/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtsensors_python.h"

// main header
#include "qtapreading_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QTapReadingWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QTapReadingWrapper::QTapReadingWrapper(::QObject * parent) : QTapReading(parent)
{
    resetPyMethodCache();
    // ... middle
}

void QTapReadingWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QTapReadingWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QTapReadingWrapper::copyValuesFrom(::QSensorReading * other)
{
    if (m_PyMethodCache[2]) {
        return this->::QTapReading::copyValuesFrom(other);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "copyValuesFrom";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QTapReading::copyValuesFrom(other);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSensorsTypes[SBK_QSENSORREADING_IDX]), other)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QTapReadingWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QTapReadingWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[4]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QTapReadingWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QTapReading.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QTapReadingWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[6])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QTapReading.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QTapReadingWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[8]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QTapReadingWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QTapReading::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QTapReadingWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QTapReading::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QTapReadingWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QTapReadingWrapper *>(this));
        return QTapReading::qt_metacast(_clname);
}

QTapReadingWrapper::~QTapReadingWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QTapReading_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QTapReading >()))
        return -1;

    ::QTapReadingWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSensors.QTapReading.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QTapReading", 1, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QTapReading::QTapReading(QObject*)
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QTapReading(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTapReading_Init_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QTapReading(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QTapReadingWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QTapReadingWrapper(cppArg0);
            }

            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QTapReading >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QTapReading_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QTapReading_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QTapReading_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QTapReadingFunc_copyValuesFrom(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTapReading *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSensorsTypes[SBK_QTAPREADING_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSensors.QTapReading.copyValuesFrom";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSensorReading::copyValuesFrom(QSensorReading*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSensorsTypes[SBK_QSENSORREADING_IDX]), (pyArg)))) {
        overloadId = 0; // copyValuesFrom(QSensorReading*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTapReadingFunc_copyValuesFrom_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QSensorReading *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // copyValuesFrom(QSensorReading*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QTapReading::copyValuesFrom(cppArg0)
                : cppSelf->copyValuesFrom(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTapReadingFunc_copyValuesFrom_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTapReadingFunc_isDoubleTap(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTapReading *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSensorsTypes[SBK_QTAPREADING_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSensors.QTapReading.isDoubleTap";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isDoubleTap()const
            bool cppResult = const_cast<const ::QTapReading *>(cppSelf)->isDoubleTap();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTapReadingFunc_setDoubleTap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTapReading *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSensorsTypes[SBK_QTAPREADING_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSensors.QTapReading.setDoubleTap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTapReading::setDoubleTap(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setDoubleTap(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTapReadingFunc_setDoubleTap_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDoubleTap(bool)
            cppSelf->setDoubleTap(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTapReadingFunc_setDoubleTap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTapReadingFunc_setTapDirection(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTapReading *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSensorsTypes[SBK_QTAPREADING_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSensors.QTapReading.setTapDirection";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTapReading::setTapDirection(QTapReading::TapDirection)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtSensorsTypes[SBK_QTAPREADING_TAPDIRECTION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setTapDirection(QTapReading::TapDirection)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTapReadingFunc_setTapDirection_TypeError;

    // Call function/method
    {
        ::QTapReading::TapDirection cppArg0{QTapReading::Undefined};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setTapDirection(QTapReading::TapDirection)
            cppSelf->setTapDirection(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTapReadingFunc_setTapDirection_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTapReadingFunc_tapDirection(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTapReading *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSensorsTypes[SBK_QTAPREADING_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSensors.QTapReading.tapDirection";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // tapDirection()const
            QTapReading::TapDirection cppResult = const_cast<const ::QTapReading *>(cppSelf)->tapDirection();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtSensorsTypes[SBK_QTAPREADING_TAPDIRECTION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QTapReading_PropertyStrings[] = {
    "doubleTap:isDoubleTap",
    "tapDirection:",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QTapReading_methods[] = {
    {"copyValuesFrom", reinterpret_cast<PyCFunction>(Sbk_QTapReadingFunc_copyValuesFrom), METH_O},
    {"isDoubleTap", reinterpret_cast<PyCFunction>(Sbk_QTapReadingFunc_isDoubleTap), METH_NOARGS},
    {"setDoubleTap", reinterpret_cast<PyCFunction>(Sbk_QTapReadingFunc_setDoubleTap), METH_O},
    {"setTapDirection", reinterpret_cast<PyCFunction>(Sbk_QTapReadingFunc_setTapDirection), METH_O},
    {"tapDirection", reinterpret_cast<PyCFunction>(Sbk_QTapReadingFunc_tapDirection), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QTapReading_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QTapReading *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSensorsTypes[SBK_QTAPREADING_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QTapReadingWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QTapReading_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QTapReading_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QTapReading_Type = nullptr;
static SbkObjectType *Sbk_QTapReading_TypeF(void)
{
    return _Sbk_QTapReading_Type;
}

static PyType_Slot Sbk_QTapReading_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QTapReading_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QTapReading_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QTapReading_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QTapReading_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QTapReading_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QTapReading_spec = {
    "2:PySide2.QtSensors.QTapReading",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QTapReading_slots
};

} //extern "C"

static void *Sbk_QTapReading_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QTapReading *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void QTapReading_TapDirection_PythonToCpp_QTapReading_TapDirection(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTapReading::TapDirection *>(cppOut) =
        static_cast<::QTapReading::TapDirection>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QTapReading_TapDirection_PythonToCpp_QTapReading_TapDirection_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtSensorsTypes[SBK_QTAPREADING_TAPDIRECTION_IDX]))
        return QTapReading_TapDirection_PythonToCpp_QTapReading_TapDirection;
    return {};
}
static PyObject *QTapReading_TapDirection_CppToPython_QTapReading_TapDirection(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QTapReading::TapDirection *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtSensorsTypes[SBK_QTAPREADING_TAPDIRECTION_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QTapReading_PythonToCpp_QTapReading_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QTapReading_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QTapReading_PythonToCpp_QTapReading_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QTapReading_TypeF())))
        return QTapReading_PythonToCpp_QTapReading_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QTapReading_PTR_CppToPython_QTapReading(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QTapReading *>(const_cast<void *>(cppIn)), Sbk_QTapReading_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QTapReading_SignatureStrings[] = {
    "PySide2.QtSensors.QTapReading(self,parent:PySide2.QtCore.QObject)",
    "PySide2.QtSensors.QTapReading.copyValuesFrom(self,other:PySide2.QtSensors.QSensorReading)",
    "PySide2.QtSensors.QTapReading.isDoubleTap(self)->bool",
    "PySide2.QtSensors.QTapReading.setDoubleTap(self,doubleTap:bool)",
    "PySide2.QtSensors.QTapReading.setTapDirection(self,tapDirection:PySide2.QtSensors.QTapReading.TapDirection)",
    "PySide2.QtSensors.QTapReading.tapDirection(self)->PySide2.QtSensors.QTapReading.TapDirection",
    nullptr}; // Sentinel

void init_QTapReading(PyObject *module)
{
    _Sbk_QTapReading_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QTapReading",
        "QTapReading*",
        &Sbk_QTapReading_spec,
        &Shiboken::callCppDestructor< ::QTapReading >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSensorsTypes[SBK_QSENSORREADING_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QTapReading_Type);
    InitSignatureStrings(pyType, QTapReading_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QTapReading_Type), Sbk_QTapReading_PropertyStrings);
    SbkPySide2_QtSensorsTypes[SBK_QTAPREADING_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QTapReading_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QTapReading_TypeF(),
        QTapReading_PythonToCpp_QTapReading_PTR,
        is_QTapReading_PythonToCpp_QTapReading_PTR_Convertible,
        QTapReading_PTR_CppToPython_QTapReading);

    Shiboken::Conversions::registerConverterName(converter, "QTapReading");
    Shiboken::Conversions::registerConverterName(converter, "QTapReading*");
    Shiboken::Conversions::registerConverterName(converter, "QTapReading&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QTapReading).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QTapReadingWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QTapReading_TypeF(), &Sbk_QTapReading_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'TapDirection'.
    SbkPySide2_QtSensorsTypes[SBK_QTAPREADING_TAPDIRECTION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QTapReading_TypeF(),
        "TapDirection",
        "2:PySide2.QtSensors.QTapReading.TapDirection",
        "QTapReading::TapDirection");
    if (!SbkPySide2_QtSensorsTypes[SBK_QTAPREADING_TAPDIRECTION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSensorsTypes[SBK_QTAPREADING_TAPDIRECTION_IDX],
        Sbk_QTapReading_TypeF(), "Undefined", (long) QTapReading::TapDirection::Undefined))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSensorsTypes[SBK_QTAPREADING_TAPDIRECTION_IDX],
        Sbk_QTapReading_TypeF(), "X", (long) QTapReading::TapDirection::X))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSensorsTypes[SBK_QTAPREADING_TAPDIRECTION_IDX],
        Sbk_QTapReading_TypeF(), "Y", (long) QTapReading::TapDirection::Y))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSensorsTypes[SBK_QTAPREADING_TAPDIRECTION_IDX],
        Sbk_QTapReading_TypeF(), "Z", (long) QTapReading::TapDirection::Z))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSensorsTypes[SBK_QTAPREADING_TAPDIRECTION_IDX],
        Sbk_QTapReading_TypeF(), "X_Pos", (long) QTapReading::TapDirection::X_Pos))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSensorsTypes[SBK_QTAPREADING_TAPDIRECTION_IDX],
        Sbk_QTapReading_TypeF(), "Y_Pos", (long) QTapReading::TapDirection::Y_Pos))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSensorsTypes[SBK_QTAPREADING_TAPDIRECTION_IDX],
        Sbk_QTapReading_TypeF(), "Z_Pos", (long) QTapReading::TapDirection::Z_Pos))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSensorsTypes[SBK_QTAPREADING_TAPDIRECTION_IDX],
        Sbk_QTapReading_TypeF(), "X_Neg", (long) QTapReading::TapDirection::X_Neg))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSensorsTypes[SBK_QTAPREADING_TAPDIRECTION_IDX],
        Sbk_QTapReading_TypeF(), "Y_Neg", (long) QTapReading::TapDirection::Y_Neg))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSensorsTypes[SBK_QTAPREADING_TAPDIRECTION_IDX],
        Sbk_QTapReading_TypeF(), "Z_Neg", (long) QTapReading::TapDirection::Z_Neg))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSensorsTypes[SBK_QTAPREADING_TAPDIRECTION_IDX],
        Sbk_QTapReading_TypeF(), "X_Both", (long) QTapReading::TapDirection::X_Both))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSensorsTypes[SBK_QTAPREADING_TAPDIRECTION_IDX],
        Sbk_QTapReading_TypeF(), "Y_Both", (long) QTapReading::TapDirection::Y_Both))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSensorsTypes[SBK_QTAPREADING_TAPDIRECTION_IDX],
        Sbk_QTapReading_TypeF(), "Z_Both", (long) QTapReading::TapDirection::Z_Both))
        return;
    // Register converter for enum 'QTapReading::TapDirection'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtSensorsTypes[SBK_QTAPREADING_TAPDIRECTION_IDX],
            QTapReading_TapDirection_CppToPython_QTapReading_TapDirection);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QTapReading_TapDirection_PythonToCpp_QTapReading_TapDirection,
            is_QTapReading_TapDirection_PythonToCpp_QTapReading_TapDirection_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtSensorsTypes[SBK_QTAPREADING_TAPDIRECTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QTapReading::TapDirection");
        Shiboken::Conversions::registerConverterName(converter, "TapDirection");
    }
    // End of 'TapDirection' enum.

    qRegisterMetaType< ::QTapReading::TapDirection >("QTapReading::TapDirection");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QTapReading_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QTapReading_TypeF(), &::QTapReading::staticMetaObject, sizeof(QTapReadingWrapper));
}
