/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#include <sbkpython.h>
#include <shiboken.h>
#include <algorithm>
#include <signature.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
#include "pyside2_qtsensors_python.h"



// Extra includes

// Current module's type array.
PyTypeObject **SbkPySide2_QtSensorsTypes = nullptr;
// Current module's PyObject pointer.
PyObject *SbkPySide2_QtSensorsModuleObject = nullptr;
// Current module's converter array.
SbkConverter **SbkPySide2_QtSensorsTypeConverters = nullptr;
void cleanTypesAttributes(void) {
    if (PY_VERSION_HEX >= 0x03000000 && PY_VERSION_HEX < 0x03060000)
        return; // PYSIDE-953: testbinding crashes in Python 3.5 when hasattr touches types!
    for (int i = 0, imax = SBK_QtSensors_IDX_COUNT; i < imax; i++) {
        PyObject *pyType = reinterpret_cast<PyObject *>(SbkPySide2_QtSensorsTypes[i]);
        Shiboken::AutoDecRef attrName(Py_BuildValue("s", "staticMetaObject"));
        if (pyType && PyObject_HasAttr(pyType, attrName))
            PyObject_SetAttr(pyType, attrName, Py_None);
    }
}
// Global functions ------------------------------------------------------------

static PyMethodDef QtSensors_methods[] = {
    {0} // Sentinel
};

// Classes initialization functions ------------------------------------------------------------
void init_qoutputrange(PyObject *module);
void init_QSensorPluginInterface(PyObject *module);
void init_QSensorManager(PyObject *module);
void init_QSensorGesturePluginInterface(PyObject *module);
void init_QSensorChangesInterface(PyObject *module);
void init_QSensorBackendFactory(PyObject *module);
void init_QSensorReading(PyObject *module);
void init_QAmbientLightReading(PyObject *module);
void init_QPressureReading(PyObject *module);
void init_QAltimeterReading(PyObject *module);
void init_QOrientationReading(PyObject *module);
void init_QAccelerometerReading(PyObject *module);
void init_QMagnetometerReading(PyObject *module);
void init_QLightReading(PyObject *module);
void init_QLidReading(PyObject *module);
void init_QTiltReading(PyObject *module);
void init_QIRProximityReading(PyObject *module);
void init_QTapReading(PyObject *module);
void init_QHumidityReading(PyObject *module);
void init_QHolsterReading(PyObject *module);
void init_QGyroscopeReading(PyObject *module);
void init_QDistanceReading(PyObject *module);
void init_QCompassReading(PyObject *module);
void init_QRotationReading(PyObject *module);
void init_QAmbientTemperatureReading(PyObject *module);
void init_QProximityReading(PyObject *module);
void init_QSensorGestureRecognizer(PyObject *module);
void init_QSensorGestureManager(PyObject *module);
void init_QSensorBackend(PyObject *module);
void init_QSensor(PyObject *module);
void init_QPressureSensor(PyObject *module);
void init_QPressureSensorStaticFields();
void init_QOrientationSensor(PyObject *module);
void init_QOrientationSensorStaticFields();
void init_QAltimeter(PyObject *module);
void init_QAltimeterStaticFields();
void init_QAccelerometer(PyObject *module);
void init_QAccelerometerStaticFields();
void init_QMagnetometer(PyObject *module);
void init_QMagnetometerStaticFields();
void init_QLightSensor(PyObject *module);
void init_QLightSensorStaticFields();
void init_QLidSensor(PyObject *module);
void init_QLidSensorStaticFields();
void init_QTiltSensor(PyObject *module);
void init_QTiltSensorStaticFields();
void init_QIRProximitySensor(PyObject *module);
void init_QIRProximitySensorStaticFields();
void init_QTapSensor(PyObject *module);
void init_QTapSensorStaticFields();
void init_QHumiditySensor(PyObject *module);
void init_QHumiditySensorStaticFields();
void init_QHolsterSensor(PyObject *module);
void init_QHolsterSensorStaticFields();
void init_QSensorFilter(PyObject *module);
void init_QAmbientLightFilter(PyObject *module);
void init_QPressureFilter(PyObject *module);
void init_QAltimeterFilter(PyObject *module);
void init_QOrientationFilter(PyObject *module);
void init_QAccelerometerFilter(PyObject *module);
void init_QMagnetometerFilter(PyObject *module);
void init_QLightFilter(PyObject *module);
void init_QLidFilter(PyObject *module);
void init_QTiltFilter(PyObject *module);
void init_QIRProximityFilter(PyObject *module);
void init_QTapFilter(PyObject *module);
void init_QHumidityFilter(PyObject *module);
void init_QHolsterFilter(PyObject *module);
void init_QGyroscopeFilter(PyObject *module);
void init_QDistanceFilter(PyObject *module);
void init_QCompassFilter(PyObject *module);
void init_QRotationFilter(PyObject *module);
void init_QAmbientTemperatureFilter(PyObject *module);
void init_QProximityFilter(PyObject *module);
void init_QGyroscope(PyObject *module);
void init_QGyroscopeStaticFields();
void init_QDistanceSensor(PyObject *module);
void init_QDistanceSensorStaticFields();
void init_QRotationSensor(PyObject *module);
void init_QRotationSensorStaticFields();
void init_QCompass(PyObject *module);
void init_QCompassStaticFields();
void init_QAmbientTemperatureSensor(PyObject *module);
void init_QAmbientTemperatureSensorStaticFields();
void init_QProximitySensor(PyObject *module);
void init_QProximitySensorStaticFields();
void init_QAmbientLightSensor(PyObject *module);
void init_QAmbientLightSensorStaticFields();

// Required modules' type and converter arrays.
PyTypeObject **SbkPySide2_QtCoreTypes;
SbkConverter **SbkPySide2_QtCoreTypeConverters;

// Module initialization ------------------------------------------------------------
// Container Type converters.

// C++ to Python conversion for type 'QPair<int,int >'.
static PyObject *_QPair_int_int__CppToPython__QPair_int_int_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QPair<int,int > *>(const_cast<void *>(cppIn));
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (return-qpair)]
    PyObject *pyOut = PyTuple_New(2);
    PyTuple_SET_ITEM(pyOut, 0, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppInRef.first));
    PyTuple_SET_ITEM(pyOut, 1, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppInRef.second));
    return pyOut;
    // END of custom code block [file: ../glue/qtcore.cpp (return-qpair)]
    // ========================================================================

}
static void _QPair_int_int__PythonToCpp__QPair_int_int_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QPair<int,int > *>(cppOut);
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (conversion-qpair-pysequence)]
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<int>(), PySequence_Fast_GET_ITEM(pyIn, 0), &(cppOutRef.first));
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<int>(), PySequence_Fast_GET_ITEM(pyIn, 1), &(cppOutRef.second));
    // END of custom code block [file: ../glue/qtcore.cpp (conversion-qpair-pysequence)]
    // ========================================================================

}
static PythonToCppFunc is__QPair_int_int__PythonToCpp__QPair_int_int__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertiblePairTypes(Shiboken::Conversions::PrimitiveTypeConverter<int>(), false, Shiboken::Conversions::PrimitiveTypeConverter<int>(), false, pyIn))
        return _QPair_int_int__PythonToCpp__QPair_int_int_;
    return {};
}

// C++ to Python conversion for type 'QList<QPair< int,int > >'.
static PyObject *_QList_QPair_int_int___CppToPython__QList_QPair_int_int__(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QPair< int,int > > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QPair< int,int > >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QPair<int,int > cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(SbkPySide2_QtSensorsTypeConverters[SBK_QTSENSORS_QPAIR_INT_INT_IDX], &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QPair_int_int___PythonToCpp__QList_QPair_int_int__(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QPair< int,int > > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QPair<int,int > cppItem;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtSensorsTypeConverters[SBK_QTSENSORS_QPAIR_INT_INT_IDX], pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QPair_int_int___PythonToCpp__QList_QPair_int_int___Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(SbkPySide2_QtSensorsTypeConverters[SBK_QTSENSORS_QPAIR_INT_INT_IDX], pyIn))
        return _QList_QPair_int_int___PythonToCpp__QList_QPair_int_int__;
    return {};
}

// C++ to Python conversion for type 'QList<QSensorFilter* >'.
static PyObject *_QList_QSensorFilterPTR__CppToPython__QList_QSensorFilterPTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QSensorFilter* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QSensorFilter* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QSensorFilter* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSensorsTypes[SBK_QSENSORFILTER_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QSensorFilterPTR__PythonToCpp__QList_QSensorFilterPTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QSensorFilter* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QSensorFilter* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSensorsTypes[SBK_QSENSORFILTER_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QSensorFilterPTR__PythonToCpp__QList_QSensorFilterPTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtSensorsTypes[SBK_QSENSORFILTER_IDX], pyIn))
        return _QList_QSensorFilterPTR__PythonToCpp__QList_QSensorFilterPTR_;
    return {};
}

// C++ to Python conversion for type 'QList<qoutputrange >'.
static PyObject *_QList_qoutputrange__CppToPython__QList_qoutputrange_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<qoutputrange > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<qoutputrange >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::qoutputrange cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSensorsTypes[SBK_QOUTPUTRANGE_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_qoutputrange__PythonToCpp__QList_qoutputrange_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<qoutputrange > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::qoutputrange cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSensorsTypes[SBK_QOUTPUTRANGE_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_qoutputrange__PythonToCpp__QList_qoutputrange__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSensorsTypes[SBK_QOUTPUTRANGE_IDX]), pyIn))
        return _QList_qoutputrange__PythonToCpp__QList_qoutputrange_;
    return {};
}

// C++ to Python conversion for type 'QList<QByteArray >'.
static PyObject *_QList_QByteArray__CppToPython__QList_QByteArray_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QByteArray > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QByteArray >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QByteArray cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QByteArray__PythonToCpp__QList_QByteArray_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QByteArray > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QByteArray cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QByteArray__PythonToCpp__QList_QByteArray__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pyIn))
        return _QList_QByteArray__PythonToCpp__QList_QByteArray_;
    return {};
}

// C++ to Python conversion for type 'const QList<QObject* > &'.
static PyObject *_constQList_QObjectPTR_REF_CppToPython__constQList_QObjectPTR_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QObject* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QObject* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QObject* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QObject* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QObject* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX], pyIn))
        return _constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF;
    return {};
}

// C++ to Python conversion for type 'QList<QSensorGestureRecognizer* >'.
static PyObject *_QList_QSensorGestureRecognizerPTR__CppToPython__QList_QSensorGestureRecognizerPTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QSensorGestureRecognizer* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QSensorGestureRecognizer* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QSensorGestureRecognizer* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSensorsTypes[SBK_QSENSORGESTURERECOGNIZER_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QSensorGestureRecognizerPTR__PythonToCpp__QList_QSensorGestureRecognizerPTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QSensorGestureRecognizer* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QSensorGestureRecognizer* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSensorsTypes[SBK_QSENSORGESTURERECOGNIZER_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QSensorGestureRecognizerPTR__PythonToCpp__QList_QSensorGestureRecognizerPTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtSensorsTypes[SBK_QSENSORGESTURERECOGNIZER_IDX], pyIn))
        return _QList_QSensorGestureRecognizerPTR__PythonToCpp__QList_QSensorGestureRecognizerPTR_;
    return {};
}

// C++ to Python conversion for type 'QList<QVariant >'.
static PyObject *_QList_QVariant__CppToPython__QList_QVariant_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QVariant > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QVariant >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QVariant cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QVariant__PythonToCpp__QList_QVariant_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QVariant > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QVariant cppItem;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QVariant__PythonToCpp__QList_QVariant__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], pyIn))
        return _QList_QVariant__PythonToCpp__QList_QVariant_;
    return {};
}

// C++ to Python conversion for type 'QList<QString >'.
static PyObject *_QList_QString__CppToPython__QList_QString_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QString > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QString >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QString cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QString__PythonToCpp__QList_QString_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QString > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QString cppItem;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QString__PythonToCpp__QList_QString__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyIn))
        return _QList_QString__PythonToCpp__QList_QString_;
    return {};
}

// C++ to Python conversion for type 'QMap<QString,QVariant >'.
static PyObject *_QMap_QString_QVariant__CppToPython__QMap_QString_QVariant_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QMap<QString,QVariant > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppmap_to_pymap_conversion - START
    PyObject *pyOut = PyDict_New();
    for (::QMap<QString,QVariant >::const_iterator it = cppInRef.begin(), end = cppInRef.end(); it != end; ++it) {
        ::QString key = it.key();
        ::QVariant value = it.value();
        PyObject *pyKey = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &key);
        PyObject *pyValue = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &value);
        PyDict_SetItem(pyOut, pyKey, pyValue);
        Py_DECREF(pyKey);
        Py_DECREF(pyValue);
    }
    return pyOut;
    // TEMPLATE - cppmap_to_pymap_conversion - END

}
static void _QMap_QString_QVariant__PythonToCpp__QMap_QString_QVariant_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QMap<QString,QVariant > *>(cppOut);
    // TEMPLATE - pydict_to_cppmap_conversion - START
    PyObject *key;
    PyObject *value;
    Py_ssize_t pos = 0;
    while (PyDict_Next(pyIn, &pos, &key, &value)) {
        ::QString cppKey;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], key, &(cppKey));
        ::QVariant cppValue;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], value, &(cppValue));
        cppOutRef.insert(cppKey, cppValue);
    }
    // TEMPLATE - pydict_to_cppmap_conversion - END

}
static PythonToCppFunc is__QMap_QString_QVariant__PythonToCpp__QMap_QString_QVariant__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleDictTypes(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], false, SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], false, pyIn))
        return _QMap_QString_QVariant__PythonToCpp__QMap_QString_QVariant_;
    return {};
}


#ifdef IS_PY3K
static struct PyModuleDef moduledef = {
    /* m_base     */ PyModuleDef_HEAD_INIT,
    /* m_name     */ "QtSensors",
    /* m_doc      */ nullptr,
    /* m_size     */ -1,
    /* m_methods  */ QtSensors_methods,
    /* m_reload   */ nullptr,
    /* m_traverse */ nullptr,
    /* m_clear    */ nullptr,
    /* m_free     */ nullptr
};

#endif

// The signatures string for the global functions.
// Multiple signatures have their index "n:" in front.
static const char *QtSensors_SignatureStrings[] = {
    nullptr}; // Sentinel

SBK_MODULE_INIT_FUNCTION_BEGIN(QtSensors)
    {
        Shiboken::AutoDecRef requiredModule(Shiboken::Module::import("PySide2.QtCore"));
        if (requiredModule.isNull())
            return SBK_MODULE_INIT_ERROR;
        SbkPySide2_QtCoreTypes = Shiboken::Module::getTypes(requiredModule);
        SbkPySide2_QtCoreTypeConverters = Shiboken::Module::getTypeConverters(requiredModule);
    }

    // Create an array of wrapper types for the current module.
    static PyTypeObject *cppApi[SBK_QtSensors_IDX_COUNT];
    SbkPySide2_QtSensorsTypes = cppApi;

    // Create an array of primitive type converters for the current module.
    static SbkConverter *sbkConverters[SBK_QtSensors_CONVERTERS_IDX_COUNT];
    SbkPySide2_QtSensorsTypeConverters = sbkConverters;

#ifdef IS_PY3K
    PyObject *module = Shiboken::Module::create("QtSensors", &moduledef);
#else
    PyObject *module = Shiboken::Module::create("QtSensors", QtSensors_methods);
#endif

    // Make module available from global scope
    SbkPySide2_QtSensorsModuleObject = module;

    // Initialize classes in the type system
    init_qoutputrange(module);
    init_QSensorPluginInterface(module);
    init_QSensorManager(module);
    init_QSensorGesturePluginInterface(module);
    init_QSensorChangesInterface(module);
    init_QSensorBackendFactory(module);
    init_QSensorReading(module);
    init_QAmbientLightReading(module);
    init_QPressureReading(module);
    init_QAltimeterReading(module);
    init_QOrientationReading(module);
    init_QAccelerometerReading(module);
    init_QMagnetometerReading(module);
    init_QLightReading(module);
    init_QLidReading(module);
    init_QTiltReading(module);
    init_QIRProximityReading(module);
    init_QTapReading(module);
    init_QHumidityReading(module);
    init_QHolsterReading(module);
    init_QGyroscopeReading(module);
    init_QDistanceReading(module);
    init_QCompassReading(module);
    init_QRotationReading(module);
    init_QAmbientTemperatureReading(module);
    init_QProximityReading(module);
    init_QSensorGestureRecognizer(module);
    init_QSensorGestureManager(module);
    init_QSensorBackend(module);
    init_QSensor(module);
    init_QPressureSensor(module);
    init_QOrientationSensor(module);
    init_QAltimeter(module);
    init_QAccelerometer(module);
    init_QMagnetometer(module);
    init_QLightSensor(module);
    init_QLidSensor(module);
    init_QTiltSensor(module);
    init_QIRProximitySensor(module);
    init_QTapSensor(module);
    init_QHumiditySensor(module);
    init_QHolsterSensor(module);
    init_QSensorFilter(module);
    init_QAmbientLightFilter(module);
    init_QPressureFilter(module);
    init_QAltimeterFilter(module);
    init_QOrientationFilter(module);
    init_QAccelerometerFilter(module);
    init_QMagnetometerFilter(module);
    init_QLightFilter(module);
    init_QLidFilter(module);
    init_QTiltFilter(module);
    init_QIRProximityFilter(module);
    init_QTapFilter(module);
    init_QHumidityFilter(module);
    init_QHolsterFilter(module);
    init_QGyroscopeFilter(module);
    init_QDistanceFilter(module);
    init_QCompassFilter(module);
    init_QRotationFilter(module);
    init_QAmbientTemperatureFilter(module);
    init_QProximityFilter(module);
    init_QGyroscope(module);
    init_QDistanceSensor(module);
    init_QRotationSensor(module);
    init_QCompass(module);
    init_QAmbientTemperatureSensor(module);
    init_QProximitySensor(module);
    init_QAmbientLightSensor(module);

    // Register converter for type 'QPair<int,int>'.
    SbkPySide2_QtSensorsTypeConverters[SBK_QTSENSORS_QPAIR_INT_INT_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QPair_int_int__CppToPython__QPair_int_int_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtSensorsTypeConverters[SBK_QTSENSORS_QPAIR_INT_INT_IDX], "QPair<int,int>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtSensorsTypeConverters[SBK_QTSENSORS_QPAIR_INT_INT_IDX],
        _QPair_int_int__PythonToCpp__QPair_int_int_,
        is__QPair_int_int__PythonToCpp__QPair_int_int__Convertible);

    // Register converter for type 'QList<QPair<int,int>>'.
    SbkPySide2_QtSensorsTypeConverters[SBK_QTSENSORS_QLIST_QPAIR_INT_INT_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QPair_int_int___CppToPython__QList_QPair_int_int__);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtSensorsTypeConverters[SBK_QTSENSORS_QLIST_QPAIR_INT_INT_IDX], "QList<QPair<int,int>>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtSensorsTypeConverters[SBK_QTSENSORS_QLIST_QPAIR_INT_INT_IDX],
        _QList_QPair_int_int___PythonToCpp__QList_QPair_int_int__,
        is__QList_QPair_int_int___PythonToCpp__QList_QPair_int_int___Convertible);

    // Register converter for type 'QList<QSensorFilter*>'.
    SbkPySide2_QtSensorsTypeConverters[SBK_QTSENSORS_QLIST_QSENSORFILTERPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QSensorFilterPTR__CppToPython__QList_QSensorFilterPTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtSensorsTypeConverters[SBK_QTSENSORS_QLIST_QSENSORFILTERPTR_IDX], "QList<QSensorFilter*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtSensorsTypeConverters[SBK_QTSENSORS_QLIST_QSENSORFILTERPTR_IDX],
        _QList_QSensorFilterPTR__PythonToCpp__QList_QSensorFilterPTR_,
        is__QList_QSensorFilterPTR__PythonToCpp__QList_QSensorFilterPTR__Convertible);

    // Register converter for type 'QList<qoutputrange>'.
    SbkPySide2_QtSensorsTypeConverters[SBK_QTSENSORS_QLIST_QOUTPUTRANGE_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_qoutputrange__CppToPython__QList_qoutputrange_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtSensorsTypeConverters[SBK_QTSENSORS_QLIST_QOUTPUTRANGE_IDX], "QList<qoutputrange>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtSensorsTypeConverters[SBK_QTSENSORS_QLIST_QOUTPUTRANGE_IDX],
        _QList_qoutputrange__PythonToCpp__QList_qoutputrange_,
        is__QList_qoutputrange__PythonToCpp__QList_qoutputrange__Convertible);

    // Register converter for type 'QList<QByteArray>'.
    SbkPySide2_QtSensorsTypeConverters[SBK_QTSENSORS_QLIST_QBYTEARRAY_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QByteArray__CppToPython__QList_QByteArray_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtSensorsTypeConverters[SBK_QTSENSORS_QLIST_QBYTEARRAY_IDX], "QList<QByteArray>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtSensorsTypeConverters[SBK_QTSENSORS_QLIST_QBYTEARRAY_IDX],
        _QList_QByteArray__PythonToCpp__QList_QByteArray_,
        is__QList_QByteArray__PythonToCpp__QList_QByteArray__Convertible);

    // Register converter for type 'const QList<QObject*>&'.
    SbkPySide2_QtSensorsTypeConverters[SBK_QTSENSORS_QLIST_QOBJECTPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQList_QObjectPTR_REF_CppToPython__constQList_QObjectPTR_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtSensorsTypeConverters[SBK_QTSENSORS_QLIST_QOBJECTPTR_IDX], "const QList<QObject*>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtSensorsTypeConverters[SBK_QTSENSORS_QLIST_QOBJECTPTR_IDX], "QList<QObject*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtSensorsTypeConverters[SBK_QTSENSORS_QLIST_QOBJECTPTR_IDX],
        _constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF,
        is__constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF_Convertible);

    // Register converter for type 'QList<QSensorGestureRecognizer*>'.
    SbkPySide2_QtSensorsTypeConverters[SBK_QTSENSORS_QLIST_QSENSORGESTURERECOGNIZERPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QSensorGestureRecognizerPTR__CppToPython__QList_QSensorGestureRecognizerPTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtSensorsTypeConverters[SBK_QTSENSORS_QLIST_QSENSORGESTURERECOGNIZERPTR_IDX], "QList<QSensorGestureRecognizer*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtSensorsTypeConverters[SBK_QTSENSORS_QLIST_QSENSORGESTURERECOGNIZERPTR_IDX],
        _QList_QSensorGestureRecognizerPTR__PythonToCpp__QList_QSensorGestureRecognizerPTR_,
        is__QList_QSensorGestureRecognizerPTR__PythonToCpp__QList_QSensorGestureRecognizerPTR__Convertible);

    // Register converter for type 'QList<QVariant>'.
    SbkPySide2_QtSensorsTypeConverters[SBK_QTSENSORS_QLIST_QVARIANT_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QVariant__CppToPython__QList_QVariant_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtSensorsTypeConverters[SBK_QTSENSORS_QLIST_QVARIANT_IDX], "QList<QVariant>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtSensorsTypeConverters[SBK_QTSENSORS_QLIST_QVARIANT_IDX],
        _QList_QVariant__PythonToCpp__QList_QVariant_,
        is__QList_QVariant__PythonToCpp__QList_QVariant__Convertible);

    // Register converter for type 'QList<QString>'.
    SbkPySide2_QtSensorsTypeConverters[SBK_QTSENSORS_QLIST_QSTRING_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QString__CppToPython__QList_QString_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtSensorsTypeConverters[SBK_QTSENSORS_QLIST_QSTRING_IDX], "QList<QString>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtSensorsTypeConverters[SBK_QTSENSORS_QLIST_QSTRING_IDX],
        _QList_QString__PythonToCpp__QList_QString_,
        is__QList_QString__PythonToCpp__QList_QString__Convertible);

    // Register converter for type 'QMap<QString,QVariant>'.
    SbkPySide2_QtSensorsTypeConverters[SBK_QTSENSORS_QMAP_QSTRING_QVARIANT_IDX] = Shiboken::Conversions::createConverter(&PyDict_Type, _QMap_QString_QVariant__CppToPython__QMap_QString_QVariant_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtSensorsTypeConverters[SBK_QTSENSORS_QMAP_QSTRING_QVARIANT_IDX], "QMap<QString,QVariant>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtSensorsTypeConverters[SBK_QTSENSORS_QMAP_QSTRING_QVARIANT_IDX],
        _QMap_QString_QVariant__PythonToCpp__QMap_QString_QVariant_,
        is__QMap_QString_QVariant__PythonToCpp__QMap_QString_QVariant__Convertible);

    // Register primitive types converters.

    Shiboken::Module::registerTypes(module, SbkPySide2_QtSensorsTypes);
    Shiboken::Module::registerTypeConverters(module, SbkPySide2_QtSensorsTypeConverters);

// Static field initialization
init_QPressureSensorStaticFields();
init_QOrientationSensorStaticFields();
init_QAltimeterStaticFields();
init_QAccelerometerStaticFields();
init_QMagnetometerStaticFields();
init_QLightSensorStaticFields();
init_QLidSensorStaticFields();
init_QTiltSensorStaticFields();
init_QIRProximitySensorStaticFields();
init_QTapSensorStaticFields();
init_QHumiditySensorStaticFields();
init_QHolsterSensorStaticFields();
init_QGyroscopeStaticFields();
init_QDistanceSensorStaticFields();
init_QRotationSensorStaticFields();
init_QCompassStaticFields();
init_QAmbientTemperatureSensorStaticFields();
init_QProximitySensorStaticFields();
init_QAmbientLightSensorStaticFields();

    if (PyErr_Occurred()) {
        PyErr_Print();
        Py_FatalError("can't initialize module QtSensors");
    }
    PySide::registerCleanupFunction(cleanTypesAttributes);

    FinishSignatureInitialization(module, QtSensors_SignatureStrings);

SBK_MODULE_INIT_FUNCTION_END
