/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtserialport_python.h"

// main header
#include "qserialport_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QSerialPortWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QSerialPortWrapper::QSerialPortWrapper(::QObject * parent) : QSerialPort(parent)
{
    resetPyMethodCache();
    // ... middle
}

QSerialPortWrapper::QSerialPortWrapper(const ::QSerialPortInfo & info, ::QObject * parent) : QSerialPort(info, parent)
{
    resetPyMethodCache();
    // ... middle
}

QSerialPortWrapper::QSerialPortWrapper(const ::QString & name, ::QObject * parent) : QSerialPort(name, parent)
{
    resetPyMethodCache();
    // ... middle
}

bool QSerialPortWrapper::atEnd() const
{
    if (m_PyMethodCache[0])
        return this->::QSerialPort::atEnd();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "atEnd";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QSerialPort::atEnd();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSerialPort.atEnd", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

qint64 QSerialPortWrapper::bytesAvailable() const
{
    if (m_PyMethodCache[1])
        return this->::QSerialPort::bytesAvailable();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "bytesAvailable";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QSerialPort::bytesAvailable();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSerialPort.bytesAvailable", "qint64", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    qint64 cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

qint64 QSerialPortWrapper::bytesToWrite() const
{
    if (m_PyMethodCache[2])
        return this->::QSerialPort::bytesToWrite();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "bytesToWrite";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QSerialPort::bytesToWrite();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSerialPort.bytesToWrite", "qint64", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    qint64 cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QSerialPortWrapper::canReadLine() const
{
    if (m_PyMethodCache[3])
        return this->::QSerialPort::canReadLine();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "canReadLine";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QSerialPort::canReadLine();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSerialPort.canReadLine", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QSerialPortWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[4]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QSerialPortWrapper::close()
{
    if (m_PyMethodCache[5]) {
        return this->::QSerialPort::close();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "close";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QSerialPort::close();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QSerialPortWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[6]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QSerialPortWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QSerialPortWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[8]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QSerialPortWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[9])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[9] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSerialPort.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QSerialPortWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[10])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[10] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSerialPort.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

bool QSerialPortWrapper::isSequential() const
{
    if (m_PyMethodCache[11])
        return this->::QSerialPort::isSequential();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "isSequential";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[11] = true;
        return this->::QSerialPort::isSequential();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSerialPort.isSequential", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QSerialPortWrapper::open(::QFlags<QIODevice::OpenModeFlag> mode)
{
    if (m_PyMethodCache[13])
        return this->::QSerialPort::open(mode);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "open";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[13] = true;
        return this->::QSerialPort::open(mode);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QIODEVICE_OPENMODEFLAG_IDX])->converter, &mode)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSerialPort.open", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

qint64 QSerialPortWrapper::pos() const
{
    if (m_PyMethodCache[14])
        return this->::QIODevice::pos();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "pos";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[14] = true;
        return this->::QIODevice::pos();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSerialPort.pos", "qint64", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    qint64 cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

qint64 QSerialPortWrapper::readData(char * data, qint64 maxSize)
{
    if (m_PyMethodCache[15]) {
        return this->::QSerialPort::readData(data, maxSize);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "readData";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[15] = true;
        return this->::QSerialPort::readData(data, maxSize);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(L)",
    maxSize
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }

    // Begin code injection
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (return-readData)]
    qint64 cppResult = 0;
    if (PyBytes_Check(pyResult)) {
        cppResult = PyBytes_GET_SIZE((PyObject *)pyResult);
        memcpy(data, PyBytes_AS_STRING((PyObject *)pyResult), cppResult);
    } else if (Shiboken::String::check(pyResult)) {
        cppResult = Shiboken::String::len((PyObject *)pyResult);
        memcpy(data, Shiboken::String::toCString((PyObject *)pyResult), cppResult);
    }
    // END of custom code block [file: ../glue/qtcore.cpp (return-readData)]
    // ========================================================================

    // End of code injection

    return cppResult;
}

qint64 QSerialPortWrapper::readLineData(char * data, qint64 maxSize)
{
    if (m_PyMethodCache[16]) {
        return this->::QSerialPort::readLineData(data, maxSize);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "readLineData";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[16] = true;
        return this->::QSerialPort::readLineData(data, maxSize);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(L)",
    maxSize
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }

    // Begin code injection
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (return-readData)]
    qint64 cppResult = 0;
    if (PyBytes_Check(pyResult)) {
        cppResult = PyBytes_GET_SIZE((PyObject *)pyResult);
        memcpy(data, PyBytes_AS_STRING((PyObject *)pyResult), cppResult);
    } else if (Shiboken::String::check(pyResult)) {
        cppResult = Shiboken::String::len((PyObject *)pyResult);
        memcpy(data, Shiboken::String::toCString((PyObject *)pyResult), cppResult);
    }
    // END of custom code block [file: ../glue/qtcore.cpp (return-readData)]
    // ========================================================================

    // End of code injection

    return cppResult;
}

bool QSerialPortWrapper::reset()
{
    if (m_PyMethodCache[17])
        return this->::QIODevice::reset();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "reset";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[17] = true;
        return this->::QIODevice::reset();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSerialPort.reset", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QSerialPortWrapper::seek(qint64 pos)
{
    if (m_PyMethodCache[18])
        return this->::QIODevice::seek(pos);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "seek";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[18] = true;
        return this->::QIODevice::seek(pos);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(L)",
    pos
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSerialPort.seek", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

qint64 QSerialPortWrapper::size() const
{
    if (m_PyMethodCache[19])
        return this->::QIODevice::size();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "size";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[19] = true;
        return this->::QIODevice::size();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSerialPort.size", "qint64", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    qint64 cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QSerialPortWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[20]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[20] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

bool QSerialPortWrapper::waitForBytesWritten(int msecs)
{
    if (m_PyMethodCache[21])
        return this->::QSerialPort::waitForBytesWritten(msecs);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "waitForBytesWritten";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[21] = true;
        return this->::QSerialPort::waitForBytesWritten(msecs);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(i)",
    msecs
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSerialPort.waitForBytesWritten", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QSerialPortWrapper::waitForReadyRead(int msecs)
{
    if (m_PyMethodCache[22])
        return this->::QSerialPort::waitForReadyRead(msecs);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "waitForReadyRead";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[22] = true;
        return this->::QSerialPort::waitForReadyRead(msecs);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(i)",
    msecs
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSerialPort.waitForReadyRead", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

qint64 QSerialPortWrapper::writeData(const char * data, qint64 maxSize)
{
    if (m_PyMethodCache[23])
        return this->::QSerialPort::writeData(data, maxSize);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "writeData";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[23] = true;
        return this->::QSerialPort::writeData(data, maxSize);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NL)",
    Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), data),
    maxSize
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSerialPort.writeData", "qint64", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    qint64 cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

const QMetaObject *QSerialPortWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QSerialPort::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QSerialPortWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QSerialPort::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QSerialPortWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QSerialPortWrapper *>(this));
        return QSerialPort::qt_metacast(_clname);
}

QSerialPortWrapper::~QSerialPortWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QSerialPort_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QSerialPort >()))
        return -1;

    ::QSerialPortWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSerialPort.QSerialPort.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|OO:QSerialPort", &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QSerialPort::QSerialPort(QObject*)
    // 1: QSerialPort::QSerialPort(QSerialPortInfo,QObject*)
    // 2: QSerialPort::QSerialPort(QString,QObject*)
    if (numArgs == 0) {
        overloadId = 0; // QSerialPort(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORTINFO_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // QSerialPort(QSerialPortInfo,QObject*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1])))) {
            overloadId = 1; // QSerialPort(QSerialPortInfo,QObject*)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QSerialPort(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 2; // QSerialPort(QString,QObject*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1])))) {
            overloadId = 2; // QSerialPort(QString,QObject*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSerialPort_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QSerialPort(QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[0]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QSerialPort_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                            goto Sbk_QSerialPort_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QObject *cppArg0 = nullptr;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QSerialPort(QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QSerialPortWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QSerialPortWrapper(cppArg0);
                }

                Shiboken::Object::setParent(pyArgs[0], self);
            }
            break;
        }
        case 1: // QSerialPort(const QSerialPortInfo & info, QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[1]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QSerialPort_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1]))))
                            goto Sbk_QSerialPort_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QSerialPortInfo cppArg0_local;
            ::QSerialPortInfo *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORTINFO_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QObject *cppArg1 = nullptr;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QSerialPort(QSerialPortInfo,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QSerialPortWrapper(*cppArg0, cppArg1);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QSerialPortWrapper(*cppArg0, cppArg1);
                }

                Shiboken::Object::setParent(pyArgs[1], self);
            }
            break;
        }
        case 2: // QSerialPort(const QString & name, QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[1]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QSerialPort_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1]))))
                            goto Sbk_QSerialPort_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QObject *cppArg1 = nullptr;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QSerialPort(QString,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QSerialPortWrapper(cppArg0, cppArg1);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QSerialPortWrapper(cppArg0, cppArg1);
                }

                Shiboken::Object::setParent(pyArgs[1], self);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QSerialPort >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QSerialPort_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QSerialPort_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QSerialPort_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QSerialPortFunc_atEnd(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSerialPort *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSerialPort.QSerialPort.atEnd";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // atEnd()const
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QSerialPort *>(cppSelf)->::QSerialPort::atEnd()
                : const_cast<const ::QSerialPort *>(cppSelf)->atEnd();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSerialPortFunc_baudRate(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSerialPort *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSerialPort.QSerialPort.baudRate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QSerialPortFunc_baudRate_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:baudRate", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QSerialPort::baudRate(QFlags<QSerialPort::Direction>)const
    if (numArgs == 0) {
        overloadId = 0; // baudRate(QFlags<QSerialPort::Direction>)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtSerialPortTypes[SBK_QFLAGS_QSERIALPORT_DIRECTION_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // baudRate(QFlags<QSerialPort::Direction>)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSerialPortFunc_baudRate_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_directions = Shiboken::String::createStaticString("directions");
            if (PyDict_Contains(kwds, key_directions)) {
                value = PyDict_GetItem(kwds, key_directions);
                if (value && pyArgs[0]) {
                    errInfo = key_directions;
                    Py_INCREF(errInfo);
                    goto Sbk_QSerialPortFunc_baudRate_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtSerialPortTypes[SBK_QFLAGS_QSERIALPORT_DIRECTION_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_QSerialPortFunc_baudRate_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_directions);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QSerialPortFunc_baudRate_TypeError;
            }
        }
        ::QFlags<QSerialPort::Direction> cppArg0 = QSerialPort::AllDirections;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // baudRate(QFlags<QSerialPort::Direction>)const
            qint32 cppResult = const_cast<const ::QSerialPort *>(cppSelf)->baudRate(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint32>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSerialPortFunc_baudRate_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSerialPortFunc_bytesAvailable(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSerialPort *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSerialPort.QSerialPort.bytesAvailable";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // bytesAvailable()const
            qint64 cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QSerialPort *>(cppSelf)->::QSerialPort::bytesAvailable()
                : const_cast<const ::QSerialPort *>(cppSelf)->bytesAvailable();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSerialPortFunc_bytesToWrite(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSerialPort *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSerialPort.QSerialPort.bytesToWrite";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // bytesToWrite()const
            qint64 cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QSerialPort *>(cppSelf)->::QSerialPort::bytesToWrite()
                : const_cast<const ::QSerialPort *>(cppSelf)->bytesToWrite();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSerialPortFunc_canReadLine(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSerialPort *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSerialPort.QSerialPort.canReadLine";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // canReadLine()const
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QSerialPort *>(cppSelf)->::QSerialPort::canReadLine()
                : const_cast<const ::QSerialPort *>(cppSelf)->canReadLine();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSerialPortFunc_clear(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSerialPort *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSerialPort.QSerialPort.clear";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QSerialPortFunc_clear_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:clear", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QSerialPort::clear(QFlags<QSerialPort::Direction>)
    if (numArgs == 0) {
        overloadId = 0; // clear(QFlags<QSerialPort::Direction>)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtSerialPortTypes[SBK_QFLAGS_QSERIALPORT_DIRECTION_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // clear(QFlags<QSerialPort::Direction>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSerialPortFunc_clear_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_directions = Shiboken::String::createStaticString("directions");
            if (PyDict_Contains(kwds, key_directions)) {
                value = PyDict_GetItem(kwds, key_directions);
                if (value && pyArgs[0]) {
                    errInfo = key_directions;
                    Py_INCREF(errInfo);
                    goto Sbk_QSerialPortFunc_clear_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtSerialPortTypes[SBK_QFLAGS_QSERIALPORT_DIRECTION_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_QSerialPortFunc_clear_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_directions);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QSerialPortFunc_clear_TypeError;
            }
        }
        ::QFlags<QSerialPort::Direction> cppArg0 = QSerialPort::AllDirections;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // clear(QFlags<QSerialPort::Direction>)
            bool cppResult = cppSelf->clear(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSerialPortFunc_clear_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSerialPortFunc_clearError(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSerialPort *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSerialPort.QSerialPort.clearError";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clearError()
            cppSelf->clearError();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QSerialPortFunc_close(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSerialPort *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSerialPort.QSerialPort.close";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // close()
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QSerialPort::close()
                : cppSelf->close();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QSerialPortFunc_dataBits(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSerialPort *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSerialPort.QSerialPort.dataBits";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // dataBits()const
            QSerialPort::DataBits cppResult = const_cast<const ::QSerialPort *>(cppSelf)->dataBits();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_DATABITS_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSerialPortFunc_dataErrorPolicy(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSerialPort *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSerialPort.QSerialPort.dataErrorPolicy";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // dataErrorPolicy()const
            QSerialPort::DataErrorPolicy cppResult = const_cast<const ::QSerialPort *>(cppSelf)->dataErrorPolicy();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_DATAERRORPOLICY_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSerialPortFunc_error(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSerialPort *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSerialPort.QSerialPort.error";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // error()const
            QSerialPort::SerialPortError cppResult = const_cast<const ::QSerialPort *>(cppSelf)->error();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_SERIALPORTERROR_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSerialPortFunc_flowControl(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSerialPort *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSerialPort.QSerialPort.flowControl";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // flowControl()const
            QSerialPort::FlowControl cppResult = const_cast<const ::QSerialPort *>(cppSelf)->flowControl();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_FLOWCONTROL_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSerialPortFunc_flush(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSerialPort *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSerialPort.QSerialPort.flush";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // flush()
            bool cppResult = cppSelf->flush();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSerialPortFunc_handle(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSerialPort *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSerialPort.QSerialPort.handle";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // handle()const
            int cppResult = const_cast<const ::QSerialPort *>(cppSelf)->handle();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSerialPortFunc_isBreakEnabled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSerialPort *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSerialPort.QSerialPort.isBreakEnabled";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isBreakEnabled()const
            bool cppResult = const_cast<const ::QSerialPort *>(cppSelf)->isBreakEnabled();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSerialPortFunc_isDataTerminalReady(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSerialPort *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSerialPort.QSerialPort.isDataTerminalReady";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isDataTerminalReady()
            bool cppResult = cppSelf->isDataTerminalReady();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSerialPortFunc_isRequestToSend(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSerialPort *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSerialPort.QSerialPort.isRequestToSend";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isRequestToSend()
            bool cppResult = cppSelf->isRequestToSend();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSerialPortFunc_isSequential(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSerialPort *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSerialPort.QSerialPort.isSequential";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isSequential()const
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QSerialPort *>(cppSelf)->::QSerialPort::isSequential()
                : const_cast<const ::QSerialPort *>(cppSelf)->isSequential();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSerialPortFunc_open(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSerialPort *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSerialPort.QSerialPort.open";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QIODevice::open(QFlags<QIODevice::OpenModeFlag>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QIODEVICE_OPENMODEFLAG_IDX])->converter, (pyArg)))) {
        overloadId = 0; // open(QFlags<QIODevice::OpenModeFlag>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSerialPortFunc_open_TypeError;

    // Call function/method
    {
        ::QFlags<QIODevice::OpenModeFlag> cppArg0 = QFlags<QIODevice::OpenModeFlag>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // open(QFlags<QIODevice::OpenModeFlag>)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QSerialPort::open(cppArg0)
                : cppSelf->open(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSerialPortFunc_open_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSerialPortFunc_parity(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSerialPort *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSerialPort.QSerialPort.parity";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // parity()const
            QSerialPort::Parity cppResult = const_cast<const ::QSerialPort *>(cppSelf)->parity();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_PARITY_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSerialPortFunc_pinoutSignals(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSerialPort *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSerialPort.QSerialPort.pinoutSignals";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // pinoutSignals()
            QFlags<QSerialPort::PinoutSignal> cppResult = cppSelf->pinoutSignals();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtSerialPortTypes[SBK_QFLAGS_QSERIALPORT_PINOUTSIGNAL_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSerialPortFunc_portName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSerialPort *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSerialPort.QSerialPort.portName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // portName()const
            QString cppResult = const_cast<const ::QSerialPort *>(cppSelf)->portName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSerialPortFunc_readBufferSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSerialPort *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSerialPort.QSerialPort.readBufferSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // readBufferSize()const
            qint64 cppResult = const_cast<const ::QSerialPort *>(cppSelf)->readBufferSize();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSerialPortFunc_readData(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSerialPort *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSerialPort.QSerialPort.readData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QIODevice::readData(char*,qint64)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArg)))) {
        overloadId = 0; // readData(char*,qint64)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSerialPortFunc_readData_TypeError;

    // Call function/method
    {
        qint64 cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // readData(char*,qint64)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (qiodevice-readData)]
            QByteArray ba(1 + int(cppArg0), char(0));
            Py_BEGIN_ALLOW_THREADS
            (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self)) ? cppSelf->::QSerialPort::readData(ba.data(), int(cppArg0)) : cppSelf->readData(ba.data(), int(cppArg0)));
            Py_END_ALLOW_THREADS
            pyResult = Shiboken::String::fromCString(ba.constData());
            // END of custom code block [file: ../glue/qtcore.cpp (qiodevice-readData)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSerialPortFunc_readData_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSerialPortFunc_readLineData(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSerialPort *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSerialPort.QSerialPort.readLineData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QIODevice::readLineData(char*,qint64)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArg)))) {
        overloadId = 0; // readLineData(char*,qint64)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSerialPortFunc_readLineData_TypeError;

    // Call function/method
    {
        qint64 cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // readLineData(char*,qint64)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (qiodevice-readData)]
            QByteArray ba(1 + int(cppArg0), char(0));
            Py_BEGIN_ALLOW_THREADS
            (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self)) ? cppSelf->::QSerialPort::readLineData(ba.data(), int(cppArg0)) : cppSelf->readLineData(ba.data(), int(cppArg0)));
            Py_END_ALLOW_THREADS
            pyResult = Shiboken::String::fromCString(ba.constData());
            // END of custom code block [file: ../glue/qtcore.cpp (qiodevice-readData)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSerialPortFunc_readLineData_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSerialPortFunc_sendBreak(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSerialPort *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSerialPort.QSerialPort.sendBreak";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QSerialPortFunc_sendBreak_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:sendBreak", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QSerialPort::sendBreak(int)
    if (numArgs == 0) {
        overloadId = 0; // sendBreak(int)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 0; // sendBreak(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSerialPortFunc_sendBreak_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_duration = Shiboken::String::createStaticString("duration");
            if (PyDict_Contains(kwds, key_duration)) {
                value = PyDict_GetItem(kwds, key_duration);
                if (value && pyArgs[0]) {
                    errInfo = key_duration;
                    Py_INCREF(errInfo);
                    goto Sbk_QSerialPortFunc_sendBreak_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                        goto Sbk_QSerialPortFunc_sendBreak_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_duration);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QSerialPortFunc_sendBreak_TypeError;
            }
        }
        int cppArg0 = 0;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // sendBreak(int)
            bool cppResult = cppSelf->sendBreak(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSerialPortFunc_sendBreak_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSerialPortFunc_setBaudRate(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSerialPort *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSerialPort.QSerialPort.setBaudRate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QSerialPortFunc_setBaudRate_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QSerialPortFunc_setBaudRate_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:setBaudRate", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QSerialPort::setBaudRate(qint32,QFlags<QSerialPort::Direction>)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint32>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setBaudRate(qint32,QFlags<QSerialPort::Direction>)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtSerialPortTypes[SBK_QFLAGS_QSERIALPORT_DIRECTION_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // setBaudRate(qint32,QFlags<QSerialPort::Direction>)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSerialPortFunc_setBaudRate_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_directions = Shiboken::String::createStaticString("directions");
            if (PyDict_Contains(kwds, key_directions)) {
                value = PyDict_GetItem(kwds, key_directions);
                if (value && pyArgs[1]) {
                    errInfo = key_directions;
                    Py_INCREF(errInfo);
                    goto Sbk_QSerialPortFunc_setBaudRate_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtSerialPortTypes[SBK_QFLAGS_QSERIALPORT_DIRECTION_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QSerialPortFunc_setBaudRate_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_directions);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QSerialPortFunc_setBaudRate_TypeError;
            }
        }
        qint32 cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QFlags<QSerialPort::Direction> cppArg1 = QSerialPort::AllDirections;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setBaudRate(qint32,QFlags<QSerialPort::Direction>)
            bool cppResult = cppSelf->setBaudRate(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSerialPortFunc_setBaudRate_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSerialPortFunc_setBreakEnabled(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSerialPort *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSerialPort.QSerialPort.setBreakEnabled";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QSerialPortFunc_setBreakEnabled_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:setBreakEnabled", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QSerialPort::setBreakEnabled(bool)
    if (numArgs == 0) {
        overloadId = 0; // setBreakEnabled(bool)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0])))) {
        overloadId = 0; // setBreakEnabled(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSerialPortFunc_setBreakEnabled_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_set = Shiboken::String::createStaticString("set");
            if (PyDict_Contains(kwds, key_set)) {
                value = PyDict_GetItem(kwds, key_set);
                if (value && pyArgs[0]) {
                    errInfo = key_set;
                    Py_INCREF(errInfo);
                    goto Sbk_QSerialPortFunc_setBreakEnabled_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0]))))
                        goto Sbk_QSerialPortFunc_setBreakEnabled_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_set);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QSerialPortFunc_setBreakEnabled_TypeError;
            }
        }
        bool cppArg0 = true;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // setBreakEnabled(bool)
            bool cppResult = cppSelf->setBreakEnabled(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSerialPortFunc_setBreakEnabled_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSerialPortFunc_setDataBits(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSerialPort *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSerialPort.QSerialPort.setDataBits";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSerialPort::setDataBits(QSerialPort::DataBits)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_DATABITS_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setDataBits(QSerialPort::DataBits)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSerialPortFunc_setDataBits_TypeError;

    // Call function/method
    {
        ::QSerialPort::DataBits cppArg0 = static_cast< ::QSerialPort::DataBits>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDataBits(QSerialPort::DataBits)
            bool cppResult = cppSelf->setDataBits(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSerialPortFunc_setDataBits_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSerialPortFunc_setDataErrorPolicy(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSerialPort *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSerialPort.QSerialPort.setDataErrorPolicy";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QSerialPortFunc_setDataErrorPolicy_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:setDataErrorPolicy", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QSerialPort::setDataErrorPolicy(QSerialPort::DataErrorPolicy)
    if (numArgs == 0) {
        overloadId = 0; // setDataErrorPolicy(QSerialPort::DataErrorPolicy)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_DATAERRORPOLICY_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // setDataErrorPolicy(QSerialPort::DataErrorPolicy)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSerialPortFunc_setDataErrorPolicy_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_policy = Shiboken::String::createStaticString("policy");
            if (PyDict_Contains(kwds, key_policy)) {
                value = PyDict_GetItem(kwds, key_policy);
                if (value && pyArgs[0]) {
                    errInfo = key_policy;
                    Py_INCREF(errInfo);
                    goto Sbk_QSerialPortFunc_setDataErrorPolicy_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_DATAERRORPOLICY_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_QSerialPortFunc_setDataErrorPolicy_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_policy);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QSerialPortFunc_setDataErrorPolicy_TypeError;
            }
        }
        ::QSerialPort::DataErrorPolicy cppArg0 = QSerialPort::DataErrorPolicy::IgnorePolicy;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // setDataErrorPolicy(QSerialPort::DataErrorPolicy)
            bool cppResult = cppSelf->setDataErrorPolicy(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSerialPortFunc_setDataErrorPolicy_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSerialPortFunc_setDataTerminalReady(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSerialPort *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSerialPort.QSerialPort.setDataTerminalReady";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSerialPort::setDataTerminalReady(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setDataTerminalReady(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSerialPortFunc_setDataTerminalReady_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDataTerminalReady(bool)
            bool cppResult = cppSelf->setDataTerminalReady(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSerialPortFunc_setDataTerminalReady_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSerialPortFunc_setFlowControl(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSerialPort *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSerialPort.QSerialPort.setFlowControl";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSerialPort::setFlowControl(QSerialPort::FlowControl)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_FLOWCONTROL_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setFlowControl(QSerialPort::FlowControl)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSerialPortFunc_setFlowControl_TypeError;

    // Call function/method
    {
        ::QSerialPort::FlowControl cppArg0{QSerialPort::NoFlowControl};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFlowControl(QSerialPort::FlowControl)
            bool cppResult = cppSelf->setFlowControl(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSerialPortFunc_setFlowControl_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSerialPortFunc_setParity(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSerialPort *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSerialPort.QSerialPort.setParity";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSerialPort::setParity(QSerialPort::Parity)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_PARITY_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setParity(QSerialPort::Parity)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSerialPortFunc_setParity_TypeError;

    // Call function/method
    {
        ::QSerialPort::Parity cppArg0{QSerialPort::NoParity};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setParity(QSerialPort::Parity)
            bool cppResult = cppSelf->setParity(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSerialPortFunc_setParity_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSerialPortFunc_setPort(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSerialPort *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSerialPort.QSerialPort.setPort";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSerialPort::setPort(QSerialPortInfo)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORTINFO_IDX]), (pyArg)))) {
        overloadId = 0; // setPort(QSerialPortInfo)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSerialPortFunc_setPort_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QSerialPortInfo cppArg0_local;
        ::QSerialPortInfo *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORTINFO_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setPort(QSerialPortInfo)
            cppSelf->setPort(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSerialPortFunc_setPort_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSerialPortFunc_setPortName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSerialPort *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSerialPort.QSerialPort.setPortName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSerialPort::setPortName(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setPortName(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSerialPortFunc_setPortName_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPortName(QString)
            cppSelf->setPortName(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSerialPortFunc_setPortName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSerialPortFunc_setReadBufferSize(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSerialPort *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSerialPort.QSerialPort.setReadBufferSize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSerialPort::setReadBufferSize(qint64)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArg)))) {
        overloadId = 0; // setReadBufferSize(qint64)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSerialPortFunc_setReadBufferSize_TypeError;

    // Call function/method
    {
        qint64 cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setReadBufferSize(qint64)
            cppSelf->setReadBufferSize(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSerialPortFunc_setReadBufferSize_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSerialPortFunc_setRequestToSend(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSerialPort *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSerialPort.QSerialPort.setRequestToSend";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSerialPort::setRequestToSend(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setRequestToSend(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSerialPortFunc_setRequestToSend_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setRequestToSend(bool)
            bool cppResult = cppSelf->setRequestToSend(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSerialPortFunc_setRequestToSend_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSerialPortFunc_setSettingsRestoredOnClose(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSerialPort *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSerialPort.QSerialPort.setSettingsRestoredOnClose";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSerialPort::setSettingsRestoredOnClose(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setSettingsRestoredOnClose(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSerialPortFunc_setSettingsRestoredOnClose_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSettingsRestoredOnClose(bool)
            cppSelf->setSettingsRestoredOnClose(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSerialPortFunc_setSettingsRestoredOnClose_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSerialPortFunc_setStopBits(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSerialPort *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSerialPort.QSerialPort.setStopBits";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSerialPort::setStopBits(QSerialPort::StopBits)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_STOPBITS_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setStopBits(QSerialPort::StopBits)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSerialPortFunc_setStopBits_TypeError;

    // Call function/method
    {
        ::QSerialPort::StopBits cppArg0 = static_cast< ::QSerialPort::StopBits>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setStopBits(QSerialPort::StopBits)
            bool cppResult = cppSelf->setStopBits(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSerialPortFunc_setStopBits_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSerialPortFunc_settingsRestoredOnClose(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSerialPort *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSerialPort.QSerialPort.settingsRestoredOnClose";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // settingsRestoredOnClose()const
            bool cppResult = const_cast<const ::QSerialPort *>(cppSelf)->settingsRestoredOnClose();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSerialPortFunc_stopBits(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSerialPort *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSerialPort.QSerialPort.stopBits";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // stopBits()const
            QSerialPort::StopBits cppResult = const_cast<const ::QSerialPort *>(cppSelf)->stopBits();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_STOPBITS_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSerialPortFunc_waitForBytesWritten(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSerialPort *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSerialPort.QSerialPort.waitForBytesWritten";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QSerialPortFunc_waitForBytesWritten_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:waitForBytesWritten", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QIODevice::waitForBytesWritten(int)
    if (numArgs == 0) {
        overloadId = 0; // waitForBytesWritten(int)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 0; // waitForBytesWritten(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSerialPortFunc_waitForBytesWritten_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_msecs = Shiboken::String::createStaticString("msecs");
            if (PyDict_Contains(kwds, key_msecs)) {
                value = PyDict_GetItem(kwds, key_msecs);
                if (value && pyArgs[0]) {
                    errInfo = key_msecs;
                    Py_INCREF(errInfo);
                    goto Sbk_QSerialPortFunc_waitForBytesWritten_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                        goto Sbk_QSerialPortFunc_waitForBytesWritten_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_msecs);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QSerialPortFunc_waitForBytesWritten_TypeError;
            }
        }
        int cppArg0 = 30000;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // waitForBytesWritten(int)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QSerialPort::waitForBytesWritten(cppArg0)
                : cppSelf->waitForBytesWritten(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSerialPortFunc_waitForBytesWritten_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSerialPortFunc_waitForReadyRead(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSerialPort *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSerialPort.QSerialPort.waitForReadyRead";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QSerialPortFunc_waitForReadyRead_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:waitForReadyRead", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QIODevice::waitForReadyRead(int)
    if (numArgs == 0) {
        overloadId = 0; // waitForReadyRead(int)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 0; // waitForReadyRead(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSerialPortFunc_waitForReadyRead_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_msecs = Shiboken::String::createStaticString("msecs");
            if (PyDict_Contains(kwds, key_msecs)) {
                value = PyDict_GetItem(kwds, key_msecs);
                if (value && pyArgs[0]) {
                    errInfo = key_msecs;
                    Py_INCREF(errInfo);
                    goto Sbk_QSerialPortFunc_waitForReadyRead_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                        goto Sbk_QSerialPortFunc_waitForReadyRead_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_msecs);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QSerialPortFunc_waitForReadyRead_TypeError;
            }
        }
        int cppArg0 = 30000;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // waitForReadyRead(int)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QSerialPort::waitForReadyRead(cppArg0)
                : cppSelf->waitForReadyRead(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSerialPortFunc_waitForReadyRead_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSerialPortFunc_writeData(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSerialPort *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSerialPort.QSerialPort.writeData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "writeData", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QIODevice::writeData(const char*,qint64)
    if (numArgs == 2
        && Shiboken::String::check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArgs[1])))) {
        overloadId = 0; // writeData(const char*,qint64)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSerialPortFunc_writeData_TypeError;

    // Call function/method
    {
        const char* cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        qint64 cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // writeData(const char*,qint64)
            qint64 cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QSerialPort::writeData(cppArg0, cppArg1)
                : cppSelf->writeData(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSerialPortFunc_writeData_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QSerialPort_PropertyStrings[] = {
    "baudRate::",
    "breakEnabled:isBreakEnabled:",
    "dataBits::",
    "dataErrorPolicy::",
    "dataTerminalReady:isDataTerminalReady:",
    "error:",
    "flowControl::",
    "parity::",
    "requestToSend:isRequestToSend:",
    "settingsRestoredOnClose::",
    "stopBits::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QSerialPort_methods[] = {
    {"atEnd", reinterpret_cast<PyCFunction>(Sbk_QSerialPortFunc_atEnd), METH_NOARGS},
    {"baudRate", reinterpret_cast<PyCFunction>(Sbk_QSerialPortFunc_baudRate), METH_VARARGS|METH_KEYWORDS},
    {"bytesAvailable", reinterpret_cast<PyCFunction>(Sbk_QSerialPortFunc_bytesAvailable), METH_NOARGS},
    {"bytesToWrite", reinterpret_cast<PyCFunction>(Sbk_QSerialPortFunc_bytesToWrite), METH_NOARGS},
    {"canReadLine", reinterpret_cast<PyCFunction>(Sbk_QSerialPortFunc_canReadLine), METH_NOARGS},
    {"clear", reinterpret_cast<PyCFunction>(Sbk_QSerialPortFunc_clear), METH_VARARGS|METH_KEYWORDS},
    {"clearError", reinterpret_cast<PyCFunction>(Sbk_QSerialPortFunc_clearError), METH_NOARGS},
    {"close", reinterpret_cast<PyCFunction>(Sbk_QSerialPortFunc_close), METH_NOARGS},
    {"dataBits", reinterpret_cast<PyCFunction>(Sbk_QSerialPortFunc_dataBits), METH_NOARGS},
    {"dataErrorPolicy", reinterpret_cast<PyCFunction>(Sbk_QSerialPortFunc_dataErrorPolicy), METH_NOARGS},
    {"error", reinterpret_cast<PyCFunction>(Sbk_QSerialPortFunc_error), METH_NOARGS},
    {"flowControl", reinterpret_cast<PyCFunction>(Sbk_QSerialPortFunc_flowControl), METH_NOARGS},
    {"flush", reinterpret_cast<PyCFunction>(Sbk_QSerialPortFunc_flush), METH_NOARGS},
    {"handle", reinterpret_cast<PyCFunction>(Sbk_QSerialPortFunc_handle), METH_NOARGS},
    {"isBreakEnabled", reinterpret_cast<PyCFunction>(Sbk_QSerialPortFunc_isBreakEnabled), METH_NOARGS},
    {"isDataTerminalReady", reinterpret_cast<PyCFunction>(Sbk_QSerialPortFunc_isDataTerminalReady), METH_NOARGS},
    {"isRequestToSend", reinterpret_cast<PyCFunction>(Sbk_QSerialPortFunc_isRequestToSend), METH_NOARGS},
    {"isSequential", reinterpret_cast<PyCFunction>(Sbk_QSerialPortFunc_isSequential), METH_NOARGS},
    {"open", reinterpret_cast<PyCFunction>(Sbk_QSerialPortFunc_open), METH_O},
    {"parity", reinterpret_cast<PyCFunction>(Sbk_QSerialPortFunc_parity), METH_NOARGS},
    {"pinoutSignals", reinterpret_cast<PyCFunction>(Sbk_QSerialPortFunc_pinoutSignals), METH_NOARGS},
    {"portName", reinterpret_cast<PyCFunction>(Sbk_QSerialPortFunc_portName), METH_NOARGS},
    {"readBufferSize", reinterpret_cast<PyCFunction>(Sbk_QSerialPortFunc_readBufferSize), METH_NOARGS},
    {"readData", reinterpret_cast<PyCFunction>(Sbk_QSerialPortFunc_readData), METH_O},
    {"readLineData", reinterpret_cast<PyCFunction>(Sbk_QSerialPortFunc_readLineData), METH_O},
    {"sendBreak", reinterpret_cast<PyCFunction>(Sbk_QSerialPortFunc_sendBreak), METH_VARARGS|METH_KEYWORDS},
    {"setBaudRate", reinterpret_cast<PyCFunction>(Sbk_QSerialPortFunc_setBaudRate), METH_VARARGS|METH_KEYWORDS},
    {"setBreakEnabled", reinterpret_cast<PyCFunction>(Sbk_QSerialPortFunc_setBreakEnabled), METH_VARARGS|METH_KEYWORDS},
    {"setDataBits", reinterpret_cast<PyCFunction>(Sbk_QSerialPortFunc_setDataBits), METH_O},
    {"setDataErrorPolicy", reinterpret_cast<PyCFunction>(Sbk_QSerialPortFunc_setDataErrorPolicy), METH_VARARGS|METH_KEYWORDS},
    {"setDataTerminalReady", reinterpret_cast<PyCFunction>(Sbk_QSerialPortFunc_setDataTerminalReady), METH_O},
    {"setFlowControl", reinterpret_cast<PyCFunction>(Sbk_QSerialPortFunc_setFlowControl), METH_O},
    {"setParity", reinterpret_cast<PyCFunction>(Sbk_QSerialPortFunc_setParity), METH_O},
    {"setPort", reinterpret_cast<PyCFunction>(Sbk_QSerialPortFunc_setPort), METH_O},
    {"setPortName", reinterpret_cast<PyCFunction>(Sbk_QSerialPortFunc_setPortName), METH_O},
    {"setReadBufferSize", reinterpret_cast<PyCFunction>(Sbk_QSerialPortFunc_setReadBufferSize), METH_O},
    {"setRequestToSend", reinterpret_cast<PyCFunction>(Sbk_QSerialPortFunc_setRequestToSend), METH_O},
    {"setSettingsRestoredOnClose", reinterpret_cast<PyCFunction>(Sbk_QSerialPortFunc_setSettingsRestoredOnClose), METH_O},
    {"setStopBits", reinterpret_cast<PyCFunction>(Sbk_QSerialPortFunc_setStopBits), METH_O},
    {"settingsRestoredOnClose", reinterpret_cast<PyCFunction>(Sbk_QSerialPortFunc_settingsRestoredOnClose), METH_NOARGS},
    {"stopBits", reinterpret_cast<PyCFunction>(Sbk_QSerialPortFunc_stopBits), METH_NOARGS},
    {"waitForBytesWritten", reinterpret_cast<PyCFunction>(Sbk_QSerialPortFunc_waitForBytesWritten), METH_VARARGS|METH_KEYWORDS},
    {"waitForReadyRead", reinterpret_cast<PyCFunction>(Sbk_QSerialPortFunc_waitForReadyRead), METH_VARARGS|METH_KEYWORDS},
    {"writeData", reinterpret_cast<PyCFunction>(Sbk_QSerialPortFunc_writeData), METH_VARARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QSerialPort_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QSerialPort *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QSerialPortWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QSerialPort_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QSerialPort_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QSerialPort_Type = nullptr;
static SbkObjectType *Sbk_QSerialPort_TypeF(void)
{
    return _Sbk_QSerialPort_Type;
}

static PyType_Slot Sbk_QSerialPort_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QSerialPort_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QSerialPort_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QSerialPort_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QSerialPort_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QSerialPort_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QSerialPort_spec = {
    "2:PySide2.QtSerialPort.QSerialPort",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QSerialPort_slots
};

} //extern "C"

static void *Sbk_QSerialPort_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QSerialPort *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}

PyObject *SbkPySide2_QtSerialPort_QSerialPort_Direction___and__(PyObject *self, PyObject *pyArg)
{
    ::QSerialPort::Directions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QSerialPort::Directions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QSerialPort::Directions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QSerialPort::Directions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QSerialPort::Directions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtSerialPortTypes[SBK_QFLAGS_QSERIALPORT_DIRECTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtSerialPort_QSerialPort_Direction___or__(PyObject *self, PyObject *pyArg)
{
    ::QSerialPort::Directions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QSerialPort::Directions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QSerialPort::Directions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QSerialPort::Directions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QSerialPort::Directions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtSerialPortTypes[SBK_QFLAGS_QSERIALPORT_DIRECTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtSerialPort_QSerialPort_Direction___xor__(PyObject *self, PyObject *pyArg)
{
    ::QSerialPort::Directions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QSerialPort::Directions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QSerialPort::Directions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QSerialPort::Directions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QSerialPort::Directions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtSerialPortTypes[SBK_QFLAGS_QSERIALPORT_DIRECTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtSerialPort_QSerialPort_Direction___invert__(PyObject *self, PyObject *pyArg)
{
    ::QSerialPort::Directions cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtSerialPortTypes[SBK_QFLAGS_QSERIALPORT_DIRECTION_IDX])->converter, self, &cppSelf);
    ::QSerialPort::Directions cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtSerialPortTypes[SBK_QFLAGS_QSERIALPORT_DIRECTION_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtSerialPort_QSerialPort_Direction_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtSerialPortTypes[SBK_QFLAGS_QSERIALPORT_DIRECTION_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtSerialPort_QSerialPort_Direction__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtSerialPortTypes[SBK_QFLAGS_QSERIALPORT_DIRECTION_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtSerialPort_QSerialPort_Direction_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtSerialPort_QSerialPort_Direction__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtSerialPort_QSerialPort_Direction__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtSerialPort_QSerialPort_Direction_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtSerialPort_QSerialPort_Direction___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtSerialPort_QSerialPort_Direction___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtSerialPort_QSerialPort_Direction___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtSerialPort_QSerialPort_Direction___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtSerialPort_QSerialPort_Direction_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtSerialPort_QSerialPort_Direction_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtSerialPort_QSerialPort_Direction_long)},
#endif
    {0, nullptr} // sentinel
};


PyObject *SbkPySide2_QtSerialPort_QSerialPort_PinoutSignal___and__(PyObject *self, PyObject *pyArg)
{
    ::QSerialPort::PinoutSignals cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QSerialPort::PinoutSignals>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QSerialPort::PinoutSignals>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QSerialPort::PinoutSignals>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QSerialPort::PinoutSignals>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtSerialPortTypes[SBK_QFLAGS_QSERIALPORT_PINOUTSIGNAL_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtSerialPort_QSerialPort_PinoutSignal___or__(PyObject *self, PyObject *pyArg)
{
    ::QSerialPort::PinoutSignals cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QSerialPort::PinoutSignals>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QSerialPort::PinoutSignals>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QSerialPort::PinoutSignals>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QSerialPort::PinoutSignals>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtSerialPortTypes[SBK_QFLAGS_QSERIALPORT_PINOUTSIGNAL_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtSerialPort_QSerialPort_PinoutSignal___xor__(PyObject *self, PyObject *pyArg)
{
    ::QSerialPort::PinoutSignals cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QSerialPort::PinoutSignals>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QSerialPort::PinoutSignals>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QSerialPort::PinoutSignals>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QSerialPort::PinoutSignals>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtSerialPortTypes[SBK_QFLAGS_QSERIALPORT_PINOUTSIGNAL_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtSerialPort_QSerialPort_PinoutSignal___invert__(PyObject *self, PyObject *pyArg)
{
    ::QSerialPort::PinoutSignals cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtSerialPortTypes[SBK_QFLAGS_QSERIALPORT_PINOUTSIGNAL_IDX])->converter, self, &cppSelf);
    ::QSerialPort::PinoutSignals cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtSerialPortTypes[SBK_QFLAGS_QSERIALPORT_PINOUTSIGNAL_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtSerialPort_QSerialPort_PinoutSignal_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtSerialPortTypes[SBK_QFLAGS_QSERIALPORT_PINOUTSIGNAL_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtSerialPort_QSerialPort_PinoutSignal__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtSerialPortTypes[SBK_QFLAGS_QSERIALPORT_PINOUTSIGNAL_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtSerialPort_QSerialPort_PinoutSignal_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtSerialPort_QSerialPort_PinoutSignal__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtSerialPort_QSerialPort_PinoutSignal__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtSerialPort_QSerialPort_PinoutSignal_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtSerialPort_QSerialPort_PinoutSignal___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtSerialPort_QSerialPort_PinoutSignal___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtSerialPort_QSerialPort_PinoutSignal___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtSerialPort_QSerialPort_PinoutSignal___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtSerialPort_QSerialPort_PinoutSignal_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtSerialPort_QSerialPort_PinoutSignal_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtSerialPort_QSerialPort_PinoutSignal_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QSerialPort_Direction_PythonToCpp_QSerialPort_Direction(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSerialPort::Direction *>(cppOut) =
        static_cast<::QSerialPort::Direction>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSerialPort_Direction_PythonToCpp_QSerialPort_Direction_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_DIRECTION_IDX]))
        return QSerialPort_Direction_PythonToCpp_QSerialPort_Direction;
    return {};
}
static PyObject *QSerialPort_Direction_CppToPython_QSerialPort_Direction(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSerialPort::Direction *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_DIRECTION_IDX], castCppIn);

}

static void QFlags_QSerialPort_Direction__PythonToCpp_QFlags_QSerialPort_Direction_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QSerialPort::Direction> *>(cppOut) =
        ::QFlags<QSerialPort::Direction>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QSerialPort_Direction__PythonToCpp_QFlags_QSerialPort_Direction__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtSerialPortTypes[SBK_QFLAGS_QSERIALPORT_DIRECTION_IDX]))
        return QFlags_QSerialPort_Direction__PythonToCpp_QFlags_QSerialPort_Direction_;
    return {};
}
static PyObject *QFlags_QSerialPort_Direction__CppToPython_QFlags_QSerialPort_Direction_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QSerialPort::Direction> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtSerialPortTypes[SBK_QFLAGS_QSERIALPORT_DIRECTION_IDX]));

}

static void QSerialPort_Direction_PythonToCpp_QFlags_QSerialPort_Direction_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QSerialPort::Direction> *>(cppOut) =
        ::QFlags<QSerialPort::Direction>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QSerialPort_Direction_PythonToCpp_QFlags_QSerialPort_Direction__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_DIRECTION_IDX]))
        return QSerialPort_Direction_PythonToCpp_QFlags_QSerialPort_Direction_;
    return {};
}
static void number_PythonToCpp_QFlags_QSerialPort_Direction_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QSerialPort::Direction> *>(cppOut) =
        ::QFlags<QSerialPort::Direction>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QSerialPort_Direction__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_DIRECTION_IDX]))
        return number_PythonToCpp_QFlags_QSerialPort_Direction_;
    return {};
}
static void QSerialPort_BaudRate_PythonToCpp_QSerialPort_BaudRate(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSerialPort::BaudRate *>(cppOut) =
        static_cast<::QSerialPort::BaudRate>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSerialPort_BaudRate_PythonToCpp_QSerialPort_BaudRate_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_BAUDRATE_IDX]))
        return QSerialPort_BaudRate_PythonToCpp_QSerialPort_BaudRate;
    return {};
}
static PyObject *QSerialPort_BaudRate_CppToPython_QSerialPort_BaudRate(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSerialPort::BaudRate *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_BAUDRATE_IDX], castCppIn);

}

static void QSerialPort_DataBits_PythonToCpp_QSerialPort_DataBits(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSerialPort::DataBits *>(cppOut) =
        static_cast<::QSerialPort::DataBits>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSerialPort_DataBits_PythonToCpp_QSerialPort_DataBits_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_DATABITS_IDX]))
        return QSerialPort_DataBits_PythonToCpp_QSerialPort_DataBits;
    return {};
}
static PyObject *QSerialPort_DataBits_CppToPython_QSerialPort_DataBits(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSerialPort::DataBits *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_DATABITS_IDX], castCppIn);

}

static void QSerialPort_Parity_PythonToCpp_QSerialPort_Parity(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSerialPort::Parity *>(cppOut) =
        static_cast<::QSerialPort::Parity>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSerialPort_Parity_PythonToCpp_QSerialPort_Parity_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_PARITY_IDX]))
        return QSerialPort_Parity_PythonToCpp_QSerialPort_Parity;
    return {};
}
static PyObject *QSerialPort_Parity_CppToPython_QSerialPort_Parity(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSerialPort::Parity *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_PARITY_IDX], castCppIn);

}

static void QSerialPort_StopBits_PythonToCpp_QSerialPort_StopBits(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSerialPort::StopBits *>(cppOut) =
        static_cast<::QSerialPort::StopBits>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSerialPort_StopBits_PythonToCpp_QSerialPort_StopBits_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_STOPBITS_IDX]))
        return QSerialPort_StopBits_PythonToCpp_QSerialPort_StopBits;
    return {};
}
static PyObject *QSerialPort_StopBits_CppToPython_QSerialPort_StopBits(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSerialPort::StopBits *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_STOPBITS_IDX], castCppIn);

}

static void QSerialPort_FlowControl_PythonToCpp_QSerialPort_FlowControl(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSerialPort::FlowControl *>(cppOut) =
        static_cast<::QSerialPort::FlowControl>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSerialPort_FlowControl_PythonToCpp_QSerialPort_FlowControl_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_FLOWCONTROL_IDX]))
        return QSerialPort_FlowControl_PythonToCpp_QSerialPort_FlowControl;
    return {};
}
static PyObject *QSerialPort_FlowControl_CppToPython_QSerialPort_FlowControl(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSerialPort::FlowControl *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_FLOWCONTROL_IDX], castCppIn);

}

static void QSerialPort_PinoutSignal_PythonToCpp_QSerialPort_PinoutSignal(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSerialPort::PinoutSignal *>(cppOut) =
        static_cast<::QSerialPort::PinoutSignal>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSerialPort_PinoutSignal_PythonToCpp_QSerialPort_PinoutSignal_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_PINOUTSIGNAL_IDX]))
        return QSerialPort_PinoutSignal_PythonToCpp_QSerialPort_PinoutSignal;
    return {};
}
static PyObject *QSerialPort_PinoutSignal_CppToPython_QSerialPort_PinoutSignal(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSerialPort::PinoutSignal *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_PINOUTSIGNAL_IDX], castCppIn);

}

static void QFlags_QSerialPort_PinoutSignal__PythonToCpp_QFlags_QSerialPort_PinoutSignal_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QSerialPort::PinoutSignal> *>(cppOut) =
        ::QFlags<QSerialPort::PinoutSignal>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QSerialPort_PinoutSignal__PythonToCpp_QFlags_QSerialPort_PinoutSignal__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtSerialPortTypes[SBK_QFLAGS_QSERIALPORT_PINOUTSIGNAL_IDX]))
        return QFlags_QSerialPort_PinoutSignal__PythonToCpp_QFlags_QSerialPort_PinoutSignal_;
    return {};
}
static PyObject *QFlags_QSerialPort_PinoutSignal__CppToPython_QFlags_QSerialPort_PinoutSignal_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QSerialPort::PinoutSignal> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtSerialPortTypes[SBK_QFLAGS_QSERIALPORT_PINOUTSIGNAL_IDX]));

}

static void QSerialPort_PinoutSignal_PythonToCpp_QFlags_QSerialPort_PinoutSignal_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QSerialPort::PinoutSignal> *>(cppOut) =
        ::QFlags<QSerialPort::PinoutSignal>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QSerialPort_PinoutSignal_PythonToCpp_QFlags_QSerialPort_PinoutSignal__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_PINOUTSIGNAL_IDX]))
        return QSerialPort_PinoutSignal_PythonToCpp_QFlags_QSerialPort_PinoutSignal_;
    return {};
}
static void number_PythonToCpp_QFlags_QSerialPort_PinoutSignal_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QSerialPort::PinoutSignal> *>(cppOut) =
        ::QFlags<QSerialPort::PinoutSignal>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QSerialPort_PinoutSignal__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_PINOUTSIGNAL_IDX]))
        return number_PythonToCpp_QFlags_QSerialPort_PinoutSignal_;
    return {};
}
static void QSerialPort_DataErrorPolicy_PythonToCpp_QSerialPort_DataErrorPolicy(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSerialPort::DataErrorPolicy *>(cppOut) =
        static_cast<::QSerialPort::DataErrorPolicy>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSerialPort_DataErrorPolicy_PythonToCpp_QSerialPort_DataErrorPolicy_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_DATAERRORPOLICY_IDX]))
        return QSerialPort_DataErrorPolicy_PythonToCpp_QSerialPort_DataErrorPolicy;
    return {};
}
static PyObject *QSerialPort_DataErrorPolicy_CppToPython_QSerialPort_DataErrorPolicy(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSerialPort::DataErrorPolicy *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_DATAERRORPOLICY_IDX], castCppIn);

}

static void QSerialPort_SerialPortError_PythonToCpp_QSerialPort_SerialPortError(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSerialPort::SerialPortError *>(cppOut) =
        static_cast<::QSerialPort::SerialPortError>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSerialPort_SerialPortError_PythonToCpp_QSerialPort_SerialPortError_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_SERIALPORTERROR_IDX]))
        return QSerialPort_SerialPortError_PythonToCpp_QSerialPort_SerialPortError;
    return {};
}
static PyObject *QSerialPort_SerialPortError_CppToPython_QSerialPort_SerialPortError(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSerialPort::SerialPortError *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_SERIALPORTERROR_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QSerialPort_PythonToCpp_QSerialPort_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QSerialPort_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QSerialPort_PythonToCpp_QSerialPort_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QSerialPort_TypeF())))
        return QSerialPort_PythonToCpp_QSerialPort_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QSerialPort_PTR_CppToPython_QSerialPort(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QSerialPort *>(const_cast<void *>(cppIn)), Sbk_QSerialPort_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QSerialPort_SignatureStrings[] = {
    "2:PySide2.QtSerialPort.QSerialPort(self,parent:PySide2.QtCore.QObject=nullptr)",
    "1:PySide2.QtSerialPort.QSerialPort(self,info:PySide2.QtSerialPort.QSerialPortInfo,parent:PySide2.QtCore.QObject=nullptr)",
    "0:PySide2.QtSerialPort.QSerialPort(self,name:QString,parent:PySide2.QtCore.QObject=nullptr)",
    "PySide2.QtSerialPort.QSerialPort.atEnd(self)->bool",
    "PySide2.QtSerialPort.QSerialPort.baudRate(self,directions:PySide2.QtSerialPort.QSerialPort.Directions=QSerialPort.AllDirections)->qint32",
    "PySide2.QtSerialPort.QSerialPort.bytesAvailable(self)->qint64",
    "PySide2.QtSerialPort.QSerialPort.bytesToWrite(self)->qint64",
    "PySide2.QtSerialPort.QSerialPort.canReadLine(self)->bool",
    "PySide2.QtSerialPort.QSerialPort.clear(self,directions:PySide2.QtSerialPort.QSerialPort.Directions=QSerialPort.AllDirections)->bool",
    "PySide2.QtSerialPort.QSerialPort.clearError(self)",
    "PySide2.QtSerialPort.QSerialPort.close(self)",
    "PySide2.QtSerialPort.QSerialPort.dataBits(self)->PySide2.QtSerialPort.QSerialPort.DataBits",
    "PySide2.QtSerialPort.QSerialPort.dataErrorPolicy(self)->PySide2.QtSerialPort.QSerialPort.DataErrorPolicy",
    "PySide2.QtSerialPort.QSerialPort.error(self)->PySide2.QtSerialPort.QSerialPort.SerialPortError",
    "PySide2.QtSerialPort.QSerialPort.flowControl(self)->PySide2.QtSerialPort.QSerialPort.FlowControl",
    "PySide2.QtSerialPort.QSerialPort.flush(self)->bool",
    "PySide2.QtSerialPort.QSerialPort.handle(self)->int",
    "PySide2.QtSerialPort.QSerialPort.isBreakEnabled(self)->bool",
    "PySide2.QtSerialPort.QSerialPort.isDataTerminalReady(self)->bool",
    "PySide2.QtSerialPort.QSerialPort.isRequestToSend(self)->bool",
    "PySide2.QtSerialPort.QSerialPort.isSequential(self)->bool",
    "PySide2.QtSerialPort.QSerialPort.open(self,mode:PySide2.QtCore.QIODevice.OpenMode)->bool",
    "PySide2.QtSerialPort.QSerialPort.parity(self)->PySide2.QtSerialPort.QSerialPort.Parity",
    "PySide2.QtSerialPort.QSerialPort.pinoutSignals(self)->PySide2.QtSerialPort.QSerialPort.PinoutSignals",
    "PySide2.QtSerialPort.QSerialPort.portName(self)->QString",
    "PySide2.QtSerialPort.QSerialPort.readBufferSize(self)->qint64",
    "PySide2.QtSerialPort.QSerialPort.readData(self,data:char*,maxSize:qint64)->qint64",
    "PySide2.QtSerialPort.QSerialPort.readLineData(self,data:char*,maxSize:qint64)->qint64",
    "PySide2.QtSerialPort.QSerialPort.sendBreak(self,duration:int=0)->bool",
    "PySide2.QtSerialPort.QSerialPort.setBaudRate(self,baudRate:qint32,directions:PySide2.QtSerialPort.QSerialPort.Directions=QSerialPort.AllDirections)->bool",
    "PySide2.QtSerialPort.QSerialPort.setBreakEnabled(self,set:bool=true)->bool",
    "PySide2.QtSerialPort.QSerialPort.setDataBits(self,dataBits:PySide2.QtSerialPort.QSerialPort.DataBits)->bool",
    "PySide2.QtSerialPort.QSerialPort.setDataErrorPolicy(self,policy:PySide2.QtSerialPort.QSerialPort.DataErrorPolicy=IgnorePolicy)->bool",
    "PySide2.QtSerialPort.QSerialPort.setDataTerminalReady(self,set:bool)->bool",
    "PySide2.QtSerialPort.QSerialPort.setFlowControl(self,flowControl:PySide2.QtSerialPort.QSerialPort.FlowControl)->bool",
    "PySide2.QtSerialPort.QSerialPort.setParity(self,parity:PySide2.QtSerialPort.QSerialPort.Parity)->bool",
    "PySide2.QtSerialPort.QSerialPort.setPort(self,info:PySide2.QtSerialPort.QSerialPortInfo)",
    "PySide2.QtSerialPort.QSerialPort.setPortName(self,name:QString)",
    "PySide2.QtSerialPort.QSerialPort.setReadBufferSize(self,size:qint64)",
    "PySide2.QtSerialPort.QSerialPort.setRequestToSend(self,set:bool)->bool",
    "PySide2.QtSerialPort.QSerialPort.setSettingsRestoredOnClose(self,restore:bool)",
    "PySide2.QtSerialPort.QSerialPort.setStopBits(self,stopBits:PySide2.QtSerialPort.QSerialPort.StopBits)->bool",
    "PySide2.QtSerialPort.QSerialPort.settingsRestoredOnClose(self)->bool",
    "PySide2.QtSerialPort.QSerialPort.stopBits(self)->PySide2.QtSerialPort.QSerialPort.StopBits",
    "PySide2.QtSerialPort.QSerialPort.waitForBytesWritten(self,msecs:int=30000)->bool",
    "PySide2.QtSerialPort.QSerialPort.waitForReadyRead(self,msecs:int=30000)->bool",
    "PySide2.QtSerialPort.QSerialPort.writeData(self,data:char*,maxSize:qint64)->qint64",
    nullptr}; // Sentinel

void init_QSerialPort(PyObject *module)
{
    _Sbk_QSerialPort_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QSerialPort",
        "QSerialPort*",
        &Sbk_QSerialPort_spec,
        &Shiboken::callCppDestructor< ::QSerialPort >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QSerialPort_Type);
    InitSignatureStrings(pyType, QSerialPort_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QSerialPort_Type), Sbk_QSerialPort_PropertyStrings);
    SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QSerialPort_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QSerialPort_TypeF(),
        QSerialPort_PythonToCpp_QSerialPort_PTR,
        is_QSerialPort_PythonToCpp_QSerialPort_PTR_Convertible,
        QSerialPort_PTR_CppToPython_QSerialPort);

    Shiboken::Conversions::registerConverterName(converter, "QSerialPort");
    Shiboken::Conversions::registerConverterName(converter, "QSerialPort*");
    Shiboken::Conversions::registerConverterName(converter, "QSerialPort&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QSerialPort).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QSerialPortWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QSerialPort_TypeF(), &Sbk_QSerialPort_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'Direction'.
    SbkPySide2_QtSerialPortTypes[SBK_QFLAGS_QSERIALPORT_DIRECTION_IDX] = PySide::QFlags::create("2:PySide2.QtSerialPort.QSerialPort.Directions", SbkPySide2_QtSerialPort_QSerialPort_Direction_number_slots);
    SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_DIRECTION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSerialPort_TypeF(),
        "Direction",
        "2:PySide2.QtSerialPort.QSerialPort.Direction",
        "QSerialPort::Direction",
        SbkPySide2_QtSerialPortTypes[SBK_QFLAGS_QSERIALPORT_DIRECTION_IDX]);
    if (!SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_DIRECTION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_DIRECTION_IDX],
        Sbk_QSerialPort_TypeF(), "Input", (long) QSerialPort::Direction::Input))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_DIRECTION_IDX],
        Sbk_QSerialPort_TypeF(), "Output", (long) QSerialPort::Direction::Output))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_DIRECTION_IDX],
        Sbk_QSerialPort_TypeF(), "AllDirections", (long) QSerialPort::Direction::AllDirections))
        return;
    // Register converter for enum 'QSerialPort::Direction'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_DIRECTION_IDX],
            QSerialPort_Direction_CppToPython_QSerialPort_Direction);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSerialPort_Direction_PythonToCpp_QSerialPort_Direction,
            is_QSerialPort_Direction_PythonToCpp_QSerialPort_Direction_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_DIRECTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSerialPort::Direction");
        Shiboken::Conversions::registerConverterName(converter, "Direction");
    }
    // Register converter for flag 'QFlags<QSerialPort::Direction>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtSerialPortTypes[SBK_QFLAGS_QSERIALPORT_DIRECTION_IDX],
            QFlags_QSerialPort_Direction__CppToPython_QFlags_QSerialPort_Direction_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSerialPort_Direction_PythonToCpp_QFlags_QSerialPort_Direction_,
            is_QSerialPort_Direction_PythonToCpp_QFlags_QSerialPort_Direction__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QSerialPort_Direction__PythonToCpp_QFlags_QSerialPort_Direction_,
            is_QFlags_QSerialPort_Direction__PythonToCpp_QFlags_QSerialPort_Direction__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QSerialPort_Direction_,
            is_number_PythonToCpp_QFlags_QSerialPort_Direction__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtSerialPortTypes[SBK_QFLAGS_QSERIALPORT_DIRECTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSerialPort::Directions");
        Shiboken::Conversions::registerConverterName(converter, "Directions");
    }
    // End of 'Direction' enum/flags.

    // Initialization of enum 'BaudRate'.
    SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_BAUDRATE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSerialPort_TypeF(),
        "BaudRate",
        "2:PySide2.QtSerialPort.QSerialPort.BaudRate",
        "QSerialPort::BaudRate");
    if (!SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_BAUDRATE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_BAUDRATE_IDX],
        Sbk_QSerialPort_TypeF(), "Baud1200", (long) QSerialPort::BaudRate::Baud1200))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_BAUDRATE_IDX],
        Sbk_QSerialPort_TypeF(), "Baud2400", (long) QSerialPort::BaudRate::Baud2400))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_BAUDRATE_IDX],
        Sbk_QSerialPort_TypeF(), "Baud4800", (long) QSerialPort::BaudRate::Baud4800))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_BAUDRATE_IDX],
        Sbk_QSerialPort_TypeF(), "Baud9600", (long) QSerialPort::BaudRate::Baud9600))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_BAUDRATE_IDX],
        Sbk_QSerialPort_TypeF(), "Baud19200", (long) QSerialPort::BaudRate::Baud19200))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_BAUDRATE_IDX],
        Sbk_QSerialPort_TypeF(), "Baud38400", (long) QSerialPort::BaudRate::Baud38400))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_BAUDRATE_IDX],
        Sbk_QSerialPort_TypeF(), "Baud57600", (long) QSerialPort::BaudRate::Baud57600))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_BAUDRATE_IDX],
        Sbk_QSerialPort_TypeF(), "Baud115200", (long) QSerialPort::BaudRate::Baud115200))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_BAUDRATE_IDX],
        Sbk_QSerialPort_TypeF(), "UnknownBaud", (long) QSerialPort::BaudRate::UnknownBaud))
        return;
    // Register converter for enum 'QSerialPort::BaudRate'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_BAUDRATE_IDX],
            QSerialPort_BaudRate_CppToPython_QSerialPort_BaudRate);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSerialPort_BaudRate_PythonToCpp_QSerialPort_BaudRate,
            is_QSerialPort_BaudRate_PythonToCpp_QSerialPort_BaudRate_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_BAUDRATE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSerialPort::BaudRate");
        Shiboken::Conversions::registerConverterName(converter, "BaudRate");
    }
    // End of 'BaudRate' enum.

    // Initialization of enum 'DataBits'.
    SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_DATABITS_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSerialPort_TypeF(),
        "DataBits",
        "2:PySide2.QtSerialPort.QSerialPort.DataBits",
        "QSerialPort::DataBits");
    if (!SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_DATABITS_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_DATABITS_IDX],
        Sbk_QSerialPort_TypeF(), "Data5", (long) QSerialPort::DataBits::Data5))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_DATABITS_IDX],
        Sbk_QSerialPort_TypeF(), "Data6", (long) QSerialPort::DataBits::Data6))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_DATABITS_IDX],
        Sbk_QSerialPort_TypeF(), "Data7", (long) QSerialPort::DataBits::Data7))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_DATABITS_IDX],
        Sbk_QSerialPort_TypeF(), "Data8", (long) QSerialPort::DataBits::Data8))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_DATABITS_IDX],
        Sbk_QSerialPort_TypeF(), "UnknownDataBits", (long) QSerialPort::DataBits::UnknownDataBits))
        return;
    // Register converter for enum 'QSerialPort::DataBits'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_DATABITS_IDX],
            QSerialPort_DataBits_CppToPython_QSerialPort_DataBits);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSerialPort_DataBits_PythonToCpp_QSerialPort_DataBits,
            is_QSerialPort_DataBits_PythonToCpp_QSerialPort_DataBits_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_DATABITS_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSerialPort::DataBits");
        Shiboken::Conversions::registerConverterName(converter, "DataBits");
    }
    // End of 'DataBits' enum.

    // Initialization of enum 'Parity'.
    SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_PARITY_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSerialPort_TypeF(),
        "Parity",
        "2:PySide2.QtSerialPort.QSerialPort.Parity",
        "QSerialPort::Parity");
    if (!SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_PARITY_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_PARITY_IDX],
        Sbk_QSerialPort_TypeF(), "NoParity", (long) QSerialPort::Parity::NoParity))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_PARITY_IDX],
        Sbk_QSerialPort_TypeF(), "EvenParity", (long) QSerialPort::Parity::EvenParity))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_PARITY_IDX],
        Sbk_QSerialPort_TypeF(), "OddParity", (long) QSerialPort::Parity::OddParity))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_PARITY_IDX],
        Sbk_QSerialPort_TypeF(), "SpaceParity", (long) QSerialPort::Parity::SpaceParity))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_PARITY_IDX],
        Sbk_QSerialPort_TypeF(), "MarkParity", (long) QSerialPort::Parity::MarkParity))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_PARITY_IDX],
        Sbk_QSerialPort_TypeF(), "UnknownParity", (long) QSerialPort::Parity::UnknownParity))
        return;
    // Register converter for enum 'QSerialPort::Parity'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_PARITY_IDX],
            QSerialPort_Parity_CppToPython_QSerialPort_Parity);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSerialPort_Parity_PythonToCpp_QSerialPort_Parity,
            is_QSerialPort_Parity_PythonToCpp_QSerialPort_Parity_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_PARITY_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSerialPort::Parity");
        Shiboken::Conversions::registerConverterName(converter, "Parity");
    }
    // End of 'Parity' enum.

    // Initialization of enum 'StopBits'.
    SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_STOPBITS_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSerialPort_TypeF(),
        "StopBits",
        "2:PySide2.QtSerialPort.QSerialPort.StopBits",
        "QSerialPort::StopBits");
    if (!SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_STOPBITS_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_STOPBITS_IDX],
        Sbk_QSerialPort_TypeF(), "OneStop", (long) QSerialPort::StopBits::OneStop))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_STOPBITS_IDX],
        Sbk_QSerialPort_TypeF(), "OneAndHalfStop", (long) QSerialPort::StopBits::OneAndHalfStop))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_STOPBITS_IDX],
        Sbk_QSerialPort_TypeF(), "TwoStop", (long) QSerialPort::StopBits::TwoStop))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_STOPBITS_IDX],
        Sbk_QSerialPort_TypeF(), "UnknownStopBits", (long) QSerialPort::StopBits::UnknownStopBits))
        return;
    // Register converter for enum 'QSerialPort::StopBits'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_STOPBITS_IDX],
            QSerialPort_StopBits_CppToPython_QSerialPort_StopBits);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSerialPort_StopBits_PythonToCpp_QSerialPort_StopBits,
            is_QSerialPort_StopBits_PythonToCpp_QSerialPort_StopBits_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_STOPBITS_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSerialPort::StopBits");
        Shiboken::Conversions::registerConverterName(converter, "StopBits");
    }
    // End of 'StopBits' enum.

    // Initialization of enum 'FlowControl'.
    SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_FLOWCONTROL_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSerialPort_TypeF(),
        "FlowControl",
        "2:PySide2.QtSerialPort.QSerialPort.FlowControl",
        "QSerialPort::FlowControl");
    if (!SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_FLOWCONTROL_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_FLOWCONTROL_IDX],
        Sbk_QSerialPort_TypeF(), "NoFlowControl", (long) QSerialPort::FlowControl::NoFlowControl))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_FLOWCONTROL_IDX],
        Sbk_QSerialPort_TypeF(), "HardwareControl", (long) QSerialPort::FlowControl::HardwareControl))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_FLOWCONTROL_IDX],
        Sbk_QSerialPort_TypeF(), "SoftwareControl", (long) QSerialPort::FlowControl::SoftwareControl))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_FLOWCONTROL_IDX],
        Sbk_QSerialPort_TypeF(), "UnknownFlowControl", (long) QSerialPort::FlowControl::UnknownFlowControl))
        return;
    // Register converter for enum 'QSerialPort::FlowControl'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_FLOWCONTROL_IDX],
            QSerialPort_FlowControl_CppToPython_QSerialPort_FlowControl);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSerialPort_FlowControl_PythonToCpp_QSerialPort_FlowControl,
            is_QSerialPort_FlowControl_PythonToCpp_QSerialPort_FlowControl_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_FLOWCONTROL_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSerialPort::FlowControl");
        Shiboken::Conversions::registerConverterName(converter, "FlowControl");
    }
    // End of 'FlowControl' enum.

    // Initialization of enum 'PinoutSignal'.
    SbkPySide2_QtSerialPortTypes[SBK_QFLAGS_QSERIALPORT_PINOUTSIGNAL_IDX] = PySide::QFlags::create("2:PySide2.QtSerialPort.QSerialPort.PinoutSignals", SbkPySide2_QtSerialPort_QSerialPort_PinoutSignal_number_slots);
    SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_PINOUTSIGNAL_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSerialPort_TypeF(),
        "PinoutSignal",
        "2:PySide2.QtSerialPort.QSerialPort.PinoutSignal",
        "QSerialPort::PinoutSignal",
        SbkPySide2_QtSerialPortTypes[SBK_QFLAGS_QSERIALPORT_PINOUTSIGNAL_IDX]);
    if (!SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_PINOUTSIGNAL_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_PINOUTSIGNAL_IDX],
        Sbk_QSerialPort_TypeF(), "NoSignal", (long) QSerialPort::PinoutSignal::NoSignal))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_PINOUTSIGNAL_IDX],
        Sbk_QSerialPort_TypeF(), "TransmittedDataSignal", (long) QSerialPort::PinoutSignal::TransmittedDataSignal))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_PINOUTSIGNAL_IDX],
        Sbk_QSerialPort_TypeF(), "ReceivedDataSignal", (long) QSerialPort::PinoutSignal::ReceivedDataSignal))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_PINOUTSIGNAL_IDX],
        Sbk_QSerialPort_TypeF(), "DataTerminalReadySignal", (long) QSerialPort::PinoutSignal::DataTerminalReadySignal))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_PINOUTSIGNAL_IDX],
        Sbk_QSerialPort_TypeF(), "DataCarrierDetectSignal", (long) QSerialPort::PinoutSignal::DataCarrierDetectSignal))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_PINOUTSIGNAL_IDX],
        Sbk_QSerialPort_TypeF(), "DataSetReadySignal", (long) QSerialPort::PinoutSignal::DataSetReadySignal))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_PINOUTSIGNAL_IDX],
        Sbk_QSerialPort_TypeF(), "RingIndicatorSignal", (long) QSerialPort::PinoutSignal::RingIndicatorSignal))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_PINOUTSIGNAL_IDX],
        Sbk_QSerialPort_TypeF(), "RequestToSendSignal", (long) QSerialPort::PinoutSignal::RequestToSendSignal))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_PINOUTSIGNAL_IDX],
        Sbk_QSerialPort_TypeF(), "ClearToSendSignal", (long) QSerialPort::PinoutSignal::ClearToSendSignal))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_PINOUTSIGNAL_IDX],
        Sbk_QSerialPort_TypeF(), "SecondaryTransmittedDataSignal", (long) QSerialPort::PinoutSignal::SecondaryTransmittedDataSignal))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_PINOUTSIGNAL_IDX],
        Sbk_QSerialPort_TypeF(), "SecondaryReceivedDataSignal", (long) QSerialPort::PinoutSignal::SecondaryReceivedDataSignal))
        return;
    // Register converter for enum 'QSerialPort::PinoutSignal'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_PINOUTSIGNAL_IDX],
            QSerialPort_PinoutSignal_CppToPython_QSerialPort_PinoutSignal);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSerialPort_PinoutSignal_PythonToCpp_QSerialPort_PinoutSignal,
            is_QSerialPort_PinoutSignal_PythonToCpp_QSerialPort_PinoutSignal_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_PINOUTSIGNAL_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSerialPort::PinoutSignal");
        Shiboken::Conversions::registerConverterName(converter, "PinoutSignal");
    }
    // Register converter for flag 'QFlags<QSerialPort::PinoutSignal>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtSerialPortTypes[SBK_QFLAGS_QSERIALPORT_PINOUTSIGNAL_IDX],
            QFlags_QSerialPort_PinoutSignal__CppToPython_QFlags_QSerialPort_PinoutSignal_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSerialPort_PinoutSignal_PythonToCpp_QFlags_QSerialPort_PinoutSignal_,
            is_QSerialPort_PinoutSignal_PythonToCpp_QFlags_QSerialPort_PinoutSignal__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QSerialPort_PinoutSignal__PythonToCpp_QFlags_QSerialPort_PinoutSignal_,
            is_QFlags_QSerialPort_PinoutSignal__PythonToCpp_QFlags_QSerialPort_PinoutSignal__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QSerialPort_PinoutSignal_,
            is_number_PythonToCpp_QFlags_QSerialPort_PinoutSignal__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtSerialPortTypes[SBK_QFLAGS_QSERIALPORT_PINOUTSIGNAL_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSerialPort::PinoutSignals");
        Shiboken::Conversions::registerConverterName(converter, "PinoutSignals");
    }
    // End of 'PinoutSignal' enum/flags.

    // Initialization of enum 'DataErrorPolicy'.
    SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_DATAERRORPOLICY_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSerialPort_TypeF(),
        "DataErrorPolicy",
        "2:PySide2.QtSerialPort.QSerialPort.DataErrorPolicy",
        "QSerialPort::DataErrorPolicy");
    if (!SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_DATAERRORPOLICY_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_DATAERRORPOLICY_IDX],
        Sbk_QSerialPort_TypeF(), "SkipPolicy", (long) QSerialPort::DataErrorPolicy::SkipPolicy))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_DATAERRORPOLICY_IDX],
        Sbk_QSerialPort_TypeF(), "PassZeroPolicy", (long) QSerialPort::DataErrorPolicy::PassZeroPolicy))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_DATAERRORPOLICY_IDX],
        Sbk_QSerialPort_TypeF(), "IgnorePolicy", (long) QSerialPort::DataErrorPolicy::IgnorePolicy))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_DATAERRORPOLICY_IDX],
        Sbk_QSerialPort_TypeF(), "StopReceivingPolicy", (long) QSerialPort::DataErrorPolicy::StopReceivingPolicy))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_DATAERRORPOLICY_IDX],
        Sbk_QSerialPort_TypeF(), "UnknownPolicy", (long) QSerialPort::DataErrorPolicy::UnknownPolicy))
        return;
    // Register converter for enum 'QSerialPort::DataErrorPolicy'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_DATAERRORPOLICY_IDX],
            QSerialPort_DataErrorPolicy_CppToPython_QSerialPort_DataErrorPolicy);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSerialPort_DataErrorPolicy_PythonToCpp_QSerialPort_DataErrorPolicy,
            is_QSerialPort_DataErrorPolicy_PythonToCpp_QSerialPort_DataErrorPolicy_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_DATAERRORPOLICY_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSerialPort::DataErrorPolicy");
        Shiboken::Conversions::registerConverterName(converter, "DataErrorPolicy");
    }
    // End of 'DataErrorPolicy' enum.

    // Initialization of enum 'SerialPortError'.
    SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_SERIALPORTERROR_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSerialPort_TypeF(),
        "SerialPortError",
        "2:PySide2.QtSerialPort.QSerialPort.SerialPortError",
        "QSerialPort::SerialPortError");
    if (!SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_SERIALPORTERROR_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_SERIALPORTERROR_IDX],
        Sbk_QSerialPort_TypeF(), "NoError", (long) QSerialPort::SerialPortError::NoError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_SERIALPORTERROR_IDX],
        Sbk_QSerialPort_TypeF(), "DeviceNotFoundError", (long) QSerialPort::SerialPortError::DeviceNotFoundError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_SERIALPORTERROR_IDX],
        Sbk_QSerialPort_TypeF(), "PermissionError", (long) QSerialPort::SerialPortError::PermissionError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_SERIALPORTERROR_IDX],
        Sbk_QSerialPort_TypeF(), "OpenError", (long) QSerialPort::SerialPortError::OpenError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_SERIALPORTERROR_IDX],
        Sbk_QSerialPort_TypeF(), "ParityError", (long) QSerialPort::SerialPortError::ParityError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_SERIALPORTERROR_IDX],
        Sbk_QSerialPort_TypeF(), "FramingError", (long) QSerialPort::SerialPortError::FramingError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_SERIALPORTERROR_IDX],
        Sbk_QSerialPort_TypeF(), "BreakConditionError", (long) QSerialPort::SerialPortError::BreakConditionError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_SERIALPORTERROR_IDX],
        Sbk_QSerialPort_TypeF(), "WriteError", (long) QSerialPort::SerialPortError::WriteError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_SERIALPORTERROR_IDX],
        Sbk_QSerialPort_TypeF(), "ReadError", (long) QSerialPort::SerialPortError::ReadError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_SERIALPORTERROR_IDX],
        Sbk_QSerialPort_TypeF(), "ResourceError", (long) QSerialPort::SerialPortError::ResourceError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_SERIALPORTERROR_IDX],
        Sbk_QSerialPort_TypeF(), "UnsupportedOperationError", (long) QSerialPort::SerialPortError::UnsupportedOperationError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_SERIALPORTERROR_IDX],
        Sbk_QSerialPort_TypeF(), "UnknownError", (long) QSerialPort::SerialPortError::UnknownError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_SERIALPORTERROR_IDX],
        Sbk_QSerialPort_TypeF(), "TimeoutError", (long) QSerialPort::SerialPortError::TimeoutError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_SERIALPORTERROR_IDX],
        Sbk_QSerialPort_TypeF(), "NotOpenError", (long) QSerialPort::SerialPortError::NotOpenError))
        return;
    // Register converter for enum 'QSerialPort::SerialPortError'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_SERIALPORTERROR_IDX],
            QSerialPort_SerialPortError_CppToPython_QSerialPort_SerialPortError);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSerialPort_SerialPortError_PythonToCpp_QSerialPort_SerialPortError,
            is_QSerialPort_SerialPortError_PythonToCpp_QSerialPort_SerialPortError_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtSerialPortTypes[SBK_QSERIALPORT_SERIALPORTERROR_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSerialPort::SerialPortError");
        Shiboken::Conversions::registerConverterName(converter, "SerialPortError");
    }
    // End of 'SerialPortError' enum.

    PySide::Signal::registerSignals(Sbk_QSerialPort_TypeF(), &::QSerialPort::staticMetaObject);
    qRegisterMetaType< ::QSerialPort::Direction >("QSerialPort::Direction");
    qRegisterMetaType< ::QSerialPort::Directions >("QSerialPort::Directions");
    qRegisterMetaType< ::QSerialPort::BaudRate >("QSerialPort::BaudRate");
    qRegisterMetaType< ::QSerialPort::DataBits >("QSerialPort::DataBits");
    qRegisterMetaType< ::QSerialPort::Parity >("QSerialPort::Parity");
    qRegisterMetaType< ::QSerialPort::StopBits >("QSerialPort::StopBits");
    qRegisterMetaType< ::QSerialPort::FlowControl >("QSerialPort::FlowControl");
    qRegisterMetaType< ::QSerialPort::PinoutSignal >("QSerialPort::PinoutSignal");
    qRegisterMetaType< ::QSerialPort::PinoutSignals >("QSerialPort::PinoutSignals");
    qRegisterMetaType< ::QSerialPort::DataErrorPolicy >("QSerialPort::DataErrorPolicy");
    qRegisterMetaType< ::QSerialPort::SerialPortError >("QSerialPort::SerialPortError");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QSerialPort_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QSerialPort_TypeF(), &::QSerialPort::staticMetaObject, sizeof(QSerialPortWrapper));
}
