/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtsql_python.h"

// main header
#include "qsqldrivercreatorbase_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QSqlDriverCreatorBaseWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QSqlDriverCreatorBaseWrapper::QSqlDriverCreatorBaseWrapper() : QSqlDriverCreatorBase()
{
    resetPyMethodCache();
    // ... middle
}

::QSqlDriver * QSqlDriverCreatorBaseWrapper::createObject() const
{
    if (m_PyMethodCache[0]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSqlDriverCreatorBase.createObject()' not implemented.");
        return nullptr;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "createObject";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSqlDriverCreatorBase.createObject()' not implemented.");
        return nullptr;
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSqlDriverCreatorBase.createObject", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QSqlDriver >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QSqlDriver *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

QSqlDriverCreatorBaseWrapper::~QSqlDriverCreatorBaseWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QSqlDriverCreatorBase_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
    SbkObjectType *type = reinterpret_cast<SbkObjectType *>(self->ob_type);
    SbkObjectType *myType = reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVERCREATORBASE_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QSqlDriverCreatorBase' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QSqlDriverCreatorBase >()))
        return -1;

    ::QSqlDriverCreatorBaseWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDriverCreatorBase.__init__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // QSqlDriverCreatorBase()
            cptr = new ::QSqlDriverCreatorBaseWrapper();
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QSqlDriverCreatorBase >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_QSqlDriverCreatorBaseFunc_createObject(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlDriverCreatorBase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVERCREATORBASE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlDriverCreatorBase.createObject";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // createObject()const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSqlDriverCreatorBase.createObject()' not implemented.");
                return {};
            }
            QSqlDriver * cppResult = const_cast<const ::QSqlDriverCreatorBase *>(cppSelf)->createObject();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVER_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QSqlDriverCreatorBase_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QSqlDriverCreatorBase_methods[] = {
    {"createObject", reinterpret_cast<PyCFunction>(Sbk_QSqlDriverCreatorBaseFunc_createObject), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QSqlDriverCreatorBase_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QSqlDriverCreatorBase *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLDRIVERCREATORBASE_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QSqlDriverCreatorBaseWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QSqlDriverCreatorBase_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QSqlDriverCreatorBase_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QSqlDriverCreatorBase_Type = nullptr;
static SbkObjectType *Sbk_QSqlDriverCreatorBase_TypeF(void)
{
    return _Sbk_QSqlDriverCreatorBase_Type;
}

static PyType_Slot Sbk_QSqlDriverCreatorBase_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QSqlDriverCreatorBase_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QSqlDriverCreatorBase_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QSqlDriverCreatorBase_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QSqlDriverCreatorBase_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QSqlDriverCreatorBase_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QSqlDriverCreatorBase_spec = {
    "2:PySide2.QtSql.QSqlDriverCreatorBase",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QSqlDriverCreatorBase_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QSqlDriverCreatorBase_PythonToCpp_QSqlDriverCreatorBase_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QSqlDriverCreatorBase_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QSqlDriverCreatorBase_PythonToCpp_QSqlDriverCreatorBase_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QSqlDriverCreatorBase_TypeF())))
        return QSqlDriverCreatorBase_PythonToCpp_QSqlDriverCreatorBase_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QSqlDriverCreatorBase_PTR_CppToPython_QSqlDriverCreatorBase(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QSqlDriverCreatorBase *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QSqlDriverCreatorBase_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QSqlDriverCreatorBase_SignatureStrings[] = {
    "PySide2.QtSql.QSqlDriverCreatorBase(self)",
    "PySide2.QtSql.QSqlDriverCreatorBase.createObject(self)->PySide2.QtSql.QSqlDriver",
    nullptr}; // Sentinel

void init_QSqlDriverCreatorBase(PyObject *module)
{
    _Sbk_QSqlDriverCreatorBase_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QSqlDriverCreatorBase",
        "QSqlDriverCreatorBase*",
        &Sbk_QSqlDriverCreatorBase_spec,
        &Shiboken::callCppDestructor< ::QSqlDriverCreatorBase >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QSqlDriverCreatorBase_Type);
    InitSignatureStrings(pyType, QSqlDriverCreatorBase_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QSqlDriverCreatorBase_Type), Sbk_QSqlDriverCreatorBase_PropertyStrings);
    SbkPySide2_QtSqlTypes[SBK_QSQLDRIVERCREATORBASE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QSqlDriverCreatorBase_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QSqlDriverCreatorBase_TypeF(),
        QSqlDriverCreatorBase_PythonToCpp_QSqlDriverCreatorBase_PTR,
        is_QSqlDriverCreatorBase_PythonToCpp_QSqlDriverCreatorBase_PTR_Convertible,
        QSqlDriverCreatorBase_PTR_CppToPython_QSqlDriverCreatorBase);

    Shiboken::Conversions::registerConverterName(converter, "QSqlDriverCreatorBase");
    Shiboken::Conversions::registerConverterName(converter, "QSqlDriverCreatorBase*");
    Shiboken::Conversions::registerConverterName(converter, "QSqlDriverCreatorBase&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QSqlDriverCreatorBase).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QSqlDriverCreatorBaseWrapper).name());


}
