/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtsql_python.h"

// main header
#include "qsqlrecord_wrapper.h"

// inner classes

// Extra includes
#include <QSqlField>
#include <QtSql/qsqlfield.h>
#include <QtSql/qsqlrecord.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QSqlRecord_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QSqlRecord >()))
        return -1;

    ::QSqlRecord *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlRecord.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QSqlRecord", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QSqlRecord::QSqlRecord()
    // 1: QSqlRecord::QSqlRecord(QSqlRecord)
    if (numArgs == 0) {
        overloadId = 0; // QSqlRecord()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSqlTypes[SBK_QSQLRECORD_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QSqlRecord(QSqlRecord)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSqlRecord_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QSqlRecord()
        {

            if (!PyErr_Occurred()) {
                // QSqlRecord()
                cptr = new ::QSqlRecord();
            }
            break;
        }
        case 1: // QSqlRecord(const QSqlRecord & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QSqlRecord cppArg0_local;
            ::QSqlRecord *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSqlTypes[SBK_QSQLRECORD_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QSqlRecord(QSqlRecord)
                cptr = new ::QSqlRecord(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QSqlRecord >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QSqlRecord_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QSqlRecord_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QSqlRecordFunc_append(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlRecord *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLRECORD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlRecord.append";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSqlRecord::append(QSqlField)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSqlTypes[SBK_QSQLFIELD_IDX]), (pyArg)))) {
        overloadId = 0; // append(QSqlField)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSqlRecordFunc_append_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QSqlField cppArg0_local;
        ::QSqlField *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSqlTypes[SBK_QSQLFIELD_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // append(QSqlField)
            cppSelf->append(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSqlRecordFunc_append_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSqlRecordFunc_clear(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlRecord *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLRECORD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlRecord.clear";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clear()
            cppSelf->clear();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QSqlRecordFunc_clearValues(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlRecord *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLRECORD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlRecord.clearValues";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clearValues()
            cppSelf->clearValues();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QSqlRecordFunc_contains(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlRecord *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLRECORD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlRecord.contains";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSqlRecord::contains(QString)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // contains(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSqlRecordFunc_contains_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // contains(QString)const
            bool cppResult = const_cast<const ::QSqlRecord *>(cppSelf)->contains(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSqlRecordFunc_contains_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSqlRecordFunc_count(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlRecord *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLRECORD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlRecord.count";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // count()const
            int cppResult = const_cast<const ::QSqlRecord *>(cppSelf)->count();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSqlRecordFunc_field(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlRecord *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLRECORD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlRecord.field";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSqlRecord::field(QString)const
    // 1: QSqlRecord::field(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 1; // field(int)const
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // field(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSqlRecordFunc_field_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // field(const QString & name) const
        {
            ::QString cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // field(QString)const
                QSqlField cppResult = const_cast<const ::QSqlRecord *>(cppSelf)->field(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSqlTypes[SBK_QSQLFIELD_IDX]), &cppResult);
            }
            break;
        }
        case 1: // field(int i) const
        {
            int cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // field(int)const
                QSqlField cppResult = const_cast<const ::QSqlRecord *>(cppSelf)->field(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSqlTypes[SBK_QSQLFIELD_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSqlRecordFunc_field_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSqlRecordFunc_fieldName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlRecord *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLRECORD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlRecord.fieldName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSqlRecord::fieldName(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // fieldName(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSqlRecordFunc_fieldName_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // fieldName(int)const
            QString cppResult = const_cast<const ::QSqlRecord *>(cppSelf)->fieldName(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSqlRecordFunc_fieldName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSqlRecordFunc_indexOf(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlRecord *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLRECORD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlRecord.indexOf";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSqlRecord::indexOf(QString)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // indexOf(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSqlRecordFunc_indexOf_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // indexOf(QString)const
            int cppResult = const_cast<const ::QSqlRecord *>(cppSelf)->indexOf(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSqlRecordFunc_indexOf_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSqlRecordFunc_insert(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlRecord *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLRECORD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlRecord.insert";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "insert", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QSqlRecord::insert(int,QSqlField)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSqlTypes[SBK_QSQLFIELD_IDX]), (pyArgs[1])))) {
        overloadId = 0; // insert(int,QSqlField)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSqlRecordFunc_insert_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QSqlField cppArg1_local;
        ::QSqlField *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSqlTypes[SBK_QSQLFIELD_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (!PyErr_Occurred()) {
            // insert(int,QSqlField)
            cppSelf->insert(cppArg0, *cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSqlRecordFunc_insert_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSqlRecordFunc_isEmpty(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlRecord *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLRECORD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlRecord.isEmpty";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isEmpty()const
            bool cppResult = const_cast<const ::QSqlRecord *>(cppSelf)->isEmpty();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSqlRecordFunc_isGenerated(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlRecord *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLRECORD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlRecord.isGenerated";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSqlRecord::isGenerated(QString)const
    // 1: QSqlRecord::isGenerated(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 1; // isGenerated(int)const
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // isGenerated(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSqlRecordFunc_isGenerated_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // isGenerated(const QString & name) const
        {
            ::QString cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // isGenerated(QString)const
                bool cppResult = const_cast<const ::QSqlRecord *>(cppSelf)->isGenerated(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // isGenerated(int i) const
        {
            int cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // isGenerated(int)const
                bool cppResult = const_cast<const ::QSqlRecord *>(cppSelf)->isGenerated(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSqlRecordFunc_isGenerated_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSqlRecordFunc_isNull(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlRecord *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLRECORD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlRecord.isNull";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSqlRecord::isNull(QString)const
    // 1: QSqlRecord::isNull(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 1; // isNull(int)const
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // isNull(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSqlRecordFunc_isNull_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // isNull(const QString & name) const
        {
            ::QString cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // isNull(QString)const
                bool cppResult = const_cast<const ::QSqlRecord *>(cppSelf)->isNull(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // isNull(int i) const
        {
            int cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // isNull(int)const
                bool cppResult = const_cast<const ::QSqlRecord *>(cppSelf)->isNull(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSqlRecordFunc_isNull_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSqlRecordFunc_keyValues(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlRecord *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLRECORD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlRecord.keyValues";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSqlRecord::keyValues(QSqlRecord)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSqlTypes[SBK_QSQLRECORD_IDX]), (pyArg)))) {
        overloadId = 0; // keyValues(QSqlRecord)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSqlRecordFunc_keyValues_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QSqlRecord cppArg0_local;
        ::QSqlRecord *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSqlTypes[SBK_QSQLRECORD_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // keyValues(QSqlRecord)const
            QSqlRecord cppResult = const_cast<const ::QSqlRecord *>(cppSelf)->keyValues(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSqlTypes[SBK_QSQLRECORD_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSqlRecordFunc_keyValues_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSqlRecordFunc_remove(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlRecord *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLRECORD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlRecord.remove";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSqlRecord::remove(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // remove(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSqlRecordFunc_remove_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // remove(int)
            cppSelf->remove(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSqlRecordFunc_remove_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSqlRecordFunc_replace(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlRecord *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLRECORD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlRecord.replace";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "replace", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QSqlRecord::replace(int,QSqlField)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSqlTypes[SBK_QSQLFIELD_IDX]), (pyArgs[1])))) {
        overloadId = 0; // replace(int,QSqlField)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSqlRecordFunc_replace_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QSqlField cppArg1_local;
        ::QSqlField *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSqlTypes[SBK_QSQLFIELD_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (!PyErr_Occurred()) {
            // replace(int,QSqlField)
            cppSelf->replace(cppArg0, *cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSqlRecordFunc_replace_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSqlRecordFunc_setGenerated(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlRecord *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLRECORD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlRecord.setGenerated";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setGenerated", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QSqlRecord::setGenerated(QString,bool)
    // 1: QSqlRecord::setGenerated(int,bool)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
        overloadId = 1; // setGenerated(int,bool)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
        overloadId = 0; // setGenerated(QString,bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSqlRecordFunc_setGenerated_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setGenerated(const QString & name, bool generated)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            bool cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setGenerated(QString,bool)
                cppSelf->setGenerated(cppArg0, cppArg1);
            }
            break;
        }
        case 1: // setGenerated(int i, bool generated)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            bool cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setGenerated(int,bool)
                cppSelf->setGenerated(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSqlRecordFunc_setGenerated_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSqlRecordFunc_setNull(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlRecord *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLRECORD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlRecord.setNull";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSqlRecord::setNull(QString)
    // 1: QSqlRecord::setNull(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 1; // setNull(int)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setNull(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSqlRecordFunc_setNull_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setNull(const QString & name)
        {
            ::QString cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // setNull(QString)
                cppSelf->setNull(cppArg0);
            }
            break;
        }
        case 1: // setNull(int i)
        {
            int cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // setNull(int)
                cppSelf->setNull(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSqlRecordFunc_setNull_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSqlRecordFunc_setValue(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlRecord *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLRECORD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlRecord.setValue";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setValue", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QSqlRecord::setValue(QString,QVariant)
    // 1: QSqlRecord::setValue(int,QVariant)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArgs[1])))) {
        overloadId = 1; // setValue(int,QVariant)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArgs[1])))) {
        overloadId = 0; // setValue(QString,QVariant)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSqlRecordFunc_setValue_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setValue(const QString & name, const QVariant & val)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QVariant cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setValue(QString,QVariant)
                cppSelf->setValue(cppArg0, cppArg1);
            }
            break;
        }
        case 1: // setValue(int i, const QVariant & val)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QVariant cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setValue(int,QVariant)
                cppSelf->setValue(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSqlRecordFunc_setValue_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSqlRecordFunc_value(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlRecord *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLRECORD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtSql.QSqlRecord.value";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSqlRecord::value(QString)const
    // 1: QSqlRecord::value(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 1; // value(int)const
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // value(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSqlRecordFunc_value_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // value(const QString & name) const
        {
            ::QString cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // value(QString)const
                QVariant cppResult = const_cast<const ::QSqlRecord *>(cppSelf)->value(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppResult);
            }
            break;
        }
        case 1: // value(int i) const
        {
            int cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // value(int)const
                QVariant cppResult = const_cast<const ::QSqlRecord *>(cppSelf)->value(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSqlRecordFunc_value_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSqlRecord___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QSqlRecord *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLRECORD_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSqlTypes[SBK_QSQLRECORD_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QSqlRecord_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QSqlRecord_methods[] = {
    {"append", reinterpret_cast<PyCFunction>(Sbk_QSqlRecordFunc_append), METH_O},
    {"clear", reinterpret_cast<PyCFunction>(Sbk_QSqlRecordFunc_clear), METH_NOARGS},
    {"clearValues", reinterpret_cast<PyCFunction>(Sbk_QSqlRecordFunc_clearValues), METH_NOARGS},
    {"contains", reinterpret_cast<PyCFunction>(Sbk_QSqlRecordFunc_contains), METH_O},
    {"count", reinterpret_cast<PyCFunction>(Sbk_QSqlRecordFunc_count), METH_NOARGS},
    {"field", reinterpret_cast<PyCFunction>(Sbk_QSqlRecordFunc_field), METH_O},
    {"fieldName", reinterpret_cast<PyCFunction>(Sbk_QSqlRecordFunc_fieldName), METH_O},
    {"indexOf", reinterpret_cast<PyCFunction>(Sbk_QSqlRecordFunc_indexOf), METH_O},
    {"insert", reinterpret_cast<PyCFunction>(Sbk_QSqlRecordFunc_insert), METH_VARARGS},
    {"isEmpty", reinterpret_cast<PyCFunction>(Sbk_QSqlRecordFunc_isEmpty), METH_NOARGS},
    {"isGenerated", reinterpret_cast<PyCFunction>(Sbk_QSqlRecordFunc_isGenerated), METH_O},
    {"isNull", reinterpret_cast<PyCFunction>(Sbk_QSqlRecordFunc_isNull), METH_O},
    {"keyValues", reinterpret_cast<PyCFunction>(Sbk_QSqlRecordFunc_keyValues), METH_O},
    {"remove", reinterpret_cast<PyCFunction>(Sbk_QSqlRecordFunc_remove), METH_O},
    {"replace", reinterpret_cast<PyCFunction>(Sbk_QSqlRecordFunc_replace), METH_VARARGS},
    {"setGenerated", reinterpret_cast<PyCFunction>(Sbk_QSqlRecordFunc_setGenerated), METH_VARARGS},
    {"setNull", reinterpret_cast<PyCFunction>(Sbk_QSqlRecordFunc_setNull), METH_O},
    {"setValue", reinterpret_cast<PyCFunction>(Sbk_QSqlRecordFunc_setValue), METH_VARARGS},
    {"value", reinterpret_cast<PyCFunction>(Sbk_QSqlRecordFunc_value), METH_O},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QSqlRecord___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_QSqlRecord_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QSqlRecord *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLRECORD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSqlTypes[SBK_QSQLRECORD_IDX]), (pyArg)))) {
                // operator!=(const QSqlRecord & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QSqlRecord cppArg0_local;
                ::QSqlRecord *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSqlTypes[SBK_QSQLRECORD_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSqlTypes[SBK_QSQLRECORD_IDX]), (pyArg)))) {
                // operator==(const QSqlRecord & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QSqlRecord cppArg0_local;
                ::QSqlRecord *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtSqlTypes[SBK_QSQLRECORD_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QSqlRecord_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QSqlRecord_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QSqlRecord_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QSqlRecord_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
extern "C"
{
static PyObject *Sbk_QSqlRecord__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSqlRecord *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLRECORD_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << *cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    int idx = str.indexOf('(');
    if (idx >= 0)
        str.replace(0, idx, Py_TYPE(self)->tp_name);
    str = str.trimmed();
    PyObject *mod = PyDict_GetItem(Py_TYPE(self)->tp_dict, Shiboken::PyMagicName::module());
    if (mod && !strchr(str, '.'))
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    else
        return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C

// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QSqlRecord_Type = nullptr;
static SbkObjectType *Sbk_QSqlRecord_TypeF(void)
{
    return _Sbk_QSqlRecord_Type;
}

static PyType_Slot Sbk_QSqlRecord_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QSqlRecord__repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QSqlRecord_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QSqlRecord_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QSqlRecord_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QSqlRecord_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QSqlRecord_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QSqlRecord_spec = {
    "2:PySide2.QtSql.QSqlRecord",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QSqlRecord_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QSqlRecord_PythonToCpp_QSqlRecord_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QSqlRecord_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QSqlRecord_PythonToCpp_QSqlRecord_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QSqlRecord_TypeF())))
        return QSqlRecord_PythonToCpp_QSqlRecord_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QSqlRecord_PTR_CppToPython_QSqlRecord(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QSqlRecord *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QSqlRecord_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QSqlRecord_COPY_CppToPython_QSqlRecord(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QSqlRecord_TypeF(), new ::QSqlRecord(*reinterpret_cast<const ::QSqlRecord *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QSqlRecord_PythonToCpp_QSqlRecord_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSqlRecord *>(cppOut) = *reinterpret_cast< ::QSqlRecord *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtSqlTypes[SBK_QSQLRECORD_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QSqlRecord_PythonToCpp_QSqlRecord_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QSqlRecord_TypeF())))
        return QSqlRecord_PythonToCpp_QSqlRecord_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QSqlRecord_SignatureStrings[] = {
    "1:PySide2.QtSql.QSqlRecord(self)",
    "0:PySide2.QtSql.QSqlRecord(self,other:PySide2.QtSql.QSqlRecord)",
    "PySide2.QtSql.QSqlRecord.append(self,field:PySide2.QtSql.QSqlField)",
    "PySide2.QtSql.QSqlRecord.clear(self)",
    "PySide2.QtSql.QSqlRecord.clearValues(self)",
    "PySide2.QtSql.QSqlRecord.contains(self,name:QString)->bool",
    "PySide2.QtSql.QSqlRecord.count(self)->int",
    "1:PySide2.QtSql.QSqlRecord.field(self,name:QString)->PySide2.QtSql.QSqlField",
    "0:PySide2.QtSql.QSqlRecord.field(self,i:int)->PySide2.QtSql.QSqlField",
    "PySide2.QtSql.QSqlRecord.fieldName(self,i:int)->QString",
    "PySide2.QtSql.QSqlRecord.indexOf(self,name:QString)->int",
    "PySide2.QtSql.QSqlRecord.insert(self,pos:int,field:PySide2.QtSql.QSqlField)",
    "PySide2.QtSql.QSqlRecord.isEmpty(self)->bool",
    "1:PySide2.QtSql.QSqlRecord.isGenerated(self,name:QString)->bool",
    "0:PySide2.QtSql.QSqlRecord.isGenerated(self,i:int)->bool",
    "1:PySide2.QtSql.QSqlRecord.isNull(self,name:QString)->bool",
    "0:PySide2.QtSql.QSqlRecord.isNull(self,i:int)->bool",
    "PySide2.QtSql.QSqlRecord.keyValues(self,keyFields:PySide2.QtSql.QSqlRecord)->PySide2.QtSql.QSqlRecord",
    "PySide2.QtSql.QSqlRecord.remove(self,pos:int)",
    "PySide2.QtSql.QSqlRecord.replace(self,pos:int,field:PySide2.QtSql.QSqlField)",
    "1:PySide2.QtSql.QSqlRecord.setGenerated(self,name:QString,generated:bool)",
    "0:PySide2.QtSql.QSqlRecord.setGenerated(self,i:int,generated:bool)",
    "1:PySide2.QtSql.QSqlRecord.setNull(self,name:QString)",
    "0:PySide2.QtSql.QSqlRecord.setNull(self,i:int)",
    "1:PySide2.QtSql.QSqlRecord.setValue(self,name:QString,val:QVariant)",
    "0:PySide2.QtSql.QSqlRecord.setValue(self,i:int,val:QVariant)",
    "1:PySide2.QtSql.QSqlRecord.value(self,name:QString)->QVariant",
    "0:PySide2.QtSql.QSqlRecord.value(self,i:int)->QVariant",
    "PySide2.QtSql.QSqlRecord.__copy__()",
    nullptr}; // Sentinel

void init_QSqlRecord(PyObject *module)
{
    _Sbk_QSqlRecord_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QSqlRecord",
        "QSqlRecord",
        &Sbk_QSqlRecord_spec,
        &Shiboken::callCppDestructor< ::QSqlRecord >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QSqlRecord_Type);
    InitSignatureStrings(pyType, QSqlRecord_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QSqlRecord_Type), Sbk_QSqlRecord_PropertyStrings);
    SbkPySide2_QtSqlTypes[SBK_QSQLRECORD_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QSqlRecord_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QSqlRecord_TypeF(),
        QSqlRecord_PythonToCpp_QSqlRecord_PTR,
        is_QSqlRecord_PythonToCpp_QSqlRecord_PTR_Convertible,
        QSqlRecord_PTR_CppToPython_QSqlRecord,
        QSqlRecord_COPY_CppToPython_QSqlRecord);

    Shiboken::Conversions::registerConverterName(converter, "QSqlRecord");
    Shiboken::Conversions::registerConverterName(converter, "QSqlRecord*");
    Shiboken::Conversions::registerConverterName(converter, "QSqlRecord&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QSqlRecord).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QSqlRecord_PythonToCpp_QSqlRecord_COPY,
        is_QSqlRecord_PythonToCpp_QSqlRecord_COPY_Convertible);

    qRegisterMetaType< ::QSqlRecord >("QSqlRecord");
}
