/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qttexttospeech_python.h"

// main header
#include "qvoice_wrapper.h"

// inner classes

// Extra includes
#include <QtTextToSpeech/qvoice.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QVoice_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QVoice >()))
        return -1;

    ::QVoice *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTextToSpeech.QVoice.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QVoice", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QVoice::QVoice()
    // 1: QVoice::QVoice(QVoice)
    if (numArgs == 0) {
        overloadId = 0; // QVoice()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtTextToSpeechTypes[SBK_QVOICE_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QVoice(QVoice)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QVoice_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QVoice()
        {

            if (!PyErr_Occurred()) {
                // QVoice()
                cptr = new ::QVoice();
            }
            break;
        }
        case 1: // QVoice(const QVoice & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QVoice cppArg0_local;
            ::QVoice *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtTextToSpeechTypes[SBK_QVOICE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QVoice(QVoice)
                cptr = new ::QVoice(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QVoice >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QVoice_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QVoice_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QVoiceFunc_age(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVoice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtTextToSpeechTypes[SBK_QVOICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTextToSpeech.QVoice.age";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // age()const
            QVoice::Age cppResult = const_cast<const ::QVoice *>(cppSelf)->age();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtTextToSpeechTypes[SBK_QVOICE_AGE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVoiceFunc_ageName(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTextToSpeech.QVoice.ageName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QVoice::ageName(QVoice::Age)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtTextToSpeechTypes[SBK_QVOICE_AGE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // ageName(QVoice::Age)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QVoiceFunc_ageName_TypeError;

    // Call function/method
    {
        ::QVoice::Age cppArg0{QVoice::Child};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // ageName(QVoice::Age)
            QString cppResult = ::QVoice::ageName(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QVoiceFunc_ageName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QVoiceFunc_gender(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVoice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtTextToSpeechTypes[SBK_QVOICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTextToSpeech.QVoice.gender";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // gender()const
            QVoice::Gender cppResult = const_cast<const ::QVoice *>(cppSelf)->gender();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtTextToSpeechTypes[SBK_QVOICE_GENDER_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVoiceFunc_genderName(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTextToSpeech.QVoice.genderName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QVoice::genderName(QVoice::Gender)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtTextToSpeechTypes[SBK_QVOICE_GENDER_IDX])->converter, (pyArg)))) {
        overloadId = 0; // genderName(QVoice::Gender)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QVoiceFunc_genderName_TypeError;

    // Call function/method
    {
        ::QVoice::Gender cppArg0{QVoice::Male};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // genderName(QVoice::Gender)
            QString cppResult = ::QVoice::genderName(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QVoiceFunc_genderName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QVoiceFunc_name(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVoice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtTextToSpeechTypes[SBK_QVOICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtTextToSpeech.QVoice.name";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // name()const
            QString cppResult = const_cast<const ::QVoice *>(cppSelf)->name();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVoice___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QVoice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtTextToSpeechTypes[SBK_QVOICE_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtTextToSpeechTypes[SBK_QVOICE_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QVoice_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QVoice_methods[] = {
    {"age", reinterpret_cast<PyCFunction>(Sbk_QVoiceFunc_age), METH_NOARGS},
    {"ageName", reinterpret_cast<PyCFunction>(Sbk_QVoiceFunc_ageName), METH_O|METH_STATIC},
    {"gender", reinterpret_cast<PyCFunction>(Sbk_QVoiceFunc_gender), METH_NOARGS},
    {"genderName", reinterpret_cast<PyCFunction>(Sbk_QVoiceFunc_genderName), METH_O|METH_STATIC},
    {"name", reinterpret_cast<PyCFunction>(Sbk_QVoiceFunc_name), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QVoice___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_QVoice_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QVoice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtTextToSpeechTypes[SBK_QVOICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtTextToSpeechTypes[SBK_QVOICE_IDX]), (pyArg)))) {
                // operator!=(const QVoice & other)
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QVoice cppArg0_local;
                ::QVoice *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtTextToSpeechTypes[SBK_QVOICE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtTextToSpeechTypes[SBK_QVOICE_IDX]), (pyArg)))) {
                // operator==(const QVoice & other)
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QVoice cppArg0_local;
                ::QVoice *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtTextToSpeechTypes[SBK_QVOICE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QVoice_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QVoice_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QVoice_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QVoice_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QVoice_Type = nullptr;
static SbkObjectType *Sbk_QVoice_TypeF(void)
{
    return _Sbk_QVoice_Type;
}

static PyType_Slot Sbk_QVoice_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QVoice_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QVoice_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QVoice_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QVoice_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QVoice_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QVoice_spec = {
    "2:PySide2.QtTextToSpeech.QVoice",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QVoice_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QVoice_Gender_PythonToCpp_QVoice_Gender(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QVoice::Gender *>(cppOut) =
        static_cast<::QVoice::Gender>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QVoice_Gender_PythonToCpp_QVoice_Gender_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtTextToSpeechTypes[SBK_QVOICE_GENDER_IDX]))
        return QVoice_Gender_PythonToCpp_QVoice_Gender;
    return {};
}
static PyObject *QVoice_Gender_CppToPython_QVoice_Gender(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QVoice::Gender *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtTextToSpeechTypes[SBK_QVOICE_GENDER_IDX], castCppIn);

}

static void QVoice_Age_PythonToCpp_QVoice_Age(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QVoice::Age *>(cppOut) =
        static_cast<::QVoice::Age>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QVoice_Age_PythonToCpp_QVoice_Age_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtTextToSpeechTypes[SBK_QVOICE_AGE_IDX]))
        return QVoice_Age_PythonToCpp_QVoice_Age;
    return {};
}
static PyObject *QVoice_Age_CppToPython_QVoice_Age(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QVoice::Age *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtTextToSpeechTypes[SBK_QVOICE_AGE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QVoice_PythonToCpp_QVoice_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QVoice_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QVoice_PythonToCpp_QVoice_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QVoice_TypeF())))
        return QVoice_PythonToCpp_QVoice_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QVoice_PTR_CppToPython_QVoice(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QVoice *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QVoice_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QVoice_COPY_CppToPython_QVoice(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QVoice_TypeF(), new ::QVoice(*reinterpret_cast<const ::QVoice *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QVoice_PythonToCpp_QVoice_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QVoice *>(cppOut) = *reinterpret_cast< ::QVoice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtTextToSpeechTypes[SBK_QVOICE_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QVoice_PythonToCpp_QVoice_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QVoice_TypeF())))
        return QVoice_PythonToCpp_QVoice_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QVoice_SignatureStrings[] = {
    "1:PySide2.QtTextToSpeech.QVoice(self)",
    "0:PySide2.QtTextToSpeech.QVoice(self,other:PySide2.QtTextToSpeech.QVoice)",
    "PySide2.QtTextToSpeech.QVoice.age(self)->PySide2.QtTextToSpeech.QVoice.Age",
    "PySide2.QtTextToSpeech.QVoice.ageName(age:PySide2.QtTextToSpeech.QVoice.Age)->QString",
    "PySide2.QtTextToSpeech.QVoice.gender(self)->PySide2.QtTextToSpeech.QVoice.Gender",
    "PySide2.QtTextToSpeech.QVoice.genderName(gender:PySide2.QtTextToSpeech.QVoice.Gender)->QString",
    "PySide2.QtTextToSpeech.QVoice.name(self)->QString",
    "PySide2.QtTextToSpeech.QVoice.__copy__()",
    nullptr}; // Sentinel

void init_QVoice(PyObject *module)
{
    _Sbk_QVoice_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QVoice",
        "QVoice",
        &Sbk_QVoice_spec,
        &Shiboken::callCppDestructor< ::QVoice >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QVoice_Type);
    InitSignatureStrings(pyType, QVoice_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QVoice_Type), Sbk_QVoice_PropertyStrings);
    SbkPySide2_QtTextToSpeechTypes[SBK_QVOICE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QVoice_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QVoice_TypeF(),
        QVoice_PythonToCpp_QVoice_PTR,
        is_QVoice_PythonToCpp_QVoice_PTR_Convertible,
        QVoice_PTR_CppToPython_QVoice,
        QVoice_COPY_CppToPython_QVoice);

    Shiboken::Conversions::registerConverterName(converter, "QVoice");
    Shiboken::Conversions::registerConverterName(converter, "QVoice*");
    Shiboken::Conversions::registerConverterName(converter, "QVoice&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QVoice).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QVoice_PythonToCpp_QVoice_COPY,
        is_QVoice_PythonToCpp_QVoice_COPY_Convertible);

    // Initialization of enums.

    // Initialization of enum 'Gender'.
    SbkPySide2_QtTextToSpeechTypes[SBK_QVOICE_GENDER_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QVoice_TypeF(),
        "Gender",
        "2:PySide2.QtTextToSpeech.QVoice.Gender",
        "QVoice::Gender");
    if (!SbkPySide2_QtTextToSpeechTypes[SBK_QVOICE_GENDER_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtTextToSpeechTypes[SBK_QVOICE_GENDER_IDX],
        Sbk_QVoice_TypeF(), "Male", (long) QVoice::Gender::Male))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtTextToSpeechTypes[SBK_QVOICE_GENDER_IDX],
        Sbk_QVoice_TypeF(), "Female", (long) QVoice::Gender::Female))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtTextToSpeechTypes[SBK_QVOICE_GENDER_IDX],
        Sbk_QVoice_TypeF(), "Unknown", (long) QVoice::Gender::Unknown))
        return;
    // Register converter for enum 'QVoice::Gender'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtTextToSpeechTypes[SBK_QVOICE_GENDER_IDX],
            QVoice_Gender_CppToPython_QVoice_Gender);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QVoice_Gender_PythonToCpp_QVoice_Gender,
            is_QVoice_Gender_PythonToCpp_QVoice_Gender_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtTextToSpeechTypes[SBK_QVOICE_GENDER_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QVoice::Gender");
        Shiboken::Conversions::registerConverterName(converter, "Gender");
    }
    // End of 'Gender' enum.

    // Initialization of enum 'Age'.
    SbkPySide2_QtTextToSpeechTypes[SBK_QVOICE_AGE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QVoice_TypeF(),
        "Age",
        "2:PySide2.QtTextToSpeech.QVoice.Age",
        "QVoice::Age");
    if (!SbkPySide2_QtTextToSpeechTypes[SBK_QVOICE_AGE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtTextToSpeechTypes[SBK_QVOICE_AGE_IDX],
        Sbk_QVoice_TypeF(), "Child", (long) QVoice::Age::Child))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtTextToSpeechTypes[SBK_QVOICE_AGE_IDX],
        Sbk_QVoice_TypeF(), "Teenager", (long) QVoice::Age::Teenager))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtTextToSpeechTypes[SBK_QVOICE_AGE_IDX],
        Sbk_QVoice_TypeF(), "Adult", (long) QVoice::Age::Adult))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtTextToSpeechTypes[SBK_QVOICE_AGE_IDX],
        Sbk_QVoice_TypeF(), "Senior", (long) QVoice::Age::Senior))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtTextToSpeechTypes[SBK_QVOICE_AGE_IDX],
        Sbk_QVoice_TypeF(), "Other", (long) QVoice::Age::Other))
        return;
    // Register converter for enum 'QVoice::Age'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtTextToSpeechTypes[SBK_QVOICE_AGE_IDX],
            QVoice_Age_CppToPython_QVoice_Age);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QVoice_Age_PythonToCpp_QVoice_Age,
            is_QVoice_Age_PythonToCpp_QVoice_Age_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtTextToSpeechTypes[SBK_QVOICE_AGE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QVoice::Age");
        Shiboken::Conversions::registerConverterName(converter, "Age");
    }
    // End of 'Age' enum.

    qRegisterMetaType< ::QVoice >("QVoice");
    qRegisterMetaType< ::QVoice::Gender >("QVoice::Gender");
    qRegisterMetaType< ::QVoice::Age >("QVoice::Age");
}
