/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtwebenginewidgets_python.h"

// main header
#include "qwebenginehistory_wrapper.h"

// inner classes

// Extra includes
#include <QList>
#include <QtWebEngineWidgets/qwebenginehistory.h>
#include <qdatastream.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static PyObject *Sbk_QWebEngineHistoryFunc_back(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineHistory *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEHISTORY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineHistory.back";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // back()
            cppSelf->back();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QWebEngineHistoryFunc_backItem(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineHistory *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEHISTORY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineHistory.backItem";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // backItem()const
            QWebEngineHistoryItem cppResult = const_cast<const ::QWebEngineHistory *>(cppSelf)->backItem();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEHISTORYITEM_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineHistoryFunc_backItems(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineHistory *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEHISTORY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineHistory.backItems";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEngineHistory::backItems(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // backItems(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineHistoryFunc_backItems_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // backItems(int)const
            QList<QWebEngineHistoryItem > cppResult = const_cast<const ::QWebEngineHistory *>(cppSelf)->backItems(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtWebEngineWidgetsTypeConverters[SBK_QTWEBENGINEWIDGETS_QLIST_QWEBENGINEHISTORYITEM_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QWebEngineHistoryFunc_backItems_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEngineHistoryFunc_canGoBack(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineHistory *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEHISTORY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineHistory.canGoBack";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // canGoBack()const
            bool cppResult = const_cast<const ::QWebEngineHistory *>(cppSelf)->canGoBack();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineHistoryFunc_canGoForward(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineHistory *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEHISTORY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineHistory.canGoForward";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // canGoForward()const
            bool cppResult = const_cast<const ::QWebEngineHistory *>(cppSelf)->canGoForward();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineHistoryFunc_clear(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineHistory *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEHISTORY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineHistory.clear";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clear()
            cppSelf->clear();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QWebEngineHistoryFunc_count(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineHistory *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEHISTORY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineHistory.count";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // count()const
            int cppResult = const_cast<const ::QWebEngineHistory *>(cppSelf)->count();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineHistoryFunc_currentItem(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineHistory *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEHISTORY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineHistory.currentItem";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // currentItem()const
            QWebEngineHistoryItem cppResult = const_cast<const ::QWebEngineHistory *>(cppSelf)->currentItem();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEHISTORYITEM_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineHistoryFunc_currentItemIndex(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineHistory *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEHISTORY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineHistory.currentItemIndex";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // currentItemIndex()const
            int cppResult = const_cast<const ::QWebEngineHistory *>(cppSelf)->currentItemIndex();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineHistoryFunc_forward(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineHistory *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEHISTORY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineHistory.forward";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // forward()
            cppSelf->forward();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QWebEngineHistoryFunc_forwardItem(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineHistory *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEHISTORY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineHistory.forwardItem";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // forwardItem()const
            QWebEngineHistoryItem cppResult = const_cast<const ::QWebEngineHistory *>(cppSelf)->forwardItem();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEHISTORYITEM_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineHistoryFunc_forwardItems(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineHistory *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEHISTORY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineHistory.forwardItems";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEngineHistory::forwardItems(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // forwardItems(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineHistoryFunc_forwardItems_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // forwardItems(int)const
            QList<QWebEngineHistoryItem > cppResult = const_cast<const ::QWebEngineHistory *>(cppSelf)->forwardItems(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtWebEngineWidgetsTypeConverters[SBK_QTWEBENGINEWIDGETS_QLIST_QWEBENGINEHISTORYITEM_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QWebEngineHistoryFunc_forwardItems_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEngineHistoryFunc_goToItem(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineHistory *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEHISTORY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineHistory.goToItem";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEngineHistory::goToItem(QWebEngineHistoryItem)
    if ((pyArg != Py_None && (pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEHISTORYITEM_IDX]), (pyArg))))) {
        overloadId = 0; // goToItem(QWebEngineHistoryItem)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineHistoryFunc_goToItem_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWebEngineHistoryItem *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // goToItem(QWebEngineHistoryItem)
            cppSelf->goToItem(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEngineHistoryFunc_goToItem_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEngineHistoryFunc_itemAt(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineHistory *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEHISTORY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineHistory.itemAt";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEngineHistory::itemAt(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // itemAt(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineHistoryFunc_itemAt_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // itemAt(int)const
            QWebEngineHistoryItem cppResult = const_cast<const ::QWebEngineHistory *>(cppSelf)->itemAt(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEHISTORYITEM_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QWebEngineHistoryFunc_itemAt_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEngineHistoryFunc_items(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineHistory *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEHISTORY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineHistory.items";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // items()const
            QList<QWebEngineHistoryItem > cppResult = const_cast<const ::QWebEngineHistory *>(cppSelf)->items();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtWebEngineWidgetsTypeConverters[SBK_QTWEBENGINEWIDGETS_QLIST_QWEBENGINEHISTORYITEM_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QWebEngineHistory_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QWebEngineHistory_methods[] = {
    {"back", reinterpret_cast<PyCFunction>(Sbk_QWebEngineHistoryFunc_back), METH_NOARGS},
    {"backItem", reinterpret_cast<PyCFunction>(Sbk_QWebEngineHistoryFunc_backItem), METH_NOARGS},
    {"backItems", reinterpret_cast<PyCFunction>(Sbk_QWebEngineHistoryFunc_backItems), METH_O},
    {"canGoBack", reinterpret_cast<PyCFunction>(Sbk_QWebEngineHistoryFunc_canGoBack), METH_NOARGS},
    {"canGoForward", reinterpret_cast<PyCFunction>(Sbk_QWebEngineHistoryFunc_canGoForward), METH_NOARGS},
    {"clear", reinterpret_cast<PyCFunction>(Sbk_QWebEngineHistoryFunc_clear), METH_NOARGS},
    {"count", reinterpret_cast<PyCFunction>(Sbk_QWebEngineHistoryFunc_count), METH_NOARGS},
    {"currentItem", reinterpret_cast<PyCFunction>(Sbk_QWebEngineHistoryFunc_currentItem), METH_NOARGS},
    {"currentItemIndex", reinterpret_cast<PyCFunction>(Sbk_QWebEngineHistoryFunc_currentItemIndex), METH_NOARGS},
    {"forward", reinterpret_cast<PyCFunction>(Sbk_QWebEngineHistoryFunc_forward), METH_NOARGS},
    {"forwardItem", reinterpret_cast<PyCFunction>(Sbk_QWebEngineHistoryFunc_forwardItem), METH_NOARGS},
    {"forwardItems", reinterpret_cast<PyCFunction>(Sbk_QWebEngineHistoryFunc_forwardItems), METH_O},
    {"goToItem", reinterpret_cast<PyCFunction>(Sbk_QWebEngineHistoryFunc_goToItem), METH_O},
    {"itemAt", reinterpret_cast<PyCFunction>(Sbk_QWebEngineHistoryFunc_itemAt), METH_O},
    {"items", reinterpret_cast<PyCFunction>(Sbk_QWebEngineHistoryFunc_items), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QWebEngineHistoryFunc___lshift__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEHISTORY_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEHISTORY_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineHistory *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEHISTORY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineHistory.__lshift__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    Shiboken::AutoDecRef attrName(Py_BuildValue("s", "__rlshift__"));
    if (!isReverse
        && Shiboken::Object::checkType(pyArg)
        && !PyObject_TypeCheck(pyArg, self->ob_type)
        && PyObject_HasAttr(pyArg, attrName)) {
        PyObject *revOpMethod = PyObject_GetAttr(pyArg, attrName);
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            pyResult = PyObject_CallFunction(revOpMethod, const_cast<char *>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(pyResult);
                pyResult = nullptr;
            }
        }
        Py_XDECREF(revOpMethod);

    }

    // Do not enter here if other object has implemented a reverse operator.
    if (!pyResult) {
        // Overloaded function decisor
        // 0: QWebEngineHistory::operator<<(QDataStream&,QWebEngineHistory)
        if (isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), (pyArg)))) {
            overloadId = 0; // operator<<(QDataStream&,QWebEngineHistory)
        }

        if (isReverse && overloadId == -1) {
            PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
            return {};
        }

        // Function signature not found.
        if (overloadId == -1) goto Sbk_QWebEngineHistoryFunc___lshift___TypeError;

        // Call function/method
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QDataStream *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator<<(QDataStream&,QWebEngineHistory) [reverse operator]
                QDataStream & cppResult = (*cppArg0) << (*cppSelf);
                pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
            }
        }

    } // End of "if (!pyResult)"

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QWebEngineHistoryFunc___lshift___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEngineHistoryFunc___rshift__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEHISTORY_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEHISTORY_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineHistory *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEHISTORY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineHistory.__rshift__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    Shiboken::AutoDecRef attrName(Py_BuildValue("s", "__rrshift__"));
    if (!isReverse
        && Shiboken::Object::checkType(pyArg)
        && !PyObject_TypeCheck(pyArg, self->ob_type)
        && PyObject_HasAttr(pyArg, attrName)) {
        PyObject *revOpMethod = PyObject_GetAttr(pyArg, attrName);
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            pyResult = PyObject_CallFunction(revOpMethod, const_cast<char *>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(pyResult);
                pyResult = nullptr;
            }
        }
        Py_XDECREF(revOpMethod);

    }

    // Do not enter here if other object has implemented a reverse operator.
    if (!pyResult) {
        // Overloaded function decisor
        // 0: QWebEngineHistory::operator>>(QDataStream&,QWebEngineHistory&)
        if (isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), (pyArg)))) {
            overloadId = 0; // operator>>(QDataStream&,QWebEngineHistory&)
        }

        if (isReverse && overloadId == -1) {
            PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
            return {};
        }

        // Function signature not found.
        if (overloadId == -1) goto Sbk_QWebEngineHistoryFunc___rshift___TypeError;

        // Call function/method
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QDataStream *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator>>(QDataStream&,QWebEngineHistory&) [reverse operator]
                QDataStream & cppResult = (*cppArg0) >> (*cppSelf);
                pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
            }
        }

    } // End of "if (!pyResult)"

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QWebEngineHistoryFunc___rshift___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

} // extern "C"

static int Sbk_QWebEngineHistory_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QWebEngineHistory_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QWebEngineHistory_Type = nullptr;
static SbkObjectType *Sbk_QWebEngineHistory_TypeF(void)
{
    return _Sbk_QWebEngineHistory_Type;
}

static PyType_Slot Sbk_QWebEngineHistory_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(SbkDeallocWrapperWithPrivateDtor)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QWebEngineHistory_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QWebEngineHistory_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QWebEngineHistory_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        nullptr},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports number protocol
    {Py_nb_rshift, (void *)Sbk_QWebEngineHistoryFunc___rshift__},
    {Py_nb_lshift, (void *)Sbk_QWebEngineHistoryFunc___lshift__},
    {0, nullptr}
};
static PyType_Spec Sbk_QWebEngineHistory_spec = {
    "2:PySide2.QtWebEngineWidgets.QWebEngineHistory",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QWebEngineHistory_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QWebEngineHistory_PythonToCpp_QWebEngineHistory_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QWebEngineHistory_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QWebEngineHistory_PythonToCpp_QWebEngineHistory_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QWebEngineHistory_TypeF())))
        return QWebEngineHistory_PythonToCpp_QWebEngineHistory_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QWebEngineHistory_PTR_CppToPython_QWebEngineHistory(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QWebEngineHistory *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QWebEngineHistory_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QWebEngineHistory_SignatureStrings[] = {
    "PySide2.QtWebEngineWidgets.QWebEngineHistory.back(self)",
    "PySide2.QtWebEngineWidgets.QWebEngineHistory.backItem(self)->PySide2.QtWebEngineWidgets.QWebEngineHistoryItem",
    "PySide2.QtWebEngineWidgets.QWebEngineHistory.backItems(self,maxItems:int)->QList[PySide2.QtWebEngineWidgets.QWebEngineHistoryItem]",
    "PySide2.QtWebEngineWidgets.QWebEngineHistory.canGoBack(self)->bool",
    "PySide2.QtWebEngineWidgets.QWebEngineHistory.canGoForward(self)->bool",
    "PySide2.QtWebEngineWidgets.QWebEngineHistory.clear(self)",
    "PySide2.QtWebEngineWidgets.QWebEngineHistory.count(self)->int",
    "PySide2.QtWebEngineWidgets.QWebEngineHistory.currentItem(self)->PySide2.QtWebEngineWidgets.QWebEngineHistoryItem",
    "PySide2.QtWebEngineWidgets.QWebEngineHistory.currentItemIndex(self)->int",
    "PySide2.QtWebEngineWidgets.QWebEngineHistory.forward(self)",
    "PySide2.QtWebEngineWidgets.QWebEngineHistory.forwardItem(self)->PySide2.QtWebEngineWidgets.QWebEngineHistoryItem",
    "PySide2.QtWebEngineWidgets.QWebEngineHistory.forwardItems(self,maxItems:int)->QList[PySide2.QtWebEngineWidgets.QWebEngineHistoryItem]",
    "PySide2.QtWebEngineWidgets.QWebEngineHistory.goToItem(self,item:PySide2.QtWebEngineWidgets.QWebEngineHistoryItem)",
    "PySide2.QtWebEngineWidgets.QWebEngineHistory.itemAt(self,i:int)->PySide2.QtWebEngineWidgets.QWebEngineHistoryItem",
    "PySide2.QtWebEngineWidgets.QWebEngineHistory.items(self)->QList[PySide2.QtWebEngineWidgets.QWebEngineHistoryItem]",
    "PySide2.QtWebEngineWidgets.QWebEngineHistory.__lshift__(self,stream:PySide2.QtCore.QDataStream)->PySide2.QtCore.QDataStream",
    "PySide2.QtWebEngineWidgets.QWebEngineHistory.__rshift__(self,stream:PySide2.QtCore.QDataStream)->PySide2.QtCore.QDataStream",
    nullptr}; // Sentinel

void init_QWebEngineHistory(PyObject *module)
{
    _Sbk_QWebEngineHistory_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QWebEngineHistory",
        "QWebEngineHistory*",
        &Sbk_QWebEngineHistory_spec,
        0,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QWebEngineHistory_Type);
    InitSignatureStrings(pyType, QWebEngineHistory_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QWebEngineHistory_Type), Sbk_QWebEngineHistory_PropertyStrings);
    SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEHISTORY_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QWebEngineHistory_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QWebEngineHistory_TypeF(),
        QWebEngineHistory_PythonToCpp_QWebEngineHistory_PTR,
        is_QWebEngineHistory_PythonToCpp_QWebEngineHistory_PTR_Convertible,
        QWebEngineHistory_PTR_CppToPython_QWebEngineHistory);

    Shiboken::Conversions::registerConverterName(converter, "QWebEngineHistory");
    Shiboken::Conversions::registerConverterName(converter, "QWebEngineHistory*");
    Shiboken::Conversions::registerConverterName(converter, "QWebEngineHistory&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QWebEngineHistory).name());


}
