/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtwebenginewidgets_python.h"

// main header
#include "qwebenginepage_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QWebEnginePageWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QWebEnginePageWrapper::QWebEnginePageWrapper(::QObject * parent) : QWebEnginePage(parent)
{
    resetPyMethodCache();
    // ... middle
}

QWebEnginePageWrapper::QWebEnginePageWrapper(::QWebEngineProfile * profile, ::QObject * parent) : QWebEnginePage(profile, parent)
{
    resetPyMethodCache();
    // ... middle
}

bool QWebEnginePageWrapper::acceptNavigationRequest(const ::QUrl & url, ::QWebEnginePage::NavigationType type, bool isMainFrame)
{
    if (m_PyMethodCache[0])
        return this->::QWebEnginePage::acceptNavigationRequest(url, type, isMainFrame);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "acceptNavigationRequest";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QWebEnginePage::acceptNavigationRequest(url, type, isMainFrame);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNN)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &url),
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_NAVIGATIONTYPE_IDX])->converter, &type),
    Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &isMainFrame)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QWebEnginePage.acceptNavigationRequest", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QWebEnginePageWrapper::certificateError(const ::QWebEngineCertificateError & certificateError)
{
    if (m_PyMethodCache[1])
        return this->::QWebEnginePage::certificateError(certificateError);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "certificateError";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QWebEnginePage::certificateError(certificateError);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECERTIFICATEERROR_IDX]), &certificateError)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QWebEnginePage.certificateError", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QWebEnginePageWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

::QStringList QWebEnginePageWrapper::chooseFiles(::QWebEnginePage::FileSelectionMode mode, const ::QStringList & oldFiles, const ::QStringList & acceptedMimeTypes)
{
    if (m_PyMethodCache[3])
        return this->::QWebEnginePage::chooseFiles(mode, oldFiles, acceptedMimeTypes);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return ::QStringList();
    static PyObject *nameCache[2] = {};
    static const char *funcName = "chooseFiles";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QWebEnginePage::chooseFiles(mode, oldFiles, acceptedMimeTypes);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNN)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_FILESELECTIONMODE_IDX])->converter, &mode),
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &oldFiles),
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &acceptedMimeTypes)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return ::QStringList();
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QWebEnginePage.chooseFiles", "QStringList", Py_TYPE(pyResult)->tp_name);
        return ::QStringList();
    }
    ::QStringList cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QWebEnginePageWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[4]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

::QWebEnginePage * QWebEnginePageWrapper::createWindow(::QWebEnginePage::WebWindowType type)
{
    if (m_PyMethodCache[5])
        return this->::QWebEnginePage::createWindow(type);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "createWindow";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QWebEnginePage::createWindow(type);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBWINDOWTYPE_IDX])->converter, &type)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QWebEnginePage.createWindow", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QWebEnginePage >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QWebEnginePage *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QWebEnginePageWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[6]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QWebEnginePageWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QWebEnginePageWrapper::event(::QEvent * arg__1)
{
    if (m_PyMethodCache[8])
        return this->::QWebEnginePage::event(arg__1);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        return this->::QWebEnginePage::event(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), arg__1)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QWebEnginePage.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QWebEnginePageWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[9])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[9] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QWebEnginePage.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QWebEnginePageWrapper::javaScriptAlert(const ::QUrl & securityOrigin, const ::QString & msg)
{
    if (m_PyMethodCache[10]) {
        return this->::QWebEnginePage::javaScriptAlert(securityOrigin, msg);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "javaScriptAlert";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[10] = true;
        return this->::QWebEnginePage::javaScriptAlert(securityOrigin, msg);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &securityOrigin),
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &msg)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QWebEnginePageWrapper::javaScriptConfirm(const ::QUrl & securityOrigin, const ::QString & msg)
{
    if (m_PyMethodCache[11])
        return this->::QWebEnginePage::javaScriptConfirm(securityOrigin, msg);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "javaScriptConfirm";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[11] = true;
        return this->::QWebEnginePage::javaScriptConfirm(securityOrigin, msg);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &securityOrigin),
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &msg)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QWebEnginePage.javaScriptConfirm", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QWebEnginePageWrapper::javaScriptConsoleMessage(::QWebEnginePage::JavaScriptConsoleMessageLevel level, const ::QString & message, int lineNumber, const ::QString & sourceID)
{
    if (m_PyMethodCache[12]) {
        return this->::QWebEnginePage::javaScriptConsoleMessage(level, message, lineNumber, sourceID);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "javaScriptConsoleMessage";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[12] = true;
        return this->::QWebEnginePage::javaScriptConsoleMessage(level, message, lineNumber, sourceID);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNiN)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_JAVASCRIPTCONSOLEMESSAGELEVEL_IDX])->converter, &level),
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &message),
    lineNumber,
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &sourceID)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QWebEnginePageWrapper::javaScriptPrompt(const ::QUrl & securityOrigin, const ::QString & msg, const ::QString & defaultValue, ::QString * result)
{
    if (m_PyMethodCache[13])
        return this->::QWebEnginePage::javaScriptPrompt(securityOrigin, msg, defaultValue, result);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "javaScriptPrompt";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[13] = true;
        return this->::QWebEnginePage::javaScriptPrompt(securityOrigin, msg, defaultValue, result);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNNN)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &securityOrigin),
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &msg),
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &defaultValue),
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &result)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QWebEnginePage.javaScriptPrompt", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QWebEnginePageWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[15]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[15] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QWebEnginePageWrapper::triggerAction(::QWebEnginePage::WebAction action, bool checked)
{
    if (m_PyMethodCache[16]) {
        return this->::QWebEnginePage::triggerAction(action, checked);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "triggerAction";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[16] = true;
        return this->::QWebEnginePage::triggerAction(action, checked);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBACTION_IDX])->converter, &action),
    Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &checked)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

const QMetaObject *QWebEnginePageWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QWebEnginePage::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QWebEnginePageWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QWebEnginePage::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QWebEnginePageWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QWebEnginePageWrapper *>(this));
        return QWebEnginePage::qt_metacast(_clname);
}

QWebEnginePageWrapper::~QWebEnginePageWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QWebEnginePage_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QWebEnginePage >()))
        return -1;

    ::QWebEnginePageWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEnginePage.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|OO:QWebEnginePage", &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QWebEnginePage::QWebEnginePage(QObject*)
    // 1: QWebEnginePage::QWebEnginePage(QWebEngineProfile*,QObject*)
    if (numArgs == 0) {
        overloadId = 0; // QWebEnginePage(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPROFILE_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // QWebEnginePage(QWebEngineProfile*,QObject*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1])))) {
            overloadId = 1; // QWebEnginePage(QWebEngineProfile*,QObject*)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QWebEnginePage(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEnginePage_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QWebEnginePage(QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[0]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QWebEnginePage_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                            goto Sbk_QWebEnginePage_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QObject *cppArg0 = Q_NULLPTR;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QWebEnginePage(QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QWebEnginePageWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QWebEnginePageWrapper(cppArg0);
                }

                Shiboken::Object::setParent(pyArgs[0], self);
            }
            break;
        }
        case 1: // QWebEnginePage(QWebEngineProfile * profile, QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[1]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QWebEnginePage_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1]))))
                            goto Sbk_QWebEnginePage_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QWebEngineProfile *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QObject *cppArg1 = Q_NULLPTR;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QWebEnginePage(QWebEngineProfile*,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QWebEnginePageWrapper(cppArg0, cppArg1);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QWebEnginePageWrapper(cppArg0, cppArg1);
                }

                Shiboken::Object::setParent(pyArgs[1], self);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QWebEnginePage >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QWebEnginePage_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QWebEnginePage_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QWebEnginePage_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QWebEnginePageFunc_acceptNavigationRequest(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEnginePage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEnginePage.acceptNavigationRequest";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "acceptNavigationRequest", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QWebEnginePage::acceptNavigationRequest(QUrl,QWebEnginePage::NavigationType,bool)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_NAVIGATIONTYPE_IDX])->converter, (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[2])))) {
        overloadId = 0; // acceptNavigationRequest(QUrl,QWebEnginePage::NavigationType,bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEnginePageFunc_acceptNavigationRequest_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::QWebEnginePage::NavigationType cppArg1{QWebEnginePage::NavigationTypeLinkClicked};
        pythonToCpp[1](pyArgs[1], &cppArg1);
        bool cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // acceptNavigationRequest(QUrl,QWebEnginePage::NavigationType,bool)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QWebEnginePage::acceptNavigationRequest(*cppArg0, cppArg1, cppArg2)
                : cppSelf->acceptNavigationRequest(*cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QWebEnginePageFunc_acceptNavigationRequest_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEnginePageFunc_action(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEnginePage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEnginePage.action";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEnginePage::action(QWebEnginePage::WebAction)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBACTION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // action(QWebEnginePage::WebAction)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEnginePageFunc_action_TypeError;

    // Call function/method
    {
        ::QWebEnginePage::WebAction cppArg0{QWebEnginePage::Back};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // action(QWebEnginePage::WebAction)const
            QAction * cppResult = const_cast<const ::QWebEnginePage *>(cppSelf)->action(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QWebEnginePageFunc_action_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEnginePageFunc_backgroundColor(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEnginePage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEnginePage.backgroundColor";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // backgroundColor()const
            QColor cppResult = const_cast<const ::QWebEnginePage *>(cppSelf)->backgroundColor();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEnginePageFunc_certificateError(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEnginePage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEnginePage.certificateError";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEnginePage::certificateError(QWebEngineCertificateError)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECERTIFICATEERROR_IDX]), (pyArg)))) {
        overloadId = 0; // certificateError(QWebEngineCertificateError)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEnginePageFunc_certificateError_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWebEngineCertificateError *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // certificateError(QWebEngineCertificateError)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QWebEnginePage::certificateError(*cppArg0)
                : cppSelf->certificateError(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QWebEnginePageFunc_certificateError_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEnginePageFunc_chooseFiles(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEnginePage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEnginePage.chooseFiles";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "chooseFiles", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QWebEnginePage::chooseFiles(QWebEnginePage::FileSelectionMode,QStringList,QStringList)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_FILESELECTIONMODE_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArgs[2])))) {
        overloadId = 0; // chooseFiles(QWebEnginePage::FileSelectionMode,QStringList,QStringList)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEnginePageFunc_chooseFiles_TypeError;

    // Call function/method
    {
        ::QWebEnginePage::FileSelectionMode cppArg0{QWebEnginePage::FileSelectOpen};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QStringList cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QStringList cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // chooseFiles(QWebEnginePage::FileSelectionMode,QStringList,QStringList)
            QStringList cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QWebEnginePage::chooseFiles(cppArg0, cppArg1, cppArg2)
                : cppSelf->chooseFiles(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QWebEnginePageFunc_chooseFiles_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEnginePageFunc_contentsSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEnginePage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEnginePage.contentsSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // contentsSize()const
            QSizeF cppResult = const_cast<const ::QWebEnginePage *>(cppSelf)->contentsSize();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEnginePageFunc_contextMenuData(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEnginePage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEnginePage.contextMenuData";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // contextMenuData()const
            const QWebEngineContextMenuData & cppResult = const_cast<const ::QWebEnginePage *>(cppSelf)->contextMenuData();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINECONTEXTMENUDATA_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEnginePageFunc_createStandardContextMenu(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEnginePage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEnginePage.createStandardContextMenu";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // createStandardContextMenu()
            QMenu * cppResult = cppSelf->createStandardContextMenu();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QMENU_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEnginePageFunc_createWindow(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEnginePage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEnginePage.createWindow";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEnginePage::createWindow(QWebEnginePage::WebWindowType)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBWINDOWTYPE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // createWindow(QWebEnginePage::WebWindowType)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEnginePageFunc_createWindow_TypeError;

    // Call function/method
    {
        ::QWebEnginePage::WebWindowType cppArg0{QWebEnginePage::WebBrowserWindow};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // createWindow(QWebEnginePage::WebWindowType)
            QWebEnginePage * cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QWebEnginePage::createWindow(cppArg0)
                : cppSelf->createWindow(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QWebEnginePageFunc_createWindow_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEnginePageFunc_devToolsPage(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEnginePage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEnginePage.devToolsPage";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // devToolsPage()const
            QWebEnginePage * cppResult = const_cast<const ::QWebEnginePage *>(cppSelf)->devToolsPage();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEnginePageFunc_download(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEnginePage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEnginePage.download";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QWebEnginePageFunc_download_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QWebEnginePageFunc_download_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:download", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QWebEnginePage::download(QUrl,QString)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // download(QUrl,QString)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            overloadId = 0; // download(QUrl,QString)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEnginePageFunc_download_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_filename = Shiboken::String::createStaticString("filename");
            if (PyDict_Contains(kwds, key_filename)) {
                value = PyDict_GetItem(kwds, key_filename);
                if (value && pyArgs[1]) {
                    errInfo = key_filename;
                    Py_INCREF(errInfo);
                    goto Sbk_QWebEnginePageFunc_download_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1]))))
                        goto Sbk_QWebEnginePageFunc_download_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_filename);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QWebEnginePageFunc_download_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::QString cppArg1 = QString();
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // download(QUrl,QString)
            cppSelf->download(*cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEnginePageFunc_download_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEnginePageFunc_event(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEnginePage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEnginePage.event";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QObject::event(QEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // event(QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEnginePageFunc_event_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // event(QEvent*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QWebEnginePage::event(cppArg0)
                : cppSelf->event(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QWebEnginePageFunc_event_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEnginePageFunc_findText(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEnginePage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEnginePage.findText";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QWebEnginePageFunc_findText_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QWebEnginePageFunc_findText_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:findText", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QWebEnginePage::findText(QString,QFlags<QWebEnginePage::FindFlag>,PyObject*)
    // 1: QWebEnginePage::findText(QString,QFlags<QWebEnginePage::FindFlag>)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // findText(QString,QFlags<QWebEnginePage::FindFlag>)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QFLAGS_QWEBENGINEPAGE_FINDFLAG_IDX])->converter, (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 1; // findText(QString,QFlags<QWebEnginePage::FindFlag>)
            } else if (numArgs == 3
                && PyObject_Check(pyArgs[2])) {
                overloadId = 0; // findText(QString,QFlags<QWebEnginePage::FindFlag>,PyObject*)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEnginePageFunc_findText_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // findText(QString arg__1, QFlags<QWebEnginePage::FindFlag> arg__2, PyObject * arg__3)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QWebEnginePageFunc_findText_TypeError;
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            SBK_UNUSED(cppArg0)
            ::QFlags<QWebEnginePage::FindFlag> cppArg1 = QFlags<QWebEnginePage::FindFlag>(0);
            pythonToCpp[1](pyArgs[1], &cppArg1);
            SBK_UNUSED(cppArg1)

            if (!PyErr_Occurred()) {
                // findText(QString,QFlags<QWebEnginePage::FindFlag>,PyObject*)
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtwebenginewidgets.cpp (qwebenginepage-findtext)]
                auto callable = pyArgs[3-1];
                auto callback = [callable](bool found)
                {
                    if (!PyCallable_Check(callable)) {
                        qWarning("Argument 3 of findText must be a callable.");
                        return;
                    }
                    Shiboken::GilState state;
                    Shiboken::AutoDecRef arglist(PyTuple_New(1));
                    PyTuple_SET_ITEM(arglist, 0, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &found));
                    Shiboken::AutoDecRef ret(PyObject_CallObject(callable, arglist));
                    Py_DECREF(callable);

                };
                Py_INCREF(callable);
                cppSelf->findText(cppArg0, cppArg1, callback);
                // END of custom code block [file: ../glue/qtwebenginewidgets.cpp (qwebenginepage-findtext)]
                // ========================================================================

                // End of code injection

            }
            break;
        }
        case 1: // findText(const QString & subString, QFlags<QWebEnginePage::FindFlag> options)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_options = Shiboken::String::createStaticString("options");
                if (PyDict_Contains(kwds, key_options)) {
                    value = PyDict_GetItem(kwds, key_options);
                    if (value && pyArgs[1]) {
                        errInfo = key_options;
                        Py_INCREF(errInfo);
                        goto Sbk_QWebEnginePageFunc_findText_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QFLAGS_QWEBENGINEPAGE_FINDFLAG_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QWebEnginePageFunc_findText_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_options);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QWebEnginePageFunc_findText_TypeError;
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QFlags<QWebEnginePage::FindFlag> cppArg1 = QWebEnginePage::FindFlags();
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // findText(QString,QFlags<QWebEnginePage::FindFlag>)
                cppSelf->findText(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEnginePageFunc_findText_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEnginePageFunc_hasSelection(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEnginePage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEnginePage.hasSelection";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hasSelection()const
            bool cppResult = const_cast<const ::QWebEnginePage *>(cppSelf)->hasSelection();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEnginePageFunc_history(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEnginePage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEnginePage.history";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // history()const
            QWebEngineHistory * cppResult = const_cast<const ::QWebEnginePage *>(cppSelf)->history();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEHISTORY_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEnginePageFunc_icon(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEnginePage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEnginePage.icon";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // icon()const
            QIcon cppResult = const_cast<const ::QWebEnginePage *>(cppSelf)->icon();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QICON_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEnginePageFunc_iconUrl(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEnginePage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEnginePage.iconUrl";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // iconUrl()const
            QUrl cppResult = const_cast<const ::QWebEnginePage *>(cppSelf)->iconUrl();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEnginePageFunc_inspectedPage(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEnginePage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEnginePage.inspectedPage";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // inspectedPage()const
            QWebEnginePage * cppResult = const_cast<const ::QWebEnginePage *>(cppSelf)->inspectedPage();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEnginePageFunc_isAudioMuted(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEnginePage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEnginePage.isAudioMuted";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isAudioMuted()const
            bool cppResult = const_cast<const ::QWebEnginePage *>(cppSelf)->isAudioMuted();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEnginePageFunc_isVisible(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEnginePage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEnginePage.isVisible";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isVisible()const
            bool cppResult = const_cast<const ::QWebEnginePage *>(cppSelf)->isVisible();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEnginePageFunc_javaScriptAlert(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEnginePage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEnginePage.javaScriptAlert";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "javaScriptAlert", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QWebEnginePage::javaScriptAlert(QUrl,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
        overloadId = 0; // javaScriptAlert(QUrl,QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEnginePageFunc_javaScriptAlert_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // javaScriptAlert(QUrl,QString)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QWebEnginePage::javaScriptAlert(*cppArg0, cppArg1)
                : cppSelf->javaScriptAlert(*cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEnginePageFunc_javaScriptAlert_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEnginePageFunc_javaScriptConfirm(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEnginePage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEnginePage.javaScriptConfirm";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "javaScriptConfirm", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QWebEnginePage::javaScriptConfirm(QUrl,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
        overloadId = 0; // javaScriptConfirm(QUrl,QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEnginePageFunc_javaScriptConfirm_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // javaScriptConfirm(QUrl,QString)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QWebEnginePage::javaScriptConfirm(*cppArg0, cppArg1)
                : cppSelf->javaScriptConfirm(*cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QWebEnginePageFunc_javaScriptConfirm_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEnginePageFunc_javaScriptConsoleMessage(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEnginePage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEnginePage.javaScriptConsoleMessage";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "javaScriptConsoleMessage", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QWebEnginePage::javaScriptConsoleMessage(QWebEnginePage::JavaScriptConsoleMessageLevel,QString,int,QString)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_JAVASCRIPTCONSOLEMESSAGELEVEL_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[3])))) {
        overloadId = 0; // javaScriptConsoleMessage(QWebEnginePage::JavaScriptConsoleMessageLevel,QString,int,QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEnginePageFunc_javaScriptConsoleMessage_TypeError;

    // Call function/method
    {
        ::QWebEnginePage::JavaScriptConsoleMessageLevel cppArg0{QWebEnginePage::InfoMessageLevel};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        ::QString cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // javaScriptConsoleMessage(QWebEnginePage::JavaScriptConsoleMessageLevel,QString,int,QString)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QWebEnginePage::javaScriptConsoleMessage(cppArg0, cppArg1, cppArg2, cppArg3)
                : cppSelf->javaScriptConsoleMessage(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEnginePageFunc_javaScriptConsoleMessage_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEnginePageFunc_javaScriptPrompt(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEnginePage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEnginePage.javaScriptPrompt";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "javaScriptPrompt", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QWebEnginePage::javaScriptPrompt(QUrl,QString,QString,QString*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[3])))) {
        overloadId = 0; // javaScriptPrompt(QUrl,QString,QString,QString*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEnginePageFunc_javaScriptPrompt_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QString cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        ::QString *cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // javaScriptPrompt(QUrl,QString,QString,QString*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QWebEnginePage::javaScriptPrompt(*cppArg0, cppArg1, cppArg2, cppArg3)
                : cppSelf->javaScriptPrompt(*cppArg0, cppArg1, cppArg2, cppArg3);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QWebEnginePageFunc_javaScriptPrompt_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEnginePageFunc_lifecycleState(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEnginePage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEnginePage.lifecycleState";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // lifecycleState()const
            QWebEnginePage::LifecycleState cppResult = const_cast<const ::QWebEnginePage *>(cppSelf)->lifecycleState();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_LIFECYCLESTATE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEnginePageFunc_load(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEnginePage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEnginePage.load";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEnginePage::load(QUrl)
    // 1: QWebEnginePage::load(QWebEngineHttpRequest)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEHTTPREQUEST_IDX]), (pyArg)))) {
        overloadId = 1; // load(QWebEngineHttpRequest)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArg)))) {
        overloadId = 0; // load(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEnginePageFunc_load_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // load(const QUrl & url)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QUrl cppArg0_local;
            ::QUrl *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // load(QUrl)
                cppSelf->load(*cppArg0);
            }
            break;
        }
        case 1: // load(const QWebEngineHttpRequest & request)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QWebEngineHttpRequest *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // load(QWebEngineHttpRequest)
                cppSelf->load(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEnginePageFunc_load_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEnginePageFunc_print(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEnginePage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEnginePage.print";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "print", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QWebEnginePage::print(QPrinter*,PyObject*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX]), (pyArgs[0])))
        && PyObject_Check(pyArgs[1])) {
        overloadId = 0; // print(QPrinter*,PyObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEnginePageFunc_print_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QPrinter *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        SBK_UNUSED(cppArg0)

        if (!PyErr_Occurred()) {
            // print(QPrinter*,PyObject*)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtwebenginewidgets.cpp (qwebenginepage-print)]
            auto printer = pyArgs[1-1];
            auto callable = pyArgs[2-1];
            auto callback = [printer, callable](bool succeeded)
            {
                if (!PyCallable_Check(callable)) {
                    qWarning("Argument 2 of print must be a callable.");
                    return;
                }
                Shiboken::GilState state;
                Shiboken::AutoDecRef arglist(PyTuple_New(1));
                PyTuple_SET_ITEM(arglist, 0, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &succeeded));
                Shiboken::AutoDecRef ret(PyObject_CallObject(callable, arglist));
                Py_DECREF(callable);
                Py_DECREF(printer);

            };
            Py_INCREF(printer); // Add a reference to the printer until asynchronous printing has finished
            Py_INCREF(callable);
            cppSelf->print(cppArg0, callback);
            // END of custom code block [file: ../glue/qtwebenginewidgets.cpp (qwebenginepage-print)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEnginePageFunc_print_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEnginePageFunc_printToPdf(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEnginePage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEnginePage.printToPdf";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QWebEnginePageFunc_printToPdf_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QWebEnginePageFunc_printToPdf_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:printToPdf", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QWebEnginePage::printToPdf(PyObject*,QPageLayout)
    // 1: QWebEnginePage::printToPdf(QString,QPageLayout)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // printToPdf(QString,QPageLayout)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_IDX]), (pyArgs[1])))) {
            overloadId = 1; // printToPdf(QString,QPageLayout)
        }
    } else if (numArgs == 2
        && PyObject_Check(pyArgs[0])
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_IDX]), (pyArgs[1])))) {
        overloadId = 0; // printToPdf(PyObject*,QPageLayout)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEnginePageFunc_printToPdf_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // printToPdf(PyObject * arg__1, QPageLayout arg__2)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QWebEnginePageFunc_printToPdf_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QPageLayout cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            SBK_UNUSED(cppArg1)

            if (!PyErr_Occurred()) {
                // printToPdf(PyObject*,QPageLayout)
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtwebenginewidgets.cpp (qwebenginepage-printtopdf)]
                auto callable = pyArgs[1-1];
                auto callback = [callable](const QByteArray &pdf)
                {
                    if (!PyCallable_Check(callable)) {
                        qWarning("Argument 1 of printToPdf must be a callable.");
                        return;
                    }
                    Shiboken::GilState state;
                    Shiboken::AutoDecRef arglist(PyTuple_New(1));
                    PyTuple_SET_ITEM(arglist, 0, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &pdf));
                    Shiboken::AutoDecRef ret(PyObject_CallObject(callable, arglist));
                    Py_DECREF(callable);

                };
                Py_INCREF(callable);
                cppSelf->printToPdf(callback, cppArg1);
                // END of custom code block [file: ../glue/qtwebenginewidgets.cpp (qwebenginepage-printtopdf)]
                // ========================================================================

                // End of code injection

            }
            break;
        }
        case 1: // printToPdf(const QString & filePath, const QPageLayout & layout)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_layout = Shiboken::String::createStaticString("layout");
                if (PyDict_Contains(kwds, key_layout)) {
                    value = PyDict_GetItem(kwds, key_layout);
                    if (value && pyArgs[1]) {
                        errInfo = key_layout;
                        Py_INCREF(errInfo);
                        goto Sbk_QWebEnginePageFunc_printToPdf_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_IDX]), (pyArgs[1]))))
                            goto Sbk_QWebEnginePageFunc_printToPdf_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_layout);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QWebEnginePageFunc_printToPdf_TypeError;
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QPageLayout cppArg1_local = QPageLayout(QPageSize(QPageSize::A4), QPageLayout::Portrait, QMarginsF());
            ::QPageLayout *cppArg1 = &cppArg1_local;
            if (pythonToCpp[1]) {
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);
            }

            if (!PyErr_Occurred()) {
                // printToPdf(QString,QPageLayout)
                cppSelf->printToPdf(cppArg0, *cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEnginePageFunc_printToPdf_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEnginePageFunc_profile(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEnginePage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEnginePage.profile";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // profile()const
            QWebEngineProfile * cppResult = const_cast<const ::QWebEnginePage *>(cppSelf)->profile();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPROFILE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEnginePageFunc_recentlyAudible(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEnginePage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEnginePage.recentlyAudible";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // recentlyAudible()const
            bool cppResult = const_cast<const ::QWebEnginePage *>(cppSelf)->recentlyAudible();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEnginePageFunc_recommendedState(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEnginePage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEnginePage.recommendedState";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // recommendedState()const
            QWebEnginePage::LifecycleState cppResult = const_cast<const ::QWebEnginePage *>(cppSelf)->recommendedState();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_LIFECYCLESTATE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEnginePageFunc_renderProcessPid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEnginePage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEnginePage.renderProcessPid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // renderProcessPid()const
            qint64 cppResult = const_cast<const ::QWebEnginePage *>(cppSelf)->renderProcessPid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEnginePageFunc_replaceMisspelledWord(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEnginePage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEnginePage.replaceMisspelledWord";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEnginePage::replaceMisspelledWord(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // replaceMisspelledWord(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEnginePageFunc_replaceMisspelledWord_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // replaceMisspelledWord(QString)
            cppSelf->replaceMisspelledWord(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEnginePageFunc_replaceMisspelledWord_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEnginePageFunc_requestedUrl(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEnginePage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEnginePage.requestedUrl";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // requestedUrl()const
            QUrl cppResult = const_cast<const ::QWebEnginePage *>(cppSelf)->requestedUrl();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEnginePageFunc_runJavaScript(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEnginePage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEnginePage.runJavaScript";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "runJavaScript", 1, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QWebEnginePage::runJavaScript(QString,quint32,PyObject*)
    // 1: QWebEnginePage::runJavaScript(QString)
    // 2: QWebEnginePage::runJavaScript(QString,quint32)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // runJavaScript(QString)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint32>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 2; // runJavaScript(QString,quint32)
            } else if (numArgs == 3
                && PyObject_Check(pyArgs[2])) {
                overloadId = 0; // runJavaScript(QString,quint32,PyObject*)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEnginePageFunc_runJavaScript_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // runJavaScript(QString arg__1, quint32 arg__2, PyObject * arg__3)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            SBK_UNUSED(cppArg0)
            quint32 cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            SBK_UNUSED(cppArg1)

            if (!PyErr_Occurred()) {
                // runJavaScript(QString,quint32,PyObject*)
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtwebenginewidgets.cpp (qwebenginepage-runjavascript)]
                auto callable = pyArgs[3-1];
                auto callback = [callable](const QVariant &result)
                {
                    if (!PyCallable_Check(callable)) {
                        qWarning("Argument 3 of runJavaScript must be a callable.");
                        return;
                    }
                    Shiboken::GilState state;
                    Shiboken::AutoDecRef arglist(PyTuple_New(1));
                    switch (result.type()) {
                    case QVariant::Bool: {
                        const bool value = result.toBool();
                        PyTuple_SET_ITEM(arglist, 0, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &value));
                    }
                        break;
                     case QVariant::Int:
                     case QVariant::UInt:
                     case QVariant::LongLong:
                     case QVariant::ULongLong:
                     case QVariant::Double: {
                        const double number = result.toDouble();
                        PyTuple_SET_ITEM(arglist, 0, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<double>(), &number));
                    }
                        break;
                    default: {
                        const QString value = result.toString();
                        PyTuple_SET_ITEM(arglist, 0, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &value));
                    }
                        break;
                    }
                   // PyTuple_SET_ITEM(arglist, 0, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &found));
                    Shiboken::AutoDecRef ret(PyObject_CallObject(callable, arglist));
                    Py_DECREF(callable);

                };
                Py_INCREF(callable);
                cppSelf->runJavaScript(cppArg0, cppArg1, callback);
                // END of custom code block [file: ../glue/qtwebenginewidgets.cpp (qwebenginepage-runjavascript)]
                // ========================================================================

                // End of code injection

            }
            break;
        }
        case 1: // runJavaScript(const QString & scriptSource)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // runJavaScript(QString)
                cppSelf->runJavaScript(cppArg0);
            }
            break;
        }
        case 2: // runJavaScript(const QString & scriptSource, quint32 worldId)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            quint32 cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // runJavaScript(QString,quint32)
                cppSelf->runJavaScript(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEnginePageFunc_runJavaScript_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEnginePageFunc_save(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEnginePage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEnginePage.save";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QWebEnginePageFunc_save_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QWebEnginePageFunc_save_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:save", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QWebEnginePage::save(QString,QWebEngineDownloadItem::SavePageFormat)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // save(QString,QWebEngineDownloadItem::SavePageFormat)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_SAVEPAGEFORMAT_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // save(QString,QWebEngineDownloadItem::SavePageFormat)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEnginePageFunc_save_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_format = Shiboken::String::createStaticString("format");
            if (PyDict_Contains(kwds, key_format)) {
                value = PyDict_GetItem(kwds, key_format);
                if (value && pyArgs[1]) {
                    errInfo = key_format;
                    Py_INCREF(errInfo);
                    goto Sbk_QWebEnginePageFunc_save_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEDOWNLOADITEM_SAVEPAGEFORMAT_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QWebEnginePageFunc_save_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_format);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QWebEnginePageFunc_save_TypeError;
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QWebEngineDownloadItem::SavePageFormat cppArg1 = QWebEngineDownloadItem::MimeHtmlSaveFormat;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // save(QString,QWebEngineDownloadItem::SavePageFormat)const
            const_cast<const ::QWebEnginePage *>(cppSelf)->save(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEnginePageFunc_save_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEnginePageFunc_scripts(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEnginePage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEnginePage.scripts";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // scripts()
            QWebEngineScriptCollection & cppResult = cppSelf->scripts();
            pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPTCOLLECTION_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEnginePageFunc_scrollPosition(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEnginePage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEnginePage.scrollPosition";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // scrollPosition()const
            QPointF cppResult = const_cast<const ::QWebEnginePage *>(cppSelf)->scrollPosition();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEnginePageFunc_selectedText(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEnginePage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEnginePage.selectedText";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // selectedText()const
            QString cppResult = const_cast<const ::QWebEnginePage *>(cppSelf)->selectedText();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEnginePageFunc_setAudioMuted(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEnginePage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEnginePage.setAudioMuted";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEnginePage::setAudioMuted(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setAudioMuted(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEnginePageFunc_setAudioMuted_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAudioMuted(bool)
            cppSelf->setAudioMuted(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEnginePageFunc_setAudioMuted_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEnginePageFunc_setBackgroundColor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEnginePage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEnginePage.setBackgroundColor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEnginePage::setBackgroundColor(QColor)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArg)))) {
        overloadId = 0; // setBackgroundColor(QColor)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEnginePageFunc_setBackgroundColor_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QColor cppArg0_local;
        ::QColor *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setBackgroundColor(QColor)
            cppSelf->setBackgroundColor(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEnginePageFunc_setBackgroundColor_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEnginePageFunc_setContent(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEnginePage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEnginePage.setContent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QWebEnginePageFunc_setContent_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QWebEnginePageFunc_setContent_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:setContent", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QWebEnginePage::setContent(QByteArray,QString,QUrl)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setContent(QByteArray,QString,QUrl)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // setContent(QByteArray,QString,QUrl)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[2])))) {
                overloadId = 0; // setContent(QByteArray,QString,QUrl)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEnginePageFunc_setContent_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_mimeType = Shiboken::String::createStaticString("mimeType");
            if (PyDict_Contains(kwds, key_mimeType)) {
                value = PyDict_GetItem(kwds, key_mimeType);
                if (value && pyArgs[1]) {
                    errInfo = key_mimeType;
                    Py_INCREF(errInfo);
                    goto Sbk_QWebEnginePageFunc_setContent_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1]))))
                        goto Sbk_QWebEnginePageFunc_setContent_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_mimeType);
            }
            static PyObject *const key_baseUrl = Shiboken::String::createStaticString("baseUrl");
            if (PyDict_Contains(kwds, key_baseUrl)) {
                value = PyDict_GetItem(kwds, key_baseUrl);
                if (value && pyArgs[2]) {
                    errInfo = key_baseUrl;
                    Py_INCREF(errInfo);
                    goto Sbk_QWebEnginePageFunc_setContent_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[2]))))
                        goto Sbk_QWebEnginePageFunc_setContent_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_baseUrl);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QWebEnginePageFunc_setContent_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::QString cppArg1 = QString();
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QUrl cppArg2_local = QUrl();
        ::QUrl *cppArg2 = &cppArg2_local;
        if (pythonToCpp[2]) {
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp[2]))
            pythonToCpp[2](pyArgs[2], &cppArg2_local);
        else
            pythonToCpp[2](pyArgs[2], &cppArg2);
        }

        if (!PyErr_Occurred()) {
            // setContent(QByteArray,QString,QUrl)
            cppSelf->setContent(*cppArg0, cppArg1, *cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEnginePageFunc_setContent_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEnginePageFunc_setDevToolsPage(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEnginePage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEnginePage.setDevToolsPage";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEnginePage::setDevToolsPage(QWebEnginePage*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX]), (pyArg)))) {
        overloadId = 0; // setDevToolsPage(QWebEnginePage*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEnginePageFunc_setDevToolsPage_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWebEnginePage *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDevToolsPage(QWebEnginePage*)
            cppSelf->setDevToolsPage(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEnginePageFunc_setDevToolsPage_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEnginePageFunc_setFeaturePermission(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEnginePage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEnginePage.setFeaturePermission";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setFeaturePermission", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QWebEnginePage::setFeaturePermission(QUrl,QWebEnginePage::Feature,QWebEnginePage::PermissionPolicy)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_FEATURE_IDX])->converter, (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_PERMISSIONPOLICY_IDX])->converter, (pyArgs[2])))) {
        overloadId = 0; // setFeaturePermission(QUrl,QWebEnginePage::Feature,QWebEnginePage::PermissionPolicy)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEnginePageFunc_setFeaturePermission_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::QWebEnginePage::Feature cppArg1{QWebEnginePage::Notifications};
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QWebEnginePage::PermissionPolicy cppArg2{QWebEnginePage::PermissionUnknown};
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // setFeaturePermission(QUrl,QWebEnginePage::Feature,QWebEnginePage::PermissionPolicy)
            cppSelf->setFeaturePermission(*cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEnginePageFunc_setFeaturePermission_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEnginePageFunc_setHtml(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEnginePage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEnginePage.setHtml";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QWebEnginePageFunc_setHtml_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QWebEnginePageFunc_setHtml_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:setHtml", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QWebEnginePage::setHtml(QString,QUrl)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setHtml(QString,QUrl)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[1])))) {
            overloadId = 0; // setHtml(QString,QUrl)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEnginePageFunc_setHtml_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_baseUrl = Shiboken::String::createStaticString("baseUrl");
            if (PyDict_Contains(kwds, key_baseUrl)) {
                value = PyDict_GetItem(kwds, key_baseUrl);
                if (value && pyArgs[1]) {
                    errInfo = key_baseUrl;
                    Py_INCREF(errInfo);
                    goto Sbk_QWebEnginePageFunc_setHtml_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[1]))))
                        goto Sbk_QWebEnginePageFunc_setHtml_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_baseUrl);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QWebEnginePageFunc_setHtml_TypeError;
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QUrl cppArg1_local = QUrl();
        ::QUrl *cppArg1 = &cppArg1_local;
        if (pythonToCpp[1]) {
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);
        }

        if (!PyErr_Occurred()) {
            // setHtml(QString,QUrl)
            cppSelf->setHtml(cppArg0, *cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEnginePageFunc_setHtml_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEnginePageFunc_setInspectedPage(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEnginePage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEnginePage.setInspectedPage";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEnginePage::setInspectedPage(QWebEnginePage*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX]), (pyArg)))) {
        overloadId = 0; // setInspectedPage(QWebEnginePage*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEnginePageFunc_setInspectedPage_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWebEnginePage *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setInspectedPage(QWebEnginePage*)
            cppSelf->setInspectedPage(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEnginePageFunc_setInspectedPage_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEnginePageFunc_setLifecycleState(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEnginePage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEnginePage.setLifecycleState";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEnginePage::setLifecycleState(QWebEnginePage::LifecycleState)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_LIFECYCLESTATE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setLifecycleState(QWebEnginePage::LifecycleState)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEnginePageFunc_setLifecycleState_TypeError;

    // Call function/method
    {
        ::QWebEnginePage::LifecycleState cppArg0{QWebEnginePage::LifecycleState::Active};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setLifecycleState(QWebEnginePage::LifecycleState)
            cppSelf->setLifecycleState(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEnginePageFunc_setLifecycleState_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEnginePageFunc_setUrl(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEnginePage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEnginePage.setUrl";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEnginePage::setUrl(QUrl)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArg)))) {
        overloadId = 0; // setUrl(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEnginePageFunc_setUrl_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setUrl(QUrl)
            cppSelf->setUrl(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEnginePageFunc_setUrl_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEnginePageFunc_setUrlRequestInterceptor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEnginePage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEnginePage.setUrlRequestInterceptor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEnginePage::setUrlRequestInterceptor(QWebEngineUrlRequestInterceptor*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineCoreTypes[SBK_QWEBENGINEURLREQUESTINTERCEPTOR_IDX]), (pyArg)))) {
        overloadId = 0; // setUrlRequestInterceptor(QWebEngineUrlRequestInterceptor*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEnginePageFunc_setUrlRequestInterceptor_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWebEngineUrlRequestInterceptor *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setUrlRequestInterceptor(QWebEngineUrlRequestInterceptor*)
            cppSelf->setUrlRequestInterceptor(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEnginePageFunc_setUrlRequestInterceptor_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEnginePageFunc_setView(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEnginePage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEnginePage.setView";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEnginePage::setView(QWidget*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArg)))) {
        overloadId = 0; // setView(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEnginePageFunc_setView_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setView(QWidget*)
            cppSelf->setView(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEnginePageFunc_setView_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEnginePageFunc_setVisible(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEnginePage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEnginePage.setVisible";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEnginePage::setVisible(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setVisible(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEnginePageFunc_setVisible_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setVisible(bool)
            cppSelf->setVisible(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEnginePageFunc_setVisible_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEnginePageFunc_setWebChannel(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEnginePage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEnginePage.setWebChannel";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setWebChannel", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QWebEnginePage::setWebChannel(QWebChannel*)
    // 1: QWebEnginePage::setWebChannel(QWebChannel*,uint)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebChannelTypes[SBK_QWEBCHANNEL_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setWebChannel(QWebChannel*)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[1])))) {
            overloadId = 1; // setWebChannel(QWebChannel*,uint)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEnginePageFunc_setWebChannel_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setWebChannel(QWebChannel * arg__1)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QWebChannel *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // setWebChannel(QWebChannel*)
                cppSelf->setWebChannel(cppArg0);
            }
            break;
        }
        case 1: // setWebChannel(QWebChannel * arg__1, uint worldId)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QWebChannel *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            uint cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setWebChannel(QWebChannel*,uint)
                cppSelf->setWebChannel(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEnginePageFunc_setWebChannel_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEnginePageFunc_setZoomFactor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEnginePage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEnginePage.setZoomFactor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEnginePage::setZoomFactor(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setZoomFactor(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEnginePageFunc_setZoomFactor_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setZoomFactor(qreal)
            cppSelf->setZoomFactor(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEnginePageFunc_setZoomFactor_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEnginePageFunc_settings(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEnginePage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEnginePage.settings";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // settings()const
            QWebEngineSettings * cppResult = const_cast<const ::QWebEnginePage *>(cppSelf)->settings();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEnginePageFunc_title(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEnginePage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEnginePage.title";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // title()const
            QString cppResult = const_cast<const ::QWebEnginePage *>(cppSelf)->title();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEnginePageFunc_toHtml(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEnginePage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEnginePage.toHtml";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEnginePage::toHtml(PyObject*)const
    if (PyObject_Check(pyArg)) {
        overloadId = 0; // toHtml(PyObject*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEnginePageFunc_toHtml_TypeError;

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toHtml(PyObject*)const
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtwebenginewidgets.cpp (qwebenginepage-convertto)]
            auto callable = pyArg;
            auto callback = [callable](const QString &text)
            {
                if (!PyCallable_Check(callable)) {
                    qWarning("Argument 1 of toHtml must be a callable.");
                    return;
                }
                Shiboken::GilState state;
                Shiboken::AutoDecRef arglist(PyTuple_New(1));
                PyTuple_SET_ITEM(arglist, 0, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &text));
                Shiboken::AutoDecRef ret(PyObject_CallObject(callable, arglist));
                Py_DECREF(callable);

            };
            Py_INCREF(callable);
            cppSelf->toHtml(callback);
            // END of custom code block [file: ../glue/qtwebenginewidgets.cpp (qwebenginepage-convertto)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEnginePageFunc_toHtml_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEnginePageFunc_toPlainText(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEnginePage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEnginePage.toPlainText";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEnginePage::toPlainText(PyObject*)const
    if (PyObject_Check(pyArg)) {
        overloadId = 0; // toPlainText(PyObject*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEnginePageFunc_toPlainText_TypeError;

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toPlainText(PyObject*)const
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtwebenginewidgets.cpp (qwebenginepage-convertto)]
            auto callable = pyArg;
            auto callback = [callable](const QString &text)
            {
                if (!PyCallable_Check(callable)) {
                    qWarning("Argument 1 of toPlainText must be a callable.");
                    return;
                }
                Shiboken::GilState state;
                Shiboken::AutoDecRef arglist(PyTuple_New(1));
                PyTuple_SET_ITEM(arglist, 0, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &text));
                Shiboken::AutoDecRef ret(PyObject_CallObject(callable, arglist));
                Py_DECREF(callable);

            };
            Py_INCREF(callable);
            cppSelf->toPlainText(callback);
            // END of custom code block [file: ../glue/qtwebenginewidgets.cpp (qwebenginepage-convertto)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEnginePageFunc_toPlainText_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEnginePageFunc_triggerAction(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEnginePage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEnginePage.triggerAction";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QWebEnginePageFunc_triggerAction_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QWebEnginePageFunc_triggerAction_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:triggerAction", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QWebEnginePage::triggerAction(QWebEnginePage::WebAction,bool)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBACTION_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // triggerAction(QWebEnginePage::WebAction,bool)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
            overloadId = 0; // triggerAction(QWebEnginePage::WebAction,bool)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEnginePageFunc_triggerAction_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_checked = Shiboken::String::createStaticString("checked");
            if (PyDict_Contains(kwds, key_checked)) {
                value = PyDict_GetItem(kwds, key_checked);
                if (value && pyArgs[1]) {
                    errInfo = key_checked;
                    Py_INCREF(errInfo);
                    goto Sbk_QWebEnginePageFunc_triggerAction_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1]))))
                        goto Sbk_QWebEnginePageFunc_triggerAction_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_checked);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QWebEnginePageFunc_triggerAction_TypeError;
            }
        }
        ::QWebEnginePage::WebAction cppArg0{QWebEnginePage::Back};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        bool cppArg1 = false;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // triggerAction(QWebEnginePage::WebAction,bool)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QWebEnginePage::triggerAction(cppArg0, cppArg1)
                : cppSelf->triggerAction(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEnginePageFunc_triggerAction_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEnginePageFunc_url(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEnginePage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEnginePage.url";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // url()const
            QUrl cppResult = const_cast<const ::QWebEnginePage *>(cppSelf)->url();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEnginePageFunc_view(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEnginePage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEnginePage.view";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // view()const
            QWidget * cppResult = const_cast<const ::QWebEnginePage *>(cppSelf)->view();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEnginePageFunc_webChannel(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEnginePage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEnginePage.webChannel";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // webChannel()const
            QWebChannel * cppResult = const_cast<const ::QWebEnginePage *>(cppSelf)->webChannel();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebChannelTypes[SBK_QWEBCHANNEL_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEnginePageFunc_zoomFactor(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEnginePage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEnginePage.zoomFactor";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // zoomFactor()const
            qreal cppResult = const_cast<const ::QWebEnginePage *>(cppSelf)->zoomFactor();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QWebEnginePage_PropertyStrings[] = {
    "audioMuted:isAudioMuted:",
    "backgroundColor::",
    "contentsSize:",
    "hasSelection:",
    "icon:",
    "iconUrl:",
    "lifecycleState::",
    "recentlyAudible:",
    "recommendedState:",
    "renderProcessPid:",
    "requestedUrl:",
    "scrollPosition:",
    "selectedText:",
    "title:",
    "url::",
    "visible:isVisible:",
    "zoomFactor::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QWebEnginePage_methods[] = {
    {"acceptNavigationRequest", reinterpret_cast<PyCFunction>(Sbk_QWebEnginePageFunc_acceptNavigationRequest), METH_VARARGS},
    {"action", reinterpret_cast<PyCFunction>(Sbk_QWebEnginePageFunc_action), METH_O},
    {"backgroundColor", reinterpret_cast<PyCFunction>(Sbk_QWebEnginePageFunc_backgroundColor), METH_NOARGS},
    {"certificateError", reinterpret_cast<PyCFunction>(Sbk_QWebEnginePageFunc_certificateError), METH_O},
    {"chooseFiles", reinterpret_cast<PyCFunction>(Sbk_QWebEnginePageFunc_chooseFiles), METH_VARARGS},
    {"contentsSize", reinterpret_cast<PyCFunction>(Sbk_QWebEnginePageFunc_contentsSize), METH_NOARGS},
    {"contextMenuData", reinterpret_cast<PyCFunction>(Sbk_QWebEnginePageFunc_contextMenuData), METH_NOARGS},
    {"createStandardContextMenu", reinterpret_cast<PyCFunction>(Sbk_QWebEnginePageFunc_createStandardContextMenu), METH_NOARGS},
    {"createWindow", reinterpret_cast<PyCFunction>(Sbk_QWebEnginePageFunc_createWindow), METH_O},
    {"devToolsPage", reinterpret_cast<PyCFunction>(Sbk_QWebEnginePageFunc_devToolsPage), METH_NOARGS},
    {"download", reinterpret_cast<PyCFunction>(Sbk_QWebEnginePageFunc_download), METH_VARARGS|METH_KEYWORDS},
    {"event", reinterpret_cast<PyCFunction>(Sbk_QWebEnginePageFunc_event), METH_O},
    {"findText", reinterpret_cast<PyCFunction>(Sbk_QWebEnginePageFunc_findText), METH_VARARGS|METH_KEYWORDS},
    {"hasSelection", reinterpret_cast<PyCFunction>(Sbk_QWebEnginePageFunc_hasSelection), METH_NOARGS},
    {"history", reinterpret_cast<PyCFunction>(Sbk_QWebEnginePageFunc_history), METH_NOARGS},
    {"icon", reinterpret_cast<PyCFunction>(Sbk_QWebEnginePageFunc_icon), METH_NOARGS},
    {"iconUrl", reinterpret_cast<PyCFunction>(Sbk_QWebEnginePageFunc_iconUrl), METH_NOARGS},
    {"inspectedPage", reinterpret_cast<PyCFunction>(Sbk_QWebEnginePageFunc_inspectedPage), METH_NOARGS},
    {"isAudioMuted", reinterpret_cast<PyCFunction>(Sbk_QWebEnginePageFunc_isAudioMuted), METH_NOARGS},
    {"isVisible", reinterpret_cast<PyCFunction>(Sbk_QWebEnginePageFunc_isVisible), METH_NOARGS},
    {"javaScriptAlert", reinterpret_cast<PyCFunction>(Sbk_QWebEnginePageFunc_javaScriptAlert), METH_VARARGS},
    {"javaScriptConfirm", reinterpret_cast<PyCFunction>(Sbk_QWebEnginePageFunc_javaScriptConfirm), METH_VARARGS},
    {"javaScriptConsoleMessage", reinterpret_cast<PyCFunction>(Sbk_QWebEnginePageFunc_javaScriptConsoleMessage), METH_VARARGS},
    {"javaScriptPrompt", reinterpret_cast<PyCFunction>(Sbk_QWebEnginePageFunc_javaScriptPrompt), METH_VARARGS},
    {"lifecycleState", reinterpret_cast<PyCFunction>(Sbk_QWebEnginePageFunc_lifecycleState), METH_NOARGS},
    {"load", reinterpret_cast<PyCFunction>(Sbk_QWebEnginePageFunc_load), METH_O},
    {"print", reinterpret_cast<PyCFunction>(Sbk_QWebEnginePageFunc_print), METH_VARARGS},
    {"printToPdf", reinterpret_cast<PyCFunction>(Sbk_QWebEnginePageFunc_printToPdf), METH_VARARGS|METH_KEYWORDS},
    {"profile", reinterpret_cast<PyCFunction>(Sbk_QWebEnginePageFunc_profile), METH_NOARGS},
    {"recentlyAudible", reinterpret_cast<PyCFunction>(Sbk_QWebEnginePageFunc_recentlyAudible), METH_NOARGS},
    {"recommendedState", reinterpret_cast<PyCFunction>(Sbk_QWebEnginePageFunc_recommendedState), METH_NOARGS},
    {"renderProcessPid", reinterpret_cast<PyCFunction>(Sbk_QWebEnginePageFunc_renderProcessPid), METH_NOARGS},
    {"replaceMisspelledWord", reinterpret_cast<PyCFunction>(Sbk_QWebEnginePageFunc_replaceMisspelledWord), METH_O},
    {"requestedUrl", reinterpret_cast<PyCFunction>(Sbk_QWebEnginePageFunc_requestedUrl), METH_NOARGS},
    {"runJavaScript", reinterpret_cast<PyCFunction>(Sbk_QWebEnginePageFunc_runJavaScript), METH_VARARGS},
    {"save", reinterpret_cast<PyCFunction>(Sbk_QWebEnginePageFunc_save), METH_VARARGS|METH_KEYWORDS},
    {"scripts", reinterpret_cast<PyCFunction>(Sbk_QWebEnginePageFunc_scripts), METH_NOARGS},
    {"scrollPosition", reinterpret_cast<PyCFunction>(Sbk_QWebEnginePageFunc_scrollPosition), METH_NOARGS},
    {"selectedText", reinterpret_cast<PyCFunction>(Sbk_QWebEnginePageFunc_selectedText), METH_NOARGS},
    {"setAudioMuted", reinterpret_cast<PyCFunction>(Sbk_QWebEnginePageFunc_setAudioMuted), METH_O},
    {"setBackgroundColor", reinterpret_cast<PyCFunction>(Sbk_QWebEnginePageFunc_setBackgroundColor), METH_O},
    {"setContent", reinterpret_cast<PyCFunction>(Sbk_QWebEnginePageFunc_setContent), METH_VARARGS|METH_KEYWORDS},
    {"setDevToolsPage", reinterpret_cast<PyCFunction>(Sbk_QWebEnginePageFunc_setDevToolsPage), METH_O},
    {"setFeaturePermission", reinterpret_cast<PyCFunction>(Sbk_QWebEnginePageFunc_setFeaturePermission), METH_VARARGS},
    {"setHtml", reinterpret_cast<PyCFunction>(Sbk_QWebEnginePageFunc_setHtml), METH_VARARGS|METH_KEYWORDS},
    {"setInspectedPage", reinterpret_cast<PyCFunction>(Sbk_QWebEnginePageFunc_setInspectedPage), METH_O},
    {"setLifecycleState", reinterpret_cast<PyCFunction>(Sbk_QWebEnginePageFunc_setLifecycleState), METH_O},
    {"setUrl", reinterpret_cast<PyCFunction>(Sbk_QWebEnginePageFunc_setUrl), METH_O},
    {"setUrlRequestInterceptor", reinterpret_cast<PyCFunction>(Sbk_QWebEnginePageFunc_setUrlRequestInterceptor), METH_O},
    {"setView", reinterpret_cast<PyCFunction>(Sbk_QWebEnginePageFunc_setView), METH_O},
    {"setVisible", reinterpret_cast<PyCFunction>(Sbk_QWebEnginePageFunc_setVisible), METH_O},
    {"setWebChannel", reinterpret_cast<PyCFunction>(Sbk_QWebEnginePageFunc_setWebChannel), METH_VARARGS},
    {"setZoomFactor", reinterpret_cast<PyCFunction>(Sbk_QWebEnginePageFunc_setZoomFactor), METH_O},
    {"settings", reinterpret_cast<PyCFunction>(Sbk_QWebEnginePageFunc_settings), METH_NOARGS},
    {"title", reinterpret_cast<PyCFunction>(Sbk_QWebEnginePageFunc_title), METH_NOARGS},
    {"toHtml", reinterpret_cast<PyCFunction>(Sbk_QWebEnginePageFunc_toHtml), METH_O},
    {"toPlainText", reinterpret_cast<PyCFunction>(Sbk_QWebEnginePageFunc_toPlainText), METH_O},
    {"triggerAction", reinterpret_cast<PyCFunction>(Sbk_QWebEnginePageFunc_triggerAction), METH_VARARGS|METH_KEYWORDS},
    {"url", reinterpret_cast<PyCFunction>(Sbk_QWebEnginePageFunc_url), METH_NOARGS},
    {"view", reinterpret_cast<PyCFunction>(Sbk_QWebEnginePageFunc_view), METH_NOARGS},
    {"webChannel", reinterpret_cast<PyCFunction>(Sbk_QWebEnginePageFunc_webChannel), METH_NOARGS},
    {"zoomFactor", reinterpret_cast<PyCFunction>(Sbk_QWebEnginePageFunc_zoomFactor), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QWebEnginePage_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QWebEnginePage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QWebEnginePageWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QWebEnginePage_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QWebEnginePage_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QWebEnginePage_Type = nullptr;
static SbkObjectType *Sbk_QWebEnginePage_TypeF(void)
{
    return _Sbk_QWebEnginePage_Type;
}

static PyType_Slot Sbk_QWebEnginePage_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QWebEnginePage_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QWebEnginePage_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QWebEnginePage_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QWebEnginePage_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QWebEnginePage_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QWebEnginePage_spec = {
    "2:PySide2.QtWebEngineWidgets.QWebEnginePage",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QWebEnginePage_slots
};

} //extern "C"

static void *Sbk_QWebEnginePage_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QWebEnginePage *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}

PyObject *SbkPySide2_QtWebEngineWidgets_QWebEnginePage_FindFlag___and__(PyObject *self, PyObject *pyArg)
{
    ::QWebEnginePage::FindFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QWebEnginePage::FindFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QWebEnginePage::FindFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QWebEnginePage::FindFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QWebEnginePage::FindFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QFLAGS_QWEBENGINEPAGE_FINDFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtWebEngineWidgets_QWebEnginePage_FindFlag___or__(PyObject *self, PyObject *pyArg)
{
    ::QWebEnginePage::FindFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QWebEnginePage::FindFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QWebEnginePage::FindFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QWebEnginePage::FindFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QWebEnginePage::FindFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QFLAGS_QWEBENGINEPAGE_FINDFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtWebEngineWidgets_QWebEnginePage_FindFlag___xor__(PyObject *self, PyObject *pyArg)
{
    ::QWebEnginePage::FindFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QWebEnginePage::FindFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QWebEnginePage::FindFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QWebEnginePage::FindFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QWebEnginePage::FindFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QFLAGS_QWEBENGINEPAGE_FINDFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtWebEngineWidgets_QWebEnginePage_FindFlag___invert__(PyObject *self, PyObject *pyArg)
{
    ::QWebEnginePage::FindFlags cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QFLAGS_QWEBENGINEPAGE_FINDFLAG_IDX])->converter, self, &cppSelf);
    ::QWebEnginePage::FindFlags cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QFLAGS_QWEBENGINEPAGE_FINDFLAG_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtWebEngineWidgets_QWebEnginePage_FindFlag_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QFLAGS_QWEBENGINEPAGE_FINDFLAG_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtWebEngineWidgets_QWebEnginePage_FindFlag__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QFLAGS_QWEBENGINEPAGE_FINDFLAG_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtWebEngineWidgets_QWebEnginePage_FindFlag_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtWebEngineWidgets_QWebEnginePage_FindFlag__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtWebEngineWidgets_QWebEnginePage_FindFlag__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtWebEngineWidgets_QWebEnginePage_FindFlag_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtWebEngineWidgets_QWebEnginePage_FindFlag___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtWebEngineWidgets_QWebEnginePage_FindFlag___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtWebEngineWidgets_QWebEnginePage_FindFlag___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtWebEngineWidgets_QWebEnginePage_FindFlag___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtWebEngineWidgets_QWebEnginePage_FindFlag_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtWebEngineWidgets_QWebEnginePage_FindFlag_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtWebEngineWidgets_QWebEnginePage_FindFlag_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QWebEnginePage_WebAction_PythonToCpp_QWebEnginePage_WebAction(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QWebEnginePage::WebAction *>(cppOut) =
        static_cast<::QWebEnginePage::WebAction>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QWebEnginePage_WebAction_PythonToCpp_QWebEnginePage_WebAction_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBACTION_IDX]))
        return QWebEnginePage_WebAction_PythonToCpp_QWebEnginePage_WebAction;
    return {};
}
static PyObject *QWebEnginePage_WebAction_CppToPython_QWebEnginePage_WebAction(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QWebEnginePage::WebAction *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBACTION_IDX], castCppIn);

}

static void QWebEnginePage_FindFlag_PythonToCpp_QWebEnginePage_FindFlag(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QWebEnginePage::FindFlag *>(cppOut) =
        static_cast<::QWebEnginePage::FindFlag>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QWebEnginePage_FindFlag_PythonToCpp_QWebEnginePage_FindFlag_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_FINDFLAG_IDX]))
        return QWebEnginePage_FindFlag_PythonToCpp_QWebEnginePage_FindFlag;
    return {};
}
static PyObject *QWebEnginePage_FindFlag_CppToPython_QWebEnginePage_FindFlag(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QWebEnginePage::FindFlag *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_FINDFLAG_IDX], castCppIn);

}

static void QFlags_QWebEnginePage_FindFlag__PythonToCpp_QFlags_QWebEnginePage_FindFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QWebEnginePage::FindFlag> *>(cppOut) =
        ::QFlags<QWebEnginePage::FindFlag>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QWebEnginePage_FindFlag__PythonToCpp_QFlags_QWebEnginePage_FindFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWebEngineWidgetsTypes[SBK_QFLAGS_QWEBENGINEPAGE_FINDFLAG_IDX]))
        return QFlags_QWebEnginePage_FindFlag__PythonToCpp_QFlags_QWebEnginePage_FindFlag_;
    return {};
}
static PyObject *QFlags_QWebEnginePage_FindFlag__CppToPython_QFlags_QWebEnginePage_FindFlag_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QWebEnginePage::FindFlag> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtWebEngineWidgetsTypes[SBK_QFLAGS_QWEBENGINEPAGE_FINDFLAG_IDX]));

}

static void QWebEnginePage_FindFlag_PythonToCpp_QFlags_QWebEnginePage_FindFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QWebEnginePage::FindFlag> *>(cppOut) =
        ::QFlags<QWebEnginePage::FindFlag>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QWebEnginePage_FindFlag_PythonToCpp_QFlags_QWebEnginePage_FindFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_FINDFLAG_IDX]))
        return QWebEnginePage_FindFlag_PythonToCpp_QFlags_QWebEnginePage_FindFlag_;
    return {};
}
static void number_PythonToCpp_QFlags_QWebEnginePage_FindFlag_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QWebEnginePage::FindFlag> *>(cppOut) =
        ::QFlags<QWebEnginePage::FindFlag>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QWebEnginePage_FindFlag__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_FINDFLAG_IDX]))
        return number_PythonToCpp_QFlags_QWebEnginePage_FindFlag_;
    return {};
}
static void QWebEnginePage_WebWindowType_PythonToCpp_QWebEnginePage_WebWindowType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QWebEnginePage::WebWindowType *>(cppOut) =
        static_cast<::QWebEnginePage::WebWindowType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QWebEnginePage_WebWindowType_PythonToCpp_QWebEnginePage_WebWindowType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBWINDOWTYPE_IDX]))
        return QWebEnginePage_WebWindowType_PythonToCpp_QWebEnginePage_WebWindowType;
    return {};
}
static PyObject *QWebEnginePage_WebWindowType_CppToPython_QWebEnginePage_WebWindowType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QWebEnginePage::WebWindowType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBWINDOWTYPE_IDX], castCppIn);

}

static void QWebEnginePage_PermissionPolicy_PythonToCpp_QWebEnginePage_PermissionPolicy(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QWebEnginePage::PermissionPolicy *>(cppOut) =
        static_cast<::QWebEnginePage::PermissionPolicy>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QWebEnginePage_PermissionPolicy_PythonToCpp_QWebEnginePage_PermissionPolicy_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_PERMISSIONPOLICY_IDX]))
        return QWebEnginePage_PermissionPolicy_PythonToCpp_QWebEnginePage_PermissionPolicy;
    return {};
}
static PyObject *QWebEnginePage_PermissionPolicy_CppToPython_QWebEnginePage_PermissionPolicy(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QWebEnginePage::PermissionPolicy *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_PERMISSIONPOLICY_IDX], castCppIn);

}

static void QWebEnginePage_NavigationType_PythonToCpp_QWebEnginePage_NavigationType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QWebEnginePage::NavigationType *>(cppOut) =
        static_cast<::QWebEnginePage::NavigationType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QWebEnginePage_NavigationType_PythonToCpp_QWebEnginePage_NavigationType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_NAVIGATIONTYPE_IDX]))
        return QWebEnginePage_NavigationType_PythonToCpp_QWebEnginePage_NavigationType;
    return {};
}
static PyObject *QWebEnginePage_NavigationType_CppToPython_QWebEnginePage_NavigationType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QWebEnginePage::NavigationType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_NAVIGATIONTYPE_IDX], castCppIn);

}

static void QWebEnginePage_Feature_PythonToCpp_QWebEnginePage_Feature(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QWebEnginePage::Feature *>(cppOut) =
        static_cast<::QWebEnginePage::Feature>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QWebEnginePage_Feature_PythonToCpp_QWebEnginePage_Feature_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_FEATURE_IDX]))
        return QWebEnginePage_Feature_PythonToCpp_QWebEnginePage_Feature;
    return {};
}
static PyObject *QWebEnginePage_Feature_CppToPython_QWebEnginePage_Feature(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QWebEnginePage::Feature *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_FEATURE_IDX], castCppIn);

}

static void QWebEnginePage_FileSelectionMode_PythonToCpp_QWebEnginePage_FileSelectionMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QWebEnginePage::FileSelectionMode *>(cppOut) =
        static_cast<::QWebEnginePage::FileSelectionMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QWebEnginePage_FileSelectionMode_PythonToCpp_QWebEnginePage_FileSelectionMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_FILESELECTIONMODE_IDX]))
        return QWebEnginePage_FileSelectionMode_PythonToCpp_QWebEnginePage_FileSelectionMode;
    return {};
}
static PyObject *QWebEnginePage_FileSelectionMode_CppToPython_QWebEnginePage_FileSelectionMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QWebEnginePage::FileSelectionMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_FILESELECTIONMODE_IDX], castCppIn);

}

static void QWebEnginePage_JavaScriptConsoleMessageLevel_PythonToCpp_QWebEnginePage_JavaScriptConsoleMessageLevel(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QWebEnginePage::JavaScriptConsoleMessageLevel *>(cppOut) =
        static_cast<::QWebEnginePage::JavaScriptConsoleMessageLevel>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QWebEnginePage_JavaScriptConsoleMessageLevel_PythonToCpp_QWebEnginePage_JavaScriptConsoleMessageLevel_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_JAVASCRIPTCONSOLEMESSAGELEVEL_IDX]))
        return QWebEnginePage_JavaScriptConsoleMessageLevel_PythonToCpp_QWebEnginePage_JavaScriptConsoleMessageLevel;
    return {};
}
static PyObject *QWebEnginePage_JavaScriptConsoleMessageLevel_CppToPython_QWebEnginePage_JavaScriptConsoleMessageLevel(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QWebEnginePage::JavaScriptConsoleMessageLevel *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_JAVASCRIPTCONSOLEMESSAGELEVEL_IDX], castCppIn);

}

static void QWebEnginePage_RenderProcessTerminationStatus_PythonToCpp_QWebEnginePage_RenderProcessTerminationStatus(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QWebEnginePage::RenderProcessTerminationStatus *>(cppOut) =
        static_cast<::QWebEnginePage::RenderProcessTerminationStatus>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QWebEnginePage_RenderProcessTerminationStatus_PythonToCpp_QWebEnginePage_RenderProcessTerminationStatus_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_RENDERPROCESSTERMINATIONSTATUS_IDX]))
        return QWebEnginePage_RenderProcessTerminationStatus_PythonToCpp_QWebEnginePage_RenderProcessTerminationStatus;
    return {};
}
static PyObject *QWebEnginePage_RenderProcessTerminationStatus_CppToPython_QWebEnginePage_RenderProcessTerminationStatus(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QWebEnginePage::RenderProcessTerminationStatus *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_RENDERPROCESSTERMINATIONSTATUS_IDX], castCppIn);

}

static void QWebEnginePage_LifecycleState_PythonToCpp_QWebEnginePage_LifecycleState(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QWebEnginePage::LifecycleState *>(cppOut) =
        static_cast<::QWebEnginePage::LifecycleState>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QWebEnginePage_LifecycleState_PythonToCpp_QWebEnginePage_LifecycleState_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_LIFECYCLESTATE_IDX]))
        return QWebEnginePage_LifecycleState_PythonToCpp_QWebEnginePage_LifecycleState;
    return {};
}
static PyObject *QWebEnginePage_LifecycleState_CppToPython_QWebEnginePage_LifecycleState(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QWebEnginePage::LifecycleState *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_LIFECYCLESTATE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QWebEnginePage_PythonToCpp_QWebEnginePage_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QWebEnginePage_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QWebEnginePage_PythonToCpp_QWebEnginePage_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QWebEnginePage_TypeF())))
        return QWebEnginePage_PythonToCpp_QWebEnginePage_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QWebEnginePage_PTR_CppToPython_QWebEnginePage(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QWebEnginePage *>(const_cast<void *>(cppIn)), Sbk_QWebEnginePage_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QWebEnginePage_SignatureStrings[] = {
    "1:PySide2.QtWebEngineWidgets.QWebEnginePage(self,parent:PySide2.QtCore.QObject=Q_NULLPTR)",
    "0:PySide2.QtWebEngineWidgets.QWebEnginePage(self,profile:PySide2.QtWebEngineWidgets.QWebEngineProfile,parent:PySide2.QtCore.QObject=Q_NULLPTR)",
    "PySide2.QtWebEngineWidgets.QWebEnginePage.acceptNavigationRequest(self,url:PySide2.QtCore.QUrl,type:PySide2.QtWebEngineWidgets.QWebEnginePage.NavigationType,isMainFrame:bool)->bool",
    "PySide2.QtWebEngineWidgets.QWebEnginePage.action(self,action:PySide2.QtWebEngineWidgets.QWebEnginePage.WebAction)->PySide2.QtWidgets.QAction",
    "PySide2.QtWebEngineWidgets.QWebEnginePage.backgroundColor(self)->PySide2.QtGui.QColor",
    "PySide2.QtWebEngineWidgets.QWebEnginePage.certificateError(self,certificateError:PySide2.QtWebEngineWidgets.QWebEngineCertificateError)->bool",
    "PySide2.QtWebEngineWidgets.QWebEnginePage.chooseFiles(self,mode:PySide2.QtWebEngineWidgets.QWebEnginePage.FileSelectionMode,oldFiles:QStringList,acceptedMimeTypes:QStringList)->QStringList",
    "PySide2.QtWebEngineWidgets.QWebEnginePage.contentsSize(self)->PySide2.QtCore.QSizeF",
    "PySide2.QtWebEngineWidgets.QWebEnginePage.contextMenuData(self)->PySide2.QtWebEngineWidgets.QWebEngineContextMenuData",
    "PySide2.QtWebEngineWidgets.QWebEnginePage.createStandardContextMenu(self)->PySide2.QtWidgets.QMenu",
    "PySide2.QtWebEngineWidgets.QWebEnginePage.createWindow(self,type:PySide2.QtWebEngineWidgets.QWebEnginePage.WebWindowType)->PySide2.QtWebEngineWidgets.QWebEnginePage",
    "PySide2.QtWebEngineWidgets.QWebEnginePage.devToolsPage(self)->PySide2.QtWebEngineWidgets.QWebEnginePage",
    "PySide2.QtWebEngineWidgets.QWebEnginePage.download(self,url:PySide2.QtCore.QUrl,filename:QString=QString())",
    "PySide2.QtWebEngineWidgets.QWebEnginePage.event(self,arg__1:PySide2.QtCore.QEvent)->bool",
    "1:PySide2.QtWebEngineWidgets.QWebEnginePage.findText(self,arg__1:QString,arg__2:PySide2.QtWebEngineWidgets.QWebEnginePage.FindFlags,arg__3:PyObject)",
    "0:PySide2.QtWebEngineWidgets.QWebEnginePage.findText(self,subString:QString,options:PySide2.QtWebEngineWidgets.QWebEnginePage.FindFlags=QWebEnginePage.FindFlags())",
    "PySide2.QtWebEngineWidgets.QWebEnginePage.hasSelection(self)->bool",
    "PySide2.QtWebEngineWidgets.QWebEnginePage.history(self)->PySide2.QtWebEngineWidgets.QWebEngineHistory",
    "PySide2.QtWebEngineWidgets.QWebEnginePage.icon(self)->PySide2.QtGui.QIcon",
    "PySide2.QtWebEngineWidgets.QWebEnginePage.iconUrl(self)->PySide2.QtCore.QUrl",
    "PySide2.QtWebEngineWidgets.QWebEnginePage.inspectedPage(self)->PySide2.QtWebEngineWidgets.QWebEnginePage",
    "PySide2.QtWebEngineWidgets.QWebEnginePage.isAudioMuted(self)->bool",
    "PySide2.QtWebEngineWidgets.QWebEnginePage.isVisible(self)->bool",
    "PySide2.QtWebEngineWidgets.QWebEnginePage.javaScriptAlert(self,securityOrigin:PySide2.QtCore.QUrl,msg:QString)",
    "PySide2.QtWebEngineWidgets.QWebEnginePage.javaScriptConfirm(self,securityOrigin:PySide2.QtCore.QUrl,msg:QString)->bool",
    "PySide2.QtWebEngineWidgets.QWebEnginePage.javaScriptConsoleMessage(self,level:PySide2.QtWebEngineWidgets.QWebEnginePage.JavaScriptConsoleMessageLevel,message:QString,lineNumber:int,sourceID:QString)",
    "PySide2.QtWebEngineWidgets.QWebEnginePage.javaScriptPrompt(self,securityOrigin:PySide2.QtCore.QUrl,msg:QString,defaultValue:QString,result:QString*)->bool",
    "PySide2.QtWebEngineWidgets.QWebEnginePage.lifecycleState(self)->PySide2.QtWebEngineWidgets.QWebEnginePage.LifecycleState",
    "1:PySide2.QtWebEngineWidgets.QWebEnginePage.load(self,url:PySide2.QtCore.QUrl)",
    "0:PySide2.QtWebEngineWidgets.QWebEnginePage.load(self,request:PySide2.QtWebEngineCore.QWebEngineHttpRequest)",
    "PySide2.QtWebEngineWidgets.QWebEnginePage.print(self,arg__1:PySide2.QtPrintSupport.QPrinter,arg__2:PyObject)",
    "1:PySide2.QtWebEngineWidgets.QWebEnginePage.printToPdf(self,arg__1:PyObject,arg__2:PySide2.QtGui.QPageLayout)",
    "0:PySide2.QtWebEngineWidgets.QWebEnginePage.printToPdf(self,filePath:QString,layout:PySide2.QtGui.QPageLayout=QPageLayout(QPageSize(QPageSize.A4), QPageLayout.Portrait, QMarginsF()))",
    "PySide2.QtWebEngineWidgets.QWebEnginePage.profile(self)->PySide2.QtWebEngineWidgets.QWebEngineProfile",
    "PySide2.QtWebEngineWidgets.QWebEnginePage.recentlyAudible(self)->bool",
    "PySide2.QtWebEngineWidgets.QWebEnginePage.recommendedState(self)->PySide2.QtWebEngineWidgets.QWebEnginePage.LifecycleState",
    "PySide2.QtWebEngineWidgets.QWebEnginePage.renderProcessPid(self)->qint64",
    "PySide2.QtWebEngineWidgets.QWebEnginePage.replaceMisspelledWord(self,replacement:QString)",
    "PySide2.QtWebEngineWidgets.QWebEnginePage.requestedUrl(self)->PySide2.QtCore.QUrl",
    "2:PySide2.QtWebEngineWidgets.QWebEnginePage.runJavaScript(self,arg__1:QString,arg__2:quint32,arg__3:PyObject)",
    "1:PySide2.QtWebEngineWidgets.QWebEnginePage.runJavaScript(self,scriptSource:QString)",
    "0:PySide2.QtWebEngineWidgets.QWebEnginePage.runJavaScript(self,scriptSource:QString,worldId:quint32)",
    "PySide2.QtWebEngineWidgets.QWebEnginePage.save(self,filePath:QString,format:PySide2.QtWebEngineWidgets.QWebEngineDownloadItem.SavePageFormat=QWebEngineDownloadItem.MimeHtmlSaveFormat)",
    "PySide2.QtWebEngineWidgets.QWebEnginePage.scripts(self)->PySide2.QtWebEngineWidgets.QWebEngineScriptCollection",
    "PySide2.QtWebEngineWidgets.QWebEnginePage.scrollPosition(self)->PySide2.QtCore.QPointF",
    "PySide2.QtWebEngineWidgets.QWebEnginePage.selectedText(self)->QString",
    "PySide2.QtWebEngineWidgets.QWebEnginePage.setAudioMuted(self,muted:bool)",
    "PySide2.QtWebEngineWidgets.QWebEnginePage.setBackgroundColor(self,color:PySide2.QtGui.QColor)",
    "PySide2.QtWebEngineWidgets.QWebEnginePage.setContent(self,data:PySide2.QtCore.QByteArray,mimeType:QString=QString(),baseUrl:PySide2.QtCore.QUrl=QUrl())",
    "PySide2.QtWebEngineWidgets.QWebEnginePage.setDevToolsPage(self,page:PySide2.QtWebEngineWidgets.QWebEnginePage)",
    "PySide2.QtWebEngineWidgets.QWebEnginePage.setFeaturePermission(self,securityOrigin:PySide2.QtCore.QUrl,feature:PySide2.QtWebEngineWidgets.QWebEnginePage.Feature,policy:PySide2.QtWebEngineWidgets.QWebEnginePage.PermissionPolicy)",
    "PySide2.QtWebEngineWidgets.QWebEnginePage.setHtml(self,html:QString,baseUrl:PySide2.QtCore.QUrl=QUrl())",
    "PySide2.QtWebEngineWidgets.QWebEnginePage.setInspectedPage(self,page:PySide2.QtWebEngineWidgets.QWebEnginePage)",
    "PySide2.QtWebEngineWidgets.QWebEnginePage.setLifecycleState(self,state:PySide2.QtWebEngineWidgets.QWebEnginePage.LifecycleState)",
    "PySide2.QtWebEngineWidgets.QWebEnginePage.setUrl(self,url:PySide2.QtCore.QUrl)",
    "PySide2.QtWebEngineWidgets.QWebEnginePage.setUrlRequestInterceptor(self,interceptor:PySide2.QtWebEngineCore.QWebEngineUrlRequestInterceptor)",
    "PySide2.QtWebEngineWidgets.QWebEnginePage.setView(self,view:PySide2.QtWidgets.QWidget)",
    "PySide2.QtWebEngineWidgets.QWebEnginePage.setVisible(self,visible:bool)",
    "1:PySide2.QtWebEngineWidgets.QWebEnginePage.setWebChannel(self,arg__1:PySide2.QtWebChannel.QWebChannel)",
    "0:PySide2.QtWebEngineWidgets.QWebEnginePage.setWebChannel(self,arg__1:PySide2.QtWebChannel.QWebChannel,worldId:uint)",
    "PySide2.QtWebEngineWidgets.QWebEnginePage.setZoomFactor(self,factor:qreal)",
    "PySide2.QtWebEngineWidgets.QWebEnginePage.settings(self)->PySide2.QtWebEngineWidgets.QWebEngineSettings",
    "PySide2.QtWebEngineWidgets.QWebEnginePage.title(self)->QString",
    "PySide2.QtWebEngineWidgets.QWebEnginePage.toHtml(self,arg__1:PyObject)",
    "PySide2.QtWebEngineWidgets.QWebEnginePage.toPlainText(self,arg__1:PyObject)",
    "PySide2.QtWebEngineWidgets.QWebEnginePage.triggerAction(self,action:PySide2.QtWebEngineWidgets.QWebEnginePage.WebAction,checked:bool=false)",
    "PySide2.QtWebEngineWidgets.QWebEnginePage.url(self)->PySide2.QtCore.QUrl",
    "PySide2.QtWebEngineWidgets.QWebEnginePage.view(self)->PySide2.QtWidgets.QWidget",
    "PySide2.QtWebEngineWidgets.QWebEnginePage.webChannel(self)->PySide2.QtWebChannel.QWebChannel",
    "PySide2.QtWebEngineWidgets.QWebEnginePage.zoomFactor(self)->qreal",
    nullptr}; // Sentinel

void init_QWebEnginePage(PyObject *module)
{
    _Sbk_QWebEnginePage_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QWebEnginePage",
        "QWebEnginePage*",
        &Sbk_QWebEnginePage_spec,
        &Shiboken::callCppDestructor< ::QWebEnginePage >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QWebEnginePage_Type);
    InitSignatureStrings(pyType, QWebEnginePage_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QWebEnginePage_Type), Sbk_QWebEnginePage_PropertyStrings);
    SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QWebEnginePage_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QWebEnginePage_TypeF(),
        QWebEnginePage_PythonToCpp_QWebEnginePage_PTR,
        is_QWebEnginePage_PythonToCpp_QWebEnginePage_PTR_Convertible,
        QWebEnginePage_PTR_CppToPython_QWebEnginePage);

    Shiboken::Conversions::registerConverterName(converter, "QWebEnginePage");
    Shiboken::Conversions::registerConverterName(converter, "QWebEnginePage*");
    Shiboken::Conversions::registerConverterName(converter, "QWebEnginePage&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QWebEnginePage).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QWebEnginePageWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QWebEnginePage_TypeF(), &Sbk_QWebEnginePage_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'WebAction'.
    SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBACTION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QWebEnginePage_TypeF(),
        "WebAction",
        "2:PySide2.QtWebEngineWidgets.QWebEnginePage.WebAction",
        "QWebEnginePage::WebAction");
    if (!SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBACTION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBACTION_IDX],
        Sbk_QWebEnginePage_TypeF(), "NoWebAction", (long) QWebEnginePage::WebAction::NoWebAction))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBACTION_IDX],
        Sbk_QWebEnginePage_TypeF(), "Back", (long) QWebEnginePage::WebAction::Back))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBACTION_IDX],
        Sbk_QWebEnginePage_TypeF(), "Forward", (long) QWebEnginePage::WebAction::Forward))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBACTION_IDX],
        Sbk_QWebEnginePage_TypeF(), "Stop", (long) QWebEnginePage::WebAction::Stop))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBACTION_IDX],
        Sbk_QWebEnginePage_TypeF(), "Reload", (long) QWebEnginePage::WebAction::Reload))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBACTION_IDX],
        Sbk_QWebEnginePage_TypeF(), "Cut", (long) QWebEnginePage::WebAction::Cut))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBACTION_IDX],
        Sbk_QWebEnginePage_TypeF(), "Copy", (long) QWebEnginePage::WebAction::Copy))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBACTION_IDX],
        Sbk_QWebEnginePage_TypeF(), "Paste", (long) QWebEnginePage::WebAction::Paste))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBACTION_IDX],
        Sbk_QWebEnginePage_TypeF(), "Undo", (long) QWebEnginePage::WebAction::Undo))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBACTION_IDX],
        Sbk_QWebEnginePage_TypeF(), "Redo", (long) QWebEnginePage::WebAction::Redo))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBACTION_IDX],
        Sbk_QWebEnginePage_TypeF(), "SelectAll", (long) QWebEnginePage::WebAction::SelectAll))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBACTION_IDX],
        Sbk_QWebEnginePage_TypeF(), "ReloadAndBypassCache", (long) QWebEnginePage::WebAction::ReloadAndBypassCache))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBACTION_IDX],
        Sbk_QWebEnginePage_TypeF(), "PasteAndMatchStyle", (long) QWebEnginePage::WebAction::PasteAndMatchStyle))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBACTION_IDX],
        Sbk_QWebEnginePage_TypeF(), "OpenLinkInThisWindow", (long) QWebEnginePage::WebAction::OpenLinkInThisWindow))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBACTION_IDX],
        Sbk_QWebEnginePage_TypeF(), "OpenLinkInNewWindow", (long) QWebEnginePage::WebAction::OpenLinkInNewWindow))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBACTION_IDX],
        Sbk_QWebEnginePage_TypeF(), "OpenLinkInNewTab", (long) QWebEnginePage::WebAction::OpenLinkInNewTab))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBACTION_IDX],
        Sbk_QWebEnginePage_TypeF(), "CopyLinkToClipboard", (long) QWebEnginePage::WebAction::CopyLinkToClipboard))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBACTION_IDX],
        Sbk_QWebEnginePage_TypeF(), "DownloadLinkToDisk", (long) QWebEnginePage::WebAction::DownloadLinkToDisk))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBACTION_IDX],
        Sbk_QWebEnginePage_TypeF(), "CopyImageToClipboard", (long) QWebEnginePage::WebAction::CopyImageToClipboard))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBACTION_IDX],
        Sbk_QWebEnginePage_TypeF(), "CopyImageUrlToClipboard", (long) QWebEnginePage::WebAction::CopyImageUrlToClipboard))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBACTION_IDX],
        Sbk_QWebEnginePage_TypeF(), "DownloadImageToDisk", (long) QWebEnginePage::WebAction::DownloadImageToDisk))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBACTION_IDX],
        Sbk_QWebEnginePage_TypeF(), "CopyMediaUrlToClipboard", (long) QWebEnginePage::WebAction::CopyMediaUrlToClipboard))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBACTION_IDX],
        Sbk_QWebEnginePage_TypeF(), "ToggleMediaControls", (long) QWebEnginePage::WebAction::ToggleMediaControls))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBACTION_IDX],
        Sbk_QWebEnginePage_TypeF(), "ToggleMediaLoop", (long) QWebEnginePage::WebAction::ToggleMediaLoop))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBACTION_IDX],
        Sbk_QWebEnginePage_TypeF(), "ToggleMediaPlayPause", (long) QWebEnginePage::WebAction::ToggleMediaPlayPause))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBACTION_IDX],
        Sbk_QWebEnginePage_TypeF(), "ToggleMediaMute", (long) QWebEnginePage::WebAction::ToggleMediaMute))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBACTION_IDX],
        Sbk_QWebEnginePage_TypeF(), "DownloadMediaToDisk", (long) QWebEnginePage::WebAction::DownloadMediaToDisk))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBACTION_IDX],
        Sbk_QWebEnginePage_TypeF(), "InspectElement", (long) QWebEnginePage::WebAction::InspectElement))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBACTION_IDX],
        Sbk_QWebEnginePage_TypeF(), "ExitFullScreen", (long) QWebEnginePage::WebAction::ExitFullScreen))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBACTION_IDX],
        Sbk_QWebEnginePage_TypeF(), "RequestClose", (long) QWebEnginePage::WebAction::RequestClose))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBACTION_IDX],
        Sbk_QWebEnginePage_TypeF(), "Unselect", (long) QWebEnginePage::WebAction::Unselect))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBACTION_IDX],
        Sbk_QWebEnginePage_TypeF(), "SavePage", (long) QWebEnginePage::WebAction::SavePage))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBACTION_IDX],
        Sbk_QWebEnginePage_TypeF(), "OpenLinkInNewBackgroundTab", (long) QWebEnginePage::WebAction::OpenLinkInNewBackgroundTab))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBACTION_IDX],
        Sbk_QWebEnginePage_TypeF(), "ViewSource", (long) QWebEnginePage::WebAction::ViewSource))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBACTION_IDX],
        Sbk_QWebEnginePage_TypeF(), "ToggleBold", (long) QWebEnginePage::WebAction::ToggleBold))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBACTION_IDX],
        Sbk_QWebEnginePage_TypeF(), "ToggleItalic", (long) QWebEnginePage::WebAction::ToggleItalic))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBACTION_IDX],
        Sbk_QWebEnginePage_TypeF(), "ToggleUnderline", (long) QWebEnginePage::WebAction::ToggleUnderline))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBACTION_IDX],
        Sbk_QWebEnginePage_TypeF(), "ToggleStrikethrough", (long) QWebEnginePage::WebAction::ToggleStrikethrough))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBACTION_IDX],
        Sbk_QWebEnginePage_TypeF(), "AlignLeft", (long) QWebEnginePage::WebAction::AlignLeft))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBACTION_IDX],
        Sbk_QWebEnginePage_TypeF(), "AlignCenter", (long) QWebEnginePage::WebAction::AlignCenter))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBACTION_IDX],
        Sbk_QWebEnginePage_TypeF(), "AlignRight", (long) QWebEnginePage::WebAction::AlignRight))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBACTION_IDX],
        Sbk_QWebEnginePage_TypeF(), "AlignJustified", (long) QWebEnginePage::WebAction::AlignJustified))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBACTION_IDX],
        Sbk_QWebEnginePage_TypeF(), "Indent", (long) QWebEnginePage::WebAction::Indent))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBACTION_IDX],
        Sbk_QWebEnginePage_TypeF(), "Outdent", (long) QWebEnginePage::WebAction::Outdent))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBACTION_IDX],
        Sbk_QWebEnginePage_TypeF(), "InsertOrderedList", (long) QWebEnginePage::WebAction::InsertOrderedList))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBACTION_IDX],
        Sbk_QWebEnginePage_TypeF(), "InsertUnorderedList", (long) QWebEnginePage::WebAction::InsertUnorderedList))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBACTION_IDX],
        Sbk_QWebEnginePage_TypeF(), "WebActionCount", (long) QWebEnginePage::WebAction::WebActionCount))
        return;
    // Register converter for enum 'QWebEnginePage::WebAction'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBACTION_IDX],
            QWebEnginePage_WebAction_CppToPython_QWebEnginePage_WebAction);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QWebEnginePage_WebAction_PythonToCpp_QWebEnginePage_WebAction,
            is_QWebEnginePage_WebAction_PythonToCpp_QWebEnginePage_WebAction_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBACTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QWebEnginePage::WebAction");
        Shiboken::Conversions::registerConverterName(converter, "WebAction");
    }
    // End of 'WebAction' enum.

    // Initialization of enum 'FindFlag'.
    SbkPySide2_QtWebEngineWidgetsTypes[SBK_QFLAGS_QWEBENGINEPAGE_FINDFLAG_IDX] = PySide::QFlags::create("2:PySide2.QtWebEngineWidgets.QWebEnginePage.FindFlags", SbkPySide2_QtWebEngineWidgets_QWebEnginePage_FindFlag_number_slots);
    SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_FINDFLAG_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QWebEnginePage_TypeF(),
        "FindFlag",
        "2:PySide2.QtWebEngineWidgets.QWebEnginePage.FindFlag",
        "QWebEnginePage::FindFlag",
        SbkPySide2_QtWebEngineWidgetsTypes[SBK_QFLAGS_QWEBENGINEPAGE_FINDFLAG_IDX]);
    if (!SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_FINDFLAG_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_FINDFLAG_IDX],
        Sbk_QWebEnginePage_TypeF(), "FindBackward", (long) QWebEnginePage::FindFlag::FindBackward))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_FINDFLAG_IDX],
        Sbk_QWebEnginePage_TypeF(), "FindCaseSensitively", (long) QWebEnginePage::FindFlag::FindCaseSensitively))
        return;
    // Register converter for enum 'QWebEnginePage::FindFlag'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_FINDFLAG_IDX],
            QWebEnginePage_FindFlag_CppToPython_QWebEnginePage_FindFlag);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QWebEnginePage_FindFlag_PythonToCpp_QWebEnginePage_FindFlag,
            is_QWebEnginePage_FindFlag_PythonToCpp_QWebEnginePage_FindFlag_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_FINDFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QWebEnginePage::FindFlag");
        Shiboken::Conversions::registerConverterName(converter, "FindFlag");
    }
    // Register converter for flag 'QFlags<QWebEnginePage::FindFlag>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QFLAGS_QWEBENGINEPAGE_FINDFLAG_IDX],
            QFlags_QWebEnginePage_FindFlag__CppToPython_QFlags_QWebEnginePage_FindFlag_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QWebEnginePage_FindFlag_PythonToCpp_QFlags_QWebEnginePage_FindFlag_,
            is_QWebEnginePage_FindFlag_PythonToCpp_QFlags_QWebEnginePage_FindFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QWebEnginePage_FindFlag__PythonToCpp_QFlags_QWebEnginePage_FindFlag_,
            is_QFlags_QWebEnginePage_FindFlag__PythonToCpp_QFlags_QWebEnginePage_FindFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QWebEnginePage_FindFlag_,
            is_number_PythonToCpp_QFlags_QWebEnginePage_FindFlag__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QFLAGS_QWEBENGINEPAGE_FINDFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QWebEnginePage::FindFlags");
        Shiboken::Conversions::registerConverterName(converter, "FindFlags");
    }
    // End of 'FindFlag' enum/flags.

    // Initialization of enum 'WebWindowType'.
    SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBWINDOWTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QWebEnginePage_TypeF(),
        "WebWindowType",
        "2:PySide2.QtWebEngineWidgets.QWebEnginePage.WebWindowType",
        "QWebEnginePage::WebWindowType");
    if (!SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBWINDOWTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBWINDOWTYPE_IDX],
        Sbk_QWebEnginePage_TypeF(), "WebBrowserWindow", (long) QWebEnginePage::WebWindowType::WebBrowserWindow))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBWINDOWTYPE_IDX],
        Sbk_QWebEnginePage_TypeF(), "WebBrowserTab", (long) QWebEnginePage::WebWindowType::WebBrowserTab))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBWINDOWTYPE_IDX],
        Sbk_QWebEnginePage_TypeF(), "WebDialog", (long) QWebEnginePage::WebWindowType::WebDialog))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBWINDOWTYPE_IDX],
        Sbk_QWebEnginePage_TypeF(), "WebBrowserBackgroundTab", (long) QWebEnginePage::WebWindowType::WebBrowserBackgroundTab))
        return;
    // Register converter for enum 'QWebEnginePage::WebWindowType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBWINDOWTYPE_IDX],
            QWebEnginePage_WebWindowType_CppToPython_QWebEnginePage_WebWindowType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QWebEnginePage_WebWindowType_PythonToCpp_QWebEnginePage_WebWindowType,
            is_QWebEnginePage_WebWindowType_PythonToCpp_QWebEnginePage_WebWindowType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_WEBWINDOWTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QWebEnginePage::WebWindowType");
        Shiboken::Conversions::registerConverterName(converter, "WebWindowType");
    }
    // End of 'WebWindowType' enum.

    // Initialization of enum 'PermissionPolicy'.
    SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_PERMISSIONPOLICY_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QWebEnginePage_TypeF(),
        "PermissionPolicy",
        "2:PySide2.QtWebEngineWidgets.QWebEnginePage.PermissionPolicy",
        "QWebEnginePage::PermissionPolicy");
    if (!SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_PERMISSIONPOLICY_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_PERMISSIONPOLICY_IDX],
        Sbk_QWebEnginePage_TypeF(), "PermissionUnknown", (long) QWebEnginePage::PermissionPolicy::PermissionUnknown))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_PERMISSIONPOLICY_IDX],
        Sbk_QWebEnginePage_TypeF(), "PermissionGrantedByUser", (long) QWebEnginePage::PermissionPolicy::PermissionGrantedByUser))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_PERMISSIONPOLICY_IDX],
        Sbk_QWebEnginePage_TypeF(), "PermissionDeniedByUser", (long) QWebEnginePage::PermissionPolicy::PermissionDeniedByUser))
        return;
    // Register converter for enum 'QWebEnginePage::PermissionPolicy'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_PERMISSIONPOLICY_IDX],
            QWebEnginePage_PermissionPolicy_CppToPython_QWebEnginePage_PermissionPolicy);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QWebEnginePage_PermissionPolicy_PythonToCpp_QWebEnginePage_PermissionPolicy,
            is_QWebEnginePage_PermissionPolicy_PythonToCpp_QWebEnginePage_PermissionPolicy_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_PERMISSIONPOLICY_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QWebEnginePage::PermissionPolicy");
        Shiboken::Conversions::registerConverterName(converter, "PermissionPolicy");
    }
    // End of 'PermissionPolicy' enum.

    // Initialization of enum 'NavigationType'.
    SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_NAVIGATIONTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QWebEnginePage_TypeF(),
        "NavigationType",
        "2:PySide2.QtWebEngineWidgets.QWebEnginePage.NavigationType",
        "QWebEnginePage::NavigationType");
    if (!SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_NAVIGATIONTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_NAVIGATIONTYPE_IDX],
        Sbk_QWebEnginePage_TypeF(), "NavigationTypeLinkClicked", (long) QWebEnginePage::NavigationType::NavigationTypeLinkClicked))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_NAVIGATIONTYPE_IDX],
        Sbk_QWebEnginePage_TypeF(), "NavigationTypeTyped", (long) QWebEnginePage::NavigationType::NavigationTypeTyped))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_NAVIGATIONTYPE_IDX],
        Sbk_QWebEnginePage_TypeF(), "NavigationTypeFormSubmitted", (long) QWebEnginePage::NavigationType::NavigationTypeFormSubmitted))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_NAVIGATIONTYPE_IDX],
        Sbk_QWebEnginePage_TypeF(), "NavigationTypeBackForward", (long) QWebEnginePage::NavigationType::NavigationTypeBackForward))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_NAVIGATIONTYPE_IDX],
        Sbk_QWebEnginePage_TypeF(), "NavigationTypeReload", (long) QWebEnginePage::NavigationType::NavigationTypeReload))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_NAVIGATIONTYPE_IDX],
        Sbk_QWebEnginePage_TypeF(), "NavigationTypeOther", (long) QWebEnginePage::NavigationType::NavigationTypeOther))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_NAVIGATIONTYPE_IDX],
        Sbk_QWebEnginePage_TypeF(), "NavigationTypeRedirect", (long) QWebEnginePage::NavigationType::NavigationTypeRedirect))
        return;
    // Register converter for enum 'QWebEnginePage::NavigationType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_NAVIGATIONTYPE_IDX],
            QWebEnginePage_NavigationType_CppToPython_QWebEnginePage_NavigationType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QWebEnginePage_NavigationType_PythonToCpp_QWebEnginePage_NavigationType,
            is_QWebEnginePage_NavigationType_PythonToCpp_QWebEnginePage_NavigationType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_NAVIGATIONTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QWebEnginePage::NavigationType");
        Shiboken::Conversions::registerConverterName(converter, "NavigationType");
    }
    // End of 'NavigationType' enum.

    // Initialization of enum 'Feature'.
    SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_FEATURE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QWebEnginePage_TypeF(),
        "Feature",
        "2:PySide2.QtWebEngineWidgets.QWebEnginePage.Feature",
        "QWebEnginePage::Feature");
    if (!SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_FEATURE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_FEATURE_IDX],
        Sbk_QWebEnginePage_TypeF(), "Notifications", (long) QWebEnginePage::Feature::Notifications))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_FEATURE_IDX],
        Sbk_QWebEnginePage_TypeF(), "Geolocation", (long) QWebEnginePage::Feature::Geolocation))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_FEATURE_IDX],
        Sbk_QWebEnginePage_TypeF(), "MediaAudioCapture", (long) QWebEnginePage::Feature::MediaAudioCapture))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_FEATURE_IDX],
        Sbk_QWebEnginePage_TypeF(), "MediaVideoCapture", (long) QWebEnginePage::Feature::MediaVideoCapture))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_FEATURE_IDX],
        Sbk_QWebEnginePage_TypeF(), "MediaAudioVideoCapture", (long) QWebEnginePage::Feature::MediaAudioVideoCapture))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_FEATURE_IDX],
        Sbk_QWebEnginePage_TypeF(), "MouseLock", (long) QWebEnginePage::Feature::MouseLock))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_FEATURE_IDX],
        Sbk_QWebEnginePage_TypeF(), "DesktopVideoCapture", (long) QWebEnginePage::Feature::DesktopVideoCapture))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_FEATURE_IDX],
        Sbk_QWebEnginePage_TypeF(), "DesktopAudioVideoCapture", (long) QWebEnginePage::Feature::DesktopAudioVideoCapture))
        return;
    // Register converter for enum 'QWebEnginePage::Feature'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_FEATURE_IDX],
            QWebEnginePage_Feature_CppToPython_QWebEnginePage_Feature);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QWebEnginePage_Feature_PythonToCpp_QWebEnginePage_Feature,
            is_QWebEnginePage_Feature_PythonToCpp_QWebEnginePage_Feature_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_FEATURE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QWebEnginePage::Feature");
        Shiboken::Conversions::registerConverterName(converter, "Feature");
    }
    // End of 'Feature' enum.

    // Initialization of enum 'FileSelectionMode'.
    SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_FILESELECTIONMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QWebEnginePage_TypeF(),
        "FileSelectionMode",
        "2:PySide2.QtWebEngineWidgets.QWebEnginePage.FileSelectionMode",
        "QWebEnginePage::FileSelectionMode");
    if (!SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_FILESELECTIONMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_FILESELECTIONMODE_IDX],
        Sbk_QWebEnginePage_TypeF(), "FileSelectOpen", (long) QWebEnginePage::FileSelectionMode::FileSelectOpen))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_FILESELECTIONMODE_IDX],
        Sbk_QWebEnginePage_TypeF(), "FileSelectOpenMultiple", (long) QWebEnginePage::FileSelectionMode::FileSelectOpenMultiple))
        return;
    // Register converter for enum 'QWebEnginePage::FileSelectionMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_FILESELECTIONMODE_IDX],
            QWebEnginePage_FileSelectionMode_CppToPython_QWebEnginePage_FileSelectionMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QWebEnginePage_FileSelectionMode_PythonToCpp_QWebEnginePage_FileSelectionMode,
            is_QWebEnginePage_FileSelectionMode_PythonToCpp_QWebEnginePage_FileSelectionMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_FILESELECTIONMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QWebEnginePage::FileSelectionMode");
        Shiboken::Conversions::registerConverterName(converter, "FileSelectionMode");
    }
    // End of 'FileSelectionMode' enum.

    // Initialization of enum 'JavaScriptConsoleMessageLevel'.
    SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_JAVASCRIPTCONSOLEMESSAGELEVEL_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QWebEnginePage_TypeF(),
        "JavaScriptConsoleMessageLevel",
        "2:PySide2.QtWebEngineWidgets.QWebEnginePage.JavaScriptConsoleMessageLevel",
        "QWebEnginePage::JavaScriptConsoleMessageLevel");
    if (!SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_JAVASCRIPTCONSOLEMESSAGELEVEL_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_JAVASCRIPTCONSOLEMESSAGELEVEL_IDX],
        Sbk_QWebEnginePage_TypeF(), "InfoMessageLevel", (long) QWebEnginePage::JavaScriptConsoleMessageLevel::InfoMessageLevel))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_JAVASCRIPTCONSOLEMESSAGELEVEL_IDX],
        Sbk_QWebEnginePage_TypeF(), "WarningMessageLevel", (long) QWebEnginePage::JavaScriptConsoleMessageLevel::WarningMessageLevel))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_JAVASCRIPTCONSOLEMESSAGELEVEL_IDX],
        Sbk_QWebEnginePage_TypeF(), "ErrorMessageLevel", (long) QWebEnginePage::JavaScriptConsoleMessageLevel::ErrorMessageLevel))
        return;
    // Register converter for enum 'QWebEnginePage::JavaScriptConsoleMessageLevel'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_JAVASCRIPTCONSOLEMESSAGELEVEL_IDX],
            QWebEnginePage_JavaScriptConsoleMessageLevel_CppToPython_QWebEnginePage_JavaScriptConsoleMessageLevel);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QWebEnginePage_JavaScriptConsoleMessageLevel_PythonToCpp_QWebEnginePage_JavaScriptConsoleMessageLevel,
            is_QWebEnginePage_JavaScriptConsoleMessageLevel_PythonToCpp_QWebEnginePage_JavaScriptConsoleMessageLevel_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_JAVASCRIPTCONSOLEMESSAGELEVEL_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QWebEnginePage::JavaScriptConsoleMessageLevel");
        Shiboken::Conversions::registerConverterName(converter, "JavaScriptConsoleMessageLevel");
    }
    // End of 'JavaScriptConsoleMessageLevel' enum.

    // Initialization of enum 'RenderProcessTerminationStatus'.
    SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_RENDERPROCESSTERMINATIONSTATUS_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QWebEnginePage_TypeF(),
        "RenderProcessTerminationStatus",
        "2:PySide2.QtWebEngineWidgets.QWebEnginePage.RenderProcessTerminationStatus",
        "QWebEnginePage::RenderProcessTerminationStatus");
    if (!SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_RENDERPROCESSTERMINATIONSTATUS_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_RENDERPROCESSTERMINATIONSTATUS_IDX],
        Sbk_QWebEnginePage_TypeF(), "NormalTerminationStatus", (long) QWebEnginePage::RenderProcessTerminationStatus::NormalTerminationStatus))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_RENDERPROCESSTERMINATIONSTATUS_IDX],
        Sbk_QWebEnginePage_TypeF(), "AbnormalTerminationStatus", (long) QWebEnginePage::RenderProcessTerminationStatus::AbnormalTerminationStatus))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_RENDERPROCESSTERMINATIONSTATUS_IDX],
        Sbk_QWebEnginePage_TypeF(), "CrashedTerminationStatus", (long) QWebEnginePage::RenderProcessTerminationStatus::CrashedTerminationStatus))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_RENDERPROCESSTERMINATIONSTATUS_IDX],
        Sbk_QWebEnginePage_TypeF(), "KilledTerminationStatus", (long) QWebEnginePage::RenderProcessTerminationStatus::KilledTerminationStatus))
        return;
    // Register converter for enum 'QWebEnginePage::RenderProcessTerminationStatus'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_RENDERPROCESSTERMINATIONSTATUS_IDX],
            QWebEnginePage_RenderProcessTerminationStatus_CppToPython_QWebEnginePage_RenderProcessTerminationStatus);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QWebEnginePage_RenderProcessTerminationStatus_PythonToCpp_QWebEnginePage_RenderProcessTerminationStatus,
            is_QWebEnginePage_RenderProcessTerminationStatus_PythonToCpp_QWebEnginePage_RenderProcessTerminationStatus_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_RENDERPROCESSTERMINATIONSTATUS_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QWebEnginePage::RenderProcessTerminationStatus");
        Shiboken::Conversions::registerConverterName(converter, "RenderProcessTerminationStatus");
    }
    // End of 'RenderProcessTerminationStatus' enum.

    // Initialization of enum 'LifecycleState'.
    SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_LIFECYCLESTATE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QWebEnginePage_TypeF(),
        "LifecycleState",
        "2:PySide2.QtWebEngineWidgets.QWebEnginePage.LifecycleState",
        "QWebEnginePage::LifecycleState");
    if (!SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_LIFECYCLESTATE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_LIFECYCLESTATE_IDX],
        SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_LIFECYCLESTATE_IDX], "Active", (long) QWebEnginePage::LifecycleState::Active))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_LIFECYCLESTATE_IDX],
        SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_LIFECYCLESTATE_IDX], "Frozen", (long) QWebEnginePage::LifecycleState::Frozen))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_LIFECYCLESTATE_IDX],
        SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_LIFECYCLESTATE_IDX], "Discarded", (long) QWebEnginePage::LifecycleState::Discarded))
        return;
    // Register converter for enum 'QWebEnginePage::LifecycleState'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_LIFECYCLESTATE_IDX],
            QWebEnginePage_LifecycleState_CppToPython_QWebEnginePage_LifecycleState);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QWebEnginePage_LifecycleState_PythonToCpp_QWebEnginePage_LifecycleState,
            is_QWebEnginePage_LifecycleState_PythonToCpp_QWebEnginePage_LifecycleState_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINEPAGE_LIFECYCLESTATE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QWebEnginePage::LifecycleState");
        Shiboken::Conversions::registerConverterName(converter, "LifecycleState");
    }
    // End of 'LifecycleState' enum.

    PySide::Signal::registerSignals(Sbk_QWebEnginePage_TypeF(), &::QWebEnginePage::staticMetaObject);
    qRegisterMetaType< ::QWebEnginePage::WebAction >("QWebEnginePage::WebAction");
    qRegisterMetaType< ::QWebEnginePage::FindFlag >("QWebEnginePage::FindFlag");
    qRegisterMetaType< ::QWebEnginePage::FindFlags >("QWebEnginePage::FindFlags");
    qRegisterMetaType< ::QWebEnginePage::WebWindowType >("QWebEnginePage::WebWindowType");
    qRegisterMetaType< ::QWebEnginePage::PermissionPolicy >("QWebEnginePage::PermissionPolicy");
    qRegisterMetaType< ::QWebEnginePage::NavigationType >("QWebEnginePage::NavigationType");
    qRegisterMetaType< ::QWebEnginePage::Feature >("QWebEnginePage::Feature");
    qRegisterMetaType< ::QWebEnginePage::FileSelectionMode >("QWebEnginePage::FileSelectionMode");
    qRegisterMetaType< ::QWebEnginePage::JavaScriptConsoleMessageLevel >("QWebEnginePage::JavaScriptConsoleMessageLevel");
    qRegisterMetaType< ::QWebEnginePage::RenderProcessTerminationStatus >("QWebEnginePage::RenderProcessTerminationStatus");
    qRegisterMetaType< ::QWebEnginePage::LifecycleState >("QWebEnginePage::LifecycleState");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QWebEnginePage_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QWebEnginePage_TypeF(), &::QWebEnginePage::staticMetaObject, sizeof(QWebEnginePageWrapper));
}
