/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtwebsockets_python.h"

// main header
#include "qwebsocket_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QWebSocketWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QWebSocketWrapper::QWebSocketWrapper(const ::QString & origin, ::QWebSocketProtocol::Version version, ::QObject * parent) : QWebSocket(origin, version, parent)
{
    resetPyMethodCache();
    // ... middle
}

void QWebSocketWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QWebSocketWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QWebSocketWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QWebSocketWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QWebSocketWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QWebSocket.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QWebSocketWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QWebSocket.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QWebSocketWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QWebSocketWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QWebSocket::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QWebSocketWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QWebSocket::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QWebSocketWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QWebSocketWrapper *>(this));
        return QWebSocket::qt_metacast(_clname);
}

QWebSocketWrapper::~QWebSocketWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QWebSocket_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QWebSocket >()))
        return -1;

    ::QWebSocketWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocket.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|OOO:QWebSocket", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return -1;


    // Overloaded function decisor
    // 0: QWebSocket::QWebSocket(QString,QWebSocketProtocol::Version,QObject*)
    if (numArgs == 0) {
        overloadId = 0; // QWebSocket(QString,QWebSocketProtocol::Version,QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // QWebSocket(QString,QWebSocketProtocol::Version,QObject*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETPROTOCOL_VERSION_IDX])->converter, (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // QWebSocket(QString,QWebSocketProtocol::Version,QObject*)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[2])))) {
                overloadId = 0; // QWebSocket(QString,QWebSocketProtocol::Version,QObject*)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebSocket_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_origin = Shiboken::String::createStaticString("origin");
            if (PyDict_Contains(kwds, key_origin)) {
                value = PyDict_GetItem(kwds, key_origin);
                if (value && pyArgs[0]) {
                    errInfo = key_origin;
                    Py_INCREF(errInfo);
                    goto Sbk_QWebSocket_Init_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0]))))
                        goto Sbk_QWebSocket_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_origin);
            }
            static PyObject *const key_version = Shiboken::String::createStaticString("version");
            if (PyDict_Contains(kwds, key_version)) {
                value = PyDict_GetItem(kwds, key_version);
                if (value && pyArgs[1]) {
                    errInfo = key_version;
                    Py_INCREF(errInfo);
                    goto Sbk_QWebSocket_Init_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETPROTOCOL_VERSION_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QWebSocket_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_version);
            }
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[2]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_QWebSocket_Init_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[2]))))
                        goto Sbk_QWebSocket_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                // fall through to handle extra keyword signals and properties
            }
        }
        ::QString cppArg0 = QString();
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QWebSocketProtocol::Version cppArg1 = QWebSocketProtocol::VersionLatest;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return -1;
        ::QObject *cppArg2 = nullptr;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // QWebSocket(QString,QWebSocketProtocol::Version,QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QWebSocketWrapper(cppArg0, cppArg1, cppArg2);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QWebSocketWrapper(cppArg0, cppArg1, cppArg2);
            }

            Shiboken::Object::setParent(pyArgs[2], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QWebSocket >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QWebSocket_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QWebSocket_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QWebSocket_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QWebSocketFunc_abort(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocket.abort";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // abort()
            cppSelf->abort();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QWebSocketFunc_bytesToWrite(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocket.bytesToWrite";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // bytesToWrite()const
            qint64 cppResult = const_cast<const ::QWebSocket *>(cppSelf)->bytesToWrite();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebSocketFunc_close(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocket.close";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QWebSocketFunc_close_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:close", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QWebSocket::close(QWebSocketProtocol::CloseCode,QString)
    if (numArgs == 0) {
        overloadId = 0; // close(QWebSocketProtocol::CloseCode,QString)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETPROTOCOL_CLOSECODE_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // close(QWebSocketProtocol::CloseCode,QString)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            overloadId = 0; // close(QWebSocketProtocol::CloseCode,QString)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebSocketFunc_close_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_closeCode = Shiboken::String::createStaticString("closeCode");
            if (PyDict_Contains(kwds, key_closeCode)) {
                value = PyDict_GetItem(kwds, key_closeCode);
                if (value && pyArgs[0]) {
                    errInfo = key_closeCode;
                    Py_INCREF(errInfo);
                    goto Sbk_QWebSocketFunc_close_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETPROTOCOL_CLOSECODE_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_QWebSocketFunc_close_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_closeCode);
            }
            static PyObject *const key_reason = Shiboken::String::createStaticString("reason");
            if (PyDict_Contains(kwds, key_reason)) {
                value = PyDict_GetItem(kwds, key_reason);
                if (value && pyArgs[1]) {
                    errInfo = key_reason;
                    Py_INCREF(errInfo);
                    goto Sbk_QWebSocketFunc_close_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1]))))
                        goto Sbk_QWebSocketFunc_close_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_reason);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QWebSocketFunc_close_TypeError;
            }
        }
        ::QWebSocketProtocol::CloseCode cppArg0 = QWebSocketProtocol::CloseCodeNormal;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1 = QString();
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // close(QWebSocketProtocol::CloseCode,QString)
            cppSelf->close(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebSocketFunc_close_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebSocketFunc_closeCode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocket.closeCode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // closeCode()const
            QWebSocketProtocol::CloseCode cppResult = const_cast<const ::QWebSocket *>(cppSelf)->closeCode();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETPROTOCOL_CLOSECODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebSocketFunc_closeReason(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocket.closeReason";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // closeReason()const
            QString cppResult = const_cast<const ::QWebSocket *>(cppSelf)->closeReason();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebSocketFunc_error(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocket.error";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // error()const
            QAbstractSocket::SocketError cppResult = const_cast<const ::QWebSocket *>(cppSelf)->error();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETERROR_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebSocketFunc_errorString(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocket.errorString";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // errorString()const
            QString cppResult = const_cast<const ::QWebSocket *>(cppSelf)->errorString();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebSocketFunc_flush(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocket.flush";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // flush()
            bool cppResult = cppSelf->flush();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebSocketFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocket.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::QWebSocket *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebSocketFunc_localAddress(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocket.localAddress";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // localAddress()const
            QHostAddress cppResult = const_cast<const ::QWebSocket *>(cppSelf)->localAddress();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebSocketFunc_localPort(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocket.localPort";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // localPort()const
            quint16 cppResult = const_cast<const ::QWebSocket *>(cppSelf)->localPort();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint16>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebSocketFunc_maskGenerator(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocket.maskGenerator";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // maskGenerator()const
            const QMaskGenerator * cppResult = const_cast<const ::QWebSocket *>(cppSelf)->maskGenerator();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebSocketsTypes[SBK_QMASKGENERATOR_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebSocketFunc_maxAllowedIncomingFrameSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocket.maxAllowedIncomingFrameSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // maxAllowedIncomingFrameSize()const
            quint64 cppResult = const_cast<const ::QWebSocket *>(cppSelf)->maxAllowedIncomingFrameSize();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebSocketFunc_maxAllowedIncomingMessageSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocket.maxAllowedIncomingMessageSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // maxAllowedIncomingMessageSize()const
            quint64 cppResult = const_cast<const ::QWebSocket *>(cppSelf)->maxAllowedIncomingMessageSize();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebSocketFunc_maxIncomingFrameSize(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocket.maxIncomingFrameSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // maxIncomingFrameSize()
            quint64 cppResult = ::QWebSocket::maxIncomingFrameSize();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebSocketFunc_maxIncomingMessageSize(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocket.maxIncomingMessageSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // maxIncomingMessageSize()
            quint64 cppResult = ::QWebSocket::maxIncomingMessageSize();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebSocketFunc_maxOutgoingFrameSize(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocket.maxOutgoingFrameSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // maxOutgoingFrameSize()
            quint64 cppResult = ::QWebSocket::maxOutgoingFrameSize();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebSocketFunc_open(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocket.open";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebSocket::open(QNetworkRequest)
    // 1: QWebSocket::open(QUrl)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArg)))) {
        overloadId = 1; // open(QUrl)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX]), (pyArg)))) {
        overloadId = 0; // open(QNetworkRequest)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebSocketFunc_open_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // open(const QNetworkRequest & request)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QNetworkRequest cppArg0_local;
            ::QNetworkRequest *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // open(QNetworkRequest)
                cppSelf->open(*cppArg0);
            }
            break;
        }
        case 1: // open(const QUrl & url)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QUrl cppArg0_local;
            ::QUrl *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // open(QUrl)
                cppSelf->open(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebSocketFunc_open_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebSocketFunc_origin(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocket.origin";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // origin()const
            QString cppResult = const_cast<const ::QWebSocket *>(cppSelf)->origin();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebSocketFunc_outgoingFrameSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocket.outgoingFrameSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // outgoingFrameSize()const
            quint64 cppResult = const_cast<const ::QWebSocket *>(cppSelf)->outgoingFrameSize();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebSocketFunc_pauseMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocket.pauseMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // pauseMode()const
            QFlags<QAbstractSocket::PauseMode> cppResult = const_cast<const ::QWebSocket *>(cppSelf)->pauseMode();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QABSTRACTSOCKET_PAUSEMODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebSocketFunc_peerAddress(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocket.peerAddress";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // peerAddress()const
            QHostAddress cppResult = const_cast<const ::QWebSocket *>(cppSelf)->peerAddress();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebSocketFunc_peerName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocket.peerName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // peerName()const
            QString cppResult = const_cast<const ::QWebSocket *>(cppSelf)->peerName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebSocketFunc_peerPort(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocket.peerPort";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // peerPort()const
            quint16 cppResult = const_cast<const ::QWebSocket *>(cppSelf)->peerPort();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint16>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebSocketFunc_ping(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocket.ping";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QWebSocketFunc_ping_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:ping", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QWebSocket::ping(QByteArray)
    if (numArgs == 0) {
        overloadId = 0; // ping(QByteArray)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))) {
        overloadId = 0; // ping(QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebSocketFunc_ping_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_payload = Shiboken::String::createStaticString("payload");
            if (PyDict_Contains(kwds, key_payload)) {
                value = PyDict_GetItem(kwds, key_payload);
                if (value && pyArgs[0]) {
                    errInfo = key_payload;
                    Py_INCREF(errInfo);
                    goto Sbk_QWebSocketFunc_ping_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0]))))
                        goto Sbk_QWebSocketFunc_ping_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_payload);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QWebSocketFunc_ping_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QByteArray cppArg0_local = QByteArray();
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0]) {
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);
        }

        if (!PyErr_Occurred()) {
            // ping(QByteArray)
            cppSelf->ping(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebSocketFunc_ping_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebSocketFunc_proxy(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocket.proxy";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // proxy()const
            QNetworkProxy cppResult = const_cast<const ::QWebSocket *>(cppSelf)->proxy();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebSocketFunc_readBufferSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocket.readBufferSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // readBufferSize()const
            qint64 cppResult = const_cast<const ::QWebSocket *>(cppSelf)->readBufferSize();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebSocketFunc_request(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocket.request";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // request()const
            QNetworkRequest cppResult = const_cast<const ::QWebSocket *>(cppSelf)->request();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebSocketFunc_requestUrl(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocket.requestUrl";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // requestUrl()const
            QUrl cppResult = const_cast<const ::QWebSocket *>(cppSelf)->requestUrl();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebSocketFunc_resourceName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocket.resourceName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // resourceName()const
            QString cppResult = const_cast<const ::QWebSocket *>(cppSelf)->resourceName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebSocketFunc_resume(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocket.resume";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // resume()
            cppSelf->resume();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QWebSocketFunc_sendBinaryMessage(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocket.sendBinaryMessage";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebSocket::sendBinaryMessage(QByteArray)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 0; // sendBinaryMessage(QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebSocketFunc_sendBinaryMessage_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // sendBinaryMessage(QByteArray)
            qint64 cppResult = cppSelf->sendBinaryMessage(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QWebSocketFunc_sendBinaryMessage_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebSocketFunc_sendTextMessage(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocket.sendTextMessage";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebSocket::sendTextMessage(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // sendTextMessage(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebSocketFunc_sendTextMessage_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // sendTextMessage(QString)
            qint64 cppResult = cppSelf->sendTextMessage(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QWebSocketFunc_sendTextMessage_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebSocketFunc_setMaskGenerator(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocket.setMaskGenerator";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebSocket::setMaskGenerator(const QMaskGenerator*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebSocketsTypes[SBK_QMASKGENERATOR_IDX]), (pyArg)))) {
        overloadId = 0; // setMaskGenerator(const QMaskGenerator*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebSocketFunc_setMaskGenerator_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMaskGenerator *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMaskGenerator(const QMaskGenerator*)
            cppSelf->setMaskGenerator(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebSocketFunc_setMaskGenerator_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebSocketFunc_setMaxAllowedIncomingFrameSize(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocket.setMaxAllowedIncomingFrameSize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebSocket::setMaxAllowedIncomingFrameSize(quint64)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), (pyArg)))) {
        overloadId = 0; // setMaxAllowedIncomingFrameSize(quint64)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebSocketFunc_setMaxAllowedIncomingFrameSize_TypeError;

    // Call function/method
    {
        quint64 cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMaxAllowedIncomingFrameSize(quint64)
            cppSelf->setMaxAllowedIncomingFrameSize(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebSocketFunc_setMaxAllowedIncomingFrameSize_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebSocketFunc_setMaxAllowedIncomingMessageSize(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocket.setMaxAllowedIncomingMessageSize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebSocket::setMaxAllowedIncomingMessageSize(quint64)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), (pyArg)))) {
        overloadId = 0; // setMaxAllowedIncomingMessageSize(quint64)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebSocketFunc_setMaxAllowedIncomingMessageSize_TypeError;

    // Call function/method
    {
        quint64 cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMaxAllowedIncomingMessageSize(quint64)
            cppSelf->setMaxAllowedIncomingMessageSize(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebSocketFunc_setMaxAllowedIncomingMessageSize_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebSocketFunc_setOutgoingFrameSize(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocket.setOutgoingFrameSize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebSocket::setOutgoingFrameSize(quint64)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), (pyArg)))) {
        overloadId = 0; // setOutgoingFrameSize(quint64)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebSocketFunc_setOutgoingFrameSize_TypeError;

    // Call function/method
    {
        quint64 cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setOutgoingFrameSize(quint64)
            cppSelf->setOutgoingFrameSize(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebSocketFunc_setOutgoingFrameSize_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebSocketFunc_setPauseMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocket.setPauseMode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebSocket::setPauseMode(QFlags<QAbstractSocket::PauseMode>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QABSTRACTSOCKET_PAUSEMODE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setPauseMode(QFlags<QAbstractSocket::PauseMode>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebSocketFunc_setPauseMode_TypeError;

    // Call function/method
    {
        ::QFlags<QAbstractSocket::PauseMode> cppArg0 = QFlags<QAbstractSocket::PauseMode>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPauseMode(QFlags<QAbstractSocket::PauseMode>)
            cppSelf->setPauseMode(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebSocketFunc_setPauseMode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebSocketFunc_setProxy(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocket.setProxy";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebSocket::setProxy(QNetworkProxy)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_IDX]), (pyArg)))) {
        overloadId = 0; // setProxy(QNetworkProxy)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebSocketFunc_setProxy_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QNetworkProxy cppArg0_local;
        ::QNetworkProxy *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setProxy(QNetworkProxy)
            cppSelf->setProxy(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebSocketFunc_setProxy_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebSocketFunc_setReadBufferSize(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocket.setReadBufferSize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebSocket::setReadBufferSize(qint64)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArg)))) {
        overloadId = 0; // setReadBufferSize(qint64)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebSocketFunc_setReadBufferSize_TypeError;

    // Call function/method
    {
        qint64 cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setReadBufferSize(qint64)
            cppSelf->setReadBufferSize(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebSocketFunc_setReadBufferSize_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebSocketFunc_state(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocket.state";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // state()const
            QAbstractSocket::SocketState cppResult = const_cast<const ::QWebSocket *>(cppSelf)->state();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETSTATE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebSocketFunc_version(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocket.version";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // version()const
            QWebSocketProtocol::Version cppResult = const_cast<const ::QWebSocket *>(cppSelf)->version();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETPROTOCOL_VERSION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QWebSocket_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QWebSocket_methods[] = {
    {"abort", reinterpret_cast<PyCFunction>(Sbk_QWebSocketFunc_abort), METH_NOARGS},
    {"bytesToWrite", reinterpret_cast<PyCFunction>(Sbk_QWebSocketFunc_bytesToWrite), METH_NOARGS},
    {"close", reinterpret_cast<PyCFunction>(Sbk_QWebSocketFunc_close), METH_VARARGS|METH_KEYWORDS},
    {"closeCode", reinterpret_cast<PyCFunction>(Sbk_QWebSocketFunc_closeCode), METH_NOARGS},
    {"closeReason", reinterpret_cast<PyCFunction>(Sbk_QWebSocketFunc_closeReason), METH_NOARGS},
    {"error", reinterpret_cast<PyCFunction>(Sbk_QWebSocketFunc_error), METH_NOARGS},
    {"errorString", reinterpret_cast<PyCFunction>(Sbk_QWebSocketFunc_errorString), METH_NOARGS},
    {"flush", reinterpret_cast<PyCFunction>(Sbk_QWebSocketFunc_flush), METH_NOARGS},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_QWebSocketFunc_isValid), METH_NOARGS},
    {"localAddress", reinterpret_cast<PyCFunction>(Sbk_QWebSocketFunc_localAddress), METH_NOARGS},
    {"localPort", reinterpret_cast<PyCFunction>(Sbk_QWebSocketFunc_localPort), METH_NOARGS},
    {"maskGenerator", reinterpret_cast<PyCFunction>(Sbk_QWebSocketFunc_maskGenerator), METH_NOARGS},
    {"maxAllowedIncomingFrameSize", reinterpret_cast<PyCFunction>(Sbk_QWebSocketFunc_maxAllowedIncomingFrameSize), METH_NOARGS},
    {"maxAllowedIncomingMessageSize", reinterpret_cast<PyCFunction>(Sbk_QWebSocketFunc_maxAllowedIncomingMessageSize), METH_NOARGS},
    {"maxIncomingFrameSize", reinterpret_cast<PyCFunction>(Sbk_QWebSocketFunc_maxIncomingFrameSize), METH_NOARGS|METH_STATIC},
    {"maxIncomingMessageSize", reinterpret_cast<PyCFunction>(Sbk_QWebSocketFunc_maxIncomingMessageSize), METH_NOARGS|METH_STATIC},
    {"maxOutgoingFrameSize", reinterpret_cast<PyCFunction>(Sbk_QWebSocketFunc_maxOutgoingFrameSize), METH_NOARGS|METH_STATIC},
    {"open", reinterpret_cast<PyCFunction>(Sbk_QWebSocketFunc_open), METH_O},
    {"origin", reinterpret_cast<PyCFunction>(Sbk_QWebSocketFunc_origin), METH_NOARGS},
    {"outgoingFrameSize", reinterpret_cast<PyCFunction>(Sbk_QWebSocketFunc_outgoingFrameSize), METH_NOARGS},
    {"pauseMode", reinterpret_cast<PyCFunction>(Sbk_QWebSocketFunc_pauseMode), METH_NOARGS},
    {"peerAddress", reinterpret_cast<PyCFunction>(Sbk_QWebSocketFunc_peerAddress), METH_NOARGS},
    {"peerName", reinterpret_cast<PyCFunction>(Sbk_QWebSocketFunc_peerName), METH_NOARGS},
    {"peerPort", reinterpret_cast<PyCFunction>(Sbk_QWebSocketFunc_peerPort), METH_NOARGS},
    {"ping", reinterpret_cast<PyCFunction>(Sbk_QWebSocketFunc_ping), METH_VARARGS|METH_KEYWORDS},
    {"proxy", reinterpret_cast<PyCFunction>(Sbk_QWebSocketFunc_proxy), METH_NOARGS},
    {"readBufferSize", reinterpret_cast<PyCFunction>(Sbk_QWebSocketFunc_readBufferSize), METH_NOARGS},
    {"request", reinterpret_cast<PyCFunction>(Sbk_QWebSocketFunc_request), METH_NOARGS},
    {"requestUrl", reinterpret_cast<PyCFunction>(Sbk_QWebSocketFunc_requestUrl), METH_NOARGS},
    {"resourceName", reinterpret_cast<PyCFunction>(Sbk_QWebSocketFunc_resourceName), METH_NOARGS},
    {"resume", reinterpret_cast<PyCFunction>(Sbk_QWebSocketFunc_resume), METH_NOARGS},
    {"sendBinaryMessage", reinterpret_cast<PyCFunction>(Sbk_QWebSocketFunc_sendBinaryMessage), METH_O},
    {"sendTextMessage", reinterpret_cast<PyCFunction>(Sbk_QWebSocketFunc_sendTextMessage), METH_O},
    {"setMaskGenerator", reinterpret_cast<PyCFunction>(Sbk_QWebSocketFunc_setMaskGenerator), METH_O},
    {"setMaxAllowedIncomingFrameSize", reinterpret_cast<PyCFunction>(Sbk_QWebSocketFunc_setMaxAllowedIncomingFrameSize), METH_O},
    {"setMaxAllowedIncomingMessageSize", reinterpret_cast<PyCFunction>(Sbk_QWebSocketFunc_setMaxAllowedIncomingMessageSize), METH_O},
    {"setOutgoingFrameSize", reinterpret_cast<PyCFunction>(Sbk_QWebSocketFunc_setOutgoingFrameSize), METH_O},
    {"setPauseMode", reinterpret_cast<PyCFunction>(Sbk_QWebSocketFunc_setPauseMode), METH_O},
    {"setProxy", reinterpret_cast<PyCFunction>(Sbk_QWebSocketFunc_setProxy), METH_O},
    {"setReadBufferSize", reinterpret_cast<PyCFunction>(Sbk_QWebSocketFunc_setReadBufferSize), METH_O},
    {"state", reinterpret_cast<PyCFunction>(Sbk_QWebSocketFunc_state), METH_NOARGS},
    {"version", reinterpret_cast<PyCFunction>(Sbk_QWebSocketFunc_version), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QWebSocket_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QWebSocket *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKET_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QWebSocketWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QWebSocket_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QWebSocket_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QWebSocket_Type = nullptr;
static SbkObjectType *Sbk_QWebSocket_TypeF(void)
{
    return _Sbk_QWebSocket_Type;
}

static PyType_Slot Sbk_QWebSocket_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QWebSocket_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QWebSocket_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QWebSocket_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QWebSocket_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QWebSocket_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QWebSocket_spec = {
    "2:PySide2.QtWebSockets.QWebSocket",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QWebSocket_slots
};

} //extern "C"

static void *Sbk_QWebSocket_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QWebSocket *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QWebSocket_PythonToCpp_QWebSocket_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QWebSocket_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QWebSocket_PythonToCpp_QWebSocket_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QWebSocket_TypeF())))
        return QWebSocket_PythonToCpp_QWebSocket_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QWebSocket_PTR_CppToPython_QWebSocket(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QWebSocket *>(const_cast<void *>(cppIn)), Sbk_QWebSocket_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QWebSocket_SignatureStrings[] = {
    "PySide2.QtWebSockets.QWebSocket(self,origin:QString=QString(),version:PySide2.QtWebSockets.QWebSocketProtocol.Version=QWebSocketProtocol.VersionLatest,parent:PySide2.QtCore.QObject=nullptr)",
    "PySide2.QtWebSockets.QWebSocket.abort(self)",
    "PySide2.QtWebSockets.QWebSocket.bytesToWrite(self)->qint64",
    "PySide2.QtWebSockets.QWebSocket.close(self,closeCode:PySide2.QtWebSockets.QWebSocketProtocol.CloseCode=QWebSocketProtocol.CloseCodeNormal,reason:QString=QString())",
    "PySide2.QtWebSockets.QWebSocket.closeCode(self)->PySide2.QtWebSockets.QWebSocketProtocol.CloseCode",
    "PySide2.QtWebSockets.QWebSocket.closeReason(self)->QString",
    "PySide2.QtWebSockets.QWebSocket.error(self)->PySide2.QtNetwork.QAbstractSocket.SocketError",
    "PySide2.QtWebSockets.QWebSocket.errorString(self)->QString",
    "PySide2.QtWebSockets.QWebSocket.flush(self)->bool",
    "PySide2.QtWebSockets.QWebSocket.isValid(self)->bool",
    "PySide2.QtWebSockets.QWebSocket.localAddress(self)->PySide2.QtNetwork.QHostAddress",
    "PySide2.QtWebSockets.QWebSocket.localPort(self)->quint16",
    "PySide2.QtWebSockets.QWebSocket.maskGenerator(self)->PySide2.QtWebSockets.QMaskGenerator",
    "PySide2.QtWebSockets.QWebSocket.maxAllowedIncomingFrameSize(self)->quint64",
    "PySide2.QtWebSockets.QWebSocket.maxAllowedIncomingMessageSize(self)->quint64",
    "PySide2.QtWebSockets.QWebSocket.maxIncomingFrameSize()->quint64",
    "PySide2.QtWebSockets.QWebSocket.maxIncomingMessageSize()->quint64",
    "PySide2.QtWebSockets.QWebSocket.maxOutgoingFrameSize()->quint64",
    "1:PySide2.QtWebSockets.QWebSocket.open(self,request:PySide2.QtNetwork.QNetworkRequest)",
    "0:PySide2.QtWebSockets.QWebSocket.open(self,url:PySide2.QtCore.QUrl)",
    "PySide2.QtWebSockets.QWebSocket.origin(self)->QString",
    "PySide2.QtWebSockets.QWebSocket.outgoingFrameSize(self)->quint64",
    "PySide2.QtWebSockets.QWebSocket.pauseMode(self)->PySide2.QtNetwork.QAbstractSocket.PauseModes",
    "PySide2.QtWebSockets.QWebSocket.peerAddress(self)->PySide2.QtNetwork.QHostAddress",
    "PySide2.QtWebSockets.QWebSocket.peerName(self)->QString",
    "PySide2.QtWebSockets.QWebSocket.peerPort(self)->quint16",
    "PySide2.QtWebSockets.QWebSocket.ping(self,payload:PySide2.QtCore.QByteArray=QByteArray())",
    "PySide2.QtWebSockets.QWebSocket.proxy(self)->PySide2.QtNetwork.QNetworkProxy",
    "PySide2.QtWebSockets.QWebSocket.readBufferSize(self)->qint64",
    "PySide2.QtWebSockets.QWebSocket.request(self)->PySide2.QtNetwork.QNetworkRequest",
    "PySide2.QtWebSockets.QWebSocket.requestUrl(self)->PySide2.QtCore.QUrl",
    "PySide2.QtWebSockets.QWebSocket.resourceName(self)->QString",
    "PySide2.QtWebSockets.QWebSocket.resume(self)",
    "PySide2.QtWebSockets.QWebSocket.sendBinaryMessage(self,data:PySide2.QtCore.QByteArray)->qint64",
    "PySide2.QtWebSockets.QWebSocket.sendTextMessage(self,message:QString)->qint64",
    "PySide2.QtWebSockets.QWebSocket.setMaskGenerator(self,maskGenerator:PySide2.QtWebSockets.QMaskGenerator)",
    "PySide2.QtWebSockets.QWebSocket.setMaxAllowedIncomingFrameSize(self,maxAllowedIncomingFrameSize:quint64)",
    "PySide2.QtWebSockets.QWebSocket.setMaxAllowedIncomingMessageSize(self,maxAllowedIncomingMessageSize:quint64)",
    "PySide2.QtWebSockets.QWebSocket.setOutgoingFrameSize(self,outgoingFrameSize:quint64)",
    "PySide2.QtWebSockets.QWebSocket.setPauseMode(self,pauseMode:PySide2.QtNetwork.QAbstractSocket.PauseModes)",
    "PySide2.QtWebSockets.QWebSocket.setProxy(self,networkProxy:PySide2.QtNetwork.QNetworkProxy)",
    "PySide2.QtWebSockets.QWebSocket.setReadBufferSize(self,size:qint64)",
    "PySide2.QtWebSockets.QWebSocket.state(self)->PySide2.QtNetwork.QAbstractSocket.SocketState",
    "PySide2.QtWebSockets.QWebSocket.version(self)->PySide2.QtWebSockets.QWebSocketProtocol.Version",
    nullptr}; // Sentinel

void init_QWebSocket(PyObject *module)
{
    _Sbk_QWebSocket_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QWebSocket",
        "QWebSocket*",
        &Sbk_QWebSocket_spec,
        &Shiboken::callCppDestructor< ::QWebSocket >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QWebSocket_Type);
    InitSignatureStrings(pyType, QWebSocket_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QWebSocket_Type), Sbk_QWebSocket_PropertyStrings);
    SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKET_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QWebSocket_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QWebSocket_TypeF(),
        QWebSocket_PythonToCpp_QWebSocket_PTR,
        is_QWebSocket_PythonToCpp_QWebSocket_PTR_Convertible,
        QWebSocket_PTR_CppToPython_QWebSocket);

    Shiboken::Conversions::registerConverterName(converter, "QWebSocket");
    Shiboken::Conversions::registerConverterName(converter, "QWebSocket*");
    Shiboken::Conversions::registerConverterName(converter, "QWebSocket&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QWebSocket).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QWebSocketWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QWebSocket_TypeF(), &Sbk_QWebSocket_typeDiscovery);

    PySide::Signal::registerSignals(Sbk_QWebSocket_TypeF(), &::QWebSocket::staticMetaObject);
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QWebSocket_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QWebSocket_TypeF(), &::QWebSocket::staticMetaObject, sizeof(QWebSocketWrapper));
}
