/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtwebsockets_python.h"

// main header
#include "qwebsocketcorsauthenticator_wrapper.h"

// inner classes

// Extra includes
#include <QtWebSockets/qwebsocketcorsauthenticator.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QWebSocketCorsAuthenticator_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QWebSocketCorsAuthenticator >()))
        return -1;

    ::QWebSocketCorsAuthenticator *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocketCorsAuthenticator.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QWebSocketCorsAuthenticator", 1, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QWebSocketCorsAuthenticator::QWebSocketCorsAuthenticator(QString)
    // 1: QWebSocketCorsAuthenticator::QWebSocketCorsAuthenticator(QWebSocketCorsAuthenticator)
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETCORSAUTHENTICATOR_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QWebSocketCorsAuthenticator(QWebSocketCorsAuthenticator)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        overloadId = 0; // QWebSocketCorsAuthenticator(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebSocketCorsAuthenticator_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QWebSocketCorsAuthenticator(const QString & origin)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QWebSocketCorsAuthenticator(QString)
                cptr = new ::QWebSocketCorsAuthenticator(cppArg0);
            }
            break;
        }
        case 1: // QWebSocketCorsAuthenticator(const QWebSocketCorsAuthenticator & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QWebSocketCorsAuthenticator *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QWebSocketCorsAuthenticator(QWebSocketCorsAuthenticator)
                cptr = new ::QWebSocketCorsAuthenticator(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QWebSocketCorsAuthenticator >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QWebSocketCorsAuthenticator_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QWebSocketCorsAuthenticator_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QWebSocketCorsAuthenticatorFunc_allowed(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocketCorsAuthenticator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETCORSAUTHENTICATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocketCorsAuthenticator.allowed";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // allowed()const
            bool cppResult = const_cast<const ::QWebSocketCorsAuthenticator *>(cppSelf)->allowed();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebSocketCorsAuthenticatorFunc_origin(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocketCorsAuthenticator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETCORSAUTHENTICATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocketCorsAuthenticator.origin";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // origin()const
            QString cppResult = const_cast<const ::QWebSocketCorsAuthenticator *>(cppSelf)->origin();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebSocketCorsAuthenticatorFunc_setAllowed(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocketCorsAuthenticator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETCORSAUTHENTICATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocketCorsAuthenticator.setAllowed";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebSocketCorsAuthenticator::setAllowed(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setAllowed(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebSocketCorsAuthenticatorFunc_setAllowed_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAllowed(bool)
            cppSelf->setAllowed(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebSocketCorsAuthenticatorFunc_setAllowed_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebSocketCorsAuthenticatorFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocketCorsAuthenticator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETCORSAUTHENTICATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocketCorsAuthenticator.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebSocketCorsAuthenticator::swap(QWebSocketCorsAuthenticator&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETCORSAUTHENTICATOR_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QWebSocketCorsAuthenticator&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebSocketCorsAuthenticatorFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWebSocketCorsAuthenticator *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // swap(QWebSocketCorsAuthenticator&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebSocketCorsAuthenticatorFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QWebSocketCorsAuthenticator_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QWebSocketCorsAuthenticator_methods[] = {
    {"allowed", reinterpret_cast<PyCFunction>(Sbk_QWebSocketCorsAuthenticatorFunc_allowed), METH_NOARGS},
    {"origin", reinterpret_cast<PyCFunction>(Sbk_QWebSocketCorsAuthenticatorFunc_origin), METH_NOARGS},
    {"setAllowed", reinterpret_cast<PyCFunction>(Sbk_QWebSocketCorsAuthenticatorFunc_setAllowed), METH_O},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QWebSocketCorsAuthenticatorFunc_swap), METH_O},

    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QWebSocketCorsAuthenticator_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QWebSocketCorsAuthenticator_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QWebSocketCorsAuthenticator_Type = nullptr;
static SbkObjectType *Sbk_QWebSocketCorsAuthenticator_TypeF(void)
{
    return _Sbk_QWebSocketCorsAuthenticator_Type;
}

static PyType_Slot Sbk_QWebSocketCorsAuthenticator_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QWebSocketCorsAuthenticator_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QWebSocketCorsAuthenticator_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QWebSocketCorsAuthenticator_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QWebSocketCorsAuthenticator_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QWebSocketCorsAuthenticator_spec = {
    "2:PySide2.QtWebSockets.QWebSocketCorsAuthenticator",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QWebSocketCorsAuthenticator_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QWebSocketCorsAuthenticator_PythonToCpp_QWebSocketCorsAuthenticator_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QWebSocketCorsAuthenticator_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QWebSocketCorsAuthenticator_PythonToCpp_QWebSocketCorsAuthenticator_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QWebSocketCorsAuthenticator_TypeF())))
        return QWebSocketCorsAuthenticator_PythonToCpp_QWebSocketCorsAuthenticator_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QWebSocketCorsAuthenticator_PTR_CppToPython_QWebSocketCorsAuthenticator(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QWebSocketCorsAuthenticator *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QWebSocketCorsAuthenticator_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QWebSocketCorsAuthenticator_SignatureStrings[] = {
    "1:PySide2.QtWebSockets.QWebSocketCorsAuthenticator(self,origin:QString)",
    "0:PySide2.QtWebSockets.QWebSocketCorsAuthenticator(self,other:PySide2.QtWebSockets.QWebSocketCorsAuthenticator)",
    "PySide2.QtWebSockets.QWebSocketCorsAuthenticator.allowed(self)->bool",
    "PySide2.QtWebSockets.QWebSocketCorsAuthenticator.origin(self)->QString",
    "PySide2.QtWebSockets.QWebSocketCorsAuthenticator.setAllowed(self,allowed:bool)",
    "PySide2.QtWebSockets.QWebSocketCorsAuthenticator.swap(self,other:PySide2.QtWebSockets.QWebSocketCorsAuthenticator)",
    nullptr}; // Sentinel

void init_QWebSocketCorsAuthenticator(PyObject *module)
{
    _Sbk_QWebSocketCorsAuthenticator_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QWebSocketCorsAuthenticator",
        "QWebSocketCorsAuthenticator*",
        &Sbk_QWebSocketCorsAuthenticator_spec,
        &Shiboken::callCppDestructor< ::QWebSocketCorsAuthenticator >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QWebSocketCorsAuthenticator_Type);
    InitSignatureStrings(pyType, QWebSocketCorsAuthenticator_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QWebSocketCorsAuthenticator_Type), Sbk_QWebSocketCorsAuthenticator_PropertyStrings);
    SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETCORSAUTHENTICATOR_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QWebSocketCorsAuthenticator_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QWebSocketCorsAuthenticator_TypeF(),
        QWebSocketCorsAuthenticator_PythonToCpp_QWebSocketCorsAuthenticator_PTR,
        is_QWebSocketCorsAuthenticator_PythonToCpp_QWebSocketCorsAuthenticator_PTR_Convertible,
        QWebSocketCorsAuthenticator_PTR_CppToPython_QWebSocketCorsAuthenticator);

    Shiboken::Conversions::registerConverterName(converter, "QWebSocketCorsAuthenticator");
    Shiboken::Conversions::registerConverterName(converter, "QWebSocketCorsAuthenticator*");
    Shiboken::Conversions::registerConverterName(converter, "QWebSocketCorsAuthenticator&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QWebSocketCorsAuthenticator).name());


}
