/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <algorithm>
#include <set>
#include <iterator>

// module include
#include "pyside2_qtwidgets_python.h"

// main header
#include "qabstractspinbox_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QAbstractSpinBoxWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QAbstractSpinBoxWrapper::QAbstractSpinBoxWrapper(::QWidget * parent) : QAbstractSpinBox(parent)
{
    resetPyMethodCache();
    // ... middle
}

void QAbstractSpinBoxWrapper::actionEvent(::QActionEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QWidget::actionEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "actionEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QWidget::actionEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QACTIONEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractSpinBoxWrapper::changeEvent(::QEvent * event)
{
    if (m_PyMethodCache[1]) {
        return this->::QAbstractSpinBox::changeEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "changeEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QAbstractSpinBox::changeEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractSpinBoxWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractSpinBoxWrapper::clear()
{
    if (m_PyMethodCache[3]) {
        return this->::QAbstractSpinBox::clear();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "clear";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QAbstractSpinBox::clear();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstractSpinBoxWrapper::closeEvent(::QCloseEvent * event)
{
    if (m_PyMethodCache[4]) {
        return this->::QAbstractSpinBox::closeEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "closeEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QAbstractSpinBox::closeEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCLOSEEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractSpinBoxWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[5]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstractSpinBoxWrapper::contextMenuEvent(::QContextMenuEvent * event)
{
    if (m_PyMethodCache[6]) {
        return this->::QAbstractSpinBox::contextMenuEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "contextMenuEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        return this->::QAbstractSpinBox::contextMenuEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCONTEXTMENUEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractSpinBoxWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

int QAbstractSpinBoxWrapper::devType() const
{
    if (m_PyMethodCache[8])
        return this->::QWidget::devType();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "devType";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        return this->::QWidget::devType();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractSpinBox.devType", "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QAbstractSpinBoxWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[9]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[9] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstractSpinBoxWrapper::dragEnterEvent(::QDragEnterEvent * event)
{
    if (m_PyMethodCache[10]) {
        return this->::QWidget::dragEnterEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "dragEnterEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[10] = true;
        return this->::QWidget::dragEnterEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QDRAGENTEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractSpinBoxWrapper::dragLeaveEvent(::QDragLeaveEvent * event)
{
    if (m_PyMethodCache[11]) {
        return this->::QWidget::dragLeaveEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "dragLeaveEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[11] = true;
        return this->::QWidget::dragLeaveEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QDRAGLEAVEEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractSpinBoxWrapper::dragMoveEvent(::QDragMoveEvent * event)
{
    if (m_PyMethodCache[12]) {
        return this->::QWidget::dragMoveEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "dragMoveEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[12] = true;
        return this->::QWidget::dragMoveEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QDRAGMOVEEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractSpinBoxWrapper::dropEvent(::QDropEvent * event)
{
    if (m_PyMethodCache[13]) {
        return this->::QWidget::dropEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "dropEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[13] = true;
        return this->::QWidget::dropEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QDROPEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractSpinBoxWrapper::enterEvent(::QEvent * event)
{
    if (m_PyMethodCache[14]) {
        return this->::QWidget::enterEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "enterEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[14] = true;
        return this->::QWidget::enterEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

bool QAbstractSpinBoxWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[15])
        return this->::QAbstractSpinBox::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[15] = true;
        return this->::QAbstractSpinBox::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractSpinBox.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QAbstractSpinBoxWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[16])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[16] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractSpinBox.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QAbstractSpinBoxWrapper::fixup(::QString & input) const
{
    if (m_PyMethodCache[17]) {
        return this->::QAbstractSpinBox::fixup(input);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "fixup";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[17] = true;
        return this->::QAbstractSpinBox::fixup(input);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &input)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }

}

void QAbstractSpinBoxWrapper::focusInEvent(::QFocusEvent * event)
{
    if (m_PyMethodCache[18]) {
        return this->::QAbstractSpinBox::focusInEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "focusInEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[18] = true;
        return this->::QAbstractSpinBox::focusInEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFOCUSEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

bool QAbstractSpinBoxWrapper::focusNextPrevChild(bool next)
{
    if (m_PyMethodCache[19])
        return this->::QWidget::focusNextPrevChild(next);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "focusNextPrevChild";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[19] = true;
        return this->::QWidget::focusNextPrevChild(next);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &next)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractSpinBox.focusNextPrevChild", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QAbstractSpinBoxWrapper::focusOutEvent(::QFocusEvent * event)
{
    if (m_PyMethodCache[20]) {
        return this->::QAbstractSpinBox::focusOutEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "focusOutEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[20] = true;
        return this->::QAbstractSpinBox::focusOutEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFOCUSEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

bool QAbstractSpinBoxWrapper::hasHeightForWidth() const
{
    if (m_PyMethodCache[21])
        return this->::QWidget::hasHeightForWidth();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "hasHeightForWidth";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[21] = true;
        return this->::QWidget::hasHeightForWidth();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractSpinBox.hasHeightForWidth", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

int QAbstractSpinBoxWrapper::heightForWidth(int arg__1) const
{
    if (m_PyMethodCache[22])
        return this->::QWidget::heightForWidth(arg__1);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "heightForWidth";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[22] = true;
        return this->::QWidget::heightForWidth(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(i)",
    arg__1
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractSpinBox.heightForWidth", "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QAbstractSpinBoxWrapper::hideEvent(::QHideEvent * event)
{
    if (m_PyMethodCache[23]) {
        return this->::QAbstractSpinBox::hideEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "hideEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[23] = true;
        return this->::QAbstractSpinBox::hideEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QHIDEEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractSpinBoxWrapper::initPainter(::QPainter * painter) const
{
    if (m_PyMethodCache[24]) {
        return this->::QWidget::initPainter(painter);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "initPainter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[24] = true;
        return this->::QWidget::initPainter(painter);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX]), painter)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstractSpinBoxWrapper::inputMethodEvent(::QInputMethodEvent * event)
{
    if (m_PyMethodCache[25]) {
        return this->::QWidget::inputMethodEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "inputMethodEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[25] = true;
        return this->::QWidget::inputMethodEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHODEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

::QVariant QAbstractSpinBoxWrapper::inputMethodQuery(::Qt::InputMethodQuery arg__1) const
{
    if (m_PyMethodCache[26])
        return this->::QAbstractSpinBox::inputMethodQuery(arg__1);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return ::QVariant();
    static PyObject *nameCache[2] = {};
    static const char *funcName = "inputMethodQuery";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[26] = true;
        return this->::QAbstractSpinBox::inputMethodQuery(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODQUERY_IDX])->converter, &arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return ::QVariant();
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractSpinBox.inputMethodQuery", "QVariant", Py_TYPE(pyResult)->tp_name);
        return ::QVariant();
    }
    ::QVariant cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QAbstractSpinBoxWrapper::keyPressEvent(::QKeyEvent * event)
{
    if (m_PyMethodCache[27]) {
        return this->::QAbstractSpinBox::keyPressEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "keyPressEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[27] = true;
        return this->::QAbstractSpinBox::keyPressEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractSpinBoxWrapper::keyReleaseEvent(::QKeyEvent * event)
{
    if (m_PyMethodCache[28]) {
        return this->::QAbstractSpinBox::keyReleaseEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "keyReleaseEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[28] = true;
        return this->::QAbstractSpinBox::keyReleaseEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractSpinBoxWrapper::leaveEvent(::QEvent * event)
{
    if (m_PyMethodCache[29]) {
        return this->::QWidget::leaveEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "leaveEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[29] = true;
        return this->::QWidget::leaveEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

int QAbstractSpinBoxWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    if (m_PyMethodCache[31])
        return this->::QWidget::metric(arg__1);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "metric";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[31] = true;
        return this->::QWidget::metric(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAINTDEVICE_PAINTDEVICEMETRIC_IDX])->converter, &arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractSpinBox.metric", "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QSize QAbstractSpinBoxWrapper::minimumSizeHint() const
{
    if (m_PyMethodCache[32])
        return this->::QAbstractSpinBox::minimumSizeHint();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "minimumSizeHint";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[32] = true;
        return this->::QAbstractSpinBox::minimumSizeHint();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractSpinBox.minimumSizeHint", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QSize >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QSize cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QAbstractSpinBoxWrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    if (m_PyMethodCache[33]) {
        return this->::QWidget::mouseDoubleClickEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "mouseDoubleClickEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[33] = true;
        return this->::QWidget::mouseDoubleClickEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMOUSEEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractSpinBoxWrapper::mouseMoveEvent(::QMouseEvent * event)
{
    if (m_PyMethodCache[34]) {
        return this->::QAbstractSpinBox::mouseMoveEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "mouseMoveEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[34] = true;
        return this->::QAbstractSpinBox::mouseMoveEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMOUSEEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractSpinBoxWrapper::mousePressEvent(::QMouseEvent * event)
{
    if (m_PyMethodCache[35]) {
        return this->::QAbstractSpinBox::mousePressEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "mousePressEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[35] = true;
        return this->::QAbstractSpinBox::mousePressEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMOUSEEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractSpinBoxWrapper::mouseReleaseEvent(::QMouseEvent * event)
{
    if (m_PyMethodCache[36]) {
        return this->::QAbstractSpinBox::mouseReleaseEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "mouseReleaseEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[36] = true;
        return this->::QAbstractSpinBox::mouseReleaseEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMOUSEEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractSpinBoxWrapper::moveEvent(::QMoveEvent * event)
{
    if (m_PyMethodCache[37]) {
        return this->::QWidget::moveEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "moveEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[37] = true;
        return this->::QWidget::moveEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMOVEEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

bool QAbstractSpinBoxWrapper::nativeEvent(const ::QByteArray & eventType, void * message, long * result)
{
    if (m_PyMethodCache[38]) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "nativeEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[38] = true;
        return this->::QWidget::nativeEvent(eventType, message, result);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &eventType),
    Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), message)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Begin code injection
    // TEMPLATE - return_native_eventfilter_conversion - START
    bool cppResult = false;
    if (PySequence_Check(pyResult) && (PySequence_Size(pyResult) == 2)) {
        Shiboken::AutoDecRef pyItem(PySequence_GetItem(pyResult, 0));
        Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyItem, &(cppResult));
        if (result) {
            Shiboken::AutoDecRef pyResultItem(PySequence_GetItem(pyResult, 1));
            Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<long>(), pyResultItem, (result));
        }
    }
    // TEMPLATE - return_native_eventfilter_conversion - END

    // End of code injection


    return cppResult;
}

::QPaintEngine * QAbstractSpinBoxWrapper::paintEngine() const
{
    if (m_PyMethodCache[39])
        return this->::QWidget::paintEngine();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "paintEngine";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[39] = true;
        return this->::QWidget::paintEngine();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractSpinBox.paintEngine", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QPaintEngine >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QPaintEngine *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QAbstractSpinBoxWrapper::paintEvent(::QPaintEvent * event)
{
    if (m_PyMethodCache[40]) {
        return this->::QAbstractSpinBox::paintEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "paintEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[40] = true;
        return this->::QAbstractSpinBox::paintEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

::QPaintDevice * QAbstractSpinBoxWrapper::redirected(::QPoint * offset) const
{
    if (m_PyMethodCache[41])
        return this->::QWidget::redirected(offset);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "redirected";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[41] = true;
        return this->::QWidget::redirected(offset);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), offset)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTDEVICE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractSpinBox.redirected", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QPaintDevice >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QPaintDevice *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QAbstractSpinBoxWrapper::resizeEvent(::QResizeEvent * event)
{
    if (m_PyMethodCache[42]) {
        return this->::QAbstractSpinBox::resizeEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "resizeEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[42] = true;
        return this->::QAbstractSpinBox::resizeEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QRESIZEEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractSpinBoxWrapper::setVisible(bool visible)
{
    if (m_PyMethodCache[43]) {
        return this->::QWidget::setVisible(visible);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    // This method belongs to a property.
    static const char *funcName = "2:setVisible";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[43] = true;
        return this->::QWidget::setVisible(visible);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &visible)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

::QPainter * QAbstractSpinBoxWrapper::sharedPainter() const
{
    if (m_PyMethodCache[44])
        return this->::QWidget::sharedPainter();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "sharedPainter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[44] = true;
        return this->::QWidget::sharedPainter();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractSpinBox.sharedPainter", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QPainter >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QPainter *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QAbstractSpinBoxWrapper::showEvent(::QShowEvent * event)
{
    if (m_PyMethodCache[45]) {
        return this->::QAbstractSpinBox::showEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "showEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[45] = true;
        return this->::QAbstractSpinBox::showEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSHOWEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

::QSize QAbstractSpinBoxWrapper::sizeHint() const
{
    if (m_PyMethodCache[46])
        return this->::QAbstractSpinBox::sizeHint();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "sizeHint";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[46] = true;
        return this->::QAbstractSpinBox::sizeHint();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractSpinBox.sizeHint", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QSize >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QSize cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QAbstractSpinBoxWrapper::stepBy(int steps)
{
    if (m_PyMethodCache[47]) {
        return this->::QAbstractSpinBox::stepBy(steps);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "stepBy";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[47] = true;
        return this->::QAbstractSpinBox::stepBy(steps);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(i)",
    steps
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

::QFlags<QAbstractSpinBox::StepEnabledFlag> QAbstractSpinBoxWrapper::stepEnabled() const
{
    if (m_PyMethodCache[48])
        return this->::QAbstractSpinBox::stepEnabled();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return QFlags<QAbstractSpinBox::StepEnabledFlag>(0);
    static PyObject *nameCache[2] = {};
    static const char *funcName = "stepEnabled";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[48] = true;
        return this->::QAbstractSpinBox::stepEnabled();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QFlags<QAbstractSpinBox::StepEnabledFlag>(0);
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QABSTRACTSPINBOX_STEPENABLEDFLAG_IDX])->converter, pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractSpinBox.stepEnabled", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QFlags<QAbstractSpinBox::StepEnabledFlag> >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return QFlags<QAbstractSpinBox::StepEnabledFlag>(0);
    }
    ::QFlags<QAbstractSpinBox::StepEnabledFlag> cppResult = QFlags<QAbstractSpinBox::StepEnabledFlag>(0);
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QAbstractSpinBoxWrapper::tabletEvent(::QTabletEvent * event)
{
    if (m_PyMethodCache[49]) {
        return this->::QWidget::tabletEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "tabletEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[49] = true;
        return this->::QWidget::tabletEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTABLETEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractSpinBoxWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[50]) {
        return this->::QAbstractSpinBox::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[50] = true;
        return this->::QAbstractSpinBox::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

::QValidator::State QAbstractSpinBoxWrapper::validate(::QString & input, int & pos) const
{
    if (m_PyMethodCache[51]) {
        return this->::QAbstractSpinBox::validate(input, pos);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return QValidator::Invalid;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "validate";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[51] = true;
        return this->::QAbstractSpinBox::validate(input, pos);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &input),
    Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &pos)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QValidator::Invalid;
    }
    // Begin code injection
    // TEMPLATE - validator_conversionrule - START
    QValidator::State cppResult;

    if (PySequence_Check(pyResult)) {
        Shiboken::AutoDecRef seq(PySequence_Fast(pyResult, 0));
        int size = PySequence_Fast_GET_SIZE(seq.object());

        if (size > 1) {
            if (Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], PySequence_Fast_GET_ITEM(seq.object(), 1)))
                Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], PySequence_Fast_GET_ITEM(seq.object(), 1), &(input));
            else
                qWarning("QAbstractSpinBox::validate: Second tuple element is not convertible to unicode.");
        }

        if (size > 2) {
            if (Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), PySequence_Fast_GET_ITEM(seq.object(), 2)))
                Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<int>(), PySequence_Fast_GET_ITEM(seq.object(), 2), &(pos));
            else
                qWarning("QAbstractSpinBox::validate: Second tuple element is not convertible to int.");
        }
        pyResult.reset(PySequence_Fast_GET_ITEM(seq.object(), 0));
        Py_INCREF(pyResult); // we need to incref, because "pyResult = ..." will decref the tuple and the tuple will be decrefed again at the end of this scope.
    }

    // check retrun value
    if (Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QVALIDATOR_STATE_IDX])->converter, pyResult)) {
        Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QVALIDATOR_STATE_IDX])->converter, pyResult, &(cppResult));
    } else {
        PyErr_Format(PyExc_TypeError, "Invalid return value in function %s, expected %s, got %s.",
                    "QValidator.validate",
                    "PySide2.QtGui.QValidator.State, (PySide2.QtGui.QValidator.State,), (PySide2.QtGui.QValidator.State, unicode) or (PySide2.QtGui.QValidator.State, unicode, int)",
                    Py_TYPE(pyResult)->tp_name);
        return QValidator::State();
    }
    // TEMPLATE - validator_conversionrule - END

    // End of code injection


    return cppResult;
}

void QAbstractSpinBoxWrapper::wheelEvent(::QWheelEvent * event)
{
    if (m_PyMethodCache[52]) {
        return this->::QAbstractSpinBox::wheelEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "wheelEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[52] = true;
        return this->::QAbstractSpinBox::wheelEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QWHEELEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QAbstractSpinBoxWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QAbstractSpinBox::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QAbstractSpinBoxWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QAbstractSpinBox::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QAbstractSpinBoxWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QAbstractSpinBoxWrapper *>(this));
        return QAbstractSpinBox::qt_metacast(_clname);
}

QAbstractSpinBoxWrapper::~QAbstractSpinBoxWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QAbstractSpinBox_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QAbstractSpinBox >()))
        return -1;

    ::QAbstractSpinBoxWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractSpinBox.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|O:QAbstractSpinBox", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QAbstractSpinBox::QAbstractSpinBox(QWidget*)
    if (numArgs == 0) {
        overloadId = 0; // QAbstractSpinBox(QWidget*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QAbstractSpinBox(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractSpinBox_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[0]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_QAbstractSpinBox_Init_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[0]))))
                        goto Sbk_QAbstractSpinBox_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                // fall through to handle extra keyword signals and properties
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QWidget *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QAbstractSpinBox(QWidget*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QAbstractSpinBoxWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QAbstractSpinBoxWrapper(cppArg0);
            }

            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QAbstractSpinBox >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QAbstractSpinBox_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QAbstractSpinBox_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QAbstractSpinBox_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QAbstractSpinBoxFunc_alignment(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSpinBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractSpinBox.alignment";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // alignment()const
            QFlags<Qt::AlignmentFlag> cppResult = const_cast<const ::QAbstractSpinBox *>(cppSelf)->alignment();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ALIGNMENTFLAG_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractSpinBoxFunc_buttonSymbols(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSpinBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractSpinBox.buttonSymbols";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // buttonSymbols()const
            QAbstractSpinBox::ButtonSymbols cppResult = const_cast<const ::QAbstractSpinBox *>(cppSelf)->buttonSymbols();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_BUTTONSYMBOLS_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractSpinBoxFunc_changeEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSpinBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractSpinBox.changeEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::changeEvent(QEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // changeEvent(QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractSpinBoxFunc_changeEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // changeEvent(QEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractSpinBox::changeEvent(cppArg0)
                : cppSelf->changeEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractSpinBoxFunc_changeEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractSpinBoxFunc_clear(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSpinBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractSpinBox.clear";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clear()
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractSpinBox::clear()
                : cppSelf->clear();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QAbstractSpinBoxFunc_closeEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSpinBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractSpinBox.closeEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::closeEvent(QCloseEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCLOSEEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // closeEvent(QCloseEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractSpinBoxFunc_closeEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QCloseEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // closeEvent(QCloseEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractSpinBox::closeEvent(cppArg0)
                : cppSelf->closeEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractSpinBoxFunc_closeEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractSpinBoxFunc_contextMenuEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSpinBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractSpinBox.contextMenuEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::contextMenuEvent(QContextMenuEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCONTEXTMENUEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // contextMenuEvent(QContextMenuEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractSpinBoxFunc_contextMenuEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QContextMenuEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // contextMenuEvent(QContextMenuEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractSpinBox::contextMenuEvent(cppArg0)
                : cppSelf->contextMenuEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractSpinBoxFunc_contextMenuEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractSpinBoxFunc_correctionMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSpinBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractSpinBox.correctionMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // correctionMode()const
            QAbstractSpinBox::CorrectionMode cppResult = const_cast<const ::QAbstractSpinBox *>(cppSelf)->correctionMode();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_CORRECTIONMODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractSpinBoxFunc_event(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSpinBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractSpinBox.event";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QObject::event(QEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // event(QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractSpinBoxFunc_event_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // event(QEvent*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractSpinBox::event(cppArg0)
                : cppSelf->event(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractSpinBoxFunc_event_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractSpinBoxFunc_fixup(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSpinBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractSpinBox.fixup";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractSpinBox::fixup(QString&)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // fixup(QString&)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractSpinBoxFunc_fixup_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // fixup(QString&)const
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QAbstractSpinBox *>(cppSelf)->::QAbstractSpinBox::fixup(cppArg0)
                : const_cast<const ::QAbstractSpinBox *>(cppSelf)->fixup(cppArg0);
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtcore.cpp (qstring-return)]
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppArg0);
            // END of custom code block [file: ../glue/qtcore.cpp (qstring-return)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractSpinBoxFunc_fixup_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractSpinBoxFunc_focusInEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSpinBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractSpinBox.focusInEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::focusInEvent(QFocusEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFOCUSEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // focusInEvent(QFocusEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractSpinBoxFunc_focusInEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QFocusEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // focusInEvent(QFocusEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractSpinBox::focusInEvent(cppArg0)
                : cppSelf->focusInEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractSpinBoxFunc_focusInEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractSpinBoxFunc_focusOutEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSpinBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractSpinBox.focusOutEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::focusOutEvent(QFocusEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFOCUSEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // focusOutEvent(QFocusEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractSpinBoxFunc_focusOutEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QFocusEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // focusOutEvent(QFocusEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractSpinBox::focusOutEvent(cppArg0)
                : cppSelf->focusOutEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractSpinBoxFunc_focusOutEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractSpinBoxFunc_hasAcceptableInput(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSpinBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractSpinBox.hasAcceptableInput";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hasAcceptableInput()const
            bool cppResult = const_cast<const ::QAbstractSpinBox *>(cppSelf)->hasAcceptableInput();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractSpinBoxFunc_hasFrame(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSpinBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractSpinBox.hasFrame";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hasFrame()const
            bool cppResult = const_cast<const ::QAbstractSpinBox *>(cppSelf)->hasFrame();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractSpinBoxFunc_hideEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSpinBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractSpinBox.hideEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::hideEvent(QHideEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QHIDEEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // hideEvent(QHideEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractSpinBoxFunc_hideEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QHideEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // hideEvent(QHideEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractSpinBox::hideEvent(cppArg0)
                : cppSelf->hideEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractSpinBoxFunc_hideEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractSpinBoxFunc_initStyleOption(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSpinBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractSpinBox.initStyleOption";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractSpinBox::initStyleOption(QStyleOptionSpinBox*)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONSPINBOX_IDX]), (pyArg)))) {
        overloadId = 0; // initStyleOption(QStyleOptionSpinBox*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractSpinBoxFunc_initStyleOption_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QStyleOptionSpinBox *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // initStyleOption(QStyleOptionSpinBox*)const
            const_cast<const ::QAbstractSpinBox *>(cppSelf)->initStyleOption(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractSpinBoxFunc_initStyleOption_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractSpinBoxFunc_inputMethodQuery(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSpinBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractSpinBox.inputMethodQuery";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::inputMethodQuery(Qt::InputMethodQuery)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODQUERY_IDX])->converter, (pyArg)))) {
        overloadId = 0; // inputMethodQuery(Qt::InputMethodQuery)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractSpinBoxFunc_inputMethodQuery_TypeError;

    // Call function/method
    {
        ::Qt::InputMethodQuery cppArg0 = static_cast< ::Qt::InputMethodQuery>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // inputMethodQuery(Qt::InputMethodQuery)const
            QVariant cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QAbstractSpinBox *>(cppSelf)->::QAbstractSpinBox::inputMethodQuery(cppArg0)
                : const_cast<const ::QAbstractSpinBox *>(cppSelf)->inputMethodQuery(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractSpinBoxFunc_inputMethodQuery_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractSpinBoxFunc_interpretText(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSpinBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractSpinBox.interpretText";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // interpretText()
            cppSelf->interpretText();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QAbstractSpinBoxFunc_isAccelerated(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSpinBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractSpinBox.isAccelerated";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isAccelerated()const
            bool cppResult = const_cast<const ::QAbstractSpinBox *>(cppSelf)->isAccelerated();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractSpinBoxFunc_isGroupSeparatorShown(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSpinBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractSpinBox.isGroupSeparatorShown";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isGroupSeparatorShown()const
            bool cppResult = const_cast<const ::QAbstractSpinBox *>(cppSelf)->isGroupSeparatorShown();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractSpinBoxFunc_isReadOnly(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSpinBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractSpinBox.isReadOnly";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isReadOnly()const
            bool cppResult = const_cast<const ::QAbstractSpinBox *>(cppSelf)->isReadOnly();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractSpinBoxFunc_keyPressEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSpinBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractSpinBox.keyPressEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::keyPressEvent(QKeyEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // keyPressEvent(QKeyEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractSpinBoxFunc_keyPressEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QKeyEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // keyPressEvent(QKeyEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractSpinBox::keyPressEvent(cppArg0)
                : cppSelf->keyPressEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractSpinBoxFunc_keyPressEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractSpinBoxFunc_keyReleaseEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSpinBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractSpinBox.keyReleaseEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::keyReleaseEvent(QKeyEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // keyReleaseEvent(QKeyEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractSpinBoxFunc_keyReleaseEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QKeyEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // keyReleaseEvent(QKeyEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractSpinBox::keyReleaseEvent(cppArg0)
                : cppSelf->keyReleaseEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractSpinBoxFunc_keyReleaseEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractSpinBoxFunc_keyboardTracking(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSpinBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractSpinBox.keyboardTracking";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // keyboardTracking()const
            bool cppResult = const_cast<const ::QAbstractSpinBox *>(cppSelf)->keyboardTracking();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractSpinBoxFunc_lineEdit(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSpinBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractSpinBox.lineEdit";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // lineEdit()const
            QLineEdit * cppResult = const_cast<const ::QAbstractSpinBox *>(cppSelf)->lineEdit();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QLINEEDIT_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractSpinBoxFunc_minimumSizeHint(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSpinBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractSpinBox.minimumSizeHint";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // minimumSizeHint()const
            QSize cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QAbstractSpinBox *>(cppSelf)->::QAbstractSpinBox::minimumSizeHint()
                : const_cast<const ::QAbstractSpinBox *>(cppSelf)->minimumSizeHint();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractSpinBoxFunc_mouseMoveEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSpinBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractSpinBox.mouseMoveEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::mouseMoveEvent(QMouseEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMOUSEEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // mouseMoveEvent(QMouseEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractSpinBoxFunc_mouseMoveEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMouseEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // mouseMoveEvent(QMouseEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractSpinBox::mouseMoveEvent(cppArg0)
                : cppSelf->mouseMoveEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractSpinBoxFunc_mouseMoveEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractSpinBoxFunc_mousePressEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSpinBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractSpinBox.mousePressEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::mousePressEvent(QMouseEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMOUSEEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // mousePressEvent(QMouseEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractSpinBoxFunc_mousePressEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMouseEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // mousePressEvent(QMouseEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractSpinBox::mousePressEvent(cppArg0)
                : cppSelf->mousePressEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractSpinBoxFunc_mousePressEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractSpinBoxFunc_mouseReleaseEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSpinBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractSpinBox.mouseReleaseEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::mouseReleaseEvent(QMouseEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMOUSEEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // mouseReleaseEvent(QMouseEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractSpinBoxFunc_mouseReleaseEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMouseEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // mouseReleaseEvent(QMouseEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractSpinBox::mouseReleaseEvent(cppArg0)
                : cppSelf->mouseReleaseEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractSpinBoxFunc_mouseReleaseEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractSpinBoxFunc_paintEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSpinBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractSpinBox.paintEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::paintEvent(QPaintEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // paintEvent(QPaintEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractSpinBoxFunc_paintEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPaintEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // paintEvent(QPaintEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractSpinBox::paintEvent(cppArg0)
                : cppSelf->paintEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractSpinBoxFunc_paintEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractSpinBoxFunc_resizeEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSpinBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractSpinBox.resizeEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::resizeEvent(QResizeEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QRESIZEEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // resizeEvent(QResizeEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractSpinBoxFunc_resizeEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QResizeEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // resizeEvent(QResizeEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractSpinBox::resizeEvent(cppArg0)
                : cppSelf->resizeEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractSpinBoxFunc_resizeEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractSpinBoxFunc_selectAll(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSpinBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractSpinBox.selectAll";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // selectAll()
            cppSelf->selectAll();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QAbstractSpinBoxFunc_setAccelerated(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSpinBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractSpinBox.setAccelerated";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractSpinBox::setAccelerated(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setAccelerated(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractSpinBoxFunc_setAccelerated_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAccelerated(bool)
            cppSelf->setAccelerated(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractSpinBoxFunc_setAccelerated_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractSpinBoxFunc_setAlignment(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSpinBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractSpinBox.setAlignment";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractSpinBox::setAlignment(QFlags<Qt::AlignmentFlag>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ALIGNMENTFLAG_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setAlignment(QFlags<Qt::AlignmentFlag>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractSpinBoxFunc_setAlignment_TypeError;

    // Call function/method
    {
        ::QFlags<Qt::AlignmentFlag> cppArg0 = QFlags<Qt::AlignmentFlag>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAlignment(QFlags<Qt::AlignmentFlag>)
            cppSelf->setAlignment(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractSpinBoxFunc_setAlignment_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractSpinBoxFunc_setButtonSymbols(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSpinBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractSpinBox.setButtonSymbols";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractSpinBox::setButtonSymbols(QAbstractSpinBox::ButtonSymbols)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_BUTTONSYMBOLS_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setButtonSymbols(QAbstractSpinBox::ButtonSymbols)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractSpinBoxFunc_setButtonSymbols_TypeError;

    // Call function/method
    {
        ::QAbstractSpinBox::ButtonSymbols cppArg0{QAbstractSpinBox::UpDownArrows};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setButtonSymbols(QAbstractSpinBox::ButtonSymbols)
            cppSelf->setButtonSymbols(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractSpinBoxFunc_setButtonSymbols_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractSpinBoxFunc_setCorrectionMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSpinBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractSpinBox.setCorrectionMode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractSpinBox::setCorrectionMode(QAbstractSpinBox::CorrectionMode)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_CORRECTIONMODE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setCorrectionMode(QAbstractSpinBox::CorrectionMode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractSpinBoxFunc_setCorrectionMode_TypeError;

    // Call function/method
    {
        ::QAbstractSpinBox::CorrectionMode cppArg0{QAbstractSpinBox::CorrectToPreviousValue};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setCorrectionMode(QAbstractSpinBox::CorrectionMode)
            cppSelf->setCorrectionMode(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractSpinBoxFunc_setCorrectionMode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractSpinBoxFunc_setFrame(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSpinBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractSpinBox.setFrame";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractSpinBox::setFrame(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setFrame(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractSpinBoxFunc_setFrame_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFrame(bool)
            cppSelf->setFrame(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractSpinBoxFunc_setFrame_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractSpinBoxFunc_setGroupSeparatorShown(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSpinBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractSpinBox.setGroupSeparatorShown";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractSpinBox::setGroupSeparatorShown(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setGroupSeparatorShown(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractSpinBoxFunc_setGroupSeparatorShown_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setGroupSeparatorShown(bool)
            cppSelf->setGroupSeparatorShown(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractSpinBoxFunc_setGroupSeparatorShown_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractSpinBoxFunc_setKeyboardTracking(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSpinBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractSpinBox.setKeyboardTracking";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractSpinBox::setKeyboardTracking(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setKeyboardTracking(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractSpinBoxFunc_setKeyboardTracking_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setKeyboardTracking(bool)
            cppSelf->setKeyboardTracking(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractSpinBoxFunc_setKeyboardTracking_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractSpinBoxFunc_setLineEdit(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSpinBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractSpinBox.setLineEdit";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractSpinBox::setLineEdit(QLineEdit*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QLINEEDIT_IDX]), (pyArg)))) {
        overloadId = 0; // setLineEdit(QLineEdit*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractSpinBoxFunc_setLineEdit_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QLineEdit *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setLineEdit(QLineEdit*)
            cppSelf->setLineEdit(cppArg0);
            Shiboken::Object::setParent(self, pyArg);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractSpinBoxFunc_setLineEdit_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractSpinBoxFunc_setReadOnly(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSpinBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractSpinBox.setReadOnly";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractSpinBox::setReadOnly(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setReadOnly(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractSpinBoxFunc_setReadOnly_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setReadOnly(bool)
            cppSelf->setReadOnly(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractSpinBoxFunc_setReadOnly_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractSpinBoxFunc_setSpecialValueText(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSpinBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractSpinBox.setSpecialValueText";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractSpinBox::setSpecialValueText(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setSpecialValueText(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractSpinBoxFunc_setSpecialValueText_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSpecialValueText(QString)
            cppSelf->setSpecialValueText(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractSpinBoxFunc_setSpecialValueText_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractSpinBoxFunc_setWrapping(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSpinBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractSpinBox.setWrapping";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractSpinBox::setWrapping(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setWrapping(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractSpinBoxFunc_setWrapping_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setWrapping(bool)
            cppSelf->setWrapping(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractSpinBoxFunc_setWrapping_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractSpinBoxFunc_showEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSpinBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractSpinBox.showEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::showEvent(QShowEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSHOWEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // showEvent(QShowEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractSpinBoxFunc_showEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QShowEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // showEvent(QShowEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractSpinBox::showEvent(cppArg0)
                : cppSelf->showEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractSpinBoxFunc_showEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractSpinBoxFunc_sizeHint(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSpinBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractSpinBox.sizeHint";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // sizeHint()const
            QSize cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QAbstractSpinBox *>(cppSelf)->::QAbstractSpinBox::sizeHint()
                : const_cast<const ::QAbstractSpinBox *>(cppSelf)->sizeHint();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractSpinBoxFunc_specialValueText(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSpinBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractSpinBox.specialValueText";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // specialValueText()const
            QString cppResult = const_cast<const ::QAbstractSpinBox *>(cppSelf)->specialValueText();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractSpinBoxFunc_stepBy(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSpinBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractSpinBox.stepBy";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractSpinBox::stepBy(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // stepBy(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractSpinBoxFunc_stepBy_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // stepBy(int)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractSpinBox::stepBy(cppArg0)
                : cppSelf->stepBy(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractSpinBoxFunc_stepBy_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractSpinBoxFunc_stepDown(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSpinBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractSpinBox.stepDown";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // stepDown()
            cppSelf->stepDown();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QAbstractSpinBoxFunc_stepEnabled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSpinBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractSpinBox.stepEnabled";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // stepEnabled()const
            QFlags<QAbstractSpinBox::StepEnabledFlag> cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QAbstractSpinBox *>(cppSelf)->::QAbstractSpinBox::stepEnabled()
                : const_cast<const ::QAbstractSpinBox *>(cppSelf)->stepEnabled();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QABSTRACTSPINBOX_STEPENABLEDFLAG_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractSpinBoxFunc_stepUp(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSpinBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractSpinBox.stepUp";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // stepUp()
            cppSelf->stepUp();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QAbstractSpinBoxFunc_text(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSpinBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractSpinBox.text";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // text()const
            QString cppResult = const_cast<const ::QAbstractSpinBox *>(cppSelf)->text();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractSpinBoxFunc_timerEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSpinBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractSpinBox.timerEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QObject::timerEvent(QTimerEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), (pyArg)))) {
        overloadId = 0; // timerEvent(QTimerEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractSpinBoxFunc_timerEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTimerEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // timerEvent(QTimerEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractSpinBox::timerEvent(cppArg0)
                : cppSelf->timerEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractSpinBoxFunc_timerEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractSpinBoxFunc_validate(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSpinBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractSpinBox.validate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "validate", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QAbstractSpinBox::validate(QString&,int&)const
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // validate(QString&,int&)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractSpinBoxFunc_validate_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // validate(QString&,int&)const
            // Begin code injection
            // TEMPLATE - return_tuple_QValidator_QString_int - START
            ::QValidator::State retval_ = ::QValidator::State((Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self)) ? cppSelf->::QAbstractSpinBox::validate(cppArg0, cppArg1) : cppSelf->validate(cppArg0, cppArg1)));
            pyResult = PyTuple_New(3);
            PyTuple_SET_ITEM(pyResult, 0, Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QVALIDATOR_STATE_IDX])->converter, &retval_));
            PyTuple_SET_ITEM(pyResult, 1, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppArg0));
            PyTuple_SET_ITEM(pyResult, 2, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppArg1));
            // TEMPLATE - return_tuple_QValidator_QString_int - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractSpinBoxFunc_validate_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractSpinBoxFunc_wheelEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSpinBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractSpinBox.wheelEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::wheelEvent(QWheelEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QWHEELEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // wheelEvent(QWheelEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractSpinBoxFunc_wheelEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWheelEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // wheelEvent(QWheelEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAbstractSpinBox::wheelEvent(cppArg0)
                : cppSelf->wheelEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractSpinBoxFunc_wheelEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractSpinBoxFunc_wrapping(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractSpinBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAbstractSpinBox.wrapping";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // wrapping()const
            bool cppResult = const_cast<const ::QAbstractSpinBox *>(cppSelf)->wrapping();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QAbstractSpinBox_PropertyStrings[] = {
    "accelerated:isAccelerated:",
    "acceptableInput:hasAcceptableInput",
    "alignment::",
    "buttonSymbols::",
    "correctionMode::",
    "frame:hasFrame:",
    "keyboardTracking::",
    "readOnly:isReadOnly:",
    "showGroupSeparator:isGroupSeparatorShown:setGroupSeparatorShown",
    "specialValueText::",
    "text:",
    "wrapping::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QAbstractSpinBox_methods[] = {
    {"alignment", reinterpret_cast<PyCFunction>(Sbk_QAbstractSpinBoxFunc_alignment), METH_NOARGS},
    {"buttonSymbols", reinterpret_cast<PyCFunction>(Sbk_QAbstractSpinBoxFunc_buttonSymbols), METH_NOARGS},
    {"changeEvent", reinterpret_cast<PyCFunction>(Sbk_QAbstractSpinBoxFunc_changeEvent), METH_O},
    {"clear", reinterpret_cast<PyCFunction>(Sbk_QAbstractSpinBoxFunc_clear), METH_NOARGS},
    {"closeEvent", reinterpret_cast<PyCFunction>(Sbk_QAbstractSpinBoxFunc_closeEvent), METH_O},
    {"contextMenuEvent", reinterpret_cast<PyCFunction>(Sbk_QAbstractSpinBoxFunc_contextMenuEvent), METH_O},
    {"correctionMode", reinterpret_cast<PyCFunction>(Sbk_QAbstractSpinBoxFunc_correctionMode), METH_NOARGS},
    {"event", reinterpret_cast<PyCFunction>(Sbk_QAbstractSpinBoxFunc_event), METH_O},
    {"fixup", reinterpret_cast<PyCFunction>(Sbk_QAbstractSpinBoxFunc_fixup), METH_O},
    {"focusInEvent", reinterpret_cast<PyCFunction>(Sbk_QAbstractSpinBoxFunc_focusInEvent), METH_O},
    {"focusOutEvent", reinterpret_cast<PyCFunction>(Sbk_QAbstractSpinBoxFunc_focusOutEvent), METH_O},
    {"hasAcceptableInput", reinterpret_cast<PyCFunction>(Sbk_QAbstractSpinBoxFunc_hasAcceptableInput), METH_NOARGS},
    {"hasFrame", reinterpret_cast<PyCFunction>(Sbk_QAbstractSpinBoxFunc_hasFrame), METH_NOARGS},
    {"hideEvent", reinterpret_cast<PyCFunction>(Sbk_QAbstractSpinBoxFunc_hideEvent), METH_O},
    {"initStyleOption", reinterpret_cast<PyCFunction>(Sbk_QAbstractSpinBoxFunc_initStyleOption), METH_O},
    {"inputMethodQuery", reinterpret_cast<PyCFunction>(Sbk_QAbstractSpinBoxFunc_inputMethodQuery), METH_O},
    {"interpretText", reinterpret_cast<PyCFunction>(Sbk_QAbstractSpinBoxFunc_interpretText), METH_NOARGS},
    {"isAccelerated", reinterpret_cast<PyCFunction>(Sbk_QAbstractSpinBoxFunc_isAccelerated), METH_NOARGS},
    {"isGroupSeparatorShown", reinterpret_cast<PyCFunction>(Sbk_QAbstractSpinBoxFunc_isGroupSeparatorShown), METH_NOARGS},
    {"isReadOnly", reinterpret_cast<PyCFunction>(Sbk_QAbstractSpinBoxFunc_isReadOnly), METH_NOARGS},
    {"keyPressEvent", reinterpret_cast<PyCFunction>(Sbk_QAbstractSpinBoxFunc_keyPressEvent), METH_O},
    {"keyReleaseEvent", reinterpret_cast<PyCFunction>(Sbk_QAbstractSpinBoxFunc_keyReleaseEvent), METH_O},
    {"keyboardTracking", reinterpret_cast<PyCFunction>(Sbk_QAbstractSpinBoxFunc_keyboardTracking), METH_NOARGS},
    {"lineEdit", reinterpret_cast<PyCFunction>(Sbk_QAbstractSpinBoxFunc_lineEdit), METH_NOARGS},
    {"minimumSizeHint", reinterpret_cast<PyCFunction>(Sbk_QAbstractSpinBoxFunc_minimumSizeHint), METH_NOARGS},
    {"mouseMoveEvent", reinterpret_cast<PyCFunction>(Sbk_QAbstractSpinBoxFunc_mouseMoveEvent), METH_O},
    {"mousePressEvent", reinterpret_cast<PyCFunction>(Sbk_QAbstractSpinBoxFunc_mousePressEvent), METH_O},
    {"mouseReleaseEvent", reinterpret_cast<PyCFunction>(Sbk_QAbstractSpinBoxFunc_mouseReleaseEvent), METH_O},
    {"paintEvent", reinterpret_cast<PyCFunction>(Sbk_QAbstractSpinBoxFunc_paintEvent), METH_O},
    {"resizeEvent", reinterpret_cast<PyCFunction>(Sbk_QAbstractSpinBoxFunc_resizeEvent), METH_O},
    {"selectAll", reinterpret_cast<PyCFunction>(Sbk_QAbstractSpinBoxFunc_selectAll), METH_NOARGS},
    {"setAccelerated", reinterpret_cast<PyCFunction>(Sbk_QAbstractSpinBoxFunc_setAccelerated), METH_O},
    {"setAlignment", reinterpret_cast<PyCFunction>(Sbk_QAbstractSpinBoxFunc_setAlignment), METH_O},
    {"setButtonSymbols", reinterpret_cast<PyCFunction>(Sbk_QAbstractSpinBoxFunc_setButtonSymbols), METH_O},
    {"setCorrectionMode", reinterpret_cast<PyCFunction>(Sbk_QAbstractSpinBoxFunc_setCorrectionMode), METH_O},
    {"setFrame", reinterpret_cast<PyCFunction>(Sbk_QAbstractSpinBoxFunc_setFrame), METH_O},
    {"setGroupSeparatorShown", reinterpret_cast<PyCFunction>(Sbk_QAbstractSpinBoxFunc_setGroupSeparatorShown), METH_O},
    {"setKeyboardTracking", reinterpret_cast<PyCFunction>(Sbk_QAbstractSpinBoxFunc_setKeyboardTracking), METH_O},
    {"setLineEdit", reinterpret_cast<PyCFunction>(Sbk_QAbstractSpinBoxFunc_setLineEdit), METH_O},
    {"setReadOnly", reinterpret_cast<PyCFunction>(Sbk_QAbstractSpinBoxFunc_setReadOnly), METH_O},
    {"setSpecialValueText", reinterpret_cast<PyCFunction>(Sbk_QAbstractSpinBoxFunc_setSpecialValueText), METH_O},
    {"setWrapping", reinterpret_cast<PyCFunction>(Sbk_QAbstractSpinBoxFunc_setWrapping), METH_O},
    {"showEvent", reinterpret_cast<PyCFunction>(Sbk_QAbstractSpinBoxFunc_showEvent), METH_O},
    {"sizeHint", reinterpret_cast<PyCFunction>(Sbk_QAbstractSpinBoxFunc_sizeHint), METH_NOARGS},
    {"specialValueText", reinterpret_cast<PyCFunction>(Sbk_QAbstractSpinBoxFunc_specialValueText), METH_NOARGS},
    {"stepBy", reinterpret_cast<PyCFunction>(Sbk_QAbstractSpinBoxFunc_stepBy), METH_O},
    {"stepDown", reinterpret_cast<PyCFunction>(Sbk_QAbstractSpinBoxFunc_stepDown), METH_NOARGS},
    {"stepEnabled", reinterpret_cast<PyCFunction>(Sbk_QAbstractSpinBoxFunc_stepEnabled), METH_NOARGS},
    {"stepUp", reinterpret_cast<PyCFunction>(Sbk_QAbstractSpinBoxFunc_stepUp), METH_NOARGS},
    {"text", reinterpret_cast<PyCFunction>(Sbk_QAbstractSpinBoxFunc_text), METH_NOARGS},
    {"timerEvent", reinterpret_cast<PyCFunction>(Sbk_QAbstractSpinBoxFunc_timerEvent), METH_O},
    {"validate", reinterpret_cast<PyCFunction>(Sbk_QAbstractSpinBoxFunc_validate), METH_VARARGS},
    {"wheelEvent", reinterpret_cast<PyCFunction>(Sbk_QAbstractSpinBoxFunc_wheelEvent), METH_O},
    {"wrapping", reinterpret_cast<PyCFunction>(Sbk_QAbstractSpinBoxFunc_wrapping), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QAbstractSpinBox_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QAbstractSpinBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QAbstractSpinBoxWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QAbstractSpinBox_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QAbstractSpinBox_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
static void * Sbk_QAbstractSpinBoxSpecialCastFunction(void *obj, SbkObjectType *desiredType)
{
    auto me = reinterpret_cast< ::QAbstractSpinBox *>(obj);
    if (desiredType == reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTDEVICE_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    return me;
}


// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QAbstractSpinBox_Type = nullptr;
static SbkObjectType *Sbk_QAbstractSpinBox_TypeF(void)
{
    return _Sbk_QAbstractSpinBox_Type;
}

static PyType_Slot Sbk_QAbstractSpinBox_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QAbstractSpinBox_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QAbstractSpinBox_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QAbstractSpinBox_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QAbstractSpinBox_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QAbstractSpinBox_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QAbstractSpinBox_spec = {
    "2:PySide2.QtWidgets.QAbstractSpinBox",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QAbstractSpinBox_slots
};

} //extern "C"

static void *Sbk_QAbstractSpinBox_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QAbstractSpinBox *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QPaintDevice >()))
        return dynamic_cast< ::QAbstractSpinBox *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}

PyObject *SbkPySide2_QtWidgets_QAbstractSpinBox_StepEnabledFlag___and__(PyObject *self, PyObject *pyArg)
{
    ::QAbstractSpinBox::StepEnabled cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QAbstractSpinBox::StepEnabled>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QAbstractSpinBox::StepEnabled>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QAbstractSpinBox::StepEnabled>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QAbstractSpinBox::StepEnabled>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QABSTRACTSPINBOX_STEPENABLEDFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtWidgets_QAbstractSpinBox_StepEnabledFlag___or__(PyObject *self, PyObject *pyArg)
{
    ::QAbstractSpinBox::StepEnabled cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QAbstractSpinBox::StepEnabled>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QAbstractSpinBox::StepEnabled>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QAbstractSpinBox::StepEnabled>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QAbstractSpinBox::StepEnabled>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QABSTRACTSPINBOX_STEPENABLEDFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtWidgets_QAbstractSpinBox_StepEnabledFlag___xor__(PyObject *self, PyObject *pyArg)
{
    ::QAbstractSpinBox::StepEnabled cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QAbstractSpinBox::StepEnabled>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QAbstractSpinBox::StepEnabled>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QAbstractSpinBox::StepEnabled>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QAbstractSpinBox::StepEnabled>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QABSTRACTSPINBOX_STEPENABLEDFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtWidgets_QAbstractSpinBox_StepEnabledFlag___invert__(PyObject *self, PyObject *pyArg)
{
    ::QAbstractSpinBox::StepEnabled cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QABSTRACTSPINBOX_STEPENABLEDFLAG_IDX])->converter, self, &cppSelf);
    ::QAbstractSpinBox::StepEnabled cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QABSTRACTSPINBOX_STEPENABLEDFLAG_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtWidgets_QAbstractSpinBox_StepEnabledFlag_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QABSTRACTSPINBOX_STEPENABLEDFLAG_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtWidgets_QAbstractSpinBox_StepEnabledFlag__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QABSTRACTSPINBOX_STEPENABLEDFLAG_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtWidgets_QAbstractSpinBox_StepEnabledFlag_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtWidgets_QAbstractSpinBox_StepEnabledFlag__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtWidgets_QAbstractSpinBox_StepEnabledFlag__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtWidgets_QAbstractSpinBox_StepEnabledFlag_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtWidgets_QAbstractSpinBox_StepEnabledFlag___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtWidgets_QAbstractSpinBox_StepEnabledFlag___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtWidgets_QAbstractSpinBox_StepEnabledFlag___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtWidgets_QAbstractSpinBox_StepEnabledFlag___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtWidgets_QAbstractSpinBox_StepEnabledFlag_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtWidgets_QAbstractSpinBox_StepEnabledFlag_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtWidgets_QAbstractSpinBox_StepEnabledFlag_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QAbstractSpinBox_StepEnabledFlag_PythonToCpp_QAbstractSpinBox_StepEnabledFlag(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QAbstractSpinBox::StepEnabledFlag *>(cppOut) =
        static_cast<::QAbstractSpinBox::StepEnabledFlag>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QAbstractSpinBox_StepEnabledFlag_PythonToCpp_QAbstractSpinBox_StepEnabledFlag_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_STEPENABLEDFLAG_IDX]))
        return QAbstractSpinBox_StepEnabledFlag_PythonToCpp_QAbstractSpinBox_StepEnabledFlag;
    return {};
}
static PyObject *QAbstractSpinBox_StepEnabledFlag_CppToPython_QAbstractSpinBox_StepEnabledFlag(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QAbstractSpinBox::StepEnabledFlag *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_STEPENABLEDFLAG_IDX], castCppIn);

}

static void QFlags_QAbstractSpinBox_StepEnabledFlag__PythonToCpp_QFlags_QAbstractSpinBox_StepEnabledFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QAbstractSpinBox::StepEnabledFlag> *>(cppOut) =
        ::QFlags<QAbstractSpinBox::StepEnabledFlag>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QAbstractSpinBox_StepEnabledFlag__PythonToCpp_QFlags_QAbstractSpinBox_StepEnabledFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QABSTRACTSPINBOX_STEPENABLEDFLAG_IDX]))
        return QFlags_QAbstractSpinBox_StepEnabledFlag__PythonToCpp_QFlags_QAbstractSpinBox_StepEnabledFlag_;
    return {};
}
static PyObject *QFlags_QAbstractSpinBox_StepEnabledFlag__CppToPython_QFlags_QAbstractSpinBox_StepEnabledFlag_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QAbstractSpinBox::StepEnabledFlag> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QABSTRACTSPINBOX_STEPENABLEDFLAG_IDX]));

}

static void QAbstractSpinBox_StepEnabledFlag_PythonToCpp_QFlags_QAbstractSpinBox_StepEnabledFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QAbstractSpinBox::StepEnabledFlag> *>(cppOut) =
        ::QFlags<QAbstractSpinBox::StepEnabledFlag>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QAbstractSpinBox_StepEnabledFlag_PythonToCpp_QFlags_QAbstractSpinBox_StepEnabledFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_STEPENABLEDFLAG_IDX]))
        return QAbstractSpinBox_StepEnabledFlag_PythonToCpp_QFlags_QAbstractSpinBox_StepEnabledFlag_;
    return {};
}
static void number_PythonToCpp_QFlags_QAbstractSpinBox_StepEnabledFlag_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QAbstractSpinBox::StepEnabledFlag> *>(cppOut) =
        ::QFlags<QAbstractSpinBox::StepEnabledFlag>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QAbstractSpinBox_StepEnabledFlag__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_STEPENABLEDFLAG_IDX]))
        return number_PythonToCpp_QFlags_QAbstractSpinBox_StepEnabledFlag_;
    return {};
}
static void QAbstractSpinBox_ButtonSymbols_PythonToCpp_QAbstractSpinBox_ButtonSymbols(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QAbstractSpinBox::ButtonSymbols *>(cppOut) =
        static_cast<::QAbstractSpinBox::ButtonSymbols>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QAbstractSpinBox_ButtonSymbols_PythonToCpp_QAbstractSpinBox_ButtonSymbols_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_BUTTONSYMBOLS_IDX]))
        return QAbstractSpinBox_ButtonSymbols_PythonToCpp_QAbstractSpinBox_ButtonSymbols;
    return {};
}
static PyObject *QAbstractSpinBox_ButtonSymbols_CppToPython_QAbstractSpinBox_ButtonSymbols(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QAbstractSpinBox::ButtonSymbols *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_BUTTONSYMBOLS_IDX], castCppIn);

}

static void QAbstractSpinBox_CorrectionMode_PythonToCpp_QAbstractSpinBox_CorrectionMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QAbstractSpinBox::CorrectionMode *>(cppOut) =
        static_cast<::QAbstractSpinBox::CorrectionMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QAbstractSpinBox_CorrectionMode_PythonToCpp_QAbstractSpinBox_CorrectionMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_CORRECTIONMODE_IDX]))
        return QAbstractSpinBox_CorrectionMode_PythonToCpp_QAbstractSpinBox_CorrectionMode;
    return {};
}
static PyObject *QAbstractSpinBox_CorrectionMode_CppToPython_QAbstractSpinBox_CorrectionMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QAbstractSpinBox::CorrectionMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_CORRECTIONMODE_IDX], castCppIn);

}

static void QAbstractSpinBox_StepType_PythonToCpp_QAbstractSpinBox_StepType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QAbstractSpinBox::StepType *>(cppOut) =
        static_cast<::QAbstractSpinBox::StepType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QAbstractSpinBox_StepType_PythonToCpp_QAbstractSpinBox_StepType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_STEPTYPE_IDX]))
        return QAbstractSpinBox_StepType_PythonToCpp_QAbstractSpinBox_StepType;
    return {};
}
static PyObject *QAbstractSpinBox_StepType_CppToPython_QAbstractSpinBox_StepType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QAbstractSpinBox::StepType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_STEPTYPE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QAbstractSpinBox_PythonToCpp_QAbstractSpinBox_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QAbstractSpinBox_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QAbstractSpinBox_PythonToCpp_QAbstractSpinBox_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QAbstractSpinBox_TypeF())))
        return QAbstractSpinBox_PythonToCpp_QAbstractSpinBox_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QAbstractSpinBox_PTR_CppToPython_QAbstractSpinBox(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QAbstractSpinBox *>(const_cast<void *>(cppIn)), Sbk_QAbstractSpinBox_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QAbstractSpinBox_SignatureStrings[] = {
    "PySide2.QtWidgets.QAbstractSpinBox(self,parent:PySide2.QtWidgets.QWidget=nullptr)",
    "PySide2.QtWidgets.QAbstractSpinBox.alignment(self)->PySide2.QtCore.Qt.Alignment",
    "PySide2.QtWidgets.QAbstractSpinBox.buttonSymbols(self)->PySide2.QtWidgets.QAbstractSpinBox.ButtonSymbols",
    "PySide2.QtWidgets.QAbstractSpinBox.changeEvent(self,event:PySide2.QtCore.QEvent)",
    "PySide2.QtWidgets.QAbstractSpinBox.clear(self)",
    "PySide2.QtWidgets.QAbstractSpinBox.closeEvent(self,event:PySide2.QtGui.QCloseEvent)",
    "PySide2.QtWidgets.QAbstractSpinBox.contextMenuEvent(self,event:PySide2.QtGui.QContextMenuEvent)",
    "PySide2.QtWidgets.QAbstractSpinBox.correctionMode(self)->PySide2.QtWidgets.QAbstractSpinBox.CorrectionMode",
    "PySide2.QtWidgets.QAbstractSpinBox.event(self,event:PySide2.QtCore.QEvent)->bool",
    "PySide2.QtWidgets.QAbstractSpinBox.fixup(self,input:QString)",
    "PySide2.QtWidgets.QAbstractSpinBox.focusInEvent(self,event:PySide2.QtGui.QFocusEvent)",
    "PySide2.QtWidgets.QAbstractSpinBox.focusOutEvent(self,event:PySide2.QtGui.QFocusEvent)",
    "PySide2.QtWidgets.QAbstractSpinBox.hasAcceptableInput(self)->bool",
    "PySide2.QtWidgets.QAbstractSpinBox.hasFrame(self)->bool",
    "PySide2.QtWidgets.QAbstractSpinBox.hideEvent(self,event:PySide2.QtGui.QHideEvent)",
    "PySide2.QtWidgets.QAbstractSpinBox.initStyleOption(self,option:PySide2.QtWidgets.QStyleOptionSpinBox)",
    "PySide2.QtWidgets.QAbstractSpinBox.inputMethodQuery(self,arg__1:PySide2.QtCore.Qt.InputMethodQuery)->QVariant",
    "PySide2.QtWidgets.QAbstractSpinBox.interpretText(self)",
    "PySide2.QtWidgets.QAbstractSpinBox.isAccelerated(self)->bool",
    "PySide2.QtWidgets.QAbstractSpinBox.isGroupSeparatorShown(self)->bool",
    "PySide2.QtWidgets.QAbstractSpinBox.isReadOnly(self)->bool",
    "PySide2.QtWidgets.QAbstractSpinBox.keyPressEvent(self,event:PySide2.QtGui.QKeyEvent)",
    "PySide2.QtWidgets.QAbstractSpinBox.keyReleaseEvent(self,event:PySide2.QtGui.QKeyEvent)",
    "PySide2.QtWidgets.QAbstractSpinBox.keyboardTracking(self)->bool",
    "PySide2.QtWidgets.QAbstractSpinBox.lineEdit(self)->PySide2.QtWidgets.QLineEdit",
    "PySide2.QtWidgets.QAbstractSpinBox.minimumSizeHint(self)->PySide2.QtCore.QSize",
    "PySide2.QtWidgets.QAbstractSpinBox.mouseMoveEvent(self,event:PySide2.QtGui.QMouseEvent)",
    "PySide2.QtWidgets.QAbstractSpinBox.mousePressEvent(self,event:PySide2.QtGui.QMouseEvent)",
    "PySide2.QtWidgets.QAbstractSpinBox.mouseReleaseEvent(self,event:PySide2.QtGui.QMouseEvent)",
    "PySide2.QtWidgets.QAbstractSpinBox.paintEvent(self,event:PySide2.QtGui.QPaintEvent)",
    "PySide2.QtWidgets.QAbstractSpinBox.resizeEvent(self,event:PySide2.QtGui.QResizeEvent)",
    "PySide2.QtWidgets.QAbstractSpinBox.selectAll(self)",
    "PySide2.QtWidgets.QAbstractSpinBox.setAccelerated(self,on:bool)",
    "PySide2.QtWidgets.QAbstractSpinBox.setAlignment(self,flag:PySide2.QtCore.Qt.Alignment)",
    "PySide2.QtWidgets.QAbstractSpinBox.setButtonSymbols(self,bs:PySide2.QtWidgets.QAbstractSpinBox.ButtonSymbols)",
    "PySide2.QtWidgets.QAbstractSpinBox.setCorrectionMode(self,cm:PySide2.QtWidgets.QAbstractSpinBox.CorrectionMode)",
    "PySide2.QtWidgets.QAbstractSpinBox.setFrame(self,arg__1:bool)",
    "PySide2.QtWidgets.QAbstractSpinBox.setGroupSeparatorShown(self,shown:bool)",
    "PySide2.QtWidgets.QAbstractSpinBox.setKeyboardTracking(self,kt:bool)",
    "PySide2.QtWidgets.QAbstractSpinBox.setLineEdit(self,edit:PySide2.QtWidgets.QLineEdit)",
    "PySide2.QtWidgets.QAbstractSpinBox.setReadOnly(self,r:bool)",
    "PySide2.QtWidgets.QAbstractSpinBox.setSpecialValueText(self,txt:QString)",
    "PySide2.QtWidgets.QAbstractSpinBox.setWrapping(self,w:bool)",
    "PySide2.QtWidgets.QAbstractSpinBox.showEvent(self,event:PySide2.QtGui.QShowEvent)",
    "PySide2.QtWidgets.QAbstractSpinBox.sizeHint(self)->PySide2.QtCore.QSize",
    "PySide2.QtWidgets.QAbstractSpinBox.specialValueText(self)->QString",
    "PySide2.QtWidgets.QAbstractSpinBox.stepBy(self,steps:int)",
    "PySide2.QtWidgets.QAbstractSpinBox.stepDown(self)",
    "PySide2.QtWidgets.QAbstractSpinBox.stepEnabled(self)->PySide2.QtWidgets.QAbstractSpinBox.StepEnabled",
    "PySide2.QtWidgets.QAbstractSpinBox.stepUp(self)",
    "PySide2.QtWidgets.QAbstractSpinBox.text(self)->QString",
    "PySide2.QtWidgets.QAbstractSpinBox.timerEvent(self,event:PySide2.QtCore.QTimerEvent)",
    "PySide2.QtWidgets.QAbstractSpinBox.validate(self,input:QString,pos:int)->PySide2.QtGui.QValidator.State",
    "PySide2.QtWidgets.QAbstractSpinBox.wheelEvent(self,event:PySide2.QtGui.QWheelEvent)",
    "PySide2.QtWidgets.QAbstractSpinBox.wrapping(self)->bool",
    nullptr}; // Sentinel

void init_QAbstractSpinBox(PyObject *module)
{
    _Sbk_QAbstractSpinBox_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QAbstractSpinBox",
        "QAbstractSpinBox*",
        &Sbk_QAbstractSpinBox_spec,
        &Shiboken::callCppDestructor< ::QAbstractSpinBox >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]),
        0,
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QAbstractSpinBox_Type);
    InitSignatureStrings(pyType, QAbstractSpinBox_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QAbstractSpinBox_Type), Sbk_QAbstractSpinBox_PropertyStrings);
    SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QAbstractSpinBox_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QAbstractSpinBox_TypeF(),
        QAbstractSpinBox_PythonToCpp_QAbstractSpinBox_PTR,
        is_QAbstractSpinBox_PythonToCpp_QAbstractSpinBox_PTR_Convertible,
        QAbstractSpinBox_PTR_CppToPython_QAbstractSpinBox);

    Shiboken::Conversions::registerConverterName(converter, "QAbstractSpinBox");
    Shiboken::Conversions::registerConverterName(converter, "QAbstractSpinBox*");
    Shiboken::Conversions::registerConverterName(converter, "QAbstractSpinBox&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QAbstractSpinBox).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QAbstractSpinBoxWrapper).name());


    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_QAbstractSpinBox_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_QAbstractSpinBox_TypeF(), &Sbk_QAbstractSpinBoxSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QAbstractSpinBox_TypeF(), &Sbk_QAbstractSpinBox_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'StepEnabledFlag'.
    SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QABSTRACTSPINBOX_STEPENABLEDFLAG_IDX] = PySide::QFlags::create("2:PySide2.QtWidgets.QAbstractSpinBox.StepEnabled", SbkPySide2_QtWidgets_QAbstractSpinBox_StepEnabledFlag_number_slots);
    SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_STEPENABLEDFLAG_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QAbstractSpinBox_TypeF(),
        "StepEnabledFlag",
        "2:PySide2.QtWidgets.QAbstractSpinBox.StepEnabledFlag",
        "QAbstractSpinBox::StepEnabledFlag",
        SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QABSTRACTSPINBOX_STEPENABLEDFLAG_IDX]);
    if (!SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_STEPENABLEDFLAG_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_STEPENABLEDFLAG_IDX],
        Sbk_QAbstractSpinBox_TypeF(), "StepNone", (long) QAbstractSpinBox::StepEnabledFlag::StepNone))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_STEPENABLEDFLAG_IDX],
        Sbk_QAbstractSpinBox_TypeF(), "StepUpEnabled", (long) QAbstractSpinBox::StepEnabledFlag::StepUpEnabled))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_STEPENABLEDFLAG_IDX],
        Sbk_QAbstractSpinBox_TypeF(), "StepDownEnabled", (long) QAbstractSpinBox::StepEnabledFlag::StepDownEnabled))
        return;
    // Register converter for enum 'QAbstractSpinBox::StepEnabledFlag'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_STEPENABLEDFLAG_IDX],
            QAbstractSpinBox_StepEnabledFlag_CppToPython_QAbstractSpinBox_StepEnabledFlag);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QAbstractSpinBox_StepEnabledFlag_PythonToCpp_QAbstractSpinBox_StepEnabledFlag,
            is_QAbstractSpinBox_StepEnabledFlag_PythonToCpp_QAbstractSpinBox_StepEnabledFlag_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_STEPENABLEDFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QAbstractSpinBox::StepEnabledFlag");
        Shiboken::Conversions::registerConverterName(converter, "StepEnabledFlag");
    }
    // Register converter for flag 'QFlags<QAbstractSpinBox::StepEnabledFlag>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QABSTRACTSPINBOX_STEPENABLEDFLAG_IDX],
            QFlags_QAbstractSpinBox_StepEnabledFlag__CppToPython_QFlags_QAbstractSpinBox_StepEnabledFlag_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QAbstractSpinBox_StepEnabledFlag_PythonToCpp_QFlags_QAbstractSpinBox_StepEnabledFlag_,
            is_QAbstractSpinBox_StepEnabledFlag_PythonToCpp_QFlags_QAbstractSpinBox_StepEnabledFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QAbstractSpinBox_StepEnabledFlag__PythonToCpp_QFlags_QAbstractSpinBox_StepEnabledFlag_,
            is_QFlags_QAbstractSpinBox_StepEnabledFlag__PythonToCpp_QFlags_QAbstractSpinBox_StepEnabledFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QAbstractSpinBox_StepEnabledFlag_,
            is_number_PythonToCpp_QFlags_QAbstractSpinBox_StepEnabledFlag__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QABSTRACTSPINBOX_STEPENABLEDFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QAbstractSpinBox::StepEnabled");
        Shiboken::Conversions::registerConverterName(converter, "StepEnabled");
    }
    // End of 'StepEnabledFlag' enum/flags.

    // Initialization of enum 'ButtonSymbols'.
    SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_BUTTONSYMBOLS_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QAbstractSpinBox_TypeF(),
        "ButtonSymbols",
        "2:PySide2.QtWidgets.QAbstractSpinBox.ButtonSymbols",
        "QAbstractSpinBox::ButtonSymbols");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_BUTTONSYMBOLS_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_BUTTONSYMBOLS_IDX],
        Sbk_QAbstractSpinBox_TypeF(), "UpDownArrows", (long) QAbstractSpinBox::ButtonSymbols::UpDownArrows))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_BUTTONSYMBOLS_IDX],
        Sbk_QAbstractSpinBox_TypeF(), "PlusMinus", (long) QAbstractSpinBox::ButtonSymbols::PlusMinus))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_BUTTONSYMBOLS_IDX],
        Sbk_QAbstractSpinBox_TypeF(), "NoButtons", (long) QAbstractSpinBox::ButtonSymbols::NoButtons))
        return;
    // Register converter for enum 'QAbstractSpinBox::ButtonSymbols'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_BUTTONSYMBOLS_IDX],
            QAbstractSpinBox_ButtonSymbols_CppToPython_QAbstractSpinBox_ButtonSymbols);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QAbstractSpinBox_ButtonSymbols_PythonToCpp_QAbstractSpinBox_ButtonSymbols,
            is_QAbstractSpinBox_ButtonSymbols_PythonToCpp_QAbstractSpinBox_ButtonSymbols_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_BUTTONSYMBOLS_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QAbstractSpinBox::ButtonSymbols");
        Shiboken::Conversions::registerConverterName(converter, "ButtonSymbols");
    }
    // End of 'ButtonSymbols' enum.

    // Initialization of enum 'CorrectionMode'.
    SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_CORRECTIONMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QAbstractSpinBox_TypeF(),
        "CorrectionMode",
        "2:PySide2.QtWidgets.QAbstractSpinBox.CorrectionMode",
        "QAbstractSpinBox::CorrectionMode");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_CORRECTIONMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_CORRECTIONMODE_IDX],
        Sbk_QAbstractSpinBox_TypeF(), "CorrectToPreviousValue", (long) QAbstractSpinBox::CorrectionMode::CorrectToPreviousValue))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_CORRECTIONMODE_IDX],
        Sbk_QAbstractSpinBox_TypeF(), "CorrectToNearestValue", (long) QAbstractSpinBox::CorrectionMode::CorrectToNearestValue))
        return;
    // Register converter for enum 'QAbstractSpinBox::CorrectionMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_CORRECTIONMODE_IDX],
            QAbstractSpinBox_CorrectionMode_CppToPython_QAbstractSpinBox_CorrectionMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QAbstractSpinBox_CorrectionMode_PythonToCpp_QAbstractSpinBox_CorrectionMode,
            is_QAbstractSpinBox_CorrectionMode_PythonToCpp_QAbstractSpinBox_CorrectionMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_CORRECTIONMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QAbstractSpinBox::CorrectionMode");
        Shiboken::Conversions::registerConverterName(converter, "CorrectionMode");
    }
    // End of 'CorrectionMode' enum.

    // Initialization of enum 'StepType'.
    SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_STEPTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QAbstractSpinBox_TypeF(),
        "StepType",
        "2:PySide2.QtWidgets.QAbstractSpinBox.StepType",
        "QAbstractSpinBox::StepType");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_STEPTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_STEPTYPE_IDX],
        Sbk_QAbstractSpinBox_TypeF(), "DefaultStepType", (long) QAbstractSpinBox::StepType::DefaultStepType))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_STEPTYPE_IDX],
        Sbk_QAbstractSpinBox_TypeF(), "AdaptiveDecimalStepType", (long) QAbstractSpinBox::StepType::AdaptiveDecimalStepType))
        return;
    // Register converter for enum 'QAbstractSpinBox::StepType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_STEPTYPE_IDX],
            QAbstractSpinBox_StepType_CppToPython_QAbstractSpinBox_StepType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QAbstractSpinBox_StepType_PythonToCpp_QAbstractSpinBox_StepType,
            is_QAbstractSpinBox_StepType_PythonToCpp_QAbstractSpinBox_StepType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_STEPTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QAbstractSpinBox::StepType");
        Shiboken::Conversions::registerConverterName(converter, "StepType");
    }
    // End of 'StepType' enum.

    PySide::Signal::registerSignals(Sbk_QAbstractSpinBox_TypeF(), &::QAbstractSpinBox::staticMetaObject);
    qRegisterMetaType< ::QAbstractSpinBox::StepEnabledFlag >("QAbstractSpinBox::StepEnabledFlag");
    qRegisterMetaType< ::QAbstractSpinBox::StepEnabled >("QAbstractSpinBox::StepEnabled");
    qRegisterMetaType< ::QAbstractSpinBox::ButtonSymbols >("QAbstractSpinBox::ButtonSymbols");
    qRegisterMetaType< ::QAbstractSpinBox::CorrectionMode >("QAbstractSpinBox::CorrectionMode");
    qRegisterMetaType< ::QAbstractSpinBox::StepType >("QAbstractSpinBox::StepType");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QAbstractSpinBox_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QAbstractSpinBox_TypeF(), &::QAbstractSpinBox::staticMetaObject, sizeof(QAbstractSpinBoxWrapper));
}
