/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtwidgets_python.h"

// main header
#include "qaction_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QActionWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QActionWrapper::QActionWrapper(::QObject * parent) : QAction(parent)
{
    resetPyMethodCache();
    // ... middle
}

QActionWrapper::QActionWrapper(const ::QIcon & icon, const ::QString & text, ::QObject * parent) : QAction(icon, text, parent)
{
    resetPyMethodCache();
    // ... middle
}

QActionWrapper::QActionWrapper(const ::QString & text, ::QObject * parent) : QAction(text, parent)
{
    resetPyMethodCache();
    // ... middle
}

void QActionWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QActionWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QActionWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QActionWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QActionWrapper::event(::QEvent * arg__1)
{
    if (m_PyMethodCache[4])
        return this->::QAction::event(arg__1);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QAction::event(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), arg__1)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAction.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QActionWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAction.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QActionWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QActionWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QAction::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QActionWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QAction::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QActionWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QActionWrapper *>(this));
        return QAction::qt_metacast(_clname);
}

QActionWrapper::~QActionWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QAction_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QAction >()))
        return -1;

    ::QActionWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAction.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|OOO:QAction", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return -1;


    // Overloaded function decisor
    // 0: QAction::QAction(QObject*)
    // 1: QAction::QAction(QIcon,QString,QObject*)
    // 2: QAction::QAction(QString,QObject*)
    if (numArgs == 0) {
        overloadId = 0; // QAction(QObject*)
    } else if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QICON_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 1; // QAction(QIcon,QString,QObject*)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[2])))) {
            overloadId = 1; // QAction(QIcon,QString,QObject*)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QAction(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 2; // QAction(QString,QObject*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1])))) {
            overloadId = 2; // QAction(QString,QObject*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAction_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QAction(QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[0]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QAction_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                            goto Sbk_QAction_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QObject *cppArg0 = nullptr;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QAction(QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QActionWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QActionWrapper(cppArg0);
                }

                Shiboken::Object::setParent(pyArgs[0], self);
            }
            break;
        }
        case 1: // QAction(const QIcon & icon, const QString & text, QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[2]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QAction_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[2]))))
                            goto Sbk_QAction_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QIcon cppArg0_local;
            ::QIcon *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QICON_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return -1;
            ::QObject *cppArg2 = nullptr;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // QAction(QIcon,QString,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QActionWrapper(*cppArg0, cppArg1, cppArg2);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QActionWrapper(*cppArg0, cppArg1, cppArg2);
                }

                Shiboken::Object::setParent(pyArgs[2], self);
            }
            break;
        }
        case 2: // QAction(const QString & text, QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[1]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QAction_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1]))))
                            goto Sbk_QAction_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QObject *cppArg1 = nullptr;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QAction(QString,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QActionWrapper(cppArg0, cppArg1);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QActionWrapper(cppArg0, cppArg1);
                }

                Shiboken::Object::setParent(pyArgs[1], self);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QAction >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QAction_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QAction_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QAction_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QActionFunc_actionGroup(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAction *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAction.actionGroup";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // actionGroup()const
            QActionGroup * cppResult = const_cast<const ::QAction *>(cppSelf)->actionGroup();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QACTIONGROUP_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QActionFunc_activate(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAction *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAction.activate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAction::activate(QAction::ActionEvent)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QACTION_ACTIONEVENT_IDX])->converter, (pyArg)))) {
        overloadId = 0; // activate(QAction::ActionEvent)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QActionFunc_activate_TypeError;

    // Call function/method
    {
        ::QAction::ActionEvent cppArg0{QAction::Trigger};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // activate(QAction::ActionEvent)
            cppSelf->activate(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QActionFunc_activate_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QActionFunc_associatedGraphicsWidgets(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAction *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAction.associatedGraphicsWidgets";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // associatedGraphicsWidgets()const
            QList<QGraphicsWidget* > cppResult = const_cast<const ::QAction *>(cppSelf)->associatedGraphicsWidgets();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QGRAPHICSWIDGETPTR_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QActionFunc_associatedWidgets(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAction *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAction.associatedWidgets";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // associatedWidgets()const
            QList<QWidget* > cppResult = const_cast<const ::QAction *>(cppSelf)->associatedWidgets();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QWIDGETPTR_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QActionFunc_autoRepeat(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAction *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAction.autoRepeat";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // autoRepeat()const
            bool cppResult = const_cast<const ::QAction *>(cppSelf)->autoRepeat();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QActionFunc_data(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAction *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAction.data";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // data()const
            QVariant cppResult = const_cast<const ::QAction *>(cppSelf)->data();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QActionFunc_event(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAction *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAction.event";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QObject::event(QEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // event(QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QActionFunc_event_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // event(QEvent*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QAction::event(cppArg0)
                : cppSelf->event(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QActionFunc_event_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QActionFunc_font(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAction *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAction.font";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // font()const
            QFont cppResult = const_cast<const ::QAction *>(cppSelf)->font();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QActionFunc_hover(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAction *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAction.hover";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hover()
            cppSelf->hover();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QActionFunc_icon(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAction *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAction.icon";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // icon()const
            QIcon cppResult = const_cast<const ::QAction *>(cppSelf)->icon();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QICON_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QActionFunc_iconText(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAction *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAction.iconText";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // iconText()const
            QString cppResult = const_cast<const ::QAction *>(cppSelf)->iconText();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QActionFunc_isCheckable(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAction *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAction.isCheckable";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isCheckable()const
            bool cppResult = const_cast<const ::QAction *>(cppSelf)->isCheckable();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QActionFunc_isChecked(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAction *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAction.isChecked";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isChecked()const
            bool cppResult = const_cast<const ::QAction *>(cppSelf)->isChecked();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QActionFunc_isEnabled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAction *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAction.isEnabled";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isEnabled()const
            bool cppResult = const_cast<const ::QAction *>(cppSelf)->isEnabled();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QActionFunc_isIconVisibleInMenu(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAction *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAction.isIconVisibleInMenu";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isIconVisibleInMenu()const
            bool cppResult = const_cast<const ::QAction *>(cppSelf)->isIconVisibleInMenu();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QActionFunc_isSeparator(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAction *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAction.isSeparator";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isSeparator()const
            bool cppResult = const_cast<const ::QAction *>(cppSelf)->isSeparator();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QActionFunc_isShortcutVisibleInContextMenu(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAction *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAction.isShortcutVisibleInContextMenu";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isShortcutVisibleInContextMenu()const
            bool cppResult = const_cast<const ::QAction *>(cppSelf)->isShortcutVisibleInContextMenu();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QActionFunc_isVisible(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAction *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAction.isVisible";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isVisible()const
            bool cppResult = const_cast<const ::QAction *>(cppSelf)->isVisible();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QActionFunc_menu(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAction *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAction.menu";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // menu()const
            QMenu * cppResult = const_cast<const ::QAction *>(cppSelf)->menu();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QMENU_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QActionFunc_menuRole(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAction *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAction.menuRole";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // menuRole()const
            QAction::MenuRole cppResult = const_cast<const ::QAction *>(cppSelf)->menuRole();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QACTION_MENUROLE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QActionFunc_parentWidget(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAction *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAction.parentWidget";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // parentWidget()const
            QWidget * cppResult = const_cast<const ::QAction *>(cppSelf)->parentWidget();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QActionFunc_priority(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAction *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAction.priority";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // priority()const
            QAction::Priority cppResult = const_cast<const ::QAction *>(cppSelf)->priority();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QACTION_PRIORITY_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QActionFunc_setActionGroup(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAction *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAction.setActionGroup";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAction::setActionGroup(QActionGroup*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QACTIONGROUP_IDX]), (pyArg)))) {
        overloadId = 0; // setActionGroup(QActionGroup*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QActionFunc_setActionGroup_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QActionGroup *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setActionGroup(QActionGroup*)
            cppSelf->setActionGroup(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QActionFunc_setActionGroup_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QActionFunc_setAutoRepeat(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAction *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAction.setAutoRepeat";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAction::setAutoRepeat(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setAutoRepeat(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QActionFunc_setAutoRepeat_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAutoRepeat(bool)
            cppSelf->setAutoRepeat(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QActionFunc_setAutoRepeat_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QActionFunc_setCheckable(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAction *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAction.setCheckable";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAction::setCheckable(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setCheckable(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QActionFunc_setCheckable_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setCheckable(bool)
            cppSelf->setCheckable(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QActionFunc_setCheckable_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QActionFunc_setChecked(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAction *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAction.setChecked";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAction::setChecked(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setChecked(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QActionFunc_setChecked_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setChecked(bool)
            cppSelf->setChecked(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QActionFunc_setChecked_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QActionFunc_setData(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAction *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAction.setData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAction::setData(QVariant)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArg)))) {
        overloadId = 0; // setData(QVariant)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QActionFunc_setData_TypeError;

    // Call function/method
    {
        ::QVariant cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setData(QVariant)
            cppSelf->setData(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QActionFunc_setData_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QActionFunc_setDisabled(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAction *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAction.setDisabled";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAction::setDisabled(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setDisabled(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QActionFunc_setDisabled_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDisabled(bool)
            cppSelf->setDisabled(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QActionFunc_setDisabled_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QActionFunc_setEnabled(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAction *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAction.setEnabled";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAction::setEnabled(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setEnabled(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QActionFunc_setEnabled_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setEnabled(bool)
            cppSelf->setEnabled(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QActionFunc_setEnabled_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QActionFunc_setFont(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAction *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAction.setFont";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAction::setFont(QFont)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), (pyArg)))) {
        overloadId = 0; // setFont(QFont)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QActionFunc_setFont_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QFont cppArg0_local;
        ::QFont *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setFont(QFont)
            cppSelf->setFont(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QActionFunc_setFont_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QActionFunc_setIcon(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAction *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAction.setIcon";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAction::setIcon(QIcon)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QICON_IDX]), (pyArg)))) {
        overloadId = 0; // setIcon(QIcon)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QActionFunc_setIcon_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QIcon cppArg0_local;
        ::QIcon *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QICON_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setIcon(QIcon)
            cppSelf->setIcon(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QActionFunc_setIcon_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QActionFunc_setIconText(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAction *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAction.setIconText";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAction::setIconText(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setIconText(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QActionFunc_setIconText_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setIconText(QString)
            cppSelf->setIconText(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QActionFunc_setIconText_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QActionFunc_setIconVisibleInMenu(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAction *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAction.setIconVisibleInMenu";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAction::setIconVisibleInMenu(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setIconVisibleInMenu(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QActionFunc_setIconVisibleInMenu_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setIconVisibleInMenu(bool)
            cppSelf->setIconVisibleInMenu(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QActionFunc_setIconVisibleInMenu_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QActionFunc_setMenu(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAction *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAction.setMenu";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAction::setMenu(QMenu*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QMENU_IDX]), (pyArg)))) {
        overloadId = 0; // setMenu(QMenu*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QActionFunc_setMenu_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMenu *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMenu(QMenu*)
            cppSelf->setMenu(cppArg0);
            Shiboken::Object::setParent(self, pyArg);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QActionFunc_setMenu_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QActionFunc_setMenuRole(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAction *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAction.setMenuRole";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAction::setMenuRole(QAction::MenuRole)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QACTION_MENUROLE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setMenuRole(QAction::MenuRole)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QActionFunc_setMenuRole_TypeError;

    // Call function/method
    {
        ::QAction::MenuRole cppArg0{QAction::NoRole};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMenuRole(QAction::MenuRole)
            cppSelf->setMenuRole(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QActionFunc_setMenuRole_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QActionFunc_setPriority(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAction *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAction.setPriority";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAction::setPriority(QAction::Priority)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QACTION_PRIORITY_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setPriority(QAction::Priority)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QActionFunc_setPriority_TypeError;

    // Call function/method
    {
        ::QAction::Priority cppArg0{QAction::LowPriority};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPriority(QAction::Priority)
            cppSelf->setPriority(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QActionFunc_setPriority_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QActionFunc_setSeparator(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAction *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAction.setSeparator";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAction::setSeparator(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setSeparator(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QActionFunc_setSeparator_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSeparator(bool)
            cppSelf->setSeparator(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QActionFunc_setSeparator_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QActionFunc_setShortcut(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAction *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAction.setShortcut";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAction::setShortcut(QKeySequence)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX]), (pyArg)))) {
        overloadId = 0; // setShortcut(QKeySequence)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QActionFunc_setShortcut_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QKeySequence cppArg0_local;
        ::QKeySequence *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setShortcut(QKeySequence)
            cppSelf->setShortcut(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QActionFunc_setShortcut_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QActionFunc_setShortcutContext(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAction *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAction.setShortcutContext";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAction::setShortcutContext(Qt::ShortcutContext)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_SHORTCUTCONTEXT_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setShortcutContext(Qt::ShortcutContext)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QActionFunc_setShortcutContext_TypeError;

    // Call function/method
    {
        ::Qt::ShortcutContext cppArg0{Qt::WidgetShortcut};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setShortcutContext(Qt::ShortcutContext)
            cppSelf->setShortcutContext(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QActionFunc_setShortcutContext_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QActionFunc_setShortcutVisibleInContextMenu(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAction *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAction.setShortcutVisibleInContextMenu";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAction::setShortcutVisibleInContextMenu(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setShortcutVisibleInContextMenu(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QActionFunc_setShortcutVisibleInContextMenu_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setShortcutVisibleInContextMenu(bool)
            cppSelf->setShortcutVisibleInContextMenu(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QActionFunc_setShortcutVisibleInContextMenu_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QActionFunc_setShortcuts(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAction *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAction.setShortcuts";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAction::setShortcuts(QKeySequence::StandardKey)
    // 1: QAction::setShortcuts(QList<QKeySequence>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QKEYSEQUENCE_IDX], (pyArg)))) {
        overloadId = 1; // setShortcuts(QList<QKeySequence>)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_STANDARDKEY_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setShortcuts(QKeySequence::StandardKey)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QActionFunc_setShortcuts_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setShortcuts(QKeySequence::StandardKey arg__1)
        {
            ::QKeySequence::StandardKey cppArg0{QKeySequence::UnknownKey};
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // setShortcuts(QKeySequence::StandardKey)
                cppSelf->setShortcuts(cppArg0);
            }
            break;
        }
        case 1: // setShortcuts(const QList<QKeySequence > & shortcuts)
        {
            ::QList<QKeySequence > cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // setShortcuts(QList<QKeySequence>)
                cppSelf->setShortcuts(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QActionFunc_setShortcuts_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QActionFunc_setStatusTip(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAction *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAction.setStatusTip";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAction::setStatusTip(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setStatusTip(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QActionFunc_setStatusTip_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setStatusTip(QString)
            cppSelf->setStatusTip(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QActionFunc_setStatusTip_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QActionFunc_setText(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAction *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAction.setText";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAction::setText(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setText(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QActionFunc_setText_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setText(QString)
            cppSelf->setText(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QActionFunc_setText_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QActionFunc_setToolTip(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAction *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAction.setToolTip";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAction::setToolTip(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setToolTip(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QActionFunc_setToolTip_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setToolTip(QString)
            cppSelf->setToolTip(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QActionFunc_setToolTip_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QActionFunc_setVisible(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAction *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAction.setVisible";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAction::setVisible(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setVisible(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QActionFunc_setVisible_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setVisible(bool)
            cppSelf->setVisible(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QActionFunc_setVisible_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QActionFunc_setWhatsThis(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAction *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAction.setWhatsThis";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAction::setWhatsThis(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setWhatsThis(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QActionFunc_setWhatsThis_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setWhatsThis(QString)
            cppSelf->setWhatsThis(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QActionFunc_setWhatsThis_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QActionFunc_shortcut(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAction *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAction.shortcut";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // shortcut()const
            QKeySequence cppResult = const_cast<const ::QAction *>(cppSelf)->shortcut();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QActionFunc_shortcutContext(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAction *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAction.shortcutContext";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // shortcutContext()const
            Qt::ShortcutContext cppResult = const_cast<const ::QAction *>(cppSelf)->shortcutContext();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_SHORTCUTCONTEXT_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QActionFunc_shortcuts(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAction *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAction.shortcuts";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // shortcuts()const
            QList<QKeySequence > cppResult = const_cast<const ::QAction *>(cppSelf)->shortcuts();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QKEYSEQUENCE_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QActionFunc_showStatusText(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAction *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAction.showStatusText";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QActionFunc_showStatusText_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:showStatusText", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QAction::showStatusText(QWidget*)
    if (numArgs == 0) {
        overloadId = 0; // showStatusText(QWidget*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[0])))) {
        overloadId = 0; // showStatusText(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QActionFunc_showStatusText_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_widget = Shiboken::String::createStaticString("widget");
            if (PyDict_Contains(kwds, key_widget)) {
                value = PyDict_GetItem(kwds, key_widget);
                if (value && pyArgs[0]) {
                    errInfo = key_widget;
                    Py_INCREF(errInfo);
                    goto Sbk_QActionFunc_showStatusText_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[0]))))
                        goto Sbk_QActionFunc_showStatusText_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_widget);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QActionFunc_showStatusText_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QWidget *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // showStatusText(QWidget*)
            bool cppResult = cppSelf->showStatusText(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QActionFunc_showStatusText_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QActionFunc_statusTip(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAction *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAction.statusTip";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // statusTip()const
            QString cppResult = const_cast<const ::QAction *>(cppSelf)->statusTip();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QActionFunc_text(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAction *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAction.text";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // text()const
            QString cppResult = const_cast<const ::QAction *>(cppSelf)->text();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QActionFunc_toggle(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAction *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAction.toggle";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toggle()
            cppSelf->toggle();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QActionFunc_toolTip(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAction *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAction.toolTip";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toolTip()const
            QString cppResult = const_cast<const ::QAction *>(cppSelf)->toolTip();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QActionFunc_trigger(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAction *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAction.trigger";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // trigger()
            cppSelf->trigger();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QActionFunc_whatsThis(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAction *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QAction.whatsThis";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // whatsThis()const
            QString cppResult = const_cast<const ::QAction *>(cppSelf)->whatsThis();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QAction_PropertyStrings[] = {
    "autoRepeat::",
    "checkable:isCheckable:",
    "checked:isChecked:",
    "enabled:isEnabled:",
    "font::",
    "icon::",
    "iconText::",
    "iconVisibleInMenu:isIconVisibleInMenu:",
    "menuRole::",
    "priority::",
    "shortcut::",
    "shortcutContext::",
    "shortcutVisibleInContextMenu:isShortcutVisibleInContextMenu:",
    "statusTip::",
    "text::",
    "toolTip::",
    "visible:isVisible:",
    "whatsThis::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QAction_methods[] = {
    {"actionGroup", reinterpret_cast<PyCFunction>(Sbk_QActionFunc_actionGroup), METH_NOARGS},
    {"activate", reinterpret_cast<PyCFunction>(Sbk_QActionFunc_activate), METH_O},
    {"associatedGraphicsWidgets", reinterpret_cast<PyCFunction>(Sbk_QActionFunc_associatedGraphicsWidgets), METH_NOARGS},
    {"associatedWidgets", reinterpret_cast<PyCFunction>(Sbk_QActionFunc_associatedWidgets), METH_NOARGS},
    {"autoRepeat", reinterpret_cast<PyCFunction>(Sbk_QActionFunc_autoRepeat), METH_NOARGS},
    {"data", reinterpret_cast<PyCFunction>(Sbk_QActionFunc_data), METH_NOARGS},
    {"event", reinterpret_cast<PyCFunction>(Sbk_QActionFunc_event), METH_O},
    {"font", reinterpret_cast<PyCFunction>(Sbk_QActionFunc_font), METH_NOARGS},
    {"hover", reinterpret_cast<PyCFunction>(Sbk_QActionFunc_hover), METH_NOARGS},
    {"icon", reinterpret_cast<PyCFunction>(Sbk_QActionFunc_icon), METH_NOARGS},
    {"iconText", reinterpret_cast<PyCFunction>(Sbk_QActionFunc_iconText), METH_NOARGS},
    {"isCheckable", reinterpret_cast<PyCFunction>(Sbk_QActionFunc_isCheckable), METH_NOARGS},
    {"isChecked", reinterpret_cast<PyCFunction>(Sbk_QActionFunc_isChecked), METH_NOARGS},
    {"isEnabled", reinterpret_cast<PyCFunction>(Sbk_QActionFunc_isEnabled), METH_NOARGS},
    {"isIconVisibleInMenu", reinterpret_cast<PyCFunction>(Sbk_QActionFunc_isIconVisibleInMenu), METH_NOARGS},
    {"isSeparator", reinterpret_cast<PyCFunction>(Sbk_QActionFunc_isSeparator), METH_NOARGS},
    {"isShortcutVisibleInContextMenu", reinterpret_cast<PyCFunction>(Sbk_QActionFunc_isShortcutVisibleInContextMenu), METH_NOARGS},
    {"isVisible", reinterpret_cast<PyCFunction>(Sbk_QActionFunc_isVisible), METH_NOARGS},
    {"menu", reinterpret_cast<PyCFunction>(Sbk_QActionFunc_menu), METH_NOARGS},
    {"menuRole", reinterpret_cast<PyCFunction>(Sbk_QActionFunc_menuRole), METH_NOARGS},
    {"parentWidget", reinterpret_cast<PyCFunction>(Sbk_QActionFunc_parentWidget), METH_NOARGS},
    {"priority", reinterpret_cast<PyCFunction>(Sbk_QActionFunc_priority), METH_NOARGS},
    {"setActionGroup", reinterpret_cast<PyCFunction>(Sbk_QActionFunc_setActionGroup), METH_O},
    {"setAutoRepeat", reinterpret_cast<PyCFunction>(Sbk_QActionFunc_setAutoRepeat), METH_O},
    {"setCheckable", reinterpret_cast<PyCFunction>(Sbk_QActionFunc_setCheckable), METH_O},
    {"setChecked", reinterpret_cast<PyCFunction>(Sbk_QActionFunc_setChecked), METH_O},
    {"setData", reinterpret_cast<PyCFunction>(Sbk_QActionFunc_setData), METH_O},
    {"setDisabled", reinterpret_cast<PyCFunction>(Sbk_QActionFunc_setDisabled), METH_O},
    {"setEnabled", reinterpret_cast<PyCFunction>(Sbk_QActionFunc_setEnabled), METH_O},
    {"setFont", reinterpret_cast<PyCFunction>(Sbk_QActionFunc_setFont), METH_O},
    {"setIcon", reinterpret_cast<PyCFunction>(Sbk_QActionFunc_setIcon), METH_O},
    {"setIconText", reinterpret_cast<PyCFunction>(Sbk_QActionFunc_setIconText), METH_O},
    {"setIconVisibleInMenu", reinterpret_cast<PyCFunction>(Sbk_QActionFunc_setIconVisibleInMenu), METH_O},
    {"setMenu", reinterpret_cast<PyCFunction>(Sbk_QActionFunc_setMenu), METH_O},
    {"setMenuRole", reinterpret_cast<PyCFunction>(Sbk_QActionFunc_setMenuRole), METH_O},
    {"setPriority", reinterpret_cast<PyCFunction>(Sbk_QActionFunc_setPriority), METH_O},
    {"setSeparator", reinterpret_cast<PyCFunction>(Sbk_QActionFunc_setSeparator), METH_O},
    {"setShortcut", reinterpret_cast<PyCFunction>(Sbk_QActionFunc_setShortcut), METH_O},
    {"setShortcutContext", reinterpret_cast<PyCFunction>(Sbk_QActionFunc_setShortcutContext), METH_O},
    {"setShortcutVisibleInContextMenu", reinterpret_cast<PyCFunction>(Sbk_QActionFunc_setShortcutVisibleInContextMenu), METH_O},
    {"setShortcuts", reinterpret_cast<PyCFunction>(Sbk_QActionFunc_setShortcuts), METH_O},
    {"setStatusTip", reinterpret_cast<PyCFunction>(Sbk_QActionFunc_setStatusTip), METH_O},
    {"setText", reinterpret_cast<PyCFunction>(Sbk_QActionFunc_setText), METH_O},
    {"setToolTip", reinterpret_cast<PyCFunction>(Sbk_QActionFunc_setToolTip), METH_O},
    {"setVisible", reinterpret_cast<PyCFunction>(Sbk_QActionFunc_setVisible), METH_O},
    {"setWhatsThis", reinterpret_cast<PyCFunction>(Sbk_QActionFunc_setWhatsThis), METH_O},
    {"shortcut", reinterpret_cast<PyCFunction>(Sbk_QActionFunc_shortcut), METH_NOARGS},
    {"shortcutContext", reinterpret_cast<PyCFunction>(Sbk_QActionFunc_shortcutContext), METH_NOARGS},
    {"shortcuts", reinterpret_cast<PyCFunction>(Sbk_QActionFunc_shortcuts), METH_NOARGS},
    {"showStatusText", reinterpret_cast<PyCFunction>(Sbk_QActionFunc_showStatusText), METH_VARARGS|METH_KEYWORDS},
    {"statusTip", reinterpret_cast<PyCFunction>(Sbk_QActionFunc_statusTip), METH_NOARGS},
    {"text", reinterpret_cast<PyCFunction>(Sbk_QActionFunc_text), METH_NOARGS},
    {"toggle", reinterpret_cast<PyCFunction>(Sbk_QActionFunc_toggle), METH_NOARGS},
    {"toolTip", reinterpret_cast<PyCFunction>(Sbk_QActionFunc_toolTip), METH_NOARGS},
    {"trigger", reinterpret_cast<PyCFunction>(Sbk_QActionFunc_trigger), METH_NOARGS},
    {"whatsThis", reinterpret_cast<PyCFunction>(Sbk_QActionFunc_whatsThis), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QAction_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QAction *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QActionWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QAction_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QAction_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
extern "C"
{
static PyObject *Sbk_QAction__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAction *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    int idx = str.indexOf('(');
    if (idx >= 0)
        str.replace(0, idx, Py_TYPE(self)->tp_name);
    str = str.trimmed();
    PyObject *mod = PyDict_GetItem(Py_TYPE(self)->tp_dict, Shiboken::PyMagicName::module());
    if (mod && !strchr(str, '.'))
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    else
        return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C

// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QAction_Type = nullptr;
static SbkObjectType *Sbk_QAction_TypeF(void)
{
    return _Sbk_QAction_Type;
}

static PyType_Slot Sbk_QAction_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QAction__repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QAction_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QAction_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QAction_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QAction_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QAction_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QAction_spec = {
    "2:PySide2.QtWidgets.QAction",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QAction_slots
};

} //extern "C"

static void *Sbk_QAction_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QAction *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void QAction_MenuRole_PythonToCpp_QAction_MenuRole(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QAction::MenuRole *>(cppOut) =
        static_cast<::QAction::MenuRole>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QAction_MenuRole_PythonToCpp_QAction_MenuRole_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QACTION_MENUROLE_IDX]))
        return QAction_MenuRole_PythonToCpp_QAction_MenuRole;
    return {};
}
static PyObject *QAction_MenuRole_CppToPython_QAction_MenuRole(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QAction::MenuRole *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QACTION_MENUROLE_IDX], castCppIn);

}

static void QAction_Priority_PythonToCpp_QAction_Priority(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QAction::Priority *>(cppOut) =
        static_cast<::QAction::Priority>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QAction_Priority_PythonToCpp_QAction_Priority_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QACTION_PRIORITY_IDX]))
        return QAction_Priority_PythonToCpp_QAction_Priority;
    return {};
}
static PyObject *QAction_Priority_CppToPython_QAction_Priority(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QAction::Priority *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QACTION_PRIORITY_IDX], castCppIn);

}

static void QAction_ActionEvent_PythonToCpp_QAction_ActionEvent(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QAction::ActionEvent *>(cppOut) =
        static_cast<::QAction::ActionEvent>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QAction_ActionEvent_PythonToCpp_QAction_ActionEvent_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QACTION_ACTIONEVENT_IDX]))
        return QAction_ActionEvent_PythonToCpp_QAction_ActionEvent;
    return {};
}
static PyObject *QAction_ActionEvent_CppToPython_QAction_ActionEvent(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QAction::ActionEvent *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QACTION_ACTIONEVENT_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QAction_PythonToCpp_QAction_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QAction_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QAction_PythonToCpp_QAction_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QAction_TypeF())))
        return QAction_PythonToCpp_QAction_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QAction_PTR_CppToPython_QAction(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QAction *>(const_cast<void *>(cppIn)), Sbk_QAction_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QAction_SignatureStrings[] = {
    "2:PySide2.QtWidgets.QAction(self,parent:PySide2.QtCore.QObject=nullptr)",
    "1:PySide2.QtWidgets.QAction(self,icon:PySide2.QtGui.QIcon,text:QString,parent:PySide2.QtCore.QObject=nullptr)",
    "0:PySide2.QtWidgets.QAction(self,text:QString,parent:PySide2.QtCore.QObject=nullptr)",
    "PySide2.QtWidgets.QAction.actionGroup(self)->PySide2.QtWidgets.QActionGroup",
    "PySide2.QtWidgets.QAction.activate(self,event:PySide2.QtWidgets.QAction.ActionEvent)",
    "PySide2.QtWidgets.QAction.associatedGraphicsWidgets(self)->QList[PySide2.QtWidgets.QGraphicsWidget]",
    "PySide2.QtWidgets.QAction.associatedWidgets(self)->QList[PySide2.QtWidgets.QWidget]",
    "PySide2.QtWidgets.QAction.autoRepeat(self)->bool",
    "PySide2.QtWidgets.QAction.data(self)->QVariant",
    "PySide2.QtWidgets.QAction.event(self,arg__1:PySide2.QtCore.QEvent)->bool",
    "PySide2.QtWidgets.QAction.font(self)->PySide2.QtGui.QFont",
    "PySide2.QtWidgets.QAction.hover(self)",
    "PySide2.QtWidgets.QAction.icon(self)->PySide2.QtGui.QIcon",
    "PySide2.QtWidgets.QAction.iconText(self)->QString",
    "PySide2.QtWidgets.QAction.isCheckable(self)->bool",
    "PySide2.QtWidgets.QAction.isChecked(self)->bool",
    "PySide2.QtWidgets.QAction.isEnabled(self)->bool",
    "PySide2.QtWidgets.QAction.isIconVisibleInMenu(self)->bool",
    "PySide2.QtWidgets.QAction.isSeparator(self)->bool",
    "PySide2.QtWidgets.QAction.isShortcutVisibleInContextMenu(self)->bool",
    "PySide2.QtWidgets.QAction.isVisible(self)->bool",
    "PySide2.QtWidgets.QAction.menu(self)->PySide2.QtWidgets.QMenu",
    "PySide2.QtWidgets.QAction.menuRole(self)->PySide2.QtWidgets.QAction.MenuRole",
    "PySide2.QtWidgets.QAction.parentWidget(self)->PySide2.QtWidgets.QWidget",
    "PySide2.QtWidgets.QAction.priority(self)->PySide2.QtWidgets.QAction.Priority",
    "PySide2.QtWidgets.QAction.setActionGroup(self,group:PySide2.QtWidgets.QActionGroup)",
    "PySide2.QtWidgets.QAction.setAutoRepeat(self,arg__1:bool)",
    "PySide2.QtWidgets.QAction.setCheckable(self,arg__1:bool)",
    "PySide2.QtWidgets.QAction.setChecked(self,arg__1:bool)",
    "PySide2.QtWidgets.QAction.setData(self,var:QVariant)",
    "PySide2.QtWidgets.QAction.setDisabled(self,b:bool)",
    "PySide2.QtWidgets.QAction.setEnabled(self,arg__1:bool)",
    "PySide2.QtWidgets.QAction.setFont(self,font:PySide2.QtGui.QFont)",
    "PySide2.QtWidgets.QAction.setIcon(self,icon:PySide2.QtGui.QIcon)",
    "PySide2.QtWidgets.QAction.setIconText(self,text:QString)",
    "PySide2.QtWidgets.QAction.setIconVisibleInMenu(self,visible:bool)",
    "PySide2.QtWidgets.QAction.setMenu(self,menu:PySide2.QtWidgets.QMenu)",
    "PySide2.QtWidgets.QAction.setMenuRole(self,menuRole:PySide2.QtWidgets.QAction.MenuRole)",
    "PySide2.QtWidgets.QAction.setPriority(self,priority:PySide2.QtWidgets.QAction.Priority)",
    "PySide2.QtWidgets.QAction.setSeparator(self,b:bool)",
    "PySide2.QtWidgets.QAction.setShortcut(self,shortcut:PySide2.QtGui.QKeySequence)",
    "PySide2.QtWidgets.QAction.setShortcutContext(self,context:PySide2.QtCore.Qt.ShortcutContext)",
    "PySide2.QtWidgets.QAction.setShortcutVisibleInContextMenu(self,show:bool)",
    "1:PySide2.QtWidgets.QAction.setShortcuts(self,arg__1:PySide2.QtGui.QKeySequence.StandardKey)",
    "0:PySide2.QtWidgets.QAction.setShortcuts(self,shortcuts:QList[PySide2.QtGui.QKeySequence])",
    "PySide2.QtWidgets.QAction.setStatusTip(self,statusTip:QString)",
    "PySide2.QtWidgets.QAction.setText(self,text:QString)",
    "PySide2.QtWidgets.QAction.setToolTip(self,tip:QString)",
    "PySide2.QtWidgets.QAction.setVisible(self,arg__1:bool)",
    "PySide2.QtWidgets.QAction.setWhatsThis(self,what:QString)",
    "PySide2.QtWidgets.QAction.shortcut(self)->PySide2.QtGui.QKeySequence",
    "PySide2.QtWidgets.QAction.shortcutContext(self)->PySide2.QtCore.Qt.ShortcutContext",
    "PySide2.QtWidgets.QAction.shortcuts(self)->QList[PySide2.QtGui.QKeySequence]",
    "PySide2.QtWidgets.QAction.showStatusText(self,widget:PySide2.QtWidgets.QWidget=nullptr)->bool",
    "PySide2.QtWidgets.QAction.statusTip(self)->QString",
    "PySide2.QtWidgets.QAction.text(self)->QString",
    "PySide2.QtWidgets.QAction.toggle(self)",
    "PySide2.QtWidgets.QAction.toolTip(self)->QString",
    "PySide2.QtWidgets.QAction.trigger(self)",
    "PySide2.QtWidgets.QAction.whatsThis(self)->QString",
    nullptr}; // Sentinel

void init_QAction(PyObject *module)
{
    _Sbk_QAction_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QAction",
        "QAction*",
        &Sbk_QAction_spec,
        &Shiboken::callCppDestructor< ::QAction >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QAction_Type);
    InitSignatureStrings(pyType, QAction_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QAction_Type), Sbk_QAction_PropertyStrings);
    SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QAction_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QAction_TypeF(),
        QAction_PythonToCpp_QAction_PTR,
        is_QAction_PythonToCpp_QAction_PTR_Convertible,
        QAction_PTR_CppToPython_QAction);

    Shiboken::Conversions::registerConverterName(converter, "QAction");
    Shiboken::Conversions::registerConverterName(converter, "QAction*");
    Shiboken::Conversions::registerConverterName(converter, "QAction&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QAction).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QActionWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QAction_TypeF(), &Sbk_QAction_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'MenuRole'.
    SbkPySide2_QtWidgetsTypes[SBK_QACTION_MENUROLE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QAction_TypeF(),
        "MenuRole",
        "2:PySide2.QtWidgets.QAction.MenuRole",
        "QAction::MenuRole");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QACTION_MENUROLE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QACTION_MENUROLE_IDX],
        Sbk_QAction_TypeF(), "NoRole", (long) QAction::MenuRole::NoRole))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QACTION_MENUROLE_IDX],
        Sbk_QAction_TypeF(), "TextHeuristicRole", (long) QAction::MenuRole::TextHeuristicRole))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QACTION_MENUROLE_IDX],
        Sbk_QAction_TypeF(), "ApplicationSpecificRole", (long) QAction::MenuRole::ApplicationSpecificRole))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QACTION_MENUROLE_IDX],
        Sbk_QAction_TypeF(), "AboutQtRole", (long) QAction::MenuRole::AboutQtRole))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QACTION_MENUROLE_IDX],
        Sbk_QAction_TypeF(), "AboutRole", (long) QAction::MenuRole::AboutRole))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QACTION_MENUROLE_IDX],
        Sbk_QAction_TypeF(), "PreferencesRole", (long) QAction::MenuRole::PreferencesRole))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QACTION_MENUROLE_IDX],
        Sbk_QAction_TypeF(), "QuitRole", (long) QAction::MenuRole::QuitRole))
        return;
    // Register converter for enum 'QAction::MenuRole'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QACTION_MENUROLE_IDX],
            QAction_MenuRole_CppToPython_QAction_MenuRole);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QAction_MenuRole_PythonToCpp_QAction_MenuRole,
            is_QAction_MenuRole_PythonToCpp_QAction_MenuRole_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QACTION_MENUROLE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QAction::MenuRole");
        Shiboken::Conversions::registerConverterName(converter, "MenuRole");
    }
    // End of 'MenuRole' enum.

    // Initialization of enum 'Priority'.
    SbkPySide2_QtWidgetsTypes[SBK_QACTION_PRIORITY_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QAction_TypeF(),
        "Priority",
        "2:PySide2.QtWidgets.QAction.Priority",
        "QAction::Priority");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QACTION_PRIORITY_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QACTION_PRIORITY_IDX],
        Sbk_QAction_TypeF(), "LowPriority", (long) QAction::Priority::LowPriority))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QACTION_PRIORITY_IDX],
        Sbk_QAction_TypeF(), "NormalPriority", (long) QAction::Priority::NormalPriority))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QACTION_PRIORITY_IDX],
        Sbk_QAction_TypeF(), "HighPriority", (long) QAction::Priority::HighPriority))
        return;
    // Register converter for enum 'QAction::Priority'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QACTION_PRIORITY_IDX],
            QAction_Priority_CppToPython_QAction_Priority);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QAction_Priority_PythonToCpp_QAction_Priority,
            is_QAction_Priority_PythonToCpp_QAction_Priority_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QACTION_PRIORITY_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QAction::Priority");
        Shiboken::Conversions::registerConverterName(converter, "Priority");
    }
    // End of 'Priority' enum.

    // Initialization of enum 'ActionEvent'.
    SbkPySide2_QtWidgetsTypes[SBK_QACTION_ACTIONEVENT_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QAction_TypeF(),
        "ActionEvent",
        "2:PySide2.QtWidgets.QAction.ActionEvent",
        "QAction::ActionEvent");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QACTION_ACTIONEVENT_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QACTION_ACTIONEVENT_IDX],
        Sbk_QAction_TypeF(), "Trigger", (long) QAction::ActionEvent::Trigger))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QACTION_ACTIONEVENT_IDX],
        Sbk_QAction_TypeF(), "Hover", (long) QAction::ActionEvent::Hover))
        return;
    // Register converter for enum 'QAction::ActionEvent'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QACTION_ACTIONEVENT_IDX],
            QAction_ActionEvent_CppToPython_QAction_ActionEvent);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QAction_ActionEvent_PythonToCpp_QAction_ActionEvent,
            is_QAction_ActionEvent_PythonToCpp_QAction_ActionEvent_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QACTION_ACTIONEVENT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QAction::ActionEvent");
        Shiboken::Conversions::registerConverterName(converter, "ActionEvent");
    }
    // End of 'ActionEvent' enum.

    PySide::Signal::registerSignals(Sbk_QAction_TypeF(), &::QAction::staticMetaObject);
    qRegisterMetaType< ::QAction::MenuRole >("QAction::MenuRole");
    qRegisterMetaType< ::QAction::Priority >("QAction::Priority");
    qRegisterMetaType< ::QAction::ActionEvent >("QAction::ActionEvent");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QAction_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QAction_TypeF(), &::QAction::staticMetaObject, sizeof(QActionWrapper));
}
