/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtwidgets_python.h"

// main header
#include "qapplication_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Begin code injection
// ========================================================================
// START of custom code block [file: ../glue/qtwidgets.cpp (qapplication-init)]
static void QApplicationConstructor(PyObject *self, PyObject *pyargv, QApplicationWrapper **cptr)
{
    static int argc;
    static char **argv;
    PyObject *stringlist = PyTuple_GET_ITEM(pyargv, 0);
    if (Shiboken::listToArgcArgv(stringlist, &argc, &argv, "PySideApp")) {
        *cptr = new QApplicationWrapper(argc, argv, 0);
        Shiboken::Object::releaseOwnership(reinterpret_cast<SbkObject *>(self));
        PySide::registerCleanupFunction(&PySide::destroyQCoreApplication);
    }
}
// END of custom code block [file: ../glue/qtwidgets.cpp (qapplication-init)]
// ========================================================================

// End of code injection


// Native ---------------------------------------------------------

void QApplicationWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QApplicationWrapper::QApplicationWrapper(int & argc, char ** argv, int arg__3) : QApplication(argc, argv, arg__3)
{
    resetPyMethodCache();
    // ... middle
}

void QApplicationWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QApplicationWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QApplicationWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QApplicationWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QApplicationWrapper::event(::QEvent * arg__1)
{
    if (m_PyMethodCache[4])
        return this->::QApplication::event(arg__1);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QApplication::event(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), arg__1)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QApplication.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QApplicationWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QApplication.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

bool QApplicationWrapper::notify(::QObject * arg__1, ::QEvent * arg__2)
{
    if (m_PyMethodCache[7])
        return this->::QApplication::notify(arg__1, arg__2);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "notify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QApplication::notify(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), arg__1),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), arg__2)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QApplication.notify", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QApplicationWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[8]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QApplicationWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QApplication::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QApplicationWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QApplication::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QApplicationWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QApplicationWrapper *>(this));
        return QApplication::qt_metacast(_clname);
}

QApplicationWrapper::~QApplicationWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QApplication_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QApplication >()))
        return -1;

    ::QApplicationWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QApplication.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QApplication", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QApplication::QApplication()
    // 1: QApplication::QApplication(QStringList)
    if (numArgs == 0) {
        overloadId = 0; // QApplication()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArgs[0])))) {
        overloadId = 1; // QApplication(QStringList)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QApplication_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QApplication()
        {

            if (!PyErr_Occurred()) {
                // QApplication()
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtwidgets.cpp (qapplication-2)]
                PyObject *empty = PyTuple_New(2);
                if (!PyTuple_SetItem(empty, 0, PyList_New(0)))
                    QApplicationConstructor(self, empty, &cptr);
                // END of custom code block [file: ../glue/qtwidgets.cpp (qapplication-2)]
                // ========================================================================

                // End of code injection

            }
            break;
        }
        case 1: // QApplication(QStringList arg__1)
        {
            ::QStringList cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            SBK_UNUSED(cppArg0)

            if (!PyErr_Occurred()) {
                // QApplication(QStringList)
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtwidgets.cpp (qapplication-1)]
                QApplicationConstructor(self, args, &cptr);
                // END of custom code block [file: ../glue/qtwidgets.cpp (qapplication-1)]
                // ========================================================================

                // End of code injection

            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QApplication >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QApplication_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QApplication_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QApplication_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QApplicationFunc_aboutQt(PyObject *self)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QApplication.aboutQt";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // aboutQt()
            ::QApplication::aboutQt();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QApplicationFunc_activeModalWidget(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QApplication.activeModalWidget";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // activeModalWidget()
            QWidget * cppResult = ::QApplication::activeModalWidget();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QApplicationFunc_activePopupWidget(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QApplication.activePopupWidget";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // activePopupWidget()
            QWidget * cppResult = ::QApplication::activePopupWidget();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QApplicationFunc_activeWindow(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QApplication.activeWindow";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // activeWindow()
            QWidget * cppResult = ::QApplication::activeWindow();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QApplicationFunc_alert(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QApplication.alert";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QApplicationFunc_alert_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QApplicationFunc_alert_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:alert", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QApplication::alert(QWidget*,int)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // alert(QWidget*,int)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 0; // alert(QWidget*,int)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QApplicationFunc_alert_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_duration = Shiboken::String::createStaticString("duration");
            if (PyDict_Contains(kwds, key_duration)) {
                value = PyDict_GetItem(kwds, key_duration);
                if (value && pyArgs[1]) {
                    errInfo = key_duration;
                    Py_INCREF(errInfo);
                    goto Sbk_QApplicationFunc_alert_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                        goto Sbk_QApplicationFunc_alert_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_duration);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QApplicationFunc_alert_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1 = 0;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // alert(QWidget*,int)
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            ::QApplication::alert(cppArg0, cppArg1);
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QApplicationFunc_alert_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QApplicationFunc_allWidgets(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QApplication.allWidgets";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // allWidgets()
            QList<QWidget* > cppResult = ::QApplication::allWidgets();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QWIDGETPTR_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QApplicationFunc_autoSipEnabled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QApplication *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QAPPLICATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QApplication.autoSipEnabled";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // autoSipEnabled()const
            bool cppResult = const_cast<const ::QApplication *>(cppSelf)->autoSipEnabled();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QApplicationFunc_beep(PyObject *self)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QApplication.beep";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // beep()
            ::QApplication::beep();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QApplicationFunc_closeAllWindows(PyObject *self)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QApplication.closeAllWindows";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // closeAllWindows()
            ::QApplication::closeAllWindows();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QApplicationFunc_colorSpec(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QApplication.colorSpec";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // colorSpec()
            int cppResult = ::QApplication::colorSpec();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QApplicationFunc_cursorFlashTime(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QApplication.cursorFlashTime";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // cursorFlashTime()
            int cppResult = ::QApplication::cursorFlashTime();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QApplicationFunc_desktop(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QApplication.desktop";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // desktop()
            QDesktopWidget * cppResult = ::QApplication::desktop();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QDESKTOPWIDGET_IDX]), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QApplicationFunc_doubleClickInterval(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QApplication.doubleClickInterval";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // doubleClickInterval()
            int cppResult = ::QApplication::doubleClickInterval();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QApplicationFunc_event(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QApplication *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QAPPLICATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QApplication.event";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QObject::event(QEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // event(QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QApplicationFunc_event_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // event(QEvent*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QApplication::event(cppArg0)
                : cppSelf->event(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QApplicationFunc_event_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QApplicationFunc_exec_(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QApplication.exec_";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // exec()
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            int cppResult = ::QApplication::exec();
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QApplicationFunc_focusWidget(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QApplication.focusWidget";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // focusWidget()
            QWidget * cppResult = ::QApplication::focusWidget();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QApplicationFunc_font(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QApplication.font";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "font", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: static QGuiApplication::font()
    // 1: static QApplication::font(const QWidget*)
    // 2: static QApplication::font(const char*)
    if (numArgs == 0) {
        overloadId = 0; // font()
    } else if (numArgs == 1
        && Shiboken::String::check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))) {
        overloadId = 2; // font(const char*)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[0])))) {
        overloadId = 1; // font(const QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QApplicationFunc_font_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // font()
        {

            if (!PyErr_Occurred()) {
                // font()
                QFont cppResult = ::QApplication::font();
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), &cppResult);
            }
            break;
        }
        case 1: // font(const QWidget * arg__1)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QWidget *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // font(const QWidget*)
                QFont cppResult = ::QApplication::font(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), &cppResult);
            }
            break;
        }
        case 2: // font(const char * className)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // font(const char*)
                QFont cppResult = ::QApplication::font(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QApplicationFunc_font_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QApplicationFunc_fontMetrics(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QApplication.fontMetrics";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // fontMetrics()
            QFontMetrics cppResult = ::QApplication::fontMetrics();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICS_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QApplicationFunc_globalStrut(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QApplication.globalStrut";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // globalStrut()
            QSize cppResult = ::QApplication::globalStrut();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QApplicationFunc_isEffectEnabled(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QApplication.isEffectEnabled";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QApplication::isEffectEnabled(Qt::UIEffect)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_UIEFFECT_IDX])->converter, (pyArg)))) {
        overloadId = 0; // isEffectEnabled(Qt::UIEffect)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QApplicationFunc_isEffectEnabled_TypeError;

    // Call function/method
    {
        ::Qt::UIEffect cppArg0{Qt::UI_General};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // isEffectEnabled(Qt::UIEffect)
            bool cppResult = ::QApplication::isEffectEnabled(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QApplicationFunc_isEffectEnabled_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QApplicationFunc_keyboardInputInterval(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QApplication.keyboardInputInterval";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // keyboardInputInterval()
            int cppResult = ::QApplication::keyboardInputInterval();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QApplicationFunc_notify(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QApplication *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QAPPLICATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QApplication.notify";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "notify", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QCoreApplication::notify(QObject*,QEvent*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), (pyArgs[1])))) {
        overloadId = 0; // notify(QObject*,QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QApplicationFunc_notify_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QObject *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QEvent *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // notify(QObject*,QEvent*)
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QApplication::notify(cppArg0, cppArg1)
                : cppSelf->notify(cppArg0, cppArg1);
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QApplicationFunc_notify_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QApplicationFunc_palette(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QApplication.palette";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "palette", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: static QApplication::palette(const QWidget*)
    // 1: static QGuiApplication::palette()
    // 2: static QApplication::palette(const char*)
    if (numArgs == 0) {
        overloadId = 1; // palette()
    } else if (numArgs == 1
        && Shiboken::String::check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))) {
        overloadId = 2; // palette(const char*)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[0])))) {
        overloadId = 0; // palette(const QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QApplicationFunc_palette_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // palette(const QWidget * arg__1)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QWidget *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // palette(const QWidget*)
                QPalette cppResult = ::QApplication::palette(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX]), &cppResult);
            }
            break;
        }
        case 1: // palette()
        {

            if (!PyErr_Occurred()) {
                // palette()
                QPalette cppResult = ::QGuiApplication::palette();
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX]), &cppResult);
            }
            break;
        }
        case 2: // palette(const char * className)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // palette(const char*)
                QPalette cppResult = ::QApplication::palette(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QApplicationFunc_palette_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QApplicationFunc_setActiveWindow(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QApplication.setActiveWindow";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QApplication::setActiveWindow(QWidget*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArg)))) {
        overloadId = 0; // setActiveWindow(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QApplicationFunc_setActiveWindow_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setActiveWindow(QWidget*)
            ::QApplication::setActiveWindow(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QApplicationFunc_setActiveWindow_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QApplicationFunc_setAutoSipEnabled(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QApplication *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QAPPLICATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QApplication.setAutoSipEnabled";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QApplication::setAutoSipEnabled(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setAutoSipEnabled(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QApplicationFunc_setAutoSipEnabled_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAutoSipEnabled(bool)
            cppSelf->setAutoSipEnabled(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QApplicationFunc_setAutoSipEnabled_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QApplicationFunc_setColorSpec(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QApplication.setColorSpec";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QApplication::setColorSpec(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setColorSpec(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QApplicationFunc_setColorSpec_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setColorSpec(int)
            ::QApplication::setColorSpec(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QApplicationFunc_setColorSpec_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QApplicationFunc_setCursorFlashTime(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QApplication.setCursorFlashTime";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QApplication::setCursorFlashTime(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setCursorFlashTime(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QApplicationFunc_setCursorFlashTime_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setCursorFlashTime(int)
            ::QApplication::setCursorFlashTime(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QApplicationFunc_setCursorFlashTime_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QApplicationFunc_setDoubleClickInterval(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QApplication.setDoubleClickInterval";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QApplication::setDoubleClickInterval(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setDoubleClickInterval(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QApplicationFunc_setDoubleClickInterval_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDoubleClickInterval(int)
            ::QApplication::setDoubleClickInterval(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QApplicationFunc_setDoubleClickInterval_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QApplicationFunc_setEffectEnabled(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QApplication.setEffectEnabled";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QApplicationFunc_setEffectEnabled_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QApplicationFunc_setEffectEnabled_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:setEffectEnabled", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QApplication::setEffectEnabled(Qt::UIEffect,bool)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_UIEFFECT_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setEffectEnabled(Qt::UIEffect,bool)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
            overloadId = 0; // setEffectEnabled(Qt::UIEffect,bool)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QApplicationFunc_setEffectEnabled_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_enable = Shiboken::String::createStaticString("enable");
            if (PyDict_Contains(kwds, key_enable)) {
                value = PyDict_GetItem(kwds, key_enable);
                if (value && pyArgs[1]) {
                    errInfo = key_enable;
                    Py_INCREF(errInfo);
                    goto Sbk_QApplicationFunc_setEffectEnabled_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1]))))
                        goto Sbk_QApplicationFunc_setEffectEnabled_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_enable);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QApplicationFunc_setEffectEnabled_TypeError;
            }
        }
        ::Qt::UIEffect cppArg0{Qt::UI_General};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        bool cppArg1 = true;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setEffectEnabled(Qt::UIEffect,bool)
            ::QApplication::setEffectEnabled(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QApplicationFunc_setEffectEnabled_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QApplicationFunc_setFont(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QApplication.setFont";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QApplicationFunc_setFont_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QApplicationFunc_setFont_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:setFont", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QApplication::setFont(QFont,const char*)
    // 1: static QGuiApplication::setFont(QFont)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setFont(QFont,const char*)
        } else if (numArgs >= 2
            && Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1])))) {
            overloadId = 0; // setFont(QFont,const char*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QApplicationFunc_setFont_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setFont(const QFont & arg__1, const char * className)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_className = Shiboken::String::createStaticString("className");
                if (PyDict_Contains(kwds, key_className)) {
                    value = PyDict_GetItem(kwds, key_className);
                    if (value && pyArgs[1]) {
                        errInfo = key_className;
                        Py_INCREF(errInfo);
                        goto Sbk_QApplicationFunc_setFont_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1]))))
                            goto Sbk_QApplicationFunc_setFont_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_className);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QApplicationFunc_setFont_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QFont cppArg0_local;
            ::QFont *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            const char* cppArg1 = nullptr;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setFont(QFont,const char*)
                ::QApplication::setFont(*cppArg0, cppArg1);
            }
            break;
        }
        case 1: // setFont(const QFont & arg__1)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QApplicationFunc_setFont_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QFont cppArg0_local;
            ::QFont *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // setFont(QFont)
                ::QGuiApplication::setFont(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QApplicationFunc_setFont_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QApplicationFunc_setGlobalStrut(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QApplication.setGlobalStrut";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QApplication::setGlobalStrut(QSize)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), (pyArg)))) {
        overloadId = 0; // setGlobalStrut(QSize)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QApplicationFunc_setGlobalStrut_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QSize cppArg0_local;
        ::QSize *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setGlobalStrut(QSize)
            ::QApplication::setGlobalStrut(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QApplicationFunc_setGlobalStrut_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QApplicationFunc_setKeyboardInputInterval(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QApplication.setKeyboardInputInterval";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QApplication::setKeyboardInputInterval(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setKeyboardInputInterval(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QApplicationFunc_setKeyboardInputInterval_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setKeyboardInputInterval(int)
            ::QApplication::setKeyboardInputInterval(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QApplicationFunc_setKeyboardInputInterval_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QApplicationFunc_setPalette(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QApplication.setPalette";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QApplicationFunc_setPalette_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QApplicationFunc_setPalette_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:setPalette", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QApplication::setPalette(QPalette,const char*)
    // 1: static QGuiApplication::setPalette(QPalette)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setPalette(QPalette,const char*)
        } else if (numArgs >= 2
            && Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1])))) {
            overloadId = 0; // setPalette(QPalette,const char*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QApplicationFunc_setPalette_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setPalette(const QPalette & arg__1, const char * className)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_className = Shiboken::String::createStaticString("className");
                if (PyDict_Contains(kwds, key_className)) {
                    value = PyDict_GetItem(kwds, key_className);
                    if (value && pyArgs[1]) {
                        errInfo = key_className;
                        Py_INCREF(errInfo);
                        goto Sbk_QApplicationFunc_setPalette_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1]))))
                            goto Sbk_QApplicationFunc_setPalette_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_className);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QApplicationFunc_setPalette_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPalette cppArg0_local;
            ::QPalette *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            const char* cppArg1 = nullptr;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setPalette(QPalette,const char*)
                ::QApplication::setPalette(*cppArg0, cppArg1);
            }
            break;
        }
        case 1: // setPalette(const QPalette & pal)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QApplicationFunc_setPalette_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPalette cppArg0_local;
            ::QPalette *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // setPalette(QPalette)
                ::QGuiApplication::setPalette(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QApplicationFunc_setPalette_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QApplicationFunc_setStartDragDistance(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QApplication.setStartDragDistance";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QApplication::setStartDragDistance(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setStartDragDistance(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QApplicationFunc_setStartDragDistance_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setStartDragDistance(int)
            ::QApplication::setStartDragDistance(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QApplicationFunc_setStartDragDistance_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QApplicationFunc_setStartDragTime(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QApplication.setStartDragTime";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QApplication::setStartDragTime(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setStartDragTime(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QApplicationFunc_setStartDragTime_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setStartDragTime(int)
            ::QApplication::setStartDragTime(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QApplicationFunc_setStartDragTime_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QApplicationFunc_setStyle(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QApplication.setStyle";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QApplication::setStyle(QStyle*)
    // 1: static QApplication::setStyle(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_IDX]), (pyArg)))) {
        overloadId = 0; // setStyle(QStyle*)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 1; // setStyle(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QApplicationFunc_setStyle_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setStyle(QStyle * arg__1)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QStyle *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // setStyle(QStyle*)
                ::QApplication::setStyle(cppArg0);
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtwidgets.cpp (qapplication-setStyle)]
                if (qApp) {
                    Shiboken::AutoDecRef pyApp(Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QAPPLICATION_IDX]), qApp));
                    Shiboken::Object::setParent(pyApp, pyArg);
                    Shiboken::Object::releaseOwnership(pyArg);
                }
                // END of custom code block [file: ../glue/qtwidgets.cpp (qapplication-setStyle)]
                // ========================================================================

                // End of code injection

                pyResult = Py_None;
                Py_INCREF(Py_None);
            }
            break;
        }
        case 1: // setStyle(const QString & arg__1)
        {
            ::QString cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // setStyle(QString)
                QStyle * cppResult = ::QApplication::setStyle(cppArg0);
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_IDX]), cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QApplicationFunc_setStyle_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QApplicationFunc_setStyleSheet(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QApplication *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QAPPLICATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QApplication.setStyleSheet";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QApplication::setStyleSheet(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setStyleSheet(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QApplicationFunc_setStyleSheet_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setStyleSheet(QString)
            cppSelf->setStyleSheet(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QApplicationFunc_setStyleSheet_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QApplicationFunc_setWheelScrollLines(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QApplication.setWheelScrollLines";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QApplication::setWheelScrollLines(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setWheelScrollLines(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QApplicationFunc_setWheelScrollLines_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setWheelScrollLines(int)
            ::QApplication::setWheelScrollLines(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QApplicationFunc_setWheelScrollLines_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QApplicationFunc_setWindowIcon(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QApplication.setWindowIcon";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QGuiApplication::setWindowIcon(QIcon)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QICON_IDX]), (pyArg)))) {
        overloadId = 0; // setWindowIcon(QIcon)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QApplicationFunc_setWindowIcon_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QIcon cppArg0_local;
        ::QIcon *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QICON_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setWindowIcon(QIcon)
            ::QApplication::setWindowIcon(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QApplicationFunc_setWindowIcon_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QApplicationFunc_startDragDistance(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QApplication.startDragDistance";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // startDragDistance()
            int cppResult = ::QApplication::startDragDistance();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QApplicationFunc_startDragTime(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QApplication.startDragTime";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // startDragTime()
            int cppResult = ::QApplication::startDragTime();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QApplicationFunc_style(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QApplication.style";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // style()
            QStyle * cppResult = ::QApplication::style();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_IDX]), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QApplicationFunc_styleSheet(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QApplication *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QAPPLICATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QApplication.styleSheet";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // styleSheet()const
            QString cppResult = const_cast<const ::QApplication *>(cppSelf)->styleSheet();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QApplicationFunc_topLevelAt(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QApplication.topLevelAt";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "topLevelAt", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QGuiApplication::topLevelAt(QPoint)
    // 1: static QApplication::topLevelAt(int,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 1; // topLevelAt(int,int)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // topLevelAt(QPoint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QApplicationFunc_topLevelAt_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // topLevelAt(const QPoint & p)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPoint cppArg0_local;
            ::QPoint *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // topLevelAt(QPoint)
                QWidget * cppResult = ::QApplication::topLevelAt(*cppArg0);
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), cppResult);
            }
            break;
        }
        case 1: // topLevelAt(int x, int y)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // topLevelAt(int,int)
                QWidget * cppResult = ::QApplication::topLevelAt(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QApplicationFunc_topLevelAt_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QApplicationFunc_topLevelWidgets(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QApplication.topLevelWidgets";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // topLevelWidgets()
            QList<QWidget* > cppResult = ::QApplication::topLevelWidgets();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QWIDGETPTR_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QApplicationFunc_wheelScrollLines(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QApplication.wheelScrollLines";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // wheelScrollLines()
            int cppResult = ::QApplication::wheelScrollLines();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QApplicationFunc_widgetAt(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QApplication.widgetAt";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "widgetAt", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QApplication::widgetAt(QPoint)
    // 1: static QApplication::widgetAt(int,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 1; // widgetAt(int,int)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // widgetAt(QPoint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QApplicationFunc_widgetAt_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // widgetAt(const QPoint & p)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPoint cppArg0_local;
            ::QPoint *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // widgetAt(QPoint)
                QWidget * cppResult = ::QApplication::widgetAt(*cppArg0);
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), cppResult);
            }
            break;
        }
        case 1: // widgetAt(int x, int y)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // widgetAt(int,int)
                QWidget * cppResult = ::QApplication::widgetAt(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QApplicationFunc_widgetAt_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QApplicationFunc_windowIcon(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QApplication.windowIcon";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // windowIcon()
            QIcon cppResult = ::QApplication::windowIcon();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QICON_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QApplication_PropertyStrings[] = {
    "autoSipEnabled::",
    "cursorFlashTime::",
    "doubleClickInterval::",
    "globalStrut::",
    "keyboardInputInterval::",
    "startDragDistance::",
    "startDragTime::",
    "styleSheet::",
    "wheelScrollLines::",
    "windowIcon::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QApplication_methods[] = {
    {"aboutQt", reinterpret_cast<PyCFunction>(Sbk_QApplicationFunc_aboutQt), METH_NOARGS|METH_STATIC},
    {"activeModalWidget", reinterpret_cast<PyCFunction>(Sbk_QApplicationFunc_activeModalWidget), METH_NOARGS|METH_STATIC},
    {"activePopupWidget", reinterpret_cast<PyCFunction>(Sbk_QApplicationFunc_activePopupWidget), METH_NOARGS|METH_STATIC},
    {"activeWindow", reinterpret_cast<PyCFunction>(Sbk_QApplicationFunc_activeWindow), METH_NOARGS|METH_STATIC},
    {"alert", reinterpret_cast<PyCFunction>(Sbk_QApplicationFunc_alert), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"allWidgets", reinterpret_cast<PyCFunction>(Sbk_QApplicationFunc_allWidgets), METH_NOARGS|METH_STATIC},
    {"autoSipEnabled", reinterpret_cast<PyCFunction>(Sbk_QApplicationFunc_autoSipEnabled), METH_NOARGS},
    {"beep", reinterpret_cast<PyCFunction>(Sbk_QApplicationFunc_beep), METH_NOARGS|METH_STATIC},
    {"closeAllWindows", reinterpret_cast<PyCFunction>(Sbk_QApplicationFunc_closeAllWindows), METH_NOARGS|METH_STATIC},
    {"colorSpec", reinterpret_cast<PyCFunction>(Sbk_QApplicationFunc_colorSpec), METH_NOARGS|METH_STATIC},
    {"cursorFlashTime", reinterpret_cast<PyCFunction>(Sbk_QApplicationFunc_cursorFlashTime), METH_NOARGS|METH_STATIC},
    {"desktop", reinterpret_cast<PyCFunction>(Sbk_QApplicationFunc_desktop), METH_NOARGS|METH_STATIC},
    {"doubleClickInterval", reinterpret_cast<PyCFunction>(Sbk_QApplicationFunc_doubleClickInterval), METH_NOARGS|METH_STATIC},
    {"event", reinterpret_cast<PyCFunction>(Sbk_QApplicationFunc_event), METH_O},
    {"exec_", reinterpret_cast<PyCFunction>(Sbk_QApplicationFunc_exec_), METH_NOARGS|METH_STATIC},
    {"focusWidget", reinterpret_cast<PyCFunction>(Sbk_QApplicationFunc_focusWidget), METH_NOARGS|METH_STATIC},
    {"font", reinterpret_cast<PyCFunction>(Sbk_QApplicationFunc_font), METH_VARARGS|METH_STATIC},
    {"fontMetrics", reinterpret_cast<PyCFunction>(Sbk_QApplicationFunc_fontMetrics), METH_NOARGS|METH_STATIC},
    {"globalStrut", reinterpret_cast<PyCFunction>(Sbk_QApplicationFunc_globalStrut), METH_NOARGS|METH_STATIC},
    {"isEffectEnabled", reinterpret_cast<PyCFunction>(Sbk_QApplicationFunc_isEffectEnabled), METH_O|METH_STATIC},
    {"keyboardInputInterval", reinterpret_cast<PyCFunction>(Sbk_QApplicationFunc_keyboardInputInterval), METH_NOARGS|METH_STATIC},
    {"notify", reinterpret_cast<PyCFunction>(Sbk_QApplicationFunc_notify), METH_VARARGS},
    {"palette", reinterpret_cast<PyCFunction>(Sbk_QApplicationFunc_palette), METH_VARARGS|METH_STATIC},
    {"setActiveWindow", reinterpret_cast<PyCFunction>(Sbk_QApplicationFunc_setActiveWindow), METH_O|METH_STATIC},
    {"setAutoSipEnabled", reinterpret_cast<PyCFunction>(Sbk_QApplicationFunc_setAutoSipEnabled), METH_O},
    {"setColorSpec", reinterpret_cast<PyCFunction>(Sbk_QApplicationFunc_setColorSpec), METH_O|METH_STATIC},
    {"setCursorFlashTime", reinterpret_cast<PyCFunction>(Sbk_QApplicationFunc_setCursorFlashTime), METH_O|METH_STATIC},
    {"setDoubleClickInterval", reinterpret_cast<PyCFunction>(Sbk_QApplicationFunc_setDoubleClickInterval), METH_O|METH_STATIC},
    {"setEffectEnabled", reinterpret_cast<PyCFunction>(Sbk_QApplicationFunc_setEffectEnabled), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"setFont", reinterpret_cast<PyCFunction>(Sbk_QApplicationFunc_setFont), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"setGlobalStrut", reinterpret_cast<PyCFunction>(Sbk_QApplicationFunc_setGlobalStrut), METH_O|METH_STATIC},
    {"setKeyboardInputInterval", reinterpret_cast<PyCFunction>(Sbk_QApplicationFunc_setKeyboardInputInterval), METH_O|METH_STATIC},
    {"setPalette", reinterpret_cast<PyCFunction>(Sbk_QApplicationFunc_setPalette), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"setStartDragDistance", reinterpret_cast<PyCFunction>(Sbk_QApplicationFunc_setStartDragDistance), METH_O|METH_STATIC},
    {"setStartDragTime", reinterpret_cast<PyCFunction>(Sbk_QApplicationFunc_setStartDragTime), METH_O|METH_STATIC},
    {"setStyle", reinterpret_cast<PyCFunction>(Sbk_QApplicationFunc_setStyle), METH_O|METH_STATIC},
    {"setStyleSheet", reinterpret_cast<PyCFunction>(Sbk_QApplicationFunc_setStyleSheet), METH_O},
    {"setWheelScrollLines", reinterpret_cast<PyCFunction>(Sbk_QApplicationFunc_setWheelScrollLines), METH_O|METH_STATIC},
    {"setWindowIcon", reinterpret_cast<PyCFunction>(Sbk_QApplicationFunc_setWindowIcon), METH_O|METH_STATIC},
    {"startDragDistance", reinterpret_cast<PyCFunction>(Sbk_QApplicationFunc_startDragDistance), METH_NOARGS|METH_STATIC},
    {"startDragTime", reinterpret_cast<PyCFunction>(Sbk_QApplicationFunc_startDragTime), METH_NOARGS|METH_STATIC},
    {"style", reinterpret_cast<PyCFunction>(Sbk_QApplicationFunc_style), METH_NOARGS|METH_STATIC},
    {"styleSheet", reinterpret_cast<PyCFunction>(Sbk_QApplicationFunc_styleSheet), METH_NOARGS},
    {"topLevelAt", reinterpret_cast<PyCFunction>(Sbk_QApplicationFunc_topLevelAt), METH_VARARGS|METH_STATIC},
    {"topLevelWidgets", reinterpret_cast<PyCFunction>(Sbk_QApplicationFunc_topLevelWidgets), METH_NOARGS|METH_STATIC},
    {"wheelScrollLines", reinterpret_cast<PyCFunction>(Sbk_QApplicationFunc_wheelScrollLines), METH_NOARGS|METH_STATIC},
    {"widgetAt", reinterpret_cast<PyCFunction>(Sbk_QApplicationFunc_widgetAt), METH_VARARGS|METH_STATIC},
    {"windowIcon", reinterpret_cast<PyCFunction>(Sbk_QApplicationFunc_windowIcon), METH_NOARGS|METH_STATIC},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QApplication_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QApplication *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QAPPLICATION_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QApplicationWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QApplication_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QApplication_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QApplication_Type = nullptr;
static SbkObjectType *Sbk_QApplication_TypeF(void)
{
    return _Sbk_QApplication_Type;
}

static PyType_Slot Sbk_QApplication_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocQAppWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QApplication_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QApplication_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QApplication_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QApplication_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QApplication_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkQAppTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QApplication_spec = {
    "2:PySide2.QtWidgets.QApplication",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QApplication_slots
};

} //extern "C"

static void *Sbk_QApplication_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QApplication *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void QApplication_ColorSpec_PythonToCpp_QApplication_ColorSpec(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QApplication::ColorSpec *>(cppOut) =
        static_cast<::QApplication::ColorSpec>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QApplication_ColorSpec_PythonToCpp_QApplication_ColorSpec_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QAPPLICATION_COLORSPEC_IDX]))
        return QApplication_ColorSpec_PythonToCpp_QApplication_ColorSpec;
    return {};
}
static PyObject *QApplication_ColorSpec_CppToPython_QApplication_ColorSpec(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QApplication::ColorSpec *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QAPPLICATION_COLORSPEC_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QApplication_PythonToCpp_QApplication_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QApplication_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QApplication_PythonToCpp_QApplication_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QApplication_TypeF())))
        return QApplication_PythonToCpp_QApplication_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QApplication_PTR_CppToPython_QApplication(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QApplication *>(const_cast<void *>(cppIn)), Sbk_QApplication_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QApplication_SignatureStrings[] = {
    "1:PySide2.QtWidgets.QApplication(self)",
    "0:PySide2.QtWidgets.QApplication(self,arg__1:QStringList)",
    "PySide2.QtWidgets.QApplication.aboutQt()",
    "PySide2.QtWidgets.QApplication.activeModalWidget()->PySide2.QtWidgets.QWidget",
    "PySide2.QtWidgets.QApplication.activePopupWidget()->PySide2.QtWidgets.QWidget",
    "PySide2.QtWidgets.QApplication.activeWindow()->PySide2.QtWidgets.QWidget",
    "PySide2.QtWidgets.QApplication.alert(widget:PySide2.QtWidgets.QWidget,duration:int=0)",
    "PySide2.QtWidgets.QApplication.allWidgets()->QList[PySide2.QtWidgets.QWidget]",
    "PySide2.QtWidgets.QApplication.autoSipEnabled(self)->bool",
    "PySide2.QtWidgets.QApplication.beep()",
    "PySide2.QtWidgets.QApplication.closeAllWindows()",
    "PySide2.QtWidgets.QApplication.colorSpec()->int",
    "PySide2.QtWidgets.QApplication.cursorFlashTime()->int",
    "PySide2.QtWidgets.QApplication.desktop()->PySide2.QtWidgets.QDesktopWidget",
    "PySide2.QtWidgets.QApplication.doubleClickInterval()->int",
    "PySide2.QtWidgets.QApplication.event(self,arg__1:PySide2.QtCore.QEvent)->bool",
    "PySide2.QtWidgets.QApplication.exec_()->int",
    "PySide2.QtWidgets.QApplication.focusWidget()->PySide2.QtWidgets.QWidget",
    "2:PySide2.QtWidgets.QApplication.font()->PySide2.QtGui.QFont",
    "1:PySide2.QtWidgets.QApplication.font(arg__1:PySide2.QtWidgets.QWidget)->PySide2.QtGui.QFont",
    "0:PySide2.QtWidgets.QApplication.font(className:char*)->PySide2.QtGui.QFont",
    "PySide2.QtWidgets.QApplication.fontMetrics()->PySide2.QtGui.QFontMetrics",
    "PySide2.QtWidgets.QApplication.globalStrut()->PySide2.QtCore.QSize",
    "PySide2.QtWidgets.QApplication.isEffectEnabled(arg__1:PySide2.QtCore.Qt.UIEffect)->bool",
    "PySide2.QtWidgets.QApplication.keyboardInputInterval()->int",
    "PySide2.QtWidgets.QApplication.notify(self,arg__1:PySide2.QtCore.QObject,arg__2:PySide2.QtCore.QEvent)->bool",
    "2:PySide2.QtWidgets.QApplication.palette(arg__1:PySide2.QtWidgets.QWidget)->PySide2.QtGui.QPalette",
    "1:PySide2.QtWidgets.QApplication.palette()->PySide2.QtGui.QPalette",
    "0:PySide2.QtWidgets.QApplication.palette(className:char*)->PySide2.QtGui.QPalette",
    "PySide2.QtWidgets.QApplication.setActiveWindow(act:PySide2.QtWidgets.QWidget)",
    "PySide2.QtWidgets.QApplication.setAutoSipEnabled(self,enabled:bool)",
    "PySide2.QtWidgets.QApplication.setColorSpec(arg__1:int)",
    "PySide2.QtWidgets.QApplication.setCursorFlashTime(arg__1:int)",
    "PySide2.QtWidgets.QApplication.setDoubleClickInterval(arg__1:int)",
    "PySide2.QtWidgets.QApplication.setEffectEnabled(arg__1:PySide2.QtCore.Qt.UIEffect,enable:bool=true)",
    "1:PySide2.QtWidgets.QApplication.setFont(arg__1:PySide2.QtGui.QFont,className:char*=nullptr)",
    "0:PySide2.QtWidgets.QApplication.setFont(arg__1:PySide2.QtGui.QFont)",
    "PySide2.QtWidgets.QApplication.setGlobalStrut(arg__1:PySide2.QtCore.QSize)",
    "PySide2.QtWidgets.QApplication.setKeyboardInputInterval(arg__1:int)",
    "1:PySide2.QtWidgets.QApplication.setPalette(arg__1:PySide2.QtGui.QPalette,className:char*=nullptr)",
    "0:PySide2.QtWidgets.QApplication.setPalette(pal:PySide2.QtGui.QPalette)",
    "PySide2.QtWidgets.QApplication.setStartDragDistance(l:int)",
    "PySide2.QtWidgets.QApplication.setStartDragTime(ms:int)",
    "1:PySide2.QtWidgets.QApplication.setStyle(arg__1:PySide2.QtWidgets.QStyle)",
    "0:PySide2.QtWidgets.QApplication.setStyle(arg__1:QString)->PySide2.QtWidgets.QStyle",
    "PySide2.QtWidgets.QApplication.setStyleSheet(self,sheet:QString)",
    "PySide2.QtWidgets.QApplication.setWheelScrollLines(arg__1:int)",
    "PySide2.QtWidgets.QApplication.setWindowIcon(icon:PySide2.QtGui.QIcon)",
    "PySide2.QtWidgets.QApplication.startDragDistance()->int",
    "PySide2.QtWidgets.QApplication.startDragTime()->int",
    "PySide2.QtWidgets.QApplication.style()->PySide2.QtWidgets.QStyle",
    "PySide2.QtWidgets.QApplication.styleSheet(self)->QString",
    "1:PySide2.QtWidgets.QApplication.topLevelAt(p:PySide2.QtCore.QPoint)->PySide2.QtWidgets.QWidget",
    "0:PySide2.QtWidgets.QApplication.topLevelAt(x:int,y:int)->PySide2.QtWidgets.QWidget",
    "PySide2.QtWidgets.QApplication.topLevelWidgets()->QList[PySide2.QtWidgets.QWidget]",
    "PySide2.QtWidgets.QApplication.wheelScrollLines()->int",
    "1:PySide2.QtWidgets.QApplication.widgetAt(p:PySide2.QtCore.QPoint)->PySide2.QtWidgets.QWidget",
    "0:PySide2.QtWidgets.QApplication.widgetAt(x:int,y:int)->PySide2.QtWidgets.QWidget",
    "PySide2.QtWidgets.QApplication.windowIcon()->PySide2.QtGui.QIcon",
    nullptr}; // Sentinel

void init_QApplication(PyObject *module)
{
    _Sbk_QApplication_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QApplication",
        "QApplication*",
        &Sbk_QApplication_spec,
        &Shiboken::callCppDestructor< ::QApplication >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QGUIAPPLICATION_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QApplication_Type);
    InitSignatureStrings(pyType, QApplication_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QApplication_Type), Sbk_QApplication_PropertyStrings);
    SbkPySide2_QtWidgetsTypes[SBK_QAPPLICATION_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QApplication_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QApplication_TypeF(),
        QApplication_PythonToCpp_QApplication_PTR,
        is_QApplication_PythonToCpp_QApplication_PTR_Convertible,
        QApplication_PTR_CppToPython_QApplication);

    Shiboken::Conversions::registerConverterName(converter, "QApplication");
    Shiboken::Conversions::registerConverterName(converter, "QApplication*");
    Shiboken::Conversions::registerConverterName(converter, "QApplication&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QApplication).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QApplicationWrapper).name());



    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QApplication_TypeF(), &Sbk_QApplication_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'ColorSpec'.
    SbkPySide2_QtWidgetsTypes[SBK_QAPPLICATION_COLORSPEC_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QApplication_TypeF(),
        "ColorSpec",
        "2:PySide2.QtWidgets.QApplication.ColorSpec",
        "QApplication::ColorSpec");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QAPPLICATION_COLORSPEC_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QAPPLICATION_COLORSPEC_IDX],
        Sbk_QApplication_TypeF(), "NormalColor", (long) QApplication::ColorSpec::NormalColor))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QAPPLICATION_COLORSPEC_IDX],
        Sbk_QApplication_TypeF(), "CustomColor", (long) QApplication::ColorSpec::CustomColor))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QAPPLICATION_COLORSPEC_IDX],
        Sbk_QApplication_TypeF(), "ManyColor", (long) QApplication::ColorSpec::ManyColor))
        return;
    // Register converter for enum 'QApplication::ColorSpec'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QAPPLICATION_COLORSPEC_IDX],
            QApplication_ColorSpec_CppToPython_QApplication_ColorSpec);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QApplication_ColorSpec_PythonToCpp_QApplication_ColorSpec,
            is_QApplication_ColorSpec_PythonToCpp_QApplication_ColorSpec_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QAPPLICATION_COLORSPEC_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QApplication::ColorSpec");
        Shiboken::Conversions::registerConverterName(converter, "ColorSpec");
    }
    // End of 'ColorSpec' enum.

    PySide::Signal::registerSignals(Sbk_QApplication_TypeF(), &::QApplication::staticMetaObject);

    qRegisterMetaType< ::QApplication::ColorSpec >("QApplication::ColorSpec");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QApplication_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QApplication_TypeF(), &::QApplication::staticMetaObject, sizeof(QApplicationWrapper));
}

