/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtwidgets_python.h"

// main header
#include "qcolormap_wrapper.h"

// inner classes

// Extra includes
#include <QVector>
#include <QtGui/qcolor.h>
#include <QtWidgets/qcolormap.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QColormap_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QColormap >()))
        return -1;

    ::QColormap *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QColormap.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QColormap", 1, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QColormap::QColormap(QColormap)
    if (numArgs == 1
        && (pyArgs[0] != Py_None && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QCOLORMAP_IDX]), (pyArgs[0]))))) {
        overloadId = 0; // QColormap(QColormap)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QColormap_Init_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QColormap *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QColormap(QColormap)
            cptr = new ::QColormap(*cppArg0);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QColormap >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QColormap_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QColormap_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QColormapFunc_cleanup(PyObject *self)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QColormap.cleanup";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // cleanup()
            ::QColormap::cleanup();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QColormapFunc_colorAt(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColormap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QCOLORMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QColormap.colorAt";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QColormap::colorAt(uint)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArg)))) {
        overloadId = 0; // colorAt(uint)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QColormapFunc_colorAt_TypeError;

    // Call function/method
    {
        uint cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // colorAt(uint)const
            const QColor cppResult = const_cast<const ::QColormap *>(cppSelf)->colorAt(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QColormapFunc_colorAt_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QColormapFunc_colormap(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColormap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QCOLORMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QColormap.colormap";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // colormap()const
            const QVector<QColor > cppResult = const_cast<const ::QColormap *>(cppSelf)->colormap();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QVECTOR_QCOLOR_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QColormapFunc_depth(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColormap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QCOLORMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QColormap.depth";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // depth()const
            int cppResult = const_cast<const ::QColormap *>(cppSelf)->depth();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QColormapFunc_initialize(PyObject *self)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QColormap.initialize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // initialize()
            ::QColormap::initialize();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QColormapFunc_instance(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QColormap.instance";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QColormapFunc_instance_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:instance", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: static QColormap::instance(int)
    if (numArgs == 0) {
        overloadId = 0; // instance(int)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 0; // instance(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QColormapFunc_instance_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_screen = Shiboken::String::createStaticString("screen");
            if (PyDict_Contains(kwds, key_screen)) {
                value = PyDict_GetItem(kwds, key_screen);
                if (value && pyArgs[0]) {
                    errInfo = key_screen;
                    Py_INCREF(errInfo);
                    goto Sbk_QColormapFunc_instance_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                        goto Sbk_QColormapFunc_instance_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_screen);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QColormapFunc_instance_TypeError;
            }
        }
        int cppArg0 = -1;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // instance(int)
            QColormap cppResult = ::QColormap::instance(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QCOLORMAP_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QColormapFunc_instance_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QColormapFunc_mode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColormap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QCOLORMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QColormap.mode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // mode()const
            QColormap::Mode cppResult = const_cast<const ::QColormap *>(cppSelf)->mode();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QCOLORMAP_MODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QColormapFunc_pixel(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColormap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QCOLORMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QColormap.pixel";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QColormap::pixel(QColor)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArg)))) {
        overloadId = 0; // pixel(QColor)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QColormapFunc_pixel_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QColor cppArg0_local;
        ::QColor *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // pixel(QColor)const
            uint cppResult = const_cast<const ::QColormap *>(cppSelf)->pixel(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QColormapFunc_pixel_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QColormapFunc_size(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QColormap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QCOLORMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QColormap.size";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // size()const
            int cppResult = const_cast<const ::QColormap *>(cppSelf)->size();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QColormap___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QColormap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QCOLORMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QCOLORMAP_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QColormap_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QColormap_methods[] = {
    {"cleanup", reinterpret_cast<PyCFunction>(Sbk_QColormapFunc_cleanup), METH_NOARGS|METH_STATIC},
    {"colorAt", reinterpret_cast<PyCFunction>(Sbk_QColormapFunc_colorAt), METH_O},
    {"colormap", reinterpret_cast<PyCFunction>(Sbk_QColormapFunc_colormap), METH_NOARGS},
    {"depth", reinterpret_cast<PyCFunction>(Sbk_QColormapFunc_depth), METH_NOARGS},
    {"initialize", reinterpret_cast<PyCFunction>(Sbk_QColormapFunc_initialize), METH_NOARGS|METH_STATIC},
    {"instance", reinterpret_cast<PyCFunction>(Sbk_QColormapFunc_instance), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"mode", reinterpret_cast<PyCFunction>(Sbk_QColormapFunc_mode), METH_NOARGS},
    {"pixel", reinterpret_cast<PyCFunction>(Sbk_QColormapFunc_pixel), METH_O},
    {"size", reinterpret_cast<PyCFunction>(Sbk_QColormapFunc_size), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QColormap___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QColormap_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QColormap_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QColormap_Type = nullptr;
static SbkObjectType *Sbk_QColormap_TypeF(void)
{
    return _Sbk_QColormap_Type;
}

static PyType_Slot Sbk_QColormap_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QColormap_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QColormap_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QColormap_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QColormap_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QColormap_spec = {
    "2:PySide2.QtWidgets.QColormap",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QColormap_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QColormap_Mode_PythonToCpp_QColormap_Mode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QColormap::Mode *>(cppOut) =
        static_cast<::QColormap::Mode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QColormap_Mode_PythonToCpp_QColormap_Mode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QCOLORMAP_MODE_IDX]))
        return QColormap_Mode_PythonToCpp_QColormap_Mode;
    return {};
}
static PyObject *QColormap_Mode_CppToPython_QColormap_Mode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QColormap::Mode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QCOLORMAP_MODE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QColormap_PythonToCpp_QColormap_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QColormap_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QColormap_PythonToCpp_QColormap_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QColormap_TypeF())))
        return QColormap_PythonToCpp_QColormap_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QColormap_PTR_CppToPython_QColormap(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QColormap *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QColormap_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QColormap_COPY_CppToPython_QColormap(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QColormap_TypeF(), new ::QColormap(*reinterpret_cast<const ::QColormap *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QColormap_PythonToCpp_QColormap_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QColormap *>(cppOut) = *reinterpret_cast< ::QColormap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QCOLORMAP_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QColormap_PythonToCpp_QColormap_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QColormap_TypeF())))
        return QColormap_PythonToCpp_QColormap_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QColormap_SignatureStrings[] = {
    "PySide2.QtWidgets.QColormap(self,colormap:PySide2.QtWidgets.QColormap)",
    "PySide2.QtWidgets.QColormap.cleanup()",
    "PySide2.QtWidgets.QColormap.colorAt(self,pixel:uint)->PySide2.QtGui.QColor",
    "PySide2.QtWidgets.QColormap.colormap(self)->QVector[PySide2.QtGui.QColor]",
    "PySide2.QtWidgets.QColormap.depth(self)->int",
    "PySide2.QtWidgets.QColormap.initialize()",
    "PySide2.QtWidgets.QColormap.instance(screen:int=-1)->PySide2.QtWidgets.QColormap",
    "PySide2.QtWidgets.QColormap.mode(self)->PySide2.QtWidgets.QColormap.Mode",
    "PySide2.QtWidgets.QColormap.pixel(self,color:PySide2.QtGui.QColor)->uint",
    "PySide2.QtWidgets.QColormap.size(self)->int",
    "PySide2.QtWidgets.QColormap.__copy__()",
    nullptr}; // Sentinel

void init_QColormap(PyObject *module)
{
    _Sbk_QColormap_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QColormap",
        "QColormap",
        &Sbk_QColormap_spec,
        &Shiboken::callCppDestructor< ::QColormap >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QColormap_Type);
    InitSignatureStrings(pyType, QColormap_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QColormap_Type), Sbk_QColormap_PropertyStrings);
    SbkPySide2_QtWidgetsTypes[SBK_QCOLORMAP_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QColormap_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QColormap_TypeF(),
        QColormap_PythonToCpp_QColormap_PTR,
        is_QColormap_PythonToCpp_QColormap_PTR_Convertible,
        QColormap_PTR_CppToPython_QColormap,
        QColormap_COPY_CppToPython_QColormap);

    Shiboken::Conversions::registerConverterName(converter, "QColormap");
    Shiboken::Conversions::registerConverterName(converter, "QColormap*");
    Shiboken::Conversions::registerConverterName(converter, "QColormap&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QColormap).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QColormap_PythonToCpp_QColormap_COPY,
        is_QColormap_PythonToCpp_QColormap_COPY_Convertible);

    // Initialization of enums.

    // Initialization of enum 'Mode'.
    SbkPySide2_QtWidgetsTypes[SBK_QCOLORMAP_MODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QColormap_TypeF(),
        "Mode",
        "2:PySide2.QtWidgets.QColormap.Mode",
        "QColormap::Mode");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QCOLORMAP_MODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QCOLORMAP_MODE_IDX],
        Sbk_QColormap_TypeF(), "Direct", (long) QColormap::Mode::Direct))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QCOLORMAP_MODE_IDX],
        Sbk_QColormap_TypeF(), "Indexed", (long) QColormap::Mode::Indexed))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QCOLORMAP_MODE_IDX],
        Sbk_QColormap_TypeF(), "Gray", (long) QColormap::Mode::Gray))
        return;
    // Register converter for enum 'QColormap::Mode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QCOLORMAP_MODE_IDX],
            QColormap_Mode_CppToPython_QColormap_Mode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QColormap_Mode_PythonToCpp_QColormap_Mode,
            is_QColormap_Mode_PythonToCpp_QColormap_Mode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QCOLORMAP_MODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QColormap::Mode");
        Shiboken::Conversions::registerConverterName(converter, "Mode");
    }
    // End of 'Mode' enum.

    qRegisterMetaType< ::QColormap::Mode >("QColormap::Mode");
}
