/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtwidgets_python.h"

// main header
#include "qgraphicsblureffect_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QGraphicsBlurEffectWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QGraphicsBlurEffectWrapper::QGraphicsBlurEffectWrapper(::QObject * parent) : QGraphicsBlurEffect(parent)
{
    resetPyMethodCache();
    // ... middle
}

::QRectF QGraphicsBlurEffectWrapper::boundingRectFor(const ::QRectF & rect) const
{
    if (m_PyMethodCache[0])
        return this->::QGraphicsBlurEffect::boundingRectFor(rect);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "boundingRectFor";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QGraphicsBlurEffect::boundingRectFor(rect);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &rect)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGraphicsBlurEffect.boundingRectFor", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QRectF >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QRectF cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QGraphicsBlurEffectWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QGraphicsBlurEffectWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QGraphicsBlurEffectWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QGraphicsBlurEffectWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[4]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QGraphicsBlurEffectWrapper::draw(::QPainter * painter)
{
    if (m_PyMethodCache[5]) {
        return this->::QGraphicsBlurEffect::draw(painter);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "draw";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QGraphicsBlurEffect::draw(painter);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX]), painter)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QGraphicsBlurEffectWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[6])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGraphicsBlurEffect.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QGraphicsBlurEffectWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[7])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGraphicsBlurEffect.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QGraphicsBlurEffectWrapper::sourceChanged(::QFlags<QGraphicsEffect::ChangeFlag> flags)
{
    if (m_PyMethodCache[9]) {
        return this->::QGraphicsEffect::sourceChanged(flags);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "sourceChanged";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[9] = true;
        return this->::QGraphicsEffect::sourceChanged(flags);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QGRAPHICSEFFECT_CHANGEFLAG_IDX])->converter, &flags)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QGraphicsBlurEffectWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[10]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[10] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QGraphicsBlurEffectWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QGraphicsBlurEffect::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QGraphicsBlurEffectWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QGraphicsBlurEffect::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QGraphicsBlurEffectWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QGraphicsBlurEffectWrapper *>(this));
        return QGraphicsBlurEffect::qt_metacast(_clname);
}

QGraphicsBlurEffectWrapper::~QGraphicsBlurEffectWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QGraphicsBlurEffect_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QGraphicsBlurEffect >()))
        return -1;

    ::QGraphicsBlurEffectWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsBlurEffect.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|O:QGraphicsBlurEffect", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QGraphicsBlurEffect::QGraphicsBlurEffect(QObject*)
    if (numArgs == 0) {
        overloadId = 0; // QGraphicsBlurEffect(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QGraphicsBlurEffect(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsBlurEffect_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[0]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_QGraphicsBlurEffect_Init_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                        goto Sbk_QGraphicsBlurEffect_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                // fall through to handle extra keyword signals and properties
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QGraphicsBlurEffect(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QGraphicsBlurEffectWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QGraphicsBlurEffectWrapper(cppArg0);
            }

            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QGraphicsBlurEffect >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QGraphicsBlurEffect_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QGraphicsBlurEffect_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QGraphicsBlurEffect_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QGraphicsBlurEffectFunc_blurHints(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsBlurEffect *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSBLUREFFECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsBlurEffect.blurHints";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // blurHints()const
            QFlags<QGraphicsBlurEffect::BlurHint> cppResult = const_cast<const ::QGraphicsBlurEffect *>(cppSelf)->blurHints();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QGRAPHICSBLUREFFECT_BLURHINT_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGraphicsBlurEffectFunc_blurRadius(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsBlurEffect *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSBLUREFFECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsBlurEffect.blurRadius";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // blurRadius()const
            qreal cppResult = const_cast<const ::QGraphicsBlurEffect *>(cppSelf)->blurRadius();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGraphicsBlurEffectFunc_boundingRectFor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsBlurEffect *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSBLUREFFECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsBlurEffect.boundingRectFor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsEffect::boundingRectFor(QRectF)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArg)))) {
        overloadId = 0; // boundingRectFor(QRectF)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsBlurEffectFunc_boundingRectFor_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QRectF cppArg0_local;
        ::QRectF *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // boundingRectFor(QRectF)const
            QRectF cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QGraphicsBlurEffect *>(cppSelf)->::QGraphicsBlurEffect::boundingRectFor(*cppArg0)
                : const_cast<const ::QGraphicsBlurEffect *>(cppSelf)->boundingRectFor(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGraphicsBlurEffectFunc_boundingRectFor_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsBlurEffectFunc_draw(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsBlurEffect *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSBLUREFFECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsBlurEffect.draw";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsEffect::draw(QPainter*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX]), (pyArg)))) {
        overloadId = 0; // draw(QPainter*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsBlurEffectFunc_draw_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPainter *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // draw(QPainter*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QGraphicsBlurEffect::draw(cppArg0)
                : cppSelf->draw(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsBlurEffectFunc_draw_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsBlurEffectFunc_setBlurHints(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsBlurEffect *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSBLUREFFECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsBlurEffect.setBlurHints";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsBlurEffect::setBlurHints(QFlags<QGraphicsBlurEffect::BlurHint>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QGRAPHICSBLUREFFECT_BLURHINT_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setBlurHints(QFlags<QGraphicsBlurEffect::BlurHint>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsBlurEffectFunc_setBlurHints_TypeError;

    // Call function/method
    {
        ::QFlags<QGraphicsBlurEffect::BlurHint> cppArg0 = QFlags<QGraphicsBlurEffect::BlurHint>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setBlurHints(QFlags<QGraphicsBlurEffect::BlurHint>)
            cppSelf->setBlurHints(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsBlurEffectFunc_setBlurHints_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsBlurEffectFunc_setBlurRadius(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsBlurEffect *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSBLUREFFECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsBlurEffect.setBlurRadius";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsBlurEffect::setBlurRadius(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setBlurRadius(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsBlurEffectFunc_setBlurRadius_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setBlurRadius(qreal)
            cppSelf->setBlurRadius(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsBlurEffectFunc_setBlurRadius_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QGraphicsBlurEffect_PropertyStrings[] = {
    "blurHints::",
    "blurRadius::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QGraphicsBlurEffect_methods[] = {
    {"blurHints", reinterpret_cast<PyCFunction>(Sbk_QGraphicsBlurEffectFunc_blurHints), METH_NOARGS},
    {"blurRadius", reinterpret_cast<PyCFunction>(Sbk_QGraphicsBlurEffectFunc_blurRadius), METH_NOARGS},
    {"boundingRectFor", reinterpret_cast<PyCFunction>(Sbk_QGraphicsBlurEffectFunc_boundingRectFor), METH_O},
    {"draw", reinterpret_cast<PyCFunction>(Sbk_QGraphicsBlurEffectFunc_draw), METH_O},
    {"setBlurHints", reinterpret_cast<PyCFunction>(Sbk_QGraphicsBlurEffectFunc_setBlurHints), METH_O},
    {"setBlurRadius", reinterpret_cast<PyCFunction>(Sbk_QGraphicsBlurEffectFunc_setBlurRadius), METH_O},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QGraphicsBlurEffect_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QGraphicsBlurEffect *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSBLUREFFECT_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QGraphicsBlurEffectWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QGraphicsBlurEffect_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QGraphicsBlurEffect_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QGraphicsBlurEffect_Type = nullptr;
static SbkObjectType *Sbk_QGraphicsBlurEffect_TypeF(void)
{
    return _Sbk_QGraphicsBlurEffect_Type;
}

static PyType_Slot Sbk_QGraphicsBlurEffect_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QGraphicsBlurEffect_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QGraphicsBlurEffect_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QGraphicsBlurEffect_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QGraphicsBlurEffect_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QGraphicsBlurEffect_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QGraphicsBlurEffect_spec = {
    "2:PySide2.QtWidgets.QGraphicsBlurEffect",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QGraphicsBlurEffect_slots
};

} //extern "C"

static void *Sbk_QGraphicsBlurEffect_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QGraphicsBlurEffect *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}

PyObject *SbkPySide2_QtWidgets_QGraphicsBlurEffect_BlurHint___and__(PyObject *self, PyObject *pyArg)
{
    ::QGraphicsBlurEffect::BlurHints cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QGraphicsBlurEffect::BlurHints>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QGraphicsBlurEffect::BlurHints>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QGraphicsBlurEffect::BlurHints>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QGraphicsBlurEffect::BlurHints>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QGRAPHICSBLUREFFECT_BLURHINT_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtWidgets_QGraphicsBlurEffect_BlurHint___or__(PyObject *self, PyObject *pyArg)
{
    ::QGraphicsBlurEffect::BlurHints cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QGraphicsBlurEffect::BlurHints>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QGraphicsBlurEffect::BlurHints>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QGraphicsBlurEffect::BlurHints>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QGraphicsBlurEffect::BlurHints>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QGRAPHICSBLUREFFECT_BLURHINT_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtWidgets_QGraphicsBlurEffect_BlurHint___xor__(PyObject *self, PyObject *pyArg)
{
    ::QGraphicsBlurEffect::BlurHints cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QGraphicsBlurEffect::BlurHints>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QGraphicsBlurEffect::BlurHints>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QGraphicsBlurEffect::BlurHints>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QGraphicsBlurEffect::BlurHints>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QGRAPHICSBLUREFFECT_BLURHINT_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtWidgets_QGraphicsBlurEffect_BlurHint___invert__(PyObject *self, PyObject *pyArg)
{
    ::QGraphicsBlurEffect::BlurHints cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QGRAPHICSBLUREFFECT_BLURHINT_IDX])->converter, self, &cppSelf);
    ::QGraphicsBlurEffect::BlurHints cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QGRAPHICSBLUREFFECT_BLURHINT_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtWidgets_QGraphicsBlurEffect_BlurHint_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QGRAPHICSBLUREFFECT_BLURHINT_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtWidgets_QGraphicsBlurEffect_BlurHint__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QGRAPHICSBLUREFFECT_BLURHINT_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtWidgets_QGraphicsBlurEffect_BlurHint_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtWidgets_QGraphicsBlurEffect_BlurHint__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtWidgets_QGraphicsBlurEffect_BlurHint__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtWidgets_QGraphicsBlurEffect_BlurHint_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtWidgets_QGraphicsBlurEffect_BlurHint___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtWidgets_QGraphicsBlurEffect_BlurHint___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtWidgets_QGraphicsBlurEffect_BlurHint___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtWidgets_QGraphicsBlurEffect_BlurHint___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtWidgets_QGraphicsBlurEffect_BlurHint_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtWidgets_QGraphicsBlurEffect_BlurHint_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtWidgets_QGraphicsBlurEffect_BlurHint_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QGraphicsBlurEffect_BlurHint_PythonToCpp_QGraphicsBlurEffect_BlurHint(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QGraphicsBlurEffect::BlurHint *>(cppOut) =
        static_cast<::QGraphicsBlurEffect::BlurHint>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QGraphicsBlurEffect_BlurHint_PythonToCpp_QGraphicsBlurEffect_BlurHint_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSBLUREFFECT_BLURHINT_IDX]))
        return QGraphicsBlurEffect_BlurHint_PythonToCpp_QGraphicsBlurEffect_BlurHint;
    return {};
}
static PyObject *QGraphicsBlurEffect_BlurHint_CppToPython_QGraphicsBlurEffect_BlurHint(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QGraphicsBlurEffect::BlurHint *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSBLUREFFECT_BLURHINT_IDX], castCppIn);

}

static void QFlags_QGraphicsBlurEffect_BlurHint__PythonToCpp_QFlags_QGraphicsBlurEffect_BlurHint_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QGraphicsBlurEffect::BlurHint> *>(cppOut) =
        ::QFlags<QGraphicsBlurEffect::BlurHint>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QGraphicsBlurEffect_BlurHint__PythonToCpp_QFlags_QGraphicsBlurEffect_BlurHint__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QGRAPHICSBLUREFFECT_BLURHINT_IDX]))
        return QFlags_QGraphicsBlurEffect_BlurHint__PythonToCpp_QFlags_QGraphicsBlurEffect_BlurHint_;
    return {};
}
static PyObject *QFlags_QGraphicsBlurEffect_BlurHint__CppToPython_QFlags_QGraphicsBlurEffect_BlurHint_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QGraphicsBlurEffect::BlurHint> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QGRAPHICSBLUREFFECT_BLURHINT_IDX]));

}

static void QGraphicsBlurEffect_BlurHint_PythonToCpp_QFlags_QGraphicsBlurEffect_BlurHint_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QGraphicsBlurEffect::BlurHint> *>(cppOut) =
        ::QFlags<QGraphicsBlurEffect::BlurHint>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QGraphicsBlurEffect_BlurHint_PythonToCpp_QFlags_QGraphicsBlurEffect_BlurHint__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSBLUREFFECT_BLURHINT_IDX]))
        return QGraphicsBlurEffect_BlurHint_PythonToCpp_QFlags_QGraphicsBlurEffect_BlurHint_;
    return {};
}
static void number_PythonToCpp_QFlags_QGraphicsBlurEffect_BlurHint_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QGraphicsBlurEffect::BlurHint> *>(cppOut) =
        ::QFlags<QGraphicsBlurEffect::BlurHint>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QGraphicsBlurEffect_BlurHint__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSBLUREFFECT_BLURHINT_IDX]))
        return number_PythonToCpp_QFlags_QGraphicsBlurEffect_BlurHint_;
    return {};
}
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QGraphicsBlurEffect_PythonToCpp_QGraphicsBlurEffect_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QGraphicsBlurEffect_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QGraphicsBlurEffect_PythonToCpp_QGraphicsBlurEffect_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QGraphicsBlurEffect_TypeF())))
        return QGraphicsBlurEffect_PythonToCpp_QGraphicsBlurEffect_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QGraphicsBlurEffect_PTR_CppToPython_QGraphicsBlurEffect(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QGraphicsBlurEffect *>(const_cast<void *>(cppIn)), Sbk_QGraphicsBlurEffect_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QGraphicsBlurEffect_SignatureStrings[] = {
    "PySide2.QtWidgets.QGraphicsBlurEffect(self,parent:PySide2.QtCore.QObject=nullptr)",
    "PySide2.QtWidgets.QGraphicsBlurEffect.blurHints(self)->PySide2.QtWidgets.QGraphicsBlurEffect.BlurHints",
    "PySide2.QtWidgets.QGraphicsBlurEffect.blurRadius(self)->qreal",
    "PySide2.QtWidgets.QGraphicsBlurEffect.boundingRectFor(self,rect:PySide2.QtCore.QRectF)->PySide2.QtCore.QRectF",
    "PySide2.QtWidgets.QGraphicsBlurEffect.draw(self,painter:PySide2.QtGui.QPainter)",
    "PySide2.QtWidgets.QGraphicsBlurEffect.setBlurHints(self,hints:PySide2.QtWidgets.QGraphicsBlurEffect.BlurHints)",
    "PySide2.QtWidgets.QGraphicsBlurEffect.setBlurRadius(self,blurRadius:qreal)",
    nullptr}; // Sentinel

void init_QGraphicsBlurEffect(PyObject *module)
{
    _Sbk_QGraphicsBlurEffect_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QGraphicsBlurEffect",
        "QGraphicsBlurEffect*",
        &Sbk_QGraphicsBlurEffect_spec,
        &Shiboken::callCppDestructor< ::QGraphicsBlurEffect >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSEFFECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QGraphicsBlurEffect_Type);
    InitSignatureStrings(pyType, QGraphicsBlurEffect_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QGraphicsBlurEffect_Type), Sbk_QGraphicsBlurEffect_PropertyStrings);
    SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSBLUREFFECT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QGraphicsBlurEffect_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QGraphicsBlurEffect_TypeF(),
        QGraphicsBlurEffect_PythonToCpp_QGraphicsBlurEffect_PTR,
        is_QGraphicsBlurEffect_PythonToCpp_QGraphicsBlurEffect_PTR_Convertible,
        QGraphicsBlurEffect_PTR_CppToPython_QGraphicsBlurEffect);

    Shiboken::Conversions::registerConverterName(converter, "QGraphicsBlurEffect");
    Shiboken::Conversions::registerConverterName(converter, "QGraphicsBlurEffect*");
    Shiboken::Conversions::registerConverterName(converter, "QGraphicsBlurEffect&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QGraphicsBlurEffect).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QGraphicsBlurEffectWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QGraphicsBlurEffect_TypeF(), &Sbk_QGraphicsBlurEffect_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'BlurHint'.
    SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QGRAPHICSBLUREFFECT_BLURHINT_IDX] = PySide::QFlags::create("2:PySide2.QtWidgets.QGraphicsBlurEffect.BlurHints", SbkPySide2_QtWidgets_QGraphicsBlurEffect_BlurHint_number_slots);
    SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSBLUREFFECT_BLURHINT_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QGraphicsBlurEffect_TypeF(),
        "BlurHint",
        "2:PySide2.QtWidgets.QGraphicsBlurEffect.BlurHint",
        "QGraphicsBlurEffect::BlurHint",
        SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QGRAPHICSBLUREFFECT_BLURHINT_IDX]);
    if (!SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSBLUREFFECT_BLURHINT_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSBLUREFFECT_BLURHINT_IDX],
        Sbk_QGraphicsBlurEffect_TypeF(), "PerformanceHint", (long) QGraphicsBlurEffect::BlurHint::PerformanceHint))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSBLUREFFECT_BLURHINT_IDX],
        Sbk_QGraphicsBlurEffect_TypeF(), "QualityHint", (long) QGraphicsBlurEffect::BlurHint::QualityHint))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSBLUREFFECT_BLURHINT_IDX],
        Sbk_QGraphicsBlurEffect_TypeF(), "AnimationHint", (long) QGraphicsBlurEffect::BlurHint::AnimationHint))
        return;
    // Register converter for enum 'QGraphicsBlurEffect::BlurHint'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSBLUREFFECT_BLURHINT_IDX],
            QGraphicsBlurEffect_BlurHint_CppToPython_QGraphicsBlurEffect_BlurHint);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QGraphicsBlurEffect_BlurHint_PythonToCpp_QGraphicsBlurEffect_BlurHint,
            is_QGraphicsBlurEffect_BlurHint_PythonToCpp_QGraphicsBlurEffect_BlurHint_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSBLUREFFECT_BLURHINT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QGraphicsBlurEffect::BlurHint");
        Shiboken::Conversions::registerConverterName(converter, "BlurHint");
    }
    // Register converter for flag 'QFlags<QGraphicsBlurEffect::BlurHint>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QGRAPHICSBLUREFFECT_BLURHINT_IDX],
            QFlags_QGraphicsBlurEffect_BlurHint__CppToPython_QFlags_QGraphicsBlurEffect_BlurHint_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QGraphicsBlurEffect_BlurHint_PythonToCpp_QFlags_QGraphicsBlurEffect_BlurHint_,
            is_QGraphicsBlurEffect_BlurHint_PythonToCpp_QFlags_QGraphicsBlurEffect_BlurHint__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QGraphicsBlurEffect_BlurHint__PythonToCpp_QFlags_QGraphicsBlurEffect_BlurHint_,
            is_QFlags_QGraphicsBlurEffect_BlurHint__PythonToCpp_QFlags_QGraphicsBlurEffect_BlurHint__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QGraphicsBlurEffect_BlurHint_,
            is_number_PythonToCpp_QFlags_QGraphicsBlurEffect_BlurHint__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QGRAPHICSBLUREFFECT_BLURHINT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QGraphicsBlurEffect::BlurHints");
        Shiboken::Conversions::registerConverterName(converter, "BlurHints");
    }
    // End of 'BlurHint' enum/flags.

    PySide::Signal::registerSignals(Sbk_QGraphicsBlurEffect_TypeF(), &::QGraphicsBlurEffect::staticMetaObject);
    qRegisterMetaType< ::QGraphicsBlurEffect::BlurHint >("QGraphicsBlurEffect::BlurHint");
    qRegisterMetaType< ::QGraphicsBlurEffect::BlurHints >("QGraphicsBlurEffect::BlurHints");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QGraphicsBlurEffect_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QGraphicsBlurEffect_TypeF(), &::QGraphicsBlurEffect::staticMetaObject, sizeof(QGraphicsBlurEffectWrapper));
}
