/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtwidgets_python.h"

// main header
#include "qgraphicseffect_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QGraphicsEffectWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QGraphicsEffectWrapper::QGraphicsEffectWrapper(::QObject * parent) : QGraphicsEffect(parent)
{
    resetPyMethodCache();
    // ... middle
}

::QRectF QGraphicsEffectWrapper::boundingRectFor(const ::QRectF & sourceRect) const
{
    if (m_PyMethodCache[0])
        return this->::QGraphicsEffect::boundingRectFor(sourceRect);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "boundingRectFor";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QGraphicsEffect::boundingRectFor(sourceRect);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &sourceRect)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGraphicsEffect.boundingRectFor", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QRectF >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QRectF cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QGraphicsEffectWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QGraphicsEffectWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QGraphicsEffectWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QGraphicsEffectWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[4]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QGraphicsEffectWrapper::draw(::QPainter * painter)
{
    if (m_PyMethodCache[5]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGraphicsEffect.draw()' not implemented.");
        return;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "draw";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGraphicsEffect.draw()' not implemented.");
        return;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX]), painter)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QGraphicsEffectWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[6])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGraphicsEffect.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QGraphicsEffectWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[7])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGraphicsEffect.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QGraphicsEffectWrapper::sourceChanged(::QFlags<QGraphicsEffect::ChangeFlag> flags)
{
    if (m_PyMethodCache[9]) {
        return this->::QGraphicsEffect::sourceChanged(flags);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "sourceChanged";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[9] = true;
        return this->::QGraphicsEffect::sourceChanged(flags);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QGRAPHICSEFFECT_CHANGEFLAG_IDX])->converter, &flags)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QGraphicsEffectWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[10]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[10] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QGraphicsEffectWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QGraphicsEffect::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QGraphicsEffectWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QGraphicsEffect::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QGraphicsEffectWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QGraphicsEffectWrapper *>(this));
        return QGraphicsEffect::qt_metacast(_clname);
}

QGraphicsEffectWrapper::~QGraphicsEffectWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QGraphicsEffect_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
    SbkObjectType *type = reinterpret_cast<SbkObjectType *>(self->ob_type);
    SbkObjectType *myType = reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSEFFECT_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QGraphicsEffect' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QGraphicsEffect >()))
        return -1;

    ::QGraphicsEffectWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsEffect.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|O:QGraphicsEffect", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QGraphicsEffect::QGraphicsEffect(QObject*)
    if (numArgs == 0) {
        overloadId = 0; // QGraphicsEffect(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QGraphicsEffect(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsEffect_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[0]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_QGraphicsEffect_Init_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                        goto Sbk_QGraphicsEffect_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                // fall through to handle extra keyword signals and properties
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QGraphicsEffect(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QGraphicsEffectWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QGraphicsEffectWrapper(cppArg0);
            }

            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QGraphicsEffect >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QGraphicsEffect_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QGraphicsEffect_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QGraphicsEffect_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QGraphicsEffectFunc_boundingRect(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsEffect *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSEFFECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsEffect.boundingRect";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // boundingRect()const
            QRectF cppResult = const_cast<const ::QGraphicsEffect *>(cppSelf)->boundingRect();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGraphicsEffectFunc_boundingRectFor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsEffect *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSEFFECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsEffect.boundingRectFor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsEffect::boundingRectFor(QRectF)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArg)))) {
        overloadId = 0; // boundingRectFor(QRectF)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsEffectFunc_boundingRectFor_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QRectF cppArg0_local;
        ::QRectF *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // boundingRectFor(QRectF)const
            QRectF cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QGraphicsEffect *>(cppSelf)->::QGraphicsEffect::boundingRectFor(*cppArg0)
                : const_cast<const ::QGraphicsEffect *>(cppSelf)->boundingRectFor(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGraphicsEffectFunc_boundingRectFor_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsEffectFunc_draw(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsEffect *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSEFFECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsEffect.draw";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsEffect::draw(QPainter*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX]), (pyArg)))) {
        overloadId = 0; // draw(QPainter*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsEffectFunc_draw_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPainter *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // draw(QPainter*)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGraphicsEffect.draw()' not implemented.");
                return {};
            }
            cppSelf->draw(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsEffectFunc_draw_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsEffectFunc_drawSource(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsEffect *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSEFFECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsEffect.drawSource";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsEffect::drawSource(QPainter*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX]), (pyArg)))) {
        overloadId = 0; // drawSource(QPainter*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsEffectFunc_drawSource_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPainter *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // drawSource(QPainter*)
            cppSelf->drawSource(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsEffectFunc_drawSource_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsEffectFunc_isEnabled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsEffect *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSEFFECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsEffect.isEnabled";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isEnabled()const
            bool cppResult = const_cast<const ::QGraphicsEffect *>(cppSelf)->isEnabled();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGraphicsEffectFunc_setEnabled(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsEffect *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSEFFECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsEffect.setEnabled";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsEffect::setEnabled(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setEnabled(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsEffectFunc_setEnabled_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setEnabled(bool)
            cppSelf->setEnabled(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsEffectFunc_setEnabled_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsEffectFunc_sourceBoundingRect(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsEffect *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSEFFECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsEffect.sourceBoundingRect";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QGraphicsEffectFunc_sourceBoundingRect_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:sourceBoundingRect", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QGraphicsEffect::sourceBoundingRect(Qt::CoordinateSystem)const
    if (numArgs == 0) {
        overloadId = 0; // sourceBoundingRect(Qt::CoordinateSystem)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_COORDINATESYSTEM_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // sourceBoundingRect(Qt::CoordinateSystem)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsEffectFunc_sourceBoundingRect_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_system = Shiboken::String::createStaticString("system");
            if (PyDict_Contains(kwds, key_system)) {
                value = PyDict_GetItem(kwds, key_system);
                if (value && pyArgs[0]) {
                    errInfo = key_system;
                    Py_INCREF(errInfo);
                    goto Sbk_QGraphicsEffectFunc_sourceBoundingRect_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_COORDINATESYSTEM_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_QGraphicsEffectFunc_sourceBoundingRect_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_system);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QGraphicsEffectFunc_sourceBoundingRect_TypeError;
            }
        }
        ::Qt::CoordinateSystem cppArg0 = Qt::LogicalCoordinates;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // sourceBoundingRect(Qt::CoordinateSystem)const
            QRectF cppResult = const_cast<const ::QGraphicsEffect *>(cppSelf)->sourceBoundingRect(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGraphicsEffectFunc_sourceBoundingRect_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsEffectFunc_sourceChanged(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsEffect *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSEFFECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsEffect.sourceChanged";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsEffect::sourceChanged(QFlags<QGraphicsEffect::ChangeFlag>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QGRAPHICSEFFECT_CHANGEFLAG_IDX])->converter, (pyArg)))) {
        overloadId = 0; // sourceChanged(QFlags<QGraphicsEffect::ChangeFlag>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsEffectFunc_sourceChanged_TypeError;

    // Call function/method
    {
        ::QFlags<QGraphicsEffect::ChangeFlag> cppArg0 = QFlags<QGraphicsEffect::ChangeFlag>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // sourceChanged(QFlags<QGraphicsEffect::ChangeFlag>)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QGraphicsEffect::sourceChanged(cppArg0)
                : cppSelf->sourceChanged(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsEffectFunc_sourceChanged_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsEffectFunc_sourceIsPixmap(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsEffect *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSEFFECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsEffect.sourceIsPixmap";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // sourceIsPixmap()const
            bool cppResult = const_cast<const ::QGraphicsEffect *>(cppSelf)->sourceIsPixmap();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGraphicsEffectFunc_sourcePixmap(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsEffect *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSEFFECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsEffect.sourcePixmap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QGraphicsEffectFunc_sourcePixmap_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:sourcePixmap", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QGraphicsEffect::sourcePixmap(Qt::CoordinateSystem,QPoint*,QGraphicsEffect::PixmapPadMode)const
    if (numArgs == 0) {
        overloadId = 0; // sourcePixmap(Qt::CoordinateSystem,QPoint*,QGraphicsEffect::PixmapPadMode)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_COORDINATESYSTEM_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // sourcePixmap(Qt::CoordinateSystem,QPoint*,QGraphicsEffect::PixmapPadMode)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // sourcePixmap(Qt::CoordinateSystem,QPoint*,QGraphicsEffect::PixmapPadMode)const
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSEFFECT_PIXMAPPADMODE_IDX])->converter, (pyArgs[2])))) {
                overloadId = 0; // sourcePixmap(Qt::CoordinateSystem,QPoint*,QGraphicsEffect::PixmapPadMode)const
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsEffectFunc_sourcePixmap_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_system = Shiboken::String::createStaticString("system");
            if (PyDict_Contains(kwds, key_system)) {
                value = PyDict_GetItem(kwds, key_system);
                if (value && pyArgs[0]) {
                    errInfo = key_system;
                    Py_INCREF(errInfo);
                    goto Sbk_QGraphicsEffectFunc_sourcePixmap_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_COORDINATESYSTEM_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_QGraphicsEffectFunc_sourcePixmap_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_system);
            }
            static PyObject *const key_offset = Shiboken::String::createStaticString("offset");
            if (PyDict_Contains(kwds, key_offset)) {
                value = PyDict_GetItem(kwds, key_offset);
                if (value && pyArgs[1]) {
                    errInfo = key_offset;
                    Py_INCREF(errInfo);
                    goto Sbk_QGraphicsEffectFunc_sourcePixmap_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[1]))))
                        goto Sbk_QGraphicsEffectFunc_sourcePixmap_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_offset);
            }
            static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
            if (PyDict_Contains(kwds, key_mode)) {
                value = PyDict_GetItem(kwds, key_mode);
                if (value && pyArgs[2]) {
                    errInfo = key_mode;
                    Py_INCREF(errInfo);
                    goto Sbk_QGraphicsEffectFunc_sourcePixmap_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSEFFECT_PIXMAPPADMODE_IDX])->converter, (pyArgs[2]))))
                        goto Sbk_QGraphicsEffectFunc_sourcePixmap_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_mode);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QGraphicsEffectFunc_sourcePixmap_TypeError;
            }
        }
        ::Qt::CoordinateSystem cppArg0 = Qt::LogicalCoordinates;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QPoint *cppArg1 = nullptr;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QGraphicsEffect::PixmapPadMode cppArg2 = QGraphicsEffect::PixmapPadMode::PadToEffectiveBoundingRect;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // sourcePixmap(Qt::CoordinateSystem,QPoint*,QGraphicsEffect::PixmapPadMode)const
            QPixmap cppResult = const_cast<const ::QGraphicsEffect *>(cppSelf)->sourcePixmap(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGraphicsEffectFunc_sourcePixmap_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsEffectFunc_update(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsEffect *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSEFFECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsEffect.update";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // update()
            cppSelf->update();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QGraphicsEffectFunc_updateBoundingRect(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsEffect *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSEFFECT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsEffect.updateBoundingRect";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // updateBoundingRect()
            cppSelf->updateBoundingRect();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}


static const char *Sbk_QGraphicsEffect_PropertyStrings[] = {
    "enabled:isEnabled:",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QGraphicsEffect_methods[] = {
    {"boundingRect", reinterpret_cast<PyCFunction>(Sbk_QGraphicsEffectFunc_boundingRect), METH_NOARGS},
    {"boundingRectFor", reinterpret_cast<PyCFunction>(Sbk_QGraphicsEffectFunc_boundingRectFor), METH_O},
    {"draw", reinterpret_cast<PyCFunction>(Sbk_QGraphicsEffectFunc_draw), METH_O},
    {"drawSource", reinterpret_cast<PyCFunction>(Sbk_QGraphicsEffectFunc_drawSource), METH_O},
    {"isEnabled", reinterpret_cast<PyCFunction>(Sbk_QGraphicsEffectFunc_isEnabled), METH_NOARGS},
    {"setEnabled", reinterpret_cast<PyCFunction>(Sbk_QGraphicsEffectFunc_setEnabled), METH_O},
    {"sourceBoundingRect", reinterpret_cast<PyCFunction>(Sbk_QGraphicsEffectFunc_sourceBoundingRect), METH_VARARGS|METH_KEYWORDS},
    {"sourceChanged", reinterpret_cast<PyCFunction>(Sbk_QGraphicsEffectFunc_sourceChanged), METH_O},
    {"sourceIsPixmap", reinterpret_cast<PyCFunction>(Sbk_QGraphicsEffectFunc_sourceIsPixmap), METH_NOARGS},
    {"sourcePixmap", reinterpret_cast<PyCFunction>(Sbk_QGraphicsEffectFunc_sourcePixmap), METH_VARARGS|METH_KEYWORDS},
    {"update", reinterpret_cast<PyCFunction>(Sbk_QGraphicsEffectFunc_update), METH_NOARGS},
    {"updateBoundingRect", reinterpret_cast<PyCFunction>(Sbk_QGraphicsEffectFunc_updateBoundingRect), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QGraphicsEffect_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QGraphicsEffect *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSEFFECT_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QGraphicsEffectWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QGraphicsEffect_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QGraphicsEffect_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QGraphicsEffect_Type = nullptr;
static SbkObjectType *Sbk_QGraphicsEffect_TypeF(void)
{
    return _Sbk_QGraphicsEffect_Type;
}

static PyType_Slot Sbk_QGraphicsEffect_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QGraphicsEffect_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QGraphicsEffect_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QGraphicsEffect_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QGraphicsEffect_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QGraphicsEffect_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QGraphicsEffect_spec = {
    "2:PySide2.QtWidgets.QGraphicsEffect",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QGraphicsEffect_slots
};

} //extern "C"

static void *Sbk_QGraphicsEffect_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QGraphicsEffect *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}

PyObject *SbkPySide2_QtWidgets_QGraphicsEffect_ChangeFlag___and__(PyObject *self, PyObject *pyArg)
{
    ::QGraphicsEffect::ChangeFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QGraphicsEffect::ChangeFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QGraphicsEffect::ChangeFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QGraphicsEffect::ChangeFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QGraphicsEffect::ChangeFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QGRAPHICSEFFECT_CHANGEFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtWidgets_QGraphicsEffect_ChangeFlag___or__(PyObject *self, PyObject *pyArg)
{
    ::QGraphicsEffect::ChangeFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QGraphicsEffect::ChangeFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QGraphicsEffect::ChangeFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QGraphicsEffect::ChangeFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QGraphicsEffect::ChangeFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QGRAPHICSEFFECT_CHANGEFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtWidgets_QGraphicsEffect_ChangeFlag___xor__(PyObject *self, PyObject *pyArg)
{
    ::QGraphicsEffect::ChangeFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QGraphicsEffect::ChangeFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QGraphicsEffect::ChangeFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QGraphicsEffect::ChangeFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QGraphicsEffect::ChangeFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QGRAPHICSEFFECT_CHANGEFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtWidgets_QGraphicsEffect_ChangeFlag___invert__(PyObject *self, PyObject *pyArg)
{
    ::QGraphicsEffect::ChangeFlags cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QGRAPHICSEFFECT_CHANGEFLAG_IDX])->converter, self, &cppSelf);
    ::QGraphicsEffect::ChangeFlags cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QGRAPHICSEFFECT_CHANGEFLAG_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtWidgets_QGraphicsEffect_ChangeFlag_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QGRAPHICSEFFECT_CHANGEFLAG_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtWidgets_QGraphicsEffect_ChangeFlag__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QGRAPHICSEFFECT_CHANGEFLAG_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtWidgets_QGraphicsEffect_ChangeFlag_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtWidgets_QGraphicsEffect_ChangeFlag__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtWidgets_QGraphicsEffect_ChangeFlag__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtWidgets_QGraphicsEffect_ChangeFlag_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtWidgets_QGraphicsEffect_ChangeFlag___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtWidgets_QGraphicsEffect_ChangeFlag___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtWidgets_QGraphicsEffect_ChangeFlag___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtWidgets_QGraphicsEffect_ChangeFlag___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtWidgets_QGraphicsEffect_ChangeFlag_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtWidgets_QGraphicsEffect_ChangeFlag_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtWidgets_QGraphicsEffect_ChangeFlag_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QGraphicsEffect_ChangeFlag_PythonToCpp_QGraphicsEffect_ChangeFlag(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QGraphicsEffect::ChangeFlag *>(cppOut) =
        static_cast<::QGraphicsEffect::ChangeFlag>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QGraphicsEffect_ChangeFlag_PythonToCpp_QGraphicsEffect_ChangeFlag_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSEFFECT_CHANGEFLAG_IDX]))
        return QGraphicsEffect_ChangeFlag_PythonToCpp_QGraphicsEffect_ChangeFlag;
    return {};
}
static PyObject *QGraphicsEffect_ChangeFlag_CppToPython_QGraphicsEffect_ChangeFlag(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QGraphicsEffect::ChangeFlag *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSEFFECT_CHANGEFLAG_IDX], castCppIn);

}

static void QFlags_QGraphicsEffect_ChangeFlag__PythonToCpp_QFlags_QGraphicsEffect_ChangeFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QGraphicsEffect::ChangeFlag> *>(cppOut) =
        ::QFlags<QGraphicsEffect::ChangeFlag>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QGraphicsEffect_ChangeFlag__PythonToCpp_QFlags_QGraphicsEffect_ChangeFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QGRAPHICSEFFECT_CHANGEFLAG_IDX]))
        return QFlags_QGraphicsEffect_ChangeFlag__PythonToCpp_QFlags_QGraphicsEffect_ChangeFlag_;
    return {};
}
static PyObject *QFlags_QGraphicsEffect_ChangeFlag__CppToPython_QFlags_QGraphicsEffect_ChangeFlag_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QGraphicsEffect::ChangeFlag> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QGRAPHICSEFFECT_CHANGEFLAG_IDX]));

}

static void QGraphicsEffect_ChangeFlag_PythonToCpp_QFlags_QGraphicsEffect_ChangeFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QGraphicsEffect::ChangeFlag> *>(cppOut) =
        ::QFlags<QGraphicsEffect::ChangeFlag>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QGraphicsEffect_ChangeFlag_PythonToCpp_QFlags_QGraphicsEffect_ChangeFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSEFFECT_CHANGEFLAG_IDX]))
        return QGraphicsEffect_ChangeFlag_PythonToCpp_QFlags_QGraphicsEffect_ChangeFlag_;
    return {};
}
static void number_PythonToCpp_QFlags_QGraphicsEffect_ChangeFlag_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QGraphicsEffect::ChangeFlag> *>(cppOut) =
        ::QFlags<QGraphicsEffect::ChangeFlag>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QGraphicsEffect_ChangeFlag__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSEFFECT_CHANGEFLAG_IDX]))
        return number_PythonToCpp_QFlags_QGraphicsEffect_ChangeFlag_;
    return {};
}
static void QGraphicsEffect_PixmapPadMode_PythonToCpp_QGraphicsEffect_PixmapPadMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QGraphicsEffect::PixmapPadMode *>(cppOut) =
        static_cast<::QGraphicsEffect::PixmapPadMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QGraphicsEffect_PixmapPadMode_PythonToCpp_QGraphicsEffect_PixmapPadMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSEFFECT_PIXMAPPADMODE_IDX]))
        return QGraphicsEffect_PixmapPadMode_PythonToCpp_QGraphicsEffect_PixmapPadMode;
    return {};
}
static PyObject *QGraphicsEffect_PixmapPadMode_CppToPython_QGraphicsEffect_PixmapPadMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QGraphicsEffect::PixmapPadMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSEFFECT_PIXMAPPADMODE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QGraphicsEffect_PythonToCpp_QGraphicsEffect_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QGraphicsEffect_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QGraphicsEffect_PythonToCpp_QGraphicsEffect_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QGraphicsEffect_TypeF())))
        return QGraphicsEffect_PythonToCpp_QGraphicsEffect_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QGraphicsEffect_PTR_CppToPython_QGraphicsEffect(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QGraphicsEffect *>(const_cast<void *>(cppIn)), Sbk_QGraphicsEffect_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QGraphicsEffect_SignatureStrings[] = {
    "PySide2.QtWidgets.QGraphicsEffect(self,parent:PySide2.QtCore.QObject=nullptr)",
    "PySide2.QtWidgets.QGraphicsEffect.boundingRect(self)->PySide2.QtCore.QRectF",
    "PySide2.QtWidgets.QGraphicsEffect.boundingRectFor(self,sourceRect:PySide2.QtCore.QRectF)->PySide2.QtCore.QRectF",
    "PySide2.QtWidgets.QGraphicsEffect.draw(self,painter:PySide2.QtGui.QPainter)",
    "PySide2.QtWidgets.QGraphicsEffect.drawSource(self,painter:PySide2.QtGui.QPainter)",
    "PySide2.QtWidgets.QGraphicsEffect.isEnabled(self)->bool",
    "PySide2.QtWidgets.QGraphicsEffect.setEnabled(self,enable:bool)",
    "PySide2.QtWidgets.QGraphicsEffect.sourceBoundingRect(self,system:PySide2.QtCore.Qt.CoordinateSystem=Qt.LogicalCoordinates)->PySide2.QtCore.QRectF",
    "PySide2.QtWidgets.QGraphicsEffect.sourceChanged(self,flags:PySide2.QtWidgets.QGraphicsEffect.ChangeFlags)",
    "PySide2.QtWidgets.QGraphicsEffect.sourceIsPixmap(self)->bool",
    "PySide2.QtWidgets.QGraphicsEffect.sourcePixmap(self,system:PySide2.QtCore.Qt.CoordinateSystem=Qt.LogicalCoordinates,offset:PySide2.QtCore.QPoint=nullptr,mode:PySide2.QtWidgets.QGraphicsEffect.PixmapPadMode=PadToEffectiveBoundingRect)->PySide2.QtGui.QPixmap",
    "PySide2.QtWidgets.QGraphicsEffect.update(self)",
    "PySide2.QtWidgets.QGraphicsEffect.updateBoundingRect(self)",
    nullptr}; // Sentinel

void init_QGraphicsEffect(PyObject *module)
{
    _Sbk_QGraphicsEffect_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QGraphicsEffect",
        "QGraphicsEffect*",
        &Sbk_QGraphicsEffect_spec,
        &Shiboken::callCppDestructor< ::QGraphicsEffect >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QGraphicsEffect_Type);
    InitSignatureStrings(pyType, QGraphicsEffect_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QGraphicsEffect_Type), Sbk_QGraphicsEffect_PropertyStrings);
    SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSEFFECT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QGraphicsEffect_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QGraphicsEffect_TypeF(),
        QGraphicsEffect_PythonToCpp_QGraphicsEffect_PTR,
        is_QGraphicsEffect_PythonToCpp_QGraphicsEffect_PTR_Convertible,
        QGraphicsEffect_PTR_CppToPython_QGraphicsEffect);

    Shiboken::Conversions::registerConverterName(converter, "QGraphicsEffect");
    Shiboken::Conversions::registerConverterName(converter, "QGraphicsEffect*");
    Shiboken::Conversions::registerConverterName(converter, "QGraphicsEffect&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QGraphicsEffect).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QGraphicsEffectWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QGraphicsEffect_TypeF(), &Sbk_QGraphicsEffect_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'ChangeFlag'.
    SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QGRAPHICSEFFECT_CHANGEFLAG_IDX] = PySide::QFlags::create("2:PySide2.QtWidgets.QGraphicsEffect.ChangeFlags", SbkPySide2_QtWidgets_QGraphicsEffect_ChangeFlag_number_slots);
    SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSEFFECT_CHANGEFLAG_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QGraphicsEffect_TypeF(),
        "ChangeFlag",
        "2:PySide2.QtWidgets.QGraphicsEffect.ChangeFlag",
        "QGraphicsEffect::ChangeFlag",
        SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QGRAPHICSEFFECT_CHANGEFLAG_IDX]);
    if (!SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSEFFECT_CHANGEFLAG_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSEFFECT_CHANGEFLAG_IDX],
        Sbk_QGraphicsEffect_TypeF(), "SourceAttached", (long) QGraphicsEffect::ChangeFlag::SourceAttached))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSEFFECT_CHANGEFLAG_IDX],
        Sbk_QGraphicsEffect_TypeF(), "SourceDetached", (long) QGraphicsEffect::ChangeFlag::SourceDetached))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSEFFECT_CHANGEFLAG_IDX],
        Sbk_QGraphicsEffect_TypeF(), "SourceBoundingRectChanged", (long) QGraphicsEffect::ChangeFlag::SourceBoundingRectChanged))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSEFFECT_CHANGEFLAG_IDX],
        Sbk_QGraphicsEffect_TypeF(), "SourceInvalidated", (long) QGraphicsEffect::ChangeFlag::SourceInvalidated))
        return;
    // Register converter for enum 'QGraphicsEffect::ChangeFlag'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSEFFECT_CHANGEFLAG_IDX],
            QGraphicsEffect_ChangeFlag_CppToPython_QGraphicsEffect_ChangeFlag);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QGraphicsEffect_ChangeFlag_PythonToCpp_QGraphicsEffect_ChangeFlag,
            is_QGraphicsEffect_ChangeFlag_PythonToCpp_QGraphicsEffect_ChangeFlag_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSEFFECT_CHANGEFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QGraphicsEffect::ChangeFlag");
        Shiboken::Conversions::registerConverterName(converter, "ChangeFlag");
    }
    // Register converter for flag 'QFlags<QGraphicsEffect::ChangeFlag>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QGRAPHICSEFFECT_CHANGEFLAG_IDX],
            QFlags_QGraphicsEffect_ChangeFlag__CppToPython_QFlags_QGraphicsEffect_ChangeFlag_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QGraphicsEffect_ChangeFlag_PythonToCpp_QFlags_QGraphicsEffect_ChangeFlag_,
            is_QGraphicsEffect_ChangeFlag_PythonToCpp_QFlags_QGraphicsEffect_ChangeFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QGraphicsEffect_ChangeFlag__PythonToCpp_QFlags_QGraphicsEffect_ChangeFlag_,
            is_QFlags_QGraphicsEffect_ChangeFlag__PythonToCpp_QFlags_QGraphicsEffect_ChangeFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QGraphicsEffect_ChangeFlag_,
            is_number_PythonToCpp_QFlags_QGraphicsEffect_ChangeFlag__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QGRAPHICSEFFECT_CHANGEFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QGraphicsEffect::ChangeFlags");
        Shiboken::Conversions::registerConverterName(converter, "ChangeFlags");
    }
    // End of 'ChangeFlag' enum/flags.

    // Initialization of enum 'PixmapPadMode'.
    SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSEFFECT_PIXMAPPADMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QGraphicsEffect_TypeF(),
        "PixmapPadMode",
        "2:PySide2.QtWidgets.QGraphicsEffect.PixmapPadMode",
        "QGraphicsEffect::PixmapPadMode");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSEFFECT_PIXMAPPADMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSEFFECT_PIXMAPPADMODE_IDX],
        Sbk_QGraphicsEffect_TypeF(), "NoPad", (long) QGraphicsEffect::PixmapPadMode::NoPad))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSEFFECT_PIXMAPPADMODE_IDX],
        Sbk_QGraphicsEffect_TypeF(), "PadToTransparentBorder", (long) QGraphicsEffect::PixmapPadMode::PadToTransparentBorder))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSEFFECT_PIXMAPPADMODE_IDX],
        Sbk_QGraphicsEffect_TypeF(), "PadToEffectiveBoundingRect", (long) QGraphicsEffect::PixmapPadMode::PadToEffectiveBoundingRect))
        return;
    // Register converter for enum 'QGraphicsEffect::PixmapPadMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSEFFECT_PIXMAPPADMODE_IDX],
            QGraphicsEffect_PixmapPadMode_CppToPython_QGraphicsEffect_PixmapPadMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QGraphicsEffect_PixmapPadMode_PythonToCpp_QGraphicsEffect_PixmapPadMode,
            is_QGraphicsEffect_PixmapPadMode_PythonToCpp_QGraphicsEffect_PixmapPadMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSEFFECT_PIXMAPPADMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QGraphicsEffect::PixmapPadMode");
        Shiboken::Conversions::registerConverterName(converter, "PixmapPadMode");
    }
    // End of 'PixmapPadMode' enum.

    PySide::Signal::registerSignals(Sbk_QGraphicsEffect_TypeF(), &::QGraphicsEffect::staticMetaObject);
    qRegisterMetaType< ::QGraphicsEffect::ChangeFlag >("QGraphicsEffect::ChangeFlag");
    qRegisterMetaType< ::QGraphicsEffect::ChangeFlags >("QGraphicsEffect::ChangeFlags");
    qRegisterMetaType< ::QGraphicsEffect::PixmapPadMode >("QGraphicsEffect::PixmapPadMode");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QGraphicsEffect_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QGraphicsEffect_TypeF(), &::QGraphicsEffect::staticMetaObject, sizeof(QGraphicsEffectWrapper));
}
