/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/
#ifndef SBK_QSPACERITEMWRAPPER_H
#define SBK_QSPACERITEMWRAPPER_H

#define protected public

#include <QtWidgets/qlayoutitem.h>


// Extra includes
#include <qsize.h>
#include <qrect.h>
#include <QtWidgets/qlayoutitem.h>
#include <QtWidgets/qsizepolicy.h>
#include <QtWidgets/qwidget.h>
#include <QtWidgets/qlayout.h>
class QSpacerItemWrapper : public QSpacerItem
{
public:
    QSpacerItemWrapper(int w, int h, ::QSizePolicy::Policy hData = QSizePolicy::Minimum, ::QSizePolicy::Policy vData = QSizePolicy::Minimum);
    ::QFlags<QSizePolicy::ControlType> controlTypes() const override;
    ::QFlags<Qt::Orientation> expandingDirections() const override;
    ::QRect geometry() const override;
    bool hasHeightForWidth() const override;
    int heightForWidth(int arg__1) const override;
    void invalidate() override;
    bool isEmpty() const override;
    ::QLayout * layout() override;
    ::QSize maximumSize() const override;
    int minimumHeightForWidth(int arg__1) const override;
    ::QSize minimumSize() const override;
    void setGeometry(const ::QRect & arg__1) override;
    ::QSize sizeHint() const override;
    ::QSpacerItem * spacerItem() override;
    ::QWidget * widget() override;
    ~QSpacerItemWrapper();
    static void pysideInitQtMetaTypes();
    void resetPyMethodCache();
private:
    mutable bool m_PyMethodCache[15];
};

#endif // SBK_QSPACERITEMWRAPPER_H

