/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtwidgets_python.h"

// main header
#include "qstyleoptionframe_wrapper.h"

// inner classes

// Extra includes
#include <QtWidgets/qstyleoption.h>
#include <QtWidgets/qwidget.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QStyleOptionFrame_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QStyleOptionFrame >()))
        return -1;

    ::QStyleOptionFrame *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QStyleOptionFrame.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QStyleOptionFrame", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QStyleOptionFrame::QStyleOptionFrame()
    // 1: QStyleOptionFrame::QStyleOptionFrame(QStyleOptionFrame)
    // 2: QStyleOptionFrame::QStyleOptionFrame(int)
    if (numArgs == 0) {
        overloadId = 0; // QStyleOptionFrame()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 2; // QStyleOptionFrame(int)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONFRAME_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QStyleOptionFrame(QStyleOptionFrame)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStyleOptionFrame_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QStyleOptionFrame()
        {

            if (!PyErr_Occurred()) {
                // QStyleOptionFrame()
                cptr = new ::QStyleOptionFrame();
            }
            break;
        }
        case 1: // QStyleOptionFrame(const QStyleOptionFrame & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QStyleOptionFrame *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QStyleOptionFrame(QStyleOptionFrame)
                cptr = new ::QStyleOptionFrame(*cppArg0);
            }
            break;
        }
        case 2: // QStyleOptionFrame(int version)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QStyleOptionFrame(int)
                cptr = new ::QStyleOptionFrame(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QStyleOptionFrame >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QStyleOptionFrame_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QStyleOptionFrame_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}


static const char *Sbk_QStyleOptionFrame_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QStyleOptionFrame_methods[] = {

    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QStyleOptionFrame_get_lineWidth(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionFrame *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONFRAME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    int cppOut_local = cppSelf->lineWidth;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QStyleOptionFrame_set_lineWidth(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionFrame *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONFRAME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'lineWidth' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'lineWidth', 'int' or convertible type expected");
        return -1;
    }

    int cppOut_local = cppSelf->lineWidth;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->lineWidth = cppOut_local;

    return 0;
}

static PyObject *Sbk_QStyleOptionFrame_get_midLineWidth(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionFrame *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONFRAME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    int cppOut_local = cppSelf->midLineWidth;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QStyleOptionFrame_set_midLineWidth(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionFrame *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONFRAME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'midLineWidth' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'midLineWidth', 'int' or convertible type expected");
        return -1;
    }

    int cppOut_local = cppSelf->midLineWidth;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->midLineWidth = cppOut_local;

    return 0;
}

static PyObject *Sbk_QStyleOptionFrame_get_features(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionFrame *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONFRAME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONFRAME_FRAMEFEATURE_IDX])->converter, &cppSelf->features);
    return pyOut;
}
static int Sbk_QStyleOptionFrame_set_features(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionFrame *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONFRAME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'features' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONFRAME_FRAMEFEATURE_IDX])->converter, (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'features', 'FrameFeatures' or convertible type expected");
        return -1;
    }

    ::QFlags<QStyleOptionFrame::FrameFeature> cppOut_local = cppSelf->features;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->features = cppOut_local;

    return 0;
}

static PyObject *Sbk_QStyleOptionFrame_get_frameShape(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionFrame *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONFRAME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    ::QFrame::Shape cppOut_local = cppSelf->frameShape;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFRAME_SHAPE_IDX])->converter, &cppOut_local);
    return pyOut;
}
static int Sbk_QStyleOptionFrame_set_frameShape(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionFrame *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONFRAME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'frameShape' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFRAME_SHAPE_IDX])->converter, (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'frameShape', 'Shape' or convertible type expected");
        return -1;
    }

    ::QFrame::Shape cppOut_local = cppSelf->frameShape;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->frameShape = cppOut_local;

    return 0;
}

// Getters and Setters for QStyleOptionFrame
static PyGetSetDef Sbk_QStyleOptionFrame_getsetlist[] = {
    {const_cast<char *>("lineWidth"), Sbk_QStyleOptionFrame_get_lineWidth, Sbk_QStyleOptionFrame_set_lineWidth},
    {const_cast<char *>("midLineWidth"), Sbk_QStyleOptionFrame_get_midLineWidth, Sbk_QStyleOptionFrame_set_midLineWidth},
    {const_cast<char *>("features"), Sbk_QStyleOptionFrame_get_features, Sbk_QStyleOptionFrame_set_features},
    {const_cast<char *>("frameShape"), Sbk_QStyleOptionFrame_get_frameShape, Sbk_QStyleOptionFrame_set_frameShape},
    {nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QStyleOptionFrame_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QStyleOptionFrame_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QStyleOptionFrame_Type = nullptr;
static SbkObjectType *Sbk_QStyleOptionFrame_TypeF(void)
{
    return _Sbk_QStyleOptionFrame_Type;
}

static PyType_Slot Sbk_QStyleOptionFrame_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QStyleOptionFrame_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QStyleOptionFrame_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QStyleOptionFrame_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_QStyleOptionFrame_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QStyleOptionFrame_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QStyleOptionFrame_spec = {
    "2:PySide2.QtWidgets.QStyleOptionFrame",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QStyleOptionFrame_slots
};

} //extern "C"

PyObject *SbkPySide2_QtWidgets_QStyleOptionFrame_FrameFeature___and__(PyObject *self, PyObject *pyArg)
{
    ::QStyleOptionFrame::FrameFeatures cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QStyleOptionFrame::FrameFeatures>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QStyleOptionFrame::FrameFeatures>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QStyleOptionFrame::FrameFeatures>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QStyleOptionFrame::FrameFeatures>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONFRAME_FRAMEFEATURE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtWidgets_QStyleOptionFrame_FrameFeature___or__(PyObject *self, PyObject *pyArg)
{
    ::QStyleOptionFrame::FrameFeatures cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QStyleOptionFrame::FrameFeatures>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QStyleOptionFrame::FrameFeatures>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QStyleOptionFrame::FrameFeatures>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QStyleOptionFrame::FrameFeatures>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONFRAME_FRAMEFEATURE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtWidgets_QStyleOptionFrame_FrameFeature___xor__(PyObject *self, PyObject *pyArg)
{
    ::QStyleOptionFrame::FrameFeatures cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QStyleOptionFrame::FrameFeatures>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QStyleOptionFrame::FrameFeatures>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QStyleOptionFrame::FrameFeatures>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QStyleOptionFrame::FrameFeatures>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONFRAME_FRAMEFEATURE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtWidgets_QStyleOptionFrame_FrameFeature___invert__(PyObject *self, PyObject *pyArg)
{
    ::QStyleOptionFrame::FrameFeatures cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONFRAME_FRAMEFEATURE_IDX])->converter, self, &cppSelf);
    ::QStyleOptionFrame::FrameFeatures cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONFRAME_FRAMEFEATURE_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtWidgets_QStyleOptionFrame_FrameFeature_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONFRAME_FRAMEFEATURE_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtWidgets_QStyleOptionFrame_FrameFeature__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONFRAME_FRAMEFEATURE_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtWidgets_QStyleOptionFrame_FrameFeature_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyleOptionFrame_FrameFeature__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyleOptionFrame_FrameFeature__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyleOptionFrame_FrameFeature_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyleOptionFrame_FrameFeature___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyleOptionFrame_FrameFeature___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyleOptionFrame_FrameFeature___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyleOptionFrame_FrameFeature___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyleOptionFrame_FrameFeature_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyleOptionFrame_FrameFeature_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyleOptionFrame_FrameFeature_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QStyleOptionFrame_StyleOptionType_PythonToCpp_QStyleOptionFrame_StyleOptionType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStyleOptionFrame::StyleOptionType *>(cppOut) =
        static_cast<::QStyleOptionFrame::StyleOptionType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QStyleOptionFrame_StyleOptionType_PythonToCpp_QStyleOptionFrame_StyleOptionType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONFRAME_STYLEOPTIONTYPE_IDX]))
        return QStyleOptionFrame_StyleOptionType_PythonToCpp_QStyleOptionFrame_StyleOptionType;
    return {};
}
static PyObject *QStyleOptionFrame_StyleOptionType_CppToPython_QStyleOptionFrame_StyleOptionType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QStyleOptionFrame::StyleOptionType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONFRAME_STYLEOPTIONTYPE_IDX], castCppIn);

}

static void QStyleOptionFrame_StyleOptionVersion_PythonToCpp_QStyleOptionFrame_StyleOptionVersion(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStyleOptionFrame::StyleOptionVersion *>(cppOut) =
        static_cast<::QStyleOptionFrame::StyleOptionVersion>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QStyleOptionFrame_StyleOptionVersion_PythonToCpp_QStyleOptionFrame_StyleOptionVersion_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONFRAME_STYLEOPTIONVERSION_IDX]))
        return QStyleOptionFrame_StyleOptionVersion_PythonToCpp_QStyleOptionFrame_StyleOptionVersion;
    return {};
}
static PyObject *QStyleOptionFrame_StyleOptionVersion_CppToPython_QStyleOptionFrame_StyleOptionVersion(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QStyleOptionFrame::StyleOptionVersion *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONFRAME_STYLEOPTIONVERSION_IDX], castCppIn);

}

static void QStyleOptionFrame_FrameFeature_PythonToCpp_QStyleOptionFrame_FrameFeature(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStyleOptionFrame::FrameFeature *>(cppOut) =
        static_cast<::QStyleOptionFrame::FrameFeature>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QStyleOptionFrame_FrameFeature_PythonToCpp_QStyleOptionFrame_FrameFeature_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONFRAME_FRAMEFEATURE_IDX]))
        return QStyleOptionFrame_FrameFeature_PythonToCpp_QStyleOptionFrame_FrameFeature;
    return {};
}
static PyObject *QStyleOptionFrame_FrameFeature_CppToPython_QStyleOptionFrame_FrameFeature(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QStyleOptionFrame::FrameFeature *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONFRAME_FRAMEFEATURE_IDX], castCppIn);

}

static void QFlags_QStyleOptionFrame_FrameFeature__PythonToCpp_QFlags_QStyleOptionFrame_FrameFeature_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QStyleOptionFrame::FrameFeature> *>(cppOut) =
        ::QFlags<QStyleOptionFrame::FrameFeature>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QStyleOptionFrame_FrameFeature__PythonToCpp_QFlags_QStyleOptionFrame_FrameFeature__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONFRAME_FRAMEFEATURE_IDX]))
        return QFlags_QStyleOptionFrame_FrameFeature__PythonToCpp_QFlags_QStyleOptionFrame_FrameFeature_;
    return {};
}
static PyObject *QFlags_QStyleOptionFrame_FrameFeature__CppToPython_QFlags_QStyleOptionFrame_FrameFeature_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QStyleOptionFrame::FrameFeature> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONFRAME_FRAMEFEATURE_IDX]));

}

static void QStyleOptionFrame_FrameFeature_PythonToCpp_QFlags_QStyleOptionFrame_FrameFeature_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QStyleOptionFrame::FrameFeature> *>(cppOut) =
        ::QFlags<QStyleOptionFrame::FrameFeature>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QStyleOptionFrame_FrameFeature_PythonToCpp_QFlags_QStyleOptionFrame_FrameFeature__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONFRAME_FRAMEFEATURE_IDX]))
        return QStyleOptionFrame_FrameFeature_PythonToCpp_QFlags_QStyleOptionFrame_FrameFeature_;
    return {};
}
static void number_PythonToCpp_QFlags_QStyleOptionFrame_FrameFeature_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QStyleOptionFrame::FrameFeature> *>(cppOut) =
        ::QFlags<QStyleOptionFrame::FrameFeature>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QStyleOptionFrame_FrameFeature__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONFRAME_FRAMEFEATURE_IDX]))
        return number_PythonToCpp_QFlags_QStyleOptionFrame_FrameFeature_;
    return {};
}
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QStyleOptionFrame_PythonToCpp_QStyleOptionFrame_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QStyleOptionFrame_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QStyleOptionFrame_PythonToCpp_QStyleOptionFrame_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QStyleOptionFrame_TypeF())))
        return QStyleOptionFrame_PythonToCpp_QStyleOptionFrame_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QStyleOptionFrame_PTR_CppToPython_QStyleOptionFrame(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QStyleOptionFrame *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QStyleOptionFrame_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QStyleOptionFrame_SignatureStrings[] = {
    "2:PySide2.QtWidgets.QStyleOptionFrame(self)",
    "1:PySide2.QtWidgets.QStyleOptionFrame(self,other:PySide2.QtWidgets.QStyleOptionFrame)",
    "0:PySide2.QtWidgets.QStyleOptionFrame(self,version:int)",
    nullptr}; // Sentinel

void init_QStyleOptionFrame(PyObject *module)
{
    _Sbk_QStyleOptionFrame_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QStyleOptionFrame",
        "QStyleOptionFrame*",
        &Sbk_QStyleOptionFrame_spec,
        &Shiboken::callCppDestructor< ::QStyleOptionFrame >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTION_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QStyleOptionFrame_Type);
    InitSignatureStrings(pyType, QStyleOptionFrame_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QStyleOptionFrame_Type), Sbk_QStyleOptionFrame_PropertyStrings);
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONFRAME_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QStyleOptionFrame_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QStyleOptionFrame_TypeF(),
        QStyleOptionFrame_PythonToCpp_QStyleOptionFrame_PTR,
        is_QStyleOptionFrame_PythonToCpp_QStyleOptionFrame_PTR_Convertible,
        QStyleOptionFrame_PTR_CppToPython_QStyleOptionFrame);

    Shiboken::Conversions::registerConverterName(converter, "QStyleOptionFrame");
    Shiboken::Conversions::registerConverterName(converter, "QStyleOptionFrame*");
    Shiboken::Conversions::registerConverterName(converter, "QStyleOptionFrame&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QStyleOptionFrame).name());


    // Initialization of enums.

    // Initialization of enum 'StyleOptionType'.
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONFRAME_STYLEOPTIONTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QStyleOptionFrame_TypeF(),
        "StyleOptionType",
        "2:PySide2.QtWidgets.QStyleOptionFrame.StyleOptionType",
        "QStyleOptionFrame::StyleOptionType");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONFRAME_STYLEOPTIONTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONFRAME_STYLEOPTIONTYPE_IDX],
        Sbk_QStyleOptionFrame_TypeF(), "Type", (long) QStyleOptionFrame::StyleOptionType::Type))
        return;
    // Register converter for enum 'QStyleOptionFrame::StyleOptionType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONFRAME_STYLEOPTIONTYPE_IDX],
            QStyleOptionFrame_StyleOptionType_CppToPython_QStyleOptionFrame_StyleOptionType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyleOptionFrame_StyleOptionType_PythonToCpp_QStyleOptionFrame_StyleOptionType,
            is_QStyleOptionFrame_StyleOptionType_PythonToCpp_QStyleOptionFrame_StyleOptionType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONFRAME_STYLEOPTIONTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyleOptionFrame::StyleOptionType");
        Shiboken::Conversions::registerConverterName(converter, "StyleOptionType");
    }
    // End of 'StyleOptionType' enum.

    // Initialization of enum 'StyleOptionVersion'.
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONFRAME_STYLEOPTIONVERSION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QStyleOptionFrame_TypeF(),
        "StyleOptionVersion",
        "2:PySide2.QtWidgets.QStyleOptionFrame.StyleOptionVersion",
        "QStyleOptionFrame::StyleOptionVersion");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONFRAME_STYLEOPTIONVERSION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONFRAME_STYLEOPTIONVERSION_IDX],
        Sbk_QStyleOptionFrame_TypeF(), "Version", (long) QStyleOptionFrame::StyleOptionVersion::Version))
        return;
    // Register converter for enum 'QStyleOptionFrame::StyleOptionVersion'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONFRAME_STYLEOPTIONVERSION_IDX],
            QStyleOptionFrame_StyleOptionVersion_CppToPython_QStyleOptionFrame_StyleOptionVersion);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyleOptionFrame_StyleOptionVersion_PythonToCpp_QStyleOptionFrame_StyleOptionVersion,
            is_QStyleOptionFrame_StyleOptionVersion_PythonToCpp_QStyleOptionFrame_StyleOptionVersion_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONFRAME_STYLEOPTIONVERSION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyleOptionFrame::StyleOptionVersion");
        Shiboken::Conversions::registerConverterName(converter, "StyleOptionVersion");
    }
    // End of 'StyleOptionVersion' enum.

    // Initialization of enum 'FrameFeature'.
    SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONFRAME_FRAMEFEATURE_IDX] = PySide::QFlags::create("2:PySide2.QtWidgets.QStyleOptionFrame.FrameFeatures", SbkPySide2_QtWidgets_QStyleOptionFrame_FrameFeature_number_slots);
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONFRAME_FRAMEFEATURE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QStyleOptionFrame_TypeF(),
        "FrameFeature",
        "2:PySide2.QtWidgets.QStyleOptionFrame.FrameFeature",
        "QStyleOptionFrame::FrameFeature",
        SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONFRAME_FRAMEFEATURE_IDX]);
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONFRAME_FRAMEFEATURE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONFRAME_FRAMEFEATURE_IDX],
        Sbk_QStyleOptionFrame_TypeF(), "None_", (long) QStyleOptionFrame::FrameFeature::None))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONFRAME_FRAMEFEATURE_IDX],
        Sbk_QStyleOptionFrame_TypeF(), "Flat", (long) QStyleOptionFrame::FrameFeature::Flat))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONFRAME_FRAMEFEATURE_IDX],
        Sbk_QStyleOptionFrame_TypeF(), "Rounded", (long) QStyleOptionFrame::FrameFeature::Rounded))
        return;
    // Register converter for enum 'QStyleOptionFrame::FrameFeature'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONFRAME_FRAMEFEATURE_IDX],
            QStyleOptionFrame_FrameFeature_CppToPython_QStyleOptionFrame_FrameFeature);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyleOptionFrame_FrameFeature_PythonToCpp_QStyleOptionFrame_FrameFeature,
            is_QStyleOptionFrame_FrameFeature_PythonToCpp_QStyleOptionFrame_FrameFeature_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONFRAME_FRAMEFEATURE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyleOptionFrame::FrameFeature");
        Shiboken::Conversions::registerConverterName(converter, "FrameFeature");
    }
    // Register converter for flag 'QFlags<QStyleOptionFrame::FrameFeature>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONFRAME_FRAMEFEATURE_IDX],
            QFlags_QStyleOptionFrame_FrameFeature__CppToPython_QFlags_QStyleOptionFrame_FrameFeature_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyleOptionFrame_FrameFeature_PythonToCpp_QFlags_QStyleOptionFrame_FrameFeature_,
            is_QStyleOptionFrame_FrameFeature_PythonToCpp_QFlags_QStyleOptionFrame_FrameFeature__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QStyleOptionFrame_FrameFeature__PythonToCpp_QFlags_QStyleOptionFrame_FrameFeature_,
            is_QFlags_QStyleOptionFrame_FrameFeature__PythonToCpp_QFlags_QStyleOptionFrame_FrameFeature__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QStyleOptionFrame_FrameFeature_,
            is_number_PythonToCpp_QFlags_QStyleOptionFrame_FrameFeature__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONFRAME_FRAMEFEATURE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyleOptionFrame::FrameFeatures");
        Shiboken::Conversions::registerConverterName(converter, "FrameFeatures");
    }
    // End of 'FrameFeature' enum/flags.

    qRegisterMetaType< ::QStyleOptionFrame::StyleOptionType >("QStyleOptionFrame::StyleOptionType");
    qRegisterMetaType< ::QStyleOptionFrame::StyleOptionVersion >("QStyleOptionFrame::StyleOptionVersion");
    qRegisterMetaType< ::QStyleOptionFrame::FrameFeature >("QStyleOptionFrame::FrameFeature");
    qRegisterMetaType< ::QStyleOptionFrame::FrameFeatures >("QStyleOptionFrame::FrameFeatures");
}
