/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtwidgets_python.h"

// main header
#include "qstyleoptionheader_wrapper.h"

// inner classes

// Extra includes
#include <QtWidgets/qstyleoption.h>
#include <QtWidgets/qwidget.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QStyleOptionHeader_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QStyleOptionHeader >()))
        return -1;

    ::QStyleOptionHeader *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QStyleOptionHeader.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QStyleOptionHeader", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QStyleOptionHeader::QStyleOptionHeader()
    // 1: QStyleOptionHeader::QStyleOptionHeader(QStyleOptionHeader)
    // 2: QStyleOptionHeader::QStyleOptionHeader(int)
    if (numArgs == 0) {
        overloadId = 0; // QStyleOptionHeader()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 2; // QStyleOptionHeader(int)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QStyleOptionHeader(QStyleOptionHeader)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStyleOptionHeader_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QStyleOptionHeader()
        {

            if (!PyErr_Occurred()) {
                // QStyleOptionHeader()
                cptr = new ::QStyleOptionHeader();
            }
            break;
        }
        case 1: // QStyleOptionHeader(const QStyleOptionHeader & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QStyleOptionHeader *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QStyleOptionHeader(QStyleOptionHeader)
                cptr = new ::QStyleOptionHeader(*cppArg0);
            }
            break;
        }
        case 2: // QStyleOptionHeader(int version)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QStyleOptionHeader(int)
                cptr = new ::QStyleOptionHeader(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QStyleOptionHeader >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QStyleOptionHeader_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QStyleOptionHeader_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}


static const char *Sbk_QStyleOptionHeader_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QStyleOptionHeader_methods[] = {

    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QStyleOptionHeader_get_section(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionHeader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    int cppOut_local = cppSelf->section;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QStyleOptionHeader_set_section(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionHeader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'section' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'section', 'int' or convertible type expected");
        return -1;
    }

    int cppOut_local = cppSelf->section;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->section = cppOut_local;

    return 0;
}

static PyObject *Sbk_QStyleOptionHeader_get_text(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionHeader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppSelf->text);
    return pyOut;
}
static int Sbk_QStyleOptionHeader_set_text(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionHeader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'text' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'text', 'QString' or convertible type expected");
        return -1;
    }

    ::QString& cppOut_ptr = cppSelf->text;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_QStyleOptionHeader_get_textAlignment(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionHeader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ALIGNMENTFLAG_IDX])->converter, &cppSelf->textAlignment);
    return pyOut;
}
static int Sbk_QStyleOptionHeader_set_textAlignment(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionHeader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'textAlignment' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ALIGNMENTFLAG_IDX])->converter, (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'textAlignment', 'Alignment' or convertible type expected");
        return -1;
    }

    ::QFlags<Qt::AlignmentFlag> cppOut_local = cppSelf->textAlignment;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->textAlignment = cppOut_local;

    return 0;
}

static PyObject *Sbk_QStyleOptionHeader_get_icon(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionHeader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    if (reinterpret_cast<void *>(&(cppSelf->icon)) == reinterpret_cast<void *>(cppSelf)) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::Object::findColocatedChild(reinterpret_cast<SbkObject *>(self), reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QICON_IDX])));
        if (pyOut) {
            Py_IncRef(pyOut);
            return pyOut;
        }
    } else if (Shiboken::BindingManager::instance().hasWrapper(&(cppSelf->icon))) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(&(cppSelf->icon)));
        Py_IncRef(pyOut);
        return pyOut;
    }
    pyOut = Shiboken::Object::newObject(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QICON_IDX]), &(cppSelf->icon), false, true);
    Shiboken::Object::setParent(self, pyOut);
    return pyOut;
}
static int Sbk_QStyleOptionHeader_set_icon(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionHeader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'icon' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QICON_IDX]), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'icon', 'QIcon' or convertible type expected");
        return -1;
    }

    ::QIcon& cppOut_ptr = cppSelf->icon;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_QStyleOptionHeader_get_iconAlignment(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionHeader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ALIGNMENTFLAG_IDX])->converter, &cppSelf->iconAlignment);
    return pyOut;
}
static int Sbk_QStyleOptionHeader_set_iconAlignment(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionHeader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'iconAlignment' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ALIGNMENTFLAG_IDX])->converter, (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'iconAlignment', 'Alignment' or convertible type expected");
        return -1;
    }

    ::QFlags<Qt::AlignmentFlag> cppOut_local = cppSelf->iconAlignment;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->iconAlignment = cppOut_local;

    return 0;
}

static PyObject *Sbk_QStyleOptionHeader_get_position(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionHeader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    ::QStyleOptionHeader::SectionPosition cppOut_local = cppSelf->position;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_SECTIONPOSITION_IDX])->converter, &cppOut_local);
    return pyOut;
}
static int Sbk_QStyleOptionHeader_set_position(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionHeader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'position' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_SECTIONPOSITION_IDX])->converter, (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'position', 'SectionPosition' or convertible type expected");
        return -1;
    }

    ::QStyleOptionHeader::SectionPosition cppOut_local = cppSelf->position;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->position = cppOut_local;

    return 0;
}

static PyObject *Sbk_QStyleOptionHeader_get_selectedPosition(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionHeader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    ::QStyleOptionHeader::SelectedPosition cppOut_local = cppSelf->selectedPosition;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_SELECTEDPOSITION_IDX])->converter, &cppOut_local);
    return pyOut;
}
static int Sbk_QStyleOptionHeader_set_selectedPosition(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionHeader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'selectedPosition' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_SELECTEDPOSITION_IDX])->converter, (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'selectedPosition', 'SelectedPosition' or convertible type expected");
        return -1;
    }

    ::QStyleOptionHeader::SelectedPosition cppOut_local = cppSelf->selectedPosition;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->selectedPosition = cppOut_local;

    return 0;
}

static PyObject *Sbk_QStyleOptionHeader_get_sortIndicator(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionHeader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    ::QStyleOptionHeader::SortIndicator cppOut_local = cppSelf->sortIndicator;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_SORTINDICATOR_IDX])->converter, &cppOut_local);
    return pyOut;
}
static int Sbk_QStyleOptionHeader_set_sortIndicator(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionHeader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'sortIndicator' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_SORTINDICATOR_IDX])->converter, (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'sortIndicator', 'SortIndicator' or convertible type expected");
        return -1;
    }

    ::QStyleOptionHeader::SortIndicator cppOut_local = cppSelf->sortIndicator;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->sortIndicator = cppOut_local;

    return 0;
}

static PyObject *Sbk_QStyleOptionHeader_get_orientation(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionHeader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    ::Qt::Orientation cppOut_local = cppSelf->orientation;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_ORIENTATION_IDX])->converter, &cppOut_local);
    return pyOut;
}
static int Sbk_QStyleOptionHeader_set_orientation(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionHeader *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'orientation' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_ORIENTATION_IDX])->converter, (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'orientation', 'Orientation' or convertible type expected");
        return -1;
    }

    ::Qt::Orientation cppOut_local = cppSelf->orientation;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->orientation = cppOut_local;

    return 0;
}

// Getters and Setters for QStyleOptionHeader
static PyGetSetDef Sbk_QStyleOptionHeader_getsetlist[] = {
    {const_cast<char *>("section"), Sbk_QStyleOptionHeader_get_section, Sbk_QStyleOptionHeader_set_section},
    {const_cast<char *>("text"), Sbk_QStyleOptionHeader_get_text, Sbk_QStyleOptionHeader_set_text},
    {const_cast<char *>("textAlignment"), Sbk_QStyleOptionHeader_get_textAlignment, Sbk_QStyleOptionHeader_set_textAlignment},
    {const_cast<char *>("icon"), Sbk_QStyleOptionHeader_get_icon, Sbk_QStyleOptionHeader_set_icon},
    {const_cast<char *>("iconAlignment"), Sbk_QStyleOptionHeader_get_iconAlignment, Sbk_QStyleOptionHeader_set_iconAlignment},
    {const_cast<char *>("position"), Sbk_QStyleOptionHeader_get_position, Sbk_QStyleOptionHeader_set_position},
    {const_cast<char *>("selectedPosition"), Sbk_QStyleOptionHeader_get_selectedPosition, Sbk_QStyleOptionHeader_set_selectedPosition},
    {const_cast<char *>("sortIndicator"), Sbk_QStyleOptionHeader_get_sortIndicator, Sbk_QStyleOptionHeader_set_sortIndicator},
    {const_cast<char *>("orientation"), Sbk_QStyleOptionHeader_get_orientation, Sbk_QStyleOptionHeader_set_orientation},
    {nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QStyleOptionHeader_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QStyleOptionHeader_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QStyleOptionHeader_Type = nullptr;
static SbkObjectType *Sbk_QStyleOptionHeader_TypeF(void)
{
    return _Sbk_QStyleOptionHeader_Type;
}

static PyType_Slot Sbk_QStyleOptionHeader_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QStyleOptionHeader_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QStyleOptionHeader_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QStyleOptionHeader_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_QStyleOptionHeader_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QStyleOptionHeader_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QStyleOptionHeader_spec = {
    "2:PySide2.QtWidgets.QStyleOptionHeader",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QStyleOptionHeader_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QStyleOptionHeader_StyleOptionType_PythonToCpp_QStyleOptionHeader_StyleOptionType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStyleOptionHeader::StyleOptionType *>(cppOut) =
        static_cast<::QStyleOptionHeader::StyleOptionType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QStyleOptionHeader_StyleOptionType_PythonToCpp_QStyleOptionHeader_StyleOptionType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_STYLEOPTIONTYPE_IDX]))
        return QStyleOptionHeader_StyleOptionType_PythonToCpp_QStyleOptionHeader_StyleOptionType;
    return {};
}
static PyObject *QStyleOptionHeader_StyleOptionType_CppToPython_QStyleOptionHeader_StyleOptionType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QStyleOptionHeader::StyleOptionType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_STYLEOPTIONTYPE_IDX], castCppIn);

}

static void QStyleOptionHeader_StyleOptionVersion_PythonToCpp_QStyleOptionHeader_StyleOptionVersion(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStyleOptionHeader::StyleOptionVersion *>(cppOut) =
        static_cast<::QStyleOptionHeader::StyleOptionVersion>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QStyleOptionHeader_StyleOptionVersion_PythonToCpp_QStyleOptionHeader_StyleOptionVersion_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_STYLEOPTIONVERSION_IDX]))
        return QStyleOptionHeader_StyleOptionVersion_PythonToCpp_QStyleOptionHeader_StyleOptionVersion;
    return {};
}
static PyObject *QStyleOptionHeader_StyleOptionVersion_CppToPython_QStyleOptionHeader_StyleOptionVersion(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QStyleOptionHeader::StyleOptionVersion *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_STYLEOPTIONVERSION_IDX], castCppIn);

}

static void QStyleOptionHeader_SectionPosition_PythonToCpp_QStyleOptionHeader_SectionPosition(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStyleOptionHeader::SectionPosition *>(cppOut) =
        static_cast<::QStyleOptionHeader::SectionPosition>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QStyleOptionHeader_SectionPosition_PythonToCpp_QStyleOptionHeader_SectionPosition_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_SECTIONPOSITION_IDX]))
        return QStyleOptionHeader_SectionPosition_PythonToCpp_QStyleOptionHeader_SectionPosition;
    return {};
}
static PyObject *QStyleOptionHeader_SectionPosition_CppToPython_QStyleOptionHeader_SectionPosition(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QStyleOptionHeader::SectionPosition *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_SECTIONPOSITION_IDX], castCppIn);

}

static void QStyleOptionHeader_SelectedPosition_PythonToCpp_QStyleOptionHeader_SelectedPosition(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStyleOptionHeader::SelectedPosition *>(cppOut) =
        static_cast<::QStyleOptionHeader::SelectedPosition>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QStyleOptionHeader_SelectedPosition_PythonToCpp_QStyleOptionHeader_SelectedPosition_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_SELECTEDPOSITION_IDX]))
        return QStyleOptionHeader_SelectedPosition_PythonToCpp_QStyleOptionHeader_SelectedPosition;
    return {};
}
static PyObject *QStyleOptionHeader_SelectedPosition_CppToPython_QStyleOptionHeader_SelectedPosition(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QStyleOptionHeader::SelectedPosition *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_SELECTEDPOSITION_IDX], castCppIn);

}

static void QStyleOptionHeader_SortIndicator_PythonToCpp_QStyleOptionHeader_SortIndicator(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStyleOptionHeader::SortIndicator *>(cppOut) =
        static_cast<::QStyleOptionHeader::SortIndicator>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QStyleOptionHeader_SortIndicator_PythonToCpp_QStyleOptionHeader_SortIndicator_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_SORTINDICATOR_IDX]))
        return QStyleOptionHeader_SortIndicator_PythonToCpp_QStyleOptionHeader_SortIndicator;
    return {};
}
static PyObject *QStyleOptionHeader_SortIndicator_CppToPython_QStyleOptionHeader_SortIndicator(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QStyleOptionHeader::SortIndicator *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_SORTINDICATOR_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QStyleOptionHeader_PythonToCpp_QStyleOptionHeader_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QStyleOptionHeader_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QStyleOptionHeader_PythonToCpp_QStyleOptionHeader_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QStyleOptionHeader_TypeF())))
        return QStyleOptionHeader_PythonToCpp_QStyleOptionHeader_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QStyleOptionHeader_PTR_CppToPython_QStyleOptionHeader(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QStyleOptionHeader *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QStyleOptionHeader_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QStyleOptionHeader_SignatureStrings[] = {
    "2:PySide2.QtWidgets.QStyleOptionHeader(self)",
    "1:PySide2.QtWidgets.QStyleOptionHeader(self,other:PySide2.QtWidgets.QStyleOptionHeader)",
    "0:PySide2.QtWidgets.QStyleOptionHeader(self,version:int)",
    nullptr}; // Sentinel

void init_QStyleOptionHeader(PyObject *module)
{
    _Sbk_QStyleOptionHeader_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QStyleOptionHeader",
        "QStyleOptionHeader*",
        &Sbk_QStyleOptionHeader_spec,
        &Shiboken::callCppDestructor< ::QStyleOptionHeader >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTION_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QStyleOptionHeader_Type);
    InitSignatureStrings(pyType, QStyleOptionHeader_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QStyleOptionHeader_Type), Sbk_QStyleOptionHeader_PropertyStrings);
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QStyleOptionHeader_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QStyleOptionHeader_TypeF(),
        QStyleOptionHeader_PythonToCpp_QStyleOptionHeader_PTR,
        is_QStyleOptionHeader_PythonToCpp_QStyleOptionHeader_PTR_Convertible,
        QStyleOptionHeader_PTR_CppToPython_QStyleOptionHeader);

    Shiboken::Conversions::registerConverterName(converter, "QStyleOptionHeader");
    Shiboken::Conversions::registerConverterName(converter, "QStyleOptionHeader*");
    Shiboken::Conversions::registerConverterName(converter, "QStyleOptionHeader&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QStyleOptionHeader).name());


    // Initialization of enums.

    // Initialization of enum 'StyleOptionType'.
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_STYLEOPTIONTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QStyleOptionHeader_TypeF(),
        "StyleOptionType",
        "2:PySide2.QtWidgets.QStyleOptionHeader.StyleOptionType",
        "QStyleOptionHeader::StyleOptionType");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_STYLEOPTIONTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_STYLEOPTIONTYPE_IDX],
        Sbk_QStyleOptionHeader_TypeF(), "Type", (long) QStyleOptionHeader::StyleOptionType::Type))
        return;
    // Register converter for enum 'QStyleOptionHeader::StyleOptionType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_STYLEOPTIONTYPE_IDX],
            QStyleOptionHeader_StyleOptionType_CppToPython_QStyleOptionHeader_StyleOptionType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyleOptionHeader_StyleOptionType_PythonToCpp_QStyleOptionHeader_StyleOptionType,
            is_QStyleOptionHeader_StyleOptionType_PythonToCpp_QStyleOptionHeader_StyleOptionType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_STYLEOPTIONTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyleOptionHeader::StyleOptionType");
        Shiboken::Conversions::registerConverterName(converter, "StyleOptionType");
    }
    // End of 'StyleOptionType' enum.

    // Initialization of enum 'StyleOptionVersion'.
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_STYLEOPTIONVERSION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QStyleOptionHeader_TypeF(),
        "StyleOptionVersion",
        "2:PySide2.QtWidgets.QStyleOptionHeader.StyleOptionVersion",
        "QStyleOptionHeader::StyleOptionVersion");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_STYLEOPTIONVERSION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_STYLEOPTIONVERSION_IDX],
        Sbk_QStyleOptionHeader_TypeF(), "Version", (long) QStyleOptionHeader::StyleOptionVersion::Version))
        return;
    // Register converter for enum 'QStyleOptionHeader::StyleOptionVersion'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_STYLEOPTIONVERSION_IDX],
            QStyleOptionHeader_StyleOptionVersion_CppToPython_QStyleOptionHeader_StyleOptionVersion);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyleOptionHeader_StyleOptionVersion_PythonToCpp_QStyleOptionHeader_StyleOptionVersion,
            is_QStyleOptionHeader_StyleOptionVersion_PythonToCpp_QStyleOptionHeader_StyleOptionVersion_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_STYLEOPTIONVERSION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyleOptionHeader::StyleOptionVersion");
        Shiboken::Conversions::registerConverterName(converter, "StyleOptionVersion");
    }
    // End of 'StyleOptionVersion' enum.

    // Initialization of enum 'SectionPosition'.
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_SECTIONPOSITION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QStyleOptionHeader_TypeF(),
        "SectionPosition",
        "2:PySide2.QtWidgets.QStyleOptionHeader.SectionPosition",
        "QStyleOptionHeader::SectionPosition");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_SECTIONPOSITION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_SECTIONPOSITION_IDX],
        Sbk_QStyleOptionHeader_TypeF(), "Beginning", (long) QStyleOptionHeader::SectionPosition::Beginning))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_SECTIONPOSITION_IDX],
        Sbk_QStyleOptionHeader_TypeF(), "Middle", (long) QStyleOptionHeader::SectionPosition::Middle))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_SECTIONPOSITION_IDX],
        Sbk_QStyleOptionHeader_TypeF(), "End", (long) QStyleOptionHeader::SectionPosition::End))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_SECTIONPOSITION_IDX],
        Sbk_QStyleOptionHeader_TypeF(), "OnlyOneSection", (long) QStyleOptionHeader::SectionPosition::OnlyOneSection))
        return;
    // Register converter for enum 'QStyleOptionHeader::SectionPosition'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_SECTIONPOSITION_IDX],
            QStyleOptionHeader_SectionPosition_CppToPython_QStyleOptionHeader_SectionPosition);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyleOptionHeader_SectionPosition_PythonToCpp_QStyleOptionHeader_SectionPosition,
            is_QStyleOptionHeader_SectionPosition_PythonToCpp_QStyleOptionHeader_SectionPosition_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_SECTIONPOSITION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyleOptionHeader::SectionPosition");
        Shiboken::Conversions::registerConverterName(converter, "SectionPosition");
    }
    // End of 'SectionPosition' enum.

    // Initialization of enum 'SelectedPosition'.
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_SELECTEDPOSITION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QStyleOptionHeader_TypeF(),
        "SelectedPosition",
        "2:PySide2.QtWidgets.QStyleOptionHeader.SelectedPosition",
        "QStyleOptionHeader::SelectedPosition");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_SELECTEDPOSITION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_SELECTEDPOSITION_IDX],
        Sbk_QStyleOptionHeader_TypeF(), "NotAdjacent", (long) QStyleOptionHeader::SelectedPosition::NotAdjacent))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_SELECTEDPOSITION_IDX],
        Sbk_QStyleOptionHeader_TypeF(), "NextIsSelected", (long) QStyleOptionHeader::SelectedPosition::NextIsSelected))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_SELECTEDPOSITION_IDX],
        Sbk_QStyleOptionHeader_TypeF(), "PreviousIsSelected", (long) QStyleOptionHeader::SelectedPosition::PreviousIsSelected))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_SELECTEDPOSITION_IDX],
        Sbk_QStyleOptionHeader_TypeF(), "NextAndPreviousAreSelected", (long) QStyleOptionHeader::SelectedPosition::NextAndPreviousAreSelected))
        return;
    // Register converter for enum 'QStyleOptionHeader::SelectedPosition'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_SELECTEDPOSITION_IDX],
            QStyleOptionHeader_SelectedPosition_CppToPython_QStyleOptionHeader_SelectedPosition);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyleOptionHeader_SelectedPosition_PythonToCpp_QStyleOptionHeader_SelectedPosition,
            is_QStyleOptionHeader_SelectedPosition_PythonToCpp_QStyleOptionHeader_SelectedPosition_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_SELECTEDPOSITION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyleOptionHeader::SelectedPosition");
        Shiboken::Conversions::registerConverterName(converter, "SelectedPosition");
    }
    // End of 'SelectedPosition' enum.

    // Initialization of enum 'SortIndicator'.
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_SORTINDICATOR_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QStyleOptionHeader_TypeF(),
        "SortIndicator",
        "2:PySide2.QtWidgets.QStyleOptionHeader.SortIndicator",
        "QStyleOptionHeader::SortIndicator");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_SORTINDICATOR_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_SORTINDICATOR_IDX],
        Sbk_QStyleOptionHeader_TypeF(), "None_", (long) QStyleOptionHeader::SortIndicator::None))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_SORTINDICATOR_IDX],
        Sbk_QStyleOptionHeader_TypeF(), "SortUp", (long) QStyleOptionHeader::SortIndicator::SortUp))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_SORTINDICATOR_IDX],
        Sbk_QStyleOptionHeader_TypeF(), "SortDown", (long) QStyleOptionHeader::SortIndicator::SortDown))
        return;
    // Register converter for enum 'QStyleOptionHeader::SortIndicator'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_SORTINDICATOR_IDX],
            QStyleOptionHeader_SortIndicator_CppToPython_QStyleOptionHeader_SortIndicator);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyleOptionHeader_SortIndicator_PythonToCpp_QStyleOptionHeader_SortIndicator,
            is_QStyleOptionHeader_SortIndicator_PythonToCpp_QStyleOptionHeader_SortIndicator_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONHEADER_SORTINDICATOR_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyleOptionHeader::SortIndicator");
        Shiboken::Conversions::registerConverterName(converter, "SortIndicator");
    }
    // End of 'SortIndicator' enum.

    qRegisterMetaType< ::QStyleOptionHeader::StyleOptionType >("QStyleOptionHeader::StyleOptionType");
    qRegisterMetaType< ::QStyleOptionHeader::StyleOptionVersion >("QStyleOptionHeader::StyleOptionVersion");
    qRegisterMetaType< ::QStyleOptionHeader::SectionPosition >("QStyleOptionHeader::SectionPosition");
    qRegisterMetaType< ::QStyleOptionHeader::SelectedPosition >("QStyleOptionHeader::SelectedPosition");
    qRegisterMetaType< ::QStyleOptionHeader::SortIndicator >("QStyleOptionHeader::SortIndicator");
}
