/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtwidgets_python.h"

// main header
#include "qstyleoptionspinbox_wrapper.h"

// inner classes

// Extra includes
#include <QtWidgets/qstyleoption.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QStyleOptionSpinBox_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QStyleOptionSpinBox >()))
        return -1;

    ::QStyleOptionSpinBox *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QStyleOptionSpinBox.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QStyleOptionSpinBox", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QStyleOptionSpinBox::QStyleOptionSpinBox()
    // 1: QStyleOptionSpinBox::QStyleOptionSpinBox(QStyleOptionSpinBox)
    // 2: QStyleOptionSpinBox::QStyleOptionSpinBox(int)
    if (numArgs == 0) {
        overloadId = 0; // QStyleOptionSpinBox()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 2; // QStyleOptionSpinBox(int)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONSPINBOX_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QStyleOptionSpinBox(QStyleOptionSpinBox)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStyleOptionSpinBox_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QStyleOptionSpinBox()
        {

            if (!PyErr_Occurred()) {
                // QStyleOptionSpinBox()
                cptr = new ::QStyleOptionSpinBox();
            }
            break;
        }
        case 1: // QStyleOptionSpinBox(const QStyleOptionSpinBox & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QStyleOptionSpinBox *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QStyleOptionSpinBox(QStyleOptionSpinBox)
                cptr = new ::QStyleOptionSpinBox(*cppArg0);
            }
            break;
        }
        case 2: // QStyleOptionSpinBox(int version)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QStyleOptionSpinBox(int)
                cptr = new ::QStyleOptionSpinBox(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QStyleOptionSpinBox >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QStyleOptionSpinBox_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QStyleOptionSpinBox_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}


static const char *Sbk_QStyleOptionSpinBox_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QStyleOptionSpinBox_methods[] = {

    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QStyleOptionSpinBox_get_buttonSymbols(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionSpinBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONSPINBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    ::QAbstractSpinBox::ButtonSymbols cppOut_local = cppSelf->buttonSymbols;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_BUTTONSYMBOLS_IDX])->converter, &cppOut_local);
    return pyOut;
}
static int Sbk_QStyleOptionSpinBox_set_buttonSymbols(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionSpinBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONSPINBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'buttonSymbols' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTSPINBOX_BUTTONSYMBOLS_IDX])->converter, (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'buttonSymbols', 'ButtonSymbols' or convertible type expected");
        return -1;
    }

    ::QAbstractSpinBox::ButtonSymbols cppOut_local = cppSelf->buttonSymbols;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->buttonSymbols = cppOut_local;

    return 0;
}

static PyObject *Sbk_QStyleOptionSpinBox_get_stepEnabled(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionSpinBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONSPINBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QABSTRACTSPINBOX_STEPENABLEDFLAG_IDX])->converter, &cppSelf->stepEnabled);
    return pyOut;
}
static int Sbk_QStyleOptionSpinBox_set_stepEnabled(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionSpinBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONSPINBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'stepEnabled' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QABSTRACTSPINBOX_STEPENABLEDFLAG_IDX])->converter, (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'stepEnabled', 'StepEnabled' or convertible type expected");
        return -1;
    }

    ::QFlags<QAbstractSpinBox::StepEnabledFlag> cppOut_local = cppSelf->stepEnabled;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->stepEnabled = cppOut_local;

    return 0;
}

static PyObject *Sbk_QStyleOptionSpinBox_get_frame(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionSpinBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONSPINBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    bool cppOut_local = cppSelf->frame;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QStyleOptionSpinBox_set_frame(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionSpinBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONSPINBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'frame' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'frame', 'bool' or convertible type expected");
        return -1;
    }

    bool cppOut_local = cppSelf->frame;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->frame = cppOut_local;

    return 0;
}

// Getters and Setters for QStyleOptionSpinBox
static PyGetSetDef Sbk_QStyleOptionSpinBox_getsetlist[] = {
    {const_cast<char *>("buttonSymbols"), Sbk_QStyleOptionSpinBox_get_buttonSymbols, Sbk_QStyleOptionSpinBox_set_buttonSymbols},
    {const_cast<char *>("stepEnabled"), Sbk_QStyleOptionSpinBox_get_stepEnabled, Sbk_QStyleOptionSpinBox_set_stepEnabled},
    {const_cast<char *>("frame"), Sbk_QStyleOptionSpinBox_get_frame, Sbk_QStyleOptionSpinBox_set_frame},
    {nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QStyleOptionSpinBox_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QStyleOptionSpinBox_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QStyleOptionSpinBox_Type = nullptr;
static SbkObjectType *Sbk_QStyleOptionSpinBox_TypeF(void)
{
    return _Sbk_QStyleOptionSpinBox_Type;
}

static PyType_Slot Sbk_QStyleOptionSpinBox_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QStyleOptionSpinBox_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QStyleOptionSpinBox_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QStyleOptionSpinBox_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_QStyleOptionSpinBox_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QStyleOptionSpinBox_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QStyleOptionSpinBox_spec = {
    "2:PySide2.QtWidgets.QStyleOptionSpinBox",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QStyleOptionSpinBox_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QStyleOptionSpinBox_StyleOptionType_PythonToCpp_QStyleOptionSpinBox_StyleOptionType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStyleOptionSpinBox::StyleOptionType *>(cppOut) =
        static_cast<::QStyleOptionSpinBox::StyleOptionType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QStyleOptionSpinBox_StyleOptionType_PythonToCpp_QStyleOptionSpinBox_StyleOptionType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONSPINBOX_STYLEOPTIONTYPE_IDX]))
        return QStyleOptionSpinBox_StyleOptionType_PythonToCpp_QStyleOptionSpinBox_StyleOptionType;
    return {};
}
static PyObject *QStyleOptionSpinBox_StyleOptionType_CppToPython_QStyleOptionSpinBox_StyleOptionType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QStyleOptionSpinBox::StyleOptionType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONSPINBOX_STYLEOPTIONTYPE_IDX], castCppIn);

}

static void QStyleOptionSpinBox_StyleOptionVersion_PythonToCpp_QStyleOptionSpinBox_StyleOptionVersion(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStyleOptionSpinBox::StyleOptionVersion *>(cppOut) =
        static_cast<::QStyleOptionSpinBox::StyleOptionVersion>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QStyleOptionSpinBox_StyleOptionVersion_PythonToCpp_QStyleOptionSpinBox_StyleOptionVersion_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONSPINBOX_STYLEOPTIONVERSION_IDX]))
        return QStyleOptionSpinBox_StyleOptionVersion_PythonToCpp_QStyleOptionSpinBox_StyleOptionVersion;
    return {};
}
static PyObject *QStyleOptionSpinBox_StyleOptionVersion_CppToPython_QStyleOptionSpinBox_StyleOptionVersion(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QStyleOptionSpinBox::StyleOptionVersion *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONSPINBOX_STYLEOPTIONVERSION_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QStyleOptionSpinBox_PythonToCpp_QStyleOptionSpinBox_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QStyleOptionSpinBox_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QStyleOptionSpinBox_PythonToCpp_QStyleOptionSpinBox_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QStyleOptionSpinBox_TypeF())))
        return QStyleOptionSpinBox_PythonToCpp_QStyleOptionSpinBox_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QStyleOptionSpinBox_PTR_CppToPython_QStyleOptionSpinBox(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QStyleOptionSpinBox *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QStyleOptionSpinBox_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QStyleOptionSpinBox_SignatureStrings[] = {
    "2:PySide2.QtWidgets.QStyleOptionSpinBox(self)",
    "1:PySide2.QtWidgets.QStyleOptionSpinBox(self,other:PySide2.QtWidgets.QStyleOptionSpinBox)",
    "0:PySide2.QtWidgets.QStyleOptionSpinBox(self,version:int)",
    nullptr}; // Sentinel

void init_QStyleOptionSpinBox(PyObject *module)
{
    _Sbk_QStyleOptionSpinBox_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QStyleOptionSpinBox",
        "QStyleOptionSpinBox*",
        &Sbk_QStyleOptionSpinBox_spec,
        &Shiboken::callCppDestructor< ::QStyleOptionSpinBox >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONCOMPLEX_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QStyleOptionSpinBox_Type);
    InitSignatureStrings(pyType, QStyleOptionSpinBox_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QStyleOptionSpinBox_Type), Sbk_QStyleOptionSpinBox_PropertyStrings);
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONSPINBOX_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QStyleOptionSpinBox_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QStyleOptionSpinBox_TypeF(),
        QStyleOptionSpinBox_PythonToCpp_QStyleOptionSpinBox_PTR,
        is_QStyleOptionSpinBox_PythonToCpp_QStyleOptionSpinBox_PTR_Convertible,
        QStyleOptionSpinBox_PTR_CppToPython_QStyleOptionSpinBox);

    Shiboken::Conversions::registerConverterName(converter, "QStyleOptionSpinBox");
    Shiboken::Conversions::registerConverterName(converter, "QStyleOptionSpinBox*");
    Shiboken::Conversions::registerConverterName(converter, "QStyleOptionSpinBox&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QStyleOptionSpinBox).name());


    // Initialization of enums.

    // Initialization of enum 'StyleOptionType'.
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONSPINBOX_STYLEOPTIONTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QStyleOptionSpinBox_TypeF(),
        "StyleOptionType",
        "2:PySide2.QtWidgets.QStyleOptionSpinBox.StyleOptionType",
        "QStyleOptionSpinBox::StyleOptionType");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONSPINBOX_STYLEOPTIONTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONSPINBOX_STYLEOPTIONTYPE_IDX],
        Sbk_QStyleOptionSpinBox_TypeF(), "Type", (long) QStyleOptionSpinBox::StyleOptionType::Type))
        return;
    // Register converter for enum 'QStyleOptionSpinBox::StyleOptionType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONSPINBOX_STYLEOPTIONTYPE_IDX],
            QStyleOptionSpinBox_StyleOptionType_CppToPython_QStyleOptionSpinBox_StyleOptionType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyleOptionSpinBox_StyleOptionType_PythonToCpp_QStyleOptionSpinBox_StyleOptionType,
            is_QStyleOptionSpinBox_StyleOptionType_PythonToCpp_QStyleOptionSpinBox_StyleOptionType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONSPINBOX_STYLEOPTIONTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyleOptionSpinBox::StyleOptionType");
        Shiboken::Conversions::registerConverterName(converter, "StyleOptionType");
    }
    // End of 'StyleOptionType' enum.

    // Initialization of enum 'StyleOptionVersion'.
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONSPINBOX_STYLEOPTIONVERSION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QStyleOptionSpinBox_TypeF(),
        "StyleOptionVersion",
        "2:PySide2.QtWidgets.QStyleOptionSpinBox.StyleOptionVersion",
        "QStyleOptionSpinBox::StyleOptionVersion");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONSPINBOX_STYLEOPTIONVERSION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONSPINBOX_STYLEOPTIONVERSION_IDX],
        Sbk_QStyleOptionSpinBox_TypeF(), "Version", (long) QStyleOptionSpinBox::StyleOptionVersion::Version))
        return;
    // Register converter for enum 'QStyleOptionSpinBox::StyleOptionVersion'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONSPINBOX_STYLEOPTIONVERSION_IDX],
            QStyleOptionSpinBox_StyleOptionVersion_CppToPython_QStyleOptionSpinBox_StyleOptionVersion);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyleOptionSpinBox_StyleOptionVersion_PythonToCpp_QStyleOptionSpinBox_StyleOptionVersion,
            is_QStyleOptionSpinBox_StyleOptionVersion_PythonToCpp_QStyleOptionSpinBox_StyleOptionVersion_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONSPINBOX_STYLEOPTIONVERSION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyleOptionSpinBox::StyleOptionVersion");
        Shiboken::Conversions::registerConverterName(converter, "StyleOptionVersion");
    }
    // End of 'StyleOptionVersion' enum.

    qRegisterMetaType< ::QStyleOptionSpinBox::StyleOptionType >("QStyleOptionSpinBox::StyleOptionType");
    qRegisterMetaType< ::QStyleOptionSpinBox::StyleOptionVersion >("QStyleOptionSpinBox::StyleOptionVersion");
}
