/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#include <sbkpython.h>
#include <shiboken.h>
#include <algorithm>
#include <signature.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
#include "pyside2_qtwidgets_python.h"



// Extra includes

// Current module's type array.
PyTypeObject **SbkPySide2_QtWidgetsTypes = nullptr;
// Current module's PyObject pointer.
PyObject *SbkPySide2_QtWidgetsModuleObject = nullptr;
// Current module's converter array.
SbkConverter **SbkPySide2_QtWidgetsTypeConverters = nullptr;
void cleanTypesAttributes(void) {
    if (PY_VERSION_HEX >= 0x03000000 && PY_VERSION_HEX < 0x03060000)
        return; // PYSIDE-953: testbinding crashes in Python 3.5 when hasattr touches types!
    for (int i = 0, imax = SBK_QtWidgets_IDX_COUNT; i < imax; i++) {
        PyObject *pyType = reinterpret_cast<PyObject *>(SbkPySide2_QtWidgetsTypes[i]);
        Shiboken::AutoDecRef attrName(Py_BuildValue("s", "staticMetaObject"));
        if (pyType && PyObject_HasAttr(pyType, attrName))
            PyObject_SetAttr(pyType, attrName, Py_None);
    }
}
// Global functions ------------------------------------------------------------

static PyMethodDef QtWidgets_methods[] = {
    {0} // Sentinel
};

// Classes initialization functions ------------------------------------------------------------
void init_QWhatsThis(PyObject *module);
void init_QUndoCommand(PyObject *module);
void init_QTreeWidgetItemIterator(PyObject *module);
void init_QTreeWidgetItem(PyObject *module);
void init_QToolTip(PyObject *module);
void init_QTableWidgetSelectionRange(PyObject *module);
void init_QTableWidgetItem(PyObject *module);
void init_QStyleHintReturn(PyObject *module);
void init_QStyleHintReturnVariant(PyObject *module);
void init_QStyleFactory(PyObject *module);
void init_QSizePolicy(PyObject *module);
void init_QScrollerProperties(PyObject *module);
void init_QListWidgetItem(PyObject *module);
void init_QLayoutItem(PyObject *module);
void init_QSpacerItem(PyObject *module);
void init_QItemEditorFactory(PyObject *module);
void init_QItemEditorCreatorBase(PyObject *module);
void init_QGestureRecognizer(PyObject *module);
void init_QFileIconProvider(PyObject *module);
void init_QColormap(PyObject *module);
void init_QStyleHintReturnMask(PyObject *module);
void init_QAccessibleWidget(PyObject *module);
void init_QTileRules(PyObject *module);
void init_QGraphicsLayoutItem(PyObject *module);
void init_QGraphicsLayout(PyObject *module);
void init_QGraphicsLinearLayout(PyObject *module);
void init_QGraphicsGridLayout(PyObject *module);
void init_QGraphicsAnchorLayout(PyObject *module);
void init_QGraphicsItem(PyObject *module);
void init_QGraphicsLineItem(PyObject *module);
void init_QGraphicsItemGroup(PyObject *module);
void init_QAbstractGraphicsShapeItem(PyObject *module);
void init_QGraphicsEllipseItem(PyObject *module);
void init_QGraphicsRectItem(PyObject *module);
void init_QGraphicsPolygonItem(PyObject *module);
void init_QGraphicsSimpleTextItem(PyObject *module);
void init_QGraphicsPathItem(PyObject *module);
void init_QGraphicsPixmapItem(PyObject *module);
void init_QStylePainter(PyObject *module);
void init_QActionGroup(PyObject *module);
void init_QStyleOption(PyObject *module);
void init_QStyleOptionFocusRect(PyObject *module);
void init_QStyleOptionToolBox(PyObject *module);
void init_QStyleOptionDockWidget(PyObject *module);
void init_QStyleOptionToolBar(PyObject *module);
void init_QStyleOptionComplex(PyObject *module);
void init_QStyleOptionToolButton(PyObject *module);
void init_QStyleOptionTitleBar(PyObject *module);
void init_QStyleOptionComboBox(PyObject *module);
void init_QStyleOptionSizeGrip(PyObject *module);
void init_QStyleOptionGroupBox(PyObject *module);
void init_QStyleOptionButton(PyObject *module);
void init_QStyleOptionProgressBar(PyObject *module);
void init_QStyleOptionMenuItem(PyObject *module);
void init_QStyleOptionHeader(PyObject *module);
void init_QStyleOptionGraphicsItem(PyObject *module);
void init_QAction(PyObject *module);
void init_QWidgetAction(PyObject *module);
void init_QStyle(PyObject *module);
void init_QCommonStyle(PyObject *module);
void init_QProxyStyle(PyObject *module);
void init_QAbstractItemDelegate(PyObject *module);
void init_QItemDelegate(PyObject *module);
void init_QStyledItemDelegate(PyObject *module);
void init_QShortcut(PyObject *module);
void init_QScroller(PyObject *module);
void init_QLayout(PyObject *module);
void init_QFormLayout(PyObject *module);
void init_QGridLayout(PyObject *module);
void init_QStackedLayout(PyObject *module);
void init_QBoxLayout(PyObject *module);
void init_QVBoxLayout(PyObject *module);
void init_QHBoxLayout(PyObject *module);
void init_QGraphicsTransform(PyObject *module);
void init_QGraphicsScale(PyObject *module);
void init_QGraphicsRotation(PyObject *module);
void init_QGraphicsScene(PyObject *module);
void init_QWidget(PyObject *module);
void init_QDesktopWidget(PyObject *module);
void init_QStatusBar(PyObject *module);
void init_QLineEdit(PyObject *module);
void init_QTabWidget(PyObject *module);
void init_QTabBar(PyObject *module);
void init_QStyleOptionTabWidgetFrame(PyObject *module);
void init_QStyleOptionTabBarBase(PyObject *module);
void init_QStyleOptionTab(PyObject *module);
void init_QSplitterHandle(PyObject *module);
void init_QSplashScreen(PyObject *module);
void init_QKeySequenceEdit(PyObject *module);
void init_QComboBox(PyObject *module);
void init_QFontComboBox(PyObject *module);
void init_QStyleOptionViewItem(PyObject *module);
void init_QWizardPage(PyObject *module);
void init_QSizeGrip(PyObject *module);
void init_QCalendarWidget(PyObject *module);
void init_QWidgetItem(PyObject *module);
void init_QGroupBox(PyObject *module);
void init_QRubberBand(PyObject *module);
void init_QStyleOptionRubberBand(PyObject *module);
void init_QAbstractSpinBox(PyObject *module);
void init_QSpinBox(PyObject *module);
void init_QDateTimeEdit(PyObject *module);
void init_QDateEdit(PyObject *module);
void init_QTimeEdit(PyObject *module);
void init_QStyleOptionSpinBox(PyObject *module);
void init_QDoubleSpinBox(PyObject *module);
void init_QAbstractSlider(PyObject *module);
void init_QDial(PyObject *module);
void init_QSlider(PyObject *module);
void init_QStyleOptionSlider(PyObject *module);
void init_QScrollBar(PyObject *module);
void init_QFrame(PyObject *module);
void init_QLabel(PyObject *module);
void init_QLCDNumber(PyObject *module);
void init_QAbstractScrollArea(PyObject *module);
void init_QTextEdit(PyObject *module);
void init_QTextEdit_ExtraSelection(PyObject *enclosingClass);
void init_QTextBrowser(PyObject *module);
void init_QAbstractItemView(PyObject *module);
void init_QHeaderView(PyObject *module);
void init_QTableView(PyObject *module);
void init_QTableWidget(PyObject *module);
void init_QColumnView(PyObject *module);
void init_QTreeView(PyObject *module);
void init_QTreeWidget(PyObject *module);
void init_QListView(PyObject *module);
void init_QUndoView(PyObject *module);
void init_QListWidget(PyObject *module);
void init_QScrollArea(PyObject *module);
void init_QMdiArea(PyObject *module);
void init_QGraphicsView(PyObject *module);
void init_QPlainTextEdit(PyObject *module);
void init_QStackedWidget(PyObject *module);
void init_QToolBox(PyObject *module);
void init_QSplitter(PyObject *module);
void init_QStyleOptionFrame(PyObject *module);
void init_QProgressBar(PyObject *module);
void init_QAbstractButton(PyObject *module);
void init_QRadioButton(PyObject *module);
void init_QPushButton(PyObject *module);
void init_QCommandLinkButton(PyObject *module);
void init_QCheckBox(PyObject *module);
void init_QToolButton(PyObject *module);
void init_QFocusFrame(PyObject *module);
void init_QOpenGLWidget(PyObject *module);
void init_QToolBar(PyObject *module);
void init_QMenuBar(PyObject *module);
void init_QMenu(PyObject *module);
void init_QDockWidget(PyObject *module);
void init_QMdiSubWindow(PyObject *module);
void init_QDialogButtonBox(PyObject *module);
void init_QMainWindow(PyObject *module);
void init_QDialog(PyObject *module);
void init_QMessageBox(PyObject *module);
void init_QFontDialog(PyObject *module);
void init_QInputDialog(PyObject *module);
void init_QErrorMessage(PyObject *module);
void init_QColorDialog(PyObject *module);
void init_QProgressDialog(PyObject *module);
void init_QWizard(PyObject *module);
void init_QUndoStack(PyObject *module);
void init_QPlainTextDocumentLayout(PyObject *module);
void init_QGraphicsObject(PyObject *module);
void init_QGraphicsWidget(PyObject *module);
void init_QGraphicsProxyWidget(PyObject *module);
void init_QGraphicsTextItem(PyObject *module);
void init_QUndoGroup(PyObject *module);
void init_QGraphicsItemAnimation(PyObject *module);
void init_QGraphicsEffect(PyObject *module);
void init_QGraphicsOpacityEffect(PyObject *module);
void init_QGraphicsDropShadowEffect(PyObject *module);
void init_QGraphicsColorizeEffect(PyObject *module);
void init_QGraphicsBlurEffect(PyObject *module);
void init_QGraphicsAnchor(PyObject *module);
void init_QGesture(PyObject *module);
void init_QPinchGesture(PyObject *module);
void init_QPanGesture(PyObject *module);
void init_QTapGesture(PyObject *module);
void init_QTapAndHoldGesture(PyObject *module);
void init_QSwipeGesture(PyObject *module);
void init_QSystemTrayIcon(PyObject *module);
void init_QDataWidgetMapper(PyObject *module);
void init_QCompleter(PyObject *module);
void init_QButtonGroup(PyObject *module);
void init_QGestureEvent(PyObject *module);
void init_QGraphicsSceneEvent(PyObject *module);
void init_QGraphicsSceneWheelEvent(PyObject *module);
void init_QGraphicsSceneResizeEvent(PyObject *module);
void init_QGraphicsSceneMoveEvent(PyObject *module);
void init_QGraphicsSceneMouseEvent(PyObject *module);
void init_QGraphicsSceneHoverEvent(PyObject *module);
void init_QGraphicsSceneHelpEvent(PyObject *module);
void init_QGraphicsSceneDragDropEvent(PyObject *module);
void init_QGraphicsSceneContextMenuEvent(PyObject *module);
void init_QApplication(PyObject *module);
void init_QFileDialog(PyObject *module);
void init_QKeyEventTransition(PyObject *module);
void init_QMouseEventTransition(PyObject *module);
void init_QFileSystemModel(PyObject *module);
void init_QDirModel(PyObject *module);

// Required modules' type and converter arrays.
PyTypeObject **SbkPySide2_QtGuiTypes;
SbkConverter **SbkPySide2_QtGuiTypeConverters;
PyTypeObject **SbkPySide2_QtCoreTypes;
SbkConverter **SbkPySide2_QtCoreTypeConverters;

// Module initialization ------------------------------------------------------------
// Container Type converters.

// C++ to Python conversion for type 'QList<QAction* >'.
static PyObject *_QList_QActionPTR__CppToPython__QList_QActionPTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QAction* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QAction* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QAction* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QActionPTR__PythonToCpp__QList_QActionPTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QAction* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QAction* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QActionPTR__PythonToCpp__QList_QActionPTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX], pyIn))
        return _QList_QActionPTR__PythonToCpp__QList_QActionPTR_;
    return {};
}

// C++ to Python conversion for type 'QList<QGraphicsItem* >'.
static PyObject *_QList_QGraphicsItemPTR__CppToPython__QList_QGraphicsItemPTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QGraphicsItem* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QGraphicsItem* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QGraphicsItem* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSITEM_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QGraphicsItemPTR__PythonToCpp__QList_QGraphicsItemPTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QGraphicsItem* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QGraphicsItem* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSITEM_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QGraphicsItemPTR__PythonToCpp__QList_QGraphicsItemPTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSITEM_IDX], pyIn))
        return _QList_QGraphicsItemPTR__PythonToCpp__QList_QGraphicsItemPTR_;
    return {};
}

// C++ to Python conversion for type 'const QList<QGraphicsTransform* > &'.
static PyObject *_constQList_QGraphicsTransformPTR_REF_CppToPython__constQList_QGraphicsTransformPTR_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QGraphicsTransform* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QGraphicsTransform* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QGraphicsTransform* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSTRANSFORM_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _constQList_QGraphicsTransformPTR_REF_PythonToCpp__constQList_QGraphicsTransformPTR_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QGraphicsTransform* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QGraphicsTransform* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSTRANSFORM_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__constQList_QGraphicsTransformPTR_REF_PythonToCpp__constQList_QGraphicsTransformPTR_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSTRANSFORM_IDX], pyIn))
        return _constQList_QGraphicsTransformPTR_REF_PythonToCpp__constQList_QGraphicsTransformPTR_REF;
    return {};
}

// C++ to Python conversion for type 'const QList<QObject* > &'.
static PyObject *_constQList_QObjectPTR_REF_CppToPython__constQList_QObjectPTR_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QObject* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QObject* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QObject* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QObject* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QObject* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX], pyIn))
        return _constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF;
    return {};
}

// C++ to Python conversion for type 'QList<QByteArray >'.
static PyObject *_QList_QByteArray__CppToPython__QList_QByteArray_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QByteArray > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QByteArray >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QByteArray cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QByteArray__PythonToCpp__QList_QByteArray_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QByteArray > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QByteArray cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QByteArray__PythonToCpp__QList_QByteArray__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pyIn))
        return _QList_QByteArray__PythonToCpp__QList_QByteArray_;
    return {};
}

// C++ to Python conversion for type 'QVector<int >'.
static PyObject *_QVector_int__CppToPython__QVector_int_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<int > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<int >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<int >::size_type idx = 0; idx < vectorSize; ++idx) {
        int cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _QVector_int__PythonToCpp__QVector_int_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<int > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        int cppItem;
        Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__QVector_int__PythonToCpp__QVector_int__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyIn))
        return _QVector_int__PythonToCpp__QVector_int_;
    return {};
}

// C++ to Python conversion for type 'QList<QWidget* >'.
static PyObject *_QList_QWidgetPTR__CppToPython__QList_QWidgetPTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QWidget* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QWidget* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QWidget* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QWidgetPTR__PythonToCpp__QList_QWidgetPTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QWidget* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QWidget* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QWidgetPTR__PythonToCpp__QList_QWidgetPTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX], pyIn))
        return _QList_QWidgetPTR__PythonToCpp__QList_QWidgetPTR_;
    return {};
}

// C++ to Python conversion for type 'QPair<QAccessibleInterface*,QFlags<QAccessible::RelationFlag> >'.
static PyObject *_QPair_QAccessibleInterfacePTR_QFlags_QAccessible_RelationFlag___CppToPython__QPair_QAccessibleInterfacePTR_QFlags_QAccessible_RelationFlag__(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QPair<QAccessibleInterface*,QFlags<QAccessible::RelationFlag> > *>(const_cast<void *>(cppIn));
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (return-qpair)]
    PyObject *pyOut = PyTuple_New(2);
    PyTuple_SET_ITEM(pyOut, 0, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLEINTERFACE_IDX]), cppInRef.first));
    PyTuple_SET_ITEM(pyOut, 1, Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QACCESSIBLE_RELATIONFLAG_IDX])->converter, &cppInRef.second));
    return pyOut;
    // END of custom code block [file: ../glue/qtcore.cpp (return-qpair)]
    // ========================================================================

}
static void _QPair_QAccessibleInterfacePTR_QFlags_QAccessible_RelationFlag___PythonToCpp__QPair_QAccessibleInterfacePTR_QFlags_QAccessible_RelationFlag__(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QPair<QAccessibleInterface*,QFlags<QAccessible::RelationFlag> > *>(cppOut);
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (conversion-qpair-pysequence)]
    Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLEINTERFACE_IDX]), PySequence_Fast_GET_ITEM(pyIn, 0), &(cppOutRef.first));
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QACCESSIBLE_RELATIONFLAG_IDX])->converter, PySequence_Fast_GET_ITEM(pyIn, 1), &(cppOutRef.second));
    // END of custom code block [file: ../glue/qtcore.cpp (conversion-qpair-pysequence)]
    // ========================================================================

}
static PythonToCppFunc is__QPair_QAccessibleInterfacePTR_QFlags_QAccessible_RelationFlag___PythonToCpp__QPair_QAccessibleInterfacePTR_QFlags_QAccessible_RelationFlag___Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertiblePairTypes(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QACCESSIBLEINTERFACE_IDX])->converter, true, *PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QACCESSIBLE_RELATIONFLAG_IDX])->converter, false, pyIn))
        return _QPair_QAccessibleInterfacePTR_QFlags_QAccessible_RelationFlag___PythonToCpp__QPair_QAccessibleInterfacePTR_QFlags_QAccessible_RelationFlag__;
    return {};
}

// C++ to Python conversion for type 'QVector<QPair< QAccessibleInterface*,QFlags<QAccessible::RelationFlag> > >'.
static PyObject *_QVector_QPair_QAccessibleInterfacePTR_QFlags_QAccessible_RelationFlag____CppToPython__QVector_QPair_QAccessibleInterfacePTR_QFlags_QAccessible_RelationFlag___(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<QPair< QAccessibleInterface*,QFlags<QAccessible::RelationFlag> > > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<QPair< QAccessibleInterface*,QFlags<QAccessible::RelationFlag> > >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<QPair< QAccessibleInterface*,QFlags<QAccessible::RelationFlag> > >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::QPair<QAccessibleInterface*,QFlags<QAccessible::RelationFlag> > cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QPAIR_QACCESSIBLEINTERFACEPTR_QFLAGS_QACCESSIBLE_RELATIONFLAG_IDX], &cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _QVector_QPair_QAccessibleInterfacePTR_QFlags_QAccessible_RelationFlag____PythonToCpp__QVector_QPair_QAccessibleInterfacePTR_QFlags_QAccessible_RelationFlag___(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<QPair< QAccessibleInterface*,QFlags<QAccessible::RelationFlag> > > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QPair<QAccessibleInterface*,QFlags<QAccessible::RelationFlag> > cppItem;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QPAIR_QACCESSIBLEINTERFACEPTR_QFLAGS_QACCESSIBLE_RELATIONFLAG_IDX], pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__QVector_QPair_QAccessibleInterfacePTR_QFlags_QAccessible_RelationFlag____PythonToCpp__QVector_QPair_QAccessibleInterfacePTR_QFlags_QAccessible_RelationFlag____Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QPAIR_QACCESSIBLEINTERFACEPTR_QFLAGS_QACCESSIBLE_RELATIONFLAG_IDX], pyIn))
        return _QVector_QPair_QAccessibleInterfacePTR_QFlags_QAccessible_RelationFlag____PythonToCpp__QVector_QPair_QAccessibleInterfacePTR_QFlags_QAccessible_RelationFlag___;
    return {};
}

// C++ to Python conversion for type 'QList<QGraphicsWidget* >'.
static PyObject *_QList_QGraphicsWidgetPTR__CppToPython__QList_QGraphicsWidgetPTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QGraphicsWidget* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QGraphicsWidget* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QGraphicsWidget* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSWIDGET_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QGraphicsWidgetPTR__PythonToCpp__QList_QGraphicsWidgetPTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QGraphicsWidget* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QGraphicsWidget* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSWIDGET_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QGraphicsWidgetPTR__PythonToCpp__QList_QGraphicsWidgetPTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSWIDGET_IDX], pyIn))
        return _QList_QGraphicsWidgetPTR__PythonToCpp__QList_QGraphicsWidgetPTR_;
    return {};
}

// C++ to Python conversion for type 'const QList<QKeySequence > &'.
static PyObject *_constQList_QKeySequence_REF_CppToPython__constQList_QKeySequence_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QKeySequence > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QKeySequence >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QKeySequence cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _constQList_QKeySequence_REF_PythonToCpp__constQList_QKeySequence_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QKeySequence > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QKeySequence cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__constQList_QKeySequence_REF_PythonToCpp__constQList_QKeySequence_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYSEQUENCE_IDX]), pyIn))
        return _constQList_QKeySequence_REF_PythonToCpp__constQList_QKeySequence_REF;
    return {};
}

// C++ to Python conversion for type 'QList<QWindow* >'.
static PyObject *_QList_QWindowPTR__CppToPython__QList_QWindowPTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QWindow* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QWindow* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QWindow* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QWINDOW_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QWindowPTR__PythonToCpp__QList_QWindowPTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QWindow* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QWindow* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QWINDOW_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QWindowPTR__PythonToCpp__QList_QWindowPTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtGuiTypes[SBK_QWINDOW_IDX], pyIn))
        return _QList_QWindowPTR__PythonToCpp__QList_QWindowPTR_;
    return {};
}

// C++ to Python conversion for type 'QList<QScreen* >'.
static PyObject *_QList_QScreenPTR__CppToPython__QList_QScreenPTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QScreen* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QScreen* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QScreen* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSCREEN_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QScreenPTR__PythonToCpp__QList_QScreenPTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QScreen* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QScreen* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSCREEN_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QScreenPTR__PythonToCpp__QList_QScreenPTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtGuiTypes[SBK_QSCREEN_IDX], pyIn))
        return _QList_QScreenPTR__PythonToCpp__QList_QScreenPTR_;
    return {};
}

// C++ to Python conversion for type 'QList<QAbstractButton* >'.
static PyObject *_QList_QAbstractButtonPTR__CppToPython__QList_QAbstractButtonPTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QAbstractButton* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QAbstractButton* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QAbstractButton* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTBUTTON_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QAbstractButtonPTR__PythonToCpp__QList_QAbstractButtonPTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QAbstractButton* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QAbstractButton* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTBUTTON_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QAbstractButtonPTR__PythonToCpp__QList_QAbstractButtonPTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTBUTTON_IDX], pyIn))
        return _QList_QAbstractButtonPTR__PythonToCpp__QList_QAbstractButtonPTR_;
    return {};
}

// C++ to Python conversion for type 'QMap<QDate,QTextCharFormat >'.
static PyObject *_QMap_QDate_QTextCharFormat__CppToPython__QMap_QDate_QTextCharFormat_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QMap<QDate,QTextCharFormat > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppmap_to_pymap_conversion - START
    PyObject *pyOut = PyDict_New();
    for (::QMap<QDate,QTextCharFormat >::const_iterator it = cppInRef.begin(), end = cppInRef.end(); it != end; ++it) {
        ::QDate key = it.key();
        ::QTextCharFormat value = it.value();
        PyObject *pyKey = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX]), &key);
        PyObject *pyValue = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX]), &value);
        PyDict_SetItem(pyOut, pyKey, pyValue);
        Py_DECREF(pyKey);
        Py_DECREF(pyValue);
    }
    return pyOut;
    // TEMPLATE - cppmap_to_pymap_conversion - END

}
static void _QMap_QDate_QTextCharFormat__PythonToCpp__QMap_QDate_QTextCharFormat_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QMap<QDate,QTextCharFormat > *>(cppOut);
    // TEMPLATE - pydict_to_cppmap_conversion - START
    PyObject *key;
    PyObject *value;
    Py_ssize_t pos = 0;
    while (PyDict_Next(pyIn, &pos, &key, &value)) {
        ::QDate cppKey;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX]), key, &(cppKey));
        ::QTextCharFormat cppValue;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX]), value, &(cppValue));
        cppOutRef.insert(cppKey, cppValue);
    }
    // TEMPLATE - pydict_to_cppmap_conversion - END

}
static PythonToCppFunc is__QMap_QDate_QTextCharFormat__PythonToCpp__QMap_QDate_QTextCharFormat__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleDictTypes(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QDATE_IDX])->converter, false, *PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX])->converter, false, pyIn))
        return _QMap_QDate_QTextCharFormat__PythonToCpp__QMap_QDate_QTextCharFormat_;
    return {};
}

// C++ to Python conversion for type 'const QVector<QColor >'.
static PyObject *_constQVector_QColor__CppToPython__constQVector_QColor_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<QColor > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<QColor >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<QColor >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::QColor cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _constQVector_QColor__PythonToCpp__constQVector_QColor_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<QColor > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QColor cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__constQVector_QColor__PythonToCpp__constQVector_QColor__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pyIn))
        return _constQVector_QColor__PythonToCpp__constQVector_QColor_;
    return {};
}

// C++ to Python conversion for type 'QList<int >'.
static PyObject *_QList_int__CppToPython__QList_int_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<int > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<int >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        int cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_int__PythonToCpp__QList_int_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<int > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        int cppItem;
        Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_int__PythonToCpp__QList_int__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyIn))
        return _QList_int__PythonToCpp__QList_int_;
    return {};
}

// C++ to Python conversion for type 'const QHash<int,QByteArray > &'.
static PyObject *_constQHash_int_QByteArray_REF_CppToPython__constQHash_int_QByteArray_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QHash<int,QByteArray > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppmap_to_pymap_conversion - START
    PyObject *pyOut = PyDict_New();
    for (::QHash<int,QByteArray >::const_iterator it = cppInRef.begin(), end = cppInRef.end(); it != end; ++it) {
        int key = it.key();
        ::QByteArray value = it.value();
        PyObject *pyKey = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &key);
        PyObject *pyValue = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &value);
        PyDict_SetItem(pyOut, pyKey, pyValue);
        Py_DECREF(pyKey);
        Py_DECREF(pyValue);
    }
    return pyOut;
    // TEMPLATE - cppmap_to_pymap_conversion - END

}
static void _constQHash_int_QByteArray_REF_PythonToCpp__constQHash_int_QByteArray_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QHash<int,QByteArray > *>(cppOut);
    // TEMPLATE - pydict_to_cppmap_conversion - START
    PyObject *key;
    PyObject *value;
    Py_ssize_t pos = 0;
    while (PyDict_Next(pyIn, &pos, &key, &value)) {
        int cppKey;
        Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<int>(), key, &(cppKey));
        ::QByteArray cppValue;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), value, &(cppValue));
        cppOutRef.insert(cppKey, cppValue);
    }
    // TEMPLATE - pydict_to_cppmap_conversion - END

}
static PythonToCppFunc is__constQHash_int_QByteArray_REF_PythonToCpp__constQHash_int_QByteArray_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleDictTypes(Shiboken::Conversions::PrimitiveTypeConverter<int>(), false, *PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX])->converter, false, pyIn))
        return _constQHash_int_QByteArray_REF_PythonToCpp__constQHash_int_QByteArray_REF;
    return {};
}

// C++ to Python conversion for type 'QMap<int,QVariant >'.
static PyObject *_QMap_int_QVariant__CppToPython__QMap_int_QVariant_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QMap<int,QVariant > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppmap_to_pymap_conversion - START
    PyObject *pyOut = PyDict_New();
    for (::QMap<int,QVariant >::const_iterator it = cppInRef.begin(), end = cppInRef.end(); it != end; ++it) {
        int key = it.key();
        ::QVariant value = it.value();
        PyObject *pyKey = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &key);
        PyObject *pyValue = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &value);
        PyDict_SetItem(pyOut, pyKey, pyValue);
        Py_DECREF(pyKey);
        Py_DECREF(pyValue);
    }
    return pyOut;
    // TEMPLATE - cppmap_to_pymap_conversion - END

}
static void _QMap_int_QVariant__PythonToCpp__QMap_int_QVariant_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QMap<int,QVariant > *>(cppOut);
    // TEMPLATE - pydict_to_cppmap_conversion - START
    PyObject *key;
    PyObject *value;
    Py_ssize_t pos = 0;
    while (PyDict_Next(pyIn, &pos, &key, &value)) {
        int cppKey;
        Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<int>(), key, &(cppKey));
        ::QVariant cppValue;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], value, &(cppValue));
        cppOutRef.insert(cppKey, cppValue);
    }
    // TEMPLATE - pydict_to_cppmap_conversion - END

}
static PythonToCppFunc is__QMap_int_QVariant__PythonToCpp__QMap_int_QVariant__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleDictTypes(Shiboken::Conversions::PrimitiveTypeConverter<int>(), false, SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], false, pyIn))
        return _QMap_int_QVariant__PythonToCpp__QMap_int_QVariant_;
    return {};
}

// C++ to Python conversion for type 'const QList<QPersistentModelIndex > &'.
static PyObject *_constQList_QPersistentModelIndex_REF_CppToPython__constQList_QPersistentModelIndex_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QPersistentModelIndex > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QPersistentModelIndex >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QPersistentModelIndex cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPERSISTENTMODELINDEX_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _constQList_QPersistentModelIndex_REF_PythonToCpp__constQList_QPersistentModelIndex_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QPersistentModelIndex > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QPersistentModelIndex cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPERSISTENTMODELINDEX_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__constQList_QPersistentModelIndex_REF_PythonToCpp__constQList_QPersistentModelIndex_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPERSISTENTMODELINDEX_IDX]), pyIn))
        return _constQList_QPersistentModelIndex_REF_PythonToCpp__constQList_QPersistentModelIndex_REF;
    return {};
}

// C++ to Python conversion for type 'QList<QUrl >'.
static PyObject *_QList_QUrl__CppToPython__QList_QUrl_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QUrl > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QUrl >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QUrl cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QUrl__PythonToCpp__QList_QUrl_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QUrl > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QUrl cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QUrl__PythonToCpp__QList_QUrl__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pyIn))
        return _QList_QUrl__PythonToCpp__QList_QUrl_;
    return {};
}

// C++ to Python conversion for type 'const QList<QGesture* > &'.
static PyObject *_constQList_QGesturePTR_REF_CppToPython__constQList_QGesturePTR_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QGesture* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QGesture* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QGesture* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGESTURE_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _constQList_QGesturePTR_REF_PythonToCpp__constQList_QGesturePTR_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QGesture* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QGesture* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGESTURE_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__constQList_QGesturePTR_REF_PythonToCpp__constQList_QGesturePTR_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtWidgetsTypes[SBK_QGESTURE_IDX], pyIn))
        return _constQList_QGesturePTR_REF_PythonToCpp__constQList_QGesturePTR_REF;
    return {};
}

// C++ to Python conversion for type 'QPair<qreal,QPointF >'.
static PyObject *_QPair_qreal_QPointF__CppToPython__QPair_qreal_QPointF_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QPair<qreal,QPointF > *>(const_cast<void *>(cppIn));
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (return-qpair)]
    PyObject *pyOut = PyTuple_New(2);
    PyTuple_SET_ITEM(pyOut, 0, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppInRef.first));
    PyTuple_SET_ITEM(pyOut, 1, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &cppInRef.second));
    return pyOut;
    // END of custom code block [file: ../glue/qtcore.cpp (return-qpair)]
    // ========================================================================

}
static void _QPair_qreal_QPointF__PythonToCpp__QPair_qreal_QPointF_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QPair<qreal,QPointF > *>(cppOut);
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (conversion-qpair-pysequence)]
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), PySequence_Fast_GET_ITEM(pyIn, 0), &(cppOutRef.first));
    Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), PySequence_Fast_GET_ITEM(pyIn, 1), &(cppOutRef.second));
    // END of custom code block [file: ../glue/qtcore.cpp (conversion-qpair-pysequence)]
    // ========================================================================

}
static PythonToCppFunc is__QPair_qreal_QPointF__PythonToCpp__QPair_qreal_QPointF__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertiblePairTypes(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), false, *PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX])->converter, false, pyIn))
        return _QPair_qreal_QPointF__PythonToCpp__QPair_qreal_QPointF_;
    return {};
}

// C++ to Python conversion for type 'QList<QPair< qreal,QPointF > >'.
static PyObject *_QList_QPair_qreal_QPointF___CppToPython__QList_QPair_qreal_QPointF__(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QPair< qreal,QPointF > > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QPair< qreal,QPointF > >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QPair<qreal,QPointF > cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QPAIR_QREAL_QPOINTF_IDX], &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QPair_qreal_QPointF___PythonToCpp__QList_QPair_qreal_QPointF__(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QPair< qreal,QPointF > > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QPair<qreal,QPointF > cppItem;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QPAIR_QREAL_QPOINTF_IDX], pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QPair_qreal_QPointF___PythonToCpp__QList_QPair_qreal_QPointF___Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QPAIR_QREAL_QPOINTF_IDX], pyIn))
        return _QList_QPair_qreal_QPointF___PythonToCpp__QList_QPair_qreal_QPointF__;
    return {};
}

// C++ to Python conversion for type 'QPair<qreal,qreal >'.
static PyObject *_QPair_qreal_qreal__CppToPython__QPair_qreal_qreal_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QPair<qreal,qreal > *>(const_cast<void *>(cppIn));
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (return-qpair)]
    PyObject *pyOut = PyTuple_New(2);
    PyTuple_SET_ITEM(pyOut, 0, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppInRef.first));
    PyTuple_SET_ITEM(pyOut, 1, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppInRef.second));
    return pyOut;
    // END of custom code block [file: ../glue/qtcore.cpp (return-qpair)]
    // ========================================================================

}
static void _QPair_qreal_qreal__PythonToCpp__QPair_qreal_qreal_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QPair<qreal,qreal > *>(cppOut);
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (conversion-qpair-pysequence)]
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), PySequence_Fast_GET_ITEM(pyIn, 0), &(cppOutRef.first));
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), PySequence_Fast_GET_ITEM(pyIn, 1), &(cppOutRef.second));
    // END of custom code block [file: ../glue/qtcore.cpp (conversion-qpair-pysequence)]
    // ========================================================================

}
static PythonToCppFunc is__QPair_qreal_qreal__PythonToCpp__QPair_qreal_qreal__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertiblePairTypes(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), false, Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), false, pyIn))
        return _QPair_qreal_qreal__PythonToCpp__QPair_qreal_qreal_;
    return {};
}

// C++ to Python conversion for type 'QList<QPair< qreal,qreal > >'.
static PyObject *_QList_QPair_qreal_qreal___CppToPython__QList_QPair_qreal_qreal__(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QPair< qreal,qreal > > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QPair< qreal,qreal > >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QPair<qreal,qreal > cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QPAIR_QREAL_QREAL_IDX], &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QPair_qreal_qreal___PythonToCpp__QList_QPair_qreal_qreal__(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QPair< qreal,qreal > > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QPair<qreal,qreal > cppItem;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QPAIR_QREAL_QREAL_IDX], pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QPair_qreal_qreal___PythonToCpp__QList_QPair_qreal_qreal___Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QPAIR_QREAL_QREAL_IDX], pyIn))
        return _QList_QPair_qreal_qreal___PythonToCpp__QList_QPair_qreal_qreal__;
    return {};
}

// C++ to Python conversion for type 'const QList<QRectF > &'.
static PyObject *_constQList_QRectF_REF_CppToPython__constQList_QRectF_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QRectF > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QRectF >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QRectF cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _constQList_QRectF_REF_PythonToCpp__constQList_QRectF_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QRectF > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QRectF cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__constQList_QRectF_REF_PythonToCpp__constQList_QRectF_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pyIn))
        return _constQList_QRectF_REF_PythonToCpp__constQList_QRectF_REF;
    return {};
}

// C++ to Python conversion for type 'QList<QGraphicsView* >'.
static PyObject *_QList_QGraphicsViewPTR__CppToPython__QList_QGraphicsViewPTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QGraphicsView* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QGraphicsView* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QGraphicsView* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSVIEW_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QGraphicsViewPTR__PythonToCpp__QList_QGraphicsViewPTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QGraphicsView* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QGraphicsView* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSVIEW_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QGraphicsViewPTR__PythonToCpp__QList_QGraphicsViewPTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSVIEW_IDX], pyIn))
        return _QList_QGraphicsViewPTR__PythonToCpp__QList_QGraphicsViewPTR_;
    return {};
}

// C++ to Python conversion for type 'QList<QListWidgetItem* >'.
static PyObject *_QList_QListWidgetItemPTR__CppToPython__QList_QListWidgetItemPTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QListWidgetItem* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QListWidgetItem* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QListWidgetItem* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QLISTWIDGETITEM_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QListWidgetItemPTR__PythonToCpp__QList_QListWidgetItemPTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QListWidgetItem* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QListWidgetItem* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QLISTWIDGETITEM_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QListWidgetItemPTR__PythonToCpp__QList_QListWidgetItemPTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtWidgetsTypes[SBK_QLISTWIDGETITEM_IDX], pyIn))
        return _QList_QListWidgetItemPTR__PythonToCpp__QList_QListWidgetItemPTR_;
    return {};
}

// C++ to Python conversion for type 'const QList<QDockWidget* > &'.
static PyObject *_constQList_QDockWidgetPTR_REF_CppToPython__constQList_QDockWidgetPTR_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QDockWidget* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QDockWidget* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QDockWidget* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QDOCKWIDGET_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _constQList_QDockWidgetPTR_REF_PythonToCpp__constQList_QDockWidgetPTR_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QDockWidget* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QDockWidget* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QDOCKWIDGET_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__constQList_QDockWidgetPTR_REF_PythonToCpp__constQList_QDockWidgetPTR_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtWidgetsTypes[SBK_QDOCKWIDGET_IDX], pyIn))
        return _constQList_QDockWidgetPTR_REF_PythonToCpp__constQList_QDockWidgetPTR_REF;
    return {};
}

// C++ to Python conversion for type 'QList<QMdiSubWindow* >'.
static PyObject *_QList_QMdiSubWindowPTR__CppToPython__QList_QMdiSubWindowPTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QMdiSubWindow* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QMdiSubWindow* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QMdiSubWindow* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QMDISUBWINDOW_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QMdiSubWindowPTR__PythonToCpp__QList_QMdiSubWindowPTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QMdiSubWindow* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QMdiSubWindow* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QMDISUBWINDOW_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QMdiSubWindowPTR__PythonToCpp__QList_QMdiSubWindowPTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtWidgetsTypes[SBK_QMDISUBWINDOW_IDX], pyIn))
        return _QList_QMdiSubWindowPTR__PythonToCpp__QList_QMdiSubWindowPTR_;
    return {};
}

// C++ to Python conversion for type 'QList<QTextEdit::ExtraSelection >'.
static PyObject *_QList_QTextEdit_ExtraSelection__CppToPython__QList_QTextEdit_ExtraSelection_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QTextEdit::ExtraSelection > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QTextEdit::ExtraSelection >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QTextEdit::ExtraSelection cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QTEXTEDIT_EXTRASELECTION_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QTextEdit_ExtraSelection__PythonToCpp__QList_QTextEdit_ExtraSelection_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QTextEdit::ExtraSelection > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QTextEdit::ExtraSelection cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QTEXTEDIT_EXTRASELECTION_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QTextEdit_ExtraSelection__PythonToCpp__QList_QTextEdit_ExtraSelection__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QTEXTEDIT_EXTRASELECTION_IDX]), pyIn))
        return _QList_QTextEdit_ExtraSelection__PythonToCpp__QList_QTextEdit_ExtraSelection_;
    return {};
}

// C++ to Python conversion for type 'QList<QScroller* >'.
static PyObject *_QList_QScrollerPTR__CppToPython__QList_QScrollerPTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QScroller* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QScroller* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QScroller* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLER_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QScrollerPTR__PythonToCpp__QList_QScrollerPTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QScroller* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QScroller* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLER_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QScrollerPTR__PythonToCpp__QList_QScrollerPTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLER_IDX], pyIn))
        return _QList_QScrollerPTR__PythonToCpp__QList_QScrollerPTR_;
    return {};
}

// C++ to Python conversion for type 'const QList<qreal > &'.
static PyObject *_constQList_qreal_REF_CppToPython__constQList_qreal_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<qreal > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<qreal >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        qreal cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _constQList_qreal_REF_PythonToCpp__constQList_qreal_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<qreal > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        qreal cppItem;
        Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__constQList_qreal_REF_PythonToCpp__constQList_qreal_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), pyIn))
        return _constQList_qreal_REF_PythonToCpp__constQList_qreal_REF;
    return {};
}

// C++ to Python conversion for type 'const QVector<QLine > &'.
static PyObject *_constQVector_QLine_REF_CppToPython__constQVector_QLine_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<QLine > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<QLine >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<QLine >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::QLine cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLINE_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _constQVector_QLine_REF_PythonToCpp__constQVector_QLine_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<QLine > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QLine cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLINE_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__constQVector_QLine_REF_PythonToCpp__constQVector_QLine_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLINE_IDX]), pyIn))
        return _constQVector_QLine_REF_PythonToCpp__constQVector_QLine_REF;
    return {};
}

// C++ to Python conversion for type 'const QVector<QLineF > &'.
static PyObject *_constQVector_QLineF_REF_CppToPython__constQVector_QLineF_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<QLineF > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<QLineF >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<QLineF >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::QLineF cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _constQVector_QLineF_REF_PythonToCpp__constQVector_QLineF_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<QLineF > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QLineF cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__constQVector_QLineF_REF_PythonToCpp__constQVector_QLineF_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLINEF_IDX]), pyIn))
        return _constQVector_QLineF_REF_PythonToCpp__constQVector_QLineF_REF;
    return {};
}

// C++ to Python conversion for type 'const QVector<QPoint > &'.
static PyObject *_constQVector_QPoint_REF_CppToPython__constQVector_QPoint_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<QPoint > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<QPoint >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<QPoint >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::QPoint cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _constQVector_QPoint_REF_PythonToCpp__constQVector_QPoint_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<QPoint > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QPoint cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__constQVector_QPoint_REF_PythonToCpp__constQVector_QPoint_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), pyIn))
        return _constQVector_QPoint_REF_PythonToCpp__constQVector_QPoint_REF;
    return {};
}

// C++ to Python conversion for type 'const QVector<QPointF > &'.
static PyObject *_constQVector_QPointF_REF_CppToPython__constQVector_QPointF_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<QPointF > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<QPointF >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<QPointF >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::QPointF cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _constQVector_QPointF_REF_PythonToCpp__constQVector_QPointF_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<QPointF > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QPointF cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__constQVector_QPointF_REF_PythonToCpp__constQVector_QPointF_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pyIn))
        return _constQVector_QPointF_REF_PythonToCpp__constQVector_QPointF_REF;
    return {};
}

// C++ to Python conversion for type 'const QVector<QRect > &'.
static PyObject *_constQVector_QRect_REF_CppToPython__constQVector_QRect_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<QRect > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<QRect >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<QRect >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::QRect cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _constQVector_QRect_REF_PythonToCpp__constQVector_QRect_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<QRect > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QRect cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__constQVector_QRect_REF_PythonToCpp__constQVector_QRect_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pyIn))
        return _constQVector_QRect_REF_PythonToCpp__constQVector_QRect_REF;
    return {};
}

// C++ to Python conversion for type 'const QVector<QRectF > &'.
static PyObject *_constQVector_QRectF_REF_CppToPython__constQVector_QRectF_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<QRectF > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<QRectF >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<QRectF >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::QRectF cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _constQVector_QRectF_REF_PythonToCpp__constQVector_QRectF_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<QRectF > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QRectF cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__constQVector_QRectF_REF_PythonToCpp__constQVector_QRectF_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pyIn))
        return _constQVector_QRectF_REF_PythonToCpp__constQVector_QRectF_REF;
    return {};
}

// C++ to Python conversion for type 'QList<QTableWidgetItem* >'.
static PyObject *_QList_QTableWidgetItemPTR__CppToPython__QList_QTableWidgetItemPTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QTableWidgetItem* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QTableWidgetItem* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QTableWidgetItem* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QTABLEWIDGETITEM_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QTableWidgetItemPTR__PythonToCpp__QList_QTableWidgetItemPTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QTableWidgetItem* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QTableWidgetItem* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QTABLEWIDGETITEM_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QTableWidgetItemPTR__PythonToCpp__QList_QTableWidgetItemPTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtWidgetsTypes[SBK_QTABLEWIDGETITEM_IDX], pyIn))
        return _QList_QTableWidgetItemPTR__PythonToCpp__QList_QTableWidgetItemPTR_;
    return {};
}

// C++ to Python conversion for type 'QList<QTableWidgetSelectionRange >'.
static PyObject *_QList_QTableWidgetSelectionRange__CppToPython__QList_QTableWidgetSelectionRange_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QTableWidgetSelectionRange > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QTableWidgetSelectionRange >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QTableWidgetSelectionRange cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QTABLEWIDGETSELECTIONRANGE_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QTableWidgetSelectionRange__PythonToCpp__QList_QTableWidgetSelectionRange_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QTableWidgetSelectionRange > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QTableWidgetSelectionRange cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QTABLEWIDGETSELECTIONRANGE_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QTableWidgetSelectionRange__PythonToCpp__QList_QTableWidgetSelectionRange__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QTABLEWIDGETSELECTIONRANGE_IDX]), pyIn))
        return _QList_QTableWidgetSelectionRange__PythonToCpp__QList_QTableWidgetSelectionRange_;
    return {};
}

// C++ to Python conversion for type 'const QList<QTreeWidgetItem* > &'.
static PyObject *_constQList_QTreeWidgetItemPTR_REF_CppToPython__constQList_QTreeWidgetItemPTR_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QTreeWidgetItem* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QTreeWidgetItem* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QTreeWidgetItem* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QTREEWIDGETITEM_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _constQList_QTreeWidgetItemPTR_REF_PythonToCpp__constQList_QTreeWidgetItemPTR_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QTreeWidgetItem* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QTreeWidgetItem* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QTREEWIDGETITEM_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__constQList_QTreeWidgetItemPTR_REF_PythonToCpp__constQList_QTreeWidgetItemPTR_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtWidgetsTypes[SBK_QTREEWIDGETITEM_IDX], pyIn))
        return _constQList_QTreeWidgetItemPTR_REF_PythonToCpp__constQList_QTreeWidgetItemPTR_REF;
    return {};
}

// C++ to Python conversion for type 'QList<QUndoStack* >'.
static PyObject *_QList_QUndoStackPTR__CppToPython__QList_QUndoStackPTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QUndoStack* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QUndoStack* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QUndoStack* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QUNDOSTACK_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QUndoStackPTR__PythonToCpp__QList_QUndoStackPTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QUndoStack* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QUndoStack* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QUNDOSTACK_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QUndoStackPTR__PythonToCpp__QList_QUndoStackPTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtWidgetsTypes[SBK_QUNDOSTACK_IDX], pyIn))
        return _QList_QUndoStackPTR__PythonToCpp__QList_QUndoStackPTR_;
    return {};
}

// C++ to Python conversion for type 'const QList<QWizard::WizardButton > &'.
static PyObject *_constQList_QWizard_WizardButton_REF_CppToPython__constQList_QWizard_WizardButton_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QWizard::WizardButton > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QWizard::WizardButton >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QWizard::WizardButton cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QWIZARD_WIZARDBUTTON_IDX])->converter, &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _constQList_QWizard_WizardButton_REF_PythonToCpp__constQList_QWizard_WizardButton_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QWizard::WizardButton > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QWizard::WizardButton cppItem{QWizard::BackButton};
        Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QWIZARD_WIZARDBUTTON_IDX])->converter, pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__constQList_QWizard_WizardButton_REF_PythonToCpp__constQList_QWizard_WizardButton_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QWIZARD_WIZARDBUTTON_IDX])->converter, pyIn))
        return _constQList_QWizard_WizardButton_REF_PythonToCpp__constQList_QWizard_WizardButton_REF;
    return {};
}

// C++ to Python conversion for type 'QList<QVariant >'.
static PyObject *_QList_QVariant__CppToPython__QList_QVariant_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QVariant > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QVariant >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QVariant cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QVariant__PythonToCpp__QList_QVariant_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QVariant > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QVariant cppItem;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QVariant__PythonToCpp__QList_QVariant__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], pyIn))
        return _QList_QVariant__PythonToCpp__QList_QVariant_;
    return {};
}

// C++ to Python conversion for type 'QList<QString >'.
static PyObject *_QList_QString__CppToPython__QList_QString_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QString > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QString >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QString cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QString__PythonToCpp__QList_QString_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QString > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QString cppItem;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QString__PythonToCpp__QList_QString__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyIn))
        return _QList_QString__PythonToCpp__QList_QString_;
    return {};
}

// C++ to Python conversion for type 'QMap<QString,QVariant >'.
static PyObject *_QMap_QString_QVariant__CppToPython__QMap_QString_QVariant_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QMap<QString,QVariant > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppmap_to_pymap_conversion - START
    PyObject *pyOut = PyDict_New();
    for (::QMap<QString,QVariant >::const_iterator it = cppInRef.begin(), end = cppInRef.end(); it != end; ++it) {
        ::QString key = it.key();
        ::QVariant value = it.value();
        PyObject *pyKey = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &key);
        PyObject *pyValue = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &value);
        PyDict_SetItem(pyOut, pyKey, pyValue);
        Py_DECREF(pyKey);
        Py_DECREF(pyValue);
    }
    return pyOut;
    // TEMPLATE - cppmap_to_pymap_conversion - END

}
static void _QMap_QString_QVariant__PythonToCpp__QMap_QString_QVariant_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QMap<QString,QVariant > *>(cppOut);
    // TEMPLATE - pydict_to_cppmap_conversion - START
    PyObject *key;
    PyObject *value;
    Py_ssize_t pos = 0;
    while (PyDict_Next(pyIn, &pos, &key, &value)) {
        ::QString cppKey;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], key, &(cppKey));
        ::QVariant cppValue;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], value, &(cppValue));
        cppOutRef.insert(cppKey, cppValue);
    }
    // TEMPLATE - pydict_to_cppmap_conversion - END

}
static PythonToCppFunc is__QMap_QString_QVariant__PythonToCpp__QMap_QString_QVariant__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleDictTypes(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], false, SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], false, pyIn))
        return _QMap_QString_QVariant__PythonToCpp__QMap_QString_QVariant_;
    return {};
}


#ifdef IS_PY3K
static struct PyModuleDef moduledef = {
    /* m_base     */ PyModuleDef_HEAD_INIT,
    /* m_name     */ "QtWidgets",
    /* m_doc      */ nullptr,
    /* m_size     */ -1,
    /* m_methods  */ QtWidgets_methods,
    /* m_reload   */ nullptr,
    /* m_traverse */ nullptr,
    /* m_clear    */ nullptr,
    /* m_free     */ nullptr
};

#endif

// The signatures string for the global functions.
// Multiple signatures have their index "n:" in front.
static const char *QtWidgets_SignatureStrings[] = {
    nullptr}; // Sentinel

SBK_MODULE_INIT_FUNCTION_BEGIN(QtWidgets)
    {
        Shiboken::AutoDecRef requiredModule(Shiboken::Module::import("PySide2.QtGui"));
        if (requiredModule.isNull())
            return SBK_MODULE_INIT_ERROR;
        SbkPySide2_QtGuiTypes = Shiboken::Module::getTypes(requiredModule);
        SbkPySide2_QtGuiTypeConverters = Shiboken::Module::getTypeConverters(requiredModule);
    }

    {
        Shiboken::AutoDecRef requiredModule(Shiboken::Module::import("PySide2.QtCore"));
        if (requiredModule.isNull())
            return SBK_MODULE_INIT_ERROR;
        SbkPySide2_QtCoreTypes = Shiboken::Module::getTypes(requiredModule);
        SbkPySide2_QtCoreTypeConverters = Shiboken::Module::getTypeConverters(requiredModule);
    }

    // Create an array of wrapper types for the current module.
    static PyTypeObject *cppApi[SBK_QtWidgets_IDX_COUNT];
    SbkPySide2_QtWidgetsTypes = cppApi;

    // Create an array of primitive type converters for the current module.
    static SbkConverter *sbkConverters[SBK_QtWidgets_CONVERTERS_IDX_COUNT];
    SbkPySide2_QtWidgetsTypeConverters = sbkConverters;

#ifdef IS_PY3K
    PyObject *module = Shiboken::Module::create("QtWidgets", &moduledef);
#else
    PyObject *module = Shiboken::Module::create("QtWidgets", QtWidgets_methods);
#endif

    // Make module available from global scope
    SbkPySide2_QtWidgetsModuleObject = module;

    // Initialize classes in the type system
    init_QWhatsThis(module);
    init_QUndoCommand(module);
    init_QTreeWidgetItemIterator(module);
    init_QTreeWidgetItem(module);
    init_QToolTip(module);
    init_QTableWidgetSelectionRange(module);
    init_QTableWidgetItem(module);
    init_QStyleHintReturn(module);
    init_QStyleHintReturnVariant(module);
    init_QStyleFactory(module);
    init_QSizePolicy(module);
    init_QScrollerProperties(module);
    init_QListWidgetItem(module);
    init_QLayoutItem(module);
    init_QSpacerItem(module);
    init_QItemEditorFactory(module);
    init_QItemEditorCreatorBase(module);
    init_QGestureRecognizer(module);
    init_QFileIconProvider(module);
    init_QColormap(module);
    init_QStyleHintReturnMask(module);
    init_QAccessibleWidget(module);
    init_QTileRules(module);
    init_QGraphicsLayoutItem(module);
    init_QGraphicsLayout(module);
    init_QGraphicsLinearLayout(module);
    init_QGraphicsGridLayout(module);
    init_QGraphicsAnchorLayout(module);
    init_QGraphicsItem(module);
    init_QGraphicsLineItem(module);
    init_QGraphicsItemGroup(module);
    init_QAbstractGraphicsShapeItem(module);
    init_QGraphicsEllipseItem(module);
    init_QGraphicsRectItem(module);
    init_QGraphicsPolygonItem(module);
    init_QGraphicsSimpleTextItem(module);
    init_QGraphicsPathItem(module);
    init_QGraphicsPixmapItem(module);
    init_QStylePainter(module);
    init_QActionGroup(module);
    init_QStyleOption(module);
    init_QStyleOptionFocusRect(module);
    init_QStyleOptionToolBox(module);
    init_QStyleOptionDockWidget(module);
    init_QStyleOptionToolBar(module);
    init_QStyleOptionComplex(module);
    init_QStyleOptionToolButton(module);
    init_QStyleOptionTitleBar(module);
    init_QStyleOptionComboBox(module);
    init_QStyleOptionSizeGrip(module);
    init_QStyleOptionGroupBox(module);
    init_QStyleOptionButton(module);
    init_QStyleOptionProgressBar(module);
    init_QStyleOptionMenuItem(module);
    init_QStyleOptionHeader(module);
    init_QStyleOptionGraphicsItem(module);
    init_QAction(module);
    init_QWidgetAction(module);
    init_QStyle(module);
    init_QCommonStyle(module);
    init_QProxyStyle(module);
    init_QAbstractItemDelegate(module);
    init_QItemDelegate(module);
    init_QStyledItemDelegate(module);
    init_QShortcut(module);
    init_QScroller(module);
    init_QLayout(module);
    init_QFormLayout(module);
    init_QGridLayout(module);
    init_QStackedLayout(module);
    init_QBoxLayout(module);
    init_QVBoxLayout(module);
    init_QHBoxLayout(module);
    init_QGraphicsTransform(module);
    init_QGraphicsScale(module);
    init_QGraphicsRotation(module);
    init_QGraphicsScene(module);
    init_QWidget(module);
    init_QDesktopWidget(module);
    init_QStatusBar(module);
    init_QLineEdit(module);
    init_QTabWidget(module);
    init_QTabBar(module);
    init_QStyleOptionTabWidgetFrame(module);
    init_QStyleOptionTabBarBase(module);
    init_QStyleOptionTab(module);
    init_QSplitterHandle(module);
    init_QSplashScreen(module);
    init_QKeySequenceEdit(module);
    init_QComboBox(module);
    init_QFontComboBox(module);
    init_QStyleOptionViewItem(module);
    init_QWizardPage(module);
    init_QSizeGrip(module);
    init_QCalendarWidget(module);
    init_QWidgetItem(module);
    init_QGroupBox(module);
    init_QRubberBand(module);
    init_QStyleOptionRubberBand(module);
    init_QAbstractSpinBox(module);
    init_QSpinBox(module);
    init_QDateTimeEdit(module);
    init_QDateEdit(module);
    init_QTimeEdit(module);
    init_QStyleOptionSpinBox(module);
    init_QDoubleSpinBox(module);
    init_QAbstractSlider(module);
    init_QDial(module);
    init_QSlider(module);
    init_QStyleOptionSlider(module);
    init_QScrollBar(module);
    init_QFrame(module);
    init_QLabel(module);
    init_QLCDNumber(module);
    init_QAbstractScrollArea(module);
    init_QTextEdit(module);
    init_QTextEdit_ExtraSelection(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtWidgetsTypes[SBK_QTEXTEDIT_IDX])->tp_dict);
    init_QTextBrowser(module);
    init_QAbstractItemView(module);
    init_QHeaderView(module);
    init_QTableView(module);
    init_QTableWidget(module);
    init_QColumnView(module);
    init_QTreeView(module);
    init_QTreeWidget(module);
    init_QListView(module);
    init_QUndoView(module);
    init_QListWidget(module);
    init_QScrollArea(module);
    init_QMdiArea(module);
    init_QGraphicsView(module);
    init_QPlainTextEdit(module);
    init_QStackedWidget(module);
    init_QToolBox(module);
    init_QSplitter(module);
    init_QStyleOptionFrame(module);
    init_QProgressBar(module);
    init_QAbstractButton(module);
    init_QRadioButton(module);
    init_QPushButton(module);
    init_QCommandLinkButton(module);
    init_QCheckBox(module);
    init_QToolButton(module);
    init_QFocusFrame(module);
    init_QOpenGLWidget(module);
    init_QToolBar(module);
    init_QMenuBar(module);
    init_QMenu(module);
    init_QDockWidget(module);
    init_QMdiSubWindow(module);
    init_QDialogButtonBox(module);
    init_QMainWindow(module);
    init_QDialog(module);
    init_QMessageBox(module);
    init_QFontDialog(module);
    init_QInputDialog(module);
    init_QErrorMessage(module);
    init_QColorDialog(module);
    init_QProgressDialog(module);
    init_QWizard(module);
    init_QUndoStack(module);
    init_QPlainTextDocumentLayout(module);
    init_QGraphicsObject(module);
    init_QGraphicsWidget(module);
    init_QGraphicsProxyWidget(module);
    init_QGraphicsTextItem(module);
    init_QUndoGroup(module);
    init_QGraphicsItemAnimation(module);
    init_QGraphicsEffect(module);
    init_QGraphicsOpacityEffect(module);
    init_QGraphicsDropShadowEffect(module);
    init_QGraphicsColorizeEffect(module);
    init_QGraphicsBlurEffect(module);
    init_QGraphicsAnchor(module);
    init_QGesture(module);
    init_QPinchGesture(module);
    init_QPanGesture(module);
    init_QTapGesture(module);
    init_QTapAndHoldGesture(module);
    init_QSwipeGesture(module);
    init_QSystemTrayIcon(module);
    init_QDataWidgetMapper(module);
    init_QCompleter(module);
    init_QButtonGroup(module);
    init_QGestureEvent(module);
    init_QGraphicsSceneEvent(module);
    init_QGraphicsSceneWheelEvent(module);
    init_QGraphicsSceneResizeEvent(module);
    init_QGraphicsSceneMoveEvent(module);
    init_QGraphicsSceneMouseEvent(module);
    init_QGraphicsSceneHoverEvent(module);
    init_QGraphicsSceneHelpEvent(module);
    init_QGraphicsSceneDragDropEvent(module);
    init_QGraphicsSceneContextMenuEvent(module);
    init_QApplication(module);
    init_QFileDialog(module);
    init_QKeyEventTransition(module);
    init_QMouseEventTransition(module);
    init_QFileSystemModel(module);
    init_QDirModel(module);

    // Register converter for type 'QList<QAction*>'.
    SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QACTIONPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QActionPTR__CppToPython__QList_QActionPTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QACTIONPTR_IDX], "QList<QAction*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QACTIONPTR_IDX],
        _QList_QActionPTR__PythonToCpp__QList_QActionPTR_,
        is__QList_QActionPTR__PythonToCpp__QList_QActionPTR__Convertible);

    // Register converter for type 'QList<QGraphicsItem*>'.
    SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QGRAPHICSITEMPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QGraphicsItemPTR__CppToPython__QList_QGraphicsItemPTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QGRAPHICSITEMPTR_IDX], "QList<QGraphicsItem*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QGRAPHICSITEMPTR_IDX],
        _QList_QGraphicsItemPTR__PythonToCpp__QList_QGraphicsItemPTR_,
        is__QList_QGraphicsItemPTR__PythonToCpp__QList_QGraphicsItemPTR__Convertible);

    // Register converter for type 'const QList<QGraphicsTransform*>&'.
    SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QGRAPHICSTRANSFORMPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQList_QGraphicsTransformPTR_REF_CppToPython__constQList_QGraphicsTransformPTR_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QGRAPHICSTRANSFORMPTR_IDX], "const QList<QGraphicsTransform*>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QGRAPHICSTRANSFORMPTR_IDX], "QList<QGraphicsTransform*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QGRAPHICSTRANSFORMPTR_IDX],
        _constQList_QGraphicsTransformPTR_REF_PythonToCpp__constQList_QGraphicsTransformPTR_REF,
        is__constQList_QGraphicsTransformPTR_REF_PythonToCpp__constQList_QGraphicsTransformPTR_REF_Convertible);

    // Register converter for type 'const QList<QObject*>&'.
    SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QOBJECTPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQList_QObjectPTR_REF_CppToPython__constQList_QObjectPTR_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QOBJECTPTR_IDX], "const QList<QObject*>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QOBJECTPTR_IDX], "QList<QObject*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QOBJECTPTR_IDX],
        _constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF,
        is__constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF_Convertible);

    // Register converter for type 'QList<QByteArray>'.
    SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QBYTEARRAY_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QByteArray__CppToPython__QList_QByteArray_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QBYTEARRAY_IDX], "QList<QByteArray>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QBYTEARRAY_IDX],
        _QList_QByteArray__PythonToCpp__QList_QByteArray_,
        is__QList_QByteArray__PythonToCpp__QList_QByteArray__Convertible);

    // Register converter for type 'QVector<int>'.
    SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QVECTOR_INT_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QVector_int__CppToPython__QVector_int_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QVECTOR_INT_IDX], "QVector<int>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QVECTOR_INT_IDX],
        _QVector_int__PythonToCpp__QVector_int_,
        is__QVector_int__PythonToCpp__QVector_int__Convertible);

    // Register converter for type 'QList<QWidget*>'.
    SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QWIDGETPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QWidgetPTR__CppToPython__QList_QWidgetPTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QWIDGETPTR_IDX], "QList<QWidget*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QWIDGETPTR_IDX],
        _QList_QWidgetPTR__PythonToCpp__QList_QWidgetPTR_,
        is__QList_QWidgetPTR__PythonToCpp__QList_QWidgetPTR__Convertible);

    // Register converter for type 'QPair<QAccessibleInterface*,QFlags<QAccessible::RelationFlag>>'.
    SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QPAIR_QACCESSIBLEINTERFACEPTR_QFLAGS_QACCESSIBLE_RELATIONFLAG_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QPair_QAccessibleInterfacePTR_QFlags_QAccessible_RelationFlag___CppToPython__QPair_QAccessibleInterfacePTR_QFlags_QAccessible_RelationFlag__);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QPAIR_QACCESSIBLEINTERFACEPTR_QFLAGS_QACCESSIBLE_RELATIONFLAG_IDX], "QPair<QAccessibleInterface*,QFlags<QAccessible::RelationFlag>>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QPAIR_QACCESSIBLEINTERFACEPTR_QFLAGS_QACCESSIBLE_RELATIONFLAG_IDX],
        _QPair_QAccessibleInterfacePTR_QFlags_QAccessible_RelationFlag___PythonToCpp__QPair_QAccessibleInterfacePTR_QFlags_QAccessible_RelationFlag__,
        is__QPair_QAccessibleInterfacePTR_QFlags_QAccessible_RelationFlag___PythonToCpp__QPair_QAccessibleInterfacePTR_QFlags_QAccessible_RelationFlag___Convertible);

    // Register converter for type 'QVector<QPair<QAccessibleInterface*,QFlags<QAccessible::RelationFlag>>>'.
    SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QVECTOR_QPAIR_QACCESSIBLEINTERFACEPTR_QFLAGS_QACCESSIBLE_RELATIONFLAG_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QVector_QPair_QAccessibleInterfacePTR_QFlags_QAccessible_RelationFlag____CppToPython__QVector_QPair_QAccessibleInterfacePTR_QFlags_QAccessible_RelationFlag___);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QVECTOR_QPAIR_QACCESSIBLEINTERFACEPTR_QFLAGS_QACCESSIBLE_RELATIONFLAG_IDX], "QVector<QPair<QAccessibleInterface*,QFlags<QAccessible::RelationFlag>>>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QVECTOR_QPAIR_QACCESSIBLEINTERFACEPTR_QFLAGS_QACCESSIBLE_RELATIONFLAG_IDX],
        _QVector_QPair_QAccessibleInterfacePTR_QFlags_QAccessible_RelationFlag____PythonToCpp__QVector_QPair_QAccessibleInterfacePTR_QFlags_QAccessible_RelationFlag___,
        is__QVector_QPair_QAccessibleInterfacePTR_QFlags_QAccessible_RelationFlag____PythonToCpp__QVector_QPair_QAccessibleInterfacePTR_QFlags_QAccessible_RelationFlag____Convertible);

    // Register converter for type 'QList<QGraphicsWidget*>'.
    SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QGRAPHICSWIDGETPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QGraphicsWidgetPTR__CppToPython__QList_QGraphicsWidgetPTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QGRAPHICSWIDGETPTR_IDX], "QList<QGraphicsWidget*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QGRAPHICSWIDGETPTR_IDX],
        _QList_QGraphicsWidgetPTR__PythonToCpp__QList_QGraphicsWidgetPTR_,
        is__QList_QGraphicsWidgetPTR__PythonToCpp__QList_QGraphicsWidgetPTR__Convertible);

    // Register converter for type 'const QList<QKeySequence>&'.
    SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QKEYSEQUENCE_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQList_QKeySequence_REF_CppToPython__constQList_QKeySequence_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QKEYSEQUENCE_IDX], "const QList<QKeySequence>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QKEYSEQUENCE_IDX], "QList<QKeySequence>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QKEYSEQUENCE_IDX],
        _constQList_QKeySequence_REF_PythonToCpp__constQList_QKeySequence_REF,
        is__constQList_QKeySequence_REF_PythonToCpp__constQList_QKeySequence_REF_Convertible);

    // Register converter for type 'QList<QWindow*>'.
    SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QWINDOWPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QWindowPTR__CppToPython__QList_QWindowPTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QWINDOWPTR_IDX], "QList<QWindow*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QWINDOWPTR_IDX],
        _QList_QWindowPTR__PythonToCpp__QList_QWindowPTR_,
        is__QList_QWindowPTR__PythonToCpp__QList_QWindowPTR__Convertible);

    // Register converter for type 'QList<QScreen*>'.
    SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QSCREENPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QScreenPTR__CppToPython__QList_QScreenPTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QSCREENPTR_IDX], "QList<QScreen*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QSCREENPTR_IDX],
        _QList_QScreenPTR__PythonToCpp__QList_QScreenPTR_,
        is__QList_QScreenPTR__PythonToCpp__QList_QScreenPTR__Convertible);

    // Register converter for type 'QList<QAbstractButton*>'.
    SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QABSTRACTBUTTONPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QAbstractButtonPTR__CppToPython__QList_QAbstractButtonPTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QABSTRACTBUTTONPTR_IDX], "QList<QAbstractButton*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QABSTRACTBUTTONPTR_IDX],
        _QList_QAbstractButtonPTR__PythonToCpp__QList_QAbstractButtonPTR_,
        is__QList_QAbstractButtonPTR__PythonToCpp__QList_QAbstractButtonPTR__Convertible);

    // Register converter for type 'QMap<QDate,QTextCharFormat>'.
    SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QMAP_QDATE_QTEXTCHARFORMAT_IDX] = Shiboken::Conversions::createConverter(&PyDict_Type, _QMap_QDate_QTextCharFormat__CppToPython__QMap_QDate_QTextCharFormat_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QMAP_QDATE_QTEXTCHARFORMAT_IDX], "QMap<QDate,QTextCharFormat>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QMAP_QDATE_QTEXTCHARFORMAT_IDX],
        _QMap_QDate_QTextCharFormat__PythonToCpp__QMap_QDate_QTextCharFormat_,
        is__QMap_QDate_QTextCharFormat__PythonToCpp__QMap_QDate_QTextCharFormat__Convertible);

    // Register converter for type 'const QVector<QColor>'.
    SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QVECTOR_QCOLOR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQVector_QColor__CppToPython__constQVector_QColor_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QVECTOR_QCOLOR_IDX], "const QVector<QColor>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QVECTOR_QCOLOR_IDX],
        _constQVector_QColor__PythonToCpp__constQVector_QColor_,
        is__constQVector_QColor__PythonToCpp__constQVector_QColor__Convertible);

    // Register converter for type 'QList<int>'.
    SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_INT_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_int__CppToPython__QList_int_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_INT_IDX], "QList<int>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_INT_IDX],
        _QList_int__PythonToCpp__QList_int_,
        is__QList_int__PythonToCpp__QList_int__Convertible);

    // Register converter for type 'const QHash<int,QByteArray>&'.
    SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QHASH_INT_QBYTEARRAY_IDX] = Shiboken::Conversions::createConverter(&PyDict_Type, _constQHash_int_QByteArray_REF_CppToPython__constQHash_int_QByteArray_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QHASH_INT_QBYTEARRAY_IDX], "const QHash<int,QByteArray>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QHASH_INT_QBYTEARRAY_IDX], "QHash<int,QByteArray>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QHASH_INT_QBYTEARRAY_IDX],
        _constQHash_int_QByteArray_REF_PythonToCpp__constQHash_int_QByteArray_REF,
        is__constQHash_int_QByteArray_REF_PythonToCpp__constQHash_int_QByteArray_REF_Convertible);

    // Register converter for type 'QMap<int,QVariant>'.
    SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QMAP_INT_QVARIANT_IDX] = Shiboken::Conversions::createConverter(&PyDict_Type, _QMap_int_QVariant__CppToPython__QMap_int_QVariant_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QMAP_INT_QVARIANT_IDX], "QMap<int,QVariant>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QMAP_INT_QVARIANT_IDX],
        _QMap_int_QVariant__PythonToCpp__QMap_int_QVariant_,
        is__QMap_int_QVariant__PythonToCpp__QMap_int_QVariant__Convertible);

    // Register converter for type 'const QList<QPersistentModelIndex>&'.
    SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QPERSISTENTMODELINDEX_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQList_QPersistentModelIndex_REF_CppToPython__constQList_QPersistentModelIndex_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QPERSISTENTMODELINDEX_IDX], "const QList<QPersistentModelIndex>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QPERSISTENTMODELINDEX_IDX], "QList<QPersistentModelIndex>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QPERSISTENTMODELINDEX_IDX],
        _constQList_QPersistentModelIndex_REF_PythonToCpp__constQList_QPersistentModelIndex_REF,
        is__constQList_QPersistentModelIndex_REF_PythonToCpp__constQList_QPersistentModelIndex_REF_Convertible);

    // Register converter for type 'QList<QUrl>'.
    SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QURL_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QUrl__CppToPython__QList_QUrl_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QURL_IDX], "QList<QUrl>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QURL_IDX],
        _QList_QUrl__PythonToCpp__QList_QUrl_,
        is__QList_QUrl__PythonToCpp__QList_QUrl__Convertible);

    // Register converter for type 'const QList<QGesture*>&'.
    SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QGESTUREPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQList_QGesturePTR_REF_CppToPython__constQList_QGesturePTR_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QGESTUREPTR_IDX], "const QList<QGesture*>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QGESTUREPTR_IDX], "QList<QGesture*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QGESTUREPTR_IDX],
        _constQList_QGesturePTR_REF_PythonToCpp__constQList_QGesturePTR_REF,
        is__constQList_QGesturePTR_REF_PythonToCpp__constQList_QGesturePTR_REF_Convertible);

    // Register converter for type 'QPair<qreal,QPointF>'.
    SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QPAIR_QREAL_QPOINTF_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QPair_qreal_QPointF__CppToPython__QPair_qreal_QPointF_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QPAIR_QREAL_QPOINTF_IDX], "QPair<qreal,QPointF>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QPAIR_QREAL_QPOINTF_IDX],
        _QPair_qreal_QPointF__PythonToCpp__QPair_qreal_QPointF_,
        is__QPair_qreal_QPointF__PythonToCpp__QPair_qreal_QPointF__Convertible);

    // Register converter for type 'QList<QPair<qreal,QPointF>>'.
    SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QPAIR_QREAL_QPOINTF_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QPair_qreal_QPointF___CppToPython__QList_QPair_qreal_QPointF__);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QPAIR_QREAL_QPOINTF_IDX], "QList<QPair<qreal,QPointF>>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QPAIR_QREAL_QPOINTF_IDX],
        _QList_QPair_qreal_QPointF___PythonToCpp__QList_QPair_qreal_QPointF__,
        is__QList_QPair_qreal_QPointF___PythonToCpp__QList_QPair_qreal_QPointF___Convertible);

    // Register converter for type 'QPair<qreal,qreal>'.
    SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QPAIR_QREAL_QREAL_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QPair_qreal_qreal__CppToPython__QPair_qreal_qreal_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QPAIR_QREAL_QREAL_IDX], "QPair<qreal,qreal>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QPAIR_QREAL_QREAL_IDX],
        _QPair_qreal_qreal__PythonToCpp__QPair_qreal_qreal_,
        is__QPair_qreal_qreal__PythonToCpp__QPair_qreal_qreal__Convertible);

    // Register converter for type 'QList<QPair<qreal,qreal>>'.
    SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QPAIR_QREAL_QREAL_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QPair_qreal_qreal___CppToPython__QList_QPair_qreal_qreal__);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QPAIR_QREAL_QREAL_IDX], "QList<QPair<qreal,qreal>>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QPAIR_QREAL_QREAL_IDX],
        _QList_QPair_qreal_qreal___PythonToCpp__QList_QPair_qreal_qreal__,
        is__QList_QPair_qreal_qreal___PythonToCpp__QList_QPair_qreal_qreal___Convertible);

    // Register converter for type 'const QList<QRectF>&'.
    SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QRECTF_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQList_QRectF_REF_CppToPython__constQList_QRectF_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QRECTF_IDX], "const QList<QRectF>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QRECTF_IDX], "QList<QRectF>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QRECTF_IDX],
        _constQList_QRectF_REF_PythonToCpp__constQList_QRectF_REF,
        is__constQList_QRectF_REF_PythonToCpp__constQList_QRectF_REF_Convertible);

    // Register converter for type 'QList<QGraphicsView*>'.
    SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QGRAPHICSVIEWPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QGraphicsViewPTR__CppToPython__QList_QGraphicsViewPTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QGRAPHICSVIEWPTR_IDX], "QList<QGraphicsView*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QGRAPHICSVIEWPTR_IDX],
        _QList_QGraphicsViewPTR__PythonToCpp__QList_QGraphicsViewPTR_,
        is__QList_QGraphicsViewPTR__PythonToCpp__QList_QGraphicsViewPTR__Convertible);

    // Register converter for type 'QList<QListWidgetItem*>'.
    SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QLISTWIDGETITEMPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QListWidgetItemPTR__CppToPython__QList_QListWidgetItemPTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QLISTWIDGETITEMPTR_IDX], "QList<QListWidgetItem*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QLISTWIDGETITEMPTR_IDX],
        _QList_QListWidgetItemPTR__PythonToCpp__QList_QListWidgetItemPTR_,
        is__QList_QListWidgetItemPTR__PythonToCpp__QList_QListWidgetItemPTR__Convertible);

    // Register converter for type 'const QList<QDockWidget*>&'.
    SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QDOCKWIDGETPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQList_QDockWidgetPTR_REF_CppToPython__constQList_QDockWidgetPTR_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QDOCKWIDGETPTR_IDX], "const QList<QDockWidget*>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QDOCKWIDGETPTR_IDX], "QList<QDockWidget*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QDOCKWIDGETPTR_IDX],
        _constQList_QDockWidgetPTR_REF_PythonToCpp__constQList_QDockWidgetPTR_REF,
        is__constQList_QDockWidgetPTR_REF_PythonToCpp__constQList_QDockWidgetPTR_REF_Convertible);

    // Register converter for type 'QList<QMdiSubWindow*>'.
    SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QMDISUBWINDOWPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QMdiSubWindowPTR__CppToPython__QList_QMdiSubWindowPTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QMDISUBWINDOWPTR_IDX], "QList<QMdiSubWindow*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QMDISUBWINDOWPTR_IDX],
        _QList_QMdiSubWindowPTR__PythonToCpp__QList_QMdiSubWindowPTR_,
        is__QList_QMdiSubWindowPTR__PythonToCpp__QList_QMdiSubWindowPTR__Convertible);

    // Register converter for type 'QList<QTextEdit::ExtraSelection>'.
    SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QTEXTEDIT_EXTRASELECTION_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QTextEdit_ExtraSelection__CppToPython__QList_QTextEdit_ExtraSelection_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QTEXTEDIT_EXTRASELECTION_IDX], "QList<QTextEdit::ExtraSelection>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QTEXTEDIT_EXTRASELECTION_IDX],
        _QList_QTextEdit_ExtraSelection__PythonToCpp__QList_QTextEdit_ExtraSelection_,
        is__QList_QTextEdit_ExtraSelection__PythonToCpp__QList_QTextEdit_ExtraSelection__Convertible);

    // Register converter for type 'QList<QScroller*>'.
    SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QSCROLLERPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QScrollerPTR__CppToPython__QList_QScrollerPTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QSCROLLERPTR_IDX], "QList<QScroller*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QSCROLLERPTR_IDX],
        _QList_QScrollerPTR__PythonToCpp__QList_QScrollerPTR_,
        is__QList_QScrollerPTR__PythonToCpp__QList_QScrollerPTR__Convertible);

    // Register converter for type 'const QList<qreal>&'.
    SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QREAL_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQList_qreal_REF_CppToPython__constQList_qreal_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QREAL_IDX], "const QList<qreal>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QREAL_IDX], "QList<qreal>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QREAL_IDX],
        _constQList_qreal_REF_PythonToCpp__constQList_qreal_REF,
        is__constQList_qreal_REF_PythonToCpp__constQList_qreal_REF_Convertible);

    // Register converter for type 'const QVector<QLine>&'.
    SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QVECTOR_QLINE_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQVector_QLine_REF_CppToPython__constQVector_QLine_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QVECTOR_QLINE_IDX], "const QVector<QLine>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QVECTOR_QLINE_IDX], "QVector<QLine>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QVECTOR_QLINE_IDX],
        _constQVector_QLine_REF_PythonToCpp__constQVector_QLine_REF,
        is__constQVector_QLine_REF_PythonToCpp__constQVector_QLine_REF_Convertible);

    // Register converter for type 'const QVector<QLineF>&'.
    SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QVECTOR_QLINEF_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQVector_QLineF_REF_CppToPython__constQVector_QLineF_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QVECTOR_QLINEF_IDX], "const QVector<QLineF>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QVECTOR_QLINEF_IDX], "QVector<QLineF>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QVECTOR_QLINEF_IDX],
        _constQVector_QLineF_REF_PythonToCpp__constQVector_QLineF_REF,
        is__constQVector_QLineF_REF_PythonToCpp__constQVector_QLineF_REF_Convertible);

    // Register converter for type 'const QVector<QPoint>&'.
    SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QVECTOR_QPOINT_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQVector_QPoint_REF_CppToPython__constQVector_QPoint_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QVECTOR_QPOINT_IDX], "const QVector<QPoint>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QVECTOR_QPOINT_IDX], "QVector<QPoint>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QVECTOR_QPOINT_IDX],
        _constQVector_QPoint_REF_PythonToCpp__constQVector_QPoint_REF,
        is__constQVector_QPoint_REF_PythonToCpp__constQVector_QPoint_REF_Convertible);

    // Register converter for type 'const QVector<QPointF>&'.
    SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QVECTOR_QPOINTF_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQVector_QPointF_REF_CppToPython__constQVector_QPointF_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QVECTOR_QPOINTF_IDX], "const QVector<QPointF>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QVECTOR_QPOINTF_IDX], "QVector<QPointF>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QVECTOR_QPOINTF_IDX],
        _constQVector_QPointF_REF_PythonToCpp__constQVector_QPointF_REF,
        is__constQVector_QPointF_REF_PythonToCpp__constQVector_QPointF_REF_Convertible);

    // Register converter for type 'const QVector<QRect>&'.
    SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QVECTOR_QRECT_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQVector_QRect_REF_CppToPython__constQVector_QRect_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QVECTOR_QRECT_IDX], "const QVector<QRect>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QVECTOR_QRECT_IDX], "QVector<QRect>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QVECTOR_QRECT_IDX],
        _constQVector_QRect_REF_PythonToCpp__constQVector_QRect_REF,
        is__constQVector_QRect_REF_PythonToCpp__constQVector_QRect_REF_Convertible);

    // Register converter for type 'const QVector<QRectF>&'.
    SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QVECTOR_QRECTF_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQVector_QRectF_REF_CppToPython__constQVector_QRectF_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QVECTOR_QRECTF_IDX], "const QVector<QRectF>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QVECTOR_QRECTF_IDX], "QVector<QRectF>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QVECTOR_QRECTF_IDX],
        _constQVector_QRectF_REF_PythonToCpp__constQVector_QRectF_REF,
        is__constQVector_QRectF_REF_PythonToCpp__constQVector_QRectF_REF_Convertible);

    // Register converter for type 'QList<QTableWidgetItem*>'.
    SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QTABLEWIDGETITEMPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QTableWidgetItemPTR__CppToPython__QList_QTableWidgetItemPTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QTABLEWIDGETITEMPTR_IDX], "QList<QTableWidgetItem*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QTABLEWIDGETITEMPTR_IDX],
        _QList_QTableWidgetItemPTR__PythonToCpp__QList_QTableWidgetItemPTR_,
        is__QList_QTableWidgetItemPTR__PythonToCpp__QList_QTableWidgetItemPTR__Convertible);

    // Register converter for type 'QList<QTableWidgetSelectionRange>'.
    SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QTABLEWIDGETSELECTIONRANGE_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QTableWidgetSelectionRange__CppToPython__QList_QTableWidgetSelectionRange_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QTABLEWIDGETSELECTIONRANGE_IDX], "QList<QTableWidgetSelectionRange>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QTABLEWIDGETSELECTIONRANGE_IDX],
        _QList_QTableWidgetSelectionRange__PythonToCpp__QList_QTableWidgetSelectionRange_,
        is__QList_QTableWidgetSelectionRange__PythonToCpp__QList_QTableWidgetSelectionRange__Convertible);

    // Register converter for type 'const QList<QTreeWidgetItem*>&'.
    SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QTREEWIDGETITEMPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQList_QTreeWidgetItemPTR_REF_CppToPython__constQList_QTreeWidgetItemPTR_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QTREEWIDGETITEMPTR_IDX], "const QList<QTreeWidgetItem*>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QTREEWIDGETITEMPTR_IDX], "QList<QTreeWidgetItem*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QTREEWIDGETITEMPTR_IDX],
        _constQList_QTreeWidgetItemPTR_REF_PythonToCpp__constQList_QTreeWidgetItemPTR_REF,
        is__constQList_QTreeWidgetItemPTR_REF_PythonToCpp__constQList_QTreeWidgetItemPTR_REF_Convertible);

    // Register converter for type 'QList<QUndoStack*>'.
    SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QUNDOSTACKPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QUndoStackPTR__CppToPython__QList_QUndoStackPTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QUNDOSTACKPTR_IDX], "QList<QUndoStack*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QUNDOSTACKPTR_IDX],
        _QList_QUndoStackPTR__PythonToCpp__QList_QUndoStackPTR_,
        is__QList_QUndoStackPTR__PythonToCpp__QList_QUndoStackPTR__Convertible);

    // Register converter for type 'const QList<QWizard::WizardButton>&'.
    SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QWIZARD_WIZARDBUTTON_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQList_QWizard_WizardButton_REF_CppToPython__constQList_QWizard_WizardButton_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QWIZARD_WIZARDBUTTON_IDX], "const QList<QWizard::WizardButton>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QWIZARD_WIZARDBUTTON_IDX], "QList<QWizard::WizardButton>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QWIZARD_WIZARDBUTTON_IDX],
        _constQList_QWizard_WizardButton_REF_PythonToCpp__constQList_QWizard_WizardButton_REF,
        is__constQList_QWizard_WizardButton_REF_PythonToCpp__constQList_QWizard_WizardButton_REF_Convertible);

    // Register converter for type 'QList<QVariant>'.
    SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QVARIANT_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QVariant__CppToPython__QList_QVariant_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QVARIANT_IDX], "QList<QVariant>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QVARIANT_IDX],
        _QList_QVariant__PythonToCpp__QList_QVariant_,
        is__QList_QVariant__PythonToCpp__QList_QVariant__Convertible);

    // Register converter for type 'QList<QString>'.
    SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QSTRING_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QString__CppToPython__QList_QString_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QSTRING_IDX], "QList<QString>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QSTRING_IDX],
        _QList_QString__PythonToCpp__QList_QString_,
        is__QList_QString__PythonToCpp__QList_QString__Convertible);

    // Register converter for type 'QMap<QString,QVariant>'.
    SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QMAP_QSTRING_QVARIANT_IDX] = Shiboken::Conversions::createConverter(&PyDict_Type, _QMap_QString_QVariant__CppToPython__QMap_QString_QVariant_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QMAP_QSTRING_QVARIANT_IDX], "QMap<QString,QVariant>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QMAP_QSTRING_QVARIANT_IDX],
        _QMap_QString_QVariant__PythonToCpp__QMap_QString_QVariant_,
        is__QMap_QString_QVariant__PythonToCpp__QMap_QString_QVariant__Convertible);

    // Register primitive types converters.

    Shiboken::Module::registerTypes(module, SbkPySide2_QtWidgetsTypes);
    Shiboken::Module::registerTypeConverters(module, SbkPySide2_QtWidgetsTypeConverters);

    if (PyErr_Occurred()) {
        PyErr_Print();
        Py_FatalError("can't initialize module QtWidgets");
    }
    PySide::registerCleanupFunction(cleanTypesAttributes);

    FinishSignatureInitialization(module, QtWidgets_SignatureStrings);

SBK_MODULE_INIT_FUNCTION_END
