/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtxml_python.h"

// main header
#include "qdomentityreference_wrapper.h"

// inner classes

// Extra includes
#include <QtXml/qdom.h>
#include <qtextstream.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QDomEntityReference_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QDomEntityReference >()))
        return -1;

    ::QDomEntityReference *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomEntityReference.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QDomEntityReference", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QDomEntityReference::QDomEntityReference()
    // 1: QDomEntityReference::QDomEntityReference(QDomEntityReference)
    if (numArgs == 0) {
        overloadId = 0; // QDomEntityReference()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMENTITYREFERENCE_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QDomEntityReference(QDomEntityReference)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDomEntityReference_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QDomEntityReference()
        {

            if (!PyErr_Occurred()) {
                // QDomEntityReference()
                cptr = new ::QDomEntityReference();
            }
            break;
        }
        case 1: // QDomEntityReference(const QDomEntityReference & x)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QDomEntityReference cppArg0_local;
            ::QDomEntityReference *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMENTITYREFERENCE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QDomEntityReference(QDomEntityReference)
                cptr = new ::QDomEntityReference(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QDomEntityReference >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QDomEntityReference_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QDomEntityReference_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QDomEntityReferenceFunc_nodeType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDomEntityReference *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMENTITYREFERENCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QDomEntityReference.nodeType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // nodeType()const
            QDomNode::NodeType cppResult = const_cast<const ::QDomEntityReference *>(cppSelf)->nodeType();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_NODETYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDomEntityReference___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QDomEntityReference *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMENTITYREFERENCE_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMENTITYREFERENCE_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QDomEntityReference_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QDomEntityReference_methods[] = {
    {"nodeType", reinterpret_cast<PyCFunction>(Sbk_QDomEntityReferenceFunc_nodeType), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QDomEntityReference___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static int Sbk_QDomEntityReference___nb_bool(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return -1;
    auto cppSelf = reinterpret_cast< ::QDomEntityReference *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMENTITYREFERENCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return !cppSelf->isNull();
}

} // extern "C"

static int Sbk_QDomEntityReference_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QDomEntityReference_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QDomEntityReference_Type = nullptr;
static SbkObjectType *Sbk_QDomEntityReference_TypeF(void)
{
    return _Sbk_QDomEntityReference_Type;
}

static PyType_Slot Sbk_QDomEntityReference_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QDomEntityReference_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QDomEntityReference_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QDomEntityReference_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QDomEntityReference_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports number protocol
#ifdef IS_PY3K
    {Py_nb_bool, (void *)Sbk_QDomEntityReference___nb_bool},
#else
    {Py_nb_nonzero, (void *)Sbk_QDomEntityReference___nb_bool},
#endif
    {0, nullptr}
};
static PyType_Spec Sbk_QDomEntityReference_spec = {
    "2:PySide2.QtXml.QDomEntityReference",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QDomEntityReference_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QDomEntityReference_PythonToCpp_QDomEntityReference_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QDomEntityReference_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QDomEntityReference_PythonToCpp_QDomEntityReference_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QDomEntityReference_TypeF())))
        return QDomEntityReference_PythonToCpp_QDomEntityReference_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QDomEntityReference_PTR_CppToPython_QDomEntityReference(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QDomEntityReference *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QDomEntityReference_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QDomEntityReference_COPY_CppToPython_QDomEntityReference(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QDomEntityReference_TypeF(), new ::QDomEntityReference(*reinterpret_cast<const ::QDomEntityReference *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QDomEntityReference_PythonToCpp_QDomEntityReference_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QDomEntityReference *>(cppOut) = *reinterpret_cast< ::QDomEntityReference *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QDOMENTITYREFERENCE_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QDomEntityReference_PythonToCpp_QDomEntityReference_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QDomEntityReference_TypeF())))
        return QDomEntityReference_PythonToCpp_QDomEntityReference_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QDomEntityReference_SignatureStrings[] = {
    "1:PySide2.QtXml.QDomEntityReference(self)",
    "0:PySide2.QtXml.QDomEntityReference(self,x:PySide2.QtXml.QDomEntityReference)",
    "PySide2.QtXml.QDomEntityReference.nodeType(self)->PySide2.QtXml.QDomNode.NodeType",
    "PySide2.QtXml.QDomEntityReference.__copy__()",
    nullptr}; // Sentinel

void init_QDomEntityReference(PyObject *module)
{
    _Sbk_QDomEntityReference_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QDomEntityReference",
        "QDomEntityReference",
        &Sbk_QDomEntityReference_spec,
        &Shiboken::callCppDestructor< ::QDomEntityReference >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QDOMNODE_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QDomEntityReference_Type);
    InitSignatureStrings(pyType, QDomEntityReference_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QDomEntityReference_Type), Sbk_QDomEntityReference_PropertyStrings);
    SbkPySide2_QtXmlTypes[SBK_QDOMENTITYREFERENCE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QDomEntityReference_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QDomEntityReference_TypeF(),
        QDomEntityReference_PythonToCpp_QDomEntityReference_PTR,
        is_QDomEntityReference_PythonToCpp_QDomEntityReference_PTR_Convertible,
        QDomEntityReference_PTR_CppToPython_QDomEntityReference,
        QDomEntityReference_COPY_CppToPython_QDomEntityReference);

    Shiboken::Conversions::registerConverterName(converter, "QDomEntityReference");
    Shiboken::Conversions::registerConverterName(converter, "QDomEntityReference*");
    Shiboken::Conversions::registerConverterName(converter, "QDomEntityReference&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QDomEntityReference).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QDomEntityReference_PythonToCpp_QDomEntityReference_COPY,
        is_QDomEntityReference_PythonToCpp_QDomEntityReference_COPY_Convertible);

    qRegisterMetaType< ::QDomEntityReference >("QDomEntityReference");
}
