/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtxmlpatterns_python.h"

// main header
#include "qxmlresultitems_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QXmlResultItemsWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QXmlResultItemsWrapper::QXmlResultItemsWrapper() : QXmlResultItems()
{
    resetPyMethodCache();
    // ... middle
}

QXmlResultItemsWrapper::~QXmlResultItemsWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QXmlResultItems_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QXmlResultItems >()))
        return -1;

    ::QXmlResultItemsWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXmlPatterns.QXmlResultItems.__init__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // QXmlResultItems()
            cptr = new ::QXmlResultItemsWrapper();
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QXmlResultItems >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_QXmlResultItemsFunc_current(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlResultItems *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLRESULTITEMS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXmlPatterns.QXmlResultItems.current";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // current()const
            QXmlItem cppResult = const_cast<const ::QXmlResultItems *>(cppSelf)->current();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLITEM_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlResultItemsFunc_hasError(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlResultItems *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLRESULTITEMS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXmlPatterns.QXmlResultItems.hasError";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hasError()const
            bool cppResult = const_cast<const ::QXmlResultItems *>(cppSelf)->hasError();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlResultItemsFunc_next(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlResultItems *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLRESULTITEMS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXmlPatterns.QXmlResultItems.next";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // next()
            QXmlItem cppResult = cppSelf->next();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLITEM_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QXmlResultItems_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QXmlResultItems_methods[] = {
    {"current", reinterpret_cast<PyCFunction>(Sbk_QXmlResultItemsFunc_current), METH_NOARGS},
    {"hasError", reinterpret_cast<PyCFunction>(Sbk_QXmlResultItemsFunc_hasError), METH_NOARGS},
    {"next", reinterpret_cast<PyCFunction>(Sbk_QXmlResultItemsFunc_next), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QXmlResultItems_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QXmlResultItems *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLRESULTITEMS_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QXmlResultItemsWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QXmlResultItems_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QXmlResultItems_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QXmlResultItems_Type = nullptr;
static SbkObjectType *Sbk_QXmlResultItems_TypeF(void)
{
    return _Sbk_QXmlResultItems_Type;
}

static PyType_Slot Sbk_QXmlResultItems_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QXmlResultItems_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QXmlResultItems_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QXmlResultItems_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QXmlResultItems_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QXmlResultItems_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QXmlResultItems_spec = {
    "2:PySide2.QtXmlPatterns.QXmlResultItems",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QXmlResultItems_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QXmlResultItems_PythonToCpp_QXmlResultItems_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QXmlResultItems_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QXmlResultItems_PythonToCpp_QXmlResultItems_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QXmlResultItems_TypeF())))
        return QXmlResultItems_PythonToCpp_QXmlResultItems_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QXmlResultItems_PTR_CppToPython_QXmlResultItems(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QXmlResultItems *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QXmlResultItems_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QXmlResultItems_SignatureStrings[] = {
    "PySide2.QtXmlPatterns.QXmlResultItems(self)",
    "PySide2.QtXmlPatterns.QXmlResultItems.current(self)->PySide2.QtXmlPatterns.QXmlItem",
    "PySide2.QtXmlPatterns.QXmlResultItems.hasError(self)->bool",
    "PySide2.QtXmlPatterns.QXmlResultItems.next(self)->PySide2.QtXmlPatterns.QXmlItem",
    nullptr}; // Sentinel

void init_QXmlResultItems(PyObject *module)
{
    _Sbk_QXmlResultItems_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QXmlResultItems",
        "QXmlResultItems*",
        &Sbk_QXmlResultItems_spec,
        &Shiboken::callCppDestructor< ::QXmlResultItems >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QXmlResultItems_Type);
    InitSignatureStrings(pyType, QXmlResultItems_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QXmlResultItems_Type), Sbk_QXmlResultItems_PropertyStrings);
    SbkPySide2_QtXmlPatternsTypes[SBK_QXMLRESULTITEMS_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QXmlResultItems_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QXmlResultItems_TypeF(),
        QXmlResultItems_PythonToCpp_QXmlResultItems_PTR,
        is_QXmlResultItems_PythonToCpp_QXmlResultItems_PTR_Convertible,
        QXmlResultItems_PTR_CppToPython_QXmlResultItems);

    Shiboken::Conversions::registerConverterName(converter, "QXmlResultItems");
    Shiboken::Conversions::registerConverterName(converter, "QXmlResultItems*");
    Shiboken::Conversions::registerConverterName(converter, "QXmlResultItems&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QXmlResultItems).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QXmlResultItemsWrapper).name());


}
