/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtxmlpatterns_python.h"

// main header
#include "qxmlschemavalidator_wrapper.h"

// inner classes

// Extra includes
#include <QtXmlPatterns/qabstractmessagehandler.h>
#include <QtXmlPatterns/qabstracturiresolver.h>
#include <QtXmlPatterns/qxmlnamepool.h>
#include <QtXmlPatterns/qxmlschema.h>
#include <qbytearray.h>
#include <qiodevice.h>
#include <qurl.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QXmlSchemaValidator_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QXmlSchemaValidator >()))
        return -1;

    ::QXmlSchemaValidator *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXmlPatterns.QXmlSchemaValidator.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QXmlSchemaValidator", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QXmlSchemaValidator::QXmlSchemaValidator()
    // 1: QXmlSchemaValidator::QXmlSchemaValidator(QXmlSchema)
    if (numArgs == 0) {
        overloadId = 0; // QXmlSchemaValidator()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLSCHEMA_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QXmlSchemaValidator(QXmlSchema)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QXmlSchemaValidator_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QXmlSchemaValidator()
        {

            if (!PyErr_Occurred()) {
                // QXmlSchemaValidator()
                cptr = new ::QXmlSchemaValidator();
            }
            break;
        }
        case 1: // QXmlSchemaValidator(const QXmlSchema & schema)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QXmlSchema *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QXmlSchemaValidator(QXmlSchema)
                cptr = new ::QXmlSchemaValidator(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QXmlSchemaValidator >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QXmlSchemaValidator_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QXmlSchemaValidator_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QXmlSchemaValidatorFunc_messageHandler(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlSchemaValidator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLSCHEMAVALIDATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXmlPatterns.QXmlSchemaValidator.messageHandler";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // messageHandler()const
            QAbstractMessageHandler * cppResult = const_cast<const ::QXmlSchemaValidator *>(cppSelf)->messageHandler();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QABSTRACTMESSAGEHANDLER_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlSchemaValidatorFunc_namePool(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlSchemaValidator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLSCHEMAVALIDATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXmlPatterns.QXmlSchemaValidator.namePool";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // namePool()const
            QXmlNamePool cppResult = const_cast<const ::QXmlSchemaValidator *>(cppSelf)->namePool();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNAMEPOOL_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlSchemaValidatorFunc_schema(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlSchemaValidator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLSCHEMAVALIDATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXmlPatterns.QXmlSchemaValidator.schema";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // schema()const
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtxmlpatterns.cpp (qxmlschemavalidator-schema)]
            QXmlSchema *cppResult = new QXmlSchema(cppSelf->schema());
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLSCHEMA_IDX]), cppResult);
            // END of custom code block [file: ../glue/qtxmlpatterns.cpp (qxmlschemavalidator-schema)]
            // ========================================================================

            // End of code injection


            // Ownership transferences.
            Shiboken::Object::getOwnership(pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlSchemaValidatorFunc_setMessageHandler(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlSchemaValidator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLSCHEMAVALIDATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXmlPatterns.QXmlSchemaValidator.setMessageHandler";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QXmlSchemaValidator::setMessageHandler(QAbstractMessageHandler*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QABSTRACTMESSAGEHANDLER_IDX]), (pyArg)))) {
        overloadId = 0; // setMessageHandler(QAbstractMessageHandler*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QXmlSchemaValidatorFunc_setMessageHandler_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QAbstractMessageHandler *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMessageHandler(QAbstractMessageHandler*)
            cppSelf->setMessageHandler(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QXmlSchemaValidatorFunc_setMessageHandler_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QXmlSchemaValidatorFunc_setSchema(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlSchemaValidator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLSCHEMAVALIDATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXmlPatterns.QXmlSchemaValidator.setSchema";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QXmlSchemaValidator::setSchema(QXmlSchema)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLSCHEMA_IDX]), (pyArg)))) {
        overloadId = 0; // setSchema(QXmlSchema)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QXmlSchemaValidatorFunc_setSchema_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QXmlSchema *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSchema(QXmlSchema)
            cppSelf->setSchema(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QXmlSchemaValidatorFunc_setSchema_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QXmlSchemaValidatorFunc_setUriResolver(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlSchemaValidator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLSCHEMAVALIDATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXmlPatterns.QXmlSchemaValidator.setUriResolver";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QXmlSchemaValidator::setUriResolver(const QAbstractUriResolver*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QABSTRACTURIRESOLVER_IDX]), (pyArg)))) {
        overloadId = 0; // setUriResolver(const QAbstractUriResolver*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QXmlSchemaValidatorFunc_setUriResolver_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QAbstractUriResolver *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setUriResolver(const QAbstractUriResolver*)
            cppSelf->setUriResolver(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QXmlSchemaValidatorFunc_setUriResolver_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QXmlSchemaValidatorFunc_uriResolver(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlSchemaValidator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLSCHEMAVALIDATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXmlPatterns.QXmlSchemaValidator.uriResolver";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // uriResolver()const
            const QAbstractUriResolver * cppResult = const_cast<const ::QXmlSchemaValidator *>(cppSelf)->uriResolver();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QABSTRACTURIRESOLVER_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlSchemaValidatorFunc_validate(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlSchemaValidator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLSCHEMAVALIDATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXmlPatterns.QXmlSchemaValidator.validate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QXmlSchemaValidatorFunc_validate_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QXmlSchemaValidatorFunc_validate_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:validate", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QXmlSchemaValidator::validate(QIODevice*,QUrl)const
    // 1: QXmlSchemaValidator::validate(QByteArray,QUrl)const
    // 2: QXmlSchemaValidator::validate(QUrl)const
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[0])))) {
        overloadId = 2; // validate(QUrl)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // validate(QByteArray,QUrl)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[1])))) {
            overloadId = 1; // validate(QByteArray,QUrl)const
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // validate(QIODevice*,QUrl)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[1])))) {
            overloadId = 0; // validate(QIODevice*,QUrl)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QXmlSchemaValidatorFunc_validate_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // validate(QIODevice * source, const QUrl & documentUri) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_documentUri = Shiboken::String::createStaticString("documentUri");
                if (PyDict_Contains(kwds, key_documentUri)) {
                    value = PyDict_GetItem(kwds, key_documentUri);
                    if (value && pyArgs[1]) {
                        errInfo = key_documentUri;
                        Py_INCREF(errInfo);
                        goto Sbk_QXmlSchemaValidatorFunc_validate_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[1]))))
                            goto Sbk_QXmlSchemaValidatorFunc_validate_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_documentUri);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QXmlSchemaValidatorFunc_validate_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QIODevice *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QUrl cppArg1_local = QUrl();
            ::QUrl *cppArg1 = &cppArg1_local;
            if (pythonToCpp[1]) {
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);
            }

            if (!PyErr_Occurred()) {
                // validate(QIODevice*,QUrl)const
                bool cppResult = const_cast<const ::QXmlSchemaValidator *>(cppSelf)->validate(cppArg0, *cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // validate(const QByteArray & data, const QUrl & documentUri) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_documentUri = Shiboken::String::createStaticString("documentUri");
                if (PyDict_Contains(kwds, key_documentUri)) {
                    value = PyDict_GetItem(kwds, key_documentUri);
                    if (value && pyArgs[1]) {
                        errInfo = key_documentUri;
                        Py_INCREF(errInfo);
                        goto Sbk_QXmlSchemaValidatorFunc_validate_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[1]))))
                            goto Sbk_QXmlSchemaValidatorFunc_validate_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_documentUri);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QXmlSchemaValidatorFunc_validate_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QByteArray cppArg0_local;
            ::QByteArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QUrl cppArg1_local = QUrl();
            ::QUrl *cppArg1 = &cppArg1_local;
            if (pythonToCpp[1]) {
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);
            }

            if (!PyErr_Occurred()) {
                // validate(QByteArray,QUrl)const
                bool cppResult = const_cast<const ::QXmlSchemaValidator *>(cppSelf)->validate(*cppArg0, *cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 2: // validate(const QUrl & source) const
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QXmlSchemaValidatorFunc_validate_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QUrl cppArg0_local;
            ::QUrl *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // validate(QUrl)const
                bool cppResult = const_cast<const ::QXmlSchemaValidator *>(cppSelf)->validate(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QXmlSchemaValidatorFunc_validate_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QXmlSchemaValidator_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QXmlSchemaValidator_methods[] = {
    {"messageHandler", reinterpret_cast<PyCFunction>(Sbk_QXmlSchemaValidatorFunc_messageHandler), METH_NOARGS},
    {"namePool", reinterpret_cast<PyCFunction>(Sbk_QXmlSchemaValidatorFunc_namePool), METH_NOARGS},
    {"schema", reinterpret_cast<PyCFunction>(Sbk_QXmlSchemaValidatorFunc_schema), METH_NOARGS},
    {"setMessageHandler", reinterpret_cast<PyCFunction>(Sbk_QXmlSchemaValidatorFunc_setMessageHandler), METH_O},
    {"setSchema", reinterpret_cast<PyCFunction>(Sbk_QXmlSchemaValidatorFunc_setSchema), METH_O},
    {"setUriResolver", reinterpret_cast<PyCFunction>(Sbk_QXmlSchemaValidatorFunc_setUriResolver), METH_O},
    {"uriResolver", reinterpret_cast<PyCFunction>(Sbk_QXmlSchemaValidatorFunc_uriResolver), METH_NOARGS},
    {"validate", reinterpret_cast<PyCFunction>(Sbk_QXmlSchemaValidatorFunc_validate), METH_VARARGS|METH_KEYWORDS},

    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QXmlSchemaValidator_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QXmlSchemaValidator_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QXmlSchemaValidator_Type = nullptr;
static SbkObjectType *Sbk_QXmlSchemaValidator_TypeF(void)
{
    return _Sbk_QXmlSchemaValidator_Type;
}

static PyType_Slot Sbk_QXmlSchemaValidator_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QXmlSchemaValidator_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QXmlSchemaValidator_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QXmlSchemaValidator_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QXmlSchemaValidator_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QXmlSchemaValidator_spec = {
    "2:PySide2.QtXmlPatterns.QXmlSchemaValidator",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QXmlSchemaValidator_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QXmlSchemaValidator_PythonToCpp_QXmlSchemaValidator_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QXmlSchemaValidator_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QXmlSchemaValidator_PythonToCpp_QXmlSchemaValidator_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QXmlSchemaValidator_TypeF())))
        return QXmlSchemaValidator_PythonToCpp_QXmlSchemaValidator_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QXmlSchemaValidator_PTR_CppToPython_QXmlSchemaValidator(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QXmlSchemaValidator *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QXmlSchemaValidator_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QXmlSchemaValidator_SignatureStrings[] = {
    "1:PySide2.QtXmlPatterns.QXmlSchemaValidator(self)",
    "0:PySide2.QtXmlPatterns.QXmlSchemaValidator(self,schema:PySide2.QtXmlPatterns.QXmlSchema)",
    "PySide2.QtXmlPatterns.QXmlSchemaValidator.messageHandler(self)->PySide2.QtXmlPatterns.QAbstractMessageHandler",
    "PySide2.QtXmlPatterns.QXmlSchemaValidator.namePool(self)->PySide2.QtXmlPatterns.QXmlNamePool",
    "PySide2.QtXmlPatterns.QXmlSchemaValidator.schema(self)->PySide2.QtXmlPatterns.QXmlSchema",
    "PySide2.QtXmlPatterns.QXmlSchemaValidator.setMessageHandler(self,handler:PySide2.QtXmlPatterns.QAbstractMessageHandler)",
    "PySide2.QtXmlPatterns.QXmlSchemaValidator.setSchema(self,schema:PySide2.QtXmlPatterns.QXmlSchema)",
    "PySide2.QtXmlPatterns.QXmlSchemaValidator.setUriResolver(self,resolver:PySide2.QtXmlPatterns.QAbstractUriResolver)",
    "PySide2.QtXmlPatterns.QXmlSchemaValidator.uriResolver(self)->PySide2.QtXmlPatterns.QAbstractUriResolver",
    "2:PySide2.QtXmlPatterns.QXmlSchemaValidator.validate(self,source:PySide2.QtCore.QIODevice,documentUri:PySide2.QtCore.QUrl=QUrl())->bool",
    "1:PySide2.QtXmlPatterns.QXmlSchemaValidator.validate(self,data:PySide2.QtCore.QByteArray,documentUri:PySide2.QtCore.QUrl=QUrl())->bool",
    "0:PySide2.QtXmlPatterns.QXmlSchemaValidator.validate(self,source:PySide2.QtCore.QUrl)->bool",
    nullptr}; // Sentinel

void init_QXmlSchemaValidator(PyObject *module)
{
    _Sbk_QXmlSchemaValidator_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QXmlSchemaValidator",
        "QXmlSchemaValidator*",
        &Sbk_QXmlSchemaValidator_spec,
        &Shiboken::callCppDestructor< ::QXmlSchemaValidator >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QXmlSchemaValidator_Type);
    InitSignatureStrings(pyType, QXmlSchemaValidator_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QXmlSchemaValidator_Type), Sbk_QXmlSchemaValidator_PropertyStrings);
    SbkPySide2_QtXmlPatternsTypes[SBK_QXMLSCHEMAVALIDATOR_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QXmlSchemaValidator_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QXmlSchemaValidator_TypeF(),
        QXmlSchemaValidator_PythonToCpp_QXmlSchemaValidator_PTR,
        is_QXmlSchemaValidator_PythonToCpp_QXmlSchemaValidator_PTR_Convertible,
        QXmlSchemaValidator_PTR_CppToPython_QXmlSchemaValidator);

    Shiboken::Conversions::registerConverterName(converter, "QXmlSchemaValidator");
    Shiboken::Conversions::registerConverterName(converter, "QXmlSchemaValidator*");
    Shiboken::Conversions::registerConverterName(converter, "QXmlSchemaValidator&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QXmlSchemaValidator).name());


}
