# Copyright The OpenTelemetry Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""
Factories for event types described in
https://github.com/open-telemetry/semantic-conventions/blob/main/docs/gen-ai/gen-ai-events.md#system-event.

Hopefully this code can be autogenerated by Weaver once Gen AI semantic conventions are
schematized in YAML and the Weaver tool supports it.
"""

from opentelemetry._events import Event
from opentelemetry.semconv._incubating.attributes import gen_ai_attributes
from opentelemetry.util.types import AnyValue


def user_event(
    *,
    role: str = "user",
    content: AnyValue = None,
) -> Event:
    """Creates a User event
    https://github.com/open-telemetry/semantic-conventions/blob/v1.28.0/docs/gen-ai/gen-ai-events.md#user-event
    """
    body: dict[str, AnyValue] = {
        "role": role,
    }
    if content is not None:
        body["content"] = content
    return Event(
        name="gen_ai.user.message",
        attributes={
            gen_ai_attributes.GEN_AI_SYSTEM: gen_ai_attributes.GenAiSystemValues.VERTEX_AI.value,
        },
        body=body,
    )


def assistant_event(
    *,
    role: str = "assistant",
    content: AnyValue = None,
) -> Event:
    """Creates an Assistant event
    https://github.com/open-telemetry/semantic-conventions/blob/v1.28.0/docs/gen-ai/gen-ai-events.md#assistant-event
    """
    body: dict[str, AnyValue] = {
        "role": role,
    }
    if content is not None:
        body["content"] = content
    return Event(
        name="gen_ai.assistant.message",
        attributes={
            gen_ai_attributes.GEN_AI_SYSTEM: gen_ai_attributes.GenAiSystemValues.VERTEX_AI.value,
        },
        body=body,
    )


def system_event(
    *,
    role: str = "system",
    content: AnyValue = None,
) -> Event:
    """Creates a System event
    https://github.com/open-telemetry/semantic-conventions/blob/v1.28.0/docs/gen-ai/gen-ai-events.md#system-event
    """
    body: dict[str, AnyValue] = {
        "role": role,
    }
    if content is not None:
        body["content"] = content
    return Event(
        name="gen_ai.system.message",
        attributes={
            gen_ai_attributes.GEN_AI_SYSTEM: gen_ai_attributes.GenAiSystemValues.VERTEX_AI.value,
        },
        body=body,
    )
