/*
 * Module code.
 *
 * Generated by SIP 4.19.25
 */

#include "sipAPIpynest2d.h"

#line 7 "/build/python-pynest2d/src/pynest2d-4.12.0/src/ItemGroup.sip"
        #include <utility>
        #include <vector>
        using ItemGroup = PlacementStrategyLike<NfpPlacer>::ItemGroup; //Make an alias here since SIP doesn't namespace syntax nor template syntax.
#line 14 "/build/python-pynest2d/src/pynest2d-4.12.0/build/src/sippynest2dpart3.cpp"



extern "C" {static void assign_ItemGroup(void *, SIP_SSIZE_T, void *);}
static void assign_ItemGroup(void *sipDst, SIP_SSIZE_T sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::ItemGroup *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::ItemGroup *>(sipSrc);
}


extern "C" {static void *array_ItemGroup(SIP_SSIZE_T);}
static void *array_ItemGroup(SIP_SSIZE_T sipNrElem)
{
    return new  ::ItemGroup[sipNrElem];
}


extern "C" {static void *copy_ItemGroup(const void *, SIP_SSIZE_T);}
static void *copy_ItemGroup(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new  ::ItemGroup(reinterpret_cast<const  ::ItemGroup *>(sipSrc)[sipSrcIdx]);
}


/* Call the mapped type's destructor. */
extern "C" {static void release_ItemGroup(void *, int);}
static void release_ItemGroup(void *ptr, int)
{
    Py_BEGIN_ALLOW_THREADS
    delete reinterpret_cast< ::ItemGroup *>(ptr);
    Py_END_ALLOW_THREADS
}



extern "C" {static int convertTo_ItemGroup(PyObject *, void **, int *, PyObject *);}
static int convertTo_ItemGroup(PyObject *sipPy,void **sipCppPtrV,int *sipIsErr,PyObject *sipTransferObj)
{
     ::ItemGroup **sipCppPtr = reinterpret_cast< ::ItemGroup **>(sipCppPtrV);

#line 38 "/build/python-pynest2d/src/pynest2d-4.12.0/src/ItemGroup.sip"
        PyObject* iterator = PyObject_GetIter(sipPy);
        if(!sipIsErr) //We're only checking if it can be converted.
        {
            //Must be any iterable.
            const bool iterable = (iterator != NULL);
            Py_XDECREF(iterator);
            return iterable;
        }

        ItemGroup* result = new ItemGroup();
        PyObject* list_item;
        while(list_item = PyIter_Next(iterator))
        {
            if(!sipCanConvertToInstance(list_item, sipClass_Item, SIP_NOT_NONE))
            {
                PyErr_Format(PyExc_TypeError, "Object in iterable cannot be converted to a libnest2d Item.");
                *sipIsErr = 1;
                break;
            }
            int state;
            Item* item = reinterpret_cast<Item*>(sipConvertToInstance(list_item, sipClass_Item, 0, SIP_NOT_NONE, &state, sipIsErr));
            if(!*sipIsErr)
            {
                result->push_back(*item);
            }

            sipReleaseInstance(item, sipClass_Item, state);
            Py_DECREF(list_item);
        }

        Py_DECREF(iterator);
        if(*sipIsErr)
        {
            delete result;
            return 0;
        }
        *sipCppPtr = result;
        return sipGetState(sipTransferObj);
#line 94 "/build/python-pynest2d/src/pynest2d-4.12.0/build/src/sippynest2dpart3.cpp"
}


extern "C" {static PyObject *convertFrom_ItemGroup(void *, PyObject *);}
static PyObject *convertFrom_ItemGroup(void *sipCppV, PyObject *sipTransferObj)
{
    ::ItemGroup *sipCpp = reinterpret_cast< ::ItemGroup *>(sipCppV);

#line 13 "/build/python-pynest2d/src/pynest2d-4.12.0/src/ItemGroup.sip"
        const long size = sipCpp->size();
        if(size < 0)
        {
            return NULL;
        }
        PyObject* result_list = PyList_New(size);
        if(!result_list)
        {
            return NULL;
        }
        for(size_t i = 0; i < size; ++i)
        {
            Item item = sipCpp->at(0);
            PyObject* python_item = sipConvertFromInstance(&item, sipClass_Item, sipTransferObj);
            if(!python_item)
            {
                Py_DECREF(result_list);
                return NULL;
            }
            PyList_SET_ITEM(result_list, i, python_item);
        }
        return result_list;
#line 126 "/build/python-pynest2d/src/pynest2d-4.12.0/build/src/sippynest2dpart3.cpp"
}


sipMappedTypeDef sipTypeDef_pynest2d_ItemGroup = {
    {
        -1,
        SIP_NULLPTR,
        0,
        SIP_TYPE_MAPPED,
        sipNameNr_ItemGroup,     /* ItemGroup */
        {0},
        0
    },
    {
        -1,
        {0, 0, 1},
        0, 0,
        0, 0,
        0, 0,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}
    },
    assign_ItemGroup,
    array_ItemGroup,
    copy_ItemGroup,
    release_ItemGroup,
    convertTo_ItemGroup,
    convertFrom_ItemGroup
};

#line 26 "/build/python-pynest2d/src/pynest2d-4.12.0/src/Item.sip"
        #include <libnest2d/libnest2d.hpp>
#line 158 "/build/python-pynest2d/src/pynest2d-4.12.0/build/src/sippynest2dpart3.cpp"

#line 10 "/build/python-pynest2d/src/pynest2d-4.12.0/src/Point.sip"
        #include <libnest2d/libnest2d.hpp>
#line 162 "/build/python-pynest2d/src/pynest2d-4.12.0/build/src/sippynest2dpart3.cpp"
#line 11 "/build/python-pynest2d/src/pynest2d-4.12.0/src/Box.sip"
        #include <libnest2d/libnest2d.hpp>
#line 165 "/build/python-pynest2d/src/pynest2d-4.12.0/build/src/sippynest2dpart3.cpp"
#line 11 "/build/python-pynest2d/src/pynest2d-4.12.0/src/Circle.sip"
        #include <libnest2d/libnest2d.hpp>
#line 168 "/build/python-pynest2d/src/pynest2d-4.12.0/build/src/sippynest2dpart3.cpp"
#line 12 "/build/python-pynest2d/src/pynest2d-4.12.0/src/String.sip"
        #include <string>
#line 171 "/build/python-pynest2d/src/pynest2d-4.12.0/build/src/sippynest2dpart3.cpp"


PyDoc_STRVAR(doc_Item_binId, "        The bin that this item is assigned to, or -1 if it's not (yet) assigned\n"
"        to any bin.\n"
"\n"
"        The assigned bin is a version of the bin shape. If all objects fit in\n"
"        one bin, their bin IDs will all be 0. If they don't fit, new bins will\n"
"        be created and some objects will be put in the new bin.\n"
"        :return: The currently assigned bin of this item.\n"
"        Assign this item to a bin.\n"
"\n"
"        Assigning to a negative number effectively takes this object out of all\n"
"        bins. Use -1 to unassign the item from all bins.\n"
"        :param idx: The index of the bin to assign the item to.");

extern "C" {static PyObject *meth_Item_binId(PyObject *, PyObject *);}
static PyObject *meth_Item_binId(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::Item *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_Item, &sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->binId();
            Py_END_ALLOW_THREADS

            return SIPLong_FromLong(sipRes);
        }
    }

    {
        int a0;
         ::Item *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_Item, &sipCpp, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->binId(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Item, sipName_binId, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_Item_isFixed, "        Whether this item is fixed in place, not able to be moved by the nester.\n"
"\n"
"        If the item is fixed, the nester is not allowed to move it and must\n"
"        place other items around it.\n"
"        :return: Whether the item is fixed in a certain bin.");

extern "C" {static PyObject *meth_Item_isFixed(PyObject *, PyObject *);}
static PyObject *meth_Item_isFixed(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::Item *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_Item, &sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isFixed();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Item, sipName_isFixed, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_Item_isDisallowedArea, "        Whether this item is a disallowed area, not able to be moved by the\n"
"        nester and not grouped together with other items.\n"
"\n"
"        If the item is a disallowed area, the nester is not allowed to move it\n"
"        and not allowed to place other items in the same spot. Contrary to\n"
"        simple fixed items, other items will not be packed nearby disallowed\n"
"        areas by the optimization.\n"
"        :return Whether the item is a disallowed area.");

extern "C" {static PyObject *meth_Item_isDisallowedArea(PyObject *, PyObject *);}
static PyObject *meth_Item_isDisallowedArea(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::Item *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_Item, &sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isDisallowedArea();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Item, sipName_isDisallowedArea, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_Item_markAsFixedInBin, "        Make this item a fixed item in a certain bin.\n"
"\n"
"        If the item is fixed, the nester is not allowed to move it and must\n"
"        place other items around it in that bin.\n"
"\n"
"        This currently only works with the FirstFit selector (which is the\n"
"        default).\n"
"        :param binid: The bin in which this item is fixed.");

extern "C" {static PyObject *meth_Item_markAsFixedInBin(PyObject *, PyObject *);}
static PyObject *meth_Item_markAsFixedInBin(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
         ::Item *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_Item, &sipCpp, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->markAsFixedInBin(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Item, sipName_markAsFixedInBin, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_Item_markAsDisallowedAreaInBin, "        Make this item a disallowed area in a certain bin.\n"
"\n"
"        If the item is a disallowed area, the nester is not allowed to move it\n"
"        and not allowed to place other items in the same spot. Contrary to\n"
"        simple fixed items, other items will not be packed nearby disallowed\n"
"        areas by the optimization.\n"
"\n"
"        This currently only works with the FirstFit selector (which is the\n"
"        default).\n"
"        :param binid: The bin in which this item is a disallowed area.");

extern "C" {static PyObject *meth_Item_markAsDisallowedAreaInBin(PyObject *, PyObject *);}
static PyObject *meth_Item_markAsDisallowedAreaInBin(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
         ::Item *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_Item, &sipCpp, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->markAsDisallowedAreaInBin(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Item, sipName_markAsDisallowedAreaInBin, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_Item_priority, "        Gives the current priority of selecting this item.\n"
"\n"
"        Items with greater priority (higher number) get selected first by the\n"
"        selectors.\n"
"        :return: The priority of selecting this item.\n"
"        Sets the priority of selecting this item.\n"
"\n"
"        Items with greater priority (higher number) get selected first by the\n"
"        selectors. This causes them to be placed in earlier bins and perhaps\n"
"        more towards the point where the objects get aligned to (depending on\n"
"        the placer).\n"
"\n"
"        The priority is not a guarantee. The selector may still select different\n"
"        items first. It only serves as an intuitive way to steer which objects\n"
"        are the most important to be placed.\n"
"        :param priority: The priority to give to this item.");

extern "C" {static PyObject *meth_Item_priority(PyObject *, PyObject *);}
static PyObject *meth_Item_priority(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::Item *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_Item, &sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->priority();
            Py_END_ALLOW_THREADS

            return SIPLong_FromLong(sipRes);
        }
    }

    {
        int a0;
         ::Item *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_Item, &sipCpp, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->priority(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Item, sipName_priority, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_Item_toString, "        Give a string representation of this item.\n"
"            \n"
"        This will give a list of all the vertices in the contour of the item.\n"
"        :return: A string representation of the item.");

extern "C" {static PyObject *meth_Item_toString(PyObject *, PyObject *);}
static PyObject *meth_Item_toString(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::Item *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_Item, &sipCpp))
        {
             ::std::string*sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::std::string(sipCpp->toString());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_std_string,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Item, sipName_toString, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_Item_vertex, "        Get a vertex from the contour of the item.\n"
"        :param idx: The index of the vertex. Should not be vertexCount() or\n"
"        higher.\n"
"        :return: A point along the contour of the item.");

extern "C" {static PyObject *meth_Item_vertex(PyObject *, PyObject *);}
static PyObject *meth_Item_vertex(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        long a0;
         ::Item *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bl", &sipSelf, sipType_Item, &sipCpp, &a0))
        {
             ::Point*sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::Point(sipCpp->vertex(a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_Point,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Item, sipName_vertex, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_Item_setVertex, "        Change a vertex on the contour of the item.\n"
"        :param idx: The index of the vertex to change. Should not be\n"
"        vertexCount() or higher.\n"
"        :param v: The new coordinates of that vertex.");

extern "C" {static PyObject *meth_Item_setVertex(PyObject *, PyObject *);}
static PyObject *meth_Item_setVertex(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        long a0;
         ::Point* a1;
         ::Item *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BlJ9", &sipSelf, sipType_Item, &sipCpp, &a0, sipType_Point, &a1))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->setVertex(a0,*a1);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Item, sipName_setVertex, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_Item_area, "        Compute the surface area of the item.\n"
"\n"
"        This is a signed area. If the polygon has the wrong winding order, this\n"
"        area will be negative.\n"
"        :return: The surface area of the item.");

extern "C" {static PyObject *meth_Item_area(PyObject *, PyObject *);}
static PyObject *meth_Item_area(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::Item *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_Item, &sipCpp))
        {
            double sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->area();
            Py_END_ALLOW_THREADS

            return PyFloat_FromDouble(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Item, sipName_area, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_Item_isContourConvex, "        Compute whether the shape of this item is completely convex.\n"
"\n"
"        The result is cached, so it is safe to query convexity multiple times on\n"
"        the same item as long as the item is not modified in between.\n"
"        :return: True if the item is convex, or False otherwise.");

extern "C" {static PyObject *meth_Item_isContourConvex(PyObject *, PyObject *);}
static PyObject *meth_Item_isContourConvex(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::Item *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_Item, &sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isContourConvex();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Item, sipName_isContourConvex, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_Item_isHoleConvex, "        For holes in the shape, return if the hole is convex.\n"
"        :param holeindex: The index of the hole in the shape. Should be less\n"
"        than holeCount().\n"
"        :return: True if the specified hole is convex, or False if it's concave.");

extern "C" {static PyObject *meth_Item_isHoleConvex(PyObject *, PyObject *);}
static PyObject *meth_Item_isHoleConvex(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        long a0;
         ::Item *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bl", &sipSelf, sipType_Item, &sipCpp, &a0))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isHoleConvex(a0);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Item, sipName_isHoleConvex, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_Item_areHolesConvex, "        Returns whether all holes are convex.\n"
"\n"
"        This is the same as going through all holes and querying isHoleConvex()\n"
"        for all of them.\n"
"        :return: True if all holes in the shape are convex, or False if there is\n"
"        at least one concave hole.");

extern "C" {static PyObject *meth_Item_areHolesConvex(PyObject *, PyObject *);}
static PyObject *meth_Item_areHolesConvex(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::Item *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_Item, &sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->areHolesConvex();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Item, sipName_areHolesConvex, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_Item_vertexCount, "        Get the number of vertices in total in the shape of the item.\n"
"        :return: The number of vertices in the contour.");

extern "C" {static PyObject *meth_Item_vertexCount(PyObject *, PyObject *);}
static PyObject *meth_Item_vertexCount(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::Item *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_Item, &sipCpp))
        {
            long sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->vertexCount();
            Py_END_ALLOW_THREADS

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Item, sipName_vertexCount, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_Item_holeCount, "        Get the number of holes in the shape of the item.\n"
"        :return: The number of holes in the shape.");

extern "C" {static PyObject *meth_Item_holeCount(PyObject *, PyObject *);}
static PyObject *meth_Item_holeCount(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::Item *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_Item, &sipCpp))
        {
            long sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->holeCount();
            Py_END_ALLOW_THREADS

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Item, sipName_holeCount, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_Item_isInside, "        Tests whether a point is contained in the shape of this item.\n"
"        :param p: The point to test whether it's contained in this item.\n"
"        :return: True if the point is inside the shape, or False if it's\n"
"        outside.\n"
"        Tests whether a different item is engulfed wholly inside of this item.\n"
"        :param sh: The item to test for whether it is inside of this item.\n"
"        :return: True if the item is wholly engulfed in this item, or False if\n"
"        it falls partially or completely outside of this item.\n"
"        Tests whether the box falls completely inside of this item.\n"
"        :param box: The box to test for being contained in this item.\n"
"        :return: True if the box is wholly engulfed in this item, or False if it falls partially or completely outside of this item.\n"
"        Tests whether the circle falls completely inside of this item.\n"
"        :param circle: The circle to test for being contained in this item.\n"
"        :return: True if the circle is wholly engulfed in this item, or False if it falls partially or completely outside of this item.");

extern "C" {static PyObject *meth_Item_isInside(PyObject *, PyObject *);}
static PyObject *meth_Item_isInside(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::Point* a0;
         ::Item *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_Item, &sipCpp, sipType_Point, &a0))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isInside(*a0);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    {
         ::Item* a0;
         ::Item *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_Item, &sipCpp, sipType_Item, &a0))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isInside(*a0);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    {
         ::Box* a0;
         ::Item *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_Item, &sipCpp, sipType_Box, &a0))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isInside(*a0);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    {
         ::Circle* a0;
         ::Item *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_Item, &sipCpp, sipType_Circle, &a0))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isInside(*a0);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Item, sipName_isInside, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_Item_boundingBox, "        Return the smallest axis-aligned bounding box around this item.\n"
"        :return: A bounding box around this item.");

extern "C" {static PyObject *meth_Item_boundingBox(PyObject *, PyObject *);}
static PyObject *meth_Item_boundingBox(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::Item *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_Item, &sipCpp))
        {
             ::Box*sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::Box(sipCpp->boundingBox());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_Box,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Item, sipName_boundingBox, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_Item_referenceVertex, "        Return a vertex that serves as a reference for this item's shape.\n"
"\n"
"        The vertex will always be the same if the vertices of the item are the\n"
"        same, even if those vertices are in a different order or if a different\n"
"        item has precisely the same vertices. This can be used for instance to\n"
"        always start iteration in the same spot if the shape is the same.\n"
"        :return: A vertex that serves as reference for the shape.");

extern "C" {static PyObject *meth_Item_referenceVertex(PyObject *, PyObject *);}
static PyObject *meth_Item_referenceVertex(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::Item *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_Item, &sipCpp))
        {
             ::Point*sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::Point(sipCpp->referenceVertex());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_Point,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Item, sipName_referenceVertex, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_Item_rightmostTopVertex, "        Returns the right-most vertex (highest X coordinate). Or if multiple\n"
"        vertices are equally far right, the top-most one of those (highest Y\n"
"        coordinate).\n"
"\n"
"        This works on the transformed shape.\n"
"        :return: The highest of the right-most vertices.");

extern "C" {static PyObject *meth_Item_rightmostTopVertex(PyObject *, PyObject *);}
static PyObject *meth_Item_rightmostTopVertex(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::Item *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_Item, &sipCpp))
        {
             ::Point*sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::Point(sipCpp->rightmostTopVertex());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_Point,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Item, sipName_rightmostTopVertex, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_Item_leftmostBottomVertex, "        Returns the left-most vertex (lowest X coordinate). Or if multiple\n"
"        vertices are equally far left, the bottom-most one of those (lowest Y\n"
"        coordinate).\n"
"\n"
"        This works on the transformed shape.\n"
"        :return: The lowest of the left-most vertices.");

extern "C" {static PyObject *meth_Item_leftmostBottomVertex(PyObject *, PyObject *);}
static PyObject *meth_Item_leftmostBottomVertex(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::Item *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_Item, &sipCpp))
        {
             ::Point*sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::Point(sipCpp->leftmostBottomVertex());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_Point,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Item, sipName_leftmostBottomVertex, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_Item_translate, "        Move the item relatively in a certain direction.\n"
"\n"
"        The vertices are not actually transformed in-place, but the\n"
"        transformation of the item is changed. The moved vertices can be found\n"
"        by calling transformedShape().\n"
"\n"
"        To arrive at the transformed shape of an item, the rotation is applied\n"
"        first, then the translation. Translation is only afterwards, so first\n"
"        translating the object and then rotating it will not cause the item to\n"
"        rotate by the translation vector around 0. It will rotate around its\n"
"        original 0 coordinate instead.\n"
"        :param delta: The motion vector by which to move this item.");

extern "C" {static PyObject *meth_Item_translate(PyObject *, PyObject *);}
static PyObject *meth_Item_translate(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::Point* a0;
         ::Item *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_Item, &sipCpp, sipType_Point, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->translate(*a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Item, sipName_translate, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_Item_translation, "        Get the current translation of the item.\n"
"\n"
"        This gets changed by arranging the items in the bins.\n"
"        :return: The current translation of the item.");

extern "C" {static PyObject *meth_Item_translation(PyObject *, PyObject *);}
static PyObject *meth_Item_translation(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::Item *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_Item, &sipCpp))
        {
             ::Point*sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::Point(sipCpp->translation());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_Point,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Item, sipName_translation, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_Item_rotate, "        Rotate the item by a certain amount.\n"
"\n"
"        The vertices are not actually transformed in-place, but the\n"
"        transformation of the item is changed. The moved vertices can be found\n"
"        by calling transformedShape().\n"
"        :param radians: The amount of rotation to apply, in radians. A positive\n"
"        rotation will rotate the item counter-clockwise.");

extern "C" {static PyObject *meth_Item_rotate(PyObject *, PyObject *);}
static PyObject *meth_Item_rotate(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        double a0;
         ::Item *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bd", &sipSelf, sipType_Item, &sipCpp, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->rotate(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Item, sipName_rotate, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_Item_rotation, "        Get the current amount of rotation applied to the model.\n"
"\n"
"        This gets changed by arranging the items in the bins.\n"
"        :return: The current rotation of the model.");

extern "C" {static PyObject *meth_Item_rotation(PyObject *, PyObject *);}
static PyObject *meth_Item_rotation(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::Item *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_Item, &sipCpp))
        {
            double sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->rotation();
            Py_END_ALLOW_THREADS

            return PyFloat_FromDouble(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Item, sipName_rotation, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_Item_inflation, "        Offset the shape by a certain amount. This will make the shape wider in\n"
"        all directions, as if performing a Minkowski sum with a circle with the\n"
"        specified distance as radius.\n"
"\n"
"        A negative distance will result in an inset of the original shape.\n"
"        :param distance: The distance by which to offset the shape.\n"
"        Get the current amount of inflation from the original shape.\n"
"        :return The current amount of inflation.");

extern "C" {static PyObject *meth_Item_inflation(PyObject *, PyObject *);}
static PyObject *meth_Item_inflation(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        long a0;
         ::Item *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bl", &sipSelf, sipType_Item, &sipCpp, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->inflation(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
         ::Item *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_Item, &sipCpp))
        {
            long sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->inflation();
            Py_END_ALLOW_THREADS

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Item, sipName_inflation, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_Item_transformedShape, "        Create a new item that has the transformation of this item applied to\n"
"        its vertices.\n"
"\n"
"        From the new item you can get the vertex coordinates to get the\n"
"        polygonal coordinates of the transformed shape.\n"
"        :return: A copy of this item, but with the transformation applied to its\n"
"        vertices.");

extern "C" {static PyObject *meth_Item_transformedShape(PyObject *, PyObject *);}
static PyObject *meth_Item_transformedShape(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::Item *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_Item, &sipCpp))
        {
             ::Item*sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::Item(sipCpp->transformedShape());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_Item,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Item, sipName_transformedShape, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_Item_resetTransformation, "        Remove all transformations on this item, reverting it to its original\n"
"        state.");

extern "C" {static PyObject *meth_Item_resetTransformation(PyObject *, PyObject *);}
static PyObject *meth_Item_resetTransformation(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::Item *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_Item, &sipCpp))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->resetTransformation();
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Item, sipName_resetTransformation, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_Item_intersects, "        Test whether two items intersect.\n"
"\n"
"        Two items intersect only if they have a non-zero area of overlap.\n"
"        :param sh1: One of the items to test intersection with.\n"
"        :param sh2: The other item to test intersection with.\n"
"        :return: True if they intersect, or False if they are disjoint.");

extern "C" {static PyObject *meth_Item_intersects(PyObject *, PyObject *);}
static PyObject *meth_Item_intersects(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::Item* a0;
         ::Item* a1;

        if (sipParseArgs(&sipParseErr, sipArgs, "J9J9", sipType_Item, &a0, sipType_Item, &a1))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::Item::intersects(*a0,*a1);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Item, sipName_intersects, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_Item_touches, "        Test whether two items touch.\n"
"\n"
"        Touching items includes the edge case where two items touch only on a vertex or on an edge but don't necessarily have any positive area of overlap. They may also just touch on the contour of the shape.\n"
"\n"
"        If two items intersect, they also always touch.");

extern "C" {static PyObject *meth_Item_touches(PyObject *, PyObject *);}
static PyObject *meth_Item_touches(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::Item* a0;
         ::Item* a1;

        if (sipParseArgs(&sipParseErr, sipArgs, "J9J9", sipType_Item, &a0, sipType_Item, &a1))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::Item::touches(*a0,*a1);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Item, sipName_touches, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_Item(void *, int);}
static void release_Item(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::Item *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_Item(void *, SIP_SSIZE_T, void *);}
static void assign_Item(void *sipDst, SIP_SSIZE_T sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::Item *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::Item *>(sipSrc);
}


extern "C" {static void *copy_Item(const void *, SIP_SSIZE_T);}
static void *copy_Item(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new  ::Item(reinterpret_cast<const  ::Item *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_Item(sipSimpleWrapper *);}
static void dealloc_Item(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_Item(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_Item(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_Item(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::Item *sipCpp = SIP_NULLPTR;

    {
        PyObject * a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "P0", &a0))
        {
#line 39 "/build/python-pynest2d/src/pynest2d-4.12.0/src/Item.sip"
        if(!PyList_Check(a0))
        {
            return NULL;
        }
        std::vector<Point> vertices;
        const size_t size = PyList_GET_SIZE(a0);
        vertices.reserve(size);
        PyErr_Clear(); //To allow us to test if any Python errors occurred.
        for(size_t i = 0; i < size; ++i)
        {
            PyObject* vertex = PyList_GET_ITEM(a0, i);
            const long x = PyLong_AsLong(PyObject_CallMethod(vertex, "x", NULL));
            const long y = PyLong_AsLong(PyObject_CallMethod(vertex, "y", NULL));
            vertices.emplace_back(x, y);
            if(PyErr_Occurred() != NULL) //Something broke. Need to clean up. Maybe the input is not proper Point instances.
            {
                return NULL;
            }
        }
        sipCpp = new Item(vertices); //Makes a copy of the vertices!
#line 1307 "/build/python-pynest2d/src/pynest2d-4.12.0/build/src/sippynest2dpart3.cpp"

            return sipCpp;
        }
    }

    {
        const  ::Item* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_Item, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::Item(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_Item[] = {
    {SIP_MLNAME_CAST(sipName_areHolesConvex), meth_Item_areHolesConvex, METH_VARARGS, SIP_MLDOC_CAST(doc_Item_areHolesConvex)},
    {SIP_MLNAME_CAST(sipName_area), meth_Item_area, METH_VARARGS, SIP_MLDOC_CAST(doc_Item_area)},
    {SIP_MLNAME_CAST(sipName_binId), meth_Item_binId, METH_VARARGS, SIP_MLDOC_CAST(doc_Item_binId)},
    {SIP_MLNAME_CAST(sipName_boundingBox), meth_Item_boundingBox, METH_VARARGS, SIP_MLDOC_CAST(doc_Item_boundingBox)},
    {SIP_MLNAME_CAST(sipName_holeCount), meth_Item_holeCount, METH_VARARGS, SIP_MLDOC_CAST(doc_Item_holeCount)},
    {SIP_MLNAME_CAST(sipName_inflation), meth_Item_inflation, METH_VARARGS, SIP_MLDOC_CAST(doc_Item_inflation)},
    {SIP_MLNAME_CAST(sipName_intersects), meth_Item_intersects, METH_VARARGS, SIP_MLDOC_CAST(doc_Item_intersects)},
    {SIP_MLNAME_CAST(sipName_isContourConvex), meth_Item_isContourConvex, METH_VARARGS, SIP_MLDOC_CAST(doc_Item_isContourConvex)},
    {SIP_MLNAME_CAST(sipName_isDisallowedArea), meth_Item_isDisallowedArea, METH_VARARGS, SIP_MLDOC_CAST(doc_Item_isDisallowedArea)},
    {SIP_MLNAME_CAST(sipName_isFixed), meth_Item_isFixed, METH_VARARGS, SIP_MLDOC_CAST(doc_Item_isFixed)},
    {SIP_MLNAME_CAST(sipName_isHoleConvex), meth_Item_isHoleConvex, METH_VARARGS, SIP_MLDOC_CAST(doc_Item_isHoleConvex)},
    {SIP_MLNAME_CAST(sipName_isInside), meth_Item_isInside, METH_VARARGS, SIP_MLDOC_CAST(doc_Item_isInside)},
    {SIP_MLNAME_CAST(sipName_leftmostBottomVertex), meth_Item_leftmostBottomVertex, METH_VARARGS, SIP_MLDOC_CAST(doc_Item_leftmostBottomVertex)},
    {SIP_MLNAME_CAST(sipName_markAsDisallowedAreaInBin), meth_Item_markAsDisallowedAreaInBin, METH_VARARGS, SIP_MLDOC_CAST(doc_Item_markAsDisallowedAreaInBin)},
    {SIP_MLNAME_CAST(sipName_markAsFixedInBin), meth_Item_markAsFixedInBin, METH_VARARGS, SIP_MLDOC_CAST(doc_Item_markAsFixedInBin)},
    {SIP_MLNAME_CAST(sipName_priority), meth_Item_priority, METH_VARARGS, SIP_MLDOC_CAST(doc_Item_priority)},
    {SIP_MLNAME_CAST(sipName_referenceVertex), meth_Item_referenceVertex, METH_VARARGS, SIP_MLDOC_CAST(doc_Item_referenceVertex)},
    {SIP_MLNAME_CAST(sipName_resetTransformation), meth_Item_resetTransformation, METH_VARARGS, SIP_MLDOC_CAST(doc_Item_resetTransformation)},
    {SIP_MLNAME_CAST(sipName_rightmostTopVertex), meth_Item_rightmostTopVertex, METH_VARARGS, SIP_MLDOC_CAST(doc_Item_rightmostTopVertex)},
    {SIP_MLNAME_CAST(sipName_rotate), meth_Item_rotate, METH_VARARGS, SIP_MLDOC_CAST(doc_Item_rotate)},
    {SIP_MLNAME_CAST(sipName_rotation), meth_Item_rotation, METH_VARARGS, SIP_MLDOC_CAST(doc_Item_rotation)},
    {SIP_MLNAME_CAST(sipName_setVertex), meth_Item_setVertex, METH_VARARGS, SIP_MLDOC_CAST(doc_Item_setVertex)},
    {SIP_MLNAME_CAST(sipName_toString), meth_Item_toString, METH_VARARGS, SIP_MLDOC_CAST(doc_Item_toString)},
    {SIP_MLNAME_CAST(sipName_touches), meth_Item_touches, METH_VARARGS, SIP_MLDOC_CAST(doc_Item_touches)},
    {SIP_MLNAME_CAST(sipName_transformedShape), meth_Item_transformedShape, METH_VARARGS, SIP_MLDOC_CAST(doc_Item_transformedShape)},
    {SIP_MLNAME_CAST(sipName_translate), meth_Item_translate, METH_VARARGS, SIP_MLDOC_CAST(doc_Item_translate)},
    {SIP_MLNAME_CAST(sipName_translation), meth_Item_translation, METH_VARARGS, SIP_MLDOC_CAST(doc_Item_translation)},
    {SIP_MLNAME_CAST(sipName_vertex), meth_Item_vertex, METH_VARARGS, SIP_MLDOC_CAST(doc_Item_vertex)},
    {SIP_MLNAME_CAST(sipName_vertexCount), meth_Item_vertexCount, METH_VARARGS, SIP_MLDOC_CAST(doc_Item_vertexCount)}
};

PyDoc_STRVAR(doc_Item, "        An item represents something that needs to be fit in the scene.\n"
"\n"
"        An item has a certain shape. For these Python bindings that shape will\n"
"        always be a polygon.\n"
"\n"
"        After the nesting has taken place, the item will be transformed. The\n"
"        transformation is encoded in a translation and a rotation. You may also\n"
"        manually scale the item if necessary. The transformed shape can be\n"
"        computed with the transformedShape() function. The original vertex\n"
"        coordinates are not modified then. The item will also be placed in a\n"
"        certain bin, which is normally the first bin unless the first bin is\n"
"        packed completely full.\n"
"\n"
"        An item can be fixed in place with the markAsFixedInBin() function,\n"
"        preventing the nester to move it. It only blocks other items\n"
"        from being placed then.");


sipClassTypeDef sipTypeDef_pynest2d_Item = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_CLASS,
        sipNameNr_Item,
        {SIP_NULLPTR},
        SIP_NULLPTR
    },
    {
        sipNameNr_Item,
        {0, 0, 1},
        29, methods_Item,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_Item,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_Item,
    SIP_NULLPTR,
    SIP_NULLPTR,
#if PY_MAJOR_VERSION >= 3
    SIP_NULLPTR,
    SIP_NULLPTR,
#else
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
#endif
    dealloc_Item,
    assign_Item,
    SIP_NULLPTR,
    copy_Item,
    release_Item,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR
};
