/*
 * Module code.
 *
 * Generated by SIP 4.19.25
 */

#include "sipAPIpynest2d.h"

#line 12 "/build/python-pynest2d/src/pynest2d-4.12.0/src/String.sip"
        #include <string>
#line 12 "/build/python-pynest2d/src/pynest2d-4.12.0/build/src/sippynest2dpart1.cpp"



extern "C" {static void assign_std_string(void *, SIP_SSIZE_T, void *);}
static void assign_std_string(void *sipDst, SIP_SSIZE_T sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::std::string *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::std::string *>(sipSrc);
}


extern "C" {static void *array_std_string(SIP_SSIZE_T);}
static void *array_std_string(SIP_SSIZE_T sipNrElem)
{
    return new  ::std::string[sipNrElem];
}


extern "C" {static void *copy_std_string(const void *, SIP_SSIZE_T);}
static void *copy_std_string(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new  ::std::string(reinterpret_cast<const  ::std::string *>(sipSrc)[sipSrcIdx]);
}


/* Call the mapped type's destructor. */
extern "C" {static void release_std_string(void *, int);}
static void release_std_string(void *ptr, int)
{
    Py_BEGIN_ALLOW_THREADS
    delete reinterpret_cast< ::std::string *>(ptr);
    Py_END_ALLOW_THREADS
}



extern "C" {static int convertTo_std_string(PyObject *, void **, int *, PyObject *);}
static int convertTo_std_string(PyObject *sipPy,void **sipCppPtrV,int *sipIsErr,PyObject *)
{
     ::std::string **sipCppPtr = reinterpret_cast< ::std::string **>(sipCppPtrV);

#line 25 "/build/python-pynest2d/src/pynest2d-4.12.0/src/String.sip"
        if(!sipIsErr) //Just a request to check if we can convert.
        {
            return PyBytes_Check(sipPy) || PyUnicode_Check(sipPy); //We can convert from Python bytes and str.
        }

        if(sipPy == Py_None) //Convert None to empty string. Happens when we supply no parameter to the str() function.
        {
            *sipCppPtr = new std::string();
            return 1;
        }
        else if(PyUnicode_Check(sipPy)) //Is a str.
        {
            PyObject* str = PyUnicode_AsEncodedString(sipPy, "UTF-8", ""); //Temporarily convert to Python str which has the AS_STRING function.
            *sipCppPtr = new std::string(PyBytes_AS_STRING(str));
            Py_DECREF(str); //Temporary object goes immediately out of scope.
            return 1;
        }
        else if(PyBytes_Check(sipPy)) //Is a str.
        {
            *sipCppPtr = new std::string(PyBytes_AS_STRING(sipPy));
            return 1;
        }
        else
        {
            return 0;
        }
#line 80 "/build/python-pynest2d/src/pynest2d-4.12.0/build/src/sippynest2dpart1.cpp"
}


extern "C" {static PyObject *convertFrom_std_string(void *, PyObject *);}
static PyObject *convertFrom_std_string(void *sipCppV, PyObject *)
{
    ::std::string *sipCpp = reinterpret_cast< ::std::string *>(sipCppV);

#line 16 "/build/python-pynest2d/src/pynest2d-4.12.0/src/String.sip"
        PyObject* result = PyUnicode_DecodeUTF8(sipCpp->c_str(), sipCpp->length(), NULL);
        if(!result)
        {
            result = PyBytes_FromString(sipCpp->c_str());
        }
        return result;
#line 96 "/build/python-pynest2d/src/pynest2d-4.12.0/build/src/sippynest2dpart1.cpp"
}


sipMappedTypeDef sipTypeDef_pynest2d_std_string = {
    {
        -1,
        SIP_NULLPTR,
        0,
        SIP_TYPE_MAPPED,
        sipNameNr_std__string,     /* std::string */
        {0},
        0
    },
    {
        -1,
        {0, 0, 1},
        0, 0,
        0, 0,
        0, 0,
        {0, 0, 0, 0, 0, 0, 0, 0, 0, 0}
    },
    assign_std_string,
    array_std_string,
    copy_std_string,
    release_std_string,
    convertTo_std_string,
    convertFrom_std_string
};

#line 12 "/build/python-pynest2d/src/pynest2d-4.12.0/src/Rectangle.sip"
        #include <libnest2d/libnest2d.hpp>
#line 128 "/build/python-pynest2d/src/pynest2d-4.12.0/build/src/sippynest2dpart1.cpp"

#line 26 "/build/python-pynest2d/src/pynest2d-4.12.0/src/Item.sip"
        #include <libnest2d/libnest2d.hpp>
#line 132 "/build/python-pynest2d/src/pynest2d-4.12.0/build/src/sippynest2dpart1.cpp"
#line 10 "/build/python-pynest2d/src/pynest2d-4.12.0/src/Point.sip"
        #include <libnest2d/libnest2d.hpp>
#line 135 "/build/python-pynest2d/src/pynest2d-4.12.0/build/src/sippynest2dpart1.cpp"
#line 11 "/build/python-pynest2d/src/pynest2d-4.12.0/src/Box.sip"
        #include <libnest2d/libnest2d.hpp>
#line 138 "/build/python-pynest2d/src/pynest2d-4.12.0/build/src/sippynest2dpart1.cpp"
#line 11 "/build/python-pynest2d/src/pynest2d-4.12.0/src/Circle.sip"
        #include <libnest2d/libnest2d.hpp>
#line 141 "/build/python-pynest2d/src/pynest2d-4.12.0/build/src/sippynest2dpart1.cpp"
#line 12 "/build/python-pynest2d/src/pynest2d-4.12.0/src/String.sip"
        #include <string>
#line 144 "/build/python-pynest2d/src/pynest2d-4.12.0/build/src/sippynest2dpart1.cpp"


PyDoc_STRVAR(doc_Rectangle_width, "        Get the width of this rectangle.\n"
"        :return: The width of the rectangle.");

extern "C" {static PyObject *meth_Rectangle_width(PyObject *, PyObject *);}
static PyObject *meth_Rectangle_width(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::Rectangle *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_Rectangle, &sipCpp))
        {
            long sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->width();
            Py_END_ALLOW_THREADS

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Rectangle, sipName_width, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_Rectangle_height, "        Get the height of this rectangle.\n"
"        :return: The height of the rectangle.");

extern "C" {static PyObject *meth_Rectangle_height(PyObject *, PyObject *);}
static PyObject *meth_Rectangle_height(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::Rectangle *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_Rectangle, &sipCpp))
        {
            long sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->height();
            Py_END_ALLOW_THREADS

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Rectangle, sipName_height, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_Rectangle_binId, "        The bin that this item is assigned to, or -1 if it's not (yet) assigned\n"
"        to any bin.\n"
"\n"
"        The assigned bin is a version of the bin shape. If all objects fit in\n"
"        one bin, their bin IDs will all be 0. If they don't fit, new bins will\n"
"        be created and some objects will be put in the new bin.\n"
"        :return: The currently assigned bin of this item.\n"
"        Assign this item to a bin.\n"
"\n"
"        Assigning to a negative number effectively takes this object out of all\n"
"        bins. Use -1 to unassign the item from all bins.\n"
"        :param idx: The index of the bin to assign the item to.");

extern "C" {static PyObject *meth_Rectangle_binId(PyObject *, PyObject *);}
static PyObject *meth_Rectangle_binId(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::Rectangle *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_Rectangle, &sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->binId();
            Py_END_ALLOW_THREADS

            return SIPLong_FromLong(sipRes);
        }
    }

    {
        int a0;
         ::Rectangle *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_Rectangle, &sipCpp, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->binId(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Rectangle, sipName_binId, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_Rectangle_isFixed, "        Whether this item is fixed in place, not able to be moved by the nester.\n"
"\n"
"        If the item is fixed, the nester is not allowed to move it and must\n"
"        place other items around it.\n"
"        :return: Whether the item is fixed in a certain bin.");

extern "C" {static PyObject *meth_Rectangle_isFixed(PyObject *, PyObject *);}
static PyObject *meth_Rectangle_isFixed(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::Rectangle *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_Rectangle, &sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isFixed();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Rectangle, sipName_isFixed, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_Rectangle_markAsFixedInBin, "        Make this item a fixed item in a certain bin.\n"
"\n"
"        If the item is fixed, the nester is not allowed to move it and must\n"
"        place other items around it in that bin.\n"
"\n"
"        This currently only works with the FirstFit selector (which is the\n"
"        default).\n"
"        :param binid: The bin in which this item is fixed.");

extern "C" {static PyObject *meth_Rectangle_markAsFixedInBin(PyObject *, PyObject *);}
static PyObject *meth_Rectangle_markAsFixedInBin(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
         ::Rectangle *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_Rectangle, &sipCpp, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->markAsFixedInBin(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Rectangle, sipName_markAsFixedInBin, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_Rectangle_priority, "        Gives the current priority of selecting this item.\n"
"\n"
"        Items with greater priority (higher number) get selected first by the\n"
"        selectors.\n"
"        :return: The priority of selecting this item.\n"
"        Sets the priority of selecting this item.\n"
"\n"
"        Items with greater priority (higher number) get selected first by the\n"
"        selectors. This causes them to be placed in earlier bins and perhaps\n"
"        more towards the point where the objects get aligned to (depending on\n"
"        the placer).\n"
"\n"
"        The priority is not a guarantee. The selector may still select different\n"
"        items first. It only serves as an intuitive way to steer which objects\n"
"        are the most important to be placed.\n"
"        :param priority: The priority to give to this item.");

extern "C" {static PyObject *meth_Rectangle_priority(PyObject *, PyObject *);}
static PyObject *meth_Rectangle_priority(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::Rectangle *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_Rectangle, &sipCpp))
        {
            int sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->priority();
            Py_END_ALLOW_THREADS

            return SIPLong_FromLong(sipRes);
        }
    }

    {
        int a0;
         ::Rectangle *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_Rectangle, &sipCpp, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->priority(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Rectangle, sipName_priority, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_Rectangle_toString, "        Give a string representation of this item.\n"
"            \n"
"        This will give a list of all the vertices in the contour of the item.\n"
"        :return: A string representation of the item.");

extern "C" {static PyObject *meth_Rectangle_toString(PyObject *, PyObject *);}
static PyObject *meth_Rectangle_toString(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::Rectangle *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_Rectangle, &sipCpp))
        {
             ::std::string*sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::std::string(sipCpp->toString());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_std_string,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Rectangle, sipName_toString, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_Rectangle_area, "        Compute the surface area of the item.\n"
"\n"
"        This is a signed area. If the polygon has the wrong winding order, this\n"
"        area will be negative.\n"
"        :return: The surface area of the item.");

extern "C" {static PyObject *meth_Rectangle_area(PyObject *, PyObject *);}
static PyObject *meth_Rectangle_area(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::Rectangle *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_Rectangle, &sipCpp))
        {
            double sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->area();
            Py_END_ALLOW_THREADS

            return PyFloat_FromDouble(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Rectangle, sipName_area, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_Rectangle_isContourConvex, "        Compute whether the shape of this item is completely convex.\n"
"\n"
"        The result is cached, so it is safe to query convexity multiple times on\n"
"        the same item as long as the item is not modified in between.\n"
"        :return: True if the item is convex, or False otherwise.");

extern "C" {static PyObject *meth_Rectangle_isContourConvex(PyObject *, PyObject *);}
static PyObject *meth_Rectangle_isContourConvex(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::Rectangle *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_Rectangle, &sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isContourConvex();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Rectangle, sipName_isContourConvex, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_Rectangle_isHoleConvex, "        For holes in the shape, return if the hole is convex.\n"
"        :param holeindex: The index of the hole in the shape. Should be less\n"
"        than holeCount().\n"
"        :return: True if the specified hole is convex, or False if it's concave.");

extern "C" {static PyObject *meth_Rectangle_isHoleConvex(PyObject *, PyObject *);}
static PyObject *meth_Rectangle_isHoleConvex(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        long a0;
         ::Rectangle *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bl", &sipSelf, sipType_Rectangle, &sipCpp, &a0))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isHoleConvex(a0);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Rectangle, sipName_isHoleConvex, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_Rectangle_areHolesConvex, "        Returns whether all holes are convex.\n"
"\n"
"        This is the same as going through all holes and querying isHoleConvex()\n"
"        for all of them.\n"
"        :return: True if all holes in the shape are convex, or False if there is\n"
"        at least one concave hole.");

extern "C" {static PyObject *meth_Rectangle_areHolesConvex(PyObject *, PyObject *);}
static PyObject *meth_Rectangle_areHolesConvex(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::Rectangle *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_Rectangle, &sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->areHolesConvex();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Rectangle, sipName_areHolesConvex, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_Rectangle_vertexCount, "        Get the number of vertices in total in the shape of the item.\n"
"        :return: The number of vertices in the contour.");

extern "C" {static PyObject *meth_Rectangle_vertexCount(PyObject *, PyObject *);}
static PyObject *meth_Rectangle_vertexCount(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::Rectangle *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_Rectangle, &sipCpp))
        {
            long sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->vertexCount();
            Py_END_ALLOW_THREADS

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Rectangle, sipName_vertexCount, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_Rectangle_holeCount, "        Get the number of holes in the shape of the item.\n"
"        :return: The number of holes in the shape.");

extern "C" {static PyObject *meth_Rectangle_holeCount(PyObject *, PyObject *);}
static PyObject *meth_Rectangle_holeCount(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::Rectangle *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_Rectangle, &sipCpp))
        {
            long sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->holeCount();
            Py_END_ALLOW_THREADS

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Rectangle, sipName_holeCount, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_Rectangle_isInside, "        Tests whether a point is contained in the shape of this item.\n"
"        :param p: The point to test whether it's contained in this item.\n"
"        :return: True if the point is inside the shape, or False if it's\n"
"        outside.\n"
"        Tests whether a different item is engulfed wholly inside of this item.\n"
"        :param sh: The item to test for whether it is inside of this item.\n"
"        :return: True if the item is wholly engulfed in this item, or False if\n"
"        it falls partially or completely outside of this item.\n"
"        Tests whether the box falls completely inside of this item.\n"
"        :param box: The box to test for being contained in this item.\n"
"        :return: True if the box is wholly engulfed in this item, or False if it falls partially or completely outside of this item.\n"
"        Tests whether the circle falls completely inside of this item.\n"
"        :param circle: The circle to test for being contained in this item.\n"
"        :return: True if the circle is wholly engulfed in this item, or False if it falls partially or completely outside of this item.");

extern "C" {static PyObject *meth_Rectangle_isInside(PyObject *, PyObject *);}
static PyObject *meth_Rectangle_isInside(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::Point* a0;
         ::Rectangle *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_Rectangle, &sipCpp, sipType_Point, &a0))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isInside(*a0);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    {
         ::Item* a0;
         ::Rectangle *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_Rectangle, &sipCpp, sipType_Item, &a0))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isInside(*a0);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    {
         ::Box* a0;
         ::Rectangle *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_Rectangle, &sipCpp, sipType_Box, &a0))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isInside(*a0);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    {
         ::Circle* a0;
         ::Rectangle *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_Rectangle, &sipCpp, sipType_Circle, &a0))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->isInside(*a0);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Rectangle, sipName_isInside, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_Rectangle_boundingBox, "        Return the smallest axis-aligned bounding box around this item.\n"
"        :return: A bounding box around this item.");

extern "C" {static PyObject *meth_Rectangle_boundingBox(PyObject *, PyObject *);}
static PyObject *meth_Rectangle_boundingBox(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::Rectangle *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_Rectangle, &sipCpp))
        {
             ::Box*sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::Box(sipCpp->boundingBox());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_Box,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Rectangle, sipName_boundingBox, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_Rectangle_referenceVertex, "        Return a vertex that serves as a reference for this item's shape.\n"
"\n"
"        The vertex will always be the same if the vertices of the item are the\n"
"        same, even if those vertices are in a different order or if a different\n"
"        item has precisely the same vertices. This can be used for instance to\n"
"        always start iteration in the same spot if the shape is the same.\n"
"        :return: A vertex that serves as reference for the shape.");

extern "C" {static PyObject *meth_Rectangle_referenceVertex(PyObject *, PyObject *);}
static PyObject *meth_Rectangle_referenceVertex(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::Rectangle *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_Rectangle, &sipCpp))
        {
             ::Point*sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::Point(sipCpp->referenceVertex());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_Point,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Rectangle, sipName_referenceVertex, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_Rectangle_rightmostTopVertex, "        Returns the right-most vertex (highest X coordinate). Or if multiple\n"
"        vertices are equally far right, the top-most one of those (highest Y\n"
"        coordinate).\n"
"\n"
"        This works on the transformed shape.\n"
"        :return: The highest of the right-most vertices.");

extern "C" {static PyObject *meth_Rectangle_rightmostTopVertex(PyObject *, PyObject *);}
static PyObject *meth_Rectangle_rightmostTopVertex(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::Rectangle *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_Rectangle, &sipCpp))
        {
             ::Point*sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::Point(sipCpp->rightmostTopVertex());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_Point,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Rectangle, sipName_rightmostTopVertex, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_Rectangle_leftmostBottomVertex, "        Returns the left-most vertex (lowest X coordinate). Or if multiple\n"
"        vertices are equally far left, the bottom-most one of those (lowest Y\n"
"        coordinate).\n"
"\n"
"        This works on the transformed shape.\n"
"        :return: The lowest of the left-most vertices.");

extern "C" {static PyObject *meth_Rectangle_leftmostBottomVertex(PyObject *, PyObject *);}
static PyObject *meth_Rectangle_leftmostBottomVertex(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::Rectangle *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_Rectangle, &sipCpp))
        {
             ::Point*sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::Point(sipCpp->leftmostBottomVertex());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_Point,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Rectangle, sipName_leftmostBottomVertex, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_Rectangle_translate, "        Move the item relatively in a certain direction.\n"
"\n"
"        The vertices are not actually transformed in-place, but the\n"
"        transformation of the item is changed. The moved vertices can be found\n"
"        by calling transformedShape().\n"
"\n"
"        To arrive at the transformed shape of an item, the rotation is applied\n"
"        first, then the translation. Translation is only afterwards, so first\n"
"        translating the object and then rotating it will not cause the item to\n"
"        rotate by the translation vector around 0. It will rotate around its\n"
"        original 0 coordinate instead.\n"
"        :param delta: The motion vector by which to move this item.");

extern "C" {static PyObject *meth_Rectangle_translate(PyObject *, PyObject *);}
static PyObject *meth_Rectangle_translate(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::Point* a0;
         ::Rectangle *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_Rectangle, &sipCpp, sipType_Point, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->translate(*a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Rectangle, sipName_translate, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_Rectangle_translation, "        Get the current translation of the item.\n"
"\n"
"        This gets changed by arranging the items in the bins.\n"
"        :return: The current translation of the item.");

extern "C" {static PyObject *meth_Rectangle_translation(PyObject *, PyObject *);}
static PyObject *meth_Rectangle_translation(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::Rectangle *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_Rectangle, &sipCpp))
        {
             ::Point*sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::Point(sipCpp->translation());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_Point,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Rectangle, sipName_translation, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_Rectangle_rotate, "        Rotate the item by a certain amount.\n"
"\n"
"        The vertices are not actually transformed in-place, but the\n"
"        transformation of the item is changed. The moved vertices can be found\n"
"        by calling transformedShape().\n"
"        :param radians: The amount of rotation to apply, in radians. A positive\n"
"        rotation will rotate the item counter-clockwise.");

extern "C" {static PyObject *meth_Rectangle_rotate(PyObject *, PyObject *);}
static PyObject *meth_Rectangle_rotate(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        double a0;
         ::Rectangle *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bd", &sipSelf, sipType_Rectangle, &sipCpp, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->rotate(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Rectangle, sipName_rotate, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_Rectangle_rotation, "        Get the current amount of rotation applied to the model.\n"
"\n"
"        This gets changed by arranging the items in the bins.\n"
"        :return: The current rotation of the model.");

extern "C" {static PyObject *meth_Rectangle_rotation(PyObject *, PyObject *);}
static PyObject *meth_Rectangle_rotation(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::Rectangle *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_Rectangle, &sipCpp))
        {
            double sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->rotation();
            Py_END_ALLOW_THREADS

            return PyFloat_FromDouble(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Rectangle, sipName_rotation, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_Rectangle_inflation, "        Offset the shape by a certain amount. This will make the shape wider in\n"
"        all directions, as if performing a Minkowski sum with a circle with the\n"
"        specified distance as radius.\n"
"\n"
"        A negative distance will result in an inset of the original shape.\n"
"        :param distance: The distance by which to offset the shape.\n"
"        Get the current amount of inflation from the original shape.\n"
"        :return The current amount of inflation.");

extern "C" {static PyObject *meth_Rectangle_inflation(PyObject *, PyObject *);}
static PyObject *meth_Rectangle_inflation(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        long a0;
         ::Rectangle *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bl", &sipSelf, sipType_Rectangle, &sipCpp, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->inflation(a0);
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
         ::Rectangle *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_Rectangle, &sipCpp))
        {
            long sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->inflation();
            Py_END_ALLOW_THREADS

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Rectangle, sipName_inflation, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_Rectangle_transformedShape, "        Create a new item that has the transformation of this item applied to\n"
"        its vertices.\n"
"\n"
"        From the new item you can get the vertex coordinates to get the\n"
"        polygonal coordinates of the transformed shape.\n"
"        :return: A copy of this item, but with the transformation applied to its\n"
"        vertices.");

extern "C" {static PyObject *meth_Rectangle_transformedShape(PyObject *, PyObject *);}
static PyObject *meth_Rectangle_transformedShape(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::Rectangle *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_Rectangle, &sipCpp))
        {
             ::Item*sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::Item(sipCpp->transformedShape());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_Item,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Rectangle, sipName_transformedShape, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_Rectangle_resetTransformation, "        Remove all transformations on this item, reverting it to its original\n"
"        state.");

extern "C" {static PyObject *meth_Rectangle_resetTransformation(PyObject *, PyObject *);}
static PyObject *meth_Rectangle_resetTransformation(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::Rectangle *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_Rectangle, &sipCpp))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp->resetTransformation();
            Py_END_ALLOW_THREADS

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Rectangle, sipName_resetTransformation, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_Rectangle_intersects, "        Test whether two items intersect.\n"
"\n"
"        Two items intersect only if they have a non-zero area of overlap.\n"
"        :param sh1: One of the items to test intersection with.\n"
"        :param sh2: The other item to test intersection with.\n"
"        :return: True if they intersect, or False if they are disjoint.");

extern "C" {static PyObject *meth_Rectangle_intersects(PyObject *, PyObject *);}
static PyObject *meth_Rectangle_intersects(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::Item* a0;
         ::Item* a1;

        if (sipParseArgs(&sipParseErr, sipArgs, "J9J9", sipType_Item, &a0, sipType_Item, &a1))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::Rectangle::intersects(*a0,*a1);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Rectangle, sipName_intersects, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_Rectangle_touches, "        Test whether two items touch.\n"
"\n"
"        Touching items includes the edge case where two items touch only on a vertex or on an edge but don't necessarily have any positive area of overlap. They may also just touch on the contour of the shape.\n"
"\n"
"        If two items intersect, they also always touch.");

extern "C" {static PyObject *meth_Rectangle_touches(PyObject *, PyObject *);}
static PyObject *meth_Rectangle_touches(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::Item* a0;
         ::Item* a1;

        if (sipParseArgs(&sipParseErr, sipArgs, "J9J9", sipType_Item, &a0, sipType_Item, &a1))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::Rectangle::touches(*a0,*a1);
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Rectangle, sipName_touches, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_Rectangle(void *, int);}
static void release_Rectangle(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::Rectangle *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_Rectangle(void *, SIP_SSIZE_T, void *);}
static void assign_Rectangle(void *sipDst, SIP_SSIZE_T sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::Rectangle *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::Rectangle *>(sipSrc);
}


extern "C" {static void *copy_Rectangle(const void *, SIP_SSIZE_T);}
static void *copy_Rectangle(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new  ::Rectangle(reinterpret_cast<const  ::Rectangle *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_Rectangle(sipSimpleWrapper *);}
static void dealloc_Rectangle(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_Rectangle(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_Rectangle(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_Rectangle(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::Rectangle *sipCpp = SIP_NULLPTR;

    {
        long a0;
        long a1;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "ll", &a0, &a1))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::Rectangle(a0,a1);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    {
        const  ::Rectangle* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_Rectangle, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::Rectangle(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_Rectangle[] = {
    {SIP_MLNAME_CAST(sipName_areHolesConvex), meth_Rectangle_areHolesConvex, METH_VARARGS, SIP_MLDOC_CAST(doc_Rectangle_areHolesConvex)},
    {SIP_MLNAME_CAST(sipName_area), meth_Rectangle_area, METH_VARARGS, SIP_MLDOC_CAST(doc_Rectangle_area)},
    {SIP_MLNAME_CAST(sipName_binId), meth_Rectangle_binId, METH_VARARGS, SIP_MLDOC_CAST(doc_Rectangle_binId)},
    {SIP_MLNAME_CAST(sipName_boundingBox), meth_Rectangle_boundingBox, METH_VARARGS, SIP_MLDOC_CAST(doc_Rectangle_boundingBox)},
    {SIP_MLNAME_CAST(sipName_height), meth_Rectangle_height, METH_VARARGS, SIP_MLDOC_CAST(doc_Rectangle_height)},
    {SIP_MLNAME_CAST(sipName_holeCount), meth_Rectangle_holeCount, METH_VARARGS, SIP_MLDOC_CAST(doc_Rectangle_holeCount)},
    {SIP_MLNAME_CAST(sipName_inflation), meth_Rectangle_inflation, METH_VARARGS, SIP_MLDOC_CAST(doc_Rectangle_inflation)},
    {SIP_MLNAME_CAST(sipName_intersects), meth_Rectangle_intersects, METH_VARARGS, SIP_MLDOC_CAST(doc_Rectangle_intersects)},
    {SIP_MLNAME_CAST(sipName_isContourConvex), meth_Rectangle_isContourConvex, METH_VARARGS, SIP_MLDOC_CAST(doc_Rectangle_isContourConvex)},
    {SIP_MLNAME_CAST(sipName_isFixed), meth_Rectangle_isFixed, METH_VARARGS, SIP_MLDOC_CAST(doc_Rectangle_isFixed)},
    {SIP_MLNAME_CAST(sipName_isHoleConvex), meth_Rectangle_isHoleConvex, METH_VARARGS, SIP_MLDOC_CAST(doc_Rectangle_isHoleConvex)},
    {SIP_MLNAME_CAST(sipName_isInside), meth_Rectangle_isInside, METH_VARARGS, SIP_MLDOC_CAST(doc_Rectangle_isInside)},
    {SIP_MLNAME_CAST(sipName_leftmostBottomVertex), meth_Rectangle_leftmostBottomVertex, METH_VARARGS, SIP_MLDOC_CAST(doc_Rectangle_leftmostBottomVertex)},
    {SIP_MLNAME_CAST(sipName_markAsFixedInBin), meth_Rectangle_markAsFixedInBin, METH_VARARGS, SIP_MLDOC_CAST(doc_Rectangle_markAsFixedInBin)},
    {SIP_MLNAME_CAST(sipName_priority), meth_Rectangle_priority, METH_VARARGS, SIP_MLDOC_CAST(doc_Rectangle_priority)},
    {SIP_MLNAME_CAST(sipName_referenceVertex), meth_Rectangle_referenceVertex, METH_VARARGS, SIP_MLDOC_CAST(doc_Rectangle_referenceVertex)},
    {SIP_MLNAME_CAST(sipName_resetTransformation), meth_Rectangle_resetTransformation, METH_VARARGS, SIP_MLDOC_CAST(doc_Rectangle_resetTransformation)},
    {SIP_MLNAME_CAST(sipName_rightmostTopVertex), meth_Rectangle_rightmostTopVertex, METH_VARARGS, SIP_MLDOC_CAST(doc_Rectangle_rightmostTopVertex)},
    {SIP_MLNAME_CAST(sipName_rotate), meth_Rectangle_rotate, METH_VARARGS, SIP_MLDOC_CAST(doc_Rectangle_rotate)},
    {SIP_MLNAME_CAST(sipName_rotation), meth_Rectangle_rotation, METH_VARARGS, SIP_MLDOC_CAST(doc_Rectangle_rotation)},
    {SIP_MLNAME_CAST(sipName_toString), meth_Rectangle_toString, METH_VARARGS, SIP_MLDOC_CAST(doc_Rectangle_toString)},
    {SIP_MLNAME_CAST(sipName_touches), meth_Rectangle_touches, METH_VARARGS, SIP_MLDOC_CAST(doc_Rectangle_touches)},
    {SIP_MLNAME_CAST(sipName_transformedShape), meth_Rectangle_transformedShape, METH_VARARGS, SIP_MLDOC_CAST(doc_Rectangle_transformedShape)},
    {SIP_MLNAME_CAST(sipName_translate), meth_Rectangle_translate, METH_VARARGS, SIP_MLDOC_CAST(doc_Rectangle_translate)},
    {SIP_MLNAME_CAST(sipName_translation), meth_Rectangle_translation, METH_VARARGS, SIP_MLDOC_CAST(doc_Rectangle_translation)},
    {SIP_MLNAME_CAST(sipName_vertexCount), meth_Rectangle_vertexCount, METH_VARARGS, SIP_MLDOC_CAST(doc_Rectangle_vertexCount)},
    {SIP_MLNAME_CAST(sipName_width), meth_Rectangle_width, METH_VARARGS, SIP_MLDOC_CAST(doc_Rectangle_width)}
};

PyDoc_STRVAR(doc_Rectangle, "        A rectangular item. This item can be placed in the bins and arranged\n"
"        there. Some algorithms may work faster on rectangles than on arbitrary\n"
"        polygons.");


sipClassTypeDef sipTypeDef_pynest2d_Rectangle = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_CLASS,
        sipNameNr_Rectangle,
        {SIP_NULLPTR},
        SIP_NULLPTR
    },
    {
        sipNameNr_Rectangle,
        {0, 0, 1},
        27, methods_Rectangle,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_Rectangle,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_Rectangle,
    SIP_NULLPTR,
    SIP_NULLPTR,
#if PY_MAJOR_VERSION >= 3
    SIP_NULLPTR,
    SIP_NULLPTR,
#else
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
#endif
    dealloc_Rectangle,
    assign_Rectangle,
    SIP_NULLPTR,
    copy_Rectangle,
    release_Rectangle,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR
};
