/*
 * Module code.
 *
 * Generated by SIP 4.19.25
 */

#include "sipAPIpynest2d.h"

#line 11 "/build/python-pynest2d/src/pynest2d-4.12.0/src/Box.sip"
        #include <libnest2d/libnest2d.hpp>
#line 12 "/build/python-pynest2d/src/pynest2d-4.12.0/build/src/sippynest2dpart5.cpp"

#line 10 "/build/python-pynest2d/src/pynest2d-4.12.0/src/Point.sip"
        #include <libnest2d/libnest2d.hpp>
#line 16 "/build/python-pynest2d/src/pynest2d-4.12.0/build/src/sippynest2dpart5.cpp"


PyDoc_STRVAR(doc_Box_infinite, "Create a box with theoretically infinite dimensions.\n"
"\n"
"This is useful as a bin to place items in without necessarily bounding the\n"
"placement of these items at any limit.\n"
"\n"
"The center of the box will be used if items are aligned by the placer to the\n"
"center of the bin.\n"
":param center: The theoretical center of the box (to be treated as if it's\n"
"just a very big box rather than mathematically infinite).\n"
":return: A box with theoretically infinite dimensions.");

extern "C" {static PyObject *meth_Box_infinite(PyObject *, PyObject *);}
static PyObject *meth_Box_infinite(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::Point* a0;

        if (sipParseArgs(&sipParseErr, sipArgs, "J9", sipType_Point, &a0))
        {
             ::Box*sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::Box( ::Box::infinite(*a0));
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_Box,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Box, sipName_infinite, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_Box_minCorner, "Returns the minimum coordinates that are still within the box.\n"
":return: The minimum coordinates of the box.");

extern "C" {static PyObject *meth_Box_minCorner(PyObject *, PyObject *);}
static PyObject *meth_Box_minCorner(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::Box *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_Box, &sipCpp))
        {
             ::Point*sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::Point(sipCpp->minCorner());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_Point,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Box, sipName_minCorner, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_Box_maxCorner, "Returns the maximum coordinates that are still within the box.\n"
":return: The maximum coordinates of the box.");

extern "C" {static PyObject *meth_Box_maxCorner(PyObject *, PyObject *);}
static PyObject *meth_Box_maxCorner(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::Box *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_Box, &sipCpp))
        {
             ::Point*sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::Point(sipCpp->maxCorner());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_Point,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Box, sipName_maxCorner, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_Box_width, "Returns the width of the box, its span in the X direction.\n"
":return: The width of the box.");

extern "C" {static PyObject *meth_Box_width(PyObject *, PyObject *);}
static PyObject *meth_Box_width(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::Box *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_Box, &sipCpp))
        {
            long sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->width();
            Py_END_ALLOW_THREADS

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Box, sipName_width, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_Box_height, "Returns the height of the box, its span in the Y direction.\n"
":return: The height of the box.");

extern "C" {static PyObject *meth_Box_height(PyObject *, PyObject *);}
static PyObject *meth_Box_height(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::Box *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_Box, &sipCpp))
        {
            long sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->height();
            Py_END_ALLOW_THREADS

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Box, sipName_height, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_Box_area, "Returns the surface area of the box, i.e. the width times the height of\n"
"the box.\n"
":return: The surface area of the box.");

extern "C" {static PyObject *meth_Box_area(PyObject *, PyObject *);}
static PyObject *meth_Box_area(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::Box *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_Box, &sipCpp))
        {
            long sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->area();
            Py_END_ALLOW_THREADS

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Box, sipName_area, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_Box_center, "Returns the center of the box, exactly in between the ``minCorner()``\n"
"and the ``maxCorner()``.\n"
":return: The center of the box.");

extern "C" {static PyObject *meth_Box_center(PyObject *, PyObject *);}
static PyObject *meth_Box_center(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::Box *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_Box, &sipCpp))
        {
             ::Point*sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::Point(sipCpp->center());
            Py_END_ALLOW_THREADS

            return sipConvertFromNewType(sipRes,sipType_Point,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Box, sipName_center, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_Box(void *, int);}
static void release_Box(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::Box *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_Box(void *, SIP_SSIZE_T, void *);}
static void assign_Box(void *sipDst, SIP_SSIZE_T sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::Box *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::Box *>(sipSrc);
}


extern "C" {static void *copy_Box(const void *, SIP_SSIZE_T);}
static void *copy_Box(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new  ::Box(reinterpret_cast<const  ::Box *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_Box(sipSimpleWrapper *);}
static void dealloc_Box(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_Box(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_Box(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_Box(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::Box *sipCpp = SIP_NULLPTR;

    {
         ::Point* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_Point, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::Box(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    {
         ::Point* a0;
         ::Point* a1;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9J9", sipType_Point, &a0, sipType_Point, &a1))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::Box(*a0,*a1);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    {
        long a0;
        long a1;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "ll", &a0, &a1))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::Box(a0,a1);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    {
        long a0;
        long a1;
         ::Point* a2;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "llJ9", &a0, &a1, sipType_Point, &a2))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::Box(a0,a1,*a2);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    {
        const  ::Box* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_Box, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::Box(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_Box[] = {
    {SIP_MLNAME_CAST(sipName_area), meth_Box_area, METH_VARARGS, SIP_MLDOC_CAST(doc_Box_area)},
    {SIP_MLNAME_CAST(sipName_center), meth_Box_center, METH_VARARGS, SIP_MLDOC_CAST(doc_Box_center)},
    {SIP_MLNAME_CAST(sipName_height), meth_Box_height, METH_VARARGS, SIP_MLDOC_CAST(doc_Box_height)},
    {SIP_MLNAME_CAST(sipName_infinite), meth_Box_infinite, METH_VARARGS, SIP_MLDOC_CAST(doc_Box_infinite)},
    {SIP_MLNAME_CAST(sipName_maxCorner), meth_Box_maxCorner, METH_VARARGS, SIP_MLDOC_CAST(doc_Box_maxCorner)},
    {SIP_MLNAME_CAST(sipName_minCorner), meth_Box_minCorner, METH_VARARGS, SIP_MLDOC_CAST(doc_Box_minCorner)},
    {SIP_MLNAME_CAST(sipName_width), meth_Box_width, METH_VARARGS, SIP_MLDOC_CAST(doc_Box_width)}
};

PyDoc_STRVAR(doc_Box, "A rectangular shape, to be used as a bin or to be placed in the scene.");


sipClassTypeDef sipTypeDef_pynest2d_Box = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_CLASS,
        sipNameNr_Box,
        {SIP_NULLPTR},
        SIP_NULLPTR
    },
    {
        sipNameNr_Box,
        {0, 0, 1},
        7, methods_Box,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_Box,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_Box,
    SIP_NULLPTR,
    SIP_NULLPTR,
#if PY_MAJOR_VERSION >= 3
    SIP_NULLPTR,
    SIP_NULLPTR,
#else
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
#endif
    dealloc_Box,
    assign_Box,
    SIP_NULLPTR,
    copy_Box,
    release_Box,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR
};

#line 24 "/build/python-pynest2d/src/pynest2d-4.12.0/src/BottomLeftConfig.sip"
        #include <libnest2d/libnest2d.hpp>
        using BottomLeftConfig = BLConfig<ClipperLib::Polygon>; //Specialise the templated BLConfig class since SIP doesn't deal with templates.
#line 411 "/build/python-pynest2d/src/pynest2d-4.12.0/build/src/sippynest2dpart5.cpp"



/* Call the instance's destructor. */
extern "C" {static void release_BottomLeftConfig(void *, int);}
static void release_BottomLeftConfig(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::BottomLeftConfig *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_BottomLeftConfig(Py_ssize_t);}
static void *array_BottomLeftConfig(Py_ssize_t sipNrElem)
{
    return new  ::BottomLeftConfig[sipNrElem];
}


extern "C" {static void assign_BottomLeftConfig(void *, SIP_SSIZE_T, void *);}
static void assign_BottomLeftConfig(void *sipDst, SIP_SSIZE_T sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::BottomLeftConfig *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::BottomLeftConfig *>(sipSrc);
}


extern "C" {static void *copy_BottomLeftConfig(const void *, SIP_SSIZE_T);}
static void *copy_BottomLeftConfig(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new  ::BottomLeftConfig(reinterpret_cast<const  ::BottomLeftConfig *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_BottomLeftConfig(sipSimpleWrapper *);}
static void dealloc_BottomLeftConfig(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_BottomLeftConfig(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_BottomLeftConfig(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_BottomLeftConfig(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::BottomLeftConfig *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::BottomLeftConfig();
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    {
        const  ::BottomLeftConfig* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_BottomLeftConfig, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::BottomLeftConfig(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


extern "C" {static PyObject *varget_BottomLeftConfig_allow_rotations(void *, PyObject *, PyObject *);}
static PyObject *varget_BottomLeftConfig_allow_rotations(void *sipSelf, PyObject *, PyObject *)
{
    bool sipVal;
     ::BottomLeftConfig *sipCpp = reinterpret_cast< ::BottomLeftConfig *>(sipSelf);

    sipVal = sipCpp->allow_rotations;

    return PyBool_FromLong(sipVal);
}


extern "C" {static int varset_BottomLeftConfig_allow_rotations(void *, PyObject *, PyObject *);}
static int varset_BottomLeftConfig_allow_rotations(void *sipSelf, PyObject *sipPy, PyObject *)
{
    int sipVal;
     ::BottomLeftConfig *sipCpp = reinterpret_cast< ::BottomLeftConfig *>(sipSelf);

    sipVal = sipConvertToBool(sipPy);

    if (sipVal < 0)
        return -1;

    sipCpp->allow_rotations = static_cast<bool>(sipVal);

    return 0;
}


extern "C" {static PyObject *varget_BottomLeftConfig_epsilon(void *, PyObject *, PyObject *);}
static PyObject *varget_BottomLeftConfig_epsilon(void *sipSelf, PyObject *, PyObject *)
{
    long sipVal;
     ::BottomLeftConfig *sipCpp = reinterpret_cast< ::BottomLeftConfig *>(sipSelf);

    sipVal = sipCpp->epsilon;

    return PyLong_FromLong(sipVal);
}


extern "C" {static int varset_BottomLeftConfig_epsilon(void *, PyObject *, PyObject *);}
static int varset_BottomLeftConfig_epsilon(void *sipSelf, PyObject *sipPy, PyObject *)
{
    long sipVal;
     ::BottomLeftConfig *sipCpp = reinterpret_cast< ::BottomLeftConfig *>(sipSelf);

    sipVal = sipLong_AsLong(sipPy);

    if (PyErr_Occurred() != SIP_NULLPTR)
        return -1;

    sipCpp->epsilon = sipVal;

    return 0;
}


extern "C" {static PyObject *varget_BottomLeftConfig_min_obj_distance(void *, PyObject *, PyObject *);}
static PyObject *varget_BottomLeftConfig_min_obj_distance(void *sipSelf, PyObject *, PyObject *)
{
    long sipVal;
     ::BottomLeftConfig *sipCpp = reinterpret_cast< ::BottomLeftConfig *>(sipSelf);

    sipVal = sipCpp->min_obj_distance;

    return PyLong_FromLong(sipVal);
}


extern "C" {static int varset_BottomLeftConfig_min_obj_distance(void *, PyObject *, PyObject *);}
static int varset_BottomLeftConfig_min_obj_distance(void *sipSelf, PyObject *sipPy, PyObject *)
{
    long sipVal;
     ::BottomLeftConfig *sipCpp = reinterpret_cast< ::BottomLeftConfig *>(sipSelf);

    sipVal = sipLong_AsLong(sipPy);

    if (PyErr_Occurred() != SIP_NULLPTR)
        return -1;

    sipCpp->min_obj_distance = sipVal;

    return 0;
}

sipVariableDef variables_BottomLeftConfig[] = {
    {InstanceVariable, sipName_allow_rotations, (PyMethodDef *)varget_BottomLeftConfig_allow_rotations, (PyMethodDef *)varset_BottomLeftConfig_allow_rotations, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_epsilon, (PyMethodDef *)varget_BottomLeftConfig_epsilon, (PyMethodDef *)varset_BottomLeftConfig_epsilon, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_min_obj_distance, (PyMethodDef *)varget_BottomLeftConfig_min_obj_distance, (PyMethodDef *)varset_BottomLeftConfig_min_obj_distance, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_BottomLeftConfig, "Configuration class for the BLPlacer class.\n"
"\n"
"With this you can configure some parameters on how the BLPlacer places\n"
"objects.\n"
"\n"
"The following attributes can be set:\n"
"* min_obj_distance (default 0):\n"
"Minimum distance between objects. This seems to not be used by libnest2d\n"
"at the moment.\n"
"* epsilon (default 1):\n"
"Resolution of placement. The lower the epsilon, the more placements will\n"
"be attempted, resulting in better placement but longer computation time.\n"
"* allow_rotations (default False):\n"
"Whether the placer is allowed to rotate the items. This placer will only\n"
"attempt 90 degree rotations if this setting is set to True.");


sipClassTypeDef sipTypeDef_pynest2d_BottomLeftConfig = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_CLASS,
        sipNameNr_BottomLeftConfig,
        {SIP_NULLPTR},
        SIP_NULLPTR
    },
    {
        sipNameNr_BottomLeftConfig,
        {0, 0, 1},
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        3, variables_BottomLeftConfig,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_BottomLeftConfig,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_BottomLeftConfig,
    SIP_NULLPTR,
    SIP_NULLPTR,
#if PY_MAJOR_VERSION >= 3
    SIP_NULLPTR,
    SIP_NULLPTR,
#else
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
#endif
    dealloc_BottomLeftConfig,
    assign_BottomLeftConfig,
    array_BottomLeftConfig,
    copy_BottomLeftConfig,
    release_BottomLeftConfig,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR
};
