#line 1 "numpy/core/src/umath/loops.c.src"

/*
 *****************************************************************************
 **       This file was autogenerated from a template  DO NOT EDIT!!!!      **
 **       Changes should be made to the original source (.src) file         **
 *****************************************************************************
 */

#line 1
/* -*- c -*- */

#define _UMATHMODULE
#define _MULTIARRAYMODULE
#define NPY_NO_DEPRECATED_API NPY_API_VERSION

#include "Python.h"

#include "npy_config.h"
#include "numpy/npy_common.h"
#include "numpy/arrayobject.h"
#include "numpy/ufuncobject.h"
#include "numpy/npy_math.h"
#include "numpy/halffloat.h"
#include "lowlevel_strided_loops.h"

#include "npy_pycompat.h"

#include "ufunc_object.h"

#include <string.h> /* for memchr */

/*
 * cutoff blocksize for pairwise summation
 * decreasing it decreases errors slightly as more pairs are summed but
 * also lowers performance, as the inner loop is unrolled eight times it is
 * effectively 16
 */
#define PW_BLOCKSIZE    128


/*
 * largest simd vector size in bytes numpy supports
 * it is currently a extremely large value as it is only used for memory
 * overlap checks
 */
#ifndef NPY_MAX_SIMD_SIZE
#define NPY_MAX_SIMD_SIZE 1024
#endif

/*
 * include vectorized functions and dispatchers
 * this file is safe to include also for generic builds
 * platform specific instructions are either masked via the proprocessor or
 * runtime detected
 */
#include "simd.inc"


/*
 *****************************************************************************
 **                             UFUNC LOOPS                                 **
 *****************************************************************************
 */

/* unary loop input and output contiguous */
#define IS_UNARY_CONT(tin, tout) (steps[0] == sizeof(tin) && \
                                  steps[1] == sizeof(tout))

#define IS_BINARY_REDUCE ((args[0] == args[2])\
        && (steps[0] == steps[2])\
        && (steps[0] == 0))

/* binary loop input and output contiguous */
#define IS_BINARY_CONT(tin, tout) (steps[0] == sizeof(tin) && \
                                   steps[1] == sizeof(tin) && \
                                   steps[2] == sizeof(tout))
/* binary loop input and output contiguous with first scalar */
#define IS_BINARY_CONT_S1(tin, tout) (steps[0] == 0 && \
                                   steps[1] == sizeof(tin) && \
                                   steps[2] == sizeof(tout))
/* binary loop input and output contiguous with second scalar */
#define IS_BINARY_CONT_S2(tin, tout) (steps[0] == sizeof(tin) && \
                                   steps[1] == 0 && \
                                   steps[2] == sizeof(tout))

#define OUTPUT_LOOP\
    char *op1 = args[1];\
    npy_intp os1 = steps[1];\
    npy_intp n = dimensions[0];\
    npy_intp i;\
    for(i = 0; i < n; i++, op1 += os1)

#define UNARY_LOOP\
    char *ip1 = args[0], *op1 = args[1];\
    npy_intp is1 = steps[0], os1 = steps[1];\
    npy_intp n = dimensions[0];\
    npy_intp i;\
    for(i = 0; i < n; i++, ip1 += is1, op1 += os1)

/*
 * loop with contiguous specialization
 * op should be the code working on `tin in` and
 * storing the result in `tout * out`
 * combine with NPY_GCC_OPT_3 to allow autovectorization
 * should only be used where its worthwhile to avoid code bloat
 */
#define BASE_UNARY_LOOP(tin, tout, op) \
    UNARY_LOOP { \
        const tin in = *(tin *)ip1; \
        tout * out = (tout *)op1; \
        op; \
    }
#define UNARY_LOOP_FAST(tin, tout, op) \
    do { \
    /* condition allows compiler to optimize the generic macro */ \
    if (IS_UNARY_CONT(tin, tout)) { \
        if (args[0] == args[1]) { \
            BASE_UNARY_LOOP(tin, tout, op) \
        } \
        else { \
            BASE_UNARY_LOOP(tin, tout, op) \
        } \
    } \
    else { \
        BASE_UNARY_LOOP(tin, tout, op) \
    } \
    } \
    while (0)

#define UNARY_LOOP_TWO_OUT\
    char *ip1 = args[0], *op1 = args[1], *op2 = args[2];\
    npy_intp is1 = steps[0], os1 = steps[1], os2 = steps[2];\
    npy_intp n = dimensions[0];\
    npy_intp i;\
    for(i = 0; i < n; i++, ip1 += is1, op1 += os1, op2 += os2)

#define BINARY_LOOP\
    char *ip1 = args[0], *ip2 = args[1], *op1 = args[2];\
    npy_intp is1 = steps[0], is2 = steps[1], os1 = steps[2];\
    npy_intp n = dimensions[0];\
    npy_intp i;\
    for(i = 0; i < n; i++, ip1 += is1, ip2 += is2, op1 += os1)

/*
 * loop with contiguous specialization
 * op should be the code working on `tin in1`, `tin in2` and
 * storing the result in `tout * out`
 * combine with NPY_GCC_OPT_3 to allow autovectorization
 * should only be used where its worthwhile to avoid code bloat
 */
#define BASE_BINARY_LOOP(tin, tout, op) \
    BINARY_LOOP { \
        const tin in1 = *(tin *)ip1; \
        const tin in2 = *(tin *)ip2; \
        tout * out = (tout *)op1; \
        op; \
    }
/*
 * unfortunately gcc 6/7 regressed and we need to give it additional hints to
 * vectorize inplace operations (PR80198)
 * must only be used after op1 == ip1 or ip2 has been checked
 * TODO: using ivdep might allow other compilers to vectorize too
 */
#if __GNUC__ >= 6
#define IVDEP_LOOP _Pragma("GCC ivdep")
#else
#define IVDEP_LOOP
#endif
#define BASE_BINARY_LOOP_INP(tin, tout, op) \
    char *ip1 = args[0], *ip2 = args[1], *op1 = args[2];\
    npy_intp is1 = steps[0], is2 = steps[1], os1 = steps[2];\
    npy_intp n = dimensions[0];\
    npy_intp i;\
    IVDEP_LOOP \
    for(i = 0; i < n; i++, ip1 += is1, ip2 += is2, op1 += os1) { \
        const tin in1 = *(tin *)ip1; \
        const tin in2 = *(tin *)ip2; \
        tout * out = (tout *)op1; \
        op; \
    }
#define BASE_BINARY_LOOP_S(tin, tout, cin, cinp, vin, vinp, op) \
    const tin cin = *(tin *)cinp; \
    BINARY_LOOP { \
        const tin vin = *(tin *)vinp; \
        tout * out = (tout *)op1; \
        op; \
    }
/* PR80198 again, scalar works without the pragma */
#define BASE_BINARY_LOOP_S_INP(tin, tout, cin, cinp, vin, vinp, op) \
    const tin cin = *(tin *)cinp; \
    BINARY_LOOP { \
        const tin vin = *(tin *)vinp; \
        tout * out = (tout *)vinp; \
        op; \
    }
#define BINARY_LOOP_FAST(tin, tout, op) \
    do { \
    /* condition allows compiler to optimize the generic macro */ \
    if (IS_BINARY_CONT(tin, tout)) { \
        if (abs_ptrdiff(args[2], args[0]) == 0 && \
                abs_ptrdiff(args[2], args[1]) >= NPY_MAX_SIMD_SIZE) { \
            BASE_BINARY_LOOP_INP(tin, tout, op) \
        } \
        else if (abs_ptrdiff(args[2], args[1]) == 0 && \
                     abs_ptrdiff(args[2], args[0]) >= NPY_MAX_SIMD_SIZE) { \
            BASE_BINARY_LOOP_INP(tin, tout, op) \
        } \
        else { \
            BASE_BINARY_LOOP(tin, tout, op) \
        } \
    } \
    else if (IS_BINARY_CONT_S1(tin, tout)) { \
        if (abs_ptrdiff(args[2], args[1]) == 0) { \
            BASE_BINARY_LOOP_S_INP(tin, tout, in1, args[0], in2, ip2, op) \
        } \
        else { \
            BASE_BINARY_LOOP_S(tin, tout, in1, args[0], in2, ip2, op) \
        } \
    } \
    else if (IS_BINARY_CONT_S2(tin, tout)) { \
        if (abs_ptrdiff(args[2], args[0]) == 0) { \
            BASE_BINARY_LOOP_S_INP(tin, tout, in2, args[1], in1, ip1, op) \
        } \
        else { \
            BASE_BINARY_LOOP_S(tin, tout, in2, args[1], in1, ip1, op) \
        }\
    } \
    else { \
        BASE_BINARY_LOOP(tin, tout, op) \
    } \
    } \
    while (0)

#define BINARY_REDUCE_LOOP_INNER\
    char *ip2 = args[1]; \
    npy_intp is2 = steps[1]; \
    npy_intp n = dimensions[0]; \
    npy_intp i; \
    for(i = 0; i < n; i++, ip2 += is2)

#define BINARY_REDUCE_LOOP(TYPE)\
    char *iop1 = args[0]; \
    TYPE io1 = *(TYPE *)iop1; \
    BINARY_REDUCE_LOOP_INNER

#define BINARY_LOOP_TWO_OUT\
    char *ip1 = args[0], *ip2 = args[1], *op1 = args[2], *op2 = args[3];\
    npy_intp is1 = steps[0], is2 = steps[1], os1 = steps[2], os2 = steps[3];\
    npy_intp n = dimensions[0];\
    npy_intp i;\
    for(i = 0; i < n; i++, ip1 += is1, ip2 += is2, op1 += os1, op2 += os2)

/******************************************************************************
 **                          GENERIC FLOAT LOOPS                             **
 *****************************************************************************/


typedef float halfUnaryFunc(npy_half x);
typedef float floatUnaryFunc(float x);
typedef double doubleUnaryFunc(double x);
typedef npy_longdouble longdoubleUnaryFunc(npy_longdouble x);
typedef npy_half halfBinaryFunc(npy_half x, npy_half y);
typedef float floatBinaryFunc(float x, float y);
typedef double doubleBinaryFunc(double x, double y);
typedef npy_longdouble longdoubleBinaryFunc(npy_longdouble x, npy_longdouble y);


/*UFUNC_API*/
NPY_NO_EXPORT void
PyUFunc_e_e(char **args, npy_intp *dimensions, npy_intp *steps, void *func)
{
    halfUnaryFunc *f = (halfUnaryFunc *)func;
    UNARY_LOOP {
        const npy_half in1 = *(npy_half *)ip1;
        *(npy_half *)op1 = f(in1);
    }
}

/*UFUNC_API*/
NPY_NO_EXPORT void
PyUFunc_e_e_As_f_f(char **args, npy_intp *dimensions, npy_intp *steps, void *func)
{
    floatUnaryFunc *f = (floatUnaryFunc *)func;
    UNARY_LOOP {
        const float in1 = npy_half_to_float(*(npy_half *)ip1);
        *(npy_half *)op1 = npy_float_to_half(f(in1));
    }
}

/*UFUNC_API*/
NPY_NO_EXPORT void
PyUFunc_e_e_As_d_d(char **args, npy_intp *dimensions, npy_intp *steps, void *func)
{
    doubleUnaryFunc *f = (doubleUnaryFunc *)func;
    UNARY_LOOP {
        const double in1 = npy_half_to_double(*(npy_half *)ip1);
        *(npy_half *)op1 = npy_double_to_half(f(in1));
    }
}

/*UFUNC_API*/
NPY_NO_EXPORT void
PyUFunc_f_f(char **args, npy_intp *dimensions, npy_intp *steps, void *func)
{
    floatUnaryFunc *f = (floatUnaryFunc *)func;
    UNARY_LOOP {
        const float in1 = *(float *)ip1;
        *(float *)op1 = f(in1);
    }
}

/*UFUNC_API*/
NPY_NO_EXPORT void
PyUFunc_f_f_As_d_d(char **args, npy_intp *dimensions, npy_intp *steps, void *func)
{
    doubleUnaryFunc *f = (doubleUnaryFunc *)func;
    UNARY_LOOP {
        const float in1 = *(float *)ip1;
        *(float *)op1 = (float)f((double)in1);
    }
}

/*UFUNC_API*/
NPY_NO_EXPORT void
PyUFunc_ee_e(char **args, npy_intp *dimensions, npy_intp *steps, void *func)
{
    halfBinaryFunc *f = (halfBinaryFunc *)func;
    BINARY_LOOP {
        npy_half in1 = *(npy_half *)ip1;
        npy_half in2 = *(npy_half *)ip2;
        *(npy_half *)op1 = f(in1, in2);
    }
}

/*UFUNC_API*/
NPY_NO_EXPORT void
PyUFunc_ee_e_As_ff_f(char **args, npy_intp *dimensions, npy_intp *steps, void *func)
{
    floatBinaryFunc *f = (floatBinaryFunc *)func;
    BINARY_LOOP {
        float in1 = npy_half_to_float(*(npy_half *)ip1);
        float in2 = npy_half_to_float(*(npy_half *)ip2);
        *(npy_half *)op1 = npy_float_to_half(f(in1, in2));
    }
}

/*UFUNC_API*/
NPY_NO_EXPORT void
PyUFunc_ee_e_As_dd_d(char **args, npy_intp *dimensions, npy_intp *steps, void *func)
{
    doubleBinaryFunc *f = (doubleBinaryFunc *)func;
    BINARY_LOOP {
        double in1 = npy_half_to_double(*(npy_half *)ip1);
        double in2 = npy_half_to_double(*(npy_half *)ip2);
        *(npy_half *)op1 = npy_double_to_half(f(in1, in2));
    }
}

/*UFUNC_API*/
NPY_NO_EXPORT void
PyUFunc_ff_f(char **args, npy_intp *dimensions, npy_intp *steps, void *func)
{
    floatBinaryFunc *f = (floatBinaryFunc *)func;
    BINARY_LOOP {
        float in1 = *(float *)ip1;
        float in2 = *(float *)ip2;
        *(float *)op1 = f(in1, in2);
    }
}

/*UFUNC_API*/
NPY_NO_EXPORT void
PyUFunc_ff_f_As_dd_d(char **args, npy_intp *dimensions, npy_intp *steps, void *func)
{
    doubleBinaryFunc *f = (doubleBinaryFunc *)func;
    BINARY_LOOP {
        float in1 = *(float *)ip1;
        float in2 = *(float *)ip2;
        *(float *)op1 = (double)f((double)in1, (double)in2);
    }
}

/*UFUNC_API*/
NPY_NO_EXPORT void
PyUFunc_d_d(char **args, npy_intp *dimensions, npy_intp *steps, void *func)
{
    doubleUnaryFunc *f = (doubleUnaryFunc *)func;
    UNARY_LOOP {
        double in1 = *(double *)ip1;
        *(double *)op1 = f(in1);
    }
}

/*UFUNC_API*/
NPY_NO_EXPORT void
PyUFunc_dd_d(char **args, npy_intp *dimensions, npy_intp *steps, void *func)
{
    doubleBinaryFunc *f = (doubleBinaryFunc *)func;
    BINARY_LOOP {
        double in1 = *(double *)ip1;
        double in2 = *(double *)ip2;
        *(double *)op1 = f(in1, in2);
    }
}

/*UFUNC_API*/
NPY_NO_EXPORT void
PyUFunc_g_g(char **args, npy_intp *dimensions, npy_intp *steps, void *func)
{
    longdoubleUnaryFunc *f = (longdoubleUnaryFunc *)func;
    UNARY_LOOP {
        npy_longdouble in1 = *(npy_longdouble *)ip1;
        *(npy_longdouble *)op1 = f(in1);
    }
}

/*UFUNC_API*/
NPY_NO_EXPORT void
PyUFunc_gg_g(char **args, npy_intp *dimensions, npy_intp *steps, void *func)
{
    longdoubleBinaryFunc *f = (longdoubleBinaryFunc *)func;
    BINARY_LOOP {
        npy_longdouble in1 = *(npy_longdouble *)ip1;
        npy_longdouble in2 = *(npy_longdouble *)ip2;
        *(npy_longdouble *)op1 = f(in1, in2);
    }
}



/******************************************************************************
 **                          GENERIC COMPLEX LOOPS                           **
 *****************************************************************************/


typedef void cdoubleUnaryFunc(npy_cdouble *x, npy_cdouble *r);
typedef void cfloatUnaryFunc(npy_cfloat *x, npy_cfloat *r);
typedef void clongdoubleUnaryFunc(npy_clongdouble *x, npy_clongdouble *r);
typedef void cdoubleBinaryFunc(npy_cdouble *x, npy_cdouble *y, npy_cdouble *r);
typedef void cfloatBinaryFunc(npy_cfloat *x, npy_cfloat *y, npy_cfloat *r);
typedef void clongdoubleBinaryFunc(npy_clongdouble *x, npy_clongdouble *y,
                                   npy_clongdouble *r);

/*UFUNC_API*/
NPY_NO_EXPORT void
PyUFunc_F_F(char **args, npy_intp *dimensions, npy_intp *steps, void *func)
{
    cfloatUnaryFunc *f = (cfloatUnaryFunc *)func;
    UNARY_LOOP {
        npy_cfloat in1 = *(npy_cfloat *)ip1;
        npy_cfloat *out = (npy_cfloat *)op1;
        f(&in1, out);
    }
}

/*UFUNC_API*/
NPY_NO_EXPORT void
PyUFunc_F_F_As_D_D(char **args, npy_intp *dimensions, npy_intp *steps, void *func)
{
    cdoubleUnaryFunc *f = (cdoubleUnaryFunc *)func;
    UNARY_LOOP {
        npy_cdouble tmp, out;
        tmp.real = (double)((float *)ip1)[0];
        tmp.imag = (double)((float *)ip1)[1];
        f(&tmp, &out);
        ((float *)op1)[0] = (float)out.real;
        ((float *)op1)[1] = (float)out.imag;
    }
}

/*UFUNC_API*/
NPY_NO_EXPORT void
PyUFunc_FF_F(char **args, npy_intp *dimensions, npy_intp *steps, void *func)
{
    cfloatBinaryFunc *f = (cfloatBinaryFunc *)func;
    BINARY_LOOP {
        npy_cfloat in1 = *(npy_cfloat *)ip1;
        npy_cfloat in2 = *(npy_cfloat *)ip2;
        npy_cfloat *out = (npy_cfloat *)op1;
        f(&in1, &in2, out);
    }
}

/*UFUNC_API*/
NPY_NO_EXPORT void
PyUFunc_FF_F_As_DD_D(char **args, npy_intp *dimensions, npy_intp *steps, void *func)
{
    cdoubleBinaryFunc *f = (cdoubleBinaryFunc *)func;
    BINARY_LOOP {
        npy_cdouble tmp1, tmp2, out;
        tmp1.real = (double)((float *)ip1)[0];
        tmp1.imag = (double)((float *)ip1)[1];
        tmp2.real = (double)((float *)ip2)[0];
        tmp2.imag = (double)((float *)ip2)[1];
        f(&tmp1, &tmp2, &out);
        ((float *)op1)[0] = (float)out.real;
        ((float *)op1)[1] = (float)out.imag;
    }
}

/*UFUNC_API*/
NPY_NO_EXPORT void
PyUFunc_D_D(char **args, npy_intp *dimensions, npy_intp *steps, void *func)
{
    cdoubleUnaryFunc *f = (cdoubleUnaryFunc *)func;
    UNARY_LOOP {
        npy_cdouble in1 = *(npy_cdouble *)ip1;
        npy_cdouble *out = (npy_cdouble *)op1;
        f(&in1, out);
    }
}

/*UFUNC_API*/
NPY_NO_EXPORT void
PyUFunc_DD_D(char **args, npy_intp *dimensions, npy_intp *steps, void *func)
{
    cdoubleBinaryFunc *f = (cdoubleBinaryFunc *)func;
    BINARY_LOOP {
        npy_cdouble in1 = *(npy_cdouble *)ip1;
        npy_cdouble in2 = *(npy_cdouble *)ip2;
        npy_cdouble *out = (npy_cdouble *)op1;
        f(&in1, &in2, out);
    }
}

/*UFUNC_API*/
NPY_NO_EXPORT void
PyUFunc_G_G(char **args, npy_intp *dimensions, npy_intp *steps, void *func)
{
    clongdoubleUnaryFunc *f = (clongdoubleUnaryFunc *)func;
    UNARY_LOOP {
        npy_clongdouble in1 = *(npy_clongdouble *)ip1;
        npy_clongdouble *out = (npy_clongdouble *)op1;
        f(&in1, out);
    }
}

/*UFUNC_API*/
NPY_NO_EXPORT void
PyUFunc_GG_G(char **args, npy_intp *dimensions, npy_intp *steps, void *func)
{
    clongdoubleBinaryFunc *f = (clongdoubleBinaryFunc *)func;
    BINARY_LOOP {
        npy_clongdouble in1 = *(npy_clongdouble *)ip1;
        npy_clongdouble in2 = *(npy_clongdouble *)ip2;
        npy_clongdouble *out = (npy_clongdouble *)op1;
        f(&in1, &in2, out);
    }
}


/******************************************************************************
 **                         GENERIC OBJECT lOOPS                             **
 *****************************************************************************/

/*UFUNC_API*/
NPY_NO_EXPORT void
PyUFunc_O_O(char **args, npy_intp *dimensions, npy_intp *steps, void *func)
{
    unaryfunc f = (unaryfunc)func;
    UNARY_LOOP {
        PyObject *in1 = *(PyObject **)ip1;
        PyObject **out = (PyObject **)op1;
        PyObject *ret = f(in1 ? in1 : Py_None);
        if (ret == NULL) {
            return;
        }
        Py_XDECREF(*out);
        *out = ret;
    }
}

/*UFUNC_API*/
NPY_NO_EXPORT void
PyUFunc_O_O_method(char **args, npy_intp *dimensions, npy_intp *steps, void *func)
{
    char *meth = (char *)func;
    UNARY_LOOP {
        PyObject *in1 = *(PyObject **)ip1;
        PyObject **out = (PyObject **)op1;
        PyObject *ret = PyObject_CallMethod(in1 ? in1 : Py_None, meth, NULL);
        if (ret == NULL) {
            return;
        }
        Py_XDECREF(*out);
        *out = ret;
    }
}

/*UFUNC_API*/
NPY_NO_EXPORT void
PyUFunc_OO_O(char **args, npy_intp *dimensions, npy_intp *steps, void *func)
{
    binaryfunc f = (binaryfunc)func;
    BINARY_LOOP {
        PyObject *in1 = *(PyObject **)ip1;
        PyObject *in2 = *(PyObject **)ip2;
        PyObject **out = (PyObject **)op1;
        PyObject *ret = f(in1 ? in1 : Py_None, in2 ? in2 : Py_None);
        if (ret == NULL) {
            return;
        }
        Py_XDECREF(*out);
        *out = ret;
    }
}

/*UFUNC_API*/
NPY_NO_EXPORT void
PyUFunc_OO_O_method(char **args, npy_intp *dimensions, npy_intp *steps, void *func)
{
    char *meth = (char *)func;
    BINARY_LOOP {
        PyObject *in1 = *(PyObject **)ip1;
        PyObject *in2 = *(PyObject **)ip2;
        PyObject **out = (PyObject **)op1;
        PyObject *ret = PyObject_CallMethod(in1 ? in1 : Py_None,
                                            meth, "(O)", in2);
        if (ret == NULL) {
            return;
        }
        Py_XDECREF(*out);
        *out = ret;
    }
}

/*
 * A general-purpose ufunc that deals with general-purpose Python callable.
 * func is a structure with nin, nout, and a Python callable function
 */

/*UFUNC_API*/
NPY_NO_EXPORT void
PyUFunc_On_Om(char **args, npy_intp *dimensions, npy_intp *steps, void *func)
{
    npy_intp n =  dimensions[0];
    PyUFunc_PyFuncData *data = (PyUFunc_PyFuncData *)func;
    int nin = data->nin;
    int nout = data->nout;
    PyObject *tocall = data->callable;
    char *ptrs[NPY_MAXARGS];
    PyObject *arglist, *result;
    PyObject *in, **op;
    npy_intp i, j, ntot;

    ntot = nin+nout;

    for(j = 0; j < ntot; j++) {
        ptrs[j] = args[j];
    }
    for(i = 0; i < n; i++) {
        arglist = PyTuple_New(nin);
        if (arglist == NULL) {
            return;
        }
        for(j = 0; j < nin; j++) {
            in = *((PyObject **)ptrs[j]);
            if (in == NULL) {
                in = Py_None;
            }
            PyTuple_SET_ITEM(arglist, j, in);
            Py_INCREF(in);
        }
        result = PyEval_CallObject(tocall, arglist);
        Py_DECREF(arglist);
        if (result == NULL) {
            return;
        }
        if (nout == 0  && result == Py_None) {
            /* No output expected, no output received, continue */
            Py_DECREF(result);
        }
        else if (nout == 1) {
            /* Single output expected, assign and continue */
            op = (PyObject **)ptrs[nin];
            Py_XDECREF(*op);
            *op = result;
        }
        else if (PyTuple_Check(result) && nout == PyTuple_Size(result)) {
            /*
             * Multiple returns match expected number of outputs, assign
             * and continue. Will also gobble empty tuples if nout == 0.
             */
            for(j = 0; j < nout; j++) {
                op = (PyObject **)ptrs[j+nin];
                Py_XDECREF(*op);
                *op = PyTuple_GET_ITEM(result, j);
                Py_INCREF(*op);
            }
            Py_DECREF(result);
        }
        else {
            /* Mismatch between returns and expected outputs, exit */
            Py_DECREF(result);
            return;
        }
        for(j = 0; j < ntot; j++) {
            ptrs[j] += steps[j];
        }
    }
}

/*
 *****************************************************************************
 **                             BOOLEAN LOOPS                               **
 *****************************************************************************
 */

#line 704

NPY_NO_EXPORT void
BOOL_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        npy_bool in1 = *((npy_bool *)ip1) != 0;
        npy_bool in2 = *((npy_bool *)ip2) != 0;
        *((npy_bool *)op1)= in1 == in2;
    }
}

#line 704

NPY_NO_EXPORT void
BOOL_not_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        npy_bool in1 = *((npy_bool *)ip1) != 0;
        npy_bool in2 = *((npy_bool *)ip2) != 0;
        *((npy_bool *)op1)= in1 != in2;
    }
}

#line 704

NPY_NO_EXPORT void
BOOL_greater(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        npy_bool in1 = *((npy_bool *)ip1) != 0;
        npy_bool in2 = *((npy_bool *)ip2) != 0;
        *((npy_bool *)op1)= in1 > in2;
    }
}

#line 704

NPY_NO_EXPORT void
BOOL_greater_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        npy_bool in1 = *((npy_bool *)ip1) != 0;
        npy_bool in2 = *((npy_bool *)ip2) != 0;
        *((npy_bool *)op1)= in1 >= in2;
    }
}

#line 704

NPY_NO_EXPORT void
BOOL_less(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        npy_bool in1 = *((npy_bool *)ip1) != 0;
        npy_bool in2 = *((npy_bool *)ip2) != 0;
        *((npy_bool *)op1)= in1 < in2;
    }
}

#line 704

NPY_NO_EXPORT void
BOOL_less_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        npy_bool in1 = *((npy_bool *)ip1) != 0;
        npy_bool in2 = *((npy_bool *)ip2) != 0;
        *((npy_bool *)op1)= in1 <= in2;
    }
}



#line 723

NPY_NO_EXPORT void
BOOL_logical_and(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
#ifdef NPY_HAVE_SSE2_INTRINSICS
        /*
         * stick with our variant for more reliable performance, only known
         * platform which outperforms it by ~20% is an i7 with glibc 2.17
         */
        if (run_reduce_simd_logical_and_BOOL(args, dimensions, steps)) {
            return;
        }
#else
        /* for now only use libc on 32-bit/non-x86 */
        if (steps[1] == 1) {
            npy_bool * op = (npy_bool *)args[0];
#if 1
            /* np.all(), search for a zero (false) */
            if (*op) {
                *op = memchr(args[1], 0, dimensions[0]) == NULL;
            }
#else
            /*
             * np.any(), search for a non-zero (true) via comparing against
             * zero blocks, memcmp is faster than memchr on SSE4 machines
             * with glibc >= 2.12 and memchr can only check for equal 1
             */
            static const npy_bool zero[4096]; /* zero by C standard */
            npy_uintp i, n = dimensions[0];

            for (i = 0; !*op && i < n - (n % sizeof(zero)); i += sizeof(zero)) {
                *op = memcmp(&args[1][i], zero, sizeof(zero)) != 0;
            }
            if (!*op && n - i > 0) {
                *op = memcmp(&args[1][i], zero, n - i) != 0;
            }
#endif
            return;
        }
#endif
        else {
            BINARY_REDUCE_LOOP(npy_bool) {
                const npy_bool in2 = *(npy_bool *)ip2;
                io1 = io1 && in2;
                if (io1 == 0) {
                    break;
                }
            }
            *((npy_bool *)iop1) = io1;
        }
    }
    else {
        if (run_binary_simd_logical_and_BOOL(args, dimensions, steps)) {
            return;
        }
        else {
            BINARY_LOOP {
                const npy_bool in1 = *(npy_bool *)ip1;
                const npy_bool in2 = *(npy_bool *)ip2;
                *((npy_bool *)op1) = in1 && in2;
            }
        }
    }
}

#line 723

NPY_NO_EXPORT void
BOOL_logical_or(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
#ifdef NPY_HAVE_SSE2_INTRINSICS
        /*
         * stick with our variant for more reliable performance, only known
         * platform which outperforms it by ~20% is an i7 with glibc 2.17
         */
        if (run_reduce_simd_logical_or_BOOL(args, dimensions, steps)) {
            return;
        }
#else
        /* for now only use libc on 32-bit/non-x86 */
        if (steps[1] == 1) {
            npy_bool * op = (npy_bool *)args[0];
#if 0
            /* np.all(), search for a zero (false) */
            if (*op) {
                *op = memchr(args[1], 0, dimensions[0]) == NULL;
            }
#else
            /*
             * np.any(), search for a non-zero (true) via comparing against
             * zero blocks, memcmp is faster than memchr on SSE4 machines
             * with glibc >= 2.12 and memchr can only check for equal 1
             */
            static const npy_bool zero[4096]; /* zero by C standard */
            npy_uintp i, n = dimensions[0];

            for (i = 0; !*op && i < n - (n % sizeof(zero)); i += sizeof(zero)) {
                *op = memcmp(&args[1][i], zero, sizeof(zero)) != 0;
            }
            if (!*op && n - i > 0) {
                *op = memcmp(&args[1][i], zero, n - i) != 0;
            }
#endif
            return;
        }
#endif
        else {
            BINARY_REDUCE_LOOP(npy_bool) {
                const npy_bool in2 = *(npy_bool *)ip2;
                io1 = io1 || in2;
                if (io1 != 0) {
                    break;
                }
            }
            *((npy_bool *)iop1) = io1;
        }
    }
    else {
        if (run_binary_simd_logical_or_BOOL(args, dimensions, steps)) {
            return;
        }
        else {
            BINARY_LOOP {
                const npy_bool in1 = *(npy_bool *)ip1;
                const npy_bool in2 = *(npy_bool *)ip2;
                *((npy_bool *)op1) = in1 || in2;
            }
        }
    }
}


#line 794
NPY_NO_EXPORT void
BOOL_absolute(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (run_unary_simd_absolute_BOOL(args, dimensions, steps)) {
        return;
    }
    else {
        UNARY_LOOP {
            npy_bool in1 = *(npy_bool *)ip1;
            *((npy_bool *)op1) = in1 != 0;
        }
    }
}

#line 794
NPY_NO_EXPORT void
BOOL_logical_not(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (run_unary_simd_logical_not_BOOL(args, dimensions, steps)) {
        return;
    }
    else {
        UNARY_LOOP {
            npy_bool in1 = *(npy_bool *)ip1;
            *((npy_bool *)op1) = in1 == 0;
        }
    }
}


NPY_NO_EXPORT void
BOOL__ones_like(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    OUTPUT_LOOP {
        *((npy_bool *)op1) = 1;
    }
}


/*
 *****************************************************************************
 **                           INTEGER LOOPS
 *****************************************************************************
 */

#line 833

#define BYTE_floor_divide BYTE_divide
#define BYTE_fmax BYTE_maximum
#define BYTE_fmin BYTE_minimum

NPY_NO_EXPORT void
BYTE__ones_like(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    OUTPUT_LOOP {
        *((npy_byte *)op1) = 1;
    }
}

NPY_NO_EXPORT void
BYTE_positive(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_byte, npy_byte, *out = +in);
}

#line 858

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
BYTE_square(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP_FAST(npy_byte, npy_byte, *out = in * in);
}
#endif

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
BYTE_reciprocal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP_FAST(npy_byte, npy_byte, *out = 1.0 / in);
}
#endif

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
BYTE_conjugate(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_byte, npy_byte, *out = in);
}
#endif

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
BYTE_negative(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_byte, npy_byte, *out = -in);
}
#endif

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
BYTE_logical_not(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_byte, npy_bool, *out = !in);
}
#endif

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
BYTE_invert(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_byte, npy_byte, *out = ~in);
}
#endif

#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
BYTE_add(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_byte) {
            io1 += *(npy_byte *)ip2;
        }
        *((npy_byte *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_byte, npy_byte, *out = in1 + in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
BYTE_subtract(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_byte) {
            io1 -= *(npy_byte *)ip2;
        }
        *((npy_byte *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_byte, npy_byte, *out = in1 - in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
BYTE_multiply(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_byte) {
            io1 *= *(npy_byte *)ip2;
        }
        *((npy_byte *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_byte, npy_byte, *out = in1 * in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
BYTE_bitwise_and(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_byte) {
            io1 &= *(npy_byte *)ip2;
        }
        *((npy_byte *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_byte, npy_byte, *out = in1 & in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
BYTE_bitwise_or(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_byte) {
            io1 |= *(npy_byte *)ip2;
        }
        *((npy_byte *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_byte, npy_byte, *out = in1 | in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
BYTE_bitwise_xor(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_byte) {
            io1 ^= *(npy_byte *)ip2;
        }
        *((npy_byte *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_byte, npy_byte, *out = in1 ^ in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
BYTE_left_shift(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_byte) {
            io1 <<= *(npy_byte *)ip2;
        }
        *((npy_byte *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_byte, npy_byte, *out = in1 << in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
BYTE_right_shift(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_byte) {
            io1 >>= *(npy_byte *)ip2;
        }
        *((npy_byte *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_byte, npy_byte, *out = in1 >> in2);
    }
}
#endif



#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
BYTE_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_byte, npy_bool, *out = in1 == in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
BYTE_not_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_byte, npy_bool, *out = in1 != in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
BYTE_greater(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_byte, npy_bool, *out = in1 > in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
BYTE_greater_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_byte, npy_bool, *out = in1 >= in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
BYTE_less(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_byte, npy_bool, *out = in1 < in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
BYTE_less_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_byte, npy_bool, *out = in1 <= in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
BYTE_logical_and(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_byte, npy_bool, *out = in1 && in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
BYTE_logical_or(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_byte, npy_bool, *out = in1 || in2);
}
#endif



#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
BYTE_logical_xor(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const int t1 = !!*(npy_byte *)ip1;
        const int t2 = !!*(npy_byte *)ip2;
        *((npy_bool *)op1) = (t1 != t2);
    }
}
#endif


#line 858

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
BYTE_square_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP_FAST(npy_byte, npy_byte, *out = in * in);
}
#endif

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
BYTE_reciprocal_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP_FAST(npy_byte, npy_byte, *out = 1.0 / in);
}
#endif

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
BYTE_conjugate_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_byte, npy_byte, *out = in);
}
#endif

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
BYTE_negative_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_byte, npy_byte, *out = -in);
}
#endif

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
BYTE_logical_not_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_byte, npy_bool, *out = !in);
}
#endif

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
BYTE_invert_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_byte, npy_byte, *out = ~in);
}
#endif

#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
BYTE_add_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_byte) {
            io1 += *(npy_byte *)ip2;
        }
        *((npy_byte *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_byte, npy_byte, *out = in1 + in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
BYTE_subtract_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_byte) {
            io1 -= *(npy_byte *)ip2;
        }
        *((npy_byte *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_byte, npy_byte, *out = in1 - in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
BYTE_multiply_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_byte) {
            io1 *= *(npy_byte *)ip2;
        }
        *((npy_byte *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_byte, npy_byte, *out = in1 * in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
BYTE_bitwise_and_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_byte) {
            io1 &= *(npy_byte *)ip2;
        }
        *((npy_byte *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_byte, npy_byte, *out = in1 & in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
BYTE_bitwise_or_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_byte) {
            io1 |= *(npy_byte *)ip2;
        }
        *((npy_byte *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_byte, npy_byte, *out = in1 | in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
BYTE_bitwise_xor_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_byte) {
            io1 ^= *(npy_byte *)ip2;
        }
        *((npy_byte *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_byte, npy_byte, *out = in1 ^ in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
BYTE_left_shift_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_byte) {
            io1 <<= *(npy_byte *)ip2;
        }
        *((npy_byte *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_byte, npy_byte, *out = in1 << in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
BYTE_right_shift_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_byte) {
            io1 >>= *(npy_byte *)ip2;
        }
        *((npy_byte *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_byte, npy_byte, *out = in1 >> in2);
    }
}
#endif



#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
BYTE_equal_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_byte, npy_bool, *out = in1 == in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
BYTE_not_equal_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_byte, npy_bool, *out = in1 != in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
BYTE_greater_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_byte, npy_bool, *out = in1 > in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
BYTE_greater_equal_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_byte, npy_bool, *out = in1 >= in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
BYTE_less_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_byte, npy_bool, *out = in1 < in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
BYTE_less_equal_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_byte, npy_bool, *out = in1 <= in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
BYTE_logical_and_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_byte, npy_bool, *out = in1 && in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
BYTE_logical_or_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_byte, npy_bool, *out = in1 || in2);
}
#endif



#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
BYTE_logical_xor_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const int t1 = !!*(npy_byte *)ip1;
        const int t2 = !!*(npy_byte *)ip2;
        *((npy_bool *)op1) = (t1 != t2);
    }
}
#endif



#line 970

NPY_NO_EXPORT void
BYTE_maximum(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_byte) {
            const npy_byte in2 = *(npy_byte *)ip2;
            io1 = (io1 > in2) ? io1 : in2;
        }
        *((npy_byte *)iop1) = io1;
    }
    else {
        BINARY_LOOP {
            const npy_byte in1 = *(npy_byte *)ip1;
            const npy_byte in2 = *(npy_byte *)ip2;
            *((npy_byte *)op1) = (in1 > in2) ? in1 : in2;
        }
    }
}


#line 970

NPY_NO_EXPORT void
BYTE_minimum(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_byte) {
            const npy_byte in2 = *(npy_byte *)ip2;
            io1 = (io1 < in2) ? io1 : in2;
        }
        *((npy_byte *)iop1) = io1;
    }
    else {
        BINARY_LOOP {
            const npy_byte in1 = *(npy_byte *)ip1;
            const npy_byte in2 = *(npy_byte *)ip2;
            *((npy_byte *)op1) = (in1 < in2) ? in1 : in2;
        }
    }
}



NPY_NO_EXPORT void
BYTE_power(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        npy_byte in1 = *(npy_byte *)ip1;
        npy_byte in2 = *(npy_byte *)ip2;
        npy_byte out;

#if 1
        if (in2 < 0) {
            NPY_ALLOW_C_API_DEF
            NPY_ALLOW_C_API;
            PyErr_SetString(PyExc_ValueError,
                    "Integers to negative integer powers are not allowed.");
            NPY_DISABLE_C_API;
            return;
        }
#endif
        if (in2 == 0) {
            *((npy_byte *)op1) = 1;
            continue;
        }
        if (in1 == 1) {
            *((npy_byte *)op1) = 1;
            continue;
        }

        out = in2 & 1 ? in1 : 1;
        in2 >>= 1;
        while (in2 > 0) {
            in1 *= in1;
            if (in2 & 1) {
                out *= in1;
            }
            in2 >>= 1;
        }
        *((npy_byte *) op1) = out;
    }
}

NPY_NO_EXPORT void
BYTE_fmod(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_byte in1 = *(npy_byte *)ip1;
        const npy_byte in2 = *(npy_byte *)ip2;
        if (in2 == 0) {
            npy_set_floatstatus_divbyzero();
            *((npy_byte *)op1) = 0;
        }
        else {
            *((npy_byte *)op1)= in1 % in2;
        }

    }
}


#line 833

#define UBYTE_floor_divide UBYTE_divide
#define UBYTE_fmax UBYTE_maximum
#define UBYTE_fmin UBYTE_minimum

NPY_NO_EXPORT void
UBYTE__ones_like(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    OUTPUT_LOOP {
        *((npy_ubyte *)op1) = 1;
    }
}

NPY_NO_EXPORT void
UBYTE_positive(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_ubyte, npy_ubyte, *out = +in);
}

#line 858

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
UBYTE_square(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP_FAST(npy_ubyte, npy_ubyte, *out = in * in);
}
#endif

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
UBYTE_reciprocal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP_FAST(npy_ubyte, npy_ubyte, *out = 1.0 / in);
}
#endif

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
UBYTE_conjugate(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_ubyte, npy_ubyte, *out = in);
}
#endif

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
UBYTE_negative(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_ubyte, npy_ubyte, *out = -in);
}
#endif

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
UBYTE_logical_not(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_ubyte, npy_bool, *out = !in);
}
#endif

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
UBYTE_invert(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_ubyte, npy_ubyte, *out = ~in);
}
#endif

#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
UBYTE_add(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ubyte) {
            io1 += *(npy_ubyte *)ip2;
        }
        *((npy_ubyte *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_ubyte, npy_ubyte, *out = in1 + in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
UBYTE_subtract(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ubyte) {
            io1 -= *(npy_ubyte *)ip2;
        }
        *((npy_ubyte *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_ubyte, npy_ubyte, *out = in1 - in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
UBYTE_multiply(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ubyte) {
            io1 *= *(npy_ubyte *)ip2;
        }
        *((npy_ubyte *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_ubyte, npy_ubyte, *out = in1 * in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
UBYTE_bitwise_and(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ubyte) {
            io1 &= *(npy_ubyte *)ip2;
        }
        *((npy_ubyte *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_ubyte, npy_ubyte, *out = in1 & in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
UBYTE_bitwise_or(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ubyte) {
            io1 |= *(npy_ubyte *)ip2;
        }
        *((npy_ubyte *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_ubyte, npy_ubyte, *out = in1 | in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
UBYTE_bitwise_xor(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ubyte) {
            io1 ^= *(npy_ubyte *)ip2;
        }
        *((npy_ubyte *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_ubyte, npy_ubyte, *out = in1 ^ in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
UBYTE_left_shift(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ubyte) {
            io1 <<= *(npy_ubyte *)ip2;
        }
        *((npy_ubyte *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_ubyte, npy_ubyte, *out = in1 << in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
UBYTE_right_shift(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ubyte) {
            io1 >>= *(npy_ubyte *)ip2;
        }
        *((npy_ubyte *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_ubyte, npy_ubyte, *out = in1 >> in2);
    }
}
#endif



#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
UBYTE_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ubyte, npy_bool, *out = in1 == in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
UBYTE_not_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ubyte, npy_bool, *out = in1 != in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
UBYTE_greater(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ubyte, npy_bool, *out = in1 > in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
UBYTE_greater_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ubyte, npy_bool, *out = in1 >= in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
UBYTE_less(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ubyte, npy_bool, *out = in1 < in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
UBYTE_less_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ubyte, npy_bool, *out = in1 <= in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
UBYTE_logical_and(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ubyte, npy_bool, *out = in1 && in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
UBYTE_logical_or(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ubyte, npy_bool, *out = in1 || in2);
}
#endif



#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
UBYTE_logical_xor(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const int t1 = !!*(npy_ubyte *)ip1;
        const int t2 = !!*(npy_ubyte *)ip2;
        *((npy_bool *)op1) = (t1 != t2);
    }
}
#endif


#line 858

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
UBYTE_square_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP_FAST(npy_ubyte, npy_ubyte, *out = in * in);
}
#endif

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
UBYTE_reciprocal_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP_FAST(npy_ubyte, npy_ubyte, *out = 1.0 / in);
}
#endif

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
UBYTE_conjugate_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_ubyte, npy_ubyte, *out = in);
}
#endif

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
UBYTE_negative_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_ubyte, npy_ubyte, *out = -in);
}
#endif

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
UBYTE_logical_not_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_ubyte, npy_bool, *out = !in);
}
#endif

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
UBYTE_invert_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_ubyte, npy_ubyte, *out = ~in);
}
#endif

#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
UBYTE_add_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ubyte) {
            io1 += *(npy_ubyte *)ip2;
        }
        *((npy_ubyte *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_ubyte, npy_ubyte, *out = in1 + in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
UBYTE_subtract_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ubyte) {
            io1 -= *(npy_ubyte *)ip2;
        }
        *((npy_ubyte *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_ubyte, npy_ubyte, *out = in1 - in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
UBYTE_multiply_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ubyte) {
            io1 *= *(npy_ubyte *)ip2;
        }
        *((npy_ubyte *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_ubyte, npy_ubyte, *out = in1 * in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
UBYTE_bitwise_and_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ubyte) {
            io1 &= *(npy_ubyte *)ip2;
        }
        *((npy_ubyte *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_ubyte, npy_ubyte, *out = in1 & in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
UBYTE_bitwise_or_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ubyte) {
            io1 |= *(npy_ubyte *)ip2;
        }
        *((npy_ubyte *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_ubyte, npy_ubyte, *out = in1 | in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
UBYTE_bitwise_xor_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ubyte) {
            io1 ^= *(npy_ubyte *)ip2;
        }
        *((npy_ubyte *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_ubyte, npy_ubyte, *out = in1 ^ in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
UBYTE_left_shift_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ubyte) {
            io1 <<= *(npy_ubyte *)ip2;
        }
        *((npy_ubyte *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_ubyte, npy_ubyte, *out = in1 << in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
UBYTE_right_shift_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ubyte) {
            io1 >>= *(npy_ubyte *)ip2;
        }
        *((npy_ubyte *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_ubyte, npy_ubyte, *out = in1 >> in2);
    }
}
#endif



#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
UBYTE_equal_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ubyte, npy_bool, *out = in1 == in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
UBYTE_not_equal_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ubyte, npy_bool, *out = in1 != in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
UBYTE_greater_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ubyte, npy_bool, *out = in1 > in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
UBYTE_greater_equal_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ubyte, npy_bool, *out = in1 >= in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
UBYTE_less_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ubyte, npy_bool, *out = in1 < in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
UBYTE_less_equal_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ubyte, npy_bool, *out = in1 <= in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
UBYTE_logical_and_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ubyte, npy_bool, *out = in1 && in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
UBYTE_logical_or_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ubyte, npy_bool, *out = in1 || in2);
}
#endif



#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
UBYTE_logical_xor_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const int t1 = !!*(npy_ubyte *)ip1;
        const int t2 = !!*(npy_ubyte *)ip2;
        *((npy_bool *)op1) = (t1 != t2);
    }
}
#endif



#line 970

NPY_NO_EXPORT void
UBYTE_maximum(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ubyte) {
            const npy_ubyte in2 = *(npy_ubyte *)ip2;
            io1 = (io1 > in2) ? io1 : in2;
        }
        *((npy_ubyte *)iop1) = io1;
    }
    else {
        BINARY_LOOP {
            const npy_ubyte in1 = *(npy_ubyte *)ip1;
            const npy_ubyte in2 = *(npy_ubyte *)ip2;
            *((npy_ubyte *)op1) = (in1 > in2) ? in1 : in2;
        }
    }
}


#line 970

NPY_NO_EXPORT void
UBYTE_minimum(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ubyte) {
            const npy_ubyte in2 = *(npy_ubyte *)ip2;
            io1 = (io1 < in2) ? io1 : in2;
        }
        *((npy_ubyte *)iop1) = io1;
    }
    else {
        BINARY_LOOP {
            const npy_ubyte in1 = *(npy_ubyte *)ip1;
            const npy_ubyte in2 = *(npy_ubyte *)ip2;
            *((npy_ubyte *)op1) = (in1 < in2) ? in1 : in2;
        }
    }
}



NPY_NO_EXPORT void
UBYTE_power(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        npy_ubyte in1 = *(npy_ubyte *)ip1;
        npy_ubyte in2 = *(npy_ubyte *)ip2;
        npy_ubyte out;

#if 0
        if (in2 < 0) {
            NPY_ALLOW_C_API_DEF
            NPY_ALLOW_C_API;
            PyErr_SetString(PyExc_ValueError,
                    "Integers to negative integer powers are not allowed.");
            NPY_DISABLE_C_API;
            return;
        }
#endif
        if (in2 == 0) {
            *((npy_ubyte *)op1) = 1;
            continue;
        }
        if (in1 == 1) {
            *((npy_ubyte *)op1) = 1;
            continue;
        }

        out = in2 & 1 ? in1 : 1;
        in2 >>= 1;
        while (in2 > 0) {
            in1 *= in1;
            if (in2 & 1) {
                out *= in1;
            }
            in2 >>= 1;
        }
        *((npy_ubyte *) op1) = out;
    }
}

NPY_NO_EXPORT void
UBYTE_fmod(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_ubyte in1 = *(npy_ubyte *)ip1;
        const npy_ubyte in2 = *(npy_ubyte *)ip2;
        if (in2 == 0) {
            npy_set_floatstatus_divbyzero();
            *((npy_ubyte *)op1) = 0;
        }
        else {
            *((npy_ubyte *)op1)= in1 % in2;
        }

    }
}


#line 833

#define SHORT_floor_divide SHORT_divide
#define SHORT_fmax SHORT_maximum
#define SHORT_fmin SHORT_minimum

NPY_NO_EXPORT void
SHORT__ones_like(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    OUTPUT_LOOP {
        *((npy_short *)op1) = 1;
    }
}

NPY_NO_EXPORT void
SHORT_positive(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_short, npy_short, *out = +in);
}

#line 858

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
SHORT_square(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP_FAST(npy_short, npy_short, *out = in * in);
}
#endif

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
SHORT_reciprocal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP_FAST(npy_short, npy_short, *out = 1.0 / in);
}
#endif

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
SHORT_conjugate(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_short, npy_short, *out = in);
}
#endif

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
SHORT_negative(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_short, npy_short, *out = -in);
}
#endif

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
SHORT_logical_not(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_short, npy_bool, *out = !in);
}
#endif

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
SHORT_invert(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_short, npy_short, *out = ~in);
}
#endif

#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
SHORT_add(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_short) {
            io1 += *(npy_short *)ip2;
        }
        *((npy_short *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_short, npy_short, *out = in1 + in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
SHORT_subtract(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_short) {
            io1 -= *(npy_short *)ip2;
        }
        *((npy_short *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_short, npy_short, *out = in1 - in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
SHORT_multiply(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_short) {
            io1 *= *(npy_short *)ip2;
        }
        *((npy_short *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_short, npy_short, *out = in1 * in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
SHORT_bitwise_and(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_short) {
            io1 &= *(npy_short *)ip2;
        }
        *((npy_short *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_short, npy_short, *out = in1 & in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
SHORT_bitwise_or(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_short) {
            io1 |= *(npy_short *)ip2;
        }
        *((npy_short *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_short, npy_short, *out = in1 | in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
SHORT_bitwise_xor(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_short) {
            io1 ^= *(npy_short *)ip2;
        }
        *((npy_short *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_short, npy_short, *out = in1 ^ in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
SHORT_left_shift(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_short) {
            io1 <<= *(npy_short *)ip2;
        }
        *((npy_short *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_short, npy_short, *out = in1 << in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
SHORT_right_shift(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_short) {
            io1 >>= *(npy_short *)ip2;
        }
        *((npy_short *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_short, npy_short, *out = in1 >> in2);
    }
}
#endif



#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
SHORT_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_short, npy_bool, *out = in1 == in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
SHORT_not_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_short, npy_bool, *out = in1 != in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
SHORT_greater(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_short, npy_bool, *out = in1 > in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
SHORT_greater_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_short, npy_bool, *out = in1 >= in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
SHORT_less(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_short, npy_bool, *out = in1 < in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
SHORT_less_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_short, npy_bool, *out = in1 <= in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
SHORT_logical_and(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_short, npy_bool, *out = in1 && in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
SHORT_logical_or(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_short, npy_bool, *out = in1 || in2);
}
#endif



#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
SHORT_logical_xor(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const int t1 = !!*(npy_short *)ip1;
        const int t2 = !!*(npy_short *)ip2;
        *((npy_bool *)op1) = (t1 != t2);
    }
}
#endif


#line 858

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
SHORT_square_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP_FAST(npy_short, npy_short, *out = in * in);
}
#endif

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
SHORT_reciprocal_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP_FAST(npy_short, npy_short, *out = 1.0 / in);
}
#endif

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
SHORT_conjugate_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_short, npy_short, *out = in);
}
#endif

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
SHORT_negative_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_short, npy_short, *out = -in);
}
#endif

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
SHORT_logical_not_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_short, npy_bool, *out = !in);
}
#endif

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
SHORT_invert_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_short, npy_short, *out = ~in);
}
#endif

#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
SHORT_add_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_short) {
            io1 += *(npy_short *)ip2;
        }
        *((npy_short *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_short, npy_short, *out = in1 + in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
SHORT_subtract_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_short) {
            io1 -= *(npy_short *)ip2;
        }
        *((npy_short *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_short, npy_short, *out = in1 - in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
SHORT_multiply_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_short) {
            io1 *= *(npy_short *)ip2;
        }
        *((npy_short *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_short, npy_short, *out = in1 * in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
SHORT_bitwise_and_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_short) {
            io1 &= *(npy_short *)ip2;
        }
        *((npy_short *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_short, npy_short, *out = in1 & in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
SHORT_bitwise_or_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_short) {
            io1 |= *(npy_short *)ip2;
        }
        *((npy_short *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_short, npy_short, *out = in1 | in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
SHORT_bitwise_xor_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_short) {
            io1 ^= *(npy_short *)ip2;
        }
        *((npy_short *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_short, npy_short, *out = in1 ^ in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
SHORT_left_shift_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_short) {
            io1 <<= *(npy_short *)ip2;
        }
        *((npy_short *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_short, npy_short, *out = in1 << in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
SHORT_right_shift_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_short) {
            io1 >>= *(npy_short *)ip2;
        }
        *((npy_short *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_short, npy_short, *out = in1 >> in2);
    }
}
#endif



#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
SHORT_equal_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_short, npy_bool, *out = in1 == in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
SHORT_not_equal_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_short, npy_bool, *out = in1 != in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
SHORT_greater_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_short, npy_bool, *out = in1 > in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
SHORT_greater_equal_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_short, npy_bool, *out = in1 >= in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
SHORT_less_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_short, npy_bool, *out = in1 < in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
SHORT_less_equal_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_short, npy_bool, *out = in1 <= in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
SHORT_logical_and_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_short, npy_bool, *out = in1 && in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
SHORT_logical_or_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_short, npy_bool, *out = in1 || in2);
}
#endif



#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
SHORT_logical_xor_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const int t1 = !!*(npy_short *)ip1;
        const int t2 = !!*(npy_short *)ip2;
        *((npy_bool *)op1) = (t1 != t2);
    }
}
#endif



#line 970

NPY_NO_EXPORT void
SHORT_maximum(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_short) {
            const npy_short in2 = *(npy_short *)ip2;
            io1 = (io1 > in2) ? io1 : in2;
        }
        *((npy_short *)iop1) = io1;
    }
    else {
        BINARY_LOOP {
            const npy_short in1 = *(npy_short *)ip1;
            const npy_short in2 = *(npy_short *)ip2;
            *((npy_short *)op1) = (in1 > in2) ? in1 : in2;
        }
    }
}


#line 970

NPY_NO_EXPORT void
SHORT_minimum(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_short) {
            const npy_short in2 = *(npy_short *)ip2;
            io1 = (io1 < in2) ? io1 : in2;
        }
        *((npy_short *)iop1) = io1;
    }
    else {
        BINARY_LOOP {
            const npy_short in1 = *(npy_short *)ip1;
            const npy_short in2 = *(npy_short *)ip2;
            *((npy_short *)op1) = (in1 < in2) ? in1 : in2;
        }
    }
}



NPY_NO_EXPORT void
SHORT_power(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        npy_short in1 = *(npy_short *)ip1;
        npy_short in2 = *(npy_short *)ip2;
        npy_short out;

#if 1
        if (in2 < 0) {
            NPY_ALLOW_C_API_DEF
            NPY_ALLOW_C_API;
            PyErr_SetString(PyExc_ValueError,
                    "Integers to negative integer powers are not allowed.");
            NPY_DISABLE_C_API;
            return;
        }
#endif
        if (in2 == 0) {
            *((npy_short *)op1) = 1;
            continue;
        }
        if (in1 == 1) {
            *((npy_short *)op1) = 1;
            continue;
        }

        out = in2 & 1 ? in1 : 1;
        in2 >>= 1;
        while (in2 > 0) {
            in1 *= in1;
            if (in2 & 1) {
                out *= in1;
            }
            in2 >>= 1;
        }
        *((npy_short *) op1) = out;
    }
}

NPY_NO_EXPORT void
SHORT_fmod(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_short in1 = *(npy_short *)ip1;
        const npy_short in2 = *(npy_short *)ip2;
        if (in2 == 0) {
            npy_set_floatstatus_divbyzero();
            *((npy_short *)op1) = 0;
        }
        else {
            *((npy_short *)op1)= in1 % in2;
        }

    }
}


#line 833

#define USHORT_floor_divide USHORT_divide
#define USHORT_fmax USHORT_maximum
#define USHORT_fmin USHORT_minimum

NPY_NO_EXPORT void
USHORT__ones_like(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    OUTPUT_LOOP {
        *((npy_ushort *)op1) = 1;
    }
}

NPY_NO_EXPORT void
USHORT_positive(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_ushort, npy_ushort, *out = +in);
}

#line 858

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
USHORT_square(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP_FAST(npy_ushort, npy_ushort, *out = in * in);
}
#endif

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
USHORT_reciprocal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP_FAST(npy_ushort, npy_ushort, *out = 1.0 / in);
}
#endif

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
USHORT_conjugate(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_ushort, npy_ushort, *out = in);
}
#endif

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
USHORT_negative(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_ushort, npy_ushort, *out = -in);
}
#endif

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
USHORT_logical_not(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_ushort, npy_bool, *out = !in);
}
#endif

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
USHORT_invert(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_ushort, npy_ushort, *out = ~in);
}
#endif

#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
USHORT_add(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ushort) {
            io1 += *(npy_ushort *)ip2;
        }
        *((npy_ushort *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_ushort, npy_ushort, *out = in1 + in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
USHORT_subtract(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ushort) {
            io1 -= *(npy_ushort *)ip2;
        }
        *((npy_ushort *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_ushort, npy_ushort, *out = in1 - in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
USHORT_multiply(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ushort) {
            io1 *= *(npy_ushort *)ip2;
        }
        *((npy_ushort *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_ushort, npy_ushort, *out = in1 * in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
USHORT_bitwise_and(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ushort) {
            io1 &= *(npy_ushort *)ip2;
        }
        *((npy_ushort *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_ushort, npy_ushort, *out = in1 & in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
USHORT_bitwise_or(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ushort) {
            io1 |= *(npy_ushort *)ip2;
        }
        *((npy_ushort *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_ushort, npy_ushort, *out = in1 | in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
USHORT_bitwise_xor(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ushort) {
            io1 ^= *(npy_ushort *)ip2;
        }
        *((npy_ushort *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_ushort, npy_ushort, *out = in1 ^ in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
USHORT_left_shift(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ushort) {
            io1 <<= *(npy_ushort *)ip2;
        }
        *((npy_ushort *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_ushort, npy_ushort, *out = in1 << in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
USHORT_right_shift(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ushort) {
            io1 >>= *(npy_ushort *)ip2;
        }
        *((npy_ushort *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_ushort, npy_ushort, *out = in1 >> in2);
    }
}
#endif



#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
USHORT_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ushort, npy_bool, *out = in1 == in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
USHORT_not_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ushort, npy_bool, *out = in1 != in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
USHORT_greater(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ushort, npy_bool, *out = in1 > in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
USHORT_greater_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ushort, npy_bool, *out = in1 >= in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
USHORT_less(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ushort, npy_bool, *out = in1 < in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
USHORT_less_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ushort, npy_bool, *out = in1 <= in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
USHORT_logical_and(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ushort, npy_bool, *out = in1 && in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
USHORT_logical_or(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ushort, npy_bool, *out = in1 || in2);
}
#endif



#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
USHORT_logical_xor(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const int t1 = !!*(npy_ushort *)ip1;
        const int t2 = !!*(npy_ushort *)ip2;
        *((npy_bool *)op1) = (t1 != t2);
    }
}
#endif


#line 858

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
USHORT_square_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP_FAST(npy_ushort, npy_ushort, *out = in * in);
}
#endif

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
USHORT_reciprocal_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP_FAST(npy_ushort, npy_ushort, *out = 1.0 / in);
}
#endif

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
USHORT_conjugate_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_ushort, npy_ushort, *out = in);
}
#endif

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
USHORT_negative_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_ushort, npy_ushort, *out = -in);
}
#endif

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
USHORT_logical_not_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_ushort, npy_bool, *out = !in);
}
#endif

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
USHORT_invert_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_ushort, npy_ushort, *out = ~in);
}
#endif

#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
USHORT_add_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ushort) {
            io1 += *(npy_ushort *)ip2;
        }
        *((npy_ushort *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_ushort, npy_ushort, *out = in1 + in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
USHORT_subtract_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ushort) {
            io1 -= *(npy_ushort *)ip2;
        }
        *((npy_ushort *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_ushort, npy_ushort, *out = in1 - in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
USHORT_multiply_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ushort) {
            io1 *= *(npy_ushort *)ip2;
        }
        *((npy_ushort *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_ushort, npy_ushort, *out = in1 * in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
USHORT_bitwise_and_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ushort) {
            io1 &= *(npy_ushort *)ip2;
        }
        *((npy_ushort *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_ushort, npy_ushort, *out = in1 & in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
USHORT_bitwise_or_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ushort) {
            io1 |= *(npy_ushort *)ip2;
        }
        *((npy_ushort *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_ushort, npy_ushort, *out = in1 | in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
USHORT_bitwise_xor_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ushort) {
            io1 ^= *(npy_ushort *)ip2;
        }
        *((npy_ushort *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_ushort, npy_ushort, *out = in1 ^ in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
USHORT_left_shift_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ushort) {
            io1 <<= *(npy_ushort *)ip2;
        }
        *((npy_ushort *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_ushort, npy_ushort, *out = in1 << in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
USHORT_right_shift_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ushort) {
            io1 >>= *(npy_ushort *)ip2;
        }
        *((npy_ushort *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_ushort, npy_ushort, *out = in1 >> in2);
    }
}
#endif



#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
USHORT_equal_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ushort, npy_bool, *out = in1 == in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
USHORT_not_equal_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ushort, npy_bool, *out = in1 != in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
USHORT_greater_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ushort, npy_bool, *out = in1 > in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
USHORT_greater_equal_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ushort, npy_bool, *out = in1 >= in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
USHORT_less_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ushort, npy_bool, *out = in1 < in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
USHORT_less_equal_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ushort, npy_bool, *out = in1 <= in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
USHORT_logical_and_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ushort, npy_bool, *out = in1 && in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
USHORT_logical_or_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ushort, npy_bool, *out = in1 || in2);
}
#endif



#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
USHORT_logical_xor_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const int t1 = !!*(npy_ushort *)ip1;
        const int t2 = !!*(npy_ushort *)ip2;
        *((npy_bool *)op1) = (t1 != t2);
    }
}
#endif



#line 970

NPY_NO_EXPORT void
USHORT_maximum(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ushort) {
            const npy_ushort in2 = *(npy_ushort *)ip2;
            io1 = (io1 > in2) ? io1 : in2;
        }
        *((npy_ushort *)iop1) = io1;
    }
    else {
        BINARY_LOOP {
            const npy_ushort in1 = *(npy_ushort *)ip1;
            const npy_ushort in2 = *(npy_ushort *)ip2;
            *((npy_ushort *)op1) = (in1 > in2) ? in1 : in2;
        }
    }
}


#line 970

NPY_NO_EXPORT void
USHORT_minimum(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ushort) {
            const npy_ushort in2 = *(npy_ushort *)ip2;
            io1 = (io1 < in2) ? io1 : in2;
        }
        *((npy_ushort *)iop1) = io1;
    }
    else {
        BINARY_LOOP {
            const npy_ushort in1 = *(npy_ushort *)ip1;
            const npy_ushort in2 = *(npy_ushort *)ip2;
            *((npy_ushort *)op1) = (in1 < in2) ? in1 : in2;
        }
    }
}



NPY_NO_EXPORT void
USHORT_power(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        npy_ushort in1 = *(npy_ushort *)ip1;
        npy_ushort in2 = *(npy_ushort *)ip2;
        npy_ushort out;

#if 0
        if (in2 < 0) {
            NPY_ALLOW_C_API_DEF
            NPY_ALLOW_C_API;
            PyErr_SetString(PyExc_ValueError,
                    "Integers to negative integer powers are not allowed.");
            NPY_DISABLE_C_API;
            return;
        }
#endif
        if (in2 == 0) {
            *((npy_ushort *)op1) = 1;
            continue;
        }
        if (in1 == 1) {
            *((npy_ushort *)op1) = 1;
            continue;
        }

        out = in2 & 1 ? in1 : 1;
        in2 >>= 1;
        while (in2 > 0) {
            in1 *= in1;
            if (in2 & 1) {
                out *= in1;
            }
            in2 >>= 1;
        }
        *((npy_ushort *) op1) = out;
    }
}

NPY_NO_EXPORT void
USHORT_fmod(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_ushort in1 = *(npy_ushort *)ip1;
        const npy_ushort in2 = *(npy_ushort *)ip2;
        if (in2 == 0) {
            npy_set_floatstatus_divbyzero();
            *((npy_ushort *)op1) = 0;
        }
        else {
            *((npy_ushort *)op1)= in1 % in2;
        }

    }
}


#line 833

#define INT_floor_divide INT_divide
#define INT_fmax INT_maximum
#define INT_fmin INT_minimum

NPY_NO_EXPORT void
INT__ones_like(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    OUTPUT_LOOP {
        *((npy_int *)op1) = 1;
    }
}

NPY_NO_EXPORT void
INT_positive(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_int, npy_int, *out = +in);
}

#line 858

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
INT_square(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP_FAST(npy_int, npy_int, *out = in * in);
}
#endif

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
INT_reciprocal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP_FAST(npy_int, npy_int, *out = 1.0 / in);
}
#endif

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
INT_conjugate(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_int, npy_int, *out = in);
}
#endif

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
INT_negative(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_int, npy_int, *out = -in);
}
#endif

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
INT_logical_not(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_int, npy_bool, *out = !in);
}
#endif

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
INT_invert(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_int, npy_int, *out = ~in);
}
#endif

#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
INT_add(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_int) {
            io1 += *(npy_int *)ip2;
        }
        *((npy_int *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_int, npy_int, *out = in1 + in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
INT_subtract(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_int) {
            io1 -= *(npy_int *)ip2;
        }
        *((npy_int *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_int, npy_int, *out = in1 - in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
INT_multiply(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_int) {
            io1 *= *(npy_int *)ip2;
        }
        *((npy_int *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_int, npy_int, *out = in1 * in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
INT_bitwise_and(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_int) {
            io1 &= *(npy_int *)ip2;
        }
        *((npy_int *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_int, npy_int, *out = in1 & in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
INT_bitwise_or(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_int) {
            io1 |= *(npy_int *)ip2;
        }
        *((npy_int *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_int, npy_int, *out = in1 | in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
INT_bitwise_xor(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_int) {
            io1 ^= *(npy_int *)ip2;
        }
        *((npy_int *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_int, npy_int, *out = in1 ^ in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
INT_left_shift(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_int) {
            io1 <<= *(npy_int *)ip2;
        }
        *((npy_int *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_int, npy_int, *out = in1 << in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
INT_right_shift(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_int) {
            io1 >>= *(npy_int *)ip2;
        }
        *((npy_int *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_int, npy_int, *out = in1 >> in2);
    }
}
#endif



#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
INT_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_int, npy_bool, *out = in1 == in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
INT_not_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_int, npy_bool, *out = in1 != in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
INT_greater(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_int, npy_bool, *out = in1 > in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
INT_greater_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_int, npy_bool, *out = in1 >= in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
INT_less(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_int, npy_bool, *out = in1 < in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
INT_less_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_int, npy_bool, *out = in1 <= in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
INT_logical_and(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_int, npy_bool, *out = in1 && in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
INT_logical_or(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_int, npy_bool, *out = in1 || in2);
}
#endif



#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
INT_logical_xor(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const int t1 = !!*(npy_int *)ip1;
        const int t2 = !!*(npy_int *)ip2;
        *((npy_bool *)op1) = (t1 != t2);
    }
}
#endif


#line 858

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
INT_square_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP_FAST(npy_int, npy_int, *out = in * in);
}
#endif

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
INT_reciprocal_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP_FAST(npy_int, npy_int, *out = 1.0 / in);
}
#endif

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
INT_conjugate_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_int, npy_int, *out = in);
}
#endif

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
INT_negative_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_int, npy_int, *out = -in);
}
#endif

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
INT_logical_not_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_int, npy_bool, *out = !in);
}
#endif

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
INT_invert_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_int, npy_int, *out = ~in);
}
#endif

#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
INT_add_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_int) {
            io1 += *(npy_int *)ip2;
        }
        *((npy_int *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_int, npy_int, *out = in1 + in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
INT_subtract_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_int) {
            io1 -= *(npy_int *)ip2;
        }
        *((npy_int *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_int, npy_int, *out = in1 - in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
INT_multiply_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_int) {
            io1 *= *(npy_int *)ip2;
        }
        *((npy_int *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_int, npy_int, *out = in1 * in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
INT_bitwise_and_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_int) {
            io1 &= *(npy_int *)ip2;
        }
        *((npy_int *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_int, npy_int, *out = in1 & in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
INT_bitwise_or_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_int) {
            io1 |= *(npy_int *)ip2;
        }
        *((npy_int *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_int, npy_int, *out = in1 | in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
INT_bitwise_xor_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_int) {
            io1 ^= *(npy_int *)ip2;
        }
        *((npy_int *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_int, npy_int, *out = in1 ^ in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
INT_left_shift_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_int) {
            io1 <<= *(npy_int *)ip2;
        }
        *((npy_int *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_int, npy_int, *out = in1 << in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
INT_right_shift_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_int) {
            io1 >>= *(npy_int *)ip2;
        }
        *((npy_int *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_int, npy_int, *out = in1 >> in2);
    }
}
#endif



#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
INT_equal_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_int, npy_bool, *out = in1 == in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
INT_not_equal_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_int, npy_bool, *out = in1 != in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
INT_greater_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_int, npy_bool, *out = in1 > in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
INT_greater_equal_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_int, npy_bool, *out = in1 >= in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
INT_less_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_int, npy_bool, *out = in1 < in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
INT_less_equal_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_int, npy_bool, *out = in1 <= in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
INT_logical_and_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_int, npy_bool, *out = in1 && in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
INT_logical_or_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_int, npy_bool, *out = in1 || in2);
}
#endif



#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
INT_logical_xor_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const int t1 = !!*(npy_int *)ip1;
        const int t2 = !!*(npy_int *)ip2;
        *((npy_bool *)op1) = (t1 != t2);
    }
}
#endif



#line 970

NPY_NO_EXPORT void
INT_maximum(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_int) {
            const npy_int in2 = *(npy_int *)ip2;
            io1 = (io1 > in2) ? io1 : in2;
        }
        *((npy_int *)iop1) = io1;
    }
    else {
        BINARY_LOOP {
            const npy_int in1 = *(npy_int *)ip1;
            const npy_int in2 = *(npy_int *)ip2;
            *((npy_int *)op1) = (in1 > in2) ? in1 : in2;
        }
    }
}


#line 970

NPY_NO_EXPORT void
INT_minimum(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_int) {
            const npy_int in2 = *(npy_int *)ip2;
            io1 = (io1 < in2) ? io1 : in2;
        }
        *((npy_int *)iop1) = io1;
    }
    else {
        BINARY_LOOP {
            const npy_int in1 = *(npy_int *)ip1;
            const npy_int in2 = *(npy_int *)ip2;
            *((npy_int *)op1) = (in1 < in2) ? in1 : in2;
        }
    }
}



NPY_NO_EXPORT void
INT_power(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        npy_int in1 = *(npy_int *)ip1;
        npy_int in2 = *(npy_int *)ip2;
        npy_int out;

#if 1
        if (in2 < 0) {
            NPY_ALLOW_C_API_DEF
            NPY_ALLOW_C_API;
            PyErr_SetString(PyExc_ValueError,
                    "Integers to negative integer powers are not allowed.");
            NPY_DISABLE_C_API;
            return;
        }
#endif
        if (in2 == 0) {
            *((npy_int *)op1) = 1;
            continue;
        }
        if (in1 == 1) {
            *((npy_int *)op1) = 1;
            continue;
        }

        out = in2 & 1 ? in1 : 1;
        in2 >>= 1;
        while (in2 > 0) {
            in1 *= in1;
            if (in2 & 1) {
                out *= in1;
            }
            in2 >>= 1;
        }
        *((npy_int *) op1) = out;
    }
}

NPY_NO_EXPORT void
INT_fmod(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_int in1 = *(npy_int *)ip1;
        const npy_int in2 = *(npy_int *)ip2;
        if (in2 == 0) {
            npy_set_floatstatus_divbyzero();
            *((npy_int *)op1) = 0;
        }
        else {
            *((npy_int *)op1)= in1 % in2;
        }

    }
}


#line 833

#define UINT_floor_divide UINT_divide
#define UINT_fmax UINT_maximum
#define UINT_fmin UINT_minimum

NPY_NO_EXPORT void
UINT__ones_like(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    OUTPUT_LOOP {
        *((npy_uint *)op1) = 1;
    }
}

NPY_NO_EXPORT void
UINT_positive(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_uint, npy_uint, *out = +in);
}

#line 858

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
UINT_square(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP_FAST(npy_uint, npy_uint, *out = in * in);
}
#endif

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
UINT_reciprocal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP_FAST(npy_uint, npy_uint, *out = 1.0 / in);
}
#endif

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
UINT_conjugate(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_uint, npy_uint, *out = in);
}
#endif

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
UINT_negative(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_uint, npy_uint, *out = -in);
}
#endif

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
UINT_logical_not(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_uint, npy_bool, *out = !in);
}
#endif

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
UINT_invert(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_uint, npy_uint, *out = ~in);
}
#endif

#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
UINT_add(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_uint) {
            io1 += *(npy_uint *)ip2;
        }
        *((npy_uint *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_uint, npy_uint, *out = in1 + in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
UINT_subtract(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_uint) {
            io1 -= *(npy_uint *)ip2;
        }
        *((npy_uint *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_uint, npy_uint, *out = in1 - in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
UINT_multiply(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_uint) {
            io1 *= *(npy_uint *)ip2;
        }
        *((npy_uint *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_uint, npy_uint, *out = in1 * in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
UINT_bitwise_and(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_uint) {
            io1 &= *(npy_uint *)ip2;
        }
        *((npy_uint *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_uint, npy_uint, *out = in1 & in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
UINT_bitwise_or(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_uint) {
            io1 |= *(npy_uint *)ip2;
        }
        *((npy_uint *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_uint, npy_uint, *out = in1 | in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
UINT_bitwise_xor(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_uint) {
            io1 ^= *(npy_uint *)ip2;
        }
        *((npy_uint *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_uint, npy_uint, *out = in1 ^ in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
UINT_left_shift(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_uint) {
            io1 <<= *(npy_uint *)ip2;
        }
        *((npy_uint *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_uint, npy_uint, *out = in1 << in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
UINT_right_shift(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_uint) {
            io1 >>= *(npy_uint *)ip2;
        }
        *((npy_uint *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_uint, npy_uint, *out = in1 >> in2);
    }
}
#endif



#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
UINT_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_uint, npy_bool, *out = in1 == in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
UINT_not_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_uint, npy_bool, *out = in1 != in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
UINT_greater(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_uint, npy_bool, *out = in1 > in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
UINT_greater_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_uint, npy_bool, *out = in1 >= in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
UINT_less(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_uint, npy_bool, *out = in1 < in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
UINT_less_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_uint, npy_bool, *out = in1 <= in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
UINT_logical_and(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_uint, npy_bool, *out = in1 && in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
UINT_logical_or(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_uint, npy_bool, *out = in1 || in2);
}
#endif



#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
UINT_logical_xor(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const int t1 = !!*(npy_uint *)ip1;
        const int t2 = !!*(npy_uint *)ip2;
        *((npy_bool *)op1) = (t1 != t2);
    }
}
#endif


#line 858

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
UINT_square_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP_FAST(npy_uint, npy_uint, *out = in * in);
}
#endif

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
UINT_reciprocal_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP_FAST(npy_uint, npy_uint, *out = 1.0 / in);
}
#endif

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
UINT_conjugate_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_uint, npy_uint, *out = in);
}
#endif

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
UINT_negative_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_uint, npy_uint, *out = -in);
}
#endif

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
UINT_logical_not_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_uint, npy_bool, *out = !in);
}
#endif

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
UINT_invert_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_uint, npy_uint, *out = ~in);
}
#endif

#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
UINT_add_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_uint) {
            io1 += *(npy_uint *)ip2;
        }
        *((npy_uint *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_uint, npy_uint, *out = in1 + in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
UINT_subtract_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_uint) {
            io1 -= *(npy_uint *)ip2;
        }
        *((npy_uint *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_uint, npy_uint, *out = in1 - in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
UINT_multiply_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_uint) {
            io1 *= *(npy_uint *)ip2;
        }
        *((npy_uint *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_uint, npy_uint, *out = in1 * in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
UINT_bitwise_and_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_uint) {
            io1 &= *(npy_uint *)ip2;
        }
        *((npy_uint *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_uint, npy_uint, *out = in1 & in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
UINT_bitwise_or_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_uint) {
            io1 |= *(npy_uint *)ip2;
        }
        *((npy_uint *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_uint, npy_uint, *out = in1 | in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
UINT_bitwise_xor_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_uint) {
            io1 ^= *(npy_uint *)ip2;
        }
        *((npy_uint *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_uint, npy_uint, *out = in1 ^ in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
UINT_left_shift_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_uint) {
            io1 <<= *(npy_uint *)ip2;
        }
        *((npy_uint *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_uint, npy_uint, *out = in1 << in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
UINT_right_shift_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_uint) {
            io1 >>= *(npy_uint *)ip2;
        }
        *((npy_uint *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_uint, npy_uint, *out = in1 >> in2);
    }
}
#endif



#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
UINT_equal_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_uint, npy_bool, *out = in1 == in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
UINT_not_equal_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_uint, npy_bool, *out = in1 != in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
UINT_greater_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_uint, npy_bool, *out = in1 > in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
UINT_greater_equal_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_uint, npy_bool, *out = in1 >= in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
UINT_less_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_uint, npy_bool, *out = in1 < in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
UINT_less_equal_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_uint, npy_bool, *out = in1 <= in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
UINT_logical_and_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_uint, npy_bool, *out = in1 && in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
UINT_logical_or_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_uint, npy_bool, *out = in1 || in2);
}
#endif



#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
UINT_logical_xor_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const int t1 = !!*(npy_uint *)ip1;
        const int t2 = !!*(npy_uint *)ip2;
        *((npy_bool *)op1) = (t1 != t2);
    }
}
#endif



#line 970

NPY_NO_EXPORT void
UINT_maximum(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_uint) {
            const npy_uint in2 = *(npy_uint *)ip2;
            io1 = (io1 > in2) ? io1 : in2;
        }
        *((npy_uint *)iop1) = io1;
    }
    else {
        BINARY_LOOP {
            const npy_uint in1 = *(npy_uint *)ip1;
            const npy_uint in2 = *(npy_uint *)ip2;
            *((npy_uint *)op1) = (in1 > in2) ? in1 : in2;
        }
    }
}


#line 970

NPY_NO_EXPORT void
UINT_minimum(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_uint) {
            const npy_uint in2 = *(npy_uint *)ip2;
            io1 = (io1 < in2) ? io1 : in2;
        }
        *((npy_uint *)iop1) = io1;
    }
    else {
        BINARY_LOOP {
            const npy_uint in1 = *(npy_uint *)ip1;
            const npy_uint in2 = *(npy_uint *)ip2;
            *((npy_uint *)op1) = (in1 < in2) ? in1 : in2;
        }
    }
}



NPY_NO_EXPORT void
UINT_power(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        npy_uint in1 = *(npy_uint *)ip1;
        npy_uint in2 = *(npy_uint *)ip2;
        npy_uint out;

#if 0
        if (in2 < 0) {
            NPY_ALLOW_C_API_DEF
            NPY_ALLOW_C_API;
            PyErr_SetString(PyExc_ValueError,
                    "Integers to negative integer powers are not allowed.");
            NPY_DISABLE_C_API;
            return;
        }
#endif
        if (in2 == 0) {
            *((npy_uint *)op1) = 1;
            continue;
        }
        if (in1 == 1) {
            *((npy_uint *)op1) = 1;
            continue;
        }

        out = in2 & 1 ? in1 : 1;
        in2 >>= 1;
        while (in2 > 0) {
            in1 *= in1;
            if (in2 & 1) {
                out *= in1;
            }
            in2 >>= 1;
        }
        *((npy_uint *) op1) = out;
    }
}

NPY_NO_EXPORT void
UINT_fmod(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_uint in1 = *(npy_uint *)ip1;
        const npy_uint in2 = *(npy_uint *)ip2;
        if (in2 == 0) {
            npy_set_floatstatus_divbyzero();
            *((npy_uint *)op1) = 0;
        }
        else {
            *((npy_uint *)op1)= in1 % in2;
        }

    }
}


#line 833

#define LONG_floor_divide LONG_divide
#define LONG_fmax LONG_maximum
#define LONG_fmin LONG_minimum

NPY_NO_EXPORT void
LONG__ones_like(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    OUTPUT_LOOP {
        *((npy_long *)op1) = 1;
    }
}

NPY_NO_EXPORT void
LONG_positive(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_long, npy_long, *out = +in);
}

#line 858

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
LONG_square(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP_FAST(npy_long, npy_long, *out = in * in);
}
#endif

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
LONG_reciprocal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP_FAST(npy_long, npy_long, *out = 1.0 / in);
}
#endif

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
LONG_conjugate(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_long, npy_long, *out = in);
}
#endif

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
LONG_negative(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_long, npy_long, *out = -in);
}
#endif

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
LONG_logical_not(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_long, npy_bool, *out = !in);
}
#endif

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
LONG_invert(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_long, npy_long, *out = ~in);
}
#endif

#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
LONG_add(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_long) {
            io1 += *(npy_long *)ip2;
        }
        *((npy_long *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_long, npy_long, *out = in1 + in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
LONG_subtract(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_long) {
            io1 -= *(npy_long *)ip2;
        }
        *((npy_long *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_long, npy_long, *out = in1 - in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
LONG_multiply(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_long) {
            io1 *= *(npy_long *)ip2;
        }
        *((npy_long *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_long, npy_long, *out = in1 * in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
LONG_bitwise_and(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_long) {
            io1 &= *(npy_long *)ip2;
        }
        *((npy_long *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_long, npy_long, *out = in1 & in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
LONG_bitwise_or(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_long) {
            io1 |= *(npy_long *)ip2;
        }
        *((npy_long *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_long, npy_long, *out = in1 | in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
LONG_bitwise_xor(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_long) {
            io1 ^= *(npy_long *)ip2;
        }
        *((npy_long *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_long, npy_long, *out = in1 ^ in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
LONG_left_shift(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_long) {
            io1 <<= *(npy_long *)ip2;
        }
        *((npy_long *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_long, npy_long, *out = in1 << in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
LONG_right_shift(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_long) {
            io1 >>= *(npy_long *)ip2;
        }
        *((npy_long *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_long, npy_long, *out = in1 >> in2);
    }
}
#endif



#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
LONG_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_long, npy_bool, *out = in1 == in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
LONG_not_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_long, npy_bool, *out = in1 != in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
LONG_greater(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_long, npy_bool, *out = in1 > in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
LONG_greater_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_long, npy_bool, *out = in1 >= in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
LONG_less(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_long, npy_bool, *out = in1 < in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
LONG_less_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_long, npy_bool, *out = in1 <= in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
LONG_logical_and(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_long, npy_bool, *out = in1 && in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
LONG_logical_or(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_long, npy_bool, *out = in1 || in2);
}
#endif



#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
LONG_logical_xor(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const int t1 = !!*(npy_long *)ip1;
        const int t2 = !!*(npy_long *)ip2;
        *((npy_bool *)op1) = (t1 != t2);
    }
}
#endif


#line 858

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
LONG_square_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP_FAST(npy_long, npy_long, *out = in * in);
}
#endif

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
LONG_reciprocal_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP_FAST(npy_long, npy_long, *out = 1.0 / in);
}
#endif

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
LONG_conjugate_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_long, npy_long, *out = in);
}
#endif

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
LONG_negative_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_long, npy_long, *out = -in);
}
#endif

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
LONG_logical_not_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_long, npy_bool, *out = !in);
}
#endif

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
LONG_invert_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_long, npy_long, *out = ~in);
}
#endif

#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
LONG_add_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_long) {
            io1 += *(npy_long *)ip2;
        }
        *((npy_long *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_long, npy_long, *out = in1 + in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
LONG_subtract_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_long) {
            io1 -= *(npy_long *)ip2;
        }
        *((npy_long *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_long, npy_long, *out = in1 - in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
LONG_multiply_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_long) {
            io1 *= *(npy_long *)ip2;
        }
        *((npy_long *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_long, npy_long, *out = in1 * in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
LONG_bitwise_and_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_long) {
            io1 &= *(npy_long *)ip2;
        }
        *((npy_long *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_long, npy_long, *out = in1 & in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
LONG_bitwise_or_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_long) {
            io1 |= *(npy_long *)ip2;
        }
        *((npy_long *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_long, npy_long, *out = in1 | in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
LONG_bitwise_xor_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_long) {
            io1 ^= *(npy_long *)ip2;
        }
        *((npy_long *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_long, npy_long, *out = in1 ^ in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
LONG_left_shift_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_long) {
            io1 <<= *(npy_long *)ip2;
        }
        *((npy_long *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_long, npy_long, *out = in1 << in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
LONG_right_shift_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_long) {
            io1 >>= *(npy_long *)ip2;
        }
        *((npy_long *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_long, npy_long, *out = in1 >> in2);
    }
}
#endif



#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
LONG_equal_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_long, npy_bool, *out = in1 == in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
LONG_not_equal_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_long, npy_bool, *out = in1 != in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
LONG_greater_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_long, npy_bool, *out = in1 > in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
LONG_greater_equal_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_long, npy_bool, *out = in1 >= in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
LONG_less_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_long, npy_bool, *out = in1 < in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
LONG_less_equal_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_long, npy_bool, *out = in1 <= in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
LONG_logical_and_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_long, npy_bool, *out = in1 && in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
LONG_logical_or_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_long, npy_bool, *out = in1 || in2);
}
#endif



#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
LONG_logical_xor_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const int t1 = !!*(npy_long *)ip1;
        const int t2 = !!*(npy_long *)ip2;
        *((npy_bool *)op1) = (t1 != t2);
    }
}
#endif



#line 970

NPY_NO_EXPORT void
LONG_maximum(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_long) {
            const npy_long in2 = *(npy_long *)ip2;
            io1 = (io1 > in2) ? io1 : in2;
        }
        *((npy_long *)iop1) = io1;
    }
    else {
        BINARY_LOOP {
            const npy_long in1 = *(npy_long *)ip1;
            const npy_long in2 = *(npy_long *)ip2;
            *((npy_long *)op1) = (in1 > in2) ? in1 : in2;
        }
    }
}


#line 970

NPY_NO_EXPORT void
LONG_minimum(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_long) {
            const npy_long in2 = *(npy_long *)ip2;
            io1 = (io1 < in2) ? io1 : in2;
        }
        *((npy_long *)iop1) = io1;
    }
    else {
        BINARY_LOOP {
            const npy_long in1 = *(npy_long *)ip1;
            const npy_long in2 = *(npy_long *)ip2;
            *((npy_long *)op1) = (in1 < in2) ? in1 : in2;
        }
    }
}



NPY_NO_EXPORT void
LONG_power(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        npy_long in1 = *(npy_long *)ip1;
        npy_long in2 = *(npy_long *)ip2;
        npy_long out;

#if 1
        if (in2 < 0) {
            NPY_ALLOW_C_API_DEF
            NPY_ALLOW_C_API;
            PyErr_SetString(PyExc_ValueError,
                    "Integers to negative integer powers are not allowed.");
            NPY_DISABLE_C_API;
            return;
        }
#endif
        if (in2 == 0) {
            *((npy_long *)op1) = 1;
            continue;
        }
        if (in1 == 1) {
            *((npy_long *)op1) = 1;
            continue;
        }

        out = in2 & 1 ? in1 : 1;
        in2 >>= 1;
        while (in2 > 0) {
            in1 *= in1;
            if (in2 & 1) {
                out *= in1;
            }
            in2 >>= 1;
        }
        *((npy_long *) op1) = out;
    }
}

NPY_NO_EXPORT void
LONG_fmod(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_long in1 = *(npy_long *)ip1;
        const npy_long in2 = *(npy_long *)ip2;
        if (in2 == 0) {
            npy_set_floatstatus_divbyzero();
            *((npy_long *)op1) = 0;
        }
        else {
            *((npy_long *)op1)= in1 % in2;
        }

    }
}


#line 833

#define ULONG_floor_divide ULONG_divide
#define ULONG_fmax ULONG_maximum
#define ULONG_fmin ULONG_minimum

NPY_NO_EXPORT void
ULONG__ones_like(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    OUTPUT_LOOP {
        *((npy_ulong *)op1) = 1;
    }
}

NPY_NO_EXPORT void
ULONG_positive(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_ulong, npy_ulong, *out = +in);
}

#line 858

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
ULONG_square(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP_FAST(npy_ulong, npy_ulong, *out = in * in);
}
#endif

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
ULONG_reciprocal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP_FAST(npy_ulong, npy_ulong, *out = 1.0 / in);
}
#endif

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
ULONG_conjugate(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_ulong, npy_ulong, *out = in);
}
#endif

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
ULONG_negative(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_ulong, npy_ulong, *out = -in);
}
#endif

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
ULONG_logical_not(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_ulong, npy_bool, *out = !in);
}
#endif

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
ULONG_invert(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_ulong, npy_ulong, *out = ~in);
}
#endif

#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
ULONG_add(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ulong) {
            io1 += *(npy_ulong *)ip2;
        }
        *((npy_ulong *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_ulong, npy_ulong, *out = in1 + in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
ULONG_subtract(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ulong) {
            io1 -= *(npy_ulong *)ip2;
        }
        *((npy_ulong *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_ulong, npy_ulong, *out = in1 - in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
ULONG_multiply(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ulong) {
            io1 *= *(npy_ulong *)ip2;
        }
        *((npy_ulong *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_ulong, npy_ulong, *out = in1 * in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
ULONG_bitwise_and(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ulong) {
            io1 &= *(npy_ulong *)ip2;
        }
        *((npy_ulong *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_ulong, npy_ulong, *out = in1 & in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
ULONG_bitwise_or(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ulong) {
            io1 |= *(npy_ulong *)ip2;
        }
        *((npy_ulong *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_ulong, npy_ulong, *out = in1 | in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
ULONG_bitwise_xor(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ulong) {
            io1 ^= *(npy_ulong *)ip2;
        }
        *((npy_ulong *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_ulong, npy_ulong, *out = in1 ^ in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
ULONG_left_shift(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ulong) {
            io1 <<= *(npy_ulong *)ip2;
        }
        *((npy_ulong *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_ulong, npy_ulong, *out = in1 << in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
ULONG_right_shift(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ulong) {
            io1 >>= *(npy_ulong *)ip2;
        }
        *((npy_ulong *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_ulong, npy_ulong, *out = in1 >> in2);
    }
}
#endif



#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
ULONG_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ulong, npy_bool, *out = in1 == in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
ULONG_not_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ulong, npy_bool, *out = in1 != in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
ULONG_greater(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ulong, npy_bool, *out = in1 > in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
ULONG_greater_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ulong, npy_bool, *out = in1 >= in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
ULONG_less(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ulong, npy_bool, *out = in1 < in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
ULONG_less_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ulong, npy_bool, *out = in1 <= in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
ULONG_logical_and(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ulong, npy_bool, *out = in1 && in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
ULONG_logical_or(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ulong, npy_bool, *out = in1 || in2);
}
#endif



#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
ULONG_logical_xor(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const int t1 = !!*(npy_ulong *)ip1;
        const int t2 = !!*(npy_ulong *)ip2;
        *((npy_bool *)op1) = (t1 != t2);
    }
}
#endif


#line 858

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
ULONG_square_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP_FAST(npy_ulong, npy_ulong, *out = in * in);
}
#endif

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
ULONG_reciprocal_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP_FAST(npy_ulong, npy_ulong, *out = 1.0 / in);
}
#endif

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
ULONG_conjugate_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_ulong, npy_ulong, *out = in);
}
#endif

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
ULONG_negative_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_ulong, npy_ulong, *out = -in);
}
#endif

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
ULONG_logical_not_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_ulong, npy_bool, *out = !in);
}
#endif

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
ULONG_invert_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_ulong, npy_ulong, *out = ~in);
}
#endif

#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
ULONG_add_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ulong) {
            io1 += *(npy_ulong *)ip2;
        }
        *((npy_ulong *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_ulong, npy_ulong, *out = in1 + in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
ULONG_subtract_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ulong) {
            io1 -= *(npy_ulong *)ip2;
        }
        *((npy_ulong *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_ulong, npy_ulong, *out = in1 - in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
ULONG_multiply_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ulong) {
            io1 *= *(npy_ulong *)ip2;
        }
        *((npy_ulong *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_ulong, npy_ulong, *out = in1 * in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
ULONG_bitwise_and_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ulong) {
            io1 &= *(npy_ulong *)ip2;
        }
        *((npy_ulong *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_ulong, npy_ulong, *out = in1 & in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
ULONG_bitwise_or_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ulong) {
            io1 |= *(npy_ulong *)ip2;
        }
        *((npy_ulong *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_ulong, npy_ulong, *out = in1 | in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
ULONG_bitwise_xor_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ulong) {
            io1 ^= *(npy_ulong *)ip2;
        }
        *((npy_ulong *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_ulong, npy_ulong, *out = in1 ^ in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
ULONG_left_shift_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ulong) {
            io1 <<= *(npy_ulong *)ip2;
        }
        *((npy_ulong *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_ulong, npy_ulong, *out = in1 << in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
ULONG_right_shift_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ulong) {
            io1 >>= *(npy_ulong *)ip2;
        }
        *((npy_ulong *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_ulong, npy_ulong, *out = in1 >> in2);
    }
}
#endif



#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
ULONG_equal_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ulong, npy_bool, *out = in1 == in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
ULONG_not_equal_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ulong, npy_bool, *out = in1 != in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
ULONG_greater_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ulong, npy_bool, *out = in1 > in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
ULONG_greater_equal_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ulong, npy_bool, *out = in1 >= in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
ULONG_less_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ulong, npy_bool, *out = in1 < in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
ULONG_less_equal_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ulong, npy_bool, *out = in1 <= in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
ULONG_logical_and_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ulong, npy_bool, *out = in1 && in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
ULONG_logical_or_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ulong, npy_bool, *out = in1 || in2);
}
#endif



#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
ULONG_logical_xor_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const int t1 = !!*(npy_ulong *)ip1;
        const int t2 = !!*(npy_ulong *)ip2;
        *((npy_bool *)op1) = (t1 != t2);
    }
}
#endif



#line 970

NPY_NO_EXPORT void
ULONG_maximum(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ulong) {
            const npy_ulong in2 = *(npy_ulong *)ip2;
            io1 = (io1 > in2) ? io1 : in2;
        }
        *((npy_ulong *)iop1) = io1;
    }
    else {
        BINARY_LOOP {
            const npy_ulong in1 = *(npy_ulong *)ip1;
            const npy_ulong in2 = *(npy_ulong *)ip2;
            *((npy_ulong *)op1) = (in1 > in2) ? in1 : in2;
        }
    }
}


#line 970

NPY_NO_EXPORT void
ULONG_minimum(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ulong) {
            const npy_ulong in2 = *(npy_ulong *)ip2;
            io1 = (io1 < in2) ? io1 : in2;
        }
        *((npy_ulong *)iop1) = io1;
    }
    else {
        BINARY_LOOP {
            const npy_ulong in1 = *(npy_ulong *)ip1;
            const npy_ulong in2 = *(npy_ulong *)ip2;
            *((npy_ulong *)op1) = (in1 < in2) ? in1 : in2;
        }
    }
}



NPY_NO_EXPORT void
ULONG_power(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        npy_ulong in1 = *(npy_ulong *)ip1;
        npy_ulong in2 = *(npy_ulong *)ip2;
        npy_ulong out;

#if 0
        if (in2 < 0) {
            NPY_ALLOW_C_API_DEF
            NPY_ALLOW_C_API;
            PyErr_SetString(PyExc_ValueError,
                    "Integers to negative integer powers are not allowed.");
            NPY_DISABLE_C_API;
            return;
        }
#endif
        if (in2 == 0) {
            *((npy_ulong *)op1) = 1;
            continue;
        }
        if (in1 == 1) {
            *((npy_ulong *)op1) = 1;
            continue;
        }

        out = in2 & 1 ? in1 : 1;
        in2 >>= 1;
        while (in2 > 0) {
            in1 *= in1;
            if (in2 & 1) {
                out *= in1;
            }
            in2 >>= 1;
        }
        *((npy_ulong *) op1) = out;
    }
}

NPY_NO_EXPORT void
ULONG_fmod(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_ulong in1 = *(npy_ulong *)ip1;
        const npy_ulong in2 = *(npy_ulong *)ip2;
        if (in2 == 0) {
            npy_set_floatstatus_divbyzero();
            *((npy_ulong *)op1) = 0;
        }
        else {
            *((npy_ulong *)op1)= in1 % in2;
        }

    }
}


#line 833

#define LONGLONG_floor_divide LONGLONG_divide
#define LONGLONG_fmax LONGLONG_maximum
#define LONGLONG_fmin LONGLONG_minimum

NPY_NO_EXPORT void
LONGLONG__ones_like(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    OUTPUT_LOOP {
        *((npy_longlong *)op1) = 1;
    }
}

NPY_NO_EXPORT void
LONGLONG_positive(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_longlong, npy_longlong, *out = +in);
}

#line 858

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
LONGLONG_square(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP_FAST(npy_longlong, npy_longlong, *out = in * in);
}
#endif

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
LONGLONG_reciprocal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP_FAST(npy_longlong, npy_longlong, *out = 1.0 / in);
}
#endif

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
LONGLONG_conjugate(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_longlong, npy_longlong, *out = in);
}
#endif

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
LONGLONG_negative(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_longlong, npy_longlong, *out = -in);
}
#endif

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
LONGLONG_logical_not(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_longlong, npy_bool, *out = !in);
}
#endif

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
LONGLONG_invert(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_longlong, npy_longlong, *out = ~in);
}
#endif

#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
LONGLONG_add(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_longlong) {
            io1 += *(npy_longlong *)ip2;
        }
        *((npy_longlong *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_longlong, npy_longlong, *out = in1 + in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
LONGLONG_subtract(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_longlong) {
            io1 -= *(npy_longlong *)ip2;
        }
        *((npy_longlong *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_longlong, npy_longlong, *out = in1 - in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
LONGLONG_multiply(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_longlong) {
            io1 *= *(npy_longlong *)ip2;
        }
        *((npy_longlong *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_longlong, npy_longlong, *out = in1 * in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
LONGLONG_bitwise_and(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_longlong) {
            io1 &= *(npy_longlong *)ip2;
        }
        *((npy_longlong *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_longlong, npy_longlong, *out = in1 & in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
LONGLONG_bitwise_or(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_longlong) {
            io1 |= *(npy_longlong *)ip2;
        }
        *((npy_longlong *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_longlong, npy_longlong, *out = in1 | in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
LONGLONG_bitwise_xor(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_longlong) {
            io1 ^= *(npy_longlong *)ip2;
        }
        *((npy_longlong *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_longlong, npy_longlong, *out = in1 ^ in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
LONGLONG_left_shift(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_longlong) {
            io1 <<= *(npy_longlong *)ip2;
        }
        *((npy_longlong *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_longlong, npy_longlong, *out = in1 << in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
LONGLONG_right_shift(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_longlong) {
            io1 >>= *(npy_longlong *)ip2;
        }
        *((npy_longlong *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_longlong, npy_longlong, *out = in1 >> in2);
    }
}
#endif



#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
LONGLONG_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_longlong, npy_bool, *out = in1 == in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
LONGLONG_not_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_longlong, npy_bool, *out = in1 != in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
LONGLONG_greater(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_longlong, npy_bool, *out = in1 > in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
LONGLONG_greater_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_longlong, npy_bool, *out = in1 >= in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
LONGLONG_less(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_longlong, npy_bool, *out = in1 < in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
LONGLONG_less_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_longlong, npy_bool, *out = in1 <= in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
LONGLONG_logical_and(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_longlong, npy_bool, *out = in1 && in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
LONGLONG_logical_or(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_longlong, npy_bool, *out = in1 || in2);
}
#endif



#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
LONGLONG_logical_xor(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const int t1 = !!*(npy_longlong *)ip1;
        const int t2 = !!*(npy_longlong *)ip2;
        *((npy_bool *)op1) = (t1 != t2);
    }
}
#endif


#line 858

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
LONGLONG_square_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP_FAST(npy_longlong, npy_longlong, *out = in * in);
}
#endif

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
LONGLONG_reciprocal_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP_FAST(npy_longlong, npy_longlong, *out = 1.0 / in);
}
#endif

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
LONGLONG_conjugate_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_longlong, npy_longlong, *out = in);
}
#endif

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
LONGLONG_negative_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_longlong, npy_longlong, *out = -in);
}
#endif

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
LONGLONG_logical_not_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_longlong, npy_bool, *out = !in);
}
#endif

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
LONGLONG_invert_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_longlong, npy_longlong, *out = ~in);
}
#endif

#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
LONGLONG_add_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_longlong) {
            io1 += *(npy_longlong *)ip2;
        }
        *((npy_longlong *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_longlong, npy_longlong, *out = in1 + in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
LONGLONG_subtract_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_longlong) {
            io1 -= *(npy_longlong *)ip2;
        }
        *((npy_longlong *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_longlong, npy_longlong, *out = in1 - in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
LONGLONG_multiply_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_longlong) {
            io1 *= *(npy_longlong *)ip2;
        }
        *((npy_longlong *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_longlong, npy_longlong, *out = in1 * in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
LONGLONG_bitwise_and_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_longlong) {
            io1 &= *(npy_longlong *)ip2;
        }
        *((npy_longlong *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_longlong, npy_longlong, *out = in1 & in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
LONGLONG_bitwise_or_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_longlong) {
            io1 |= *(npy_longlong *)ip2;
        }
        *((npy_longlong *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_longlong, npy_longlong, *out = in1 | in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
LONGLONG_bitwise_xor_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_longlong) {
            io1 ^= *(npy_longlong *)ip2;
        }
        *((npy_longlong *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_longlong, npy_longlong, *out = in1 ^ in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
LONGLONG_left_shift_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_longlong) {
            io1 <<= *(npy_longlong *)ip2;
        }
        *((npy_longlong *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_longlong, npy_longlong, *out = in1 << in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
LONGLONG_right_shift_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_longlong) {
            io1 >>= *(npy_longlong *)ip2;
        }
        *((npy_longlong *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_longlong, npy_longlong, *out = in1 >> in2);
    }
}
#endif



#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
LONGLONG_equal_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_longlong, npy_bool, *out = in1 == in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
LONGLONG_not_equal_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_longlong, npy_bool, *out = in1 != in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
LONGLONG_greater_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_longlong, npy_bool, *out = in1 > in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
LONGLONG_greater_equal_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_longlong, npy_bool, *out = in1 >= in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
LONGLONG_less_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_longlong, npy_bool, *out = in1 < in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
LONGLONG_less_equal_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_longlong, npy_bool, *out = in1 <= in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
LONGLONG_logical_and_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_longlong, npy_bool, *out = in1 && in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
LONGLONG_logical_or_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_longlong, npy_bool, *out = in1 || in2);
}
#endif



#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
LONGLONG_logical_xor_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const int t1 = !!*(npy_longlong *)ip1;
        const int t2 = !!*(npy_longlong *)ip2;
        *((npy_bool *)op1) = (t1 != t2);
    }
}
#endif



#line 970

NPY_NO_EXPORT void
LONGLONG_maximum(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_longlong) {
            const npy_longlong in2 = *(npy_longlong *)ip2;
            io1 = (io1 > in2) ? io1 : in2;
        }
        *((npy_longlong *)iop1) = io1;
    }
    else {
        BINARY_LOOP {
            const npy_longlong in1 = *(npy_longlong *)ip1;
            const npy_longlong in2 = *(npy_longlong *)ip2;
            *((npy_longlong *)op1) = (in1 > in2) ? in1 : in2;
        }
    }
}


#line 970

NPY_NO_EXPORT void
LONGLONG_minimum(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_longlong) {
            const npy_longlong in2 = *(npy_longlong *)ip2;
            io1 = (io1 < in2) ? io1 : in2;
        }
        *((npy_longlong *)iop1) = io1;
    }
    else {
        BINARY_LOOP {
            const npy_longlong in1 = *(npy_longlong *)ip1;
            const npy_longlong in2 = *(npy_longlong *)ip2;
            *((npy_longlong *)op1) = (in1 < in2) ? in1 : in2;
        }
    }
}



NPY_NO_EXPORT void
LONGLONG_power(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        npy_longlong in1 = *(npy_longlong *)ip1;
        npy_longlong in2 = *(npy_longlong *)ip2;
        npy_longlong out;

#if 1
        if (in2 < 0) {
            NPY_ALLOW_C_API_DEF
            NPY_ALLOW_C_API;
            PyErr_SetString(PyExc_ValueError,
                    "Integers to negative integer powers are not allowed.");
            NPY_DISABLE_C_API;
            return;
        }
#endif
        if (in2 == 0) {
            *((npy_longlong *)op1) = 1;
            continue;
        }
        if (in1 == 1) {
            *((npy_longlong *)op1) = 1;
            continue;
        }

        out = in2 & 1 ? in1 : 1;
        in2 >>= 1;
        while (in2 > 0) {
            in1 *= in1;
            if (in2 & 1) {
                out *= in1;
            }
            in2 >>= 1;
        }
        *((npy_longlong *) op1) = out;
    }
}

NPY_NO_EXPORT void
LONGLONG_fmod(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_longlong in1 = *(npy_longlong *)ip1;
        const npy_longlong in2 = *(npy_longlong *)ip2;
        if (in2 == 0) {
            npy_set_floatstatus_divbyzero();
            *((npy_longlong *)op1) = 0;
        }
        else {
            *((npy_longlong *)op1)= in1 % in2;
        }

    }
}


#line 833

#define ULONGLONG_floor_divide ULONGLONG_divide
#define ULONGLONG_fmax ULONGLONG_maximum
#define ULONGLONG_fmin ULONGLONG_minimum

NPY_NO_EXPORT void
ULONGLONG__ones_like(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    OUTPUT_LOOP {
        *((npy_ulonglong *)op1) = 1;
    }
}

NPY_NO_EXPORT void
ULONGLONG_positive(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_ulonglong, npy_ulonglong, *out = +in);
}

#line 858

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
ULONGLONG_square(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP_FAST(npy_ulonglong, npy_ulonglong, *out = in * in);
}
#endif

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
ULONGLONG_reciprocal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP_FAST(npy_ulonglong, npy_ulonglong, *out = 1.0 / in);
}
#endif

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
ULONGLONG_conjugate(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_ulonglong, npy_ulonglong, *out = in);
}
#endif

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
ULONGLONG_negative(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_ulonglong, npy_ulonglong, *out = -in);
}
#endif

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
ULONGLONG_logical_not(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_ulonglong, npy_bool, *out = !in);
}
#endif

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
ULONGLONG_invert(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_ulonglong, npy_ulonglong, *out = ~in);
}
#endif

#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
ULONGLONG_add(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ulonglong) {
            io1 += *(npy_ulonglong *)ip2;
        }
        *((npy_ulonglong *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_ulonglong, npy_ulonglong, *out = in1 + in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
ULONGLONG_subtract(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ulonglong) {
            io1 -= *(npy_ulonglong *)ip2;
        }
        *((npy_ulonglong *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_ulonglong, npy_ulonglong, *out = in1 - in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
ULONGLONG_multiply(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ulonglong) {
            io1 *= *(npy_ulonglong *)ip2;
        }
        *((npy_ulonglong *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_ulonglong, npy_ulonglong, *out = in1 * in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
ULONGLONG_bitwise_and(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ulonglong) {
            io1 &= *(npy_ulonglong *)ip2;
        }
        *((npy_ulonglong *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_ulonglong, npy_ulonglong, *out = in1 & in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
ULONGLONG_bitwise_or(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ulonglong) {
            io1 |= *(npy_ulonglong *)ip2;
        }
        *((npy_ulonglong *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_ulonglong, npy_ulonglong, *out = in1 | in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
ULONGLONG_bitwise_xor(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ulonglong) {
            io1 ^= *(npy_ulonglong *)ip2;
        }
        *((npy_ulonglong *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_ulonglong, npy_ulonglong, *out = in1 ^ in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
ULONGLONG_left_shift(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ulonglong) {
            io1 <<= *(npy_ulonglong *)ip2;
        }
        *((npy_ulonglong *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_ulonglong, npy_ulonglong, *out = in1 << in2);
    }
}
#endif


#line 913

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
ULONGLONG_right_shift(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ulonglong) {
            io1 >>= *(npy_ulonglong *)ip2;
        }
        *((npy_ulonglong *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_ulonglong, npy_ulonglong, *out = in1 >> in2);
    }
}
#endif



#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
ULONGLONG_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ulonglong, npy_bool, *out = in1 == in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
ULONGLONG_not_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ulonglong, npy_bool, *out = in1 != in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
ULONGLONG_greater(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ulonglong, npy_bool, *out = in1 > in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
ULONGLONG_greater_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ulonglong, npy_bool, *out = in1 >= in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
ULONGLONG_less(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ulonglong, npy_bool, *out = in1 < in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
ULONGLONG_less_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ulonglong, npy_bool, *out = in1 <= in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
ULONGLONG_logical_and(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ulonglong, npy_bool, *out = in1 && in2);
}
#endif


#line 937

#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
ULONGLONG_logical_or(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ulonglong, npy_bool, *out = in1 || in2);
}
#endif



#if 1
NPY_NO_EXPORT NPY_GCC_OPT_3  void
ULONGLONG_logical_xor(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const int t1 = !!*(npy_ulonglong *)ip1;
        const int t2 = !!*(npy_ulonglong *)ip2;
        *((npy_bool *)op1) = (t1 != t2);
    }
}
#endif


#line 858

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
ULONGLONG_square_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP_FAST(npy_ulonglong, npy_ulonglong, *out = in * in);
}
#endif

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
ULONGLONG_reciprocal_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP_FAST(npy_ulonglong, npy_ulonglong, *out = 1.0 / in);
}
#endif

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
ULONGLONG_conjugate_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_ulonglong, npy_ulonglong, *out = in);
}
#endif

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
ULONGLONG_negative_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_ulonglong, npy_ulonglong, *out = -in);
}
#endif

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
ULONGLONG_logical_not_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_ulonglong, npy_bool, *out = !in);
}
#endif

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
ULONGLONG_invert_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_ulonglong, npy_ulonglong, *out = ~in);
}
#endif

#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
ULONGLONG_add_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ulonglong) {
            io1 += *(npy_ulonglong *)ip2;
        }
        *((npy_ulonglong *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_ulonglong, npy_ulonglong, *out = in1 + in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
ULONGLONG_subtract_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ulonglong) {
            io1 -= *(npy_ulonglong *)ip2;
        }
        *((npy_ulonglong *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_ulonglong, npy_ulonglong, *out = in1 - in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
ULONGLONG_multiply_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ulonglong) {
            io1 *= *(npy_ulonglong *)ip2;
        }
        *((npy_ulonglong *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_ulonglong, npy_ulonglong, *out = in1 * in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
ULONGLONG_bitwise_and_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ulonglong) {
            io1 &= *(npy_ulonglong *)ip2;
        }
        *((npy_ulonglong *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_ulonglong, npy_ulonglong, *out = in1 & in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
ULONGLONG_bitwise_or_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ulonglong) {
            io1 |= *(npy_ulonglong *)ip2;
        }
        *((npy_ulonglong *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_ulonglong, npy_ulonglong, *out = in1 | in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
ULONGLONG_bitwise_xor_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ulonglong) {
            io1 ^= *(npy_ulonglong *)ip2;
        }
        *((npy_ulonglong *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_ulonglong, npy_ulonglong, *out = in1 ^ in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
ULONGLONG_left_shift_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ulonglong) {
            io1 <<= *(npy_ulonglong *)ip2;
        }
        *((npy_ulonglong *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_ulonglong, npy_ulonglong, *out = in1 << in2);
    }
}
#endif


#line 913

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
ULONGLONG_right_shift_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if(IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ulonglong) {
            io1 >>= *(npy_ulonglong *)ip2;
        }
        *((npy_ulonglong *)iop1) = io1;
    }
    else {
        BINARY_LOOP_FAST(npy_ulonglong, npy_ulonglong, *out = in1 >> in2);
    }
}
#endif



#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
ULONGLONG_equal_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ulonglong, npy_bool, *out = in1 == in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
ULONGLONG_not_equal_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ulonglong, npy_bool, *out = in1 != in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
ULONGLONG_greater_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ulonglong, npy_bool, *out = in1 > in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
ULONGLONG_greater_equal_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ulonglong, npy_bool, *out = in1 >= in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
ULONGLONG_less_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ulonglong, npy_bool, *out = in1 < in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
ULONGLONG_less_equal_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ulonglong, npy_bool, *out = in1 <= in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
ULONGLONG_logical_and_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ulonglong, npy_bool, *out = in1 && in2);
}
#endif


#line 937

#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
ULONGLONG_logical_or_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * gcc vectorization of this is not good (PR60575) but manual integer
     * vectorization is too tedious to be worthwhile
     */
    BINARY_LOOP_FAST(npy_ulonglong, npy_bool, *out = in1 || in2);
}
#endif



#if HAVE_ATTRIBUTE_TARGET_AVX2
NPY_NO_EXPORT NPY_GCC_OPT_3 NPY_GCC_TARGET_AVX2 void
ULONGLONG_logical_xor_avx2(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const int t1 = !!*(npy_ulonglong *)ip1;
        const int t2 = !!*(npy_ulonglong *)ip2;
        *((npy_bool *)op1) = (t1 != t2);
    }
}
#endif



#line 970

NPY_NO_EXPORT void
ULONGLONG_maximum(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ulonglong) {
            const npy_ulonglong in2 = *(npy_ulonglong *)ip2;
            io1 = (io1 > in2) ? io1 : in2;
        }
        *((npy_ulonglong *)iop1) = io1;
    }
    else {
        BINARY_LOOP {
            const npy_ulonglong in1 = *(npy_ulonglong *)ip1;
            const npy_ulonglong in2 = *(npy_ulonglong *)ip2;
            *((npy_ulonglong *)op1) = (in1 > in2) ? in1 : in2;
        }
    }
}


#line 970

NPY_NO_EXPORT void
ULONGLONG_minimum(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_ulonglong) {
            const npy_ulonglong in2 = *(npy_ulonglong *)ip2;
            io1 = (io1 < in2) ? io1 : in2;
        }
        *((npy_ulonglong *)iop1) = io1;
    }
    else {
        BINARY_LOOP {
            const npy_ulonglong in1 = *(npy_ulonglong *)ip1;
            const npy_ulonglong in2 = *(npy_ulonglong *)ip2;
            *((npy_ulonglong *)op1) = (in1 < in2) ? in1 : in2;
        }
    }
}



NPY_NO_EXPORT void
ULONGLONG_power(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        npy_ulonglong in1 = *(npy_ulonglong *)ip1;
        npy_ulonglong in2 = *(npy_ulonglong *)ip2;
        npy_ulonglong out;

#if 0
        if (in2 < 0) {
            NPY_ALLOW_C_API_DEF
            NPY_ALLOW_C_API;
            PyErr_SetString(PyExc_ValueError,
                    "Integers to negative integer powers are not allowed.");
            NPY_DISABLE_C_API;
            return;
        }
#endif
        if (in2 == 0) {
            *((npy_ulonglong *)op1) = 1;
            continue;
        }
        if (in1 == 1) {
            *((npy_ulonglong *)op1) = 1;
            continue;
        }

        out = in2 & 1 ? in1 : 1;
        in2 >>= 1;
        while (in2 > 0) {
            in1 *= in1;
            if (in2 & 1) {
                out *= in1;
            }
            in2 >>= 1;
        }
        *((npy_ulonglong *) op1) = out;
    }
}

NPY_NO_EXPORT void
ULONGLONG_fmod(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_ulonglong in1 = *(npy_ulonglong *)ip1;
        const npy_ulonglong in2 = *(npy_ulonglong *)ip2;
        if (in2 == 0) {
            npy_set_floatstatus_divbyzero();
            *((npy_ulonglong *)op1) = 0;
        }
        else {
            *((npy_ulonglong *)op1)= in1 % in2;
        }

    }
}



#line 1056

NPY_NO_EXPORT NPY_GCC_OPT_3 void
BYTE_absolute(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_byte, npy_byte, *out = (in >= 0) ? in : -in);
}

NPY_NO_EXPORT NPY_GCC_OPT_3 void
BYTE_sign(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_byte, npy_byte, *out = in > 0 ? 1 : (in < 0 ? -1 : 0));
}

NPY_NO_EXPORT void
BYTE_divide(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_byte in1 = *(npy_byte *)ip1;
        const npy_byte in2 = *(npy_byte *)ip2;
        /*
         * FIXME: On x86 at least, dividing the smallest representable integer
         * by -1 causes a SIFGPE (division overflow). We treat this case here
         * (to avoid a SIGFPE crash at python level), but a good solution would
         * be to treat integer division problems separately from FPU exceptions
         * (i.e. a different approach than npy_set_floatstatus_divbyzero()).
         */
        if (in2 == 0 || (in1 == NPY_MIN_BYTE && in2 == -1)) {
            npy_set_floatstatus_divbyzero();
            *((npy_byte *)op1) = 0;
        }
        else if (((in1 > 0) != (in2 > 0)) && (in1 % in2 != 0)) {
            *((npy_byte *)op1) = in1/in2 - 1;
        }
        else {
            *((npy_byte *)op1) = in1/in2;
        }
    }
}

NPY_NO_EXPORT void
BYTE_remainder(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_byte in1 = *(npy_byte *)ip1;
        const npy_byte in2 = *(npy_byte *)ip2;
        if (in2 == 0) {
            npy_set_floatstatus_divbyzero();
            *((npy_byte *)op1) = 0;
        }
        else {
            /* handle mixed case the way Python does */
            const npy_byte rem = in1 % in2;
            if ((in1 > 0) == (in2 > 0) || rem == 0) {
                *((npy_byte *)op1) = rem;
            }
            else {
                *((npy_byte *)op1) = rem + in2;
            }
        }
    }
}

NPY_NO_EXPORT void
BYTE_divmod(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP_TWO_OUT {
        const npy_byte in1 = *(npy_byte *)ip1;
        const npy_byte in2 = *(npy_byte *)ip2;
        /* see FIXME note for divide above */
        if (in2 == 0 || (in1 == NPY_MIN_BYTE && in2 == -1)) {
            npy_set_floatstatus_divbyzero();
            *((npy_byte *)op1) = 0;
            *((npy_byte *)op2) = 0;
        }
        else {
            /* handle mixed case the way Python does */
            const npy_byte quo = in1 / in2;
            const npy_byte rem = in1 % in2;
            if ((in1 > 0) == (in2 > 0) || rem == 0) {
                *((npy_byte *)op1) = quo;
                *((npy_byte *)op2) = rem;
            }
            else {
                *((npy_byte *)op1) = quo - 1;
                *((npy_byte *)op2) = rem + in2;
            }
        }
    }
}

#line 1149
NPY_NO_EXPORT void
BYTE_gcd(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_byte in1 = *(npy_byte *)ip1;
        const npy_byte in2 = *(npy_byte *)ip2;
        *((npy_byte *)op1) = npy_gcd(in1, in2);
    }
}

#line 1149
NPY_NO_EXPORT void
BYTE_lcm(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_byte in1 = *(npy_byte *)ip1;
        const npy_byte in2 = *(npy_byte *)ip2;
        *((npy_byte *)op1) = npy_lcm(in1, in2);
    }
}



#line 1056

NPY_NO_EXPORT NPY_GCC_OPT_3 void
SHORT_absolute(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_short, npy_short, *out = (in >= 0) ? in : -in);
}

NPY_NO_EXPORT NPY_GCC_OPT_3 void
SHORT_sign(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_short, npy_short, *out = in > 0 ? 1 : (in < 0 ? -1 : 0));
}

NPY_NO_EXPORT void
SHORT_divide(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_short in1 = *(npy_short *)ip1;
        const npy_short in2 = *(npy_short *)ip2;
        /*
         * FIXME: On x86 at least, dividing the smallest representable integer
         * by -1 causes a SIFGPE (division overflow). We treat this case here
         * (to avoid a SIGFPE crash at python level), but a good solution would
         * be to treat integer division problems separately from FPU exceptions
         * (i.e. a different approach than npy_set_floatstatus_divbyzero()).
         */
        if (in2 == 0 || (in1 == NPY_MIN_SHORT && in2 == -1)) {
            npy_set_floatstatus_divbyzero();
            *((npy_short *)op1) = 0;
        }
        else if (((in1 > 0) != (in2 > 0)) && (in1 % in2 != 0)) {
            *((npy_short *)op1) = in1/in2 - 1;
        }
        else {
            *((npy_short *)op1) = in1/in2;
        }
    }
}

NPY_NO_EXPORT void
SHORT_remainder(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_short in1 = *(npy_short *)ip1;
        const npy_short in2 = *(npy_short *)ip2;
        if (in2 == 0) {
            npy_set_floatstatus_divbyzero();
            *((npy_short *)op1) = 0;
        }
        else {
            /* handle mixed case the way Python does */
            const npy_short rem = in1 % in2;
            if ((in1 > 0) == (in2 > 0) || rem == 0) {
                *((npy_short *)op1) = rem;
            }
            else {
                *((npy_short *)op1) = rem + in2;
            }
        }
    }
}

NPY_NO_EXPORT void
SHORT_divmod(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP_TWO_OUT {
        const npy_short in1 = *(npy_short *)ip1;
        const npy_short in2 = *(npy_short *)ip2;
        /* see FIXME note for divide above */
        if (in2 == 0 || (in1 == NPY_MIN_SHORT && in2 == -1)) {
            npy_set_floatstatus_divbyzero();
            *((npy_short *)op1) = 0;
            *((npy_short *)op2) = 0;
        }
        else {
            /* handle mixed case the way Python does */
            const npy_short quo = in1 / in2;
            const npy_short rem = in1 % in2;
            if ((in1 > 0) == (in2 > 0) || rem == 0) {
                *((npy_short *)op1) = quo;
                *((npy_short *)op2) = rem;
            }
            else {
                *((npy_short *)op1) = quo - 1;
                *((npy_short *)op2) = rem + in2;
            }
        }
    }
}

#line 1149
NPY_NO_EXPORT void
SHORT_gcd(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_short in1 = *(npy_short *)ip1;
        const npy_short in2 = *(npy_short *)ip2;
        *((npy_short *)op1) = npy_gcd(in1, in2);
    }
}

#line 1149
NPY_NO_EXPORT void
SHORT_lcm(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_short in1 = *(npy_short *)ip1;
        const npy_short in2 = *(npy_short *)ip2;
        *((npy_short *)op1) = npy_lcm(in1, in2);
    }
}



#line 1056

NPY_NO_EXPORT NPY_GCC_OPT_3 void
INT_absolute(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_int, npy_int, *out = (in >= 0) ? in : -in);
}

NPY_NO_EXPORT NPY_GCC_OPT_3 void
INT_sign(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_int, npy_int, *out = in > 0 ? 1 : (in < 0 ? -1 : 0));
}

NPY_NO_EXPORT void
INT_divide(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_int in1 = *(npy_int *)ip1;
        const npy_int in2 = *(npy_int *)ip2;
        /*
         * FIXME: On x86 at least, dividing the smallest representable integer
         * by -1 causes a SIFGPE (division overflow). We treat this case here
         * (to avoid a SIGFPE crash at python level), but a good solution would
         * be to treat integer division problems separately from FPU exceptions
         * (i.e. a different approach than npy_set_floatstatus_divbyzero()).
         */
        if (in2 == 0 || (in1 == NPY_MIN_INT && in2 == -1)) {
            npy_set_floatstatus_divbyzero();
            *((npy_int *)op1) = 0;
        }
        else if (((in1 > 0) != (in2 > 0)) && (in1 % in2 != 0)) {
            *((npy_int *)op1) = in1/in2 - 1;
        }
        else {
            *((npy_int *)op1) = in1/in2;
        }
    }
}

NPY_NO_EXPORT void
INT_remainder(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_int in1 = *(npy_int *)ip1;
        const npy_int in2 = *(npy_int *)ip2;
        if (in2 == 0) {
            npy_set_floatstatus_divbyzero();
            *((npy_int *)op1) = 0;
        }
        else {
            /* handle mixed case the way Python does */
            const npy_int rem = in1 % in2;
            if ((in1 > 0) == (in2 > 0) || rem == 0) {
                *((npy_int *)op1) = rem;
            }
            else {
                *((npy_int *)op1) = rem + in2;
            }
        }
    }
}

NPY_NO_EXPORT void
INT_divmod(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP_TWO_OUT {
        const npy_int in1 = *(npy_int *)ip1;
        const npy_int in2 = *(npy_int *)ip2;
        /* see FIXME note for divide above */
        if (in2 == 0 || (in1 == NPY_MIN_INT && in2 == -1)) {
            npy_set_floatstatus_divbyzero();
            *((npy_int *)op1) = 0;
            *((npy_int *)op2) = 0;
        }
        else {
            /* handle mixed case the way Python does */
            const npy_int quo = in1 / in2;
            const npy_int rem = in1 % in2;
            if ((in1 > 0) == (in2 > 0) || rem == 0) {
                *((npy_int *)op1) = quo;
                *((npy_int *)op2) = rem;
            }
            else {
                *((npy_int *)op1) = quo - 1;
                *((npy_int *)op2) = rem + in2;
            }
        }
    }
}

#line 1149
NPY_NO_EXPORT void
INT_gcd(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_int in1 = *(npy_int *)ip1;
        const npy_int in2 = *(npy_int *)ip2;
        *((npy_int *)op1) = npy_gcd(in1, in2);
    }
}

#line 1149
NPY_NO_EXPORT void
INT_lcm(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_int in1 = *(npy_int *)ip1;
        const npy_int in2 = *(npy_int *)ip2;
        *((npy_int *)op1) = npy_lcm(in1, in2);
    }
}



#line 1056

NPY_NO_EXPORT NPY_GCC_OPT_3 void
LONG_absolute(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_long, npy_long, *out = (in >= 0) ? in : -in);
}

NPY_NO_EXPORT NPY_GCC_OPT_3 void
LONG_sign(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_long, npy_long, *out = in > 0 ? 1 : (in < 0 ? -1 : 0));
}

NPY_NO_EXPORT void
LONG_divide(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_long in1 = *(npy_long *)ip1;
        const npy_long in2 = *(npy_long *)ip2;
        /*
         * FIXME: On x86 at least, dividing the smallest representable integer
         * by -1 causes a SIFGPE (division overflow). We treat this case here
         * (to avoid a SIGFPE crash at python level), but a good solution would
         * be to treat integer division problems separately from FPU exceptions
         * (i.e. a different approach than npy_set_floatstatus_divbyzero()).
         */
        if (in2 == 0 || (in1 == NPY_MIN_LONG && in2 == -1)) {
            npy_set_floatstatus_divbyzero();
            *((npy_long *)op1) = 0;
        }
        else if (((in1 > 0) != (in2 > 0)) && (in1 % in2 != 0)) {
            *((npy_long *)op1) = in1/in2 - 1;
        }
        else {
            *((npy_long *)op1) = in1/in2;
        }
    }
}

NPY_NO_EXPORT void
LONG_remainder(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_long in1 = *(npy_long *)ip1;
        const npy_long in2 = *(npy_long *)ip2;
        if (in2 == 0) {
            npy_set_floatstatus_divbyzero();
            *((npy_long *)op1) = 0;
        }
        else {
            /* handle mixed case the way Python does */
            const npy_long rem = in1 % in2;
            if ((in1 > 0) == (in2 > 0) || rem == 0) {
                *((npy_long *)op1) = rem;
            }
            else {
                *((npy_long *)op1) = rem + in2;
            }
        }
    }
}

NPY_NO_EXPORT void
LONG_divmod(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP_TWO_OUT {
        const npy_long in1 = *(npy_long *)ip1;
        const npy_long in2 = *(npy_long *)ip2;
        /* see FIXME note for divide above */
        if (in2 == 0 || (in1 == NPY_MIN_LONG && in2 == -1)) {
            npy_set_floatstatus_divbyzero();
            *((npy_long *)op1) = 0;
            *((npy_long *)op2) = 0;
        }
        else {
            /* handle mixed case the way Python does */
            const npy_long quo = in1 / in2;
            const npy_long rem = in1 % in2;
            if ((in1 > 0) == (in2 > 0) || rem == 0) {
                *((npy_long *)op1) = quo;
                *((npy_long *)op2) = rem;
            }
            else {
                *((npy_long *)op1) = quo - 1;
                *((npy_long *)op2) = rem + in2;
            }
        }
    }
}

#line 1149
NPY_NO_EXPORT void
LONG_gcd(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_long in1 = *(npy_long *)ip1;
        const npy_long in2 = *(npy_long *)ip2;
        *((npy_long *)op1) = npy_gcdl(in1, in2);
    }
}

#line 1149
NPY_NO_EXPORT void
LONG_lcm(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_long in1 = *(npy_long *)ip1;
        const npy_long in2 = *(npy_long *)ip2;
        *((npy_long *)op1) = npy_lcml(in1, in2);
    }
}



#line 1056

NPY_NO_EXPORT NPY_GCC_OPT_3 void
LONGLONG_absolute(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_longlong, npy_longlong, *out = (in >= 0) ? in : -in);
}

NPY_NO_EXPORT NPY_GCC_OPT_3 void
LONGLONG_sign(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_longlong, npy_longlong, *out = in > 0 ? 1 : (in < 0 ? -1 : 0));
}

NPY_NO_EXPORT void
LONGLONG_divide(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_longlong in1 = *(npy_longlong *)ip1;
        const npy_longlong in2 = *(npy_longlong *)ip2;
        /*
         * FIXME: On x86 at least, dividing the smallest representable integer
         * by -1 causes a SIFGPE (division overflow). We treat this case here
         * (to avoid a SIGFPE crash at python level), but a good solution would
         * be to treat integer division problems separately from FPU exceptions
         * (i.e. a different approach than npy_set_floatstatus_divbyzero()).
         */
        if (in2 == 0 || (in1 == NPY_MIN_LONGLONG && in2 == -1)) {
            npy_set_floatstatus_divbyzero();
            *((npy_longlong *)op1) = 0;
        }
        else if (((in1 > 0) != (in2 > 0)) && (in1 % in2 != 0)) {
            *((npy_longlong *)op1) = in1/in2 - 1;
        }
        else {
            *((npy_longlong *)op1) = in1/in2;
        }
    }
}

NPY_NO_EXPORT void
LONGLONG_remainder(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_longlong in1 = *(npy_longlong *)ip1;
        const npy_longlong in2 = *(npy_longlong *)ip2;
        if (in2 == 0) {
            npy_set_floatstatus_divbyzero();
            *((npy_longlong *)op1) = 0;
        }
        else {
            /* handle mixed case the way Python does */
            const npy_longlong rem = in1 % in2;
            if ((in1 > 0) == (in2 > 0) || rem == 0) {
                *((npy_longlong *)op1) = rem;
            }
            else {
                *((npy_longlong *)op1) = rem + in2;
            }
        }
    }
}

NPY_NO_EXPORT void
LONGLONG_divmod(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP_TWO_OUT {
        const npy_longlong in1 = *(npy_longlong *)ip1;
        const npy_longlong in2 = *(npy_longlong *)ip2;
        /* see FIXME note for divide above */
        if (in2 == 0 || (in1 == NPY_MIN_LONGLONG && in2 == -1)) {
            npy_set_floatstatus_divbyzero();
            *((npy_longlong *)op1) = 0;
            *((npy_longlong *)op2) = 0;
        }
        else {
            /* handle mixed case the way Python does */
            const npy_longlong quo = in1 / in2;
            const npy_longlong rem = in1 % in2;
            if ((in1 > 0) == (in2 > 0) || rem == 0) {
                *((npy_longlong *)op1) = quo;
                *((npy_longlong *)op2) = rem;
            }
            else {
                *((npy_longlong *)op1) = quo - 1;
                *((npy_longlong *)op2) = rem + in2;
            }
        }
    }
}

#line 1149
NPY_NO_EXPORT void
LONGLONG_gcd(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_longlong in1 = *(npy_longlong *)ip1;
        const npy_longlong in2 = *(npy_longlong *)ip2;
        *((npy_longlong *)op1) = npy_gcdll(in1, in2);
    }
}

#line 1149
NPY_NO_EXPORT void
LONGLONG_lcm(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_longlong in1 = *(npy_longlong *)ip1;
        const npy_longlong in2 = *(npy_longlong *)ip2;
        *((npy_longlong *)op1) = npy_lcmll(in1, in2);
    }
}




#line 1167

NPY_NO_EXPORT void
UBYTE_absolute(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_ubyte in1 = *(npy_ubyte *)ip1;
        *((npy_ubyte *)op1) = in1;
    }
}

NPY_NO_EXPORT NPY_GCC_OPT_3 void
UBYTE_sign(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_ubyte, npy_ubyte, *out = in > 0 ? 1 : 0);
}

NPY_NO_EXPORT void
UBYTE_divide(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_ubyte in1 = *(npy_ubyte *)ip1;
        const npy_ubyte in2 = *(npy_ubyte *)ip2;
        if (in2 == 0) {
            npy_set_floatstatus_divbyzero();
            *((npy_ubyte *)op1) = 0;
        }
        else {
            *((npy_ubyte *)op1)= in1/in2;
        }
    }
}

NPY_NO_EXPORT void
UBYTE_remainder(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_ubyte in1 = *(npy_ubyte *)ip1;
        const npy_ubyte in2 = *(npy_ubyte *)ip2;
        if (in2 == 0) {
            npy_set_floatstatus_divbyzero();
            *((npy_ubyte *)op1) = 0;
        }
        else {
            *((npy_ubyte *)op1) = in1 % in2;
        }
    }
}

NPY_NO_EXPORT void
UBYTE_divmod(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP_TWO_OUT {
        const npy_ubyte in1 = *(npy_ubyte *)ip1;
        const npy_ubyte in2 = *(npy_ubyte *)ip2;
        if (in2 == 0) {
            npy_set_floatstatus_divbyzero();
            *((npy_ubyte *)op1) = 0;
            *((npy_ubyte *)op2) = 0;
        }
        else {
            *((npy_ubyte *)op1)= in1/in2;
            *((npy_ubyte *)op2) = in1 % in2;
        }
    }
}

#line 1236
NPY_NO_EXPORT void
UBYTE_gcd(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_ubyte in1 = *(npy_ubyte *)ip1;
        const npy_ubyte in2 = *(npy_ubyte *)ip2;
        *((npy_ubyte *)op1) = npy_gcdu(in1, in2);
    }
}

#line 1236
NPY_NO_EXPORT void
UBYTE_lcm(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_ubyte in1 = *(npy_ubyte *)ip1;
        const npy_ubyte in2 = *(npy_ubyte *)ip2;
        *((npy_ubyte *)op1) = npy_lcmu(in1, in2);
    }
}



#line 1167

NPY_NO_EXPORT void
USHORT_absolute(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_ushort in1 = *(npy_ushort *)ip1;
        *((npy_ushort *)op1) = in1;
    }
}

NPY_NO_EXPORT NPY_GCC_OPT_3 void
USHORT_sign(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_ushort, npy_ushort, *out = in > 0 ? 1 : 0);
}

NPY_NO_EXPORT void
USHORT_divide(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_ushort in1 = *(npy_ushort *)ip1;
        const npy_ushort in2 = *(npy_ushort *)ip2;
        if (in2 == 0) {
            npy_set_floatstatus_divbyzero();
            *((npy_ushort *)op1) = 0;
        }
        else {
            *((npy_ushort *)op1)= in1/in2;
        }
    }
}

NPY_NO_EXPORT void
USHORT_remainder(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_ushort in1 = *(npy_ushort *)ip1;
        const npy_ushort in2 = *(npy_ushort *)ip2;
        if (in2 == 0) {
            npy_set_floatstatus_divbyzero();
            *((npy_ushort *)op1) = 0;
        }
        else {
            *((npy_ushort *)op1) = in1 % in2;
        }
    }
}

NPY_NO_EXPORT void
USHORT_divmod(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP_TWO_OUT {
        const npy_ushort in1 = *(npy_ushort *)ip1;
        const npy_ushort in2 = *(npy_ushort *)ip2;
        if (in2 == 0) {
            npy_set_floatstatus_divbyzero();
            *((npy_ushort *)op1) = 0;
            *((npy_ushort *)op2) = 0;
        }
        else {
            *((npy_ushort *)op1)= in1/in2;
            *((npy_ushort *)op2) = in1 % in2;
        }
    }
}

#line 1236
NPY_NO_EXPORT void
USHORT_gcd(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_ushort in1 = *(npy_ushort *)ip1;
        const npy_ushort in2 = *(npy_ushort *)ip2;
        *((npy_ushort *)op1) = npy_gcdu(in1, in2);
    }
}

#line 1236
NPY_NO_EXPORT void
USHORT_lcm(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_ushort in1 = *(npy_ushort *)ip1;
        const npy_ushort in2 = *(npy_ushort *)ip2;
        *((npy_ushort *)op1) = npy_lcmu(in1, in2);
    }
}



#line 1167

NPY_NO_EXPORT void
UINT_absolute(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_uint in1 = *(npy_uint *)ip1;
        *((npy_uint *)op1) = in1;
    }
}

NPY_NO_EXPORT NPY_GCC_OPT_3 void
UINT_sign(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_uint, npy_uint, *out = in > 0 ? 1 : 0);
}

NPY_NO_EXPORT void
UINT_divide(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_uint in1 = *(npy_uint *)ip1;
        const npy_uint in2 = *(npy_uint *)ip2;
        if (in2 == 0) {
            npy_set_floatstatus_divbyzero();
            *((npy_uint *)op1) = 0;
        }
        else {
            *((npy_uint *)op1)= in1/in2;
        }
    }
}

NPY_NO_EXPORT void
UINT_remainder(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_uint in1 = *(npy_uint *)ip1;
        const npy_uint in2 = *(npy_uint *)ip2;
        if (in2 == 0) {
            npy_set_floatstatus_divbyzero();
            *((npy_uint *)op1) = 0;
        }
        else {
            *((npy_uint *)op1) = in1 % in2;
        }
    }
}

NPY_NO_EXPORT void
UINT_divmod(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP_TWO_OUT {
        const npy_uint in1 = *(npy_uint *)ip1;
        const npy_uint in2 = *(npy_uint *)ip2;
        if (in2 == 0) {
            npy_set_floatstatus_divbyzero();
            *((npy_uint *)op1) = 0;
            *((npy_uint *)op2) = 0;
        }
        else {
            *((npy_uint *)op1)= in1/in2;
            *((npy_uint *)op2) = in1 % in2;
        }
    }
}

#line 1236
NPY_NO_EXPORT void
UINT_gcd(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_uint in1 = *(npy_uint *)ip1;
        const npy_uint in2 = *(npy_uint *)ip2;
        *((npy_uint *)op1) = npy_gcdu(in1, in2);
    }
}

#line 1236
NPY_NO_EXPORT void
UINT_lcm(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_uint in1 = *(npy_uint *)ip1;
        const npy_uint in2 = *(npy_uint *)ip2;
        *((npy_uint *)op1) = npy_lcmu(in1, in2);
    }
}



#line 1167

NPY_NO_EXPORT void
ULONG_absolute(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_ulong in1 = *(npy_ulong *)ip1;
        *((npy_ulong *)op1) = in1;
    }
}

NPY_NO_EXPORT NPY_GCC_OPT_3 void
ULONG_sign(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_ulong, npy_ulong, *out = in > 0 ? 1 : 0);
}

NPY_NO_EXPORT void
ULONG_divide(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_ulong in1 = *(npy_ulong *)ip1;
        const npy_ulong in2 = *(npy_ulong *)ip2;
        if (in2 == 0) {
            npy_set_floatstatus_divbyzero();
            *((npy_ulong *)op1) = 0;
        }
        else {
            *((npy_ulong *)op1)= in1/in2;
        }
    }
}

NPY_NO_EXPORT void
ULONG_remainder(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_ulong in1 = *(npy_ulong *)ip1;
        const npy_ulong in2 = *(npy_ulong *)ip2;
        if (in2 == 0) {
            npy_set_floatstatus_divbyzero();
            *((npy_ulong *)op1) = 0;
        }
        else {
            *((npy_ulong *)op1) = in1 % in2;
        }
    }
}

NPY_NO_EXPORT void
ULONG_divmod(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP_TWO_OUT {
        const npy_ulong in1 = *(npy_ulong *)ip1;
        const npy_ulong in2 = *(npy_ulong *)ip2;
        if (in2 == 0) {
            npy_set_floatstatus_divbyzero();
            *((npy_ulong *)op1) = 0;
            *((npy_ulong *)op2) = 0;
        }
        else {
            *((npy_ulong *)op1)= in1/in2;
            *((npy_ulong *)op2) = in1 % in2;
        }
    }
}

#line 1236
NPY_NO_EXPORT void
ULONG_gcd(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_ulong in1 = *(npy_ulong *)ip1;
        const npy_ulong in2 = *(npy_ulong *)ip2;
        *((npy_ulong *)op1) = npy_gcdul(in1, in2);
    }
}

#line 1236
NPY_NO_EXPORT void
ULONG_lcm(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_ulong in1 = *(npy_ulong *)ip1;
        const npy_ulong in2 = *(npy_ulong *)ip2;
        *((npy_ulong *)op1) = npy_lcmul(in1, in2);
    }
}



#line 1167

NPY_NO_EXPORT void
ULONGLONG_absolute(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_ulonglong in1 = *(npy_ulonglong *)ip1;
        *((npy_ulonglong *)op1) = in1;
    }
}

NPY_NO_EXPORT NPY_GCC_OPT_3 void
ULONGLONG_sign(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_FAST(npy_ulonglong, npy_ulonglong, *out = in > 0 ? 1 : 0);
}

NPY_NO_EXPORT void
ULONGLONG_divide(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_ulonglong in1 = *(npy_ulonglong *)ip1;
        const npy_ulonglong in2 = *(npy_ulonglong *)ip2;
        if (in2 == 0) {
            npy_set_floatstatus_divbyzero();
            *((npy_ulonglong *)op1) = 0;
        }
        else {
            *((npy_ulonglong *)op1)= in1/in2;
        }
    }
}

NPY_NO_EXPORT void
ULONGLONG_remainder(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_ulonglong in1 = *(npy_ulonglong *)ip1;
        const npy_ulonglong in2 = *(npy_ulonglong *)ip2;
        if (in2 == 0) {
            npy_set_floatstatus_divbyzero();
            *((npy_ulonglong *)op1) = 0;
        }
        else {
            *((npy_ulonglong *)op1) = in1 % in2;
        }
    }
}

NPY_NO_EXPORT void
ULONGLONG_divmod(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP_TWO_OUT {
        const npy_ulonglong in1 = *(npy_ulonglong *)ip1;
        const npy_ulonglong in2 = *(npy_ulonglong *)ip2;
        if (in2 == 0) {
            npy_set_floatstatus_divbyzero();
            *((npy_ulonglong *)op1) = 0;
            *((npy_ulonglong *)op2) = 0;
        }
        else {
            *((npy_ulonglong *)op1)= in1/in2;
            *((npy_ulonglong *)op2) = in1 % in2;
        }
    }
}

#line 1236
NPY_NO_EXPORT void
ULONGLONG_gcd(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_ulonglong in1 = *(npy_ulonglong *)ip1;
        const npy_ulonglong in2 = *(npy_ulonglong *)ip2;
        *((npy_ulonglong *)op1) = npy_gcdull(in1, in2);
    }
}

#line 1236
NPY_NO_EXPORT void
ULONGLONG_lcm(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_ulonglong in1 = *(npy_ulonglong *)ip1;
        const npy_ulonglong in2 = *(npy_ulonglong *)ip2;
        *((npy_ulonglong *)op1) = npy_lcmull(in1, in2);
    }
}




/*
 *****************************************************************************
 **                           DATETIME LOOPS                                **
 *****************************************************************************
 */

NPY_NO_EXPORT void
TIMEDELTA_negative(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_timedelta in1 = *(npy_timedelta *)ip1;
        if (in1 == NPY_DATETIME_NAT) {
            *((npy_timedelta *)op1) = NPY_DATETIME_NAT;
        }
        else {
            *((npy_timedelta *)op1) = -in1;
        }
    }
}

NPY_NO_EXPORT void
TIMEDELTA_positive(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_timedelta in1 = *(npy_timedelta *)ip1;
        *((npy_timedelta *)op1) = +in1;
    }
}

NPY_NO_EXPORT void
TIMEDELTA_absolute(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_timedelta in1 = *(npy_timedelta *)ip1;
        if (in1 == NPY_DATETIME_NAT) {
            *((npy_timedelta *)op1) = NPY_DATETIME_NAT;
        }
        else {
            *((npy_timedelta *)op1) = (in1 >= 0) ? in1 : -in1;
        }
    }
}

NPY_NO_EXPORT void
TIMEDELTA_sign(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_timedelta in1 = *(npy_timedelta *)ip1;
        *((npy_timedelta *)op1) = in1 > 0 ? 1 : (in1 < 0 ? -1 : 0);
    }
}

#line 1305

NPY_NO_EXPORT void
DATETIME_isnat(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_datetime in1 = *(npy_datetime *)ip1;
        *((npy_bool *)op1) = (in1 == NPY_DATETIME_NAT);
    }
}

NPY_NO_EXPORT void
DATETIME__ones_like(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    OUTPUT_LOOP {
        *((npy_datetime *)op1) = 1;
    }
}

#line 1327
NPY_NO_EXPORT void
DATETIME_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_datetime in1 = *(npy_datetime *)ip1;
        const npy_datetime in2 = *(npy_datetime *)ip2;
        *((npy_bool *)op1) = (in1 == in2 &&
                              in1 != NPY_DATETIME_NAT &&
                              in2 != NPY_DATETIME_NAT);
    }
}

#line 1327
NPY_NO_EXPORT void
DATETIME_greater(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_datetime in1 = *(npy_datetime *)ip1;
        const npy_datetime in2 = *(npy_datetime *)ip2;
        *((npy_bool *)op1) = (in1 > in2 &&
                              in1 != NPY_DATETIME_NAT &&
                              in2 != NPY_DATETIME_NAT);
    }
}

#line 1327
NPY_NO_EXPORT void
DATETIME_greater_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_datetime in1 = *(npy_datetime *)ip1;
        const npy_datetime in2 = *(npy_datetime *)ip2;
        *((npy_bool *)op1) = (in1 >= in2 &&
                              in1 != NPY_DATETIME_NAT &&
                              in2 != NPY_DATETIME_NAT);
    }
}

#line 1327
NPY_NO_EXPORT void
DATETIME_less(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_datetime in1 = *(npy_datetime *)ip1;
        const npy_datetime in2 = *(npy_datetime *)ip2;
        *((npy_bool *)op1) = (in1 < in2 &&
                              in1 != NPY_DATETIME_NAT &&
                              in2 != NPY_DATETIME_NAT);
    }
}

#line 1327
NPY_NO_EXPORT void
DATETIME_less_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_datetime in1 = *(npy_datetime *)ip1;
        const npy_datetime in2 = *(npy_datetime *)ip2;
        *((npy_bool *)op1) = (in1 <= in2 &&
                              in1 != NPY_DATETIME_NAT &&
                              in2 != NPY_DATETIME_NAT);
    }
}


NPY_NO_EXPORT void
DATETIME_not_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_datetime in1 = *(npy_datetime *)ip1;
        const npy_datetime in2 = *(npy_datetime *)ip2;
        *((npy_bool *)op1) = (in1 != in2 ||
                              in1 == NPY_DATETIME_NAT ||
                              in2 == NPY_DATETIME_NAT);
    }
}


#line 1357
NPY_NO_EXPORT void
DATETIME_maximum(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_datetime in1 = *(npy_datetime *)ip1;
        const npy_datetime in2 = *(npy_datetime *)ip2;
        if (in1 == NPY_DATETIME_NAT) {
            *((npy_datetime *)op1) = in2;
        }
        else if (in2 == NPY_DATETIME_NAT) {
            *((npy_datetime *)op1) = in1;
        }
        else {
            *((npy_datetime *)op1) = (in1 > in2) ? in1 : in2;
        }
    }
}

#line 1357
NPY_NO_EXPORT void
DATETIME_minimum(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_datetime in1 = *(npy_datetime *)ip1;
        const npy_datetime in2 = *(npy_datetime *)ip2;
        if (in1 == NPY_DATETIME_NAT) {
            *((npy_datetime *)op1) = in2;
        }
        else if (in2 == NPY_DATETIME_NAT) {
            *((npy_datetime *)op1) = in1;
        }
        else {
            *((npy_datetime *)op1) = (in1 < in2) ? in1 : in2;
        }
    }
}



#line 1305

NPY_NO_EXPORT void
TIMEDELTA_isnat(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_timedelta in1 = *(npy_timedelta *)ip1;
        *((npy_bool *)op1) = (in1 == NPY_DATETIME_NAT);
    }
}

NPY_NO_EXPORT void
TIMEDELTA__ones_like(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    OUTPUT_LOOP {
        *((npy_timedelta *)op1) = 1;
    }
}

#line 1327
NPY_NO_EXPORT void
TIMEDELTA_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_timedelta in1 = *(npy_timedelta *)ip1;
        const npy_timedelta in2 = *(npy_timedelta *)ip2;
        *((npy_bool *)op1) = (in1 == in2 &&
                              in1 != NPY_DATETIME_NAT &&
                              in2 != NPY_DATETIME_NAT);
    }
}

#line 1327
NPY_NO_EXPORT void
TIMEDELTA_greater(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_timedelta in1 = *(npy_timedelta *)ip1;
        const npy_timedelta in2 = *(npy_timedelta *)ip2;
        *((npy_bool *)op1) = (in1 > in2 &&
                              in1 != NPY_DATETIME_NAT &&
                              in2 != NPY_DATETIME_NAT);
    }
}

#line 1327
NPY_NO_EXPORT void
TIMEDELTA_greater_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_timedelta in1 = *(npy_timedelta *)ip1;
        const npy_timedelta in2 = *(npy_timedelta *)ip2;
        *((npy_bool *)op1) = (in1 >= in2 &&
                              in1 != NPY_DATETIME_NAT &&
                              in2 != NPY_DATETIME_NAT);
    }
}

#line 1327
NPY_NO_EXPORT void
TIMEDELTA_less(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_timedelta in1 = *(npy_timedelta *)ip1;
        const npy_timedelta in2 = *(npy_timedelta *)ip2;
        *((npy_bool *)op1) = (in1 < in2 &&
                              in1 != NPY_DATETIME_NAT &&
                              in2 != NPY_DATETIME_NAT);
    }
}

#line 1327
NPY_NO_EXPORT void
TIMEDELTA_less_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_timedelta in1 = *(npy_timedelta *)ip1;
        const npy_timedelta in2 = *(npy_timedelta *)ip2;
        *((npy_bool *)op1) = (in1 <= in2 &&
                              in1 != NPY_DATETIME_NAT &&
                              in2 != NPY_DATETIME_NAT);
    }
}


NPY_NO_EXPORT void
TIMEDELTA_not_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_timedelta in1 = *(npy_timedelta *)ip1;
        const npy_timedelta in2 = *(npy_timedelta *)ip2;
        *((npy_bool *)op1) = (in1 != in2 ||
                              in1 == NPY_DATETIME_NAT ||
                              in2 == NPY_DATETIME_NAT);
    }
}


#line 1357
NPY_NO_EXPORT void
TIMEDELTA_maximum(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_timedelta in1 = *(npy_timedelta *)ip1;
        const npy_timedelta in2 = *(npy_timedelta *)ip2;
        if (in1 == NPY_DATETIME_NAT) {
            *((npy_timedelta *)op1) = in2;
        }
        else if (in2 == NPY_DATETIME_NAT) {
            *((npy_timedelta *)op1) = in1;
        }
        else {
            *((npy_timedelta *)op1) = (in1 > in2) ? in1 : in2;
        }
    }
}

#line 1357
NPY_NO_EXPORT void
TIMEDELTA_minimum(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_timedelta in1 = *(npy_timedelta *)ip1;
        const npy_timedelta in2 = *(npy_timedelta *)ip2;
        if (in1 == NPY_DATETIME_NAT) {
            *((npy_timedelta *)op1) = in2;
        }
        else if (in2 == NPY_DATETIME_NAT) {
            *((npy_timedelta *)op1) = in1;
        }
        else {
            *((npy_timedelta *)op1) = (in1 < in2) ? in1 : in2;
        }
    }
}




NPY_NO_EXPORT void
DATETIME_Mm_M_add(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    BINARY_LOOP {
        const npy_datetime in1 = *(npy_datetime *)ip1;
        const npy_timedelta in2 = *(npy_timedelta *)ip2;
        if (in1 == NPY_DATETIME_NAT || in2 == NPY_DATETIME_NAT) {
            *((npy_datetime *)op1) = NPY_DATETIME_NAT;
        }
        else {
            *((npy_datetime *)op1) = in1 + in2;
        }
    }
}

NPY_NO_EXPORT void
DATETIME_mM_M_add(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_timedelta in1 = *(npy_timedelta *)ip1;
        const npy_datetime in2 = *(npy_datetime *)ip2;
        if (in1 == NPY_DATETIME_NAT || in2 == NPY_DATETIME_NAT) {
            *((npy_datetime *)op1) = NPY_DATETIME_NAT;
        }
        else {
            *((npy_datetime *)op1) = in1 + in2;
        }
    }
}

NPY_NO_EXPORT void
TIMEDELTA_mm_m_add(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_timedelta in1 = *(npy_timedelta *)ip1;
        const npy_timedelta in2 = *(npy_timedelta *)ip2;
        if (in1 == NPY_DATETIME_NAT || in2 == NPY_DATETIME_NAT) {
            *((npy_timedelta *)op1) = NPY_DATETIME_NAT;
        }
        else {
            *((npy_timedelta *)op1) = in1 + in2;
        }
    }
}

NPY_NO_EXPORT void
DATETIME_Mm_M_subtract(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_datetime in1 = *(npy_datetime *)ip1;
        const npy_timedelta in2 = *(npy_timedelta *)ip2;
        if (in1 == NPY_DATETIME_NAT || in2 == NPY_DATETIME_NAT) {
            *((npy_datetime *)op1) = NPY_DATETIME_NAT;
        }
        else {
            *((npy_datetime *)op1) = in1 - in2;
        }
    }
}

NPY_NO_EXPORT void
DATETIME_MM_m_subtract(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_datetime in1 = *(npy_datetime *)ip1;
        const npy_datetime in2 = *(npy_datetime *)ip2;
        if (in1 == NPY_DATETIME_NAT || in2 == NPY_DATETIME_NAT) {
            *((npy_timedelta *)op1) = NPY_DATETIME_NAT;
        }
        else {
            *((npy_timedelta *)op1) = in1 - in2;
        }
    }
}

NPY_NO_EXPORT void
TIMEDELTA_mm_m_subtract(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_timedelta in1 = *(npy_timedelta *)ip1;
        const npy_timedelta in2 = *(npy_timedelta *)ip2;
        if (in1 == NPY_DATETIME_NAT || in2 == NPY_DATETIME_NAT) {
            *((npy_timedelta *)op1) = NPY_DATETIME_NAT;
        }
        else {
            *((npy_timedelta *)op1) = in1 - in2;
        }
    }
}

/* Note: Assuming 'q' == NPY_LONGLONG */
NPY_NO_EXPORT void
TIMEDELTA_mq_m_multiply(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_timedelta in1 = *(npy_timedelta *)ip1;
        const npy_int64 in2 = *(npy_int64 *)ip2;
        if (in1 == NPY_DATETIME_NAT) {
            *((npy_timedelta *)op1) = NPY_DATETIME_NAT;
        }
        else {
            *((npy_timedelta *)op1) = in1 * in2;
        }
    }
}

/* Note: Assuming 'q' == NPY_LONGLONG */
NPY_NO_EXPORT void
TIMEDELTA_qm_m_multiply(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_int64 in1 = *(npy_int64 *)ip1;
        const npy_timedelta in2 = *(npy_timedelta *)ip2;
        if (in2 == NPY_DATETIME_NAT) {
            *((npy_timedelta *)op1) = NPY_DATETIME_NAT;
        }
        else {
            *((npy_timedelta *)op1) = in1 * in2;
        }
    }
}

NPY_NO_EXPORT void
TIMEDELTA_md_m_multiply(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_timedelta in1 = *(npy_timedelta *)ip1;
        const double in2 = *(double *)ip2;
        if (in1 == NPY_DATETIME_NAT) {
            *((npy_timedelta *)op1) = NPY_DATETIME_NAT;
        }
        else {
            double result = in1 * in2;
            if (npy_isfinite(result)) {
                *((npy_timedelta *)op1) = (npy_timedelta)result;
            }
            else {
                *((npy_timedelta *)op1) = NPY_DATETIME_NAT;
            }
        }
    }
}

NPY_NO_EXPORT void
TIMEDELTA_dm_m_multiply(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const double in1 = *(double *)ip1;
        const npy_timedelta in2 = *(npy_timedelta *)ip2;
        if (in2 == NPY_DATETIME_NAT) {
            *((npy_timedelta *)op1) = NPY_DATETIME_NAT;
        }
        else {
            double result = in1 * in2;
            if (npy_isfinite(result)) {
                *((npy_timedelta *)op1) = (npy_timedelta)result;
            }
            else {
                *((npy_timedelta *)op1) = NPY_DATETIME_NAT;
            }
        }
    }
}

/* Note: Assuming 'q' == NPY_LONGLONG */
NPY_NO_EXPORT void
TIMEDELTA_mq_m_divide(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_timedelta in1 = *(npy_timedelta *)ip1;
        const npy_int64 in2 = *(npy_int64 *)ip2;
        if (in1 == NPY_DATETIME_NAT || in2 == 0) {
            *((npy_timedelta *)op1) = NPY_DATETIME_NAT;
        }
        else {
            *((npy_timedelta *)op1) = in1 / in2;
        }
    }
}

NPY_NO_EXPORT void
TIMEDELTA_md_m_divide(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_timedelta in1 = *(npy_timedelta *)ip1;
        const double in2 = *(double *)ip2;
        if (in1 == NPY_DATETIME_NAT) {
            *((npy_timedelta *)op1) = NPY_DATETIME_NAT;
        }
        else {
            double result = in1 / in2;
            if (npy_isfinite(result)) {
                *((npy_timedelta *)op1) = (npy_timedelta)result;
            }
            else {
                *((npy_timedelta *)op1) = NPY_DATETIME_NAT;
            }
        }
    }
}

NPY_NO_EXPORT void
TIMEDELTA_mm_d_divide(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_timedelta in1 = *(npy_timedelta *)ip1;
        const npy_timedelta in2 = *(npy_timedelta *)ip2;
        if (in1 == NPY_DATETIME_NAT || in2 == NPY_DATETIME_NAT) {
            *((double *)op1) = NPY_NAN;
        }
        else {
            *((double *)op1) = (double)in1 / (double)in2;
        }
    }
}

NPY_NO_EXPORT void
TIMEDELTA_mm_m_remainder(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_timedelta in1 = *(npy_timedelta *)ip1;
        const npy_timedelta in2 = *(npy_timedelta *)ip2;
        if (in1 == NPY_DATETIME_NAT || in2 == NPY_DATETIME_NAT) {
            *((npy_timedelta *)op1) = NPY_DATETIME_NAT;
        }
        else {
            if (in2 == 0) {
                npy_set_floatstatus_divbyzero();
                *((npy_timedelta *)op1) = NPY_DATETIME_NAT;
            }
            else {
                /* handle mixed case the way Python does */
                const npy_timedelta rem = in1 % in2;
                if ((in1 > 0) == (in2 > 0) || rem == 0) {
                    *((npy_timedelta *)op1) = rem;
                }
                else {
                    *((npy_timedelta *)op1) = rem + in2;
                }
            }
        }
    }
}

NPY_NO_EXPORT void
TIMEDELTA_mm_q_floor_divide(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_timedelta in1 = *(npy_timedelta *)ip1;
        const npy_timedelta in2 = *(npy_timedelta *)ip2;
        if (in1 == NPY_DATETIME_NAT || in2 == NPY_DATETIME_NAT) {
            npy_set_floatstatus_invalid();
            *((npy_int64 *)op1) = 0;
        }
        else if (in2 == 0) {
            npy_set_floatstatus_divbyzero();
            *((npy_int64 *)op1) = 0;
        }
        else {
            if (((in1 > 0) != (in2 > 0)) && (in1 % in2 != 0)) {
                *((npy_int64 *)op1) = in1/in2 - 1;
            }
            else {
                *((npy_int64 *)op1) = in1/in2;
            }
        }
    }
}

NPY_NO_EXPORT void
TIMEDELTA_mm_qm_divmod(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP_TWO_OUT {
        const npy_timedelta in1 = *(npy_timedelta *)ip1;
        const npy_timedelta in2 = *(npy_timedelta *)ip2;
        if (in1 == NPY_DATETIME_NAT || in2 == NPY_DATETIME_NAT) {
            npy_set_floatstatus_invalid();
            *((npy_int64 *)op1) = 0;
            *((npy_timedelta *)op2) = NPY_DATETIME_NAT;
        }
        else if (in2 == 0) {
            npy_set_floatstatus_divbyzero();
            *((npy_int64 *)op1) = 0;
            *((npy_timedelta *)op2) = NPY_DATETIME_NAT;
        }
        else {
            const npy_int64 quo = in1 / in2;
            const npy_timedelta rem = in1 % in2;
            if ((in1 > 0) == (in2 > 0) || rem == 0) {
                *((npy_int64 *)op1) = quo;
                *((npy_timedelta *)op2) = rem;
            }
            else {
                *((npy_int64 *)op1) = quo - 1;
                *((npy_timedelta *)op2) = rem + in2;
            }
        }
    }
}

/*
 *****************************************************************************
 **                             FLOAT LOOPS                                 **
 *****************************************************************************
 */

#line 1690

NPY_NO_EXPORT void
FLOAT_sqrt(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (!run_unary_simd_sqrt_FLOAT(args, dimensions, steps)) {
        UNARY_LOOP {
            const npy_float in1 = *(npy_float *)ip1;
            *(npy_float *)op1 = npy_sqrtf(in1);
        }
    }
}


#line 1690

NPY_NO_EXPORT void
DOUBLE_sqrt(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (!run_unary_simd_sqrt_DOUBLE(args, dimensions, steps)) {
        UNARY_LOOP {
            const npy_double in1 = *(npy_double *)ip1;
            *(npy_double *)op1 = npy_sqrt(in1);
        }
    }
}




#line 1714

/*
 * Pairwise summation, rounding error O(lg n) instead of O(n).
 * The recursion depth is O(lg n) as well.
 * when updating also update similar complex floats summation
 */
static npy_float
pairwise_sum_FLOAT(char *a, npy_intp n, npy_intp stride)
{
    if (n < 8) {
        npy_intp i;
        npy_float res = 0.;

        for (i = 0; i < n; i++) {
            res += (*((npy_float*)(a + i * stride)));
        }
        return res;
    }
    else if (n <= PW_BLOCKSIZE) {
        npy_intp i;
        npy_float r[8], res;

        /*
         * sum a block with 8 accumulators
         * 8 times unroll reduces blocksize to 16 and allows vectorization with
         * avx without changing summation ordering
         */
        r[0] = (*((npy_float *)(a + 0 * stride)));
        r[1] = (*((npy_float *)(a + 1 * stride)));
        r[2] = (*((npy_float *)(a + 2 * stride)));
        r[3] = (*((npy_float *)(a + 3 * stride)));
        r[4] = (*((npy_float *)(a + 4 * stride)));
        r[5] = (*((npy_float *)(a + 5 * stride)));
        r[6] = (*((npy_float *)(a + 6 * stride)));
        r[7] = (*((npy_float *)(a + 7 * stride)));

        for (i = 8; i < n - (n % 8); i += 8) {
            /* small blocksizes seems to mess with hardware prefetch */
            NPY_PREFETCH(a + (i + 512/(npy_intp)sizeof(npy_float))*stride, 0, 3);
            r[0] += (*((npy_float *)(a + (i + 0) * stride)));
            r[1] += (*((npy_float *)(a + (i + 1) * stride)));
            r[2] += (*((npy_float *)(a + (i + 2) * stride)));
            r[3] += (*((npy_float *)(a + (i + 3) * stride)));
            r[4] += (*((npy_float *)(a + (i + 4) * stride)));
            r[5] += (*((npy_float *)(a + (i + 5) * stride)));
            r[6] += (*((npy_float *)(a + (i + 6) * stride)));
            r[7] += (*((npy_float *)(a + (i + 7) * stride)));
        }

        /* accumulate now to avoid stack spills for single peel loop */
        res = ((r[0] + r[1]) + (r[2] + r[3])) +
              ((r[4] + r[5]) + (r[6] + r[7]));

        /* do non multiple of 8 rest */
        for (; i < n; i++) {
            res += (*((npy_float *)(a + i * stride)));
        }
        return res;
    }
    else {
        /* divide by two but avoid non-multiples of unroll factor */
        npy_intp n2 = n / 2;

        n2 -= n2 % 8;
        return pairwise_sum_FLOAT(a, n2, stride) +
               pairwise_sum_FLOAT(a + n2 * stride, n - n2, stride);
    }
}


#line 1714

/*
 * Pairwise summation, rounding error O(lg n) instead of O(n).
 * The recursion depth is O(lg n) as well.
 * when updating also update similar complex floats summation
 */
static npy_double
pairwise_sum_DOUBLE(char *a, npy_intp n, npy_intp stride)
{
    if (n < 8) {
        npy_intp i;
        npy_double res = 0.;

        for (i = 0; i < n; i++) {
            res += (*((npy_double*)(a + i * stride)));
        }
        return res;
    }
    else if (n <= PW_BLOCKSIZE) {
        npy_intp i;
        npy_double r[8], res;

        /*
         * sum a block with 8 accumulators
         * 8 times unroll reduces blocksize to 16 and allows vectorization with
         * avx without changing summation ordering
         */
        r[0] = (*((npy_double *)(a + 0 * stride)));
        r[1] = (*((npy_double *)(a + 1 * stride)));
        r[2] = (*((npy_double *)(a + 2 * stride)));
        r[3] = (*((npy_double *)(a + 3 * stride)));
        r[4] = (*((npy_double *)(a + 4 * stride)));
        r[5] = (*((npy_double *)(a + 5 * stride)));
        r[6] = (*((npy_double *)(a + 6 * stride)));
        r[7] = (*((npy_double *)(a + 7 * stride)));

        for (i = 8; i < n - (n % 8); i += 8) {
            /* small blocksizes seems to mess with hardware prefetch */
            NPY_PREFETCH(a + (i + 512/(npy_intp)sizeof(npy_double))*stride, 0, 3);
            r[0] += (*((npy_double *)(a + (i + 0) * stride)));
            r[1] += (*((npy_double *)(a + (i + 1) * stride)));
            r[2] += (*((npy_double *)(a + (i + 2) * stride)));
            r[3] += (*((npy_double *)(a + (i + 3) * stride)));
            r[4] += (*((npy_double *)(a + (i + 4) * stride)));
            r[5] += (*((npy_double *)(a + (i + 5) * stride)));
            r[6] += (*((npy_double *)(a + (i + 6) * stride)));
            r[7] += (*((npy_double *)(a + (i + 7) * stride)));
        }

        /* accumulate now to avoid stack spills for single peel loop */
        res = ((r[0] + r[1]) + (r[2] + r[3])) +
              ((r[4] + r[5]) + (r[6] + r[7]));

        /* do non multiple of 8 rest */
        for (; i < n; i++) {
            res += (*((npy_double *)(a + i * stride)));
        }
        return res;
    }
    else {
        /* divide by two but avoid non-multiples of unroll factor */
        npy_intp n2 = n / 2;

        n2 -= n2 % 8;
        return pairwise_sum_DOUBLE(a, n2, stride) +
               pairwise_sum_DOUBLE(a + n2 * stride, n - n2, stride);
    }
}


#line 1714

/*
 * Pairwise summation, rounding error O(lg n) instead of O(n).
 * The recursion depth is O(lg n) as well.
 * when updating also update similar complex floats summation
 */
static npy_longdouble
pairwise_sum_LONGDOUBLE(char *a, npy_intp n, npy_intp stride)
{
    if (n < 8) {
        npy_intp i;
        npy_longdouble res = 0.;

        for (i = 0; i < n; i++) {
            res += (*((npy_longdouble*)(a + i * stride)));
        }
        return res;
    }
    else if (n <= PW_BLOCKSIZE) {
        npy_intp i;
        npy_longdouble r[8], res;

        /*
         * sum a block with 8 accumulators
         * 8 times unroll reduces blocksize to 16 and allows vectorization with
         * avx without changing summation ordering
         */
        r[0] = (*((npy_longdouble *)(a + 0 * stride)));
        r[1] = (*((npy_longdouble *)(a + 1 * stride)));
        r[2] = (*((npy_longdouble *)(a + 2 * stride)));
        r[3] = (*((npy_longdouble *)(a + 3 * stride)));
        r[4] = (*((npy_longdouble *)(a + 4 * stride)));
        r[5] = (*((npy_longdouble *)(a + 5 * stride)));
        r[6] = (*((npy_longdouble *)(a + 6 * stride)));
        r[7] = (*((npy_longdouble *)(a + 7 * stride)));

        for (i = 8; i < n - (n % 8); i += 8) {
            /* small blocksizes seems to mess with hardware prefetch */
            NPY_PREFETCH(a + (i + 512/(npy_intp)sizeof(npy_longdouble))*stride, 0, 3);
            r[0] += (*((npy_longdouble *)(a + (i + 0) * stride)));
            r[1] += (*((npy_longdouble *)(a + (i + 1) * stride)));
            r[2] += (*((npy_longdouble *)(a + (i + 2) * stride)));
            r[3] += (*((npy_longdouble *)(a + (i + 3) * stride)));
            r[4] += (*((npy_longdouble *)(a + (i + 4) * stride)));
            r[5] += (*((npy_longdouble *)(a + (i + 5) * stride)));
            r[6] += (*((npy_longdouble *)(a + (i + 6) * stride)));
            r[7] += (*((npy_longdouble *)(a + (i + 7) * stride)));
        }

        /* accumulate now to avoid stack spills for single peel loop */
        res = ((r[0] + r[1]) + (r[2] + r[3])) +
              ((r[4] + r[5]) + (r[6] + r[7]));

        /* do non multiple of 8 rest */
        for (; i < n; i++) {
            res += (*((npy_longdouble *)(a + i * stride)));
        }
        return res;
    }
    else {
        /* divide by two but avoid non-multiples of unroll factor */
        npy_intp n2 = n / 2;

        n2 -= n2 % 8;
        return pairwise_sum_LONGDOUBLE(a, n2, stride) +
               pairwise_sum_LONGDOUBLE(a + n2 * stride, n - n2, stride);
    }
}


#line 1714

/*
 * Pairwise summation, rounding error O(lg n) instead of O(n).
 * The recursion depth is O(lg n) as well.
 * when updating also update similar complex floats summation
 */
static npy_float
pairwise_sum_HALF(char *a, npy_intp n, npy_intp stride)
{
    if (n < 8) {
        npy_intp i;
        npy_float res = 0.;

        for (i = 0; i < n; i++) {
            res += npy_half_to_float(*((npy_half*)(a + i * stride)));
        }
        return res;
    }
    else if (n <= PW_BLOCKSIZE) {
        npy_intp i;
        npy_float r[8], res;

        /*
         * sum a block with 8 accumulators
         * 8 times unroll reduces blocksize to 16 and allows vectorization with
         * avx without changing summation ordering
         */
        r[0] = npy_half_to_float(*((npy_half *)(a + 0 * stride)));
        r[1] = npy_half_to_float(*((npy_half *)(a + 1 * stride)));
        r[2] = npy_half_to_float(*((npy_half *)(a + 2 * stride)));
        r[3] = npy_half_to_float(*((npy_half *)(a + 3 * stride)));
        r[4] = npy_half_to_float(*((npy_half *)(a + 4 * stride)));
        r[5] = npy_half_to_float(*((npy_half *)(a + 5 * stride)));
        r[6] = npy_half_to_float(*((npy_half *)(a + 6 * stride)));
        r[7] = npy_half_to_float(*((npy_half *)(a + 7 * stride)));

        for (i = 8; i < n - (n % 8); i += 8) {
            /* small blocksizes seems to mess with hardware prefetch */
            NPY_PREFETCH(a + (i + 512/(npy_intp)sizeof(npy_half))*stride, 0, 3);
            r[0] += npy_half_to_float(*((npy_half *)(a + (i + 0) * stride)));
            r[1] += npy_half_to_float(*((npy_half *)(a + (i + 1) * stride)));
            r[2] += npy_half_to_float(*((npy_half *)(a + (i + 2) * stride)));
            r[3] += npy_half_to_float(*((npy_half *)(a + (i + 3) * stride)));
            r[4] += npy_half_to_float(*((npy_half *)(a + (i + 4) * stride)));
            r[5] += npy_half_to_float(*((npy_half *)(a + (i + 5) * stride)));
            r[6] += npy_half_to_float(*((npy_half *)(a + (i + 6) * stride)));
            r[7] += npy_half_to_float(*((npy_half *)(a + (i + 7) * stride)));
        }

        /* accumulate now to avoid stack spills for single peel loop */
        res = ((r[0] + r[1]) + (r[2] + r[3])) +
              ((r[4] + r[5]) + (r[6] + r[7]));

        /* do non multiple of 8 rest */
        for (; i < n; i++) {
            res += npy_half_to_float(*((npy_half *)(a + i * stride)));
        }
        return res;
    }
    else {
        /* divide by two but avoid non-multiples of unroll factor */
        npy_intp n2 = n / 2;

        n2 -= n2 % 8;
        return pairwise_sum_HALF(a, n2, stride) +
               pairwise_sum_HALF(a + n2 * stride, n - n2, stride);
    }
}



#line 1792

#line 1799
NPY_NO_EXPORT void
FLOAT_add(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
#if 1
        npy_float * iop1 = (npy_float *)args[0];
        npy_intp n = dimensions[0];

        *iop1 += pairwise_sum_FLOAT(args[1], n, steps[1]);
#else
        BINARY_REDUCE_LOOP(npy_float) {
            io1 += *(npy_float *)ip2;
        }
        *((npy_float *)iop1) = io1;
#endif
    }
    else if (!run_binary_simd_add_FLOAT(args, dimensions, steps)) {
        BINARY_LOOP {
            const npy_float in1 = *(npy_float *)ip1;
            const npy_float in2 = *(npy_float *)ip2;
            *((npy_float *)op1) = in1 + in2;
        }
    }
}

#line 1799
NPY_NO_EXPORT void
FLOAT_subtract(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
#if 0
        npy_float * iop1 = (npy_float *)args[0];
        npy_intp n = dimensions[0];

        *iop1 -= pairwise_sum_FLOAT(args[1], n, steps[1]);
#else
        BINARY_REDUCE_LOOP(npy_float) {
            io1 -= *(npy_float *)ip2;
        }
        *((npy_float *)iop1) = io1;
#endif
    }
    else if (!run_binary_simd_subtract_FLOAT(args, dimensions, steps)) {
        BINARY_LOOP {
            const npy_float in1 = *(npy_float *)ip1;
            const npy_float in2 = *(npy_float *)ip2;
            *((npy_float *)op1) = in1 - in2;
        }
    }
}

#line 1799
NPY_NO_EXPORT void
FLOAT_multiply(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
#if 0
        npy_float * iop1 = (npy_float *)args[0];
        npy_intp n = dimensions[0];

        *iop1 *= pairwise_sum_FLOAT(args[1], n, steps[1]);
#else
        BINARY_REDUCE_LOOP(npy_float) {
            io1 *= *(npy_float *)ip2;
        }
        *((npy_float *)iop1) = io1;
#endif
    }
    else if (!run_binary_simd_multiply_FLOAT(args, dimensions, steps)) {
        BINARY_LOOP {
            const npy_float in1 = *(npy_float *)ip1;
            const npy_float in2 = *(npy_float *)ip2;
            *((npy_float *)op1) = in1 * in2;
        }
    }
}

#line 1799
NPY_NO_EXPORT void
FLOAT_divide(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
#if 0
        npy_float * iop1 = (npy_float *)args[0];
        npy_intp n = dimensions[0];

        *iop1 /= pairwise_sum_FLOAT(args[1], n, steps[1]);
#else
        BINARY_REDUCE_LOOP(npy_float) {
            io1 /= *(npy_float *)ip2;
        }
        *((npy_float *)iop1) = io1;
#endif
    }
    else if (!run_binary_simd_divide_FLOAT(args, dimensions, steps)) {
        BINARY_LOOP {
            const npy_float in1 = *(npy_float *)ip1;
            const npy_float in2 = *(npy_float *)ip2;
            *((npy_float *)op1) = in1 / in2;
        }
    }
}


#line 1830
NPY_NO_EXPORT void
FLOAT_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (!run_binary_simd_equal_FLOAT(args, dimensions, steps)) {
        BINARY_LOOP {
            const npy_float in1 = *(npy_float *)ip1;
            const npy_float in2 = *(npy_float *)ip2;
            *((npy_bool *)op1) = in1 == in2;
        }
    }
}

#line 1830
NPY_NO_EXPORT void
FLOAT_not_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (!run_binary_simd_not_equal_FLOAT(args, dimensions, steps)) {
        BINARY_LOOP {
            const npy_float in1 = *(npy_float *)ip1;
            const npy_float in2 = *(npy_float *)ip2;
            *((npy_bool *)op1) = in1 != in2;
        }
    }
}

#line 1830
NPY_NO_EXPORT void
FLOAT_less(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (!run_binary_simd_less_FLOAT(args, dimensions, steps)) {
        BINARY_LOOP {
            const npy_float in1 = *(npy_float *)ip1;
            const npy_float in2 = *(npy_float *)ip2;
            *((npy_bool *)op1) = in1 < in2;
        }
    }
}

#line 1830
NPY_NO_EXPORT void
FLOAT_less_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (!run_binary_simd_less_equal_FLOAT(args, dimensions, steps)) {
        BINARY_LOOP {
            const npy_float in1 = *(npy_float *)ip1;
            const npy_float in2 = *(npy_float *)ip2;
            *((npy_bool *)op1) = in1 <= in2;
        }
    }
}

#line 1830
NPY_NO_EXPORT void
FLOAT_greater(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (!run_binary_simd_greater_FLOAT(args, dimensions, steps)) {
        BINARY_LOOP {
            const npy_float in1 = *(npy_float *)ip1;
            const npy_float in2 = *(npy_float *)ip2;
            *((npy_bool *)op1) = in1 > in2;
        }
    }
}

#line 1830
NPY_NO_EXPORT void
FLOAT_greater_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (!run_binary_simd_greater_equal_FLOAT(args, dimensions, steps)) {
        BINARY_LOOP {
            const npy_float in1 = *(npy_float *)ip1;
            const npy_float in2 = *(npy_float *)ip2;
            *((npy_bool *)op1) = in1 >= in2;
        }
    }
}

#line 1830
NPY_NO_EXPORT void
FLOAT_logical_and(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (!run_binary_simd_logical_and_FLOAT(args, dimensions, steps)) {
        BINARY_LOOP {
            const npy_float in1 = *(npy_float *)ip1;
            const npy_float in2 = *(npy_float *)ip2;
            *((npy_bool *)op1) = in1 && in2;
        }
    }
}

#line 1830
NPY_NO_EXPORT void
FLOAT_logical_or(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (!run_binary_simd_logical_or_FLOAT(args, dimensions, steps)) {
        BINARY_LOOP {
            const npy_float in1 = *(npy_float *)ip1;
            const npy_float in2 = *(npy_float *)ip2;
            *((npy_bool *)op1) = in1 || in2;
        }
    }
}


NPY_NO_EXPORT void
FLOAT_logical_xor(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const int t1 = !!*(npy_float *)ip1;
        const int t2 = !!*(npy_float *)ip2;
        *((npy_bool *)op1) = (t1 != t2);
    }
}

NPY_NO_EXPORT void
FLOAT_logical_not(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_float in1 = *(npy_float *)ip1;
        *((npy_bool *)op1) = !in1;
    }
}

#line 1866
NPY_NO_EXPORT void
FLOAT_isnan(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (!run_isnan_simd_FLOAT(args, dimensions, steps)) {
        UNARY_LOOP {
            const npy_float in1 = *(npy_float *)ip1;
            *((npy_bool *)op1) = npy_isnan(in1) != 0;
        }
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

#line 1866
NPY_NO_EXPORT void
FLOAT_isinf(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (!run_isinf_simd_FLOAT(args, dimensions, steps)) {
        UNARY_LOOP {
            const npy_float in1 = *(npy_float *)ip1;
            *((npy_bool *)op1) = npy_isinf(in1) != 0;
        }
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

#line 1866
NPY_NO_EXPORT void
FLOAT_isfinite(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (!run_isfinite_simd_FLOAT(args, dimensions, steps)) {
        UNARY_LOOP {
            const npy_float in1 = *(npy_float *)ip1;
            *((npy_bool *)op1) = npy_isfinite(in1) != 0;
        }
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

#line 1866
NPY_NO_EXPORT void
FLOAT_signbit(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (!run_signbit_simd_FLOAT(args, dimensions, steps)) {
        UNARY_LOOP {
            const npy_float in1 = *(npy_float *)ip1;
            *((npy_bool *)op1) = npy_signbit(in1) != 0;
        }
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}


NPY_NO_EXPORT void
FLOAT_spacing(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_float in1 = *(npy_float *)ip1;
        *((npy_float *)op1) = npy_spacingf(in1);
    }
}

NPY_NO_EXPORT void
FLOAT_copysign(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_float in1 = *(npy_float *)ip1;
        const npy_float in2 = *(npy_float *)ip2;
        *((npy_float *)op1)= npy_copysignf(in1, in2);
    }
}

NPY_NO_EXPORT void
FLOAT_nextafter(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_float in1 = *(npy_float *)ip1;
        const npy_float in2 = *(npy_float *)ip2;
        *((npy_float *)op1)= npy_nextafterf(in1, in2);
    }
}

#line 1912
NPY_NO_EXPORT void
FLOAT_maximum(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*  */
    if (IS_BINARY_REDUCE) {
        if (!run_unary_reduce_simd_maximum_FLOAT(args, dimensions, steps)) {
            BINARY_REDUCE_LOOP(npy_float) {
                const npy_float in2 = *(npy_float *)ip2;
                /* Order of operations important for MSVC 2015 */
                io1 = (io1 >= in2 || npy_isnan(io1)) ? io1 : in2;
            }
            *((npy_float *)iop1) = io1;
        }
    }
    else {
        BINARY_LOOP {
            npy_float in1 = *(npy_float *)ip1;
            const npy_float in2 = *(npy_float *)ip2;
            /* Order of operations important for MSVC 2015 */
            in1 = (in1 >= in2 || npy_isnan(in1)) ? in1 : in2;
            *((npy_float *)op1) = in1;
        }
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

#line 1912
NPY_NO_EXPORT void
FLOAT_minimum(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*  */
    if (IS_BINARY_REDUCE) {
        if (!run_unary_reduce_simd_minimum_FLOAT(args, dimensions, steps)) {
            BINARY_REDUCE_LOOP(npy_float) {
                const npy_float in2 = *(npy_float *)ip2;
                /* Order of operations important for MSVC 2015 */
                io1 = (io1 <= in2 || npy_isnan(io1)) ? io1 : in2;
            }
            *((npy_float *)iop1) = io1;
        }
    }
    else {
        BINARY_LOOP {
            npy_float in1 = *(npy_float *)ip1;
            const npy_float in2 = *(npy_float *)ip2;
            /* Order of operations important for MSVC 2015 */
            in1 = (in1 <= in2 || npy_isnan(in1)) ? in1 : in2;
            *((npy_float *)op1) = in1;
        }
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}


#line 1943
NPY_NO_EXPORT void
FLOAT_fmax(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*  */
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_float) {
            const npy_float in2 = *(npy_float *)ip2;
            /* Order of operations important for MSVC 2015 */
            io1 = (io1 >= in2 || npy_isnan(in2)) ? io1 : in2;
        }
        *((npy_float *)iop1) = io1;
    }
    else {
        BINARY_LOOP {
            const npy_float in1 = *(npy_float *)ip1;
            const npy_float in2 = *(npy_float *)ip2;
            /* Order of operations important for MSVC 2015 */
            *((npy_float *)op1) = (in1 >= in2 || npy_isnan(in2)) ? in1 : in2;
        }
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

#line 1943
NPY_NO_EXPORT void
FLOAT_fmin(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*  */
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_float) {
            const npy_float in2 = *(npy_float *)ip2;
            /* Order of operations important for MSVC 2015 */
            io1 = (io1 <= in2 || npy_isnan(in2)) ? io1 : in2;
        }
        *((npy_float *)iop1) = io1;
    }
    else {
        BINARY_LOOP {
            const npy_float in1 = *(npy_float *)ip1;
            const npy_float in2 = *(npy_float *)ip2;
            /* Order of operations important for MSVC 2015 */
            *((npy_float *)op1) = (in1 <= in2 || npy_isnan(in2)) ? in1 : in2;
        }
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}


NPY_NO_EXPORT void
FLOAT_floor_divide(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_float in1 = *(npy_float *)ip1;
        const npy_float in2 = *(npy_float *)ip2;
        npy_float mod;
        *((npy_float *)op1) = npy_divmodf(in1, in2, &mod);
    }
}

NPY_NO_EXPORT void
FLOAT_remainder(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_float in1 = *(npy_float *)ip1;
        const npy_float in2 = *(npy_float *)ip2;
        npy_divmodf(in1, in2, (npy_float *)op1);
    }
}

NPY_NO_EXPORT void
FLOAT_divmod(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP_TWO_OUT {
        const npy_float in1 = *(npy_float *)ip1;
        const npy_float in2 = *(npy_float *)ip2;
        *((npy_float *)op1) = npy_divmodf(in1, in2, (npy_float *)op2);
    }
}

NPY_NO_EXPORT void
FLOAT_square(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    char * margs[] = {args[0], args[0], args[1]};
    npy_intp msteps[] = {steps[0], steps[0], steps[1]};
    if (!run_binary_simd_multiply_FLOAT(margs, dimensions, msteps)) {
        UNARY_LOOP {
            const npy_float in1 = *(npy_float *)ip1;
            *((npy_float *)op1) = in1*in1;
        }
    }
}

NPY_NO_EXPORT void
FLOAT_reciprocal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    npy_float one = 1.f;
    char * margs[] = {(char*)&one, args[0], args[1]};
    npy_intp msteps[] = {0, steps[0], steps[1]};
    if (!run_binary_simd_divide_FLOAT(margs, dimensions, msteps)) {
        UNARY_LOOP {
            const npy_float in1 = *(npy_float *)ip1;
            *((npy_float *)op1) = 1/in1;
        }
    }
}

NPY_NO_EXPORT void
FLOAT__ones_like(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    OUTPUT_LOOP {
        *((npy_float *)op1) = 1;
    }
}

NPY_NO_EXPORT void
FLOAT_conjugate(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_float in1 = *(npy_float *)ip1;
        *((npy_float *)op1) = in1;
    }
}

NPY_NO_EXPORT void
FLOAT_absolute(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (!run_unary_simd_absolute_FLOAT(args, dimensions, steps)) {
        UNARY_LOOP {
            const npy_float in1 = *(npy_float *)ip1;
            const npy_float tmp = in1 > 0 ? in1 : -in1;
            /* add 0 to clear -0.0 */
            *((npy_float *)op1) = tmp + 0;
        }
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

NPY_NO_EXPORT void
FLOAT_negative(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (!run_unary_simd_negative_FLOAT(args, dimensions, steps)) {
        UNARY_LOOP {
            const npy_float in1 = *(npy_float *)ip1;
            *((npy_float *)op1) = -in1;
        }
    }
}

NPY_NO_EXPORT void
FLOAT_positive(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_float in1 = *(npy_float *)ip1;
        *((npy_float *)op1) = +in1;
    }
}

NPY_NO_EXPORT void
FLOAT_sign(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /* Sign of nan is nan */
    UNARY_LOOP {
        const npy_float in1 = *(npy_float *)ip1;
        *((npy_float *)op1) = in1 > 0 ? 1 : (in1 < 0 ? -1 : (in1 == 0 ? 0 : in1));
    }
}

NPY_NO_EXPORT void
FLOAT_modf(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_TWO_OUT {
        const npy_float in1 = *(npy_float *)ip1;
        *((npy_float *)op1) = npy_modff(in1, (npy_float *)op2);
    }
}

NPY_NO_EXPORT void
FLOAT_frexp(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_TWO_OUT {
        const npy_float in1 = *(npy_float *)ip1;
        *((npy_float *)op1) = npy_frexpf(in1, (int *)op2);
    }
}

NPY_NO_EXPORT void
FLOAT_ldexp(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_float in1 = *(npy_float *)ip1;
        const int in2 = *(int *)ip2;
        *((npy_float *)op1) = npy_ldexpf(in1, in2);
    }
}

NPY_NO_EXPORT void
FLOAT_ldexp_long(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * Additional loop to handle npy_long integer inputs (cf. #866, #1633).
     * npy_long != npy_int on many 64-bit platforms, so we need this second loop
     * to handle the default integer type.
     */
    BINARY_LOOP {
        const npy_float in1 = *(npy_float *)ip1;
        const long in2 = *(long *)ip2;
        if (((int)in2) == in2) {
            /* Range OK */
            *((npy_float *)op1) = npy_ldexpf(in1, ((int)in2));
        }
        else {
            /*
             * Outside npy_int range -- also ldexp will overflow in this case,
             * given that exponent has less bits than npy_int.
             */
            if (in2 > 0) {
                *((npy_float *)op1) = npy_ldexpf(in1, NPY_MAX_INT);
            }
            else {
                *((npy_float *)op1) = npy_ldexpf(in1, NPY_MIN_INT);
            }
        }
    }
}

#define FLOAT_true_divide FLOAT_divide


#line 1792

#line 1799
NPY_NO_EXPORT void
DOUBLE_add(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
#if 1
        npy_double * iop1 = (npy_double *)args[0];
        npy_intp n = dimensions[0];

        *iop1 += pairwise_sum_DOUBLE(args[1], n, steps[1]);
#else
        BINARY_REDUCE_LOOP(npy_double) {
            io1 += *(npy_double *)ip2;
        }
        *((npy_double *)iop1) = io1;
#endif
    }
    else if (!run_binary_simd_add_DOUBLE(args, dimensions, steps)) {
        BINARY_LOOP {
            const npy_double in1 = *(npy_double *)ip1;
            const npy_double in2 = *(npy_double *)ip2;
            *((npy_double *)op1) = in1 + in2;
        }
    }
}

#line 1799
NPY_NO_EXPORT void
DOUBLE_subtract(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
#if 0
        npy_double * iop1 = (npy_double *)args[0];
        npy_intp n = dimensions[0];

        *iop1 -= pairwise_sum_DOUBLE(args[1], n, steps[1]);
#else
        BINARY_REDUCE_LOOP(npy_double) {
            io1 -= *(npy_double *)ip2;
        }
        *((npy_double *)iop1) = io1;
#endif
    }
    else if (!run_binary_simd_subtract_DOUBLE(args, dimensions, steps)) {
        BINARY_LOOP {
            const npy_double in1 = *(npy_double *)ip1;
            const npy_double in2 = *(npy_double *)ip2;
            *((npy_double *)op1) = in1 - in2;
        }
    }
}

#line 1799
NPY_NO_EXPORT void
DOUBLE_multiply(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
#if 0
        npy_double * iop1 = (npy_double *)args[0];
        npy_intp n = dimensions[0];

        *iop1 *= pairwise_sum_DOUBLE(args[1], n, steps[1]);
#else
        BINARY_REDUCE_LOOP(npy_double) {
            io1 *= *(npy_double *)ip2;
        }
        *((npy_double *)iop1) = io1;
#endif
    }
    else if (!run_binary_simd_multiply_DOUBLE(args, dimensions, steps)) {
        BINARY_LOOP {
            const npy_double in1 = *(npy_double *)ip1;
            const npy_double in2 = *(npy_double *)ip2;
            *((npy_double *)op1) = in1 * in2;
        }
    }
}

#line 1799
NPY_NO_EXPORT void
DOUBLE_divide(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
#if 0
        npy_double * iop1 = (npy_double *)args[0];
        npy_intp n = dimensions[0];

        *iop1 /= pairwise_sum_DOUBLE(args[1], n, steps[1]);
#else
        BINARY_REDUCE_LOOP(npy_double) {
            io1 /= *(npy_double *)ip2;
        }
        *((npy_double *)iop1) = io1;
#endif
    }
    else if (!run_binary_simd_divide_DOUBLE(args, dimensions, steps)) {
        BINARY_LOOP {
            const npy_double in1 = *(npy_double *)ip1;
            const npy_double in2 = *(npy_double *)ip2;
            *((npy_double *)op1) = in1 / in2;
        }
    }
}


#line 1830
NPY_NO_EXPORT void
DOUBLE_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (!run_binary_simd_equal_DOUBLE(args, dimensions, steps)) {
        BINARY_LOOP {
            const npy_double in1 = *(npy_double *)ip1;
            const npy_double in2 = *(npy_double *)ip2;
            *((npy_bool *)op1) = in1 == in2;
        }
    }
}

#line 1830
NPY_NO_EXPORT void
DOUBLE_not_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (!run_binary_simd_not_equal_DOUBLE(args, dimensions, steps)) {
        BINARY_LOOP {
            const npy_double in1 = *(npy_double *)ip1;
            const npy_double in2 = *(npy_double *)ip2;
            *((npy_bool *)op1) = in1 != in2;
        }
    }
}

#line 1830
NPY_NO_EXPORT void
DOUBLE_less(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (!run_binary_simd_less_DOUBLE(args, dimensions, steps)) {
        BINARY_LOOP {
            const npy_double in1 = *(npy_double *)ip1;
            const npy_double in2 = *(npy_double *)ip2;
            *((npy_bool *)op1) = in1 < in2;
        }
    }
}

#line 1830
NPY_NO_EXPORT void
DOUBLE_less_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (!run_binary_simd_less_equal_DOUBLE(args, dimensions, steps)) {
        BINARY_LOOP {
            const npy_double in1 = *(npy_double *)ip1;
            const npy_double in2 = *(npy_double *)ip2;
            *((npy_bool *)op1) = in1 <= in2;
        }
    }
}

#line 1830
NPY_NO_EXPORT void
DOUBLE_greater(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (!run_binary_simd_greater_DOUBLE(args, dimensions, steps)) {
        BINARY_LOOP {
            const npy_double in1 = *(npy_double *)ip1;
            const npy_double in2 = *(npy_double *)ip2;
            *((npy_bool *)op1) = in1 > in2;
        }
    }
}

#line 1830
NPY_NO_EXPORT void
DOUBLE_greater_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (!run_binary_simd_greater_equal_DOUBLE(args, dimensions, steps)) {
        BINARY_LOOP {
            const npy_double in1 = *(npy_double *)ip1;
            const npy_double in2 = *(npy_double *)ip2;
            *((npy_bool *)op1) = in1 >= in2;
        }
    }
}

#line 1830
NPY_NO_EXPORT void
DOUBLE_logical_and(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (!run_binary_simd_logical_and_DOUBLE(args, dimensions, steps)) {
        BINARY_LOOP {
            const npy_double in1 = *(npy_double *)ip1;
            const npy_double in2 = *(npy_double *)ip2;
            *((npy_bool *)op1) = in1 && in2;
        }
    }
}

#line 1830
NPY_NO_EXPORT void
DOUBLE_logical_or(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (!run_binary_simd_logical_or_DOUBLE(args, dimensions, steps)) {
        BINARY_LOOP {
            const npy_double in1 = *(npy_double *)ip1;
            const npy_double in2 = *(npy_double *)ip2;
            *((npy_bool *)op1) = in1 || in2;
        }
    }
}


NPY_NO_EXPORT void
DOUBLE_logical_xor(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const int t1 = !!*(npy_double *)ip1;
        const int t2 = !!*(npy_double *)ip2;
        *((npy_bool *)op1) = (t1 != t2);
    }
}

NPY_NO_EXPORT void
DOUBLE_logical_not(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_double in1 = *(npy_double *)ip1;
        *((npy_bool *)op1) = !in1;
    }
}

#line 1866
NPY_NO_EXPORT void
DOUBLE_isnan(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (!run_isnan_simd_DOUBLE(args, dimensions, steps)) {
        UNARY_LOOP {
            const npy_double in1 = *(npy_double *)ip1;
            *((npy_bool *)op1) = npy_isnan(in1) != 0;
        }
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

#line 1866
NPY_NO_EXPORT void
DOUBLE_isinf(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (!run_isinf_simd_DOUBLE(args, dimensions, steps)) {
        UNARY_LOOP {
            const npy_double in1 = *(npy_double *)ip1;
            *((npy_bool *)op1) = npy_isinf(in1) != 0;
        }
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

#line 1866
NPY_NO_EXPORT void
DOUBLE_isfinite(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (!run_isfinite_simd_DOUBLE(args, dimensions, steps)) {
        UNARY_LOOP {
            const npy_double in1 = *(npy_double *)ip1;
            *((npy_bool *)op1) = npy_isfinite(in1) != 0;
        }
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

#line 1866
NPY_NO_EXPORT void
DOUBLE_signbit(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (!run_signbit_simd_DOUBLE(args, dimensions, steps)) {
        UNARY_LOOP {
            const npy_double in1 = *(npy_double *)ip1;
            *((npy_bool *)op1) = npy_signbit(in1) != 0;
        }
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}


NPY_NO_EXPORT void
DOUBLE_spacing(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_double in1 = *(npy_double *)ip1;
        *((npy_double *)op1) = npy_spacing(in1);
    }
}

NPY_NO_EXPORT void
DOUBLE_copysign(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_double in1 = *(npy_double *)ip1;
        const npy_double in2 = *(npy_double *)ip2;
        *((npy_double *)op1)= npy_copysign(in1, in2);
    }
}

NPY_NO_EXPORT void
DOUBLE_nextafter(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_double in1 = *(npy_double *)ip1;
        const npy_double in2 = *(npy_double *)ip2;
        *((npy_double *)op1)= npy_nextafter(in1, in2);
    }
}

#line 1912
NPY_NO_EXPORT void
DOUBLE_maximum(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*  */
    if (IS_BINARY_REDUCE) {
        if (!run_unary_reduce_simd_maximum_DOUBLE(args, dimensions, steps)) {
            BINARY_REDUCE_LOOP(npy_double) {
                const npy_double in2 = *(npy_double *)ip2;
                /* Order of operations important for MSVC 2015 */
                io1 = (io1 >= in2 || npy_isnan(io1)) ? io1 : in2;
            }
            *((npy_double *)iop1) = io1;
        }
    }
    else {
        BINARY_LOOP {
            npy_double in1 = *(npy_double *)ip1;
            const npy_double in2 = *(npy_double *)ip2;
            /* Order of operations important for MSVC 2015 */
            in1 = (in1 >= in2 || npy_isnan(in1)) ? in1 : in2;
            *((npy_double *)op1) = in1;
        }
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

#line 1912
NPY_NO_EXPORT void
DOUBLE_minimum(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*  */
    if (IS_BINARY_REDUCE) {
        if (!run_unary_reduce_simd_minimum_DOUBLE(args, dimensions, steps)) {
            BINARY_REDUCE_LOOP(npy_double) {
                const npy_double in2 = *(npy_double *)ip2;
                /* Order of operations important for MSVC 2015 */
                io1 = (io1 <= in2 || npy_isnan(io1)) ? io1 : in2;
            }
            *((npy_double *)iop1) = io1;
        }
    }
    else {
        BINARY_LOOP {
            npy_double in1 = *(npy_double *)ip1;
            const npy_double in2 = *(npy_double *)ip2;
            /* Order of operations important for MSVC 2015 */
            in1 = (in1 <= in2 || npy_isnan(in1)) ? in1 : in2;
            *((npy_double *)op1) = in1;
        }
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}


#line 1943
NPY_NO_EXPORT void
DOUBLE_fmax(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*  */
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_double) {
            const npy_double in2 = *(npy_double *)ip2;
            /* Order of operations important for MSVC 2015 */
            io1 = (io1 >= in2 || npy_isnan(in2)) ? io1 : in2;
        }
        *((npy_double *)iop1) = io1;
    }
    else {
        BINARY_LOOP {
            const npy_double in1 = *(npy_double *)ip1;
            const npy_double in2 = *(npy_double *)ip2;
            /* Order of operations important for MSVC 2015 */
            *((npy_double *)op1) = (in1 >= in2 || npy_isnan(in2)) ? in1 : in2;
        }
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

#line 1943
NPY_NO_EXPORT void
DOUBLE_fmin(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*  */
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_double) {
            const npy_double in2 = *(npy_double *)ip2;
            /* Order of operations important for MSVC 2015 */
            io1 = (io1 <= in2 || npy_isnan(in2)) ? io1 : in2;
        }
        *((npy_double *)iop1) = io1;
    }
    else {
        BINARY_LOOP {
            const npy_double in1 = *(npy_double *)ip1;
            const npy_double in2 = *(npy_double *)ip2;
            /* Order of operations important for MSVC 2015 */
            *((npy_double *)op1) = (in1 <= in2 || npy_isnan(in2)) ? in1 : in2;
        }
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}


NPY_NO_EXPORT void
DOUBLE_floor_divide(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_double in1 = *(npy_double *)ip1;
        const npy_double in2 = *(npy_double *)ip2;
        npy_double mod;
        *((npy_double *)op1) = npy_divmod(in1, in2, &mod);
    }
}

NPY_NO_EXPORT void
DOUBLE_remainder(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_double in1 = *(npy_double *)ip1;
        const npy_double in2 = *(npy_double *)ip2;
        npy_divmod(in1, in2, (npy_double *)op1);
    }
}

NPY_NO_EXPORT void
DOUBLE_divmod(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP_TWO_OUT {
        const npy_double in1 = *(npy_double *)ip1;
        const npy_double in2 = *(npy_double *)ip2;
        *((npy_double *)op1) = npy_divmod(in1, in2, (npy_double *)op2);
    }
}

NPY_NO_EXPORT void
DOUBLE_square(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    char * margs[] = {args[0], args[0], args[1]};
    npy_intp msteps[] = {steps[0], steps[0], steps[1]};
    if (!run_binary_simd_multiply_DOUBLE(margs, dimensions, msteps)) {
        UNARY_LOOP {
            const npy_double in1 = *(npy_double *)ip1;
            *((npy_double *)op1) = in1*in1;
        }
    }
}

NPY_NO_EXPORT void
DOUBLE_reciprocal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    npy_double one = 1.;
    char * margs[] = {(char*)&one, args[0], args[1]};
    npy_intp msteps[] = {0, steps[0], steps[1]};
    if (!run_binary_simd_divide_DOUBLE(margs, dimensions, msteps)) {
        UNARY_LOOP {
            const npy_double in1 = *(npy_double *)ip1;
            *((npy_double *)op1) = 1/in1;
        }
    }
}

NPY_NO_EXPORT void
DOUBLE__ones_like(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    OUTPUT_LOOP {
        *((npy_double *)op1) = 1;
    }
}

NPY_NO_EXPORT void
DOUBLE_conjugate(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_double in1 = *(npy_double *)ip1;
        *((npy_double *)op1) = in1;
    }
}

NPY_NO_EXPORT void
DOUBLE_absolute(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (!run_unary_simd_absolute_DOUBLE(args, dimensions, steps)) {
        UNARY_LOOP {
            const npy_double in1 = *(npy_double *)ip1;
            const npy_double tmp = in1 > 0 ? in1 : -in1;
            /* add 0 to clear -0.0 */
            *((npy_double *)op1) = tmp + 0;
        }
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

NPY_NO_EXPORT void
DOUBLE_negative(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (!run_unary_simd_negative_DOUBLE(args, dimensions, steps)) {
        UNARY_LOOP {
            const npy_double in1 = *(npy_double *)ip1;
            *((npy_double *)op1) = -in1;
        }
    }
}

NPY_NO_EXPORT void
DOUBLE_positive(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_double in1 = *(npy_double *)ip1;
        *((npy_double *)op1) = +in1;
    }
}

NPY_NO_EXPORT void
DOUBLE_sign(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /* Sign of nan is nan */
    UNARY_LOOP {
        const npy_double in1 = *(npy_double *)ip1;
        *((npy_double *)op1) = in1 > 0 ? 1 : (in1 < 0 ? -1 : (in1 == 0 ? 0 : in1));
    }
}

NPY_NO_EXPORT void
DOUBLE_modf(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_TWO_OUT {
        const npy_double in1 = *(npy_double *)ip1;
        *((npy_double *)op1) = npy_modf(in1, (npy_double *)op2);
    }
}

NPY_NO_EXPORT void
DOUBLE_frexp(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_TWO_OUT {
        const npy_double in1 = *(npy_double *)ip1;
        *((npy_double *)op1) = npy_frexp(in1, (int *)op2);
    }
}

NPY_NO_EXPORT void
DOUBLE_ldexp(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_double in1 = *(npy_double *)ip1;
        const int in2 = *(int *)ip2;
        *((npy_double *)op1) = npy_ldexp(in1, in2);
    }
}

NPY_NO_EXPORT void
DOUBLE_ldexp_long(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * Additional loop to handle npy_long integer inputs (cf. #866, #1633).
     * npy_long != npy_int on many 64-bit platforms, so we need this second loop
     * to handle the default integer type.
     */
    BINARY_LOOP {
        const npy_double in1 = *(npy_double *)ip1;
        const long in2 = *(long *)ip2;
        if (((int)in2) == in2) {
            /* Range OK */
            *((npy_double *)op1) = npy_ldexp(in1, ((int)in2));
        }
        else {
            /*
             * Outside npy_int range -- also ldexp will overflow in this case,
             * given that exponent has less bits than npy_int.
             */
            if (in2 > 0) {
                *((npy_double *)op1) = npy_ldexp(in1, NPY_MAX_INT);
            }
            else {
                *((npy_double *)op1) = npy_ldexp(in1, NPY_MIN_INT);
            }
        }
    }
}

#define DOUBLE_true_divide DOUBLE_divide


#line 1792

#line 1799
NPY_NO_EXPORT void
LONGDOUBLE_add(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
#if 1
        npy_longdouble * iop1 = (npy_longdouble *)args[0];
        npy_intp n = dimensions[0];

        *iop1 += pairwise_sum_LONGDOUBLE(args[1], n, steps[1]);
#else
        BINARY_REDUCE_LOOP(npy_longdouble) {
            io1 += *(npy_longdouble *)ip2;
        }
        *((npy_longdouble *)iop1) = io1;
#endif
    }
    else if (!run_binary_simd_add_LONGDOUBLE(args, dimensions, steps)) {
        BINARY_LOOP {
            const npy_longdouble in1 = *(npy_longdouble *)ip1;
            const npy_longdouble in2 = *(npy_longdouble *)ip2;
            *((npy_longdouble *)op1) = in1 + in2;
        }
    }
}

#line 1799
NPY_NO_EXPORT void
LONGDOUBLE_subtract(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
#if 0
        npy_longdouble * iop1 = (npy_longdouble *)args[0];
        npy_intp n = dimensions[0];

        *iop1 -= pairwise_sum_LONGDOUBLE(args[1], n, steps[1]);
#else
        BINARY_REDUCE_LOOP(npy_longdouble) {
            io1 -= *(npy_longdouble *)ip2;
        }
        *((npy_longdouble *)iop1) = io1;
#endif
    }
    else if (!run_binary_simd_subtract_LONGDOUBLE(args, dimensions, steps)) {
        BINARY_LOOP {
            const npy_longdouble in1 = *(npy_longdouble *)ip1;
            const npy_longdouble in2 = *(npy_longdouble *)ip2;
            *((npy_longdouble *)op1) = in1 - in2;
        }
    }
}

#line 1799
NPY_NO_EXPORT void
LONGDOUBLE_multiply(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
#if 0
        npy_longdouble * iop1 = (npy_longdouble *)args[0];
        npy_intp n = dimensions[0];

        *iop1 *= pairwise_sum_LONGDOUBLE(args[1], n, steps[1]);
#else
        BINARY_REDUCE_LOOP(npy_longdouble) {
            io1 *= *(npy_longdouble *)ip2;
        }
        *((npy_longdouble *)iop1) = io1;
#endif
    }
    else if (!run_binary_simd_multiply_LONGDOUBLE(args, dimensions, steps)) {
        BINARY_LOOP {
            const npy_longdouble in1 = *(npy_longdouble *)ip1;
            const npy_longdouble in2 = *(npy_longdouble *)ip2;
            *((npy_longdouble *)op1) = in1 * in2;
        }
    }
}

#line 1799
NPY_NO_EXPORT void
LONGDOUBLE_divide(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
#if 0
        npy_longdouble * iop1 = (npy_longdouble *)args[0];
        npy_intp n = dimensions[0];

        *iop1 /= pairwise_sum_LONGDOUBLE(args[1], n, steps[1]);
#else
        BINARY_REDUCE_LOOP(npy_longdouble) {
            io1 /= *(npy_longdouble *)ip2;
        }
        *((npy_longdouble *)iop1) = io1;
#endif
    }
    else if (!run_binary_simd_divide_LONGDOUBLE(args, dimensions, steps)) {
        BINARY_LOOP {
            const npy_longdouble in1 = *(npy_longdouble *)ip1;
            const npy_longdouble in2 = *(npy_longdouble *)ip2;
            *((npy_longdouble *)op1) = in1 / in2;
        }
    }
}


#line 1830
NPY_NO_EXPORT void
LONGDOUBLE_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (!run_binary_simd_equal_LONGDOUBLE(args, dimensions, steps)) {
        BINARY_LOOP {
            const npy_longdouble in1 = *(npy_longdouble *)ip1;
            const npy_longdouble in2 = *(npy_longdouble *)ip2;
            *((npy_bool *)op1) = in1 == in2;
        }
    }
}

#line 1830
NPY_NO_EXPORT void
LONGDOUBLE_not_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (!run_binary_simd_not_equal_LONGDOUBLE(args, dimensions, steps)) {
        BINARY_LOOP {
            const npy_longdouble in1 = *(npy_longdouble *)ip1;
            const npy_longdouble in2 = *(npy_longdouble *)ip2;
            *((npy_bool *)op1) = in1 != in2;
        }
    }
}

#line 1830
NPY_NO_EXPORT void
LONGDOUBLE_less(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (!run_binary_simd_less_LONGDOUBLE(args, dimensions, steps)) {
        BINARY_LOOP {
            const npy_longdouble in1 = *(npy_longdouble *)ip1;
            const npy_longdouble in2 = *(npy_longdouble *)ip2;
            *((npy_bool *)op1) = in1 < in2;
        }
    }
}

#line 1830
NPY_NO_EXPORT void
LONGDOUBLE_less_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (!run_binary_simd_less_equal_LONGDOUBLE(args, dimensions, steps)) {
        BINARY_LOOP {
            const npy_longdouble in1 = *(npy_longdouble *)ip1;
            const npy_longdouble in2 = *(npy_longdouble *)ip2;
            *((npy_bool *)op1) = in1 <= in2;
        }
    }
}

#line 1830
NPY_NO_EXPORT void
LONGDOUBLE_greater(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (!run_binary_simd_greater_LONGDOUBLE(args, dimensions, steps)) {
        BINARY_LOOP {
            const npy_longdouble in1 = *(npy_longdouble *)ip1;
            const npy_longdouble in2 = *(npy_longdouble *)ip2;
            *((npy_bool *)op1) = in1 > in2;
        }
    }
}

#line 1830
NPY_NO_EXPORT void
LONGDOUBLE_greater_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (!run_binary_simd_greater_equal_LONGDOUBLE(args, dimensions, steps)) {
        BINARY_LOOP {
            const npy_longdouble in1 = *(npy_longdouble *)ip1;
            const npy_longdouble in2 = *(npy_longdouble *)ip2;
            *((npy_bool *)op1) = in1 >= in2;
        }
    }
}

#line 1830
NPY_NO_EXPORT void
LONGDOUBLE_logical_and(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (!run_binary_simd_logical_and_LONGDOUBLE(args, dimensions, steps)) {
        BINARY_LOOP {
            const npy_longdouble in1 = *(npy_longdouble *)ip1;
            const npy_longdouble in2 = *(npy_longdouble *)ip2;
            *((npy_bool *)op1) = in1 && in2;
        }
    }
}

#line 1830
NPY_NO_EXPORT void
LONGDOUBLE_logical_or(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (!run_binary_simd_logical_or_LONGDOUBLE(args, dimensions, steps)) {
        BINARY_LOOP {
            const npy_longdouble in1 = *(npy_longdouble *)ip1;
            const npy_longdouble in2 = *(npy_longdouble *)ip2;
            *((npy_bool *)op1) = in1 || in2;
        }
    }
}


NPY_NO_EXPORT void
LONGDOUBLE_logical_xor(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const int t1 = !!*(npy_longdouble *)ip1;
        const int t2 = !!*(npy_longdouble *)ip2;
        *((npy_bool *)op1) = (t1 != t2);
    }
}

NPY_NO_EXPORT void
LONGDOUBLE_logical_not(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_longdouble in1 = *(npy_longdouble *)ip1;
        *((npy_bool *)op1) = !in1;
    }
}

#line 1866
NPY_NO_EXPORT void
LONGDOUBLE_isnan(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (!run_isnan_simd_LONGDOUBLE(args, dimensions, steps)) {
        UNARY_LOOP {
            const npy_longdouble in1 = *(npy_longdouble *)ip1;
            *((npy_bool *)op1) = npy_isnan(in1) != 0;
        }
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

#line 1866
NPY_NO_EXPORT void
LONGDOUBLE_isinf(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (!run_isinf_simd_LONGDOUBLE(args, dimensions, steps)) {
        UNARY_LOOP {
            const npy_longdouble in1 = *(npy_longdouble *)ip1;
            *((npy_bool *)op1) = npy_isinf(in1) != 0;
        }
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

#line 1866
NPY_NO_EXPORT void
LONGDOUBLE_isfinite(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (!run_isfinite_simd_LONGDOUBLE(args, dimensions, steps)) {
        UNARY_LOOP {
            const npy_longdouble in1 = *(npy_longdouble *)ip1;
            *((npy_bool *)op1) = npy_isfinite(in1) != 0;
        }
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

#line 1866
NPY_NO_EXPORT void
LONGDOUBLE_signbit(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (!run_signbit_simd_LONGDOUBLE(args, dimensions, steps)) {
        UNARY_LOOP {
            const npy_longdouble in1 = *(npy_longdouble *)ip1;
            *((npy_bool *)op1) = npy_signbit(in1) != 0;
        }
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}


NPY_NO_EXPORT void
LONGDOUBLE_spacing(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_longdouble in1 = *(npy_longdouble *)ip1;
        *((npy_longdouble *)op1) = npy_spacingl(in1);
    }
}

NPY_NO_EXPORT void
LONGDOUBLE_copysign(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_longdouble in1 = *(npy_longdouble *)ip1;
        const npy_longdouble in2 = *(npy_longdouble *)ip2;
        *((npy_longdouble *)op1)= npy_copysignl(in1, in2);
    }
}

NPY_NO_EXPORT void
LONGDOUBLE_nextafter(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_longdouble in1 = *(npy_longdouble *)ip1;
        const npy_longdouble in2 = *(npy_longdouble *)ip2;
        *((npy_longdouble *)op1)= npy_nextafterl(in1, in2);
    }
}

#line 1912
NPY_NO_EXPORT void
LONGDOUBLE_maximum(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*  */
    if (IS_BINARY_REDUCE) {
        if (!run_unary_reduce_simd_maximum_LONGDOUBLE(args, dimensions, steps)) {
            BINARY_REDUCE_LOOP(npy_longdouble) {
                const npy_longdouble in2 = *(npy_longdouble *)ip2;
                /* Order of operations important for MSVC 2015 */
                io1 = (io1 >= in2 || npy_isnan(io1)) ? io1 : in2;
            }
            *((npy_longdouble *)iop1) = io1;
        }
    }
    else {
        BINARY_LOOP {
            npy_longdouble in1 = *(npy_longdouble *)ip1;
            const npy_longdouble in2 = *(npy_longdouble *)ip2;
            /* Order of operations important for MSVC 2015 */
            in1 = (in1 >= in2 || npy_isnan(in1)) ? in1 : in2;
            *((npy_longdouble *)op1) = in1;
        }
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

#line 1912
NPY_NO_EXPORT void
LONGDOUBLE_minimum(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*  */
    if (IS_BINARY_REDUCE) {
        if (!run_unary_reduce_simd_minimum_LONGDOUBLE(args, dimensions, steps)) {
            BINARY_REDUCE_LOOP(npy_longdouble) {
                const npy_longdouble in2 = *(npy_longdouble *)ip2;
                /* Order of operations important for MSVC 2015 */
                io1 = (io1 <= in2 || npy_isnan(io1)) ? io1 : in2;
            }
            *((npy_longdouble *)iop1) = io1;
        }
    }
    else {
        BINARY_LOOP {
            npy_longdouble in1 = *(npy_longdouble *)ip1;
            const npy_longdouble in2 = *(npy_longdouble *)ip2;
            /* Order of operations important for MSVC 2015 */
            in1 = (in1 <= in2 || npy_isnan(in1)) ? in1 : in2;
            *((npy_longdouble *)op1) = in1;
        }
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}


#line 1943
NPY_NO_EXPORT void
LONGDOUBLE_fmax(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*  */
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_longdouble) {
            const npy_longdouble in2 = *(npy_longdouble *)ip2;
            /* Order of operations important for MSVC 2015 */
            io1 = (io1 >= in2 || npy_isnan(in2)) ? io1 : in2;
        }
        *((npy_longdouble *)iop1) = io1;
    }
    else {
        BINARY_LOOP {
            const npy_longdouble in1 = *(npy_longdouble *)ip1;
            const npy_longdouble in2 = *(npy_longdouble *)ip2;
            /* Order of operations important for MSVC 2015 */
            *((npy_longdouble *)op1) = (in1 >= in2 || npy_isnan(in2)) ? in1 : in2;
        }
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

#line 1943
NPY_NO_EXPORT void
LONGDOUBLE_fmin(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*  */
    if (IS_BINARY_REDUCE) {
        BINARY_REDUCE_LOOP(npy_longdouble) {
            const npy_longdouble in2 = *(npy_longdouble *)ip2;
            /* Order of operations important for MSVC 2015 */
            io1 = (io1 <= in2 || npy_isnan(in2)) ? io1 : in2;
        }
        *((npy_longdouble *)iop1) = io1;
    }
    else {
        BINARY_LOOP {
            const npy_longdouble in1 = *(npy_longdouble *)ip1;
            const npy_longdouble in2 = *(npy_longdouble *)ip2;
            /* Order of operations important for MSVC 2015 */
            *((npy_longdouble *)op1) = (in1 <= in2 || npy_isnan(in2)) ? in1 : in2;
        }
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}


NPY_NO_EXPORT void
LONGDOUBLE_floor_divide(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_longdouble in1 = *(npy_longdouble *)ip1;
        const npy_longdouble in2 = *(npy_longdouble *)ip2;
        npy_longdouble mod;
        *((npy_longdouble *)op1) = npy_divmodl(in1, in2, &mod);
    }
}

NPY_NO_EXPORT void
LONGDOUBLE_remainder(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_longdouble in1 = *(npy_longdouble *)ip1;
        const npy_longdouble in2 = *(npy_longdouble *)ip2;
        npy_divmodl(in1, in2, (npy_longdouble *)op1);
    }
}

NPY_NO_EXPORT void
LONGDOUBLE_divmod(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP_TWO_OUT {
        const npy_longdouble in1 = *(npy_longdouble *)ip1;
        const npy_longdouble in2 = *(npy_longdouble *)ip2;
        *((npy_longdouble *)op1) = npy_divmodl(in1, in2, (npy_longdouble *)op2);
    }
}

NPY_NO_EXPORT void
LONGDOUBLE_square(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    char * margs[] = {args[0], args[0], args[1]};
    npy_intp msteps[] = {steps[0], steps[0], steps[1]};
    if (!run_binary_simd_multiply_LONGDOUBLE(margs, dimensions, msteps)) {
        UNARY_LOOP {
            const npy_longdouble in1 = *(npy_longdouble *)ip1;
            *((npy_longdouble *)op1) = in1*in1;
        }
    }
}

NPY_NO_EXPORT void
LONGDOUBLE_reciprocal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    npy_longdouble one = 1.l;
    char * margs[] = {(char*)&one, args[0], args[1]};
    npy_intp msteps[] = {0, steps[0], steps[1]};
    if (!run_binary_simd_divide_LONGDOUBLE(margs, dimensions, msteps)) {
        UNARY_LOOP {
            const npy_longdouble in1 = *(npy_longdouble *)ip1;
            *((npy_longdouble *)op1) = 1/in1;
        }
    }
}

NPY_NO_EXPORT void
LONGDOUBLE__ones_like(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    OUTPUT_LOOP {
        *((npy_longdouble *)op1) = 1;
    }
}

NPY_NO_EXPORT void
LONGDOUBLE_conjugate(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_longdouble in1 = *(npy_longdouble *)ip1;
        *((npy_longdouble *)op1) = in1;
    }
}

NPY_NO_EXPORT void
LONGDOUBLE_absolute(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (!run_unary_simd_absolute_LONGDOUBLE(args, dimensions, steps)) {
        UNARY_LOOP {
            const npy_longdouble in1 = *(npy_longdouble *)ip1;
            const npy_longdouble tmp = in1 > 0 ? in1 : -in1;
            /* add 0 to clear -0.0 */
            *((npy_longdouble *)op1) = tmp + 0;
        }
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

NPY_NO_EXPORT void
LONGDOUBLE_negative(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (!run_unary_simd_negative_LONGDOUBLE(args, dimensions, steps)) {
        UNARY_LOOP {
            const npy_longdouble in1 = *(npy_longdouble *)ip1;
            *((npy_longdouble *)op1) = -in1;
        }
    }
}

NPY_NO_EXPORT void
LONGDOUBLE_positive(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_longdouble in1 = *(npy_longdouble *)ip1;
        *((npy_longdouble *)op1) = +in1;
    }
}

NPY_NO_EXPORT void
LONGDOUBLE_sign(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /* Sign of nan is nan */
    UNARY_LOOP {
        const npy_longdouble in1 = *(npy_longdouble *)ip1;
        *((npy_longdouble *)op1) = in1 > 0 ? 1 : (in1 < 0 ? -1 : (in1 == 0 ? 0 : in1));
    }
}

NPY_NO_EXPORT void
LONGDOUBLE_modf(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_TWO_OUT {
        const npy_longdouble in1 = *(npy_longdouble *)ip1;
        *((npy_longdouble *)op1) = npy_modfl(in1, (npy_longdouble *)op2);
    }
}

NPY_NO_EXPORT void
LONGDOUBLE_frexp(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_TWO_OUT {
        const npy_longdouble in1 = *(npy_longdouble *)ip1;
        *((npy_longdouble *)op1) = npy_frexpl(in1, (int *)op2);
    }
}

NPY_NO_EXPORT void
LONGDOUBLE_ldexp(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_longdouble in1 = *(npy_longdouble *)ip1;
        const int in2 = *(int *)ip2;
        *((npy_longdouble *)op1) = npy_ldexpl(in1, in2);
    }
}

NPY_NO_EXPORT void
LONGDOUBLE_ldexp_long(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * Additional loop to handle npy_long integer inputs (cf. #866, #1633).
     * npy_long != npy_int on many 64-bit platforms, so we need this second loop
     * to handle the default integer type.
     */
    BINARY_LOOP {
        const npy_longdouble in1 = *(npy_longdouble *)ip1;
        const long in2 = *(long *)ip2;
        if (((int)in2) == in2) {
            /* Range OK */
            *((npy_longdouble *)op1) = npy_ldexpl(in1, ((int)in2));
        }
        else {
            /*
             * Outside npy_int range -- also ldexp will overflow in this case,
             * given that exponent has less bits than npy_int.
             */
            if (in2 > 0) {
                *((npy_longdouble *)op1) = npy_ldexpl(in1, NPY_MAX_INT);
            }
            else {
                *((npy_longdouble *)op1) = npy_ldexpl(in1, NPY_MIN_INT);
            }
        }
    }
}

#define LONGDOUBLE_true_divide LONGDOUBLE_divide



/*
 *****************************************************************************
 **                          HALF-FLOAT LOOPS                               **
 *****************************************************************************
 */


#line 2161
NPY_NO_EXPORT void
HALF_add(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        char *iop1 = args[0];
        float io1 = npy_half_to_float(*(npy_half *)iop1);
#if 1
        npy_intp n = dimensions[0];

        io1 += pairwise_sum_HALF(args[1], n, steps[1]);
#else
        BINARY_REDUCE_LOOP_INNER {
            io1 += npy_half_to_float(*(npy_half *)ip2);
        }
#endif
        *((npy_half *)iop1) = npy_float_to_half(io1);
    }
    else {
        BINARY_LOOP {
            const float in1 = npy_half_to_float(*(npy_half *)ip1);
            const float in2 = npy_half_to_float(*(npy_half *)ip2);
            *((npy_half *)op1) = npy_float_to_half(in1 + in2);
        }
    }
}

#line 2161
NPY_NO_EXPORT void
HALF_subtract(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        char *iop1 = args[0];
        float io1 = npy_half_to_float(*(npy_half *)iop1);
#if 0
        npy_intp n = dimensions[0];

        io1 -= pairwise_sum_HALF(args[1], n, steps[1]);
#else
        BINARY_REDUCE_LOOP_INNER {
            io1 -= npy_half_to_float(*(npy_half *)ip2);
        }
#endif
        *((npy_half *)iop1) = npy_float_to_half(io1);
    }
    else {
        BINARY_LOOP {
            const float in1 = npy_half_to_float(*(npy_half *)ip1);
            const float in2 = npy_half_to_float(*(npy_half *)ip2);
            *((npy_half *)op1) = npy_float_to_half(in1 - in2);
        }
    }
}

#line 2161
NPY_NO_EXPORT void
HALF_multiply(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        char *iop1 = args[0];
        float io1 = npy_half_to_float(*(npy_half *)iop1);
#if 0
        npy_intp n = dimensions[0];

        io1 *= pairwise_sum_HALF(args[1], n, steps[1]);
#else
        BINARY_REDUCE_LOOP_INNER {
            io1 *= npy_half_to_float(*(npy_half *)ip2);
        }
#endif
        *((npy_half *)iop1) = npy_float_to_half(io1);
    }
    else {
        BINARY_LOOP {
            const float in1 = npy_half_to_float(*(npy_half *)ip1);
            const float in2 = npy_half_to_float(*(npy_half *)ip2);
            *((npy_half *)op1) = npy_float_to_half(in1 * in2);
        }
    }
}

#line 2161
NPY_NO_EXPORT void
HALF_divide(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE) {
        char *iop1 = args[0];
        float io1 = npy_half_to_float(*(npy_half *)iop1);
#if 0
        npy_intp n = dimensions[0];

        io1 /= pairwise_sum_HALF(args[1], n, steps[1]);
#else
        BINARY_REDUCE_LOOP_INNER {
            io1 /= npy_half_to_float(*(npy_half *)ip2);
        }
#endif
        *((npy_half *)iop1) = npy_float_to_half(io1);
    }
    else {
        BINARY_LOOP {
            const float in1 = npy_half_to_float(*(npy_half *)ip1);
            const float in2 = npy_half_to_float(*(npy_half *)ip2);
            *((npy_half *)op1) = npy_float_to_half(in1 / in2);
        }
    }
}


#define _HALF_LOGICAL_AND(a,b) (!npy_half_iszero(a) && !npy_half_iszero(b))
#define _HALF_LOGICAL_OR(a,b) (!npy_half_iszero(a) || !npy_half_iszero(b))
#line 2196
NPY_NO_EXPORT void
HALF_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_half in1 = *(npy_half *)ip1;
        const npy_half in2 = *(npy_half *)ip2;
        *((npy_bool *)op1) = npy_half_eq(in1, in2);
    }
}

#line 2196
NPY_NO_EXPORT void
HALF_not_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_half in1 = *(npy_half *)ip1;
        const npy_half in2 = *(npy_half *)ip2;
        *((npy_bool *)op1) = npy_half_ne(in1, in2);
    }
}

#line 2196
NPY_NO_EXPORT void
HALF_less(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_half in1 = *(npy_half *)ip1;
        const npy_half in2 = *(npy_half *)ip2;
        *((npy_bool *)op1) = npy_half_lt(in1, in2);
    }
}

#line 2196
NPY_NO_EXPORT void
HALF_less_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_half in1 = *(npy_half *)ip1;
        const npy_half in2 = *(npy_half *)ip2;
        *((npy_bool *)op1) = npy_half_le(in1, in2);
    }
}

#line 2196
NPY_NO_EXPORT void
HALF_greater(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_half in1 = *(npy_half *)ip1;
        const npy_half in2 = *(npy_half *)ip2;
        *((npy_bool *)op1) = npy_half_gt(in1, in2);
    }
}

#line 2196
NPY_NO_EXPORT void
HALF_greater_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_half in1 = *(npy_half *)ip1;
        const npy_half in2 = *(npy_half *)ip2;
        *((npy_bool *)op1) = npy_half_ge(in1, in2);
    }
}

#line 2196
NPY_NO_EXPORT void
HALF_logical_and(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_half in1 = *(npy_half *)ip1;
        const npy_half in2 = *(npy_half *)ip2;
        *((npy_bool *)op1) = _HALF_LOGICAL_AND(in1, in2);
    }
}

#line 2196
NPY_NO_EXPORT void
HALF_logical_or(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_half in1 = *(npy_half *)ip1;
        const npy_half in2 = *(npy_half *)ip2;
        *((npy_bool *)op1) = _HALF_LOGICAL_OR(in1, in2);
    }
}

#undef _HALF_LOGICAL_AND
#undef _HALF_LOGICAL_OR

NPY_NO_EXPORT void
HALF_logical_xor(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const int in1 = !npy_half_iszero(*(npy_half *)ip1);
        const int in2 = !npy_half_iszero(*(npy_half *)ip2);
        *((npy_bool *)op1) = (in1 != in2);
    }
}

NPY_NO_EXPORT void
HALF_logical_not(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_half in1 = *(npy_half *)ip1;
        *((npy_bool *)op1) = npy_half_iszero(in1);
    }
}

#line 2232
NPY_NO_EXPORT void
HALF_isnan(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_half in1 = *(npy_half *)ip1;
        *((npy_bool *)op1) = npy_half_isnan(in1) != 0;
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

#line 2232
NPY_NO_EXPORT void
HALF_isinf(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_half in1 = *(npy_half *)ip1;
        *((npy_bool *)op1) = npy_half_isinf(in1) != 0;
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

#line 2232
NPY_NO_EXPORT void
HALF_isfinite(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_half in1 = *(npy_half *)ip1;
        *((npy_bool *)op1) = npy_half_isfinite(in1) != 0;
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

#line 2232
NPY_NO_EXPORT void
HALF_signbit(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_half in1 = *(npy_half *)ip1;
        *((npy_bool *)op1) = npy_half_signbit(in1) != 0;
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}


NPY_NO_EXPORT void
HALF_spacing(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_half in1 = *(npy_half *)ip1;
        *((npy_half *)op1) = npy_half_spacing(in1);
    }
}

NPY_NO_EXPORT void
HALF_copysign(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_half in1 = *(npy_half *)ip1;
        const npy_half in2 = *(npy_half *)ip2;
        *((npy_half *)op1)= npy_half_copysign(in1, in2);
    }
}

NPY_NO_EXPORT void
HALF_nextafter(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_half in1 = *(npy_half *)ip1;
        const npy_half in2 = *(npy_half *)ip2;
        *((npy_half *)op1)= npy_half_nextafter(in1, in2);
    }
}

#line 2276
NPY_NO_EXPORT void
HALF_maximum(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*  */
    BINARY_LOOP {
        const npy_half in1 = *(npy_half *)ip1;
        const npy_half in2 = *(npy_half *)ip2;
        *((npy_half *)op1) = (npy_half_ge(in1, in2) || npy_half_isnan(in1)) ? in1 : in2;
    }
    /* npy_half_isnan will never set floatstatus_invalid, so do not clear */
}

#line 2276
NPY_NO_EXPORT void
HALF_minimum(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*  */
    BINARY_LOOP {
        const npy_half in1 = *(npy_half *)ip1;
        const npy_half in2 = *(npy_half *)ip2;
        *((npy_half *)op1) = (npy_half_le(in1, in2) || npy_half_isnan(in1)) ? in1 : in2;
    }
    /* npy_half_isnan will never set floatstatus_invalid, so do not clear */
}


#line 2293
NPY_NO_EXPORT void
HALF_fmax(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*  */
    BINARY_LOOP {
        const npy_half in1 = *(npy_half *)ip1;
        const npy_half in2 = *(npy_half *)ip2;
        *((npy_half *)op1) = (npy_half_ge(in1, in2) || npy_half_isnan(in2)) ? in1 : in2;
    }
    /* npy_half_isnan will never set floatstatus_invalid, so do not clear */
}

#line 2293
NPY_NO_EXPORT void
HALF_fmin(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*  */
    BINARY_LOOP {
        const npy_half in1 = *(npy_half *)ip1;
        const npy_half in2 = *(npy_half *)ip2;
        *((npy_half *)op1) = (npy_half_le(in1, in2) || npy_half_isnan(in2)) ? in1 : in2;
    }
    /* npy_half_isnan will never set floatstatus_invalid, so do not clear */
}


NPY_NO_EXPORT void
HALF_floor_divide(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_half in1 = *(npy_half *)ip1;
        const npy_half in2 = *(npy_half *)ip2;
        npy_half mod;
        *((npy_half *)op1) = npy_half_divmod(in1, in2, &mod);
    }
}

NPY_NO_EXPORT void
HALF_remainder(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_half in1 = *(npy_half *)ip1;
        const npy_half in2 = *(npy_half *)ip2;
        npy_half_divmod(in1, in2, (npy_half *)op1);
    }
}

NPY_NO_EXPORT void
HALF_divmod(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP_TWO_OUT {
        const npy_half in1 = *(npy_half *)ip1;
        const npy_half in2 = *(npy_half *)ip2;
        *((npy_half *)op1) = npy_half_divmod(in1, in2, (npy_half *)op2);
    }
}

NPY_NO_EXPORT void
HALF_square(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP {
        const float in1 = npy_half_to_float(*(npy_half *)ip1);
        *((npy_half *)op1) = npy_float_to_half(in1*in1);
    }
}

NPY_NO_EXPORT void
HALF_reciprocal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP {
        const float in1 = npy_half_to_float(*(npy_half *)ip1);
        *((npy_half *)op1) = npy_float_to_half(1/in1);
    }
}

NPY_NO_EXPORT void
HALF__ones_like(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    OUTPUT_LOOP {
        *((npy_half *)op1) = NPY_HALF_ONE;
    }
}

NPY_NO_EXPORT void
HALF_conjugate(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_half in1 = *(npy_half *)ip1;
        *((npy_half *)op1) = in1;
    }
}

NPY_NO_EXPORT void
HALF_absolute(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_half in1 = *(npy_half *)ip1;
        *((npy_half *)op1) = in1&0x7fffu;
    }
}

NPY_NO_EXPORT void
HALF_negative(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_half in1 = *(npy_half *)ip1;
        *((npy_half *)op1) = in1^0x8000u;
    }
}

NPY_NO_EXPORT void
HALF_positive(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_half in1 = *(npy_half *)ip1;
        *((npy_half *)op1) = +in1;
    }
}

NPY_NO_EXPORT void
HALF_sign(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /* Sign of nan is nan */
    UNARY_LOOP {
        const npy_half in1 = *(npy_half *)ip1;
        *((npy_half *)op1) = npy_half_isnan(in1) ? in1 :
                    (((in1&0x7fffu) == 0) ? 0 :
                      (((in1&0x8000u) == 0) ? NPY_HALF_ONE : NPY_HALF_NEGONE));
    }
}

NPY_NO_EXPORT void
HALF_modf(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    float temp;

    UNARY_LOOP_TWO_OUT {
        const float in1 = npy_half_to_float(*(npy_half *)ip1);
        *((npy_half *)op1) = npy_float_to_half(npy_modff(in1, &temp));
        *((npy_half *)op2) = npy_float_to_half(temp);
    }
}

NPY_NO_EXPORT void
HALF_frexp(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP_TWO_OUT {
        const float in1 = npy_half_to_float(*(npy_half *)ip1);
        *((npy_half *)op1) = npy_float_to_half(npy_frexpf(in1, (int *)op2));
    }
}

NPY_NO_EXPORT void
HALF_ldexp(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const float in1 = npy_half_to_float(*(npy_half *)ip1);
        const int in2 = *(int *)ip2;
        *((npy_half *)op1) = npy_float_to_half(npy_ldexpf(in1, in2));
    }
}

NPY_NO_EXPORT void
HALF_ldexp_long(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /*
     * Additional loop to handle npy_long integer inputs (cf. #866, #1633).
     * npy_long != npy_int on many 64-bit platforms, so we need this second loop
     * to handle the default integer type.
     */
    BINARY_LOOP {
        const float in1 = npy_half_to_float(*(npy_half *)ip1);
        const long in2 = *(long *)ip2;
        if (((int)in2) == in2) {
            /* Range OK */
            *((npy_half *)op1) = npy_float_to_half(npy_ldexpf(in1, ((int)in2)));
        }
        else {
            /*
             * Outside npy_int range -- also ldexp will overflow in this case,
             * given that exponent has less bits than npy_int.
             */
            if (in2 > 0) {
                *((npy_half *)op1) = npy_float_to_half(npy_ldexpf(in1, NPY_MAX_INT));
            }
            else {
                *((npy_half *)op1) = npy_float_to_half(npy_ldexpf(in1, NPY_MIN_INT));
            }
        }
    }
}

#define HALF_true_divide HALF_divide


/*
 *****************************************************************************
 **                           COMPLEX LOOPS                                 **
 *****************************************************************************
 */

#define CGE(xr,xi,yr,yi) ((xr > yr && !npy_isnan(xi) && !npy_isnan(yi)) \
                          || (xr == yr && xi >= yi))
#define CLE(xr,xi,yr,yi) ((xr < yr && !npy_isnan(xi) && !npy_isnan(yi)) \
                          || (xr == yr && xi <= yi))
#define CGT(xr,xi,yr,yi) ((xr > yr && !npy_isnan(xi) && !npy_isnan(yi)) \
                          || (xr == yr && xi > yi))
#define CLT(xr,xi,yr,yi) ((xr < yr && !npy_isnan(xi) && !npy_isnan(yi)) \
                          || (xr == yr && xi < yi))
#define CEQ(xr,xi,yr,yi) (xr == yr && xi == yi)
#define CNE(xr,xi,yr,yi) (xr != yr || xi != yi)

#line 2499

/* similar to pairwise sum of real floats */
static void
pairwise_sum_CFLOAT(npy_float *rr, npy_float * ri, char * a, npy_intp n,
                    npy_intp stride)
{
    assert(n % 2 == 0);
    if (n < 8) {
        npy_intp i;

        *rr = 0.;
        *ri = 0.;
        for (i = 0; i < n; i += 2) {
            *rr += *((npy_float *)(a + i * stride + 0));
            *ri += *((npy_float *)(a + i * stride + sizeof(npy_float)));
        }
        return;
    }
    else if (n <= PW_BLOCKSIZE) {
        npy_intp i;
        npy_float r[8];

        /*
         * sum a block with 8 accumulators
         * 8 times unroll reduces blocksize to 16 and allows vectorization with
         * avx without changing summation ordering
         */
        r[0] = *((npy_float *)(a + 0 * stride));
        r[1] = *((npy_float *)(a + 0 * stride + sizeof(npy_float)));
        r[2] = *((npy_float *)(a + 2 * stride));
        r[3] = *((npy_float *)(a + 2 * stride + sizeof(npy_float)));
        r[4] = *((npy_float *)(a + 4 * stride));
        r[5] = *((npy_float *)(a + 4 * stride + sizeof(npy_float)));
        r[6] = *((npy_float *)(a + 6 * stride));
        r[7] = *((npy_float *)(a + 6 * stride + sizeof(npy_float)));

        for (i = 8; i < n - (n % 8); i += 8) {
            /* small blocksizes seems to mess with hardware prefetch */
            NPY_PREFETCH(a + (i + 512/(npy_intp)sizeof(npy_float))*stride, 0, 3);
            r[0] += *((npy_float *)(a + (i + 0) * stride));
            r[1] += *((npy_float *)(a + (i + 0) * stride + sizeof(npy_float)));
            r[2] += *((npy_float *)(a + (i + 2) * stride));
            r[3] += *((npy_float *)(a + (i + 2) * stride + sizeof(npy_float)));
            r[4] += *((npy_float *)(a + (i + 4) * stride));
            r[5] += *((npy_float *)(a + (i + 4) * stride + sizeof(npy_float)));
            r[6] += *((npy_float *)(a + (i + 6) * stride));
            r[7] += *((npy_float *)(a + (i + 6) * stride + sizeof(npy_float)));
        }

        /* accumulate now to avoid stack spills for single peel loop */
        *rr = ((r[0] + r[2]) + (r[4] + r[6]));
        *ri = ((r[1] + r[3]) + (r[5] + r[7]));

        /* do non multiple of 8 rest */
        for (; i < n; i+=2) {
            *rr += *((npy_float *)(a + i * stride + 0));
            *ri += *((npy_float *)(a + i * stride + sizeof(npy_float)));
        }
        return;
    }
    else {
        /* divide by two but avoid non-multiples of unroll factor */
        npy_float rr1, ri1, rr2, ri2;
        npy_intp n2 = n / 2;

        n2 -= n2 % 8;
        pairwise_sum_CFLOAT(&rr1, &ri1, a, n2, stride);
        pairwise_sum_CFLOAT(&rr2, &ri2, a + n2 * stride, n - n2, stride);
        *rr = rr1 + rr2;
        *ri = ri1 + ri2;
        return;
    }
}

#line 2579
NPY_NO_EXPORT void
CFLOAT_add(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE && 1) {
        npy_intp n = dimensions[0];
        npy_float * or = ((npy_float *)args[0]);
        npy_float * oi = ((npy_float *)args[0]) + 1;
        npy_float rr, ri;

        pairwise_sum_CFLOAT(&rr, &ri, args[1], n * 2, steps[1] / 2);
        *or += rr;
        *oi += ri;
        return;
    }
    else {
        BINARY_LOOP {
            const npy_float in1r = ((npy_float *)ip1)[0];
            const npy_float in1i = ((npy_float *)ip1)[1];
            const npy_float in2r = ((npy_float *)ip2)[0];
            const npy_float in2i = ((npy_float *)ip2)[1];
            ((npy_float *)op1)[0] = in1r + in2r;
            ((npy_float *)op1)[1] = in1i + in2i;
        }
    }
}

#line 2579
NPY_NO_EXPORT void
CFLOAT_subtract(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE && 0) {
        npy_intp n = dimensions[0];
        npy_float * or = ((npy_float *)args[0]);
        npy_float * oi = ((npy_float *)args[0]) + 1;
        npy_float rr, ri;

        pairwise_sum_CFLOAT(&rr, &ri, args[1], n * 2, steps[1] / 2);
        *or -= rr;
        *oi -= ri;
        return;
    }
    else {
        BINARY_LOOP {
            const npy_float in1r = ((npy_float *)ip1)[0];
            const npy_float in1i = ((npy_float *)ip1)[1];
            const npy_float in2r = ((npy_float *)ip2)[0];
            const npy_float in2i = ((npy_float *)ip2)[1];
            ((npy_float *)op1)[0] = in1r - in2r;
            ((npy_float *)op1)[1] = in1i - in2i;
        }
    }
}


NPY_NO_EXPORT void
CFLOAT_multiply(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_float in1r = ((npy_float *)ip1)[0];
        const npy_float in1i = ((npy_float *)ip1)[1];
        const npy_float in2r = ((npy_float *)ip2)[0];
        const npy_float in2i = ((npy_float *)ip2)[1];
        ((npy_float *)op1)[0] = in1r*in2r - in1i*in2i;
        ((npy_float *)op1)[1] = in1r*in2i + in1i*in2r;
    }
}

NPY_NO_EXPORT void
CFLOAT_divide(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_float in1r = ((npy_float *)ip1)[0];
        const npy_float in1i = ((npy_float *)ip1)[1];
        const npy_float in2r = ((npy_float *)ip2)[0];
        const npy_float in2i = ((npy_float *)ip2)[1];
        const npy_float in2r_abs = npy_fabsf(in2r);
        const npy_float in2i_abs = npy_fabsf(in2i);
        if (in2r_abs >= in2i_abs) {
            if (in2r_abs == 0 && in2i_abs == 0) {
                /* divide by zero should yield a complex inf or nan */
                ((npy_float *)op1)[0] = in1r/in2r_abs;
                ((npy_float *)op1)[1] = in1i/in2i_abs;
            }
            else {
                const npy_float rat = in2i/in2r;
                const npy_float scl = 1.0f/(in2r + in2i*rat);
                ((npy_float *)op1)[0] = (in1r + in1i*rat)*scl;
                ((npy_float *)op1)[1] = (in1i - in1r*rat)*scl;
            }
        }
        else {
            const npy_float rat = in2r/in2i;
            const npy_float scl = 1.0f/(in2i + in2r*rat);
            ((npy_float *)op1)[0] = (in1r*rat + in1i)*scl;
            ((npy_float *)op1)[1] = (in1i*rat - in1r)*scl;
        }
    }
}

NPY_NO_EXPORT void
CFLOAT_floor_divide(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_float in1r = ((npy_float *)ip1)[0];
        const npy_float in1i = ((npy_float *)ip1)[1];
        const npy_float in2r = ((npy_float *)ip2)[0];
        const npy_float in2i = ((npy_float *)ip2)[1];
        if (npy_fabsf(in2r) >= npy_fabsf(in2i)) {
            const npy_float rat = in2i/in2r;
            ((npy_float *)op1)[0] = npy_floorf((in1r + in1i*rat)/(in2r + in2i*rat));
            ((npy_float *)op1)[1] = 0;
        }
        else {
            const npy_float rat = in2r/in2i;
            ((npy_float *)op1)[0] = npy_floorf((in1r*rat + in1i)/(in2i + in2r*rat));
            ((npy_float *)op1)[1] = 0;
        }
    }
}

#line 2676
NPY_NO_EXPORT void
CFLOAT_greater(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_float in1r = ((npy_float *)ip1)[0];
        const npy_float in1i = ((npy_float *)ip1)[1];
        const npy_float in2r = ((npy_float *)ip2)[0];
        const npy_float in2i = ((npy_float *)ip2)[1];
        *((npy_bool *)op1) = CGT(in1r,in1i,in2r,in2i);
    }
}

#line 2676
NPY_NO_EXPORT void
CFLOAT_greater_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_float in1r = ((npy_float *)ip1)[0];
        const npy_float in1i = ((npy_float *)ip1)[1];
        const npy_float in2r = ((npy_float *)ip2)[0];
        const npy_float in2i = ((npy_float *)ip2)[1];
        *((npy_bool *)op1) = CGE(in1r,in1i,in2r,in2i);
    }
}

#line 2676
NPY_NO_EXPORT void
CFLOAT_less(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_float in1r = ((npy_float *)ip1)[0];
        const npy_float in1i = ((npy_float *)ip1)[1];
        const npy_float in2r = ((npy_float *)ip2)[0];
        const npy_float in2i = ((npy_float *)ip2)[1];
        *((npy_bool *)op1) = CLT(in1r,in1i,in2r,in2i);
    }
}

#line 2676
NPY_NO_EXPORT void
CFLOAT_less_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_float in1r = ((npy_float *)ip1)[0];
        const npy_float in1i = ((npy_float *)ip1)[1];
        const npy_float in2r = ((npy_float *)ip2)[0];
        const npy_float in2i = ((npy_float *)ip2)[1];
        *((npy_bool *)op1) = CLE(in1r,in1i,in2r,in2i);
    }
}

#line 2676
NPY_NO_EXPORT void
CFLOAT_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_float in1r = ((npy_float *)ip1)[0];
        const npy_float in1i = ((npy_float *)ip1)[1];
        const npy_float in2r = ((npy_float *)ip2)[0];
        const npy_float in2i = ((npy_float *)ip2)[1];
        *((npy_bool *)op1) = CEQ(in1r,in1i,in2r,in2i);
    }
}

#line 2676
NPY_NO_EXPORT void
CFLOAT_not_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_float in1r = ((npy_float *)ip1)[0];
        const npy_float in1i = ((npy_float *)ip1)[1];
        const npy_float in2r = ((npy_float *)ip2)[0];
        const npy_float in2i = ((npy_float *)ip2)[1];
        *((npy_bool *)op1) = CNE(in1r,in1i,in2r,in2i);
    }
}


#line 2694
NPY_NO_EXPORT void
CFLOAT_logical_and(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_float in1r = ((npy_float *)ip1)[0];
        const npy_float in1i = ((npy_float *)ip1)[1];
        const npy_float in2r = ((npy_float *)ip2)[0];
        const npy_float in2i = ((npy_float *)ip2)[1];
        *((npy_bool *)op1) = (in1r || in1i) && (in2r || in2i);
    }
}

#line 2694
NPY_NO_EXPORT void
CFLOAT_logical_or(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_float in1r = ((npy_float *)ip1)[0];
        const npy_float in1i = ((npy_float *)ip1)[1];
        const npy_float in2r = ((npy_float *)ip2)[0];
        const npy_float in2i = ((npy_float *)ip2)[1];
        *((npy_bool *)op1) = (in1r || in1i) || (in2r || in2i);
    }
}


NPY_NO_EXPORT void
CFLOAT_logical_xor(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_float in1r = ((npy_float *)ip1)[0];
        const npy_float in1i = ((npy_float *)ip1)[1];
        const npy_float in2r = ((npy_float *)ip2)[0];
        const npy_float in2i = ((npy_float *)ip2)[1];
        const npy_bool tmp1 = (in1r || in1i);
        const npy_bool tmp2 = (in2r || in2i);
        *((npy_bool *)op1) = tmp1 != tmp2;
    }
}

NPY_NO_EXPORT void
CFLOAT_logical_not(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_float in1r = ((npy_float *)ip1)[0];
        const npy_float in1i = ((npy_float *)ip1)[1];
        *((npy_bool *)op1) = !(in1r || in1i);
    }
}

#line 2736
NPY_NO_EXPORT void
CFLOAT_isnan(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_float in1r = ((npy_float *)ip1)[0];
        const npy_float in1i = ((npy_float *)ip1)[1];
        *((npy_bool *)op1) = npy_isnan(in1r) || npy_isnan(in1i);
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

#line 2736
NPY_NO_EXPORT void
CFLOAT_isinf(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_float in1r = ((npy_float *)ip1)[0];
        const npy_float in1i = ((npy_float *)ip1)[1];
        *((npy_bool *)op1) = npy_isinf(in1r) || npy_isinf(in1i);
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

#line 2736
NPY_NO_EXPORT void
CFLOAT_isfinite(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_float in1r = ((npy_float *)ip1)[0];
        const npy_float in1i = ((npy_float *)ip1)[1];
        *((npy_bool *)op1) = npy_isfinite(in1r) && npy_isfinite(in1i);
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}


NPY_NO_EXPORT void
CFLOAT_square(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP {
        const npy_float in1r = ((npy_float *)ip1)[0];
        const npy_float in1i = ((npy_float *)ip1)[1];
        ((npy_float *)op1)[0] = in1r*in1r - in1i*in1i;
        ((npy_float *)op1)[1] = in1r*in1i + in1i*in1r;
    }
}

NPY_NO_EXPORT void
CFLOAT_reciprocal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP {
        const npy_float in1r = ((npy_float *)ip1)[0];
        const npy_float in1i = ((npy_float *)ip1)[1];
        if (npy_fabsf(in1i) <= npy_fabsf(in1r)) {
            const npy_float r = in1i/in1r;
            const npy_float d = in1r + in1i*r;
            ((npy_float *)op1)[0] = 1/d;
            ((npy_float *)op1)[1] = -r/d;
        } else {
            const npy_float r = in1r/in1i;
            const npy_float d = in1r*r + in1i;
            ((npy_float *)op1)[0] = r/d;
            ((npy_float *)op1)[1] = -1/d;
        }
    }
}

NPY_NO_EXPORT void
CFLOAT__ones_like(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    OUTPUT_LOOP {
        ((npy_float *)op1)[0] = 1;
        ((npy_float *)op1)[1] = 0;
    }
}

NPY_NO_EXPORT void
CFLOAT_conjugate(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func)) {
    UNARY_LOOP {
        const npy_float in1r = ((npy_float *)ip1)[0];
        const npy_float in1i = ((npy_float *)ip1)[1];
        ((npy_float *)op1)[0] = in1r;
        ((npy_float *)op1)[1] = -in1i;
    }
}

NPY_NO_EXPORT void
CFLOAT_absolute(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_float in1r = ((npy_float *)ip1)[0];
        const npy_float in1i = ((npy_float *)ip1)[1];
        *((npy_float *)op1) = npy_hypotf(in1r, in1i);
    }
}

NPY_NO_EXPORT void
CFLOAT__arg(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_float in1r = ((npy_float *)ip1)[0];
        const npy_float in1i = ((npy_float *)ip1)[1];
        *((npy_float *)op1) = npy_atan2f(in1i, in1r);
    }
}

NPY_NO_EXPORT void
CFLOAT_sign(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /* fixme: sign of nan is currently 0 */
    UNARY_LOOP {
        const npy_float in1r = ((npy_float *)ip1)[0];
        const npy_float in1i = ((npy_float *)ip1)[1];
        ((npy_float *)op1)[0] = CGT(in1r, in1i, 0.0, 0.0) ?  1 :
                            (CLT(in1r, in1i, 0.0, 0.0) ? -1 :
                            (CEQ(in1r, in1i, 0.0, 0.0) ?  0 : NPY_NANF));
        ((npy_float *)op1)[1] = 0;
    }
}

#line 2836
NPY_NO_EXPORT void
CFLOAT_maximum(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        npy_float in1r = ((npy_float *)ip1)[0];
        npy_float in1i = ((npy_float *)ip1)[1];
        const npy_float in2r = ((npy_float *)ip2)[0];
        const npy_float in2i = ((npy_float *)ip2)[1];
        if ( !(npy_isnan(in1r) || npy_isnan(in1i) || CGE(in1r, in1i, in2r, in2i))) {
            in1r = in2r;
            in1i = in2i;
        }
        ((npy_float *)op1)[0] = in1r;
        ((npy_float *)op1)[1] = in1i;
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

#line 2836
NPY_NO_EXPORT void
CFLOAT_minimum(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        npy_float in1r = ((npy_float *)ip1)[0];
        npy_float in1i = ((npy_float *)ip1)[1];
        const npy_float in2r = ((npy_float *)ip2)[0];
        const npy_float in2i = ((npy_float *)ip2)[1];
        if ( !(npy_isnan(in1r) || npy_isnan(in1i) || CLE(in1r, in1i, in2r, in2i))) {
            in1r = in2r;
            in1i = in2i;
        }
        ((npy_float *)op1)[0] = in1r;
        ((npy_float *)op1)[1] = in1i;
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}


#line 2859
NPY_NO_EXPORT void
CFLOAT_fmax(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_float in1r = ((npy_float *)ip1)[0];
        const npy_float in1i = ((npy_float *)ip1)[1];
        const npy_float in2r = ((npy_float *)ip2)[0];
        const npy_float in2i = ((npy_float *)ip2)[1];
        if (npy_isnan(in2r) || npy_isnan(in2i) || CGE(in1r, in1i, in2r, in2i)) {
            ((npy_float *)op1)[0] = in1r;
            ((npy_float *)op1)[1] = in1i;
        }
        else {
            ((npy_float *)op1)[0] = in2r;
            ((npy_float *)op1)[1] = in2i;
        }
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

#line 2859
NPY_NO_EXPORT void
CFLOAT_fmin(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_float in1r = ((npy_float *)ip1)[0];
        const npy_float in1i = ((npy_float *)ip1)[1];
        const npy_float in2r = ((npy_float *)ip2)[0];
        const npy_float in2i = ((npy_float *)ip2)[1];
        if (npy_isnan(in2r) || npy_isnan(in2i) || CLE(in1r, in1i, in2r, in2i)) {
            ((npy_float *)op1)[0] = in1r;
            ((npy_float *)op1)[1] = in1i;
        }
        else {
            ((npy_float *)op1)[0] = in2r;
            ((npy_float *)op1)[1] = in2i;
        }
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}


#define CFLOAT_true_divide CFLOAT_divide


#line 2499

/* similar to pairwise sum of real floats */
static void
pairwise_sum_CDOUBLE(npy_double *rr, npy_double * ri, char * a, npy_intp n,
                    npy_intp stride)
{
    assert(n % 2 == 0);
    if (n < 8) {
        npy_intp i;

        *rr = 0.;
        *ri = 0.;
        for (i = 0; i < n; i += 2) {
            *rr += *((npy_double *)(a + i * stride + 0));
            *ri += *((npy_double *)(a + i * stride + sizeof(npy_double)));
        }
        return;
    }
    else if (n <= PW_BLOCKSIZE) {
        npy_intp i;
        npy_double r[8];

        /*
         * sum a block with 8 accumulators
         * 8 times unroll reduces blocksize to 16 and allows vectorization with
         * avx without changing summation ordering
         */
        r[0] = *((npy_double *)(a + 0 * stride));
        r[1] = *((npy_double *)(a + 0 * stride + sizeof(npy_double)));
        r[2] = *((npy_double *)(a + 2 * stride));
        r[3] = *((npy_double *)(a + 2 * stride + sizeof(npy_double)));
        r[4] = *((npy_double *)(a + 4 * stride));
        r[5] = *((npy_double *)(a + 4 * stride + sizeof(npy_double)));
        r[6] = *((npy_double *)(a + 6 * stride));
        r[7] = *((npy_double *)(a + 6 * stride + sizeof(npy_double)));

        for (i = 8; i < n - (n % 8); i += 8) {
            /* small blocksizes seems to mess with hardware prefetch */
            NPY_PREFETCH(a + (i + 512/(npy_intp)sizeof(npy_double))*stride, 0, 3);
            r[0] += *((npy_double *)(a + (i + 0) * stride));
            r[1] += *((npy_double *)(a + (i + 0) * stride + sizeof(npy_double)));
            r[2] += *((npy_double *)(a + (i + 2) * stride));
            r[3] += *((npy_double *)(a + (i + 2) * stride + sizeof(npy_double)));
            r[4] += *((npy_double *)(a + (i + 4) * stride));
            r[5] += *((npy_double *)(a + (i + 4) * stride + sizeof(npy_double)));
            r[6] += *((npy_double *)(a + (i + 6) * stride));
            r[7] += *((npy_double *)(a + (i + 6) * stride + sizeof(npy_double)));
        }

        /* accumulate now to avoid stack spills for single peel loop */
        *rr = ((r[0] + r[2]) + (r[4] + r[6]));
        *ri = ((r[1] + r[3]) + (r[5] + r[7]));

        /* do non multiple of 8 rest */
        for (; i < n; i+=2) {
            *rr += *((npy_double *)(a + i * stride + 0));
            *ri += *((npy_double *)(a + i * stride + sizeof(npy_double)));
        }
        return;
    }
    else {
        /* divide by two but avoid non-multiples of unroll factor */
        npy_double rr1, ri1, rr2, ri2;
        npy_intp n2 = n / 2;

        n2 -= n2 % 8;
        pairwise_sum_CDOUBLE(&rr1, &ri1, a, n2, stride);
        pairwise_sum_CDOUBLE(&rr2, &ri2, a + n2 * stride, n - n2, stride);
        *rr = rr1 + rr2;
        *ri = ri1 + ri2;
        return;
    }
}

#line 2579
NPY_NO_EXPORT void
CDOUBLE_add(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE && 1) {
        npy_intp n = dimensions[0];
        npy_double * or = ((npy_double *)args[0]);
        npy_double * oi = ((npy_double *)args[0]) + 1;
        npy_double rr, ri;

        pairwise_sum_CDOUBLE(&rr, &ri, args[1], n * 2, steps[1] / 2);
        *or += rr;
        *oi += ri;
        return;
    }
    else {
        BINARY_LOOP {
            const npy_double in1r = ((npy_double *)ip1)[0];
            const npy_double in1i = ((npy_double *)ip1)[1];
            const npy_double in2r = ((npy_double *)ip2)[0];
            const npy_double in2i = ((npy_double *)ip2)[1];
            ((npy_double *)op1)[0] = in1r + in2r;
            ((npy_double *)op1)[1] = in1i + in2i;
        }
    }
}

#line 2579
NPY_NO_EXPORT void
CDOUBLE_subtract(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE && 0) {
        npy_intp n = dimensions[0];
        npy_double * or = ((npy_double *)args[0]);
        npy_double * oi = ((npy_double *)args[0]) + 1;
        npy_double rr, ri;

        pairwise_sum_CDOUBLE(&rr, &ri, args[1], n * 2, steps[1] / 2);
        *or -= rr;
        *oi -= ri;
        return;
    }
    else {
        BINARY_LOOP {
            const npy_double in1r = ((npy_double *)ip1)[0];
            const npy_double in1i = ((npy_double *)ip1)[1];
            const npy_double in2r = ((npy_double *)ip2)[0];
            const npy_double in2i = ((npy_double *)ip2)[1];
            ((npy_double *)op1)[0] = in1r - in2r;
            ((npy_double *)op1)[1] = in1i - in2i;
        }
    }
}


NPY_NO_EXPORT void
CDOUBLE_multiply(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_double in1r = ((npy_double *)ip1)[0];
        const npy_double in1i = ((npy_double *)ip1)[1];
        const npy_double in2r = ((npy_double *)ip2)[0];
        const npy_double in2i = ((npy_double *)ip2)[1];
        ((npy_double *)op1)[0] = in1r*in2r - in1i*in2i;
        ((npy_double *)op1)[1] = in1r*in2i + in1i*in2r;
    }
}

NPY_NO_EXPORT void
CDOUBLE_divide(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_double in1r = ((npy_double *)ip1)[0];
        const npy_double in1i = ((npy_double *)ip1)[1];
        const npy_double in2r = ((npy_double *)ip2)[0];
        const npy_double in2i = ((npy_double *)ip2)[1];
        const npy_double in2r_abs = npy_fabs(in2r);
        const npy_double in2i_abs = npy_fabs(in2i);
        if (in2r_abs >= in2i_abs) {
            if (in2r_abs == 0 && in2i_abs == 0) {
                /* divide by zero should yield a complex inf or nan */
                ((npy_double *)op1)[0] = in1r/in2r_abs;
                ((npy_double *)op1)[1] = in1i/in2i_abs;
            }
            else {
                const npy_double rat = in2i/in2r;
                const npy_double scl = 1.0/(in2r + in2i*rat);
                ((npy_double *)op1)[0] = (in1r + in1i*rat)*scl;
                ((npy_double *)op1)[1] = (in1i - in1r*rat)*scl;
            }
        }
        else {
            const npy_double rat = in2r/in2i;
            const npy_double scl = 1.0/(in2i + in2r*rat);
            ((npy_double *)op1)[0] = (in1r*rat + in1i)*scl;
            ((npy_double *)op1)[1] = (in1i*rat - in1r)*scl;
        }
    }
}

NPY_NO_EXPORT void
CDOUBLE_floor_divide(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_double in1r = ((npy_double *)ip1)[0];
        const npy_double in1i = ((npy_double *)ip1)[1];
        const npy_double in2r = ((npy_double *)ip2)[0];
        const npy_double in2i = ((npy_double *)ip2)[1];
        if (npy_fabs(in2r) >= npy_fabs(in2i)) {
            const npy_double rat = in2i/in2r;
            ((npy_double *)op1)[0] = npy_floor((in1r + in1i*rat)/(in2r + in2i*rat));
            ((npy_double *)op1)[1] = 0;
        }
        else {
            const npy_double rat = in2r/in2i;
            ((npy_double *)op1)[0] = npy_floor((in1r*rat + in1i)/(in2i + in2r*rat));
            ((npy_double *)op1)[1] = 0;
        }
    }
}

#line 2676
NPY_NO_EXPORT void
CDOUBLE_greater(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_double in1r = ((npy_double *)ip1)[0];
        const npy_double in1i = ((npy_double *)ip1)[1];
        const npy_double in2r = ((npy_double *)ip2)[0];
        const npy_double in2i = ((npy_double *)ip2)[1];
        *((npy_bool *)op1) = CGT(in1r,in1i,in2r,in2i);
    }
}

#line 2676
NPY_NO_EXPORT void
CDOUBLE_greater_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_double in1r = ((npy_double *)ip1)[0];
        const npy_double in1i = ((npy_double *)ip1)[1];
        const npy_double in2r = ((npy_double *)ip2)[0];
        const npy_double in2i = ((npy_double *)ip2)[1];
        *((npy_bool *)op1) = CGE(in1r,in1i,in2r,in2i);
    }
}

#line 2676
NPY_NO_EXPORT void
CDOUBLE_less(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_double in1r = ((npy_double *)ip1)[0];
        const npy_double in1i = ((npy_double *)ip1)[1];
        const npy_double in2r = ((npy_double *)ip2)[0];
        const npy_double in2i = ((npy_double *)ip2)[1];
        *((npy_bool *)op1) = CLT(in1r,in1i,in2r,in2i);
    }
}

#line 2676
NPY_NO_EXPORT void
CDOUBLE_less_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_double in1r = ((npy_double *)ip1)[0];
        const npy_double in1i = ((npy_double *)ip1)[1];
        const npy_double in2r = ((npy_double *)ip2)[0];
        const npy_double in2i = ((npy_double *)ip2)[1];
        *((npy_bool *)op1) = CLE(in1r,in1i,in2r,in2i);
    }
}

#line 2676
NPY_NO_EXPORT void
CDOUBLE_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_double in1r = ((npy_double *)ip1)[0];
        const npy_double in1i = ((npy_double *)ip1)[1];
        const npy_double in2r = ((npy_double *)ip2)[0];
        const npy_double in2i = ((npy_double *)ip2)[1];
        *((npy_bool *)op1) = CEQ(in1r,in1i,in2r,in2i);
    }
}

#line 2676
NPY_NO_EXPORT void
CDOUBLE_not_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_double in1r = ((npy_double *)ip1)[0];
        const npy_double in1i = ((npy_double *)ip1)[1];
        const npy_double in2r = ((npy_double *)ip2)[0];
        const npy_double in2i = ((npy_double *)ip2)[1];
        *((npy_bool *)op1) = CNE(in1r,in1i,in2r,in2i);
    }
}


#line 2694
NPY_NO_EXPORT void
CDOUBLE_logical_and(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_double in1r = ((npy_double *)ip1)[0];
        const npy_double in1i = ((npy_double *)ip1)[1];
        const npy_double in2r = ((npy_double *)ip2)[0];
        const npy_double in2i = ((npy_double *)ip2)[1];
        *((npy_bool *)op1) = (in1r || in1i) && (in2r || in2i);
    }
}

#line 2694
NPY_NO_EXPORT void
CDOUBLE_logical_or(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_double in1r = ((npy_double *)ip1)[0];
        const npy_double in1i = ((npy_double *)ip1)[1];
        const npy_double in2r = ((npy_double *)ip2)[0];
        const npy_double in2i = ((npy_double *)ip2)[1];
        *((npy_bool *)op1) = (in1r || in1i) || (in2r || in2i);
    }
}


NPY_NO_EXPORT void
CDOUBLE_logical_xor(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_double in1r = ((npy_double *)ip1)[0];
        const npy_double in1i = ((npy_double *)ip1)[1];
        const npy_double in2r = ((npy_double *)ip2)[0];
        const npy_double in2i = ((npy_double *)ip2)[1];
        const npy_bool tmp1 = (in1r || in1i);
        const npy_bool tmp2 = (in2r || in2i);
        *((npy_bool *)op1) = tmp1 != tmp2;
    }
}

NPY_NO_EXPORT void
CDOUBLE_logical_not(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_double in1r = ((npy_double *)ip1)[0];
        const npy_double in1i = ((npy_double *)ip1)[1];
        *((npy_bool *)op1) = !(in1r || in1i);
    }
}

#line 2736
NPY_NO_EXPORT void
CDOUBLE_isnan(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_double in1r = ((npy_double *)ip1)[0];
        const npy_double in1i = ((npy_double *)ip1)[1];
        *((npy_bool *)op1) = npy_isnan(in1r) || npy_isnan(in1i);
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

#line 2736
NPY_NO_EXPORT void
CDOUBLE_isinf(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_double in1r = ((npy_double *)ip1)[0];
        const npy_double in1i = ((npy_double *)ip1)[1];
        *((npy_bool *)op1) = npy_isinf(in1r) || npy_isinf(in1i);
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

#line 2736
NPY_NO_EXPORT void
CDOUBLE_isfinite(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_double in1r = ((npy_double *)ip1)[0];
        const npy_double in1i = ((npy_double *)ip1)[1];
        *((npy_bool *)op1) = npy_isfinite(in1r) && npy_isfinite(in1i);
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}


NPY_NO_EXPORT void
CDOUBLE_square(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP {
        const npy_double in1r = ((npy_double *)ip1)[0];
        const npy_double in1i = ((npy_double *)ip1)[1];
        ((npy_double *)op1)[0] = in1r*in1r - in1i*in1i;
        ((npy_double *)op1)[1] = in1r*in1i + in1i*in1r;
    }
}

NPY_NO_EXPORT void
CDOUBLE_reciprocal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP {
        const npy_double in1r = ((npy_double *)ip1)[0];
        const npy_double in1i = ((npy_double *)ip1)[1];
        if (npy_fabs(in1i) <= npy_fabs(in1r)) {
            const npy_double r = in1i/in1r;
            const npy_double d = in1r + in1i*r;
            ((npy_double *)op1)[0] = 1/d;
            ((npy_double *)op1)[1] = -r/d;
        } else {
            const npy_double r = in1r/in1i;
            const npy_double d = in1r*r + in1i;
            ((npy_double *)op1)[0] = r/d;
            ((npy_double *)op1)[1] = -1/d;
        }
    }
}

NPY_NO_EXPORT void
CDOUBLE__ones_like(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    OUTPUT_LOOP {
        ((npy_double *)op1)[0] = 1;
        ((npy_double *)op1)[1] = 0;
    }
}

NPY_NO_EXPORT void
CDOUBLE_conjugate(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func)) {
    UNARY_LOOP {
        const npy_double in1r = ((npy_double *)ip1)[0];
        const npy_double in1i = ((npy_double *)ip1)[1];
        ((npy_double *)op1)[0] = in1r;
        ((npy_double *)op1)[1] = -in1i;
    }
}

NPY_NO_EXPORT void
CDOUBLE_absolute(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_double in1r = ((npy_double *)ip1)[0];
        const npy_double in1i = ((npy_double *)ip1)[1];
        *((npy_double *)op1) = npy_hypot(in1r, in1i);
    }
}

NPY_NO_EXPORT void
CDOUBLE__arg(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_double in1r = ((npy_double *)ip1)[0];
        const npy_double in1i = ((npy_double *)ip1)[1];
        *((npy_double *)op1) = npy_atan2(in1i, in1r);
    }
}

NPY_NO_EXPORT void
CDOUBLE_sign(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /* fixme: sign of nan is currently 0 */
    UNARY_LOOP {
        const npy_double in1r = ((npy_double *)ip1)[0];
        const npy_double in1i = ((npy_double *)ip1)[1];
        ((npy_double *)op1)[0] = CGT(in1r, in1i, 0.0, 0.0) ?  1 :
                            (CLT(in1r, in1i, 0.0, 0.0) ? -1 :
                            (CEQ(in1r, in1i, 0.0, 0.0) ?  0 : NPY_NAN));
        ((npy_double *)op1)[1] = 0;
    }
}

#line 2836
NPY_NO_EXPORT void
CDOUBLE_maximum(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        npy_double in1r = ((npy_double *)ip1)[0];
        npy_double in1i = ((npy_double *)ip1)[1];
        const npy_double in2r = ((npy_double *)ip2)[0];
        const npy_double in2i = ((npy_double *)ip2)[1];
        if ( !(npy_isnan(in1r) || npy_isnan(in1i) || CGE(in1r, in1i, in2r, in2i))) {
            in1r = in2r;
            in1i = in2i;
        }
        ((npy_double *)op1)[0] = in1r;
        ((npy_double *)op1)[1] = in1i;
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

#line 2836
NPY_NO_EXPORT void
CDOUBLE_minimum(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        npy_double in1r = ((npy_double *)ip1)[0];
        npy_double in1i = ((npy_double *)ip1)[1];
        const npy_double in2r = ((npy_double *)ip2)[0];
        const npy_double in2i = ((npy_double *)ip2)[1];
        if ( !(npy_isnan(in1r) || npy_isnan(in1i) || CLE(in1r, in1i, in2r, in2i))) {
            in1r = in2r;
            in1i = in2i;
        }
        ((npy_double *)op1)[0] = in1r;
        ((npy_double *)op1)[1] = in1i;
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}


#line 2859
NPY_NO_EXPORT void
CDOUBLE_fmax(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_double in1r = ((npy_double *)ip1)[0];
        const npy_double in1i = ((npy_double *)ip1)[1];
        const npy_double in2r = ((npy_double *)ip2)[0];
        const npy_double in2i = ((npy_double *)ip2)[1];
        if (npy_isnan(in2r) || npy_isnan(in2i) || CGE(in1r, in1i, in2r, in2i)) {
            ((npy_double *)op1)[0] = in1r;
            ((npy_double *)op1)[1] = in1i;
        }
        else {
            ((npy_double *)op1)[0] = in2r;
            ((npy_double *)op1)[1] = in2i;
        }
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

#line 2859
NPY_NO_EXPORT void
CDOUBLE_fmin(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_double in1r = ((npy_double *)ip1)[0];
        const npy_double in1i = ((npy_double *)ip1)[1];
        const npy_double in2r = ((npy_double *)ip2)[0];
        const npy_double in2i = ((npy_double *)ip2)[1];
        if (npy_isnan(in2r) || npy_isnan(in2i) || CLE(in1r, in1i, in2r, in2i)) {
            ((npy_double *)op1)[0] = in1r;
            ((npy_double *)op1)[1] = in1i;
        }
        else {
            ((npy_double *)op1)[0] = in2r;
            ((npy_double *)op1)[1] = in2i;
        }
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}


#define CDOUBLE_true_divide CDOUBLE_divide


#line 2499

/* similar to pairwise sum of real floats */
static void
pairwise_sum_CLONGDOUBLE(npy_longdouble *rr, npy_longdouble * ri, char * a, npy_intp n,
                    npy_intp stride)
{
    assert(n % 2 == 0);
    if (n < 8) {
        npy_intp i;

        *rr = 0.;
        *ri = 0.;
        for (i = 0; i < n; i += 2) {
            *rr += *((npy_longdouble *)(a + i * stride + 0));
            *ri += *((npy_longdouble *)(a + i * stride + sizeof(npy_longdouble)));
        }
        return;
    }
    else if (n <= PW_BLOCKSIZE) {
        npy_intp i;
        npy_longdouble r[8];

        /*
         * sum a block with 8 accumulators
         * 8 times unroll reduces blocksize to 16 and allows vectorization with
         * avx without changing summation ordering
         */
        r[0] = *((npy_longdouble *)(a + 0 * stride));
        r[1] = *((npy_longdouble *)(a + 0 * stride + sizeof(npy_longdouble)));
        r[2] = *((npy_longdouble *)(a + 2 * stride));
        r[3] = *((npy_longdouble *)(a + 2 * stride + sizeof(npy_longdouble)));
        r[4] = *((npy_longdouble *)(a + 4 * stride));
        r[5] = *((npy_longdouble *)(a + 4 * stride + sizeof(npy_longdouble)));
        r[6] = *((npy_longdouble *)(a + 6 * stride));
        r[7] = *((npy_longdouble *)(a + 6 * stride + sizeof(npy_longdouble)));

        for (i = 8; i < n - (n % 8); i += 8) {
            /* small blocksizes seems to mess with hardware prefetch */
            NPY_PREFETCH(a + (i + 512/(npy_intp)sizeof(npy_longdouble))*stride, 0, 3);
            r[0] += *((npy_longdouble *)(a + (i + 0) * stride));
            r[1] += *((npy_longdouble *)(a + (i + 0) * stride + sizeof(npy_longdouble)));
            r[2] += *((npy_longdouble *)(a + (i + 2) * stride));
            r[3] += *((npy_longdouble *)(a + (i + 2) * stride + sizeof(npy_longdouble)));
            r[4] += *((npy_longdouble *)(a + (i + 4) * stride));
            r[5] += *((npy_longdouble *)(a + (i + 4) * stride + sizeof(npy_longdouble)));
            r[6] += *((npy_longdouble *)(a + (i + 6) * stride));
            r[7] += *((npy_longdouble *)(a + (i + 6) * stride + sizeof(npy_longdouble)));
        }

        /* accumulate now to avoid stack spills for single peel loop */
        *rr = ((r[0] + r[2]) + (r[4] + r[6]));
        *ri = ((r[1] + r[3]) + (r[5] + r[7]));

        /* do non multiple of 8 rest */
        for (; i < n; i+=2) {
            *rr += *((npy_longdouble *)(a + i * stride + 0));
            *ri += *((npy_longdouble *)(a + i * stride + sizeof(npy_longdouble)));
        }
        return;
    }
    else {
        /* divide by two but avoid non-multiples of unroll factor */
        npy_longdouble rr1, ri1, rr2, ri2;
        npy_intp n2 = n / 2;

        n2 -= n2 % 8;
        pairwise_sum_CLONGDOUBLE(&rr1, &ri1, a, n2, stride);
        pairwise_sum_CLONGDOUBLE(&rr2, &ri2, a + n2 * stride, n - n2, stride);
        *rr = rr1 + rr2;
        *ri = ri1 + ri2;
        return;
    }
}

#line 2579
NPY_NO_EXPORT void
CLONGDOUBLE_add(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE && 1) {
        npy_intp n = dimensions[0];
        npy_longdouble * or = ((npy_longdouble *)args[0]);
        npy_longdouble * oi = ((npy_longdouble *)args[0]) + 1;
        npy_longdouble rr, ri;

        pairwise_sum_CLONGDOUBLE(&rr, &ri, args[1], n * 2, steps[1] / 2);
        *or += rr;
        *oi += ri;
        return;
    }
    else {
        BINARY_LOOP {
            const npy_longdouble in1r = ((npy_longdouble *)ip1)[0];
            const npy_longdouble in1i = ((npy_longdouble *)ip1)[1];
            const npy_longdouble in2r = ((npy_longdouble *)ip2)[0];
            const npy_longdouble in2i = ((npy_longdouble *)ip2)[1];
            ((npy_longdouble *)op1)[0] = in1r + in2r;
            ((npy_longdouble *)op1)[1] = in1i + in2i;
        }
    }
}

#line 2579
NPY_NO_EXPORT void
CLONGDOUBLE_subtract(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    if (IS_BINARY_REDUCE && 0) {
        npy_intp n = dimensions[0];
        npy_longdouble * or = ((npy_longdouble *)args[0]);
        npy_longdouble * oi = ((npy_longdouble *)args[0]) + 1;
        npy_longdouble rr, ri;

        pairwise_sum_CLONGDOUBLE(&rr, &ri, args[1], n * 2, steps[1] / 2);
        *or -= rr;
        *oi -= ri;
        return;
    }
    else {
        BINARY_LOOP {
            const npy_longdouble in1r = ((npy_longdouble *)ip1)[0];
            const npy_longdouble in1i = ((npy_longdouble *)ip1)[1];
            const npy_longdouble in2r = ((npy_longdouble *)ip2)[0];
            const npy_longdouble in2i = ((npy_longdouble *)ip2)[1];
            ((npy_longdouble *)op1)[0] = in1r - in2r;
            ((npy_longdouble *)op1)[1] = in1i - in2i;
        }
    }
}


NPY_NO_EXPORT void
CLONGDOUBLE_multiply(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_longdouble in1r = ((npy_longdouble *)ip1)[0];
        const npy_longdouble in1i = ((npy_longdouble *)ip1)[1];
        const npy_longdouble in2r = ((npy_longdouble *)ip2)[0];
        const npy_longdouble in2i = ((npy_longdouble *)ip2)[1];
        ((npy_longdouble *)op1)[0] = in1r*in2r - in1i*in2i;
        ((npy_longdouble *)op1)[1] = in1r*in2i + in1i*in2r;
    }
}

NPY_NO_EXPORT void
CLONGDOUBLE_divide(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_longdouble in1r = ((npy_longdouble *)ip1)[0];
        const npy_longdouble in1i = ((npy_longdouble *)ip1)[1];
        const npy_longdouble in2r = ((npy_longdouble *)ip2)[0];
        const npy_longdouble in2i = ((npy_longdouble *)ip2)[1];
        const npy_longdouble in2r_abs = npy_fabsl(in2r);
        const npy_longdouble in2i_abs = npy_fabsl(in2i);
        if (in2r_abs >= in2i_abs) {
            if (in2r_abs == 0 && in2i_abs == 0) {
                /* divide by zero should yield a complex inf or nan */
                ((npy_longdouble *)op1)[0] = in1r/in2r_abs;
                ((npy_longdouble *)op1)[1] = in1i/in2i_abs;
            }
            else {
                const npy_longdouble rat = in2i/in2r;
                const npy_longdouble scl = 1.0l/(in2r + in2i*rat);
                ((npy_longdouble *)op1)[0] = (in1r + in1i*rat)*scl;
                ((npy_longdouble *)op1)[1] = (in1i - in1r*rat)*scl;
            }
        }
        else {
            const npy_longdouble rat = in2r/in2i;
            const npy_longdouble scl = 1.0l/(in2i + in2r*rat);
            ((npy_longdouble *)op1)[0] = (in1r*rat + in1i)*scl;
            ((npy_longdouble *)op1)[1] = (in1i*rat - in1r)*scl;
        }
    }
}

NPY_NO_EXPORT void
CLONGDOUBLE_floor_divide(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_longdouble in1r = ((npy_longdouble *)ip1)[0];
        const npy_longdouble in1i = ((npy_longdouble *)ip1)[1];
        const npy_longdouble in2r = ((npy_longdouble *)ip2)[0];
        const npy_longdouble in2i = ((npy_longdouble *)ip2)[1];
        if (npy_fabsl(in2r) >= npy_fabsl(in2i)) {
            const npy_longdouble rat = in2i/in2r;
            ((npy_longdouble *)op1)[0] = npy_floorl((in1r + in1i*rat)/(in2r + in2i*rat));
            ((npy_longdouble *)op1)[1] = 0;
        }
        else {
            const npy_longdouble rat = in2r/in2i;
            ((npy_longdouble *)op1)[0] = npy_floorl((in1r*rat + in1i)/(in2i + in2r*rat));
            ((npy_longdouble *)op1)[1] = 0;
        }
    }
}

#line 2676
NPY_NO_EXPORT void
CLONGDOUBLE_greater(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_longdouble in1r = ((npy_longdouble *)ip1)[0];
        const npy_longdouble in1i = ((npy_longdouble *)ip1)[1];
        const npy_longdouble in2r = ((npy_longdouble *)ip2)[0];
        const npy_longdouble in2i = ((npy_longdouble *)ip2)[1];
        *((npy_bool *)op1) = CGT(in1r,in1i,in2r,in2i);
    }
}

#line 2676
NPY_NO_EXPORT void
CLONGDOUBLE_greater_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_longdouble in1r = ((npy_longdouble *)ip1)[0];
        const npy_longdouble in1i = ((npy_longdouble *)ip1)[1];
        const npy_longdouble in2r = ((npy_longdouble *)ip2)[0];
        const npy_longdouble in2i = ((npy_longdouble *)ip2)[1];
        *((npy_bool *)op1) = CGE(in1r,in1i,in2r,in2i);
    }
}

#line 2676
NPY_NO_EXPORT void
CLONGDOUBLE_less(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_longdouble in1r = ((npy_longdouble *)ip1)[0];
        const npy_longdouble in1i = ((npy_longdouble *)ip1)[1];
        const npy_longdouble in2r = ((npy_longdouble *)ip2)[0];
        const npy_longdouble in2i = ((npy_longdouble *)ip2)[1];
        *((npy_bool *)op1) = CLT(in1r,in1i,in2r,in2i);
    }
}

#line 2676
NPY_NO_EXPORT void
CLONGDOUBLE_less_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_longdouble in1r = ((npy_longdouble *)ip1)[0];
        const npy_longdouble in1i = ((npy_longdouble *)ip1)[1];
        const npy_longdouble in2r = ((npy_longdouble *)ip2)[0];
        const npy_longdouble in2i = ((npy_longdouble *)ip2)[1];
        *((npy_bool *)op1) = CLE(in1r,in1i,in2r,in2i);
    }
}

#line 2676
NPY_NO_EXPORT void
CLONGDOUBLE_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_longdouble in1r = ((npy_longdouble *)ip1)[0];
        const npy_longdouble in1i = ((npy_longdouble *)ip1)[1];
        const npy_longdouble in2r = ((npy_longdouble *)ip2)[0];
        const npy_longdouble in2i = ((npy_longdouble *)ip2)[1];
        *((npy_bool *)op1) = CEQ(in1r,in1i,in2r,in2i);
    }
}

#line 2676
NPY_NO_EXPORT void
CLONGDOUBLE_not_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_longdouble in1r = ((npy_longdouble *)ip1)[0];
        const npy_longdouble in1i = ((npy_longdouble *)ip1)[1];
        const npy_longdouble in2r = ((npy_longdouble *)ip2)[0];
        const npy_longdouble in2i = ((npy_longdouble *)ip2)[1];
        *((npy_bool *)op1) = CNE(in1r,in1i,in2r,in2i);
    }
}


#line 2694
NPY_NO_EXPORT void
CLONGDOUBLE_logical_and(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_longdouble in1r = ((npy_longdouble *)ip1)[0];
        const npy_longdouble in1i = ((npy_longdouble *)ip1)[1];
        const npy_longdouble in2r = ((npy_longdouble *)ip2)[0];
        const npy_longdouble in2i = ((npy_longdouble *)ip2)[1];
        *((npy_bool *)op1) = (in1r || in1i) && (in2r || in2i);
    }
}

#line 2694
NPY_NO_EXPORT void
CLONGDOUBLE_logical_or(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_longdouble in1r = ((npy_longdouble *)ip1)[0];
        const npy_longdouble in1i = ((npy_longdouble *)ip1)[1];
        const npy_longdouble in2r = ((npy_longdouble *)ip2)[0];
        const npy_longdouble in2i = ((npy_longdouble *)ip2)[1];
        *((npy_bool *)op1) = (in1r || in1i) || (in2r || in2i);
    }
}


NPY_NO_EXPORT void
CLONGDOUBLE_logical_xor(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_longdouble in1r = ((npy_longdouble *)ip1)[0];
        const npy_longdouble in1i = ((npy_longdouble *)ip1)[1];
        const npy_longdouble in2r = ((npy_longdouble *)ip2)[0];
        const npy_longdouble in2i = ((npy_longdouble *)ip2)[1];
        const npy_bool tmp1 = (in1r || in1i);
        const npy_bool tmp2 = (in2r || in2i);
        *((npy_bool *)op1) = tmp1 != tmp2;
    }
}

NPY_NO_EXPORT void
CLONGDOUBLE_logical_not(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_longdouble in1r = ((npy_longdouble *)ip1)[0];
        const npy_longdouble in1i = ((npy_longdouble *)ip1)[1];
        *((npy_bool *)op1) = !(in1r || in1i);
    }
}

#line 2736
NPY_NO_EXPORT void
CLONGDOUBLE_isnan(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_longdouble in1r = ((npy_longdouble *)ip1)[0];
        const npy_longdouble in1i = ((npy_longdouble *)ip1)[1];
        *((npy_bool *)op1) = npy_isnan(in1r) || npy_isnan(in1i);
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

#line 2736
NPY_NO_EXPORT void
CLONGDOUBLE_isinf(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_longdouble in1r = ((npy_longdouble *)ip1)[0];
        const npy_longdouble in1i = ((npy_longdouble *)ip1)[1];
        *((npy_bool *)op1) = npy_isinf(in1r) || npy_isinf(in1i);
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

#line 2736
NPY_NO_EXPORT void
CLONGDOUBLE_isfinite(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_longdouble in1r = ((npy_longdouble *)ip1)[0];
        const npy_longdouble in1i = ((npy_longdouble *)ip1)[1];
        *((npy_bool *)op1) = npy_isfinite(in1r) && npy_isfinite(in1i);
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}


NPY_NO_EXPORT void
CLONGDOUBLE_square(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP {
        const npy_longdouble in1r = ((npy_longdouble *)ip1)[0];
        const npy_longdouble in1i = ((npy_longdouble *)ip1)[1];
        ((npy_longdouble *)op1)[0] = in1r*in1r - in1i*in1i;
        ((npy_longdouble *)op1)[1] = in1r*in1i + in1i*in1r;
    }
}

NPY_NO_EXPORT void
CLONGDOUBLE_reciprocal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    UNARY_LOOP {
        const npy_longdouble in1r = ((npy_longdouble *)ip1)[0];
        const npy_longdouble in1i = ((npy_longdouble *)ip1)[1];
        if (npy_fabsl(in1i) <= npy_fabsl(in1r)) {
            const npy_longdouble r = in1i/in1r;
            const npy_longdouble d = in1r + in1i*r;
            ((npy_longdouble *)op1)[0] = 1/d;
            ((npy_longdouble *)op1)[1] = -r/d;
        } else {
            const npy_longdouble r = in1r/in1i;
            const npy_longdouble d = in1r*r + in1i;
            ((npy_longdouble *)op1)[0] = r/d;
            ((npy_longdouble *)op1)[1] = -1/d;
        }
    }
}

NPY_NO_EXPORT void
CLONGDOUBLE__ones_like(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(data))
{
    OUTPUT_LOOP {
        ((npy_longdouble *)op1)[0] = 1;
        ((npy_longdouble *)op1)[1] = 0;
    }
}

NPY_NO_EXPORT void
CLONGDOUBLE_conjugate(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func)) {
    UNARY_LOOP {
        const npy_longdouble in1r = ((npy_longdouble *)ip1)[0];
        const npy_longdouble in1i = ((npy_longdouble *)ip1)[1];
        ((npy_longdouble *)op1)[0] = in1r;
        ((npy_longdouble *)op1)[1] = -in1i;
    }
}

NPY_NO_EXPORT void
CLONGDOUBLE_absolute(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_longdouble in1r = ((npy_longdouble *)ip1)[0];
        const npy_longdouble in1i = ((npy_longdouble *)ip1)[1];
        *((npy_longdouble *)op1) = npy_hypotl(in1r, in1i);
    }
}

NPY_NO_EXPORT void
CLONGDOUBLE__arg(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    UNARY_LOOP {
        const npy_longdouble in1r = ((npy_longdouble *)ip1)[0];
        const npy_longdouble in1i = ((npy_longdouble *)ip1)[1];
        *((npy_longdouble *)op1) = npy_atan2l(in1i, in1r);
    }
}

NPY_NO_EXPORT void
CLONGDOUBLE_sign(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    /* fixme: sign of nan is currently 0 */
    UNARY_LOOP {
        const npy_longdouble in1r = ((npy_longdouble *)ip1)[0];
        const npy_longdouble in1i = ((npy_longdouble *)ip1)[1];
        ((npy_longdouble *)op1)[0] = CGT(in1r, in1i, 0.0, 0.0) ?  1 :
                            (CLT(in1r, in1i, 0.0, 0.0) ? -1 :
                            (CEQ(in1r, in1i, 0.0, 0.0) ?  0 : NPY_NANL));
        ((npy_longdouble *)op1)[1] = 0;
    }
}

#line 2836
NPY_NO_EXPORT void
CLONGDOUBLE_maximum(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        npy_longdouble in1r = ((npy_longdouble *)ip1)[0];
        npy_longdouble in1i = ((npy_longdouble *)ip1)[1];
        const npy_longdouble in2r = ((npy_longdouble *)ip2)[0];
        const npy_longdouble in2i = ((npy_longdouble *)ip2)[1];
        if ( !(npy_isnan(in1r) || npy_isnan(in1i) || CGE(in1r, in1i, in2r, in2i))) {
            in1r = in2r;
            in1i = in2i;
        }
        ((npy_longdouble *)op1)[0] = in1r;
        ((npy_longdouble *)op1)[1] = in1i;
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

#line 2836
NPY_NO_EXPORT void
CLONGDOUBLE_minimum(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        npy_longdouble in1r = ((npy_longdouble *)ip1)[0];
        npy_longdouble in1i = ((npy_longdouble *)ip1)[1];
        const npy_longdouble in2r = ((npy_longdouble *)ip2)[0];
        const npy_longdouble in2i = ((npy_longdouble *)ip2)[1];
        if ( !(npy_isnan(in1r) || npy_isnan(in1i) || CLE(in1r, in1i, in2r, in2i))) {
            in1r = in2r;
            in1i = in2i;
        }
        ((npy_longdouble *)op1)[0] = in1r;
        ((npy_longdouble *)op1)[1] = in1i;
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}


#line 2859
NPY_NO_EXPORT void
CLONGDOUBLE_fmax(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_longdouble in1r = ((npy_longdouble *)ip1)[0];
        const npy_longdouble in1i = ((npy_longdouble *)ip1)[1];
        const npy_longdouble in2r = ((npy_longdouble *)ip2)[0];
        const npy_longdouble in2i = ((npy_longdouble *)ip2)[1];
        if (npy_isnan(in2r) || npy_isnan(in2i) || CGE(in1r, in1i, in2r, in2i)) {
            ((npy_longdouble *)op1)[0] = in1r;
            ((npy_longdouble *)op1)[1] = in1i;
        }
        else {
            ((npy_longdouble *)op1)[0] = in2r;
            ((npy_longdouble *)op1)[1] = in2i;
        }
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}

#line 2859
NPY_NO_EXPORT void
CLONGDOUBLE_fmin(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    BINARY_LOOP {
        const npy_longdouble in1r = ((npy_longdouble *)ip1)[0];
        const npy_longdouble in1i = ((npy_longdouble *)ip1)[1];
        const npy_longdouble in2r = ((npy_longdouble *)ip2)[0];
        const npy_longdouble in2i = ((npy_longdouble *)ip2)[1];
        if (npy_isnan(in2r) || npy_isnan(in2i) || CLE(in1r, in1i, in2r, in2i)) {
            ((npy_longdouble *)op1)[0] = in1r;
            ((npy_longdouble *)op1)[1] = in1i;
        }
        else {
            ((npy_longdouble *)op1)[0] = in2r;
            ((npy_longdouble *)op1)[1] = in2i;
        }
    }
    npy_clear_floatstatus_barrier((char*)dimensions);
}


#define CLONGDOUBLE_true_divide CLONGDOUBLE_divide



#undef CGE
#undef CLE
#undef CGT
#undef CLT
#undef CEQ
#undef CNE

/*
 *****************************************************************************
 **                            OBJECT LOOPS                                 **
 *****************************************************************************
 */

#line 2902

#line 2907
NPY_NO_EXPORT void
OBJECT_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func)) {
    BINARY_LOOP {
        PyObject *ret_obj;
        PyObject *in1 = *(PyObject **)ip1;
        PyObject *in2 = *(PyObject **)ip2;

        in1 = in1 ? in1 : Py_None;
        in2 = in2 ? in2 : Py_None;

        /*
         * Do not use RichCompareBool because it includes an identity check for
         * == and !=. This is wrong for elementwise behaviour, since it means
         * that NaN can be equal to NaN and an array is equal to itself.
         */
        ret_obj = PyObject_RichCompare(in1, in2, Py_EQ);
        if (ret_obj == NULL) {
            return;
        }
#if 1
        {
            int ret = PyObject_IsTrue(ret_obj);
            Py_DECREF(ret_obj);
            if (ret == -1) {
                return;
            }
            *((npy_bool *)op1) = (npy_bool)ret;
        }
#else
        *((PyObject **)op1) = ret_obj;
#endif
    }
}

#line 2907
NPY_NO_EXPORT void
OBJECT_OO_O_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func)) {
    BINARY_LOOP {
        PyObject *ret_obj;
        PyObject *in1 = *(PyObject **)ip1;
        PyObject *in2 = *(PyObject **)ip2;

        in1 = in1 ? in1 : Py_None;
        in2 = in2 ? in2 : Py_None;

        /*
         * Do not use RichCompareBool because it includes an identity check for
         * == and !=. This is wrong for elementwise behaviour, since it means
         * that NaN can be equal to NaN and an array is equal to itself.
         */
        ret_obj = PyObject_RichCompare(in1, in2, Py_EQ);
        if (ret_obj == NULL) {
            return;
        }
#if 0
        {
            int ret = PyObject_IsTrue(ret_obj);
            Py_DECREF(ret_obj);
            if (ret == -1) {
                return;
            }
            *((npy_bool *)op1) = (npy_bool)ret;
        }
#else
        *((PyObject **)op1) = ret_obj;
#endif
    }
}


#line 2902

#line 2907
NPY_NO_EXPORT void
OBJECT_not_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func)) {
    BINARY_LOOP {
        PyObject *ret_obj;
        PyObject *in1 = *(PyObject **)ip1;
        PyObject *in2 = *(PyObject **)ip2;

        in1 = in1 ? in1 : Py_None;
        in2 = in2 ? in2 : Py_None;

        /*
         * Do not use RichCompareBool because it includes an identity check for
         * == and !=. This is wrong for elementwise behaviour, since it means
         * that NaN can be equal to NaN and an array is equal to itself.
         */
        ret_obj = PyObject_RichCompare(in1, in2, Py_NE);
        if (ret_obj == NULL) {
            return;
        }
#if 1
        {
            int ret = PyObject_IsTrue(ret_obj);
            Py_DECREF(ret_obj);
            if (ret == -1) {
                return;
            }
            *((npy_bool *)op1) = (npy_bool)ret;
        }
#else
        *((PyObject **)op1) = ret_obj;
#endif
    }
}

#line 2907
NPY_NO_EXPORT void
OBJECT_OO_O_not_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func)) {
    BINARY_LOOP {
        PyObject *ret_obj;
        PyObject *in1 = *(PyObject **)ip1;
        PyObject *in2 = *(PyObject **)ip2;

        in1 = in1 ? in1 : Py_None;
        in2 = in2 ? in2 : Py_None;

        /*
         * Do not use RichCompareBool because it includes an identity check for
         * == and !=. This is wrong for elementwise behaviour, since it means
         * that NaN can be equal to NaN and an array is equal to itself.
         */
        ret_obj = PyObject_RichCompare(in1, in2, Py_NE);
        if (ret_obj == NULL) {
            return;
        }
#if 0
        {
            int ret = PyObject_IsTrue(ret_obj);
            Py_DECREF(ret_obj);
            if (ret == -1) {
                return;
            }
            *((npy_bool *)op1) = (npy_bool)ret;
        }
#else
        *((PyObject **)op1) = ret_obj;
#endif
    }
}


#line 2902

#line 2907
NPY_NO_EXPORT void
OBJECT_greater(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func)) {
    BINARY_LOOP {
        PyObject *ret_obj;
        PyObject *in1 = *(PyObject **)ip1;
        PyObject *in2 = *(PyObject **)ip2;

        in1 = in1 ? in1 : Py_None;
        in2 = in2 ? in2 : Py_None;

        /*
         * Do not use RichCompareBool because it includes an identity check for
         * == and !=. This is wrong for elementwise behaviour, since it means
         * that NaN can be equal to NaN and an array is equal to itself.
         */
        ret_obj = PyObject_RichCompare(in1, in2, Py_GT);
        if (ret_obj == NULL) {
            return;
        }
#if 1
        {
            int ret = PyObject_IsTrue(ret_obj);
            Py_DECREF(ret_obj);
            if (ret == -1) {
                return;
            }
            *((npy_bool *)op1) = (npy_bool)ret;
        }
#else
        *((PyObject **)op1) = ret_obj;
#endif
    }
}

#line 2907
NPY_NO_EXPORT void
OBJECT_OO_O_greater(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func)) {
    BINARY_LOOP {
        PyObject *ret_obj;
        PyObject *in1 = *(PyObject **)ip1;
        PyObject *in2 = *(PyObject **)ip2;

        in1 = in1 ? in1 : Py_None;
        in2 = in2 ? in2 : Py_None;

        /*
         * Do not use RichCompareBool because it includes an identity check for
         * == and !=. This is wrong for elementwise behaviour, since it means
         * that NaN can be equal to NaN and an array is equal to itself.
         */
        ret_obj = PyObject_RichCompare(in1, in2, Py_GT);
        if (ret_obj == NULL) {
            return;
        }
#if 0
        {
            int ret = PyObject_IsTrue(ret_obj);
            Py_DECREF(ret_obj);
            if (ret == -1) {
                return;
            }
            *((npy_bool *)op1) = (npy_bool)ret;
        }
#else
        *((PyObject **)op1) = ret_obj;
#endif
    }
}


#line 2902

#line 2907
NPY_NO_EXPORT void
OBJECT_greater_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func)) {
    BINARY_LOOP {
        PyObject *ret_obj;
        PyObject *in1 = *(PyObject **)ip1;
        PyObject *in2 = *(PyObject **)ip2;

        in1 = in1 ? in1 : Py_None;
        in2 = in2 ? in2 : Py_None;

        /*
         * Do not use RichCompareBool because it includes an identity check for
         * == and !=. This is wrong for elementwise behaviour, since it means
         * that NaN can be equal to NaN and an array is equal to itself.
         */
        ret_obj = PyObject_RichCompare(in1, in2, Py_GE);
        if (ret_obj == NULL) {
            return;
        }
#if 1
        {
            int ret = PyObject_IsTrue(ret_obj);
            Py_DECREF(ret_obj);
            if (ret == -1) {
                return;
            }
            *((npy_bool *)op1) = (npy_bool)ret;
        }
#else
        *((PyObject **)op1) = ret_obj;
#endif
    }
}

#line 2907
NPY_NO_EXPORT void
OBJECT_OO_O_greater_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func)) {
    BINARY_LOOP {
        PyObject *ret_obj;
        PyObject *in1 = *(PyObject **)ip1;
        PyObject *in2 = *(PyObject **)ip2;

        in1 = in1 ? in1 : Py_None;
        in2 = in2 ? in2 : Py_None;

        /*
         * Do not use RichCompareBool because it includes an identity check for
         * == and !=. This is wrong for elementwise behaviour, since it means
         * that NaN can be equal to NaN and an array is equal to itself.
         */
        ret_obj = PyObject_RichCompare(in1, in2, Py_GE);
        if (ret_obj == NULL) {
            return;
        }
#if 0
        {
            int ret = PyObject_IsTrue(ret_obj);
            Py_DECREF(ret_obj);
            if (ret == -1) {
                return;
            }
            *((npy_bool *)op1) = (npy_bool)ret;
        }
#else
        *((PyObject **)op1) = ret_obj;
#endif
    }
}


#line 2902

#line 2907
NPY_NO_EXPORT void
OBJECT_less(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func)) {
    BINARY_LOOP {
        PyObject *ret_obj;
        PyObject *in1 = *(PyObject **)ip1;
        PyObject *in2 = *(PyObject **)ip2;

        in1 = in1 ? in1 : Py_None;
        in2 = in2 ? in2 : Py_None;

        /*
         * Do not use RichCompareBool because it includes an identity check for
         * == and !=. This is wrong for elementwise behaviour, since it means
         * that NaN can be equal to NaN and an array is equal to itself.
         */
        ret_obj = PyObject_RichCompare(in1, in2, Py_LT);
        if (ret_obj == NULL) {
            return;
        }
#if 1
        {
            int ret = PyObject_IsTrue(ret_obj);
            Py_DECREF(ret_obj);
            if (ret == -1) {
                return;
            }
            *((npy_bool *)op1) = (npy_bool)ret;
        }
#else
        *((PyObject **)op1) = ret_obj;
#endif
    }
}

#line 2907
NPY_NO_EXPORT void
OBJECT_OO_O_less(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func)) {
    BINARY_LOOP {
        PyObject *ret_obj;
        PyObject *in1 = *(PyObject **)ip1;
        PyObject *in2 = *(PyObject **)ip2;

        in1 = in1 ? in1 : Py_None;
        in2 = in2 ? in2 : Py_None;

        /*
         * Do not use RichCompareBool because it includes an identity check for
         * == and !=. This is wrong for elementwise behaviour, since it means
         * that NaN can be equal to NaN and an array is equal to itself.
         */
        ret_obj = PyObject_RichCompare(in1, in2, Py_LT);
        if (ret_obj == NULL) {
            return;
        }
#if 0
        {
            int ret = PyObject_IsTrue(ret_obj);
            Py_DECREF(ret_obj);
            if (ret == -1) {
                return;
            }
            *((npy_bool *)op1) = (npy_bool)ret;
        }
#else
        *((PyObject **)op1) = ret_obj;
#endif
    }
}


#line 2902

#line 2907
NPY_NO_EXPORT void
OBJECT_less_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func)) {
    BINARY_LOOP {
        PyObject *ret_obj;
        PyObject *in1 = *(PyObject **)ip1;
        PyObject *in2 = *(PyObject **)ip2;

        in1 = in1 ? in1 : Py_None;
        in2 = in2 ? in2 : Py_None;

        /*
         * Do not use RichCompareBool because it includes an identity check for
         * == and !=. This is wrong for elementwise behaviour, since it means
         * that NaN can be equal to NaN and an array is equal to itself.
         */
        ret_obj = PyObject_RichCompare(in1, in2, Py_LE);
        if (ret_obj == NULL) {
            return;
        }
#if 1
        {
            int ret = PyObject_IsTrue(ret_obj);
            Py_DECREF(ret_obj);
            if (ret == -1) {
                return;
            }
            *((npy_bool *)op1) = (npy_bool)ret;
        }
#else
        *((PyObject **)op1) = ret_obj;
#endif
    }
}

#line 2907
NPY_NO_EXPORT void
OBJECT_OO_O_less_equal(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func)) {
    BINARY_LOOP {
        PyObject *ret_obj;
        PyObject *in1 = *(PyObject **)ip1;
        PyObject *in2 = *(PyObject **)ip2;

        in1 = in1 ? in1 : Py_None;
        in2 = in2 ? in2 : Py_None;

        /*
         * Do not use RichCompareBool because it includes an identity check for
         * == and !=. This is wrong for elementwise behaviour, since it means
         * that NaN can be equal to NaN and an array is equal to itself.
         */
        ret_obj = PyObject_RichCompare(in1, in2, Py_LE);
        if (ret_obj == NULL) {
            return;
        }
#if 0
        {
            int ret = PyObject_IsTrue(ret_obj);
            Py_DECREF(ret_obj);
            if (ret == -1) {
                return;
            }
            *((npy_bool *)op1) = (npy_bool)ret;
        }
#else
        *((PyObject **)op1) = ret_obj;
#endif
    }
}



NPY_NO_EXPORT void
OBJECT_sign(char **args, npy_intp *dimensions, npy_intp *steps, void *NPY_UNUSED(func))
{
    PyObject *zero = PyLong_FromLong(0);

    UNARY_LOOP {
        PyObject *in1 = *(PyObject **)ip1;
        PyObject **out = (PyObject **)op1;
        PyObject *ret = NULL;
        int v;

        if (in1 == NULL) {
            in1 = Py_None;
        }

        if ((v = PyObject_RichCompareBool(in1, zero, Py_LT)) == 1) {
            ret = PyLong_FromLong(-1);
        }
        else if (v == 0 &&
                (v = PyObject_RichCompareBool(in1, zero, Py_GT)) == 1) {
            ret = PyLong_FromLong(1);
        }
        else if (v == 0 &&
                (v = PyObject_RichCompareBool(in1, zero, Py_EQ)) == 1) {
            ret = PyLong_FromLong(0);
        }
        else if (v == 0) {
            /* in1 is NaN */
            PyErr_SetString(PyExc_TypeError,
                    "unorderable types for comparison");
        }

        if (ret == NULL) {
            break;
        }
        Py_XDECREF(*out);
        *out = ret;
    }
    Py_XDECREF(zero);
}

/*
 *****************************************************************************
 **                              END LOOPS                                  **
 *****************************************************************************
 */

