#line 1 "numpy/core/src/umath/scalarmath.c.src"

/*
 *****************************************************************************
 **       This file was autogenerated from a template  DO NOT EDIT!!!!      **
 **       Changes should be made to the original source (.src) file         **
 *****************************************************************************
 */

#line 1
/* -*- c -*- */

/* The purpose of this module is to add faster math for array scalars
   that does not go through the ufunc machinery

   but still supports error-modes.
*/

#define _UMATHMODULE
#define _MULTIARRAYMODULE
#define NPY_NO_DEPRECATED_API NPY_API_VERSION

#include "Python.h"
#include "npy_config.h"
#include "numpy/arrayobject.h"
#include "numpy/ufuncobject.h"
#include "numpy/arrayscalars.h"

#include "npy_pycompat.h"

#include "numpy/halffloat.h"
#include "templ_common.h"

#include "binop_override.h"
#include "npy_longdouble.h"

/* Basic operations:
 *
 *  BINARY:
 *
 * add, subtract, multiply, divide, remainder, divmod, power,
 * floor_divide, true_divide
 *
 * lshift, rshift, and, or, xor (integers only)
 *
 * UNARY:
 *
 * negative, positive, absolute, nonzero, invert, int, long, float, oct, hex
 *
 */

#line 46
static void
byte_ctype_add(npy_byte a, npy_byte b, npy_byte *out) {
    *out = a + b;
    if ((*out^a) >= 0 || (*out^b) >= 0) {
        return;
    }
    npy_set_floatstatus_overflow();
    return;
}
static void
byte_ctype_subtract(npy_byte a, npy_byte b, npy_byte *out) {
    *out = a - b;
    if ((*out^a) >= 0 || (*out^~b) >= 0) {
        return;
    }
    npy_set_floatstatus_overflow();
    return;
}

#line 46
static void
short_ctype_add(npy_short a, npy_short b, npy_short *out) {
    *out = a + b;
    if ((*out^a) >= 0 || (*out^b) >= 0) {
        return;
    }
    npy_set_floatstatus_overflow();
    return;
}
static void
short_ctype_subtract(npy_short a, npy_short b, npy_short *out) {
    *out = a - b;
    if ((*out^a) >= 0 || (*out^~b) >= 0) {
        return;
    }
    npy_set_floatstatus_overflow();
    return;
}

#line 46
static void
int_ctype_add(npy_int a, npy_int b, npy_int *out) {
    *out = a + b;
    if ((*out^a) >= 0 || (*out^b) >= 0) {
        return;
    }
    npy_set_floatstatus_overflow();
    return;
}
static void
int_ctype_subtract(npy_int a, npy_int b, npy_int *out) {
    *out = a - b;
    if ((*out^a) >= 0 || (*out^~b) >= 0) {
        return;
    }
    npy_set_floatstatus_overflow();
    return;
}

#line 46
static void
long_ctype_add(npy_long a, npy_long b, npy_long *out) {
    *out = a + b;
    if ((*out^a) >= 0 || (*out^b) >= 0) {
        return;
    }
    npy_set_floatstatus_overflow();
    return;
}
static void
long_ctype_subtract(npy_long a, npy_long b, npy_long *out) {
    *out = a - b;
    if ((*out^a) >= 0 || (*out^~b) >= 0) {
        return;
    }
    npy_set_floatstatus_overflow();
    return;
}

#line 46
static void
longlong_ctype_add(npy_longlong a, npy_longlong b, npy_longlong *out) {
    *out = a + b;
    if ((*out^a) >= 0 || (*out^b) >= 0) {
        return;
    }
    npy_set_floatstatus_overflow();
    return;
}
static void
longlong_ctype_subtract(npy_longlong a, npy_longlong b, npy_longlong *out) {
    *out = a - b;
    if ((*out^a) >= 0 || (*out^~b) >= 0) {
        return;
    }
    npy_set_floatstatus_overflow();
    return;
}


#line 70
static void
ubyte_ctype_add(npy_ubyte a, npy_ubyte b, npy_ubyte *out) {
    *out = a + b;
    if (*out >= a && *out >= b) {
        return;
    }
    npy_set_floatstatus_overflow();
    return;
}
static void
ubyte_ctype_subtract(npy_ubyte a, npy_ubyte b, npy_ubyte *out) {
    *out = a - b;
    if (a >= b) {
        return;
    }
    npy_set_floatstatus_overflow();
    return;
}

#line 70
static void
ushort_ctype_add(npy_ushort a, npy_ushort b, npy_ushort *out) {
    *out = a + b;
    if (*out >= a && *out >= b) {
        return;
    }
    npy_set_floatstatus_overflow();
    return;
}
static void
ushort_ctype_subtract(npy_ushort a, npy_ushort b, npy_ushort *out) {
    *out = a - b;
    if (a >= b) {
        return;
    }
    npy_set_floatstatus_overflow();
    return;
}

#line 70
static void
uint_ctype_add(npy_uint a, npy_uint b, npy_uint *out) {
    *out = a + b;
    if (*out >= a && *out >= b) {
        return;
    }
    npy_set_floatstatus_overflow();
    return;
}
static void
uint_ctype_subtract(npy_uint a, npy_uint b, npy_uint *out) {
    *out = a - b;
    if (a >= b) {
        return;
    }
    npy_set_floatstatus_overflow();
    return;
}

#line 70
static void
ulong_ctype_add(npy_ulong a, npy_ulong b, npy_ulong *out) {
    *out = a + b;
    if (*out >= a && *out >= b) {
        return;
    }
    npy_set_floatstatus_overflow();
    return;
}
static void
ulong_ctype_subtract(npy_ulong a, npy_ulong b, npy_ulong *out) {
    *out = a - b;
    if (a >= b) {
        return;
    }
    npy_set_floatstatus_overflow();
    return;
}

#line 70
static void
ulonglong_ctype_add(npy_ulonglong a, npy_ulonglong b, npy_ulonglong *out) {
    *out = a + b;
    if (*out >= a && *out >= b) {
        return;
    }
    npy_set_floatstatus_overflow();
    return;
}
static void
ulonglong_ctype_subtract(npy_ulonglong a, npy_ulonglong b, npy_ulonglong *out) {
    *out = a - b;
    if (a >= b) {
        return;
    }
    npy_set_floatstatus_overflow();
    return;
}


#ifndef NPY_SIZEOF_BYTE
#define NPY_SIZEOF_BYTE 1
#endif

#line 108
#if NPY_SIZEOF_INT > NPY_SIZEOF_BYTE
static void
byte_ctype_multiply(npy_byte a, npy_byte b, npy_byte *out) {
    npy_int temp;
    temp = ((npy_int) a) * ((npy_int) b);
    *out = (npy_byte) temp;
#if 1
    if (temp > NPY_MAX_BYTE || temp < NPY_MIN_BYTE)
#else
        if (temp > NPY_MAX_BYTE)
#endif
            npy_set_floatstatus_overflow();
    return;
}
#endif

#line 108
#if NPY_SIZEOF_INT > NPY_SIZEOF_BYTE
static void
ubyte_ctype_multiply(npy_ubyte a, npy_ubyte b, npy_ubyte *out) {
    npy_uint temp;
    temp = ((npy_uint) a) * ((npy_uint) b);
    *out = (npy_ubyte) temp;
#if 0
    if (temp > NPY_MAX_UBYTE || temp < NPY_MIN_UBYTE)
#else
        if (temp > NPY_MAX_UBYTE)
#endif
            npy_set_floatstatus_overflow();
    return;
}
#endif

#line 108
#if NPY_SIZEOF_INT > NPY_SIZEOF_SHORT
static void
short_ctype_multiply(npy_short a, npy_short b, npy_short *out) {
    npy_int temp;
    temp = ((npy_int) a) * ((npy_int) b);
    *out = (npy_short) temp;
#if 1
    if (temp > NPY_MAX_SHORT || temp < NPY_MIN_SHORT)
#else
        if (temp > NPY_MAX_SHORT)
#endif
            npy_set_floatstatus_overflow();
    return;
}
#endif

#line 108
#if NPY_SIZEOF_INT > NPY_SIZEOF_SHORT
static void
ushort_ctype_multiply(npy_ushort a, npy_ushort b, npy_ushort *out) {
    npy_uint temp;
    temp = ((npy_uint) a) * ((npy_uint) b);
    *out = (npy_ushort) temp;
#if 0
    if (temp > NPY_MAX_USHORT || temp < NPY_MIN_USHORT)
#else
        if (temp > NPY_MAX_USHORT)
#endif
            npy_set_floatstatus_overflow();
    return;
}
#endif

#line 108
#if NPY_SIZEOF_LONGLONG > NPY_SIZEOF_INT
static void
int_ctype_multiply(npy_int a, npy_int b, npy_int *out) {
    npy_longlong temp;
    temp = ((npy_longlong) a) * ((npy_longlong) b);
    *out = (npy_int) temp;
#if 1
    if (temp > NPY_MAX_INT || temp < NPY_MIN_INT)
#else
        if (temp > NPY_MAX_INT)
#endif
            npy_set_floatstatus_overflow();
    return;
}
#endif

#line 108
#if NPY_SIZEOF_LONGLONG > NPY_SIZEOF_INT
static void
uint_ctype_multiply(npy_uint a, npy_uint b, npy_uint *out) {
    npy_ulonglong temp;
    temp = ((npy_ulonglong) a) * ((npy_ulonglong) b);
    *out = (npy_uint) temp;
#if 0
    if (temp > NPY_MAX_UINT || temp < NPY_MIN_UINT)
#else
        if (temp > NPY_MAX_UINT)
#endif
            npy_set_floatstatus_overflow();
    return;
}
#endif

#line 108
#if NPY_SIZEOF_LONGLONG > NPY_SIZEOF_LONG
static void
long_ctype_multiply(npy_long a, npy_long b, npy_long *out) {
    npy_longlong temp;
    temp = ((npy_longlong) a) * ((npy_longlong) b);
    *out = (npy_long) temp;
#if 1
    if (temp > NPY_MAX_LONG || temp < NPY_MIN_LONG)
#else
        if (temp > NPY_MAX_LONG)
#endif
            npy_set_floatstatus_overflow();
    return;
}
#endif

#line 108
#if NPY_SIZEOF_LONGLONG > NPY_SIZEOF_LONG
static void
ulong_ctype_multiply(npy_ulong a, npy_ulong b, npy_ulong *out) {
    npy_ulonglong temp;
    temp = ((npy_ulonglong) a) * ((npy_ulonglong) b);
    *out = (npy_ulong) temp;
#if 0
    if (temp > NPY_MAX_ULONG || temp < NPY_MIN_ULONG)
#else
        if (temp > NPY_MAX_ULONG)
#endif
            npy_set_floatstatus_overflow();
    return;
}
#endif


#line 133
#if NPY_SIZEOF_LONGLONG == NPY_SIZEOF_INT
static void
int_ctype_multiply(npy_int a, npy_int b, npy_int *out) {
    if (npy_mul_with_overflow_int(out, a, b)) {
        npy_set_floatstatus_overflow();
    }
    return;
}
#endif

#line 133
#if NPY_SIZEOF_LONGLONG == NPY_SIZEOF_INT
static void
uint_ctype_multiply(npy_uint a, npy_uint b, npy_uint *out) {
    if (npy_mul_with_overflow_uint(out, a, b)) {
        npy_set_floatstatus_overflow();
    }
    return;
}
#endif

#line 133
#if NPY_SIZEOF_LONGLONG == NPY_SIZEOF_LONG
static void
long_ctype_multiply(npy_long a, npy_long b, npy_long *out) {
    if (npy_mul_with_overflow_long(out, a, b)) {
        npy_set_floatstatus_overflow();
    }
    return;
}
#endif

#line 133
#if NPY_SIZEOF_LONGLONG == NPY_SIZEOF_LONG
static void
ulong_ctype_multiply(npy_ulong a, npy_ulong b, npy_ulong *out) {
    if (npy_mul_with_overflow_ulong(out, a, b)) {
        npy_set_floatstatus_overflow();
    }
    return;
}
#endif

#line 133
#if NPY_SIZEOF_LONGLONG == NPY_SIZEOF_LONGLONG
static void
longlong_ctype_multiply(npy_longlong a, npy_longlong b, npy_longlong *out) {
    if (npy_mul_with_overflow_longlong(out, a, b)) {
        npy_set_floatstatus_overflow();
    }
    return;
}
#endif

#line 133
#if NPY_SIZEOF_LONGLONG == NPY_SIZEOF_LONGLONG
static void
ulonglong_ctype_multiply(npy_ulonglong a, npy_ulonglong b, npy_ulonglong *out) {
    if (npy_mul_with_overflow_ulonglong(out, a, b)) {
        npy_set_floatstatus_overflow();
    }
    return;
}
#endif


#line 152
static void
byte_ctype_divide(npy_byte a, npy_byte b, npy_byte *out) {
    if (b == 0) {
        npy_set_floatstatus_divbyzero();
        *out = 0;
    }
#if 1
    else if (b == -1 && a < 0 && a == -a) {
        npy_set_floatstatus_overflow();
        *out = a / b;
    }
#endif
    else {
#if 1
        npy_byte tmp;
        tmp = a / b;
        if (((a > 0) != (b > 0)) && (a % b != 0)) {
            tmp--;
        }
        *out = tmp;
#else
        *out = a / b;
#endif
    }
}

#define byte_ctype_floor_divide byte_ctype_divide

static void
byte_ctype_remainder(npy_byte a, npy_byte b, npy_byte *out) {
    if (a == 0 || b == 0) {
        if (b == 0) npy_set_floatstatus_divbyzero();
        *out = 0;
        return;
    }
#if 1
    else if ((a > 0) == (b > 0)) {
        *out = a % b;
    }
    else {
        /* handled like Python does */
        *out = a % b;
        if (*out) *out += b;
    }
#else
    *out = a % b;
#endif
}

#line 152
static void
ubyte_ctype_divide(npy_ubyte a, npy_ubyte b, npy_ubyte *out) {
    if (b == 0) {
        npy_set_floatstatus_divbyzero();
        *out = 0;
    }
#if 0
    else if (b == -1 && a < 0 && a == -a) {
        npy_set_floatstatus_overflow();
        *out = a / b;
    }
#endif
    else {
#if 0
        npy_ubyte tmp;
        tmp = a / b;
        if (((a > 0) != (b > 0)) && (a % b != 0)) {
            tmp--;
        }
        *out = tmp;
#else
        *out = a / b;
#endif
    }
}

#define ubyte_ctype_floor_divide ubyte_ctype_divide

static void
ubyte_ctype_remainder(npy_ubyte a, npy_ubyte b, npy_ubyte *out) {
    if (a == 0 || b == 0) {
        if (b == 0) npy_set_floatstatus_divbyzero();
        *out = 0;
        return;
    }
#if 0
    else if ((a > 0) == (b > 0)) {
        *out = a % b;
    }
    else {
        /* handled like Python does */
        *out = a % b;
        if (*out) *out += b;
    }
#else
    *out = a % b;
#endif
}

#line 152
static void
short_ctype_divide(npy_short a, npy_short b, npy_short *out) {
    if (b == 0) {
        npy_set_floatstatus_divbyzero();
        *out = 0;
    }
#if 1
    else if (b == -1 && a < 0 && a == -a) {
        npy_set_floatstatus_overflow();
        *out = a / b;
    }
#endif
    else {
#if 1
        npy_short tmp;
        tmp = a / b;
        if (((a > 0) != (b > 0)) && (a % b != 0)) {
            tmp--;
        }
        *out = tmp;
#else
        *out = a / b;
#endif
    }
}

#define short_ctype_floor_divide short_ctype_divide

static void
short_ctype_remainder(npy_short a, npy_short b, npy_short *out) {
    if (a == 0 || b == 0) {
        if (b == 0) npy_set_floatstatus_divbyzero();
        *out = 0;
        return;
    }
#if 1
    else if ((a > 0) == (b > 0)) {
        *out = a % b;
    }
    else {
        /* handled like Python does */
        *out = a % b;
        if (*out) *out += b;
    }
#else
    *out = a % b;
#endif
}

#line 152
static void
ushort_ctype_divide(npy_ushort a, npy_ushort b, npy_ushort *out) {
    if (b == 0) {
        npy_set_floatstatus_divbyzero();
        *out = 0;
    }
#if 0
    else if (b == -1 && a < 0 && a == -a) {
        npy_set_floatstatus_overflow();
        *out = a / b;
    }
#endif
    else {
#if 0
        npy_ushort tmp;
        tmp = a / b;
        if (((a > 0) != (b > 0)) && (a % b != 0)) {
            tmp--;
        }
        *out = tmp;
#else
        *out = a / b;
#endif
    }
}

#define ushort_ctype_floor_divide ushort_ctype_divide

static void
ushort_ctype_remainder(npy_ushort a, npy_ushort b, npy_ushort *out) {
    if (a == 0 || b == 0) {
        if (b == 0) npy_set_floatstatus_divbyzero();
        *out = 0;
        return;
    }
#if 0
    else if ((a > 0) == (b > 0)) {
        *out = a % b;
    }
    else {
        /* handled like Python does */
        *out = a % b;
        if (*out) *out += b;
    }
#else
    *out = a % b;
#endif
}

#line 152
static void
int_ctype_divide(npy_int a, npy_int b, npy_int *out) {
    if (b == 0) {
        npy_set_floatstatus_divbyzero();
        *out = 0;
    }
#if 1
    else if (b == -1 && a < 0 && a == -a) {
        npy_set_floatstatus_overflow();
        *out = a / b;
    }
#endif
    else {
#if 1
        npy_int tmp;
        tmp = a / b;
        if (((a > 0) != (b > 0)) && (a % b != 0)) {
            tmp--;
        }
        *out = tmp;
#else
        *out = a / b;
#endif
    }
}

#define int_ctype_floor_divide int_ctype_divide

static void
int_ctype_remainder(npy_int a, npy_int b, npy_int *out) {
    if (a == 0 || b == 0) {
        if (b == 0) npy_set_floatstatus_divbyzero();
        *out = 0;
        return;
    }
#if 1
    else if ((a > 0) == (b > 0)) {
        *out = a % b;
    }
    else {
        /* handled like Python does */
        *out = a % b;
        if (*out) *out += b;
    }
#else
    *out = a % b;
#endif
}

#line 152
static void
uint_ctype_divide(npy_uint a, npy_uint b, npy_uint *out) {
    if (b == 0) {
        npy_set_floatstatus_divbyzero();
        *out = 0;
    }
#if 0
    else if (b == -1 && a < 0 && a == -a) {
        npy_set_floatstatus_overflow();
        *out = a / b;
    }
#endif
    else {
#if 0
        npy_uint tmp;
        tmp = a / b;
        if (((a > 0) != (b > 0)) && (a % b != 0)) {
            tmp--;
        }
        *out = tmp;
#else
        *out = a / b;
#endif
    }
}

#define uint_ctype_floor_divide uint_ctype_divide

static void
uint_ctype_remainder(npy_uint a, npy_uint b, npy_uint *out) {
    if (a == 0 || b == 0) {
        if (b == 0) npy_set_floatstatus_divbyzero();
        *out = 0;
        return;
    }
#if 0
    else if ((a > 0) == (b > 0)) {
        *out = a % b;
    }
    else {
        /* handled like Python does */
        *out = a % b;
        if (*out) *out += b;
    }
#else
    *out = a % b;
#endif
}

#line 152
static void
long_ctype_divide(npy_long a, npy_long b, npy_long *out) {
    if (b == 0) {
        npy_set_floatstatus_divbyzero();
        *out = 0;
    }
#if 1
    else if (b == -1 && a < 0 && a == -a) {
        npy_set_floatstatus_overflow();
        *out = a / b;
    }
#endif
    else {
#if 1
        npy_long tmp;
        tmp = a / b;
        if (((a > 0) != (b > 0)) && (a % b != 0)) {
            tmp--;
        }
        *out = tmp;
#else
        *out = a / b;
#endif
    }
}

#define long_ctype_floor_divide long_ctype_divide

static void
long_ctype_remainder(npy_long a, npy_long b, npy_long *out) {
    if (a == 0 || b == 0) {
        if (b == 0) npy_set_floatstatus_divbyzero();
        *out = 0;
        return;
    }
#if 1
    else if ((a > 0) == (b > 0)) {
        *out = a % b;
    }
    else {
        /* handled like Python does */
        *out = a % b;
        if (*out) *out += b;
    }
#else
    *out = a % b;
#endif
}

#line 152
static void
ulong_ctype_divide(npy_ulong a, npy_ulong b, npy_ulong *out) {
    if (b == 0) {
        npy_set_floatstatus_divbyzero();
        *out = 0;
    }
#if 0
    else if (b == -1 && a < 0 && a == -a) {
        npy_set_floatstatus_overflow();
        *out = a / b;
    }
#endif
    else {
#if 0
        npy_ulong tmp;
        tmp = a / b;
        if (((a > 0) != (b > 0)) && (a % b != 0)) {
            tmp--;
        }
        *out = tmp;
#else
        *out = a / b;
#endif
    }
}

#define ulong_ctype_floor_divide ulong_ctype_divide

static void
ulong_ctype_remainder(npy_ulong a, npy_ulong b, npy_ulong *out) {
    if (a == 0 || b == 0) {
        if (b == 0) npy_set_floatstatus_divbyzero();
        *out = 0;
        return;
    }
#if 0
    else if ((a > 0) == (b > 0)) {
        *out = a % b;
    }
    else {
        /* handled like Python does */
        *out = a % b;
        if (*out) *out += b;
    }
#else
    *out = a % b;
#endif
}

#line 152
static void
longlong_ctype_divide(npy_longlong a, npy_longlong b, npy_longlong *out) {
    if (b == 0) {
        npy_set_floatstatus_divbyzero();
        *out = 0;
    }
#if 1
    else if (b == -1 && a < 0 && a == -a) {
        npy_set_floatstatus_overflow();
        *out = a / b;
    }
#endif
    else {
#if 1
        npy_longlong tmp;
        tmp = a / b;
        if (((a > 0) != (b > 0)) && (a % b != 0)) {
            tmp--;
        }
        *out = tmp;
#else
        *out = a / b;
#endif
    }
}

#define longlong_ctype_floor_divide longlong_ctype_divide

static void
longlong_ctype_remainder(npy_longlong a, npy_longlong b, npy_longlong *out) {
    if (a == 0 || b == 0) {
        if (b == 0) npy_set_floatstatus_divbyzero();
        *out = 0;
        return;
    }
#if 1
    else if ((a > 0) == (b > 0)) {
        *out = a % b;
    }
    else {
        /* handled like Python does */
        *out = a % b;
        if (*out) *out += b;
    }
#else
    *out = a % b;
#endif
}

#line 152
static void
ulonglong_ctype_divide(npy_ulonglong a, npy_ulonglong b, npy_ulonglong *out) {
    if (b == 0) {
        npy_set_floatstatus_divbyzero();
        *out = 0;
    }
#if 0
    else if (b == -1 && a < 0 && a == -a) {
        npy_set_floatstatus_overflow();
        *out = a / b;
    }
#endif
    else {
#if 0
        npy_ulonglong tmp;
        tmp = a / b;
        if (((a > 0) != (b > 0)) && (a % b != 0)) {
            tmp--;
        }
        *out = tmp;
#else
        *out = a / b;
#endif
    }
}

#define ulonglong_ctype_floor_divide ulonglong_ctype_divide

static void
ulonglong_ctype_remainder(npy_ulonglong a, npy_ulonglong b, npy_ulonglong *out) {
    if (a == 0 || b == 0) {
        if (b == 0) npy_set_floatstatus_divbyzero();
        *out = 0;
        return;
    }
#if 0
    else if ((a > 0) == (b > 0)) {
        *out = a % b;
    }
    else {
        /* handled like Python does */
        *out = a % b;
        if (*out) *out += b;
    }
#else
    *out = a % b;
#endif
}


#line 208
#define byte_ctype_true_divide(a, b, out)     \
    *(out) = ((npy_float) (a)) / ((npy_float) (b));

#line 208
#define ubyte_ctype_true_divide(a, b, out)     \
    *(out) = ((npy_float) (a)) / ((npy_float) (b));

#line 208
#define short_ctype_true_divide(a, b, out)     \
    *(out) = ((npy_float) (a)) / ((npy_float) (b));

#line 208
#define ushort_ctype_true_divide(a, b, out)     \
    *(out) = ((npy_float) (a)) / ((npy_float) (b));

#line 208
#define int_ctype_true_divide(a, b, out)     \
    *(out) = ((npy_double) (a)) / ((npy_double) (b));

#line 208
#define uint_ctype_true_divide(a, b, out)     \
    *(out) = ((npy_double) (a)) / ((npy_double) (b));

#line 208
#define long_ctype_true_divide(a, b, out)     \
    *(out) = ((npy_double) (a)) / ((npy_double) (b));

#line 208
#define ulong_ctype_true_divide(a, b, out)     \
    *(out) = ((npy_double) (a)) / ((npy_double) (b));

#line 208
#define longlong_ctype_true_divide(a, b, out)     \
    *(out) = ((npy_double) (a)) / ((npy_double) (b));

#line 208
#define ulonglong_ctype_true_divide(a, b, out)     \
    *(out) = ((npy_double) (a)) / ((npy_double) (b));


/* b will always be positive in this call */
#line 222
static void
byte_ctype_power(npy_byte a, npy_byte b, npy_byte *out) {
    npy_byte tmp;

    if (b == 0) {
        *out = 1;
        return;
    }
    if (a == 1) {
        *out = 1;
        return;
    }

    tmp = b & 1 ? a : 1;
    b >>= 1;
    while (b > 0) {
        a *= a;
        if (b & 1) {
            tmp *= a;
        }
        b >>= 1;
    }
    *out = tmp;
}

#line 222
static void
ubyte_ctype_power(npy_ubyte a, npy_ubyte b, npy_ubyte *out) {
    npy_ubyte tmp;

    if (b == 0) {
        *out = 1;
        return;
    }
    if (a == 1) {
        *out = 1;
        return;
    }

    tmp = b & 1 ? a : 1;
    b >>= 1;
    while (b > 0) {
        a *= a;
        if (b & 1) {
            tmp *= a;
        }
        b >>= 1;
    }
    *out = tmp;
}

#line 222
static void
short_ctype_power(npy_short a, npy_short b, npy_short *out) {
    npy_short tmp;

    if (b == 0) {
        *out = 1;
        return;
    }
    if (a == 1) {
        *out = 1;
        return;
    }

    tmp = b & 1 ? a : 1;
    b >>= 1;
    while (b > 0) {
        a *= a;
        if (b & 1) {
            tmp *= a;
        }
        b >>= 1;
    }
    *out = tmp;
}

#line 222
static void
ushort_ctype_power(npy_ushort a, npy_ushort b, npy_ushort *out) {
    npy_ushort tmp;

    if (b == 0) {
        *out = 1;
        return;
    }
    if (a == 1) {
        *out = 1;
        return;
    }

    tmp = b & 1 ? a : 1;
    b >>= 1;
    while (b > 0) {
        a *= a;
        if (b & 1) {
            tmp *= a;
        }
        b >>= 1;
    }
    *out = tmp;
}

#line 222
static void
int_ctype_power(npy_int a, npy_int b, npy_int *out) {
    npy_int tmp;

    if (b == 0) {
        *out = 1;
        return;
    }
    if (a == 1) {
        *out = 1;
        return;
    }

    tmp = b & 1 ? a : 1;
    b >>= 1;
    while (b > 0) {
        a *= a;
        if (b & 1) {
            tmp *= a;
        }
        b >>= 1;
    }
    *out = tmp;
}

#line 222
static void
uint_ctype_power(npy_uint a, npy_uint b, npy_uint *out) {
    npy_uint tmp;

    if (b == 0) {
        *out = 1;
        return;
    }
    if (a == 1) {
        *out = 1;
        return;
    }

    tmp = b & 1 ? a : 1;
    b >>= 1;
    while (b > 0) {
        a *= a;
        if (b & 1) {
            tmp *= a;
        }
        b >>= 1;
    }
    *out = tmp;
}

#line 222
static void
long_ctype_power(npy_long a, npy_long b, npy_long *out) {
    npy_long tmp;

    if (b == 0) {
        *out = 1;
        return;
    }
    if (a == 1) {
        *out = 1;
        return;
    }

    tmp = b & 1 ? a : 1;
    b >>= 1;
    while (b > 0) {
        a *= a;
        if (b & 1) {
            tmp *= a;
        }
        b >>= 1;
    }
    *out = tmp;
}

#line 222
static void
ulong_ctype_power(npy_ulong a, npy_ulong b, npy_ulong *out) {
    npy_ulong tmp;

    if (b == 0) {
        *out = 1;
        return;
    }
    if (a == 1) {
        *out = 1;
        return;
    }

    tmp = b & 1 ? a : 1;
    b >>= 1;
    while (b > 0) {
        a *= a;
        if (b & 1) {
            tmp *= a;
        }
        b >>= 1;
    }
    *out = tmp;
}

#line 222
static void
longlong_ctype_power(npy_longlong a, npy_longlong b, npy_longlong *out) {
    npy_longlong tmp;

    if (b == 0) {
        *out = 1;
        return;
    }
    if (a == 1) {
        *out = 1;
        return;
    }

    tmp = b & 1 ? a : 1;
    b >>= 1;
    while (b > 0) {
        a *= a;
        if (b & 1) {
            tmp *= a;
        }
        b >>= 1;
    }
    *out = tmp;
}

#line 222
static void
ulonglong_ctype_power(npy_ulonglong a, npy_ulonglong b, npy_ulonglong *out) {
    npy_ulonglong tmp;

    if (b == 0) {
        *out = 1;
        return;
    }
    if (a == 1) {
        *out = 1;
        return;
    }

    tmp = b & 1 ? a : 1;
    b >>= 1;
    while (b > 0) {
        a *= a;
        if (b & 1) {
            tmp *= a;
        }
        b >>= 1;
    }
    *out = tmp;
}




/* QUESTION:  Should we check for overflow / underflow in (l,r)shift? */

#line 258

#line 263

#define byte_ctype_and(arg1, arg2, out) *(out) = (arg1) & (arg2)


#line 263

#define byte_ctype_xor(arg1, arg2, out) *(out) = (arg1) ^ (arg2)


#line 263

#define byte_ctype_or(arg1, arg2, out) *(out) = (arg1) | (arg2)


#line 263

#define byte_ctype_lshift(arg1, arg2, out) *(out) = (arg1) << (arg2)


#line 263

#define byte_ctype_rshift(arg1, arg2, out) *(out) = (arg1) >> (arg2)




#line 258

#line 263

#define ubyte_ctype_and(arg1, arg2, out) *(out) = (arg1) & (arg2)


#line 263

#define ubyte_ctype_xor(arg1, arg2, out) *(out) = (arg1) ^ (arg2)


#line 263

#define ubyte_ctype_or(arg1, arg2, out) *(out) = (arg1) | (arg2)


#line 263

#define ubyte_ctype_lshift(arg1, arg2, out) *(out) = (arg1) << (arg2)


#line 263

#define ubyte_ctype_rshift(arg1, arg2, out) *(out) = (arg1) >> (arg2)




#line 258

#line 263

#define short_ctype_and(arg1, arg2, out) *(out) = (arg1) & (arg2)


#line 263

#define short_ctype_xor(arg1, arg2, out) *(out) = (arg1) ^ (arg2)


#line 263

#define short_ctype_or(arg1, arg2, out) *(out) = (arg1) | (arg2)


#line 263

#define short_ctype_lshift(arg1, arg2, out) *(out) = (arg1) << (arg2)


#line 263

#define short_ctype_rshift(arg1, arg2, out) *(out) = (arg1) >> (arg2)




#line 258

#line 263

#define ushort_ctype_and(arg1, arg2, out) *(out) = (arg1) & (arg2)


#line 263

#define ushort_ctype_xor(arg1, arg2, out) *(out) = (arg1) ^ (arg2)


#line 263

#define ushort_ctype_or(arg1, arg2, out) *(out) = (arg1) | (arg2)


#line 263

#define ushort_ctype_lshift(arg1, arg2, out) *(out) = (arg1) << (arg2)


#line 263

#define ushort_ctype_rshift(arg1, arg2, out) *(out) = (arg1) >> (arg2)




#line 258

#line 263

#define int_ctype_and(arg1, arg2, out) *(out) = (arg1) & (arg2)


#line 263

#define int_ctype_xor(arg1, arg2, out) *(out) = (arg1) ^ (arg2)


#line 263

#define int_ctype_or(arg1, arg2, out) *(out) = (arg1) | (arg2)


#line 263

#define int_ctype_lshift(arg1, arg2, out) *(out) = (arg1) << (arg2)


#line 263

#define int_ctype_rshift(arg1, arg2, out) *(out) = (arg1) >> (arg2)




#line 258

#line 263

#define uint_ctype_and(arg1, arg2, out) *(out) = (arg1) & (arg2)


#line 263

#define uint_ctype_xor(arg1, arg2, out) *(out) = (arg1) ^ (arg2)


#line 263

#define uint_ctype_or(arg1, arg2, out) *(out) = (arg1) | (arg2)


#line 263

#define uint_ctype_lshift(arg1, arg2, out) *(out) = (arg1) << (arg2)


#line 263

#define uint_ctype_rshift(arg1, arg2, out) *(out) = (arg1) >> (arg2)




#line 258

#line 263

#define long_ctype_and(arg1, arg2, out) *(out) = (arg1) & (arg2)


#line 263

#define long_ctype_xor(arg1, arg2, out) *(out) = (arg1) ^ (arg2)


#line 263

#define long_ctype_or(arg1, arg2, out) *(out) = (arg1) | (arg2)


#line 263

#define long_ctype_lshift(arg1, arg2, out) *(out) = (arg1) << (arg2)


#line 263

#define long_ctype_rshift(arg1, arg2, out) *(out) = (arg1) >> (arg2)




#line 258

#line 263

#define ulong_ctype_and(arg1, arg2, out) *(out) = (arg1) & (arg2)


#line 263

#define ulong_ctype_xor(arg1, arg2, out) *(out) = (arg1) ^ (arg2)


#line 263

#define ulong_ctype_or(arg1, arg2, out) *(out) = (arg1) | (arg2)


#line 263

#define ulong_ctype_lshift(arg1, arg2, out) *(out) = (arg1) << (arg2)


#line 263

#define ulong_ctype_rshift(arg1, arg2, out) *(out) = (arg1) >> (arg2)




#line 258

#line 263

#define longlong_ctype_and(arg1, arg2, out) *(out) = (arg1) & (arg2)


#line 263

#define longlong_ctype_xor(arg1, arg2, out) *(out) = (arg1) ^ (arg2)


#line 263

#define longlong_ctype_or(arg1, arg2, out) *(out) = (arg1) | (arg2)


#line 263

#define longlong_ctype_lshift(arg1, arg2, out) *(out) = (arg1) << (arg2)


#line 263

#define longlong_ctype_rshift(arg1, arg2, out) *(out) = (arg1) >> (arg2)




#line 258

#line 263

#define ulonglong_ctype_and(arg1, arg2, out) *(out) = (arg1) & (arg2)


#line 263

#define ulonglong_ctype_xor(arg1, arg2, out) *(out) = (arg1) ^ (arg2)


#line 263

#define ulonglong_ctype_or(arg1, arg2, out) *(out) = (arg1) | (arg2)


#line 263

#define ulonglong_ctype_lshift(arg1, arg2, out) *(out) = (arg1) << (arg2)


#line 263

#define ulonglong_ctype_rshift(arg1, arg2, out) *(out) = (arg1) >> (arg2)





#line 275
#define float_ctype_add(a, b, outp) *(outp) = (a) + (b)
#define float_ctype_subtract(a, b, outp) *(outp) = (a) - (b)
#define float_ctype_multiply(a, b, outp) *(outp) = (a) * (b)
#define float_ctype_divide(a, b, outp) *(outp) = (a) / (b)
#define float_ctype_true_divide float_ctype_divide


static void
float_ctype_floor_divide(npy_float a, npy_float b, npy_float *out) {
    npy_float mod;

    *out = npy_divmodf(a, b, &mod);
}


static void
float_ctype_remainder(npy_float a, npy_float b, npy_float *out) {
    npy_divmodf(a, b, out);
}


static void
float_ctype_divmod(npy_float a, npy_float b, npy_float *out1, npy_float *out2) {
    *out1 = npy_divmodf(a, b, out2);
}



#line 275
#define double_ctype_add(a, b, outp) *(outp) = (a) + (b)
#define double_ctype_subtract(a, b, outp) *(outp) = (a) - (b)
#define double_ctype_multiply(a, b, outp) *(outp) = (a) * (b)
#define double_ctype_divide(a, b, outp) *(outp) = (a) / (b)
#define double_ctype_true_divide double_ctype_divide


static void
double_ctype_floor_divide(npy_double a, npy_double b, npy_double *out) {
    npy_double mod;

    *out = npy_divmod(a, b, &mod);
}


static void
double_ctype_remainder(npy_double a, npy_double b, npy_double *out) {
    npy_divmod(a, b, out);
}


static void
double_ctype_divmod(npy_double a, npy_double b, npy_double *out1, npy_double *out2) {
    *out1 = npy_divmod(a, b, out2);
}



#line 275
#define longdouble_ctype_add(a, b, outp) *(outp) = (a) + (b)
#define longdouble_ctype_subtract(a, b, outp) *(outp) = (a) - (b)
#define longdouble_ctype_multiply(a, b, outp) *(outp) = (a) * (b)
#define longdouble_ctype_divide(a, b, outp) *(outp) = (a) / (b)
#define longdouble_ctype_true_divide longdouble_ctype_divide


static void
longdouble_ctype_floor_divide(npy_longdouble a, npy_longdouble b, npy_longdouble *out) {
    npy_longdouble mod;

    *out = npy_divmodl(a, b, &mod);
}


static void
longdouble_ctype_remainder(npy_longdouble a, npy_longdouble b, npy_longdouble *out) {
    npy_divmodl(a, b, out);
}


static void
longdouble_ctype_divmod(npy_longdouble a, npy_longdouble b, npy_longdouble *out1, npy_longdouble *out2) {
    *out1 = npy_divmodl(a, b, out2);
}




#define half_ctype_add(a, b, outp) *(outp) = \
        npy_float_to_half(npy_half_to_float(a) + npy_half_to_float(b))
#define half_ctype_subtract(a, b, outp) *(outp) = \
        npy_float_to_half(npy_half_to_float(a) - npy_half_to_float(b))
#define half_ctype_multiply(a, b, outp) *(outp) = \
        npy_float_to_half(npy_half_to_float(a) * npy_half_to_float(b))
#define half_ctype_divide(a, b, outp) *(outp) = \
        npy_float_to_half(npy_half_to_float(a) / npy_half_to_float(b))
#define half_ctype_true_divide half_ctype_divide


static void
half_ctype_floor_divide(npy_half a, npy_half b, npy_half *out) {
    npy_half mod;

    *out = npy_half_divmod(a, b, &mod);
}


static void
half_ctype_remainder(npy_half a, npy_half b, npy_half *out) {
    npy_half_divmod(a, b, out);
}


static void
half_ctype_divmod(npy_half a, npy_half b, npy_half *out1, npy_half *out2) {
    *out1 = npy_half_divmod(a, b, out2);
}

#line 340
#define cfloat_ctype_add(a, b, outp) do{        \
    (outp)->real = (a).real + (b).real;         \
    (outp)->imag = (a).imag + (b).imag;         \
    } while(0)
#define cfloat_ctype_subtract(a, b, outp) do{   \
    (outp)->real = (a).real - (b).real;         \
    (outp)->imag = (a).imag - (b).imag;         \
    } while(0)
#define cfloat_ctype_multiply(a, b, outp) do{                   \
    (outp)->real = (a).real * (b).real - (a).imag * (b).imag;   \
    (outp)->imag = (a).real * (b).imag + (a).imag * (b).real;   \
    } while(0)
/* Algorithm identical to that in loops.c.src, for consistency */
#define cfloat_ctype_divide(a, b, outp) do{                         \
    npy_float in1r = (a).real;                                        \
    npy_float in1i = (a).imag;                                        \
    npy_float in2r = (b).real;                                        \
    npy_float in2i = (b).imag;                                        \
    npy_float in2r_abs = npy_fabsf(in2r);                           \
    npy_float in2i_abs = npy_fabsf(in2i);                           \
    if (in2r_abs >= in2i_abs) {                                     \
        if (in2r_abs == 0 && in2i_abs == 0) {                       \
            /* divide by zero should yield a complex inf or nan */  \
            (outp)->real = in1r/in2r_abs;                           \
            (outp)->imag = in1i/in2i_abs;                           \
        }                                                           \
        else {                                                      \
            npy_float rat = in2i/in2r;                                \
            npy_float scl = 1.0f/(in2r + in2i*rat);                 \
            (outp)->real = (in1r + in1i*rat)*scl;                   \
            (outp)->imag = (in1i - in1r*rat)*scl;                   \
        }                                                           \
    }                                                               \
    else {                                                          \
        npy_float rat = in2r/in2i;                                    \
        npy_float scl = 1.0f/(in2i + in2r*rat);                     \
        (outp)->real = (in1r*rat + in1i)*scl;                       \
        (outp)->imag = (in1i*rat - in1r)*scl;                       \
    }                                                               \
    } while(0)

#define cfloat_ctype_true_divide cfloat_ctype_divide

#define cfloat_ctype_floor_divide(a, b, outp) do {      \
    float_ctype_floor_divide(                         \
        ((a).real*(b).real + (a).imag*(b).imag),        \
        ((b).real*(b).real + (b).imag*(b).imag),        \
        &((outp)->real));                               \
    (outp)->imag = 0;                                   \
    } while(0)

#line 340
#define cdouble_ctype_add(a, b, outp) do{        \
    (outp)->real = (a).real + (b).real;         \
    (outp)->imag = (a).imag + (b).imag;         \
    } while(0)
#define cdouble_ctype_subtract(a, b, outp) do{   \
    (outp)->real = (a).real - (b).real;         \
    (outp)->imag = (a).imag - (b).imag;         \
    } while(0)
#define cdouble_ctype_multiply(a, b, outp) do{                   \
    (outp)->real = (a).real * (b).real - (a).imag * (b).imag;   \
    (outp)->imag = (a).real * (b).imag + (a).imag * (b).real;   \
    } while(0)
/* Algorithm identical to that in loops.c.src, for consistency */
#define cdouble_ctype_divide(a, b, outp) do{                         \
    npy_double in1r = (a).real;                                        \
    npy_double in1i = (a).imag;                                        \
    npy_double in2r = (b).real;                                        \
    npy_double in2i = (b).imag;                                        \
    npy_double in2r_abs = npy_fabs(in2r);                           \
    npy_double in2i_abs = npy_fabs(in2i);                           \
    if (in2r_abs >= in2i_abs) {                                     \
        if (in2r_abs == 0 && in2i_abs == 0) {                       \
            /* divide by zero should yield a complex inf or nan */  \
            (outp)->real = in1r/in2r_abs;                           \
            (outp)->imag = in1i/in2i_abs;                           \
        }                                                           \
        else {                                                      \
            npy_double rat = in2i/in2r;                                \
            npy_double scl = 1.0/(in2r + in2i*rat);                 \
            (outp)->real = (in1r + in1i*rat)*scl;                   \
            (outp)->imag = (in1i - in1r*rat)*scl;                   \
        }                                                           \
    }                                                               \
    else {                                                          \
        npy_double rat = in2r/in2i;                                    \
        npy_double scl = 1.0/(in2i + in2r*rat);                     \
        (outp)->real = (in1r*rat + in1i)*scl;                       \
        (outp)->imag = (in1i*rat - in1r)*scl;                       \
    }                                                               \
    } while(0)

#define cdouble_ctype_true_divide cdouble_ctype_divide

#define cdouble_ctype_floor_divide(a, b, outp) do {      \
    double_ctype_floor_divide(                         \
        ((a).real*(b).real + (a).imag*(b).imag),        \
        ((b).real*(b).real + (b).imag*(b).imag),        \
        &((outp)->real));                               \
    (outp)->imag = 0;                                   \
    } while(0)

#line 340
#define clongdouble_ctype_add(a, b, outp) do{        \
    (outp)->real = (a).real + (b).real;         \
    (outp)->imag = (a).imag + (b).imag;         \
    } while(0)
#define clongdouble_ctype_subtract(a, b, outp) do{   \
    (outp)->real = (a).real - (b).real;         \
    (outp)->imag = (a).imag - (b).imag;         \
    } while(0)
#define clongdouble_ctype_multiply(a, b, outp) do{                   \
    (outp)->real = (a).real * (b).real - (a).imag * (b).imag;   \
    (outp)->imag = (a).real * (b).imag + (a).imag * (b).real;   \
    } while(0)
/* Algorithm identical to that in loops.c.src, for consistency */
#define clongdouble_ctype_divide(a, b, outp) do{                         \
    npy_longdouble in1r = (a).real;                                        \
    npy_longdouble in1i = (a).imag;                                        \
    npy_longdouble in2r = (b).real;                                        \
    npy_longdouble in2i = (b).imag;                                        \
    npy_longdouble in2r_abs = npy_fabsl(in2r);                           \
    npy_longdouble in2i_abs = npy_fabsl(in2i);                           \
    if (in2r_abs >= in2i_abs) {                                     \
        if (in2r_abs == 0 && in2i_abs == 0) {                       \
            /* divide by zero should yield a complex inf or nan */  \
            (outp)->real = in1r/in2r_abs;                           \
            (outp)->imag = in1i/in2i_abs;                           \
        }                                                           \
        else {                                                      \
            npy_longdouble rat = in2i/in2r;                                \
            npy_longdouble scl = 1.0l/(in2r + in2i*rat);                 \
            (outp)->real = (in1r + in1i*rat)*scl;                   \
            (outp)->imag = (in1i - in1r*rat)*scl;                   \
        }                                                           \
    }                                                               \
    else {                                                          \
        npy_longdouble rat = in2r/in2i;                                    \
        npy_longdouble scl = 1.0l/(in2i + in2r*rat);                     \
        (outp)->real = (in1r*rat + in1i)*scl;                       \
        (outp)->imag = (in1i*rat - in1r)*scl;                       \
    }                                                               \
    } while(0)

#define clongdouble_ctype_true_divide clongdouble_ctype_divide

#define clongdouble_ctype_floor_divide(a, b, outp) do {      \
    longdouble_ctype_floor_divide(                         \
        ((a).real*(b).real + (a).imag*(b).imag),        \
        ((b).real*(b).real + (b).imag*(b).imag),        \
        &((outp)->real));                               \
    (outp)->imag = 0;                                   \
    } while(0)




#line 398
#define byte_ctype_divmod(a, b, out, out2) {  \
    byte_ctype_floor_divide(a, b, out);       \
    byte_ctype_remainder(a, b, out2);         \
    }

#line 398
#define ubyte_ctype_divmod(a, b, out, out2) {  \
    ubyte_ctype_floor_divide(a, b, out);       \
    ubyte_ctype_remainder(a, b, out2);         \
    }

#line 398
#define short_ctype_divmod(a, b, out, out2) {  \
    short_ctype_floor_divide(a, b, out);       \
    short_ctype_remainder(a, b, out2);         \
    }

#line 398
#define ushort_ctype_divmod(a, b, out, out2) {  \
    ushort_ctype_floor_divide(a, b, out);       \
    ushort_ctype_remainder(a, b, out2);         \
    }

#line 398
#define int_ctype_divmod(a, b, out, out2) {  \
    int_ctype_floor_divide(a, b, out);       \
    int_ctype_remainder(a, b, out2);         \
    }

#line 398
#define uint_ctype_divmod(a, b, out, out2) {  \
    uint_ctype_floor_divide(a, b, out);       \
    uint_ctype_remainder(a, b, out2);         \
    }

#line 398
#define long_ctype_divmod(a, b, out, out2) {  \
    long_ctype_floor_divide(a, b, out);       \
    long_ctype_remainder(a, b, out2);         \
    }

#line 398
#define ulong_ctype_divmod(a, b, out, out2) {  \
    ulong_ctype_floor_divide(a, b, out);       \
    ulong_ctype_remainder(a, b, out2);         \
    }

#line 398
#define longlong_ctype_divmod(a, b, out, out2) {  \
    longlong_ctype_floor_divide(a, b, out);       \
    longlong_ctype_remainder(a, b, out2);         \
    }

#line 398
#define ulonglong_ctype_divmod(a, b, out, out2) {  \
    ulonglong_ctype_floor_divide(a, b, out);       \
    ulonglong_ctype_remainder(a, b, out2);         \
    }

#line 398
#define cfloat_ctype_divmod(a, b, out, out2) {  \
    cfloat_ctype_floor_divide(a, b, out);       \
    cfloat_ctype_remainder(a, b, out2);         \
    }

#line 398
#define cdouble_ctype_divmod(a, b, out, out2) {  \
    cdouble_ctype_floor_divide(a, b, out);       \
    cdouble_ctype_remainder(a, b, out2);         \
    }

#line 398
#define clongdouble_ctype_divmod(a, b, out, out2) {  \
    clongdouble_ctype_floor_divide(a, b, out);       \
    clongdouble_ctype_remainder(a, b, out2);         \
    }



#line 409
static npy_float (*_basic_float_pow)(npy_float a, npy_float b);

static void
float_ctype_power(npy_float a, npy_float b, npy_float *out)
{
    *out = _basic_float_pow(a, b);
}

#line 409
static npy_double (*_basic_double_pow)(npy_double a, npy_double b);

static void
double_ctype_power(npy_double a, npy_double b, npy_double *out)
{
    *out = _basic_double_pow(a, b);
}

#line 409
static npy_longdouble (*_basic_longdouble_pow)(npy_longdouble a, npy_longdouble b);

static void
longdouble_ctype_power(npy_longdouble a, npy_longdouble b, npy_longdouble *out)
{
    *out = _basic_longdouble_pow(a, b);
}

static void
half_ctype_power(npy_half a, npy_half b, npy_half *out)
{
    const npy_float af = npy_half_to_float(a);
    const npy_float bf = npy_half_to_float(b);
    const npy_float outf = _basic_float_pow(af,bf);
    *out = npy_float_to_half(outf);
}

#line 435
static void
byte_ctype_negative(npy_byte a, npy_byte *out)
{
#if 0
    npy_set_floatstatus_overflow();
#endif
    *out = -a;
}

#line 435
static void
ubyte_ctype_negative(npy_ubyte a, npy_ubyte *out)
{
#if 1
    npy_set_floatstatus_overflow();
#endif
    *out = -a;
}

#line 435
static void
short_ctype_negative(npy_short a, npy_short *out)
{
#if 0
    npy_set_floatstatus_overflow();
#endif
    *out = -a;
}

#line 435
static void
ushort_ctype_negative(npy_ushort a, npy_ushort *out)
{
#if 1
    npy_set_floatstatus_overflow();
#endif
    *out = -a;
}

#line 435
static void
int_ctype_negative(npy_int a, npy_int *out)
{
#if 0
    npy_set_floatstatus_overflow();
#endif
    *out = -a;
}

#line 435
static void
uint_ctype_negative(npy_uint a, npy_uint *out)
{
#if 1
    npy_set_floatstatus_overflow();
#endif
    *out = -a;
}

#line 435
static void
long_ctype_negative(npy_long a, npy_long *out)
{
#if 0
    npy_set_floatstatus_overflow();
#endif
    *out = -a;
}

#line 435
static void
ulong_ctype_negative(npy_ulong a, npy_ulong *out)
{
#if 1
    npy_set_floatstatus_overflow();
#endif
    *out = -a;
}

#line 435
static void
longlong_ctype_negative(npy_longlong a, npy_longlong *out)
{
#if 0
    npy_set_floatstatus_overflow();
#endif
    *out = -a;
}

#line 435
static void
ulonglong_ctype_negative(npy_ulonglong a, npy_ulonglong *out)
{
#if 1
    npy_set_floatstatus_overflow();
#endif
    *out = -a;
}

#line 435
static void
float_ctype_negative(npy_float a, npy_float *out)
{
#if 0
    npy_set_floatstatus_overflow();
#endif
    *out = -a;
}

#line 435
static void
double_ctype_negative(npy_double a, npy_double *out)
{
#if 0
    npy_set_floatstatus_overflow();
#endif
    *out = -a;
}

#line 435
static void
longdouble_ctype_negative(npy_longdouble a, npy_longdouble *out)
{
#if 0
    npy_set_floatstatus_overflow();
#endif
    *out = -a;
}


static void
half_ctype_negative(npy_half a, npy_half *out)
{
    *out = a^0x8000u;
}


#line 456
static void
cfloat_ctype_negative(npy_cfloat a, npy_cfloat *out)
{
    out->real = -a.real;
    out->imag = -a.imag;
}

#line 456
static void
cdouble_ctype_negative(npy_cdouble a, npy_cdouble *out)
{
    out->real = -a.real;
    out->imag = -a.imag;
}

#line 456
static void
clongdouble_ctype_negative(npy_clongdouble a, npy_clongdouble *out)
{
    out->real = -a.real;
    out->imag = -a.imag;
}


#line 472
static void
byte_ctype_positive(npy_byte a, npy_byte *out)
{
    *out = a;
}

#line 472
static void
ubyte_ctype_positive(npy_ubyte a, npy_ubyte *out)
{
    *out = a;
}

#line 472
static void
short_ctype_positive(npy_short a, npy_short *out)
{
    *out = a;
}

#line 472
static void
ushort_ctype_positive(npy_ushort a, npy_ushort *out)
{
    *out = a;
}

#line 472
static void
int_ctype_positive(npy_int a, npy_int *out)
{
    *out = a;
}

#line 472
static void
uint_ctype_positive(npy_uint a, npy_uint *out)
{
    *out = a;
}

#line 472
static void
long_ctype_positive(npy_long a, npy_long *out)
{
    *out = a;
}

#line 472
static void
ulong_ctype_positive(npy_ulong a, npy_ulong *out)
{
    *out = a;
}

#line 472
static void
longlong_ctype_positive(npy_longlong a, npy_longlong *out)
{
    *out = a;
}

#line 472
static void
ulonglong_ctype_positive(npy_ulonglong a, npy_ulonglong *out)
{
    *out = a;
}

#line 472
static void
half_ctype_positive(npy_half a, npy_half *out)
{
    *out = a;
}

#line 472
static void
float_ctype_positive(npy_float a, npy_float *out)
{
    *out = a;
}

#line 472
static void
double_ctype_positive(npy_double a, npy_double *out)
{
    *out = a;
}

#line 472
static void
longdouble_ctype_positive(npy_longdouble a, npy_longdouble *out)
{
    *out = a;
}


/*
 * Get the nc_powf, nc_pow, and nc_powl functions from
 * the data area of the power ufunc in umathmodule.
 */

#line 488
static void
cfloat_ctype_positive(npy_cfloat a, npy_cfloat *out)
{
    out->real = a.real;
    out->imag = a.imag;
}

static void (*_basic_cfloat_pow)(npy_cfloat *, npy_cfloat *, npy_cfloat *);

static void
cfloat_ctype_power(npy_cfloat a, npy_cfloat b, npy_cfloat *out)
{
    _basic_cfloat_pow(&a, &b, out);
}

#line 488
static void
cdouble_ctype_positive(npy_cdouble a, npy_cdouble *out)
{
    out->real = a.real;
    out->imag = a.imag;
}

static void (*_basic_cdouble_pow)(npy_cdouble *, npy_cdouble *, npy_cdouble *);

static void
cdouble_ctype_power(npy_cdouble a, npy_cdouble b, npy_cdouble *out)
{
    _basic_cdouble_pow(&a, &b, out);
}

#line 488
static void
clongdouble_ctype_positive(npy_clongdouble a, npy_clongdouble *out)
{
    out->real = a.real;
    out->imag = a.imag;
}

static void (*_basic_clongdouble_pow)(npy_clongdouble *, npy_clongdouble *, npy_clongdouble *);

static void
clongdouble_ctype_power(npy_clongdouble a, npy_clongdouble b, npy_clongdouble *out)
{
    _basic_clongdouble_pow(&a, &b, out);
}



#line 508

#define ubyte_ctype_absolute ubyte_ctype_positive


#line 508

#define ushort_ctype_absolute ushort_ctype_positive


#line 508

#define uint_ctype_absolute uint_ctype_positive


#line 508

#define ulong_ctype_absolute ulong_ctype_positive


#line 508

#define ulonglong_ctype_absolute ulonglong_ctype_positive




#line 518
static void
byte_ctype_absolute(npy_byte a, npy_byte *out)
{
    *out = (a < 0 ? -a : a);
}

#line 518
static void
short_ctype_absolute(npy_short a, npy_short *out)
{
    *out = (a < 0 ? -a : a);
}

#line 518
static void
int_ctype_absolute(npy_int a, npy_int *out)
{
    *out = (a < 0 ? -a : a);
}

#line 518
static void
long_ctype_absolute(npy_long a, npy_long *out)
{
    *out = (a < 0 ? -a : a);
}

#line 518
static void
longlong_ctype_absolute(npy_longlong a, npy_longlong *out)
{
    *out = (a < 0 ? -a : a);
}


#line 530
static void
float_ctype_absolute(npy_float a, npy_float *out)
{
    *out = npy_fabsf(a);
}

#line 530
static void
double_ctype_absolute(npy_double a, npy_double *out)
{
    *out = npy_fabs(a);
}

#line 530
static void
longdouble_ctype_absolute(npy_longdouble a, npy_longdouble *out)
{
    *out = npy_fabsl(a);
}


static void
half_ctype_absolute(npy_half a, npy_half *out)
{
    *out = a&0x7fffu;
}

#line 549
static void
cfloat_ctype_absolute(npy_cfloat a, npy_float *out)
{
    *out = npy_cabsf(a);
}

#line 549
static void
cdouble_ctype_absolute(npy_cdouble a, npy_double *out)
{
    *out = npy_cabs(a);
}

#line 549
static void
clongdouble_ctype_absolute(npy_clongdouble a, npy_longdouble *out)
{
    *out = npy_cabsl(a);
}


#line 560

#define byte_ctype_invert(a, out) *(out) = ~a;


#line 560

#define ubyte_ctype_invert(a, out) *(out) = ~a;


#line 560

#define short_ctype_invert(a, out) *(out) = ~a;


#line 560

#define ushort_ctype_invert(a, out) *(out) = ~a;


#line 560

#define int_ctype_invert(a, out) *(out) = ~a;


#line 560

#define uint_ctype_invert(a, out) *(out) = ~a;


#line 560

#define long_ctype_invert(a, out) *(out) = ~a;


#line 560

#define ulong_ctype_invert(a, out) *(out) = ~a;


#line 560

#define longlong_ctype_invert(a, out) *(out) = ~a;


#line 560

#define ulonglong_ctype_invert(a, out) *(out) = ~a;



/*** END OF BASIC CODE **/


/* The general strategy for commutative binary operators is to
 *
 * 1) Convert the types to the common type if both are scalars (0 return)
 * 2) If both are not scalars use ufunc machinery (-2 return)
 * 3) If both are scalars but cannot be cast to the right type
 * return NotImplmented (-1 return)
 *
 * 4) Perform the function on the C-type.
 * 5) If an error condition occurred, check to see
 * what the current error-handling is and handle the error.
 *
 * 6) Construct and return the output scalar.
 */

#line 600

static int
_byte_convert_to_ctype(PyObject *a, npy_byte *arg1)
{
    PyObject *temp;

    if (PyArray_IsScalar(a, Byte)) {
        *arg1 = PyArrayScalar_VAL(a, Byte);
        return 0;
    }
    else if (PyArray_IsScalar(a, Generic)) {
        PyArray_Descr *descr1;

        if (!PyArray_IsScalar(a, Number)) {
            return -1;
        }
        descr1 = PyArray_DescrFromTypeObject((PyObject *)Py_TYPE(a));
        if (PyArray_CanCastSafely(descr1->type_num, NPY_BYTE)) {
            PyArray_CastScalarDirect(a, descr1, arg1, NPY_BYTE);
            Py_DECREF(descr1);
            return 0;
        }
        else {
            Py_DECREF(descr1);
            return -1;
        }
    }
    else if (PyArray_GetPriority(a, NPY_PRIORITY) > NPY_PRIORITY) {
        return -2;
    }
    else if ((temp = PyArray_ScalarFromObject(a)) != NULL) {
        int retval = _byte_convert_to_ctype(temp, arg1);

        Py_DECREF(temp);
        return retval;
    }
    return -2;
}


#line 600

static int
_ubyte_convert_to_ctype(PyObject *a, npy_ubyte *arg1)
{
    PyObject *temp;

    if (PyArray_IsScalar(a, UByte)) {
        *arg1 = PyArrayScalar_VAL(a, UByte);
        return 0;
    }
    else if (PyArray_IsScalar(a, Generic)) {
        PyArray_Descr *descr1;

        if (!PyArray_IsScalar(a, Number)) {
            return -1;
        }
        descr1 = PyArray_DescrFromTypeObject((PyObject *)Py_TYPE(a));
        if (PyArray_CanCastSafely(descr1->type_num, NPY_UBYTE)) {
            PyArray_CastScalarDirect(a, descr1, arg1, NPY_UBYTE);
            Py_DECREF(descr1);
            return 0;
        }
        else {
            Py_DECREF(descr1);
            return -1;
        }
    }
    else if (PyArray_GetPriority(a, NPY_PRIORITY) > NPY_PRIORITY) {
        return -2;
    }
    else if ((temp = PyArray_ScalarFromObject(a)) != NULL) {
        int retval = _ubyte_convert_to_ctype(temp, arg1);

        Py_DECREF(temp);
        return retval;
    }
    return -2;
}


#line 600

static int
_short_convert_to_ctype(PyObject *a, npy_short *arg1)
{
    PyObject *temp;

    if (PyArray_IsScalar(a, Short)) {
        *arg1 = PyArrayScalar_VAL(a, Short);
        return 0;
    }
    else if (PyArray_IsScalar(a, Generic)) {
        PyArray_Descr *descr1;

        if (!PyArray_IsScalar(a, Number)) {
            return -1;
        }
        descr1 = PyArray_DescrFromTypeObject((PyObject *)Py_TYPE(a));
        if (PyArray_CanCastSafely(descr1->type_num, NPY_SHORT)) {
            PyArray_CastScalarDirect(a, descr1, arg1, NPY_SHORT);
            Py_DECREF(descr1);
            return 0;
        }
        else {
            Py_DECREF(descr1);
            return -1;
        }
    }
    else if (PyArray_GetPriority(a, NPY_PRIORITY) > NPY_PRIORITY) {
        return -2;
    }
    else if ((temp = PyArray_ScalarFromObject(a)) != NULL) {
        int retval = _short_convert_to_ctype(temp, arg1);

        Py_DECREF(temp);
        return retval;
    }
    return -2;
}


#line 600

static int
_ushort_convert_to_ctype(PyObject *a, npy_ushort *arg1)
{
    PyObject *temp;

    if (PyArray_IsScalar(a, UShort)) {
        *arg1 = PyArrayScalar_VAL(a, UShort);
        return 0;
    }
    else if (PyArray_IsScalar(a, Generic)) {
        PyArray_Descr *descr1;

        if (!PyArray_IsScalar(a, Number)) {
            return -1;
        }
        descr1 = PyArray_DescrFromTypeObject((PyObject *)Py_TYPE(a));
        if (PyArray_CanCastSafely(descr1->type_num, NPY_USHORT)) {
            PyArray_CastScalarDirect(a, descr1, arg1, NPY_USHORT);
            Py_DECREF(descr1);
            return 0;
        }
        else {
            Py_DECREF(descr1);
            return -1;
        }
    }
    else if (PyArray_GetPriority(a, NPY_PRIORITY) > NPY_PRIORITY) {
        return -2;
    }
    else if ((temp = PyArray_ScalarFromObject(a)) != NULL) {
        int retval = _ushort_convert_to_ctype(temp, arg1);

        Py_DECREF(temp);
        return retval;
    }
    return -2;
}


#line 600

static int
_int_convert_to_ctype(PyObject *a, npy_int *arg1)
{
    PyObject *temp;

    if (PyArray_IsScalar(a, Int)) {
        *arg1 = PyArrayScalar_VAL(a, Int);
        return 0;
    }
    else if (PyArray_IsScalar(a, Generic)) {
        PyArray_Descr *descr1;

        if (!PyArray_IsScalar(a, Number)) {
            return -1;
        }
        descr1 = PyArray_DescrFromTypeObject((PyObject *)Py_TYPE(a));
        if (PyArray_CanCastSafely(descr1->type_num, NPY_INT)) {
            PyArray_CastScalarDirect(a, descr1, arg1, NPY_INT);
            Py_DECREF(descr1);
            return 0;
        }
        else {
            Py_DECREF(descr1);
            return -1;
        }
    }
    else if (PyArray_GetPriority(a, NPY_PRIORITY) > NPY_PRIORITY) {
        return -2;
    }
    else if ((temp = PyArray_ScalarFromObject(a)) != NULL) {
        int retval = _int_convert_to_ctype(temp, arg1);

        Py_DECREF(temp);
        return retval;
    }
    return -2;
}


#line 600

static int
_uint_convert_to_ctype(PyObject *a, npy_uint *arg1)
{
    PyObject *temp;

    if (PyArray_IsScalar(a, UInt)) {
        *arg1 = PyArrayScalar_VAL(a, UInt);
        return 0;
    }
    else if (PyArray_IsScalar(a, Generic)) {
        PyArray_Descr *descr1;

        if (!PyArray_IsScalar(a, Number)) {
            return -1;
        }
        descr1 = PyArray_DescrFromTypeObject((PyObject *)Py_TYPE(a));
        if (PyArray_CanCastSafely(descr1->type_num, NPY_UINT)) {
            PyArray_CastScalarDirect(a, descr1, arg1, NPY_UINT);
            Py_DECREF(descr1);
            return 0;
        }
        else {
            Py_DECREF(descr1);
            return -1;
        }
    }
    else if (PyArray_GetPriority(a, NPY_PRIORITY) > NPY_PRIORITY) {
        return -2;
    }
    else if ((temp = PyArray_ScalarFromObject(a)) != NULL) {
        int retval = _uint_convert_to_ctype(temp, arg1);

        Py_DECREF(temp);
        return retval;
    }
    return -2;
}


#line 600

static int
_long_convert_to_ctype(PyObject *a, npy_long *arg1)
{
    PyObject *temp;

    if (PyArray_IsScalar(a, Long)) {
        *arg1 = PyArrayScalar_VAL(a, Long);
        return 0;
    }
    else if (PyArray_IsScalar(a, Generic)) {
        PyArray_Descr *descr1;

        if (!PyArray_IsScalar(a, Number)) {
            return -1;
        }
        descr1 = PyArray_DescrFromTypeObject((PyObject *)Py_TYPE(a));
        if (PyArray_CanCastSafely(descr1->type_num, NPY_LONG)) {
            PyArray_CastScalarDirect(a, descr1, arg1, NPY_LONG);
            Py_DECREF(descr1);
            return 0;
        }
        else {
            Py_DECREF(descr1);
            return -1;
        }
    }
    else if (PyArray_GetPriority(a, NPY_PRIORITY) > NPY_PRIORITY) {
        return -2;
    }
    else if ((temp = PyArray_ScalarFromObject(a)) != NULL) {
        int retval = _long_convert_to_ctype(temp, arg1);

        Py_DECREF(temp);
        return retval;
    }
    return -2;
}


#line 600

static int
_ulong_convert_to_ctype(PyObject *a, npy_ulong *arg1)
{
    PyObject *temp;

    if (PyArray_IsScalar(a, ULong)) {
        *arg1 = PyArrayScalar_VAL(a, ULong);
        return 0;
    }
    else if (PyArray_IsScalar(a, Generic)) {
        PyArray_Descr *descr1;

        if (!PyArray_IsScalar(a, Number)) {
            return -1;
        }
        descr1 = PyArray_DescrFromTypeObject((PyObject *)Py_TYPE(a));
        if (PyArray_CanCastSafely(descr1->type_num, NPY_ULONG)) {
            PyArray_CastScalarDirect(a, descr1, arg1, NPY_ULONG);
            Py_DECREF(descr1);
            return 0;
        }
        else {
            Py_DECREF(descr1);
            return -1;
        }
    }
    else if (PyArray_GetPriority(a, NPY_PRIORITY) > NPY_PRIORITY) {
        return -2;
    }
    else if ((temp = PyArray_ScalarFromObject(a)) != NULL) {
        int retval = _ulong_convert_to_ctype(temp, arg1);

        Py_DECREF(temp);
        return retval;
    }
    return -2;
}


#line 600

static int
_longlong_convert_to_ctype(PyObject *a, npy_longlong *arg1)
{
    PyObject *temp;

    if (PyArray_IsScalar(a, LongLong)) {
        *arg1 = PyArrayScalar_VAL(a, LongLong);
        return 0;
    }
    else if (PyArray_IsScalar(a, Generic)) {
        PyArray_Descr *descr1;

        if (!PyArray_IsScalar(a, Number)) {
            return -1;
        }
        descr1 = PyArray_DescrFromTypeObject((PyObject *)Py_TYPE(a));
        if (PyArray_CanCastSafely(descr1->type_num, NPY_LONGLONG)) {
            PyArray_CastScalarDirect(a, descr1, arg1, NPY_LONGLONG);
            Py_DECREF(descr1);
            return 0;
        }
        else {
            Py_DECREF(descr1);
            return -1;
        }
    }
    else if (PyArray_GetPriority(a, NPY_PRIORITY) > NPY_PRIORITY) {
        return -2;
    }
    else if ((temp = PyArray_ScalarFromObject(a)) != NULL) {
        int retval = _longlong_convert_to_ctype(temp, arg1);

        Py_DECREF(temp);
        return retval;
    }
    return -2;
}


#line 600

static int
_ulonglong_convert_to_ctype(PyObject *a, npy_ulonglong *arg1)
{
    PyObject *temp;

    if (PyArray_IsScalar(a, ULongLong)) {
        *arg1 = PyArrayScalar_VAL(a, ULongLong);
        return 0;
    }
    else if (PyArray_IsScalar(a, Generic)) {
        PyArray_Descr *descr1;

        if (!PyArray_IsScalar(a, Number)) {
            return -1;
        }
        descr1 = PyArray_DescrFromTypeObject((PyObject *)Py_TYPE(a));
        if (PyArray_CanCastSafely(descr1->type_num, NPY_ULONGLONG)) {
            PyArray_CastScalarDirect(a, descr1, arg1, NPY_ULONGLONG);
            Py_DECREF(descr1);
            return 0;
        }
        else {
            Py_DECREF(descr1);
            return -1;
        }
    }
    else if (PyArray_GetPriority(a, NPY_PRIORITY) > NPY_PRIORITY) {
        return -2;
    }
    else if ((temp = PyArray_ScalarFromObject(a)) != NULL) {
        int retval = _ulonglong_convert_to_ctype(temp, arg1);

        Py_DECREF(temp);
        return retval;
    }
    return -2;
}


#line 600

static int
_half_convert_to_ctype(PyObject *a, npy_half *arg1)
{
    PyObject *temp;

    if (PyArray_IsScalar(a, Half)) {
        *arg1 = PyArrayScalar_VAL(a, Half);
        return 0;
    }
    else if (PyArray_IsScalar(a, Generic)) {
        PyArray_Descr *descr1;

        if (!PyArray_IsScalar(a, Number)) {
            return -1;
        }
        descr1 = PyArray_DescrFromTypeObject((PyObject *)Py_TYPE(a));
        if (PyArray_CanCastSafely(descr1->type_num, NPY_HALF)) {
            PyArray_CastScalarDirect(a, descr1, arg1, NPY_HALF);
            Py_DECREF(descr1);
            return 0;
        }
        else {
            Py_DECREF(descr1);
            return -1;
        }
    }
    else if (PyArray_GetPriority(a, NPY_PRIORITY) > NPY_PRIORITY) {
        return -2;
    }
    else if ((temp = PyArray_ScalarFromObject(a)) != NULL) {
        int retval = _half_convert_to_ctype(temp, arg1);

        Py_DECREF(temp);
        return retval;
    }
    return -2;
}


#line 600

static int
_float_convert_to_ctype(PyObject *a, npy_float *arg1)
{
    PyObject *temp;

    if (PyArray_IsScalar(a, Float)) {
        *arg1 = PyArrayScalar_VAL(a, Float);
        return 0;
    }
    else if (PyArray_IsScalar(a, Generic)) {
        PyArray_Descr *descr1;

        if (!PyArray_IsScalar(a, Number)) {
            return -1;
        }
        descr1 = PyArray_DescrFromTypeObject((PyObject *)Py_TYPE(a));
        if (PyArray_CanCastSafely(descr1->type_num, NPY_FLOAT)) {
            PyArray_CastScalarDirect(a, descr1, arg1, NPY_FLOAT);
            Py_DECREF(descr1);
            return 0;
        }
        else {
            Py_DECREF(descr1);
            return -1;
        }
    }
    else if (PyArray_GetPriority(a, NPY_PRIORITY) > NPY_PRIORITY) {
        return -2;
    }
    else if ((temp = PyArray_ScalarFromObject(a)) != NULL) {
        int retval = _float_convert_to_ctype(temp, arg1);

        Py_DECREF(temp);
        return retval;
    }
    return -2;
}


#line 600

static int
_longdouble_convert_to_ctype(PyObject *a, npy_longdouble *arg1)
{
    PyObject *temp;

    if (PyArray_IsScalar(a, LongDouble)) {
        *arg1 = PyArrayScalar_VAL(a, LongDouble);
        return 0;
    }
    else if (PyArray_IsScalar(a, Generic)) {
        PyArray_Descr *descr1;

        if (!PyArray_IsScalar(a, Number)) {
            return -1;
        }
        descr1 = PyArray_DescrFromTypeObject((PyObject *)Py_TYPE(a));
        if (PyArray_CanCastSafely(descr1->type_num, NPY_LONGDOUBLE)) {
            PyArray_CastScalarDirect(a, descr1, arg1, NPY_LONGDOUBLE);
            Py_DECREF(descr1);
            return 0;
        }
        else {
            Py_DECREF(descr1);
            return -1;
        }
    }
    else if (PyArray_GetPriority(a, NPY_PRIORITY) > NPY_PRIORITY) {
        return -2;
    }
    else if ((temp = PyArray_ScalarFromObject(a)) != NULL) {
        int retval = _longdouble_convert_to_ctype(temp, arg1);

        Py_DECREF(temp);
        return retval;
    }
    return -2;
}


#line 600

static int
_cfloat_convert_to_ctype(PyObject *a, npy_cfloat *arg1)
{
    PyObject *temp;

    if (PyArray_IsScalar(a, CFloat)) {
        *arg1 = PyArrayScalar_VAL(a, CFloat);
        return 0;
    }
    else if (PyArray_IsScalar(a, Generic)) {
        PyArray_Descr *descr1;

        if (!PyArray_IsScalar(a, Number)) {
            return -1;
        }
        descr1 = PyArray_DescrFromTypeObject((PyObject *)Py_TYPE(a));
        if (PyArray_CanCastSafely(descr1->type_num, NPY_CFLOAT)) {
            PyArray_CastScalarDirect(a, descr1, arg1, NPY_CFLOAT);
            Py_DECREF(descr1);
            return 0;
        }
        else {
            Py_DECREF(descr1);
            return -1;
        }
    }
    else if (PyArray_GetPriority(a, NPY_PRIORITY) > NPY_PRIORITY) {
        return -2;
    }
    else if ((temp = PyArray_ScalarFromObject(a)) != NULL) {
        int retval = _cfloat_convert_to_ctype(temp, arg1);

        Py_DECREF(temp);
        return retval;
    }
    return -2;
}


#line 600

static int
_cdouble_convert_to_ctype(PyObject *a, npy_cdouble *arg1)
{
    PyObject *temp;

    if (PyArray_IsScalar(a, CDouble)) {
        *arg1 = PyArrayScalar_VAL(a, CDouble);
        return 0;
    }
    else if (PyArray_IsScalar(a, Generic)) {
        PyArray_Descr *descr1;

        if (!PyArray_IsScalar(a, Number)) {
            return -1;
        }
        descr1 = PyArray_DescrFromTypeObject((PyObject *)Py_TYPE(a));
        if (PyArray_CanCastSafely(descr1->type_num, NPY_CDOUBLE)) {
            PyArray_CastScalarDirect(a, descr1, arg1, NPY_CDOUBLE);
            Py_DECREF(descr1);
            return 0;
        }
        else {
            Py_DECREF(descr1);
            return -1;
        }
    }
    else if (PyArray_GetPriority(a, NPY_PRIORITY) > NPY_PRIORITY) {
        return -2;
    }
    else if ((temp = PyArray_ScalarFromObject(a)) != NULL) {
        int retval = _cdouble_convert_to_ctype(temp, arg1);

        Py_DECREF(temp);
        return retval;
    }
    return -2;
}


#line 600

static int
_clongdouble_convert_to_ctype(PyObject *a, npy_clongdouble *arg1)
{
    PyObject *temp;

    if (PyArray_IsScalar(a, CLongDouble)) {
        *arg1 = PyArrayScalar_VAL(a, CLongDouble);
        return 0;
    }
    else if (PyArray_IsScalar(a, Generic)) {
        PyArray_Descr *descr1;

        if (!PyArray_IsScalar(a, Number)) {
            return -1;
        }
        descr1 = PyArray_DescrFromTypeObject((PyObject *)Py_TYPE(a));
        if (PyArray_CanCastSafely(descr1->type_num, NPY_CLONGDOUBLE)) {
            PyArray_CastScalarDirect(a, descr1, arg1, NPY_CLONGDOUBLE);
            Py_DECREF(descr1);
            return 0;
        }
        else {
            Py_DECREF(descr1);
            return -1;
        }
    }
    else if (PyArray_GetPriority(a, NPY_PRIORITY) > NPY_PRIORITY) {
        return -2;
    }
    else if ((temp = PyArray_ScalarFromObject(a)) != NULL) {
        int retval = _clongdouble_convert_to_ctype(temp, arg1);

        Py_DECREF(temp);
        return retval;
    }
    return -2;
}




/* Same as above but added exact checks against known python types for speed */

#line 652

static int
_double_convert_to_ctype(PyObject *a, npy_double *arg1)
{
    PyObject *temp;

    if (PyFloat_CheckExact(a)){
        *arg1 = PyFloat_AS_DOUBLE(a);
        return 0;
    }

    if (PyArray_IsScalar(a, Double)) {
        *arg1 = PyArrayScalar_VAL(a, Double);
        return 0;
    }
    else if (PyArray_IsScalar(a, Generic)) {
        PyArray_Descr *descr1;

        if (!PyArray_IsScalar(a, Number)) {
            return -1;
        }
        descr1 = PyArray_DescrFromTypeObject((PyObject *)Py_TYPE(a));
        if (PyArray_CanCastSafely(descr1->type_num, NPY_DOUBLE)) {
            PyArray_CastScalarDirect(a, descr1, arg1, NPY_DOUBLE);
            Py_DECREF(descr1);
            return 0;
        }
        else {
            Py_DECREF(descr1);
            return -1;
        }
    }
    else if (PyArray_GetPriority(a, NPY_PRIORITY) > NPY_PRIORITY) {
        return -2;
    }
    else if ((temp = PyArray_ScalarFromObject(a)) != NULL) {
        int retval = _double_convert_to_ctype(temp, arg1);

        Py_DECREF(temp);
        return retval;
    }
    return -2;
}




#line 707
static int
_byte_convert2_to_ctypes(PyObject *a, npy_byte *arg1,
                           PyObject *b, npy_byte *arg2)
{
    int ret;
    ret = _byte_convert_to_ctype(a, arg1);
    if (ret < 0) {
        return ret;
    }
    ret = _byte_convert_to_ctype(b, arg2);
    if (ret < 0) {
        return ret;
    }
    return 0;
}

#line 707
static int
_ubyte_convert2_to_ctypes(PyObject *a, npy_ubyte *arg1,
                           PyObject *b, npy_ubyte *arg2)
{
    int ret;
    ret = _ubyte_convert_to_ctype(a, arg1);
    if (ret < 0) {
        return ret;
    }
    ret = _ubyte_convert_to_ctype(b, arg2);
    if (ret < 0) {
        return ret;
    }
    return 0;
}

#line 707
static int
_short_convert2_to_ctypes(PyObject *a, npy_short *arg1,
                           PyObject *b, npy_short *arg2)
{
    int ret;
    ret = _short_convert_to_ctype(a, arg1);
    if (ret < 0) {
        return ret;
    }
    ret = _short_convert_to_ctype(b, arg2);
    if (ret < 0) {
        return ret;
    }
    return 0;
}

#line 707
static int
_ushort_convert2_to_ctypes(PyObject *a, npy_ushort *arg1,
                           PyObject *b, npy_ushort *arg2)
{
    int ret;
    ret = _ushort_convert_to_ctype(a, arg1);
    if (ret < 0) {
        return ret;
    }
    ret = _ushort_convert_to_ctype(b, arg2);
    if (ret < 0) {
        return ret;
    }
    return 0;
}

#line 707
static int
_int_convert2_to_ctypes(PyObject *a, npy_int *arg1,
                           PyObject *b, npy_int *arg2)
{
    int ret;
    ret = _int_convert_to_ctype(a, arg1);
    if (ret < 0) {
        return ret;
    }
    ret = _int_convert_to_ctype(b, arg2);
    if (ret < 0) {
        return ret;
    }
    return 0;
}

#line 707
static int
_uint_convert2_to_ctypes(PyObject *a, npy_uint *arg1,
                           PyObject *b, npy_uint *arg2)
{
    int ret;
    ret = _uint_convert_to_ctype(a, arg1);
    if (ret < 0) {
        return ret;
    }
    ret = _uint_convert_to_ctype(b, arg2);
    if (ret < 0) {
        return ret;
    }
    return 0;
}

#line 707
static int
_long_convert2_to_ctypes(PyObject *a, npy_long *arg1,
                           PyObject *b, npy_long *arg2)
{
    int ret;
    ret = _long_convert_to_ctype(a, arg1);
    if (ret < 0) {
        return ret;
    }
    ret = _long_convert_to_ctype(b, arg2);
    if (ret < 0) {
        return ret;
    }
    return 0;
}

#line 707
static int
_ulong_convert2_to_ctypes(PyObject *a, npy_ulong *arg1,
                           PyObject *b, npy_ulong *arg2)
{
    int ret;
    ret = _ulong_convert_to_ctype(a, arg1);
    if (ret < 0) {
        return ret;
    }
    ret = _ulong_convert_to_ctype(b, arg2);
    if (ret < 0) {
        return ret;
    }
    return 0;
}

#line 707
static int
_longlong_convert2_to_ctypes(PyObject *a, npy_longlong *arg1,
                           PyObject *b, npy_longlong *arg2)
{
    int ret;
    ret = _longlong_convert_to_ctype(a, arg1);
    if (ret < 0) {
        return ret;
    }
    ret = _longlong_convert_to_ctype(b, arg2);
    if (ret < 0) {
        return ret;
    }
    return 0;
}

#line 707
static int
_ulonglong_convert2_to_ctypes(PyObject *a, npy_ulonglong *arg1,
                           PyObject *b, npy_ulonglong *arg2)
{
    int ret;
    ret = _ulonglong_convert_to_ctype(a, arg1);
    if (ret < 0) {
        return ret;
    }
    ret = _ulonglong_convert_to_ctype(b, arg2);
    if (ret < 0) {
        return ret;
    }
    return 0;
}

#line 707
static int
_half_convert2_to_ctypes(PyObject *a, npy_half *arg1,
                           PyObject *b, npy_half *arg2)
{
    int ret;
    ret = _half_convert_to_ctype(a, arg1);
    if (ret < 0) {
        return ret;
    }
    ret = _half_convert_to_ctype(b, arg2);
    if (ret < 0) {
        return ret;
    }
    return 0;
}

#line 707
static int
_float_convert2_to_ctypes(PyObject *a, npy_float *arg1,
                           PyObject *b, npy_float *arg2)
{
    int ret;
    ret = _float_convert_to_ctype(a, arg1);
    if (ret < 0) {
        return ret;
    }
    ret = _float_convert_to_ctype(b, arg2);
    if (ret < 0) {
        return ret;
    }
    return 0;
}

#line 707
static int
_double_convert2_to_ctypes(PyObject *a, npy_double *arg1,
                           PyObject *b, npy_double *arg2)
{
    int ret;
    ret = _double_convert_to_ctype(a, arg1);
    if (ret < 0) {
        return ret;
    }
    ret = _double_convert_to_ctype(b, arg2);
    if (ret < 0) {
        return ret;
    }
    return 0;
}

#line 707
static int
_cfloat_convert2_to_ctypes(PyObject *a, npy_cfloat *arg1,
                           PyObject *b, npy_cfloat *arg2)
{
    int ret;
    ret = _cfloat_convert_to_ctype(a, arg1);
    if (ret < 0) {
        return ret;
    }
    ret = _cfloat_convert_to_ctype(b, arg2);
    if (ret < 0) {
        return ret;
    }
    return 0;
}

#line 707
static int
_cdouble_convert2_to_ctypes(PyObject *a, npy_cdouble *arg1,
                           PyObject *b, npy_cdouble *arg2)
{
    int ret;
    ret = _cdouble_convert_to_ctype(a, arg1);
    if (ret < 0) {
        return ret;
    }
    ret = _cdouble_convert_to_ctype(b, arg2);
    if (ret < 0) {
        return ret;
    }
    return 0;
}


#line 728

static int
_longdouble_convert2_to_ctypes(PyObject *a, npy_longdouble *arg1,
                           PyObject *b, npy_longdouble *arg2)
{
    int ret;
    ret = _longdouble_convert_to_ctype(a, arg1);
    if (ret < 0) {
        return ret;
    }
    ret = _longdouble_convert_to_ctype(b, arg2);
    if (ret == -2) {
        ret = -3;
    }
    if (ret < 0) {
        return ret;
    }
    return 0;
}


#line 728

static int
_clongdouble_convert2_to_ctypes(PyObject *a, npy_clongdouble *arg1,
                           PyObject *b, npy_clongdouble *arg2)
{
    int ret;
    ret = _clongdouble_convert_to_ctype(a, arg1);
    if (ret < 0) {
        return ret;
    }
    ret = _clongdouble_convert_to_ctype(b, arg2);
    if (ret == -2) {
        ret = -3;
    }
    if (ret < 0) {
        return ret;
    }
    return 0;
}




#if defined(NPY_PY3K)
#define CODEGEN_SKIP_divide_FLAG
#endif

#line 798

#if !defined(CODEGEN_SKIP_add_FLAG)

static PyObject *
byte_add(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_byte arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_byte out;
#if 0
    npy_byte out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_add, byte_add);

    switch(_byte_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_add(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_add(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    byte_ctype_add(arg1, arg2, (npy_byte *)&out, &out2);
#else
    byte_ctype_add(arg1, arg2, (npy_byte *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("byte_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Byte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Byte, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Byte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Byte, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Byte);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Byte, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_add_FLAG)

static PyObject *
ubyte_add(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ubyte arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ubyte out;
#if 0
    npy_ubyte out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_add, ubyte_add);

    switch(_ubyte_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_add(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_add(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ubyte_ctype_add(arg1, arg2, (npy_ubyte *)&out, &out2);
#else
    ubyte_ctype_add(arg1, arg2, (npy_ubyte *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ubyte_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UByte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UByte, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UByte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UByte, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UByte);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UByte, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_add_FLAG)

static PyObject *
short_add(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_short arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_short out;
#if 0
    npy_short out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_add, short_add);

    switch(_short_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_add(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_add(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    short_ctype_add(arg1, arg2, (npy_short *)&out, &out2);
#else
    short_ctype_add(arg1, arg2, (npy_short *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("short_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Short);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Short, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Short);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Short, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Short);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Short, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_add_FLAG)

static PyObject *
ushort_add(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ushort arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ushort out;
#if 0
    npy_ushort out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_add, ushort_add);

    switch(_ushort_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_add(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_add(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ushort_ctype_add(arg1, arg2, (npy_ushort *)&out, &out2);
#else
    ushort_ctype_add(arg1, arg2, (npy_ushort *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ushort_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UShort);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UShort, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UShort);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UShort, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UShort);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UShort, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_add_FLAG)

static PyObject *
int_add(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_int arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_int out;
#if 0
    npy_int out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_add, int_add);

    switch(_int_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_add(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_add(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    int_ctype_add(arg1, arg2, (npy_int *)&out, &out2);
#else
    int_ctype_add(arg1, arg2, (npy_int *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("int_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Int);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Int, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Int);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Int, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Int);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Int, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_add_FLAG)

static PyObject *
uint_add(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_uint arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_uint out;
#if 0
    npy_uint out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_add, uint_add);

    switch(_uint_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_add(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_add(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    uint_ctype_add(arg1, arg2, (npy_uint *)&out, &out2);
#else
    uint_ctype_add(arg1, arg2, (npy_uint *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("uint_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UInt);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UInt, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UInt);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UInt, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UInt);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UInt, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_add_FLAG)

static PyObject *
long_add(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_long arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_long out;
#if 0
    npy_long out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_add, long_add);

    switch(_long_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_add(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_add(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    long_ctype_add(arg1, arg2, (npy_long *)&out, &out2);
#else
    long_ctype_add(arg1, arg2, (npy_long *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("long_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Long);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Long, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Long);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Long, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Long);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Long, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_add_FLAG)

static PyObject *
ulong_add(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ulong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ulong out;
#if 0
    npy_ulong out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_add, ulong_add);

    switch(_ulong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_add(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_add(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ulong_ctype_add(arg1, arg2, (npy_ulong *)&out, &out2);
#else
    ulong_ctype_add(arg1, arg2, (npy_ulong *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ulong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(ULong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(ULong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(ULong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, ULong, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_add_FLAG)

static PyObject *
longlong_add(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_longlong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_longlong out;
#if 0
    npy_longlong out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_add, longlong_add);

    switch(_longlong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_add(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_add(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    longlong_ctype_add(arg1, arg2, (npy_longlong *)&out, &out2);
#else
    longlong_ctype_add(arg1, arg2, (npy_longlong *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("longlong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(LongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongLong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(LongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongLong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(LongLong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, LongLong, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_add_FLAG)

static PyObject *
ulonglong_add(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ulonglong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ulonglong out;
#if 0
    npy_ulonglong out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_add, ulonglong_add);

    switch(_ulonglong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_add(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_add(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ulonglong_ctype_add(arg1, arg2, (npy_ulonglong *)&out, &out2);
#else
    ulonglong_ctype_add(arg1, arg2, (npy_ulonglong *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ulonglong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(ULongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULongLong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(ULongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULongLong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(ULongLong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, ULongLong, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_subtract_FLAG)

static PyObject *
byte_subtract(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_byte arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_byte out;
#if 0
    npy_byte out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_subtract, byte_subtract);

    switch(_byte_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_subtract(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_subtract(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    byte_ctype_subtract(arg1, arg2, (npy_byte *)&out, &out2);
#else
    byte_ctype_subtract(arg1, arg2, (npy_byte *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("byte_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Byte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Byte, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Byte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Byte, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Byte);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Byte, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_subtract_FLAG)

static PyObject *
ubyte_subtract(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ubyte arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ubyte out;
#if 0
    npy_ubyte out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_subtract, ubyte_subtract);

    switch(_ubyte_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_subtract(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_subtract(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ubyte_ctype_subtract(arg1, arg2, (npy_ubyte *)&out, &out2);
#else
    ubyte_ctype_subtract(arg1, arg2, (npy_ubyte *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ubyte_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UByte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UByte, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UByte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UByte, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UByte);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UByte, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_subtract_FLAG)

static PyObject *
short_subtract(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_short arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_short out;
#if 0
    npy_short out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_subtract, short_subtract);

    switch(_short_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_subtract(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_subtract(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    short_ctype_subtract(arg1, arg2, (npy_short *)&out, &out2);
#else
    short_ctype_subtract(arg1, arg2, (npy_short *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("short_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Short);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Short, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Short);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Short, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Short);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Short, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_subtract_FLAG)

static PyObject *
ushort_subtract(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ushort arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ushort out;
#if 0
    npy_ushort out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_subtract, ushort_subtract);

    switch(_ushort_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_subtract(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_subtract(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ushort_ctype_subtract(arg1, arg2, (npy_ushort *)&out, &out2);
#else
    ushort_ctype_subtract(arg1, arg2, (npy_ushort *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ushort_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UShort);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UShort, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UShort);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UShort, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UShort);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UShort, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_subtract_FLAG)

static PyObject *
int_subtract(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_int arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_int out;
#if 0
    npy_int out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_subtract, int_subtract);

    switch(_int_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_subtract(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_subtract(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    int_ctype_subtract(arg1, arg2, (npy_int *)&out, &out2);
#else
    int_ctype_subtract(arg1, arg2, (npy_int *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("int_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Int);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Int, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Int);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Int, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Int);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Int, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_subtract_FLAG)

static PyObject *
uint_subtract(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_uint arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_uint out;
#if 0
    npy_uint out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_subtract, uint_subtract);

    switch(_uint_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_subtract(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_subtract(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    uint_ctype_subtract(arg1, arg2, (npy_uint *)&out, &out2);
#else
    uint_ctype_subtract(arg1, arg2, (npy_uint *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("uint_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UInt);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UInt, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UInt);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UInt, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UInt);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UInt, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_subtract_FLAG)

static PyObject *
long_subtract(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_long arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_long out;
#if 0
    npy_long out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_subtract, long_subtract);

    switch(_long_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_subtract(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_subtract(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    long_ctype_subtract(arg1, arg2, (npy_long *)&out, &out2);
#else
    long_ctype_subtract(arg1, arg2, (npy_long *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("long_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Long);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Long, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Long);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Long, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Long);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Long, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_subtract_FLAG)

static PyObject *
ulong_subtract(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ulong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ulong out;
#if 0
    npy_ulong out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_subtract, ulong_subtract);

    switch(_ulong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_subtract(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_subtract(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ulong_ctype_subtract(arg1, arg2, (npy_ulong *)&out, &out2);
#else
    ulong_ctype_subtract(arg1, arg2, (npy_ulong *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ulong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(ULong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(ULong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(ULong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, ULong, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_subtract_FLAG)

static PyObject *
longlong_subtract(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_longlong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_longlong out;
#if 0
    npy_longlong out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_subtract, longlong_subtract);

    switch(_longlong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_subtract(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_subtract(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    longlong_ctype_subtract(arg1, arg2, (npy_longlong *)&out, &out2);
#else
    longlong_ctype_subtract(arg1, arg2, (npy_longlong *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("longlong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(LongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongLong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(LongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongLong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(LongLong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, LongLong, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_subtract_FLAG)

static PyObject *
ulonglong_subtract(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ulonglong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ulonglong out;
#if 0
    npy_ulonglong out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_subtract, ulonglong_subtract);

    switch(_ulonglong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_subtract(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_subtract(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ulonglong_ctype_subtract(arg1, arg2, (npy_ulonglong *)&out, &out2);
#else
    ulonglong_ctype_subtract(arg1, arg2, (npy_ulonglong *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ulonglong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(ULongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULongLong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(ULongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULongLong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(ULongLong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, ULongLong, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_multiply_FLAG)

static PyObject *
byte_multiply(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_byte arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_byte out;
#if 0
    npy_byte out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_multiply, byte_multiply);

    switch(_byte_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_multiply(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_multiply(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    byte_ctype_multiply(arg1, arg2, (npy_byte *)&out, &out2);
#else
    byte_ctype_multiply(arg1, arg2, (npy_byte *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("byte_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Byte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Byte, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Byte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Byte, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Byte);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Byte, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_multiply_FLAG)

static PyObject *
ubyte_multiply(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ubyte arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ubyte out;
#if 0
    npy_ubyte out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_multiply, ubyte_multiply);

    switch(_ubyte_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_multiply(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_multiply(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ubyte_ctype_multiply(arg1, arg2, (npy_ubyte *)&out, &out2);
#else
    ubyte_ctype_multiply(arg1, arg2, (npy_ubyte *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ubyte_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UByte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UByte, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UByte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UByte, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UByte);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UByte, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_multiply_FLAG)

static PyObject *
short_multiply(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_short arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_short out;
#if 0
    npy_short out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_multiply, short_multiply);

    switch(_short_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_multiply(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_multiply(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    short_ctype_multiply(arg1, arg2, (npy_short *)&out, &out2);
#else
    short_ctype_multiply(arg1, arg2, (npy_short *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("short_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Short);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Short, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Short);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Short, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Short);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Short, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_multiply_FLAG)

static PyObject *
ushort_multiply(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ushort arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ushort out;
#if 0
    npy_ushort out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_multiply, ushort_multiply);

    switch(_ushort_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_multiply(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_multiply(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ushort_ctype_multiply(arg1, arg2, (npy_ushort *)&out, &out2);
#else
    ushort_ctype_multiply(arg1, arg2, (npy_ushort *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ushort_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UShort);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UShort, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UShort);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UShort, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UShort);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UShort, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_multiply_FLAG)

static PyObject *
int_multiply(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_int arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_int out;
#if 0
    npy_int out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_multiply, int_multiply);

    switch(_int_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_multiply(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_multiply(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    int_ctype_multiply(arg1, arg2, (npy_int *)&out, &out2);
#else
    int_ctype_multiply(arg1, arg2, (npy_int *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("int_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Int);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Int, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Int);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Int, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Int);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Int, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_multiply_FLAG)

static PyObject *
uint_multiply(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_uint arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_uint out;
#if 0
    npy_uint out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_multiply, uint_multiply);

    switch(_uint_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_multiply(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_multiply(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    uint_ctype_multiply(arg1, arg2, (npy_uint *)&out, &out2);
#else
    uint_ctype_multiply(arg1, arg2, (npy_uint *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("uint_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UInt);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UInt, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UInt);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UInt, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UInt);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UInt, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_multiply_FLAG)

static PyObject *
long_multiply(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_long arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_long out;
#if 0
    npy_long out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_multiply, long_multiply);

    switch(_long_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_multiply(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_multiply(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    long_ctype_multiply(arg1, arg2, (npy_long *)&out, &out2);
#else
    long_ctype_multiply(arg1, arg2, (npy_long *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("long_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Long);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Long, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Long);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Long, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Long);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Long, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_multiply_FLAG)

static PyObject *
ulong_multiply(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ulong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ulong out;
#if 0
    npy_ulong out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_multiply, ulong_multiply);

    switch(_ulong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_multiply(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_multiply(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ulong_ctype_multiply(arg1, arg2, (npy_ulong *)&out, &out2);
#else
    ulong_ctype_multiply(arg1, arg2, (npy_ulong *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ulong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(ULong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(ULong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(ULong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, ULong, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_multiply_FLAG)

static PyObject *
longlong_multiply(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_longlong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_longlong out;
#if 0
    npy_longlong out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_multiply, longlong_multiply);

    switch(_longlong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_multiply(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_multiply(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    longlong_ctype_multiply(arg1, arg2, (npy_longlong *)&out, &out2);
#else
    longlong_ctype_multiply(arg1, arg2, (npy_longlong *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("longlong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(LongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongLong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(LongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongLong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(LongLong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, LongLong, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_multiply_FLAG)

static PyObject *
ulonglong_multiply(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ulonglong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ulonglong out;
#if 0
    npy_ulonglong out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_multiply, ulonglong_multiply);

    switch(_ulonglong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_multiply(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_multiply(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ulonglong_ctype_multiply(arg1, arg2, (npy_ulonglong *)&out, &out2);
#else
    ulonglong_ctype_multiply(arg1, arg2, (npy_ulonglong *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ulonglong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(ULongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULongLong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(ULongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULongLong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(ULongLong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, ULongLong, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_divide_FLAG)

static PyObject *
byte_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_byte arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_byte out;
#if 0
    npy_byte out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_divide, byte_divide);

    switch(_byte_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    byte_ctype_divide(arg1, arg2, (npy_byte *)&out, &out2);
#else
    byte_ctype_divide(arg1, arg2, (npy_byte *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("byte_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Byte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Byte, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Byte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Byte, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Byte);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Byte, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_divide_FLAG)

static PyObject *
ubyte_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ubyte arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ubyte out;
#if 0
    npy_ubyte out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_divide, ubyte_divide);

    switch(_ubyte_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ubyte_ctype_divide(arg1, arg2, (npy_ubyte *)&out, &out2);
#else
    ubyte_ctype_divide(arg1, arg2, (npy_ubyte *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ubyte_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UByte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UByte, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UByte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UByte, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UByte);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UByte, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_divide_FLAG)

static PyObject *
short_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_short arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_short out;
#if 0
    npy_short out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_divide, short_divide);

    switch(_short_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    short_ctype_divide(arg1, arg2, (npy_short *)&out, &out2);
#else
    short_ctype_divide(arg1, arg2, (npy_short *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("short_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Short);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Short, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Short);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Short, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Short);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Short, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_divide_FLAG)

static PyObject *
ushort_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ushort arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ushort out;
#if 0
    npy_ushort out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_divide, ushort_divide);

    switch(_ushort_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ushort_ctype_divide(arg1, arg2, (npy_ushort *)&out, &out2);
#else
    ushort_ctype_divide(arg1, arg2, (npy_ushort *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ushort_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UShort);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UShort, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UShort);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UShort, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UShort);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UShort, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_divide_FLAG)

static PyObject *
int_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_int arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_int out;
#if 0
    npy_int out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_divide, int_divide);

    switch(_int_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    int_ctype_divide(arg1, arg2, (npy_int *)&out, &out2);
#else
    int_ctype_divide(arg1, arg2, (npy_int *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("int_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Int);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Int, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Int);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Int, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Int);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Int, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_divide_FLAG)

static PyObject *
uint_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_uint arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_uint out;
#if 0
    npy_uint out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_divide, uint_divide);

    switch(_uint_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    uint_ctype_divide(arg1, arg2, (npy_uint *)&out, &out2);
#else
    uint_ctype_divide(arg1, arg2, (npy_uint *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("uint_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UInt);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UInt, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UInt);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UInt, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UInt);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UInt, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_divide_FLAG)

static PyObject *
long_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_long arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_long out;
#if 0
    npy_long out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_divide, long_divide);

    switch(_long_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    long_ctype_divide(arg1, arg2, (npy_long *)&out, &out2);
#else
    long_ctype_divide(arg1, arg2, (npy_long *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("long_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Long);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Long, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Long);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Long, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Long);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Long, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_divide_FLAG)

static PyObject *
ulong_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ulong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ulong out;
#if 0
    npy_ulong out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_divide, ulong_divide);

    switch(_ulong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ulong_ctype_divide(arg1, arg2, (npy_ulong *)&out, &out2);
#else
    ulong_ctype_divide(arg1, arg2, (npy_ulong *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ulong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(ULong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(ULong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(ULong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, ULong, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_divide_FLAG)

static PyObject *
longlong_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_longlong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_longlong out;
#if 0
    npy_longlong out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_divide, longlong_divide);

    switch(_longlong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    longlong_ctype_divide(arg1, arg2, (npy_longlong *)&out, &out2);
#else
    longlong_ctype_divide(arg1, arg2, (npy_longlong *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("longlong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(LongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongLong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(LongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongLong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(LongLong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, LongLong, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_divide_FLAG)

static PyObject *
ulonglong_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ulonglong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ulonglong out;
#if 0
    npy_ulonglong out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_divide, ulonglong_divide);

    switch(_ulonglong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ulonglong_ctype_divide(arg1, arg2, (npy_ulonglong *)&out, &out2);
#else
    ulonglong_ctype_divide(arg1, arg2, (npy_ulonglong *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ulonglong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(ULongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULongLong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(ULongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULongLong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(ULongLong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, ULongLong, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_remainder_FLAG)

static PyObject *
byte_remainder(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_byte arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_byte out;
#if 0
    npy_byte out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_remainder, byte_remainder);

    switch(_byte_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_remainder(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_remainder(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    byte_ctype_remainder(arg1, arg2, (npy_byte *)&out, &out2);
#else
    byte_ctype_remainder(arg1, arg2, (npy_byte *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("byte_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Byte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Byte, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Byte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Byte, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Byte);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Byte, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_remainder_FLAG)

static PyObject *
ubyte_remainder(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ubyte arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ubyte out;
#if 0
    npy_ubyte out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_remainder, ubyte_remainder);

    switch(_ubyte_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_remainder(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_remainder(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ubyte_ctype_remainder(arg1, arg2, (npy_ubyte *)&out, &out2);
#else
    ubyte_ctype_remainder(arg1, arg2, (npy_ubyte *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ubyte_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UByte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UByte, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UByte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UByte, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UByte);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UByte, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_remainder_FLAG)

static PyObject *
short_remainder(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_short arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_short out;
#if 0
    npy_short out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_remainder, short_remainder);

    switch(_short_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_remainder(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_remainder(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    short_ctype_remainder(arg1, arg2, (npy_short *)&out, &out2);
#else
    short_ctype_remainder(arg1, arg2, (npy_short *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("short_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Short);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Short, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Short);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Short, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Short);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Short, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_remainder_FLAG)

static PyObject *
ushort_remainder(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ushort arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ushort out;
#if 0
    npy_ushort out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_remainder, ushort_remainder);

    switch(_ushort_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_remainder(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_remainder(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ushort_ctype_remainder(arg1, arg2, (npy_ushort *)&out, &out2);
#else
    ushort_ctype_remainder(arg1, arg2, (npy_ushort *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ushort_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UShort);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UShort, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UShort);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UShort, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UShort);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UShort, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_remainder_FLAG)

static PyObject *
int_remainder(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_int arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_int out;
#if 0
    npy_int out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_remainder, int_remainder);

    switch(_int_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_remainder(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_remainder(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    int_ctype_remainder(arg1, arg2, (npy_int *)&out, &out2);
#else
    int_ctype_remainder(arg1, arg2, (npy_int *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("int_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Int);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Int, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Int);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Int, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Int);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Int, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_remainder_FLAG)

static PyObject *
uint_remainder(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_uint arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_uint out;
#if 0
    npy_uint out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_remainder, uint_remainder);

    switch(_uint_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_remainder(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_remainder(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    uint_ctype_remainder(arg1, arg2, (npy_uint *)&out, &out2);
#else
    uint_ctype_remainder(arg1, arg2, (npy_uint *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("uint_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UInt);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UInt, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UInt);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UInt, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UInt);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UInt, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_remainder_FLAG)

static PyObject *
long_remainder(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_long arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_long out;
#if 0
    npy_long out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_remainder, long_remainder);

    switch(_long_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_remainder(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_remainder(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    long_ctype_remainder(arg1, arg2, (npy_long *)&out, &out2);
#else
    long_ctype_remainder(arg1, arg2, (npy_long *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("long_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Long);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Long, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Long);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Long, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Long);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Long, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_remainder_FLAG)

static PyObject *
ulong_remainder(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ulong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ulong out;
#if 0
    npy_ulong out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_remainder, ulong_remainder);

    switch(_ulong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_remainder(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_remainder(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ulong_ctype_remainder(arg1, arg2, (npy_ulong *)&out, &out2);
#else
    ulong_ctype_remainder(arg1, arg2, (npy_ulong *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ulong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(ULong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(ULong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(ULong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, ULong, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_remainder_FLAG)

static PyObject *
longlong_remainder(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_longlong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_longlong out;
#if 0
    npy_longlong out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_remainder, longlong_remainder);

    switch(_longlong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_remainder(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_remainder(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    longlong_ctype_remainder(arg1, arg2, (npy_longlong *)&out, &out2);
#else
    longlong_ctype_remainder(arg1, arg2, (npy_longlong *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("longlong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(LongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongLong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(LongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongLong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(LongLong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, LongLong, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_remainder_FLAG)

static PyObject *
ulonglong_remainder(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ulonglong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ulonglong out;
#if 0
    npy_ulonglong out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_remainder, ulonglong_remainder);

    switch(_ulonglong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_remainder(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_remainder(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ulonglong_ctype_remainder(arg1, arg2, (npy_ulonglong *)&out, &out2);
#else
    ulonglong_ctype_remainder(arg1, arg2, (npy_ulonglong *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ulonglong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(ULongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULongLong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(ULongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULongLong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(ULongLong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, ULongLong, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_divmod_FLAG)

static PyObject *
byte_divmod(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_byte arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_byte out;
#if 1
    npy_byte out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_divmod, byte_divmod);

    switch(_byte_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_divmod(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_divmod(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 1
    byte_ctype_divmod(arg1, arg2, (npy_byte *)&out, &out2);
#else
    byte_ctype_divmod(arg1, arg2, (npy_byte *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("byte_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 1
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Byte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Byte, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Byte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Byte, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Byte);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Byte, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_divmod_FLAG)

static PyObject *
ubyte_divmod(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ubyte arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ubyte out;
#if 1
    npy_ubyte out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_divmod, ubyte_divmod);

    switch(_ubyte_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_divmod(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_divmod(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 1
    ubyte_ctype_divmod(arg1, arg2, (npy_ubyte *)&out, &out2);
#else
    ubyte_ctype_divmod(arg1, arg2, (npy_ubyte *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ubyte_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 1
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UByte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UByte, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UByte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UByte, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UByte);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UByte, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_divmod_FLAG)

static PyObject *
short_divmod(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_short arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_short out;
#if 1
    npy_short out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_divmod, short_divmod);

    switch(_short_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_divmod(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_divmod(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 1
    short_ctype_divmod(arg1, arg2, (npy_short *)&out, &out2);
#else
    short_ctype_divmod(arg1, arg2, (npy_short *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("short_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 1
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Short);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Short, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Short);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Short, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Short);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Short, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_divmod_FLAG)

static PyObject *
ushort_divmod(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ushort arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ushort out;
#if 1
    npy_ushort out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_divmod, ushort_divmod);

    switch(_ushort_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_divmod(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_divmod(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 1
    ushort_ctype_divmod(arg1, arg2, (npy_ushort *)&out, &out2);
#else
    ushort_ctype_divmod(arg1, arg2, (npy_ushort *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ushort_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 1
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UShort);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UShort, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UShort);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UShort, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UShort);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UShort, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_divmod_FLAG)

static PyObject *
int_divmod(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_int arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_int out;
#if 1
    npy_int out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_divmod, int_divmod);

    switch(_int_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_divmod(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_divmod(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 1
    int_ctype_divmod(arg1, arg2, (npy_int *)&out, &out2);
#else
    int_ctype_divmod(arg1, arg2, (npy_int *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("int_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 1
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Int);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Int, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Int);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Int, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Int);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Int, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_divmod_FLAG)

static PyObject *
uint_divmod(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_uint arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_uint out;
#if 1
    npy_uint out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_divmod, uint_divmod);

    switch(_uint_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_divmod(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_divmod(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 1
    uint_ctype_divmod(arg1, arg2, (npy_uint *)&out, &out2);
#else
    uint_ctype_divmod(arg1, arg2, (npy_uint *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("uint_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 1
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UInt);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UInt, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UInt);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UInt, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UInt);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UInt, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_divmod_FLAG)

static PyObject *
long_divmod(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_long arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_long out;
#if 1
    npy_long out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_divmod, long_divmod);

    switch(_long_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_divmod(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_divmod(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 1
    long_ctype_divmod(arg1, arg2, (npy_long *)&out, &out2);
#else
    long_ctype_divmod(arg1, arg2, (npy_long *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("long_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 1
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Long);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Long, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Long);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Long, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Long);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Long, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_divmod_FLAG)

static PyObject *
ulong_divmod(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ulong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ulong out;
#if 1
    npy_ulong out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_divmod, ulong_divmod);

    switch(_ulong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_divmod(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_divmod(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 1
    ulong_ctype_divmod(arg1, arg2, (npy_ulong *)&out, &out2);
#else
    ulong_ctype_divmod(arg1, arg2, (npy_ulong *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ulong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 1
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(ULong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(ULong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(ULong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, ULong, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_divmod_FLAG)

static PyObject *
longlong_divmod(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_longlong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_longlong out;
#if 1
    npy_longlong out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_divmod, longlong_divmod);

    switch(_longlong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_divmod(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_divmod(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 1
    longlong_ctype_divmod(arg1, arg2, (npy_longlong *)&out, &out2);
#else
    longlong_ctype_divmod(arg1, arg2, (npy_longlong *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("longlong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 1
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(LongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongLong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(LongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongLong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(LongLong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, LongLong, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_divmod_FLAG)

static PyObject *
ulonglong_divmod(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ulonglong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ulonglong out;
#if 1
    npy_ulonglong out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_divmod, ulonglong_divmod);

    switch(_ulonglong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_divmod(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_divmod(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 1
    ulonglong_ctype_divmod(arg1, arg2, (npy_ulonglong *)&out, &out2);
#else
    ulonglong_ctype_divmod(arg1, arg2, (npy_ulonglong *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ulonglong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 1
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(ULongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULongLong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(ULongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULongLong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(ULongLong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, ULongLong, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_floor_divide_FLAG)

static PyObject *
byte_floor_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_byte arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_byte out;
#if 0
    npy_byte out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_floor_divide, byte_floor_divide);

    switch(_byte_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_floor_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_floor_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    byte_ctype_floor_divide(arg1, arg2, (npy_byte *)&out, &out2);
#else
    byte_ctype_floor_divide(arg1, arg2, (npy_byte *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("byte_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Byte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Byte, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Byte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Byte, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Byte);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Byte, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_floor_divide_FLAG)

static PyObject *
ubyte_floor_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ubyte arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ubyte out;
#if 0
    npy_ubyte out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_floor_divide, ubyte_floor_divide);

    switch(_ubyte_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_floor_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_floor_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ubyte_ctype_floor_divide(arg1, arg2, (npy_ubyte *)&out, &out2);
#else
    ubyte_ctype_floor_divide(arg1, arg2, (npy_ubyte *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ubyte_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UByte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UByte, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UByte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UByte, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UByte);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UByte, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_floor_divide_FLAG)

static PyObject *
short_floor_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_short arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_short out;
#if 0
    npy_short out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_floor_divide, short_floor_divide);

    switch(_short_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_floor_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_floor_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    short_ctype_floor_divide(arg1, arg2, (npy_short *)&out, &out2);
#else
    short_ctype_floor_divide(arg1, arg2, (npy_short *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("short_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Short);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Short, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Short);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Short, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Short);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Short, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_floor_divide_FLAG)

static PyObject *
ushort_floor_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ushort arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ushort out;
#if 0
    npy_ushort out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_floor_divide, ushort_floor_divide);

    switch(_ushort_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_floor_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_floor_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ushort_ctype_floor_divide(arg1, arg2, (npy_ushort *)&out, &out2);
#else
    ushort_ctype_floor_divide(arg1, arg2, (npy_ushort *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ushort_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UShort);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UShort, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UShort);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UShort, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UShort);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UShort, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_floor_divide_FLAG)

static PyObject *
int_floor_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_int arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_int out;
#if 0
    npy_int out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_floor_divide, int_floor_divide);

    switch(_int_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_floor_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_floor_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    int_ctype_floor_divide(arg1, arg2, (npy_int *)&out, &out2);
#else
    int_ctype_floor_divide(arg1, arg2, (npy_int *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("int_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Int);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Int, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Int);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Int, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Int);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Int, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_floor_divide_FLAG)

static PyObject *
uint_floor_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_uint arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_uint out;
#if 0
    npy_uint out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_floor_divide, uint_floor_divide);

    switch(_uint_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_floor_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_floor_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    uint_ctype_floor_divide(arg1, arg2, (npy_uint *)&out, &out2);
#else
    uint_ctype_floor_divide(arg1, arg2, (npy_uint *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("uint_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UInt);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UInt, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UInt);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UInt, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UInt);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UInt, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_floor_divide_FLAG)

static PyObject *
long_floor_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_long arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_long out;
#if 0
    npy_long out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_floor_divide, long_floor_divide);

    switch(_long_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_floor_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_floor_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    long_ctype_floor_divide(arg1, arg2, (npy_long *)&out, &out2);
#else
    long_ctype_floor_divide(arg1, arg2, (npy_long *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("long_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Long);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Long, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Long);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Long, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Long);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Long, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_floor_divide_FLAG)

static PyObject *
ulong_floor_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ulong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ulong out;
#if 0
    npy_ulong out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_floor_divide, ulong_floor_divide);

    switch(_ulong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_floor_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_floor_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ulong_ctype_floor_divide(arg1, arg2, (npy_ulong *)&out, &out2);
#else
    ulong_ctype_floor_divide(arg1, arg2, (npy_ulong *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ulong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(ULong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(ULong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(ULong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, ULong, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_floor_divide_FLAG)

static PyObject *
longlong_floor_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_longlong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_longlong out;
#if 0
    npy_longlong out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_floor_divide, longlong_floor_divide);

    switch(_longlong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_floor_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_floor_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    longlong_ctype_floor_divide(arg1, arg2, (npy_longlong *)&out, &out2);
#else
    longlong_ctype_floor_divide(arg1, arg2, (npy_longlong *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("longlong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(LongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongLong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(LongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongLong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(LongLong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, LongLong, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_floor_divide_FLAG)

static PyObject *
ulonglong_floor_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ulonglong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ulonglong out;
#if 0
    npy_ulonglong out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_floor_divide, ulonglong_floor_divide);

    switch(_ulonglong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_floor_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_floor_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ulonglong_ctype_floor_divide(arg1, arg2, (npy_ulonglong *)&out, &out2);
#else
    ulonglong_ctype_floor_divide(arg1, arg2, (npy_ulonglong *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ulonglong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(ULongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULongLong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(ULongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULongLong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(ULongLong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, ULongLong, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_lshift_FLAG)

static PyObject *
byte_lshift(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_byte arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_byte out;
#if 0
    npy_byte out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_lshift, byte_lshift);

    switch(_byte_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_lshift(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_lshift(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    byte_ctype_lshift(arg1, arg2, (npy_byte *)&out, &out2);
#else
    byte_ctype_lshift(arg1, arg2, (npy_byte *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("byte_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Byte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Byte, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Byte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Byte, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Byte);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Byte, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_lshift_FLAG)

static PyObject *
ubyte_lshift(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ubyte arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ubyte out;
#if 0
    npy_ubyte out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_lshift, ubyte_lshift);

    switch(_ubyte_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_lshift(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_lshift(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ubyte_ctype_lshift(arg1, arg2, (npy_ubyte *)&out, &out2);
#else
    ubyte_ctype_lshift(arg1, arg2, (npy_ubyte *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ubyte_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UByte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UByte, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UByte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UByte, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UByte);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UByte, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_lshift_FLAG)

static PyObject *
short_lshift(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_short arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_short out;
#if 0
    npy_short out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_lshift, short_lshift);

    switch(_short_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_lshift(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_lshift(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    short_ctype_lshift(arg1, arg2, (npy_short *)&out, &out2);
#else
    short_ctype_lshift(arg1, arg2, (npy_short *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("short_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Short);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Short, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Short);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Short, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Short);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Short, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_lshift_FLAG)

static PyObject *
ushort_lshift(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ushort arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ushort out;
#if 0
    npy_ushort out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_lshift, ushort_lshift);

    switch(_ushort_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_lshift(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_lshift(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ushort_ctype_lshift(arg1, arg2, (npy_ushort *)&out, &out2);
#else
    ushort_ctype_lshift(arg1, arg2, (npy_ushort *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ushort_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UShort);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UShort, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UShort);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UShort, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UShort);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UShort, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_lshift_FLAG)

static PyObject *
int_lshift(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_int arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_int out;
#if 0
    npy_int out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_lshift, int_lshift);

    switch(_int_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_lshift(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_lshift(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    int_ctype_lshift(arg1, arg2, (npy_int *)&out, &out2);
#else
    int_ctype_lshift(arg1, arg2, (npy_int *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("int_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Int);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Int, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Int);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Int, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Int);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Int, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_lshift_FLAG)

static PyObject *
uint_lshift(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_uint arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_uint out;
#if 0
    npy_uint out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_lshift, uint_lshift);

    switch(_uint_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_lshift(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_lshift(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    uint_ctype_lshift(arg1, arg2, (npy_uint *)&out, &out2);
#else
    uint_ctype_lshift(arg1, arg2, (npy_uint *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("uint_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UInt);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UInt, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UInt);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UInt, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UInt);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UInt, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_lshift_FLAG)

static PyObject *
long_lshift(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_long arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_long out;
#if 0
    npy_long out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_lshift, long_lshift);

    switch(_long_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_lshift(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_lshift(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    long_ctype_lshift(arg1, arg2, (npy_long *)&out, &out2);
#else
    long_ctype_lshift(arg1, arg2, (npy_long *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("long_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Long);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Long, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Long);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Long, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Long);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Long, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_lshift_FLAG)

static PyObject *
ulong_lshift(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ulong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ulong out;
#if 0
    npy_ulong out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_lshift, ulong_lshift);

    switch(_ulong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_lshift(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_lshift(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ulong_ctype_lshift(arg1, arg2, (npy_ulong *)&out, &out2);
#else
    ulong_ctype_lshift(arg1, arg2, (npy_ulong *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ulong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(ULong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(ULong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(ULong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, ULong, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_lshift_FLAG)

static PyObject *
longlong_lshift(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_longlong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_longlong out;
#if 0
    npy_longlong out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_lshift, longlong_lshift);

    switch(_longlong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_lshift(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_lshift(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    longlong_ctype_lshift(arg1, arg2, (npy_longlong *)&out, &out2);
#else
    longlong_ctype_lshift(arg1, arg2, (npy_longlong *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("longlong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(LongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongLong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(LongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongLong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(LongLong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, LongLong, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_lshift_FLAG)

static PyObject *
ulonglong_lshift(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ulonglong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ulonglong out;
#if 0
    npy_ulonglong out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_lshift, ulonglong_lshift);

    switch(_ulonglong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_lshift(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_lshift(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ulonglong_ctype_lshift(arg1, arg2, (npy_ulonglong *)&out, &out2);
#else
    ulonglong_ctype_lshift(arg1, arg2, (npy_ulonglong *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ulonglong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(ULongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULongLong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(ULongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULongLong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(ULongLong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, ULongLong, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_rshift_FLAG)

static PyObject *
byte_rshift(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_byte arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_byte out;
#if 0
    npy_byte out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_rshift, byte_rshift);

    switch(_byte_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_rshift(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_rshift(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    byte_ctype_rshift(arg1, arg2, (npy_byte *)&out, &out2);
#else
    byte_ctype_rshift(arg1, arg2, (npy_byte *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("byte_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Byte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Byte, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Byte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Byte, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Byte);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Byte, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_rshift_FLAG)

static PyObject *
ubyte_rshift(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ubyte arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ubyte out;
#if 0
    npy_ubyte out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_rshift, ubyte_rshift);

    switch(_ubyte_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_rshift(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_rshift(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ubyte_ctype_rshift(arg1, arg2, (npy_ubyte *)&out, &out2);
#else
    ubyte_ctype_rshift(arg1, arg2, (npy_ubyte *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ubyte_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UByte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UByte, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UByte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UByte, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UByte);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UByte, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_rshift_FLAG)

static PyObject *
short_rshift(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_short arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_short out;
#if 0
    npy_short out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_rshift, short_rshift);

    switch(_short_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_rshift(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_rshift(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    short_ctype_rshift(arg1, arg2, (npy_short *)&out, &out2);
#else
    short_ctype_rshift(arg1, arg2, (npy_short *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("short_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Short);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Short, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Short);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Short, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Short);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Short, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_rshift_FLAG)

static PyObject *
ushort_rshift(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ushort arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ushort out;
#if 0
    npy_ushort out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_rshift, ushort_rshift);

    switch(_ushort_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_rshift(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_rshift(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ushort_ctype_rshift(arg1, arg2, (npy_ushort *)&out, &out2);
#else
    ushort_ctype_rshift(arg1, arg2, (npy_ushort *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ushort_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UShort);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UShort, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UShort);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UShort, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UShort);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UShort, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_rshift_FLAG)

static PyObject *
int_rshift(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_int arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_int out;
#if 0
    npy_int out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_rshift, int_rshift);

    switch(_int_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_rshift(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_rshift(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    int_ctype_rshift(arg1, arg2, (npy_int *)&out, &out2);
#else
    int_ctype_rshift(arg1, arg2, (npy_int *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("int_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Int);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Int, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Int);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Int, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Int);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Int, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_rshift_FLAG)

static PyObject *
uint_rshift(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_uint arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_uint out;
#if 0
    npy_uint out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_rshift, uint_rshift);

    switch(_uint_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_rshift(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_rshift(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    uint_ctype_rshift(arg1, arg2, (npy_uint *)&out, &out2);
#else
    uint_ctype_rshift(arg1, arg2, (npy_uint *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("uint_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UInt);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UInt, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UInt);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UInt, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UInt);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UInt, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_rshift_FLAG)

static PyObject *
long_rshift(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_long arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_long out;
#if 0
    npy_long out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_rshift, long_rshift);

    switch(_long_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_rshift(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_rshift(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    long_ctype_rshift(arg1, arg2, (npy_long *)&out, &out2);
#else
    long_ctype_rshift(arg1, arg2, (npy_long *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("long_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Long);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Long, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Long);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Long, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Long);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Long, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_rshift_FLAG)

static PyObject *
ulong_rshift(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ulong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ulong out;
#if 0
    npy_ulong out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_rshift, ulong_rshift);

    switch(_ulong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_rshift(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_rshift(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ulong_ctype_rshift(arg1, arg2, (npy_ulong *)&out, &out2);
#else
    ulong_ctype_rshift(arg1, arg2, (npy_ulong *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ulong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(ULong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(ULong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(ULong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, ULong, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_rshift_FLAG)

static PyObject *
longlong_rshift(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_longlong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_longlong out;
#if 0
    npy_longlong out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_rshift, longlong_rshift);

    switch(_longlong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_rshift(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_rshift(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    longlong_ctype_rshift(arg1, arg2, (npy_longlong *)&out, &out2);
#else
    longlong_ctype_rshift(arg1, arg2, (npy_longlong *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("longlong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(LongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongLong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(LongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongLong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(LongLong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, LongLong, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_rshift_FLAG)

static PyObject *
ulonglong_rshift(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ulonglong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ulonglong out;
#if 0
    npy_ulonglong out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_rshift, ulonglong_rshift);

    switch(_ulonglong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_rshift(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_rshift(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ulonglong_ctype_rshift(arg1, arg2, (npy_ulonglong *)&out, &out2);
#else
    ulonglong_ctype_rshift(arg1, arg2, (npy_ulonglong *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ulonglong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(ULongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULongLong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(ULongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULongLong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(ULongLong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, ULongLong, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_and_FLAG)

static PyObject *
byte_and(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_byte arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_byte out;
#if 0
    npy_byte out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_and, byte_and);

    switch(_byte_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_and(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_and(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    byte_ctype_and(arg1, arg2, (npy_byte *)&out, &out2);
#else
    byte_ctype_and(arg1, arg2, (npy_byte *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("byte_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Byte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Byte, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Byte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Byte, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Byte);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Byte, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_and_FLAG)

static PyObject *
ubyte_and(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ubyte arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ubyte out;
#if 0
    npy_ubyte out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_and, ubyte_and);

    switch(_ubyte_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_and(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_and(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ubyte_ctype_and(arg1, arg2, (npy_ubyte *)&out, &out2);
#else
    ubyte_ctype_and(arg1, arg2, (npy_ubyte *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ubyte_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UByte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UByte, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UByte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UByte, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UByte);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UByte, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_and_FLAG)

static PyObject *
short_and(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_short arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_short out;
#if 0
    npy_short out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_and, short_and);

    switch(_short_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_and(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_and(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    short_ctype_and(arg1, arg2, (npy_short *)&out, &out2);
#else
    short_ctype_and(arg1, arg2, (npy_short *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("short_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Short);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Short, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Short);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Short, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Short);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Short, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_and_FLAG)

static PyObject *
ushort_and(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ushort arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ushort out;
#if 0
    npy_ushort out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_and, ushort_and);

    switch(_ushort_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_and(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_and(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ushort_ctype_and(arg1, arg2, (npy_ushort *)&out, &out2);
#else
    ushort_ctype_and(arg1, arg2, (npy_ushort *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ushort_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UShort);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UShort, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UShort);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UShort, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UShort);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UShort, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_and_FLAG)

static PyObject *
int_and(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_int arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_int out;
#if 0
    npy_int out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_and, int_and);

    switch(_int_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_and(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_and(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    int_ctype_and(arg1, arg2, (npy_int *)&out, &out2);
#else
    int_ctype_and(arg1, arg2, (npy_int *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("int_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Int);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Int, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Int);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Int, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Int);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Int, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_and_FLAG)

static PyObject *
uint_and(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_uint arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_uint out;
#if 0
    npy_uint out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_and, uint_and);

    switch(_uint_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_and(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_and(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    uint_ctype_and(arg1, arg2, (npy_uint *)&out, &out2);
#else
    uint_ctype_and(arg1, arg2, (npy_uint *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("uint_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UInt);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UInt, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UInt);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UInt, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UInt);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UInt, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_and_FLAG)

static PyObject *
long_and(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_long arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_long out;
#if 0
    npy_long out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_and, long_and);

    switch(_long_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_and(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_and(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    long_ctype_and(arg1, arg2, (npy_long *)&out, &out2);
#else
    long_ctype_and(arg1, arg2, (npy_long *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("long_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Long);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Long, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Long);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Long, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Long);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Long, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_and_FLAG)

static PyObject *
ulong_and(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ulong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ulong out;
#if 0
    npy_ulong out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_and, ulong_and);

    switch(_ulong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_and(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_and(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ulong_ctype_and(arg1, arg2, (npy_ulong *)&out, &out2);
#else
    ulong_ctype_and(arg1, arg2, (npy_ulong *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ulong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(ULong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(ULong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(ULong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, ULong, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_and_FLAG)

static PyObject *
longlong_and(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_longlong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_longlong out;
#if 0
    npy_longlong out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_and, longlong_and);

    switch(_longlong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_and(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_and(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    longlong_ctype_and(arg1, arg2, (npy_longlong *)&out, &out2);
#else
    longlong_ctype_and(arg1, arg2, (npy_longlong *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("longlong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(LongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongLong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(LongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongLong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(LongLong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, LongLong, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_and_FLAG)

static PyObject *
ulonglong_and(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ulonglong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ulonglong out;
#if 0
    npy_ulonglong out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_and, ulonglong_and);

    switch(_ulonglong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_and(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_and(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ulonglong_ctype_and(arg1, arg2, (npy_ulonglong *)&out, &out2);
#else
    ulonglong_ctype_and(arg1, arg2, (npy_ulonglong *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ulonglong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(ULongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULongLong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(ULongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULongLong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(ULongLong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, ULongLong, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_or_FLAG)

static PyObject *
byte_or(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_byte arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_byte out;
#if 0
    npy_byte out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_or, byte_or);

    switch(_byte_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_or(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_or(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    byte_ctype_or(arg1, arg2, (npy_byte *)&out, &out2);
#else
    byte_ctype_or(arg1, arg2, (npy_byte *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("byte_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Byte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Byte, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Byte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Byte, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Byte);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Byte, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_or_FLAG)

static PyObject *
ubyte_or(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ubyte arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ubyte out;
#if 0
    npy_ubyte out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_or, ubyte_or);

    switch(_ubyte_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_or(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_or(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ubyte_ctype_or(arg1, arg2, (npy_ubyte *)&out, &out2);
#else
    ubyte_ctype_or(arg1, arg2, (npy_ubyte *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ubyte_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UByte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UByte, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UByte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UByte, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UByte);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UByte, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_or_FLAG)

static PyObject *
short_or(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_short arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_short out;
#if 0
    npy_short out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_or, short_or);

    switch(_short_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_or(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_or(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    short_ctype_or(arg1, arg2, (npy_short *)&out, &out2);
#else
    short_ctype_or(arg1, arg2, (npy_short *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("short_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Short);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Short, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Short);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Short, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Short);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Short, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_or_FLAG)

static PyObject *
ushort_or(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ushort arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ushort out;
#if 0
    npy_ushort out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_or, ushort_or);

    switch(_ushort_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_or(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_or(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ushort_ctype_or(arg1, arg2, (npy_ushort *)&out, &out2);
#else
    ushort_ctype_or(arg1, arg2, (npy_ushort *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ushort_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UShort);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UShort, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UShort);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UShort, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UShort);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UShort, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_or_FLAG)

static PyObject *
int_or(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_int arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_int out;
#if 0
    npy_int out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_or, int_or);

    switch(_int_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_or(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_or(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    int_ctype_or(arg1, arg2, (npy_int *)&out, &out2);
#else
    int_ctype_or(arg1, arg2, (npy_int *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("int_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Int);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Int, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Int);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Int, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Int);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Int, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_or_FLAG)

static PyObject *
uint_or(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_uint arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_uint out;
#if 0
    npy_uint out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_or, uint_or);

    switch(_uint_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_or(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_or(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    uint_ctype_or(arg1, arg2, (npy_uint *)&out, &out2);
#else
    uint_ctype_or(arg1, arg2, (npy_uint *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("uint_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UInt);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UInt, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UInt);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UInt, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UInt);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UInt, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_or_FLAG)

static PyObject *
long_or(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_long arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_long out;
#if 0
    npy_long out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_or, long_or);

    switch(_long_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_or(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_or(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    long_ctype_or(arg1, arg2, (npy_long *)&out, &out2);
#else
    long_ctype_or(arg1, arg2, (npy_long *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("long_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Long);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Long, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Long);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Long, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Long);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Long, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_or_FLAG)

static PyObject *
ulong_or(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ulong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ulong out;
#if 0
    npy_ulong out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_or, ulong_or);

    switch(_ulong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_or(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_or(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ulong_ctype_or(arg1, arg2, (npy_ulong *)&out, &out2);
#else
    ulong_ctype_or(arg1, arg2, (npy_ulong *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ulong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(ULong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(ULong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(ULong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, ULong, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_or_FLAG)

static PyObject *
longlong_or(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_longlong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_longlong out;
#if 0
    npy_longlong out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_or, longlong_or);

    switch(_longlong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_or(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_or(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    longlong_ctype_or(arg1, arg2, (npy_longlong *)&out, &out2);
#else
    longlong_ctype_or(arg1, arg2, (npy_longlong *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("longlong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(LongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongLong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(LongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongLong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(LongLong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, LongLong, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_or_FLAG)

static PyObject *
ulonglong_or(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ulonglong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ulonglong out;
#if 0
    npy_ulonglong out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_or, ulonglong_or);

    switch(_ulonglong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_or(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_or(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ulonglong_ctype_or(arg1, arg2, (npy_ulonglong *)&out, &out2);
#else
    ulonglong_ctype_or(arg1, arg2, (npy_ulonglong *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ulonglong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(ULongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULongLong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(ULongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULongLong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(ULongLong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, ULongLong, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_xor_FLAG)

static PyObject *
byte_xor(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_byte arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_byte out;
#if 0
    npy_byte out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_xor, byte_xor);

    switch(_byte_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_xor(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_xor(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    byte_ctype_xor(arg1, arg2, (npy_byte *)&out, &out2);
#else
    byte_ctype_xor(arg1, arg2, (npy_byte *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("byte_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Byte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Byte, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Byte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Byte, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Byte);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Byte, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_xor_FLAG)

static PyObject *
ubyte_xor(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ubyte arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ubyte out;
#if 0
    npy_ubyte out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_xor, ubyte_xor);

    switch(_ubyte_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_xor(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_xor(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ubyte_ctype_xor(arg1, arg2, (npy_ubyte *)&out, &out2);
#else
    ubyte_ctype_xor(arg1, arg2, (npy_ubyte *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ubyte_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UByte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UByte, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UByte);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UByte, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UByte);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UByte, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_xor_FLAG)

static PyObject *
short_xor(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_short arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_short out;
#if 0
    npy_short out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_xor, short_xor);

    switch(_short_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_xor(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_xor(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    short_ctype_xor(arg1, arg2, (npy_short *)&out, &out2);
#else
    short_ctype_xor(arg1, arg2, (npy_short *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("short_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Short);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Short, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Short);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Short, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Short);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Short, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_xor_FLAG)

static PyObject *
ushort_xor(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ushort arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ushort out;
#if 0
    npy_ushort out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_xor, ushort_xor);

    switch(_ushort_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_xor(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_xor(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ushort_ctype_xor(arg1, arg2, (npy_ushort *)&out, &out2);
#else
    ushort_ctype_xor(arg1, arg2, (npy_ushort *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ushort_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UShort);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UShort, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UShort);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UShort, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UShort);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UShort, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_xor_FLAG)

static PyObject *
int_xor(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_int arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_int out;
#if 0
    npy_int out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_xor, int_xor);

    switch(_int_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_xor(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_xor(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    int_ctype_xor(arg1, arg2, (npy_int *)&out, &out2);
#else
    int_ctype_xor(arg1, arg2, (npy_int *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("int_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Int);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Int, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Int);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Int, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Int);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Int, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_xor_FLAG)

static PyObject *
uint_xor(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_uint arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_uint out;
#if 0
    npy_uint out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_xor, uint_xor);

    switch(_uint_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_xor(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_xor(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    uint_ctype_xor(arg1, arg2, (npy_uint *)&out, &out2);
#else
    uint_ctype_xor(arg1, arg2, (npy_uint *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("uint_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(UInt);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UInt, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(UInt);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, UInt, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(UInt);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UInt, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_xor_FLAG)

static PyObject *
long_xor(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_long arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_long out;
#if 0
    npy_long out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_xor, long_xor);

    switch(_long_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_xor(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_xor(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    long_ctype_xor(arg1, arg2, (npy_long *)&out, &out2);
#else
    long_ctype_xor(arg1, arg2, (npy_long *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("long_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Long);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Long, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Long);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Long, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Long);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Long, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_xor_FLAG)

static PyObject *
ulong_xor(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ulong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ulong out;
#if 0
    npy_ulong out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_xor, ulong_xor);

    switch(_ulong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_xor(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_xor(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ulong_ctype_xor(arg1, arg2, (npy_ulong *)&out, &out2);
#else
    ulong_ctype_xor(arg1, arg2, (npy_ulong *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ulong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(ULong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(ULong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(ULong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, ULong, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_xor_FLAG)

static PyObject *
longlong_xor(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_longlong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_longlong out;
#if 0
    npy_longlong out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_xor, longlong_xor);

    switch(_longlong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_xor(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_xor(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    longlong_ctype_xor(arg1, arg2, (npy_longlong *)&out, &out2);
#else
    longlong_ctype_xor(arg1, arg2, (npy_longlong *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("longlong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(LongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongLong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(LongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongLong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(LongLong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, LongLong, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_xor_FLAG)

static PyObject *
ulonglong_xor(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ulonglong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_ulonglong out;
#if 0
    npy_ulonglong out2;
    PyObject *obj;
#endif

#if 0
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_xor, ulonglong_xor);

    switch(_ulonglong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_xor(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_xor(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 0
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ulonglong_ctype_xor(arg1, arg2, (npy_ulonglong *)&out, &out2);
#else
    ulonglong_ctype_xor(arg1, arg2, (npy_ulonglong *)&out);
#endif

#if 0
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ulonglong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(ULongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULongLong, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(ULongLong);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, ULongLong, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(ULongLong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, ULongLong, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_true_divide_FLAG)

static PyObject *
byte_true_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_byte arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_float out;
#if 0
    npy_float out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_true_divide, byte_true_divide);

    switch(_byte_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_true_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_true_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    byte_ctype_true_divide(arg1, arg2, (npy_float *)&out, &out2);
#else
    byte_ctype_true_divide(arg1, arg2, (npy_float *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("byte_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Float);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Float, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Float);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Float, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Float);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Float, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_true_divide_FLAG)

static PyObject *
ubyte_true_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ubyte arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_float out;
#if 0
    npy_float out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_true_divide, ubyte_true_divide);

    switch(_ubyte_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_true_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_true_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ubyte_ctype_true_divide(arg1, arg2, (npy_float *)&out, &out2);
#else
    ubyte_ctype_true_divide(arg1, arg2, (npy_float *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ubyte_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Float);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Float, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Float);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Float, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Float);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Float, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_true_divide_FLAG)

static PyObject *
short_true_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_short arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_float out;
#if 0
    npy_float out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_true_divide, short_true_divide);

    switch(_short_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_true_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_true_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    short_ctype_true_divide(arg1, arg2, (npy_float *)&out, &out2);
#else
    short_ctype_true_divide(arg1, arg2, (npy_float *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("short_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Float);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Float, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Float);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Float, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Float);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Float, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_true_divide_FLAG)

static PyObject *
ushort_true_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ushort arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_float out;
#if 0
    npy_float out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_true_divide, ushort_true_divide);

    switch(_ushort_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_true_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_true_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ushort_ctype_true_divide(arg1, arg2, (npy_float *)&out, &out2);
#else
    ushort_ctype_true_divide(arg1, arg2, (npy_float *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ushort_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Float);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Float, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Float);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Float, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Float);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Float, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_true_divide_FLAG)

static PyObject *
int_true_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_int arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_double out;
#if 0
    npy_double out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_true_divide, int_true_divide);

    switch(_int_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_true_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_true_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    int_ctype_true_divide(arg1, arg2, (npy_double *)&out, &out2);
#else
    int_ctype_true_divide(arg1, arg2, (npy_double *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("int_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Double);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Double, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Double);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Double, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Double);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Double, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_true_divide_FLAG)

static PyObject *
uint_true_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_uint arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_double out;
#if 0
    npy_double out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_true_divide, uint_true_divide);

    switch(_uint_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_true_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_true_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    uint_ctype_true_divide(arg1, arg2, (npy_double *)&out, &out2);
#else
    uint_ctype_true_divide(arg1, arg2, (npy_double *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("uint_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Double);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Double, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Double);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Double, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Double);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Double, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_true_divide_FLAG)

static PyObject *
long_true_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_long arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_double out;
#if 0
    npy_double out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_true_divide, long_true_divide);

    switch(_long_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_true_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_true_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    long_ctype_true_divide(arg1, arg2, (npy_double *)&out, &out2);
#else
    long_ctype_true_divide(arg1, arg2, (npy_double *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("long_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Double);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Double, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Double);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Double, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Double);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Double, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_true_divide_FLAG)

static PyObject *
ulong_true_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ulong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_double out;
#if 0
    npy_double out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_true_divide, ulong_true_divide);

    switch(_ulong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_true_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_true_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ulong_ctype_true_divide(arg1, arg2, (npy_double *)&out, &out2);
#else
    ulong_ctype_true_divide(arg1, arg2, (npy_double *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ulong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Double);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Double, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Double);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Double, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Double);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Double, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_true_divide_FLAG)

static PyObject *
longlong_true_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_longlong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_double out;
#if 0
    npy_double out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_true_divide, longlong_true_divide);

    switch(_longlong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_true_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_true_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    longlong_ctype_true_divide(arg1, arg2, (npy_double *)&out, &out2);
#else
    longlong_ctype_true_divide(arg1, arg2, (npy_double *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("longlong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Double);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Double, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Double);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Double, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Double);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Double, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_true_divide_FLAG)

static PyObject *
ulonglong_true_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_ulonglong arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_double out;
#if 0
    npy_double out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_true_divide, ulonglong_true_divide);

    switch(_ulonglong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_true_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_true_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    ulonglong_ctype_true_divide(arg1, arg2, (npy_double *)&out, &out2);
#else
    ulonglong_ctype_true_divide(arg1, arg2, (npy_double *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ulonglong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Double);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Double, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Double);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Double, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Double);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Double, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_add_FLAG)

static PyObject *
half_add(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_half arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_half out;
#if 0
    npy_half out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_add, half_add);

    switch(_half_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_add(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_add(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    half_ctype_add(arg1, arg2, (npy_half *)&out, &out2);
#else
    half_ctype_add(arg1, arg2, (npy_half *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("half_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Half);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Half, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Half);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Half, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Half);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Half, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_add_FLAG)

static PyObject *
float_add(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_float arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_float out;
#if 0
    npy_float out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_add, float_add);

    switch(_float_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_add(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_add(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    float_ctype_add(arg1, arg2, (npy_float *)&out, &out2);
#else
    float_ctype_add(arg1, arg2, (npy_float *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("float_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Float);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Float, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Float);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Float, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Float);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Float, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_add_FLAG)

static PyObject *
double_add(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_double arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_double out;
#if 0
    npy_double out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_add, double_add);

    switch(_double_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_add(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_add(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    double_ctype_add(arg1, arg2, (npy_double *)&out, &out2);
#else
    double_ctype_add(arg1, arg2, (npy_double *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("double_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Double);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Double, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Double);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Double, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Double);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Double, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_add_FLAG)

static PyObject *
longdouble_add(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_longdouble arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_longdouble out;
#if 0
    npy_longdouble out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_add, longdouble_add);

    switch(_longdouble_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_add(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_add(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    longdouble_ctype_add(arg1, arg2, (npy_longdouble *)&out, &out2);
#else
    longdouble_ctype_add(arg1, arg2, (npy_longdouble *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("longdouble_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(LongDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongDouble, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(LongDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongDouble, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(LongDouble);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, LongDouble, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_add_FLAG)

static PyObject *
cfloat_add(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_cfloat arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_cfloat out;
#if 0
    npy_cfloat out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_add, cfloat_add);

    switch(_cfloat_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_add(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_add(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    cfloat_ctype_add(arg1, arg2, (npy_cfloat *)&out, &out2);
#else
    cfloat_ctype_add(arg1, arg2, (npy_cfloat *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("cfloat_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(CFloat);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CFloat, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(CFloat);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CFloat, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(CFloat);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, CFloat, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_add_FLAG)

static PyObject *
cdouble_add(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_cdouble arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_cdouble out;
#if 0
    npy_cdouble out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_add, cdouble_add);

    switch(_cdouble_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_add(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_add(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    cdouble_ctype_add(arg1, arg2, (npy_cdouble *)&out, &out2);
#else
    cdouble_ctype_add(arg1, arg2, (npy_cdouble *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("cdouble_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(CDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CDouble, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(CDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CDouble, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(CDouble);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, CDouble, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_add_FLAG)

static PyObject *
clongdouble_add(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_clongdouble arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_clongdouble out;
#if 0
    npy_clongdouble out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_add, clongdouble_add);

    switch(_clongdouble_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_add(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_add(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    clongdouble_ctype_add(arg1, arg2, (npy_clongdouble *)&out, &out2);
#else
    clongdouble_ctype_add(arg1, arg2, (npy_clongdouble *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("clongdouble_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(CLongDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CLongDouble, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(CLongDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CLongDouble, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(CLongDouble);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, CLongDouble, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_subtract_FLAG)

static PyObject *
half_subtract(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_half arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_half out;
#if 0
    npy_half out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_subtract, half_subtract);

    switch(_half_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_subtract(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_subtract(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    half_ctype_subtract(arg1, arg2, (npy_half *)&out, &out2);
#else
    half_ctype_subtract(arg1, arg2, (npy_half *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("half_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Half);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Half, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Half);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Half, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Half);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Half, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_subtract_FLAG)

static PyObject *
float_subtract(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_float arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_float out;
#if 0
    npy_float out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_subtract, float_subtract);

    switch(_float_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_subtract(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_subtract(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    float_ctype_subtract(arg1, arg2, (npy_float *)&out, &out2);
#else
    float_ctype_subtract(arg1, arg2, (npy_float *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("float_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Float);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Float, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Float);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Float, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Float);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Float, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_subtract_FLAG)

static PyObject *
double_subtract(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_double arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_double out;
#if 0
    npy_double out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_subtract, double_subtract);

    switch(_double_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_subtract(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_subtract(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    double_ctype_subtract(arg1, arg2, (npy_double *)&out, &out2);
#else
    double_ctype_subtract(arg1, arg2, (npy_double *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("double_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Double);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Double, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Double);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Double, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Double);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Double, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_subtract_FLAG)

static PyObject *
longdouble_subtract(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_longdouble arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_longdouble out;
#if 0
    npy_longdouble out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_subtract, longdouble_subtract);

    switch(_longdouble_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_subtract(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_subtract(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    longdouble_ctype_subtract(arg1, arg2, (npy_longdouble *)&out, &out2);
#else
    longdouble_ctype_subtract(arg1, arg2, (npy_longdouble *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("longdouble_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(LongDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongDouble, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(LongDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongDouble, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(LongDouble);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, LongDouble, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_subtract_FLAG)

static PyObject *
cfloat_subtract(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_cfloat arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_cfloat out;
#if 0
    npy_cfloat out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_subtract, cfloat_subtract);

    switch(_cfloat_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_subtract(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_subtract(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    cfloat_ctype_subtract(arg1, arg2, (npy_cfloat *)&out, &out2);
#else
    cfloat_ctype_subtract(arg1, arg2, (npy_cfloat *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("cfloat_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(CFloat);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CFloat, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(CFloat);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CFloat, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(CFloat);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, CFloat, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_subtract_FLAG)

static PyObject *
cdouble_subtract(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_cdouble arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_cdouble out;
#if 0
    npy_cdouble out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_subtract, cdouble_subtract);

    switch(_cdouble_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_subtract(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_subtract(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    cdouble_ctype_subtract(arg1, arg2, (npy_cdouble *)&out, &out2);
#else
    cdouble_ctype_subtract(arg1, arg2, (npy_cdouble *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("cdouble_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(CDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CDouble, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(CDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CDouble, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(CDouble);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, CDouble, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_subtract_FLAG)

static PyObject *
clongdouble_subtract(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_clongdouble arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_clongdouble out;
#if 0
    npy_clongdouble out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_subtract, clongdouble_subtract);

    switch(_clongdouble_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_subtract(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_subtract(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    clongdouble_ctype_subtract(arg1, arg2, (npy_clongdouble *)&out, &out2);
#else
    clongdouble_ctype_subtract(arg1, arg2, (npy_clongdouble *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("clongdouble_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(CLongDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CLongDouble, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(CLongDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CLongDouble, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(CLongDouble);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, CLongDouble, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_multiply_FLAG)

static PyObject *
half_multiply(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_half arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_half out;
#if 0
    npy_half out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_multiply, half_multiply);

    switch(_half_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_multiply(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_multiply(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    half_ctype_multiply(arg1, arg2, (npy_half *)&out, &out2);
#else
    half_ctype_multiply(arg1, arg2, (npy_half *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("half_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Half);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Half, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Half);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Half, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Half);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Half, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_multiply_FLAG)

static PyObject *
float_multiply(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_float arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_float out;
#if 0
    npy_float out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_multiply, float_multiply);

    switch(_float_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_multiply(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_multiply(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    float_ctype_multiply(arg1, arg2, (npy_float *)&out, &out2);
#else
    float_ctype_multiply(arg1, arg2, (npy_float *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("float_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Float);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Float, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Float);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Float, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Float);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Float, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_multiply_FLAG)

static PyObject *
double_multiply(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_double arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_double out;
#if 0
    npy_double out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_multiply, double_multiply);

    switch(_double_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_multiply(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_multiply(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    double_ctype_multiply(arg1, arg2, (npy_double *)&out, &out2);
#else
    double_ctype_multiply(arg1, arg2, (npy_double *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("double_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Double);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Double, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Double);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Double, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Double);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Double, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_multiply_FLAG)

static PyObject *
longdouble_multiply(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_longdouble arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_longdouble out;
#if 0
    npy_longdouble out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_multiply, longdouble_multiply);

    switch(_longdouble_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_multiply(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_multiply(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    longdouble_ctype_multiply(arg1, arg2, (npy_longdouble *)&out, &out2);
#else
    longdouble_ctype_multiply(arg1, arg2, (npy_longdouble *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("longdouble_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(LongDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongDouble, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(LongDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongDouble, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(LongDouble);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, LongDouble, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_multiply_FLAG)

static PyObject *
cfloat_multiply(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_cfloat arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_cfloat out;
#if 0
    npy_cfloat out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_multiply, cfloat_multiply);

    switch(_cfloat_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_multiply(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_multiply(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    cfloat_ctype_multiply(arg1, arg2, (npy_cfloat *)&out, &out2);
#else
    cfloat_ctype_multiply(arg1, arg2, (npy_cfloat *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("cfloat_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(CFloat);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CFloat, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(CFloat);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CFloat, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(CFloat);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, CFloat, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_multiply_FLAG)

static PyObject *
cdouble_multiply(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_cdouble arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_cdouble out;
#if 0
    npy_cdouble out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_multiply, cdouble_multiply);

    switch(_cdouble_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_multiply(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_multiply(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    cdouble_ctype_multiply(arg1, arg2, (npy_cdouble *)&out, &out2);
#else
    cdouble_ctype_multiply(arg1, arg2, (npy_cdouble *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("cdouble_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(CDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CDouble, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(CDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CDouble, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(CDouble);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, CDouble, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_multiply_FLAG)

static PyObject *
clongdouble_multiply(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_clongdouble arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_clongdouble out;
#if 0
    npy_clongdouble out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_multiply, clongdouble_multiply);

    switch(_clongdouble_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_multiply(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_multiply(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    clongdouble_ctype_multiply(arg1, arg2, (npy_clongdouble *)&out, &out2);
#else
    clongdouble_ctype_multiply(arg1, arg2, (npy_clongdouble *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("clongdouble_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(CLongDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CLongDouble, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(CLongDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CLongDouble, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(CLongDouble);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, CLongDouble, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_divide_FLAG)

static PyObject *
half_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_half arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_half out;
#if 0
    npy_half out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_divide, half_divide);

    switch(_half_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    half_ctype_divide(arg1, arg2, (npy_half *)&out, &out2);
#else
    half_ctype_divide(arg1, arg2, (npy_half *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("half_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Half);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Half, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Half);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Half, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Half);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Half, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_divide_FLAG)

static PyObject *
float_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_float arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_float out;
#if 0
    npy_float out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_divide, float_divide);

    switch(_float_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    float_ctype_divide(arg1, arg2, (npy_float *)&out, &out2);
#else
    float_ctype_divide(arg1, arg2, (npy_float *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("float_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Float);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Float, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Float);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Float, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Float);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Float, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_divide_FLAG)

static PyObject *
double_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_double arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_double out;
#if 0
    npy_double out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_divide, double_divide);

    switch(_double_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    double_ctype_divide(arg1, arg2, (npy_double *)&out, &out2);
#else
    double_ctype_divide(arg1, arg2, (npy_double *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("double_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Double);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Double, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Double);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Double, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Double);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Double, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_divide_FLAG)

static PyObject *
longdouble_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_longdouble arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_longdouble out;
#if 0
    npy_longdouble out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_divide, longdouble_divide);

    switch(_longdouble_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    longdouble_ctype_divide(arg1, arg2, (npy_longdouble *)&out, &out2);
#else
    longdouble_ctype_divide(arg1, arg2, (npy_longdouble *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("longdouble_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(LongDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongDouble, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(LongDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongDouble, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(LongDouble);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, LongDouble, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_divide_FLAG)

static PyObject *
cfloat_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_cfloat arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_cfloat out;
#if 0
    npy_cfloat out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_divide, cfloat_divide);

    switch(_cfloat_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    cfloat_ctype_divide(arg1, arg2, (npy_cfloat *)&out, &out2);
#else
    cfloat_ctype_divide(arg1, arg2, (npy_cfloat *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("cfloat_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(CFloat);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CFloat, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(CFloat);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CFloat, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(CFloat);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, CFloat, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_divide_FLAG)

static PyObject *
cdouble_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_cdouble arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_cdouble out;
#if 0
    npy_cdouble out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_divide, cdouble_divide);

    switch(_cdouble_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    cdouble_ctype_divide(arg1, arg2, (npy_cdouble *)&out, &out2);
#else
    cdouble_ctype_divide(arg1, arg2, (npy_cdouble *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("cdouble_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(CDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CDouble, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(CDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CDouble, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(CDouble);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, CDouble, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_divide_FLAG)

static PyObject *
clongdouble_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_clongdouble arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_clongdouble out;
#if 0
    npy_clongdouble out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_divide, clongdouble_divide);

    switch(_clongdouble_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    clongdouble_ctype_divide(arg1, arg2, (npy_clongdouble *)&out, &out2);
#else
    clongdouble_ctype_divide(arg1, arg2, (npy_clongdouble *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("clongdouble_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(CLongDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CLongDouble, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(CLongDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CLongDouble, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(CLongDouble);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, CLongDouble, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_floor_divide_FLAG)

static PyObject *
half_floor_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_half arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_half out;
#if 0
    npy_half out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_floor_divide, half_floor_divide);

    switch(_half_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_floor_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_floor_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    half_ctype_floor_divide(arg1, arg2, (npy_half *)&out, &out2);
#else
    half_ctype_floor_divide(arg1, arg2, (npy_half *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("half_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Half);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Half, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Half);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Half, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Half);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Half, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_floor_divide_FLAG)

static PyObject *
float_floor_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_float arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_float out;
#if 0
    npy_float out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_floor_divide, float_floor_divide);

    switch(_float_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_floor_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_floor_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    float_ctype_floor_divide(arg1, arg2, (npy_float *)&out, &out2);
#else
    float_ctype_floor_divide(arg1, arg2, (npy_float *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("float_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Float);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Float, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Float);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Float, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Float);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Float, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_floor_divide_FLAG)

static PyObject *
double_floor_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_double arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_double out;
#if 0
    npy_double out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_floor_divide, double_floor_divide);

    switch(_double_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_floor_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_floor_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    double_ctype_floor_divide(arg1, arg2, (npy_double *)&out, &out2);
#else
    double_ctype_floor_divide(arg1, arg2, (npy_double *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("double_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Double);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Double, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Double);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Double, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Double);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Double, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_floor_divide_FLAG)

static PyObject *
longdouble_floor_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_longdouble arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_longdouble out;
#if 0
    npy_longdouble out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_floor_divide, longdouble_floor_divide);

    switch(_longdouble_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_floor_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_floor_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    longdouble_ctype_floor_divide(arg1, arg2, (npy_longdouble *)&out, &out2);
#else
    longdouble_ctype_floor_divide(arg1, arg2, (npy_longdouble *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("longdouble_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(LongDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongDouble, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(LongDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongDouble, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(LongDouble);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, LongDouble, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_floor_divide_FLAG)

static PyObject *
cfloat_floor_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_cfloat arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_cfloat out;
#if 0
    npy_cfloat out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_floor_divide, cfloat_floor_divide);

    switch(_cfloat_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_floor_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_floor_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    cfloat_ctype_floor_divide(arg1, arg2, (npy_cfloat *)&out, &out2);
#else
    cfloat_ctype_floor_divide(arg1, arg2, (npy_cfloat *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("cfloat_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(CFloat);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CFloat, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(CFloat);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CFloat, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(CFloat);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, CFloat, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_floor_divide_FLAG)

static PyObject *
cdouble_floor_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_cdouble arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_cdouble out;
#if 0
    npy_cdouble out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_floor_divide, cdouble_floor_divide);

    switch(_cdouble_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_floor_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_floor_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    cdouble_ctype_floor_divide(arg1, arg2, (npy_cdouble *)&out, &out2);
#else
    cdouble_ctype_floor_divide(arg1, arg2, (npy_cdouble *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("cdouble_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(CDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CDouble, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(CDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CDouble, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(CDouble);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, CDouble, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_floor_divide_FLAG)

static PyObject *
clongdouble_floor_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_clongdouble arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_clongdouble out;
#if 0
    npy_clongdouble out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_floor_divide, clongdouble_floor_divide);

    switch(_clongdouble_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_floor_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_floor_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    clongdouble_ctype_floor_divide(arg1, arg2, (npy_clongdouble *)&out, &out2);
#else
    clongdouble_ctype_floor_divide(arg1, arg2, (npy_clongdouble *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("clongdouble_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(CLongDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CLongDouble, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(CLongDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CLongDouble, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(CLongDouble);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, CLongDouble, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_true_divide_FLAG)

static PyObject *
half_true_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_half arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_half out;
#if 0
    npy_half out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_true_divide, half_true_divide);

    switch(_half_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_true_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_true_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    half_ctype_true_divide(arg1, arg2, (npy_half *)&out, &out2);
#else
    half_ctype_true_divide(arg1, arg2, (npy_half *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("half_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Half);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Half, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Half);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Half, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Half);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Half, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_true_divide_FLAG)

static PyObject *
float_true_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_float arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_float out;
#if 0
    npy_float out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_true_divide, float_true_divide);

    switch(_float_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_true_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_true_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    float_ctype_true_divide(arg1, arg2, (npy_float *)&out, &out2);
#else
    float_ctype_true_divide(arg1, arg2, (npy_float *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("float_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Float);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Float, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Float);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Float, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Float);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Float, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_true_divide_FLAG)

static PyObject *
double_true_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_double arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_double out;
#if 0
    npy_double out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_true_divide, double_true_divide);

    switch(_double_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_true_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_true_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    double_ctype_true_divide(arg1, arg2, (npy_double *)&out, &out2);
#else
    double_ctype_true_divide(arg1, arg2, (npy_double *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("double_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Double);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Double, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Double);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Double, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Double);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Double, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_true_divide_FLAG)

static PyObject *
longdouble_true_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_longdouble arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_longdouble out;
#if 0
    npy_longdouble out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_true_divide, longdouble_true_divide);

    switch(_longdouble_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_true_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_true_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    longdouble_ctype_true_divide(arg1, arg2, (npy_longdouble *)&out, &out2);
#else
    longdouble_ctype_true_divide(arg1, arg2, (npy_longdouble *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("longdouble_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(LongDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongDouble, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(LongDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongDouble, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(LongDouble);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, LongDouble, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_true_divide_FLAG)

static PyObject *
cfloat_true_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_cfloat arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_cfloat out;
#if 0
    npy_cfloat out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_true_divide, cfloat_true_divide);

    switch(_cfloat_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_true_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_true_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    cfloat_ctype_true_divide(arg1, arg2, (npy_cfloat *)&out, &out2);
#else
    cfloat_ctype_true_divide(arg1, arg2, (npy_cfloat *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("cfloat_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(CFloat);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CFloat, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(CFloat);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CFloat, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(CFloat);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, CFloat, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_true_divide_FLAG)

static PyObject *
cdouble_true_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_cdouble arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_cdouble out;
#if 0
    npy_cdouble out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_true_divide, cdouble_true_divide);

    switch(_cdouble_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_true_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_true_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    cdouble_ctype_true_divide(arg1, arg2, (npy_cdouble *)&out, &out2);
#else
    cdouble_ctype_true_divide(arg1, arg2, (npy_cdouble *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("cdouble_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(CDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CDouble, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(CDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CDouble, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(CDouble);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, CDouble, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_true_divide_FLAG)

static PyObject *
clongdouble_true_divide(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_clongdouble arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_clongdouble out;
#if 0
    npy_clongdouble out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_true_divide, clongdouble_true_divide);

    switch(_clongdouble_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_true_divide(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_true_divide(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    clongdouble_ctype_true_divide(arg1, arg2, (npy_clongdouble *)&out, &out2);
#else
    clongdouble_ctype_true_divide(arg1, arg2, (npy_clongdouble *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("clongdouble_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(CLongDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CLongDouble, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(CLongDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, CLongDouble, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(CLongDouble);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, CLongDouble, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_divmod_FLAG)

static PyObject *
half_divmod(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_half arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_half out;
#if 1
    npy_half out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_divmod, half_divmod);

    switch(_half_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_divmod(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_divmod(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 1
    half_ctype_divmod(arg1, arg2, (npy_half *)&out, &out2);
#else
    half_ctype_divmod(arg1, arg2, (npy_half *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("half_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 1
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Half);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Half, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Half);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Half, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Half);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Half, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_divmod_FLAG)

static PyObject *
float_divmod(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_float arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_float out;
#if 1
    npy_float out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_divmod, float_divmod);

    switch(_float_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_divmod(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_divmod(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 1
    float_ctype_divmod(arg1, arg2, (npy_float *)&out, &out2);
#else
    float_ctype_divmod(arg1, arg2, (npy_float *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("float_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 1
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Float);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Float, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Float);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Float, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Float);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Float, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_divmod_FLAG)

static PyObject *
double_divmod(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_double arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_double out;
#if 1
    npy_double out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_divmod, double_divmod);

    switch(_double_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_divmod(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_divmod(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 1
    double_ctype_divmod(arg1, arg2, (npy_double *)&out, &out2);
#else
    double_ctype_divmod(arg1, arg2, (npy_double *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("double_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 1
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Double);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Double, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Double);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Double, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Double);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Double, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_divmod_FLAG)

static PyObject *
longdouble_divmod(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_longdouble arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_longdouble out;
#if 1
    npy_longdouble out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_divmod, longdouble_divmod);

    switch(_longdouble_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_divmod(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_divmod(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 1
    longdouble_ctype_divmod(arg1, arg2, (npy_longdouble *)&out, &out2);
#else
    longdouble_ctype_divmod(arg1, arg2, (npy_longdouble *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("longdouble_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 1
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(LongDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongDouble, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(LongDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongDouble, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(LongDouble);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, LongDouble, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_remainder_FLAG)

static PyObject *
half_remainder(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_half arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_half out;
#if 0
    npy_half out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_remainder, half_remainder);

    switch(_half_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_remainder(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_remainder(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    half_ctype_remainder(arg1, arg2, (npy_half *)&out, &out2);
#else
    half_ctype_remainder(arg1, arg2, (npy_half *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("half_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Half);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Half, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Half);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Half, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Half);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Half, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_remainder_FLAG)

static PyObject *
float_remainder(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_float arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_float out;
#if 0
    npy_float out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_remainder, float_remainder);

    switch(_float_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_remainder(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_remainder(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    float_ctype_remainder(arg1, arg2, (npy_float *)&out, &out2);
#else
    float_ctype_remainder(arg1, arg2, (npy_float *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("float_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Float);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Float, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Float);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Float, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Float);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Float, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_remainder_FLAG)

static PyObject *
double_remainder(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_double arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_double out;
#if 0
    npy_double out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_remainder, double_remainder);

    switch(_double_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_remainder(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_remainder(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    double_ctype_remainder(arg1, arg2, (npy_double *)&out, &out2);
#else
    double_ctype_remainder(arg1, arg2, (npy_double *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("double_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(Double);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Double, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(Double);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, Double, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(Double);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Double, out);
#endif
    return ret;
}
#endif


#line 798

#if !defined(CODEGEN_SKIP_remainder_FLAG)

static PyObject *
longdouble_remainder(PyObject *a, PyObject *b)
{
    PyObject *ret;
    npy_longdouble arg1, arg2;
    /*
     * NOTE: In gcc >= 4.1, the compiler will reorder floating point
     *       operations and floating point error state checks. In
     *       particular, the arithmetic operations were being reordered
     *       so that the errors weren't caught.  Declaring this output
     *       variable volatile was the minimal fix for the issue.
     *       (Ticket #1671)
     */
    volatile npy_longdouble out;
#if 0
    npy_longdouble out2;
    PyObject *obj;
#endif

#if 1
    int retstatus;
    int first;
#endif

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_remainder, longdouble_remainder);

    switch(_longdouble_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* one of them can't be cast safely must be mixed-types*/
            return PyArray_Type.tp_as_number->nb_remainder(a,b);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_remainder(a,b);
        case -3:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

#if 1
    npy_clear_floatstatus_barrier((char*)&out);
#endif

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
#if 0
    longdouble_ctype_remainder(arg1, arg2, (npy_longdouble *)&out, &out2);
#else
    longdouble_ctype_remainder(arg1, arg2, (npy_longdouble *)&out);
#endif

#if 1
    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("longdouble_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }
#endif


#if 0
    ret = PyTuple_New(2);
    if (ret == NULL) {
        return NULL;
    }
    obj = PyArrayScalar_New(LongDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongDouble, out);
    PyTuple_SET_ITEM(ret, 0, obj);
    obj = PyArrayScalar_New(LongDouble);
    if (obj == NULL) {
        Py_DECREF(ret);
        return NULL;
    }
    PyArrayScalar_ASSIGN(obj, LongDouble, out2);
    PyTuple_SET_ITEM(ret, 1, obj);
#else
    ret = PyArrayScalar_New(LongDouble);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, LongDouble, out);
#endif
    return ret;
}
#endif



#undef CODEGEN_SKIP_divide_FLAG

#define _IS_ZERO(x) (x == 0)

#line 953

#if 0
static PyObject *
byte_power(PyObject *a, PyObject *b, PyObject *modulo)
{
    PyObject *ret;
    npy_byte arg1, arg2;
    int retstatus;
    int first;
    npy_byte out = {0, 0};

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_power, byte_power);

    switch(_byte_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,modulo);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,modulo);
        case -3:
        default:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    if (modulo != Py_None) {
        /* modular exponentiation is not implemented (gh-8804) */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    npy_clear_floatstatus_barrier((char*)&out);

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2.real) && _IS_ZERO(arg2.imag)) {
        out.real = 1;
        out.imag = 0;
    }
    else {
        byte_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("byte_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(Byte);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Byte, out);

    return ret;
}

#elif 1

static PyObject *
byte_power(PyObject *a, PyObject *b, PyObject *modulo)
{
    PyObject *ret;
    npy_byte arg1, arg2, out;

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_power, byte_power);

    switch(_byte_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,modulo);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,modulo);
        case -3:
        default:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    if (modulo != Py_None) {
        /* modular exponentiation is not implemented (gh-8804) */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    npy_clear_floatstatus_barrier((char*)&out);

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (arg2 < 0) {
        PyErr_SetString(PyExc_ValueError,
                "Integers to negative integer powers are not allowed.");
        return NULL;
    }
    byte_ctype_power(arg1, arg2, &out);

    ret = PyArrayScalar_New(Byte);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Byte, out);

    return ret;
}

#else

static PyObject *
byte_power(PyObject *a, PyObject *b, PyObject *modulo)
{
    PyObject *ret;
    npy_byte arg1, arg2;
    int retstatus;
    int first;

    npy_byte out = 0;

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_power, byte_power);

    switch(_byte_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,modulo);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,modulo);
        case -3:
        default:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    if (modulo != Py_None) {
        /* modular exponentiation is not implemented (gh-8804) */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    npy_clear_floatstatus_barrier((char*)&out);

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2)) {
        out = 1;
    }
    else {
        byte_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("byte_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(Byte);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Byte, out);

    return ret;
}

#endif


#line 953

#if 0
static PyObject *
ubyte_power(PyObject *a, PyObject *b, PyObject *modulo)
{
    PyObject *ret;
    npy_ubyte arg1, arg2;
    int retstatus;
    int first;
    npy_ubyte out = {0, 0};

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_power, ubyte_power);

    switch(_ubyte_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,modulo);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,modulo);
        case -3:
        default:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    if (modulo != Py_None) {
        /* modular exponentiation is not implemented (gh-8804) */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    npy_clear_floatstatus_barrier((char*)&out);

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2.real) && _IS_ZERO(arg2.imag)) {
        out.real = 1;
        out.imag = 0;
    }
    else {
        ubyte_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ubyte_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(UByte);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UByte, out);

    return ret;
}

#elif 0

static PyObject *
ubyte_power(PyObject *a, PyObject *b, PyObject *modulo)
{
    PyObject *ret;
    npy_ubyte arg1, arg2, out;

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_power, ubyte_power);

    switch(_ubyte_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,modulo);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,modulo);
        case -3:
        default:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    if (modulo != Py_None) {
        /* modular exponentiation is not implemented (gh-8804) */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    npy_clear_floatstatus_barrier((char*)&out);

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (arg2 < 0) {
        PyErr_SetString(PyExc_ValueError,
                "Integers to negative integer powers are not allowed.");
        return NULL;
    }
    ubyte_ctype_power(arg1, arg2, &out);

    ret = PyArrayScalar_New(UByte);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UByte, out);

    return ret;
}

#else

static PyObject *
ubyte_power(PyObject *a, PyObject *b, PyObject *modulo)
{
    PyObject *ret;
    npy_ubyte arg1, arg2;
    int retstatus;
    int first;

    npy_ubyte out = 0;

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_power, ubyte_power);

    switch(_ubyte_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,modulo);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,modulo);
        case -3:
        default:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    if (modulo != Py_None) {
        /* modular exponentiation is not implemented (gh-8804) */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    npy_clear_floatstatus_barrier((char*)&out);

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2)) {
        out = 1;
    }
    else {
        ubyte_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ubyte_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(UByte);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UByte, out);

    return ret;
}

#endif


#line 953

#if 0
static PyObject *
short_power(PyObject *a, PyObject *b, PyObject *modulo)
{
    PyObject *ret;
    npy_short arg1, arg2;
    int retstatus;
    int first;
    npy_short out = {0, 0};

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_power, short_power);

    switch(_short_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,modulo);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,modulo);
        case -3:
        default:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    if (modulo != Py_None) {
        /* modular exponentiation is not implemented (gh-8804) */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    npy_clear_floatstatus_barrier((char*)&out);

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2.real) && _IS_ZERO(arg2.imag)) {
        out.real = 1;
        out.imag = 0;
    }
    else {
        short_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("short_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(Short);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Short, out);

    return ret;
}

#elif 1

static PyObject *
short_power(PyObject *a, PyObject *b, PyObject *modulo)
{
    PyObject *ret;
    npy_short arg1, arg2, out;

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_power, short_power);

    switch(_short_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,modulo);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,modulo);
        case -3:
        default:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    if (modulo != Py_None) {
        /* modular exponentiation is not implemented (gh-8804) */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    npy_clear_floatstatus_barrier((char*)&out);

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (arg2 < 0) {
        PyErr_SetString(PyExc_ValueError,
                "Integers to negative integer powers are not allowed.");
        return NULL;
    }
    short_ctype_power(arg1, arg2, &out);

    ret = PyArrayScalar_New(Short);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Short, out);

    return ret;
}

#else

static PyObject *
short_power(PyObject *a, PyObject *b, PyObject *modulo)
{
    PyObject *ret;
    npy_short arg1, arg2;
    int retstatus;
    int first;

    npy_short out = 0;

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_power, short_power);

    switch(_short_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,modulo);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,modulo);
        case -3:
        default:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    if (modulo != Py_None) {
        /* modular exponentiation is not implemented (gh-8804) */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    npy_clear_floatstatus_barrier((char*)&out);

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2)) {
        out = 1;
    }
    else {
        short_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("short_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(Short);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Short, out);

    return ret;
}

#endif


#line 953

#if 0
static PyObject *
ushort_power(PyObject *a, PyObject *b, PyObject *modulo)
{
    PyObject *ret;
    npy_ushort arg1, arg2;
    int retstatus;
    int first;
    npy_ushort out = {0, 0};

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_power, ushort_power);

    switch(_ushort_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,modulo);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,modulo);
        case -3:
        default:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    if (modulo != Py_None) {
        /* modular exponentiation is not implemented (gh-8804) */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    npy_clear_floatstatus_barrier((char*)&out);

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2.real) && _IS_ZERO(arg2.imag)) {
        out.real = 1;
        out.imag = 0;
    }
    else {
        ushort_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ushort_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(UShort);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UShort, out);

    return ret;
}

#elif 0

static PyObject *
ushort_power(PyObject *a, PyObject *b, PyObject *modulo)
{
    PyObject *ret;
    npy_ushort arg1, arg2, out;

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_power, ushort_power);

    switch(_ushort_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,modulo);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,modulo);
        case -3:
        default:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    if (modulo != Py_None) {
        /* modular exponentiation is not implemented (gh-8804) */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    npy_clear_floatstatus_barrier((char*)&out);

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (arg2 < 0) {
        PyErr_SetString(PyExc_ValueError,
                "Integers to negative integer powers are not allowed.");
        return NULL;
    }
    ushort_ctype_power(arg1, arg2, &out);

    ret = PyArrayScalar_New(UShort);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UShort, out);

    return ret;
}

#else

static PyObject *
ushort_power(PyObject *a, PyObject *b, PyObject *modulo)
{
    PyObject *ret;
    npy_ushort arg1, arg2;
    int retstatus;
    int first;

    npy_ushort out = 0;

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_power, ushort_power);

    switch(_ushort_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,modulo);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,modulo);
        case -3:
        default:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    if (modulo != Py_None) {
        /* modular exponentiation is not implemented (gh-8804) */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    npy_clear_floatstatus_barrier((char*)&out);

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2)) {
        out = 1;
    }
    else {
        ushort_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ushort_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(UShort);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UShort, out);

    return ret;
}

#endif


#line 953

#if 0
static PyObject *
int_power(PyObject *a, PyObject *b, PyObject *modulo)
{
    PyObject *ret;
    npy_int arg1, arg2;
    int retstatus;
    int first;
    npy_int out = {0, 0};

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_power, int_power);

    switch(_int_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,modulo);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,modulo);
        case -3:
        default:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    if (modulo != Py_None) {
        /* modular exponentiation is not implemented (gh-8804) */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    npy_clear_floatstatus_barrier((char*)&out);

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2.real) && _IS_ZERO(arg2.imag)) {
        out.real = 1;
        out.imag = 0;
    }
    else {
        int_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("int_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(Int);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Int, out);

    return ret;
}

#elif 1

static PyObject *
int_power(PyObject *a, PyObject *b, PyObject *modulo)
{
    PyObject *ret;
    npy_int arg1, arg2, out;

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_power, int_power);

    switch(_int_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,modulo);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,modulo);
        case -3:
        default:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    if (modulo != Py_None) {
        /* modular exponentiation is not implemented (gh-8804) */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    npy_clear_floatstatus_barrier((char*)&out);

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (arg2 < 0) {
        PyErr_SetString(PyExc_ValueError,
                "Integers to negative integer powers are not allowed.");
        return NULL;
    }
    int_ctype_power(arg1, arg2, &out);

    ret = PyArrayScalar_New(Int);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Int, out);

    return ret;
}

#else

static PyObject *
int_power(PyObject *a, PyObject *b, PyObject *modulo)
{
    PyObject *ret;
    npy_int arg1, arg2;
    int retstatus;
    int first;

    npy_int out = 0;

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_power, int_power);

    switch(_int_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,modulo);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,modulo);
        case -3:
        default:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    if (modulo != Py_None) {
        /* modular exponentiation is not implemented (gh-8804) */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    npy_clear_floatstatus_barrier((char*)&out);

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2)) {
        out = 1;
    }
    else {
        int_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("int_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(Int);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Int, out);

    return ret;
}

#endif


#line 953

#if 0
static PyObject *
uint_power(PyObject *a, PyObject *b, PyObject *modulo)
{
    PyObject *ret;
    npy_uint arg1, arg2;
    int retstatus;
    int first;
    npy_uint out = {0, 0};

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_power, uint_power);

    switch(_uint_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,modulo);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,modulo);
        case -3:
        default:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    if (modulo != Py_None) {
        /* modular exponentiation is not implemented (gh-8804) */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    npy_clear_floatstatus_barrier((char*)&out);

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2.real) && _IS_ZERO(arg2.imag)) {
        out.real = 1;
        out.imag = 0;
    }
    else {
        uint_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("uint_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(UInt);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UInt, out);

    return ret;
}

#elif 0

static PyObject *
uint_power(PyObject *a, PyObject *b, PyObject *modulo)
{
    PyObject *ret;
    npy_uint arg1, arg2, out;

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_power, uint_power);

    switch(_uint_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,modulo);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,modulo);
        case -3:
        default:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    if (modulo != Py_None) {
        /* modular exponentiation is not implemented (gh-8804) */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    npy_clear_floatstatus_barrier((char*)&out);

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (arg2 < 0) {
        PyErr_SetString(PyExc_ValueError,
                "Integers to negative integer powers are not allowed.");
        return NULL;
    }
    uint_ctype_power(arg1, arg2, &out);

    ret = PyArrayScalar_New(UInt);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UInt, out);

    return ret;
}

#else

static PyObject *
uint_power(PyObject *a, PyObject *b, PyObject *modulo)
{
    PyObject *ret;
    npy_uint arg1, arg2;
    int retstatus;
    int first;

    npy_uint out = 0;

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_power, uint_power);

    switch(_uint_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,modulo);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,modulo);
        case -3:
        default:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    if (modulo != Py_None) {
        /* modular exponentiation is not implemented (gh-8804) */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    npy_clear_floatstatus_barrier((char*)&out);

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2)) {
        out = 1;
    }
    else {
        uint_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("uint_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(UInt);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, UInt, out);

    return ret;
}

#endif


#line 953

#if 0
static PyObject *
long_power(PyObject *a, PyObject *b, PyObject *modulo)
{
    PyObject *ret;
    npy_long arg1, arg2;
    int retstatus;
    int first;
    npy_long out = {0, 0};

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_power, long_power);

    switch(_long_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,modulo);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,modulo);
        case -3:
        default:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    if (modulo != Py_None) {
        /* modular exponentiation is not implemented (gh-8804) */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    npy_clear_floatstatus_barrier((char*)&out);

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2.real) && _IS_ZERO(arg2.imag)) {
        out.real = 1;
        out.imag = 0;
    }
    else {
        long_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("long_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(Long);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Long, out);

    return ret;
}

#elif 1

static PyObject *
long_power(PyObject *a, PyObject *b, PyObject *modulo)
{
    PyObject *ret;
    npy_long arg1, arg2, out;

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_power, long_power);

    switch(_long_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,modulo);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,modulo);
        case -3:
        default:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    if (modulo != Py_None) {
        /* modular exponentiation is not implemented (gh-8804) */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    npy_clear_floatstatus_barrier((char*)&out);

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (arg2 < 0) {
        PyErr_SetString(PyExc_ValueError,
                "Integers to negative integer powers are not allowed.");
        return NULL;
    }
    long_ctype_power(arg1, arg2, &out);

    ret = PyArrayScalar_New(Long);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Long, out);

    return ret;
}

#else

static PyObject *
long_power(PyObject *a, PyObject *b, PyObject *modulo)
{
    PyObject *ret;
    npy_long arg1, arg2;
    int retstatus;
    int first;

    npy_long out = 0;

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_power, long_power);

    switch(_long_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,modulo);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,modulo);
        case -3:
        default:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    if (modulo != Py_None) {
        /* modular exponentiation is not implemented (gh-8804) */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    npy_clear_floatstatus_barrier((char*)&out);

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2)) {
        out = 1;
    }
    else {
        long_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("long_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(Long);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Long, out);

    return ret;
}

#endif


#line 953

#if 0
static PyObject *
ulong_power(PyObject *a, PyObject *b, PyObject *modulo)
{
    PyObject *ret;
    npy_ulong arg1, arg2;
    int retstatus;
    int first;
    npy_ulong out = {0, 0};

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_power, ulong_power);

    switch(_ulong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,modulo);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,modulo);
        case -3:
        default:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    if (modulo != Py_None) {
        /* modular exponentiation is not implemented (gh-8804) */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    npy_clear_floatstatus_barrier((char*)&out);

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2.real) && _IS_ZERO(arg2.imag)) {
        out.real = 1;
        out.imag = 0;
    }
    else {
        ulong_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ulong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(ULong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, ULong, out);

    return ret;
}

#elif 0

static PyObject *
ulong_power(PyObject *a, PyObject *b, PyObject *modulo)
{
    PyObject *ret;
    npy_ulong arg1, arg2, out;

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_power, ulong_power);

    switch(_ulong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,modulo);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,modulo);
        case -3:
        default:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    if (modulo != Py_None) {
        /* modular exponentiation is not implemented (gh-8804) */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    npy_clear_floatstatus_barrier((char*)&out);

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (arg2 < 0) {
        PyErr_SetString(PyExc_ValueError,
                "Integers to negative integer powers are not allowed.");
        return NULL;
    }
    ulong_ctype_power(arg1, arg2, &out);

    ret = PyArrayScalar_New(ULong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, ULong, out);

    return ret;
}

#else

static PyObject *
ulong_power(PyObject *a, PyObject *b, PyObject *modulo)
{
    PyObject *ret;
    npy_ulong arg1, arg2;
    int retstatus;
    int first;

    npy_ulong out = 0;

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_power, ulong_power);

    switch(_ulong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,modulo);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,modulo);
        case -3:
        default:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    if (modulo != Py_None) {
        /* modular exponentiation is not implemented (gh-8804) */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    npy_clear_floatstatus_barrier((char*)&out);

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2)) {
        out = 1;
    }
    else {
        ulong_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ulong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(ULong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, ULong, out);

    return ret;
}

#endif


#line 953

#if 0
static PyObject *
longlong_power(PyObject *a, PyObject *b, PyObject *modulo)
{
    PyObject *ret;
    npy_longlong arg1, arg2;
    int retstatus;
    int first;
    npy_longlong out = {0, 0};

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_power, longlong_power);

    switch(_longlong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,modulo);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,modulo);
        case -3:
        default:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    if (modulo != Py_None) {
        /* modular exponentiation is not implemented (gh-8804) */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    npy_clear_floatstatus_barrier((char*)&out);

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2.real) && _IS_ZERO(arg2.imag)) {
        out.real = 1;
        out.imag = 0;
    }
    else {
        longlong_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("longlong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(LongLong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, LongLong, out);

    return ret;
}

#elif 1

static PyObject *
longlong_power(PyObject *a, PyObject *b, PyObject *modulo)
{
    PyObject *ret;
    npy_longlong arg1, arg2, out;

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_power, longlong_power);

    switch(_longlong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,modulo);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,modulo);
        case -3:
        default:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    if (modulo != Py_None) {
        /* modular exponentiation is not implemented (gh-8804) */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    npy_clear_floatstatus_barrier((char*)&out);

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (arg2 < 0) {
        PyErr_SetString(PyExc_ValueError,
                "Integers to negative integer powers are not allowed.");
        return NULL;
    }
    longlong_ctype_power(arg1, arg2, &out);

    ret = PyArrayScalar_New(LongLong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, LongLong, out);

    return ret;
}

#else

static PyObject *
longlong_power(PyObject *a, PyObject *b, PyObject *modulo)
{
    PyObject *ret;
    npy_longlong arg1, arg2;
    int retstatus;
    int first;

    npy_longlong out = 0;

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_power, longlong_power);

    switch(_longlong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,modulo);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,modulo);
        case -3:
        default:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    if (modulo != Py_None) {
        /* modular exponentiation is not implemented (gh-8804) */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    npy_clear_floatstatus_barrier((char*)&out);

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2)) {
        out = 1;
    }
    else {
        longlong_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("longlong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(LongLong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, LongLong, out);

    return ret;
}

#endif


#line 953

#if 0
static PyObject *
ulonglong_power(PyObject *a, PyObject *b, PyObject *modulo)
{
    PyObject *ret;
    npy_ulonglong arg1, arg2;
    int retstatus;
    int first;
    npy_ulonglong out = {0, 0};

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_power, ulonglong_power);

    switch(_ulonglong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,modulo);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,modulo);
        case -3:
        default:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    if (modulo != Py_None) {
        /* modular exponentiation is not implemented (gh-8804) */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    npy_clear_floatstatus_barrier((char*)&out);

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2.real) && _IS_ZERO(arg2.imag)) {
        out.real = 1;
        out.imag = 0;
    }
    else {
        ulonglong_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ulonglong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(ULongLong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, ULongLong, out);

    return ret;
}

#elif 0

static PyObject *
ulonglong_power(PyObject *a, PyObject *b, PyObject *modulo)
{
    PyObject *ret;
    npy_ulonglong arg1, arg2, out;

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_power, ulonglong_power);

    switch(_ulonglong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,modulo);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,modulo);
        case -3:
        default:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    if (modulo != Py_None) {
        /* modular exponentiation is not implemented (gh-8804) */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    npy_clear_floatstatus_barrier((char*)&out);

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (arg2 < 0) {
        PyErr_SetString(PyExc_ValueError,
                "Integers to negative integer powers are not allowed.");
        return NULL;
    }
    ulonglong_ctype_power(arg1, arg2, &out);

    ret = PyArrayScalar_New(ULongLong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, ULongLong, out);

    return ret;
}

#else

static PyObject *
ulonglong_power(PyObject *a, PyObject *b, PyObject *modulo)
{
    PyObject *ret;
    npy_ulonglong arg1, arg2;
    int retstatus;
    int first;

    npy_ulonglong out = 0;

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_power, ulonglong_power);

    switch(_ulonglong_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,modulo);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,modulo);
        case -3:
        default:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    if (modulo != Py_None) {
        /* modular exponentiation is not implemented (gh-8804) */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    npy_clear_floatstatus_barrier((char*)&out);

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2)) {
        out = 1;
    }
    else {
        ulonglong_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("ulonglong_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(ULongLong);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, ULongLong, out);

    return ret;
}

#endif


#line 953

#if 0
static PyObject *
half_power(PyObject *a, PyObject *b, PyObject *modulo)
{
    PyObject *ret;
    npy_half arg1, arg2;
    int retstatus;
    int first;
    npy_half out = {NPY_HALF_ZERO, NPY_HALF_ZERO};

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_power, half_power);

    switch(_half_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,modulo);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,modulo);
        case -3:
        default:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    if (modulo != Py_None) {
        /* modular exponentiation is not implemented (gh-8804) */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    npy_clear_floatstatus_barrier((char*)&out);

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (npy_half_iszero(arg2.real) && npy_half_iszero(arg2.imag)) {
        out.real = NPY_HALF_ONE;
        out.imag = NPY_HALF_ZERO;
    }
    else {
        half_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("half_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(Half);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Half, out);

    return ret;
}

#elif 0

static PyObject *
half_power(PyObject *a, PyObject *b, PyObject *modulo)
{
    PyObject *ret;
    npy_half arg1, arg2, out;

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_power, half_power);

    switch(_half_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,modulo);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,modulo);
        case -3:
        default:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    if (modulo != Py_None) {
        /* modular exponentiation is not implemented (gh-8804) */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    npy_clear_floatstatus_barrier((char*)&out);

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (arg2 < 0) {
        PyErr_SetString(PyExc_ValueError,
                "Integers to negative integer powers are not allowed.");
        return NULL;
    }
    half_ctype_power(arg1, arg2, &out);

    ret = PyArrayScalar_New(Half);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Half, out);

    return ret;
}

#else

static PyObject *
half_power(PyObject *a, PyObject *b, PyObject *modulo)
{
    PyObject *ret;
    npy_half arg1, arg2;
    int retstatus;
    int first;

    npy_half out = NPY_HALF_ZERO;

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_power, half_power);

    switch(_half_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,modulo);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,modulo);
        case -3:
        default:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    if (modulo != Py_None) {
        /* modular exponentiation is not implemented (gh-8804) */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    npy_clear_floatstatus_barrier((char*)&out);

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (npy_half_iszero(arg2)) {
        out = NPY_HALF_ONE;
    }
    else {
        half_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("half_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(Half);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Half, out);

    return ret;
}

#endif


#line 953

#if 0
static PyObject *
float_power(PyObject *a, PyObject *b, PyObject *modulo)
{
    PyObject *ret;
    npy_float arg1, arg2;
    int retstatus;
    int first;
    npy_float out = {0, 0};

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_power, float_power);

    switch(_float_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,modulo);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,modulo);
        case -3:
        default:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    if (modulo != Py_None) {
        /* modular exponentiation is not implemented (gh-8804) */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    npy_clear_floatstatus_barrier((char*)&out);

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2.real) && _IS_ZERO(arg2.imag)) {
        out.real = 1;
        out.imag = 0;
    }
    else {
        float_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("float_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(Float);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Float, out);

    return ret;
}

#elif 0

static PyObject *
float_power(PyObject *a, PyObject *b, PyObject *modulo)
{
    PyObject *ret;
    npy_float arg1, arg2, out;

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_power, float_power);

    switch(_float_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,modulo);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,modulo);
        case -3:
        default:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    if (modulo != Py_None) {
        /* modular exponentiation is not implemented (gh-8804) */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    npy_clear_floatstatus_barrier((char*)&out);

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (arg2 < 0) {
        PyErr_SetString(PyExc_ValueError,
                "Integers to negative integer powers are not allowed.");
        return NULL;
    }
    float_ctype_power(arg1, arg2, &out);

    ret = PyArrayScalar_New(Float);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Float, out);

    return ret;
}

#else

static PyObject *
float_power(PyObject *a, PyObject *b, PyObject *modulo)
{
    PyObject *ret;
    npy_float arg1, arg2;
    int retstatus;
    int first;

    npy_float out = 0;

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_power, float_power);

    switch(_float_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,modulo);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,modulo);
        case -3:
        default:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    if (modulo != Py_None) {
        /* modular exponentiation is not implemented (gh-8804) */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    npy_clear_floatstatus_barrier((char*)&out);

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2)) {
        out = 1;
    }
    else {
        float_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("float_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(Float);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Float, out);

    return ret;
}

#endif


#line 953

#if 0
static PyObject *
double_power(PyObject *a, PyObject *b, PyObject *modulo)
{
    PyObject *ret;
    npy_double arg1, arg2;
    int retstatus;
    int first;
    npy_double out = {0, 0};

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_power, double_power);

    switch(_double_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,modulo);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,modulo);
        case -3:
        default:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    if (modulo != Py_None) {
        /* modular exponentiation is not implemented (gh-8804) */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    npy_clear_floatstatus_barrier((char*)&out);

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2.real) && _IS_ZERO(arg2.imag)) {
        out.real = 1;
        out.imag = 0;
    }
    else {
        double_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("double_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(Double);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Double, out);

    return ret;
}

#elif 0

static PyObject *
double_power(PyObject *a, PyObject *b, PyObject *modulo)
{
    PyObject *ret;
    npy_double arg1, arg2, out;

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_power, double_power);

    switch(_double_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,modulo);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,modulo);
        case -3:
        default:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    if (modulo != Py_None) {
        /* modular exponentiation is not implemented (gh-8804) */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    npy_clear_floatstatus_barrier((char*)&out);

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (arg2 < 0) {
        PyErr_SetString(PyExc_ValueError,
                "Integers to negative integer powers are not allowed.");
        return NULL;
    }
    double_ctype_power(arg1, arg2, &out);

    ret = PyArrayScalar_New(Double);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Double, out);

    return ret;
}

#else

static PyObject *
double_power(PyObject *a, PyObject *b, PyObject *modulo)
{
    PyObject *ret;
    npy_double arg1, arg2;
    int retstatus;
    int first;

    npy_double out = 0;

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_power, double_power);

    switch(_double_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,modulo);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,modulo);
        case -3:
        default:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    if (modulo != Py_None) {
        /* modular exponentiation is not implemented (gh-8804) */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    npy_clear_floatstatus_barrier((char*)&out);

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2)) {
        out = 1;
    }
    else {
        double_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("double_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(Double);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, Double, out);

    return ret;
}

#endif


#line 953

#if 0
static PyObject *
longdouble_power(PyObject *a, PyObject *b, PyObject *modulo)
{
    PyObject *ret;
    npy_longdouble arg1, arg2;
    int retstatus;
    int first;
    npy_longdouble out = {0, 0};

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_power, longdouble_power);

    switch(_longdouble_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,modulo);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,modulo);
        case -3:
        default:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    if (modulo != Py_None) {
        /* modular exponentiation is not implemented (gh-8804) */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    npy_clear_floatstatus_barrier((char*)&out);

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2.real) && _IS_ZERO(arg2.imag)) {
        out.real = 1;
        out.imag = 0;
    }
    else {
        longdouble_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("longdouble_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(LongDouble);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, LongDouble, out);

    return ret;
}

#elif 0

static PyObject *
longdouble_power(PyObject *a, PyObject *b, PyObject *modulo)
{
    PyObject *ret;
    npy_longdouble arg1, arg2, out;

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_power, longdouble_power);

    switch(_longdouble_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,modulo);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,modulo);
        case -3:
        default:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    if (modulo != Py_None) {
        /* modular exponentiation is not implemented (gh-8804) */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    npy_clear_floatstatus_barrier((char*)&out);

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (arg2 < 0) {
        PyErr_SetString(PyExc_ValueError,
                "Integers to negative integer powers are not allowed.");
        return NULL;
    }
    longdouble_ctype_power(arg1, arg2, &out);

    ret = PyArrayScalar_New(LongDouble);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, LongDouble, out);

    return ret;
}

#else

static PyObject *
longdouble_power(PyObject *a, PyObject *b, PyObject *modulo)
{
    PyObject *ret;
    npy_longdouble arg1, arg2;
    int retstatus;
    int first;

    npy_longdouble out = 0;

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_power, longdouble_power);

    switch(_longdouble_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,modulo);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,modulo);
        case -3:
        default:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    if (modulo != Py_None) {
        /* modular exponentiation is not implemented (gh-8804) */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    npy_clear_floatstatus_barrier((char*)&out);

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2)) {
        out = 1;
    }
    else {
        longdouble_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("longdouble_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(LongDouble);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, LongDouble, out);

    return ret;
}

#endif


#line 953

#if 1
static PyObject *
cfloat_power(PyObject *a, PyObject *b, PyObject *modulo)
{
    PyObject *ret;
    npy_cfloat arg1, arg2;
    int retstatus;
    int first;
    npy_cfloat out = {0, 0};

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_power, cfloat_power);

    switch(_cfloat_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,modulo);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,modulo);
        case -3:
        default:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    if (modulo != Py_None) {
        /* modular exponentiation is not implemented (gh-8804) */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    npy_clear_floatstatus_barrier((char*)&out);

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2.real) && _IS_ZERO(arg2.imag)) {
        out.real = 1;
        out.imag = 0;
    }
    else {
        cfloat_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("cfloat_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(CFloat);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, CFloat, out);

    return ret;
}

#elif 0

static PyObject *
cfloat_power(PyObject *a, PyObject *b, PyObject *modulo)
{
    PyObject *ret;
    npy_cfloat arg1, arg2, out;

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_power, cfloat_power);

    switch(_cfloat_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,modulo);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,modulo);
        case -3:
        default:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    if (modulo != Py_None) {
        /* modular exponentiation is not implemented (gh-8804) */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    npy_clear_floatstatus_barrier((char*)&out);

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (arg2 < 0) {
        PyErr_SetString(PyExc_ValueError,
                "Integers to negative integer powers are not allowed.");
        return NULL;
    }
    cfloat_ctype_power(arg1, arg2, &out);

    ret = PyArrayScalar_New(CFloat);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, CFloat, out);

    return ret;
}

#else

static PyObject *
cfloat_power(PyObject *a, PyObject *b, PyObject *modulo)
{
    PyObject *ret;
    npy_cfloat arg1, arg2;
    int retstatus;
    int first;

    npy_cfloat out = 0;

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_power, cfloat_power);

    switch(_cfloat_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,modulo);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,modulo);
        case -3:
        default:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    if (modulo != Py_None) {
        /* modular exponentiation is not implemented (gh-8804) */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    npy_clear_floatstatus_barrier((char*)&out);

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2)) {
        out = 1;
    }
    else {
        cfloat_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("cfloat_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(CFloat);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, CFloat, out);

    return ret;
}

#endif


#line 953

#if 1
static PyObject *
cdouble_power(PyObject *a, PyObject *b, PyObject *modulo)
{
    PyObject *ret;
    npy_cdouble arg1, arg2;
    int retstatus;
    int first;
    npy_cdouble out = {0, 0};

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_power, cdouble_power);

    switch(_cdouble_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,modulo);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,modulo);
        case -3:
        default:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    if (modulo != Py_None) {
        /* modular exponentiation is not implemented (gh-8804) */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    npy_clear_floatstatus_barrier((char*)&out);

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2.real) && _IS_ZERO(arg2.imag)) {
        out.real = 1;
        out.imag = 0;
    }
    else {
        cdouble_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("cdouble_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(CDouble);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, CDouble, out);

    return ret;
}

#elif 0

static PyObject *
cdouble_power(PyObject *a, PyObject *b, PyObject *modulo)
{
    PyObject *ret;
    npy_cdouble arg1, arg2, out;

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_power, cdouble_power);

    switch(_cdouble_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,modulo);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,modulo);
        case -3:
        default:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    if (modulo != Py_None) {
        /* modular exponentiation is not implemented (gh-8804) */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    npy_clear_floatstatus_barrier((char*)&out);

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (arg2 < 0) {
        PyErr_SetString(PyExc_ValueError,
                "Integers to negative integer powers are not allowed.");
        return NULL;
    }
    cdouble_ctype_power(arg1, arg2, &out);

    ret = PyArrayScalar_New(CDouble);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, CDouble, out);

    return ret;
}

#else

static PyObject *
cdouble_power(PyObject *a, PyObject *b, PyObject *modulo)
{
    PyObject *ret;
    npy_cdouble arg1, arg2;
    int retstatus;
    int first;

    npy_cdouble out = 0;

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_power, cdouble_power);

    switch(_cdouble_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,modulo);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,modulo);
        case -3:
        default:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    if (modulo != Py_None) {
        /* modular exponentiation is not implemented (gh-8804) */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    npy_clear_floatstatus_barrier((char*)&out);

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2)) {
        out = 1;
    }
    else {
        cdouble_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("cdouble_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(CDouble);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, CDouble, out);

    return ret;
}

#endif


#line 953

#if 1
static PyObject *
clongdouble_power(PyObject *a, PyObject *b, PyObject *modulo)
{
    PyObject *ret;
    npy_clongdouble arg1, arg2;
    int retstatus;
    int first;
    npy_clongdouble out = {0, 0};

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_power, clongdouble_power);

    switch(_clongdouble_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,modulo);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,modulo);
        case -3:
        default:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    if (modulo != Py_None) {
        /* modular exponentiation is not implemented (gh-8804) */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    npy_clear_floatstatus_barrier((char*)&out);

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2.real) && _IS_ZERO(arg2.imag)) {
        out.real = 1;
        out.imag = 0;
    }
    else {
        clongdouble_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("clongdouble_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(CLongDouble);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, CLongDouble, out);

    return ret;
}

#elif 0

static PyObject *
clongdouble_power(PyObject *a, PyObject *b, PyObject *modulo)
{
    PyObject *ret;
    npy_clongdouble arg1, arg2, out;

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_power, clongdouble_power);

    switch(_clongdouble_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,modulo);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,modulo);
        case -3:
        default:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    if (modulo != Py_None) {
        /* modular exponentiation is not implemented (gh-8804) */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    npy_clear_floatstatus_barrier((char*)&out);

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (arg2 < 0) {
        PyErr_SetString(PyExc_ValueError,
                "Integers to negative integer powers are not allowed.");
        return NULL;
    }
    clongdouble_ctype_power(arg1, arg2, &out);

    ret = PyArrayScalar_New(CLongDouble);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, CLongDouble, out);

    return ret;
}

#else

static PyObject *
clongdouble_power(PyObject *a, PyObject *b, PyObject *modulo)
{
    PyObject *ret;
    npy_clongdouble arg1, arg2;
    int retstatus;
    int first;

    npy_clongdouble out = 0;

    BINOP_GIVE_UP_IF_NEEDED(a, b, nb_power, clongdouble_power);

    switch(_clongdouble_convert2_to_ctypes(a, &arg1, b, &arg2)) {
        case 0:
            break;
        case -1:
            /* can't cast both safely mixed-types? */
            return PyArray_Type.tp_as_number->nb_power(a,b,modulo);
        case -2:
            /* use default handling */
            if (PyErr_Occurred()) {
                return NULL;
            }
            return PyGenericArrType_Type.tp_as_number->nb_power(a,b,modulo);
        case -3:
        default:
            /*
             * special case for longdouble and clongdouble
             * because they have a recursive getitem in their dtype
             */
            Py_INCREF(Py_NotImplemented);
            return Py_NotImplemented;
    }

    if (modulo != Py_None) {
        /* modular exponentiation is not implemented (gh-8804) */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    npy_clear_floatstatus_barrier((char*)&out);

    /*
     * here we do the actual calculation with arg1 and arg2
     * as a function call.
     */
    if (_IS_ZERO(arg2)) {
        out = 1;
    }
    else {
        clongdouble_ctype_power(arg1, arg2, &out);
    }

    /* Check status flag.  If it is set, then look up what to do */
    retstatus = npy_get_floatstatus_barrier((char*)&out);
    if (retstatus) {
        int bufsize, errmask;
        PyObject *errobj;

        if (PyUFunc_GetPyValues("clongdouble_scalars", &bufsize, &errmask,
                                &errobj) < 0) {
            return NULL;
        }
        first = 1;
        if (PyUFunc_handlefperr(errmask, errobj, retstatus, &first)) {
            Py_XDECREF(errobj);
            return NULL;
        }
        Py_XDECREF(errobj);
    }

    ret = PyArrayScalar_New(CLongDouble);
    if (ret == NULL) {
        return NULL;
    }
    PyArrayScalar_ASSIGN(ret, CLongDouble, out);

    return ret;
}

#endif


#undef _IS_ZERO


#line 1188

#line 1194

#define cfloat_divmod NULL


#line 1194

#define cfloat_remainder NULL




#line 1188

#line 1194

#define cdouble_divmod NULL


#line 1194

#define cdouble_remainder NULL




#line 1188

#line 1194

#define clongdouble_divmod NULL


#line 1194

#define clongdouble_remainder NULL





#line 1206

#line 1212

#define half_lshift NULL


#line 1212

#define half_rshift NULL


#line 1212

#define half_and NULL


#line 1212

#define half_or NULL


#line 1212

#define half_xor NULL




#line 1206

#line 1212

#define float_lshift NULL


#line 1212

#define float_rshift NULL


#line 1212

#define float_and NULL


#line 1212

#define float_or NULL


#line 1212

#define float_xor NULL




#line 1206

#line 1212

#define double_lshift NULL


#line 1212

#define double_rshift NULL


#line 1212

#define double_and NULL


#line 1212

#define double_or NULL


#line 1212

#define double_xor NULL




#line 1206

#line 1212

#define longdouble_lshift NULL


#line 1212

#define longdouble_rshift NULL


#line 1212

#define longdouble_and NULL


#line 1212

#define longdouble_or NULL


#line 1212

#define longdouble_xor NULL




#line 1206

#line 1212

#define cfloat_lshift NULL


#line 1212

#define cfloat_rshift NULL


#line 1212

#define cfloat_and NULL


#line 1212

#define cfloat_or NULL


#line 1212

#define cfloat_xor NULL




#line 1206

#line 1212

#define cdouble_lshift NULL


#line 1212

#define cdouble_rshift NULL


#line 1212

#define cdouble_and NULL


#line 1212

#define cdouble_or NULL


#line 1212

#define cdouble_xor NULL




#line 1206

#line 1212

#define clongdouble_lshift NULL


#line 1212

#define clongdouble_rshift NULL


#line 1212

#define clongdouble_and NULL


#line 1212

#define clongdouble_or NULL


#line 1212

#define clongdouble_xor NULL





#line 1262
static PyObject *
byte_negative(PyObject *a)
{
    npy_byte arg1;
    npy_byte out;
    PyObject *ret;

    switch(_byte_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_negative(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    byte_ctype_negative(arg1, &out);

    ret = PyArrayScalar_New(Byte);
    PyArrayScalar_ASSIGN(ret, Byte, out);

    return ret;
}

#line 1262
static PyObject *
ubyte_negative(PyObject *a)
{
    npy_ubyte arg1;
    npy_ubyte out;
    PyObject *ret;

    switch(_ubyte_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_negative(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    ubyte_ctype_negative(arg1, &out);

    ret = PyArrayScalar_New(UByte);
    PyArrayScalar_ASSIGN(ret, UByte, out);

    return ret;
}

#line 1262
static PyObject *
short_negative(PyObject *a)
{
    npy_short arg1;
    npy_short out;
    PyObject *ret;

    switch(_short_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_negative(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    short_ctype_negative(arg1, &out);

    ret = PyArrayScalar_New(Short);
    PyArrayScalar_ASSIGN(ret, Short, out);

    return ret;
}

#line 1262
static PyObject *
ushort_negative(PyObject *a)
{
    npy_ushort arg1;
    npy_ushort out;
    PyObject *ret;

    switch(_ushort_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_negative(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    ushort_ctype_negative(arg1, &out);

    ret = PyArrayScalar_New(UShort);
    PyArrayScalar_ASSIGN(ret, UShort, out);

    return ret;
}

#line 1262
static PyObject *
int_negative(PyObject *a)
{
    npy_int arg1;
    npy_int out;
    PyObject *ret;

    switch(_int_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_negative(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    int_ctype_negative(arg1, &out);

    ret = PyArrayScalar_New(Int);
    PyArrayScalar_ASSIGN(ret, Int, out);

    return ret;
}

#line 1262
static PyObject *
uint_negative(PyObject *a)
{
    npy_uint arg1;
    npy_uint out;
    PyObject *ret;

    switch(_uint_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_negative(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    uint_ctype_negative(arg1, &out);

    ret = PyArrayScalar_New(UInt);
    PyArrayScalar_ASSIGN(ret, UInt, out);

    return ret;
}

#line 1262
static PyObject *
long_negative(PyObject *a)
{
    npy_long arg1;
    npy_long out;
    PyObject *ret;

    switch(_long_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_negative(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    long_ctype_negative(arg1, &out);

    ret = PyArrayScalar_New(Long);
    PyArrayScalar_ASSIGN(ret, Long, out);

    return ret;
}

#line 1262
static PyObject *
ulong_negative(PyObject *a)
{
    npy_ulong arg1;
    npy_ulong out;
    PyObject *ret;

    switch(_ulong_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_negative(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    ulong_ctype_negative(arg1, &out);

    ret = PyArrayScalar_New(ULong);
    PyArrayScalar_ASSIGN(ret, ULong, out);

    return ret;
}

#line 1262
static PyObject *
longlong_negative(PyObject *a)
{
    npy_longlong arg1;
    npy_longlong out;
    PyObject *ret;

    switch(_longlong_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_negative(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    longlong_ctype_negative(arg1, &out);

    ret = PyArrayScalar_New(LongLong);
    PyArrayScalar_ASSIGN(ret, LongLong, out);

    return ret;
}

#line 1262
static PyObject *
ulonglong_negative(PyObject *a)
{
    npy_ulonglong arg1;
    npy_ulonglong out;
    PyObject *ret;

    switch(_ulonglong_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_negative(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    ulonglong_ctype_negative(arg1, &out);

    ret = PyArrayScalar_New(ULongLong);
    PyArrayScalar_ASSIGN(ret, ULongLong, out);

    return ret;
}

#line 1262
static PyObject *
half_negative(PyObject *a)
{
    npy_half arg1;
    npy_half out;
    PyObject *ret;

    switch(_half_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_negative(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    half_ctype_negative(arg1, &out);

    ret = PyArrayScalar_New(Half);
    PyArrayScalar_ASSIGN(ret, Half, out);

    return ret;
}

#line 1262
static PyObject *
float_negative(PyObject *a)
{
    npy_float arg1;
    npy_float out;
    PyObject *ret;

    switch(_float_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_negative(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    float_ctype_negative(arg1, &out);

    ret = PyArrayScalar_New(Float);
    PyArrayScalar_ASSIGN(ret, Float, out);

    return ret;
}

#line 1262
static PyObject *
double_negative(PyObject *a)
{
    npy_double arg1;
    npy_double out;
    PyObject *ret;

    switch(_double_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_negative(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    double_ctype_negative(arg1, &out);

    ret = PyArrayScalar_New(Double);
    PyArrayScalar_ASSIGN(ret, Double, out);

    return ret;
}

#line 1262
static PyObject *
longdouble_negative(PyObject *a)
{
    npy_longdouble arg1;
    npy_longdouble out;
    PyObject *ret;

    switch(_longdouble_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_negative(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    longdouble_ctype_negative(arg1, &out);

    ret = PyArrayScalar_New(LongDouble);
    PyArrayScalar_ASSIGN(ret, LongDouble, out);

    return ret;
}

#line 1262
static PyObject *
cfloat_negative(PyObject *a)
{
    npy_cfloat arg1;
    npy_cfloat out;
    PyObject *ret;

    switch(_cfloat_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_negative(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    cfloat_ctype_negative(arg1, &out);

    ret = PyArrayScalar_New(CFloat);
    PyArrayScalar_ASSIGN(ret, CFloat, out);

    return ret;
}

#line 1262
static PyObject *
cdouble_negative(PyObject *a)
{
    npy_cdouble arg1;
    npy_cdouble out;
    PyObject *ret;

    switch(_cdouble_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_negative(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    cdouble_ctype_negative(arg1, &out);

    ret = PyArrayScalar_New(CDouble);
    PyArrayScalar_ASSIGN(ret, CDouble, out);

    return ret;
}

#line 1262
static PyObject *
clongdouble_negative(PyObject *a)
{
    npy_clongdouble arg1;
    npy_clongdouble out;
    PyObject *ret;

    switch(_clongdouble_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_negative(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    clongdouble_ctype_negative(arg1, &out);

    ret = PyArrayScalar_New(CLongDouble);
    PyArrayScalar_ASSIGN(ret, CLongDouble, out);

    return ret;
}

#line 1262
static PyObject *
byte_positive(PyObject *a)
{
    npy_byte arg1;
    npy_byte out;
    PyObject *ret;

    switch(_byte_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_positive(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    byte_ctype_positive(arg1, &out);

    ret = PyArrayScalar_New(Byte);
    PyArrayScalar_ASSIGN(ret, Byte, out);

    return ret;
}

#line 1262
static PyObject *
ubyte_positive(PyObject *a)
{
    npy_ubyte arg1;
    npy_ubyte out;
    PyObject *ret;

    switch(_ubyte_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_positive(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    ubyte_ctype_positive(arg1, &out);

    ret = PyArrayScalar_New(UByte);
    PyArrayScalar_ASSIGN(ret, UByte, out);

    return ret;
}

#line 1262
static PyObject *
short_positive(PyObject *a)
{
    npy_short arg1;
    npy_short out;
    PyObject *ret;

    switch(_short_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_positive(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    short_ctype_positive(arg1, &out);

    ret = PyArrayScalar_New(Short);
    PyArrayScalar_ASSIGN(ret, Short, out);

    return ret;
}

#line 1262
static PyObject *
ushort_positive(PyObject *a)
{
    npy_ushort arg1;
    npy_ushort out;
    PyObject *ret;

    switch(_ushort_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_positive(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    ushort_ctype_positive(arg1, &out);

    ret = PyArrayScalar_New(UShort);
    PyArrayScalar_ASSIGN(ret, UShort, out);

    return ret;
}

#line 1262
static PyObject *
int_positive(PyObject *a)
{
    npy_int arg1;
    npy_int out;
    PyObject *ret;

    switch(_int_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_positive(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    int_ctype_positive(arg1, &out);

    ret = PyArrayScalar_New(Int);
    PyArrayScalar_ASSIGN(ret, Int, out);

    return ret;
}

#line 1262
static PyObject *
uint_positive(PyObject *a)
{
    npy_uint arg1;
    npy_uint out;
    PyObject *ret;

    switch(_uint_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_positive(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    uint_ctype_positive(arg1, &out);

    ret = PyArrayScalar_New(UInt);
    PyArrayScalar_ASSIGN(ret, UInt, out);

    return ret;
}

#line 1262
static PyObject *
long_positive(PyObject *a)
{
    npy_long arg1;
    npy_long out;
    PyObject *ret;

    switch(_long_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_positive(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    long_ctype_positive(arg1, &out);

    ret = PyArrayScalar_New(Long);
    PyArrayScalar_ASSIGN(ret, Long, out);

    return ret;
}

#line 1262
static PyObject *
ulong_positive(PyObject *a)
{
    npy_ulong arg1;
    npy_ulong out;
    PyObject *ret;

    switch(_ulong_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_positive(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    ulong_ctype_positive(arg1, &out);

    ret = PyArrayScalar_New(ULong);
    PyArrayScalar_ASSIGN(ret, ULong, out);

    return ret;
}

#line 1262
static PyObject *
longlong_positive(PyObject *a)
{
    npy_longlong arg1;
    npy_longlong out;
    PyObject *ret;

    switch(_longlong_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_positive(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    longlong_ctype_positive(arg1, &out);

    ret = PyArrayScalar_New(LongLong);
    PyArrayScalar_ASSIGN(ret, LongLong, out);

    return ret;
}

#line 1262
static PyObject *
ulonglong_positive(PyObject *a)
{
    npy_ulonglong arg1;
    npy_ulonglong out;
    PyObject *ret;

    switch(_ulonglong_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_positive(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    ulonglong_ctype_positive(arg1, &out);

    ret = PyArrayScalar_New(ULongLong);
    PyArrayScalar_ASSIGN(ret, ULongLong, out);

    return ret;
}

#line 1262
static PyObject *
half_positive(PyObject *a)
{
    npy_half arg1;
    npy_half out;
    PyObject *ret;

    switch(_half_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_positive(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    half_ctype_positive(arg1, &out);

    ret = PyArrayScalar_New(Half);
    PyArrayScalar_ASSIGN(ret, Half, out);

    return ret;
}

#line 1262
static PyObject *
float_positive(PyObject *a)
{
    npy_float arg1;
    npy_float out;
    PyObject *ret;

    switch(_float_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_positive(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    float_ctype_positive(arg1, &out);

    ret = PyArrayScalar_New(Float);
    PyArrayScalar_ASSIGN(ret, Float, out);

    return ret;
}

#line 1262
static PyObject *
double_positive(PyObject *a)
{
    npy_double arg1;
    npy_double out;
    PyObject *ret;

    switch(_double_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_positive(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    double_ctype_positive(arg1, &out);

    ret = PyArrayScalar_New(Double);
    PyArrayScalar_ASSIGN(ret, Double, out);

    return ret;
}

#line 1262
static PyObject *
longdouble_positive(PyObject *a)
{
    npy_longdouble arg1;
    npy_longdouble out;
    PyObject *ret;

    switch(_longdouble_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_positive(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    longdouble_ctype_positive(arg1, &out);

    ret = PyArrayScalar_New(LongDouble);
    PyArrayScalar_ASSIGN(ret, LongDouble, out);

    return ret;
}

#line 1262
static PyObject *
cfloat_positive(PyObject *a)
{
    npy_cfloat arg1;
    npy_cfloat out;
    PyObject *ret;

    switch(_cfloat_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_positive(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    cfloat_ctype_positive(arg1, &out);

    ret = PyArrayScalar_New(CFloat);
    PyArrayScalar_ASSIGN(ret, CFloat, out);

    return ret;
}

#line 1262
static PyObject *
cdouble_positive(PyObject *a)
{
    npy_cdouble arg1;
    npy_cdouble out;
    PyObject *ret;

    switch(_cdouble_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_positive(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    cdouble_ctype_positive(arg1, &out);

    ret = PyArrayScalar_New(CDouble);
    PyArrayScalar_ASSIGN(ret, CDouble, out);

    return ret;
}

#line 1262
static PyObject *
clongdouble_positive(PyObject *a)
{
    npy_clongdouble arg1;
    npy_clongdouble out;
    PyObject *ret;

    switch(_clongdouble_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_positive(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    clongdouble_ctype_positive(arg1, &out);

    ret = PyArrayScalar_New(CLongDouble);
    PyArrayScalar_ASSIGN(ret, CLongDouble, out);

    return ret;
}

#line 1262
static PyObject *
byte_absolute(PyObject *a)
{
    npy_byte arg1;
    npy_byte out;
    PyObject *ret;

    switch(_byte_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_absolute(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    byte_ctype_absolute(arg1, &out);

    ret = PyArrayScalar_New(Byte);
    PyArrayScalar_ASSIGN(ret, Byte, out);

    return ret;
}

#line 1262
static PyObject *
ubyte_absolute(PyObject *a)
{
    npy_ubyte arg1;
    npy_ubyte out;
    PyObject *ret;

    switch(_ubyte_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_absolute(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    ubyte_ctype_absolute(arg1, &out);

    ret = PyArrayScalar_New(UByte);
    PyArrayScalar_ASSIGN(ret, UByte, out);

    return ret;
}

#line 1262
static PyObject *
short_absolute(PyObject *a)
{
    npy_short arg1;
    npy_short out;
    PyObject *ret;

    switch(_short_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_absolute(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    short_ctype_absolute(arg1, &out);

    ret = PyArrayScalar_New(Short);
    PyArrayScalar_ASSIGN(ret, Short, out);

    return ret;
}

#line 1262
static PyObject *
ushort_absolute(PyObject *a)
{
    npy_ushort arg1;
    npy_ushort out;
    PyObject *ret;

    switch(_ushort_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_absolute(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    ushort_ctype_absolute(arg1, &out);

    ret = PyArrayScalar_New(UShort);
    PyArrayScalar_ASSIGN(ret, UShort, out);

    return ret;
}

#line 1262
static PyObject *
int_absolute(PyObject *a)
{
    npy_int arg1;
    npy_int out;
    PyObject *ret;

    switch(_int_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_absolute(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    int_ctype_absolute(arg1, &out);

    ret = PyArrayScalar_New(Int);
    PyArrayScalar_ASSIGN(ret, Int, out);

    return ret;
}

#line 1262
static PyObject *
uint_absolute(PyObject *a)
{
    npy_uint arg1;
    npy_uint out;
    PyObject *ret;

    switch(_uint_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_absolute(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    uint_ctype_absolute(arg1, &out);

    ret = PyArrayScalar_New(UInt);
    PyArrayScalar_ASSIGN(ret, UInt, out);

    return ret;
}

#line 1262
static PyObject *
long_absolute(PyObject *a)
{
    npy_long arg1;
    npy_long out;
    PyObject *ret;

    switch(_long_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_absolute(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    long_ctype_absolute(arg1, &out);

    ret = PyArrayScalar_New(Long);
    PyArrayScalar_ASSIGN(ret, Long, out);

    return ret;
}

#line 1262
static PyObject *
ulong_absolute(PyObject *a)
{
    npy_ulong arg1;
    npy_ulong out;
    PyObject *ret;

    switch(_ulong_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_absolute(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    ulong_ctype_absolute(arg1, &out);

    ret = PyArrayScalar_New(ULong);
    PyArrayScalar_ASSIGN(ret, ULong, out);

    return ret;
}

#line 1262
static PyObject *
longlong_absolute(PyObject *a)
{
    npy_longlong arg1;
    npy_longlong out;
    PyObject *ret;

    switch(_longlong_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_absolute(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    longlong_ctype_absolute(arg1, &out);

    ret = PyArrayScalar_New(LongLong);
    PyArrayScalar_ASSIGN(ret, LongLong, out);

    return ret;
}

#line 1262
static PyObject *
ulonglong_absolute(PyObject *a)
{
    npy_ulonglong arg1;
    npy_ulonglong out;
    PyObject *ret;

    switch(_ulonglong_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_absolute(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    ulonglong_ctype_absolute(arg1, &out);

    ret = PyArrayScalar_New(ULongLong);
    PyArrayScalar_ASSIGN(ret, ULongLong, out);

    return ret;
}

#line 1262
static PyObject *
half_absolute(PyObject *a)
{
    npy_half arg1;
    npy_half out;
    PyObject *ret;

    switch(_half_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_absolute(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    half_ctype_absolute(arg1, &out);

    ret = PyArrayScalar_New(Half);
    PyArrayScalar_ASSIGN(ret, Half, out);

    return ret;
}

#line 1262
static PyObject *
float_absolute(PyObject *a)
{
    npy_float arg1;
    npy_float out;
    PyObject *ret;

    switch(_float_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_absolute(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    float_ctype_absolute(arg1, &out);

    ret = PyArrayScalar_New(Float);
    PyArrayScalar_ASSIGN(ret, Float, out);

    return ret;
}

#line 1262
static PyObject *
double_absolute(PyObject *a)
{
    npy_double arg1;
    npy_double out;
    PyObject *ret;

    switch(_double_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_absolute(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    double_ctype_absolute(arg1, &out);

    ret = PyArrayScalar_New(Double);
    PyArrayScalar_ASSIGN(ret, Double, out);

    return ret;
}

#line 1262
static PyObject *
longdouble_absolute(PyObject *a)
{
    npy_longdouble arg1;
    npy_longdouble out;
    PyObject *ret;

    switch(_longdouble_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_absolute(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    longdouble_ctype_absolute(arg1, &out);

    ret = PyArrayScalar_New(LongDouble);
    PyArrayScalar_ASSIGN(ret, LongDouble, out);

    return ret;
}

#line 1262
static PyObject *
cfloat_absolute(PyObject *a)
{
    npy_cfloat arg1;
    npy_float out;
    PyObject *ret;

    switch(_cfloat_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_absolute(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    cfloat_ctype_absolute(arg1, &out);

    ret = PyArrayScalar_New(Float);
    PyArrayScalar_ASSIGN(ret, Float, out);

    return ret;
}

#line 1262
static PyObject *
cdouble_absolute(PyObject *a)
{
    npy_cdouble arg1;
    npy_double out;
    PyObject *ret;

    switch(_cdouble_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_absolute(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    cdouble_ctype_absolute(arg1, &out);

    ret = PyArrayScalar_New(Double);
    PyArrayScalar_ASSIGN(ret, Double, out);

    return ret;
}

#line 1262
static PyObject *
clongdouble_absolute(PyObject *a)
{
    npy_clongdouble arg1;
    npy_longdouble out;
    PyObject *ret;

    switch(_clongdouble_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_absolute(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    clongdouble_ctype_absolute(arg1, &out);

    ret = PyArrayScalar_New(LongDouble);
    PyArrayScalar_ASSIGN(ret, LongDouble, out);

    return ret;
}

#line 1262
static PyObject *
byte_invert(PyObject *a)
{
    npy_byte arg1;
    npy_byte out;
    PyObject *ret;

    switch(_byte_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_invert(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    byte_ctype_invert(arg1, &out);

    ret = PyArrayScalar_New(Byte);
    PyArrayScalar_ASSIGN(ret, Byte, out);

    return ret;
}

#line 1262
static PyObject *
ubyte_invert(PyObject *a)
{
    npy_ubyte arg1;
    npy_ubyte out;
    PyObject *ret;

    switch(_ubyte_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_invert(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    ubyte_ctype_invert(arg1, &out);

    ret = PyArrayScalar_New(UByte);
    PyArrayScalar_ASSIGN(ret, UByte, out);

    return ret;
}

#line 1262
static PyObject *
short_invert(PyObject *a)
{
    npy_short arg1;
    npy_short out;
    PyObject *ret;

    switch(_short_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_invert(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    short_ctype_invert(arg1, &out);

    ret = PyArrayScalar_New(Short);
    PyArrayScalar_ASSIGN(ret, Short, out);

    return ret;
}

#line 1262
static PyObject *
ushort_invert(PyObject *a)
{
    npy_ushort arg1;
    npy_ushort out;
    PyObject *ret;

    switch(_ushort_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_invert(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    ushort_ctype_invert(arg1, &out);

    ret = PyArrayScalar_New(UShort);
    PyArrayScalar_ASSIGN(ret, UShort, out);

    return ret;
}

#line 1262
static PyObject *
int_invert(PyObject *a)
{
    npy_int arg1;
    npy_int out;
    PyObject *ret;

    switch(_int_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_invert(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    int_ctype_invert(arg1, &out);

    ret = PyArrayScalar_New(Int);
    PyArrayScalar_ASSIGN(ret, Int, out);

    return ret;
}

#line 1262
static PyObject *
uint_invert(PyObject *a)
{
    npy_uint arg1;
    npy_uint out;
    PyObject *ret;

    switch(_uint_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_invert(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    uint_ctype_invert(arg1, &out);

    ret = PyArrayScalar_New(UInt);
    PyArrayScalar_ASSIGN(ret, UInt, out);

    return ret;
}

#line 1262
static PyObject *
long_invert(PyObject *a)
{
    npy_long arg1;
    npy_long out;
    PyObject *ret;

    switch(_long_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_invert(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    long_ctype_invert(arg1, &out);

    ret = PyArrayScalar_New(Long);
    PyArrayScalar_ASSIGN(ret, Long, out);

    return ret;
}

#line 1262
static PyObject *
ulong_invert(PyObject *a)
{
    npy_ulong arg1;
    npy_ulong out;
    PyObject *ret;

    switch(_ulong_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_invert(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    ulong_ctype_invert(arg1, &out);

    ret = PyArrayScalar_New(ULong);
    PyArrayScalar_ASSIGN(ret, ULong, out);

    return ret;
}

#line 1262
static PyObject *
longlong_invert(PyObject *a)
{
    npy_longlong arg1;
    npy_longlong out;
    PyObject *ret;

    switch(_longlong_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_invert(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    longlong_ctype_invert(arg1, &out);

    ret = PyArrayScalar_New(LongLong);
    PyArrayScalar_ASSIGN(ret, LongLong, out);

    return ret;
}

#line 1262
static PyObject *
ulonglong_invert(PyObject *a)
{
    npy_ulonglong arg1;
    npy_ulonglong out;
    PyObject *ret;

    switch(_ulonglong_convert_to_ctype(a, &arg1)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case -2:
        /* use default handling */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_as_number->nb_invert(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

    ulonglong_ctype_invert(arg1, &out);

    ret = PyArrayScalar_New(ULongLong);
    PyArrayScalar_ASSIGN(ret, ULongLong, out);

    return ret;
}


#line 1302

#define half_invert NULL


#line 1302

#define float_invert NULL


#line 1302

#define double_invert NULL


#line 1302

#define longdouble_invert NULL


#line 1302

#define cfloat_invert NULL


#line 1302

#define cdouble_invert NULL


#line 1302

#define clongdouble_invert NULL



#if defined(NPY_PY3K)
#define NONZERO_NAME(prefix) prefix##bool
#else
#define NONZERO_NAME(prefix) prefix##nonzero
#endif

#define _IS_NONZERO(x) (x != 0)
#line 1327
static int
NONZERO_NAME(byte_)(PyObject *a)
{
    int ret;
    npy_byte arg1;

    if (_byte_convert_to_ctype(a, &arg1) < 0) {
        if (PyErr_Occurred()) {
            return -1;
        }
        return PyGenericArrType_Type.tp_as_number->NONZERO_NAME(nb_)(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

#if 1
    ret = _IS_NONZERO(arg1);
#else
    ret = (_IS_NONZERO(arg1.real) || _IS_NONZERO(arg1.imag));
#endif

    return ret;
}

#line 1327
static int
NONZERO_NAME(ubyte_)(PyObject *a)
{
    int ret;
    npy_ubyte arg1;

    if (_ubyte_convert_to_ctype(a, &arg1) < 0) {
        if (PyErr_Occurred()) {
            return -1;
        }
        return PyGenericArrType_Type.tp_as_number->NONZERO_NAME(nb_)(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

#if 1
    ret = _IS_NONZERO(arg1);
#else
    ret = (_IS_NONZERO(arg1.real) || _IS_NONZERO(arg1.imag));
#endif

    return ret;
}

#line 1327
static int
NONZERO_NAME(short_)(PyObject *a)
{
    int ret;
    npy_short arg1;

    if (_short_convert_to_ctype(a, &arg1) < 0) {
        if (PyErr_Occurred()) {
            return -1;
        }
        return PyGenericArrType_Type.tp_as_number->NONZERO_NAME(nb_)(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

#if 1
    ret = _IS_NONZERO(arg1);
#else
    ret = (_IS_NONZERO(arg1.real) || _IS_NONZERO(arg1.imag));
#endif

    return ret;
}

#line 1327
static int
NONZERO_NAME(ushort_)(PyObject *a)
{
    int ret;
    npy_ushort arg1;

    if (_ushort_convert_to_ctype(a, &arg1) < 0) {
        if (PyErr_Occurred()) {
            return -1;
        }
        return PyGenericArrType_Type.tp_as_number->NONZERO_NAME(nb_)(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

#if 1
    ret = _IS_NONZERO(arg1);
#else
    ret = (_IS_NONZERO(arg1.real) || _IS_NONZERO(arg1.imag));
#endif

    return ret;
}

#line 1327
static int
NONZERO_NAME(int_)(PyObject *a)
{
    int ret;
    npy_int arg1;

    if (_int_convert_to_ctype(a, &arg1) < 0) {
        if (PyErr_Occurred()) {
            return -1;
        }
        return PyGenericArrType_Type.tp_as_number->NONZERO_NAME(nb_)(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

#if 1
    ret = _IS_NONZERO(arg1);
#else
    ret = (_IS_NONZERO(arg1.real) || _IS_NONZERO(arg1.imag));
#endif

    return ret;
}

#line 1327
static int
NONZERO_NAME(uint_)(PyObject *a)
{
    int ret;
    npy_uint arg1;

    if (_uint_convert_to_ctype(a, &arg1) < 0) {
        if (PyErr_Occurred()) {
            return -1;
        }
        return PyGenericArrType_Type.tp_as_number->NONZERO_NAME(nb_)(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

#if 1
    ret = _IS_NONZERO(arg1);
#else
    ret = (_IS_NONZERO(arg1.real) || _IS_NONZERO(arg1.imag));
#endif

    return ret;
}

#line 1327
static int
NONZERO_NAME(long_)(PyObject *a)
{
    int ret;
    npy_long arg1;

    if (_long_convert_to_ctype(a, &arg1) < 0) {
        if (PyErr_Occurred()) {
            return -1;
        }
        return PyGenericArrType_Type.tp_as_number->NONZERO_NAME(nb_)(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

#if 1
    ret = _IS_NONZERO(arg1);
#else
    ret = (_IS_NONZERO(arg1.real) || _IS_NONZERO(arg1.imag));
#endif

    return ret;
}

#line 1327
static int
NONZERO_NAME(ulong_)(PyObject *a)
{
    int ret;
    npy_ulong arg1;

    if (_ulong_convert_to_ctype(a, &arg1) < 0) {
        if (PyErr_Occurred()) {
            return -1;
        }
        return PyGenericArrType_Type.tp_as_number->NONZERO_NAME(nb_)(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

#if 1
    ret = _IS_NONZERO(arg1);
#else
    ret = (_IS_NONZERO(arg1.real) || _IS_NONZERO(arg1.imag));
#endif

    return ret;
}

#line 1327
static int
NONZERO_NAME(longlong_)(PyObject *a)
{
    int ret;
    npy_longlong arg1;

    if (_longlong_convert_to_ctype(a, &arg1) < 0) {
        if (PyErr_Occurred()) {
            return -1;
        }
        return PyGenericArrType_Type.tp_as_number->NONZERO_NAME(nb_)(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

#if 1
    ret = _IS_NONZERO(arg1);
#else
    ret = (_IS_NONZERO(arg1.real) || _IS_NONZERO(arg1.imag));
#endif

    return ret;
}

#line 1327
static int
NONZERO_NAME(ulonglong_)(PyObject *a)
{
    int ret;
    npy_ulonglong arg1;

    if (_ulonglong_convert_to_ctype(a, &arg1) < 0) {
        if (PyErr_Occurred()) {
            return -1;
        }
        return PyGenericArrType_Type.tp_as_number->NONZERO_NAME(nb_)(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

#if 1
    ret = _IS_NONZERO(arg1);
#else
    ret = (_IS_NONZERO(arg1.real) || _IS_NONZERO(arg1.imag));
#endif

    return ret;
}

#line 1327
static int
NONZERO_NAME(half_)(PyObject *a)
{
    int ret;
    npy_half arg1;

    if (_half_convert_to_ctype(a, &arg1) < 0) {
        if (PyErr_Occurred()) {
            return -1;
        }
        return PyGenericArrType_Type.tp_as_number->NONZERO_NAME(nb_)(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

#if 1
    ret = !npy_half_iszero(arg1);
#else
    ret = (!npy_half_iszero(arg1.real) || !npy_half_iszero(arg1.imag));
#endif

    return ret;
}

#line 1327
static int
NONZERO_NAME(float_)(PyObject *a)
{
    int ret;
    npy_float arg1;

    if (_float_convert_to_ctype(a, &arg1) < 0) {
        if (PyErr_Occurred()) {
            return -1;
        }
        return PyGenericArrType_Type.tp_as_number->NONZERO_NAME(nb_)(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

#if 1
    ret = _IS_NONZERO(arg1);
#else
    ret = (_IS_NONZERO(arg1.real) || _IS_NONZERO(arg1.imag));
#endif

    return ret;
}

#line 1327
static int
NONZERO_NAME(double_)(PyObject *a)
{
    int ret;
    npy_double arg1;

    if (_double_convert_to_ctype(a, &arg1) < 0) {
        if (PyErr_Occurred()) {
            return -1;
        }
        return PyGenericArrType_Type.tp_as_number->NONZERO_NAME(nb_)(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

#if 1
    ret = _IS_NONZERO(arg1);
#else
    ret = (_IS_NONZERO(arg1.real) || _IS_NONZERO(arg1.imag));
#endif

    return ret;
}

#line 1327
static int
NONZERO_NAME(longdouble_)(PyObject *a)
{
    int ret;
    npy_longdouble arg1;

    if (_longdouble_convert_to_ctype(a, &arg1) < 0) {
        if (PyErr_Occurred()) {
            return -1;
        }
        return PyGenericArrType_Type.tp_as_number->NONZERO_NAME(nb_)(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

#if 1
    ret = _IS_NONZERO(arg1);
#else
    ret = (_IS_NONZERO(arg1.real) || _IS_NONZERO(arg1.imag));
#endif

    return ret;
}

#line 1327
static int
NONZERO_NAME(cfloat_)(PyObject *a)
{
    int ret;
    npy_cfloat arg1;

    if (_cfloat_convert_to_ctype(a, &arg1) < 0) {
        if (PyErr_Occurred()) {
            return -1;
        }
        return PyGenericArrType_Type.tp_as_number->NONZERO_NAME(nb_)(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

#if 0
    ret = _IS_NONZERO(arg1);
#else
    ret = (_IS_NONZERO(arg1.real) || _IS_NONZERO(arg1.imag));
#endif

    return ret;
}

#line 1327
static int
NONZERO_NAME(cdouble_)(PyObject *a)
{
    int ret;
    npy_cdouble arg1;

    if (_cdouble_convert_to_ctype(a, &arg1) < 0) {
        if (PyErr_Occurred()) {
            return -1;
        }
        return PyGenericArrType_Type.tp_as_number->NONZERO_NAME(nb_)(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

#if 0
    ret = _IS_NONZERO(arg1);
#else
    ret = (_IS_NONZERO(arg1.real) || _IS_NONZERO(arg1.imag));
#endif

    return ret;
}

#line 1327
static int
NONZERO_NAME(clongdouble_)(PyObject *a)
{
    int ret;
    npy_clongdouble arg1;

    if (_clongdouble_convert_to_ctype(a, &arg1) < 0) {
        if (PyErr_Occurred()) {
            return -1;
        }
        return PyGenericArrType_Type.tp_as_number->NONZERO_NAME(nb_)(a);
    }

    /*
     * here we do the actual calculation with arg1 and arg2
     * make it a function call.
     */

#if 0
    ret = _IS_NONZERO(arg1);
#else
    ret = (_IS_NONZERO(arg1.real) || _IS_NONZERO(arg1.imag));
#endif

    return ret;
}

#undef _IS_NONZERO


static int
emit_complexwarning(void)
{
    static PyObject *cls = NULL;
    if (cls == NULL) {
        PyObject *mod;
        mod = PyImport_ImportModule("numpy.core");
        assert(mod != NULL);
        cls = PyObject_GetAttrString(mod, "ComplexWarning");
        assert(cls != NULL);
        Py_DECREF(mod);
    }
    return PyErr_WarnEx(cls,
            "Casting complex values to real discards the imaginary part", 1);
}

#line 1395
static PyObject *
byte_int(PyObject *obj)
{
    PyObject *long_result;

#if 0
    signed long x = (PyArrayScalar_VAL(obj, Byte).real);
#else
    signed long x = (PyArrayScalar_VAL(obj, Byte));
#endif

#if 0
    if (emit_complexwarning() < 0) {
        return NULL;
    }
#endif

    long_result = PyLong_FromLong(x);
    if (long_result == NULL){
        return NULL;
    }

#ifndef NPY_PY3K
    /* Invoke long.__int__ to try to downcast */
    {
        PyObject *before_downcast = long_result;
        long_result = Py_TYPE(long_result)->tp_as_number->nb_int(long_result);
        Py_DECREF(before_downcast);
    }
#endif

    return long_result;
}

#line 1395
static PyObject *
ubyte_int(PyObject *obj)
{
    PyObject *long_result;

#if 0
    unsigned long x = (PyArrayScalar_VAL(obj, UByte).real);
#else
    unsigned long x = (PyArrayScalar_VAL(obj, UByte));
#endif

#if 0
    if (emit_complexwarning() < 0) {
        return NULL;
    }
#endif

    long_result = PyLong_FromUnsignedLong(x);
    if (long_result == NULL){
        return NULL;
    }

#ifndef NPY_PY3K
    /* Invoke long.__int__ to try to downcast */
    {
        PyObject *before_downcast = long_result;
        long_result = Py_TYPE(long_result)->tp_as_number->nb_int(long_result);
        Py_DECREF(before_downcast);
    }
#endif

    return long_result;
}

#line 1395
static PyObject *
short_int(PyObject *obj)
{
    PyObject *long_result;

#if 0
    signed long x = (PyArrayScalar_VAL(obj, Short).real);
#else
    signed long x = (PyArrayScalar_VAL(obj, Short));
#endif

#if 0
    if (emit_complexwarning() < 0) {
        return NULL;
    }
#endif

    long_result = PyLong_FromLong(x);
    if (long_result == NULL){
        return NULL;
    }

#ifndef NPY_PY3K
    /* Invoke long.__int__ to try to downcast */
    {
        PyObject *before_downcast = long_result;
        long_result = Py_TYPE(long_result)->tp_as_number->nb_int(long_result);
        Py_DECREF(before_downcast);
    }
#endif

    return long_result;
}

#line 1395
static PyObject *
ushort_int(PyObject *obj)
{
    PyObject *long_result;

#if 0
    unsigned long x = (PyArrayScalar_VAL(obj, UShort).real);
#else
    unsigned long x = (PyArrayScalar_VAL(obj, UShort));
#endif

#if 0
    if (emit_complexwarning() < 0) {
        return NULL;
    }
#endif

    long_result = PyLong_FromUnsignedLong(x);
    if (long_result == NULL){
        return NULL;
    }

#ifndef NPY_PY3K
    /* Invoke long.__int__ to try to downcast */
    {
        PyObject *before_downcast = long_result;
        long_result = Py_TYPE(long_result)->tp_as_number->nb_int(long_result);
        Py_DECREF(before_downcast);
    }
#endif

    return long_result;
}

#line 1395
static PyObject *
int_int(PyObject *obj)
{
    PyObject *long_result;

#if 0
    signed long x = (PyArrayScalar_VAL(obj, Int).real);
#else
    signed long x = (PyArrayScalar_VAL(obj, Int));
#endif

#if 0
    if (emit_complexwarning() < 0) {
        return NULL;
    }
#endif

    long_result = PyLong_FromLong(x);
    if (long_result == NULL){
        return NULL;
    }

#ifndef NPY_PY3K
    /* Invoke long.__int__ to try to downcast */
    {
        PyObject *before_downcast = long_result;
        long_result = Py_TYPE(long_result)->tp_as_number->nb_int(long_result);
        Py_DECREF(before_downcast);
    }
#endif

    return long_result;
}

#line 1395
static PyObject *
uint_int(PyObject *obj)
{
    PyObject *long_result;

#if 0
    unsigned long x = (PyArrayScalar_VAL(obj, UInt).real);
#else
    unsigned long x = (PyArrayScalar_VAL(obj, UInt));
#endif

#if 0
    if (emit_complexwarning() < 0) {
        return NULL;
    }
#endif

    long_result = PyLong_FromUnsignedLong(x);
    if (long_result == NULL){
        return NULL;
    }

#ifndef NPY_PY3K
    /* Invoke long.__int__ to try to downcast */
    {
        PyObject *before_downcast = long_result;
        long_result = Py_TYPE(long_result)->tp_as_number->nb_int(long_result);
        Py_DECREF(before_downcast);
    }
#endif

    return long_result;
}

#line 1395
static PyObject *
long_int(PyObject *obj)
{
    PyObject *long_result;

#if 0
    signed long x = (PyArrayScalar_VAL(obj, Long).real);
#else
    signed long x = (PyArrayScalar_VAL(obj, Long));
#endif

#if 0
    if (emit_complexwarning() < 0) {
        return NULL;
    }
#endif

    long_result = PyLong_FromLong(x);
    if (long_result == NULL){
        return NULL;
    }

#ifndef NPY_PY3K
    /* Invoke long.__int__ to try to downcast */
    {
        PyObject *before_downcast = long_result;
        long_result = Py_TYPE(long_result)->tp_as_number->nb_int(long_result);
        Py_DECREF(before_downcast);
    }
#endif

    return long_result;
}

#line 1395
static PyObject *
ulong_int(PyObject *obj)
{
    PyObject *long_result;

#if 0
    unsigned long x = (PyArrayScalar_VAL(obj, ULong).real);
#else
    unsigned long x = (PyArrayScalar_VAL(obj, ULong));
#endif

#if 0
    if (emit_complexwarning() < 0) {
        return NULL;
    }
#endif

    long_result = PyLong_FromUnsignedLong(x);
    if (long_result == NULL){
        return NULL;
    }

#ifndef NPY_PY3K
    /* Invoke long.__int__ to try to downcast */
    {
        PyObject *before_downcast = long_result;
        long_result = Py_TYPE(long_result)->tp_as_number->nb_int(long_result);
        Py_DECREF(before_downcast);
    }
#endif

    return long_result;
}

#line 1395
static PyObject *
longlong_int(PyObject *obj)
{
    PyObject *long_result;

#if 0
    signed PY_LONG_LONG x = (PyArrayScalar_VAL(obj, LongLong).real);
#else
    signed PY_LONG_LONG x = (PyArrayScalar_VAL(obj, LongLong));
#endif

#if 0
    if (emit_complexwarning() < 0) {
        return NULL;
    }
#endif

    long_result = PyLong_FromLongLong(x);
    if (long_result == NULL){
        return NULL;
    }

#ifndef NPY_PY3K
    /* Invoke long.__int__ to try to downcast */
    {
        PyObject *before_downcast = long_result;
        long_result = Py_TYPE(long_result)->tp_as_number->nb_int(long_result);
        Py_DECREF(before_downcast);
    }
#endif

    return long_result;
}

#line 1395
static PyObject *
ulonglong_int(PyObject *obj)
{
    PyObject *long_result;

#if 0
    unsigned PY_LONG_LONG x = (PyArrayScalar_VAL(obj, ULongLong).real);
#else
    unsigned PY_LONG_LONG x = (PyArrayScalar_VAL(obj, ULongLong));
#endif

#if 0
    if (emit_complexwarning() < 0) {
        return NULL;
    }
#endif

    long_result = PyLong_FromUnsignedLongLong(x);
    if (long_result == NULL){
        return NULL;
    }

#ifndef NPY_PY3K
    /* Invoke long.__int__ to try to downcast */
    {
        PyObject *before_downcast = long_result;
        long_result = Py_TYPE(long_result)->tp_as_number->nb_int(long_result);
        Py_DECREF(before_downcast);
    }
#endif

    return long_result;
}

#line 1395
static PyObject *
half_int(PyObject *obj)
{
    PyObject *long_result;

#if 0
     double x = npy_half_to_double(PyArrayScalar_VAL(obj, Half).real);
#else
     double x = npy_half_to_double(PyArrayScalar_VAL(obj, Half));
#endif

#if 0
    if (emit_complexwarning() < 0) {
        return NULL;
    }
#endif

    long_result = PyLong_FromDouble(x);
    if (long_result == NULL){
        return NULL;
    }

#ifndef NPY_PY3K
    /* Invoke long.__int__ to try to downcast */
    {
        PyObject *before_downcast = long_result;
        long_result = Py_TYPE(long_result)->tp_as_number->nb_int(long_result);
        Py_DECREF(before_downcast);
    }
#endif

    return long_result;
}

#line 1395
static PyObject *
float_int(PyObject *obj)
{
    PyObject *long_result;

#if 0
     double x = (PyArrayScalar_VAL(obj, Float).real);
#else
     double x = (PyArrayScalar_VAL(obj, Float));
#endif

#if 0
    if (emit_complexwarning() < 0) {
        return NULL;
    }
#endif

    long_result = PyLong_FromDouble(x);
    if (long_result == NULL){
        return NULL;
    }

#ifndef NPY_PY3K
    /* Invoke long.__int__ to try to downcast */
    {
        PyObject *before_downcast = long_result;
        long_result = Py_TYPE(long_result)->tp_as_number->nb_int(long_result);
        Py_DECREF(before_downcast);
    }
#endif

    return long_result;
}

#line 1395
static PyObject *
double_int(PyObject *obj)
{
    PyObject *long_result;

#if 0
     double x = (PyArrayScalar_VAL(obj, Double).real);
#else
     double x = (PyArrayScalar_VAL(obj, Double));
#endif

#if 0
    if (emit_complexwarning() < 0) {
        return NULL;
    }
#endif

    long_result = PyLong_FromDouble(x);
    if (long_result == NULL){
        return NULL;
    }

#ifndef NPY_PY3K
    /* Invoke long.__int__ to try to downcast */
    {
        PyObject *before_downcast = long_result;
        long_result = Py_TYPE(long_result)->tp_as_number->nb_int(long_result);
        Py_DECREF(before_downcast);
    }
#endif

    return long_result;
}

#line 1395
static PyObject *
longdouble_int(PyObject *obj)
{
    PyObject *long_result;

#if 0
     npy_longdouble x = (PyArrayScalar_VAL(obj, LongDouble).real);
#else
     npy_longdouble x = (PyArrayScalar_VAL(obj, LongDouble));
#endif

#if 0
    if (emit_complexwarning() < 0) {
        return NULL;
    }
#endif

    long_result = npy_longdouble_to_PyLong(x);
    if (long_result == NULL){
        return NULL;
    }

#ifndef NPY_PY3K
    /* Invoke long.__int__ to try to downcast */
    {
        PyObject *before_downcast = long_result;
        long_result = Py_TYPE(long_result)->tp_as_number->nb_int(long_result);
        Py_DECREF(before_downcast);
    }
#endif

    return long_result;
}

#line 1395
static PyObject *
cfloat_int(PyObject *obj)
{
    PyObject *long_result;

#if 1
     double x = (PyArrayScalar_VAL(obj, CFloat).real);
#else
     double x = (PyArrayScalar_VAL(obj, CFloat));
#endif

#if 1
    if (emit_complexwarning() < 0) {
        return NULL;
    }
#endif

    long_result = PyLong_FromDouble(x);
    if (long_result == NULL){
        return NULL;
    }

#ifndef NPY_PY3K
    /* Invoke long.__int__ to try to downcast */
    {
        PyObject *before_downcast = long_result;
        long_result = Py_TYPE(long_result)->tp_as_number->nb_int(long_result);
        Py_DECREF(before_downcast);
    }
#endif

    return long_result;
}

#line 1395
static PyObject *
cdouble_int(PyObject *obj)
{
    PyObject *long_result;

#if 1
     double x = (PyArrayScalar_VAL(obj, CDouble).real);
#else
     double x = (PyArrayScalar_VAL(obj, CDouble));
#endif

#if 1
    if (emit_complexwarning() < 0) {
        return NULL;
    }
#endif

    long_result = PyLong_FromDouble(x);
    if (long_result == NULL){
        return NULL;
    }

#ifndef NPY_PY3K
    /* Invoke long.__int__ to try to downcast */
    {
        PyObject *before_downcast = long_result;
        long_result = Py_TYPE(long_result)->tp_as_number->nb_int(long_result);
        Py_DECREF(before_downcast);
    }
#endif

    return long_result;
}

#line 1395
static PyObject *
clongdouble_int(PyObject *obj)
{
    PyObject *long_result;

#if 1
     npy_longdouble x = (PyArrayScalar_VAL(obj, CLongDouble).real);
#else
     npy_longdouble x = (PyArrayScalar_VAL(obj, CLongDouble));
#endif

#if 1
    if (emit_complexwarning() < 0) {
        return NULL;
    }
#endif

    long_result = npy_longdouble_to_PyLong(x);
    if (long_result == NULL){
        return NULL;
    }

#ifndef NPY_PY3K
    /* Invoke long.__int__ to try to downcast */
    {
        PyObject *before_downcast = long_result;
        long_result = Py_TYPE(long_result)->tp_as_number->nb_int(long_result);
        Py_DECREF(before_downcast);
    }
#endif

    return long_result;
}


#line 1448
static NPY_INLINE PyObject *
byte_long(PyObject *obj)
{
#if 0
    if (emit_complexwarning() < 0) {
        return NULL;
    }
    return PyLong_FromLongLong((PyArrayScalar_VAL(obj, Byte).real));
#else
    return PyLong_FromLongLong((PyArrayScalar_VAL(obj, Byte)));
#endif
}

#line 1448
static NPY_INLINE PyObject *
ubyte_long(PyObject *obj)
{
#if 0
    if (emit_complexwarning() < 0) {
        return NULL;
    }
    return PyLong_FromUnsignedLongLong((PyArrayScalar_VAL(obj, UByte).real));
#else
    return PyLong_FromUnsignedLongLong((PyArrayScalar_VAL(obj, UByte)));
#endif
}

#line 1448
static NPY_INLINE PyObject *
short_long(PyObject *obj)
{
#if 0
    if (emit_complexwarning() < 0) {
        return NULL;
    }
    return PyLong_FromLongLong((PyArrayScalar_VAL(obj, Short).real));
#else
    return PyLong_FromLongLong((PyArrayScalar_VAL(obj, Short)));
#endif
}

#line 1448
static NPY_INLINE PyObject *
ushort_long(PyObject *obj)
{
#if 0
    if (emit_complexwarning() < 0) {
        return NULL;
    }
    return PyLong_FromUnsignedLongLong((PyArrayScalar_VAL(obj, UShort).real));
#else
    return PyLong_FromUnsignedLongLong((PyArrayScalar_VAL(obj, UShort)));
#endif
}

#line 1448
static NPY_INLINE PyObject *
int_long(PyObject *obj)
{
#if 0
    if (emit_complexwarning() < 0) {
        return NULL;
    }
    return PyLong_FromLongLong((PyArrayScalar_VAL(obj, Int).real));
#else
    return PyLong_FromLongLong((PyArrayScalar_VAL(obj, Int)));
#endif
}

#line 1448
static NPY_INLINE PyObject *
uint_long(PyObject *obj)
{
#if 0
    if (emit_complexwarning() < 0) {
        return NULL;
    }
    return PyLong_FromUnsignedLongLong((PyArrayScalar_VAL(obj, UInt).real));
#else
    return PyLong_FromUnsignedLongLong((PyArrayScalar_VAL(obj, UInt)));
#endif
}

#line 1448
static NPY_INLINE PyObject *
long_long(PyObject *obj)
{
#if 0
    if (emit_complexwarning() < 0) {
        return NULL;
    }
    return PyLong_FromLongLong((PyArrayScalar_VAL(obj, Long).real));
#else
    return PyLong_FromLongLong((PyArrayScalar_VAL(obj, Long)));
#endif
}

#line 1448
static NPY_INLINE PyObject *
ulong_long(PyObject *obj)
{
#if 0
    if (emit_complexwarning() < 0) {
        return NULL;
    }
    return PyLong_FromUnsignedLongLong((PyArrayScalar_VAL(obj, ULong).real));
#else
    return PyLong_FromUnsignedLongLong((PyArrayScalar_VAL(obj, ULong)));
#endif
}

#line 1448
static NPY_INLINE PyObject *
longlong_long(PyObject *obj)
{
#if 0
    if (emit_complexwarning() < 0) {
        return NULL;
    }
    return PyLong_FromLongLong((PyArrayScalar_VAL(obj, LongLong).real));
#else
    return PyLong_FromLongLong((PyArrayScalar_VAL(obj, LongLong)));
#endif
}

#line 1448
static NPY_INLINE PyObject *
ulonglong_long(PyObject *obj)
{
#if 0
    if (emit_complexwarning() < 0) {
        return NULL;
    }
    return PyLong_FromUnsignedLongLong((PyArrayScalar_VAL(obj, ULongLong).real));
#else
    return PyLong_FromUnsignedLongLong((PyArrayScalar_VAL(obj, ULongLong)));
#endif
}

#line 1448
static NPY_INLINE PyObject *
half_long(PyObject *obj)
{
#if 0
    if (emit_complexwarning() < 0) {
        return NULL;
    }
    return PyLong_FromDouble(npy_half_to_double(PyArrayScalar_VAL(obj, Half).real));
#else
    return PyLong_FromDouble(npy_half_to_double(PyArrayScalar_VAL(obj, Half)));
#endif
}

#line 1448
static NPY_INLINE PyObject *
float_long(PyObject *obj)
{
#if 0
    if (emit_complexwarning() < 0) {
        return NULL;
    }
    return PyLong_FromDouble((PyArrayScalar_VAL(obj, Float).real));
#else
    return PyLong_FromDouble((PyArrayScalar_VAL(obj, Float)));
#endif
}

#line 1448
static NPY_INLINE PyObject *
double_long(PyObject *obj)
{
#if 0
    if (emit_complexwarning() < 0) {
        return NULL;
    }
    return PyLong_FromDouble((PyArrayScalar_VAL(obj, Double).real));
#else
    return PyLong_FromDouble((PyArrayScalar_VAL(obj, Double)));
#endif
}

#line 1448
static NPY_INLINE PyObject *
longdouble_long(PyObject *obj)
{
#if 0
    if (emit_complexwarning() < 0) {
        return NULL;
    }
    return npy_longdouble_to_PyLong((PyArrayScalar_VAL(obj, LongDouble).real));
#else
    return npy_longdouble_to_PyLong((PyArrayScalar_VAL(obj, LongDouble)));
#endif
}

#line 1448
static NPY_INLINE PyObject *
cfloat_long(PyObject *obj)
{
#if 1
    if (emit_complexwarning() < 0) {
        return NULL;
    }
    return PyLong_FromDouble((PyArrayScalar_VAL(obj, CFloat).real));
#else
    return PyLong_FromDouble((PyArrayScalar_VAL(obj, CFloat)));
#endif
}

#line 1448
static NPY_INLINE PyObject *
cdouble_long(PyObject *obj)
{
#if 1
    if (emit_complexwarning() < 0) {
        return NULL;
    }
    return PyLong_FromDouble((PyArrayScalar_VAL(obj, CDouble).real));
#else
    return PyLong_FromDouble((PyArrayScalar_VAL(obj, CDouble)));
#endif
}

#line 1448
static NPY_INLINE PyObject *
clongdouble_long(PyObject *obj)
{
#if 1
    if (emit_complexwarning() < 0) {
        return NULL;
    }
    return npy_longdouble_to_PyLong((PyArrayScalar_VAL(obj, CLongDouble).real));
#else
    return npy_longdouble_to_PyLong((PyArrayScalar_VAL(obj, CLongDouble)));
#endif
}

#line 1448
static NPY_INLINE PyObject *
byte_float(PyObject *obj)
{
#if 0
    if (emit_complexwarning() < 0) {
        return NULL;
    }
    return PyFloat_FromDouble((PyArrayScalar_VAL(obj, Byte).real));
#else
    return PyFloat_FromDouble((PyArrayScalar_VAL(obj, Byte)));
#endif
}

#line 1448
static NPY_INLINE PyObject *
ubyte_float(PyObject *obj)
{
#if 0
    if (emit_complexwarning() < 0) {
        return NULL;
    }
    return PyFloat_FromDouble((PyArrayScalar_VAL(obj, UByte).real));
#else
    return PyFloat_FromDouble((PyArrayScalar_VAL(obj, UByte)));
#endif
}

#line 1448
static NPY_INLINE PyObject *
short_float(PyObject *obj)
{
#if 0
    if (emit_complexwarning() < 0) {
        return NULL;
    }
    return PyFloat_FromDouble((PyArrayScalar_VAL(obj, Short).real));
#else
    return PyFloat_FromDouble((PyArrayScalar_VAL(obj, Short)));
#endif
}

#line 1448
static NPY_INLINE PyObject *
ushort_float(PyObject *obj)
{
#if 0
    if (emit_complexwarning() < 0) {
        return NULL;
    }
    return PyFloat_FromDouble((PyArrayScalar_VAL(obj, UShort).real));
#else
    return PyFloat_FromDouble((PyArrayScalar_VAL(obj, UShort)));
#endif
}

#line 1448
static NPY_INLINE PyObject *
int_float(PyObject *obj)
{
#if 0
    if (emit_complexwarning() < 0) {
        return NULL;
    }
    return PyFloat_FromDouble((PyArrayScalar_VAL(obj, Int).real));
#else
    return PyFloat_FromDouble((PyArrayScalar_VAL(obj, Int)));
#endif
}

#line 1448
static NPY_INLINE PyObject *
uint_float(PyObject *obj)
{
#if 0
    if (emit_complexwarning() < 0) {
        return NULL;
    }
    return PyFloat_FromDouble((PyArrayScalar_VAL(obj, UInt).real));
#else
    return PyFloat_FromDouble((PyArrayScalar_VAL(obj, UInt)));
#endif
}

#line 1448
static NPY_INLINE PyObject *
long_float(PyObject *obj)
{
#if 0
    if (emit_complexwarning() < 0) {
        return NULL;
    }
    return PyFloat_FromDouble((PyArrayScalar_VAL(obj, Long).real));
#else
    return PyFloat_FromDouble((PyArrayScalar_VAL(obj, Long)));
#endif
}

#line 1448
static NPY_INLINE PyObject *
ulong_float(PyObject *obj)
{
#if 0
    if (emit_complexwarning() < 0) {
        return NULL;
    }
    return PyFloat_FromDouble((PyArrayScalar_VAL(obj, ULong).real));
#else
    return PyFloat_FromDouble((PyArrayScalar_VAL(obj, ULong)));
#endif
}

#line 1448
static NPY_INLINE PyObject *
longlong_float(PyObject *obj)
{
#if 0
    if (emit_complexwarning() < 0) {
        return NULL;
    }
    return PyFloat_FromDouble((PyArrayScalar_VAL(obj, LongLong).real));
#else
    return PyFloat_FromDouble((PyArrayScalar_VAL(obj, LongLong)));
#endif
}

#line 1448
static NPY_INLINE PyObject *
ulonglong_float(PyObject *obj)
{
#if 0
    if (emit_complexwarning() < 0) {
        return NULL;
    }
    return PyFloat_FromDouble((PyArrayScalar_VAL(obj, ULongLong).real));
#else
    return PyFloat_FromDouble((PyArrayScalar_VAL(obj, ULongLong)));
#endif
}

#line 1448
static NPY_INLINE PyObject *
half_float(PyObject *obj)
{
#if 0
    if (emit_complexwarning() < 0) {
        return NULL;
    }
    return PyFloat_FromDouble(npy_half_to_double(PyArrayScalar_VAL(obj, Half).real));
#else
    return PyFloat_FromDouble(npy_half_to_double(PyArrayScalar_VAL(obj, Half)));
#endif
}

#line 1448
static NPY_INLINE PyObject *
float_float(PyObject *obj)
{
#if 0
    if (emit_complexwarning() < 0) {
        return NULL;
    }
    return PyFloat_FromDouble((PyArrayScalar_VAL(obj, Float).real));
#else
    return PyFloat_FromDouble((PyArrayScalar_VAL(obj, Float)));
#endif
}

#line 1448
static NPY_INLINE PyObject *
double_float(PyObject *obj)
{
#if 0
    if (emit_complexwarning() < 0) {
        return NULL;
    }
    return PyFloat_FromDouble((PyArrayScalar_VAL(obj, Double).real));
#else
    return PyFloat_FromDouble((PyArrayScalar_VAL(obj, Double)));
#endif
}

#line 1448
static NPY_INLINE PyObject *
longdouble_float(PyObject *obj)
{
#if 0
    if (emit_complexwarning() < 0) {
        return NULL;
    }
    return PyFloat_FromDouble((PyArrayScalar_VAL(obj, LongDouble).real));
#else
    return PyFloat_FromDouble((PyArrayScalar_VAL(obj, LongDouble)));
#endif
}

#line 1448
static NPY_INLINE PyObject *
cfloat_float(PyObject *obj)
{
#if 1
    if (emit_complexwarning() < 0) {
        return NULL;
    }
    return PyFloat_FromDouble((PyArrayScalar_VAL(obj, CFloat).real));
#else
    return PyFloat_FromDouble((PyArrayScalar_VAL(obj, CFloat)));
#endif
}

#line 1448
static NPY_INLINE PyObject *
cdouble_float(PyObject *obj)
{
#if 1
    if (emit_complexwarning() < 0) {
        return NULL;
    }
    return PyFloat_FromDouble((PyArrayScalar_VAL(obj, CDouble).real));
#else
    return PyFloat_FromDouble((PyArrayScalar_VAL(obj, CDouble)));
#endif
}

#line 1448
static NPY_INLINE PyObject *
clongdouble_float(PyObject *obj)
{
#if 1
    if (emit_complexwarning() < 0) {
        return NULL;
    }
    return PyFloat_FromDouble((PyArrayScalar_VAL(obj, CLongDouble).real));
#else
    return PyFloat_FromDouble((PyArrayScalar_VAL(obj, CLongDouble)));
#endif
}


#if !defined(NPY_PY3K)

#line 1474
static PyObject *
byte_oct(PyObject *obj)
{
    PyObject *pyint;
    pyint = byte_int(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyInt_Type.tp_as_number->nb_oct(pyint);
}

#line 1474
static PyObject *
ubyte_oct(PyObject *obj)
{
    PyObject *pyint;
    pyint = ubyte_int(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyInt_Type.tp_as_number->nb_oct(pyint);
}

#line 1474
static PyObject *
short_oct(PyObject *obj)
{
    PyObject *pyint;
    pyint = short_int(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyInt_Type.tp_as_number->nb_oct(pyint);
}

#line 1474
static PyObject *
ushort_oct(PyObject *obj)
{
    PyObject *pyint;
    pyint = ushort_int(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyInt_Type.tp_as_number->nb_oct(pyint);
}

#line 1474
static PyObject *
int_oct(PyObject *obj)
{
    PyObject *pyint;
    pyint = int_int(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyInt_Type.tp_as_number->nb_oct(pyint);
}

#line 1474
static PyObject *
uint_oct(PyObject *obj)
{
    PyObject *pyint;
    pyint = uint_long(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyLong_Type.tp_as_number->nb_oct(pyint);
}

#line 1474
static PyObject *
long_oct(PyObject *obj)
{
    PyObject *pyint;
    pyint = long_long(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyLong_Type.tp_as_number->nb_oct(pyint);
}

#line 1474
static PyObject *
ulong_oct(PyObject *obj)
{
    PyObject *pyint;
    pyint = ulong_long(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyLong_Type.tp_as_number->nb_oct(pyint);
}

#line 1474
static PyObject *
longlong_oct(PyObject *obj)
{
    PyObject *pyint;
    pyint = longlong_long(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyLong_Type.tp_as_number->nb_oct(pyint);
}

#line 1474
static PyObject *
ulonglong_oct(PyObject *obj)
{
    PyObject *pyint;
    pyint = ulonglong_long(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyLong_Type.tp_as_number->nb_oct(pyint);
}

#line 1474
static PyObject *
half_oct(PyObject *obj)
{
    PyObject *pyint;
    pyint = half_int(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyInt_Type.tp_as_number->nb_oct(pyint);
}

#line 1474
static PyObject *
float_oct(PyObject *obj)
{
    PyObject *pyint;
    pyint = float_int(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyInt_Type.tp_as_number->nb_oct(pyint);
}

#line 1474
static PyObject *
double_oct(PyObject *obj)
{
    PyObject *pyint;
    pyint = double_long(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyLong_Type.tp_as_number->nb_oct(pyint);
}

#line 1474
static PyObject *
longdouble_oct(PyObject *obj)
{
    PyObject *pyint;
    pyint = longdouble_long(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyLong_Type.tp_as_number->nb_oct(pyint);
}

#line 1474
static PyObject *
cfloat_oct(PyObject *obj)
{
    PyObject *pyint;
    pyint = cfloat_int(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyInt_Type.tp_as_number->nb_oct(pyint);
}

#line 1474
static PyObject *
cdouble_oct(PyObject *obj)
{
    PyObject *pyint;
    pyint = cdouble_long(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyLong_Type.tp_as_number->nb_oct(pyint);
}

#line 1474
static PyObject *
clongdouble_oct(PyObject *obj)
{
    PyObject *pyint;
    pyint = clongdouble_long(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyLong_Type.tp_as_number->nb_oct(pyint);
}

#line 1474
static PyObject *
byte_hex(PyObject *obj)
{
    PyObject *pyint;
    pyint = byte_int(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyInt_Type.tp_as_number->nb_hex(pyint);
}

#line 1474
static PyObject *
ubyte_hex(PyObject *obj)
{
    PyObject *pyint;
    pyint = ubyte_int(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyInt_Type.tp_as_number->nb_hex(pyint);
}

#line 1474
static PyObject *
short_hex(PyObject *obj)
{
    PyObject *pyint;
    pyint = short_int(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyInt_Type.tp_as_number->nb_hex(pyint);
}

#line 1474
static PyObject *
ushort_hex(PyObject *obj)
{
    PyObject *pyint;
    pyint = ushort_int(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyInt_Type.tp_as_number->nb_hex(pyint);
}

#line 1474
static PyObject *
int_hex(PyObject *obj)
{
    PyObject *pyint;
    pyint = int_int(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyInt_Type.tp_as_number->nb_hex(pyint);
}

#line 1474
static PyObject *
uint_hex(PyObject *obj)
{
    PyObject *pyint;
    pyint = uint_long(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyLong_Type.tp_as_number->nb_hex(pyint);
}

#line 1474
static PyObject *
long_hex(PyObject *obj)
{
    PyObject *pyint;
    pyint = long_long(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyLong_Type.tp_as_number->nb_hex(pyint);
}

#line 1474
static PyObject *
ulong_hex(PyObject *obj)
{
    PyObject *pyint;
    pyint = ulong_long(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyLong_Type.tp_as_number->nb_hex(pyint);
}

#line 1474
static PyObject *
longlong_hex(PyObject *obj)
{
    PyObject *pyint;
    pyint = longlong_long(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyLong_Type.tp_as_number->nb_hex(pyint);
}

#line 1474
static PyObject *
ulonglong_hex(PyObject *obj)
{
    PyObject *pyint;
    pyint = ulonglong_long(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyLong_Type.tp_as_number->nb_hex(pyint);
}

#line 1474
static PyObject *
half_hex(PyObject *obj)
{
    PyObject *pyint;
    pyint = half_int(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyInt_Type.tp_as_number->nb_hex(pyint);
}

#line 1474
static PyObject *
float_hex(PyObject *obj)
{
    PyObject *pyint;
    pyint = float_int(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyInt_Type.tp_as_number->nb_hex(pyint);
}

#line 1474
static PyObject *
double_hex(PyObject *obj)
{
    PyObject *pyint;
    pyint = double_long(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyLong_Type.tp_as_number->nb_hex(pyint);
}

#line 1474
static PyObject *
longdouble_hex(PyObject *obj)
{
    PyObject *pyint;
    pyint = longdouble_long(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyLong_Type.tp_as_number->nb_hex(pyint);
}

#line 1474
static PyObject *
cfloat_hex(PyObject *obj)
{
    PyObject *pyint;
    pyint = cfloat_int(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyInt_Type.tp_as_number->nb_hex(pyint);
}

#line 1474
static PyObject *
cdouble_hex(PyObject *obj)
{
    PyObject *pyint;
    pyint = cdouble_long(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyLong_Type.tp_as_number->nb_hex(pyint);
}

#line 1474
static PyObject *
clongdouble_hex(PyObject *obj)
{
    PyObject *pyint;
    pyint = clongdouble_long(obj);
    if (pyint == NULL) {
        return NULL;
    }
    return PyLong_Type.tp_as_number->nb_hex(pyint);
}


#endif

#line 1494
#define def_cmp_le(arg1, arg2) (arg1 <= arg2)
#define cmplx_cmp_le(arg1, arg2) ((arg1.real == arg2.real) ?        \
                                      arg1.imag <= arg2.imag :        \
                                      arg1.real <= arg2.real)
#define def_half_cmp_le(arg1, arg2) npy_half_le(arg1, arg2)

#line 1494
#define def_cmp_ge(arg1, arg2) (arg1 >= arg2)
#define cmplx_cmp_ge(arg1, arg2) ((arg1.real == arg2.real) ?        \
                                      arg1.imag >= arg2.imag :        \
                                      arg1.real >= arg2.real)
#define def_half_cmp_ge(arg1, arg2) npy_half_ge(arg1, arg2)

#line 1494
#define def_cmp_lt(arg1, arg2) (arg1 < arg2)
#define cmplx_cmp_lt(arg1, arg2) ((arg1.real == arg2.real) ?        \
                                      arg1.imag < arg2.imag :        \
                                      arg1.real < arg2.real)
#define def_half_cmp_lt(arg1, arg2) npy_half_lt(arg1, arg2)

#line 1494
#define def_cmp_gt(arg1, arg2) (arg1 > arg2)
#define cmplx_cmp_gt(arg1, arg2) ((arg1.real == arg2.real) ?        \
                                      arg1.imag > arg2.imag :        \
                                      arg1.real > arg2.real)
#define def_half_cmp_gt(arg1, arg2) npy_half_gt(arg1, arg2)

#line 1494
#define def_cmp_eq(arg1, arg2) (arg1 == arg2)
#define cmplx_cmp_eq(arg1, arg2) ((arg1.real == arg2.real) ?        \
                                      arg1.imag == arg2.imag :        \
                                      arg1.real == arg2.real)
#define def_half_cmp_eq(arg1, arg2) npy_half_eq(arg1, arg2)

#line 1494
#define def_cmp_ne(arg1, arg2) (arg1 != arg2)
#define cmplx_cmp_ne(arg1, arg2) ((arg1.real == arg2.real) ?        \
                                      arg1.imag != arg2.imag :        \
                                      arg1.real != arg2.real)
#define def_half_cmp_ne(arg1, arg2) npy_half_ne(arg1, arg2)


#line 1508
static PyObject*
byte_richcompare(PyObject *self, PyObject *other, int cmp_op)
{
    npy_byte arg1, arg2;
    int out=0;

    RICHCMP_GIVE_UP_IF_NEEDED(self, other);

    switch(_byte_convert2_to_ctypes(self, &arg1, other, &arg2)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
    case -2:
        /* use ufunc */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_richcompare(self, other, cmp_op);
    case -3:
        /*
         * special case for longdouble and clongdouble
         * because they have a recursive getitem in their dtype
         */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    /* here we do the actual calculation with arg1 and arg2 */
    switch (cmp_op) {
    case Py_EQ:
        out = def_cmp_eq(arg1, arg2);
        break;
    case Py_NE:
        out = def_cmp_ne(arg1, arg2);
        break;
    case Py_LE:
        out = def_cmp_le(arg1, arg2);
        break;
    case Py_GE:
        out = def_cmp_ge(arg1, arg2);
        break;
    case Py_LT:
        out = def_cmp_lt(arg1, arg2);
        break;
    case Py_GT:
        out = def_cmp_gt(arg1, arg2);
        break;
    }

    if (out) {
        PyArrayScalar_RETURN_TRUE;
    }
    else {
        PyArrayScalar_RETURN_FALSE;
    }
}

#line 1508
static PyObject*
ubyte_richcompare(PyObject *self, PyObject *other, int cmp_op)
{
    npy_ubyte arg1, arg2;
    int out=0;

    RICHCMP_GIVE_UP_IF_NEEDED(self, other);

    switch(_ubyte_convert2_to_ctypes(self, &arg1, other, &arg2)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
    case -2:
        /* use ufunc */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_richcompare(self, other, cmp_op);
    case -3:
        /*
         * special case for longdouble and clongdouble
         * because they have a recursive getitem in their dtype
         */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    /* here we do the actual calculation with arg1 and arg2 */
    switch (cmp_op) {
    case Py_EQ:
        out = def_cmp_eq(arg1, arg2);
        break;
    case Py_NE:
        out = def_cmp_ne(arg1, arg2);
        break;
    case Py_LE:
        out = def_cmp_le(arg1, arg2);
        break;
    case Py_GE:
        out = def_cmp_ge(arg1, arg2);
        break;
    case Py_LT:
        out = def_cmp_lt(arg1, arg2);
        break;
    case Py_GT:
        out = def_cmp_gt(arg1, arg2);
        break;
    }

    if (out) {
        PyArrayScalar_RETURN_TRUE;
    }
    else {
        PyArrayScalar_RETURN_FALSE;
    }
}

#line 1508
static PyObject*
short_richcompare(PyObject *self, PyObject *other, int cmp_op)
{
    npy_short arg1, arg2;
    int out=0;

    RICHCMP_GIVE_UP_IF_NEEDED(self, other);

    switch(_short_convert2_to_ctypes(self, &arg1, other, &arg2)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
    case -2:
        /* use ufunc */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_richcompare(self, other, cmp_op);
    case -3:
        /*
         * special case for longdouble and clongdouble
         * because they have a recursive getitem in their dtype
         */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    /* here we do the actual calculation with arg1 and arg2 */
    switch (cmp_op) {
    case Py_EQ:
        out = def_cmp_eq(arg1, arg2);
        break;
    case Py_NE:
        out = def_cmp_ne(arg1, arg2);
        break;
    case Py_LE:
        out = def_cmp_le(arg1, arg2);
        break;
    case Py_GE:
        out = def_cmp_ge(arg1, arg2);
        break;
    case Py_LT:
        out = def_cmp_lt(arg1, arg2);
        break;
    case Py_GT:
        out = def_cmp_gt(arg1, arg2);
        break;
    }

    if (out) {
        PyArrayScalar_RETURN_TRUE;
    }
    else {
        PyArrayScalar_RETURN_FALSE;
    }
}

#line 1508
static PyObject*
ushort_richcompare(PyObject *self, PyObject *other, int cmp_op)
{
    npy_ushort arg1, arg2;
    int out=0;

    RICHCMP_GIVE_UP_IF_NEEDED(self, other);

    switch(_ushort_convert2_to_ctypes(self, &arg1, other, &arg2)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
    case -2:
        /* use ufunc */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_richcompare(self, other, cmp_op);
    case -3:
        /*
         * special case for longdouble and clongdouble
         * because they have a recursive getitem in their dtype
         */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    /* here we do the actual calculation with arg1 and arg2 */
    switch (cmp_op) {
    case Py_EQ:
        out = def_cmp_eq(arg1, arg2);
        break;
    case Py_NE:
        out = def_cmp_ne(arg1, arg2);
        break;
    case Py_LE:
        out = def_cmp_le(arg1, arg2);
        break;
    case Py_GE:
        out = def_cmp_ge(arg1, arg2);
        break;
    case Py_LT:
        out = def_cmp_lt(arg1, arg2);
        break;
    case Py_GT:
        out = def_cmp_gt(arg1, arg2);
        break;
    }

    if (out) {
        PyArrayScalar_RETURN_TRUE;
    }
    else {
        PyArrayScalar_RETURN_FALSE;
    }
}

#line 1508
static PyObject*
int_richcompare(PyObject *self, PyObject *other, int cmp_op)
{
    npy_int arg1, arg2;
    int out=0;

    RICHCMP_GIVE_UP_IF_NEEDED(self, other);

    switch(_int_convert2_to_ctypes(self, &arg1, other, &arg2)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
    case -2:
        /* use ufunc */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_richcompare(self, other, cmp_op);
    case -3:
        /*
         * special case for longdouble and clongdouble
         * because they have a recursive getitem in their dtype
         */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    /* here we do the actual calculation with arg1 and arg2 */
    switch (cmp_op) {
    case Py_EQ:
        out = def_cmp_eq(arg1, arg2);
        break;
    case Py_NE:
        out = def_cmp_ne(arg1, arg2);
        break;
    case Py_LE:
        out = def_cmp_le(arg1, arg2);
        break;
    case Py_GE:
        out = def_cmp_ge(arg1, arg2);
        break;
    case Py_LT:
        out = def_cmp_lt(arg1, arg2);
        break;
    case Py_GT:
        out = def_cmp_gt(arg1, arg2);
        break;
    }

    if (out) {
        PyArrayScalar_RETURN_TRUE;
    }
    else {
        PyArrayScalar_RETURN_FALSE;
    }
}

#line 1508
static PyObject*
uint_richcompare(PyObject *self, PyObject *other, int cmp_op)
{
    npy_uint arg1, arg2;
    int out=0;

    RICHCMP_GIVE_UP_IF_NEEDED(self, other);

    switch(_uint_convert2_to_ctypes(self, &arg1, other, &arg2)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
    case -2:
        /* use ufunc */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_richcompare(self, other, cmp_op);
    case -3:
        /*
         * special case for longdouble and clongdouble
         * because they have a recursive getitem in their dtype
         */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    /* here we do the actual calculation with arg1 and arg2 */
    switch (cmp_op) {
    case Py_EQ:
        out = def_cmp_eq(arg1, arg2);
        break;
    case Py_NE:
        out = def_cmp_ne(arg1, arg2);
        break;
    case Py_LE:
        out = def_cmp_le(arg1, arg2);
        break;
    case Py_GE:
        out = def_cmp_ge(arg1, arg2);
        break;
    case Py_LT:
        out = def_cmp_lt(arg1, arg2);
        break;
    case Py_GT:
        out = def_cmp_gt(arg1, arg2);
        break;
    }

    if (out) {
        PyArrayScalar_RETURN_TRUE;
    }
    else {
        PyArrayScalar_RETURN_FALSE;
    }
}

#line 1508
static PyObject*
long_richcompare(PyObject *self, PyObject *other, int cmp_op)
{
    npy_long arg1, arg2;
    int out=0;

    RICHCMP_GIVE_UP_IF_NEEDED(self, other);

    switch(_long_convert2_to_ctypes(self, &arg1, other, &arg2)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
    case -2:
        /* use ufunc */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_richcompare(self, other, cmp_op);
    case -3:
        /*
         * special case for longdouble and clongdouble
         * because they have a recursive getitem in their dtype
         */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    /* here we do the actual calculation with arg1 and arg2 */
    switch (cmp_op) {
    case Py_EQ:
        out = def_cmp_eq(arg1, arg2);
        break;
    case Py_NE:
        out = def_cmp_ne(arg1, arg2);
        break;
    case Py_LE:
        out = def_cmp_le(arg1, arg2);
        break;
    case Py_GE:
        out = def_cmp_ge(arg1, arg2);
        break;
    case Py_LT:
        out = def_cmp_lt(arg1, arg2);
        break;
    case Py_GT:
        out = def_cmp_gt(arg1, arg2);
        break;
    }

    if (out) {
        PyArrayScalar_RETURN_TRUE;
    }
    else {
        PyArrayScalar_RETURN_FALSE;
    }
}

#line 1508
static PyObject*
ulong_richcompare(PyObject *self, PyObject *other, int cmp_op)
{
    npy_ulong arg1, arg2;
    int out=0;

    RICHCMP_GIVE_UP_IF_NEEDED(self, other);

    switch(_ulong_convert2_to_ctypes(self, &arg1, other, &arg2)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
    case -2:
        /* use ufunc */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_richcompare(self, other, cmp_op);
    case -3:
        /*
         * special case for longdouble and clongdouble
         * because they have a recursive getitem in their dtype
         */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    /* here we do the actual calculation with arg1 and arg2 */
    switch (cmp_op) {
    case Py_EQ:
        out = def_cmp_eq(arg1, arg2);
        break;
    case Py_NE:
        out = def_cmp_ne(arg1, arg2);
        break;
    case Py_LE:
        out = def_cmp_le(arg1, arg2);
        break;
    case Py_GE:
        out = def_cmp_ge(arg1, arg2);
        break;
    case Py_LT:
        out = def_cmp_lt(arg1, arg2);
        break;
    case Py_GT:
        out = def_cmp_gt(arg1, arg2);
        break;
    }

    if (out) {
        PyArrayScalar_RETURN_TRUE;
    }
    else {
        PyArrayScalar_RETURN_FALSE;
    }
}

#line 1508
static PyObject*
longlong_richcompare(PyObject *self, PyObject *other, int cmp_op)
{
    npy_longlong arg1, arg2;
    int out=0;

    RICHCMP_GIVE_UP_IF_NEEDED(self, other);

    switch(_longlong_convert2_to_ctypes(self, &arg1, other, &arg2)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
    case -2:
        /* use ufunc */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_richcompare(self, other, cmp_op);
    case -3:
        /*
         * special case for longdouble and clongdouble
         * because they have a recursive getitem in their dtype
         */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    /* here we do the actual calculation with arg1 and arg2 */
    switch (cmp_op) {
    case Py_EQ:
        out = def_cmp_eq(arg1, arg2);
        break;
    case Py_NE:
        out = def_cmp_ne(arg1, arg2);
        break;
    case Py_LE:
        out = def_cmp_le(arg1, arg2);
        break;
    case Py_GE:
        out = def_cmp_ge(arg1, arg2);
        break;
    case Py_LT:
        out = def_cmp_lt(arg1, arg2);
        break;
    case Py_GT:
        out = def_cmp_gt(arg1, arg2);
        break;
    }

    if (out) {
        PyArrayScalar_RETURN_TRUE;
    }
    else {
        PyArrayScalar_RETURN_FALSE;
    }
}

#line 1508
static PyObject*
ulonglong_richcompare(PyObject *self, PyObject *other, int cmp_op)
{
    npy_ulonglong arg1, arg2;
    int out=0;

    RICHCMP_GIVE_UP_IF_NEEDED(self, other);

    switch(_ulonglong_convert2_to_ctypes(self, &arg1, other, &arg2)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
    case -2:
        /* use ufunc */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_richcompare(self, other, cmp_op);
    case -3:
        /*
         * special case for longdouble and clongdouble
         * because they have a recursive getitem in their dtype
         */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    /* here we do the actual calculation with arg1 and arg2 */
    switch (cmp_op) {
    case Py_EQ:
        out = def_cmp_eq(arg1, arg2);
        break;
    case Py_NE:
        out = def_cmp_ne(arg1, arg2);
        break;
    case Py_LE:
        out = def_cmp_le(arg1, arg2);
        break;
    case Py_GE:
        out = def_cmp_ge(arg1, arg2);
        break;
    case Py_LT:
        out = def_cmp_lt(arg1, arg2);
        break;
    case Py_GT:
        out = def_cmp_gt(arg1, arg2);
        break;
    }

    if (out) {
        PyArrayScalar_RETURN_TRUE;
    }
    else {
        PyArrayScalar_RETURN_FALSE;
    }
}

#line 1508
static PyObject*
half_richcompare(PyObject *self, PyObject *other, int cmp_op)
{
    npy_half arg1, arg2;
    int out=0;

    RICHCMP_GIVE_UP_IF_NEEDED(self, other);

    switch(_half_convert2_to_ctypes(self, &arg1, other, &arg2)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
    case -2:
        /* use ufunc */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_richcompare(self, other, cmp_op);
    case -3:
        /*
         * special case for longdouble and clongdouble
         * because they have a recursive getitem in their dtype
         */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    /* here we do the actual calculation with arg1 and arg2 */
    switch (cmp_op) {
    case Py_EQ:
        out = def_half_cmp_eq(arg1, arg2);
        break;
    case Py_NE:
        out = def_half_cmp_ne(arg1, arg2);
        break;
    case Py_LE:
        out = def_half_cmp_le(arg1, arg2);
        break;
    case Py_GE:
        out = def_half_cmp_ge(arg1, arg2);
        break;
    case Py_LT:
        out = def_half_cmp_lt(arg1, arg2);
        break;
    case Py_GT:
        out = def_half_cmp_gt(arg1, arg2);
        break;
    }

    if (out) {
        PyArrayScalar_RETURN_TRUE;
    }
    else {
        PyArrayScalar_RETURN_FALSE;
    }
}

#line 1508
static PyObject*
float_richcompare(PyObject *self, PyObject *other, int cmp_op)
{
    npy_float arg1, arg2;
    int out=0;

    RICHCMP_GIVE_UP_IF_NEEDED(self, other);

    switch(_float_convert2_to_ctypes(self, &arg1, other, &arg2)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
    case -2:
        /* use ufunc */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_richcompare(self, other, cmp_op);
    case -3:
        /*
         * special case for longdouble and clongdouble
         * because they have a recursive getitem in their dtype
         */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    /* here we do the actual calculation with arg1 and arg2 */
    switch (cmp_op) {
    case Py_EQ:
        out = def_cmp_eq(arg1, arg2);
        break;
    case Py_NE:
        out = def_cmp_ne(arg1, arg2);
        break;
    case Py_LE:
        out = def_cmp_le(arg1, arg2);
        break;
    case Py_GE:
        out = def_cmp_ge(arg1, arg2);
        break;
    case Py_LT:
        out = def_cmp_lt(arg1, arg2);
        break;
    case Py_GT:
        out = def_cmp_gt(arg1, arg2);
        break;
    }

    if (out) {
        PyArrayScalar_RETURN_TRUE;
    }
    else {
        PyArrayScalar_RETURN_FALSE;
    }
}

#line 1508
static PyObject*
double_richcompare(PyObject *self, PyObject *other, int cmp_op)
{
    npy_double arg1, arg2;
    int out=0;

    RICHCMP_GIVE_UP_IF_NEEDED(self, other);

    switch(_double_convert2_to_ctypes(self, &arg1, other, &arg2)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
    case -2:
        /* use ufunc */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_richcompare(self, other, cmp_op);
    case -3:
        /*
         * special case for longdouble and clongdouble
         * because they have a recursive getitem in their dtype
         */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    /* here we do the actual calculation with arg1 and arg2 */
    switch (cmp_op) {
    case Py_EQ:
        out = def_cmp_eq(arg1, arg2);
        break;
    case Py_NE:
        out = def_cmp_ne(arg1, arg2);
        break;
    case Py_LE:
        out = def_cmp_le(arg1, arg2);
        break;
    case Py_GE:
        out = def_cmp_ge(arg1, arg2);
        break;
    case Py_LT:
        out = def_cmp_lt(arg1, arg2);
        break;
    case Py_GT:
        out = def_cmp_gt(arg1, arg2);
        break;
    }

    if (out) {
        PyArrayScalar_RETURN_TRUE;
    }
    else {
        PyArrayScalar_RETURN_FALSE;
    }
}

#line 1508
static PyObject*
longdouble_richcompare(PyObject *self, PyObject *other, int cmp_op)
{
    npy_longdouble arg1, arg2;
    int out=0;

    RICHCMP_GIVE_UP_IF_NEEDED(self, other);

    switch(_longdouble_convert2_to_ctypes(self, &arg1, other, &arg2)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
    case -2:
        /* use ufunc */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_richcompare(self, other, cmp_op);
    case -3:
        /*
         * special case for longdouble and clongdouble
         * because they have a recursive getitem in their dtype
         */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    /* here we do the actual calculation with arg1 and arg2 */
    switch (cmp_op) {
    case Py_EQ:
        out = def_cmp_eq(arg1, arg2);
        break;
    case Py_NE:
        out = def_cmp_ne(arg1, arg2);
        break;
    case Py_LE:
        out = def_cmp_le(arg1, arg2);
        break;
    case Py_GE:
        out = def_cmp_ge(arg1, arg2);
        break;
    case Py_LT:
        out = def_cmp_lt(arg1, arg2);
        break;
    case Py_GT:
        out = def_cmp_gt(arg1, arg2);
        break;
    }

    if (out) {
        PyArrayScalar_RETURN_TRUE;
    }
    else {
        PyArrayScalar_RETURN_FALSE;
    }
}

#line 1508
static PyObject*
cfloat_richcompare(PyObject *self, PyObject *other, int cmp_op)
{
    npy_cfloat arg1, arg2;
    int out=0;

    RICHCMP_GIVE_UP_IF_NEEDED(self, other);

    switch(_cfloat_convert2_to_ctypes(self, &arg1, other, &arg2)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
    case -2:
        /* use ufunc */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_richcompare(self, other, cmp_op);
    case -3:
        /*
         * special case for longdouble and clongdouble
         * because they have a recursive getitem in their dtype
         */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    /* here we do the actual calculation with arg1 and arg2 */
    switch (cmp_op) {
    case Py_EQ:
        out = cmplx_cmp_eq(arg1, arg2);
        break;
    case Py_NE:
        out = cmplx_cmp_ne(arg1, arg2);
        break;
    case Py_LE:
        out = cmplx_cmp_le(arg1, arg2);
        break;
    case Py_GE:
        out = cmplx_cmp_ge(arg1, arg2);
        break;
    case Py_LT:
        out = cmplx_cmp_lt(arg1, arg2);
        break;
    case Py_GT:
        out = cmplx_cmp_gt(arg1, arg2);
        break;
    }

    if (out) {
        PyArrayScalar_RETURN_TRUE;
    }
    else {
        PyArrayScalar_RETURN_FALSE;
    }
}

#line 1508
static PyObject*
cdouble_richcompare(PyObject *self, PyObject *other, int cmp_op)
{
    npy_cdouble arg1, arg2;
    int out=0;

    RICHCMP_GIVE_UP_IF_NEEDED(self, other);

    switch(_cdouble_convert2_to_ctypes(self, &arg1, other, &arg2)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
    case -2:
        /* use ufunc */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_richcompare(self, other, cmp_op);
    case -3:
        /*
         * special case for longdouble and clongdouble
         * because they have a recursive getitem in their dtype
         */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    /* here we do the actual calculation with arg1 and arg2 */
    switch (cmp_op) {
    case Py_EQ:
        out = cmplx_cmp_eq(arg1, arg2);
        break;
    case Py_NE:
        out = cmplx_cmp_ne(arg1, arg2);
        break;
    case Py_LE:
        out = cmplx_cmp_le(arg1, arg2);
        break;
    case Py_GE:
        out = cmplx_cmp_ge(arg1, arg2);
        break;
    case Py_LT:
        out = cmplx_cmp_lt(arg1, arg2);
        break;
    case Py_GT:
        out = cmplx_cmp_gt(arg1, arg2);
        break;
    }

    if (out) {
        PyArrayScalar_RETURN_TRUE;
    }
    else {
        PyArrayScalar_RETURN_FALSE;
    }
}

#line 1508
static PyObject*
clongdouble_richcompare(PyObject *self, PyObject *other, int cmp_op)
{
    npy_clongdouble arg1, arg2;
    int out=0;

    RICHCMP_GIVE_UP_IF_NEEDED(self, other);

    switch(_clongdouble_convert2_to_ctypes(self, &arg1, other, &arg2)) {
    case 0:
        break;
    case -1:
        /* can't cast both safely use different add function */
    case -2:
        /* use ufunc */
        if (PyErr_Occurred()) {
            return NULL;
        }
        return PyGenericArrType_Type.tp_richcompare(self, other, cmp_op);
    case -3:
        /*
         * special case for longdouble and clongdouble
         * because they have a recursive getitem in their dtype
         */
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    /* here we do the actual calculation with arg1 and arg2 */
    switch (cmp_op) {
    case Py_EQ:
        out = cmplx_cmp_eq(arg1, arg2);
        break;
    case Py_NE:
        out = cmplx_cmp_ne(arg1, arg2);
        break;
    case Py_LE:
        out = cmplx_cmp_le(arg1, arg2);
        break;
    case Py_GE:
        out = cmplx_cmp_ge(arg1, arg2);
        break;
    case Py_LT:
        out = cmplx_cmp_lt(arg1, arg2);
        break;
    case Py_GT:
        out = cmplx_cmp_gt(arg1, arg2);
        break;
    }

    if (out) {
        PyArrayScalar_RETURN_TRUE;
    }
    else {
        PyArrayScalar_RETURN_FALSE;
    }
}


#line 1573
static PyNumberMethods byte_as_number = {
    (binaryfunc)byte_add,                     /*nb_add*/
    (binaryfunc)byte_subtract,                /*nb_subtract*/
    (binaryfunc)byte_multiply,                /*nb_multiply*/
#if !defined(NPY_PY3K)
    (binaryfunc)byte_divide,                  /*nb_divide*/
#endif
    (binaryfunc)byte_remainder,               /*nb_remainder*/
    (binaryfunc)byte_divmod,                  /*nb_divmod*/
    (ternaryfunc)byte_power,                  /*nb_power*/
    (unaryfunc)byte_negative,
    (unaryfunc)byte_positive,                 /*nb_pos*/
    (unaryfunc)byte_absolute,                 /*nb_abs*/
#if defined(NPY_PY3K)
    (inquiry)byte_bool,                       /*nb_bool*/
#else
    (inquiry)byte_nonzero,                    /*nb_nonzero*/
#endif
    (unaryfunc)byte_invert,                   /*nb_invert*/
    (binaryfunc)byte_lshift,                  /*nb_lshift*/
    (binaryfunc)byte_rshift,                  /*nb_rshift*/
    (binaryfunc)byte_and,                     /*nb_and*/
    (binaryfunc)byte_xor,                     /*nb_xor*/
    (binaryfunc)byte_or,                      /*nb_or*/
#if !defined(NPY_PY3K)
    0,                                          /*nb_coerce*/
#endif
    (unaryfunc)byte_int,                      /*nb_int*/
#if defined(NPY_PY3K)
    (unaryfunc)0,                               /*nb_reserved*/
#else
    (unaryfunc)byte_long,                     /*nb_long*/
#endif
    (unaryfunc)byte_float,                    /*nb_float*/
#if !defined(NPY_PY3K)
    (unaryfunc)byte_oct,                      /*nb_oct*/
    (unaryfunc)byte_hex,                      /*nb_hex*/
#endif
    0,                                          /*inplace_add*/
    0,                                          /*inplace_subtract*/
    0,                                          /*inplace_multiply*/
#if !defined(NPY_PY3K)
    0,                                          /*inplace_divide*/
#endif
    0,                                          /*inplace_remainder*/
    0,                                          /*inplace_power*/
    0,                                          /*inplace_lshift*/
    0,                                          /*inplace_rshift*/
    0,                                          /*inplace_and*/
    0,                                          /*inplace_xor*/
    0,                                          /*inplace_or*/
    (binaryfunc)byte_floor_divide,            /*nb_floor_divide*/
    (binaryfunc)byte_true_divide,             /*nb_true_divide*/
    0,                                          /*nb_inplace_floor_divide*/
    0,                                          /*nb_inplace_true_divide*/
    (unaryfunc)NULL,                            /*nb_index*/
#if PY_VERSION_HEX >= 0x03050000
    0,                                          /*nb_matrix_multiply*/
    0,                                          /*nb_inplace_matrix_multiply*/
#endif
};

#line 1573
static PyNumberMethods ubyte_as_number = {
    (binaryfunc)ubyte_add,                     /*nb_add*/
    (binaryfunc)ubyte_subtract,                /*nb_subtract*/
    (binaryfunc)ubyte_multiply,                /*nb_multiply*/
#if !defined(NPY_PY3K)
    (binaryfunc)ubyte_divide,                  /*nb_divide*/
#endif
    (binaryfunc)ubyte_remainder,               /*nb_remainder*/
    (binaryfunc)ubyte_divmod,                  /*nb_divmod*/
    (ternaryfunc)ubyte_power,                  /*nb_power*/
    (unaryfunc)ubyte_negative,
    (unaryfunc)ubyte_positive,                 /*nb_pos*/
    (unaryfunc)ubyte_absolute,                 /*nb_abs*/
#if defined(NPY_PY3K)
    (inquiry)ubyte_bool,                       /*nb_bool*/
#else
    (inquiry)ubyte_nonzero,                    /*nb_nonzero*/
#endif
    (unaryfunc)ubyte_invert,                   /*nb_invert*/
    (binaryfunc)ubyte_lshift,                  /*nb_lshift*/
    (binaryfunc)ubyte_rshift,                  /*nb_rshift*/
    (binaryfunc)ubyte_and,                     /*nb_and*/
    (binaryfunc)ubyte_xor,                     /*nb_xor*/
    (binaryfunc)ubyte_or,                      /*nb_or*/
#if !defined(NPY_PY3K)
    0,                                          /*nb_coerce*/
#endif
    (unaryfunc)ubyte_int,                      /*nb_int*/
#if defined(NPY_PY3K)
    (unaryfunc)0,                               /*nb_reserved*/
#else
    (unaryfunc)ubyte_long,                     /*nb_long*/
#endif
    (unaryfunc)ubyte_float,                    /*nb_float*/
#if !defined(NPY_PY3K)
    (unaryfunc)ubyte_oct,                      /*nb_oct*/
    (unaryfunc)ubyte_hex,                      /*nb_hex*/
#endif
    0,                                          /*inplace_add*/
    0,                                          /*inplace_subtract*/
    0,                                          /*inplace_multiply*/
#if !defined(NPY_PY3K)
    0,                                          /*inplace_divide*/
#endif
    0,                                          /*inplace_remainder*/
    0,                                          /*inplace_power*/
    0,                                          /*inplace_lshift*/
    0,                                          /*inplace_rshift*/
    0,                                          /*inplace_and*/
    0,                                          /*inplace_xor*/
    0,                                          /*inplace_or*/
    (binaryfunc)ubyte_floor_divide,            /*nb_floor_divide*/
    (binaryfunc)ubyte_true_divide,             /*nb_true_divide*/
    0,                                          /*nb_inplace_floor_divide*/
    0,                                          /*nb_inplace_true_divide*/
    (unaryfunc)NULL,                            /*nb_index*/
#if PY_VERSION_HEX >= 0x03050000
    0,                                          /*nb_matrix_multiply*/
    0,                                          /*nb_inplace_matrix_multiply*/
#endif
};

#line 1573
static PyNumberMethods short_as_number = {
    (binaryfunc)short_add,                     /*nb_add*/
    (binaryfunc)short_subtract,                /*nb_subtract*/
    (binaryfunc)short_multiply,                /*nb_multiply*/
#if !defined(NPY_PY3K)
    (binaryfunc)short_divide,                  /*nb_divide*/
#endif
    (binaryfunc)short_remainder,               /*nb_remainder*/
    (binaryfunc)short_divmod,                  /*nb_divmod*/
    (ternaryfunc)short_power,                  /*nb_power*/
    (unaryfunc)short_negative,
    (unaryfunc)short_positive,                 /*nb_pos*/
    (unaryfunc)short_absolute,                 /*nb_abs*/
#if defined(NPY_PY3K)
    (inquiry)short_bool,                       /*nb_bool*/
#else
    (inquiry)short_nonzero,                    /*nb_nonzero*/
#endif
    (unaryfunc)short_invert,                   /*nb_invert*/
    (binaryfunc)short_lshift,                  /*nb_lshift*/
    (binaryfunc)short_rshift,                  /*nb_rshift*/
    (binaryfunc)short_and,                     /*nb_and*/
    (binaryfunc)short_xor,                     /*nb_xor*/
    (binaryfunc)short_or,                      /*nb_or*/
#if !defined(NPY_PY3K)
    0,                                          /*nb_coerce*/
#endif
    (unaryfunc)short_int,                      /*nb_int*/
#if defined(NPY_PY3K)
    (unaryfunc)0,                               /*nb_reserved*/
#else
    (unaryfunc)short_long,                     /*nb_long*/
#endif
    (unaryfunc)short_float,                    /*nb_float*/
#if !defined(NPY_PY3K)
    (unaryfunc)short_oct,                      /*nb_oct*/
    (unaryfunc)short_hex,                      /*nb_hex*/
#endif
    0,                                          /*inplace_add*/
    0,                                          /*inplace_subtract*/
    0,                                          /*inplace_multiply*/
#if !defined(NPY_PY3K)
    0,                                          /*inplace_divide*/
#endif
    0,                                          /*inplace_remainder*/
    0,                                          /*inplace_power*/
    0,                                          /*inplace_lshift*/
    0,                                          /*inplace_rshift*/
    0,                                          /*inplace_and*/
    0,                                          /*inplace_xor*/
    0,                                          /*inplace_or*/
    (binaryfunc)short_floor_divide,            /*nb_floor_divide*/
    (binaryfunc)short_true_divide,             /*nb_true_divide*/
    0,                                          /*nb_inplace_floor_divide*/
    0,                                          /*nb_inplace_true_divide*/
    (unaryfunc)NULL,                            /*nb_index*/
#if PY_VERSION_HEX >= 0x03050000
    0,                                          /*nb_matrix_multiply*/
    0,                                          /*nb_inplace_matrix_multiply*/
#endif
};

#line 1573
static PyNumberMethods ushort_as_number = {
    (binaryfunc)ushort_add,                     /*nb_add*/
    (binaryfunc)ushort_subtract,                /*nb_subtract*/
    (binaryfunc)ushort_multiply,                /*nb_multiply*/
#if !defined(NPY_PY3K)
    (binaryfunc)ushort_divide,                  /*nb_divide*/
#endif
    (binaryfunc)ushort_remainder,               /*nb_remainder*/
    (binaryfunc)ushort_divmod,                  /*nb_divmod*/
    (ternaryfunc)ushort_power,                  /*nb_power*/
    (unaryfunc)ushort_negative,
    (unaryfunc)ushort_positive,                 /*nb_pos*/
    (unaryfunc)ushort_absolute,                 /*nb_abs*/
#if defined(NPY_PY3K)
    (inquiry)ushort_bool,                       /*nb_bool*/
#else
    (inquiry)ushort_nonzero,                    /*nb_nonzero*/
#endif
    (unaryfunc)ushort_invert,                   /*nb_invert*/
    (binaryfunc)ushort_lshift,                  /*nb_lshift*/
    (binaryfunc)ushort_rshift,                  /*nb_rshift*/
    (binaryfunc)ushort_and,                     /*nb_and*/
    (binaryfunc)ushort_xor,                     /*nb_xor*/
    (binaryfunc)ushort_or,                      /*nb_or*/
#if !defined(NPY_PY3K)
    0,                                          /*nb_coerce*/
#endif
    (unaryfunc)ushort_int,                      /*nb_int*/
#if defined(NPY_PY3K)
    (unaryfunc)0,                               /*nb_reserved*/
#else
    (unaryfunc)ushort_long,                     /*nb_long*/
#endif
    (unaryfunc)ushort_float,                    /*nb_float*/
#if !defined(NPY_PY3K)
    (unaryfunc)ushort_oct,                      /*nb_oct*/
    (unaryfunc)ushort_hex,                      /*nb_hex*/
#endif
    0,                                          /*inplace_add*/
    0,                                          /*inplace_subtract*/
    0,                                          /*inplace_multiply*/
#if !defined(NPY_PY3K)
    0,                                          /*inplace_divide*/
#endif
    0,                                          /*inplace_remainder*/
    0,                                          /*inplace_power*/
    0,                                          /*inplace_lshift*/
    0,                                          /*inplace_rshift*/
    0,                                          /*inplace_and*/
    0,                                          /*inplace_xor*/
    0,                                          /*inplace_or*/
    (binaryfunc)ushort_floor_divide,            /*nb_floor_divide*/
    (binaryfunc)ushort_true_divide,             /*nb_true_divide*/
    0,                                          /*nb_inplace_floor_divide*/
    0,                                          /*nb_inplace_true_divide*/
    (unaryfunc)NULL,                            /*nb_index*/
#if PY_VERSION_HEX >= 0x03050000
    0,                                          /*nb_matrix_multiply*/
    0,                                          /*nb_inplace_matrix_multiply*/
#endif
};

#line 1573
static PyNumberMethods int_as_number = {
    (binaryfunc)int_add,                     /*nb_add*/
    (binaryfunc)int_subtract,                /*nb_subtract*/
    (binaryfunc)int_multiply,                /*nb_multiply*/
#if !defined(NPY_PY3K)
    (binaryfunc)int_divide,                  /*nb_divide*/
#endif
    (binaryfunc)int_remainder,               /*nb_remainder*/
    (binaryfunc)int_divmod,                  /*nb_divmod*/
    (ternaryfunc)int_power,                  /*nb_power*/
    (unaryfunc)int_negative,
    (unaryfunc)int_positive,                 /*nb_pos*/
    (unaryfunc)int_absolute,                 /*nb_abs*/
#if defined(NPY_PY3K)
    (inquiry)int_bool,                       /*nb_bool*/
#else
    (inquiry)int_nonzero,                    /*nb_nonzero*/
#endif
    (unaryfunc)int_invert,                   /*nb_invert*/
    (binaryfunc)int_lshift,                  /*nb_lshift*/
    (binaryfunc)int_rshift,                  /*nb_rshift*/
    (binaryfunc)int_and,                     /*nb_and*/
    (binaryfunc)int_xor,                     /*nb_xor*/
    (binaryfunc)int_or,                      /*nb_or*/
#if !defined(NPY_PY3K)
    0,                                          /*nb_coerce*/
#endif
    (unaryfunc)int_int,                      /*nb_int*/
#if defined(NPY_PY3K)
    (unaryfunc)0,                               /*nb_reserved*/
#else
    (unaryfunc)int_long,                     /*nb_long*/
#endif
    (unaryfunc)int_float,                    /*nb_float*/
#if !defined(NPY_PY3K)
    (unaryfunc)int_oct,                      /*nb_oct*/
    (unaryfunc)int_hex,                      /*nb_hex*/
#endif
    0,                                          /*inplace_add*/
    0,                                          /*inplace_subtract*/
    0,                                          /*inplace_multiply*/
#if !defined(NPY_PY3K)
    0,                                          /*inplace_divide*/
#endif
    0,                                          /*inplace_remainder*/
    0,                                          /*inplace_power*/
    0,                                          /*inplace_lshift*/
    0,                                          /*inplace_rshift*/
    0,                                          /*inplace_and*/
    0,                                          /*inplace_xor*/
    0,                                          /*inplace_or*/
    (binaryfunc)int_floor_divide,            /*nb_floor_divide*/
    (binaryfunc)int_true_divide,             /*nb_true_divide*/
    0,                                          /*nb_inplace_floor_divide*/
    0,                                          /*nb_inplace_true_divide*/
    (unaryfunc)NULL,                            /*nb_index*/
#if PY_VERSION_HEX >= 0x03050000
    0,                                          /*nb_matrix_multiply*/
    0,                                          /*nb_inplace_matrix_multiply*/
#endif
};

#line 1573
static PyNumberMethods uint_as_number = {
    (binaryfunc)uint_add,                     /*nb_add*/
    (binaryfunc)uint_subtract,                /*nb_subtract*/
    (binaryfunc)uint_multiply,                /*nb_multiply*/
#if !defined(NPY_PY3K)
    (binaryfunc)uint_divide,                  /*nb_divide*/
#endif
    (binaryfunc)uint_remainder,               /*nb_remainder*/
    (binaryfunc)uint_divmod,                  /*nb_divmod*/
    (ternaryfunc)uint_power,                  /*nb_power*/
    (unaryfunc)uint_negative,
    (unaryfunc)uint_positive,                 /*nb_pos*/
    (unaryfunc)uint_absolute,                 /*nb_abs*/
#if defined(NPY_PY3K)
    (inquiry)uint_bool,                       /*nb_bool*/
#else
    (inquiry)uint_nonzero,                    /*nb_nonzero*/
#endif
    (unaryfunc)uint_invert,                   /*nb_invert*/
    (binaryfunc)uint_lshift,                  /*nb_lshift*/
    (binaryfunc)uint_rshift,                  /*nb_rshift*/
    (binaryfunc)uint_and,                     /*nb_and*/
    (binaryfunc)uint_xor,                     /*nb_xor*/
    (binaryfunc)uint_or,                      /*nb_or*/
#if !defined(NPY_PY3K)
    0,                                          /*nb_coerce*/
#endif
    (unaryfunc)uint_int,                      /*nb_int*/
#if defined(NPY_PY3K)
    (unaryfunc)0,                               /*nb_reserved*/
#else
    (unaryfunc)uint_long,                     /*nb_long*/
#endif
    (unaryfunc)uint_float,                    /*nb_float*/
#if !defined(NPY_PY3K)
    (unaryfunc)uint_oct,                      /*nb_oct*/
    (unaryfunc)uint_hex,                      /*nb_hex*/
#endif
    0,                                          /*inplace_add*/
    0,                                          /*inplace_subtract*/
    0,                                          /*inplace_multiply*/
#if !defined(NPY_PY3K)
    0,                                          /*inplace_divide*/
#endif
    0,                                          /*inplace_remainder*/
    0,                                          /*inplace_power*/
    0,                                          /*inplace_lshift*/
    0,                                          /*inplace_rshift*/
    0,                                          /*inplace_and*/
    0,                                          /*inplace_xor*/
    0,                                          /*inplace_or*/
    (binaryfunc)uint_floor_divide,            /*nb_floor_divide*/
    (binaryfunc)uint_true_divide,             /*nb_true_divide*/
    0,                                          /*nb_inplace_floor_divide*/
    0,                                          /*nb_inplace_true_divide*/
    (unaryfunc)NULL,                            /*nb_index*/
#if PY_VERSION_HEX >= 0x03050000
    0,                                          /*nb_matrix_multiply*/
    0,                                          /*nb_inplace_matrix_multiply*/
#endif
};

#line 1573
static PyNumberMethods long_as_number = {
    (binaryfunc)long_add,                     /*nb_add*/
    (binaryfunc)long_subtract,                /*nb_subtract*/
    (binaryfunc)long_multiply,                /*nb_multiply*/
#if !defined(NPY_PY3K)
    (binaryfunc)long_divide,                  /*nb_divide*/
#endif
    (binaryfunc)long_remainder,               /*nb_remainder*/
    (binaryfunc)long_divmod,                  /*nb_divmod*/
    (ternaryfunc)long_power,                  /*nb_power*/
    (unaryfunc)long_negative,
    (unaryfunc)long_positive,                 /*nb_pos*/
    (unaryfunc)long_absolute,                 /*nb_abs*/
#if defined(NPY_PY3K)
    (inquiry)long_bool,                       /*nb_bool*/
#else
    (inquiry)long_nonzero,                    /*nb_nonzero*/
#endif
    (unaryfunc)long_invert,                   /*nb_invert*/
    (binaryfunc)long_lshift,                  /*nb_lshift*/
    (binaryfunc)long_rshift,                  /*nb_rshift*/
    (binaryfunc)long_and,                     /*nb_and*/
    (binaryfunc)long_xor,                     /*nb_xor*/
    (binaryfunc)long_or,                      /*nb_or*/
#if !defined(NPY_PY3K)
    0,                                          /*nb_coerce*/
#endif
    (unaryfunc)long_int,                      /*nb_int*/
#if defined(NPY_PY3K)
    (unaryfunc)0,                               /*nb_reserved*/
#else
    (unaryfunc)long_long,                     /*nb_long*/
#endif
    (unaryfunc)long_float,                    /*nb_float*/
#if !defined(NPY_PY3K)
    (unaryfunc)long_oct,                      /*nb_oct*/
    (unaryfunc)long_hex,                      /*nb_hex*/
#endif
    0,                                          /*inplace_add*/
    0,                                          /*inplace_subtract*/
    0,                                          /*inplace_multiply*/
#if !defined(NPY_PY3K)
    0,                                          /*inplace_divide*/
#endif
    0,                                          /*inplace_remainder*/
    0,                                          /*inplace_power*/
    0,                                          /*inplace_lshift*/
    0,                                          /*inplace_rshift*/
    0,                                          /*inplace_and*/
    0,                                          /*inplace_xor*/
    0,                                          /*inplace_or*/
    (binaryfunc)long_floor_divide,            /*nb_floor_divide*/
    (binaryfunc)long_true_divide,             /*nb_true_divide*/
    0,                                          /*nb_inplace_floor_divide*/
    0,                                          /*nb_inplace_true_divide*/
    (unaryfunc)NULL,                            /*nb_index*/
#if PY_VERSION_HEX >= 0x03050000
    0,                                          /*nb_matrix_multiply*/
    0,                                          /*nb_inplace_matrix_multiply*/
#endif
};

#line 1573
static PyNumberMethods ulong_as_number = {
    (binaryfunc)ulong_add,                     /*nb_add*/
    (binaryfunc)ulong_subtract,                /*nb_subtract*/
    (binaryfunc)ulong_multiply,                /*nb_multiply*/
#if !defined(NPY_PY3K)
    (binaryfunc)ulong_divide,                  /*nb_divide*/
#endif
    (binaryfunc)ulong_remainder,               /*nb_remainder*/
    (binaryfunc)ulong_divmod,                  /*nb_divmod*/
    (ternaryfunc)ulong_power,                  /*nb_power*/
    (unaryfunc)ulong_negative,
    (unaryfunc)ulong_positive,                 /*nb_pos*/
    (unaryfunc)ulong_absolute,                 /*nb_abs*/
#if defined(NPY_PY3K)
    (inquiry)ulong_bool,                       /*nb_bool*/
#else
    (inquiry)ulong_nonzero,                    /*nb_nonzero*/
#endif
    (unaryfunc)ulong_invert,                   /*nb_invert*/
    (binaryfunc)ulong_lshift,                  /*nb_lshift*/
    (binaryfunc)ulong_rshift,                  /*nb_rshift*/
    (binaryfunc)ulong_and,                     /*nb_and*/
    (binaryfunc)ulong_xor,                     /*nb_xor*/
    (binaryfunc)ulong_or,                      /*nb_or*/
#if !defined(NPY_PY3K)
    0,                                          /*nb_coerce*/
#endif
    (unaryfunc)ulong_int,                      /*nb_int*/
#if defined(NPY_PY3K)
    (unaryfunc)0,                               /*nb_reserved*/
#else
    (unaryfunc)ulong_long,                     /*nb_long*/
#endif
    (unaryfunc)ulong_float,                    /*nb_float*/
#if !defined(NPY_PY3K)
    (unaryfunc)ulong_oct,                      /*nb_oct*/
    (unaryfunc)ulong_hex,                      /*nb_hex*/
#endif
    0,                                          /*inplace_add*/
    0,                                          /*inplace_subtract*/
    0,                                          /*inplace_multiply*/
#if !defined(NPY_PY3K)
    0,                                          /*inplace_divide*/
#endif
    0,                                          /*inplace_remainder*/
    0,                                          /*inplace_power*/
    0,                                          /*inplace_lshift*/
    0,                                          /*inplace_rshift*/
    0,                                          /*inplace_and*/
    0,                                          /*inplace_xor*/
    0,                                          /*inplace_or*/
    (binaryfunc)ulong_floor_divide,            /*nb_floor_divide*/
    (binaryfunc)ulong_true_divide,             /*nb_true_divide*/
    0,                                          /*nb_inplace_floor_divide*/
    0,                                          /*nb_inplace_true_divide*/
    (unaryfunc)NULL,                            /*nb_index*/
#if PY_VERSION_HEX >= 0x03050000
    0,                                          /*nb_matrix_multiply*/
    0,                                          /*nb_inplace_matrix_multiply*/
#endif
};

#line 1573
static PyNumberMethods longlong_as_number = {
    (binaryfunc)longlong_add,                     /*nb_add*/
    (binaryfunc)longlong_subtract,                /*nb_subtract*/
    (binaryfunc)longlong_multiply,                /*nb_multiply*/
#if !defined(NPY_PY3K)
    (binaryfunc)longlong_divide,                  /*nb_divide*/
#endif
    (binaryfunc)longlong_remainder,               /*nb_remainder*/
    (binaryfunc)longlong_divmod,                  /*nb_divmod*/
    (ternaryfunc)longlong_power,                  /*nb_power*/
    (unaryfunc)longlong_negative,
    (unaryfunc)longlong_positive,                 /*nb_pos*/
    (unaryfunc)longlong_absolute,                 /*nb_abs*/
#if defined(NPY_PY3K)
    (inquiry)longlong_bool,                       /*nb_bool*/
#else
    (inquiry)longlong_nonzero,                    /*nb_nonzero*/
#endif
    (unaryfunc)longlong_invert,                   /*nb_invert*/
    (binaryfunc)longlong_lshift,                  /*nb_lshift*/
    (binaryfunc)longlong_rshift,                  /*nb_rshift*/
    (binaryfunc)longlong_and,                     /*nb_and*/
    (binaryfunc)longlong_xor,                     /*nb_xor*/
    (binaryfunc)longlong_or,                      /*nb_or*/
#if !defined(NPY_PY3K)
    0,                                          /*nb_coerce*/
#endif
    (unaryfunc)longlong_int,                      /*nb_int*/
#if defined(NPY_PY3K)
    (unaryfunc)0,                               /*nb_reserved*/
#else
    (unaryfunc)longlong_long,                     /*nb_long*/
#endif
    (unaryfunc)longlong_float,                    /*nb_float*/
#if !defined(NPY_PY3K)
    (unaryfunc)longlong_oct,                      /*nb_oct*/
    (unaryfunc)longlong_hex,                      /*nb_hex*/
#endif
    0,                                          /*inplace_add*/
    0,                                          /*inplace_subtract*/
    0,                                          /*inplace_multiply*/
#if !defined(NPY_PY3K)
    0,                                          /*inplace_divide*/
#endif
    0,                                          /*inplace_remainder*/
    0,                                          /*inplace_power*/
    0,                                          /*inplace_lshift*/
    0,                                          /*inplace_rshift*/
    0,                                          /*inplace_and*/
    0,                                          /*inplace_xor*/
    0,                                          /*inplace_or*/
    (binaryfunc)longlong_floor_divide,            /*nb_floor_divide*/
    (binaryfunc)longlong_true_divide,             /*nb_true_divide*/
    0,                                          /*nb_inplace_floor_divide*/
    0,                                          /*nb_inplace_true_divide*/
    (unaryfunc)NULL,                            /*nb_index*/
#if PY_VERSION_HEX >= 0x03050000
    0,                                          /*nb_matrix_multiply*/
    0,                                          /*nb_inplace_matrix_multiply*/
#endif
};

#line 1573
static PyNumberMethods ulonglong_as_number = {
    (binaryfunc)ulonglong_add,                     /*nb_add*/
    (binaryfunc)ulonglong_subtract,                /*nb_subtract*/
    (binaryfunc)ulonglong_multiply,                /*nb_multiply*/
#if !defined(NPY_PY3K)
    (binaryfunc)ulonglong_divide,                  /*nb_divide*/
#endif
    (binaryfunc)ulonglong_remainder,               /*nb_remainder*/
    (binaryfunc)ulonglong_divmod,                  /*nb_divmod*/
    (ternaryfunc)ulonglong_power,                  /*nb_power*/
    (unaryfunc)ulonglong_negative,
    (unaryfunc)ulonglong_positive,                 /*nb_pos*/
    (unaryfunc)ulonglong_absolute,                 /*nb_abs*/
#if defined(NPY_PY3K)
    (inquiry)ulonglong_bool,                       /*nb_bool*/
#else
    (inquiry)ulonglong_nonzero,                    /*nb_nonzero*/
#endif
    (unaryfunc)ulonglong_invert,                   /*nb_invert*/
    (binaryfunc)ulonglong_lshift,                  /*nb_lshift*/
    (binaryfunc)ulonglong_rshift,                  /*nb_rshift*/
    (binaryfunc)ulonglong_and,                     /*nb_and*/
    (binaryfunc)ulonglong_xor,                     /*nb_xor*/
    (binaryfunc)ulonglong_or,                      /*nb_or*/
#if !defined(NPY_PY3K)
    0,                                          /*nb_coerce*/
#endif
    (unaryfunc)ulonglong_int,                      /*nb_int*/
#if defined(NPY_PY3K)
    (unaryfunc)0,                               /*nb_reserved*/
#else
    (unaryfunc)ulonglong_long,                     /*nb_long*/
#endif
    (unaryfunc)ulonglong_float,                    /*nb_float*/
#if !defined(NPY_PY3K)
    (unaryfunc)ulonglong_oct,                      /*nb_oct*/
    (unaryfunc)ulonglong_hex,                      /*nb_hex*/
#endif
    0,                                          /*inplace_add*/
    0,                                          /*inplace_subtract*/
    0,                                          /*inplace_multiply*/
#if !defined(NPY_PY3K)
    0,                                          /*inplace_divide*/
#endif
    0,                                          /*inplace_remainder*/
    0,                                          /*inplace_power*/
    0,                                          /*inplace_lshift*/
    0,                                          /*inplace_rshift*/
    0,                                          /*inplace_and*/
    0,                                          /*inplace_xor*/
    0,                                          /*inplace_or*/
    (binaryfunc)ulonglong_floor_divide,            /*nb_floor_divide*/
    (binaryfunc)ulonglong_true_divide,             /*nb_true_divide*/
    0,                                          /*nb_inplace_floor_divide*/
    0,                                          /*nb_inplace_true_divide*/
    (unaryfunc)NULL,                            /*nb_index*/
#if PY_VERSION_HEX >= 0x03050000
    0,                                          /*nb_matrix_multiply*/
    0,                                          /*nb_inplace_matrix_multiply*/
#endif
};

#line 1573
static PyNumberMethods half_as_number = {
    (binaryfunc)half_add,                     /*nb_add*/
    (binaryfunc)half_subtract,                /*nb_subtract*/
    (binaryfunc)half_multiply,                /*nb_multiply*/
#if !defined(NPY_PY3K)
    (binaryfunc)half_divide,                  /*nb_divide*/
#endif
    (binaryfunc)half_remainder,               /*nb_remainder*/
    (binaryfunc)half_divmod,                  /*nb_divmod*/
    (ternaryfunc)half_power,                  /*nb_power*/
    (unaryfunc)half_negative,
    (unaryfunc)half_positive,                 /*nb_pos*/
    (unaryfunc)half_absolute,                 /*nb_abs*/
#if defined(NPY_PY3K)
    (inquiry)half_bool,                       /*nb_bool*/
#else
    (inquiry)half_nonzero,                    /*nb_nonzero*/
#endif
    (unaryfunc)half_invert,                   /*nb_invert*/
    (binaryfunc)half_lshift,                  /*nb_lshift*/
    (binaryfunc)half_rshift,                  /*nb_rshift*/
    (binaryfunc)half_and,                     /*nb_and*/
    (binaryfunc)half_xor,                     /*nb_xor*/
    (binaryfunc)half_or,                      /*nb_or*/
#if !defined(NPY_PY3K)
    0,                                          /*nb_coerce*/
#endif
    (unaryfunc)half_int,                      /*nb_int*/
#if defined(NPY_PY3K)
    (unaryfunc)0,                               /*nb_reserved*/
#else
    (unaryfunc)half_long,                     /*nb_long*/
#endif
    (unaryfunc)half_float,                    /*nb_float*/
#if !defined(NPY_PY3K)
    (unaryfunc)half_oct,                      /*nb_oct*/
    (unaryfunc)half_hex,                      /*nb_hex*/
#endif
    0,                                          /*inplace_add*/
    0,                                          /*inplace_subtract*/
    0,                                          /*inplace_multiply*/
#if !defined(NPY_PY3K)
    0,                                          /*inplace_divide*/
#endif
    0,                                          /*inplace_remainder*/
    0,                                          /*inplace_power*/
    0,                                          /*inplace_lshift*/
    0,                                          /*inplace_rshift*/
    0,                                          /*inplace_and*/
    0,                                          /*inplace_xor*/
    0,                                          /*inplace_or*/
    (binaryfunc)half_floor_divide,            /*nb_floor_divide*/
    (binaryfunc)half_true_divide,             /*nb_true_divide*/
    0,                                          /*nb_inplace_floor_divide*/
    0,                                          /*nb_inplace_true_divide*/
    (unaryfunc)NULL,                            /*nb_index*/
#if PY_VERSION_HEX >= 0x03050000
    0,                                          /*nb_matrix_multiply*/
    0,                                          /*nb_inplace_matrix_multiply*/
#endif
};

#line 1573
static PyNumberMethods float_as_number = {
    (binaryfunc)float_add,                     /*nb_add*/
    (binaryfunc)float_subtract,                /*nb_subtract*/
    (binaryfunc)float_multiply,                /*nb_multiply*/
#if !defined(NPY_PY3K)
    (binaryfunc)float_divide,                  /*nb_divide*/
#endif
    (binaryfunc)float_remainder,               /*nb_remainder*/
    (binaryfunc)float_divmod,                  /*nb_divmod*/
    (ternaryfunc)float_power,                  /*nb_power*/
    (unaryfunc)float_negative,
    (unaryfunc)float_positive,                 /*nb_pos*/
    (unaryfunc)float_absolute,                 /*nb_abs*/
#if defined(NPY_PY3K)
    (inquiry)float_bool,                       /*nb_bool*/
#else
    (inquiry)float_nonzero,                    /*nb_nonzero*/
#endif
    (unaryfunc)float_invert,                   /*nb_invert*/
    (binaryfunc)float_lshift,                  /*nb_lshift*/
    (binaryfunc)float_rshift,                  /*nb_rshift*/
    (binaryfunc)float_and,                     /*nb_and*/
    (binaryfunc)float_xor,                     /*nb_xor*/
    (binaryfunc)float_or,                      /*nb_or*/
#if !defined(NPY_PY3K)
    0,                                          /*nb_coerce*/
#endif
    (unaryfunc)float_int,                      /*nb_int*/
#if defined(NPY_PY3K)
    (unaryfunc)0,                               /*nb_reserved*/
#else
    (unaryfunc)float_long,                     /*nb_long*/
#endif
    (unaryfunc)float_float,                    /*nb_float*/
#if !defined(NPY_PY3K)
    (unaryfunc)float_oct,                      /*nb_oct*/
    (unaryfunc)float_hex,                      /*nb_hex*/
#endif
    0,                                          /*inplace_add*/
    0,                                          /*inplace_subtract*/
    0,                                          /*inplace_multiply*/
#if !defined(NPY_PY3K)
    0,                                          /*inplace_divide*/
#endif
    0,                                          /*inplace_remainder*/
    0,                                          /*inplace_power*/
    0,                                          /*inplace_lshift*/
    0,                                          /*inplace_rshift*/
    0,                                          /*inplace_and*/
    0,                                          /*inplace_xor*/
    0,                                          /*inplace_or*/
    (binaryfunc)float_floor_divide,            /*nb_floor_divide*/
    (binaryfunc)float_true_divide,             /*nb_true_divide*/
    0,                                          /*nb_inplace_floor_divide*/
    0,                                          /*nb_inplace_true_divide*/
    (unaryfunc)NULL,                            /*nb_index*/
#if PY_VERSION_HEX >= 0x03050000
    0,                                          /*nb_matrix_multiply*/
    0,                                          /*nb_inplace_matrix_multiply*/
#endif
};

#line 1573
static PyNumberMethods double_as_number = {
    (binaryfunc)double_add,                     /*nb_add*/
    (binaryfunc)double_subtract,                /*nb_subtract*/
    (binaryfunc)double_multiply,                /*nb_multiply*/
#if !defined(NPY_PY3K)
    (binaryfunc)double_divide,                  /*nb_divide*/
#endif
    (binaryfunc)double_remainder,               /*nb_remainder*/
    (binaryfunc)double_divmod,                  /*nb_divmod*/
    (ternaryfunc)double_power,                  /*nb_power*/
    (unaryfunc)double_negative,
    (unaryfunc)double_positive,                 /*nb_pos*/
    (unaryfunc)double_absolute,                 /*nb_abs*/
#if defined(NPY_PY3K)
    (inquiry)double_bool,                       /*nb_bool*/
#else
    (inquiry)double_nonzero,                    /*nb_nonzero*/
#endif
    (unaryfunc)double_invert,                   /*nb_invert*/
    (binaryfunc)double_lshift,                  /*nb_lshift*/
    (binaryfunc)double_rshift,                  /*nb_rshift*/
    (binaryfunc)double_and,                     /*nb_and*/
    (binaryfunc)double_xor,                     /*nb_xor*/
    (binaryfunc)double_or,                      /*nb_or*/
#if !defined(NPY_PY3K)
    0,                                          /*nb_coerce*/
#endif
    (unaryfunc)double_int,                      /*nb_int*/
#if defined(NPY_PY3K)
    (unaryfunc)0,                               /*nb_reserved*/
#else
    (unaryfunc)double_long,                     /*nb_long*/
#endif
    (unaryfunc)double_float,                    /*nb_float*/
#if !defined(NPY_PY3K)
    (unaryfunc)double_oct,                      /*nb_oct*/
    (unaryfunc)double_hex,                      /*nb_hex*/
#endif
    0,                                          /*inplace_add*/
    0,                                          /*inplace_subtract*/
    0,                                          /*inplace_multiply*/
#if !defined(NPY_PY3K)
    0,                                          /*inplace_divide*/
#endif
    0,                                          /*inplace_remainder*/
    0,                                          /*inplace_power*/
    0,                                          /*inplace_lshift*/
    0,                                          /*inplace_rshift*/
    0,                                          /*inplace_and*/
    0,                                          /*inplace_xor*/
    0,                                          /*inplace_or*/
    (binaryfunc)double_floor_divide,            /*nb_floor_divide*/
    (binaryfunc)double_true_divide,             /*nb_true_divide*/
    0,                                          /*nb_inplace_floor_divide*/
    0,                                          /*nb_inplace_true_divide*/
    (unaryfunc)NULL,                            /*nb_index*/
#if PY_VERSION_HEX >= 0x03050000
    0,                                          /*nb_matrix_multiply*/
    0,                                          /*nb_inplace_matrix_multiply*/
#endif
};

#line 1573
static PyNumberMethods longdouble_as_number = {
    (binaryfunc)longdouble_add,                     /*nb_add*/
    (binaryfunc)longdouble_subtract,                /*nb_subtract*/
    (binaryfunc)longdouble_multiply,                /*nb_multiply*/
#if !defined(NPY_PY3K)
    (binaryfunc)longdouble_divide,                  /*nb_divide*/
#endif
    (binaryfunc)longdouble_remainder,               /*nb_remainder*/
    (binaryfunc)longdouble_divmod,                  /*nb_divmod*/
    (ternaryfunc)longdouble_power,                  /*nb_power*/
    (unaryfunc)longdouble_negative,
    (unaryfunc)longdouble_positive,                 /*nb_pos*/
    (unaryfunc)longdouble_absolute,                 /*nb_abs*/
#if defined(NPY_PY3K)
    (inquiry)longdouble_bool,                       /*nb_bool*/
#else
    (inquiry)longdouble_nonzero,                    /*nb_nonzero*/
#endif
    (unaryfunc)longdouble_invert,                   /*nb_invert*/
    (binaryfunc)longdouble_lshift,                  /*nb_lshift*/
    (binaryfunc)longdouble_rshift,                  /*nb_rshift*/
    (binaryfunc)longdouble_and,                     /*nb_and*/
    (binaryfunc)longdouble_xor,                     /*nb_xor*/
    (binaryfunc)longdouble_or,                      /*nb_or*/
#if !defined(NPY_PY3K)
    0,                                          /*nb_coerce*/
#endif
    (unaryfunc)longdouble_int,                      /*nb_int*/
#if defined(NPY_PY3K)
    (unaryfunc)0,                               /*nb_reserved*/
#else
    (unaryfunc)longdouble_long,                     /*nb_long*/
#endif
    (unaryfunc)longdouble_float,                    /*nb_float*/
#if !defined(NPY_PY3K)
    (unaryfunc)longdouble_oct,                      /*nb_oct*/
    (unaryfunc)longdouble_hex,                      /*nb_hex*/
#endif
    0,                                          /*inplace_add*/
    0,                                          /*inplace_subtract*/
    0,                                          /*inplace_multiply*/
#if !defined(NPY_PY3K)
    0,                                          /*inplace_divide*/
#endif
    0,                                          /*inplace_remainder*/
    0,                                          /*inplace_power*/
    0,                                          /*inplace_lshift*/
    0,                                          /*inplace_rshift*/
    0,                                          /*inplace_and*/
    0,                                          /*inplace_xor*/
    0,                                          /*inplace_or*/
    (binaryfunc)longdouble_floor_divide,            /*nb_floor_divide*/
    (binaryfunc)longdouble_true_divide,             /*nb_true_divide*/
    0,                                          /*nb_inplace_floor_divide*/
    0,                                          /*nb_inplace_true_divide*/
    (unaryfunc)NULL,                            /*nb_index*/
#if PY_VERSION_HEX >= 0x03050000
    0,                                          /*nb_matrix_multiply*/
    0,                                          /*nb_inplace_matrix_multiply*/
#endif
};

#line 1573
static PyNumberMethods cfloat_as_number = {
    (binaryfunc)cfloat_add,                     /*nb_add*/
    (binaryfunc)cfloat_subtract,                /*nb_subtract*/
    (binaryfunc)cfloat_multiply,                /*nb_multiply*/
#if !defined(NPY_PY3K)
    (binaryfunc)cfloat_divide,                  /*nb_divide*/
#endif
    (binaryfunc)cfloat_remainder,               /*nb_remainder*/
    (binaryfunc)cfloat_divmod,                  /*nb_divmod*/
    (ternaryfunc)cfloat_power,                  /*nb_power*/
    (unaryfunc)cfloat_negative,
    (unaryfunc)cfloat_positive,                 /*nb_pos*/
    (unaryfunc)cfloat_absolute,                 /*nb_abs*/
#if defined(NPY_PY3K)
    (inquiry)cfloat_bool,                       /*nb_bool*/
#else
    (inquiry)cfloat_nonzero,                    /*nb_nonzero*/
#endif
    (unaryfunc)cfloat_invert,                   /*nb_invert*/
    (binaryfunc)cfloat_lshift,                  /*nb_lshift*/
    (binaryfunc)cfloat_rshift,                  /*nb_rshift*/
    (binaryfunc)cfloat_and,                     /*nb_and*/
    (binaryfunc)cfloat_xor,                     /*nb_xor*/
    (binaryfunc)cfloat_or,                      /*nb_or*/
#if !defined(NPY_PY3K)
    0,                                          /*nb_coerce*/
#endif
    (unaryfunc)cfloat_int,                      /*nb_int*/
#if defined(NPY_PY3K)
    (unaryfunc)0,                               /*nb_reserved*/
#else
    (unaryfunc)cfloat_long,                     /*nb_long*/
#endif
    (unaryfunc)cfloat_float,                    /*nb_float*/
#if !defined(NPY_PY3K)
    (unaryfunc)cfloat_oct,                      /*nb_oct*/
    (unaryfunc)cfloat_hex,                      /*nb_hex*/
#endif
    0,                                          /*inplace_add*/
    0,                                          /*inplace_subtract*/
    0,                                          /*inplace_multiply*/
#if !defined(NPY_PY3K)
    0,                                          /*inplace_divide*/
#endif
    0,                                          /*inplace_remainder*/
    0,                                          /*inplace_power*/
    0,                                          /*inplace_lshift*/
    0,                                          /*inplace_rshift*/
    0,                                          /*inplace_and*/
    0,                                          /*inplace_xor*/
    0,                                          /*inplace_or*/
    (binaryfunc)cfloat_floor_divide,            /*nb_floor_divide*/
    (binaryfunc)cfloat_true_divide,             /*nb_true_divide*/
    0,                                          /*nb_inplace_floor_divide*/
    0,                                          /*nb_inplace_true_divide*/
    (unaryfunc)NULL,                            /*nb_index*/
#if PY_VERSION_HEX >= 0x03050000
    0,                                          /*nb_matrix_multiply*/
    0,                                          /*nb_inplace_matrix_multiply*/
#endif
};

#line 1573
static PyNumberMethods cdouble_as_number = {
    (binaryfunc)cdouble_add,                     /*nb_add*/
    (binaryfunc)cdouble_subtract,                /*nb_subtract*/
    (binaryfunc)cdouble_multiply,                /*nb_multiply*/
#if !defined(NPY_PY3K)
    (binaryfunc)cdouble_divide,                  /*nb_divide*/
#endif
    (binaryfunc)cdouble_remainder,               /*nb_remainder*/
    (binaryfunc)cdouble_divmod,                  /*nb_divmod*/
    (ternaryfunc)cdouble_power,                  /*nb_power*/
    (unaryfunc)cdouble_negative,
    (unaryfunc)cdouble_positive,                 /*nb_pos*/
    (unaryfunc)cdouble_absolute,                 /*nb_abs*/
#if defined(NPY_PY3K)
    (inquiry)cdouble_bool,                       /*nb_bool*/
#else
    (inquiry)cdouble_nonzero,                    /*nb_nonzero*/
#endif
    (unaryfunc)cdouble_invert,                   /*nb_invert*/
    (binaryfunc)cdouble_lshift,                  /*nb_lshift*/
    (binaryfunc)cdouble_rshift,                  /*nb_rshift*/
    (binaryfunc)cdouble_and,                     /*nb_and*/
    (binaryfunc)cdouble_xor,                     /*nb_xor*/
    (binaryfunc)cdouble_or,                      /*nb_or*/
#if !defined(NPY_PY3K)
    0,                                          /*nb_coerce*/
#endif
    (unaryfunc)cdouble_int,                      /*nb_int*/
#if defined(NPY_PY3K)
    (unaryfunc)0,                               /*nb_reserved*/
#else
    (unaryfunc)cdouble_long,                     /*nb_long*/
#endif
    (unaryfunc)cdouble_float,                    /*nb_float*/
#if !defined(NPY_PY3K)
    (unaryfunc)cdouble_oct,                      /*nb_oct*/
    (unaryfunc)cdouble_hex,                      /*nb_hex*/
#endif
    0,                                          /*inplace_add*/
    0,                                          /*inplace_subtract*/
    0,                                          /*inplace_multiply*/
#if !defined(NPY_PY3K)
    0,                                          /*inplace_divide*/
#endif
    0,                                          /*inplace_remainder*/
    0,                                          /*inplace_power*/
    0,                                          /*inplace_lshift*/
    0,                                          /*inplace_rshift*/
    0,                                          /*inplace_and*/
    0,                                          /*inplace_xor*/
    0,                                          /*inplace_or*/
    (binaryfunc)cdouble_floor_divide,            /*nb_floor_divide*/
    (binaryfunc)cdouble_true_divide,             /*nb_true_divide*/
    0,                                          /*nb_inplace_floor_divide*/
    0,                                          /*nb_inplace_true_divide*/
    (unaryfunc)NULL,                            /*nb_index*/
#if PY_VERSION_HEX >= 0x03050000
    0,                                          /*nb_matrix_multiply*/
    0,                                          /*nb_inplace_matrix_multiply*/
#endif
};

#line 1573
static PyNumberMethods clongdouble_as_number = {
    (binaryfunc)clongdouble_add,                     /*nb_add*/
    (binaryfunc)clongdouble_subtract,                /*nb_subtract*/
    (binaryfunc)clongdouble_multiply,                /*nb_multiply*/
#if !defined(NPY_PY3K)
    (binaryfunc)clongdouble_divide,                  /*nb_divide*/
#endif
    (binaryfunc)clongdouble_remainder,               /*nb_remainder*/
    (binaryfunc)clongdouble_divmod,                  /*nb_divmod*/
    (ternaryfunc)clongdouble_power,                  /*nb_power*/
    (unaryfunc)clongdouble_negative,
    (unaryfunc)clongdouble_positive,                 /*nb_pos*/
    (unaryfunc)clongdouble_absolute,                 /*nb_abs*/
#if defined(NPY_PY3K)
    (inquiry)clongdouble_bool,                       /*nb_bool*/
#else
    (inquiry)clongdouble_nonzero,                    /*nb_nonzero*/
#endif
    (unaryfunc)clongdouble_invert,                   /*nb_invert*/
    (binaryfunc)clongdouble_lshift,                  /*nb_lshift*/
    (binaryfunc)clongdouble_rshift,                  /*nb_rshift*/
    (binaryfunc)clongdouble_and,                     /*nb_and*/
    (binaryfunc)clongdouble_xor,                     /*nb_xor*/
    (binaryfunc)clongdouble_or,                      /*nb_or*/
#if !defined(NPY_PY3K)
    0,                                          /*nb_coerce*/
#endif
    (unaryfunc)clongdouble_int,                      /*nb_int*/
#if defined(NPY_PY3K)
    (unaryfunc)0,                               /*nb_reserved*/
#else
    (unaryfunc)clongdouble_long,                     /*nb_long*/
#endif
    (unaryfunc)clongdouble_float,                    /*nb_float*/
#if !defined(NPY_PY3K)
    (unaryfunc)clongdouble_oct,                      /*nb_oct*/
    (unaryfunc)clongdouble_hex,                      /*nb_hex*/
#endif
    0,                                          /*inplace_add*/
    0,                                          /*inplace_subtract*/
    0,                                          /*inplace_multiply*/
#if !defined(NPY_PY3K)
    0,                                          /*inplace_divide*/
#endif
    0,                                          /*inplace_remainder*/
    0,                                          /*inplace_power*/
    0,                                          /*inplace_lshift*/
    0,                                          /*inplace_rshift*/
    0,                                          /*inplace_and*/
    0,                                          /*inplace_xor*/
    0,                                          /*inplace_or*/
    (binaryfunc)clongdouble_floor_divide,            /*nb_floor_divide*/
    (binaryfunc)clongdouble_true_divide,             /*nb_true_divide*/
    0,                                          /*nb_inplace_floor_divide*/
    0,                                          /*nb_inplace_true_divide*/
    (unaryfunc)NULL,                            /*nb_index*/
#if PY_VERSION_HEX >= 0x03050000
    0,                                          /*nb_matrix_multiply*/
    0,                                          /*nb_inplace_matrix_multiply*/
#endif
};


NPY_NO_EXPORT void
add_scalarmath(void)
{
    #line 1649
    byte_as_number.nb_index = PyByteArrType_Type.tp_as_number->nb_index;
    PyByteArrType_Type.tp_as_number = &(byte_as_number);
    PyByteArrType_Type.tp_richcompare = byte_richcompare;
    
#line 1649
    ubyte_as_number.nb_index = PyUByteArrType_Type.tp_as_number->nb_index;
    PyUByteArrType_Type.tp_as_number = &(ubyte_as_number);
    PyUByteArrType_Type.tp_richcompare = ubyte_richcompare;
    
#line 1649
    short_as_number.nb_index = PyShortArrType_Type.tp_as_number->nb_index;
    PyShortArrType_Type.tp_as_number = &(short_as_number);
    PyShortArrType_Type.tp_richcompare = short_richcompare;
    
#line 1649
    ushort_as_number.nb_index = PyUShortArrType_Type.tp_as_number->nb_index;
    PyUShortArrType_Type.tp_as_number = &(ushort_as_number);
    PyUShortArrType_Type.tp_richcompare = ushort_richcompare;
    
#line 1649
    int_as_number.nb_index = PyIntArrType_Type.tp_as_number->nb_index;
    PyIntArrType_Type.tp_as_number = &(int_as_number);
    PyIntArrType_Type.tp_richcompare = int_richcompare;
    
#line 1649
    uint_as_number.nb_index = PyUIntArrType_Type.tp_as_number->nb_index;
    PyUIntArrType_Type.tp_as_number = &(uint_as_number);
    PyUIntArrType_Type.tp_richcompare = uint_richcompare;
    
#line 1649
    long_as_number.nb_index = PyLongArrType_Type.tp_as_number->nb_index;
    PyLongArrType_Type.tp_as_number = &(long_as_number);
    PyLongArrType_Type.tp_richcompare = long_richcompare;
    
#line 1649
    ulong_as_number.nb_index = PyULongArrType_Type.tp_as_number->nb_index;
    PyULongArrType_Type.tp_as_number = &(ulong_as_number);
    PyULongArrType_Type.tp_richcompare = ulong_richcompare;
    
#line 1649
    longlong_as_number.nb_index = PyLongLongArrType_Type.tp_as_number->nb_index;
    PyLongLongArrType_Type.tp_as_number = &(longlong_as_number);
    PyLongLongArrType_Type.tp_richcompare = longlong_richcompare;
    
#line 1649
    ulonglong_as_number.nb_index = PyULongLongArrType_Type.tp_as_number->nb_index;
    PyULongLongArrType_Type.tp_as_number = &(ulonglong_as_number);
    PyULongLongArrType_Type.tp_richcompare = ulonglong_richcompare;
    
#line 1649
    half_as_number.nb_index = PyHalfArrType_Type.tp_as_number->nb_index;
    PyHalfArrType_Type.tp_as_number = &(half_as_number);
    PyHalfArrType_Type.tp_richcompare = half_richcompare;
    
#line 1649
    float_as_number.nb_index = PyFloatArrType_Type.tp_as_number->nb_index;
    PyFloatArrType_Type.tp_as_number = &(float_as_number);
    PyFloatArrType_Type.tp_richcompare = float_richcompare;
    
#line 1649
    double_as_number.nb_index = PyDoubleArrType_Type.tp_as_number->nb_index;
    PyDoubleArrType_Type.tp_as_number = &(double_as_number);
    PyDoubleArrType_Type.tp_richcompare = double_richcompare;
    
#line 1649
    longdouble_as_number.nb_index = PyLongDoubleArrType_Type.tp_as_number->nb_index;
    PyLongDoubleArrType_Type.tp_as_number = &(longdouble_as_number);
    PyLongDoubleArrType_Type.tp_richcompare = longdouble_richcompare;
    
#line 1649
    cfloat_as_number.nb_index = PyCFloatArrType_Type.tp_as_number->nb_index;
    PyCFloatArrType_Type.tp_as_number = &(cfloat_as_number);
    PyCFloatArrType_Type.tp_richcompare = cfloat_richcompare;
    
#line 1649
    cdouble_as_number.nb_index = PyCDoubleArrType_Type.tp_as_number->nb_index;
    PyCDoubleArrType_Type.tp_as_number = &(cdouble_as_number);
    PyCDoubleArrType_Type.tp_richcompare = cdouble_richcompare;
    
#line 1649
    clongdouble_as_number.nb_index = PyCLongDoubleArrType_Type.tp_as_number->nb_index;
    PyCLongDoubleArrType_Type.tp_as_number = &(clongdouble_as_number);
    PyCLongDoubleArrType_Type.tp_richcompare = clongdouble_richcompare;
    
}

static int
get_functions(PyObject * mm)
{
    PyObject *obj;
    void **funcdata;
    char *signatures;
    int i, j;
    int ret = -1;

    /* Get the nc_pow functions */
    /* Get the pow functions */
    obj = PyObject_GetAttrString(mm, "power");
    if (obj == NULL) {
        goto fail;
    }
    funcdata = ((PyUFuncObject *)obj)->data;
    signatures = ((PyUFuncObject *)obj)->types;

    i = 0;
    j = 0;
    while (signatures[i] != NPY_FLOAT) {
        i += 3;
        j++;
    }
    _basic_float_pow = funcdata[j];
    _basic_double_pow = funcdata[j + 1];
    _basic_longdouble_pow = funcdata[j + 2];
    _basic_cfloat_pow = funcdata[j + 3];
    _basic_cdouble_pow = funcdata[j + 4];
    _basic_clongdouble_pow = funcdata[j + 5];
    Py_DECREF(obj);

    return ret = 0;

 fail:
    Py_DECREF(mm);
    return ret;
}


NPY_NO_EXPORT int initscalarmath(PyObject * m)
{
    if (get_functions(m) < 0) {
        return -1;
    }

    add_scalarmath();

    return 0;
}

