// This file is generated by Tools/cases_generator/generate_cases.py
// from:
//   Python/bytecodes.c
// Do not edit!

        TARGET(NOP) {
            DISPATCH();
        }

        TARGET(RESUME) {
            #line 137 "Python/bytecodes.c"
            assert(tstate->cframe == &cframe);
            assert(frame == cframe.current_frame);
            /* Possibly combine this with eval breaker */
            if (frame->f_code->_co_instrumentation_version != tstate->interp->monitoring_version) {
                int err = _Py_Instrument(frame->f_code, tstate->interp);
                if (err) goto error;
                next_instr--;
            }
            else if (_Py_atomic_load_relaxed_int32(&tstate->interp->ceval.eval_breaker) && oparg < 2) {
                goto handle_eval_breaker;
            }
            #line 24 "Python/generated_cases.c.h"
            DISPATCH();
        }

        TARGET(INSTRUMENTED_RESUME) {
            #line 151 "Python/bytecodes.c"
            /* Possible performance enhancement:
             *   We need to check the eval breaker anyway, can we
             * combine the instrument verison check and the eval breaker test?
             */
            if (frame->f_code->_co_instrumentation_version != tstate->interp->monitoring_version) {
                if (_Py_Instrument(frame->f_code, tstate->interp)) {
                    goto error;
                }
                next_instr--;
            }
            else {
                _PyFrame_SetStackPointer(frame, stack_pointer);
                int err = _Py_call_instrumentation(
                        tstate, oparg > 0, frame, next_instr-1);
                stack_pointer = _PyFrame_GetStackPointer(frame);
                if (err) goto error;
                if (frame->prev_instr != next_instr-1) {
                    /* Instrumentation has jumped */
                    next_instr = frame->prev_instr;
                    DISPATCH();
                }
                if (_Py_atomic_load_relaxed_int32(&tstate->interp->ceval.eval_breaker) && oparg < 2) {
                    goto handle_eval_breaker;
                }
            }
            #line 55 "Python/generated_cases.c.h"
            DISPATCH();
        }

        TARGET(LOAD_CLOSURE) {
            PyObject *value;
            #line 179 "Python/bytecodes.c"
            /* We keep LOAD_CLOSURE so that the bytecode stays more readable. */
            value = GETLOCAL(oparg);
            if (value == NULL) goto unbound_local_error;
            Py_INCREF(value);
            #line 66 "Python/generated_cases.c.h"
            STACK_GROW(1);
            stack_pointer[-1] = value;
            DISPATCH();
        }

        TARGET(LOAD_FAST_CHECK) {
            PyObject *value;
            #line 186 "Python/bytecodes.c"
            value = GETLOCAL(oparg);
            if (value == NULL) goto unbound_local_error;
            Py_INCREF(value);
            #line 78 "Python/generated_cases.c.h"
            STACK_GROW(1);
            stack_pointer[-1] = value;
            DISPATCH();
        }

        TARGET(LOAD_FAST) {
            PyObject *value;
            #line 192 "Python/bytecodes.c"
            value = GETLOCAL(oparg);
            assert(value != NULL);
            Py_INCREF(value);
            #line 90 "Python/generated_cases.c.h"
            STACK_GROW(1);
            stack_pointer[-1] = value;
            DISPATCH();
        }

        TARGET(LOAD_FAST_AND_CLEAR) {
            PyObject *value;
            #line 198 "Python/bytecodes.c"
            value = GETLOCAL(oparg);
            // do not use SETLOCAL here, it decrefs the old value
            GETLOCAL(oparg) = NULL;
            #line 102 "Python/generated_cases.c.h"
            STACK_GROW(1);
            stack_pointer[-1] = value;
            DISPATCH();
        }

        TARGET(LOAD_CONST) {
            PREDICTED(LOAD_CONST);
            PyObject *value;
            #line 204 "Python/bytecodes.c"
            value = GETITEM(frame->f_code->co_consts, oparg);
            Py_INCREF(value);
            #line 114 "Python/generated_cases.c.h"
            STACK_GROW(1);
            stack_pointer[-1] = value;
            DISPATCH();
        }

        TARGET(STORE_FAST) {
            PyObject *value = stack_pointer[-1];
            #line 209 "Python/bytecodes.c"
            SETLOCAL(oparg, value);
            #line 124 "Python/generated_cases.c.h"
            STACK_SHRINK(1);
            DISPATCH();
        }

        TARGET(LOAD_FAST__LOAD_FAST) {
            PyObject *_tmp_1;
            PyObject *_tmp_2;
            {
                PyObject *value;
                #line 192 "Python/bytecodes.c"
                value = GETLOCAL(oparg);
                assert(value != NULL);
                Py_INCREF(value);
                #line 138 "Python/generated_cases.c.h"
                _tmp_2 = value;
            }
            oparg = (next_instr++)->op.arg;
            {
                PyObject *value;
                #line 192 "Python/bytecodes.c"
                value = GETLOCAL(oparg);
                assert(value != NULL);
                Py_INCREF(value);
                #line 148 "Python/generated_cases.c.h"
                _tmp_1 = value;
            }
            STACK_GROW(2);
            stack_pointer[-1] = _tmp_1;
            stack_pointer[-2] = _tmp_2;
            DISPATCH();
        }

        TARGET(LOAD_FAST__LOAD_CONST) {
            PyObject *_tmp_1;
            PyObject *_tmp_2;
            {
                PyObject *value;
                #line 192 "Python/bytecodes.c"
                value = GETLOCAL(oparg);
                assert(value != NULL);
                Py_INCREF(value);
                #line 166 "Python/generated_cases.c.h"
                _tmp_2 = value;
            }
            oparg = (next_instr++)->op.arg;
            {
                PyObject *value;
                #line 204 "Python/bytecodes.c"
                value = GETITEM(frame->f_code->co_consts, oparg);
                Py_INCREF(value);
                #line 175 "Python/generated_cases.c.h"
                _tmp_1 = value;
            }
            STACK_GROW(2);
            stack_pointer[-1] = _tmp_1;
            stack_pointer[-2] = _tmp_2;
            DISPATCH();
        }

        TARGET(STORE_FAST__LOAD_FAST) {
            PyObject *_tmp_1 = stack_pointer[-1];
            {
                PyObject *value = _tmp_1;
                #line 209 "Python/bytecodes.c"
                SETLOCAL(oparg, value);
                #line 190 "Python/generated_cases.c.h"
            }
            oparg = (next_instr++)->op.arg;
            {
                PyObject *value;
                #line 192 "Python/bytecodes.c"
                value = GETLOCAL(oparg);
                assert(value != NULL);
                Py_INCREF(value);
                #line 199 "Python/generated_cases.c.h"
                _tmp_1 = value;
            }
            stack_pointer[-1] = _tmp_1;
            DISPATCH();
        }

        TARGET(STORE_FAST__STORE_FAST) {
            PyObject *_tmp_1 = stack_pointer[-1];
            PyObject *_tmp_2 = stack_pointer[-2];
            {
                PyObject *value = _tmp_1;
                #line 209 "Python/bytecodes.c"
                SETLOCAL(oparg, value);
                #line 213 "Python/generated_cases.c.h"
            }
            oparg = (next_instr++)->op.arg;
            {
                PyObject *value = _tmp_2;
                #line 209 "Python/bytecodes.c"
                SETLOCAL(oparg, value);
                #line 220 "Python/generated_cases.c.h"
            }
            STACK_SHRINK(2);
            DISPATCH();
        }

        TARGET(LOAD_CONST__LOAD_FAST) {
            PyObject *_tmp_1;
            PyObject *_tmp_2;
            {
                PyObject *value;
                #line 204 "Python/bytecodes.c"
                value = GETITEM(frame->f_code->co_consts, oparg);
                Py_INCREF(value);
                #line 234 "Python/generated_cases.c.h"
                _tmp_2 = value;
            }
            oparg = (next_instr++)->op.arg;
            {
                PyObject *value;
                #line 192 "Python/bytecodes.c"
                value = GETLOCAL(oparg);
                assert(value != NULL);
                Py_INCREF(value);
                #line 244 "Python/generated_cases.c.h"
                _tmp_1 = value;
            }
            STACK_GROW(2);
            stack_pointer[-1] = _tmp_1;
            stack_pointer[-2] = _tmp_2;
            DISPATCH();
        }

        TARGET(POP_TOP) {
            PyObject *value = stack_pointer[-1];
            #line 219 "Python/bytecodes.c"
            #line 256 "Python/generated_cases.c.h"
            Py_DECREF(value);
            STACK_SHRINK(1);
            DISPATCH();
        }

        TARGET(PUSH_NULL) {
            PyObject *res;
            #line 223 "Python/bytecodes.c"
            res = NULL;
            #line 266 "Python/generated_cases.c.h"
            STACK_GROW(1);
            stack_pointer[-1] = res;
            DISPATCH();
        }

        TARGET(END_FOR) {
            PyObject *_tmp_1 = stack_pointer[-1];
            PyObject *_tmp_2 = stack_pointer[-2];
            {
                PyObject *value = _tmp_1;
                #line 219 "Python/bytecodes.c"
                #line 278 "Python/generated_cases.c.h"
                Py_DECREF(value);
            }
            {
                PyObject *value = _tmp_2;
                #line 219 "Python/bytecodes.c"
                #line 284 "Python/generated_cases.c.h"
                Py_DECREF(value);
            }
            STACK_SHRINK(2);
            DISPATCH();
        }

        TARGET(INSTRUMENTED_END_FOR) {
            PyObject *value = stack_pointer[-1];
            PyObject *receiver = stack_pointer[-2];
            #line 229 "Python/bytecodes.c"
            /* Need to create a fake StopIteration error here,
             * to conform to PEP 380 */
            if (PyGen_Check(receiver)) {
                PyErr_SetObject(PyExc_StopIteration, value);
                if (monitor_stop_iteration(tstate, frame, next_instr-1)) {
                    goto error;
                }
                PyErr_SetRaisedException(NULL);
            }
            #line 304 "Python/generated_cases.c.h"
            Py_DECREF(receiver);
            Py_DECREF(value);
            STACK_SHRINK(2);
            DISPATCH();
        }

        TARGET(END_SEND) {
            PyObject *value = stack_pointer[-1];
            PyObject *receiver = stack_pointer[-2];
            #line 242 "Python/bytecodes.c"
            Py_DECREF(receiver);
            #line 316 "Python/generated_cases.c.h"
            STACK_SHRINK(1);
            stack_pointer[-1] = value;
            DISPATCH();
        }

        TARGET(INSTRUMENTED_END_SEND) {
            PyObject *value = stack_pointer[-1];
            PyObject *receiver = stack_pointer[-2];
            #line 246 "Python/bytecodes.c"
            if (PyGen_Check(receiver) || PyCoro_CheckExact(receiver)) {
                PyErr_SetObject(PyExc_StopIteration, value);
                if (monitor_stop_iteration(tstate, frame, next_instr-1)) {
                    goto error;
                }
                PyErr_SetRaisedException(NULL);
            }
            Py_DECREF(receiver);
            #line 334 "Python/generated_cases.c.h"
            STACK_SHRINK(1);
            stack_pointer[-1] = value;
            DISPATCH();
        }

        TARGET(UNARY_NEGATIVE) {
            PyObject *value = stack_pointer[-1];
            PyObject *res;
            #line 257 "Python/bytecodes.c"
            res = PyNumber_Negative(value);
            #line 345 "Python/generated_cases.c.h"
            Py_DECREF(value);
            #line 259 "Python/bytecodes.c"
            if (res == NULL) goto pop_1_error;
            #line 349 "Python/generated_cases.c.h"
            stack_pointer[-1] = res;
            DISPATCH();
        }

        TARGET(UNARY_NOT) {
            PyObject *value = stack_pointer[-1];
            PyObject *res;
            #line 263 "Python/bytecodes.c"
            int err = PyObject_IsTrue(value);
            #line 359 "Python/generated_cases.c.h"
            Py_DECREF(value);
            #line 265 "Python/bytecodes.c"
            if (err < 0) goto pop_1_error;
            if (err == 0) {
                res = Py_True;
            }
            else {
                res = Py_False;
            }
            #line 369 "Python/generated_cases.c.h"
            stack_pointer[-1] = res;
            DISPATCH();
        }

        TARGET(UNARY_INVERT) {
            PyObject *value = stack_pointer[-1];
            PyObject *res;
            #line 275 "Python/bytecodes.c"
            res = PyNumber_Invert(value);
            #line 379 "Python/generated_cases.c.h"
            Py_DECREF(value);
            #line 277 "Python/bytecodes.c"
            if (res == NULL) goto pop_1_error;
            #line 383 "Python/generated_cases.c.h"
            stack_pointer[-1] = res;
            DISPATCH();
        }

        TARGET(BINARY_OP_MULTIPLY_INT) {
            PyObject *right = stack_pointer[-1];
            PyObject *left = stack_pointer[-2];
            PyObject *prod;
            #line 294 "Python/bytecodes.c"
            DEOPT_IF(!PyLong_CheckExact(left), BINARY_OP);
            DEOPT_IF(!PyLong_CheckExact(right), BINARY_OP);
            STAT_INC(BINARY_OP, hit);
            prod = _PyLong_Multiply((PyLongObject *)left, (PyLongObject *)right);
            _Py_DECREF_SPECIALIZED(right, (destructor)PyObject_Free);
            _Py_DECREF_SPECIALIZED(left, (destructor)PyObject_Free);
            if (prod == NULL) goto pop_2_error;
            #line 400 "Python/generated_cases.c.h"
            STACK_SHRINK(1);
            stack_pointer[-1] = prod;
            next_instr += 1;
            DISPATCH();
        }

        TARGET(BINARY_OP_MULTIPLY_FLOAT) {
            PyObject *right = stack_pointer[-1];
            PyObject *left = stack_pointer[-2];
            PyObject *prod;
            #line 304 "Python/bytecodes.c"
            DEOPT_IF(!PyFloat_CheckExact(left), BINARY_OP);
            DEOPT_IF(!PyFloat_CheckExact(right), BINARY_OP);
            STAT_INC(BINARY_OP, hit);
            double dprod = ((PyFloatObject *)left)->ob_fval *
                ((PyFloatObject *)right)->ob_fval;
            DECREF_INPUTS_AND_REUSE_FLOAT(left, right, dprod, prod);
            #line 418 "Python/generated_cases.c.h"
            STACK_SHRINK(1);
            stack_pointer[-1] = prod;
            next_instr += 1;
            DISPATCH();
        }

        TARGET(BINARY_OP_SUBTRACT_INT) {
            PyObject *right = stack_pointer[-1];
            PyObject *left = stack_pointer[-2];
            PyObject *sub;
            #line 313 "Python/bytecodes.c"
            DEOPT_IF(!PyLong_CheckExact(left), BINARY_OP);
            DEOPT_IF(!PyLong_CheckExact(right), BINARY_OP);
            STAT_INC(BINARY_OP, hit);
            sub = _PyLong_Subtract((PyLongObject *)left, (PyLongObject *)right);
            _Py_DECREF_SPECIALIZED(right, (destructor)PyObject_Free);
            _Py_DECREF_SPECIALIZED(left, (destructor)PyObject_Free);
            if (sub == NULL) goto pop_2_error;
            #line 437 "Python/generated_cases.c.h"
            STACK_SHRINK(1);
            stack_pointer[-1] = sub;
            next_instr += 1;
            DISPATCH();
        }

        TARGET(BINARY_OP_SUBTRACT_FLOAT) {
            PyObject *right = stack_pointer[-1];
            PyObject *left = stack_pointer[-2];
            PyObject *sub;
            #line 323 "Python/bytecodes.c"
            DEOPT_IF(!PyFloat_CheckExact(left), BINARY_OP);
            DEOPT_IF(!PyFloat_CheckExact(right), BINARY_OP);
            STAT_INC(BINARY_OP, hit);
            double dsub = ((PyFloatObject *)left)->ob_fval - ((PyFloatObject *)right)->ob_fval;
            DECREF_INPUTS_AND_REUSE_FLOAT(left, right, dsub, sub);
            #line 454 "Python/generated_cases.c.h"
            STACK_SHRINK(1);
            stack_pointer[-1] = sub;
            next_instr += 1;
            DISPATCH();
        }

        TARGET(BINARY_OP_ADD_UNICODE) {
            PyObject *right = stack_pointer[-1];
            PyObject *left = stack_pointer[-2];
            PyObject *res;
            #line 331 "Python/bytecodes.c"
            DEOPT_IF(!PyUnicode_CheckExact(left), BINARY_OP);
            DEOPT_IF(Py_TYPE(right) != Py_TYPE(left), BINARY_OP);
            STAT_INC(BINARY_OP, hit);
            res = PyUnicode_Concat(left, right);
            _Py_DECREF_SPECIALIZED(left, _PyUnicode_ExactDealloc);
            _Py_DECREF_SPECIALIZED(right, _PyUnicode_ExactDealloc);
            if (res == NULL) goto pop_2_error;
            #line 473 "Python/generated_cases.c.h"
            STACK_SHRINK(1);
            stack_pointer[-1] = res;
            next_instr += 1;
            DISPATCH();
        }

        TARGET(BINARY_OP_INPLACE_ADD_UNICODE) {
            PyObject *right = stack_pointer[-1];
            PyObject *left = stack_pointer[-2];
            #line 347 "Python/bytecodes.c"
            DEOPT_IF(!PyUnicode_CheckExact(left), BINARY_OP);
            DEOPT_IF(Py_TYPE(right) != Py_TYPE(left), BINARY_OP);
            _Py_CODEUNIT true_next = next_instr[INLINE_CACHE_ENTRIES_BINARY_OP];
            assert(true_next.op.code == STORE_FAST ||
                   true_next.op.code == STORE_FAST__LOAD_FAST);
            PyObject **target_local = &GETLOCAL(true_next.op.arg);
            DEOPT_IF(*target_local != left, BINARY_OP);
            STAT_INC(BINARY_OP, hit);
            /* Handle `left = left + right` or `left += right` for str.
             *
             * When possible, extend `left` in place rather than
             * allocating a new PyUnicodeObject. This attempts to avoid
             * quadratic behavior when one neglects to use str.join().
             *
             * If `left` has only two references remaining (one from
             * the stack, one in the locals), DECREFing `left` leaves
             * only the locals reference, so PyUnicode_Append knows
             * that the string is safe to mutate.
             */
            assert(Py_REFCNT(left) >= 2);
            _Py_DECREF_NO_DEALLOC(left);
            PyUnicode_Append(target_local, right);
            _Py_DECREF_SPECIALIZED(right, _PyUnicode_ExactDealloc);
            if (*target_local == NULL) goto pop_2_error;
            // The STORE_FAST is already done.
            JUMPBY(INLINE_CACHE_ENTRIES_BINARY_OP + 1);
            #line 510 "Python/generated_cases.c.h"
            STACK_SHRINK(2);
            DISPATCH();
        }

        TARGET(BINARY_OP_ADD_FLOAT) {
            PyObject *right = stack_pointer[-1];
            PyObject *left = stack_pointer[-2];
            PyObject *sum;
            #line 376 "Python/bytecodes.c"
            DEOPT_IF(!PyFloat_CheckExact(left), BINARY_OP);
            DEOPT_IF(Py_TYPE(right) != Py_TYPE(left), BINARY_OP);
            STAT_INC(BINARY_OP, hit);
            double dsum = ((PyFloatObject *)left)->ob_fval +
                ((PyFloatObject *)right)->ob_fval;
            DECREF_INPUTS_AND_REUSE_FLOAT(left, right, dsum, sum);
            #line 526 "Python/generated_cases.c.h"
            STACK_SHRINK(1);
            stack_pointer[-1] = sum;
            next_instr += 1;
            DISPATCH();
        }

        TARGET(BINARY_OP_ADD_INT) {
            PyObject *right = stack_pointer[-1];
            PyObject *left = stack_pointer[-2];
            PyObject *sum;
            #line 385 "Python/bytecodes.c"
            DEOPT_IF(!PyLong_CheckExact(left), BINARY_OP);
            DEOPT_IF(Py_TYPE(right) != Py_TYPE(left), BINARY_OP);
            STAT_INC(BINARY_OP, hit);
            sum = _PyLong_Add((PyLongObject *)left, (PyLongObject *)right);
            _Py_DECREF_SPECIALIZED(right, (destructor)PyObject_Free);
            _Py_DECREF_SPECIALIZED(left, (destructor)PyObject_Free);
            if (sum == NULL) goto pop_2_error;
            #line 545 "Python/generated_cases.c.h"
            STACK_SHRINK(1);
            stack_pointer[-1] = sum;
            next_instr += 1;
            DISPATCH();
        }

        TARGET(BINARY_SUBSCR) {
            PREDICTED(BINARY_SUBSCR);
            static_assert(INLINE_CACHE_ENTRIES_BINARY_SUBSCR == 1, "incorrect cache size");
            PyObject *sub = stack_pointer[-1];
            PyObject *container = stack_pointer[-2];
            PyObject *res;
            #line 403 "Python/bytecodes.c"
            #if ENABLE_SPECIALIZATION
            _PyBinarySubscrCache *cache = (_PyBinarySubscrCache *)next_instr;
            if (ADAPTIVE_COUNTER_IS_ZERO(cache->counter)) {
                next_instr--;
                _Py_Specialize_BinarySubscr(container, sub, next_instr);
                DISPATCH_SAME_OPARG();
            }
            STAT_INC(BINARY_SUBSCR, deferred);
            DECREMENT_ADAPTIVE_COUNTER(cache->counter);
            #endif  /* ENABLE_SPECIALIZATION */
            res = PyObject_GetItem(container, sub);
            #line 570 "Python/generated_cases.c.h"
            Py_DECREF(container);
            Py_DECREF(sub);
            #line 415 "Python/bytecodes.c"
            if (res == NULL) goto pop_2_error;
            #line 575 "Python/generated_cases.c.h"
            STACK_SHRINK(1);
            stack_pointer[-1] = res;
            next_instr += 1;
            DISPATCH();
        }

        TARGET(BINARY_SLICE) {
            PyObject *stop = stack_pointer[-1];
            PyObject *start = stack_pointer[-2];
            PyObject *container = stack_pointer[-3];
            PyObject *res;
            #line 419 "Python/bytecodes.c"
            PyObject *slice = _PyBuildSlice_ConsumeRefs(start, stop);
            // Can't use ERROR_IF() here, because we haven't
            // DECREF'ed container yet, and we still own slice.
            if (slice == NULL) {
                res = NULL;
            }
            else {
                res = PyObject_GetItem(container, slice);
                Py_DECREF(slice);
            }
            Py_DECREF(container);
            if (res == NULL) goto pop_3_error;
            #line 600 "Python/generated_cases.c.h"
            STACK_SHRINK(2);
            stack_pointer[-1] = res;
            DISPATCH();
        }

        TARGET(STORE_SLICE) {
            PyObject *stop = stack_pointer[-1];
            PyObject *start = stack_pointer[-2];
            PyObject *container = stack_pointer[-3];
            PyObject *v = stack_pointer[-4];
            #line 434 "Python/bytecodes.c"
            PyObject *slice = _PyBuildSlice_ConsumeRefs(start, stop);
            int err;
            if (slice == NULL) {
                err = 1;
            }
            else {
                err = PyObject_SetItem(container, slice, v);
                Py_DECREF(slice);
            }
            Py_DECREF(v);
            Py_DECREF(container);
            if (err) goto pop_4_error;
            #line 624 "Python/generated_cases.c.h"
            STACK_SHRINK(4);
            DISPATCH();
        }

        TARGET(BINARY_SUBSCR_LIST_INT) {
            PyObject *sub = stack_pointer[-1];
            PyObject *list = stack_pointer[-2];
            PyObject *res;
            #line 449 "Python/bytecodes.c"
            DEOPT_IF(!PyLong_CheckExact(sub), BINARY_SUBSCR);
            DEOPT_IF(!PyList_CheckExact(list), BINARY_SUBSCR);

            // Deopt unless 0 <= sub < PyList_Size(list)
            DEOPT_IF(!_PyLong_IsNonNegativeCompact((PyLongObject *)sub), BINARY_SUBSCR);
            Py_ssize_t index = ((PyLongObject*)sub)->long_value.ob_digit[0];
            DEOPT_IF(index >= PyList_GET_SIZE(list), BINARY_SUBSCR);
            STAT_INC(BINARY_SUBSCR, hit);
            res = PyList_GET_ITEM(list, index);
            assert(res != NULL);
            Py_INCREF(res);
            _Py_DECREF_SPECIALIZED(sub, (destructor)PyObject_Free);
            Py_DECREF(list);
            #line 647 "Python/generated_cases.c.h"
            STACK_SHRINK(1);
            stack_pointer[-1] = res;
            next_instr += 1;
            DISPATCH();
        }

        TARGET(BINARY_SUBSCR_TUPLE_INT) {
            PyObject *sub = stack_pointer[-1];
            PyObject *tuple = stack_pointer[-2];
            PyObject *res;
            #line 465 "Python/bytecodes.c"
            DEOPT_IF(!PyLong_CheckExact(sub), BINARY_SUBSCR);
            DEOPT_IF(!PyTuple_CheckExact(tuple), BINARY_SUBSCR);

            // Deopt unless 0 <= sub < PyTuple_Size(list)
            DEOPT_IF(!_PyLong_IsNonNegativeCompact((PyLongObject *)sub), BINARY_SUBSCR);
            Py_ssize_t index = ((PyLongObject*)sub)->long_value.ob_digit[0];
            DEOPT_IF(index >= PyTuple_GET_SIZE(tuple), BINARY_SUBSCR);
            STAT_INC(BINARY_SUBSCR, hit);
            res = PyTuple_GET_ITEM(tuple, index);
            assert(res != NULL);
            Py_INCREF(res);
            _Py_DECREF_SPECIALIZED(sub, (destructor)PyObject_Free);
            Py_DECREF(tuple);
            #line 672 "Python/generated_cases.c.h"
            STACK_SHRINK(1);
            stack_pointer[-1] = res;
            next_instr += 1;
            DISPATCH();
        }

        TARGET(BINARY_SUBSCR_DICT) {
            PyObject *sub = stack_pointer[-1];
            PyObject *dict = stack_pointer[-2];
            PyObject *res;
            #line 481 "Python/bytecodes.c"
            DEOPT_IF(!PyDict_CheckExact(dict), BINARY_SUBSCR);
            STAT_INC(BINARY_SUBSCR, hit);
            res = PyDict_GetItemWithError(dict, sub);
            if (res == NULL) {
                if (!_PyErr_Occurred(tstate)) {
                    _PyErr_SetKeyError(sub);
                }
            #line 691 "Python/generated_cases.c.h"
                Py_DECREF(dict);
                Py_DECREF(sub);
            #line 489 "Python/bytecodes.c"
                if (true) goto pop_2_error;
            }
            Py_INCREF(res);  // Do this before DECREF'ing dict, sub
            #line 698 "Python/generated_cases.c.h"
            Py_DECREF(dict);
            Py_DECREF(sub);
            STACK_SHRINK(1);
            stack_pointer[-1] = res;
            next_instr += 1;
            DISPATCH();
        }

        TARGET(BINARY_SUBSCR_GETITEM) {
            PyObject *sub = stack_pointer[-1];
            PyObject *container = stack_pointer[-2];
            #line 496 "Python/bytecodes.c"
            DEOPT_IF(tstate->interp->eval_frame, BINARY_SUBSCR);
            PyTypeObject *tp = Py_TYPE(container);
            DEOPT_IF(!PyType_HasFeature(tp, Py_TPFLAGS_HEAPTYPE), BINARY_SUBSCR);
            PyHeapTypeObject *ht = (PyHeapTypeObject *)tp;
            PyObject *cached = ht->_spec_cache.getitem;
            DEOPT_IF(cached == NULL, BINARY_SUBSCR);
            assert(PyFunction_Check(cached));
            PyFunctionObject *getitem = (PyFunctionObject *)cached;
            uint32_t cached_version = ht->_spec_cache.getitem_version;
            DEOPT_IF(getitem->func_version != cached_version, BINARY_SUBSCR);
            PyCodeObject *code = (PyCodeObject *)getitem->func_code;
            assert(code->co_argcount == 2);
            DEOPT_IF(!_PyThreadState_HasStackSpace(tstate, code->co_framesize), BINARY_SUBSCR);
            STAT_INC(BINARY_SUBSCR, hit);
            Py_INCREF(getitem);
            _PyInterpreterFrame *new_frame = _PyFrame_PushUnchecked(tstate, getitem, 2);
            STACK_SHRINK(2);
            new_frame->localsplus[0] = container;
            new_frame->localsplus[1] = sub;
            JUMPBY(INLINE_CACHE_ENTRIES_BINARY_SUBSCR);
            frame->return_offset = 0;
            DISPATCH_INLINED(new_frame);
            #line 733 "Python/generated_cases.c.h"
        }

        TARGET(LIST_APPEND) {
            PyObject *v = stack_pointer[-1];
            PyObject *list = stack_pointer[-(2 + (oparg-1))];
            #line 521 "Python/bytecodes.c"
            if (_PyList_AppendTakeRef((PyListObject *)list, v) < 0) goto pop_1_error;
            #line 741 "Python/generated_cases.c.h"
            STACK_SHRINK(1);
            PREDICT(JUMP_BACKWARD);
            DISPATCH();
        }

        TARGET(SET_ADD) {
            PyObject *v = stack_pointer[-1];
            PyObject *set = stack_pointer[-(2 + (oparg-1))];
            #line 526 "Python/bytecodes.c"
            int err = PySet_Add(set, v);
            #line 752 "Python/generated_cases.c.h"
            Py_DECREF(v);
            #line 528 "Python/bytecodes.c"
            if (err) goto pop_1_error;
            #line 756 "Python/generated_cases.c.h"
            STACK_SHRINK(1);
            PREDICT(JUMP_BACKWARD);
            DISPATCH();
        }

        TARGET(STORE_SUBSCR) {
            PREDICTED(STORE_SUBSCR);
            static_assert(INLINE_CACHE_ENTRIES_STORE_SUBSCR == 1, "incorrect cache size");
            PyObject *sub = stack_pointer[-1];
            PyObject *container = stack_pointer[-2];
            PyObject *v = stack_pointer[-3];
            uint16_t counter = read_u16(&next_instr[0].cache);
            #line 539 "Python/bytecodes.c"
            #if ENABLE_SPECIALIZATION
            if (ADAPTIVE_COUNTER_IS_ZERO(counter)) {
                next_instr--;
                _Py_Specialize_StoreSubscr(container, sub, next_instr);
                DISPATCH_SAME_OPARG();
            }
            STAT_INC(STORE_SUBSCR, deferred);
            _PyStoreSubscrCache *cache = (_PyStoreSubscrCache *)next_instr;
            DECREMENT_ADAPTIVE_COUNTER(cache->counter);
            #else
            (void)counter;  // Unused.
            #endif  /* ENABLE_SPECIALIZATION */
            /* container[sub] = v */
            int err = PyObject_SetItem(container, sub, v);
            #line 784 "Python/generated_cases.c.h"
            Py_DECREF(v);
            Py_DECREF(container);
            Py_DECREF(sub);
            #line 554 "Python/bytecodes.c"
            if (err) goto pop_3_error;
            #line 790 "Python/generated_cases.c.h"
            STACK_SHRINK(3);
            next_instr += 1;
            DISPATCH();
        }

        TARGET(STORE_SUBSCR_LIST_INT) {
            PyObject *sub = stack_pointer[-1];
            PyObject *list = stack_pointer[-2];
            PyObject *value = stack_pointer[-3];
            #line 558 "Python/bytecodes.c"
            DEOPT_IF(!PyLong_CheckExact(sub), STORE_SUBSCR);
            DEOPT_IF(!PyList_CheckExact(list), STORE_SUBSCR);

            // Ensure nonnegative, zero-or-one-digit ints.
            DEOPT_IF(!_PyLong_IsNonNegativeCompact((PyLongObject *)sub), STORE_SUBSCR);
            Py_ssize_t index = ((PyLongObject*)sub)->long_value.ob_digit[0];
            // Ensure index < len(list)
            DEOPT_IF(index >= PyList_GET_SIZE(list), STORE_SUBSCR);
            STAT_INC(STORE_SUBSCR, hit);

            PyObject *old_value = PyList_GET_ITEM(list, index);
            PyList_SET_ITEM(list, index, value);
            assert(old_value != NULL);
            Py_DECREF(old_value);
            _Py_DECREF_SPECIALIZED(sub, (destructor)PyObject_Free);
            Py_DECREF(list);
            #line 817 "Python/generated_cases.c.h"
            STACK_SHRINK(3);
            next_instr += 1;
            DISPATCH();
        }

        TARGET(STORE_SUBSCR_DICT) {
            PyObject *sub = stack_pointer[-1];
            PyObject *dict = stack_pointer[-2];
            PyObject *value = stack_pointer[-3];
            #line 577 "Python/bytecodes.c"
            DEOPT_IF(!PyDict_CheckExact(dict), STORE_SUBSCR);
            STAT_INC(STORE_SUBSCR, hit);
            int err = _PyDict_SetItem_Take2((PyDictObject *)dict, sub, value);
            Py_DECREF(dict);
            if (err) goto pop_3_error;
            #line 833 "Python/generated_cases.c.h"
            STACK_SHRINK(3);
            next_instr += 1;
            DISPATCH();
        }

        TARGET(DELETE_SUBSCR) {
            PyObject *sub = stack_pointer[-1];
            PyObject *container = stack_pointer[-2];
            #line 585 "Python/bytecodes.c"
            /* del container[sub] */
            int err = PyObject_DelItem(container, sub);
            #line 845 "Python/generated_cases.c.h"
            Py_DECREF(container);
            Py_DECREF(sub);
            #line 588 "Python/bytecodes.c"
            if (err) goto pop_2_error;
            #line 850 "Python/generated_cases.c.h"
            STACK_SHRINK(2);
            DISPATCH();
        }

        TARGET(CALL_INTRINSIC_1) {
            PyObject *value = stack_pointer[-1];
            PyObject *res;
            #line 592 "Python/bytecodes.c"
            assert(oparg <= MAX_INTRINSIC_1);
            res = _PyIntrinsics_UnaryFunctions[oparg](tstate, value);
            #line 861 "Python/generated_cases.c.h"
            Py_DECREF(value);
            #line 595 "Python/bytecodes.c"
            if (res == NULL) goto pop_1_error;
            #line 865 "Python/generated_cases.c.h"
            stack_pointer[-1] = res;
            DISPATCH();
        }

        TARGET(CALL_INTRINSIC_2) {
            PyObject *value1 = stack_pointer[-1];
            PyObject *value2 = stack_pointer[-2];
            PyObject *res;
            #line 599 "Python/bytecodes.c"
            assert(oparg <= MAX_INTRINSIC_2);
            res = _PyIntrinsics_BinaryFunctions[oparg](tstate, value2, value1);
            #line 877 "Python/generated_cases.c.h"
            Py_DECREF(value2);
            Py_DECREF(value1);
            #line 602 "Python/bytecodes.c"
            if (res == NULL) goto pop_2_error;
            #line 882 "Python/generated_cases.c.h"
            STACK_SHRINK(1);
            stack_pointer[-1] = res;
            DISPATCH();
        }

        TARGET(RAISE_VARARGS) {
            PyObject **args = (stack_pointer - oparg);
            #line 606 "Python/bytecodes.c"
            PyObject *cause = NULL, *exc = NULL;
            switch (oparg) {
            case 2:
                cause = args[1];
                /* fall through */
            case 1:
                exc = args[0];
                /* fall through */
            case 0:
                if (do_raise(tstate, exc, cause)) { STACK_SHRINK(oparg); goto exception_unwind; }
                break;
            default:
                _PyErr_SetString(tstate, PyExc_SystemError,
                                 "bad RAISE_VARARGS oparg");
                break;
            }
            if (true) { STACK_SHRINK(oparg); goto error; }
            #line 908 "Python/generated_cases.c.h"
        }

        TARGET(INTERPRETER_EXIT) {
            PyObject *retval = stack_pointer[-1];
            #line 626 "Python/bytecodes.c"
            assert(frame == &entry_frame);
            assert(_PyFrame_IsIncomplete(frame));
            STACK_SHRINK(1);  // Since we're not going to DISPATCH()
            assert(EMPTY());
            /* Restore previous cframe and return. */
            tstate->cframe = cframe.previous;
            assert(tstate->cframe->current_frame == frame->previous);
            assert(!_PyErr_Occurred(tstate));
            _Py_LeaveRecursiveCallTstate(tstate);
            return retval;
            #line 924 "Python/generated_cases.c.h"
        }

        TARGET(RETURN_VALUE) {
            PyObject *retval = stack_pointer[-1];
            #line 639 "Python/bytecodes.c"
            STACK_SHRINK(1);
            assert(EMPTY());
            _PyFrame_SetStackPointer(frame, stack_pointer);
            _Py_LeaveRecursiveCallPy(tstate);
            assert(frame != &entry_frame);
            // GH-99729: We need to unlink the frame *before* clearing it:
            _PyInterpreterFrame *dying = frame;
            frame = cframe.current_frame = dying->previous;
            _PyEvalFrameClearAndPop(tstate, dying);
            frame->prev_instr += frame->return_offset;
            _PyFrame_StackPush(frame, retval);
            goto resume_frame;
            #line 942 "Python/generated_cases.c.h"
        }

        TARGET(INSTRUMENTED_RETURN_VALUE) {
            PyObject *retval = stack_pointer[-1];
            #line 654 "Python/bytecodes.c"
            int err = _Py_call_instrumentation_arg(
                    tstate, PY_MONITORING_EVENT_PY_RETURN,
                    frame, next_instr-1, retval);
            if (err) goto error;
            STACK_SHRINK(1);
            assert(EMPTY());
            _PyFrame_SetStackPointer(frame, stack_pointer);
            _Py_LeaveRecursiveCallPy(tstate);
            assert(frame != &entry_frame);
            // GH-99729: We need to unlink the frame *before* clearing it:
            _PyInterpreterFrame *dying = frame;
            frame = cframe.current_frame = dying->previous;
            _PyEvalFrameClearAndPop(tstate, dying);
            frame->prev_instr += frame->return_offset;
            _PyFrame_StackPush(frame, retval);
            goto resume_frame;
            #line 964 "Python/generated_cases.c.h"
        }

        TARGET(RETURN_CONST) {
            #line 673 "Python/bytecodes.c"
            PyObject *retval = GETITEM(frame->f_code->co_consts, oparg);
            Py_INCREF(retval);
            assert(EMPTY());
            _PyFrame_SetStackPointer(frame, stack_pointer);
            _Py_LeaveRecursiveCallPy(tstate);
            assert(frame != &entry_frame);
            // GH-99729: We need to unlink the frame *before* clearing it:
            _PyInterpreterFrame *dying = frame;
            frame = cframe.current_frame = dying->previous;
            _PyEvalFrameClearAndPop(tstate, dying);
            frame->prev_instr += frame->return_offset;
            _PyFrame_StackPush(frame, retval);
            goto resume_frame;
            #line 982 "Python/generated_cases.c.h"
        }

        TARGET(INSTRUMENTED_RETURN_CONST) {
            #line 689 "Python/bytecodes.c"
            PyObject *retval = GETITEM(frame->f_code->co_consts, oparg);
            int err = _Py_call_instrumentation_arg(
                    tstate, PY_MONITORING_EVENT_PY_RETURN,
                    frame, next_instr-1, retval);
            if (err) goto error;
            Py_INCREF(retval);
            assert(EMPTY());
            _PyFrame_SetStackPointer(frame, stack_pointer);
            _Py_LeaveRecursiveCallPy(tstate);
            assert(frame != &entry_frame);
            // GH-99729: We need to unlink the frame *before* clearing it:
            _PyInterpreterFrame *dying = frame;
            frame = cframe.current_frame = dying->previous;
            _PyEvalFrameClearAndPop(tstate, dying);
            frame->prev_instr += frame->return_offset;
            _PyFrame_StackPush(frame, retval);
            goto resume_frame;
            #line 1004 "Python/generated_cases.c.h"
        }

        TARGET(GET_AITER) {
            PyObject *obj = stack_pointer[-1];
            PyObject *iter;
            #line 709 "Python/bytecodes.c"
            unaryfunc getter = NULL;
            PyTypeObject *type = Py_TYPE(obj);

            if (type->tp_as_async != NULL) {
                getter = type->tp_as_async->am_aiter;
            }

            if (getter == NULL) {
                _PyErr_Format(tstate, PyExc_TypeError,
                              "'async for' requires an object with "
                              "__aiter__ method, got %.100s",
                              type->tp_name);
            #line 1023 "Python/generated_cases.c.h"
                Py_DECREF(obj);
            #line 722 "Python/bytecodes.c"
                if (true) goto pop_1_error;
            }

            iter = (*getter)(obj);
            #line 1030 "Python/generated_cases.c.h"
            Py_DECREF(obj);
            #line 727 "Python/bytecodes.c"
            if (iter == NULL) goto pop_1_error;

            if (Py_TYPE(iter)->tp_as_async == NULL ||
                    Py_TYPE(iter)->tp_as_async->am_anext == NULL) {

                _PyErr_Format(tstate, PyExc_TypeError,
                              "'async for' received an object from __aiter__ "
                              "that does not implement __anext__: %.100s",
                              Py_TYPE(iter)->tp_name);
                Py_DECREF(iter);
                if (true) goto pop_1_error;
            }
            #line 1045 "Python/generated_cases.c.h"
            stack_pointer[-1] = iter;
            DISPATCH();
        }

        TARGET(GET_ANEXT) {
            PyObject *aiter = stack_pointer[-1];
            PyObject *awaitable;
            #line 742 "Python/bytecodes.c"
            unaryfunc getter = NULL;
            PyObject *next_iter = NULL;
            PyTypeObject *type = Py_TYPE(aiter);

            if (PyAsyncGen_CheckExact(aiter)) {
                awaitable = type->tp_as_async->am_anext(aiter);
                if (awaitable == NULL) {
                    goto error;
                }
            } else {
                if (type->tp_as_async != NULL){
                    getter = type->tp_as_async->am_anext;
                }

                if (getter != NULL) {
                    next_iter = (*getter)(aiter);
                    if (next_iter == NULL) {
                        goto error;
                    }
                }
                else {
                    _PyErr_Format(tstate, PyExc_TypeError,
                                  "'async for' requires an iterator with "
                                  "__anext__ method, got %.100s",
                                  type->tp_name);
                    goto error;
                }

                awaitable = _PyCoro_GetAwaitableIter(next_iter);
                if (awaitable == NULL) {
                    _PyErr_FormatFromCause(
                        PyExc_TypeError,
                        "'async for' received an invalid object "
                        "from __anext__: %.100s",
                        Py_TYPE(next_iter)->tp_name);

                    Py_DECREF(next_iter);
                    goto error;
                } else {
                    Py_DECREF(next_iter);
                }
            }

            #line 1097 "Python/generated_cases.c.h"
            STACK_GROW(1);
            stack_pointer[-1] = awaitable;
            PREDICT(LOAD_CONST);
            DISPATCH();
        }

        TARGET(GET_AWAITABLE) {
            PREDICTED(GET_AWAITABLE);
            PyObject *iterable = stack_pointer[-1];
            PyObject *iter;
            #line 789 "Python/bytecodes.c"
            iter = _PyCoro_GetAwaitableIter(iterable);

            if (iter == NULL) {
                format_awaitable_error(tstate, Py_TYPE(iterable), oparg);
            }

            #line 1115 "Python/generated_cases.c.h"
            Py_DECREF(iterable);
            #line 796 "Python/bytecodes.c"

            if (iter != NULL && PyCoro_CheckExact(iter)) {
                PyObject *yf = _PyGen_yf((PyGenObject*)iter);
                if (yf != NULL) {
                    /* `iter` is a coroutine object that is being
                       awaited, `yf` is a pointer to the current awaitable
                       being awaited on. */
                    Py_DECREF(yf);
                    Py_CLEAR(iter);
                    _PyErr_SetString(tstate, PyExc_RuntimeError,
                                     "coroutine is being awaited already");
                    /* The code below jumps to `error` if `iter` is NULL. */
                }
            }

            if (iter == NULL) goto pop_1_error;

            #line 1135 "Python/generated_cases.c.h"
            stack_pointer[-1] = iter;
            PREDICT(LOAD_CONST);
            DISPATCH();
        }

        TARGET(SEND) {
            PREDICTED(SEND);
            static_assert(INLINE_CACHE_ENTRIES_SEND == 1, "incorrect cache size");
            PyObject *v = stack_pointer[-1];
            PyObject *receiver = stack_pointer[-2];
            PyObject *retval;
            #line 822 "Python/bytecodes.c"
            #if ENABLE_SPECIALIZATION
            _PySendCache *cache = (_PySendCache *)next_instr;
            if (ADAPTIVE_COUNTER_IS_ZERO(cache->counter)) {
                next_instr--;
                _Py_Specialize_Send(receiver, next_instr);
                DISPATCH_SAME_OPARG();
            }
            STAT_INC(SEND, deferred);
            DECREMENT_ADAPTIVE_COUNTER(cache->counter);
            #endif  /* ENABLE_SPECIALIZATION */
            assert(frame != &entry_frame);
            if ((tstate->interp->eval_frame == NULL) &&
                (Py_TYPE(receiver) == &PyGen_Type || Py_TYPE(receiver) == &PyCoro_Type) &&
                ((PyGenObject *)receiver)->gi_frame_state < FRAME_EXECUTING)
            {
                PyGenObject *gen = (PyGenObject *)receiver;
                _PyInterpreterFrame *gen_frame = (_PyInterpreterFrame *)gen->gi_iframe;
                frame->return_offset = oparg;
                STACK_SHRINK(1);
                _PyFrame_StackPush(gen_frame, v);
                gen->gi_frame_state = FRAME_EXECUTING;
                gen->gi_exc_state.previous_item = tstate->exc_info;
                tstate->exc_info = &gen->gi_exc_state;
                JUMPBY(INLINE_CACHE_ENTRIES_SEND);
                DISPATCH_INLINED(gen_frame);
            }
            if (Py_IsNone(v) && PyIter_Check(receiver)) {
                retval = Py_TYPE(receiver)->tp_iternext(receiver);
            }
            else {
                retval = PyObject_CallMethodOneArg(receiver, &_Py_ID(send), v);
            }
            if (retval == NULL) {
                if (_PyErr_ExceptionMatches(tstate, PyExc_StopIteration)
                ) {
                    monitor_raise(tstate, frame, next_instr-1);
                }
                if (_PyGen_FetchStopIterationValue(&retval) == 0) {
                    assert(retval != NULL);
                    JUMPBY(oparg);
                }
                else {
                    goto error;
                }
            }
            Py_DECREF(v);
            #line 1194 "Python/generated_cases.c.h"
            stack_pointer[-1] = retval;
            next_instr += 1;
            DISPATCH();
        }

        TARGET(SEND_GEN) {
            PyObject *v = stack_pointer[-1];
            PyObject *receiver = stack_pointer[-2];
            #line 871 "Python/bytecodes.c"
            DEOPT_IF(tstate->interp->eval_frame, SEND);
            PyGenObject *gen = (PyGenObject *)receiver;
            DEOPT_IF(Py_TYPE(gen) != &PyGen_Type &&
                     Py_TYPE(gen) != &PyCoro_Type, SEND);
            DEOPT_IF(gen->gi_frame_state >= FRAME_EXECUTING, SEND);
            STAT_INC(SEND, hit);
            _PyInterpreterFrame *gen_frame = (_PyInterpreterFrame *)gen->gi_iframe;
            frame->return_offset = oparg;
            STACK_SHRINK(1);
            _PyFrame_StackPush(gen_frame, v);
            gen->gi_frame_state = FRAME_EXECUTING;
            gen->gi_exc_state.previous_item = tstate->exc_info;
            tstate->exc_info = &gen->gi_exc_state;
            JUMPBY(INLINE_CACHE_ENTRIES_SEND);
            DISPATCH_INLINED(gen_frame);
            #line 1219 "Python/generated_cases.c.h"
        }

        TARGET(INSTRUMENTED_YIELD_VALUE) {
            PyObject *retval = stack_pointer[-1];
            #line 889 "Python/bytecodes.c"
            assert(frame != &entry_frame);
            PyGenObject *gen = _PyFrame_GetGenerator(frame);
            gen->gi_frame_state = FRAME_SUSPENDED;
            _PyFrame_SetStackPointer(frame, stack_pointer - 1);
            int err = _Py_call_instrumentation_arg(
                    tstate, PY_MONITORING_EVENT_PY_YIELD,
                    frame, next_instr-1, retval);
            if (err) goto error;
            tstate->exc_info = gen->gi_exc_state.previous_item;
            gen->gi_exc_state.previous_item = NULL;
            _Py_LeaveRecursiveCallPy(tstate);
            _PyInterpreterFrame *gen_frame = frame;
            frame = cframe.current_frame = frame->previous;
            gen_frame->previous = NULL;
            _PyFrame_StackPush(frame, retval);
            goto resume_frame;
            #line 1241 "Python/generated_cases.c.h"
        }

        TARGET(YIELD_VALUE) {
            PyObject *retval = stack_pointer[-1];
            #line 908 "Python/bytecodes.c"
            // NOTE: It's important that YIELD_VALUE never raises an exception!
            // The compiler treats any exception raised here as a failed close()
            // or throw() call.
            assert(frame != &entry_frame);
            PyGenObject *gen = _PyFrame_GetGenerator(frame);
            gen->gi_frame_state = FRAME_SUSPENDED;
            _PyFrame_SetStackPointer(frame, stack_pointer - 1);
            tstate->exc_info = gen->gi_exc_state.previous_item;
            gen->gi_exc_state.previous_item = NULL;
            _Py_LeaveRecursiveCallPy(tstate);
            _PyInterpreterFrame *gen_frame = frame;
            frame = cframe.current_frame = frame->previous;
            gen_frame->previous = NULL;
            _PyFrame_StackPush(frame, retval);
            goto resume_frame;
            #line 1262 "Python/generated_cases.c.h"
        }

        TARGET(POP_EXCEPT) {
            PyObject *exc_value = stack_pointer[-1];
            #line 926 "Python/bytecodes.c"
            _PyErr_StackItem *exc_info = tstate->exc_info;
            Py_XSETREF(exc_info->exc_value, exc_value);
            #line 1270 "Python/generated_cases.c.h"
            STACK_SHRINK(1);
            DISPATCH();
        }

        TARGET(RERAISE) {
            PyObject *exc = stack_pointer[-1];
            PyObject **values = (stack_pointer - (1 + oparg));
            #line 931 "Python/bytecodes.c"
            assert(oparg >= 0 && oparg <= 2);
            if (oparg) {
                PyObject *lasti = values[0];
                if (PyLong_Check(lasti)) {
                    frame->prev_instr = _PyCode_CODE(frame->f_code) + PyLong_AsLong(lasti);
                    assert(!_PyErr_Occurred(tstate));
                }
                else {
                    assert(PyLong_Check(lasti));
                    _PyErr_SetString(tstate, PyExc_SystemError, "lasti is not an int");
                    goto error;
                }
            }
            assert(exc && PyExceptionInstance_Check(exc));
            Py_INCREF(exc);
            _PyErr_SetRaisedException(tstate, exc);
            goto exception_unwind;
            #line 1296 "Python/generated_cases.c.h"
        }

        TARGET(END_ASYNC_FOR) {
            PyObject *exc = stack_pointer[-1];
            PyObject *awaitable = stack_pointer[-2];
            #line 951 "Python/bytecodes.c"
            assert(exc && PyExceptionInstance_Check(exc));
            if (PyErr_GivenExceptionMatches(exc, PyExc_StopAsyncIteration)) {
            #line 1305 "Python/generated_cases.c.h"
                Py_DECREF(awaitable);
                Py_DECREF(exc);
            #line 954 "Python/bytecodes.c"
            }
            else {
                Py_INCREF(exc);
                _PyErr_SetRaisedException(tstate, exc);
                goto exception_unwind;
            }
            #line 1315 "Python/generated_cases.c.h"
            STACK_SHRINK(2);
            DISPATCH();
        }

        TARGET(CLEANUP_THROW) {
            PyObject *exc_value = stack_pointer[-1];
            PyObject *last_sent_val = stack_pointer[-2];
            PyObject *sub_iter = stack_pointer[-3];
            PyObject *none;
            PyObject *value;
            #line 963 "Python/bytecodes.c"
            assert(throwflag);
            assert(exc_value && PyExceptionInstance_Check(exc_value));
            if (PyErr_GivenExceptionMatches(exc_value, PyExc_StopIteration)) {
                value = Py_NewRef(((PyStopIterationObject *)exc_value)->value);
            #line 1331 "Python/generated_cases.c.h"
                Py_DECREF(sub_iter);
                Py_DECREF(last_sent_val);
                Py_DECREF(exc_value);
            #line 968 "Python/bytecodes.c"
                none = Py_None;
            }
            else {
                _PyErr_SetRaisedException(tstate, Py_NewRef(exc_value));
                goto exception_unwind;
            }
            #line 1342 "Python/generated_cases.c.h"
            STACK_SHRINK(1);
            stack_pointer[-1] = value;
            stack_pointer[-2] = none;
            DISPATCH();
        }

        TARGET(LOAD_ASSERTION_ERROR) {
            PyObject *value;
            #line 977 "Python/bytecodes.c"
            value = Py_NewRef(PyExc_AssertionError);
            #line 1353 "Python/generated_cases.c.h"
            STACK_GROW(1);
            stack_pointer[-1] = value;
            DISPATCH();
        }

        TARGET(LOAD_BUILD_CLASS) {
            PyObject *bc;
            #line 981 "Python/bytecodes.c"
            if (PyDict_CheckExact(BUILTINS())) {
                bc = _PyDict_GetItemWithError(BUILTINS(),
                                              &_Py_ID(__build_class__));
                if (bc == NULL) {
                    if (!_PyErr_Occurred(tstate)) {
                        _PyErr_SetString(tstate, PyExc_NameError,
                                         "__build_class__ not found");
                    }
                    if (true) goto error;
                }
                Py_INCREF(bc);
            }
            else {
                bc = PyObject_GetItem(BUILTINS(), &_Py_ID(__build_class__));
                if (bc == NULL) {
                    if (_PyErr_ExceptionMatches(tstate, PyExc_KeyError))
                        _PyErr_SetString(tstate, PyExc_NameError,
                                         "__build_class__ not found");
                    if (true) goto error;
                }
            }
            #line 1383 "Python/generated_cases.c.h"
            STACK_GROW(1);
            stack_pointer[-1] = bc;
            DISPATCH();
        }

        TARGET(STORE_NAME) {
            PyObject *v = stack_pointer[-1];
            #line 1006 "Python/bytecodes.c"
            PyObject *name = GETITEM(frame->f_code->co_names, oparg);
            PyObject *ns = LOCALS();
            int err;
            if (ns == NULL) {
                _PyErr_Format(tstate, PyExc_SystemError,
                              "no locals found when storing %R", name);
            #line 1398 "Python/generated_cases.c.h"
                Py_DECREF(v);
            #line 1013 "Python/bytecodes.c"
                if (true) goto pop_1_error;
            }
            if (PyDict_CheckExact(ns))
                err = PyDict_SetItem(ns, name, v);
            else
                err = PyObject_SetItem(ns, name, v);
            #line 1407 "Python/generated_cases.c.h"
            Py_DECREF(v);
            #line 1020 "Python/bytecodes.c"
            if (err) goto pop_1_error;
            #line 1411 "Python/generated_cases.c.h"
            STACK_SHRINK(1);
            DISPATCH();
        }

        TARGET(DELETE_NAME) {
            #line 1024 "Python/bytecodes.c"
            PyObject *name = GETITEM(frame->f_code->co_names, oparg);
            PyObject *ns = LOCALS();
            int err;
            if (ns == NULL) {
                _PyErr_Format(tstate, PyExc_SystemError,
                              "no locals when deleting %R", name);
                goto error;
            }
            err = PyObject_DelItem(ns, name);
            // Can't use ERROR_IF here.
            if (err != 0) {
                format_exc_check_arg(tstate, PyExc_NameError,
                                     NAME_ERROR_MSG,
                                     name);
                goto error;
            }
            #line 1434 "Python/generated_cases.c.h"
            DISPATCH();
        }

        TARGET(UNPACK_SEQUENCE) {
            PREDICTED(UNPACK_SEQUENCE);
            static_assert(INLINE_CACHE_ENTRIES_UNPACK_SEQUENCE == 1, "incorrect cache size");
            PyObject *seq = stack_pointer[-1];
            #line 1050 "Python/bytecodes.c"
            #if ENABLE_SPECIALIZATION
            _PyUnpackSequenceCache *cache = (_PyUnpackSequenceCache *)next_instr;
            if (ADAPTIVE_COUNTER_IS_ZERO(cache->counter)) {
                next_instr--;
                _Py_Specialize_UnpackSequence(seq, next_instr, oparg);
                DISPATCH_SAME_OPARG();
            }
            STAT_INC(UNPACK_SEQUENCE, deferred);
            DECREMENT_ADAPTIVE_COUNTER(cache->counter);
            #endif  /* ENABLE_SPECIALIZATION */
            PyObject **top = stack_pointer + oparg - 1;
            int res = unpack_iterable(tstate, seq, oparg, -1, top);
            #line 1455 "Python/generated_cases.c.h"
            Py_DECREF(seq);
            #line 1063 "Python/bytecodes.c"
            if (res == 0) goto pop_1_error;
            #line 1459 "Python/generated_cases.c.h"
            STACK_SHRINK(1);
            STACK_GROW(oparg);
            next_instr += 1;
            DISPATCH();
        }

        TARGET(UNPACK_SEQUENCE_TWO_TUPLE) {
            PyObject *seq = stack_pointer[-1];
            PyObject **values = stack_pointer - (1);
            #line 1067 "Python/bytecodes.c"
            DEOPT_IF(!PyTuple_CheckExact(seq), UNPACK_SEQUENCE);
            DEOPT_IF(PyTuple_GET_SIZE(seq) != 2, UNPACK_SEQUENCE);
            assert(oparg == 2);
            STAT_INC(UNPACK_SEQUENCE, hit);
            values[0] = Py_NewRef(PyTuple_GET_ITEM(seq, 1));
            values[1] = Py_NewRef(PyTuple_GET_ITEM(seq, 0));
            #line 1476 "Python/generated_cases.c.h"
            Py_DECREF(seq);
            STACK_SHRINK(1);
            STACK_GROW(oparg);
            next_instr += 1;
            DISPATCH();
        }

        TARGET(UNPACK_SEQUENCE_TUPLE) {
            PyObject *seq = stack_pointer[-1];
            PyObject **values = stack_pointer - (1);
            #line 1077 "Python/bytecodes.c"
            DEOPT_IF(!PyTuple_CheckExact(seq), UNPACK_SEQUENCE);
            DEOPT_IF(PyTuple_GET_SIZE(seq) != oparg, UNPACK_SEQUENCE);
            STAT_INC(UNPACK_SEQUENCE, hit);
            PyObject **items = _PyTuple_ITEMS(seq);
            for (int i = oparg; --i >= 0; ) {
                *values++ = Py_NewRef(items[i]);
            }
            #line 1495 "Python/generated_cases.c.h"
            Py_DECREF(seq);
            STACK_SHRINK(1);
            STACK_GROW(oparg);
            next_instr += 1;
            DISPATCH();
        }

        TARGET(UNPACK_SEQUENCE_LIST) {
            PyObject *seq = stack_pointer[-1];
            PyObject **values = stack_pointer - (1);
            #line 1088 "Python/bytecodes.c"
            DEOPT_IF(!PyList_CheckExact(seq), UNPACK_SEQUENCE);
            DEOPT_IF(PyList_GET_SIZE(seq) != oparg, UNPACK_SEQUENCE);
            STAT_INC(UNPACK_SEQUENCE, hit);
            PyObject **items = _PyList_ITEMS(seq);
            for (int i = oparg; --i >= 0; ) {
                *values++ = Py_NewRef(items[i]);
            }
            #line 1514 "Python/generated_cases.c.h"
            Py_DECREF(seq);
            STACK_SHRINK(1);
            STACK_GROW(oparg);
            next_instr += 1;
            DISPATCH();
        }

        TARGET(UNPACK_EX) {
            PyObject *seq = stack_pointer[-1];
            #line 1099 "Python/bytecodes.c"
            int totalargs = 1 + (oparg & 0xFF) + (oparg >> 8);
            PyObject **top = stack_pointer + totalargs - 1;
            int res = unpack_iterable(tstate, seq, oparg & 0xFF, oparg >> 8, top);
            #line 1528 "Python/generated_cases.c.h"
            Py_DECREF(seq);
            #line 1103 "Python/bytecodes.c"
            if (res == 0) goto pop_1_error;
            #line 1532 "Python/generated_cases.c.h"
            STACK_GROW((oparg & 0xFF) + (oparg >> 8));
            DISPATCH();
        }

        TARGET(STORE_ATTR) {
            PREDICTED(STORE_ATTR);
            static_assert(INLINE_CACHE_ENTRIES_STORE_ATTR == 4, "incorrect cache size");
            PyObject *owner = stack_pointer[-1];
            PyObject *v = stack_pointer[-2];
            uint16_t counter = read_u16(&next_instr[0].cache);
            #line 1114 "Python/bytecodes.c"
            #if ENABLE_SPECIALIZATION
            if (ADAPTIVE_COUNTER_IS_ZERO(counter)) {
                PyObject *name = GETITEM(frame->f_code->co_names, oparg);
                next_instr--;
                _Py_Specialize_StoreAttr(owner, next_instr, name);
                DISPATCH_SAME_OPARG();
            }
            STAT_INC(STORE_ATTR, deferred);
            _PyAttrCache *cache = (_PyAttrCache *)next_instr;
            DECREMENT_ADAPTIVE_COUNTER(cache->counter);
            #else
            (void)counter;  // Unused.
            #endif  /* ENABLE_SPECIALIZATION */
            PyObject *name = GETITEM(frame->f_code->co_names, oparg);
            int err = PyObject_SetAttr(owner, name, v);
            #line 1559 "Python/generated_cases.c.h"
            Py_DECREF(v);
            Py_DECREF(owner);
            #line 1130 "Python/bytecodes.c"
            if (err) goto pop_2_error;
            #line 1564 "Python/generated_cases.c.h"
            STACK_SHRINK(2);
            next_instr += 4;
            DISPATCH();
        }

        TARGET(DELETE_ATTR) {
            PyObject *owner = stack_pointer[-1];
            #line 1134 "Python/bytecodes.c"
            PyObject *name = GETITEM(frame->f_code->co_names, oparg);
            int err = PyObject_SetAttr(owner, name, (PyObject *)NULL);
            #line 1575 "Python/generated_cases.c.h"
            Py_DECREF(owner);
            #line 1137 "Python/bytecodes.c"
            if (err) goto pop_1_error;
            #line 1579 "Python/generated_cases.c.h"
            STACK_SHRINK(1);
            DISPATCH();
        }

        TARGET(STORE_GLOBAL) {
            PyObject *v = stack_pointer[-1];
            #line 1141 "Python/bytecodes.c"
            PyObject *name = GETITEM(frame->f_code->co_names, oparg);
            int err = PyDict_SetItem(GLOBALS(), name, v);
            #line 1589 "Python/generated_cases.c.h"
            Py_DECREF(v);
            #line 1144 "Python/bytecodes.c"
            if (err) goto pop_1_error;
            #line 1593 "Python/generated_cases.c.h"
            STACK_SHRINK(1);
            DISPATCH();
        }

        TARGET(DELETE_GLOBAL) {
            #line 1148 "Python/bytecodes.c"
            PyObject *name = GETITEM(frame->f_code->co_names, oparg);
            int err;
            err = PyDict_DelItem(GLOBALS(), name);
            // Can't use ERROR_IF here.
            if (err != 0) {
                if (_PyErr_ExceptionMatches(tstate, PyExc_KeyError)) {
                    format_exc_check_arg(tstate, PyExc_NameError,
                                         NAME_ERROR_MSG, name);
                }
                goto error;
            }
            #line 1611 "Python/generated_cases.c.h"
            DISPATCH();
        }

        TARGET(LOAD_LOCALS) {
            PyObject *_tmp_1;
            {
                PyObject *locals;
                #line 1162 "Python/bytecodes.c"
                locals = LOCALS();
                if (locals == NULL) {
                    _PyErr_SetString(tstate, PyExc_SystemError,
                                     "no locals found");
                    if (true) goto error;
                }
                Py_INCREF(locals);
                #line 1627 "Python/generated_cases.c.h"
                _tmp_1 = locals;
            }
            STACK_GROW(1);
            stack_pointer[-1] = _tmp_1;
            DISPATCH();
        }

        TARGET(LOAD_NAME) {
            PyObject *_tmp_1;
            {
                PyObject *locals;
                #line 1162 "Python/bytecodes.c"
                locals = LOCALS();
                if (locals == NULL) {
                    _PyErr_SetString(tstate, PyExc_SystemError,
                                     "no locals found");
                    if (true) goto error;
                }
                Py_INCREF(locals);
                #line 1647 "Python/generated_cases.c.h"
                _tmp_1 = locals;
            }
            {
                PyObject *mod_or_class_dict = _tmp_1;
                PyObject *v;
                #line 1174 "Python/bytecodes.c"
                PyObject *name = GETITEM(frame->f_code->co_names, oparg);
                if (PyDict_CheckExact(mod_or_class_dict)) {
                    v = PyDict_GetItemWithError(mod_or_class_dict, name);
                    if (v != NULL) {
                        Py_INCREF(v);
                    }
                    else if (_PyErr_Occurred(tstate)) {
                        Py_DECREF(mod_or_class_dict);
                        goto error;
                    }
                }
                else {
                    v = PyObject_GetItem(mod_or_class_dict, name);
                    if (v == NULL) {
                        if (!_PyErr_ExceptionMatches(tstate, PyExc_KeyError)) {
                            Py_DECREF(mod_or_class_dict);
                            goto error;
                        }
                        _PyErr_Clear(tstate);
                    }
                }
                Py_DECREF(mod_or_class_dict);
                if (v == NULL) {
                    v = PyDict_GetItemWithError(GLOBALS(), name);
                    if (v != NULL) {
                        Py_INCREF(v);
                    }
                    else if (_PyErr_Occurred(tstate)) {
                        goto error;
                    }
                    else {
                        if (PyDict_CheckExact(BUILTINS())) {
                            v = PyDict_GetItemWithError(BUILTINS(), name);
                            if (v == NULL) {
                                if (!_PyErr_Occurred(tstate)) {
                                    format_exc_check_arg(
                                            tstate, PyExc_NameError,
                                            NAME_ERROR_MSG, name);
                                }
                                goto error;
                            }
                            Py_INCREF(v);
                        }
                        else {
                            v = PyObject_GetItem(BUILTINS(), name);
                            if (v == NULL) {
                                if (_PyErr_ExceptionMatches(tstate, PyExc_KeyError)) {
                                    format_exc_check_arg(
                                                tstate, PyExc_NameError,
                                                NAME_ERROR_MSG, name);
                                }
                                goto error;
                            }
                        }
                    }
                }
                #line 1710 "Python/generated_cases.c.h"
                _tmp_1 = v;
            }
            STACK_GROW(1);
            stack_pointer[-1] = _tmp_1;
            DISPATCH();
        }

        TARGET(LOAD_FROM_DICT_OR_GLOBALS) {
            PyObject *_tmp_1 = stack_pointer[-1];
            {
                PyObject *mod_or_class_dict = _tmp_1;
                PyObject *v;
                #line 1174 "Python/bytecodes.c"
                PyObject *name = GETITEM(frame->f_code->co_names, oparg);
                if (PyDict_CheckExact(mod_or_class_dict)) {
                    v = PyDict_GetItemWithError(mod_or_class_dict, name);
                    if (v != NULL) {
                        Py_INCREF(v);
                    }
                    else if (_PyErr_Occurred(tstate)) {
                        Py_DECREF(mod_or_class_dict);
                        goto error;
                    }
                }
                else {
                    v = PyObject_GetItem(mod_or_class_dict, name);
                    if (v == NULL) {
                        if (!_PyErr_ExceptionMatches(tstate, PyExc_KeyError)) {
                            Py_DECREF(mod_or_class_dict);
                            goto error;
                        }
                        _PyErr_Clear(tstate);
                    }
                }
                Py_DECREF(mod_or_class_dict);
                if (v == NULL) {
                    v = PyDict_GetItemWithError(GLOBALS(), name);
                    if (v != NULL) {
                        Py_INCREF(v);
                    }
                    else if (_PyErr_Occurred(tstate)) {
                        goto error;
                    }
                    else {
                        if (PyDict_CheckExact(BUILTINS())) {
                            v = PyDict_GetItemWithError(BUILTINS(), name);
                            if (v == NULL) {
                                if (!_PyErr_Occurred(tstate)) {
                                    format_exc_check_arg(
                                            tstate, PyExc_NameError,
                                            NAME_ERROR_MSG, name);
                                }
                                goto error;
                            }
                            Py_INCREF(v);
                        }
                        else {
                            v = PyObject_GetItem(BUILTINS(), name);
                            if (v == NULL) {
                                if (_PyErr_ExceptionMatches(tstate, PyExc_KeyError)) {
                                    format_exc_check_arg(
                                                tstate, PyExc_NameError,
                                                NAME_ERROR_MSG, name);
                                }
                                goto error;
                            }
                        }
                    }
                }
                #line 1780 "Python/generated_cases.c.h"
                _tmp_1 = v;
            }
            stack_pointer[-1] = _tmp_1;
            DISPATCH();
        }

        TARGET(LOAD_GLOBAL) {
            PREDICTED(LOAD_GLOBAL);
            static_assert(INLINE_CACHE_ENTRIES_LOAD_GLOBAL == 4, "incorrect cache size");
            PyObject *null = NULL;
            PyObject *v;
            #line 1243 "Python/bytecodes.c"
            #if ENABLE_SPECIALIZATION
            _PyLoadGlobalCache *cache = (_PyLoadGlobalCache *)next_instr;
            if (ADAPTIVE_COUNTER_IS_ZERO(cache->counter)) {
                PyObject *name = GETITEM(frame->f_code->co_names, oparg>>1);
                next_instr--;
                _Py_Specialize_LoadGlobal(GLOBALS(), BUILTINS(), next_instr, name);
                DISPATCH_SAME_OPARG();
            }
            STAT_INC(LOAD_GLOBAL, deferred);
            DECREMENT_ADAPTIVE_COUNTER(cache->counter);
            #endif  /* ENABLE_SPECIALIZATION */
            PyObject *name = GETITEM(frame->f_code->co_names, oparg>>1);
            if (PyDict_CheckExact(GLOBALS())
                && PyDict_CheckExact(BUILTINS()))
            {
                v = _PyDict_LoadGlobal((PyDictObject *)GLOBALS(),
                                       (PyDictObject *)BUILTINS(),
                                       name);
                if (v == NULL) {
                    if (!_PyErr_Occurred(tstate)) {
                        /* _PyDict_LoadGlobal() returns NULL without raising
                         * an exception if the key doesn't exist */
                        format_exc_check_arg(tstate, PyExc_NameError,
                                             NAME_ERROR_MSG, name);
                    }
                    if (true) goto error;
                }
                Py_INCREF(v);
            }
            else {
                /* Slow-path if globals or builtins is not a dict */

                /* namespace 1: globals */
                v = PyObject_GetItem(GLOBALS(), name);
                if (v == NULL) {
                    if (!_PyErr_ExceptionMatches(tstate, PyExc_KeyError)) goto error;
                    _PyErr_Clear(tstate);

                    /* namespace 2: builtins */
                    v = PyObject_GetItem(BUILTINS(), name);
                    if (v == NULL) {
                        if (_PyErr_ExceptionMatches(tstate, PyExc_KeyError)) {
                            format_exc_check_arg(
                                        tstate, PyExc_NameError,
                                        NAME_ERROR_MSG, name);
                        }
                        if (true) goto error;
                    }
                }
            }
            null = NULL;
            #line 1844 "Python/generated_cases.c.h"
            STACK_GROW(1);
            STACK_GROW(((oparg & 1) ? 1 : 0));
            stack_pointer[-1] = v;
            if (oparg & 1) { stack_pointer[-(1 + ((oparg & 1) ? 1 : 0))] = null; }
            next_instr += 4;
            DISPATCH();
        }

        TARGET(LOAD_GLOBAL_MODULE) {
            PyObject *null = NULL;
            PyObject *res;
            uint16_t index = read_u16(&next_instr[1].cache);
            uint16_t version = read_u16(&next_instr[2].cache);
            #line 1297 "Python/bytecodes.c"
            DEOPT_IF(!PyDict_CheckExact(GLOBALS()), LOAD_GLOBAL);
            PyDictObject *dict = (PyDictObject *)GLOBALS();
            DEOPT_IF(dict->ma_keys->dk_version != version, LOAD_GLOBAL);
            assert(DK_IS_UNICODE(dict->ma_keys));
            PyDictUnicodeEntry *entries = DK_UNICODE_ENTRIES(dict->ma_keys);
            res = entries[index].me_value;
            DEOPT_IF(res == NULL, LOAD_GLOBAL);
            Py_INCREF(res);
            STAT_INC(LOAD_GLOBAL, hit);
            null = NULL;
            #line 1869 "Python/generated_cases.c.h"
            STACK_GROW(1);
            STACK_GROW(((oparg & 1) ? 1 : 0));
            stack_pointer[-1] = res;
            if (oparg & 1) { stack_pointer[-(1 + ((oparg & 1) ? 1 : 0))] = null; }
            next_instr += 4;
            DISPATCH();
        }

        TARGET(LOAD_GLOBAL_BUILTIN) {
            PyObject *null = NULL;
            PyObject *res;
            uint16_t index = read_u16(&next_instr[1].cache);
            uint16_t mod_version = read_u16(&next_instr[2].cache);
            uint16_t bltn_version = read_u16(&next_instr[3].cache);
            #line 1310 "Python/bytecodes.c"
            DEOPT_IF(!PyDict_CheckExact(GLOBALS()), LOAD_GLOBAL);
            DEOPT_IF(!PyDict_CheckExact(BUILTINS()), LOAD_GLOBAL);
            PyDictObject *mdict = (PyDictObject *)GLOBALS();
            PyDictObject *bdict = (PyDictObject *)BUILTINS();
            assert(opcode == LOAD_GLOBAL_BUILTIN);
            DEOPT_IF(mdict->ma_keys->dk_version != mod_version, LOAD_GLOBAL);
            DEOPT_IF(bdict->ma_keys->dk_version != bltn_version, LOAD_GLOBAL);
            assert(DK_IS_UNICODE(bdict->ma_keys));
            PyDictUnicodeEntry *entries = DK_UNICODE_ENTRIES(bdict->ma_keys);
            res = entries[index].me_value;
            DEOPT_IF(res == NULL, LOAD_GLOBAL);
            Py_INCREF(res);
            STAT_INC(LOAD_GLOBAL, hit);
            null = NULL;
            #line 1899 "Python/generated_cases.c.h"
            STACK_GROW(1);
            STACK_GROW(((oparg & 1) ? 1 : 0));
            stack_pointer[-1] = res;
            if (oparg & 1) { stack_pointer[-(1 + ((oparg & 1) ? 1 : 0))] = null; }
            next_instr += 4;
            DISPATCH();
        }

        TARGET(DELETE_FAST) {
            #line 1327 "Python/bytecodes.c"
            PyObject *v = GETLOCAL(oparg);
            if (v == NULL) goto unbound_local_error;
            SETLOCAL(oparg, NULL);
            #line 1913 "Python/generated_cases.c.h"
            DISPATCH();
        }

        TARGET(MAKE_CELL) {
            #line 1333 "Python/bytecodes.c"
            // "initial" is probably NULL but not if it's an arg (or set
            // via PyFrame_LocalsToFast() before MAKE_CELL has run).
            PyObject *initial = GETLOCAL(oparg);
            PyObject *cell = PyCell_New(initial);
            if (cell == NULL) {
                goto resume_with_error;
            }
            SETLOCAL(oparg, cell);
            #line 1927 "Python/generated_cases.c.h"
            DISPATCH();
        }

        TARGET(DELETE_DEREF) {
            #line 1344 "Python/bytecodes.c"
            PyObject *cell = GETLOCAL(oparg);
            PyObject *oldobj = PyCell_GET(cell);
            // Can't use ERROR_IF here.
            // Fortunately we don't need its superpower.
            if (oldobj == NULL) {
                format_exc_unbound(tstate, frame->f_code, oparg);
                goto error;
            }
            PyCell_SET(cell, NULL);
            Py_DECREF(oldobj);
            #line 1943 "Python/generated_cases.c.h"
            DISPATCH();
        }

        TARGET(LOAD_FROM_DICT_OR_DEREF) {
            PyObject *class_dict = stack_pointer[-1];
            PyObject *value;
            #line 1357 "Python/bytecodes.c"
            PyObject *name;
            assert(class_dict);
            assert(oparg >= 0 && oparg < frame->f_code->co_nlocalsplus);
            name = PyTuple_GET_ITEM(frame->f_code->co_localsplusnames, oparg);
            if (PyDict_CheckExact(class_dict)) {
                value = PyDict_GetItemWithError(class_dict, name);
                if (value != NULL) {
                    Py_INCREF(value);
                }
                else if (_PyErr_Occurred(tstate)) {
                    Py_DECREF(class_dict);
                    goto error;
                }
            }
            else {
                value = PyObject_GetItem(class_dict, name);
                if (value == NULL) {
                    if (!_PyErr_ExceptionMatches(tstate, PyExc_KeyError)) {
                        Py_DECREF(class_dict);
                        goto error;
                    }
                    _PyErr_Clear(tstate);
                }
            }
            Py_DECREF(class_dict);
            if (!value) {
                PyObject *cell = GETLOCAL(oparg);
                value = PyCell_GET(cell);
                if (value == NULL) {
                    format_exc_unbound(tstate, frame->f_code, oparg);
                    goto error;
                }
                Py_INCREF(value);
            }
            #line 1985 "Python/generated_cases.c.h"
            stack_pointer[-1] = value;
            DISPATCH();
        }

        TARGET(LOAD_DEREF) {
            PyObject *value;
            #line 1394 "Python/bytecodes.c"
            PyObject *cell = GETLOCAL(oparg);
            value = PyCell_GET(cell);
            if (value == NULL) {
                format_exc_unbound(tstate, frame->f_code, oparg);
                if (true) goto error;
            }
            Py_INCREF(value);
            #line 2000 "Python/generated_cases.c.h"
            STACK_GROW(1);
            stack_pointer[-1] = value;
            DISPATCH();
        }

        TARGET(STORE_DEREF) {
            PyObject *v = stack_pointer[-1];
            #line 1404 "Python/bytecodes.c"
            PyObject *cell = GETLOCAL(oparg);
            PyObject *oldobj = PyCell_GET(cell);
            PyCell_SET(cell, v);
            Py_XDECREF(oldobj);
            #line 2013 "Python/generated_cases.c.h"
            STACK_SHRINK(1);
            DISPATCH();
        }

        TARGET(COPY_FREE_VARS) {
            #line 1411 "Python/bytecodes.c"
            /* Copy closure variables to free variables */
            PyCodeObject *co = frame->f_code;
            assert(PyFunction_Check(frame->f_funcobj));
            PyObject *closure = ((PyFunctionObject *)frame->f_funcobj)->func_closure;
            assert(oparg == co->co_nfreevars);
            int offset = co->co_nlocalsplus - oparg;
            for (int i = 0; i < oparg; ++i) {
                PyObject *o = PyTuple_GET_ITEM(closure, i);
                frame->localsplus[offset + i] = Py_NewRef(o);
            }
            #line 2030 "Python/generated_cases.c.h"
            DISPATCH();
        }

        TARGET(BUILD_STRING) {
            PyObject **pieces = (stack_pointer - oparg);
            PyObject *str;
            #line 1424 "Python/bytecodes.c"
            str = _PyUnicode_JoinArray(&_Py_STR(empty), pieces, oparg);
            #line 2039 "Python/generated_cases.c.h"
            for (int _i = oparg; --_i >= 0;) {
                Py_DECREF(pieces[_i]);
            }
            #line 1426 "Python/bytecodes.c"
            if (str == NULL) { STACK_SHRINK(oparg); goto error; }
            #line 2045 "Python/generated_cases.c.h"
            STACK_SHRINK(oparg);
            STACK_GROW(1);
            stack_pointer[-1] = str;
            DISPATCH();
        }

        TARGET(BUILD_TUPLE) {
            PyObject **values = (stack_pointer - oparg);
            PyObject *tup;
            #line 1430 "Python/bytecodes.c"
            tup = _PyTuple_FromArraySteal(values, oparg);
            if (tup == NULL) { STACK_SHRINK(oparg); goto error; }
            #line 2058 "Python/generated_cases.c.h"
            STACK_SHRINK(oparg);
            STACK_GROW(1);
            stack_pointer[-1] = tup;
            DISPATCH();
        }

        TARGET(BUILD_LIST) {
            PyObject **values = (stack_pointer - oparg);
            PyObject *list;
            #line 1435 "Python/bytecodes.c"
            list = _PyList_FromArraySteal(values, oparg);
            if (list == NULL) { STACK_SHRINK(oparg); goto error; }
            #line 2071 "Python/generated_cases.c.h"
            STACK_SHRINK(oparg);
            STACK_GROW(1);
            stack_pointer[-1] = list;
            DISPATCH();
        }

        TARGET(LIST_EXTEND) {
            PyObject *iterable = stack_pointer[-1];
            PyObject *list = stack_pointer[-(2 + (oparg-1))];
            #line 1440 "Python/bytecodes.c"
            PyObject *none_val = _PyList_Extend((PyListObject *)list, iterable);
            if (none_val == NULL) {
                if (_PyErr_ExceptionMatches(tstate, PyExc_TypeError) &&
                   (Py_TYPE(iterable)->tp_iter == NULL && !PySequence_Check(iterable)))
                {
                    _PyErr_Clear(tstate);
                    _PyErr_Format(tstate, PyExc_TypeError,
                          "Value after * must be an iterable, not %.200s",
                          Py_TYPE(iterable)->tp_name);
                }
            #line 2092 "Python/generated_cases.c.h"
                Py_DECREF(iterable);
            #line 1451 "Python/bytecodes.c"
                if (true) goto pop_1_error;
            }
            assert(Py_IsNone(none_val));
            #line 2098 "Python/generated_cases.c.h"
            Py_DECREF(iterable);
            STACK_SHRINK(1);
            DISPATCH();
        }

        TARGET(SET_UPDATE) {
            PyObject *iterable = stack_pointer[-1];
            PyObject *set = stack_pointer[-(2 + (oparg-1))];
            #line 1458 "Python/bytecodes.c"
            int err = _PySet_Update(set, iterable);
            #line 2109 "Python/generated_cases.c.h"
            Py_DECREF(iterable);
            #line 1460 "Python/bytecodes.c"
            if (err < 0) goto pop_1_error;
            #line 2113 "Python/generated_cases.c.h"
            STACK_SHRINK(1);
            DISPATCH();
        }

        TARGET(BUILD_SET) {
            PyObject **values = (stack_pointer - oparg);
            PyObject *set;
            #line 1464 "Python/bytecodes.c"
            set = PySet_New(NULL);
            if (set == NULL)
                goto error;
            int err = 0;
            for (int i = 0; i < oparg; i++) {
                PyObject *item = values[i];
                if (err == 0)
                    err = PySet_Add(set, item);
                Py_DECREF(item);
            }
            if (err != 0) {
                Py_DECREF(set);
                if (true) { STACK_SHRINK(oparg); goto error; }
            }
            #line 2136 "Python/generated_cases.c.h"
            STACK_SHRINK(oparg);
            STACK_GROW(1);
            stack_pointer[-1] = set;
            DISPATCH();
        }

        TARGET(BUILD_MAP) {
            PyObject **values = (stack_pointer - oparg*2);
            PyObject *map;
            #line 1481 "Python/bytecodes.c"
            map = _PyDict_FromItems(
                    values, 2,
                    values+1, 2,
                    oparg);
            if (map == NULL)
                goto error;

            #line 2154 "Python/generated_cases.c.h"
            for (int _i = oparg*2; --_i >= 0;) {
                Py_DECREF(values[_i]);
            }
            #line 1489 "Python/bytecodes.c"
            if (map == NULL) { STACK_SHRINK(oparg*2); goto error; }
            #line 2160 "Python/generated_cases.c.h"
            STACK_SHRINK(oparg*2);
            STACK_GROW(1);
            stack_pointer[-1] = map;
            DISPATCH();
        }

        TARGET(SETUP_ANNOTATIONS) {
            #line 1493 "Python/bytecodes.c"
            int err;
            PyObject *ann_dict;
            if (LOCALS() == NULL) {
                _PyErr_Format(tstate, PyExc_SystemError,
                              "no locals found when setting up annotations");
                if (true) goto error;
            }
            /* check if __annotations__ in locals()... */
            if (PyDict_CheckExact(LOCALS())) {
                ann_dict = _PyDict_GetItemWithError(LOCALS(),
                                                    &_Py_ID(__annotations__));
                if (ann_dict == NULL) {
                    if (_PyErr_Occurred(tstate)) goto error;
                    /* ...if not, create a new one */
                    ann_dict = PyDict_New();
                    if (ann_dict == NULL) goto error;
                    err = PyDict_SetItem(LOCALS(), &_Py_ID(__annotations__),
                                         ann_dict);
                    Py_DECREF(ann_dict);
                    if (err) goto error;
                }
            }
            else {
                /* do the same if locals() is not a dict */
                ann_dict = PyObject_GetItem(LOCALS(), &_Py_ID(__annotations__));
                if (ann_dict == NULL) {
                    if (!_PyErr_ExceptionMatches(tstate, PyExc_KeyError)) goto error;
                    _PyErr_Clear(tstate);
                    ann_dict = PyDict_New();
                    if (ann_dict == NULL) goto error;
                    err = PyObject_SetItem(LOCALS(), &_Py_ID(__annotations__),
                                           ann_dict);
                    Py_DECREF(ann_dict);
                    if (err) goto error;
                }
                else {
                    Py_DECREF(ann_dict);
                }
            }
            #line 2208 "Python/generated_cases.c.h"
            DISPATCH();
        }

        TARGET(BUILD_CONST_KEY_MAP) {
            PyObject *keys = stack_pointer[-1];
            PyObject **values = (stack_pointer - (1 + oparg));
            PyObject *map;
            #line 1535 "Python/bytecodes.c"
            if (!PyTuple_CheckExact(keys) ||
                PyTuple_GET_SIZE(keys) != (Py_ssize_t)oparg) {
                _PyErr_SetString(tstate, PyExc_SystemError,
                                 "bad BUILD_CONST_KEY_MAP keys argument");
                goto error;  // Pop the keys and values.
            }
            map = _PyDict_FromItems(
                    &PyTuple_GET_ITEM(keys, 0), 1,
                    values, 1, oparg);
            #line 2226 "Python/generated_cases.c.h"
            for (int _i = oparg; --_i >= 0;) {
                Py_DECREF(values[_i]);
            }
            Py_DECREF(keys);
            #line 1545 "Python/bytecodes.c"
            if (map == NULL) { STACK_SHRINK(oparg); goto pop_1_error; }
            #line 2233 "Python/generated_cases.c.h"
            STACK_SHRINK(oparg);
            stack_pointer[-1] = map;
            DISPATCH();
        }

        TARGET(DICT_UPDATE) {
            PyObject *update = stack_pointer[-1];
            #line 1549 "Python/bytecodes.c"
            PyObject *dict = PEEK(oparg + 1);  // update is still on the stack
            if (PyDict_Update(dict, update) < 0) {
                if (_PyErr_ExceptionMatches(tstate, PyExc_AttributeError)) {
                    _PyErr_Format(tstate, PyExc_TypeError,
                                    "'%.200s' object is not a mapping",
                                    Py_TYPE(update)->tp_name);
                }
            #line 2249 "Python/generated_cases.c.h"
                Py_DECREF(update);
            #line 1557 "Python/bytecodes.c"
                if (true) goto pop_1_error;
            }
            #line 2254 "Python/generated_cases.c.h"
            Py_DECREF(update);
            STACK_SHRINK(1);
            DISPATCH();
        }

        TARGET(DICT_MERGE) {
            PyObject *update = stack_pointer[-1];
            #line 1563 "Python/bytecodes.c"
            PyObject *dict = PEEK(oparg + 1);  // update is still on the stack

            if (_PyDict_MergeEx(dict, update, 2) < 0) {
                format_kwargs_error(tstate, PEEK(3 + oparg), update);
            #line 2267 "Python/generated_cases.c.h"
                Py_DECREF(update);
            #line 1568 "Python/bytecodes.c"
                if (true) goto pop_1_error;
            }
            #line 2272 "Python/generated_cases.c.h"
            Py_DECREF(update);
            STACK_SHRINK(1);
            PREDICT(CALL_FUNCTION_EX);
            DISPATCH();
        }

        TARGET(MAP_ADD) {
            PyObject *value = stack_pointer[-1];
            PyObject *key = stack_pointer[-2];
            #line 1575 "Python/bytecodes.c"
            PyObject *dict = PEEK(oparg + 2);  // key, value are still on the stack
            assert(PyDict_CheckExact(dict));
            /* dict[key] = value */
            // Do not DECREF INPUTS because the function steals the references
            if (_PyDict_SetItem_Take2((PyDictObject *)dict, key, value) != 0) goto pop_2_error;
            #line 2288 "Python/generated_cases.c.h"
            STACK_SHRINK(2);
            PREDICT(JUMP_BACKWARD);
            DISPATCH();
        }

        TARGET(INSTRUMENTED_LOAD_SUPER_ATTR) {
            #line 1584 "Python/bytecodes.c"
            _PySuperAttrCache *cache = (_PySuperAttrCache *)next_instr;
            // cancel out the decrement that will happen in LOAD_SUPER_ATTR; we
            // don't want to specialize instrumented instructions
            INCREMENT_ADAPTIVE_COUNTER(cache->counter);
            GO_TO_INSTRUCTION(LOAD_SUPER_ATTR);
            #line 2301 "Python/generated_cases.c.h"
        }

        TARGET(LOAD_SUPER_ATTR) {
            PREDICTED(LOAD_SUPER_ATTR);
            static_assert(INLINE_CACHE_ENTRIES_LOAD_SUPER_ATTR == 1, "incorrect cache size");
            PyObject *self = stack_pointer[-1];
            PyObject *class = stack_pointer[-2];
            PyObject *global_super = stack_pointer[-3];
            PyObject *res2 = NULL;
            PyObject *res;
            #line 1598 "Python/bytecodes.c"
            PyObject *name = GETITEM(frame->f_code->co_names, oparg >> 2);
            int load_method = oparg & 1;
            #if ENABLE_SPECIALIZATION
            _PySuperAttrCache *cache = (_PySuperAttrCache *)next_instr;
            if (ADAPTIVE_COUNTER_IS_ZERO(cache->counter)) {
                next_instr--;
                _Py_Specialize_LoadSuperAttr(global_super, class, next_instr, load_method);
                DISPATCH_SAME_OPARG();
            }
            STAT_INC(LOAD_SUPER_ATTR, deferred);
            DECREMENT_ADAPTIVE_COUNTER(cache->counter);
            #endif  /* ENABLE_SPECIALIZATION */

            if (opcode == INSTRUMENTED_LOAD_SUPER_ATTR) {
                PyObject *arg = oparg & 2 ? class : &_PyInstrumentation_MISSING;
                int err = _Py_call_instrumentation_2args(
                        tstate, PY_MONITORING_EVENT_CALL,
                        frame, next_instr-1, global_super, arg);
                if (err) goto pop_3_error;
            }

            // we make no attempt to optimize here; specializations should
            // handle any case whose performance we care about
            PyObject *stack[] = {class, self};
            PyObject *super = PyObject_Vectorcall(global_super, stack, oparg & 2, NULL);
            if (opcode == INSTRUMENTED_LOAD_SUPER_ATTR) {
                PyObject *arg = oparg & 2 ? class : &_PyInstrumentation_MISSING;
                if (super == NULL) {
                    _Py_call_instrumentation_exc2(
                        tstate, PY_MONITORING_EVENT_C_RAISE,
                        frame, next_instr-1, global_super, arg);
                }
                else {
                    int err = _Py_call_instrumentation_2args(
                        tstate, PY_MONITORING_EVENT_C_RETURN,
                        frame, next_instr-1, global_super, arg);
                    if (err < 0) {
                        Py_CLEAR(super);
                    }
                }
            }
            #line 2354 "Python/generated_cases.c.h"
            Py_DECREF(global_super);
            Py_DECREF(class);
            Py_DECREF(self);
            #line 1640 "Python/bytecodes.c"
            if (super == NULL) goto pop_3_error;
            res = PyObject_GetAttr(super, name);
            Py_DECREF(super);
            if (res == NULL) goto pop_3_error;
            #line 2363 "Python/generated_cases.c.h"
            STACK_SHRINK(2);
            STACK_GROW(((oparg & 1) ? 1 : 0));
            stack_pointer[-1] = res;
            if (oparg & 1) { stack_pointer[-(1 + ((oparg & 1) ? 1 : 0))] = res2; }
            next_instr += 1;
            DISPATCH();
        }

        TARGET(LOAD_SUPER_ATTR_ATTR) {
            PyObject *self = stack_pointer[-1];
            PyObject *class = stack_pointer[-2];
            PyObject *global_super = stack_pointer[-3];
            PyObject *res2 = NULL;
            PyObject *res;
            #line 1647 "Python/bytecodes.c"
            assert(!(oparg & 1));
            DEOPT_IF(global_super != (PyObject *)&PySuper_Type, LOAD_SUPER_ATTR);
            DEOPT_IF(!PyType_Check(class), LOAD_SUPER_ATTR);
            STAT_INC(LOAD_SUPER_ATTR, hit);
            PyObject *name = GETITEM(frame->f_code->co_names, oparg >> 2);
            res = _PySuper_Lookup((PyTypeObject *)class, self, name, NULL);
            #line 2385 "Python/generated_cases.c.h"
            Py_DECREF(global_super);
            Py_DECREF(class);
            Py_DECREF(self);
            #line 1654 "Python/bytecodes.c"
            if (res == NULL) goto pop_3_error;
            #line 2391 "Python/generated_cases.c.h"
            STACK_SHRINK(2);
            STACK_GROW(((oparg & 1) ? 1 : 0));
            stack_pointer[-1] = res;
            if (oparg & 1) { stack_pointer[-(1 + ((oparg & 1) ? 1 : 0))] = res2; }
            next_instr += 1;
            DISPATCH();
        }

        TARGET(LOAD_SUPER_ATTR_METHOD) {
            PyObject *self = stack_pointer[-1];
            PyObject *class = stack_pointer[-2];
            PyObject *global_super = stack_pointer[-3];
            PyObject *res2;
            PyObject *res;
            #line 1658 "Python/bytecodes.c"
            assert(oparg & 1);
            DEOPT_IF(global_super != (PyObject *)&PySuper_Type, LOAD_SUPER_ATTR);
            DEOPT_IF(!PyType_Check(class), LOAD_SUPER_ATTR);
            STAT_INC(LOAD_SUPER_ATTR, hit);
            PyObject *name = GETITEM(frame->f_code->co_names, oparg >> 2);
            int method_found = 0;
            res2 = _PySuper_Lookup((PyTypeObject *)class, self, name, &method_found);
            Py_DECREF(global_super);
            Py_DECREF(class);
            if (res2 == NULL) {
                Py_DECREF(self);
                if (true) goto pop_3_error;
            }
            if (method_found) {
                res = self; // transfer ownership
            } else {
                Py_DECREF(self);
                res = res2;
                res2 = NULL;
            }
            #line 2427 "Python/generated_cases.c.h"
            STACK_SHRINK(1);
            stack_pointer[-1] = res;
            stack_pointer[-2] = res2;
            next_instr += 1;
            DISPATCH();
        }

        TARGET(LOAD_ATTR) {
            PREDICTED(LOAD_ATTR);
            static_assert(INLINE_CACHE_ENTRIES_LOAD_ATTR == 9, "incorrect cache size");
            PyObject *owner = stack_pointer[-1];
            PyObject *res2 = NULL;
            PyObject *res;
            #line 1695 "Python/bytecodes.c"
            #if ENABLE_SPECIALIZATION
            _PyAttrCache *cache = (_PyAttrCache *)next_instr;
            if (ADAPTIVE_COUNTER_IS_ZERO(cache->counter)) {
                PyObject *name = GETITEM(frame->f_code->co_names, oparg>>1);
                next_instr--;
                _Py_Specialize_LoadAttr(owner, next_instr, name);
                DISPATCH_SAME_OPARG();
            }
            STAT_INC(LOAD_ATTR, deferred);
            DECREMENT_ADAPTIVE_COUNTER(cache->counter);
            #endif  /* ENABLE_SPECIALIZATION */
            PyObject *name = GETITEM(frame->f_code->co_names, oparg >> 1);
            if (oparg & 1) {
                /* Designed to work in tandem with CALL, pushes two values. */
                PyObject* meth = NULL;
                if (_PyObject_GetMethod(owner, name, &meth)) {
                    /* We can bypass temporary bound method object.
                       meth is unbound method and obj is self.

                       meth | self | arg1 | ... | argN
                     */
                    assert(meth != NULL);  // No errors on this branch
                    res2 = meth;
                    res = owner;  // Transfer ownership
                }
                else {
                    /* meth is not an unbound method (but a regular attr, or
                       something was returned by a descriptor protocol).  Set
                       the second element of the stack to NULL, to signal
                       CALL that it's not a method call.

                       NULL | meth | arg1 | ... | argN
                    */
            #line 2475 "Python/generated_cases.c.h"
                    Py_DECREF(owner);
            #line 1729 "Python/bytecodes.c"
                    if (meth == NULL) goto pop_1_error;
                    res2 = NULL;
                    res = meth;
                }
            }
            else {
                /* Classic, pushes one value. */
                res = PyObject_GetAttr(owner, name);
            #line 2486 "Python/generated_cases.c.h"
                Py_DECREF(owner);
            #line 1738 "Python/bytecodes.c"
                if (res == NULL) goto pop_1_error;
            }
            #line 2491 "Python/generated_cases.c.h"
            STACK_GROW(((oparg & 1) ? 1 : 0));
            stack_pointer[-1] = res;
            if (oparg & 1) { stack_pointer[-(1 + ((oparg & 1) ? 1 : 0))] = res2; }
            next_instr += 9;
            DISPATCH();
        }

        TARGET(LOAD_ATTR_INSTANCE_VALUE) {
            PyObject *owner = stack_pointer[-1];
            PyObject *res2 = NULL;
            PyObject *res;
            uint32_t type_version = read_u32(&next_instr[1].cache);
            uint16_t index = read_u16(&next_instr[3].cache);
            #line 1743 "Python/bytecodes.c"
            PyTypeObject *tp = Py_TYPE(owner);
            assert(type_version != 0);
            DEOPT_IF(tp->tp_version_tag != type_version, LOAD_ATTR);
            assert(tp->tp_dictoffset < 0);
            assert(tp->tp_flags & Py_TPFLAGS_MANAGED_DICT);
            PyDictOrValues dorv = *_PyObject_DictOrValuesPointer(owner);
            DEOPT_IF(!_PyDictOrValues_IsValues(dorv), LOAD_ATTR);
            res = _PyDictOrValues_GetValues(dorv)->values[index];
            DEOPT_IF(res == NULL, LOAD_ATTR);
            STAT_INC(LOAD_ATTR, hit);
            Py_INCREF(res);
            res2 = NULL;
            #line 2518 "Python/generated_cases.c.h"
            Py_DECREF(owner);
            STACK_GROW(((oparg & 1) ? 1 : 0));
            stack_pointer[-1] = res;
            if (oparg & 1) { stack_pointer[-(1 + ((oparg & 1) ? 1 : 0))] = res2; }
            next_instr += 9;
            DISPATCH();
        }

        TARGET(LOAD_ATTR_MODULE) {
            PyObject *owner = stack_pointer[-1];
            PyObject *res2 = NULL;
            PyObject *res;
            uint32_t type_version = read_u32(&next_instr[1].cache);
            uint16_t index = read_u16(&next_instr[3].cache);
            #line 1759 "Python/bytecodes.c"
            DEOPT_IF(!PyModule_CheckExact(owner), LOAD_ATTR);
            PyDictObject *dict = (PyDictObject *)((PyModuleObject *)owner)->md_dict;
            assert(dict != NULL);
            DEOPT_IF(dict->ma_keys->dk_version != type_version, LOAD_ATTR);
            assert(dict->ma_keys->dk_kind == DICT_KEYS_UNICODE);
            assert(index < dict->ma_keys->dk_nentries);
            PyDictUnicodeEntry *ep = DK_UNICODE_ENTRIES(dict->ma_keys) + index;
            res = ep->me_value;
            DEOPT_IF(res == NULL, LOAD_ATTR);
            STAT_INC(LOAD_ATTR, hit);
            Py_INCREF(res);
            res2 = NULL;
            #line 2546 "Python/generated_cases.c.h"
            Py_DECREF(owner);
            STACK_GROW(((oparg & 1) ? 1 : 0));
            stack_pointer[-1] = res;
            if (oparg & 1) { stack_pointer[-(1 + ((oparg & 1) ? 1 : 0))] = res2; }
            next_instr += 9;
            DISPATCH();
        }

        TARGET(LOAD_ATTR_WITH_HINT) {
            PyObject *owner = stack_pointer[-1];
            PyObject *res2 = NULL;
            PyObject *res;
            uint32_t type_version = read_u32(&next_instr[1].cache);
            uint16_t index = read_u16(&next_instr[3].cache);
            #line 1775 "Python/bytecodes.c"
            PyTypeObject *tp = Py_TYPE(owner);
            assert(type_version != 0);
            DEOPT_IF(tp->tp_version_tag != type_version, LOAD_ATTR);
            assert(tp->tp_flags & Py_TPFLAGS_MANAGED_DICT);
            PyDictOrValues dorv = *_PyObject_DictOrValuesPointer(owner);
            DEOPT_IF(_PyDictOrValues_IsValues(dorv), LOAD_ATTR);
            PyDictObject *dict = (PyDictObject *)_PyDictOrValues_GetDict(dorv);
            DEOPT_IF(dict == NULL, LOAD_ATTR);
            assert(PyDict_CheckExact((PyObject *)dict));
            PyObject *name = GETITEM(frame->f_code->co_names, oparg>>1);
            uint16_t hint = index;
            DEOPT_IF(hint >= (size_t)dict->ma_keys->dk_nentries, LOAD_ATTR);
            if (DK_IS_UNICODE(dict->ma_keys)) {
                PyDictUnicodeEntry *ep = DK_UNICODE_ENTRIES(dict->ma_keys) + hint;
                DEOPT_IF(ep->me_key != name, LOAD_ATTR);
                res = ep->me_value;
            }
            else {
                PyDictKeyEntry *ep = DK_ENTRIES(dict->ma_keys) + hint;
                DEOPT_IF(ep->me_key != name, LOAD_ATTR);
                res = ep->me_value;
            }
            DEOPT_IF(res == NULL, LOAD_ATTR);
            STAT_INC(LOAD_ATTR, hit);
            Py_INCREF(res);
            res2 = NULL;
            #line 2588 "Python/generated_cases.c.h"
            Py_DECREF(owner);
            STACK_GROW(((oparg & 1) ? 1 : 0));
            stack_pointer[-1] = res;
            if (oparg & 1) { stack_pointer[-(1 + ((oparg & 1) ? 1 : 0))] = res2; }
            next_instr += 9;
            DISPATCH();
        }

        TARGET(LOAD_ATTR_SLOT) {
            PyObject *owner = stack_pointer[-1];
            PyObject *res2 = NULL;
            PyObject *res;
            uint32_t type_version = read_u32(&next_instr[1].cache);
            uint16_t index = read_u16(&next_instr[3].cache);
            #line 1805 "Python/bytecodes.c"
            PyTypeObject *tp = Py_TYPE(owner);
            assert(type_version != 0);
            DEOPT_IF(tp->tp_version_tag != type_version, LOAD_ATTR);
            char *addr = (char *)owner + index;
            res = *(PyObject **)addr;
            DEOPT_IF(res == NULL, LOAD_ATTR);
            STAT_INC(LOAD_ATTR, hit);
            Py_INCREF(res);
            res2 = NULL;
            #line 2613 "Python/generated_cases.c.h"
            Py_DECREF(owner);
            STACK_GROW(((oparg & 1) ? 1 : 0));
            stack_pointer[-1] = res;
            if (oparg & 1) { stack_pointer[-(1 + ((oparg & 1) ? 1 : 0))] = res2; }
            next_instr += 9;
            DISPATCH();
        }

        TARGET(LOAD_ATTR_CLASS) {
            PyObject *cls = stack_pointer[-1];
            PyObject *res2 = NULL;
            PyObject *res;
            uint32_t type_version = read_u32(&next_instr[1].cache);
            PyObject *descr = read_obj(&next_instr[5].cache);
            #line 1818 "Python/bytecodes.c"

            DEOPT_IF(!PyType_Check(cls), LOAD_ATTR);
            DEOPT_IF(((PyTypeObject *)cls)->tp_version_tag != type_version,
                LOAD_ATTR);
            assert(type_version != 0);

            STAT_INC(LOAD_ATTR, hit);
            res2 = NULL;
            res = descr;
            assert(res != NULL);
            Py_INCREF(res);
            #line 2640 "Python/generated_cases.c.h"
            Py_DECREF(cls);
            STACK_GROW(((oparg & 1) ? 1 : 0));
            stack_pointer[-1] = res;
            if (oparg & 1) { stack_pointer[-(1 + ((oparg & 1) ? 1 : 0))] = res2; }
            next_instr += 9;
            DISPATCH();
        }

        TARGET(LOAD_ATTR_PROPERTY) {
            PyObject *owner = stack_pointer[-1];
            uint32_t type_version = read_u32(&next_instr[1].cache);
            uint32_t func_version = read_u32(&next_instr[3].cache);
            PyObject *fget = read_obj(&next_instr[5].cache);
            #line 1833 "Python/bytecodes.c"
            DEOPT_IF(tstate->interp->eval_frame, LOAD_ATTR);

            PyTypeObject *cls = Py_TYPE(owner);
            DEOPT_IF(cls->tp_version_tag != type_version, LOAD_ATTR);
            assert(type_version != 0);
            assert(Py_IS_TYPE(fget, &PyFunction_Type));
            PyFunctionObject *f = (PyFunctionObject *)fget;
            assert(func_version != 0);
            DEOPT_IF(f->func_version != func_version, LOAD_ATTR);
            PyCodeObject *code = (PyCodeObject *)f->func_code;
            assert(code->co_argcount == 1);
            DEOPT_IF(!_PyThreadState_HasStackSpace(tstate, code->co_framesize), LOAD_ATTR);
            STAT_INC(LOAD_ATTR, hit);
            Py_INCREF(fget);
            _PyInterpreterFrame *new_frame = _PyFrame_PushUnchecked(tstate, f, 1);
            // Manipulate stack directly because we exit with DISPATCH_INLINED().
            SET_TOP(NULL);
            int shrink_stack = !(oparg & 1);
            STACK_SHRINK(shrink_stack);
            new_frame->localsplus[0] = owner;
            JUMPBY(INLINE_CACHE_ENTRIES_LOAD_ATTR);
            frame->return_offset = 0;
            DISPATCH_INLINED(new_frame);
            #line 2678 "Python/generated_cases.c.h"
        }

        TARGET(LOAD_ATTR_GETATTRIBUTE_OVERRIDDEN) {
            PyObject *owner = stack_pointer[-1];
            uint32_t type_version = read_u32(&next_instr[1].cache);
            uint32_t func_version = read_u32(&next_instr[3].cache);
            PyObject *getattribute = read_obj(&next_instr[5].cache);
            #line 1859 "Python/bytecodes.c"
            DEOPT_IF(tstate->interp->eval_frame, LOAD_ATTR);
            PyTypeObject *cls = Py_TYPE(owner);
            DEOPT_IF(cls->tp_version_tag != type_version, LOAD_ATTR);
            assert(type_version != 0);
            assert(Py_IS_TYPE(getattribute, &PyFunction_Type));
            PyFunctionObject *f = (PyFunctionObject *)getattribute;
            assert(func_version != 0);
            DEOPT_IF(f->func_version != func_version, LOAD_ATTR);
            PyCodeObject *code = (PyCodeObject *)f->func_code;
            assert(code->co_argcount == 2);
            DEOPT_IF(!_PyThreadState_HasStackSpace(tstate, code->co_framesize), LOAD_ATTR);
            STAT_INC(LOAD_ATTR, hit);

            PyObject *name = GETITEM(frame->f_code->co_names, oparg >> 1);
            Py_INCREF(f);
            _PyInterpreterFrame *new_frame = _PyFrame_PushUnchecked(tstate, f, 2);
            // Manipulate stack directly because we exit with DISPATCH_INLINED().
            SET_TOP(NULL);
            int shrink_stack = !(oparg & 1);
            STACK_SHRINK(shrink_stack);
            new_frame->localsplus[0] = owner;
            new_frame->localsplus[1] = Py_NewRef(name);
            JUMPBY(INLINE_CACHE_ENTRIES_LOAD_ATTR);
            frame->return_offset = 0;
            DISPATCH_INLINED(new_frame);
            #line 2712 "Python/generated_cases.c.h"
        }

        TARGET(STORE_ATTR_INSTANCE_VALUE) {
            PyObject *owner = stack_pointer[-1];
            PyObject *value = stack_pointer[-2];
            uint32_t type_version = read_u32(&next_instr[1].cache);
            uint16_t index = read_u16(&next_instr[3].cache);
            #line 1887 "Python/bytecodes.c"
            PyTypeObject *tp = Py_TYPE(owner);
            assert(type_version != 0);
            DEOPT_IF(tp->tp_version_tag != type_version, STORE_ATTR);
            assert(tp->tp_flags & Py_TPFLAGS_MANAGED_DICT);
            PyDictOrValues dorv = *_PyObject_DictOrValuesPointer(owner);
            DEOPT_IF(!_PyDictOrValues_IsValues(dorv), STORE_ATTR);
            STAT_INC(STORE_ATTR, hit);
            PyDictValues *values = _PyDictOrValues_GetValues(dorv);
            PyObject *old_value = values->values[index];
            values->values[index] = value;
            if (old_value == NULL) {
                _PyDictValues_AddToInsertionOrder(values, index);
            }
            else {
                Py_DECREF(old_value);
            }
            Py_DECREF(owner);
            #line 2738 "Python/generated_cases.c.h"
            STACK_SHRINK(2);
            next_instr += 4;
            DISPATCH();
        }

        TARGET(STORE_ATTR_WITH_HINT) {
            PyObject *owner = stack_pointer[-1];
            PyObject *value = stack_pointer[-2];
            uint32_t type_version = read_u32(&next_instr[1].cache);
            uint16_t hint = read_u16(&next_instr[3].cache);
            #line 1907 "Python/bytecodes.c"
            PyTypeObject *tp = Py_TYPE(owner);
            assert(type_version != 0);
            DEOPT_IF(tp->tp_version_tag != type_version, STORE_ATTR);
            assert(tp->tp_flags & Py_TPFLAGS_MANAGED_DICT);
            PyDictOrValues dorv = *_PyObject_DictOrValuesPointer(owner);
            DEOPT_IF(_PyDictOrValues_IsValues(dorv), STORE_ATTR);
            PyDictObject *dict = (PyDictObject *)_PyDictOrValues_GetDict(dorv);
            DEOPT_IF(dict == NULL, STORE_ATTR);
            assert(PyDict_CheckExact((PyObject *)dict));
            PyObject *name = GETITEM(frame->f_code->co_names, oparg);
            DEOPT_IF(hint >= (size_t)dict->ma_keys->dk_nentries, STORE_ATTR);
            PyObject *old_value;
            uint64_t new_version;
            if (DK_IS_UNICODE(dict->ma_keys)) {
                PyDictUnicodeEntry *ep = DK_UNICODE_ENTRIES(dict->ma_keys) + hint;
                DEOPT_IF(ep->me_key != name, STORE_ATTR);
                old_value = ep->me_value;
                DEOPT_IF(old_value == NULL, STORE_ATTR);
                new_version = _PyDict_NotifyEvent(tstate->interp, PyDict_EVENT_MODIFIED, dict, name, value);
                ep->me_value = value;
            }
            else {
                PyDictKeyEntry *ep = DK_ENTRIES(dict->ma_keys) + hint;
                DEOPT_IF(ep->me_key != name, STORE_ATTR);
                old_value = ep->me_value;
                DEOPT_IF(old_value == NULL, STORE_ATTR);
                new_version = _PyDict_NotifyEvent(tstate->interp, PyDict_EVENT_MODIFIED, dict, name, value);
                ep->me_value = value;
            }
            Py_DECREF(old_value);
            STAT_INC(STORE_ATTR, hit);
            /* Ensure dict is GC tracked if it needs to be */
            if (!_PyObject_GC_IS_TRACKED(dict) && _PyObject_GC_MAY_BE_TRACKED(value)) {
                _PyObject_GC_TRACK(dict);
            }
            /* PEP 509 */
            dict->ma_version_tag = new_version;
            Py_DECREF(owner);
            #line 2788 "Python/generated_cases.c.h"
            STACK_SHRINK(2);
            next_instr += 4;
            DISPATCH();
        }

        TARGET(STORE_ATTR_SLOT) {
            PyObject *owner = stack_pointer[-1];
            PyObject *value = stack_pointer[-2];
            uint32_t type_version = read_u32(&next_instr[1].cache);
            uint16_t index = read_u16(&next_instr[3].cache);
            #line 1948 "Python/bytecodes.c"
            PyTypeObject *tp = Py_TYPE(owner);
            assert(type_version != 0);
            DEOPT_IF(tp->tp_version_tag != type_version, STORE_ATTR);
            char *addr = (char *)owner + index;
            STAT_INC(STORE_ATTR, hit);
            PyObject *old_value = *(PyObject **)addr;
            *(PyObject **)addr = value;
            Py_XDECREF(old_value);
            Py_DECREF(owner);
            #line 2809 "Python/generated_cases.c.h"
            STACK_SHRINK(2);
            next_instr += 4;
            DISPATCH();
        }

        TARGET(COMPARE_OP) {
            PREDICTED(COMPARE_OP);
            static_assert(INLINE_CACHE_ENTRIES_COMPARE_OP == 1, "incorrect cache size");
            PyObject *right = stack_pointer[-1];
            PyObject *left = stack_pointer[-2];
            PyObject *res;
            #line 1967 "Python/bytecodes.c"
            #if ENABLE_SPECIALIZATION
            _PyCompareOpCache *cache = (_PyCompareOpCache *)next_instr;
            if (ADAPTIVE_COUNTER_IS_ZERO(cache->counter)) {
                next_instr--;
                _Py_Specialize_CompareOp(left, right, next_instr, oparg);
                DISPATCH_SAME_OPARG();
            }
            STAT_INC(COMPARE_OP, deferred);
            DECREMENT_ADAPTIVE_COUNTER(cache->counter);
            #endif  /* ENABLE_SPECIALIZATION */
            assert((oparg >> 4) <= Py_GE);
            res = PyObject_RichCompare(left, right, oparg>>4);
            #line 2834 "Python/generated_cases.c.h"
            Py_DECREF(left);
            Py_DECREF(right);
            #line 1980 "Python/bytecodes.c"
            if (res == NULL) goto pop_2_error;
            #line 2839 "Python/generated_cases.c.h"
            STACK_SHRINK(1);
            stack_pointer[-1] = res;
            next_instr += 1;
            DISPATCH();
        }

        TARGET(COMPARE_OP_FLOAT) {
            PyObject *right = stack_pointer[-1];
            PyObject *left = stack_pointer[-2];
            PyObject *res;
            #line 1984 "Python/bytecodes.c"
            DEOPT_IF(!PyFloat_CheckExact(left), COMPARE_OP);
            DEOPT_IF(!PyFloat_CheckExact(right), COMPARE_OP);
            STAT_INC(COMPARE_OP, hit);
            double dleft = PyFloat_AS_DOUBLE(left);
            double dright = PyFloat_AS_DOUBLE(right);
            // 1 if NaN, 2 if <, 4 if >, 8 if ==; this matches low four bits of the oparg
            int sign_ish = COMPARISON_BIT(dleft, dright);
            _Py_DECREF_SPECIALIZED(left, _PyFloat_ExactDealloc);
            _Py_DECREF_SPECIALIZED(right, _PyFloat_ExactDealloc);
            res = (sign_ish & oparg) ? Py_True : Py_False;
            #line 2861 "Python/generated_cases.c.h"
            STACK_SHRINK(1);
            stack_pointer[-1] = res;
            next_instr += 1;
            DISPATCH();
        }

        TARGET(COMPARE_OP_INT) {
            PyObject *right = stack_pointer[-1];
            PyObject *left = stack_pointer[-2];
            PyObject *res;
            #line 1998 "Python/bytecodes.c"
            DEOPT_IF(!PyLong_CheckExact(left), COMPARE_OP);
            DEOPT_IF(!PyLong_CheckExact(right), COMPARE_OP);
            DEOPT_IF(!_PyLong_IsCompact((PyLongObject *)left), COMPARE_OP);
            DEOPT_IF(!_PyLong_IsCompact((PyLongObject *)right), COMPARE_OP);
            STAT_INC(COMPARE_OP, hit);
            assert(_PyLong_DigitCount((PyLongObject *)left) <= 1 &&
                   _PyLong_DigitCount((PyLongObject *)right) <= 1);
            Py_ssize_t ileft = _PyLong_CompactValue((PyLongObject *)left);
            Py_ssize_t iright = _PyLong_CompactValue((PyLongObject *)right);
            // 2 if <, 4 if >, 8 if ==; this matches the low 4 bits of the oparg
            int sign_ish = COMPARISON_BIT(ileft, iright);
            _Py_DECREF_SPECIALIZED(left, (destructor)PyObject_Free);
            _Py_DECREF_SPECIALIZED(right, (destructor)PyObject_Free);
            res = (sign_ish & oparg) ? Py_True : Py_False;
            #line 2887 "Python/generated_cases.c.h"
            STACK_SHRINK(1);
            stack_pointer[-1] = res;
            next_instr += 1;
            DISPATCH();
        }

        TARGET(COMPARE_OP_STR) {
            PyObject *right = stack_pointer[-1];
            PyObject *left = stack_pointer[-2];
            PyObject *res;
            #line 2016 "Python/bytecodes.c"
            DEOPT_IF(!PyUnicode_CheckExact(left), COMPARE_OP);
            DEOPT_IF(!PyUnicode_CheckExact(right), COMPARE_OP);
            STAT_INC(COMPARE_OP, hit);
            int eq = _PyUnicode_Equal(left, right);
            assert((oparg >>4) == Py_EQ || (oparg >>4) == Py_NE);
            _Py_DECREF_SPECIALIZED(left, _PyUnicode_ExactDealloc);
            _Py_DECREF_SPECIALIZED(right, _PyUnicode_ExactDealloc);
            assert(eq == 0 || eq == 1);
            assert((oparg & 0xf) == COMPARISON_NOT_EQUALS || (oparg & 0xf) == COMPARISON_EQUALS);
            assert(COMPARISON_NOT_EQUALS + 1 == COMPARISON_EQUALS);
            res = ((COMPARISON_NOT_EQUALS + eq) & oparg) ? Py_True : Py_False;
            #line 2910 "Python/generated_cases.c.h"
            STACK_SHRINK(1);
            stack_pointer[-1] = res;
            next_instr += 1;
            DISPATCH();
        }

        TARGET(IS_OP) {
            PyObject *right = stack_pointer[-1];
            PyObject *left = stack_pointer[-2];
            PyObject *b;
            #line 2030 "Python/bytecodes.c"
            int res = Py_Is(left, right) ^ oparg;
            #line 2923 "Python/generated_cases.c.h"
            Py_DECREF(left);
            Py_DECREF(right);
            #line 2032 "Python/bytecodes.c"
            b = res ? Py_True : Py_False;
            #line 2928 "Python/generated_cases.c.h"
            STACK_SHRINK(1);
            stack_pointer[-1] = b;
            DISPATCH();
        }

        TARGET(CONTAINS_OP) {
            PyObject *right = stack_pointer[-1];
            PyObject *left = stack_pointer[-2];
            PyObject *b;
            #line 2036 "Python/bytecodes.c"
            int res = PySequence_Contains(right, left);
            #line 2940 "Python/generated_cases.c.h"
            Py_DECREF(left);
            Py_DECREF(right);
            #line 2038 "Python/bytecodes.c"
            if (res < 0) goto pop_2_error;
            b = (res ^ oparg) ? Py_True : Py_False;
            #line 2946 "Python/generated_cases.c.h"
            STACK_SHRINK(1);
            stack_pointer[-1] = b;
            DISPATCH();
        }

        TARGET(CHECK_EG_MATCH) {
            PyObject *match_type = stack_pointer[-1];
            PyObject *exc_value = stack_pointer[-2];
            PyObject *rest;
            PyObject *match;
            #line 2043 "Python/bytecodes.c"
            if (check_except_star_type_valid(tstate, match_type) < 0) {
            #line 2959 "Python/generated_cases.c.h"
                Py_DECREF(exc_value);
                Py_DECREF(match_type);
            #line 2045 "Python/bytecodes.c"
                if (true) goto pop_2_error;
            }

            match = NULL;
            rest = NULL;
            int res = exception_group_match(exc_value, match_type,
                                            &match, &rest);
            #line 2970 "Python/generated_cases.c.h"
            Py_DECREF(exc_value);
            Py_DECREF(match_type);
            #line 2053 "Python/bytecodes.c"
            if (res < 0) goto pop_2_error;

            assert((match == NULL) == (rest == NULL));
            if (match == NULL) goto pop_2_error;

            if (!Py_IsNone(match)) {
                PyErr_SetHandledException(match);
            }
            #line 2982 "Python/generated_cases.c.h"
            stack_pointer[-1] = match;
            stack_pointer[-2] = rest;
            DISPATCH();
        }

        TARGET(CHECK_EXC_MATCH) {
            PyObject *right = stack_pointer[-1];
            PyObject *left = stack_pointer[-2];
            PyObject *b;
            #line 2064 "Python/bytecodes.c"
            assert(PyExceptionInstance_Check(left));
            if (check_except_type_valid(tstate, right) < 0) {
            #line 2995 "Python/generated_cases.c.h"
                 Py_DECREF(right);
            #line 2067 "Python/bytecodes.c"
                 if (true) goto pop_1_error;
            }

            int res = PyErr_GivenExceptionMatches(left, right);
            #line 3002 "Python/generated_cases.c.h"
            Py_DECREF(right);
            #line 2072 "Python/bytecodes.c"
            b = res ? Py_True : Py_False;
            #line 3006 "Python/generated_cases.c.h"
            stack_pointer[-1] = b;
            DISPATCH();
        }

        TARGET(IMPORT_NAME) {
            PyObject *fromlist = stack_pointer[-1];
            PyObject *level = stack_pointer[-2];
            PyObject *res;
            #line 2076 "Python/bytecodes.c"
            PyObject *name = GETITEM(frame->f_code->co_names, oparg);
            res = import_name(tstate, frame, name, fromlist, level);
            #line 3018 "Python/generated_cases.c.h"
            Py_DECREF(level);
            Py_DECREF(fromlist);
            #line 2079 "Python/bytecodes.c"
            if (res == NULL) goto pop_2_error;
            #line 3023 "Python/generated_cases.c.h"
            STACK_SHRINK(1);
            stack_pointer[-1] = res;
            DISPATCH();
        }

        TARGET(IMPORT_FROM) {
            PyObject *from = stack_pointer[-1];
            PyObject *res;
            #line 2083 "Python/bytecodes.c"
            PyObject *name = GETITEM(frame->f_code->co_names, oparg);
            res = import_from(tstate, from, name);
            if (res == NULL) goto error;
            #line 3036 "Python/generated_cases.c.h"
            STACK_GROW(1);
            stack_pointer[-1] = res;
            DISPATCH();
        }

        TARGET(JUMP_FORWARD) {
            #line 2089 "Python/bytecodes.c"
            JUMPBY(oparg);
            #line 3045 "Python/generated_cases.c.h"
            DISPATCH();
        }

        TARGET(JUMP_BACKWARD) {
            PREDICTED(JUMP_BACKWARD);
            #line 2093 "Python/bytecodes.c"
            assert(oparg < INSTR_OFFSET());
            JUMPBY(-oparg);
            #line 3054 "Python/generated_cases.c.h"
            CHECK_EVAL_BREAKER();
            DISPATCH();
        }

        TARGET(POP_JUMP_IF_FALSE) {
            PREDICTED(POP_JUMP_IF_FALSE);
            PyObject *cond = stack_pointer[-1];
            #line 2099 "Python/bytecodes.c"
            if (Py_IsFalse(cond)) {
                JUMPBY(oparg);
            }
            else if (!Py_IsTrue(cond)) {
                int err = PyObject_IsTrue(cond);
            #line 3068 "Python/generated_cases.c.h"
                Py_DECREF(cond);
            #line 2105 "Python/bytecodes.c"
                if (err == 0) {
                    JUMPBY(oparg);
                }
                else {
                    if (err < 0) goto pop_1_error;
                }
            }
            #line 3078 "Python/generated_cases.c.h"
            STACK_SHRINK(1);
            DISPATCH();
        }

        TARGET(POP_JUMP_IF_TRUE) {
            PyObject *cond = stack_pointer[-1];
            #line 2115 "Python/bytecodes.c"
            if (Py_IsTrue(cond)) {
                JUMPBY(oparg);
            }
            else if (!Py_IsFalse(cond)) {
                int err = PyObject_IsTrue(cond);
            #line 3091 "Python/generated_cases.c.h"
                Py_DECREF(cond);
            #line 2121 "Python/bytecodes.c"
                if (err > 0) {
                    JUMPBY(oparg);
                }
                else {
                    if (err < 0) goto pop_1_error;
                }
            }
            #line 3101 "Python/generated_cases.c.h"
            STACK_SHRINK(1);
            DISPATCH();
        }

        TARGET(POP_JUMP_IF_NOT_NONE) {
            PyObject *value = stack_pointer[-1];
            #line 2131 "Python/bytecodes.c"
            if (!Py_IsNone(value)) {
            #line 3110 "Python/generated_cases.c.h"
                Py_DECREF(value);
            #line 2133 "Python/bytecodes.c"
                JUMPBY(oparg);
            }
            #line 3115 "Python/generated_cases.c.h"
            STACK_SHRINK(1);
            DISPATCH();
        }

        TARGET(POP_JUMP_IF_NONE) {
            PyObject *value = stack_pointer[-1];
            #line 2138 "Python/bytecodes.c"
            if (Py_IsNone(value)) {
                JUMPBY(oparg);
            }
            else {
            #line 3127 "Python/generated_cases.c.h"
                Py_DECREF(value);
            #line 2143 "Python/bytecodes.c"
            }
            #line 3131 "Python/generated_cases.c.h"
            STACK_SHRINK(1);
            DISPATCH();
        }

        TARGET(JUMP_BACKWARD_NO_INTERRUPT) {
            #line 2147 "Python/bytecodes.c"
            /* This bytecode is used in the `yield from` or `await` loop.
             * If there is an interrupt, we want it handled in the innermost
             * generator or coroutine, so we deliberately do not check it here.
             * (see bpo-30039).
             */
            JUMPBY(-oparg);
            #line 3144 "Python/generated_cases.c.h"
            DISPATCH();
        }

        TARGET(GET_LEN) {
            PyObject *obj = stack_pointer[-1];
            PyObject *len_o;
            #line 2156 "Python/bytecodes.c"
            // PUSH(len(TOS))
            Py_ssize_t len_i = PyObject_Length(obj);
            if (len_i < 0) goto error;
            len_o = PyLong_FromSsize_t(len_i);
            if (len_o == NULL) goto error;
            #line 3157 "Python/generated_cases.c.h"
            STACK_GROW(1);
            stack_pointer[-1] = len_o;
            DISPATCH();
        }

        TARGET(MATCH_CLASS) {
            PyObject *names = stack_pointer[-1];
            PyObject *type = stack_pointer[-2];
            PyObject *subject = stack_pointer[-3];
            PyObject *attrs;
            #line 2164 "Python/bytecodes.c"
            // Pop TOS and TOS1. Set TOS to a tuple of attributes on success, or
            // None on failure.
            assert(PyTuple_CheckExact(names));
            attrs = match_class(tstate, subject, type, oparg, names);
            #line 3173 "Python/generated_cases.c.h"
            Py_DECREF(subject);
            Py_DECREF(type);
            Py_DECREF(names);
            #line 2169 "Python/bytecodes.c"
            if (attrs) {
                assert(PyTuple_CheckExact(attrs));  // Success!
            }
            else {
                if (_PyErr_Occurred(tstate)) goto pop_3_error;
                attrs = Py_None;  // Failure!
            }
            #line 3185 "Python/generated_cases.c.h"
            STACK_SHRINK(2);
            stack_pointer[-1] = attrs;
            DISPATCH();
        }

        TARGET(MATCH_MAPPING) {
            PyObject *subject = stack_pointer[-1];
            PyObject *res;
            #line 2179 "Python/bytecodes.c"
            int match = Py_TYPE(subject)->tp_flags & Py_TPFLAGS_MAPPING;
            res = match ? Py_True : Py_False;
            #line 3197 "Python/generated_cases.c.h"
            STACK_GROW(1);
            stack_pointer[-1] = res;
            PREDICT(POP_JUMP_IF_FALSE);
            DISPATCH();
        }

        TARGET(MATCH_SEQUENCE) {
            PyObject *subject = stack_pointer[-1];
            PyObject *res;
            #line 2185 "Python/bytecodes.c"
            int match = Py_TYPE(subject)->tp_flags & Py_TPFLAGS_SEQUENCE;
            res = match ? Py_True : Py_False;
            #line 3210 "Python/generated_cases.c.h"
            STACK_GROW(1);
            stack_pointer[-1] = res;
            PREDICT(POP_JUMP_IF_FALSE);
            DISPATCH();
        }

        TARGET(MATCH_KEYS) {
            PyObject *keys = stack_pointer[-1];
            PyObject *subject = stack_pointer[-2];
            PyObject *values_or_none;
            #line 2191 "Python/bytecodes.c"
            // On successful match, PUSH(values). Otherwise, PUSH(None).
            values_or_none = match_keys(tstate, subject, keys);
            if (values_or_none == NULL) goto error;
            #line 3225 "Python/generated_cases.c.h"
            STACK_GROW(1);
            stack_pointer[-1] = values_or_none;
            DISPATCH();
        }

        TARGET(GET_ITER) {
            PyObject *iterable = stack_pointer[-1];
            PyObject *iter;
            #line 2197 "Python/bytecodes.c"
            /* before: [obj]; after [getiter(obj)] */
            iter = PyObject_GetIter(iterable);
            #line 3237 "Python/generated_cases.c.h"
            Py_DECREF(iterable);
            #line 2200 "Python/bytecodes.c"
            if (iter == NULL) goto pop_1_error;
            #line 3241 "Python/generated_cases.c.h"
            stack_pointer[-1] = iter;
            DISPATCH();
        }

        TARGET(GET_YIELD_FROM_ITER) {
            PyObject *iterable = stack_pointer[-1];
            PyObject *iter;
            #line 2204 "Python/bytecodes.c"
            /* before: [obj]; after [getiter(obj)] */
            if (PyCoro_CheckExact(iterable)) {
                /* `iterable` is a coroutine */
                if (!(frame->f_code->co_flags & (CO_COROUTINE | CO_ITERABLE_COROUTINE))) {
                    /* and it is used in a 'yield from' expression of a
                       regular generator. */
                    _PyErr_SetString(tstate, PyExc_TypeError,
                                     "cannot 'yield from' a coroutine object "
                                     "in a non-coroutine generator");
                    goto error;
                }
                iter = iterable;
            }
            else if (PyGen_CheckExact(iterable)) {
                iter = iterable;
            }
            else {
                /* `iterable` is not a generator. */
                iter = PyObject_GetIter(iterable);
                if (iter == NULL) {
                    goto error;
                }
            #line 3272 "Python/generated_cases.c.h"
                Py_DECREF(iterable);
            #line 2227 "Python/bytecodes.c"
            }
            #line 3276 "Python/generated_cases.c.h"
            stack_pointer[-1] = iter;
            PREDICT(LOAD_CONST);
            DISPATCH();
        }

        TARGET(FOR_ITER) {
            PREDICTED(FOR_ITER);
            static_assert(INLINE_CACHE_ENTRIES_FOR_ITER == 1, "incorrect cache size");
            PyObject *iter = stack_pointer[-1];
            PyObject *next;
            #line 2246 "Python/bytecodes.c"
            #if ENABLE_SPECIALIZATION
            _PyForIterCache *cache = (_PyForIterCache *)next_instr;
            if (ADAPTIVE_COUNTER_IS_ZERO(cache->counter)) {
                next_instr--;
                _Py_Specialize_ForIter(iter, next_instr, oparg);
                DISPATCH_SAME_OPARG();
            }
            STAT_INC(FOR_ITER, deferred);
            DECREMENT_ADAPTIVE_COUNTER(cache->counter);
            #endif  /* ENABLE_SPECIALIZATION */
            /* before: [iter]; after: [iter, iter()] *or* [] (and jump over END_FOR.) */
            next = (*Py_TYPE(iter)->tp_iternext)(iter);
            if (next == NULL) {
                if (_PyErr_Occurred(tstate)) {
                    if (!_PyErr_ExceptionMatches(tstate, PyExc_StopIteration)) {
                        goto error;
                    }
                    monitor_raise(tstate, frame, next_instr-1);
                    _PyErr_Clear(tstate);
                }
                /* iterator ended normally */
                assert(next_instr[INLINE_CACHE_ENTRIES_FOR_ITER + oparg].op.code == END_FOR ||
                       next_instr[INLINE_CACHE_ENTRIES_FOR_ITER + oparg].op.code == INSTRUMENTED_END_FOR);
                Py_DECREF(iter);
                STACK_SHRINK(1);
                /* Jump forward oparg, then skip following END_FOR instruction */
                JUMPBY(INLINE_CACHE_ENTRIES_FOR_ITER + oparg + 1);
                DISPATCH();
            }
            // Common case: no jump, leave it to the code generator
            #line 3318 "Python/generated_cases.c.h"
            STACK_GROW(1);
            stack_pointer[-1] = next;
            next_instr += 1;
            DISPATCH();
        }

        TARGET(INSTRUMENTED_FOR_ITER) {
            #line 2279 "Python/bytecodes.c"
            _Py_CODEUNIT *here = next_instr-1;
            _Py_CODEUNIT *target;
            PyObject *iter = TOP();
            PyObject *next = (*Py_TYPE(iter)->tp_iternext)(iter);
            if (next != NULL) {
                PUSH(next);
                target = next_instr + INLINE_CACHE_ENTRIES_FOR_ITER;
            }
            else {
                if (_PyErr_Occurred(tstate)) {
                    if (!_PyErr_ExceptionMatches(tstate, PyExc_StopIteration)) {
                        goto error;
                    }
                    monitor_raise(tstate, frame, here);
                    _PyErr_Clear(tstate);
                }
                /* iterator ended normally */
                assert(next_instr[INLINE_CACHE_ENTRIES_FOR_ITER + oparg].op.code == END_FOR ||
                       next_instr[INLINE_CACHE_ENTRIES_FOR_ITER + oparg].op.code == INSTRUMENTED_END_FOR);
                STACK_SHRINK(1);
                Py_DECREF(iter);
                /* Skip END_FOR */
                target = next_instr + INLINE_CACHE_ENTRIES_FOR_ITER + oparg + 1;
            }
            INSTRUMENTED_JUMP(here, target, PY_MONITORING_EVENT_BRANCH);
            #line 3352 "Python/generated_cases.c.h"
            DISPATCH();
        }

        TARGET(FOR_ITER_LIST) {
            PyObject *iter = stack_pointer[-1];
            PyObject *next;
            #line 2307 "Python/bytecodes.c"
            DEOPT_IF(Py_TYPE(iter) != &PyListIter_Type, FOR_ITER);
            _PyListIterObject *it = (_PyListIterObject *)iter;
            STAT_INC(FOR_ITER, hit);
            PyListObject *seq = it->it_seq;
            if (seq) {
                if (it->it_index < PyList_GET_SIZE(seq)) {
                    next = Py_NewRef(PyList_GET_ITEM(seq, it->it_index++));
                    goto end_for_iter_list;  // End of this instruction
                }
                it->it_seq = NULL;
                Py_DECREF(seq);
            }
            Py_DECREF(iter);
            STACK_SHRINK(1);
            /* Jump forward oparg, then skip following END_FOR instruction */
            JUMPBY(INLINE_CACHE_ENTRIES_FOR_ITER + oparg + 1);
            DISPATCH();
        end_for_iter_list:
            // Common case: no jump, leave it to the code generator
            #line 3379 "Python/generated_cases.c.h"
            STACK_GROW(1);
            stack_pointer[-1] = next;
            next_instr += 1;
            DISPATCH();
        }

        TARGET(FOR_ITER_TUPLE) {
            PyObject *iter = stack_pointer[-1];
            PyObject *next;
            #line 2329 "Python/bytecodes.c"
            _PyTupleIterObject *it = (_PyTupleIterObject *)iter;
            DEOPT_IF(Py_TYPE(it) != &PyTupleIter_Type, FOR_ITER);
            STAT_INC(FOR_ITER, hit);
            PyTupleObject *seq = it->it_seq;
            if (seq) {
                if (it->it_index < PyTuple_GET_SIZE(seq)) {
                    next = Py_NewRef(PyTuple_GET_ITEM(seq, it->it_index++));
                    goto end_for_iter_tuple;  // End of this instruction
                }
                it->it_seq = NULL;
                Py_DECREF(seq);
            }
            Py_DECREF(iter);
            STACK_SHRINK(1);
            /* Jump forward oparg, then skip following END_FOR instruction */
            JUMPBY(INLINE_CACHE_ENTRIES_FOR_ITER + oparg + 1);
            DISPATCH();
        end_for_iter_tuple:
            // Common case: no jump, leave it to the code generator
            #line 3409 "Python/generated_cases.c.h"
            STACK_GROW(1);
            stack_pointer[-1] = next;
            next_instr += 1;
            DISPATCH();
        }

        TARGET(FOR_ITER_RANGE) {
            PyObject *iter = stack_pointer[-1];
            PyObject *next;
            #line 2351 "Python/bytecodes.c"
            _PyRangeIterObject *r = (_PyRangeIterObject *)iter;
            DEOPT_IF(Py_TYPE(r) != &PyRangeIter_Type, FOR_ITER);
            STAT_INC(FOR_ITER, hit);
            if (r->len <= 0) {
                STACK_SHRINK(1);
                Py_DECREF(r);
                // Jump over END_FOR instruction.
                JUMPBY(INLINE_CACHE_ENTRIES_FOR_ITER + oparg + 1);
                DISPATCH();
            }
            long value = r->start;
            r->start = value + r->step;
            r->len--;
            next = PyLong_FromLong(value);
            if (next == NULL) {
                goto error;
            }
            #line 3437 "Python/generated_cases.c.h"
            STACK_GROW(1);
            stack_pointer[-1] = next;
            next_instr += 1;
            DISPATCH();
        }

        TARGET(FOR_ITER_GEN) {
            PyObject *iter = stack_pointer[-1];
            #line 2371 "Python/bytecodes.c"
            DEOPT_IF(tstate->interp->eval_frame, FOR_ITER);
            PyGenObject *gen = (PyGenObject *)iter;
            DEOPT_IF(Py_TYPE(gen) != &PyGen_Type, FOR_ITER);
            DEOPT_IF(gen->gi_frame_state >= FRAME_EXECUTING, FOR_ITER);
            STAT_INC(FOR_ITER, hit);
            _PyInterpreterFrame *gen_frame = (_PyInterpreterFrame *)gen->gi_iframe;
            frame->return_offset = oparg;
            _PyFrame_StackPush(gen_frame, Py_None);
            gen->gi_frame_state = FRAME_EXECUTING;
            gen->gi_exc_state.previous_item = tstate->exc_info;
            tstate->exc_info = &gen->gi_exc_state;
            JUMPBY(INLINE_CACHE_ENTRIES_FOR_ITER);
            assert(next_instr[oparg].op.code == END_FOR ||
                   next_instr[oparg].op.code == INSTRUMENTED_END_FOR);
            DISPATCH_INLINED(gen_frame);
            #line 3462 "Python/generated_cases.c.h"
        }

        TARGET(BEFORE_ASYNC_WITH) {
            PyObject *mgr = stack_pointer[-1];
            PyObject *exit;
            PyObject *res;
            #line 2389 "Python/bytecodes.c"
            PyObject *enter = _PyObject_LookupSpecial(mgr, &_Py_ID(__aenter__));
            if (enter == NULL) {
                if (!_PyErr_Occurred(tstate)) {
                    _PyErr_Format(tstate, PyExc_TypeError,
                                  "'%.200s' object does not support the "
                                  "asynchronous context manager protocol",
                                  Py_TYPE(mgr)->tp_name);
                }
                goto error;
            }
            exit = _PyObject_LookupSpecial(mgr, &_Py_ID(__aexit__));
            if (exit == NULL) {
                if (!_PyErr_Occurred(tstate)) {
                    _PyErr_Format(tstate, PyExc_TypeError,
                                  "'%.200s' object does not support the "
                                  "asynchronous context manager protocol "
                                  "(missed __aexit__ method)",
                                  Py_TYPE(mgr)->tp_name);
                }
                Py_DECREF(enter);
                goto error;
            }
            #line 3492 "Python/generated_cases.c.h"
            Py_DECREF(mgr);
            #line 2412 "Python/bytecodes.c"
            res = _PyObject_CallNoArgs(enter);
            Py_DECREF(enter);
            if (res == NULL) {
                Py_DECREF(exit);
                if (true) goto pop_1_error;
            }
            #line 3501 "Python/generated_cases.c.h"
            STACK_GROW(1);
            stack_pointer[-1] = res;
            stack_pointer[-2] = exit;
            PREDICT(GET_AWAITABLE);
            DISPATCH();
        }

        TARGET(BEFORE_WITH) {
            PyObject *mgr = stack_pointer[-1];
            PyObject *exit;
            PyObject *res;
            #line 2422 "Python/bytecodes.c"
            /* pop the context manager, push its __exit__ and the
             * value returned from calling its __enter__
             */
            PyObject *enter = _PyObject_LookupSpecial(mgr, &_Py_ID(__enter__));
            if (enter == NULL) {
                if (!_PyErr_Occurred(tstate)) {
                    _PyErr_Format(tstate, PyExc_TypeError,
                                  "'%.200s' object does not support the "
                                  "context manager protocol",
                                  Py_TYPE(mgr)->tp_name);
                }
                goto error;
            }
            exit = _PyObject_LookupSpecial(mgr, &_Py_ID(__exit__));
            if (exit == NULL) {
                if (!_PyErr_Occurred(tstate)) {
                    _PyErr_Format(tstate, PyExc_TypeError,
                                  "'%.200s' object does not support the "
                                  "context manager protocol "
                                  "(missed __exit__ method)",
                                  Py_TYPE(mgr)->tp_name);
                }
                Py_DECREF(enter);
                goto error;
            }
            #line 3539 "Python/generated_cases.c.h"
            Py_DECREF(mgr);
            #line 2448 "Python/bytecodes.c"
            res = _PyObject_CallNoArgs(enter);
            Py_DECREF(enter);
            if (res == NULL) {
                Py_DECREF(exit);
                if (true) goto pop_1_error;
            }
            #line 3548 "Python/generated_cases.c.h"
            STACK_GROW(1);
            stack_pointer[-1] = res;
            stack_pointer[-2] = exit;
            DISPATCH();
        }

        TARGET(WITH_EXCEPT_START) {
            PyObject *val = stack_pointer[-1];
            PyObject *lasti = stack_pointer[-3];
            PyObject *exit_func = stack_pointer[-4];
            PyObject *res;
            #line 2457 "Python/bytecodes.c"
            /* At the top of the stack are 4 values:
               - val: TOP = exc_info()
               - unused: SECOND = previous exception
               - lasti: THIRD = lasti of exception in exc_info()
               - exit_func: FOURTH = the context.__exit__ bound method
               We call FOURTH(type(TOP), TOP, GetTraceback(TOP)).
               Then we push the __exit__ return value.
            */
            PyObject *exc, *tb;

            assert(val && PyExceptionInstance_Check(val));
            exc = PyExceptionInstance_Class(val);
            tb = PyException_GetTraceback(val);
            Py_XDECREF(tb);
            assert(PyLong_Check(lasti));
            (void)lasti; // Shut up compiler warning if asserts are off
            PyObject *stack[4] = {NULL, exc, val, tb};
            res = PyObject_Vectorcall(exit_func, stack + 1,
                    3 | PY_VECTORCALL_ARGUMENTS_OFFSET, NULL);
            if (res == NULL) goto error;
            #line 3581 "Python/generated_cases.c.h"
            STACK_GROW(1);
            stack_pointer[-1] = res;
            DISPATCH();
        }

        TARGET(PUSH_EXC_INFO) {
            PyObject *new_exc = stack_pointer[-1];
            PyObject *prev_exc;
            #line 2480 "Python/bytecodes.c"
            _PyErr_StackItem *exc_info = tstate->exc_info;
            if (exc_info->exc_value != NULL) {
                prev_exc = exc_info->exc_value;
            }
            else {
                prev_exc = Py_None;
            }
            assert(PyExceptionInstance_Check(new_exc));
            exc_info->exc_value = Py_NewRef(new_exc);
            #line 3600 "Python/generated_cases.c.h"
            STACK_GROW(1);
            stack_pointer[-1] = new_exc;
            stack_pointer[-2] = prev_exc;
            DISPATCH();
        }

        TARGET(LOAD_ATTR_METHOD_WITH_VALUES) {
            PyObject *self = stack_pointer[-1];
            PyObject *res2 = NULL;
            PyObject *res;
            uint32_t type_version = read_u32(&next_instr[1].cache);
            uint32_t keys_version = read_u32(&next_instr[3].cache);
            PyObject *descr = read_obj(&next_instr[5].cache);
            #line 2492 "Python/bytecodes.c"
            /* Cached method object */
            PyTypeObject *self_cls = Py_TYPE(self);
            assert(type_version != 0);
            DEOPT_IF(self_cls->tp_version_tag != type_version, LOAD_ATTR);
            assert(self_cls->tp_flags & Py_TPFLAGS_MANAGED_DICT);
            PyDictOrValues dorv = *_PyObject_DictOrValuesPointer(self);
            DEOPT_IF(!_PyDictOrValues_IsValues(dorv), LOAD_ATTR);
            PyHeapTypeObject *self_heap_type = (PyHeapTypeObject *)self_cls;
            DEOPT_IF(self_heap_type->ht_cached_keys->dk_version !=
                     keys_version, LOAD_ATTR);
            STAT_INC(LOAD_ATTR, hit);
            assert(descr != NULL);
            res2 = Py_NewRef(descr);
            assert(_PyType_HasFeature(Py_TYPE(res2), Py_TPFLAGS_METHOD_DESCRIPTOR));
            res = self;
            assert(oparg & 1);
            #line 3631 "Python/generated_cases.c.h"
            STACK_GROW(((oparg & 1) ? 1 : 0));
            stack_pointer[-1] = res;
            if (oparg & 1) { stack_pointer[-(1 + ((oparg & 1) ? 1 : 0))] = res2; }
            next_instr += 9;
            DISPATCH();
        }

        TARGET(LOAD_ATTR_METHOD_NO_DICT) {
            PyObject *self = stack_pointer[-1];
            PyObject *res2 = NULL;
            PyObject *res;
            uint32_t type_version = read_u32(&next_instr[1].cache);
            PyObject *descr = read_obj(&next_instr[5].cache);
            #line 2511 "Python/bytecodes.c"
            PyTypeObject *self_cls = Py_TYPE(self);
            DEOPT_IF(self_cls->tp_version_tag != type_version, LOAD_ATTR);
            assert(self_cls->tp_dictoffset == 0);
            STAT_INC(LOAD_ATTR, hit);
            assert(descr != NULL);
            assert(_PyType_HasFeature(Py_TYPE(descr), Py_TPFLAGS_METHOD_DESCRIPTOR));
            res2 = Py_NewRef(descr);
            res = self;
            assert(oparg & 1);
            #line 3655 "Python/generated_cases.c.h"
            STACK_GROW(((oparg & 1) ? 1 : 0));
            stack_pointer[-1] = res;
            if (oparg & 1) { stack_pointer[-(1 + ((oparg & 1) ? 1 : 0))] = res2; }
            next_instr += 9;
            DISPATCH();
        }

        TARGET(LOAD_ATTR_METHOD_LAZY_DICT) {
            PyObject *self = stack_pointer[-1];
            PyObject *res2 = NULL;
            PyObject *res;
            uint32_t type_version = read_u32(&next_instr[1].cache);
            PyObject *descr = read_obj(&next_instr[5].cache);
            #line 2523 "Python/bytecodes.c"
            PyTypeObject *self_cls = Py_TYPE(self);
            DEOPT_IF(self_cls->tp_version_tag != type_version, LOAD_ATTR);
            Py_ssize_t dictoffset = self_cls->tp_dictoffset;
            assert(dictoffset > 0);
            PyObject *dict = *(PyObject **)((char *)self + dictoffset);
            /* This object has a __dict__, just not yet created */
            DEOPT_IF(dict != NULL, LOAD_ATTR);
            STAT_INC(LOAD_ATTR, hit);
            assert(descr != NULL);
            assert(_PyType_HasFeature(Py_TYPE(descr), Py_TPFLAGS_METHOD_DESCRIPTOR));
            res2 = Py_NewRef(descr);
            res = self;
            assert(oparg & 1);
            #line 3683 "Python/generated_cases.c.h"
            STACK_GROW(((oparg & 1) ? 1 : 0));
            stack_pointer[-1] = res;
            if (oparg & 1) { stack_pointer[-(1 + ((oparg & 1) ? 1 : 0))] = res2; }
            next_instr += 9;
            DISPATCH();
        }

        TARGET(KW_NAMES) {
            #line 2539 "Python/bytecodes.c"
            assert(kwnames == NULL);
            assert(oparg < PyTuple_GET_SIZE(frame->f_code->co_consts));
            kwnames = GETITEM(frame->f_code->co_consts, oparg);
            #line 3696 "Python/generated_cases.c.h"
            DISPATCH();
        }

        TARGET(INSTRUMENTED_CALL) {
            #line 2545 "Python/bytecodes.c"
            int is_meth = PEEK(oparg+2) != NULL;
            int total_args = oparg + is_meth;
            PyObject *function = PEEK(total_args + 1);
            PyObject *arg = total_args == 0 ?
                &_PyInstrumentation_MISSING : PEEK(total_args);
            int err = _Py_call_instrumentation_2args(
                    tstate, PY_MONITORING_EVENT_CALL,
                    frame, next_instr-1, function, arg);
            if (err) goto error;
            _PyCallCache *cache = (_PyCallCache *)next_instr;
            INCREMENT_ADAPTIVE_COUNTER(cache->counter);
            GO_TO_INSTRUCTION(CALL);
            #line 3714 "Python/generated_cases.c.h"
        }

        TARGET(CALL) {
            PREDICTED(CALL);
            static_assert(INLINE_CACHE_ENTRIES_CALL == 3, "incorrect cache size");
            PyObject **args = (stack_pointer - oparg);
            PyObject *callable = stack_pointer[-(1 + oparg)];
            PyObject *method = stack_pointer[-(2 + oparg)];
            PyObject *res;
            #line 2590 "Python/bytecodes.c"
            int is_meth = method != NULL;
            int total_args = oparg;
            if (is_meth) {
                callable = method;
                args--;
                total_args++;
            }
            #if ENABLE_SPECIALIZATION
            _PyCallCache *cache = (_PyCallCache *)next_instr;
            if (ADAPTIVE_COUNTER_IS_ZERO(cache->counter)) {
                next_instr--;
                _Py_Specialize_Call(callable, next_instr, total_args, kwnames);
                DISPATCH_SAME_OPARG();
            }
            STAT_INC(CALL, deferred);
            DECREMENT_ADAPTIVE_COUNTER(cache->counter);
            #endif  /* ENABLE_SPECIALIZATION */
            if (!is_meth && Py_TYPE(callable) == &PyMethod_Type) {
                is_meth = 1;  // For consistenct; it's dead, though
                args--;
                total_args++;
                PyObject *self = ((PyMethodObject *)callable)->im_self;
                args[0] = Py_NewRef(self);
                method = ((PyMethodObject *)callable)->im_func;
                args[-1] = Py_NewRef(method);
                Py_DECREF(callable);
                callable = method;
            }
            int positional_args = total_args - KWNAMES_LEN();
            // Check if the call can be inlined or not
            if (Py_TYPE(callable) == &PyFunction_Type &&
                tstate->interp->eval_frame == NULL &&
                ((PyFunctionObject *)callable)->vectorcall == _PyFunction_Vectorcall)
            {
                int code_flags = ((PyCodeObject*)PyFunction_GET_CODE(callable))->co_flags;
                PyObject *locals = code_flags & CO_OPTIMIZED ? NULL : Py_NewRef(PyFunction_GET_GLOBALS(callable));
                _PyInterpreterFrame *new_frame = _PyEvalFramePushAndInit(
                    tstate, (PyFunctionObject *)callable, locals,
                    args, positional_args, kwnames
                );
                kwnames = NULL;
                // Manipulate stack directly since we leave using DISPATCH_INLINED().
                STACK_SHRINK(oparg + 2);
                // The frame has stolen all the arguments from the stack,
                // so there is no need to clean them up.
                if (new_frame == NULL) {
                    goto error;
                }
                JUMPBY(INLINE_CACHE_ENTRIES_CALL);
                frame->return_offset = 0;
                DISPATCH_INLINED(new_frame);
            }
            /* Callable is not a normal Python function */
            res = PyObject_Vectorcall(
                callable, args,
                positional_args | PY_VECTORCALL_ARGUMENTS_OFFSET,
                kwnames);
            if (opcode == INSTRUMENTED_CALL) {
                PyObject *arg = total_args == 0 ?
                    &_PyInstrumentation_MISSING : PEEK(total_args);
                if (res == NULL) {
                    _Py_call_instrumentation_exc2(
                        tstate, PY_MONITORING_EVENT_C_RAISE,
                        frame, next_instr-1, callable, arg);
                }
                else {
                    int err = _Py_call_instrumentation_2args(
                        tstate, PY_MONITORING_EVENT_C_RETURN,
                        frame, next_instr-1, callable, arg);
                    if (err < 0) {
                        Py_CLEAR(res);
                    }
                }
            }
            kwnames = NULL;
            assert((res != NULL) ^ (_PyErr_Occurred(tstate) != NULL));
            Py_DECREF(callable);
            for (int i = 0; i < total_args; i++) {
                Py_DECREF(args[i]);
            }
            if (res == NULL) { STACK_SHRINK(oparg); goto pop_2_error; }
            #line 3806 "Python/generated_cases.c.h"
            STACK_SHRINK(oparg);
            STACK_SHRINK(1);
            stack_pointer[-1] = res;
            next_instr += 3;
            CHECK_EVAL_BREAKER();
            DISPATCH();
        }

        TARGET(CALL_BOUND_METHOD_EXACT_ARGS) {
            PyObject *callable = stack_pointer[-(1 + oparg)];
            PyObject *method = stack_pointer[-(2 + oparg)];
            #line 2678 "Python/bytecodes.c"
            DEOPT_IF(method != NULL, CALL);
            DEOPT_IF(Py_TYPE(callable) != &PyMethod_Type, CALL);
            STAT_INC(CALL, hit);
            PyObject *self = ((PyMethodObject *)callable)->im_self;
            PEEK(oparg + 1) = Py_NewRef(self);  // callable
            PyObject *meth = ((PyMethodObject *)callable)->im_func;
            PEEK(oparg + 2) = Py_NewRef(meth);  // method
            Py_DECREF(callable);
            GO_TO_INSTRUCTION(CALL_PY_EXACT_ARGS);
            #line 3828 "Python/generated_cases.c.h"
        }

        TARGET(CALL_PY_EXACT_ARGS) {
            PREDICTED(CALL_PY_EXACT_ARGS);
            PyObject **args = (stack_pointer - oparg);
            PyObject *callable = stack_pointer[-(1 + oparg)];
            PyObject *method = stack_pointer[-(2 + oparg)];
            uint32_t func_version = read_u32(&next_instr[1].cache);
            #line 2690 "Python/bytecodes.c"
            assert(kwnames == NULL);
            DEOPT_IF(tstate->interp->eval_frame, CALL);
            int is_meth = method != NULL;
            int argcount = oparg;
            if (is_meth) {
                callable = method;
                args--;
                argcount++;
            }
            DEOPT_IF(!PyFunction_Check(callable), CALL);
            PyFunctionObject *func = (PyFunctionObject *)callable;
            DEOPT_IF(func->func_version != func_version, CALL);
            PyCodeObject *code = (PyCodeObject *)func->func_code;
            DEOPT_IF(code->co_argcount != argcount, CALL);
            DEOPT_IF(!_PyThreadState_HasStackSpace(tstate, code->co_framesize), CALL);
            STAT_INC(CALL, hit);
            _PyInterpreterFrame *new_frame = _PyFrame_PushUnchecked(tstate, func, argcount);
            for (int i = 0; i < argcount; i++) {
                new_frame->localsplus[i] = args[i];
            }
            // Manipulate stack directly since we leave using DISPATCH_INLINED().
            STACK_SHRINK(oparg + 2);
            JUMPBY(INLINE_CACHE_ENTRIES_CALL);
            frame->return_offset = 0;
            DISPATCH_INLINED(new_frame);
            #line 3863 "Python/generated_cases.c.h"
        }

        TARGET(CALL_PY_WITH_DEFAULTS) {
            PyObject **args = (stack_pointer - oparg);
            PyObject *callable = stack_pointer[-(1 + oparg)];
            PyObject *method = stack_pointer[-(2 + oparg)];
            uint32_t func_version = read_u32(&next_instr[1].cache);
            #line 2718 "Python/bytecodes.c"
            assert(kwnames == NULL);
            DEOPT_IF(tstate->interp->eval_frame, CALL);
            int is_meth = method != NULL;
            int argcount = oparg;
            if (is_meth) {
                callable = method;
                args--;
                argcount++;
            }
            DEOPT_IF(!PyFunction_Check(callable), CALL);
            PyFunctionObject *func = (PyFunctionObject *)callable;
            DEOPT_IF(func->func_version != func_version, CALL);
            PyCodeObject *code = (PyCodeObject *)func->func_code;
            assert(func->func_defaults);
            assert(PyTuple_CheckExact(func->func_defaults));
            int defcount = (int)PyTuple_GET_SIZE(func->func_defaults);
            assert(defcount <= code->co_argcount);
            int min_args = code->co_argcount - defcount;
            DEOPT_IF(argcount > code->co_argcount, CALL);
            DEOPT_IF(argcount < min_args, CALL);
            DEOPT_IF(!_PyThreadState_HasStackSpace(tstate, code->co_framesize), CALL);
            STAT_INC(CALL, hit);
            _PyInterpreterFrame *new_frame = _PyFrame_PushUnchecked(tstate, func, code->co_argcount);
            for (int i = 0; i < argcount; i++) {
                new_frame->localsplus[i] = args[i];
            }
            for (int i = argcount; i < code->co_argcount; i++) {
                PyObject *def = PyTuple_GET_ITEM(func->func_defaults, i - min_args);
                new_frame->localsplus[i] = Py_NewRef(def);
            }
            // Manipulate stack and cache directly since we leave using DISPATCH_INLINED().
            STACK_SHRINK(oparg + 2);
            JUMPBY(INLINE_CACHE_ENTRIES_CALL);
            frame->return_offset = 0;
            DISPATCH_INLINED(new_frame);
            #line 3907 "Python/generated_cases.c.h"
        }

        TARGET(CALL_NO_KW_TYPE_1) {
            PyObject **args = (stack_pointer - oparg);
            PyObject *callable = stack_pointer[-(1 + oparg)];
            PyObject *null = stack_pointer[-(2 + oparg)];
            PyObject *res;
            #line 2756 "Python/bytecodes.c"
            assert(kwnames == NULL);
            assert(oparg == 1);
            DEOPT_IF(null != NULL, CALL);
            PyObject *obj = args[0];
            DEOPT_IF(callable != (PyObject *)&PyType_Type, CALL);
            STAT_INC(CALL, hit);
            res = Py_NewRef(Py_TYPE(obj));
            Py_DECREF(obj);
            Py_DECREF(&PyType_Type);  // I.e., callable
            #line 3925 "Python/generated_cases.c.h"
            STACK_SHRINK(oparg);
            STACK_SHRINK(1);
            stack_pointer[-1] = res;
            next_instr += 3;
            DISPATCH();
        }

        TARGET(CALL_NO_KW_STR_1) {
            PyObject **args = (stack_pointer - oparg);
            PyObject *callable = stack_pointer[-(1 + oparg)];
            PyObject *null = stack_pointer[-(2 + oparg)];
            PyObject *res;
            #line 2768 "Python/bytecodes.c"
            assert(kwnames == NULL);
            assert(oparg == 1);
            DEOPT_IF(null != NULL, CALL);
            DEOPT_IF(callable != (PyObject *)&PyUnicode_Type, CALL);
            STAT_INC(CALL, hit);
            PyObject *arg = args[0];
            res = PyObject_Str(arg);
            Py_DECREF(arg);
            Py_DECREF(&PyUnicode_Type);  // I.e., callable
            if (res == NULL) { STACK_SHRINK(oparg); goto pop_2_error; }
            #line 3949 "Python/generated_cases.c.h"
            STACK_SHRINK(oparg);
            STACK_SHRINK(1);
            stack_pointer[-1] = res;
            next_instr += 3;
            CHECK_EVAL_BREAKER();
            DISPATCH();
        }

        TARGET(CALL_NO_KW_TUPLE_1) {
            PyObject **args = (stack_pointer - oparg);
            PyObject *callable = stack_pointer[-(1 + oparg)];
            PyObject *null = stack_pointer[-(2 + oparg)];
            PyObject *res;
            #line 2782 "Python/bytecodes.c"
            assert(kwnames == NULL);
            assert(oparg == 1);
            DEOPT_IF(null != NULL, CALL);
            DEOPT_IF(callable != (PyObject *)&PyTuple_Type, CALL);
            STAT_INC(CALL, hit);
            PyObject *arg = args[0];
            res = PySequence_Tuple(arg);
            Py_DECREF(arg);
            Py_DECREF(&PyTuple_Type);  // I.e., tuple
            if (res == NULL) { STACK_SHRINK(oparg); goto pop_2_error; }
            #line 3974 "Python/generated_cases.c.h"
            STACK_SHRINK(oparg);
            STACK_SHRINK(1);
            stack_pointer[-1] = res;
            next_instr += 3;
            CHECK_EVAL_BREAKER();
            DISPATCH();
        }

        TARGET(CALL_BUILTIN_CLASS) {
            PyObject **args = (stack_pointer - oparg);
            PyObject *callable = stack_pointer[-(1 + oparg)];
            PyObject *method = stack_pointer[-(2 + oparg)];
            PyObject *res;
            #line 2796 "Python/bytecodes.c"
            int is_meth = method != NULL;
            int total_args = oparg;
            if (is_meth) {
                callable = method;
                args--;
                total_args++;
            }
            int kwnames_len = KWNAMES_LEN();
            DEOPT_IF(!PyType_Check(callable), CALL);
            PyTypeObject *tp = (PyTypeObject *)callable;
            DEOPT_IF(tp->tp_vectorcall == NULL, CALL);
            STAT_INC(CALL, hit);
            res = tp->tp_vectorcall((PyObject *)tp, args,
                                    total_args - kwnames_len, kwnames);
            kwnames = NULL;
            /* Free the arguments. */
            for (int i = 0; i < total_args; i++) {
                Py_DECREF(args[i]);
            }
            Py_DECREF(tp);
            if (res == NULL) { STACK_SHRINK(oparg); goto pop_2_error; }
            #line 4010 "Python/generated_cases.c.h"
            STACK_SHRINK(oparg);
            STACK_SHRINK(1);
            stack_pointer[-1] = res;
            next_instr += 3;
            CHECK_EVAL_BREAKER();
            DISPATCH();
        }

        TARGET(CALL_NO_KW_BUILTIN_O) {
            PyObject **args = (stack_pointer - oparg);
            PyObject *callable = stack_pointer[-(1 + oparg)];
            PyObject *method = stack_pointer[-(2 + oparg)];
            PyObject *res;
            #line 2821 "Python/bytecodes.c"
            /* Builtin METH_O functions */
            assert(kwnames == NULL);
            int is_meth = method != NULL;
            int total_args = oparg;
            if (is_meth) {
                callable = method;
                args--;
                total_args++;
            }
            DEOPT_IF(total_args != 1, CALL);
            DEOPT_IF(!PyCFunction_CheckExact(callable), CALL);
            DEOPT_IF(PyCFunction_GET_FLAGS(callable) != METH_O, CALL);
            STAT_INC(CALL, hit);
            PyCFunction cfunc = PyCFunction_GET_FUNCTION(callable);
            // This is slower but CPython promises to check all non-vectorcall
            // function calls.
            if (_Py_EnterRecursiveCallTstate(tstate, " while calling a Python object")) {
                goto error;
            }
            PyObject *arg = args[0];
            res = _PyCFunction_TrampolineCall(cfunc, PyCFunction_GET_SELF(callable), arg);
            _Py_LeaveRecursiveCallTstate(tstate);
            assert((res != NULL) ^ (_PyErr_Occurred(tstate) != NULL));

            Py_DECREF(arg);
            Py_DECREF(callable);
            if (res == NULL) { STACK_SHRINK(oparg); goto pop_2_error; }
            #line 4052 "Python/generated_cases.c.h"
            STACK_SHRINK(oparg);
            STACK_SHRINK(1);
            stack_pointer[-1] = res;
            next_instr += 3;
            CHECK_EVAL_BREAKER();
            DISPATCH();
        }

        TARGET(CALL_NO_KW_BUILTIN_FAST) {
            PyObject **args = (stack_pointer - oparg);
            PyObject *callable = stack_pointer[-(1 + oparg)];
            PyObject *method = stack_pointer[-(2 + oparg)];
            PyObject *res;
            #line 2852 "Python/bytecodes.c"
            /* Builtin METH_FASTCALL functions, without keywords */
            assert(kwnames == NULL);
            int is_meth = method != NULL;
            int total_args = oparg;
            if (is_meth) {
                callable = method;
                args--;
                total_args++;
            }
            DEOPT_IF(!PyCFunction_CheckExact(callable), CALL);
            DEOPT_IF(PyCFunction_GET_FLAGS(callable) != METH_FASTCALL, CALL);
            STAT_INC(CALL, hit);
            PyCFunction cfunc = PyCFunction_GET_FUNCTION(callable);
            /* res = func(self, args, nargs) */
            res = ((_PyCFunctionFast)(void(*)(void))cfunc)(
                PyCFunction_GET_SELF(callable),
                args,
                total_args);
            assert((res != NULL) ^ (_PyErr_Occurred(tstate) != NULL));

            /* Free the arguments. */
            for (int i = 0; i < total_args; i++) {
                Py_DECREF(args[i]);
            }
            Py_DECREF(callable);
            if (res == NULL) { STACK_SHRINK(oparg); goto pop_2_error; }
                /* Not deopting because this doesn't mean our optimization was
                   wrong. `res` can be NULL for valid reasons. Eg. getattr(x,
                   'invalid'). In those cases an exception is set, so we must
                   handle it.
                */
            #line 4098 "Python/generated_cases.c.h"
            STACK_SHRINK(oparg);
            STACK_SHRINK(1);
            stack_pointer[-1] = res;
            next_instr += 3;
            CHECK_EVAL_BREAKER();
            DISPATCH();
        }

        TARGET(CALL_BUILTIN_FAST_WITH_KEYWORDS) {
            PyObject **args = (stack_pointer - oparg);
            PyObject *callable = stack_pointer[-(1 + oparg)];
            PyObject *method = stack_pointer[-(2 + oparg)];
            PyObject *res;
            #line 2887 "Python/bytecodes.c"
            /* Builtin METH_FASTCALL | METH_KEYWORDS functions */
            int is_meth = method != NULL;
            int total_args = oparg;
            if (is_meth) {
                callable = method;
                args--;
                total_args++;
            }
            DEOPT_IF(!PyCFunction_CheckExact(callable), CALL);
            DEOPT_IF(PyCFunction_GET_FLAGS(callable) !=
                (METH_FASTCALL | METH_KEYWORDS), CALL);
            STAT_INC(CALL, hit);
            /* res = func(self, args, nargs, kwnames) */
            _PyCFunctionFastWithKeywords cfunc =
                (_PyCFunctionFastWithKeywords)(void(*)(void))
                PyCFunction_GET_FUNCTION(callable);
            res = cfunc(
                PyCFunction_GET_SELF(callable),
                args,
                total_args - KWNAMES_LEN(),
                kwnames
            );
            assert((res != NULL) ^ (_PyErr_Occurred(tstate) != NULL));
            kwnames = NULL;

            /* Free the arguments. */
            for (int i = 0; i < total_args; i++) {
                Py_DECREF(args[i]);
            }
            Py_DECREF(callable);
            if (res == NULL) { STACK_SHRINK(oparg); goto pop_2_error; }
            #line 4144 "Python/generated_cases.c.h"
            STACK_SHRINK(oparg);
            STACK_SHRINK(1);
            stack_pointer[-1] = res;
            next_instr += 3;
            CHECK_EVAL_BREAKER();
            DISPATCH();
        }

        TARGET(CALL_NO_KW_LEN) {
            PyObject **args = (stack_pointer - oparg);
            PyObject *callable = stack_pointer[-(1 + oparg)];
            PyObject *method = stack_pointer[-(2 + oparg)];
            PyObject *res;
            #line 2922 "Python/bytecodes.c"
            assert(kwnames == NULL);
            /* len(o) */
            int is_meth = method != NULL;
            int total_args = oparg;
            if (is_meth) {
                callable = method;
                args--;
                total_args++;
            }
            DEOPT_IF(total_args != 1, CALL);
            PyInterpreterState *interp = _PyInterpreterState_GET();
            DEOPT_IF(callable != interp->callable_cache.len, CALL);
            STAT_INC(CALL, hit);
            PyObject *arg = args[0];
            Py_ssize_t len_i = PyObject_Length(arg);
            if (len_i < 0) {
                goto error;
            }
            res = PyLong_FromSsize_t(len_i);
            assert((res != NULL) ^ (_PyErr_Occurred(tstate) != NULL));

            Py_DECREF(callable);
            Py_DECREF(arg);
            if (res == NULL) { STACK_SHRINK(oparg); goto pop_2_error; }
            #line 4183 "Python/generated_cases.c.h"
            STACK_SHRINK(oparg);
            STACK_SHRINK(1);
            stack_pointer[-1] = res;
            next_instr += 3;
            DISPATCH();
        }

        TARGET(CALL_NO_KW_ISINSTANCE) {
            PyObject **args = (stack_pointer - oparg);
            PyObject *callable = stack_pointer[-(1 + oparg)];
            PyObject *method = stack_pointer[-(2 + oparg)];
            PyObject *res;
            #line 2949 "Python/bytecodes.c"
            assert(kwnames == NULL);
            /* isinstance(o, o2) */
            int is_meth = method != NULL;
            int total_args = oparg;
            if (is_meth) {
                callable = method;
                args--;
                total_args++;
            }
            DEOPT_IF(total_args != 2, CALL);
            PyInterpreterState *interp = _PyInterpreterState_GET();
            DEOPT_IF(callable != interp->callable_cache.isinstance, CALL);
            STAT_INC(CALL, hit);
            PyObject *cls = args[1];
            PyObject *inst = args[0];
            int retval = PyObject_IsInstance(inst, cls);
            if (retval < 0) {
                goto error;
            }
            res = PyBool_FromLong(retval);
            assert((res != NULL) ^ (_PyErr_Occurred(tstate) != NULL));

            Py_DECREF(inst);
            Py_DECREF(cls);
            Py_DECREF(callable);
            if (res == NULL) { STACK_SHRINK(oparg); goto pop_2_error; }
            #line 4223 "Python/generated_cases.c.h"
            STACK_SHRINK(oparg);
            STACK_SHRINK(1);
            stack_pointer[-1] = res;
            next_instr += 3;
            DISPATCH();
        }

        TARGET(CALL_NO_KW_LIST_APPEND) {
            PyObject **args = (stack_pointer - oparg);
            PyObject *self = stack_pointer[-(1 + oparg)];
            PyObject *method = stack_pointer[-(2 + oparg)];
            #line 2979 "Python/bytecodes.c"
            assert(kwnames == NULL);
            assert(oparg == 1);
            assert(method != NULL);
            PyInterpreterState *interp = _PyInterpreterState_GET();
            DEOPT_IF(method != interp->callable_cache.list_append, CALL);
            DEOPT_IF(!PyList_Check(self), CALL);
            STAT_INC(CALL, hit);
            if (_PyList_AppendTakeRef((PyListObject *)self, args[0]) < 0) {
                goto pop_1_error;  // Since arg is DECREF'ed already
            }
            Py_DECREF(self);
            Py_DECREF(method);
            STACK_SHRINK(3);
            // CALL + POP_TOP
            JUMPBY(INLINE_CACHE_ENTRIES_CALL + 1);
            assert(next_instr[-1].op.code == POP_TOP);
            DISPATCH();
            #line 4253 "Python/generated_cases.c.h"
        }

        TARGET(CALL_NO_KW_METHOD_DESCRIPTOR_O) {
            PyObject **args = (stack_pointer - oparg);
            PyObject *method = stack_pointer[-(2 + oparg)];
            PyObject *res;
            #line 2999 "Python/bytecodes.c"
            assert(kwnames == NULL);
            int is_meth = method != NULL;
            int total_args = oparg;
            if (is_meth) {
                args--;
                total_args++;
            }
            PyMethodDescrObject *callable =
                (PyMethodDescrObject *)PEEK(total_args + 1);
            DEOPT_IF(total_args != 2, CALL);
            DEOPT_IF(!Py_IS_TYPE(callable, &PyMethodDescr_Type), CALL);
            PyMethodDef *meth = callable->d_method;
            DEOPT_IF(meth->ml_flags != METH_O, CALL);
            PyObject *arg = args[1];
            PyObject *self = args[0];
            DEOPT_IF(!Py_IS_TYPE(self, callable->d_common.d_type), CALL);
            STAT_INC(CALL, hit);
            PyCFunction cfunc = meth->ml_meth;
            // This is slower but CPython promises to check all non-vectorcall
            // function calls.
            if (_Py_EnterRecursiveCallTstate(tstate, " while calling a Python object")) {
                goto error;
            }
            res = _PyCFunction_TrampolineCall(cfunc, self, arg);
            _Py_LeaveRecursiveCallTstate(tstate);
            assert((res != NULL) ^ (_PyErr_Occurred(tstate) != NULL));
            Py_DECREF(self);
            Py_DECREF(arg);
            Py_DECREF(callable);
            if (res == NULL) { STACK_SHRINK(oparg); goto pop_2_error; }
            #line 4291 "Python/generated_cases.c.h"
            STACK_SHRINK(oparg);
            STACK_SHRINK(1);
            stack_pointer[-1] = res;
            next_instr += 3;
            CHECK_EVAL_BREAKER();
            DISPATCH();
        }

        TARGET(CALL_METHOD_DESCRIPTOR_FAST_WITH_KEYWORDS) {
            PyObject **args = (stack_pointer - oparg);
            PyObject *method = stack_pointer[-(2 + oparg)];
            PyObject *res;
            #line 3033 "Python/bytecodes.c"
            int is_meth = method != NULL;
            int total_args = oparg;
            if (is_meth) {
                args--;
                total_args++;
            }
            PyMethodDescrObject *callable =
                (PyMethodDescrObject *)PEEK(total_args + 1);
            DEOPT_IF(!Py_IS_TYPE(callable, &PyMethodDescr_Type), CALL);
            PyMethodDef *meth = callable->d_method;
            DEOPT_IF(meth->ml_flags != (METH_FASTCALL|METH_KEYWORDS), CALL);
            PyTypeObject *d_type = callable->d_common.d_type;
            PyObject *self = args[0];
            DEOPT_IF(!Py_IS_TYPE(self, d_type), CALL);
            STAT_INC(CALL, hit);
            int nargs = total_args - 1;
            _PyCFunctionFastWithKeywords cfunc =
                (_PyCFunctionFastWithKeywords)(void(*)(void))meth->ml_meth;
            res = cfunc(self, args + 1, nargs - KWNAMES_LEN(), kwnames);
            assert((res != NULL) ^ (_PyErr_Occurred(tstate) != NULL));
            kwnames = NULL;

            /* Free the arguments. */
            for (int i = 0; i < total_args; i++) {
                Py_DECREF(args[i]);
            }
            Py_DECREF(callable);
            if (res == NULL) { STACK_SHRINK(oparg); goto pop_2_error; }
            #line 4333 "Python/generated_cases.c.h"
            STACK_SHRINK(oparg);
            STACK_SHRINK(1);
            stack_pointer[-1] = res;
            next_instr += 3;
            CHECK_EVAL_BREAKER();
            DISPATCH();
        }

        TARGET(CALL_NO_KW_METHOD_DESCRIPTOR_NOARGS) {
            PyObject **args = (stack_pointer - oparg);
            PyObject *method = stack_pointer[-(2 + oparg)];
            PyObject *res;
            #line 3065 "Python/bytecodes.c"
            assert(kwnames == NULL);
            assert(oparg == 0 || oparg == 1);
            int is_meth = method != NULL;
            int total_args = oparg;
            if (is_meth) {
                args--;
                total_args++;
            }
            DEOPT_IF(total_args != 1, CALL);
            PyMethodDescrObject *callable = (PyMethodDescrObject *)SECOND();
            DEOPT_IF(!Py_IS_TYPE(callable, &PyMethodDescr_Type), CALL);
            PyMethodDef *meth = callable->d_method;
            PyObject *self = args[0];
            DEOPT_IF(!Py_IS_TYPE(self, callable->d_common.d_type), CALL);
            DEOPT_IF(meth->ml_flags != METH_NOARGS, CALL);
            STAT_INC(CALL, hit);
            PyCFunction cfunc = meth->ml_meth;
            // This is slower but CPython promises to check all non-vectorcall
            // function calls.
            if (_Py_EnterRecursiveCallTstate(tstate, " while calling a Python object")) {
                goto error;
            }
            res = _PyCFunction_TrampolineCall(cfunc, self, NULL);
            _Py_LeaveRecursiveCallTstate(tstate);
            assert((res != NULL) ^ (_PyErr_Occurred(tstate) != NULL));
            Py_DECREF(self);
            Py_DECREF(callable);
            if (res == NULL) { STACK_SHRINK(oparg); goto pop_2_error; }
            #line 4375 "Python/generated_cases.c.h"
            STACK_SHRINK(oparg);
            STACK_SHRINK(1);
            stack_pointer[-1] = res;
            next_instr += 3;
            CHECK_EVAL_BREAKER();
            DISPATCH();
        }

        TARGET(CALL_NO_KW_METHOD_DESCRIPTOR_FAST) {
            PyObject **args = (stack_pointer - oparg);
            PyObject *method = stack_pointer[-(2 + oparg)];
            PyObject *res;
            #line 3097 "Python/bytecodes.c"
            assert(kwnames == NULL);
            int is_meth = method != NULL;
            int total_args = oparg;
            if (is_meth) {
                args--;
                total_args++;
            }
            PyMethodDescrObject *callable =
                (PyMethodDescrObject *)PEEK(total_args + 1);
            /* Builtin METH_FASTCALL methods, without keywords */
            DEOPT_IF(!Py_IS_TYPE(callable, &PyMethodDescr_Type), CALL);
            PyMethodDef *meth = callable->d_method;
            DEOPT_IF(meth->ml_flags != METH_FASTCALL, CALL);
            PyObject *self = args[0];
            DEOPT_IF(!Py_IS_TYPE(self, callable->d_common.d_type), CALL);
            STAT_INC(CALL, hit);
            _PyCFunctionFast cfunc =
                (_PyCFunctionFast)(void(*)(void))meth->ml_meth;
            int nargs = total_args - 1;
            res = cfunc(self, args + 1, nargs);
            assert((res != NULL) ^ (_PyErr_Occurred(tstate) != NULL));
            /* Clear the stack of the arguments. */
            for (int i = 0; i < total_args; i++) {
                Py_DECREF(args[i]);
            }
            Py_DECREF(callable);
            if (res == NULL) { STACK_SHRINK(oparg); goto pop_2_error; }
            #line 4416 "Python/generated_cases.c.h"
            STACK_SHRINK(oparg);
            STACK_SHRINK(1);
            stack_pointer[-1] = res;
            next_instr += 3;
            CHECK_EVAL_BREAKER();
            DISPATCH();
        }

        TARGET(INSTRUMENTED_CALL_FUNCTION_EX) {
            #line 3128 "Python/bytecodes.c"
            GO_TO_INSTRUCTION(CALL_FUNCTION_EX);
            #line 4428 "Python/generated_cases.c.h"
        }

        TARGET(CALL_FUNCTION_EX) {
            PREDICTED(CALL_FUNCTION_EX);
            PyObject *kwargs = (oparg & 1) ? stack_pointer[-(((oparg & 1) ? 1 : 0))] : NULL;
            PyObject *callargs = stack_pointer[-(1 + ((oparg & 1) ? 1 : 0))];
            PyObject *func = stack_pointer[-(2 + ((oparg & 1) ? 1 : 0))];
            PyObject *result;
            #line 3132 "Python/bytecodes.c"
            // DICT_MERGE is called before this opcode if there are kwargs.
            // It converts all dict subtypes in kwargs into regular dicts.
            assert(kwargs == NULL || PyDict_CheckExact(kwargs));
            if (!PyTuple_CheckExact(callargs)) {
                if (check_args_iterable(tstate, func, callargs) < 0) {
                    goto error;
                }
                PyObject *tuple = PySequence_Tuple(callargs);
                if (tuple == NULL) {
                    goto error;
                }
                Py_SETREF(callargs, tuple);
            }
            assert(PyTuple_CheckExact(callargs));
            EVAL_CALL_STAT_INC_IF_FUNCTION(EVAL_CALL_FUNCTION_EX, func);
            if (opcode == INSTRUMENTED_CALL_FUNCTION_EX &&
                !PyFunction_Check(func) && !PyMethod_Check(func)
            ) {
                PyObject *arg = PyTuple_GET_SIZE(callargs) > 0 ?
                    PyTuple_GET_ITEM(callargs, 0) : Py_None;
                int err = _Py_call_instrumentation_2args(
                    tstate, PY_MONITORING_EVENT_CALL,
                    frame, next_instr-1, func, arg);
                if (err) goto error;
                result = PyObject_Call(func, callargs, kwargs);
                if (result == NULL) {
                    _Py_call_instrumentation_exc2(
                        tstate, PY_MONITORING_EVENT_C_RAISE,
                        frame, next_instr-1, func, arg);
                }
                else {
                    int err = _Py_call_instrumentation_2args(
                        tstate, PY_MONITORING_EVENT_C_RETURN,
                        frame, next_instr-1, func, arg);
                    if (err < 0) {
                        Py_CLEAR(result);
                    }
                }
            }
            else {
                if (Py_TYPE(func) == &PyFunction_Type &&
                    tstate->interp->eval_frame == NULL &&
                    ((PyFunctionObject *)func)->vectorcall == _PyFunction_Vectorcall) {
                    assert(PyTuple_CheckExact(callargs));
                    Py_ssize_t nargs = PyTuple_GET_SIZE(callargs);
                    int code_flags = ((PyCodeObject *)PyFunction_GET_CODE(func))->co_flags;
                    PyObject *locals = code_flags & CO_OPTIMIZED ? NULL : Py_NewRef(PyFunction_GET_GLOBALS(func));

                    _PyInterpreterFrame *new_frame = _PyEvalFramePushAndInit_Ex(tstate,
                                                                                (PyFunctionObject *)func, locals,
                                                                                nargs, callargs, kwargs);
                    // Need to manually shrink the stack since we exit with DISPATCH_INLINED.
                    STACK_SHRINK(oparg + 3);
                    if (new_frame == NULL) {
                        goto error;
                    }
                    frame->return_offset = 0;
                    DISPATCH_INLINED(new_frame);
                }
                result = PyObject_Call(func, callargs, kwargs);
            }
            #line 4499 "Python/generated_cases.c.h"
            Py_DECREF(func);
            Py_DECREF(callargs);
            Py_XDECREF(kwargs);
            #line 3194 "Python/bytecodes.c"
            assert(PEEK(3 + (oparg & 1)) == NULL);
            if (result == NULL) { STACK_SHRINK(((oparg & 1) ? 1 : 0)); goto pop_3_error; }
            #line 4506 "Python/generated_cases.c.h"
            STACK_SHRINK(((oparg & 1) ? 1 : 0));
            STACK_SHRINK(2);
            stack_pointer[-1] = result;
            CHECK_EVAL_BREAKER();
            DISPATCH();
        }

        TARGET(MAKE_FUNCTION) {
            PyObject *codeobj = stack_pointer[-1];
            PyObject *closure = (oparg & 0x08) ? stack_pointer[-(1 + ((oparg & 0x08) ? 1 : 0))] : NULL;
            PyObject *annotations = (oparg & 0x04) ? stack_pointer[-(1 + ((oparg & 0x08) ? 1 : 0) + ((oparg & 0x04) ? 1 : 0))] : NULL;
            PyObject *kwdefaults = (oparg & 0x02) ? stack_pointer[-(1 + ((oparg & 0x08) ? 1 : 0) + ((oparg & 0x04) ? 1 : 0) + ((oparg & 0x02) ? 1 : 0))] : NULL;
            PyObject *defaults = (oparg & 0x01) ? stack_pointer[-(1 + ((oparg & 0x08) ? 1 : 0) + ((oparg & 0x04) ? 1 : 0) + ((oparg & 0x02) ? 1 : 0) + ((oparg & 0x01) ? 1 : 0))] : NULL;
            PyObject *func;
            #line 3204 "Python/bytecodes.c"

            PyFunctionObject *func_obj = (PyFunctionObject *)
                PyFunction_New(codeobj, GLOBALS());

            Py_DECREF(codeobj);
            if (func_obj == NULL) {
                goto error;
            }

            if (oparg & 0x08) {
                assert(PyTuple_CheckExact(closure));
                func_obj->func_closure = closure;
            }
            if (oparg & 0x04) {
                assert(PyTuple_CheckExact(annotations));
                func_obj->func_annotations = annotations;
            }
            if (oparg & 0x02) {
                assert(PyDict_CheckExact(kwdefaults));
                func_obj->func_kwdefaults = kwdefaults;
            }
            if (oparg & 0x01) {
                assert(PyTuple_CheckExact(defaults));
                func_obj->func_defaults = defaults;
            }

            func_obj->func_version = ((PyCodeObject *)codeobj)->co_version;
            func = (PyObject *)func_obj;
            #line 4550 "Python/generated_cases.c.h"
            STACK_SHRINK(((oparg & 0x01) ? 1 : 0) + ((oparg & 0x02) ? 1 : 0) + ((oparg & 0x04) ? 1 : 0) + ((oparg & 0x08) ? 1 : 0));
            stack_pointer[-1] = func;
            DISPATCH();
        }

        TARGET(RETURN_GENERATOR) {
            #line 3235 "Python/bytecodes.c"
            assert(PyFunction_Check(frame->f_funcobj));
            PyFunctionObject *func = (PyFunctionObject *)frame->f_funcobj;
            PyGenObject *gen = (PyGenObject *)_Py_MakeCoro(func);
            if (gen == NULL) {
                goto error;
            }
            assert(EMPTY());
            _PyFrame_SetStackPointer(frame, stack_pointer);
            _PyInterpreterFrame *gen_frame = (_PyInterpreterFrame *)gen->gi_iframe;
            _PyFrame_Copy(frame, gen_frame);
            assert(frame->frame_obj == NULL);
            gen->gi_frame_state = FRAME_CREATED;
            gen_frame->owner = FRAME_OWNED_BY_GENERATOR;
            _Py_LeaveRecursiveCallPy(tstate);
            assert(frame != &entry_frame);
            _PyInterpreterFrame *prev = frame->previous;
            _PyThreadState_PopFrame(tstate, frame);
            frame = cframe.current_frame = prev;
            _PyFrame_StackPush(frame, (PyObject *)gen);
            goto resume_frame;
            #line 4578 "Python/generated_cases.c.h"
        }

        TARGET(BUILD_SLICE) {
            PyObject *step = (oparg == 3) ? stack_pointer[-(((oparg == 3) ? 1 : 0))] : NULL;
            PyObject *stop = stack_pointer[-(1 + ((oparg == 3) ? 1 : 0))];
            PyObject *start = stack_pointer[-(2 + ((oparg == 3) ? 1 : 0))];
            PyObject *slice;
            #line 3258 "Python/bytecodes.c"
            slice = PySlice_New(start, stop, step);
            #line 4588 "Python/generated_cases.c.h"
            Py_DECREF(start);
            Py_DECREF(stop);
            Py_XDECREF(step);
            #line 3260 "Python/bytecodes.c"
            if (slice == NULL) { STACK_SHRINK(((oparg == 3) ? 1 : 0)); goto pop_2_error; }
            #line 4594 "Python/generated_cases.c.h"
            STACK_SHRINK(((oparg == 3) ? 1 : 0));
            STACK_SHRINK(1);
            stack_pointer[-1] = slice;
            DISPATCH();
        }

        TARGET(FORMAT_VALUE) {
            PyObject *fmt_spec = ((oparg & FVS_MASK) == FVS_HAVE_SPEC) ? stack_pointer[-((((oparg & FVS_MASK) == FVS_HAVE_SPEC) ? 1 : 0))] : NULL;
            PyObject *value = stack_pointer[-(1 + (((oparg & FVS_MASK) == FVS_HAVE_SPEC) ? 1 : 0))];
            PyObject *result;
            #line 3264 "Python/bytecodes.c"
            /* Handles f-string value formatting. */
            PyObject *(*conv_fn)(PyObject *);
            int which_conversion = oparg & FVC_MASK;

            /* See if any conversion is specified. */
            switch (which_conversion) {
            case FVC_NONE:  conv_fn = NULL;           break;
            case FVC_STR:   conv_fn = PyObject_Str;   break;
            case FVC_REPR:  conv_fn = PyObject_Repr;  break;
            case FVC_ASCII: conv_fn = PyObject_ASCII; break;
            default:
                _PyErr_Format(tstate, PyExc_SystemError,
                              "unexpected conversion flag %d",
                              which_conversion);
                goto error;
            }

            /* If there's a conversion function, call it and replace
               value with that result. Otherwise, just use value,
               without conversion. */
            if (conv_fn != NULL) {
                result = conv_fn(value);
                Py_DECREF(value);
                if (result == NULL) {
                    Py_XDECREF(fmt_spec);
                    if (true) { STACK_SHRINK((((oparg & FVS_MASK) == FVS_HAVE_SPEC) ? 1 : 0)); goto pop_1_error; }
                }
                value = result;
            }

            result = PyObject_Format(value, fmt_spec);
            Py_DECREF(value);
            Py_XDECREF(fmt_spec);
            if (result == NULL) { STACK_SHRINK((((oparg & FVS_MASK) == FVS_HAVE_SPEC) ? 1 : 0)); goto pop_1_error; }
            #line 4640 "Python/generated_cases.c.h"
            STACK_SHRINK((((oparg & FVS_MASK) == FVS_HAVE_SPEC) ? 1 : 0));
            stack_pointer[-1] = result;
            DISPATCH();
        }

        TARGET(COPY) {
            PyObject *bottom = stack_pointer[-(1 + (oparg-1))];
            PyObject *top;
            #line 3301 "Python/bytecodes.c"
            assert(oparg > 0);
            top = Py_NewRef(bottom);
            #line 4652 "Python/generated_cases.c.h"
            STACK_GROW(1);
            stack_pointer[-1] = top;
            DISPATCH();
        }

        TARGET(BINARY_OP) {
            PREDICTED(BINARY_OP);
            static_assert(INLINE_CACHE_ENTRIES_BINARY_OP == 1, "incorrect cache size");
            PyObject *rhs = stack_pointer[-1];
            PyObject *lhs = stack_pointer[-2];
            PyObject *res;
            #line 3306 "Python/bytecodes.c"
            #if ENABLE_SPECIALIZATION
            _PyBinaryOpCache *cache = (_PyBinaryOpCache *)next_instr;
            if (ADAPTIVE_COUNTER_IS_ZERO(cache->counter)) {
                next_instr--;
                _Py_Specialize_BinaryOp(lhs, rhs, next_instr, oparg, &GETLOCAL(0));
                DISPATCH_SAME_OPARG();
            }
            STAT_INC(BINARY_OP, deferred);
            DECREMENT_ADAPTIVE_COUNTER(cache->counter);
            #endif  /* ENABLE_SPECIALIZATION */
            assert(0 <= oparg);
            assert((unsigned)oparg < Py_ARRAY_LENGTH(binary_ops));
            assert(binary_ops[oparg]);
            res = binary_ops[oparg](lhs, rhs);
            #line 4679 "Python/generated_cases.c.h"
            Py_DECREF(lhs);
            Py_DECREF(rhs);
            #line 3321 "Python/bytecodes.c"
            if (res == NULL) goto pop_2_error;
            #line 4684 "Python/generated_cases.c.h"
            STACK_SHRINK(1);
            stack_pointer[-1] = res;
            next_instr += 1;
            DISPATCH();
        }

        TARGET(SWAP) {
            PyObject *top = stack_pointer[-1];
            PyObject *bottom = stack_pointer[-(2 + (oparg-2))];
            #line 3326 "Python/bytecodes.c"
            assert(oparg >= 2);
            #line 4696 "Python/generated_cases.c.h"
            stack_pointer[-1] = bottom;
            stack_pointer[-(2 + (oparg-2))] = top;
            DISPATCH();
        }

        TARGET(INSTRUMENTED_INSTRUCTION) {
            #line 3330 "Python/bytecodes.c"
            int next_opcode = _Py_call_instrumentation_instruction(
                tstate, frame, next_instr-1);
            if (next_opcode < 0) goto error;
            next_instr--;
            if (_PyOpcode_Caches[next_opcode]) {
                _PyBinaryOpCache *cache = (_PyBinaryOpCache *)(next_instr+1);
                INCREMENT_ADAPTIVE_COUNTER(cache->counter);
            }
            assert(next_opcode > 0 && next_opcode < 256);
            opcode = next_opcode;
            DISPATCH_GOTO();
            #line 4715 "Python/generated_cases.c.h"
        }

        TARGET(INSTRUMENTED_JUMP_FORWARD) {
            #line 3344 "Python/bytecodes.c"
            INSTRUMENTED_JUMP(next_instr-1, next_instr+oparg, PY_MONITORING_EVENT_JUMP);
            #line 4721 "Python/generated_cases.c.h"
            DISPATCH();
        }

        TARGET(INSTRUMENTED_JUMP_BACKWARD) {
            #line 3348 "Python/bytecodes.c"
            INSTRUMENTED_JUMP(next_instr-1, next_instr-oparg, PY_MONITORING_EVENT_JUMP);
            #line 4728 "Python/generated_cases.c.h"
            CHECK_EVAL_BREAKER();
            DISPATCH();
        }

        TARGET(INSTRUMENTED_POP_JUMP_IF_TRUE) {
            #line 3353 "Python/bytecodes.c"
            PyObject *cond = POP();
            int err = PyObject_IsTrue(cond);
            Py_DECREF(cond);
            if (err < 0) goto error;
            _Py_CODEUNIT *here = next_instr-1;
            assert(err == 0 || err == 1);
            int offset = err*oparg;
            INSTRUMENTED_JUMP(here, next_instr + offset, PY_MONITORING_EVENT_BRANCH);
            #line 4743 "Python/generated_cases.c.h"
            DISPATCH();
        }

        TARGET(INSTRUMENTED_POP_JUMP_IF_FALSE) {
            #line 3364 "Python/bytecodes.c"
            PyObject *cond = POP();
            int err = PyObject_IsTrue(cond);
            Py_DECREF(cond);
            if (err < 0) goto error;
            _Py_CODEUNIT *here = next_instr-1;
            assert(err == 0 || err == 1);
            int offset = (1-err)*oparg;
            INSTRUMENTED_JUMP(here, next_instr + offset, PY_MONITORING_EVENT_BRANCH);
            #line 4757 "Python/generated_cases.c.h"
            DISPATCH();
        }

        TARGET(INSTRUMENTED_POP_JUMP_IF_NONE) {
            #line 3375 "Python/bytecodes.c"
            PyObject *value = POP();
            _Py_CODEUNIT *here = next_instr-1;
            int offset;
            if (Py_IsNone(value)) {
                offset = oparg;
            }
            else {
                Py_DECREF(value);
                offset = 0;
            }
            INSTRUMENTED_JUMP(here, next_instr + offset, PY_MONITORING_EVENT_BRANCH);
            #line 4774 "Python/generated_cases.c.h"
            DISPATCH();
        }

        TARGET(INSTRUMENTED_POP_JUMP_IF_NOT_NONE) {
            #line 3389 "Python/bytecodes.c"
            PyObject *value = POP();
            _Py_CODEUNIT *here = next_instr-1;
            int offset;
            if (Py_IsNone(value)) {
                offset = 0;
            }
            else {
                Py_DECREF(value);
                 offset = oparg;
            }
            INSTRUMENTED_JUMP(here, next_instr + offset, PY_MONITORING_EVENT_BRANCH);
            #line 4791 "Python/generated_cases.c.h"
            DISPATCH();
        }

        TARGET(EXTENDED_ARG) {
            #line 3403 "Python/bytecodes.c"
            assert(oparg);
            opcode = next_instr->op.code;
            oparg = oparg << 8 | next_instr->op.arg;
            PRE_DISPATCH_GOTO();
            DISPATCH_GOTO();
            #line 4802 "Python/generated_cases.c.h"
        }

        TARGET(CACHE) {
            #line 3411 "Python/bytecodes.c"
            assert(0 && "Executing a cache.");
            Py_UNREACHABLE();
            #line 4809 "Python/generated_cases.c.h"
        }

        TARGET(RESERVED) {
            #line 3416 "Python/bytecodes.c"
            assert(0 && "Executing RESERVED instruction.");
            Py_UNREACHABLE();
            #line 4816 "Python/generated_cases.c.h"
        }
