# coding: utf-8
#
# This file is generated by module/emoji/make_emoji_trie.py. Do not
# edit it directly.
#
# Emoji trie data.
#
#
# It contains a data structure that can be used to determine if a
# sequence of codepoints is an emoji and if it should be rendered
# in an emoji font.
#
# Each trie node is a dictionary mapping codepoints to other dictionaries.
# If a codepoint is not present in the dictionarly, look up the '' key
# in the dictionary to find what it maps to. (It will be one of the constants
# below.
#
# The top-level dictionary is named emoji.

# The codepoint is not an emoji.
NOT_EMOJI = 0

# The codepoints are an emoji, but it may or may not be rendered in an emoji font.
UNQUALIFIED = 1

# The codepoints are part of a larger emoji sequence, and should be rendered
# in an emoji font when standing alone.
COMPONENT = 2

# The codepoints are an emoji, and should be rendered in an emoji font, but
# aren't fully qualified.
MINIMALLY_QUALIFIED = 3

# The codepoints are an emoji, and should be rendered in an emoji font.
QUALIFIED = 4


e1 = { '': 4, }
e189 = { '': 2, }
e14 = { '': 1, }
e53 = { '': 3, }
e2 = { '': 1, '️': e1, }
e5 = { '': 3, '️': e1, }
e7 = { '': 0, '💨': e1, }
e9 = { '': 0, '💫': e1, }
e12 = { '': 0, '🔥': e1, '🩹': e1, }
e20 = { '': 4, '🏻': e1, '🏼': e1, '🏽': e1, '🏾': e1, '🏿': e1, }
e21 = { '': 1, '️': e1, '🏻': e1, '🏼': e1, '🏽': e1, '🏾': e1, '🏿': e1, }
e25 = { '': 0, '🏼': e1, '🏽': e1, '🏾': e1, '🏿': e1, }
e28 = { '': 0, '🏻': e1, '🏽': e1, '🏾': e1, '🏿': e1, }
e31 = { '': 0, '🏻': e1, '🏼': e1, '🏾': e1, '🏿': e1, }
e34 = { '': 0, '🏻': e1, '🏼': e1, '🏽': e1, '🏿': e1, }
e37 = { '': 0, '🏻': e1, '🏼': e1, '🏽': e1, '🏾': e1, }
e43 = { '': 0, '🏻': e1, '🏼': e1, '🏽': e1, '🏾': e1, '🏿': e1, }
e100 = { '': 0, '🧑': e1, }
e139 = { '': 0, '👨': e1, }
e146 = { '': 0, '👦': e1, }
e148 = { '': 0, '👦': e1, '👧': e1, }
e183 = { '': 0, '👨': e1, '👩': e1, }
e191 = { '': 0, '🦺': e1, }
e193 = { '': 0, '⬛': e1, }
e197 = { '': 0, '⃣': e1, }
e204 = { '': 0, '󠁿': e1, }
e213 = { '': 0, '🇨': e1, '🇩': e1, '🇪': e1, '🇫': e1, '🇬': e1, '🇮': e1, '🇱': e1, '🇲': e1, '🇴': e1, '🇶': e1, '🇷': e1, '🇸': e1, '🇹': e1, '🇺': e1, '🇼': e1, '🇽': e1, '🇿': e1, }
e214 = { '': 0, '🇦': e1, '🇧': e1, '🇩': e1, '🇪': e1, '🇫': e1, '🇬': e1, '🇭': e1, '🇮': e1, '🇯': e1, '🇱': e1, '🇲': e1, '🇳': e1, '🇴': e1, '🇶': e1, '🇷': e1, '🇸': e1, '🇹': e1, '🇻': e1, '🇼': e1, '🇾': e1, '🇿': e1, }
e215 = { '': 0, '🇦': e1, '🇨': e1, '🇩': e1, '🇫': e1, '🇬': e1, '🇭': e1, '🇮': e1, '🇰': e1, '🇱': e1, '🇲': e1, '🇳': e1, '🇴': e1, '🇵': e1, '🇷': e1, '🇺': e1, '🇻': e1, '🇼': e1, '🇽': e1, '🇾': e1, '🇿': e1, }
e216 = { '': 0, '🇪': e1, '🇬': e1, '🇯': e1, '🇰': e1, '🇲': e1, '🇴': e1, '🇿': e1, }
e217 = { '': 0, '🇦': e1, '🇨': e1, '🇪': e1, '🇬': e1, '🇭': e1, '🇷': e1, '🇸': e1, '🇹': e1, '🇺': e1, }
e218 = { '': 0, '🇮': e1, '🇯': e1, '🇰': e1, '🇲': e1, '🇴': e1, '🇷': e1, }
e219 = { '': 0, '🇦': e1, '🇧': e1, '🇩': e1, '🇪': e1, '🇫': e1, '🇬': e1, '🇭': e1, '🇮': e1, '🇱': e1, '🇲': e1, '🇳': e1, '🇵': e1, '🇶': e1, '🇷': e1, '🇸': e1, '🇹': e1, '🇺': e1, '🇼': e1, '🇾': e1, }
e220 = { '': 0, '🇰': e1, '🇲': e1, '🇳': e1, '🇷': e1, '🇹': e1, '🇺': e1, }
e221 = { '': 0, '🇨': e1, '🇩': e1, '🇪': e1, '🇱': e1, '🇲': e1, '🇳': e1, '🇴': e1, '🇶': e1, '🇷': e1, '🇸': e1, '🇹': e1, }
e222 = { '': 0, '🇪': e1, '🇲': e1, '🇴': e1, '🇵': e1, }
e223 = { '': 0, '🇪': e1, '🇬': e1, '🇭': e1, '🇮': e1, '🇲': e1, '🇳': e1, '🇵': e1, '🇷': e1, '🇼': e1, '🇾': e1, '🇿': e1, }
e224 = { '': 0, '🇦': e1, '🇧': e1, '🇨': e1, '🇮': e1, '🇰': e1, '🇷': e1, '🇸': e1, '🇹': e1, '🇺': e1, '🇻': e1, '🇾': e1, }
e225 = { '': 0, '🇦': e1, '🇨': e1, '🇩': e1, '🇪': e1, '🇫': e1, '🇬': e1, '🇭': e1, '🇰': e1, '🇱': e1, '🇲': e1, '🇳': e1, '🇴': e1, '🇵': e1, '🇶': e1, '🇷': e1, '🇸': e1, '🇹': e1, '🇺': e1, '🇻': e1, '🇼': e1, '🇽': e1, '🇾': e1, '🇿': e1, }
e226 = { '': 0, '🇦': e1, '🇨': e1, '🇪': e1, '🇫': e1, '🇬': e1, '🇮': e1, '🇱': e1, '🇴': e1, '🇵': e1, '🇷': e1, '🇺': e1, '🇿': e1, }
e227 = { '': 0, '🇲': e1, }
e228 = { '': 0, '🇦': e1, '🇪': e1, '🇫': e1, '🇬': e1, '🇭': e1, '🇰': e1, '🇱': e1, '🇲': e1, '🇳': e1, '🇷': e1, '🇸': e1, '🇹': e1, '🇼': e1, '🇾': e1, }
e229 = { '': 0, '🇦': e1, }
e230 = { '': 0, '🇪': e1, '🇴': e1, '🇸': e1, '🇺': e1, '🇼': e1, }
e231 = { '': 0, '🇦': e1, '🇧': e1, '🇨': e1, '🇩': e1, '🇪': e1, '🇬': e1, '🇭': e1, '🇮': e1, '🇯': e1, '🇰': e1, '🇱': e1, '🇲': e1, '🇳': e1, '🇴': e1, '🇷': e1, '🇸': e1, '🇹': e1, '🇻': e1, '🇽': e1, '🇾': e1, '🇿': e1, }
e232 = { '': 0, '🇦': e1, '🇨': e1, '🇩': e1, '🇫': e1, '🇬': e1, '🇭': e1, '🇯': e1, '🇰': e1, '🇱': e1, '🇲': e1, '🇳': e1, '🇴': e1, '🇷': e1, '🇹': e1, '🇻': e1, '🇼': e1, '🇿': e1, }
e233 = { '': 0, '🇦': e1, '🇬': e1, '🇲': e1, '🇳': e1, '🇸': e1, '🇾': e1, '🇿': e1, }
e234 = { '': 0, '🇦': e1, '🇨': e1, '🇪': e1, '🇬': e1, '🇮': e1, '🇳': e1, '🇺': e1, }
e235 = { '': 0, '🇫': e1, '🇸': e1, }
e236 = { '': 0, '🇰': e1, }
e237 = { '': 0, '🇪': e1, '🇹': e1, }
e238 = { '': 0, '🇦': e1, '🇲': e1, '🇼': e1, }
e13 = { '': 0, '🔥': e14, '🩹': e14, }
e19 = { '': 1, '️': e14, }
e52 = { '': 0, '🏼': e53, '🏽': e53, '🏾': e53, '🏿': e53, }
e64 = { '': 0, '🏻': e53, '🏽': e53, '🏾': e53, '🏿': e53, }
e75 = { '': 0, '🏻': e53, '🏼': e53, '🏾': e53, '🏿': e53, }
e86 = { '': 0, '🏻': e53, '🏼': e53, '🏽': e53, '🏿': e53, }
e97 = { '': 0, '🏻': e53, '🏼': e53, '🏽': e53, '🏾': e53, }
e117 = { '': 0, '🏻': e53, '🏼': e53, '🏽': e53, '🏾': e53, '🏿': e53, }
e142 = { '': 0, '👨': e53, }
e186 = { '': 0, '👨': e53, '👩': e53, }
e4 = { '': 0, '🌫': e5, }
e17 = { '': 0, '🗨': e5, }
e103 = { '': 0, '♀': e5, '♂': e5, }
e195 = { '': 0, '❄': e5, }
e199 = { '': 0, '☠': e5, }
e211 = { '': 0, '⚧': e5, '🌈': e1, }
e6 = { '': 4, '‍': e7, }
e8 = { '': 4, '‍': e9, }
e11 = { '': 4, '‍': e12, }
e24 = { '': 0, '🫲': e25, }
e48 = { '': 0, '🧑': e25, }
e108 = { '': 0, '👨': e25, }
e153 = { '': 0, '👨': e25, '👩': e25, }
e27 = { '': 0, '🫲': e28, }
e60 = { '': 0, '🧑': e28, }
e121 = { '': 0, '👨': e28, }
e165 = { '': 0, '👨': e28, '👩': e28, }
e30 = { '': 0, '🫲': e31, }
e71 = { '': 0, '🧑': e31, }
e125 = { '': 0, '👨': e31, }
e169 = { '': 0, '👨': e31, '👩': e31, }
e33 = { '': 0, '🫲': e34, }
e82 = { '': 0, '🧑': e34, }
e129 = { '': 0, '👨': e34, }
e173 = { '': 0, '👨': e34, '👩': e34, }
e36 = { '': 0, '🫲': e37, }
e93 = { '': 0, '🧑': e37, }
e133 = { '': 0, '👨': e37, }
e177 = { '': 0, '👨': e37, '👩': e37, }
e42 = { '': 0, '🧑': e43, }
e113 = { '': 0, '👨': e43, }
e158 = { '': 0, '👨': e43, '👩': e43, }
e99 = { '': 0, '‍': e100, }
e138 = { '': 0, '‍': e139, }
e145 = { '': 4, '‍': e146, }
e147 = { '': 4, '‍': e148, }
e182 = { '': 0, '‍': e183, }
e190 = { '': 4, '‍': e191, }
e192 = { '': 4, '‍': e193, }
e196 = { '': 0, '⃣': e14, '️': e197, }
e203 = { '': 0, '󠁧': e204, }
e206 = { '': 0, '󠁴': e204, }
e208 = { '': 0, '󠁳': e204, }
e18 = { '': 0, '🗨': e19, }
e188 = { '': 0, '♀': e19, '♂': e19, }
e212 = { '': 0, '⚧': e19, '🌈': e14, }
e51 = { '': 0, '🧑': e52, }
e63 = { '': 0, '🧑': e64, }
e74 = { '': 0, '🧑': e75, }
e85 = { '': 0, '🧑': e86, }
e96 = { '': 0, '🧑': e97, }
e116 = { '': 0, '👨': e117, }
e161 = { '': 0, '👨': e117, '👩': e117, }
e141 = { '': 0, '‍': e142, }
e185 = { '': 0, '‍': e186, }
e3 = { '': 4, '‍': e4, }
e16 = { '': 4, '‍': e17, }
e102 = { '': 4, '‍': e103, }
e194 = { '': 4, '‍': e195, }
e210 = { '': 4, '‍': e211, }
e10 = { '': 1, '‍': e13, '️': e11, }
e23 = { '': 4, '‍': e24, }
e47 = { '': 0, '‍': e48, }
e107 = { '': 0, '‍': e108, }
e152 = { '': 0, '‍': e153, }
e26 = { '': 4, '‍': e27, }
e59 = { '': 0, '‍': e60, }
e120 = { '': 0, '‍': e121, }
e164 = { '': 0, '‍': e165, }
e29 = { '': 4, '‍': e30, }
e70 = { '': 0, '‍': e71, }
e124 = { '': 0, '‍': e125, }
e168 = { '': 0, '‍': e169, }
e32 = { '': 4, '‍': e33, }
e81 = { '': 0, '‍': e82, }
e128 = { '': 0, '‍': e129, }
e172 = { '': 0, '‍': e173, }
e35 = { '': 4, '‍': e36, }
e92 = { '': 0, '‍': e93, }
e132 = { '': 0, '‍': e133, }
e176 = { '': 0, '‍': e177, }
e41 = { '': 0, '‍': e42, }
e112 = { '': 0, '‍': e113, }
e157 = { '': 0, '‍': e158, }
e98 = { '': 0, '⚕': e5, '⚖': e5, '✈': e5, '🌾': e1, '🍳': e1, '🍼': e1, '🎄': e1, '🎓': e1, '🎤': e1, '🎨': e1, '🏫': e1, '🏭': e1, '💻': e1, '💼': e1, '🔧': e1, '🔬': e1, '🚀': e1, '🚒': e1, '🤝': e99, '🦯': e1, '🦰': e1, '🦱': e1, '🦲': e1, '🦳': e1, '🦼': e1, '🦽': e1, }
e137 = { '': 0, '👨': e1, '💋': e138, }
e144 = { '': 0, '👦': e145, '👧': e147, }
e181 = { '': 0, '👨': e1, '👩': e1, '💋': e182, }
e202 = { '': 0, '󠁮': e203, }
e205 = { '': 0, '󠁣': e206, }
e207 = { '': 0, '󠁬': e208, }
e50 = { '': 0, '‍': e51, }
e62 = { '': 0, '‍': e63, }
e73 = { '': 0, '‍': e74, }
e84 = { '': 0, '‍': e85, }
e95 = { '': 0, '‍': e96, }
e115 = { '': 0, '‍': e116, }
e160 = { '': 0, '‍': e161, }
e140 = { '': 0, '👨': e53, '💋': e141, }
e184 = { '': 0, '👨': e53, '👩': e53, '💋': e185, }
e15 = { '': 1, '‍': e18, '️': e16, }
e101 = { '': 4, '‍': e103, '🏻': e102, '🏼': e102, '🏽': e102, '🏾': e102, '🏿': e102, }
e187 = { '': 1, '‍': e188, '️': e102, '🏻': e102, '🏼': e102, '🏽': e102, '🏾': e102, '🏿': e102, }
e209 = { '': 1, '‍': e212, '️': e210, }
e46 = { '': 0, '💋': e47, '🧑': e25, }
e58 = { '': 0, '💋': e59, '🧑': e28, }
e69 = { '': 0, '💋': e70, '🧑': e31, }
e80 = { '': 0, '💋': e81, '🧑': e34, }
e22 = { '': 4, '🏻': e23, '🏼': e26, '🏽': e29, '🏾': e32, '🏿': e35, }
e91 = { '': 0, '💋': e92, '🧑': e37, }
e111 = { '': 0, '👨': e43, '💋': e112, }
e156 = { '': 0, '👨': e43, '👩': e43, '💋': e157, }
e136 = { '': 0, '‍': e137, }
e143 = { '': 0, '‍': e144, }
e180 = { '': 0, '‍': e181, }
e201 = { '': 0, '󠁥': e202, '󠁳': e205, '󠁷': e207, }
e49 = { '': 0, '💋': e50, '🧑': e52, }
e61 = { '': 0, '💋': e62, '🧑': e64, }
e72 = { '': 0, '💋': e73, '🧑': e75, }
e83 = { '': 0, '💋': e84, '🧑': e86, }
e94 = { '': 0, '💋': e95, '🧑': e97, }
e114 = { '': 0, '👨': e117, '💋': e115, }
e159 = { '': 0, '👨': e117, '👩': e117, '💋': e160, }
e45 = { '': 0, '‍': e46, }
e57 = { '': 0, '‍': e58, }
e68 = { '': 0, '‍': e69, }
e79 = { '': 0, '‍': e80, }
e90 = { '': 0, '‍': e91, }
e110 = { '': 0, '‍': e111, }
e155 = { '': 0, '‍': e156, }
e135 = { '': 0, '‍': e140, '️': e136, }
e179 = { '': 0, '‍': e184, '️': e180, }
e200 = { '': 0, '󠁢': e201, }
e44 = { '': 0, '‍': e49, '️': e45, }
e56 = { '': 0, '‍': e61, '️': e57, }
e67 = { '': 0, '‍': e72, '️': e68, }
e78 = { '': 0, '‍': e83, '️': e79, }
e89 = { '': 0, '‍': e94, '️': e90, }
e109 = { '': 0, '‍': e114, '️': e110, }
e154 = { '': 0, '‍': e159, '️': e155, }
e134 = { '': 0, '⚕': e5, '⚖': e5, '✈': e5, '❤': e135, '🌾': e1, '🍳': e1, '🍼': e1, '🎓': e1, '🎤': e1, '🎨': e1, '🏫': e1, '🏭': e1, '👦': e145, '👧': e147, '👨': e143, '👩': e143, '💻': e1, '💼': e1, '🔧': e1, '🔬': e1, '🚀': e1, '🚒': e1, '🦯': e1, '🦰': e1, '🦱': e1, '🦲': e1, '🦳': e1, '🦼': e1, '🦽': e1, }
e178 = { '': 0, '⚕': e5, '⚖': e5, '✈': e5, '❤': e179, '🌾': e1, '🍳': e1, '🍼': e1, '🎓': e1, '🎤': e1, '🎨': e1, '🏫': e1, '🏭': e1, '👦': e145, '👧': e147, '👩': e143, '💻': e1, '💼': e1, '🔧': e1, '🔬': e1, '🚀': e1, '🚒': e1, '🦯': e1, '🦰': e1, '🦱': e1, '🦲': e1, '🦳': e1, '🦼': e1, '🦽': e1, }
e198 = { '': 4, '‍': e199, '󠁧': e200, }
e40 = { '': 0, '⚕': e5, '⚖': e5, '✈': e5, '❤': e44, '🌾': e1, '🍳': e1, '🍼': e1, '🎄': e1, '🎓': e1, '🎤': e1, '🎨': e1, '🏫': e1, '🏭': e1, '💻': e1, '💼': e1, '🔧': e1, '🔬': e1, '🚀': e1, '🚒': e1, '🤝': e41, '🦯': e1, '🦰': e1, '🦱': e1, '🦲': e1, '🦳': e1, '🦼': e1, '🦽': e1, }
e55 = { '': 0, '⚕': e5, '⚖': e5, '✈': e5, '❤': e56, '🌾': e1, '🍳': e1, '🍼': e1, '🎄': e1, '🎓': e1, '🎤': e1, '🎨': e1, '🏫': e1, '🏭': e1, '💻': e1, '💼': e1, '🔧': e1, '🔬': e1, '🚀': e1, '🚒': e1, '🤝': e41, '🦯': e1, '🦰': e1, '🦱': e1, '🦲': e1, '🦳': e1, '🦼': e1, '🦽': e1, }
e66 = { '': 0, '⚕': e5, '⚖': e5, '✈': e5, '❤': e67, '🌾': e1, '🍳': e1, '🍼': e1, '🎄': e1, '🎓': e1, '🎤': e1, '🎨': e1, '🏫': e1, '🏭': e1, '💻': e1, '💼': e1, '🔧': e1, '🔬': e1, '🚀': e1, '🚒': e1, '🤝': e41, '🦯': e1, '🦰': e1, '🦱': e1, '🦲': e1, '🦳': e1, '🦼': e1, '🦽': e1, }
e77 = { '': 0, '⚕': e5, '⚖': e5, '✈': e5, '❤': e78, '🌾': e1, '🍳': e1, '🍼': e1, '🎄': e1, '🎓': e1, '🎤': e1, '🎨': e1, '🏫': e1, '🏭': e1, '💻': e1, '💼': e1, '🔧': e1, '🔬': e1, '🚀': e1, '🚒': e1, '🤝': e41, '🦯': e1, '🦰': e1, '🦱': e1, '🦲': e1, '🦳': e1, '🦼': e1, '🦽': e1, }
e88 = { '': 0, '⚕': e5, '⚖': e5, '✈': e5, '❤': e89, '🌾': e1, '🍳': e1, '🍼': e1, '🎄': e1, '🎓': e1, '🎤': e1, '🎨': e1, '🏫': e1, '🏭': e1, '💻': e1, '💼': e1, '🔧': e1, '🔬': e1, '🚀': e1, '🚒': e1, '🤝': e41, '🦯': e1, '🦰': e1, '🦱': e1, '🦲': e1, '🦳': e1, '🦼': e1, '🦽': e1, }
e106 = { '': 0, '⚕': e5, '⚖': e5, '✈': e5, '❤': e109, '🌾': e1, '🍳': e1, '🍼': e1, '🎓': e1, '🎤': e1, '🎨': e1, '🏫': e1, '🏭': e1, '💻': e1, '💼': e1, '🔧': e1, '🔬': e1, '🚀': e1, '🚒': e1, '🤝': e107, '🦯': e1, '🦰': e1, '🦱': e1, '🦲': e1, '🦳': e1, '🦼': e1, '🦽': e1, }
e119 = { '': 0, '⚕': e5, '⚖': e5, '✈': e5, '❤': e109, '🌾': e1, '🍳': e1, '🍼': e1, '🎓': e1, '🎤': e1, '🎨': e1, '🏫': e1, '🏭': e1, '💻': e1, '💼': e1, '🔧': e1, '🔬': e1, '🚀': e1, '🚒': e1, '🤝': e120, '🦯': e1, '🦰': e1, '🦱': e1, '🦲': e1, '🦳': e1, '🦼': e1, '🦽': e1, }
e123 = { '': 0, '⚕': e5, '⚖': e5, '✈': e5, '❤': e109, '🌾': e1, '🍳': e1, '🍼': e1, '🎓': e1, '🎤': e1, '🎨': e1, '🏫': e1, '🏭': e1, '💻': e1, '💼': e1, '🔧': e1, '🔬': e1, '🚀': e1, '🚒': e1, '🤝': e124, '🦯': e1, '🦰': e1, '🦱': e1, '🦲': e1, '🦳': e1, '🦼': e1, '🦽': e1, }
e127 = { '': 0, '⚕': e5, '⚖': e5, '✈': e5, '❤': e109, '🌾': e1, '🍳': e1, '🍼': e1, '🎓': e1, '🎤': e1, '🎨': e1, '🏫': e1, '🏭': e1, '💻': e1, '💼': e1, '🔧': e1, '🔬': e1, '🚀': e1, '🚒': e1, '🤝': e128, '🦯': e1, '🦰': e1, '🦱': e1, '🦲': e1, '🦳': e1, '🦼': e1, '🦽': e1, }
e131 = { '': 0, '⚕': e5, '⚖': e5, '✈': e5, '❤': e109, '🌾': e1, '🍳': e1, '🍼': e1, '🎓': e1, '🎤': e1, '🎨': e1, '🏫': e1, '🏭': e1, '💻': e1, '💼': e1, '🔧': e1, '🔬': e1, '🚀': e1, '🚒': e1, '🤝': e132, '🦯': e1, '🦰': e1, '🦱': e1, '🦲': e1, '🦳': e1, '🦼': e1, '🦽': e1, }
e151 = { '': 0, '⚕': e5, '⚖': e5, '✈': e5, '❤': e154, '🌾': e1, '🍳': e1, '🍼': e1, '🎓': e1, '🎤': e1, '🎨': e1, '🏫': e1, '🏭': e1, '💻': e1, '💼': e1, '🔧': e1, '🔬': e1, '🚀': e1, '🚒': e1, '🤝': e152, '🦯': e1, '🦰': e1, '🦱': e1, '🦲': e1, '🦳': e1, '🦼': e1, '🦽': e1, }
e163 = { '': 0, '⚕': e5, '⚖': e5, '✈': e5, '❤': e154, '🌾': e1, '🍳': e1, '🍼': e1, '🎓': e1, '🎤': e1, '🎨': e1, '🏫': e1, '🏭': e1, '💻': e1, '💼': e1, '🔧': e1, '🔬': e1, '🚀': e1, '🚒': e1, '🤝': e164, '🦯': e1, '🦰': e1, '🦱': e1, '🦲': e1, '🦳': e1, '🦼': e1, '🦽': e1, }
e167 = { '': 0, '⚕': e5, '⚖': e5, '✈': e5, '❤': e154, '🌾': e1, '🍳': e1, '🍼': e1, '🎓': e1, '🎤': e1, '🎨': e1, '🏫': e1, '🏭': e1, '💻': e1, '💼': e1, '🔧': e1, '🔬': e1, '🚀': e1, '🚒': e1, '🤝': e168, '🦯': e1, '🦰': e1, '🦱': e1, '🦲': e1, '🦳': e1, '🦼': e1, '🦽': e1, }
e171 = { '': 0, '⚕': e5, '⚖': e5, '✈': e5, '❤': e154, '🌾': e1, '🍳': e1, '🍼': e1, '🎓': e1, '🎤': e1, '🎨': e1, '🏫': e1, '🏭': e1, '💻': e1, '💼': e1, '🔧': e1, '🔬': e1, '🚀': e1, '🚒': e1, '🤝': e172, '🦯': e1, '🦰': e1, '🦱': e1, '🦲': e1, '🦳': e1, '🦼': e1, '🦽': e1, }
e175 = { '': 0, '⚕': e5, '⚖': e5, '✈': e5, '❤': e154, '🌾': e1, '🍳': e1, '🍼': e1, '🎓': e1, '🎤': e1, '🎨': e1, '🏫': e1, '🏭': e1, '💻': e1, '💼': e1, '🔧': e1, '🔬': e1, '🚀': e1, '🚒': e1, '🤝': e176, '🦯': e1, '🦰': e1, '🦱': e1, '🦲': e1, '🦳': e1, '🦼': e1, '🦽': e1, }
e39 = { '': 4, '‍': e40, }
e54 = { '': 4, '‍': e55, }
e65 = { '': 4, '‍': e66, }
e76 = { '': 4, '‍': e77, }
e87 = { '': 4, '‍': e88, }
e105 = { '': 4, '‍': e106, }
e118 = { '': 4, '‍': e119, }
e122 = { '': 4, '‍': e123, }
e126 = { '': 4, '‍': e127, }
e130 = { '': 4, '‍': e131, }
e150 = { '': 4, '‍': e151, }
e162 = { '': 4, '‍': e163, }
e166 = { '': 4, '‍': e167, }
e170 = { '': 4, '‍': e171, }
e174 = { '': 4, '‍': e175, }
e38 = { '': 4, '‍': e98, '🏻': e39, '🏼': e54, '🏽': e65, '🏾': e76, '🏿': e87, }
e104 = { '': 4, '‍': e134, '🏻': e105, '🏼': e118, '🏽': e122, '🏾': e126, '🏿': e130, }
e149 = { '': 4, '‍': e178, '🏻': e150, '🏼': e162, '🏽': e166, '🏾': e170, '🏿': e174, }
emoji = { '': 0, '#': e196, '*': e196, '0': e196, '1': e196, '2': e196, '3': e196, '4': e196, '5': e196, '6': e196, '7': e196, '8': e196, '9': e196, '©': e2, '®': e2, '‼': e2, '⁉': e2, '™': e2, 'ℹ': e2, '↔': e2, '↕': e2, '↖': e2, '↗': e2, '↘': e2, '↙': e2, '↩': e2, '↪': e2, '⌚': e1, '⌛': e1, '⌨': e2, '⏏': e2, '⏩': e1, '⏪': e1, '⏫': e1, '⏬': e1, '⏭': e2, '⏮': e2, '⏯': e2, '⏰': e1, '⏱': e2, '⏲': e2, '⏳': e1, '⏸': e2, '⏹': e2, '⏺': e2, 'Ⓜ': e2, '▪': e2, '▫': e2, '▶': e2, '◀': e2, '◻': e2, '◼': e2, '◽': e1, '◾': e1, '☀': e2, '☁': e2, '☂': e2, '☃': e2, '☄': e2, '☎': e2, '☑': e2, '☔': e1, '☕': e1, '☘': e2, '☝': e21, '☠': e2, '☢': e2, '☣': e2, '☦': e2, '☪': e2, '☮': e2, '☯': e2, '☸': e2, '☹': e2, '☺': e2, '♀': e2, '♂': e2, '♈': e1, '♉': e1, '♊': e1, '♋': e1, '♌': e1, '♍': e1, '♎': e1, '♏': e1, '♐': e1, '♑': e1, '♒': e1, '♓': e1, '♟': e2, '♠': e2, '♣': e2, '♥': e2, '♦': e2, '♨': e2, '♻': e2, '♾': e2, '♿': e1, '⚒': e2, '⚓': e1, '⚔': e2, '⚕': e2, '⚖': e2, '⚗': e2, '⚙': e2, '⚛': e2, '⚜': e2, '⚠': e2, '⚡': e1, '⚧': e2, '⚪': e1, '⚫': e1, '⚰': e2, '⚱': e2, '⚽': e1, '⚾': e1, '⛄': e1, '⛅': e1, '⛈': e2, '⛎': e1, '⛏': e2, '⛑': e2, '⛓': e2, '⛔': e1, '⛩': e2, '⛪': e1, '⛰': e2, '⛱': e2, '⛲': e1, '⛳': e1, '⛴': e2, '⛵': e1, '⛷': e2, '⛸': e2, '⛹': e187, '⛺': e1, '⛽': e1, '✂': e2, '✅': e1, '✈': e2, '✉': e2, '✊': e20, '✋': e20, '✌': e21, '✍': e21, '✏': e2, '✒': e2, '✔': e2, '✖': e2, '✝': e2, '✡': e2, '✨': e1, '✳': e2, '✴': e2, '❄': e2, '❇': e2, '❌': e1, '❎': e1, '❓': e1, '❔': e1, '❕': e1, '❗': e1, '❣': e2, '❤': e10, '➕': e1, '➖': e1, '➗': e1, '➡': e2, '➰': e1, '➿': e1, '⤴': e2, '⤵': e2, '⬅': e2, '⬆': e2, '⬇': e2, '⬛': e1, '⬜': e1, '⭐': e1, '⭕': e1, '〰': e2, '〽': e2, '㊗': e2, '㊙': e2, '🀄': e1, '🃏': e1, '🅰': e2, '🅱': e2, '🅾': e2, '🅿': e2, '🆎': e1, '🆑': e1, '🆒': e1, '🆓': e1, '🆔': e1, '🆕': e1, '🆖': e1, '🆗': e1, '🆘': e1, '🆙': e1, '🆚': e1, '🇦': e213, '🇧': e214, '🇨': e215, '🇩': e216, '🇪': e217, '🇫': e218, '🇬': e219, '🇭': e220, '🇮': e221, '🇯': e222, '🇰': e223, '🇱': e224, '🇲': e225, '🇳': e226, '🇴': e227, '🇵': e228, '🇶': e229, '🇷': e230, '🇸': e231, '🇹': e232, '🇺': e233, '🇻': e234, '🇼': e235, '🇽': e236, '🇾': e237, '🇿': e238, '🈁': e1, '🈂': e2, '🈚': e1, '🈯': e1, '🈲': e1, '🈳': e1, '🈴': e1, '🈵': e1, '🈶': e1, '🈷': e2, '🈸': e1, '🈹': e1, '🈺': e1, '🉐': e1, '🉑': e1, '🌀': e1, '🌁': e1, '🌂': e1, '🌃': e1, '🌄': e1, '🌅': e1, '🌆': e1, '🌇': e1, '🌈': e1, '🌉': e1, '🌊': e1, '🌋': e1, '🌌': e1, '🌍': e1, '🌎': e1, '🌏': e1, '🌐': e1, '🌑': e1, '🌒': e1, '🌓': e1, '🌔': e1, '🌕': e1, '🌖': e1, '🌗': e1, '🌘': e1, '🌙': e1, '🌚': e1, '🌛': e1, '🌜': e1, '🌝': e1, '🌞': e1, '🌟': e1, '🌠': e1, '🌡': e2, '🌤': e2, '🌥': e2, '🌦': e2, '🌧': e2, '🌨': e2, '🌩': e2, '🌪': e2, '🌫': e2, '🌬': e2, '🌭': e1, '🌮': e1, '🌯': e1, '🌰': e1, '🌱': e1, '🌲': e1, '🌳': e1, '🌴': e1, '🌵': e1, '🌶': e2, '🌷': e1, '🌸': e1, '🌹': e1, '🌺': e1, '🌻': e1, '🌼': e1, '🌽': e1, '🌾': e1, '🌿': e1, '🍀': e1, '🍁': e1, '🍂': e1, '🍃': e1, '🍄': e1, '🍅': e1, '🍆': e1, '🍇': e1, '🍈': e1, '🍉': e1, '🍊': e1, '🍋': e1, '🍌': e1, '🍍': e1, '🍎': e1, '🍏': e1, '🍐': e1, '🍑': e1, '🍒': e1, '🍓': e1, '🍔': e1, '🍕': e1, '🍖': e1, '🍗': e1, '🍘': e1, '🍙': e1, '🍚': e1, '🍛': e1, '🍜': e1, '🍝': e1, '🍞': e1, '🍟': e1, '🍠': e1, '🍡': e1, '🍢': e1, '🍣': e1, '🍤': e1, '🍥': e1, '🍦': e1, '🍧': e1, '🍨': e1, '🍩': e1, '🍪': e1, '🍫': e1, '🍬': e1, '🍭': e1, '🍮': e1, '🍯': e1, '🍰': e1, '🍱': e1, '🍲': e1, '🍳': e1, '🍴': e1, '🍵': e1, '🍶': e1, '🍷': e1, '🍸': e1, '🍹': e1, '🍺': e1, '🍻': e1, '🍼': e1, '🍽': e2, '🍾': e1, '🍿': e1, '🎀': e1, '🎁': e1, '🎂': e1, '🎃': e1, '🎄': e1, '🎅': e20, '🎆': e1, '🎇': e1, '🎈': e1, '🎉': e1, '🎊': e1, '🎋': e1, '🎌': e1, '🎍': e1, '🎎': e1, '🎏': e1, '🎐': e1, '🎑': e1, '🎒': e1, '🎓': e1, '🎖': e2, '🎗': e2, '🎙': e2, '🎚': e2, '🎛': e2, '🎞': e2, '🎟': e2, '🎠': e1, '🎡': e1, '🎢': e1, '🎣': e1, '🎤': e1, '🎥': e1, '🎦': e1, '🎧': e1, '🎨': e1, '🎩': e1, '🎪': e1, '🎫': e1, '🎬': e1, '🎭': e1, '🎮': e1, '🎯': e1, '🎰': e1, '🎱': e1, '🎲': e1, '🎳': e1, '🎴': e1, '🎵': e1, '🎶': e1, '🎷': e1, '🎸': e1, '🎹': e1, '🎺': e1, '🎻': e1, '🎼': e1, '🎽': e1, '🎾': e1, '🎿': e1, '🏀': e1, '🏁': e1, '🏂': e20, '🏃': e101, '🏄': e101, '🏅': e1, '🏆': e1, '🏇': e20, '🏈': e1, '🏉': e1, '🏊': e101, '🏋': e187, '🏌': e187, '🏍': e2, '🏎': e2, '🏏': e1, '🏐': e1, '🏑': e1, '🏒': e1, '🏓': e1, '🏔': e2, '🏕': e2, '🏖': e2, '🏗': e2, '🏘': e2, '🏙': e2, '🏚': e2, '🏛': e2, '🏜': e2, '🏝': e2, '🏞': e2, '🏟': e2, '🏠': e1, '🏡': e1, '🏢': e1, '🏣': e1, '🏤': e1, '🏥': e1, '🏦': e1, '🏧': e1, '🏨': e1, '🏩': e1, '🏪': e1, '🏫': e1, '🏬': e1, '🏭': e1, '🏮': e1, '🏯': e1, '🏰': e1, '🏳': e209, '🏴': e198, '🏵': e2, '🏷': e2, '🏸': e1, '🏹': e1, '🏺': e1, '🏻': e189, '🏼': e189, '🏽': e189, '🏾': e189, '🏿': e189, '🐀': e1, '🐁': e1, '🐂': e1, '🐃': e1, '🐄': e1, '🐅': e1, '🐆': e1, '🐇': e1, '🐈': e192, '🐉': e1, '🐊': e1, '🐋': e1, '🐌': e1, '🐍': e1, '🐎': e1, '🐏': e1, '🐐': e1, '🐑': e1, '🐒': e1, '🐓': e1, '🐔': e1, '🐕': e190, '🐖': e1, '🐗': e1, '🐘': e1, '🐙': e1, '🐚': e1, '🐛': e1, '🐜': e1, '🐝': e1, '🐞': e1, '🐟': e1, '🐠': e1, '🐡': e1, '🐢': e1, '🐣': e1, '🐤': e1, '🐥': e1, '🐦': e192, '🐧': e1, '🐨': e1, '🐩': e1, '🐪': e1, '🐫': e1, '🐬': e1, '🐭': e1, '🐮': e1, '🐯': e1, '🐰': e1, '🐱': e1, '🐲': e1, '🐳': e1, '🐴': e1, '🐵': e1, '🐶': e1, '🐷': e1, '🐸': e1, '🐹': e1, '🐺': e1, '🐻': e194, '🐼': e1, '🐽': e1, '🐾': e1, '🐿': e2, '👀': e1, '👁': e15, '👂': e20, '👃': e20, '👄': e1, '👅': e1, '👆': e20, '👇': e20, '👈': e20, '👉': e20, '👊': e20, '👋': e20, '👌': e20, '👍': e20, '👎': e20, '👏': e20, '👐': e20, '👑': e1, '👒': e1, '👓': e1, '👔': e1, '👕': e1, '👖': e1, '👗': e1, '👘': e1, '👙': e1, '👚': e1, '👛': e1, '👜': e1, '👝': e1, '👞': e1, '👟': e1, '👠': e1, '👡': e1, '👢': e1, '👣': e1, '👤': e1, '👥': e1, '👦': e20, '👧': e20, '👨': e104, '👩': e149, '👪': e1, '👫': e20, '👬': e20, '👭': e20, '👮': e101, '👯': e102, '👰': e101, '👱': e101, '👲': e20, '👳': e101, '👴': e20, '👵': e20, '👶': e20, '👷': e101, '👸': e20, '👹': e1, '👺': e1, '👻': e1, '👼': e20, '👽': e1, '👾': e1, '👿': e1, '💀': e1, '💁': e101, '💂': e101, '💃': e20, '💄': e1, '💅': e20, '💆': e101, '💇': e101, '💈': e1, '💉': e1, '💊': e1, '💋': e1, '💌': e1, '💍': e1, '💎': e1, '💏': e20, '💐': e1, '💑': e20, '💒': e1, '💓': e1, '💔': e1, '💕': e1, '💖': e1, '💗': e1, '💘': e1, '💙': e1, '💚': e1, '💛': e1, '💜': e1, '💝': e1, '💞': e1, '💟': e1, '💠': e1, '💡': e1, '💢': e1, '💣': e1, '💤': e1, '💥': e1, '💦': e1, '💧': e1, '💨': e1, '💩': e1, '💪': e20, '💫': e1, '💬': e1, '💭': e1, '💮': e1, '💯': e1, '💰': e1, '💱': e1, '💲': e1, '💳': e1, '💴': e1, '💵': e1, '💶': e1, '💷': e1, '💸': e1, '💹': e1, '💺': e1, '💻': e1, '💼': e1, '💽': e1, '💾': e1, '💿': e1, '📀': e1, '📁': e1, '📂': e1, '📃': e1, '📄': e1, '📅': e1, '📆': e1, '📇': e1, '📈': e1, '📉': e1, '📊': e1, '📋': e1, '📌': e1, '📍': e1, '📎': e1, '📏': e1, '📐': e1, '📑': e1, '📒': e1, '📓': e1, '📔': e1, '📕': e1, '📖': e1, '📗': e1, '📘': e1, '📙': e1, '📚': e1, '📛': e1, '📜': e1, '📝': e1, '📞': e1, '📟': e1, '📠': e1, '📡': e1, '📢': e1, '📣': e1, '📤': e1, '📥': e1, '📦': e1, '📧': e1, '📨': e1, '📩': e1, '📪': e1, '📫': e1, '📬': e1, '📭': e1, '📮': e1, '📯': e1, '📰': e1, '📱': e1, '📲': e1, '📳': e1, '📴': e1, '📵': e1, '📶': e1, '📷': e1, '📸': e1, '📹': e1, '📺': e1, '📻': e1, '📼': e1, '📽': e2, '📿': e1, '🔀': e1, '🔁': e1, '🔂': e1, '🔃': e1, '🔄': e1, '🔅': e1, '🔆': e1, '🔇': e1, '🔈': e1, '🔉': e1, '🔊': e1, '🔋': e1, '🔌': e1, '🔍': e1, '🔎': e1, '🔏': e1, '🔐': e1, '🔑': e1, '🔒': e1, '🔓': e1, '🔔': e1, '🔕': e1, '🔖': e1, '🔗': e1, '🔘': e1, '🔙': e1, '🔚': e1, '🔛': e1, '🔜': e1, '🔝': e1, '🔞': e1, '🔟': e1, '🔠': e1, '🔡': e1, '🔢': e1, '🔣': e1, '🔤': e1, '🔥': e1, '🔦': e1, '🔧': e1, '🔨': e1, '🔩': e1, '🔪': e1, '🔫': e1, '🔬': e1, '🔭': e1, '🔮': e1, '🔯': e1, '🔰': e1, '🔱': e1, '🔲': e1, '🔳': e1, '🔴': e1, '🔵': e1, '🔶': e1, '🔷': e1, '🔸': e1, '🔹': e1, '🔺': e1, '🔻': e1, '🔼': e1, '🔽': e1, '🕉': e2, '🕊': e2, '🕋': e1, '🕌': e1, '🕍': e1, '🕎': e1, '🕐': e1, '🕑': e1, '🕒': e1, '🕓': e1, '🕔': e1, '🕕': e1, '🕖': e1, '🕗': e1, '🕘': e1, '🕙': e1, '🕚': e1, '🕛': e1, '🕜': e1, '🕝': e1, '🕞': e1, '🕟': e1, '🕠': e1, '🕡': e1, '🕢': e1, '🕣': e1, '🕤': e1, '🕥': e1, '🕦': e1, '🕧': e1, '🕯': e2, '🕰': e2, '🕳': e2, '🕴': e21, '🕵': e187, '🕶': e2, '🕷': e2, '🕸': e2, '🕹': e2, '🕺': e20, '🖇': e2, '🖊': e2, '🖋': e2, '🖌': e2, '🖍': e2, '🖐': e21, '🖕': e20, '🖖': e20, '🖤': e1, '🖥': e2, '🖨': e2, '🖱': e2, '🖲': e2, '🖼': e2, '🗂': e2, '🗃': e2, '🗄': e2, '🗑': e2, '🗒': e2, '🗓': e2, '🗜': e2, '🗝': e2, '🗞': e2, '🗡': e2, '🗣': e2, '🗨': e2, '🗯': e2, '🗳': e2, '🗺': e2, '🗻': e1, '🗼': e1, '🗽': e1, '🗾': e1, '🗿': e1, '😀': e1, '😁': e1, '😂': e1, '😃': e1, '😄': e1, '😅': e1, '😆': e1, '😇': e1, '😈': e1, '😉': e1, '😊': e1, '😋': e1, '😌': e1, '😍': e1, '😎': e1, '😏': e1, '😐': e1, '😑': e1, '😒': e1, '😓': e1, '😔': e1, '😕': e1, '😖': e1, '😗': e1, '😘': e1, '😙': e1, '😚': e1, '😛': e1, '😜': e1, '😝': e1, '😞': e1, '😟': e1, '😠': e1, '😡': e1, '😢': e1, '😣': e1, '😤': e1, '😥': e1, '😦': e1, '😧': e1, '😨': e1, '😩': e1, '😪': e1, '😫': e1, '😬': e1, '😭': e1, '😮': e6, '😯': e1, '😰': e1, '😱': e1, '😲': e1, '😳': e1, '😴': e1, '😵': e8, '😶': e3, '😷': e1, '😸': e1, '😹': e1, '😺': e1, '😻': e1, '😼': e1, '😽': e1, '😾': e1, '😿': e1, '🙀': e1, '🙁': e1, '🙂': e1, '🙃': e1, '🙄': e1, '🙅': e101, '🙆': e101, '🙇': e101, '🙈': e1, '🙉': e1, '🙊': e1, '🙋': e101, '🙌': e20, '🙍': e101, '🙎': e101, '🙏': e20, '🚀': e1, '🚁': e1, '🚂': e1, '🚃': e1, '🚄': e1, '🚅': e1, '🚆': e1, '🚇': e1, '🚈': e1, '🚉': e1, '🚊': e1, '🚋': e1, '🚌': e1, '🚍': e1, '🚎': e1, '🚏': e1, '🚐': e1, '🚑': e1, '🚒': e1, '🚓': e1, '🚔': e1, '🚕': e1, '🚖': e1, '🚗': e1, '🚘': e1, '🚙': e1, '🚚': e1, '🚛': e1, '🚜': e1, '🚝': e1, '🚞': e1, '🚟': e1, '🚠': e1, '🚡': e1, '🚢': e1, '🚣': e101, '🚤': e1, '🚥': e1, '🚦': e1, '🚧': e1, '🚨': e1, '🚩': e1, '🚪': e1, '🚫': e1, '🚬': e1, '🚭': e1, '🚮': e1, '🚯': e1, '🚰': e1, '🚱': e1, '🚲': e1, '🚳': e1, '🚴': e101, '🚵': e101, '🚶': e101, '🚷': e1, '🚸': e1, '🚹': e1, '🚺': e1, '🚻': e1, '🚼': e1, '🚽': e1, '🚾': e1, '🚿': e1, '🛀': e20, '🛁': e1, '🛂': e1, '🛃': e1, '🛄': e1, '🛅': e1, '🛋': e2, '🛌': e20, '🛍': e2, '🛎': e2, '🛏': e2, '🛐': e1, '🛑': e1, '🛒': e1, '🛕': e1, '🛖': e1, '🛗': e1, '🛜': e1, '🛝': e1, '🛞': e1, '🛟': e1, '🛠': e2, '🛡': e2, '🛢': e2, '🛣': e2, '🛤': e2, '🛥': e2, '🛩': e2, '🛫': e1, '🛬': e1, '🛰': e2, '🛳': e2, '🛴': e1, '🛵': e1, '🛶': e1, '🛷': e1, '🛸': e1, '🛹': e1, '🛺': e1, '🛻': e1, '🛼': e1, '🟠': e1, '🟡': e1, '🟢': e1, '🟣': e1, '🟤': e1, '🟥': e1, '🟦': e1, '🟧': e1, '🟨': e1, '🟩': e1, '🟪': e1, '🟫': e1, '🟰': e1, '🤌': e20, '🤍': e1, '🤎': e1, '🤏': e20, '🤐': e1, '🤑': e1, '🤒': e1, '🤓': e1, '🤔': e1, '🤕': e1, '🤖': e1, '🤗': e1, '🤘': e20, '🤙': e20, '🤚': e20, '🤛': e20, '🤜': e20, '🤝': e20, '🤞': e20, '🤟': e20, '🤠': e1, '🤡': e1, '🤢': e1, '🤣': e1, '🤤': e1, '🤥': e1, '🤦': e101, '🤧': e1, '🤨': e1, '🤩': e1, '🤪': e1, '🤫': e1, '🤬': e1, '🤭': e1, '🤮': e1, '🤯': e1, '🤰': e20, '🤱': e20, '🤲': e20, '🤳': e20, '🤴': e20, '🤵': e101, '🤶': e20, '🤷': e101, '🤸': e101, '🤹': e101, '🤺': e1, '🤼': e102, '🤽': e101, '🤾': e101, '🤿': e1, '🥀': e1, '🥁': e1, '🥂': e1, '🥃': e1, '🥄': e1, '🥅': e1, '🥇': e1, '🥈': e1, '🥉': e1, '🥊': e1, '🥋': e1, '🥌': e1, '🥍': e1, '🥎': e1, '🥏': e1, '🥐': e1, '🥑': e1, '🥒': e1, '🥓': e1, '🥔': e1, '🥕': e1, '🥖': e1, '🥗': e1, '🥘': e1, '🥙': e1, '🥚': e1, '🥛': e1, '🥜': e1, '🥝': e1, '🥞': e1, '🥟': e1, '🥠': e1, '🥡': e1, '🥢': e1, '🥣': e1, '🥤': e1, '🥥': e1, '🥦': e1, '🥧': e1, '🥨': e1, '🥩': e1, '🥪': e1, '🥫': e1, '🥬': e1, '🥭': e1, '🥮': e1, '🥯': e1, '🥰': e1, '🥱': e1, '🥲': e1, '🥳': e1, '🥴': e1, '🥵': e1, '🥶': e1, '🥷': e20, '🥸': e1, '🥹': e1, '🥺': e1, '🥻': e1, '🥼': e1, '🥽': e1, '🥾': e1, '🥿': e1, '🦀': e1, '🦁': e1, '🦂': e1, '🦃': e1, '🦄': e1, '🦅': e1, '🦆': e1, '🦇': e1, '🦈': e1, '🦉': e1, '🦊': e1, '🦋': e1, '🦌': e1, '🦍': e1, '🦎': e1, '🦏': e1, '🦐': e1, '🦑': e1, '🦒': e1, '🦓': e1, '🦔': e1, '🦕': e1, '🦖': e1, '🦗': e1, '🦘': e1, '🦙': e1, '🦚': e1, '🦛': e1, '🦜': e1, '🦝': e1, '🦞': e1, '🦟': e1, '🦠': e1, '🦡': e1, '🦢': e1, '🦣': e1, '🦤': e1, '🦥': e1, '🦦': e1, '🦧': e1, '🦨': e1, '🦩': e1, '🦪': e1, '🦫': e1, '🦬': e1, '🦭': e1, '🦮': e1, '🦯': e1, '🦰': e189, '🦱': e189, '🦲': e189, '🦳': e189, '🦴': e1, '🦵': e20, '🦶': e20, '🦷': e1, '🦸': e101, '🦹': e101, '🦺': e1, '🦻': e20, '🦼': e1, '🦽': e1, '🦾': e1, '🦿': e1, '🧀': e1, '🧁': e1, '🧂': e1, '🧃': e1, '🧄': e1, '🧅': e1, '🧆': e1, '🧇': e1, '🧈': e1, '🧉': e1, '🧊': e1, '🧋': e1, '🧌': e1, '🧍': e101, '🧎': e101, '🧏': e101, '🧐': e1, '🧑': e38, '🧒': e20, '🧓': e20, '🧔': e101, '🧕': e20, '🧖': e101, '🧗': e101, '🧘': e101, '🧙': e101, '🧚': e101, '🧛': e101, '🧜': e101, '🧝': e101, '🧞': e102, '🧟': e102, '🧠': e1, '🧡': e1, '🧢': e1, '🧣': e1, '🧤': e1, '🧥': e1, '🧦': e1, '🧧': e1, '🧨': e1, '🧩': e1, '🧪': e1, '🧫': e1, '🧬': e1, '🧭': e1, '🧮': e1, '🧯': e1, '🧰': e1, '🧱': e1, '🧲': e1, '🧳': e1, '🧴': e1, '🧵': e1, '🧶': e1, '🧷': e1, '🧸': e1, '🧹': e1, '🧺': e1, '🧻': e1, '🧼': e1, '🧽': e1, '🧾': e1, '🧿': e1, '🩰': e1, '🩱': e1, '🩲': e1, '🩳': e1, '🩴': e1, '🩵': e1, '🩶': e1, '🩷': e1, '🩸': e1, '🩹': e1, '🩺': e1, '🩻': e1, '🩼': e1, '🪀': e1, '🪁': e1, '🪂': e1, '🪃': e1, '🪄': e1, '🪅': e1, '🪆': e1, '🪇': e1, '🪈': e1, '🪐': e1, '🪑': e1, '🪒': e1, '🪓': e1, '🪔': e1, '🪕': e1, '🪖': e1, '🪗': e1, '🪘': e1, '🪙': e1, '🪚': e1, '🪛': e1, '🪜': e1, '🪝': e1, '🪞': e1, '🪟': e1, '🪠': e1, '🪡': e1, '🪢': e1, '🪣': e1, '🪤': e1, '🪥': e1, '🪦': e1, '🪧': e1, '🪨': e1, '🪩': e1, '🪪': e1, '🪫': e1, '🪬': e1, '🪭': e1, '🪮': e1, '🪯': e1, '🪰': e1, '🪱': e1, '🪲': e1, '🪳': e1, '🪴': e1, '🪵': e1, '🪶': e1, '🪷': e1, '🪸': e1, '🪹': e1, '🪺': e1, '🪻': e1, '🪼': e1, '🪽': e1, '🪿': e1, '🫀': e1, '🫁': e1, '🫂': e1, '🫃': e20, '🫄': e20, '🫅': e20, '🫎': e1, '🫏': e1, '🫐': e1, '🫑': e1, '🫒': e1, '🫓': e1, '🫔': e1, '🫕': e1, '🫖': e1, '🫗': e1, '🫘': e1, '🫙': e1, '🫚': e1, '🫛': e1, '🫠': e1, '🫡': e1, '🫢': e1, '🫣': e1, '🫤': e1, '🫥': e1, '🫦': e1, '🫧': e1, '🫨': e1, '🫰': e20, '🫱': e22, '🫲': e20, '🫳': e20, '🫴': e20, '🫵': e20, '🫶': e20, '🫷': e20, '🫸': e20, }
