#pragma once

#include "cellRtc.h"
#include "Emu/Cell/ErrorCodes.h"

#include <set>

error_code sceNpInit(u32 poolsize, vm::ptr<void> poolptr);
error_code sceNpTerm();

using np_in_addr_t   = u32;
using np_in_port_t   = u16;
using np_sa_family_t = u8;
using np_socklen_t   = u32;

struct np_in_addr
{
	np_in_addr_t np_s_addr; // TODO: alignment?
};

using sys_memory_container_t = u32;

using system_time_t = u64; // s64 in documentation. But since this is in microseconds, it doesn't seem to make much sense.
using second_t = u32;
using usecond_t = u64;

using SceNpBasicAttachmentDataId = u32;
using SceNpBasicMessageId = u64;
using SceNpBasicMessageRecvAction = u32;

using SceNpClanId = u32;
using SceNpClansMessageId = u32;
using SceNpClansMemberStatus = s32;

using SceNpCustomMenuIndexMask = u32;
using SceNpCustomMenuSelectedType = u32;

using SceNpFriendlistCustomOptions = u64;

using SceNpPlatformType = s32;

using SceNpScoreBoardId = u32;
using SceNpScoreClansBoardId = u32;
using SceNpScorePcId = s32;
using SceNpScoreRankNumber = u32;
using SceNpScoreValue = s64;

using SceNpTime = s64;

// Error Codes
enum SceNpError : u32
{
	// NP Manager Utility
	SCE_NP_ERROR_NOT_INITIALIZED            = 0x8002aa01,
	SCE_NP_ERROR_ALREADY_INITIALIZED        = 0x8002aa02,
	SCE_NP_ERROR_INVALID_ARGUMENT           = 0x8002aa03,
	SCE_NP_ERROR_OUT_OF_MEMORY              = 0x8002aa04,
	SCE_NP_ERROR_ID_NO_SPACE                = 0x8002aa05,
	SCE_NP_ERROR_ID_NOT_FOUND               = 0x8002aa06,
	SCE_NP_ERROR_SESSION_RUNNING            = 0x8002aa07,
	SCE_NP_ERROR_LOGINID_ALREADY_EXISTS     = 0x8002aa08,
	SCE_NP_ERROR_INVALID_TICKET_SIZE        = 0x8002aa09,
	SCE_NP_ERROR_INVALID_STATE              = 0x8002aa0a,
	SCE_NP_ERROR_ABORTED                    = 0x8002aa0b,
	SCE_NP_ERROR_OFFLINE                    = 0x8002aa0c,
	SCE_NP_ERROR_VARIANT_ACCOUNT_ID         = 0x8002aa0d,
	SCE_NP_ERROR_GET_CLOCK                  = 0x8002aa0e,
	SCE_NP_ERROR_INSUFFICIENT_BUFFER        = 0x8002aa0f,
	SCE_NP_ERROR_EXPIRED_TICKET             = 0x8002aa10,
	SCE_NP_ERROR_TICKET_PARAM_NOT_FOUND     = 0x8002aa11,
	SCE_NP_ERROR_UNSUPPORTED_TICKET_VERSION = 0x8002aa12,
	SCE_NP_ERROR_TICKET_STATUS_CODE_INVALID = 0x8002aa13,
	SCE_NP_ERROR_INVALID_TICKET_VERSION     = 0x8002aa14,
	SCE_NP_ERROR_ALREADY_USED               = 0x8002aa15,
	SCE_NP_ERROR_DIFFERENT_USER             = 0x8002aa16,
	SCE_NP_ERROR_ALREADY_DONE               = 0x8002aa17,

	// NP Basic Utility
	SCE_NP_BASIC_ERROR_ALREADY_INITIALIZED      = 0x8002a661,
	SCE_NP_BASIC_ERROR_NOT_INITIALIZED          = 0x8002a662,
	SCE_NP_BASIC_ERROR_NOT_SUPPORTED            = 0x8002a663,
	SCE_NP_BASIC_ERROR_OUT_OF_MEMORY            = 0x8002a664,
	SCE_NP_BASIC_ERROR_INVALID_ARGUMENT         = 0x8002a665,
	SCE_NP_BASIC_ERROR_BAD_ID                   = 0x8002a666,
	SCE_NP_BASIC_ERROR_IDS_DIFFER               = 0x8002a667,
	SCE_NP_BASIC_ERROR_PARSER_FAILED            = 0x8002a668,
	SCE_NP_BASIC_ERROR_TIMEOUT                  = 0x8002a669,
	SCE_NP_BASIC_ERROR_NO_EVENT                 = 0x8002a66a,
	SCE_NP_BASIC_ERROR_EXCEEDS_MAX              = 0x8002a66b,
	SCE_NP_BASIC_ERROR_INSUFFICIENT             = 0x8002a66c,
	SCE_NP_BASIC_ERROR_NOT_REGISTERED           = 0x8002a66d,
	SCE_NP_BASIC_ERROR_DATA_LOST                = 0x8002a66e,
	SCE_NP_BASIC_ERROR_BUSY                     = 0x8002a66f,
	SCE_NP_BASIC_ERROR_STATUS                   = 0x8002a670,
	SCE_NP_BASIC_ERROR_CANCEL                   = 0x8002a671,
	SCE_NP_BASIC_ERROR_INVALID_MEMORY_CONTAINER = 0x8002a672,
	SCE_NP_BASIC_ERROR_INVALID_DATA_ID          = 0x8002a673,
	SCE_NP_BASIC_ERROR_BROKEN_DATA              = 0x8002a674,
	SCE_NP_BASIC_ERROR_BLOCKLIST_ADD_FAILED     = 0x8002a675,
	SCE_NP_BASIC_ERROR_BLOCKLIST_IS_FULL        = 0x8002a676,
	SCE_NP_BASIC_ERROR_SEND_FAILED              = 0x8002a677,
	SCE_NP_BASIC_ERROR_NOT_CONNECTED            = 0x8002a678,
	SCE_NP_BASIC_ERROR_INSUFFICIENT_DISK_SPACE  = 0x8002a679,
	SCE_NP_BASIC_ERROR_INTERNAL_FAILURE         = 0x8002a67a,
	SCE_NP_BASIC_ERROR_DOES_NOT_EXIST           = 0x8002a67b,
	SCE_NP_BASIC_ERROR_INVALID                  = 0x8002a67c,
	SCE_NP_BASIC_ERROR_UNKNOWN                  = 0x8002a6bf,
	SCE_NP_EXT_ERROR_CONTEXT_DOES_NOT_EXIST     = 0x8002a6a1,
	SCE_NP_EXT_ERROR_CONTEXT_ALREADY_EXISTS     = 0x8002a6a2,
	SCE_NP_EXT_ERROR_NO_CONTEXT                 = 0x8002a6a3,
	SCE_NP_EXT_ERROR_NO_ORIGIN                  = 0x8002a6a4,

	// NP Common Utility
	SCE_NP_UTIL_ERROR_INVALID_ARGUMENT      = 0x8002ab01,
	SCE_NP_UTIL_ERROR_OUT_OF_MEMORY         = 0x8002ab02,
	SCE_NP_UTIL_ERROR_INSUFFICIENT          = 0x8002ab03,
	SCE_NP_UTIL_ERROR_PARSER_FAILED         = 0x8002ab04,
	SCE_NP_UTIL_ERROR_INVALID_PROTOCOL_ID   = 0x8002ab05,
	SCE_NP_UTIL_ERROR_INVALID_NP_ID         = 0x8002ab06,
	SCE_NP_UTIL_ERROR_INVALID_NP_LOBBY_ID   = 0x8002ab07,
	SCE_NP_UTIL_ERROR_INVALID_NP_ROOM_ID    = 0x8002ab08,
	SCE_NP_UTIL_ERROR_INVALID_NP_ENV        = 0x8002ab09,
	SCE_NP_UTIL_ERROR_INVALID_TITLEID       = 0x8002ab0a,
	SCE_NP_UTIL_ERROR_INVALID_CHARACTER     = 0x8002ab0b,
	SCE_NP_UTIL_ERROR_INVALID_ESCAPE_STRING = 0x8002ab0c,
	SCE_NP_UTIL_ERROR_UNKNOWN_TYPE          = 0x8002ab0d,
	SCE_NP_UTIL_ERROR_UNKNOWN               = 0x8002ab0e,
	SCE_NP_UTIL_ERROR_NOT_MATCH             = 0x8002ab0f,
	SCE_NP_UTIL_ERROR_UNKNOWN_PLATFORM_TYPE = 0x8002ab10,

	// NP Friendlist Utility
	SCE_NP_FRIENDLIST_ERROR_ALREADY_INITIALIZED      = 0x8002ab20,
	SCE_NP_FRIENDLIST_ERROR_NOT_INITIALIZED          = 0x8002ab21,
	SCE_NP_FRIENDLIST_ERROR_OUT_OF_MEMORY            = 0x8002ab22,
	SCE_NP_FRIENDLIST_ERROR_INVALID_MEMORY_CONTAINER = 0x8002ab23,
	SCE_NP_FRIENDLIST_ERROR_INSUFFICIENT             = 0x8002ab24,
	SCE_NP_FRIENDLIST_ERROR_CANCEL                   = 0x8002ab25,
	SCE_NP_FRIENDLIST_ERROR_STATUS                   = 0x8002ab26,
	SCE_NP_FRIENDLIST_ERROR_BUSY                     = 0x8002ab27,
	SCE_NP_FRIENDLIST_ERROR_INVALID_ARGUMENT         = 0x8002ab28,

	// NP Profile Utility
	SCE_NP_PROFILE_ERROR_ALREADY_INITIALIZED = 0x8002ab40,
	SCE_NP_PROFILE_ERROR_NOT_INITIALIZED     = 0x8002ab41,
	SCE_NP_PROFILE_ERROR_OUT_OF_MEMORY       = 0x8002ab42,
	SCE_NP_PROFILE_ERROR_NOT_SUPPORTED       = 0x8002ab43,
	SCE_NP_PROFILE_ERROR_INSUFFICIENT        = 0x8002ab44,
	SCE_NP_PROFILE_ERROR_CANCEL              = 0x8002ab45,
	SCE_NP_PROFILE_ERROR_STATUS              = 0x8002ab46,
	SCE_NP_PROFILE_ERROR_BUSY                = 0x8002ab47,
	SCE_NP_PROFILE_ERROR_INVALID_ARGUMENT    = 0x8002ab48,
	SCE_NP_PROFILE_ERROR_ABORT               = 0x8002ab49,

	// NP Community Utility
	SCE_NP_COMMUNITY_ERROR_ALREADY_INITIALIZED          = 0x8002a101,
	SCE_NP_COMMUNITY_ERROR_NOT_INITIALIZED              = 0x8002a102,
	SCE_NP_COMMUNITY_ERROR_OUT_OF_MEMORY                = 0x8002a103,
	SCE_NP_COMMUNITY_ERROR_INVALID_ARGUMENT             = 0x8002a104,
	SCE_NP_COMMUNITY_ERROR_NO_TITLE_SET                 = 0x8002a105,
	SCE_NP_COMMUNITY_ERROR_NO_LOGIN                     = 0x8002a106,
	SCE_NP_COMMUNITY_ERROR_TOO_MANY_OBJECTS             = 0x8002a107,
	SCE_NP_COMMUNITY_ERROR_TRANSACTION_STILL_REFERENCED = 0x8002a108,
	SCE_NP_COMMUNITY_ERROR_ABORTED                      = 0x8002a109,
	SCE_NP_COMMUNITY_ERROR_NO_RESOURCE                  = 0x8002a10a,
	SCE_NP_COMMUNITY_ERROR_BAD_RESPONSE                 = 0x8002a10b,
	SCE_NP_COMMUNITY_ERROR_BODY_TOO_LARGE               = 0x8002a10c,
	SCE_NP_COMMUNITY_ERROR_HTTP_SERVER                  = 0x8002a10d,
	SCE_NP_COMMUNITY_ERROR_INVALID_SIGNATURE            = 0x8002a10e,
	SCE_NP_COMMUNITY_ERROR_TIMEOUT                      = 0x8002a10f,
	SCE_NP_COMMUNITY_ERROR_INSUFFICIENT_ARGUMENT        = 0x8002a1a1,
	SCE_NP_COMMUNITY_ERROR_UNKNOWN_TYPE                 = 0x8002a1a2,
	SCE_NP_COMMUNITY_ERROR_INVALID_ID                   = 0x8002a1a3,
	SCE_NP_COMMUNITY_ERROR_INVALID_ONLINE_ID            = 0x8002a1a4,
	SCE_NP_COMMUNITY_ERROR_INVALID_TICKET               = 0x8002a1a5,
	SCE_NP_COMMUNITY_ERROR_CLIENT_HANDLE_ALREADY_EXISTS = 0x8002a1a6,
	SCE_NP_COMMUNITY_ERROR_INSUFFICIENT_BUFFER          = 0x8002a1a7,
	SCE_NP_COMMUNITY_ERROR_INVALID_TYPE                 = 0x8002a1a8,
	SCE_NP_COMMUNITY_ERROR_TRANSACTION_ALREADY_END      = 0x8002a1a9,
	SCE_NP_COMMUNITY_ERROR_TRANSACTION_BEFORE_END       = 0x8002a1aa,
	SCE_NP_COMMUNITY_ERROR_BUSY_BY_ANOTEHR_TRANSACTION  = 0x8002a1ab,
	SCE_NP_COMMUNITY_ERROR_INVALID_ALIGNMENT            = 0x8002a1ac,
	SCE_NP_COMMUNITY_ERROR_TOO_MANY_NPID                = 0x8002a1ad,
	SCE_NP_COMMUNITY_ERROR_TOO_LARGE_RANGE              = 0x8002a1ae,
	SCE_NP_COMMUNITY_ERROR_INVALID_PARTITION            = 0x8002a1af,
	SCE_NP_COMMUNITY_ERROR_TOO_MANY_SLOTID              = 0x8002a1b1,

	// NP Community Server
	SCE_NP_COMMUNITY_SERVER_ERROR_BAD_REQUEST                         = 0x8002a401,
	SCE_NP_COMMUNITY_SERVER_ERROR_INVALID_TICKET                      = 0x8002a402,
	SCE_NP_COMMUNITY_SERVER_ERROR_INVALID_SIGNATURE                   = 0x8002a403,
	SCE_NP_COMMUNITY_SERVER_ERROR_EXPIRED_TICKET                      = 0x8002a404,
	SCE_NP_COMMUNITY_SERVER_ERROR_INVALID_NPID                        = 0x8002a405,
	SCE_NP_COMMUNITY_SERVER_ERROR_FORBIDDEN                           = 0x8002a406,
	SCE_NP_COMMUNITY_SERVER_ERROR_INTERNAL_SERVER_ERROR               = 0x8002a407,
	SCE_NP_COMMUNITY_SERVER_ERROR_VERSION_NOT_SUPPORTED               = 0x8002a408,
	SCE_NP_COMMUNITY_SERVER_ERROR_SERVICE_UNAVAILABLE                 = 0x8002a409,
	SCE_NP_COMMUNITY_SERVER_ERROR_PLAYER_BANNED                       = 0x8002a40a,
	SCE_NP_COMMUNITY_SERVER_ERROR_CENSORED                            = 0x8002a40b,
	SCE_NP_COMMUNITY_SERVER_ERROR_RANKING_RECORD_FORBIDDEN            = 0x8002a40c,
	SCE_NP_COMMUNITY_SERVER_ERROR_USER_PROFILE_NOT_FOUND              = 0x8002a40d,
	SCE_NP_COMMUNITY_SERVER_ERROR_UPLOADER_DATA_NOT_FOUND             = 0x8002a40e,
	SCE_NP_COMMUNITY_SERVER_ERROR_QUOTA_MASTER_NOT_FOUND              = 0x8002a40f,
	SCE_NP_COMMUNITY_SERVER_ERROR_RANKING_TITLE_NOT_FOUND             = 0x8002a410,
	SCE_NP_COMMUNITY_SERVER_ERROR_BLACKLISTED_USER_ID                 = 0x8002a411,
	SCE_NP_COMMUNITY_SERVER_ERROR_GAME_RANKING_NOT_FOUND              = 0x8002a412,
	SCE_NP_COMMUNITY_SERVER_ERROR_RANKING_STORE_NOT_FOUND             = 0x8002a414,
	SCE_NP_COMMUNITY_SERVER_ERROR_NOT_BEST_SCORE                      = 0x8002a415,
	SCE_NP_COMMUNITY_SERVER_ERROR_LATEST_UPDATE_NOT_FOUND             = 0x8002a416,
	SCE_NP_COMMUNITY_SERVER_ERROR_RANKING_BOARD_MASTER_NOT_FOUND      = 0x8002a417,
	SCE_NP_COMMUNITY_SERVER_ERROR_RANKING_GAME_DATA_MASTER_NOT_FOUND  = 0x8002a418,
	SCE_NP_COMMUNITY_SERVER_ERROR_INVALID_ANTICHEAT_DATA              = 0x8002a419,
	SCE_NP_COMMUNITY_SERVER_ERROR_TOO_LARGE_DATA                      = 0x8002a41a,
	SCE_NP_COMMUNITY_SERVER_ERROR_NO_SUCH_USER_NPID                   = 0x8002a41b,
	SCE_NP_COMMUNITY_SERVER_ERROR_INVALID_ENVIRONMENT                 = 0x8002a41d,
	SCE_NP_COMMUNITY_SERVER_ERROR_INVALID_ONLINE_NAME_CHARACTER       = 0x8002a41f,
	SCE_NP_COMMUNITY_SERVER_ERROR_INVALID_ONLINE_NAME_LENGTH          = 0x8002a420,
	SCE_NP_COMMUNITY_SERVER_ERROR_INVALID_ABOUT_ME_CHARACTER          = 0x8002a421,
	SCE_NP_COMMUNITY_SERVER_ERROR_INVALID_ABOUT_ME_LENGTH             = 0x8002a422,
	SCE_NP_COMMUNITY_SERVER_ERROR_INVALID_SCORE                       = 0x8002a423,
	SCE_NP_COMMUNITY_SERVER_ERROR_OVER_THE_RANKING_LIMIT              = 0x8002a424,
	SCE_NP_COMMUNITY_SERVER_ERROR_FAIL_TO_CREATE_SIGNATURE            = 0x8002a426,
	SCE_NP_COMMUNITY_SERVER_ERROR_RANKING_MASTER_INFO_NOT_FOUND       = 0x8002a427,
	SCE_NP_COMMUNITY_SERVER_ERROR_OVER_THE_GAME_DATA_LIMIT            = 0x8002a428,
	SCE_NP_COMMUNITY_SERVER_ERROR_SELF_DATA_NOT_FOUND                 = 0x8002a42a,
	SCE_NP_COMMUNITY_SERVER_ERROR_USER_NOT_ASSIGNED                   = 0x8002a42b,
	SCE_NP_COMMUNITY_SERVER_ERROR_GAME_DATA_ALREADY_EXISTS            = 0x8002a42c,
	SCE_NP_COMMUNITY_SERVER_ERROR_TOO_MANY_RESULTS                    = 0x8002a42d,
	SCE_NP_COMMUNITY_SERVER_ERROR_NOT_RECORDABLE_VERSION              = 0x8002a42e,
	SCE_NP_COMMUNITY_SERVER_ERROR_USER_STORAGE_TITLE_MASTER_NOT_FOUND = 0x8002a448,
	SCE_NP_COMMUNITY_SERVER_ERROR_INVALID_VIRTUAL_USER                = 0x8002a449,
	SCE_NP_COMMUNITY_SERVER_ERROR_USER_STORAGE_DATA_NOT_FOUND         = 0x8002a44a,
	SCE_NP_COMMUNITY_SERVER_ERROR_CONDITIONS_NOT_SATISFIED            = 0x8002a473,
	SCE_NP_COMMUNITY_SERVER_ERROR_MATCHING_BEFORE_SERVICE             = 0x8002a4a0,
	SCE_NP_COMMUNITY_SERVER_ERROR_MATCHING_END_OF_SERVICE             = 0x8002a4a1,
	SCE_NP_COMMUNITY_SERVER_ERROR_MATCHING_MAINTENANCE                = 0x8002a4a2,
	SCE_NP_COMMUNITY_SERVER_ERROR_RANKING_BEFORE_SERVICE              = 0x8002a4a3,
	SCE_NP_COMMUNITY_SERVER_ERROR_RANKING_END_OF_SERVICE              = 0x8002a4a4,
	SCE_NP_COMMUNITY_SERVER_ERROR_RANKING_MAINTENANCE                 = 0x8002a4a5,
	SCE_NP_COMMUNITY_SERVER_ERROR_NO_SUCH_TITLE                       = 0x8002a4a6,
	SCE_NP_COMMUNITY_SERVER_ERROR_TITLE_USER_STORAGE_BEFORE_SERVICE   = 0x8002a4aa,
	SCE_NP_COMMUNITY_SERVER_ERROR_TITLE_USER_STORAGE_END_OF_SERVICE   = 0x8002a4ab,
	SCE_NP_COMMUNITY_SERVER_ERROR_TITLE_USER_STORAGE_MAINTENANCE      = 0x8002a4ac,
	SCE_NP_COMMUNITY_SERVER_ERROR_UNSPECIFIED                         = 0x8002a4ff,

	// COMMERCE
	SCE_NP_COMMERCE_ERROR_NOT_INITIALIZED                   = 0x80029401,
	SCE_NP_COMMERCE_ERROR_ALREADY_INITIALIZED               = 0x80029402,
	SCE_NP_COMMERCE_ERROR_OUT_OF_MEMORY                     = 0x80029403,
	SCE_NP_COMMERCE_ERROR_UNSUPPORTED_VERSION               = 0x80029404,
	SCE_NP_COMMERCE_ERROR_CTX_MAX                           = 0x80029405,
	SCE_NP_COMMERCE_ERROR_CTX_NOT_FOUND                     = 0x80029406,
	SCE_NP_COMMERCE_ERROR_CTXID_NOT_AVAILABLE               = 0x80029407,
	SCE_NP_COMMERCE_ERROR_REQ_MAX                           = 0x80029408,
	SCE_NP_COMMERCE_ERROR_REQ_NOT_FOUND                     = 0x80029409,
	SCE_NP_COMMERCE_ERROR_REQID_NOT_AVAILABLE               = 0x8002940a,
	SCE_NP_COMMERCE_ERROR_INVALID_CATEGORY_ID               = 0x8002940b,
	SCE_NP_COMMERCE_ERROR_INVALID_LANG_CODE                 = 0x8002940c,
	SCE_NP_COMMERCE_ERROR_REQ_BUSY                          = 0x8002940d,
	SCE_NP_COMMERCE_ERROR_INSUFFICIENT_BUFFER               = 0x8002940e,
	SCE_NP_COMMERCE_ERROR_INVALID_REQ_STATE                 = 0x8002940f,
	SCE_NP_COMMERCE_ERROR_INVALID_CTX_STATE                 = 0x80029410,
	SCE_NP_COMMERCE_ERROR_UNKNOWN                           = 0x80029411,
	SCE_NP_COMMERCE_ERROR_INVALID_REQ_TYPE                  = 0x80029412,
	SCE_NP_COMMERCE_ERROR_INVALID_MEMORY_CONTAINER          = 0x80029413,
	SCE_NP_COMMERCE_ERROR_INSUFFICIENT_MEMORY_CONTAINER     = 0x80029414,
	SCE_NP_COMMERCE_ERROR_INVALID_DATA_FLAG_TYPE            = 0x80029415,
	SCE_NP_COMMERCE_ERROR_INVALID_DATA_FLAG_STATE           = 0x80029416,
	SCE_NP_COMMERCE_ERROR_DATA_FLAG_NUM_NOT_FOUND           = 0x80029417,
	SCE_NP_COMMERCE_ERROR_DATA_FLAG_INFO_NOT_FOUND          = 0x80029418,
	SCE_NP_COMMERCE_ERROR_INVALID_PROVIDER_ID               = 0x80029419,
	SCE_NP_COMMERCE_ERROR_INVALID_DATA_FLAG_NUM             = 0x8002941a,
	SCE_NP_COMMERCE_ERROR_INVALID_SKU_ID                    = 0x8002941b,
	SCE_NP_COMMERCE_ERROR_INVALID_DATA_FLAG_ID              = 0x8002941c,
	SCE_NP_COMMERCE_ERROR_GPC_SEND_REQUEST                  = 0x8002941d,
	SCE_NP_COMMERCE_ERROR_GDF_SEND_REQUEST                  = 0x8002941e,
	SCE_NP_COMMERCE_ERROR_SDF_SEND_REQUEST                  = 0x8002941f,

	SCE_NP_COMMERCE_ERROR_PARSE_PRODUCT_CATEGORY            = 0x80029421,
	SCE_NP_COMMERCE_ERROR_CURRENCY_INFO_NOT_FOUND           = 0x80029422,
	SCE_NP_COMMERCE_ERROR_CATEGORY_INFO_NOT_FOUND           = 0x80029423,
	SCE_NP_COMMERCE_ERROR_CHILD_CATEGORY_COUNT_NOT_FOUND    = 0x80029424,
	SCE_NP_COMMERCE_ERROR_CHILD_CATEGORY_INFO_NOT_FOUND     = 0x80029425,
	SCE_NP_COMMERCE_ERROR_SKU_COUNT_NOT_FOUND               = 0x80029426,
	SCE_NP_COMMERCE_ERROR_SKU_INFO_NOT_FOUND                = 0x80029427,
	SCE_NP_COMMERCE_ERROR_PLUGIN_LOAD_FAILURE               = 0x80029428,
	SCE_NP_COMMERCE_ERROR_INVALID_SKU_NUM                   = 0x80029429,
	SCE_NP_COMMERCE_ERROR_INVALID_GPC_PROTOCOL_VERSION      = 0x8002942a,

	SCE_NP_COMMERCE_ERROR_CHECKOUT_UNEXPECTED               = 0x80029430,
	SCE_NP_COMMERCE_ERROR_CHECKOUT_OUT_OF_SERVICE           = 0x80029431,
	SCE_NP_COMMERCE_ERROR_CHECKOUT_INVALID_SKU              = 0x80029432,
	SCE_NP_COMMERCE_ERROR_CHECKOUT_SERVER_BUSY              = 0x80029433,
	SCE_NP_COMMERCE_ERROR_CHECKOUT_MAINTENANCE              = 0x80029434,
	SCE_NP_COMMERCE_ERROR_CHECKOUT_ACCOUNT_SUSPENDED        = 0x80029435,
	SCE_NP_COMMERCE_ERROR_CHECKOUT_OVER_SPENDING_LIMIT      = 0x80029436,
	SCE_NP_COMMERCE_ERROR_CHECKOUT_NOT_ENOUGH_MONEY         = 0x80029437,
	SCE_NP_COMMERCE_ERROR_CHECKOUT_UNKNOWN                  = 0x80029438,

	SCE_NP_COMMERCE_BROWSE_SERVER_ERROR_UNKNOWN             = 0x80029600,
	SCE_NP_COMMERCE_BROWSE_SERVER_ERROR_INVALID_CREDENTIALS = 0x80029601,
	SCE_NP_COMMERCE_BROWSE_SERVER_ERROR_INVALID_CATEGORY_ID = 0x80029602,
	SCE_NP_COMMERCE_BROWSE_SERVER_ERROR_SERVICE_END         = 0x80029603,
	SCE_NP_COMMERCE_BROWSE_SERVER_ERROR_SERVICE_STOP        = 0x80029604,
	SCE_NP_COMMERCE_BROWSE_SERVER_ERROR_SERVICE_BUSY        = 0x80029605,
	SCE_NP_COMMERCE_BROWSE_SERVER_ERROR_UNSUPPORTED_VERSION = 0x80029606,
	SCE_NP_COMMERCE_BROWSE_SERVER_ERROR_INTERNAL_SERVER     = 0x80029680,

	SCE_NP_COMMERCE_GDF_SERVER_ERROR_UNKNOWN                = 0x80029d00,
	SCE_NP_COMMERCE_GDF_SERVER_ERROR_INVALID_CREDENTIALS    = 0x80029d01,
	SCE_NP_COMMERCE_GDF_SERVER_ERROR_INVALID_FLAGLIST       = 0x80029d02,
	SCE_NP_COMMERCE_GDF_SERVER_ERROR_SERVICE_END            = 0x80029d03,
	SCE_NP_COMMERCE_GDF_SERVER_ERROR_SERVICE_STOP           = 0x80029d04,
	SCE_NP_COMMERCE_GDF_SERVER_ERROR_SERVICE_BUSY           = 0x80029d05,
	SCE_NP_COMMERCE_GDF_SERVER_ERROR_UNSUPPORTED_VERSION    = 0x80029d06,

	SCE_NP_COMMERCE_SDF_SERVER_ERROR_UNKNOWN                = 0x80029e00,
	SCE_NP_COMMERCE_SDF_SERVER_ERROR_INVALID_CREDENTIALS    = 0x80029e01,
	SCE_NP_COMMERCE_SDF_SERVER_ERROR_INVALID_FLAGLIST       = 0x80029e02,
	SCE_NP_COMMERCE_SDF_SERVER_ERROR_SERVICE_END            = 0x80029e03,
	SCE_NP_COMMERCE_SDF_SERVER_ERROR_SERVICE_STOP           = 0x80029e04,
	SCE_NP_COMMERCE_SDF_SERVER_ERROR_SERVICE_BUSY           = 0x80029e05,
	SCE_NP_COMMERCE_SDF_SERVER_ERROR_UNSUPPORTED_VERSION    = 0x80029e06,

	// DRM
	SCE_NP_DRM_ERROR_OUT_OF_MEMORY        = 0x80029501,
	SCE_NP_DRM_ERROR_INVALID_PARAM        = 0x80029502,
	SCE_NP_DRM_ERROR_SERVER_RESPONSE      = 0x80029509,
	SCE_NP_DRM_ERROR_NO_ENTITLEMENT       = 0x80029513,
	SCE_NP_DRM_ERROR_BAD_ACT              = 0x80029514,
	SCE_NP_DRM_ERROR_BAD_FORMAT           = 0x80029515,
	SCE_NP_DRM_ERROR_NO_LOGIN             = 0x80029516,
	SCE_NP_DRM_ERROR_INTERNAL             = 0x80029517,
	SCE_NP_DRM_ERROR_BAD_PERM             = 0x80029519,
	SCE_NP_DRM_ERROR_UNKNOWN_VERSION      = 0x8002951a,
	SCE_NP_DRM_ERROR_TIME_LIMIT           = 0x8002951b,
	SCE_NP_DRM_ERROR_DIFFERENT_ACCOUNT_ID = 0x8002951c,
	SCE_NP_DRM_ERROR_DIFFERENT_DRM_TYPE   = 0x8002951d,
	SCE_NP_DRM_ERROR_SERVICE_NOT_STARTED  = 0x8002951e,
	SCE_NP_DRM_ERROR_BUSY                 = 0x80029520,
	SCE_NP_DRM_ERROR_LICENSE_NOT_FOUND    = 0x80029521,
	SCE_NP_DRM_ERROR_IO                   = 0x80029525,
	SCE_NP_DRM_ERROR_FORMAT               = 0x80029530,
	SCE_NP_DRM_ERROR_FILENAME             = 0x80029533,
	SCE_NP_DRM_ERROR_K_LICENSEE           = 0x80029534,

	// DRM Server
	SCE_NP_DRM_SERVER_ERROR_SERVICE_IS_END                 = 0x80029700,
	SCE_NP_DRM_SERVER_ERROR_SERVICE_STOP_TEMPORARILY       = 0x80029701,
	SCE_NP_DRM_SERVER_ERROR_SERVICE_IS_BUSY                = 0x80029702,
	SCE_NP_DRM_SERVER_ERROR_INVALID_USER_CREDENTIAL        = 0x80029721,
	SCE_NP_DRM_SERVER_ERROR_INVALID_PRODUCT_ID             = 0x80029722,
	SCE_NP_DRM_SERVER_ERROR_ACCOUNT_IS_CLOSED              = 0x80029730,
	SCE_NP_DRM_SERVER_ERROR_ACCOUNT_IS_SUSPENDED           = 0x80029731,
	SCE_NP_DRM_SERVER_ERROR_ACTIVATED_CONSOLE_IS_FULL      = 0x80029750,
	SCE_NP_DRM_SERVER_ERROR_CONSOLE_NOT_ACTIVATED          = 0x80029751,
	SCE_NP_DRM_SERVER_ERROR_PRIMARY_CONSOLE_CANNOT_CHANGED = 0x80029752,
	SCE_NP_DRM_SERVER_ERROR_UNKNOWN                        = 0x80029780,

	// DRM Install
	SCE_NP_DRM_INSTALL_ERROR_FORMAT      = 0x80029563,
	SCE_NP_DRM_INSTALL_ERROR_CHECK       = 0x80029564,
	SCE_NP_DRM_INSTALL_ERROR_UNSUPPORTED = 0x80029566,

	// Game purchase processing
	GAME_ERR_NOT_XMBBUY_CONTENT = 0x80028F81,

	// Auth
	SCE_NP_AUTH_EINVAL            = 0x8002a002,
	SCE_NP_AUTH_ENOMEM            = 0x8002a004,
	SCE_NP_AUTH_ESRCH             = 0x8002a005,
	SCE_NP_AUTH_EBUSY             = 0x8002a00a,
	SCE_NP_AUTH_EABORT            = 0x8002a00c,
	SCE_NP_AUTH_EEXIST            = 0x8002a014,
	SCE_NP_AUTH_EINVALID_ARGUMENT = 0x8002a015,

	// Auth extended
	SCE_NP_AUTH_ERROR_SERVICE_END             = 0x8002a200,
	SCE_NP_AUTH_ERROR_SERVICE_DOWN            = 0x8002a201,
	SCE_NP_AUTH_ERROR_SERVICE_BUSY            = 0x8002a202,
	SCE_NP_AUTH_ERROR_SERVER_MAINTENANCE      = 0x8002a203,
	SCE_NP_AUTH_ERROR_INVALID_DATA_LENGTH     = 0x8002a210,
	SCE_NP_AUTH_ERROR_INVALID_USER_AGENT      = 0x8002a211,
	SCE_NP_AUTH_ERROR_INVALID_VERSION         = 0x8002a212,
	SCE_NP_AUTH_ERROR_INVALID_SERVICE_ID      = 0x8002a220,
	SCE_NP_AUTH_ERROR_INVALID_CREDENTIAL      = 0x8002a221,
	SCE_NP_AUTH_ERROR_INVALID_ENTITLEMENT_ID  = 0x8002a222,
	SCE_NP_AUTH_ERROR_INVALID_CONSUMED_COUNT  = 0x8002a223,
	SCE_NP_AUTH_ERROR_INVALID_CONSOLE_ID      = 0x8002a224,
	SCE_NP_AUTH_ERROR_CONSOLE_ID_SUSPENDED    = 0x8002a227,
	SCE_NP_AUTH_ERROR_ACCOUNT_CLOSED          = 0x8002a230,
	SCE_NP_AUTH_ERROR_ACCOUNT_SUSPENDED       = 0x8002a231,
	SCE_NP_AUTH_ERROR_ACCOUNT_RENEW_EULA      = 0x8002a232,
	SCE_NP_AUTH_ERROR_ACCOUNT_RENEW_ACCOUNT1  = 0x8002a240,
	SCE_NP_AUTH_ERROR_ACCOUNT_RENEW_ACCOUNT2  = 0x8002a241,
	SCE_NP_AUTH_ERROR_ACCOUNT_RENEW_ACCOUNT3  = 0x8002a242,
	SCE_NP_AUTH_ERROR_ACCOUNT_RENEW_ACCOUNT4  = 0x8002a243,
	SCE_NP_AUTH_ERROR_ACCOUNT_RENEW_ACCOUNT5  = 0x8002a244,
	SCE_NP_AUTH_ERROR_ACCOUNT_RENEW_ACCOUNT6  = 0x8002a245,
	SCE_NP_AUTH_ERROR_ACCOUNT_RENEW_ACCOUNT7  = 0x8002a246,
	SCE_NP_AUTH_ERROR_ACCOUNT_RENEW_ACCOUNT8  = 0x8002a247,
	SCE_NP_AUTH_ERROR_ACCOUNT_RENEW_ACCOUNT9  = 0x8002a248,
	SCE_NP_AUTH_ERROR_ACCOUNT_RENEW_ACCOUNT10 = 0x8002a249,
	SCE_NP_AUTH_ERROR_ACCOUNT_RENEW_ACCOUNT11 = 0x8002a24a,
	SCE_NP_AUTH_ERROR_ACCOUNT_RENEW_ACCOUNT12 = 0x8002a24b,
	SCE_NP_AUTH_ERROR_ACCOUNT_RENEW_ACCOUNT13 = 0x8002a24c,
	SCE_NP_AUTH_ERROR_ACCOUNT_RENEW_ACCOUNT14 = 0x8002a24d,
	SCE_NP_AUTH_ERROR_ACCOUNT_RENEW_ACCOUNT15 = 0x8002a24e,
	SCE_NP_AUTH_ERROR_ACCOUNT_RENEW_ACCOUNT16 = 0x8002a24f,
	SCE_NP_AUTH_ERROR_UNKNOWN                 = 0x8002a280,

	// Core Utility
	SCE_NP_CORE_UTIL_ERROR_INVALID_ARGUMENT    = 0x8002a501,
	SCE_NP_CORE_UTIL_ERROR_OUT_OF_MEMORY       = 0x8002a502,
	SCE_NP_CORE_UTIL_ERROR_INSUFFICIENT        = 0x8002a503,
	SCE_NP_CORE_UTIL_ERROR_PARSER_FAILED       = 0x8002a504,
	SCE_NP_CORE_UTIL_ERROR_INVALID_PROTOCOL_ID = 0x8002a505,
	SCE_NP_CORE_UTIL_ERROR_INVALID_EXTENSION   = 0x8002a506,
	SCE_NP_CORE_UTIL_ERROR_INVALID_TEXT        = 0x8002a507,
	SCE_NP_CORE_UTIL_ERROR_UNKNOWN_TYPE        = 0x8002a508,
	SCE_NP_CORE_UTIL_ERROR_UNKNOWN             = 0x8002a509,

	// Core Parser
	SCE_NP_CORE_PARSER_ERROR_NOT_INITIALIZED     = 0x8002a511,
	SCE_NP_CORE_PARSER_ERROR_ALREADY_INITIALIZED = 0x8002a512,
	SCE_NP_CORE_PARSER_ERROR_OUT_OF_MEMORY       = 0x8002a513,
	SCE_NP_CORE_PARSER_ERROR_INSUFFICIENT        = 0x8002a514,
	SCE_NP_CORE_PARSER_ERROR_INVALID_FORMAT      = 0x8002a515,
	SCE_NP_CORE_PARSER_ERROR_INVALID_ARGUMENT    = 0x8002a516,
	SCE_NP_CORE_PARSER_ERROR_INVALID_HANDLE      = 0x8002a517,
	SCE_NP_CORE_PARSER_ERROR_INVALID_ICON        = 0x8002a518,
	SCE_NP_CORE_PARSER_ERROR_UNKNOWN             = 0x8002a519,

	// Core Errors
	SCE_NP_CORE_ERROR_ALREADY_INITIALIZED       = 0x8002a521,
	SCE_NP_CORE_ERROR_NOT_INITIALIZED           = 0x8002a522,
	SCE_NP_CORE_ERROR_INVALID_ARGUMENT          = 0x8002a523,
	SCE_NP_CORE_ERROR_OUT_OF_MEMORY             = 0x8002a524,
	SCE_NP_CORE_ERROR_ID_NOT_AVAILABLE          = 0x8002a525,
	SCE_NP_CORE_ERROR_USER_OFFLINE              = 0x8002a526,
	SCE_NP_CORE_ERROR_SESSION_RUNNING           = 0x8002a527,
	SCE_NP_CORE_ERROR_SESSION_NOT_ESTABLISHED   = 0x8002a528,
	SCE_NP_CORE_ERROR_SESSION_INVALID_STATE     = 0x8002a529,
	SCE_NP_CORE_ERROR_SESSION_ID_TOO_LONG       = 0x8002a52a,
	SCE_NP_CORE_ERROR_SESSION_INVALID_NAMESPACE = 0x8002a52b,
	SCE_NP_CORE_ERROR_CONNECTION_TIMEOUT        = 0x8002a52c,
	SCE_NP_CORE_ERROR_GETSOCKOPT                = 0x8002a52d,
	SCE_NP_CORE_ERROR_SSL_NOT_INITIALIZED       = 0x8002a52e,
	SCE_NP_CORE_ERROR_SSL_ALREADY_INITIALIZED   = 0x8002a52f,
	SCE_NP_CORE_ERROR_SSL_NO_CERT               = 0x8002a530,
	SCE_NP_CORE_ERROR_SSL_NO_TRUSTWORTHY_CA     = 0x8002a531,
	SCE_NP_CORE_ERROR_SSL_INVALID_CERT          = 0x8002a532,
	SCE_NP_CORE_ERROR_SSL_CERT_VERIFY           = 0x8002a533,
	SCE_NP_CORE_ERROR_SSL_CN_CHECK              = 0x8002a534,
	SCE_NP_CORE_ERROR_SSL_HANDSHAKE_FAILED      = 0x8002a535,
	SCE_NP_CORE_ERROR_SSL_SEND                  = 0x8002a536,
	SCE_NP_CORE_ERROR_SSL_RECV                  = 0x8002a537,
	SCE_NP_CORE_ERROR_SSL_CREATE_CTX            = 0x8002a538,
	SCE_NP_CORE_ERROR_PARSE_PEM                 = 0x8002a539,
	SCE_NP_CORE_ERROR_INVALID_INITIATE_STREAM   = 0x8002a53a,
	SCE_NP_CORE_ERROR_SASL_NOT_SUPPORTED        = 0x8002a53b,
	SCE_NP_CORE_ERROR_NAMESPACE_ALREADY_EXISTS  = 0x8002a53c,
	SCE_NP_CORE_ERROR_FROM_ALREADY_EXISTS       = 0x8002a53d,
	SCE_NP_CORE_ERROR_MODULE_NOT_REGISTERED     = 0x8002a53e,
	SCE_NP_CORE_ERROR_MODULE_FROM_NOT_FOUND     = 0x8002a53f,
	SCE_NP_CORE_ERROR_UNKNOWN_NAMESPACE         = 0x8002a540,
	SCE_NP_CORE_ERROR_INVALID_VERSION           = 0x8002a541,
	SCE_NP_CORE_ERROR_LOGIN_TIMEOUT             = 0x8002a542,
	SCE_NP_CORE_ERROR_TOO_MANY_SESSIONS         = 0x8002a543,
	SCE_NP_CORE_ERROR_SENDLIST_NOT_FOUND        = 0x8002a544,
	SCE_NP_CORE_ERROR_NO_ID                     = 0x8002a545,
	SCE_NP_CORE_ERROR_LOAD_CERTS                = 0x8002a546,
	SCE_NP_CORE_ERROR_NET_SELECT                = 0x8002a547,
	SCE_NP_CORE_ERROR_DISCONNECTED              = 0x8002a548,
	SCE_NP_CORE_ERROR_TICKET_TOO_SMALL          = 0x8002a549,
	SCE_NP_CORE_ERROR_INVALID_TICKET            = 0x8002a54a,
	SCE_NP_CORE_ERROR_INVALID_ONLINEID          = 0x8002a54b,
	SCE_NP_CORE_ERROR_GETHOSTBYNAME             = 0x8002a54c,
	SCE_NP_CORE_ERROR_UNDEFINED_STREAM_ERROR    = 0x8002a54d,
	SCE_NP_CORE_ERROR_INTERNAL                  = 0x8002a5ff,

	// Core DNS
	SCE_NP_CORE_ERROR_DNS_HOST_NOT_FOUND = 0x8002af01,
	SCE_NP_CORE_ERROR_DNS_TRY_AGAIN      = 0x8002af02,
	SCE_NP_CORE_ERROR_DNS_NO_RECOVERY    = 0x8002af03,
	SCE_NP_CORE_ERROR_DNS_NO_DATA        = 0x8002af04,
	SCE_NP_CORE_ERROR_DNS_NO_ADDRESS     = 0x8002afff,

	// Core Server
	SCE_NP_CORE_SERVER_ERROR_CONFLICT                   = 0x8002a303,
	SCE_NP_CORE_SERVER_ERROR_NOT_AUTHORIZED             = 0x8002a30d,
	SCE_NP_CORE_SERVER_ERROR_REMOTE_CONNECTION_FAILED   = 0x8002a30f,
	SCE_NP_CORE_SERVER_ERROR_RESOURCE_CONSTRAINT        = 0x8002a310,
	SCE_NP_CORE_SERVER_ERROR_SYSTEM_SHUTDOWN            = 0x8002a313,
	SCE_NP_CORE_SERVER_ERROR_UNSUPPORTED_CLIENT_VERSION = 0x8002a319,

	// Signaling
	SCE_NP_SIGNALING_ERROR_NOT_INITIALIZED       = 0x8002a801,
	SCE_NP_SIGNALING_ERROR_ALREADY_INITIALIZED   = 0x8002a802,
	SCE_NP_SIGNALING_ERROR_OUT_OF_MEMORY         = 0x8002a803,
	SCE_NP_SIGNALING_ERROR_CTXID_NOT_AVAILABLE   = 0x8002a804,
	SCE_NP_SIGNALING_ERROR_CTX_NOT_FOUND         = 0x8002a805,
	SCE_NP_SIGNALING_ERROR_REQID_NOT_AVAILABLE   = 0x8002a806,
	SCE_NP_SIGNALING_ERROR_REQ_NOT_FOUND         = 0x8002a807,
	SCE_NP_SIGNALING_ERROR_PARSER_CREATE_FAILED  = 0x8002a808,
	SCE_NP_SIGNALING_ERROR_PARSER_FAILED         = 0x8002a809,
	SCE_NP_SIGNALING_ERROR_INVALID_NAMESPACE     = 0x8002a80a,
	SCE_NP_SIGNALING_ERROR_NETINFO_NOT_AVAILABLE = 0x8002a80b,
	SCE_NP_SIGNALING_ERROR_PEER_NOT_RESPONDING   = 0x8002a80c,
	SCE_NP_SIGNALING_ERROR_CONNID_NOT_AVAILABLE  = 0x8002a80d,
	SCE_NP_SIGNALING_ERROR_CONN_NOT_FOUND        = 0x8002a80e,
	SCE_NP_SIGNALING_ERROR_PEER_UNREACHABLE      = 0x8002a80f,
	SCE_NP_SIGNALING_ERROR_TERMINATED_BY_PEER    = 0x8002a810,
	SCE_NP_SIGNALING_ERROR_TIMEOUT               = 0x8002a811,
	SCE_NP_SIGNALING_ERROR_CTX_MAX               = 0x8002a812,
	SCE_NP_SIGNALING_ERROR_RESULT_NOT_FOUND      = 0x8002a813,
	SCE_NP_SIGNALING_ERROR_CONN_IN_PROGRESS      = 0x8002a814,
	SCE_NP_SIGNALING_ERROR_INVALID_ARGUMENT      = 0x8002a815,
	SCE_NP_SIGNALING_ERROR_OWN_NP_ID             = 0x8002a816,
	SCE_NP_SIGNALING_ERROR_TOO_MANY_CONN         = 0x8002a817,
	SCE_NP_SIGNALING_ERROR_TERMINATED_BY_MYSELF  = 0x8002a818,

	// Custom Menu
	SCE_NP_CUSTOM_MENU_ERROR_ALREADY_INITIALIZED = 0x80023b01,
	SCE_NP_CUSTOM_MENU_ERROR_NOT_INITIALIZED     = 0x80023b02,
	SCE_NP_CUSTOM_MENU_ERROR_OUT_OF_MEMORY       = 0x80023b03,
	SCE_NP_CUSTOM_MENU_ERROR_NOT_SUPPORTED       = 0x80023b04,
	SCE_NP_CUSTOM_MENU_ERROR_INSUFFICIENT        = 0x80023b05,
	SCE_NP_CUSTOM_MENU_ERROR_CANCEL              = 0x80023b06,
	SCE_NP_CUSTOM_MENU_ERROR_STATUS              = 0x80023b07,
	SCE_NP_CUSTOM_MENU_ERROR_BUSY                = 0x80023b08,
	SCE_NP_CUSTOM_MENU_ERROR_INVALID_ARGUMENT    = 0x80023b09,
	SCE_NP_CUSTOM_MENU_ERROR_ABORT               = 0x80023b0a,
	SCE_NP_CUSTOM_MENU_ERROR_NOT_REGISTERED      = 0x80023b0b,
	SCE_NP_CUSTOM_MENU_ERROR_EXCEEDS_MAX         = 0x80023b0c,
	SCE_NP_CUSTOM_MENU_ERROR_INVALID_CHARACTER   = 0x80023b0d,

	// EULA
	SCE_NP_EULA_ERROR_UNKNOWN                   = 0x8002e500,
	SCE_NP_EULA_ERROR_INVALID_ARGUMENT          = 0x8002e501,
	SCE_NP_EULA_ERROR_NOT_INITIALIZED           = 0x8002e502,
	SCE_NP_EULA_ERROR_ALREADY_INITIALIZED       = 0x8002e503,
	SCE_NP_EULA_ERROR_OUT_OF_MEMORY             = 0x8002e504,
	SCE_NP_EULA_ERROR_BUSY                      = 0x8002e505,
	SCE_NP_EULA_ERROR_EULA_NOT_FOUND            = 0x8002e5a0,
	SCE_NP_EULA_ERROR_NET_OUT_OF_MEMORY         = 0x8002e5a1,
	SCE_NP_EULA_ERROR_CONF_FORMAT               = 0x8002e5b0,
	SCE_NP_EULA_ERROR_CONF_INVALID_FILENAME     = 0x8002e5b1,
	SCE_NP_EULA_ERROR_CONF_TOO_MANY_EULA_FILES  = 0x8002e5b2,
	SCE_NP_EULA_ERROR_CONF_INVALID_LANGUAGE     = 0x8002e5b3,
	SCE_NP_EULA_ERROR_CONF_INVALID_COUNTRY      = 0x8002e5b4,
	SCE_NP_EULA_ERROR_CONF_INVALID_NPCOMMID     = 0x8002e5b5,
	SCE_NP_EULA_ERROR_CONF_INVALID_EULA_VERSION = 0x8002e5b6,

	// Matching
	SCE_NP_MATCHING_ERROR_NOT_INITIALIZED                  = 0x8002a701,
	SCE_NP_MATCHING_ERROR_ALREADY_INITIALIZED              = 0x8002a702,
	SCE_NP_MATCHING_ERROR_INVALID_ARG                      = 0x8002a703,
	SCE_NP_MATCHING_ERROR_TERMINATED                       = 0x8002a704,
	SCE_NP_MATCHING_ERROR_TIMEOUT                          = 0x8002a705,
	SCE_NP_MATCHING_ERROR_OUT_OF_MEMORY                    = 0x8002a706,
	SCE_NP_MATCHING_ERROR_CTXID_NOT_AVAIL                  = 0x8002a707,
	SCE_NP_MATCHING_ERROR_CTX_ALREADY_EXIST                = 0x8002a708,
	SCE_NP_MATCHING_ERROR_CTX_NOT_FOUND                    = 0x8002a709,
	SCE_NP_MATCHING_ERROR_LOBBY_NOT_FOUND                  = 0x8002a70a,
	SCE_NP_MATCHING_ERROR_ROOM_NOT_FOUND                   = 0x8002a70b,
	SCE_NP_MATCHING_ERROR_MEMBER_NOT_FOUND                 = 0x8002a70c,
	SCE_NP_MATCHING_ERROR_TOO_BIG_VALUE                    = 0x8002a70d,
	SCE_NP_MATCHING_ERROR_IVALID_ATTR_TYPE                 = 0x8002a70e,
	SCE_NP_MATCHING_ERROR_INVALID_ATTR_ID                  = 0x8002a70f,
	SCE_NP_MATCHING_ERROR_ALREADY_REQUESTED                = 0x8002a710,
	SCE_NP_MATCHING_ERROR_LIMITTED_SEATING                 = 0x8002a711,
	SCE_NP_MATCHING_ERROR_LOCKED                           = 0x8002a712,
	SCE_NP_MATCHING_ERROR_CTX_STILL_RUNNING                = 0x8002a713,
	SCE_NP_MATCHING_ERROR_INSUFFICIENT_BUFFER              = 0x8002a714,
	SCE_NP_MATCHING_ERROR_REQUEST_NOT_ALLOWED              = 0x8002a715,
	SCE_NP_MATCHING_ERROR_CTX_MAX                          = 0x8002a716,
	SCE_NP_MATCHING_ERROR_INVALID_REQ_ID                   = 0x8002a717,
	SCE_NP_MATCHING_ERROR_RESULT_NOT_FOUND                 = 0x8002a718,
	SCE_NP_MATCHING_ERROR_BUSY                             = 0x8002a719,
	SCE_NP_MATCHING_ERROR_ALREADY_JOINED_ROOM              = 0x8002a71a,
	SCE_NP_MATCHING_ERROR_ROOM_MAX                         = 0x8002a71b,
	SCE_NP_MATCHING_ERROR_QUICK_MATCH_PLAYER_NOT_FOUND     = 0x8002a71c,
	SCE_NP_MATCHING_ERROR_COND_MAX                         = 0x8002a71d,
	SCE_NP_MATCHING_ERROR_INVALID_COND                     = 0x8002a71e,
	SCE_NP_MATCHING_ERROR_INVALID_ATTR                     = 0x8002a71f,
	SCE_NP_MATCHING_ERROR_COMP_OP_INEQUALITY_MAX           = 0x8002a720,
	SCE_NP_MATCHING_ERROR_RESULT_OVERFLOWED                = 0x8002a721,
	SCE_NP_MATCHING_ERROR_HTTPXML_TIMEOUT                  = 0x8002a722,
	SCE_NP_MATCHING_ERROR_CANCELED                         = 0x8002a723,
	SCE_NP_MATCHING_ERROR_SEARCH_JOIN_ROOM_NOT_FOUND       = 0x8002a724,
	SCE_NP_MATCHING_ERROR_INVALID_COMP_OP                  = 0x8002a725,
	SCE_NP_MATCHING_ERROR_INVALID_COMP_TYPE                = 0x8002a726,
	SCE_NP_MATCHING_ERROR_REQUEST_NOT_FOUND                = 0x8002a727,
	SCE_NP_MATCHING_ERROR_INTERNAL_ERROR                   = 0x8002a728,
	SCE_NP_MATCHING_ERROR_INVALID_PROTOCOL_ID              = 0x8002a729,
	SCE_NP_MATCHING_ERROR_ATTR_NOT_SPECIFIED               = 0x8002a72a,
	SCE_NP_MATCHING_ERROR_SYSUTIL_INVALID_RESULT           = 0x8002a72b,
	SCE_NP_MATCHING_ERROR_PLUGIN_LOAD_FAILURE              = 0x8002a72c,
	SCE_NP_MATCHING_ERROR_INVALID_ATTR_VALUE               = 0x8002a72d,
	SCE_NP_MATCHING_ERROR_DUPLICATE                        = 0x8002a72e,
	SCE_NP_MATCHING_ERROR_INVALID_MEMORY_CONTAINER         = 0x8002a72f,
	SCE_NP_MATCHING_ERROR_SHUTDOWN                         = 0x8002a730,
	SCE_NP_MATCHING_ERROR_SYSUTIL_SERVER_BUSY              = 0x8002a731,
	SCE_NP_MATCHING_ERROR_SEND_INVITATION_PARTIALLY_FAILED = 0x8002a732,
	SCE_NP_MATCHING_ERROR_UTILITY_UNAVAILABLE              = 0x8002a733,

	SCE_NP_MATCHING_SERVER_ERROR_OUT_OF_SERVICE            = 0x8002a740,
	SCE_NP_MATCHING_SERVER_ERROR_MAINTENANCE               = 0x8002a741,
	SCE_NP_MATCHING_SERVER_ERROR_SERVER_BUSY               = 0x8002a742,
	SCE_NP_MATCHING_SERVER_ERROR_ACCESS_FORBIDDEN          = 0x8002a743,
	SCE_NP_MATCHING_SERVER_ERROR_NO_SUCH_SERVER            = 0x8002a744,
	SCE_NP_MATCHING_SERVER_ERROR_NO_SUCH_LOBBY             = 0x8002a745,
	SCE_NP_MATCHING_SERVER_ERROR_NO_SUCH_ROOM              = 0x8002a746,
	SCE_NP_MATCHING_SERVER_ERROR_NO_SUCH_USER              = 0x8002a747,
	SCE_NP_MATCHING_SERVER_ERROR_NOT_ALLOWED               = 0x8002a748,
	SCE_NP_MATCHING_SERVER_ERROR_UNKNOWN                   = 0x8002a749,
	SCE_NP_MATCHING_SERVER_ERROR_BAD_REQUEST_STANZA        = 0x8002a74a,
	SCE_NP_MATCHING_SERVER_ERROR_REQUEST_FORBIDDEN         = 0x8002a74b,
	SCE_NP_MATCHING_SERVER_ERROR_INTERNAL_ERROR            = 0x8002a74c,
	SCE_NP_MATCHING_SERVER_ERROR_ROOM_OVER                 = 0x8002a74d,
	SCE_NP_MATCHING_SERVER_ERROR_ROOM_CLOSED               = 0x8002a74e,
};

enum
{
	SCE_NP_COMMERCE_CURRENCY_CODE_LEN = 4,
	SCE_NP_COMMERCE_CATEGORY_ID_LEN = 56,
	SCE_NP_COMMERCE_CATEGORY_NAME_LEN = 192,
	SCE_NP_COMMERCE_CATEGORY_DESCRIPTION_LEN = 384,
	SCE_NP_COMMERCE_CATEGORY_IMAGEURL_LEN = 128,
	SCE_NP_COMMERCE_PRODUCT_ID_LEN = 48,
	SCE_NP_COMMERCE_PRODUCT_NAME_LEN = 192,
	SCE_NP_COMMERCE_SKU_ID_LEN = 56,
	SCE_NP_COMMERCE_SKU_NAME_LEN = 64,
	SCE_NP_COMMERCE_SKU_DESCRIPTION_LEN = 384,
	SCE_NP_COMMERCE_SKU_IMAGEURL_LEN = 128,
	SCE_NP_COMMERCE_SKU_USER_DATA_LEN = 128,
};

enum
{
	SCE_NP_COMMERCE_EVENT_REQUEST_ERROR = 0x0001,
	SCE_NP_COMMERCE_EVENT_PRODUCT_CATEGORY_READY = 0x0011,
	SCE_NP_COMMERCE_EVENT_PRODUCT_CATEGORY_DONE = 0x0012,
	SCE_NP_COMMERCE_EVENT_PRODUCT_CATEGORY_ABORT = 0x0013,
	SCE_NP_COMMERCE_EVENT_DO_CHECKOUT_STARTED = 0x0021,
	SCE_NP_COMMERCE_EVENT_DO_CHECKOUT_SUCCESS = 0x0022,
	SCE_NP_COMMERCE_EVENT_DO_CHECKOUT_BACK = 0x0023,
	SCE_NP_COMMERCE_EVENT_DO_CHECKOUT_FINISHED = 0x0025,
};

enum
{
	SCE_NP_MATCHING_EVENT_ERROR = 0x0001,
	SCE_NP_MATCHING_EVENT_LEAVE_ROOM_DONE = 0x0002,
	SCE_NP_MATCHING_EVENT_RESERVED1 = 0x0003,
	SCE_NP_MATCHING_EVENT_RESERVED2 = 0x0004,
	SCE_NP_MATCHING_EVENT_ROOM_UPDATE_NEW_MEMBER = 0x0005,
	SCE_NP_MATCHING_EVENT_ROOM_UPDATE_MEMBER_LEAVE = 0x0006,
	SCE_NP_MATCHING_EVENT_ROOM_DISAPPEARED = 0x0007,
	SCE_NP_MATCHING_EVENT_RESERVED3 = 0x0008,
	SCE_NP_MATCHING_EVENT_GET_ROOM_INFO_DONE = 0x0009,
	SCE_NP_MATCHING_EVENT_SET_ROOM_INFO_DONE = 0x000a,
	SCE_NP_MATCHING_EVENT_GRANT_OWNER_DONE = 0x000b,
	SCE_NP_MATCHING_EVENT_ROOM_UPDATE_OWNER_CHANGE = 0x000c,
	SCE_NP_MATCHING_EVENT_KICK_MEMBER_DONE = 0x000d,
	SCE_NP_MATCHING_EVENT_ROOM_KICKED = 0x000e,
	SCE_NP_MATCHING_EVENT_GET_ROOM_SEARCH_FLAG_DONE = 0x000f,
	SCE_NP_MATCHING_EVENT_SET_ROOM_SEARCH_FLAG_DONE = 0x0010,
};

enum
{
	SCE_NP_MATCHING_ATTR_TYPE_BASIC_BIN = 1,
	SCE_NP_MATCHING_ATTR_TYPE_BASIC_NUM = 2,
	SCE_NP_MATCHING_ATTR_TYPE_GAME_BIN = 3,
	SCE_NP_MATCHING_ATTR_TYPE_GAME_NUM = 4,
};

enum
{
	SCE_NP_MATCHING_ATTR_ID_MIN                         = 1,
	SCE_NP_MATCHING_ATTR_ID_MAX                         = 16,
	SCE_NP_MATCHING_ATTR_ID_FOR_SEARCH_CONDITION_MAX    = 8,
	SCE_NP_MATCHING_ATTR_ID_FOR_GRLGLIMIT_SRCH_COND_MAX = 8,
	SCE_NP_MATCHING_ATTR_BIN_BIG_SIZE_ID_MAX            = 2,
	SCE_NP_MATCHING_ATTR_BIN_MAX_SIZE_SMALL             = 64,
	SCE_NP_MATCHING_ATTR_BIN_MAX_SIZE_BIG               = 256,
};

enum
{
	SCE_NP_MATCHING_ROOM_ATTR_ID_TOTAL_SLOT = 1,
	SCE_NP_MATCHING_ROOM_ATTR_ID_PRIVATE_SLOT = 2,
	SCE_NP_MATCHING_ROOM_ATTR_ID_CUR_TOTAL_NUM = 3,
	SCE_NP_MATCHING_ROOM_ATTR_ID_CUR_PUBLIC_NUM = 4,
	SCE_NP_MATCHING_ROOM_ATTR_ID_CUR_PRIVATE_NUM = 5,
	SCE_NP_MATCHING_ROOM_ATTR_ID_PRIVILEGE_TYPE = 6,
	SCE_NP_MATCHING_ROOM_ATTR_ID_ROOM_SEARCH_FLAG = 7,
	SCE_NP_MATCHING_ROOM_ATTR_ID_MAX = 8,
};

enum
{
	SCE_NP_MATCHING_ROOM_SLOT_TYPE_PUBLIC = 0,
	SCE_NP_MATCHING_ROOM_SLOT_TYPE_PRIVATE = 1,
};

enum
{
	SCE_NP_MATCHING_ROOM_PRIVILEGE_TYPE_NO_AUTO_GRANT = 0,
	SCE_NP_MATCHING_ROOM_PRIVILEGE_TYPE_AUTO_GRANT = 1,
};

enum
{
	SCE_NP_MATCHING_ROOM_SEARCH_FLAG_OPEN = 0,
	SCE_NP_MATCHING_ROOM_SEARCH_FLAG_STEALTH = 1,
};

enum
{
	SCE_NP_MATCHING_COND_MAX               = 9,
	SCE_NP_MATCHING_GRLG_LIMIT_COND_MAX    = 9,
	SCE_NP_MATCHING_COMP_OP_INEQUALITY_MAX = 9,
};

enum
{
	SCE_NP_MATCHING_CONDITION_SEARCH_EQ = 0,
	SCE_NP_MATCHING_CONDITION_SEARCH_NE = 1,
	SCE_NP_MATCHING_CONDITION_SEARCH_LT = 2,
	SCE_NP_MATCHING_CONDITION_SEARCH_LE = 3,
	SCE_NP_MATCHING_CONDITION_SEARCH_GT = 4,
	SCE_NP_MATCHING_CONDITION_SEARCH_GE = 5,
	SCE_NP_MATCHING_CONDITION_SEARCH_MAX = 6,
};

enum
{
	SCE_NP_MATCHING_CONDITION_TYPE_VALUE = 0,
};

enum
{
	SCE_NP_MATCHING_INVITATION_DESTINATION_MAX = 12,
	SCE_NP_MATCHING_INVITATION_SUBJECT_MAX_CHARS = 16,
	SCE_NP_MATCHING_INVITATION_BODY_MAX_CHARS = 128,

	SCE_NP_MATCHING_KICK_OPT_MAX_LENGTH = 16,

	SCE_NP_MATCHING_ROOM_MAX_SLOT = 16,
	SCE_NP_MATCHING_CTX_MAX = 8,
};

enum
{
	SCE_NP_MATCHING_SEND_INVITATION_MEMSIZE   = 16 * 1024 * 1024,
	SCE_NP_MATCHING_ACCEPT_INVITATION_MEMSIZE = 16 * 1024 * 1024,
};

// Basic presence options
enum
{
	SCE_NP_BASIC_PRESENCE_OPTIONS_SET_DATA    = 0x00000001,
	SCE_NP_BASIC_PRESENCE_OPTIONS_SET_STATUS  = 0x00000002,
	SCE_NP_BASIC_PRESENCE_OPTIONS_ALL_OPTIONS = 0x00000003, // sum of all other options
};

// Basic presence states
enum
{
	SCE_NP_BASIC_PRESENCE_STATE_OFFLINE        = 0,
	SCE_NP_BASIC_PRESENCE_STATE_OUT_OF_CONTEXT = 1,
	SCE_NP_BASIC_PRESENCE_STATE_IN_CONTEXT     = 2
};

// Basic player options
enum
{
	SCE_NP_BASIC_PLAYERS_HISTORY_OPTIONS_BY_NP_COMM_ID = 0,
	SCE_NP_BASIC_PLAYERS_HISTORY_OPTIONS_ALL           = 1
};

// Custom menu selection types
enum : SceNpCustomMenuSelectedType
{
	SCE_NP_CUSTOM_MENU_SELECTED_TYPE_ME     = 1,
	SCE_NP_CUSTOM_MENU_SELECTED_TYPE_FRIEND = 2,
	SCE_NP_CUSTOM_MENU_SELECTED_TYPE_PLAYER = 3,
};

// Custom menu action masks
enum SceNpCustomMenuActionMask : u32
{
	SCE_NP_CUSTOM_MENU_ACTION_MASK_ME     = 0x00000001,
	SCE_NP_CUSTOM_MENU_ACTION_MASK_FRIEND = 0x00000002,
	SCE_NP_CUSTOM_MENU_ACTION_MASK_PLAYER = 0x00000004,
	SCE_NP_CUSTOM_MENU_ACTION_MASK_ALL    = 0x00000007 // sum of all other masks
};

// Custom menu index mask
enum
{
	SCE_NP_CUSTOM_MENU_INDEX_BITS       = (sizeof(SceNpCustomMenuIndexMask) * 8),
	SCE_NP_CUSTOM_MENU_INDEX_BITS_ALL   = (static_cast<SceNpCustomMenuIndexMask>(-1)),
	SCE_NP_CUSTOM_MENU_INDEX_BITS_SHIFT = 5,
	SCE_NP_CUSTOM_MENU_INDEX_BITS_MASK  = (SCE_NP_CUSTOM_MENU_INDEX_BITS - 1),
	SCE_NP_CUSTOM_MENU_INDEX_BITS_MAX   = 127,
	SCE_NP_CUSTOM_MENU_INDEX_SETSIZE    = 128,
};

#define SCE_NP_CUSTOM_MENU_INDEX_SET(n, p) ((p)->index_bits[(n) >> SCE_NP_CUSTOM_MENU_INDEX_BITS_SHIFT] |= (1 << ((n) & SCE_NP_CUSTOM_MENU_INDEX_BITS_MASK)))
#define SCE_NP_CUSTOM_MENU_INDEX_CLR(n, p) ((p)->index_bits[(n) >> SCE_NP_CUSTOM_MENU_INDEX_BITS_SHIFT] &= ~(1 << ((n) & SCE_NP_CUSTOM_MENU_INDEX_BITS_MASK)))
#define SCE_NP_CUSTOM_MENU_INDEX_ISSET(n, p) ((p)->index_bits[(n) >> SCE_NP_CUSTOM_MENU_INDEX_BITS_SHIFT] & (1 << ((n) & SCE_NP_CUSTOM_MENU_INDEX_BITS_MASK)))
#define SCE_NP_CUSTOM_MENU_INDEX_ZERO(p) ( for (u32 i = 0; i < (SCE_NP_CUSTOM_MENU_INDEX_SETSIZE >> SCE_NP_CUSTOM_MENU_INDEX_BITS_SHIFT); i++) p->index_bits[i] = 0; )
#define SCE_NP_CUSTOM_MENU_INDEX_SET_ALL(p) ( for (u32 i = 0; i < (SCE_NP_CUSTOM_MENU_INDEX_SETSIZE >> SCE_NP_CUSTOM_MENU_INDEX_BITS_SHIFT); i++) p->index_bits[i] = SCE_NP_CUSTOM_MENU_INDEX_BITS_ALL; )

enum
{
	SCE_NP_PORT          = 3658,
	SCE_NP_MIN_POOL_SIZE = 128 * 1024
};

enum
{
	SCE_NP_DRM_OPEN_FLAG = 2,
};

enum : u64
{
	SCE_NP_DRM_EXITSPAWN2_EXIT_WO_FINI = 0x4000000000000000ULL,
	SCE_NP_DRM_TIME_INFO_ENDLESS       = 0x7FFFFFFFFFFFFFFFULL
};

enum
{
	SCE_NP_MANAGER_SUB_SIGNIN_MAX = 3,
};

enum
{
	SCE_NP_MANAGER_SUB_SIGNIN_RESULT_OK     = 0,
	SCE_NP_MANAGER_SUB_SIGNIN_RESULT_CANCEL = 1,
};

// NP Manager Utility statuses
enum
{
	SCE_NP_MANAGER_STATUS_OFFLINE         = -1,
	SCE_NP_MANAGER_STATUS_GETTING_TICKET  = 0,
	SCE_NP_MANAGER_STATUS_GETTING_PROFILE = 1,
	SCE_NP_MANAGER_STATUS_LOGGING_IN      = 2,
	SCE_NP_MANAGER_STATUS_ONLINE          = 3,
};

enum
{
	SCE_NP_MANAGER_EVENT_GOT_TICKET = 255
};

// Event types
enum
{
	SCE_NP_BASIC_EVENT_UNKNOWN                               = -1,
	SCE_NP_BASIC_EVENT_OFFLINE                               = 0,
	SCE_NP_BASIC_EVENT_PRESENCE                              = 1,
	SCE_NP_BASIC_EVENT_MESSAGE                               = 2,
	SCE_NP_BASIC_EVENT_ADD_FRIEND_RESULT                     = 3,
	SCE_NP_BASIC_EVENT_INCOMING_ATTACHMENT                   = 4,
	SCE_NP_BASIC_EVENT_INCOMING_INVITATION                   = 5,
	SCE_NP_BASIC_EVENT_END_OF_INITIAL_PRESENCE               = 6,
	SCE_NP_BASIC_EVENT_SEND_ATTACHMENT_RESULT                = 7,
	SCE_NP_BASIC_EVENT_RECV_ATTACHMENT_RESULT                = 8,
	SCE_NP_BASIC_EVENT_OUT_OF_CONTEXT                        = 9,
	SCE_NP_BASIC_EVENT_FRIEND_REMOVED                        = 10,
	SCE_NP_BASIC_EVENT_ADD_BLOCKLIST_RESULT                  = 11,
	SCE_NP_BASIC_EVENT_SEND_MESSAGE_RESULT                   = 12,
	SCE_NP_BASIC_EVENT_SEND_INVITATION_RESULT                = 13,
	SCE_NP_BASIC_EVENT_RECV_INVITATION_RESULT                = 14,
	SCE_NP_BASIC_EVENT_MESSAGE_MARKED_AS_USED_RESULT         = 15,
	SCE_NP_BASIC_EVENT_INCOMING_CUSTOM_INVITATION            = 16,
	SCE_NP_BASIC_EVENT_INCOMING_CLAN_MESSAGE                 = 17,
	SCE_NP_BASIC_EVENT_ADD_PLAYERS_HISTORY_RESULT            = 18,
	SCE_NP_BASIC_EVENT_SEND_CUSTOM_DATA_RESULT               = 19,
	SCE_NP_BASIC_EVENT_RECV_CUSTOM_DATA_RESULT               = 20,
	SCE_NP_BASIC_EVENT_INCOMING_CUSTOM_DATA_MESSAGE          = 21,
	SCE_NP_BASIC_EVENT_SEND_URL_ATTACHMENT_RESULT            = 22,
	SCE_NP_BASIC_EVENT_INCOMING_BOOTABLE_INVITATION          = 23,
	SCE_NP_BASIC_EVENT_BLOCKLIST_UPDATE                      = 24,
	SCE_NP_BASIC_EVENT_INCOMING_BOOTABLE_CUSTOM_DATA_MESSAGE = 25,
};

// IDs for attachment data objects
enum : SceNpBasicAttachmentDataId
{
	SCE_NP_BASIC_INVALID_ATTACHMENT_DATA_ID = 0,
	SCE_NP_BASIC_INVALID_MESSAGE_ID         = 0,
	SCE_NP_BASIC_SELECTED_INVITATION_DATA   = 1,
	SCE_NP_BASIC_SELECTED_MESSAGE_DATA      = 2,
};

// Actions made in system GUI
enum
{
	SCE_NP_BASIC_MESSAGE_ACTION_UNKNOWN = 0,
	SCE_NP_BASIC_MESSAGE_ACTION_USE     = 1,
	SCE_NP_BASIC_MESSAGE_ACTION_ACCEPT  = 2,
	SCE_NP_BASIC_MESSAGE_ACTION_DENY    = 3,
};

// Main types of messages
enum SceNpBasicMessageMainType : u16
{
	SCE_NP_BASIC_MESSAGE_MAIN_TYPE_DATA_ATTACHMENT = 0,
	SCE_NP_BASIC_MESSAGE_MAIN_TYPE_GENERAL         = 1,
	SCE_NP_BASIC_MESSAGE_MAIN_TYPE_ADD_FRIEND      = 2,
	SCE_NP_BASIC_MESSAGE_MAIN_TYPE_INVITE          = 3,
	SCE_NP_BASIC_MESSAGE_MAIN_TYPE_CUSTOM_DATA     = 4,
	SCE_NP_BASIC_MESSAGE_MAIN_TYPE_URL_ATTACHMENT  = 5,
};

// Sub types of messages
enum SceNpBasicMessageSubType : u16
{
	SCE_NP_BASIC_MESSAGE_DATA_ATTACHMENT_SUBTYPE_ACTION_USE = 0,
	SCE_NP_BASIC_MESSAGE_GENERAL_SUBTYPE_NONE               = 0,
	SCE_NP_BASIC_MESSAGE_ADD_FRIEND_SUBTYPE_NONE            = 0,
	SCE_NP_BASIC_MESSAGE_INVITE_SUBTYPE_ACTION_ACCEPT_DENY  = 0,
	SCE_NP_BASIC_MESSAGE_CUSTOM_DATA_SUBTYPE_ACTION_USE     = 0,
	SCE_NP_BASIC_MESSAGE_URL_ATTACHMENT_SUBTYPE_ACTION_USE  = 0,
	SCE_NP_BASIC_MESSAGE_INVITE_SUBTYPE_ACTION_ACCEPT       = 1,
};

// Applicable features of messages
#define SCE_NP_BASIC_MESSAGE_FEATURES_EXP_MIN(min) (((static_cast<u32>(min) << 16) | (0 << 15)) & 0xFFFF8000)
enum SceNpBasicMessageFeatures : u32
{
	SCE_NP_BASIC_MESSAGE_FEATURES_MULTI_RECEIPIENTS = 0x00000001,
	SCE_NP_BASIC_MESSAGE_FEATURES_BOOTABLE          = 0x00000002,
	SCE_NP_BASIC_MESSAGE_FEATURES_ASSUME_SEND       = 0x00000004,
	SCE_NP_BASIC_MESSAGE_FEATURES_ALL_FEATURES      =
		SCE_NP_BASIC_MESSAGE_FEATURES_MULTI_RECEIPIENTS |
		SCE_NP_BASIC_MESSAGE_FEATURES_BOOTABLE |
		SCE_NP_BASIC_MESSAGE_FEATURES_ASSUME_SEND |
		SCE_NP_BASIC_MESSAGE_FEATURES_EXP_MIN(0xffff)
};

// Types of messages
enum SceNpBasicMessageInfoType : u32
{
	SCE_NP_BASIC_MESSAGE_INFO_TYPE_MESSAGE_ATTACHMENT           = 0,
	SCE_NP_BASIC_MESSAGE_INFO_TYPE_MATCHING_INVITATION          = 1,
	SCE_NP_BASIC_MESSAGE_INFO_TYPE_CLAN_MESSAGE                 = 3,
	SCE_NP_BASIC_MESSAGE_INFO_TYPE_CUSTOM_DATA_MESSAGE          = 4,
	SCE_NP_BASIC_MESSAGE_INFO_TYPE_ANY_UNREAD_MESSAGE           = 5,
	SCE_NP_BASIC_MESSAGE_INFO_TYPE_BOOTABLE_INVITATION          = 6,
	SCE_NP_BASIC_MESSAGE_INFO_TYPE_BOOTABLE_CUSTOM_DATA_MESSAGE = 7,
};

// Context options (signaling)
enum
{
	SCE_NP_SIGNALING_CTX_OPT_BANDWIDTH_PROBE_DISABLE = 0,
	SCE_NP_SIGNALING_CTX_OPT_BANDWIDTH_PROBE_ENABLE  = 1,
	SCE_NP_SIGNALING_CTX_OPT_BANDWIDTH_PROBE         = 1,
};

// Event types (including extended ones)
enum
{
	SCE_NP_SIGNALING_EVENT_DEAD                 = 0,
	SCE_NP_SIGNALING_EVENT_ESTABLISHED          = 1,
	SCE_NP_SIGNALING_EVENT_NETINFO_ERROR        = 2,
	SCE_NP_SIGNALING_EVENT_NETINFO_RESULT       = 3,
	SCE_NP_SIGNALING_EVENT_EXT_PEER_ACTIVATED   = 10,
	SCE_NP_SIGNALING_EVENT_EXT_PEER_DEACTIVATED = 11,
	SCE_NP_SIGNALING_EVENT_EXT_MUTUAL_ACTIVATED = 12,
};

// Connection states
enum
{
	SCE_NP_SIGNALING_CONN_STATUS_INACTIVE = 0,
	SCE_NP_SIGNALING_CONN_STATUS_PENDING  = 1,
	SCE_NP_SIGNALING_CONN_STATUS_ACTIVE   = 2,
};

// Connection information to obtain
enum
{
	SCE_NP_SIGNALING_CONN_INFO_RTT            = 1,
	SCE_NP_SIGNALING_CONN_INFO_BANDWIDTH      = 2,
	SCE_NP_SIGNALING_CONN_INFO_PEER_NPID      = 3,
	SCE_NP_SIGNALING_CONN_INFO_PEER_ADDRESS   = 4,
	SCE_NP_SIGNALING_CONN_INFO_MAPPED_ADDRESS = 5,
	SCE_NP_SIGNALING_CONN_INFO_PACKET_LOSS    = 6,
};

// NAT status type
enum
{
	SCE_NP_SIGNALING_NETINFO_NAT_STATUS_UNKNOWN = 0,
	SCE_NP_SIGNALING_NETINFO_NAT_STATUS_TYPE1   = 1,
	SCE_NP_SIGNALING_NETINFO_NAT_STATUS_TYPE2   = 2,
	SCE_NP_SIGNALING_NETINFO_NAT_STATUS_TYPE3   = 3,
};

// UPnP status
enum
{
	SCE_NP_SIGNALING_NETINFO_UPNP_STATUS_UNKNOWN = 0,
	SCE_NP_SIGNALING_NETINFO_UPNP_STATUS_INVALID = 1,
	SCE_NP_SIGNALING_NETINFO_UPNP_STATUS_VALID   = 2,
};

// NP port status
enum
{
	SCE_NP_SIGNALING_NETINFO_NPPORT_STATUS_CLOSED = 0,
	SCE_NP_SIGNALING_NETINFO_NPPORT_STATUS_OPEN   = 1,
};

// NP Receive message options
enum SceNpBasicMessageRecvOptions : u32
{
	SCE_NP_BASIC_RECV_MESSAGE_OPTIONS_PRESERVE         = 0x00000001,
	SCE_NP_BASIC_RECV_MESSAGE_OPTIONS_INCLUDE_BOOTABLE = 0x00000002,
	SCE_NP_BASIC_RECV_MESSAGE_OPTIONS_ASSUME_LATEST    = 0x00000004,
	SCE_NP_BASIC_RECV_MESSAGE_OPTIONS_ALL_OPTIONS      = 0x00000007 // sum of all other options
};

// Constants for common NP functions and structures
enum
{
	SCE_NET_NP_AVATAR_IMAGE_MAX_SIZE         = 204800, // 200 * 1024
	SCE_NET_NP_AVATAR_IMAGE_MAX_SIZE_LARGE   = 204800, // 200 * 1024
	SCE_NET_NP_AVATAR_IMAGE_MAX_SIZE_MIDDLE  = 102400, // 100 * 1024
	SCE_NET_NP_AVATAR_IMAGE_MAX_SIZE_SMALL   = 10240,  //  10 * 1024
	SCE_NET_NP_AVATAR_URL_MAX_LENGTH         = 127,
	SCE_NET_NP_ONLINEID_MIN_LENGTH           = 3,
	SCE_NET_NP_ONLINEID_MAX_LENGTH           = 16,
	SCE_NET_NP_ONLINENAME_MAX_LENGTH         = 48,
	SCE_NET_NP_ABOUT_ME_MAX_LENGTH           = 63,
	SCE_NP_TSS_MAX_SIZE                      = 65536,   // 64 * 1024
	SCE_NET_NP_TSS_MAX_SIZE                  = SCE_NP_TSS_MAX_SIZE,
	SCE_NP_TSS_EXTRA_SLOT_MAX_SIZE           = 4194304, // 4 * 1024 * 1024
	SCE_NP_FRIEND_MAX_NUM                    = 100,
	SCE_NET_NP_COMMUNICATION_PASSPHRASE_SIZE = 128,
	SCE_NP_COMMUNICATION_SIGNATURE_SIZE      = 160,
	SCE_NP_COMMUNICATION_PASSPHRASE_SIZE     = SCE_NET_NP_COMMUNICATION_PASSPHRASE_SIZE,
	SCE_NET_NP_PSHANDLE_MIN_LENGTH           = SCE_NET_NP_ONLINEID_MIN_LENGTH,
	SCE_NET_NP_PSHANDLE_MAX_LENGTH           = SCE_NET_NP_ONLINEID_MAX_LENGTH,
	SCE_NET_NP_SUBHANDLE_MAX_LENGTH          = SCE_NET_NP_ONLINENAME_MAX_LENGTH,
	SCE_NET_NP_ICON_URL_MAX_LENGTH           = SCE_NET_NP_AVATAR_URL_MAX_LENGTH,
	SCE_NP_UTIL_NPID_VERSION                 = 1,
	SCE_NP_UTIL_NPLOBBYID_VERSION            = 1,
	SCE_NP_UTIL_NPROOMID_VERSION             = 1,
	SCE_NP_COMMERCE_VERSION                  = 1,
};

// Languages
enum
{
	SCE_NP_LANG_JAPANESE      = 0,
	SCE_NP_LANG_ENGLISH       = 1,
	SCE_NP_LANG_ENGLISH_US    = 1,
	SCE_NP_LANG_FRENCH        = 2,
	SCE_NP_LANG_SPANISH       = 3,
	SCE_NP_LANG_GERMAN        = 4,
	SCE_NP_LANG_ITALIAN       = 5,
	SCE_NP_LANG_DUTCH         = 6,
	SCE_NP_LANG_PORTUGUESE    = 7,
	SCE_NP_LANG_PORTUGUESE_PT = 7,
	SCE_NP_LANG_RUSSIAN       = 8,
	SCE_NP_LANG_KOREAN        = 9,
	SCE_NP_LANG_CHINESE_T     = 10,
	SCE_NP_LANG_CHINESE_S     = 11,
	SCE_NP_LANG_FINNISH       = 12,
	SCE_NP_LANG_SWEDISH       = 13,
	SCE_NP_LANG_DANISH        = 14,
	SCE_NP_LANG_NORWEGIAN     = 15,
	SCE_NP_LANG_POLISH        = 16,
	SCE_NP_LANG_PORTUGUESE_BR = 17,
	SCE_NP_LANG_ENGLISH_GB    = 18,
	SCE_NP_LANG_TURKISH       = 19,
	SCE_NP_LANG_SPANISH_LA    = 20,
	SCE_NP_LANG_ARABIC        = 21,
	SCE_NP_LANG_FRENCH_CA     = 22,
};

enum SceNpAvatarSizeType
{
	SCE_NP_AVATAR_SIZE_LARGE,
	SCE_NP_AVATAR_SIZE_MIDDLE,
	SCE_NP_AVATAR_SIZE_SMALL
};

// Constants for basic NP functions and structures
enum
{
	SCE_NP_BASIC_MAX_MESSAGE_SIZE                       = 512,
	SCE_NP_BASIC_MAX_PRESENCE_SIZE                      = 128,
	SCE_NP_BASIC_MAX_MESSAGE_ATTACHMENT_SIZE            = 1048576,
	SCE_NP_BASIC_SUBJECT_CHARACTER_MAX                  = 18,
	SCE_NP_BASIC_BODY_CHARACTER_MAX                     = 512,
	SCE_NP_BASIC_DESCRIPTION_CHARACTER_MAX              = 341,
	SCE_NP_BASIC_SEND_MESSAGE_MAX_RECIPIENTS            = 12,
	SCE_NP_BASIC_PRESENCE_TITLE_SIZE_MAX                = 128,
	SCE_NP_BASIC_PRESENCE_STATUS_SIZE_MAX               = 64,
	SCE_NP_BASIC_PRESENCE_STATUS_CHARACTER_MAX          = 21,
	SCE_NP_BASIC_PRESENCE_EXTENDED_STATUS_SIZE_MAX      = 192,
	SCE_NP_BASIC_PRESENCE_EXTENDED_STATUS_CHARACTER_MAX = 63,
	SCE_NP_BASIC_PRESENCE_COMMENT_SIZE_MAX              = 64,
	SCE_NP_BASIC_MAX_INVITATION_DATA_SIZE               = 1024,
	SCE_NP_BASIC_MAX_URL_ATTACHMENT_SIZE                = 2048,
	SCE_NP_BASIC_PLAYER_HISTORY_MAX_PLAYERS             = 8,
};

// Common constants of sceNpClans
enum
{
	SCE_NP_CLANS_CLAN_NAME_MAX_LENGTH        = 64,
	SCE_NP_CLANS_CLAN_TAG_MAX_LENGTH         = 8,
	SCE_NP_CLANS_CLAN_DESCRIPTION_MAX_LENGTH = 255,
};

// Constants for custom menu functions and structures
enum
{
	SCE_NP_CUSTOM_MENU_ACTION_CHARACTER_MAX   = 21,
	SCE_NP_CUSTOM_MENU_ACTION_ITEMS_MAX       = 7,
	SCE_NP_CUSTOM_MENU_ACTION_ITEMS_TOTAL_MAX = 16,
	SCE_NP_CUSTOM_MENU_EXCEPTION_ITEMS_MAX    = 256,
};

// Constants for manager functions and structures
enum
{
	SCE_NP_COOKIE_MAX_SIZE       = 1024,
	SCE_NP_TICKET_MAX_SIZE       = 65536,
	SCE_NP_TICKET_PARAM_DATA_LEN = 256,
	SCE_NP_ENTITLEMENT_ID_SIZE   = 32,
};

enum
{
    SCE_NP_ENTITLEMENT_TYPE_NON_CONSUMABLE = 0,
    SCE_NP_ENTITLEMENT_TYPE_CONSUMABLE     = 1
};

// Constants for ranking (score) functions and structures
enum
{
	SCE_NP_SCORE_MAX_CTX_NUM                    = 32,
	SCE_NP_SCORE_COMMENT_MAXLEN                 = 63,
	SCE_NP_SCORE_GAMEDATA_ID_LEN                = 63,
	SCE_NP_SCORE_GAMEINFO_SIZE                  = 64,
	SCE_NP_SCORE_PASSPHRASE_SIZE                = 128,
	SCE_NP_SCORE_CENSOR_COMMENT_MAXLEN          = 255,
	SCE_NP_SCORE_SANITIZE_COMMENT_MAXLEN        = 255,
	SCE_NP_SCORE_MAX_RANGE_NUM_PER_TRANS        = 100,
	SCE_NP_SCORE_MAX_NPID_NUM_PER_TRANS         = 101,
	SCE_NP_SCORE_MAX_CLAN_NUM_PER_TRANS         = 101,
	SCE_NP_SCORE_MAX_SELECTED_FRIENDS_NUM       = 100,
	SCE_NP_SCORE_VARIABLE_SIZE_GAMEINFO_MAXSIZE = 189,
};

enum
{
	SCE_NP_SCORE_NORMAL_UPDATE = 0,
	SCE_NP_SCORE_FORCE_UPDATE = 1
};

enum
{
	SCE_NP_SCORE_DESCENDING_ORDER = 0,
	SCE_NP_SCORE_ASCENDING_ORDER = 1
};

// Constants for signaling functions and structures
enum
{
	SCE_NP_SIGNALING_CTX_MAX = 8,
};

enum : SceNpPlatformType
{
	SCE_NP_PLATFORM_TYPE_NONE = 0,
	SCE_NP_PLATFORM_TYPE_PS3  = 1,
	SCE_NP_PLATFORM_TYPE_VITA = 2,
	SCE_NP_PLATFORM_TYPE_PS4 = 3, // Note: unknown on which fw versions it appears, but sdk version is unchecked
};

enum
{
	SCE_NP_MATCHING_GUI_EVENT_CREATE_ROOM         = 0x0001,
	SCE_NP_MATCHING_GUI_EVENT_JOIN_ROOM           = 0x0002,
	SCE_NP_MATCHING_GUI_EVENT_RESERVED2           = 0x0003,
	SCE_NP_MATCHING_GUI_EVENT_SEARCH_JOIN         = 0x0004,
	SCE_NP_MATCHING_GUI_EVENT_QUICK_MATCH         = 0x0005,
	SCE_NP_MATCHING_GUI_EVENT_SEND_INVITATION     = 0x0006,
	SCE_NP_MATCHING_GUI_EVENT_ACCEPT_INVITATION   = 0x0007,
	SCE_NP_MATCHING_GUI_EVENT_COMMON_LOAD         = 0x0008,
	SCE_NP_MATCHING_GUI_EVENT_COMMON_UNLOAD       = 0x0009,
	SCE_NP_MATCHING_GUI_EVENT_GET_ROOM_LIST       = 0x000a,
	SCE_NP_MATCHING_GUI_EVENT_GET_ROOM_LIST_LIMIT = 0x000b
};

enum
{
	SCE_NP_TICKET_PARAM_SERIAL_ID          = 0,
	SCE_NP_TICKET_PARAM_ISSUER_ID          = 1,
	SCE_NP_TICKET_PARAM_ISSUED_DATE        = 2,
	SCE_NP_TICKET_PARAM_EXPIRE_DATE        = 3,
	SCE_NP_TICKET_PARAM_SUBJECT_ACCOUNT_ID = 4,
	SCE_NP_TICKET_PARAM_SUBJECT_ONLINE_ID  = 5,
	SCE_NP_TICKET_PARAM_SUBJECT_REGION     = 6,
	SCE_NP_TICKET_PARAM_SUBJECT_DOMAIN     = 7,
	SCE_NP_TICKET_PARAM_SERVICE_ID         = 8,
	SCE_NP_TICKET_PARAM_SUBJECT_STATUS     = 9,
	SCE_NP_TICKET_PARAM_STATUS_DURATION    = 10,
	SCE_NP_TICKET_PARAM_SUBJECT_DOB        = 11,
};

enum
{
	SCE_NP_TICKET_SERIAL_ID_SIZE = 20,
	SCE_NP_SUBJECT_REGION_SIZE   = 4,
	SCE_NP_SUBJECT_DOMAIN_SIZE   = 4,
	SCE_NP_SERVICE_ID_SIZE       = 24,
};

enum
{
	SCE_NP_LOOKUP_MAX_CTX_NUM = 32
};

enum
{
	SCE_NP_AUTH_OAUTH_REQUEST_ID_MAX = 4
};

struct SceNpDrmKey
{
	u8 keydata[16];
};

struct SceNpDrmOpenArg
{
	be_t<u64> flag;
};

// NP communication ID structure
struct SceNpCommunicationId
{
	char data[9 + 1]; // char term;
	u8 num;
	char dummy;
};

// OnlineId structure
struct SceNpOnlineId
{
	char data[16 + 1]; // char term;
	char dummy[3];
};

// NP ID structure
struct SceNpId
{
	SceNpOnlineId handle;

	union
	{
		// This field (system reserved) seems to be combined of two parts
		// The second is used by sceNpUtilSetPlatformType and sceNpUtilGetPlatformType
		u8 opt[8];
		nse_t<u32, 1> unk1[2];
	};

	u8 reserved[8];
};

CHECK_SIZE_ALIGN(SceNpId, 0x24, 1);

// Online Name structure
struct SceNpOnlineName
{
	char data[48 + 1]; // char term;
	char padding[3];
};

// Avatar structure
struct SceNpAvatarUrl
{
	char data[127 + 1]; // char term;
};

// Avatar image structure
struct SceNpAvatarImage
{
	u8 data[SCE_NET_NP_AVATAR_IMAGE_MAX_SIZE];
	be_t<u32> size;
	u8 reserved[12];
};

// Self introduction structure
struct SceNpAboutMe
{
	char data[SCE_NET_NP_ABOUT_ME_MAX_LENGTH + 1]; // char term;
};

// User information structure
struct SceNpUserInfo
{
	SceNpId userId;
	SceNpOnlineName name;
	SceNpAvatarUrl icon;
};

// User information structure
struct SceNpUserInfo2
{
	SceNpId npId;
	vm::bptr<SceNpOnlineName> onlineName;
	vm::bptr<SceNpAvatarUrl> avatarUrl;
};

// Often used languages structure
struct SceNpMyLanguages
{
	be_t<s32> language1;
	be_t<s32> language2;
	be_t<s32> language3;
	u8 padding[4];
};

// NP communication passphrase
struct SceNpCommunicationPassphrase
{
	u8 data[SCE_NP_COMMUNICATION_PASSPHRASE_SIZE];
};

// NP communication signature
struct SceNpCommunicationSignature
{
	u8 data[SCE_NP_COMMUNICATION_SIGNATURE_SIZE];
};

// NP cache information structure
struct SceNpManagerCacheParam
{
	be_t<u32> size;
	SceNpOnlineId onlineId;
	SceNpId npId;
	SceNpOnlineName onlineName;
	SceNpAvatarUrl avatarUrl;
};

// Message attachment data
struct SceNpBasicAttachmentData
{
	be_t<SceNpBasicAttachmentDataId> id;
	be_t<u32> size;
};

// Message extended attachment data
struct SceNpBasicExtendedAttachmentData
{
	be_t<u64> flags;
	be_t<u64> msgId;
	SceNpBasicAttachmentData data;
	be_t<u32> userAction;
	u8 markedAsUsed;
	u8 reserved[3];
};

// Message structure
struct SceNpBasicMessageDetails
{
	be_t<u64> msgId;
	be_t<u16> mainType;
	be_t<u16> subType;
	be_t<u32> msgFeatures;
	vm::bptr<SceNpId> npids;
	be_t<u32> count;
	vm::bptr<char> subject;
	vm::bptr<char> body;
	vm::bptr<u8> data;
	be_t<u32> size;
};

// Presence details of an user
struct SceNpBasicPresenceDetails
{
	s8 title[SCE_NP_BASIC_PRESENCE_TITLE_SIZE_MAX];
	s8 status[SCE_NP_BASIC_PRESENCE_STATUS_SIZE_MAX];
	s8 comment[SCE_NP_BASIC_PRESENCE_COMMENT_SIZE_MAX];
	u8 data[SCE_NP_BASIC_MAX_PRESENCE_SIZE];
	be_t<u32> size;
	be_t<s32> state;
};

// Extended presence details of an user
struct SceNpBasicPresenceDetails2
{
	be_t<u32> struct_size;
	be_t<s32> state;
	s8 title[SCE_NP_BASIC_PRESENCE_TITLE_SIZE_MAX];
	s8 status[SCE_NP_BASIC_PRESENCE_EXTENDED_STATUS_SIZE_MAX];
	s8 comment[SCE_NP_BASIC_PRESENCE_COMMENT_SIZE_MAX];
	u8 data[SCE_NP_BASIC_MAX_PRESENCE_SIZE];
	be_t<u32> size;
};

// Country/region code
struct SceNpCountryCode
{
	s8 data[2];
	s8 term;
	s8 padding[1];
};

// Date information
struct SceNpDate
{
	be_t<u16> year;
	u8 month;
	u8 day;
};

// Entitlement ID (fixed-length)
struct SceNpEntitlementId
{
	u8 data[SCE_NP_ENTITLEMENT_ID_SIZE]; // Unsigned char? What is the right type...?
};

// Callback for getting the connection status
using SceNpManagerCallback = void(s32 event, s32 result, vm::ptr<void> arg);

// Score data unique to the application
struct SceNpScoreGameInfo
{
	u8 nativeData[SCE_NP_SCORE_GAMEINFO_SIZE];
};

// Ranking comment structure
struct SceNpScoreComment
{
	s8 data[SCE_NP_SCORE_COMMENT_MAXLEN];
	s8 term[1];
};

// Ranking information structure
struct SceNpScoreRankData
{
	SceNpId npId;
	SceNpOnlineName onlineName;
	be_t<s32> pcId;
	be_t<u32> serialRank;
	be_t<u32> rank;
	be_t<u32> highestRank;
	be_t<s32> hasGameData;
	u8 pad0[4];
	be_t<s64> scoreValue;
	CellRtcTick recordDate;
};

// Version of SceNpScoreRankData that was deprecated in 180.002
struct SceNpScoreRankData_deprecated
{
	SceNpId npId;
	SceNpOnlineName onlineName;
	be_t<u32> serialRank;
	be_t<u32> rank;
	be_t<u32> highestRank;
	be_t<s32> hasGameData;
	be_t<s64> scoreValue;
	CellRtcTick recordDate;
};

// Ranking information of a player or a clan member
struct SceNpScorePlayerRankData
{
	be_t<s32> hasData;
	u8 pad0[4];
	SceNpScoreRankData rankData;
};

// Version of SceNpScorePlayerRankData that was deprecated in 180.002
struct SceNpScorePlayerRankData_deprecated
{
	be_t<s32> hasData;
	u8 pad0[4];
	SceNpScoreRankData_deprecated rankData;
};

// Scoreboard information
struct SceNpScoreBoardInfo
{
	be_t<u32> rankLimit;
	be_t<u32> updateMode;
	be_t<u32> sortMode;
	be_t<u32> uploadNumLimit;
	be_t<u32> uploadSizeLimit;
};

// NOTE: Use SceNpCommunicationPassphrase instead
// Authentication information per NP Communication ID for score ranking
// SceNpCommunicationPassphrase SceNpScorePassphrase;

// NP ID structure with player character ID
struct SceNpScoreNpIdPcId
{
	SceNpId npId;
	be_t<s32> pcId;
	u8 pad[4];
};

// Basic clan information to be used in raking
struct SceNpScoreClanBasicInfo
{
	s8 clanName[SCE_NP_CLANS_CLAN_NAME_MAX_LENGTH + 1];
	s8 clanTag[SCE_NP_CLANS_CLAN_TAG_MAX_LENGTH + 1];
	u8 reserved[10];
};

// Clan member information handled in ranking
struct SceNpScoreClansMemberDescription
{
	s8 description[SCE_NP_CLANS_CLAN_DESCRIPTION_MAX_LENGTH + 1];
};

// Clan ranking information
struct SceNpScoreClanRankData
{
	be_t<u32> clanId;
	SceNpScoreClanBasicInfo clanInfo;
	be_t<u32> regularMemberCount;
	be_t<u32> recordMemberCount;
	be_t<u32> serialRank;
	be_t<u32> rank;
	be_t<s64> scoreValue;
	CellRtcTick recordDate;
	SceNpId npId;
	SceNpOnlineName onlineName;
	u8 reserved[32];
};

// Clan ranking information to be obtained for a specified clan ID
struct SceNpScoreClanIdRankData
{
	be_t<s32> hasData;
	u8 pad0[4];
	SceNpScoreClanRankData rankData;
};

// Union for connection information
union SceNpSignalingConnectionInfo
{
	be_t<u32> rtt;
	be_t<u32> bandwidth;
	SceNpId npId;
	struct
	{
		np_in_addr addr; // in_addr
		np_in_port_t port; // in_port_t
	} address;
	be_t<u32> packet_loss;
};

// Network information structure
struct SceNpSignalingNetInfo
{
	be_t<u32> size;
	be_t<u32> local_addr; // in_addr
	be_t<u32> mapped_addr; // in_addr
	be_t<s32> nat_status;
	be_t<s32> upnp_status;
	be_t<s32> npport_status;
	be_t<u16> npport;
};

struct SceNpCustomMenuAction
{
	be_t<u32> options;
	vm::bcptr<char> name;
	be_t<SceNpCustomMenuActionMask> mask;
};

struct SceNpCustomMenu
{
	be_t<u64> options;
	vm::bptr<SceNpCustomMenuAction> actions;
	be_t<u32> numActions;
};

struct SceNpCustomMenuIndexArray
{
	be_t<SceNpCustomMenuIndexMask> index_bits[SCE_NP_CUSTOM_MENU_INDEX_SETSIZE >> SCE_NP_CUSTOM_MENU_INDEX_BITS_SHIFT];
};

struct SceNpCustomMenuActionExceptions
{
	be_t<u32> options;
	SceNpId npid;
	SceNpCustomMenuIndexArray actions;
	u8 reserved[4];
};

struct SceNpCommerceProductCategory
{
	be_t<u32> version;
	vm::bcptr<void> data;
	be_t<u32> dataSize;
	be_t<u32> dval;
	u8 reserved[16];
};

struct SceNpCommerceProductSkuInfo
{
	vm::bptr<SceNpCommerceProductCategory> pc;
	vm::bcptr<void> data;
	u8 reserved[8];
};

struct SceNpCommerceCategoryInfo
{
	vm::bptr<SceNpCommerceProductCategory> pc;
	vm::bcptr<void> data;
	u8 reserved[8];
};

struct SceNpCommerceCurrencyInfo
{
	vm::bptr<SceNpCommerceProductCategory> pc;
	vm::bcptr<void> data;
	u8 reserved[8];
};

struct SceNpCommercePrice
{
	be_t<u32> integer;
	be_t<u32> fractional;
};

struct SceNpTicketVersion
{
	be_t<u16> major;
	be_t<u16> minor;
};

union SceNpTicketParam
{
	be_t<s32> i32;
	be_t<s64> i64;
	be_t<u32> ui32;
	be_t<u64> ui64;
	SceNpDate date;
	u8 data[SCE_NP_TICKET_PARAM_DATA_LEN];
};

struct SceNpEntitlement
{
	SceNpEntitlementId id;
	be_t<SceNpTime> created_date;
	be_t<SceNpTime> expire_date;
	be_t<u32> type;
	be_t<s32> remaining_count;
	be_t<u32> consumed_count;
	u8 padding[4];
};

struct SceNpLobbyId
{
	u8 opt[28];
	u8 reserved[8];
};

struct SceNpRoomId
{
	u8 opt[28];
	u8 reserved[8];
};

struct SceNpMatchingAttr
{
	vm::bptr<SceNpMatchingAttr> next;
	be_t<s32> type;
	be_t<u32> id;
	union
	{
		be_t<u32> num;
		struct
		{
			vm::bptr<void> ptr;
			be_t<u32> size;
		} data;
	} value;
};

struct SceNpMatchingSearchCondition
{
	vm::bptr<SceNpMatchingSearchCondition> next;
	be_t<s32> target_attr_type;
	be_t<u32> target_attr_id;
	be_t<s32> comp_op;
	be_t<s32> comp_type;
	SceNpMatchingAttr compared;
};

struct SceNpMatchingReqRange
{
	be_t<u32> start;
	be_t<u32> max;
};

struct SceNpScoreVariableSizeGameInfo
{
	be_t<u32> infoSize;
	u8 data[SCE_NP_SCORE_VARIABLE_SIZE_GAMEINFO_MAXSIZE];
	u8 pad[3];
};

struct SceNpScoreRecordOptParam
{
	be_t<u32> size;
	vm::bptr<SceNpScoreVariableSizeGameInfo> vsInfo;
	vm::bptr<CellRtcTick> reserved;
};

// Old GUI API structures

struct SceNpMatchingRoomMember
{
	vm::bptr<SceNpMatchingRoomMember> next;
	SceNpUserInfo user_info;
	be_t<s32> owner;
};

struct SceNpMatchingRoomStatus
{
	SceNpRoomId id;
	vm::bptr<SceNpMatchingRoomMember> members;
	be_t<s32> num;
	vm::bptr<SceNpId> kick_actor;
	vm::bptr<void> opt;
	be_t<s32> opt_len;
};

struct SceNpMatchingJoinedRoomInfo
{
	SceNpLobbyId lobbyid;
	SceNpMatchingRoomStatus room_status;
};

struct SceNpMatchingRange
{
	be_t<u32> start;
	be_t<u32> results;
	be_t<u32> total;
};

struct SceNpMatchingRoom
{
	vm::bptr<SceNpMatchingRoom> next;
	SceNpRoomId id;
	vm::bptr<SceNpMatchingAttr> attr;
};

struct SceNpMatchingRoomList
{
	SceNpLobbyId lobbyid;
	SceNpMatchingRange range;
	vm::bptr<SceNpMatchingRoom> head;
};

struct SceNpMatchingSearchJoinRoomInfo
{
	SceNpLobbyId lobbyid;
	SceNpMatchingRoomStatus room_status;
	vm::bptr<SceNpMatchingAttr> attr;
};

// NP callback functions
using SceNpCustomMenuEventHandler = s32(s32 retCode, u32 index, vm::cptr<SceNpId> npid, SceNpCustomMenuSelectedType type, vm::ptr<void> arg);
using SceNpBasicEventHandler = s32(s32 event, s32 retCode, u32 reqId, vm::ptr<void> arg);
using SceNpCommerceHandler = void(u32 ctx_id, u32 subject_id, s32 event, s32 error_code, vm::ptr<void> arg);
using SceNpSignalingHandler = void(u32 ctx_id, u32 subject_id, s32 event, s32 error_code, vm::ptr<void> arg);
using SceNpFriendlistResultHandler = s32(s32 retCode, vm::ptr<void> arg);
using SceNpMatchingHandler = void(u32 ctx_id, u32 req_id, s32 event, s32 error_code, vm::ptr<void> arg);
using SceNpMatchingGUIHandler = void(u32 ctx_id, s32 event, s32 error_code, vm::ptr<void> arg);
using SceNpProfileResultHandler = s32(s32 result, vm::ptr<void> arg);

using SceNpManagerSubSigninCallback = void(s32 result, vm::ptr<SceNpId> npId, vm::ptr<void> cb_arg);

// Used to pass data to UI/RPCN
struct message_data
{
	SceNpCommunicationId commId{};
	u64 msgId = 0;
	u16 mainType = 0;
	u16 subType = 0;
	u32 msgFeatures = 0;
	std::string subject;
	std::string body;
	std::vector<u8> data;
	void print() const;
};

struct np_state
{
	atomic_t<bool> abort_gui_flag = false;
};

namespace rpcn
{
	class rpcn_client;
}

class SendMessageDialogBase
{
public:
	virtual ~SendMessageDialogBase() = default;

	virtual error_code Exec(message_data& msg_data, std::set<std::string>& npids) = 0;
	virtual void callback_handler(u16 ntype, const std::string& username, bool status) = 0;

protected:
	std::shared_ptr<rpcn::rpcn_client> m_rpcn;
};

class RecvMessageDialogBase
{
public:
	virtual ~RecvMessageDialogBase() = default;

	virtual error_code Exec(SceNpBasicMessageMainType type, SceNpBasicMessageRecvOptions options, SceNpBasicMessageRecvAction& recv_result, u64& chosen_msg_id) = 0;
	virtual void callback_handler(const shared_ptr<std::pair<std::string, message_data>> new_msg, u64 msg_id) = 0;

protected:
	std::shared_ptr<rpcn::rpcn_client> m_rpcn;
};

// Generic functions, also used in SceNpMatchingInt.cpp
error_code matching_create_room(u32 ctx_id, vm::cptr<SceNpCommunicationId> communicationId, vm::cptr<SceNpMatchingAttr> attr, vm::ptr<SceNpMatchingGUIHandler> handler, vm::ptr<void> arg);
error_code matching_join_room(u32 ctx_id, vm::ptr<SceNpRoomId> room_id, vm::ptr<SceNpMatchingGUIHandler> handler, vm::ptr<void> arg);
error_code matching_get_room_list(u32 ctx_id, vm::ptr<SceNpCommunicationId> communicationId, vm::ptr<SceNpMatchingReqRange> range, vm::ptr<SceNpMatchingSearchCondition> cond,
	vm::ptr<SceNpMatchingAttr> attr, vm::ptr<SceNpMatchingGUIHandler> handler, vm::ptr<void> arg, bool limit);
error_code matching_set_room_info(u32 ctx_id, vm::ptr<SceNpLobbyId> lobby_id, vm::ptr<SceNpRoomId> room_id, vm::ptr<SceNpMatchingAttr> attr, vm::ptr<u32> req_id, bool limit);
error_code matching_get_room_info(u32 ctx_id, vm::ptr<SceNpLobbyId> lobby_id, vm::ptr<SceNpRoomId> room_id, vm::ptr<SceNpMatchingAttr> attr, vm::ptr<u32> req_id, bool limit);
error_code matching_get_room_member_list(u32 ctx_id, vm::ptr<SceNpRoomId> room_id, vm::ptr<u32> buflen, vm::ptr<void> buf);
