/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Subtarget Enumeration Source Fragment                                      *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/


#ifdef GET_SUBTARGETINFO_ENUM
#undef GET_SUBTARGETINFO_ENUM

namespace llvm {
namespace X86 {
enum {
  Feature3DNow = 0,
  Feature3DNowA = 1,
  FeatureADX = 2,
  FeatureAES = 3,
  FeatureAMXBF16 = 4,
  FeatureAMXFP16 = 5,
  FeatureAMXINT8 = 6,
  FeatureAMXTILE = 7,
  FeatureAVX = 8,
  FeatureAVX2 = 9,
  FeatureAVX512 = 10,
  FeatureAVXIFMA = 11,
  FeatureAVXNECONVERT = 12,
  FeatureAVXVNNI = 13,
  FeatureAVXVNNIINT8 = 14,
  FeatureBF16 = 15,
  FeatureBITALG = 16,
  FeatureBMI = 17,
  FeatureBMI2 = 18,
  FeatureBWI = 19,
  FeatureCDI = 20,
  FeatureCLDEMOTE = 21,
  FeatureCLFLUSHOPT = 22,
  FeatureCLWB = 23,
  FeatureCLZERO = 24,
  FeatureCMOV = 25,
  FeatureCMPCCXADD = 26,
  FeatureCRC32 = 27,
  FeatureCX8 = 28,
  FeatureCX16 = 29,
  FeatureDQI = 30,
  FeatureENQCMD = 31,
  FeatureERI = 32,
  FeatureERMSB = 33,
  FeatureF16C = 34,
  FeatureFMA = 35,
  FeatureFMA4 = 36,
  FeatureFP16 = 37,
  FeatureFSGSBase = 38,
  FeatureFSRM = 39,
  FeatureFXSR = 40,
  FeatureGFNI = 41,
  FeatureHRESET = 42,
  FeatureHardenSlsIJmp = 43,
  FeatureHardenSlsRet = 44,
  FeatureIFMA = 45,
  FeatureINVPCID = 46,
  FeatureKL = 47,
  FeatureLAHFSAHF64 = 48,
  FeatureLVIControlFlowIntegrity = 49,
  FeatureLVILoadHardening = 50,
  FeatureLWP = 51,
  FeatureLZCNT = 52,
  FeatureMMX = 53,
  FeatureMOVBE = 54,
  FeatureMOVDIR64B = 55,
  FeatureMOVDIRI = 56,
  FeatureMWAITX = 57,
  FeatureNOPL = 58,
  FeaturePCLMUL = 59,
  FeaturePCONFIG = 60,
  FeaturePFI = 61,
  FeaturePKU = 62,
  FeaturePOPCNT = 63,
  FeaturePREFETCHI = 64,
  FeaturePREFETCHWT1 = 65,
  FeaturePRFCHW = 66,
  FeaturePTWRITE = 67,
  FeatureRAOINT = 68,
  FeatureRDPID = 69,
  FeatureRDPRU = 70,
  FeatureRDRAND = 71,
  FeatureRDSEED = 72,
  FeatureRTM = 73,
  FeatureRetpoline = 74,
  FeatureRetpolineExternalThunk = 75,
  FeatureRetpolineIndirectBranches = 76,
  FeatureRetpolineIndirectCalls = 77,
  FeatureSERIALIZE = 78,
  FeatureSGX = 79,
  FeatureSHA = 80,
  FeatureSHSTK = 81,
  FeatureSSE1 = 82,
  FeatureSSE2 = 83,
  FeatureSSE3 = 84,
  FeatureSSE4A = 85,
  FeatureSSE41 = 86,
  FeatureSSE42 = 87,
  FeatureSSEUnalignedMem = 88,
  FeatureSSSE3 = 89,
  FeatureSoftFloat = 90,
  FeatureSpeculativeExecutionSideEffectSuppression = 91,
  FeatureTBM = 92,
  FeatureTSXLDTRK = 93,
  FeatureTaggedGlobals = 94,
  FeatureUINTR = 95,
  FeatureVAES = 96,
  FeatureVBMI = 97,
  FeatureVBMI2 = 98,
  FeatureVLX = 99,
  FeatureVNNI = 100,
  FeatureVP2INTERSECT = 101,
  FeatureVPCLMULQDQ = 102,
  FeatureVPOPCNTDQ = 103,
  FeatureWAITPKG = 104,
  FeatureWBNOINVD = 105,
  FeatureWIDEKL = 106,
  FeatureX86_64 = 107,
  FeatureX87 = 108,
  FeatureXOP = 109,
  FeatureXSAVE = 110,
  FeatureXSAVEC = 111,
  FeatureXSAVEOPT = 112,
  FeatureXSAVES = 113,
  Is16Bit = 114,
  Is32Bit = 115,
  Is64Bit = 116,
  ProcIntelAtom = 117,
  TuningAllowLight256Bit = 118,
  TuningBranchFusion = 119,
  TuningFast7ByteNOP = 120,
  TuningFast11ByteNOP = 121,
  TuningFast15ByteNOP = 122,
  TuningFastBEXTR = 123,
  TuningFastGather = 124,
  TuningFastHorizontalOps = 125,
  TuningFastLZCNT = 126,
  TuningFastMOVBE = 127,
  TuningFastSHLDRotate = 128,
  TuningFastScalarFSQRT = 129,
  TuningFastScalarShiftMasks = 130,
  TuningFastVariableCrossLaneShuffle = 131,
  TuningFastVariablePerLaneShuffle = 132,
  TuningFastVectorFSQRT = 133,
  TuningFastVectorShiftMasks = 134,
  TuningGETMANTFalseDeps = 135,
  TuningInsertVZEROUPPER = 136,
  TuningLEAForSP = 137,
  TuningLEAUsesAG = 138,
  TuningLZCNTFalseDeps = 139,
  TuningMULCFalseDeps = 140,
  TuningMULLQFalseDeps = 141,
  TuningMacroFusion = 142,
  TuningPERMFalseDeps = 143,
  TuningPOPCNTFalseDeps = 144,
  TuningPadShortFunctions = 145,
  TuningPrefer128Bit = 146,
  TuningPrefer256Bit = 147,
  TuningPreferMaskRegisters = 148,
  TuningRANGEFalseDeps = 149,
  TuningSBBDepBreaking = 150,
  TuningSlow3OpsLEA = 151,
  TuningSlowDivide32 = 152,
  TuningSlowDivide64 = 153,
  TuningSlowIncDec = 154,
  TuningSlowLEA = 155,
  TuningSlowPMADDWD = 156,
  TuningSlowPMULLD = 157,
  TuningSlowSHLD = 158,
  TuningSlowTwoMemOps = 159,
  TuningSlowUAMem16 = 160,
  TuningSlowUAMem32 = 161,
  TuningUseGLMDivSqrtCosts = 162,
  TuningUseSLMArithCosts = 163,
  NumSubtargetFeatures = 164
};
} // end namespace X86
} // end namespace llvm

#endif // GET_SUBTARGETINFO_ENUM


#ifdef GET_SUBTARGETINFO_MACRO
GET_SUBTARGETINFO_MACRO(IsAtom, false, isAtom)
GET_SUBTARGETINFO_MACRO(Is16Bit, false, is16Bit)
GET_SUBTARGETINFO_MACRO(Is32Bit, false, is32Bit)
GET_SUBTARGETINFO_MACRO(HasX86_64, false, hasX86_64)
GET_SUBTARGETINFO_MACRO(Is64Bit, false, is64Bit)
GET_SUBTARGETINFO_MACRO(HasADX, false, hasADX)
GET_SUBTARGETINFO_MACRO(HasAES, false, hasAES)
GET_SUBTARGETINFO_MACRO(AllowLight256Bit, false, allowLight256Bit)
GET_SUBTARGETINFO_MACRO(HasAMXBF16, false, hasAMXBF16)
GET_SUBTARGETINFO_MACRO(HasAMXFP16, false, hasAMXFP16)
GET_SUBTARGETINFO_MACRO(HasAMXINT8, false, hasAMXINT8)
GET_SUBTARGETINFO_MACRO(HasAMXTILE, false, hasAMXTILE)
GET_SUBTARGETINFO_MACRO(HasBF16, false, hasBF16)
GET_SUBTARGETINFO_MACRO(HasBITALG, false, hasBITALG)
GET_SUBTARGETINFO_MACRO(HasBWI, false, hasBWI)
GET_SUBTARGETINFO_MACRO(HasCDI, false, hasCDI)
GET_SUBTARGETINFO_MACRO(HasDQI, false, hasDQI)
GET_SUBTARGETINFO_MACRO(HasERI, false, hasERI)
GET_SUBTARGETINFO_MACRO(HasFP16, false, hasFP16)
GET_SUBTARGETINFO_MACRO(HasIFMA, false, hasIFMA)
GET_SUBTARGETINFO_MACRO(HasPFI, false, hasPFI)
GET_SUBTARGETINFO_MACRO(HasVBMI, false, hasVBMI)
GET_SUBTARGETINFO_MACRO(HasVBMI2, false, hasVBMI2)
GET_SUBTARGETINFO_MACRO(HasVLX, false, hasVLX)
GET_SUBTARGETINFO_MACRO(HasVNNI, false, hasVNNI)
GET_SUBTARGETINFO_MACRO(HasVP2INTERSECT, false, hasVP2INTERSECT)
GET_SUBTARGETINFO_MACRO(HasVPOPCNTDQ, false, hasVPOPCNTDQ)
GET_SUBTARGETINFO_MACRO(HasAVXIFMA, false, hasAVXIFMA)
GET_SUBTARGETINFO_MACRO(HasAVXNECONVERT, false, hasAVXNECONVERT)
GET_SUBTARGETINFO_MACRO(HasAVXVNNI, false, hasAVXVNNI)
GET_SUBTARGETINFO_MACRO(HasAVXVNNIINT8, false, hasAVXVNNIINT8)
GET_SUBTARGETINFO_MACRO(HasBMI, false, hasBMI)
GET_SUBTARGETINFO_MACRO(HasBMI2, false, hasBMI2)
GET_SUBTARGETINFO_MACRO(HasBranchFusion, false, hasBranchFusion)
GET_SUBTARGETINFO_MACRO(HasCLDEMOTE, false, hasCLDEMOTE)
GET_SUBTARGETINFO_MACRO(HasCLFLUSHOPT, false, hasCLFLUSHOPT)
GET_SUBTARGETINFO_MACRO(HasCLWB, false, hasCLWB)
GET_SUBTARGETINFO_MACRO(HasCLZERO, false, hasCLZERO)
GET_SUBTARGETINFO_MACRO(HasCMOV, false, hasCMOV)
GET_SUBTARGETINFO_MACRO(HasCMPCCXADD, false, hasCMPCCXADD)
GET_SUBTARGETINFO_MACRO(HasCRC32, false, hasCRC32)
GET_SUBTARGETINFO_MACRO(HasCX16, false, hasCX16)
GET_SUBTARGETINFO_MACRO(HasCX8, false, hasCX8)
GET_SUBTARGETINFO_MACRO(HasENQCMD, false, hasENQCMD)
GET_SUBTARGETINFO_MACRO(HasERMSB, false, hasERMSB)
GET_SUBTARGETINFO_MACRO(HasF16C, false, hasF16C)
GET_SUBTARGETINFO_MACRO(HasGETMANTFalseDeps, false, hasGETMANTFalseDeps)
GET_SUBTARGETINFO_MACRO(HasLZCNTFalseDeps, false, hasLZCNTFalseDeps)
GET_SUBTARGETINFO_MACRO(HasMULCFalseDeps, false, hasMULCFalseDeps)
GET_SUBTARGETINFO_MACRO(HasMULLQFalseDeps, false, hasMULLQFalseDeps)
GET_SUBTARGETINFO_MACRO(HasPERMFalseDeps, false, hasPERMFalseDeps)
GET_SUBTARGETINFO_MACRO(HasPOPCNTFalseDeps, false, hasPOPCNTFalseDeps)
GET_SUBTARGETINFO_MACRO(HasRANGEFalseDeps, false, hasRANGEFalseDeps)
GET_SUBTARGETINFO_MACRO(HasFast11ByteNOP, false, hasFast11ByteNOP)
GET_SUBTARGETINFO_MACRO(HasFast15ByteNOP, false, hasFast15ByteNOP)
GET_SUBTARGETINFO_MACRO(HasFast7ByteNOP, false, hasFast7ByteNOP)
GET_SUBTARGETINFO_MACRO(HasFastBEXTR, false, hasFastBEXTR)
GET_SUBTARGETINFO_MACRO(HasFastGather, false, hasFastGather)
GET_SUBTARGETINFO_MACRO(HasFastHorizontalOps, false, hasFastHorizontalOps)
GET_SUBTARGETINFO_MACRO(HasFastLZCNT, false, hasFastLZCNT)
GET_SUBTARGETINFO_MACRO(HasFastMOVBE, false, hasFastMOVBE)
GET_SUBTARGETINFO_MACRO(HasFastScalarFSQRT, false, hasFastScalarFSQRT)
GET_SUBTARGETINFO_MACRO(HasFastScalarShiftMasks, false, hasFastScalarShiftMasks)
GET_SUBTARGETINFO_MACRO(HasFastSHLDRotate, false, hasFastSHLDRotate)
GET_SUBTARGETINFO_MACRO(HasFastVariableCrossLaneShuffle, false, hasFastVariableCrossLaneShuffle)
GET_SUBTARGETINFO_MACRO(HasFastVariablePerLaneShuffle, false, hasFastVariablePerLaneShuffle)
GET_SUBTARGETINFO_MACRO(HasFastVectorFSQRT, false, hasFastVectorFSQRT)
GET_SUBTARGETINFO_MACRO(HasFastVectorShiftMasks, false, hasFastVectorShiftMasks)
GET_SUBTARGETINFO_MACRO(HasFMA, false, hasFMA)
GET_SUBTARGETINFO_MACRO(HasFMA4, false, hasFMA4)
GET_SUBTARGETINFO_MACRO(HasFSGSBase, false, hasFSGSBase)
GET_SUBTARGETINFO_MACRO(HasFSRM, false, hasFSRM)
GET_SUBTARGETINFO_MACRO(HasFXSR, false, hasFXSR)
GET_SUBTARGETINFO_MACRO(HasGFNI, false, hasGFNI)
GET_SUBTARGETINFO_MACRO(HardenSlsIJmp, false, hardenSlsIJmp)
GET_SUBTARGETINFO_MACRO(HardenSlsRet, false, hardenSlsRet)
GET_SUBTARGETINFO_MACRO(HasHRESET, false, hasHRESET)
GET_SUBTARGETINFO_MACRO(HasSlowDivide32, false, hasSlowDivide32)
GET_SUBTARGETINFO_MACRO(HasSlowDivide64, false, hasSlowDivide64)
GET_SUBTARGETINFO_MACRO(HasINVPCID, false, hasINVPCID)
GET_SUBTARGETINFO_MACRO(HasKL, false, hasKL)
GET_SUBTARGETINFO_MACRO(UseLeaForSP, false, useLeaForSP)
GET_SUBTARGETINFO_MACRO(LeaUsesAG, false, leaUsesAG)
GET_SUBTARGETINFO_MACRO(UseLVIControlFlowIntegrity, false, useLVIControlFlowIntegrity)
GET_SUBTARGETINFO_MACRO(UseLVILoadHardening, false, useLVILoadHardening)
GET_SUBTARGETINFO_MACRO(HasLWP, false, hasLWP)
GET_SUBTARGETINFO_MACRO(HasLZCNT, false, hasLZCNT)
GET_SUBTARGETINFO_MACRO(HasMacroFusion, false, hasMacroFusion)
GET_SUBTARGETINFO_MACRO(HasMOVBE, false, hasMOVBE)
GET_SUBTARGETINFO_MACRO(HasMOVDIR64B, false, hasMOVDIR64B)
GET_SUBTARGETINFO_MACRO(HasMOVDIRI, false, hasMOVDIRI)
GET_SUBTARGETINFO_MACRO(HasMWAITX, false, hasMWAITX)
GET_SUBTARGETINFO_MACRO(HasNOPL, false, hasNOPL)
GET_SUBTARGETINFO_MACRO(PadShortFunctions, false, padShortFunctions)
GET_SUBTARGETINFO_MACRO(HasPCLMUL, false, hasPCLMUL)
GET_SUBTARGETINFO_MACRO(HasPCONFIG, false, hasPCONFIG)
GET_SUBTARGETINFO_MACRO(HasPKU, false, hasPKU)
GET_SUBTARGETINFO_MACRO(HasPOPCNT, false, hasPOPCNT)
GET_SUBTARGETINFO_MACRO(Prefer128Bit, false, prefer128Bit)
GET_SUBTARGETINFO_MACRO(Prefer256Bit, false, prefer256Bit)
GET_SUBTARGETINFO_MACRO(PreferMaskRegisters, false, preferMaskRegisters)
GET_SUBTARGETINFO_MACRO(HasPREFETCHI, false, hasPREFETCHI)
GET_SUBTARGETINFO_MACRO(HasPREFETCHWT1, false, hasPREFETCHWT1)
GET_SUBTARGETINFO_MACRO(HasPRFCHW, false, hasPRFCHW)
GET_SUBTARGETINFO_MACRO(HasPTWRITE, false, hasPTWRITE)
GET_SUBTARGETINFO_MACRO(HasRAOINT, false, hasRAOINT)
GET_SUBTARGETINFO_MACRO(HasRDPID, false, hasRDPID)
GET_SUBTARGETINFO_MACRO(HasRDPRU, false, hasRDPRU)
GET_SUBTARGETINFO_MACRO(HasRDRAND, false, hasRDRAND)
GET_SUBTARGETINFO_MACRO(HasRDSEED, false, hasRDSEED)
GET_SUBTARGETINFO_MACRO(DeprecatedUseRetpoline, false, deprecatedUseRetpoline)
GET_SUBTARGETINFO_MACRO(UseRetpolineExternalThunk, false, useRetpolineExternalThunk)
GET_SUBTARGETINFO_MACRO(UseRetpolineIndirectBranches, false, useRetpolineIndirectBranches)
GET_SUBTARGETINFO_MACRO(UseRetpolineIndirectCalls, false, useRetpolineIndirectCalls)
GET_SUBTARGETINFO_MACRO(HasRTM, false, hasRTM)
GET_SUBTARGETINFO_MACRO(HasLAHFSAHF64, false, hasLAHFSAHF64)
GET_SUBTARGETINFO_MACRO(HasSBBDepBreaking, false, hasSBBDepBreaking)
GET_SUBTARGETINFO_MACRO(HasSERIALIZE, false, hasSERIALIZE)
GET_SUBTARGETINFO_MACRO(UseSpeculativeExecutionSideEffectSuppression, false, useSpeculativeExecutionSideEffectSuppression)
GET_SUBTARGETINFO_MACRO(HasSGX, false, hasSGX)
GET_SUBTARGETINFO_MACRO(HasSHA, false, hasSHA)
GET_SUBTARGETINFO_MACRO(HasSHSTK, false, hasSHSTK)
GET_SUBTARGETINFO_MACRO(Slow3OpsLEA, false, slow3OpsLEA)
GET_SUBTARGETINFO_MACRO(SlowIncDec, false, slowIncDec)
GET_SUBTARGETINFO_MACRO(SlowLEA, false, slowLEA)
GET_SUBTARGETINFO_MACRO(IsPMADDWDSlow, false, isPMADDWDSlow)
GET_SUBTARGETINFO_MACRO(IsPMULLDSlow, false, isPMULLDSlow)
GET_SUBTARGETINFO_MACRO(IsSHLDSlow, false, isSHLDSlow)
GET_SUBTARGETINFO_MACRO(SlowTwoMemOps, false, slowTwoMemOps)
GET_SUBTARGETINFO_MACRO(IsUnalignedMem16Slow, false, isUnalignedMem16Slow)
GET_SUBTARGETINFO_MACRO(IsUnalignedMem32Slow, false, isUnalignedMem32Slow)
GET_SUBTARGETINFO_MACRO(UseSoftFloat, false, useSoftFloat)
GET_SUBTARGETINFO_MACRO(HasSSEUnalignedMem, false, hasSSEUnalignedMem)
GET_SUBTARGETINFO_MACRO(HasSSE4A, false, hasSSE4A)
GET_SUBTARGETINFO_MACRO(AllowTaggedGlobals, false, allowTaggedGlobals)
GET_SUBTARGETINFO_MACRO(HasTBM, false, hasTBM)
GET_SUBTARGETINFO_MACRO(HasTSXLDTRK, false, hasTSXLDTRK)
GET_SUBTARGETINFO_MACRO(HasUINTR, false, hasUINTR)
GET_SUBTARGETINFO_MACRO(UseGLMDivSqrtCosts, false, useGLMDivSqrtCosts)
GET_SUBTARGETINFO_MACRO(UseSLMArithCosts, false, useSLMArithCosts)
GET_SUBTARGETINFO_MACRO(HasVAES, false, hasVAES)
GET_SUBTARGETINFO_MACRO(HasVPCLMULQDQ, false, hasVPCLMULQDQ)
GET_SUBTARGETINFO_MACRO(InsertVZEROUPPER, false, insertVZEROUPPER)
GET_SUBTARGETINFO_MACRO(HasWAITPKG, false, hasWAITPKG)
GET_SUBTARGETINFO_MACRO(HasWBNOINVD, false, hasWBNOINVD)
GET_SUBTARGETINFO_MACRO(HasWIDEKL, false, hasWIDEKL)
GET_SUBTARGETINFO_MACRO(HasX87, false, hasX87)
GET_SUBTARGETINFO_MACRO(HasXOP, false, hasXOP)
GET_SUBTARGETINFO_MACRO(HasXSAVE, false, hasXSAVE)
GET_SUBTARGETINFO_MACRO(HasXSAVEC, false, hasXSAVEC)
GET_SUBTARGETINFO_MACRO(HasXSAVEOPT, false, hasXSAVEOPT)
GET_SUBTARGETINFO_MACRO(HasXSAVES, false, hasXSAVES)
#undef GET_SUBTARGETINFO_MACRO
#endif // GET_SUBTARGETINFO_MACRO


#ifdef GET_SUBTARGETINFO_MC_DESC
#undef GET_SUBTARGETINFO_MC_DESC

namespace llvm {
// Sorted (by key) array of values for CPU features.
extern const llvm::SubtargetFeatureKV X86FeatureKV[] = {
  { "16bit-mode", "16-bit mode (i8086)", X86::Is16Bit, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "32bit-mode", "32-bit mode (80386)", X86::Is32Bit, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "3dnow", "Enable 3DNow! instructions", X86::Feature3DNow, { { { 0x20000000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "3dnowa", "Enable 3DNow! Athlon instructions", X86::Feature3DNowA, { { { 0x1ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "64bit", "Support 64-bit instructions", X86::FeatureX86_64, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "64bit-mode", "64-bit mode (x86_64)", X86::Is64Bit, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "adx", "Support ADX instructions", X86::FeatureADX, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "aes", "Enable AES instructions", X86::FeatureAES, { { { 0x0ULL, 0x80000ULL, 0x0ULL, 0x0ULL, } } } },
  { "allow-light-256-bit", "Enable generation of 256-bit load/stores even if we prefer 128-bit", X86::TuningAllowLight256Bit, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "amx-bf16", "Support AMX-BF16 instructions", X86::FeatureAMXBF16, { { { 0x80ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "amx-fp16", "Support AMX amx-fp16 instructions", X86::FeatureAMXFP16, { { { 0x80ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "amx-int8", "Support AMX-INT8 instructions", X86::FeatureAMXINT8, { { { 0x80ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "amx-tile", "Support AMX-TILE instructions", X86::FeatureAMXTILE, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx", "Enable AVX instructions", X86::FeatureAVX, { { { 0x0ULL, 0x800000ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx2", "Enable AVX2 instructions", X86::FeatureAVX2, { { { 0x100ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512bf16", "Support bfloat16 floating point", X86::FeatureBF16, { { { 0x80000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512bitalg", "Enable AVX-512 Bit Algorithms", X86::FeatureBITALG, { { { 0x80000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512bw", "Enable AVX-512 Byte and Word Instructions", X86::FeatureBWI, { { { 0x400ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512cd", "Enable AVX-512 Conflict Detection Instructions", X86::FeatureCDI, { { { 0x400ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512dq", "Enable AVX-512 Doubleword and Quadword Instructions", X86::FeatureDQI, { { { 0x400ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512er", "Enable AVX-512 Exponential and Reciprocal Instructions", X86::FeatureERI, { { { 0x400ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512f", "Enable AVX-512 instructions", X86::FeatureAVX512, { { { 0xc00000200ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512fp16", "Support 16-bit floating point", X86::FeatureFP16, { { { 0x40080000ULL, 0x800000000ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512ifma", "Enable AVX-512 Integer Fused Multiple-Add", X86::FeatureIFMA, { { { 0x400ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512pf", "Enable AVX-512 PreFetch Instructions", X86::FeaturePFI, { { { 0x400ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512vbmi", "Enable AVX-512 Vector Byte Manipulation Instructions", X86::FeatureVBMI, { { { 0x80000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512vbmi2", "Enable AVX-512 further Vector Byte Manipulation Instructions", X86::FeatureVBMI2, { { { 0x80000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512vl", "Enable AVX-512 Vector Length eXtensions", X86::FeatureVLX, { { { 0x400ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512vnni", "Enable AVX-512 Vector Neural Network Instructions", X86::FeatureVNNI, { { { 0x400ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512vp2intersect", "Enable AVX-512 vp2intersect", X86::FeatureVP2INTERSECT, { { { 0x400ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512vpopcntdq", "Enable AVX-512 Population Count Instructions", X86::FeatureVPOPCNTDQ, { { { 0x400ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avxifma", "Enable AVX-IFMA", X86::FeatureAVXIFMA, { { { 0x200ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avxneconvert", "Support AVX-NE-CONVERT instructions", X86::FeatureAVXNECONVERT, { { { 0x200ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avxvnni", "Support AVX_VNNI encoding", X86::FeatureAVXVNNI, { { { 0x200ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avxvnniint8", "Enable AVX-VNNI-INT8", X86::FeatureAVXVNNIINT8, { { { 0x200ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "bmi", "Support BMI instructions", X86::FeatureBMI, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "bmi2", "Support BMI2 instructions", X86::FeatureBMI2, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "branchfusion", "CMP/TEST can be fused with conditional branches", X86::TuningBranchFusion, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "cldemote", "Enable Cache Line Demote", X86::FeatureCLDEMOTE, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "clflushopt", "Flush A Cache Line Optimized", X86::FeatureCLFLUSHOPT, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "clwb", "Cache Line Write Back", X86::FeatureCLWB, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "clzero", "Enable Cache Line Zero", X86::FeatureCLZERO, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "cmov", "Enable conditional move instructions", X86::FeatureCMOV, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "cmpccxadd", "Support CMPCCXADD instructions", X86::FeatureCMPCCXADD, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "crc32", "Enable SSE 4.2 CRC32 instruction (used when SSE4.2 is supported but function is GPR only)", X86::FeatureCRC32, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "cx16", "64-bit with cmpxchg16b (this is true for most x86-64 chips, but not the first AMD chips)", X86::FeatureCX16, { { { 0x10000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "cx8", "Support CMPXCHG8B instructions", X86::FeatureCX8, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "enqcmd", "Has ENQCMD instructions", X86::FeatureENQCMD, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "ermsb", "REP MOVS/STOS are fast", X86::FeatureERMSB, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "f16c", "Support 16-bit floating point conversion instructions", X86::FeatureF16C, { { { 0x100ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "false-deps-getmant", "VGETMANTSS/SD/SH and VGETMANDPS/PD(memory version) has a false dependency on dest register", X86::TuningGETMANTFalseDeps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "false-deps-lzcnt-tzcnt", "LZCNT/TZCNT have a false dependency on dest register", X86::TuningLZCNTFalseDeps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "false-deps-mulc", "VF[C]MULCPH/SH has a false dependency on dest register", X86::TuningMULCFalseDeps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "false-deps-mullq", "VPMULLQ has a false dependency on dest register", X86::TuningMULLQFalseDeps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "false-deps-perm", "VPERMD/Q/PS/PD has a false dependency on dest register", X86::TuningPERMFalseDeps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "false-deps-popcnt", "POPCNT has a false dependency on dest register", X86::TuningPOPCNTFalseDeps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "false-deps-range", "VRANGEPD/PS/SD/SS has a false dependency on dest register", X86::TuningRANGEFalseDeps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-11bytenop", "Target can quickly decode up to 11 byte NOPs", X86::TuningFast11ByteNOP, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-15bytenop", "Target can quickly decode up to 15 byte NOPs", X86::TuningFast15ByteNOP, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-7bytenop", "Target can quickly decode up to 7 byte NOPs", X86::TuningFast7ByteNOP, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-bextr", "Indicates that the BEXTR instruction is implemented as a single uop with good throughput", X86::TuningFastBEXTR, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-gather", "Indicates if gather is reasonably fast (this is true for Skylake client and all AVX-512 CPUs)", X86::TuningFastGather, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-hops", "Prefer horizontal vector math instructions (haddp, phsub, etc.) over normal vector instructions with shuffles", X86::TuningFastHorizontalOps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-lzcnt", "LZCNT instructions are as fast as most simple integer ops", X86::TuningFastLZCNT, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-movbe", "Prefer a movbe over a single-use load + bswap / single-use bswap + store", X86::TuningFastMOVBE, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-scalar-fsqrt", "Scalar SQRT is fast (disable Newton-Raphson)", X86::TuningFastScalarFSQRT, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-scalar-shift-masks", "Prefer a left/right scalar logical shift pair over a shift+and pair", X86::TuningFastScalarShiftMasks, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-shld-rotate", "SHLD can be used as a faster rotate", X86::TuningFastSHLDRotate, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-variable-crosslane-shuffle", "Cross-lane shuffles with variable masks are fast", X86::TuningFastVariableCrossLaneShuffle, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-variable-perlane-shuffle", "Per-lane shuffles with variable masks are fast", X86::TuningFastVariablePerLaneShuffle, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-vector-fsqrt", "Vector SQRT is fast (disable Newton-Raphson)", X86::TuningFastVectorFSQRT, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-vector-shift-masks", "Prefer a left/right vector logical shift pair over a shift+and pair", X86::TuningFastVectorShiftMasks, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fma", "Enable three-operand fused multiple-add", X86::FeatureFMA, { { { 0x100ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fma4", "Enable four-operand fused multiple-add", X86::FeatureFMA4, { { { 0x100ULL, 0x200000ULL, 0x0ULL, 0x0ULL, } } } },
  { "fsgsbase", "Support FS/GS Base instructions", X86::FeatureFSGSBase, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fsrm", "REP MOVSB of short lengths is faster", X86::FeatureFSRM, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fxsr", "Support fxsave/fxrestore instructions", X86::FeatureFXSR, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "gfni", "Enable Galois Field Arithmetic Instructions", X86::FeatureGFNI, { { { 0x0ULL, 0x80000ULL, 0x0ULL, 0x0ULL, } } } },
  { "harden-sls-ijmp", "Harden against straight line speculation across indirect JMP instructions.", X86::FeatureHardenSlsIJmp, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "harden-sls-ret", "Harden against straight line speculation across RET instructions.", X86::FeatureHardenSlsRet, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "hreset", "Has hreset instruction", X86::FeatureHRESET, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "idivl-to-divb", "Use 8-bit divide for positive values less than 256", X86::TuningSlowDivide32, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "idivq-to-divl", "Use 32-bit divide for positive values less than 2^32", X86::TuningSlowDivide64, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "invpcid", "Invalidate Process-Context Identifier", X86::FeatureINVPCID, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "kl", "Support Key Locker kl Instructions", X86::FeatureKL, { { { 0x0ULL, 0x80000ULL, 0x0ULL, 0x0ULL, } } } },
  { "lea-sp", "Use LEA for adjusting the stack pointer (this is an optimization for Intel Atom processors)", X86::TuningLEAForSP, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "lea-uses-ag", "LEA instruction needs inputs at AG stage", X86::TuningLEAUsesAG, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "lvi-cfi", "Prevent indirect calls/branches from using a memory operand, and precede all indirect calls/branches from a register with an LFENCE instruction to serialize control flow. Also decompose RET instructions into a POP+LFENCE+JMP sequence.", X86::FeatureLVIControlFlowIntegrity, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "lvi-load-hardening", "Insert LFENCE instructions to prevent data speculatively injected into loads from being used maliciously.", X86::FeatureLVILoadHardening, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "lwp", "Enable LWP instructions", X86::FeatureLWP, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "lzcnt", "Support LZCNT instruction", X86::FeatureLZCNT, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "macrofusion", "Various instructions can be fused with conditional branches", X86::TuningMacroFusion, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "mmx", "Enable MMX instructions", X86::FeatureMMX, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "movbe", "Support MOVBE instruction", X86::FeatureMOVBE, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "movdir64b", "Support movdir64b instruction (direct store 64 bytes)", X86::FeatureMOVDIR64B, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "movdiri", "Support movdiri instruction (direct store integer)", X86::FeatureMOVDIRI, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "mwaitx", "Enable MONITORX/MWAITX timer functionality", X86::FeatureMWAITX, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "nopl", "Enable NOPL instruction (generally pentium pro+)", X86::FeatureNOPL, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "pad-short-functions", "Pad short functions (to prevent a stall when returning too early)", X86::TuningPadShortFunctions, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "pclmul", "Enable packed carry-less multiplication instructions", X86::FeaturePCLMUL, { { { 0x0ULL, 0x80000ULL, 0x0ULL, 0x0ULL, } } } },
  { "pconfig", "platform configuration instruction", X86::FeaturePCONFIG, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "pku", "Enable protection keys", X86::FeaturePKU, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "popcnt", "Support POPCNT instruction", X86::FeaturePOPCNT, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "prefer-128-bit", "Prefer 128-bit AVX instructions", X86::TuningPrefer128Bit, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "prefer-256-bit", "Prefer 256-bit AVX instructions", X86::TuningPrefer256Bit, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "prefer-mask-registers", "Prefer AVX512 mask registers over PTEST/MOVMSK", X86::TuningPreferMaskRegisters, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "prefetchi", "Prefetch instruction with T0 or T1 Hint", X86::FeaturePREFETCHI, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "prefetchwt1", "Prefetch with Intent to Write and T1 Hint", X86::FeaturePREFETCHWT1, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "prfchw", "Support PRFCHW instructions", X86::FeaturePRFCHW, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "ptwrite", "Support ptwrite instruction", X86::FeaturePTWRITE, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "raoint", "Support RAO-INT instructions", X86::FeatureRAOINT, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "rdpid", "Support RDPID instructions", X86::FeatureRDPID, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "rdpru", "Support RDPRU instructions", X86::FeatureRDPRU, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "rdrnd", "Support RDRAND instruction", X86::FeatureRDRAND, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "rdseed", "Support RDSEED instruction", X86::FeatureRDSEED, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "retpoline", "Remove speculation of indirect branches from the generated code, either by avoiding them entirely or lowering them with a speculation blocking construct", X86::FeatureRetpoline, { { { 0x0ULL, 0x3000ULL, 0x0ULL, 0x0ULL, } } } },
  { "retpoline-external-thunk", "When lowering an indirect call or branch using a `retpoline`, rely on the specified user provided thunk rather than emitting one ourselves. Only has effect when combined with some other retpoline feature", X86::FeatureRetpolineExternalThunk, { { { 0x0ULL, 0x2000ULL, 0x0ULL, 0x0ULL, } } } },
  { "retpoline-indirect-branches", "Remove speculation of indirect branches from the generated code", X86::FeatureRetpolineIndirectBranches, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "retpoline-indirect-calls", "Remove speculation of indirect calls from the generated code", X86::FeatureRetpolineIndirectCalls, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "rtm", "Support RTM instructions", X86::FeatureRTM, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sahf", "Support LAHF and SAHF instructions in 64-bit mode", X86::FeatureLAHFSAHF64, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sbb-dep-breaking", "SBB with same register has no source dependency", X86::TuningSBBDepBreaking, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "serialize", "Has serialize instruction", X86::FeatureSERIALIZE, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "seses", "Prevent speculative execution side channel timing attacks by inserting a speculation barrier before memory reads, memory writes, and conditional branches. Implies LVI Control Flow integrity.", X86::FeatureSpeculativeExecutionSideEffectSuppression, { { { 0x2000000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sgx", "Enable Software Guard Extensions", X86::FeatureSGX, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sha", "Enable SHA instructions", X86::FeatureSHA, { { { 0x0ULL, 0x80000ULL, 0x0ULL, 0x0ULL, } } } },
  { "shstk", "Support CET Shadow-Stack instructions", X86::FeatureSHSTK, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-3ops-lea", "LEA instruction with 3 ops or certain registers is slow", X86::TuningSlow3OpsLEA, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-incdec", "INC and DEC instructions are slower than ADD and SUB", X86::TuningSlowIncDec, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-lea", "LEA instruction with certain arguments is slow", X86::TuningSlowLEA, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-pmaddwd", "PMADDWD is slower than PMULLD", X86::TuningSlowPMADDWD, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-pmulld", "PMULLD instruction is slow (compared to PMULLW/PMULHW and PMULUDQ)", X86::TuningSlowPMULLD, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-shld", "SHLD instruction is slow", X86::TuningSlowSHLD, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-two-mem-ops", "Two memory operand instructions are slow", X86::TuningSlowTwoMemOps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-unaligned-mem-16", "Slow unaligned 16-byte memory access", X86::TuningSlowUAMem16, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-unaligned-mem-32", "Slow unaligned 32-byte memory access", X86::TuningSlowUAMem32, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "soft-float", "Use software floating point features", X86::FeatureSoftFloat, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sse", "Enable SSE instructions", X86::FeatureSSE1, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sse-unaligned-mem", "Allow unaligned memory operands with SSE instructions (this may require setting a configuration bit in the processor)", X86::FeatureSSEUnalignedMem, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sse2", "Enable SSE2 instructions", X86::FeatureSSE2, { { { 0x0ULL, 0x40000ULL, 0x0ULL, 0x0ULL, } } } },
  { "sse3", "Enable SSE3 instructions", X86::FeatureSSE3, { { { 0x0ULL, 0x80000ULL, 0x0ULL, 0x0ULL, } } } },
  { "sse4.1", "Enable SSE 4.1 instructions", X86::FeatureSSE41, { { { 0x0ULL, 0x2000000ULL, 0x0ULL, 0x0ULL, } } } },
  { "sse4.2", "Enable SSE 4.2 instructions", X86::FeatureSSE42, { { { 0x0ULL, 0x400000ULL, 0x0ULL, 0x0ULL, } } } },
  { "sse4a", "Support SSE 4a instructions", X86::FeatureSSE4A, { { { 0x0ULL, 0x100000ULL, 0x0ULL, 0x0ULL, } } } },
  { "ssse3", "Enable SSSE3 instructions", X86::FeatureSSSE3, { { { 0x0ULL, 0x100000ULL, 0x0ULL, 0x0ULL, } } } },
  { "tagged-globals", "Use an instruction sequence for taking the address of a global that allows a memory tag in the upper address bits.", X86::FeatureTaggedGlobals, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "tbm", "Enable TBM instructions", X86::FeatureTBM, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "tsxldtrk", "Support TSXLDTRK instructions", X86::FeatureTSXLDTRK, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "uintr", "Has UINTR Instructions", X86::FeatureUINTR, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "use-glm-div-sqrt-costs", "Use Goldmont specific floating point div/sqrt costs", X86::TuningUseGLMDivSqrtCosts, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "use-slm-arith-costs", "Use Silvermont specific arithmetic costs", X86::TuningUseSLMArithCosts, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "vaes", "Promote selected AES instructions to AVX512/AVX registers", X86::FeatureVAES, { { { 0x108ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "vpclmulqdq", "Enable vpclmulqdq instructions", X86::FeatureVPCLMULQDQ, { { { 0x800000000000100ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "vzeroupper", "Should insert vzeroupper instructions", X86::TuningInsertVZEROUPPER, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "waitpkg", "Wait and pause enhancements", X86::FeatureWAITPKG, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "wbnoinvd", "Write Back No Invalidate", X86::FeatureWBNOINVD, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "widekl", "Support Key Locker wide Instructions", X86::FeatureWIDEKL, { { { 0x800000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "x87", "Enable X87 float instructions", X86::FeatureX87, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "xop", "Enable XOP instructions", X86::FeatureXOP, { { { 0x1000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "xsave", "Support xsave instructions", X86::FeatureXSAVE, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "xsavec", "Support xsavec instructions", X86::FeatureXSAVEC, { { { 0x0ULL, 0x400000000000ULL, 0x0ULL, 0x0ULL, } } } },
  { "xsaveopt", "Support xsaveopt instructions", X86::FeatureXSAVEOPT, { { { 0x0ULL, 0x400000000000ULL, 0x0ULL, 0x0ULL, } } } },
  { "xsaves", "Support xsaves instructions", X86::FeatureXSAVES, { { { 0x0ULL, 0x400000000000ULL, 0x0ULL, 0x0ULL, } } } },
};

#ifdef DBGFIELD
#error "<target>GenSubtargetInfo.inc requires a DBGFIELD macro"
#endif
#if !defined(NDEBUG) || defined(LLVM_ENABLE_DUMP)
#define DBGFIELD(x) x,
#else
#define DBGFIELD(x)
#endif

// ===============================================================
// Data tables for the new per-operand machine model.

// {ProcResourceIdx, Cycles}
extern const llvm::MCWriteProcResEntry X86WriteProcResTable[] = {
  { 0,  0}, // Invalid
  { 5,  1}, // #1
  { 1,  1}, // #2
  { 2,  1}, // #3
  { 3,  1}, // #4
  { 4,  1}, // #5
  { 5,  1}, // #6
  { 6,  1}, // #7
  { 7,  1}, // #8
  { 8,  1}, // #9
  { 4,  1}, // #10
  { 5,  1}, // #11
  { 7,  1}, // #12
  { 8,  1}, // #13
  { 4,  2}, // #14
  { 5,  3}, // #15
  { 7,  2}, // #16
  { 8,  2}, // #17
  {15,  2}, // #18
  {16,  1}, // #19
  {19,  1}, // #20
  {23,  1}, // #21
  { 4,  1}, // #22
  { 5,  1}, // #23
  { 7,  1}, // #24
  { 8,  1}, // #25
  {13,  1}, // #26
  {14,  1}, // #27
  {15,  1}, // #28
  {16,  1}, // #29
  { 2,  1}, // #30
  { 3,  1}, // #31
  { 4,  1}, // #32
  { 5,  1}, // #33
  { 9,  1}, // #34
  {10,  1}, // #35
  {11,  1}, // #36
  {15,  1}, // #37
  {19,  1}, // #38
  {23,  1}, // #39
  { 5,  1}, // #40
  {15,  2}, // #41
  {16,  1}, // #42
  {19,  1}, // #43
  {23,  1}, // #44
  { 4,  1}, // #45
  { 5,  2}, // #46
  { 7,  1}, // #47
  { 8,  1}, // #48
  {15,  2}, // #49
  {16,  1}, // #50
  {19,  1}, // #51
  {23,  1}, // #52
  { 3,  1}, // #53
  { 4,  1}, // #54
  { 5,  1}, // #55
  {10,  1}, // #56
  {11,  1}, // #57
  {15,  1}, // #58
  {16,  1}, // #59
  { 3,  1}, // #60
  { 4,  1}, // #61
  { 5,  1}, // #62
  { 6,  1}, // #63
  { 7,  1}, // #64
  {10,  1}, // #65
  {11,  1}, // #66
  {20,  1}, // #67
  { 2,  1}, // #68
  { 3,  1}, // #69
  { 4,  1}, // #70
  { 5,  1}, // #71
  {15,  1}, // #72
  {16,  1}, // #73
  { 2,  2}, // #74
  { 3,  2}, // #75
  { 4,  2}, // #76
  { 5,  2}, // #77
  {15,  1}, // #78
  {16,  1}, // #79
  { 1,  4}, // #80
  { 2,  5}, // #81
  { 3, 11}, // #82
  { 4, 13}, // #83
  { 5, 13}, // #84
  { 6,  7}, // #85
  { 7,  9}, // #86
  { 8,  6}, // #87
  {10,  6}, // #88
  {11,  6}, // #89
  {15,  1}, // #90
  {16,  1}, // #91
  {20,  3}, // #92
  { 1,  4}, // #93
  { 2,  5}, // #94
  { 3, 12}, // #95
  { 4, 14}, // #96
  { 5, 14}, // #97
  { 6,  7}, // #98
  { 7,  9}, // #99
  { 8,  6}, // #100
  {10,  6}, // #101
  {11,  6}, // #102
  {20,  3}, // #103
  { 2,  1}, // #104
  { 3,  1}, // #105
  { 4,  2}, // #106
  { 5,  2}, // #107
  { 7,  1}, // #108
  { 8,  1}, // #109
  { 9,  1}, // #110
  {10,  1}, // #111
  {11,  1}, // #112
  {15,  1}, // #113
  {16,  1}, // #114
  { 5,  1}, // #115
  {11,  1}, // #116
  {15,  1}, // #117
  {16,  1}, // #118
  { 2,  1}, // #119
  { 3,  1}, // #120
  { 4,  1}, // #121
  { 5,  1}, // #122
  { 9,  1}, // #123
  {10,  1}, // #124
  {11,  1}, // #125
  {15,  1}, // #126
  {16,  1}, // #127
  { 2,  1}, // #128
  { 3,  1}, // #129
  { 4,  3}, // #130
  { 5,  9}, // #131
  { 7,  2}, // #132
  { 8,  2}, // #133
  { 9,  1}, // #134
  {10,  1}, // #135
  {11,  3}, // #136
  {15,  1}, // #137
  {16,  1}, // #138
  { 2,  1}, // #139
  { 3,  1}, // #140
  { 4,  1}, // #141
  { 5,  1}, // #142
  { 9,  1}, // #143
  {10,  1}, // #144
  {11,  1}, // #145
  {15,  2}, // #146
  {16,  1}, // #147
  {19,  1}, // #148
  {23,  1}, // #149
  { 2,  1}, // #150
  { 3,  1}, // #151
  { 4,  3}, // #152
  { 5,  8}, // #153
  { 7,  2}, // #154
  { 8,  2}, // #155
  { 9,  1}, // #156
  {10,  1}, // #157
  {11,  3}, // #158
  {15,  2}, // #159
  {16,  1}, // #160
  {19,  1}, // #161
  {23,  1}, // #162
  { 4,  1}, // #163
  { 5,  1}, // #164
  { 7,  1}, // #165
  { 8,  1}, // #166
  {15,  1}, // #167
  {16,  1}, // #168
  { 4,  2}, // #169
  { 5,  5}, // #170
  { 7,  2}, // #171
  { 8,  2}, // #172
  { 1,  1}, // #173
  { 2,  1}, // #174
  { 3,  1}, // #175
  { 4,  1}, // #176
  { 5,  1}, // #177
  { 6,  1}, // #178
  { 7,  1}, // #179
  { 8,  1}, // #180
  {15,  1}, // #181
  {16,  1}, // #182
  { 2,  1}, // #183
  { 3,  2}, // #184
  { 4,  2}, // #185
  { 5,  2}, // #186
  { 6,  1}, // #187
  { 7,  1}, // #188
  {10,  1}, // #189
  {11,  1}, // #190
  {20,  1}, // #191
  { 2,  1}, // #192
  { 3,  2}, // #193
  { 4,  2}, // #194
  { 5,  2}, // #195
  { 6,  1}, // #196
  { 7,  1}, // #197
  {10,  1}, // #198
  {11,  1}, // #199
  {15,  1}, // #200
  {16,  1}, // #201
  {20,  1}, // #202
  { 1,  1}, // #203
  { 2,  2}, // #204
  { 3,  2}, // #205
  { 4,  2}, // #206
  { 5,  2}, // #207
  { 6,  1}, // #208
  { 7,  1}, // #209
  { 8,  1}, // #210
  {15,  1}, // #211
  {16,  1}, // #212
  { 2,  3}, // #213
  { 3,  3}, // #214
  { 4,  3}, // #215
  { 5,  4}, // #216
  { 9,  3}, // #217
  {10,  3}, // #218
  {11,  3}, // #219
  {15,  1}, // #220
  {16,  1}, // #221
  { 2,  3}, // #222
  { 3,  3}, // #223
  { 4,  3}, // #224
  { 5,  3}, // #225
  { 9,  3}, // #226
  {10,  3}, // #227
  {11,  3}, // #228
  {15,  1}, // #229
  {16,  1}, // #230
  { 2,  2}, // #231
  { 3,  3}, // #232
  { 4,  3}, // #233
  { 5,  3}, // #234
  {10,  1}, // #235
  {11,  1}, // #236
  {15,  1}, // #237
  {16,  1}, // #238
  { 2,  2}, // #239
  { 3,  5}, // #240
  { 4,  6}, // #241
  { 5,  6}, // #242
  { 6,  1}, // #243
  { 7,  2}, // #244
  { 8,  1}, // #245
  {10,  3}, // #246
  {11,  3}, // #247
  {15,  1}, // #248
  {16,  1}, // #249
  {20,  1}, // #250
  { 2,  2}, // #251
  { 3,  5}, // #252
  { 4,  6}, // #253
  { 5,  6}, // #254
  { 6,  1}, // #255
  { 7,  2}, // #256
  { 8,  1}, // #257
  {10,  3}, // #258
  {11,  3}, // #259
  {20,  1}, // #260
  { 3,  1}, // #261
  { 4,  1}, // #262
  { 5,  1}, // #263
  {10,  1}, // #264
  {11,  1}, // #265
  {15,  1}, // #266
  {19,  1}, // #267
  {23,  1}, // #268
  { 1,  1}, // #269
  { 2,  1}, // #270
  { 3,  2}, // #271
  { 4,  2}, // #272
  { 5,  2}, // #273
  { 6,  1}, // #274
  { 7,  1}, // #275
  { 8,  1}, // #276
  {10,  1}, // #277
  {11,  1}, // #278
  { 3,  1}, // #279
  { 4,  1}, // #280
  { 5,  1}, // #281
  { 6,  1}, // #282
  { 7,  1}, // #283
  {10,  1}, // #284
  {11,  1}, // #285
  {13,  1}, // #286
  {14,  1}, // #287
  {15,  1}, // #288
  {16,  1}, // #289
  {20,  1}, // #290
  { 1,  1}, // #291
  { 2,  1}, // #292
  { 3,  9}, // #293
  { 4, 10}, // #294
  { 5, 10}, // #295
  { 6,  9}, // #296
  { 7, 10}, // #297
  { 8,  2}, // #298
  { 3,  2}, // #299
  { 4,  2}, // #300
  { 5,  2}, // #301
  { 6,  2}, // #302
  { 7,  2}, // #303
  { 3,  3}, // #304
  { 4,  3}, // #305
  { 5,  3}, // #306
  { 6,  2}, // #307
  { 7,  2}, // #308
  {10,  3}, // #309
  {11,  3}, // #310
  {15,  1}, // #311
  {16,  1}, // #312
  {20,  2}, // #313
  { 3,  3}, // #314
  { 4,  3}, // #315
  { 5,  3}, // #316
  { 6,  2}, // #317
  { 7,  2}, // #318
  {10,  3}, // #319
  {11,  3}, // #320
  {20,  2}, // #321
  { 2,  1}, // #322
  { 3,  1}, // #323
  { 4,  2}, // #324
  { 5,  4}, // #325
  { 7,  1}, // #326
  { 8,  1}, // #327
  { 9,  1}, // #328
  {10,  1}, // #329
  {11,  1}, // #330
  {15,  1}, // #331
  {16,  1}, // #332
  { 2,  1}, // #333
  { 3,  1}, // #334
  { 4,  1}, // #335
  { 5,  2}, // #336
  { 9,  1}, // #337
  {10,  1}, // #338
  {11,  1}, // #339
  {15,  1}, // #340
  {16,  1}, // #341
  { 2,  1}, // #342
  { 3,  1}, // #343
  { 4,  2}, // #344
  { 5,  3}, // #345
  { 7,  1}, // #346
  { 8,  1}, // #347
  { 9,  1}, // #348
  {10,  1}, // #349
  {11,  1}, // #350
  {15,  1}, // #351
  {16,  1}, // #352
  { 2,  1}, // #353
  { 3,  2}, // #354
  { 4,  2}, // #355
  { 5,  2}, // #356
  { 6,  1}, // #357
  { 7,  1}, // #358
  { 9,  1}, // #359
  {10,  2}, // #360
  {11,  2}, // #361
  {15,  1}, // #362
  {16,  1}, // #363
  {20,  1}, // #364
  { 2,  1}, // #365
  { 3,  2}, // #366
  { 4,  2}, // #367
  { 5,  2}, // #368
  { 6,  1}, // #369
  { 7,  1}, // #370
  { 9,  1}, // #371
  {10,  2}, // #372
  {11,  2}, // #373
  {20,  1}, // #374
  { 3,  1}, // #375
  { 4,  1}, // #376
  { 5,  1}, // #377
  { 6,  1}, // #378
  { 7,  1}, // #379
  {10,  1}, // #380
  {11,  1}, // #381
  {15,  1}, // #382
  {16,  1}, // #383
  {20,  1}, // #384
  { 1,  1}, // #385
  { 2,  1}, // #386
  { 3,  2}, // #387
  { 4,  3}, // #388
  { 5,  3}, // #389
  { 6,  1}, // #390
  { 7,  2}, // #391
  { 8,  2}, // #392
  {15,  1}, // #393
  {16,  1}, // #394
  { 3,  1}, // #395
  { 4,  1}, // #396
  { 5,  1}, // #397
  { 6,  1}, // #398
  { 7,  1}, // #399
  {15,  1}, // #400
  {16,  1}, // #401
  { 3,  3}, // #402
  { 4,  3}, // #403
  { 5,  3}, // #404
  { 6,  3}, // #405
  { 7,  3}, // #406
  {10,  2}, // #407
  {11,  2}, // #408
  {15,  1}, // #409
  {16,  1}, // #410
  {20,  2}, // #411
  { 3,  3}, // #412
  { 4,  3}, // #413
  { 5,  3}, // #414
  { 6,  3}, // #415
  { 7,  3}, // #416
  {10,  2}, // #417
  {11,  2}, // #418
  {20,  2}, // #419
  { 3,  2}, // #420
  { 4,  2}, // #421
  { 5,  2}, // #422
  { 6,  1}, // #423
  { 7,  1}, // #424
  {10,  2}, // #425
  {11,  2}, // #426
  {20,  1}, // #427
  { 1,  1}, // #428
  { 2,  1}, // #429
  { 3,  2}, // #430
  { 4,  2}, // #431
  { 5,  2}, // #432
  { 6,  2}, // #433
  { 7,  2}, // #434
  { 8,  1}, // #435
  {10,  1}, // #436
  {11,  1}, // #437
  {15,  1}, // #438
  {16,  1}, // #439
  {20,  1}, // #440
  { 1,  1}, // #441
  { 2,  1}, // #442
  { 3,  2}, // #443
  { 4,  2}, // #444
  { 5,  2}, // #445
  { 6,  2}, // #446
  { 7,  2}, // #447
  { 8,  1}, // #448
  {10,  1}, // #449
  {11,  1}, // #450
  {20,  1}, // #451
  { 3,  2}, // #452
  { 4,  2}, // #453
  { 5,  2}, // #454
  { 6,  1}, // #455
  { 7,  1}, // #456
  {10,  2}, // #457
  {11,  2}, // #458
  {15,  1}, // #459
  {16,  1}, // #460
  {20,  1}, // #461
  { 1,  3}, // #462
  { 2,  4}, // #463
  { 3,  6}, // #464
  { 4,  7}, // #465
  { 5,  7}, // #466
  { 6,  4}, // #467
  { 7,  5}, // #468
  { 8,  4}, // #469
  { 9,  1}, // #470
  {10,  2}, // #471
  {11,  2}, // #472
  {15,  1}, // #473
  {16,  1}, // #474
  {20,  1}, // #475
  { 1,  3}, // #476
  { 2,  4}, // #477
  { 3,  7}, // #478
  { 4,  8}, // #479
  { 5,  8}, // #480
  { 6,  4}, // #481
  { 7,  5}, // #482
  { 8,  4}, // #483
  { 9,  1}, // #484
  {10,  2}, // #485
  {11,  2}, // #486
  {20,  1}, // #487
  { 1,  3}, // #488
  { 2,  4}, // #489
  { 3,  7}, // #490
  { 4,  8}, // #491
  { 5,  8}, // #492
  { 6,  4}, // #493
  { 7,  5}, // #494
  { 8,  4}, // #495
  { 9,  1}, // #496
  {10,  2}, // #497
  {11,  2}, // #498
  {15,  1}, // #499
  {16,  1}, // #500
  {20,  1}, // #501
  { 1,  3}, // #502
  { 2,  4}, // #503
  { 3,  8}, // #504
  { 4,  9}, // #505
  { 5,  9}, // #506
  { 6,  4}, // #507
  { 7,  5}, // #508
  { 8,  4}, // #509
  { 9,  1}, // #510
  {10,  2}, // #511
  {11,  2}, // #512
  {20,  1}, // #513
  { 1,  3}, // #514
  { 2,  3}, // #515
  { 3,  3}, // #516
  { 4,  3}, // #517
  { 5,  3}, // #518
  { 6,  3}, // #519
  { 7,  3}, // #520
  { 8,  3}, // #521
  {15,  1}, // #522
  {16,  1}, // #523
  { 3,  3}, // #524
  { 4,  3}, // #525
  { 5,  3}, // #526
  {10,  2}, // #527
  {11,  2}, // #528
  {15,  1}, // #529
  {16,  1}, // #530
  { 2,  1}, // #531
  { 3,  2}, // #532
  { 4,  2}, // #533
  { 5,  2}, // #534
  {10,  1}, // #535
  {11,  1}, // #536
  { 2,  2}, // #537
  { 3,  2}, // #538
  { 4,  5}, // #539
  { 5,  7}, // #540
  { 7,  3}, // #541
  { 8,  3}, // #542
  { 9,  2}, // #543
  {10,  2}, // #544
  {11,  2}, // #545
  {15,  2}, // #546
  {16,  1}, // #547
  {19,  1}, // #548
  {23,  1}, // #549
  { 4,  2}, // #550
  { 5,  2}, // #551
  { 7,  2}, // #552
  { 8,  2}, // #553
  { 4,  1}, // #554
  { 5,  1}, // #555
  { 7,  1}, // #556
  { 8,  1}, // #557
  {15,  2}, // #558
  {16,  1}, // #559
  {19,  1}, // #560
  {23,  1}, // #561
  { 4,  2}, // #562
  { 5,  2}, // #563
  { 7,  2}, // #564
  { 8,  2}, // #565
  {15,  2}, // #566
  {16,  1}, // #567
  {19,  1}, // #568
  {23,  1}, // #569
  { 4,  2}, // #570
  { 5,  2}, // #571
  { 7,  2}, // #572
  { 8,  2}, // #573
  {15,  1}, // #574
  {19,  1}, // #575
  {23,  1}, // #576
  { 2,  1}, // #577
  { 3,  1}, // #578
  { 4,  2}, // #579
  { 5,  3}, // #580
  { 7,  1}, // #581
  { 8,  1}, // #582
  { 9,  1}, // #583
  {10,  1}, // #584
  {11,  1}, // #585
  {15,  2}, // #586
  {16,  1}, // #587
  {19,  1}, // #588
  {23,  1}, // #589
  { 2,  1}, // #590
  { 3,  1}, // #591
  { 4,  1}, // #592
  { 5,  2}, // #593
  { 9,  1}, // #594
  {10,  1}, // #595
  {11,  1}, // #596
  {15,  2}, // #597
  {16,  1}, // #598
  {19,  1}, // #599
  {23,  1}, // #600
  { 1,  1}, // #601
  { 2,  1}, // #602
  { 3,  1}, // #603
  { 4,  1}, // #604
  { 5,  1}, // #605
  { 6,  1}, // #606
  { 7,  1}, // #607
  { 8,  1}, // #608
  {28,  7}, // #609
  { 1,  1}, // #610
  { 2,  1}, // #611
  { 3,  1}, // #612
  { 4,  2}, // #613
  { 5,  2}, // #614
  { 6,  1}, // #615
  { 7,  2}, // #616
  { 8,  2}, // #617
  {15,  1}, // #618
  {19,  1}, // #619
  {23,  1}, // #620
  { 3,  3}, // #621
  { 4,  3}, // #622
  { 5,  3}, // #623
  {15,  1}, // #624
  {16,  1}, // #625
  { 2,  1}, // #626
  { 3,  1}, // #627
  { 4,  1}, // #628
  { 5,  1}, // #629
  {15,  1}, // #630
  {19,  1}, // #631
  {23,  1}, // #632
  { 1,  1}, // #633
  { 2,  1}, // #634
  { 3,  1}, // #635
  { 4,  1}, // #636
  { 5,  1}, // #637
  { 6,  1}, // #638
  { 7,  1}, // #639
  { 8,  1}, // #640
  {15,  1}, // #641
  {19,  1}, // #642
  {23,  1}, // #643
  { 1,  2}, // #644
  { 2,  3}, // #645
  { 3,  7}, // #646
  { 4, 15}, // #647
  { 5, 15}, // #648
  { 6,  6}, // #649
  { 7, 10}, // #650
  { 8,  6}, // #651
  { 9,  1}, // #652
  {10,  3}, // #653
  {11,  3}, // #654
  {20,  2}, // #655
  {21,  4}, // #656
  { 2,  1}, // #657
  { 3,  3}, // #658
  { 4,  3}, // #659
  { 5,  3}, // #660
  { 6,  2}, // #661
  { 7,  2}, // #662
  {10,  2}, // #663
  {11,  2}, // #664
  {20,  2}, // #665
  { 1,  1}, // #666
  { 2,  2}, // #667
  { 3,  3}, // #668
  { 4,  3}, // #669
  { 5,  3}, // #670
  { 6,  2}, // #671
  { 7,  2}, // #672
  { 8,  1}, // #673
  {10,  1}, // #674
  {11,  1}, // #675
  {20,  1}, // #676
  {14,  1}, // #677
  {15,  1}, // #678
  {18,  1}, // #679
  {19,  1}, // #680
  { 5,  4}, // #681
  {15,  2}, // #682
  {16,  1}, // #683
  {19,  1}, // #684
  {23,  1}, // #685
  { 4,  1}, // #686
  { 5,  6}, // #687
  { 7,  1}, // #688
  { 8,  1}, // #689
  {15,  2}, // #690
  {16,  1}, // #691
  {19,  1}, // #692
  {23,  1}, // #693
  { 1,  1}, // #694
  { 2,  1}, // #695
  { 3,  2}, // #696
  { 4,  2}, // #697
  { 5,  2}, // #698
  { 6,  2}, // #699
  { 7,  2}, // #700
  { 8,  1}, // #701
  {13,  1}, // #702
  {14,  1}, // #703
  {15,  1}, // #704
  {16,  1}, // #705
  { 3,  1}, // #706
  { 4,  1}, // #707
  { 5,  1}, // #708
  { 6,  1}, // #709
  { 7,  1}, // #710
  {10,  1}, // #711
  {11,  1}, // #712
  {14,  1}, // #713
  {15,  1}, // #714
  {18,  1}, // #715
  {19,  1}, // #716
  {20,  1}, // #717
  { 2,  1}, // #718
  { 3,  1}, // #719
  { 4,  7}, // #720
  { 5, 11}, // #721
  { 7,  6}, // #722
  { 8,  6}, // #723
  { 9,  1}, // #724
  {10,  1}, // #725
  {11,  1}, // #726
  { 4,  1}, // #727
  { 5,  1}, // #728
  { 7,  1}, // #729
  { 8,  1}, // #730
  {14,  1}, // #731
  {15,  1}, // #732
  {18,  1}, // #733
  {19,  1}, // #734
  {21,  1}, // #735
  { 3,  1}, // #736
  { 4,  2}, // #737
  { 5,  2}, // #738
  { 6,  1}, // #739
  { 7,  2}, // #740
  { 8,  1}, // #741
  {10,  1}, // #742
  {11,  1}, // #743
  {20,  1}, // #744
  { 2,  2}, // #745
  { 3,  2}, // #746
  { 4,  9}, // #747
  { 5, 13}, // #748
  { 7,  7}, // #749
  { 8,  7}, // #750
  { 9,  2}, // #751
  {10,  2}, // #752
  {11,  2}, // #753
  {15,  2}, // #754
  {16,  1}, // #755
  {19,  1}, // #756
  {23,  1}, // #757
  { 2,  1}, // #758
  { 3,  1}, // #759
  { 4,  5}, // #760
  { 5,  7}, // #761
  { 7,  4}, // #762
  { 8,  4}, // #763
  { 9,  1}, // #764
  {10,  1}, // #765
  {11,  1}, // #766
  { 1,  2}, // #767
  { 2,  2}, // #768
  { 3,  6}, // #769
  { 4, 12}, // #770
  { 5, 19}, // #771
  { 6,  4}, // #772
  { 7, 10}, // #773
  { 8,  8}, // #774
  {10,  4}, // #775
  {11,  4}, // #776
  {15,  2}, // #777
  {16,  1}, // #778
  {19,  1}, // #779
  {20,  2}, // #780
  {23,  1}, // #781
  { 4,  4}, // #782
  { 5,  4}, // #783
  { 1,  2}, // #784
  { 2,  8}, // #785
  { 3, 12}, // #786
  { 4, 21}, // #787
  { 5, 21}, // #788
  { 6,  5}, // #789
  { 7, 14}, // #790
  { 8,  9}, // #791
  { 9,  4}, // #792
  {10,  7}, // #793
  {11,  7}, // #794
  {20,  3}, // #795
  { 1,  2}, // #796
  { 2,  4}, // #797
  { 3, 13}, // #798
  { 4, 34}, // #799
  { 5, 34}, // #800
  { 6, 11}, // #801
  { 7, 32}, // #802
  { 8, 23}, // #803
  { 9,  2}, // #804
  {10, 11}, // #805
  {11, 11}, // #806
  {15, 19}, // #807
  {16, 14}, // #808
  {19,  4}, // #809
  {20,  9}, // #810
  {23,  5}, // #811
  { 2,  1}, // #812
  { 3,  1}, // #813
  { 4,  3}, // #814
  { 5,  9}, // #815
  { 7,  2}, // #816
  { 8,  2}, // #817
  { 9,  1}, // #818
  {10,  1}, // #819
  {11,  1}, // #820
  {15,  1}, // #821
  {16,  1}, // #822
  { 3,  1}, // #823
  { 4, 10}, // #824
  { 5, 10}, // #825
  { 6,  1}, // #826
  { 7,  3}, // #827
  { 8,  2}, // #828
  {10,  1}, // #829
  {11,  1}, // #830
  {20,  1}, // #831
  {21,  2}, // #832
  { 1,  7}, // #833
  { 2, 24}, // #834
  { 3, 44}, // #835
  { 4, 70}, // #836
  { 5, 75}, // #837
  { 6, 26}, // #838
  { 7, 52}, // #839
  { 8, 32}, // #840
  { 9, 17}, // #841
  {10, 36}, // #842
  {11, 37}, // #843
  {15, 10}, // #844
  {16,  9}, // #845
  {19,  1}, // #846
  {20, 19}, // #847
  {23,  1}, // #848
  { 3,  9}, // #849
  { 4, 15}, // #850
  { 5, 15}, // #851
  { 6,  9}, // #852
  { 7,  9}, // #853
  {10,  6}, // #854
  {11,  6}, // #855
  {20,  6}, // #856
  { 1,  5}, // #857
  { 2, 20}, // #858
  { 3, 35}, // #859
  { 4, 61}, // #860
  { 5, 66}, // #861
  { 6, 20}, // #862
  { 7, 46}, // #863
  { 8, 31}, // #864
  { 9, 15}, // #865
  {10, 30}, // #866
  {11, 30}, // #867
  {15,  6}, // #868
  {16,  5}, // #869
  {19,  1}, // #870
  {20, 15}, // #871
  {23,  1}, // #872
  { 1,  5}, // #873
  { 2, 20}, // #874
  { 3, 36}, // #875
  { 4, 61}, // #876
  { 5, 66}, // #877
  { 6, 21}, // #878
  { 7, 46}, // #879
  { 8, 30}, // #880
  { 9, 15}, // #881
  {10, 30}, // #882
  {11, 30}, // #883
  {15,  6}, // #884
  {16,  5}, // #885
  {19,  1}, // #886
  {20, 15}, // #887
  {23,  1}, // #888
  { 1,  6}, // #889
  { 2, 23}, // #890
  { 3, 41}, // #891
  { 4, 68}, // #892
  { 5, 73}, // #893
  { 6, 24}, // #894
  { 7, 51}, // #895
  { 8, 33}, // #896
  { 9, 16}, // #897
  {10, 34}, // #898
  {11, 34}, // #899
  {15,  9}, // #900
  {16,  8}, // #901
  {19,  1}, // #902
  {20, 18}, // #903
  {23,  1}, // #904
  { 2,  9}, // #905
  { 3, 23}, // #906
  { 4, 53}, // #907
  { 5, 54}, // #908
  { 6,  3}, // #909
  { 7, 33}, // #910
  { 8, 20}, // #911
  { 9,  8}, // #912
  {10, 15}, // #913
  {11, 16}, // #914
  {20,  2}, // #915
  { 1,  7}, // #916
  { 2, 26}, // #917
  { 3, 46}, // #918
  { 4, 71}, // #919
  { 5, 79}, // #920
  { 6, 27}, // #921
  { 7, 52}, // #922
  { 8, 32}, // #923
  { 9, 19}, // #924
  {10, 39}, // #925
  {11, 41}, // #926
  {15,  8}, // #927
  {16,  8}, // #928
  {20, 20}, // #929
  { 1,  7}, // #930
  { 2, 26}, // #931
  { 3, 46}, // #932
  { 4, 71}, // #933
  { 5, 79}, // #934
  { 6, 27}, // #935
  { 7, 52}, // #936
  { 8, 32}, // #937
  { 9, 19}, // #938
  {10, 39}, // #939
  {11, 41}, // #940
  {15,  7}, // #941
  {16,  7}, // #942
  {20, 20}, // #943
  { 1,  2}, // #944
  { 2,  9}, // #945
  { 3, 14}, // #946
  { 4, 24}, // #947
  { 5, 24}, // #948
  { 6,  7}, // #949
  { 7, 17}, // #950
  { 8, 12}, // #951
  { 9,  6}, // #952
  {10, 11}, // #953
  {11, 11}, // #954
  {15,  1}, // #955
  {19,  1}, // #956
  {20,  5}, // #957
  {23,  1}, // #958
  { 1,  2}, // #959
  { 2, 12}, // #960
  { 3, 17}, // #961
  { 4, 27}, // #962
  { 5, 32}, // #963
  { 6,  7}, // #964
  { 7, 17}, // #965
  { 8, 12}, // #966
  { 9, 10}, // #967
  {10, 15}, // #968
  {11, 15}, // #969
  {15, 40}, // #970
  {16,  2}, // #971
  {19, 38}, // #972
  {20,  5}, // #973
  {23, 38}, // #974
  { 1,  4}, // #975
  { 2,  4}, // #976
  { 3,  6}, // #977
  { 4, 57}, // #978
  { 5, 57}, // #979
  { 6,  5}, // #980
  { 7,  9}, // #981
  { 8,  8}, // #982
  {10,  1}, // #983
  {11,  1}, // #984
  {13, 33}, // #985
  {14, 33}, // #986
  {15, 33}, // #987
  {16, 33}, // #988
  {21,  2}, // #989
  { 1,  8}, // #990
  { 2, 35}, // #991
  { 3, 79}, // #992
  { 4, 142}, // #993
  { 5, 142}, // #994
  { 6, 37}, // #995
  { 7, 100}, // #996
  { 8, 71}, // #997
  { 9, 21}, // #998
  {10, 46}, // #999
  {11, 46}, // #1000
  {15,  1}, // #1001
  {19,  1}, // #1002
  {20, 10}, // #1003
  {23,  1}, // #1004
  { 1,  1}, // #1005
  { 2,  1}, // #1006
  { 3,  1}, // #1007
  { 4,  2}, // #1008
  { 5,  2}, // #1009
  { 6,  1}, // #1010
  { 7,  1}, // #1011
  { 8,  1}, // #1012
  { 2,  3}, // #1013
  { 3,  3}, // #1014
  { 4,  7}, // #1015
  { 5, 10}, // #1016
  { 7,  4}, // #1017
  { 8,  4}, // #1018
  { 9,  3}, // #1019
  {10,  3}, // #1020
  {11,  3}, // #1021
  { 2,  1}, // #1022
  { 3,  1}, // #1023
  { 4,  3}, // #1024
  { 5,  3}, // #1025
  { 7,  2}, // #1026
  { 8,  2}, // #1027
  { 9,  1}, // #1028
  {10,  1}, // #1029
  {11,  1}, // #1030
  { 3,  1}, // #1031
  { 4,  1}, // #1032
  { 5,  1}, // #1033
  { 6,  1}, // #1034
  { 7,  1}, // #1035
  {10,  1}, // #1036
  {11,  1}, // #1037
  {15,  1}, // #1038
  {19,  1}, // #1039
  {20,  1}, // #1040
  {23,  1}, // #1041
  { 5,  2}, // #1042
  {15,  1}, // #1043
  {19,  1}, // #1044
  {23,  1}, // #1045
  { 2,  1}, // #1046
  { 3,  1}, // #1047
  { 4,  2}, // #1048
  { 5,  2}, // #1049
  { 7,  1}, // #1050
  { 8,  1}, // #1051
  { 9,  1}, // #1052
  {10,  1}, // #1053
  {11,  1}, // #1054
  {15,  1}, // #1055
  {19,  1}, // #1056
  {23,  1}, // #1057
  { 1,  5}, // #1058
  { 2, 13}, // #1059
  { 3, 13}, // #1060
  { 4, 13}, // #1061
  { 5, 13}, // #1062
  { 6,  5}, // #1063
  { 7,  5}, // #1064
  { 8,  5}, // #1065
  { 9,  8}, // #1066
  {10,  8}, // #1067
  {11,  8}, // #1068
  {15, 21}, // #1069
  {16, 21}, // #1070
  { 4,  1}, // #1071
  { 5,  1}, // #1072
  { 7,  1}, // #1073
  { 8,  1}, // #1074
  {13,  1}, // #1075
  {14,  1}, // #1076
  {15,  1}, // #1077
  {16,  1}, // #1078
  {21,  1}, // #1079
  { 1,  1}, // #1080
  { 2,  1}, // #1081
  { 3,  1}, // #1082
  { 4,  1}, // #1083
  { 5,  1}, // #1084
  { 6,  1}, // #1085
  { 7,  1}, // #1086
  { 8,  1}, // #1087
  {14,  1}, // #1088
  {15,  1}, // #1089
  {18,  1}, // #1090
  {19,  1}, // #1091
  { 5,  5}, // #1092
  {15,  2}, // #1093
  {16,  2}, // #1094
  { 5,  2}, // #1095
  {15,  2}, // #1096
  {16,  1}, // #1097
  {19,  1}, // #1098
  {23,  1}, // #1099
  { 4,  2}, // #1100
  { 5,  2}, // #1101
  { 7,  1}, // #1102
  { 8,  1}, // #1103
  {13,  1}, // #1104
  {14,  2}, // #1105
  {15,  2}, // #1106
  {16,  1}, // #1107
  {18,  1}, // #1108
  {19,  1}, // #1109
  {21,  1}, // #1110
  { 4,  1}, // #1111
  { 5,  3}, // #1112
  { 7,  1}, // #1113
  { 8,  1}, // #1114
  {15,  2}, // #1115
  {16,  1}, // #1116
  {19,  1}, // #1117
  {23,  1}, // #1118
  { 3,  2}, // #1119
  { 4,  2}, // #1120
  { 5,  2}, // #1121
  { 6,  2}, // #1122
  { 7,  2}, // #1123
  {10,  2}, // #1124
  {11,  2}, // #1125
  {13,  1}, // #1126
  {14,  1}, // #1127
  {15,  1}, // #1128
  {16,  1}, // #1129
  {20,  2}, // #1130
  { 1,  1}, // #1131
  { 2,  1}, // #1132
  { 3,  1}, // #1133
  { 4,  1}, // #1134
  { 5,  1}, // #1135
  { 6,  1}, // #1136
  { 7,  1}, // #1137
  { 8,  1}, // #1138
  {13,  1}, // #1139
  {14,  1}, // #1140
  {15,  1}, // #1141
  {16,  1}, // #1142
  { 1,  1}, // #1143
  { 2,  1}, // #1144
  { 3,  2}, // #1145
  { 4,  2}, // #1146
  { 5,  2}, // #1147
  { 6,  2}, // #1148
  { 7,  2}, // #1149
  { 8,  1}, // #1150
  {10,  1}, // #1151
  {11,  1}, // #1152
  {13,  1}, // #1153
  {14,  1}, // #1154
  {15,  1}, // #1155
  {16,  1}, // #1156
  {20,  1}, // #1157
  { 2,  3}, // #1158
  { 3,  4}, // #1159
  { 4,  7}, // #1160
  { 5, 10}, // #1161
  { 7,  3}, // #1162
  { 8,  3}, // #1163
  { 9,  3}, // #1164
  {10,  3}, // #1165
  {11,  4}, // #1166
  { 4,  2}, // #1167
  { 5,  2}, // #1168
  { 7,  2}, // #1169
  { 8,  2}, // #1170
  {15,  1}, // #1171
  {16,  1}, // #1172
  { 2,  2}, // #1173
  { 3,  3}, // #1174
  { 4,  9}, // #1175
  { 5, 18}, // #1176
  { 6,  1}, // #1177
  { 7,  7}, // #1178
  { 8,  6}, // #1179
  { 9,  2}, // #1180
  {10,  3}, // #1181
  {11,  3}, // #1182
  {20,  1}, // #1183
  { 1,  2}, // #1184
  { 2,  9}, // #1185
  { 3, 14}, // #1186
  { 4, 21}, // #1187
  { 5, 24}, // #1188
  { 6,  4}, // #1189
  { 7, 11}, // #1190
  { 8,  7}, // #1191
  { 9,  7}, // #1192
  {10, 12}, // #1193
  {11, 12}, // #1194
  {15,  1}, // #1195
  {16,  1}, // #1196
  {20,  2}, // #1197
  { 2,  2}, // #1198
  { 3,  2}, // #1199
  { 4,  2}, // #1200
  { 5,  3}, // #1201
  { 9,  2}, // #1202
  {10,  2}, // #1203
  {11,  2}, // #1204
  {15,  2}, // #1205
  {19,  2}, // #1206
  {23,  2}, // #1207
  { 4,  1}, // #1208
  { 5,  1}, // #1209
  { 7,  1}, // #1210
  { 8,  1}, // #1211
  {15,  1}, // #1212
  {19,  1}, // #1213
  {23,  1}, // #1214
  { 2,  5}, // #1215
  { 3,  5}, // #1216
  { 4, 16}, // #1217
  { 5, 23}, // #1218
  { 7, 11}, // #1219
  { 8,  8}, // #1220
  { 9,  5}, // #1221
  {10,  5}, // #1222
  {11,  5}, // #1223
  { 3,  2}, // #1224
  { 4,  2}, // #1225
  { 5,  2}, // #1226
  { 6,  2}, // #1227
  { 7,  2}, // #1228
  {10,  2}, // #1229
  {11,  2}, // #1230
  {15,  1}, // #1231
  {16,  1}, // #1232
  {20,  2}, // #1233
  { 3,  2}, // #1234
  { 4,  2}, // #1235
  { 5,  2}, // #1236
  { 6,  2}, // #1237
  { 7,  2}, // #1238
  {10,  2}, // #1239
  {11,  2}, // #1240
  {20,  2}, // #1241
  { 1,  1}, // #1242
  { 2,  6}, // #1243
  { 3,  8}, // #1244
  { 4, 17}, // #1245
  { 5, 20}, // #1246
  { 6,  2}, // #1247
  { 7, 11}, // #1248
  { 8,  9}, // #1249
  { 9,  5}, // #1250
  {10,  7}, // #1251
  {11,  7}, // #1252
  {15,  2}, // #1253
  {16,  2}, // #1254
  {20,  1}, // #1255
  { 1,  1}, // #1256
  { 2,  4}, // #1257
  { 3,  5}, // #1258
  { 4, 10}, // #1259
  { 5, 10}, // #1260
  { 6,  2}, // #1261
  { 7,  7}, // #1262
  { 8,  6}, // #1263
  { 9,  3}, // #1264
  {10,  4}, // #1265
  {11,  4}, // #1266
  {15,  3}, // #1267
  {16,  3}, // #1268
  {20,  1}, // #1269
  { 2,  8}, // #1270
  { 3, 14}, // #1271
  { 4, 30}, // #1272
  { 5, 54}, // #1273
  { 6,  2}, // #1274
  { 7, 18}, // #1275
  { 8, 14}, // #1276
  { 9,  8}, // #1277
  {10, 10}, // #1278
  {11, 11}, // #1279
  {20,  2}, // #1280
  { 2,  2}, // #1281
  { 3,  2}, // #1282
  { 4,  7}, // #1283
  { 5,  9}, // #1284
  { 7,  5}, // #1285
  { 8,  5}, // #1286
  { 9,  2}, // #1287
  {10,  2}, // #1288
  {11,  2}, // #1289
  { 2,  3}, // #1290
  { 3,  4}, // #1291
  { 4, 10}, // #1292
  { 5, 15}, // #1293
  { 6,  1}, // #1294
  { 7,  7}, // #1295
  { 8,  6}, // #1296
  { 9,  3}, // #1297
  {10,  4}, // #1298
  {11,  4}, // #1299
  {20,  1}, // #1300
  { 2,  1}, // #1301
  { 3,  1}, // #1302
  { 4, 30}, // #1303
  { 5, 30}, // #1304
  { 7,  8}, // #1305
  { 8,  8}, // #1306
  { 9,  1}, // #1307
  {10,  1}, // #1308
  {11,  1}, // #1309
  {13,  1}, // #1310
  {14,  1}, // #1311
  {15,  1}, // #1312
  {16,  1}, // #1313
  {21,  8}, // #1314
  { 2, 35}, // #1315
  { 3, 90}, // #1316
  { 4, 134}, // #1317
  { 5, 134}, // #1318
  { 6, 34}, // #1319
  { 7, 78}, // #1320
  { 8, 44}, // #1321
  { 9, 21}, // #1322
  {10, 51}, // #1323
  {11, 51}, // #1324
  {15,  5}, // #1325
  {16,  4}, // #1326
  {19,  1}, // #1327
  {20,  9}, // #1328
  {23,  1}, // #1329
  { 2, 52}, // #1330
  { 3, 97}, // #1331
  { 4, 150}, // #1332
  { 5, 150}, // #1333
  { 6, 45}, // #1334
  { 7, 98}, // #1335
  { 8, 53}, // #1336
  { 9, 27}, // #1337
  {10, 37}, // #1338
  {11, 37}, // #1339
  {15,  5}, // #1340
  {16,  4}, // #1341
  {19,  1}, // #1342
  {20, 10}, // #1343
  {23,  1}, // #1344
  { 2,  1}, // #1345
  { 3,  4}, // #1346
  { 4, 15}, // #1347
  { 5, 15}, // #1348
  { 6,  2}, // #1349
  { 7,  5}, // #1350
  { 8,  3}, // #1351
  { 9,  1}, // #1352
  {10,  4}, // #1353
  {11,  4}, // #1354
  {13,  1}, // #1355
  {14,  2}, // #1356
  {15,  2}, // #1357
  {16,  1}, // #1358
  {18,  1}, // #1359
  {19,  1}, // #1360
  {20,  2}, // #1361
  {21,  3}, // #1362
  { 1,  2}, // #1363
  { 2,  2}, // #1364
  { 3,  7}, // #1365
  { 4, 56}, // #1366
  { 5, 56}, // #1367
  { 6,  7}, // #1368
  { 7, 17}, // #1369
  { 8, 12}, // #1370
  {13,  8}, // #1371
  {14,  8}, // #1372
  {15,  8}, // #1373
  {16,  8}, // #1374
  { 1,  4}, // #1375
  { 2,  4}, // #1376
  { 3,  6}, // #1377
  { 4, 57}, // #1378
  { 5, 57}, // #1379
  { 6,  5}, // #1380
  { 7, 11}, // #1381
  { 8, 10}, // #1382
  {10,  1}, // #1383
  {11,  1}, // #1384
  {13, 31}, // #1385
  {14, 31}, // #1386
  {15, 31}, // #1387
  {16, 31}, // #1388
  {21,  4}, // #1389
  { 1,  9}, // #1390
  { 2, 10}, // #1391
  { 3, 26}, // #1392
  { 4, 78}, // #1393
  { 5, 78}, // #1394
  { 6, 25}, // #1395
  { 7, 47}, // #1396
  { 8, 31}, // #1397
  { 9,  1}, // #1398
  {10, 17}, // #1399
  {11, 17}, // #1400
  {14, 11}, // #1401
  {15, 11}, // #1402
  {18, 11}, // #1403
  {19, 11}, // #1404
  {20, 16}, // #1405
  {21,  1}, // #1406
  { 1,  1}, // #1407
  { 2,  1}, // #1408
  { 3,  3}, // #1409
  { 4,  3}, // #1410
  { 5,  3}, // #1411
  { 6,  1}, // #1412
  { 7,  1}, // #1413
  { 8,  1}, // #1414
  {10,  1}, // #1415
  {11,  1}, // #1416
  {15,  2}, // #1417
  {16,  2}, // #1418
  { 1,  1}, // #1419
  { 2,  1}, // #1420
  { 3,  4}, // #1421
  { 4,  4}, // #1422
  { 5,  4}, // #1423
  { 6,  1}, // #1424
  { 7,  1}, // #1425
  { 8,  1}, // #1426
  {10,  2}, // #1427
  {11,  2}, // #1428
  {15,  4}, // #1429
  {16,  4}, // #1430
  { 1,  1}, // #1431
  { 2,  1}, // #1432
  { 3,  4}, // #1433
  { 4,  4}, // #1434
  { 5,  4}, // #1435
  { 6,  1}, // #1436
  { 7,  1}, // #1437
  { 8,  1}, // #1438
  {10,  2}, // #1439
  {11,  2}, // #1440
  {15,  8}, // #1441
  {16,  8}, // #1442
  { 4,  2}, // #1443
  { 5,  2}, // #1444
  { 7,  1}, // #1445
  { 8,  1}, // #1446
  {13,  1}, // #1447
  {14,  1}, // #1448
  {15,  1}, // #1449
  {16,  1}, // #1450
  {21,  1}, // #1451
  { 2,  1}, // #1452
  { 3,  1}, // #1453
  { 4,  3}, // #1454
  { 5,  3}, // #1455
  { 7,  2}, // #1456
  { 8,  2}, // #1457
  { 9,  1}, // #1458
  {10,  1}, // #1459
  {11,  1}, // #1460
  {15,  1}, // #1461
  {16,  1}, // #1462
  { 1,  2}, // #1463
  { 2,  2}, // #1464
  { 3,  2}, // #1465
  { 4,  2}, // #1466
  { 5,  2}, // #1467
  { 6,  2}, // #1468
  { 7,  2}, // #1469
  { 8,  2}, // #1470
  {15,  1}, // #1471
  {19,  1}, // #1472
  {23,  1}, // #1473
  { 2,  3}, // #1474
  { 3,  6}, // #1475
  { 4,  7}, // #1476
  { 5,  7}, // #1477
  { 6,  1}, // #1478
  { 7,  2}, // #1479
  { 8,  1}, // #1480
  {10,  1}, // #1481
  {11,  1}, // #1482
  {20,  1}, // #1483
  { 2,  3}, // #1484
  { 3,  6}, // #1485
  { 4,  7}, // #1486
  { 5,  7}, // #1487
  { 6,  1}, // #1488
  { 7,  2}, // #1489
  { 8,  1}, // #1490
  {10,  1}, // #1491
  {11,  1}, // #1492
  {15,  1}, // #1493
  {16,  1}, // #1494
  {20,  1}, // #1495
  { 2,  2}, // #1496
  { 3,  6}, // #1497
  { 4,  7}, // #1498
  { 5,  7}, // #1499
  { 7,  1}, // #1500
  { 8,  1}, // #1501
  {10,  2}, // #1502
  {11,  2}, // #1503
  { 2,  2}, // #1504
  { 3,  6}, // #1505
  { 4,  7}, // #1506
  { 5,  7}, // #1507
  { 7,  1}, // #1508
  { 8,  1}, // #1509
  {10,  2}, // #1510
  {11,  2}, // #1511
  {15,  1}, // #1512
  {16,  1}, // #1513
  { 2,  1}, // #1514
  { 3,  3}, // #1515
  { 4,  3}, // #1516
  { 5,  3}, // #1517
  {10,  1}, // #1518
  {11,  1}, // #1519
  { 2,  1}, // #1520
  { 3,  3}, // #1521
  { 4,  3}, // #1522
  { 5,  3}, // #1523
  {10,  1}, // #1524
  {11,  1}, // #1525
  {15,  1}, // #1526
  {16,  1}, // #1527
  { 4,  1}, // #1528
  { 5,  2}, // #1529
  { 7,  1}, // #1530
  { 8,  1}, // #1531
  {15,  1}, // #1532
  {16,  1}, // #1533
  { 4,  1}, // #1534
  { 5,  5}, // #1535
  { 7,  1}, // #1536
  { 8,  1}, // #1537
  {15,  2}, // #1538
  {16,  1}, // #1539
  {19,  1}, // #1540
  {23,  1}, // #1541
  { 1,  1}, // #1542
  { 2,  4}, // #1543
  { 3,  5}, // #1544
  { 4,  9}, // #1545
  { 5, 13}, // #1546
  { 6,  2}, // #1547
  { 7,  6}, // #1548
  { 8,  5}, // #1549
  { 9,  3}, // #1550
  {10,  4}, // #1551
  {11,  4}, // #1552
  {15,  2}, // #1553
  {16,  2}, // #1554
  {20,  1}, // #1555
  { 1,  1}, // #1556
  { 2,  1}, // #1557
  { 3,  3}, // #1558
  { 4,  3}, // #1559
  { 5,  3}, // #1560
  { 6,  3}, // #1561
  { 7,  3}, // #1562
  { 8,  1}, // #1563
  {10,  2}, // #1564
  {11,  2}, // #1565
  {20,  2}, // #1566
  { 2,  1}, // #1567
  { 3,  3}, // #1568
  { 4,  3}, // #1569
  { 5,  3}, // #1570
  {10,  2}, // #1571
  {11,  2}, // #1572
  { 1,  1}, // #1573
  { 2,  1}, // #1574
  { 3,  3}, // #1575
  { 4,  3}, // #1576
  { 5,  3}, // #1577
  { 6,  3}, // #1578
  { 7,  3}, // #1579
  { 8,  1}, // #1580
  {10,  2}, // #1581
  {11,  2}, // #1582
  {15,  1}, // #1583
  {16,  1}, // #1584
  {20,  2}, // #1585
  { 2,  1}, // #1586
  { 3,  3}, // #1587
  { 4,  3}, // #1588
  { 5,  3}, // #1589
  {10,  2}, // #1590
  {11,  2}, // #1591
  {15,  1}, // #1592
  {16,  1}, // #1593
  { 2, 52}, // #1594
  { 3, 125}, // #1595
  { 4, 178}, // #1596
  { 5, 178}, // #1597
  { 6, 41}, // #1598
  { 7, 94}, // #1599
  { 8, 53}, // #1600
  { 9, 29}, // #1601
  {10, 69}, // #1602
  {11, 69}, // #1603
  {15,  6}, // #1604
  {16,  4}, // #1605
  {19,  2}, // #1606
  {20,  8}, // #1607
  {23,  2}, // #1608
  { 4,  1}, // #1609
  { 5,  1}, // #1610
  {13,  1}, // #1611
  {14,  2}, // #1612
  {15,  2}, // #1613
  {16,  1}, // #1614
  {18,  1}, // #1615
  {19,  1}, // #1616
  { 2,  1}, // #1617
  { 3,  1}, // #1618
  { 4,  3}, // #1619
  { 5,  8}, // #1620
  { 7,  2}, // #1621
  { 8,  2}, // #1622
  { 9,  1}, // #1623
  {10,  1}, // #1624
  {11,  1}, // #1625
  {15,  1}, // #1626
  {16,  1}, // #1627
  { 2,  1}, // #1628
  { 3,  1}, // #1629
  { 4,  3}, // #1630
  { 5,  7}, // #1631
  { 7,  2}, // #1632
  { 8,  2}, // #1633
  { 9,  1}, // #1634
  {10,  1}, // #1635
  {11,  1}, // #1636
  {15,  2}, // #1637
  {16,  1}, // #1638
  {19,  1}, // #1639
  {23,  1}, // #1640
  { 4,  1}, // #1641
  { 5,  2}, // #1642
  { 7,  1}, // #1643
  { 8,  1}, // #1644
  {15,  1}, // #1645
  {19,  1}, // #1646
  {23,  1}, // #1647
  { 2,  1}, // #1648
  { 3,  4}, // #1649
  { 4, 10}, // #1650
  { 5, 10}, // #1651
  { 6,  3}, // #1652
  { 7,  9}, // #1653
  { 8,  6}, // #1654
  { 9,  1}, // #1655
  {10,  4}, // #1656
  {11,  4}, // #1657
  {20,  3}, // #1658
  { 1,  7}, // #1659
  { 2, 26}, // #1660
  { 3, 47}, // #1661
  { 4, 73}, // #1662
  { 5, 80}, // #1663
  { 6, 28}, // #1664
  { 7, 54}, // #1665
  { 8, 33}, // #1666
  { 9, 19}, // #1667
  {10, 40}, // #1668
  {11, 42}, // #1669
  {15,  7}, // #1670
  {16,  7}, // #1671
  {20, 21}, // #1672
  { 1,  7}, // #1673
  { 2, 27}, // #1674
  { 3, 47}, // #1675
  { 4, 73}, // #1676
  { 5, 80}, // #1677
  { 6, 27}, // #1678
  { 7, 53}, // #1679
  { 8, 33}, // #1680
  { 9, 19}, // #1681
  {10, 39}, // #1682
  {11, 42}, // #1683
  {15,  7}, // #1684
  {16,  7}, // #1685
  {20, 20}, // #1686
  { 1,  7}, // #1687
  { 2, 28}, // #1688
  { 3, 48}, // #1689
  { 4, 76}, // #1690
  { 5, 84}, // #1691
  { 6, 27}, // #1692
  { 7, 55}, // #1693
  { 8, 35}, // #1694
  { 9, 21}, // #1695
  {10, 41}, // #1696
  {11, 43}, // #1697
  {15, 10}, // #1698
  {16, 10}, // #1699
  {20, 20}, // #1700
  { 1,  7}, // #1701
  { 2, 28}, // #1702
  { 3, 49}, // #1703
  { 4, 77}, // #1704
  { 5, 88}, // #1705
  { 6, 28}, // #1706
  { 7, 56}, // #1707
  { 8, 35}, // #1708
  { 9, 21}, // #1709
  {10, 42}, // #1710
  {11, 44}, // #1711
  {15, 11}, // #1712
  {16, 11}, // #1713
  {20, 21}, // #1714
  { 1,  7}, // #1715
  { 2, 24}, // #1716
  { 3, 43}, // #1717
  { 4, 67}, // #1718
  { 5, 73}, // #1719
  { 6, 26}, // #1720
  { 7, 50}, // #1721
  { 8, 31}, // #1722
  { 9, 17}, // #1723
  {10, 36}, // #1724
  {11, 36}, // #1725
  {15,  9}, // #1726
  {16,  8}, // #1727
  {19,  1}, // #1728
  {20, 19}, // #1729
  {23,  1}, // #1730
  { 1,  7}, // #1731
  { 2, 24}, // #1732
  { 3, 46}, // #1733
  { 4, 74}, // #1734
  { 5, 79}, // #1735
  { 6, 28}, // #1736
  { 7, 56}, // #1737
  { 8, 34}, // #1738
  { 9, 17}, // #1739
  {10, 38}, // #1740
  {11, 38}, // #1741
  {15, 12}, // #1742
  {16, 11}, // #1743
  {19,  1}, // #1744
  {20, 21}, // #1745
  {23,  1}, // #1746
  { 1,  5}, // #1747
  { 2, 11}, // #1748
  { 3, 18}, // #1749
  { 4, 26}, // #1750
  { 5, 32}, // #1751
  { 6, 12}, // #1752
  { 7, 20}, // #1753
  { 8, 13}, // #1754
  { 9,  6}, // #1755
  {10, 13}, // #1756
  {11, 15}, // #1757
  {15,  5}, // #1758
  {19,  5}, // #1759
  {20,  7}, // #1760
  {23,  5}, // #1761
  { 4,  1}, // #1762
  { 5,  1}, // #1763
  { 7,  1}, // #1764
  { 8,  1}, // #1765
  {21,  1}, // #1766
  { 1,  8}, // #1767
  { 2, 22}, // #1768
  { 3, 23}, // #1769
  { 4, 25}, // #1770
  { 5, 25}, // #1771
  { 6,  9}, // #1772
  { 7, 11}, // #1773
  { 8, 10}, // #1774
  { 9, 14}, // #1775
  {10, 15}, // #1776
  {11, 15}, // #1777
  {15,  3}, // #1778
  {16,  3}, // #1779
  {20,  1}, // #1780
  { 1,  1}, // #1781
  { 2,  6}, // #1782
  { 3,  9}, // #1783
  { 4, 18}, // #1784
  { 5, 20}, // #1785
  { 6,  4}, // #1786
  { 7, 13}, // #1787
  { 8, 10}, // #1788
  { 9,  5}, // #1789
  {10,  6}, // #1790
  {11,  6}, // #1791
  {15,  3}, // #1792
  {16,  3}, // #1793
  {20,  1}, // #1794
  { 1,  1}, // #1795
  { 2,  4}, // #1796
  { 3,  4}, // #1797
  { 4,  8}, // #1798
  { 5, 10}, // #1799
  { 6,  1}, // #1800
  { 7,  5}, // #1801
  { 8,  5}, // #1802
  { 9,  3}, // #1803
  {10,  3}, // #1804
  {11,  3}, // #1805
  {15,  3}, // #1806
  {16,  2}, // #1807
  {19,  1}, // #1808
  {23,  1}, // #1809
  { 2,  3}, // #1810
  { 3,  4}, // #1811
  { 4,  9}, // #1812
  { 5, 10}, // #1813
  { 6,  1}, // #1814
  { 7,  6}, // #1815
  { 8,  5}, // #1816
  { 9,  3}, // #1817
  {10,  3}, // #1818
  {11,  3}, // #1819
  {15,  3}, // #1820
  {16,  2}, // #1821
  {19,  1}, // #1822
  {23,  1}, // #1823
  { 2,  3}, // #1824
  { 3,  3}, // #1825
  { 4,  8}, // #1826
  { 5,  8}, // #1827
  { 7,  5}, // #1828
  { 8,  5}, // #1829
  { 9,  3}, // #1830
  {10,  3}, // #1831
  {11,  3}, // #1832
  {15,  3}, // #1833
  {16,  2}, // #1834
  {19,  1}, // #1835
  {23,  1}, // #1836
  { 2,  3}, // #1837
  { 3,  3}, // #1838
  { 4,  7}, // #1839
  { 5,  8}, // #1840
  { 7,  4}, // #1841
  { 8,  4}, // #1842
  { 9,  3}, // #1843
  {10,  3}, // #1844
  {11,  3}, // #1845
  {15,  2}, // #1846
  {16,  1}, // #1847
  {19,  1}, // #1848
  {23,  1}, // #1849
  { 1,  1}, // #1850
  { 2,  4}, // #1851
  { 3, 12}, // #1852
  { 4, 20}, // #1853
  { 5, 22}, // #1854
  { 6,  8}, // #1855
  { 7, 16}, // #1856
  { 8,  9}, // #1857
  { 9,  3}, // #1858
  {10, 10}, // #1859
  {11, 10}, // #1860
  {15,  3}, // #1861
  {16,  1}, // #1862
  {19,  2}, // #1863
  {20,  7}, // #1864
  {23,  2}, // #1865
  { 2,  1}, // #1866
  { 3,  6}, // #1867
  { 4, 13}, // #1868
  { 5, 18}, // #1869
  { 6,  5}, // #1870
  { 7, 12}, // #1871
  { 8,  7}, // #1872
  { 9,  1}, // #1873
  {10,  6}, // #1874
  {11,  6}, // #1875
  {15,  2}, // #1876
  {19,  2}, // #1877
  {20,  5}, // #1878
  {23,  2}, // #1879
  { 2,  8}, // #1880
  { 3, 22}, // #1881
  { 4, 38}, // #1882
  { 5, 44}, // #1883
  { 6, 12}, // #1884
  { 7, 28}, // #1885
  { 8, 16}, // #1886
  { 9,  7}, // #1887
  {10, 19}, // #1888
  {11, 21}, // #1889
  {15,  2}, // #1890
  {19,  2}, // #1891
  {20, 12}, // #1892
  {23,  2}, // #1893
  { 3,  1}, // #1894
  { 4,  2}, // #1895
  { 5,  3}, // #1896
  { 6,  1}, // #1897
  { 7,  2}, // #1898
  { 8,  1}, // #1899
  {10,  1}, // #1900
  {11,  1}, // #1901
  {20,  1}, // #1902
  { 2,  4}, // #1903
  { 3, 10}, // #1904
  { 4, 18}, // #1905
  { 5, 24}, // #1906
  { 6,  3}, // #1907
  { 7, 11}, // #1908
  { 8,  8}, // #1909
  { 9,  4}, // #1910
  {10,  7}, // #1911
  {11,  9}, // #1912
  {20,  3}, // #1913
  { 1,  6}, // #1914
  { 2, 21}, // #1915
  { 3, 38}, // #1916
  { 4, 66}, // #1917
  { 5, 70}, // #1918
  { 6, 23}, // #1919
  { 7, 51}, // #1920
  { 8, 34}, // #1921
  { 9, 15}, // #1922
  {10, 31}, // #1923
  {11, 31}, // #1924
  {15,  8}, // #1925
  {16,  7}, // #1926
  {19,  1}, // #1927
  {20, 16}, // #1928
  {23,  1}, // #1929
  { 1,  6}, // #1930
  { 2, 21}, // #1931
  { 3, 37}, // #1932
  { 4, 64}, // #1933
  { 5, 70}, // #1934
  { 6, 22}, // #1935
  { 7, 49}, // #1936
  { 8, 33}, // #1937
  { 9, 15}, // #1938
  {10, 31}, // #1939
  {11, 31}, // #1940
  {15,  8}, // #1941
  {16,  7}, // #1942
  {19,  1}, // #1943
  {20, 16}, // #1944
  {23,  1}, // #1945
  { 1,  6}, // #1946
  { 2, 21}, // #1947
  { 3, 40}, // #1948
  { 4, 70}, // #1949
  { 5, 74}, // #1950
  { 6, 25}, // #1951
  { 7, 55}, // #1952
  { 8, 36}, // #1953
  { 9, 15}, // #1954
  {10, 33}, // #1955
  {11, 33}, // #1956
  {15, 10}, // #1957
  {16,  9}, // #1958
  {19,  1}, // #1959
  {20, 18}, // #1960
  {23,  1}, // #1961
  { 1,  6}, // #1962
  { 2, 21}, // #1963
  { 3, 39}, // #1964
  { 4, 68}, // #1965
  { 5, 74}, // #1966
  { 6, 24}, // #1967
  { 7, 53}, // #1968
  { 8, 35}, // #1969
  { 9, 15}, // #1970
  {10, 33}, // #1971
  {11, 33}, // #1972
  {15, 10}, // #1973
  {16,  9}, // #1974
  {19,  1}, // #1975
  {20, 18}, // #1976
  {23,  1}, // #1977
  { 1,  7}, // #1978
  { 2, 23}, // #1979
  { 3, 40}, // #1980
  { 4, 65}, // #1981
  { 5, 71}, // #1982
  { 6, 24}, // #1983
  { 7, 49}, // #1984
  { 8, 32}, // #1985
  { 9, 16}, // #1986
  {10, 33}, // #1987
  {11, 33}, // #1988
  {15,  8}, // #1989
  {16,  7}, // #1990
  {19,  1}, // #1991
  {20, 17}, // #1992
  {23,  1}, // #1993
  { 1,  7}, // #1994
  { 2, 23}, // #1995
  { 3, 43}, // #1996
  { 4, 71}, // #1997
  { 5, 77}, // #1998
  { 6, 27}, // #1999
  { 7, 55}, // #2000
  { 8, 35}, // #2001
  { 9, 16}, // #2002
  {10, 36}, // #2003
  {11, 36}, // #2004
  {15, 11}, // #2005
  {16, 10}, // #2006
  {19,  1}, // #2007
  {20, 20}, // #2008
  {23,  1}, // #2009
  { 4,  2}, // #2010
  { 5,  3}, // #2011
  { 7,  2}, // #2012
  { 8,  2}, // #2013
  {15,  1}, // #2014
  {16,  1}, // #2015
  {21,  2}, // #2016
  { 4,  2}, // #2017
  { 5,  3}, // #2018
  { 7,  2}, // #2019
  { 8,  2}, // #2020
  {21,  2}, // #2021
  { 4,  2}, // #2022
  { 5,  4}, // #2023
  { 7,  2}, // #2024
  { 8,  2}, // #2025
  {21,  2}, // #2026
  { 2,  2}, // #2027
  { 3,  2}, // #2028
  { 4,  7}, // #2029
  { 5,  8}, // #2030
  { 7,  5}, // #2031
  { 8,  5}, // #2032
  { 9,  2}, // #2033
  {10,  2}, // #2034
  {11,  2}, // #2035
  {15,  2}, // #2036
  {16,  1}, // #2037
  {19,  1}, // #2038
  {23,  1}, // #2039
  { 2,  3}, // #2040
  { 3,  3}, // #2041
  { 4,  7}, // #2042
  { 5,  9}, // #2043
  { 7,  4}, // #2044
  { 8,  4}, // #2045
  { 9,  3}, // #2046
  {10,  3}, // #2047
  {11,  3}, // #2048
  {15,  2}, // #2049
  {16,  1}, // #2050
  {19,  1}, // #2051
  {23,  1}, // #2052
  { 1,  2}, // #2053
  { 2,  9}, // #2054
  { 3, 16}, // #2055
  { 4, 24}, // #2056
  { 5, 24}, // #2057
  { 6,  6}, // #2058
  { 7, 14}, // #2059
  { 8,  7}, // #2060
  { 9,  7}, // #2061
  {10, 11}, // #2062
  {11, 11}, // #2063
  {15,  1}, // #2064
  {16,  1}, // #2065
  {20,  4}, // #2066
  { 2,  1}, // #2067
  { 3,  1}, // #2068
  { 4,  3}, // #2069
  { 5,  5}, // #2070
  { 7,  2}, // #2071
  { 8,  2}, // #2072
  { 9,  1}, // #2073
  {10,  1}, // #2074
  {11,  1}, // #2075
  {15,  1}, // #2076
  {19,  1}, // #2077
  {23,  1}, // #2078
  { 3,  1}, // #2079
  { 4,  1}, // #2080
  { 5,  2}, // #2081
  { 6,  1}, // #2082
  { 7,  1}, // #2083
  {10,  1}, // #2084
  {11,  1}, // #2085
  {20,  1}, // #2086
  { 2,  1}, // #2087
  { 3,  1}, // #2088
  { 4,  5}, // #2089
  { 5,  6}, // #2090
  { 7,  4}, // #2091
  { 8,  4}, // #2092
  { 9,  1}, // #2093
  {10,  1}, // #2094
  {11,  1}, // #2095
  { 1,  6}, // #2096
  { 2, 13}, // #2097
  { 3, 13}, // #2098
  { 4, 13}, // #2099
  { 5, 13}, // #2100
  { 6,  6}, // #2101
  { 7,  6}, // #2102
  { 8,  6}, // #2103
  { 9,  7}, // #2104
  {10,  7}, // #2105
  {11,  7}, // #2106
  {15, 18}, // #2107
  {16, 18}, // #2108
  { 1,  6}, // #2109
  { 2, 13}, // #2110
  { 3, 13}, // #2111
  { 4, 13}, // #2112
  { 5, 13}, // #2113
  { 6,  6}, // #2114
  { 7,  6}, // #2115
  { 8,  6}, // #2116
  { 9,  7}, // #2117
  {10,  7}, // #2118
  {11,  7}, // #2119
  {15, 17}, // #2120
  {16, 17}, // #2121
  { 1,  5}, // #2122
  { 2, 13}, // #2123
  { 3, 13}, // #2124
  { 4, 13}, // #2125
  { 5, 13}, // #2126
  { 6,  5}, // #2127
  { 7,  5}, // #2128
  { 8,  5}, // #2129
  { 9,  8}, // #2130
  {10,  8}, // #2131
  {11,  8}, // #2132
  {15, 20}, // #2133
  {16, 20}, // #2134
  { 1,  1}, // #2135
  { 2,  1}, // #2136
  { 3,  1}, // #2137
  { 4,  2}, // #2138
  { 5,  2}, // #2139
  { 6,  1}, // #2140
  { 7,  2}, // #2141
  { 8,  2}, // #2142
  {15,  1}, // #2143
  {16,  1}, // #2144
  { 2,  4}, // #2145
  { 3,  5}, // #2146
  { 4,  6}, // #2147
  { 5,  8}, // #2148
  { 6,  1}, // #2149
  { 7,  2}, // #2150
  { 8,  1}, // #2151
  { 9,  4}, // #2152
  {10,  5}, // #2153
  {11,  5}, // #2154
  {20,  1}, // #2155
  { 1,  1}, // #2156
  { 2, 43}, // #2157
  { 3, 91}, // #2158
  { 4, 143}, // #2159
  { 5, 143}, // #2160
  { 6, 49}, // #2161
  { 7, 101}, // #2162
  { 8, 53}, // #2163
  { 9, 23}, // #2164
  {10, 35}, // #2165
  {11, 35}, // #2166
  {15,  6}, // #2167
  {16,  4}, // #2168
  {19,  2}, // #2169
  {20, 12}, // #2170
  {23,  2}, // #2171
  { 1,  1}, // #2172
  { 2, 43}, // #2173
  { 3, 91}, // #2174
  { 4, 144}, // #2175
  { 5, 144}, // #2176
  { 6, 49}, // #2177
  { 7, 102}, // #2178
  { 8, 54}, // #2179
  { 9, 23}, // #2180
  {10, 35}, // #2181
  {11, 35}, // #2182
  {15,  6}, // #2183
  {16,  4}, // #2184
  {19,  2}, // #2185
  {20, 12}, // #2186
  {23,  2}, // #2187
  { 2, 52}, // #2188
  { 3, 97}, // #2189
  { 4, 149}, // #2190
  { 5, 149}, // #2191
  { 6, 45}, // #2192
  { 7, 97}, // #2193
  { 8, 52}, // #2194
  { 9, 27}, // #2195
  {10, 37}, // #2196
  {11, 37}, // #2197
  {15,  5}, // #2198
  {16,  4}, // #2199
  {19,  1}, // #2200
  {20, 10}, // #2201
  {23,  1}, // #2202
  { 2, 52}, // #2203
  { 3, 123}, // #2204
  { 4, 176}, // #2205
  { 5, 176}, // #2206
  { 6, 41}, // #2207
  { 7, 94}, // #2208
  { 8, 53}, // #2209
  { 9, 29}, // #2210
  {10, 68}, // #2211
  {11, 68}, // #2212
  {15,  6}, // #2213
  {16,  4}, // #2214
  {19,  2}, // #2215
  {20,  9}, // #2216
  {23,  2}, // #2217
  { 1,  1}, // #2218
  { 3,  2}, // #2219
  { 1,  1}, // #2220
  { 3,  1}, // #2221
  { 1,  6}, // #2222
  { 2,  6}, // #2223
  { 3, 12}, // #2224
  { 1,  5}, // #2225
  { 2,  5}, // #2226
  { 3, 10}, // #2227
  { 1, 16}, // #2228
  { 2, 16}, // #2229
  { 3, 32}, // #2230
  { 3, 15}, // #2231
  { 1, 10}, // #2232
  { 2, 10}, // #2233
  { 3, 20}, // #2234
  { 1,  9}, // #2235
  { 2,  9}, // #2236
  { 3, 18}, // #2237
  { 1,  5}, // #2238
  { 3,  5}, // #2239
  { 1,  7}, // #2240
  { 2,  7}, // #2241
  { 3, 14}, // #2242
  { 1,  8}, // #2243
  { 2,  8}, // #2244
  { 3, 16}, // #2245
  { 1, 12}, // #2246
  { 2, 12}, // #2247
  { 3, 24}, // #2248
  { 1, 11}, // #2249
  { 2, 11}, // #2250
  { 3, 22}, // #2251
  { 1, 50}, // #2252
  { 2, 50}, // #2253
  { 3, 100}, // #2254
  { 1, 130}, // #2255
  { 2, 130}, // #2256
  { 3, 260}, // #2257
  { 1, 68}, // #2258
  { 2, 68}, // #2259
  { 3, 136}, // #2260
  { 1, 125}, // #2261
  { 2, 125}, // #2262
  { 3, 250}, // #2263
  { 1, 70}, // #2264
  { 2, 70}, // #2265
  { 3, 140}, // #2266
  { 1, 34}, // #2267
  { 2, 34}, // #2268
  { 3, 68}, // #2269
  { 1, 62}, // #2270
  { 2, 62}, // #2271
  { 3, 124}, // #2272
  { 1,  2}, // #2273
  { 3,  2}, // #2274
  { 1, 14}, // #2275
  { 2, 14}, // #2276
  { 3, 28}, // #2277
  { 1,  3}, // #2278
  { 3,  3}, // #2279
  { 1,  4}, // #2280
  { 2,  4}, // #2281
  { 3,  8}, // #2282
  { 1,  3}, // #2283
  { 2,  3}, // #2284
  { 3,  6}, // #2285
  { 1,  2}, // #2286
  { 2,  2}, // #2287
  { 3,  4}, // #2288
  { 1,  4}, // #2289
  { 3,  4}, // #2290
  { 1, 71}, // #2291
  { 3, 71}, // #2292
  { 1, 15}, // #2293
  { 2, 15}, // #2294
  { 3, 30}, // #2295
  { 3, 21}, // #2296
  { 3, 25}, // #2297
  { 3, 29}, // #2298
  { 3, 45}, // #2299
  { 3, 55}, // #2300
  { 3, 59}, // #2301
  { 3, 63}, // #2302
  { 3, 72}, // #2303
  { 3, 74}, // #2304
  { 3, 77}, // #2305
  { 3, 78}, // #2306
  { 3, 92}, // #2307
  { 3, 94}, // #2308
  { 3, 99}, // #2309
  { 3, 121}, // #2310
  { 3, 127}, // #2311
  { 3, 130}, // #2312
  { 3, 141}, // #2313
  { 3, 146}, // #2314
  { 3, 147}, // #2315
  { 3, 168}, // #2316
  { 3, 174}, // #2317
  { 3, 183}, // #2318
  { 3, 202}, // #2319
  { 5,  2}, // #2320
  { 8,  2}, // #2321
  {11,  1}, // #2322
  {14,  1}, // #2323
  {20,  1}, // #2324
  { 2,  1}, // #2325
  { 5,  1}, // #2326
  { 7,  1}, // #2327
  { 8,  1}, // #2328
  { 1,  2}, // #2329
  { 5, 44}, // #2330
  { 7, 44}, // #2331
  { 8, 44}, // #2332
  {22,  1}, // #2333
  {24,  1}, // #2334
  { 1,  3}, // #2335
  { 2,  1}, // #2336
  { 5,  1}, // #2337
  { 7,  1}, // #2338
  { 8,  1}, // #2339
  {22,  3}, // #2340
  { 5,  1}, // #2341
  { 8,  1}, // #2342
  { 5,  6}, // #2343
  { 8,  6}, // #2344
  { 1,  1}, // #2345
  {13,  1}, // #2346
  {14,  3}, // #2347
  {20,  3}, // #2348
  {24,  1}, // #2349
  { 1,  3}, // #2350
  {10,  3}, // #2351
  {14,  1}, // #2352
  {19,  1}, // #2353
  {22,  3}, // #2354
  { 1,  1}, // #2355
  {13,  2}, // #2356
  {14, 36}, // #2357
  {20, 36}, // #2358
  {24,  1}, // #2359
  { 1,  4}, // #2360
  { 5,  2}, // #2361
  { 8,  2}, // #2362
  {22,  3}, // #2363
  {24,  1}, // #2364
  {10,  4}, // #2365
  {14,  1}, // #2366
  {16,  1}, // #2367
  {19,  1}, // #2368
  { 1,  3}, // #2369
  { 5,  2}, // #2370
  { 8,  2}, // #2371
  {22,  3}, // #2372
  { 1,  3}, // #2373
  {10,  1}, // #2374
  {14,  1}, // #2375
  {15,  1}, // #2376
  {19,  1}, // #2377
  {22,  3}, // #2378
  { 1,  3}, // #2379
  {12,  1}, // #2380
  {14,  1}, // #2381
  {15,  1}, // #2382
  {19,  1}, // #2383
  {22,  3}, // #2384
  { 1,  3}, // #2385
  {11,  1}, // #2386
  {14,  1}, // #2387
  {20,  1}, // #2388
  {22,  3}, // #2389
  { 1,  3}, // #2390
  {14,  1}, // #2391
  {16,  1}, // #2392
  {19,  1}, // #2393
  {21,  1}, // #2394
  {22,  3}, // #2395
  { 1,  3}, // #2396
  { 5,  6}, // #2397
  { 8,  6}, // #2398
  {22,  3}, // #2399
  { 1,  3}, // #2400
  { 5,  8}, // #2401
  { 8,  8}, // #2402
  {22,  3}, // #2403
  { 1,  2}, // #2404
  { 5,  7}, // #2405
  { 8,  7}, // #2406
  {22,  2}, // #2407
  { 1,  1}, // #2408
  { 5, 42}, // #2409
  { 8, 42}, // #2410
  {22,  1}, // #2411
  { 1,  1}, // #2412
  { 5, 44}, // #2413
  { 8, 44}, // #2414
  {22,  1}, // #2415
  { 1,  3}, // #2416
  { 5,  1}, // #2417
  { 8,  1}, // #2418
  {22,  3}, // #2419
  { 1,  2}, // #2420
  {22,  2}, // #2421
  { 5,  3}, // #2422
  { 7,  3}, // #2423
  { 8,  3}, // #2424
  { 1,  3}, // #2425
  { 5,  1}, // #2426
  { 6,  1}, // #2427
  { 8,  1}, // #2428
  {10,  1}, // #2429
  {14,  1}, // #2430
  {15,  1}, // #2431
  {19,  1}, // #2432
  {22,  3}, // #2433
  { 1,  3}, // #2434
  { 5,  4}, // #2435
  { 8,  4}, // #2436
  {22,  3}, // #2437
  { 1,  3}, // #2438
  { 9,  1}, // #2439
  {13,  1}, // #2440
  {14,  1}, // #2441
  {15,  1}, // #2442
  {19,  1}, // #2443
  {22,  3}, // #2444
  { 1,  3}, // #2445
  { 5,  1}, // #2446
  { 6,  1}, // #2447
  { 8,  1}, // #2448
  { 9,  1}, // #2449
  {10,  1}, // #2450
  {13,  1}, // #2451
  {14,  1}, // #2452
  {15,  1}, // #2453
  {19,  1}, // #2454
  {22,  3}, // #2455
  { 1,  3}, // #2456
  { 9,  2}, // #2457
  {13,  1}, // #2458
  {14,  1}, // #2459
  {15,  1}, // #2460
  {19,  1}, // #2461
  {22,  3}, // #2462
  { 1,  3}, // #2463
  { 4, 15}, // #2464
  { 5,  1}, // #2465
  { 7,  1}, // #2466
  { 8,  1}, // #2467
  {22,  3}, // #2468
  { 1,  3}, // #2469
  { 4, 14}, // #2470
  { 5,  1}, // #2471
  { 7,  1}, // #2472
  { 8,  1}, // #2473
  {22,  3}, // #2474
  { 1,  3}, // #2475
  { 4, 12}, // #2476
  { 5,  1}, // #2477
  { 7,  1}, // #2478
  { 8,  1}, // #2479
  {22,  3}, // #2480
  { 1,  3}, // #2481
  {10,  9}, // #2482
  {14,  1}, // #2483
  {16,  1}, // #2484
  {19,  1}, // #2485
  {22,  3}, // #2486
  { 1,  3}, // #2487
  {10, 10}, // #2488
  {14,  1}, // #2489
  {16,  1}, // #2490
  {19,  1}, // #2491
  {22,  3}, // #2492
  { 1,  3}, // #2493
  {10, 14}, // #2494
  {14,  1}, // #2495
  {16,  1}, // #2496
  {19,  1}, // #2497
  {22,  3}, // #2498
  { 1,  1}, // #2499
  {24,  1}, // #2500
  { 1,  1}, // #2501
  {13,  1}, // #2502
  {14,  2}, // #2503
  {16,  2}, // #2504
  {19,  2}, // #2505
  {24,  1}, // #2506
  { 5,  1}, // #2507
  { 6,  1}, // #2508
  { 8,  1}, // #2509
  {10,  3}, // #2510
  {14,  1}, // #2511
  {15,  1}, // #2512
  {19,  1}, // #2513
  {10,  1}, // #2514
  {14,  1}, // #2515
  {19,  1}, // #2516
  {13,  1}, // #2517
  {14,  1}, // #2518
  {16,  1}, // #2519
  {19,  1}, // #2520
  { 1,  3}, // #2521
  {10,  5}, // #2522
  {14,  1}, // #2523
  {15,  1}, // #2524
  {19,  1}, // #2525
  {22,  3}, // #2526
  { 1,  3}, // #2527
  { 4, 17}, // #2528
  { 5,  1}, // #2529
  { 7,  1}, // #2530
  { 8,  1}, // #2531
  {22,  3}, // #2532
  { 1,  3}, // #2533
  { 4, 25}, // #2534
  { 5,  1}, // #2535
  { 7,  1}, // #2536
  { 8,  1}, // #2537
  {22,  3}, // #2538
  { 1,  3}, // #2539
  { 5,  1}, // #2540
  { 7,  1}, // #2541
  { 8,  1}, // #2542
  {22,  3}, // #2543
  {23,  5}, // #2544
  { 5,  1}, // #2545
  { 7,  1}, // #2546
  { 8,  1}, // #2547
  {23,  5}, // #2548
  { 1,  3}, // #2549
  { 5,  1}, // #2550
  { 7,  1}, // #2551
  { 8,  1}, // #2552
  {22,  3}, // #2553
  {23,  2}, // #2554
  { 5,  1}, // #2555
  { 7,  1}, // #2556
  { 8,  1}, // #2557
  {23,  2}, // #2558
  { 1,  3}, // #2559
  { 5,  1}, // #2560
  { 7,  1}, // #2561
  { 8,  1}, // #2562
  {22,  3}, // #2563
  {23,  4}, // #2564
  { 5,  1}, // #2565
  { 7,  1}, // #2566
  { 8,  1}, // #2567
  {23,  4}, // #2568
  { 1,  3}, // #2569
  { 5,  1}, // #2570
  { 7,  1}, // #2571
  { 8,  1}, // #2572
  {22,  3}, // #2573
  {23,  6}, // #2574
  { 5,  1}, // #2575
  { 7,  1}, // #2576
  { 8,  1}, // #2577
  {23,  6}, // #2578
  { 1,  3}, // #2579
  {10,  2}, // #2580
  {14,  1}, // #2581
  {19,  1}, // #2582
  {22,  3}, // #2583
  { 1,  3}, // #2584
  {11,  3}, // #2585
  {14,  1}, // #2586
  {19,  1}, // #2587
  {22,  3}, // #2588
  { 1,  1}, // #2589
  {22,  1}, // #2590
  { 1,  3}, // #2591
  { 5,  2}, // #2592
  { 6,  2}, // #2593
  { 8,  2}, // #2594
  {22,  3}, // #2595
  {11,  2}, // #2596
  {14,  1}, // #2597
  {19,  1}, // #2598
  { 1,  1}, // #2599
  {13,  1}, // #2600
  {14,  1}, // #2601
  {16,  1}, // #2602
  {19,  1}, // #2603
  {24,  1}, // #2604
  {11,  1}, // #2605
  {14,  1}, // #2606
  {19,  1}, // #2607
  { 1,  3}, // #2608
  {11,  4}, // #2609
  {14,  1}, // #2610
  {19,  1}, // #2611
  {22,  3}, // #2612
  { 1,  3}, // #2613
  {11,  2}, // #2614
  {14,  1}, // #2615
  {19,  1}, // #2616
  {22,  3}, // #2617
  { 1,  3}, // #2618
  {12,  4}, // #2619
  {14,  1}, // #2620
  {15,  1}, // #2621
  {19,  1}, // #2622
  {22,  3}, // #2623
  { 1,  3}, // #2624
  {10,  1}, // #2625
  {14,  1}, // #2626
  {16,  1}, // #2627
  {19,  1}, // #2628
  {22,  3}, // #2629
  { 1,  3}, // #2630
  {12,  7}, // #2631
  {14,  1}, // #2632
  {15,  1}, // #2633
  {19,  1}, // #2634
  {22,  3}, // #2635
  { 1, 23}, // #2636
  { 5,  1}, // #2637
  { 6,  1}, // #2638
  { 8,  1}, // #2639
  {10,  1}, // #2640
  {11, 10}, // #2641
  {14,  1}, // #2642
  {16,  1}, // #2643
  {19,  1}, // #2644
  {22, 13}, // #2645
  {24, 10}, // #2646
  { 1, 20}, // #2647
  { 5,  1}, // #2648
  { 6,  1}, // #2649
  { 8,  1}, // #2650
  {10,  1}, // #2651
  {11, 10}, // #2652
  {14,  1}, // #2653
  {16,  1}, // #2654
  {19,  1}, // #2655
  {22, 10}, // #2656
  {24, 10}, // #2657
  { 1,  3}, // #2658
  { 5,  1}, // #2659
  { 6,  1}, // #2660
  { 8,  1}, // #2661
  {10,  6}, // #2662
  {14,  1}, // #2663
  {16,  1}, // #2664
  {19,  1}, // #2665
  {22,  3}, // #2666
  { 1,  3}, // #2667
  { 5,  1}, // #2668
  { 6,  1}, // #2669
  { 8,  1}, // #2670
  {10,  8}, // #2671
  {14,  1}, // #2672
  {16,  1}, // #2673
  {19,  1}, // #2674
  {22,  3}, // #2675
  { 1,  3}, // #2676
  {11,  1}, // #2677
  {14,  1}, // #2678
  {15,  1}, // #2679
  {19,  1}, // #2680
  {22,  3}, // #2681
  { 1,  3}, // #2682
  {11,  1}, // #2683
  {12,  2}, // #2684
  {14,  3}, // #2685
  {15,  2}, // #2686
  {19,  3}, // #2687
  {22,  3}, // #2688
  { 1,  3}, // #2689
  {22,  2}, // #2690
  {24,  1}, // #2691
  { 1,  4}, // #2692
  { 5,  1}, // #2693
  { 8,  1}, // #2694
  {22,  3}, // #2695
  {24,  1}, // #2696
  { 1,  3}, // #2697
  {13,  1}, // #2698
  {14,  1}, // #2699
  {16,  1}, // #2700
  {19,  1}, // #2701
  {22,  3}, // #2702
  { 1,  3}, // #2703
  {10,  2}, // #2704
  {14,  1}, // #2705
  {16,  1}, // #2706
  {19,  1}, // #2707
  {22,  3}, // #2708
  { 1,  1}, // #2709
  { 5,  1}, // #2710
  { 8,  1}, // #2711
  {24,  1}, // #2712
  { 1,  1}, // #2713
  { 5, 22}, // #2714
  { 8, 22}, // #2715
  {22,  1}, // #2716
  {10, 18}, // #2717
  {14,  1}, // #2718
  {16,  1}, // #2719
  {19,  1}, // #2720
  { 1, 18}, // #2721
  {24, 18}, // #2722
  { 1,  3}, // #2723
  {10,  3}, // #2724
  {14,  1}, // #2725
  {22,  3}, // #2726
  { 1,  3}, // #2727
  {10,  2}, // #2728
  {14,  1}, // #2729
  {15,  1}, // #2730
  {19,  1}, // #2731
  {22,  3}, // #2732
  { 1,  3}, // #2733
  {14,  2}, // #2734
  {16,  2}, // #2735
  {19,  2}, // #2736
  {21,  2}, // #2737
  {22,  3}, // #2738
  { 1,  3}, // #2739
  {11,  2}, // #2740
  {14,  2}, // #2741
  {20,  2}, // #2742
  {22,  3}, // #2743
  { 1,  3}, // #2744
  {11,  1}, // #2745
  {14,  1}, // #2746
  {19,  1}, // #2747
  {22,  3}, // #2748
  { 1,  3}, // #2749
  { 9,  2}, // #2750
  {10,  1}, // #2751
  {13,  1}, // #2752
  {14,  1}, // #2753
  {15,  1}, // #2754
  {19,  1}, // #2755
  {22,  3}, // #2756
  { 1,  1}, // #2757
  { 9,  2}, // #2758
  {10,  1}, // #2759
  {13,  1}, // #2760
  {14,  1}, // #2761
  {15,  1}, // #2762
  {19,  1}, // #2763
  {24,  1}, // #2764
  { 1,  1}, // #2765
  { 9,  2}, // #2766
  {13,  1}, // #2767
  {14,  1}, // #2768
  {15,  1}, // #2769
  {19,  1}, // #2770
  {24,  1}, // #2771
  { 1,  3}, // #2772
  {10, 18}, // #2773
  {14,  2}, // #2774
  {16,  2}, // #2775
  {19,  2}, // #2776
  {22,  3}, // #2777
  { 1,  3}, // #2778
  {10, 25}, // #2779
  {14,  2}, // #2780
  {16,  2}, // #2781
  {19,  2}, // #2782
  {22,  3}, // #2783
  { 1,  3}, // #2784
  {13,  1}, // #2785
  {14,  2}, // #2786
  {16,  2}, // #2787
  {19,  2}, // #2788
  {22,  3}, // #2789
  { 1,  3}, // #2790
  {10,  8}, // #2791
  {14,  1}, // #2792
  {15,  1}, // #2793
  {19,  1}, // #2794
  {22,  3}, // #2795
  { 1,  3}, // #2796
  {11,  3}, // #2797
  {14,  2}, // #2798
  {19,  2}, // #2799
  {22,  3}, // #2800
  { 1,  2}, // #2801
  {10, 376}, // #2802
  {14,  2}, // #2803
  {19,  2}, // #2804
  {24,  2}, // #2805
  { 1,  3}, // #2806
  {10,  4}, // #2807
  {14,  2}, // #2808
  {19,  2}, // #2809
  {22,  3}, // #2810
  { 1,  1}, // #2811
  {10, 188}, // #2812
  {14,  1}, // #2813
  {19,  1}, // #2814
  {24,  1}, // #2815
  { 1,  3}, // #2816
  {10,  4}, // #2817
  {14,  1}, // #2818
  {19,  1}, // #2819
  {22,  3}, // #2820
  {10,  2}, // #2821
  {14,  2}, // #2822
  {19,  2}, // #2823
  { 1,  2}, // #2824
  {13,  2}, // #2825
  {14, 36}, // #2826
  {20, 36}, // #2827
  {24,  2}, // #2828
  {11,  2}, // #2829
  {14,  2}, // #2830
  {19,  2}, // #2831
  { 1,  3}, // #2832
  {11,  4}, // #2833
  {14,  2}, // #2834
  {19,  2}, // #2835
  {22,  3}, // #2836
  { 1,  2}, // #2837
  {13,  2}, // #2838
  {14,  2}, // #2839
  {16,  2}, // #2840
  {19,  2}, // #2841
  {24,  2}, // #2842
  { 1,  3}, // #2843
  { 5,  1}, // #2844
  { 6,  1}, // #2845
  { 8,  1}, // #2846
  {10,  4}, // #2847
  {14,  2}, // #2848
  {19,  2}, // #2849
  {22,  3}, // #2850
  { 1,  3}, // #2851
  {10,  1}, // #2852
  {14,  2}, // #2853
  {16,  2}, // #2854
  {19,  2}, // #2855
  {22,  3}, // #2856
  { 1,  3}, // #2857
  {10,  2}, // #2858
  {14,  2}, // #2859
  {16,  2}, // #2860
  {19,  2}, // #2861
  {22,  3}, // #2862
  { 1,  3}, // #2863
  { 5,  1}, // #2864
  { 6,  1}, // #2865
  { 8,  1}, // #2866
  {10,  4}, // #2867
  {14,  4}, // #2868
  {19,  4}, // #2869
  {22,  3}, // #2870
  { 9,  3}, // #2871
  {13,  1}, // #2872
  {14,  1}, // #2873
  {15,  1}, // #2874
  {19,  1}, // #2875
  { 5, 23}, // #2876
  { 7, 23}, // #2877
  { 8, 23}, // #2878
  { 5, 21}, // #2879
  { 7, 21}, // #2880
  { 8, 21}, // #2881
  { 5, 26}, // #2882
  { 7, 26}, // #2883
  { 8, 26}, // #2884
  { 5, 69}, // #2885
  { 7, 69}, // #2886
  { 8, 69}, // #2887
  { 5, 14}, // #2888
  { 8, 14}, // #2889
  { 5, 25}, // #2890
  { 8, 25}, // #2891
  { 1,  1}, // #2892
  {10,  4}, // #2893
  {14,  2}, // #2894
  {19,  2}, // #2895
  {22,  1}, // #2896
  { 5, 20}, // #2897
  { 7, 20}, // #2898
  { 8, 20}, // #2899
  { 1,  3}, // #2900
  {10, 10}, // #2901
  {14,  1}, // #2902
  {15,  1}, // #2903
  {19,  1}, // #2904
  {22,  3}, // #2905
  { 1,  3}, // #2906
  {10, 18}, // #2907
  {14,  1}, // #2908
  {15,  1}, // #2909
  {19,  1}, // #2910
  {22,  3}, // #2911
  { 5, 375}, // #2912
  { 8, 375}, // #2913
  { 5, 24}, // #2914
  { 8, 24}, // #2915
  {10,  6}, // #2916
  {14,  1}, // #2917
  {19,  1}, // #2918
  {10,  8}, // #2919
  {14,  1}, // #2920
  {19,  1}, // #2921
  { 5,  3}, // #2922
  { 8,  3}, // #2923
  { 5, 18}, // #2924
  { 8, 18}, // #2925
  { 5, 88}, // #2926
  { 8, 88}, // #2927
  { 1,  3}, // #2928
  { 5,  3}, // #2929
  { 8,  3}, // #2930
  {22,  3}, // #2931
  { 5, 10}, // #2932
  { 8, 10}, // #2933
  { 5, 12}, // #2934
  { 8, 12}, // #2935
  { 5, 17}, // #2936
  { 8, 17}, // #2937
  { 5,  5}, // #2938
  { 8,  5}, // #2939
  { 5, 23}, // #2940
  { 8, 23}, // #2941
  { 5, 20}, // #2942
  { 8, 20}, // #2943
  { 5, 19}, // #2944
  { 8, 19}, // #2945
  { 5, 13}, // #2946
  { 8, 13}, // #2947
  { 5, 21}, // #2948
  { 8, 21}, // #2949
  { 5, 15}, // #2950
  { 8, 15}, // #2951
  {13,  1}, // #2952
  {14, 10}, // #2953
  {16, 10}, // #2954
  {19, 10}, // #2955
  {13,  1}, // #2956
  {14,  3}, // #2957
  {16,  3}, // #2958
  {19,  3}, // #2959
  {13,  1}, // #2960
  {14,  4}, // #2961
  {16,  4}, // #2962
  {19,  4}, // #2963
  {11,  1}, // #2964
  {12,  1}, // #2965
  {14,  1}, // #2966
  {15,  1}, // #2967
  {19,  1}, // #2968
  {22,  1}, // #2969
  {23,  1}, // #2970
  {14,  1}, // #2971
  {20,  1}, // #2972
  {22,  1}, // #2973
  {23,  1}, // #2974
  { 7,  1}, // #2975
  {12,  1}, // #2976
  {14,  2}, // #2977
  {17,  1}, // #2978
  {20,  2}, // #2979
  {21,  2}, // #2980
  {22,  3}, // #2981
  {23,  6}, // #2982
  {14,  1}, // #2983
  {17,  1}, // #2984
  {20,  1}, // #2985
  {21,  1}, // #2986
  {22,  1}, // #2987
  {23,  2}, // #2988
  { 4,  1}, // #2989
  {11,  1}, // #2990
  {15,  1}, // #2991
  {16,  1}, // #2992
  {19,  1}, // #2993
  {22,  1}, // #2994
  {23,  1}, // #2995
  { 7,  1}, // #2996
  {12,  1}, // #2997
  {21,  1}, // #2998
  {23,  2}, // #2999
  {17,  1}, // #3000
  {21,  1}, // #3001
  {23,  1}, // #3002
  { 7,  1}, // #3003
  {12,  1}, // #3004
  {17,  1}, // #3005
  {21,  2}, // #3006
  {22,  1}, // #3007
  {23,  4}, // #3008
  { 8,  1}, // #3009
  {13,  1}, // #3010
  {15,  1}, // #3011
  {18,  1}, // #3012
  {19,  1}, // #3013
  {20,  1}, // #3014
  {22,  1}, // #3015
  {23,  1}, // #3016
  {17,  1}, // #3017
  {21,  1}, // #3018
  {22,  1}, // #3019
  {23,  2}, // #3020
  { 4,  1}, // #3021
  {11,  1}, // #3022
  {15,  1}, // #3023
  {16,  1}, // #3024
  {17,  1}, // #3025
  {19,  1}, // #3026
  {21,  1}, // #3027
  {22,  1}, // #3028
  {23,  2}, // #3029
  { 8,  1}, // #3030
  {13,  1}, // #3031
  {15,  1}, // #3032
  {17,  1}, // #3033
  {18,  1}, // #3034
  {19,  1}, // #3035
  {20,  1}, // #3036
  {21,  1}, // #3037
  {22,  1}, // #3038
  {23,  2}, // #3039
  { 8,  2}, // #3040
  {13,  2}, // #3041
  {15,  2}, // #3042
  {17,  1}, // #3043
  {18,  2}, // #3044
  {19,  2}, // #3045
  {20,  2}, // #3046
  {21,  1}, // #3047
  {22,  2}, // #3048
  {23,  3}, // #3049
  { 8,  2}, // #3050
  {13,  2}, // #3051
  {15,  2}, // #3052
  {18,  2}, // #3053
  {19,  2}, // #3054
  {20,  2}, // #3055
  {22,  2}, // #3056
  {23,  2}, // #3057
  { 3,  2}, // #3058
  { 8,  7}, // #3059
  {11,  2}, // #3060
  {12,  2}, // #3061
  {13,  9}, // #3062
  {14,  2}, // #3063
  {15,  7}, // #3064
  {17,  1}, // #3065
  {18,  7}, // #3066
  {19, 10}, // #3067
  {20,  9}, // #3068
  {21,  1}, // #3069
  {22, 10}, // #3070
  {23, 11}, // #3071
  { 3,  2}, // #3072
  { 8,  7}, // #3073
  {11,  2}, // #3074
  {12,  2}, // #3075
  {13,  9}, // #3076
  {14,  2}, // #3077
  {15,  7}, // #3078
  {18,  7}, // #3079
  {19, 11}, // #3080
  {20,  9}, // #3081
  {22, 11}, // #3082
  {23, 11}, // #3083
  {14,  1}, // #3084
  {15,  1}, // #3085
  {17,  1}, // #3086
  {19,  1}, // #3087
  {20,  1}, // #3088
  {21,  1}, // #3089
  {22,  2}, // #3090
  {23,  3}, // #3091
  {14,  1}, // #3092
  {15,  1}, // #3093
  {19,  1}, // #3094
  {20,  1}, // #3095
  {22,  2}, // #3096
  {23,  2}, // #3097
  {15,  1}, // #3098
  {17,  1}, // #3099
  {19,  1}, // #3100
  {21,  1}, // #3101
  {22,  1}, // #3102
  {23,  2}, // #3103
  { 7,  1}, // #3104
  {12,  1}, // #3105
  {14,  1}, // #3106
  {17,  1}, // #3107
  {20,  1}, // #3108
  {21,  2}, // #3109
  {22,  1}, // #3110
  {23,  4}, // #3111
  {22,  3}, // #3112
  {23,  3}, // #3113
  {14,  2}, // #3114
  {20,  2}, // #3115
  {22,  5}, // #3116
  {23,  5}, // #3117
  { 4,  1}, // #3118
  { 8,  1}, // #3119
  {11,  1}, // #3120
  {13,  1}, // #3121
  {15,  2}, // #3122
  {16,  1}, // #3123
  {17,  1}, // #3124
  {18,  1}, // #3125
  {19,  2}, // #3126
  {20,  1}, // #3127
  {21,  1}, // #3128
  {22,  2}, // #3129
  {23,  3}, // #3130
  { 4,  1}, // #3131
  { 8,  1}, // #3132
  {11,  1}, // #3133
  {13,  1}, // #3134
  {15,  2}, // #3135
  {16,  1}, // #3136
  {18,  1}, // #3137
  {19,  2}, // #3138
  {20,  1}, // #3139
  {22,  2}, // #3140
  {23,  2}, // #3141
  { 3,  1}, // #3142
  {11,  1}, // #3143
  {12,  1}, // #3144
  {13,  1}, // #3145
  {14,  1}, // #3146
  {17,  1}, // #3147
  {19,  1}, // #3148
  {20,  1}, // #3149
  {21,  1}, // #3150
  {22,  1}, // #3151
  {23,  2}, // #3152
  { 3,  1}, // #3153
  { 8,  1}, // #3154
  {11,  1}, // #3155
  {12,  1}, // #3156
  {13,  2}, // #3157
  {14,  1}, // #3158
  {15,  1}, // #3159
  {18,  1}, // #3160
  {19,  2}, // #3161
  {20,  2}, // #3162
  {22,  2}, // #3163
  {23,  2}, // #3164
  { 3,  1}, // #3165
  { 4,  1}, // #3166
  {11,  2}, // #3167
  {12,  1}, // #3168
  {13,  1}, // #3169
  {14,  1}, // #3170
  {15,  1}, // #3171
  {16,  1}, // #3172
  {17,  1}, // #3173
  {19,  2}, // #3174
  {20,  1}, // #3175
  {21,  1}, // #3176
  {22,  2}, // #3177
  {23,  3}, // #3178
  { 3,  1}, // #3179
  { 4,  1}, // #3180
  {11,  2}, // #3181
  {12,  1}, // #3182
  {13,  1}, // #3183
  {14,  1}, // #3184
  {15,  1}, // #3185
  {16,  1}, // #3186
  {19,  2}, // #3187
  {20,  1}, // #3188
  {22,  2}, // #3189
  {23,  2}, // #3190
  { 3,  2}, // #3191
  { 4,  2}, // #3192
  { 8,  2}, // #3193
  {11,  4}, // #3194
  {12,  2}, // #3195
  {13,  4}, // #3196
  {14,  2}, // #3197
  {15,  4}, // #3198
  {16,  2}, // #3199
  {17,  1}, // #3200
  {18,  2}, // #3201
  {19,  6}, // #3202
  {20,  4}, // #3203
  {21,  1}, // #3204
  {22,  7}, // #3205
  {23,  8}, // #3206
  { 3,  7}, // #3207
  { 4,  7}, // #3208
  { 8,  3}, // #3209
  { 9,  3}, // #3210
  {11, 15}, // #3211
  {12,  7}, // #3212
  {13, 10}, // #3213
  {14, 10}, // #3214
  {15, 10}, // #3215
  {16, 10}, // #3216
  {18,  6}, // #3217
  {19, 18}, // #3218
  {20, 13}, // #3219
  {22, 32}, // #3220
  {23, 32}, // #3221
  { 1, 10}, // #3222
  { 3,  1}, // #3223
  {11,  1}, // #3224
  {12,  1}, // #3225
  {13,  1}, // #3226
  {14,  1}, // #3227
  {19,  1}, // #3228
  {20,  1}, // #3229
  {22,  1}, // #3230
  {23,  1}, // #3231
  { 2,  8}, // #3232
  { 3,  1}, // #3233
  {11,  1}, // #3234
  {12,  1}, // #3235
  {13,  1}, // #3236
  {14,  1}, // #3237
  {17,  1}, // #3238
  {19,  1}, // #3239
  {20,  1}, // #3240
  {21,  1}, // #3241
  {22,  1}, // #3242
  {23,  2}, // #3243
  { 2,  8}, // #3244
  { 3,  1}, // #3245
  {11,  1}, // #3246
  {12,  1}, // #3247
  {13,  1}, // #3248
  {14,  1}, // #3249
  {19,  1}, // #3250
  {20,  1}, // #3251
  {22,  1}, // #3252
  {23,  1}, // #3253
  { 2,  5}, // #3254
  { 3,  1}, // #3255
  {11,  1}, // #3256
  {12,  1}, // #3257
  {13,  1}, // #3258
  {14,  1}, // #3259
  {17,  1}, // #3260
  {19,  1}, // #3261
  {20,  1}, // #3262
  {21,  1}, // #3263
  {22,  1}, // #3264
  {23,  2}, // #3265
  { 2,  5}, // #3266
  { 3,  1}, // #3267
  {11,  1}, // #3268
  {12,  1}, // #3269
  {13,  1}, // #3270
  {14,  1}, // #3271
  {19,  1}, // #3272
  {20,  1}, // #3273
  {22,  1}, // #3274
  {23,  1}, // #3275
  { 2,  3}, // #3276
  { 3,  1}, // #3277
  {11,  1}, // #3278
  {12,  1}, // #3279
  {13,  1}, // #3280
  {14,  1}, // #3281
  {19,  1}, // #3282
  {20,  1}, // #3283
  {22,  1}, // #3284
  {23,  1}, // #3285
  { 2,  4}, // #3286
  { 3,  1}, // #3287
  {11,  1}, // #3288
  {12,  1}, // #3289
  {13,  1}, // #3290
  {14,  1}, // #3291
  {19,  1}, // #3292
  {20,  1}, // #3293
  {22,  1}, // #3294
  {23,  1}, // #3295
  { 3,  1}, // #3296
  { 4,  1}, // #3297
  { 8,  1}, // #3298
  {11,  2}, // #3299
  {12,  1}, // #3300
  {13,  2}, // #3301
  {14,  1}, // #3302
  {15,  2}, // #3303
  {16,  1}, // #3304
  {17,  1}, // #3305
  {18,  1}, // #3306
  {19,  3}, // #3307
  {20,  2}, // #3308
  {21,  1}, // #3309
  {22,  3}, // #3310
  {23,  4}, // #3311
  { 3,  1}, // #3312
  { 4,  1}, // #3313
  { 8,  1}, // #3314
  {11,  2}, // #3315
  {12,  1}, // #3316
  {13,  2}, // #3317
  {14,  1}, // #3318
  {15,  2}, // #3319
  {16,  1}, // #3320
  {18,  1}, // #3321
  {19,  3}, // #3322
  {20,  2}, // #3323
  {22,  3}, // #3324
  {23,  3}, // #3325
  { 3,  2}, // #3326
  { 4,  1}, // #3327
  { 8,  1}, // #3328
  {11,  3}, // #3329
  {12,  2}, // #3330
  {13,  3}, // #3331
  {14,  2}, // #3332
  {15,  2}, // #3333
  {16,  1}, // #3334
  {17,  1}, // #3335
  {18,  1}, // #3336
  {19,  4}, // #3337
  {20,  3}, // #3338
  {21,  1}, // #3339
  {22,  4}, // #3340
  {23,  5}, // #3341
  { 3,  2}, // #3342
  { 4,  1}, // #3343
  { 8,  1}, // #3344
  {11,  3}, // #3345
  {12,  2}, // #3346
  {13,  3}, // #3347
  {14,  2}, // #3348
  {15,  2}, // #3349
  {16,  1}, // #3350
  {18,  1}, // #3351
  {19,  4}, // #3352
  {20,  3}, // #3353
  {22,  4}, // #3354
  {23,  4}, // #3355
  { 7,  1}, // #3356
  { 8,  1}, // #3357
  {12,  1}, // #3358
  {13,  1}, // #3359
  {15,  1}, // #3360
  {18,  1}, // #3361
  {19,  1}, // #3362
  {20,  1}, // #3363
  {21,  1}, // #3364
  {22,  1}, // #3365
  {23,  3}, // #3366
  {11,  8}, // #3367
  {15,  1}, // #3368
  {19, 30}, // #3369
  {22, 31}, // #3370
  {23, 31}, // #3371
  {11,  2}, // #3372
  {19,  2}, // #3373
  {22,  2}, // #3374
  {23,  2}, // #3375
  { 4,  1}, // #3376
  { 8,  2}, // #3377
  {11,  1}, // #3378
  {13,  2}, // #3379
  {15,  3}, // #3380
  {16,  1}, // #3381
  {17,  1}, // #3382
  {18,  2}, // #3383
  {19,  3}, // #3384
  {20,  2}, // #3385
  {21,  1}, // #3386
  {22,  3}, // #3387
  {23,  4}, // #3388
  { 4,  1}, // #3389
  { 8,  2}, // #3390
  {11,  1}, // #3391
  {13,  2}, // #3392
  {15,  3}, // #3393
  {16,  1}, // #3394
  {18,  2}, // #3395
  {19,  3}, // #3396
  {20,  2}, // #3397
  {22,  3}, // #3398
  {23,  3}, // #3399
  { 4,  1}, // #3400
  {11,  1}, // #3401
  {14,  1}, // #3402
  {15,  1}, // #3403
  {16,  1}, // #3404
  {17,  1}, // #3405
  {19,  1}, // #3406
  {20,  1}, // #3407
  {21,  1}, // #3408
  {22,  4}, // #3409
  {23,  5}, // #3410
  { 4,  1}, // #3411
  {11,  1}, // #3412
  {14,  1}, // #3413
  {15,  1}, // #3414
  {16,  1}, // #3415
  {19,  1}, // #3416
  {20,  1}, // #3417
  {22,  4}, // #3418
  {23,  4}, // #3419
  { 4,  1}, // #3420
  {11,  1}, // #3421
  {15,  1}, // #3422
  {16,  1}, // #3423
  {17,  1}, // #3424
  {19,  1}, // #3425
  {21,  1}, // #3426
  {22,  2}, // #3427
  {23,  3}, // #3428
  { 4,  1}, // #3429
  {11,  1}, // #3430
  {15,  1}, // #3431
  {16,  1}, // #3432
  {19,  1}, // #3433
  {22,  2}, // #3434
  {23,  2}, // #3435
  { 4,  1}, // #3436
  {11,  1}, // #3437
  {14,  1}, // #3438
  {15,  1}, // #3439
  {16,  1}, // #3440
  {17,  1}, // #3441
  {19,  1}, // #3442
  {20,  1}, // #3443
  {21,  1}, // #3444
  {22,  3}, // #3445
  {23,  4}, // #3446
  { 4,  1}, // #3447
  {11,  1}, // #3448
  {14,  1}, // #3449
  {15,  1}, // #3450
  {16,  1}, // #3451
  {19,  1}, // #3452
  {20,  1}, // #3453
  {22,  3}, // #3454
  {23,  3}, // #3455
  { 3,  1}, // #3456
  {11,  1}, // #3457
  {12,  1}, // #3458
  {13,  1}, // #3459
  {14,  1}, // #3460
  {17,  1}, // #3461
  {19,  1}, // #3462
  {20,  1}, // #3463
  {21,  1}, // #3464
  {22,  2}, // #3465
  {23,  3}, // #3466
  {11,  1}, // #3467
  {19,  1}, // #3468
  {22,  1}, // #3469
  {23,  1}, // #3470
  { 7,  1}, // #3471
  {12,  1}, // #3472
  {17,  1}, // #3473
  {21,  1}, // #3474
  {23,  2}, // #3475
  { 8,  2}, // #3476
  {13,  2}, // #3477
  {15,  3}, // #3478
  {17,  1}, // #3479
  {18,  2}, // #3480
  {19,  3}, // #3481
  {20,  2}, // #3482
  {21,  1}, // #3483
  {22,  3}, // #3484
  {23,  4}, // #3485
  { 8,  2}, // #3486
  {13,  2}, // #3487
  {15,  3}, // #3488
  {18,  2}, // #3489
  {19,  3}, // #3490
  {20,  2}, // #3491
  {22,  3}, // #3492
  {23,  3}, // #3493
  { 3,  1}, // #3494
  { 8,  2}, // #3495
  {11,  1}, // #3496
  {12,  1}, // #3497
  {13,  3}, // #3498
  {14,  1}, // #3499
  {15,  2}, // #3500
  {17,  1}, // #3501
  {18,  2}, // #3502
  {19,  3}, // #3503
  {20,  3}, // #3504
  {21,  1}, // #3505
  {22,  3}, // #3506
  {23,  4}, // #3507
  { 3,  1}, // #3508
  { 8,  2}, // #3509
  {11,  1}, // #3510
  {12,  1}, // #3511
  {13,  3}, // #3512
  {14,  1}, // #3513
  {15,  2}, // #3514
  {18,  2}, // #3515
  {19,  3}, // #3516
  {20,  3}, // #3517
  {22,  3}, // #3518
  {23,  3}, // #3519
  {11,  1}, // #3520
  {17,  1}, // #3521
  {19,  1}, // #3522
  {21,  1}, // #3523
  {22,  1}, // #3524
  {23,  2}, // #3525
  { 3,  4}, // #3526
  { 8,  3}, // #3527
  {11,  4}, // #3528
  {12,  4}, // #3529
  {13,  7}, // #3530
  {14,  4}, // #3531
  {15,  3}, // #3532
  {17,  1}, // #3533
  {18,  3}, // #3534
  {19,  7}, // #3535
  {20,  7}, // #3536
  {21,  1}, // #3537
  {22,  8}, // #3538
  {23,  9}, // #3539
  { 3,  4}, // #3540
  { 8,  3}, // #3541
  {11,  4}, // #3542
  {12,  4}, // #3543
  {13,  7}, // #3544
  {14,  4}, // #3545
  {15,  3}, // #3546
  {18,  3}, // #3547
  {19,  7}, // #3548
  {20,  7}, // #3549
  {22,  8}, // #3550
  {23,  8}, // #3551
  { 3,  4}, // #3552
  { 8,  3}, // #3553
  {11,  4}, // #3554
  {12,  4}, // #3555
  {13,  7}, // #3556
  {14,  4}, // #3557
  {15,  3}, // #3558
  {17,  1}, // #3559
  {18,  3}, // #3560
  {19,  8}, // #3561
  {20,  7}, // #3562
  {21,  1}, // #3563
  {22,  9}, // #3564
  {23, 10}, // #3565
  { 3,  4}, // #3566
  { 8,  3}, // #3567
  {11,  4}, // #3568
  {12,  4}, // #3569
  {13,  7}, // #3570
  {14,  4}, // #3571
  {15,  3}, // #3572
  {18,  3}, // #3573
  {19,  8}, // #3574
  {20,  7}, // #3575
  {22,  9}, // #3576
  {23,  9}, // #3577
  { 3,  3}, // #3578
  {11,  3}, // #3579
  {12,  3}, // #3580
  {13,  3}, // #3581
  {14,  3}, // #3582
  {17,  1}, // #3583
  {19,  3}, // #3584
  {20,  3}, // #3585
  {21,  1}, // #3586
  {22,  3}, // #3587
  {23,  4}, // #3588
  { 3,  3}, // #3589
  {11,  3}, // #3590
  {12,  3}, // #3591
  {13,  3}, // #3592
  {14,  3}, // #3593
  {19,  3}, // #3594
  {20,  3}, // #3595
  {22,  3}, // #3596
  {23,  3}, // #3597
  { 3,  2}, // #3598
  {11,  2}, // #3599
  {12,  2}, // #3600
  {13,  2}, // #3601
  {14,  2}, // #3602
  {17,  1}, // #3603
  {19,  2}, // #3604
  {20,  2}, // #3605
  {21,  1}, // #3606
  {22,  2}, // #3607
  {23,  3}, // #3608
  { 3,  2}, // #3609
  {11,  2}, // #3610
  {12,  2}, // #3611
  {13,  2}, // #3612
  {14,  2}, // #3613
  {19,  2}, // #3614
  {20,  2}, // #3615
  {22,  2}, // #3616
  {23,  2}, // #3617
  { 7,  1}, // #3618
  {12,  1}, // #3619
  {17,  1}, // #3620
  {21,  2}, // #3621
  {23,  3}, // #3622
  { 3,  1}, // #3623
  { 8,  1}, // #3624
  {11,  1}, // #3625
  {12,  1}, // #3626
  {13,  2}, // #3627
  {14,  1}, // #3628
  {15,  1}, // #3629
  {17,  1}, // #3630
  {18,  1}, // #3631
  {19,  2}, // #3632
  {20,  2}, // #3633
  {21,  1}, // #3634
  {22,  2}, // #3635
  {23,  3}, // #3636
  {14,  2}, // #3637
  {20,  2}, // #3638
  {22,  3}, // #3639
  {23,  3}, // #3640
  { 4,  2}, // #3641
  {11,  2}, // #3642
  {15,  2}, // #3643
  {16,  2}, // #3644
  {17,  1}, // #3645
  {19,  2}, // #3646
  {21,  1}, // #3647
  {22,  2}, // #3648
  {23,  3}, // #3649
  { 7,  1}, // #3650
  {12,  1}, // #3651
  {14,  1}, // #3652
  {20,  1}, // #3653
  {21,  1}, // #3654
  {22,  1}, // #3655
  {23,  3}, // #3656
  { 4,  1}, // #3657
  {11,  1}, // #3658
  {14,  1}, // #3659
  {15,  1}, // #3660
  {16,  1}, // #3661
  {17,  1}, // #3662
  {19,  1}, // #3663
  {20,  1}, // #3664
  {21,  2}, // #3665
  {22,  4}, // #3666
  {23,  6}, // #3667
  { 4,  1}, // #3668
  {11,  1}, // #3669
  {15,  1}, // #3670
  {16,  1}, // #3671
  {17,  1}, // #3672
  {19,  1}, // #3673
  {21,  2}, // #3674
  {22,  2}, // #3675
  {23,  4}, // #3676
  { 2, 14}, // #3677
  { 3,  1}, // #3678
  {11,  1}, // #3679
  {12,  1}, // #3680
  {13,  1}, // #3681
  {14,  1}, // #3682
  {17,  1}, // #3683
  {19,  1}, // #3684
  {20,  1}, // #3685
  {21,  1}, // #3686
  {22,  1}, // #3687
  {23,  2}, // #3688
  { 2, 14}, // #3689
  { 3,  1}, // #3690
  {11,  1}, // #3691
  {12,  1}, // #3692
  {13,  1}, // #3693
  {14,  1}, // #3694
  {19,  1}, // #3695
  {20,  1}, // #3696
  {22,  1}, // #3697
  {23,  1}, // #3698
  { 2,  7}, // #3699
  { 3,  1}, // #3700
  {11,  1}, // #3701
  {12,  1}, // #3702
  {13,  1}, // #3703
  {14,  1}, // #3704
  {17,  1}, // #3705
  {19,  1}, // #3706
  {20,  1}, // #3707
  {21,  1}, // #3708
  {22,  1}, // #3709
  {23,  2}, // #3710
  { 2,  7}, // #3711
  { 3,  1}, // #3712
  {11,  1}, // #3713
  {12,  1}, // #3714
  {13,  1}, // #3715
  {14,  1}, // #3716
  {19,  1}, // #3717
  {20,  1}, // #3718
  {22,  1}, // #3719
  {23,  1}, // #3720
  { 2,  9}, // #3721
  { 3,  1}, // #3722
  {11,  1}, // #3723
  {12,  1}, // #3724
  {13,  1}, // #3725
  {14,  1}, // #3726
  {19,  1}, // #3727
  {20,  1}, // #3728
  {22,  1}, // #3729
  {23,  1}, // #3730
  { 4,  1}, // #3731
  { 7,  1}, // #3732
  {11,  1}, // #3733
  {12,  1}, // #3734
  {15,  1}, // #3735
  {16,  1}, // #3736
  {19,  1}, // #3737
  {21,  1}, // #3738
  {22,  1}, // #3739
  {23,  3}, // #3740
  { 2, 16}, // #3741
  { 3,  2}, // #3742
  {11,  2}, // #3743
  {12,  2}, // #3744
  {13,  2}, // #3745
  {14,  2}, // #3746
  {17,  1}, // #3747
  {19,  3}, // #3748
  {20,  2}, // #3749
  {21,  1}, // #3750
  {22,  3}, // #3751
  {23,  4}, // #3752
  { 2, 16}, // #3753
  { 3,  2}, // #3754
  {11,  2}, // #3755
  {12,  2}, // #3756
  {13,  2}, // #3757
  {14,  2}, // #3758
  {19,  3}, // #3759
  {20,  2}, // #3760
  {22,  3}, // #3761
  {23,  3}, // #3762
  { 2, 10}, // #3763
  { 3,  2}, // #3764
  {11,  2}, // #3765
  {12,  2}, // #3766
  {13,  2}, // #3767
  {14,  2}, // #3768
  {17,  1}, // #3769
  {19,  3}, // #3770
  {20,  2}, // #3771
  {21,  1}, // #3772
  {22,  3}, // #3773
  {23,  4}, // #3774
  { 2, 10}, // #3775
  { 3,  2}, // #3776
  {11,  2}, // #3777
  {12,  2}, // #3778
  {13,  2}, // #3779
  {14,  2}, // #3780
  {19,  3}, // #3781
  {20,  2}, // #3782
  {22,  3}, // #3783
  {23,  3}, // #3784
  { 3,  1}, // #3785
  { 7,  1}, // #3786
  {11,  1}, // #3787
  {12,  2}, // #3788
  {13,  1}, // #3789
  {14,  1}, // #3790
  {15,  1}, // #3791
  {19,  2}, // #3792
  {20,  1}, // #3793
  {21,  1}, // #3794
  {22,  2}, // #3795
  {23,  4}, // #3796
  { 3,  2}, // #3797
  { 8,  1}, // #3798
  {11,  2}, // #3799
  {12,  2}, // #3800
  {13,  3}, // #3801
  {14,  2}, // #3802
  {15,  1}, // #3803
  {17,  1}, // #3804
  {18,  1}, // #3805
  {19,  3}, // #3806
  {20,  3}, // #3807
  {21,  1}, // #3808
  {22,  3}, // #3809
  {23,  4}, // #3810
  { 3,  2}, // #3811
  { 8,  1}, // #3812
  {11,  2}, // #3813
  {12,  2}, // #3814
  {13,  3}, // #3815
  {14,  2}, // #3816
  {15,  1}, // #3817
  {18,  1}, // #3818
  {19,  3}, // #3819
  {20,  3}, // #3820
  {22,  3}, // #3821
  {23,  3}, // #3822
  { 2, 28}, // #3823
  { 3,  2}, // #3824
  {11,  2}, // #3825
  {12,  2}, // #3826
  {13,  2}, // #3827
  {14,  2}, // #3828
  {17,  1}, // #3829
  {19,  3}, // #3830
  {20,  2}, // #3831
  {21,  1}, // #3832
  {22,  3}, // #3833
  {23,  4}, // #3834
  { 2, 28}, // #3835
  { 3,  2}, // #3836
  {11,  2}, // #3837
  {12,  2}, // #3838
  {13,  2}, // #3839
  {14,  2}, // #3840
  {19,  3}, // #3841
  {20,  2}, // #3842
  {22,  3}, // #3843
  {23,  3}, // #3844
  { 2, 14}, // #3845
  { 3,  2}, // #3846
  {11,  2}, // #3847
  {12,  2}, // #3848
  {13,  2}, // #3849
  {14,  2}, // #3850
  {17,  1}, // #3851
  {19,  3}, // #3852
  {20,  2}, // #3853
  {21,  1}, // #3854
  {22,  3}, // #3855
  {23,  4}, // #3856
  { 2, 14}, // #3857
  { 3,  2}, // #3858
  {11,  2}, // #3859
  {12,  2}, // #3860
  {13,  2}, // #3861
  {14,  2}, // #3862
  {19,  3}, // #3863
  {20,  2}, // #3864
  {22,  3}, // #3865
  {23,  3}, // #3866
  {14,  1}, // #3867
  {17,  1}, // #3868
  {20,  1}, // #3869
  {21,  2}, // #3870
  {22,  3}, // #3871
  {23,  5}, // #3872
  { 4,  2}, // #3873
  {11,  2}, // #3874
  {14,  3}, // #3875
  {15,  3}, // #3876
  {16,  2}, // #3877
  {17,  1}, // #3878
  {19,  3}, // #3879
  {20,  3}, // #3880
  {21,  2}, // #3881
  {22,  9}, // #3882
  {23, 11}, // #3883
  { 3,  2}, // #3884
  { 4,  1}, // #3885
  { 9,  4}, // #3886
  {11,  3}, // #3887
  {12,  2}, // #3888
  {13,  2}, // #3889
  {14,  6}, // #3890
  {15,  1}, // #3891
  {16,  5}, // #3892
  {18,  4}, // #3893
  {19,  3}, // #3894
  {20,  6}, // #3895
  {22, 12}, // #3896
  {23, 12}, // #3897
  {17,  1}, // #3898
  {21,  1}, // #3899
  {22,  2}, // #3900
  {23,  3}, // #3901
  { 9,  1}, // #3902
  {14,  1}, // #3903
  {16,  1}, // #3904
  {18,  1}, // #3905
  {20,  1}, // #3906
  {22,  3}, // #3907
  {23,  3}, // #3908
  { 7,  1}, // #3909
  {12,  1}, // #3910
  {17,  1}, // #3911
  {21,  2}, // #3912
  {22,  3}, // #3913
  {23,  6}, // #3914
  {14,  1}, // #3915
  {20,  1}, // #3916
  {22,  2}, // #3917
  {23,  2}, // #3918
  { 3,  1}, // #3919
  {11,  2}, // #3920
  {12,  1}, // #3921
  {13,  1}, // #3922
  {14,  1}, // #3923
  {17,  1}, // #3924
  {19,  2}, // #3925
  {20,  1}, // #3926
  {21,  1}, // #3927
  {22,  2}, // #3928
  {23,  3}, // #3929
  {14,  2}, // #3930
  {20,  2}, // #3931
  {22, 11}, // #3932
  {23, 11}, // #3933
  { 7,  1}, // #3934
  { 9,  1}, // #3935
  {12,  1}, // #3936
  {14,  1}, // #3937
  {16,  1}, // #3938
  {18,  1}, // #3939
  {20,  1}, // #3940
  {21,  1}, // #3941
  {22,  1}, // #3942
  {23,  3}, // #3943
  { 9,  1}, // #3944
  {14,  1}, // #3945
  {16,  1}, // #3946
  {18,  1}, // #3947
  {20,  1}, // #3948
  {22,  5}, // #3949
  {23,  5}, // #3950
  { 7,  1}, // #3951
  {12,  1}, // #3952
  {14,  4}, // #3953
  {15,  2}, // #3954
  {17,  1}, // #3955
  {19,  2}, // #3956
  {20,  4}, // #3957
  {21,  2}, // #3958
  {22, 11}, // #3959
  {23, 14}, // #3960
  { 9,  2}, // #3961
  {14,  4}, // #3962
  {15,  1}, // #3963
  {16,  2}, // #3964
  {18,  2}, // #3965
  {19,  1}, // #3966
  {20,  4}, // #3967
  {22,  7}, // #3968
  {23,  7}, // #3969
  { 9,  1}, // #3970
  {14,  1}, // #3971
  {16,  1}, // #3972
  {18,  1}, // #3973
  {20,  1}, // #3974
  {22,  6}, // #3975
  {23,  6}, // #3976
  { 3,  2}, // #3977
  { 7,  1}, // #3978
  { 8,  4}, // #3979
  {11,  2}, // #3980
  {12,  3}, // #3981
  {13,  6}, // #3982
  {14,  6}, // #3983
  {15,  4}, // #3984
  {17,  1}, // #3985
  {18,  4}, // #3986
  {19,  6}, // #3987
  {20, 10}, // #3988
  {21,  2}, // #3989
  {22, 16}, // #3990
  {23, 19}, // #3991
  { 8,  2}, // #3992
  {13,  2}, // #3993
  {15,  2}, // #3994
  {18,  2}, // #3995
  {19,  2}, // #3996
  {20,  2}, // #3997
  {22, 22}, // #3998
  {23, 22}, // #3999
  { 7,  1}, // #4000
  { 8,  1}, // #4001
  { 9,  1}, // #4002
  {12,  1}, // #4003
  {13,  1}, // #4004
  {14,  2}, // #4005
  {15,  1}, // #4006
  {16,  1}, // #4007
  {17,  1}, // #4008
  {18,  2}, // #4009
  {19,  1}, // #4010
  {20,  3}, // #4011
  {21,  2}, // #4012
  {22,  5}, // #4013
  {23,  8}, // #4014
  { 8,  6}, // #4015
  {11,  3}, // #4016
  {13,  6}, // #4017
  {15,  6}, // #4018
  {18,  6}, // #4019
  {19,  9}, // #4020
  {20,  6}, // #4021
  {22, 15}, // #4022
  {23, 15}, // #4023
  { 8,  1}, // #4024
  { 9,  5}, // #4025
  {13,  1}, // #4026
  {14,  9}, // #4027
  {15,  1}, // #4028
  {16,  5}, // #4029
  {17,  2}, // #4030
  {18,  6}, // #4031
  {19,  1}, // #4032
  {20, 10}, // #4033
  {21,  3}, // #4034
  {22, 20}, // #4035
  {23, 23}, // #4036
  { 8,  1}, // #4037
  { 9,  5}, // #4038
  {13,  1}, // #4039
  {14,  9}, // #4040
  {15,  1}, // #4041
  {16,  5}, // #4042
  {17,  3}, // #4043
  {18,  6}, // #4044
  {19,  1}, // #4045
  {20, 10}, // #4046
  {21,  3}, // #4047
  {22, 20}, // #4048
  {23, 23}, // #4049
  { 8,  1}, // #4050
  { 9,  1}, // #4051
  {13,  1}, // #4052
  {14,  2}, // #4053
  {15,  1}, // #4054
  {16,  1}, // #4055
  {18,  2}, // #4056
  {19,  1}, // #4057
  {20,  3}, // #4058
  {22,  8}, // #4059
  {23,  8}, // #4060
  { 3,  4}, // #4061
  { 9,  2}, // #4062
  {11,  4}, // #4063
  {12,  4}, // #4064
  {13,  5}, // #4065
  {14,  8}, // #4066
  {15,  1}, // #4067
  {16,  2}, // #4068
  {17, 33}, // #4069
  {18,  2}, // #4070
  {19,  6}, // #4071
  {20,  9}, // #4072
  {21, 33}, // #4073
  {22, 57}, // #4074
  {23, 90}, // #4075
  { 9,  1}, // #4076
  {14,  1}, // #4077
  {16,  1}, // #4078
  {17,  1}, // #4079
  {18,  1}, // #4080
  {20,  1}, // #4081
  {21,  1}, // #4082
  {22,  2}, // #4083
  {23,  3}, // #4084
  { 3,  1}, // #4085
  {11,  1}, // #4086
  {12,  1}, // #4087
  {13,  1}, // #4088
  {14,  1}, // #4089
  {19,  1}, // #4090
  {20,  1}, // #4091
  {22,  2}, // #4092
  {23,  2}, // #4093
  {11,  1}, // #4094
  {19,  2}, // #4095
  {22,  2}, // #4096
  {23,  2}, // #4097
  {14,  1}, // #4098
  {20,  1}, // #4099
  {22,  3}, // #4100
  {23,  3}, // #4101
  { 4,  2}, // #4102
  {11,  2}, // #4103
  {14,  4}, // #4104
  {15,  2}, // #4105
  {16,  2}, // #4106
  {19,  2}, // #4107
  {20,  4}, // #4108
  {22,  8}, // #4109
  {23,  8}, // #4110
  { 4,  2}, // #4111
  {11,  2}, // #4112
  {14,  3}, // #4113
  {15,  3}, // #4114
  {16,  2}, // #4115
  {19,  3}, // #4116
  {20,  3}, // #4117
  {22, 10}, // #4118
  {23, 10}, // #4119
  { 7,  1}, // #4120
  {12,  1}, // #4121
  {21,  1}, // #4122
  {22,  1}, // #4123
  {23,  3}, // #4124
  { 7,  1}, // #4125
  {12,  1}, // #4126
  {14,  1}, // #4127
  {20,  1}, // #4128
  {21,  1}, // #4129
  {22,  2}, // #4130
  {23,  4}, // #4131
  { 7,  1}, // #4132
  { 9,  1}, // #4133
  {12,  1}, // #4134
  {14,  1}, // #4135
  {16,  1}, // #4136
  {18,  1}, // #4137
  {20,  1}, // #4138
  {21,  1}, // #4139
  {22,  2}, // #4140
  {23,  4}, // #4141
  { 7,  1}, // #4142
  {12,  1}, // #4143
  {21,  1}, // #4144
  {22,  4}, // #4145
  {23,  6}, // #4146
  { 9,  1}, // #4147
  {14,  1}, // #4148
  {16,  1}, // #4149
  {18,  1}, // #4150
  {20,  1}, // #4151
  {22,  2}, // #4152
  {23,  2}, // #4153
  { 9,  1}, // #4154
  {14,  1}, // #4155
  {16,  1}, // #4156
  {17,  1}, // #4157
  {18,  1}, // #4158
  {20,  1}, // #4159
  {21,  1}, // #4160
  {22,  1}, // #4161
  {23,  2}, // #4162
  { 3,  1}, // #4163
  { 7,  1}, // #4164
  {11,  1}, // #4165
  {12,  2}, // #4166
  {13,  1}, // #4167
  {14,  1}, // #4168
  {19,  1}, // #4169
  {20,  1}, // #4170
  {21,  1}, // #4171
  {22,  1}, // #4172
  {23,  3}, // #4173
  { 4,  1}, // #4174
  { 9,  1}, // #4175
  {11,  1}, // #4176
  {14,  2}, // #4177
  {15,  1}, // #4178
  {16,  2}, // #4179
  {18,  1}, // #4180
  {19,  1}, // #4181
  {20,  2}, // #4182
  {22,  4}, // #4183
  {23,  4}, // #4184
  { 7,  1}, // #4185
  { 9,  1}, // #4186
  {12,  1}, // #4187
  {14,  1}, // #4188
  {16,  1}, // #4189
  {17,  1}, // #4190
  {18,  1}, // #4191
  {20,  1}, // #4192
  {21,  2}, // #4193
  {22,  2}, // #4194
  {23,  5}, // #4195
  { 7,  1}, // #4196
  {12,  1}, // #4197
  {14,  2}, // #4198
  {17,  1}, // #4199
  {20,  2}, // #4200
  {21,  2}, // #4201
  {22,  2}, // #4202
  {23,  5}, // #4203
  { 7,  1}, // #4204
  {12,  1}, // #4205
  {17,  1}, // #4206
  {21,  2}, // #4207
  {22,  2}, // #4208
  {23,  5}, // #4209
  { 8,  1}, // #4210
  { 9,  1}, // #4211
  {13,  1}, // #4212
  {14,  1}, // #4213
  {15,  1}, // #4214
  {16,  1}, // #4215
  {18,  2}, // #4216
  {19,  1}, // #4217
  {20,  2}, // #4218
  {22,  2}, // #4219
  {23,  2}, // #4220
  {14,  1}, // #4221
  {17,  1}, // #4222
  {20,  1}, // #4223
  {21,  1}, // #4224
  {22,  4}, // #4225
  {23,  5}, // #4226
  { 9,  1}, // #4227
  {14,  1}, // #4228
  {16,  1}, // #4229
  {18,  1}, // #4230
  {20,  1}, // #4231
  {22,  1}, // #4232
  {23,  1}, // #4233
  { 7,  1}, // #4234
  {12,  1}, // #4235
  {15,  1}, // #4236
  {19,  1}, // #4237
  {21,  1}, // #4238
  {22,  1}, // #4239
  {23,  3}, // #4240
  {14,  2}, // #4241
  {20,  2}, // #4242
  {22,  2}, // #4243
  {23,  2}, // #4244
  { 8,  2}, // #4245
  {13,  2}, // #4246
  {15,  2}, // #4247
  {18,  2}, // #4248
  {19,  2}, // #4249
  {20,  2}, // #4250
  {22,  3}, // #4251
  {23,  3}, // #4252
  { 8,  1}, // #4253
  {13,  1}, // #4254
  {15,  1}, // #4255
  {17,  1}, // #4256
  {18,  1}, // #4257
  {19,  2}, // #4258
  {20,  1}, // #4259
  {21,  1}, // #4260
  {22,  2}, // #4261
  {23,  3}, // #4262
  { 4,  2}, // #4263
  { 9,  2}, // #4264
  {11,  2}, // #4265
  {14,  2}, // #4266
  {15,  2}, // #4267
  {16,  4}, // #4268
  {17,  1}, // #4269
  {18,  2}, // #4270
  {19,  2}, // #4271
  {20,  2}, // #4272
  {21,  1}, // #4273
  {22,  7}, // #4274
  {23,  8}, // #4275
  { 4,  1}, // #4276
  { 9,  2}, // #4277
  {11,  1}, // #4278
  {14,  2}, // #4279
  {15,  1}, // #4280
  {16,  3}, // #4281
  {17,  1}, // #4282
  {18,  2}, // #4283
  {19,  1}, // #4284
  {20,  2}, // #4285
  {21,  1}, // #4286
  {22,  4}, // #4287
  {23,  5}, // #4288
  { 4,  1}, // #4289
  { 9,  1}, // #4290
  {11,  1}, // #4291
  {14,  2}, // #4292
  {15,  1}, // #4293
  {16,  2}, // #4294
  {18,  1}, // #4295
  {19,  1}, // #4296
  {20,  2}, // #4297
  {22,  3}, // #4298
  {23,  3}, // #4299
  {14,  1}, // #4300
  {20,  1}, // #4301
  {22,  5}, // #4302
  {23,  5}, // #4303
  { 4,  1}, // #4304
  {11,  1}, // #4305
  {14,  4}, // #4306
  {15,  2}, // #4307
  {16,  1}, // #4308
  {17,  1}, // #4309
  {19,  2}, // #4310
  {20,  4}, // #4311
  {21,  2}, // #4312
  {22,  8}, // #4313
  {23, 10}, // #4314
  { 4,  2}, // #4315
  {11,  2}, // #4316
  {14,  2}, // #4317
  {15,  2}, // #4318
  {16,  2}, // #4319
  {19,  2}, // #4320
  {20,  2}, // #4321
  {22,  7}, // #4322
  {23,  7}, // #4323
  { 4,  1}, // #4324
  {11,  1}, // #4325
  {14,  4}, // #4326
  {15,  2}, // #4327
  {16,  1}, // #4328
  {19,  2}, // #4329
  {20,  4}, // #4330
  {22,  9}, // #4331
  {23,  9}, // #4332
  { 9,  3}, // #4333
  {14,  3}, // #4334
  {16,  3}, // #4335
  {17,  1}, // #4336
  {18,  3}, // #4337
  {20,  3}, // #4338
  {21,  1}, // #4339
  {22, 18}, // #4340
  {23, 19}, // #4341
  { 7,  1}, // #4342
  { 9,  5}, // #4343
  {12,  1}, // #4344
  {14,  5}, // #4345
  {16,  5}, // #4346
  {17,  1}, // #4347
  {18,  5}, // #4348
  {20,  5}, // #4349
  {21,  2}, // #4350
  {22, 24}, // #4351
  {23, 27}, // #4352
  { 7,  1}, // #4353
  { 9,  6}, // #4354
  {12,  1}, // #4355
  {14,  6}, // #4356
  {16,  6}, // #4357
  {17,  1}, // #4358
  {18,  6}, // #4359
  {20,  6}, // #4360
  {21,  2}, // #4361
  {22, 25}, // #4362
  {23, 28}, // #4363
  { 3,  2}, // #4364
  {11,  4}, // #4365
  {12,  2}, // #4366
  {13,  3}, // #4367
  {14, 12}, // #4368
  {17,  8}, // #4369
  {19,  7}, // #4370
  {20, 13}, // #4371
  {21,  8}, // #4372
  {22, 56}, // #4373
  {23, 64}, // #4374
  { 3,  4}, // #4375
  { 9,  4}, // #4376
  {11,  4}, // #4377
  {12,  4}, // #4378
  {13,  5}, // #4379
  {14, 10}, // #4380
  {15,  1}, // #4381
  {16,  4}, // #4382
  {17, 31}, // #4383
  {18,  4}, // #4384
  {19,  6}, // #4385
  {20, 11}, // #4386
  {21, 31}, // #4387
  {22, 57}, // #4388
  {23, 88}, // #4389
  { 3,  9}, // #4390
  { 4,  9}, // #4391
  { 7, 11}, // #4392
  { 8,  8}, // #4393
  { 9,  1}, // #4394
  {11, 18}, // #4395
  {12, 20}, // #4396
  {13, 17}, // #4397
  {14, 31}, // #4398
  {15, 17}, // #4399
  {16, 10}, // #4400
  {18,  9}, // #4401
  {19, 26}, // #4402
  {20, 39}, // #4403
  {21, 11}, // #4404
  {22, 78}, // #4405
  {23, 100}, // #4406
  { 7,  1}, // #4407
  { 8,  3}, // #4408
  {12,  1}, // #4409
  {13,  3}, // #4410
  {15,  3}, // #4411
  {17,  2}, // #4412
  {18,  3}, // #4413
  {19,  3}, // #4414
  {20,  3}, // #4415
  {21,  2}, // #4416
  {22,  4}, // #4417
  {23,  7}, // #4418
  { 7,  1}, // #4419
  { 8,  3}, // #4420
  {12,  1}, // #4421
  {13,  3}, // #4422
  {15,  3}, // #4423
  {17,  4}, // #4424
  {18,  3}, // #4425
  {19,  3}, // #4426
  {20,  3}, // #4427
  {21,  4}, // #4428
  {22,  4}, // #4429
  {23,  9}, // #4430
  { 7,  1}, // #4431
  { 8,  4}, // #4432
  {12,  1}, // #4433
  {13,  4}, // #4434
  {15,  4}, // #4435
  {17,  4}, // #4436
  {18,  4}, // #4437
  {19,  4}, // #4438
  {20,  4}, // #4439
  {21,  4}, // #4440
  {22,  5}, // #4441
  {23, 10}, // #4442
  { 7,  1}, // #4443
  { 8,  4}, // #4444
  {12,  1}, // #4445
  {13,  4}, // #4446
  {15,  4}, // #4447
  {17,  8}, // #4448
  {18,  4}, // #4449
  {19,  4}, // #4450
  {20,  4}, // #4451
  {21,  8}, // #4452
  {22,  5}, // #4453
  {23, 14}, // #4454
  { 7,  1}, // #4455
  { 8,  5}, // #4456
  {12,  1}, // #4457
  {13,  5}, // #4458
  {15,  5}, // #4459
  {17,  2}, // #4460
  {18,  5}, // #4461
  {19,  5}, // #4462
  {20,  5}, // #4463
  {21,  2}, // #4464
  {22,  6}, // #4465
  {23,  9}, // #4466
  { 9,  1}, // #4467
  {14,  1}, // #4468
  {16,  1}, // #4469
  {17,  1}, // #4470
  {18,  1}, // #4471
  {20,  1}, // #4472
  {21,  1}, // #4473
  {22, 17}, // #4474
  {23, 18}, // #4475
  {14,  1}, // #4476
  {17,  1}, // #4477
  {20,  1}, // #4478
  {21,  1}, // #4479
  {22,  2}, // #4480
  {23,  3}, // #4481
  { 9,  1}, // #4482
  {16,  1}, // #4483
  { 3,  3}, // #4484
  {11,  1}, // #4485
  {12,  2}, // #4486
  {14,  1}, // #4487
  { 8,  1}, // #4488
  { 9,  1}, // #4489
  {12,  1}, // #4490
  {14,  1}, // #4491
  {15,  1}, // #4492
  { 8,  2}, // #4493
  { 9,  2}, // #4494
  {12,  2}, // #4495
  {14,  2}, // #4496
  {15,  2}, // #4497
  { 3,  1}, // #4498
  {11,  1}, // #4499
  {12,  2}, // #4500
  {14,  1}, // #4501
  { 3,  2}, // #4502
  {11,  1}, // #4503
  {12,  2}, // #4504
  {14,  1}, // #4505
  { 3,  2}, // #4506
  {11,  1}, // #4507
  {12,  1}, // #4508
  { 5,  1}, // #4509
  { 7,  1}, // #4510
  { 9,  1}, // #4511
  {10,  1}, // #4512
  {11,  1}, // #4513
  {12,  1}, // #4514
  { 7,  1}, // #4515
  { 9,  2}, // #4516
  {11,  1}, // #4517
  {12,  1}, // #4518
  {16,  1}, // #4519
  {19,  1}, // #4520
  { 7,  1}, // #4521
  { 9,  2}, // #4522
  {16,  1}, // #4523
  {19,  1}, // #4524
  { 7,  1}, // #4525
  { 9,  1}, // #4526
  {11,  1}, // #4527
  {12,  1}, // #4528
  {19,  1}, // #4529
  { 7,  1}, // #4530
  { 9,  1}, // #4531
  {19,  1}, // #4532
  { 9,  4}, // #4533
  {10,  4}, // #4534
  {11,  1}, // #4535
  {12,  1}, // #4536
  { 3,  8}, // #4537
  {11,  1}, // #4538
  {12,  1}, // #4539
  { 1,  1}, // #4540
  { 3,  1}, // #4541
  { 5,  1}, // #4542
  { 7,  1}, // #4543
  { 9,  1}, // #4544
  {10,  1}, // #4545
  {11,  1}, // #4546
  {12,  1}, // #4547
  { 3,  4}, // #4548
  {11,  1}, // #4549
  {12,  1}, // #4550
  { 8,  1}, // #4551
  { 9,  1}, // #4552
  {11,  1}, // #4553
  {12,  1}, // #4554
  {15,  1}, // #4555
  { 8,  1}, // #4556
  { 9,  1}, // #4557
  {15,  1}, // #4558
  { 1,  1}, // #4559
  { 3,  1}, // #4560
  { 5,  1}, // #4561
  { 7,  1}, // #4562
  { 8,  1}, // #4563
  { 9,  2}, // #4564
  {10,  1}, // #4565
  {11,  1}, // #4566
  {12,  1}, // #4567
  {15,  1}, // #4568
  { 1,  1}, // #4569
  { 3,  1}, // #4570
  { 5,  1}, // #4571
  { 7,  1}, // #4572
  { 8,  1}, // #4573
  { 9,  2}, // #4574
  {10,  1}, // #4575
  {15,  1}, // #4576
  { 8,  1}, // #4577
  { 9,  1}, // #4578
  {11,  1}, // #4579
  {12,  1}, // #4580
  {15,  2}, // #4581
  { 8,  1}, // #4582
  { 9,  1}, // #4583
  {15,  2}, // #4584
  { 2,  1}, // #4585
  { 3,  1}, // #4586
  { 4, 17}, // #4587
  {11,  1}, // #4588
  {12,  1}, // #4589
  { 2,  1}, // #4590
  { 3,  1}, // #4591
  { 4, 25}, // #4592
  {11,  1}, // #4593
  {12,  1}, // #4594
  { 2,  1}, // #4595
  { 3,  1}, // #4596
  { 4, 41}, // #4597
  {11,  1}, // #4598
  {12,  1}, // #4599
  { 2,  1}, // #4600
  { 3,  1}, // #4601
  { 4, 12}, // #4602
  {11,  1}, // #4603
  {12,  1}, // #4604
  { 6, 19}, // #4605
  { 8,  1}, // #4606
  { 9,  1}, // #4607
  {10, 19}, // #4608
  {11,  1}, // #4609
  {12,  1}, // #4610
  { 5,  3}, // #4611
  { 6,  3}, // #4612
  { 8,  1}, // #4613
  { 9,  1}, // #4614
  {10,  6}, // #4615
  {11,  1}, // #4616
  {12,  1}, // #4617
  { 9,  1}, // #4618
  {11,  1}, // #4619
  {12,  1}, // #4620
  {16,  1}, // #4621
  { 2,  1}, // #4622
  { 3,  1}, // #4623
  {11,  1}, // #4624
  {12,  1}, // #4625
  {13,  3}, // #4626
  { 2,  1}, // #4627
  { 3,  1}, // #4628
  {13,  3}, // #4629
  { 2,  1}, // #4630
  { 3,  1}, // #4631
  {11,  1}, // #4632
  {12,  1}, // #4633
  {13,  1}, // #4634
  { 2,  1}, // #4635
  { 3,  1}, // #4636
  {11,  1}, // #4637
  {12,  1}, // #4638
  {13,  2}, // #4639
  { 2,  1}, // #4640
  { 3,  1}, // #4641
  {13,  1}, // #4642
  { 2,  1}, // #4643
  { 3,  1}, // #4644
  {13,  2}, // #4645
  { 2,  1}, // #4646
  { 3,  1}, // #4647
  {11,  1}, // #4648
  {12,  1}, // #4649
  {13,  4}, // #4650
  { 2,  1}, // #4651
  { 3,  1}, // #4652
  {13,  4}, // #4653
  { 7,  1}, // #4654
  { 9,  1}, // #4655
  {11,  1}, // #4656
  {12,  1}, // #4657
  {19,  2}, // #4658
  { 7,  1}, // #4659
  { 9,  1}, // #4660
  {19,  2}, // #4661
  { 6,  2}, // #4662
  { 8,  1}, // #4663
  { 9,  1}, // #4664
  {10,  2}, // #4665
  {11,  1}, // #4666
  {12,  1}, // #4667
  { 6,  1}, // #4668
  { 8,  1}, // #4669
  { 9,  1}, // #4670
  {10,  1}, // #4671
  {11,  1}, // #4672
  {12,  1}, // #4673
  { 9,  4}, // #4674
  {11,  1}, // #4675
  {12,  1}, // #4676
  {16,  4}, // #4677
  { 9,  4}, // #4678
  {16,  4}, // #4679
  { 1,  1}, // #4680
  { 3,  1}, // #4681
  { 5,  1}, // #4682
  { 8,  1}, // #4683
  { 9,  1}, // #4684
  {10,  1}, // #4685
  {11,  3}, // #4686
  {12,  5}, // #4687
  {14,  2}, // #4688
  {16, 10}, // #4689
  {18,  4}, // #4690
  { 1,  1}, // #4691
  { 3,  1}, // #4692
  { 5,  1}, // #4693
  { 8,  1}, // #4694
  { 9,  1}, // #4695
  {10,  1}, // #4696
  {11,  2}, // #4697
  {12,  4}, // #4698
  {14,  2}, // #4699
  {16, 10}, // #4700
  {18,  4}, // #4701
  { 1,  1}, // #4702
  { 3,  1}, // #4703
  { 5,  1}, // #4704
  { 7,  1}, // #4705
  { 8,  2}, // #4706
  { 9,  3}, // #4707
  {10,  1}, // #4708
  {11,  1}, // #4709
  {12,  1}, // #4710
  {16,  2}, // #4711
  {18,  2}, // #4712
  { 1,  1}, // #4713
  { 3,  1}, // #4714
  { 5,  1}, // #4715
  { 7,  1}, // #4716
  { 8,  2}, // #4717
  { 9,  3}, // #4718
  {10,  1}, // #4719
  {16,  2}, // #4720
  {18,  2}, // #4721
  { 7,  2}, // #4722
  { 9,  3}, // #4723
  {11,  1}, // #4724
  {12,  1}, // #4725
  {16,  1}, // #4726
  {19,  2}, // #4727
  { 7,  2}, // #4728
  { 9,  3}, // #4729
  {16,  1}, // #4730
  {19,  2}, // #4731
  { 9,  1}, // #4732
  {11,  1}, // #4733
  {12,  1}, // #4734
  {16,  4}, // #4735
  { 9,  1}, // #4736
  {16,  4}, // #4737
  { 3,  1}, // #4738
  {12,  1}, // #4739
  {14,  1}, // #4740
  { 3, 22}, // #4741
  {11,  1}, // #4742
  {12,  1}, // #4743
  { 6, 27}, // #4744
  { 8,  1}, // #4745
  { 9,  1}, // #4746
  {10, 27}, // #4747
  {11,  1}, // #4748
  {12,  1}, // #4749
  { 6, 21}, // #4750
  { 8,  1}, // #4751
  { 9,  1}, // #4752
  {10, 21}, // #4753
  {11,  1}, // #4754
  {12,  1}, // #4755
  { 6, 35}, // #4756
  { 8,  1}, // #4757
  { 9,  1}, // #4758
  {10, 35}, // #4759
  { 5,  2}, // #4760
  { 7,  2}, // #4761
  { 9,  2}, // #4762
  {10,  2}, // #4763
  {11,  2}, // #4764
  {12,  2}, // #4765
  { 8,  2}, // #4766
  { 9,  2}, // #4767
  {15,  2}, // #4768
  { 9,  6}, // #4769
  {10,  6}, // #4770
  {11,  2}, // #4771
  {12,  2}, // #4772
  { 9,  2}, // #4773
  {10,  2}, // #4774
  {11,  1}, // #4775
  {12,  1}, // #4776
  { 8,  2}, // #4777
  { 9,  2}, // #4778
  {11,  2}, // #4779
  {12,  2}, // #4780
  {15,  2}, // #4781
  { 8,  2}, // #4782
  { 9,  2}, // #4783
  {10,  4}, // #4784
  {11,  2}, // #4785
  {12,  2}, // #4786
  {15,  2}, // #4787
  { 8,  2}, // #4788
  { 9,  2}, // #4789
  {10,  4}, // #4790
  {15,  2}, // #4791
  { 8,  2}, // #4792
  { 9,  2}, // #4793
  {10,  2}, // #4794
  {12,  1}, // #4795
  {14,  1}, // #4796
  {15,  2}, // #4797
  { 8,  2}, // #4798
  { 9,  2}, // #4799
  {10,  2}, // #4800
  {15,  2}, // #4801
  { 6, 38}, // #4802
  { 8,  2}, // #4803
  { 9,  2}, // #4804
  {10, 38}, // #4805
  {11,  2}, // #4806
  {12,  2}, // #4807
  { 5,  6}, // #4808
  { 6,  6}, // #4809
  { 8,  2}, // #4810
  { 9,  2}, // #4811
  {10, 12}, // #4812
  {11,  2}, // #4813
  {12,  2}, // #4814
  { 3,  4}, // #4815
  { 5,  1}, // #4816
  { 7,  1}, // #4817
  { 8,  4}, // #4818
  { 9,  5}, // #4819
  {10,  1}, // #4820
  {11,  4}, // #4821
  {12,  8}, // #4822
  {14,  4}, // #4823
  {15,  4}, // #4824
  { 9,  4}, // #4825
  {10,  4}, // #4826
  {11,  2}, // #4827
  {12,  2}, // #4828
  { 3,  2}, // #4829
  { 5,  1}, // #4830
  { 7,  1}, // #4831
  { 8,  2}, // #4832
  { 9,  3}, // #4833
  {10,  1}, // #4834
  {11,  2}, // #4835
  {12,  4}, // #4836
  {14,  2}, // #4837
  {15,  2}, // #4838
  { 3,  8}, // #4839
  { 5,  1}, // #4840
  { 7,  1}, // #4841
  { 8, 10}, // #4842
  { 9, 11}, // #4843
  {10,  1}, // #4844
  {11,  8}, // #4845
  {12, 16}, // #4846
  {14,  8}, // #4847
  {15, 10}, // #4848
  { 3,  4}, // #4849
  { 5,  1}, // #4850
  { 7,  1}, // #4851
  { 8,  5}, // #4852
  { 9,  6}, // #4853
  {10,  1}, // #4854
  {11,  4}, // #4855
  {12,  8}, // #4856
  {14,  4}, // #4857
  {15,  5}, // #4858
  { 9,  2}, // #4859
  {16,  2}, // #4860
  { 6,  4}, // #4861
  { 8,  2}, // #4862
  { 9,  2}, // #4863
  {10,  4}, // #4864
  {11,  2}, // #4865
  {12,  2}, // #4866
  { 6,  2}, // #4867
  { 8,  2}, // #4868
  { 9,  2}, // #4869
  {10,  2}, // #4870
  {11,  2}, // #4871
  {12,  2}, // #4872
  { 9,  2}, // #4873
  {10,  6}, // #4874
  {11,  2}, // #4875
  {12,  2}, // #4876
  { 9,  1}, // #4877
  {10,  4}, // #4878
  {11,  1}, // #4879
  {12,  1}, // #4880
  { 9,  4}, // #4881
  {11,  2}, // #4882
  {12,  2}, // #4883
  {16,  4}, // #4884
  { 9,  2}, // #4885
  {11,  1}, // #4886
  {12,  1}, // #4887
  {16,  2}, // #4888
  { 1,  1}, // #4889
  { 3,  1}, // #4890
  { 5,  2}, // #4891
  { 9,  2}, // #4892
  {10,  4}, // #4893
  {11,  2}, // #4894
  {12,  2}, // #4895
  { 6, 54}, // #4896
  { 8,  2}, // #4897
  { 9,  2}, // #4898
  {10, 54}, // #4899
  {11,  2}, // #4900
  {12,  2}, // #4901
  { 6, 42}, // #4902
  { 8,  2}, // #4903
  { 9,  2}, // #4904
  {10, 42}, // #4905
  {11,  2}, // #4906
  {12,  2}, // #4907
  { 3,  2}, // #4908
  {11, 16}, // #4909
  {12, 32}, // #4910
  {14, 16}, // #4911
  { 9,  2}, // #4912
  {10,  4}, // #4913
  {11,  1}, // #4914
  {12,  1}, // #4915
  { 3, 42}, // #4916
  { 5,  1}, // #4917
  { 7,  1}, // #4918
  { 8,  2}, // #4919
  { 9,  3}, // #4920
  {10,  1}, // #4921
  {11,  2}, // #4922
  {12, 18}, // #4923
  {14, 16}, // #4924
  {15,  2}, // #4925
  { 3,  3}, // #4926
  {11, 19}, // #4927
  {12, 38}, // #4928
  {14, 19}, // #4929
  { 3,  6}, // #4930
  {11, 38}, // #4931
  {12, 76}, // #4932
  {14, 38}, // #4933
  { 3,  3}, // #4934
  {11, 16}, // #4935
  {12, 32}, // #4936
  {14, 16}, // #4937
  { 3,  3}, // #4938
  {11, 17}, // #4939
  {12, 34}, // #4940
  {14, 17}, // #4941
  { 3,  6}, // #4942
  {11,  1}, // #4943
  {12,  2}, // #4944
  {14,  1}, // #4945
  { 3,  1}, // #4946
  {11, 19}, // #4947
  {12, 38}, // #4948
  {14, 19}, // #4949
  { 2,  1}, // #4950
  { 3,  1}, // #4951
  {12,  1}, // #4952
  {14,  1}, // #4953
  {13,  1}, // #4954
  {19,  1}, // #4955
  {20,  1}, // #4956
  {22,  1}, // #4957
  {23,  1}, // #4958
  { 3,  3}, // #4959
  { 8,  6}, // #4960
  {11,  3}, // #4961
  {12,  3}, // #4962
  {13,  9}, // #4963
  {14,  3}, // #4964
  {15,  6}, // #4965
  {17,  1}, // #4966
  {18,  6}, // #4967
  {19, 10}, // #4968
  {20,  9}, // #4969
  {21,  1}, // #4970
  {22, 10}, // #4971
  {23, 11}, // #4972
  { 3,  3}, // #4973
  { 8,  6}, // #4974
  {11,  3}, // #4975
  {12,  3}, // #4976
  {13,  9}, // #4977
  {14,  3}, // #4978
  {15,  6}, // #4979
  {18,  6}, // #4980
  {19, 11}, // #4981
  {20,  9}, // #4982
  {22, 11}, // #4983
  {23, 11}, // #4984
  { 8,  1}, // #4985
  {11,  1}, // #4986
  {13,  1}, // #4987
  {15,  1}, // #4988
  {17,  1}, // #4989
  {18,  1}, // #4990
  {19,  2}, // #4991
  {20,  1}, // #4992
  {21,  1}, // #4993
  {22,  2}, // #4994
  {23,  3}, // #4995
  { 8,  1}, // #4996
  {11,  1}, // #4997
  {13,  1}, // #4998
  {15,  1}, // #4999
  {18,  1}, // #5000
  {19,  2}, // #5001
  {20,  1}, // #5002
  {22,  2}, // #5003
  {23,  2}, // #5004
  {11,  2}, // #5005
  {17,  1}, // #5006
  {19,  2}, // #5007
  {21,  1}, // #5008
  {22,  2}, // #5009
  {23,  3}, // #5010
  { 1, 10}, // #5011
  { 3,  1}, // #5012
  {11,  1}, // #5013
  {12,  1}, // #5014
  {13,  1}, // #5015
  {14,  1}, // #5016
  {17,  1}, // #5017
  {19,  1}, // #5018
  {20,  1}, // #5019
  {21,  1}, // #5020
  {22,  1}, // #5021
  {23,  2}, // #5022
  { 3,  7}, // #5023
  { 4,  2}, // #5024
  { 8,  8}, // #5025
  { 9,  3}, // #5026
  {11,  9}, // #5027
  {12,  7}, // #5028
  {13, 16}, // #5029
  {14, 10}, // #5030
  {15, 10}, // #5031
  {16,  5}, // #5032
  {18, 11}, // #5033
  {19, 18}, // #5034
  {20, 19}, // #5035
  {22, 32}, // #5036
  {23, 32}, // #5037
  { 2,  4}, // #5038
  { 3,  1}, // #5039
  {11,  1}, // #5040
  {12,  1}, // #5041
  {13,  1}, // #5042
  {14,  1}, // #5043
  {17,  1}, // #5044
  {19,  1}, // #5045
  {20,  1}, // #5046
  {21,  1}, // #5047
  {22,  1}, // #5048
  {23,  2}, // #5049
  { 2,  3}, // #5050
  { 3,  1}, // #5051
  {11,  1}, // #5052
  {12,  1}, // #5053
  {13,  1}, // #5054
  {14,  1}, // #5055
  {17,  1}, // #5056
  {19,  1}, // #5057
  {20,  1}, // #5058
  {21,  1}, // #5059
  {22,  1}, // #5060
  {23,  2}, // #5061
  { 8,  1}, // #5062
  {13,  1}, // #5063
  {15,  1}, // #5064
  {17,  1}, // #5065
  {18,  1}, // #5066
  {19,  3}, // #5067
  {20,  1}, // #5068
  {21,  1}, // #5069
  {22,  3}, // #5070
  {23,  4}, // #5071
  { 8,  1}, // #5072
  {13,  1}, // #5073
  {15,  1}, // #5074
  {18,  1}, // #5075
  {19,  3}, // #5076
  {20,  1}, // #5077
  {22,  3}, // #5078
  {23,  3}, // #5079
  { 8,  1}, // #5080
  {13,  1}, // #5081
  {15,  1}, // #5082
  {17,  1}, // #5083
  {18,  1}, // #5084
  {19,  4}, // #5085
  {20,  1}, // #5086
  {21,  1}, // #5087
  {22,  4}, // #5088
  {23,  5}, // #5089
  { 8,  1}, // #5090
  {13,  1}, // #5091
  {15,  1}, // #5092
  {18,  1}, // #5093
  {19,  4}, // #5094
  {20,  1}, // #5095
  {22,  4}, // #5096
  {23,  4}, // #5097
  {13,  9}, // #5098
  {19,  9}, // #5099
  {20,  9}, // #5100
  {22, 10}, // #5101
  {23, 10}, // #5102
  {13,  2}, // #5103
  {19,  2}, // #5104
  {20,  2}, // #5105
  {22,  2}, // #5106
  {23,  2}, // #5107
  { 8,  2}, // #5108
  {13,  2}, // #5109
  {15,  2}, // #5110
  {17,  1}, // #5111
  {18,  2}, // #5112
  {19,  3}, // #5113
  {20,  2}, // #5114
  {21,  1}, // #5115
  {22,  3}, // #5116
  {23,  4}, // #5117
  { 8,  2}, // #5118
  {13,  2}, // #5119
  {15,  2}, // #5120
  {18,  2}, // #5121
  {19,  3}, // #5122
  {20,  2}, // #5123
  {22,  3}, // #5124
  {23,  3}, // #5125
  { 3,  2}, // #5126
  { 8,  4}, // #5127
  {11,  2}, // #5128
  {12,  2}, // #5129
  {13,  6}, // #5130
  {14,  2}, // #5131
  {15,  4}, // #5132
  {17,  1}, // #5133
  {18,  4}, // #5134
  {19,  6}, // #5135
  {20,  6}, // #5136
  {21,  1}, // #5137
  {22,  7}, // #5138
  {23,  8}, // #5139
  { 3,  4}, // #5140
  { 4,  2}, // #5141
  { 8,  4}, // #5142
  { 9,  8}, // #5143
  {11,  6}, // #5144
  {12,  4}, // #5145
  {13,  8}, // #5146
  {14, 26}, // #5147
  {15,  6}, // #5148
  {16, 10}, // #5149
  {18, 12}, // #5150
  {19, 10}, // #5151
  {20, 30}, // #5152
  {22, 66}, // #5153
  {23, 66}, // #5154
  {13,  1}, // #5155
  {17,  1}, // #5156
  {19,  1}, // #5157
  {20,  1}, // #5158
  {21,  1}, // #5159
  {22,  1}, // #5160
  {23,  2}, // #5161
  { 8,  2}, // #5162
  {13,  3}, // #5163
  {15,  2}, // #5164
  {17,  1}, // #5165
  {18,  2}, // #5166
  {19,  3}, // #5167
  {20,  3}, // #5168
  {21,  1}, // #5169
  {22,  3}, // #5170
  {23,  4}, // #5171
  { 8,  2}, // #5172
  {13,  3}, // #5173
  {15,  2}, // #5174
  {18,  2}, // #5175
  {19,  3}, // #5176
  {20,  3}, // #5177
  {22,  3}, // #5178
  {23,  3}, // #5179
  { 7,  1}, // #5180
  {12,  1}, // #5181
  {14,  3}, // #5182
  {17,  1}, // #5183
  {20,  3}, // #5184
  {21,  2}, // #5185
  {22,  3}, // #5186
  {23,  6}, // #5187
  {14,  3}, // #5188
  {20,  3}, // #5189
  {22,  3}, // #5190
  {23,  3}, // #5191
  { 4,  1}, // #5192
  {11,  1}, // #5193
  {14,  2}, // #5194
  {15,  1}, // #5195
  {16,  1}, // #5196
  {17,  1}, // #5197
  {19,  1}, // #5198
  {20,  2}, // #5199
  {21,  2}, // #5200
  {22,  4}, // #5201
  {23,  6}, // #5202
  { 4,  1}, // #5203
  {11,  1}, // #5204
  {14,  2}, // #5205
  {15,  1}, // #5206
  {16,  1}, // #5207
  {19,  1}, // #5208
  {20,  2}, // #5209
  {22,  4}, // #5210
  {23,  4}, // #5211
  { 2,  6}, // #5212
  { 3,  1}, // #5213
  {11,  1}, // #5214
  {12,  1}, // #5215
  {13,  1}, // #5216
  {14,  1}, // #5217
  {17,  1}, // #5218
  {19,  1}, // #5219
  {20,  1}, // #5220
  {21,  1}, // #5221
  {22,  1}, // #5222
  {23,  2}, // #5223
  { 2,  6}, // #5224
  { 3,  1}, // #5225
  {11,  1}, // #5226
  {12,  1}, // #5227
  {13,  1}, // #5228
  {14,  1}, // #5229
  {19,  1}, // #5230
  {20,  1}, // #5231
  {22,  1}, // #5232
  {23,  1}, // #5233
  { 8,  1}, // #5234
  {13,  2}, // #5235
  {15,  1}, // #5236
  {17,  1}, // #5237
  {18,  1}, // #5238
  {19,  2}, // #5239
  {20,  2}, // #5240
  {21,  1}, // #5241
  {22,  2}, // #5242
  {23,  3}, // #5243
  { 8,  1}, // #5244
  {13,  2}, // #5245
  {15,  1}, // #5246
  {18,  1}, // #5247
  {19,  2}, // #5248
  {20,  2}, // #5249
  {22,  2}, // #5250
  {23,  2}, // #5251
  {13,  2}, // #5252
  {17,  1}, // #5253
  {19,  2}, // #5254
  {20,  2}, // #5255
  {21,  1}, // #5256
  {22,  2}, // #5257
  {23,  3}, // #5258
  { 7,  1}, // #5259
  { 8,  1}, // #5260
  {11,  1}, // #5261
  {12,  1}, // #5262
  {13,  1}, // #5263
  {15,  1}, // #5264
  {18,  1}, // #5265
  {19,  2}, // #5266
  {20,  1}, // #5267
  {21,  1}, // #5268
  {22,  2}, // #5269
  {23,  4}, // #5270
  { 7,  1}, // #5271
  { 8,  1}, // #5272
  {12,  1}, // #5273
  {13,  2}, // #5274
  {15,  1}, // #5275
  {18,  1}, // #5276
  {19,  2}, // #5277
  {20,  2}, // #5278
  {21,  1}, // #5279
  {22,  2}, // #5280
  {23,  4}, // #5281
  { 2, 16}, // #5282
  { 3,  2}, // #5283
  { 8,  1}, // #5284
  {11,  2}, // #5285
  {12,  2}, // #5286
  {13,  3}, // #5287
  {14,  2}, // #5288
  {15,  1}, // #5289
  {17,  1}, // #5290
  {18,  1}, // #5291
  {19,  3}, // #5292
  {20,  3}, // #5293
  {21,  1}, // #5294
  {22,  3}, // #5295
  {23,  4}, // #5296
  { 2, 16}, // #5297
  { 3,  2}, // #5298
  { 8,  1}, // #5299
  {11,  2}, // #5300
  {12,  2}, // #5301
  {13,  3}, // #5302
  {14,  2}, // #5303
  {15,  1}, // #5304
  {18,  1}, // #5305
  {19,  3}, // #5306
  {20,  3}, // #5307
  {22,  3}, // #5308
  {23,  3}, // #5309
  { 2, 10}, // #5310
  { 3,  2}, // #5311
  { 8,  1}, // #5312
  {11,  2}, // #5313
  {12,  2}, // #5314
  {13,  3}, // #5315
  {14,  2}, // #5316
  {15,  1}, // #5317
  {17,  1}, // #5318
  {18,  1}, // #5319
  {19,  3}, // #5320
  {20,  3}, // #5321
  {21,  1}, // #5322
  {22,  3}, // #5323
  {23,  4}, // #5324
  { 2, 10}, // #5325
  { 3,  2}, // #5326
  { 8,  1}, // #5327
  {11,  2}, // #5328
  {12,  2}, // #5329
  {13,  3}, // #5330
  {14,  2}, // #5331
  {15,  1}, // #5332
  {18,  1}, // #5333
  {19,  3}, // #5334
  {20,  3}, // #5335
  {22,  3}, // #5336
  {23,  3}, // #5337
  { 3,  1}, // #5338
  {11,  1}, // #5339
  {12,  1}, // #5340
  {13,  1}, // #5341
  {14,  1}, // #5342
  {19,  1}, // #5343
  {20,  1}, // #5344
  {21,  1}, // #5345
  {22,  1}, // #5346
  {23,  2}, // #5347
  { 2, 12}, // #5348
  { 3,  1}, // #5349
  {11,  1}, // #5350
  {12,  1}, // #5351
  {13,  1}, // #5352
  {14,  1}, // #5353
  {17,  1}, // #5354
  {19,  1}, // #5355
  {20,  1}, // #5356
  {21,  1}, // #5357
  {22,  1}, // #5358
  {23,  2}, // #5359
  { 2, 12}, // #5360
  { 3,  1}, // #5361
  {11,  1}, // #5362
  {12,  1}, // #5363
  {13,  1}, // #5364
  {14,  1}, // #5365
  {19,  1}, // #5366
  {20,  1}, // #5367
  {22,  1}, // #5368
  {23,  1}, // #5369
  { 2, 24}, // #5370
  { 3,  2}, // #5371
  { 8,  1}, // #5372
  {11,  2}, // #5373
  {12,  2}, // #5374
  {13,  3}, // #5375
  {14,  2}, // #5376
  {15,  1}, // #5377
  {17,  1}, // #5378
  {18,  1}, // #5379
  {19,  3}, // #5380
  {20,  3}, // #5381
  {21,  1}, // #5382
  {22,  3}, // #5383
  {23,  4}, // #5384
  { 2, 24}, // #5385
  { 3,  2}, // #5386
  { 8,  1}, // #5387
  {11,  2}, // #5388
  {12,  2}, // #5389
  {13,  3}, // #5390
  {14,  2}, // #5391
  {15,  1}, // #5392
  {18,  1}, // #5393
  {19,  3}, // #5394
  {20,  3}, // #5395
  {22,  3}, // #5396
  {23,  3}, // #5397
  { 2, 12}, // #5398
  { 3,  2}, // #5399
  { 8,  1}, // #5400
  {11,  2}, // #5401
  {12,  2}, // #5402
  {13,  3}, // #5403
  {14,  2}, // #5404
  {15,  1}, // #5405
  {17,  1}, // #5406
  {18,  1}, // #5407
  {19,  3}, // #5408
  {20,  3}, // #5409
  {21,  1}, // #5410
  {22,  3}, // #5411
  {23,  4}, // #5412
  { 2, 12}, // #5413
  { 3,  2}, // #5414
  { 8,  1}, // #5415
  {11,  2}, // #5416
  {12,  2}, // #5417
  {13,  3}, // #5418
  {14,  2}, // #5419
  {15,  1}, // #5420
  {18,  1}, // #5421
  {19,  3}, // #5422
  {20,  3}, // #5423
  {22,  3}, // #5424
  {23,  3}, // #5425
  { 4,  2}, // #5426
  {11,  2}, // #5427
  {14,  4}, // #5428
  {15,  3}, // #5429
  {16,  2}, // #5430
  {17,  1}, // #5431
  {19,  3}, // #5432
  {20,  4}, // #5433
  {21,  2}, // #5434
  {22,  9}, // #5435
  {23, 11}, // #5436
  { 3,  2}, // #5437
  { 4,  1}, // #5438
  { 8,  2}, // #5439
  { 9,  4}, // #5440
  {11,  3}, // #5441
  {12,  2}, // #5442
  {13,  6}, // #5443
  {14,  6}, // #5444
  {15,  3}, // #5445
  {16,  5}, // #5446
  {18,  6}, // #5447
  {19,  7}, // #5448
  {20, 10}, // #5449
  {22, 15}, // #5450
  {23, 15}, // #5451
  { 8,  2}, // #5452
  {11,  1}, // #5453
  {13,  2}, // #5454
  {15,  2}, // #5455
  {18,  2}, // #5456
  {19,  3}, // #5457
  {20,  2}, // #5458
  {22,  3}, // #5459
  {23,  3}, // #5460
  { 3,  1}, // #5461
  { 8,  1}, // #5462
  {11,  2}, // #5463
  {12,  1}, // #5464
  {13,  2}, // #5465
  {14,  1}, // #5466
  {15,  1}, // #5467
  {18,  1}, // #5468
  {19,  3}, // #5469
  {20,  2}, // #5470
  {22,  3}, // #5471
  {23,  3}, // #5472
  { 7,  1}, // #5473
  { 9,  1}, // #5474
  {12,  1}, // #5475
  {14,  2}, // #5476
  {16,  1}, // #5477
  {17,  1}, // #5478
  {18,  1}, // #5479
  {20,  2}, // #5480
  {21,  2}, // #5481
  {22,  5}, // #5482
  {23,  8}, // #5483
  { 3,  1}, // #5484
  {11,  1}, // #5485
  {12,  1}, // #5486
  {13,  2}, // #5487
  {14,  1}, // #5488
  {17,  1}, // #5489
  {19,  2}, // #5490
  {20,  2}, // #5491
  {21,  1}, // #5492
  {22,  2}, // #5493
  {23,  3}, // #5494
  { 9,  1}, // #5495
  {14,  1}, // #5496
  {16,  1}, // #5497
  {18,  1}, // #5498
  {20,  1}, // #5499
  {22,  4}, // #5500
  {23,  4}, // #5501
  { 9,  1}, // #5502
  {14,  4}, // #5503
  {15,  1}, // #5504
  {16,  1}, // #5505
  {18,  1}, // #5506
  {19,  1}, // #5507
  {20,  4}, // #5508
  {22,  7}, // #5509
  {23,  7}, // #5510
  { 8,  1}, // #5511
  { 9,  2}, // #5512
  {13,  1}, // #5513
  {14,  2}, // #5514
  {15,  1}, // #5515
  {16,  2}, // #5516
  {18,  3}, // #5517
  {19,  1}, // #5518
  {20,  3}, // #5519
  {22, 10}, // #5520
  {23, 10}, // #5521
  { 8,  6}, // #5522
  {13,  9}, // #5523
  {15,  6}, // #5524
  {18,  6}, // #5525
  {19,  9}, // #5526
  {20,  9}, // #5527
  {22, 15}, // #5528
  {23, 15}, // #5529
  { 4,  2}, // #5530
  {11,  2}, // #5531
  {14,  4}, // #5532
  {15,  3}, // #5533
  {16,  2}, // #5534
  {19,  3}, // #5535
  {20,  4}, // #5536
  {22, 10}, // #5537
  {23, 10}, // #5538
  { 4,  1}, // #5539
  { 9,  5}, // #5540
  {11,  1}, // #5541
  {13,  4}, // #5542
  {14,  5}, // #5543
  {15,  1}, // #5544
  {16,  6}, // #5545
  {18,  5}, // #5546
  {19,  5}, // #5547
  {20,  9}, // #5548
  {22, 10}, // #5549
  {23, 10}, // #5550
  { 4,  1}, // #5551
  { 9,  1}, // #5552
  {11,  1}, // #5553
  {14,  1}, // #5554
  {15,  1}, // #5555
  {16,  2}, // #5556
  {18,  1}, // #5557
  {19,  1}, // #5558
  {20,  1}, // #5559
  {22,  4}, // #5560
  {23,  4}, // #5561
  { 4,  1}, // #5562
  {11,  1}, // #5563
  {14,  5}, // #5564
  {15,  2}, // #5565
  {16,  1}, // #5566
  {17,  1}, // #5567
  {19,  2}, // #5568
  {20,  5}, // #5569
  {21,  2}, // #5570
  {22,  8}, // #5571
  {23, 10}, // #5572
  { 4,  2}, // #5573
  {11,  2}, // #5574
  {14,  3}, // #5575
  {15,  2}, // #5576
  {16,  2}, // #5577
  {19,  2}, // #5578
  {20,  3}, // #5579
  {22,  7}, // #5580
  {23,  7}, // #5581
  { 4,  1}, // #5582
  {11,  1}, // #5583
  {14,  5}, // #5584
  {15,  2}, // #5585
  {16,  1}, // #5586
  {19,  2}, // #5587
  {20,  5}, // #5588
  {22,  9}, // #5589
  {23,  9}, // #5590
  { 4,  1}, // #5591
  { 9,  8}, // #5592
  {11,  1}, // #5593
  {14,  8}, // #5594
  {15,  1}, // #5595
  {16,  9}, // #5596
  {17,  1}, // #5597
  {18,  8}, // #5598
  {19,  1}, // #5599
  {20,  8}, // #5600
  {21,  1}, // #5601
  {22, 30}, // #5602
  {23, 31}, // #5603
  { 7,  1}, // #5604
  { 9, 10}, // #5605
  {12,  1}, // #5606
  {14, 10}, // #5607
  {16, 10}, // #5608
  {17,  1}, // #5609
  {18, 10}, // #5610
  {20, 10}, // #5611
  {21,  2}, // #5612
  {22, 36}, // #5613
  {23, 39}, // #5614
  { 7,  1}, // #5615
  { 9, 11}, // #5616
  {12,  1}, // #5617
  {14, 11}, // #5618
  {16, 11}, // #5619
  {17,  1}, // #5620
  {18, 11}, // #5621
  {20, 11}, // #5622
  {21,  2}, // #5623
  {22, 37}, // #5624
  {23, 40}, // #5625
  { 4,  1}, // #5626
  { 7,  1}, // #5627
  { 8,  2}, // #5628
  { 9,  3}, // #5629
  {11,  1}, // #5630
  {12,  1}, // #5631
  {13,  2}, // #5632
  {14,  3}, // #5633
  {15,  4}, // #5634
  {16,  4}, // #5635
  {17,  1}, // #5636
  {18,  5}, // #5637
  {19,  4}, // #5638
  {20,  5}, // #5639
  {21,  2}, // #5640
  {22, 15}, // #5641
  {23, 18}, // #5642
  { 3,  2}, // #5643
  {11,  2}, // #5644
  {12,  2}, // #5645
  {13,  7}, // #5646
  {14, 12}, // #5647
  {17,  8}, // #5648
  {19,  7}, // #5649
  {20, 17}, // #5650
  {21,  8}, // #5651
  {22, 56}, // #5652
  {23, 64}, // #5653
  { 3,  9}, // #5654
  { 4,  1}, // #5655
  { 7, 11}, // #5656
  { 8, 16}, // #5657
  { 9,  1}, // #5658
  {11, 10}, // #5659
  {12, 20}, // #5660
  {13, 25}, // #5661
  {14, 31}, // #5662
  {15, 17}, // #5663
  {16,  2}, // #5664
  {18, 17}, // #5665
  {19, 26}, // #5666
  {20, 47}, // #5667
  {21, 11}, // #5668
  {22, 78}, // #5669
  {23, 100}, // #5670
  { 3,  1}, // #5671
  { 8,  1}, // #5672
  {11,  1}, // #5673
  {12,  1}, // #5674
  {13,  2}, // #5675
  {14,  1}, // #5676
  {15,  1}, // #5677
  {17,  2}, // #5678
  {18,  1}, // #5679
  {19,  3}, // #5680
  {20,  2}, // #5681
  {21,  2}, // #5682
  {22,  3}, // #5683
  {23,  5}, // #5684
  { 3,  1}, // #5685
  { 8,  1}, // #5686
  {11,  1}, // #5687
  {12,  1}, // #5688
  {13,  2}, // #5689
  {14,  1}, // #5690
  {15,  1}, // #5691
  {17,  4}, // #5692
  {18,  1}, // #5693
  {19,  3}, // #5694
  {20,  2}, // #5695
  {21,  4}, // #5696
  {22,  3}, // #5697
  {23,  7}, // #5698
  { 3,  1}, // #5699
  { 8,  1}, // #5700
  {11,  1}, // #5701
  {12,  1}, // #5702
  {13,  2}, // #5703
  {14,  1}, // #5704
  {15,  1}, // #5705
  {17,  8}, // #5706
  {18,  1}, // #5707
  {19,  3}, // #5708
  {20,  2}, // #5709
  {21,  8}, // #5710
  {22,  3}, // #5711
  {23, 11}, // #5712
  { 8,  5}, // #5713
  {11,  5}, // #5714
  {13,  5}, // #5715
  {15,  5}, // #5716
  {18,  5}, // #5717
  {19, 14}, // #5718
  {20,  5}, // #5719
  {22, 14}, // #5720
  {23, 14}, // #5721
  { 8,  9}, // #5722
  {11,  7}, // #5723
  {13,  9}, // #5724
  {15,  9}, // #5725
  {18,  9}, // #5726
  {19, 21}, // #5727
  {20,  9}, // #5728
  {22, 21}, // #5729
  {23, 21}, // #5730
  { 8, 17}, // #5731
  {11, 11}, // #5732
  {13, 17}, // #5733
  {15, 17}, // #5734
  {18, 17}, // #5735
  {19, 35}, // #5736
  {20, 17}, // #5737
  {22, 35}, // #5738
  {23, 35}, // #5739
  { 8,  2}, // #5740
  {11,  1}, // #5741
  {13,  2}, // #5742
  {15,  2}, // #5743
  {17,  1}, // #5744
  {18,  2}, // #5745
  {19,  3}, // #5746
  {20,  2}, // #5747
  {21,  1}, // #5748
  {22,  3}, // #5749
  {23,  4}, // #5750
  { 7,  2}, // #5751
  {12,  2}, // #5752
  {15,  1}, // #5753
  {19,  1}, // #5754
  {21,  2}, // #5755
  {22,  1}, // #5756
  {23,  5}, // #5757
  { 7,  1}, // #5758
  {11,  1}, // #5759
  {12,  1}, // #5760
  {19,  1}, // #5761
  {21,  1}, // #5762
  {22,  1}, // #5763
  {23,  3}, // #5764
  { 7,  1}, // #5765
  { 8,  2}, // #5766
  {12,  1}, // #5767
  {13,  2}, // #5768
  {15,  2}, // #5769
  {18,  2}, // #5770
  {19,  2}, // #5771
  {20,  2}, // #5772
  {21,  1}, // #5773
  {22,  2}, // #5774
  {23,  4}, // #5775
  { 8,  1}, // #5776
  {13,  1}, // #5777
  {15,  1}, // #5778
  {17,  1}, // #5779
  {18,  1}, // #5780
  {19,  1}, // #5781
  {20,  1}, // #5782
  {21,  1}, // #5783
  {22,  2}, // #5784
  {23,  3}, // #5785
  { 3,  1}, // #5786
  { 7,  2}, // #5787
  {11,  1}, // #5788
  {12,  3}, // #5789
  {13,  1}, // #5790
  {14,  1}, // #5791
  {19,  1}, // #5792
  {20,  1}, // #5793
  {21,  2}, // #5794
  {22,  3}, // #5795
  {23,  7}, // #5796
  { 3,  1}, // #5797
  { 7,  4}, // #5798
  {11,  1}, // #5799
  {12,  5}, // #5800
  {13,  1}, // #5801
  {14,  1}, // #5802
  {19,  1}, // #5803
  {20,  1}, // #5804
  {21,  4}, // #5805
  {22,  3}, // #5806
  {23, 11}, // #5807
  { 3,  1}, // #5808
  { 7,  8}, // #5809
  {11,  1}, // #5810
  {12,  9}, // #5811
  {13,  1}, // #5812
  {14,  1}, // #5813
  {19,  1}, // #5814
  {20,  1}, // #5815
  {21,  8}, // #5816
  {22,  3}, // #5817
  {23, 19}, // #5818
  { 3,  1}, // #5819
  { 7, 16}, // #5820
  { 8,  1}, // #5821
  {11,  1}, // #5822
  {12, 17}, // #5823
  {13,  2}, // #5824
  {14,  1}, // #5825
  {15,  1}, // #5826
  {18,  1}, // #5827
  {19,  2}, // #5828
  {20,  2}, // #5829
  {21, 16}, // #5830
  {22,  4}, // #5831
  {23, 36}, // #5832
  { 3,  1}, // #5833
  { 7,  2}, // #5834
  { 8,  1}, // #5835
  {11,  1}, // #5836
  {12,  3}, // #5837
  {13,  2}, // #5838
  {14,  1}, // #5839
  {15,  1}, // #5840
  {18,  1}, // #5841
  {19,  2}, // #5842
  {20,  2}, // #5843
  {21,  2}, // #5844
  {22,  4}, // #5845
  {23,  8}, // #5846
  { 3,  1}, // #5847
  { 7,  4}, // #5848
  { 8,  1}, // #5849
  {11,  1}, // #5850
  {12,  5}, // #5851
  {13,  2}, // #5852
  {14,  1}, // #5853
  {15,  1}, // #5854
  {18,  1}, // #5855
  {19,  2}, // #5856
  {20,  2}, // #5857
  {21,  4}, // #5858
  {22,  4}, // #5859
  {23, 12}, // #5860
  { 3,  1}, // #5861
  { 7,  8}, // #5862
  { 8,  1}, // #5863
  {11,  1}, // #5864
  {12,  9}, // #5865
  {13,  2}, // #5866
  {14,  1}, // #5867
  {15,  1}, // #5868
  {18,  1}, // #5869
  {19,  2}, // #5870
  {20,  2}, // #5871
  {21,  8}, // #5872
  {22,  4}, // #5873
  {23, 20}, // #5874
  {11,  3}, // #5875
  {19,  3}, // #5876
  {22,  3}, // #5877
  {23,  3}, // #5878
  {13,  3}, // #5879
  {19,  3}, // #5880
  {20,  3}, // #5881
  {22,  3}, // #5882
  {23,  3}, // #5883
  { 4,  1}, // #5884
  { 8,  2}, // #5885
  {11,  3}, // #5886
  {13,  2}, // #5887
  {15,  3}, // #5888
  {16,  1}, // #5889
  {17,  1}, // #5890
  {18,  2}, // #5891
  {19,  7}, // #5892
  {20,  2}, // #5893
  {21,  1}, // #5894
  {22,  7}, // #5895
  {23,  8}, // #5896
  {11,  3}, // #5897
  {17,  1}, // #5898
  {19,  3}, // #5899
  {21,  1}, // #5900
  {22,  3}, // #5901
  {23,  4}, // #5902
  {13,  3}, // #5903
  {17,  1}, // #5904
  {19,  3}, // #5905
  {20,  3}, // #5906
  {21,  1}, // #5907
  {22,  3}, // #5908
  {23,  4}, // #5909
  { 3,  1}, // #5910
  {11,  1}, // #5911
  {12,  1}, // #5912
  {13,  1}, // #5913
  {14,  1}, // #5914
  {17,  2}, // #5915
  {19,  2}, // #5916
  {20,  1}, // #5917
  {21,  2}, // #5918
  {22,  3}, // #5919
  {23,  5}, // #5920
  { 3,  1}, // #5921
  {11,  1}, // #5922
  {12,  1}, // #5923
  {13,  1}, // #5924
  {14,  1}, // #5925
  {17,  4}, // #5926
  {19,  2}, // #5927
  {20,  1}, // #5928
  {21,  4}, // #5929
  {22,  3}, // #5930
  {23,  7}, // #5931
  { 3,  1}, // #5932
  {11,  1}, // #5933
  {12,  1}, // #5934
  {13,  1}, // #5935
  {14,  1}, // #5936
  {17,  8}, // #5937
  {19,  2}, // #5938
  {20,  1}, // #5939
  {21,  8}, // #5940
  {22,  3}, // #5941
  {23, 11}, // #5942
  { 3,  1}, // #5943
  {11,  1}, // #5944
  {12,  1}, // #5945
  {13,  1}, // #5946
  {14,  1}, // #5947
  {17, 16}, // #5948
  {19,  2}, // #5949
  {20,  1}, // #5950
  {21, 16}, // #5951
  {22,  3}, // #5952
  {23, 19}, // #5953
  { 8,  5}, // #5954
  {11,  5}, // #5955
  {13,  5}, // #5956
  {15,  5}, // #5957
  {17,  1}, // #5958
  {18,  5}, // #5959
  {19, 14}, // #5960
  {20,  5}, // #5961
  {21,  1}, // #5962
  {22, 14}, // #5963
  {23, 15}, // #5964
  { 8,  9}, // #5965
  {11,  7}, // #5966
  {13,  9}, // #5967
  {15,  9}, // #5968
  {17,  1}, // #5969
  {18,  9}, // #5970
  {19, 21}, // #5971
  {20,  9}, // #5972
  {21,  1}, // #5973
  {22, 21}, // #5974
  {23, 22}, // #5975
  { 8, 17}, // #5976
  {11, 11}, // #5977
  {13, 17}, // #5978
  {15, 17}, // #5979
  {17,  1}, // #5980
  {18, 17}, // #5981
  {19, 35}, // #5982
  {20, 17}, // #5983
  {21,  1}, // #5984
  {22, 35}, // #5985
  {23, 36}, // #5986
  {14,  2}, // #5987
  {17,  1}, // #5988
  {20,  2}, // #5989
  {21,  1}, // #5990
  {22,  2}, // #5991
  {23,  3}, // #5992
  { 7,  1}, // #5993
  {12,  1}, // #5994
  {14,  2}, // #5995
  {20,  2}, // #5996
  {21,  1}, // #5997
  {22,  2}, // #5998
  {23,  4}, // #5999
  { 4,  1}, // #6000
  { 7,  1}, // #6001
  { 9,  1}, // #6002
  {11,  1}, // #6003
  {12,  1}, // #6004
  { 6,  1}, // #6005
  { 8,  1}, // #6006
  { 9,  1}, // #6007
  {11,  1}, // #6008
  {12,  1}, // #6009
  { 5,  1}, // #6010
  { 6,  2}, // #6011
  { 8,  2}, // #6012
  { 9,  2}, // #6013
  {10,  2}, // #6014
  {11,  3}, // #6015
  {12,  6}, // #6016
  { 6,  1}, // #6017
  { 8,  1}, // #6018
  { 9,  1}, // #6019
  {10,  1}, // #6020
  {11,  1}, // #6021
  {12,  2}, // #6022
  { 5,  1}, // #6023
  {10,  1}, // #6024
  {12,  2}, // #6025
  {10,  1}, // #6026
  {12,  1}, // #6027
  { 5,  1}, // #6028
  {10,  2}, // #6029
  {11,  1}, // #6030
  {12,  4}, // #6031
  { 5,  1}, // #6032
  {10,  2}, // #6033
  {11,  3}, // #6034
  {12,  6}, // #6035
  { 8,  1}, // #6036
  {10,  1}, // #6037
  {11,  2}, // #6038
  {12,  3}, // #6039
  { 4,  1}, // #6040
  { 7,  1}, // #6041
  { 9,  1}, // #6042
  {10,  1}, // #6043
  {11,  1}, // #6044
  {12,  2}, // #6045
  { 6,  1}, // #6046
  { 8,  1}, // #6047
  { 9,  1}, // #6048
  {10,  1}, // #6049
  {11,  2}, // #6050
  {12,  3}, // #6051
  { 6,  1}, // #6052
  { 8,  1}, // #6053
  { 9,  1}, // #6054
  {11,  2}, // #6055
  {12,  2}, // #6056
  { 6,  2}, // #6057
  { 8,  2}, // #6058
  { 9,  2}, // #6059
  {10,  1}, // #6060
  {11,  2}, // #6061
  {12,  3}, // #6062
  { 6,  2}, // #6063
  { 8,  2}, // #6064
  { 9,  2}, // #6065
  {11,  2}, // #6066
  {12,  2}, // #6067
  {10,  1}, // #6068
  {11, 10}, // #6069
  {12, 11}, // #6070
  {11, 11}, // #6071
  {12, 11}, // #6072
  { 4,  1}, // #6073
  { 7,  1}, // #6074
  { 8,  1}, // #6075
  { 9,  1}, // #6076
  {10,  1}, // #6077
  {11,  2}, // #6078
  {12,  3}, // #6079
  { 4,  1}, // #6080
  { 7,  1}, // #6081
  { 8,  1}, // #6082
  { 9,  1}, // #6083
  {11,  2}, // #6084
  {12,  2}, // #6085
  { 8,  1}, // #6086
  {10,  1}, // #6087
  {11,  1}, // #6088
  {12,  2}, // #6089
  { 8,  2}, // #6090
  {10,  1}, // #6091
  {11,  2}, // #6092
  {12,  3}, // #6093
  { 8,  2}, // #6094
  {11,  2}, // #6095
  {12,  2}, // #6096
  { 5,  1}, // #6097
  { 6,  1}, // #6098
  { 8,  2}, // #6099
  { 9,  1}, // #6100
  {10,  2}, // #6101
  {11,  3}, // #6102
  {12,  6}, // #6103
  { 5,  1}, // #6104
  { 8,  1}, // #6105
  {10,  2}, // #6106
  {11,  1}, // #6107
  {12,  4}, // #6108
  { 6,  2}, // #6109
  { 8,  3}, // #6110
  { 9,  2}, // #6111
  {11,  3}, // #6112
  {12,  3}, // #6113
  { 8,  1}, // #6114
  {11,  4}, // #6115
  {12,  4}, // #6116
  { 4,  1}, // #6117
  { 6,  1}, // #6118
  { 7,  1}, // #6119
  { 8,  1}, // #6120
  { 9,  2}, // #6121
  {10,  1}, // #6122
  {11,  2}, // #6123
  {12,  3}, // #6124
  { 4,  1}, // #6125
  { 6,  1}, // #6126
  { 7,  1}, // #6127
  { 8,  1}, // #6128
  { 9,  2}, // #6129
  {11,  2}, // #6130
  {12,  2}, // #6131
  { 3,  1}, // #6132
  { 7,  1}, // #6133
  { 8,  1}, // #6134
  {10,  1}, // #6135
  {11,  1}, // #6136
  {12,  2}, // #6137
  { 3,  1}, // #6138
  { 6,  1}, // #6139
  { 7,  1}, // #6140
  { 8,  2}, // #6141
  { 9,  1}, // #6142
  {11,  2}, // #6143
  {12,  2}, // #6144
  { 3,  1}, // #6145
  { 4,  1}, // #6146
  { 7,  2}, // #6147
  { 8,  1}, // #6148
  { 9,  1}, // #6149
  {10,  1}, // #6150
  {11,  2}, // #6151
  {12,  3}, // #6152
  { 3,  1}, // #6153
  { 4,  1}, // #6154
  { 7,  2}, // #6155
  { 8,  1}, // #6156
  { 9,  1}, // #6157
  {11,  2}, // #6158
  {12,  2}, // #6159
  { 4,  1}, // #6160
  { 6,  2}, // #6161
  { 7,  1}, // #6162
  { 8,  2}, // #6163
  { 9,  3}, // #6164
  {11,  3}, // #6165
  {12,  3}, // #6166
  { 3,  1}, // #6167
  { 7,  1}, // #6168
  { 8,  1}, // #6169
  {11,  1}, // #6170
  {12,  1}, // #6171
  { 1, 10}, // #6172
  { 3,  1}, // #6173
  { 7,  1}, // #6174
  { 8,  1}, // #6175
  {10,  1}, // #6176
  {11,  1}, // #6177
  {12,  2}, // #6178
  { 1, 10}, // #6179
  { 3,  1}, // #6180
  { 7,  1}, // #6181
  { 8,  1}, // #6182
  {11,  1}, // #6183
  {12,  1}, // #6184
  { 2, 22}, // #6185
  { 3,  1}, // #6186
  { 7,  1}, // #6187
  { 8,  1}, // #6188
  {10,  1}, // #6189
  {11,  1}, // #6190
  {12,  2}, // #6191
  { 2, 22}, // #6192
  { 3,  1}, // #6193
  { 7,  1}, // #6194
  { 8,  1}, // #6195
  {11,  1}, // #6196
  {12,  1}, // #6197
  { 2, 14}, // #6198
  { 3,  1}, // #6199
  { 7,  1}, // #6200
  { 8,  1}, // #6201
  {10,  1}, // #6202
  {11,  1}, // #6203
  {12,  2}, // #6204
  { 2, 14}, // #6205
  { 3,  1}, // #6206
  { 7,  1}, // #6207
  { 8,  1}, // #6208
  {11,  1}, // #6209
  {12,  1}, // #6210
  { 3,  1}, // #6211
  { 4,  1}, // #6212
  { 6,  1}, // #6213
  { 7,  2}, // #6214
  { 8,  2}, // #6215
  { 9,  2}, // #6216
  {10,  1}, // #6217
  {11,  3}, // #6218
  {12,  4}, // #6219
  { 3,  1}, // #6220
  { 4,  1}, // #6221
  { 6,  1}, // #6222
  { 7,  2}, // #6223
  { 8,  2}, // #6224
  { 9,  2}, // #6225
  {11,  3}, // #6226
  {12,  3}, // #6227
  { 3,  1}, // #6228
  { 4,  2}, // #6229
  { 6,  1}, // #6230
  { 7,  3}, // #6231
  { 8,  2}, // #6232
  { 9,  3}, // #6233
  {10,  1}, // #6234
  {11,  4}, // #6235
  {12,  5}, // #6236
  { 3,  1}, // #6237
  { 4,  2}, // #6238
  { 6,  1}, // #6239
  { 7,  3}, // #6240
  { 8,  2}, // #6241
  { 9,  3}, // #6242
  {11,  4}, // #6243
  {12,  4}, // #6244
  { 5,  1}, // #6245
  { 9,  1}, // #6246
  {10,  1}, // #6247
  {11,  1}, // #6248
  {12,  3}, // #6249
  { 3,  1}, // #6250
  { 7,  1}, // #6251
  { 8,  1}, // #6252
  { 9,  1}, // #6253
  {11,  2}, // #6254
  {12,  2}, // #6255
  {11, 31}, // #6256
  {12, 31}, // #6257
  { 4,  1}, // #6258
  { 6,  2}, // #6259
  { 7,  1}, // #6260
  { 8,  2}, // #6261
  { 9,  3}, // #6262
  {10,  1}, // #6263
  {11,  3}, // #6264
  {12,  4}, // #6265
  { 4,  1}, // #6266
  { 7,  1}, // #6267
  { 8,  1}, // #6268
  { 9,  1}, // #6269
  {10,  1}, // #6270
  {11,  4}, // #6271
  {12,  5}, // #6272
  { 4,  1}, // #6273
  { 7,  1}, // #6274
  { 8,  1}, // #6275
  { 9,  1}, // #6276
  {11,  4}, // #6277
  {12,  4}, // #6278
  { 4,  1}, // #6279
  { 7,  1}, // #6280
  { 9,  1}, // #6281
  {10,  1}, // #6282
  {11,  2}, // #6283
  {12,  3}, // #6284
  { 4,  1}, // #6285
  { 7,  1}, // #6286
  { 9,  1}, // #6287
  {11,  2}, // #6288
  {12,  2}, // #6289
  { 4,  1}, // #6290
  { 7,  1}, // #6291
  { 8,  1}, // #6292
  { 9,  1}, // #6293
  {10,  1}, // #6294
  {11,  3}, // #6295
  {12,  4}, // #6296
  { 4,  1}, // #6297
  { 7,  1}, // #6298
  { 8,  1}, // #6299
  { 9,  1}, // #6300
  {11,  3}, // #6301
  {12,  3}, // #6302
  { 3,  1}, // #6303
  { 5,  1}, // #6304
  { 6,  1}, // #6305
  { 7,  1}, // #6306
  { 8,  2}, // #6307
  { 9,  1}, // #6308
  {10,  1}, // #6309
  {11,  2}, // #6310
  {12,  4}, // #6311
  { 6,  1}, // #6312
  { 8,  1}, // #6313
  { 9,  2}, // #6314
  {11,  2}, // #6315
  {12,  2}, // #6316
  { 3,  1}, // #6317
  { 7,  1}, // #6318
  { 8,  1}, // #6319
  { 9,  2}, // #6320
  {10,  1}, // #6321
  {11,  3}, // #6322
  {12,  4}, // #6323
  { 3,  1}, // #6324
  { 7,  1}, // #6325
  { 8,  1}, // #6326
  { 9,  2}, // #6327
  {11,  3}, // #6328
  {12,  3}, // #6329
  {10,  1}, // #6330
  {11, 17}, // #6331
  {12, 18}, // #6332
  {11, 18}, // #6333
  {12, 18}, // #6334
  {10,  1}, // #6335
  {11,  7}, // #6336
  {12,  8}, // #6337
  {11,  8}, // #6338
  {12,  8}, // #6339
  { 3,  3}, // #6340
  { 7,  3}, // #6341
  { 8,  3}, // #6342
  {10,  1}, // #6343
  {11,  3}, // #6344
  {12,  4}, // #6345
  { 3,  3}, // #6346
  { 7,  3}, // #6347
  { 8,  3}, // #6348
  {11,  3}, // #6349
  {12,  3}, // #6350
  { 5,  1}, // #6351
  {10,  2}, // #6352
  {12,  3}, // #6353
  { 3,  1}, // #6354
  { 7,  1}, // #6355
  { 8,  1}, // #6356
  { 9,  1}, // #6357
  {10,  1}, // #6358
  {11,  2}, // #6359
  {12,  3}, // #6360
  { 3,  1}, // #6361
  { 6,  1}, // #6362
  { 7,  1}, // #6363
  { 8,  2}, // #6364
  { 9,  1}, // #6365
  {10,  1}, // #6366
  {11,  2}, // #6367
  {12,  3}, // #6368
  { 5,  1}, // #6369
  { 8,  2}, // #6370
  {10,  2}, // #6371
  {11,  2}, // #6372
  {12,  5}, // #6373
  { 5,  1}, // #6374
  { 8,  3}, // #6375
  {10,  2}, // #6376
  {11,  3}, // #6377
  {12,  6}, // #6378
  { 5,  1}, // #6379
  { 8,  1}, // #6380
  {10,  1}, // #6381
  {11,  1}, // #6382
  {12,  3}, // #6383
  { 5,  1}, // #6384
  { 8,  3}, // #6385
  {10,  2}, // #6386
  {11,  4}, // #6387
  {12,  7}, // #6388
  { 5,  1}, // #6389
  { 8,  1}, // #6390
  {10,  2}, // #6391
  {11,  2}, // #6392
  {12,  5}, // #6393
  { 2, 21}, // #6394
  { 3,  1}, // #6395
  { 7,  1}, // #6396
  { 8,  1}, // #6397
  {10,  1}, // #6398
  {11,  1}, // #6399
  {12,  2}, // #6400
  { 2, 21}, // #6401
  { 3,  1}, // #6402
  { 7,  1}, // #6403
  { 8,  1}, // #6404
  {11,  1}, // #6405
  {12,  1}, // #6406
  { 2, 24}, // #6407
  { 3,  1}, // #6408
  { 7,  1}, // #6409
  { 8,  1}, // #6410
  {11,  1}, // #6411
  {12,  1}, // #6412
  { 7,  1}, // #6413
  {10,  1}, // #6414
  {11,  1}, // #6415
  {12,  2}, // #6416
  { 4,  1}, // #6417
  { 5,  1}, // #6418
  { 7,  1}, // #6419
  { 9,  1}, // #6420
  {10,  1}, // #6421
  {11,  1}, // #6422
  {12,  3}, // #6423
  { 2, 44}, // #6424
  { 3,  2}, // #6425
  { 7,  2}, // #6426
  { 8,  3}, // #6427
  {10,  1}, // #6428
  {11,  3}, // #6429
  {12,  4}, // #6430
  { 2, 44}, // #6431
  { 3,  2}, // #6432
  { 7,  2}, // #6433
  { 8,  3}, // #6434
  {11,  3}, // #6435
  {12,  3}, // #6436
  { 2, 28}, // #6437
  { 3,  2}, // #6438
  { 7,  2}, // #6439
  { 8,  3}, // #6440
  {10,  1}, // #6441
  {11,  3}, // #6442
  {12,  4}, // #6443
  { 2, 28}, // #6444
  { 3,  2}, // #6445
  { 7,  2}, // #6446
  { 8,  3}, // #6447
  {11,  3}, // #6448
  {12,  3}, // #6449
  { 5,  1}, // #6450
  { 7,  1}, // #6451
  {10,  1}, // #6452
  {11,  1}, // #6453
  {12,  3}, // #6454
  { 8,  7}, // #6455
  {10,  4}, // #6456
  {11,  7}, // #6457
  {12, 11}, // #6458
  { 5,  1}, // #6459
  {10,  2}, // #6460
  {11,  2}, // #6461
  {12,  5}, // #6462
  { 6,  1}, // #6463
  { 7,  1}, // #6464
  { 8,  1}, // #6465
  { 9,  1}, // #6466
  {10,  1}, // #6467
  {11,  2}, // #6468
  {12,  3}, // #6469
  { 5,  1}, // #6470
  { 6,  2}, // #6471
  { 8,  2}, // #6472
  { 9,  2}, // #6473
  {10,  2}, // #6474
  {11,  2}, // #6475
  {12,  5}, // #6476
  { 4,  1}, // #6477
  { 5,  1}, // #6478
  { 7,  1}, // #6479
  { 9,  1}, // #6480
  {10,  2}, // #6481
  {11,  1}, // #6482
  {12,  4}, // #6483
  { 4,  1}, // #6484
  { 6,  3}, // #6485
  { 7,  1}, // #6486
  { 8,  5}, // #6487
  { 9,  4}, // #6488
  {11, 12}, // #6489
  {12, 12}, // #6490
  { 5,  1}, // #6491
  { 6,  1}, // #6492
  { 8,  1}, // #6493
  { 9,  1}, // #6494
  {10,  2}, // #6495
  {11,  1}, // #6496
  {12,  4}, // #6497
  { 6,  1}, // #6498
  { 8,  1}, // #6499
  { 9,  1}, // #6500
  {11,  4}, // #6501
  {12,  4}, // #6502
  { 4,  1}, // #6503
  { 6,  3}, // #6504
  { 7,  1}, // #6505
  { 8,  3}, // #6506
  { 9,  4}, // #6507
  {11,  8}, // #6508
  {12,  8}, // #6509
  { 5,  1}, // #6510
  { 6,  2}, // #6511
  { 7,  1}, // #6512
  { 8,  2}, // #6513
  { 9,  2}, // #6514
  {10,  1}, // #6515
  {11,  3}, // #6516
  {12,  5}, // #6517
  { 3,  1}, // #6518
  { 7,  1}, // #6519
  { 8,  1}, // #6520
  {11,  2}, // #6521
  {12,  2}, // #6522
  { 8,  2}, // #6523
  {11,  3}, // #6524
  {12,  3}, // #6525
  { 4,  1}, // #6526
  { 6,  1}, // #6527
  { 7,  1}, // #6528
  { 8,  5}, // #6529
  { 9,  2}, // #6530
  {11,  8}, // #6531
  {12,  8}, // #6532
  { 8,  8}, // #6533
  {11,  8}, // #6534
  {12,  8}, // #6535
  { 5,  1}, // #6536
  { 6,  1}, // #6537
  { 8,  1}, // #6538
  { 9,  1}, // #6539
  {10,  1}, // #6540
  {11,  1}, // #6541
  {12,  3}, // #6542
  { 5,  1}, // #6543
  {10,  1}, // #6544
  {11,  1}, // #6545
  {12,  3}, // #6546
  { 3,  1}, // #6547
  { 5,  1}, // #6548
  { 7,  1}, // #6549
  { 8,  1}, // #6550
  { 9,  1}, // #6551
  {10,  1}, // #6552
  {11,  2}, // #6553
  {12,  4}, // #6554
  { 5,  1}, // #6555
  { 6,  1}, // #6556
  { 7,  1}, // #6557
  { 8,  1}, // #6558
  { 9,  1}, // #6559
  {10,  1}, // #6560
  {11,  2}, // #6561
  {12,  4}, // #6562
  { 3,  1}, // #6563
  { 5,  1}, // #6564
  { 7,  1}, // #6565
  { 8,  1}, // #6566
  {10,  2}, // #6567
  {11,  1}, // #6568
  {12,  4}, // #6569
  { 4,  1}, // #6570
  { 6,  2}, // #6571
  { 7,  1}, // #6572
  { 8,  2}, // #6573
  { 9,  3}, // #6574
  {11,  4}, // #6575
  {12,  4}, // #6576
  {10,  2}, // #6577
  {11,  3}, // #6578
  {12,  5}, // #6579
  { 5,  1}, // #6580
  { 6,  1}, // #6581
  { 7,  1}, // #6582
  { 8,  1}, // #6583
  { 9,  1}, // #6584
  {10,  2}, // #6585
  {11,  2}, // #6586
  {12,  5}, // #6587
  { 5,  1}, // #6588
  { 8,  2}, // #6589
  {10,  2}, // #6590
  {11,  3}, // #6591
  {12,  6}, // #6592
  { 4,  2}, // #6593
  { 7,  2}, // #6594
  { 9,  2}, // #6595
  {10,  1}, // #6596
  {11,  2}, // #6597
  {12,  3}, // #6598
  { 8,  2}, // #6599
  {10,  1}, // #6600
  {11,  3}, // #6601
  {12,  4}, // #6602
  { 5,  1}, // #6603
  { 8,  2}, // #6604
  {10,  1}, // #6605
  {11,  2}, // #6606
  {12,  4}, // #6607
  { 3,  1}, // #6608
  { 4,  1}, // #6609
  { 8,  1}, // #6610
  { 9,  1}, // #6611
  {11,  2}, // #6612
  {12,  1}, // #6613
  {13,  2}, // #6614
  {14,  2}, // #6615
  {15,  2}, // #6616
  {16,  2}, // #6617
  {18,  2}, // #6618
  {19,  3}, // #6619
  {20,  3}, // #6620
  {22,  4}, // #6621
  {23,  4}, // #6622
  { 4,  1}, // #6623
  { 9,  1}, // #6624
  {11,  1}, // #6625
  {14,  1}, // #6626
  {15,  1}, // #6627
  {16,  2}, // #6628
  {17,  1}, // #6629
  {18,  1}, // #6630
  {19,  1}, // #6631
  {20,  1}, // #6632
  {21,  1}, // #6633
  {22,  2}, // #6634
  {23,  3}, // #6635
  { 4,  1}, // #6636
  { 9,  1}, // #6637
  {11,  1}, // #6638
  {14,  1}, // #6639
  {15,  1}, // #6640
  {16,  2}, // #6641
  {18,  1}, // #6642
  {19,  1}, // #6643
  {20,  1}, // #6644
  {22,  2}, // #6645
  {23,  2}, // #6646
  { 2, 17}, // #6647
  { 3,  1}, // #6648
  {11,  1}, // #6649
  {12,  1}, // #6650
  {13,  1}, // #6651
  {14,  1}, // #6652
  {19,  1}, // #6653
  {20,  1}, // #6654
  {22,  1}, // #6655
  {23,  1}, // #6656
  { 4,  1}, // #6657
  { 7,  1}, // #6658
  { 8,  1}, // #6659
  {11,  1}, // #6660
  {12,  1}, // #6661
  {13,  1}, // #6662
  {15,  2}, // #6663
  {16,  1}, // #6664
  {18,  1}, // #6665
  {19,  2}, // #6666
  {20,  1}, // #6667
  {21,  1}, // #6668
  {22,  2}, // #6669
  {23,  4}, // #6670
  { 2, 28}, // #6671
  { 3,  2}, // #6672
  {11,  2}, // #6673
  {12,  2}, // #6674
  {13,  2}, // #6675
  {14,  2}, // #6676
  {15,  1}, // #6677
  {17,  1}, // #6678
  {19,  3}, // #6679
  {20,  2}, // #6680
  {21,  1}, // #6681
  {22,  3}, // #6682
  {23,  4}, // #6683
  { 2, 28}, // #6684
  { 3,  2}, // #6685
  {11,  2}, // #6686
  {12,  2}, // #6687
  {13,  2}, // #6688
  {14,  2}, // #6689
  {15,  1}, // #6690
  {19,  3}, // #6691
  {20,  2}, // #6692
  {22,  3}, // #6693
  {23,  3}, // #6694
  { 2, 14}, // #6695
  { 3,  2}, // #6696
  {11,  2}, // #6697
  {12,  2}, // #6698
  {13,  2}, // #6699
  {14,  2}, // #6700
  {15,  1}, // #6701
  {17,  1}, // #6702
  {19,  3}, // #6703
  {20,  2}, // #6704
  {21,  1}, // #6705
  {22,  3}, // #6706
  {23,  4}, // #6707
  { 2, 14}, // #6708
  { 3,  2}, // #6709
  {11,  2}, // #6710
  {12,  2}, // #6711
  {13,  2}, // #6712
  {14,  2}, // #6713
  {15,  1}, // #6714
  {19,  3}, // #6715
  {20,  2}, // #6716
  {22,  3}, // #6717
  {23,  3}, // #6718
  { 4,  2}, // #6719
  {11,  2}, // #6720
  {15,  2}, // #6721
  {16,  2}, // #6722
  {19,  2}, // #6723
  {22,  2}, // #6724
  {23,  2}, // #6725
  { 3,  2}, // #6726
  { 4,  1}, // #6727
  { 8,  2}, // #6728
  { 9,  4}, // #6729
  {11,  5}, // #6730
  {12,  2}, // #6731
  {13,  4}, // #6732
  {14,  6}, // #6733
  {15,  3}, // #6734
  {16,  5}, // #6735
  {18,  6}, // #6736
  {19,  7}, // #6737
  {20,  8}, // #6738
  {22, 15}, // #6739
  {23, 15}, // #6740
  { 7,  1}, // #6741
  {12,  1}, // #6742
  {17,  2}, // #6743
  {21,  2}, // #6744
  {22,  2}, // #6745
  {23,  5}, // #6746
  {17,  1}, // #6747
  {21,  1}, // #6748
  {22, 14}, // #6749
  {23, 15}, // #6750
  {17,  2}, // #6751
  {21,  2}, // #6752
  {22,  3}, // #6753
  {23,  5}, // #6754
  { 9,  2}, // #6755
  {14,  2}, // #6756
  {16,  2}, // #6757
  {17,  1}, // #6758
  {18,  2}, // #6759
  {19,  1}, // #6760
  {20,  2}, // #6761
  {21,  1}, // #6762
  {22,  3}, // #6763
  {23,  4}, // #6764
  {17,  1}, // #6765
  {19, 16}, // #6766
  {21,  1}, // #6767
  {22, 16}, // #6768
  {23, 17}, // #6769
  { 3,  2}, // #6770
  { 8,  2}, // #6771
  {11,  2}, // #6772
  {12,  2}, // #6773
  {13,  4}, // #6774
  {14,  4}, // #6775
  {15,  3}, // #6776
  {17,  2}, // #6777
  {18,  2}, // #6778
  {19,  8}, // #6779
  {20,  6}, // #6780
  {21,  2}, // #6781
  {22, 10}, // #6782
  {23, 12}, // #6783
  { 3,  3}, // #6784
  { 8,  3}, // #6785
  {11,  3}, // #6786
  {12,  3}, // #6787
  {13,  6}, // #6788
  {14,  7}, // #6789
  {15,  4}, // #6790
  {17,  4}, // #6791
  {18,  3}, // #6792
  {19, 12}, // #6793
  {20, 10}, // #6794
  {21,  4}, // #6795
  {22, 16}, // #6796
  {23, 20}, // #6797
  { 3,  5}, // #6798
  { 8,  3}, // #6799
  {11,  5}, // #6800
  {12,  5}, // #6801
  {13,  8}, // #6802
  {14, 13}, // #6803
  {15,  4}, // #6804
  {17,  8}, // #6805
  {18,  3}, // #6806
  {19, 18}, // #6807
  {20, 16}, // #6808
  {21,  8}, // #6809
  {22, 26}, // #6810
  {23, 34}, // #6811
  { 3,  3}, // #6812
  { 8,  3}, // #6813
  {11,  3}, // #6814
  {12,  3}, // #6815
  {13,  6}, // #6816
  {14,  5}, // #6817
  {15,  4}, // #6818
  {17,  2}, // #6819
  {18,  3}, // #6820
  {19, 10}, // #6821
  {20,  8}, // #6822
  {21,  2}, // #6823
  {22, 12}, // #6824
  {23, 14}, // #6825
  { 3,  5}, // #6826
  { 8,  3}, // #6827
  {11,  5}, // #6828
  {12,  5}, // #6829
  {13,  8}, // #6830
  {14,  9}, // #6831
  {15,  4}, // #6832
  {17,  4}, // #6833
  {18,  3}, // #6834
  {19, 14}, // #6835
  {20, 12}, // #6836
  {21,  4}, // #6837
  {22, 18}, // #6838
  {23, 22}, // #6839
  { 3,  3}, // #6840
  { 8,  3}, // #6841
  {11,  3}, // #6842
  {12,  3}, // #6843
  {13,  6}, // #6844
  {14,  5}, // #6845
  {15,  4}, // #6846
  {17,  2}, // #6847
  {18,  3}, // #6848
  {19, 11}, // #6849
  {20,  8}, // #6850
  {21,  2}, // #6851
  {22, 13}, // #6852
  {23, 15}, // #6853
  {14,  1}, // #6854
  {17,  1}, // #6855
  {20,  1}, // #6856
  {21,  1}, // #6857
  {22,  3}, // #6858
  {23,  4}, // #6859
  { 9,  6}, // #6860
  {10,  2}, // #6861
  { 5,  2}, // #6862
  { 6,  2}, // #6863
  {10,  1}, // #6864
  { 5,  1}, // #6865
  { 6,  1}, // #6866
  {10,  1}, // #6867
  { 4,  5}, // #6868
  { 6,  5}, // #6869
  {10,  1}, // #6870
  { 4,  4}, // #6871
  { 6,  4}, // #6872
  {10,  1}, // #6873
  { 4,  1}, // #6874
  { 6,  1}, // #6875
  {10,  1}, // #6876
  { 7, 10}, // #6877
  { 8, 10}, // #6878
  { 9, 20}, // #6879
  {10,  1}, // #6880
  { 7,  1}, // #6881
  { 8,  1}, // #6882
  { 9,  2}, // #6883
  {10,  2}, // #6884
  { 4,  2}, // #6885
  { 6,  2}, // #6886
  {10,  1}, // #6887
  { 1, 25}, // #6888
  { 9,  1}, // #6889
  {10,  1}, // #6890
  { 2, 69}, // #6891
  { 4,  1}, // #6892
  { 6,  1}, // #6893
  {10,  1}, // #6894
  { 2, 39}, // #6895
  { 4,  1}, // #6896
  { 6,  1}, // #6897
  {10,  1}, // #6898
  { 2, 17}, // #6899
  { 4,  1}, // #6900
  { 6,  1}, // #6901
  {10,  1}, // #6902
  { 2, 32}, // #6903
  { 4,  1}, // #6904
  { 6,  1}, // #6905
  {10,  1}, // #6906
  { 5,  8}, // #6907
  { 6,  8}, // #6908
  {10,  1}, // #6909
  { 5, 12}, // #6910
  { 6, 12}, // #6911
  {10,  1}, // #6912
  { 4,  1}, // #6913
  { 6,  1}, // #6914
  {10,  2}, // #6915
  { 6, 10}, // #6916
  { 5,  6}, // #6917
  { 6,  6}, // #6918
  {10,  1}, // #6919
  { 8,  5}, // #6920
  { 9,  5}, // #6921
  {10,  1}, // #6922
  { 8,  4}, // #6923
  { 9,  4}, // #6924
  {10,  1}, // #6925
  { 8,  7}, // #6926
  { 9,  7}, // #6927
  {10,  1}, // #6928
  { 3,  4}, // #6929
  { 4,  1}, // #6930
  { 6,  1}, // #6931
  {10,  1}, // #6932
  { 3,  2}, // #6933
  { 4,  1}, // #6934
  { 6,  1}, // #6935
  {10,  1}, // #6936
  { 4, 10}, // #6937
  { 6, 10}, // #6938
  {10,  1}, // #6939
  { 4, 21}, // #6940
  { 6, 21}, // #6941
  {10,  1}, // #6942
  { 4, 17}, // #6943
  { 6, 17}, // #6944
  {10,  1}, // #6945
  { 4, 13}, // #6946
  { 6, 13}, // #6947
  {10,  1}, // #6948
  { 4, 11}, // #6949
  { 6, 11}, // #6950
  {10,  1}, // #6951
  { 4,  8}, // #6952
  { 6,  8}, // #6953
  {10,  1}, // #6954
  { 2, 70}, // #6955
  { 4,  1}, // #6956
  { 6,  1}, // #6957
  {10,  1}, // #6958
  { 2, 40}, // #6959
  { 4,  1}, // #6960
  { 6,  1}, // #6961
  {10,  1}, // #6962
  { 2, 35}, // #6963
  { 4,  1}, // #6964
  { 6,  1}, // #6965
  {10,  1}, // #6966
  { 2, 20}, // #6967
  { 4,  1}, // #6968
  { 6,  1}, // #6969
  {10,  1}, // #6970
  {26,  1}, // #6971
  {27,  1}, // #6972
  {15,  1}, // #6973
  {23,  1}, // #6974
  {24,  1}, // #6975
  {26,  1}, // #6976
  {27,  1}, // #6977
  {16,  1}, // #6978
  {24,  1}, // #6979
  {26,  1}, // #6980
  {27,  1}, // #6981
  { 7,  1}, // #6982
  {14,  1}, // #6983
  {16,  2}, // #6984
  {19,  1}, // #6985
  {20,  1}, // #6986
  {24,  2}, // #6987
  {25,  2}, // #6988
  {26,  3}, // #6989
  {27,  6}, // #6990
  {16,  1}, // #6991
  {19,  1}, // #6992
  {24,  1}, // #6993
  {25,  1}, // #6994
  {26,  1}, // #6995
  {27,  2}, // #6996
  { 4,  1}, // #6997
  {13,  1}, // #6998
  {17,  1}, // #6999
  {18,  1}, // #7000
  {23,  1}, // #7001
  {26,  1}, // #7002
  {27,  1}, // #7003
  { 7,  1}, // #7004
  {14,  1}, // #7005
  {20,  1}, // #7006
  {25,  1}, // #7007
  {27,  2}, // #7008
  {19,  1}, // #7009
  {25,  1}, // #7010
  {27,  1}, // #7011
  { 7,  1}, // #7012
  {14,  1}, // #7013
  {19,  1}, // #7014
  {20,  1}, // #7015
  {25,  2}, // #7016
  {26,  1}, // #7017
  {27,  4}, // #7018
  { 3,  1}, // #7019
  {13,  1}, // #7020
  {14,  1}, // #7021
  {15,  1}, // #7022
  {16,  1}, // #7023
  {23,  1}, // #7024
  {24,  1}, // #7025
  {26,  1}, // #7026
  {27,  1}, // #7027
  {19,  1}, // #7028
  {25,  1}, // #7029
  {26,  1}, // #7030
  {27,  2}, // #7031
  {13,  1}, // #7032
  {19,  1}, // #7033
  {23,  1}, // #7034
  {25,  1}, // #7035
  {26,  1}, // #7036
  {27,  2}, // #7037
  {13,  1}, // #7038
  {23,  1}, // #7039
  {26,  1}, // #7040
  {27,  1}, // #7041
  { 3,  1}, // #7042
  {13,  1}, // #7043
  {14,  1}, // #7044
  {15,  1}, // #7045
  {16,  1}, // #7046
  {19,  1}, // #7047
  {23,  1}, // #7048
  {24,  1}, // #7049
  {25,  1}, // #7050
  {26,  1}, // #7051
  {27,  2}, // #7052
  { 3,  2}, // #7053
  {13,  2}, // #7054
  {14,  2}, // #7055
  {15,  2}, // #7056
  {16,  2}, // #7057
  {19,  1}, // #7058
  {23,  2}, // #7059
  {24,  2}, // #7060
  {25,  1}, // #7061
  {26,  2}, // #7062
  {27,  3}, // #7063
  { 3,  2}, // #7064
  {13,  2}, // #7065
  {14,  2}, // #7066
  {15,  2}, // #7067
  {16,  2}, // #7068
  {23,  2}, // #7069
  {24,  2}, // #7070
  {26,  2}, // #7071
  {27,  2}, // #7072
  { 3,  3}, // #7073
  { 8,  6}, // #7074
  {13,  3}, // #7075
  {14,  3}, // #7076
  {15,  9}, // #7077
  {16,  3}, // #7078
  {17,  6}, // #7079
  {19,  1}, // #7080
  {21,  6}, // #7081
  {23, 10}, // #7082
  {24,  9}, // #7083
  {25,  1}, // #7084
  {26, 10}, // #7085
  {27, 11}, // #7086
  { 3,  3}, // #7087
  { 8,  6}, // #7088
  {13,  3}, // #7089
  {14,  3}, // #7090
  {15,  9}, // #7091
  {16,  3}, // #7092
  {17,  6}, // #7093
  {21,  6}, // #7094
  {23, 11}, // #7095
  {24,  9}, // #7096
  {26, 11}, // #7097
  {27, 11}, // #7098
  {16,  1}, // #7099
  {17,  1}, // #7100
  {19,  1}, // #7101
  {23,  1}, // #7102
  {24,  1}, // #7103
  {25,  1}, // #7104
  {26,  2}, // #7105
  {27,  3}, // #7106
  {16,  1}, // #7107
  {17,  1}, // #7108
  {23,  1}, // #7109
  {24,  1}, // #7110
  {26,  2}, // #7111
  {27,  2}, // #7112
  {19,  1}, // #7113
  {23,  2}, // #7114
  {25,  1}, // #7115
  {26,  2}, // #7116
  {27,  3}, // #7117
  {23,  2}, // #7118
  {26,  2}, // #7119
  {27,  2}, // #7120
  {17,  1}, // #7121
  {19,  1}, // #7122
  {23,  1}, // #7123
  {25,  1}, // #7124
  {26,  1}, // #7125
  {27,  2}, // #7126
  {17,  1}, // #7127
  {23,  1}, // #7128
  {26,  1}, // #7129
  {27,  1}, // #7130
  { 4,  1}, // #7131
  {13,  1}, // #7132
  {17,  1}, // #7133
  {18,  1}, // #7134
  {19,  1}, // #7135
  {23,  1}, // #7136
  {25,  1}, // #7137
  {26,  1}, // #7138
  {27,  2}, // #7139
  { 7,  1}, // #7140
  {14,  1}, // #7141
  {16,  1}, // #7142
  {19,  1}, // #7143
  {20,  1}, // #7144
  {24,  1}, // #7145
  {25,  2}, // #7146
  {26,  1}, // #7147
  {27,  4}, // #7148
  {26,  3}, // #7149
  {27,  3}, // #7150
  {16,  2}, // #7151
  {24,  2}, // #7152
  {26,  5}, // #7153
  {27,  5}, // #7154
  { 8,  1}, // #7155
  {13,  1}, // #7156
  {15,  1}, // #7157
  {17,  1}, // #7158
  {19,  1}, // #7159
  {21,  1}, // #7160
  {23,  2}, // #7161
  {24,  1}, // #7162
  {25,  1}, // #7163
  {26,  2}, // #7164
  {27,  3}, // #7165
  { 8,  1}, // #7166
  {13,  1}, // #7167
  {15,  1}, // #7168
  {17,  1}, // #7169
  {21,  1}, // #7170
  {23,  2}, // #7171
  {24,  1}, // #7172
  {26,  2}, // #7173
  {27,  2}, // #7174
  {13,  2}, // #7175
  {19,  1}, // #7176
  {23,  2}, // #7177
  {25,  1}, // #7178
  {26,  2}, // #7179
  {27,  3}, // #7180
  {13,  2}, // #7181
  {23,  2}, // #7182
  {26,  2}, // #7183
  {27,  2}, // #7184
  { 1, 10}, // #7185
  { 3,  1}, // #7186
  {13,  1}, // #7187
  {14,  1}, // #7188
  {15,  1}, // #7189
  {16,  1}, // #7190
  {19,  1}, // #7191
  {23,  1}, // #7192
  {24,  1}, // #7193
  {25,  1}, // #7194
  {26,  1}, // #7195
  {27,  2}, // #7196
  { 3,  7}, // #7197
  { 4,  2}, // #7198
  { 8,  8}, // #7199
  { 9,  3}, // #7200
  {13,  9}, // #7201
  {14,  7}, // #7202
  {15, 16}, // #7203
  {16, 10}, // #7204
  {17, 10}, // #7205
  {18,  5}, // #7206
  {21, 11}, // #7207
  {23, 18}, // #7208
  {24, 19}, // #7209
  {26, 32}, // #7210
  {27, 32}, // #7211
  { 1, 10}, // #7212
  { 3,  1}, // #7213
  {13,  1}, // #7214
  {14,  1}, // #7215
  {15,  1}, // #7216
  {16,  1}, // #7217
  {23,  1}, // #7218
  {24,  1}, // #7219
  {26,  1}, // #7220
  {27,  1}, // #7221
  { 2,  4}, // #7222
  { 3,  1}, // #7223
  {13,  1}, // #7224
  {14,  1}, // #7225
  {15,  1}, // #7226
  {16,  1}, // #7227
  {19,  1}, // #7228
  {23,  1}, // #7229
  {24,  1}, // #7230
  {25,  1}, // #7231
  {26,  1}, // #7232
  {27,  2}, // #7233
  { 2,  4}, // #7234
  { 3,  1}, // #7235
  {13,  1}, // #7236
  {14,  1}, // #7237
  {15,  1}, // #7238
  {16,  1}, // #7239
  {23,  1}, // #7240
  {24,  1}, // #7241
  {26,  1}, // #7242
  {27,  1}, // #7243
  { 2,  3}, // #7244
  { 3,  1}, // #7245
  {13,  1}, // #7246
  {14,  1}, // #7247
  {15,  1}, // #7248
  {16,  1}, // #7249
  {19,  1}, // #7250
  {23,  1}, // #7251
  {24,  1}, // #7252
  {25,  1}, // #7253
  {26,  1}, // #7254
  {27,  2}, // #7255
  { 2,  3}, // #7256
  { 3,  1}, // #7257
  {13,  1}, // #7258
  {14,  1}, // #7259
  {15,  1}, // #7260
  {16,  1}, // #7261
  {23,  1}, // #7262
  {24,  1}, // #7263
  {26,  1}, // #7264
  {27,  1}, // #7265
  { 8,  1}, // #7266
  {15,  1}, // #7267
  {17,  1}, // #7268
  {19,  1}, // #7269
  {21,  1}, // #7270
  {23,  3}, // #7271
  {24,  1}, // #7272
  {25,  1}, // #7273
  {26,  3}, // #7274
  {27,  4}, // #7275
  { 8,  1}, // #7276
  {15,  1}, // #7277
  {17,  1}, // #7278
  {21,  1}, // #7279
  {23,  3}, // #7280
  {24,  1}, // #7281
  {26,  3}, // #7282
  {27,  3}, // #7283
  { 8,  1}, // #7284
  {15,  1}, // #7285
  {17,  1}, // #7286
  {19,  1}, // #7287
  {21,  1}, // #7288
  {23,  4}, // #7289
  {24,  1}, // #7290
  {25,  1}, // #7291
  {26,  4}, // #7292
  {27,  5}, // #7293
  { 8,  1}, // #7294
  {15,  1}, // #7295
  {17,  1}, // #7296
  {21,  1}, // #7297
  {23,  4}, // #7298
  {24,  1}, // #7299
  {26,  4}, // #7300
  {27,  4}, // #7301
  { 7,  1}, // #7302
  { 8,  1}, // #7303
  {14,  1}, // #7304
  {15,  1}, // #7305
  {17,  1}, // #7306
  {20,  1}, // #7307
  {21,  1}, // #7308
  {23,  1}, // #7309
  {24,  1}, // #7310
  {25,  1}, // #7311
  {26,  1}, // #7312
  {27,  3}, // #7313
  { 3,  1}, // #7314
  { 8,  1}, // #7315
  {13,  1}, // #7316
  {14,  1}, // #7317
  {15,  2}, // #7318
  {16,  1}, // #7319
  {17,  1}, // #7320
  {21,  1}, // #7321
  {23,  2}, // #7322
  {24,  2}, // #7323
  {26,  2}, // #7324
  {27,  2}, // #7325
  {15,  9}, // #7326
  {23,  9}, // #7327
  {24,  9}, // #7328
  {26, 10}, // #7329
  {27, 10}, // #7330
  {15,  2}, // #7331
  {23,  2}, // #7332
  {24,  2}, // #7333
  {26,  2}, // #7334
  {27,  2}, // #7335
  { 8,  2}, // #7336
  {15,  2}, // #7337
  {17,  2}, // #7338
  {19,  1}, // #7339
  {21,  2}, // #7340
  {23,  3}, // #7341
  {24,  2}, // #7342
  {25,  1}, // #7343
  {26,  3}, // #7344
  {27,  4}, // #7345
  { 8,  2}, // #7346
  {15,  2}, // #7347
  {17,  2}, // #7348
  {21,  2}, // #7349
  {23,  3}, // #7350
  {24,  2}, // #7351
  {26,  3}, // #7352
  {27,  3}, // #7353
  { 3,  2}, // #7354
  { 8,  4}, // #7355
  {13,  2}, // #7356
  {14,  2}, // #7357
  {15,  6}, // #7358
  {16,  2}, // #7359
  {17,  4}, // #7360
  {19,  1}, // #7361
  {21,  4}, // #7362
  {23,  6}, // #7363
  {24,  6}, // #7364
  {25,  1}, // #7365
  {26,  7}, // #7366
  {27,  8}, // #7367
  { 3,  4}, // #7368
  { 4,  2}, // #7369
  { 8,  4}, // #7370
  { 9,  8}, // #7371
  {13,  6}, // #7372
  {14,  4}, // #7373
  {15,  8}, // #7374
  {16, 26}, // #7375
  {17,  6}, // #7376
  {18, 10}, // #7377
  {21, 12}, // #7378
  {23, 10}, // #7379
  {24, 30}, // #7380
  {26, 66}, // #7381
  {27, 66}, // #7382
  { 4,  1}, // #7383
  {13,  1}, // #7384
  {16,  1}, // #7385
  {17,  1}, // #7386
  {18,  1}, // #7387
  {19,  1}, // #7388
  {23,  1}, // #7389
  {24,  1}, // #7390
  {25,  1}, // #7391
  {26,  4}, // #7392
  {27,  5}, // #7393
  { 4,  1}, // #7394
  {13,  1}, // #7395
  {16,  1}, // #7396
  {17,  1}, // #7397
  {18,  1}, // #7398
  {23,  1}, // #7399
  {24,  1}, // #7400
  {26,  4}, // #7401
  {27,  4}, // #7402
  { 4,  1}, // #7403
  {13,  1}, // #7404
  {17,  1}, // #7405
  {18,  1}, // #7406
  {19,  1}, // #7407
  {23,  1}, // #7408
  {25,  1}, // #7409
  {26,  2}, // #7410
  {27,  3}, // #7411
  { 4,  1}, // #7412
  {13,  1}, // #7413
  {17,  1}, // #7414
  {18,  1}, // #7415
  {23,  1}, // #7416
  {26,  2}, // #7417
  {27,  2}, // #7418
  { 4,  1}, // #7419
  {13,  1}, // #7420
  {16,  1}, // #7421
  {17,  1}, // #7422
  {18,  1}, // #7423
  {19,  1}, // #7424
  {23,  1}, // #7425
  {24,  1}, // #7426
  {25,  1}, // #7427
  {26,  3}, // #7428
  {27,  4}, // #7429
  { 4,  1}, // #7430
  {13,  1}, // #7431
  {16,  1}, // #7432
  {17,  1}, // #7433
  {18,  1}, // #7434
  {23,  1}, // #7435
  {24,  1}, // #7436
  {26,  3}, // #7437
  {27,  3}, // #7438
  { 4,  1}, // #7439
  { 8,  1}, // #7440
  {13,  1}, // #7441
  {15,  1}, // #7442
  {17,  2}, // #7443
  {18,  1}, // #7444
  {19,  1}, // #7445
  {21,  1}, // #7446
  {23,  2}, // #7447
  {24,  1}, // #7448
  {25,  1}, // #7449
  {26,  2}, // #7450
  {27,  3}, // #7451
  { 4,  1}, // #7452
  { 8,  1}, // #7453
  {13,  1}, // #7454
  {15,  1}, // #7455
  {17,  2}, // #7456
  {18,  1}, // #7457
  {21,  1}, // #7458
  {23,  2}, // #7459
  {24,  1}, // #7460
  {26,  2}, // #7461
  {27,  2}, // #7462
  { 8,  1}, // #7463
  {15,  1}, // #7464
  {17,  1}, // #7465
  {21,  1}, // #7466
  {23,  1}, // #7467
  {24,  1}, // #7468
  {26,  1}, // #7469
  {27,  1}, // #7470
  { 3,  1}, // #7471
  {13,  1}, // #7472
  {14,  1}, // #7473
  {15,  1}, // #7474
  {16,  1}, // #7475
  {19,  1}, // #7476
  {23,  1}, // #7477
  {24,  1}, // #7478
  {25,  1}, // #7479
  {26,  2}, // #7480
  {27,  3}, // #7481
  { 7,  1}, // #7482
  {14,  1}, // #7483
  {19,  1}, // #7484
  {20,  1}, // #7485
  {25,  1}, // #7486
  {27,  2}, // #7487
  {15,  1}, // #7488
  {19,  1}, // #7489
  {23,  1}, // #7490
  {24,  1}, // #7491
  {25,  1}, // #7492
  {26,  1}, // #7493
  {27,  2}, // #7494
  { 8,  1}, // #7495
  {15,  1}, // #7496
  {17,  1}, // #7497
  {19,  1}, // #7498
  {21,  1}, // #7499
  {23,  1}, // #7500
  {24,  1}, // #7501
  {25,  1}, // #7502
  {26,  1}, // #7503
  {27,  2}, // #7504
  { 8,  2}, // #7505
  {15,  3}, // #7506
  {17,  2}, // #7507
  {19,  1}, // #7508
  {21,  2}, // #7509
  {23,  3}, // #7510
  {24,  3}, // #7511
  {25,  1}, // #7512
  {26,  3}, // #7513
  {27,  4}, // #7514
  { 8,  2}, // #7515
  {15,  3}, // #7516
  {17,  2}, // #7517
  {21,  2}, // #7518
  {23,  3}, // #7519
  {24,  3}, // #7520
  {26,  3}, // #7521
  {27,  3}, // #7522
  { 8,  2}, // #7523
  {15,  2}, // #7524
  {17,  2}, // #7525
  {21,  2}, // #7526
  {23,  2}, // #7527
  {24,  2}, // #7528
  {26,  2}, // #7529
  {27,  2}, // #7530
  { 8,  2}, // #7531
  {15,  2}, // #7532
  {17,  2}, // #7533
  {19,  1}, // #7534
  {21,  2}, // #7535
  {23,  2}, // #7536
  {24,  2}, // #7537
  {25,  1}, // #7538
  {26,  2}, // #7539
  {27,  3}, // #7540
  { 3,  4}, // #7541
  { 8,  3}, // #7542
  {13,  4}, // #7543
  {14,  4}, // #7544
  {15,  7}, // #7545
  {16,  4}, // #7546
  {17,  3}, // #7547
  {19,  1}, // #7548
  {21,  3}, // #7549
  {23,  7}, // #7550
  {24,  7}, // #7551
  {25,  1}, // #7552
  {26,  8}, // #7553
  {27,  9}, // #7554
  { 3,  4}, // #7555
  { 8,  3}, // #7556
  {13,  4}, // #7557
  {14,  4}, // #7558
  {15,  7}, // #7559
  {16,  4}, // #7560
  {17,  3}, // #7561
  {21,  3}, // #7562
  {23,  7}, // #7563
  {24,  7}, // #7564
  {26,  8}, // #7565
  {27,  8}, // #7566
  { 3,  4}, // #7567
  { 8,  3}, // #7568
  {13,  4}, // #7569
  {14,  4}, // #7570
  {15,  7}, // #7571
  {16,  4}, // #7572
  {17,  3}, // #7573
  {19,  1}, // #7574
  {21,  3}, // #7575
  {23,  8}, // #7576
  {24,  7}, // #7577
  {25,  1}, // #7578
  {26,  9}, // #7579
  {27, 10}, // #7580
  { 3,  4}, // #7581
  { 8,  3}, // #7582
  {13,  4}, // #7583
  {14,  4}, // #7584
  {15,  7}, // #7585
  {16,  4}, // #7586
  {17,  3}, // #7587
  {21,  3}, // #7588
  {23,  8}, // #7589
  {24,  7}, // #7590
  {26,  9}, // #7591
  {27,  9}, // #7592
  { 3,  3}, // #7593
  {13,  3}, // #7594
  {14,  3}, // #7595
  {15,  3}, // #7596
  {16,  3}, // #7597
  {19,  1}, // #7598
  {23,  3}, // #7599
  {24,  3}, // #7600
  {25,  1}, // #7601
  {26,  3}, // #7602
  {27,  4}, // #7603
  { 3,  3}, // #7604
  {13,  3}, // #7605
  {14,  3}, // #7606
  {15,  3}, // #7607
  {16,  3}, // #7608
  {23,  3}, // #7609
  {24,  3}, // #7610
  {26,  3}, // #7611
  {27,  3}, // #7612
  { 7,  1}, // #7613
  {14,  1}, // #7614
  {19,  1}, // #7615
  {20,  1}, // #7616
  {25,  2}, // #7617
  {27,  3}, // #7618
  { 3,  1}, // #7619
  { 8,  1}, // #7620
  {13,  1}, // #7621
  {14,  1}, // #7622
  {15,  2}, // #7623
  {16,  1}, // #7624
  {17,  1}, // #7625
  {19,  1}, // #7626
  {21,  1}, // #7627
  {23,  2}, // #7628
  {24,  2}, // #7629
  {25,  1}, // #7630
  {26,  2}, // #7631
  {27,  3}, // #7632
  { 7,  1}, // #7633
  {14,  1}, // #7634
  {16,  3}, // #7635
  {19,  1}, // #7636
  {20,  1}, // #7637
  {24,  3}, // #7638
  {25,  2}, // #7639
  {26,  3}, // #7640
  {27,  6}, // #7641
  {16,  3}, // #7642
  {24,  3}, // #7643
  {26,  3}, // #7644
  {27,  3}, // #7645
  { 7,  1}, // #7646
  {14,  1}, // #7647
  {16,  1}, // #7648
  {20,  1}, // #7649
  {24,  1}, // #7650
  {25,  1}, // #7651
  {26,  1}, // #7652
  {27,  3}, // #7653
  { 4,  1}, // #7654
  {13,  1}, // #7655
  {16,  2}, // #7656
  {17,  1}, // #7657
  {18,  1}, // #7658
  {19,  1}, // #7659
  {23,  1}, // #7660
  {24,  2}, // #7661
  {25,  2}, // #7662
  {26,  4}, // #7663
  {27,  6}, // #7664
  { 4,  1}, // #7665
  {13,  1}, // #7666
  {17,  1}, // #7667
  {18,  1}, // #7668
  {19,  1}, // #7669
  {23,  1}, // #7670
  {25,  2}, // #7671
  {26,  2}, // #7672
  {27,  4}, // #7673
  { 4,  1}, // #7674
  {13,  1}, // #7675
  {16,  2}, // #7676
  {17,  1}, // #7677
  {18,  1}, // #7678
  {23,  1}, // #7679
  {24,  2}, // #7680
  {26,  4}, // #7681
  {27,  4}, // #7682
  { 2,  6}, // #7683
  { 3,  1}, // #7684
  {13,  1}, // #7685
  {14,  1}, // #7686
  {15,  1}, // #7687
  {16,  1}, // #7688
  {19,  1}, // #7689
  {23,  1}, // #7690
  {24,  1}, // #7691
  {25,  1}, // #7692
  {26,  1}, // #7693
  {27,  2}, // #7694
  { 2,  6}, // #7695
  { 3,  1}, // #7696
  {13,  1}, // #7697
  {14,  1}, // #7698
  {15,  1}, // #7699
  {16,  1}, // #7700
  {23,  1}, // #7701
  {24,  1}, // #7702
  {26,  1}, // #7703
  {27,  1}, // #7704
  { 2,  7}, // #7705
  { 3,  1}, // #7706
  {13,  1}, // #7707
  {14,  1}, // #7708
  {15,  1}, // #7709
  {16,  1}, // #7710
  {23,  1}, // #7711
  {24,  1}, // #7712
  {26,  1}, // #7713
  {27,  1}, // #7714
  {15,  2}, // #7715
  {19,  1}, // #7716
  {23,  2}, // #7717
  {24,  2}, // #7718
  {25,  1}, // #7719
  {26,  2}, // #7720
  {27,  3}, // #7721
  { 7,  1}, // #7722
  { 8,  1}, // #7723
  {13,  1}, // #7724
  {14,  1}, // #7725
  {15,  1}, // #7726
  {17,  1}, // #7727
  {20,  1}, // #7728
  {21,  1}, // #7729
  {23,  2}, // #7730
  {24,  1}, // #7731
  {25,  1}, // #7732
  {26,  2}, // #7733
  {27,  4}, // #7734
  { 7,  1}, // #7735
  { 8,  1}, // #7736
  {14,  1}, // #7737
  {15,  2}, // #7738
  {17,  1}, // #7739
  {20,  1}, // #7740
  {21,  1}, // #7741
  {23,  2}, // #7742
  {24,  2}, // #7743
  {25,  1}, // #7744
  {26,  2}, // #7745
  {27,  4}, // #7746
  { 8,  1}, // #7747
  {15,  2}, // #7748
  {17,  1}, // #7749
  {21,  1}, // #7750
  {23,  2}, // #7751
  {24,  2}, // #7752
  {26,  2}, // #7753
  {27,  2}, // #7754
  { 2,  8}, // #7755
  { 3,  1}, // #7756
  {13,  1}, // #7757
  {14,  1}, // #7758
  {15,  1}, // #7759
  {16,  1}, // #7760
  {19,  1}, // #7761
  {23,  1}, // #7762
  {24,  1}, // #7763
  {25,  1}, // #7764
  {26,  1}, // #7765
  {27,  2}, // #7766
  { 2,  8}, // #7767
  { 3,  1}, // #7768
  {13,  1}, // #7769
  {14,  1}, // #7770
  {15,  1}, // #7771
  {16,  1}, // #7772
  {23,  1}, // #7773
  {24,  1}, // #7774
  {26,  1}, // #7775
  {27,  1}, // #7776
  { 2, 16}, // #7777
  { 3,  2}, // #7778
  { 8,  1}, // #7779
  {13,  2}, // #7780
  {14,  2}, // #7781
  {15,  3}, // #7782
  {16,  2}, // #7783
  {17,  1}, // #7784
  {19,  1}, // #7785
  {21,  1}, // #7786
  {23,  3}, // #7787
  {24,  3}, // #7788
  {25,  1}, // #7789
  {26,  3}, // #7790
  {27,  4}, // #7791
  { 2, 16}, // #7792
  { 3,  2}, // #7793
  { 8,  1}, // #7794
  {13,  2}, // #7795
  {14,  2}, // #7796
  {15,  3}, // #7797
  {16,  2}, // #7798
  {17,  1}, // #7799
  {21,  1}, // #7800
  {23,  3}, // #7801
  {24,  3}, // #7802
  {26,  3}, // #7803
  {27,  3}, // #7804
  { 2,  5}, // #7805
  { 3,  1}, // #7806
  {13,  1}, // #7807
  {14,  1}, // #7808
  {15,  1}, // #7809
  {16,  1}, // #7810
  {19,  1}, // #7811
  {23,  1}, // #7812
  {24,  1}, // #7813
  {25,  1}, // #7814
  {26,  1}, // #7815
  {27,  2}, // #7816
  { 2,  5}, // #7817
  { 3,  1}, // #7818
  {13,  1}, // #7819
  {14,  1}, // #7820
  {15,  1}, // #7821
  {16,  1}, // #7822
  {23,  1}, // #7823
  {24,  1}, // #7824
  {26,  1}, // #7825
  {27,  1}, // #7826
  { 2, 10}, // #7827
  { 3,  2}, // #7828
  { 8,  1}, // #7829
  {13,  2}, // #7830
  {14,  2}, // #7831
  {15,  3}, // #7832
  {16,  2}, // #7833
  {17,  1}, // #7834
  {19,  1}, // #7835
  {21,  1}, // #7836
  {23,  3}, // #7837
  {24,  3}, // #7838
  {25,  1}, // #7839
  {26,  3}, // #7840
  {27,  4}, // #7841
  { 2, 10}, // #7842
  { 3,  2}, // #7843
  { 8,  1}, // #7844
  {13,  2}, // #7845
  {14,  2}, // #7846
  {15,  3}, // #7847
  {16,  2}, // #7848
  {17,  1}, // #7849
  {21,  1}, // #7850
  {23,  3}, // #7851
  {24,  3}, // #7852
  {26,  3}, // #7853
  {27,  3}, // #7854
  { 3,  1}, // #7855
  {13,  1}, // #7856
  {14,  1}, // #7857
  {15,  1}, // #7858
  {16,  1}, // #7859
  {23,  1}, // #7860
  {24,  1}, // #7861
  {25,  1}, // #7862
  {26,  1}, // #7863
  {27,  2}, // #7864
  { 2, 12}, // #7865
  { 3,  1}, // #7866
  {13,  1}, // #7867
  {14,  1}, // #7868
  {15,  1}, // #7869
  {16,  1}, // #7870
  {19,  1}, // #7871
  {23,  1}, // #7872
  {24,  1}, // #7873
  {25,  1}, // #7874
  {26,  1}, // #7875
  {27,  2}, // #7876
  { 2, 12}, // #7877
  { 3,  1}, // #7878
  {13,  1}, // #7879
  {14,  1}, // #7880
  {15,  1}, // #7881
  {16,  1}, // #7882
  {23,  1}, // #7883
  {24,  1}, // #7884
  {26,  1}, // #7885
  {27,  1}, // #7886
  { 2, 24}, // #7887
  { 3,  2}, // #7888
  { 8,  1}, // #7889
  {13,  2}, // #7890
  {14,  2}, // #7891
  {15,  3}, // #7892
  {16,  2}, // #7893
  {17,  1}, // #7894
  {19,  1}, // #7895
  {21,  1}, // #7896
  {23,  3}, // #7897
  {24,  3}, // #7898
  {25,  1}, // #7899
  {26,  3}, // #7900
  {27,  4}, // #7901
  { 2, 24}, // #7902
  { 3,  2}, // #7903
  { 8,  1}, // #7904
  {13,  2}, // #7905
  {14,  2}, // #7906
  {15,  3}, // #7907
  {16,  2}, // #7908
  {17,  1}, // #7909
  {21,  1}, // #7910
  {23,  3}, // #7911
  {24,  3}, // #7912
  {26,  3}, // #7913
  {27,  3}, // #7914
  { 2, 12}, // #7915
  { 3,  2}, // #7916
  { 8,  1}, // #7917
  {13,  2}, // #7918
  {14,  2}, // #7919
  {15,  3}, // #7920
  {16,  2}, // #7921
  {17,  1}, // #7922
  {19,  1}, // #7923
  {21,  1}, // #7924
  {23,  3}, // #7925
  {24,  3}, // #7926
  {25,  1}, // #7927
  {26,  3}, // #7928
  {27,  4}, // #7929
  { 2, 12}, // #7930
  { 3,  2}, // #7931
  { 8,  1}, // #7932
  {13,  2}, // #7933
  {14,  2}, // #7934
  {15,  3}, // #7935
  {16,  2}, // #7936
  {17,  1}, // #7937
  {21,  1}, // #7938
  {23,  3}, // #7939
  {24,  3}, // #7940
  {26,  3}, // #7941
  {27,  3}, // #7942
  {16,  1}, // #7943
  {19,  1}, // #7944
  {24,  1}, // #7945
  {25,  2}, // #7946
  {26,  3}, // #7947
  {27,  5}, // #7948
  { 4,  2}, // #7949
  {13,  2}, // #7950
  {16,  4}, // #7951
  {17,  3}, // #7952
  {18,  2}, // #7953
  {19,  1}, // #7954
  {23,  3}, // #7955
  {24,  4}, // #7956
  {25,  2}, // #7957
  {26,  9}, // #7958
  {27, 11}, // #7959
  { 3,  2}, // #7960
  { 4,  1}, // #7961
  { 8,  2}, // #7962
  { 9,  4}, // #7963
  {13,  3}, // #7964
  {14,  2}, // #7965
  {15,  6}, // #7966
  {16,  6}, // #7967
  {17,  3}, // #7968
  {18,  5}, // #7969
  {21,  6}, // #7970
  {23,  7}, // #7971
  {24, 10}, // #7972
  {26, 15}, // #7973
  {27, 15}, // #7974
  { 8,  2}, // #7975
  {13,  1}, // #7976
  {15,  2}, // #7977
  {17,  2}, // #7978
  {21,  2}, // #7979
  {23,  3}, // #7980
  {24,  2}, // #7981
  {26,  3}, // #7982
  {27,  3}, // #7983
  { 3,  1}, // #7984
  { 8,  1}, // #7985
  {13,  2}, // #7986
  {14,  1}, // #7987
  {15,  2}, // #7988
  {16,  1}, // #7989
  {17,  1}, // #7990
  {21,  1}, // #7991
  {23,  3}, // #7992
  {24,  2}, // #7993
  {26,  3}, // #7994
  {27,  3}, // #7995
  {19,  1}, // #7996
  {25,  1}, // #7997
  {26,  2}, // #7998
  {27,  3}, // #7999
  { 9,  1}, // #8000
  {16,  1}, // #8001
  {18,  1}, // #8002
  {21,  1}, // #8003
  {24,  1}, // #8004
  {26,  3}, // #8005
  {27,  3}, // #8006
  { 7,  1}, // #8007
  { 9,  1}, // #8008
  {14,  1}, // #8009
  {16,  2}, // #8010
  {18,  1}, // #8011
  {19,  1}, // #8012
  {20,  1}, // #8013
  {21,  1}, // #8014
  {24,  2}, // #8015
  {25,  2}, // #8016
  {26,  5}, // #8017
  {27,  8}, // #8018
  {16,  1}, // #8019
  {24,  1}, // #8020
  {26,  2}, // #8021
  {27,  2}, // #8022
  { 3,  1}, // #8023
  {13,  1}, // #8024
  {14,  1}, // #8025
  {15,  2}, // #8026
  {16,  1}, // #8027
  {19,  1}, // #8028
  {23,  2}, // #8029
  {24,  2}, // #8030
  {25,  1}, // #8031
  {26,  2}, // #8032
  {27,  3}, // #8033
  {16,  2}, // #8034
  {24,  2}, // #8035
  {26, 11}, // #8036
  {27, 11}, // #8037
  { 7,  1}, // #8038
  { 9,  1}, // #8039
  {14,  1}, // #8040
  {16,  1}, // #8041
  {18,  1}, // #8042
  {20,  1}, // #8043
  {21,  1}, // #8044
  {24,  1}, // #8045
  {25,  1}, // #8046
  {26,  1}, // #8047
  {27,  3}, // #8048
  { 9,  1}, // #8049
  {16,  1}, // #8050
  {18,  1}, // #8051
  {21,  1}, // #8052
  {24,  1}, // #8053
  {26,  4}, // #8054
  {27,  4}, // #8055
  { 7,  1}, // #8056
  {14,  1}, // #8057
  {16,  4}, // #8058
  {17,  2}, // #8059
  {19,  1}, // #8060
  {20,  1}, // #8061
  {23,  2}, // #8062
  {24,  4}, // #8063
  {25,  2}, // #8064
  {26, 11}, // #8065
  {27, 14}, // #8066
  { 9,  1}, // #8067
  {16,  4}, // #8068
  {17,  1}, // #8069
  {18,  1}, // #8070
  {21,  1}, // #8071
  {23,  1}, // #8072
  {24,  4}, // #8073
  {26,  7}, // #8074
  {27,  7}, // #8075
  { 9,  1}, // #8076
  {16,  1}, // #8077
  {18,  1}, // #8078
  {21,  1}, // #8079
  {24,  1}, // #8080
  {26,  6}, // #8081
  {27,  6}, // #8082
  { 3,  2}, // #8083
  { 7,  1}, // #8084
  { 8,  4}, // #8085
  {13,  2}, // #8086
  {14,  3}, // #8087
  {15,  6}, // #8088
  {16,  6}, // #8089
  {17,  4}, // #8090
  {19,  1}, // #8091
  {20,  1}, // #8092
  {21,  4}, // #8093
  {23,  6}, // #8094
  {24, 10}, // #8095
  {25,  2}, // #8096
  {26, 16}, // #8097
  {27, 19}, // #8098
  { 8,  2}, // #8099
  {15,  2}, // #8100
  {17,  2}, // #8101
  {21,  2}, // #8102
  {23,  2}, // #8103
  {24,  2}, // #8104
  {26, 22}, // #8105
  {27, 22}, // #8106
  { 8,  1}, // #8107
  { 9,  2}, // #8108
  {15,  1}, // #8109
  {16,  2}, // #8110
  {17,  1}, // #8111
  {18,  2}, // #8112
  {21,  3}, // #8113
  {23,  1}, // #8114
  {24,  3}, // #8115
  {26, 10}, // #8116
  {27, 10}, // #8117
  { 7,  1}, // #8118
  { 8,  1}, // #8119
  { 9,  1}, // #8120
  {14,  1}, // #8121
  {15,  1}, // #8122
  {16,  2}, // #8123
  {17,  1}, // #8124
  {18,  1}, // #8125
  {19,  1}, // #8126
  {20,  1}, // #8127
  {21,  2}, // #8128
  {23,  1}, // #8129
  {24,  3}, // #8130
  {25,  2}, // #8131
  {26,  5}, // #8132
  {27,  8}, // #8133
  { 8,  6}, // #8134
  {15,  9}, // #8135
  {17,  6}, // #8136
  {21,  6}, // #8137
  {23,  9}, // #8138
  {24,  9}, // #8139
  {26, 15}, // #8140
  {27, 15}, // #8141
  { 8,  1}, // #8142
  { 9,  5}, // #8143
  {15,  1}, // #8144
  {16,  9}, // #8145
  {17,  1}, // #8146
  {18,  5}, // #8147
  {19,  2}, // #8148
  {21,  6}, // #8149
  {23,  1}, // #8150
  {24, 10}, // #8151
  {25,  3}, // #8152
  {26, 20}, // #8153
  {27, 23}, // #8154
  { 8,  1}, // #8155
  { 9,  5}, // #8156
  {15,  1}, // #8157
  {16,  9}, // #8158
  {17,  1}, // #8159
  {18,  5}, // #8160
  {19,  3}, // #8161
  {21,  6}, // #8162
  {23,  1}, // #8163
  {24, 10}, // #8164
  {25,  3}, // #8165
  {26, 20}, // #8166
  {27, 23}, // #8167
  { 8,  1}, // #8168
  { 9,  1}, // #8169
  {15,  1}, // #8170
  {16,  2}, // #8171
  {17,  1}, // #8172
  {18,  1}, // #8173
  {21,  2}, // #8174
  {23,  1}, // #8175
  {24,  3}, // #8176
  {26,  8}, // #8177
  {27,  8}, // #8178
  { 3,  4}, // #8179
  { 9,  2}, // #8180
  {13,  4}, // #8181
  {14,  4}, // #8182
  {15,  5}, // #8183
  {16,  8}, // #8184
  {17,  1}, // #8185
  {18,  2}, // #8186
  {19, 33}, // #8187
  {21,  2}, // #8188
  {23,  6}, // #8189
  {24,  9}, // #8190
  {25, 33}, // #8191
  {26, 57}, // #8192
  {27, 90}, // #8193
  { 9,  1}, // #8194
  {16,  1}, // #8195
  {18,  1}, // #8196
  {19,  1}, // #8197
  {21,  1}, // #8198
  {24,  1}, // #8199
  {25,  1}, // #8200
  {26,  2}, // #8201
  {27,  3}, // #8202
  { 3,  1}, // #8203
  {13,  1}, // #8204
  {14,  1}, // #8205
  {15,  1}, // #8206
  {16,  1}, // #8207
  {23,  1}, // #8208
  {24,  1}, // #8209
  {26,  2}, // #8210
  {27,  2}, // #8211
  {16,  1}, // #8212
  {24,  1}, // #8213
  {26,  3}, // #8214
  {27,  3}, // #8215
  { 4,  2}, // #8216
  {13,  2}, // #8217
  {16,  3}, // #8218
  {17,  2}, // #8219
  {18,  2}, // #8220
  {23,  2}, // #8221
  {24,  3}, // #8222
  {26,  7}, // #8223
  {27,  7}, // #8224
  { 4,  2}, // #8225
  {13,  2}, // #8226
  {16,  4}, // #8227
  {17,  3}, // #8228
  {18,  2}, // #8229
  {23,  3}, // #8230
  {24,  4}, // #8231
  {26, 10}, // #8232
  {27, 10}, // #8233
  { 7,  1}, // #8234
  {14,  1}, // #8235
  {20,  1}, // #8236
  {25,  1}, // #8237
  {26,  1}, // #8238
  {27,  3}, // #8239
  { 7,  1}, // #8240
  {14,  1}, // #8241
  {16,  1}, // #8242
  {20,  1}, // #8243
  {24,  1}, // #8244
  {25,  1}, // #8245
  {26,  2}, // #8246
  {27,  4}, // #8247
  { 7,  1}, // #8248
  { 9,  1}, // #8249
  {14,  1}, // #8250
  {16,  1}, // #8251
  {18,  1}, // #8252
  {20,  1}, // #8253
  {21,  1}, // #8254
  {24,  1}, // #8255
  {25,  1}, // #8256
  {26,  2}, // #8257
  {27,  4}, // #8258
  { 7,  1}, // #8259
  {14,  1}, // #8260
  {20,  1}, // #8261
  {25,  1}, // #8262
  {26,  4}, // #8263
  {27,  6}, // #8264
  { 9,  1}, // #8265
  {16,  1}, // #8266
  {18,  1}, // #8267
  {21,  1}, // #8268
  {24,  1}, // #8269
  {26,  2}, // #8270
  {27,  2}, // #8271
  { 9,  1}, // #8272
  {16,  1}, // #8273
  {18,  1}, // #8274
  {19,  1}, // #8275
  {21,  1}, // #8276
  {24,  1}, // #8277
  {25,  1}, // #8278
  {26,  1}, // #8279
  {27,  2}, // #8280
  { 3,  1}, // #8281
  { 7,  1}, // #8282
  {13,  1}, // #8283
  {14,  2}, // #8284
  {15,  1}, // #8285
  {16,  1}, // #8286
  {20,  1}, // #8287
  {23,  1}, // #8288
  {24,  1}, // #8289
  {25,  1}, // #8290
  {26,  1}, // #8291
  {27,  3}, // #8292
  { 4,  1}, // #8293
  { 9,  1}, // #8294
  {13,  1}, // #8295
  {16,  2}, // #8296
  {17,  1}, // #8297
  {18,  2}, // #8298
  {21,  1}, // #8299
  {23,  1}, // #8300
  {24,  2}, // #8301
  {26,  4}, // #8302
  {27,  4}, // #8303
  { 7,  1}, // #8304
  { 9,  1}, // #8305
  {14,  1}, // #8306
  {16,  1}, // #8307
  {18,  1}, // #8308
  {19,  1}, // #8309
  {20,  1}, // #8310
  {21,  1}, // #8311
  {24,  1}, // #8312
  {25,  2}, // #8313
  {26,  2}, // #8314
  {27,  5}, // #8315
  { 7,  1}, // #8316
  {14,  1}, // #8317
  {16,  2}, // #8318
  {19,  1}, // #8319
  {20,  1}, // #8320
  {24,  2}, // #8321
  {25,  2}, // #8322
  {26,  2}, // #8323
  {27,  5}, // #8324
  { 7,  1}, // #8325
  {14,  1}, // #8326
  {19,  1}, // #8327
  {20,  1}, // #8328
  {25,  2}, // #8329
  {26,  2}, // #8330
  {27,  5}, // #8331
  { 4,  1}, // #8332
  { 9,  5}, // #8333
  {13,  1}, // #8334
  {15,  4}, // #8335
  {16,  5}, // #8336
  {17,  1}, // #8337
  {18,  6}, // #8338
  {21,  5}, // #8339
  {23,  5}, // #8340
  {24,  9}, // #8341
  {26, 10}, // #8342
  {27, 10}, // #8343
  { 9,  1}, // #8344
  {16,  1}, // #8345
  {18,  1}, // #8346
  {21,  1}, // #8347
  {24,  1}, // #8348
  {26,  1}, // #8349
  {27,  1}, // #8350
  { 7,  1}, // #8351
  {14,  1}, // #8352
  {17,  1}, // #8353
  {20,  1}, // #8354
  {23,  1}, // #8355
  {25,  1}, // #8356
  {26,  1}, // #8357
  {27,  3}, // #8358
  {16,  2}, // #8359
  {24,  2}, // #8360
  {26,  2}, // #8361
  {27,  2}, // #8362
  { 8,  2}, // #8363
  {15,  2}, // #8364
  {17,  2}, // #8365
  {21,  2}, // #8366
  {23,  2}, // #8367
  {24,  2}, // #8368
  {26,  3}, // #8369
  {27,  3}, // #8370
  { 4,  1}, // #8371
  { 9,  1}, // #8372
  {13,  1}, // #8373
  {16,  1}, // #8374
  {17,  1}, // #8375
  {18,  2}, // #8376
  {21,  1}, // #8377
  {23,  1}, // #8378
  {24,  1}, // #8379
  {26,  4}, // #8380
  {27,  4}, // #8381
  { 4,  1}, // #8382
  { 9,  2}, // #8383
  {13,  1}, // #8384
  {16,  2}, // #8385
  {17,  1}, // #8386
  {18,  3}, // #8387
  {19,  1}, // #8388
  {21,  2}, // #8389
  {23,  1}, // #8390
  {24,  2}, // #8391
  {25,  1}, // #8392
  {26,  4}, // #8393
  {27,  5}, // #8394
  { 4,  1}, // #8395
  { 9,  1}, // #8396
  {13,  1}, // #8397
  {16,  2}, // #8398
  {17,  1}, // #8399
  {18,  2}, // #8400
  {21,  1}, // #8401
  {23,  1}, // #8402
  {24,  2}, // #8403
  {26,  3}, // #8404
  {27,  3}, // #8405
  {16,  1}, // #8406
  {24,  1}, // #8407
  {26,  5}, // #8408
  {27,  5}, // #8409
  { 4,  1}, // #8410
  {13,  1}, // #8411
  {16,  5}, // #8412
  {17,  2}, // #8413
  {18,  1}, // #8414
  {19,  1}, // #8415
  {23,  2}, // #8416
  {24,  5}, // #8417
  {25,  2}, // #8418
  {26,  8}, // #8419
  {27, 10}, // #8420
  { 4,  1}, // #8421
  {13,  1}, // #8422
  {16,  5}, // #8423
  {17,  2}, // #8424
  {18,  1}, // #8425
  {23,  2}, // #8426
  {24,  5}, // #8427
  {26,  9}, // #8428
  {27,  9}, // #8429
  { 4,  1}, // #8430
  { 9,  8}, // #8431
  {13,  1}, // #8432
  {16,  8}, // #8433
  {17,  1}, // #8434
  {18,  9}, // #8435
  {19,  1}, // #8436
  {21,  8}, // #8437
  {23,  1}, // #8438
  {24,  8}, // #8439
  {25,  1}, // #8440
  {26, 30}, // #8441
  {27, 31}, // #8442
  { 7,  1}, // #8443
  { 9, 10}, // #8444
  {14,  1}, // #8445
  {16, 10}, // #8446
  {18, 10}, // #8447
  {19,  1}, // #8448
  {20,  1}, // #8449
  {21, 10}, // #8450
  {24, 10}, // #8451
  {25,  2}, // #8452
  {26, 36}, // #8453
  {27, 39}, // #8454
  { 7,  1}, // #8455
  { 9, 11}, // #8456
  {14,  1}, // #8457
  {16, 11}, // #8458
  {18, 11}, // #8459
  {19,  1}, // #8460
  {20,  1}, // #8461
  {21, 11}, // #8462
  {24, 11}, // #8463
  {25,  2}, // #8464
  {26, 37}, // #8465
  {27, 40}, // #8466
  { 4,  1}, // #8467
  { 7,  1}, // #8468
  { 8,  2}, // #8469
  { 9,  3}, // #8470
  {13,  1}, // #8471
  {14,  1}, // #8472
  {15,  2}, // #8473
  {16,  3}, // #8474
  {17,  4}, // #8475
  {18,  4}, // #8476
  {19,  1}, // #8477
  {20,  1}, // #8478
  {21,  5}, // #8479
  {23,  4}, // #8480
  {24,  5}, // #8481
  {25,  2}, // #8482
  {26, 15}, // #8483
  {27, 18}, // #8484
  { 3,  2}, // #8485
  {13,  2}, // #8486
  {14,  2}, // #8487
  {15,  7}, // #8488
  {16, 12}, // #8489
  {19,  8}, // #8490
  {23,  7}, // #8491
  {24, 17}, // #8492
  {25,  8}, // #8493
  {26, 56}, // #8494
  {27, 64}, // #8495
  { 3,  4}, // #8496
  { 9,  4}, // #8497
  {13,  4}, // #8498
  {14,  4}, // #8499
  {15,  5}, // #8500
  {16, 10}, // #8501
  {17,  1}, // #8502
  {18,  4}, // #8503
  {19, 31}, // #8504
  {21,  4}, // #8505
  {23,  6}, // #8506
  {24, 11}, // #8507
  {25, 31}, // #8508
  {26, 57}, // #8509
  {27, 88}, // #8510
  { 3,  9}, // #8511
  { 4,  1}, // #8512
  { 7, 11}, // #8513
  { 8, 16}, // #8514
  { 9,  1}, // #8515
  {13, 10}, // #8516
  {14, 20}, // #8517
  {15, 25}, // #8518
  {16, 31}, // #8519
  {17, 17}, // #8520
  {18,  2}, // #8521
  {20, 11}, // #8522
  {21, 17}, // #8523
  {23, 26}, // #8524
  {24, 47}, // #8525
  {25, 11}, // #8526
  {26, 78}, // #8527
  {27, 100}, // #8528
  { 3,  1}, // #8529
  { 8,  1}, // #8530
  {13,  1}, // #8531
  {14,  1}, // #8532
  {15,  2}, // #8533
  {16,  1}, // #8534
  {17,  1}, // #8535
  {19,  2}, // #8536
  {21,  1}, // #8537
  {23,  3}, // #8538
  {24,  2}, // #8539
  {25,  2}, // #8540
  {26,  3}, // #8541
  {27,  5}, // #8542
  { 3,  1}, // #8543
  { 8,  1}, // #8544
  {13,  1}, // #8545
  {14,  1}, // #8546
  {15,  2}, // #8547
  {16,  1}, // #8548
  {17,  1}, // #8549
  {19,  4}, // #8550
  {21,  1}, // #8551
  {23,  3}, // #8552
  {24,  2}, // #8553
  {25,  4}, // #8554
  {26,  3}, // #8555
  {27,  7}, // #8556
  { 3,  1}, // #8557
  { 8,  1}, // #8558
  {13,  1}, // #8559
  {14,  1}, // #8560
  {15,  2}, // #8561
  {16,  1}, // #8562
  {17,  1}, // #8563
  {19,  8}, // #8564
  {21,  1}, // #8565
  {23,  3}, // #8566
  {24,  2}, // #8567
  {25,  8}, // #8568
  {26,  3}, // #8569
  {27, 11}, // #8570
  { 8,  5}, // #8571
  {13,  5}, // #8572
  {15,  5}, // #8573
  {17,  5}, // #8574
  {21,  5}, // #8575
  {23, 14}, // #8576
  {24,  5}, // #8577
  {26, 14}, // #8578
  {27, 14}, // #8579
  { 8,  9}, // #8580
  {13,  7}, // #8581
  {15,  9}, // #8582
  {17,  9}, // #8583
  {21,  9}, // #8584
  {23, 21}, // #8585
  {24,  9}, // #8586
  {26, 21}, // #8587
  {27, 21}, // #8588
  { 8, 17}, // #8589
  {13, 11}, // #8590
  {15, 17}, // #8591
  {17, 17}, // #8592
  {21, 17}, // #8593
  {23, 35}, // #8594
  {24, 17}, // #8595
  {26, 35}, // #8596
  {27, 35}, // #8597
  { 3,  1}, // #8598
  { 8,  2}, // #8599
  {13,  1}, // #8600
  {14,  1}, // #8601
  {15,  3}, // #8602
  {16,  1}, // #8603
  {17,  2}, // #8604
  {21,  2}, // #8605
  {23,  3}, // #8606
  {24,  3}, // #8607
  {26,  3}, // #8608
  {27,  3}, // #8609
  { 3,  1}, // #8610
  { 8,  2}, // #8611
  {13,  1}, // #8612
  {14,  1}, // #8613
  {15,  3}, // #8614
  {16,  1}, // #8615
  {17,  2}, // #8616
  {19,  1}, // #8617
  {21,  2}, // #8618
  {23,  3}, // #8619
  {24,  3}, // #8620
  {25,  1}, // #8621
  {26,  3}, // #8622
  {27,  4}, // #8623
  { 8,  2}, // #8624
  {13,  1}, // #8625
  {15,  2}, // #8626
  {17,  2}, // #8627
  {19,  1}, // #8628
  {21,  2}, // #8629
  {23,  3}, // #8630
  {24,  2}, // #8631
  {25,  1}, // #8632
  {26,  3}, // #8633
  {27,  4}, // #8634
  { 7,  2}, // #8635
  {14,  2}, // #8636
  {17,  1}, // #8637
  {20,  2}, // #8638
  {23,  1}, // #8639
  {25,  2}, // #8640
  {26,  1}, // #8641
  {27,  5}, // #8642
  { 7,  1}, // #8643
  {13,  1}, // #8644
  {14,  1}, // #8645
  {20,  1}, // #8646
  {23,  1}, // #8647
  {25,  1}, // #8648
  {26,  1}, // #8649
  {27,  3}, // #8650
  { 7,  1}, // #8651
  { 8,  2}, // #8652
  {14,  1}, // #8653
  {15,  2}, // #8654
  {17,  2}, // #8655
  {20,  1}, // #8656
  {21,  2}, // #8657
  {23,  2}, // #8658
  {24,  2}, // #8659
  {25,  1}, // #8660
  {26,  2}, // #8661
  {27,  4}, // #8662
  { 8,  1}, // #8663
  {15,  1}, // #8664
  {17,  1}, // #8665
  {19,  1}, // #8666
  {21,  1}, // #8667
  {23,  1}, // #8668
  {24,  1}, // #8669
  {25,  1}, // #8670
  {26,  2}, // #8671
  {27,  3}, // #8672
  { 3,  1}, // #8673
  { 7,  2}, // #8674
  {13,  1}, // #8675
  {14,  3}, // #8676
  {15,  1}, // #8677
  {16,  1}, // #8678
  {20,  2}, // #8679
  {23,  1}, // #8680
  {24,  1}, // #8681
  {25,  2}, // #8682
  {26,  3}, // #8683
  {27,  7}, // #8684
  { 3,  1}, // #8685
  { 7,  4}, // #8686
  {13,  1}, // #8687
  {14,  5}, // #8688
  {15,  1}, // #8689
  {16,  1}, // #8690
  {20,  4}, // #8691
  {23,  1}, // #8692
  {24,  1}, // #8693
  {25,  4}, // #8694
  {26,  3}, // #8695
  {27, 11}, // #8696
  { 3,  1}, // #8697
  { 7,  8}, // #8698
  {13,  1}, // #8699
  {14,  9}, // #8700
  {15,  1}, // #8701
  {16,  1}, // #8702
  {20,  8}, // #8703
  {23,  1}, // #8704
  {24,  1}, // #8705
  {25,  8}, // #8706
  {26,  3}, // #8707
  {27, 19}, // #8708
  { 3,  1}, // #8709
  { 7, 16}, // #8710
  { 8,  1}, // #8711
  {13,  1}, // #8712
  {14, 17}, // #8713
  {15,  2}, // #8714
  {16,  1}, // #8715
  {17,  1}, // #8716
  {20, 16}, // #8717
  {21,  1}, // #8718
  {23,  2}, // #8719
  {24,  2}, // #8720
  {25, 16}, // #8721
  {26,  4}, // #8722
  {27, 36}, // #8723
  { 3,  1}, // #8724
  { 7,  2}, // #8725
  { 8,  1}, // #8726
  {13,  1}, // #8727
  {14,  3}, // #8728
  {15,  2}, // #8729
  {16,  1}, // #8730
  {17,  1}, // #8731
  {20,  2}, // #8732
  {21,  1}, // #8733
  {23,  2}, // #8734
  {24,  2}, // #8735
  {25,  2}, // #8736
  {26,  4}, // #8737
  {27,  8}, // #8738
  { 3,  1}, // #8739
  { 7,  4}, // #8740
  { 8,  1}, // #8741
  {13,  1}, // #8742
  {14,  5}, // #8743
  {15,  2}, // #8744
  {16,  1}, // #8745
  {17,  1}, // #8746
  {20,  4}, // #8747
  {21,  1}, // #8748
  {23,  2}, // #8749
  {24,  2}, // #8750
  {25,  4}, // #8751
  {26,  4}, // #8752
  {27, 12}, // #8753
  { 3,  1}, // #8754
  { 7,  8}, // #8755
  { 8,  1}, // #8756
  {13,  1}, // #8757
  {14,  9}, // #8758
  {15,  2}, // #8759
  {16,  1}, // #8760
  {17,  1}, // #8761
  {20,  8}, // #8762
  {21,  1}, // #8763
  {23,  2}, // #8764
  {24,  2}, // #8765
  {25,  8}, // #8766
  {26,  4}, // #8767
  {27, 20}, // #8768
  {13,  3}, // #8769
  {23,  3}, // #8770
  {26,  3}, // #8771
  {27,  3}, // #8772
  { 3,  1}, // #8773
  {13,  2}, // #8774
  {14,  1}, // #8775
  {15,  1}, // #8776
  {16,  1}, // #8777
  {19,  1}, // #8778
  {23,  2}, // #8779
  {24,  1}, // #8780
  {25,  1}, // #8781
  {26,  2}, // #8782
  {27,  3}, // #8783
  { 4,  1}, // #8784
  { 8,  2}, // #8785
  {13,  3}, // #8786
  {15,  2}, // #8787
  {17,  3}, // #8788
  {18,  1}, // #8789
  {19,  1}, // #8790
  {21,  2}, // #8791
  {23,  7}, // #8792
  {24,  2}, // #8793
  {25,  1}, // #8794
  {26,  7}, // #8795
  {27,  8}, // #8796
  {13,  3}, // #8797
  {19,  1}, // #8798
  {23,  3}, // #8799
  {25,  1}, // #8800
  {26,  3}, // #8801
  {27,  4}, // #8802
  { 3,  1}, // #8803
  {13,  1}, // #8804
  {14,  1}, // #8805
  {15,  1}, // #8806
  {16,  1}, // #8807
  {19,  2}, // #8808
  {23,  2}, // #8809
  {24,  1}, // #8810
  {25,  2}, // #8811
  {26,  3}, // #8812
  {27,  5}, // #8813
  { 3,  1}, // #8814
  {13,  1}, // #8815
  {14,  1}, // #8816
  {15,  1}, // #8817
  {16,  1}, // #8818
  {19,  4}, // #8819
  {23,  2}, // #8820
  {24,  1}, // #8821
  {25,  4}, // #8822
  {26,  3}, // #8823
  {27,  7}, // #8824
  { 3,  1}, // #8825
  {13,  1}, // #8826
  {14,  1}, // #8827
  {15,  1}, // #8828
  {16,  1}, // #8829
  {19,  8}, // #8830
  {23,  2}, // #8831
  {24,  1}, // #8832
  {25,  8}, // #8833
  {26,  3}, // #8834
  {27, 11}, // #8835
  { 3,  1}, // #8836
  {13,  1}, // #8837
  {14,  1}, // #8838
  {15,  1}, // #8839
  {16,  1}, // #8840
  {19, 16}, // #8841
  {23,  2}, // #8842
  {24,  1}, // #8843
  {25, 16}, // #8844
  {26,  3}, // #8845
  {27, 19}, // #8846
  { 8,  5}, // #8847
  {13,  5}, // #8848
  {15,  5}, // #8849
  {17,  5}, // #8850
  {19,  1}, // #8851
  {21,  5}, // #8852
  {23, 14}, // #8853
  {24,  5}, // #8854
  {25,  1}, // #8855
  {26, 14}, // #8856
  {27, 15}, // #8857
  { 8,  9}, // #8858
  {13,  7}, // #8859
  {15,  9}, // #8860
  {17,  9}, // #8861
  {19,  1}, // #8862
  {21,  9}, // #8863
  {23, 21}, // #8864
  {24,  9}, // #8865
  {25,  1}, // #8866
  {26, 21}, // #8867
  {27, 22}, // #8868
  { 8, 17}, // #8869
  {13, 11}, // #8870
  {15, 17}, // #8871
  {17, 17}, // #8872
  {19,  1}, // #8873
  {21, 17}, // #8874
  {23, 35}, // #8875
  {24, 17}, // #8876
  {25,  1}, // #8877
  {26, 35}, // #8878
  {27, 36}, // #8879
  {16,  2}, // #8880
  {19,  1}, // #8881
  {24,  2}, // #8882
  {25,  1}, // #8883
  {26,  2}, // #8884
  {27,  3}, // #8885
  { 7,  1}, // #8886
  {14,  1}, // #8887
  {16,  2}, // #8888
  {20,  1}, // #8889
  {24,  2}, // #8890
  {25,  1}, // #8891
  {26,  2}, // #8892
  {27,  4}, // #8893
  { 3,  1}, // #8894
  {11,  2}, // #8895
  {12,  1}, // #8896
  {13,  1}, // #8897
  {14,  1}, // #8898
  {19,  2}, // #8899
  {20,  1}, // #8900
  {22,  2}, // #8901
  {23,  2}, // #8902
  { 8,  1}, // #8903
  {11,  2}, // #8904
  {13,  1}, // #8905
  {15,  1}, // #8906
  {17,  1}, // #8907
  {18,  1}, // #8908
  {19,  3}, // #8909
  {20,  1}, // #8910
  {21,  1}, // #8911
  {22,  3}, // #8912
  {23,  4}, // #8913
  { 8,  1}, // #8914
  {11,  2}, // #8915
  {13,  1}, // #8916
  {15,  1}, // #8917
  {18,  1}, // #8918
  {19,  3}, // #8919
  {20,  1}, // #8920
  {22,  3}, // #8921
  {23,  3}, // #8922
  { 8,  1}, // #8923
  {11,  3}, // #8924
  {13,  1}, // #8925
  {15,  1}, // #8926
  {17,  1}, // #8927
  {18,  1}, // #8928
  {19,  4}, // #8929
  {20,  1}, // #8930
  {21,  1}, // #8931
  {22,  4}, // #8932
  {23,  5}, // #8933
  { 8,  1}, // #8934
  {11,  3}, // #8935
  {13,  1}, // #8936
  {15,  1}, // #8937
  {18,  1}, // #8938
  {19,  4}, // #8939
  {20,  1}, // #8940
  {22,  4}, // #8941
  {23,  4}, // #8942
  {22, 16}, // #8943
  {23, 16}, // #8944
  { 7,  1}, // #8945
  { 9, 11}, // #8946
  {12,  1}, // #8947
  {14, 11}, // #8948
  {16, 11}, // #8949
  {17,  1}, // #8950
  {18, 11}, // #8951
  {20, 11}, // #8952
  {21,  2}, // #8953
  {22, 41}, // #8954
  {23, 44}, // #8955
  {11,  1}, // #8956
  {22,  1}, // #8957
  { 1,  1}, // #8958
  { 4,  1}, // #8959
  { 1,  2}, // #8960
  { 4,  1}, // #8961
  {11,  1}, // #8962
  {15,  1}, // #8963
  {18,  1}, // #8964
  {20,  1}, // #8965
  {21,  1}, // #8966
  {22,  1}, // #8967
  { 1,  1}, // #8968
  {11,  1}, // #8969
  {21,  1}, // #8970
  { 1,  1}, // #8971
  {11,  1}, // #8972
  {16,  1}, // #8973
  {22,  1}, // #8974
  { 1,  1}, // #8975
  { 4,  2}, // #8976
  { 1,  1}, // #8977
  { 4, 12}, // #8978
  { 1,  1}, // #8979
  { 4, 16}, // #8980
  { 1,  1}, // #8981
  {11,  2}, // #8982
  {14,  1}, // #8983
  {16,  1}, // #8984
  {17,  1}, // #8985
  {19,  1}, // #8986
  {21,  1}, // #8987
  {22,  1}, // #8988
  { 1,  1}, // #8989
  {11,  1}, // #8990
  {12,  1}, // #8991
  {16,  1}, // #8992
  {17,  1}, // #8993
  {18,  1}, // #8994
  {22,  1}, // #8995
  { 1,  1}, // #8996
  {11,  1}, // #8997
  {15,  1}, // #8998
  {18,  1}, // #8999
  {20,  1}, // #9000
  {21,  1}, // #9001
  {22,  1}, // #9002
  { 1,  1}, // #9003
  {11,  2}, // #9004
  {15,  2}, // #9005
  {18,  2}, // #9006
  {20,  2}, // #9007
  {21,  2}, // #9008
  {22,  2}, // #9009
  { 1,  1}, // #9010
  { 4,  1}, // #9011
  { 7,  1}, // #9012
  {10, 17}, // #9013
  { 1,  1}, // #9014
  { 4,  1}, // #9015
  { 7,  1}, // #9016
  {10, 25}, // #9017
  { 1,  1}, // #9018
  { 4,  1}, // #9019
  { 7,  1}, // #9020
  {10, 41}, // #9021
  { 1,  1}, // #9022
  { 4,  1}, // #9023
  { 7,  1}, // #9024
  {10, 15}, // #9025
  { 1,  1}, // #9026
  {11,  5}, // #9027
  {15,  5}, // #9028
  {18,  5}, // #9029
  {20,  5}, // #9030
  {21,  5}, // #9031
  {22,  5}, // #9032
  { 1,  1}, // #9033
  {11,  3}, // #9034
  {15,  3}, // #9035
  {18,  3}, // #9036
  {20,  3}, // #9037
  {21,  3}, // #9038
  {22,  3}, // #9039
  { 1,  1}, // #9040
  {11,  5}, // #9041
  {14,  3}, // #9042
  {17,  3}, // #9043
  {19,  5}, // #9044
  {21,  3}, // #9045
  {11,  3}, // #9046
  {14,  2}, // #9047
  {17,  2}, // #9048
  {19,  3}, // #9049
  {21,  2}, // #9050
  { 1,  1}, // #9051
  {11,  1}, // #9052
  {22,  1}, // #9053
  { 1,  1}, // #9054
  { 4,  1}, // #9055
  { 6,  1}, // #9056
  {23,  1}, // #9057
  { 1,  1}, // #9058
  {11,  1}, // #9059
  {19,  1}, // #9060
  { 1,  1}, // #9061
  {11,  1}, // #9062
  {20,  1}, // #9063
  {22,  1}, // #9064
  {11,  1}, // #9065
  {14,  1}, // #9066
  {17,  1}, // #9067
  {19,  1}, // #9068
  {21,  1}, // #9069
  { 1,  1}, // #9070
  {11,  1}, // #9071
  {14,  1}, // #9072
  {17,  1}, // #9073
  {19,  1}, // #9074
  {21,  1}, // #9075
  { 1,  1}, // #9076
  { 4,  1}, // #9077
  { 6,  1}, // #9078
  {23,  2}, // #9079
  { 1,  1}, // #9080
  {11,  2}, // #9081
  {12,  2}, // #9082
  {16,  2}, // #9083
  {17,  2}, // #9084
  {18,  2}, // #9085
  {22,  2}, // #9086
  { 1,  1}, // #9087
  {11,  2}, // #9088
  {19,  2}, // #9089
  { 1,  1}, // #9090
  {11,  8}, // #9091
  {15,  8}, // #9092
  {18,  8}, // #9093
  {20,  8}, // #9094
  {21,  8}, // #9095
  {22,  8}, // #9096
  {11, 20}, // #9097
  {15, 20}, // #9098
  {18, 20}, // #9099
  {20, 20}, // #9100
  {21, 20}, // #9101
  {22, 20}, // #9102
  { 1,  1}, // #9103
  {11,  2}, // #9104
  {21,  2}, // #9105
  { 1,  1}, // #9106
  {11,  2}, // #9107
  {16,  2}, // #9108
  {22,  2}, // #9109
  { 1,  1}, // #9110
  {11,  9}, // #9111
  {15,  9}, // #9112
  {18,  9}, // #9113
  {20,  9}, // #9114
  {21,  9}, // #9115
  {22,  9}, // #9116
  { 1,  1}, // #9117
  {11,  6}, // #9118
  {15,  6}, // #9119
  {18,  6}, // #9120
  {20,  6}, // #9121
  {21,  6}, // #9122
  {22,  6}, // #9123
  { 1,  1}, // #9124
  {11,  2}, // #9125
  {22,  2}, // #9126
  { 1,  1}, // #9127
  {11,  3}, // #9128
  {16,  3}, // #9129
  {22,  3}, // #9130
  { 1,  1}, // #9131
  {11,  4}, // #9132
  {19,  4}, // #9133
  {11,  2}, // #9134
  {14,  2}, // #9135
  {17,  2}, // #9136
  {19,  2}, // #9137
  {21,  2}, // #9138
  { 1,  1}, // #9139
  {11,  4}, // #9140
  {12,  4}, // #9141
  {16,  4}, // #9142
  {17,  4}, // #9143
  {18,  4}, // #9144
  {22,  4}, // #9145
  { 1,  1}, // #9146
  {11,  2}, // #9147
  {14,  2}, // #9148
  {17,  2}, // #9149
  {19,  2}, // #9150
  {21,  2}, // #9151
  { 1,  1}, // #9152
  {11,  2}, // #9153
  {13,  2}, // #9154
  {16,  2}, // #9155
  {19,  2}, // #9156
  {20,  2}, // #9157
  {22,  2}, // #9158
  { 1,  1}, // #9159
  {11,  4}, // #9160
  {13,  4}, // #9161
  {16,  4}, // #9162
  {19,  4}, // #9163
  {20,  4}, // #9164
  {22,  4}, // #9165
  { 1,  1}, // #9166
  {11, 16}, // #9167
  {15, 16}, // #9168
  {18, 16}, // #9169
  {20, 16}, // #9170
  {21, 16}, // #9171
  {22, 16}, // #9172
  { 1,  1}, // #9173
  {11, 10}, // #9174
  {15, 10}, // #9175
  {18, 10}, // #9176
  {20, 10}, // #9177
  {21, 10}, // #9178
  {22, 10}, // #9179
  {11,  2}, // #9180
  {15,  1}, // #9181
  {18,  1}, // #9182
  {19,  1}, // #9183
  {20,  1}, // #9184
  {21,  1}, // #9185
  {22,  1}, // #9186
  { 1,  1}, // #9187
  {11,  2}, // #9188
  {15,  1}, // #9189
  {18,  1}, // #9190
  {19,  1}, // #9191
  {20,  1}, // #9192
  {21,  1}, // #9193
  {22,  1}, // #9194
  { 1,  1}, // #9195
  {11,  1}, // #9196
  {17,  1}, // #9197
  { 1,  5}, // #9198
  {11,  3}, // #9199
  {14,  2}, // #9200
  {17,  2}, // #9201
  {19,  3}, // #9202
  {21,  2}, // #9203
  { 1,  1}, // #9204
  {11,  1}, // #9205
  {18,  1}, // #9206
  {22,  1}, // #9207
  { 1,  1}, // #9208
  {11,  3}, // #9209
  {18,  3}, // #9210
  {22,  3}, // #9211
  { 1,  1}, // #9212
  {11,  2}, // #9213
  {18,  2}, // #9214
  {22,  2}, // #9215
  { 1,  1}, // #9216
  { 4,  1}, // #9217
  { 9,  1}, // #9218
  {11,  2}, // #9219
  {15,  1}, // #9220
  {18,  1}, // #9221
  {20,  1}, // #9222
  {21,  1}, // #9223
  {22,  2}, // #9224
  {11,  2}, // #9225
  {14,  1}, // #9226
  {15,  1}, // #9227
  {17,  1}, // #9228
  {18,  1}, // #9229
  {19,  1}, // #9230
  {20,  1}, // #9231
  {21,  2}, // #9232
  {22,  1}, // #9233
  { 1,  1}, // #9234
  {11,  2}, // #9235
  {14,  1}, // #9236
  {15,  1}, // #9237
  {17,  1}, // #9238
  {18,  1}, // #9239
  {19,  1}, // #9240
  {20,  1}, // #9241
  {21,  2}, // #9242
  {22,  1}, // #9243
  {11,  2}, // #9244
  {14,  1}, // #9245
  {17,  1}, // #9246
  {19,  2}, // #9247
  {21,  1}, // #9248
  {11,  2}, // #9249
  {13,  1}, // #9250
  {16,  1}, // #9251
  {18,  1}, // #9252
  {19,  1}, // #9253
  {20,  1}, // #9254
  {22,  2}, // #9255
  {11,  1}, // #9256
  {13,  1}, // #9257
  {16,  1}, // #9258
  {19,  1}, // #9259
  {20,  1}, // #9260
  {22,  1}, // #9261
  { 1,  1}, // #9262
  {11,  1}, // #9263
  {13,  1}, // #9264
  {16,  1}, // #9265
  {19,  1}, // #9266
  {20,  1}, // #9267
  {22,  1}, // #9268
  {12,  1}, // #9269
  {23,  1}, // #9270
  { 1,  2}, // #9271
  { 5,  1}, // #9272
  {12,  1}, // #9273
  {16,  1}, // #9274
  {19,  1}, // #9275
  {21,  1}, // #9276
  {22,  1}, // #9277
  {23,  1}, // #9278
  { 1,  1}, // #9279
  {12,  1}, // #9280
  {22,  1}, // #9281
  { 1,  1}, // #9282
  {12,  1}, // #9283
  {17,  1}, // #9284
  {23,  1}, // #9285
  { 1,  1}, // #9286
  { 5,  2}, // #9287
  { 1,  1}, // #9288
  { 5, 12}, // #9289
  { 1,  1}, // #9290
  { 5, 16}, // #9291
  { 1,  1}, // #9292
  {12,  2}, // #9293
  {15,  1}, // #9294
  {17,  1}, // #9295
  {18,  1}, // #9296
  {20,  1}, // #9297
  {22,  1}, // #9298
  {23,  1}, // #9299
  { 1,  1}, // #9300
  {12,  1}, // #9301
  {13,  1}, // #9302
  {17,  1}, // #9303
  {18,  1}, // #9304
  {19,  1}, // #9305
  {23,  1}, // #9306
  { 1,  1}, // #9307
  {12,  1}, // #9308
  {16,  1}, // #9309
  {19,  1}, // #9310
  {21,  1}, // #9311
  {22,  1}, // #9312
  {23,  1}, // #9313
  { 1,  1}, // #9314
  {12,  2}, // #9315
  {16,  2}, // #9316
  {19,  2}, // #9317
  {21,  2}, // #9318
  {22,  2}, // #9319
  {23,  2}, // #9320
  { 1,  1}, // #9321
  { 5,  1}, // #9322
  { 8,  1}, // #9323
  {11, 17}, // #9324
  { 1,  1}, // #9325
  { 5,  1}, // #9326
  { 8,  1}, // #9327
  {11, 25}, // #9328
  { 1,  1}, // #9329
  { 5,  1}, // #9330
  { 8,  1}, // #9331
  {11, 41}, // #9332
  { 1,  1}, // #9333
  { 5,  1}, // #9334
  { 8,  1}, // #9335
  {11, 15}, // #9336
  { 1,  1}, // #9337
  {12,  6}, // #9338
  {16,  6}, // #9339
  {19,  6}, // #9340
  {21,  6}, // #9341
  {22,  6}, // #9342
  {23,  6}, // #9343
  { 1,  1}, // #9344
  {12,  5}, // #9345
  {16,  5}, // #9346
  {19,  5}, // #9347
  {21,  5}, // #9348
  {22,  5}, // #9349
  {23,  5}, // #9350
  { 1,  1}, // #9351
  {12,  5}, // #9352
  {15,  3}, // #9353
  {18,  3}, // #9354
  {20,  5}, // #9355
  {22,  3}, // #9356
  {12,  3}, // #9357
  {15,  2}, // #9358
  {18,  2}, // #9359
  {20,  3}, // #9360
  {22,  2}, // #9361
  { 1,  1}, // #9362
  {12,  1}, // #9363
  {23,  1}, // #9364
  { 1,  1}, // #9365
  { 5,  1}, // #9366
  { 7,  1}, // #9367
  {24,  1}, // #9368
  { 1,  1}, // #9369
  {12,  1}, // #9370
  {20,  1}, // #9371
  { 1,  1}, // #9372
  {12,  1}, // #9373
  {21,  1}, // #9374
  {23,  1}, // #9375
  {12,  1}, // #9376
  {15,  1}, // #9377
  {18,  1}, // #9378
  {20,  1}, // #9379
  {22,  1}, // #9380
  { 1,  1}, // #9381
  {12,  1}, // #9382
  {15,  1}, // #9383
  {18,  1}, // #9384
  {20,  1}, // #9385
  {22,  1}, // #9386
  { 1,  1}, // #9387
  { 5,  1}, // #9388
  { 7,  1}, // #9389
  {24,  2}, // #9390
  { 1,  1}, // #9391
  {12,  2}, // #9392
  {13,  2}, // #9393
  {17,  2}, // #9394
  {18,  2}, // #9395
  {19,  2}, // #9396
  {23,  2}, // #9397
  { 1,  1}, // #9398
  {12,  2}, // #9399
  {20,  2}, // #9400
  { 1,  1}, // #9401
  {12, 10}, // #9402
  {16, 10}, // #9403
  {19, 10}, // #9404
  {21, 10}, // #9405
  {22, 10}, // #9406
  {23, 10}, // #9407
  { 1,  1}, // #9408
  {12,  7}, // #9409
  {16,  7}, // #9410
  {19,  7}, // #9411
  {21,  7}, // #9412
  {22,  7}, // #9413
  {23,  7}, // #9414
  {12, 20}, // #9415
  {16, 20}, // #9416
  {19, 20}, // #9417
  {21, 20}, // #9418
  {22, 20}, // #9419
  {23, 20}, // #9420
  { 1,  1}, // #9421
  {12,  2}, // #9422
  {17,  2}, // #9423
  {23,  2}, // #9424
  {12,  2}, // #9425
  {15,  2}, // #9426
  {18,  2}, // #9427
  {20,  2}, // #9428
  {22,  2}, // #9429
  { 1,  1}, // #9430
  {12,  2}, // #9431
  {14,  2}, // #9432
  {17,  2}, // #9433
  {20,  2}, // #9434
  {21,  2}, // #9435
  {23,  2}, // #9436
  {12,  2}, // #9437
  {16,  1}, // #9438
  {19,  1}, // #9439
  {20,  1}, // #9440
  {21,  1}, // #9441
  {22,  1}, // #9442
  {23,  1}, // #9443
  { 1,  1}, // #9444
  {12,  2}, // #9445
  {16,  1}, // #9446
  {19,  1}, // #9447
  {20,  1}, // #9448
  {21,  1}, // #9449
  {22,  1}, // #9450
  {23,  1}, // #9451
  { 1,  1}, // #9452
  {12,  1}, // #9453
  {18,  1}, // #9454
  { 1,  5}, // #9455
  {12,  3}, // #9456
  {15,  2}, // #9457
  {18,  2}, // #9458
  {20,  3}, // #9459
  {22,  2}, // #9460
  { 1,  1}, // #9461
  {12,  1}, // #9462
  {19,  1}, // #9463
  {23,  1}, // #9464
  { 1,  1}, // #9465
  {12,  3}, // #9466
  {19,  3}, // #9467
  {23,  3}, // #9468
  { 1,  1}, // #9469
  {12,  3}, // #9470
  {17,  3}, // #9471
  {23,  3}, // #9472
  { 1,  1}, // #9473
  { 5,  1}, // #9474
  {10,  1}, // #9475
  {12,  2}, // #9476
  {16,  1}, // #9477
  {19,  1}, // #9478
  {21,  1}, // #9479
  {22,  1}, // #9480
  {23,  2}, // #9481
  {12,  2}, // #9482
  {15,  1}, // #9483
  {16,  1}, // #9484
  {18,  1}, // #9485
  {19,  1}, // #9486
  {20,  1}, // #9487
  {21,  1}, // #9488
  {22,  2}, // #9489
  {23,  1}, // #9490
  { 1,  1}, // #9491
  {12,  2}, // #9492
  {15,  1}, // #9493
  {16,  1}, // #9494
  {18,  1}, // #9495
  {19,  1}, // #9496
  {20,  1}, // #9497
  {21,  1}, // #9498
  {22,  2}, // #9499
  {23,  1}, // #9500
  {12,  2}, // #9501
  {15,  1}, // #9502
  {18,  1}, // #9503
  {20,  2}, // #9504
  {22,  1}, // #9505
  {12,  2}, // #9506
  {14,  1}, // #9507
  {17,  1}, // #9508
  {19,  1}, // #9509
  {20,  1}, // #9510
  {21,  1}, // #9511
  {23,  2}, // #9512
  {12,  1}, // #9513
  {14,  1}, // #9514
  {17,  1}, // #9515
  {20,  1}, // #9516
  {21,  1}, // #9517
  {23,  1}, // #9518
  { 1,  1}, // #9519
  {12,  1}, // #9520
  {14,  1}, // #9521
  {17,  1}, // #9522
  {20,  1}, // #9523
  {21,  1}, // #9524
  {23,  1}, // #9525
  {11,  1}, // #9526
  {36,  1}, // #9527
  {11,  0}, // #9528
  {36,  0}, // #9529
  {14,  1}, // #9530
  {20,  1}, // #9531
  {28,  1}, // #9532
  {31,  1}, // #9533
  {32,  1}, // #9534
  {13,  1}, // #9535
  {36,  1}, // #9536
  {11, 12}, // #9537
  {36, 12}, // #9538
  { 4,  1}, // #9539
  {13,  1}, // #9540
  {36,  2}, // #9541
  {37,  1}, // #9542
  {38,  1}, // #9543
  {11,  4}, // #9544
  {36,  4}, // #9545
  {11, 100}, // #9546
  {36, 100}, // #9547
  {10,  3}, // #9548
  {11,  3}, // #9549
  {36,  3}, // #9550
  {26,  1}, // #9551
  {27,  1}, // #9552
  {37,  1}, // #9553
  {39,  1}, // #9554
  {14,  1}, // #9555
  {26,  1}, // #9556
  {37,  1}, // #9557
  {38,  1}, // #9558
  { 4,  2}, // #9559
  {11,  1}, // #9560
  {36,  3}, // #9561
  {37,  2}, // #9562
  {38,  1}, // #9563
  {39,  1}, // #9564
  {14,  2}, // #9565
  {15,  2}, // #9566
  {16,  2}, // #9567
  {20,  2}, // #9568
  {21,  2}, // #9569
  {28,  2}, // #9570
  {29,  2}, // #9571
  {31,  2}, // #9572
  {32,  2}, // #9573
  { 4,  2}, // #9574
  {11,  4}, // #9575
  {36,  6}, // #9576
  {37,  2}, // #9577
  {38,  1}, // #9578
  {39,  1}, // #9579
  { 4,  1}, // #9580
  {11,  4}, // #9581
  {36,  5}, // #9582
  {37,  1}, // #9583
  {38,  1}, // #9584
  { 4,  1}, // #9585
  {11,  1}, // #9586
  {36,  2}, // #9587
  {37,  1}, // #9588
  {38,  1}, // #9589
  {14,  2}, // #9590
  {17,  1}, // #9591
  {18,  1}, // #9592
  {20,  1}, // #9593
  {26,  1}, // #9594
  {28,  1}, // #9595
  {31,  1}, // #9596
  {32,  1}, // #9597
  {37,  1}, // #9598
  {38,  1}, // #9599
  {14,  1}, // #9600
  {17,  1}, // #9601
  {18,  1}, // #9602
  {20,  1}, // #9603
  {28,  1}, // #9604
  {31,  1}, // #9605
  {32,  1}, // #9606
  {14,  2}, // #9607
  {15,  1}, // #9608
  {16,  1}, // #9609
  {20,  1}, // #9610
  {21,  1}, // #9611
  {26,  1}, // #9612
  {28,  1}, // #9613
  {29,  1}, // #9614
  {31,  1}, // #9615
  {32,  1}, // #9616
  {37,  1}, // #9617
  {38,  1}, // #9618
  {14,  1}, // #9619
  {15,  1}, // #9620
  {16,  1}, // #9621
  {20,  1}, // #9622
  {21,  1}, // #9623
  {28,  1}, // #9624
  {29,  1}, // #9625
  {31,  1}, // #9626
  {32,  1}, // #9627
  {14,  2}, // #9628
  {20,  1}, // #9629
  {26,  1}, // #9630
  {28,  1}, // #9631
  {31,  1}, // #9632
  {32,  1}, // #9633
  {37,  1}, // #9634
  {38,  1}, // #9635
  { 4,  1}, // #9636
  {10,  1}, // #9637
  {11,  1}, // #9638
  {36,  2}, // #9639
  {37,  1}, // #9640
  {38,  1}, // #9641
  {10,  1}, // #9642
  {11,  1}, // #9643
  {36,  1}, // #9644
  { 4,  1}, // #9645
  {11,  2}, // #9646
  {36,  3}, // #9647
  {37,  1}, // #9648
  {38,  1}, // #9649
  {11,  2}, // #9650
  {36,  2}, // #9651
  { 4,  1}, // #9652
  { 6,  3}, // #9653
  {10,  3}, // #9654
  {11,  3}, // #9655
  {36,  4}, // #9656
  {37,  1}, // #9657
  {38,  1}, // #9658
  { 6,  3}, // #9659
  {10,  3}, // #9660
  {11,  3}, // #9661
  {36,  3}, // #9662
  { 4,  1}, // #9663
  { 6,  4}, // #9664
  {10,  4}, // #9665
  {11,  4}, // #9666
  {36,  5}, // #9667
  {37,  1}, // #9668
  {38,  1}, // #9669
  { 6,  4}, // #9670
  {10,  4}, // #9671
  {11,  4}, // #9672
  {36,  4}, // #9673
  { 4,  2}, // #9674
  {10,  1}, // #9675
  {11,  1}, // #9676
  {36,  3}, // #9677
  {37,  2}, // #9678
  {38,  1}, // #9679
  {39,  1}, // #9680
  {10,  2}, // #9681
  {11,  2}, // #9682
  {36,  2}, // #9683
  { 4,  1}, // #9684
  {36,  1}, // #9685
  {37,  1}, // #9686
  {38,  1}, // #9687
  { 4,  1}, // #9688
  { 9,  1}, // #9689
  {11,  1}, // #9690
  {36,  2}, // #9691
  {37,  1}, // #9692
  {38,  1}, // #9693
  { 9,  1}, // #9694
  {11,  1}, // #9695
  {36,  1}, // #9696
  {11, 28}, // #9697
  {36, 28}, // #9698
  {11,  8}, // #9699
  {36,  8}, // #9700
  {14,  3}, // #9701
  {15,  2}, // #9702
  {16,  2}, // #9703
  {20,  2}, // #9704
  {21,  2}, // #9705
  {26,  1}, // #9706
  {28,  2}, // #9707
  {29,  2}, // #9708
  {31,  2}, // #9709
  {32,  2}, // #9710
  {37,  1}, // #9711
  {38,  1}, // #9712
  { 4,  1}, // #9713
  { 6,  1}, // #9714
  {10,  1}, // #9715
  {11,  1}, // #9716
  {36,  2}, // #9717
  {37,  1}, // #9718
  {38,  1}, // #9719
  { 6,  1}, // #9720
  {10,  1}, // #9721
  {11,  1}, // #9722
  {36,  1}, // #9723
  {14,  3}, // #9724
  {17,  2}, // #9725
  {18,  2}, // #9726
  {20,  2}, // #9727
  {26,  1}, // #9728
  {28,  2}, // #9729
  {31,  2}, // #9730
  {32,  2}, // #9731
  {37,  1}, // #9732
  {38,  1}, // #9733
  {14,  2}, // #9734
  {17,  2}, // #9735
  {18,  2}, // #9736
  {20,  2}, // #9737
  {28,  2}, // #9738
  {31,  2}, // #9739
  {32,  2}, // #9740
  { 4,  1}, // #9741
  { 5, 11}, // #9742
  { 9, 11}, // #9743
  {11, 11}, // #9744
  {13, 11}, // #9745
  {36, 12}, // #9746
  {37,  1}, // #9747
  {38,  1}, // #9748
  { 5, 11}, // #9749
  { 9, 11}, // #9750
  {11, 11}, // #9751
  {13, 11}, // #9752
  {36, 11}, // #9753
  { 4,  1}, // #9754
  { 5, 13}, // #9755
  { 9, 13}, // #9756
  {11, 13}, // #9757
  {13, 13}, // #9758
  {36, 14}, // #9759
  {37,  1}, // #9760
  {38,  1}, // #9761
  { 5, 13}, // #9762
  { 9, 13}, // #9763
  {11, 13}, // #9764
  {13, 13}, // #9765
  {36, 13}, // #9766
  { 4,  1}, // #9767
  { 5, 17}, // #9768
  { 9, 17}, // #9769
  {11, 17}, // #9770
  {13, 17}, // #9771
  {36, 18}, // #9772
  {37,  1}, // #9773
  {38,  1}, // #9774
  { 5, 17}, // #9775
  { 9, 17}, // #9776
  {11, 17}, // #9777
  {13, 17}, // #9778
  {36, 17}, // #9779
  { 4,  1}, // #9780
  { 5, 10}, // #9781
  { 9, 10}, // #9782
  {11, 10}, // #9783
  {13, 10}, // #9784
  {36, 11}, // #9785
  {37,  1}, // #9786
  {38,  1}, // #9787
  { 5, 10}, // #9788
  { 9, 10}, // #9789
  {11, 10}, // #9790
  {13, 10}, // #9791
  {36, 10}, // #9792
  {14,  6}, // #9793
  {15,  5}, // #9794
  {16,  5}, // #9795
  {19,  5}, // #9796
  {20,  5}, // #9797
  {21,  5}, // #9798
  {23,  5}, // #9799
  {26,  1}, // #9800
  {28,  5}, // #9801
  {29,  5}, // #9802
  {30,  5}, // #9803
  {31,  5}, // #9804
  {32,  5}, // #9805
  {34,  5}, // #9806
  {35,  5}, // #9807
  {37,  1}, // #9808
  {38,  1}, // #9809
  {14,  5}, // #9810
  {15,  5}, // #9811
  {16,  5}, // #9812
  {19,  5}, // #9813
  {20,  5}, // #9814
  {21,  5}, // #9815
  {23,  5}, // #9816
  {28,  5}, // #9817
  {29,  5}, // #9818
  {30,  5}, // #9819
  {31,  5}, // #9820
  {32,  5}, // #9821
  {34,  5}, // #9822
  {35,  5}, // #9823
  {14,  4}, // #9824
  {15,  3}, // #9825
  {16,  3}, // #9826
  {19,  3}, // #9827
  {20,  3}, // #9828
  {21,  3}, // #9829
  {23,  3}, // #9830
  {26,  1}, // #9831
  {28,  3}, // #9832
  {29,  3}, // #9833
  {30,  3}, // #9834
  {31,  3}, // #9835
  {32,  3}, // #9836
  {34,  3}, // #9837
  {35,  3}, // #9838
  {37,  1}, // #9839
  {38,  1}, // #9840
  {14,  3}, // #9841
  {15,  3}, // #9842
  {16,  3}, // #9843
  {19,  3}, // #9844
  {20,  3}, // #9845
  {21,  3}, // #9846
  {23,  3}, // #9847
  {28,  3}, // #9848
  {29,  3}, // #9849
  {30,  3}, // #9850
  {31,  3}, // #9851
  {32,  3}, // #9852
  {34,  3}, // #9853
  {35,  3}, // #9854
  {14,  7}, // #9855
  {15,  6}, // #9856
  {16,  6}, // #9857
  {20,  6}, // #9858
  {21,  6}, // #9859
  {26,  1}, // #9860
  {28,  6}, // #9861
  {29,  6}, // #9862
  {31,  6}, // #9863
  {32,  6}, // #9864
  {37,  1}, // #9865
  {38,  1}, // #9866
  {14,  6}, // #9867
  {15,  6}, // #9868
  {16,  6}, // #9869
  {20,  6}, // #9870
  {21,  6}, // #9871
  {28,  6}, // #9872
  {29,  6}, // #9873
  {31,  6}, // #9874
  {32,  6}, // #9875
  {14,  9}, // #9876
  {15,  8}, // #9877
  {16,  8}, // #9878
  {20,  8}, // #9879
  {21,  8}, // #9880
  {26,  1}, // #9881
  {28,  8}, // #9882
  {29,  8}, // #9883
  {31,  8}, // #9884
  {32,  8}, // #9885
  {37,  1}, // #9886
  {38,  1}, // #9887
  {14,  8}, // #9888
  {15,  8}, // #9889
  {16,  8}, // #9890
  {20,  8}, // #9891
  {21,  8}, // #9892
  {28,  8}, // #9893
  {29,  8}, // #9894
  {31,  8}, // #9895
  {32,  8}, // #9896
  { 4,  1}, // #9897
  {36,  1}, // #9898
  {37,  2}, // #9899
  {39,  2}, // #9900
  {14,  2}, // #9901
  {26,  2}, // #9902
  {14,  2}, // #9903
  {15,  1}, // #9904
  {16,  1}, // #9905
  {19,  1}, // #9906
  {20,  1}, // #9907
  {21,  1}, // #9908
  {23,  1}, // #9909
  {26,  1}, // #9910
  {28,  1}, // #9911
  {29,  1}, // #9912
  {30,  1}, // #9913
  {31,  1}, // #9914
  {32,  1}, // #9915
  {34,  1}, // #9916
  {35,  1}, // #9917
  {37,  1}, // #9918
  {38,  1}, // #9919
  {14,  2}, // #9920
  {20,  1}, // #9921
  {26,  1}, // #9922
  {28,  1}, // #9923
  {31,  1}, // #9924
  {32,  1}, // #9925
  {33,  1}, // #9926
  {37,  1}, // #9927
  {38,  1}, // #9928
  {14,  1}, // #9929
  {20,  1}, // #9930
  {28,  1}, // #9931
  {31,  1}, // #9932
  {32,  1}, // #9933
  {33,  1}, // #9934
  {14,  3}, // #9935
  {17,  2}, // #9936
  {18,  2}, // #9937
  {19,  2}, // #9938
  {20,  2}, // #9939
  {24,  2}, // #9940
  {26,  1}, // #9941
  {28,  2}, // #9942
  {30,  2}, // #9943
  {31,  2}, // #9944
  {32,  2}, // #9945
  {34,  2}, // #9946
  {35,  2}, // #9947
  {37,  1}, // #9948
  {38,  1}, // #9949
  {14,  2}, // #9950
  {17,  2}, // #9951
  {18,  2}, // #9952
  {19,  2}, // #9953
  {20,  2}, // #9954
  {24,  2}, // #9955
  {28,  2}, // #9956
  {30,  2}, // #9957
  {31,  2}, // #9958
  {32,  2}, // #9959
  {34,  2}, // #9960
  {35,  2}, // #9961
  {14,  2}, // #9962
  {19,  1}, // #9963
  {20,  1}, // #9964
  {26,  1}, // #9965
  {28,  1}, // #9966
  {30,  1}, // #9967
  {31,  1}, // #9968
  {32,  1}, // #9969
  {34,  1}, // #9970
  {35,  1}, // #9971
  {37,  1}, // #9972
  {38,  1}, // #9973
  {14,  1}, // #9974
  {19,  1}, // #9975
  {20,  1}, // #9976
  {28,  1}, // #9977
  {30,  1}, // #9978
  {31,  1}, // #9979
  {32,  1}, // #9980
  {34,  1}, // #9981
  {35,  1}, // #9982
  { 8,  1}, // #9983
  { 9,  1}, // #9984
  {11,  1}, // #9985
  {36,  1}, // #9986
  { 4,  1}, // #9987
  {11,  6}, // #9988
  {36,  7}, // #9989
  {37,  1}, // #9990
  {38,  1}, // #9991
  {14,  3}, // #9992
  {15,  2}, // #9993
  {16,  2}, // #9994
  {20,  2}, // #9995
  {21,  2}, // #9996
  {22,  2}, // #9997
  {26,  1}, // #9998
  {28,  2}, // #9999
  {29,  2}, // #10000
  {31,  2}, // #10001
  {32,  2}, // #10002
  {33,  2}, // #10003
  {37,  1}, // #10004
  {38,  1}, // #10005
  {14,  2}, // #10006
  {15,  2}, // #10007
  {16,  2}, // #10008
  {20,  2}, // #10009
  {21,  2}, // #10010
  {22,  2}, // #10011
  {28,  2}, // #10012
  {29,  2}, // #10013
  {31,  2}, // #10014
  {32,  2}, // #10015
  {33,  2}, // #10016
  {14,  3}, // #10017
  {26,  3}, // #10018
  {37,  1}, // #10019
  {38,  1}, // #10020
  {14,  1}, // #10021
  {17,  1}, // #10022
  {18,  1}, // #10023
  {19,  1}, // #10024
  {20,  1}, // #10025
  {24,  1}, // #10026
  {28,  1}, // #10027
  {30,  1}, // #10028
  {31,  1}, // #10029
  {32,  1}, // #10030
  {34,  1}, // #10031
  {35,  1}, // #10032
  {14,  3}, // #10033
  {20,  2}, // #10034
  {26,  1}, // #10035
  {28,  2}, // #10036
  {31,  2}, // #10037
  {32,  2}, // #10038
  {37,  1}, // #10039
  {38,  1}, // #10040
  {14,  2}, // #10041
  {20,  2}, // #10042
  {28,  2}, // #10043
  {31,  2}, // #10044
  {32,  2}, // #10045
  {14,  9}, // #10046
  {20,  8}, // #10047
  {26,  1}, // #10048
  {28,  8}, // #10049
  {31,  8}, // #10050
  {32,  8}, // #10051
  {37,  1}, // #10052
  {38,  1}, // #10053
  {14,  8}, // #10054
  {20,  8}, // #10055
  {28,  8}, // #10056
  {31,  8}, // #10057
  {32,  8}, // #10058
  {14,  5}, // #10059
  {15,  4}, // #10060
  {16,  4}, // #10061
  {20,  4}, // #10062
  {21,  4}, // #10063
  {26,  1}, // #10064
  {28,  4}, // #10065
  {29,  4}, // #10066
  {31,  4}, // #10067
  {32,  4}, // #10068
  {37,  1}, // #10069
  {38,  1}, // #10070
  {14,  4}, // #10071
  {15,  4}, // #10072
  {16,  4}, // #10073
  {20,  4}, // #10074
  {21,  4}, // #10075
  {28,  4}, // #10076
  {29,  4}, // #10077
  {31,  4}, // #10078
  {32,  4}, // #10079
  {14, 13}, // #10080
  {20, 12}, // #10081
  {26,  1}, // #10082
  {28, 12}, // #10083
  {31, 12}, // #10084
  {32, 12}, // #10085
  {37,  1}, // #10086
  {38,  1}, // #10087
  {14, 12}, // #10088
  {20, 12}, // #10089
  {28, 12}, // #10090
  {31, 12}, // #10091
  {32, 12}, // #10092
  { 4,  2}, // #10093
  {36,  2}, // #10094
  {37,  3}, // #10095
  {38,  1}, // #10096
  {39,  2}, // #10097
  {14,  2}, // #10098
  {19,  1}, // #10099
  {20,  1}, // #10100
  {26,  2}, // #10101
  {27,  1}, // #10102
  {28,  1}, // #10103
  {30,  1}, // #10104
  {31,  1}, // #10105
  {32,  1}, // #10106
  {34,  1}, // #10107
  {35,  1}, // #10108
  {37,  1}, // #10109
  {38,  1}, // #10110
  {14,  1}, // #10111
  {19,  1}, // #10112
  {20,  1}, // #10113
  {26,  1}, // #10114
  {27,  1}, // #10115
  {28,  1}, // #10116
  {30,  1}, // #10117
  {31,  1}, // #10118
  {32,  1}, // #10119
  {34,  1}, // #10120
  {35,  1}, // #10121
  { 4,  1}, // #10122
  {36,  1}, // #10123
  {37,  1}, // #10124
  {39,  1}, // #10125
  {14,  1}, // #10126
  {15,  1}, // #10127
  {16,  1}, // #10128
  {19,  1}, // #10129
  {20,  1}, // #10130
  {21,  1}, // #10131
  {23,  1}, // #10132
  {28,  1}, // #10133
  {29,  1}, // #10134
  {30,  1}, // #10135
  {31,  1}, // #10136
  {32,  1}, // #10137
  {34,  1}, // #10138
  {35,  1}, // #10139
  { 4,  1}, // #10140
  { 9,  2}, // #10141
  {11,  2}, // #10142
  {36,  3}, // #10143
  {37,  1}, // #10144
  {39,  1}, // #10145
  { 9,  2}, // #10146
  {11,  2}, // #10147
  {36,  2}, // #10148
  { 4,  1}, // #10149
  {10,  4}, // #10150
  {11,  4}, // #10151
  {36,  5}, // #10152
  {37,  1}, // #10153
  {38,  1}, // #10154
  {14, 10}, // #10155
  {15,  9}, // #10156
  {16,  9}, // #10157
  {19,  9}, // #10158
  {20,  9}, // #10159
  {21,  9}, // #10160
  {23,  9}, // #10161
  {26,  1}, // #10162
  {28,  9}, // #10163
  {29,  9}, // #10164
  {30,  9}, // #10165
  {31,  9}, // #10166
  {32,  9}, // #10167
  {34,  9}, // #10168
  {35,  9}, // #10169
  {37,  1}, // #10170
  {38,  1}, // #10171
  {14,  9}, // #10172
  {15,  9}, // #10173
  {16,  9}, // #10174
  {19,  9}, // #10175
  {20,  9}, // #10176
  {21,  9}, // #10177
  {23,  9}, // #10178
  {28,  9}, // #10179
  {29,  9}, // #10180
  {30,  9}, // #10181
  {31,  9}, // #10182
  {32,  9}, // #10183
  {34,  9}, // #10184
  {35,  9}, // #10185
  {14, 23}, // #10186
  {15, 23}, // #10187
  {16, 23}, // #10188
  {19, 23}, // #10189
  {20, 23}, // #10190
  {21, 23}, // #10191
  {23, 23}, // #10192
  {28, 23}, // #10193
  {29, 23}, // #10194
  {30, 23}, // #10195
  {31, 23}, // #10196
  {32, 23}, // #10197
  {34, 23}, // #10198
  {35, 23}, // #10199
  { 4,  1}, // #10200
  {11, 60}, // #10201
  {36, 61}, // #10202
  {37,  1}, // #10203
  {39,  1}, // #10204
  {14,  2}, // #10205
  {17,  2}, // #10206
  {18,  2}, // #10207
  {20,  2}, // #10208
  {26,  1}, // #10209
  {27,  1}, // #10210
  {28,  2}, // #10211
  {31,  2}, // #10212
  {32,  2}, // #10213
  {37,  1}, // #10214
  {39,  1}, // #10215
  {14,  1}, // #10216
  {17,  1}, // #10217
  {18,  1}, // #10218
  {20,  1}, // #10219
  {26,  1}, // #10220
  {27,  1}, // #10221
  {28,  1}, // #10222
  {31,  1}, // #10223
  {32,  1}, // #10224
  {37,  1}, // #10225
  {39,  1}, // #10226
  {26,  6}, // #10227
  {27,  6}, // #10228
  {37,  1}, // #10229
  {39,  1}, // #10230
  {26,  4}, // #10231
  {27,  4}, // #10232
  {37,  1}, // #10233
  {39,  1}, // #10234
  {26, 12}, // #10235
  {27, 12}, // #10236
  {37,  1}, // #10237
  {39,  1}, // #10238
  {14,  4}, // #10239
  {19,  3}, // #10240
  {20,  3}, // #10241
  {26,  1}, // #10242
  {28,  3}, // #10243
  {30,  3}, // #10244
  {31,  3}, // #10245
  {32,  3}, // #10246
  {34,  3}, // #10247
  {35,  3}, // #10248
  {37,  1}, // #10249
  {38,  1}, // #10250
  {14,  3}, // #10251
  {19,  3}, // #10252
  {20,  3}, // #10253
  {28,  3}, // #10254
  {30,  3}, // #10255
  {31,  3}, // #10256
  {32,  3}, // #10257
  {34,  3}, // #10258
  {35,  3}, // #10259
  {14,  3}, // #10260
  {19,  2}, // #10261
  {20,  2}, // #10262
  {26,  1}, // #10263
  {28,  2}, // #10264
  {30,  2}, // #10265
  {31,  2}, // #10266
  {32,  2}, // #10267
  {34,  2}, // #10268
  {35,  2}, // #10269
  {37,  1}, // #10270
  {38,  1}, // #10271
  {14,  2}, // #10272
  {19,  2}, // #10273
  {20,  2}, // #10274
  {28,  2}, // #10275
  {30,  2}, // #10276
  {31,  2}, // #10277
  {32,  2}, // #10278
  {34,  2}, // #10279
  {35,  2}, // #10280
  { 4,  1}, // #10281
  {10,  8}, // #10282
  {11,  8}, // #10283
  {36,  9}, // #10284
  {37,  1}, // #10285
  {38,  1}, // #10286
  {37, 30}, // #10287
  { 4,  3}, // #10288
  {36,  3}, // #10289
  {37,  1}, // #10290
  {38,  1}, // #10291
  { 4,  1}, // #10292
  {11, 12}, // #10293
  {36, 13}, // #10294
  {37,  1}, // #10295
  {38,  1}, // #10296
  {11, 24}, // #10297
  {36, 24}, // #10298
  {11, 59}, // #10299
  {36, 59}, // #10300
  {10,  6}, // #10301
  {11,  6}, // #10302
  {36,  6}, // #10303
  {10,  8}, // #10304
  {11,  8}, // #10305
  {36,  8}, // #10306
  { 4,  1}, // #10307
  {14,  1}, // #10308
  {15,  1}, // #10309
  {16,  1}, // #10310
  {20,  1}, // #10311
  {21,  1}, // #10312
  {22,  1}, // #10313
  {28,  1}, // #10314
  {29,  1}, // #10315
  {31,  1}, // #10316
  {32,  1}, // #10317
  {33,  1}, // #10318
  {36,  1}, // #10319
  {37,  1}, // #10320
  {38,  1}, // #10321
  { 4,  1}, // #10322
  {14, 24}, // #10323
  {20, 24}, // #10324
  {28, 24}, // #10325
  {31, 24}, // #10326
  {32, 24}, // #10327
  {36,  1}, // #10328
  {37,  1}, // #10329
  {38,  1}, // #10330
  { 4,  1}, // #10331
  {14, 62}, // #10332
  {20, 62}, // #10333
  {28, 62}, // #10334
  {31, 62}, // #10335
  {32, 62}, // #10336
  {36,  1}, // #10337
  {37,  1}, // #10338
  {38,  1}, // #10339
  { 4,  1}, // #10340
  {11,  4}, // #10341
  {36,  5}, // #10342
  {37,  1}, // #10343
  {39,  1}, // #10344
  {14,  6}, // #10345
  {17,  6}, // #10346
  {18,  6}, // #10347
  {20,  6}, // #10348
  {28,  6}, // #10349
  {31,  6}, // #10350
  {32,  6}, // #10351
  { 4,  1}, // #10352
  {14,  1}, // #10353
  {15,  1}, // #10354
  {16,  1}, // #10355
  {19,  1}, // #10356
  {20,  1}, // #10357
  {21,  1}, // #10358
  {23,  1}, // #10359
  {28,  1}, // #10360
  {29,  1}, // #10361
  {30,  1}, // #10362
  {31,  1}, // #10363
  {32,  1}, // #10364
  {34,  1}, // #10365
  {35,  1}, // #10366
  {36,  1}, // #10367
  {37,  1}, // #10368
  {38,  1}, // #10369
  {14,  1}, // #10370
  {15,  1}, // #10371
  {16,  1}, // #10372
  {20,  1}, // #10373
  {21,  1}, // #10374
  {22,  1}, // #10375
  {26,  1}, // #10376
  {27,  1}, // #10377
  {28,  1}, // #10378
  {29,  1}, // #10379
  {31,  1}, // #10380
  {32,  1}, // #10381
  {33,  1}, // #10382
  {37,  1}, // #10383
  {39,  1}, // #10384
  { 4,  1}, // #10385
  {14,  8}, // #10386
  {20,  8}, // #10387
  {28,  8}, // #10388
  {31,  8}, // #10389
  {32,  8}, // #10390
  {36,  1}, // #10391
  {37,  1}, // #10392
  {38,  1}, // #10393
  {14,  3}, // #10394
  {20,  3}, // #10395
  {28,  3}, // #10396
  {31,  3}, // #10397
  {32,  3}, // #10398
  { 4,  1}, // #10399
  {14,  3}, // #10400
  {20,  3}, // #10401
  {28,  3}, // #10402
  {31,  3}, // #10403
  {32,  3}, // #10404
  {36,  1}, // #10405
  {37,  1}, // #10406
  {38,  1}, // #10407
  { 4,  1}, // #10408
  {14,  2}, // #10409
  {20,  2}, // #10410
  {28,  2}, // #10411
  {31,  2}, // #10412
  {32,  2}, // #10413
  {36,  1}, // #10414
  {37,  1}, // #10415
  {38,  1}, // #10416
  { 4,  1}, // #10417
  {11,  7}, // #10418
  {36,  8}, // #10419
  {37,  2}, // #10420
  {38,  1}, // #10421
  {39,  1}, // #10422
  { 4,  1}, // #10423
  {10,  2}, // #10424
  {11,  2}, // #10425
  {36,  3}, // #10426
  {37,  1}, // #10427
  {38,  1}, // #10428
  {14,  5}, // #10429
  {20,  4}, // #10430
  {26,  1}, // #10431
  {28,  4}, // #10432
  {31,  4}, // #10433
  {32,  4}, // #10434
  { 4,  1}, // #10435
  {14,  2}, // #10436
  {15,  2}, // #10437
  {16,  2}, // #10438
  {19,  2}, // #10439
  {20,  2}, // #10440
  {21,  2}, // #10441
  {23,  2}, // #10442
  {28,  2}, // #10443
  {29,  2}, // #10444
  {30,  2}, // #10445
  {31,  2}, // #10446
  {32,  2}, // #10447
  {34,  2}, // #10448
  {35,  2}, // #10449
  {36,  1}, // #10450
  {37,  1}, // #10451
  {38,  1}, // #10452
  {11,  1}, // #10453
  {41,  1}, // #10454
  {11,  0}, // #10455
  {41,  0}, // #10456
  {14,  1}, // #10457
  {28,  1}, // #10458
  {33,  1}, // #10459
  {36,  1}, // #10460
  {37,  1}, // #10461
  {13,  1}, // #10462
  {41,  1}, // #10463
  {11, 12}, // #10464
  {41, 12}, // #10465
  { 4,  1}, // #10466
  {13,  1}, // #10467
  {41,  2}, // #10468
  {42,  1}, // #10469
  {43,  1}, // #10470
  {11,  4}, // #10471
  {41,  4}, // #10472
  {11, 100}, // #10473
  {41, 100}, // #10474
  {10,  3}, // #10475
  {11,  3}, // #10476
  {41,  3}, // #10477
  {19,  1}, // #10478
  {32,  1}, // #10479
  {42,  1}, // #10480
  {44,  1}, // #10481
  {14,  1}, // #10482
  {19,  1}, // #10483
  {30,  1}, // #10484
  {42,  1}, // #10485
  {43,  1}, // #10486
  { 4,  2}, // #10487
  {11,  1}, // #10488
  {41,  3}, // #10489
  {42,  2}, // #10490
  {43,  1}, // #10491
  {44,  1}, // #10492
  {14,  2}, // #10493
  {20,  2}, // #10494
  {21,  2}, // #10495
  {24,  2}, // #10496
  {28,  2}, // #10497
  {29,  2}, // #10498
  {33,  2}, // #10499
  {34,  2}, // #10500
  {36,  2}, // #10501
  {37,  2}, // #10502
  { 4,  2}, // #10503
  {11,  4}, // #10504
  {41,  6}, // #10505
  {42,  2}, // #10506
  {43,  1}, // #10507
  {44,  1}, // #10508
  { 4,  1}, // #10509
  {11,  4}, // #10510
  {41,  5}, // #10511
  {42,  1}, // #10512
  {43,  1}, // #10513
  { 4,  1}, // #10514
  {11,  1}, // #10515
  {41,  2}, // #10516
  {42,  1}, // #10517
  {43,  1}, // #10518
  {14,  2}, // #10519
  {19,  1}, // #10520
  {22,  1}, // #10521
  {23,  1}, // #10522
  {26,  1}, // #10523
  {27,  1}, // #10524
  {28,  1}, // #10525
  {30,  1}, // #10526
  {31,  1}, // #10527
  {33,  1}, // #10528
  {36,  1}, // #10529
  {37,  1}, // #10530
  {42,  1}, // #10531
  {43,  1}, // #10532
  {14,  1}, // #10533
  {22,  1}, // #10534
  {23,  1}, // #10535
  {26,  1}, // #10536
  {27,  1}, // #10537
  {28,  1}, // #10538
  {31,  1}, // #10539
  {33,  1}, // #10540
  {36,  1}, // #10541
  {37,  1}, // #10542
  {14,  2}, // #10543
  {19,  1}, // #10544
  {20,  1}, // #10545
  {21,  1}, // #10546
  {24,  1}, // #10547
  {28,  1}, // #10548
  {29,  1}, // #10549
  {30,  1}, // #10550
  {33,  1}, // #10551
  {34,  1}, // #10552
  {36,  1}, // #10553
  {37,  1}, // #10554
  {42,  1}, // #10555
  {43,  1}, // #10556
  {14,  1}, // #10557
  {20,  1}, // #10558
  {21,  1}, // #10559
  {24,  1}, // #10560
  {28,  1}, // #10561
  {29,  1}, // #10562
  {33,  1}, // #10563
  {34,  1}, // #10564
  {36,  1}, // #10565
  {37,  1}, // #10566
  {14,  2}, // #10567
  {19,  1}, // #10568
  {28,  1}, // #10569
  {30,  1}, // #10570
  {33,  1}, // #10571
  {36,  1}, // #10572
  {37,  1}, // #10573
  {42,  1}, // #10574
  {43,  1}, // #10575
  { 4,  1}, // #10576
  {10,  1}, // #10577
  {11,  1}, // #10578
  {41,  2}, // #10579
  {42,  1}, // #10580
  {43,  1}, // #10581
  {10,  1}, // #10582
  {11,  1}, // #10583
  {41,  1}, // #10584
  { 4,  1}, // #10585
  { 6,  1}, // #10586
  {10,  1}, // #10587
  {11,  1}, // #10588
  {41,  2}, // #10589
  {42,  1}, // #10590
  {43,  1}, // #10591
  { 6,  1}, // #10592
  {10,  1}, // #10593
  {11,  1}, // #10594
  {41,  1}, // #10595
  { 4,  2}, // #10596
  {10,  1}, // #10597
  {11,  1}, // #10598
  {41,  3}, // #10599
  {42,  2}, // #10600
  {43,  1}, // #10601
  {44,  1}, // #10602
  {10,  2}, // #10603
  {11,  2}, // #10604
  {41,  2}, // #10605
  { 4,  1}, // #10606
  {41,  1}, // #10607
  {42,  1}, // #10608
  {43,  1}, // #10609
  { 4,  1}, // #10610
  { 9,  1}, // #10611
  {11,  1}, // #10612
  {41,  2}, // #10613
  {42,  1}, // #10614
  {43,  1}, // #10615
  { 9,  1}, // #10616
  {11,  1}, // #10617
  {41,  1}, // #10618
  {11, 28}, // #10619
  {41, 28}, // #10620
  {11,  8}, // #10621
  {41,  8}, // #10622
  {14,  3}, // #10623
  {19,  1}, // #10624
  {20,  2}, // #10625
  {21,  2}, // #10626
  {24,  2}, // #10627
  {28,  2}, // #10628
  {29,  2}, // #10629
  {30,  1}, // #10630
  {33,  2}, // #10631
  {34,  2}, // #10632
  {36,  2}, // #10633
  {37,  2}, // #10634
  {42,  1}, // #10635
  {43,  1}, // #10636
  {14,  3}, // #10637
  {19,  1}, // #10638
  {22,  2}, // #10639
  {23,  2}, // #10640
  {26,  2}, // #10641
  {27,  2}, // #10642
  {28,  2}, // #10643
  {30,  1}, // #10644
  {31,  2}, // #10645
  {33,  2}, // #10646
  {36,  2}, // #10647
  {37,  2}, // #10648
  {42,  1}, // #10649
  {43,  1}, // #10650
  {14,  2}, // #10651
  {22,  2}, // #10652
  {23,  2}, // #10653
  {26,  2}, // #10654
  {27,  2}, // #10655
  {28,  2}, // #10656
  {31,  2}, // #10657
  {33,  2}, // #10658
  {36,  2}, // #10659
  {37,  2}, // #10660
  {14,  6}, // #10661
  {19,  1}, // #10662
  {22,  5}, // #10663
  {23,  5}, // #10664
  {26,  5}, // #10665
  {27,  5}, // #10666
  {28,  5}, // #10667
  {30,  1}, // #10668
  {31,  5}, // #10669
  {33,  5}, // #10670
  {36,  5}, // #10671
  {37,  5}, // #10672
  {42,  1}, // #10673
  {43,  1}, // #10674
  {14,  5}, // #10675
  {22,  5}, // #10676
  {23,  5}, // #10677
  {26,  5}, // #10678
  {27,  5}, // #10679
  {28,  5}, // #10680
  {31,  5}, // #10681
  {33,  5}, // #10682
  {36,  5}, // #10683
  {37,  5}, // #10684
  { 4,  1}, // #10685
  { 5, 11}, // #10686
  { 9, 11}, // #10687
  {11, 11}, // #10688
  {13, 11}, // #10689
  {41, 12}, // #10690
  {42,  1}, // #10691
  {43,  1}, // #10692
  { 5, 11}, // #10693
  { 9, 11}, // #10694
  {11, 11}, // #10695
  {13, 11}, // #10696
  {41, 11}, // #10697
  { 4,  1}, // #10698
  { 5, 13}, // #10699
  { 9, 13}, // #10700
  {11, 13}, // #10701
  {13, 13}, // #10702
  {41, 14}, // #10703
  {42,  1}, // #10704
  {43,  1}, // #10705
  { 5, 13}, // #10706
  { 9, 13}, // #10707
  {11, 13}, // #10708
  {13, 13}, // #10709
  {41, 13}, // #10710
  { 4,  1}, // #10711
  { 5, 17}, // #10712
  { 9, 17}, // #10713
  {11, 17}, // #10714
  {13, 17}, // #10715
  {41, 18}, // #10716
  {42,  1}, // #10717
  {43,  1}, // #10718
  { 5, 17}, // #10719
  { 9, 17}, // #10720
  {11, 17}, // #10721
  {13, 17}, // #10722
  {41, 17}, // #10723
  { 4,  1}, // #10724
  { 5, 10}, // #10725
  { 9, 10}, // #10726
  {11, 10}, // #10727
  {13, 10}, // #10728
  {41, 11}, // #10729
  {42,  1}, // #10730
  {43,  1}, // #10731
  { 5, 10}, // #10732
  { 9, 10}, // #10733
  {11, 10}, // #10734
  {13, 10}, // #10735
  {41, 10}, // #10736
  {14,  6}, // #10737
  {16,  5}, // #10738
  {19,  1}, // #10739
  {20,  5}, // #10740
  {21,  5}, // #10741
  {24,  5}, // #10742
  {25,  5}, // #10743
  {27,  5}, // #10744
  {28,  5}, // #10745
  {29,  5}, // #10746
  {30,  1}, // #10747
  {33,  5}, // #10748
  {34,  5}, // #10749
  {35,  5}, // #10750
  {36,  5}, // #10751
  {37,  5}, // #10752
  {39,  5}, // #10753
  {40,  5}, // #10754
  {42,  1}, // #10755
  {43,  1}, // #10756
  {14,  5}, // #10757
  {16,  5}, // #10758
  {20,  5}, // #10759
  {21,  5}, // #10760
  {24,  5}, // #10761
  {25,  5}, // #10762
  {27,  5}, // #10763
  {28,  5}, // #10764
  {29,  5}, // #10765
  {33,  5}, // #10766
  {34,  5}, // #10767
  {35,  5}, // #10768
  {36,  5}, // #10769
  {37,  5}, // #10770
  {39,  5}, // #10771
  {40,  5}, // #10772
  {14,  4}, // #10773
  {16,  3}, // #10774
  {19,  1}, // #10775
  {20,  3}, // #10776
  {21,  3}, // #10777
  {24,  3}, // #10778
  {25,  3}, // #10779
  {27,  3}, // #10780
  {28,  3}, // #10781
  {29,  3}, // #10782
  {30,  1}, // #10783
  {33,  3}, // #10784
  {34,  3}, // #10785
  {35,  3}, // #10786
  {36,  3}, // #10787
  {37,  3}, // #10788
  {39,  3}, // #10789
  {40,  3}, // #10790
  {42,  1}, // #10791
  {43,  1}, // #10792
  {14,  3}, // #10793
  {16,  3}, // #10794
  {20,  3}, // #10795
  {21,  3}, // #10796
  {24,  3}, // #10797
  {25,  3}, // #10798
  {27,  3}, // #10799
  {28,  3}, // #10800
  {29,  3}, // #10801
  {33,  3}, // #10802
  {34,  3}, // #10803
  {35,  3}, // #10804
  {36,  3}, // #10805
  {37,  3}, // #10806
  {39,  3}, // #10807
  {40,  3}, // #10808
  {14,  7}, // #10809
  {19,  1}, // #10810
  {20,  6}, // #10811
  {21,  6}, // #10812
  {24,  6}, // #10813
  {28,  6}, // #10814
  {29,  6}, // #10815
  {30,  1}, // #10816
  {33,  6}, // #10817
  {34,  6}, // #10818
  {36,  6}, // #10819
  {37,  6}, // #10820
  {42,  1}, // #10821
  {43,  1}, // #10822
  {14,  6}, // #10823
  {20,  6}, // #10824
  {21,  6}, // #10825
  {24,  6}, // #10826
  {28,  6}, // #10827
  {29,  6}, // #10828
  {33,  6}, // #10829
  {34,  6}, // #10830
  {36,  6}, // #10831
  {37,  6}, // #10832
  {14,  9}, // #10833
  {19,  1}, // #10834
  {20,  8}, // #10835
  {21,  8}, // #10836
  {24,  8}, // #10837
  {28,  8}, // #10838
  {29,  8}, // #10839
  {30,  1}, // #10840
  {33,  8}, // #10841
  {34,  8}, // #10842
  {36,  8}, // #10843
  {37,  8}, // #10844
  {42,  1}, // #10845
  {43,  1}, // #10846
  {14,  8}, // #10847
  {20,  8}, // #10848
  {21,  8}, // #10849
  {24,  8}, // #10850
  {28,  8}, // #10851
  {29,  8}, // #10852
  {33,  8}, // #10853
  {34,  8}, // #10854
  {36,  8}, // #10855
  {37,  8}, // #10856
  { 4,  1}, // #10857
  {41,  1}, // #10858
  {42,  2}, // #10859
  {44,  2}, // #10860
  {14,  2}, // #10861
  {19,  2}, // #10862
  {30,  2}, // #10863
  {14,  2}, // #10864
  {16,  1}, // #10865
  {19,  1}, // #10866
  {20,  1}, // #10867
  {21,  1}, // #10868
  {24,  1}, // #10869
  {25,  1}, // #10870
  {27,  1}, // #10871
  {28,  1}, // #10872
  {29,  1}, // #10873
  {30,  1}, // #10874
  {33,  1}, // #10875
  {34,  1}, // #10876
  {35,  1}, // #10877
  {36,  1}, // #10878
  {37,  1}, // #10879
  {39,  1}, // #10880
  {40,  1}, // #10881
  {42,  1}, // #10882
  {43,  1}, // #10883
  {14,  2}, // #10884
  {19,  1}, // #10885
  {28,  1}, // #10886
  {30,  1}, // #10887
  {33,  1}, // #10888
  {36,  1}, // #10889
  {37,  1}, // #10890
  {38,  1}, // #10891
  {42,  1}, // #10892
  {43,  1}, // #10893
  {14,  1}, // #10894
  {28,  1}, // #10895
  {33,  1}, // #10896
  {36,  1}, // #10897
  {37,  1}, // #10898
  {38,  1}, // #10899
  {14,  3}, // #10900
  {17,  2}, // #10901
  {19,  1}, // #10902
  {22,  2}, // #10903
  {23,  2}, // #10904
  {25,  2}, // #10905
  {26,  2}, // #10906
  {27,  2}, // #10907
  {28,  2}, // #10908
  {30,  1}, // #10909
  {31,  2}, // #10910
  {33,  2}, // #10911
  {35,  2}, // #10912
  {36,  2}, // #10913
  {37,  2}, // #10914
  {39,  2}, // #10915
  {40,  2}, // #10916
  {42,  1}, // #10917
  {43,  1}, // #10918
  {14,  2}, // #10919
  {17,  2}, // #10920
  {22,  2}, // #10921
  {23,  2}, // #10922
  {25,  2}, // #10923
  {26,  2}, // #10924
  {27,  2}, // #10925
  {28,  2}, // #10926
  {31,  2}, // #10927
  {33,  2}, // #10928
  {35,  2}, // #10929
  {36,  2}, // #10930
  {37,  2}, // #10931
  {39,  2}, // #10932
  {40,  2}, // #10933
  { 4,  1}, // #10934
  { 6,  3}, // #10935
  {10,  3}, // #10936
  {11,  3}, // #10937
  {41,  4}, // #10938
  {42,  1}, // #10939
  {43,  1}, // #10940
  { 6,  3}, // #10941
  {10,  3}, // #10942
  {11,  3}, // #10943
  {41,  3}, // #10944
  { 4,  1}, // #10945
  { 6,  4}, // #10946
  {10,  4}, // #10947
  {11,  4}, // #10948
  {41,  5}, // #10949
  {42,  1}, // #10950
  {43,  1}, // #10951
  { 6,  4}, // #10952
  {10,  4}, // #10953
  {11,  4}, // #10954
  {41,  4}, // #10955
  {14,  2}, // #10956
  {19,  1}, // #10957
  {25,  1}, // #10958
  {27,  1}, // #10959
  {28,  1}, // #10960
  {30,  1}, // #10961
  {33,  1}, // #10962
  {35,  1}, // #10963
  {36,  1}, // #10964
  {37,  1}, // #10965
  {39,  1}, // #10966
  {40,  1}, // #10967
  {42,  1}, // #10968
  {43,  1}, // #10969
  {14,  1}, // #10970
  {25,  1}, // #10971
  {27,  1}, // #10972
  {28,  1}, // #10973
  {33,  1}, // #10974
  {35,  1}, // #10975
  {36,  1}, // #10976
  {37,  1}, // #10977
  {39,  1}, // #10978
  {40,  1}, // #10979
  { 8,  1}, // #10980
  { 9,  1}, // #10981
  {11,  1}, // #10982
  {41,  1}, // #10983
  { 4,  1}, // #10984
  {11,  6}, // #10985
  {41,  7}, // #10986
  {42,  1}, // #10987
  {43,  1}, // #10988
  {14,  3}, // #10989
  {15,  2}, // #10990
  {19,  1}, // #10991
  {20,  2}, // #10992
  {21,  2}, // #10993
  {24,  2}, // #10994
  {28,  2}, // #10995
  {29,  2}, // #10996
  {30,  1}, // #10997
  {33,  2}, // #10998
  {34,  2}, // #10999
  {36,  2}, // #11000
  {37,  2}, // #11001
  {38,  2}, // #11002
  {42,  1}, // #11003
  {43,  1}, // #11004
  {14,  2}, // #11005
  {15,  2}, // #11006
  {20,  2}, // #11007
  {21,  2}, // #11008
  {24,  2}, // #11009
  {28,  2}, // #11010
  {29,  2}, // #11011
  {33,  2}, // #11012
  {34,  2}, // #11013
  {36,  2}, // #11014
  {37,  2}, // #11015
  {38,  2}, // #11016
  {14,  3}, // #11017
  {19,  3}, // #11018
  {30,  3}, // #11019
  {42,  1}, // #11020
  {43,  1}, // #11021
  {14,  1}, // #11022
  {17,  1}, // #11023
  {22,  1}, // #11024
  {23,  1}, // #11025
  {25,  1}, // #11026
  {26,  1}, // #11027
  {27,  1}, // #11028
  {28,  1}, // #11029
  {31,  1}, // #11030
  {33,  1}, // #11031
  {35,  1}, // #11032
  {36,  1}, // #11033
  {37,  1}, // #11034
  {39,  1}, // #11035
  {40,  1}, // #11036
  {14,  3}, // #11037
  {19,  1}, // #11038
  {28,  2}, // #11039
  {30,  1}, // #11040
  {33,  2}, // #11041
  {36,  2}, // #11042
  {37,  2}, // #11043
  {42,  1}, // #11044
  {43,  1}, // #11045
  {14,  2}, // #11046
  {28,  2}, // #11047
  {33,  2}, // #11048
  {36,  2}, // #11049
  {37,  2}, // #11050
  {14,  9}, // #11051
  {19,  1}, // #11052
  {28,  8}, // #11053
  {30,  1}, // #11054
  {33,  8}, // #11055
  {36,  8}, // #11056
  {37,  8}, // #11057
  {42,  1}, // #11058
  {43,  1}, // #11059
  {14,  8}, // #11060
  {28,  8}, // #11061
  {33,  8}, // #11062
  {36,  8}, // #11063
  {37,  8}, // #11064
  {14,  5}, // #11065
  {19,  1}, // #11066
  {20,  4}, // #11067
  {21,  4}, // #11068
  {24,  4}, // #11069
  {28,  4}, // #11070
  {29,  4}, // #11071
  {30,  1}, // #11072
  {33,  4}, // #11073
  {34,  4}, // #11074
  {36,  4}, // #11075
  {37,  4}, // #11076
  {42,  1}, // #11077
  {43,  1}, // #11078
  {14,  4}, // #11079
  {20,  4}, // #11080
  {21,  4}, // #11081
  {24,  4}, // #11082
  {28,  4}, // #11083
  {29,  4}, // #11084
  {33,  4}, // #11085
  {34,  4}, // #11086
  {36,  4}, // #11087
  {37,  4}, // #11088
  {14, 13}, // #11089
  {19,  1}, // #11090
  {28, 12}, // #11091
  {30,  1}, // #11092
  {33, 12}, // #11093
  {36, 12}, // #11094
  {37, 12}, // #11095
  {42,  1}, // #11096
  {43,  1}, // #11097
  {14, 12}, // #11098
  {28, 12}, // #11099
  {33, 12}, // #11100
  {36, 12}, // #11101
  {37, 12}, // #11102
  { 4,  2}, // #11103
  {41,  2}, // #11104
  {42,  3}, // #11105
  {43,  1}, // #11106
  {44,  2}, // #11107
  {14,  3}, // #11108
  {19,  1}, // #11109
  {25,  2}, // #11110
  {27,  2}, // #11111
  {28,  2}, // #11112
  {30,  1}, // #11113
  {33,  2}, // #11114
  {35,  2}, // #11115
  {36,  2}, // #11116
  {37,  2}, // #11117
  {39,  2}, // #11118
  {40,  2}, // #11119
  {42,  1}, // #11120
  {43,  1}, // #11121
  {14,  2}, // #11122
  {25,  2}, // #11123
  {27,  2}, // #11124
  {28,  2}, // #11125
  {33,  2}, // #11126
  {35,  2}, // #11127
  {36,  2}, // #11128
  {37,  2}, // #11129
  {39,  2}, // #11130
  {40,  2}, // #11131
  {14,  2}, // #11132
  {19,  2}, // #11133
  {25,  1}, // #11134
  {27,  1}, // #11135
  {28,  1}, // #11136
  {30,  1}, // #11137
  {32,  1}, // #11138
  {33,  1}, // #11139
  {35,  1}, // #11140
  {36,  1}, // #11141
  {37,  1}, // #11142
  {39,  1}, // #11143
  {40,  1}, // #11144
  {42,  1}, // #11145
  {43,  1}, // #11146
  {14,  1}, // #11147
  {19,  1}, // #11148
  {25,  1}, // #11149
  {27,  1}, // #11150
  {28,  1}, // #11151
  {32,  1}, // #11152
  {33,  1}, // #11153
  {35,  1}, // #11154
  {36,  1}, // #11155
  {37,  1}, // #11156
  {39,  1}, // #11157
  {40,  1}, // #11158
  { 4,  1}, // #11159
  {41,  1}, // #11160
  {42,  1}, // #11161
  {44,  1}, // #11162
  {14,  1}, // #11163
  {16,  1}, // #11164
  {20,  1}, // #11165
  {21,  1}, // #11166
  {24,  1}, // #11167
  {25,  1}, // #11168
  {27,  1}, // #11169
  {28,  1}, // #11170
  {29,  1}, // #11171
  {33,  1}, // #11172
  {34,  1}, // #11173
  {35,  1}, // #11174
  {36,  1}, // #11175
  {37,  1}, // #11176
  {39,  1}, // #11177
  {40,  1}, // #11178
  { 4,  1}, // #11179
  { 9,  2}, // #11180
  {11,  2}, // #11181
  {41,  3}, // #11182
  {42,  1}, // #11183
  {44,  1}, // #11184
  { 9,  2}, // #11185
  {11,  2}, // #11186
  {41,  2}, // #11187
  { 4,  1}, // #11188
  {10,  4}, // #11189
  {11,  4}, // #11190
  {41,  5}, // #11191
  {42,  1}, // #11192
  {43,  1}, // #11193
  {14, 10}, // #11194
  {16,  9}, // #11195
  {19,  1}, // #11196
  {20,  9}, // #11197
  {21,  9}, // #11198
  {24,  9}, // #11199
  {25,  9}, // #11200
  {27,  9}, // #11201
  {28,  9}, // #11202
  {29,  9}, // #11203
  {30,  1}, // #11204
  {33,  9}, // #11205
  {34,  9}, // #11206
  {35,  9}, // #11207
  {36,  9}, // #11208
  {37,  9}, // #11209
  {39,  9}, // #11210
  {40,  9}, // #11211
  {42,  1}, // #11212
  {43,  1}, // #11213
  {14,  9}, // #11214
  {16,  9}, // #11215
  {20,  9}, // #11216
  {21,  9}, // #11217
  {24,  9}, // #11218
  {25,  9}, // #11219
  {27,  9}, // #11220
  {28,  9}, // #11221
  {29,  9}, // #11222
  {33,  9}, // #11223
  {34,  9}, // #11224
  {35,  9}, // #11225
  {36,  9}, // #11226
  {37,  9}, // #11227
  {39,  9}, // #11228
  {40,  9}, // #11229
  {14, 23}, // #11230
  {16, 23}, // #11231
  {20, 23}, // #11232
  {21, 23}, // #11233
  {24, 23}, // #11234
  {25, 23}, // #11235
  {27, 23}, // #11236
  {28, 23}, // #11237
  {29, 23}, // #11238
  {33, 23}, // #11239
  {34, 23}, // #11240
  {35, 23}, // #11241
  {36, 23}, // #11242
  {37, 23}, // #11243
  {39, 23}, // #11244
  {40, 23}, // #11245
  { 4,  1}, // #11246
  {11, 60}, // #11247
  {41, 61}, // #11248
  {42,  1}, // #11249
  {44,  1}, // #11250
  {14,  5}, // #11251
  {19,  1}, // #11252
  {22,  4}, // #11253
  {23,  4}, // #11254
  {26,  4}, // #11255
  {27,  4}, // #11256
  {28,  4}, // #11257
  {30,  1}, // #11258
  {31,  4}, // #11259
  {33,  4}, // #11260
  {36,  4}, // #11261
  {37,  4}, // #11262
  {42,  1}, // #11263
  {43,  1}, // #11264
  {14,  4}, // #11265
  {22,  4}, // #11266
  {23,  4}, // #11267
  {26,  4}, // #11268
  {27,  4}, // #11269
  {28,  4}, // #11270
  {31,  4}, // #11271
  {33,  4}, // #11272
  {36,  4}, // #11273
  {37,  4}, // #11274
  {14,  2}, // #11275
  {19,  1}, // #11276
  {22,  2}, // #11277
  {23,  2}, // #11278
  {26,  2}, // #11279
  {27,  2}, // #11280
  {28,  2}, // #11281
  {31,  2}, // #11282
  {32,  1}, // #11283
  {33,  2}, // #11284
  {36,  2}, // #11285
  {37,  2}, // #11286
  {42,  1}, // #11287
  {44,  1}, // #11288
  {14,  1}, // #11289
  {19,  1}, // #11290
  {22,  1}, // #11291
  {23,  1}, // #11292
  {26,  1}, // #11293
  {27,  1}, // #11294
  {28,  1}, // #11295
  {31,  1}, // #11296
  {32,  1}, // #11297
  {33,  1}, // #11298
  {36,  1}, // #11299
  {37,  1}, // #11300
  {42,  1}, // #11301
  {44,  1}, // #11302
  {14,  5}, // #11303
  {19,  1}, // #11304
  {28,  4}, // #11305
  {30,  1}, // #11306
  {33,  4}, // #11307
  {36,  4}, // #11308
  {37,  4}, // #11309
  {42,  1}, // #11310
  {43,  1}, // #11311
  {14,  4}, // #11312
  {28,  4}, // #11313
  {33,  4}, // #11314
  {36,  4}, // #11315
  {37,  4}, // #11316
  {14, 11}, // #11317
  {16, 10}, // #11318
  {19,  1}, // #11319
  {20, 10}, // #11320
  {21, 10}, // #11321
  {24, 10}, // #11322
  {25, 10}, // #11323
  {27, 10}, // #11324
  {28, 10}, // #11325
  {29, 10}, // #11326
  {30,  1}, // #11327
  {33, 10}, // #11328
  {34, 10}, // #11329
  {35, 10}, // #11330
  {36, 10}, // #11331
  {37, 10}, // #11332
  {39, 10}, // #11333
  {40, 10}, // #11334
  {42,  1}, // #11335
  {43,  1}, // #11336
  {14, 10}, // #11337
  {16, 10}, // #11338
  {20, 10}, // #11339
  {21, 10}, // #11340
  {24, 10}, // #11341
  {25, 10}, // #11342
  {27, 10}, // #11343
  {28, 10}, // #11344
  {29, 10}, // #11345
  {33, 10}, // #11346
  {34, 10}, // #11347
  {35, 10}, // #11348
  {36, 10}, // #11349
  {37, 10}, // #11350
  {39, 10}, // #11351
  {40, 10}, // #11352
  {14,  7}, // #11353
  {16,  6}, // #11354
  {19,  1}, // #11355
  {20,  6}, // #11356
  {21,  6}, // #11357
  {24,  6}, // #11358
  {25,  6}, // #11359
  {27,  6}, // #11360
  {28,  6}, // #11361
  {29,  6}, // #11362
  {30,  1}, // #11363
  {33,  6}, // #11364
  {34,  6}, // #11365
  {35,  6}, // #11366
  {36,  6}, // #11367
  {37,  6}, // #11368
  {39,  6}, // #11369
  {40,  6}, // #11370
  {42,  1}, // #11371
  {43,  1}, // #11372
  {14,  6}, // #11373
  {16,  6}, // #11374
  {20,  6}, // #11375
  {21,  6}, // #11376
  {24,  6}, // #11377
  {25,  6}, // #11378
  {27,  6}, // #11379
  {28,  6}, // #11380
  {29,  6}, // #11381
  {33,  6}, // #11382
  {34,  6}, // #11383
  {35,  6}, // #11384
  {36,  6}, // #11385
  {37,  6}, // #11386
  {39,  6}, // #11387
  {40,  6}, // #11388
  {14,  3}, // #11389
  {19,  1}, // #11390
  {28,  2}, // #11391
  {30,  1}, // #11392
  {33,  2}, // #11393
  {36,  2}, // #11394
  {37,  2}, // #11395
  {38,  2}, // #11396
  {42,  1}, // #11397
  {43,  1}, // #11398
  {14,  2}, // #11399
  {28,  2}, // #11400
  {33,  2}, // #11401
  {36,  2}, // #11402
  {37,  2}, // #11403
  {38,  2}, // #11404
  {19,  6}, // #11405
  {32,  6}, // #11406
  {42,  1}, // #11407
  {44,  1}, // #11408
  {19,  4}, // #11409
  {32,  4}, // #11410
  {42,  1}, // #11411
  {44,  1}, // #11412
  {19, 12}, // #11413
  {32, 12}, // #11414
  {42,  1}, // #11415
  {44,  1}, // #11416
  {14,  4}, // #11417
  {15,  3}, // #11418
  {19,  1}, // #11419
  {20,  3}, // #11420
  {21,  3}, // #11421
  {24,  3}, // #11422
  {28,  3}, // #11423
  {29,  3}, // #11424
  {30,  1}, // #11425
  {33,  3}, // #11426
  {34,  3}, // #11427
  {36,  3}, // #11428
  {37,  3}, // #11429
  {38,  3}, // #11430
  {42,  1}, // #11431
  {43,  1}, // #11432
  {14,  3}, // #11433
  {15,  3}, // #11434
  {20,  3}, // #11435
  {21,  3}, // #11436
  {24,  3}, // #11437
  {28,  3}, // #11438
  {29,  3}, // #11439
  {33,  3}, // #11440
  {34,  3}, // #11441
  {36,  3}, // #11442
  {37,  3}, // #11443
  {38,  3}, // #11444
  {14,  4}, // #11445
  {19,  1}, // #11446
  {25,  3}, // #11447
  {27,  3}, // #11448
  {28,  3}, // #11449
  {30,  1}, // #11450
  {33,  3}, // #11451
  {35,  3}, // #11452
  {36,  3}, // #11453
  {37,  3}, // #11454
  {39,  3}, // #11455
  {40,  3}, // #11456
  {42,  1}, // #11457
  {43,  1}, // #11458
  {14,  3}, // #11459
  {25,  3}, // #11460
  {27,  3}, // #11461
  {28,  3}, // #11462
  {33,  3}, // #11463
  {35,  3}, // #11464
  {36,  3}, // #11465
  {37,  3}, // #11466
  {39,  3}, // #11467
  {40,  3}, // #11468
  {14,  3}, // #11469
  {16,  2}, // #11470
  {19,  1}, // #11471
  {20,  2}, // #11472
  {21,  2}, // #11473
  {24,  2}, // #11474
  {25,  2}, // #11475
  {27,  2}, // #11476
  {28,  2}, // #11477
  {29,  2}, // #11478
  {30,  1}, // #11479
  {33,  2}, // #11480
  {34,  2}, // #11481
  {35,  2}, // #11482
  {36,  2}, // #11483
  {37,  2}, // #11484
  {39,  2}, // #11485
  {40,  2}, // #11486
  {42,  1}, // #11487
  {43,  1}, // #11488
  {14,  2}, // #11489
  {16,  2}, // #11490
  {20,  2}, // #11491
  {21,  2}, // #11492
  {24,  2}, // #11493
  {25,  2}, // #11494
  {27,  2}, // #11495
  {28,  2}, // #11496
  {29,  2}, // #11497
  {33,  2}, // #11498
  {34,  2}, // #11499
  {35,  2}, // #11500
  {36,  2}, // #11501
  {37,  2}, // #11502
  {39,  2}, // #11503
  {40,  2}, // #11504
  {14, 19}, // #11505
  {16, 18}, // #11506
  {19,  1}, // #11507
  {20, 18}, // #11508
  {21, 18}, // #11509
  {24, 18}, // #11510
  {25, 18}, // #11511
  {27, 18}, // #11512
  {28, 18}, // #11513
  {29, 18}, // #11514
  {30,  1}, // #11515
  {33, 18}, // #11516
  {34, 18}, // #11517
  {35, 18}, // #11518
  {36, 18}, // #11519
  {37, 18}, // #11520
  {39, 18}, // #11521
  {40, 18}, // #11522
  {42,  1}, // #11523
  {43,  1}, // #11524
  {14, 18}, // #11525
  {16, 18}, // #11526
  {20, 18}, // #11527
  {21, 18}, // #11528
  {24, 18}, // #11529
  {25, 18}, // #11530
  {27, 18}, // #11531
  {28, 18}, // #11532
  {29, 18}, // #11533
  {33, 18}, // #11534
  {34, 18}, // #11535
  {35, 18}, // #11536
  {36, 18}, // #11537
  {37, 18}, // #11538
  {39, 18}, // #11539
  {40, 18}, // #11540
  { 4,  1}, // #11541
  {10,  8}, // #11542
  {11,  8}, // #11543
  {41,  9}, // #11544
  {42,  1}, // #11545
  {43,  1}, // #11546
  {42, 30}, // #11547
  { 4,  1}, // #11548
  {11,  2}, // #11549
  {41,  3}, // #11550
  {42,  1}, // #11551
  {43,  1}, // #11552
  { 4,  3}, // #11553
  {41,  3}, // #11554
  {42,  1}, // #11555
  {43,  1}, // #11556
  { 4,  1}, // #11557
  {11, 12}, // #11558
  {41, 13}, // #11559
  {42,  1}, // #11560
  {43,  1}, // #11561
  {11, 24}, // #11562
  {41, 24}, // #11563
  {11, 59}, // #11564
  {41, 59}, // #11565
  {10,  6}, // #11566
  {11,  6}, // #11567
  {41,  6}, // #11568
  {10,  8}, // #11569
  {11,  8}, // #11570
  {41,  8}, // #11571
  { 4,  1}, // #11572
  {14,  1}, // #11573
  {15,  1}, // #11574
  {20,  1}, // #11575
  {21,  1}, // #11576
  {24,  1}, // #11577
  {28,  1}, // #11578
  {29,  1}, // #11579
  {33,  1}, // #11580
  {34,  1}, // #11581
  {36,  1}, // #11582
  {37,  1}, // #11583
  {38,  1}, // #11584
  {41,  1}, // #11585
  {42,  1}, // #11586
  {43,  1}, // #11587
  { 4,  1}, // #11588
  {14, 24}, // #11589
  {28, 24}, // #11590
  {33, 24}, // #11591
  {36, 24}, // #11592
  {37, 24}, // #11593
  {41,  1}, // #11594
  {42,  1}, // #11595
  {43,  1}, // #11596
  { 4,  1}, // #11597
  {14, 62}, // #11598
  {28, 62}, // #11599
  {33, 62}, // #11600
  {36, 62}, // #11601
  {37, 62}, // #11602
  {41,  1}, // #11603
  {42,  1}, // #11604
  {43,  1}, // #11605
  { 4,  1}, // #11606
  {11,  4}, // #11607
  {41,  5}, // #11608
  {42,  1}, // #11609
  {44,  1}, // #11610
  { 4,  1}, // #11611
  {14,  1}, // #11612
  {16,  1}, // #11613
  {20,  1}, // #11614
  {21,  1}, // #11615
  {24,  1}, // #11616
  {25,  1}, // #11617
  {27,  1}, // #11618
  {28,  1}, // #11619
  {29,  1}, // #11620
  {33,  1}, // #11621
  {34,  1}, // #11622
  {35,  1}, // #11623
  {36,  1}, // #11624
  {37,  1}, // #11625
  {39,  1}, // #11626
  {40,  1}, // #11627
  {41,  1}, // #11628
  {42,  1}, // #11629
  {43,  1}, // #11630
  {14,  1}, // #11631
  {15,  1}, // #11632
  {19,  1}, // #11633
  {20,  1}, // #11634
  {21,  1}, // #11635
  {24,  1}, // #11636
  {28,  1}, // #11637
  {29,  1}, // #11638
  {32,  1}, // #11639
  {33,  1}, // #11640
  {34,  1}, // #11641
  {36,  1}, // #11642
  {37,  1}, // #11643
  {38,  1}, // #11644
  {42,  1}, // #11645
  {44,  1}, // #11646
  { 4,  1}, // #11647
  {14,  8}, // #11648
  {28,  8}, // #11649
  {33,  8}, // #11650
  {36,  8}, // #11651
  {37,  8}, // #11652
  {41,  1}, // #11653
  {42,  1}, // #11654
  {43,  1}, // #11655
  {14,  3}, // #11656
  {28,  3}, // #11657
  {33,  3}, // #11658
  {36,  3}, // #11659
  {37,  3}, // #11660
  { 4,  1}, // #11661
  {14,  3}, // #11662
  {28,  3}, // #11663
  {33,  3}, // #11664
  {36,  3}, // #11665
  {37,  3}, // #11666
  {41,  1}, // #11667
  {42,  1}, // #11668
  {43,  1}, // #11669
  { 4,  1}, // #11670
  {14,  2}, // #11671
  {28,  2}, // #11672
  {33,  2}, // #11673
  {36,  2}, // #11674
  {37,  2}, // #11675
  {41,  1}, // #11676
  {42,  1}, // #11677
  {43,  1}, // #11678
  { 4,  1}, // #11679
  {11,  7}, // #11680
  {41,  8}, // #11681
  {42,  2}, // #11682
  {43,  1}, // #11683
  {44,  1}, // #11684
  { 4,  1}, // #11685
  {10,  2}, // #11686
  {11,  2}, // #11687
  {41,  3}, // #11688
  {42,  1}, // #11689
  {43,  1}, // #11690
  { 4,  1}, // #11691
  {14,  2}, // #11692
  {16,  2}, // #11693
  {20,  2}, // #11694
  {21,  2}, // #11695
  {24,  2}, // #11696
  {25,  2}, // #11697
  {27,  2}, // #11698
  {28,  2}, // #11699
  {29,  2}, // #11700
  {33,  2}, // #11701
  {34,  2}, // #11702
  {35,  2}, // #11703
  {36,  2}, // #11704
  {37,  2}, // #11705
  {39,  2}, // #11706
  {40,  2}, // #11707
  {41,  1}, // #11708
  {42,  1}, // #11709
  {43,  1}, // #11710
  {14,  1}, // #11711
  {30,  1}, // #11712
  {14,  6}, // #11713
  {22,  6}, // #11714
  {23,  6}, // #11715
  {26,  6}, // #11716
  {27,  6}, // #11717
  {28,  6}, // #11718
  {31,  6}, // #11719
  {33,  6}, // #11720
  {36,  6}, // #11721
  {37,  6}, // #11722
  {14,  4}, // #11723
  {25,  4}, // #11724
  {27,  4}, // #11725
  {28,  4}, // #11726
  {33,  4}, // #11727
  {35,  4}, // #11728
  {36,  4}, // #11729
  {37,  4}, // #11730
  {39,  4}, // #11731
  {40,  4}, // #11732
  {14,  5}, // #11733
  {25,  5}, // #11734
  {27,  5}, // #11735
  {28,  5}, // #11736
  {33,  5}, // #11737
  {35,  5}, // #11738
  {36,  5}, // #11739
  {37,  5}, // #11740
  {39,  5}, // #11741
  {40,  5}, // #11742
  {14,  3}, // #11743
  {20,  3}, // #11744
  {21,  3}, // #11745
  {24,  3}, // #11746
  {28,  3}, // #11747
  {29,  3}, // #11748
  {33,  3}, // #11749
  {34,  3}, // #11750
  {36,  3}, // #11751
  {37,  3}, // #11752
  {14,  5}, // #11753
  {20,  5}, // #11754
  {21,  5}, // #11755
  {24,  5}, // #11756
  {28,  5}, // #11757
  {29,  5}, // #11758
  {33,  5}, // #11759
  {34,  5}, // #11760
  {36,  5}, // #11761
  {37,  5}, // #11762
  {14,  6}, // #11763
  {20,  2}, // #11764
  {21,  2}, // #11765
  {22,  2}, // #11766
  {23,  2}, // #11767
  {24,  2}, // #11768
  {25,  2}, // #11769
  {26,  2}, // #11770
  {27,  4}, // #11771
  {28,  6}, // #11772
  {29,  2}, // #11773
  {31,  2}, // #11774
  {33,  6}, // #11775
  {34,  2}, // #11776
  {35,  2}, // #11777
  {36,  6}, // #11778
  {37,  6}, // #11779
  {39,  2}, // #11780
  {40,  2}, // #11781
  {14,  2}, // #11782
  {27,  2}, // #11783
  {28,  2}, // #11784
  {33,  2}, // #11785
  {36,  2}, // #11786
  {37,  2} // #11787
}; // X86WriteProcResTable

// {Cycles, WriteResourceID}
extern const llvm::MCWriteLatencyEntry X86WriteLatencyTable[] = {
  { 0,  0}, // Invalid
  { 1,  0}, // #1 WriteALU_WriteZero_WriteVecALU_WriteJump_WriteMove_WriteADC_WriteFSign_WriteNop_WriteFLogic_WriteFBlend_WriteFVarBlend_WriteBSWAP32_WriteBitTest_WriteBitTestSet_WriteCMOV_WriteFCom_WriteVecALUX_WriteFLDC_WriteFShuffle_WriteVecLogicX_WriteShuffle_WriteFLD0_WriteFLD1_WriteLEA_WriteVecMoveX_WriteVecShiftImm_WriteFMoveX_WriteShuffleX_WriteVarBlend_WriteBlend_WriteVarShuffleX_WriteVecShiftImmX_WriteRMW_WriteShift_WriteShuffleY_WriteFLogicY_WriteFBlendY_WriteVecALUY_WriteFMoveY_WriteFShuffleY_WriteVecMoveY_WriteVecLogicY_WriteBlendY_WriteFVarShuffleY_WriteVecShiftImmY_WriteVarVecShift_WriteVarVecShiftY_WriteVarShuffleY_ADLPWriteResGroup40_ADLPWriteResGroup155_ADLPWriteResGroup151_ADLPWriteResGroup188_ADLPWriteResGroup189_ADLPWriteResGroup57_ADLPWriteResGroup21_ADLPWriteResGroup54_ADLPWriteResGroup22_ADLPWriteResGroup191_ADLPWriteResGroup6_ADLPWriteResGroup212_ADLPWriteResGroup173_ADLPWriteResGroup74_ADLPWriteResGroup77_ADLPWriteResGroup85_ADLPWriteResGroup128_ADLPWriteResGroup129_ADLPWriteResGroup130_ADLPWriteResGroup137_ADLPWriteResGroup144_ADLPWriteResGroup187_ADLPWriteResGroup210_ADLPWriteResGroup235_WriteCMPXCHGRMW_WriteJumpLd_WriteFStoreX_WriteFLoadX_AtomWrite0_1_WriteADCLd_WriteALULd_WriteFLogicLd_WriteBSWAP64_WriteBitTestImmLd_WriteLoad_WriteCMOVLd_WriteStore_WriteVecExtractSt_WriteVecALUXLd_WriteFShuffleLd_WriteVecLoadX_WriteFence_WriteVecStoreX_WriteVecMoveFromGpr_WriteVecStoreNT_WriteVecALULd_WriteShuffleLd_WriteVecLogicLd_WriteVecInsertLd_WriteVarShuffleLd_WriteVecLoadNT_WriteStoreNT_WriteFStoreNTX_WriteShuffleXLd_WriteVecLogicXLd_WriteRotate_WriteRotateCL_WriteShiftLd_WriteShiftCL_WriteSETCC_WriteVecShiftImmXLd_WriteFTestLd_AtomWrite1_1_AtomWrite0_1_1_AtomWrite01_1_WriteFStoreY_WriteBZHI_WriteFCMOV_WriteXCHG_WriteFComX_WriteVecTest_WriteSETCCStore_WriteFSqrt80_WriteSTMXCSR_WriteShuffle256_WriteVarShuffle256_WriteVecStoreY_WriteVPMOV256_WriteVecTestY_WriteFTestY_PdWriteTST_F_UCOM_FPPr_PdWriteLEA16r_PdWriteADCSBB64ri32_PdWriteVMOVUPDYmrVMOVUPSYmr_PdWriteVMOVDQUYmr_PdWriteMOVDQArr_PdWriteSETGEmSETGmSETLEmSETLm_WriteBLS_WriteLAHFSAHF_WriteVecMoveToGpr_WriteMMXMOVMSK_WriteVecStoreNTY_WriteFStoreNTY_BWWriteResGroup10_BWWriteResGroup2_BWWriteResGroup5_BWWriteResGroup6_BWWriteResGroup3_BWWriteResGroup4_BWWriteResGroup7_BWWriteResGroup8_BWWriteResGroup9_WriteBEXTR_WriteLZCNT_WritePHAdd_WritePOPCNT_WriteFShuffle256_JWriteVecExtractF128_JWriteZeroIdiomYmm_WriteShuffleZ_WriteFLogicZ_WriteVecALUZ_WriteFMoveZ_WriteFShuffleZ_WriteVecMoveZ_WriteVecLogicZ_WriteFVarShuffleZ_WriteVecShiftImmZ_WriteVarVecShiftZ_WriteVarShuffleZ_SKXWriteResGroup9_SKXWriteResGroup11_SKXWriteResGroup3_SKXWriteResGroup6_SKXWriteResGroup7_SKXWriteResGroup4_SKXWriteResGroup8_SKXWriteResGroup10_SKXWritePSUB_WriteCvtSS2SD_WriteFVarShuffle256_SBWriteResGroup2_SBWriteResGroup1_SBWriteResGroup4_SBWriteResGroup5_SBWriteResGroupVzeroupper_WriteBitTestRegLd_HWWriteBTRSCmr_HWWrite2P1_HWWriteP01_HWWrite2P01_HWWrite2P0156_P23_HWWriteResGroup1_HWWriteINTO_HWWritePushA_HWWritePopA_HWWriteP1_HWWriteBOUND_HWWriteResGroup3_HWWriteResGroup6_HWWriteResGroup7_HWWrite3P01_HWWriteP0156_P23_HWWriteRETI_HWWriteRDPMC_HWWriteRDRAND_HWWriteFNSAVE_HWWriteFRSTOR_HWWriteResGroup2_HWWriteResGroup4_HWWriteResGroup5_HWWriteResGroup8_HWWriteResGroup9_HWWriteResGroup10_HWWriteADC0_WriteSHDrri_WriteSHDrrcl_WriteFMaskedStore64_WriteFMaskedStore32_WriteVecMaskedStore32_WriteVecMaskedStore64_ICXWriteResGroup9_ICXWriteResGroup11_ICXWriteResGroup3_ICXWriteResGroup6_ICXWriteResGroup7_ICXWriteResGroup4_ICXWriteResGroup8_ICXWriteResGroup10_ICXWritePSUB_SKLWriteResGroup9_SKLWriteResGroup11_SKLWriteResGroup3_SKLWriteResGroup6_SKLWriteResGroup7_SKLWriteResGroup4_SKLWriteResGroup8_SKLWriteResGroup10_SKLWritePSUB_WriteFCmp64X_WriteFCmpX_WriteFMOVMSK_WriteVecMOVMSK_WriteVecShiftX_WriteFVarBlendY_WriteFCmp64Y_WriteFCmpY_WriteVarBlendY_WriteVecShiftY_ZnWriteFPU3Lat1_ZnWriteFLDr_ZnWriteFPU0Lat1_ZnWriteFXCH_ZnWriteJCXZ_ZnWriteLD_F80m_ZnWriteLOOPE_ZnWriteCMPXCHG8B_ZnWriteRET_ZnWritePCMPGTQr_ZnWriteFPU01Y_ZnWriteCALLr_ZnXADD_ZnWriteFPU013_ZnWriteSHA1MSG2r_ZnWriteSHA1NEXTEr_Zn2WriteFPU3Lat1_Zn2WriteFLDr_Zn2WriteFPU0Lat1_Zn2WriteFXCH_Zn2WriteJCXZ_Zn2WriteLD_F80m_Zn2WriteLOOPE_Zn2WriteCMPXCHG8B_Zn2WriteRET_Zn2WritePCMPGTQr_Zn2WriteFPU01Y_Zn2WriteCALLr_Zn2XADD_Zn2WriteFPU013_Zn2WriteSHA1MSG2r_Zn2WriteSHA1NEXTEr_Zn2WriteXCHG_WriteFMaskedStore64Y_WriteFMaskedStore32Y_WriteVecMaskedStore32Y_WriteVecMaskedStore64Y_WriteVecMOVMSKY_Zn3WriteLFENCE_Zn3WriteMoveExtend_Zn3WriteVecALUXMMX_Zn3WriteRotateR1_Zn3WriteMOVMMX_Zn3WriteSFENCE_Zn3WriteMOVBEmr_Zn3WriteCvtPD2IMMX_Zn3WriteSHA1MSG2rr_SHA1NEXTErr_Zn3WriteALUSlow_Zn3WriteMaterialize32bitImm_Zn3WriteADC8mr_SBB8mr_Zn3WriteWriteXCHGUnrenameable_Zn3WritePOPCNT16rr_Zn3WriteLZCNT16rr_Zn3WriteMOVMMXSlow_Zn3WriteVecALUXSlow_Zn3WriteVecALUYSlow_WriteBSF_WriteBSR_WriteCvtSD2I_WriteFVarBlendZ_WriteVarBlendZ_WriteVecShiftZ_Zn4WriteLFENCE_Zn4WriteMoveExtend_Zn4WriteRotateR1_Zn4WriteMOVMMX_Zn4WriteSFENCE_Zn4WriteMOVBEmr_Zn4WriteSHA1MSG2rr_SHA1NEXTErr_Zn4WriteALUSlow_Zn4WriteMaterialize32bitImm_Zn4WriteADC8mr_SBB8mr_Zn4WriteWriteXCHGUnrenameable_Zn4WritePOPCNT16rr_Zn4WriteLZCNT16rr_Zn4WriteMOVMMXSlow_Zn4WriteVecALUYSlow_Zn4WriteVecOpMask_Zn4WriteVecOpMaskMemMov_Zn4WriteVecOpMaskKRMov_Zn4WriteSHIFTri
  {12,  0}, // #2 WriteCMPXCHGRMW_WriteFStoreX_WriteFStoreY_WriteRMW_WriteAESDecEncLd_WriteAESKeyGenLd_WriteCvtPD2ILd_WriteCvtPD2PSLd_WriteCvtSD2ILd_WriteCvtSD2SSLd_WriteCvtSS2ILd_WriteStore_WriteFHAddLd_WriteVecStoreX_WriteShiftLd_WriteSHDmrcl_WriteSHDmri_WriteFSqrtX_WriteSTMXCSR_WriteFCmp64YLd_WriteFCmpYLd_WriteCvtI2PDYLd_WriteCvtI2PSYLd_WriteCvtPS2IYLd_WriteCvtPS2PDYLd_WriteCvtPH2PSYLd_WriteCvtPH2PSLd_WriteCvtPS2PHYSt_WriteCvtPS2PHSt_WriteFMAYLd_WriteVecStoreY_WriteMPSADYLd_WriteFMul64YLd_WriteFMulYLd_WriteVecTestYLd_WriteFRcpYLd_WriteFRsqrtYLd_WriteFSqrtY_ADLPWriteResGroup36_ADLPWriteResGroup179_ADLPWriteResGroup50_ADLPWriteResGroup176_ADLPWriteResGroup142_ADLPWriteResGroup139_ADLPWriteResGroup120_ADLPWriteResGroup115_ADLPWriteResGroup229_ADLPWriteResGroup69_ADLPWriteResGroup127_ADLPWriteResGroup134_WriteIMul64Ld_WriteIMul64RegLd_WriteDiv8_WriteVecExtract_WriteIDiv8_WriteFMOVMSK_WriteCLMul_WritePCmpIStrMLd_WriteVecMOVMSK_PdWriteRCL8rCL_PdWriteRCR8ri_PdWriteVPCLMULQDQrr_WriteMPSADLd_WriteCvtPD2PSYLd_WriteCvtPD2IYLd_WriteFRndYLd_BWWriteResGroup135_WriteCvtSS2SDLd_WritePCmpIStrILd_WriteDPPSY_WriteCLMulLd_WriteVecIMulYLd_WriteVecIMulZLd_SKXWriteResGroup200_SKXWriteResGroup175_SKXWriteResGroup176_SKXWriteResGroup177_WriteAESIMC_WritePSADBWYLd_WritePSADBWZLd_WriteFHAddYLd_WriteFMul64ZLd_WriteFMulZLd_WritePMULLDYLd_WritePMULLDZLd_SBWriteResGroup111_WriteFRndLd_WriteFMAZLd_WriteCvtI2PDZLd_WriteCvtPD2IZLd_HWWriteResGroup91_3_WriteDPPD_WriteFRcpXLd_WriteFRsqrtXLd_ICXWriteResGroup200_ICXWriteResGroup175_ICXWriteResGroup176_ICXWriteResGroup177_WriteCvtI2PDLd_WriteCvtI2PSLd_WriteCvtPS2ILd_WriteCvtI2SDLd_WriteCvtI2SSLd_WriteFRcpLd_WriteFRsqrtLd_WriteFMALd_WriteFMAXLd_ZnWriteCVTPD2DQLd_ZnWriteFIST_ZnWriteFPU03_ZnWriteCVSTSI2SILd_Zn2WriteFIST_Zn2WriteFPU03_WriteVarShuffle256Ld_WriteFRcpZLd_WriteFRsqrtZLd
  { 6,  0}, // #3 WriteJumpLd_WriteBEXTR_WriteBitTestImmLd_WriteFHAdd_WriteCvtPH2PS_WriteCvtPS2PH_WriteVecTestY_ADLPWriteResGroup95_ADLPWriteResGroup5_ADLPWriteResGroup94_ADLPWriteResGroup154_ADLPWriteResGroup238_ADLPWriteResGroup53_ADLPWriteResGroup234_ADLPWriteResGroup30_ADLPWriteResGroup209_ADLPWriteResGroup111_ADLPWriteResGroup232_ADLPWriteResGroup224_ADLPWriteResGroup228_ADLPWriteResGroup141_ADLPWriteResGroup153_WriteFAdd64X_WriteFCmp64X_WriteFCmpX_WriteCvtI2PS_WriteCvtPS2I_WriteCvtI2SD_WriteCvtI2SS_WriteCvtSS2SD_WriteIMul16Reg_WriteIMul16Imm_WriteIMul32_WriteFLD1_AtomWrite01_6_PdWriteALURMW_WriteRMW_WriteBEXTRLd_WriteBLSLd_WriteFComXLd_WriteCRC32Ld_WriteFComLd_WriteIMul64_WriteIMul64Reg_WriteIMul64Imm_WriteLZCNTLd_WriteVecInsertLd_WriteStore_WriteVecTestLd_WriteTZCNTLd_WriteShuffle256Ld_WriteVarShuffle256Ld_WriteFMaskedStore64Y_WriteFMaskedLoadY_WriteFMaskedStore32Y_WriteVecMaskedLoadY_WriteVPMOV256Ld_WriteVecTestYLd_WriteFTestYLd_WriteFTestLd_PdWriteXLAT_PdWriteVBROADCASTYLd_PdWriteXADDm_PdWriteFCOMPm_PdWriteMMX_CVTPD2PIrrMMX_CVTPI2PDrr_PdWriteLXADD_PdWriteBMI1m_PdWriteCRC32r32r32_PdWriteMMX_CVTTPD2PIrr_WriteFLoadY_WriteADCLd_WriteALULd_WriteFLogicLd_WriteFBlendLd_WriteBitTestRegLd_WriteBZHILd_WriteCMOVLd_WriteCvtPS2PDLd_WriteCvtSS2SDLd_WriteVecALUXLd_WriteFShuffleLd_WriteVecALULd_WriteShuffleLd_WriteVecLogicLd_WriteVarShuffleLd_WriteVecShiftLd_WriteShuffleXLd_WriteVecLogicXLd_WriteBlendLd_WriteVarShuffleXLd_WriteShiftLd_WriteFRnd_WriteSHDrrcl_WriteCvtI2PDY_WriteCvtPD2PSY_WriteCvtPD2IY_WriteCvtPH2PSYLd_WriteCvtPH2PSLd_WriteCvtPS2PHY_WriteFRndY_WriteVecLoadY_WriteVecLoadNTY_WriteFVarShuffleLd_WriteVecShiftImmXLd_BWWriteResGroup69_BWWriteResGroup66_BWWriteResGroup70_BWWriteResGroup58_BWWriteResGroup71_BWWriteResGroup36b_BWWriteResGroup65_BWWriteResGroup62_BWWriteResGroup68_BWWriteResGroup59_BWWriteResGroup64_WriteIMul16Ld_WriteIMul16RegLd_WriteIMul32Ld_WriteIMul32RegLd_WriteIMul32ImmLd_WriteIMul8Ld_WritePHAddLd_WriteFLogicYLd_WriteFBlendYLd_WriteFShuffle256Ld_WriteFShuffleYLd_JWriteVBROADCASTYLd_WriteFLoadX_WriteCvtSD2I_WriteCvtSS2I_WriteVecLoadX_WriteCLMul_WriteCvtPS2PHSt_WriteFHAddY_SKXWriteResGroup86_SKXWriteResGroup72_SKXWriteResGroup81_SKXWriteResGroup82_SKXWriteResGroup87_SKXWriteResGroup88_SKXWriteResGroup44c_SKXWriteResGroup71_SKXWriteResGroup76_SKXWriteResGroup84_SKXWriteResGroup92a_SKXWriteResGroup79_SKXWriteResGroup73_SKXWriteResGroup80_SBWriteResGroup48_SBWriteResGroup53_SBWriteResGroup81_SBWriteResGroup49_SBWriteResGroup51_SBWriteResGroup52_WriteCvtI2PDZ_WriteCvtPD2IZ_WriteCvtPS2PHZ_WriteFRndZ_HWWriteResGroup18_HWWriteResGroup108_HWWriteResGroup60b_HWWriteResGroup0_HWWriteResGroup14_HWWriteResGroup107_HWWriteResGroup13_HWWriteResGroup16_WriteFAddXLd_WriteFAdd64Ld_WriteFAddLd_WriteFCmp64XLd_WriteFCmpXLd_WriteFCmp64Ld_WriteFCmpLd_WriteCMPXCHG_WritePHAddX_WritePOPCNTLd_WriteFRndLd_ICXWriteResGroup86_ICXWriteResGroup72_ICXWriteResGroup81_ICXWriteResGroup82_ICXWriteResGroup87_ICXWriteResGroup88_ICXWriteResGroup44c_ICXWriteResGroup71_ICXWriteResGroup76_ICXWriteResGroup84_ICXWriteResGroup79_ICXWriteResGroup73_ICXWriteResGroup80_SKLWriteResGroup82_SKLWriteResGroup68_SKLWriteResGroup76_SKLWriteResGroup78_SKLWriteResGroup83_SKLWriteResGroup84_SKLWriteResGroup42c_SKLWriteResGroup67_SKLWriteResGroup72_SKLWriteResGroup80_SKLWriteResGroup88_SKLWriteResGroup75_SKLWriteResGroup69_ZnWriteBTRSCm_ZnWriteSHA1RNDS4r_Zn2WriteBTRSCm_Zn2WriteSHA1RNDS4r_WritePCmpEStrI_WritePCmpEStrM_WritePCmpIStrM_WriteSHDmrcl_WriteSHDmri_Zn3WriteXCHG32rm_XCHG64rm_Zn3Writerm_SHA256MSG1rm_Zn3WriteSHA1RNDS4rri_Zn3WriteSHA1MSG1rm_Zn3WriteVPERMYri_WriteCvtPD2PSZ_WriteCvtPS2PDZ_Zn4WriteXCHG32rm_XCHG64rm_Zn4Writerm_SHA256MSG1rm_Zn4WriteSHA1RNDS4rri_Zn4WriteSHA1MSG1rm_Zn4WriteVPERMYri_Zn4WriteSCALErr_Zn4WriteBF16_Zn4CONFLICTrr
  {100,  0}, // #4 WriteSystem_WriteMicrocoded_ADLPWriteResGroup168_ADLPWriteResGroup198_ADLPWriteResGroup68_ADLPWriteResGroup269_ADLPWriteResGroup27_ADLPWriteResGroup201_ADLPWriteResGroup203_ADLPWriteResGroup28_ADLPWriteResGroup82_ADLPWriteResGroup96_ADLPWriteResGroup97_ADLPWriteResGroup98_ADLPWriteResGroup99_ADLPWriteResGroup100_ADLPWriteResGroup101_ADLPWriteResGroup135_ADLPWriteResGroup166_ADLPWriteResGroup167_ADLPWriteResGroup184_ADLPWriteResGroup185_ADLPWriteResGroup186_ADLPWriteResGroup199_ADLPWriteResGroup200_ADLPWriteResGroup205_ADLPWriteResGroup218_ADLPWriteResGroup236_ADLPWriteResGroup239_ADLPWriteResGroup270_ZnWriteMicrocoded_Zn2WriteMicrocoded
  { 3,  0}, // #5 WriteSHDrri_WriteFAdd64X_WriteFAddX_WriteBSF_WriteBSR_WriteBZHI_WriteFCMOV_WriteCMPXCHG_WriteFComX_WriteCRC32_WriteIMul16Reg_WriteIMul32Reg_WriteIMul32Imm_WriteIMul64Reg_WriteIMul64Imm_WriteIMul8_WriteLAHFSAHF_WriteLZCNT_WriteVecMoveToGpr_WriteVecMoveFromGpr_WritePHAdd_WriteMMXMOVMSK_WritePSADBW_WriteVarShuffle_WriteFMOVMSK_WriteCLMul_WriteVecMOVMSK_WritePOPCNT_WritePSADBWX_WriteTZCNT_WriteFAdd64Y_WriteFAddY_WriteFVarBlendY_WriteShuffle256_WriteFShuffle256_WriteVarShuffle256_WritePSADBWY_WriteVarBlendY_WriteFVarShuffle256_WriteVPMOV256_WriteFTest_ADLPWriteResGroup23_ADLPWriteResGroup104_ADLPWriteResGroup103_ADLPWriteResGroup63_ADLPWriteResGroup118_ADLPWriteResGroup20_ADLPWriteResGroup64_ADLPWriteResGroup170_ADLPWriteResGroup119_ADLPWriteResGroup16_ADLPWriteResGroup24_ADLPWriteResGroup19_ADLPWriteResGroup226_ADLPWriteResGroup124_ADLPWriteResGroup8_ADLPWriteResGroup217_ADLPWriteResGroup245_WriteVecShiftLd_WriteVecShiftXLd_AtomWrite01_3_WriteCMPXCHGRMW_WriteFLDC_WriteFLD0_WriteFLD1_WriteFStoreNTX_WriteVarShuffleX_WriteSHDrrcl_WriteFStoreNTY_WriteFVarShuffleY_WriteVarVecShift_PdWriteCMPXCHG8rm_PdWriteCMPXCHG8rr_PdWriteCMPXCHG16rm_CMPXCHG32rm_CMPXCHG64rm_PdWriteCMPXCHG8B_PdWriteCMPXCHG16B_PdWriteSHLD16rrCLSHLD32rrCLSHRD32rrCL_PdWriteEXTRQ_PdWriteINSERTQI_WriteFCmp64X_WriteFCmpX_WriteCvtI2PS_WriteCvtPS2I_WriteFMul64X_WriteFMulX_WriteMULX32_WriteMULX64_WritePHAddX_WriteRotateCL_WriteShiftCL_WriteFCmp64Y_WriteFCmpY_WriteCvtI2PSY_WriteCvtPS2IY_WriteFMul64Y_WriteFMulY_WritePHAddY_WriteVecMOVMSKY_WriteVarVecShiftY_BWWriteResGroup34_BWWriteResGroup38_BWWriteResGroup37_BWWriteResGroup27_BWWriteResGroup28_BWWriteResGroup33_BWWriteSETA_SETBEm_WriteAESDecEnc_WriteLoad_WriteCvtI2PD_WriteCvtPD2I_WriteCvtPD2PS_WriteVecExtractSt_WriteLDMXCSR_WriteMPSAD_WriteVecTest_WriteFRnd_WriteCvtPH2PSY_WriteCvtI2PDY_WriteCvtPS2PH_WriteFRndY_JSlowLEA16r_JWriteCMPXCHG8rr_WriteCvtPS2PD_WriteCvtSS2SD_WriteCvtPD2IY_WriteCvtPD2IZ_WriteCvtPS2IZ_WriteCvtPS2PDY_WriteCvtPS2PDZ_WritePSADBWZ_WriteVecTestY_SKXWriteResGroup42_SKXWriteResGroup34_SKXWriteResGroup48_SKXWriteResGroup47_SKXWriteResGroup45_SKXWriteResGroup43_SKXWriteResGroup31_SKXWriteResGroup32_SKXWriteResGroup41_SKXWriteResGroup30_SKXWriteResGroup37_SKXWriteResGroup38_SKXWritePCMPGTQ_SKXWriteSETA_SETBEm_WriteVecALU_WriteFAdd64Z_WriteFAddZ_WriteFCmpZ_WriteCvtI2PSZ_WriteCvtPH2PSZ_WriteCvtPS2PHY_WriteCvtPS2PHZ_WriteFRndZ_WriteFCmp64Z_SBWriteResGroup30_SBWriteResGroup21_SBWriteResGroup22_SBWriteResGroup24_SBWriteResGroup26_2_SBWriteCMOVA_CMOVBErr_SBWriteSETA_SETBEm_WriteVarVecShiftZ_HWWriteResGroup58_HWWriteResGroup45_HWWriteResGroup44_HWWriteResGroup50_HWWriteResGroup51_HWWriteResGroup57_HWWriteCMOVA_CMOVBErr_HWWriteSETA_SETBEm_WriteFLoadX_WriteXCHG_WriteVecLoadX_WriteVecLoadNT_WriteFMaskedLoad_WriteVecMaskedLoad_ICXWriteResGroup42_ICXWriteResGroup34_ICXWriteResGroup48_ICXWriteResGroup47_ICXWriteResGroup45_ICXWriteResGroup43_ICXWriteResGroup31_ICXWriteResGroup32_ICXWriteResGroup41_ICXWriteResGroup30_ICXWriteResGroup37_ICXWriteResGroup38_ICXWritePCMPGTQ_ICXWriteSETA_SETBEm_SKLWriteResGroup40_SKLWriteResGroup32_SKLWriteResGroup46_SKLWriteResGroup45_SKLWriteResGroup43_SKLWriteResGroup41_SKLWriteResGroup29_SKLWriteResGroup30_SKLWriteResGroup39_SKLWriteResGroup35_SKLWriteResGroup36_SKLWritePCMPGTQ_SKLWriteSETA_SETBEm_ZnWriteCVTPS2PDr_ZnWriteMul16_ZnWriteMul32_ZnWriteVCVTPS2PDY_Zn2WriteCVTPD2PSr_Zn2WriteCVTPS2PDr_Zn2WriteCVTSS2SDr_Zn2WriteMul16_Zn2WriteMul32_Zn2WriteCVTPD2PSYr_Zn2WriteVCVTPS2PDY_WriteFTestY_Zn2WriteCVTPD2DQr_Zn2WriteCVTDQ2PDr_Zn2WriteCVSTSI2SDr_Zn2WriteEXTRQ_WriteCvtSD2SS_WriteCvtI2SD_WriteCvtI2SS_WriteVecIMulX_WritePHMINPOS_WritePMULLD_WriteFRcpX_WriteFRsqrtX_WriteVecIMulY_WritePMULLDY_WriteFRcpY_WriteFRsqrtY_Zn3WriteCvtI2PSMMX_Zn3WriteCMPXCHG8rr_Zn3WriteCMPXCHG8B_Zn3WriteRotateRightRI_Zn3WriteRotateRightRCL_Zn3WritePDEP_PEXT_Zn3WriteVPERM2I128rr_VPERM2F128rr_Zn3WriteEXTRQI_INSERTQI_Zn3WriteSHA256MSG2rr_Zn3WriteEXTRQ_INSERTQ_WriteVecIMulZ_WriteFMul64Z_WriteFMulZ_WriteFVarShuffleZ_WritePMULLDZ_Zn4WriteCMPXCHG8rr_Zn4WriteCMPXCHG8B_Zn4WriteRotateRightRI_Zn4WriteRotateRightRCL_Zn4WritePDEP_PEXT_Zn4WriteVPERM2I128rr_VPERM2F128rr_Zn4WriteEXTRQI_INSERTQI_Zn4WriteSHA256MSG2rr_Zn4WriteEXTRQ_INSERTQ_Zn4VPTESTZ128_Zn4PERMIT2_128
  { 7,  0}, // #6 WriteFLoadX_WriteAESKeyGen_WriteBLSLd_WriteCMOVLd_WriteCvtSD2I_WriteCvtI2SD_WriteCvtI2SS_WriteCvtSS2I_WriteVecLoadX_WriteLDMXCSR_WriteVecLoadNT_WriteCvtI2PDY_WriteCvtPD2PSY_WriteCvtPD2IY_WriteCvtPS2PDY_ADLPWriteResGroup112_ADLPWriteResGroup152_ADLPWriteResGroup92_ADLPWriteResGroup58_ADLPWriteResGroup278_ADLPWriteResGroup208_ADLPWriteResGroup241_ADLPWriteResGroup78_ADLPWriteResGroup18_ADLPWriteResGroup52_ADLPWriteResGroup13_ADLPWriteResGroup143_ADLPWriteResGroup195_ADLPWriteResGroup106_ADLPWriteResGroup140_ADLPWriteResGroup0_ADLPWriteResGroup12_ADLPWriteResGroup41_ADLPWriteResGroup256_WriteFAdd64XLd_WriteFCmp64XLd_WriteFCmpXLd_WriteCvtI2PSLd_WriteCvtPS2ILd_WriteCvtI2SDLd_WriteCvtI2SSLd_WriteCvtSS2SDLd_WriteIMul16_WriteIMul16RegLd_WriteIMul16ImmLd_WriteIMul32Ld_WriteIMul8Ld_WritePHAddX_AtomWrite0_1_7_AtomWrite0_1_7_4_AtomWrite01_7_WriteFLogicLd_WriteFBlendLd_WriteFVarBlendLd_WriteBSFLd_PdWriteBTSIm_PdWriteBTSRm_WriteFCmp64Ld_WriteFCmpLd_WriteVecALUXLd_WriteFShuffleLd_WriteVecALULd_WriteShuffleLd_WriteVecLogicLd_WriteShuffleXLd_WriteVecLogicXLd_WriteVarBlendLd_WriteBlendLd_WritePCmpIStrM_WritePHAddXLd_WriteShuffleYLd_WriteFLogicYLd_WriteFVarBlendYLd_WriteFBlendYLd_WriteFShuffle256Ld_WriteFCmp64YLd_WriteFCmpYLd_WriteFShuffleYLd_WriteVecShiftImmXLd_PdWriteRCR32riRCR64ri_PdWriteVBROADCASTF128_PdWriteRCL3264rCL_PdWriteVEXTRACTF128mr_PdWriteRCR3264rCL_PdWriteVPPERMLd_WriteRMW_WriteAESDecEnc_WriteBEXTRLd_WriteMPSAD_WriteVecShiftXLd_WriteVecTestLd_WriteCvtPS2PHYSt_WriteVecALUYLd_WriteFMaskedLoad_WriteMPSADY_WriteVecLogicYLd_WriteBlendYLd_WriteFVarShuffleYLd_WriteVecMaskedLoad_WriteVecShiftImmYLd_WriteVarShuffleYLd_WriteVecShiftYLd_WriteFTestYLd_BWWriteResGroup80_BWWriteResGroup82_BWWriteResGroup90_BWWriteResGroup84_BWWriteResGroup89_BWWriteResGroup87_BWWriteResGroup88_BWWriteResGroup73_BWWriteResGroup77_BWWriteResGroup79_BWWriteResGroup74_BWWriteCMOVA_CMOVBErm_WriteAESIMCLd_WriteAESKeyGenLd_WriteCvtPS2PDLd_WriteCvtSD2SS_WriteVecIMulXLd_WriteVecIMulLd_WritePSADBWLd_WriteVarShuffleLd_WriteFMulXLd_WriteFMulLd_WriteCLMulLd_WritePCmpIStrI_WritePHMINPOSLd_WritePSADBWXLd_WriteVarShuffleXLd_WriteFRcpXLd_WriteFRcpLd_WriteFRsqrtXLd_WriteFRsqrtLd_WriteCvtPS2PDYLd_WriteFMulYLd_WriteFRcpYLd_WriteFRsqrtYLd_WriteFLoadY_WriteFComXLd_WriteFComLd_WriteCvtPH2PSY_WriteCvtPD2PSZ_WriteCvtPH2PSZ_WriteCvtPS2PHZ_WriteVecLoadY_WriteVecLoadNTY_WriteFVarShuffleLd_WriteVarVecShiftLd_SKXWriteResGroup100_SKXWriteResGroup99_SKXWriteResGroup95_SKXWriteResGroup89_SKXWriteResGroup101_SKXWriteResGroup111_SKXWriteResGroup104_SKXWriteResGroup109_SKXWriteResGroup107_SKXWriteResGroup108_SKXWriteResGroup96_SKXWriteResGroup90_SKXWriteResGroup93_SKXWriteResGroup92_SKXWriteResGroup93z_SKXWriteResGroup97_SKXWriteResGroup103_SKXWriteResGroup106_SKXWriteResGroup110_SKXWriteResGroup112_SKXWriteResGroup113_SKXWriteResGroup114_SKXWriteCMOVA_CMOVBErm_WriteADCLd_WriteVecInsertLd_WriteCvtPS2PDZLd_WriteFRcpZ_WriteFRsqrtZ_WriteFTestLd_SBWriteResGroup69_SBWriteResGroup25_1_SBWriteResGroup63_SBWriteResGroup68_SBWriteResGroup54_SBWriteResGroup58_SBWriteResGroup59_SBWriteResGroup62_SBWriteResGroup64_SBWriteResGroup66_SBWriteResGroup67_WriteCvtPH2PSYLd_WriteCvtPH2PSZLd_WriteCvtPS2PHZSt_HWWriteResGroup25_HWWriteResGroup37_HWWriteResGroup26_HWWriteResGroup0_1_HWWriteResGroup39_HWWriteXLAT_HWWriteResGroup114_HWWriteResGroup41_HWWriteResGroup17_HWWriteResGroup11_1_HWWriteResGroup36_2_WriteCvtSD2SSLd_WriteIMul64_WriteFMul64X_SLMWriteResGroup1rm_ICXWriteResGroup100_ICXWriteResGroup99_ICXWriteResGroup95_ICXWriteResGroup89_ICXWriteResGroup101_ICXWriteResGroup111_ICXWriteResGroup104_ICXWriteResGroup109_ICXWriteResGroup107_ICXWriteResGroup108_ICXWriteResGroup96_ICXWriteResGroup92_ICXWriteResGroup90_ICXWriteResGroup93_ICXWriteResGroup93z_ICXWriteResGroup97_ICXWriteResGroup103_ICXWriteResGroup106_ICXWriteResGroup110_ICXWriteResGroup112_ICXWriteResGroup113_ICXWriteResGroup114_ICXWriteCMOVA_CMOVBErm_SKLWriteResGroup95_SKLWriteResGroup94_SKLWriteResGroup91_SKLWriteResGroup85_SKLWriteResGroup96_SKLWriteResGroup103_SKLWriteResGroup98_SKLWriteResGroup102_SKLWriteResGroup100_SKLWriteResGroup101_SKLWriteResGroup92_SKLWriteCMOVA_CMOVBErm_WriteFHAdd_WriteIMulHLd_WriteFHAddY_Zn2WriteMul16Ld_Zn2WriteMul32Ld_WriteMULX32Ld_WriteMULX64Ld_WriteFCMOV_WriteCRC32Ld_WriteIMul16Ld_WriteIMul32RegLd_WriteIMul32ImmLd_WriteIMul64Ld_WriteIMul64RegLd_WriteIMul64ImmLd_WriteFVarShuffle256_Zn3WriteRotateRightMCL_Zn3WriteCMPXCHG8rm_LCMPXCHG8_Zn3WriteVPERM2F128rm_Zn3WriteSHA256MSG2rm_Zn3WriteXCHG8rm_XCHG16rm_Zn3WriteRotateRightMI_WriteDPPD_Zn4WriteRotateRightMCL_Zn4WriteCMPXCHG8rm_LCMPXCHG8_Zn4WriteVPERM2F128rm_Zn4WriteSHA256MSG2rm_Zn4WriteXCHG8rm_XCHG16rm_Zn4WriteRotateRightMI_Zn4WriteVPERMPSYrr
  { 8,  0}, // #7 WriteFLoadY_WriteAESIMC_WriteFLogicLd_WriteFBlendLd_WriteFVarBlendLd_WriteBSFLd_WriteBSRLd_WriteBZHILd_WriteFComXLd_WriteCRC32Ld_WriteFComLd_WriteVecALUXLd_WriteIMul16RegLd_WriteIMul32RegLd_WriteIMul32ImmLd_WriteIMul64RegLd_WriteIMul64ImmLd_WriteIMul8Ld_WriteFShuffleLd_WriteLZCNTLd_WriteVecInsertLd_WriteShuffleXLd_WriteVecLogicXLd_WriteVarBlendLd_WriteBlendLd_WritePOPCNTLd_WriteVarShuffleXLd_WriteVecShiftXLd_WriteFRnd_WriteTZCNTLd_WriteCvtPH2PSY_WriteCvtPS2PHY_WriteFRndY_WriteVecLoadY_WriteFMaskedLoad_WriteVecLoadNTY_WriteFVarShuffleLd_WriteVecMaskedLoad_WriteVarVecShiftLd_WriteFTestLd_ADLPWriteResGroup37_ADLPWriteResGroup38_ADLPWriteResGroup171_ADLPWriteResGroup117_ADLPWriteResGroup175_ADLPWriteResGroup192_ADLPWriteResGroup172_ADLPWriteResGroup110_ADLPWriteResGroup225_ADLPWriteResGroup147_ADLPWriteResGroup150_ADLPWriteResGroup216_ADLPWriteResGroup240_WriteCvtI2PDLd_WriteCvtPD2ILd_WriteCvtPS2PDLd_WriteCvtSD2I_WriteCvtSS2I_WriteFHAdd_WriteIMul16Ld_WritePHAddXLd_AtomWrite01_8_WriteCvtPD2PS_WriteIMul32Ld_WriteVarShuffleLd_WriteVecShiftLd_WriteMPSAD_WriteCvtI2PDY_WriteCvtPD2PSY_WriteCvtPD2IY_WriteCvtPS2PDY_WriteFVarShuffleYLd_PdWriteVPERM2F128rm_PdWriteRCL3264ri_WriteCMPXCHGRMW_BWWriteResGroup100_WriteFAdd64XLd_WriteFAddXLd_WriteFAdd64Ld_WriteFAddLd_WriteFCmp64XLd_WriteFCmpXLd_WriteFCmp64Ld_WriteFCmpLd_WriteCvtI2PSLd_WriteCvtPS2ILd_WriteIMul16ImmLd_WritePHAddLd_WriteFMul64XLd_WriteFMulXLd_WriteFMul64Ld_WriteFMulLd_WriteMULX32Ld_WriteMULX64Ld_WriteFVarBlendYLd_WriteFMaskedLoadY_WriteVarBlendYLd_WriteVecMaskedLoadY_BWWriteResGroup97_BWWriteResGroup99_BWWriteResGroup154_BWWriteResGroup91_BWWriteResGroup92_WriteAESDecEncLd_WriteCvtPD2PSLd_WriteVecMoveFromGpr_WriteMPSADLd_WritePCmpIStrM_WriteVecTestLd_WriteFRndLd_WriteFAdd64YLd_WriteFAddYLd_WriteCvtI2PDYLd_WriteCvtI2PSYLd_WriteCvtPS2IYLd_WriteCvtPH2PSYLd_WriteCvtPH2PSLd_WriteFRndYLd_SKXWriteResGroup130_WriteCvtSS2SDLd_WritePSADBWLd_WriteShuffleYLd_WriteShuffleZLd_WriteFLogicYLd_WriteFLogicZLd_WriteFBlendYLd_WriteCvtPD2IYLd_WriteCvtPD2IZLd_WriteCvtPS2IZLd_WriteCvtPS2PDYLd_WriteCvtPS2PDZLd_WriteCvtPS2PHYSt_WriteCvtPS2PHZSt_WriteFRndZ_WriteVecALUYLd_WriteVecALUZLd_WriteFShuffleYLd_WriteFShuffleZLd_WriteVecLogicYLd_WriteVecLogicZLd_WriteBlendYLd_WriteVarBlendZLd_WriteFVarShuffleZLd_WriteVecShiftImmYLd_WriteVecShiftImmZLd_WriteVarVecShiftYLd_WriteVarVecShiftZLd_WriteVarShuffleYLd_WriteVarShuffleZLd_WriteVecShiftYLd_WriteVecShiftZLd_SKXWriteResGroup127_SKXWriteResGroup128_SKXWriteResGroup118_SKXWriteResGroup119_SKXWriteResGroup121_SKXWriteResGroup123_SKXWriteResGroup131_SKXWriteResGroup132_SKXWriteResGroup133_SKXWriteResGroup134_WriteAESKeyGen_WriteVecALULd_WriteSHDmri_WriteShuffle256Ld_WriteFShuffle256Ld_WriteVarShuffle256Ld_WriteCvtPH2PSZLd_WriteFVarShuffle256Ld_WriteVPMOV256Ld_WriteFTestYLd_SBWriteResGroup86_SBWriteResGroup84_SBWriteResGroup77_SBWriteResGroup83_SBWriteResGroup85_SBWriteResGroup87_SBWriteCMOVA_CMOVBErm_HWWriteResGroup12_HWWriteResGroup48_HWWriteResGroup46_HWWriteResGroup47_HWWriteResGroup145_HWWriteResGroup11_2_HWWriteResGroup13_1_HWWriteResGroup17_2_HWWriteCMOVA_CMOVBErm_WriteCvtSD2ILd_WriteCvtI2SDLd_WriteCvtI2SSLd_WriteCvtSS2ILd_WriteVecIMulXLd_WritePSADBWXLd_SLMWriteResGroup2rm_ICXWriteResGroup130_ICXWriteResGroup127_ICXWriteResGroup128_ICXWriteResGroup118_ICXWriteResGroup119_ICXWriteResGroup121_ICXWriteResGroup123_ICXWriteResGroup131_ICXWriteResGroup132_ICXWriteResGroup133_ICXWriteResGroup134_SKLWriteResGroup119_SKLWriteResGroup116_SKLWriteResGroup117_SKLWriteResGroup107_SKLWriteResGroup108_SKLWriteResGroup110_SKLWriteResGroup112_WriteFLoadX_ZnWriteMul16Ld_ZnWriteMul32Ld_WriteVecLoadX_ZnWriteFPU13_WriteShuffleLd_WriteVecLogicLd_WriteFStoreNT_WriteFCmp64YLd_WriteFCmpYLd_WriteVecShiftImmXLd_ZnWriteLEAVE_ZnWritePushA_ZnWritePCMPGTQm_ZnWriteBROADCAST_ZnWriteFPU01Op2_ZnWriteVPBROADCAST256Ld_ZnWritePCMPGTQYm_ZnWriteFPU0Lat1Ld_ZnWriteVPBROADCAST128Ld_ZnWriteFPU013m_ZnWriteSHA1MSG2Ld_ZnWriteSHA1NEXTELd_Zn2WriteMul64Ld_Zn2WriteFPU13_Zn2WriteLEAVE_Zn2WritePushA_Zn2WritePCMPGTQm_Zn2WriteBROADCAST_Zn2WriteFPU01Op2_Zn2WriteVPBROADCAST256Ld_Zn2WritePCMPGTQYm_Zn2WriteFPU0Lat1Ld_Zn2WriteVPBROADCAST128Ld_Zn2WriteFPU013m_Zn2WriteSHA1MSG2Ld_Zn2WriteSHA1NEXTELd_WriteFLD0_WriteVecTestYLd_Zn3WriteRotateLeftMI_Zn3WriteVINSERTF128rmr_Zn3WriteRotateLeftMCL_Zn3WriteVEXTRACTI128mr_WriteFVarBlendZLd_Zn4WriteRotateLeftMI_Zn4WriteVINSERTF128rmr_Zn4WriteRotateLeftMCL_Zn4WriteVEXTRACTI128mr
  {11,  0}, // #8 WriteADCLd_WriteALULd_WriteBEXTRLd_WriteBitTestRegLd_WriteFCmp64XLd_WriteFCmpXLd_WriteFCmp64Ld_WriteFCmpLd_WriteCvtI2PDLd_WriteCvtI2PSLd_WriteCvtPS2ILd_WriteCvtPS2PDLd_WriteCvtI2SDLd_WriteCvtI2SSLd_WriteCvtSS2SDLd_WriteFDivX_WritePHAddLd_WritePSADBWLd_WriteVarShuffleLd_WriteMPSADLd_WriteFMul64XLd_WriteFMulXLd_WriteFMul64Ld_WriteFMulLd_WritePCmpIStrI_WritePCmpIStrM_WritePHMINPOSLd_WriteFRcpXLd_WriteFRcpLd_WriteFRsqrtXLd_WriteFRsqrtLd_WriteFMALd_WriteFAdd64YLd_WriteFAddYLd_WriteShuffle256Ld_WriteFShuffle256Ld_WriteVarShuffle256Ld_WritePSADBWYLd_WriteFDivY_WriteFMAXLd_WriteFVarShuffle256Ld_WriteVPMOV256Ld_WriteFTestYLd_ADLPWriteResGroup56_ADLPWriteResGroup156_ADLPWriteResGroup263_ADLPWriteResGroup123_AtomWrite01_11_WriteCvtPD2PS_WriteCvtSD2SSLd_WriteFHAdd_WriteVecMoveToGpr_WriteVecMoveFromGpr_WriteFHAddY_PdWriteRCR8rCL_PdWriteRCL16ri_BWWriteResGroup122_1_WriteFRndLd_WriteSHDmrcl_WriteFSqrtX_WriteCvtI2PDYLd_WriteFMAYLd_WriteVecIMulYLd_WriteFHAddYLd_WriteFRcpY_WriteFRsqrtY_BWWriteResGroup133_BWWriteResGroup123_BWWriteResGroup131_BWWriteResGroup132_WriteCMPXCHGRMW_WriteDPPS_WriteCvtPD2PSYLd_WriteCvtPD2IYLd_JWriteCMPXCHG8B_JWriteCMPXCHG8rm_WriteCvtSD2ILd_WriteCvtSS2ILd_WriteVecIMulXLd_WriteFMAZLd_WriteFAdd64ZLd_WriteFAddZLd_WriteFCmp64YLd_WriteFCmpYLd_WriteFCmpZLd_WriteFCmp64ZLd_WriteMPSADYLd_WriteFMul64YLd_WriteFMul64ZLd_WriteFMulYLd_WriteFMulZLd_WriteFRcpYLd_WriteFRcpZLd_WriteFRsqrtYLd_SKXWriteResGroup171_SKXWriteResGroup162_SKXWriteResGroup160_SKXWriteResGroup169_SKXWriteResGroup170_SKXWriteResGroup166_SKXWriteResGroup148_2_SKXWriteResGroup161_SKXWriteResGroup164_SKXWriteResGroup167_WriteFHAddLd_WritePCmpEStrM_WritePMULLDLd_WritePSADBWXLd_WriteCvtPD2PSZLd_WriteCvtPD2IZLd_WriteVecShiftYLd_WriteVecShiftZLd_SBWriteResGroup108_SBWriteResGroup104_SBWriteResGroup106_WriteCLMul_WriteVecTestYLd_WriteFRsqrtZ_HWWriteResGroup131_HWWriteFRNDINT_HWWriteResGroup91_2_HWWriteResGroup75_HWWriteResGroup129_HWWriteResGroup130_WriteAESDecEncLd_WriteAESIMCLd_WriteAESKeyGenLd_WriteCvtPD2PSLd_ICXWriteResGroup171_ICXWriteResGroup162_ICXWriteResGroup160_ICXWriteResGroup169_ICXWriteResGroup170_ICXWriteResGroup166_ICXWriteResGroup148_2_ICXWriteResGroup161_ICXWriteResGroup164_ICXWriteResGroup167_WriteCvtPD2ILd_WriteCvtI2PSYLd_WriteCvtPS2IYLd_WriteCvtPS2PDYLd_SKLWriteResGroup156_SKLWriteResGroup149_SKLWriteResGroup146_SKLWriteResGroup154_SKLWriteResGroup155_ZnWriteCVTPD2PSLd_ZnWriteCVTSS2SDLd_ZnWriteFPU3_WriteVecIMulLd_ZnWriteCVTPD2PSYLd_WriteFRndYLd_WritePMULLDYLd_ZnWriteFILD_ZnWriteSHA256RNDS2Ld_Zn2WriteFPU3_Zn2WriteFILD_Zn2WriteCVSTSI2SILd_Zn2WriteSHA256RNDS2Ld_WriteFComXLd_WriteDiv16_WriteFLDC_WriteIDiv16_WriteFLD1_WriteCLMulLd_WriteCvtPH2PSYLd_Zn3WriteVPERMPSYrm_WriteCvtI2PDZLd_WriteCvtPS2IZLd_WriteCvtPH2PSZLd_WritePSADBWZLd_WriteFDivZ_WriteDPPSY_Zn4WriteVPERMPSYrm
  {10,  0}, // #9 WriteFAdd64XLd_WriteFAddXLd_WriteFAdd64Ld_WriteFAddLd_WriteEMMS_WriteIMul16Ld_WriteCLMulLd_WritePMULLD_WritePSADBWXLd_WriteFVarBlendYLd_WriteVarBlendYLd_WritePHAddYLd_WritePMULLDY_ADLPWriteResGroup9_ADLPWriteResGroup169_ADLPWriteResGroup266_ADLPWriteResGroup15_WriteFComXLd_WriteCvtSD2SS_AtomWrite01_10_WriteFMul64XLd_WriteFRcpXLd_WriteFRsqrtXLd_AtomWrite0_1_10_WriteAESIMCLd_WriteAESKeyGenLd_WriteIMul64Ld_WriteIMul64RegLd_WriteIMul64ImmLd_WritePHAddLd_WriteMMXMOVMSK_WriteFMulXLd_WriteFMul64Ld_WriteFMulLd_WritePCmpEStrM_WritePMULLDLd_WriteFRcpLd_WriteFRsqrtLd_WriteFMALd_WriteFAdd64YLd_WriteFAddYLd_WriteFMAXLd_WriteFMAYLd_WriteFMul64YLd_WriteFMulYLd_WriteFRcpYLd_WriteFRsqrtYLd_PdWriteCRC32r64r64_PdWriteRCL16rCL_PdWriteRCR16ri_PdWriteVFRCZP_PdWriteVFRCZS_PdWriteVFRCZY_WriteVecIMulXLd_WriteFHAddLd_WriteVecIMulLd_WritePSADBWLd_WritePHMINPOSLd_WriteVecTestYLd_BWWriteResGroup115_BWWriteResGroup117_WriteAESDecEncLd_WriteFCmp64XLd_WriteFCmpXLd_WriteCvtSD2SSLd_WriteMPSADLd_WritePCmpIStrI_WritePCmpIStrM_WriteShuffle256Ld_WriteFShuffle256Ld_WriteVarShuffle256Ld_WriteCvtPH2PSYLd_WriteCvtPH2PSZLd_WritePSADBWYLd_WritePSADBWZLd_WriteFVarShuffle256Ld_WriteVPMOV256Ld_WritePMULLDZ_SKXWriteResGroup148_SKXWriteResGroup157_SKXWriteResGroup154_SKXWriteResGroup136_2_SKXWriteResGroup149_SKXWriteResGroup151_WriteCvtI2PDLd_WriteCvtPD2ILd_WriteCvtPD2PSLd_WriteCvtSD2ILd_WriteCvtI2SSLd_WriteCvtSS2ILd_WritePCmpEStrILd_WriteSHDmrcl_WriteFMAZLd_WriteFAdd64ZLd_WriteFAddZLd_WriteFCmp64YLd_WriteFCmpYLd_WriteFCmpZLd_WriteCvtI2PDYLd_WriteCvtI2PDZLd_WriteCvtI2PSYLd_WriteCvtI2PSZLd_WriteCvtPS2IYLd_WriteCvtPS2IZLd_WriteFRndYLd_WriteFRndZLd_WriteFCmp64ZLd_SBWriteResGroup101_WriteSHDmri_WriteCvtPD2PSZLd_WriteCvtPS2PDYLd_WriteCvtPS2PDZLd_WriteVarVecShiftYLd_WriteVarVecShiftZLd_HWWriteResGroup52_1_WriteCMPXCHGRMW_WriteBSF_WriteBSR_WriteLDMXCSR_ICXWriteResGroup148_ICXWriteResGroup157_ICXWriteResGroup154_ICXWriteResGroup136_2_ICXWriteResGroup149_ICXWriteResGroup151_WriteCvtI2PSLd_WriteCvtPS2ILd_WriteCvtI2SDLd_WriteCvtSS2SDLd_SKLWriteResGroup133_SKLWriteResGroup143_SKLWriteResGroup138_SKLWriteResGroup140_WriteCRC32Ld_ZnWriteCVTPS2PDLd_WriteFDivX_WriteFComLd_WritePHAddXLd_WriteFDivY_WriteVarVecShiftLd_Zn2WriteCVTPD2PSLd_Zn2WriteCVTPS2PDLd_Zn2WriteCVTSS2SDLd_WriteVecTestLd_WriteFRndLd_Zn2WriteCVTPD2PSYLd_WriteFVarShuffleYLd_WriteFVarShuffleLd_WriteFTestYLd_WriteFTestLd_Zn2WriteCVTPD2DQLd_WriteCvtPS2PDLd_WriteDiv8_WriteIDiv8_WriteCvtPH2PSLd_WriteVecIMulYLd_WritePMULLDYLd_Zn3WriteVZEROALL_Zn3WriteVPERMPDYmi_WriteCvtPD2IYLd_WriteCvtPD2IZLd_WriteVecIMulZLd_WriteFMul64ZLd_WriteFMulZLd_WriteFVarShuffleZLd_WritePMULLDZLd_Zn4WriteVZEROALL_Zn4WriteVPERMPDYmi
  { 5,  0}, // #10 WriteAESDecEnc_WriteLoad_WriteCvtI2PD_WriteCvtPD2I_WriteCvtPD2PS_WriteCvtPS2PD_WriteCvtSD2SS_WriteCvtSS2SD_WriteVecIMulX_WriteIMul16_WriteSHDrrcl_WriteVecIMulY_WriteFHAddY_WriteFTestY_ADLPWriteResGroup180_ADLPWriteResGroup181_ADLPWriteResGroup102_ADLPWriteResGroup242_ADLPWriteResGroup288_ADLPWriteResGroup182_ADLPWriteResGroup230_ADLPWriteResGroup29_ADLPWriteResGroup70_ADLPWriteResGroup126_ADLPWriteResGroup132_ADLPWriteResGroup254_ADLPWriteResGroup258_WriteFAddXLd_WriteFAdd64Ld_WriteFAddLd_WriteFCmp64Ld_WriteFCmpLd_WriteFCom_WriteFComLd_WriteEMMS_WriteVecIMulXLd_WriteIMul32RegLd_WriteIMul32ImmLd_WriteLDMXCSR_WriteFMulXLd_WriteFMul64Ld_WritePSADBWXLd_WriteVarShuffleXLd_WriteFRndLd_AtomWrite1_5_AtomWrite0_1_5_AtomWrite01_5_WriteJumpLd_WriteFLoadX_WriteFLoadY_WriteADCLd_WriteALULd_WriteFAdd64X_WriteAESIMC_WriteAESKeyGen_WriteBitTestImmLd_WriteBitTestRegLd_WriteBZHILd_WriteCMOVLd_WriteIMul16Imm_WriteVecLoadX_WritePHAdd_WriteVecLoadNT_WriteFMul64X_WritePMULLD_WriteFRcpX_WriteShiftLd_WriteFRsqrtX_WriteFAdd64Y_WriteFAddY_WriteFMAX_WriteFMAY_WriteVecLoadY_WriteVecLoadNTY_WriteFMul64Y_WriteFMulY_WriteFRcpY_WriteFRsqrtY_PdWriteX87Add_PdWriteX87Mul_PdWriteCRC32r32r16_PdWriteCMOVm_WriteCMPXCHG_WriteCLMul_WritePHMINPOS_WriteCvtPS2PHSt_WritePSADBWY_WriteFMaskedStore64Y_WriteFMaskedStore32Y_WriteVecMaskedStore32Y_WriteVecMaskedStore64Y_BWWriteResGroup50_BWWriteResGroup54_BWWriteResGroup36_BWWriteResGroup57_BWWriteResGroup49_BWWriteResGroup47_BWWriteResGroup51_BWWriteResGroup55_BWWritePCMPGTQ_WriteBLSLd_WriteBSR_WriteTZCNTLd_WriteCvtPH2PS_WriteVecIMulZ_SKXWriteResGroup61_SKXWriteResGroup44b_SKXWriteResGroup69_SKXWriteResGroup63_SKXWriteResGroup67_SKXWriteResGroup62_SKXWriteResGroup65_SKXWriteResGroup66_WriteCvtSD2I_WriteCvtI2SS_WriteCvtSS2I_WriteVecExtractSt_WriteSTMXCSR_WritePSADBWZ_WriteFMAZ_WriteFMul64Z_WriteFMulZ_WritePMULLDY_WritePMULLDZ_SBWriteResGroup33_SBWriteResGroup41_SBWriteResGroup47_SBWriteResGroup76_SBWriteResGroup35_SBWriteResGroup35_2_SBWriteResGroup36_SBWriteResGroup40_SBWriteResGroup45_SBWriteResGroup46_SBWritePCMPGTQ_HWWriteResGroup93_HWWriteResGroup99_HWWriteResGroup60_HWWriteResGroup88_HWWriteResGroup89_HWWriteResGroup94_HWWriteResGroup100_HWWritePCMPGTQ_WriteRMW_WriteCvtI2PS_WriteCvtPS2I_WriteCvtI2SD_WriteIMul64Reg_WriteIMul64Imm_WriteIMul8_WriteVecShiftLd_WriteVecShiftXLd_SLMWriteResGroup2rr_ICXWriteResGroup61_ICXWriteResGroup44b_ICXWriteResGroup69_ICXWriteResGroup63_ICXWriteResGroup67_ICXWriteResGroup62_ICXWriteResGroup65_ICXWriteResGroup66_SKLWriteResGroup60_SKLWriteResGroup42b_SKLWriteResGroup65_SKLWriteResGroup61_SKLWriteResGroup63_WriteBEXTRLd_WriteStore_WritePOPCNTLd_WriteCvtI2PDY_WriteCvtI2PSY_ZnWriteCVTPD2PSYr_WriteCvtPD2IY_WriteCvtPS2IY_ZnWriteCVTPD2DQr_ZnWriteSTr_ZnWriteXCHGrm_ZnWriteST_FP80m_ZnWriteEXTRACTPSm_ZnWriteMOVBE_ZnWritePop16r_ZnWriteCVTDQ2PDr_ZnWriteCVSTSI2SDr_ZnWriteCVSTSI2SIr_WriteLZCNTLd_Zn2WriteSTr_Zn2WriteXCHGrm_Zn2WriteST_FP80m_Zn2WriteEXTRACTPSm_Zn2WriteMOVBE_Zn2WritePop16r_WriteVarShuffle256_Zn3WriteMOVSlow_Zn3WriteX87Arith_Zn3WriteX87Div_Zn3Writerm_SHA1MSG2rm_SHA1NEXTErm_Zn3WriteRotateM1_WriteBSFLd_WriteBSRLd_WriteFRcpZ_WriteFRsqrtZ_Zn4WriteMOVSlow_Zn4WriteX87Arith_Zn4WriteX87Div_Zn4Writerm_SHA1MSG2rm_SHA1NEXTErm_Zn4WriteRotateM1_Zn4WriteVPERMDYrr_Zn4MOVSrr_Zn4VPTESTZ_Zn4VRSQRT14PDZ256_Zn4PERMIT2Z
  {15,  0}, // #11 WriteAESIMCLd_WriteDiv32_WriteIDiv32_WriteFRndLd_WriteCvtPD2PSYLd_WriteCvtPD2IYLd_ADLPWriteResGroup44_WriteCMPXCHG_WriteSTMXCSR_WriteDiv16_WriteDPPD_WriteIDiv16_WritePCmpEStrMLd_PdWriteVFRCZm_PdWriteVFRCZYm_WritePMULLDLd_BWWriteResGroup149_BWWriteResGroup147_WriteDiv8Ld_WriteIDiv8Ld_WriteDPPDLd_WriteFRndYLd_WriteFRndZLd_SKXWriteResGroup195_SKXWriteResGroup191_SKXWriteResGroup174_SKXWriteResGroup174z_SKXWriteResGroup194_SBWriteResGroup119_HWWriteResGroup115_HWWriteFXTRACT_HWWriteResGroup188_WriteDPPS_ICXWriteResGroup195_ICXWriteResGroup191_ICXWriteResGroup174_ICXWriteResGroup174z_ICXWriteResGroup194_SKLWriteResGroup174_SKLWriteResGroup171_WriteFDiv64Y_WriteDiv16Ld_WriteIDiv16Ld_WriteFSqrtX_WriteDPPSY_WriteFSqrtY_WriteFSqrtZ
  { 2,  0}, // #12 WriteBLS_WriteBSWAP64_WriteXCHG_WriteFence_WritePHAddX_WriteVecShiftX_WriteRotate_WriteRotateCL_WriteShiftCL_WriteSETCC_WritePHAddY_ADLPWriteResGroup243_ADLPWriteResGroup268_ADLPWriteResGroup84_ADLPWriteResGroup62_ADLPWriteResGroup105_ADLPWriteResGroup55_ADLPWriteResGroup39_ADLPWriteResGroup14_ADLPWriteResGroup219_ADLPWriteResGroup93_ADLPWriteResGroup222_ADLPWriteResGroup178_ADLPWriteResGroup11_ADLPWriteResGroup25_WriteSHDrri_AtomWrite01_2_WriteLAHFSAHF_WriteStore_WriteSETCCStore_WriteSHDrrcl_WriteVecALU_WriteFLogic_WriteBEXTR_WriteFBlend_WriteFVarBlend_WriteBitTestSet_WriteFCmp64X_WriteFCmpX_WriteCRC32_WriteVecALUX_WriteEMMS_WriteFShuffle_WriteVecLogicX_WriteShuffle_WriteLZCNT_WriteVecStore_WriteVecStoreNT_WriteVecMove_WriteVecInsert_WriteVecShiftImm_WriteFStore_WriteShuffleX_WriteVarBlend_WriteBlend_WriteVecShiftImmX_WriteTZCNT_WriteShuffleY_WriteFLogicY_WriteFVarBlendY_WriteFBlendY_WriteFShuffle256_WriteFCmp64Y_WriteFCmpY_WriteFMoveY_WriteFShuffleY_WriteVecMoveY_WriteVecStoreNTY_PdWriteLAHF_PdWriteVEXTRACTF128rr_PdWriteMOVHPm_PdWriteBMI1_PdWriteSAHF_PdWriteBEXTRI_PdWriteBEXTRIm_PdWriteVPPERM_PdWrite3OpsLEA_WriteCvtPS2PD_WriteCvtSS2SD_WriteVecExtractSt_WriteVecTest_WriteSTMXCSR_WriteCvtPH2PSY_WriteVarBlendY_BWWriteResGroup14_BWWriteResGroup20_BWWriteResGroup22_BWWriteResGroup12_BWWriteResGroup17_BWWriteResGroup35_BWWriteResGroup25_BWWriteResGroup16_BWWriteResGroup18_BWWriteResGroup24_BWWriteResGroup87_1_BWWriteCMOVA_CMOVBErr_BWWriteSETA_SETBEr_WriteFSign_WriteAESIMC_WriteAESKeyGen_WriteVecIMulX_WritePSADBW_WriteVarShuffle_WriteFMulX_WriteCLMul_WritePHMINPOS_WritePSADBWX_WriteVarShuffleX_WriteFRcpX_WriteRMW_WriteFRsqrtX_WriteCvtPS2PDY_WriteFMulY_WriteFRcpY_WriteFRsqrtY_JWriteXCHG8rr_XADDrr_JWriteINSERTQ_JWrite3OpsLEA_WriteFComX_WriteVecMoveToGpr_WriteMMXMOVMSK_WriteFMOVMSK_WriteVecMOVMSK_WriteFVarBlendZ_WriteFMaskedStore64Y_WriteFMaskedStore32Y_WriteVarBlendZ_WriteVecMaskedStore32Y_WriteVecMaskedStore64Y_WriteVecMOVMSKY_WriteFTestY_SKXWriteResGroup17_SKXWriteResGroup23_SKXWriteResGroup25_SKXWriteResGroup14_SKXWriteResGroup44_SKXWriteResGroup28_SKXWriteResGroup20_SKXWriteResGroup13_SKXWriteResGroup21_SKXWriteResGroup27_SKXWriteResGroup107_1_SKXWriteResGroup29_SKXWriteCMOVA_CMOVBErr_SKXWriteSETA_SETBEr_WriteADC_WriteCvtPS2PDZ_WriteVecTestY_SBWriteResGroup18_SBWriteResGroup11_SBWriteResGroup12_SBWriteResGroup15_SBWriteResGroup23_SBWriteSETA_SETBEr_WriteCvtPH2PSZ_HWWriteResGroup30_HWWriteResGroup35_HWWriteResGroup21_HWWriteResGroup28_HWWriteResGroup33_HWWriteResGroup59_HWWriteResGroup24_HWWriteResGroup32_HWWriteResGroup19_HWWriteResGroup23_HWWriteResGroup23_16_HWWriteResGroup46_1_HWWriteSETA_SETBEr_ICXWriteResGroup17_ICXWriteResGroup23_ICXWriteResGroup25_ICXWriteResGroup14_ICXWriteResGroup44_ICXWriteResGroup28_ICXWriteResGroup20_ICXWriteResGroup13_ICXWriteResGroup21_ICXWriteResGroup27_ICXWriteResGroup107_1_ICXWriteResGroup29_ICXWriteCMOVA_CMOVBErr_ICXWriteSETA_SETBEr_SKLWriteResGroup17_SKLWriteResGroup23_SKLWriteResGroup25_SKLWriteResGroup14_SKLWriteResGroup42_SKLWriteResGroup28_SKLWriteResGroup20_SKLWriteResGroup13_SKLWriteResGroup21_SKLWriteResGroup27_SKLWriteResGroup100_1_SKLWriteCMOVA_CMOVBErr_SKLWriteSETA_SETBEr_WriteShuffle256_WriteVarShuffle256_WriteFVarShuffle256_ZnWriteEXTRACTPSr_ZnWriteVINSERT128r_ZnWriteEXTRQ_ZnWriteSHA1MSG1r_Zn2WriteEXTRACTPSr_Zn2WriteVINSERT128r_Zn2WriteSHA1MSG1r_WriteCvtSD2I_WriteCvtSS2I_WritePCmpIStrI_Zn3WriteCvtI2PDMMX_Zn3WriteSHA256MSG1rr_Zn3SlowLEA16r_Zn3WriteTZCNT16rr_Zn3WriteWriteFStoreMMX_Zn3WriteSHA1MSG1rr_Zn3Write3OpsLEA_WriteFCmpZ_WriteFCmp64Z_Zn4WriteSHA256MSG1rr_Zn4SlowLEA16r_Zn4WriteTZCNT16rr_Zn4WriteWriteFStoreMMX_Zn4WriteVecALUXSlow_Zn4WriteSHA1MSG1rr_Zn4WriteVFIXUPIMMPDZrr_VRANGESDrr_Zn4WriteSHIFTrr_Zn4WriteALIGN_Zn4WritePACK_Zn4WriteFCmp64_Zn4MOVS_Zn4CONFLICTZ128_Zn4PERMILP_Zn4PERMIT2_128rr_Zn4VecALUZSlow_Zn4Write3OpsLEA
  {18,  0}, // #13 WriteRMW_WriteDiv64_WriteFDivXLd_WriteFDivLd_WriteIDiv64_WritePMULLDLd_WriteFSqrt64X_WritePMULLDYLd_WriteFSqrt64Y_ADLPWriteResGroup34_ADLPWriteResGroup206_ADLPWriteResGroup116_AtomWrite01_18_WriteCvtSD2ILd_WriteCvtSS2ILd_WriteDiv32Ld_WriteDiv64Ld_WriteIDiv32Ld_WriteIDiv64Ld_WritePCmpEStrI_BWWriteResGroup160_BWWriteResGroup159_BWWriteResGroup183_2_WriteFSqrtXLd_WriteFDivYLd_WriteFDivZ_SKXWriteResGroup208_SKXWriteResGroup207_SKXWriteResGroupVEX2_WriteAESIMCLd_WriteDPPSLd_WriteFRcpYLd_WriteFRcpZLd_WriteFRsqrtYLd_WriteFRsqrtZLd_HWWriteResGroup149_ICXWriteResGroup208_ICXWriteResGroup207_ICXWriteResGroupVEX2_SKLWriteResGroup185_SKLWriteResGroup184_SKLWriteResGroupVEX2_WriteFDivZLd_WriteDPPSYLd
  { 4,  0}, // #14 WriteFCmp64X_WriteFCmpX_WriteCvtI2PS_WriteCvtPS2I_WriteVecExtract_WriteIMul16Imm_WriteIMul32_WriteIMul64_WriteVecInsert_WriteMPSAD_WriteFMul64X_WriteFMulX_WriteMULX32_WriteMULX64_WritePHMINPOS_WriteVecTest_WriteFRcpX_WriteFRsqrtX_WriteFCmp64Y_WriteFCmpY_WriteCvtI2PSY_WriteCvtPS2IY_WriteFMAX_WriteFMAY_WriteMPSADY_WriteFMul64Y_WriteFMulY_WriteVecMOVMSKY_WriteVecShiftY_WriteFRcpY_WriteFRsqrtY_ADLPWriteResGroup83_ADLPWriteResGroup174_ADLPWriteResGroup60_ADLPWriteResGroup51_ADLPWriteResGroup190_ADLPWriteResGroup277_ADLPWriteResGroup121_ADLPWriteResGroup158_ADLPWriteResGroup214_WritePHAddLd_WriteVecIMulLd_WritePSADBWLd_WriteFMulLd_WriteVarShuffleX_WriteFRcpLd_WriteFRsqrtLd_WriteSHDmrcl_WriteSHDmri_AtomWrite01_4_WriteBSR_WriteCvtSD2SS_WriteCvtI2SD_WriteCvtI2SS_WriteCvtSS2SD_WriteVecIMulX_WriteIMul16Reg_WriteIMul32Reg_WriteIMul32Imm_WriteIMul8_WritePOPCNT_WritePSADBWX_WriteFRnd_WriteCvtPS2PHYSt_WriteCvtPS2PHSt_WriteFRndY_PdWriteMMX_CVTPI2PSrr_PdWriteMOVQ2DQrr_PdWriteVPERM2F128rr_PdWriteVPMACS_WriteCvtI2PD_WriteCvtPD2I_WriteCvtPD2PS_WriteCvtSD2I_WriteCvtSS2I_WriteCvtPS2PDY_WriteVecTestY_BWWriteResGroup42_BWWriteResGroup44_BWWriteResGroup45_BWWriteResGroup41_BWWriteResGroup43_WriteJumpLd_WriteADCLd_WriteALULd_WriteBEXTRLd_WriteBSF_WriteBitTestImmLd_WriteBitTestRegLd_WriteCMOVLd_WriteFHAdd_WriteLZCNTLd_WriteVecMoveToGpr_WriteVecInsertLd_WritePMULLD_WriteStore_WritePOPCNTLd_WriteShiftLd_WriteSHDrrcl_WriteFHAddY_WriteFVarShuffleY_WriteFTestY_WriteFAdd64X_WriteFAddX_WriteAESDecEnc_WriteFAdd64Y_WriteFAdd64Z_WriteFAddY_WriteFAddZ_WriteFCmpZ_WriteCvtI2PDY_WriteCvtI2PDZ_WriteCvtI2PSZ_WriteFMAZ_WriteFCmp64Z_WriteFMul64Z_WriteFMulZ_WriteVecShiftZ_WriteFRcpZ_SKXWriteResGroup54_SKXWriteResGroup55_SKXWriteResGroup57_SKXWriteResGroup49_SKXWriteResGroup50_SKXWriteResGroup33_SKXWriteResGroup50z_SKXWriteResGroup51_WritePCmpEStrI_WriteCvtPD2PSY_WriteCvtPD2PSZ_WriteCvtPD2IY_WriteCvtPD2IZ_WriteCvtPS2PHZSt_SBWriteResGroup31_SBWriteResGroup29_2_SBWriteResGroup24b_WriteCvtPS2PDZ_HWWriteResGroup73_HWWriteMOVS_HWWriteResGroup62_HWWriteResGroup81_HWWriteResGroup72_HWWriteResGroup61_HWWriteCMPS_HWWriteResGroup83_WriteFLogicLd_WriteFBlendLd_WriteFVarBlend_WriteRMW_WriteVecExtractSt_WriteVecALUXLd_WriteFShuffleLd_WriteVecALULd_WriteShuffleLd_WriteVecLogicLd_WriteMMXMOVMSK_WriteVarShuffleLd_WriteFMOVMSK_WriteShuffleXLd_WriteVecLogicXLd_WriteVarBlend_WriteBlendLd_WriteVecTestLd_WriteFVarShuffleLd_WriteVecShiftImmXLd_WriteFTestLd_SLMWriteResGroup1rr_ICXWriteResGroup54_ICXWriteResGroup55_ICXWriteResGroup57_ICXWriteResGroup49_ICXWriteResGroup50_ICXWriteResGroup33_ICXWriteResGroup50z_ICXWriteResGroup51_SKLWriteResGroup53_SKLWriteResGroup55_SKLWriteResGroup54_SKLWriteResGroup57_SKLWriteResGroup47_WriteAESIMC_WriteAESKeyGen_WriteLoad_ZnWriteCVTPD2PSr_ZnWriteCVTSS2SDr_ZnWriteMul64_WriteVecIMulY_WriteFMaskedStore64_WriteFMaskedStore32_WriteVecMaskedStore32_WriteVecMaskedStore64_WritePMULLDY_ZnWriteCVTPS2PIr_ZnWritePUSH_ZnWriteINSERTQ_ZnWriteSHA256RNDS2r_Zn2WriteMul16Imm_Zn2WriteMul64_WriteVPMOV256_Zn2WriteCVTPS2PIr_Zn2WritePUSH_Zn2WriteCVSTSI2SIr_Zn2WriteINSERTQ_Zn2WriteSHA256RNDS2r_WriteFComX_WriteCLMul_WriteCvtPH2PSY_Zn3WriteCMPXCHG16B_LCMPXCHG16B_Zn3WriteRotateLeftRI_Zn3WriteRotateLeftRCL_Zn3WriteVEXTRACTF128rr_VEXTRACTI128rr_Zn3WriteSHA256RNDS2rr_Zn3WriteMOVBE16rm_WriteCvtPS2IZ_WriteCvtPH2PSZ_WritePSADBWZ_Zn4WriteCMPXCHG16B_LCMPXCHG16B_Zn4WriteRotateLeftRI_Zn4WriteRotateLeftRCL_Zn4WriteVEXTRACTF128rr_VEXTRACTI128rr_Zn4WriteSHA256RNDS2rr_Zn4WriteMOVBE16rm_Zn4WriteVecALU2Slow_Zn4WriteBUSDr_VPMADDr_Zn4MOVSZ_Zn4VPTESTZ256_Zn4PERMIT2_256
  {20,  0}, // #15 WriteDiv16Ld_WriteFDiv64XLd_WriteIDiv16Ld_WriteFSqrtYLd_ADLPWriteResGroup159_ADLPWriteResGroup81_ADLPWriteResGroup48_ADLPWriteResGroup45_ADLPWriteResGroup79_ADLPWriteResGroup80_AtomWrite01_20_WriteDPPDLd_WriteDPPSYLd_BWWriteResGroup167_BWWriteResGroup165_WriteAESKeyGen_WriteFSqrtZ_SKXWriteResGroup220_SKXWriteResGroup219_SKXWriteResGroup215_SKXWriteResGroupVEX4_WriteFDivXLd_WriteFDivLd_WriteCLMulLd_WriteFSqrtXLd_WriteFSqrtLd_WriteAESIMCLd_WriteDPPSLd_HWWriteResGroup156_HWWriteResGroup154_WritePCmpEStrMLd_WritePCmpIStrILd_ICXWriteResGroup220_ICXWriteResGroup219_ICXWriteResGroup215_ICXWriteResGroupVEX4_SKLWriteResGroup193_SKLWriteResGroup192_SKLWriteResGroup189_SKLWriteResGroupVEX4_WriteFDiv64Ld_WriteFSqrt64X_WriteFSqrt80_WriteFSqrt64Y_WriteFDiv64YLd_WriteFDiv64ZLd
  {16,  0}, // #16 WriteDiv16_WriteDPPDLd_WriteIDiv16_WritePCmpEStrI_WritePCmpEStrM_WritePCmpIStrMLd_WriteFRndYLd_ADLPWriteResGroup267_WriteBSFLd_WriteBSRLd_WriteDiv8Ld_WriteFHAddLd_WriteIDiv8Ld_WritePCmpIStrILd_WriteFHAddYLd_WriteFDivXLd_BWWriteResGroup150_WriteFSqrt64X_WriteFSqrtXLd_WriteFSqrtLd_WritePMULLDYLd_BWWriteResGroup153_WriteDPPSLd_WriteFMaskedStore64Y_WriteFMaskedStore32_JWriteLOCK_CMPXCHG8rm_WriteFDivLd_WritePMULLDLd_WriteFRsqrtZLd_SKXWriteResGroup199_HWWriteResGroup120_HWWriteResGroup186_HWWriteResGroup190_ICXWriteResGroup199_SKLWriteResGroup177_SKLWriteResGroup178
  {19,  0}, // #17 WriteDiv32Ld_WriteFDiv64Ld_WriteVecExtractSt_WriteIDiv32Ld_WriteFSqrtXLd_WriteFSqrtLd_WriteFDivYLd_WriteDiv16Ld_WriteIDiv16Ld_WritePCmpEStrILd_WriteAESIMCLd_WriteFDiv64XLd_BWWriteResGroup161_WriteDPPSLd_WritePCmpEStrM_BWWriteResGroup183_4_BWWriteResGroup183_3_WriteFDivX_WritePCmpEStrMLd_JWriteLOCK_CMPXCHG8B_JWriteLOCK_ALURMW_WriteFSqrtYLd_SKXWriteGatherEVEX4_WriteDPPSYLd_WriteFDivXLd_HWWriteResGroup135_HWWriteResGroup143_HWWriteFPREM_ICXWriteGatherEVEX4_WriteDiv8Ld_WriteIDiv8Ld
  {23,  0}, // #18 WriteDiv64Ld_WriteIDiv64Ld_WriteFSqrt64Ld_AtomWrite01_23_WritePCmpEStrILd_WriteFSqrt80_WriteFDiv64Y_WriteFDivYLd_BWWriteResGroup176_WriteFDiv64Z_SKXWriteResGroup228_WriteIDiv8_HWWriteResGroup151_WriteFSqrtLd_ICXWriteResGroup228_SKLWriteResGroup198
  {22,  0}, // #19 WriteDiv8Ld_WriteIDiv8Ld_WriteDPPSYLd_ADLPWriteResGroup46_AtomWrite01_22_BWWriteResGroup172_WriteFMaskedStore32Y_SKXWriteResGroup223_SKXWriteResGroupVEX8_SKXWriteResGroup225_SKXWriteResGroup211_SKXWriteResGroup211_1_WriteFDiv64X_WriteFSqrt64XLd_HWWriteResGroup146_HWWriteResGroup187_WriteFDivLd_ICXWriteResGroup223_ICXWriteResGroupVEX8_ICXWriteResGroup225_ICXWriteResGroup211_ICXWriteResGroup211_1_SKLWriteResGroup196_SKLWriteResGroupVEX8_WriteFDiv64YLd_WriteDPPSLd_WriteFSqrtXLd_WriteFSqrtLd_WriteFSqrt80_WriteFSqrtYLd_WriteFSqrtZLd
  {17,  0}, // #20 WriteDiv8_WriteIDiv8_WritePCmpEStrMLd_WriteStore_ADLPWriteResGroup276_ADLPWriteResGroup17_AtomWrite01_17_WriteCLMulLd_WriteFDivY_WriteFRcpYLd_WriteFRsqrtYLd_BWWriteResGroup183_1_WriteDiv16_WriteIDiv16_WriteDPPSYLd_JWriteLOCK_CMPXCHGrm_WriteFDivXLd_WriteFSqrtLd_WritePMULLDYLd_WritePMULLDZLd_SKXWriteResGroup202_SKXWriteGatherEVEX2_WritePCmpIStrILd_WritePCmpIStrMLd_WriteFSqrtXLd_HWWriteResGroup147_HWWriteResGroup132_HWWriteResGroup185_HWWriteResGroup189_ICXWriteResGroup202_ICXWriteGatherEVEX2_SKLWriteResGroup180_WriteFDivLd_WriteFDivYLd_WriteDiv32Ld_WriteDiv64_WriteIDiv32Ld_WriteIDiv64
  {14,  0}, // #21 WriteFDiv64X_WriteDPPS_WriteFDiv64Y_WriteDPPSY_WriteFMaskedStore64Y_WriteFMaskedStore32Y_WriteVecMaskedStore32Y_WriteVecMaskedStore64Y_ADLPWriteResGroup157_WriteIMul64ImmLd_AtomWrite01_14_WriteAESDecEncLd_WriteDiv32_WriteDiv64_WriteFDiv64XLd_WriteFDivXLd_WriteFDivLd_WriteFDiv64Ld_WriteIDiv32_WriteIDiv64_WriteMPSADLd_WritePCmpEStrI_WriteFSqrt64XLd_WriteFSqrtXLd_WriteFSqrt64Ld_WriteFSqrtLd_WriteFDiv64YLd_WriteFDivYLd_WriteFSqrt64YLd_WriteFSqrtYLd_WriteAESIMC_BWWriteResGroup139_1_WriteDPPDLd_BWWriteResGroup146_BWWriteResGroup145_BWWriteResGroup141_BWWriteResGroup144_WritePCmpEStrM_WriteAESIMCLd_WriteFRndLd_WriteCvtPD2PSYLd_WriteCvtPD2PSZLd_SKXWriteResGroup190_SKXWriteResGroup187_SKXWriteResGroup188_SKXWriteResGroup189_WriteAESKeyGenLd_WriteCLMul_WriteMPSADYLd_WriteFRcpYLd_WriteFRcpZLd_WriteFRsqrtYLd_WriteFRsqrtZLd_HWWriteResGroup142_HWWriteResGroup184_WritePMULLDLd_ICXWriteResGroup190_ICXWriteResGroup187_ICXWriteResGroup188_ICXWriteResGroup189_SKLWriteResGroup170_SKLWriteResGroup169_WriteFHAddLd_WriteFHAddYLd_WriteDiv8Ld_WriteIDiv8Ld_WriteFVarShuffle256Ld
  { 9,  0}, // #22 WriteDPPD_WriteIMul16ImmLd_WriteIMul32Ld_WriteIMul64Ld_WriteVecALULd_WriteShuffleLd_WriteVecLogicLd_WriteVecShiftLd_WriteMULX32Ld_WriteMULX64Ld_WritePHAddXLd_WriteVecTestLd_WriteShuffleYLd_WriteFLogicYLd_WriteFBlendYLd_WriteVecALUYLd_WriteFMaskedLoadY_WriteFShuffleYLd_WriteVecLogicYLd_WriteBlendYLd_WriteFVarShuffleYLd_WriteVecMaskedLoadY_WriteVarVecShiftYLd_WriteVarShuffleYLd_WriteVecShiftYLd_ADLPWriteResGroup114_ADLPWriteResGroup122_ADLPWriteResGroup197_ADLPWriteResGroup255_ADLPWriteResGroup125_ADLPWriteResGroup221_ADLPWriteResGroup177_ADLPWriteResGroup244_ADLPWriteResGroup264_WriteBitTestRegLd_WriteFCMOV_WriteFComX_WriteCvtSD2ILd_WriteCvtSS2ILd_WriteFHAddLd_WriteFMul64X_WriteFRcpX_WriteFRsqrtX_AtomWrite0_1_9_AtomWrite01_9_WriteAESDecEnc_WriteCvtI2PSLd_WriteCvtPS2ILd_WriteCvtSD2SSLd_WriteCvtI2SDLd_WriteCvtI2SSLd_WriteCvtSS2SDLd_WriteFDiv64X_WriteFDivX_WriteVecIMulXLd_WriteVecIMulLd_WritePSADBWLd_WritePHMINPOSLd_WritePSADBWXLd_WriteFRndLd_WriteFSqrt64X_WriteFSqrtX_WriteCvtI2PSYLd_WriteCvtPS2IYLd_WriteFDiv64Y_WriteFDivY_WriteFRndYLd_WriteFSqrt64Y_WriteFSqrtY_PdWriteX87Div_PdWriteRCR16rCL_WriteCvtI2PDLd_WriteCvtPD2ILd_WriteCvtPD2PSLd_WriteIMul16Ld_WriteSHDmri_WriteFAdd64YLd_WriteFAddYLd_WriteShuffle256Ld_WriteFShuffle256Ld_WriteFCmp64YLd_WriteFCmpYLd_WriteVarShuffle256Ld_WriteCvtPS2PDYLd_WriteFMul64YLd_WriteFMulYLd_WriteFVarShuffle256Ld_WritePHAddYLd_WriteVPMOV256Ld_BWWriteResGroup101_BWWriteResGroup112_BWWriteResGroup108_BWWriteResGroup113_WriteIMul64RegLd_WriteIMul64ImmLd_WriteFMul64XLd_WriteFMul64Ld_WritePMULLDLd_WriteSHDmrcl_WriteFHAddYLd_WriteVecTestYLd_WriteFTestYLd_WriteFAdd64Ld_WriteFAddLd_WriteFCmp64Ld_WriteFCmpLd_WriteFMulLd_WriteFRcpLd_WriteFRsqrtLd_WriteFMALd_WriteFVarBlendYLd_WriteFVarBlendZLd_WriteCvtI2PDYLd_WriteCvtI2PDZLd_WriteCvtI2PSZLd_WriteCvtPH2PSLd_WriteFRsqrtZ_SKXWriteResGroup135_SKXWriteResGroup137_SKXWriteResGroup136_SKXWriteResGroup146_SKXWriteResGroup143_SBWriteResGroup98_WriteFAdd64XLd_WriteFAddXLd_SBWriteResGroup100_WriteRMW_WriteFCmp64XLd_WriteFCmpXLd_WritePOPCNTLd_WriteVarBlendYLd_WriteVarBlendZLd_SBWriteResGroup97_2_SBWriteResGroup95_SBWriteResGroup99_SBWriteResGroupVzeroall_WriteCMPXCHGRMW_HWWriteResGroup69_WriteVarVecShiftLd_HWWriteResGroup66_HWWriteResGroup68_HWWriteResGroup53_1_HWWriteResGroup78_1_HWWriteResGroup80_HWWriteResGroup87_WritePHAddLd_ICXWriteResGroup135_ICXWriteResGroup137_ICXWriteResGroup136_ICXWriteResGroup146_ICXWriteResGroup143_WriteCvtPS2PDLd_SKLWriteResGroup120_SKLWriteResGroup123_SKLWriteResGroup121_SKLWriteResGroup131_SKLWriteResGroup128_ZnWriteMul64Ld_WriteFTestLd_ZnWriteFPU02_ZnWriteVINSERT128Ld_ZnWriteFPU01Op2Y_ZnWriteSHA1MSG1Ld_Zn2WriteFPU02_Zn2WriteVINSERT128Ld_Zn2WriteFPU01Op2Y_Zn2WriteSHA1MSG1Ld_WritePCmpIStrILd_Zn3WriteVPERMDYm_WriteVecShiftXLd_WriteFCmpZLd_WriteFCmp64ZLd_Zn4WriteVPERMYm
  {21,  0}, // #23 WriteDPPSLd_WriteFSqrt80_WriteFDiv64YLd_ADLPWriteResGroup220_AtomWrite01_21_WriteFSqrt64XLd_WriteFSqrt64Ld_WriteFSqrtY_BWWriteResGroup171_BWWriteResGroup169_BWWriteResGroup183_5_WriteFSqrtX_SKXWriteResGroup205_SKXWriteGatherEVEX8_WriteFDivY_WriteFDivZ_WriteDPPSYLd_WriteFSqrtZ_HWWriteResGroup144_WritePCmpEStrI_ICXWriteResGroup205_ICXWriteGatherEVEX8_WriteDiv16Ld_WriteIDiv16Ld_WriteFSqrtXLd_WriteFSqrtLd_WriteFSqrtYLd_WriteDiv64Ld_WriteIDiv64Ld_WriteFSqrt64Y_WriteFSqrt64Z
  {13,  0}, // #24 WriteVecIMulXLd_WriteVecIMulLd_WriteSETCCStore_WriteVecIMulYLd_WriteFHAddYLd_ADLPWriteResGroup113_ADLPWriteResGroup33_ADLPWriteResGroup10_ADLPWriteResGroup231_ADLPWriteResGroup223_ADLPWriteResGroup227_ADLPWriteResGroup4_ADLPWriteResGroup7_ADLPWriteResGroup138_ADLPWriteResGroup233_ADLPWriteResGroup265_AtomWrite01_13_WriteCvtI2PDLd_WriteCvtPD2ILd_WriteCvtPD2PSLd_WriteCvtPS2PDLd_WriteCvtSD2I_WriteCvtSS2I_WriteVecExtractSt_WriteCvtI2PDYLd_WriteCvtPD2PSYLd_WriteCvtPD2IYLd_WriteCvtPS2PDYLd_WriteCvtPH2PSYLd_WriteCvtPH2PSLd_PdWriteCVTSI642SDrr_CVTSI642SSrr_CVTSI2SDr_CVTSI2SSrr_PdWriteRCL8ri_WriteMPSADYLd_WritePCmpIStrMLd_WriteFMaskedStore64_WriteDPPS_WriteDPPSY_SKXWriteResGroup180_SKXWriteResGroup181_SKXWriteResGroup183_WriteAESDecEncLd_WriteMPSADLd_SBWriteResGroup114_WriteFDivX_WriteFRndYLd_WriteFRndZLd_HWWriteResGroup103_WriteBSFLd_WriteBSRLd_WriteCLMulLd_ICXWriteResGroup180_ICXWriteResGroup181_ICXWriteResGroup183_SKLWriteResGroup162_WriteFDiv64X_ZnWriteSHA1RNDS4Ld_WriteFDiv64Y_Zn2WriteSHA1RNDS4Ld_WriteDiv32_WriteFHAddLd_WriteIDiv32_WritePCmpEStrILd_WritePCmpEStrMLd_WriteCvtPD2PSZLd_WriteCvtPS2PDZLd_WriteFDiv64Z
  {511,  0}, // #25 WriteVecStoreNT_ADLPWriteResGroup145
  {512,  0}, // #26 WriteStoreNT_ADLPWriteResGroup148
  {518,  0}, // #27 WriteFStoreNTX_ADLPWriteResGroup149
  { 3,  0}, // #28 WriteIMulHLd
  { 9,  0}, // #29 WriteMULX32Ld_WriteMULX64Ld
  { 3,  0}, // #30 WriteIMulH
  { 4,  0}, // #31 WriteMULX32_WriteMULX64
  {31,  0}, // #32 WritePCmpEStrILd_WritePCmpIStrILd_WriteEMMS_SBWriteResGroup130_HWWriteResGroup163_HWWriteResGroup165
  {12,  0}, // #33 WriteRotateLd_WriteShiftLd_WriteShiftCLLd_ADLPWriteResGroup211_ADLPWriteResGroup271
  { 1,  0}, // #34 WriteRMW
  {19,  0}, // #35 WriteRotateCLLd
  { 1,  0}, // #36 WriteRMW
  {24,  0}, // #37 WriteFSqrt64XLd_ADLPWriteResGroup109_ADLPWriteResGroup237_WritePCmpEStrMLd_BWWriteResGroup177_WriteFDiv64XLd_WriteFDivXLd_WriteFDivLd_WriteFDiv64Ld_WritePCmpEStrILd_WriteFSqrt80_HWWriteResGroup162
  { 5,  0}, // #38 WriteLoad
  { 5,  0}, // #39 WriteVecMaskedGatherWriteback
  {507,  0}, // #40 WriteVecStoreNTY
  {542,  0}, // #41 WriteFStoreNTY
  {25,  0}, // #42 WriteFSqrt64YLd_ADLPWriteResGroup32_ADLPWriteResGroup47_AtomWrite01_25_WriteDPPS_WriteDiv8_WriteIDiv16_WriteIDiv32_WriteIDiv64_WriteIDiv8_WriteDiv32_WriteAESKeyGenLd_WritePCmpEStrMLd_WriteFDivZLd_SKXWriteResGroup233_SKXWriteGatherEVEX16_WriteDiv16_WriteDiv64_WriteFDiv64Ld_ICXWriteResGroup233_ICXWriteGatherEVEX16_SKLWriteResGroup202
  {11,  0}, // #43 WriteALULd
  { 1,  0}, // #44 WriteRMW
  {39,  0}, // #45 ADLPWriteResGroup274_ADLPWriteResGroup273_WriteFSqrt64ZLd_WriteFDivX
  { 1,  0}, // #46 WriteRMW
  {32,  0}, // #47 ADLPWriteResGroup31_AtomWrite01_32_WriteDPPSYLd_WriteFSqrt64XLd_WriteFSqrt64Ld_JWriteCMPXCHG16B_WriteFSqrt64Z
  {42,  0}, // #48 ADLPWriteResGroup207_ADLPWriteResGroup280_ADLPWriteResGroup287_ADLPWriteResGroup282_ADLPWriteResGroup283_ADLPWriteResGroup286_BWWriteResGroup196_WriteFSqrtY_SKXWriteResGroup254_SKXWriteResGroup255_WriteFDiv64YLd_WriteFDiv64ZLd_WriteFSqrt64YLd_WriteFSqrt64ZLd_HWWriteResGroup176_WriteFDivXLd_ICXWriteResGroup254_ICXWriteResGroup255_SKLWriteResGroup214_SKLWriteResGroup215
  {126,  0}, // #49 ADLPWriteResGroup49
  {75,  0}, // #50 ADLPWriteResGroup61_BWWriteResGroup200_SKXWriteResGroup263_HWWriteResGroup180_HWWriteFSCALE_ICXWriteResGroup263_SKLWriteResGroup220
  {35,  0}, // #51 ADLPWriteResGroup165_ADLPWriteResGroup164_ADLPWriteResGroup75_ADLPWriteResGroup76_ADLPWriteResGroup71_ADLPWriteResGroup72_ADLPWriteResGroup73_ADLPWriteResGroup160_ADLPWriteResGroup161_ADLPWriteResGroup162_ADLPWriteResGroup163_WriteIDiv16Ld_WriteIDiv32Ld_WriteIDiv64Ld_WriteIDiv8Ld_WriteFSqrt64YLd_BWWriteResGroup194_WriteFSqrt80_SKXWriteResGroup248_SKXWriteResGroup247_WriteFDiv64Y_WriteFDiv64Z_WriteFSqrt64Z_HWWriteResGroup170_ICXWriteResGroup248_ICXWriteResGroup247_SKLWriteResGroup210_SKLWriteResGroup209
  {63,  0}, // #52 ADLPWriteResGroup66_ADLPWriteResGroup67_ADLPWriteResGroup108_AtomWrite01_63_BWWriteResGroup199_BWWriteResGroup198_SKXWriteResGroup260_SKXWriteResGroup259_ICXWriteResGroup260_ICXWriteResGroup259_SKLWriteResGroup219_SKLWriteResGroup218
  {81,  0}, // #53 ADLPWriteResGroup248_ADLPWriteResGroup246
  {13,  0}, // #54 ADLPWriteResGroup213_ADLPWriteResGroup272_ADLPWriteResGroup193_ADLPWriteResGroup215
  { 1,  0}, // #55 WriteRMW
  {65,  0}, // #56 ADLPWriteResGroup90
  {70,  0}, // #57 ADLPWriteResGroup107_WriteFDivXLd_WriteFSqrtXLd
  {37,  0}, // #58 ADLPWriteResGroup279_SKXWriteResGroup250_SKXWriteResGroup249_WriteFDiv64Ld_ICXWriteResGroup250_ICXWriteResGroup249_SKLWriteResGroup211
  {27,  0}, // #59 ADLPWriteResGroup42_WriteDPPSY_PdWriteVDPPSrri_WriteFSqrtYLd_WriteFSqrt64X_WriteFSqrtZLd_SKXWriteResGroup239_WriteFSqrt64XLd_WriteFSqrt64Ld_HWWriteFPREM1_HWWriteResGroup155_ICXWriteResGroup239_SKLWriteResGroup206_WriteFSqrt64YLd
  {30,  0}, // #60 ADLPWriteResGroup43_AtomWrite01_30_WriteDPPSLd_BWWriteResGroup186_WriteFDiv64ZLd_SKXWriteResGroup243_WriteDiv16Ld_WriteDiv32Ld_WriteDiv64Ld_WriteDiv8Ld_WriteIDiv16Ld_WriteIDiv32Ld_WriteIDiv64Ld_WriteIDiv8Ld_HWWriteResGroup161_HWWriteResGroup164_ICXWriteResGroup243_SKLWriteResGroup208
  {41,  0}, // #61 ADLPWriteResGroup281_WriteDiv64_WriteIDiv64_SKXWriteResGroup253_HWWriteResGroup175_WriteFSqrtX_ICXWriteResGroup253_SKLWriteResGroup213
  {46,  0}, // #62 ADLPWriteResGroup285_ADLPWriteResGroup284_AtomWrite01_46_PdWriteVZEROUPPER_JWriteJVZEROUPPER_SKLWriteResGroup216
  {40,  0}, // #63 ADLPWriteResGroup257_SKXWriteResGroup252_WriteFSqrt80_ICXWriteResGroup252_SKLWriteResGroup212
  {62,  0}, // #64 ADLPWriteResGroup59_WriteFDiv64Ld_WriteIDiv16Ld_WriteIDiv32Ld_WriteIDiv8Ld_WriteFSqrt64Ld_SKXWriteResGroup258_ICXWriteResGroup258_SKLWriteResGroup217
  {106,  0}, // #65 ADLPWriteResGroup65_SKXWriteResGroup266_ICXWriteResGroup266_SKLWriteResGroup223
  {20,  0}, // #66 ADLPWriteResGroup251
  { 5,  0}, // #67 WriteVecMaskedGatherWriteback
  {29,  0}, // #68 ADLPWriteResGroup250_AtomWrite01_29_WriteAESKeyGen_WriteFDiv64YLd_WriteFSqrt64Y_BWWriteResGroup182_BWWriteResGroup185_WriteDiv16Ld_WriteDiv32Ld_WriteDiv64Ld_WriteDiv8Ld_SKXWriteResGroup242_WriteFDivY_WriteFDivZ_WriteFSqrtY_WriteFSqrtZ_WriteIDiv16Ld_WriteIDiv32Ld_WriteIDiv64Ld_WriteIDiv8Ld_ICXWriteResGroup242
  { 5,  0}, // #69 WriteVecMaskedGatherWriteback
  {28,  0}, // #70 ADLPWriteResGroup253_WriteDiv32Ld_WriteIDiv32Ld_WriteIDiv16Ld_WriteIDiv64Ld_WriteIDiv8Ld_WriteFDiv64XLd_WriteFDiv64Ld_WriteFDivYLd_WriteFDivZLd_WriteFSqrtYLd_WriteFSqrtZLd_WriteFSqrt64XLd_WriteFSqrt64Ld_WriteFSqrt64YLd_WriteFSqrt64ZLd
  { 5,  0}, // #71 WriteVecMaskedGatherWriteback
  {30,  0}, // #72 ADLPWriteResGroup252
  { 5,  0}, // #73 WriteVecMaskedGatherWriteback
  {40,  0}, // #74 ADLPWriteResGroup275
  { 1,  0}, // #75 WriteRMW
  {26,  0}, // #76 ADLPWriteResGroup35_AtomWrite01_26_BWWriteResGroup180_WriteFSqrtXLd_WriteFSqrtLd_WriteFDiv64XLd
  {198,  0}, // #77 ADLPWriteResGroup87
  {66,  0}, // #78 ADLPWriteResGroup88
  {71,  0}, // #79 ADLPWriteResGroup89_ADLPWriteResGroup91_WriteFSqrt80_AtomWrite01_71_WriteFSqrt64X
  {217,  0}, // #80 ADLPWriteResGroup133
  {181,  0}, // #81 ADLPWriteResGroup136
  {514,  0}, // #82 ADLPWriteResGroup146
  {20,  0}, // #83 ADLPWriteResGroup194_ADLPWriteResGroup196
  { 1,  0}, // #84 WriteRMW
  {1386,  0}, // #85 ADLPWriteResGroup202
  {1381,  0}, // #86 ADLPWriteResGroup204
  {74,  0}, // #87 ADLPWriteResGroup247_ADLPWriteResGroup249_AtomWrite01_74_SKXWriteResGroup262_WriteFSqrt64XLd_ICXWriteResGroup262
  {521,  0}, // #88 ADLPWriteResGroup259
  {473,  0}, // #89 ADLPWriteResGroup260
  {494,  0}, // #90 ADLPWriteResGroup261
  {470,  0}, // #91 ADLPWriteResGroup262
  {50,  0}, // #92 WriteDiv16Ld_WriteDiv32Ld_WriteDiv8
  {130,  0}, // #93 WriteDiv64Ld_WriteIDiv64Ld_AtomWrite01_130
  {68,  0}, // #94 WriteDiv8Ld_AtomWrite01_68
  {125,  0}, // #95 WriteFDiv64XLd_WriteFSqrt64XLd
  {34,  0}, // #96 WriteFDivLd_WriteFSqrtLd_WriteDiv16Ld_WriteDiv32Ld_WriteDiv64Ld_WriteDiv8Ld_BWWriteResGroup191_JWriteMASKMOVDQU_SBWriteResGroup131_WriteAESKeyGenLd_HWWriteResGroup166_WriteFDiv64
  { 1,  0}, // #97 WriteRotateLd_WriteRotateCLLd_WriteShiftLd_WriteShiftCLLd_WriteALULd
  { 1,  0}, // #98 WriteRMW
  {45,  0}, // #99 AtomWrite01_45_WriteFDiv64Y_WriteFDiv64Z_WriteFSqrt64Y_WriteFSqrt64Z_WriteDiv64Ld_WriteIDiv64Ld
  {48,  0}, // #100 AtomWrite01_48
  {55,  0}, // #101 AtomWrite01_55
  {59,  0}, // #102 AtomWrite01_59_WriteFSqrt64YLd
  {72,  0}, // #103 AtomWrite01_72_WriteFDiv64XLd
  {77,  0}, // #104 AtomWrite01_77
  {78,  0}, // #105 AtomWrite01_78
  {79,  0}, // #106 AtomWrite01_79
  {92,  0}, // #107 AtomWrite01_92
  {94,  0}, // #108 AtomWrite01_94
  {99,  0}, // #109 AtomWrite01_99
  {121,  0}, // #110 AtomWrite01_121
  {127,  0}, // #111 AtomWrite01_127
  {140,  0}, // #112 AtomWrite01_140_SKXWriteResGroup267_ICXWriteResGroup267
  {141,  0}, // #113 AtomWrite01_141
  {146,  0}, // #114 AtomWrite01_146
  {147,  0}, // #115 AtomWrite01_147
  {168,  0}, // #116 AtomWrite01_168
  {174,  0}, // #117 AtomWrite01_174
  {183,  0}, // #118 AtomWrite01_183
  {202,  0}, // #119 AtomWrite01_202
  { 5,  0}, // #120 WriteRotateLd_WriteRotateCLLd_WriteShiftLd_WriteShiftCLLd_WriteALULd
  { 1,  0}, // #121 WriteRMW
  {90,  0}, // #122 PdWriteVZEROALL_JWriteJVZEROALL
  {184,  0}, // #123 PdWriteLARrr
  {33,  0}, // #124 WriteAESKeyGenLd
  {80,  0}, // #125 WriteDiv16_WriteDiv32_WriteDiv64
  { 9,  0}, // #126 WriteIMulHLd
  { 8,  0}, // #127 WriteMULX32Ld_WriteMULX64Ld
  { 4,  0}, // #128 WriteIMulH
  { 3,  0}, // #129 WriteMULX32_WriteMULX64
  { 6,  0}, // #130 WriteRotateLd_WriteShiftLd_WriteALULd
  { 1,  0}, // #131 WriteRMW
  { 8,  0}, // #132 WriteRotateCLLd_WriteShiftCLLd
  { 1,  0}, // #133 WriteRMW
  {60,  0}, // #134 BWWriteResGroup197
  {115,  0}, // #135 BWWriteResGroup202_HWWriteResGroup183
  {44,  0}, // #136 WriteDiv64Ld_WriteIDiv64Ld_SKXWriteResGroup256_WriteFSqrtXLd_ICXWriteResGroup256
  { 4,  0}, // #137 WriteRotateLd_WriteRotateCLLd_WriteShiftLd_WriteShiftCLLd_WriteALULd
  { 2,  0}, // #138 WriteRMW
  {43,  0}, // #139 WriteFDiv64YLd_WriteFDivYLd
  {38,  0}, // #140 WriteFDiv64Y_WriteFDivY_JWriteLOCK_CMPXCHG16B_WriteFSqrt64Ld
  {54,  0}, // #141 WriteFSqrt64Y
  {47,  0}, // #142 WriteFSqrtYLd_HWWriteFBLD
  {11,  0}, // #143 JWriteXCHGrm_XCHG_Part_JWriteLOCK_XADDrm_XCHG_Part
  {16,  0}, // #144 JWriteXCHGrm_LdSt_Part
  { 3,  0}, // #145 JWriteXADDrm_XCHG_Part
  {11,  0}, // #146 JWriteXADDrm_LdSt_Part
  {76,  0}, // #147 WriteDiv16_WriteDiv32_WriteDiv64
  {102,  0}, // #148 WriteIDiv16_WriteIDiv32_WriteIDiv64
  {67,  0}, // #149 SKXWriteResGroup261_ICXWriteResGroup261
  { 7,  0}, // #150 WriteRotateLd
  { 1,  0}, // #151 WriteRMW
  {52,  0}, // #152 WriteFDiv64YLd_WriteFDiv64ZLd_WriteFSqrt64YLd_WriteFSqrt64ZLd
  {36,  0}, // #153 WriteFDivYLd_WriteFDivZLd_WriteFSqrtYLd_WriteFSqrtZLd_HWWriteResGroup171
  {98,  0}, // #154 WriteDiv16_WriteDiv32_WriteDiv64
  {112,  0}, // #155 WriteIDiv16_WriteIDiv32_WriteIDiv64
  {64,  0}, // #156 HWWriteResGroup179_HWWriteResGroup178
  {61,  0}, // #157 HWWriteResGroup177
  {69,  0}, // #158 WriteFDiv64X
  { 4,  0}, // #159 WriteRotateLd_WriteRotateCLLd_WriteShiftLd_WriteShiftCLLd_WriteALULd
  { 1,  0}, // #160 WriteRMW
  { 3,  0}, // #161 WriteIMulH
  { 3,  0}, // #162 WriteMULX32_WriteMULX64
  { 4,  0}, // #163 WriteLoad
  { 8,  0}, // #164 WriteVecMaskedGatherWriteback_WriteIMulHLd
  { 7,  0}, // #165 WriteIMulHLd_WriteMULX32Ld_WriteMULX64Ld
  { 7,  0} // #166 WriteMULX32Ld_WriteMULX64Ld
}; // X86WriteLatencyTable

// {UseIdx, WriteResourceID, Cycles}
extern const llvm::MCReadAdvanceEntry X86ReadAdvanceTable[] = {
  {0,  0,  0}, // Invalid
  {5,  0,  5}, // #1
  {6,  0,  5}, // #2
  {0,  0,  5}, // #3
  {6,  0,  5}, // #4
  {0,  0,  6}, // #5
  {1,  0,  0}, // #6
  {0,  0,  6}, // #7
  {6,  0,  6}, // #8
  {0,  0,  6}, // #9
  {1,  0,  6}, // #10
  {0,  0,  5}, // #11
  {1,  0,  5}, // #12
  {5,  0,  3}, // #13
  {6,  0,  3}, // #14
  {0,  0,  3}, // #15
  {6,  0,  3}, // #16
  {0,  0,  3}, // #17
  {1,  0,  3}, // #18
  {5,  0,  4}, // #19
  {6,  0,  4}, // #20
  {0,  0,  4}, // #21
  {6,  0,  4}, // #22
  {0,  0, -10}, // #23
  {1,  0, -10}, // #24
  {0,  0, -6}, // #25
  {1,  0, -6}, // #26
  {5,  0,  3}, // #27
  {6,  0,  3}, // #28
  {7,  0,  3}, // #29
  {8,  0,  3}, // #30
  {0,  0,  7}, // #31
  {0,  0,  7}, // #32
  {6,  0,  7}, // #33
  {0,  0,  7}, // #34
  {1,  0,  7}, // #35
  {0,  0,  8}, // #36
  {0,  0,  8}, // #37
  {6,  0,  8}, // #38
  {0,  0,  8}, // #39
  {1,  0,  8}, // #40
  {0,  0, -1}, // #41
  {1,  0, -1} // #42
}; // X86ReadAdvanceTable

// {Name, NumMicroOps, BeginGroup, EndGroup, RetireOOO, WriteProcResIdx,#, WriteLatencyIdx,#, ReadAdvanceIdx,#}
static const llvm::MCSchedClassDesc AlderlakePModelSchedClasses[] = {
  {DBGFIELD("InvalidSchedClass")  8191, false, false, false, 0, 0,  0, 0,  0, 0},
  {DBGFIELD("WriteALU")           1, false, false, false,  1, 1,  1, 1,  0, 0}, // #1
  {DBGFIELD("WriteZero")          1, false, false, false,  0, 0,  1, 1,  0, 0}, // #2
  {DBGFIELD("WriteVecALU")        1, false, false, false,  2, 8,  1, 1,  0, 0}, // #3
  {DBGFIELD("WriteJump")          1, false, false, false, 10, 4,  1, 1,  0, 0}, // #4
  {DBGFIELD("WriteCMPXCHGRMW")    6, false, false, false, 14, 8,  2, 1,  0, 0}, // #5
  {DBGFIELD("WriteJumpLd")        2, false, false, false, 22, 8,  3, 1,  0, 0}, // #6
  {DBGFIELD("WriteMove")          1, false, false, false,  1, 1,  1, 1,  0, 0}, // #7
  {DBGFIELD("WriteSystem")        1, false, false, false,  5, 2,  4, 1,  0, 0}, // #8
  {DBGFIELD("WriteADC")           1, false, false, false, 10, 4,  1, 1,  0, 0}, // #9
  {DBGFIELD("WriteSHDrri")        1, false, false, false, 30, 7,  5, 1,  0, 0}, // #10
  {DBGFIELD("WriteFStoreX")       2, false, false, false, 37, 3,  2, 1,  0, 0}, // #11
  {DBGFIELD("WriteFLoadX")        1, false, false, false, 28, 2,  6, 1,  0, 0}, // #12
  {DBGFIELD("WriteFStoreY")       2, false, false, false, 37, 3,  2, 1,  0, 0}, // #13
  {DBGFIELD("WriteFLoadY")        1, false, false, false, 28, 2,  7, 1,  0, 0}, // #14
  {DBGFIELD("WriteMicrocoded")    1, false, false, false,  5, 2,  4, 1,  0, 0}, // #15
  {DBGFIELD("WriteALURMW")        4, false, false, false, 40, 5,  2, 1,  0, 0}, // #16
  {DBGFIELD("WriteFSign")         1, false, false, false,  2, 8,  1, 1,  0, 0}, // #17
  {DBGFIELD("WriteADCRMW")        5, false, false, false, 45, 8,  2, 1,  0, 0}, // #18
  {DBGFIELD("WriteADCRMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 5, false, false, false, 45, 8,  2, 1,  1, 2}, // #19
  {DBGFIELD("WriteADCLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, false, 45, 4,  8, 1,  3, 2}, // #20
  {DBGFIELD("WriteALURMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 4, false, false, false, 40, 5,  2, 1,  1, 1}, // #21
  {DBGFIELD("WriteALULd_ReadAfterLd") 1, false, false, false,  1, 1,  8, 1,  3, 1}, // #22
  {DBGFIELD("WriteFAdd64XLd_ReadAfterVecXLd") 2, false, false, false, 53, 7,  9, 1,  5, 1}, // #23
  {DBGFIELD("WriteFAdd64X")       1, false, false, false, 53, 5,  5, 1,  0, 0}, // #24
  {DBGFIELD("WriteFAddXLd_ReadAfterVecXLd") 2, false, false, false, 53, 7,  9, 1,  5, 1}, // #25
  {DBGFIELD("WriteFAddX")         1, false, false, false, 53, 5,  5, 1,  0, 0}, // #26
  {DBGFIELD("WriteNop")           0, false, false, false,  0, 0,  1, 1,  0, 0}, // #27
  {DBGFIELD("WriteFAdd64Ld_ReadAfterVecLd") 2, false, false, false, 53, 7,  9, 1,  5, 1}, // #28
  {DBGFIELD("WriteFAdd64")        1, false, false, false, 53, 5,  5, 1,  0, 0}, // #29
  {DBGFIELD("WriteFAddLd_ReadAfterVecLd") 2, false, false, false, 53, 7,  9, 1,  5, 1}, // #30
  {DBGFIELD("WriteFAdd")          1, false, false, false, 60, 8,  5, 1,  0, 0}, // #31
  {DBGFIELD("WriteFAddLd")        2, false, false, false, 53, 7,  9, 1,  0, 0}, // #32
  {DBGFIELD("WriteAESDecEncLd_ReadAfterVecXLd") 2, false, false, false, 68, 6,  2, 1,  5, 1}, // #33
  {DBGFIELD("WriteAESDecEnc")     1, false, false, false,  3, 4, 10, 1,  0, 0}, // #34
  {DBGFIELD("WriteAESIMCLd")      3, false, false, false, 74, 6, 11, 1,  0, 0}, // #35
  {DBGFIELD("WriteAESIMC")        2, false, false, false, 74, 4,  7, 1,  0, 0}, // #36
  {DBGFIELD("WriteAESKeyGenLd")   14, false, false, false, 80, 13,  2, 1,  0, 0}, // #37
  {DBGFIELD("WriteAESKeyGen")     14, false, false, false, 93, 11,  6, 1,  0, 0}, // #38
  {DBGFIELD("WriteFLogicLd_ReadAfterVecXLd") 2, false, false, false, 69, 5,  7, 1,  5, 1}, // #39
  {DBGFIELD("WriteFLogic")        1, false, false, false,  4, 3,  1, 1,  0, 0}, // #40
  {DBGFIELD("WriteBEXTRLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 3, false, false, false, 104, 11,  8, 1,  1, 1}, // #41
  {DBGFIELD("WriteBEXTR")         2, false, false, false, 104, 9,  3, 1,  0, 0}, // #42
  {DBGFIELD("WriteBEXTRLd")       3, false, false, false, 104, 11,  8, 1,  0, 0}, // #43
  {DBGFIELD("WriteALULd")         1, false, false, false,  1, 1,  8, 1,  0, 0}, // #44
  {DBGFIELD("WriteFBlendLd_ReadAfterVecXLd") 2, false, false, false, 69, 5,  7, 1,  5, 1}, // #45
  {DBGFIELD("WriteFBlend")        1, false, false, false,  4, 3,  1, 1,  0, 0}, // #46
  {DBGFIELD("WriteFVarBlendLd_ReadAfterVecXLd") 2, false, false, false, 69, 5,  7, 1,  5, 1}, // #47
  {DBGFIELD("WriteFVarBlend")     1, false, false, false,  4, 3,  1, 1,  0, 0}, // #48
  {DBGFIELD("WriteBLSLd")         2, false, false, false, 115, 4,  6, 1,  0, 0}, // #49
  {DBGFIELD("WriteBLS")           1, false, false, false, 115, 2, 12, 1,  0, 0}, // #50
  {DBGFIELD("WriteBSFLd")         2, false, false, false, 119, 9,  7, 1,  0, 0}, // #51
  {DBGFIELD("WriteBSF")           1, false, false, false, 30, 7,  5, 1,  0, 0}, // #52
  {DBGFIELD("WriteBSRLd")         2, false, false, false, 119, 9,  7, 1,  0, 0}, // #53
  {DBGFIELD("WriteBSR")           1, false, false, false, 30, 7,  5, 1,  0, 0}, // #54
  {DBGFIELD("WriteBSWAP32")       1, false, false, false, 30, 7,  1, 1,  0, 0}, // #55
  {DBGFIELD("WriteBSWAP64")       2, false, false, false, 104, 9, 12, 1,  0, 0}, // #56
  {DBGFIELD("WriteBitTestImmLd")  2, false, false, false, 119, 9,  3, 1,  0, 0}, // #57
  {DBGFIELD("WriteBitTestRegLd")  10, false, false, false, 128, 11,  8, 1,  0, 0}, // #58
  {DBGFIELD("WriteBitTest")       1, false, false, false, 30, 7,  1, 1,  0, 0}, // #59
  {DBGFIELD("WriteBitTestSetImmRMW") 4, false, false, false, 139, 11,  2, 1,  0, 0}, // #60
  {DBGFIELD("WriteBitTestSetRegRMW") 11, false, false, false, 150, 13, 13, 1,  0, 0}, // #61
  {DBGFIELD("WriteBitTestSet")    1, false, false, false, 30, 7,  1, 1,  0, 0}, // #62
  {DBGFIELD("WriteBZHILd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, false, 119, 9,  7, 1,  1, 1}, // #63
  {DBGFIELD("WriteBZHI")          1, false, false, false, 30, 7,  5, 1,  0, 0}, // #64
  {DBGFIELD("WriteLoad")          1, false, false, false, 28, 2, 10, 1,  0, 0}, // #65
  {DBGFIELD("WriteCMOVLd_ReadAfterLd") 2, false, false, false, 163, 6,  6, 1,  3, 1}, // #66
  {DBGFIELD("WriteCMOV")          1, false, false, false, 10, 4,  1, 1,  0, 0}, // #67
  {DBGFIELD("WriteFCMOV")         1, false, false, false, 30, 7,  5, 1,  0, 0}, // #68
  {DBGFIELD("WriteALULd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, false,  1, 1,  8, 1,  1, 1}, // #69
  {DBGFIELD("WriteXCHG")          3, false, false, false, 15, 1, 12, 1,  0, 0}, // #70
  {DBGFIELD("WriteFCmp64XLd_ReadAfterVecXLd") 2, false, false, false, 68, 6,  8, 1,  5, 1}, // #71
  {DBGFIELD("WriteFCmp64X")       1, false, false, false,  3, 4, 14, 1,  0, 0}, // #72
  {DBGFIELD("WriteFCmpXLd_ReadAfterVecXLd") 2, false, false, false, 68, 6,  8, 1,  5, 1}, // #73
  {DBGFIELD("WriteFCmpX")         1, false, false, false,  3, 4, 14, 1,  0, 0}, // #74
  {DBGFIELD("WriteFCmp64Ld_ReadAfterVecLd") 2, false, false, false, 68, 6,  8, 1,  5, 1}, // #75
  {DBGFIELD("WriteFCmp64")        1, false, false, false,  3, 4, 14, 1,  0, 0}, // #76
  {DBGFIELD("WriteFCmpLd_ReadAfterVecLd") 2, false, false, false, 68, 6,  8, 1,  5, 1}, // #77
  {DBGFIELD("WriteFCmp")          1, false, false, false,  3, 4, 14, 1,  0, 0}, // #78
  {DBGFIELD("WriteCMPXCHG")       5, false, false, false, 169, 4,  5, 1,  0, 0}, // #79
  {DBGFIELD("WriteFComXLd_ReadAfterVecLd") 2, false, false, false, 173, 10,  7, 1,  5, 1}, // #80
  {DBGFIELD("WriteFComX")         1, false, false, false,  2, 8,  5, 1,  0, 0}, // #81
  {DBGFIELD("WriteFCom")          1, false, false, false, 60, 8,  1, 1,  0, 0}, // #82
  {DBGFIELD("WriteCRC32Ld_ReadAfterLd") 2, false, false, false, 119, 9,  7, 1,  3, 1}, // #83
  {DBGFIELD("WriteCRC32")         1, false, false, false, 30, 7,  5, 1,  0, 0}, // #84
  {DBGFIELD("WriteCvtI2PDLd")     2, false, false, false, 68, 6,  8, 1,  0, 0}, // #85
  {DBGFIELD("WriteCvtI2PD")       2, false, false, false, 183, 9, 10, 1,  0, 0}, // #86
  {DBGFIELD("WriteCvtI2PSLd")     2, false, false, false, 68, 6,  8, 1,  0, 0}, // #87
  {DBGFIELD("WriteCvtI2PS")       1, false, false, false,  3, 4, 14, 1,  0, 0}, // #88
  {DBGFIELD("WriteCvtPD2ILd")     3, false, false, false, 192, 11,  2, 1,  0, 0}, // #89
  {DBGFIELD("WriteCvtPD2I")       2, false, false, false, 183, 9, 10, 1,  0, 0}, // #90
  {DBGFIELD("WriteCvtPD2PSLd")    3, false, false, false, 192, 11,  2, 1,  0, 0}, // #91
  {DBGFIELD("WriteCvtPD2PS")      2, false, false, false, 183, 9, 10, 1,  0, 0}, // #92
  {DBGFIELD("WriteCvtPS2ILd")     2, false, false, false, 68, 6,  8, 1,  0, 0}, // #93
  {DBGFIELD("WriteCvtPS2I")       1, false, false, false,  3, 4, 14, 1,  0, 0}, // #94
  {DBGFIELD("WriteCvtPS2PDLd")    2, false, false, false, 68, 6,  8, 1,  0, 0}, // #95
  {DBGFIELD("WriteCvtPS2PD")      2, false, false, false, 183, 9, 10, 1,  0, 0}, // #96
  {DBGFIELD("WriteCvtSD2ILd")     3, false, false, false, 203, 10,  2, 1,  0, 0}, // #97
  {DBGFIELD("WriteCvtSD2I_ReadDefault") 2, false, false, false, 203, 8,  6, 1,  0, 0}, // #98
  {DBGFIELD("WriteCvtSD2I")       2, false, false, false, 203, 8,  6, 1,  0, 0}, // #99
  {DBGFIELD("WriteCvtSD2SSLd_ReadAfterVecLd") 3, false, false, false, 192, 11,  2, 1,  5, 1}, // #100
  {DBGFIELD("WriteCvtSD2SS")      2, false, false, false, 183, 9, 10, 1,  0, 0}, // #101
  {DBGFIELD("WriteCvtI2SDLd")     2, false, false, false, 68, 6,  8, 1,  0, 0}, // #102
  {DBGFIELD("WriteCvtI2SDLd_ReadAfterVecLd") 2, false, false, false, 68, 6,  8, 1,  5, 1}, // #103
  {DBGFIELD("WriteCvtI2SD_ReadInt2Fpu") 2, false, false, false, 183, 9,  6, 1,  0, 1}, // #104
  {DBGFIELD("WriteCvtI2SD_ReadDefault_ReadInt2Fpu") 2, false, false, false, 183, 9,  6, 1,  6, 1}, // #105
  {DBGFIELD("WriteCvtI2SSLd")     2, false, false, false, 68, 6,  8, 1,  0, 0}, // #106
  {DBGFIELD("WriteCvtI2SSLd_ReadAfterVecLd") 2, false, false, false, 68, 6,  8, 1,  5, 1}, // #107
  {DBGFIELD("WriteCvtI2SS_ReadInt2Fpu") 2, false, false, false, 183, 9,  6, 1,  0, 1}, // #108
  {DBGFIELD("WriteCvtI2SS_ReadDefault_ReadInt2Fpu") 2, false, false, false, 183, 9,  6, 1,  6, 1}, // #109
  {DBGFIELD("WriteCvtSS2SDLd_ReadAfterVecLd") 2, false, false, false, 68, 6,  8, 1,  5, 1}, // #110
  {DBGFIELD("WriteCvtSS2SD")      2, false, false, false, 183, 9, 10, 1,  0, 0}, // #111
  {DBGFIELD("WriteCvtSS2ILd")     3, false, false, false, 203, 10,  2, 1,  0, 0}, // #112
  {DBGFIELD("WriteCvtSS2I_ReadDefault") 2, false, false, false, 203, 8,  6, 1,  0, 0}, // #113
  {DBGFIELD("WriteCvtSS2I")       2, false, false, false, 203, 8,  6, 1,  0, 0}, // #114
  {DBGFIELD("WriteDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 5, false, false, false, 213, 9, 15, 1,  1, 2}, // #115
  {DBGFIELD("WriteDiv16")         4, false, false, false, 213, 7, 16, 1,  0, 0}, // #116
  {DBGFIELD("WriteDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 5, false, false, false, 213, 9, 17, 1,  1, 2}, // #117
  {DBGFIELD("WriteDiv32")         4, false, false, false, 213, 7, 11, 1,  0, 0}, // #118
  {DBGFIELD("WriteDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 4, false, false, false, 222, 9, 18, 1,  1, 2}, // #119
  {DBGFIELD("WriteDiv64")         3, false, false, false, 222, 7, 13, 1,  0, 0}, // #120
  {DBGFIELD("WriteDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 3, false, false, false, 222, 7, 19, 1,  1, 2}, // #121
  {DBGFIELD("WriteDiv8")          3, false, false, false, 222, 7, 20, 1,  0, 0}, // #122
  {DBGFIELD("WriteFDiv64XLd_ReadAfterVecXLd") 2, false, false, false, 173, 10, 15, 1,  5, 1}, // #123
  {DBGFIELD("WriteFDiv64X")       1, false, false, false,  2, 8, 21, 1,  0, 0}, // #124
  {DBGFIELD("WriteFDivXLd_ReadAfterVecXLd") 2, false, false, false, 173, 10, 13, 1,  5, 1}, // #125
  {DBGFIELD("WriteFDivX")         1, false, false, false,  2, 8,  8, 1,  0, 0}, // #126
  {DBGFIELD("WriteFDivLd")        2, false, false, false, 173, 10, 13, 1,  0, 0}, // #127
  {DBGFIELD("WriteFDiv")          1, false, false, false,  2, 8,  8, 1,  0, 0}, // #128
  {DBGFIELD("WriteFDiv64Ld_ReadAfterVecLd") 2, false, false, false, 173, 10, 17, 1,  5, 1}, // #129
  {DBGFIELD("WriteFDiv64")        1, false, false, false,  2, 8, 21, 1,  0, 0}, // #130
  {DBGFIELD("WriteFDivLd_ReadAfterVecLd") 2, false, false, false, 173, 10, 13, 1,  5, 1}, // #131
  {DBGFIELD("WriteDPPDLd_ReadAfterVecXLd") 4, false, false, false, 231, 8, 16, 1,  5, 1}, // #132
  {DBGFIELD("WriteDPPD")          3, false, false, false, 231, 6, 22, 1,  0, 0}, // #133
  {DBGFIELD("WriteDPPSLd_ReadAfterVecXLd") 7, false, false, false, 239, 12, 23, 1,  5, 1}, // #134
  {DBGFIELD("WriteDPPS")          6, false, false, false, 251, 10, 21, 1,  0, 0}, // #135
  {DBGFIELD("WriteStore")         2, false, false, false, 37, 3,  2, 1,  0, 0}, // #136
  {DBGFIELD("WriteVecExtractSt")  3, false, false, false, 261, 8, 17, 1,  0, 0}, // #137
  {DBGFIELD("WriteVecExtract")    2, false, false, false, 269, 10, 14, 1,  0, 0}, // #138
  {DBGFIELD("WriteVecALUX")       1, false, false, false,  3, 4,  1, 1,  0, 0}, // #139
  {DBGFIELD("WriteFComLd")        2, false, false, false, 279, 12,  7, 1,  0, 0}, // #140
  {DBGFIELD("WriteEMMS")          10, false, false, false, 291, 8,  9, 1,  0, 0}, // #141
  {DBGFIELD("WriteFLDC")          2, false, false, false, 299, 5,  1, 1,  0, 0}, // #142
  {DBGFIELD("WriteVecIMulXLd_ReadAfterVecXLd") 2, false, false, false, 68, 6, 24, 1,  5, 1}, // #143
  {DBGFIELD("WriteVecIMulX")      1, false, false, false,  3, 4, 10, 1,  0, 0}, // #144
  {DBGFIELD("WriteVecALUXLd_ReadAfterVecXLd") 2, false, false, false, 68, 6,  7, 1,  5, 1}, // #145
  {DBGFIELD("WriteFHAddLd_ReadAfterVecXLd") 4, false, false, false, 304, 10,  2, 1,  5, 1}, // #146
  {DBGFIELD("WriteFHAdd")         3, false, false, false, 314, 8,  3, 1,  0, 0}, // #147
  {DBGFIELD("WriteIDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 5, false, false, false, 213, 9, 15, 1,  1, 2}, // #148
  {DBGFIELD("WriteIDiv16")        4, false, false, false, 213, 7, 16, 1,  0, 0}, // #149
  {DBGFIELD("WriteIDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 5, false, false, false, 213, 9, 17, 1,  1, 2}, // #150
  {DBGFIELD("WriteIDiv32")        4, false, false, false, 213, 7, 11, 1,  0, 0}, // #151
  {DBGFIELD("WriteIDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 4, false, false, false, 222, 9, 18, 1,  1, 2}, // #152
  {DBGFIELD("WriteIDiv64")        3, false, false, false, 222, 7, 13, 1,  0, 0}, // #153
  {DBGFIELD("WriteIDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 3, false, false, false, 222, 7, 19, 1,  1, 2}, // #154
  {DBGFIELD("WriteIDiv8")         3, false, false, false, 222, 7, 20, 1,  0, 0}, // #155
  {DBGFIELD("WriteIMul16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 5, false, false, false, 322, 11,  9, 1,  1, 2}, // #156
  {DBGFIELD("WriteIMul16")        4, false, false, false, 322, 9, 10, 1,  0, 0}, // #157
  {DBGFIELD("WriteIMul16RegLd_ReadAfterLd") 2, false, false, false, 119, 9,  7, 1,  3, 1}, // #158
  {DBGFIELD("WriteIMul16ImmLd")   3, false, false, false, 333, 9, 22, 1,  0, 0}, // #159
  {DBGFIELD("WriteIMul16Reg")     1, false, false, false, 30, 7,  5, 1,  0, 0}, // #160
  {DBGFIELD("WriteIMul16Imm")     2, false, false, false, 333, 7, 14, 1,  0, 0}, // #161
  {DBGFIELD("WriteIMul32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 4, false, false, false, 342, 11, 22, 1,  1, 2}, // #162
  {DBGFIELD("WriteIMul32")        3, false, false, false, 342, 9, 14, 1,  0, 0}, // #163
  {DBGFIELD("WriteIMul32RegLd_ReadAfterLd") 2, false, false, false, 119, 9,  7, 1,  3, 1}, // #164
  {DBGFIELD("WriteIMul32ImmLd")   2, false, false, false, 119, 9,  7, 1,  0, 0}, // #165
  {DBGFIELD("WriteIMul32Reg")     1, false, false, false, 30, 7,  5, 1,  0, 0}, // #166
  {DBGFIELD("WriteIMul32Imm")     1, false, false, false, 30, 7,  5, 1,  0, 0}, // #167
  {DBGFIELD("WriteIMul64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 3, false, false, false, 353, 12, 22, 1,  1, 2}, // #168
  {DBGFIELD("WriteIMul64")        2, false, false, false, 365, 10, 14, 1,  0, 0}, // #169
  {DBGFIELD("WriteIMul64RegLd_ReadAfterLd") 2, false, false, false, 119, 9,  7, 1,  3, 1}, // #170
  {DBGFIELD("WriteIMul64ImmLd")   2, false, false, false, 119, 9,  7, 1,  0, 0}, // #171
  {DBGFIELD("WriteIMul64Reg")     1, false, false, false, 30, 7,  5, 1,  0, 0}, // #172
  {DBGFIELD("WriteIMul64Imm")     1, false, false, false, 30, 7,  5, 1,  0, 0}, // #173
  {DBGFIELD("WriteIMul8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, false, 119, 9,  7, 1,  1, 2}, // #174
  {DBGFIELD("WriteIMul8")         1, false, false, false, 30, 7,  5, 1,  0, 0}, // #175
  {DBGFIELD("WriteFShuffleLd_ReadAfterVecXLd") 2, false, false, false, 375, 10,  7, 1,  5, 1}, // #176
  {DBGFIELD("WriteFShuffle")      1, false, false, false, 60, 8,  1, 1,  0, 0}, // #177
  {DBGFIELD("WriteVecLogicX")     1, false, false, false,  4, 3,  1, 1,  0, 0}, // #178
  {DBGFIELD("WriteShuffle")       1, false, false, false, 60, 8,  1, 1,  0, 0}, // #179
  {DBGFIELD("WriteLAHFSAHF")      1, false, false, false, 10, 4,  5, 1,  0, 0}, // #180
  {DBGFIELD("WriteVecLoadX")      1, false, false, false, 28, 2,  6, 1,  0, 0}, // #181
  {DBGFIELD("WriteLDMXCSR")       4, false, false, false, 385, 10,  6, 1,  0, 0}, // #182
  {DBGFIELD("WriteFLD0")          1, false, false, false,  4, 5,  1, 1,  0, 0}, // #183
  {DBGFIELD("WriteFLD1")          2, false, false, false, 299, 5,  1, 1,  0, 0}, // #184
  {DBGFIELD("WriteLEA")           1, false, false, false, 30, 7,  1, 1,  0, 0}, // #185
  {DBGFIELD("WriteFence")         1, false, false, false, 10, 4, 12, 1,  0, 0}, // #186
  {DBGFIELD("WriteLZCNTLd")       2, false, false, false, 119, 9,  7, 1,  0, 0}, // #187
  {DBGFIELD("WriteLZCNT")         1, false, false, false, 30, 7,  5, 1,  0, 0}, // #188
  {DBGFIELD("WriteVecStoreX")     2, false, false, false, 37, 3,  2, 1,  0, 0}, // #189
  {DBGFIELD("WriteVecStore")      2, false, false, false, 37, 3,  2, 1,  0, 0}, // #190
  {DBGFIELD("WriteVecMoveToGpr")  1, false, false, false,  2, 8,  5, 1,  0, 0}, // #191
  {DBGFIELD("WriteVecLoad")       1, false, false, false, 28, 2,  6, 1,  0, 0}, // #192
  {DBGFIELD("WriteVecMoveFromGpr") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #193
  {DBGFIELD("WriteVecMoveX")      0, false, false, false,  0, 0,  1, 1,  0, 0}, // #194
  {DBGFIELD("WriteVecStoreNT")    2, false, false, false, 37, 3, 25, 1,  0, 0}, // #195
  {DBGFIELD("WriteVecMove")       1, false, false, false,  4, 5,  1, 1,  0, 0}, // #196
  {DBGFIELD("WriteVecALULd")      2, false, false, false, 173, 10, 22, 1,  0, 0}, // #197
  {DBGFIELD("WriteShuffleLd_ReadAfterVecLd") 2, false, false, false, 375, 10, 22, 1,  5, 1}, // #198
  {DBGFIELD("WriteVecALULd_ReadAfterVecLd") 2, false, false, false, 173, 10, 22, 1,  5, 1}, // #199
  {DBGFIELD("WriteVecLogicLd_ReadAfterVecLd") 2, false, false, false, 395, 7, 22, 1,  5, 1}, // #200
  {DBGFIELD("WriteVecLogic")      1, false, false, false,  4, 5,  1, 1,  0, 0}, // #201
  {DBGFIELD("WritePHAddLd_ReadAfterVecLd") 4, false, false, false, 402, 10,  8, 1,  5, 1}, // #202
  {DBGFIELD("WritePHAdd")         3, false, false, false, 412, 8,  5, 1,  0, 0}, // #203
  {DBGFIELD("WriteVecInsertLd_ReadAfterLd") 2, false, false, false, 53, 7,  7, 1,  3, 1}, // #204
  {DBGFIELD("WriteVecInsert_ReadDefault_ReadInt2Fpu") 2, false, false, false, 420, 8, 14, 1,  6, 1}, // #205
  {DBGFIELD("WriteVecIMulLd_ReadAfterVecLd") 2, false, false, false, 173, 10, 24, 1,  5, 1}, // #206
  {DBGFIELD("WriteVecIMul")       1, false, false, false,  2, 8, 10, 1,  0, 0}, // #207
  {DBGFIELD("WriteMMXMOVMSK")     1, false, false, false,  2, 8,  5, 1,  0, 0}, // #208
  {DBGFIELD("WritePSADBWLd_ReadAfterVecLd") 2, false, false, false, 375, 10,  8, 1,  5, 1}, // #209
  {DBGFIELD("WritePSADBW")        1, false, false, false, 60, 8,  5, 1,  0, 0}, // #210
  {DBGFIELD("WriteVarShuffleLd_ReadAfterVecLd") 3, false, false, false, 428, 13,  8, 1,  5, 1}, // #211
  {DBGFIELD("WriteVarShuffle")    2, false, false, false, 441, 11,  5, 1,  0, 0}, // #212
  {DBGFIELD("WriteShuffleLd")     2, false, false, false, 375, 10, 22, 1,  0, 0}, // #213
  {DBGFIELD("WriteVecShiftImm")   1, false, false, false,  2, 8,  1, 1,  0, 0}, // #214
  {DBGFIELD("WriteVecShiftLd_ReadAfterVecLd") 2, false, false, false, 173, 10, 22, 1,  5, 1}, // #215
  {DBGFIELD("WriteVecShift")      1, false, false, false,  2, 8,  1, 1,  0, 0}, // #216
  {DBGFIELD("WriteFMoveX")        0, false, false, false,  0, 0,  1, 1,  0, 0}, // #217
  {DBGFIELD("WriteFShuffleLd")    2, false, false, false, 375, 10,  7, 1,  0, 0}, // #218
  {DBGFIELD("WriteFStore")        2, false, false, false, 37, 3,  2, 1,  0, 0}, // #219
  {DBGFIELD("WriteFMOVMSK")       1, false, false, false,  2, 8,  5, 1,  0, 0}, // #220
  {DBGFIELD("WriteVecLoadNT")     1, false, false, false, 28, 2,  6, 1,  0, 0}, // #221
  {DBGFIELD("WriteStoreNT")       2, false, false, false, 37, 3, 26, 1,  0, 0}, // #222
  {DBGFIELD("WriteFStoreNTX")     2, false, false, false, 37, 3, 27, 1,  0, 0}, // #223
  {DBGFIELD("WriteFStoreNT")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #224
  {DBGFIELD("WriteFLoad")         1, false, false, false, 28, 2,  6, 1,  0, 0}, // #225
  {DBGFIELD("WriteMPSADLd_ReadAfterVecXLd") 3, false, false, false, 452, 10,  8, 1,  5, 1}, // #226
  {DBGFIELD("WriteMPSAD")         2, false, false, false, 420, 8, 14, 1,  0, 0}, // #227
  {DBGFIELD("WriteFMul64XLd_ReadAfterVecXLd") 2, false, false, false, 68, 6,  8, 1,  5, 1}, // #228
  {DBGFIELD("WriteFMul64X")       1, false, false, false,  3, 4, 14, 1,  0, 0}, // #229
  {DBGFIELD("WriteFMulXLd_ReadAfterVecXLd") 2, false, false, false, 68, 6,  8, 1,  5, 1}, // #230
  {DBGFIELD("WriteFMulX")         1, false, false, false,  3, 4, 14, 1,  0, 0}, // #231
  {DBGFIELD("WriteFMul64Ld_ReadAfterVecLd") 2, false, false, false, 68, 6,  8, 1,  5, 1}, // #232
  {DBGFIELD("WriteFMul64")        1, false, false, false,  3, 4, 14, 1,  0, 0}, // #233
  {DBGFIELD("WriteFMulLd_ReadAfterVecLd") 2, false, false, false, 68, 6,  8, 1,  5, 1}, // #234
  {DBGFIELD("WriteFMul")          1, false, false, false,  3, 4, 14, 1,  0, 0}, // #235
  {DBGFIELD("WriteMULX32Ld")      3, false, false, false, 342, 11, 22, 1,  0, 0}, // #236
  {DBGFIELD("WriteMULX32")        2, false, false, false, 342, 9, 14, 1,  0, 0}, // #237
  {DBGFIELD("WriteIMulHLd_WriteMULX32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 4, false, false, false, 342, 11, 28, 2,  1, 1}, // #238
  {DBGFIELD("WriteIMulH_WriteMULX32") 3, false, false, false, 342, 9, 30, 2,  0, 0}, // #239
  {DBGFIELD("WriteMULX64Ld")      2, false, false, false, 353, 12, 22, 1,  0, 0}, // #240
  {DBGFIELD("WriteMULX64")        1, false, false, false, 365, 10, 14, 1,  0, 0}, // #241
  {DBGFIELD("WriteIMulHLd_WriteMULX64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 3, false, false, false, 353, 12, 28, 2,  1, 1}, // #242
  {DBGFIELD("WriteIMulH_WriteMULX64") 2, false, false, false, 365, 10, 30, 2,  0, 0}, // #243
  {DBGFIELD("WriteFMulLd")        2, false, false, false, 68, 6,  8, 1,  0, 0}, // #244
  {DBGFIELD("WriteVecALUXLd")     2, false, false, false, 68, 6,  7, 1,  0, 0}, // #245
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd") 2, false, false, false, 53, 7,  7, 1,  5, 1}, // #246
  {DBGFIELD("WriteShuffleX")      1, false, false, false, 53, 5,  1, 1,  0, 0}, // #247
  {DBGFIELD("WriteVecLogicXLd_ReadAfterVecXLd") 2, false, false, false, 69, 5,  7, 1,  5, 1}, // #248
  {DBGFIELD("WriteVarBlendLd_ReadAfterVecXLd") 2, false, false, false, 69, 5,  7, 1,  5, 1}, // #249
  {DBGFIELD("WriteVarBlend")      1, false, false, false,  4, 3,  1, 1,  0, 0}, // #250
  {DBGFIELD("WriteBlendLd_ReadAfterVecXLd") 2, false, false, false, 53, 7,  7, 1,  5, 1}, // #251
  {DBGFIELD("WriteBlend")         1, false, false, false, 53, 5,  1, 1,  0, 0}, // #252
  {DBGFIELD("WriteCLMulLd_ReadAfterVecXLd") 2, false, false, false, 375, 10,  9, 1,  5, 1}, // #253
  {DBGFIELD("WriteCLMul")         1, false, false, false, 60, 8,  5, 1,  0, 0}, // #254
  {DBGFIELD("WritePCmpEStrILd_ReadAfterVecXLd") 8, false, false, false, 462, 14, 32, 1,  5, 1}, // #255
  {DBGFIELD("WritePCmpEStrI")     8, false, false, false, 476, 12, 16, 1,  0, 0}, // #256
  {DBGFIELD("WritePCmpEStrMLd_ReadAfterVecXLd") 9, false, false, false, 488, 14, 20, 1,  5, 1}, // #257
  {DBGFIELD("WritePCmpEStrM")     9, false, false, false, 502, 12, 16, 1,  0, 0}, // #258
  {DBGFIELD("WritePCmpIStrILd_ReadAfterVecXLd") 4, false, false, false, 514, 10, 32, 1,  5, 1}, // #259
  {DBGFIELD("WritePCmpIStrI")     3, false, false, false, 514, 8,  8, 1,  0, 0}, // #260
  {DBGFIELD("WritePCmpIStrMLd_ReadAfterVecXLd") 4, false, false, false, 514, 10, 16, 1,  5, 1}, // #261
  {DBGFIELD("WritePCmpIStrM")     3, false, false, false, 514, 8,  8, 1,  0, 0}, // #262
  {DBGFIELD("WriteCvtPS2ILd_ReadAfterVecXLd") 2, false, false, false, 68, 6,  8, 1,  5, 1}, // #263
  {DBGFIELD("WritePHAddXLd_ReadAfterVecXLd") 4, false, false, false, 524, 7, 22, 1,  5, 1}, // #264
  {DBGFIELD("WritePHAddX")        3, false, false, false, 524, 5, 12, 1,  0, 0}, // #265
  {DBGFIELD("WritePHMINPOSLd")    2, false, false, false, 173, 10,  8, 1,  0, 0}, // #266
  {DBGFIELD("WritePHMINPOS")      1, false, false, false,  2, 8, 14, 1,  0, 0}, // #267
  {DBGFIELD("WriteCvtI2PSLd_ReadAfterVecXLd") 2, false, false, false, 68, 6,  8, 1,  5, 1}, // #268
  {DBGFIELD("WriteVecMOVMSK")     1, false, false, false,  2, 8,  5, 1,  0, 0}, // #269
  {DBGFIELD("WriteShuffleXLd")    2, false, false, false, 53, 7,  7, 1,  0, 0}, // #270
  {DBGFIELD("WritePMULLDLd_ReadAfterVecXLd") 3, false, false, false, 74, 6, 13, 1,  5, 1}, // #271
  {DBGFIELD("WritePMULLD")        2, false, false, false, 74, 4,  9, 1,  0, 0}, // #272
  {DBGFIELD("WriteCopy")          3, false, false, false, 18, 4, 20, 1,  0, 0}, // #273
  {DBGFIELD("WritePOPCNTLd")      2, false, false, false, 119, 9,  7, 1,  0, 0}, // #274
  {DBGFIELD("WritePOPCNT")        1, false, false, false, 30, 7,  5, 1,  0, 0}, // #275
  {DBGFIELD("WritePSADBWXLd_ReadAfterVecXLd") 2, false, false, false, 375, 10,  9, 1,  5, 1}, // #276
  {DBGFIELD("WritePSADBWX")       1, false, false, false, 60, 8,  5, 1,  0, 0}, // #277
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd") 2, false, false, false, 53, 7,  7, 1,  5, 1}, // #278
  {DBGFIELD("WriteVarShuffleX")   1, false, false, false, 53, 5,  1, 1,  0, 0}, // #279
  {DBGFIELD("WriteVecShiftImmX")  1, false, false, false,  3, 4,  1, 1,  0, 0}, // #280
  {DBGFIELD("WriteVecShiftXLd_ReadAfterVecXLd") 2, false, false, false, 68, 6,  7, 1,  5, 1}, // #281
  {DBGFIELD("WriteVecShiftX")     2, false, false, false, 531, 6, 12, 1,  0, 0}, // #282
  {DBGFIELD("WriteVecTestLd_ReadAfterVecXLd") 3, false, false, false, 428, 13, 22, 1,  5, 1}, // #283
  {DBGFIELD("WriteVecTest")       2, false, false, false, 441, 11, 14, 1,  0, 0}, // #284
  {DBGFIELD("WriteRotateLd_WriteRMW") 6, false, false, false, 14, 8, 33, 2,  0, 0}, // #285
  {DBGFIELD("WriteRotateCLLd_WriteRMW") 10, false, false, false, 537, 13, 35, 2,  0, 0}, // #286
  {DBGFIELD("WriteRotate")        3, false, false, false, 14, 4, 12, 1,  0, 0}, // #287
  {DBGFIELD("WriteRotateCL")      2, false, false, false, 550, 4, 12, 1,  0, 0}, // #288
  {DBGFIELD("WriteFRcpXLd")       2, false, false, false, 173, 10,  8, 1,  0, 0}, // #289
  {DBGFIELD("WriteFRcpX")         1, false, false, false,  2, 8, 14, 1,  0, 0}, // #290
  {DBGFIELD("WriteFRcpLd")        2, false, false, false, 173, 10,  8, 1,  0, 0}, // #291
  {DBGFIELD("WriteFRcpLd_ReadAfterVecLd") 2, false, false, false, 173, 10,  8, 1,  5, 1}, // #292
  {DBGFIELD("WriteFRcp")          1, false, false, false,  2, 8, 14, 1,  0, 0}, // #293
  {DBGFIELD("WriteRMW")           3, false, false, false, 18, 4,  1, 1,  0, 0}, // #294
  {DBGFIELD("WriteShiftLd")       1, false, false, false, 10, 4,  2, 1,  0, 0}, // #295
  {DBGFIELD("WriteShift")         1, false, false, false, 10, 4,  1, 1,  0, 0}, // #296
  {DBGFIELD("WriteFRndLd")        3, false, false, false, 74, 6, 11, 1,  0, 0}, // #297
  {DBGFIELD("WriteFRnd")          2, false, false, false, 74, 4,  7, 1,  0, 0}, // #298
  {DBGFIELD("WriteFRndLd_ReadAfterVecXLd") 3, false, false, false, 74, 6, 11, 1,  5, 1}, // #299
  {DBGFIELD("WriteFRsqrtXLd")     2, false, false, false, 173, 10,  8, 1,  0, 0}, // #300
  {DBGFIELD("WriteFRsqrtX")       1, false, false, false,  2, 8, 14, 1,  0, 0}, // #301
  {DBGFIELD("WriteFRsqrtLd")      2, false, false, false, 173, 10,  8, 1,  0, 0}, // #302
  {DBGFIELD("WriteFRsqrtLd_ReadAfterVecLd") 2, false, false, false, 173, 10,  8, 1,  5, 1}, // #303
  {DBGFIELD("WriteFRsqrt")        1, false, false, false,  2, 8, 14, 1,  0, 0}, // #304
  {DBGFIELD("WriteShiftLd_WriteRMW") 4, false, false, false, 554, 8, 33, 2,  0, 0}, // #305
  {DBGFIELD("WriteShiftCLLd_WriteRMW") 5, false, false, false, 562, 8, 33, 2,  0, 0}, // #306
  {DBGFIELD("WriteShiftCL")       2, false, false, false, 550, 4, 12, 1,  0, 0}, // #307
  {DBGFIELD("WriteShiftLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, false, 10, 4,  2, 1,  1, 1}, // #308
  {DBGFIELD("WriteSETCCStore")    4, false, false, false, 570, 7, 24, 1,  0, 0}, // #309
  {DBGFIELD("WriteSETCC")         2, false, false, false, 550, 4, 12, 1,  0, 0}, // #310
  {DBGFIELD("WriteSHDmrcl")       6, false, false, false, 577, 13,  2, 1,  0, 0}, // #311
  {DBGFIELD("WriteSHDmri")        5, false, false, false, 590, 11,  2, 1,  0, 0}, // #312
  {DBGFIELD("WriteSHDrrcl")       3, false, false, false, 342, 9, 10, 1,  0, 0}, // #313
  {DBGFIELD("WriteFSqrt64XLd")    2, false, false, false, 173, 10, 37, 1,  0, 0}, // #314
  {DBGFIELD("WriteFSqrt64X")      1, false, false, false,  2, 8, 13, 1,  0, 0}, // #315
  {DBGFIELD("WriteFSqrtXLd")      2, false, false, false, 173, 10, 17, 1,  0, 0}, // #316
  {DBGFIELD("WriteFSqrtX")        1, false, false, false,  2, 8,  2, 1,  0, 0}, // #317
  {DBGFIELD("WriteFSqrt64Ld")     2, false, false, false, 173, 10, 18, 1,  0, 0}, // #318
  {DBGFIELD("WriteFSqrt64Ld_ReadAfterVecLd") 2, false, false, false, 173, 10, 18, 1,  5, 1}, // #319
  {DBGFIELD("WriteFSqrt64")       1, false, false, false,  2, 8, 13, 1,  0, 0}, // #320
  {DBGFIELD("WriteFSqrtLd")       2, false, false, false, 173, 10, 17, 1,  0, 0}, // #321
  {DBGFIELD("WriteFSqrtLd_ReadAfterVecLd") 2, false, false, false, 173, 10, 17, 1,  5, 1}, // #322
  {DBGFIELD("WriteFSqrt")         1, false, false, false,  2, 8,  2, 1,  0, 0}, // #323
  {DBGFIELD("WriteFSqrt80")       1, false, false, false, 601, 9, 23, 1,  0, 0}, // #324
  {DBGFIELD("WriteSTMXCSR")       4, false, false, false, 610, 11,  2, 1,  0, 0}, // #325
  {DBGFIELD("WriteTZCNTLd")       2, false, false, false, 119, 9,  7, 1,  0, 0}, // #326
  {DBGFIELD("WriteTZCNT")         1, false, false, false, 30, 7,  5, 1,  0, 0}, // #327
  {DBGFIELD("WriteFMAZLd")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #328
  {DBGFIELD("WriteFMALd")         2, false, false, false, 68, 6,  8, 1,  0, 0}, // #329
  {DBGFIELD("WriteFAdd64YLd_ReadAfterVecYLd") 2, false, false, false, 53, 7,  8, 1,  5, 1}, // #330
  {DBGFIELD("WriteFAdd64Y")       1, false, false, false, 53, 5,  5, 1,  0, 0}, // #331
  {DBGFIELD("WriteFAdd64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #332
  {DBGFIELD("WriteFAdd64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #333
  {DBGFIELD("WriteFAddYLd_ReadAfterVecYLd") 2, false, false, false, 53, 7,  8, 1,  5, 1}, // #334
  {DBGFIELD("WriteFAddY")         1, false, false, false, 53, 5,  5, 1,  0, 0}, // #335
  {DBGFIELD("WriteFAddZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #336
  {DBGFIELD("WriteFAddZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #337
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd") 2, false, false, false, 53, 7, 22, 1,  5, 1}, // #338
  {DBGFIELD("WriteShuffleY")      1, false, false, false, 53, 5,  1, 1,  0, 0}, // #339
  {DBGFIELD("WriteShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #340
  {DBGFIELD("WriteShuffleZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #341
  {DBGFIELD("WriteFLogicYLd_ReadAfterVecYLd") 2, false, false, false, 69, 5, 22, 1,  5, 1}, // #342
  {DBGFIELD("WriteFLogicY")       1, false, false, false,  4, 3,  1, 1,  0, 0}, // #343
  {DBGFIELD("WriteFLogicZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #344
  {DBGFIELD("WriteFLogicZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #345
  {DBGFIELD("WriteCvtPH2PSY")     2, false, false, false, 183, 9,  7, 1,  0, 0}, // #346
  {DBGFIELD("WriteCvtPH2PS")      2, false, false, false, 183, 9,  3, 1,  0, 0}, // #347
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterVecYLd") 4, false, false, false, 621, 5,  9, 1,  5, 1}, // #348
  {DBGFIELD("WriteFVarBlendY")    3, false, false, false, 223, 3,  5, 1,  0, 0}, // #349
  {DBGFIELD("WriteFVarBlendZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #350
  {DBGFIELD("WriteFVarBlendZ")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #351
  {DBGFIELD("WriteFBlendYLd_ReadAfterVecYLd") 2, false, false, false, 69, 5, 22, 1,  5, 1}, // #352
  {DBGFIELD("WriteFBlendY")       1, false, false, false,  4, 3,  1, 1,  0, 0}, // #353
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 4, false, false, false, 621, 5,  9, 1,  7, 2}, // #354
  {DBGFIELD("WriteFVarBlendLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 2, false, false, false, 69, 5,  7, 1,  7, 2}, // #355
  {DBGFIELD("WriteShuffle256Ld")  2, false, false, false, 375, 10,  8, 1,  0, 0}, // #356
  {DBGFIELD("WriteShuffle256")    1, false, false, false, 60, 8,  5, 1,  0, 0}, // #357
  {DBGFIELD("WriteShuffleYLd")    2, false, false, false, 53, 7, 22, 1,  0, 0}, // #358
  {DBGFIELD("WriteFShuffle256")   1, false, false, false, 60, 8,  5, 1,  0, 0}, // #359
  {DBGFIELD("WriteFShuffle256Ld") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #360
  {DBGFIELD("WriteFCmp64YLd_ReadAfterVecYLd") 2, false, false, false, 68, 6,  2, 1,  5, 1}, // #361
  {DBGFIELD("WriteFCmp64Y")       1, false, false, false,  3, 4, 14, 1,  0, 0}, // #362
  {DBGFIELD("WriteFCmpYLd_ReadAfterVecYLd") 2, false, false, false, 68, 6,  2, 1,  5, 1}, // #363
  {DBGFIELD("WriteFCmpY")         1, false, false, false,  3, 4, 14, 1,  0, 0}, // #364
  {DBGFIELD("WriteFCmpZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #365
  {DBGFIELD("WriteFCmpZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #366
  {DBGFIELD("WriteVarShuffle256Ld") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #367
  {DBGFIELD("WriteVarShuffle256") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #368
  {DBGFIELD("WriteCvtI2PDYLd")    2, false, false, false, 68, 6,  2, 1,  0, 0}, // #369
  {DBGFIELD("WriteCvtI2PDY")      2, false, false, false, 183, 9,  6, 1,  0, 0}, // #370
  {DBGFIELD("WriteCvtI2PDZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #371
  {DBGFIELD("WriteCvtI2PDZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #372
  {DBGFIELD("WriteCvtI2PSYLd")    2, false, false, false, 68, 6,  2, 1,  0, 0}, // #373
  {DBGFIELD("WriteCvtI2PSY")      1, false, false, false,  3, 4, 14, 1,  0, 0}, // #374
  {DBGFIELD("WriteCvtI2PSZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #375
  {DBGFIELD("WriteCvtI2PSZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #376
  {DBGFIELD("WriteCvtPD2PSLd_ReadAfterVecXLd") 3, false, false, false, 192, 11,  2, 1,  5, 1}, // #377
  {DBGFIELD("WriteCvtPD2PSYLd_ReadAfterVecYLd") 3, false, false, false, 192, 11, 11, 1,  5, 1}, // #378
  {DBGFIELD("WriteCvtPD2PSY")     2, false, false, false, 183, 9,  6, 1,  0, 0}, // #379
  {DBGFIELD("WriteCvtPD2PSZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #380
  {DBGFIELD("WriteCvtPD2PSZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #381
  {DBGFIELD("WriteCvtPD2PSYLd")   3, false, false, false, 192, 11, 11, 1,  0, 0}, // #382
  {DBGFIELD("WriteCvtPD2PSZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #383
  {DBGFIELD("WriteCvtPD2IYLd")    3, false, false, false, 192, 11, 11, 1,  0, 0}, // #384
  {DBGFIELD("WriteCvtPD2IY")      2, false, false, false, 183, 9,  6, 1,  0, 0}, // #385
  {DBGFIELD("WriteCvtPD2IZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #386
  {DBGFIELD("WriteCvtPD2IZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #387
  {DBGFIELD("WriteCvtPS2IYLd")    2, false, false, false, 68, 6,  2, 1,  0, 0}, // #388
  {DBGFIELD("WriteCvtPS2IY")      1, false, false, false,  3, 4, 14, 1,  0, 0}, // #389
  {DBGFIELD("WriteCvtPS2IZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #390
  {DBGFIELD("WriteCvtPS2IZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #391
  {DBGFIELD("WriteCvtPS2PDYLd")   2, false, false, false, 68, 6,  2, 1,  0, 0}, // #392
  {DBGFIELD("WriteCvtPS2PDY")     2, false, false, false, 183, 9,  6, 1,  0, 0}, // #393
  {DBGFIELD("WriteCvtPS2PDZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #394
  {DBGFIELD("WriteCvtPS2PDZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #395
  {DBGFIELD("WriteCvtPH2PSYLd")   2, false, false, false, 68, 6,  2, 1,  0, 0}, // #396
  {DBGFIELD("WriteCvtPH2PSLd")    2, false, false, false, 68, 6,  2, 1,  0, 0}, // #397
  {DBGFIELD("WriteCvtPH2PSZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #398
  {DBGFIELD("WriteCvtPH2PSZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #399
  {DBGFIELD("WriteCvtPS2PHYSt")   3, false, false, false, 626, 7,  2, 1,  0, 0}, // #400
  {DBGFIELD("WriteCvtPS2PHY")     2, false, false, false, 183, 9,  7, 1,  0, 0}, // #401
  {DBGFIELD("WriteCvtPS2PHSt")    3, false, false, false, 626, 7,  2, 1,  0, 0}, // #402
  {DBGFIELD("WriteCvtPS2PH")      2, false, false, false, 183, 9,  3, 1,  0, 0}, // #403
  {DBGFIELD("WriteCvtPS2PHZSt")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #404
  {DBGFIELD("WriteCvtPS2PHZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #405
  {DBGFIELD("WriteCvtSD2ILd_ReadAfterVecLd") 3, false, false, false, 203, 10,  2, 1,  5, 1}, // #406
  {DBGFIELD("WriteCvtSS2ILd_ReadAfterVecLd") 3, false, false, false, 203, 10,  2, 1,  5, 1}, // #407
  {DBGFIELD("WritePSADBWYLd_ReadAfterVecYLd") 2, false, false, false, 375, 10,  8, 1,  5, 1}, // #408
  {DBGFIELD("WritePSADBWY")       1, false, false, false, 60, 8,  5, 1,  0, 0}, // #409
  {DBGFIELD("WritePSADBWZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #410
  {DBGFIELD("WritePSADBWZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #411
  {DBGFIELD("WriteFDiv64YLd_ReadAfterVecYLd") 2, false, false, false, 173, 10, 23, 1,  5, 1}, // #412
  {DBGFIELD("WriteFDiv64Y")       1, false, false, false,  2, 8, 21, 1,  0, 0}, // #413
  {DBGFIELD("WriteFDiv64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #414
  {DBGFIELD("WriteFDiv64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #415
  {DBGFIELD("WriteFDivYLd_ReadAfterVecYLd") 2, false, false, false, 173, 10, 17, 1,  5, 1}, // #416
  {DBGFIELD("WriteFDivY")         1, false, false, false,  2, 8,  8, 1,  0, 0}, // #417
  {DBGFIELD("WriteFDivZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #418
  {DBGFIELD("WriteFDivZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #419
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd") 2, false, false, false, 68, 6,  8, 1,  5, 1}, // #420
  {DBGFIELD("WriteFMAX")          1, false, false, false,  3, 4, 14, 1,  0, 0}, // #421
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd") 2, false, false, false, 68, 6,  2, 1,  5, 1}, // #422
  {DBGFIELD("WriteFMAY")          1, false, false, false,  3, 4, 14, 1,  0, 0}, // #423
  {DBGFIELD("WriteFMAZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #424
  {DBGFIELD("WriteFMAZ")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #425
  {DBGFIELD("WriteDPPSYLd_ReadAfterVecYLd") 7, false, false, false, 239, 12, 19, 1,  5, 1}, // #426
  {DBGFIELD("WriteDPPSY")         6, false, false, false, 251, 10, 21, 1,  0, 0}, // #427
  {DBGFIELD("WriteVarShuffle256Ld_ReadAfterVecYLd") 2, false, false, false, 375, 10,  8, 1,  5, 1}, // #428
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd_ReadAfterVecYLd") 2, false, false, false, 68, 6,  2, 1,  9, 2}, // #429
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd_ReadAfterVecXLd") 2, false, false, false, 68, 6,  8, 1,  9, 2}, // #430
  {DBGFIELD("WriteFMALd_ReadAfterVecLd") 2, false, false, false, 68, 6,  8, 1,  5, 1}, // #431
  {DBGFIELD("WriteFMA")           1, false, false, false,  3, 4, 14, 1,  0, 0}, // #432
  {DBGFIELD("WriteFMALd_ReadAfterVecLd_ReadAfterVecLd") 2, false, false, false, 68, 6,  8, 1,  9, 2}, // #433
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 2, false, false, false, 68, 6,  2, 1,  7, 2}, // #434
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 2, false, false, false, 68, 6,  8, 1,  7, 2}, // #435
  {DBGFIELD("WriteFMALd_ReadAfterVecLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecLd") 2, false, false, false, 68, 6,  8, 1,  7, 2}, // #436
  {DBGFIELD("WriteFRndYLd_ReadAfterVecYLd") 3, false, false, false, 74, 6, 16, 1,  5, 1}, // #437
  {DBGFIELD("WriteFRndY")         2, false, false, false, 74, 4,  7, 1,  0, 0}, // #438
  {DBGFIELD("WriteLoad_WriteVecMaskedGatherWriteback") 1, false, false, false, 28, 2, 38, 2,  0, 0}, // #439
  {DBGFIELD("WriteFRndZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #440
  {DBGFIELD("WriteFRndZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #441
  {DBGFIELD("WriteVecIMulYLd_ReadAfterVecYLd") 2, false, false, false, 68, 6, 24, 1,  5, 1}, // #442
  {DBGFIELD("WriteVecIMulY")      1, false, false, false,  3, 4, 10, 1,  0, 0}, // #443
  {DBGFIELD("WriteVecIMulZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #444
  {DBGFIELD("WriteVecIMulZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #445
  {DBGFIELD("WriteVecALUYLd_ReadAfterVecYLd") 2, false, false, false, 68, 6, 22, 1,  5, 1}, // #446
  {DBGFIELD("WriteVecALUY")       1, false, false, false,  3, 4,  1, 1,  0, 0}, // #447
  {DBGFIELD("WriteVecALUZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #448
  {DBGFIELD("WriteVecALUZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #449
  {DBGFIELD("WriteFHAddYLd_ReadAfterVecYLd") 4, false, false, false, 304, 10, 24, 1,  5, 1}, // #450
  {DBGFIELD("WriteFHAddY")        3, false, false, false, 314, 8, 10, 1,  0, 0}, // #451
  {DBGFIELD("WriteFShuffle256Ld_ReadAfterVecYLd") 2, false, false, false, 375, 10,  8, 1,  5, 1}, // #452
  {DBGFIELD("WriteShuffle256Ld_ReadAfterVecYLd") 2, false, false, false, 375, 10,  8, 1,  5, 1}, // #453
  {DBGFIELD("WriteVecLoadY")      1, false, false, false, 28, 2,  7, 1,  0, 0}, // #454
  {DBGFIELD("WriteFMaskedStore64Y") 3, false, false, false, 633, 11, 21, 1,  0, 0}, // #455
  {DBGFIELD("WriteFMaskedLoadY")  2, false, false, false, 69, 5, 22, 1,  0, 0}, // #456
  {DBGFIELD("WriteFMaskedStore64") 3, false, false, false, 633, 11, 21, 1,  0, 0}, // #457
  {DBGFIELD("WriteFMaskedLoad")   2, false, false, false, 69, 5,  7, 1,  0, 0}, // #458
  {DBGFIELD("WriteFMaskedStore32Y") 3, false, false, false, 633, 11, 21, 1,  0, 0}, // #459
  {DBGFIELD("WriteFMaskedStore32") 3, false, false, false, 633, 11, 21, 1,  0, 0}, // #460
  {DBGFIELD("WriteFCmp64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #461
  {DBGFIELD("WriteFCmp64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #462
  {DBGFIELD("WriteFMoveY")        0, false, false, false,  0, 0,  1, 1,  0, 0}, // #463
  {DBGFIELD("WriteFMoveZ")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #464
  {DBGFIELD("WriteFShuffleYLd")   2, false, false, false, 375, 10, 22, 1,  0, 0}, // #465
  {DBGFIELD("WriteFShuffleY")     1, false, false, false, 60, 8,  1, 1,  0, 0}, // #466
  {DBGFIELD("WriteFShuffleZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #467
  {DBGFIELD("WriteFShuffleZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #468
  {DBGFIELD("WriteVecStoreY")     2, false, false, false, 37, 3,  2, 1,  0, 0}, // #469
  {DBGFIELD("WriteVecMoveY")      0, false, false, false,  0, 0,  1, 1,  0, 0}, // #470
  {DBGFIELD("WriteVecMoveZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #471
  {DBGFIELD("WriteVecLoadNTY")    1, false, false, false, 28, 2,  7, 1,  0, 0}, // #472
  {DBGFIELD("WriteVecStoreNTY")   2, false, false, false, 37, 3, 40, 1,  0, 0}, // #473
  {DBGFIELD("WriteFStoreNTY")     2, false, false, false, 37, 3, 41, 1,  0, 0}, // #474
  {DBGFIELD("WriteMPSADYLd_ReadAfterVecYLd") 3, false, false, false, 452, 10,  2, 1,  5, 1}, // #475
  {DBGFIELD("WriteMPSADY")        2, false, false, false, 420, 8, 14, 1,  0, 0}, // #476
  {DBGFIELD("WriteFMul64YLd_ReadAfterVecYLd") 2, false, false, false, 68, 6,  2, 1,  5, 1}, // #477
  {DBGFIELD("WriteFMul64Y")       1, false, false, false,  3, 4, 14, 1,  0, 0}, // #478
  {DBGFIELD("WriteFMul64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #479
  {DBGFIELD("WriteFMul64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #480
  {DBGFIELD("WriteFMulYLd_ReadAfterVecYLd") 2, false, false, false, 68, 6,  2, 1,  5, 1}, // #481
  {DBGFIELD("WriteFMulY")         1, false, false, false,  3, 4, 14, 1,  0, 0}, // #482
  {DBGFIELD("WriteFMulZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #483
  {DBGFIELD("WriteFMulZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #484
  {DBGFIELD("WriteVecALUYLd")     2, false, false, false, 68, 6, 22, 1,  0, 0}, // #485
  {DBGFIELD("WriteVecALUZLd")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #486
  {DBGFIELD("WriteVecLogicYLd_ReadAfterVecYLd") 2, false, false, false, 69, 5, 22, 1,  5, 1}, // #487
  {DBGFIELD("WriteVecLogicY")     1, false, false, false,  4, 3,  1, 1,  0, 0}, // #488
  {DBGFIELD("WriteVecLogicZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #489
  {DBGFIELD("WriteVecLogicZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #490
  {DBGFIELD("WriteBlendYLd_ReadAfterVecYLd") 2, false, false, false, 69, 5, 22, 1,  5, 1}, // #491
  {DBGFIELD("WriteBlendY")        1, false, false, false,  4, 3,  1, 1,  0, 0}, // #492
  {DBGFIELD("WriteVarBlendYLd_ReadAfterVecYLd") 4, false, false, false, 621, 5,  9, 1,  5, 1}, // #493
  {DBGFIELD("WriteVarBlendY")     3, false, false, false, 223, 3,  5, 1,  0, 0}, // #494
  {DBGFIELD("WriteVarBlendZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #495
  {DBGFIELD("WriteVarBlendZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #496
  {DBGFIELD("WriteVarBlendYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 4, false, false, false, 621, 5,  9, 1,  7, 2}, // #497
  {DBGFIELD("WriteVarBlendLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 2, false, false, false, 69, 5,  7, 1,  7, 2}, // #498
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 2, false, false, false, 53, 7, 22, 1,  7, 2}, // #499
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd_ReadAfterVecYLd") 2, false, false, false, 53, 7, 22, 1,  9, 2}, // #500
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 2, false, false, false, 53, 7,  7, 1,  7, 2}, // #501
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd_ReadAfterVecXLd") 2, false, false, false, 53, 7,  7, 1,  9, 2}, // #502
  {DBGFIELD("WriteFVarShuffle256Ld_ReadAfterVecYLd") 2, false, false, false, 375, 10,  8, 1,  5, 1}, // #503
  {DBGFIELD("WriteFVarShuffle256") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #504
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 2, false, false, false, 375, 10, 22, 1,  7, 2}, // #505
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd_ReadAfterVecYLd") 2, false, false, false, 375, 10, 22, 1,  9, 2}, // #506
  {DBGFIELD("WriteFVarShuffleY")  1, false, false, false, 60, 8,  1, 1,  0, 0}, // #507
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 2, false, false, false, 375, 10,  7, 1,  7, 2}, // #508
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd_ReadAfterVecXLd") 2, false, false, false, 375, 10,  7, 1,  9, 2}, // #509
  {DBGFIELD("WriteFVarShuffle")   1, false, false, false, 60, 8,  1, 1,  0, 0}, // #510
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd") 2, false, false, false, 375, 10, 22, 1,  5, 1}, // #511
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd") 2, false, false, false, 375, 10,  7, 1,  5, 1}, // #512
  {DBGFIELD("WriteFVarShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #513
  {DBGFIELD("WriteFVarShuffleZ")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #514
  {DBGFIELD("WritePHAddYLd_ReadAfterVecYLd") 4, false, false, false, 524, 7,  9, 1,  5, 1}, // #515
  {DBGFIELD("WritePHAddY")        3, false, false, false, 524, 5, 12, 1,  0, 0}, // #516
  {DBGFIELD("WriteVecInsert")     2, false, false, false, 420, 8, 14, 1,  0, 0}, // #517
  {DBGFIELD("WriteVecIMulXLd")    2, false, false, false, 68, 6, 24, 1,  0, 0}, // #518
  {DBGFIELD("WriteVecIMulYLd")    2, false, false, false, 68, 6, 24, 1,  0, 0}, // #519
  {DBGFIELD("WriteVecIMulZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #520
  {DBGFIELD("WriteVecMaskedStore32Y") 3, false, false, false, 633, 11, 21, 1,  0, 0}, // #521
  {DBGFIELD("WriteVecMaskedLoadY") 2, false, false, false, 69, 5, 22, 1,  0, 0}, // #522
  {DBGFIELD("WriteVecMaskedStore32") 3, false, false, false, 633, 11, 21, 1,  0, 0}, // #523
  {DBGFIELD("WriteVecMaskedLoad") 2, false, false, false, 69, 5,  7, 1,  0, 0}, // #524
  {DBGFIELD("WriteVecMaskedStore64Y") 3, false, false, false, 633, 11, 21, 1,  0, 0}, // #525
  {DBGFIELD("WriteVecMaskedStore64") 3, false, false, false, 633, 11, 21, 1,  0, 0}, // #526
  {DBGFIELD("WriteVPMOV256Ld")    2, false, false, false, 375, 10,  8, 1,  0, 0}, // #527
  {DBGFIELD("WriteVPMOV256")      1, false, false, false, 60, 8,  5, 1,  0, 0}, // #528
  {DBGFIELD("WriteVecMOVMSKY")    1, false, false, false,  2, 8, 14, 1,  0, 0}, // #529
  {DBGFIELD("WritePMULLDYLd_ReadAfterVecYLd") 3, false, false, false, 74, 6, 13, 1,  5, 1}, // #530
  {DBGFIELD("WritePMULLDY")       2, false, false, false, 74, 4,  9, 1,  0, 0}, // #531
  {DBGFIELD("WritePMULLDZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #532
  {DBGFIELD("WritePMULLDZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #533
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 2, false, false, false, 53, 7,  7, 1,  7, 2}, // #534
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd_ReadAfterVecXLd") 2, false, false, false, 53, 7,  7, 1,  9, 2}, // #535
  {DBGFIELD("WriteVecShiftImmXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #536
  {DBGFIELD("WriteVecShiftImmYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #537
  {DBGFIELD("WriteVecShiftImmY")  1, false, false, false,  3, 4,  1, 1,  0, 0}, // #538
  {DBGFIELD("WriteVecShiftImmZLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #539
  {DBGFIELD("WriteVecShiftImmZ")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #540
  {DBGFIELD("WriteVarVecShiftLd_ReadAfterVecXLd") 2, false, false, false, 68, 6,  7, 1,  5, 1}, // #541
  {DBGFIELD("WriteVarVecShift")   1, false, false, false,  3, 4,  1, 1,  0, 0}, // #542
  {DBGFIELD("WriteVarVecShiftYLd_ReadAfterVecYLd") 2, false, false, false, 68, 6, 22, 1,  5, 1}, // #543
  {DBGFIELD("WriteVarVecShiftY")  1, false, false, false,  3, 4,  1, 1,  0, 0}, // #544
  {DBGFIELD("WriteVarVecShiftZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #545
  {DBGFIELD("WriteVarVecShiftZ")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #546
  {DBGFIELD("WriteVecShiftImmXLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #547
  {DBGFIELD("WriteVarShuffleYLd_ReadAfterVecYLd") 2, false, false, false, 53, 7, 22, 1,  5, 1}, // #548
  {DBGFIELD("WriteVarShuffleY")   1, false, false, false, 53, 5,  1, 1,  0, 0}, // #549
  {DBGFIELD("WriteVarShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #550
  {DBGFIELD("WriteVarShuffleZ")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #551
  {DBGFIELD("WriteShuffleZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #552
  {DBGFIELD("WriteVecShiftYLd_ReadAfterVecYLd") 2, false, false, false, 68, 6, 22, 1,  5, 1}, // #553
  {DBGFIELD("WriteVecShiftY")     2, false, false, false, 183, 9, 14, 1,  0, 0}, // #554
  {DBGFIELD("WriteVecShiftZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #555
  {DBGFIELD("WriteVecShiftZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #556
  {DBGFIELD("WriteVecTestYLd_ReadAfterVecYLd") 3, false, false, false, 428, 13,  2, 1,  5, 1}, // #557
  {DBGFIELD("WriteVecTestY")      2, false, false, false, 441, 11,  3, 1,  0, 0}, // #558
  {DBGFIELD("WriteFRcpXLd_ReadAfterVecXLd") 2, false, false, false, 173, 10,  8, 1,  5, 1}, // #559
  {DBGFIELD("WriteFRcpYLd_ReadAfterVecYLd") 2, false, false, false, 173, 10,  2, 1,  5, 1}, // #560
  {DBGFIELD("WriteFRcpY")         1, false, false, false,  2, 8, 14, 1,  0, 0}, // #561
  {DBGFIELD("WriteFRcpZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #562
  {DBGFIELD("WriteFRcpZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #563
  {DBGFIELD("WriteFRcpYLd")       2, false, false, false, 173, 10,  2, 1,  0, 0}, // #564
  {DBGFIELD("WriteFRndYLd")       3, false, false, false, 74, 6, 16, 1,  0, 0}, // #565
  {DBGFIELD("WriteFRsqrtXLd_ReadAfterVecXLd") 2, false, false, false, 173, 10,  8, 1,  5, 1}, // #566
  {DBGFIELD("WriteFRsqrtYLd_ReadAfterVecYLd") 2, false, false, false, 173, 10,  2, 1,  5, 1}, // #567
  {DBGFIELD("WriteFRsqrtY")       1, false, false, false,  2, 8, 14, 1,  0, 0}, // #568
  {DBGFIELD("WriteFRsqrtZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #569
  {DBGFIELD("WriteFRsqrtZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #570
  {DBGFIELD("WriteFRsqrtYLd")     2, false, false, false, 173, 10,  2, 1,  0, 0}, // #571
  {DBGFIELD("WriteFShuffleYLd_ReadAfterVecYLd") 2, false, false, false, 375, 10, 22, 1,  5, 1}, // #572
  {DBGFIELD("WriteFShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #573
  {DBGFIELD("WriteFSqrt64YLd")    2, false, false, false, 173, 10, 42, 1,  0, 0}, // #574
  {DBGFIELD("WriteFSqrt64Y")      1, false, false, false,  2, 8, 13, 1,  0, 0}, // #575
  {DBGFIELD("WriteFSqrt64XLd_ReadAfterVecXLd") 2, false, false, false, 173, 10, 37, 1,  5, 1}, // #576
  {DBGFIELD("WriteFSqrt64YLd_ReadAfterVecYLd") 2, false, false, false, 173, 10, 42, 1,  5, 1}, // #577
  {DBGFIELD("WriteFSqrt64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #578
  {DBGFIELD("WriteFSqrt64Z")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #579
  {DBGFIELD("WriteFSqrtXLd_ReadAfterVecXLd") 2, false, false, false, 173, 10, 17, 1,  5, 1}, // #580
  {DBGFIELD("WriteFSqrtYLd_ReadAfterVecYLd") 2, false, false, false, 173, 10, 15, 1,  5, 1}, // #581
  {DBGFIELD("WriteFSqrtY")        1, false, false, false,  2, 8,  2, 1,  0, 0}, // #582
  {DBGFIELD("WriteFSqrtZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #583
  {DBGFIELD("WriteFSqrtZ")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #584
  {DBGFIELD("WriteFSqrtYLd")      2, false, false, false, 173, 10, 15, 1,  0, 0}, // #585
  {DBGFIELD("WriteFTestYLd_ReadAfterVecYLd") 2, false, false, false, 173, 10,  8, 1,  5, 1}, // #586
  {DBGFIELD("WriteFTestY")        1, false, false, false,  2, 8, 10, 1,  0, 0}, // #587
  {DBGFIELD("WriteFTestLd_ReadAfterVecXLd") 2, false, false, false, 173, 10,  7, 1,  5, 1}, // #588
  {DBGFIELD("WriteFTest")         1, false, false, false,  2, 8,  5, 1,  0, 0}, // #589
  {DBGFIELD("WriteALULd_WriteRMW") 4, false, false, false, 40, 5, 43, 2,  0, 0}, // #590
  {DBGFIELD("COPY")               8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #591
  {DBGFIELD("XAM_F")              1, false, false, false,  2, 8, 12, 1,  0, 0}, // #592
  {DBGFIELD("LD_Frr")             1, false, false, false,  5, 2,  1, 1,  0, 0}, // #593
  {DBGFIELD("MOVSX64rr32")        1, false, false, false, 115, 2,  1, 1,  0, 0}, // #594
  {DBGFIELD("RCL16m1_RCL16mi_RCL32m1_RCL32mi_RCL64m1_RCL64mi_RCL8m1_RCL8mi_RCR16m1_RCR16mi_RCR32m1_RCR32mi_RCR64m1_RCR64mi_RCR8m1_RCR8mi_ROL16m1_ROL16mi_ROL32m1_ROL32mi_ROL64m1_ROL64mi_ROL8m1_ROL8mi_ROR16m1_ROR16mi_ROR32m1_ROR32mi_ROR64m1_ROR64mi_ROR8m1_ROR8mi") 6, false, false, false, 14, 8, 33, 2,  0, 0}, // #595
  {DBGFIELD("RCL16mCL_RCL32mCL_RCL64mCL_RCL8mCL_RCR16mCL_RCR32mCL_RCR64mCL_RCR8mCL_ROL16mCL_ROL32mCL_ROL64mCL_ROL8mCL_ROR16mCL_ROR32mCL_ROR64mCL_ROR8mCL") 10, false, false, false, 537, 13, 35, 2,  0, 0}, // #596
  {DBGFIELD("SAR16m1_SAR16mi_SAR32m1_SAR32mi_SAR64m1_SAR64mi_SAR8m1_SAR8mi_SHL16m1_SHL16mi_SHL32m1_SHL32mi_SHL64m1_SHL64mi_SHL8m1_SHL8mi_SHR16m1_SHR16mi_SHR32m1_SHR32mi_SHR64m1_SHR64mi_SHR8m1_SHR8mi") 4, false, false, false, 554, 8, 33, 2,  0, 0}, // #597
  {DBGFIELD("SAR16mCL_SAR32mCL_SAR64mCL_SAR8mCL_SHL16mCL_SHL32mCL_SHL64mCL_SHL8mCL_SHR16mCL_SHR32mCL_SHR64mCL_SHR8mCL") 5, false, false, false, 562, 8, 33, 2,  0, 0}, // #598
  {DBGFIELD("MOVSX32rr16_MOVSX32rr8_MOVSX32rr8_NOREX_MOVSX64rr16_MOVSX64rr8_MOVZX32rr16_MOVZX32rr8_MOVZX32rr8_NOREX_MOVZX64rr16_MOVZX64rr8") 1, false, false, false,  1, 1,  1, 1,  0, 0}, // #599
  {DBGFIELD("FCOMPP")             1, false, false, false,  5, 2,  4, 1,  0, 0}, // #600
  {DBGFIELD("UCOM_FPPr_UCOM_FPr_UCOM_Fr") 1, false, false, false,  2, 8, 12, 1,  0, 0}, // #601
  {DBGFIELD("MMX_CVTPI2PSrr")     2, false, false, false, 203, 8,  6, 1,  0, 0}, // #602
  {DBGFIELD("MMX_CVTPI2PSrm")     2, false, false, false, 68, 6,  8, 1,  0, 0}, // #603
  {DBGFIELD("MMX_CVTPS2PIrr_MMX_CVTTPS2PIrr") 2, false, false, false, 269, 8, 22, 1,  0, 0}, // #604
  {DBGFIELD("POP32r_POP64r_POP16rmr_POP32rmr_POP64rmr") 1, false, false, false, 28, 2, 10, 1,  0, 0}, // #605
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r_PUSHi16_PUSHi32_PUSH16rmr_PUSH32rmr_PUSH64rmr_PUSH16i8_PUSH32i8_PUSH64i8_PUSH64i32") 2, false, false, false, 37, 3,  2, 1,  0, 0}, // #606
  {DBGFIELD("XCH_F")              15, false, false, false, 644, 13, 20, 1,  0, 0}, // #607
  {DBGFIELD("RETI16_RETI32_RETI64_IRET_IRET16_IRET32_IRET64") 2, false, false, false, 22, 8,  3, 1,  0, 0}, // #608
  {DBGFIELD("MMX_CVTPS2PIrm_MMX_CVTTPS2PIrm") 2, false, false, false, 173, 10, 24, 1,  0, 0}, // #609
  {DBGFIELD("ILD_F16m_ILD_F32m_ILD_F64m") 2, false, false, false, 279, 12,  9, 1,  0, 0}, // #610
  {DBGFIELD("CVTSI642SDrm")       2, false, false, false, 68, 6,  8, 1,  0, 0}, // #611
  {DBGFIELD("CVTSI642SDrm_Int")   2, false, false, false, 68, 6,  8, 1,  5, 1}, // #612
  {DBGFIELD("CVTSI642SSrr")       3, false, false, false, 657, 9,  7, 1,  0, 1}, // #613
  {DBGFIELD("CVTSI642SSrr_Int")   3, false, false, false, 657, 9,  7, 1,  6, 1}, // #614
  {DBGFIELD("CVTSI642SSrm")       3, false, false, false, 192, 11,  2, 1,  0, 0}, // #615
  {DBGFIELD("CVTSI642SSrm_Int")   3, false, false, false, 192, 11,  2, 1,  5, 1}, // #616
  {DBGFIELD("CVTSS2SI64rr_CVTTSS2SI64rr") 3, false, false, false, 666, 11,  7, 1,  0, 0}, // #617
  {DBGFIELD("CVTSS2SI64rr_Int_CVTTSS2SI64rr_Int") 3, false, false, false, 666, 11,  7, 1,  0, 0}, // #618
  {DBGFIELD("CVTSS2SI64rm_CVTSS2SI64rm_Int_CVTTSS2SI64rm_CVTTSS2SI64rm_Int") 3, false, false, false, 203, 10,  2, 1,  0, 0}, // #619
  {DBGFIELD("FDECSTP_FFREE_FFREEP_FINCSTP_WAIT_STOSB_STOSL_STOSQ_STOSW") 2, false, false, false, 76, 2, 12, 1,  0, 0}, // #620
  {DBGFIELD("LFENCE")             1, false, false, false, 10, 4, 12, 1,  0, 0}, // #621
  {DBGFIELD("MOVSSrr_MOVSSrr_REV") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #622
  {DBGFIELD("LEAVE_LEAVE64")      3, false, false, false, 77, 3,  3, 1,  0, 0}, // #623
  {DBGFIELD("POP16r")             2, false, false, false, 71, 3,  3, 1,  0, 0}, // #624
  {DBGFIELD("PUSH16rmm_PUSH32rmm_PUSH64rmm") 3, false, false, false, 18, 4,  1, 1,  0, 0}, // #625
  {DBGFIELD("LODSB_LODSL_LODSQ_LODSW_SCASB_SCASL_SCASQ_SCASW") 4, false, false, false, 623, 3,  3, 1,  0, 0}, // #626
  {DBGFIELD("PUSHCS16_PUSHCS32_PUSHDS16_PUSHDS32_PUSHES16_PUSHES32_PUSHFS16_PUSHFS32_PUSHFS64_PUSHGS16_PUSHGS32_PUSHGS64_PUSHSS16_PUSHSS32") 1, false, false, false,  5, 2,  4, 1,  0, 0}, // #627
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m_ST_F32m_ST_F64m_ST_FP32m_ST_FP64m") 1, false, false, false, 677, 4,  1, 1,  0, 0}, // #628
  {DBGFIELD("ST_FPrr_ST_Frr")     1, false, false, false,  5, 2,  1, 1,  0, 0}, // #629
  {DBGFIELD("MMX_PADDQrr_MMX_PSUBQrr") 1, false, false, false,  4, 5,  1, 1,  0, 0}, // #630
  {DBGFIELD("MOVSX16rr8_MOVZX16rr8") 1, false, false, false,  1, 1,  1, 1,  0, 0}, // #631
  {DBGFIELD("MOVDQUmr_MASKMOVDQU_MASKMOVDQU64") 2, false, false, false, 37, 3,  2, 1,  0, 0}, // #632
  {DBGFIELD("MOVUPDmr_MOVUPSmr")  2, false, false, false, 37, 3,  2, 1,  0, 0}, // #633
  {DBGFIELD("PADDQrr_PSUBQrr")    1, false, false, false,  4, 3,  1, 1,  0, 0}, // #634
  {DBGFIELD("CLD")                2, false, false, false, 45, 4,  5, 1,  0, 0}, // #635
  {DBGFIELD("LDDQUrm")            1, false, false, false, 28, 2,  6, 1,  0, 0}, // #636
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW_MOVSB_MOVSL_MOVSQ_MOVSW") 7, false, false, false, 681, 5,  6, 1,  0, 0}, // #637
  {DBGFIELD("POP16rmm_POP32rmm_POP64rmm") 3, false, false, false, 18, 4,  2, 1,  0, 0}, // #638
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm_XCHG16rm_XCHG32rm_XCHG64rm_XCHG8rm") 9, false, false, false, 686, 8, 45, 2,  0, 0}, // #639
  {DBGFIELD("PHADDDrr_PHSUBDrr")  3, false, false, false, 524, 5, 12, 1,  0, 0}, // #640
  {DBGFIELD("MOVSX16rm8_MOVZX16rm8") 2, false, false, false, 115, 4,  3, 1,  0, 0}, // #641
  {DBGFIELD("MMX_PADDQrm_MMX_PSUBQrm") 2, false, false, false, 395, 7, 22, 1,  5, 1}, // #642
  {DBGFIELD("MOVDQUrm")           1, false, false, false, 28, 2,  6, 1,  0, 0}, // #643
  {DBGFIELD("MOVUPDrm_MOVUPSrm")  1, false, false, false, 28, 2,  6, 1,  0, 0}, // #644
  {DBGFIELD("PADDQrm_PSUBQrm")    2, false, false, false, 69, 5,  7, 1,  5, 1}, // #645
  {DBGFIELD("CBW_CWD_CWDE_CDQ_CDQE_CQO") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #646
  {DBGFIELD("JCXZ_JECXZ_JRCXZ")   2, false, false, false, 106, 4, 12, 1,  0, 0}, // #647
  {DBGFIELD("LD_F80m")            1, false, false, false, 26, 4,  6, 1,  0, 0}, // #648
  {DBGFIELD("PHADDDrm_PHSUBDrm")  4, false, false, false, 524, 7, 22, 1,  5, 1}, // #649
  {DBGFIELD("MMX_PEXTRWrr_PEXTRWrr_PEXTRWrr_REV") 2, false, false, false, 269, 10, 14, 1,  0, 0}, // #650
  {DBGFIELD("FLDCW16m")           3, false, false, false, 694, 12,  6, 1,  0, 0}, // #651
  {DBGFIELD("ST_FP80m")           2, false, false, false, 677, 4,  1, 1,  0, 0}, // #652
  {DBGFIELD("MMX_PHADDSWrr_MMX_PHADDWrr_MMX_PHSUBSWrr_MMX_PHSUBWrr") 3, false, false, false, 412, 8,  5, 1,  0, 0}, // #653
  {DBGFIELD("CMPXCHG8rm")         6, false, false, false, 14, 8, 24, 1,  0, 0}, // #654
  {DBGFIELD("INTO")               1, false, false, false,  5, 2,  4, 1,  0, 0}, // #655
  {DBGFIELD("XLAT")               3, false, false, false, 77, 3,  6, 1,  0, 0}, // #656
  {DBGFIELD("SHLD16rrCL_SHRD16rrCL") 3, false, false, false, 342, 9, 10, 1,  0, 0}, // #657
  {DBGFIELD("SHLD16rri8_SHRD16rri8") 1, false, false, false, 30, 7,  5, 1,  0, 0}, // #658
  {DBGFIELD("SHLD16mrCL_SHRD16mrCL") 6, false, false, false, 577, 13,  2, 1,  0, 0}, // #659
  {DBGFIELD("SHLD16mri8_SHRD16mri8") 5, false, false, false, 590, 11,  2, 1,  0, 0}, // #660
  {DBGFIELD("IST_F16m_IST_F32m_IST_FP16m_IST_FP32m_IST_FP64m") 3, false, false, false, 706, 12, 14, 1,  0, 0}, // #661
  {DBGFIELD("MMX_PHADDSWrm_MMX_PHADDWrm_MMX_PHSUBSWrm_MMX_PHSUBWrm") 4, false, false, false, 402, 10,  8, 1,  5, 1}, // #662
  {DBGFIELD("AAD8i8")             1, false, false, false,  5, 2,  4, 1,  0, 0}, // #663
  {DBGFIELD("LOOPE")              11, false, false, false, 718, 9,  5, 1,  0, 0}, // #664
  {DBGFIELD("PUSHA16_PUSHA32")    1, false, false, false, 677, 4,  1, 1,  0, 0}, // #665
  {DBGFIELD("SHLD64rrCL_SHRD64rrCL") 3, false, false, false, 342, 9, 10, 1,  0, 0}, // #666
  {DBGFIELD("FNSTCW16m")          3, false, false, false, 727, 9, 12, 1,  0, 0}, // #667
  {DBGFIELD("POPA16_POPA32")      1, false, false, false, 26, 4, 10, 1,  0, 0}, // #668
  {DBGFIELD("PUSHF16_PUSHF32_PUSHF64") 1, false, false, false, 677, 4,  1, 1,  0, 0}, // #669
  {DBGFIELD("SHLD64mrCL_SHRD64mrCL") 6, false, false, false, 577, 13,  2, 1,  0, 0}, // #670
  {DBGFIELD("SHLD64mri8_SHRD64mri8") 5, false, false, false, 590, 11,  2, 1,  0, 0}, // #671
  {DBGFIELD("SHLD64rri8_SHRD64rri8") 1, false, false, false, 30, 7,  5, 1,  0, 0}, // #672
  {DBGFIELD("CMPXCHG8rr")         5, false, false, false, 169, 4,  5, 1,  0, 0}, // #673
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr_TST_F_TST_Fp32_TST_Fp64_TST_Fp80") 1, false, false, false, 60, 8,  1, 1,  0, 0}, // #674
  {DBGFIELD("BOUNDS16rm_BOUNDS32rm") 1, false, false, false,  5, 2,  4, 1,  0, 0}, // #675
  {DBGFIELD("AAA_AAS")            1, false, false, false,  5, 2,  4, 1,  0, 0}, // #676
  {DBGFIELD("CMPXCHG16rm_CMPXCHG32rm_CMPXCHG64rm") 6, false, false, false, 14, 8,  2, 1,  0, 0}, // #677
  {DBGFIELD("LOOPNE")             11, false, false, false, 718, 9, 12, 1,  0, 0}, // #678
  {DBGFIELD("PAUSE")              2, false, false, false, 736, 9, 14, 1,  0, 0}, // #679
  {DBGFIELD("CMPXCHG8B")          16, false, false, false, 745, 13, 42, 1,  0, 0}, // #680
  {DBGFIELD("DAA")                1, false, false, false,  5, 2,  4, 1,  0, 0}, // #681
  {DBGFIELD("LOOP")               7, false, false, false, 758, 9,  5, 1,  0, 0}, // #682
  {DBGFIELD("DAS")                1, false, false, false,  5, 2,  4, 1,  0, 0}, // #683
  {DBGFIELD("AAM8i8")             1, false, false, false,  5, 2,  4, 1,  0, 0}, // #684
  {DBGFIELD("STD")                2, false, false, false, 45, 4,  3, 1,  0, 0}, // #685
  {DBGFIELD("CMPXCHG16B")         22, false, false, false, 767, 15, 47, 1,  0, 0}, // #686
  {DBGFIELD("ARPL16mr_ARPL16rr")  1, false, false, false,  5, 2,  4, 1,  0, 0}, // #687
  {DBGFIELD("FNCLEX_FXTRACT")     4, false, false, false, 782, 2, 14, 1,  0, 0}, // #688
  {DBGFIELD("POPF32_POPF64")      1, false, false, false, 26, 4, 10, 1,  0, 0}, // #689
  {DBGFIELD("POPDS16_POPDS32_POPES16_POPES32_POPFS16_POPFS32_POPFS64_POPGS16_POPGS32_POPGS64") 1, false, false, false,  5, 2,  4, 1,  0, 0}, // #690
  {DBGFIELD("RDTSC_RDTSCP")       21, false, false, false, 784, 12, 48, 1,  0, 0}, // #691
  {DBGFIELD("ENTER")              57, false, false, false, 796, 16, 49, 1,  0, 0}, // #692
  {DBGFIELD("POPF16")             10, false, false, false, 812, 11, 10, 1,  0, 0}, // #693
  {DBGFIELD("MONITOR32rrr_MONITOR64rrr") 1, false, false, false,  5, 2,  4, 1,  0, 0}, // #694
  {DBGFIELD("FRNDINT")            1, false, false, false,  5, 2,  4, 1,  0, 0}, // #695
  {DBGFIELD("MWAITrr_RDPMC")      10, false, false, false, 823, 10, 15, 1,  0, 0}, // #696
  {DBGFIELD("POPSS16_POPSS32")    1, false, false, false,  5, 2,  4, 1,  0, 0}, // #697
  {DBGFIELD("FPREM")              1, false, false, false,  5, 2,  4, 1,  0, 0}, // #698
  {DBGFIELD("INSB_INSL_INSW")     86, false, false, false, 833, 16, 15, 1,  0, 0}, // #699
  {DBGFIELD("FNINIT")             15, false, false, false, 849, 8, 50, 1,  0, 0}, // #700
  {DBGFIELD("OUT8rr_OUT16rr_OUT32rr") 73, false, false, false, 857, 16, 51, 1,  0, 0}, // #701
  {DBGFIELD("FPREM1")             1, false, false, false,  5, 2,  4, 1,  0, 0}, // #702
  {DBGFIELD("INVLPG_INVLPGA32_INVLPGA64") 1, false, false, false,  5, 2,  4, 1,  0, 0}, // #703
  {DBGFIELD("OUT8ir_OUT16ir_OUT32ir") 73, false, false, false, 873, 16, 51, 1,  0, 0}, // #704
  {DBGFIELD("OUTSB_OUTSL_OUTSW")  83, false, false, false, 889, 16,  4, 1,  0, 0}, // #705
  {DBGFIELD("FSCALE")             1, false, false, false,  5, 2,  4, 1,  0, 0}, // #706
  {DBGFIELD("RDMSR")              54, false, false, false, 905, 11,  4, 1,  0, 0}, // #707
  {DBGFIELD("RET_RET16_RET32_RET64_LRET16_LRET32_LRET64_LRETI16_LRETI32_LRETI64") 2, false, false, false, 22, 8,  3, 1,  0, 0}, // #708
  {DBGFIELD("IN8ri_IN16ri_IN32ri") 87, false, false, false, 916, 14, 51, 1,  0, 0}, // #709
  {DBGFIELD("IN8rr_IN16rr_IN32rr") 86, false, false, false, 930, 14, 51, 1,  0, 0}, // #710
  {DBGFIELD("F2XM1")              1, false, false, false,  5, 2,  4, 1,  0, 0}, // #711
  {DBGFIELD("CPUID")              26, false, false, false, 944, 15, 13, 1,  0, 0}, // #712
  {DBGFIELD("INT")                1, false, false, false,  5, 2,  4, 1,  0, 0}, // #713
  {DBGFIELD("INT3")               1, false, false, false,  5, 2,  4, 1,  0, 0}, // #714
  {DBGFIELD("FXSAVE_FXSAVE64")    110, false, false, false, 959, 16,  4, 1,  0, 0}, // #715
  {DBGFIELD("FXRSTOR_FXRSTOR64")  90, false, false, false, 975, 15, 52, 1,  0, 0}, // #716
  {DBGFIELD("FYL2X")              1, false, false, false,  5, 2,  4, 1,  0, 0}, // #717
  {DBGFIELD("FYL2XP1")            1, false, false, false,  5, 2,  4, 1,  0, 0}, // #718
  {DBGFIELD("FPTAN")              1, false, false, false,  5, 2,  4, 1,  0, 0}, // #719
  {DBGFIELD("FSINCOS_FSIN_FCOS")  1, false, false, false,  5, 2,  4, 1,  0, 0}, // #720
  {DBGFIELD("FPATAN")             1, false, false, false,  5, 2,  4, 1,  0, 0}, // #721
  {DBGFIELD("WRMSR")              144, false, false, false, 990, 15,  4, 1,  0, 0}, // #722
  {DBGFIELD("COMP_FST0r_COM_FST0r") 1, false, false, false, 60, 8,  1, 1,  0, 0}, // #723
  {DBGFIELD("UCOM_FPr_UCOM_Fr")   1, false, false, false, 60, 8,  1, 1,  0, 0}, // #724
  {DBGFIELD("FDECSTP_FINCSTP_FFREE_FFREEP") 2, false, false, false, 299, 5, 12, 1,  0, 0}, // #725
  {DBGFIELD("FNOP")               1, false, false, false,  4, 5,  1, 1,  0, 0}, // #726
  {DBGFIELD("RET64")              2, false, false, false, 163, 6,  6, 1,  0, 0}, // #727
  {DBGFIELD("CDQ_CQO")            1, false, false, false, 10, 4,  1, 1,  0, 0}, // #728
  {DBGFIELD("MMX_PABSBrr_MMX_PABSDrr_MMX_PABSWrr_MMX_PSIGNBrr_MMX_PSIGNDrr_MMX_PSIGNWrr") 1, false, false, false,  2, 8,  1, 1,  0, 0}, // #729
  {DBGFIELD("MMX_PADDQrr")        1, false, false, false,  4, 5,  1, 1,  0, 0}, // #730
  {DBGFIELD("MMX_PALIGNRrri")     1, false, false, false, 60, 8,  1, 1,  0, 0}, // #731
  {DBGFIELD("SCASB_SCASL_SCASQ_SCASW") 4, false, false, false, 623, 3,  3, 1,  0, 0}, // #732
  {DBGFIELD("COMISDrr_COMISDrr_Int_COMISSrr_COMISSrr_Int_UCOMISDrr_UCOMISDrr_Int_UCOMISSrr_UCOMISSrr_Int_VCOMISDrr_VCOMISDrr_Int_VCOMISSrr_VCOMISSrr_Int_VUCOMISDrr_VUCOMISDrr_Int_VUCOMISSrr_VUCOMISSrr_Int") 1, false, false, false,  2, 8,  5, 1,  0, 0}, // #733
  {DBGFIELD("CWD")                2, false, false, false, 45, 4, 12, 1,  0, 0}, // #734
  {DBGFIELD("FNSTSW16r")          2, false, false, false, 1005, 8,  5, 1,  0, 0}, // #735
  {DBGFIELD("MMX_MOVDQ2Qrr")      2, false, false, false, 184, 5,  5, 1,  0, 0}, // #736
  {DBGFIELD("PUSHFS64")           3, false, false, false, 30, 10,  1, 1,  0, 0}, // #737
  {DBGFIELD("EXTRACTPSrr_VEXTRACTPSrr") 2, false, false, false, 441, 11, 14, 1,  0, 0}, // #738
  {DBGFIELD("RCL8r1_RCL16r1_RCL32r1_RCL64r1_RCR8r1_RCR16r1_RCR32r1_RCR64r1") 3, false, false, false, 14, 4, 12, 1,  0, 0}, // #739
  {DBGFIELD("RCR8ri_RCR16ri_RCR32ri_RCR64ri") 3, false, false, false, 14, 4, 12, 1,  0, 0}, // #740
  {DBGFIELD("RCL8ri_RCL16ri_RCL32ri_RCL64ri") 3, false, false, false, 14, 4, 12, 1,  0, 0}, // #741
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr") 1, false, false, false, 60, 8,  1, 1,  0, 0}, // #742
  {DBGFIELD("MOV64sr")            1, false, false, false,  5, 2,  1, 1,  0, 0}, // #743
  {DBGFIELD("RCL16rCL_RCL32rCL_RCL64rCL_RCL8rCL_RCR16rCL_RCR32rCL_RCR64rCL_RCR8rCL") 10, false, false, false, 1013, 9, 22, 1,  0, 0}, // #744
  {DBGFIELD("PUSH16r_PUSH16rmr_PUSH32r_PUSH32rmr_PUSH64i8_PUSH64r_PUSH64rmr") 2, false, false, false, 37, 3,  2, 1,  0, 0}, // #745
  {DBGFIELD("CLI")                3, false, false, false, 1022, 9,  4, 1,  0, 0}, // #746
  {DBGFIELD("PUSHGS64")           3, false, false, false, 30, 10,  1, 1,  0, 0}, // #747
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m") 3, false, false, false, 706, 12, 14, 1,  0, 0}, // #748
  {DBGFIELD("CALL64pcrel32")      2, false, false, false, 37, 3,  5, 1,  0, 0}, // #749
  {DBGFIELD("CALL64r_RVMARKER_CALL16r_CALL16r_NT_CALL32r_CALL32r_NT_CALL64r_CALL64r_NT") 1, false, false, false, 10, 4,  1, 1,  0, 0}, // #750
  {DBGFIELD("EXTRACTPSmr_VEXTRACTPSmr") 3, false, false, false, 1031, 11,  2, 1,  0, 0}, // #751
  {DBGFIELD("STOSB_STOSL_STOSQ_STOSW") 4, false, false, false, 1042, 4,  6, 1,  0, 0}, // #752
  {DBGFIELD("PEXTRDmr_PEXTRQmr_VPEXTRDmr_VPEXTRQmr") 3, false, false, false, 261, 8,  2, 1,  0, 0}, // #753
  {DBGFIELD("PUSHF16_PUSHF64")    4, false, false, false, 1046, 12, 14, 1,  0, 0}, // #754
  {DBGFIELD("CLFLUSH_CLFLUSHOPT") 3, false, false, false, 629, 4, 12, 1,  0, 0}, // #755
  {DBGFIELD("VBROADCASTSSrm")     1, false, false, false, 28, 2,  6, 1,  0, 0}, // #756
  {DBGFIELD("MOV64toPQIrm_VMOV64toPQIrm_MOVDI2PDIrm_VMOVDI2PDIrm_MOVQI2PQIrm_VMOVQI2PQIrm") 1, false, false, false, 28, 2,  6, 1,  0, 0}, // #757
  {DBGFIELD("MOVDDUPrm_VMOVDDUPrm_MOVSHDUPrm_VMOVSHDUPrm_MOVSLDUPrm_VMOVSLDUPrm") 1, false, false, false, 28, 2,  6, 1,  0, 0}, // #758
  {DBGFIELD("MOVSDrm_MOVSDrm_alt_VMOVSDrm_VMOVSDrm_alt_MOVSSrm_MOVSSrm_alt_VMOVSSrm_VMOVSSrm_alt") 1, false, false, false, 28, 2,  6, 1,  0, 0}, // #759
  {DBGFIELD("MOV16sm")            1, false, false, false,  5, 2,  1, 1,  0, 0}, // #760
  {DBGFIELD("MMX_PABSBrm_MMX_PABSDrm_MMX_PABSWrm") 2, false, false, false, 173, 10, 22, 1,  0, 0}, // #761
  {DBGFIELD("MMX_PALIGNRrmi")     2, false, false, false, 375, 10, 22, 1,  5, 1}, // #762
  {DBGFIELD("MMX_PSIGNBrm_MMX_PSIGNDrm_MMX_PSIGNWrm") 2, false, false, false, 173, 10, 22, 1,  5, 1}, // #763
  {DBGFIELD("LODSL_LODSQ")        3, false, false, false, 77, 3, 10, 1,  0, 0}, // #764
  {DBGFIELD("VBROADCASTSDYrm_VBROADCASTSSYrm") 1, false, false, false, 28, 2,  7, 1,  0, 0}, // #765
  {DBGFIELD("VMOVDDUPYrm_VMOVSHDUPYrm_VMOVSLDUPYrm") 1, false, false, false, 28, 2,  7, 1,  0, 0}, // #766
  {DBGFIELD("VINSERTF128rm")      2, false, false, false, 69, 5, 22, 1,  5, 1}, // #767
  {DBGFIELD("MMX_PADDQrm")        2, false, false, false, 395, 7, 22, 1,  5, 1}, // #768
  {DBGFIELD("VERRm_VERWm")        34, false, false, false, 1058, 13, 53, 1,  0, 0}, // #769
  {DBGFIELD("FARJMP64m")          2, false, false, false, 1071, 9,  3, 1,  0, 0}, // #770
  {DBGFIELD("FNSTSWm")            3, false, false, false, 1080, 12,  5, 1,  0, 0}, // #771
  {DBGFIELD("SLDT16r_SLDT32r_SLDT64r_STR16r_STR32r_STR64r") 2, false, false, false, 333, 7,  3, 1,  0, 0}, // #772
  {DBGFIELD("CALL64m_RVMARKER_CALL64m_CALL64m_NT") 1, false, false, false, 10, 4,  1, 1,  0, 0}, // #773
  {DBGFIELD("CALL16m_CALL16m_NT_CALL32m_CALL32m_NT") 5, false, false, false, 45, 8,  6, 1,  0, 0}, // #774
  {DBGFIELD("COMISDrm_COMISDrm_Int_COMISSrm_COMISSrm_Int_UCOMISDrm_UCOMISDrm_Int_UCOMISSrm_UCOMISSrm_Int_VCOMISDrm_VCOMISDrm_Int_VCOMISSrm_VCOMISSrm_Int_VUCOMISDrm_VUCOMISDrm_Int_VUCOMISSrm_VUCOMISSrm_Int") 2, false, false, false, 173, 10,  7, 1,  5, 1}, // #775
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW") 7, false, false, false, 1092, 3,  3, 1,  0, 0}, // #776
  {DBGFIELD("ROL16m1_ROL16mi_ROL32m1_ROL32mi_ROL64m1_ROL64mi_ROL8m1_ROL8mi_ROR16m1_ROR16mi_ROR32m1_ROR32mi_ROR64m1_ROR64mi_ROR8m1_ROR8mi") 5, false, false, false, 562, 8, 54, 2,  0, 0}, // #777
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm") 5, false, false, false, 1095, 5, 54, 2,  0, 0}, // #778
  {DBGFIELD("FARCALL64m")         5, false, false, false, 1100, 11,  6, 1,  0, 0}, // #779
  {DBGFIELD("LD_F32m_LD_F64m")    1, false, false, false, 26, 4,  6, 1,  0, 0}, // #780
  {DBGFIELD("ROL16mCL_ROL32mCL_ROL64mCL_ROL8mCL_ROR16mCL_ROR32mCL_ROR64mCL_ROR8mCL") 5, false, false, false, 562, 8, 54, 2,  0, 0}, // #781
  {DBGFIELD("ADC8mr_ADC16mr_ADC32mr_ADC64mr_SBB8mr_SBB16mr_SBB32mr_SBB64mr") 6, false, false, false, 1111, 8,  2, 1, 11, 2}, // #782
  {DBGFIELD("ADD_F32m_ADD_F64m_SUBR_F32m_SUBR_F64m_SUB_F32m_SUB_F64m") 2, false, false, false, 279, 12,  9, 1,  0, 0}, // #783
  {DBGFIELD("PCMPGTQrm_VPCMPGTQrm") 2, false, false, false, 375, 10,  9, 1,  5, 1}, // #784
  {DBGFIELD("FICOM16m_FICOM32m_FICOMP16m_FICOMP32m") 3, false, false, false, 1119, 12,  8, 1,  0, 0}, // #785
  {DBGFIELD("MUL_F32m_MUL_F64m")  2, false, false, false, 1131, 12,  8, 1,  0, 0}, // #786
  {DBGFIELD("ADD_FI16m_ADD_FI32m_SUBR_FI16m_SUBR_FI32m_SUB_FI16m_SUB_FI32m") 3, false, false, false, 1119, 12, 24, 1,  0, 0}, // #787
  {DBGFIELD("MUL_FI16m_MUL_FI32m") 3, false, false, false, 1143, 15, 21, 1,  0, 0}, // #788
  {DBGFIELD("DIVR_F32m_DIVR_F64m_DIV_F32m_DIV_F64m") 2, false, false, false, 1131, 12, 19, 1,  0, 0}, // #789
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m_DIV_FI16m_DIV_FI32m") 3, false, false, false, 1143, 15, 42, 1,  0, 0}, // #790
  {DBGFIELD("VZEROALL")           10, false, false, false, 1158, 9, 16, 1,  0, 0}, // #791
  {DBGFIELD("VZEROUPPER")         0, false, false, false,  0, 0,  0, 1,  0, 0}, // #792
  {DBGFIELD("CLC")                0, false, false, false,  0, 0,  1, 1,  0, 0}, // #793
  {DBGFIELD("SUB32rr_SUB64rr_XOR32rr_XOR64rr") 1, false, false, false,  1, 1,  1, 1,  0, 0}, // #794
  {DBGFIELD("XORPSrr_VXORPSrr_XORPDrr_VXORPDrr") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #795
  {DBGFIELD("VXORPSYrr_VXORPDYrr") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #796
  {DBGFIELD("PXORrr_VPXORrr")     1, false, false, false,  4, 3,  1, 1,  0, 0}, // #797
  {DBGFIELD("PSUBBrr_VPSUBBrr_PSUBDrr_VPSUBDrr_VPSUBQrr_PSUBWrr_VPSUBWrr_PCMPGTBrr_VPCMPGTBrr_PCMPGTDrr_VPCMPGTDrr_PCMPGTWrr_VPCMPGTWrr") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #798
  {DBGFIELD("PSUBQrr")            1, false, false, false,  4, 3,  1, 1,  0, 0}, // #799
  {DBGFIELD("PCMPGTQrr_VPCMPGTQrr") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #800
  {DBGFIELD("CMOV16rr_CMOV32rr_CMOV64rr") 1, false, false, false, 10, 4,  1, 1,  0, 0}, // #801
  {DBGFIELD("CMOV16rm_CMOV32rm_CMOV64rm") 2, false, false, false, 163, 6,  6, 1,  3, 1}, // #802
  {DBGFIELD("SETCCr")             2, false, false, false, 550, 4, 12, 1,  0, 0}, // #803
  {DBGFIELD("SETCCm")             4, false, false, false, 570, 7, 24, 1,  0, 0}, // #804
  {DBGFIELD("MOVHPDrm_MOVHPSrm_MOVLPDrm_MOVLPSrm_VMOVHPDrm_VMOVHPSrm_VMOVLPDrm_VMOVLPSrm") 2, false, false, false, 375, 10,  7, 1,  5, 1}, // #805
  {DBGFIELD("RETI16_RETI32_RETI64") 3, false, false, false, 1167, 6,  3, 1,  0, 0}, // #806
  {DBGFIELD("LRETI16_LRETI32_LRETI64") 2, false, false, false, 22, 8,  3, 1,  0, 0}, // #807
  {DBGFIELD("RDPMC")              18, false, false, false, 1173, 11,  4, 1,  0, 0}, // #808
  {DBGFIELD("RDRAND16r_RDRAND32r_RDRAND64r") 25, false, false, false, 1184, 14,  4, 1,  0, 0}, // #809
  {DBGFIELD("FBLDm")              1, false, false, false,  5, 2,  4, 1,  0, 0}, // #810
  {DBGFIELD("FFREE_FFREEP")       1, false, false, false,  5, 2,  4, 1,  0, 0}, // #811
  {DBGFIELD("FSAVEm")             1, false, false, false,  5, 2,  4, 1,  0, 0}, // #812
  {DBGFIELD("FRSTORm")            1, false, false, false,  5, 2,  4, 1,  0, 0}, // #813
  {DBGFIELD("FXTRACT")            1, false, false, false,  5, 2,  4, 1,  0, 0}, // #814
  {DBGFIELD("VPBROADCASTDrm_VPBROADCASTQrm") 1, false, false, false, 28, 2,  6, 1,  0, 0}, // #815
  {DBGFIELD("VBROADCASTF128")     1, false, false, false, 28, 2,  7, 1,  0, 0}, // #816
  {DBGFIELD("VBROADCASTI128")     1, false, false, false, 28, 2,  7, 1,  0, 0}, // #817
  {DBGFIELD("VPBROADCASTDYrm_VPBROADCASTQYrm") 1, false, false, false, 28, 2,  7, 1,  0, 0}, // #818
  {DBGFIELD("FBSTPm")             2, false, false, false, 677, 4,  1, 1,  0, 0}, // #819
  {DBGFIELD("VMPTRSTm")           2, false, false, false, 677, 4,  1, 1,  0, 0}, // #820
  {DBGFIELD("ST_FP32m_ST_FP64m")  2, false, false, false, 677, 4,  1, 1,  0, 0}, // #821
  {DBGFIELD("VPSLLVQYrr_VPSRLVQYrr") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #822
  {DBGFIELD("VPSLLVQrr_VPSRLVQrr") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #823
  {DBGFIELD("MMX_MOVQ2DQrr")      2, false, false, false, 269, 8,  5, 1,  0, 0}, // #824
  {DBGFIELD("JMP16r_JMP16r_NT_JMP32r_JMP32r_NT_JMP64r_JMP64r_NT_JMP64r_REX") 1, false, false, false, 10, 4,  1, 1,  0, 0}, // #825
  {DBGFIELD("FINCSTP")            1, false, false, false,  4, 5,  1, 1,  0, 0}, // #826
  {DBGFIELD("ANDN32rr_ANDN64rr")  1, false, false, false, 115, 2, 12, 1,  0, 0}, // #827
  {DBGFIELD("VPBLENDDYrri")       1, false, false, false,  4, 3,  1, 1,  0, 0}, // #828
  {DBGFIELD("VPBLENDDrri")        1, false, false, false,  4, 3,  1, 1,  0, 0}, // #829
  {DBGFIELD("SGDT64m_SIDT64m_SMSW16m_STRm_SYSCALL") 7, false, false, false, 1198, 10, 23, 1,  0, 0}, // #830
  {DBGFIELD("VPSLLVQrm_VPSRLVQrm") 2, false, false, false, 68, 6,  7, 1,  5, 1}, // #831
  {DBGFIELD("VPSLLVQYrm_VPSRLVQYrm") 2, false, false, false, 68, 6, 22, 1,  5, 1}, // #832
  {DBGFIELD("PDEP32rm_PDEP64rm_PEXT32rm_PEXT64rm") 2, false, false, false, 119, 9,  7, 1,  3, 1}, // #833
  {DBGFIELD("PMOVSXBDrm_PMOVZXBDrm_VPMOVSXBDrm_VPMOVZXBDrm_PMOVSXBQrm_PMOVZXBQrm_VPMOVSXBQrm_VPMOVZXBQrm_PMOVSXBWrm_PMOVZXBWrm_VPMOVSXBWrm_VPMOVZXBWrm_PMOVSXDQrm_PMOVZXDQrm_VPMOVSXDQrm_VPMOVZXDQrm_PMOVSXWDrm_PMOVZXWDrm_VPMOVSXWDrm_VPMOVZXWDrm_PMOVSXWQrm_PMOVZXWQrm_VPMOVSXWQrm_VPMOVZXWQrm") 2, false, false, false, 53, 7,  7, 1,  0, 0}, // #834
  {DBGFIELD("VPMOVSXBDYrm_VPMOVSXBQYrm_VPMOVSXWQYrm") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #835
  {DBGFIELD("JMP16m_JMP16m_NT_JMP32m_JMP32m_NT_JMP64m_JMP64m_NT_JMP64m_REX") 2, false, false, false, 1071, 9,  3, 1,  0, 0}, // #836
  {DBGFIELD("ANDN32rm_ANDN64rm")  2, false, false, false, 115, 4,  6, 1,  3, 1}, // #837
  {DBGFIELD("MOVBE16rm_MOVBE32rm_MOVBE64rm") 3, false, false, false, 104, 11,  6, 1,  0, 0}, // #838
  {DBGFIELD("VINSERTI128rm")      2, false, false, false, 69, 5, 22, 1,  5, 1}, // #839
  {DBGFIELD("VPBLENDDrmi")        2, false, false, false, 69, 5,  7, 1,  5, 1}, // #840
  {DBGFIELD("VPBLENDDYrmi")       2, false, false, false, 69, 5, 22, 1,  5, 1}, // #841
  {DBGFIELD("POP32r_POP64r")      1, false, false, false, 28, 2, 10, 1,  0, 0}, // #842
  {DBGFIELD("SFENCE")             2, false, false, false, 37, 3, 12, 1,  0, 0}, // #843
  {DBGFIELD("MOVBE32mr_MOVBE64mr") 4, false, false, false, 1046, 12,  2, 1,  0, 0}, // #844
  {DBGFIELD("MOVBE16mr")          3, false, false, false, 1208, 7,  2, 1,  0, 0}, // #845
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r_PUSH64i8") 2, false, false, false, 37, 3,  2, 1,  0, 0}, // #846
  {DBGFIELD("MFENCE")             2, false, false, false, 37, 3,  5, 1,  0, 0}, // #847
  {DBGFIELD("XGETBV")             23, false, false, false, 1215, 9, 14, 1,  0, 0}, // #848
  {DBGFIELD("MMX_PACKSSDWrm_MMX_PACKSSWBrm_MMX_PACKUSWBrm") 3, false, false, false, 1224, 10,  2, 1,  5, 1}, // #849
  {DBGFIELD("LRET64_RET32")       2, false, false, false, 163, 6,  3, 1,  0, 0}, // #850
  {DBGFIELD("ROL8r1_ROL16r1_ROL32r1_ROL64r1_ROR8r1_ROR16r1_ROR32r1_ROR64r1") 2, false, false, false, 550, 4,  1, 1,  0, 0}, // #851
  {DBGFIELD("PDEP32rr_PDEP64rr_PEXT32rr_PEXT64rr") 1, false, false, false, 30, 7,  5, 1,  0, 0}, // #852
  {DBGFIELD("VPBROADCASTBrr_VPBROADCASTWrr") 1, false, false, false, 60, 8,  1, 1,  0, 0}, // #853
  {DBGFIELD("VPMOVSXBWYrm_VPMOVSXDQYrm_VPMOVSXWDYrm_VPMOVZXWDYrm") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #854
  {DBGFIELD("MMX_PACKSSDWrr_MMX_PACKSSWBrr_MMX_PACKUSWBrr") 2, false, false, false, 1234, 8, 14, 1,  0, 0}, // #855
  {DBGFIELD("CLDEMOTE")           3, false, false, false, 629, 4,  5, 1,  0, 0}, // #856
  {DBGFIELD("MMX_CVTPI2PDrm")     2, false, false, false, 68, 6,  8, 1,  0, 0}, // #857
  {DBGFIELD("VPBROADCASTBYrm_VPBROADCASTBrm_VPBROADCASTWYrm_VPBROADCASTWrm") 2, false, false, false, 375, 10, 22, 1,  0, 0}, // #858
  {DBGFIELD("LAR16rr_LAR32rr_LAR64rr") 22, false, false, false, 1242, 14, 56, 1,  0, 0}, // #859
  {DBGFIELD("LAR16rm_LAR32rm_LAR64rm_LSL16rm_LSL32rm_LSL64rm") 13, false, false, false, 1256, 14, 57, 1,  0, 0}, // #860
  {DBGFIELD("MUL_FPrST0_MUL_FST0r_MUL_FrST0") 1, false, false, false,  2, 8, 14, 1,  0, 0}, // #861
  {DBGFIELD("VPCMPGTQYrm")        2, false, false, false, 375, 10,  8, 1,  5, 1}, // #862
  {DBGFIELD("VCVTSI642SSrr_VCVTSI642SSrr_Int") 3, false, false, false, 657, 9,  7, 1,  6, 1}, // #863
  {DBGFIELD("STR16r_STR32r_STR64r") 2, false, false, false, 333, 7, 10, 1,  0, 0}, // #864
  {DBGFIELD("XSETBV")             54, false, false, false, 1270, 11, 10, 1,  0, 0}, // #865
  {DBGFIELD("RCL16mCL_RCL32mCL_RCL64mCL_RCL8mCL") 10, false, false, false, 537, 13, 35, 2,  0, 0}, // #866
  {DBGFIELD("RCL16rCL_RCL32rCL_RCL64rCL_RCR16rCL_RCR32rCL_RCR64rCL") 7, false, false, false, 537, 9,  7, 1,  0, 0}, // #867
  {DBGFIELD("RCL8rCL")            9, false, false, false, 1281, 9,  6, 1,  0, 0}, // #868
  {DBGFIELD("RDTSC")              15, false, false, false, 1290, 11, 13, 1,  0, 0}, // #869
  {DBGFIELD("XRSTOR_XRSTOR64_XRSTORS_XRSTORS64") 31, false, false, false, 1301, 14, 58, 1,  0, 0}, // #870
  {DBGFIELD("DIV_FPrST0_DIV_FST0r_DIV_FrST0") 1, false, false, false,  2, 8, 15, 1,  0, 0}, // #871
  {DBGFIELD("DIVR_F32m_DIVR_F64m") 2, false, false, false, 1131, 12, 59, 1,  0, 0}, // #872
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m") 3, false, false, false, 1143, 15, 60, 1,  0, 0}, // #873
  {DBGFIELD("DIVR_FPrST0_DIVR_FST0r_DIVR_FrST0") 1, false, false, false,  2, 8, 11, 1,  0, 0}, // #874
  {DBGFIELD("XSAVE64")            140, false, false, false, 1315, 15, 61, 1,  0, 0}, // #875
  {DBGFIELD("XSAVE")              140, false, false, false, 1315, 15, 48, 1,  0, 0}, // #876
  {DBGFIELD("XSAVEC_XSAVEC64_XSAVES_XSAVES64_XSAVEOPT_XSAVEOPT64") 156, false, false, false, 1330, 15, 62, 1,  0, 0}, // #877
  {DBGFIELD("VMCLEARm")           18, false, false, false, 1345, 18, 63, 1,  0, 0}, // #878
  {DBGFIELD("FLDENVm")            64, false, false, false, 1363, 12, 64, 1,  0, 0}, // #879
  {DBGFIELD("FXRSTOR64")          88, false, false, false, 1375, 15, 52, 1,  0, 0}, // #880
  {DBGFIELD("FSTENVm")            100, false, false, false, 1390, 17, 65, 1,  0, 0}, // #881
  {DBGFIELD("VGATHERDPDrm_VPGATHERDQrm") 5, false, false, false, 1407, 12, 66, 2,  0, 0}, // #882
  {DBGFIELD("VGATHERDPDYrm_VPGATHERDQYrm") 8, false, false, false, 1419, 12, 68, 2,  0, 0}, // #883
  {DBGFIELD("VGATHERDPSrm_VPGATHERDDrm") 8, false, false, false, 1419, 12, 70, 2,  0, 0}, // #884
  {DBGFIELD("VGATHERDPSYrm_VPGATHERDDYrm") 12, false, false, false, 1431, 12, 72, 2,  0, 0}, // #885
  {DBGFIELD("VGATHERQPDrm_VPGATHERQQrm") 5, false, false, false, 1407, 12, 66, 2,  0, 0}, // #886
  {DBGFIELD("VGATHERQPDYrm_VPGATHERQQYrm_VGATHERQPSYrm_VPGATHERQDYrm") 8, false, false, false, 1419, 12, 68, 2,  0, 0}, // #887
  {DBGFIELD("VGATHERQPSrm_VPGATHERQDrm") 5, false, false, false, 1407, 12, 66, 2,  0, 0}, // #888
  {DBGFIELD("VPXORYrr")           1, false, false, false,  4, 3,  1, 1,  0, 0}, // #889
  {DBGFIELD("VPSUBBYrr_VPSUBDYrr_VPSUBQYrr_VPSUBWYrr_VPCMPGTBYrr_VPCMPGTDYrr_VPCMPGTWYrr") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #890
  {DBGFIELD("VPCMPGTQYrr")        1, false, false, false, 60, 8,  5, 1,  0, 0}, // #891
  {DBGFIELD("ADC16ri8_ADC32ri8_ADC64ri8_SBB16ri8_SBB32ri8_SBB64ri8") 1, false, false, false, 10, 4,  1, 1,  0, 0}, // #892
  {DBGFIELD("ADC8i8_SBB8i8_ADC16i16_SBB16i16_ADC32i32_SBB32i32_ADC64i32_SBB64i32") 1, false, false, false, 10, 4,  1, 1,  0, 0}, // #893
  {DBGFIELD("FCOM32m_FCOM64m_FCOMP32m_FCOMP64m") 2, false, false, false, 279, 12,  7, 1,  0, 0}, // #894
  {DBGFIELD("LRET64")             3, false, false, false, 1443, 9,  6, 1,  0, 0}, // #895
  {DBGFIELD("POPF64")             7, false, false, false, 1452, 11, 10, 1,  0, 0}, // #896
  {DBGFIELD("VGATHERQPDYrm_VPGATHERQQYrm") 8, false, false, false, 1419, 12, 68, 2,  0, 0}, // #897
  {DBGFIELD("PCMPEQQrr")          1, false, false, false,  3, 4,  1, 1,  0, 0}, // #898
  {DBGFIELD("PCMPGTQrr")          1, false, false, false, 60, 8,  5, 1,  0, 0}, // #899
  {DBGFIELD("PCMPEQQrm")          2, false, false, false, 68, 6,  7, 1,  5, 1}, // #900
  {DBGFIELD("PCMPGTQrm")          2, false, false, false, 375, 10,  9, 1,  5, 1}, // #901
  {DBGFIELD("MOV16rm")            2, false, false, false, 71, 3,  3, 1,  0, 0}, // #902
  {DBGFIELD("POP16rmm")           3, false, false, false, 18, 4,  2, 1,  0, 0}, // #903
  {DBGFIELD("PUSH16rmm_PUSH32rmm") 3, false, false, false, 18, 4,  2, 1,  0, 0}, // #904
  {DBGFIELD("PUSHF16")            4, false, false, false, 1046, 12,  2, 1,  0, 0}, // #905
  {DBGFIELD("LAHF")               1, false, false, false, 10, 4,  5, 1,  0, 0}, // #906
  {DBGFIELD("ADD16mi_ADD16mi8_ADD32mi_ADD32mi8_ADD64mi32_ADD64mi8_ADD8mi_ADD8mi8_SUB16mi_SUB16mi8_SUB32mi_SUB32mi8_SUB64mi32_SUB64mi8_SUB8mi_SUB8mi8") 4, false, false, false, 40, 5,  2, 1,  0, 0}, // #907
  {DBGFIELD("ADD16mr_ADD32mr_ADD64mr_ADD8mr_SUB16mr_SUB32mr_SUB64mr_SUB8mr") 4, false, false, false, 40, 5,  2, 1,  1, 1}, // #908
  {DBGFIELD("ADC16mi_ADC16mi8_ADC32mi_ADC32mi8_ADC64mi32_ADC64mi8_ADC8mi_ADC8mi8_SBB16mi_SBB16mi8_SBB32mi_SBB32mi8_SBB64mi32_SBB64mi8_SBB8mi_SBB8mi8") 5, false, false, false, 45, 8,  2, 1,  0, 0}, // #909
  {DBGFIELD("DEC16m_DEC32m_DEC64m_DEC8m_INC16m_INC32m_INC64m_INC8m_NEG16m_NEG32m_NEG64m_NEG8m_NOT16m_NOT32m_NOT64m_NOT8m") 4, false, false, false, 40, 5,  2, 1,  0, 0}, // #910
  {DBGFIELD("CALL16r_CALL16r_NT_CALL32r_CALL32r_NT") 3, false, false, false, 1208, 7,  5, 1,  0, 0}, // #911
  {DBGFIELD("RET16_LRET16_LRET32") 2, false, false, false, 22, 8,  3, 1,  0, 0}, // #912
  {DBGFIELD("IRET16_IRET32_IRET64") 2, false, false, false, 22, 8,  3, 1,  0, 0}, // #913
  {DBGFIELD("AND16mi_AND16mi8_AND32mi_AND32mi8_AND64mi32_AND64mi8_AND8mi_AND8mi8_OR16mi_OR16mi8_OR32mi_OR32mi8_OR32mi8Locked_OR64mi32_OR64mi8_OR8mi_OR8mi8_XOR16mi_XOR16mi8_XOR32mi_XOR32mi8_XOR64mi32_XOR64mi8_XOR8mi_XOR8mi8") 4, false, false, false, 40, 5,  2, 1,  0, 0}, // #914
  {DBGFIELD("AND16mr_AND32mr_AND64mr_AND8mr_OR16mr_OR32mr_OR64mr_OR8mr_XOR16mr_XOR32mr_XOR64mr_XOR8mr") 4, false, false, false, 40, 5,  2, 1,  1, 1}, // #915
  {DBGFIELD("SHLD32mri8_SHRD32mri8") 5, false, false, false, 590, 11,  2, 1,  0, 0}, // #916
  {DBGFIELD("SHLD32rrCL_SHRD32rrCL") 3, false, false, false, 342, 9, 10, 1,  0, 0}, // #917
  {DBGFIELD("SHLD32mrCL_SHRD32mrCL") 6, false, false, false, 577, 13,  2, 1,  0, 0}, // #918
  {DBGFIELD("XADD16rr_XADD32rr_XADD64rr_XADD8rr") 3, false, false, false, 15, 1, 12, 1,  0, 0}, // #919
  {DBGFIELD("CHS_F_CHS_Fp32_CHS_Fp64_CHS_Fp80") 1, false, false, false,  2, 8,  1, 1,  0, 0}, // #920
  {DBGFIELD("MMX_MASKMOVQ_MMX_MASKMOVQ64") 4, false, false, false, 1463, 11,  2, 1,  0, 0}, // #921
  {DBGFIELD("MASKMOVDQU_MASKMOVDQU64") 2, false, false, false, 677, 4,  1, 1,  0, 0}, // #922
  {DBGFIELD("VMASKMOVDQU_VMASKMOVDQU64") 2, false, false, false, 677, 4,  1, 1,  0, 0}, // #923
  {DBGFIELD("VPMASKMOVDYrm")      2, false, false, false, 69, 5, 22, 1,  0, 0}, // #924
  {DBGFIELD("VPMASKMOVDrm")       2, false, false, false, 69, 5,  7, 1,  0, 0}, // #925
  {DBGFIELD("VPMASKMOVDYmr")      3, false, false, false, 633, 11, 21, 1,  0, 0}, // #926
  {DBGFIELD("VPMASKMOVDmr")       3, false, false, false, 633, 11, 21, 1,  0, 0}, // #927
  {DBGFIELD("VPMASKMOVQYmr")      3, false, false, false, 633, 11, 21, 1,  0, 0}, // #928
  {DBGFIELD("VPMASKMOVQmr")       3, false, false, false, 633, 11, 21, 1,  0, 0}, // #929
  {DBGFIELD("VPBROADCASTBrm_VPBROADCASTWrm") 2, false, false, false, 375, 10,  7, 1,  0, 0}, // #930
  {DBGFIELD("VPGATHERDDYrm")      12, false, false, false, 1431, 12, 72, 2,  0, 0}, // #931
  {DBGFIELD("VPGATHERDDrm")       8, false, false, false, 1419, 12, 70, 2,  0, 0}, // #932
  {DBGFIELD("VPGATHERDQYrm")      8, false, false, false, 1419, 12, 68, 2,  0, 0}, // #933
  {DBGFIELD("VPGATHERDQrm")       5, false, false, false, 1407, 12, 66, 2,  0, 0}, // #934
  {DBGFIELD("VPGATHERQDYrm")      8, false, false, false, 1419, 12, 68, 2,  0, 0}, // #935
  {DBGFIELD("VPGATHERQDrm")       5, false, false, false, 1407, 12, 66, 2,  0, 0}, // #936
  {DBGFIELD("VPGATHERQQYrm")      8, false, false, false, 1419, 12, 68, 2,  0, 0}, // #937
  {DBGFIELD("VPGATHERQQrm")       5, false, false, false, 1407, 12, 66, 2,  0, 0}, // #938
  {DBGFIELD("VPERM2F128rr")       1, false, false, false, 60, 8,  5, 1,  0, 0}, // #939
  {DBGFIELD("VPERM2I128rr")       1, false, false, false, 60, 8,  5, 1,  0, 0}, // #940
  {DBGFIELD("VPERM2F128rm")       2, false, false, false, 375, 10,  8, 1,  5, 1}, // #941
  {DBGFIELD("VPERM2I128rm")       2, false, false, false, 375, 10,  8, 1,  5, 1}, // #942
  {DBGFIELD("VEXTRACTF128rr")     1, false, false, false, 60, 8,  5, 1,  0, 0}, // #943
  {DBGFIELD("VEXTRACTI128rr")     1, false, false, false, 60, 8,  5, 1,  0, 0}, // #944
  {DBGFIELD("VEXTRACTF128mr")     2, false, false, false, 37, 3,  2, 1,  0, 0}, // #945
  {DBGFIELD("VEXTRACTI128mr")     2, false, false, false, 37, 3,  2, 1,  0, 0}, // #946
  {DBGFIELD("VINSERTF128rr")      1, false, false, false, 60, 8,  5, 1,  0, 0}, // #947
  {DBGFIELD("VINSERTI128rr")      1, false, false, false, 60, 8,  5, 1,  0, 0}, // #948
  {DBGFIELD("CVTDQ2PDrr_VCVTDQ2PDrr") 2, false, false, false, 183, 9, 10, 1,  0, 0}, // #949
  {DBGFIELD("VCVTDQ2PDYrr")       2, false, false, false, 183, 9,  6, 1,  0, 0}, // #950
  {DBGFIELD("CVTPD2DQrr_CVTTPD2DQrr_VCVTPD2DQrr_VCVTTPD2DQrr") 2, false, false, false, 183, 9, 10, 1,  0, 0}, // #951
  {DBGFIELD("CVTPD2DQrm_CVTTPD2DQrm_VCVTPD2DQrm_VCVTTPD2DQrm") 3, false, false, false, 192, 11,  2, 1,  0, 0}, // #952
  {DBGFIELD("VCVTPD2DQYrr_VCVTTPD2DQYrr") 2, false, false, false, 183, 9,  6, 1,  0, 0}, // #953
  {DBGFIELD("VCVTPD2DQYrm_VCVTTPD2DQYrm") 3, false, false, false, 192, 11, 11, 1,  0, 0}, // #954
  {DBGFIELD("MMX_CVTPI2PDrr")     2, false, false, false, 183, 9,  3, 1,  0, 0}, // #955
  {DBGFIELD("MMX_CVTPD2PIrr_MMX_CVTTPD2PIrr") 2, false, false, false, 183, 9,  7, 1,  0, 0}, // #956
  {DBGFIELD("CVTSS2SIrr_CVTTSS2SIrr_VCVTSS2SI64rr_VCVTSS2SIrr_VCVTTSS2SI64rr_VCVTTSS2SIrr") 2, false, false, false, 203, 8,  6, 1,  0, 0}, // #957
  {DBGFIELD("CVTSS2SIrr_Int_CVTTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int_VCVTTSS2SI64rr_Int_VCVTTSS2SIrr_Int") 2, false, false, false, 203, 8,  6, 1,  0, 0}, // #958
  {DBGFIELD("CVTSS2SIrm_CVTSS2SIrm_Int_CVTTSS2SIrm_CVTTSS2SIrm_Int_VCVTSS2SI64rm_VCVTSS2SI64rm_Int_VCVTSS2SIrm_VCVTSS2SIrm_Int_VCVTTSS2SI64rm_VCVTTSS2SI64rm_Int_VCVTTSS2SIrm_VCVTTSS2SIrm_Int") 3, false, false, false, 203, 10,  2, 1,  0, 0}, // #959
  {DBGFIELD("CVTSI2SDrr_CVTSI642SDrr") 2, false, false, false, 183, 9,  6, 1,  0, 1}, // #960
  {DBGFIELD("CVTSI2SDrr_Int_CVTSI642SDrr_Int_VCVTSI2SDrr_VCVTSI2SDrr_Int_VCVTSI642SDrr_VCVTSI642SDrr_Int") 2, false, false, false, 183, 9,  6, 1,  6, 1}, // #961
  {DBGFIELD("CVTSD2SI64rr_CVTSD2SIrr_CVTTSD2SI64rr_CVTTSD2SIrr_VCVTSD2SI64rr_VCVTSD2SIrr_VCVTTSD2SI64rr_VCVTTSD2SIrr") 2, false, false, false, 203, 8,  6, 1,  0, 0}, // #962
  {DBGFIELD("CVTSD2SI64rr_Int_CVTSD2SIrr_Int_CVTTSD2SI64rr_Int_CVTTSD2SIrr_Int_VCVTSD2SI64rr_Int_VCVTSD2SIrr_Int") 2, false, false, false, 203, 8,  6, 1,  0, 0}, // #963
  {DBGFIELD("VCVTTSD2SI64rr_Int_VCVTTSD2SIrr_Int") 2, false, false, false, 203, 8,  6, 1,  0, 0}, // #964
  {DBGFIELD("CVTSD2SI64rm_CVTSD2SI64rm_Int_CVTSD2SIrm_CVTSD2SIrm_Int_CVTTSD2SI64rm_CVTTSD2SI64rm_Int_CVTTSD2SIrm_CVTTSD2SIrm_Int_VCVTSD2SI64rm_VCVTSD2SI64rm_Int_VCVTSD2SIrm_VCVTSD2SIrm_Int_VCVTTSD2SI64rm_VCVTTSD2SIrm") 3, false, false, false, 203, 10,  2, 1,  0, 0}, // #965
  {DBGFIELD("VCVTTSD2SI64rm_Int_VCVTTSD2SIrm_Int") 3, false, false, false, 203, 10,  2, 1,  0, 0}, // #966
  {DBGFIELD("EXTRQ_EXTRQI")       1, false, false, false,  3, 4,  1, 1,  0, 0}, // #967
  {DBGFIELD("INSERTQ_INSERTQI")   1, false, false, false,  3, 4,  1, 1,  0, 0}, // #968
  {DBGFIELD("SHA256MSG2rm")       3, false, false, false, 1224, 10, 24, 1,  5, 1}, // #969
  {DBGFIELD("SHA256MSG2rr")       2, false, false, false, 1234, 8,  3, 1,  0, 0}, // #970
  {DBGFIELD("SHA1MSG1rr_SHA256MSG1rr") 7, false, false, false, 1474, 10, 10, 1,  0, 0}, // #971
  {DBGFIELD("SHA1MSG1rm_SHA256MSG1rm") 8, false, false, false, 1484, 12,  2, 1,  5, 1}, // #972
  {DBGFIELD("SHA1MSG2rr")         7, false, false, false, 1496, 8,  3, 1,  0, 0}, // #973
  {DBGFIELD("SHA1MSG2rm")         8, false, false, false, 1504, 10, 24, 1,  5, 1}, // #974
  {DBGFIELD("SHA1NEXTErr")        3, false, false, false, 1514, 6,  5, 1,  0, 0}, // #975
  {DBGFIELD("SHA1NEXTErm")        4, false, false, false, 1520, 8,  7, 1,  5, 1}, // #976
  {DBGFIELD("SHA1RNDS4rri")       1, false, false, false, 60, 8,  3, 1,  0, 0}, // #977
  {DBGFIELD("SHA1RNDS4rmi")       2, false, false, false, 375, 10, 24, 1,  5, 1}, // #978
  {DBGFIELD("SHA256RNDS2rr")      1, false, false, false, 60, 8,  3, 1,  0, 0}, // #979
  {DBGFIELD("SHA256RNDS2rm")      2, false, false, false, 375, 10, 24, 1,  5, 1}, // #980
  {DBGFIELD("XCHG16rr_XCHG32rr_XCHG64rr_XCHG8rr_XCHG16ar_XCHG32ar_XCHG64ar") 3, false, false, false, 15, 1, 12, 1,  0, 0}, // #981
  {DBGFIELD("CVTDQ2PSrr_VCVTDQ2PSrr") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #982
  {DBGFIELD("VCVTDQ2PSYrr")       1, false, false, false,  3, 4, 14, 1,  0, 0}, // #983
  {DBGFIELD("CVTPS2DQrr_CVTTPS2DQrr_VCVTPS2DQrr_VCVTTPS2DQrr") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #984
  {DBGFIELD("MOV8rm_MOV8rm_NOREX_MOVSX16rm16_MOVSX16rm32_MOVZX16rm16") 1, false, false, false, 28, 2, 10, 1,  0, 0}, // #985
  {DBGFIELD("MOVBE16rm")          3, false, false, false, 1528, 6,  6, 1,  0, 0}, // #986
  {DBGFIELD("ADD8i8_ADD16i16_ADD32i32_ADD64i32_AND8i8_AND16i16_AND32i32_AND64i32_OR8i8_OR16i16_OR32i32_OR64i32_SUB8i8_SUB16i16_SUB32i32_SUB64i32_XOR8i8_XOR16i16_XOR32i32_XOR64i32") 1, false, false, false,  1, 1,  1, 1,  0, 0}, // #987
  {DBGFIELD("MOVSX16rr16_MOVSX16rr32_MOVZX16rr16") 1, false, false, false,  1, 1,  1, 1,  0, 0}, // #988
  {DBGFIELD("MOV32ri_MOV32ri_alt_MOV64ri32") 1, false, false, false,  1, 1,  1, 1,  0, 0}, // #989
  {DBGFIELD("ADC8mr_SBB8mr")      6, false, false, false, 1111, 8, 24, 1, 11, 2}, // #990
  {DBGFIELD("LEA32r_LEA64r_LEA64_32r") 1, false, false, false, 30, 7,  1, 1,  0, 0}, // #991
  {DBGFIELD("LEA16r")             2, false, false, false, 333, 7, 12, 1,  0, 0}, // #992
  {DBGFIELD("LCMPXCHG8")          6, false, false, false, 14, 8,  2, 1,  0, 0}, // #993
  {DBGFIELD("LCMPXCHG16B")        6, false, false, false, 14, 8,  2, 1,  0, 0}, // #994
  {DBGFIELD("XCHG8rr_XCHG16rr_XCHG16ar") 3, false, false, false, 15, 1, 12, 1,  0, 0}, // #995
  {DBGFIELD("XCHG8rm_XCHG16rm")   8, false, false, false, 1534, 8, 74, 2,  0, 0}, // #996
  {DBGFIELD("POPCNT16rr")         1, false, false, false, 30, 7,  5, 1,  0, 0}, // #997
  {DBGFIELD("LZCNT16rr")          1, false, false, false, 30, 7,  5, 1,  0, 0}, // #998
  {DBGFIELD("TZCNT16rr")          1, false, false, false, 30, 7,  5, 1,  0, 0}, // #999
  {DBGFIELD("RCL8m1_RCL16m1_RCL32m1_RCL64m1_RCR8m1_RCR16m1_RCR32m1_RCR64m1") 6, false, false, false, 14, 8, 33, 2,  0, 0}, // #1000
  {DBGFIELD("RCR8mi_RCR16mi_RCR32mi_RCR64mi") 6, false, false, false, 14, 8, 33, 2,  0, 0}, // #1001
  {DBGFIELD("RCR16rCL_RCR32rCL_RCR64rCL") 7, false, false, false, 537, 9,  7, 1,  0, 0}, // #1002
  {DBGFIELD("MOVHPDmr_MOVHPSmr_VMOVHPDmr_VMOVHPSmr") 2, false, false, false, 37, 3,  2, 1,  0, 0}, // #1003
  {DBGFIELD("MMX_MOVQ2FR64rr")    2, false, false, false, 269, 8,  5, 1,  0, 0}, // #1004
  {DBGFIELD("MMX_MOVD64rr_MMX_MOVD64to64rr") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1005
  {DBGFIELD("EXTRQ")              1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1006
  {DBGFIELD("INSERTQ")            1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1007
  {DBGFIELD("PABSBrr_PABSDrr_PABSWrr_PADDSBrr_PADDSWrr_PADDUSBrr_PADDUSWrr_PAVGBrr_PAVGWrr_PSIGNBrr_PSIGNDrr_PSIGNWrr_VPABSBrr_VPABSDrr_VPABSWrr_VPADDSBrr_VPADDSWrr_VPADDUSBrr_VPADDUSWrr_VPAVGBrr_VPAVGWrr_VPCMPEQQrr_VPSIGNBrr_VPSIGNDrr_VPSIGNWrr_PSUBSBrr_PSUBSWrr_PSUBUSBrr_PSUBUSWrr_VPSUBSBrr_VPSUBSWrr_VPSUBUSBrr_VPSUBUSWrr") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1008
  {DBGFIELD("MMX_PADDSBrr_MMX_PADDSWrr_MMX_PADDUSBrr_MMX_PADDUSWrr_MMX_PAVGBrr_MMX_PAVGWrr_MMX_PSUBSBrr_MMX_PSUBSWrr_MMX_PSUBUSBrr_MMX_PSUBUSWrr") 1, false, false, false,  2, 8,  1, 1,  0, 0}, // #1009
  {DBGFIELD("VPABSBYrr_VPABSDYrr_VPABSWYrr_VPADDSBYrr_VPADDSWYrr_VPADDUSBYrr_VPADDUSWYrr_VPSUBSBYrr_VPSUBSWYrr_VPSUBUSBYrr_VPSUBUSWYrr_VPAVGBYrr_VPAVGWYrr_VPCMPEQQYrr_VPSIGNBYrr_VPSIGNDYrr_VPSIGNWYrr") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1010
  {DBGFIELD("MMX_CVTPD2PIrm_MMX_CVTTPD2PIrm") 3, false, false, false, 192, 11, 37, 1,  0, 0}, // #1011
  {DBGFIELD("SHA1MSG1rr")         2, false, false, false, 184, 8, 12, 1,  0, 0}, // #1012
  {DBGFIELD("SHA1MSG1rm")         3, false, false, false, 193, 10, 22, 1,  5, 1}, // #1013
  {DBGFIELD("VPERMPSYrm")         2, false, false, false, 375, 10,  8, 1,  5, 1}, // #1014
  {DBGFIELD("VPERMPDYri")         1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1015
  {DBGFIELD("VPERMQYri")          1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1016
  {DBGFIELD("VPERMPDYmi")         2, false, false, false, 375, 10,  8, 1,  5, 1}, // #1017
  {DBGFIELD("VPERMQYmi")          2, false, false, false, 375, 10,  8, 1,  5, 1}, // #1018
  {DBGFIELD("VPERMDYrm")          2, false, false, false, 375, 10,  8, 1,  5, 1}, // #1019
  {DBGFIELD("MOV32rr_MOV32rr_REV_MOV64rr_MOV64rr_REV") 1, false, false, false,  1, 1,  0, 1,  0, 0}, // #1020
  {DBGFIELD("MOVSX32rr32")        1, false, false, false, 115, 2,  1, 1,  0, 0}, // #1021
  {DBGFIELD("XOR32rr_REV_XOR64rr_REV_SUB32rr_REV_SUB64rr_REV") 1, false, false, false,  1, 1,  1, 1,  0, 0}, // #1022
  {DBGFIELD("CMP8rr_CMP8rr_REV_CMP16rr_CMP16rr_REV_CMP32rr_CMP32rr_REV_CMP64rr_CMP64rr_REV") 1, false, false, false,  1, 1,  1, 1,  0, 0}, // #1023
  {DBGFIELD("VXORPSrr_VXORPDrr")  1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1024
  {DBGFIELD("VANDNPSrr_VANDNPDrr") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1025
  {DBGFIELD("VANDNPSYrr_VANDNPDYrr") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1026
  {DBGFIELD("VPXORrr")            1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1027
  {DBGFIELD("VPANDNrr")           1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1028
  {DBGFIELD("VPANDNYrr")          1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1029
  {DBGFIELD("VPSUBBrr_VPSUBWrr_VPSUBDrr_VPSUBQrr_VPCMPGTBrr_VPCMPGTWrr_VPCMPGTDrr") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1030
  {DBGFIELD("KADDBrr_KADDDrr_KADDQrr_KADDWrr_KANDBrr_KANDDrr_KANDQrr_KANDWrr_KANDNBrr_KANDNDrr_KANDNQrr_KANDNWrr_KNOTBrr_KNOTDrr_KNOTQrr_KNOTWrr_KORBrr_KORDrr_KORQrr_KORWrr_KORTESTBrr_KORTESTDrr_KORTESTQrr_KORTESTWrr_KTESTBrr_KTESTDrr_KTESTQrr_KTESTWrr_KXNORBrr_KXNORDrr_KXNORQrr_KXNORWrr_KXORBrr_KXORDrr_KXORQrr_KXORWrr") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1031
  {DBGFIELD("KMOVBkk_KMOVDkk_KMOVQkk_KMOVWkk_KMOVBrk_KMOVDrk_KMOVQrk_KMOVWrk") 1, false, false, false,  1, 1,  1, 1,  0, 0}, // #1032
  {DBGFIELD("KUNPCKBWrr_KUNPCKDQrr_KUNPCKWDrr") 1, false, false, false, 60, 8,  1, 1,  0, 0}, // #1033
  {DBGFIELD("KMOVBmk_KMOVDmk_KMOVQmk_KMOVWmk") 2, false, false, false, 37, 3,  2, 1,  0, 0}, // #1034
  {DBGFIELD("KMOVBkr_KMOVDkr_KMOVQkr_KMOVWkr") 1, false, false, false,  1, 1,  1, 1,  0, 0}, // #1035
  {DBGFIELD("VALIGNDZrri_VALIGNQZrri") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1036
  {DBGFIELD("VALIGNDZ128rri_VALIGNQZ128rri") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1037
  {DBGFIELD("VALIGNDZ256rri_VALIGNQZ256rri") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1038
  {DBGFIELD("VPERMPSYrr")         1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1039
  {DBGFIELD("VPERMDYrr")          1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1040
  {DBGFIELD("VFIXUPIMMPDZ128rrik_VFIXUPIMMPDZ128rrikz_VFIXUPIMMPSZ128rrik_VFIXUPIMMPSZ128rrikz_VFIXUPIMMPDZ128rri_VFIXUPIMMPSZ128rri_VRANGEPDZ128rri_VRANGEPDZ128rrik_VRANGEPDZ128rrikz_VRANGEPSZ128rri_VRANGEPSZ128rrik_VRANGEPSZ128rrikz_VRANGESDZrri_VRANGESDZrrib_VRANGESDZrribk_VRANGESDZrribkz_VRANGESDZrrik_VRANGESDZrrikz_VRANGESSZrri_VRANGESSZrrib_VRANGESSZrribk_VRANGESSZrribkz_VRANGESSZrrik_VRANGESSZrrikz") 1, false, false, false, 53, 5,  5, 1,  0, 0}, // #1041
  {DBGFIELD("VFIXUPIMMPDZ256rrik_VFIXUPIMMPDZ256rrikz_VFIXUPIMMPSZ256rrik_VFIXUPIMMPSZ256rrikz_VFIXUPIMMPDZ256rri_VFIXUPIMMPSZ256rri_VRANGEPDZ256rri_VRANGEPDZ256rrik_VRANGEPDZ256rrikz_VRANGEPSZ256rri_VRANGEPSZ256rrik_VRANGEPSZ256rrikz") 1, false, false, false, 53, 5,  5, 1,  0, 0}, // #1042
  {DBGFIELD("VFIXUPIMMPDZrrik_VFIXUPIMMPDZrrikz_VFIXUPIMMPSZrrik_VFIXUPIMMPSZrrikz_VRANGEPDZrri_VRANGEPDZrrib_VRANGEPDZrribk_VRANGEPDZrribkz_VRANGEPDZrrik_VRANGEPDZrrikz_VRANGEPSZrri_VRANGEPSZrrib_VRANGEPSZrribk_VRANGEPSZrribkz_VRANGEPSZrrik_VRANGEPSZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1043
  {DBGFIELD("VFIXUPIMMSDZrrik_VFIXUPIMMSDZrrikz_VFIXUPIMMSSZrrik_VFIXUPIMMSSZrrikz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1044
  {DBGFIELD("VSCALEFSDZrrb_Int_VSCALEFSDZrrb_Intk_VSCALEFSDZrrb_Intkz_VSCALEFSSZrrb_Int_VSCALEFSSZrrb_Intk_VSCALEFSSZrrb_Intkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1045
  {DBGFIELD("VREDUCEPDZ128rri_VREDUCEPDZ128rrik_VREDUCEPDZ128rrikz_VREDUCEPSZ128rri_VREDUCEPSZ128rrik_VREDUCEPSZ128rrikz_VREDUCESDZrri_VREDUCESDZrrib_VREDUCESDZrribk_VREDUCESDZrribkz_VREDUCESDZrrik_VREDUCESDZrrikz_VREDUCESSZrri_VREDUCESSZrrib_VREDUCESSZrribk_VREDUCESSZrribkz_VREDUCESSZrrik_VREDUCESSZrrikz") 2, false, false, false, 74, 4,  7, 1,  0, 0}, // #1046
  {DBGFIELD("VREDUCEPDZrri_VREDUCEPDZrrib_VREDUCEPDZrribk_VREDUCEPDZrribkz_VREDUCEPDZrrik_VREDUCEPDZrrikz_VREDUCEPSZrri_VREDUCEPSZrrib_VREDUCEPSZrribk_VREDUCEPSZrribkz_VREDUCEPSZrrik_VREDUCEPSZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1047
  {DBGFIELD("VDPBF16PSZ128r_VDPBF16PSZ128rk_VDPBF16PSZ128rkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1048
  {DBGFIELD("VDPBF16PSZ256r_VDPBF16PSZ256rk_VDPBF16PSZ256rkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1049
  {DBGFIELD("VDPBF16PSZr_VDPBF16PSZrk_VDPBF16PSZrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1050
  {DBGFIELD("VPDPBUSDSZ128r_VPDPBUSDSZ128rk_VPDPBUSDSZ128rkz_VPDPBUSDZ128r_VPDPBUSDZ128rk_VPDPBUSDZ128rkz_VPDPWSSDSZ128r_VPDPWSSDSZ128rk_VPDPWSSDSZ128rkz_VPDPWSSDZ128r_VPDPWSSDZ128rk_VPDPWSSDZ128rkz_VPMADD52HUQZ128r_VPMADD52HUQZ128rk_VPMADD52HUQZ128rkz_VPMADD52LUQZ128r_VPMADD52LUQZ128rk_VPMADD52LUQZ128rkz") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #1051
  {DBGFIELD("VPDPBUSDSZ256r_VPDPBUSDSZ256rk_VPDPBUSDSZ256rkz_VPDPBUSDZ256r_VPDPBUSDZ256rk_VPDPBUSDZ256rkz_VPDPWSSDSZ256r_VPDPWSSDSZ256rk_VPDPWSSDSZ256rkz_VPDPWSSDZ256r_VPDPWSSDZ256rk_VPDPWSSDZ256rkz_VPMADD52HUQZ256r_VPMADD52HUQZ256rk_VPMADD52HUQZ256rkz_VPMADD52LUQZ256r_VPMADD52LUQZ256rk_VPMADD52LUQZ256rkz") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #1052
  {DBGFIELD("VPDPBUSDSZr_VPDPBUSDSZrk_VPDPBUSDSZrkz_VPDPBUSDZr_VPDPBUSDZrk_VPDPBUSDZrkz_VPDPWSSDSZr_VPDPWSSDSZrk_VPDPWSSDSZrkz_VPDPWSSDZr_VPDPWSSDZrk_VPDPWSSDZrkz_VPMADD52HUQZr_VPMADD52HUQZrk_VPMADD52HUQZrkz_VPMADD52LUQZr_VPMADD52LUQZrk_VPMADD52LUQZrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1053
  {DBGFIELD("VPLZCNTDZ128rr_VPLZCNTDZ128rrk_VPLZCNTDZ128rrkz_VPLZCNTQZ128rr_VPLZCNTQZ128rrk_VPLZCNTQZ128rrkz_VPSHLDDZ128rri_VPSHLDDZ128rrik_VPSHLDDZ128rrikz_VPSHLDQZ128rri_VPSHLDQZ128rrik_VPSHLDQZ128rrikz_VPSHLDVDZ128rk_VPSHLDVDZ128rkz_VPSHLDVQZ128rk_VPSHLDVQZ128rkz_VPSHLDVWZ128rk_VPSHLDVWZ128rkz_VPSHLDWZ128rri_VPSHLDWZ128rrik_VPSHLDWZ128rrikz_VPSHRDDZ128rri_VPSHRDDZ128rrik_VPSHRDDZ128rrikz_VPSHRDQZ128rri_VPSHRDQZ128rrik_VPSHRDQZ128rrikz_VPSHRDVDZ128rk_VPSHRDVDZ128rkz_VPSHRDVQZ128rk_VPSHRDVQZ128rkz_VPSHRDVWZ128rk_VPSHRDVWZ128rkz_VPSHRDWZ128rri_VPSHRDWZ128rrik_VPSHRDWZ128rrikz_VPSHUFBITQMBZ128rr_VPSHUFBITQMBZ128rrk") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #1054
  {DBGFIELD("VPLZCNTDZ256rr_VPLZCNTDZ256rrk_VPLZCNTDZ256rrkz_VPLZCNTQZ256rr_VPLZCNTQZ256rrk_VPLZCNTQZ256rrkz_VPSHLDDZ256rri_VPSHLDDZ256rrik_VPSHLDDZ256rrikz_VPSHLDQZ256rri_VPSHLDQZ256rrik_VPSHLDQZ256rrikz_VPSHLDVDZ256rk_VPSHLDVDZ256rkz_VPSHLDVQZ256rk_VPSHLDVQZ256rkz_VPSHLDVWZ256rk_VPSHLDVWZ256rkz_VPSHLDWZ256rri_VPSHLDWZ256rrik_VPSHLDWZ256rrikz_VPSHRDDZ256rri_VPSHRDDZ256rrik_VPSHRDDZ256rrikz_VPSHRDQZ256rri_VPSHRDQZ256rrik_VPSHRDQZ256rrikz_VPSHRDVDZ256rk_VPSHRDVDZ256rkz_VPSHRDVQZ256rk_VPSHRDVQZ256rkz_VPSHRDVWZ256rk_VPSHRDVWZ256rkz_VPSHRDWZ256rri_VPSHRDWZ256rrik_VPSHRDWZ256rrikz") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #1055
  {DBGFIELD("VPLZCNTDZrr_VPLZCNTDZrrk_VPLZCNTDZrrkz_VPLZCNTQZrr_VPLZCNTQZrrk_VPLZCNTQZrrkz_VPSHLDDZrri_VPSHLDDZrrik_VPSHLDDZrrikz_VPSHLDQZrri_VPSHLDQZrrik_VPSHLDQZrrikz_VPSHLDVDZrk_VPSHLDVDZrkz_VPSHLDVQZrk_VPSHLDVQZrkz_VPSHLDVWZrk_VPSHLDVWZrkz_VPSHLDWZrri_VPSHLDWZrrik_VPSHLDWZrrikz_VPSHRDDZrri_VPSHRDDZrrik_VPSHRDDZrrikz_VPSHRDQZrri_VPSHRDQZrrik_VPSHRDQZrrikz_VPSHRDVDZrk_VPSHRDVDZrkz_VPSHRDVQZrk_VPSHRDVQZrkz_VPSHRDVWZrk_VPSHRDVWZrkz_VPSHRDWZrri_VPSHRDWZrrik_VPSHRDWZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1056
  {DBGFIELD("PSLLDrr_PSLLQrr_PSLLWrr_PSRADrr_PSRAWrr_PSRLDrr_PSRLQrr_PSRLWrr_VPSLLDZ128rr_VPSLLDZ128rrk_VPSLLDZ128rrkz_VPSLLDrr_VPSLLQZ128rr_VPSLLQZ128rrk_VPSLLQZ128rrkz_VPSLLQrr_VPSLLWZ128rr_VPSLLWZ128rrk_VPSLLWZ128rrkz_VPSLLWrr_VPSRADZ128rr_VPSRADZ128rrk_VPSRADZ128rrkz_VPSRADrr_VPSRAQZ128rr_VPSRAQZ128rrk_VPSRAQZ128rrkz_VPSRAWZ128rr_VPSRAWZ128rrk_VPSRAWZ128rrkz_VPSRAWrr_VPSRLDZ128rr_VPSRLDZ128rrk_VPSRLDZ128rrkz_VPSRLDrr_VPSRLQZ128rr_VPSRLQZ128rrk_VPSRLQZ128rrkz_VPSRLQrr_VPSRLWZ128rr_VPSRLWZ128rrk_VPSRLWZ128rrkz_VPSRLWrr") 2, false, false, false, 531, 6, 12, 1,  0, 0}, // #1057
  {DBGFIELD("VPSLLDYrr_VPSLLDZ256rr_VPSLLDZ256rrk_VPSLLDZ256rrkz_VPSLLQYrr_VPSLLQZ256rr_VPSLLQZ256rrk_VPSLLQZ256rrkz_VPSLLWYrr_VPSLLWZ256rr_VPSLLWZ256rrk_VPSLLWZ256rrkz_VPSRADYrr_VPSRADZ256rr_VPSRADZ256rrk_VPSRADZ256rrkz_VPSRAQZ256rr_VPSRAQZ256rrk_VPSRAQZ256rrkz_VPSRAWYrr_VPSRAWZ256rr_VPSRAWZ256rrk_VPSRAWZ256rrkz_VPSRLDYrr_VPSRLDZ256rr_VPSRLDZ256rrk_VPSRLDZ256rrkz_VPSRLQYrr_VPSRLQZ256rr_VPSRLQZ256rrk_VPSRLQZ256rrkz_VPSRLWYrr_VPSRLWZ256rr_VPSRLWZ256rrk_VPSRLWZ256rrkz") 2, false, false, false, 183, 9, 14, 1,  0, 0}, // #1058
  {DBGFIELD("VPSLLDZrr_VPSLLDZrrk_VPSLLDZrrkz_VPSLLQZrr_VPSLLQZrrk_VPSLLQZrrkz_VPSLLWZrr_VPSLLWZrrk_VPSLLWZrrkz_VPSRADZrr_VPSRADZrrk_VPSRADZrrkz_VPSRAQZrr_VPSRAQZrrk_VPSRAQZrrkz_VPSRAWZrr_VPSRAWZrrk_VPSRAWZrrkz_VPSRLDZrr_VPSRLDZrrk_VPSRLDZrrkz_VPSRLQZrr_VPSRLQZrrk_VPSRLQZrrkz_VPSRLWZrr_VPSRLWZrrk_VPSRLWZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1059
  {DBGFIELD("VPSLLDQYri_VPSRLDQYri_VPSLLDQZ256ri_VPSRLDQZ256ri") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1060
  {DBGFIELD("PSLLDQri_PSRLDQri_VPSLLDQri_VPSRLDQri") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1061
  {DBGFIELD("VPSLLDQZri_VPSRLDQZri") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1062
  {DBGFIELD("VPSHUFBYrr_VPSHUFBZ256rr_VPSHUFBZ256rrk_VPSHUFBZ256rrkz") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1063
  {DBGFIELD("VPSHUFBZ128rr_VPSHUFBZ128rrk_VPSHUFBZ128rrkz") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1064
  {DBGFIELD("VPSHUFBZrr_VPSHUFBZrrk_VPSHUFBZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1065
  {DBGFIELD("VPROLVDZ128rr_VPROLVDZ128rrk_VPROLVDZ128rrkz_VPROLVQZ128rr_VPROLVQZ128rrk_VPROLVQZ128rrkz_VPRORVDZ128rr_VPRORVDZ128rrk_VPRORVDZ128rrkz_VPRORVQZ128rr_VPRORVQZ128rrk_VPRORVQZ128rrkz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1066
  {DBGFIELD("VPROLVDZ256rr_VPROLVDZ256rrk_VPROLVDZ256rrkz_VPROLVQZ256rr_VPROLVQZ256rrk_VPROLVQZ256rrkz_VPRORVDZ256rr_VPRORVDZ256rrk_VPRORVDZ256rrkz_VPRORVQZ256rr_VPRORVQZ256rrk_VPRORVQZ256rrkz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1067
  {DBGFIELD("VPROLVDZrr_VPROLVDZrrk_VPROLVDZrrkz_VPROLVQZrr_VPROLVQZrrk_VPROLVQZrrkz_VPRORVDZrr_VPRORVDZrrk_VPRORVDZrrkz_VPRORVQZrr_VPRORVQZrrk_VPRORVQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1068
  {DBGFIELD("VPROLDZ256ri_VPROLDZ256rik_VPROLDZ256rikz_VPROLQZ256ri_VPROLQZ256rik_VPROLQZ256rikz_VPRORDZ256ri_VPRORDZ256rik_VPRORDZ256rikz_VPRORQZ256ri_VPRORQZ256rik_VPRORQZ256rikz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1069
  {DBGFIELD("VPROLDZ128ri_VPROLDZ128rik_VPROLDZ128rikz_VPROLQZ128ri_VPROLQZ128rik_VPROLQZ128rikz_VPRORDZ128ri_VPRORDZ128rik_VPRORDZ128rikz_VPRORQZ128ri_VPRORQZ128rik_VPRORQZ128rikz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1070
  {DBGFIELD("VPROLDZri_VPROLDZrik_VPROLDZrikz_VPROLQZri_VPROLQZrik_VPROLQZrikz_VPRORDZri_VPRORDZrik_VPRORDZrikz_VPRORQZri_VPRORQZrik_VPRORQZrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1071
  {DBGFIELD("VFMSUB231SSZr_Intkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1072
  {DBGFIELD("VPSLLDZ128ri_VPSLLDZ128rik_VPSLLDZ128rikz_VPSLLQZ128ri_VPSLLQZ128rik_VPSLLQZ128rikz_VPSLLWZ128ri_VPSLLWZ128rik_VPSLLWZ128rikz_VPSRADZ128ri_VPSRADZ128rik_VPSRADZ128rikz_VPSRAQZ128ri_VPSRAQZ128rik_VPSRAQZ128rikz_VPSRAWZ128ri_VPSRAWZ128rik_VPSRAWZ128rikz_VPSRLDZ128ri_VPSRLDZ128rik_VPSRLDZ128rikz_VPSRLQZ128ri_VPSRLQZ128rik_VPSRLQZ128rikz_VPSRLWZ128ri_VPSRLWZ128rik_VPSRLWZ128rikz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1073
  {DBGFIELD("VPSLLDZ256ri_VPSLLDZ256rik_VPSLLDZ256rikz_VPSLLQZ256ri_VPSLLQZ256rik_VPSLLQZ256rikz_VPSLLWZ256ri_VPSLLWZ256rik_VPSLLWZ256rikz_VPSRADZ256ri_VPSRADZ256rik_VPSRADZ256rikz_VPSRAQZ256ri_VPSRAQZ256rik_VPSRAQZ256rikz_VPSRAWZ256ri_VPSRAWZ256rik_VPSRAWZ256rikz_VPSRLDZ256ri_VPSRLDZ256rik_VPSRLDZ256rikz_VPSRLQZ256ri_VPSRLQZ256rik_VPSRLQZ256rikz_VPSRLWZ256ri_VPSRLWZ256rik_VPSRLWZ256rikz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1074
  {DBGFIELD("VPSLLDZri_VPSLLDZrik_VPSLLDZrikz_VPSLLQZri_VPSLLQZrik_VPSLLQZrikz_VPSLLWZri_VPSLLWZrik_VPSLLWZrikz_VPSRADZri_VPSRADZrik_VPSRADZrikz_VPSRAQZri_VPSRAQZrik_VPSRAQZrikz_VPSRAWZri_VPSRAWZrik_VPSRAWZrikz_VPSRLDZri_VPSRLDZrik_VPSRLDZrikz_VPSRLQZri_VPSRLQZrik_VPSRLQZrikz_VPSRLWZri_VPSRLWZrik_VPSRLWZrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1075
  {DBGFIELD("PALIGNRrri_VPALIGNRZ128rri_VPALIGNRZ128rrik_VPALIGNRZ128rrikz_VPALIGNRrri") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1076
  {DBGFIELD("VPALIGNRZ256rri_VPALIGNRZ256rrik_VPALIGNRZ256rrikz") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1077
  {DBGFIELD("VPALIGNRZrri_VPALIGNRZrrik_VPALIGNRZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1078
  {DBGFIELD("PACKSSDWrr_PACKSSWBrr_PACKUSDWrr_PACKUSWBrr_VPACKSSDWZ128rr_VPACKSSDWZ128rrk_VPACKSSDWZ128rrkz_VPACKSSDWrr_VPACKSSWBZ128rr_VPACKSSWBZ128rrk_VPACKSSWBZ128rrkz_VPACKSSWBrr_VPACKUSDWZ128rr_VPACKUSDWZ128rrk_VPACKUSDWZ128rrkz_VPACKUSDWrr_VPACKUSWBZ128rr_VPACKUSWBZ128rrk_VPACKUSWBZ128rrkz_VPACKUSWBrr") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1079
  {DBGFIELD("VPACKSSDWZ256rr_VPACKSSDWZ256rrk_VPACKSSDWZ256rrkz_VPACKSSWBZ256rr_VPACKSSWBZ256rrk_VPACKSSWBZ256rrkz_VPACKUSDWZ256rr_VPACKUSDWZ256rrk_VPACKUSDWZ256rrkz_VPACKUSWBZ256rr_VPACKUSWBZ256rrk_VPACKUSWBZ256rrkz") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1080
  {DBGFIELD("VPACKSSDWZrr_VPACKSSDWZrrk_VPACKSSDWZrrkz_VPACKSSWBZrr_VPACKSSWBZrrk_VPACKSSWBZrrkz_VPACKUSDWZrr_VPACKUSDWZrrk_VPACKUSDWZrrkz_VPACKUSWBZrr_VPACKUSWBZrrk_VPACKUSWBZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1081
  {DBGFIELD("CMPPDrri_VCMPPDrri_VMAXCPDZ128rr_VMAXCPDZ128rrk_VMAXCPDZ128rrkz_VMAXPDZ128rr_VMAXPDZ128rrk_VMAXPDZ128rrkz_VMINCPDZ128rr_VMINCPDZ128rrk_VMINCPDZ128rrkz_VMINPDZ128rr_VMINPDZ128rrk_VMINPDZ128rrkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1082
  {DBGFIELD("CMPPSrri_VCMPPSrri") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1083
  {DBGFIELD("CMPSDrr_CMPSDrr_Int_VCMPSDrr_VCMPSDrr_Int_MAXSDrr_Int_MINSDrr_Int_VMAXSDZrr_Int_VMAXSDZrr_Intk_VMAXSDZrr_Intkz_VMAXSDrr_Int_VMINSDZrr_Int_VMINSDZrr_Intk_VMINSDZrr_Intkz_VMINSDrr_Int") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1084
  {DBGFIELD("CMPSSrr_CMPSSrr_Int_VCMPSSrr_VCMPSSrr_Int_MAXSSrr_Int_MINSSrr_Int_VMAXSSZrr_Int_VMAXSSZrr_Intk_VMAXSSZrr_Intkz_VMAXSSrr_Int_VMINSSZrr_Int_VMINSSZrr_Intk_VMINSSZrr_Intkz_VMINSSrr_Int") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1085
  {DBGFIELD("VPMAXSQZ128rr_VPMAXSQZ128rrk_VPMAXSQZ128rrkz_VPMAXUQZ128rr_VPMAXUQZ128rrk_VPMAXUQZ128rrkz_VPMINSQZ128rr_VPMINSQZ128rrk_VPMINSQZ128rrkz_VPMINUQZ128rr_VPMINUQZ128rrk_VPMINUQZ128rrkz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1086
  {DBGFIELD("VPMAXSQZ256rr_VPMAXSQZ256rrk_VPMAXSQZ256rrkz_VPMAXUQZ256rr_VPMAXUQZ256rrk_VPMAXUQZ256rrkz_VPMINSQZ256rr_VPMINSQZ256rrk_VPMINSQZ256rrkz_VPMINUQZ256rr_VPMINUQZ256rrk_VPMINUQZ256rrkz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1087
  {DBGFIELD("VPMAXSQZrr_VPMAXSQZrrk_VPMAXSQZrrkz_VPMAXUQZrr_VPMAXUQZrrk_VPMAXUQZrrkz_VPMINSQZrr_VPMINSQZrrk_VPMINSQZrrkz_VPMINUQZrr_VPMINUQZrrk_VPMINUQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1088
  {DBGFIELD("VMAXCPDZ256rr_VMAXCPDZ256rrk_VMAXCPDZ256rrkz_VMAXPDZ256rr_VMAXPDZ256rrk_VMAXPDZ256rrkz_VMINCPDZ256rr_VMINCPDZ256rrk_VMINCPDZ256rrkz_VMINPDZ256rr_VMINPDZ256rrk_VMINPDZ256rrkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1089
  {DBGFIELD("VMAXCPDZrr_VMAXCPDZrrk_VMAXCPDZrrkz_VMAXPDZrr_VMAXPDZrrb_VMAXPDZrrbk_VMAXPDZrrbkz_VMAXPDZrrk_VMAXPDZrrkz_VMINCPDZrr_VMINCPDZrrk_VMINCPDZrrkz_VMINPDZrr_VMINPDZrrb_VMINPDZrrbk_VMINPDZrrbkz_VMINPDZrrk_VMINPDZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1090
  {DBGFIELD("VPMOVSXBDZ128rr_VPMOVSXBDZ128rrk_VPMOVSXBDZ128rrkz_VPMOVSXBQZ128rr_VPMOVSXBQZ128rrk_VPMOVSXBQZ128rrkz_VPMOVSXBWZ128rr_VPMOVSXBWZ128rrk_VPMOVSXBWZ128rrkz_VPMOVSXDQZ128rr_VPMOVSXDQZ128rrk_VPMOVSXDQZ128rrkz_VPMOVSXWDZ128rr_VPMOVSXWDZ128rrk_VPMOVSXWDZ128rrkz_VPMOVSXWQZ128rr_VPMOVSXWQZ128rrk_VPMOVSXWQZ128rrkz_VPMOVZXBDZ128rr_VPMOVZXBDZ128rrk_VPMOVZXBDZ128rrkz_VPMOVZXBQZ128rr_VPMOVZXBQZ128rrk_VPMOVZXBQZ128rrkz_VPMOVZXBWZ128rr_VPMOVZXBWZ128rrk_VPMOVZXBWZ128rrkz_VPMOVZXDQZ128rr_VPMOVZXDQZ128rrk_VPMOVZXDQZ128rrkz_VPMOVZXWDZ128rr_VPMOVZXWDZ128rrk_VPMOVZXWDZ128rrkz_VPMOVZXWQZ128rr_VPMOVZXWQZ128rrk_VPMOVZXWQZ128rrkz") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1091
  {DBGFIELD("VPMOVSXBDZ256rr_VPMOVSXBDZ256rrk_VPMOVSXBDZ256rrkz_VPMOVSXBQZ256rr_VPMOVSXBQZ256rrk_VPMOVSXBQZ256rrkz_VPMOVSXBWZ256rr_VPMOVSXBWZ256rrk_VPMOVSXBWZ256rrkz_VPMOVSXDQZ256rr_VPMOVSXDQZ256rrk_VPMOVSXDQZ256rrkz_VPMOVSXWDZ256rr_VPMOVSXWDZ256rrk_VPMOVSXWDZ256rrkz_VPMOVSXWQZ256rr_VPMOVSXWQZ256rrk_VPMOVSXWQZ256rrkz_VPMOVZXBDZ256rr_VPMOVZXBDZ256rrk_VPMOVZXBDZ256rrkz_VPMOVZXBQZ256rr_VPMOVZXBQZ256rrk_VPMOVZXBQZ256rrkz_VPMOVZXBWZ256rr_VPMOVZXBWZ256rrk_VPMOVZXBWZ256rrkz_VPMOVZXDQZ256rr_VPMOVZXDQZ256rrk_VPMOVZXDQZ256rrkz_VPMOVZXWDZ256rr_VPMOVZXWDZ256rrk_VPMOVZXWDZ256rrkz_VPMOVZXWQZ256rr_VPMOVZXWQZ256rrk_VPMOVZXWQZ256rrkz_VPMOVSXBDYrr_VPMOVSXBQYrr_VPMOVSXBWYrr_VPMOVZXBDYrr_VPMOVZXBQYrr_VPMOVZXBWYrr_VPMOVSXDQYrr_VPMOVSXWDYrr_VPMOVSXWQYrr_VPMOVUSQWZ128rr_VPMOVUSQWZ128rrk_VPMOVUSQWZ128rrkz_VPMOVZXDQYrr_VPMOVZXWDYrr_VPMOVZXWQYrr_VPMOVDBZ128rr_VPMOVDBZ128rrk_VPMOVDBZ128rrkz_VPMOVDWZ128rr_VPMOVDWZ128rrk_VPMOVDWZ128rrkz_VPMOVQBZ128rr_VPMOVQBZ128rrk_VPMOVQBZ128rrkz_VPMOVQDZ128rr_VPMOVQDZ128rrk_VPMOVQDZ128rrkz_VPMOVQWZ128rr_VPMOVQWZ128rrk_VPMOVQWZ128rrkz_VPMOVSDBZ128rr_VPMOVSDBZ128rrk_VPMOVSDBZ128rrkz_VPMOVSDWZ128rr_VPMOVSDWZ128rrk_VPMOVSDWZ128rrkz_VPMOVSQBZ128rr_VPMOVSQBZ128rrk_VPMOVSQBZ128rrkz_VPMOVSQDZ128rr_VPMOVSQDZ128rrk_VPMOVSQDZ128rrkz_VPMOVSQWZ128rr_VPMOVSQWZ128rrk_VPMOVSQWZ128rrkz_VPMOVSWBZ128rr_VPMOVSWBZ128rrk_VPMOVSWBZ128rrkz_VPMOVUSDBZ128rr_VPMOVUSDBZ128rrk_VPMOVUSDBZ128rrkz_VPMOVUSDWZ128rr_VPMOVUSDWZ128rrk_VPMOVUSDWZ128rrkz_VPMOVUSQBZ128rr_VPMOVUSQBZ128rrk_VPMOVUSQBZ128rrkz_VPMOVUSQDZ128rr_VPMOVUSQDZ128rrk_VPMOVUSQDZ128rrkz_VPMOVUSWBZ128rr_VPMOVUSWBZ128rrk_VPMOVUSWBZ128rrkz_VPMOVWBZ128rr_VPMOVWBZ128rrk_VPMOVWBZ128rrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1092
  {DBGFIELD("VMOVDDUPZ128rr_VMOVDDUPZ128rrk_VMOVDDUPZ128rrkz") 1, false, false, false, 60, 8,  1, 1,  0, 0}, // #1093
  {DBGFIELD("VMOVDDUPZ256rr_VMOVDDUPZ256rrk_VMOVDDUPZ256rrkz") 1, false, false, false, 60, 8,  1, 1,  0, 0}, // #1094
  {DBGFIELD("VMOVDDUPZrr_VMOVDDUPZrrk_VMOVDDUPZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1095
  {DBGFIELD("PMOVSXBDrr_PMOVSXBQrr_PMOVSXBWrr_PMOVSXDQrr_PMOVSXWDrr_PMOVSXWQrr_PMOVZXBDrr_PMOVZXBQrr_PMOVZXBWrr_PMOVZXDQrr_PMOVZXWDrr_PMOVZXWQrr_VPMOVSXBDrr_VPMOVSXBQrr_VPMOVSXBWrr_VPMOVSXDQrr_VPMOVSXWDrr_VPMOVSXWQrr_VPMOVZXBDrr_VPMOVZXBQrr_VPMOVZXBWrr_VPMOVZXDQrr_VPMOVZXWDrr_VPMOVZXWQrr") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1096
  {DBGFIELD("VPMOVSXBDZrr_VPMOVSXBDZrrk_VPMOVSXBDZrrkz_VPMOVSXBQZrr_VPMOVSXBQZrrk_VPMOVSXBQZrrkz_VPMOVSXBWZrr_VPMOVSXBWZrrk_VPMOVSXBWZrrkz_VPMOVSXDQZrr_VPMOVSXDQZrrk_VPMOVSXDQZrrkz_VPMOVSXWDZrr_VPMOVSXWDZrrk_VPMOVSXWDZrrkz_VPMOVSXWQZrr_VPMOVSXWQZrrk_VPMOVSXWQZrrkz_VPMOVZXBDZrr_VPMOVZXBDZrrk_VPMOVZXBDZrrkz_VPMOVZXBQZrr_VPMOVZXBQZrrk_VPMOVZXBQZrrkz_VPMOVZXBWZrr_VPMOVZXBWZrrk_VPMOVZXBWZrrkz_VPMOVZXDQZrr_VPMOVZXDQZrrk_VPMOVZXDQZrrkz_VPMOVZXWDZrr_VPMOVZXWDZrrk_VPMOVZXWDZrrkz_VPMOVZXWQZrr_VPMOVZXWQZrrk_VPMOVZXWQZrrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1097
  {DBGFIELD("VPMOVDBZrr_VPMOVDBZrrk_VPMOVDBZrrkz_VPMOVQBZrr_VPMOVQBZrrk_VPMOVQBZrrkz_VPMOVQWZrr_VPMOVQWZrrk_VPMOVQWZrrkz_VPMOVSDBZrr_VPMOVSDBZrrk_VPMOVSDBZrrkz_VPMOVSQBZrr_VPMOVSQBZrrk_VPMOVSQBZrrkz_VPMOVSQWZrr_VPMOVSQWZrrk_VPMOVSQWZrrkz_VPMOVUSDBZrr_VPMOVUSDBZrrk_VPMOVUSDBZrrkz_VPMOVUSQBZrr_VPMOVUSQBZrrk_VPMOVUSQBZrrkz_VPMOVUSQWZrr_VPMOVUSQWZrrk_VPMOVUSQWZrrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1098
  {DBGFIELD("VPTESTMBZ128rrk_VPTESTMDZ128rrk_VPTESTMQZ128rrk_VPTESTMWZ128rrk_VPTESTNMBZ128rrk_VPTESTNMDZ128rrk_VPTESTNMQZ128rrk_VPTESTNMWZ128rrk") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1099
  {DBGFIELD("VPTESTMBZ256rr_VPTESTMBZ256rrk_VPTESTMDZ256rr_VPTESTMDZ256rrk_VPTESTMQZ256rr_VPTESTMQZ256rrk_VPTESTMWZ256rr_VPTESTMWZ256rrk_VPTESTNMBZ256rr_VPTESTNMBZ256rrk_VPTESTNMDZ256rr_VPTESTNMDZ256rrk_VPTESTNMQZ256rr_VPTESTNMQZ256rrk_VPTESTNMWZ256rr_VPTESTNMWZ256rrk") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1100
  {DBGFIELD("VPTESTMBZrrk_VPTESTMDZrrk_VPTESTMQZrrk_VPTESTMWZrrk_VPTESTNMBZrrk_VPTESTNMDZrrk_VPTESTNMQZrrk_VPTESTNMWZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1101
  {DBGFIELD("VPCONFLICTDZ128rr_VPCONFLICTDZ128rrk_VPCONFLICTDZ128rrkz_VPCONFLICTQZ128rr_VPCONFLICTQZ128rrk_VPCONFLICTQZ128rrkz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1102
  {DBGFIELD("VPCONFLICTDZ256rr_VPCONFLICTDZ256rrk_VPCONFLICTDZ256rrkz_VPCONFLICTQZ256rr_VPCONFLICTQZ256rrk_VPCONFLICTQZ256rrkz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1103
  {DBGFIELD("VPCONFLICTDZrr_VPCONFLICTDZrrk_VPCONFLICTDZrrkz_VPCONFLICTQZrr_VPCONFLICTQZrrk_VPCONFLICTQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1104
  {DBGFIELD("VRSQRT14PDZ128r_VRSQRT14PDZ128rk_VRSQRT14PDZ128rkz_VRSQRT14PSZ128r_VRSQRT14PSZ128rk_VRSQRT14PSZ128rkz") 1, false, false, false,  2, 8, 14, 1,  0, 0}, // #1105
  {DBGFIELD("VRSQRT14PDZ256r_VRSQRT14PDZ256rk_VRSQRT14PDZ256rkz_VRSQRT14PSZ256r_VRSQRT14PSZ256rk_VRSQRT14PSZ256rkz") 1, false, false, false,  2, 8, 14, 1,  0, 0}, // #1106
  {DBGFIELD("VRSQRT14PDZr_VRSQRT14PDZrk_VRSQRT14PDZrkz_VRSQRT14PSZr_VRSQRT14PSZrk_VRSQRT14PSZrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1107
  {DBGFIELD("VPERMILPDYrr_VPERMILPDZ256rr_VPERMILPDZ256rrk_VPERMILPDZ256rrkz_VPERMILPSYrr_VPERMILPSZ256rr_VPERMILPSZ256rrk_VPERMILPSZ256rrkz") 1, false, false, false, 60, 8,  1, 1,  0, 0}, // #1108
  {DBGFIELD("VPERMILPDZ128rr_VPERMILPDZ128rrk_VPERMILPDZ128rrkz_VPERMILPSZ128rr_VPERMILPSZ128rrk_VPERMILPSZ128rrkz") 1, false, false, false, 60, 8,  1, 1,  0, 0}, // #1109
  {DBGFIELD("VPERMILPDZrr_VPERMILPDZrrk_VPERMILPDZrrkz_VPERMILPSZrr_VPERMILPSZrrk_VPERMILPSZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1110
  {DBGFIELD("VPERMI2PD128rr_VPERMI2PD128rrk_VPERMI2PD128rrkz_VPERMI2PS128rr_VPERMI2PS128rrk_VPERMI2PS128rrkz_VPERMT2PD128rr_VPERMT2PD128rrk_VPERMT2PD128rrkz_VPERMT2PS128rr_VPERMT2PS128rrk_VPERMT2PS128rrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1111
  {DBGFIELD("VPERMI2W128rr_VPERMI2W128rrk_VPERMI2W128rrkz_VPERMT2W128rr_VPERMT2W128rrk_VPERMT2W128rrkz_VPERMI2B128rr_VPERMI2B128rrk_VPERMI2B128rrkz_VPERMI2D128rr_VPERMI2D128rrk_VPERMI2D128rrkz_VPERMI2Q128rr_VPERMI2Q128rrk_VPERMI2Q128rrkz_VPERMT2B128rr_VPERMT2B128rrk_VPERMT2B128rrkz_VPERMT2D128rr_VPERMT2D128rrk_VPERMT2D128rrkz_VPERMT2Q128rr_VPERMT2Q128rrk_VPERMT2Q128rrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1112
  {DBGFIELD("VCOMPRESSPDZ128rr_VCOMPRESSPDZ128rrk_VCOMPRESSPDZ128rrkz_VCOMPRESSPSZ128rr_VCOMPRESSPSZ128rrk_VCOMPRESSPSZ128rrkz_VPCOMPRESSBZ128rr_VPCOMPRESSBZ128rrk_VPCOMPRESSBZ128rrkz_VPCOMPRESSDZ128rr_VPCOMPRESSDZ128rrk_VPCOMPRESSDZ128rrkz_VPCOMPRESSQZ128rr_VPCOMPRESSQZ128rrk_VPCOMPRESSQZ128rrkz_VPCOMPRESSWZ128rr_VPCOMPRESSWZ128rrk_VPCOMPRESSWZ128rrkz_VPERMBZ128rr_VPERMBZ128rrk_VPERMBZ128rrkz_VPERMWZ128rr_VPERMWZ128rrk_VPERMWZ128rrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1113
  {DBGFIELD("VPERMI2PD256rr_VPERMI2PD256rrk_VPERMI2PD256rrkz_VPERMI2PS256rr_VPERMI2PS256rrk_VPERMI2PS256rrkz_VPERMT2PD256rr_VPERMT2PD256rrk_VPERMT2PD256rrkz_VPERMT2PS256rr_VPERMT2PS256rrk_VPERMT2PS256rrkz_VPERMPDZ256rr_VPERMPDZ256rrk_VPERMPDZ256rrkz_VPERMPSZ256rr_VPERMPSZ256rrk_VPERMPSZ256rrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1114
  {DBGFIELD("VPERMI2W256rr_VPERMI2W256rrk_VPERMI2W256rrkz_VPERMT2W256rr_VPERMT2W256rrk_VPERMT2W256rrkz_VCOMPRESSPDZ256rr_VCOMPRESSPDZ256rrk_VCOMPRESSPDZ256rrkz_VCOMPRESSPSZ256rr_VCOMPRESSPSZ256rrk_VCOMPRESSPSZ256rrkz_VPCOMPRESSBZ256rr_VPCOMPRESSBZ256rrk_VPCOMPRESSBZ256rrkz_VPCOMPRESSDZ256rr_VPCOMPRESSDZ256rrk_VPCOMPRESSDZ256rrkz_VPCOMPRESSQZ256rr_VPCOMPRESSQZ256rrk_VPCOMPRESSQZ256rrkz_VPCOMPRESSWZ256rr_VPCOMPRESSWZ256rrk_VPCOMPRESSWZ256rrkz_VPERMBZ256rr_VPERMBZ256rrk_VPERMBZ256rrkz_VPERMDZ256rr_VPERMDZ256rrk_VPERMDZ256rrkz_VPERMQZ256rr_VPERMQZ256rrk_VPERMQZ256rrkz_VPERMWZ256rr_VPERMWZ256rrk_VPERMWZ256rrkz_VPERMI2B256rr_VPERMI2B256rrk_VPERMI2B256rrkz_VPERMI2D256rr_VPERMI2D256rrk_VPERMI2D256rrkz_VPERMI2Q256rr_VPERMI2Q256rrk_VPERMI2Q256rrkz_VPERMT2B256rr_VPERMT2B256rrk_VPERMT2B256rrkz_VPERMT2D256rr_VPERMT2D256rrk_VPERMT2D256rrkz_VPERMT2Q256rr_VPERMT2Q256rrk_VPERMT2Q256rrkz_VPEXPANDBZ256rr_VPEXPANDBZ256rrk_VPEXPANDBZ256rrkz_VPEXPANDWZ256rr_VPEXPANDWZ256rrk_VPEXPANDWZ256rrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1115
  {DBGFIELD("VPERMI2PDrr_VPERMI2PDrrk_VPERMI2PDrrkz_VPERMI2PSrr_VPERMI2PSrrk_VPERMI2PSrrkz_VPERMT2PDrr_VPERMT2PDrrk_VPERMT2PDrrkz_VPERMT2PSrr_VPERMT2PSrrk_VPERMT2PSrrkz_VPERMPDZrr_VPERMPDZrrk_VPERMPDZrrkz_VPERMPSZrr_VPERMPSZrrk_VPERMPSZrrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1116
  {DBGFIELD("VPERMI2Wrr_VPERMI2Wrrk_VPERMI2Wrrkz_VPERMT2Wrr_VPERMT2Wrrk_VPERMT2Wrrkz_VPERMBZrr_VPERMBZrrk_VPERMBZrrkz_VPERMDZrr_VPERMDZrrk_VPERMDZrrkz_VPERMWZrr_VPERMWZrrk_VPERMWZrrkz_VPERMI2Brr_VPERMI2Brrk_VPERMI2Brrkz_VPERMI2Drr_VPERMI2Drrk_VPERMI2Drrkz_VPERMI2Qrr_VPERMI2Qrrk_VPERMI2Qrrkz_VPERMT2Brr_VPERMT2Brrk_VPERMT2Brrkz_VPERMT2Drr_VPERMT2Drrk_VPERMT2Drrkz_VPERMT2Qrr_VPERMT2Qrrk_VPERMT2Qrrkz_VCOMPRESSPDZrr_VCOMPRESSPDZrrk_VCOMPRESSPDZrrkz_VCOMPRESSPSZrr_VCOMPRESSPSZrrk_VCOMPRESSPSZrrkz_VPCOMPRESSBZrr_VPCOMPRESSBZrrk_VPCOMPRESSBZrrkz_VPCOMPRESSDZrr_VPCOMPRESSDZrrk_VPCOMPRESSDZrrkz_VPCOMPRESSQZrr_VPCOMPRESSQZrrk_VPCOMPRESSQZrrkz_VPCOMPRESSWZrr_VPCOMPRESSWZrrk_VPCOMPRESSWZrrkz_VPEXPANDBZrr_VPEXPANDBZrrk_VPEXPANDBZrrkz_VPEXPANDWZrr_VPEXPANDWZrrk_VPEXPANDWZrrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1117
  {DBGFIELD("VPABSBZ128rr_VPABSBZ128rrk_VPABSBZ128rrkz_VPABSDZ128rr_VPABSDZ128rrk_VPABSDZ128rrkz_VPABSQZ128rr_VPABSQZ128rrk_VPABSQZ128rrkz_VPABSWZ128rr_VPABSWZ128rrk_VPABSWZ128rrkz_VPADDSBZ128rr_VPADDSBZ128rrk_VPADDSBZ128rrkz_VPADDSWZ128rr_VPADDSWZ128rrk_VPADDSWZ128rrkz_VPADDUSBZ128rr_VPADDUSBZ128rrk_VPADDUSBZ128rrkz_VPADDUSWZ128rr_VPADDUSWZ128rrk_VPADDUSWZ128rrkz_VPAVGBZ128rr_VPAVGBZ128rrk_VPAVGBZ128rrkz_VPAVGWZ128rr_VPAVGWZ128rrk_VPAVGWZ128rrkz_VPOPCNTBZ128rr_VPOPCNTBZ128rrk_VPOPCNTBZ128rrkz_VPOPCNTDZ128rr_VPOPCNTDZ128rrk_VPOPCNTDZ128rrkz_VPOPCNTQZ128rr_VPOPCNTQZ128rrk_VPOPCNTQZ128rrkz_VPOPCNTWZ128rr_VPOPCNTWZ128rrk_VPOPCNTWZ128rrkz_VPSUBSBZ128rr_VPSUBSBZ128rrk_VPSUBSBZ128rrkz_VPSUBSWZ128rr_VPSUBSWZ128rrk_VPSUBSWZ128rrkz_VPSUBUSBZ128rr_VPSUBUSBZ128rrk_VPSUBUSBZ128rrkz_VPSUBUSWZ128rr_VPSUBUSWZ128rrk_VPSUBUSWZ128rrkz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1118
  {DBGFIELD("LSL16rr_LSL32rr_LSL64rr") 15, false, false, false, 1542, 14, 52, 1,  0, 0}, // #1119
  {DBGFIELD("LXADD8_LXADD16_LXADD32_LXADD64") 4, false, false, false, 40, 5,  2, 1,  0, 0}, // #1120
  {DBGFIELD("BLCFILL32rr_BLCFILL64rr_BLCI32rr_BLCI64rr_BLCIC32rr_BLCIC64rr_BLCMSK32rr_BLCMSK64rr_BLCS32rr_BLCS64rr_BLSFILL32rr_BLSFILL64rr_BLSIC32rr_BLSIC64rr_T1MSKC32rr_T1MSKC64rr_TZMSK32rr_TZMSK64rr") 1, false, false, false,  1, 1,  1, 1,  0, 0}, // #1121
  {DBGFIELD("BLCFILL32rm_BLCFILL64rm_BLCI32rm_BLCI64rm_BLCIC32rm_BLCIC64rm_BLCMSK32rm_BLCMSK64rm_BLCS32rm_BLCS64rm_BLSFILL32rm_BLSFILL64rm_BLSIC32rm_BLSIC64rm_T1MSKC32rm_T1MSKC64rm_TZMSK32rm_TZMSK64rm") 1, false, false, false,  1, 1,  8, 1,  0, 0}, // #1122
  {DBGFIELD("ADC64ri32_SBB64ri32") 1, false, false, false, 10, 4,  1, 1,  0, 0}, // #1123
  {DBGFIELD("CRC32r32r16")        1, false, false, false, 30, 7,  5, 1,  0, 0}, // #1124
  {DBGFIELD("CRC32r32r32")        1, false, false, false, 30, 7,  5, 1,  0, 0}, // #1125
  {DBGFIELD("CRC32r64r64")        1, false, false, false, 30, 7,  5, 1,  0, 0}, // #1126
  {DBGFIELD("SAHF")               2, false, false, false, 550, 4, 14, 1,  0, 0}, // #1127
  {DBGFIELD("BEXTRI32ri_BEXTRI64ri") 2, false, false, false, 104, 9,  3, 1,  0, 0}, // #1128
  {DBGFIELD("BEXTRI32mi_BEXTRI64mi") 3, false, false, false, 104, 11,  8, 1,  0, 0}, // #1129
  {DBGFIELD("RCR8ri")             3, false, false, false, 14, 4, 12, 1,  0, 0}, // #1130
  {DBGFIELD("RCL16rCL")           7, false, false, false, 537, 9,  7, 1,  0, 0}, // #1131
  {DBGFIELD("RCR16ri")            3, false, false, false, 14, 4, 12, 1,  0, 0}, // #1132
  {DBGFIELD("RCR32rCL_RCR64rCL")  7, false, false, false, 537, 9,  7, 1,  0, 0}, // #1133
  {DBGFIELD("RCL16ri")            3, false, false, false, 14, 4, 12, 1,  0, 0}, // #1134
  {DBGFIELD("RCL32ri_RCL64ri")    3, false, false, false, 14, 4, 12, 1,  0, 0}, // #1135
  {DBGFIELD("SHLD16rrCL")         3, false, false, false, 342, 9, 10, 1,  0, 0}, // #1136
  {DBGFIELD("VMOVUPDYmr_VMOVUPSYmr") 2, false, false, false, 37, 3,  2, 1,  0, 0}, // #1137
  {DBGFIELD("TST_F")              1, false, false, false,  2, 8, 12, 1,  0, 0}, // #1138
  {DBGFIELD("VDPPSrri")           6, false, false, false, 251, 10, 21, 1,  0, 0}, // #1139
  {DBGFIELD("VFRCZPDrr_VFRCZPSrr") 2, false, false, false, 74, 4,  7, 1,  0, 0}, // #1140
  {DBGFIELD("VFRCZSDrr_VFRCZSSrr") 2, false, false, false, 74, 4,  7, 1,  0, 0}, // #1141
  {DBGFIELD("VFRCZPDrm_VFRCZPSrm_VFRCZSDrm_VFRCZSSrm") 3, false, false, false, 74, 6, 11, 1,  5, 1}, // #1142
  {DBGFIELD("VFRCZPSYrr_VFRCZPDYrr") 2, false, false, false, 74, 4,  7, 1,  0, 0}, // #1143
  {DBGFIELD("VFRCZPSYrm_VFRCZPDYrm") 3, false, false, false, 74, 6, 16, 1,  5, 1}, // #1144
  {DBGFIELD("MMX_CVTTPD2PIrr")    2, false, false, false, 183, 9,  7, 1,  0, 0}, // #1145
  {DBGFIELD("CVTSI2SSrr")         2, false, false, false, 183, 9,  6, 1,  0, 1}, // #1146
  {DBGFIELD("VMOVDQUYmr")         2, false, false, false, 37, 3,  2, 1,  0, 0}, // #1147
  {DBGFIELD("MOVDQArr")           0, false, false, false,  0, 0,  1, 1,  0, 0}, // #1148
  {DBGFIELD("VPMACSDQHrr_VPMACSDQLrr_VPMACSSDQHrr_VPMACSSDQLrr") 2, false, false, false, 74, 4,  9, 1,  0, 0}, // #1149
  {DBGFIELD("VPPERMrrr_VPPERMrrr_REV") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1150
  {DBGFIELD("VPPERMrrm")          2, false, false, false, 53, 7,  7, 1,  9, 2}, // #1151
  {DBGFIELD("VPPERMrmr")          2, false, false, false, 53, 7,  7, 1,  7, 2}, // #1152
  {DBGFIELD("PHADDWrr_PHSUBWrr_PHADDSWrr_PHSUBSWrr_VPHADDDrr_VPHSUBDrr_VPHADDWrr_VPHSUBWrr_VPHADDSWrr_VPHSUBSWrr") 3, false, false, false, 524, 5, 12, 1,  0, 0}, // #1153
  {DBGFIELD("PHADDWrm_PHSUBWrm_PHADDSWrm_PHSUBSWrm_VPHADDDrm_VPHSUBDrm_VPHADDWrm_VPHSUBWrm_VPHADDSWrm_VPHSUBSWrm") 4, false, false, false, 524, 7, 22, 1,  5, 1}, // #1154
  {DBGFIELD("VPCLMULQDQrr")       1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1155
  {DBGFIELD("ANDNPSrr_ANDNPDrr")  1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1156
  {DBGFIELD("MMX_PXORrr_MMX_PANDNrr") 1, false, false, false,  4, 5,  1, 1,  0, 0}, // #1157
  {DBGFIELD("PANDNrr")            1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1158
  {DBGFIELD("MMX_PSUBBrr_MMX_PSUBDrr_MMX_PSUBWrr_MMX_PCMPGTBrr_MMX_PCMPGTDrr_MMX_PCMPGTWrr") 1, false, false, false,  4, 5,  1, 1,  0, 0}, // #1159
  {DBGFIELD("LCMPXCHG16_LCMPXCHG32_LCMPXCHG64") 6, false, false, false, 14, 8,  2, 1,  0, 0}, // #1160
  {DBGFIELD("CMPXCHG16rr_CMPXCHG32rr_CMPXCHG64rr") 5, false, false, false, 169, 4,  5, 1,  0, 0}, // #1161
  {DBGFIELD("LCMPXCHG8B")         6, false, false, false, 14, 8,  2, 1,  0, 0}, // #1162
  {DBGFIELD("XCHG8rr")            3, false, false, false, 15, 1, 12, 1,  0, 0}, // #1163
  {DBGFIELD("MMX_PSUBSBrr_MMX_PSUBSWrr_MMX_PSUBUSBrr_MMX_PSUBUSWrr") 1, false, false, false,  2, 8,  1, 1,  0, 0}, // #1164
  {DBGFIELD("PSUBSBrr_VPSUBSBrr_PSUBSWrr_VPSUBSWrr_PSUBUSBrr_VPSUBUSBrr_PSUBUSWrr_VPSUBUSWrr") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1165
  {DBGFIELD("MMX_PCMPEQBrr_MMX_PCMPEQDrr_MMX_PCMPEQWrr_MMX_PMAXSWrr_MMX_PMINSWrr_MMX_PMAXUBrr_MMX_PMINUBrr") 1, false, false, false,  2, 8,  1, 1,  0, 0}, // #1166
  {DBGFIELD("MMX_PCMPGTBrr_MMX_PCMPGTDrr_MMX_PCMPGTWrr") 1, false, false, false,  2, 8,  1, 1,  0, 0}, // #1167
  {DBGFIELD("CLAC_STAC")          1, false, false, false, 10, 4,  1, 1,  0, 0}, // #1168
  {DBGFIELD("PADDBrr_PADDDrr_PADDWrr_VPADDBrr_VPADDDrr_VPADDQrr_VPADDWrr") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1169
  {DBGFIELD("VPADDBYrr_VPADDDYrr_VPADDQYrr_VPADDWYrr") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1170
  {DBGFIELD("ADD_FPrST0_ADD_FST0r_ADD_FrST0_SUBR_FPrST0_SUBR_FST0r_SUBR_FrST0_SUB_FPrST0_SUB_FST0r_SUB_FrST0") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1171
  {DBGFIELD("MMX_PHADDSWrr_MMX_PHSUBSWrr") 3, false, false, false, 1556, 11,  5, 1,  0, 0}, // #1172
  {DBGFIELD("PHADDSWrr_VPHADDSWrr_PHSUBSWrr_VPHSUBSWrr") 3, false, false, false, 1567, 6, 12, 1,  0, 0}, // #1173
  {DBGFIELD("VPHADDSWYrr_VPHSUBSWYrr") 3, false, false, false, 1567, 6, 12, 1,  0, 0}, // #1174
  {DBGFIELD("MMX_PADDSBrm_MMX_PADDSWrm_MMX_PADDUSBrm_MMX_PADDUSWrm_MMX_PAVGBrm_MMX_PAVGWrm_MMX_PCMPEQBrm_MMX_PCMPEQDrm_MMX_PCMPEQWrm_MMX_PCMPGTBrm_MMX_PCMPGTDrm_MMX_PCMPGTWrm_MMX_PMAXSWrm_MMX_PMAXUBrm_MMX_PMINSWrm_MMX_PMINUBrm_MMX_PSUBSBrm_MMX_PSUBSWrm_MMX_PSUBUSBrm_MMX_PSUBUSWrm") 2, false, false, false, 173, 10, 22, 1,  5, 1}, // #1175
  {DBGFIELD("PADDBrm_PADDDrm_PADDWrm_VPADDBrm_VPADDDrm_VPADDQrm_VPADDWrm_PSUBBrm_PSUBDrm_PSUBWrm_VPSUBBrm_VPSUBDrm_VPSUBQrm_VPSUBWrm") 2, false, false, false, 69, 5,  7, 1,  5, 1}, // #1176
  {DBGFIELD("VCVTSS2SI64rr_VCVTTSS2SI64rr") 3, false, false, false, 666, 11,  7, 1,  0, 0}, // #1177
  {DBGFIELD("VCVTSS2SI64rr_Int_VCVTTSS2SI64rr_Int") 3, false, false, false, 666, 11,  7, 1,  0, 0}, // #1178
  {DBGFIELD("VPADDBYrm_VPADDDYrm_VPADDQYrm_VPADDWYrm_VPSUBBYrm_VPSUBDYrm_VPSUBQYrm_VPSUBWYrm") 2, false, false, false, 69, 5, 22, 1,  5, 1}, // #1179
  {DBGFIELD("MMX_PHADDSWrm_MMX_PHSUBSWrm") 4, false, false, false, 1573, 13,  8, 1,  5, 1}, // #1180
  {DBGFIELD("PHADDSWrm_VPHADDSWrm_PHSUBSWrm_VPHSUBSWrm") 4, false, false, false, 1586, 8, 22, 1,  5, 1}, // #1181
  {DBGFIELD("VPHADDSWYrm_VPHSUBSWYrm") 4, false, false, false, 1586, 8,  9, 1,  5, 1}, // #1182
  {DBGFIELD("XSAVEC_XSAVEC64_XSAVES_XSAVES64") 186, false, false, false, 1594, 15, 48, 1,  0, 0}, // #1183
  {DBGFIELD("PCMPGTBrr_PCMPGTDrr_PCMPGTWrr") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1184
  {DBGFIELD("VPCMPGTBrr_VPCMPGTDrr_VPCMPGTWrr") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1185
  {DBGFIELD("VPCMPGTBYrr_VPCMPGTDYrr_VPCMPGTWYrr") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1186
  {DBGFIELD("KANDBrr_KANDDrr_KANDQrr_KANDWrr_KANDNBrr_KANDNDrr_KANDNQrr_KANDNWrr_KNOTBrr_KNOTDrr_KNOTQrr_KNOTWrr_KORBrr_KORDrr_KORQrr_KORWrr_KXNORBrr_KXNORDrr_KXNORQrr_KXNORWrr_KXORBrr_KXORDrr_KXORQrr_KXORWrr") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1187
  {DBGFIELD("KMOVBkk_KMOVDkk_KMOVQkk_KMOVWkk") 1, false, false, false,  1, 1,  1, 1,  0, 0}, // #1188
  {DBGFIELD("KSET0D_KSET0Q_KSET0W_KSET1D_KSET1Q_KSET1W") 1, false, false, false,  0, 0,  1, 1,  0, 0}, // #1189
  {DBGFIELD("VPMOVB2MZ128rr_VPMOVB2MZ256rr_VPMOVB2MZrr_VPMOVD2MZ128rr_VPMOVD2MZ256rr_VPMOVD2MZrr_VPMOVQ2MZ128rr_VPMOVQ2MZ256rr_VPMOVQ2MZrr_VPMOVW2MZ128rr_VPMOVW2MZ256rr_VPMOVW2MZrr") 1, false, false, false,  1, 1,  1, 1,  0, 0}, // #1190
  {DBGFIELD("VBLENDMPDZ128rr_VBLENDMPDZ128rrk_VBLENDMPDZ128rrkz_VBLENDMPSZ128rr_VBLENDMPSZ128rrk_VBLENDMPSZ128rrkz") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1191
  {DBGFIELD("VBLENDMPDZ256rr_VBLENDMPDZ256rrk_VBLENDMPDZ256rrkz_VBLENDMPSZ256rr_VBLENDMPSZ256rrk_VBLENDMPSZ256rrkz") 3, false, false, false, 223, 3,  5, 1,  0, 0}, // #1192
  {DBGFIELD("VPADDBZ128rr_VPADDBZ128rrk_VPADDBZ128rrkz_VPADDDZ128rr_VPADDDZ128rrk_VPADDDZ128rrkz_VPADDQZ128rr_VPADDQZ128rrk_VPADDQZ128rrkz_VPADDWZ128rr_VPADDWZ128rrk_VPADDWZ128rrkz_VPSUBBZ128rrk_VPSUBBZ128rrkz_VPSUBDZ128rrk_VPSUBDZ128rrkz_VPSUBQZ128rrk_VPSUBQZ128rrkz_VPSUBWZ128rrk_VPSUBWZ128rrkz_VPTERNLOGDZ128rri_VPTERNLOGDZ128rrik_VPTERNLOGDZ128rrikz_VPTERNLOGQZ128rri_VPTERNLOGQZ128rrik_VPTERNLOGQZ128rrikz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1193
  {DBGFIELD("VPADDBZ256rr_VPADDBZ256rrk_VPADDBZ256rrkz_VPADDDZ256rr_VPADDDZ256rrk_VPADDDZ256rrkz_VPADDQZ256rr_VPADDQZ256rrk_VPADDQZ256rrkz_VPADDWZ256rr_VPADDWZ256rrk_VPADDWZ256rrkz_VPSUBBZ256rrk_VPSUBBZ256rrkz_VPSUBDZ256rrk_VPSUBDZ256rrkz_VPSUBQZ256rrk_VPSUBQZ256rrkz_VPSUBWZ256rrk_VPSUBWZ256rrkz_VPTERNLOGDZ256rri_VPTERNLOGDZ256rrik_VPTERNLOGDZ256rrikz_VPTERNLOGQZ256rri_VPTERNLOGQZ256rrik_VPTERNLOGQZ256rrikz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1194
  {DBGFIELD("VPADDBZrr_VPADDBZrrk_VPADDBZrrkz_VPADDDZrr_VPADDDZrrk_VPADDDZrrkz_VPADDQZrr_VPADDQZrrk_VPADDQZrrkz_VPADDWZrr_VPADDWZrrk_VPADDWZrrkz_VPSUBBZrrk_VPSUBBZrrkz_VPSUBDZrrk_VPSUBDZrrkz_VPSUBQZrrk_VPSUBQZrrkz_VPSUBWZrrk_VPSUBWZrrkz_VPTERNLOGDZrri_VPTERNLOGDZrrik_VPTERNLOGDZrrikz_VPTERNLOGQZrri_VPTERNLOGQZrrik_VPTERNLOGQZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1195
  {DBGFIELD("VPBLENDMBZ128rr_VPBLENDMBZ128rrk_VPBLENDMBZ128rrkz_VPBLENDMDZ128rr_VPBLENDMDZ128rrk_VPBLENDMDZ128rrkz_VPBLENDMQZ128rr_VPBLENDMQZ128rrk_VPBLENDMQZ128rrkz_VPBLENDMWZ128rr_VPBLENDMWZ128rrk_VPBLENDMWZ128rrkz") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1196
  {DBGFIELD("VPBLENDMBZ256rr_VPBLENDMBZ256rrk_VPBLENDMBZ256rrkz_VPBLENDMDZ256rr_VPBLENDMDZ256rrk_VPBLENDMDZ256rrkz_VPBLENDMQZ256rr_VPBLENDMQZ256rrk_VPBLENDMQZ256rrkz_VPBLENDMWZ256rr_VPBLENDMWZ256rrk_VPBLENDMWZ256rrkz") 3, false, false, false, 223, 3,  5, 1,  0, 0}, // #1197
  {DBGFIELD("VMOVDQU8Zmr_VMOVDQU8Zmrk") 2, false, false, false, 37, 3,  2, 1,  0, 0}, // #1198
  {DBGFIELD("KORTESTBrr_KORTESTDrr_KORTESTQrr_KORTESTWrr_KTESTBrr_KTESTDrr_KTESTQrr_KTESTWrr") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1199
  {DBGFIELD("VALIGNDZ128rrik_VALIGNDZ128rrikz_VALIGNQZ128rrik_VALIGNQZ128rrikz") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1200
  {DBGFIELD("VALIGNDZ256rrik_VALIGNDZ256rrikz_VALIGNQZ256rrik_VALIGNQZ256rrikz") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1201
  {DBGFIELD("VALIGNDZrrik_VALIGNDZrrikz_VALIGNQZrrik_VALIGNQZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1202
  {DBGFIELD("KSHIFTLBri_KSHIFTLDri_KSHIFTLQri_KSHIFTLWri_KSHIFTRBri_KSHIFTRDri_KSHIFTRQri_KSHIFTRWri") 1, false, false, false, 60, 8,  1, 1,  0, 0}, // #1203
  {DBGFIELD("VCMPPDZ128rri_VCMPPDZ128rrik_VCMPPSZ128rri_VCMPPSZ128rrik_VFPCLASSPDZ128rr_VFPCLASSPDZ128rrk_VFPCLASSPSZ128rr_VFPCLASSPSZ128rrk") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1204
  {DBGFIELD("VCMPPDZ256rri_VCMPPDZ256rrik_VCMPPSZ256rri_VCMPPSZ256rrik_VFPCLASSPDZ256rr_VFPCLASSPDZ256rrk_VFPCLASSPSZ256rr_VFPCLASSPSZ256rrk") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1205
  {DBGFIELD("VCMPPDZrri_VCMPPDZrrib_VCMPPDZrribk_VCMPPDZrrik_VCMPPSZrri_VCMPPSZrrib_VCMPPSZrribk_VCMPPSZrrik_VFPCLASSPDZrr_VFPCLASSPDZrrk_VFPCLASSPSZrr_VFPCLASSPSZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1206
  {DBGFIELD("VCMPSDZrr_VCMPSDZrr_Int_VCMPSDZrr_Intk_VCMPSDZrrb_Int_VCMPSDZrrb_Intk_VCMPSSZrr_VCMPSSZrr_Int_VCMPSSZrr_Intk_VCMPSSZrrb_Int_VCMPSSZrrb_Intk_VFPCLASSSDZrr_VFPCLASSSDZrrk_VFPCLASSSSZrr_VFPCLASSSSZrrk") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1207
  {DBGFIELD("VPCMPBZ128rri_VPCMPBZ128rrik_VPCMPDZ128rri_VPCMPDZ128rrik_VPCMPEQBZ128rr_VPCMPEQBZ128rrk_VPCMPEQDZ128rr_VPCMPEQDZ128rrk_VPCMPEQQZ128rr_VPCMPEQQZ128rrk_VPCMPEQWZ128rr_VPCMPEQWZ128rrk_VPCMPGTBZ128rr_VPCMPGTBZ128rrk_VPCMPGTDZ128rr_VPCMPGTDZ128rrk_VPCMPGTQZ128rr_VPCMPGTQZ128rrk_VPCMPGTWZ128rr_VPCMPGTWZ128rrk_VPCMPQZ128rri_VPCMPQZ128rrik_VPCMPUBZ128rri_VPCMPUBZ128rrik_VPCMPUDZ128rri_VPCMPUDZ128rrik_VPCMPUQZ128rri_VPCMPUQZ128rrik_VPCMPUWZ128rri_VPCMPUWZ128rrik_VPCMPWZ128rri_VPCMPWZ128rrik") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1208
  {DBGFIELD("VPCMPBZ256rri_VPCMPBZ256rrik_VPCMPDZ256rri_VPCMPDZ256rrik_VPCMPEQBZ256rr_VPCMPEQBZ256rrk_VPCMPEQDZ256rr_VPCMPEQDZ256rrk_VPCMPEQQZ256rr_VPCMPEQQZ256rrk_VPCMPEQWZ256rr_VPCMPEQWZ256rrk_VPCMPGTBZ256rr_VPCMPGTBZ256rrk_VPCMPGTDZ256rr_VPCMPGTDZ256rrk_VPCMPGTQZ256rr_VPCMPGTQZ256rrk_VPCMPGTWZ256rr_VPCMPGTWZ256rrk_VPCMPQZ256rri_VPCMPQZ256rrik_VPCMPUBZ256rri_VPCMPUBZ256rrik_VPCMPUDZ256rri_VPCMPUDZ256rrik_VPCMPUQZ256rri_VPCMPUQZ256rrik_VPCMPUWZ256rri_VPCMPUWZ256rrik_VPCMPWZ256rri_VPCMPWZ256rrik") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1209
  {DBGFIELD("VPCMPBZrri_VPCMPBZrrik_VPCMPDZrri_VPCMPDZrrik_VPCMPEQBZrr_VPCMPEQBZrrk_VPCMPEQDZrr_VPCMPEQDZrrk_VPCMPEQQZrr_VPCMPEQQZrrk_VPCMPEQWZrr_VPCMPEQWZrrk_VPCMPGTBZrr_VPCMPGTBZrrk_VPCMPGTDZrr_VPCMPGTDZrrk_VPCMPGTQZrr_VPCMPGTQZrrk_VPCMPGTWZrr_VPCMPGTWZrrk_VPCMPQZrri_VPCMPQZrrik_VPCMPUBZrri_VPCMPUBZrrik_VPCMPUDZrri_VPCMPUDZrrik_VPCMPUQZrri_VPCMPUQZrrik_VPCMPUWZrri_VPCMPUWZrrik_VPCMPWZrri_VPCMPWZrrik") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1210
  {DBGFIELD("VPTESTMBZ128rr_VPTESTMDZ128rr_VPTESTMQZ128rr_VPTESTMWZ128rr_VPTESTNMBZ128rr_VPTESTNMDZ128rr_VPTESTNMQZ128rr_VPTESTNMWZ128rr") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1211
  {DBGFIELD("VPTESTMBZrr_VPTESTMDZrr_VPTESTMQZrr_VPTESTMWZrr_VPTESTNMBZrr_VPTESTNMDZrr_VPTESTNMQZrr_VPTESTNMWZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1212
  {DBGFIELD("VCVTPD2QQZ128rr_VCVTPD2QQZ128rrk_VCVTPD2QQZ128rrkz_VCVTPD2UQQZ128rr_VCVTPD2UQQZ128rrk_VCVTPD2UQQZ128rrkz_VCVTTPD2QQZ128rr_VCVTTPD2QQZ128rrk_VCVTTPD2QQZ128rrkz_VCVTTPD2UQQZ128rr_VCVTTPD2UQQZ128rrk_VCVTTPD2UQQZ128rrkz") 2, false, false, false, 183, 9, 10, 1,  0, 0}, // #1213
  {DBGFIELD("VCVTPD2QQZ256rr_VCVTPD2QQZ256rrk_VCVTPD2QQZ256rrkz_VCVTPD2UQQZ256rr_VCVTPD2UQQZ256rrk_VCVTPD2UQQZ256rrkz_VCVTTPD2QQZ256rr_VCVTTPD2QQZ256rrk_VCVTTPD2QQZ256rrkz_VCVTTPD2UQQZ256rr_VCVTTPD2UQQZ256rrk_VCVTTPD2UQQZ256rrkz") 2, false, false, false, 183, 9,  6, 1,  0, 0}, // #1214
  {DBGFIELD("VCVTPS2DQYrr_VCVTPS2DQZ256rr_VCVTPS2DQZ256rrk_VCVTPS2DQZ256rrkz_VCVTPS2UDQZ256rr_VCVTPS2UDQZ256rrk_VCVTPS2UDQZ256rrkz_VCVTTPS2DQZ256rr_VCVTTPS2DQZ256rrk_VCVTTPS2DQZ256rrkz_VCVTTPS2UDQZ256rr_VCVTTPS2UDQZ256rrk_VCVTTPS2UDQZ256rrkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1215
  {DBGFIELD("VCVTPS2DQZ128rr_VCVTPS2DQZ128rrk_VCVTPS2DQZ128rrkz_VCVTPS2UDQZ128rr_VCVTPS2UDQZ128rrk_VCVTPS2UDQZ128rrkz_VCVTTPS2DQZ128rr_VCVTTPS2DQZ128rrk_VCVTTPS2DQZ128rrkz_VCVTTPS2UDQZ128rr_VCVTTPS2UDQZ128rrk_VCVTTPS2UDQZ128rrkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1216
  {DBGFIELD("VCVTPD2QQZrr_VCVTPD2UQQZrr_VCVTTPD2QQZrr_VCVTTPD2UQQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1217
  {DBGFIELD("VCVTPS2DQZrr_VCVTPS2UDQZrr_VCVTTPS2DQZrr_VCVTTPS2UDQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1218
  {DBGFIELD("VEXPANDPDZ128rr_VEXPANDPDZ128rrk_VEXPANDPDZ128rrkz_VEXPANDPDZ256rr_VEXPANDPDZ256rrk_VEXPANDPDZ256rrkz_VEXPANDPDZrr_VEXPANDPDZrrk_VEXPANDPDZrrkz_VEXPANDPSZ128rr_VEXPANDPSZ128rrk_VEXPANDPSZ128rrkz_VEXPANDPSZ256rr_VEXPANDPSZ256rrk_VEXPANDPSZ256rrkz_VEXPANDPSZrr_VEXPANDPSZrrk_VEXPANDPSZrrkz_VPEXPANDDZ128rr_VPEXPANDDZ128rrk_VPEXPANDDZ128rrkz_VPEXPANDDZ256rr_VPEXPANDDZ256rrk_VPEXPANDDZ256rrkz_VPEXPANDDZrr_VPEXPANDDZrrk_VPEXPANDDZrrkz_VPEXPANDQZ128rr_VPEXPANDQZ128rrk_VPEXPANDQZ128rrkz_VPEXPANDQZ256rr_VPEXPANDQZ256rrk_VPEXPANDQZ256rrkz_VPEXPANDQZrr_VPEXPANDQZrrk_VPEXPANDQZrrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1219
  {DBGFIELD("VPMOVDBZ128rr_VPMOVDBZ128rrk_VPMOVDBZ128rrkz_VPMOVDWZ128rr_VPMOVDWZ128rrk_VPMOVDWZ128rrkz_VPMOVQBZ128rr_VPMOVQBZ128rrk_VPMOVQBZ128rrkz_VPMOVQWZ128rr_VPMOVQWZ128rrk_VPMOVQWZ128rrkz_VPMOVSDBZ128rr_VPMOVSDBZ128rrk_VPMOVSDBZ128rrkz_VPMOVSDWZ128rr_VPMOVSDWZ128rrk_VPMOVSDWZ128rrkz_VPMOVSQBZ128rr_VPMOVSQBZ128rrk_VPMOVSQBZ128rrkz_VPMOVSQDZ128rr_VPMOVSQDZ128rrk_VPMOVSQDZ128rrkz_VPMOVSQWZ128rr_VPMOVSQWZ128rrk_VPMOVSQWZ128rrkz_VPMOVSWBZ128rr_VPMOVSWBZ128rrk_VPMOVSWBZ128rrkz_VPMOVUSDBZ128rr_VPMOVUSDBZ128rrk_VPMOVUSDBZ128rrkz_VPMOVUSDWZ128rr_VPMOVUSDWZ128rrk_VPMOVUSDWZ128rrkz_VPMOVUSQBZ128rr_VPMOVUSQBZ128rrk_VPMOVUSQBZ128rrkz_VPMOVUSQDZ128rr_VPMOVUSQDZ128rrk_VPMOVUSQDZ128rrkz_VPMOVUSWBZ128rr_VPMOVUSWBZ128rrk_VPMOVUSWBZ128rrkz_VPMOVWBZ128rr_VPMOVWBZ128rrk_VPMOVWBZ128rrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1220
  {DBGFIELD("VPMOVDBZ256rr_VPMOVDBZ256rrk_VPMOVDBZ256rrkz_VPMOVDWZ256rr_VPMOVDWZ256rrk_VPMOVDWZ256rrkz_VPMOVDWZrr_VPMOVDWZrrk_VPMOVDWZrrkz_VPMOVQBZ256rr_VPMOVQBZ256rrk_VPMOVQBZ256rrkz_VPMOVQWZ256rr_VPMOVQWZ256rrk_VPMOVQWZ256rrkz_VPMOVSDBZ256rr_VPMOVSDBZ256rrk_VPMOVSDBZ256rrkz_VPMOVSDWZ256rr_VPMOVSDWZ256rrk_VPMOVSDWZ256rrkz_VPMOVSDWZrr_VPMOVSDWZrrk_VPMOVSDWZrrkz_VPMOVSQBZ256rr_VPMOVSQBZ256rrk_VPMOVSQBZ256rrkz_VPMOVSQDZ256rr_VPMOVSQDZ256rrk_VPMOVSQDZ256rrkz_VPMOVSQDZrr_VPMOVSQDZrrk_VPMOVSQDZrrkz_VPMOVSQWZ256rr_VPMOVSQWZ256rrk_VPMOVSQWZ256rrkz_VPMOVSWBZ256rr_VPMOVSWBZ256rrk_VPMOVSWBZ256rrkz_VPMOVSWBZrr_VPMOVSWBZrrk_VPMOVSWBZrrkz_VPMOVUSDBZ256rr_VPMOVUSDBZ256rrk_VPMOVUSDBZ256rrkz_VPMOVUSDWZ256rr_VPMOVUSDWZ256rrk_VPMOVUSDWZ256rrkz_VPMOVUSDWZrr_VPMOVUSDWZrrk_VPMOVUSDWZrrkz_VPMOVUSQBZ256rr_VPMOVUSQBZ256rrk_VPMOVUSQBZ256rrkz_VPMOVUSQDZ256rr_VPMOVUSQDZ256rrk_VPMOVUSQDZ256rrkz_VPMOVUSQDZrr_VPMOVUSQDZrrk_VPMOVUSQDZrrkz_VPMOVUSWBZ256rr_VPMOVUSWBZ256rrk_VPMOVUSWBZ256rrkz_VPMOVUSWBZrr_VPMOVUSWBZrrk_VPMOVUSWBZrrkz_VPMOVWBZ256rr_VPMOVWBZ256rrk_VPMOVWBZ256rrkz_VPMOVWBZrr_VPMOVWBZrrk_VPMOVWBZrrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1221
  {DBGFIELD("VPMOVDBZrr_VPMOVDBZrrk_VPMOVDBZrrkz_VPMOVQBZrr_VPMOVQBZrrk_VPMOVQBZrrkz_VPMOVQWZrr_VPMOVQWZrrk_VPMOVQWZrrkz_VPMOVSDBZrr_VPMOVSDBZrrk_VPMOVSDBZrrkz_VPMOVSQBZrr_VPMOVSQBZrrk_VPMOVSQBZrrkz_VPMOVSQWZrr_VPMOVSQWZrrk_VPMOVSQWZrrkz_VPMOVUSDBZrr_VPMOVUSDBZrrk_VPMOVUSDBZrrkz_VPMOVUSQBZrr_VPMOVUSQBZrrk_VPMOVUSQBZrrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1222
  {DBGFIELD("VPMOVQDZ128mr_VPMOVQDZ128mrk_VPMOVQDZ256mr_VPMOVQDZ256mrk_VPMOVQDZmr_VPMOVQDZmrk") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #1223
  {DBGFIELD("VCVTDQ2PDZ128rr_VCVTDQ2PDZ128rrk_VCVTDQ2PDZ128rrkz_VCVTUDQ2PDZ128rr_VCVTUDQ2PDZ128rrk_VCVTUDQ2PDZ128rrkz") 2, false, false, false, 183, 9, 10, 1,  0, 0}, // #1224
  {DBGFIELD("VCVTPD2DQZ128rr_VCVTPD2DQZ128rrk_VCVTPD2DQZ128rrkz_VCVTPD2UDQZ128rr_VCVTPD2UDQZ128rrk_VCVTPD2UDQZ128rrkz_VCVTTPD2DQZ128rr_VCVTTPD2DQZ128rrk_VCVTTPD2DQZ128rrkz_VCVTTPD2UDQZ128rr_VCVTTPD2UDQZ128rrk_VCVTTPD2UDQZ128rrkz") 2, false, false, false, 183, 9, 10, 1,  0, 0}, // #1225
  {DBGFIELD("VCVTPS2PDZ128rr_VCVTPS2PDZ128rrk_VCVTPS2PDZ128rrkz_CVTPS2PDrr_VCVTPS2PDrr") 2, false, false, false, 183, 9, 10, 1,  0, 0}, // #1226
  {DBGFIELD("VCVTPS2QQZ128rr_VCVTPS2QQZ128rrk_VCVTPS2QQZ128rrkz_VCVTPS2UQQZ128rr_VCVTPS2UQQZ128rrk_VCVTPS2UQQZ128rrkz_VCVTTPS2QQZ128rr_VCVTTPS2QQZ128rrk_VCVTTPS2QQZ128rrkz_VCVTTPS2UQQZ128rr_VCVTTPS2UQQZ128rrk_VCVTTPS2UQQZ128rrkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1227
  {DBGFIELD("VCVTQQ2PSZ128rr_VCVTQQ2PSZ128rrk_VCVTQQ2PSZ128rrkz_VCVTUQQ2PSZ128rr_VCVTUQQ2PSZ128rrk_VCVTUQQ2PSZ128rrkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1228
  {DBGFIELD("VCVTSI2SSZrr_VCVTSI2SSZrr_Int_VCVTSI2SSZrrb_Int_CVTSI2SSrr_Int_VCVTSI2SSrr_VCVTSI2SSrr_Int_VCVTUSI2SSZrr_VCVTUSI2SSZrr_Int_VCVTUSI2SSZrrb_Int") 2, false, false, false, 183, 9,  6, 1,  6, 1}, // #1229
  {DBGFIELD("VCVTSI2SDZrr_VCVTSI2SDZrr_Int_VCVTSI642SDZrr_VCVTSI642SDZrr_Int_VCVTSI642SDZrrb_Int_VCVTUSI2SDZrr_VCVTUSI2SDZrr_Int_VCVTUSI642SDZrr_VCVTUSI642SDZrr_Int_VCVTUSI642SDZrrb_Int") 2, false, false, false, 183, 9,  6, 1,  6, 1}, // #1230
  {DBGFIELD("VCVTSS2SDZrr_VCVTSS2SDZrr_Int_VCVTSS2SDZrr_Intk_VCVTSS2SDZrr_Intkz_VCVTSS2SDZrrb_Int_VCVTSS2SDZrrb_Intk_VCVTSS2SDZrrb_Intkz_CVTSS2SDrr_CVTSS2SDrr_Int_VCVTSS2SDrr_VCVTSS2SDrr_Int") 2, false, false, false, 183, 9, 10, 1,  0, 0}, // #1231
  {DBGFIELD("VPCONFLICTQZ128rr_VPCONFLICTQZ128rrk_VPCONFLICTQZ128rrkz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1232
  {DBGFIELD("VCVTPS2PHZ128mr_VCVTPS2PHZ128mrk") 3, false, false, false, 626, 7,  2, 1,  0, 0}, // #1233
  {DBGFIELD("VCVTPS2PHZ256mr_VCVTPS2PHZ256mrk") 3, false, false, false, 626, 7,  2, 1,  0, 0}, // #1234
  {DBGFIELD("VCVTPS2PHZmr_VCVTPS2PHZmrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1235
  {DBGFIELD("VPMOVDBZ128mr_VPMOVDBZ128mrk_VPMOVDBZ256mr_VPMOVDBZ256mrk_VPMOVDBZmr_VPMOVDBZmrk_VPMOVDWZ128mr_VPMOVDWZ128mrk_VPMOVDWZ256mr_VPMOVDWZ256mrk_VPMOVDWZmr_VPMOVDWZmrk_VPMOVQBZ128mr_VPMOVQBZ128mrk_VPMOVQBZ256mr_VPMOVQBZ256mrk_VPMOVQBZmr_VPMOVQBZmrk_VPMOVQWZ128mr_VPMOVQWZ128mrk_VPMOVQWZ256mr_VPMOVQWZ256mrk_VPMOVQWZmr_VPMOVQWZmrk_VPMOVSDBZ128mr_VPMOVSDBZ128mrk_VPMOVSDBZ256mr_VPMOVSDBZ256mrk_VPMOVSDBZmr_VPMOVSDBZmrk_VPMOVSDWZ128mr_VPMOVSDWZ128mrk_VPMOVSDWZ256mr_VPMOVSDWZ256mrk_VPMOVSDWZmr_VPMOVSDWZmrk_VPMOVSQBZ128mr_VPMOVSQBZ128mrk_VPMOVSQBZ256mr_VPMOVSQBZ256mrk_VPMOVSQBZmr_VPMOVSQBZmrk_VPMOVSQDZ128mr_VPMOVSQDZ128mrk_VPMOVSQDZ256mr_VPMOVSQDZ256mrk_VPMOVSQDZmr_VPMOVSQDZmrk_VPMOVSQWZ128mr_VPMOVSQWZ128mrk_VPMOVSQWZ256mr_VPMOVSQWZ256mrk_VPMOVSQWZmr_VPMOVSQWZmrk_VPMOVSWBZ128mr_VPMOVSWBZ128mrk_VPMOVSWBZ256mr_VPMOVSWBZ256mrk_VPMOVSWBZmr_VPMOVSWBZmrk_VPMOVUSDBZ128mr_VPMOVUSDBZ128mrk_VPMOVUSDBZ256mr_VPMOVUSDBZ256mrk_VPMOVUSDBZmr_VPMOVUSDBZmrk_VPMOVUSDWZ128mr_VPMOVUSDWZ128mrk_VPMOVUSDWZ256mr_VPMOVUSDWZ256mrk_VPMOVUSDWZmr_VPMOVUSDWZmrk_VPMOVUSQBZ128mr_VPMOVUSQBZ128mrk_VPMOVUSQBZ256mr_VPMOVUSQBZ256mrk_VPMOVUSQBZmr_VPMOVUSQBZmrk_VPMOVUSQDZ128mr_VPMOVUSQDZ128mrk_VPMOVUSQDZ256mr_VPMOVUSQDZ256mrk_VPMOVUSQDZmr_VPMOVUSQDZmrk_VPMOVUSQWZ128mr_VPMOVUSQWZ128mrk_VPMOVUSQWZ256mr_VPMOVUSQWZ256mrk_VPMOVUSQWZmr_VPMOVUSQWZmrk_VPMOVUSWBZ128mr_VPMOVUSWBZ128mrk_VPMOVUSWBZ256mr_VPMOVUSWBZ256mrk_VPMOVUSWBZmr_VPMOVUSWBZmrk_VPMOVWBZ128mr_VPMOVWBZ128mrk_VPMOVWBZ256mr_VPMOVWBZ256mrk_VPMOVWBZmr_VPMOVWBZmrk") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #1236
  {DBGFIELD("VCOMPRESSPDZ128rr_VCOMPRESSPDZ128rrk_VCOMPRESSPDZ128rrkz_VCOMPRESSPSZ128rr_VCOMPRESSPSZ128rrk_VCOMPRESSPSZ128rrkz_VPCOMPRESSDZ128rr_VPCOMPRESSDZ128rrk_VPCOMPRESSDZ128rrkz_VPCOMPRESSQZ128rr_VPCOMPRESSQZ128rrk_VPCOMPRESSQZ128rrkz_VPERMWZ128rr_VPERMWZ128rrk_VPERMWZ128rrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1237
  {DBGFIELD("VCOMPRESSPDZ256rr_VCOMPRESSPDZ256rrk_VCOMPRESSPDZ256rrkz_VCOMPRESSPSZ256rr_VCOMPRESSPSZ256rrk_VCOMPRESSPSZ256rrkz_VPCOMPRESSDZ256rr_VPCOMPRESSDZ256rrk_VPCOMPRESSDZ256rrkz_VPCOMPRESSQZ256rr_VPCOMPRESSQZ256rrk_VPCOMPRESSQZ256rrkz_VPERMWZ256rr_VPERMWZ256rrk_VPERMWZ256rrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1238
  {DBGFIELD("VCOMPRESSPDZrr_VCOMPRESSPDZrrk_VCOMPRESSPDZrrkz_VCOMPRESSPSZrr_VCOMPRESSPSZrrk_VCOMPRESSPSZrrkz_VPCOMPRESSDZrr_VPCOMPRESSDZrrk_VPCOMPRESSDZrrkz_VPCOMPRESSQZrr_VPCOMPRESSQZrrk_VPCOMPRESSQZrrkz_VPERMWZrr_VPERMWZrrk_VPERMWZrrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1239
  {DBGFIELD("VMOV64toPQIZrm_VMOVQI2PQIZrm") 1, false, false, false, 28, 2,  6, 1,  0, 0}, // #1240
  {DBGFIELD("VMOVDI2PDIZrm")      1, false, false, false, 28, 2,  6, 1,  0, 0}, // #1241
  {DBGFIELD("VCVTSI642SSZrr_VCVTSI642SSZrr_Int_VCVTSI642SSZrrb_Int_VCVTUSI642SSZrr_VCVTUSI642SSZrr_Int_VCVTUSI642SSZrrb_Int") 2, false, false, false, 183, 9,  6, 1,  6, 1}, // #1242
  {DBGFIELD("VMOVSDZrm_VMOVSDZrm_alt_VMOVSDZrmk_VMOVSDZrmkz_VMOVSSZrm_VMOVSSZrm_alt_VMOVSSZrmk_VMOVSSZrmkz") 1, false, false, false, 28, 2,  6, 1,  0, 0}, // #1243
  {DBGFIELD("VCVTDQ2PDZ256rr_VCVTDQ2PDZ256rrk_VCVTDQ2PDZ256rrkz_VCVTUDQ2PDZ256rr_VCVTUDQ2PDZ256rrk_VCVTUDQ2PDZ256rrkz") 2, false, false, false, 183, 9,  6, 1,  0, 0}, // #1244
  {DBGFIELD("VCVTPD2DQZ256rr_VCVTPD2DQZ256rrk_VCVTPD2DQZ256rrkz_VCVTPD2UDQZ256rr_VCVTPD2UDQZ256rrk_VCVTPD2UDQZ256rrkz_VCVTTPD2DQZ256rr_VCVTTPD2DQZ256rrk_VCVTTPD2DQZ256rrkz_VCVTTPD2UDQZ256rr_VCVTTPD2UDQZ256rrk_VCVTTPD2UDQZ256rrkz") 2, false, false, false, 183, 9,  6, 1,  0, 0}, // #1245
  {DBGFIELD("VCVTPS2PDYrr_VCVTPS2PDZ256rr_VCVTPS2PDZ256rrk_VCVTPS2PDZ256rrkz") 2, false, false, false, 183, 9,  6, 1,  0, 0}, // #1246
  {DBGFIELD("VCVTPS2QQZ256rr_VCVTPS2QQZ256rrk_VCVTPS2QQZ256rrkz_VCVTPS2UQQZ256rr_VCVTPS2UQQZ256rrk_VCVTPS2UQQZ256rrkz_VCVTTPS2QQZ256rr_VCVTTPS2QQZ256rrk_VCVTTPS2QQZ256rrkz_VCVTTPS2UQQZ256rr_VCVTTPS2UQQZ256rrk_VCVTTPS2UQQZ256rrkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1247
  {DBGFIELD("VCVTQQ2PSZ256rr_VCVTQQ2PSZ256rrk_VCVTQQ2PSZ256rrkz_VCVTUQQ2PSZ256rr_VCVTUQQ2PSZ256rrk_VCVTUQQ2PSZ256rrkz") 1, false, false, false,  3, 4, 14, 1,  0, 0}, // #1248
  {DBGFIELD("VCVTDQ2PDZrr_VCVTUDQ2PDZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1249
  {DBGFIELD("VCVTPD2DQZrr_VCVTPD2UDQZrr_VCVTTPD2DQZrr_VCVTTPD2UDQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1250
  {DBGFIELD("VCVTPS2PDZrr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1251
  {DBGFIELD("VCVTPS2QQZrr_VCVTPS2UQQZrr_VCVTTPS2QQZrr_VCVTTPS2UQQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1252
  {DBGFIELD("VCVTQQ2PSZrr_VCVTUQQ2PSZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1253
  {DBGFIELD("VMOVNTDQAZ128rm")    1, false, false, false, 28, 2,  6, 1,  0, 0}, // #1254
  {DBGFIELD("VBLENDMPDZ128rm_VBLENDMPDZ128rmb_VBLENDMPDZ128rmbk_VBLENDMPDZ128rmbkz_VBLENDMPDZ128rmk_VBLENDMPDZ128rmkz_VBLENDMPSZ128rm_VBLENDMPSZ128rmb_VBLENDMPSZ128rmbk_VBLENDMPSZ128rmbkz_VBLENDMPSZ128rmk_VBLENDMPSZ128rmkz") 2, false, false, false, 69, 5,  7, 1,  5, 1}, // #1255
  {DBGFIELD("VBROADCASTI32X2Z128rm_VBROADCASTI32X2Z128rmk_VBROADCASTI32X2Z128rmkz_VPBROADCASTDZ128rm_VPBROADCASTDZ128rmk_VPBROADCASTDZ128rmkz_VPBROADCASTQZ128rm_VPBROADCASTQZ128rmk_VPBROADCASTQZ128rmkz") 2, false, false, false, 53, 7,  7, 1,  0, 0}, // #1256
  {DBGFIELD("VBROADCASTSSZ128rm_VBROADCASTSSZ128rmk_VBROADCASTSSZ128rmkz") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #1257
  {DBGFIELD("VMOVAPDZ128rm_VMOVAPDZ128rmk_VMOVAPDZ128rmkz_VMOVAPSZ128rm_NOVLX_VMOVAPSZ128rm_VMOVAPSZ128rmk_VMOVAPSZ128rmkz_VMOVUPDZ128rm_VMOVUPDZ128rmk_VMOVUPDZ128rmkz_VMOVUPSZ128rm_NOVLX_VMOVUPSZ128rm_VMOVUPSZ128rmk_VMOVUPSZ128rmkz") 1, false, false, false, 28, 2,  6, 1,  0, 0}, // #1258
  {DBGFIELD("VMOVDDUPZ128rm_VMOVDDUPZ128rmk_VMOVDDUPZ128rmkz_VMOVSHDUPZ128rm_VMOVSHDUPZ128rmk_VMOVSHDUPZ128rmkz_VMOVSLDUPZ128rm_VMOVSLDUPZ128rmk_VMOVSLDUPZ128rmkz") 2, false, false, false, 375, 10,  7, 1,  0, 0}, // #1259
  {DBGFIELD("VMOVDQA32Z128rm_VMOVDQA32Z128rmk_VMOVDQA32Z128rmkz_VMOVDQA64Z128rm_VMOVDQA64Z128rmk_VMOVDQA64Z128rmkz_VMOVDQU16Z128rm_VMOVDQU16Z128rmk_VMOVDQU16Z128rmkz_VMOVDQU32Z128rm_VMOVDQU32Z128rmk_VMOVDQU32Z128rmkz_VMOVDQU64Z128rm_VMOVDQU64Z128rmk_VMOVDQU64Z128rmkz_VMOVDQU8Z128rm_VMOVDQU8Z128rmk_VMOVDQU8Z128rmkz") 1, false, false, false, 28, 2,  6, 1,  0, 0}, // #1260
  {DBGFIELD("VPADDBZ128rm_VPADDBZ128rmk_VPADDBZ128rmkz_VPADDDZ128rm_VPADDDZ128rmb_VPADDDZ128rmbk_VPADDDZ128rmbkz_VPADDDZ128rmk_VPADDDZ128rmkz_VPADDQZ128rm_VPADDQZ128rmb_VPADDQZ128rmbk_VPADDQZ128rmbkz_VPADDQZ128rmk_VPADDQZ128rmkz_VPADDWZ128rm_VPADDWZ128rmk_VPADDWZ128rmkz_VPSUBBZ128rm_VPSUBBZ128rmk_VPSUBBZ128rmkz_VPSUBDZ128rm_VPSUBDZ128rmb_VPSUBDZ128rmbk_VPSUBDZ128rmbkz_VPSUBDZ128rmk_VPSUBDZ128rmkz_VPSUBQZ128rm_VPSUBQZ128rmb_VPSUBQZ128rmbk_VPSUBQZ128rmbkz_VPSUBQZ128rmk_VPSUBQZ128rmkz_VPSUBWZ128rm_VPSUBWZ128rmk_VPSUBWZ128rmkz_VPTERNLOGDZ128rmbi_VPTERNLOGDZ128rmbik_VPTERNLOGDZ128rmbikz_VPTERNLOGDZ128rmi_VPTERNLOGDZ128rmik_VPTERNLOGDZ128rmikz_VPTERNLOGQZ128rmbi_VPTERNLOGQZ128rmbik_VPTERNLOGQZ128rmbikz_VPTERNLOGQZ128rmi_VPTERNLOGQZ128rmik_VPTERNLOGQZ128rmikz") 2, false, false, false, 68, 6,  7, 1,  5, 1}, // #1261
  {DBGFIELD("VPBLENDMBZ128rm_VPBLENDMBZ128rmk_VPBLENDMBZ128rmkz_VPBLENDMDZ128rm_VPBLENDMDZ128rmb_VPBLENDMDZ128rmbk_VPBLENDMDZ128rmbkz_VPBLENDMDZ128rmk_VPBLENDMDZ128rmkz_VPBLENDMQZ128rm_VPBLENDMQZ128rmb_VPBLENDMQZ128rmbk_VPBLENDMQZ128rmbkz_VPBLENDMQZ128rmk_VPBLENDMQZ128rmkz_VPBLENDMWZ128rm_VPBLENDMWZ128rmk_VPBLENDMWZ128rmkz") 2, false, false, false, 69, 5,  7, 1,  5, 1}, // #1262
  {DBGFIELD("VPERMI2W128rr_VPERMI2W128rrk_VPERMI2W128rrkz_VPERMT2W128rr_VPERMT2W128rrk_VPERMT2W128rrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1263
  {DBGFIELD("VPERMI2W256rr_VPERMI2W256rrk_VPERMI2W256rrkz_VPERMT2W256rr_VPERMT2W256rrk_VPERMT2W256rrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1264
  {DBGFIELD("VPERMI2Wrr_VPERMI2Wrrk_VPERMI2Wrrkz_VPERMT2Wrr_VPERMT2Wrrk_VPERMT2Wrrkz") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1265
  {DBGFIELD("VCVTSS2SI64Zrr_VCVTSS2SI64Zrr_Int_VCVTSS2SI64Zrrb_Int_VCVTTSS2SI64Zrr_VCVTTSS2SI64Zrr_Int_VCVTTSS2SI64Zrrb_Int_VCVTSS2USI64Zrr_Int_VCVTSS2USI64Zrrb_Int_VCVTTSS2USI64Zrr_VCVTTSS2USI64Zrr_Int_VCVTTSS2USI64Zrrb_Int") 2, false, false, false, 203, 8,  6, 1,  0, 0}, // #1266
  {DBGFIELD("KMOVBkm_KMOVDkm_KMOVQkm_KMOVWkm") 1, false, false, false, 28, 2, 10, 1,  0, 0}, // #1267
  {DBGFIELD("VCOMPRESSPDZ128mr_VCOMPRESSPDZ128mrk_VCOMPRESSPDZ256mr_VCOMPRESSPDZ256mrk_VCOMPRESSPDZmr_VCOMPRESSPDZmrk_VCOMPRESSPSZ128mr_VCOMPRESSPSZ128mrk_VCOMPRESSPSZ256mr_VCOMPRESSPSZ256mrk_VCOMPRESSPSZmr_VCOMPRESSPSZmrk_VPCOMPRESSDZ128mr_VPCOMPRESSDZ128mrk_VPCOMPRESSDZ256mr_VPCOMPRESSDZ256mrk_VPCOMPRESSDZmr_VPCOMPRESSDZmrk_VPCOMPRESSQZ128mr_VPCOMPRESSQZ128mrk_VPCOMPRESSQZ256mr_VPCOMPRESSQZ256mrk_VPCOMPRESSQZmr_VPCOMPRESSQZmrk") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #1268
  {DBGFIELD("VPSCATTERDQZ128mr_VPSCATTERQQZ128mr_VSCATTERDPDZ128mr_VSCATTERQPDZ128mr") 2, false, false, false, 37, 3,  2, 1,  0, 0}, // #1269
  {DBGFIELD("VPSCATTERDQZ256mr_VPSCATTERQQZ256mr_VSCATTERDPDZ256mr_VSCATTERQPDZ256mr") 2, false, false, false, 37, 3,  2, 1,  0, 0}, // #1270
  {DBGFIELD("VPSCATTERDQZmr_VPSCATTERQQZmr_VSCATTERDPDZmr_VSCATTERQPDZmr") 2, false, false, false, 37, 3,  2, 1,  0, 0}, // #1271
  {DBGFIELD("VSCATTERDPSZmr")     2, false, false, false, 37, 3,  2, 1,  0, 0}, // #1272
  {DBGFIELD("VPBROADCASTBZ256rm_VPBROADCASTBZ256rmk_VPBROADCASTBZ256rmkz_VPBROADCASTBZrm_VPBROADCASTBZrmk_VPBROADCASTBZrmkz_VPBROADCASTWZ256rm_VPBROADCASTWZ256rmk_VPBROADCASTWZ256rmkz_VPBROADCASTWZrm_VPBROADCASTWZrmk_VPBROADCASTWZrmkz") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #1273
  {DBGFIELD("VMOVNTDQAZ256rm")    1, false, false, false, 28, 2,  7, 1,  0, 0}, // #1274
  {DBGFIELD("VBLENDMPDZ256rm_VBLENDMPDZ256rmb_VBLENDMPDZ256rmbk_VBLENDMPDZ256rmbkz_VBLENDMPDZ256rmk_VBLENDMPDZ256rmkz_VBLENDMPSZ256rm_VBLENDMPSZ256rmb_VBLENDMPSZ256rmbk_VBLENDMPSZ256rmbkz_VBLENDMPSZ256rmk_VBLENDMPSZ256rmkz") 4, false, false, false, 621, 5,  9, 1,  5, 1}, // #1275
  {DBGFIELD("VBLENDMPDZrm_VBLENDMPDZrmb_VBLENDMPDZrmbk_VBLENDMPDZrmbkz_VBLENDMPDZrmk_VBLENDMPDZrmkz_VBLENDMPSZrm_VBLENDMPSZrmb_VBLENDMPSZrmbk_VBLENDMPSZrmbkz_VBLENDMPSZrmk_VBLENDMPSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1276
  {DBGFIELD("VBROADCASTF32X2Z256rm_VBROADCASTF32X2Z256rmk_VBROADCASTF32X2Z256rmkz_VBROADCASTF32X2Zrm_VBROADCASTF32X2Zrmk_VBROADCASTF32X2Zrmkz_VBROADCASTI32X2Z256rm_VBROADCASTI32X2Z256rmk_VBROADCASTI32X2Z256rmkz_VBROADCASTI32X2Zrm_VBROADCASTI32X2Zrmk_VBROADCASTI32X2Zrmkz_VPBROADCASTDZ256rm_VPBROADCASTDZ256rmk_VPBROADCASTDZ256rmkz_VPBROADCASTDZrm_VPBROADCASTDZrmk_VPBROADCASTDZrmkz_VPBROADCASTQZ256rm_VPBROADCASTQZ256rmk_VPBROADCASTQZ256rmkz_VPBROADCASTQZrm_VPBROADCASTQZrmk_VPBROADCASTQZrmkz") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #1277
  {DBGFIELD("VBROADCASTF32X4Z256rm_VBROADCASTF32X4Z256rmk_VBROADCASTF32X4Z256rmkz_VBROADCASTF32X4rm_VBROADCASTF32X4rmk_VBROADCASTF32X4rmkz_VBROADCASTF32X8rm_VBROADCASTF32X8rmk_VBROADCASTF32X8rmkz_VBROADCASTF64X2Z128rm_VBROADCASTF64X2Z128rmk_VBROADCASTF64X2Z128rmkz_VBROADCASTF64X2rm_VBROADCASTF64X2rmk_VBROADCASTF64X2rmkz_VBROADCASTF64X4rm_VBROADCASTF64X4rmk_VBROADCASTF64X4rmkz_VBROADCASTI32X4Z256rm_VBROADCASTI32X4Z256rmk_VBROADCASTI32X4Z256rmkz_VBROADCASTI32X4rm_VBROADCASTI32X4rmk_VBROADCASTI32X4rmkz_VBROADCASTI32X8rm_VBROADCASTI32X8rmk_VBROADCASTI32X8rmkz_VBROADCASTI64X2Z128rm_VBROADCASTI64X2Z128rmk_VBROADCASTI64X2Z128rmkz_VBROADCASTI64X2rm_VBROADCASTI64X2rmk_VBROADCASTI64X2rmkz_VBROADCASTI64X4rm_VBROADCASTI64X4rmk_VBROADCASTI64X4rmkz") 2, false, false, false, 53, 7, 22, 1,  0, 0}, // #1278
  {DBGFIELD("VBROADCASTSDZ256rm_VBROADCASTSDZ256rmk_VBROADCASTSDZ256rmkz_VBROADCASTSDZrm_VBROADCASTSDZrmk_VBROADCASTSDZrmkz_VBROADCASTSSZ256rm_VBROADCASTSSZ256rmk_VBROADCASTSSZ256rmkz_VBROADCASTSSZrm_VBROADCASTSSZrmk_VBROADCASTSSZrmkz") 2, false, false, false, 375, 10,  8, 1,  0, 0}, // #1279
  {DBGFIELD("VINSERTF32x4Z256rm_VINSERTF32x4Z256rmk_VINSERTF32x4Z256rmkz_VINSERTF32x4Zrm_VINSERTF32x4Zrmk_VINSERTF32x4Zrmkz_VINSERTF32x8Zrm_VINSERTF32x8Zrmk_VINSERTF32x8Zrmkz_VINSERTF64x2Z256rm_VINSERTF64x2Z256rmk_VINSERTF64x2Z256rmkz_VINSERTF64x2Zrm_VINSERTF64x2Zrmk_VINSERTF64x2Zrmkz_VINSERTF64x4Zrm_VINSERTF64x4Zrmk_VINSERTF64x4Zrmkz") 2, false, false, false, 375, 10,  8, 1,  5, 1}, // #1280
  {DBGFIELD("VINSERTI32x4Z256rm_VINSERTI32x4Z256rmk_VINSERTI32x4Z256rmkz_VINSERTI32x4Zrm_VINSERTI32x4Zrmk_VINSERTI32x4Zrmkz_VINSERTI32x8Zrm_VINSERTI32x8Zrmk_VINSERTI32x8Zrmkz_VINSERTI64x2Z256rm_VINSERTI64x2Z256rmk_VINSERTI64x2Z256rmkz_VINSERTI64x2Zrm_VINSERTI64x2Zrmk_VINSERTI64x2Zrmkz_VINSERTI64x4Zrm_VINSERTI64x4Zrmk_VINSERTI64x4Zrmkz") 2, false, false, false, 375, 10,  8, 1,  5, 1}, // #1281
  {DBGFIELD("VMOVAPDZ256rm_VMOVAPDZ256rmk_VMOVAPDZ256rmkz_VMOVAPDZrm_VMOVAPDZrmk_VMOVAPDZrmkz_VMOVAPSZ256rm_NOVLX_VMOVAPSZ256rm_VMOVAPSZ256rmk_VMOVAPSZ256rmkz_VMOVAPSZrm_VMOVAPSZrmk_VMOVAPSZrmkz_VMOVUPDZ256rm_VMOVUPDZ256rmk_VMOVUPDZ256rmkz_VMOVUPDZrm_VMOVUPDZrmk_VMOVUPDZrmkz_VMOVUPSZ256rm_NOVLX_VMOVUPSZ256rm_VMOVUPSZ256rmk_VMOVUPSZ256rmkz_VMOVUPSZrm_VMOVUPSZrmk_VMOVUPSZrmkz") 1, false, false, false, 28, 2,  7, 1,  0, 0}, // #1282
  {DBGFIELD("VMOVDDUPZ256rm_VMOVDDUPZ256rmk_VMOVDDUPZ256rmkz_VMOVSHDUPZ256rm_VMOVSHDUPZ256rmk_VMOVSHDUPZ256rmkz_VMOVSLDUPZ256rm_VMOVSLDUPZ256rmk_VMOVSLDUPZ256rmkz") 2, false, false, false, 375, 10, 22, 1,  0, 0}, // #1283
  {DBGFIELD("VMOVDDUPZrm_VMOVDDUPZrmk_VMOVDDUPZrmkz_VMOVSHDUPZrm_VMOVSHDUPZrmk_VMOVSHDUPZrmkz_VMOVSLDUPZrm_VMOVSLDUPZrmk_VMOVSLDUPZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1284
  {DBGFIELD("VMOVDQA32Z256rm_VMOVDQA32Z256rmk_VMOVDQA32Z256rmkz_VMOVDQA32Zrm_VMOVDQA32Zrmk_VMOVDQA32Zrmkz_VMOVDQA64Z256rm_VMOVDQA64Z256rmk_VMOVDQA64Z256rmkz_VMOVDQA64Zrm_VMOVDQA64Zrmk_VMOVDQA64Zrmkz_VMOVDQU16Z256rm_VMOVDQU16Z256rmk_VMOVDQU16Z256rmkz_VMOVDQU16Zrm_VMOVDQU16Zrmk_VMOVDQU16Zrmkz_VMOVDQU32Z256rm_VMOVDQU32Z256rmk_VMOVDQU32Z256rmkz_VMOVDQU32Zrm_VMOVDQU32Zrmk_VMOVDQU32Zrmkz_VMOVDQU64Z256rm_VMOVDQU64Z256rmk_VMOVDQU64Z256rmkz_VMOVDQU64Zrm_VMOVDQU64Zrmk_VMOVDQU64Zrmkz_VMOVDQU8Z256rm_VMOVDQU8Z256rmk_VMOVDQU8Z256rmkz_VMOVDQU8Zrm_VMOVDQU8Zrmk_VMOVDQU8Zrmkz") 1, false, false, false, 28, 2,  7, 1,  0, 0}, // #1285
  {DBGFIELD("VPADDBZ256rm_VPADDBZ256rmk_VPADDBZ256rmkz_VPADDDZ256rm_VPADDDZ256rmb_VPADDDZ256rmbk_VPADDDZ256rmbkz_VPADDDZ256rmk_VPADDDZ256rmkz_VPADDQZ256rm_VPADDQZ256rmb_VPADDQZ256rmbk_VPADDQZ256rmbkz_VPADDQZ256rmk_VPADDQZ256rmkz_VPADDWZ256rm_VPADDWZ256rmk_VPADDWZ256rmkz_VPSUBBZ256rm_VPSUBBZ256rmk_VPSUBBZ256rmkz_VPSUBDZ256rm_VPSUBDZ256rmb_VPSUBDZ256rmbk_VPSUBDZ256rmbkz_VPSUBDZ256rmk_VPSUBDZ256rmkz_VPSUBQZ256rm_VPSUBQZ256rmb_VPSUBQZ256rmbk_VPSUBQZ256rmbkz_VPSUBQZ256rmk_VPSUBQZ256rmkz_VPSUBWZ256rm_VPSUBWZ256rmk_VPSUBWZ256rmkz_VPTERNLOGDZ256rmbi_VPTERNLOGDZ256rmbik_VPTERNLOGDZ256rmbikz_VPTERNLOGDZ256rmi_VPTERNLOGDZ256rmik_VPTERNLOGDZ256rmikz_VPTERNLOGQZ256rmbi_VPTERNLOGQZ256rmbik_VPTERNLOGQZ256rmbikz_VPTERNLOGQZ256rmi_VPTERNLOGQZ256rmik_VPTERNLOGQZ256rmikz") 2, false, false, false, 68, 6, 22, 1,  5, 1}, // #1286
  {DBGFIELD("VPADDBZrm_VPADDBZrmk_VPADDBZrmkz_VPADDDZrm_VPADDDZrmb_VPADDDZrmbk_VPADDDZrmbkz_VPADDDZrmk_VPADDDZrmkz_VPADDQZrm_VPADDQZrmb_VPADDQZrmbk_VPADDQZrmbkz_VPADDQZrmk_VPADDQZrmkz_VPADDWZrm_VPADDWZrmk_VPADDWZrmkz_VPSUBBZrm_VPSUBBZrmk_VPSUBBZrmkz_VPSUBDZrm_VPSUBDZrmb_VPSUBDZrmbk_VPSUBDZrmbkz_VPSUBDZrmk_VPSUBDZrmkz_VPSUBQZrm_VPSUBQZrmb_VPSUBQZrmbk_VPSUBQZrmbkz_VPSUBQZrmk_VPSUBQZrmkz_VPSUBWZrm_VPSUBWZrmk_VPSUBWZrmkz_VPTERNLOGDZrmbi_VPTERNLOGDZrmbik_VPTERNLOGDZrmbikz_VPTERNLOGDZrmi_VPTERNLOGDZrmik_VPTERNLOGDZrmikz_VPTERNLOGQZrmbi_VPTERNLOGQZrmbik_VPTERNLOGQZrmbikz_VPTERNLOGQZrmi_VPTERNLOGQZrmik_VPTERNLOGQZrmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1287
  {DBGFIELD("VPBLENDMBZ256rm_VPBLENDMBZ256rmk_VPBLENDMBZ256rmkz_VPBLENDMDZ256rm_VPBLENDMDZ256rmb_VPBLENDMDZ256rmbk_VPBLENDMDZ256rmbkz_VPBLENDMDZ256rmk_VPBLENDMDZ256rmkz_VPBLENDMQZ256rm_VPBLENDMQZ256rmb_VPBLENDMQZ256rmbk_VPBLENDMQZ256rmbkz_VPBLENDMQZ256rmk_VPBLENDMQZ256rmkz_VPBLENDMWZ256rm_VPBLENDMWZ256rmk_VPBLENDMWZ256rmkz") 4, false, false, false, 621, 5,  9, 1,  5, 1}, // #1288
  {DBGFIELD("VPBLENDMBZrm_VPBLENDMBZrmk_VPBLENDMBZrmkz_VPBLENDMDZrm_VPBLENDMDZrmb_VPBLENDMDZrmbk_VPBLENDMDZrmbkz_VPBLENDMDZrmk_VPBLENDMDZrmkz_VPBLENDMQZrm_VPBLENDMQZrmb_VPBLENDMQZrmbk_VPBLENDMQZrmbkz_VPBLENDMQZrmk_VPBLENDMQZrmkz_VPBLENDMWZrm_VPBLENDMWZrmk_VPBLENDMWZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1289
  {DBGFIELD("VPSCATTERQDZ128mr_VPSCATTERQDZ256mr_VSCATTERQPSZ128mr_VSCATTERQPSZ256mr") 2, false, false, false, 37, 3,  2, 1,  0, 0}, // #1290
  {DBGFIELD("VPSCATTERDDZ128mr_VSCATTERDPSZ128mr") 2, false, false, false, 37, 3,  2, 1,  0, 0}, // #1291
  {DBGFIELD("VPSCATTERDDZ256mr_VSCATTERDPSZ256mr") 2, false, false, false, 37, 3,  2, 1,  0, 0}, // #1292
  {DBGFIELD("VPSCATTERDDZmr")     2, false, false, false, 37, 3,  2, 1,  0, 0}, // #1293
  {DBGFIELD("VALIGNDZ128rmbi_VALIGNDZ128rmbik_VALIGNDZ128rmbikz_VALIGNDZ128rmi_VALIGNDZ128rmik_VALIGNDZ128rmikz_VALIGNQZ128rmbi_VALIGNQZ128rmbik_VALIGNQZ128rmbikz_VALIGNQZ128rmi_VALIGNQZ128rmik_VALIGNQZ128rmikz") 2, false, false, false, 53, 7,  7, 1,  5, 1}, // #1294
  {DBGFIELD("VFPCLASSSDZrm_VFPCLASSSDZrmk_VFPCLASSSSZrm_VFPCLASSSSZrmk") 2, false, false, false, 68, 6,  8, 1,  5, 1}, // #1295
  {DBGFIELD("VPERMI2D128rm_VPERMI2D128rmb_VPERMI2D128rmbk_VPERMI2D128rmbkz_VPERMI2D128rmk_VPERMI2D128rmkz_VPERMI2Q128rm_VPERMI2Q128rmb_VPERMI2Q128rmbk_VPERMI2Q128rmbkz_VPERMI2Q128rmk_VPERMI2Q128rmkz_VPERMT2D128rm_VPERMT2D128rmb_VPERMT2D128rmbk_VPERMT2D128rmbkz_VPERMT2D128rmk_VPERMT2D128rmkz_VPERMT2Q128rm_VPERMT2Q128rmb_VPERMT2Q128rmbk_VPERMT2Q128rmbkz_VPERMT2Q128rmk_VPERMT2Q128rmkz") 2, false, false, false, 375, 10,  8, 1,  5, 1}, // #1296
  {DBGFIELD("VPERMI2PD128rm_VPERMI2PD128rmb_VPERMI2PD128rmbk_VPERMI2PD128rmbkz_VPERMI2PD128rmk_VPERMI2PD128rmkz_VPERMI2PS128rm_VPERMI2PS128rmb_VPERMI2PS128rmbk_VPERMI2PS128rmbkz_VPERMI2PS128rmk_VPERMI2PS128rmkz_VPERMT2PD128rm_VPERMT2PD128rmb_VPERMT2PD128rmbk_VPERMT2PD128rmbkz_VPERMT2PD128rmk_VPERMT2PD128rmkz_VPERMT2PS128rm_VPERMT2PS128rmb_VPERMT2PS128rmbk_VPERMT2PS128rmbkz_VPERMT2PS128rmk_VPERMT2PS128rmkz") 2, false, false, false, 375, 10,  8, 1,  5, 1}, // #1297
  {DBGFIELD("VPMAXSQZ128rm_VPMAXSQZ128rmb_VPMAXSQZ128rmbk_VPMAXSQZ128rmbkz_VPMAXSQZ128rmk_VPMAXSQZ128rmkz_VPMAXUQZ128rm_VPMAXUQZ128rmb_VPMAXUQZ128rmbk_VPMAXUQZ128rmbkz_VPMAXUQZ128rmk_VPMAXUQZ128rmkz_VPMINSQZ128rm_VPMINSQZ128rmb_VPMINSQZ128rmbk_VPMINSQZ128rmbkz_VPMINSQZ128rmk_VPMINSQZ128rmkz_VPMINUQZ128rm_VPMINUQZ128rmb_VPMINUQZ128rmbk_VPMINUQZ128rmbkz_VPMINUQZ128rmk_VPMINUQZ128rmkz") 2, false, false, false, 68, 6,  7, 1,  5, 1}, // #1298
  {DBGFIELD("VCMPPDZ128rmbi_VCMPPDZ128rmbik_VCMPPDZ128rmi_VCMPPDZ128rmik_VCMPPSZ128rmbi_VCMPPSZ128rmbik_VCMPPSZ128rmi_VCMPPSZ128rmik_VFPCLASSPDZ128rm_VFPCLASSPDZ128rmb_VFPCLASSPDZ128rmbk_VFPCLASSPDZ128rmk_VFPCLASSPSZ128rm_VFPCLASSPSZ128rmb_VFPCLASSPSZ128rmbk_VFPCLASSPSZ128rmk") 2, false, false, false, 68, 6,  8, 1,  5, 1}, // #1299
  {DBGFIELD("VCMPSDZrm_VCMPSDZrm_Int_VCMPSDZrm_Intk_VCMPSSZrm_VCMPSSZrm_Int_VCMPSSZrm_Intk") 2, false, false, false, 68, 6,  8, 1,  5, 1}, // #1300
  {DBGFIELD("VPCMPBZ128rmi_VPCMPBZ128rmik_VPCMPDZ128rmi_VPCMPDZ128rmib_VPCMPDZ128rmibk_VPCMPDZ128rmik_VPCMPEQBZ128rm_VPCMPEQBZ128rmk_VPCMPEQDZ128rm_VPCMPEQDZ128rmb_VPCMPEQDZ128rmbk_VPCMPEQDZ128rmk_VPCMPEQQZ128rm_VPCMPEQQZ128rmb_VPCMPEQQZ128rmbk_VPCMPEQQZ128rmk_VPCMPEQWZ128rm_VPCMPEQWZ128rmk_VPCMPGTBZ128rm_VPCMPGTBZ128rmk_VPCMPGTDZ128rm_VPCMPGTDZ128rmb_VPCMPGTDZ128rmbk_VPCMPGTDZ128rmk_VPCMPGTQZ128rm_VPCMPGTQZ128rmb_VPCMPGTQZ128rmbk_VPCMPGTQZ128rmk_VPCMPGTWZ128rm_VPCMPGTWZ128rmk_VPCMPQZ128rmi_VPCMPQZ128rmib_VPCMPQZ128rmibk_VPCMPQZ128rmik_VPCMPUBZ128rmi_VPCMPUBZ128rmik_VPCMPUDZ128rmi_VPCMPUDZ128rmib_VPCMPUDZ128rmibk_VPCMPUDZ128rmik_VPCMPUQZ128rmi_VPCMPUQZ128rmib_VPCMPUQZ128rmibk_VPCMPUQZ128rmik_VPCMPUWZ128rmi_VPCMPUWZ128rmik_VPCMPWZ128rmi_VPCMPWZ128rmik") 2, false, false, false, 68, 6,  7, 1,  5, 1}, // #1301
  {DBGFIELD("VPTESTMBZ128rm_VPTESTMBZ128rmk_VPTESTMDZ128rm_VPTESTMDZ128rmb_VPTESTMDZ128rmbk_VPTESTMDZ128rmk_VPTESTMQZ128rm_VPTESTMQZ128rmb_VPTESTMQZ128rmbk_VPTESTMQZ128rmk_VPTESTMWZ128rm_VPTESTMWZ128rmk_VPTESTNMBZ128rm_VPTESTNMBZ128rmk_VPTESTNMDZ128rm_VPTESTNMDZ128rmb_VPTESTNMDZ128rmbk_VPTESTNMDZ128rmk_VPTESTNMQZ128rm_VPTESTNMQZ128rmb_VPTESTNMQZ128rmbk_VPTESTNMQZ128rmk_VPTESTNMWZ128rm_VPTESTNMWZ128rmk") 2, false, false, false, 69, 5,  7, 1,  5, 1}, // #1302
  {DBGFIELD("CVTPS2PDrm_VCVTPS2PDrm") 2, false, false, false, 68, 6,  8, 1,  0, 0}, // #1303
  {DBGFIELD("VALIGNDZ256rmbi_VALIGNDZ256rmbik_VALIGNDZ256rmbikz_VALIGNDZ256rmi_VALIGNDZ256rmik_VALIGNDZ256rmikz_VALIGNQZ256rmbi_VALIGNQZ256rmbik_VALIGNQZ256rmbikz_VALIGNQZ256rmi_VALIGNQZ256rmik_VALIGNQZ256rmikz") 2, false, false, false, 53, 7, 22, 1,  5, 1}, // #1304
  {DBGFIELD("VALIGNDZrmbi_VALIGNDZrmbik_VALIGNDZrmbikz_VALIGNDZrmi_VALIGNDZrmik_VALIGNDZrmikz_VALIGNQZrmbi_VALIGNQZrmbik_VALIGNQZrmbikz_VALIGNQZrmi_VALIGNQZrmik_VALIGNQZrmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1305
  {DBGFIELD("VPMAXSQZ256rm_VPMAXSQZ256rmb_VPMAXSQZ256rmbk_VPMAXSQZ256rmbkz_VPMAXSQZ256rmk_VPMAXSQZ256rmkz_VPMAXUQZ256rm_VPMAXUQZ256rmb_VPMAXUQZ256rmbk_VPMAXUQZ256rmbkz_VPMAXUQZ256rmk_VPMAXUQZ256rmkz_VPMINSQZ256rm_VPMINSQZ256rmb_VPMINSQZ256rmbk_VPMINSQZ256rmbkz_VPMINSQZ256rmk_VPMINSQZ256rmkz_VPMINUQZ256rm_VPMINUQZ256rmb_VPMINUQZ256rmbk_VPMINUQZ256rmbkz_VPMINUQZ256rmk_VPMINUQZ256rmkz") 2, false, false, false, 68, 6, 22, 1,  5, 1}, // #1306
  {DBGFIELD("VPMAXSQZrm_VPMAXSQZrmb_VPMAXSQZrmbk_VPMAXSQZrmbkz_VPMAXSQZrmk_VPMAXSQZrmkz_VPMAXUQZrm_VPMAXUQZrmb_VPMAXUQZrmbk_VPMAXUQZrmbkz_VPMAXUQZrmk_VPMAXUQZrmkz_VPMINSQZrm_VPMINSQZrmb_VPMINSQZrmbk_VPMINSQZrmbkz_VPMINSQZrmk_VPMINSQZrmkz_VPMINUQZrm_VPMINUQZrmb_VPMINUQZrmbk_VPMINUQZrmbkz_VPMINUQZrmk_VPMINUQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1307
  {DBGFIELD("VCMPPDZ256rmbi_VCMPPDZ256rmbik_VCMPPDZ256rmi_VCMPPDZ256rmik_VCMPPSZ256rmbi_VCMPPSZ256rmbik_VCMPPSZ256rmi_VCMPPSZ256rmik_VFPCLASSPDZ256rm_VFPCLASSPDZ256rmb_VFPCLASSPDZ256rmbk_VFPCLASSPDZ256rmk_VFPCLASSPSZ256rm_VFPCLASSPSZ256rmb_VFPCLASSPSZ256rmbk_VFPCLASSPSZ256rmk") 2, false, false, false, 68, 6,  2, 1,  5, 1}, // #1308
  {DBGFIELD("VCMPPDZrmbi_VCMPPDZrmbik_VCMPPDZrmi_VCMPPDZrmik_VCMPPSZrmbi_VCMPPSZrmbik_VCMPPSZrmi_VCMPPSZrmik_VFPCLASSPDZrm_VFPCLASSPDZrmb_VFPCLASSPDZrmbk_VFPCLASSPDZrmk_VFPCLASSPSZrm_VFPCLASSPSZrmb_VFPCLASSPSZrmbk_VFPCLASSPSZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1309
  {DBGFIELD("VPCMPBZ256rmi_VPCMPBZ256rmik_VPCMPDZ256rmi_VPCMPDZ256rmib_VPCMPDZ256rmibk_VPCMPDZ256rmik_VPCMPEQBZ256rm_VPCMPEQBZ256rmk_VPCMPEQDZ256rm_VPCMPEQDZ256rmb_VPCMPEQDZ256rmbk_VPCMPEQDZ256rmk_VPCMPEQQZ256rm_VPCMPEQQZ256rmb_VPCMPEQQZ256rmbk_VPCMPEQQZ256rmk_VPCMPEQWZ256rm_VPCMPEQWZ256rmk_VPCMPGTBZ256rm_VPCMPGTBZ256rmk_VPCMPGTDZ256rm_VPCMPGTDZ256rmb_VPCMPGTDZ256rmbk_VPCMPGTDZ256rmk_VPCMPGTQZ256rm_VPCMPGTQZ256rmb_VPCMPGTQZ256rmbk_VPCMPGTQZ256rmk_VPCMPGTWZ256rm_VPCMPGTWZ256rmk_VPCMPQZ256rmi_VPCMPQZ256rmib_VPCMPQZ256rmibk_VPCMPQZ256rmik_VPCMPUBZ256rmi_VPCMPUBZ256rmik_VPCMPUDZ256rmi_VPCMPUDZ256rmib_VPCMPUDZ256rmibk_VPCMPUDZ256rmik_VPCMPUQZ256rmi_VPCMPUQZ256rmib_VPCMPUQZ256rmibk_VPCMPUQZ256rmik_VPCMPUWZ256rmi_VPCMPUWZ256rmik_VPCMPWZ256rmi_VPCMPWZ256rmik") 2, false, false, false, 68, 6, 22, 1,  5, 1}, // #1310
  {DBGFIELD("VPCMPBZrmi_VPCMPBZrmik_VPCMPDZrmi_VPCMPDZrmib_VPCMPDZrmibk_VPCMPDZrmik_VPCMPEQBZrm_VPCMPEQBZrmk_VPCMPEQDZrm_VPCMPEQDZrmb_VPCMPEQDZrmbk_VPCMPEQDZrmk_VPCMPEQQZrm_VPCMPEQQZrmb_VPCMPEQQZrmbk_VPCMPEQQZrmk_VPCMPEQWZrm_VPCMPEQWZrmk_VPCMPGTBZrm_VPCMPGTBZrmk_VPCMPGTDZrm_VPCMPGTDZrmb_VPCMPGTDZrmbk_VPCMPGTDZrmk_VPCMPGTQZrm_VPCMPGTQZrmb_VPCMPGTQZrmbk_VPCMPGTQZrmk_VPCMPGTWZrm_VPCMPGTWZrmk_VPCMPQZrmi_VPCMPQZrmib_VPCMPQZrmibk_VPCMPQZrmik_VPCMPUBZrmi_VPCMPUBZrmik_VPCMPUDZrmi_VPCMPUDZrmib_VPCMPUDZrmibk_VPCMPUDZrmik_VPCMPUQZrmi_VPCMPUQZrmib_VPCMPUQZrmibk_VPCMPUQZrmik_VPCMPUWZrmi_VPCMPUWZrmik_VPCMPWZrmi_VPCMPWZrmik") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1311
  {DBGFIELD("VPTESTMBZ256rm_VPTESTMBZ256rmk_VPTESTMDZ256rm_VPTESTMDZ256rmb_VPTESTMDZ256rmbk_VPTESTMDZ256rmk_VPTESTMQZ256rm_VPTESTMQZ256rmb_VPTESTMQZ256rmbk_VPTESTMQZ256rmk_VPTESTMWZ256rm_VPTESTMWZ256rmk_VPTESTNMBZ256rm_VPTESTNMBZ256rmk_VPTESTNMDZ256rm_VPTESTNMDZ256rmb_VPTESTNMDZ256rmbk_VPTESTNMDZ256rmk_VPTESTNMQZ256rm_VPTESTNMQZ256rmb_VPTESTNMQZ256rmbk_VPTESTNMQZ256rmk_VPTESTNMWZ256rm_VPTESTNMWZ256rmk") 2, false, false, false, 69, 5, 22, 1,  5, 1}, // #1312
  {DBGFIELD("VPTESTMBZrm_VPTESTMBZrmk_VPTESTMDZrm_VPTESTMDZrmb_VPTESTMDZrmbk_VPTESTMDZrmk_VPTESTMQZrm_VPTESTMQZrmb_VPTESTMQZrmbk_VPTESTMQZrmk_VPTESTMWZrm_VPTESTMWZrmk_VPTESTNMBZrm_VPTESTNMBZrmk_VPTESTNMDZrm_VPTESTNMDZrmb_VPTESTNMDZrmbk_VPTESTNMDZrmk_VPTESTNMQZrm_VPTESTNMQZrmb_VPTESTNMQZrmbk_VPTESTNMQZrmk_VPTESTNMWZrm_VPTESTNMWZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1313
  {DBGFIELD("VCVTDQ2PDZ128rm_VCVTDQ2PDZ128rmb_VCVTDQ2PDZ128rmbk_VCVTDQ2PDZ128rmbkz_VCVTDQ2PDZ128rmk_VCVTDQ2PDZ128rmkz_VCVTQQ2PDZ128rm_VCVTQQ2PDZ128rmb_VCVTQQ2PDZ128rmbk_VCVTQQ2PDZ128rmbkz_VCVTQQ2PDZ128rmk_VCVTQQ2PDZ128rmkz_VCVTUDQ2PDZ128rm_VCVTUDQ2PDZ128rmb_VCVTUDQ2PDZ128rmbk_VCVTUDQ2PDZ128rmbkz_VCVTUDQ2PDZ128rmk_VCVTUDQ2PDZ128rmkz_VCVTUQQ2PDZ128rm_VCVTUQQ2PDZ128rmb_VCVTUQQ2PDZ128rmbk_VCVTUQQ2PDZ128rmbkz_VCVTUQQ2PDZ128rmk_VCVTUQQ2PDZ128rmkz") 2, false, false, false, 68, 6,  8, 1,  0, 0}, // #1314
  {DBGFIELD("VCVTDQ2PSZ128rm_VCVTDQ2PSZ128rmb_VCVTDQ2PSZ128rmbk_VCVTDQ2PSZ128rmbkz_VCVTDQ2PSZ128rmk_VCVTDQ2PSZ128rmkz_CVTDQ2PSrm_VCVTDQ2PSrm_VCVTQQ2PSZ128rm_VCVTQQ2PSZ128rmb_VCVTQQ2PSZ128rmbk_VCVTQQ2PSZ128rmbkz_VCVTQQ2PSZ128rmk_VCVTQQ2PSZ128rmkz_VCVTUDQ2PSZ128rm_VCVTUDQ2PSZ128rmb_VCVTUDQ2PSZ128rmbk_VCVTUDQ2PSZ128rmbkz_VCVTUDQ2PSZ128rmk_VCVTUDQ2PSZ128rmkz_VCVTUQQ2PSZ128rm_VCVTUQQ2PSZ128rmb_VCVTUQQ2PSZ128rmbk_VCVTUQQ2PSZ128rmbkz_VCVTUQQ2PSZ128rmk_VCVTUQQ2PSZ128rmkz") 2, false, false, false, 68, 6,  8, 1,  0, 0}, // #1315
  {DBGFIELD("VCVTPD2QQZ128rm_VCVTPD2QQZ128rmb_VCVTPD2QQZ128rmbk_VCVTPD2QQZ128rmbkz_VCVTPD2QQZ128rmk_VCVTPD2QQZ128rmkz_VCVTPD2UQQZ128rm_VCVTPD2UQQZ128rmb_VCVTPD2UQQZ128rmbk_VCVTPD2UQQZ128rmbkz_VCVTPD2UQQZ128rmk_VCVTPD2UQQZ128rmkz_VCVTTPD2QQZ128rm_VCVTTPD2QQZ128rmb_VCVTTPD2QQZ128rmbk_VCVTTPD2QQZ128rmbkz_VCVTTPD2QQZ128rmk_VCVTTPD2QQZ128rmkz_VCVTTPD2UQQZ128rm_VCVTTPD2UQQZ128rmb_VCVTTPD2UQQZ128rmbk_VCVTTPD2UQQZ128rmbkz_VCVTTPD2UQQZ128rmk_VCVTTPD2UQQZ128rmkz") 3, false, false, false, 192, 11,  2, 1,  0, 0}, // #1316
  {DBGFIELD("VCVTPH2PSZ128rm_VCVTPH2PSZ128rmk_VCVTPH2PSZ128rmkz") 2, false, false, false, 68, 6,  2, 1,  0, 0}, // #1317
  {DBGFIELD("VCVTPS2DQZ128rm_VCVTPS2DQZ128rmb_VCVTPS2DQZ128rmbk_VCVTPS2DQZ128rmbkz_VCVTPS2DQZ128rmk_VCVTPS2DQZ128rmkz_CVTPS2DQrm_VCVTPS2DQrm_VCVTPS2QQZ128rm_VCVTPS2QQZ128rmb_VCVTPS2QQZ128rmbk_VCVTPS2QQZ128rmbkz_VCVTPS2QQZ128rmk_VCVTPS2QQZ128rmkz_VCVTPS2UDQZ128rm_VCVTPS2UDQZ128rmb_VCVTPS2UDQZ128rmbk_VCVTPS2UDQZ128rmbkz_VCVTPS2UDQZ128rmk_VCVTPS2UDQZ128rmkz_VCVTPS2UQQZ128rm_VCVTPS2UQQZ128rmb_VCVTPS2UQQZ128rmbk_VCVTPS2UQQZ128rmbkz_VCVTPS2UQQZ128rmk_VCVTPS2UQQZ128rmkz_VCVTTPS2DQZ128rm_VCVTTPS2DQZ128rmb_VCVTTPS2DQZ128rmbk_VCVTTPS2DQZ128rmbkz_VCVTTPS2DQZ128rmk_VCVTTPS2DQZ128rmkz_CVTTPS2DQrm_VCVTTPS2DQrm_VCVTTPS2QQZ128rm_VCVTTPS2QQZ128rmb_VCVTTPS2QQZ128rmbk_VCVTTPS2QQZ128rmbkz_VCVTTPS2QQZ128rmk_VCVTTPS2QQZ128rmkz_VCVTTPS2UDQZ128rm_VCVTTPS2UDQZ128rmb_VCVTTPS2UDQZ128rmbk_VCVTTPS2UDQZ128rmbkz_VCVTTPS2UDQZ128rmk_VCVTTPS2UDQZ128rmkz_VCVTTPS2UQQZ128rm_VCVTTPS2UQQZ128rmb_VCVTTPS2UQQZ128rmbk_VCVTTPS2UQQZ128rmbkz_VCVTTPS2UQQZ128rmk_VCVTTPS2UQQZ128rmkz") 2, false, false, false, 68, 6,  8, 1,  0, 0}, // #1318
  {DBGFIELD("VCVTPS2PDZ128rm_VCVTPS2PDZ128rmb_VCVTPS2PDZ128rmbk_VCVTPS2PDZ128rmbkz_VCVTPS2PDZ128rmk_VCVTPS2PDZ128rmkz") 2, false, false, false, 68, 6,  8, 1,  0, 0}, // #1319
  {DBGFIELD("VCVTSS2SDZrm_VCVTSS2SDZrm_Int_VCVTSS2SDZrm_Intk_VCVTSS2SDZrm_Intkz_CVTSS2SDrm_CVTSS2SDrm_Int_VCVTSS2SDrm_VCVTSS2SDrm_Int") 2, false, false, false, 68, 6,  8, 1,  5, 1}, // #1320
  {DBGFIELD("VEXPANDPDZ128rm_VEXPANDPDZ128rmk_VEXPANDPDZ128rmkz_VEXPANDPSZ128rm_VEXPANDPSZ128rmk_VEXPANDPSZ128rmkz_VPEXPANDDZ128rm_VPEXPANDDZ128rmk_VPEXPANDDZ128rmkz_VPEXPANDQZ128rm_VPEXPANDQZ128rmk_VPEXPANDQZ128rmkz") 2, false, false, false, 375, 10,  8, 1,  5, 1}, // #1321
  {DBGFIELD("VCVTDQ2PSYrm")       2, false, false, false, 68, 6,  2, 1,  0, 0}, // #1322
  {DBGFIELD("VCVTPS2PDYrm")       2, false, false, false, 68, 6,  2, 1,  0, 0}, // #1323
  {DBGFIELD("VCVTDQ2PDZ256rm_VCVTDQ2PDZ256rmb_VCVTDQ2PDZ256rmbk_VCVTDQ2PDZ256rmbkz_VCVTDQ2PDZ256rmk_VCVTDQ2PDZ256rmkz_VCVTQQ2PDZ256rm_VCVTQQ2PDZ256rmb_VCVTQQ2PDZ256rmbk_VCVTQQ2PDZ256rmbkz_VCVTQQ2PDZ256rmk_VCVTQQ2PDZ256rmkz_VCVTUDQ2PDZ256rm_VCVTUDQ2PDZ256rmb_VCVTUDQ2PDZ256rmbk_VCVTUDQ2PDZ256rmbkz_VCVTUDQ2PDZ256rmk_VCVTUDQ2PDZ256rmkz_VCVTUQQ2PDZ256rm_VCVTUQQ2PDZ256rmb_VCVTUQQ2PDZ256rmbk_VCVTUQQ2PDZ256rmbkz_VCVTUQQ2PDZ256rmk_VCVTUQQ2PDZ256rmkz") 2, false, false, false, 68, 6,  2, 1,  0, 0}, // #1324
  {DBGFIELD("VCVTDQ2PDZrm_VCVTDQ2PDZrmb_VCVTDQ2PDZrmbk_VCVTDQ2PDZrmbkz_VCVTDQ2PDZrmk_VCVTDQ2PDZrmkz_VCVTQQ2PDZrm_VCVTQQ2PDZrmb_VCVTQQ2PDZrmbk_VCVTQQ2PDZrmbkz_VCVTQQ2PDZrmk_VCVTQQ2PDZrmkz_VCVTUDQ2PDZrm_VCVTUDQ2PDZrmb_VCVTUDQ2PDZrmbk_VCVTUDQ2PDZrmbkz_VCVTUDQ2PDZrmk_VCVTUDQ2PDZrmkz_VCVTUQQ2PDZrm_VCVTUQQ2PDZrmb_VCVTUQQ2PDZrmbk_VCVTUQQ2PDZrmbkz_VCVTUQQ2PDZrmk_VCVTUQQ2PDZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1325
  {DBGFIELD("VCVTDQ2PSZ256rm_VCVTDQ2PSZ256rmb_VCVTDQ2PSZ256rmbk_VCVTDQ2PSZ256rmbkz_VCVTDQ2PSZ256rmk_VCVTDQ2PSZ256rmkz_VCVTQQ2PSZ256rm_VCVTQQ2PSZ256rmb_VCVTQQ2PSZ256rmbk_VCVTQQ2PSZ256rmbkz_VCVTQQ2PSZ256rmk_VCVTQQ2PSZ256rmkz_VCVTUDQ2PSZ256rm_VCVTUDQ2PSZ256rmb_VCVTUDQ2PSZ256rmbk_VCVTUDQ2PSZ256rmbkz_VCVTUDQ2PSZ256rmk_VCVTUDQ2PSZ256rmkz_VCVTUQQ2PSZ256rm_VCVTUQQ2PSZ256rmb_VCVTUQQ2PSZ256rmbk_VCVTUQQ2PSZ256rmbkz_VCVTUQQ2PSZ256rmk_VCVTUQQ2PSZ256rmkz") 2, false, false, false, 68, 6,  2, 1,  0, 0}, // #1326
  {DBGFIELD("VCVTDQ2PSZrm_VCVTDQ2PSZrmb_VCVTDQ2PSZrmbk_VCVTDQ2PSZrmbkz_VCVTDQ2PSZrmk_VCVTDQ2PSZrmkz_VCVTUDQ2PSZrm_VCVTUDQ2PSZrmb_VCVTUDQ2PSZrmbk_VCVTUDQ2PSZrmbkz_VCVTUDQ2PSZrmk_VCVTUDQ2PSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1327
  {DBGFIELD("VCVTPH2PSZ256rm_VCVTPH2PSZ256rmk_VCVTPH2PSZ256rmkz") 2, false, false, false, 68, 6,  2, 1,  0, 0}, // #1328
  {DBGFIELD("VCVTPH2PSZrm_VCVTPH2PSZrmk_VCVTPH2PSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1329
  {DBGFIELD("VCVTPS2PDZ256rm_VCVTPS2PDZ256rmb_VCVTPS2PDZ256rmbk_VCVTPS2PDZ256rmbkz_VCVTPS2PDZ256rmk_VCVTPS2PDZ256rmkz") 2, false, false, false, 68, 6,  2, 1,  0, 0}, // #1330
  {DBGFIELD("VCVTPS2PDZrm_VCVTPS2PDZrmb_VCVTPS2PDZrmbk_VCVTPS2PDZrmbkz_VCVTPS2PDZrmk_VCVTPS2PDZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1331
  {DBGFIELD("VCVTPD2QQZ256rm_VCVTPD2QQZ256rmb_VCVTPD2QQZ256rmbk_VCVTPD2QQZ256rmbkz_VCVTPD2QQZ256rmk_VCVTPD2QQZ256rmkz_VCVTTPD2QQZ256rm_VCVTTPD2QQZ256rmb_VCVTTPD2QQZ256rmbk_VCVTTPD2QQZ256rmbkz_VCVTTPD2QQZ256rmk_VCVTTPD2QQZ256rmkz_VCVTPD2UQQZ256rm_VCVTPD2UQQZ256rmb_VCVTPD2UQQZ256rmbk_VCVTPD2UQQZ256rmbkz_VCVTPD2UQQZ256rmk_VCVTPD2UQQZ256rmkz_VCVTTPD2UQQZ256rm_VCVTTPD2UQQZ256rmb_VCVTTPD2UQQZ256rmbk_VCVTTPD2UQQZ256rmbkz_VCVTTPD2UQQZ256rmk_VCVTTPD2UQQZ256rmkz") 3, false, false, false, 192, 11, 11, 1,  0, 0}, // #1332
  {DBGFIELD("VCVTPD2QQZrm_VCVTPD2QQZrmb_VCVTPD2QQZrmbk_VCVTPD2QQZrmbkz_VCVTPD2QQZrmk_VCVTPD2QQZrmkz_VCVTTPD2QQZrm_VCVTTPD2QQZrmb_VCVTTPD2QQZrmbk_VCVTTPD2QQZrmbkz_VCVTTPD2QQZrmk_VCVTTPD2QQZrmkz_VCVTPD2UQQZrm_VCVTPD2UQQZrmb_VCVTPD2UQQZrmbk_VCVTPD2UQQZrmbkz_VCVTPD2UQQZrmk_VCVTPD2UQQZrmkz_VCVTTPD2UQQZrm_VCVTTPD2UQQZrmb_VCVTTPD2UQQZrmbk_VCVTTPD2UQQZrmbkz_VCVTTPD2UQQZrmk_VCVTTPD2UQQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1333
  {DBGFIELD("VCVTPS2DQYrm_VCVTTPS2DQYrm_VCVTPS2DQZ256rm_VCVTPS2DQZ256rmb_VCVTPS2DQZ256rmbk_VCVTPS2DQZ256rmbkz_VCVTPS2DQZ256rmk_VCVTPS2DQZ256rmkz_VCVTTPS2DQZ256rm_VCVTTPS2DQZ256rmb_VCVTTPS2DQZ256rmbk_VCVTTPS2DQZ256rmbkz_VCVTTPS2DQZ256rmk_VCVTTPS2DQZ256rmkz_VCVTPS2QQZ256rm_VCVTPS2QQZ256rmb_VCVTPS2QQZ256rmbk_VCVTPS2QQZ256rmbkz_VCVTPS2QQZ256rmk_VCVTPS2QQZ256rmkz_VCVTTPS2QQZ256rm_VCVTTPS2QQZ256rmb_VCVTTPS2QQZ256rmbk_VCVTTPS2QQZ256rmbkz_VCVTTPS2QQZ256rmk_VCVTTPS2QQZ256rmkz_VCVTPS2UDQZ256rm_VCVTPS2UDQZ256rmb_VCVTPS2UDQZ256rmbk_VCVTPS2UDQZ256rmbkz_VCVTPS2UDQZ256rmk_VCVTPS2UDQZ256rmkz_VCVTTPS2UDQZ256rm_VCVTTPS2UDQZ256rmb_VCVTTPS2UDQZ256rmbk_VCVTTPS2UDQZ256rmbkz_VCVTTPS2UDQZ256rmk_VCVTTPS2UDQZ256rmkz_VCVTPS2UQQZ256rm_VCVTPS2UQQZ256rmb_VCVTPS2UQQZ256rmbk_VCVTPS2UQQZ256rmbkz_VCVTPS2UQQZ256rmk_VCVTPS2UQQZ256rmkz_VCVTTPS2UQQZ256rm_VCVTTPS2UQQZ256rmb_VCVTTPS2UQQZ256rmbk_VCVTTPS2UQQZ256rmbkz_VCVTTPS2UQQZ256rmk_VCVTTPS2UQQZ256rmkz") 2, false, false, false, 68, 6,  2, 1,  0, 0}, // #1334
  {DBGFIELD("VCVTPS2DQZrm_VCVTPS2DQZrmb_VCVTPS2DQZrmbk_VCVTPS2DQZrmbkz_VCVTPS2DQZrmk_VCVTPS2DQZrmkz_VCVTTPS2DQZrm_VCVTTPS2DQZrmb_VCVTTPS2DQZrmbk_VCVTTPS2DQZrmbkz_VCVTTPS2DQZrmk_VCVTTPS2DQZrmkz_VCVTPS2UDQZrm_VCVTPS2UDQZrmb_VCVTPS2UDQZrmbk_VCVTPS2UDQZrmbkz_VCVTPS2UDQZrmk_VCVTPS2UDQZrmkz_VCVTTPS2UDQZrm_VCVTTPS2UDQZrmb_VCVTTPS2UDQZrmbk_VCVTTPS2UDQZrmbkz_VCVTTPS2UDQZrmk_VCVTTPS2UDQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1335
  {DBGFIELD("VEXPANDPDZ256rm_VEXPANDPDZ256rmk_VEXPANDPDZ256rmkz_VEXPANDPDZrm_VEXPANDPDZrmk_VEXPANDPDZrmkz_VEXPANDPSZ256rm_VEXPANDPSZ256rmk_VEXPANDPSZ256rmkz_VEXPANDPSZrm_VEXPANDPSZrmk_VEXPANDPSZrmkz_VPEXPANDDZ256rm_VPEXPANDDZ256rmk_VPEXPANDDZ256rmkz_VPEXPANDDZrm_VPEXPANDDZrmk_VPEXPANDDZrmkz_VPEXPANDQZ256rm_VPEXPANDQZ256rmk_VPEXPANDQZ256rmkz_VPEXPANDQZrm_VPEXPANDQZrmk_VPEXPANDQZrmkz") 2, false, false, false, 375, 10,  8, 1,  5, 1}, // #1336
  {DBGFIELD("CVTDQ2PDrm_VCVTDQ2PDrm") 2, false, false, false, 68, 6,  8, 1,  0, 0}, // #1337
  {DBGFIELD("CVTPD2DQrm_CVTTPD2DQrm") 3, false, false, false, 192, 11,  2, 1,  0, 0}, // #1338
  {DBGFIELD("VPCONFLICTQZ128rm_VPCONFLICTQZ128rmb_VPCONFLICTQZ128rmbk_VPCONFLICTQZ128rmbkz_VPCONFLICTQZ128rmk_VPCONFLICTQZ128rmkz") 2, false, false, false, 68, 6,  7, 1,  0, 0}, // #1339
  {DBGFIELD("VPMULLQZ128rr_VPMULLQZ128rrk_VPMULLQZ128rrkz") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #1340
  {DBGFIELD("VPMULLQZ256rr_VPMULLQZ256rrk_VPMULLQZ256rrkz") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #1341
  {DBGFIELD("VPMULLQZrr_VPMULLQZrrk_VPMULLQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1342
  {DBGFIELD("VPERMWZ128rm_VPERMWZ128rmk_VPERMWZ128rmkz") 2, false, false, false, 375, 10,  8, 1,  5, 1}, // #1343
  {DBGFIELD("VCVTSD2USIZrm_Int_VCVTTSD2USIZrm_VCVTTSD2USIZrm_Int") 3, false, false, false, 203, 10,  2, 1,  5, 1}, // #1344
  {DBGFIELD("VCVTSS2USI64Zrm_Int_VCVTTSS2USI64Zrm_VCVTTSS2USI64Zrm_Int") 3, false, false, false, 203, 10,  2, 1,  5, 1}, // #1345
  {DBGFIELD("VCVTPS2QQZrm_VCVTPS2QQZrmb_VCVTPS2QQZrmbk_VCVTPS2QQZrmbkz_VCVTPS2QQZrmk_VCVTPS2QQZrmkz_VCVTTPS2QQZrm_VCVTTPS2QQZrmb_VCVTTPS2QQZrmbk_VCVTTPS2QQZrmbkz_VCVTTPS2QQZrmk_VCVTTPS2QQZrmkz_VCVTPS2UQQZrm_VCVTPS2UQQZrmb_VCVTPS2UQQZrmbk_VCVTPS2UQQZrmbkz_VCVTPS2UQQZrmk_VCVTPS2UQQZrmkz_VCVTTPS2UQQZrm_VCVTTPS2UQQZrmb_VCVTTPS2UQQZrmbk_VCVTTPS2UQQZrmbkz_VCVTTPS2UQQZrmk_VCVTTPS2UQQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1346
  {DBGFIELD("VPERMWZ256rm_VPERMWZ256rmk_VPERMWZ256rmkz_VPERMWZrm_VPERMWZrmk_VPERMWZrmkz") 2, false, false, false, 375, 10,  8, 1,  5, 1}, // #1347
  {DBGFIELD("VCVTDQ2PDYrm")       2, false, false, false, 68, 6,  2, 1,  0, 0}, // #1348
  {DBGFIELD("VPERMI2W128rm_VPERMI2W128rmk_VPERMI2W128rmkz_VPERMT2W128rm_VPERMT2W128rmk_VPERMT2W128rmkz") 2, false, false, false, 375, 10,  8, 1,  5, 1}, // #1349
  {DBGFIELD("VCVTPD2DQZrm_VCVTPD2DQZrmb_VCVTPD2DQZrmbk_VCVTPD2DQZrmbkz_VCVTPD2DQZrmk_VCVTPD2DQZrmkz_VCVTPD2UDQZrm_VCVTPD2UDQZrmb_VCVTPD2UDQZrmbk_VCVTPD2UDQZrmbkz_VCVTPD2UDQZrmk_VCVTPD2UDQZrmkz_VCVTTPD2DQZrm_VCVTTPD2DQZrmb_VCVTTPD2DQZrmbk_VCVTTPD2DQZrmbkz_VCVTTPD2DQZrmk_VCVTTPD2DQZrmkz_VCVTTPD2UDQZrm_VCVTTPD2UDQZrmb_VCVTTPD2UDQZrmbk_VCVTTPD2UDQZrmbkz_VCVTTPD2UDQZrmk_VCVTTPD2UDQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1350
  {DBGFIELD("VCVTQQ2PSZrm_VCVTQQ2PSZrmb_VCVTQQ2PSZrmbk_VCVTQQ2PSZrmbkz_VCVTQQ2PSZrmk_VCVTQQ2PSZrmkz_VCVTUQQ2PSZrm_VCVTUQQ2PSZrmb_VCVTUQQ2PSZrmbk_VCVTUQQ2PSZrmbkz_VCVTUQQ2PSZrmk_VCVTUQQ2PSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1351
  {DBGFIELD("VPERMI2W256rm_VPERMI2W256rmk_VPERMI2W256rmkz_VPERMI2Wrm_VPERMI2Wrmk_VPERMI2Wrmkz_VPERMT2W256rm_VPERMT2W256rmk_VPERMT2W256rmkz_VPERMT2Wrm_VPERMT2Wrmk_VPERMT2Wrmkz") 2, false, false, false, 375, 10,  8, 1,  5, 1}, // #1352
  {DBGFIELD("VPCONFLICTDZ128rm_VPCONFLICTDZ128rmb_VPCONFLICTDZ128rmbk_VPCONFLICTDZ128rmbkz_VPCONFLICTDZ128rmk_VPCONFLICTDZ128rmkz") 2, false, false, false, 68, 6,  7, 1,  0, 0}, // #1353
  {DBGFIELD("VPMULLQZ128rm_VPMULLQZ128rmb_VPMULLQZ128rmbk_VPMULLQZ128rmbkz_VPMULLQZ128rmk_VPMULLQZ128rmkz") 2, false, false, false, 68, 6, 24, 1,  5, 1}, // #1354
  {DBGFIELD("VPMULLQZ256rm_VPMULLQZ256rmb_VPMULLQZ256rmbk_VPMULLQZ256rmbkz_VPMULLQZ256rmk_VPMULLQZ256rmkz") 2, false, false, false, 68, 6, 24, 1,  5, 1}, // #1355
  {DBGFIELD("VPMULLQZrm_VPMULLQZrmb_VPMULLQZrmbk_VPMULLQZrmbkz_VPMULLQZrmk_VPMULLQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1356
  {DBGFIELD("VGATHERQPSZ128rm_VPGATHERQDZ128rm_VGATHERDPDZ128rm_VPGATHERDQZ128rm_VGATHERQPDZ128rm_VPGATHERQQZ128rm") 1, false, false, false, 28, 2, 38, 2,  0, 0}, // #1357
  {DBGFIELD("VGATHERQPSZ256rm_VPGATHERQDZ256rm_VGATHERQPDZ256rm_VPGATHERQQZ256rm_VGATHERDPSZ128rm_VPGATHERDDZ128rm_VGATHERDPDZ256rm_VPGATHERDQZ256rm") 1, false, false, false, 28, 2, 38, 2,  0, 0}, // #1358
  {DBGFIELD("VGATHERDPSZ256rm_VPGATHERDDZ256rm_VGATHERDPDZrm_VPGATHERDQZrm_VGATHERQPDZrm_VPGATHERQQZrm_VGATHERQPSZrm_VPGATHERQDZrm") 1, false, false, false, 28, 2, 38, 2,  0, 0}, // #1359
  {DBGFIELD("VGATHERDPSZrm_VPGATHERDDZrm") 1, false, false, false, 28, 2, 38, 2,  0, 0}, // #1360
  {DBGFIELD("VPCONFLICTQZ256rr_VPCONFLICTQZ256rrk_VPCONFLICTQZ256rrkz") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1361
  {DBGFIELD("VPCONFLICTQZ256rm_VPCONFLICTQZ256rmb_VPCONFLICTQZ256rmbk_VPCONFLICTQZ256rmbkz_VPCONFLICTQZ256rmk_VPCONFLICTQZ256rmkz") 2, false, false, false, 68, 6, 22, 1,  0, 0}, // #1362
  {DBGFIELD("VPCONFLICTQZrr_VPCONFLICTQZrrk_VPCONFLICTQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1363
  {DBGFIELD("VPCONFLICTDZ256rm_VPCONFLICTDZ256rmb_VPCONFLICTDZ256rmbk_VPCONFLICTDZ256rmbkz_VPCONFLICTDZ256rmk_VPCONFLICTDZ256rmkz") 2, false, false, false, 68, 6, 22, 1,  0, 0}, // #1364
  {DBGFIELD("VPCONFLICTQZrm_VPCONFLICTQZrmb_VPCONFLICTQZrmbk_VPCONFLICTQZrmbkz_VPCONFLICTQZrmk_VPCONFLICTQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1365
  {DBGFIELD("VPCONFLICTDZrm_VPCONFLICTDZrmb_VPCONFLICTDZrmbk_VPCONFLICTDZrmbkz_VPCONFLICTDZrmk_VPCONFLICTDZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1366
  {DBGFIELD("VXORPSZ128rr_VXORPDZ128rr") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1367
  {DBGFIELD("VXORPSZ256rr_VXORPDZ256rr") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1368
  {DBGFIELD("VXORPSZrr_VXORPDZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1369
  {DBGFIELD("VPXORDZ128rr_VPXORQZ128rr") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1370
  {DBGFIELD("VPXORDZ256rr_VPXORQZ256rr") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1371
  {DBGFIELD("VPXORDZrr_VPXORQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1372
  {DBGFIELD("VPSUBBZ128rr_VPSUBDZ128rr_VPSUBQZ128rr_VPSUBWZ128rr") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1373
  {DBGFIELD("VPSUBBZ256rr_VPSUBDZ256rr_VPSUBQZ256rr_VPSUBWZ256rr") 1, false, false, false,  3, 4,  1, 1,  0, 0}, // #1374
  {DBGFIELD("VPSUBBZrr_VPSUBDZrr_VPSUBQZrr_VPSUBWZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1375
  {DBGFIELD("VPBROADCASTDrr_VPBROADCASTQrr") 1, false, false, false, 60, 8,  1, 1,  0, 0}, // #1376
  {DBGFIELD("INSERTPSrr_VINSERTPSZrr_VINSERTPSrr_MOVHLPSrr_MOVLHPSrr_VMOVHLPSZrr_VMOVHLPSrr_VMOVLHPSZrr_VMOVLHPSrr_MOVDDUPrr_VMOVDDUPrr_VPERMILPDZ128ri_VPERMILPDZ128rik_VPERMILPDZ128rikz_VPERMILPDri_VPERMILPSZ128ri_VPERMILPSZ128rik_VPERMILPSZ128rikz_VPERMILPSri_UNPCKHPDrr_UNPCKHPSrr_UNPCKLPDrr_UNPCKLPSrr_VUNPCKHPDZ128rr_VUNPCKHPDZ128rrk_VUNPCKHPDZ128rrkz_VUNPCKHPDrr_VUNPCKHPSZ128rr_VUNPCKHPSZ128rrk_VUNPCKHPSZ128rrkz_VUNPCKHPSrr_VUNPCKLPDZ128rr_VUNPCKLPDZ128rrk_VUNPCKLPDZ128rrkz_VUNPCKLPDrr_VUNPCKLPSZ128rr_VUNPCKLPSZ128rrk_VUNPCKLPSZ128rrkz_VUNPCKLPSrr") 1, false, false, false, 60, 8,  1, 1,  0, 0}, // #1377
  {DBGFIELD("VMOVDDUPYrr_VPERMILPDYri_VPERMILPDZ256ri_VPERMILPDZ256rik_VPERMILPDZ256rikz_VPERMILPSYri_VPERMILPSZ256ri_VPERMILPSZ256rik_VPERMILPSZ256rikz_VUNPCKHPDYrr_VUNPCKHPDZ256rr_VUNPCKHPDZ256rrk_VUNPCKHPDZ256rrkz_VUNPCKHPSYrr_VUNPCKHPSZ256rr_VUNPCKHPSZ256rrk_VUNPCKHPSZ256rrkz_VUNPCKLPDYrr_VUNPCKLPDZ256rr_VUNPCKLPDZ256rrk_VUNPCKLPDZ256rrkz_VUNPCKLPSYrr_VUNPCKLPSZ256rr_VUNPCKLPSZ256rrk_VUNPCKLPSZ256rrkz") 1, false, false, false, 60, 8,  1, 1,  0, 0}, // #1378
  {DBGFIELD("VPALIGNRYrri")       1, false, false, false, 60, 8,  1, 1,  0, 0}, // #1379
  {DBGFIELD("VPERMILPDrr_VPERMILPSrr") 1, false, false, false, 60, 8,  1, 1,  0, 0}, // #1380
  {DBGFIELD("MOVSDrr_MOVSDrr_REV_VMOVSDZrr_VMOVSDZrr_REV_VMOVSDZrrk_VMOVSDZrrk_REV_VMOVSDZrrkz_VMOVSDZrrkz_REV_VMOVSDrr_VMOVSDrr_REV_VMOVSSZrr_VMOVSSZrr_REV_VMOVSSZrrk_VMOVSSZrrk_REV_VMOVSSZrrkz_VMOVSSZrrkz_REV_VMOVSSrr_VMOVSSrr_REV") 1, false, false, false, 60, 8,  1, 1,  0, 0}, // #1381
  {DBGFIELD("VPACKSSDWYrr_VPACKSSWBYrr_VPACKUSDWYrr_VPACKUSWBYrr") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1382
  {DBGFIELD("VPBROADCASTBZ128rm_VPBROADCASTBZ128rmk_VPBROADCASTBZ128rmkz_VPBROADCASTWZ128rm_VPBROADCASTWZ128rmk_VPBROADCASTWZ128rmkz") 2, false, false, false, 53, 7,  7, 1,  0, 0}, // #1383
  {DBGFIELD("INSERTPSrm_VINSERTPSZrm_VINSERTPSrm_UNPCKHPDrm_UNPCKHPSrm_UNPCKLPDrm_UNPCKLPSrm_VUNPCKHPDZ128rm_VUNPCKHPDZ128rmb_VUNPCKHPDZ128rmbk_VUNPCKHPDZ128rmbkz_VUNPCKHPDZ128rmk_VUNPCKHPDZ128rmkz_VUNPCKHPDrm_VUNPCKHPSZ128rm_VUNPCKHPSZ128rmb_VUNPCKHPSZ128rmbk_VUNPCKHPSZ128rmbkz_VUNPCKHPSZ128rmk_VUNPCKHPSZ128rmkz_VUNPCKHPSrm_VUNPCKLPDZ128rm_VUNPCKLPDZ128rmb_VUNPCKLPDZ128rmbk_VUNPCKLPDZ128rmbkz_VUNPCKLPDZ128rmk_VUNPCKLPDZ128rmkz_VUNPCKLPDrm_VUNPCKLPSZ128rm_VUNPCKLPSZ128rmb_VUNPCKLPSZ128rmbk_VUNPCKLPSZ128rmbkz_VUNPCKLPSZ128rmk_VUNPCKLPSZ128rmkz_VUNPCKLPSrm") 2, false, false, false, 375, 10,  7, 1,  5, 1}, // #1384
  {DBGFIELD("PALIGNRrmi_VPALIGNRZ128rmi_VPALIGNRZ128rmik_VPALIGNRZ128rmikz_VPALIGNRrmi") 2, false, false, false, 53, 7,  7, 1,  5, 1}, // #1385
  {DBGFIELD("VPERMILPDZ128mbi_VPERMILPDZ128mbik_VPERMILPDZ128mbikz_VPERMILPDZ128mi_VPERMILPDZ128mik_VPERMILPDZ128mikz_VPERMILPDmi_VPERMILPSZ128mbi_VPERMILPSZ128mbik_VPERMILPSZ128mbikz_VPERMILPSZ128mi_VPERMILPSZ128mik_VPERMILPSZ128mikz_VPERMILPSmi") 2, false, false, false, 375, 10,  7, 1,  0, 0}, // #1386
  {DBGFIELD("VPERMILPDZ128rm_VPERMILPDZ128rmb_VPERMILPDZ128rmbk_VPERMILPDZ128rmbkz_VPERMILPDZ128rmk_VPERMILPDZ128rmkz_VPERMILPDrm_VPERMILPSZ128rm_VPERMILPSZ128rmb_VPERMILPSZ128rmbk_VPERMILPSZ128rmbkz_VPERMILPSZ128rmk_VPERMILPSZ128rmkz_VPERMILPSrm") 2, false, false, false, 375, 10,  7, 1,  5, 1}, // #1387
  {DBGFIELD("VPALIGNRYrmi_VPALIGNRZ256rmi_VPALIGNRZ256rmik_VPALIGNRZ256rmikz") 2, false, false, false, 53, 7, 22, 1,  5, 1}, // #1388
  {DBGFIELD("VPERMILPDYmi_VPERMILPDZ256mbi_VPERMILPDZ256mbik_VPERMILPDZ256mbikz_VPERMILPDZ256mi_VPERMILPDZ256mik_VPERMILPDZ256mikz_VPERMILPSYmi_VPERMILPSZ256mbi_VPERMILPSZ256mbik_VPERMILPSZ256mbikz_VPERMILPSZ256mi_VPERMILPSZ256mik_VPERMILPSZ256mikz") 2, false, false, false, 375, 10, 22, 1,  0, 0}, // #1389
  {DBGFIELD("VPERMILPDYrm_VPERMILPDZ256rm_VPERMILPDZ256rmb_VPERMILPDZ256rmbk_VPERMILPDZ256rmbkz_VPERMILPDZ256rmk_VPERMILPDZ256rmkz_VPERMILPSYrm_VPERMILPSZ256rm_VPERMILPSZ256rmb_VPERMILPSZ256rmbk_VPERMILPSZ256rmbkz_VPERMILPSZ256rmk_VPERMILPSZ256rmkz") 2, false, false, false, 375, 10, 22, 1,  5, 1}, // #1390
  {DBGFIELD("VUNPCKHPDYrm_VUNPCKHPDZ256rm_VUNPCKHPDZ256rmb_VUNPCKHPDZ256rmbk_VUNPCKHPDZ256rmbkz_VUNPCKHPDZ256rmk_VUNPCKHPDZ256rmkz_VUNPCKHPSYrm_VUNPCKHPSZ256rm_VUNPCKHPSZ256rmb_VUNPCKHPSZ256rmbk_VUNPCKHPSZ256rmbkz_VUNPCKHPSZ256rmk_VUNPCKHPSZ256rmkz_VUNPCKLPDYrm_VUNPCKLPDZ256rm_VUNPCKLPDZ256rmb_VUNPCKLPDZ256rmbk_VUNPCKLPDZ256rmbkz_VUNPCKLPDZ256rmk_VUNPCKLPDZ256rmkz_VUNPCKLPSYrm_VUNPCKLPSZ256rm_VUNPCKLPSZ256rmb_VUNPCKLPSZ256rmbk_VUNPCKLPSZ256rmbkz_VUNPCKLPSZ256rmk_VUNPCKLPSZ256rmkz") 2, false, false, false, 375, 10, 22, 1,  5, 1}, // #1391
  {DBGFIELD("PACKSSDWrm_PACKSSWBrm_PACKUSDWrm_PACKUSWBrm_VPACKSSDWZ128rm_VPACKSSDWZ128rmb_VPACKSSDWZ128rmbk_VPACKSSDWZ128rmbkz_VPACKSSDWZ128rmk_VPACKSSDWZ128rmkz_VPACKSSDWrm_VPACKSSWBZ128rm_VPACKSSWBZ128rmk_VPACKSSWBZ128rmkz_VPACKSSWBrm_VPACKUSDWZ128rm_VPACKUSDWZ128rmb_VPACKUSDWZ128rmbk_VPACKUSDWZ128rmbkz_VPACKUSDWZ128rmk_VPACKUSDWZ128rmkz_VPACKUSDWrm_VPACKUSWBZ128rm_VPACKUSWBZ128rmk_VPACKUSWBZ128rmkz_VPACKUSWBrm") 2, false, false, false, 53, 7,  7, 1,  5, 1}, // #1392
  {DBGFIELD("VPACKSSDWYrm_VPACKSSDWZ256rm_VPACKSSDWZ256rmb_VPACKSSDWZ256rmbk_VPACKSSDWZ256rmbkz_VPACKSSDWZ256rmk_VPACKSSDWZ256rmkz_VPACKSSWBYrm_VPACKSSWBZ256rm_VPACKSSWBZ256rmk_VPACKSSWBZ256rmkz_VPACKUSDWYrm_VPACKUSDWZ256rm_VPACKUSDWZ256rmb_VPACKUSDWZ256rmbk_VPACKUSDWZ256rmbkz_VPACKUSDWZ256rmk_VPACKUSDWZ256rmkz_VPACKUSWBYrm_VPACKUSWBZ256rm_VPACKUSWBZ256rmk_VPACKUSWBZ256rmkz") 2, false, false, false, 53, 7, 22, 1,  5, 1}, // #1393
  {DBGFIELD("VPACKSSDWZrm_VPACKSSDWZrmb_VPACKSSDWZrmbk_VPACKSSDWZrmbkz_VPACKSSDWZrmk_VPACKSSDWZrmkz_VPACKSSWBZrm_VPACKSSWBZrmk_VPACKSSWBZrmkz_VPACKUSDWZrm_VPACKUSDWZrmb_VPACKUSDWZrmbk_VPACKUSDWZrmbkz_VPACKUSDWZrmk_VPACKUSDWZrmkz_VPACKUSWBZrm_VPACKUSWBZrmk_VPACKUSWBZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1394
  {DBGFIELD("AADD64mr_AAND64mr_AOR64mr_AXOR64mr") 3, false, false, false, 1609, 8,  6, 1,  0, 0}, // #1395
  {DBGFIELD("JMP16m_JMP16m_NT_JMP32m_JMP32m_NT_JMP64m_JMP64m_NT") 2, false, false, false, 163, 6,  3, 1,  0, 0}, // #1396
  {DBGFIELD("RET16")              2, false, false, false, 163, 6,  3, 1,  0, 0}, // #1397
  {DBGFIELD("RORX32mi_RORX64mi")  2, false, false, false, 163, 6,  3, 1,  0, 0}, // #1398
  {DBGFIELD("ADC16rm_ADC32rm_ADC64rm_ADC8rm_SBB16rm_SBB32rm_SBB64rm_SBB8rm_ADCX32rm_ADCX64rm_ADOX32rm_ADOX64rm") 2, false, false, false, 163, 6,  3, 1, 11, 2}, // #1399
  {DBGFIELD("ADC8mi_ADC8mi8_SBB8mi_SBB8mi8") 5, false, false, false, 45, 8, 24, 1,  0, 0}, // #1400
  {DBGFIELD("CMP16mi_CMP32mi_CMP8mi_CMP16mi8_CMP32mi8_CMP64mi8_CMP8mi8") 2, false, false, false, 71, 3,  3, 1,  0, 0}, // #1401
  {DBGFIELD("MOV8rm")             2, false, false, false, 71, 3,  3, 1,  0, 0}, // #1402
  {DBGFIELD("POP16rmr_POP32rmr")  2, false, false, false, 71, 3,  3, 1,  0, 0}, // #1403
  {DBGFIELD("POP32r")             2, false, false, false, 71, 3,  3, 1,  0, 0}, // #1404
  {DBGFIELD("CMP64mi32")          2, false, false, false, 71, 3,  3, 1,  0, 0}, // #1405
  {DBGFIELD("MOV8rm_NOREX")       2, false, false, false, 71, 3,  3, 1,  0, 0}, // #1406
  {DBGFIELD("MOVZX16rm8")         2, false, false, false, 71, 3,  3, 1,  0, 0}, // #1407
  {DBGFIELD("ADD16rm_ADD32rm_ADD64rm_ADD8rm_CMP16rm_CMP32rm_CMP64rm_CMP8rm_SUB16rm_SUB32rm_SUB64rm_SUB8rm_AND16rm_AND32rm_AND8rm_OR16rm_OR32rm_OR8rm_XOR16rm_XOR32rm_XOR8rm") 2, false, false, false, 71, 3,  3, 1,  3, 1}, // #1408
  {DBGFIELD("CMP16mr_CMP32mr_CMP64mr_CMP8mr") 2, false, false, false, 71, 3,  3, 1,  3, 1}, // #1409
  {DBGFIELD("ADD64ri8_SUB64ri8_DEC64r_INC64r") 0, false, false, false,  0, 0,  1, 1,  0, 0}, // #1410
  {DBGFIELD("MOV64rr_MOV64rr_REV") 0, false, false, false,  0, 0,  1, 1,  0, 0}, // #1411
  {DBGFIELD("JMP_2")              0, false, false, false,  0, 0,  1, 1,  0, 0}, // #1412
  {DBGFIELD("ADD8mi_ADD8mi8_SUB8mi_SUB8mi8") 4, false, false, false, 40, 5, 24, 1,  0, 0}, // #1413
  {DBGFIELD("AND8mi_AND8mi8_OR8mi_OR8mi8_XOR8mi_XOR8mi8") 4, false, false, false, 40, 5, 24, 1,  0, 0}, // #1414
  {DBGFIELD("DEC8m_INC8m_NEG8m_NOT8m") 4, false, false, false, 40, 5, 24, 1,  0, 0}, // #1415
  {DBGFIELD("ADD8mr")             4, false, false, false, 40, 5, 24, 1,  3, 1}, // #1416
  {DBGFIELD("AND8mr_OR8mr_XOR8mr") 4, false, false, false, 40, 5, 24, 1,  3, 1}, // #1417
  {DBGFIELD("SUB8mr")             4, false, false, false, 40, 5, 24, 1,  3, 1}, // #1418
  {DBGFIELD("ADDSSrr_ADDSSrr_Int_SUBSSrr_SUBSSrr_Int_VADDSSrr_VADDSSrr_Int_VSUBSSrr_VSUBSSrr_Int") 1, false, false, false, 53, 5,  5, 1,  0, 0}, // #1419
  {DBGFIELD("AND16ri8_AND16rr_AND32ri8_AND32rr_AND64ri8_AND64rr_AND8ri8_AND8rr_AND16rr_REV_AND32rr_REV_AND64rr_REV_AND8rr_REV_TEST32i32_TEST64i32_AND32ri_AND8ri_TEST32ri_TEST8ri_AND64ri32_TEST64ri32_TEST8i8_OR16ri8_OR16rr_OR32ri8_OR32rr_OR64ri8_OR64rr_OR8ri8_OR8rr_XOR16ri8_XOR16rr_XOR32ri8_XOR64ri8_XOR8ri8_XOR8rr_OR16rr_REV_OR32rr_REV_OR64rr_REV_OR8rr_REV_XOR16rr_REV_XOR8rr_REV_OR32ri_OR8ri_XOR32ri_XOR8ri_OR64ri32_XOR64ri32_TEST16rr_TEST32rr_TEST64rr_TEST8rr") 1, false, false, false,  1, 1, 12, 1,  0, 0}, // #1420
  {DBGFIELD("AND32i32_AND64i32_AND8i8_OR32i32_OR64i32_XOR32i32_XOR64i32_OR8i8_XOR8i8") 1, false, false, false,  1, 1, 12, 1,  0, 0}, // #1421
  {DBGFIELD("XOR32rr_XOR64rr")    1, false, false, false,  1, 1, 12, 1,  0, 0}, // #1422
  {DBGFIELD("XOR32rr_REV_XOR64rr_REV") 1, false, false, false,  1, 1, 12, 1,  0, 0}, // #1423
  {DBGFIELD("XOR8rr_NOREX")       1, false, false, false,  1, 1, 12, 1,  0, 0}, // #1424
  {DBGFIELD("TEST16mi_TEST32mi_TEST8mi") 2, false, false, false, 71, 3,  6, 1,  0, 0}, // #1425
  {DBGFIELD("TEST64mi32")         2, false, false, false, 71, 3,  6, 1,  0, 0}, // #1426
  {DBGFIELD("OR64rm_XOR64rm")     2, false, false, false, 71, 3,  6, 1,  3, 1}, // #1427
  {DBGFIELD("AND64rm")            2, false, false, false, 71, 3,  6, 1,  3, 1}, // #1428
  {DBGFIELD("TEST16mr_TEST32mr_TEST64mr_TEST8mr") 2, false, false, false, 71, 3,  6, 1,  3, 1}, // #1429
  {DBGFIELD("BT64mr")             9, false, false, false, 1617, 11,  9, 1,  0, 0}, // #1430
  {DBGFIELD("BT64rr")             1, false, false, false, 30, 7,  5, 1,  0, 0}, // #1431
  {DBGFIELD("BTC64rr_BTR64rr_BTS64rr") 1, false, false, false, 30, 7,  5, 1,  0, 0}, // #1432
  {DBGFIELD("BTC64mr_BTR64mr_BTS64mr") 10, false, false, false, 1628, 13, 20, 1,  0, 0}, // #1433
  {DBGFIELD("CALL64m_CALL64m_NT") 5, false, false, false, 45, 8,  6, 1,  0, 0}, // #1434
  {DBGFIELD("CALL64r_CALL64r_NT") 3, false, false, false, 1208, 7,  5, 1,  0, 0}, // #1435
  {DBGFIELD("CDQE_CWDE")          1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1436
  {DBGFIELD("MOVSHDUPrr_MOVSLDUPrr_VMOVSHDUPrr_VMOVSLDUPrr_SHUFPDrri_SHUFPSrri_VSHUFPDrri_VSHUFPSrri") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1437
  {DBGFIELD("VMOVSHDUPYrr_VMOVSLDUPYrr_VSHUFPDYrri_VSHUFPSYrri") 1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1438
  {DBGFIELD("VPBLENDWYrri")       1, false, false, false, 53, 5,  1, 1,  0, 0}, // #1439
  {DBGFIELD("CLFLUSH")            4, false, false, false, 1641, 7, 12, 1,  0, 0}, // #1440
  {DBGFIELD("CLTS")               10, false, false, false, 1648, 11,  4, 1,  0, 0}, // #1441
  {DBGFIELD("MOV16o16a_MOV16o32a_MOV16o64a") 3, false, false, false, 629, 4, 10, 1,  0, 0}, // #1442
  {DBGFIELD("CLWB")               3, false, false, false, 629, 4, 10, 1,  0, 0}, // #1443
  {DBGFIELD("CVTSD2SIrm_CVTSD2SIrm_Int_CVTTSD2SIrm_CVTTSD2SIrm_Int_VCVTSD2SIrm_VCVTSD2SIrm_Int_VCVTTSD2SIrm") 3, false, false, false, 203, 10, 76, 1,  0, 0}, // #1444
  {DBGFIELD("VCVTTSD2SIrm_Int")   3, false, false, false, 203, 10, 76, 1,  0, 0}, // #1445
  {DBGFIELD("VCVTSI642SSrm_Int")  3, false, false, false, 192, 11,  2, 1,  5, 1}, // #1446
  {DBGFIELD("VCVTSI642SSrm")      3, false, false, false, 192, 11,  2, 1,  5, 1}, // #1447
  {DBGFIELD("VCVTSI642SSrr_Int")  3, false, false, false, 657, 9,  7, 1,  6, 1}, // #1448
  {DBGFIELD("JECXZ_JRCXZ")        2, false, false, false, 45, 4, 12, 1,  0, 0}, // #1449
  {DBGFIELD("ST_Frr")             1, false, false, false,  5, 2,  1, 1,  0, 0}, // #1450
  {DBGFIELD("MOV16sr_MOV32sr")    1, false, false, false,  5, 2,  1, 1,  0, 0}, // #1451
  {DBGFIELD("DEC16r_alt_SALC")    1, false, false, false,  5, 2,  1, 1,  0, 0}, // #1452
  {DBGFIELD("SYSCALL")            1, false, false, false,  5, 2,  1, 1,  0, 0}, // #1453
  {DBGFIELD("DEC32r_alt")         1, false, false, false, 554, 8,  6, 1,  0, 0}, // #1454
  {DBGFIELD("DIVR_FPrST0_DIVR_FrST0") 1, false, false, false,  2, 8, 11, 1,  0, 0}, // #1455
  {DBGFIELD("DIVSDrm_Int_VDIVSDrm_Int") 2, false, false, false, 173, 10, 15, 1,  5, 1}, // #1456
  {DBGFIELD("DIV_FPrST0_DIV_FrST0") 1, false, false, false,  2, 8, 15, 1,  0, 0}, // #1457
  {DBGFIELD("SMSW16m")            3, false, false, false, 1031, 11,  2, 1,  0, 0}, // #1458
  {DBGFIELD("MMX_PEXTRWrr")       2, false, false, false, 441, 11, 14, 1,  0, 0}, // #1459
  {DBGFIELD("MMX_PADDBrr_MMX_PADDDrr_MMX_PADDWrr") 1, false, false, false,  4, 5,  1, 1,  0, 0}, // #1460
  {DBGFIELD("GF2P8AFFINEINVQBrmi_GF2P8AFFINEQBrmi_VGF2P8AFFINEINVQBrmi_VGF2P8AFFINEQBrmi") 2, false, false, false, 68, 6,  2, 1,  5, 1}, // #1461
  {DBGFIELD("GF2P8MULBrm_VGF2P8MULBrm") 2, false, false, false, 68, 6,  2, 1,  5, 1}, // #1462
  {DBGFIELD("VGF2P8AFFINEINVQBYrmi_VGF2P8AFFINEQBYrmi") 2, false, false, false, 68, 6,  2, 1,  5, 1}, // #1463
  {DBGFIELD("VGF2P8MULBYrm")      2, false, false, false, 68, 6,  2, 1,  5, 1}, // #1464
  {DBGFIELD("GF2P8MULBrr_VGF2P8MULBrr") 1, false, false, false,  3, 4, 10, 1,  0, 0}, // #1465
  {DBGFIELD("VGF2P8MULBYrr")      1, false, false, false,  3, 4, 10, 1,  0, 0}, // #1466
  {DBGFIELD("IN16ri")             87, false, false, false, 1659, 14, 51, 1,  0, 0}, // #1467
  {DBGFIELD("IN16rr")             87, false, false, false, 1673, 14, 51, 1,  0, 0}, // #1468
  {DBGFIELD("IN32ri")             94, false, false, false, 1687, 14, 51, 1,  0, 0}, // #1469
  {DBGFIELD("IN32rr")             99, false, false, false, 1701, 14,  1, 1,  0, 0}, // #1470
  {DBGFIELD("INC16r_alt")         4, false, false, false, 10, 4,  1, 1,  0, 0}, // #1471
  {DBGFIELD("INC32r_alt")         1, false, false, false, 28, 2,  6, 1,  0, 0}, // #1472
  {DBGFIELD("INSB")               83, false, false, false, 1715, 16, 15, 1,  0, 0}, // #1473
  {DBGFIELD("INSL")               92, false, false, false, 1731, 16, 15, 1,  0, 0}, // #1474
  {DBGFIELD("INVLPG")             42, false, false, false, 1747, 15,  4, 1,  0, 0}, // #1475
  {DBGFIELD("JMP64r_REX")         1, false, false, false, 1762, 5,  1, 1,  0, 0}, // #1476
  {DBGFIELD("JMP_1_JMP_4")        0, false, false, false,  0, 0,  0, 1,  0, 0}, // #1477
  {DBGFIELD("LAR16rm")            81, false, false, false, 1767, 14, 77, 1,  0, 0}, // #1478
  {DBGFIELD("LAR16rr")            22, false, false, false, 1242, 14, 78, 1,  0, 0}, // #1479
  {DBGFIELD("LAR32rm")            85, false, false, false, 1781, 14, 79, 1,  0, 0}, // #1480
  {DBGFIELD("LAR64rm")            87, false, false, false, 1781, 14, 79, 1,  0, 0}, // #1481
  {DBGFIELD("LEAVE")              4, false, false, false, 623, 3,  3, 1,  0, 0}, // #1482
  {DBGFIELD("LGDT64m")            14, false, false, false, 1795, 15,  4, 1,  0, 0}, // #1483
  {DBGFIELD("LIDT64m")            14, false, false, false, 1810, 14,  4, 1,  0, 0}, // #1484
  {DBGFIELD("LLDT16m")            12, false, false, false, 1824, 13,  4, 1,  0, 0}, // #1485
  {DBGFIELD("LLDT16r")            11, false, false, false, 1837, 13,  4, 1,  0, 0}, // #1486
  {DBGFIELD("LMSW16m")            27, false, false, false, 1850, 16,  4, 1,  0, 0}, // #1487
  {DBGFIELD("LMSW16r")            22, false, false, false, 1866, 14,  4, 1,  0, 0}, // #1488
  {DBGFIELD("MMX_MOVD64mr")       2, false, false, false, 37, 3, 13, 1,  0, 0}, // #1489
  {DBGFIELD("MMX_MOVD64rm_MMX_MOVQ64rm") 1, false, false, false, 28, 2,  7, 1,  0, 0}, // #1490
  {DBGFIELD("MMX_MOVD64to64rm")   1, false, false, false, 28, 2,  7, 1,  0, 0}, // #1491
  {DBGFIELD("MMX_MOVFR642Qrr")    2, false, false, false, 184, 5,  5, 1,  0, 0}, // #1492
  {DBGFIELD("MMX_PACKSSDWrm_MMX_PACKSSWBrm") 3, false, false, false, 1224, 10,  2, 1,  5, 1}, // #1493
  {DBGFIELD("MMX_PACKSSDWrr_MMX_PACKSSWBrr") 2, false, false, false, 1234, 8, 14, 1,  0, 0}, // #1494
  {DBGFIELD("MMX_PINSRWrr")       2, false, false, false, 1234, 8, 14, 1,  6, 1}, // #1495
  {DBGFIELD("MMX_PADDBrm_MMX_PADDDrm_MMX_PADDWrm_MMX_PSUBBrm_MMX_PSUBDrm_MMX_PSUBWrm") 2, false, false, false, 395, 7, 22, 1,  5, 1}, // #1496
  {DBGFIELD("MMX_PINSRWrm")       2, false, false, false, 375, 10, 22, 1,  3, 1}, // #1497
  {DBGFIELD("VPALIGNRYrmi")       2, false, false, false, 375, 10, 22, 1,  5, 1}, // #1498
  {DBGFIELD("MOV16ao16_MOV16ao32_MOV16ao64") 2, false, false, false, 71, 3, 10, 1,  0, 0}, // #1499
  {DBGFIELD("PUSHFS16_PUSHFS32_PUSHGS16_PUSHGS32") 3, false, false, false, 30, 10,  2, 1,  0, 0}, // #1500
  {DBGFIELD("MOV16ms")            3, false, false, false, 30, 10,  2, 1,  0, 0}, // #1501
  {DBGFIELD("MOVBE32mr")          3, false, false, false, 30, 10,  2, 1,  0, 0}, // #1502
  {DBGFIELD("MOV16rs_MOV32rs_MOV64rs") 2, false, false, false, 333, 7,  1, 1,  0, 0}, // #1503
  {DBGFIELD("SLDT16r")            2, false, false, false, 333, 7,  1, 1,  0, 0}, // #1504
  {DBGFIELD("STR16r")             2, false, false, false, 333, 7,  1, 1,  0, 0}, // #1505
  {DBGFIELD("MOV32ao16_MOV32ao32_MOV32ao64") 1, false, false, false, 28, 2,  1, 1,  0, 0}, // #1506
  {DBGFIELD("MOV64ao64")          1, false, false, false, 28, 2,  1, 1,  0, 0}, // #1507
  {DBGFIELD("MOV32o16a_MOV32o32a_MOV8o16a_MOV8o32a_MOV32o64a_MOV64o64a_MOV8o64a") 3, false, false, false, 629, 4,  1, 1,  0, 0}, // #1508
  {DBGFIELD("MOVZX32rr8_MOVZX64rr8") 1, false, false, false,  1, 1,  0, 1,  0, 0}, // #1509
  {DBGFIELD("MOVZX32rr8_NOREX")   1, false, false, false,  1, 1,  0, 1,  0, 0}, // #1510
  {DBGFIELD("MOV64ao32")          1, false, false, false, 28, 2, 10, 1,  0, 0}, // #1511
  {DBGFIELD("MOV64dr")            48, false, false, false, 1880, 14, 80, 1,  0, 0}, // #1512
  {DBGFIELD("MOV64o32a")          2, false, false, false, 37, 3,  2, 1,  0, 0}, // #1513
  {DBGFIELD("MOV64rc")            3, false, false, false, 1894, 9,  4, 1,  0, 0}, // #1514
  {DBGFIELD("MOV64rd")            24, false, false, false, 1903, 11, 81, 1,  0, 0}, // #1515
  {DBGFIELD("MOV8ao16_MOV8ao32_MOV8ao64") 2, false, false, false, 71, 3,  1, 1,  0, 0}, // #1516
  {DBGFIELD("MOV8mi_MOV8mr")      2, false, false, false, 37, 3, 24, 1,  0, 0}, // #1517
  {DBGFIELD("MOV8mr_NOREX")       2, false, false, false, 37, 3, 24, 1,  0, 0}, // #1518
  {DBGFIELD("MOVBE32rm")          2, false, false, false, 119, 9,  3, 1,  0, 0}, // #1519
  {DBGFIELD("SLDT16m")            4, false, false, false, 1046, 12,  2, 1,  0, 0}, // #1520
  {DBGFIELD("STRm")               4, false, false, false, 1046, 12,  2, 1,  0, 0}, // #1521
  {DBGFIELD("MOVDIR64B16_MOVDIR64B32_MOVDIR64B64") 4, false, false, false, 554, 8,  1, 1,  0, 0}, // #1522
  {DBGFIELD("MOVDIRI32")          2, false, false, false, 37, 3, 25, 1,  0, 0}, // #1523
  {DBGFIELD("MOVDIRI64")          2, false, false, false, 37, 3, 82, 1,  0, 0}, // #1524
  {DBGFIELD("MOVLPDrm_MOVLPSrm_VMOVLPDrm_VMOVLPSrm") 2, false, false, false, 53, 7,  7, 1,  5, 1}, // #1525
  {DBGFIELD("SHUFPDrmi_SHUFPSrmi_VSHUFPDrmi_VSHUFPSrmi") 2, false, false, false, 53, 7,  7, 1,  5, 1}, // #1526
  {DBGFIELD("MOVNTDQmr")          2, false, false, false, 37, 3, 26, 1,  0, 0}, // #1527
  {DBGFIELD("MOVNTImr")           2, false, false, false, 37, 3, 27, 1,  0, 0}, // #1528
  {DBGFIELD("MOVSB")              7, false, false, false, 681, 5,  7, 1,  0, 0}, // #1529
  {DBGFIELD("MOVSDrr_MOVSDrr_REV_VMOVSDrr_VMOVSDrr_REV_VMOVSSrr_VMOVSSrr_REV") 1, false, false, false,  4, 3,  1, 1,  0, 0}, // #1530
  {DBGFIELD("MOVSX16rm16_MOVSX16rm32") 1, false, false, false, 28, 2,  3, 1,  0, 0}, // #1531
  {DBGFIELD("MOVSX32rm16_MOVSX32rm32_MOVSX64rm16_MOVSX64rm32_MOVSX32rm8_MOVSX64rm8") 1, false, false, false, 28, 2,  3, 1,  0, 0}, // #1532
  {DBGFIELD("MOVSX32rm8_NOREX")   1, false, false, false, 28, 2,  3, 1,  0, 0}, // #1533
  {DBGFIELD("MOVSX16rr16_MOVSX16rr32") 1, false, false, false, 115, 2,  1, 1,  0, 0}, // #1534
  {DBGFIELD("MOVSX16rr8")         1, false, false, false, 115, 2,  1, 1,  0, 0}, // #1535
  {DBGFIELD("MOVSX32rr16_MOVSX32rr8_MOVSX64rr16_MOVSX64rr8") 1, false, false, false, 115, 2,  1, 1,  0, 0}, // #1536
  {DBGFIELD("MOVSX32rr8_NOREX")   1, false, false, false, 115, 2,  1, 1,  0, 0}, // #1537
  {DBGFIELD("MUL_FPrST0_MUL_FrST0") 1, false, false, false,  2, 8, 14, 1,  0, 0}, // #1538
  {DBGFIELD("OUT16ir")            79, false, false, false, 1914, 16, 51, 1,  0, 0}, // #1539
  {DBGFIELD("OUT16rr")            79, false, false, false, 1930, 16, 51, 1,  0, 0}, // #1540
  {DBGFIELD("OUT32ir")            85, false, false, false, 1946, 16, 51, 1,  0, 0}, // #1541
  {DBGFIELD("OUT32rr")            85, false, false, false, 1962, 16, 51, 1,  0, 0}, // #1542
  {DBGFIELD("OUTSB")              80, false, false, false, 1978, 16,  4, 1,  0, 0}, // #1543
  {DBGFIELD("OUTSL")              89, false, false, false, 1994, 16,  4, 1,  0, 0}, // #1544
  {DBGFIELD("PACKSSDWrm_PACKSSWBrm_PACKUSDWrm_PACKUSWBrm_VPACKSSDWrm_VPACKSSWBrm_VPACKUSDWrm_VPACKUSWBrm") 2, false, false, false, 375, 10,  9, 1,  5, 1}, // #1545
  {DBGFIELD("PACKSSDWrr_PACKSSWBrr_PACKUSDWrr_PACKUSWBrr_VPACKSSDWrr_VPACKSSWBrr_VPACKUSDWrr_VPACKUSWBrr") 1, false, false, false, 60, 8,  5, 1,  0, 0}, // #1546
  {DBGFIELD("PALIGNRrmi_VPALIGNRrmi") 2, false, false, false, 375, 10,  7, 1,  5, 1}, // #1547
  {DBGFIELD("PALIGNRrri_VPALIGNRrri") 1, false, false, false, 60, 8,  1, 1,  0, 0}, // #1548
  {DBGFIELD("PREFETCHIT0_PREFETCHIT1") 1, false, false, false, 26, 4, 10, 1,  0, 0}, // #1549
  {DBGFIELD("PREFETCHT0_PREFETCHT1_PREFETCHT2") 1, false, false, false, 28, 2,  0, 1,  0, 0}, // #1550
  {DBGFIELD("PREFETCHNTA")        1, false, false, false, 28, 2,  0, 1,  0, 0}, // #1551
  {DBGFIELD("PTWRITE64m_PTWRITEm") 4, false, false, false, 2010, 7,  4, 1,  0, 0}, // #1552
  {DBGFIELD("PTWRITE64r")         3, false, false, false, 2017, 5,  4, 1,  0, 0}, // #1553
  {DBGFIELD("PTWRITEr")           4, false, false, false, 2022, 5,  4, 1,  0, 0}, // #1554
  {DBGFIELD("PUSH64r")            2, false, false, false, 37, 3,  1, 1,  0, 0}, // #1555
  {DBGFIELD("PUSH64rmr")          2, false, false, false, 37, 3,  1, 1,  0, 0}, // #1556
  {DBGFIELD("RCL8m1_RCR8m1")      6, false, false, false, 14, 8, 54, 2,  0, 0}, // #1557
  {DBGFIELD("RCL8mi")             6, false, false, false, 14, 8, 54, 2,  0, 0}, // #1558
  {DBGFIELD("RCR8mi")             6, false, false, false, 14, 8, 54, 2,  0, 0}, // #1559
  {DBGFIELD("RCL8mCL")            11, false, false, false, 2027, 13, 83, 2,  0, 0}, // #1560
  {DBGFIELD("RCR8mCL")            12, false, false, false, 2040, 13, 83, 2,  0, 0}, // #1561
  {DBGFIELD("RDPID64")            1, false, false, false, 30, 7,  4, 1,  0, 0}, // #1562
  {DBGFIELD("RDPKRUr")            3, false, false, false, 342, 9,  4, 1,  0, 0}, // #1563
  {DBGFIELD("RDRAND16r")          25, false, false, false, 1184, 14, 85, 1,  0, 0}, // #1564
  {DBGFIELD("RDSEED16r")          25, false, false, false, 2053, 14, 86, 1,  0, 0}, // #1565
  {DBGFIELD("RDSEED32r_RDSEED64r") 25, false, false, false, 2053, 14,  4, 1,  0, 0}, // #1566
  {DBGFIELD("REX64_PREFIX")       1, false, false, false,  0, 0,  1, 1,  0, 0}, // #1567
  {DBGFIELD("ROL16m1_ROL16mi_ROL32m1_ROL32mi_ROL64m1_ROL64mi_ROR16m1_ROR16mi_ROR32m1_ROR32mi_ROR64m1_ROR64mi") 5, false, false, false, 562, 8, 33, 2,  0, 0}, // #1568
  {DBGFIELD("ROL16mCL_ROL32mCL_ROL64mCL_ROR16mCL_ROR32mCL_ROR64mCL") 5, false, false, false, 562, 8, 33, 2,  0, 0}, // #1569
  {DBGFIELD("ROL16ri_ROL32ri_ROL64ri_ROL8ri_ROR16ri_ROR32ri_ROR64ri_ROR8ri") 2, false, false, false, 550, 4,  1, 1,  0, 0}, // #1570
  {DBGFIELD("SHL8mCL_SAR8mCL_SHR8mCL") 5, false, false, false, 562, 8, 54, 2,  0, 0}, // #1571
  {DBGFIELD("SAR8m1_SAR8mi_SHR8m1_SHR8mi_SHL8m1_SHL8mi") 4, false, false, false, 554, 8, 54, 2,  0, 0}, // #1572
  {DBGFIELD("SARX32rm_SARX64rm_SHRX32rm_SHRX64rm_SHLX32rm_SHLX64rm") 2, false, false, false, 163, 6,  7, 1,  3, 1}, // #1573
  {DBGFIELD("SARX32rr_SARX64rr_SHRX32rr_SHRX64rr_SHLX32rr_SHLX64rr") 1, false, false, false, 10, 4,  5, 1,  0, 0}, // #1574
  {DBGFIELD("SERIALIZE")          7, false, false, false, 2067, 12,  4, 1,  0, 0}, // #1575
  {DBGFIELD("SHRD16mri8")         5, false, false, false, 590, 11, 24, 1,  0, 0}, // #1576
  {DBGFIELD("SMSW16r")            2, false, false, false, 2079, 8,  1, 1,  0, 0}, // #1577
  {DBGFIELD("SMSW32r_SMSW64r")    2, false, false, false, 2079, 8,  4, 1,  0, 0}, // #1578
  {DBGFIELD("SQRTSDm_Int_VSQRTSDm_Int") 2, false, false, false, 173, 10, 37, 1,  5, 1}, // #1579
  {DBGFIELD("STI")                6, false, false, false, 2087, 9,  4, 1,  0, 0}, // #1580
  {DBGFIELD("STOSB")              4, false, false, false, 1042, 4,  7, 1,  0, 0}, // #1581
  {DBGFIELD("VBLENDVPDrm_VBLENDVPSrm") 4, false, false, false, 621, 5, 22, 1,  9, 2}, // #1582
  {DBGFIELD("VPBLENDVBrm")        4, false, false, false, 621, 5, 22, 1,  9, 2}, // #1583
  {DBGFIELD("VBLENDVPDrr_VBLENDVPSrr") 3, false, false, false, 223, 3,  5, 1,  0, 0}, // #1584
  {DBGFIELD("VPBLENDVBrr")        3, false, false, false, 223, 3,  5, 1,  0, 0}, // #1585
  {DBGFIELD("VERRm")              31, false, false, false, 2096, 13, 53, 1,  0, 0}, // #1586
  {DBGFIELD("VERRr")              30, false, false, false, 2109, 13, 87, 1,  0, 0}, // #1587
  {DBGFIELD("VERWr")              33, false, false, false, 2122, 13, 87, 1,  0, 0}, // #1588
  {DBGFIELD("VHADDPDrr_VHADDPSrr_VHSUBPDrr_VHSUBPSrr") 3, false, false, false, 314, 8, 10, 1,  0, 0}, // #1589
  {DBGFIELD("VLDMXCSR")           3, false, false, false, 2135, 10,  6, 1,  0, 0}, // #1590
  {DBGFIELD("VMOVMSKPDYrr_VMOVMSKPSYrr") 1, false, false, false,  2, 8, 10, 1,  0, 0}, // #1591
  {DBGFIELD("VMOVNTDQmr")         2, false, false, false, 37, 3, 88, 1,  0, 0}, // #1592
  {DBGFIELD("VMOVNTPDmr")         2, false, false, false, 37, 3, 89, 1,  0, 0}, // #1593
  {DBGFIELD("VMOVNTPSYmr")        2, false, false, false, 37, 3, 90, 1,  0, 0}, // #1594
  {DBGFIELD("VMOVNTPSmr")         2, false, false, false, 37, 3, 91, 1,  0, 0}, // #1595
  {DBGFIELD("VPACKSSDWYrm_VPACKSSWBYrm_VPACKUSDWYrm_VPACKUSWBYrm") 2, false, false, false, 375, 10,  8, 1,  5, 1}, // #1596
  {DBGFIELD("VPCLMULQDQYrm")      2, false, false, false, 375, 10,  8, 1,  5, 1}, // #1597
  {DBGFIELD("VSHUFPDYrmi_VSHUFPSYrmi") 2, false, false, false, 53, 7, 22, 1,  5, 1}, // #1598
  {DBGFIELD("VPBLENDWYrmi")       2, false, false, false, 53, 7, 22, 1,  5, 1}, // #1599
  {DBGFIELD("VPDPBUSDSYrm_VPDPBUSDrm_VPDPWSSDSYrm_VPDPWSSDrm_VPDPBUSDSrm_VPDPBUSDYrm_VPDPWSSDSrm_VPDPWSSDYrm") 2, false, false, false, 68, 6, 24, 1,  0, 0}, // #1600
  {DBGFIELD("WRPKRUr")            8, false, false, false, 2145, 11,  4, 1,  0, 0}, // #1601
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm") 5, false, false, false, 1095, 5, 33, 2,  0, 0}, // #1602
  {DBGFIELD("XCHG16rm")           8, false, false, false, 1534, 8, 45, 2,  0, 0}, // #1603
  {DBGFIELD("XCHG32rm")           8, false, false, false, 1534, 8, 45, 2,  0, 0}, // #1604
  {DBGFIELD("XRSTOR_XRSTOR64_XRSTORS") 31, false, false, false, 1301, 14, 58, 1,  0, 0}, // #1605
  {DBGFIELD("XSAVEC")             151, false, false, false, 2156, 16, 48, 1,  0, 0}, // #1606
  {DBGFIELD("XSAVEC64")           152, false, false, false, 2172, 16, 48, 1,  0, 0}, // #1607
  {DBGFIELD("XSAVEOPT")           155, false, false, false, 2188, 15, 62, 1,  0, 0}, // #1608
  {DBGFIELD("XSAVES")             184, false, false, false, 2203, 15, 48, 1,  0, 0}, // #1609
  {DBGFIELD("PdWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1610
  {DBGFIELD("WriteVecALU")        0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1611
  {DBGFIELD("JWriteZeroLatency")  0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1612
  {DBGFIELD("JWriteLOCK_CMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1613
  {DBGFIELD("JWriteLOCK_CMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1614
  {DBGFIELD("JWriteLOCK_CMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1615
  {DBGFIELD("JWriteLOCK_CMPXCHGrm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1616
  {DBGFIELD("JWriteCMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1617
  {DBGFIELD("JWriteCMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1618
  {DBGFIELD("JWriteCMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1619
  {DBGFIELD("WriteCMPXCHGRMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1620
  {DBGFIELD("JWriteCMPXCHG8rr_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1621
  {DBGFIELD("WriteCMPXCHG_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1622
  {DBGFIELD("JWriteLOCK_CMPXCHG8B") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1623
  {DBGFIELD("JWriteLOCK_CMPXCHG16B") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1624
  {DBGFIELD("JWriteLOCK_CMPXCHG8rm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1625
  {DBGFIELD("JWriteLOCK_CMPXCHGrm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1626
  {DBGFIELD("JWriteCMPXCHG8B")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1627
  {DBGFIELD("JWriteCMPXCHG16B")   0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1628
  {DBGFIELD("JWriteCMPXCHG8rm")   0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1629
  {DBGFIELD("WriteCMPXCHGRMW")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1630
  {DBGFIELD("JWriteCMPXCHG8rr")   0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1631
  {DBGFIELD("WriteCMPXCHG")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1632
  {DBGFIELD("JWriteLOCK_CMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1633
  {DBGFIELD("JWriteLOCK_CMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1634
  {DBGFIELD("JWriteLOCK_CMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1635
  {DBGFIELD("JWriteLOCK_CMPXCHGrm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1636
  {DBGFIELD("JWriteCMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1637
  {DBGFIELD("JWriteCMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1638
  {DBGFIELD("JWriteCMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1639
  {DBGFIELD("WriteCMPXCHGRMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1640
  {DBGFIELD("JWriteCMPXCHG8rr_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1641
  {DBGFIELD("WriteCMPXCHG_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1642
  {DBGFIELD("JWriteLOCK_XADDrm_XCHG_Part_JWriteXCHGrm_LdSt_Part_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1643
  {DBGFIELD("JWriteXADDrm_XCHG_Part_JWriteXADDrm_LdSt_Part_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1644
  {DBGFIELD("SBWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1645
  {DBGFIELD("WriteALU")           0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1646
  {DBGFIELD("HWWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1647
  {DBGFIELD("BWWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1648
  {DBGFIELD("Zn3WriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1649
  {DBGFIELD("Zn4WriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1650
  {DBGFIELD("SKLWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1651
  {DBGFIELD("SKXWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1652
  {DBGFIELD("ICXWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1653
  {DBGFIELD("WriteFLogic")        0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1654
  {DBGFIELD("WriteFLogicY")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1655
  {DBGFIELD("JWriteZeroIdiomYmm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1656
  {DBGFIELD("WriteVecLogicX")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1657
  {DBGFIELD("WriteVecALUX")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1658
  {DBGFIELD("SKLWritePSUB")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1659
  {DBGFIELD("SKXWritePSUB")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1660
  {DBGFIELD("ICXWritePSUB")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1661
  {DBGFIELD("SBWritePCMPGTQ")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1662
  {DBGFIELD("HWWritePCMPGTQ")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1663
  {DBGFIELD("BWWritePCMPGTQ")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1664
  {DBGFIELD("SKLWritePCMPGTQ")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1665
  {DBGFIELD("SKXWritePCMPGTQ")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1666
  {DBGFIELD("ICXWritePCMPGTQ")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1667
  {DBGFIELD("SBWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1668
  {DBGFIELD("WriteCMOV")          0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1669
  {DBGFIELD("HWWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1670
  {DBGFIELD("BWWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1671
  {DBGFIELD("SKLWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1672
  {DBGFIELD("SKXWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1673
  {DBGFIELD("ICXWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1674
  {DBGFIELD("SBWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1675
  {DBGFIELD("WriteCMOVLd")        0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1676
  {DBGFIELD("HWWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1677
  {DBGFIELD("BWWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1678
  {DBGFIELD("PdWriteCMOVm")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1679
  {DBGFIELD("SKLWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1680
  {DBGFIELD("SKXWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1681
  {DBGFIELD("ICXWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1682
  {DBGFIELD("SBWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1683
  {DBGFIELD("WriteSETCC")         0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1684
  {DBGFIELD("HWWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1685
  {DBGFIELD("BWWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1686
  {DBGFIELD("SKLWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1687
  {DBGFIELD("SKXWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1688
  {DBGFIELD("ICXWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1689
  {DBGFIELD("SBWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1690
  {DBGFIELD("WriteSETCCStore")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1691
  {DBGFIELD("HWWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1692
  {DBGFIELD("BWWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1693
  {DBGFIELD("PdWriteSETGEmSETGmSETLEmSETLm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1694
  {DBGFIELD("SKLWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1695
  {DBGFIELD("SKXWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1696
  {DBGFIELD("ICXWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1697
  {DBGFIELD("WriteVecLogicY")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1698
  {DBGFIELD("WriteVecALUY")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1699
  {DBGFIELD("HWWriteADC0")        0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1700
  {DBGFIELD("WriteADC")           0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1701
  {DBGFIELD("JWriteLOCK_ALURMW")  0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1702
  {DBGFIELD("WriteALURMW")        0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1703
  {DBGFIELD("WriteFShuffle256")   0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1704
  {DBGFIELD("Zn3Write3OpsLEA")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1705
  {DBGFIELD("WriteLEA")           0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1706
  {DBGFIELD("Zn4Write3OpsLEA")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1707
  {DBGFIELD("PdWrite3OpsLEA")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1708
  {DBGFIELD("JWrite3OpsLEA")      0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1709
  {DBGFIELD("WriteVecLogic")      0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1710
  {DBGFIELD("WriteFLogicZ")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1711
  {DBGFIELD("WriteVecLogicZ")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1712
}; // AlderlakePModelSchedClasses

// {Name, NumMicroOps, BeginGroup, EndGroup, RetireOOO, WriteProcResIdx,#, WriteLatencyIdx,#, ReadAdvanceIdx,#}
static const llvm::MCSchedClassDesc AtomModelSchedClasses[] = {
  {DBGFIELD("InvalidSchedClass")  8191, false, false, false, 0, 0,  0, 0,  0, 0},
  {DBGFIELD("WriteALU")           1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1
  {DBGFIELD("WriteZero")          1, false, false, false,  0, 0,  1, 1,  0, 0}, // #2
  {DBGFIELD("WriteVecALU")        1, false, false, false,  4, 1,  1, 1,  0, 0}, // #3
  {DBGFIELD("WriteJump")          1, false, false, false,  3, 2,  1, 1,  0, 0}, // #4
  {DBGFIELD("WriteCMPXCHGRMW")    1, false, false, false, 2218, 2,  1, 1,  0, 0}, // #5
  {DBGFIELD("WriteJumpLd")        1, false, false, false,  3, 2,  1, 1,  0, 0}, // #6
  {DBGFIELD("WriteMove")          1, false, false, false,  4, 1,  1, 1,  0, 0}, // #7
  {DBGFIELD("WriteSystem")        1, false, false, false,  4, 1,  4, 1,  0, 0}, // #8
  {DBGFIELD("WriteADC")           1, false, false, false,  4, 1,  1, 1,  0, 0}, // #9
  {DBGFIELD("WriteSHDrri")        1, false, false, false, 75, 1, 12, 1,  0, 0}, // #10
  {DBGFIELD("WriteFStoreX")       1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #11
  {DBGFIELD("WriteFLoadX")        1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #12
  {DBGFIELD("WriteFStoreY")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #13
  {DBGFIELD("WriteFLoadY")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #14
  {DBGFIELD("WriteMicrocoded")    1, false, false, false,  4, 1,  4, 1,  0, 0}, // #15
  {DBGFIELD("WriteALURMW")        1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #16
  {DBGFIELD("WriteFSign")         1, false, false, false,  3, 2,  1, 1,  0, 0}, // #17
  {DBGFIELD("WriteADCRMW")        1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #18
  {DBGFIELD("WriteADCRMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, false, 2220, 2,  1, 1, 13, 2}, // #19
  {DBGFIELD("WriteADCLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, false, 2220, 2,  1, 1, 15, 2}, // #20
  {DBGFIELD("WriteALURMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, false, 2220, 2,  1, 1, 13, 1}, // #21
  {DBGFIELD("WriteALULd_ReadAfterLd") 1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #22
  {DBGFIELD("WriteFAdd64XLd_ReadAfterVecXLd") 4, false, false, false, 2222, 3,  6, 1, 15, 1}, // #23
  {DBGFIELD("WriteFAdd64X")       3, false, false, false, 2225, 3,  3, 1,  0, 0}, // #24
  {DBGFIELD("WriteFAddXLd_ReadAfterVecXLd") 1, false, false, false, 269, 3, 10, 1, 15, 1}, // #25
  {DBGFIELD("WriteFAddX")         1, false, false, false,  3, 2, 10, 1,  0, 0}, // #26
  {DBGFIELD("WriteNop")           1, false, false, false,  4, 1,  1, 1,  0, 0}, // #27
  {DBGFIELD("WriteFAdd64Ld_ReadAfterVecLd") 1, false, false, false, 269, 3, 10, 1, 15, 1}, // #28
  {DBGFIELD("WriteFAdd64")        1, false, false, false,  3, 2, 10, 1,  0, 0}, // #29
  {DBGFIELD("WriteFAddLd_ReadAfterVecLd") 1, false, false, false, 269, 3, 10, 1, 15, 1}, // #30
  {DBGFIELD("WriteFAdd")          1, false, false, false,  3, 2, 10, 1,  0, 0}, // #31
  {DBGFIELD("WriteFAddLd")        1, false, false, false, 269, 3, 10, 1,  0, 0}, // #32
  {DBGFIELD("WriteAESDecEncLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #33
  {DBGFIELD("WriteAESDecEnc")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #34
  {DBGFIELD("WriteAESIMCLd")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #35
  {DBGFIELD("WriteAESIMC")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #36
  {DBGFIELD("WriteAESKeyGenLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #37
  {DBGFIELD("WriteAESKeyGen")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #38
  {DBGFIELD("WriteFLogicLd_ReadAfterVecXLd") 1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #39
  {DBGFIELD("WriteFLogic")        1, false, false, false,  4, 1,  1, 1,  0, 0}, // #40
  {DBGFIELD("WriteBEXTRLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #41
  {DBGFIELD("WriteBEXTR")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #42
  {DBGFIELD("WriteBEXTRLd")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #43
  {DBGFIELD("WriteALULd")         1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #44
  {DBGFIELD("WriteFBlendLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #45
  {DBGFIELD("WriteFBlend")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #46
  {DBGFIELD("WriteFVarBlendLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #47
  {DBGFIELD("WriteFVarBlend")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #48
  {DBGFIELD("WriteBLSLd")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #49
  {DBGFIELD("WriteBLS")           8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #50
  {DBGFIELD("WriteBSFLd")         10, false, false, false, 2228, 3, 16, 1,  0, 0}, // #51
  {DBGFIELD("WriteBSF")           10, false, false, false, 2228, 3, 16, 1,  0, 0}, // #52
  {DBGFIELD("WriteBSRLd")         10, false, false, false, 2228, 3, 16, 1,  0, 0}, // #53
  {DBGFIELD("WriteBSR")           10, false, false, false, 2228, 3, 16, 1,  0, 0}, // #54
  {DBGFIELD("WriteBSWAP32")       1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #55
  {DBGFIELD("WriteBSWAP64")       1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #56
  {DBGFIELD("WriteBitTestImmLd")  1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #57
  {DBGFIELD("WriteBitTestRegLd")  1, false, false, false, 293, 1, 22, 1,  0, 0}, // #58
  {DBGFIELD("WriteBitTest")       1, false, false, false,  3, 2,  1, 1,  0, 0}, // #59
  {DBGFIELD("WriteBitTestSetImmRMW") 1, false, false, false, 75, 1, 12, 1,  0, 0}, // #60
  {DBGFIELD("WriteBitTestSetRegRMW") 1, false, false, false, 82, 1,  8, 1,  0, 0}, // #61
  {DBGFIELD("WriteBitTestSet")    1, false, false, false,  3, 2,  1, 1,  0, 0}, // #62
  {DBGFIELD("WriteBZHILd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #63
  {DBGFIELD("WriteBZHI")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #64
  {DBGFIELD("WriteLoad")          1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #65
  {DBGFIELD("WriteCMOVLd_ReadAfterLd") 1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #66
  {DBGFIELD("WriteCMOV")          1, false, false, false,  4, 1,  1, 1,  0, 0}, // #67
  {DBGFIELD("WriteFCMOV")         1, false, false, false, 293, 1, 22, 1,  0, 0}, // #68
  {DBGFIELD("WriteALULd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, false, 2220, 2,  1, 1, 13, 1}, // #69
  {DBGFIELD("WriteXCHG")          1, false, false, false, 75, 1, 12, 1,  0, 0}, // #70
  {DBGFIELD("WriteFCmp64XLd_ReadAfterVecXLd") 4, false, false, false, 2222, 3,  6, 1, 15, 1}, // #71
  {DBGFIELD("WriteFCmp64X")       3, false, false, false, 2225, 3,  3, 1,  0, 0}, // #72
  {DBGFIELD("WriteFCmpXLd_ReadAfterVecXLd") 4, false, false, false, 2222, 3,  6, 1, 15, 1}, // #73
  {DBGFIELD("WriteFCmpX")         3, false, false, false, 2225, 3,  3, 1,  0, 0}, // #74
  {DBGFIELD("WriteFCmp64Ld_ReadAfterVecLd") 1, false, false, false, 269, 3, 10, 1, 15, 1}, // #75
  {DBGFIELD("WriteFCmp64")        1, false, false, false,  3, 2, 10, 1,  0, 0}, // #76
  {DBGFIELD("WriteFCmpLd_ReadAfterVecLd") 1, false, false, false, 269, 3, 10, 1, 15, 1}, // #77
  {DBGFIELD("WriteFCmp")          1, false, false, false,  3, 2, 10, 1,  0, 0}, // #78
  {DBGFIELD("WriteCMPXCHG")       1, false, false, false, 2231, 1, 11, 1,  0, 0}, // #79
  {DBGFIELD("WriteFComXLd_ReadAfterVecLd") 5, false, false, false, 2232, 3,  9, 1, 15, 1}, // #80
  {DBGFIELD("WriteFComX")         4, false, false, false, 2235, 3, 22, 1,  0, 0}, // #81
  {DBGFIELD("WriteFCom")          1, false, false, false, 2238, 2, 10, 1,  0, 0}, // #82
  {DBGFIELD("WriteCRC32Ld_ReadAfterLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #83
  {DBGFIELD("WriteCRC32")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #84
  {DBGFIELD("WriteCvtI2PDLd")     4, false, false, false, 2240, 3,  7, 1,  0, 0}, // #85
  {DBGFIELD("WriteCvtI2PD")       3, false, false, false, 2222, 3,  6, 1,  0, 0}, // #86
  {DBGFIELD("WriteCvtI2PSLd")     4, false, false, false, 2240, 3,  6, 1,  0, 0}, // #87
  {DBGFIELD("WriteCvtI2PS")       3, false, false, false, 2222, 3,  3, 1,  0, 0}, // #88
  {DBGFIELD("WriteCvtPD2ILd")     5, false, false, false, 2243, 3,  7, 1,  0, 0}, // #89
  {DBGFIELD("WriteCvtPD2I")       4, false, false, false, 2240, 3,  6, 1,  0, 0}, // #90
  {DBGFIELD("WriteCvtPD2PSLd")    5, false, false, false, 2246, 3,  2, 1,  0, 0}, // #91
  {DBGFIELD("WriteCvtPD2PS")      4, false, false, false, 2249, 3,  8, 1,  0, 0}, // #92
  {DBGFIELD("WriteCvtPS2ILd")     4, false, false, false, 2240, 3,  6, 1,  0, 0}, // #93
  {DBGFIELD("WriteCvtPS2I")       3, false, false, false, 2222, 3,  3, 1,  0, 0}, // #94
  {DBGFIELD("WriteCvtPS2PDLd")    5, false, false, false, 2240, 3,  7, 1,  0, 0}, // #95
  {DBGFIELD("WriteCvtPS2PD")      4, false, false, false, 2222, 3,  6, 1,  0, 0}, // #96
  {DBGFIELD("WriteCvtSD2ILd")     4, false, false, false, 2232, 3, 22, 1,  0, 0}, // #97
  {DBGFIELD("WriteCvtSD2I_ReadDefault") 3, false, false, false, 2243, 3,  7, 1,  0, 0}, // #98
  {DBGFIELD("WriteCvtSD2I")       3, false, false, false, 2243, 3,  7, 1,  0, 0}, // #99
  {DBGFIELD("WriteCvtSD2SSLd_ReadAfterVecLd") 4, false, false, false, 2246, 3,  8, 1, 15, 1}, // #100
  {DBGFIELD("WriteCvtSD2SS")      3, false, false, false, 2232, 3,  9, 1,  0, 0}, // #101
  {DBGFIELD("WriteCvtI2SDLd")     3, false, false, false, 2240, 3,  6, 1,  0, 0}, // #102
  {DBGFIELD("WriteCvtI2SDLd_ReadAfterVecLd") 3, false, false, false, 2240, 3,  6, 1, 15, 1}, // #103
  {DBGFIELD("WriteCvtI2SD_ReadInt2Fpu") 3, false, false, false, 2222, 3,  3, 1,  0, 1}, // #104
  {DBGFIELD("WriteCvtI2SD_ReadDefault_ReadInt2Fpu") 3, false, false, false, 2222, 3,  3, 1,  6, 1}, // #105
  {DBGFIELD("WriteCvtI2SSLd")     1, false, false, false, 2222, 3,  6, 1,  0, 0}, // #106
  {DBGFIELD("WriteCvtI2SSLd_ReadAfterVecLd") 1, false, false, false, 2222, 3,  6, 1, 15, 1}, // #107
  {DBGFIELD("WriteCvtI2SS_ReadInt2Fpu") 3, false, false, false, 2222, 3,  3, 1,  0, 1}, // #108
  {DBGFIELD("WriteCvtI2SS_ReadDefault_ReadInt2Fpu") 3, false, false, false, 2222, 3,  3, 1,  6, 1}, // #109
  {DBGFIELD("WriteCvtSS2SDLd_ReadAfterVecLd") 4, false, false, false, 2240, 3,  6, 1, 15, 1}, // #110
  {DBGFIELD("WriteCvtSS2SD")      3, false, false, false, 2222, 3,  3, 1,  0, 0}, // #111
  {DBGFIELD("WriteCvtSS2ILd")     4, false, false, false, 2235, 3, 22, 1,  0, 0}, // #112
  {DBGFIELD("WriteCvtSS2I_ReadDefault") 3, false, false, false, 2243, 3,  7, 1,  0, 0}, // #113
  {DBGFIELD("WriteCvtSS2I")       3, false, false, false, 2243, 3,  7, 1,  0, 0}, // #114
  {DBGFIELD("WriteDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 12, false, false, false, 2252, 3, 92, 1, 13, 2}, // #115
  {DBGFIELD("WriteDiv16")         12, false, false, false, 2252, 3, 92, 1,  0, 0}, // #116
  {DBGFIELD("WriteDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 12, false, false, false, 2252, 3, 92, 1, 13, 2}, // #117
  {DBGFIELD("WriteDiv32")         12, false, false, false, 2252, 3, 92, 1,  0, 0}, // #118
  {DBGFIELD("WriteDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 38, false, false, false, 2255, 3, 93, 1, 13, 2}, // #119
  {DBGFIELD("WriteDiv64")         38, false, false, false, 2255, 3, 93, 1,  0, 0}, // #120
  {DBGFIELD("WriteDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 9, false, false, false, 2258, 3, 94, 1, 13, 2}, // #121
  {DBGFIELD("WriteDiv8")          9, false, false, false, 2252, 3, 92, 1,  0, 0}, // #122
  {DBGFIELD("WriteFDiv64XLd_ReadAfterVecXLd") 7, false, false, false, 2261, 3, 95, 1, 15, 1}, // #123
  {DBGFIELD("WriteFDiv64X")       6, false, false, false, 2261, 3, 95, 1,  0, 0}, // #124
  {DBGFIELD("WriteFDivXLd_ReadAfterVecXLd") 7, false, false, false, 2264, 3, 57, 1, 15, 1}, // #125
  {DBGFIELD("WriteFDivX")         6, false, false, false, 2264, 3, 57, 1,  0, 0}, // #126
  {DBGFIELD("WriteFDivLd")        4, false, false, false, 2267, 3, 96, 1,  0, 0}, // #127
  {DBGFIELD("WriteFDiv")          3, false, false, false, 2267, 3, 96, 1,  0, 0}, // #128
  {DBGFIELD("WriteFDiv64Ld_ReadAfterVecLd") 4, false, false, false, 2270, 3, 64, 1, 15, 1}, // #129
  {DBGFIELD("WriteFDiv64")        3, false, false, false, 2270, 3, 64, 1,  0, 0}, // #130
  {DBGFIELD("WriteFDivLd_ReadAfterVecLd") 4, false, false, false, 2267, 3, 96, 1, 15, 1}, // #131
  {DBGFIELD("WriteDPPDLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #132
  {DBGFIELD("WriteDPPD")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #133
  {DBGFIELD("WriteDPPSLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #134
  {DBGFIELD("WriteDPPS")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #135
  {DBGFIELD("WriteStore")         1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #136
  {DBGFIELD("WriteVecExtractSt")  1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #137
  {DBGFIELD("WriteVecExtract")    1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #138
  {DBGFIELD("WriteVecALUX")       1, false, false, false,  4, 1,  1, 1,  0, 0}, // #139
  {DBGFIELD("WriteFComLd")        1, false, false, false, 2238, 2, 10, 1,  0, 0}, // #140
  {DBGFIELD("WriteEMMS")          1, false, false, false, 240, 1, 10, 1,  0, 0}, // #141
  {DBGFIELD("WriteFLDC")          1, false, false, false, 1904, 1,  9, 1,  0, 0}, // #142
  {DBGFIELD("WriteVecIMulXLd_ReadAfterVecXLd") 1, false, false, false, 2273, 2, 10, 1, 15, 1}, // #143
  {DBGFIELD("WriteVecIMulX")      1, false, false, false, 2273, 2, 10, 1,  0, 0}, // #144
  {DBGFIELD("WriteVecALUXLd_ReadAfterVecXLd") 1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #145
  {DBGFIELD("WriteFHAddLd_ReadAfterVecXLd") 6, false, false, false, 2235, 3, 22, 1, 15, 1}, // #146
  {DBGFIELD("WriteFHAdd")         5, false, false, false, 2243, 3,  7, 1,  0, 0}, // #147
  {DBGFIELD("WriteIDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 29, false, false, false, 2270, 3, 64, 1, 13, 2}, // #148
  {DBGFIELD("WriteIDiv16")        29, false, false, false, 2270, 3, 64, 1,  0, 0}, // #149
  {DBGFIELD("WriteIDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 29, false, false, false, 2270, 3, 64, 1, 13, 2}, // #150
  {DBGFIELD("WriteIDiv32")        29, false, false, false, 2270, 3, 64, 1,  0, 0}, // #151
  {DBGFIELD("WriteIDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 60, false, false, false, 2255, 3, 93, 1, 13, 2}, // #152
  {DBGFIELD("WriteIDiv64")        60, false, false, false, 2255, 3, 93, 1,  0, 0}, // #153
  {DBGFIELD("WriteIDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 26, false, false, false, 2270, 3, 64, 1, 13, 2}, // #154
  {DBGFIELD("WriteIDiv8")         26, false, false, false, 2270, 3, 64, 1,  0, 0}, // #155
  {DBGFIELD("WriteIMul16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 5, false, false, false, 2243, 3,  7, 1, 13, 2}, // #156
  {DBGFIELD("WriteIMul16")        4, false, false, false, 2240, 3,  6, 1,  0, 0}, // #157
  {DBGFIELD("WriteIMul16RegLd_ReadAfterLd") 3, false, false, false, 2240, 3,  6, 1, 15, 1}, // #158
  {DBGFIELD("WriteIMul16ImmLd")   3, false, false, false, 2240, 3,  6, 1,  0, 0}, // #159
  {DBGFIELD("WriteIMul16Reg")     2, false, false, false, 2222, 3,  3, 1,  0, 0}, // #160
  {DBGFIELD("WriteIMul16Imm")     2, false, false, false, 2222, 3,  3, 1,  0, 0}, // #161
  {DBGFIELD("WriteIMul32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 4, false, false, false, 2240, 3,  6, 1, 13, 2}, // #162
  {DBGFIELD("WriteIMul32")        3, false, false, false, 2222, 3,  3, 1,  0, 0}, // #163
  {DBGFIELD("WriteIMul32RegLd_ReadAfterLd") 1, false, false, false, 2238, 2, 10, 1, 15, 1}, // #164
  {DBGFIELD("WriteIMul32ImmLd")   1, false, false, false, 2238, 2, 10, 1,  0, 0}, // #165
  {DBGFIELD("WriteIMul32Reg")     1, false, false, false, 2238, 2, 10, 1,  0, 0}, // #166
  {DBGFIELD("WriteIMul32Imm")     1, false, false, false, 2238, 2, 10, 1,  0, 0}, // #167
  {DBGFIELD("WriteIMul64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 8, false, false, false, 2246, 3,  2, 1, 13, 2}, // #168
  {DBGFIELD("WriteIMul64")        8, false, false, false, 2246, 3,  2, 1,  0, 0}, // #169
  {DBGFIELD("WriteIMul64RegLd_ReadAfterLd") 6, false, false, false, 2246, 3,  2, 1, 15, 1}, // #170
  {DBGFIELD("WriteIMul64ImmLd")   7, false, false, false, 2275, 3, 21, 1,  0, 0}, // #171
  {DBGFIELD("WriteIMul64Reg")     6, false, false, false, 2246, 3,  2, 1,  0, 0}, // #172
  {DBGFIELD("WriteIMul64Imm")     7, false, false, false, 2275, 3, 21, 1,  0, 0}, // #173
  {DBGFIELD("WriteIMul8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 3, false, false, false, 2240, 3,  6, 1, 13, 2}, // #174
  {DBGFIELD("WriteIMul8")         3, false, false, false, 2240, 3,  6, 1,  0, 0}, // #175
  {DBGFIELD("WriteFShuffleLd_ReadAfterVecXLd") 1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #176
  {DBGFIELD("WriteFShuffle")      1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #177
  {DBGFIELD("WriteVecLogicX")     1, false, false, false,  4, 1,  1, 1,  0, 0}, // #178
  {DBGFIELD("WriteShuffle")       1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #179
  {DBGFIELD("WriteLAHFSAHF")      1, false, false, false, 75, 1, 12, 1,  0, 0}, // #180
  {DBGFIELD("WriteVecLoadX")      1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #181
  {DBGFIELD("WriteLDMXCSR")       4, false, false, false, 2225, 3, 10, 1,  0, 0}, // #182
  {DBGFIELD("WriteFLD0")          1, false, false, false,  4, 1,  1, 1,  0, 0}, // #183
  {DBGFIELD("WriteFLD1")          1, false, false, false, 464, 1,  3, 1,  0, 0}, // #184
  {DBGFIELD("WriteLEA")           1, false, false, false,  3, 2,  1, 1,  0, 0}, // #185
  {DBGFIELD("WriteFence")         1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #186
  {DBGFIELD("WriteLZCNTLd")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #187
  {DBGFIELD("WriteLZCNT")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #188
  {DBGFIELD("WriteVecStoreX")     1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #189
  {DBGFIELD("WriteVecStore")      1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #190
  {DBGFIELD("WriteVecMoveToGpr")  1, false, false, false, 2278, 2,  5, 1,  0, 0}, // #191
  {DBGFIELD("WriteVecLoad")       1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #192
  {DBGFIELD("WriteVecMoveFromGpr") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #193
  {DBGFIELD("WriteVecMoveX")      1, false, false, false,  4, 1,  1, 1,  0, 0}, // #194
  {DBGFIELD("WriteVecStoreNT")    1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #195
  {DBGFIELD("WriteVecMove")       1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #196
  {DBGFIELD("WriteVecALULd")      1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #197
  {DBGFIELD("WriteShuffleLd_ReadAfterVecLd") 1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #198
  {DBGFIELD("WriteVecALULd_ReadAfterVecLd") 1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #199
  {DBGFIELD("WriteVecLogicLd_ReadAfterVecLd") 1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #200
  {DBGFIELD("WriteVecLogic")      1, false, false, false,  4, 1,  1, 1,  0, 0}, // #201
  {DBGFIELD("WritePHAddLd_ReadAfterVecLd") 4, false, false, false, 2280, 3, 14, 1, 15, 1}, // #202
  {DBGFIELD("WritePHAdd")         3, false, false, false, 2283, 3,  5, 1,  0, 0}, // #203
  {DBGFIELD("WriteVecInsertLd_ReadAfterLd") 1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #204
  {DBGFIELD("WriteVecInsert_ReadDefault_ReadInt2Fpu") 1, false, false, false, 2220, 2,  1, 1,  6, 1}, // #205
  {DBGFIELD("WriteVecIMulLd_ReadAfterVecLd") 1, false, false, false, 2220, 2, 14, 1, 15, 1}, // #206
  {DBGFIELD("WriteVecIMul")       1, false, false, false, 2220, 2, 14, 1,  0, 0}, // #207
  {DBGFIELD("WriteMMXMOVMSK")     1, false, false, false, 2278, 2,  5, 1,  0, 0}, // #208
  {DBGFIELD("WritePSADBWLd_ReadAfterVecLd") 1, false, false, false, 2220, 2, 14, 1, 15, 1}, // #209
  {DBGFIELD("WritePSADBW")        1, false, false, false, 2220, 2, 14, 1,  0, 0}, // #210
  {DBGFIELD("WriteVarShuffleLd_ReadAfterVecLd") 1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #211
  {DBGFIELD("WriteVarShuffle")    1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #212
  {DBGFIELD("WriteShuffleLd")     1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #213
  {DBGFIELD("WriteVecShiftImm")   1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #214
  {DBGFIELD("WriteVecShiftLd_ReadAfterVecLd") 3, false, false, false, 2286, 3,  5, 1, 15, 1}, // #215
  {DBGFIELD("WriteVecShift")      2, false, false, false, 269, 3, 12, 1,  0, 0}, // #216
  {DBGFIELD("WriteFMoveX")        1, false, false, false,  4, 1,  1, 1,  0, 0}, // #217
  {DBGFIELD("WriteFShuffleLd")    1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #218
  {DBGFIELD("WriteFStore")        1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #219
  {DBGFIELD("WriteFMOVMSK")       1, false, false, false, 2278, 2,  5, 1,  0, 0}, // #220
  {DBGFIELD("WriteVecLoadNT")     1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #221
  {DBGFIELD("WriteStoreNT")       1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #222
  {DBGFIELD("WriteFStoreNTX")     1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #223
  {DBGFIELD("WriteFStoreNT")      1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #224
  {DBGFIELD("WriteFLoad")         1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #225
  {DBGFIELD("WriteMPSADLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #226
  {DBGFIELD("WriteMPSAD")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #227
  {DBGFIELD("WriteFMul64XLd_ReadAfterVecXLd") 7, false, false, false, 2232, 3,  9, 1, 15, 1}, // #228
  {DBGFIELD("WriteFMul64X")       6, false, false, false, 2235, 3, 22, 1,  0, 0}, // #229
  {DBGFIELD("WriteFMulXLd_ReadAfterVecXLd") 1, false, false, false, 2273, 2, 10, 1, 15, 1}, // #230
  {DBGFIELD("WriteFMulX")         1, false, false, false, 2273, 2, 10, 1,  0, 0}, // #231
  {DBGFIELD("WriteFMul64Ld_ReadAfterVecLd") 1, false, false, false, 2273, 2, 10, 1, 15, 1}, // #232
  {DBGFIELD("WriteFMul64")        1, false, false, false, 2273, 2, 10, 1,  0, 0}, // #233
  {DBGFIELD("WriteFMulLd_ReadAfterVecLd") 1, false, false, false, 2273, 2, 14, 1, 15, 1}, // #234
  {DBGFIELD("WriteFMul")          1, false, false, false, 2273, 2, 14, 1,  0, 0}, // #235
  {DBGFIELD("WriteMULX32Ld")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #236
  {DBGFIELD("WriteMULX32")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #237
  {DBGFIELD("WriteIMulHLd_WriteMULX32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #238
  {DBGFIELD("WriteIMulH_WriteMULX32") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #239
  {DBGFIELD("WriteMULX64Ld")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #240
  {DBGFIELD("WriteMULX64")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #241
  {DBGFIELD("WriteIMulHLd_WriteMULX64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #242
  {DBGFIELD("WriteIMulH_WriteMULX64") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #243
  {DBGFIELD("WriteFMulLd")        1, false, false, false, 2273, 2, 14, 1,  0, 0}, // #244
  {DBGFIELD("WriteVecALUXLd")     1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #245
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd") 1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #246
  {DBGFIELD("WriteShuffleX")      1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #247
  {DBGFIELD("WriteVecLogicXLd_ReadAfterVecXLd") 1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #248
  {DBGFIELD("WriteVarBlendLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #249
  {DBGFIELD("WriteVarBlend")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #250
  {DBGFIELD("WriteBlendLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #251
  {DBGFIELD("WriteBlend")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #252
  {DBGFIELD("WriteCLMulLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #253
  {DBGFIELD("WriteCLMul")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #254
  {DBGFIELD("WritePCmpEStrILd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #255
  {DBGFIELD("WritePCmpEStrI")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #256
  {DBGFIELD("WritePCmpEStrMLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #257
  {DBGFIELD("WritePCmpEStrM")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #258
  {DBGFIELD("WritePCmpIStrILd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #259
  {DBGFIELD("WritePCmpIStrI")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #260
  {DBGFIELD("WritePCmpIStrMLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #261
  {DBGFIELD("WritePCmpIStrM")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #262
  {DBGFIELD("WriteCvtPS2ILd_ReadAfterVecXLd") 4, false, false, false, 2240, 3,  6, 1, 15, 1}, // #263
  {DBGFIELD("WritePHAddXLd_ReadAfterVecXLd") 4, false, false, false, 2243, 3,  7, 1, 15, 1}, // #264
  {DBGFIELD("WritePHAddX")        3, false, false, false, 2240, 3,  6, 1,  0, 0}, // #265
  {DBGFIELD("WritePHMINPOSLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #266
  {DBGFIELD("WritePHMINPOS")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #267
  {DBGFIELD("WriteCvtI2PSLd_ReadAfterVecXLd") 4, false, false, false, 2240, 3,  6, 1, 15, 1}, // #268
  {DBGFIELD("WriteVecMOVMSK")     1, false, false, false, 2278, 2,  5, 1,  0, 0}, // #269
  {DBGFIELD("WriteShuffleXLd")    1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #270
  {DBGFIELD("WritePMULLDLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #271
  {DBGFIELD("WritePMULLD")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #272
  {DBGFIELD("WriteCopy")          2, false, false, false, 2273, 2, 12, 1,  0, 0}, // #273
  {DBGFIELD("WritePOPCNTLd")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #274
  {DBGFIELD("WritePOPCNT")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #275
  {DBGFIELD("WritePSADBWXLd_ReadAfterVecXLd") 1, false, false, false, 2273, 2, 10, 1, 15, 1}, // #276
  {DBGFIELD("WritePSADBWX")       1, false, false, false, 2273, 2, 10, 1,  0, 0}, // #277
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd") 5, false, false, false, 2280, 3, 10, 1, 15, 1}, // #278
  {DBGFIELD("WriteVarShuffleX")   4, false, false, false, 2283, 3, 14, 1,  0, 0}, // #279
  {DBGFIELD("WriteVecShiftImmX")  1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #280
  {DBGFIELD("WriteVecShiftXLd_ReadAfterVecXLd") 3, false, false, false, 2286, 3,  5, 1, 15, 1}, // #281
  {DBGFIELD("WriteVecShiftX")     2, false, false, false, 269, 3, 12, 1,  0, 0}, // #282
  {DBGFIELD("WriteVecTestLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #283
  {DBGFIELD("WriteVecTest")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #284
  {DBGFIELD("WriteRotateLd_WriteRMW") 2, false, false, false, 2273, 2, 97, 2,  0, 0}, // #285
  {DBGFIELD("WriteRotateCLLd_WriteRMW") 2, false, false, false, 2273, 2, 97, 2,  0, 0}, // #286
  {DBGFIELD("WriteRotate")        1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #287
  {DBGFIELD("WriteRotateCL")      1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #288
  {DBGFIELD("WriteFRcpXLd")       6, false, false, false, 2232, 3,  9, 1,  0, 0}, // #289
  {DBGFIELD("WriteFRcpX")         5, false, false, false, 2235, 3, 22, 1,  0, 0}, // #290
  {DBGFIELD("WriteFRcpLd")        1, false, false, false, 2289, 2, 14, 1,  0, 0}, // #291
  {DBGFIELD("WriteFRcpLd_ReadAfterVecLd") 1, false, false, false, 2289, 2, 14, 1, 15, 1}, // #292
  {DBGFIELD("WriteFRcp")          1, false, false, false, 2289, 2, 14, 1,  0, 0}, // #293
  {DBGFIELD("WriteRMW")           1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #294
  {DBGFIELD("WriteShiftLd")       1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #295
  {DBGFIELD("WriteShift")         1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #296
  {DBGFIELD("WriteFRndLd")        1, false, false, false, 2238, 2, 10, 1,  0, 0}, // #297
  {DBGFIELD("WriteFRnd")          1, false, false, false, 2238, 2, 10, 1,  0, 0}, // #298
  {DBGFIELD("WriteFRndLd_ReadAfterVecXLd") 1, false, false, false, 2238, 2, 10, 1, 15, 1}, // #299
  {DBGFIELD("WriteFRsqrtXLd")     6, false, false, false, 2232, 3,  9, 1,  0, 0}, // #300
  {DBGFIELD("WriteFRsqrtX")       5, false, false, false, 2235, 3, 22, 1,  0, 0}, // #301
  {DBGFIELD("WriteFRsqrtLd")      1, false, false, false, 2289, 2, 14, 1,  0, 0}, // #302
  {DBGFIELD("WriteFRsqrtLd_ReadAfterVecLd") 1, false, false, false, 2289, 2, 14, 1, 15, 1}, // #303
  {DBGFIELD("WriteFRsqrt")        1, false, false, false, 2289, 2, 14, 1,  0, 0}, // #304
  {DBGFIELD("WriteShiftLd_WriteRMW") 2, false, false, false, 2273, 2, 97, 2,  0, 0}, // #305
  {DBGFIELD("WriteShiftCLLd_WriteRMW") 2, false, false, false, 2273, 2, 97, 2,  0, 0}, // #306
  {DBGFIELD("WriteShiftCL")       1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #307
  {DBGFIELD("WriteShiftLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, false, 2220, 2,  1, 1, 13, 1}, // #308
  {DBGFIELD("WriteSETCCStore")    1, false, false, false, 75, 1, 12, 1,  0, 0}, // #309
  {DBGFIELD("WriteSETCC")         1, false, false, false,  4, 1,  1, 1,  0, 0}, // #310
  {DBGFIELD("WriteSHDmrcl")       1, false, false, false, 1159, 1, 14, 1,  0, 0}, // #311
  {DBGFIELD("WriteSHDmri")        1, false, false, false, 1159, 1, 14, 1,  0, 0}, // #312
  {DBGFIELD("WriteSHDrrcl")       1, false, false, false, 75, 1, 12, 1,  0, 0}, // #313
  {DBGFIELD("WriteFSqrt64XLd")    6, false, false, false, 2261, 3, 95, 1,  0, 0}, // #314
  {DBGFIELD("WriteFSqrt64X")      5, false, false, false, 2261, 3, 95, 1,  0, 0}, // #315
  {DBGFIELD("WriteFSqrtXLd")      6, false, false, false, 2264, 3, 57, 1,  0, 0}, // #316
  {DBGFIELD("WriteFSqrtX")        5, false, false, false, 2264, 3, 57, 1,  0, 0}, // #317
  {DBGFIELD("WriteFSqrt64Ld")     4, false, false, false, 2270, 3, 64, 1,  0, 0}, // #318
  {DBGFIELD("WriteFSqrt64Ld_ReadAfterVecLd") 4, false, false, false, 2270, 3, 64, 1, 15, 1}, // #319
  {DBGFIELD("WriteFSqrt64")       3, false, false, false, 2270, 3, 64, 1,  0, 0}, // #320
  {DBGFIELD("WriteFSqrtLd")       4, false, false, false, 2267, 3, 96, 1,  0, 0}, // #321
  {DBGFIELD("WriteFSqrtLd_ReadAfterVecLd") 4, false, false, false, 2267, 3, 96, 1, 15, 1}, // #322
  {DBGFIELD("WriteFSqrt")         3, false, false, false, 2267, 3, 96, 1,  0, 0}, // #323
  {DBGFIELD("WriteFSqrt80")       1, false, false, false, 2291, 2, 79, 1,  0, 0}, // #324
  {DBGFIELD("WriteSTMXCSR")       4, false, false, false, 2293, 3, 11, 1,  0, 0}, // #325
  {DBGFIELD("WriteTZCNTLd")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #326
  {DBGFIELD("WriteTZCNT")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #327
  {DBGFIELD("WriteFMAZLd")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #328
  {DBGFIELD("WriteFMALd")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #329
  {DBGFIELD("WriteFAdd64YLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #330
  {DBGFIELD("WriteFAdd64Y")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #331
  {DBGFIELD("WriteFAdd64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #332
  {DBGFIELD("WriteFAdd64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #333
  {DBGFIELD("WriteFAddYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #334
  {DBGFIELD("WriteFAddY")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #335
  {DBGFIELD("WriteFAddZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #336
  {DBGFIELD("WriteFAddZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #337
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #338
  {DBGFIELD("WriteShuffleY")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #339
  {DBGFIELD("WriteShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #340
  {DBGFIELD("WriteShuffleZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #341
  {DBGFIELD("WriteFLogicYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #342
  {DBGFIELD("WriteFLogicY")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #343
  {DBGFIELD("WriteFLogicZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #344
  {DBGFIELD("WriteFLogicZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #345
  {DBGFIELD("WriteCvtPH2PSY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #346
  {DBGFIELD("WriteCvtPH2PS")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #347
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #348
  {DBGFIELD("WriteFVarBlendY")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #349
  {DBGFIELD("WriteFVarBlendZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #350
  {DBGFIELD("WriteFVarBlendZ")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #351
  {DBGFIELD("WriteFBlendYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #352
  {DBGFIELD("WriteFBlendY")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #353
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #354
  {DBGFIELD("WriteFVarBlendLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #355
  {DBGFIELD("WriteShuffle256Ld")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #356
  {DBGFIELD("WriteShuffle256")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #357
  {DBGFIELD("WriteShuffleYLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #358
  {DBGFIELD("WriteFShuffle256")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #359
  {DBGFIELD("WriteFShuffle256Ld") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #360
  {DBGFIELD("WriteFCmp64YLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #361
  {DBGFIELD("WriteFCmp64Y")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #362
  {DBGFIELD("WriteFCmpYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #363
  {DBGFIELD("WriteFCmpY")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #364
  {DBGFIELD("WriteFCmpZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #365
  {DBGFIELD("WriteFCmpZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #366
  {DBGFIELD("WriteVarShuffle256Ld") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #367
  {DBGFIELD("WriteVarShuffle256") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #368
  {DBGFIELD("WriteCvtI2PDYLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #369
  {DBGFIELD("WriteCvtI2PDY")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #370
  {DBGFIELD("WriteCvtI2PDZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #371
  {DBGFIELD("WriteCvtI2PDZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #372
  {DBGFIELD("WriteCvtI2PSYLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #373
  {DBGFIELD("WriteCvtI2PSY")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #374
  {DBGFIELD("WriteCvtI2PSZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #375
  {DBGFIELD("WriteCvtI2PSZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #376
  {DBGFIELD("WriteCvtPD2PSLd_ReadAfterVecXLd") 5, false, false, false, 2246, 3,  2, 1, 15, 1}, // #377
  {DBGFIELD("WriteCvtPD2PSYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #378
  {DBGFIELD("WriteCvtPD2PSY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #379
  {DBGFIELD("WriteCvtPD2PSZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #380
  {DBGFIELD("WriteCvtPD2PSZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #381
  {DBGFIELD("WriteCvtPD2PSYLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #382
  {DBGFIELD("WriteCvtPD2PSZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #383
  {DBGFIELD("WriteCvtPD2IYLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #384
  {DBGFIELD("WriteCvtPD2IY")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #385
  {DBGFIELD("WriteCvtPD2IZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #386
  {DBGFIELD("WriteCvtPD2IZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #387
  {DBGFIELD("WriteCvtPS2IYLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #388
  {DBGFIELD("WriteCvtPS2IY")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #389
  {DBGFIELD("WriteCvtPS2IZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #390
  {DBGFIELD("WriteCvtPS2IZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #391
  {DBGFIELD("WriteCvtPS2PDYLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #392
  {DBGFIELD("WriteCvtPS2PDY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #393
  {DBGFIELD("WriteCvtPS2PDZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #394
  {DBGFIELD("WriteCvtPS2PDZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #395
  {DBGFIELD("WriteCvtPH2PSYLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #396
  {DBGFIELD("WriteCvtPH2PSLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #397
  {DBGFIELD("WriteCvtPH2PSZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #398
  {DBGFIELD("WriteCvtPH2PSZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #399
  {DBGFIELD("WriteCvtPS2PHYSt")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #400
  {DBGFIELD("WriteCvtPS2PHY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #401
  {DBGFIELD("WriteCvtPS2PHSt")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #402
  {DBGFIELD("WriteCvtPS2PH")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #403
  {DBGFIELD("WriteCvtPS2PHZSt")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #404
  {DBGFIELD("WriteCvtPS2PHZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #405
  {DBGFIELD("WriteCvtSD2ILd_ReadAfterVecLd") 4, false, false, false, 2232, 3, 22, 1, 15, 1}, // #406
  {DBGFIELD("WriteCvtSS2ILd_ReadAfterVecLd") 4, false, false, false, 2235, 3, 22, 1, 15, 1}, // #407
  {DBGFIELD("WritePSADBWYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #408
  {DBGFIELD("WritePSADBWY")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #409
  {DBGFIELD("WritePSADBWZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #410
  {DBGFIELD("WritePSADBWZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #411
  {DBGFIELD("WriteFDiv64YLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #412
  {DBGFIELD("WriteFDiv64Y")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #413
  {DBGFIELD("WriteFDiv64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #414
  {DBGFIELD("WriteFDiv64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #415
  {DBGFIELD("WriteFDivYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #416
  {DBGFIELD("WriteFDivY")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #417
  {DBGFIELD("WriteFDivZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #418
  {DBGFIELD("WriteFDivZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #419
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #420
  {DBGFIELD("WriteFMAX")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #421
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #422
  {DBGFIELD("WriteFMAY")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #423
  {DBGFIELD("WriteFMAZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #424
  {DBGFIELD("WriteFMAZ")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #425
  {DBGFIELD("WriteDPPSYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #426
  {DBGFIELD("WriteDPPSY")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #427
  {DBGFIELD("WriteVarShuffle256Ld_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #428
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #429
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #430
  {DBGFIELD("WriteFMALd_ReadAfterVecLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #431
  {DBGFIELD("WriteFMA")           8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #432
  {DBGFIELD("WriteFMALd_ReadAfterVecLd_ReadAfterVecLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #433
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #434
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #435
  {DBGFIELD("WriteFMALd_ReadAfterVecLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #436
  {DBGFIELD("WriteFRndYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #437
  {DBGFIELD("WriteFRndY")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #438
  {DBGFIELD("WriteLoad_WriteVecMaskedGatherWriteback") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #439
  {DBGFIELD("WriteFRndZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #440
  {DBGFIELD("WriteFRndZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #441
  {DBGFIELD("WriteVecIMulYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #442
  {DBGFIELD("WriteVecIMulY")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #443
  {DBGFIELD("WriteVecIMulZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #444
  {DBGFIELD("WriteVecIMulZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #445
  {DBGFIELD("WriteVecALUYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #446
  {DBGFIELD("WriteVecALUY")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #447
  {DBGFIELD("WriteVecALUZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #448
  {DBGFIELD("WriteVecALUZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #449
  {DBGFIELD("WriteFHAddYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #450
  {DBGFIELD("WriteFHAddY")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #451
  {DBGFIELD("WriteFShuffle256Ld_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #452
  {DBGFIELD("WriteShuffle256Ld_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #453
  {DBGFIELD("WriteVecLoadY")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #454
  {DBGFIELD("WriteFMaskedStore64Y") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #455
  {DBGFIELD("WriteFMaskedLoadY")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #456
  {DBGFIELD("WriteFMaskedStore64") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #457
  {DBGFIELD("WriteFMaskedLoad")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #458
  {DBGFIELD("WriteFMaskedStore32Y") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #459
  {DBGFIELD("WriteFMaskedStore32") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #460
  {DBGFIELD("WriteFCmp64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #461
  {DBGFIELD("WriteFCmp64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #462
  {DBGFIELD("WriteFMoveY")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #463
  {DBGFIELD("WriteFMoveZ")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #464
  {DBGFIELD("WriteFShuffleYLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #465
  {DBGFIELD("WriteFShuffleY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #466
  {DBGFIELD("WriteFShuffleZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #467
  {DBGFIELD("WriteFShuffleZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #468
  {DBGFIELD("WriteVecStoreY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #469
  {DBGFIELD("WriteVecMoveY")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #470
  {DBGFIELD("WriteVecMoveZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #471
  {DBGFIELD("WriteVecLoadNTY")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #472
  {DBGFIELD("WriteVecStoreNTY")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #473
  {DBGFIELD("WriteFStoreNTY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #474
  {DBGFIELD("WriteMPSADYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #475
  {DBGFIELD("WriteMPSADY")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #476
  {DBGFIELD("WriteFMul64YLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #477
  {DBGFIELD("WriteFMul64Y")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #478
  {DBGFIELD("WriteFMul64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #479
  {DBGFIELD("WriteFMul64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #480
  {DBGFIELD("WriteFMulYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #481
  {DBGFIELD("WriteFMulY")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #482
  {DBGFIELD("WriteFMulZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #483
  {DBGFIELD("WriteFMulZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #484
  {DBGFIELD("WriteVecALUYLd")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #485
  {DBGFIELD("WriteVecALUZLd")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #486
  {DBGFIELD("WriteVecLogicYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #487
  {DBGFIELD("WriteVecLogicY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #488
  {DBGFIELD("WriteVecLogicZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #489
  {DBGFIELD("WriteVecLogicZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #490
  {DBGFIELD("WriteBlendYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #491
  {DBGFIELD("WriteBlendY")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #492
  {DBGFIELD("WriteVarBlendYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #493
  {DBGFIELD("WriteVarBlendY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #494
  {DBGFIELD("WriteVarBlendZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #495
  {DBGFIELD("WriteVarBlendZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #496
  {DBGFIELD("WriteVarBlendYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #497
  {DBGFIELD("WriteVarBlendLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #498
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #499
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #500
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 1, false, false, false, 2220, 2,  1, 1, 15, 2}, // #501
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd_ReadAfterVecXLd") 1, false, false, false, 2220, 2,  1, 1, 17, 2}, // #502
  {DBGFIELD("WriteFVarShuffle256Ld_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #503
  {DBGFIELD("WriteFVarShuffle256") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #504
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #505
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #506
  {DBGFIELD("WriteFVarShuffleY")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #507
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #508
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #509
  {DBGFIELD("WriteFVarShuffle")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #510
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #511
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #512
  {DBGFIELD("WriteFVarShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #513
  {DBGFIELD("WriteFVarShuffleZ")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #514
  {DBGFIELD("WritePHAddYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #515
  {DBGFIELD("WritePHAddY")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #516
  {DBGFIELD("WriteVecInsert")     1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #517
  {DBGFIELD("WriteVecIMulXLd")    1, false, false, false, 2273, 2, 10, 1,  0, 0}, // #518
  {DBGFIELD("WriteVecIMulYLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #519
  {DBGFIELD("WriteVecIMulZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #520
  {DBGFIELD("WriteVecMaskedStore32Y") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #521
  {DBGFIELD("WriteVecMaskedLoadY") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #522
  {DBGFIELD("WriteVecMaskedStore32") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #523
  {DBGFIELD("WriteVecMaskedLoad") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #524
  {DBGFIELD("WriteVecMaskedStore64Y") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #525
  {DBGFIELD("WriteVecMaskedStore64") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #526
  {DBGFIELD("WriteVPMOV256Ld")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #527
  {DBGFIELD("WriteVPMOV256")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #528
  {DBGFIELD("WriteVecMOVMSKY")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #529
  {DBGFIELD("WritePMULLDYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #530
  {DBGFIELD("WritePMULLDY")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #531
  {DBGFIELD("WritePMULLDZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #532
  {DBGFIELD("WritePMULLDZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #533
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 5, false, false, false, 2280, 3, 10, 1, 15, 2}, // #534
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd_ReadAfterVecXLd") 5, false, false, false, 2280, 3, 10, 1, 17, 2}, // #535
  {DBGFIELD("WriteVecShiftImmXLd") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #536
  {DBGFIELD("WriteVecShiftImmYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #537
  {DBGFIELD("WriteVecShiftImmY")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #538
  {DBGFIELD("WriteVecShiftImmZLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #539
  {DBGFIELD("WriteVecShiftImmZ")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #540
  {DBGFIELD("WriteVarVecShiftLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #541
  {DBGFIELD("WriteVarVecShift")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #542
  {DBGFIELD("WriteVarVecShiftYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #543
  {DBGFIELD("WriteVarVecShiftY")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #544
  {DBGFIELD("WriteVarVecShiftZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #545
  {DBGFIELD("WriteVarVecShiftZ")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #546
  {DBGFIELD("WriteVecShiftImmXLd_ReadAfterVecXLd") 1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #547
  {DBGFIELD("WriteVarShuffleYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #548
  {DBGFIELD("WriteVarShuffleY")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #549
  {DBGFIELD("WriteVarShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #550
  {DBGFIELD("WriteVarShuffleZ")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #551
  {DBGFIELD("WriteShuffleZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #552
  {DBGFIELD("WriteVecShiftYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #553
  {DBGFIELD("WriteVecShiftY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #554
  {DBGFIELD("WriteVecShiftZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #555
  {DBGFIELD("WriteVecShiftZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #556
  {DBGFIELD("WriteVecTestYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #557
  {DBGFIELD("WriteVecTestY")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #558
  {DBGFIELD("WriteFRcpXLd_ReadAfterVecXLd") 6, false, false, false, 2232, 3,  9, 1, 15, 1}, // #559
  {DBGFIELD("WriteFRcpYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #560
  {DBGFIELD("WriteFRcpY")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #561
  {DBGFIELD("WriteFRcpZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #562
  {DBGFIELD("WriteFRcpZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #563
  {DBGFIELD("WriteFRcpYLd")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #564
  {DBGFIELD("WriteFRndYLd")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #565
  {DBGFIELD("WriteFRsqrtXLd_ReadAfterVecXLd") 6, false, false, false, 2232, 3,  9, 1, 15, 1}, // #566
  {DBGFIELD("WriteFRsqrtYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #567
  {DBGFIELD("WriteFRsqrtY")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #568
  {DBGFIELD("WriteFRsqrtZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #569
  {DBGFIELD("WriteFRsqrtZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #570
  {DBGFIELD("WriteFRsqrtYLd")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #571
  {DBGFIELD("WriteFShuffleYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #572
  {DBGFIELD("WriteFShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #573
  {DBGFIELD("WriteFSqrt64YLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #574
  {DBGFIELD("WriteFSqrt64Y")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #575
  {DBGFIELD("WriteFSqrt64XLd_ReadAfterVecXLd") 6, false, false, false, 2261, 3, 95, 1, 15, 1}, // #576
  {DBGFIELD("WriteFSqrt64YLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #577
  {DBGFIELD("WriteFSqrt64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #578
  {DBGFIELD("WriteFSqrt64Z")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #579
  {DBGFIELD("WriteFSqrtXLd_ReadAfterVecXLd") 6, false, false, false, 2264, 3, 57, 1, 15, 1}, // #580
  {DBGFIELD("WriteFSqrtYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #581
  {DBGFIELD("WriteFSqrtY")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #582
  {DBGFIELD("WriteFSqrtZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #583
  {DBGFIELD("WriteFSqrtZ")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #584
  {DBGFIELD("WriteFSqrtYLd")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #585
  {DBGFIELD("WriteFTestYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #586
  {DBGFIELD("WriteFTestY")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #587
  {DBGFIELD("WriteFTestLd_ReadAfterVecXLd") 1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #588
  {DBGFIELD("WriteFTest")         1, false, false, false,  4, 1,  1, 1,  0, 0}, // #589
  {DBGFIELD("WriteALULd_WriteRMW") 2, false, false, false, 2273, 2, 97, 2,  0, 0}, // #590
  {DBGFIELD("COPY")               1, false, false, false,  4, 1,  1, 1,  0, 0}, // #591
  {DBGFIELD("XAM_F")              1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #592
  {DBGFIELD("LD_Frr")             1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #593
  {DBGFIELD("MOVSX64rr32")        1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #594
  {DBGFIELD("RCL16m1_RCL16mi_RCL32m1_RCL32mi_RCL64m1_RCL64mi_RCL8m1_RCL8mi_RCR16m1_RCR16mi_RCR32m1_RCR32mi_RCR64m1_RCR64mi_RCR8m1_RCR8mi_ROL16m1_ROL16mi_ROL32m1_ROL32mi_ROL64m1_ROL64mi_ROL8m1_ROL8mi_ROR16m1_ROR16mi_ROR32m1_ROR32mi_ROR64m1_ROR64mi_ROR8m1_ROR8mi") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #595
  {DBGFIELD("RCL16mCL_RCL32mCL_RCL64mCL_RCL8mCL_RCR16mCL_RCR32mCL_RCR64mCL_RCR8mCL_ROL16mCL_ROL32mCL_ROL64mCL_ROL8mCL_ROR16mCL_ROR32mCL_ROR64mCL_ROR8mCL") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #596
  {DBGFIELD("SAR16m1_SAR16mi_SAR32m1_SAR32mi_SAR64m1_SAR64mi_SAR8m1_SAR8mi_SHL16m1_SHL16mi_SHL32m1_SHL32mi_SHL64m1_SHL64mi_SHL8m1_SHL8mi_SHR16m1_SHR16mi_SHR32m1_SHR32mi_SHR64m1_SHR64mi_SHR8m1_SHR8mi") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #597
  {DBGFIELD("SAR16mCL_SAR32mCL_SAR64mCL_SAR8mCL_SHL16mCL_SHL32mCL_SHL64mCL_SHL8mCL_SHR16mCL_SHR32mCL_SHR64mCL_SHR8mCL") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #598
  {DBGFIELD("MOVSX32rr16_MOVSX32rr8_MOVSX32rr8_NOREX_MOVSX64rr16_MOVSX64rr8_MOVZX32rr16_MOVZX32rr8_MOVZX32rr8_NOREX_MOVZX64rr16_MOVZX64rr8") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #599
  {DBGFIELD("FCOMPP")             1, false, false, false,  3, 2,  1, 1,  0, 0}, // #600
  {DBGFIELD("UCOM_FPPr_UCOM_FPr_UCOM_Fr") 1, false, false, false,  3, 2,  1, 1,  0, 0}, // #601
  {DBGFIELD("MMX_CVTPI2PSrr")     1, false, false, false, 1215, 2, 10, 1,  0, 0}, // #602
  {DBGFIELD("MMX_CVTPI2PSrm")     1, false, false, false, 1215, 2, 10, 1,  0, 0}, // #603
  {DBGFIELD("MMX_CVTPS2PIrr_MMX_CVTTPS2PIrr") 1, false, false, false, 1215, 2, 10, 1,  0, 0}, // #604
  {DBGFIELD("POP32r_POP64r_POP16rmr_POP32rmr_POP64rmr") 1, false, false, false, 269, 3,  1, 1,  0, 0}, // #605
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r_PUSHi16_PUSHi32_PUSH16rmr_PUSH32rmr_PUSH64rmr_PUSH16i8_PUSH32i8_PUSH64i8_PUSH64i32") 1, false, false, false, 269, 3,  1, 1,  0, 0}, // #606
  {DBGFIELD("XCH_F")              1, false, false, false, 269, 3,  1, 1,  0, 0}, // #607
  {DBGFIELD("RETI16_RETI32_RETI64_IRET_IRET16_IRET32_IRET64") 1, false, false, false, 269, 3,  1, 1,  0, 0}, // #608
  {DBGFIELD("MMX_CVTPS2PIrm_MMX_CVTTPS2PIrm") 1, false, false, false, 2225, 3, 10, 1,  0, 0}, // #609
  {DBGFIELD("ILD_F16m_ILD_F32m_ILD_F64m") 1, false, false, false, 2225, 3, 10, 1,  0, 0}, // #610
  {DBGFIELD("CVTSI642SDrm")       1, false, false, false, 2222, 3,  6, 1,  0, 0}, // #611
  {DBGFIELD("CVTSI642SDrm_Int")   1, false, false, false, 2222, 3,  6, 1,  0, 0}, // #612
  {DBGFIELD("CVTSI642SSrr")       4, false, false, false, 2243, 3,  6, 1,  0, 0}, // #613
  {DBGFIELD("CVTSI642SSrr_Int")   4, false, false, false, 2243, 3,  6, 1,  0, 0}, // #614
  {DBGFIELD("CVTSI642SSrm")       4, false, false, false, 2243, 3,  6, 1,  0, 0}, // #615
  {DBGFIELD("CVTSI642SSrm_Int")   4, false, false, false, 2243, 3,  6, 1,  0, 0}, // #616
  {DBGFIELD("CVTSS2SI64rr_CVTTSS2SI64rr") 4, false, false, false, 2235, 3, 22, 1,  0, 0}, // #617
  {DBGFIELD("CVTSS2SI64rr_Int_CVTTSS2SI64rr_Int") 4, false, false, false, 2235, 3, 22, 1,  0, 0}, // #618
  {DBGFIELD("CVTSS2SI64rm_CVTSS2SI64rm_Int_CVTTSS2SI64rm_CVTTSS2SI64rm_Int") 5, false, false, false, 2249, 3,  9, 1,  0, 0}, // #619
  {DBGFIELD("FDECSTP_FFREE_FFREEP_FINCSTP_WAIT_STOSB_STOSL_STOSQ_STOSW") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #620
  {DBGFIELD("LFENCE")             1, false, false, false,  4, 1,  1, 1,  0, 0}, // #621
  {DBGFIELD("MOVSSrr_MOVSSrr_REV") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #622
  {DBGFIELD("LEAVE_LEAVE64")      1, false, false, false, 75, 1, 12, 1,  0, 0}, // #623
  {DBGFIELD("POP16r")             1, false, false, false, 75, 1, 12, 1,  0, 0}, // #624
  {DBGFIELD("PUSH16rmm_PUSH32rmm_PUSH64rmm") 1, false, false, false, 75, 1, 12, 1,  0, 0}, // #625
  {DBGFIELD("LODSB_LODSL_LODSQ_LODSW_SCASB_SCASL_SCASQ_SCASW") 1, false, false, false, 75, 1, 12, 1,  0, 0}, // #626
  {DBGFIELD("PUSHCS16_PUSHCS32_PUSHDS16_PUSHDS32_PUSHES16_PUSHES32_PUSHFS16_PUSHFS32_PUSHFS64_PUSHGS16_PUSHGS32_PUSHGS64_PUSHSS16_PUSHSS32") 1, false, false, false, 75, 1, 12, 1,  0, 0}, // #627
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m_ST_F32m_ST_F64m_ST_FP32m_ST_FP64m") 1, false, false, false, 75, 1, 12, 1,  0, 0}, // #628
  {DBGFIELD("ST_FPrr_ST_Frr")     1, false, false, false, 75, 1, 12, 1,  0, 0}, // #629
  {DBGFIELD("MMX_PADDQrr_MMX_PSUBQrr") 1, false, false, false, 75, 1, 12, 1,  0, 0}, // #630
  {DBGFIELD("MOVSX16rr8_MOVZX16rr8") 1, false, false, false, 75, 1, 12, 1,  0, 0}, // #631
  {DBGFIELD("MOVDQUmr_MASKMOVDQU_MASKMOVDQU64") 1, false, false, false, 75, 1, 12, 1,  0, 0}, // #632
  {DBGFIELD("MOVUPDmr_MOVUPSmr")  1, false, false, false, 75, 1, 12, 1,  0, 0}, // #633
  {DBGFIELD("PADDQrr_PSUBQrr")    1, false, false, false, 75, 1, 12, 1,  0, 0}, // #634
  {DBGFIELD("CLD")                1, false, false, false, 214, 1,  5, 1,  0, 0}, // #635
  {DBGFIELD("LDDQUrm")            1, false, false, false, 214, 1,  5, 1,  0, 0}, // #636
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW_MOVSB_MOVSL_MOVSQ_MOVSW") 1, false, false, false, 214, 1,  5, 1,  0, 0}, // #637
  {DBGFIELD("POP16rmm_POP32rmm_POP64rmm") 1, false, false, false, 214, 1,  5, 1,  0, 0}, // #638
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm_XCHG16rm_XCHG32rm_XCHG64rm_XCHG8rm") 1, false, false, false, 214, 1,  5, 1,  0, 0}, // #639
  {DBGFIELD("PHADDDrr_PHSUBDrr")  1, false, false, false, 214, 1,  5, 1,  0, 0}, // #640
  {DBGFIELD("MOVSX16rm8_MOVZX16rm8") 1, false, false, false, 214, 1,  5, 1,  0, 0}, // #641
  {DBGFIELD("MMX_PADDQrm_MMX_PSUBQrm") 1, false, false, false, 214, 1,  5, 1,  0, 0}, // #642
  {DBGFIELD("MOVDQUrm")           1, false, false, false, 214, 1,  5, 1,  0, 0}, // #643
  {DBGFIELD("MOVUPDrm_MOVUPSrm")  1, false, false, false, 214, 1,  5, 1,  0, 0}, // #644
  {DBGFIELD("PADDQrm_PSUBQrm")    1, false, false, false, 214, 1,  5, 1,  0, 0}, // #645
  {DBGFIELD("CBW_CWD_CWDE_CDQ_CDQE_CQO") 1, false, false, false, 1159, 1, 14, 1,  0, 0}, // #646
  {DBGFIELD("JCXZ_JECXZ_JRCXZ")   1, false, false, false, 1159, 1, 14, 1,  0, 0}, // #647
  {DBGFIELD("LD_F80m")            1, false, false, false, 1159, 1, 14, 1,  0, 0}, // #648
  {DBGFIELD("PHADDDrm_PHSUBDrm")  1, false, false, false, 1159, 1, 14, 1,  0, 0}, // #649
  {DBGFIELD("MMX_PEXTRWrr_PEXTRWrr_PEXTRWrr_REV") 1, false, false, false, 1159, 1, 14, 1,  0, 0}, // #650
  {DBGFIELD("FLDCW16m")           1, false, false, false, 240, 1, 10, 1,  0, 0}, // #651
  {DBGFIELD("ST_FP80m")           1, false, false, false, 240, 1, 10, 1,  0, 0}, // #652
  {DBGFIELD("MMX_PHADDSWrr_MMX_PHADDWrr_MMX_PHSUBSWrr_MMX_PHSUBWrr") 1, false, false, false, 240, 1, 10, 1,  0, 0}, // #653
  {DBGFIELD("CMPXCHG8rm")         1, false, false, false, 464, 1,  3, 1,  0, 0}, // #654
  {DBGFIELD("INTO")               1, false, false, false, 464, 1,  3, 1,  0, 0}, // #655
  {DBGFIELD("XLAT")               1, false, false, false, 464, 1,  3, 1,  0, 0}, // #656
  {DBGFIELD("SHLD16rrCL_SHRD16rrCL") 1, false, false, false, 464, 1,  3, 1,  0, 0}, // #657
  {DBGFIELD("SHLD16rri8_SHRD16rri8") 1, false, false, false, 464, 1,  3, 1,  0, 0}, // #658
  {DBGFIELD("SHLD16mrCL_SHRD16mrCL") 1, false, false, false, 464, 1,  3, 1,  0, 0}, // #659
  {DBGFIELD("SHLD16mri8_SHRD16mri8") 1, false, false, false, 464, 1,  3, 1,  0, 0}, // #660
  {DBGFIELD("IST_F16m_IST_F32m_IST_FP16m_IST_FP32m_IST_FP64m") 1, false, false, false, 464, 1,  3, 1,  0, 0}, // #661
  {DBGFIELD("MMX_PHADDSWrm_MMX_PHADDWrm_MMX_PHSUBSWrm_MMX_PHSUBWrm") 1, false, false, false, 464, 1,  3, 1,  0, 0}, // #662
  {DBGFIELD("AAD8i8")             1, false, false, false, 478, 1,  6, 1,  0, 0}, // #663
  {DBGFIELD("LOOPE")              1, false, false, false, 504, 1,  7, 1,  0, 0}, // #664
  {DBGFIELD("PUSHA16_PUSHA32")    1, false, false, false, 504, 1,  7, 1,  0, 0}, // #665
  {DBGFIELD("SHLD64rrCL_SHRD64rrCL") 1, false, false, false, 504, 1,  7, 1,  0, 0}, // #666
  {DBGFIELD("FNSTCW16m")          1, false, false, false, 504, 1,  7, 1,  0, 0}, // #667
  {DBGFIELD("POPA16_POPA32")      1, false, false, false, 293, 1, 22, 1,  0, 0}, // #668
  {DBGFIELD("PUSHF16_PUSHF32_PUSHF64") 1, false, false, false, 293, 1, 22, 1,  0, 0}, // #669
  {DBGFIELD("SHLD64mrCL_SHRD64mrCL") 1, false, false, false, 293, 1, 22, 1,  0, 0}, // #670
  {DBGFIELD("SHLD64mri8_SHRD64mri8") 1, false, false, false, 293, 1, 22, 1,  0, 0}, // #671
  {DBGFIELD("SHLD64rri8_SHRD64rri8") 1, false, false, false, 293, 1, 22, 1,  0, 0}, // #672
  {DBGFIELD("CMPXCHG8rr")         1, false, false, false, 293, 1, 22, 1,  0, 0}, // #673
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr_TST_F_TST_Fp32_TST_Fp64_TST_Fp80") 1, false, false, false, 293, 1, 22, 1,  0, 0}, // #674
  {DBGFIELD("BOUNDS16rm_BOUNDS32rm") 1, false, false, false, 82, 1,  8, 1,  0, 0}, // #675
  {DBGFIELD("AAA_AAS")            1, false, false, false, 798, 1, 24, 1,  0, 0}, // #676
  {DBGFIELD("CMPXCHG16rm_CMPXCHG32rm_CMPXCHG64rm") 1, false, false, false, 946, 1, 21, 1,  0, 0}, // #677
  {DBGFIELD("LOOPNE")             1, false, false, false, 961, 1, 20, 1,  0, 0}, // #678
  {DBGFIELD("PAUSE")              1, false, false, false, 961, 1, 20, 1,  0, 0}, // #679
  {DBGFIELD("CMPXCHG8B")          1, false, false, false, 1749, 1, 13, 1,  0, 0}, // #680
  {DBGFIELD("DAA")                1, false, false, false, 1749, 1, 13, 1,  0, 0}, // #681
  {DBGFIELD("LOOP")               1, false, false, false, 1749, 1, 13, 1,  0, 0}, // #682
  {DBGFIELD("DAS")                1, false, false, false, 2234, 1, 15, 1,  0, 0}, // #683
  {DBGFIELD("AAM8i8")             1, false, false, false, 2296, 1, 23, 1,  0, 0}, // #684
  {DBGFIELD("STD")                1, false, false, false, 2296, 1, 23, 1,  0, 0}, // #685
  {DBGFIELD("CMPXCHG16B")         1, false, false, false, 1881, 1, 19, 1,  0, 0}, // #686
  {DBGFIELD("ARPL16mr_ARPL16rr")  1, false, false, false, 906, 1, 18, 1,  0, 0}, // #687
  {DBGFIELD("FNCLEX_FXTRACT")     1, false, false, false, 2297, 1, 42, 1,  0, 0}, // #688
  {DBGFIELD("POPF32_POPF64")      1, false, false, false, 1392, 1, 76, 1,  0, 0}, // #689
  {DBGFIELD("POPDS16_POPDS32_POPES16_POPES32_POPFS16_POPFS32_POPFS64_POPGS16_POPGS32_POPGS64") 1, false, false, false, 2298, 1, 68, 1,  0, 0}, // #690
  {DBGFIELD("RDTSC_RDTSCP")       1, false, false, false, 2295, 1, 60, 1,  0, 0}, // #691
  {DBGFIELD("ENTER")              1, false, false, false, 2230, 1, 47, 1,  0, 0}, // #692
  {DBGFIELD("POPF16")             1, false, false, false, 2230, 1, 47, 1,  0, 0}, // #693
  {DBGFIELD("MONITOR32rrr_MONITOR64rrr") 1, false, false, false, 2299, 1, 99, 1,  0, 0}, // #694
  {DBGFIELD("FRNDINT")            1, false, false, false, 918, 1, 62, 1,  0, 0}, // #695
  {DBGFIELD("MWAITrr_RDPMC")      1, false, false, false, 918, 1, 62, 1,  0, 0}, // #696
  {DBGFIELD("POPSS16_POPSS32")    1, false, false, false, 1689, 1, 100, 1,  0, 0}, // #697
  {DBGFIELD("FPREM")              1, false, false, false, 2300, 1, 101, 1,  0, 0}, // #698
  {DBGFIELD("INSB_INSL_INSW")     1, false, false, false, 2301, 1, 102, 1,  0, 0}, // #699
  {DBGFIELD("FNINIT")             1, false, false, false, 2302, 1, 52, 1,  0, 0}, // #700
  {DBGFIELD("OUT8rr_OUT16rr_OUT32rr") 1, false, false, false, 2269, 1, 94, 1,  0, 0}, // #701
  {DBGFIELD("FPREM1")             1, false, false, false, 2292, 1, 79, 1,  0, 0}, // #702
  {DBGFIELD("INVLPG_INVLPGA32_INVLPGA64") 1, false, false, false, 2292, 1, 79, 1,  0, 0}, // #703
  {DBGFIELD("OUT8ir_OUT16ir_OUT32ir") 1, false, false, false, 2303, 1, 103, 1,  0, 0}, // #704
  {DBGFIELD("OUTSB_OUTSL_OUTSW")  1, false, false, false, 2304, 1, 87, 1,  0, 0}, // #705
  {DBGFIELD("FSCALE")             1, false, false, false, 2305, 1, 104, 1,  0, 0}, // #706
  {DBGFIELD("RDMSR")              1, false, false, false, 2306, 1, 105, 1,  0, 0}, // #707
  {DBGFIELD("RET_RET16_RET32_RET64_LRET16_LRET32_LRET64_LRETI16_LRETI32_LRETI64") 1, false, false, false, 992, 1, 106, 1,  0, 0}, // #708
  {DBGFIELD("IN8ri_IN16ri_IN32ri") 1, false, false, false, 2307, 1, 107, 1,  0, 0}, // #709
  {DBGFIELD("IN8rr_IN16rr_IN32rr") 1, false, false, false, 2308, 1, 108, 1,  0, 0}, // #710
  {DBGFIELD("F2XM1")              1, false, false, false, 2309, 1, 109, 1,  0, 0}, // #711
  {DBGFIELD("CPUID")              1, false, false, false, 2310, 1, 110, 1,  0, 0}, // #712
  {DBGFIELD("INT")                1, false, false, false, 2311, 1, 111, 1,  0, 0}, // #713
  {DBGFIELD("INT3")               1, false, false, false, 2312, 1, 93, 1,  0, 0}, // #714
  {DBGFIELD("FXSAVE_FXSAVE64")    1, false, false, false, 2266, 1, 112, 1,  0, 0}, // #715
  {DBGFIELD("FXRSTOR_FXRSTOR64")  1, false, false, false, 2313, 1, 113, 1,  0, 0}, // #716
  {DBGFIELD("FYL2X")              1, false, false, false, 2314, 1, 114, 1,  0, 0}, // #717
  {DBGFIELD("FYL2XP1")            1, false, false, false, 2315, 1, 115, 1,  0, 0}, // #718
  {DBGFIELD("FPTAN")              1, false, false, false, 2316, 1, 116, 1,  0, 0}, // #719
  {DBGFIELD("FSINCOS_FSIN_FCOS")  1, false, false, false, 2317, 1, 117, 1,  0, 0}, // #720
  {DBGFIELD("FPATAN")             1, false, false, false, 2318, 1, 118, 1,  0, 0}, // #721
  {DBGFIELD("WRMSR")              1, false, false, false, 2319, 1, 119, 1,  0, 0}, // #722
  {DBGFIELD("COMP_FST0r_COM_FST0r") 1, false, false, false, 2238, 2, 10, 1,  0, 0}, // #723
  {DBGFIELD("UCOM_FPr_UCOM_Fr")   1, false, false, false,  3, 2,  1, 1,  0, 0}, // #724
  {DBGFIELD("FDECSTP_FINCSTP_FFREE_FFREEP") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #725
  {DBGFIELD("FNOP")               1, false, false, false,  4, 1,  1, 1,  0, 0}, // #726
  {DBGFIELD("RET64")              1, false, false, false, 992, 1, 106, 1,  0, 0}, // #727
  {DBGFIELD("CDQ_CQO")            1, false, false, false, 1159, 1, 14, 1,  0, 0}, // #728
  {DBGFIELD("MMX_PABSBrr_MMX_PABSDrr_MMX_PABSWrr_MMX_PSIGNBrr_MMX_PSIGNDrr_MMX_PSIGNWrr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #729
  {DBGFIELD("MMX_PADDQrr")        1, false, false, false, 75, 1, 12, 1,  0, 0}, // #730
  {DBGFIELD("MMX_PALIGNRrri")     1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #731
  {DBGFIELD("SCASB_SCASL_SCASQ_SCASW") 1, false, false, false, 75, 1, 12, 1,  0, 0}, // #732
  {DBGFIELD("COMISDrr_COMISDrr_Int_COMISSrr_COMISSrr_Int_UCOMISDrr_UCOMISDrr_Int_UCOMISSrr_UCOMISSrr_Int_VCOMISDrr_VCOMISDrr_Int_VCOMISSrr_VCOMISSrr_Int_VUCOMISDrr_VUCOMISDrr_Int_VUCOMISSrr_VUCOMISSrr_Int") 4, false, false, false, 2235, 3, 22, 1,  0, 0}, // #733
  {DBGFIELD("CWD")                1, false, false, false, 1159, 1, 14, 1,  0, 0}, // #734
  {DBGFIELD("FNSTSW16r")          1, false, false, false,  4, 1,  1, 1,  0, 0}, // #735
  {DBGFIELD("MMX_MOVDQ2Qrr")      1, false, false, false,  4, 1,  1, 1,  0, 0}, // #736
  {DBGFIELD("PUSHFS64")           1, false, false, false, 75, 1, 12, 1,  0, 0}, // #737
  {DBGFIELD("EXTRACTPSrr_VEXTRACTPSrr") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #738
  {DBGFIELD("RCL8r1_RCL16r1_RCL32r1_RCL64r1_RCR8r1_RCR16r1_RCR32r1_RCR64r1") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #739
  {DBGFIELD("RCR8ri_RCR16ri_RCR32ri_RCR64ri") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #740
  {DBGFIELD("RCL8ri_RCL16ri_RCL32ri_RCL64ri") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #741
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr") 1, false, false, false, 293, 1, 22, 1,  0, 0}, // #742
  {DBGFIELD("MOV64sr")            1, false, false, false,  4, 1,  1, 1,  0, 0}, // #743
  {DBGFIELD("RCL16rCL_RCL32rCL_RCL64rCL_RCL8rCL_RCR16rCL_RCR32rCL_RCR64rCL_RCR8rCL") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #744
  {DBGFIELD("PUSH16r_PUSH16rmr_PUSH32r_PUSH32rmr_PUSH64i8_PUSH64r_PUSH64rmr") 1, false, false, false, 269, 3,  1, 1,  0, 0}, // #745
  {DBGFIELD("CLI")                1, false, false, false,  4, 1,  4, 1,  0, 0}, // #746
  {DBGFIELD("PUSHGS64")           1, false, false, false, 75, 1, 12, 1,  0, 0}, // #747
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m") 1, false, false, false, 75, 1, 12, 1,  0, 0}, // #748
  {DBGFIELD("CALL64pcrel32")      1, false, false, false,  3, 2,  1, 1,  0, 0}, // #749
  {DBGFIELD("CALL64r_RVMARKER_CALL16r_CALL16r_NT_CALL32r_CALL32r_NT_CALL64r_CALL64r_NT") 1, false, false, false,  3, 2,  1, 1,  0, 0}, // #750
  {DBGFIELD("EXTRACTPSmr_VEXTRACTPSmr") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #751
  {DBGFIELD("STOSB_STOSL_STOSQ_STOSW") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #752
  {DBGFIELD("PEXTRDmr_PEXTRQmr_VPEXTRDmr_VPEXTRQmr") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #753
  {DBGFIELD("PUSHF16_PUSHF64")    1, false, false, false, 293, 1, 22, 1,  0, 0}, // #754
  {DBGFIELD("CLFLUSH_CLFLUSHOPT") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #755
  {DBGFIELD("VBROADCASTSSrm")     1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #756
  {DBGFIELD("MOV64toPQIrm_VMOV64toPQIrm_MOVDI2PDIrm_VMOVDI2PDIrm_MOVQI2PQIrm_VMOVQI2PQIrm") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #757
  {DBGFIELD("MOVDDUPrm_VMOVDDUPrm_MOVSHDUPrm_VMOVSHDUPrm_MOVSLDUPrm_VMOVSLDUPrm") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #758
  {DBGFIELD("MOVSDrm_MOVSDrm_alt_VMOVSDrm_VMOVSDrm_alt_MOVSSrm_MOVSSrm_alt_VMOVSSrm_VMOVSSrm_alt") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #759
  {DBGFIELD("MOV16sm")            1, false, false, false,  4, 1,  1, 1,  0, 0}, // #760
  {DBGFIELD("MMX_PABSBrm_MMX_PABSDrm_MMX_PABSWrm") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #761
  {DBGFIELD("MMX_PALIGNRrmi")     1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #762
  {DBGFIELD("MMX_PSIGNBrm_MMX_PSIGNDrm_MMX_PSIGNWrm") 1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #763
  {DBGFIELD("LODSL_LODSQ")        1, false, false, false, 75, 1, 12, 1,  0, 0}, // #764
  {DBGFIELD("VBROADCASTSDYrm_VBROADCASTSSYrm") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #765
  {DBGFIELD("VMOVDDUPYrm_VMOVSHDUPYrm_VMOVSLDUPYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #766
  {DBGFIELD("VINSERTF128rm")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #767
  {DBGFIELD("MMX_PADDQrm")        1, false, false, false, 214, 1,  5, 1,  0, 0}, // #768
  {DBGFIELD("VERRm_VERWm")        1, false, false, false,  4, 1,  4, 1,  0, 0}, // #769
  {DBGFIELD("FARJMP64m")          1, false, false, false,  3, 2,  1, 1,  0, 0}, // #770
  {DBGFIELD("FNSTSWm")            1, false, false, false,  4, 1,  4, 1,  0, 0}, // #771
  {DBGFIELD("SLDT16r_SLDT32r_SLDT64r_STR16r_STR32r_STR64r") 1, false, false, false,  4, 1,  4, 1,  0, 0}, // #772
  {DBGFIELD("CALL64m_RVMARKER_CALL64m_CALL64m_NT") 1, false, false, false,  3, 2,  1, 1,  0, 0}, // #773
  {DBGFIELD("CALL16m_CALL16m_NT_CALL32m_CALL32m_NT") 1, false, false, false,  3, 2,  1, 1,  0, 0}, // #774
  {DBGFIELD("COMISDrm_COMISDrm_Int_COMISSrm_COMISSrm_Int_UCOMISDrm_UCOMISDrm_Int_UCOMISSrm_UCOMISSrm_Int_VCOMISDrm_VCOMISDrm_Int_VCOMISSrm_VCOMISSrm_Int_VUCOMISDrm_VUCOMISDrm_Int_VUCOMISSrm_VUCOMISSrm_Int") 5, false, false, false, 2232, 3,  9, 1, 15, 1}, // #775
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW") 1, false, false, false, 214, 1,  5, 1,  0, 0}, // #776
  {DBGFIELD("ROL16m1_ROL16mi_ROL32m1_ROL32mi_ROL64m1_ROL64mi_ROL8m1_ROL8mi_ROR16m1_ROR16mi_ROR32m1_ROR32mi_ROR64m1_ROR64mi_ROR8m1_ROR8mi") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #777
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm") 1, false, false, false, 214, 1,  5, 1,  0, 0}, // #778
  {DBGFIELD("FARCALL64m")         1, false, false, false,  3, 2,  1, 1,  0, 0}, // #779
  {DBGFIELD("LD_F32m_LD_F64m")    1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #780
  {DBGFIELD("ROL16mCL_ROL32mCL_ROL64mCL_ROL8mCL_ROR16mCL_ROR32mCL_ROR64mCL_ROR8mCL") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #781
  {DBGFIELD("ADC8mr_ADC16mr_ADC32mr_ADC64mr_SBB8mr_SBB16mr_SBB32mr_SBB64mr") 1, false, false, false, 2220, 2,  1, 1, 13, 2}, // #782
  {DBGFIELD("ADD_F32m_ADD_F64m_SUBR_F32m_SUBR_F64m_SUB_F32m_SUB_F64m") 1, false, false, false, 269, 3, 10, 1,  0, 0}, // #783
  {DBGFIELD("PCMPGTQrm_VPCMPGTQrm") 1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #784
  {DBGFIELD("FICOM16m_FICOM32m_FICOMP16m_FICOMP32m") 1, false, false, false, 2238, 2, 10, 1,  0, 0}, // #785
  {DBGFIELD("MUL_F32m_MUL_F64m")  1, false, false, false, 2273, 2, 14, 1,  0, 0}, // #786
  {DBGFIELD("ADD_FI16m_ADD_FI32m_SUBR_FI16m_SUBR_FI32m_SUB_FI16m_SUB_FI32m") 1, false, false, false, 269, 3, 10, 1,  0, 0}, // #787
  {DBGFIELD("MUL_FI16m_MUL_FI32m") 1, false, false, false, 2273, 2, 14, 1,  0, 0}, // #788
  {DBGFIELD("DIVR_F32m_DIVR_F64m_DIV_F32m_DIV_F64m") 4, false, false, false, 2267, 3, 96, 1,  0, 0}, // #789
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m_DIV_FI16m_DIV_FI32m") 4, false, false, false, 2267, 3, 96, 1,  0, 0}, // #790
  {DBGFIELD("VZEROALL")           1, false, false, false,  4, 1,  4, 1,  0, 0}, // #791
  {DBGFIELD("VZEROUPPER")         1, false, false, false,  4, 1,  4, 1,  0, 0}, // #792
  {DBGFIELD("CLC")                1, false, false, false,  4, 1,  1, 1,  0, 0}, // #793
  {DBGFIELD("SUB32rr_SUB64rr_XOR32rr_XOR64rr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #794
  {DBGFIELD("XORPSrr_VXORPSrr_XORPDrr_VXORPDrr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #795
  {DBGFIELD("VXORPSYrr_VXORPDYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #796
  {DBGFIELD("PXORrr_VPXORrr")     1, false, false, false,  4, 1,  1, 1,  0, 0}, // #797
  {DBGFIELD("PSUBBrr_VPSUBBrr_PSUBDrr_VPSUBDrr_VPSUBQrr_PSUBWrr_VPSUBWrr_PCMPGTBrr_VPCMPGTBrr_PCMPGTDrr_VPCMPGTDrr_PCMPGTWrr_VPCMPGTWrr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #798
  {DBGFIELD("PSUBQrr")            1, false, false, false, 75, 1, 12, 1,  0, 0}, // #799
  {DBGFIELD("PCMPGTQrr_VPCMPGTQrr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #800
  {DBGFIELD("CMOV16rr_CMOV32rr_CMOV64rr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #801
  {DBGFIELD("CMOV16rm_CMOV32rm_CMOV64rm") 1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #802
  {DBGFIELD("SETCCr")             1, false, false, false,  4, 1,  1, 1,  0, 0}, // #803
  {DBGFIELD("SETCCm")             1, false, false, false, 75, 1, 12, 1,  0, 0}, // #804
  {DBGFIELD("MOVHPDrm_MOVHPSrm_MOVLPDrm_MOVLPSrm_VMOVHPDrm_VMOVHPSrm_VMOVLPDrm_VMOVLPSrm") 1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #805
  {DBGFIELD("RETI16_RETI32_RETI64") 1, false, false, false, 269, 3,  1, 1,  0, 0}, // #806
  {DBGFIELD("LRETI16_LRETI32_LRETI64") 1, false, false, false, 992, 1, 106, 1,  0, 0}, // #807
  {DBGFIELD("RDPMC")              1, false, false, false, 918, 1, 62, 1,  0, 0}, // #808
  {DBGFIELD("RDRAND16r_RDRAND32r_RDRAND64r") 1, false, false, false,  4, 1,  4, 1,  0, 0}, // #809
  {DBGFIELD("FBLDm")              1, false, false, false,  4, 1,  4, 1,  0, 0}, // #810
  {DBGFIELD("FFREE_FFREEP")       1, false, false, false,  4, 1,  1, 1,  0, 0}, // #811
  {DBGFIELD("FSAVEm")             1, false, false, false,  4, 1,  4, 1,  0, 0}, // #812
  {DBGFIELD("FRSTORm")            1, false, false, false,  4, 1,  4, 1,  0, 0}, // #813
  {DBGFIELD("FXTRACT")            1, false, false, false, 2297, 1, 42, 1,  0, 0}, // #814
  {DBGFIELD("VPBROADCASTDrm_VPBROADCASTQrm") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #815
  {DBGFIELD("VBROADCASTF128")     1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #816
  {DBGFIELD("VBROADCASTI128")     1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #817
  {DBGFIELD("VPBROADCASTDYrm_VPBROADCASTQYrm") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #818
  {DBGFIELD("FBSTPm")             1, false, false, false,  4, 1,  4, 1,  0, 0}, // #819
  {DBGFIELD("VMPTRSTm")           1, false, false, false,  4, 1,  4, 1,  0, 0}, // #820
  {DBGFIELD("ST_FP32m_ST_FP64m")  1, false, false, false, 75, 1, 12, 1,  0, 0}, // #821
  {DBGFIELD("VPSLLVQYrr_VPSRLVQYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #822
  {DBGFIELD("VPSLLVQrr_VPSRLVQrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #823
  {DBGFIELD("MMX_MOVQ2DQrr")      1, false, false, false,  4, 1,  1, 1,  0, 0}, // #824
  {DBGFIELD("JMP16r_JMP16r_NT_JMP32r_JMP32r_NT_JMP64r_JMP64r_NT_JMP64r_REX") 1, false, false, false,  3, 2,  1, 1,  0, 0}, // #825
  {DBGFIELD("FINCSTP")            1, false, false, false,  4, 1,  1, 1,  0, 0}, // #826
  {DBGFIELD("ANDN32rr_ANDN64rr")  1, false, false, false,  4, 1,  1, 1,  0, 0}, // #827
  {DBGFIELD("VPBLENDDYrri")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #828
  {DBGFIELD("VPBLENDDrri")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #829
  {DBGFIELD("SGDT64m_SIDT64m_SMSW16m_STRm_SYSCALL") 1, false, false, false,  4, 1,  4, 1,  0, 0}, // #830
  {DBGFIELD("VPSLLVQrm_VPSRLVQrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #831
  {DBGFIELD("VPSLLVQYrm_VPSRLVQYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #832
  {DBGFIELD("PDEP32rm_PDEP64rm_PEXT32rm_PEXT64rm") 1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #833
  {DBGFIELD("PMOVSXBDrm_PMOVZXBDrm_VPMOVSXBDrm_VPMOVZXBDrm_PMOVSXBQrm_PMOVZXBQrm_VPMOVSXBQrm_VPMOVZXBQrm_PMOVSXBWrm_PMOVZXBWrm_VPMOVSXBWrm_VPMOVZXBWrm_PMOVSXDQrm_PMOVZXDQrm_VPMOVSXDQrm_VPMOVZXDQrm_PMOVSXWDrm_PMOVZXWDrm_VPMOVSXWDrm_VPMOVZXWDrm_PMOVSXWQrm_PMOVZXWQrm_VPMOVSXWQrm_VPMOVZXWQrm") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #834
  {DBGFIELD("VPMOVSXBDYrm_VPMOVSXBQYrm_VPMOVSXWQYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #835
  {DBGFIELD("JMP16m_JMP16m_NT_JMP32m_JMP32m_NT_JMP64m_JMP64m_NT_JMP64m_REX") 1, false, false, false,  3, 2,  1, 1,  0, 0}, // #836
  {DBGFIELD("ANDN32rm_ANDN64rm")  1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #837
  {DBGFIELD("MOVBE16rm_MOVBE32rm_MOVBE64rm") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #838
  {DBGFIELD("VINSERTI128rm")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #839
  {DBGFIELD("VPBLENDDrmi")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #840
  {DBGFIELD("VPBLENDDYrmi")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #841
  {DBGFIELD("POP32r_POP64r")      1, false, false, false, 269, 3,  1, 1,  0, 0}, // #842
  {DBGFIELD("SFENCE")             1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #843
  {DBGFIELD("MOVBE32mr_MOVBE64mr") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #844
  {DBGFIELD("MOVBE16mr")          1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #845
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r_PUSH64i8") 1, false, false, false, 269, 3,  1, 1,  0, 0}, // #846
  {DBGFIELD("MFENCE")             1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #847
  {DBGFIELD("XGETBV")             1, false, false, false,  4, 1,  4, 1,  0, 0}, // #848
  {DBGFIELD("MMX_PACKSSDWrm_MMX_PACKSSWBrm_MMX_PACKUSWBrm") 1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #849
  {DBGFIELD("LRET64_RET32")       1, false, false, false, 992, 1, 106, 1,  0, 0}, // #850
  {DBGFIELD("ROL8r1_ROL16r1_ROL32r1_ROL64r1_ROR8r1_ROR16r1_ROR32r1_ROR64r1") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #851
  {DBGFIELD("PDEP32rr_PDEP64rr_PEXT32rr_PEXT64rr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #852
  {DBGFIELD("VPBROADCASTBrr_VPBROADCASTWrr") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #853
  {DBGFIELD("VPMOVSXBWYrm_VPMOVSXDQYrm_VPMOVSXWDYrm_VPMOVZXWDYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #854
  {DBGFIELD("MMX_PACKSSDWrr_MMX_PACKSSWBrr_MMX_PACKUSWBrr") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #855
  {DBGFIELD("CLDEMOTE")           1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #856
  {DBGFIELD("MMX_CVTPI2PDrm")     4, false, false, false, 2240, 3,  7, 1,  0, 0}, // #857
  {DBGFIELD("VPBROADCASTBYrm_VPBROADCASTBrm_VPBROADCASTWYrm_VPBROADCASTWrm") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #858
  {DBGFIELD("LAR16rr_LAR32rr_LAR64rr") 1, false, false, false,  4, 1,  4, 1,  0, 0}, // #859
  {DBGFIELD("LAR16rm_LAR32rm_LAR64rm_LSL16rm_LSL32rm_LSL64rm") 1, false, false, false,  4, 1,  4, 1,  0, 0}, // #860
  {DBGFIELD("MUL_FPrST0_MUL_FST0r_MUL_FrST0") 1, false, false, false, 2273, 2, 14, 1,  0, 0}, // #861
  {DBGFIELD("VPCMPGTQYrm")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #862
  {DBGFIELD("VCVTSI642SSrr_VCVTSI642SSrr_Int") 3, false, false, false, 2222, 3,  3, 1,  6, 1}, // #863
  {DBGFIELD("STR16r_STR32r_STR64r") 1, false, false, false,  4, 1,  4, 1,  0, 0}, // #864
  {DBGFIELD("XSETBV")             1, false, false, false,  4, 1,  4, 1,  0, 0}, // #865
  {DBGFIELD("RCL16mCL_RCL32mCL_RCL64mCL_RCL8mCL") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #866
  {DBGFIELD("RCL16rCL_RCL32rCL_RCL64rCL_RCR16rCL_RCR32rCL_RCR64rCL") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #867
  {DBGFIELD("RCL8rCL")            1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #868
  {DBGFIELD("RDTSC")              1, false, false, false, 2295, 1, 60, 1,  0, 0}, // #869
  {DBGFIELD("XRSTOR_XRSTOR64_XRSTORS_XRSTORS64") 1, false, false, false,  4, 1,  4, 1,  0, 0}, // #870
  {DBGFIELD("DIV_FPrST0_DIV_FST0r_DIV_FrST0") 3, false, false, false, 2267, 3, 96, 1,  0, 0}, // #871
  {DBGFIELD("DIVR_F32m_DIVR_F64m") 4, false, false, false, 2267, 3, 96, 1,  0, 0}, // #872
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m") 4, false, false, false, 2267, 3, 96, 1,  0, 0}, // #873
  {DBGFIELD("DIVR_FPrST0_DIVR_FST0r_DIVR_FrST0") 3, false, false, false, 2267, 3, 96, 1,  0, 0}, // #874
  {DBGFIELD("XSAVE64")            1, false, false, false,  4, 1,  4, 1,  0, 0}, // #875
  {DBGFIELD("XSAVE")              1, false, false, false,  4, 1,  4, 1,  0, 0}, // #876
  {DBGFIELD("XSAVEC_XSAVEC64_XSAVES_XSAVES64_XSAVEOPT_XSAVEOPT64") 1, false, false, false,  4, 1,  4, 1,  0, 0}, // #877
  {DBGFIELD("VMCLEARm")           1, false, false, false,  4, 1,  4, 1,  0, 0}, // #878
  {DBGFIELD("FLDENVm")            1, false, false, false,  4, 1,  4, 1,  0, 0}, // #879
  {DBGFIELD("FXRSTOR64")          1, false, false, false, 2313, 1, 113, 1,  0, 0}, // #880
  {DBGFIELD("FSTENVm")            1, false, false, false,  4, 1,  4, 1,  0, 0}, // #881
  {DBGFIELD("VGATHERDPDrm_VPGATHERDQrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #882
  {DBGFIELD("VGATHERDPDYrm_VPGATHERDQYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #883
  {DBGFIELD("VGATHERDPSrm_VPGATHERDDrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #884
  {DBGFIELD("VGATHERDPSYrm_VPGATHERDDYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #885
  {DBGFIELD("VGATHERQPDrm_VPGATHERQQrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #886
  {DBGFIELD("VGATHERQPDYrm_VPGATHERQQYrm_VGATHERQPSYrm_VPGATHERQDYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #887
  {DBGFIELD("VGATHERQPSrm_VPGATHERQDrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #888
  {DBGFIELD("VPXORYrr")           8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #889
  {DBGFIELD("VPSUBBYrr_VPSUBDYrr_VPSUBQYrr_VPSUBWYrr_VPCMPGTBYrr_VPCMPGTDYrr_VPCMPGTWYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #890
  {DBGFIELD("VPCMPGTQYrr")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #891
  {DBGFIELD("ADC16ri8_ADC32ri8_ADC64ri8_SBB16ri8_SBB32ri8_SBB64ri8") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #892
  {DBGFIELD("ADC8i8_SBB8i8_ADC16i16_SBB16i16_ADC32i32_SBB32i32_ADC64i32_SBB64i32") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #893
  {DBGFIELD("FCOM32m_FCOM64m_FCOMP32m_FCOMP64m") 1, false, false, false, 2238, 2, 10, 1,  0, 0}, // #894
  {DBGFIELD("LRET64")             1, false, false, false, 992, 1, 106, 1,  0, 0}, // #895
  {DBGFIELD("POPF64")             1, false, false, false, 1392, 1, 76, 1,  0, 0}, // #896
  {DBGFIELD("VGATHERQPDYrm_VPGATHERQQYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #897
  {DBGFIELD("PCMPEQQrr")          1, false, false, false,  4, 1,  1, 1,  0, 0}, // #898
  {DBGFIELD("PCMPGTQrr")          1, false, false, false,  4, 1,  1, 1,  0, 0}, // #899
  {DBGFIELD("PCMPEQQrm")          1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #900
  {DBGFIELD("PCMPGTQrm")          1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #901
  {DBGFIELD("MOV16rm")            1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #902
  {DBGFIELD("POP16rmm")           1, false, false, false, 214, 1,  5, 1,  0, 0}, // #903
  {DBGFIELD("PUSH16rmm_PUSH32rmm") 1, false, false, false, 75, 1, 12, 1,  0, 0}, // #904
  {DBGFIELD("PUSHF16")            1, false, false, false, 293, 1, 22, 1,  0, 0}, // #905
  {DBGFIELD("LAHF")               1, false, false, false, 75, 1, 12, 1,  0, 0}, // #906
  {DBGFIELD("ADD16mi_ADD16mi8_ADD32mi_ADD32mi8_ADD64mi32_ADD64mi8_ADD8mi_ADD8mi8_SUB16mi_SUB16mi8_SUB32mi_SUB32mi8_SUB64mi32_SUB64mi8_SUB8mi_SUB8mi8") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #907
  {DBGFIELD("ADD16mr_ADD32mr_ADD64mr_ADD8mr_SUB16mr_SUB32mr_SUB64mr_SUB8mr") 1, false, false, false, 2220, 2,  1, 1, 13, 1}, // #908
  {DBGFIELD("ADC16mi_ADC16mi8_ADC32mi_ADC32mi8_ADC64mi32_ADC64mi8_ADC8mi_ADC8mi8_SBB16mi_SBB16mi8_SBB32mi_SBB32mi8_SBB64mi32_SBB64mi8_SBB8mi_SBB8mi8") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #909
  {DBGFIELD("DEC16m_DEC32m_DEC64m_DEC8m_INC16m_INC32m_INC64m_INC8m_NEG16m_NEG32m_NEG64m_NEG8m_NOT16m_NOT32m_NOT64m_NOT8m") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #910
  {DBGFIELD("CALL16r_CALL16r_NT_CALL32r_CALL32r_NT") 1, false, false, false,  3, 2,  1, 1,  0, 0}, // #911
  {DBGFIELD("RET16_LRET16_LRET32") 1, false, false, false, 992, 1, 106, 1,  0, 0}, // #912
  {DBGFIELD("IRET16_IRET32_IRET64") 1, false, false, false, 269, 3,  1, 1,  0, 0}, // #913
  {DBGFIELD("AND16mi_AND16mi8_AND32mi_AND32mi8_AND64mi32_AND64mi8_AND8mi_AND8mi8_OR16mi_OR16mi8_OR32mi_OR32mi8_OR32mi8Locked_OR64mi32_OR64mi8_OR8mi_OR8mi8_XOR16mi_XOR16mi8_XOR32mi_XOR32mi8_XOR64mi32_XOR64mi8_XOR8mi_XOR8mi8") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #914
  {DBGFIELD("AND16mr_AND32mr_AND64mr_AND8mr_OR16mr_OR32mr_OR64mr_OR8mr_XOR16mr_XOR32mr_XOR64mr_XOR8mr") 1, false, false, false, 2220, 2,  1, 1, 13, 1}, // #915
  {DBGFIELD("SHLD32mri8_SHRD32mri8") 1, false, false, false, 1159, 1, 14, 1,  0, 0}, // #916
  {DBGFIELD("SHLD32rrCL_SHRD32rrCL") 1, false, false, false, 75, 1, 12, 1,  0, 0}, // #917
  {DBGFIELD("SHLD32mrCL_SHRD32mrCL") 1, false, false, false, 1159, 1, 14, 1,  0, 0}, // #918
  {DBGFIELD("XADD16rr_XADD32rr_XADD64rr_XADD8rr") 1, false, false, false, 75, 1, 12, 1,  0, 0}, // #919
  {DBGFIELD("CHS_F_CHS_Fp32_CHS_Fp64_CHS_Fp80") 1, false, false, false,  3, 2,  1, 1,  0, 0}, // #920
  {DBGFIELD("MMX_MASKMOVQ_MMX_MASKMOVQ64") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #921
  {DBGFIELD("MASKMOVDQU_MASKMOVDQU64") 1, false, false, false, 75, 1, 12, 1,  0, 0}, // #922
  {DBGFIELD("VMASKMOVDQU_VMASKMOVDQU64") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #923
  {DBGFIELD("VPMASKMOVDYrm")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #924
  {DBGFIELD("VPMASKMOVDrm")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #925
  {DBGFIELD("VPMASKMOVDYmr")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #926
  {DBGFIELD("VPMASKMOVDmr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #927
  {DBGFIELD("VPMASKMOVQYmr")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #928
  {DBGFIELD("VPMASKMOVQmr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #929
  {DBGFIELD("VPBROADCASTBrm_VPBROADCASTWrm") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #930
  {DBGFIELD("VPGATHERDDYrm")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #931
  {DBGFIELD("VPGATHERDDrm")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #932
  {DBGFIELD("VPGATHERDQYrm")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #933
  {DBGFIELD("VPGATHERDQrm")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #934
  {DBGFIELD("VPGATHERQDYrm")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #935
  {DBGFIELD("VPGATHERQDrm")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #936
  {DBGFIELD("VPGATHERQQYrm")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #937
  {DBGFIELD("VPGATHERQQrm")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #938
  {DBGFIELD("VPERM2F128rr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #939
  {DBGFIELD("VPERM2I128rr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #940
  {DBGFIELD("VPERM2F128rm")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #941
  {DBGFIELD("VPERM2I128rm")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #942
  {DBGFIELD("VEXTRACTF128rr")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #943
  {DBGFIELD("VEXTRACTI128rr")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #944
  {DBGFIELD("VEXTRACTF128mr")     1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #945
  {DBGFIELD("VEXTRACTI128mr")     1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #946
  {DBGFIELD("VINSERTF128rr")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #947
  {DBGFIELD("VINSERTI128rr")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #948
  {DBGFIELD("CVTDQ2PDrr_VCVTDQ2PDrr") 3, false, false, false, 2222, 3,  6, 1,  0, 0}, // #949
  {DBGFIELD("VCVTDQ2PDYrr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #950
  {DBGFIELD("CVTPD2DQrr_CVTTPD2DQrr_VCVTPD2DQrr_VCVTTPD2DQrr") 4, false, false, false, 2240, 3,  6, 1,  0, 0}, // #951
  {DBGFIELD("CVTPD2DQrm_CVTTPD2DQrm_VCVTPD2DQrm_VCVTTPD2DQrm") 5, false, false, false, 2243, 3,  7, 1,  0, 0}, // #952
  {DBGFIELD("VCVTPD2DQYrr_VCVTTPD2DQYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #953
  {DBGFIELD("VCVTPD2DQYrm_VCVTTPD2DQYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #954
  {DBGFIELD("MMX_CVTPI2PDrr")     3, false, false, false, 2222, 3,  6, 1,  0, 0}, // #955
  {DBGFIELD("MMX_CVTPD2PIrr_MMX_CVTTPD2PIrr") 4, false, false, false, 2240, 3,  6, 1,  0, 0}, // #956
  {DBGFIELD("CVTSS2SIrr_CVTTSS2SIrr_VCVTSS2SI64rr_VCVTSS2SIrr_VCVTTSS2SI64rr_VCVTTSS2SIrr") 3, false, false, false, 2243, 3,  7, 1,  0, 0}, // #957
  {DBGFIELD("CVTSS2SIrr_Int_CVTTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int_VCVTTSS2SI64rr_Int_VCVTTSS2SIrr_Int") 3, false, false, false, 2243, 3,  7, 1,  0, 0}, // #958
  {DBGFIELD("CVTSS2SIrm_CVTSS2SIrm_Int_CVTTSS2SIrm_CVTTSS2SIrm_Int_VCVTSS2SI64rm_VCVTSS2SI64rm_Int_VCVTSS2SIrm_VCVTSS2SIrm_Int_VCVTTSS2SI64rm_VCVTTSS2SI64rm_Int_VCVTTSS2SIrm_VCVTTSS2SIrm_Int") 4, false, false, false, 2235, 3, 22, 1,  0, 0}, // #959
  {DBGFIELD("CVTSI2SDrr_CVTSI642SDrr") 3, false, false, false, 2222, 3,  3, 1,  0, 1}, // #960
  {DBGFIELD("CVTSI2SDrr_Int_CVTSI642SDrr_Int_VCVTSI2SDrr_VCVTSI2SDrr_Int_VCVTSI642SDrr_VCVTSI642SDrr_Int") 3, false, false, false, 2222, 3,  3, 1,  6, 1}, // #961
  {DBGFIELD("CVTSD2SI64rr_CVTSD2SIrr_CVTTSD2SI64rr_CVTTSD2SIrr_VCVTSD2SI64rr_VCVTSD2SIrr_VCVTTSD2SI64rr_VCVTTSD2SIrr") 3, false, false, false, 2243, 3,  7, 1,  0, 0}, // #962
  {DBGFIELD("CVTSD2SI64rr_Int_CVTSD2SIrr_Int_CVTTSD2SI64rr_Int_CVTTSD2SIrr_Int_VCVTSD2SI64rr_Int_VCVTSD2SIrr_Int") 3, false, false, false, 2243, 3,  7, 1,  0, 0}, // #963
  {DBGFIELD("VCVTTSD2SI64rr_Int_VCVTTSD2SIrr_Int") 3, false, false, false, 2243, 3,  7, 1,  0, 0}, // #964
  {DBGFIELD("CVTSD2SI64rm_CVTSD2SI64rm_Int_CVTSD2SIrm_CVTSD2SIrm_Int_CVTTSD2SI64rm_CVTTSD2SI64rm_Int_CVTTSD2SIrm_CVTTSD2SIrm_Int_VCVTSD2SI64rm_VCVTSD2SI64rm_Int_VCVTSD2SIrm_VCVTSD2SIrm_Int_VCVTTSD2SI64rm_VCVTTSD2SIrm") 4, false, false, false, 2232, 3, 22, 1,  0, 0}, // #965
  {DBGFIELD("VCVTTSD2SI64rm_Int_VCVTTSD2SIrm_Int") 4, false, false, false, 2235, 3, 22, 1,  0, 0}, // #966
  {DBGFIELD("EXTRQ_EXTRQI")       1, false, false, false,  4, 1,  1, 1,  0, 0}, // #967
  {DBGFIELD("INSERTQ_INSERTQI")   1, false, false, false,  4, 1,  1, 1,  0, 0}, // #968
  {DBGFIELD("SHA256MSG2rm")       1, false, false, false, 2273, 2, 10, 1, 15, 1}, // #969
  {DBGFIELD("SHA256MSG2rr")       1, false, false, false, 2273, 2, 10, 1,  0, 0}, // #970
  {DBGFIELD("SHA1MSG1rr_SHA256MSG1rr") 1, false, false, false, 2273, 2, 10, 1,  0, 0}, // #971
  {DBGFIELD("SHA1MSG1rm_SHA256MSG1rm") 1, false, false, false, 2273, 2, 10, 1, 15, 1}, // #972
  {DBGFIELD("SHA1MSG2rr")         1, false, false, false, 2273, 2, 10, 1,  0, 0}, // #973
  {DBGFIELD("SHA1MSG2rm")         1, false, false, false, 2273, 2, 10, 1, 15, 1}, // #974
  {DBGFIELD("SHA1NEXTErr")        1, false, false, false, 2273, 2, 10, 1,  0, 0}, // #975
  {DBGFIELD("SHA1NEXTErm")        1, false, false, false, 2273, 2, 10, 1, 15, 1}, // #976
  {DBGFIELD("SHA1RNDS4rri")       1, false, false, false, 2273, 2, 10, 1,  0, 0}, // #977
  {DBGFIELD("SHA1RNDS4rmi")       1, false, false, false, 2273, 2, 10, 1, 15, 1}, // #978
  {DBGFIELD("SHA256RNDS2rr")      1, false, false, false, 2273, 2, 10, 1,  0, 0}, // #979
  {DBGFIELD("SHA256RNDS2rm")      1, false, false, false, 2273, 2, 10, 1, 15, 1}, // #980
  {DBGFIELD("XCHG16rr_XCHG32rr_XCHG64rr_XCHG8rr_XCHG16ar_XCHG32ar_XCHG64ar") 1, false, false, false, 75, 1, 12, 1,  0, 0}, // #981
  {DBGFIELD("CVTDQ2PSrr_VCVTDQ2PSrr") 3, false, false, false, 2222, 3,  3, 1,  0, 0}, // #982
  {DBGFIELD("VCVTDQ2PSYrr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #983
  {DBGFIELD("CVTPS2DQrr_CVTTPS2DQrr_VCVTPS2DQrr_VCVTTPS2DQrr") 3, false, false, false, 2222, 3,  3, 1,  0, 0}, // #984
  {DBGFIELD("MOV8rm_MOV8rm_NOREX_MOVSX16rm16_MOVSX16rm32_MOVZX16rm16") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #985
  {DBGFIELD("MOVBE16rm")          1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #986
  {DBGFIELD("ADD8i8_ADD16i16_ADD32i32_ADD64i32_AND8i8_AND16i16_AND32i32_AND64i32_OR8i8_OR16i16_OR32i32_OR64i32_SUB8i8_SUB16i16_SUB32i32_SUB64i32_XOR8i8_XOR16i16_XOR32i32_XOR64i32") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #987
  {DBGFIELD("MOVSX16rr16_MOVSX16rr32_MOVZX16rr16") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #988
  {DBGFIELD("MOV32ri_MOV32ri_alt_MOV64ri32") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #989
  {DBGFIELD("ADC8mr_SBB8mr")      1, false, false, false, 2220, 2,  1, 1, 13, 2}, // #990
  {DBGFIELD("LEA32r_LEA64r_LEA64_32r") 1, false, false, false,  3, 2,  1, 1,  0, 0}, // #991
  {DBGFIELD("LEA16r")             1, false, false, false,  3, 2,  1, 1,  0, 0}, // #992
  {DBGFIELD("LCMPXCHG8")          1, false, false, false, 2218, 2,  1, 1,  0, 0}, // #993
  {DBGFIELD("LCMPXCHG16B")        1, false, false, false, 2218, 2,  1, 1,  0, 0}, // #994
  {DBGFIELD("XCHG8rr_XCHG16rr_XCHG16ar") 1, false, false, false, 75, 1, 12, 1,  0, 0}, // #995
  {DBGFIELD("XCHG8rm_XCHG16rm")   1, false, false, false, 214, 1,  5, 1,  0, 0}, // #996
  {DBGFIELD("POPCNT16rr")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #997
  {DBGFIELD("LZCNT16rr")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #998
  {DBGFIELD("TZCNT16rr")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #999
  {DBGFIELD("RCL8m1_RCL16m1_RCL32m1_RCL64m1_RCR8m1_RCR16m1_RCR32m1_RCR64m1") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1000
  {DBGFIELD("RCR8mi_RCR16mi_RCR32mi_RCR64mi") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1001
  {DBGFIELD("RCR16rCL_RCR32rCL_RCR64rCL") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1002
  {DBGFIELD("MOVHPDmr_MOVHPSmr_VMOVHPDmr_VMOVHPSmr") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1003
  {DBGFIELD("MMX_MOVQ2FR64rr")    1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1004
  {DBGFIELD("MMX_MOVD64rr_MMX_MOVD64to64rr") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1005
  {DBGFIELD("EXTRQ")              1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1006
  {DBGFIELD("INSERTQ")            1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1007
  {DBGFIELD("PABSBrr_PABSDrr_PABSWrr_PADDSBrr_PADDSWrr_PADDUSBrr_PADDUSWrr_PAVGBrr_PAVGWrr_PSIGNBrr_PSIGNDrr_PSIGNWrr_VPABSBrr_VPABSDrr_VPABSWrr_VPADDSBrr_VPADDSWrr_VPADDUSBrr_VPADDUSWrr_VPAVGBrr_VPAVGWrr_VPCMPEQQrr_VPSIGNBrr_VPSIGNDrr_VPSIGNWrr_PSUBSBrr_PSUBSWrr_PSUBUSBrr_PSUBUSWrr_VPSUBSBrr_VPSUBSWrr_VPSUBUSBrr_VPSUBUSWrr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1008
  {DBGFIELD("MMX_PADDSBrr_MMX_PADDSWrr_MMX_PADDUSBrr_MMX_PADDUSWrr_MMX_PAVGBrr_MMX_PAVGWrr_MMX_PSUBSBrr_MMX_PSUBSWrr_MMX_PSUBUSBrr_MMX_PSUBUSWrr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1009
  {DBGFIELD("VPABSBYrr_VPABSDYrr_VPABSWYrr_VPADDSBYrr_VPADDSWYrr_VPADDUSBYrr_VPADDUSWYrr_VPSUBSBYrr_VPSUBSWYrr_VPSUBUSBYrr_VPSUBUSWYrr_VPAVGBYrr_VPAVGWYrr_VPCMPEQQYrr_VPSIGNBYrr_VPSIGNDYrr_VPSIGNWYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1010
  {DBGFIELD("MMX_CVTPD2PIrm_MMX_CVTTPD2PIrm") 5, false, false, false, 2243, 3,  7, 1,  0, 0}, // #1011
  {DBGFIELD("SHA1MSG1rr")         1, false, false, false, 2273, 2, 10, 1,  0, 0}, // #1012
  {DBGFIELD("SHA1MSG1rm")         1, false, false, false, 2273, 2, 10, 1, 15, 1}, // #1013
  {DBGFIELD("VPERMPSYrm")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1014
  {DBGFIELD("VPERMPDYri")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1015
  {DBGFIELD("VPERMQYri")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1016
  {DBGFIELD("VPERMPDYmi")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1017
  {DBGFIELD("VPERMQYmi")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1018
  {DBGFIELD("VPERMDYrm")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1019
  {DBGFIELD("MOV32rr_MOV32rr_REV_MOV64rr_MOV64rr_REV") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1020
  {DBGFIELD("MOVSX32rr32")        1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1021
  {DBGFIELD("XOR32rr_REV_XOR64rr_REV_SUB32rr_REV_SUB64rr_REV") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1022
  {DBGFIELD("CMP8rr_CMP8rr_REV_CMP16rr_CMP16rr_REV_CMP32rr_CMP32rr_REV_CMP64rr_CMP64rr_REV") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1023
  {DBGFIELD("VXORPSrr_VXORPDrr")  1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1024
  {DBGFIELD("VANDNPSrr_VANDNPDrr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1025
  {DBGFIELD("VANDNPSYrr_VANDNPDYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1026
  {DBGFIELD("VPXORrr")            1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1027
  {DBGFIELD("VPANDNrr")           1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1028
  {DBGFIELD("VPANDNYrr")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1029
  {DBGFIELD("VPSUBBrr_VPSUBWrr_VPSUBDrr_VPSUBQrr_VPCMPGTBrr_VPCMPGTWrr_VPCMPGTDrr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1030
  {DBGFIELD("KADDBrr_KADDDrr_KADDQrr_KADDWrr_KANDBrr_KANDDrr_KANDQrr_KANDWrr_KANDNBrr_KANDNDrr_KANDNQrr_KANDNWrr_KNOTBrr_KNOTDrr_KNOTQrr_KNOTWrr_KORBrr_KORDrr_KORQrr_KORWrr_KORTESTBrr_KORTESTDrr_KORTESTQrr_KORTESTWrr_KTESTBrr_KTESTDrr_KTESTQrr_KTESTWrr_KXNORBrr_KXNORDrr_KXNORQrr_KXNORWrr_KXORBrr_KXORDrr_KXORQrr_KXORWrr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1031
  {DBGFIELD("KMOVBkk_KMOVDkk_KMOVQkk_KMOVWkk_KMOVBrk_KMOVDrk_KMOVQrk_KMOVWrk") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1032
  {DBGFIELD("KUNPCKBWrr_KUNPCKDQrr_KUNPCKWDrr") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1033
  {DBGFIELD("KMOVBmk_KMOVDmk_KMOVQmk_KMOVWmk") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1034
  {DBGFIELD("KMOVBkr_KMOVDkr_KMOVQkr_KMOVWkr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1035
  {DBGFIELD("VALIGNDZrri_VALIGNQZrri") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1036
  {DBGFIELD("VALIGNDZ128rri_VALIGNQZ128rri") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1037
  {DBGFIELD("VALIGNDZ256rri_VALIGNQZ256rri") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1038
  {DBGFIELD("VPERMPSYrr")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1039
  {DBGFIELD("VPERMDYrr")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1040
  {DBGFIELD("VFIXUPIMMPDZ128rrik_VFIXUPIMMPDZ128rrikz_VFIXUPIMMPSZ128rrik_VFIXUPIMMPSZ128rrikz_VFIXUPIMMPDZ128rri_VFIXUPIMMPSZ128rri_VRANGEPDZ128rri_VRANGEPDZ128rrik_VRANGEPDZ128rrikz_VRANGEPSZ128rri_VRANGEPSZ128rrik_VRANGEPSZ128rrikz_VRANGESDZrri_VRANGESDZrrib_VRANGESDZrribk_VRANGESDZrribkz_VRANGESDZrrik_VRANGESDZrrikz_VRANGESSZrri_VRANGESSZrrib_VRANGESSZrribk_VRANGESSZrribkz_VRANGESSZrrik_VRANGESSZrrikz") 1, false, false, false,  3, 2, 10, 1,  0, 0}, // #1041
  {DBGFIELD("VFIXUPIMMPDZ256rrik_VFIXUPIMMPDZ256rrikz_VFIXUPIMMPSZ256rrik_VFIXUPIMMPSZ256rrikz_VFIXUPIMMPDZ256rri_VFIXUPIMMPSZ256rri_VRANGEPDZ256rri_VRANGEPDZ256rrik_VRANGEPDZ256rrikz_VRANGEPSZ256rri_VRANGEPSZ256rrik_VRANGEPSZ256rrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1042
  {DBGFIELD("VFIXUPIMMPDZrrik_VFIXUPIMMPDZrrikz_VFIXUPIMMPSZrrik_VFIXUPIMMPSZrrikz_VRANGEPDZrri_VRANGEPDZrrib_VRANGEPDZrribk_VRANGEPDZrribkz_VRANGEPDZrrik_VRANGEPDZrrikz_VRANGEPSZrri_VRANGEPSZrrib_VRANGEPSZrribk_VRANGEPSZrribkz_VRANGEPSZrrik_VRANGEPSZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1043
  {DBGFIELD("VFIXUPIMMSDZrrik_VFIXUPIMMSDZrrikz_VFIXUPIMMSSZrrik_VFIXUPIMMSSZrrikz") 1, false, false, false,  3, 2, 10, 1,  0, 0}, // #1044
  {DBGFIELD("VSCALEFSDZrrb_Int_VSCALEFSDZrrb_Intk_VSCALEFSDZrrb_Intkz_VSCALEFSSZrrb_Int_VSCALEFSSZrrb_Intk_VSCALEFSSZrrb_Intkz") 1, false, false, false,  3, 2, 10, 1,  0, 0}, // #1045
  {DBGFIELD("VREDUCEPDZ128rri_VREDUCEPDZ128rrik_VREDUCEPDZ128rrikz_VREDUCEPSZ128rri_VREDUCEPSZ128rrik_VREDUCEPSZ128rrikz_VREDUCESDZrri_VREDUCESDZrrib_VREDUCESDZrribk_VREDUCESDZrribkz_VREDUCESDZrrik_VREDUCESDZrrikz_VREDUCESSZrri_VREDUCESSZrrib_VREDUCESSZrribk_VREDUCESSZrribkz_VREDUCESSZrrik_VREDUCESSZrrikz") 1, false, false, false, 2238, 2, 10, 1,  0, 0}, // #1046
  {DBGFIELD("VREDUCEPDZrri_VREDUCEPDZrrib_VREDUCEPDZrribk_VREDUCEPDZrribkz_VREDUCEPDZrrik_VREDUCEPDZrrikz_VREDUCEPSZrri_VREDUCEPSZrrib_VREDUCEPSZrribk_VREDUCEPSZrribkz_VREDUCEPSZrrik_VREDUCEPSZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1047
  {DBGFIELD("VDPBF16PSZ128r_VDPBF16PSZ128rk_VDPBF16PSZ128rkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1048
  {DBGFIELD("VDPBF16PSZ256r_VDPBF16PSZ256rk_VDPBF16PSZ256rkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1049
  {DBGFIELD("VDPBF16PSZr_VDPBF16PSZrk_VDPBF16PSZrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1050
  {DBGFIELD("VPDPBUSDSZ128r_VPDPBUSDSZ128rk_VPDPBUSDSZ128rkz_VPDPBUSDZ128r_VPDPBUSDZ128rk_VPDPBUSDZ128rkz_VPDPWSSDSZ128r_VPDPWSSDSZ128rk_VPDPWSSDSZ128rkz_VPDPWSSDZ128r_VPDPWSSDZ128rk_VPDPWSSDZ128rkz_VPMADD52HUQZ128r_VPMADD52HUQZ128rk_VPMADD52HUQZ128rkz_VPMADD52LUQZ128r_VPMADD52LUQZ128rk_VPMADD52LUQZ128rkz") 1, false, false, false, 2273, 2, 10, 1,  0, 0}, // #1051
  {DBGFIELD("VPDPBUSDSZ256r_VPDPBUSDSZ256rk_VPDPBUSDSZ256rkz_VPDPBUSDZ256r_VPDPBUSDZ256rk_VPDPBUSDZ256rkz_VPDPWSSDSZ256r_VPDPWSSDSZ256rk_VPDPWSSDSZ256rkz_VPDPWSSDZ256r_VPDPWSSDZ256rk_VPDPWSSDZ256rkz_VPMADD52HUQZ256r_VPMADD52HUQZ256rk_VPMADD52HUQZ256rkz_VPMADD52LUQZ256r_VPMADD52LUQZ256rk_VPMADD52LUQZ256rkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1052
  {DBGFIELD("VPDPBUSDSZr_VPDPBUSDSZrk_VPDPBUSDSZrkz_VPDPBUSDZr_VPDPBUSDZrk_VPDPBUSDZrkz_VPDPWSSDSZr_VPDPWSSDSZrk_VPDPWSSDSZrkz_VPDPWSSDZr_VPDPWSSDZrk_VPDPWSSDZrkz_VPMADD52HUQZr_VPMADD52HUQZrk_VPMADD52HUQZrkz_VPMADD52LUQZr_VPMADD52LUQZrk_VPMADD52LUQZrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1053
  {DBGFIELD("VPLZCNTDZ128rr_VPLZCNTDZ128rrk_VPLZCNTDZ128rrkz_VPLZCNTQZ128rr_VPLZCNTQZ128rrk_VPLZCNTQZ128rrkz_VPSHLDDZ128rri_VPSHLDDZ128rrik_VPSHLDDZ128rrikz_VPSHLDQZ128rri_VPSHLDQZ128rrik_VPSHLDQZ128rrikz_VPSHLDVDZ128rk_VPSHLDVDZ128rkz_VPSHLDVQZ128rk_VPSHLDVQZ128rkz_VPSHLDVWZ128rk_VPSHLDVWZ128rkz_VPSHLDWZ128rri_VPSHLDWZ128rrik_VPSHLDWZ128rrikz_VPSHRDDZ128rri_VPSHRDDZ128rrik_VPSHRDDZ128rrikz_VPSHRDQZ128rri_VPSHRDQZ128rrik_VPSHRDQZ128rrikz_VPSHRDVDZ128rk_VPSHRDVDZ128rkz_VPSHRDVQZ128rk_VPSHRDVQZ128rkz_VPSHRDVWZ128rk_VPSHRDVWZ128rkz_VPSHRDWZ128rri_VPSHRDWZ128rrik_VPSHRDWZ128rrikz_VPSHUFBITQMBZ128rr_VPSHUFBITQMBZ128rrk") 1, false, false, false, 2273, 2, 10, 1,  0, 0}, // #1054
  {DBGFIELD("VPLZCNTDZ256rr_VPLZCNTDZ256rrk_VPLZCNTDZ256rrkz_VPLZCNTQZ256rr_VPLZCNTQZ256rrk_VPLZCNTQZ256rrkz_VPSHLDDZ256rri_VPSHLDDZ256rrik_VPSHLDDZ256rrikz_VPSHLDQZ256rri_VPSHLDQZ256rrik_VPSHLDQZ256rrikz_VPSHLDVDZ256rk_VPSHLDVDZ256rkz_VPSHLDVQZ256rk_VPSHLDVQZ256rkz_VPSHLDVWZ256rk_VPSHLDVWZ256rkz_VPSHLDWZ256rri_VPSHLDWZ256rrik_VPSHLDWZ256rrikz_VPSHRDDZ256rri_VPSHRDDZ256rrik_VPSHRDDZ256rrikz_VPSHRDQZ256rri_VPSHRDQZ256rrik_VPSHRDQZ256rrikz_VPSHRDVDZ256rk_VPSHRDVDZ256rkz_VPSHRDVQZ256rk_VPSHRDVQZ256rkz_VPSHRDVWZ256rk_VPSHRDVWZ256rkz_VPSHRDWZ256rri_VPSHRDWZ256rrik_VPSHRDWZ256rrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1055
  {DBGFIELD("VPLZCNTDZrr_VPLZCNTDZrrk_VPLZCNTDZrrkz_VPLZCNTQZrr_VPLZCNTQZrrk_VPLZCNTQZrrkz_VPSHLDDZrri_VPSHLDDZrrik_VPSHLDDZrrikz_VPSHLDQZrri_VPSHLDQZrrik_VPSHLDQZrrikz_VPSHLDVDZrk_VPSHLDVDZrkz_VPSHLDVQZrk_VPSHLDVQZrkz_VPSHLDVWZrk_VPSHLDVWZrkz_VPSHLDWZrri_VPSHLDWZrrik_VPSHLDWZrrikz_VPSHRDDZrri_VPSHRDDZrrik_VPSHRDDZrrikz_VPSHRDQZrri_VPSHRDQZrrik_VPSHRDQZrrikz_VPSHRDVDZrk_VPSHRDVDZrkz_VPSHRDVQZrk_VPSHRDVQZrkz_VPSHRDVWZrk_VPSHRDVWZrkz_VPSHRDWZrri_VPSHRDWZrrik_VPSHRDWZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1056
  {DBGFIELD("PSLLDrr_PSLLQrr_PSLLWrr_PSRADrr_PSRAWrr_PSRLDrr_PSRLQrr_PSRLWrr_VPSLLDZ128rr_VPSLLDZ128rrk_VPSLLDZ128rrkz_VPSLLDrr_VPSLLQZ128rr_VPSLLQZ128rrk_VPSLLQZ128rrkz_VPSLLQrr_VPSLLWZ128rr_VPSLLWZ128rrk_VPSLLWZ128rrkz_VPSLLWrr_VPSRADZ128rr_VPSRADZ128rrk_VPSRADZ128rrkz_VPSRADrr_VPSRAQZ128rr_VPSRAQZ128rrk_VPSRAQZ128rrkz_VPSRAWZ128rr_VPSRAWZ128rrk_VPSRAWZ128rrkz_VPSRAWrr_VPSRLDZ128rr_VPSRLDZ128rrk_VPSRLDZ128rrkz_VPSRLDrr_VPSRLQZ128rr_VPSRLQZ128rrk_VPSRLQZ128rrkz_VPSRLQrr_VPSRLWZ128rr_VPSRLWZ128rrk_VPSRLWZ128rrkz_VPSRLWrr") 2, false, false, false, 269, 3, 12, 1,  0, 0}, // #1057
  {DBGFIELD("VPSLLDYrr_VPSLLDZ256rr_VPSLLDZ256rrk_VPSLLDZ256rrkz_VPSLLQYrr_VPSLLQZ256rr_VPSLLQZ256rrk_VPSLLQZ256rrkz_VPSLLWYrr_VPSLLWZ256rr_VPSLLWZ256rrk_VPSLLWZ256rrkz_VPSRADYrr_VPSRADZ256rr_VPSRADZ256rrk_VPSRADZ256rrkz_VPSRAQZ256rr_VPSRAQZ256rrk_VPSRAQZ256rrkz_VPSRAWYrr_VPSRAWZ256rr_VPSRAWZ256rrk_VPSRAWZ256rrkz_VPSRLDYrr_VPSRLDZ256rr_VPSRLDZ256rrk_VPSRLDZ256rrkz_VPSRLQYrr_VPSRLQZ256rr_VPSRLQZ256rrk_VPSRLQZ256rrkz_VPSRLWYrr_VPSRLWZ256rr_VPSRLWZ256rrk_VPSRLWZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1058
  {DBGFIELD("VPSLLDZrr_VPSLLDZrrk_VPSLLDZrrkz_VPSLLQZrr_VPSLLQZrrk_VPSLLQZrrkz_VPSLLWZrr_VPSLLWZrrk_VPSLLWZrrkz_VPSRADZrr_VPSRADZrrk_VPSRADZrrkz_VPSRAQZrr_VPSRAQZrrk_VPSRAQZrrkz_VPSRAWZrr_VPSRAWZrrk_VPSRAWZrrkz_VPSRLDZrr_VPSRLDZrrk_VPSRLDZrrkz_VPSRLQZrr_VPSRLQZrrk_VPSRLQZrrkz_VPSRLWZrr_VPSRLWZrrk_VPSRLWZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1059
  {DBGFIELD("VPSLLDQYri_VPSRLDQYri_VPSLLDQZ256ri_VPSRLDQZ256ri") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1060
  {DBGFIELD("PSLLDQri_PSRLDQri_VPSLLDQri_VPSRLDQri") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1061
  {DBGFIELD("VPSLLDQZri_VPSRLDQZri") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1062
  {DBGFIELD("VPSHUFBYrr_VPSHUFBZ256rr_VPSHUFBZ256rrk_VPSHUFBZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1063
  {DBGFIELD("VPSHUFBZ128rr_VPSHUFBZ128rrk_VPSHUFBZ128rrkz") 4, false, false, false, 2283, 3, 14, 1,  0, 0}, // #1064
  {DBGFIELD("VPSHUFBZrr_VPSHUFBZrrk_VPSHUFBZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1065
  {DBGFIELD("VPROLVDZ128rr_VPROLVDZ128rrk_VPROLVDZ128rrkz_VPROLVQZ128rr_VPROLVQZ128rrk_VPROLVQZ128rrkz_VPRORVDZ128rr_VPRORVDZ128rrk_VPRORVDZ128rrkz_VPRORVQZ128rr_VPRORVQZ128rrk_VPRORVQZ128rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1066
  {DBGFIELD("VPROLVDZ256rr_VPROLVDZ256rrk_VPROLVDZ256rrkz_VPROLVQZ256rr_VPROLVQZ256rrk_VPROLVQZ256rrkz_VPRORVDZ256rr_VPRORVDZ256rrk_VPRORVDZ256rrkz_VPRORVQZ256rr_VPRORVQZ256rrk_VPRORVQZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1067
  {DBGFIELD("VPROLVDZrr_VPROLVDZrrk_VPROLVDZrrkz_VPROLVQZrr_VPROLVQZrrk_VPROLVQZrrkz_VPRORVDZrr_VPRORVDZrrk_VPRORVDZrrkz_VPRORVQZrr_VPRORVQZrrk_VPRORVQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1068
  {DBGFIELD("VPROLDZ256ri_VPROLDZ256rik_VPROLDZ256rikz_VPROLQZ256ri_VPROLQZ256rik_VPROLQZ256rikz_VPRORDZ256ri_VPRORDZ256rik_VPRORDZ256rikz_VPRORQZ256ri_VPRORQZ256rik_VPRORQZ256rikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1069
  {DBGFIELD("VPROLDZ128ri_VPROLDZ128rik_VPROLDZ128rikz_VPROLQZ128ri_VPROLQZ128rik_VPROLQZ128rikz_VPRORDZ128ri_VPRORDZ128rik_VPRORDZ128rikz_VPRORQZ128ri_VPRORQZ128rik_VPRORQZ128rikz") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1070
  {DBGFIELD("VPROLDZri_VPROLDZrik_VPROLDZrikz_VPROLQZri_VPROLQZrik_VPROLQZrikz_VPRORDZri_VPRORDZrik_VPRORDZrikz_VPRORQZri_VPRORQZrik_VPRORQZrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1071
  {DBGFIELD("VFMSUB231SSZr_Intkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1072
  {DBGFIELD("VPSLLDZ128ri_VPSLLDZ128rik_VPSLLDZ128rikz_VPSLLQZ128ri_VPSLLQZ128rik_VPSLLQZ128rikz_VPSLLWZ128ri_VPSLLWZ128rik_VPSLLWZ128rikz_VPSRADZ128ri_VPSRADZ128rik_VPSRADZ128rikz_VPSRAQZ128ri_VPSRAQZ128rik_VPSRAQZ128rikz_VPSRAWZ128ri_VPSRAWZ128rik_VPSRAWZ128rikz_VPSRLDZ128ri_VPSRLDZ128rik_VPSRLDZ128rikz_VPSRLQZ128ri_VPSRLQZ128rik_VPSRLQZ128rikz_VPSRLWZ128ri_VPSRLWZ128rik_VPSRLWZ128rikz") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1073
  {DBGFIELD("VPSLLDZ256ri_VPSLLDZ256rik_VPSLLDZ256rikz_VPSLLQZ256ri_VPSLLQZ256rik_VPSLLQZ256rikz_VPSLLWZ256ri_VPSLLWZ256rik_VPSLLWZ256rikz_VPSRADZ256ri_VPSRADZ256rik_VPSRADZ256rikz_VPSRAQZ256ri_VPSRAQZ256rik_VPSRAQZ256rikz_VPSRAWZ256ri_VPSRAWZ256rik_VPSRAWZ256rikz_VPSRLDZ256ri_VPSRLDZ256rik_VPSRLDZ256rikz_VPSRLQZ256ri_VPSRLQZ256rik_VPSRLQZ256rikz_VPSRLWZ256ri_VPSRLWZ256rik_VPSRLWZ256rikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1074
  {DBGFIELD("VPSLLDZri_VPSLLDZrik_VPSLLDZrikz_VPSLLQZri_VPSLLQZrik_VPSLLQZrikz_VPSLLWZri_VPSLLWZrik_VPSLLWZrikz_VPSRADZri_VPSRADZrik_VPSRADZrikz_VPSRAQZri_VPSRAQZrik_VPSRAQZrikz_VPSRAWZri_VPSRAWZrik_VPSRAWZrikz_VPSRLDZri_VPSRLDZrik_VPSRLDZrikz_VPSRLQZri_VPSRLQZrik_VPSRLQZrikz_VPSRLWZri_VPSRLWZrik_VPSRLWZrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1075
  {DBGFIELD("PALIGNRrri_VPALIGNRZ128rri_VPALIGNRZ128rrik_VPALIGNRZ128rrikz_VPALIGNRrri") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1076
  {DBGFIELD("VPALIGNRZ256rri_VPALIGNRZ256rrik_VPALIGNRZ256rrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1077
  {DBGFIELD("VPALIGNRZrri_VPALIGNRZrrik_VPALIGNRZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1078
  {DBGFIELD("PACKSSDWrr_PACKSSWBrr_PACKUSDWrr_PACKUSWBrr_VPACKSSDWZ128rr_VPACKSSDWZ128rrk_VPACKSSDWZ128rrkz_VPACKSSDWrr_VPACKSSWBZ128rr_VPACKSSWBZ128rrk_VPACKSSWBZ128rrkz_VPACKSSWBrr_VPACKUSDWZ128rr_VPACKUSDWZ128rrk_VPACKUSDWZ128rrkz_VPACKUSDWrr_VPACKUSWBZ128rr_VPACKUSWBZ128rrk_VPACKUSWBZ128rrkz_VPACKUSWBrr") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1079
  {DBGFIELD("VPACKSSDWZ256rr_VPACKSSDWZ256rrk_VPACKSSDWZ256rrkz_VPACKSSWBZ256rr_VPACKSSWBZ256rrk_VPACKSSWBZ256rrkz_VPACKUSDWZ256rr_VPACKUSDWZ256rrk_VPACKUSDWZ256rrkz_VPACKUSWBZ256rr_VPACKUSWBZ256rrk_VPACKUSWBZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1080
  {DBGFIELD("VPACKSSDWZrr_VPACKSSDWZrrk_VPACKSSDWZrrkz_VPACKSSWBZrr_VPACKSSWBZrrk_VPACKSSWBZrrkz_VPACKUSDWZrr_VPACKUSDWZrrk_VPACKUSDWZrrkz_VPACKUSWBZrr_VPACKUSWBZrrk_VPACKUSWBZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1081
  {DBGFIELD("CMPPDrri_VCMPPDrri_VMAXCPDZ128rr_VMAXCPDZ128rrk_VMAXCPDZ128rrkz_VMAXPDZ128rr_VMAXPDZ128rrk_VMAXPDZ128rrkz_VMINCPDZ128rr_VMINCPDZ128rrk_VMINCPDZ128rrkz_VMINPDZ128rr_VMINPDZ128rrk_VMINPDZ128rrkz") 3, false, false, false, 2225, 3,  3, 1,  0, 0}, // #1082
  {DBGFIELD("CMPPSrri_VCMPPSrri") 3, false, false, false, 2225, 3,  3, 1,  0, 0}, // #1083
  {DBGFIELD("CMPSDrr_CMPSDrr_Int_VCMPSDrr_VCMPSDrr_Int_MAXSDrr_Int_MINSDrr_Int_VMAXSDZrr_Int_VMAXSDZrr_Intk_VMAXSDZrr_Intkz_VMAXSDrr_Int_VMINSDZrr_Int_VMINSDZrr_Intk_VMINSDZrr_Intkz_VMINSDrr_Int") 1, false, false, false,  3, 2, 10, 1,  0, 0}, // #1084
  {DBGFIELD("CMPSSrr_CMPSSrr_Int_VCMPSSrr_VCMPSSrr_Int_MAXSSrr_Int_MINSSrr_Int_VMAXSSZrr_Int_VMAXSSZrr_Intk_VMAXSSZrr_Intkz_VMAXSSrr_Int_VMINSSZrr_Int_VMINSSZrr_Intk_VMINSSZrr_Intkz_VMINSSrr_Int") 1, false, false, false,  3, 2, 10, 1,  0, 0}, // #1085
  {DBGFIELD("VPMAXSQZ128rr_VPMAXSQZ128rrk_VPMAXSQZ128rrkz_VPMAXUQZ128rr_VPMAXUQZ128rrk_VPMAXUQZ128rrkz_VPMINSQZ128rr_VPMINSQZ128rrk_VPMINSQZ128rrkz_VPMINUQZ128rr_VPMINUQZ128rrk_VPMINUQZ128rrkz") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1086
  {DBGFIELD("VPMAXSQZ256rr_VPMAXSQZ256rrk_VPMAXSQZ256rrkz_VPMAXUQZ256rr_VPMAXUQZ256rrk_VPMAXUQZ256rrkz_VPMINSQZ256rr_VPMINSQZ256rrk_VPMINSQZ256rrkz_VPMINUQZ256rr_VPMINUQZ256rrk_VPMINUQZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1087
  {DBGFIELD("VPMAXSQZrr_VPMAXSQZrrk_VPMAXSQZrrkz_VPMAXUQZrr_VPMAXUQZrrk_VPMAXUQZrrkz_VPMINSQZrr_VPMINSQZrrk_VPMINSQZrrkz_VPMINUQZrr_VPMINUQZrrk_VPMINUQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1088
  {DBGFIELD("VMAXCPDZ256rr_VMAXCPDZ256rrk_VMAXCPDZ256rrkz_VMAXPDZ256rr_VMAXPDZ256rrk_VMAXPDZ256rrkz_VMINCPDZ256rr_VMINCPDZ256rrk_VMINCPDZ256rrkz_VMINPDZ256rr_VMINPDZ256rrk_VMINPDZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1089
  {DBGFIELD("VMAXCPDZrr_VMAXCPDZrrk_VMAXCPDZrrkz_VMAXPDZrr_VMAXPDZrrb_VMAXPDZrrbk_VMAXPDZrrbkz_VMAXPDZrrk_VMAXPDZrrkz_VMINCPDZrr_VMINCPDZrrk_VMINCPDZrrkz_VMINPDZrr_VMINPDZrrb_VMINPDZrrbk_VMINPDZrrbkz_VMINPDZrrk_VMINPDZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1090
  {DBGFIELD("VPMOVSXBDZ128rr_VPMOVSXBDZ128rrk_VPMOVSXBDZ128rrkz_VPMOVSXBQZ128rr_VPMOVSXBQZ128rrk_VPMOVSXBQZ128rrkz_VPMOVSXBWZ128rr_VPMOVSXBWZ128rrk_VPMOVSXBWZ128rrkz_VPMOVSXDQZ128rr_VPMOVSXDQZ128rrk_VPMOVSXDQZ128rrkz_VPMOVSXWDZ128rr_VPMOVSXWDZ128rrk_VPMOVSXWDZ128rrkz_VPMOVSXWQZ128rr_VPMOVSXWQZ128rrk_VPMOVSXWQZ128rrkz_VPMOVZXBDZ128rr_VPMOVZXBDZ128rrk_VPMOVZXBDZ128rrkz_VPMOVZXBQZ128rr_VPMOVZXBQZ128rrk_VPMOVZXBQZ128rrkz_VPMOVZXBWZ128rr_VPMOVZXBWZ128rrk_VPMOVZXBWZ128rrkz_VPMOVZXDQZ128rr_VPMOVZXDQZ128rrk_VPMOVZXDQZ128rrkz_VPMOVZXWDZ128rr_VPMOVZXWDZ128rrk_VPMOVZXWDZ128rrkz_VPMOVZXWQZ128rr_VPMOVZXWQZ128rrk_VPMOVZXWQZ128rrkz") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1091
  {DBGFIELD("VPMOVSXBDZ256rr_VPMOVSXBDZ256rrk_VPMOVSXBDZ256rrkz_VPMOVSXBQZ256rr_VPMOVSXBQZ256rrk_VPMOVSXBQZ256rrkz_VPMOVSXBWZ256rr_VPMOVSXBWZ256rrk_VPMOVSXBWZ256rrkz_VPMOVSXDQZ256rr_VPMOVSXDQZ256rrk_VPMOVSXDQZ256rrkz_VPMOVSXWDZ256rr_VPMOVSXWDZ256rrk_VPMOVSXWDZ256rrkz_VPMOVSXWQZ256rr_VPMOVSXWQZ256rrk_VPMOVSXWQZ256rrkz_VPMOVZXBDZ256rr_VPMOVZXBDZ256rrk_VPMOVZXBDZ256rrkz_VPMOVZXBQZ256rr_VPMOVZXBQZ256rrk_VPMOVZXBQZ256rrkz_VPMOVZXBWZ256rr_VPMOVZXBWZ256rrk_VPMOVZXBWZ256rrkz_VPMOVZXDQZ256rr_VPMOVZXDQZ256rrk_VPMOVZXDQZ256rrkz_VPMOVZXWDZ256rr_VPMOVZXWDZ256rrk_VPMOVZXWDZ256rrkz_VPMOVZXWQZ256rr_VPMOVZXWQZ256rrk_VPMOVZXWQZ256rrkz_VPMOVSXBDYrr_VPMOVSXBQYrr_VPMOVSXBWYrr_VPMOVZXBDYrr_VPMOVZXBQYrr_VPMOVZXBWYrr_VPMOVSXDQYrr_VPMOVSXWDYrr_VPMOVSXWQYrr_VPMOVUSQWZ128rr_VPMOVUSQWZ128rrk_VPMOVUSQWZ128rrkz_VPMOVZXDQYrr_VPMOVZXWDYrr_VPMOVZXWQYrr_VPMOVDBZ128rr_VPMOVDBZ128rrk_VPMOVDBZ128rrkz_VPMOVDWZ128rr_VPMOVDWZ128rrk_VPMOVDWZ128rrkz_VPMOVQBZ128rr_VPMOVQBZ128rrk_VPMOVQBZ128rrkz_VPMOVQDZ128rr_VPMOVQDZ128rrk_VPMOVQDZ128rrkz_VPMOVQWZ128rr_VPMOVQWZ128rrk_VPMOVQWZ128rrkz_VPMOVSDBZ128rr_VPMOVSDBZ128rrk_VPMOVSDBZ128rrkz_VPMOVSDWZ128rr_VPMOVSDWZ128rrk_VPMOVSDWZ128rrkz_VPMOVSQBZ128rr_VPMOVSQBZ128rrk_VPMOVSQBZ128rrkz_VPMOVSQDZ128rr_VPMOVSQDZ128rrk_VPMOVSQDZ128rrkz_VPMOVSQWZ128rr_VPMOVSQWZ128rrk_VPMOVSQWZ128rrkz_VPMOVSWBZ128rr_VPMOVSWBZ128rrk_VPMOVSWBZ128rrkz_VPMOVUSDBZ128rr_VPMOVUSDBZ128rrk_VPMOVUSDBZ128rrkz_VPMOVUSDWZ128rr_VPMOVUSDWZ128rrk_VPMOVUSDWZ128rrkz_VPMOVUSQBZ128rr_VPMOVUSQBZ128rrk_VPMOVUSQBZ128rrkz_VPMOVUSQDZ128rr_VPMOVUSQDZ128rrk_VPMOVUSQDZ128rrkz_VPMOVUSWBZ128rr_VPMOVUSWBZ128rrk_VPMOVUSWBZ128rrkz_VPMOVWBZ128rr_VPMOVWBZ128rrk_VPMOVWBZ128rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1092
  {DBGFIELD("VMOVDDUPZ128rr_VMOVDDUPZ128rrk_VMOVDDUPZ128rrkz") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1093
  {DBGFIELD("VMOVDDUPZ256rr_VMOVDDUPZ256rrk_VMOVDDUPZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1094
  {DBGFIELD("VMOVDDUPZrr_VMOVDDUPZrrk_VMOVDDUPZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1095
  {DBGFIELD("PMOVSXBDrr_PMOVSXBQrr_PMOVSXBWrr_PMOVSXDQrr_PMOVSXWDrr_PMOVSXWQrr_PMOVZXBDrr_PMOVZXBQrr_PMOVZXBWrr_PMOVZXDQrr_PMOVZXWDrr_PMOVZXWQrr_VPMOVSXBDrr_VPMOVSXBQrr_VPMOVSXBWrr_VPMOVSXDQrr_VPMOVSXWDrr_VPMOVSXWQrr_VPMOVZXBDrr_VPMOVZXBQrr_VPMOVZXBWrr_VPMOVZXDQrr_VPMOVZXWDrr_VPMOVZXWQrr") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1096
  {DBGFIELD("VPMOVSXBDZrr_VPMOVSXBDZrrk_VPMOVSXBDZrrkz_VPMOVSXBQZrr_VPMOVSXBQZrrk_VPMOVSXBQZrrkz_VPMOVSXBWZrr_VPMOVSXBWZrrk_VPMOVSXBWZrrkz_VPMOVSXDQZrr_VPMOVSXDQZrrk_VPMOVSXDQZrrkz_VPMOVSXWDZrr_VPMOVSXWDZrrk_VPMOVSXWDZrrkz_VPMOVSXWQZrr_VPMOVSXWQZrrk_VPMOVSXWQZrrkz_VPMOVZXBDZrr_VPMOVZXBDZrrk_VPMOVZXBDZrrkz_VPMOVZXBQZrr_VPMOVZXBQZrrk_VPMOVZXBQZrrkz_VPMOVZXBWZrr_VPMOVZXBWZrrk_VPMOVZXBWZrrkz_VPMOVZXDQZrr_VPMOVZXDQZrrk_VPMOVZXDQZrrkz_VPMOVZXWDZrr_VPMOVZXWDZrrk_VPMOVZXWDZrrkz_VPMOVZXWQZrr_VPMOVZXWQZrrk_VPMOVZXWQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1097
  {DBGFIELD("VPMOVDBZrr_VPMOVDBZrrk_VPMOVDBZrrkz_VPMOVQBZrr_VPMOVQBZrrk_VPMOVQBZrrkz_VPMOVQWZrr_VPMOVQWZrrk_VPMOVQWZrrkz_VPMOVSDBZrr_VPMOVSDBZrrk_VPMOVSDBZrrkz_VPMOVSQBZrr_VPMOVSQBZrrk_VPMOVSQBZrrkz_VPMOVSQWZrr_VPMOVSQWZrrk_VPMOVSQWZrrkz_VPMOVUSDBZrr_VPMOVUSDBZrrk_VPMOVUSDBZrrkz_VPMOVUSQBZrr_VPMOVUSQBZrrk_VPMOVUSQBZrrkz_VPMOVUSQWZrr_VPMOVUSQWZrrk_VPMOVUSQWZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1098
  {DBGFIELD("VPTESTMBZ128rrk_VPTESTMDZ128rrk_VPTESTMQZ128rrk_VPTESTMWZ128rrk_VPTESTNMBZ128rrk_VPTESTNMDZ128rrk_VPTESTNMQZ128rrk_VPTESTNMWZ128rrk") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1099
  {DBGFIELD("VPTESTMBZ256rr_VPTESTMBZ256rrk_VPTESTMDZ256rr_VPTESTMDZ256rrk_VPTESTMQZ256rr_VPTESTMQZ256rrk_VPTESTMWZ256rr_VPTESTMWZ256rrk_VPTESTNMBZ256rr_VPTESTNMBZ256rrk_VPTESTNMDZ256rr_VPTESTNMDZ256rrk_VPTESTNMQZ256rr_VPTESTNMQZ256rrk_VPTESTNMWZ256rr_VPTESTNMWZ256rrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1100
  {DBGFIELD("VPTESTMBZrrk_VPTESTMDZrrk_VPTESTMQZrrk_VPTESTMWZrrk_VPTESTNMBZrrk_VPTESTNMDZrrk_VPTESTNMQZrrk_VPTESTNMWZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1101
  {DBGFIELD("VPCONFLICTDZ128rr_VPCONFLICTDZ128rrk_VPCONFLICTDZ128rrkz_VPCONFLICTQZ128rr_VPCONFLICTQZ128rrk_VPCONFLICTQZ128rrkz") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1102
  {DBGFIELD("VPCONFLICTDZ256rr_VPCONFLICTDZ256rrk_VPCONFLICTDZ256rrkz_VPCONFLICTQZ256rr_VPCONFLICTQZ256rrk_VPCONFLICTQZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1103
  {DBGFIELD("VPCONFLICTDZrr_VPCONFLICTDZrrk_VPCONFLICTDZrrkz_VPCONFLICTQZrr_VPCONFLICTQZrrk_VPCONFLICTQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1104
  {DBGFIELD("VRSQRT14PDZ128r_VRSQRT14PDZ128rk_VRSQRT14PDZ128rkz_VRSQRT14PSZ128r_VRSQRT14PSZ128rk_VRSQRT14PSZ128rkz") 5, false, false, false, 2235, 3, 22, 1,  0, 0}, // #1105
  {DBGFIELD("VRSQRT14PDZ256r_VRSQRT14PDZ256rk_VRSQRT14PDZ256rkz_VRSQRT14PSZ256r_VRSQRT14PSZ256rk_VRSQRT14PSZ256rkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1106
  {DBGFIELD("VRSQRT14PDZr_VRSQRT14PDZrk_VRSQRT14PDZrkz_VRSQRT14PSZr_VRSQRT14PSZrk_VRSQRT14PSZrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1107
  {DBGFIELD("VPERMILPDYrr_VPERMILPDZ256rr_VPERMILPDZ256rrk_VPERMILPDZ256rrkz_VPERMILPSYrr_VPERMILPSZ256rr_VPERMILPSZ256rrk_VPERMILPSZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1108
  {DBGFIELD("VPERMILPDZ128rr_VPERMILPDZ128rrk_VPERMILPDZ128rrkz_VPERMILPSZ128rr_VPERMILPSZ128rrk_VPERMILPSZ128rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1109
  {DBGFIELD("VPERMILPDZrr_VPERMILPDZrrk_VPERMILPDZrrkz_VPERMILPSZrr_VPERMILPSZrrk_VPERMILPSZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1110
  {DBGFIELD("VPERMI2PD128rr_VPERMI2PD128rrk_VPERMI2PD128rrkz_VPERMI2PS128rr_VPERMI2PS128rrk_VPERMI2PS128rrkz_VPERMT2PD128rr_VPERMT2PD128rrk_VPERMT2PD128rrkz_VPERMT2PS128rr_VPERMT2PS128rrk_VPERMT2PS128rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1111
  {DBGFIELD("VPERMI2W128rr_VPERMI2W128rrk_VPERMI2W128rrkz_VPERMT2W128rr_VPERMT2W128rrk_VPERMT2W128rrkz_VPERMI2B128rr_VPERMI2B128rrk_VPERMI2B128rrkz_VPERMI2D128rr_VPERMI2D128rrk_VPERMI2D128rrkz_VPERMI2Q128rr_VPERMI2Q128rrk_VPERMI2Q128rrkz_VPERMT2B128rr_VPERMT2B128rrk_VPERMT2B128rrkz_VPERMT2D128rr_VPERMT2D128rrk_VPERMT2D128rrkz_VPERMT2Q128rr_VPERMT2Q128rrk_VPERMT2Q128rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1112
  {DBGFIELD("VCOMPRESSPDZ128rr_VCOMPRESSPDZ128rrk_VCOMPRESSPDZ128rrkz_VCOMPRESSPSZ128rr_VCOMPRESSPSZ128rrk_VCOMPRESSPSZ128rrkz_VPCOMPRESSBZ128rr_VPCOMPRESSBZ128rrk_VPCOMPRESSBZ128rrkz_VPCOMPRESSDZ128rr_VPCOMPRESSDZ128rrk_VPCOMPRESSDZ128rrkz_VPCOMPRESSQZ128rr_VPCOMPRESSQZ128rrk_VPCOMPRESSQZ128rrkz_VPCOMPRESSWZ128rr_VPCOMPRESSWZ128rrk_VPCOMPRESSWZ128rrkz_VPERMBZ128rr_VPERMBZ128rrk_VPERMBZ128rrkz_VPERMWZ128rr_VPERMWZ128rrk_VPERMWZ128rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1113
  {DBGFIELD("VPERMI2PD256rr_VPERMI2PD256rrk_VPERMI2PD256rrkz_VPERMI2PS256rr_VPERMI2PS256rrk_VPERMI2PS256rrkz_VPERMT2PD256rr_VPERMT2PD256rrk_VPERMT2PD256rrkz_VPERMT2PS256rr_VPERMT2PS256rrk_VPERMT2PS256rrkz_VPERMPDZ256rr_VPERMPDZ256rrk_VPERMPDZ256rrkz_VPERMPSZ256rr_VPERMPSZ256rrk_VPERMPSZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1114
  {DBGFIELD("VPERMI2W256rr_VPERMI2W256rrk_VPERMI2W256rrkz_VPERMT2W256rr_VPERMT2W256rrk_VPERMT2W256rrkz_VCOMPRESSPDZ256rr_VCOMPRESSPDZ256rrk_VCOMPRESSPDZ256rrkz_VCOMPRESSPSZ256rr_VCOMPRESSPSZ256rrk_VCOMPRESSPSZ256rrkz_VPCOMPRESSBZ256rr_VPCOMPRESSBZ256rrk_VPCOMPRESSBZ256rrkz_VPCOMPRESSDZ256rr_VPCOMPRESSDZ256rrk_VPCOMPRESSDZ256rrkz_VPCOMPRESSQZ256rr_VPCOMPRESSQZ256rrk_VPCOMPRESSQZ256rrkz_VPCOMPRESSWZ256rr_VPCOMPRESSWZ256rrk_VPCOMPRESSWZ256rrkz_VPERMBZ256rr_VPERMBZ256rrk_VPERMBZ256rrkz_VPERMDZ256rr_VPERMDZ256rrk_VPERMDZ256rrkz_VPERMQZ256rr_VPERMQZ256rrk_VPERMQZ256rrkz_VPERMWZ256rr_VPERMWZ256rrk_VPERMWZ256rrkz_VPERMI2B256rr_VPERMI2B256rrk_VPERMI2B256rrkz_VPERMI2D256rr_VPERMI2D256rrk_VPERMI2D256rrkz_VPERMI2Q256rr_VPERMI2Q256rrk_VPERMI2Q256rrkz_VPERMT2B256rr_VPERMT2B256rrk_VPERMT2B256rrkz_VPERMT2D256rr_VPERMT2D256rrk_VPERMT2D256rrkz_VPERMT2Q256rr_VPERMT2Q256rrk_VPERMT2Q256rrkz_VPEXPANDBZ256rr_VPEXPANDBZ256rrk_VPEXPANDBZ256rrkz_VPEXPANDWZ256rr_VPEXPANDWZ256rrk_VPEXPANDWZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1115
  {DBGFIELD("VPERMI2PDrr_VPERMI2PDrrk_VPERMI2PDrrkz_VPERMI2PSrr_VPERMI2PSrrk_VPERMI2PSrrkz_VPERMT2PDrr_VPERMT2PDrrk_VPERMT2PDrrkz_VPERMT2PSrr_VPERMT2PSrrk_VPERMT2PSrrkz_VPERMPDZrr_VPERMPDZrrk_VPERMPDZrrkz_VPERMPSZrr_VPERMPSZrrk_VPERMPSZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1116
  {DBGFIELD("VPERMI2Wrr_VPERMI2Wrrk_VPERMI2Wrrkz_VPERMT2Wrr_VPERMT2Wrrk_VPERMT2Wrrkz_VPERMBZrr_VPERMBZrrk_VPERMBZrrkz_VPERMDZrr_VPERMDZrrk_VPERMDZrrkz_VPERMWZrr_VPERMWZrrk_VPERMWZrrkz_VPERMI2Brr_VPERMI2Brrk_VPERMI2Brrkz_VPERMI2Drr_VPERMI2Drrk_VPERMI2Drrkz_VPERMI2Qrr_VPERMI2Qrrk_VPERMI2Qrrkz_VPERMT2Brr_VPERMT2Brrk_VPERMT2Brrkz_VPERMT2Drr_VPERMT2Drrk_VPERMT2Drrkz_VPERMT2Qrr_VPERMT2Qrrk_VPERMT2Qrrkz_VCOMPRESSPDZrr_VCOMPRESSPDZrrk_VCOMPRESSPDZrrkz_VCOMPRESSPSZrr_VCOMPRESSPSZrrk_VCOMPRESSPSZrrkz_VPCOMPRESSBZrr_VPCOMPRESSBZrrk_VPCOMPRESSBZrrkz_VPCOMPRESSDZrr_VPCOMPRESSDZrrk_VPCOMPRESSDZrrkz_VPCOMPRESSQZrr_VPCOMPRESSQZrrk_VPCOMPRESSQZrrkz_VPCOMPRESSWZrr_VPCOMPRESSWZrrk_VPCOMPRESSWZrrkz_VPEXPANDBZrr_VPEXPANDBZrrk_VPEXPANDBZrrkz_VPEXPANDWZrr_VPEXPANDWZrrk_VPEXPANDWZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1117
  {DBGFIELD("VPABSBZ128rr_VPABSBZ128rrk_VPABSBZ128rrkz_VPABSDZ128rr_VPABSDZ128rrk_VPABSDZ128rrkz_VPABSQZ128rr_VPABSQZ128rrk_VPABSQZ128rrkz_VPABSWZ128rr_VPABSWZ128rrk_VPABSWZ128rrkz_VPADDSBZ128rr_VPADDSBZ128rrk_VPADDSBZ128rrkz_VPADDSWZ128rr_VPADDSWZ128rrk_VPADDSWZ128rrkz_VPADDUSBZ128rr_VPADDUSBZ128rrk_VPADDUSBZ128rrkz_VPADDUSWZ128rr_VPADDUSWZ128rrk_VPADDUSWZ128rrkz_VPAVGBZ128rr_VPAVGBZ128rrk_VPAVGBZ128rrkz_VPAVGWZ128rr_VPAVGWZ128rrk_VPAVGWZ128rrkz_VPOPCNTBZ128rr_VPOPCNTBZ128rrk_VPOPCNTBZ128rrkz_VPOPCNTDZ128rr_VPOPCNTDZ128rrk_VPOPCNTDZ128rrkz_VPOPCNTQZ128rr_VPOPCNTQZ128rrk_VPOPCNTQZ128rrkz_VPOPCNTWZ128rr_VPOPCNTWZ128rrk_VPOPCNTWZ128rrkz_VPSUBSBZ128rr_VPSUBSBZ128rrk_VPSUBSBZ128rrkz_VPSUBSWZ128rr_VPSUBSWZ128rrk_VPSUBSWZ128rrkz_VPSUBUSBZ128rr_VPSUBUSBZ128rrk_VPSUBUSBZ128rrkz_VPSUBUSWZ128rr_VPSUBUSWZ128rrk_VPSUBUSWZ128rrkz") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1118
  {DBGFIELD("LSL16rr_LSL32rr_LSL64rr") 1, false, false, false,  4, 1,  4, 1,  0, 0}, // #1119
  {DBGFIELD("LXADD8_LXADD16_LXADD32_LXADD64") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1120
  {DBGFIELD("BLCFILL32rr_BLCFILL64rr_BLCI32rr_BLCI64rr_BLCIC32rr_BLCIC64rr_BLCMSK32rr_BLCMSK64rr_BLCS32rr_BLCS64rr_BLSFILL32rr_BLSFILL64rr_BLSIC32rr_BLSIC64rr_T1MSKC32rr_T1MSKC64rr_TZMSK32rr_TZMSK64rr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1121
  {DBGFIELD("BLCFILL32rm_BLCFILL64rm_BLCI32rm_BLCI64rm_BLCIC32rm_BLCIC64rm_BLCMSK32rm_BLCMSK64rm_BLCS32rm_BLCS64rm_BLSFILL32rm_BLSFILL64rm_BLSIC32rm_BLSIC64rm_T1MSKC32rm_T1MSKC64rm_TZMSK32rm_TZMSK64rm") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1122
  {DBGFIELD("ADC64ri32_SBB64ri32") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1123
  {DBGFIELD("CRC32r32r16")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1124
  {DBGFIELD("CRC32r32r32")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1125
  {DBGFIELD("CRC32r64r64")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1126
  {DBGFIELD("SAHF")               1, false, false, false, 75, 1, 12, 1,  0, 0}, // #1127
  {DBGFIELD("BEXTRI32ri_BEXTRI64ri") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1128
  {DBGFIELD("BEXTRI32mi_BEXTRI64mi") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1129
  {DBGFIELD("RCR8ri")             1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1130
  {DBGFIELD("RCL16rCL")           1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1131
  {DBGFIELD("RCR16ri")            1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1132
  {DBGFIELD("RCR32rCL_RCR64rCL")  1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1133
  {DBGFIELD("RCL16ri")            1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1134
  {DBGFIELD("RCL32ri_RCL64ri")    1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1135
  {DBGFIELD("SHLD16rrCL")         1, false, false, false, 464, 1,  3, 1,  0, 0}, // #1136
  {DBGFIELD("VMOVUPDYmr_VMOVUPSYmr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1137
  {DBGFIELD("TST_F")              1, false, false, false, 293, 1, 22, 1,  0, 0}, // #1138
  {DBGFIELD("VDPPSrri")           8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1139
  {DBGFIELD("VFRCZPDrr_VFRCZPSrr") 1, false, false, false, 2238, 2, 10, 1,  0, 0}, // #1140
  {DBGFIELD("VFRCZSDrr_VFRCZSSrr") 1, false, false, false, 2238, 2, 10, 1,  0, 0}, // #1141
  {DBGFIELD("VFRCZPDrm_VFRCZPSrm_VFRCZSDrm_VFRCZSSrm") 1, false, false, false, 2238, 2, 10, 1, 15, 1}, // #1142
  {DBGFIELD("VFRCZPSYrr_VFRCZPDYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1143
  {DBGFIELD("VFRCZPSYrm_VFRCZPDYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1144
  {DBGFIELD("MMX_CVTTPD2PIrr")    4, false, false, false, 2240, 3,  6, 1,  0, 0}, // #1145
  {DBGFIELD("CVTSI2SSrr")         3, false, false, false, 2222, 3,  3, 1,  0, 1}, // #1146
  {DBGFIELD("VMOVDQUYmr")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1147
  {DBGFIELD("MOVDQArr")           1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1148
  {DBGFIELD("VPMACSDQHrr_VPMACSDQLrr_VPMACSSDQHrr_VPMACSSDQLrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1149
  {DBGFIELD("VPPERMrrr_VPPERMrrr_REV") 4, false, false, false, 2283, 3, 14, 1,  0, 0}, // #1150
  {DBGFIELD("VPPERMrrm")          5, false, false, false, 2280, 3, 10, 1, 17, 2}, // #1151
  {DBGFIELD("VPPERMrmr")          5, false, false, false, 2280, 3, 10, 1, 15, 2}, // #1152
  {DBGFIELD("PHADDWrr_PHSUBWrr_PHADDSWrr_PHSUBSWrr_VPHADDDrr_VPHSUBDrr_VPHADDWrr_VPHSUBWrr_VPHADDSWrr_VPHSUBSWrr") 3, false, false, false, 2240, 3,  6, 1,  0, 0}, // #1153
  {DBGFIELD("PHADDWrm_PHSUBWrm_PHADDSWrm_PHSUBSWrm_VPHADDDrm_VPHSUBDrm_VPHADDWrm_VPHSUBWrm_VPHADDSWrm_VPHSUBSWrm") 4, false, false, false, 2243, 3,  7, 1, 15, 1}, // #1154
  {DBGFIELD("VPCLMULQDQrr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1155
  {DBGFIELD("ANDNPSrr_ANDNPDrr")  1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1156
  {DBGFIELD("MMX_PXORrr_MMX_PANDNrr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1157
  {DBGFIELD("PANDNrr")            1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1158
  {DBGFIELD("MMX_PSUBBrr_MMX_PSUBDrr_MMX_PSUBWrr_MMX_PCMPGTBrr_MMX_PCMPGTDrr_MMX_PCMPGTWrr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1159
  {DBGFIELD("LCMPXCHG16_LCMPXCHG32_LCMPXCHG64") 1, false, false, false, 2218, 2,  1, 1,  0, 0}, // #1160
  {DBGFIELD("CMPXCHG16rr_CMPXCHG32rr_CMPXCHG64rr") 1, false, false, false, 2231, 1, 11, 1,  0, 0}, // #1161
  {DBGFIELD("LCMPXCHG8B")         1, false, false, false, 2218, 2,  1, 1,  0, 0}, // #1162
  {DBGFIELD("XCHG8rr")            1, false, false, false, 75, 1, 12, 1,  0, 0}, // #1163
  {DBGFIELD("MMX_PSUBSBrr_MMX_PSUBSWrr_MMX_PSUBUSBrr_MMX_PSUBUSWrr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1164
  {DBGFIELD("PSUBSBrr_VPSUBSBrr_PSUBSWrr_VPSUBSWrr_PSUBUSBrr_VPSUBUSBrr_PSUBUSWrr_VPSUBUSWrr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1165
  {DBGFIELD("MMX_PCMPEQBrr_MMX_PCMPEQDrr_MMX_PCMPEQWrr_MMX_PMAXSWrr_MMX_PMINSWrr_MMX_PMAXUBrr_MMX_PMINUBrr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1166
  {DBGFIELD("MMX_PCMPGTBrr_MMX_PCMPGTDrr_MMX_PCMPGTWrr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1167
  {DBGFIELD("CLAC_STAC")          1, false, false, false,  4, 1,  4, 1,  0, 0}, // #1168
  {DBGFIELD("PADDBrr_PADDDrr_PADDWrr_VPADDBrr_VPADDDrr_VPADDQrr_VPADDWrr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1169
  {DBGFIELD("VPADDBYrr_VPADDDYrr_VPADDQYrr_VPADDWYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1170
  {DBGFIELD("ADD_FPrST0_ADD_FST0r_ADD_FrST0_SUBR_FPrST0_SUBR_FST0r_SUBR_FrST0_SUB_FPrST0_SUB_FST0r_SUB_FrST0") 1, false, false, false,  3, 2, 10, 1,  0, 0}, // #1171
  {DBGFIELD("MMX_PHADDSWrr_MMX_PHSUBSWrr") 1, false, false, false, 240, 1, 10, 1,  0, 0}, // #1172
  {DBGFIELD("PHADDSWrr_VPHADDSWrr_PHSUBSWrr_VPHSUBSWrr") 3, false, false, false, 2240, 3,  6, 1,  0, 0}, // #1173
  {DBGFIELD("VPHADDSWYrr_VPHSUBSWYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1174
  {DBGFIELD("MMX_PADDSBrm_MMX_PADDSWrm_MMX_PADDUSBrm_MMX_PADDUSWrm_MMX_PAVGBrm_MMX_PAVGWrm_MMX_PCMPEQBrm_MMX_PCMPEQDrm_MMX_PCMPEQWrm_MMX_PCMPGTBrm_MMX_PCMPGTDrm_MMX_PCMPGTWrm_MMX_PMAXSWrm_MMX_PMAXUBrm_MMX_PMINSWrm_MMX_PMINUBrm_MMX_PSUBSBrm_MMX_PSUBSWrm_MMX_PSUBUSBrm_MMX_PSUBUSWrm") 1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #1175
  {DBGFIELD("PADDBrm_PADDDrm_PADDWrm_VPADDBrm_VPADDDrm_VPADDQrm_VPADDWrm_PSUBBrm_PSUBDrm_PSUBWrm_VPSUBBrm_VPSUBDrm_VPSUBQrm_VPSUBWrm") 1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #1176
  {DBGFIELD("VCVTSS2SI64rr_VCVTTSS2SI64rr") 3, false, false, false, 2243, 3,  7, 1,  0, 0}, // #1177
  {DBGFIELD("VCVTSS2SI64rr_Int_VCVTTSS2SI64rr_Int") 3, false, false, false, 2243, 3,  7, 1,  0, 0}, // #1178
  {DBGFIELD("VPADDBYrm_VPADDDYrm_VPADDQYrm_VPADDWYrm_VPSUBBYrm_VPSUBDYrm_VPSUBQYrm_VPSUBWYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1179
  {DBGFIELD("MMX_PHADDSWrm_MMX_PHSUBSWrm") 1, false, false, false, 464, 1,  3, 1,  0, 0}, // #1180
  {DBGFIELD("PHADDSWrm_VPHADDSWrm_PHSUBSWrm_VPHSUBSWrm") 4, false, false, false, 2243, 3,  7, 1, 15, 1}, // #1181
  {DBGFIELD("VPHADDSWYrm_VPHSUBSWYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1182
  {DBGFIELD("XSAVEC_XSAVEC64_XSAVES_XSAVES64") 1, false, false, false,  4, 1,  4, 1,  0, 0}, // #1183
  {DBGFIELD("PCMPGTBrr_PCMPGTDrr_PCMPGTWrr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1184
  {DBGFIELD("VPCMPGTBrr_VPCMPGTDrr_VPCMPGTWrr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1185
  {DBGFIELD("VPCMPGTBYrr_VPCMPGTDYrr_VPCMPGTWYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1186
  {DBGFIELD("KANDBrr_KANDDrr_KANDQrr_KANDWrr_KANDNBrr_KANDNDrr_KANDNQrr_KANDNWrr_KNOTBrr_KNOTDrr_KNOTQrr_KNOTWrr_KORBrr_KORDrr_KORQrr_KORWrr_KXNORBrr_KXNORDrr_KXNORQrr_KXNORWrr_KXORBrr_KXORDrr_KXORQrr_KXORWrr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1187
  {DBGFIELD("KMOVBkk_KMOVDkk_KMOVQkk_KMOVWkk") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1188
  {DBGFIELD("KSET0D_KSET0Q_KSET0W_KSET1D_KSET1Q_KSET1W") 1, false, false, false,  0, 0,  1, 1,  0, 0}, // #1189
  {DBGFIELD("VPMOVB2MZ128rr_VPMOVB2MZ256rr_VPMOVB2MZrr_VPMOVD2MZ128rr_VPMOVD2MZ256rr_VPMOVD2MZrr_VPMOVQ2MZ128rr_VPMOVQ2MZ256rr_VPMOVQ2MZrr_VPMOVW2MZ128rr_VPMOVW2MZ256rr_VPMOVW2MZrr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1190
  {DBGFIELD("VBLENDMPDZ128rr_VBLENDMPDZ128rrk_VBLENDMPDZ128rrkz_VBLENDMPSZ128rr_VBLENDMPSZ128rrk_VBLENDMPSZ128rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1191
  {DBGFIELD("VBLENDMPDZ256rr_VBLENDMPDZ256rrk_VBLENDMPDZ256rrkz_VBLENDMPSZ256rr_VBLENDMPSZ256rrk_VBLENDMPSZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1192
  {DBGFIELD("VPADDBZ128rr_VPADDBZ128rrk_VPADDBZ128rrkz_VPADDDZ128rr_VPADDDZ128rrk_VPADDDZ128rrkz_VPADDQZ128rr_VPADDQZ128rrk_VPADDQZ128rrkz_VPADDWZ128rr_VPADDWZ128rrk_VPADDWZ128rrkz_VPSUBBZ128rrk_VPSUBBZ128rrkz_VPSUBDZ128rrk_VPSUBDZ128rrkz_VPSUBQZ128rrk_VPSUBQZ128rrkz_VPSUBWZ128rrk_VPSUBWZ128rrkz_VPTERNLOGDZ128rri_VPTERNLOGDZ128rrik_VPTERNLOGDZ128rrikz_VPTERNLOGQZ128rri_VPTERNLOGQZ128rrik_VPTERNLOGQZ128rrikz") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1193
  {DBGFIELD("VPADDBZ256rr_VPADDBZ256rrk_VPADDBZ256rrkz_VPADDDZ256rr_VPADDDZ256rrk_VPADDDZ256rrkz_VPADDQZ256rr_VPADDQZ256rrk_VPADDQZ256rrkz_VPADDWZ256rr_VPADDWZ256rrk_VPADDWZ256rrkz_VPSUBBZ256rrk_VPSUBBZ256rrkz_VPSUBDZ256rrk_VPSUBDZ256rrkz_VPSUBQZ256rrk_VPSUBQZ256rrkz_VPSUBWZ256rrk_VPSUBWZ256rrkz_VPTERNLOGDZ256rri_VPTERNLOGDZ256rrik_VPTERNLOGDZ256rrikz_VPTERNLOGQZ256rri_VPTERNLOGQZ256rrik_VPTERNLOGQZ256rrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1194
  {DBGFIELD("VPADDBZrr_VPADDBZrrk_VPADDBZrrkz_VPADDDZrr_VPADDDZrrk_VPADDDZrrkz_VPADDQZrr_VPADDQZrrk_VPADDQZrrkz_VPADDWZrr_VPADDWZrrk_VPADDWZrrkz_VPSUBBZrrk_VPSUBBZrrkz_VPSUBDZrrk_VPSUBDZrrkz_VPSUBQZrrk_VPSUBQZrrkz_VPSUBWZrrk_VPSUBWZrrkz_VPTERNLOGDZrri_VPTERNLOGDZrrik_VPTERNLOGDZrrikz_VPTERNLOGQZrri_VPTERNLOGQZrrik_VPTERNLOGQZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1195
  {DBGFIELD("VPBLENDMBZ128rr_VPBLENDMBZ128rrk_VPBLENDMBZ128rrkz_VPBLENDMDZ128rr_VPBLENDMDZ128rrk_VPBLENDMDZ128rrkz_VPBLENDMQZ128rr_VPBLENDMQZ128rrk_VPBLENDMQZ128rrkz_VPBLENDMWZ128rr_VPBLENDMWZ128rrk_VPBLENDMWZ128rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1196
  {DBGFIELD("VPBLENDMBZ256rr_VPBLENDMBZ256rrk_VPBLENDMBZ256rrkz_VPBLENDMDZ256rr_VPBLENDMDZ256rrk_VPBLENDMDZ256rrkz_VPBLENDMQZ256rr_VPBLENDMQZ256rrk_VPBLENDMQZ256rrkz_VPBLENDMWZ256rr_VPBLENDMWZ256rrk_VPBLENDMWZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1197
  {DBGFIELD("VMOVDQU8Zmr_VMOVDQU8Zmrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1198
  {DBGFIELD("KORTESTBrr_KORTESTDrr_KORTESTQrr_KORTESTWrr_KTESTBrr_KTESTDrr_KTESTQrr_KTESTWrr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1199
  {DBGFIELD("VALIGNDZ128rrik_VALIGNDZ128rrikz_VALIGNQZ128rrik_VALIGNQZ128rrikz") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1200
  {DBGFIELD("VALIGNDZ256rrik_VALIGNDZ256rrikz_VALIGNQZ256rrik_VALIGNQZ256rrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1201
  {DBGFIELD("VALIGNDZrrik_VALIGNDZrrikz_VALIGNQZrrik_VALIGNQZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1202
  {DBGFIELD("KSHIFTLBri_KSHIFTLDri_KSHIFTLQri_KSHIFTLWri_KSHIFTRBri_KSHIFTRDri_KSHIFTRQri_KSHIFTRWri") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1203
  {DBGFIELD("VCMPPDZ128rri_VCMPPDZ128rrik_VCMPPSZ128rri_VCMPPSZ128rrik_VFPCLASSPDZ128rr_VFPCLASSPDZ128rrk_VFPCLASSPSZ128rr_VFPCLASSPSZ128rrk") 3, false, false, false, 2225, 3,  3, 1,  0, 0}, // #1204
  {DBGFIELD("VCMPPDZ256rri_VCMPPDZ256rrik_VCMPPSZ256rri_VCMPPSZ256rrik_VFPCLASSPDZ256rr_VFPCLASSPDZ256rrk_VFPCLASSPSZ256rr_VFPCLASSPSZ256rrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1205
  {DBGFIELD("VCMPPDZrri_VCMPPDZrrib_VCMPPDZrribk_VCMPPDZrrik_VCMPPSZrri_VCMPPSZrrib_VCMPPSZrribk_VCMPPSZrrik_VFPCLASSPDZrr_VFPCLASSPDZrrk_VFPCLASSPSZrr_VFPCLASSPSZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1206
  {DBGFIELD("VCMPSDZrr_VCMPSDZrr_Int_VCMPSDZrr_Intk_VCMPSDZrrb_Int_VCMPSDZrrb_Intk_VCMPSSZrr_VCMPSSZrr_Int_VCMPSSZrr_Intk_VCMPSSZrrb_Int_VCMPSSZrrb_Intk_VFPCLASSSDZrr_VFPCLASSSDZrrk_VFPCLASSSSZrr_VFPCLASSSSZrrk") 1, false, false, false,  3, 2, 10, 1,  0, 0}, // #1207
  {DBGFIELD("VPCMPBZ128rri_VPCMPBZ128rrik_VPCMPDZ128rri_VPCMPDZ128rrik_VPCMPEQBZ128rr_VPCMPEQBZ128rrk_VPCMPEQDZ128rr_VPCMPEQDZ128rrk_VPCMPEQQZ128rr_VPCMPEQQZ128rrk_VPCMPEQWZ128rr_VPCMPEQWZ128rrk_VPCMPGTBZ128rr_VPCMPGTBZ128rrk_VPCMPGTDZ128rr_VPCMPGTDZ128rrk_VPCMPGTQZ128rr_VPCMPGTQZ128rrk_VPCMPGTWZ128rr_VPCMPGTWZ128rrk_VPCMPQZ128rri_VPCMPQZ128rrik_VPCMPUBZ128rri_VPCMPUBZ128rrik_VPCMPUDZ128rri_VPCMPUDZ128rrik_VPCMPUQZ128rri_VPCMPUQZ128rrik_VPCMPUWZ128rri_VPCMPUWZ128rrik_VPCMPWZ128rri_VPCMPWZ128rrik") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1208
  {DBGFIELD("VPCMPBZ256rri_VPCMPBZ256rrik_VPCMPDZ256rri_VPCMPDZ256rrik_VPCMPEQBZ256rr_VPCMPEQBZ256rrk_VPCMPEQDZ256rr_VPCMPEQDZ256rrk_VPCMPEQQZ256rr_VPCMPEQQZ256rrk_VPCMPEQWZ256rr_VPCMPEQWZ256rrk_VPCMPGTBZ256rr_VPCMPGTBZ256rrk_VPCMPGTDZ256rr_VPCMPGTDZ256rrk_VPCMPGTQZ256rr_VPCMPGTQZ256rrk_VPCMPGTWZ256rr_VPCMPGTWZ256rrk_VPCMPQZ256rri_VPCMPQZ256rrik_VPCMPUBZ256rri_VPCMPUBZ256rrik_VPCMPUDZ256rri_VPCMPUDZ256rrik_VPCMPUQZ256rri_VPCMPUQZ256rrik_VPCMPUWZ256rri_VPCMPUWZ256rrik_VPCMPWZ256rri_VPCMPWZ256rrik") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1209
  {DBGFIELD("VPCMPBZrri_VPCMPBZrrik_VPCMPDZrri_VPCMPDZrrik_VPCMPEQBZrr_VPCMPEQBZrrk_VPCMPEQDZrr_VPCMPEQDZrrk_VPCMPEQQZrr_VPCMPEQQZrrk_VPCMPEQWZrr_VPCMPEQWZrrk_VPCMPGTBZrr_VPCMPGTBZrrk_VPCMPGTDZrr_VPCMPGTDZrrk_VPCMPGTQZrr_VPCMPGTQZrrk_VPCMPGTWZrr_VPCMPGTWZrrk_VPCMPQZrri_VPCMPQZrrik_VPCMPUBZrri_VPCMPUBZrrik_VPCMPUDZrri_VPCMPUDZrrik_VPCMPUQZrri_VPCMPUQZrrik_VPCMPUWZrri_VPCMPUWZrrik_VPCMPWZrri_VPCMPWZrrik") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1210
  {DBGFIELD("VPTESTMBZ128rr_VPTESTMDZ128rr_VPTESTMQZ128rr_VPTESTMWZ128rr_VPTESTNMBZ128rr_VPTESTNMDZ128rr_VPTESTNMQZ128rr_VPTESTNMWZ128rr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1211
  {DBGFIELD("VPTESTMBZrr_VPTESTMDZrr_VPTESTMQZrr_VPTESTMWZrr_VPTESTNMBZrr_VPTESTNMDZrr_VPTESTNMQZrr_VPTESTNMWZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1212
  {DBGFIELD("VCVTPD2QQZ128rr_VCVTPD2QQZ128rrk_VCVTPD2QQZ128rrkz_VCVTPD2UQQZ128rr_VCVTPD2UQQZ128rrk_VCVTPD2UQQZ128rrkz_VCVTTPD2QQZ128rr_VCVTTPD2QQZ128rrk_VCVTTPD2QQZ128rrkz_VCVTTPD2UQQZ128rr_VCVTTPD2UQQZ128rrk_VCVTTPD2UQQZ128rrkz") 4, false, false, false, 2240, 3,  6, 1,  0, 0}, // #1213
  {DBGFIELD("VCVTPD2QQZ256rr_VCVTPD2QQZ256rrk_VCVTPD2QQZ256rrkz_VCVTPD2UQQZ256rr_VCVTPD2UQQZ256rrk_VCVTPD2UQQZ256rrkz_VCVTTPD2QQZ256rr_VCVTTPD2QQZ256rrk_VCVTTPD2QQZ256rrkz_VCVTTPD2UQQZ256rr_VCVTTPD2UQQZ256rrk_VCVTTPD2UQQZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1214
  {DBGFIELD("VCVTPS2DQYrr_VCVTPS2DQZ256rr_VCVTPS2DQZ256rrk_VCVTPS2DQZ256rrkz_VCVTPS2UDQZ256rr_VCVTPS2UDQZ256rrk_VCVTPS2UDQZ256rrkz_VCVTTPS2DQZ256rr_VCVTTPS2DQZ256rrk_VCVTTPS2DQZ256rrkz_VCVTTPS2UDQZ256rr_VCVTTPS2UDQZ256rrk_VCVTTPS2UDQZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1215
  {DBGFIELD("VCVTPS2DQZ128rr_VCVTPS2DQZ128rrk_VCVTPS2DQZ128rrkz_VCVTPS2UDQZ128rr_VCVTPS2UDQZ128rrk_VCVTPS2UDQZ128rrkz_VCVTTPS2DQZ128rr_VCVTTPS2DQZ128rrk_VCVTTPS2DQZ128rrkz_VCVTTPS2UDQZ128rr_VCVTTPS2UDQZ128rrk_VCVTTPS2UDQZ128rrkz") 3, false, false, false, 2222, 3,  3, 1,  0, 0}, // #1216
  {DBGFIELD("VCVTPD2QQZrr_VCVTPD2UQQZrr_VCVTTPD2QQZrr_VCVTTPD2UQQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1217
  {DBGFIELD("VCVTPS2DQZrr_VCVTPS2UDQZrr_VCVTTPS2DQZrr_VCVTTPS2UDQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1218
  {DBGFIELD("VEXPANDPDZ128rr_VEXPANDPDZ128rrk_VEXPANDPDZ128rrkz_VEXPANDPDZ256rr_VEXPANDPDZ256rrk_VEXPANDPDZ256rrkz_VEXPANDPDZrr_VEXPANDPDZrrk_VEXPANDPDZrrkz_VEXPANDPSZ128rr_VEXPANDPSZ128rrk_VEXPANDPSZ128rrkz_VEXPANDPSZ256rr_VEXPANDPSZ256rrk_VEXPANDPSZ256rrkz_VEXPANDPSZrr_VEXPANDPSZrrk_VEXPANDPSZrrkz_VPEXPANDDZ128rr_VPEXPANDDZ128rrk_VPEXPANDDZ128rrkz_VPEXPANDDZ256rr_VPEXPANDDZ256rrk_VPEXPANDDZ256rrkz_VPEXPANDDZrr_VPEXPANDDZrrk_VPEXPANDDZrrkz_VPEXPANDQZ128rr_VPEXPANDQZ128rrk_VPEXPANDQZ128rrkz_VPEXPANDQZ256rr_VPEXPANDQZ256rrk_VPEXPANDQZ256rrkz_VPEXPANDQZrr_VPEXPANDQZrrk_VPEXPANDQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1219
  {DBGFIELD("VPMOVDBZ128rr_VPMOVDBZ128rrk_VPMOVDBZ128rrkz_VPMOVDWZ128rr_VPMOVDWZ128rrk_VPMOVDWZ128rrkz_VPMOVQBZ128rr_VPMOVQBZ128rrk_VPMOVQBZ128rrkz_VPMOVQWZ128rr_VPMOVQWZ128rrk_VPMOVQWZ128rrkz_VPMOVSDBZ128rr_VPMOVSDBZ128rrk_VPMOVSDBZ128rrkz_VPMOVSDWZ128rr_VPMOVSDWZ128rrk_VPMOVSDWZ128rrkz_VPMOVSQBZ128rr_VPMOVSQBZ128rrk_VPMOVSQBZ128rrkz_VPMOVSQDZ128rr_VPMOVSQDZ128rrk_VPMOVSQDZ128rrkz_VPMOVSQWZ128rr_VPMOVSQWZ128rrk_VPMOVSQWZ128rrkz_VPMOVSWBZ128rr_VPMOVSWBZ128rrk_VPMOVSWBZ128rrkz_VPMOVUSDBZ128rr_VPMOVUSDBZ128rrk_VPMOVUSDBZ128rrkz_VPMOVUSDWZ128rr_VPMOVUSDWZ128rrk_VPMOVUSDWZ128rrkz_VPMOVUSQBZ128rr_VPMOVUSQBZ128rrk_VPMOVUSQBZ128rrkz_VPMOVUSQDZ128rr_VPMOVUSQDZ128rrk_VPMOVUSQDZ128rrkz_VPMOVUSWBZ128rr_VPMOVUSWBZ128rrk_VPMOVUSWBZ128rrkz_VPMOVWBZ128rr_VPMOVWBZ128rrk_VPMOVWBZ128rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1220
  {DBGFIELD("VPMOVDBZ256rr_VPMOVDBZ256rrk_VPMOVDBZ256rrkz_VPMOVDWZ256rr_VPMOVDWZ256rrk_VPMOVDWZ256rrkz_VPMOVDWZrr_VPMOVDWZrrk_VPMOVDWZrrkz_VPMOVQBZ256rr_VPMOVQBZ256rrk_VPMOVQBZ256rrkz_VPMOVQWZ256rr_VPMOVQWZ256rrk_VPMOVQWZ256rrkz_VPMOVSDBZ256rr_VPMOVSDBZ256rrk_VPMOVSDBZ256rrkz_VPMOVSDWZ256rr_VPMOVSDWZ256rrk_VPMOVSDWZ256rrkz_VPMOVSDWZrr_VPMOVSDWZrrk_VPMOVSDWZrrkz_VPMOVSQBZ256rr_VPMOVSQBZ256rrk_VPMOVSQBZ256rrkz_VPMOVSQDZ256rr_VPMOVSQDZ256rrk_VPMOVSQDZ256rrkz_VPMOVSQDZrr_VPMOVSQDZrrk_VPMOVSQDZrrkz_VPMOVSQWZ256rr_VPMOVSQWZ256rrk_VPMOVSQWZ256rrkz_VPMOVSWBZ256rr_VPMOVSWBZ256rrk_VPMOVSWBZ256rrkz_VPMOVSWBZrr_VPMOVSWBZrrk_VPMOVSWBZrrkz_VPMOVUSDBZ256rr_VPMOVUSDBZ256rrk_VPMOVUSDBZ256rrkz_VPMOVUSDWZ256rr_VPMOVUSDWZ256rrk_VPMOVUSDWZ256rrkz_VPMOVUSDWZrr_VPMOVUSDWZrrk_VPMOVUSDWZrrkz_VPMOVUSQBZ256rr_VPMOVUSQBZ256rrk_VPMOVUSQBZ256rrkz_VPMOVUSQDZ256rr_VPMOVUSQDZ256rrk_VPMOVUSQDZ256rrkz_VPMOVUSQDZrr_VPMOVUSQDZrrk_VPMOVUSQDZrrkz_VPMOVUSWBZ256rr_VPMOVUSWBZ256rrk_VPMOVUSWBZ256rrkz_VPMOVUSWBZrr_VPMOVUSWBZrrk_VPMOVUSWBZrrkz_VPMOVWBZ256rr_VPMOVWBZ256rrk_VPMOVWBZ256rrkz_VPMOVWBZrr_VPMOVWBZrrk_VPMOVWBZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1221
  {DBGFIELD("VPMOVDBZrr_VPMOVDBZrrk_VPMOVDBZrrkz_VPMOVQBZrr_VPMOVQBZrrk_VPMOVQBZrrkz_VPMOVQWZrr_VPMOVQWZrrk_VPMOVQWZrrkz_VPMOVSDBZrr_VPMOVSDBZrrk_VPMOVSDBZrrkz_VPMOVSQBZrr_VPMOVSQBZrrk_VPMOVSQBZrrkz_VPMOVSQWZrr_VPMOVSQWZrrk_VPMOVSQWZrrkz_VPMOVUSDBZrr_VPMOVUSDBZrrk_VPMOVUSDBZrrkz_VPMOVUSQBZrr_VPMOVUSQBZrrk_VPMOVUSQBZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1222
  {DBGFIELD("VPMOVQDZ128mr_VPMOVQDZ128mrk_VPMOVQDZ256mr_VPMOVQDZ256mrk_VPMOVQDZmr_VPMOVQDZmrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1223
  {DBGFIELD("VCVTDQ2PDZ128rr_VCVTDQ2PDZ128rrk_VCVTDQ2PDZ128rrkz_VCVTUDQ2PDZ128rr_VCVTUDQ2PDZ128rrk_VCVTUDQ2PDZ128rrkz") 3, false, false, false, 2222, 3,  6, 1,  0, 0}, // #1224
  {DBGFIELD("VCVTPD2DQZ128rr_VCVTPD2DQZ128rrk_VCVTPD2DQZ128rrkz_VCVTPD2UDQZ128rr_VCVTPD2UDQZ128rrk_VCVTPD2UDQZ128rrkz_VCVTTPD2DQZ128rr_VCVTTPD2DQZ128rrk_VCVTTPD2DQZ128rrkz_VCVTTPD2UDQZ128rr_VCVTTPD2UDQZ128rrk_VCVTTPD2UDQZ128rrkz") 4, false, false, false, 2240, 3,  6, 1,  0, 0}, // #1225
  {DBGFIELD("VCVTPS2PDZ128rr_VCVTPS2PDZ128rrk_VCVTPS2PDZ128rrkz_CVTPS2PDrr_VCVTPS2PDrr") 4, false, false, false, 2222, 3,  6, 1,  0, 0}, // #1226
  {DBGFIELD("VCVTPS2QQZ128rr_VCVTPS2QQZ128rrk_VCVTPS2QQZ128rrkz_VCVTPS2UQQZ128rr_VCVTPS2UQQZ128rrk_VCVTPS2UQQZ128rrkz_VCVTTPS2QQZ128rr_VCVTTPS2QQZ128rrk_VCVTTPS2QQZ128rrkz_VCVTTPS2UQQZ128rr_VCVTTPS2UQQZ128rrk_VCVTTPS2UQQZ128rrkz") 3, false, false, false, 2222, 3,  3, 1,  0, 0}, // #1227
  {DBGFIELD("VCVTQQ2PSZ128rr_VCVTQQ2PSZ128rrk_VCVTQQ2PSZ128rrkz_VCVTUQQ2PSZ128rr_VCVTUQQ2PSZ128rrk_VCVTUQQ2PSZ128rrkz") 3, false, false, false, 2222, 3,  3, 1,  0, 0}, // #1228
  {DBGFIELD("VCVTSI2SSZrr_VCVTSI2SSZrr_Int_VCVTSI2SSZrrb_Int_CVTSI2SSrr_Int_VCVTSI2SSrr_VCVTSI2SSrr_Int_VCVTUSI2SSZrr_VCVTUSI2SSZrr_Int_VCVTUSI2SSZrrb_Int") 3, false, false, false, 2222, 3,  3, 1,  6, 1}, // #1229
  {DBGFIELD("VCVTSI2SDZrr_VCVTSI2SDZrr_Int_VCVTSI642SDZrr_VCVTSI642SDZrr_Int_VCVTSI642SDZrrb_Int_VCVTUSI2SDZrr_VCVTUSI2SDZrr_Int_VCVTUSI642SDZrr_VCVTUSI642SDZrr_Int_VCVTUSI642SDZrrb_Int") 3, false, false, false, 2222, 3,  3, 1,  6, 1}, // #1230
  {DBGFIELD("VCVTSS2SDZrr_VCVTSS2SDZrr_Int_VCVTSS2SDZrr_Intk_VCVTSS2SDZrr_Intkz_VCVTSS2SDZrrb_Int_VCVTSS2SDZrrb_Intk_VCVTSS2SDZrrb_Intkz_CVTSS2SDrr_CVTSS2SDrr_Int_VCVTSS2SDrr_VCVTSS2SDrr_Int") 3, false, false, false, 2222, 3,  3, 1,  0, 0}, // #1231
  {DBGFIELD("VPCONFLICTQZ128rr_VPCONFLICTQZ128rrk_VPCONFLICTQZ128rrkz") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1232
  {DBGFIELD("VCVTPS2PHZ128mr_VCVTPS2PHZ128mrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1233
  {DBGFIELD("VCVTPS2PHZ256mr_VCVTPS2PHZ256mrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1234
  {DBGFIELD("VCVTPS2PHZmr_VCVTPS2PHZmrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1235
  {DBGFIELD("VPMOVDBZ128mr_VPMOVDBZ128mrk_VPMOVDBZ256mr_VPMOVDBZ256mrk_VPMOVDBZmr_VPMOVDBZmrk_VPMOVDWZ128mr_VPMOVDWZ128mrk_VPMOVDWZ256mr_VPMOVDWZ256mrk_VPMOVDWZmr_VPMOVDWZmrk_VPMOVQBZ128mr_VPMOVQBZ128mrk_VPMOVQBZ256mr_VPMOVQBZ256mrk_VPMOVQBZmr_VPMOVQBZmrk_VPMOVQWZ128mr_VPMOVQWZ128mrk_VPMOVQWZ256mr_VPMOVQWZ256mrk_VPMOVQWZmr_VPMOVQWZmrk_VPMOVSDBZ128mr_VPMOVSDBZ128mrk_VPMOVSDBZ256mr_VPMOVSDBZ256mrk_VPMOVSDBZmr_VPMOVSDBZmrk_VPMOVSDWZ128mr_VPMOVSDWZ128mrk_VPMOVSDWZ256mr_VPMOVSDWZ256mrk_VPMOVSDWZmr_VPMOVSDWZmrk_VPMOVSQBZ128mr_VPMOVSQBZ128mrk_VPMOVSQBZ256mr_VPMOVSQBZ256mrk_VPMOVSQBZmr_VPMOVSQBZmrk_VPMOVSQDZ128mr_VPMOVSQDZ128mrk_VPMOVSQDZ256mr_VPMOVSQDZ256mrk_VPMOVSQDZmr_VPMOVSQDZmrk_VPMOVSQWZ128mr_VPMOVSQWZ128mrk_VPMOVSQWZ256mr_VPMOVSQWZ256mrk_VPMOVSQWZmr_VPMOVSQWZmrk_VPMOVSWBZ128mr_VPMOVSWBZ128mrk_VPMOVSWBZ256mr_VPMOVSWBZ256mrk_VPMOVSWBZmr_VPMOVSWBZmrk_VPMOVUSDBZ128mr_VPMOVUSDBZ128mrk_VPMOVUSDBZ256mr_VPMOVUSDBZ256mrk_VPMOVUSDBZmr_VPMOVUSDBZmrk_VPMOVUSDWZ128mr_VPMOVUSDWZ128mrk_VPMOVUSDWZ256mr_VPMOVUSDWZ256mrk_VPMOVUSDWZmr_VPMOVUSDWZmrk_VPMOVUSQBZ128mr_VPMOVUSQBZ128mrk_VPMOVUSQBZ256mr_VPMOVUSQBZ256mrk_VPMOVUSQBZmr_VPMOVUSQBZmrk_VPMOVUSQDZ128mr_VPMOVUSQDZ128mrk_VPMOVUSQDZ256mr_VPMOVUSQDZ256mrk_VPMOVUSQDZmr_VPMOVUSQDZmrk_VPMOVUSQWZ128mr_VPMOVUSQWZ128mrk_VPMOVUSQWZ256mr_VPMOVUSQWZ256mrk_VPMOVUSQWZmr_VPMOVUSQWZmrk_VPMOVUSWBZ128mr_VPMOVUSWBZ128mrk_VPMOVUSWBZ256mr_VPMOVUSWBZ256mrk_VPMOVUSWBZmr_VPMOVUSWBZmrk_VPMOVWBZ128mr_VPMOVWBZ128mrk_VPMOVWBZ256mr_VPMOVWBZ256mrk_VPMOVWBZmr_VPMOVWBZmrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1236
  {DBGFIELD("VCOMPRESSPDZ128rr_VCOMPRESSPDZ128rrk_VCOMPRESSPDZ128rrkz_VCOMPRESSPSZ128rr_VCOMPRESSPSZ128rrk_VCOMPRESSPSZ128rrkz_VPCOMPRESSDZ128rr_VPCOMPRESSDZ128rrk_VPCOMPRESSDZ128rrkz_VPCOMPRESSQZ128rr_VPCOMPRESSQZ128rrk_VPCOMPRESSQZ128rrkz_VPERMWZ128rr_VPERMWZ128rrk_VPERMWZ128rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1237
  {DBGFIELD("VCOMPRESSPDZ256rr_VCOMPRESSPDZ256rrk_VCOMPRESSPDZ256rrkz_VCOMPRESSPSZ256rr_VCOMPRESSPSZ256rrk_VCOMPRESSPSZ256rrkz_VPCOMPRESSDZ256rr_VPCOMPRESSDZ256rrk_VPCOMPRESSDZ256rrkz_VPCOMPRESSQZ256rr_VPCOMPRESSQZ256rrk_VPCOMPRESSQZ256rrkz_VPERMWZ256rr_VPERMWZ256rrk_VPERMWZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1238
  {DBGFIELD("VCOMPRESSPDZrr_VCOMPRESSPDZrrk_VCOMPRESSPDZrrkz_VCOMPRESSPSZrr_VCOMPRESSPSZrrk_VCOMPRESSPSZrrkz_VPCOMPRESSDZrr_VPCOMPRESSDZrrk_VPCOMPRESSDZrrkz_VPCOMPRESSQZrr_VPCOMPRESSQZrrk_VPCOMPRESSQZrrkz_VPERMWZrr_VPERMWZrrk_VPERMWZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1239
  {DBGFIELD("VMOV64toPQIZrm_VMOVQI2PQIZrm") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1240
  {DBGFIELD("VMOVDI2PDIZrm")      1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1241
  {DBGFIELD("VCVTSI642SSZrr_VCVTSI642SSZrr_Int_VCVTSI642SSZrrb_Int_VCVTUSI642SSZrr_VCVTUSI642SSZrr_Int_VCVTUSI642SSZrrb_Int") 3, false, false, false, 2222, 3,  3, 1,  6, 1}, // #1242
  {DBGFIELD("VMOVSDZrm_VMOVSDZrm_alt_VMOVSDZrmk_VMOVSDZrmkz_VMOVSSZrm_VMOVSSZrm_alt_VMOVSSZrmk_VMOVSSZrmkz") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1243
  {DBGFIELD("VCVTDQ2PDZ256rr_VCVTDQ2PDZ256rrk_VCVTDQ2PDZ256rrkz_VCVTUDQ2PDZ256rr_VCVTUDQ2PDZ256rrk_VCVTUDQ2PDZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1244
  {DBGFIELD("VCVTPD2DQZ256rr_VCVTPD2DQZ256rrk_VCVTPD2DQZ256rrkz_VCVTPD2UDQZ256rr_VCVTPD2UDQZ256rrk_VCVTPD2UDQZ256rrkz_VCVTTPD2DQZ256rr_VCVTTPD2DQZ256rrk_VCVTTPD2DQZ256rrkz_VCVTTPD2UDQZ256rr_VCVTTPD2UDQZ256rrk_VCVTTPD2UDQZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1245
  {DBGFIELD("VCVTPS2PDYrr_VCVTPS2PDZ256rr_VCVTPS2PDZ256rrk_VCVTPS2PDZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1246
  {DBGFIELD("VCVTPS2QQZ256rr_VCVTPS2QQZ256rrk_VCVTPS2QQZ256rrkz_VCVTPS2UQQZ256rr_VCVTPS2UQQZ256rrk_VCVTPS2UQQZ256rrkz_VCVTTPS2QQZ256rr_VCVTTPS2QQZ256rrk_VCVTTPS2QQZ256rrkz_VCVTTPS2UQQZ256rr_VCVTTPS2UQQZ256rrk_VCVTTPS2UQQZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1247
  {DBGFIELD("VCVTQQ2PSZ256rr_VCVTQQ2PSZ256rrk_VCVTQQ2PSZ256rrkz_VCVTUQQ2PSZ256rr_VCVTUQQ2PSZ256rrk_VCVTUQQ2PSZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1248
  {DBGFIELD("VCVTDQ2PDZrr_VCVTUDQ2PDZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1249
  {DBGFIELD("VCVTPD2DQZrr_VCVTPD2UDQZrr_VCVTTPD2DQZrr_VCVTTPD2UDQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1250
  {DBGFIELD("VCVTPS2PDZrr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1251
  {DBGFIELD("VCVTPS2QQZrr_VCVTPS2UQQZrr_VCVTTPS2QQZrr_VCVTTPS2UQQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1252
  {DBGFIELD("VCVTQQ2PSZrr_VCVTUQQ2PSZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1253
  {DBGFIELD("VMOVNTDQAZ128rm")    1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1254
  {DBGFIELD("VBLENDMPDZ128rm_VBLENDMPDZ128rmb_VBLENDMPDZ128rmbk_VBLENDMPDZ128rmbkz_VBLENDMPDZ128rmk_VBLENDMPDZ128rmkz_VBLENDMPSZ128rm_VBLENDMPSZ128rmb_VBLENDMPSZ128rmbk_VBLENDMPSZ128rmbkz_VBLENDMPSZ128rmk_VBLENDMPSZ128rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1255
  {DBGFIELD("VBROADCASTI32X2Z128rm_VBROADCASTI32X2Z128rmk_VBROADCASTI32X2Z128rmkz_VPBROADCASTDZ128rm_VPBROADCASTDZ128rmk_VPBROADCASTDZ128rmkz_VPBROADCASTQZ128rm_VPBROADCASTQZ128rmk_VPBROADCASTQZ128rmkz") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1256
  {DBGFIELD("VBROADCASTSSZ128rm_VBROADCASTSSZ128rmk_VBROADCASTSSZ128rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1257
  {DBGFIELD("VMOVAPDZ128rm_VMOVAPDZ128rmk_VMOVAPDZ128rmkz_VMOVAPSZ128rm_NOVLX_VMOVAPSZ128rm_VMOVAPSZ128rmk_VMOVAPSZ128rmkz_VMOVUPDZ128rm_VMOVUPDZ128rmk_VMOVUPDZ128rmkz_VMOVUPSZ128rm_NOVLX_VMOVUPSZ128rm_VMOVUPSZ128rmk_VMOVUPSZ128rmkz") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1258
  {DBGFIELD("VMOVDDUPZ128rm_VMOVDDUPZ128rmk_VMOVDDUPZ128rmkz_VMOVSHDUPZ128rm_VMOVSHDUPZ128rmk_VMOVSHDUPZ128rmkz_VMOVSLDUPZ128rm_VMOVSLDUPZ128rmk_VMOVSLDUPZ128rmkz") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1259
  {DBGFIELD("VMOVDQA32Z128rm_VMOVDQA32Z128rmk_VMOVDQA32Z128rmkz_VMOVDQA64Z128rm_VMOVDQA64Z128rmk_VMOVDQA64Z128rmkz_VMOVDQU16Z128rm_VMOVDQU16Z128rmk_VMOVDQU16Z128rmkz_VMOVDQU32Z128rm_VMOVDQU32Z128rmk_VMOVDQU32Z128rmkz_VMOVDQU64Z128rm_VMOVDQU64Z128rmk_VMOVDQU64Z128rmkz_VMOVDQU8Z128rm_VMOVDQU8Z128rmk_VMOVDQU8Z128rmkz") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1260
  {DBGFIELD("VPADDBZ128rm_VPADDBZ128rmk_VPADDBZ128rmkz_VPADDDZ128rm_VPADDDZ128rmb_VPADDDZ128rmbk_VPADDDZ128rmbkz_VPADDDZ128rmk_VPADDDZ128rmkz_VPADDQZ128rm_VPADDQZ128rmb_VPADDQZ128rmbk_VPADDQZ128rmbkz_VPADDQZ128rmk_VPADDQZ128rmkz_VPADDWZ128rm_VPADDWZ128rmk_VPADDWZ128rmkz_VPSUBBZ128rm_VPSUBBZ128rmk_VPSUBBZ128rmkz_VPSUBDZ128rm_VPSUBDZ128rmb_VPSUBDZ128rmbk_VPSUBDZ128rmbkz_VPSUBDZ128rmk_VPSUBDZ128rmkz_VPSUBQZ128rm_VPSUBQZ128rmb_VPSUBQZ128rmbk_VPSUBQZ128rmbkz_VPSUBQZ128rmk_VPSUBQZ128rmkz_VPSUBWZ128rm_VPSUBWZ128rmk_VPSUBWZ128rmkz_VPTERNLOGDZ128rmbi_VPTERNLOGDZ128rmbik_VPTERNLOGDZ128rmbikz_VPTERNLOGDZ128rmi_VPTERNLOGDZ128rmik_VPTERNLOGDZ128rmikz_VPTERNLOGQZ128rmbi_VPTERNLOGQZ128rmbik_VPTERNLOGQZ128rmbikz_VPTERNLOGQZ128rmi_VPTERNLOGQZ128rmik_VPTERNLOGQZ128rmikz") 1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #1261
  {DBGFIELD("VPBLENDMBZ128rm_VPBLENDMBZ128rmk_VPBLENDMBZ128rmkz_VPBLENDMDZ128rm_VPBLENDMDZ128rmb_VPBLENDMDZ128rmbk_VPBLENDMDZ128rmbkz_VPBLENDMDZ128rmk_VPBLENDMDZ128rmkz_VPBLENDMQZ128rm_VPBLENDMQZ128rmb_VPBLENDMQZ128rmbk_VPBLENDMQZ128rmbkz_VPBLENDMQZ128rmk_VPBLENDMQZ128rmkz_VPBLENDMWZ128rm_VPBLENDMWZ128rmk_VPBLENDMWZ128rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1262
  {DBGFIELD("VPERMI2W128rr_VPERMI2W128rrk_VPERMI2W128rrkz_VPERMT2W128rr_VPERMT2W128rrk_VPERMT2W128rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1263
  {DBGFIELD("VPERMI2W256rr_VPERMI2W256rrk_VPERMI2W256rrkz_VPERMT2W256rr_VPERMT2W256rrk_VPERMT2W256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1264
  {DBGFIELD("VPERMI2Wrr_VPERMI2Wrrk_VPERMI2Wrrkz_VPERMT2Wrr_VPERMT2Wrrk_VPERMT2Wrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1265
  {DBGFIELD("VCVTSS2SI64Zrr_VCVTSS2SI64Zrr_Int_VCVTSS2SI64Zrrb_Int_VCVTTSS2SI64Zrr_VCVTTSS2SI64Zrr_Int_VCVTTSS2SI64Zrrb_Int_VCVTSS2USI64Zrr_Int_VCVTSS2USI64Zrrb_Int_VCVTTSS2USI64Zrr_VCVTTSS2USI64Zrr_Int_VCVTTSS2USI64Zrrb_Int") 3, false, false, false, 2243, 3,  7, 1,  0, 0}, // #1266
  {DBGFIELD("KMOVBkm_KMOVDkm_KMOVQkm_KMOVWkm") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1267
  {DBGFIELD("VCOMPRESSPDZ128mr_VCOMPRESSPDZ128mrk_VCOMPRESSPDZ256mr_VCOMPRESSPDZ256mrk_VCOMPRESSPDZmr_VCOMPRESSPDZmrk_VCOMPRESSPSZ128mr_VCOMPRESSPSZ128mrk_VCOMPRESSPSZ256mr_VCOMPRESSPSZ256mrk_VCOMPRESSPSZmr_VCOMPRESSPSZmrk_VPCOMPRESSDZ128mr_VPCOMPRESSDZ128mrk_VPCOMPRESSDZ256mr_VPCOMPRESSDZ256mrk_VPCOMPRESSDZmr_VPCOMPRESSDZmrk_VPCOMPRESSQZ128mr_VPCOMPRESSQZ128mrk_VPCOMPRESSQZ256mr_VPCOMPRESSQZ256mrk_VPCOMPRESSQZmr_VPCOMPRESSQZmrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1268
  {DBGFIELD("VPSCATTERDQZ128mr_VPSCATTERQQZ128mr_VSCATTERDPDZ128mr_VSCATTERQPDZ128mr") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1269
  {DBGFIELD("VPSCATTERDQZ256mr_VPSCATTERQQZ256mr_VSCATTERDPDZ256mr_VSCATTERQPDZ256mr") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1270
  {DBGFIELD("VPSCATTERDQZmr_VPSCATTERQQZmr_VSCATTERDPDZmr_VSCATTERQPDZmr") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1271
  {DBGFIELD("VSCATTERDPSZmr")     1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1272
  {DBGFIELD("VPBROADCASTBZ256rm_VPBROADCASTBZ256rmk_VPBROADCASTBZ256rmkz_VPBROADCASTBZrm_VPBROADCASTBZrmk_VPBROADCASTBZrmkz_VPBROADCASTWZ256rm_VPBROADCASTWZ256rmk_VPBROADCASTWZ256rmkz_VPBROADCASTWZrm_VPBROADCASTWZrmk_VPBROADCASTWZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1273
  {DBGFIELD("VMOVNTDQAZ256rm")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1274
  {DBGFIELD("VBLENDMPDZ256rm_VBLENDMPDZ256rmb_VBLENDMPDZ256rmbk_VBLENDMPDZ256rmbkz_VBLENDMPDZ256rmk_VBLENDMPDZ256rmkz_VBLENDMPSZ256rm_VBLENDMPSZ256rmb_VBLENDMPSZ256rmbk_VBLENDMPSZ256rmbkz_VBLENDMPSZ256rmk_VBLENDMPSZ256rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1275
  {DBGFIELD("VBLENDMPDZrm_VBLENDMPDZrmb_VBLENDMPDZrmbk_VBLENDMPDZrmbkz_VBLENDMPDZrmk_VBLENDMPDZrmkz_VBLENDMPSZrm_VBLENDMPSZrmb_VBLENDMPSZrmbk_VBLENDMPSZrmbkz_VBLENDMPSZrmk_VBLENDMPSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1276
  {DBGFIELD("VBROADCASTF32X2Z256rm_VBROADCASTF32X2Z256rmk_VBROADCASTF32X2Z256rmkz_VBROADCASTF32X2Zrm_VBROADCASTF32X2Zrmk_VBROADCASTF32X2Zrmkz_VBROADCASTI32X2Z256rm_VBROADCASTI32X2Z256rmk_VBROADCASTI32X2Z256rmkz_VBROADCASTI32X2Zrm_VBROADCASTI32X2Zrmk_VBROADCASTI32X2Zrmkz_VPBROADCASTDZ256rm_VPBROADCASTDZ256rmk_VPBROADCASTDZ256rmkz_VPBROADCASTDZrm_VPBROADCASTDZrmk_VPBROADCASTDZrmkz_VPBROADCASTQZ256rm_VPBROADCASTQZ256rmk_VPBROADCASTQZ256rmkz_VPBROADCASTQZrm_VPBROADCASTQZrmk_VPBROADCASTQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1277
  {DBGFIELD("VBROADCASTF32X4Z256rm_VBROADCASTF32X4Z256rmk_VBROADCASTF32X4Z256rmkz_VBROADCASTF32X4rm_VBROADCASTF32X4rmk_VBROADCASTF32X4rmkz_VBROADCASTF32X8rm_VBROADCASTF32X8rmk_VBROADCASTF32X8rmkz_VBROADCASTF64X2Z128rm_VBROADCASTF64X2Z128rmk_VBROADCASTF64X2Z128rmkz_VBROADCASTF64X2rm_VBROADCASTF64X2rmk_VBROADCASTF64X2rmkz_VBROADCASTF64X4rm_VBROADCASTF64X4rmk_VBROADCASTF64X4rmkz_VBROADCASTI32X4Z256rm_VBROADCASTI32X4Z256rmk_VBROADCASTI32X4Z256rmkz_VBROADCASTI32X4rm_VBROADCASTI32X4rmk_VBROADCASTI32X4rmkz_VBROADCASTI32X8rm_VBROADCASTI32X8rmk_VBROADCASTI32X8rmkz_VBROADCASTI64X2Z128rm_VBROADCASTI64X2Z128rmk_VBROADCASTI64X2Z128rmkz_VBROADCASTI64X2rm_VBROADCASTI64X2rmk_VBROADCASTI64X2rmkz_VBROADCASTI64X4rm_VBROADCASTI64X4rmk_VBROADCASTI64X4rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1278
  {DBGFIELD("VBROADCASTSDZ256rm_VBROADCASTSDZ256rmk_VBROADCASTSDZ256rmkz_VBROADCASTSDZrm_VBROADCASTSDZrmk_VBROADCASTSDZrmkz_VBROADCASTSSZ256rm_VBROADCASTSSZ256rmk_VBROADCASTSSZ256rmkz_VBROADCASTSSZrm_VBROADCASTSSZrmk_VBROADCASTSSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1279
  {DBGFIELD("VINSERTF32x4Z256rm_VINSERTF32x4Z256rmk_VINSERTF32x4Z256rmkz_VINSERTF32x4Zrm_VINSERTF32x4Zrmk_VINSERTF32x4Zrmkz_VINSERTF32x8Zrm_VINSERTF32x8Zrmk_VINSERTF32x8Zrmkz_VINSERTF64x2Z256rm_VINSERTF64x2Z256rmk_VINSERTF64x2Z256rmkz_VINSERTF64x2Zrm_VINSERTF64x2Zrmk_VINSERTF64x2Zrmkz_VINSERTF64x4Zrm_VINSERTF64x4Zrmk_VINSERTF64x4Zrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1280
  {DBGFIELD("VINSERTI32x4Z256rm_VINSERTI32x4Z256rmk_VINSERTI32x4Z256rmkz_VINSERTI32x4Zrm_VINSERTI32x4Zrmk_VINSERTI32x4Zrmkz_VINSERTI32x8Zrm_VINSERTI32x8Zrmk_VINSERTI32x8Zrmkz_VINSERTI64x2Z256rm_VINSERTI64x2Z256rmk_VINSERTI64x2Z256rmkz_VINSERTI64x2Zrm_VINSERTI64x2Zrmk_VINSERTI64x2Zrmkz_VINSERTI64x4Zrm_VINSERTI64x4Zrmk_VINSERTI64x4Zrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1281
  {DBGFIELD("VMOVAPDZ256rm_VMOVAPDZ256rmk_VMOVAPDZ256rmkz_VMOVAPDZrm_VMOVAPDZrmk_VMOVAPDZrmkz_VMOVAPSZ256rm_NOVLX_VMOVAPSZ256rm_VMOVAPSZ256rmk_VMOVAPSZ256rmkz_VMOVAPSZrm_VMOVAPSZrmk_VMOVAPSZrmkz_VMOVUPDZ256rm_VMOVUPDZ256rmk_VMOVUPDZ256rmkz_VMOVUPDZrm_VMOVUPDZrmk_VMOVUPDZrmkz_VMOVUPSZ256rm_NOVLX_VMOVUPSZ256rm_VMOVUPSZ256rmk_VMOVUPSZ256rmkz_VMOVUPSZrm_VMOVUPSZrmk_VMOVUPSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1282
  {DBGFIELD("VMOVDDUPZ256rm_VMOVDDUPZ256rmk_VMOVDDUPZ256rmkz_VMOVSHDUPZ256rm_VMOVSHDUPZ256rmk_VMOVSHDUPZ256rmkz_VMOVSLDUPZ256rm_VMOVSLDUPZ256rmk_VMOVSLDUPZ256rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1283
  {DBGFIELD("VMOVDDUPZrm_VMOVDDUPZrmk_VMOVDDUPZrmkz_VMOVSHDUPZrm_VMOVSHDUPZrmk_VMOVSHDUPZrmkz_VMOVSLDUPZrm_VMOVSLDUPZrmk_VMOVSLDUPZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1284
  {DBGFIELD("VMOVDQA32Z256rm_VMOVDQA32Z256rmk_VMOVDQA32Z256rmkz_VMOVDQA32Zrm_VMOVDQA32Zrmk_VMOVDQA32Zrmkz_VMOVDQA64Z256rm_VMOVDQA64Z256rmk_VMOVDQA64Z256rmkz_VMOVDQA64Zrm_VMOVDQA64Zrmk_VMOVDQA64Zrmkz_VMOVDQU16Z256rm_VMOVDQU16Z256rmk_VMOVDQU16Z256rmkz_VMOVDQU16Zrm_VMOVDQU16Zrmk_VMOVDQU16Zrmkz_VMOVDQU32Z256rm_VMOVDQU32Z256rmk_VMOVDQU32Z256rmkz_VMOVDQU32Zrm_VMOVDQU32Zrmk_VMOVDQU32Zrmkz_VMOVDQU64Z256rm_VMOVDQU64Z256rmk_VMOVDQU64Z256rmkz_VMOVDQU64Zrm_VMOVDQU64Zrmk_VMOVDQU64Zrmkz_VMOVDQU8Z256rm_VMOVDQU8Z256rmk_VMOVDQU8Z256rmkz_VMOVDQU8Zrm_VMOVDQU8Zrmk_VMOVDQU8Zrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1285
  {DBGFIELD("VPADDBZ256rm_VPADDBZ256rmk_VPADDBZ256rmkz_VPADDDZ256rm_VPADDDZ256rmb_VPADDDZ256rmbk_VPADDDZ256rmbkz_VPADDDZ256rmk_VPADDDZ256rmkz_VPADDQZ256rm_VPADDQZ256rmb_VPADDQZ256rmbk_VPADDQZ256rmbkz_VPADDQZ256rmk_VPADDQZ256rmkz_VPADDWZ256rm_VPADDWZ256rmk_VPADDWZ256rmkz_VPSUBBZ256rm_VPSUBBZ256rmk_VPSUBBZ256rmkz_VPSUBDZ256rm_VPSUBDZ256rmb_VPSUBDZ256rmbk_VPSUBDZ256rmbkz_VPSUBDZ256rmk_VPSUBDZ256rmkz_VPSUBQZ256rm_VPSUBQZ256rmb_VPSUBQZ256rmbk_VPSUBQZ256rmbkz_VPSUBQZ256rmk_VPSUBQZ256rmkz_VPSUBWZ256rm_VPSUBWZ256rmk_VPSUBWZ256rmkz_VPTERNLOGDZ256rmbi_VPTERNLOGDZ256rmbik_VPTERNLOGDZ256rmbikz_VPTERNLOGDZ256rmi_VPTERNLOGDZ256rmik_VPTERNLOGDZ256rmikz_VPTERNLOGQZ256rmbi_VPTERNLOGQZ256rmbik_VPTERNLOGQZ256rmbikz_VPTERNLOGQZ256rmi_VPTERNLOGQZ256rmik_VPTERNLOGQZ256rmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1286
  {DBGFIELD("VPADDBZrm_VPADDBZrmk_VPADDBZrmkz_VPADDDZrm_VPADDDZrmb_VPADDDZrmbk_VPADDDZrmbkz_VPADDDZrmk_VPADDDZrmkz_VPADDQZrm_VPADDQZrmb_VPADDQZrmbk_VPADDQZrmbkz_VPADDQZrmk_VPADDQZrmkz_VPADDWZrm_VPADDWZrmk_VPADDWZrmkz_VPSUBBZrm_VPSUBBZrmk_VPSUBBZrmkz_VPSUBDZrm_VPSUBDZrmb_VPSUBDZrmbk_VPSUBDZrmbkz_VPSUBDZrmk_VPSUBDZrmkz_VPSUBQZrm_VPSUBQZrmb_VPSUBQZrmbk_VPSUBQZrmbkz_VPSUBQZrmk_VPSUBQZrmkz_VPSUBWZrm_VPSUBWZrmk_VPSUBWZrmkz_VPTERNLOGDZrmbi_VPTERNLOGDZrmbik_VPTERNLOGDZrmbikz_VPTERNLOGDZrmi_VPTERNLOGDZrmik_VPTERNLOGDZrmikz_VPTERNLOGQZrmbi_VPTERNLOGQZrmbik_VPTERNLOGQZrmbikz_VPTERNLOGQZrmi_VPTERNLOGQZrmik_VPTERNLOGQZrmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1287
  {DBGFIELD("VPBLENDMBZ256rm_VPBLENDMBZ256rmk_VPBLENDMBZ256rmkz_VPBLENDMDZ256rm_VPBLENDMDZ256rmb_VPBLENDMDZ256rmbk_VPBLENDMDZ256rmbkz_VPBLENDMDZ256rmk_VPBLENDMDZ256rmkz_VPBLENDMQZ256rm_VPBLENDMQZ256rmb_VPBLENDMQZ256rmbk_VPBLENDMQZ256rmbkz_VPBLENDMQZ256rmk_VPBLENDMQZ256rmkz_VPBLENDMWZ256rm_VPBLENDMWZ256rmk_VPBLENDMWZ256rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1288
  {DBGFIELD("VPBLENDMBZrm_VPBLENDMBZrmk_VPBLENDMBZrmkz_VPBLENDMDZrm_VPBLENDMDZrmb_VPBLENDMDZrmbk_VPBLENDMDZrmbkz_VPBLENDMDZrmk_VPBLENDMDZrmkz_VPBLENDMQZrm_VPBLENDMQZrmb_VPBLENDMQZrmbk_VPBLENDMQZrmbkz_VPBLENDMQZrmk_VPBLENDMQZrmkz_VPBLENDMWZrm_VPBLENDMWZrmk_VPBLENDMWZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1289
  {DBGFIELD("VPSCATTERQDZ128mr_VPSCATTERQDZ256mr_VSCATTERQPSZ128mr_VSCATTERQPSZ256mr") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1290
  {DBGFIELD("VPSCATTERDDZ128mr_VSCATTERDPSZ128mr") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1291
  {DBGFIELD("VPSCATTERDDZ256mr_VSCATTERDPSZ256mr") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1292
  {DBGFIELD("VPSCATTERDDZmr")     1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1293
  {DBGFIELD("VALIGNDZ128rmbi_VALIGNDZ128rmbik_VALIGNDZ128rmbikz_VALIGNDZ128rmi_VALIGNDZ128rmik_VALIGNDZ128rmikz_VALIGNQZ128rmbi_VALIGNQZ128rmbik_VALIGNQZ128rmbikz_VALIGNQZ128rmi_VALIGNQZ128rmik_VALIGNQZ128rmikz") 1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #1294
  {DBGFIELD("VFPCLASSSDZrm_VFPCLASSSDZrmk_VFPCLASSSSZrm_VFPCLASSSSZrmk") 1, false, false, false, 269, 3, 10, 1, 15, 1}, // #1295
  {DBGFIELD("VPERMI2D128rm_VPERMI2D128rmb_VPERMI2D128rmbk_VPERMI2D128rmbkz_VPERMI2D128rmk_VPERMI2D128rmkz_VPERMI2Q128rm_VPERMI2Q128rmb_VPERMI2Q128rmbk_VPERMI2Q128rmbkz_VPERMI2Q128rmk_VPERMI2Q128rmkz_VPERMT2D128rm_VPERMT2D128rmb_VPERMT2D128rmbk_VPERMT2D128rmbkz_VPERMT2D128rmk_VPERMT2D128rmkz_VPERMT2Q128rm_VPERMT2Q128rmb_VPERMT2Q128rmbk_VPERMT2Q128rmbkz_VPERMT2Q128rmk_VPERMT2Q128rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1296
  {DBGFIELD("VPERMI2PD128rm_VPERMI2PD128rmb_VPERMI2PD128rmbk_VPERMI2PD128rmbkz_VPERMI2PD128rmk_VPERMI2PD128rmkz_VPERMI2PS128rm_VPERMI2PS128rmb_VPERMI2PS128rmbk_VPERMI2PS128rmbkz_VPERMI2PS128rmk_VPERMI2PS128rmkz_VPERMT2PD128rm_VPERMT2PD128rmb_VPERMT2PD128rmbk_VPERMT2PD128rmbkz_VPERMT2PD128rmk_VPERMT2PD128rmkz_VPERMT2PS128rm_VPERMT2PS128rmb_VPERMT2PS128rmbk_VPERMT2PS128rmbkz_VPERMT2PS128rmk_VPERMT2PS128rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1297
  {DBGFIELD("VPMAXSQZ128rm_VPMAXSQZ128rmb_VPMAXSQZ128rmbk_VPMAXSQZ128rmbkz_VPMAXSQZ128rmk_VPMAXSQZ128rmkz_VPMAXUQZ128rm_VPMAXUQZ128rmb_VPMAXUQZ128rmbk_VPMAXUQZ128rmbkz_VPMAXUQZ128rmk_VPMAXUQZ128rmkz_VPMINSQZ128rm_VPMINSQZ128rmb_VPMINSQZ128rmbk_VPMINSQZ128rmbkz_VPMINSQZ128rmk_VPMINSQZ128rmkz_VPMINUQZ128rm_VPMINUQZ128rmb_VPMINUQZ128rmbk_VPMINUQZ128rmbkz_VPMINUQZ128rmk_VPMINUQZ128rmkz") 1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #1298
  {DBGFIELD("VCMPPDZ128rmbi_VCMPPDZ128rmbik_VCMPPDZ128rmi_VCMPPDZ128rmik_VCMPPSZ128rmbi_VCMPPSZ128rmbik_VCMPPSZ128rmi_VCMPPSZ128rmik_VFPCLASSPDZ128rm_VFPCLASSPDZ128rmb_VFPCLASSPDZ128rmbk_VFPCLASSPDZ128rmk_VFPCLASSPSZ128rm_VFPCLASSPSZ128rmb_VFPCLASSPSZ128rmbk_VFPCLASSPSZ128rmk") 4, false, false, false, 2222, 3,  6, 1, 15, 1}, // #1299
  {DBGFIELD("VCMPSDZrm_VCMPSDZrm_Int_VCMPSDZrm_Intk_VCMPSSZrm_VCMPSSZrm_Int_VCMPSSZrm_Intk") 1, false, false, false, 269, 3, 10, 1, 15, 1}, // #1300
  {DBGFIELD("VPCMPBZ128rmi_VPCMPBZ128rmik_VPCMPDZ128rmi_VPCMPDZ128rmib_VPCMPDZ128rmibk_VPCMPDZ128rmik_VPCMPEQBZ128rm_VPCMPEQBZ128rmk_VPCMPEQDZ128rm_VPCMPEQDZ128rmb_VPCMPEQDZ128rmbk_VPCMPEQDZ128rmk_VPCMPEQQZ128rm_VPCMPEQQZ128rmb_VPCMPEQQZ128rmbk_VPCMPEQQZ128rmk_VPCMPEQWZ128rm_VPCMPEQWZ128rmk_VPCMPGTBZ128rm_VPCMPGTBZ128rmk_VPCMPGTDZ128rm_VPCMPGTDZ128rmb_VPCMPGTDZ128rmbk_VPCMPGTDZ128rmk_VPCMPGTQZ128rm_VPCMPGTQZ128rmb_VPCMPGTQZ128rmbk_VPCMPGTQZ128rmk_VPCMPGTWZ128rm_VPCMPGTWZ128rmk_VPCMPQZ128rmi_VPCMPQZ128rmib_VPCMPQZ128rmibk_VPCMPQZ128rmik_VPCMPUBZ128rmi_VPCMPUBZ128rmik_VPCMPUDZ128rmi_VPCMPUDZ128rmib_VPCMPUDZ128rmibk_VPCMPUDZ128rmik_VPCMPUQZ128rmi_VPCMPUQZ128rmib_VPCMPUQZ128rmibk_VPCMPUQZ128rmik_VPCMPUWZ128rmi_VPCMPUWZ128rmik_VPCMPWZ128rmi_VPCMPWZ128rmik") 1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #1301
  {DBGFIELD("VPTESTMBZ128rm_VPTESTMBZ128rmk_VPTESTMDZ128rm_VPTESTMDZ128rmb_VPTESTMDZ128rmbk_VPTESTMDZ128rmk_VPTESTMQZ128rm_VPTESTMQZ128rmb_VPTESTMQZ128rmbk_VPTESTMQZ128rmk_VPTESTMWZ128rm_VPTESTMWZ128rmk_VPTESTNMBZ128rm_VPTESTNMBZ128rmk_VPTESTNMDZ128rm_VPTESTNMDZ128rmb_VPTESTNMDZ128rmbk_VPTESTNMDZ128rmk_VPTESTNMQZ128rm_VPTESTNMQZ128rmb_VPTESTNMQZ128rmbk_VPTESTNMQZ128rmk_VPTESTNMWZ128rm_VPTESTNMWZ128rmk") 1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #1302
  {DBGFIELD("CVTPS2PDrm_VCVTPS2PDrm") 5, false, false, false, 2240, 3,  7, 1,  0, 0}, // #1303
  {DBGFIELD("VALIGNDZ256rmbi_VALIGNDZ256rmbik_VALIGNDZ256rmbikz_VALIGNDZ256rmi_VALIGNDZ256rmik_VALIGNDZ256rmikz_VALIGNQZ256rmbi_VALIGNQZ256rmbik_VALIGNQZ256rmbikz_VALIGNQZ256rmi_VALIGNQZ256rmik_VALIGNQZ256rmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1304
  {DBGFIELD("VALIGNDZrmbi_VALIGNDZrmbik_VALIGNDZrmbikz_VALIGNDZrmi_VALIGNDZrmik_VALIGNDZrmikz_VALIGNQZrmbi_VALIGNQZrmbik_VALIGNQZrmbikz_VALIGNQZrmi_VALIGNQZrmik_VALIGNQZrmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1305
  {DBGFIELD("VPMAXSQZ256rm_VPMAXSQZ256rmb_VPMAXSQZ256rmbk_VPMAXSQZ256rmbkz_VPMAXSQZ256rmk_VPMAXSQZ256rmkz_VPMAXUQZ256rm_VPMAXUQZ256rmb_VPMAXUQZ256rmbk_VPMAXUQZ256rmbkz_VPMAXUQZ256rmk_VPMAXUQZ256rmkz_VPMINSQZ256rm_VPMINSQZ256rmb_VPMINSQZ256rmbk_VPMINSQZ256rmbkz_VPMINSQZ256rmk_VPMINSQZ256rmkz_VPMINUQZ256rm_VPMINUQZ256rmb_VPMINUQZ256rmbk_VPMINUQZ256rmbkz_VPMINUQZ256rmk_VPMINUQZ256rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1306
  {DBGFIELD("VPMAXSQZrm_VPMAXSQZrmb_VPMAXSQZrmbk_VPMAXSQZrmbkz_VPMAXSQZrmk_VPMAXSQZrmkz_VPMAXUQZrm_VPMAXUQZrmb_VPMAXUQZrmbk_VPMAXUQZrmbkz_VPMAXUQZrmk_VPMAXUQZrmkz_VPMINSQZrm_VPMINSQZrmb_VPMINSQZrmbk_VPMINSQZrmbkz_VPMINSQZrmk_VPMINSQZrmkz_VPMINUQZrm_VPMINUQZrmb_VPMINUQZrmbk_VPMINUQZrmbkz_VPMINUQZrmk_VPMINUQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1307
  {DBGFIELD("VCMPPDZ256rmbi_VCMPPDZ256rmbik_VCMPPDZ256rmi_VCMPPDZ256rmik_VCMPPSZ256rmbi_VCMPPSZ256rmbik_VCMPPSZ256rmi_VCMPPSZ256rmik_VFPCLASSPDZ256rm_VFPCLASSPDZ256rmb_VFPCLASSPDZ256rmbk_VFPCLASSPDZ256rmk_VFPCLASSPSZ256rm_VFPCLASSPSZ256rmb_VFPCLASSPSZ256rmbk_VFPCLASSPSZ256rmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1308
  {DBGFIELD("VCMPPDZrmbi_VCMPPDZrmbik_VCMPPDZrmi_VCMPPDZrmik_VCMPPSZrmbi_VCMPPSZrmbik_VCMPPSZrmi_VCMPPSZrmik_VFPCLASSPDZrm_VFPCLASSPDZrmb_VFPCLASSPDZrmbk_VFPCLASSPDZrmk_VFPCLASSPSZrm_VFPCLASSPSZrmb_VFPCLASSPSZrmbk_VFPCLASSPSZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1309
  {DBGFIELD("VPCMPBZ256rmi_VPCMPBZ256rmik_VPCMPDZ256rmi_VPCMPDZ256rmib_VPCMPDZ256rmibk_VPCMPDZ256rmik_VPCMPEQBZ256rm_VPCMPEQBZ256rmk_VPCMPEQDZ256rm_VPCMPEQDZ256rmb_VPCMPEQDZ256rmbk_VPCMPEQDZ256rmk_VPCMPEQQZ256rm_VPCMPEQQZ256rmb_VPCMPEQQZ256rmbk_VPCMPEQQZ256rmk_VPCMPEQWZ256rm_VPCMPEQWZ256rmk_VPCMPGTBZ256rm_VPCMPGTBZ256rmk_VPCMPGTDZ256rm_VPCMPGTDZ256rmb_VPCMPGTDZ256rmbk_VPCMPGTDZ256rmk_VPCMPGTQZ256rm_VPCMPGTQZ256rmb_VPCMPGTQZ256rmbk_VPCMPGTQZ256rmk_VPCMPGTWZ256rm_VPCMPGTWZ256rmk_VPCMPQZ256rmi_VPCMPQZ256rmib_VPCMPQZ256rmibk_VPCMPQZ256rmik_VPCMPUBZ256rmi_VPCMPUBZ256rmik_VPCMPUDZ256rmi_VPCMPUDZ256rmib_VPCMPUDZ256rmibk_VPCMPUDZ256rmik_VPCMPUQZ256rmi_VPCMPUQZ256rmib_VPCMPUQZ256rmibk_VPCMPUQZ256rmik_VPCMPUWZ256rmi_VPCMPUWZ256rmik_VPCMPWZ256rmi_VPCMPWZ256rmik") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1310
  {DBGFIELD("VPCMPBZrmi_VPCMPBZrmik_VPCMPDZrmi_VPCMPDZrmib_VPCMPDZrmibk_VPCMPDZrmik_VPCMPEQBZrm_VPCMPEQBZrmk_VPCMPEQDZrm_VPCMPEQDZrmb_VPCMPEQDZrmbk_VPCMPEQDZrmk_VPCMPEQQZrm_VPCMPEQQZrmb_VPCMPEQQZrmbk_VPCMPEQQZrmk_VPCMPEQWZrm_VPCMPEQWZrmk_VPCMPGTBZrm_VPCMPGTBZrmk_VPCMPGTDZrm_VPCMPGTDZrmb_VPCMPGTDZrmbk_VPCMPGTDZrmk_VPCMPGTQZrm_VPCMPGTQZrmb_VPCMPGTQZrmbk_VPCMPGTQZrmk_VPCMPGTWZrm_VPCMPGTWZrmk_VPCMPQZrmi_VPCMPQZrmib_VPCMPQZrmibk_VPCMPQZrmik_VPCMPUBZrmi_VPCMPUBZrmik_VPCMPUDZrmi_VPCMPUDZrmib_VPCMPUDZrmibk_VPCMPUDZrmik_VPCMPUQZrmi_VPCMPUQZrmib_VPCMPUQZrmibk_VPCMPUQZrmik_VPCMPUWZrmi_VPCMPUWZrmik_VPCMPWZrmi_VPCMPWZrmik") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1311
  {DBGFIELD("VPTESTMBZ256rm_VPTESTMBZ256rmk_VPTESTMDZ256rm_VPTESTMDZ256rmb_VPTESTMDZ256rmbk_VPTESTMDZ256rmk_VPTESTMQZ256rm_VPTESTMQZ256rmb_VPTESTMQZ256rmbk_VPTESTMQZ256rmk_VPTESTMWZ256rm_VPTESTMWZ256rmk_VPTESTNMBZ256rm_VPTESTNMBZ256rmk_VPTESTNMDZ256rm_VPTESTNMDZ256rmb_VPTESTNMDZ256rmbk_VPTESTNMDZ256rmk_VPTESTNMQZ256rm_VPTESTNMQZ256rmb_VPTESTNMQZ256rmbk_VPTESTNMQZ256rmk_VPTESTNMWZ256rm_VPTESTNMWZ256rmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1312
  {DBGFIELD("VPTESTMBZrm_VPTESTMBZrmk_VPTESTMDZrm_VPTESTMDZrmb_VPTESTMDZrmbk_VPTESTMDZrmk_VPTESTMQZrm_VPTESTMQZrmb_VPTESTMQZrmbk_VPTESTMQZrmk_VPTESTMWZrm_VPTESTMWZrmk_VPTESTNMBZrm_VPTESTNMBZrmk_VPTESTNMDZrm_VPTESTNMDZrmb_VPTESTNMDZrmbk_VPTESTNMDZrmk_VPTESTNMQZrm_VPTESTNMQZrmb_VPTESTNMQZrmbk_VPTESTNMQZrmk_VPTESTNMWZrm_VPTESTNMWZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1313
  {DBGFIELD("VCVTDQ2PDZ128rm_VCVTDQ2PDZ128rmb_VCVTDQ2PDZ128rmbk_VCVTDQ2PDZ128rmbkz_VCVTDQ2PDZ128rmk_VCVTDQ2PDZ128rmkz_VCVTQQ2PDZ128rm_VCVTQQ2PDZ128rmb_VCVTQQ2PDZ128rmbk_VCVTQQ2PDZ128rmbkz_VCVTQQ2PDZ128rmk_VCVTQQ2PDZ128rmkz_VCVTUDQ2PDZ128rm_VCVTUDQ2PDZ128rmb_VCVTUDQ2PDZ128rmbk_VCVTUDQ2PDZ128rmbkz_VCVTUDQ2PDZ128rmk_VCVTUDQ2PDZ128rmkz_VCVTUQQ2PDZ128rm_VCVTUQQ2PDZ128rmb_VCVTUQQ2PDZ128rmbk_VCVTUQQ2PDZ128rmbkz_VCVTUQQ2PDZ128rmk_VCVTUQQ2PDZ128rmkz") 4, false, false, false, 2240, 3,  7, 1,  0, 0}, // #1314
  {DBGFIELD("VCVTDQ2PSZ128rm_VCVTDQ2PSZ128rmb_VCVTDQ2PSZ128rmbk_VCVTDQ2PSZ128rmbkz_VCVTDQ2PSZ128rmk_VCVTDQ2PSZ128rmkz_CVTDQ2PSrm_VCVTDQ2PSrm_VCVTQQ2PSZ128rm_VCVTQQ2PSZ128rmb_VCVTQQ2PSZ128rmbk_VCVTQQ2PSZ128rmbkz_VCVTQQ2PSZ128rmk_VCVTQQ2PSZ128rmkz_VCVTUDQ2PSZ128rm_VCVTUDQ2PSZ128rmb_VCVTUDQ2PSZ128rmbk_VCVTUDQ2PSZ128rmbkz_VCVTUDQ2PSZ128rmk_VCVTUDQ2PSZ128rmkz_VCVTUQQ2PSZ128rm_VCVTUQQ2PSZ128rmb_VCVTUQQ2PSZ128rmbk_VCVTUQQ2PSZ128rmbkz_VCVTUQQ2PSZ128rmk_VCVTUQQ2PSZ128rmkz") 4, false, false, false, 2240, 3,  6, 1,  0, 0}, // #1315
  {DBGFIELD("VCVTPD2QQZ128rm_VCVTPD2QQZ128rmb_VCVTPD2QQZ128rmbk_VCVTPD2QQZ128rmbkz_VCVTPD2QQZ128rmk_VCVTPD2QQZ128rmkz_VCVTPD2UQQZ128rm_VCVTPD2UQQZ128rmb_VCVTPD2UQQZ128rmbk_VCVTPD2UQQZ128rmbkz_VCVTPD2UQQZ128rmk_VCVTPD2UQQZ128rmkz_VCVTTPD2QQZ128rm_VCVTTPD2QQZ128rmb_VCVTTPD2QQZ128rmbk_VCVTTPD2QQZ128rmbkz_VCVTTPD2QQZ128rmk_VCVTTPD2QQZ128rmkz_VCVTTPD2UQQZ128rm_VCVTTPD2UQQZ128rmb_VCVTTPD2UQQZ128rmbk_VCVTTPD2UQQZ128rmbkz_VCVTTPD2UQQZ128rmk_VCVTTPD2UQQZ128rmkz") 5, false, false, false, 2243, 3,  7, 1,  0, 0}, // #1316
  {DBGFIELD("VCVTPH2PSZ128rm_VCVTPH2PSZ128rmk_VCVTPH2PSZ128rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1317
  {DBGFIELD("VCVTPS2DQZ128rm_VCVTPS2DQZ128rmb_VCVTPS2DQZ128rmbk_VCVTPS2DQZ128rmbkz_VCVTPS2DQZ128rmk_VCVTPS2DQZ128rmkz_CVTPS2DQrm_VCVTPS2DQrm_VCVTPS2QQZ128rm_VCVTPS2QQZ128rmb_VCVTPS2QQZ128rmbk_VCVTPS2QQZ128rmbkz_VCVTPS2QQZ128rmk_VCVTPS2QQZ128rmkz_VCVTPS2UDQZ128rm_VCVTPS2UDQZ128rmb_VCVTPS2UDQZ128rmbk_VCVTPS2UDQZ128rmbkz_VCVTPS2UDQZ128rmk_VCVTPS2UDQZ128rmkz_VCVTPS2UQQZ128rm_VCVTPS2UQQZ128rmb_VCVTPS2UQQZ128rmbk_VCVTPS2UQQZ128rmbkz_VCVTPS2UQQZ128rmk_VCVTPS2UQQZ128rmkz_VCVTTPS2DQZ128rm_VCVTTPS2DQZ128rmb_VCVTTPS2DQZ128rmbk_VCVTTPS2DQZ128rmbkz_VCVTTPS2DQZ128rmk_VCVTTPS2DQZ128rmkz_CVTTPS2DQrm_VCVTTPS2DQrm_VCVTTPS2QQZ128rm_VCVTTPS2QQZ128rmb_VCVTTPS2QQZ128rmbk_VCVTTPS2QQZ128rmbkz_VCVTTPS2QQZ128rmk_VCVTTPS2QQZ128rmkz_VCVTTPS2UDQZ128rm_VCVTTPS2UDQZ128rmb_VCVTTPS2UDQZ128rmbk_VCVTTPS2UDQZ128rmbkz_VCVTTPS2UDQZ128rmk_VCVTTPS2UDQZ128rmkz_VCVTTPS2UQQZ128rm_VCVTTPS2UQQZ128rmb_VCVTTPS2UQQZ128rmbk_VCVTTPS2UQQZ128rmbkz_VCVTTPS2UQQZ128rmk_VCVTTPS2UQQZ128rmkz") 4, false, false, false, 2240, 3,  6, 1,  0, 0}, // #1318
  {DBGFIELD("VCVTPS2PDZ128rm_VCVTPS2PDZ128rmb_VCVTPS2PDZ128rmbk_VCVTPS2PDZ128rmbkz_VCVTPS2PDZ128rmk_VCVTPS2PDZ128rmkz") 5, false, false, false, 2240, 3,  7, 1,  0, 0}, // #1319
  {DBGFIELD("VCVTSS2SDZrm_VCVTSS2SDZrm_Int_VCVTSS2SDZrm_Intk_VCVTSS2SDZrm_Intkz_CVTSS2SDrm_CVTSS2SDrm_Int_VCVTSS2SDrm_VCVTSS2SDrm_Int") 4, false, false, false, 2240, 3,  6, 1, 15, 1}, // #1320
  {DBGFIELD("VEXPANDPDZ128rm_VEXPANDPDZ128rmk_VEXPANDPDZ128rmkz_VEXPANDPSZ128rm_VEXPANDPSZ128rmk_VEXPANDPSZ128rmkz_VPEXPANDDZ128rm_VPEXPANDDZ128rmk_VPEXPANDDZ128rmkz_VPEXPANDQZ128rm_VPEXPANDQZ128rmk_VPEXPANDQZ128rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1321
  {DBGFIELD("VCVTDQ2PSYrm")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1322
  {DBGFIELD("VCVTPS2PDYrm")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1323
  {DBGFIELD("VCVTDQ2PDZ256rm_VCVTDQ2PDZ256rmb_VCVTDQ2PDZ256rmbk_VCVTDQ2PDZ256rmbkz_VCVTDQ2PDZ256rmk_VCVTDQ2PDZ256rmkz_VCVTQQ2PDZ256rm_VCVTQQ2PDZ256rmb_VCVTQQ2PDZ256rmbk_VCVTQQ2PDZ256rmbkz_VCVTQQ2PDZ256rmk_VCVTQQ2PDZ256rmkz_VCVTUDQ2PDZ256rm_VCVTUDQ2PDZ256rmb_VCVTUDQ2PDZ256rmbk_VCVTUDQ2PDZ256rmbkz_VCVTUDQ2PDZ256rmk_VCVTUDQ2PDZ256rmkz_VCVTUQQ2PDZ256rm_VCVTUQQ2PDZ256rmb_VCVTUQQ2PDZ256rmbk_VCVTUQQ2PDZ256rmbkz_VCVTUQQ2PDZ256rmk_VCVTUQQ2PDZ256rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1324
  {DBGFIELD("VCVTDQ2PDZrm_VCVTDQ2PDZrmb_VCVTDQ2PDZrmbk_VCVTDQ2PDZrmbkz_VCVTDQ2PDZrmk_VCVTDQ2PDZrmkz_VCVTQQ2PDZrm_VCVTQQ2PDZrmb_VCVTQQ2PDZrmbk_VCVTQQ2PDZrmbkz_VCVTQQ2PDZrmk_VCVTQQ2PDZrmkz_VCVTUDQ2PDZrm_VCVTUDQ2PDZrmb_VCVTUDQ2PDZrmbk_VCVTUDQ2PDZrmbkz_VCVTUDQ2PDZrmk_VCVTUDQ2PDZrmkz_VCVTUQQ2PDZrm_VCVTUQQ2PDZrmb_VCVTUQQ2PDZrmbk_VCVTUQQ2PDZrmbkz_VCVTUQQ2PDZrmk_VCVTUQQ2PDZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1325
  {DBGFIELD("VCVTDQ2PSZ256rm_VCVTDQ2PSZ256rmb_VCVTDQ2PSZ256rmbk_VCVTDQ2PSZ256rmbkz_VCVTDQ2PSZ256rmk_VCVTDQ2PSZ256rmkz_VCVTQQ2PSZ256rm_VCVTQQ2PSZ256rmb_VCVTQQ2PSZ256rmbk_VCVTQQ2PSZ256rmbkz_VCVTQQ2PSZ256rmk_VCVTQQ2PSZ256rmkz_VCVTUDQ2PSZ256rm_VCVTUDQ2PSZ256rmb_VCVTUDQ2PSZ256rmbk_VCVTUDQ2PSZ256rmbkz_VCVTUDQ2PSZ256rmk_VCVTUDQ2PSZ256rmkz_VCVTUQQ2PSZ256rm_VCVTUQQ2PSZ256rmb_VCVTUQQ2PSZ256rmbk_VCVTUQQ2PSZ256rmbkz_VCVTUQQ2PSZ256rmk_VCVTUQQ2PSZ256rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1326
  {DBGFIELD("VCVTDQ2PSZrm_VCVTDQ2PSZrmb_VCVTDQ2PSZrmbk_VCVTDQ2PSZrmbkz_VCVTDQ2PSZrmk_VCVTDQ2PSZrmkz_VCVTUDQ2PSZrm_VCVTUDQ2PSZrmb_VCVTUDQ2PSZrmbk_VCVTUDQ2PSZrmbkz_VCVTUDQ2PSZrmk_VCVTUDQ2PSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1327
  {DBGFIELD("VCVTPH2PSZ256rm_VCVTPH2PSZ256rmk_VCVTPH2PSZ256rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1328
  {DBGFIELD("VCVTPH2PSZrm_VCVTPH2PSZrmk_VCVTPH2PSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1329
  {DBGFIELD("VCVTPS2PDZ256rm_VCVTPS2PDZ256rmb_VCVTPS2PDZ256rmbk_VCVTPS2PDZ256rmbkz_VCVTPS2PDZ256rmk_VCVTPS2PDZ256rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1330
  {DBGFIELD("VCVTPS2PDZrm_VCVTPS2PDZrmb_VCVTPS2PDZrmbk_VCVTPS2PDZrmbkz_VCVTPS2PDZrmk_VCVTPS2PDZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1331
  {DBGFIELD("VCVTPD2QQZ256rm_VCVTPD2QQZ256rmb_VCVTPD2QQZ256rmbk_VCVTPD2QQZ256rmbkz_VCVTPD2QQZ256rmk_VCVTPD2QQZ256rmkz_VCVTTPD2QQZ256rm_VCVTTPD2QQZ256rmb_VCVTTPD2QQZ256rmbk_VCVTTPD2QQZ256rmbkz_VCVTTPD2QQZ256rmk_VCVTTPD2QQZ256rmkz_VCVTPD2UQQZ256rm_VCVTPD2UQQZ256rmb_VCVTPD2UQQZ256rmbk_VCVTPD2UQQZ256rmbkz_VCVTPD2UQQZ256rmk_VCVTPD2UQQZ256rmkz_VCVTTPD2UQQZ256rm_VCVTTPD2UQQZ256rmb_VCVTTPD2UQQZ256rmbk_VCVTTPD2UQQZ256rmbkz_VCVTTPD2UQQZ256rmk_VCVTTPD2UQQZ256rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1332
  {DBGFIELD("VCVTPD2QQZrm_VCVTPD2QQZrmb_VCVTPD2QQZrmbk_VCVTPD2QQZrmbkz_VCVTPD2QQZrmk_VCVTPD2QQZrmkz_VCVTTPD2QQZrm_VCVTTPD2QQZrmb_VCVTTPD2QQZrmbk_VCVTTPD2QQZrmbkz_VCVTTPD2QQZrmk_VCVTTPD2QQZrmkz_VCVTPD2UQQZrm_VCVTPD2UQQZrmb_VCVTPD2UQQZrmbk_VCVTPD2UQQZrmbkz_VCVTPD2UQQZrmk_VCVTPD2UQQZrmkz_VCVTTPD2UQQZrm_VCVTTPD2UQQZrmb_VCVTTPD2UQQZrmbk_VCVTTPD2UQQZrmbkz_VCVTTPD2UQQZrmk_VCVTTPD2UQQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1333
  {DBGFIELD("VCVTPS2DQYrm_VCVTTPS2DQYrm_VCVTPS2DQZ256rm_VCVTPS2DQZ256rmb_VCVTPS2DQZ256rmbk_VCVTPS2DQZ256rmbkz_VCVTPS2DQZ256rmk_VCVTPS2DQZ256rmkz_VCVTTPS2DQZ256rm_VCVTTPS2DQZ256rmb_VCVTTPS2DQZ256rmbk_VCVTTPS2DQZ256rmbkz_VCVTTPS2DQZ256rmk_VCVTTPS2DQZ256rmkz_VCVTPS2QQZ256rm_VCVTPS2QQZ256rmb_VCVTPS2QQZ256rmbk_VCVTPS2QQZ256rmbkz_VCVTPS2QQZ256rmk_VCVTPS2QQZ256rmkz_VCVTTPS2QQZ256rm_VCVTTPS2QQZ256rmb_VCVTTPS2QQZ256rmbk_VCVTTPS2QQZ256rmbkz_VCVTTPS2QQZ256rmk_VCVTTPS2QQZ256rmkz_VCVTPS2UDQZ256rm_VCVTPS2UDQZ256rmb_VCVTPS2UDQZ256rmbk_VCVTPS2UDQZ256rmbkz_VCVTPS2UDQZ256rmk_VCVTPS2UDQZ256rmkz_VCVTTPS2UDQZ256rm_VCVTTPS2UDQZ256rmb_VCVTTPS2UDQZ256rmbk_VCVTTPS2UDQZ256rmbkz_VCVTTPS2UDQZ256rmk_VCVTTPS2UDQZ256rmkz_VCVTPS2UQQZ256rm_VCVTPS2UQQZ256rmb_VCVTPS2UQQZ256rmbk_VCVTPS2UQQZ256rmbkz_VCVTPS2UQQZ256rmk_VCVTPS2UQQZ256rmkz_VCVTTPS2UQQZ256rm_VCVTTPS2UQQZ256rmb_VCVTTPS2UQQZ256rmbk_VCVTTPS2UQQZ256rmbkz_VCVTTPS2UQQZ256rmk_VCVTTPS2UQQZ256rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1334
  {DBGFIELD("VCVTPS2DQZrm_VCVTPS2DQZrmb_VCVTPS2DQZrmbk_VCVTPS2DQZrmbkz_VCVTPS2DQZrmk_VCVTPS2DQZrmkz_VCVTTPS2DQZrm_VCVTTPS2DQZrmb_VCVTTPS2DQZrmbk_VCVTTPS2DQZrmbkz_VCVTTPS2DQZrmk_VCVTTPS2DQZrmkz_VCVTPS2UDQZrm_VCVTPS2UDQZrmb_VCVTPS2UDQZrmbk_VCVTPS2UDQZrmbkz_VCVTPS2UDQZrmk_VCVTPS2UDQZrmkz_VCVTTPS2UDQZrm_VCVTTPS2UDQZrmb_VCVTTPS2UDQZrmbk_VCVTTPS2UDQZrmbkz_VCVTTPS2UDQZrmk_VCVTTPS2UDQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1335
  {DBGFIELD("VEXPANDPDZ256rm_VEXPANDPDZ256rmk_VEXPANDPDZ256rmkz_VEXPANDPDZrm_VEXPANDPDZrmk_VEXPANDPDZrmkz_VEXPANDPSZ256rm_VEXPANDPSZ256rmk_VEXPANDPSZ256rmkz_VEXPANDPSZrm_VEXPANDPSZrmk_VEXPANDPSZrmkz_VPEXPANDDZ256rm_VPEXPANDDZ256rmk_VPEXPANDDZ256rmkz_VPEXPANDDZrm_VPEXPANDDZrmk_VPEXPANDDZrmkz_VPEXPANDQZ256rm_VPEXPANDQZ256rmk_VPEXPANDQZ256rmkz_VPEXPANDQZrm_VPEXPANDQZrmk_VPEXPANDQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1336
  {DBGFIELD("CVTDQ2PDrm_VCVTDQ2PDrm") 4, false, false, false, 2240, 3,  7, 1,  0, 0}, // #1337
  {DBGFIELD("CVTPD2DQrm_CVTTPD2DQrm") 5, false, false, false, 2243, 3,  7, 1,  0, 0}, // #1338
  {DBGFIELD("VPCONFLICTQZ128rm_VPCONFLICTQZ128rmb_VPCONFLICTQZ128rmbk_VPCONFLICTQZ128rmbkz_VPCONFLICTQZ128rmk_VPCONFLICTQZ128rmkz") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1339
  {DBGFIELD("VPMULLQZ128rr_VPMULLQZ128rrk_VPMULLQZ128rrkz") 1, false, false, false, 2273, 2, 10, 1,  0, 0}, // #1340
  {DBGFIELD("VPMULLQZ256rr_VPMULLQZ256rrk_VPMULLQZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1341
  {DBGFIELD("VPMULLQZrr_VPMULLQZrrk_VPMULLQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1342
  {DBGFIELD("VPERMWZ128rm_VPERMWZ128rmk_VPERMWZ128rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1343
  {DBGFIELD("VCVTSD2USIZrm_Int_VCVTTSD2USIZrm_VCVTTSD2USIZrm_Int") 4, false, false, false, 2232, 3, 22, 1, 15, 1}, // #1344
  {DBGFIELD("VCVTSS2USI64Zrm_Int_VCVTTSS2USI64Zrm_VCVTTSS2USI64Zrm_Int") 4, false, false, false, 2235, 3, 22, 1, 15, 1}, // #1345
  {DBGFIELD("VCVTPS2QQZrm_VCVTPS2QQZrmb_VCVTPS2QQZrmbk_VCVTPS2QQZrmbkz_VCVTPS2QQZrmk_VCVTPS2QQZrmkz_VCVTTPS2QQZrm_VCVTTPS2QQZrmb_VCVTTPS2QQZrmbk_VCVTTPS2QQZrmbkz_VCVTTPS2QQZrmk_VCVTTPS2QQZrmkz_VCVTPS2UQQZrm_VCVTPS2UQQZrmb_VCVTPS2UQQZrmbk_VCVTPS2UQQZrmbkz_VCVTPS2UQQZrmk_VCVTPS2UQQZrmkz_VCVTTPS2UQQZrm_VCVTTPS2UQQZrmb_VCVTTPS2UQQZrmbk_VCVTTPS2UQQZrmbkz_VCVTTPS2UQQZrmk_VCVTTPS2UQQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1346
  {DBGFIELD("VPERMWZ256rm_VPERMWZ256rmk_VPERMWZ256rmkz_VPERMWZrm_VPERMWZrmk_VPERMWZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1347
  {DBGFIELD("VCVTDQ2PDYrm")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1348
  {DBGFIELD("VPERMI2W128rm_VPERMI2W128rmk_VPERMI2W128rmkz_VPERMT2W128rm_VPERMT2W128rmk_VPERMT2W128rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1349
  {DBGFIELD("VCVTPD2DQZrm_VCVTPD2DQZrmb_VCVTPD2DQZrmbk_VCVTPD2DQZrmbkz_VCVTPD2DQZrmk_VCVTPD2DQZrmkz_VCVTPD2UDQZrm_VCVTPD2UDQZrmb_VCVTPD2UDQZrmbk_VCVTPD2UDQZrmbkz_VCVTPD2UDQZrmk_VCVTPD2UDQZrmkz_VCVTTPD2DQZrm_VCVTTPD2DQZrmb_VCVTTPD2DQZrmbk_VCVTTPD2DQZrmbkz_VCVTTPD2DQZrmk_VCVTTPD2DQZrmkz_VCVTTPD2UDQZrm_VCVTTPD2UDQZrmb_VCVTTPD2UDQZrmbk_VCVTTPD2UDQZrmbkz_VCVTTPD2UDQZrmk_VCVTTPD2UDQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1350
  {DBGFIELD("VCVTQQ2PSZrm_VCVTQQ2PSZrmb_VCVTQQ2PSZrmbk_VCVTQQ2PSZrmbkz_VCVTQQ2PSZrmk_VCVTQQ2PSZrmkz_VCVTUQQ2PSZrm_VCVTUQQ2PSZrmb_VCVTUQQ2PSZrmbk_VCVTUQQ2PSZrmbkz_VCVTUQQ2PSZrmk_VCVTUQQ2PSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1351
  {DBGFIELD("VPERMI2W256rm_VPERMI2W256rmk_VPERMI2W256rmkz_VPERMI2Wrm_VPERMI2Wrmk_VPERMI2Wrmkz_VPERMT2W256rm_VPERMT2W256rmk_VPERMT2W256rmkz_VPERMT2Wrm_VPERMT2Wrmk_VPERMT2Wrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1352
  {DBGFIELD("VPCONFLICTDZ128rm_VPCONFLICTDZ128rmb_VPCONFLICTDZ128rmbk_VPCONFLICTDZ128rmbkz_VPCONFLICTDZ128rmk_VPCONFLICTDZ128rmkz") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1353
  {DBGFIELD("VPMULLQZ128rm_VPMULLQZ128rmb_VPMULLQZ128rmbk_VPMULLQZ128rmbkz_VPMULLQZ128rmk_VPMULLQZ128rmkz") 1, false, false, false, 2273, 2, 10, 1, 15, 1}, // #1354
  {DBGFIELD("VPMULLQZ256rm_VPMULLQZ256rmb_VPMULLQZ256rmbk_VPMULLQZ256rmbkz_VPMULLQZ256rmk_VPMULLQZ256rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1355
  {DBGFIELD("VPMULLQZrm_VPMULLQZrmb_VPMULLQZrmbk_VPMULLQZrmbkz_VPMULLQZrmk_VPMULLQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1356
  {DBGFIELD("VGATHERQPSZ128rm_VPGATHERQDZ128rm_VGATHERDPDZ128rm_VPGATHERDQZ128rm_VGATHERQPDZ128rm_VPGATHERQQZ128rm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1357
  {DBGFIELD("VGATHERQPSZ256rm_VPGATHERQDZ256rm_VGATHERQPDZ256rm_VPGATHERQQZ256rm_VGATHERDPSZ128rm_VPGATHERDDZ128rm_VGATHERDPDZ256rm_VPGATHERDQZ256rm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1358
  {DBGFIELD("VGATHERDPSZ256rm_VPGATHERDDZ256rm_VGATHERDPDZrm_VPGATHERDQZrm_VGATHERQPDZrm_VPGATHERQQZrm_VGATHERQPSZrm_VPGATHERQDZrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1359
  {DBGFIELD("VGATHERDPSZrm_VPGATHERDDZrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1360
  {DBGFIELD("VPCONFLICTQZ256rr_VPCONFLICTQZ256rrk_VPCONFLICTQZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1361
  {DBGFIELD("VPCONFLICTQZ256rm_VPCONFLICTQZ256rmb_VPCONFLICTQZ256rmbk_VPCONFLICTQZ256rmbkz_VPCONFLICTQZ256rmk_VPCONFLICTQZ256rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1362
  {DBGFIELD("VPCONFLICTQZrr_VPCONFLICTQZrrk_VPCONFLICTQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1363
  {DBGFIELD("VPCONFLICTDZ256rm_VPCONFLICTDZ256rmb_VPCONFLICTDZ256rmbk_VPCONFLICTDZ256rmbkz_VPCONFLICTDZ256rmk_VPCONFLICTDZ256rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1364
  {DBGFIELD("VPCONFLICTQZrm_VPCONFLICTQZrmb_VPCONFLICTQZrmbk_VPCONFLICTQZrmbkz_VPCONFLICTQZrmk_VPCONFLICTQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1365
  {DBGFIELD("VPCONFLICTDZrm_VPCONFLICTDZrmb_VPCONFLICTDZrmbk_VPCONFLICTDZrmbkz_VPCONFLICTDZrmk_VPCONFLICTDZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1366
  {DBGFIELD("VXORPSZ128rr_VXORPDZ128rr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1367
  {DBGFIELD("VXORPSZ256rr_VXORPDZ256rr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1368
  {DBGFIELD("VXORPSZrr_VXORPDZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1369
  {DBGFIELD("VPXORDZ128rr_VPXORQZ128rr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1370
  {DBGFIELD("VPXORDZ256rr_VPXORQZ256rr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1371
  {DBGFIELD("VPXORDZrr_VPXORQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1372
  {DBGFIELD("VPSUBBZ128rr_VPSUBDZ128rr_VPSUBQZ128rr_VPSUBWZ128rr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1373
  {DBGFIELD("VPSUBBZ256rr_VPSUBDZ256rr_VPSUBQZ256rr_VPSUBWZ256rr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1374
  {DBGFIELD("VPSUBBZrr_VPSUBDZrr_VPSUBQZrr_VPSUBWZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1375
  {DBGFIELD("VPBROADCASTDrr_VPBROADCASTQrr") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1376
  {DBGFIELD("INSERTPSrr_VINSERTPSZrr_VINSERTPSrr_MOVHLPSrr_MOVLHPSrr_VMOVHLPSZrr_VMOVHLPSrr_VMOVLHPSZrr_VMOVLHPSrr_MOVDDUPrr_VMOVDDUPrr_VPERMILPDZ128ri_VPERMILPDZ128rik_VPERMILPDZ128rikz_VPERMILPDri_VPERMILPSZ128ri_VPERMILPSZ128rik_VPERMILPSZ128rikz_VPERMILPSri_UNPCKHPDrr_UNPCKHPSrr_UNPCKLPDrr_UNPCKLPSrr_VUNPCKHPDZ128rr_VUNPCKHPDZ128rrk_VUNPCKHPDZ128rrkz_VUNPCKHPDrr_VUNPCKHPSZ128rr_VUNPCKHPSZ128rrk_VUNPCKHPSZ128rrkz_VUNPCKHPSrr_VUNPCKLPDZ128rr_VUNPCKLPDZ128rrk_VUNPCKLPDZ128rrkz_VUNPCKLPDrr_VUNPCKLPSZ128rr_VUNPCKLPSZ128rrk_VUNPCKLPSZ128rrkz_VUNPCKLPSrr") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1377
  {DBGFIELD("VMOVDDUPYrr_VPERMILPDYri_VPERMILPDZ256ri_VPERMILPDZ256rik_VPERMILPDZ256rikz_VPERMILPSYri_VPERMILPSZ256ri_VPERMILPSZ256rik_VPERMILPSZ256rikz_VUNPCKHPDYrr_VUNPCKHPDZ256rr_VUNPCKHPDZ256rrk_VUNPCKHPDZ256rrkz_VUNPCKHPSYrr_VUNPCKHPSZ256rr_VUNPCKHPSZ256rrk_VUNPCKHPSZ256rrkz_VUNPCKLPDYrr_VUNPCKLPDZ256rr_VUNPCKLPDZ256rrk_VUNPCKLPDZ256rrkz_VUNPCKLPSYrr_VUNPCKLPSZ256rr_VUNPCKLPSZ256rrk_VUNPCKLPSZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1378
  {DBGFIELD("VPALIGNRYrri")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1379
  {DBGFIELD("VPERMILPDrr_VPERMILPSrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1380
  {DBGFIELD("MOVSDrr_MOVSDrr_REV_VMOVSDZrr_VMOVSDZrr_REV_VMOVSDZrrk_VMOVSDZrrk_REV_VMOVSDZrrkz_VMOVSDZrrkz_REV_VMOVSDrr_VMOVSDrr_REV_VMOVSSZrr_VMOVSSZrr_REV_VMOVSSZrrk_VMOVSSZrrk_REV_VMOVSSZrrkz_VMOVSSZrrkz_REV_VMOVSSrr_VMOVSSrr_REV") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1381
  {DBGFIELD("VPACKSSDWYrr_VPACKSSWBYrr_VPACKUSDWYrr_VPACKUSWBYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1382
  {DBGFIELD("VPBROADCASTBZ128rm_VPBROADCASTBZ128rmk_VPBROADCASTBZ128rmkz_VPBROADCASTWZ128rm_VPBROADCASTWZ128rmk_VPBROADCASTWZ128rmkz") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1383
  {DBGFIELD("INSERTPSrm_VINSERTPSZrm_VINSERTPSrm_UNPCKHPDrm_UNPCKHPSrm_UNPCKLPDrm_UNPCKLPSrm_VUNPCKHPDZ128rm_VUNPCKHPDZ128rmb_VUNPCKHPDZ128rmbk_VUNPCKHPDZ128rmbkz_VUNPCKHPDZ128rmk_VUNPCKHPDZ128rmkz_VUNPCKHPDrm_VUNPCKHPSZ128rm_VUNPCKHPSZ128rmb_VUNPCKHPSZ128rmbk_VUNPCKHPSZ128rmbkz_VUNPCKHPSZ128rmk_VUNPCKHPSZ128rmkz_VUNPCKHPSrm_VUNPCKLPDZ128rm_VUNPCKLPDZ128rmb_VUNPCKLPDZ128rmbk_VUNPCKLPDZ128rmbkz_VUNPCKLPDZ128rmk_VUNPCKLPDZ128rmkz_VUNPCKLPDrm_VUNPCKLPSZ128rm_VUNPCKLPSZ128rmb_VUNPCKLPSZ128rmbk_VUNPCKLPSZ128rmbkz_VUNPCKLPSZ128rmk_VUNPCKLPSZ128rmkz_VUNPCKLPSrm") 1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #1384
  {DBGFIELD("PALIGNRrmi_VPALIGNRZ128rmi_VPALIGNRZ128rmik_VPALIGNRZ128rmikz_VPALIGNRrmi") 1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #1385
  {DBGFIELD("VPERMILPDZ128mbi_VPERMILPDZ128mbik_VPERMILPDZ128mbikz_VPERMILPDZ128mi_VPERMILPDZ128mik_VPERMILPDZ128mikz_VPERMILPDmi_VPERMILPSZ128mbi_VPERMILPSZ128mbik_VPERMILPSZ128mbikz_VPERMILPSZ128mi_VPERMILPSZ128mik_VPERMILPSZ128mikz_VPERMILPSmi") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1386
  {DBGFIELD("VPERMILPDZ128rm_VPERMILPDZ128rmb_VPERMILPDZ128rmbk_VPERMILPDZ128rmbkz_VPERMILPDZ128rmk_VPERMILPDZ128rmkz_VPERMILPDrm_VPERMILPSZ128rm_VPERMILPSZ128rmb_VPERMILPSZ128rmbk_VPERMILPSZ128rmbkz_VPERMILPSZ128rmk_VPERMILPSZ128rmkz_VPERMILPSrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1387
  {DBGFIELD("VPALIGNRYrmi_VPALIGNRZ256rmi_VPALIGNRZ256rmik_VPALIGNRZ256rmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1388
  {DBGFIELD("VPERMILPDYmi_VPERMILPDZ256mbi_VPERMILPDZ256mbik_VPERMILPDZ256mbikz_VPERMILPDZ256mi_VPERMILPDZ256mik_VPERMILPDZ256mikz_VPERMILPSYmi_VPERMILPSZ256mbi_VPERMILPSZ256mbik_VPERMILPSZ256mbikz_VPERMILPSZ256mi_VPERMILPSZ256mik_VPERMILPSZ256mikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1389
  {DBGFIELD("VPERMILPDYrm_VPERMILPDZ256rm_VPERMILPDZ256rmb_VPERMILPDZ256rmbk_VPERMILPDZ256rmbkz_VPERMILPDZ256rmk_VPERMILPDZ256rmkz_VPERMILPSYrm_VPERMILPSZ256rm_VPERMILPSZ256rmb_VPERMILPSZ256rmbk_VPERMILPSZ256rmbkz_VPERMILPSZ256rmk_VPERMILPSZ256rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1390
  {DBGFIELD("VUNPCKHPDYrm_VUNPCKHPDZ256rm_VUNPCKHPDZ256rmb_VUNPCKHPDZ256rmbk_VUNPCKHPDZ256rmbkz_VUNPCKHPDZ256rmk_VUNPCKHPDZ256rmkz_VUNPCKHPSYrm_VUNPCKHPSZ256rm_VUNPCKHPSZ256rmb_VUNPCKHPSZ256rmbk_VUNPCKHPSZ256rmbkz_VUNPCKHPSZ256rmk_VUNPCKHPSZ256rmkz_VUNPCKLPDYrm_VUNPCKLPDZ256rm_VUNPCKLPDZ256rmb_VUNPCKLPDZ256rmbk_VUNPCKLPDZ256rmbkz_VUNPCKLPDZ256rmk_VUNPCKLPDZ256rmkz_VUNPCKLPSYrm_VUNPCKLPSZ256rm_VUNPCKLPSZ256rmb_VUNPCKLPSZ256rmbk_VUNPCKLPSZ256rmbkz_VUNPCKLPSZ256rmk_VUNPCKLPSZ256rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1391
  {DBGFIELD("PACKSSDWrm_PACKSSWBrm_PACKUSDWrm_PACKUSWBrm_VPACKSSDWZ128rm_VPACKSSDWZ128rmb_VPACKSSDWZ128rmbk_VPACKSSDWZ128rmbkz_VPACKSSDWZ128rmk_VPACKSSDWZ128rmkz_VPACKSSDWrm_VPACKSSWBZ128rm_VPACKSSWBZ128rmk_VPACKSSWBZ128rmkz_VPACKSSWBrm_VPACKUSDWZ128rm_VPACKUSDWZ128rmb_VPACKUSDWZ128rmbk_VPACKUSDWZ128rmbkz_VPACKUSDWZ128rmk_VPACKUSDWZ128rmkz_VPACKUSDWrm_VPACKUSWBZ128rm_VPACKUSWBZ128rmk_VPACKUSWBZ128rmkz_VPACKUSWBrm") 1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #1392
  {DBGFIELD("VPACKSSDWYrm_VPACKSSDWZ256rm_VPACKSSDWZ256rmb_VPACKSSDWZ256rmbk_VPACKSSDWZ256rmbkz_VPACKSSDWZ256rmk_VPACKSSDWZ256rmkz_VPACKSSWBYrm_VPACKSSWBZ256rm_VPACKSSWBZ256rmk_VPACKSSWBZ256rmkz_VPACKUSDWYrm_VPACKUSDWZ256rm_VPACKUSDWZ256rmb_VPACKUSDWZ256rmbk_VPACKUSDWZ256rmbkz_VPACKUSDWZ256rmk_VPACKUSDWZ256rmkz_VPACKUSWBYrm_VPACKUSWBZ256rm_VPACKUSWBZ256rmk_VPACKUSWBZ256rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1393
  {DBGFIELD("VPACKSSDWZrm_VPACKSSDWZrmb_VPACKSSDWZrmbk_VPACKSSDWZrmbkz_VPACKSSDWZrmk_VPACKSSDWZrmkz_VPACKSSWBZrm_VPACKSSWBZrmk_VPACKSSWBZrmkz_VPACKUSDWZrm_VPACKUSDWZrmb_VPACKUSDWZrmbk_VPACKUSDWZrmbkz_VPACKUSDWZrmk_VPACKUSDWZrmkz_VPACKUSWBZrm_VPACKUSWBZrmk_VPACKUSWBZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1394
  {DBGFIELD("AADD64mr_AAND64mr_AOR64mr_AXOR64mr") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1395
  {DBGFIELD("JMP16m_JMP16m_NT_JMP32m_JMP32m_NT_JMP64m_JMP64m_NT") 1, false, false, false,  3, 2,  1, 1,  0, 0}, // #1396
  {DBGFIELD("RET16")              1, false, false, false, 992, 1, 106, 1,  0, 0}, // #1397
  {DBGFIELD("RORX32mi_RORX64mi")  1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1398
  {DBGFIELD("ADC16rm_ADC32rm_ADC64rm_ADC8rm_SBB16rm_SBB32rm_SBB64rm_SBB8rm_ADCX32rm_ADCX64rm_ADOX32rm_ADOX64rm") 1, false, false, false, 2220, 2,  1, 1, 15, 2}, // #1399
  {DBGFIELD("ADC8mi_ADC8mi8_SBB8mi_SBB8mi8") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1400
  {DBGFIELD("CMP16mi_CMP32mi_CMP8mi_CMP16mi8_CMP32mi8_CMP64mi8_CMP8mi8") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1401
  {DBGFIELD("MOV8rm")             1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1402
  {DBGFIELD("POP16rmr_POP32rmr")  1, false, false, false, 269, 3,  1, 1,  0, 0}, // #1403
  {DBGFIELD("POP32r")             1, false, false, false, 269, 3,  1, 1,  0, 0}, // #1404
  {DBGFIELD("CMP64mi32")          1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1405
  {DBGFIELD("MOV8rm_NOREX")       1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1406
  {DBGFIELD("MOVZX16rm8")         1, false, false, false, 214, 1,  5, 1,  0, 0}, // #1407
  {DBGFIELD("ADD16rm_ADD32rm_ADD64rm_ADD8rm_CMP16rm_CMP32rm_CMP64rm_CMP8rm_SUB16rm_SUB32rm_SUB64rm_SUB8rm_AND16rm_AND32rm_AND8rm_OR16rm_OR32rm_OR8rm_XOR16rm_XOR32rm_XOR8rm") 1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #1408
  {DBGFIELD("CMP16mr_CMP32mr_CMP64mr_CMP8mr") 1, false, false, false, 2220, 2,  1, 1, 13, 1}, // #1409
  {DBGFIELD("ADD64ri8_SUB64ri8_DEC64r_INC64r") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1410
  {DBGFIELD("MOV64rr_MOV64rr_REV") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1411
  {DBGFIELD("JMP_2")              1, false, false, false,  3, 2,  1, 1,  0, 0}, // #1412
  {DBGFIELD("ADD8mi_ADD8mi8_SUB8mi_SUB8mi8") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1413
  {DBGFIELD("AND8mi_AND8mi8_OR8mi_OR8mi8_XOR8mi_XOR8mi8") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1414
  {DBGFIELD("DEC8m_INC8m_NEG8m_NOT8m") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1415
  {DBGFIELD("ADD8mr")             1, false, false, false, 2220, 2,  1, 1, 13, 1}, // #1416
  {DBGFIELD("AND8mr_OR8mr_XOR8mr") 1, false, false, false, 2220, 2,  1, 1, 13, 1}, // #1417
  {DBGFIELD("SUB8mr")             1, false, false, false, 2220, 2,  1, 1, 13, 1}, // #1418
  {DBGFIELD("ADDSSrr_ADDSSrr_Int_SUBSSrr_SUBSSrr_Int_VADDSSrr_VADDSSrr_Int_VSUBSSrr_VSUBSSrr_Int") 1, false, false, false,  3, 2, 10, 1,  0, 0}, // #1419
  {DBGFIELD("AND16ri8_AND16rr_AND32ri8_AND32rr_AND64ri8_AND64rr_AND8ri8_AND8rr_AND16rr_REV_AND32rr_REV_AND64rr_REV_AND8rr_REV_TEST32i32_TEST64i32_AND32ri_AND8ri_TEST32ri_TEST8ri_AND64ri32_TEST64ri32_TEST8i8_OR16ri8_OR16rr_OR32ri8_OR32rr_OR64ri8_OR64rr_OR8ri8_OR8rr_XOR16ri8_XOR16rr_XOR32ri8_XOR64ri8_XOR8ri8_XOR8rr_OR16rr_REV_OR32rr_REV_OR64rr_REV_OR8rr_REV_XOR16rr_REV_XOR8rr_REV_OR32ri_OR8ri_XOR32ri_XOR8ri_OR64ri32_XOR64ri32_TEST16rr_TEST32rr_TEST64rr_TEST8rr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1420
  {DBGFIELD("AND32i32_AND64i32_AND8i8_OR32i32_OR64i32_XOR32i32_XOR64i32_OR8i8_XOR8i8") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1421
  {DBGFIELD("XOR32rr_XOR64rr")    1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1422
  {DBGFIELD("XOR32rr_REV_XOR64rr_REV") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1423
  {DBGFIELD("XOR8rr_NOREX")       1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1424
  {DBGFIELD("TEST16mi_TEST32mi_TEST8mi") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1425
  {DBGFIELD("TEST64mi32")         1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1426
  {DBGFIELD("OR64rm_XOR64rm")     1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #1427
  {DBGFIELD("AND64rm")            1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #1428
  {DBGFIELD("TEST16mr_TEST32mr_TEST64mr_TEST8mr") 1, false, false, false, 2220, 2,  1, 1, 13, 1}, // #1429
  {DBGFIELD("BT64mr")             1, false, false, false, 293, 1, 22, 1,  0, 0}, // #1430
  {DBGFIELD("BT64rr")             1, false, false, false,  3, 2,  1, 1,  0, 0}, // #1431
  {DBGFIELD("BTC64rr_BTR64rr_BTS64rr") 1, false, false, false,  3, 2,  1, 1,  0, 0}, // #1432
  {DBGFIELD("BTC64mr_BTR64mr_BTS64mr") 1, false, false, false, 82, 1,  8, 1,  0, 0}, // #1433
  {DBGFIELD("CALL64m_CALL64m_NT") 1, false, false, false,  3, 2,  1, 1,  0, 0}, // #1434
  {DBGFIELD("CALL64r_CALL64r_NT") 1, false, false, false,  3, 2,  1, 1,  0, 0}, // #1435
  {DBGFIELD("CDQE_CWDE")          1, false, false, false, 1159, 1, 14, 1,  0, 0}, // #1436
  {DBGFIELD("MOVSHDUPrr_MOVSLDUPrr_VMOVSHDUPrr_VMOVSLDUPrr_SHUFPDrri_SHUFPSrri_VSHUFPDrri_VSHUFPSrri") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1437
  {DBGFIELD("VMOVSHDUPYrr_VMOVSLDUPYrr_VSHUFPDYrri_VSHUFPSYrri") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1438
  {DBGFIELD("VPBLENDWYrri")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1439
  {DBGFIELD("CLFLUSH")            1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1440
  {DBGFIELD("CLTS")               1, false, false, false,  4, 1,  4, 1,  0, 0}, // #1441
  {DBGFIELD("MOV16o16a_MOV16o32a_MOV16o64a") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1442
  {DBGFIELD("CLWB")               1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1443
  {DBGFIELD("CVTSD2SIrm_CVTSD2SIrm_Int_CVTTSD2SIrm_CVTTSD2SIrm_Int_VCVTSD2SIrm_VCVTSD2SIrm_Int_VCVTTSD2SIrm") 4, false, false, false, 2232, 3, 22, 1,  0, 0}, // #1444
  {DBGFIELD("VCVTTSD2SIrm_Int")   4, false, false, false, 2235, 3, 22, 1,  0, 0}, // #1445
  {DBGFIELD("VCVTSI642SSrm_Int")  1, false, false, false, 2222, 3,  6, 1, 15, 1}, // #1446
  {DBGFIELD("VCVTSI642SSrm")      1, false, false, false, 2222, 3,  6, 1, 15, 1}, // #1447
  {DBGFIELD("VCVTSI642SSrr_Int")  3, false, false, false, 2222, 3,  3, 1,  6, 1}, // #1448
  {DBGFIELD("JECXZ_JRCXZ")        1, false, false, false, 1159, 1, 14, 1,  0, 0}, // #1449
  {DBGFIELD("ST_Frr")             1, false, false, false, 75, 1, 12, 1,  0, 0}, // #1450
  {DBGFIELD("MOV16sr_MOV32sr")    1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1451
  {DBGFIELD("DEC16r_alt_SALC")    1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1452
  {DBGFIELD("SYSCALL")            1, false, false, false,  4, 1,  4, 1,  0, 0}, // #1453
  {DBGFIELD("DEC32r_alt")         1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1454
  {DBGFIELD("DIVR_FPrST0_DIVR_FrST0") 3, false, false, false, 2267, 3, 96, 1,  0, 0}, // #1455
  {DBGFIELD("DIVSDrm_Int_VDIVSDrm_Int") 4, false, false, false, 2270, 3, 64, 1, 15, 1}, // #1456
  {DBGFIELD("DIV_FPrST0_DIV_FrST0") 3, false, false, false, 2267, 3, 96, 1,  0, 0}, // #1457
  {DBGFIELD("SMSW16m")            1, false, false, false,  4, 1,  4, 1,  0, 0}, // #1458
  {DBGFIELD("MMX_PEXTRWrr")       1, false, false, false, 1159, 1, 14, 1,  0, 0}, // #1459
  {DBGFIELD("MMX_PADDBrr_MMX_PADDDrr_MMX_PADDWrr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1460
  {DBGFIELD("GF2P8AFFINEINVQBrmi_GF2P8AFFINEQBrmi_VGF2P8AFFINEINVQBrmi_VGF2P8AFFINEQBrmi") 1, false, false, false, 2273, 2, 10, 1, 15, 1}, // #1461
  {DBGFIELD("GF2P8MULBrm_VGF2P8MULBrm") 1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #1462
  {DBGFIELD("VGF2P8AFFINEINVQBYrmi_VGF2P8AFFINEQBYrmi") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1463
  {DBGFIELD("VGF2P8MULBYrm")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1464
  {DBGFIELD("GF2P8MULBrr_VGF2P8MULBrr") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1465
  {DBGFIELD("VGF2P8MULBYrr")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1466
  {DBGFIELD("IN16ri")             1, false, false, false, 2307, 1, 107, 1,  0, 0}, // #1467
  {DBGFIELD("IN16rr")             1, false, false, false, 2308, 1, 108, 1,  0, 0}, // #1468
  {DBGFIELD("IN32ri")             1, false, false, false, 2307, 1, 107, 1,  0, 0}, // #1469
  {DBGFIELD("IN32rr")             1, false, false, false, 2308, 1, 108, 1,  0, 0}, // #1470
  {DBGFIELD("INC16r_alt")         1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1471
  {DBGFIELD("INC32r_alt")         1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1472
  {DBGFIELD("INSB")               1, false, false, false, 2301, 1, 102, 1,  0, 0}, // #1473
  {DBGFIELD("INSL")               1, false, false, false, 2301, 1, 102, 1,  0, 0}, // #1474
  {DBGFIELD("INVLPG")             1, false, false, false, 2292, 1, 79, 1,  0, 0}, // #1475
  {DBGFIELD("JMP64r_REX")         1, false, false, false,  3, 2,  1, 1,  0, 0}, // #1476
  {DBGFIELD("JMP_1_JMP_4")        1, false, false, false,  3, 2,  1, 1,  0, 0}, // #1477
  {DBGFIELD("LAR16rm")            1, false, false, false,  4, 1,  4, 1,  0, 0}, // #1478
  {DBGFIELD("LAR16rr")            1, false, false, false,  4, 1,  4, 1,  0, 0}, // #1479
  {DBGFIELD("LAR32rm")            1, false, false, false,  4, 1,  4, 1,  0, 0}, // #1480
  {DBGFIELD("LAR64rm")            1, false, false, false,  4, 1,  4, 1,  0, 0}, // #1481
  {DBGFIELD("LEAVE")              1, false, false, false, 75, 1, 12, 1,  0, 0}, // #1482
  {DBGFIELD("LGDT64m")            1, false, false, false,  4, 1,  4, 1,  0, 0}, // #1483
  {DBGFIELD("LIDT64m")            1, false, false, false,  4, 1,  4, 1,  0, 0}, // #1484
  {DBGFIELD("LLDT16m")            1, false, false, false,  4, 1,  4, 1,  0, 0}, // #1485
  {DBGFIELD("LLDT16r")            1, false, false, false,  4, 1,  4, 1,  0, 0}, // #1486
  {DBGFIELD("LMSW16m")            1, false, false, false,  4, 1,  4, 1,  0, 0}, // #1487
  {DBGFIELD("LMSW16r")            1, false, false, false,  4, 1,  4, 1,  0, 0}, // #1488
  {DBGFIELD("MMX_MOVD64mr")       1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1489
  {DBGFIELD("MMX_MOVD64rm_MMX_MOVQ64rm") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1490
  {DBGFIELD("MMX_MOVD64to64rm")   1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1491
  {DBGFIELD("MMX_MOVFR642Qrr")    1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1492
  {DBGFIELD("MMX_PACKSSDWrm_MMX_PACKSSWBrm") 1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #1493
  {DBGFIELD("MMX_PACKSSDWrr_MMX_PACKSSWBrr") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1494
  {DBGFIELD("MMX_PINSRWrr")       1, false, false, false, 2220, 2,  1, 1,  6, 1}, // #1495
  {DBGFIELD("MMX_PADDBrm_MMX_PADDDrm_MMX_PADDWrm_MMX_PSUBBrm_MMX_PSUBDrm_MMX_PSUBWrm") 1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #1496
  {DBGFIELD("MMX_PINSRWrm")       1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #1497
  {DBGFIELD("VPALIGNRYrmi")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1498
  {DBGFIELD("MOV16ao16_MOV16ao32_MOV16ao64") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1499
  {DBGFIELD("PUSHFS16_PUSHFS32_PUSHGS16_PUSHGS32") 1, false, false, false, 75, 1, 12, 1,  0, 0}, // #1500
  {DBGFIELD("MOV16ms")            1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1501
  {DBGFIELD("MOVBE32mr")          1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1502
  {DBGFIELD("MOV16rs_MOV32rs_MOV64rs") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1503
  {DBGFIELD("SLDT16r")            1, false, false, false,  4, 1,  4, 1,  0, 0}, // #1504
  {DBGFIELD("STR16r")             1, false, false, false,  4, 1,  4, 1,  0, 0}, // #1505
  {DBGFIELD("MOV32ao16_MOV32ao32_MOV32ao64") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1506
  {DBGFIELD("MOV64ao64")          1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1507
  {DBGFIELD("MOV32o16a_MOV32o32a_MOV8o16a_MOV8o32a_MOV32o64a_MOV64o64a_MOV8o64a") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1508
  {DBGFIELD("MOVZX32rr8_MOVZX64rr8") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1509
  {DBGFIELD("MOVZX32rr8_NOREX")   1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1510
  {DBGFIELD("MOV64ao32")          1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1511
  {DBGFIELD("MOV64dr")            1, false, false, false,  4, 1,  4, 1,  0, 0}, // #1512
  {DBGFIELD("MOV64o32a")          1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1513
  {DBGFIELD("MOV64rc")            1, false, false, false,  4, 1,  4, 1,  0, 0}, // #1514
  {DBGFIELD("MOV64rd")            1, false, false, false,  4, 1,  4, 1,  0, 0}, // #1515
  {DBGFIELD("MOV8ao16_MOV8ao32_MOV8ao64") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1516
  {DBGFIELD("MOV8mi_MOV8mr")      1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1517
  {DBGFIELD("MOV8mr_NOREX")       1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1518
  {DBGFIELD("MOVBE32rm")          1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1519
  {DBGFIELD("SLDT16m")            1, false, false, false,  4, 1,  4, 1,  0, 0}, // #1520
  {DBGFIELD("STRm")               1, false, false, false,  4, 1,  4, 1,  0, 0}, // #1521
  {DBGFIELD("MOVDIR64B16_MOVDIR64B32_MOVDIR64B64") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1522
  {DBGFIELD("MOVDIRI32")          1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1523
  {DBGFIELD("MOVDIRI64")          1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1524
  {DBGFIELD("MOVLPDrm_MOVLPSrm_VMOVLPDrm_VMOVLPSrm") 1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #1525
  {DBGFIELD("SHUFPDrmi_SHUFPSrmi_VSHUFPDrmi_VSHUFPSrmi") 1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #1526
  {DBGFIELD("MOVNTDQmr")          1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1527
  {DBGFIELD("MOVNTImr")           1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1528
  {DBGFIELD("MOVSB")              1, false, false, false, 214, 1,  5, 1,  0, 0}, // #1529
  {DBGFIELD("MOVSDrr_MOVSDrr_REV_VMOVSDrr_VMOVSDrr_REV_VMOVSSrr_VMOVSSrr_REV") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1530
  {DBGFIELD("MOVSX16rm16_MOVSX16rm32") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1531
  {DBGFIELD("MOVSX32rm16_MOVSX32rm32_MOVSX64rm16_MOVSX64rm32_MOVSX32rm8_MOVSX64rm8") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1532
  {DBGFIELD("MOVSX32rm8_NOREX")   1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1533
  {DBGFIELD("MOVSX16rr16_MOVSX16rr32") 1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1534
  {DBGFIELD("MOVSX16rr8")         1, false, false, false, 75, 1, 12, 1,  0, 0}, // #1535
  {DBGFIELD("MOVSX32rr16_MOVSX32rr8_MOVSX64rr16_MOVSX64rr8") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1536
  {DBGFIELD("MOVSX32rr8_NOREX")   1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1537
  {DBGFIELD("MUL_FPrST0_MUL_FrST0") 1, false, false, false, 2273, 2, 14, 1,  0, 0}, // #1538
  {DBGFIELD("OUT16ir")            1, false, false, false, 2303, 1, 103, 1,  0, 0}, // #1539
  {DBGFIELD("OUT16rr")            1, false, false, false, 2269, 1, 94, 1,  0, 0}, // #1540
  {DBGFIELD("OUT32ir")            1, false, false, false, 2303, 1, 103, 1,  0, 0}, // #1541
  {DBGFIELD("OUT32rr")            1, false, false, false, 2269, 1, 94, 1,  0, 0}, // #1542
  {DBGFIELD("OUTSB")              1, false, false, false, 2304, 1, 87, 1,  0, 0}, // #1543
  {DBGFIELD("OUTSL")              1, false, false, false, 2304, 1, 87, 1,  0, 0}, // #1544
  {DBGFIELD("PACKSSDWrm_PACKSSWBrm_PACKUSDWrm_PACKUSWBrm_VPACKSSDWrm_VPACKSSWBrm_VPACKUSDWrm_VPACKUSWBrm") 1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #1545
  {DBGFIELD("PACKSSDWrr_PACKSSWBrr_PACKUSDWrr_PACKUSWBrr_VPACKSSDWrr_VPACKSSWBrr_VPACKUSDWrr_VPACKUSWBrr") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1546
  {DBGFIELD("PALIGNRrmi_VPALIGNRrmi") 1, false, false, false, 2220, 2,  1, 1, 15, 1}, // #1547
  {DBGFIELD("PALIGNRrri_VPALIGNRrri") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1548
  {DBGFIELD("PREFETCHIT0_PREFETCHIT1") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1549
  {DBGFIELD("PREFETCHT0_PREFETCHT1_PREFETCHT2") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1550
  {DBGFIELD("PREFETCHNTA")        1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1551
  {DBGFIELD("PTWRITE64m_PTWRITEm") 1, false, false, false,  4, 1,  4, 1,  0, 0}, // #1552
  {DBGFIELD("PTWRITE64r")         1, false, false, false,  4, 1,  4, 1,  0, 0}, // #1553
  {DBGFIELD("PTWRITEr")           1, false, false, false,  4, 1,  4, 1,  0, 0}, // #1554
  {DBGFIELD("PUSH64r")            1, false, false, false, 269, 3,  1, 1,  0, 0}, // #1555
  {DBGFIELD("PUSH64rmr")          1, false, false, false, 269, 3,  1, 1,  0, 0}, // #1556
  {DBGFIELD("RCL8m1_RCR8m1")      1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1557
  {DBGFIELD("RCL8mi")             1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1558
  {DBGFIELD("RCR8mi")             1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1559
  {DBGFIELD("RCL8mCL")            1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1560
  {DBGFIELD("RCR8mCL")            1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1561
  {DBGFIELD("RDPID64")            1, false, false, false,  4, 1,  4, 1,  0, 0}, // #1562
  {DBGFIELD("RDPKRUr")            1, false, false, false,  4, 1,  4, 1,  0, 0}, // #1563
  {DBGFIELD("RDRAND16r")          1, false, false, false,  4, 1,  4, 1,  0, 0}, // #1564
  {DBGFIELD("RDSEED16r")          1, false, false, false,  4, 1,  4, 1,  0, 0}, // #1565
  {DBGFIELD("RDSEED32r_RDSEED64r") 1, false, false, false,  4, 1,  4, 1,  0, 0}, // #1566
  {DBGFIELD("REX64_PREFIX")       1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1567
  {DBGFIELD("ROL16m1_ROL16mi_ROL32m1_ROL32mi_ROL64m1_ROL64mi_ROR16m1_ROR16mi_ROR32m1_ROR32mi_ROR64m1_ROR64mi") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1568
  {DBGFIELD("ROL16mCL_ROL32mCL_ROL64mCL_ROR16mCL_ROR32mCL_ROR64mCL") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1569
  {DBGFIELD("ROL16ri_ROL32ri_ROL64ri_ROL8ri_ROR16ri_ROR32ri_ROR64ri_ROR8ri") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1570
  {DBGFIELD("SHL8mCL_SAR8mCL_SHR8mCL") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1571
  {DBGFIELD("SAR8m1_SAR8mi_SHR8m1_SHR8mi_SHL8m1_SHL8mi") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1572
  {DBGFIELD("SARX32rm_SARX64rm_SHRX32rm_SHRX64rm_SHLX32rm_SHLX64rm") 1, false, false, false, 2220, 2,  1, 1, 13, 1}, // #1573
  {DBGFIELD("SARX32rr_SARX64rr_SHRX32rr_SHRX64rr_SHLX32rr_SHLX64rr") 1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1574
  {DBGFIELD("SERIALIZE")          1, false, false, false,  4, 1,  4, 1,  0, 0}, // #1575
  {DBGFIELD("SHRD16mri8")         1, false, false, false, 464, 1,  3, 1,  0, 0}, // #1576
  {DBGFIELD("SMSW16r")            1, false, false, false,  4, 1,  4, 1,  0, 0}, // #1577
  {DBGFIELD("SMSW32r_SMSW64r")    1, false, false, false,  4, 1,  4, 1,  0, 0}, // #1578
  {DBGFIELD("SQRTSDm_Int_VSQRTSDm_Int") 4, false, false, false, 2270, 3, 64, 1, 15, 1}, // #1579
  {DBGFIELD("STI")                1, false, false, false,  4, 1,  4, 1,  0, 0}, // #1580
  {DBGFIELD("STOSB")              1, false, false, false,  4, 1,  1, 1,  0, 0}, // #1581
  {DBGFIELD("VBLENDVPDrm_VBLENDVPSrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1582
  {DBGFIELD("VPBLENDVBrm")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1583
  {DBGFIELD("VBLENDVPDrr_VBLENDVPSrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1584
  {DBGFIELD("VPBLENDVBrr")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1585
  {DBGFIELD("VERRm")              1, false, false, false,  4, 1,  4, 1,  0, 0}, // #1586
  {DBGFIELD("VERRr")              1, false, false, false,  4, 1,  4, 1,  0, 0}, // #1587
  {DBGFIELD("VERWr")              1, false, false, false,  4, 1,  4, 1,  0, 0}, // #1588
  {DBGFIELD("VHADDPDrr_VHADDPSrr_VHSUBPDrr_VHSUBPSrr") 5, false, false, false, 2243, 3,  7, 1,  0, 0}, // #1589
  {DBGFIELD("VLDMXCSR")           4, false, false, false, 2225, 3, 10, 1,  0, 0}, // #1590
  {DBGFIELD("VMOVMSKPDYrr_VMOVMSKPSYrr") 1, false, false, false, 2278, 2,  5, 1,  0, 0}, // #1591
  {DBGFIELD("VMOVNTDQmr")         1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1592
  {DBGFIELD("VMOVNTPDmr")         1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1593
  {DBGFIELD("VMOVNTPSYmr")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1594
  {DBGFIELD("VMOVNTPSmr")         1, false, false, false, 2220, 2,  1, 1,  0, 0}, // #1595
  {DBGFIELD("VPACKSSDWYrm_VPACKSSWBYrm_VPACKUSDWYrm_VPACKUSWBYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1596
  {DBGFIELD("VPCLMULQDQYrm")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1597
  {DBGFIELD("VSHUFPDYrmi_VSHUFPSYrmi") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1598
  {DBGFIELD("VPBLENDWYrmi")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1599
  {DBGFIELD("VPDPBUSDSYrm_VPDPBUSDrm_VPDPWSSDSYrm_VPDPWSSDrm_VPDPBUSDSrm_VPDPBUSDYrm_VPDPWSSDSrm_VPDPWSSDYrm") 1, false, false, false, 2273, 2, 10, 1,  0, 0}, // #1600
  {DBGFIELD("WRPKRUr")            1, false, false, false,  4, 1,  4, 1,  0, 0}, // #1601
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm") 1, false, false, false, 214, 1,  5, 1,  0, 0}, // #1602
  {DBGFIELD("XCHG16rm")           1, false, false, false, 214, 1,  5, 1,  0, 0}, // #1603
  {DBGFIELD("XCHG32rm")           1, false, false, false, 214, 1,  5, 1,  0, 0}, // #1604
  {DBGFIELD("XRSTOR_XRSTOR64_XRSTORS") 1, false, false, false,  4, 1,  4, 1,  0, 0}, // #1605
  {DBGFIELD("XSAVEC")             1, false, false, false,  4, 1,  4, 1,  0, 0}, // #1606
  {DBGFIELD("XSAVEC64")           1, false, false, false,  4, 1,  4, 1,  0, 0}, // #1607
  {DBGFIELD("XSAVEOPT")           1, false, false, false,  4, 1,  4, 1,  0, 0}, // #1608
  {DBGFIELD("XSAVES")             1, false, false, false,  4, 1,  4, 1,  0, 0}, // #1609
  {DBGFIELD("PdWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1610
  {DBGFIELD("WriteVecALU")        0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1611
  {DBGFIELD("JWriteZeroLatency")  0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1612
  {DBGFIELD("JWriteLOCK_CMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1613
  {DBGFIELD("JWriteLOCK_CMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1614
  {DBGFIELD("JWriteLOCK_CMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1615
  {DBGFIELD("JWriteLOCK_CMPXCHGrm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1616
  {DBGFIELD("JWriteCMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1617
  {DBGFIELD("JWriteCMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1618
  {DBGFIELD("JWriteCMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1619
  {DBGFIELD("WriteCMPXCHGRMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1620
  {DBGFIELD("JWriteCMPXCHG8rr_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1621
  {DBGFIELD("WriteCMPXCHG_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1622
  {DBGFIELD("JWriteLOCK_CMPXCHG8B") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1623
  {DBGFIELD("JWriteLOCK_CMPXCHG16B") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1624
  {DBGFIELD("JWriteLOCK_CMPXCHG8rm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1625
  {DBGFIELD("JWriteLOCK_CMPXCHGrm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1626
  {DBGFIELD("JWriteCMPXCHG8B")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1627
  {DBGFIELD("JWriteCMPXCHG16B")   0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1628
  {DBGFIELD("JWriteCMPXCHG8rm")   0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1629
  {DBGFIELD("WriteCMPXCHGRMW")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1630
  {DBGFIELD("JWriteCMPXCHG8rr")   0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1631
  {DBGFIELD("WriteCMPXCHG")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1632
  {DBGFIELD("JWriteLOCK_CMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1633
  {DBGFIELD("JWriteLOCK_CMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1634
  {DBGFIELD("JWriteLOCK_CMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1635
  {DBGFIELD("JWriteLOCK_CMPXCHGrm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1636
  {DBGFIELD("JWriteCMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1637
  {DBGFIELD("JWriteCMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1638
  {DBGFIELD("JWriteCMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1639
  {DBGFIELD("WriteCMPXCHGRMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1640
  {DBGFIELD("JWriteCMPXCHG8rr_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1641
  {DBGFIELD("WriteCMPXCHG_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1642
  {DBGFIELD("JWriteLOCK_XADDrm_XCHG_Part_JWriteXCHGrm_LdSt_Part_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1643
  {DBGFIELD("JWriteXADDrm_XCHG_Part_JWriteXADDrm_LdSt_Part_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1644
  {DBGFIELD("SBWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1645
  {DBGFIELD("WriteALU")           0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1646
  {DBGFIELD("HWWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1647
  {DBGFIELD("BWWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1648
  {DBGFIELD("Zn3WriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1649
  {DBGFIELD("Zn4WriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1650
  {DBGFIELD("SKLWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1651
  {DBGFIELD("SKXWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1652
  {DBGFIELD("ICXWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1653
  {DBGFIELD("WriteFLogic")        0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1654
  {DBGFIELD("WriteFLogicY")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1655
  {DBGFIELD("JWriteZeroIdiomYmm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1656
  {DBGFIELD("WriteVecLogicX")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1657
  {DBGFIELD("WriteVecALUX")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1658
  {DBGFIELD("SKLWritePSUB")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1659
  {DBGFIELD("SKXWritePSUB")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1660
  {DBGFIELD("ICXWritePSUB")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1661
  {DBGFIELD("SBWritePCMPGTQ")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1662
  {DBGFIELD("HWWritePCMPGTQ")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1663
  {DBGFIELD("BWWritePCMPGTQ")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1664
  {DBGFIELD("SKLWritePCMPGTQ")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1665
  {DBGFIELD("SKXWritePCMPGTQ")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1666
  {DBGFIELD("ICXWritePCMPGTQ")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1667
  {DBGFIELD("SBWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1668
  {DBGFIELD("WriteCMOV")          0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1669
  {DBGFIELD("HWWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1670
  {DBGFIELD("BWWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1671
  {DBGFIELD("SKLWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1672
  {DBGFIELD("SKXWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1673
  {DBGFIELD("ICXWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1674
  {DBGFIELD("SBWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1675
  {DBGFIELD("WriteCMOVLd")        0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1676
  {DBGFIELD("HWWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1677
  {DBGFIELD("BWWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1678
  {DBGFIELD("PdWriteCMOVm")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1679
  {DBGFIELD("SKLWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1680
  {DBGFIELD("SKXWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1681
  {DBGFIELD("ICXWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1682
  {DBGFIELD("SBWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1683
  {DBGFIELD("WriteSETCC")         0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1684
  {DBGFIELD("HWWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1685
  {DBGFIELD("BWWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1686
  {DBGFIELD("SKLWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1687
  {DBGFIELD("SKXWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1688
  {DBGFIELD("ICXWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1689
  {DBGFIELD("SBWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1690
  {DBGFIELD("WriteSETCCStore")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1691
  {DBGFIELD("HWWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1692
  {DBGFIELD("BWWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1693
  {DBGFIELD("PdWriteSETGEmSETGmSETLEmSETLm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1694
  {DBGFIELD("SKLWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1695
  {DBGFIELD("SKXWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1696
  {DBGFIELD("ICXWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1697
  {DBGFIELD("WriteVecLogicY")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1698
  {DBGFIELD("WriteVecALUY")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1699
  {DBGFIELD("HWWriteADC0")        0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1700
  {DBGFIELD("WriteADC")           0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1701
  {DBGFIELD("JWriteLOCK_ALURMW")  0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1702
  {DBGFIELD("WriteALURMW")        0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1703
  {DBGFIELD("WriteFShuffle256")   0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1704
  {DBGFIELD("Zn3Write3OpsLEA")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1705
  {DBGFIELD("WriteLEA")           0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1706
  {DBGFIELD("Zn4Write3OpsLEA")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1707
  {DBGFIELD("PdWrite3OpsLEA")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1708
  {DBGFIELD("JWrite3OpsLEA")      0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1709
  {DBGFIELD("WriteVecLogic")      0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1710
  {DBGFIELD("WriteFLogicZ")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1711
  {DBGFIELD("WriteVecLogicZ")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #1712
}; // AtomModelSchedClasses

// {Name, NumMicroOps, BeginGroup, EndGroup, RetireOOO, WriteProcResIdx,#, WriteLatencyIdx,#, ReadAdvanceIdx,#}
static const llvm::MCSchedClassDesc BdVer2ModelSchedClasses[] = {
  {DBGFIELD("InvalidSchedClass")  8191, false, false, false, 0, 0,  0, 0,  0, 0},
  {DBGFIELD("WriteALU")           1, false, false, false, 2320, 2,  1, 1,  0, 0}, // #1
  {DBGFIELD("WriteZero")          1, false, false, false,  0, 0,  1, 1,  0, 0}, // #2
  {DBGFIELD("WriteVecALU")        1, false, false, false, 2322, 3, 12, 1,  0, 0}, // #3
  {DBGFIELD("WriteJump")          1, false, false, false, 2325, 4,  1, 1,  0, 0}, // #4
  {DBGFIELD("WriteCMPXCHGRMW")    2, false, false, false, 2329, 6,  5, 1,  0, 0}, // #5
  {DBGFIELD("WriteJumpLd")        1, false, false, false, 2335, 6, 10, 1,  0, 0}, // #6
  {DBGFIELD("WriteMove")          1, false, false, false, 2320, 2,  1, 1,  0, 0}, // #7
  {DBGFIELD("WriteSystem")        1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #8
  {DBGFIELD("WriteADC")           1, false, false, false, 2320, 2,  1, 1,  0, 0}, // #9
  {DBGFIELD("WriteSHDrri")        6, false, false, false, 2343, 2,  5, 1,  0, 0}, // #10
  {DBGFIELD("WriteFStoreX")       1, false, false, false, 2345, 5,  1, 1,  0, 0}, // #11
  {DBGFIELD("WriteFLoadX")        1, false, false, false, 2350, 5, 10, 1,  0, 0}, // #12
  {DBGFIELD("WriteFStoreY")       4, false, false, false, 2355, 5,  1, 1,  0, 0}, // #13
  {DBGFIELD("WriteFLoadY")        2, false, false, false, 2350, 5, 10, 1,  0, 0}, // #14
  {DBGFIELD("WriteMicrocoded")    1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #15
  {DBGFIELD("WriteALURMW")        1, false, false, false, 2360, 5,  3, 1,  0, 0}, // #16
  {DBGFIELD("WriteFSign")         1, false, false, false, 2365, 4,  1, 1,  0, 0}, // #17
  {DBGFIELD("WriteADCRMW")        2, false, false, false, 2360, 5,  3, 1,  0, 0}, // #18
  {DBGFIELD("WriteADCRMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, false, 2360, 5,  3, 1, 19, 2}, // #19
  {DBGFIELD("WriteADCLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, false, 2369, 4, 10, 1, 21, 2}, // #20
  {DBGFIELD("WriteALURMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, false, 2360, 5,  3, 1, 19, 1}, // #21
  {DBGFIELD("WriteALULd_ReadAfterLd") 1, false, false, false, 2369, 4, 10, 1, 21, 1}, // #22
  {DBGFIELD("WriteFAdd64XLd_ReadAfterVecXLd") 1, false, false, false, 2373, 6,  9, 1,  3, 1}, // #23
  {DBGFIELD("WriteFAdd64X")       1, false, false, false, 2374, 4, 10, 1,  0, 0}, // #24
  {DBGFIELD("WriteFAddXLd_ReadAfterVecXLd") 1, false, false, false, 2373, 6,  9, 1,  3, 1}, // #25
  {DBGFIELD("WriteFAddX")         1, false, false, false, 2374, 4, 10, 1,  0, 0}, // #26
  {DBGFIELD("WriteNop")           1, false, false, false, 2320, 2,  1, 1,  0, 0}, // #27
  {DBGFIELD("WriteFAdd64Ld_ReadAfterVecLd") 1, false, false, false, 2373, 6,  9, 1,  3, 1}, // #28
  {DBGFIELD("WriteFAdd64")        1, false, false, false, 2374, 4, 10, 1,  0, 0}, // #29
  {DBGFIELD("WriteFAddLd_ReadAfterVecLd") 1, false, false, false, 2373, 6,  9, 1,  3, 1}, // #30
  {DBGFIELD("WriteFAdd")          1, false, false, false, 2374, 4, 10, 1,  0, 0}, // #31
  {DBGFIELD("WriteFAddLd")        1, false, false, false, 2373, 6,  9, 1,  0, 0}, // #32
  {DBGFIELD("WriteAESDecEncLd_ReadAfterVecXLd") 2, false, false, false, 2379, 6, 21, 1,  3, 1}, // #33
  {DBGFIELD("WriteAESDecEnc")     2, false, false, false, 2380, 4, 22, 1,  0, 0}, // #34
  {DBGFIELD("WriteAESIMCLd")      1, false, false, false, 2379, 6,  9, 1,  0, 0}, // #35
  {DBGFIELD("WriteAESIMC")        1, false, false, false, 2380, 4, 10, 1,  0, 0}, // #36
  {DBGFIELD("WriteAESKeyGenLd")   1, false, false, false, 2379, 6,  9, 1,  0, 0}, // #37
  {DBGFIELD("WriteAESKeyGen")     1, false, false, false, 2380, 4, 10, 1,  0, 0}, // #38
  {DBGFIELD("WriteFLogicLd_ReadAfterVecXLd") 1, false, false, false, 2385, 5,  6, 1,  3, 1}, // #39
  {DBGFIELD("WriteFLogic")        1, false, false, false, 2322, 3, 12, 1,  0, 0}, // #40
  {DBGFIELD("WriteBEXTRLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, false, 2369, 4,  3, 1, 19, 1}, // #41
  {DBGFIELD("WriteBEXTR")         2, false, false, false, 2320, 2, 12, 1,  0, 0}, // #42
  {DBGFIELD("WriteBEXTRLd")       2, false, false, false, 2369, 4,  3, 1,  0, 0}, // #43
  {DBGFIELD("WriteALULd")         1, false, false, false, 2369, 4, 10, 1,  0, 0}, // #44
  {DBGFIELD("WriteFBlendLd_ReadAfterVecXLd") 1, false, false, false, 2385, 5,  6, 1,  3, 1}, // #45
  {DBGFIELD("WriteFBlend")        1, false, false, false, 2322, 3, 12, 1,  0, 0}, // #46
  {DBGFIELD("WriteFVarBlendLd_ReadAfterVecXLd") 1, false, false, false, 2390, 6,  6, 1,  3, 1}, // #47
  {DBGFIELD("WriteFVarBlend")     1, false, false, false, 2391, 4, 12, 1,  0, 0}, // #48
  {DBGFIELD("WriteBLSLd")         2, false, false, false, 2369, 4,  3, 1,  0, 0}, // #49
  {DBGFIELD("WriteBLS")           2, false, false, false, 2320, 2, 12, 1,  0, 0}, // #50
  {DBGFIELD("WriteBSFLd")         8, false, false, false, 2396, 4,  6, 1,  0, 0}, // #51
  {DBGFIELD("WriteBSF")           6, false, false, false, 2343, 2,  5, 1,  0, 0}, // #52
  {DBGFIELD("WriteBSRLd")         9, false, false, false, 2400, 4,  7, 1,  0, 0}, // #53
  {DBGFIELD("WriteBSR")           7, false, false, false, 2401, 2, 14, 1,  0, 0}, // #54
  {DBGFIELD("WriteBSWAP32")       1, false, false, false, 2341, 2,  1, 1,  0, 0}, // #55
  {DBGFIELD("WriteBSWAP64")       1, false, false, false, 2341, 2,  1, 1,  0, 0}, // #56
  {DBGFIELD("WriteBitTestImmLd")  1, false, false, false, 2369, 4, 10, 1,  0, 0}, // #57
  {DBGFIELD("WriteBitTestRegLd")  7, false, false, false, 2404, 4, 10, 1,  0, 0}, // #58
  {DBGFIELD("WriteBitTest")       1, false, false, false, 2320, 2,  1, 1,  0, 0}, // #59
  {DBGFIELD("WriteBitTestSetImmRMW") 4, false, false, false, 2408, 4,  6, 1,  0, 0}, // #60
  {DBGFIELD("WriteBitTestSetRegRMW") 10, false, false, false, 2412, 4,  6, 1,  0, 0}, // #61
  {DBGFIELD("WriteBitTestSet")    2, false, false, false, 2320, 2, 12, 1,  0, 0}, // #62
  {DBGFIELD("WriteBZHILd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, false, 2416, 4, 10, 1, 19, 1}, // #63
  {DBGFIELD("WriteBZHI")          1, false, false, false, 2341, 2,  1, 1,  0, 0}, // #64
  {DBGFIELD("WriteLoad")          1, false, false, false, 2420, 2, 10, 1,  0, 0}, // #65
  {DBGFIELD("WriteCMOVLd_ReadAfterLd") 1, false, false, false, 2416, 4, 10, 1, 21, 1}, // #66
  {DBGFIELD("WriteCMOV")          1, false, false, false, 2341, 2,  1, 1,  0, 0}, // #67
  {DBGFIELD("WriteFCMOV")         1, false, false, false, 2374, 4,  1, 1,  0, 0}, // #68
  {DBGFIELD("WriteALULd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, false, 2369, 4, 10, 1, 19, 1}, // #69
  {DBGFIELD("WriteXCHG")          2, false, false, false, 11, 3,  1, 1,  0, 0}, // #70
  {DBGFIELD("WriteFCmp64XLd_ReadAfterVecXLd") 1, false, false, false, 2373, 6,  6, 1,  3, 1}, // #71
  {DBGFIELD("WriteFCmp64X")       1, false, false, false, 2374, 4, 12, 1,  0, 0}, // #72
  {DBGFIELD("WriteFCmpXLd_ReadAfterVecXLd") 1, false, false, false, 2373, 6,  6, 1,  3, 1}, // #73
  {DBGFIELD("WriteFCmpX")         1, false, false, false, 2374, 4, 12, 1,  0, 0}, // #74
  {DBGFIELD("WriteFCmp64Ld_ReadAfterVecLd") 1, false, false, false, 2373, 6,  6, 1,  3, 1}, // #75
  {DBGFIELD("WriteFCmp64")        1, false, false, false, 2374, 4, 12, 1,  0, 0}, // #76
  {DBGFIELD("WriteFCmpLd_ReadAfterVecLd") 1, false, false, false, 2373, 6,  6, 1,  3, 1}, // #77
  {DBGFIELD("WriteFCmp")          1, false, false, false, 2374, 4, 12, 1,  0, 0}, // #78
  {DBGFIELD("WriteCMPXCHG")       5, false, false, false, 2422, 3,  5, 1,  0, 0}, // #79
  {DBGFIELD("WriteFComXLd_ReadAfterVecLd") 2, false, false, false, 2425, 9,  3, 1,  3, 1}, // #80
  {DBGFIELD("WriteFComX")         2, false, false, false, 2426, 7,  1, 1,  0, 0}, // #81
  {DBGFIELD("WriteFCom")          2, false, false, false, 2426, 7,  1, 1,  0, 0}, // #82
  {DBGFIELD("WriteCRC32Ld_ReadAfterLd") 3, false, false, false, 2434, 4,  3, 1, 21, 1}, // #83
  {DBGFIELD("WriteCRC32")         3, false, false, false, 2435, 2, 12, 1,  0, 0}, // #84
  {DBGFIELD("WriteCvtI2PDLd")     2, false, false, false, 2438, 7, 24, 1,  0, 0}, // #85
  {DBGFIELD("WriteCvtI2PD")       2, false, false, false, 2439, 5,  7, 1,  0, 0}, // #86
  {DBGFIELD("WriteCvtI2PSLd")     1, false, false, false, 2438, 7, 22, 1,  0, 0}, // #87
  {DBGFIELD("WriteCvtI2PS")       1, false, false, false, 2439, 5, 14, 1,  0, 0}, // #88
  {DBGFIELD("WriteCvtPD2ILd")     2, false, false, false, 2438, 7, 24, 1,  0, 0}, // #89
  {DBGFIELD("WriteCvtPD2I")       2, false, false, false, 2439, 5,  7, 1,  0, 0}, // #90
  {DBGFIELD("WriteCvtPD2PSLd")    2, false, false, false, 2438, 7, 24, 1,  0, 0}, // #91
  {DBGFIELD("WriteCvtPD2PS")      2, false, false, false, 2439, 5,  7, 1,  0, 0}, // #92
  {DBGFIELD("WriteCvtPS2ILd")     1, false, false, false, 2438, 7, 22, 1,  0, 0}, // #93
  {DBGFIELD("WriteCvtPS2I")       1, false, false, false, 2439, 5, 14, 1,  0, 0}, // #94
  {DBGFIELD("WriteCvtPS2PDLd")    2, false, false, false, 2438, 7, 24, 1,  0, 0}, // #95
  {DBGFIELD("WriteCvtPS2PD")      2, false, false, false, 2439, 5,  7, 1,  0, 0}, // #96
  {DBGFIELD("WriteCvtSD2ILd")     2, false, false, false, 2445, 11, 13, 1,  0, 0}, // #97
  {DBGFIELD("WriteCvtSD2I_ReadDefault") 2, false, false, false, 2446, 9, 24, 1,  0, 0}, // #98
  {DBGFIELD("WriteCvtSD2I")       2, false, false, false, 2446, 9, 24, 1,  0, 0}, // #99
  {DBGFIELD("WriteCvtSD2SSLd_ReadAfterVecLd") 1, false, false, false, 2456, 7, 22, 1,  3, 1}, // #100
  {DBGFIELD("WriteCvtSD2SS")      1, false, false, false, 2457, 5, 14, 1,  0, 0}, // #101
  {DBGFIELD("WriteCvtI2SDLd")     2, false, false, false, 2438, 7, 22, 1,  0, 0}, // #102
  {DBGFIELD("WriteCvtI2SDLd_ReadAfterVecLd") 2, false, false, false, 2438, 7, 22, 1,  3, 1}, // #103
  {DBGFIELD("WriteCvtI2SD_ReadInt2Fpu") 2, false, false, false, 2439, 5, 14, 1, 23, 1}, // #104
  {DBGFIELD("WriteCvtI2SD_ReadDefault_ReadInt2Fpu") 2, false, false, false, 2439, 5, 14, 1, 24, 1}, // #105
  {DBGFIELD("WriteCvtI2SSLd")     2, false, false, false, 2438, 7, 22, 1,  0, 0}, // #106
  {DBGFIELD("WriteCvtI2SSLd_ReadAfterVecLd") 2, false, false, false, 2438, 7, 22, 1,  3, 1}, // #107
  {DBGFIELD("WriteCvtI2SS_ReadInt2Fpu") 2, false, false, false, 2439, 5, 14, 1, 23, 1}, // #108
  {DBGFIELD("WriteCvtI2SS_ReadDefault_ReadInt2Fpu") 2, false, false, false, 2439, 5, 14, 1, 24, 1}, // #109
  {DBGFIELD("WriteCvtSS2SDLd_ReadAfterVecLd") 1, false, false, false, 2456, 7, 22, 1,  3, 1}, // #110
  {DBGFIELD("WriteCvtSS2SD")      1, false, false, false, 2457, 5, 14, 1,  0, 0}, // #111
  {DBGFIELD("WriteCvtSS2ILd")     2, false, false, false, 2445, 11, 13, 1,  0, 0}, // #112
  {DBGFIELD("WriteCvtSS2I_ReadDefault") 2, false, false, false, 2446, 9, 24, 1,  0, 0}, // #113
  {DBGFIELD("WriteCvtSS2I")       2, false, false, false, 2446, 9, 24, 1,  0, 0}, // #114
  {DBGFIELD("WriteDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, false, 2463, 6, 17, 1, 19, 2}, // #115
  {DBGFIELD("WriteDiv16")         2, false, false, false, 2464, 4, 11, 1,  0, 0}, // #116
  {DBGFIELD("WriteDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, false, 2469, 6, 13, 1, 19, 2}, // #117
  {DBGFIELD("WriteDiv32")         2, false, false, false, 2470, 4, 21, 1,  0, 0}, // #118
  {DBGFIELD("WriteDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, false, 2469, 6, 13, 1, 19, 2}, // #119
  {DBGFIELD("WriteDiv64")         2, false, false, false, 2470, 4, 21, 1,  0, 0}, // #120
  {DBGFIELD("WriteDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, false, 2475, 6, 16, 1, 19, 2}, // #121
  {DBGFIELD("WriteDiv8")          1, false, false, false, 2476, 4,  2, 1,  0, 0}, // #122
  {DBGFIELD("WriteFDiv64XLd_ReadAfterVecXLd") 1, false, false, false, 2481, 6, 21, 1,  3, 1}, // #123
  {DBGFIELD("WriteFDiv64X")       1, false, false, false, 2482, 4, 22, 1,  0, 0}, // #124
  {DBGFIELD("WriteFDivXLd_ReadAfterVecXLd") 1, false, false, false, 2481, 6, 21, 1,  3, 1}, // #125
  {DBGFIELD("WriteFDivX")         1, false, false, false, 2482, 4, 22, 1,  0, 0}, // #126
  {DBGFIELD("WriteFDivLd")        1, false, false, false, 2481, 6, 21, 1,  0, 0}, // #127
  {DBGFIELD("WriteFDiv")          1, false, false, false, 2482, 4, 22, 1,  0, 0}, // #128
  {DBGFIELD("WriteFDiv64Ld_ReadAfterVecLd") 1, false, false, false, 2481, 6, 21, 1,  3, 1}, // #129
  {DBGFIELD("WriteFDiv64")        1, false, false, false, 2482, 4, 22, 1,  0, 0}, // #130
  {DBGFIELD("WriteFDivLd_ReadAfterVecLd") 1, false, false, false, 2481, 6, 21, 1,  3, 1}, // #131
  {DBGFIELD("WriteDPPDLd_ReadAfterVecXLd") 17, false, false, false, 2487, 6, 15, 1,  3, 1}, // #132
  {DBGFIELD("WriteDPPD")          15, false, false, false, 2488, 4, 11, 1,  0, 0}, // #133
  {DBGFIELD("WriteDPPSLd_ReadAfterVecXLd") 18, false, false, false, 2493, 6, 60, 1,  3, 1}, // #134
  {DBGFIELD("WriteDPPS")          16, false, false, false, 2494, 4, 42, 1,  0, 0}, // #135
  {DBGFIELD("WriteStore")         1, false, false, false, 2499, 2,  1, 1,  0, 0}, // #136
  {DBGFIELD("WriteVecExtractSt")  2, false, false, false, 2501, 6, 24, 1,  0, 0}, // #137
  {DBGFIELD("WriteVecExtract")    2, false, false, false, 2507, 7,  2, 1,  0, 0}, // #138
  {DBGFIELD("WriteVecALUX")       1, false, false, false, 2322, 3, 12, 1,  0, 0}, // #139
  {DBGFIELD("WriteFComLd")        2, false, false, false, 2425, 9,  3, 1,  0, 0}, // #140
  {DBGFIELD("WriteEMMS")          1, false, false, false, 2514, 3, 12, 1,  0, 0}, // #141
  {DBGFIELD("WriteFLDC")          1, false, false, false, 2517, 4,  5, 1,  0, 0}, // #142
  {DBGFIELD("WriteVecIMulXLd_ReadAfterVecXLd") 1, false, false, false, 2379, 6, 22, 1,  3, 1}, // #143
  {DBGFIELD("WriteVecIMulX")      1, false, false, false, 2380, 4, 14, 1,  0, 0}, // #144
  {DBGFIELD("WriteVecALUXLd_ReadAfterVecXLd") 1, false, false, false, 2385, 5,  6, 1,  3, 1}, // #145
  {DBGFIELD("WriteFHAddLd_ReadAfterVecXLd") 4, false, false, false, 2521, 6, 16, 1,  3, 1}, // #146
  {DBGFIELD("WriteFHAdd")         3, false, false, false, 2522, 4,  8, 1,  0, 0}, // #147
  {DBGFIELD("WriteIDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, false, 2527, 6, 17, 1, 19, 2}, // #148
  {DBGFIELD("WriteIDiv16")        2, false, false, false, 2528, 4, 11, 1,  0, 0}, // #149
  {DBGFIELD("WriteIDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, false, 2533, 6, 13, 1, 19, 2}, // #150
  {DBGFIELD("WriteIDiv32")        2, false, false, false, 2534, 4, 21, 1,  0, 0}, // #151
  {DBGFIELD("WriteIDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, false, 2469, 6, 13, 1, 19, 2}, // #152
  {DBGFIELD("WriteIDiv64")        2, false, false, false, 2470, 4, 21, 1,  0, 0}, // #153
  {DBGFIELD("WriteIDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, false, 2475, 6, 16, 1, 19, 2}, // #154
  {DBGFIELD("WriteIDiv8")         1, false, false, false, 2476, 4,  2, 1,  0, 0}, // #155
  {DBGFIELD("WriteIMul16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, false, 2539, 6,  7, 1, 19, 2}, // #156
  {DBGFIELD("WriteIMul16")        2, false, false, false, 2545, 4, 14, 1,  0, 0}, // #157
  {DBGFIELD("WriteIMul16RegLd_ReadAfterLd") 1, false, false, false, 2549, 6,  7, 1, 21, 1}, // #158
  {DBGFIELD("WriteIMul16ImmLd")   2, false, false, false, 2539, 6, 22, 1,  0, 0}, // #159
  {DBGFIELD("WriteIMul16Reg")     1, false, false, false, 2555, 4, 14, 1,  0, 0}, // #160
  {DBGFIELD("WriteIMul16Imm")     2, false, false, false, 2545, 4, 10, 1,  0, 0}, // #161
  {DBGFIELD("WriteIMul32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, false, 2559, 6,  7, 1, 19, 2}, // #162
  {DBGFIELD("WriteIMul32")        1, false, false, false, 2565, 4, 14, 1,  0, 0}, // #163
  {DBGFIELD("WriteIMul32RegLd_ReadAfterLd") 1, false, false, false, 2549, 6,  7, 1, 21, 1}, // #164
  {DBGFIELD("WriteIMul32ImmLd")   2, false, false, false, 2549, 6,  7, 1,  0, 0}, // #165
  {DBGFIELD("WriteIMul32Reg")     1, false, false, false, 2555, 4, 14, 1,  0, 0}, // #166
  {DBGFIELD("WriteIMul32Imm")     1, false, false, false, 2555, 4, 14, 1,  0, 0}, // #167
  {DBGFIELD("WriteIMul64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, false, 2569, 6,  9, 1, 19, 2}, // #168
  {DBGFIELD("WriteIMul64")        1, false, false, false, 2575, 4,  3, 1,  0, 0}, // #169
  {DBGFIELD("WriteIMul64RegLd_ReadAfterLd") 1, false, false, false, 2559, 6,  9, 1, 21, 1}, // #170
  {DBGFIELD("WriteIMul64ImmLd")   2, false, false, false, 2559, 6,  9, 1,  0, 0}, // #171
  {DBGFIELD("WriteIMul64Reg")     1, false, false, false, 2565, 4,  3, 1,  0, 0}, // #172
  {DBGFIELD("WriteIMul64Imm")     1, false, false, false, 2565, 4,  3, 1,  0, 0}, // #173
  {DBGFIELD("WriteIMul8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, false, 2559, 6,  7, 1, 19, 2}, // #174
  {DBGFIELD("WriteIMul8")         1, false, false, false, 2565, 4, 14, 1,  0, 0}, // #175
  {DBGFIELD("WriteFShuffleLd_ReadAfterVecXLd") 1, false, false, false, 2579, 5,  6, 1,  3, 1}, // #176
  {DBGFIELD("WriteFShuffle")      1, false, false, false, 2580, 3, 12, 1,  0, 0}, // #177
  {DBGFIELD("WriteVecLogicX")     1, false, false, false, 2322, 3, 12, 1,  0, 0}, // #178
  {DBGFIELD("WriteShuffle")       1, false, false, false, 2391, 4, 12, 1,  0, 0}, // #179
  {DBGFIELD("WriteLAHFSAHF")      2, false, false, false, 2435, 2, 12, 1,  0, 0}, // #180
  {DBGFIELD("WriteVecLoadX")      1, false, false, false, 2584, 5, 10, 1,  0, 0}, // #181
  {DBGFIELD("WriteLDMXCSR")       1, false, false, false, 2589, 2, 10, 1,  0, 0}, // #182
  {DBGFIELD("WriteFLD0")          1, false, false, false, 2517, 4,  5, 1,  0, 0}, // #183
  {DBGFIELD("WriteFLD1")          1, false, false, false, 2517, 4,  5, 1,  0, 0}, // #184
  {DBGFIELD("WriteLEA")           1, false, false, false, 2320, 2,  1, 1,  0, 0}, // #185
  {DBGFIELD("WriteFence")         1, false, false, false, 2499, 2,  1, 1,  0, 0}, // #186
  {DBGFIELD("WriteLZCNTLd")       2, false, false, false, 2591, 5,  3, 1,  0, 0}, // #187
  {DBGFIELD("WriteLZCNT")         2, false, false, false, 2592, 3, 12, 1,  0, 0}, // #188
  {DBGFIELD("WriteVecStoreX")     1, false, false, false, 2345, 5,  1, 1,  0, 0}, // #189
  {DBGFIELD("WriteVecStore")      1, false, false, false, 2345, 5, 12, 1,  0, 0}, // #190
  {DBGFIELD("WriteVecMoveToGpr")  1, false, false, false, 2426, 7,  8, 1,  0, 0}, // #191
  {DBGFIELD("WriteVecLoad")       1, false, false, false, 2584, 5, 10, 1,  0, 0}, // #192
  {DBGFIELD("WriteVecMoveFromGpr") 2, false, false, false, 2580, 3,  8, 1,  0, 0}, // #193
  {DBGFIELD("WriteVecMoveX")      1, false, false, false, 2596, 3,  1, 1,  0, 0}, // #194
  {DBGFIELD("WriteVecStoreNT")    1, false, false, false, 2599, 6, 12, 1,  0, 0}, // #195
  {DBGFIELD("WriteVecMove")       1, false, false, false, 2605, 3, 12, 1,  0, 0}, // #196
  {DBGFIELD("WriteVecALULd")      1, false, false, false, 2385, 5,  6, 1,  0, 0}, // #197
  {DBGFIELD("WriteShuffleLd_ReadAfterVecLd") 1, false, false, false, 2390, 6,  6, 1,  3, 1}, // #198
  {DBGFIELD("WriteVecALULd_ReadAfterVecLd") 1, false, false, false, 2385, 5,  6, 1,  3, 1}, // #199
  {DBGFIELD("WriteVecLogicLd_ReadAfterVecLd") 1, false, false, false, 2385, 5,  6, 1,  3, 1}, // #200
  {DBGFIELD("WriteVecLogic")      1, false, false, false, 2322, 3, 12, 1,  0, 0}, // #201
  {DBGFIELD("WritePHAddLd_ReadAfterVecLd") 4, false, false, false, 2608, 5,  9, 1,  3, 1}, // #202
  {DBGFIELD("WritePHAdd")         3, false, false, false, 2609, 3, 10, 1,  0, 0}, // #203
  {DBGFIELD("WriteVecInsertLd_ReadAfterLd") 2, false, false, false, 2608, 5,  3, 1, 21, 1}, // #204
  {DBGFIELD("WriteVecInsert_ReadDefault_ReadInt2Fpu") 2, false, false, false, 2585, 3, 12, 1, 24, 1}, // #205
  {DBGFIELD("WriteVecIMulLd_ReadAfterVecLd") 1, false, false, false, 2379, 6, 22, 1,  3, 1}, // #206
  {DBGFIELD("WriteVecIMul")       1, false, false, false, 2380, 4, 14, 1,  0, 0}, // #207
  {DBGFIELD("WriteMMXMOVMSK")     2, false, false, false, 2426, 7,  9, 1,  0, 0}, // #208
  {DBGFIELD("WritePSADBWLd_ReadAfterVecLd") 2, false, false, false, 2613, 5, 22, 1,  3, 1}, // #209
  {DBGFIELD("WritePSADBW")        2, false, false, false, 2596, 3, 14, 1,  0, 0}, // #210
  {DBGFIELD("WriteVarShuffleLd_ReadAfterVecLd") 1, false, false, false, 2390, 6,  7, 1,  3, 1}, // #211
  {DBGFIELD("WriteVarShuffle")    1, false, false, false, 2391, 4,  5, 1,  0, 0}, // #212
  {DBGFIELD("WriteShuffleLd")     1, false, false, false, 2390, 6,  6, 1,  0, 0}, // #213
  {DBGFIELD("WriteVecShiftImm")   1, false, false, false, 2391, 4, 12, 1,  0, 0}, // #214
  {DBGFIELD("WriteVecShiftLd_ReadAfterVecLd") 1, false, false, false, 2390, 6,  7, 1,  3, 1}, // #215
  {DBGFIELD("WriteVecShift")      1, false, false, false, 2391, 4,  5, 1,  0, 0}, // #216
  {DBGFIELD("WriteFMoveX")        1, false, false, false, 2580, 3,  1, 1,  0, 0}, // #217
  {DBGFIELD("WriteFShuffleLd")    1, false, false, false, 2579, 5,  6, 1,  0, 0}, // #218
  {DBGFIELD("WriteFStore")        1, false, false, false, 2345, 5, 12, 1,  0, 0}, // #219
  {DBGFIELD("WriteFMOVMSK")       2, false, false, false, 2426, 7,  2, 1,  0, 0}, // #220
  {DBGFIELD("WriteVecLoadNT")     1, false, false, false, 2608, 5, 10, 1,  0, 0}, // #221
  {DBGFIELD("WriteStoreNT")       1, false, false, false, 2499, 2,  1, 1,  0, 0}, // #222
  {DBGFIELD("WriteFStoreNTX")     1, false, false, false, 2599, 6,  5, 1,  0, 0}, // #223
  {DBGFIELD("WriteFStoreNT")      1, false, false, false, 2599, 6,  5, 1,  0, 0}, // #224
  {DBGFIELD("WriteFLoad")         1, false, false, false, 2350, 5, 10, 1,  0, 0}, // #225
  {DBGFIELD("WriteMPSADLd_ReadAfterVecXLd") 8, false, false, false, 2618, 6, 21, 1,  3, 1}, // #226
  {DBGFIELD("WriteMPSAD")         8, false, false, false, 2619, 4,  7, 1,  0, 0}, // #227
  {DBGFIELD("WriteFMul64XLd_ReadAfterVecXLd") 1, false, false, false, 2624, 6,  9, 1,  3, 1}, // #228
  {DBGFIELD("WriteFMul64X")       1, false, false, false, 2625, 4, 10, 1,  0, 0}, // #229
  {DBGFIELD("WriteFMulXLd_ReadAfterVecXLd") 1, false, false, false, 2624, 6,  9, 1,  3, 1}, // #230
  {DBGFIELD("WriteFMulX")         1, false, false, false, 2625, 4, 10, 1,  0, 0}, // #231
  {DBGFIELD("WriteFMul64Ld_ReadAfterVecLd") 1, false, false, false, 2624, 6,  9, 1,  3, 1}, // #232
  {DBGFIELD("WriteFMul64")        1, false, false, false, 2625, 4, 10, 1,  0, 0}, // #233
  {DBGFIELD("WriteFMulLd_ReadAfterVecLd") 1, false, false, false, 2624, 6,  9, 1,  3, 1}, // #234
  {DBGFIELD("WriteFMul")          1, false, false, false, 2625, 4, 10, 1,  0, 0}, // #235
  {DBGFIELD("WriteMULX32Ld")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #236
  {DBGFIELD("WriteMULX32")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #237
  {DBGFIELD("WriteIMulHLd_WriteMULX32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #238
  {DBGFIELD("WriteIMulH_WriteMULX32") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #239
  {DBGFIELD("WriteMULX64Ld")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #240
  {DBGFIELD("WriteMULX64")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #241
  {DBGFIELD("WriteIMulHLd_WriteMULX64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #242
  {DBGFIELD("WriteIMulH_WriteMULX64") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #243
  {DBGFIELD("WriteFMulLd")        1, false, false, false, 2624, 6,  9, 1,  0, 0}, // #244
  {DBGFIELD("WriteVecALUXLd")     1, false, false, false, 2385, 5,  6, 1,  0, 0}, // #245
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd") 1, false, false, false, 2390, 6,  6, 1,  3, 1}, // #246
  {DBGFIELD("WriteShuffleX")      1, false, false, false, 2391, 4, 12, 1,  0, 0}, // #247
  {DBGFIELD("WriteVecLogicXLd_ReadAfterVecXLd") 1, false, false, false, 2385, 5,  6, 1,  3, 1}, // #248
  {DBGFIELD("WriteVarBlendLd_ReadAfterVecXLd") 1, false, false, false, 2390, 6,  6, 1,  3, 1}, // #249
  {DBGFIELD("WriteVarBlend")      1, false, false, false, 2391, 4, 12, 1,  0, 0}, // #250
  {DBGFIELD("WriteBlendLd_ReadAfterVecXLd") 1, false, false, false, 2385, 5,  6, 1,  3, 1}, // #251
  {DBGFIELD("WriteBlend")         1, false, false, false, 2322, 3, 12, 1,  0, 0}, // #252
  {DBGFIELD("WriteCLMulLd_ReadAfterVecXLd") 6, false, false, false, 2630, 6, 20, 1,  3, 1}, // #253
  {DBGFIELD("WriteCLMul")         5, false, false, false, 2631, 4,  2, 1,  0, 0}, // #254
  {DBGFIELD("WritePCmpEStrILd_ReadAfterVecXLd") 28, false, false, false, 2636, 11, 17, 1,  3, 1}, // #255
  {DBGFIELD("WritePCmpEStrI")     27, false, false, false, 2647, 11, 21, 1,  0, 0}, // #256
  {DBGFIELD("WritePCmpEStrMLd_ReadAfterVecXLd") 28, false, false, false, 2636, 11, 11, 1,  3, 1}, // #257
  {DBGFIELD("WritePCmpEStrM")     27, false, false, false, 2647, 11,  9, 1,  0, 0}, // #258
  {DBGFIELD("WritePCmpIStrILd_ReadAfterVecXLd") 8, false, false, false, 2658, 9, 16, 1,  3, 1}, // #259
  {DBGFIELD("WritePCmpIStrI")     7, false, false, false, 2659, 7,  8, 1,  0, 0}, // #260
  {DBGFIELD("WritePCmpIStrMLd_ReadAfterVecXLd") 9, false, false, false, 2667, 9,  2, 1,  3, 1}, // #261
  {DBGFIELD("WritePCmpIStrM")     7, false, false, false, 2668, 7,  6, 1,  0, 0}, // #262
  {DBGFIELD("WriteCvtPS2ILd_ReadAfterVecXLd") 1, false, false, false, 2438, 7, 22, 1,  3, 1}, // #263
  {DBGFIELD("WritePHAddXLd_ReadAfterVecXLd") 1, false, false, false, 2613, 5,  6, 1,  3, 1}, // #264
  {DBGFIELD("WritePHAddX")        1, false, false, false, 2596, 3, 12, 1,  0, 0}, // #265
  {DBGFIELD("WritePHMINPOSLd")    2, false, false, false, 2676, 6, 22, 1,  0, 0}, // #266
  {DBGFIELD("WritePHMINPOS")      2, false, false, false, 2677, 4, 14, 1,  0, 0}, // #267
  {DBGFIELD("WriteCvtI2PSLd_ReadAfterVecXLd") 1, false, false, false, 2438, 7, 22, 1,  3, 1}, // #268
  {DBGFIELD("WriteVecMOVMSK")     2, false, false, false, 2426, 7,  2, 1,  0, 0}, // #269
  {DBGFIELD("WriteShuffleXLd")    1, false, false, false, 2390, 6,  6, 1,  0, 0}, // #270
  {DBGFIELD("WritePMULLDLd_ReadAfterVecXLd") 1, false, false, false, 2682, 7,  9, 1,  3, 1}, // #271
  {DBGFIELD("WritePMULLD")        1, false, false, false, 2683, 5, 10, 1,  0, 0}, // #272
  {DBGFIELD("WriteCopy")          2, false, false, false, 2689, 3,  3, 1,  0, 0}, // #273
  {DBGFIELD("WritePOPCNTLd")      1, false, false, false, 2434, 4,  7, 1,  0, 0}, // #274
  {DBGFIELD("WritePOPCNT")        1, false, false, false, 2435, 2, 14, 1,  0, 0}, // #275
  {DBGFIELD("WritePSADBWXLd_ReadAfterVecXLd") 2, false, false, false, 2613, 5, 22, 1,  3, 1}, // #276
  {DBGFIELD("WritePSADBWX")       2, false, false, false, 2596, 3, 14, 1,  0, 0}, // #277
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd") 1, false, false, false, 2390, 6,  7, 1,  3, 1}, // #278
  {DBGFIELD("WriteVarShuffleX")   1, false, false, false, 2391, 4,  5, 1,  0, 0}, // #279
  {DBGFIELD("WriteVecShiftImmX")  1, false, false, false, 2391, 4, 12, 1,  0, 0}, // #280
  {DBGFIELD("WriteVecShiftXLd_ReadAfterVecXLd") 1, false, false, false, 2390, 6,  7, 1,  3, 1}, // #281
  {DBGFIELD("WriteVecShiftX")     1, false, false, false, 2391, 4,  5, 1,  0, 0}, // #282
  {DBGFIELD("WriteVecTestLd_ReadAfterVecXLd") 2, false, false, false, 2425, 9,  3, 1,  3, 1}, // #283
  {DBGFIELD("WriteVecTest")       2, false, false, false, 2426, 7,  1, 1,  0, 0}, // #284
  {DBGFIELD("WriteRotateLd_WriteRMW") 2, false, false, false, 2360, 5, 120, 2,  0, 0}, // #285
  {DBGFIELD("WriteRotateCLLd_WriteRMW") 2, false, false, false, 2692, 5, 120, 2,  0, 0}, // #286
  {DBGFIELD("WriteRotate")        1, false, false, false, 2320, 2,  1, 1,  0, 0}, // #287
  {DBGFIELD("WriteRotateCL")      1, false, false, false, 2341, 2,  1, 1,  0, 0}, // #288
  {DBGFIELD("WriteFRcpXLd")       1, false, false, false, 2624, 6,  9, 1,  0, 0}, // #289
  {DBGFIELD("WriteFRcpX")         1, false, false, false, 2625, 4, 10, 1,  0, 0}, // #290
  {DBGFIELD("WriteFRcpLd")        1, false, false, false, 2624, 6,  9, 1,  0, 0}, // #291
  {DBGFIELD("WriteFRcpLd_ReadAfterVecLd") 1, false, false, false, 2624, 6,  9, 1,  3, 1}, // #292
  {DBGFIELD("WriteFRcp")          1, false, false, false, 2625, 4, 10, 1,  0, 0}, // #293
  {DBGFIELD("WriteRMW")           1, false, false, false, 2499, 2,  1, 1,  0, 0}, // #294
  {DBGFIELD("WriteShiftLd")       1, false, false, false, 2369, 4, 10, 1,  0, 0}, // #295
  {DBGFIELD("WriteShift")         1, false, false, false, 2320, 2,  1, 1,  0, 0}, // #296
  {DBGFIELD("WriteFRndLd")        1, false, false, false, 2697, 6, 22, 1,  0, 0}, // #297
  {DBGFIELD("WriteFRnd")          1, false, false, false, 2517, 4, 14, 1,  0, 0}, // #298
  {DBGFIELD("WriteFRndLd_ReadAfterVecXLd") 1, false, false, false, 2697, 6, 22, 1,  3, 1}, // #299
  {DBGFIELD("WriteFRsqrtXLd")     1, false, false, false, 2624, 6,  9, 1,  0, 0}, // #300
  {DBGFIELD("WriteFRsqrtX")       1, false, false, false, 2625, 4, 10, 1,  0, 0}, // #301
  {DBGFIELD("WriteFRsqrtLd")      1, false, false, false, 2703, 6,  9, 1,  0, 0}, // #302
  {DBGFIELD("WriteFRsqrtLd_ReadAfterVecLd") 1, false, false, false, 2703, 6,  9, 1,  3, 1}, // #303
  {DBGFIELD("WriteFRsqrt")        1, false, false, false, 2704, 4, 10, 1,  0, 0}, // #304
  {DBGFIELD("WriteShiftLd_WriteRMW") 2, false, false, false, 2360, 5, 120, 2,  0, 0}, // #305
  {DBGFIELD("WriteShiftCLLd_WriteRMW") 2, false, false, false, 2692, 5, 120, 2,  0, 0}, // #306
  {DBGFIELD("WriteShiftCL")       1, false, false, false, 2341, 2,  1, 1,  0, 0}, // #307
  {DBGFIELD("WriteShiftLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, false, 2369, 4, 10, 1, 19, 1}, // #308
  {DBGFIELD("WriteSETCCStore")    1, false, false, false, 2709, 4,  1, 1,  0, 0}, // #309
  {DBGFIELD("WriteSETCC")         1, false, false, false, 2341, 2,  1, 1,  0, 0}, // #310
  {DBGFIELD("WriteSHDmrcl")       8, false, false, false, 2713, 4, 14, 1,  0, 0}, // #311
  {DBGFIELD("WriteSHDmri")        8, false, false, false, 2713, 4, 14, 1,  0, 0}, // #312
  {DBGFIELD("WriteSHDrrcl")       7, false, false, false, 2401, 2,  5, 1,  0, 0}, // #313
  {DBGFIELD("WriteFSqrt64XLd")    1, false, false, false, 2481, 6, 21, 1,  0, 0}, // #314
  {DBGFIELD("WriteFSqrt64X")      1, false, false, false, 2482, 4, 22, 1,  0, 0}, // #315
  {DBGFIELD("WriteFSqrtXLd")      1, false, false, false, 2481, 6, 21, 1,  0, 0}, // #316
  {DBGFIELD("WriteFSqrtX")        1, false, false, false, 2482, 4, 22, 1,  0, 0}, // #317
  {DBGFIELD("WriteFSqrt64Ld")     1, false, false, false, 2481, 6, 21, 1,  0, 0}, // #318
  {DBGFIELD("WriteFSqrt64Ld_ReadAfterVecLd") 1, false, false, false, 2481, 6, 21, 1,  3, 1}, // #319
  {DBGFIELD("WriteFSqrt64")       1, false, false, false, 2482, 4, 22, 1,  0, 0}, // #320
  {DBGFIELD("WriteFSqrtLd")       1, false, false, false, 2481, 6, 21, 1,  0, 0}, // #321
  {DBGFIELD("WriteFSqrtLd_ReadAfterVecLd") 1, false, false, false, 2481, 6, 21, 1,  3, 1}, // #322
  {DBGFIELD("WriteFSqrt")         1, false, false, false, 2482, 4, 22, 1,  0, 0}, // #323
  {DBGFIELD("WriteFSqrt80")       1, false, false, false, 2717, 4,  1, 1,  0, 0}, // #324
  {DBGFIELD("WriteSTMXCSR")       2, false, false, false, 2721, 2,  1, 1,  0, 0}, // #325
  {DBGFIELD("WriteTZCNTLd")       2, false, false, false, 2591, 5,  3, 1,  0, 0}, // #326
  {DBGFIELD("WriteTZCNT")         2, false, false, false, 2592, 3, 12, 1,  0, 0}, // #327
  {DBGFIELD("WriteFMAZLd")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #328
  {DBGFIELD("WriteFMALd")         1, false, false, false, 2723, 4,  9, 1,  0, 0}, // #329
  {DBGFIELD("WriteFAdd64YLd_ReadAfterVecYLd") 2, false, false, false, 2727, 6,  9, 1,  3, 1}, // #330
  {DBGFIELD("WriteFAdd64Y")       2, false, false, false, 2728, 4, 10, 1,  0, 0}, // #331
  {DBGFIELD("WriteFAdd64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #332
  {DBGFIELD("WriteFAdd64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #333
  {DBGFIELD("WriteFAddYLd_ReadAfterVecYLd") 2, false, false, false, 2727, 6,  9, 1,  3, 1}, // #334
  {DBGFIELD("WriteFAddY")         2, false, false, false, 2728, 4, 10, 1,  0, 0}, // #335
  {DBGFIELD("WriteFAddZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #336
  {DBGFIELD("WriteFAddZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #337
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd") 2, false, false, false, 2733, 6,  6, 1,  3, 1}, // #338
  {DBGFIELD("WriteShuffleY")      2, false, false, false, 2734, 4, 12, 1,  0, 0}, // #339
  {DBGFIELD("WriteShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #340
  {DBGFIELD("WriteShuffleZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #341
  {DBGFIELD("WriteFLogicYLd_ReadAfterVecYLd") 2, false, false, false, 2739, 5,  6, 1,  3, 1}, // #342
  {DBGFIELD("WriteFLogicY")       2, false, false, false, 2740, 3, 12, 1,  0, 0}, // #343
  {DBGFIELD("WriteFLogicZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #344
  {DBGFIELD("WriteFLogicZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #345
  {DBGFIELD("WriteCvtPH2PSY")     4, false, false, false, 2457, 5,  7, 1,  0, 0}, // #346
  {DBGFIELD("WriteCvtPH2PS")      2, false, false, false, 2457, 5,  7, 1,  0, 0}, // #347
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterVecYLd") 2, false, false, false, 2733, 6,  6, 1,  3, 1}, // #348
  {DBGFIELD("WriteFVarBlendY")    2, false, false, false, 2734, 4, 12, 1,  0, 0}, // #349
  {DBGFIELD("WriteFVarBlendZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #350
  {DBGFIELD("WriteFVarBlendZ")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #351
  {DBGFIELD("WriteFBlendYLd_ReadAfterVecYLd") 2, false, false, false, 2739, 5,  6, 1,  3, 1}, // #352
  {DBGFIELD("WriteFBlendY")       2, false, false, false, 2740, 3, 12, 1,  0, 0}, // #353
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 2, false, false, false, 2733, 6,  6, 1,  3, 2}, // #354
  {DBGFIELD("WriteFVarBlendLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 1, false, false, false, 2390, 6,  6, 1,  3, 2}, // #355
  {DBGFIELD("WriteShuffle256Ld")  1, false, false, false, 2744, 5,  3, 1,  0, 0}, // #356
  {DBGFIELD("WriteShuffle256")    1, false, false, false, 2605, 3,  1, 1,  0, 0}, // #357
  {DBGFIELD("WriteShuffleYLd")    2, false, false, false, 2733, 6,  6, 1,  0, 0}, // #358
  {DBGFIELD("WriteFShuffle256")   2, false, false, false, 2351, 3, 12, 1,  0, 0}, // #359
  {DBGFIELD("WriteFShuffle256Ld") 2, false, false, false, 2350, 5,  6, 1,  0, 0}, // #360
  {DBGFIELD("WriteFCmp64YLd_ReadAfterVecYLd") 2, false, false, false, 2727, 6,  6, 1,  3, 1}, // #361
  {DBGFIELD("WriteFCmp64Y")       2, false, false, false, 2728, 4, 12, 1,  0, 0}, // #362
  {DBGFIELD("WriteFCmpYLd_ReadAfterVecYLd") 2, false, false, false, 2727, 6,  6, 1,  3, 1}, // #363
  {DBGFIELD("WriteFCmpY")         2, false, false, false, 2728, 4, 12, 1,  0, 0}, // #364
  {DBGFIELD("WriteFCmpZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #365
  {DBGFIELD("WriteFCmpZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #366
  {DBGFIELD("WriteVarShuffle256Ld") 1, false, false, false, 2744, 5,  3, 1,  0, 0}, // #367
  {DBGFIELD("WriteVarShuffle256") 1, false, false, false, 2605, 3,  1, 1,  0, 0}, // #368
  {DBGFIELD("WriteCvtI2PDYLd")    5, false, false, false, 2456, 7, 24, 1,  0, 0}, // #369
  {DBGFIELD("WriteCvtI2PDY")      4, false, false, false, 2457, 5,  7, 1,  0, 0}, // #370
  {DBGFIELD("WriteCvtI2PDZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #371
  {DBGFIELD("WriteCvtI2PDZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #372
  {DBGFIELD("WriteCvtI2PSYLd")    2, false, false, false, 2456, 7, 22, 1,  0, 0}, // #373
  {DBGFIELD("WriteCvtI2PSY")      2, false, false, false, 2457, 5, 14, 1,  0, 0}, // #374
  {DBGFIELD("WriteCvtI2PSZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #375
  {DBGFIELD("WriteCvtI2PSZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #376
  {DBGFIELD("WriteCvtPD2PSLd_ReadAfterVecXLd") 2, false, false, false, 2438, 7, 24, 1,  3, 1}, // #377
  {DBGFIELD("WriteCvtPD2PSYLd_ReadAfterVecYLd") 4, false, false, false, 2749, 8, 24, 1,  3, 1}, // #378
  {DBGFIELD("WriteCvtPD2PSY")     4, false, false, false, 2750, 6,  7, 1,  0, 0}, // #379
  {DBGFIELD("WriteCvtPD2PSZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #380
  {DBGFIELD("WriteCvtPD2PSZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #381
  {DBGFIELD("WriteCvtPD2PSYLd")   4, false, false, false, 2749, 8, 24, 1,  0, 0}, // #382
  {DBGFIELD("WriteCvtPD2PSZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #383
  {DBGFIELD("WriteCvtPD2IYLd")    4, false, false, false, 2749, 8, 24, 1,  0, 0}, // #384
  {DBGFIELD("WriteCvtPD2IY")      4, false, false, false, 2750, 6,  7, 1,  0, 0}, // #385
  {DBGFIELD("WriteCvtPD2IZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #386
  {DBGFIELD("WriteCvtPD2IZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #387
  {DBGFIELD("WriteCvtPS2IYLd")    2, false, false, false, 2456, 7, 22, 1,  0, 0}, // #388
  {DBGFIELD("WriteCvtPS2IY")      2, false, false, false, 2457, 5, 14, 1,  0, 0}, // #389
  {DBGFIELD("WriteCvtPS2IZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #390
  {DBGFIELD("WriteCvtPS2IZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #391
  {DBGFIELD("WriteCvtPS2PDYLd")   5, false, false, false, 2456, 7, 24, 1,  0, 0}, // #392
  {DBGFIELD("WriteCvtPS2PDY")     4, false, false, false, 2457, 5,  7, 1,  0, 0}, // #393
  {DBGFIELD("WriteCvtPS2PDZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #394
  {DBGFIELD("WriteCvtPS2PDZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #395
  {DBGFIELD("WriteCvtPH2PSYLd")   7, false, false, false, 2456, 7, 24, 1,  0, 0}, // #396
  {DBGFIELD("WriteCvtPH2PSLd")    3, false, false, false, 2456, 7, 24, 1,  0, 0}, // #397
  {DBGFIELD("WriteCvtPH2PSZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #398
  {DBGFIELD("WriteCvtPH2PSZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #399
  {DBGFIELD("WriteCvtPS2PHYSt")   4, false, false, false, 2757, 8, 14, 1,  0, 0}, // #400
  {DBGFIELD("WriteCvtPS2PHY")     4, false, false, false, 2750, 6,  7, 1,  0, 0}, // #401
  {DBGFIELD("WriteCvtPS2PHSt")    3, false, false, false, 2765, 7, 14, 1,  0, 0}, // #402
  {DBGFIELD("WriteCvtPS2PH")      2, false, false, false, 2457, 5,  7, 1,  0, 0}, // #403
  {DBGFIELD("WriteCvtPS2PHZSt")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #404
  {DBGFIELD("WriteCvtPS2PHZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #405
  {DBGFIELD("WriteCvtSD2ILd_ReadAfterVecLd") 2, false, false, false, 2445, 11, 13, 1,  3, 1}, // #406
  {DBGFIELD("WriteCvtSS2ILd_ReadAfterVecLd") 2, false, false, false, 2445, 11, 13, 1,  3, 1}, // #407
  {DBGFIELD("WritePSADBWYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #408
  {DBGFIELD("WritePSADBWY")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #409
  {DBGFIELD("WritePSADBWZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #410
  {DBGFIELD("WritePSADBWZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #411
  {DBGFIELD("WriteFDiv64YLd_ReadAfterVecYLd") 2, false, false, false, 2772, 6, 21, 1,  3, 1}, // #412
  {DBGFIELD("WriteFDiv64Y")       2, false, false, false, 2773, 4, 22, 1,  0, 0}, // #413
  {DBGFIELD("WriteFDiv64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #414
  {DBGFIELD("WriteFDiv64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #415
  {DBGFIELD("WriteFDivYLd_ReadAfterVecYLd") 2, false, false, false, 2772, 6, 21, 1,  3, 1}, // #416
  {DBGFIELD("WriteFDivY")         2, false, false, false, 2773, 4, 22, 1,  0, 0}, // #417
  {DBGFIELD("WriteFDivZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #418
  {DBGFIELD("WriteFDivZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #419
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd") 1, false, false, false, 2723, 4,  9, 1,  3, 1}, // #420
  {DBGFIELD("WriteFMAX")          1, false, false, false, 2351, 2, 10, 1,  0, 0}, // #421
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd") 2, false, false, false, 2723, 4,  9, 1,  3, 1}, // #422
  {DBGFIELD("WriteFMAY")          2, false, false, false, 2351, 2, 10, 1,  0, 0}, // #423
  {DBGFIELD("WriteFMAZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #424
  {DBGFIELD("WriteFMAZ")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #425
  {DBGFIELD("WriteDPPSYLd_ReadAfterVecYLd") 29, false, false, false, 2778, 6, 47, 1,  3, 1}, // #426
  {DBGFIELD("WriteDPPSY")         25, false, false, false, 2779, 4, 59, 1,  0, 0}, // #427
  {DBGFIELD("WriteVarShuffle256Ld_ReadAfterVecYLd") 1, false, false, false, 2744, 5,  3, 1,  3, 1}, // #428
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd_ReadAfterVecYLd") 2, false, false, false, 2723, 4,  9, 1, 11, 2}, // #429
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd_ReadAfterVecXLd") 1, false, false, false, 2723, 4,  9, 1, 11, 2}, // #430
  {DBGFIELD("WriteFMALd_ReadAfterVecLd") 1, false, false, false, 2723, 4,  9, 1,  3, 1}, // #431
  {DBGFIELD("WriteFMA")           1, false, false, false, 2351, 2, 10, 1,  0, 0}, // #432
  {DBGFIELD("WriteFMALd_ReadAfterVecLd_ReadAfterVecLd") 1, false, false, false, 2723, 4,  9, 1, 11, 2}, // #433
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 2, false, false, false, 2723, 4,  9, 1,  3, 2}, // #434
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 1, false, false, false, 2723, 4,  9, 1,  3, 2}, // #435
  {DBGFIELD("WriteFMALd_ReadAfterVecLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecLd") 1, false, false, false, 2723, 4,  9, 1,  3, 2}, // #436
  {DBGFIELD("WriteFRndYLd_ReadAfterVecYLd") 2, false, false, false, 2784, 6, 22, 1,  3, 1}, // #437
  {DBGFIELD("WriteFRndY")         2, false, false, false, 2502, 4, 14, 1,  0, 0}, // #438
  {DBGFIELD("WriteLoad_WriteVecMaskedGatherWriteback") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #439
  {DBGFIELD("WriteFRndZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #440
  {DBGFIELD("WriteFRndZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #441
  {DBGFIELD("WriteVecIMulYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #442
  {DBGFIELD("WriteVecIMulY")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #443
  {DBGFIELD("WriteVecIMulZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #444
  {DBGFIELD("WriteVecIMulZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #445
  {DBGFIELD("WriteVecALUYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #446
  {DBGFIELD("WriteVecALUY")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #447
  {DBGFIELD("WriteVecALUZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #448
  {DBGFIELD("WriteVecALUZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #449
  {DBGFIELD("WriteFHAddYLd_ReadAfterVecYLd") 10, false, false, false, 2790, 6, 16, 1,  3, 1}, // #450
  {DBGFIELD("WriteFHAddY")        8, false, false, false, 2791, 4,  8, 1,  0, 0}, // #451
  {DBGFIELD("WriteFShuffle256Ld_ReadAfterVecYLd") 2, false, false, false, 2350, 5,  6, 1,  3, 1}, // #452
  {DBGFIELD("WriteShuffle256Ld_ReadAfterVecYLd") 1, false, false, false, 2744, 5,  3, 1,  3, 1}, // #453
  {DBGFIELD("WriteVecLoadY")      2, false, false, false, 2796, 5, 10, 1,  0, 0}, // #454
  {DBGFIELD("WriteFMaskedStore64Y") 34, false, false, false, 2801, 5,  3, 1,  0, 0}, // #455
  {DBGFIELD("WriteFMaskedLoadY")  2, false, false, false, 2806, 5,  3, 1,  0, 0}, // #456
  {DBGFIELD("WriteFMaskedStore64") 18, false, false, false, 2811, 5,  3, 1,  0, 0}, // #457
  {DBGFIELD("WriteFMaskedLoad")   1, false, false, false, 2816, 5,  3, 1,  0, 0}, // #458
  {DBGFIELD("WriteFMaskedStore32Y") 34, false, false, false, 2801, 5,  3, 1,  0, 0}, // #459
  {DBGFIELD("WriteFMaskedStore32") 18, false, false, false, 2811, 5,  3, 1,  0, 0}, // #460
  {DBGFIELD("WriteFCmp64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #461
  {DBGFIELD("WriteFCmp64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #462
  {DBGFIELD("WriteFMoveY")        2, false, false, false, 2821, 3, 12, 1,  0, 0}, // #463
  {DBGFIELD("WriteFMoveZ")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #464
  {DBGFIELD("WriteFShuffleYLd")   2, false, false, false, 2806, 5,  6, 1,  0, 0}, // #465
  {DBGFIELD("WriteFShuffleY")     2, false, false, false, 2807, 3, 12, 1,  0, 0}, // #466
  {DBGFIELD("WriteFShuffleZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #467
  {DBGFIELD("WriteFShuffleZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #468
  {DBGFIELD("WriteVecStoreY")     4, false, false, false, 2824, 5,  1, 1,  0, 0}, // #469
  {DBGFIELD("WriteVecMoveY")      2, false, false, false, 2829, 3, 12, 1,  0, 0}, // #470
  {DBGFIELD("WriteVecMoveZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #471
  {DBGFIELD("WriteVecLoadNTY")    1, false, false, false, 2832, 5, 10, 1,  0, 0}, // #472
  {DBGFIELD("WriteVecStoreNTY")   4, false, false, false, 2837, 6, 12, 1,  0, 0}, // #473
  {DBGFIELD("WriteFStoreNTY")     4, false, false, false, 2837, 6,  5, 1,  0, 0}, // #474
  {DBGFIELD("WriteMPSADYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #475
  {DBGFIELD("WriteMPSADY")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #476
  {DBGFIELD("WriteFMul64YLd_ReadAfterVecYLd") 2, false, false, false, 2703, 6,  9, 1,  3, 1}, // #477
  {DBGFIELD("WriteFMul64Y")       2, false, false, false, 2704, 4, 10, 1,  0, 0}, // #478
  {DBGFIELD("WriteFMul64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #479
  {DBGFIELD("WriteFMul64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #480
  {DBGFIELD("WriteFMulYLd_ReadAfterVecYLd") 2, false, false, false, 2703, 6,  9, 1,  3, 1}, // #481
  {DBGFIELD("WriteFMulY")         2, false, false, false, 2704, 4, 10, 1,  0, 0}, // #482
  {DBGFIELD("WriteFMulZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #483
  {DBGFIELD("WriteFMulZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #484
  {DBGFIELD("WriteVecALUYLd")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #485
  {DBGFIELD("WriteVecALUZLd")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #486
  {DBGFIELD("WriteVecLogicYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #487
  {DBGFIELD("WriteVecLogicY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #488
  {DBGFIELD("WriteVecLogicZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #489
  {DBGFIELD("WriteVecLogicZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #490
  {DBGFIELD("WriteBlendYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #491
  {DBGFIELD("WriteBlendY")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #492
  {DBGFIELD("WriteVarBlendYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #493
  {DBGFIELD("WriteVarBlendY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #494
  {DBGFIELD("WriteVarBlendZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #495
  {DBGFIELD("WriteVarBlendZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #496
  {DBGFIELD("WriteVarBlendYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #497
  {DBGFIELD("WriteVarBlendLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 1, false, false, false, 2390, 6,  6, 1,  3, 2}, // #498
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 2, false, false, false, 2733, 6,  6, 1,  3, 2}, // #499
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd_ReadAfterVecYLd") 2, false, false, false, 2733, 6,  6, 1, 11, 2}, // #500
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 1, false, false, false, 2390, 6,  6, 1,  3, 2}, // #501
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd_ReadAfterVecXLd") 1, false, false, false, 2390, 6,  6, 1, 11, 2}, // #502
  {DBGFIELD("WriteFVarShuffle256Ld_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #503
  {DBGFIELD("WriteFVarShuffle256") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #504
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 2, false, false, false, 2733, 6,  7, 1,  3, 2}, // #505
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd_ReadAfterVecYLd") 2, false, false, false, 2733, 6,  7, 1, 11, 2}, // #506
  {DBGFIELD("WriteFVarShuffleY")  2, false, false, false, 2734, 4,  5, 1,  0, 0}, // #507
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 1, false, false, false, 2390, 6,  7, 1,  3, 2}, // #508
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd_ReadAfterVecXLd") 1, false, false, false, 2390, 6,  7, 1, 11, 2}, // #509
  {DBGFIELD("WriteFVarShuffle")   1, false, false, false, 2391, 4,  5, 1,  0, 0}, // #510
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd") 2, false, false, false, 2733, 6,  7, 1,  3, 1}, // #511
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd") 1, false, false, false, 2390, 6,  7, 1,  3, 1}, // #512
  {DBGFIELD("WriteFVarShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #513
  {DBGFIELD("WriteFVarShuffleZ")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #514
  {DBGFIELD("WritePHAddYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #515
  {DBGFIELD("WritePHAddY")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #516
  {DBGFIELD("WriteVecInsert")     2, false, false, false, 2585, 3, 12, 1,  0, 0}, // #517
  {DBGFIELD("WriteVecIMulXLd")    1, false, false, false, 2379, 6, 22, 1,  0, 0}, // #518
  {DBGFIELD("WriteVecIMulYLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #519
  {DBGFIELD("WriteVecIMulZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #520
  {DBGFIELD("WriteVecMaskedStore32Y") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #521
  {DBGFIELD("WriteVecMaskedLoadY") 2, false, false, false, 2832, 5,  3, 1,  0, 0}, // #522
  {DBGFIELD("WriteVecMaskedStore32") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #523
  {DBGFIELD("WriteVecMaskedLoad") 1, false, false, false, 2613, 5,  3, 1,  0, 0}, // #524
  {DBGFIELD("WriteVecMaskedStore64Y") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #525
  {DBGFIELD("WriteVecMaskedStore64") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #526
  {DBGFIELD("WriteVPMOV256Ld")    1, false, false, false, 2744, 5,  3, 1,  0, 0}, // #527
  {DBGFIELD("WriteVPMOV256")      1, false, false, false, 2605, 3,  1, 1,  0, 0}, // #528
  {DBGFIELD("WriteVecMOVMSKY")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #529
  {DBGFIELD("WritePMULLDYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #530
  {DBGFIELD("WritePMULLDY")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #531
  {DBGFIELD("WritePMULLDZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #532
  {DBGFIELD("WritePMULLDZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #533
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 1, false, false, false, 2390, 6,  7, 1,  3, 2}, // #534
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd_ReadAfterVecXLd") 1, false, false, false, 2390, 6,  7, 1, 11, 2}, // #535
  {DBGFIELD("WriteVecShiftImmXLd") 1, false, false, false, 2390, 6,  6, 1,  0, 0}, // #536
  {DBGFIELD("WriteVecShiftImmYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #537
  {DBGFIELD("WriteVecShiftImmY")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #538
  {DBGFIELD("WriteVecShiftImmZLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #539
  {DBGFIELD("WriteVecShiftImmZ")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #540
  {DBGFIELD("WriteVarVecShiftLd_ReadAfterVecXLd") 1, false, false, false, 2390, 6,  7, 1,  3, 1}, // #541
  {DBGFIELD("WriteVarVecShift")   1, false, false, false, 2391, 4,  5, 1,  0, 0}, // #542
  {DBGFIELD("WriteVarVecShiftYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #543
  {DBGFIELD("WriteVarVecShiftY")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #544
  {DBGFIELD("WriteVarVecShiftZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #545
  {DBGFIELD("WriteVarVecShiftZ")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #546
  {DBGFIELD("WriteVecShiftImmXLd_ReadAfterVecXLd") 1, false, false, false, 2390, 6,  6, 1,  3, 1}, // #547
  {DBGFIELD("WriteVarShuffleYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #548
  {DBGFIELD("WriteVarShuffleY")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #549
  {DBGFIELD("WriteVarShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #550
  {DBGFIELD("WriteVarShuffleZ")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #551
  {DBGFIELD("WriteShuffleZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #552
  {DBGFIELD("WriteVecShiftYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #553
  {DBGFIELD("WriteVecShiftY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #554
  {DBGFIELD("WriteVecShiftZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #555
  {DBGFIELD("WriteVecShiftZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #556
  {DBGFIELD("WriteVecTestYLd_ReadAfterVecYLd") 6, false, false, false, 2843, 8,  3, 1,  3, 1}, // #557
  {DBGFIELD("WriteVecTestY")      4, false, false, false, 2844, 6,  1, 1,  0, 0}, // #558
  {DBGFIELD("WriteFRcpXLd_ReadAfterVecXLd") 1, false, false, false, 2624, 6,  9, 1,  3, 1}, // #559
  {DBGFIELD("WriteFRcpYLd_ReadAfterVecYLd") 2, false, false, false, 2851, 6,  9, 1,  3, 1}, // #560
  {DBGFIELD("WriteFRcpY")         2, false, false, false, 2852, 4, 10, 1,  0, 0}, // #561
  {DBGFIELD("WriteFRcpZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #562
  {DBGFIELD("WriteFRcpZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #563
  {DBGFIELD("WriteFRcpYLd")       2, false, false, false, 2851, 6,  9, 1,  0, 0}, // #564
  {DBGFIELD("WriteFRndYLd")       2, false, false, false, 2784, 6, 22, 1,  0, 0}, // #565
  {DBGFIELD("WriteFRsqrtXLd_ReadAfterVecXLd") 1, false, false, false, 2624, 6,  9, 1,  3, 1}, // #566
  {DBGFIELD("WriteFRsqrtYLd_ReadAfterVecYLd") 2, false, false, false, 2857, 6,  9, 1,  3, 1}, // #567
  {DBGFIELD("WriteFRsqrtY")       2, false, false, false, 2858, 4, 10, 1,  0, 0}, // #568
  {DBGFIELD("WriteFRsqrtZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #569
  {DBGFIELD("WriteFRsqrtZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #570
  {DBGFIELD("WriteFRsqrtYLd")     2, false, false, false, 2857, 6,  9, 1,  0, 0}, // #571
  {DBGFIELD("WriteFShuffleYLd_ReadAfterVecYLd") 2, false, false, false, 2806, 5,  6, 1,  3, 1}, // #572
  {DBGFIELD("WriteFShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #573
  {DBGFIELD("WriteFSqrt64YLd")    2, false, false, false, 2772, 6, 21, 1,  0, 0}, // #574
  {DBGFIELD("WriteFSqrt64Y")      2, false, false, false, 2773, 4, 22, 1,  0, 0}, // #575
  {DBGFIELD("WriteFSqrt64XLd_ReadAfterVecXLd") 1, false, false, false, 2481, 6, 21, 1,  3, 1}, // #576
  {DBGFIELD("WriteFSqrt64YLd_ReadAfterVecYLd") 2, false, false, false, 2772, 6, 21, 1,  3, 1}, // #577
  {DBGFIELD("WriteFSqrt64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #578
  {DBGFIELD("WriteFSqrt64Z")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #579
  {DBGFIELD("WriteFSqrtXLd_ReadAfterVecXLd") 1, false, false, false, 2481, 6, 21, 1,  3, 1}, // #580
  {DBGFIELD("WriteFSqrtYLd_ReadAfterVecYLd") 2, false, false, false, 2772, 6, 21, 1,  3, 1}, // #581
  {DBGFIELD("WriteFSqrtY")        2, false, false, false, 2773, 4, 22, 1,  0, 0}, // #582
  {DBGFIELD("WriteFSqrtZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #583
  {DBGFIELD("WriteFSqrtZ")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #584
  {DBGFIELD("WriteFSqrtYLd")      2, false, false, false, 2772, 6, 21, 1,  0, 0}, // #585
  {DBGFIELD("WriteFTestYLd_ReadAfterVecYLd") 6, false, false, false, 2863, 8,  3, 1,  3, 1}, // #586
  {DBGFIELD("WriteFTestY")        4, false, false, false, 2864, 6,  1, 1,  0, 0}, // #587
  {DBGFIELD("WriteFTestLd_ReadAfterVecXLd") 2, false, false, false, 2425, 9,  3, 1,  3, 1}, // #588
  {DBGFIELD("WriteFTest")         2, false, false, false, 2426, 7,  1, 1,  0, 0}, // #589
  {DBGFIELD("WriteALULd_WriteRMW") 2, false, false, false, 2360, 5, 120, 2,  0, 0}, // #590
  {DBGFIELD("COPY")               1, false, false, false, 2320, 2,  1, 1,  0, 0}, // #591
  {DBGFIELD("XAM_F")              2, false, false, false, 2426, 7,  1, 1,  0, 0}, // #592
  {DBGFIELD("LD_Frr")             1, false, false, false, 2320, 2,  1, 1,  0, 0}, // #593
  {DBGFIELD("MOVSX64rr32")        1, false, false, false, 2320, 2,  1, 1,  0, 0}, // #594
  {DBGFIELD("RCL16m1_RCL16mi_RCL32m1_RCL32mi_RCL64m1_RCL64mi_RCL8m1_RCL8mi_RCR16m1_RCR16mi_RCR32m1_RCR32mi_RCR64m1_RCR64mi_RCR8m1_RCR8mi_ROL16m1_ROL16mi_ROL32m1_ROL32mi_ROL64m1_ROL64mi_ROL8m1_ROL8mi_ROR16m1_ROR16mi_ROR32m1_ROR32mi_ROR64m1_ROR64mi_ROR8m1_ROR8mi") 2, false, false, false, 2360, 5, 120, 2,  0, 0}, // #595
  {DBGFIELD("RCL16mCL_RCL32mCL_RCL64mCL_RCL8mCL_RCR16mCL_RCR32mCL_RCR64mCL_RCR8mCL_ROL16mCL_ROL32mCL_ROL64mCL_ROL8mCL_ROR16mCL_ROR32mCL_ROR64mCL_ROR8mCL") 2, false, false, false, 2692, 5, 120, 2,  0, 0}, // #596
  {DBGFIELD("SAR16m1_SAR16mi_SAR32m1_SAR32mi_SAR64m1_SAR64mi_SAR8m1_SAR8mi_SHL16m1_SHL16mi_SHL32m1_SHL32mi_SHL64m1_SHL64mi_SHL8m1_SHL8mi_SHR16m1_SHR16mi_SHR32m1_SHR32mi_SHR64m1_SHR64mi_SHR8m1_SHR8mi") 2, false, false, false, 2360, 5, 120, 2,  0, 0}, // #597
  {DBGFIELD("SAR16mCL_SAR32mCL_SAR64mCL_SAR8mCL_SHL16mCL_SHL32mCL_SHL64mCL_SHL8mCL_SHR16mCL_SHR32mCL_SHR64mCL_SHR8mCL") 2, false, false, false, 2692, 5, 120, 2,  0, 0}, // #598
  {DBGFIELD("MOVSX32rr16_MOVSX32rr8_MOVSX32rr8_NOREX_MOVSX64rr16_MOVSX64rr8_MOVZX32rr16_MOVZX32rr8_MOVZX32rr8_NOREX_MOVZX64rr16_MOVZX64rr8") 1, false, false, false, 2320, 2,  1, 1,  0, 0}, // #599
  {DBGFIELD("FCOMPP")             1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #600
  {DBGFIELD("UCOM_FPPr_UCOM_FPr_UCOM_Fr") 1, false, false, false, 2625, 4,  1, 1,  0, 0}, // #601
  {DBGFIELD("MMX_CVTPI2PSrr")     2, false, false, false, 2439, 5, 14, 1,  0, 0}, // #602
  {DBGFIELD("MMX_CVTPI2PSrm")     1, false, false, false, 2438, 7, 22, 1,  0, 0}, // #603
  {DBGFIELD("MMX_CVTPS2PIrr_MMX_CVTTPS2PIrr") 1, false, false, false, 2439, 5, 14, 1,  0, 0}, // #604
  {DBGFIELD("POP32r_POP64r_POP16rmr_POP32rmr_POP64rmr") 1, false, false, false, 2420, 2, 10, 1,  0, 0}, // #605
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r_PUSHi16_PUSHi32_PUSH16rmr_PUSH32rmr_PUSH64rmr_PUSH16i8_PUSH32i8_PUSH64i8_PUSH64i32") 1, false, false, false, 2499, 2,  1, 1,  0, 0}, // #606
  {DBGFIELD("XCH_F")              1, false, false, false, 2320, 2,  1, 1,  0, 0}, // #607
  {DBGFIELD("RETI16_RETI32_RETI64_IRET_IRET16_IRET32_IRET64") 1, false, false, false, 2335, 6, 10, 1,  0, 0}, // #608
  {DBGFIELD("MMX_CVTPS2PIrm_MMX_CVTTPS2PIrm") 1, false, false, false, 2438, 7, 22, 1,  0, 0}, // #609
  {DBGFIELD("ILD_F16m_ILD_F32m_ILD_F64m") 1, false, false, false, 2420, 2, 10, 1,  0, 0}, // #610
  {DBGFIELD("CVTSI642SDrm")       2, false, false, false, 2438, 7, 22, 1,  0, 0}, // #611
  {DBGFIELD("CVTSI642SDrm_Int")   2, false, false, false, 2438, 7, 22, 1,  3, 1}, // #612
  {DBGFIELD("CVTSI642SSrr")       2, false, false, false, 2871, 5, 24, 1,  0, 0}, // #613
  {DBGFIELD("CVTSI642SSrr_Int")   2, false, false, false, 2439, 5, 14, 1, 24, 1}, // #614
  {DBGFIELD("CVTSI642SSrm")       2, false, false, false, 2438, 7, 22, 1,  0, 0}, // #615
  {DBGFIELD("CVTSI642SSrm_Int")   2, false, false, false, 2438, 7, 22, 1,  3, 1}, // #616
  {DBGFIELD("CVTSS2SI64rr_CVTTSS2SI64rr") 2, false, false, false, 2446, 9, 24, 1,  0, 0}, // #617
  {DBGFIELD("CVTSS2SI64rr_Int_CVTTSS2SI64rr_Int") 2, false, false, false, 2446, 9, 24, 1,  0, 0}, // #618
  {DBGFIELD("CVTSS2SI64rm_CVTSS2SI64rm_Int_CVTTSS2SI64rm_CVTTSS2SI64rm_Int") 2, false, false, false, 2445, 11, 13, 1,  0, 0}, // #619
  {DBGFIELD("FDECSTP_FFREE_FFREEP_FINCSTP_WAIT_STOSB_STOSL_STOSQ_STOSW") 1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #620
  {DBGFIELD("LFENCE")             1, false, false, false, 2499, 2,  1, 1,  0, 0}, // #621
  {DBGFIELD("MOVSSrr_MOVSSrr_REV") 1, false, false, false, 2580, 3, 12, 1,  0, 0}, // #622
  {DBGFIELD("LEAVE_LEAVE64")      1, false, false, false, 2320, 2,  1, 1,  0, 0}, // #623
  {DBGFIELD("POP16r")             1, false, false, false, 2420, 2, 10, 1,  0, 0}, // #624
  {DBGFIELD("PUSH16rmm_PUSH32rmm_PUSH64rmm") 2, false, false, false, 2689, 3,  3, 1,  0, 0}, // #625
  {DBGFIELD("LODSB_LODSL_LODSQ_LODSW_SCASB_SCASL_SCASQ_SCASW") 1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #626
  {DBGFIELD("PUSHCS16_PUSHCS32_PUSHDS16_PUSHDS32_PUSHES16_PUSHES32_PUSHFS16_PUSHFS32_PUSHFS64_PUSHGS16_PUSHGS32_PUSHGS64_PUSHSS16_PUSHSS32") 1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #627
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m_ST_F32m_ST_F64m_ST_FP32m_ST_FP64m") 1, false, false, false, 2499, 2,  1, 1,  0, 0}, // #628
  {DBGFIELD("ST_FPrr_ST_Frr")     1, false, false, false, 2320, 2,  1, 1,  0, 0}, // #629
  {DBGFIELD("MMX_PADDQrr_MMX_PSUBQrr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #630
  {DBGFIELD("MOVSX16rr8_MOVZX16rr8") 1, false, false, false, 2320, 2,  1, 1,  0, 0}, // #631
  {DBGFIELD("MOVDQUmr_MASKMOVDQU_MASKMOVDQU64") 1, false, false, false, 2345, 5,  1, 1,  0, 0}, // #632
  {DBGFIELD("MOVUPDmr_MOVUPSmr")  1, false, false, false, 2345, 5,  1, 1,  0, 0}, // #633
  {DBGFIELD("PADDQrr_PSUBQrr")    1, false, false, false, 2322, 3, 12, 1,  0, 0}, // #634
  {DBGFIELD("CLD")                1, false, false, false, 2320, 2,  1, 1,  0, 0}, // #635
  {DBGFIELD("LDDQUrm")            1, false, false, false, 2584, 5, 10, 1,  0, 0}, // #636
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW_MOVSB_MOVSL_MOVSQ_MOVSW") 1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #637
  {DBGFIELD("POP16rmm_POP32rmm_POP64rmm") 2, false, false, false, 2689, 3,  3, 1,  0, 0}, // #638
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm_XCHG16rm_XCHG32rm_XCHG64rm_XCHG8rm") 2, false, false, false, 2360, 5, 120, 2,  0, 0}, // #639
  {DBGFIELD("PHADDDrr_PHSUBDrr")  3, false, false, false, 2609, 3, 10, 1,  0, 0}, // #640
  {DBGFIELD("MOVSX16rm8_MOVZX16rm8") 1, false, false, false, 2420, 2, 10, 1,  0, 0}, // #641
  {DBGFIELD("MMX_PADDQrm_MMX_PSUBQrm") 1, false, false, false, 2385, 5,  6, 1,  3, 1}, // #642
  {DBGFIELD("MOVDQUrm")           1, false, false, false, 2584, 5, 10, 1,  0, 0}, // #643
  {DBGFIELD("MOVUPDrm_MOVUPSrm")  1, false, false, false, 2350, 5, 10, 1,  0, 0}, // #644
  {DBGFIELD("PADDQrm_PSUBQrm")    1, false, false, false, 2385, 5,  6, 1,  3, 1}, // #645
  {DBGFIELD("CBW_CWD_CWDE_CDQ_CDQE_CQO") 1, false, false, false, 2320, 2,  1, 1,  0, 0}, // #646
  {DBGFIELD("JCXZ_JECXZ_JRCXZ")   1, false, false, false, 2325, 4,  1, 1,  0, 0}, // #647
  {DBGFIELD("LD_F80m")            1, false, false, false, 2420, 2, 10, 1,  0, 0}, // #648
  {DBGFIELD("PHADDDrm_PHSUBDrm")  4, false, false, false, 2608, 5,  9, 1,  0, 0}, // #649
  {DBGFIELD("MMX_PEXTRWrr_PEXTRWrr_PEXTRWrr_REV") 2, false, false, false, 2507, 7,  2, 1,  0, 0}, // #650
  {DBGFIELD("FLDCW16m")           1, false, false, false, 2420, 2, 10, 1,  0, 0}, // #651
  {DBGFIELD("ST_FP80m")           1, false, false, false, 2499, 2,  1, 1,  0, 0}, // #652
  {DBGFIELD("MMX_PHADDSWrr_MMX_PHADDWrr_MMX_PHSUBSWrr_MMX_PHSUBWrr") 3, false, false, false, 2609, 3, 10, 1,  0, 0}, // #653
  {DBGFIELD("CMPXCHG8rm")         5, false, false, false, 2876, 3,  5, 1,  0, 0}, // #654
  {DBGFIELD("INTO")               1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #655
  {DBGFIELD("XLAT")               1, false, false, false, 2341, 2,  3, 1,  0, 0}, // #656
  {DBGFIELD("SHLD16rrCL_SHRD16rrCL") 7, false, false, false, 2401, 2,  5, 1,  0, 0}, // #657
  {DBGFIELD("SHLD16rri8_SHRD16rri8") 6, false, false, false, 2343, 2,  5, 1,  0, 0}, // #658
  {DBGFIELD("SHLD16mrCL_SHRD16mrCL") 8, false, false, false, 2713, 4, 14, 1,  0, 0}, // #659
  {DBGFIELD("SHLD16mri8_SHRD16mri8") 8, false, false, false, 2713, 4, 14, 1,  0, 0}, // #660
  {DBGFIELD("IST_F16m_IST_F32m_IST_FP16m_IST_FP32m_IST_FP64m") 1, false, false, false, 2499, 2,  1, 1,  0, 0}, // #661
  {DBGFIELD("MMX_PHADDSWrm_MMX_PHADDWrm_MMX_PHSUBSWrm_MMX_PHSUBWrm") 4, false, false, false, 2608, 5,  9, 1,  3, 1}, // #662
  {DBGFIELD("AAD8i8")             1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #663
  {DBGFIELD("LOOPE")              1, false, false, false, 2325, 4,  1, 1,  0, 0}, // #664
  {DBGFIELD("PUSHA16_PUSHA32")    1, false, false, false, 2499, 2,  1, 1,  0, 0}, // #665
  {DBGFIELD("SHLD64rrCL_SHRD64rrCL") 7, false, false, false, 2401, 2,  5, 1,  0, 0}, // #666
  {DBGFIELD("FNSTCW16m")          1, false, false, false, 2320, 2,  1, 1,  0, 0}, // #667
  {DBGFIELD("POPA16_POPA32")      1, false, false, false, 2420, 2, 10, 1,  0, 0}, // #668
  {DBGFIELD("PUSHF16_PUSHF32_PUSHF64") 1, false, false, false, 2499, 2,  1, 1,  0, 0}, // #669
  {DBGFIELD("SHLD64mrCL_SHRD64mrCL") 8, false, false, false, 2713, 4, 14, 1,  0, 0}, // #670
  {DBGFIELD("SHLD64mri8_SHRD64mri8") 8, false, false, false, 2713, 4, 14, 1,  0, 0}, // #671
  {DBGFIELD("SHLD64rri8_SHRD64rri8") 6, false, false, false, 2343, 2,  5, 1,  0, 0}, // #672
  {DBGFIELD("CMPXCHG8rr")         3, false, false, false, 2422, 3,  5, 1,  0, 0}, // #673
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr_TST_F_TST_Fp32_TST_Fp64_TST_Fp80") 2, false, false, false, 2426, 7,  1, 1,  0, 0}, // #674
  {DBGFIELD("BOUNDS16rm_BOUNDS32rm") 1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #675
  {DBGFIELD("AAA_AAS")            1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #676
  {DBGFIELD("CMPXCHG16rm_CMPXCHG32rm_CMPXCHG64rm") 6, false, false, false, 2879, 3,  5, 1,  0, 0}, // #677
  {DBGFIELD("LOOPNE")             1, false, false, false, 2325, 4,  1, 1,  0, 0}, // #678
  {DBGFIELD("PAUSE")              1, false, false, false, 2320, 2,  1, 1,  0, 0}, // #679
  {DBGFIELD("CMPXCHG8B")          18, false, false, false, 2882, 3,  5, 1,  0, 0}, // #680
  {DBGFIELD("DAA")                1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #681
  {DBGFIELD("LOOP")               1, false, false, false, 2325, 4,  1, 1,  0, 0}, // #682
  {DBGFIELD("DAS")                1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #683
  {DBGFIELD("AAM8i8")             1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #684
  {DBGFIELD("STD")                1, false, false, false, 2320, 2,  1, 1,  0, 0}, // #685
  {DBGFIELD("CMPXCHG16B")         22, false, false, false, 2885, 3,  5, 1,  0, 0}, // #686
  {DBGFIELD("ARPL16mr_ARPL16rr")  1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #687
  {DBGFIELD("FNCLEX_FXTRACT")     1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #688
  {DBGFIELD("POPF32_POPF64")      1, false, false, false, 2420, 2, 10, 1,  0, 0}, // #689
  {DBGFIELD("POPDS16_POPDS32_POPES16_POPES32_POPFS16_POPFS32_POPFS64_POPGS16_POPGS32_POPGS64") 1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #690
  {DBGFIELD("RDTSC_RDTSCP")       1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #691
  {DBGFIELD("ENTER")              1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #692
  {DBGFIELD("POPF16")             1, false, false, false, 2420, 2, 10, 1,  0, 0}, // #693
  {DBGFIELD("MONITOR32rrr_MONITOR64rrr") 1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #694
  {DBGFIELD("FRNDINT")            1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #695
  {DBGFIELD("MWAITrr_RDPMC")      1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #696
  {DBGFIELD("POPSS16_POPSS32")    1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #697
  {DBGFIELD("FPREM")              1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #698
  {DBGFIELD("INSB_INSL_INSW")     1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #699
  {DBGFIELD("FNINIT")             1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #700
  {DBGFIELD("OUT8rr_OUT16rr_OUT32rr") 1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #701
  {DBGFIELD("FPREM1")             1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #702
  {DBGFIELD("INVLPG_INVLPGA32_INVLPGA64") 1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #703
  {DBGFIELD("OUT8ir_OUT16ir_OUT32ir") 1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #704
  {DBGFIELD("OUTSB_OUTSL_OUTSW")  1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #705
  {DBGFIELD("FSCALE")             1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #706
  {DBGFIELD("RDMSR")              1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #707
  {DBGFIELD("RET_RET16_RET32_RET64_LRET16_LRET32_LRET64_LRETI16_LRETI32_LRETI64") 1, false, false, false, 2335, 6, 10, 1,  0, 0}, // #708
  {DBGFIELD("IN8ri_IN16ri_IN32ri") 1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #709
  {DBGFIELD("IN8rr_IN16rr_IN32rr") 1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #710
  {DBGFIELD("F2XM1")              1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #711
  {DBGFIELD("CPUID")              1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #712
  {DBGFIELD("INT")                1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #713
  {DBGFIELD("INT3")               1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #714
  {DBGFIELD("FXSAVE_FXSAVE64")    1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #715
  {DBGFIELD("FXRSTOR_FXRSTOR64")  1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #716
  {DBGFIELD("FYL2X")              1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #717
  {DBGFIELD("FYL2XP1")            1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #718
  {DBGFIELD("FPTAN")              1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #719
  {DBGFIELD("FSINCOS_FSIN_FCOS")  1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #720
  {DBGFIELD("FPATAN")             1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #721
  {DBGFIELD("WRMSR")              1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #722
  {DBGFIELD("COMP_FST0r_COM_FST0r") 2, false, false, false, 2426, 7,  1, 1,  0, 0}, // #723
  {DBGFIELD("UCOM_FPr_UCOM_Fr")   2, false, false, false, 2426, 7,  1, 1,  0, 0}, // #724
  {DBGFIELD("FDECSTP_FINCSTP_FFREE_FFREEP") 1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #725
  {DBGFIELD("FNOP")               1, false, false, false, 2320, 2,  1, 1,  0, 0}, // #726
  {DBGFIELD("RET64")              1, false, false, false, 2335, 6, 10, 1,  0, 0}, // #727
  {DBGFIELD("CDQ_CQO")            1, false, false, false, 2320, 2,  1, 1,  0, 0}, // #728
  {DBGFIELD("MMX_PABSBrr_MMX_PABSDrr_MMX_PABSWrr_MMX_PSIGNBrr_MMX_PSIGNDrr_MMX_PSIGNWrr") 1, false, false, false, 2322, 3, 12, 1,  0, 0}, // #729
  {DBGFIELD("MMX_PADDQrr")        1, false, false, false, 2322, 3, 12, 1,  0, 0}, // #730
  {DBGFIELD("MMX_PALIGNRrri")     1, false, false, false, 2391, 4, 12, 1,  0, 0}, // #731
  {DBGFIELD("SCASB_SCASL_SCASQ_SCASW") 1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #732
  {DBGFIELD("COMISDrr_COMISDrr_Int_COMISSrr_COMISSrr_Int_UCOMISDrr_UCOMISDrr_Int_UCOMISSrr_UCOMISSrr_Int_VCOMISDrr_VCOMISDrr_Int_VCOMISSrr_VCOMISSrr_Int_VUCOMISDrr_VUCOMISDrr_Int_VUCOMISSrr_VUCOMISSrr_Int") 2, false, false, false, 2426, 7,  1, 1,  0, 0}, // #733
  {DBGFIELD("CWD")                1, false, false, false, 2320, 2,  1, 1,  0, 0}, // #734
  {DBGFIELD("FNSTSW16r")          1, false, false, false, 2320, 2,  1, 1,  0, 0}, // #735
  {DBGFIELD("MMX_MOVDQ2Qrr")      1, false, false, false, 2596, 3,  1, 1,  0, 0}, // #736
  {DBGFIELD("PUSHFS64")           1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #737
  {DBGFIELD("EXTRACTPSrr_VEXTRACTPSrr") 2, false, false, false, 2507, 7,  2, 1,  0, 0}, // #738
  {DBGFIELD("RCL8r1_RCL16r1_RCL32r1_RCL64r1_RCR8r1_RCR16r1_RCR32r1_RCR64r1") 1, false, false, false, 2320, 2,  1, 1,  0, 0}, // #739
  {DBGFIELD("RCR8ri_RCR16ri_RCR32ri_RCR64ri") 15, false, false, false, 2888, 2,  6, 1,  0, 0}, // #740
  {DBGFIELD("RCL8ri_RCL16ri_RCL32ri_RCL64ri") 25, false, false, false, 2890, 2, 24, 1,  0, 0}, // #741
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr") 2, false, false, false, 2426, 7,  1, 1,  0, 0}, // #742
  {DBGFIELD("MOV64sr")            1, false, false, false, 2320, 2,  1, 1,  0, 0}, // #743
  {DBGFIELD("RCL16rCL_RCL32rCL_RCL64rCL_RCL8rCL_RCR16rCL_RCR32rCL_RCR64rCL_RCR8rCL") 24, false, false, false, 2714, 2,  8, 1,  0, 0}, // #744
  {DBGFIELD("PUSH16r_PUSH16rmr_PUSH32r_PUSH32rmr_PUSH64i8_PUSH64r_PUSH64rmr") 1, false, false, false, 2499, 2,  1, 1,  0, 0}, // #745
  {DBGFIELD("CLI")                1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #746
  {DBGFIELD("PUSHGS64")           1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #747
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m") 1, false, false, false, 2499, 2,  1, 1,  0, 0}, // #748
  {DBGFIELD("CALL64pcrel32")      1, false, false, false, 2325, 4,  1, 1,  0, 0}, // #749
  {DBGFIELD("CALL64r_RVMARKER_CALL16r_CALL16r_NT_CALL32r_CALL32r_NT_CALL64r_CALL64r_NT") 1, false, false, false, 2325, 4,  1, 1,  0, 0}, // #750
  {DBGFIELD("EXTRACTPSmr_VEXTRACTPSmr") 2, false, false, false, 2501, 6, 24, 1,  0, 0}, // #751
  {DBGFIELD("STOSB_STOSL_STOSQ_STOSW") 1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #752
  {DBGFIELD("PEXTRDmr_PEXTRQmr_VPEXTRDmr_VPEXTRQmr") 2, false, false, false, 2501, 6, 24, 1,  0, 0}, // #753
  {DBGFIELD("PUSHF16_PUSHF64")    1, false, false, false, 2499, 2,  1, 1,  0, 0}, // #754
  {DBGFIELD("CLFLUSH_CLFLUSHOPT") 1, false, false, false, 2420, 2, 10, 1,  0, 0}, // #755
  {DBGFIELD("VBROADCASTSSrm")     1, false, false, false, 2579, 5,  6, 1,  0, 0}, // #756
  {DBGFIELD("MOV64toPQIrm_VMOV64toPQIrm_MOVDI2PDIrm_VMOVDI2PDIrm_MOVQI2PQIrm_VMOVQI2PQIrm") 1, false, false, false, 2584, 5, 10, 1,  0, 0}, // #757
  {DBGFIELD("MOVDDUPrm_VMOVDDUPrm_MOVSHDUPrm_VMOVSHDUPrm_MOVSLDUPrm_VMOVSLDUPrm") 1, false, false, false, 2579, 5,  6, 1,  0, 0}, // #758
  {DBGFIELD("MOVSDrm_MOVSDrm_alt_VMOVSDrm_VMOVSDrm_alt_MOVSSrm_MOVSSrm_alt_VMOVSSrm_VMOVSSrm_alt") 1, false, false, false, 2350, 5, 10, 1,  0, 0}, // #759
  {DBGFIELD("MOV16sm")            1, false, false, false, 2320, 2,  1, 1,  0, 0}, // #760
  {DBGFIELD("MMX_PABSBrm_MMX_PABSDrm_MMX_PABSWrm") 1, false, false, false, 2385, 5,  6, 1,  0, 0}, // #761
  {DBGFIELD("MMX_PALIGNRrmi")     1, false, false, false, 2390, 6,  6, 1,  3, 1}, // #762
  {DBGFIELD("MMX_PSIGNBrm_MMX_PSIGNDrm_MMX_PSIGNWrm") 1, false, false, false, 2385, 5,  6, 1,  3, 1}, // #763
  {DBGFIELD("LODSL_LODSQ")        1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #764
  {DBGFIELD("VBROADCASTSDYrm_VBROADCASTSSYrm") 2, false, false, false, 2892, 5,  3, 1, 21, 1}, // #765
  {DBGFIELD("VMOVDDUPYrm_VMOVSHDUPYrm_VMOVSLDUPYrm") 2, false, false, false, 2806, 5,  6, 1,  0, 0}, // #766
  {DBGFIELD("VINSERTF128rm")      2, false, false, false, 2350, 5,  6, 1,  3, 1}, // #767
  {DBGFIELD("MMX_PADDQrm")        1, false, false, false, 2385, 5,  6, 1,  3, 1}, // #768
  {DBGFIELD("VERRm_VERWm")        1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #769
  {DBGFIELD("FARJMP64m")          1, false, false, false, 2325, 4,  1, 1,  0, 0}, // #770
  {DBGFIELD("FNSTSWm")            1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #771
  {DBGFIELD("SLDT16r_SLDT32r_SLDT64r_STR16r_STR32r_STR64r") 1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #772
  {DBGFIELD("CALL64m_RVMARKER_CALL64m_CALL64m_NT") 1, false, false, false, 2325, 4,  1, 1,  0, 0}, // #773
  {DBGFIELD("CALL16m_CALL16m_NT_CALL32m_CALL32m_NT") 1, false, false, false, 2335, 6, 10, 1,  0, 0}, // #774
  {DBGFIELD("COMISDrm_COMISDrm_Int_COMISSrm_COMISSrm_Int_UCOMISDrm_UCOMISDrm_Int_UCOMISSrm_UCOMISSrm_Int_VCOMISDrm_VCOMISDrm_Int_VCOMISSrm_VCOMISSrm_Int_VUCOMISDrm_VUCOMISDrm_Int_VUCOMISSrm_VUCOMISSrm_Int") 2, false, false, false, 2425, 9,  3, 1,  3, 1}, // #775
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW") 1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #776
  {DBGFIELD("ROL16m1_ROL16mi_ROL32m1_ROL32mi_ROL64m1_ROL64mi_ROL8m1_ROL8mi_ROR16m1_ROR16mi_ROR32m1_ROR32mi_ROR64m1_ROR64mi_ROR8m1_ROR8mi") 2, false, false, false, 2360, 5, 120, 2,  0, 0}, // #777
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm") 4, false, false, false, 2897, 3,  3, 1,  0, 0}, // #778
  {DBGFIELD("FARCALL64m")         1, false, false, false, 2325, 4,  1, 1,  0, 0}, // #779
  {DBGFIELD("LD_F32m_LD_F64m")    1, false, false, false, 2420, 2, 10, 1,  0, 0}, // #780
  {DBGFIELD("ROL16mCL_ROL32mCL_ROL64mCL_ROL8mCL_ROR16mCL_ROR32mCL_ROR64mCL_ROR8mCL") 2, false, false, false, 2692, 5, 120, 2,  0, 0}, // #781
  {DBGFIELD("ADC8mr_ADC16mr_ADC32mr_ADC64mr_SBB8mr_SBB16mr_SBB32mr_SBB64mr") 2, false, false, false, 2360, 5,  3, 1, 19, 2}, // #782
  {DBGFIELD("ADD_F32m_ADD_F64m_SUBR_F32m_SUBR_F64m_SUB_F32m_SUB_F64m") 1, false, false, false, 2900, 6, 10, 1,  0, 0}, // #783
  {DBGFIELD("PCMPGTQrm_VPCMPGTQrm") 1, false, false, false, 2385, 5,  6, 1,  3, 1}, // #784
  {DBGFIELD("FICOM16m_FICOM32m_FICOMP16m_FICOMP32m") 2, false, false, false, 2425, 9,  3, 1,  0, 0}, // #785
  {DBGFIELD("MUL_F32m_MUL_F64m")  1, false, false, false, 2487, 6, 10, 1,  0, 0}, // #786
  {DBGFIELD("ADD_FI16m_ADD_FI32m_SUBR_FI16m_SUBR_FI32m_SUB_FI16m_SUB_FI32m") 1, false, false, false, 2900, 6, 10, 1,  0, 0}, // #787
  {DBGFIELD("MUL_FI16m_MUL_FI32m") 1, false, false, false, 2487, 6, 10, 1,  0, 0}, // #788
  {DBGFIELD("DIVR_F32m_DIVR_F64m_DIV_F32m_DIV_F64m") 1, false, false, false, 2906, 6, 22, 1,  0, 0}, // #789
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m_DIV_FI16m_DIV_FI32m") 1, false, false, false, 2906, 6, 22, 1,  0, 0}, // #790
  {DBGFIELD("VZEROALL")           32, false, false, false,  0, 0, 122, 1,  0, 0}, // #791
  {DBGFIELD("VZEROUPPER")         16, false, false, false,  0, 0, 62, 1,  0, 0}, // #792
  {DBGFIELD("CLC")                1, false, false, false, 2320, 2,  1, 1,  0, 0}, // #793
  {DBGFIELD("SUB32rr_SUB64rr_XOR32rr_XOR64rr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #794
  {DBGFIELD("XORPSrr_VXORPSrr_XORPDrr_VXORPDrr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #795
  {DBGFIELD("VXORPSYrr_VXORPDYrr") 2, false, false, false, 2740, 3, 12, 1,  0, 0}, // #796
  {DBGFIELD("PXORrr_VPXORrr")     8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #797
  {DBGFIELD("PSUBBrr_VPSUBBrr_PSUBDrr_VPSUBDrr_VPSUBQrr_PSUBWrr_VPSUBWrr_PCMPGTBrr_VPCMPGTBrr_PCMPGTDrr_VPCMPGTDrr_PCMPGTWrr_VPCMPGTWrr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #798
  {DBGFIELD("PSUBQrr")            8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #799
  {DBGFIELD("PCMPGTQrr_VPCMPGTQrr") 1, false, false, false, 2322, 3, 12, 1,  0, 0}, // #800
  {DBGFIELD("CMOV16rr_CMOV32rr_CMOV64rr") 1, false, false, false, 2341, 2,  1, 1,  0, 0}, // #801
  {DBGFIELD("CMOV16rm_CMOV32rm_CMOV64rm") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #802
  {DBGFIELD("SETCCr")             1, false, false, false, 2341, 2,  1, 1,  0, 0}, // #803
  {DBGFIELD("SETCCm")             8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #804
  {DBGFIELD("MOVHPDrm_MOVHPSrm_MOVLPDrm_MOVLPSrm_VMOVHPDrm_VMOVHPSrm_VMOVLPDrm_VMOVLPSrm") 1, false, false, false, 2579, 5,  6, 1,  3, 1}, // #805
  {DBGFIELD("RETI16_RETI32_RETI64") 1, false, false, false, 2335, 6, 10, 1,  0, 0}, // #806
  {DBGFIELD("LRETI16_LRETI32_LRETI64") 1, false, false, false, 2335, 6, 10, 1,  0, 0}, // #807
  {DBGFIELD("RDPMC")              1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #808
  {DBGFIELD("RDRAND16r_RDRAND32r_RDRAND64r") 1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #809
  {DBGFIELD("FBLDm")              1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #810
  {DBGFIELD("FFREE_FFREEP")       1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #811
  {DBGFIELD("FSAVEm")             1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #812
  {DBGFIELD("FRSTORm")            1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #813
  {DBGFIELD("FXTRACT")            1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #814
  {DBGFIELD("VPBROADCASTDrm_VPBROADCASTQrm") 1, false, false, false, 2390, 6,  6, 1,  0, 0}, // #815
  {DBGFIELD("VBROADCASTF128")     2, false, false, false, 2351, 3,  6, 1,  0, 0}, // #816
  {DBGFIELD("VBROADCASTI128")     1, false, false, false, 2390, 6,  6, 1,  0, 0}, // #817
  {DBGFIELD("VPBROADCASTDYrm_VPBROADCASTQYrm") 1, false, false, false, 2390, 6,  6, 1,  0, 0}, // #818
  {DBGFIELD("FBSTPm")             1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #819
  {DBGFIELD("VMPTRSTm")           1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #820
  {DBGFIELD("ST_FP32m_ST_FP64m")  1, false, false, false, 2499, 2,  1, 1,  0, 0}, // #821
  {DBGFIELD("VPSLLVQYrr_VPSRLVQYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #822
  {DBGFIELD("VPSLLVQrr_VPSRLVQrr") 1, false, false, false, 2391, 4,  5, 1,  0, 0}, // #823
  {DBGFIELD("MMX_MOVQ2DQrr")      1, false, false, false, 2605, 3, 14, 1,  0, 0}, // #824
  {DBGFIELD("JMP16r_JMP16r_NT_JMP32r_JMP32r_NT_JMP64r_JMP64r_NT_JMP64r_REX") 1, false, false, false, 2325, 4,  1, 1,  0, 0}, // #825
  {DBGFIELD("FINCSTP")            1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #826
  {DBGFIELD("ANDN32rr_ANDN64rr")  1, false, false, false, 2320, 2,  1, 1,  0, 0}, // #827
  {DBGFIELD("VPBLENDDYrri")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #828
  {DBGFIELD("VPBLENDDrri")        1, false, false, false, 2322, 3, 12, 1,  0, 0}, // #829
  {DBGFIELD("SGDT64m_SIDT64m_SMSW16m_STRm_SYSCALL") 1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #830
  {DBGFIELD("VPSLLVQrm_VPSRLVQrm") 1, false, false, false, 2390, 6,  7, 1,  3, 1}, // #831
  {DBGFIELD("VPSLLVQYrm_VPSRLVQYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #832
  {DBGFIELD("PDEP32rm_PDEP64rm_PEXT32rm_PEXT64rm") 1, false, false, false, 2369, 4, 10, 1, 21, 1}, // #833
  {DBGFIELD("PMOVSXBDrm_PMOVZXBDrm_VPMOVSXBDrm_VPMOVZXBDrm_PMOVSXBQrm_PMOVZXBQrm_VPMOVSXBQrm_VPMOVZXBQrm_PMOVSXBWrm_PMOVZXBWrm_VPMOVSXBWrm_VPMOVZXBWrm_PMOVSXDQrm_PMOVZXDQrm_VPMOVSXDQrm_VPMOVZXDQrm_PMOVSXWDrm_PMOVZXWDrm_VPMOVSXWDrm_VPMOVZXWDrm_PMOVSXWQrm_PMOVZXWQrm_VPMOVSXWQrm_VPMOVZXWQrm") 1, false, false, false, 2390, 6,  6, 1,  0, 0}, // #834
  {DBGFIELD("VPMOVSXBDYrm_VPMOVSXBQYrm_VPMOVSXWQYrm") 1, false, false, false, 2744, 5,  3, 1,  0, 0}, // #835
  {DBGFIELD("JMP16m_JMP16m_NT_JMP32m_JMP32m_NT_JMP64m_JMP64m_NT_JMP64m_REX") 1, false, false, false, 2335, 6, 10, 1,  0, 0}, // #836
  {DBGFIELD("ANDN32rm_ANDN64rm")  1, false, false, false, 2369, 4, 10, 1, 21, 1}, // #837
  {DBGFIELD("MOVBE16rm_MOVBE32rm_MOVBE64rm") 1, false, false, false, 2369, 4, 10, 1,  0, 0}, // #838
  {DBGFIELD("VINSERTI128rm")      1, false, false, false, 2744, 5,  3, 1,  3, 1}, // #839
  {DBGFIELD("VPBLENDDrmi")        1, false, false, false, 2385, 5,  6, 1,  3, 1}, // #840
  {DBGFIELD("VPBLENDDYrmi")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #841
  {DBGFIELD("POP32r_POP64r")      1, false, false, false, 2420, 2, 10, 1,  0, 0}, // #842
  {DBGFIELD("SFENCE")             1, false, false, false, 2499, 2,  1, 1,  0, 0}, // #843
  {DBGFIELD("MOVBE32mr_MOVBE64mr") 1, false, false, false, 2499, 2,  1, 1,  0, 0}, // #844
  {DBGFIELD("MOVBE16mr")          1, false, false, false, 2499, 2,  1, 1,  0, 0}, // #845
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r_PUSH64i8") 1, false, false, false, 2499, 2,  1, 1,  0, 0}, // #846
  {DBGFIELD("MFENCE")             1, false, false, false, 2499, 2,  1, 1,  0, 0}, // #847
  {DBGFIELD("XGETBV")             1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #848
  {DBGFIELD("MMX_PACKSSDWrm_MMX_PACKSSWBrm_MMX_PACKUSWBrm") 1, false, false, false, 2390, 6,  6, 1,  3, 1}, // #849
  {DBGFIELD("LRET64_RET32")       1, false, false, false, 2335, 6, 10, 1,  0, 0}, // #850
  {DBGFIELD("ROL8r1_ROL16r1_ROL32r1_ROL64r1_ROR8r1_ROR16r1_ROR32r1_ROR64r1") 1, false, false, false, 2320, 2,  1, 1,  0, 0}, // #851
  {DBGFIELD("PDEP32rr_PDEP64rr_PEXT32rr_PEXT64rr") 1, false, false, false, 2320, 2,  1, 1,  0, 0}, // #852
  {DBGFIELD("VPBROADCASTBrr_VPBROADCASTWrr") 1, false, false, false, 2391, 4, 12, 1,  0, 0}, // #853
  {DBGFIELD("VPMOVSXBWYrm_VPMOVSXDQYrm_VPMOVSXWDYrm_VPMOVZXWDYrm") 1, false, false, false, 2744, 5,  3, 1,  0, 0}, // #854
  {DBGFIELD("MMX_PACKSSDWrr_MMX_PACKSSWBrr_MMX_PACKUSWBrr") 1, false, false, false, 2391, 4, 12, 1,  0, 0}, // #855
  {DBGFIELD("CLDEMOTE")           1, false, false, false, 2420, 2, 10, 1,  0, 0}, // #856
  {DBGFIELD("MMX_CVTPI2PDrm")     2, false, false, false, 2438, 7, 24, 1,  0, 0}, // #857
  {DBGFIELD("VPBROADCASTBYrm_VPBROADCASTBrm_VPBROADCASTWYrm_VPBROADCASTWrm") 1, false, false, false, 2390, 6,  6, 1,  0, 0}, // #858
  {DBGFIELD("LAR16rr_LAR32rr_LAR64rr") 45, false, false, false, 2912, 2, 123, 1,  0, 0}, // #859
  {DBGFIELD("LAR16rm_LAR32rm_LAR64rm_LSL16rm_LSL32rm_LSL64rm") 1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #860
  {DBGFIELD("MUL_FPrST0_MUL_FST0r_MUL_FrST0") 1, false, false, false, 2625, 4, 10, 1,  0, 0}, // #861
  {DBGFIELD("VPCMPGTQYrm")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #862
  {DBGFIELD("VCVTSI642SSrr_VCVTSI642SSrr_Int") 2, false, false, false, 2439, 5, 14, 1, 24, 1}, // #863
  {DBGFIELD("STR16r_STR32r_STR64r") 1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #864
  {DBGFIELD("XSETBV")             1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #865
  {DBGFIELD("RCL16mCL_RCL32mCL_RCL64mCL_RCL8mCL") 2, false, false, false, 2692, 5, 120, 2,  0, 0}, // #866
  {DBGFIELD("RCL16rCL_RCL32rCL_RCL64rCL_RCR16rCL_RCR32rCL_RCR64rCL") 17, false, false, false, 2888, 2,  6, 1,  0, 0}, // #867
  {DBGFIELD("RCL8rCL")            26, false, false, false, 2914, 2,  2, 1,  0, 0}, // #868
  {DBGFIELD("RDTSC")              1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #869
  {DBGFIELD("XRSTOR_XRSTOR64_XRSTORS_XRSTORS64") 1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #870
  {DBGFIELD("DIV_FPrST0_DIV_FST0r_DIV_FrST0") 1, false, false, false, 2482, 4, 22, 1,  0, 0}, // #871
  {DBGFIELD("DIVR_F32m_DIVR_F64m") 1, false, false, false, 2906, 6, 22, 1,  0, 0}, // #872
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m") 1, false, false, false, 2906, 6, 22, 1,  0, 0}, // #873
  {DBGFIELD("DIVR_FPrST0_DIVR_FST0r_DIVR_FrST0") 1, false, false, false, 2482, 4, 22, 1,  0, 0}, // #874
  {DBGFIELD("XSAVE64")            1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #875
  {DBGFIELD("XSAVE")              1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #876
  {DBGFIELD("XSAVEC_XSAVEC64_XSAVES_XSAVES64_XSAVEOPT_XSAVEOPT64") 1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #877
  {DBGFIELD("VMCLEARm")           1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #878
  {DBGFIELD("FLDENVm")            1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #879
  {DBGFIELD("FXRSTOR64")          1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #880
  {DBGFIELD("FSTENVm")            1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #881
  {DBGFIELD("VGATHERDPDrm_VPGATHERDQrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #882
  {DBGFIELD("VGATHERDPDYrm_VPGATHERDQYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #883
  {DBGFIELD("VGATHERDPSrm_VPGATHERDDrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #884
  {DBGFIELD("VGATHERDPSYrm_VPGATHERDDYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #885
  {DBGFIELD("VGATHERQPDrm_VPGATHERQQrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #886
  {DBGFIELD("VGATHERQPDYrm_VPGATHERQQYrm_VGATHERQPSYrm_VPGATHERQDYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #887
  {DBGFIELD("VGATHERQPSrm_VPGATHERQDrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #888
  {DBGFIELD("VPXORYrr")           8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #889
  {DBGFIELD("VPSUBBYrr_VPSUBDYrr_VPSUBQYrr_VPSUBWYrr_VPCMPGTBYrr_VPCMPGTDYrr_VPCMPGTWYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #890
  {DBGFIELD("VPCMPGTQYrr")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #891
  {DBGFIELD("ADC16ri8_ADC32ri8_ADC64ri8_SBB16ri8_SBB32ri8_SBB64ri8") 1, false, false, false, 2320, 2,  1, 1,  0, 0}, // #892
  {DBGFIELD("ADC8i8_SBB8i8_ADC16i16_SBB16i16_ADC32i32_SBB32i32_ADC64i32_SBB64i32") 1, false, false, false, 2320, 2,  1, 1,  0, 0}, // #893
  {DBGFIELD("FCOM32m_FCOM64m_FCOMP32m_FCOMP64m") 1, false, false, false, 2625, 4,  3, 1,  0, 0}, // #894
  {DBGFIELD("LRET64")             1, false, false, false, 2335, 6, 10, 1,  0, 0}, // #895
  {DBGFIELD("POPF64")             1, false, false, false, 2420, 2, 10, 1,  0, 0}, // #896
  {DBGFIELD("VGATHERQPDYrm_VPGATHERQQYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #897
  {DBGFIELD("PCMPEQQrr")          1, false, false, false, 2322, 3, 12, 1,  0, 0}, // #898
  {DBGFIELD("PCMPGTQrr")          1, false, false, false, 2322, 3, 12, 1,  0, 0}, // #899
  {DBGFIELD("PCMPEQQrm")          1, false, false, false, 2385, 5,  6, 1,  3, 1}, // #900
  {DBGFIELD("PCMPGTQrm")          1, false, false, false, 2385, 5,  6, 1,  3, 1}, // #901
  {DBGFIELD("MOV16rm")            1, false, false, false, 2420, 2, 10, 1,  0, 0}, // #902
  {DBGFIELD("POP16rmm")           2, false, false, false, 2689, 3,  3, 1,  0, 0}, // #903
  {DBGFIELD("PUSH16rmm_PUSH32rmm") 2, false, false, false, 2689, 3,  3, 1,  0, 0}, // #904
  {DBGFIELD("PUSHF16")            1, false, false, false, 2499, 2,  1, 1,  0, 0}, // #905
  {DBGFIELD("LAHF")               4, false, false, false, 2435, 2, 12, 1,  0, 0}, // #906
  {DBGFIELD("ADD16mi_ADD16mi8_ADD32mi_ADD32mi8_ADD64mi32_ADD64mi8_ADD8mi_ADD8mi8_SUB16mi_SUB16mi8_SUB32mi_SUB32mi8_SUB64mi32_SUB64mi8_SUB8mi_SUB8mi8") 1, false, false, false, 2360, 5,  3, 1,  0, 0}, // #907
  {DBGFIELD("ADD16mr_ADD32mr_ADD64mr_ADD8mr_SUB16mr_SUB32mr_SUB64mr_SUB8mr") 1, false, false, false, 2360, 5,  3, 1, 19, 1}, // #908
  {DBGFIELD("ADC16mi_ADC16mi8_ADC32mi_ADC32mi8_ADC64mi32_ADC64mi8_ADC8mi_ADC8mi8_SBB16mi_SBB16mi8_SBB32mi_SBB32mi8_SBB64mi32_SBB64mi8_SBB8mi_SBB8mi8") 2, false, false, false, 2360, 5,  3, 1,  0, 0}, // #909
  {DBGFIELD("DEC16m_DEC32m_DEC64m_DEC8m_INC16m_INC32m_INC64m_INC8m_NEG16m_NEG32m_NEG64m_NEG8m_NOT16m_NOT32m_NOT64m_NOT8m") 1, false, false, false, 2360, 5,  3, 1,  0, 0}, // #910
  {DBGFIELD("CALL16r_CALL16r_NT_CALL32r_CALL32r_NT") 1, false, false, false, 2325, 4,  1, 1,  0, 0}, // #911
  {DBGFIELD("RET16_LRET16_LRET32") 1, false, false, false, 2335, 6, 10, 1,  0, 0}, // #912
  {DBGFIELD("IRET16_IRET32_IRET64") 1, false, false, false, 2335, 6, 10, 1,  0, 0}, // #913
  {DBGFIELD("AND16mi_AND16mi8_AND32mi_AND32mi8_AND64mi32_AND64mi8_AND8mi_AND8mi8_OR16mi_OR16mi8_OR32mi_OR32mi8_OR32mi8Locked_OR64mi32_OR64mi8_OR8mi_OR8mi8_XOR16mi_XOR16mi8_XOR32mi_XOR32mi8_XOR64mi32_XOR64mi8_XOR8mi_XOR8mi8") 1, false, false, false, 2360, 5,  3, 1,  0, 0}, // #914
  {DBGFIELD("AND16mr_AND32mr_AND64mr_AND8mr_OR16mr_OR32mr_OR64mr_OR8mr_XOR16mr_XOR32mr_XOR64mr_XOR8mr") 1, false, false, false, 2360, 5,  3, 1, 19, 1}, // #915
  {DBGFIELD("SHLD32mri8_SHRD32mri8") 8, false, false, false, 2713, 4, 14, 1,  0, 0}, // #916
  {DBGFIELD("SHLD32rrCL_SHRD32rrCL") 7, false, false, false, 2343, 2,  5, 1,  0, 0}, // #917
  {DBGFIELD("SHLD32mrCL_SHRD32mrCL") 8, false, false, false, 2713, 4, 14, 1,  0, 0}, // #918
  {DBGFIELD("XADD16rr_XADD32rr_XADD64rr_XADD8rr") 2, false, false, false, 11, 3,  1, 1,  0, 0}, // #919
  {DBGFIELD("CHS_F_CHS_Fp32_CHS_Fp64_CHS_Fp80") 1, false, false, false, 2365, 4,  1, 1,  0, 0}, // #920
  {DBGFIELD("MMX_MASKMOVQ_MMX_MASKMOVQ64") 1, false, false, false, 2391, 4, 12, 1,  0, 0}, // #921
  {DBGFIELD("MASKMOVDQU_MASKMOVDQU64") 1, false, false, false, 2345, 5,  1, 1,  0, 0}, // #922
  {DBGFIELD("VMASKMOVDQU_VMASKMOVDQU64") 1, false, false, false, 2345, 5,  1, 1,  0, 0}, // #923
  {DBGFIELD("VPMASKMOVDYrm")      2, false, false, false, 2832, 5,  3, 1,  0, 0}, // #924
  {DBGFIELD("VPMASKMOVDrm")       1, false, false, false, 2613, 5,  3, 1,  0, 0}, // #925
  {DBGFIELD("VPMASKMOVDYmr")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #926
  {DBGFIELD("VPMASKMOVDmr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #927
  {DBGFIELD("VPMASKMOVQYmr")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #928
  {DBGFIELD("VPMASKMOVQmr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #929
  {DBGFIELD("VPBROADCASTBrm_VPBROADCASTWrm") 1, false, false, false, 2390, 6,  6, 1,  0, 0}, // #930
  {DBGFIELD("VPGATHERDDYrm")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #931
  {DBGFIELD("VPGATHERDDrm")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #932
  {DBGFIELD("VPGATHERDQYrm")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #933
  {DBGFIELD("VPGATHERDQrm")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #934
  {DBGFIELD("VPGATHERQDYrm")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #935
  {DBGFIELD("VPGATHERQDrm")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #936
  {DBGFIELD("VPGATHERQQYrm")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #937
  {DBGFIELD("VPGATHERQQrm")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #938
  {DBGFIELD("VPERM2F128rr")       8, false, false, false, 2916, 3, 14, 1,  0, 0}, // #939
  {DBGFIELD("VPERM2I128rr")       1, false, false, false, 2605, 3,  1, 1,  0, 0}, // #940
  {DBGFIELD("VPERM2F128rm")       10, false, false, false, 2919, 3,  7, 1,  0, 0}, // #941
  {DBGFIELD("VPERM2I128rm")       1, false, false, false, 2744, 5,  3, 1,  3, 1}, // #942
  {DBGFIELD("VEXTRACTF128rr")     1, false, false, false, 2580, 3, 12, 1,  0, 0}, // #943
  {DBGFIELD("VEXTRACTI128rr")     1, false, false, false, 2605, 3,  1, 1,  0, 0}, // #944
  {DBGFIELD("VEXTRACTF128mr")     2, false, false, false, 2817, 3,  6, 1,  0, 0}, // #945
  {DBGFIELD("VEXTRACTI128mr")     1, false, false, false, 2345, 5,  1, 1,  0, 0}, // #946
  {DBGFIELD("VINSERTF128rr")      2, false, false, false, 2351, 3, 12, 1,  0, 0}, // #947
  {DBGFIELD("VINSERTI128rr")      1, false, false, false, 2605, 3,  1, 1,  0, 0}, // #948
  {DBGFIELD("CVTDQ2PDrr_VCVTDQ2PDrr") 2, false, false, false, 2439, 5,  7, 1,  0, 0}, // #949
  {DBGFIELD("VCVTDQ2PDYrr")       4, false, false, false, 2457, 5,  7, 1,  0, 0}, // #950
  {DBGFIELD("CVTPD2DQrr_CVTTPD2DQrr_VCVTPD2DQrr_VCVTTPD2DQrr") 2, false, false, false, 2439, 5,  7, 1,  0, 0}, // #951
  {DBGFIELD("CVTPD2DQrm_CVTTPD2DQrm_VCVTPD2DQrm_VCVTTPD2DQrm") 2, false, false, false, 2438, 7, 24, 1,  0, 0}, // #952
  {DBGFIELD("VCVTPD2DQYrr_VCVTTPD2DQYrr") 4, false, false, false, 2750, 6,  7, 1,  0, 0}, // #953
  {DBGFIELD("VCVTPD2DQYrm_VCVTTPD2DQYrm") 4, false, false, false, 2749, 8, 24, 1,  0, 0}, // #954
  {DBGFIELD("MMX_CVTPI2PDrr")     2, false, false, false, 2439, 5,  3, 1,  0, 0}, // #955
  {DBGFIELD("MMX_CVTPD2PIrr_MMX_CVTTPD2PIrr") 2, false, false, false, 2439, 5,  3, 1,  0, 0}, // #956
  {DBGFIELD("CVTSS2SIrr_CVTTSS2SIrr_VCVTSS2SI64rr_VCVTSS2SIrr_VCVTTSS2SI64rr_VCVTTSS2SIrr") 2, false, false, false, 2446, 9, 24, 1,  0, 0}, // #957
  {DBGFIELD("CVTSS2SIrr_Int_CVTTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int_VCVTTSS2SI64rr_Int_VCVTTSS2SIrr_Int") 2, false, false, false, 2446, 9, 24, 1,  0, 0}, // #958
  {DBGFIELD("CVTSS2SIrm_CVTSS2SIrm_Int_CVTTSS2SIrm_CVTTSS2SIrm_Int_VCVTSS2SI64rm_VCVTSS2SI64rm_Int_VCVTSS2SIrm_VCVTSS2SIrm_Int_VCVTTSS2SI64rm_VCVTTSS2SI64rm_Int_VCVTTSS2SIrm_VCVTTSS2SIrm_Int") 2, false, false, false, 2445, 11, 13, 1,  0, 0}, // #959
  {DBGFIELD("CVTSI2SDrr_CVTSI642SDrr") 2, false, false, false, 2871, 5, 24, 1,  0, 0}, // #960
  {DBGFIELD("CVTSI2SDrr_Int_CVTSI642SDrr_Int_VCVTSI2SDrr_VCVTSI2SDrr_Int_VCVTSI642SDrr_VCVTSI642SDrr_Int") 2, false, false, false, 2439, 5, 14, 1, 24, 1}, // #961
  {DBGFIELD("CVTSD2SI64rr_CVTSD2SIrr_CVTTSD2SI64rr_CVTTSD2SIrr_VCVTSD2SI64rr_VCVTSD2SIrr_VCVTTSD2SI64rr_VCVTTSD2SIrr") 2, false, false, false, 2446, 9, 24, 1,  0, 0}, // #962
  {DBGFIELD("CVTSD2SI64rr_Int_CVTSD2SIrr_Int_CVTTSD2SI64rr_Int_CVTTSD2SIrr_Int_VCVTSD2SI64rr_Int_VCVTSD2SIrr_Int") 2, false, false, false, 2446, 9, 24, 1,  0, 0}, // #963
  {DBGFIELD("VCVTTSD2SI64rr_Int_VCVTTSD2SIrr_Int") 2, false, false, false, 2446, 9, 24, 1,  0, 0}, // #964
  {DBGFIELD("CVTSD2SI64rm_CVTSD2SI64rm_Int_CVTSD2SIrm_CVTSD2SIrm_Int_CVTTSD2SI64rm_CVTTSD2SI64rm_Int_CVTTSD2SIrm_CVTTSD2SIrm_Int_VCVTSD2SI64rm_VCVTSD2SI64rm_Int_VCVTSD2SIrm_VCVTSD2SIrm_Int_VCVTTSD2SI64rm_VCVTTSD2SIrm") 2, false, false, false, 2445, 11, 13, 1,  0, 0}, // #965
  {DBGFIELD("VCVTTSD2SI64rm_Int_VCVTTSD2SIrm_Int") 2, false, false, false, 2445, 11, 13, 1,  0, 0}, // #966
  {DBGFIELD("EXTRQ_EXTRQI")       1, false, false, false, 2585, 3,  5, 1,  0, 0}, // #967
  {DBGFIELD("INSERTQ_INSERTQI")   1, false, false, false, 2585, 3,  5, 1,  0, 0}, // #968
  {DBGFIELD("SHA256MSG2rm")       1, false, false, false, 2379, 6, 22, 1,  3, 1}, // #969
  {DBGFIELD("SHA256MSG2rr")       1, false, false, false, 2380, 4, 14, 1,  0, 0}, // #970
  {DBGFIELD("SHA1MSG1rr_SHA256MSG1rr") 1, false, false, false, 2380, 4, 14, 1,  0, 0}, // #971
  {DBGFIELD("SHA1MSG1rm_SHA256MSG1rm") 1, false, false, false, 2379, 6, 22, 1,  3, 1}, // #972
  {DBGFIELD("SHA1MSG2rr")         1, false, false, false, 2380, 4, 14, 1,  0, 0}, // #973
  {DBGFIELD("SHA1MSG2rm")         1, false, false, false, 2379, 6, 22, 1,  3, 1}, // #974
  {DBGFIELD("SHA1NEXTErr")        1, false, false, false, 2380, 4, 14, 1,  0, 0}, // #975
  {DBGFIELD("SHA1NEXTErm")        1, false, false, false, 2379, 6, 22, 1,  3, 1}, // #976
  {DBGFIELD("SHA1RNDS4rri")       1, false, false, false, 2380, 4, 14, 1,  0, 0}, // #977
  {DBGFIELD("SHA1RNDS4rmi")       1, false, false, false, 2379, 6, 22, 1,  3, 1}, // #978
  {DBGFIELD("SHA256RNDS2rr")      1, false, false, false, 2380, 4, 14, 1,  0, 0}, // #979
  {DBGFIELD("SHA256RNDS2rm")      1, false, false, false, 2379, 6, 22, 1,  3, 1}, // #980
  {DBGFIELD("XCHG16rr_XCHG32rr_XCHG64rr_XCHG8rr_XCHG16ar_XCHG32ar_XCHG64ar") 2, false, false, false, 11, 3,  1, 1,  0, 0}, // #981
  {DBGFIELD("CVTDQ2PSrr_VCVTDQ2PSrr") 1, false, false, false, 2439, 5, 14, 1,  0, 0}, // #982
  {DBGFIELD("VCVTDQ2PSYrr")       2, false, false, false, 2457, 5, 14, 1,  0, 0}, // #983
  {DBGFIELD("CVTPS2DQrr_CVTTPS2DQrr_VCVTPS2DQrr_VCVTTPS2DQrr") 1, false, false, false, 2439, 5, 14, 1,  0, 0}, // #984
  {DBGFIELD("MOV8rm_MOV8rm_NOREX_MOVSX16rm16_MOVSX16rm32_MOVZX16rm16") 1, false, false, false, 2420, 2, 10, 1,  0, 0}, // #985
  {DBGFIELD("MOVBE16rm")          1, false, false, false, 2369, 4, 10, 1,  0, 0}, // #986
  {DBGFIELD("ADD8i8_ADD16i16_ADD32i32_ADD64i32_AND8i8_AND16i16_AND32i32_AND64i32_OR8i8_OR16i16_OR32i32_OR64i32_SUB8i8_SUB16i16_SUB32i32_SUB64i32_XOR8i8_XOR16i16_XOR32i32_XOR64i32") 1, false, false, false, 2320, 2,  1, 1,  0, 0}, // #987
  {DBGFIELD("MOVSX16rr16_MOVSX16rr32_MOVZX16rr16") 1, false, false, false, 2320, 2,  1, 1,  0, 0}, // #988
  {DBGFIELD("MOV32ri_MOV32ri_alt_MOV64ri32") 1, false, false, false, 2320, 2,  1, 1,  0, 0}, // #989
  {DBGFIELD("ADC8mr_SBB8mr")      2, false, false, false, 2360, 5,  3, 1, 19, 2}, // #990
  {DBGFIELD("LEA32r_LEA64r_LEA64_32r") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #991
  {DBGFIELD("LEA16r")             2, false, false, false, 2922, 2,  1, 1,  0, 0}, // #992
  {DBGFIELD("LCMPXCHG8")          2, false, false, false, 2329, 6,  5, 1,  0, 0}, // #993
  {DBGFIELD("LCMPXCHG16B")        2, false, false, false, 2329, 6,  5, 1,  0, 0}, // #994
  {DBGFIELD("XCHG8rr_XCHG16rr_XCHG16ar") 2, false, false, false, 11, 3,  1, 1,  0, 0}, // #995
  {DBGFIELD("XCHG8rm_XCHG16rm")   2, false, false, false, 2360, 5, 120, 2,  0, 0}, // #996
  {DBGFIELD("POPCNT16rr")         1, false, false, false, 2435, 2, 14, 1,  0, 0}, // #997
  {DBGFIELD("LZCNT16rr")          2, false, false, false, 2592, 3, 12, 1,  0, 0}, // #998
  {DBGFIELD("TZCNT16rr")          2, false, false, false, 2592, 3, 12, 1,  0, 0}, // #999
  {DBGFIELD("RCL8m1_RCL16m1_RCL32m1_RCL64m1_RCR8m1_RCR16m1_RCR32m1_RCR64m1") 2, false, false, false, 2360, 5, 120, 2,  0, 0}, // #1000
  {DBGFIELD("RCR8mi_RCR16mi_RCR32mi_RCR64mi") 2, false, false, false, 2360, 5, 120, 2,  0, 0}, // #1001
  {DBGFIELD("RCR16rCL_RCR32rCL_RCR64rCL") 20, false, false, false, 2924, 2, 22, 1,  0, 0}, // #1002
  {DBGFIELD("MOVHPDmr_MOVHPSmr_VMOVHPDmr_VMOVHPSmr") 2, false, false, false, 2345, 5, 12, 1,  0, 0}, // #1003
  {DBGFIELD("MMX_MOVQ2FR64rr")    1, false, false, false, 2596, 3,  1, 1,  0, 0}, // #1004
  {DBGFIELD("MMX_MOVD64rr_MMX_MOVD64to64rr") 2, false, false, false, 2580, 3,  8, 1,  0, 0}, // #1005
  {DBGFIELD("EXTRQ")              1, false, false, false, 2585, 3,  5, 1,  0, 0}, // #1006
  {DBGFIELD("INSERTQ")            1, false, false, false, 2596, 3,  5, 1,  0, 0}, // #1007
  {DBGFIELD("PABSBrr_PABSDrr_PABSWrr_PADDSBrr_PADDSWrr_PADDUSBrr_PADDUSWrr_PAVGBrr_PAVGWrr_PSIGNBrr_PSIGNDrr_PSIGNWrr_VPABSBrr_VPABSDrr_VPABSWrr_VPADDSBrr_VPADDSWrr_VPADDUSBrr_VPADDUSWrr_VPAVGBrr_VPAVGWrr_VPCMPEQQrr_VPSIGNBrr_VPSIGNDrr_VPSIGNWrr_PSUBSBrr_PSUBSWrr_PSUBUSBrr_PSUBUSWrr_VPSUBSBrr_VPSUBSWrr_VPSUBUSBrr_VPSUBUSWrr") 1, false, false, false, 2322, 3, 12, 1,  0, 0}, // #1008
  {DBGFIELD("MMX_PADDSBrr_MMX_PADDSWrr_MMX_PADDUSBrr_MMX_PADDUSWrr_MMX_PAVGBrr_MMX_PAVGWrr_MMX_PSUBSBrr_MMX_PSUBSWrr_MMX_PSUBUSBrr_MMX_PSUBUSWrr") 1, false, false, false, 2322, 3, 12, 1,  0, 0}, // #1009
  {DBGFIELD("VPABSBYrr_VPABSDYrr_VPABSWYrr_VPADDSBYrr_VPADDSWYrr_VPADDUSBYrr_VPADDUSWYrr_VPSUBSBYrr_VPSUBSWYrr_VPSUBUSBYrr_VPSUBUSWYrr_VPAVGBYrr_VPAVGWYrr_VPCMPEQQYrr_VPSIGNBYrr_VPSIGNDYrr_VPSIGNWYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1010
  {DBGFIELD("MMX_CVTPD2PIrm_MMX_CVTTPD2PIrm") 2, false, false, false, 2438, 7, 24, 1,  0, 0}, // #1011
  {DBGFIELD("SHA1MSG1rr")         1, false, false, false, 2380, 4, 14, 1,  0, 0}, // #1012
  {DBGFIELD("SHA1MSG1rm")         1, false, false, false, 2379, 6, 22, 1,  3, 1}, // #1013
  {DBGFIELD("VPERMPSYrm")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1014
  {DBGFIELD("VPERMPDYri")         2, false, false, false, 2351, 3, 12, 1,  0, 0}, // #1015
  {DBGFIELD("VPERMQYri")          1, false, false, false, 2605, 3,  1, 1,  0, 0}, // #1016
  {DBGFIELD("VPERMPDYmi")         2, false, false, false, 2350, 5,  6, 1,  3, 1}, // #1017
  {DBGFIELD("VPERMQYmi")          1, false, false, false, 2744, 5,  3, 1,  3, 1}, // #1018
  {DBGFIELD("VPERMDYrm")          1, false, false, false, 2744, 5,  3, 1,  3, 1}, // #1019
  {DBGFIELD("MOV32rr_MOV32rr_REV_MOV64rr_MOV64rr_REV") 1, false, false, false, 2320, 2,  1, 1,  0, 0}, // #1020
  {DBGFIELD("MOVSX32rr32")        1, false, false, false, 2320, 2,  1, 1,  0, 0}, // #1021
  {DBGFIELD("XOR32rr_REV_XOR64rr_REV_SUB32rr_REV_SUB64rr_REV") 1, false, false, false, 2320, 2,  1, 1,  0, 0}, // #1022
  {DBGFIELD("CMP8rr_CMP8rr_REV_CMP16rr_CMP16rr_REV_CMP32rr_CMP32rr_REV_CMP64rr_CMP64rr_REV") 1, false, false, false, 2320, 2,  1, 1,  0, 0}, // #1023
  {DBGFIELD("VXORPSrr_VXORPDrr")  8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #1024
  {DBGFIELD("VANDNPSrr_VANDNPDrr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #1025
  {DBGFIELD("VANDNPSYrr_VANDNPDYrr") 2, false, false, false, 2740, 3, 12, 1,  0, 0}, // #1026
  {DBGFIELD("VPXORrr")            8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #1027
  {DBGFIELD("VPANDNrr")           8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #1028
  {DBGFIELD("VPANDNYrr")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1029
  {DBGFIELD("VPSUBBrr_VPSUBWrr_VPSUBDrr_VPSUBQrr_VPCMPGTBrr_VPCMPGTWrr_VPCMPGTDrr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #1030
  {DBGFIELD("KADDBrr_KADDDrr_KADDQrr_KADDWrr_KANDBrr_KANDDrr_KANDQrr_KANDWrr_KANDNBrr_KANDNDrr_KANDNQrr_KANDNWrr_KNOTBrr_KNOTDrr_KNOTQrr_KNOTWrr_KORBrr_KORDrr_KORQrr_KORWrr_KORTESTBrr_KORTESTDrr_KORTESTQrr_KORTESTWrr_KTESTBrr_KTESTDrr_KTESTQrr_KTESTWrr_KXNORBrr_KXNORDrr_KXNORQrr_KXNORWrr_KXORBrr_KXORDrr_KXORQrr_KXORWrr") 1, false, false, false, 2322, 3, 12, 1,  0, 0}, // #1031
  {DBGFIELD("KMOVBkk_KMOVDkk_KMOVQkk_KMOVWkk_KMOVBrk_KMOVDrk_KMOVQrk_KMOVWrk") 1, false, false, false, 2320, 2,  1, 1,  0, 0}, // #1032
  {DBGFIELD("KUNPCKBWrr_KUNPCKDQrr_KUNPCKWDrr") 1, false, false, false, 2391, 4, 12, 1,  0, 0}, // #1033
  {DBGFIELD("KMOVBmk_KMOVDmk_KMOVQmk_KMOVWmk") 1, false, false, false, 2499, 2,  1, 1,  0, 0}, // #1034
  {DBGFIELD("KMOVBkr_KMOVDkr_KMOVQkr_KMOVWkr") 1, false, false, false, 2320, 2,  1, 1,  0, 0}, // #1035
  {DBGFIELD("VALIGNDZrri_VALIGNQZrri") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1036
  {DBGFIELD("VALIGNDZ128rri_VALIGNQZ128rri") 1, false, false, false, 2391, 4, 12, 1,  0, 0}, // #1037
  {DBGFIELD("VALIGNDZ256rri_VALIGNQZ256rri") 2, false, false, false, 2734, 4, 12, 1,  0, 0}, // #1038
  {DBGFIELD("VPERMPSYrr")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1039
  {DBGFIELD("VPERMDYrr")          1, false, false, false, 2605, 3,  1, 1,  0, 0}, // #1040
  {DBGFIELD("VFIXUPIMMPDZ128rrik_VFIXUPIMMPDZ128rrikz_VFIXUPIMMPSZ128rrik_VFIXUPIMMPSZ128rrikz_VFIXUPIMMPDZ128rri_VFIXUPIMMPSZ128rri_VRANGEPDZ128rri_VRANGEPDZ128rrik_VRANGEPDZ128rrikz_VRANGEPSZ128rri_VRANGEPSZ128rrik_VRANGEPSZ128rrikz_VRANGESDZrri_VRANGESDZrrib_VRANGESDZrribk_VRANGESDZrribkz_VRANGESDZrrik_VRANGESDZrrikz_VRANGESSZrri_VRANGESSZrrib_VRANGESSZrribk_VRANGESSZrribkz_VRANGESSZrrik_VRANGESSZrrikz") 1, false, false, false, 2374, 4, 10, 1,  0, 0}, // #1041
  {DBGFIELD("VFIXUPIMMPDZ256rrik_VFIXUPIMMPDZ256rrikz_VFIXUPIMMPSZ256rrik_VFIXUPIMMPSZ256rrikz_VFIXUPIMMPDZ256rri_VFIXUPIMMPSZ256rri_VRANGEPDZ256rri_VRANGEPDZ256rrik_VRANGEPDZ256rrikz_VRANGEPSZ256rri_VRANGEPSZ256rrik_VRANGEPSZ256rrikz") 2, false, false, false, 2728, 4, 10, 1,  0, 0}, // #1042
  {DBGFIELD("VFIXUPIMMPDZrrik_VFIXUPIMMPDZrrikz_VFIXUPIMMPSZrrik_VFIXUPIMMPSZrrikz_VRANGEPDZrri_VRANGEPDZrrib_VRANGEPDZrribk_VRANGEPDZrribkz_VRANGEPDZrrik_VRANGEPDZrrikz_VRANGEPSZrri_VRANGEPSZrrib_VRANGEPSZrribk_VRANGEPSZrribkz_VRANGEPSZrrik_VRANGEPSZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1043
  {DBGFIELD("VFIXUPIMMSDZrrik_VFIXUPIMMSDZrrikz_VFIXUPIMMSSZrrik_VFIXUPIMMSSZrrikz") 1, false, false, false, 2374, 4, 10, 1,  0, 0}, // #1044
  {DBGFIELD("VSCALEFSDZrrb_Int_VSCALEFSDZrrb_Intk_VSCALEFSDZrrb_Intkz_VSCALEFSSZrrb_Int_VSCALEFSSZrrb_Intk_VSCALEFSSZrrb_Intkz") 1, false, false, false, 2374, 4, 10, 1,  0, 0}, // #1045
  {DBGFIELD("VREDUCEPDZ128rri_VREDUCEPDZ128rrik_VREDUCEPDZ128rrikz_VREDUCEPSZ128rri_VREDUCEPSZ128rrik_VREDUCEPSZ128rrikz_VREDUCESDZrri_VREDUCESDZrrib_VREDUCESDZrribk_VREDUCESDZrribkz_VREDUCESDZrrik_VREDUCESDZrrikz_VREDUCESSZrri_VREDUCESSZrrib_VREDUCESSZrribk_VREDUCESSZrribkz_VREDUCESSZrrik_VREDUCESSZrrikz") 1, false, false, false, 2517, 4, 14, 1,  0, 0}, // #1046
  {DBGFIELD("VREDUCEPDZrri_VREDUCEPDZrrib_VREDUCEPDZrribk_VREDUCEPDZrribkz_VREDUCEPDZrrik_VREDUCEPDZrrikz_VREDUCEPSZrri_VREDUCEPSZrrib_VREDUCEPSZrribk_VREDUCEPSZrribkz_VREDUCEPSZrrik_VREDUCEPSZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1047
  {DBGFIELD("VDPBF16PSZ128r_VDPBF16PSZ128rk_VDPBF16PSZ128rkz") 1, false, false, false, 2351, 2, 10, 1,  0, 0}, // #1048
  {DBGFIELD("VDPBF16PSZ256r_VDPBF16PSZ256rk_VDPBF16PSZ256rkz") 2, false, false, false, 2351, 2, 10, 1,  0, 0}, // #1049
  {DBGFIELD("VDPBF16PSZr_VDPBF16PSZrk_VDPBF16PSZrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1050
  {DBGFIELD("VPDPBUSDSZ128r_VPDPBUSDSZ128rk_VPDPBUSDSZ128rkz_VPDPBUSDZ128r_VPDPBUSDZ128rk_VPDPBUSDZ128rkz_VPDPWSSDSZ128r_VPDPWSSDSZ128rk_VPDPWSSDSZ128rkz_VPDPWSSDZ128r_VPDPWSSDZ128rk_VPDPWSSDZ128rkz_VPMADD52HUQZ128r_VPMADD52HUQZ128rk_VPMADD52HUQZ128rkz_VPMADD52LUQZ128r_VPMADD52LUQZ128rk_VPMADD52LUQZ128rkz") 1, false, false, false, 2380, 4, 14, 1,  0, 0}, // #1051
  {DBGFIELD("VPDPBUSDSZ256r_VPDPBUSDSZ256rk_VPDPBUSDSZ256rkz_VPDPBUSDZ256r_VPDPBUSDZ256rk_VPDPBUSDZ256rkz_VPDPWSSDSZ256r_VPDPWSSDSZ256rk_VPDPWSSDSZ256rkz_VPDPWSSDZ256r_VPDPWSSDZ256rk_VPDPWSSDZ256rkz_VPMADD52HUQZ256r_VPMADD52HUQZ256rk_VPMADD52HUQZ256rkz_VPMADD52LUQZ256r_VPMADD52LUQZ256rk_VPMADD52LUQZ256rkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1052
  {DBGFIELD("VPDPBUSDSZr_VPDPBUSDSZrk_VPDPBUSDSZrkz_VPDPBUSDZr_VPDPBUSDZrk_VPDPBUSDZrkz_VPDPWSSDSZr_VPDPWSSDSZrk_VPDPWSSDSZrkz_VPDPWSSDZr_VPDPWSSDZrk_VPDPWSSDZrkz_VPMADD52HUQZr_VPMADD52HUQZrk_VPMADD52HUQZrkz_VPMADD52LUQZr_VPMADD52LUQZrk_VPMADD52LUQZrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1053
  {DBGFIELD("VPLZCNTDZ128rr_VPLZCNTDZ128rrk_VPLZCNTDZ128rrkz_VPLZCNTQZ128rr_VPLZCNTQZ128rrk_VPLZCNTQZ128rrkz_VPSHLDDZ128rri_VPSHLDDZ128rrik_VPSHLDDZ128rrikz_VPSHLDQZ128rri_VPSHLDQZ128rrik_VPSHLDQZ128rrikz_VPSHLDVDZ128rk_VPSHLDVDZ128rkz_VPSHLDVQZ128rk_VPSHLDVQZ128rkz_VPSHLDVWZ128rk_VPSHLDVWZ128rkz_VPSHLDWZ128rri_VPSHLDWZ128rrik_VPSHLDWZ128rrikz_VPSHRDDZ128rri_VPSHRDDZ128rrik_VPSHRDDZ128rrikz_VPSHRDQZ128rri_VPSHRDQZ128rrik_VPSHRDQZ128rrikz_VPSHRDVDZ128rk_VPSHRDVDZ128rkz_VPSHRDVQZ128rk_VPSHRDVQZ128rkz_VPSHRDVWZ128rk_VPSHRDVWZ128rkz_VPSHRDWZ128rri_VPSHRDWZ128rrik_VPSHRDWZ128rrikz_VPSHUFBITQMBZ128rr_VPSHUFBITQMBZ128rrk") 1, false, false, false, 2380, 4, 14, 1,  0, 0}, // #1054
  {DBGFIELD("VPLZCNTDZ256rr_VPLZCNTDZ256rrk_VPLZCNTDZ256rrkz_VPLZCNTQZ256rr_VPLZCNTQZ256rrk_VPLZCNTQZ256rrkz_VPSHLDDZ256rri_VPSHLDDZ256rrik_VPSHLDDZ256rrikz_VPSHLDQZ256rri_VPSHLDQZ256rrik_VPSHLDQZ256rrikz_VPSHLDVDZ256rk_VPSHLDVDZ256rkz_VPSHLDVQZ256rk_VPSHLDVQZ256rkz_VPSHLDVWZ256rk_VPSHLDVWZ256rkz_VPSHLDWZ256rri_VPSHLDWZ256rrik_VPSHLDWZ256rrikz_VPSHRDDZ256rri_VPSHRDDZ256rrik_VPSHRDDZ256rrikz_VPSHRDQZ256rri_VPSHRDQZ256rrik_VPSHRDQZ256rrikz_VPSHRDVDZ256rk_VPSHRDVDZ256rkz_VPSHRDVQZ256rk_VPSHRDVQZ256rkz_VPSHRDVWZ256rk_VPSHRDVWZ256rkz_VPSHRDWZ256rri_VPSHRDWZ256rrik_VPSHRDWZ256rrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1055
  {DBGFIELD("VPLZCNTDZrr_VPLZCNTDZrrk_VPLZCNTDZrrkz_VPLZCNTQZrr_VPLZCNTQZrrk_VPLZCNTQZrrkz_VPSHLDDZrri_VPSHLDDZrrik_VPSHLDDZrrikz_VPSHLDQZrri_VPSHLDQZrrik_VPSHLDQZrrikz_VPSHLDVDZrk_VPSHLDVDZrkz_VPSHLDVQZrk_VPSHLDVQZrkz_VPSHLDVWZrk_VPSHLDVWZrkz_VPSHLDWZrri_VPSHLDWZrrik_VPSHLDWZrrikz_VPSHRDDZrri_VPSHRDDZrrik_VPSHRDDZrrikz_VPSHRDQZrri_VPSHRDQZrrik_VPSHRDQZrrikz_VPSHRDVDZrk_VPSHRDVDZrkz_VPSHRDVQZrk_VPSHRDVQZrkz_VPSHRDVWZrk_VPSHRDVWZrkz_VPSHRDWZrri_VPSHRDWZrrik_VPSHRDWZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1056
  {DBGFIELD("PSLLDrr_PSLLQrr_PSLLWrr_PSRADrr_PSRAWrr_PSRLDrr_PSRLQrr_PSRLWrr_VPSLLDZ128rr_VPSLLDZ128rrk_VPSLLDZ128rrkz_VPSLLDrr_VPSLLQZ128rr_VPSLLQZ128rrk_VPSLLQZ128rrkz_VPSLLQrr_VPSLLWZ128rr_VPSLLWZ128rrk_VPSLLWZ128rrkz_VPSLLWrr_VPSRADZ128rr_VPSRADZ128rrk_VPSRADZ128rrkz_VPSRADrr_VPSRAQZ128rr_VPSRAQZ128rrk_VPSRAQZ128rrkz_VPSRAWZ128rr_VPSRAWZ128rrk_VPSRAWZ128rrkz_VPSRAWrr_VPSRLDZ128rr_VPSRLDZ128rrk_VPSRLDZ128rrkz_VPSRLDrr_VPSRLQZ128rr_VPSRLQZ128rrk_VPSRLQZ128rrkz_VPSRLQrr_VPSRLWZ128rr_VPSRLWZ128rrk_VPSRLWZ128rrkz_VPSRLWrr") 1, false, false, false, 2391, 4,  5, 1,  0, 0}, // #1057
  {DBGFIELD("VPSLLDYrr_VPSLLDZ256rr_VPSLLDZ256rrk_VPSLLDZ256rrkz_VPSLLQYrr_VPSLLQZ256rr_VPSLLQZ256rrk_VPSLLQZ256rrkz_VPSLLWYrr_VPSLLWZ256rr_VPSLLWZ256rrk_VPSLLWZ256rrkz_VPSRADYrr_VPSRADZ256rr_VPSRADZ256rrk_VPSRADZ256rrkz_VPSRAQZ256rr_VPSRAQZ256rrk_VPSRAQZ256rrkz_VPSRAWYrr_VPSRAWZ256rr_VPSRAWZ256rrk_VPSRAWZ256rrkz_VPSRLDYrr_VPSRLDZ256rr_VPSRLDZ256rrk_VPSRLDZ256rrkz_VPSRLQYrr_VPSRLQZ256rr_VPSRLQZ256rrk_VPSRLQZ256rrkz_VPSRLWYrr_VPSRLWZ256rr_VPSRLWZ256rrk_VPSRLWZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1058
  {DBGFIELD("VPSLLDZrr_VPSLLDZrrk_VPSLLDZrrkz_VPSLLQZrr_VPSLLQZrrk_VPSLLQZrrkz_VPSLLWZrr_VPSLLWZrrk_VPSLLWZrrkz_VPSRADZrr_VPSRADZrrk_VPSRADZrrkz_VPSRAQZrr_VPSRAQZrrk_VPSRAQZrrkz_VPSRAWZrr_VPSRAWZrrk_VPSRAWZrrkz_VPSRLDZrr_VPSRLDZrrk_VPSRLDZrrkz_VPSRLQZrr_VPSRLQZrrk_VPSRLQZrrkz_VPSRLWZrr_VPSRLWZrrk_VPSRLWZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1059
  {DBGFIELD("VPSLLDQYri_VPSRLDQYri_VPSLLDQZ256ri_VPSRLDQZ256ri") 2, false, false, false, 2734, 4, 12, 1,  0, 0}, // #1060
  {DBGFIELD("PSLLDQri_PSRLDQri_VPSLLDQri_VPSRLDQri") 1, false, false, false, 2391, 4, 12, 1,  0, 0}, // #1061
  {DBGFIELD("VPSLLDQZri_VPSRLDQZri") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1062
  {DBGFIELD("VPSHUFBYrr_VPSHUFBZ256rr_VPSHUFBZ256rrk_VPSHUFBZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1063
  {DBGFIELD("VPSHUFBZ128rr_VPSHUFBZ128rrk_VPSHUFBZ128rrkz") 1, false, false, false, 2391, 4,  5, 1,  0, 0}, // #1064
  {DBGFIELD("VPSHUFBZrr_VPSHUFBZrrk_VPSHUFBZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1065
  {DBGFIELD("VPROLVDZ128rr_VPROLVDZ128rrk_VPROLVDZ128rrkz_VPROLVQZ128rr_VPROLVQZ128rrk_VPROLVQZ128rrkz_VPRORVDZ128rr_VPRORVDZ128rrk_VPRORVDZ128rrkz_VPRORVQZ128rr_VPRORVQZ128rrk_VPRORVQZ128rrkz") 1, false, false, false, 2391, 4,  5, 1,  0, 0}, // #1066
  {DBGFIELD("VPROLVDZ256rr_VPROLVDZ256rrk_VPROLVDZ256rrkz_VPROLVQZ256rr_VPROLVQZ256rrk_VPROLVQZ256rrkz_VPRORVDZ256rr_VPRORVDZ256rrk_VPRORVDZ256rrkz_VPRORVQZ256rr_VPRORVQZ256rrk_VPRORVQZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1067
  {DBGFIELD("VPROLVDZrr_VPROLVDZrrk_VPROLVDZrrkz_VPROLVQZrr_VPROLVQZrrk_VPROLVQZrrkz_VPRORVDZrr_VPRORVDZrrk_VPRORVDZrrkz_VPRORVQZrr_VPRORVQZrrk_VPRORVQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1068
  {DBGFIELD("VPROLDZ256ri_VPROLDZ256rik_VPROLDZ256rikz_VPROLQZ256ri_VPROLQZ256rik_VPROLQZ256rikz_VPRORDZ256ri_VPRORDZ256rik_VPRORDZ256rikz_VPRORQZ256ri_VPRORQZ256rik_VPRORQZ256rikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1069
  {DBGFIELD("VPROLDZ128ri_VPROLDZ128rik_VPROLDZ128rikz_VPROLQZ128ri_VPROLQZ128rik_VPROLQZ128rikz_VPRORDZ128ri_VPRORDZ128rik_VPRORDZ128rikz_VPRORQZ128ri_VPRORQZ128rik_VPRORQZ128rikz") 1, false, false, false, 2391, 4, 12, 1,  0, 0}, // #1070
  {DBGFIELD("VPROLDZri_VPROLDZrik_VPROLDZrikz_VPROLQZri_VPROLQZrik_VPROLQZrikz_VPRORDZri_VPRORDZrik_VPRORDZrikz_VPRORQZri_VPRORQZrik_VPRORQZrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1071
  {DBGFIELD("VFMSUB231SSZr_Intkz") 1, false, false, false, 2351, 2, 10, 1,  0, 0}, // #1072
  {DBGFIELD("VPSLLDZ128ri_VPSLLDZ128rik_VPSLLDZ128rikz_VPSLLQZ128ri_VPSLLQZ128rik_VPSLLQZ128rikz_VPSLLWZ128ri_VPSLLWZ128rik_VPSLLWZ128rikz_VPSRADZ128ri_VPSRADZ128rik_VPSRADZ128rikz_VPSRAQZ128ri_VPSRAQZ128rik_VPSRAQZ128rikz_VPSRAWZ128ri_VPSRAWZ128rik_VPSRAWZ128rikz_VPSRLDZ128ri_VPSRLDZ128rik_VPSRLDZ128rikz_VPSRLQZ128ri_VPSRLQZ128rik_VPSRLQZ128rikz_VPSRLWZ128ri_VPSRLWZ128rik_VPSRLWZ128rikz") 1, false, false, false, 2391, 4, 12, 1,  0, 0}, // #1073
  {DBGFIELD("VPSLLDZ256ri_VPSLLDZ256rik_VPSLLDZ256rikz_VPSLLQZ256ri_VPSLLQZ256rik_VPSLLQZ256rikz_VPSLLWZ256ri_VPSLLWZ256rik_VPSLLWZ256rikz_VPSRADZ256ri_VPSRADZ256rik_VPSRADZ256rikz_VPSRAQZ256ri_VPSRAQZ256rik_VPSRAQZ256rikz_VPSRAWZ256ri_VPSRAWZ256rik_VPSRAWZ256rikz_VPSRLDZ256ri_VPSRLDZ256rik_VPSRLDZ256rikz_VPSRLQZ256ri_VPSRLQZ256rik_VPSRLQZ256rikz_VPSRLWZ256ri_VPSRLWZ256rik_VPSRLWZ256rikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1074
  {DBGFIELD("VPSLLDZri_VPSLLDZrik_VPSLLDZrikz_VPSLLQZri_VPSLLQZrik_VPSLLQZrikz_VPSLLWZri_VPSLLWZrik_VPSLLWZrikz_VPSRADZri_VPSRADZrik_VPSRADZrikz_VPSRAQZri_VPSRAQZrik_VPSRAQZrikz_VPSRAWZri_VPSRAWZrik_VPSRAWZrikz_VPSRLDZri_VPSRLDZrik_VPSRLDZrikz_VPSRLQZri_VPSRLQZrik_VPSRLQZrikz_VPSRLWZri_VPSRLWZrik_VPSRLWZrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1075
  {DBGFIELD("PALIGNRrri_VPALIGNRZ128rri_VPALIGNRZ128rrik_VPALIGNRZ128rrikz_VPALIGNRrri") 1, false, false, false, 2391, 4, 12, 1,  0, 0}, // #1076
  {DBGFIELD("VPALIGNRZ256rri_VPALIGNRZ256rrik_VPALIGNRZ256rrikz") 2, false, false, false, 2734, 4, 12, 1,  0, 0}, // #1077
  {DBGFIELD("VPALIGNRZrri_VPALIGNRZrrik_VPALIGNRZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1078
  {DBGFIELD("PACKSSDWrr_PACKSSWBrr_PACKUSDWrr_PACKUSWBrr_VPACKSSDWZ128rr_VPACKSSDWZ128rrk_VPACKSSDWZ128rrkz_VPACKSSDWrr_VPACKSSWBZ128rr_VPACKSSWBZ128rrk_VPACKSSWBZ128rrkz_VPACKSSWBrr_VPACKUSDWZ128rr_VPACKUSDWZ128rrk_VPACKUSDWZ128rrkz_VPACKUSDWrr_VPACKUSWBZ128rr_VPACKUSWBZ128rrk_VPACKUSWBZ128rrkz_VPACKUSWBrr") 1, false, false, false, 2391, 4, 12, 1,  0, 0}, // #1079
  {DBGFIELD("VPACKSSDWZ256rr_VPACKSSDWZ256rrk_VPACKSSDWZ256rrkz_VPACKSSWBZ256rr_VPACKSSWBZ256rrk_VPACKSSWBZ256rrkz_VPACKUSDWZ256rr_VPACKUSDWZ256rrk_VPACKUSDWZ256rrkz_VPACKUSWBZ256rr_VPACKUSWBZ256rrk_VPACKUSWBZ256rrkz") 2, false, false, false, 2734, 4, 12, 1,  0, 0}, // #1080
  {DBGFIELD("VPACKSSDWZrr_VPACKSSDWZrrk_VPACKSSDWZrrkz_VPACKSSWBZrr_VPACKSSWBZrrk_VPACKSSWBZrrkz_VPACKUSDWZrr_VPACKUSDWZrrk_VPACKUSDWZrrkz_VPACKUSWBZrr_VPACKUSWBZrrk_VPACKUSWBZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1081
  {DBGFIELD("CMPPDrri_VCMPPDrri_VMAXCPDZ128rr_VMAXCPDZ128rrk_VMAXCPDZ128rrkz_VMAXPDZ128rr_VMAXPDZ128rrk_VMAXPDZ128rrkz_VMINCPDZ128rr_VMINCPDZ128rrk_VMINCPDZ128rrkz_VMINPDZ128rr_VMINPDZ128rrk_VMINPDZ128rrkz") 1, false, false, false, 2374, 4, 12, 1,  0, 0}, // #1082
  {DBGFIELD("CMPPSrri_VCMPPSrri") 1, false, false, false, 2374, 4, 12, 1,  0, 0}, // #1083
  {DBGFIELD("CMPSDrr_CMPSDrr_Int_VCMPSDrr_VCMPSDrr_Int_MAXSDrr_Int_MINSDrr_Int_VMAXSDZrr_Int_VMAXSDZrr_Intk_VMAXSDZrr_Intkz_VMAXSDrr_Int_VMINSDZrr_Int_VMINSDZrr_Intk_VMINSDZrr_Intkz_VMINSDrr_Int") 1, false, false, false, 2374, 4, 12, 1,  0, 0}, // #1084
  {DBGFIELD("CMPSSrr_CMPSSrr_Int_VCMPSSrr_VCMPSSrr_Int_MAXSSrr_Int_MINSSrr_Int_VMAXSSZrr_Int_VMAXSSZrr_Intk_VMAXSSZrr_Intkz_VMAXSSrr_Int_VMINSSZrr_Int_VMINSSZrr_Intk_VMINSSZrr_Intkz_VMINSSrr_Int") 1, false, false, false, 2374, 4, 12, 1,  0, 0}, // #1085
  {DBGFIELD("VPMAXSQZ128rr_VPMAXSQZ128rrk_VPMAXSQZ128rrkz_VPMAXUQZ128rr_VPMAXUQZ128rrk_VPMAXUQZ128rrkz_VPMINSQZ128rr_VPMINSQZ128rrk_VPMINSQZ128rrkz_VPMINUQZ128rr_VPMINUQZ128rrk_VPMINUQZ128rrkz") 1, false, false, false, 2322, 3, 12, 1,  0, 0}, // #1086
  {DBGFIELD("VPMAXSQZ256rr_VPMAXSQZ256rrk_VPMAXSQZ256rrkz_VPMAXUQZ256rr_VPMAXUQZ256rrk_VPMAXUQZ256rrkz_VPMINSQZ256rr_VPMINSQZ256rrk_VPMINSQZ256rrkz_VPMINUQZ256rr_VPMINUQZ256rrk_VPMINUQZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1087
  {DBGFIELD("VPMAXSQZrr_VPMAXSQZrrk_VPMAXSQZrrkz_VPMAXUQZrr_VPMAXUQZrrk_VPMAXUQZrrkz_VPMINSQZrr_VPMINSQZrrk_VPMINSQZrrkz_VPMINUQZrr_VPMINUQZrrk_VPMINUQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1088
  {DBGFIELD("VMAXCPDZ256rr_VMAXCPDZ256rrk_VMAXCPDZ256rrkz_VMAXPDZ256rr_VMAXPDZ256rrk_VMAXPDZ256rrkz_VMINCPDZ256rr_VMINCPDZ256rrk_VMINCPDZ256rrkz_VMINPDZ256rr_VMINPDZ256rrk_VMINPDZ256rrkz") 2, false, false, false, 2728, 4, 12, 1,  0, 0}, // #1089
  {DBGFIELD("VMAXCPDZrr_VMAXCPDZrrk_VMAXCPDZrrkz_VMAXPDZrr_VMAXPDZrrb_VMAXPDZrrbk_VMAXPDZrrbkz_VMAXPDZrrk_VMAXPDZrrkz_VMINCPDZrr_VMINCPDZrrk_VMINCPDZrrkz_VMINPDZrr_VMINPDZrrb_VMINPDZrrbk_VMINPDZrrbkz_VMINPDZrrk_VMINPDZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1090
  {DBGFIELD("VPMOVSXBDZ128rr_VPMOVSXBDZ128rrk_VPMOVSXBDZ128rrkz_VPMOVSXBQZ128rr_VPMOVSXBQZ128rrk_VPMOVSXBQZ128rrkz_VPMOVSXBWZ128rr_VPMOVSXBWZ128rrk_VPMOVSXBWZ128rrkz_VPMOVSXDQZ128rr_VPMOVSXDQZ128rrk_VPMOVSXDQZ128rrkz_VPMOVSXWDZ128rr_VPMOVSXWDZ128rrk_VPMOVSXWDZ128rrkz_VPMOVSXWQZ128rr_VPMOVSXWQZ128rrk_VPMOVSXWQZ128rrkz_VPMOVZXBDZ128rr_VPMOVZXBDZ128rrk_VPMOVZXBDZ128rrkz_VPMOVZXBQZ128rr_VPMOVZXBQZ128rrk_VPMOVZXBQZ128rrkz_VPMOVZXBWZ128rr_VPMOVZXBWZ128rrk_VPMOVZXBWZ128rrkz_VPMOVZXDQZ128rr_VPMOVZXDQZ128rrk_VPMOVZXDQZ128rrkz_VPMOVZXWDZ128rr_VPMOVZXWDZ128rrk_VPMOVZXWDZ128rrkz_VPMOVZXWQZ128rr_VPMOVZXWQZ128rrk_VPMOVZXWQZ128rrkz") 1, false, false, false, 2391, 4, 12, 1,  0, 0}, // #1091
  {DBGFIELD("VPMOVSXBDZ256rr_VPMOVSXBDZ256rrk_VPMOVSXBDZ256rrkz_VPMOVSXBQZ256rr_VPMOVSXBQZ256rrk_VPMOVSXBQZ256rrkz_VPMOVSXBWZ256rr_VPMOVSXBWZ256rrk_VPMOVSXBWZ256rrkz_VPMOVSXDQZ256rr_VPMOVSXDQZ256rrk_VPMOVSXDQZ256rrkz_VPMOVSXWDZ256rr_VPMOVSXWDZ256rrk_VPMOVSXWDZ256rrkz_VPMOVSXWQZ256rr_VPMOVSXWQZ256rrk_VPMOVSXWQZ256rrkz_VPMOVZXBDZ256rr_VPMOVZXBDZ256rrk_VPMOVZXBDZ256rrkz_VPMOVZXBQZ256rr_VPMOVZXBQZ256rrk_VPMOVZXBQZ256rrkz_VPMOVZXBWZ256rr_VPMOVZXBWZ256rrk_VPMOVZXBWZ256rrkz_VPMOVZXDQZ256rr_VPMOVZXDQZ256rrk_VPMOVZXDQZ256rrkz_VPMOVZXWDZ256rr_VPMOVZXWDZ256rrk_VPMOVZXWDZ256rrkz_VPMOVZXWQZ256rr_VPMOVZXWQZ256rrk_VPMOVZXWQZ256rrkz_VPMOVSXBDYrr_VPMOVSXBQYrr_VPMOVSXBWYrr_VPMOVZXBDYrr_VPMOVZXBQYrr_VPMOVZXBWYrr_VPMOVSXDQYrr_VPMOVSXWDYrr_VPMOVSXWQYrr_VPMOVUSQWZ128rr_VPMOVUSQWZ128rrk_VPMOVUSQWZ128rrkz_VPMOVZXDQYrr_VPMOVZXWDYrr_VPMOVZXWQYrr_VPMOVDBZ128rr_VPMOVDBZ128rrk_VPMOVDBZ128rrkz_VPMOVDWZ128rr_VPMOVDWZ128rrk_VPMOVDWZ128rrkz_VPMOVQBZ128rr_VPMOVQBZ128rrk_VPMOVQBZ128rrkz_VPMOVQDZ128rr_VPMOVQDZ128rrk_VPMOVQDZ128rrkz_VPMOVQWZ128rr_VPMOVQWZ128rrk_VPMOVQWZ128rrkz_VPMOVSDBZ128rr_VPMOVSDBZ128rrk_VPMOVSDBZ128rrkz_VPMOVSDWZ128rr_VPMOVSDWZ128rrk_VPMOVSDWZ128rrkz_VPMOVSQBZ128rr_VPMOVSQBZ128rrk_VPMOVSQBZ128rrkz_VPMOVSQDZ128rr_VPMOVSQDZ128rrk_VPMOVSQDZ128rrkz_VPMOVSQWZ128rr_VPMOVSQWZ128rrk_VPMOVSQWZ128rrkz_VPMOVSWBZ128rr_VPMOVSWBZ128rrk_VPMOVSWBZ128rrkz_VPMOVUSDBZ128rr_VPMOVUSDBZ128rrk_VPMOVUSDBZ128rrkz_VPMOVUSDWZ128rr_VPMOVUSDWZ128rrk_VPMOVUSDWZ128rrkz_VPMOVUSQBZ128rr_VPMOVUSQBZ128rrk_VPMOVUSQBZ128rrkz_VPMOVUSQDZ128rr_VPMOVUSQDZ128rrk_VPMOVUSQDZ128rrkz_VPMOVUSWBZ128rr_VPMOVUSWBZ128rrk_VPMOVUSWBZ128rrkz_VPMOVWBZ128rr_VPMOVWBZ128rrk_VPMOVWBZ128rrkz") 1, false, false, false, 2605, 3,  1, 1,  0, 0}, // #1092
  {DBGFIELD("VMOVDDUPZ128rr_VMOVDDUPZ128rrk_VMOVDDUPZ128rrkz") 1, false, false, false, 2580, 3, 12, 1,  0, 0}, // #1093
  {DBGFIELD("VMOVDDUPZ256rr_VMOVDDUPZ256rrk_VMOVDDUPZ256rrkz") 2, false, false, false, 2807, 3, 12, 1,  0, 0}, // #1094
  {DBGFIELD("VMOVDDUPZrr_VMOVDDUPZrrk_VMOVDDUPZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1095
  {DBGFIELD("PMOVSXBDrr_PMOVSXBQrr_PMOVSXBWrr_PMOVSXDQrr_PMOVSXWDrr_PMOVSXWQrr_PMOVZXBDrr_PMOVZXBQrr_PMOVZXBWrr_PMOVZXDQrr_PMOVZXWDrr_PMOVZXWQrr_VPMOVSXBDrr_VPMOVSXBQrr_VPMOVSXBWrr_VPMOVSXDQrr_VPMOVSXWDrr_VPMOVSXWQrr_VPMOVZXBDrr_VPMOVZXBQrr_VPMOVZXBWrr_VPMOVZXDQrr_VPMOVZXWDrr_VPMOVZXWQrr") 1, false, false, false, 2391, 4, 12, 1,  0, 0}, // #1096
  {DBGFIELD("VPMOVSXBDZrr_VPMOVSXBDZrrk_VPMOVSXBDZrrkz_VPMOVSXBQZrr_VPMOVSXBQZrrk_VPMOVSXBQZrrkz_VPMOVSXBWZrr_VPMOVSXBWZrrk_VPMOVSXBWZrrkz_VPMOVSXDQZrr_VPMOVSXDQZrrk_VPMOVSXDQZrrkz_VPMOVSXWDZrr_VPMOVSXWDZrrk_VPMOVSXWDZrrkz_VPMOVSXWQZrr_VPMOVSXWQZrrk_VPMOVSXWQZrrkz_VPMOVZXBDZrr_VPMOVZXBDZrrk_VPMOVZXBDZrrkz_VPMOVZXBQZrr_VPMOVZXBQZrrk_VPMOVZXBQZrrkz_VPMOVZXBWZrr_VPMOVZXBWZrrk_VPMOVZXBWZrrkz_VPMOVZXDQZrr_VPMOVZXDQZrrk_VPMOVZXDQZrrkz_VPMOVZXWDZrr_VPMOVZXWDZrrk_VPMOVZXWDZrrkz_VPMOVZXWQZrr_VPMOVZXWQZrrk_VPMOVZXWQZrrkz") 1, false, false, false, 2605, 3,  1, 1,  0, 0}, // #1097
  {DBGFIELD("VPMOVDBZrr_VPMOVDBZrrk_VPMOVDBZrrkz_VPMOVQBZrr_VPMOVQBZrrk_VPMOVQBZrrkz_VPMOVQWZrr_VPMOVQWZrrk_VPMOVQWZrrkz_VPMOVSDBZrr_VPMOVSDBZrrk_VPMOVSDBZrrkz_VPMOVSQBZrr_VPMOVSQBZrrk_VPMOVSQBZrrkz_VPMOVSQWZrr_VPMOVSQWZrrk_VPMOVSQWZrrkz_VPMOVUSDBZrr_VPMOVUSDBZrrk_VPMOVUSDBZrrkz_VPMOVUSQBZrr_VPMOVUSQBZrrk_VPMOVUSQBZrrkz_VPMOVUSQWZrr_VPMOVUSQWZrrk_VPMOVUSQWZrrkz") 1, false, false, false, 2605, 3,  1, 1,  0, 0}, // #1098
  {DBGFIELD("VPTESTMBZ128rrk_VPTESTMDZ128rrk_VPTESTMQZ128rrk_VPTESTMWZ128rrk_VPTESTNMBZ128rrk_VPTESTNMDZ128rrk_VPTESTNMQZ128rrk_VPTESTNMWZ128rrk") 1, false, false, false, 2322, 3, 12, 1,  0, 0}, // #1099
  {DBGFIELD("VPTESTMBZ256rr_VPTESTMBZ256rrk_VPTESTMDZ256rr_VPTESTMDZ256rrk_VPTESTMQZ256rr_VPTESTMQZ256rrk_VPTESTMWZ256rr_VPTESTMWZ256rrk_VPTESTNMBZ256rr_VPTESTNMBZ256rrk_VPTESTNMDZ256rr_VPTESTNMDZ256rrk_VPTESTNMQZ256rr_VPTESTNMQZ256rrk_VPTESTNMWZ256rr_VPTESTNMWZ256rrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1100
  {DBGFIELD("VPTESTMBZrrk_VPTESTMDZrrk_VPTESTMQZrrk_VPTESTMWZrrk_VPTESTNMBZrrk_VPTESTNMDZrrk_VPTESTNMQZrrk_VPTESTNMWZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1101
  {DBGFIELD("VPCONFLICTDZ128rr_VPCONFLICTDZ128rrk_VPCONFLICTDZ128rrkz_VPCONFLICTQZ128rr_VPCONFLICTQZ128rrk_VPCONFLICTQZ128rrkz") 1, false, false, false, 2322, 3, 12, 1,  0, 0}, // #1102
  {DBGFIELD("VPCONFLICTDZ256rr_VPCONFLICTDZ256rrk_VPCONFLICTDZ256rrkz_VPCONFLICTQZ256rr_VPCONFLICTQZ256rrk_VPCONFLICTQZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1103
  {DBGFIELD("VPCONFLICTDZrr_VPCONFLICTDZrrk_VPCONFLICTDZrrkz_VPCONFLICTQZrr_VPCONFLICTQZrrk_VPCONFLICTQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1104
  {DBGFIELD("VRSQRT14PDZ128r_VRSQRT14PDZ128rk_VRSQRT14PDZ128rkz_VRSQRT14PSZ128r_VRSQRT14PSZ128rk_VRSQRT14PSZ128rkz") 1, false, false, false, 2625, 4, 10, 1,  0, 0}, // #1105
  {DBGFIELD("VRSQRT14PDZ256r_VRSQRT14PDZ256rk_VRSQRT14PDZ256rkz_VRSQRT14PSZ256r_VRSQRT14PSZ256rk_VRSQRT14PSZ256rkz") 2, false, false, false, 2858, 4, 10, 1,  0, 0}, // #1106
  {DBGFIELD("VRSQRT14PDZr_VRSQRT14PDZrk_VRSQRT14PDZrkz_VRSQRT14PSZr_VRSQRT14PSZrk_VRSQRT14PSZrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1107
  {DBGFIELD("VPERMILPDYrr_VPERMILPDZ256rr_VPERMILPDZ256rrk_VPERMILPDZ256rrkz_VPERMILPSYrr_VPERMILPSZ256rr_VPERMILPSZ256rrk_VPERMILPSZ256rrkz") 2, false, false, false, 2734, 4,  5, 1,  0, 0}, // #1108
  {DBGFIELD("VPERMILPDZ128rr_VPERMILPDZ128rrk_VPERMILPDZ128rrkz_VPERMILPSZ128rr_VPERMILPSZ128rrk_VPERMILPSZ128rrkz") 1, false, false, false, 2391, 4,  5, 1,  0, 0}, // #1109
  {DBGFIELD("VPERMILPDZrr_VPERMILPDZrrk_VPERMILPDZrrkz_VPERMILPSZrr_VPERMILPSZrrk_VPERMILPSZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1110
  {DBGFIELD("VPERMI2PD128rr_VPERMI2PD128rrk_VPERMI2PD128rrkz_VPERMI2PS128rr_VPERMI2PS128rrk_VPERMI2PS128rrkz_VPERMT2PD128rr_VPERMT2PD128rrk_VPERMT2PD128rrkz_VPERMT2PS128rr_VPERMT2PS128rrk_VPERMT2PS128rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1111
  {DBGFIELD("VPERMI2W128rr_VPERMI2W128rrk_VPERMI2W128rrkz_VPERMT2W128rr_VPERMT2W128rrk_VPERMT2W128rrkz_VPERMI2B128rr_VPERMI2B128rrk_VPERMI2B128rrkz_VPERMI2D128rr_VPERMI2D128rrk_VPERMI2D128rrkz_VPERMI2Q128rr_VPERMI2Q128rrk_VPERMI2Q128rrkz_VPERMT2B128rr_VPERMT2B128rrk_VPERMT2B128rrkz_VPERMT2D128rr_VPERMT2D128rrk_VPERMT2D128rrkz_VPERMT2Q128rr_VPERMT2Q128rrk_VPERMT2Q128rrkz") 1, false, false, false, 2605, 3,  1, 1,  0, 0}, // #1112
  {DBGFIELD("VCOMPRESSPDZ128rr_VCOMPRESSPDZ128rrk_VCOMPRESSPDZ128rrkz_VCOMPRESSPSZ128rr_VCOMPRESSPSZ128rrk_VCOMPRESSPSZ128rrkz_VPCOMPRESSBZ128rr_VPCOMPRESSBZ128rrk_VPCOMPRESSBZ128rrkz_VPCOMPRESSDZ128rr_VPCOMPRESSDZ128rrk_VPCOMPRESSDZ128rrkz_VPCOMPRESSQZ128rr_VPCOMPRESSQZ128rrk_VPCOMPRESSQZ128rrkz_VPCOMPRESSWZ128rr_VPCOMPRESSWZ128rrk_VPCOMPRESSWZ128rrkz_VPERMBZ128rr_VPERMBZ128rrk_VPERMBZ128rrkz_VPERMWZ128rr_VPERMWZ128rrk_VPERMWZ128rrkz") 1, false, false, false, 2605, 3,  1, 1,  0, 0}, // #1113
  {DBGFIELD("VPERMI2PD256rr_VPERMI2PD256rrk_VPERMI2PD256rrkz_VPERMI2PS256rr_VPERMI2PS256rrk_VPERMI2PS256rrkz_VPERMT2PD256rr_VPERMT2PD256rrk_VPERMT2PD256rrkz_VPERMT2PS256rr_VPERMT2PS256rrk_VPERMT2PS256rrkz_VPERMPDZ256rr_VPERMPDZ256rrk_VPERMPDZ256rrkz_VPERMPSZ256rr_VPERMPSZ256rrk_VPERMPSZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1114
  {DBGFIELD("VPERMI2W256rr_VPERMI2W256rrk_VPERMI2W256rrkz_VPERMT2W256rr_VPERMT2W256rrk_VPERMT2W256rrkz_VCOMPRESSPDZ256rr_VCOMPRESSPDZ256rrk_VCOMPRESSPDZ256rrkz_VCOMPRESSPSZ256rr_VCOMPRESSPSZ256rrk_VCOMPRESSPSZ256rrkz_VPCOMPRESSBZ256rr_VPCOMPRESSBZ256rrk_VPCOMPRESSBZ256rrkz_VPCOMPRESSDZ256rr_VPCOMPRESSDZ256rrk_VPCOMPRESSDZ256rrkz_VPCOMPRESSQZ256rr_VPCOMPRESSQZ256rrk_VPCOMPRESSQZ256rrkz_VPCOMPRESSWZ256rr_VPCOMPRESSWZ256rrk_VPCOMPRESSWZ256rrkz_VPERMBZ256rr_VPERMBZ256rrk_VPERMBZ256rrkz_VPERMDZ256rr_VPERMDZ256rrk_VPERMDZ256rrkz_VPERMQZ256rr_VPERMQZ256rrk_VPERMQZ256rrkz_VPERMWZ256rr_VPERMWZ256rrk_VPERMWZ256rrkz_VPERMI2B256rr_VPERMI2B256rrk_VPERMI2B256rrkz_VPERMI2D256rr_VPERMI2D256rrk_VPERMI2D256rrkz_VPERMI2Q256rr_VPERMI2Q256rrk_VPERMI2Q256rrkz_VPERMT2B256rr_VPERMT2B256rrk_VPERMT2B256rrkz_VPERMT2D256rr_VPERMT2D256rrk_VPERMT2D256rrkz_VPERMT2Q256rr_VPERMT2Q256rrk_VPERMT2Q256rrkz_VPEXPANDBZ256rr_VPEXPANDBZ256rrk_VPEXPANDBZ256rrkz_VPEXPANDWZ256rr_VPEXPANDWZ256rrk_VPEXPANDWZ256rrkz") 1, false, false, false, 2605, 3,  1, 1,  0, 0}, // #1115
  {DBGFIELD("VPERMI2PDrr_VPERMI2PDrrk_VPERMI2PDrrkz_VPERMI2PSrr_VPERMI2PSrrk_VPERMI2PSrrkz_VPERMT2PDrr_VPERMT2PDrrk_VPERMT2PDrrkz_VPERMT2PSrr_VPERMT2PSrrk_VPERMT2PSrrkz_VPERMPDZrr_VPERMPDZrrk_VPERMPDZrrkz_VPERMPSZrr_VPERMPSZrrk_VPERMPSZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1116
  {DBGFIELD("VPERMI2Wrr_VPERMI2Wrrk_VPERMI2Wrrkz_VPERMT2Wrr_VPERMT2Wrrk_VPERMT2Wrrkz_VPERMBZrr_VPERMBZrrk_VPERMBZrrkz_VPERMDZrr_VPERMDZrrk_VPERMDZrrkz_VPERMWZrr_VPERMWZrrk_VPERMWZrrkz_VPERMI2Brr_VPERMI2Brrk_VPERMI2Brrkz_VPERMI2Drr_VPERMI2Drrk_VPERMI2Drrkz_VPERMI2Qrr_VPERMI2Qrrk_VPERMI2Qrrkz_VPERMT2Brr_VPERMT2Brrk_VPERMT2Brrkz_VPERMT2Drr_VPERMT2Drrk_VPERMT2Drrkz_VPERMT2Qrr_VPERMT2Qrrk_VPERMT2Qrrkz_VCOMPRESSPDZrr_VCOMPRESSPDZrrk_VCOMPRESSPDZrrkz_VCOMPRESSPSZrr_VCOMPRESSPSZrrk_VCOMPRESSPSZrrkz_VPCOMPRESSBZrr_VPCOMPRESSBZrrk_VPCOMPRESSBZrrkz_VPCOMPRESSDZrr_VPCOMPRESSDZrrk_VPCOMPRESSDZrrkz_VPCOMPRESSQZrr_VPCOMPRESSQZrrk_VPCOMPRESSQZrrkz_VPCOMPRESSWZrr_VPCOMPRESSWZrrk_VPCOMPRESSWZrrkz_VPEXPANDBZrr_VPEXPANDBZrrk_VPEXPANDBZrrkz_VPEXPANDWZrr_VPEXPANDWZrrk_VPEXPANDWZrrkz") 1, false, false, false, 2605, 3,  1, 1,  0, 0}, // #1117
  {DBGFIELD("VPABSBZ128rr_VPABSBZ128rrk_VPABSBZ128rrkz_VPABSDZ128rr_VPABSDZ128rrk_VPABSDZ128rrkz_VPABSQZ128rr_VPABSQZ128rrk_VPABSQZ128rrkz_VPABSWZ128rr_VPABSWZ128rrk_VPABSWZ128rrkz_VPADDSBZ128rr_VPADDSBZ128rrk_VPADDSBZ128rrkz_VPADDSWZ128rr_VPADDSWZ128rrk_VPADDSWZ128rrkz_VPADDUSBZ128rr_VPADDUSBZ128rrk_VPADDUSBZ128rrkz_VPADDUSWZ128rr_VPADDUSWZ128rrk_VPADDUSWZ128rrkz_VPAVGBZ128rr_VPAVGBZ128rrk_VPAVGBZ128rrkz_VPAVGWZ128rr_VPAVGWZ128rrk_VPAVGWZ128rrkz_VPOPCNTBZ128rr_VPOPCNTBZ128rrk_VPOPCNTBZ128rrkz_VPOPCNTDZ128rr_VPOPCNTDZ128rrk_VPOPCNTDZ128rrkz_VPOPCNTQZ128rr_VPOPCNTQZ128rrk_VPOPCNTQZ128rrkz_VPOPCNTWZ128rr_VPOPCNTWZ128rrk_VPOPCNTWZ128rrkz_VPSUBSBZ128rr_VPSUBSBZ128rrk_VPSUBSBZ128rrkz_VPSUBSWZ128rr_VPSUBSWZ128rrk_VPSUBSWZ128rrkz_VPSUBUSBZ128rr_VPSUBUSBZ128rrk_VPSUBUSBZ128rrkz_VPSUBUSWZ128rr_VPSUBUSWZ128rrk_VPSUBUSWZ128rrkz") 1, false, false, false, 2322, 3, 12, 1,  0, 0}, // #1118
  {DBGFIELD("LSL16rr_LSL32rr_LSL64rr") 45, false, false, false, 2912, 2, 123, 1,  0, 0}, // #1119
  {DBGFIELD("LXADD8_LXADD16_LXADD32_LXADD64") 4, false, false, false, 2926, 2,  3, 1,  0, 0}, // #1120
  {DBGFIELD("BLCFILL32rr_BLCFILL64rr_BLCI32rr_BLCI64rr_BLCIC32rr_BLCIC64rr_BLCMSK32rr_BLCMSK64rr_BLCS32rr_BLCS64rr_BLSFILL32rr_BLSFILL64rr_BLSIC32rr_BLSIC64rr_T1MSKC32rr_T1MSKC64rr_TZMSK32rr_TZMSK64rr") 2, false, false, false, 2320, 2, 12, 1,  0, 0}, // #1121
  {DBGFIELD("BLCFILL32rm_BLCFILL64rm_BLCI32rm_BLCI64rm_BLCIC32rm_BLCIC64rm_BLCMSK32rm_BLCMSK64rm_BLCS32rm_BLCS64rm_BLSFILL32rm_BLSFILL64rm_BLSIC32rm_BLSIC64rm_T1MSKC32rm_T1MSKC64rm_TZMSK32rm_TZMSK64rm") 2, false, false, false, 2928, 4,  3, 1,  0, 0}, // #1122
  {DBGFIELD("ADC64ri32_SBB64ri32") 1, false, false, false, 2922, 2,  1, 1,  0, 0}, // #1123
  {DBGFIELD("CRC32r32r16")        5, false, false, false, 2932, 2, 10, 1,  0, 0}, // #1124
  {DBGFIELD("CRC32r32r32")        7, false, false, false, 2934, 2,  3, 1,  0, 0}, // #1125
  {DBGFIELD("CRC32r64r64")        11, false, false, false, 2936, 2,  9, 1,  0, 0}, // #1126
  {DBGFIELD("SAHF")               2, false, false, false, 2320, 2, 12, 1,  0, 0}, // #1127
  {DBGFIELD("BEXTRI32ri_BEXTRI64ri") 2, false, false, false, 2435, 2, 12, 1,  0, 0}, // #1128
  {DBGFIELD("BEXTRI32mi_BEXTRI64mi") 2, false, false, false, 2938, 2, 12, 1,  0, 0}, // #1129
  {DBGFIELD("RCR8ri")             23, false, false, false, 2940, 2,  2, 1,  0, 0}, // #1130
  {DBGFIELD("RCL16rCL")           22, false, false, false, 2942, 2,  9, 1,  0, 0}, // #1131
  {DBGFIELD("RCR16ri")            19, false, false, false, 2944, 2,  9, 1,  0, 0}, // #1132
  {DBGFIELD("RCR32rCL_RCR64rCL")  16, false, false, false, 2946, 2,  6, 1,  0, 0}, // #1133
  {DBGFIELD("RCL16ri")            21, false, false, false, 2948, 2,  8, 1,  0, 0}, // #1134
  {DBGFIELD("RCL32ri_RCL64ri")    16, false, false, false, 2950, 2,  7, 1,  0, 0}, // #1135
  {DBGFIELD("SHLD16rrCL")         7, false, false, false, 2343, 2,  5, 1,  0, 0}, // #1136
  {DBGFIELD("VMOVUPDYmr_VMOVUPSYmr") 8, false, false, false, 2599, 6,  1, 1,  0, 0}, // #1137
  {DBGFIELD("TST_F")              1, false, false, false, 2625, 4,  1, 1,  0, 0}, // #1138
  {DBGFIELD("VDPPSrri")           17, false, false, false, 2494, 4, 59, 1,  0, 0}, // #1139
  {DBGFIELD("VFRCZPDrr_VFRCZPSrr") 2, false, false, false, 2502, 4,  9, 1,  0, 0}, // #1140
  {DBGFIELD("VFRCZSDrr_VFRCZSSrr") 2, false, false, false, 2952, 4,  9, 1,  0, 0}, // #1141
  {DBGFIELD("VFRCZPDrm_VFRCZPSrm_VFRCZSDrm_VFRCZSSrm") 3, false, false, false, 2502, 4, 11, 1,  0, 0}, // #1142
  {DBGFIELD("VFRCZPSYrr_VFRCZPDYrr") 4, false, false, false, 2956, 4,  9, 1,  0, 0}, // #1143
  {DBGFIELD("VFRCZPSYrm_VFRCZPDYrm") 8, false, false, false, 2960, 4, 11, 1,  0, 0}, // #1144
  {DBGFIELD("MMX_CVTTPD2PIrr")    2, false, false, false, 2439, 5,  3, 1,  0, 0}, // #1145
  {DBGFIELD("CVTSI2SSrr")         2, false, false, false, 2871, 5, 24, 1,  0, 0}, // #1146
  {DBGFIELD("VMOVDQUYmr")         8, false, false, false, 2599, 6,  1, 1,  0, 0}, // #1147
  {DBGFIELD("MOVDQArr")           1, false, false, false, 2605, 3,  1, 1,  0, 0}, // #1148
  {DBGFIELD("VPMACSDQHrr_VPMACSDQLrr_VPMACSSDQHrr_VPMACSSDQLrr") 1, false, false, false, 2964, 5, 14, 1,  0, 0}, // #1149
  {DBGFIELD("VPPERMrrr_VPPERMrrr_REV") 1, false, false, false, 2391, 4, 12, 1,  0, 0}, // #1150
  {DBGFIELD("VPPERMrrm")          1, false, false, false, 2390, 6,  6, 1,  0, 0}, // #1151
  {DBGFIELD("VPPERMrmr")          1, false, false, false, 2390, 6,  6, 1,  0, 0}, // #1152
  {DBGFIELD("PHADDWrr_PHSUBWrr_PHADDSWrr_PHSUBSWrr_VPHADDDrr_VPHSUBDrr_VPHADDWrr_VPHSUBWrr_VPHADDSWrr_VPHSUBSWrr") 3, false, false, false, 2609, 3, 10, 1,  0, 0}, // #1153
  {DBGFIELD("PHADDWrm_PHSUBWrm_PHADDSWrm_PHSUBSWrm_VPHADDDrm_VPHSUBDrm_VPHADDWrm_VPHSUBWrm_VPHADDSWrm_VPHSUBSWrm") 4, false, false, false, 2608, 5,  9, 1,  0, 0}, // #1154
  {DBGFIELD("VPCLMULQDQrr")       6, false, false, false, 2631, 4,  2, 1,  0, 0}, // #1155
  {DBGFIELD("ANDNPSrr_ANDNPDrr")  8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #1156
  {DBGFIELD("MMX_PXORrr_MMX_PANDNrr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #1157
  {DBGFIELD("PANDNrr")            8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #1158
  {DBGFIELD("MMX_PSUBBrr_MMX_PSUBDrr_MMX_PSUBWrr_MMX_PCMPGTBrr_MMX_PCMPGTDrr_MMX_PCMPGTWrr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #1159
  {DBGFIELD("LCMPXCHG16_LCMPXCHG32_LCMPXCHG64") 2, false, false, false, 2329, 6,  5, 1,  0, 0}, // #1160
  {DBGFIELD("CMPXCHG16rr_CMPXCHG32rr_CMPXCHG64rr") 5, false, false, false, 2422, 3,  5, 1,  0, 0}, // #1161
  {DBGFIELD("LCMPXCHG8B")         2, false, false, false, 2329, 6,  5, 1,  0, 0}, // #1162
  {DBGFIELD("XCHG8rr")            2, false, false, false, 11, 3,  1, 1,  0, 0}, // #1163
  {DBGFIELD("MMX_PSUBSBrr_MMX_PSUBSWrr_MMX_PSUBUSBrr_MMX_PSUBUSWrr") 1, false, false, false, 2322, 3, 12, 1,  0, 0}, // #1164
  {DBGFIELD("PSUBSBrr_VPSUBSBrr_PSUBSWrr_VPSUBSWrr_PSUBUSBrr_VPSUBUSBrr_PSUBUSWrr_VPSUBUSWrr") 1, false, false, false, 2322, 3, 12, 1,  0, 0}, // #1165
  {DBGFIELD("MMX_PCMPEQBrr_MMX_PCMPEQDrr_MMX_PCMPEQWrr_MMX_PMAXSWrr_MMX_PMINSWrr_MMX_PMAXUBrr_MMX_PMINUBrr") 1, false, false, false, 2322, 3, 12, 1,  0, 0}, // #1166
  {DBGFIELD("MMX_PCMPGTBrr_MMX_PCMPGTDrr_MMX_PCMPGTWrr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #1167
  {DBGFIELD("CLAC_STAC")          1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #1168
  {DBGFIELD("PADDBrr_PADDDrr_PADDWrr_VPADDBrr_VPADDDrr_VPADDQrr_VPADDWrr") 1, false, false, false, 2322, 3, 12, 1,  0, 0}, // #1169
  {DBGFIELD("VPADDBYrr_VPADDDYrr_VPADDQYrr_VPADDWYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1170
  {DBGFIELD("ADD_FPrST0_ADD_FST0r_ADD_FrST0_SUBR_FPrST0_SUBR_FST0r_SUBR_FrST0_SUB_FPrST0_SUB_FST0r_SUB_FrST0") 1, false, false, false, 2374, 4, 10, 1,  0, 0}, // #1171
  {DBGFIELD("MMX_PHADDSWrr_MMX_PHSUBSWrr") 3, false, false, false, 2609, 3, 10, 1,  0, 0}, // #1172
  {DBGFIELD("PHADDSWrr_VPHADDSWrr_PHSUBSWrr_VPHSUBSWrr") 3, false, false, false, 2609, 3, 10, 1,  0, 0}, // #1173
  {DBGFIELD("VPHADDSWYrr_VPHSUBSWYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1174
  {DBGFIELD("MMX_PADDSBrm_MMX_PADDSWrm_MMX_PADDUSBrm_MMX_PADDUSWrm_MMX_PAVGBrm_MMX_PAVGWrm_MMX_PCMPEQBrm_MMX_PCMPEQDrm_MMX_PCMPEQWrm_MMX_PCMPGTBrm_MMX_PCMPGTDrm_MMX_PCMPGTWrm_MMX_PMAXSWrm_MMX_PMAXUBrm_MMX_PMINSWrm_MMX_PMINUBrm_MMX_PSUBSBrm_MMX_PSUBSWrm_MMX_PSUBUSBrm_MMX_PSUBUSWrm") 1, false, false, false, 2385, 5,  6, 1,  3, 1}, // #1175
  {DBGFIELD("PADDBrm_PADDDrm_PADDWrm_VPADDBrm_VPADDDrm_VPADDQrm_VPADDWrm_PSUBBrm_PSUBDrm_PSUBWrm_VPSUBBrm_VPSUBDrm_VPSUBQrm_VPSUBWrm") 1, false, false, false, 2385, 5,  6, 1,  3, 1}, // #1176
  {DBGFIELD("VCVTSS2SI64rr_VCVTTSS2SI64rr") 2, false, false, false, 2446, 9, 24, 1,  0, 0}, // #1177
  {DBGFIELD("VCVTSS2SI64rr_Int_VCVTTSS2SI64rr_Int") 2, false, false, false, 2446, 9, 24, 1,  0, 0}, // #1178
  {DBGFIELD("VPADDBYrm_VPADDDYrm_VPADDQYrm_VPADDWYrm_VPSUBBYrm_VPSUBDYrm_VPSUBQYrm_VPSUBWYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1179
  {DBGFIELD("MMX_PHADDSWrm_MMX_PHSUBSWrm") 4, false, false, false, 2608, 5,  9, 1,  3, 1}, // #1180
  {DBGFIELD("PHADDSWrm_VPHADDSWrm_PHSUBSWrm_VPHSUBSWrm") 4, false, false, false, 2608, 5,  9, 1,  0, 0}, // #1181
  {DBGFIELD("VPHADDSWYrm_VPHSUBSWYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1182
  {DBGFIELD("XSAVEC_XSAVEC64_XSAVES_XSAVES64") 1, false, false, false, 2341, 2,  4, 1,  0, 0}, // #1183
  {DBGFIELD("PCMPGTBrr_PCMPGTDrr_PCMPGTWrr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #1184
  {DBGFIELD("VPCMPGTBrr_VPCMPGTDrr_VPCMPGTWrr") 8190, false, false, false,  0, 0,  0, 0,  0, 0}, // #1185
  {DBGFIELD("VPCMPGTBYrr_VPCMPGTDYrr_VPCMPGTWYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1186
  {DBGFIELD("KANDBrr_KANDDrr_KANDQrr_KANDWrr_KANDNBrr_KANDNDrr_KANDNQrr_KANDNWrr_KNOTBrr_KNOTDrr_KNOTQrr_KNOTWrr_KORBrr_KORDrr_KORQrr_KORWrr_KXNORBrr_KXNORDrr_KXNORQrr_KXNORWrr_KXORBrr_KXORDrr_KXORQrr_KXORWrr") 1, false, false, false, 2322, 3, 12, 1,  0, 0}, // #1187
  {DBGFIELD("KMOVBkk_KMOVDkk_KMOVQkk_KMOVWkk") 1, false, false, false, 2320, 2,  1, 1,  0, 0}, // #1188
  {DBGFIELD("KSET0D_KSET0Q_KSET0W_KSET1D_KSET1Q_KSET1W") 1, false, false, false,  0, 0,  1, 1,  0, 0}, // #1189
  {DBGFIELD("VPMOVB2MZ128rr_VPMOVB2MZ256rr_VPMOVB2MZrr_VPMOVD2MZ128rr_VPMOVD2MZ256rr_VPMOVD2MZrr_VPMOVQ2MZ128rr_VPMOVQ2MZ256rr_VPMOVQ2MZrr_VPMOVW2MZ128rr_VPMOVW2MZ256rr_VPMOVW2MZrr") 1, false, false, false, 2320, 2,  1, 1,  0, 0}, // #1190
  {DBGFIELD("VBLENDMPDZ128rr_VBLENDMPDZ128rrk_VBLENDMPDZ128rrkz_VBLENDMPSZ128rr_VBLENDMPSZ128rrk_VBLENDMPSZ128rrkz") 1, false, false, false, 2391, 4, 12, 1,  0, 0}, // #1191
  {DBGFIELD("VBLENDMPDZ256rr_VBLENDMPDZ256rrk_VBLENDMPDZ256rrkz_VBLENDMPSZ256rr_VBLENDMPSZ256rrk_VBLENDMPSZ256rrkz") 2, false, false, false, 2734, 4, 12, 1,  0, 0}, // #1192
  {DBGFIELD("VPADDBZ128rr_VPADDBZ128rrk_VPADDBZ128rrkz_VPADDDZ128rr_VPADDDZ128rrk_VPADDDZ128rrkz_VPADDQZ128rr_VPADDQZ128rrk_VPADDQZ128rrkz_VPADDWZ128rr_VPADDWZ128rrk_VPADDWZ128rrkz_VPSUBBZ128rrk_VPSUBBZ128rrkz_VPSUBDZ128rrk_VPSUBDZ128rrkz_VPSUBQZ128rrk_VPSUBQZ128rrkz_VPSUBWZ128rrk_VPSUBWZ128rrkz_VPTERNLOGDZ128rri_VPTERNLOGDZ128rrik_VPTERNLOGDZ128rrikz_VPTERNLOGQZ128rri_VPTERNLOGQZ128rrik_VPTERNLOGQZ128rrikz") 1, false, false, false, 2322, 3, 12, 1,  0, 0}, // #1193
  {DBGFIELD("VPADDBZ256rr_VPADDBZ256rrk_VPADDBZ256rrkz_VPADDDZ256rr_VPADDDZ256rrk_VPADDDZ256rrkz_VPADDQZ256rr_VPADDQZ256rrk_VPADDQZ256rrkz_VPADDWZ256rr_VPADDWZ256rrk_VPADDWZ256rrkz_VPSUBBZ256rrk_VPSUBBZ256rrkz_VPSUBDZ256rrk_VPSUBDZ256rrkz_VPSUBQZ256rrk_VPSUBQZ256rrkz_VPSUBWZ256rrk_VPSUBWZ256rrkz_VPTERNLOGDZ256rri_VPTERNLOGDZ256rrik_VPTERNLOGDZ256rrikz_VPTERNLOGQZ256rri_VPTERNLOGQZ256rrik_VPTERNLOGQZ256rrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1194
  {DBGFIELD("VPADDBZrr_VPADDBZrrk_VPADDBZrrkz_VPADDDZrr_VPADDDZrrk_VPADDDZrrkz_VPADDQZrr_VPADDQZrrk_VPADDQZrrkz_VPADDWZrr_VPADDWZrrk_VPADDWZrrkz_VPSUBBZrrk_VPSUBBZrrkz_VPSUBDZrrk_VPSUBDZrrkz_VPSUBQZrrk_VPSUBQZrrkz_VPSUBWZrrk_VPSUBWZrrkz_VPTERNLOGDZrri_VPTERNLOGDZrrik_VPTERNLOGDZrrikz_VPTERNLOGQZrri_VPTERNLOGQZrrik_VPTERNLOGQZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1195
  {DBGFIELD("VPBLENDMBZ128rr_VPBLENDMBZ128rrk_VPBLENDMBZ128rrkz_VPBLENDMDZ128rr_VPBLENDMDZ128rrk_VPBLENDMDZ128rrkz_VPBLENDMQZ128rr_VPBLENDMQZ128rrk_VPBLENDMQZ128rrkz_VPBLENDMWZ128rr_VPBLENDMWZ128rrk_VPBLENDMWZ128rrkz") 1, false, false, false, 2391, 4, 12, 1,  0, 0}, // #1196
  {DBGFIELD("VPBLENDMBZ256rr_VPBLENDMBZ256rrk_VPBLENDMBZ256rrkz_VPBLENDMDZ256rr_VPBLENDMDZ256rrk_VPBLENDMDZ256rrkz_VPBLENDMQZ256rr_VPBLENDMQZ256rrk_VPBLENDMQZ256rrkz_VPBLENDMWZ256rr_VPBLENDMWZ256rrk_VPBLENDMWZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1197
  {DBGFIELD("VMOVDQU8Zmr_VMOVDQU8Zmrk") 4, false, false, false, 2824, 5,  1, 1,  0, 0}, // #1198
  {DBGFIELD("KORTESTBrr_KORTESTDrr_KORTESTQrr_KORTESTWrr_KTESTBrr_KTESTDrr_KTESTQrr_KTESTWrr") 1, false, false, false, 2322, 3, 12, 1,  0, 0}, // #1199
  {DBGFIELD("VALIGNDZ128rrik_VALIGNDZ128rrikz_VALIGNQZ128rrik_VALIGNQZ128rrikz") 1, false, false, false, 2391, 4, 12, 1,  0, 0}, // #1200
  {DBGFIELD("VALIGNDZ256rrik_VALIGNDZ256rrikz_VALIGNQZ256rrik_VALIGNQZ256rrikz") 2, false, false, false, 2734, 4, 12, 1,  0, 0}, // #1201
  {DBGFIELD("VALIGNDZrrik_VALIGNDZrrikz_VALIGNQZrrik_VALIGNQZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1202
  {DBGFIELD("KSHIFTLBri_KSHIFTLDri_KSHIFTLQri_KSHIFTLWri_KSHIFTRBri_KSHIFTRDri_KSHIFTRQri_KSHIFTRWri") 1, false, false, false, 2391, 4, 12, 1,  0, 0}, // #1203
  {DBGFIELD("VCMPPDZ128rri_VCMPPDZ128rrik_VCMPPSZ128rri_VCMPPSZ128rrik_VFPCLASSPDZ128rr_VFPCLASSPDZ128rrk_VFPCLASSPSZ128rr_VFPCLASSPSZ128rrk") 1, false, false, false, 2374, 4, 12, 1,  0, 0}, // #1204
  {DBGFIELD("VCMPPDZ256rri_VCMPPDZ256rrik_VCMPPSZ256rri_VCMPPSZ256rrik_VFPCLASSPDZ256rr_VFPCLASSPDZ256rrk_VFPCLASSPSZ256rr_VFPCLASSPSZ256rrk") 2, false, false, false, 2728, 4, 12, 1,  0, 0}, // #1205
  {DBGFIELD("VCMPPDZrri_VCMPPDZrrib_VCMPPDZrribk_VCMPPDZrrik_VCMPPSZrri_VCMPPSZrrib_VCMPPSZrribk_VCMPPSZrrik_VFPCLASSPDZrr_VFPCLASSPDZrrk_VFPCLASSPSZrr_VFPCLASSPSZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1206
  {DBGFIELD("VCMPSDZrr_VCMPSDZrr_Int_VCMPSDZrr_Intk_VCMPSDZrrb_Int_VCMPSDZrrb_Intk_VCMPSSZrr_VCMPSSZrr_Int_VCMPSSZrr_Intk_VCMPSSZrrb_Int_VCMPSSZrrb_Intk_VFPCLASSSDZrr_VFPCLASSSDZrrk_VFPCLASSSSZrr_VFPCLASSSSZrrk") 1, false, false, false, 2374, 4, 12, 1,  0, 0}, // #1207
  {DBGFIELD("VPCMPBZ128rri_VPCMPBZ128rrik_VPCMPDZ128rri_VPCMPDZ128rrik_VPCMPEQBZ128rr_VPCMPEQBZ128rrk_VPCMPEQDZ128rr_VPCMPEQDZ128rrk_VPCMPEQQZ128rr_VPCMPEQQZ128rrk_VPCMPEQWZ128rr_VPCMPEQWZ128rrk_VPCMPGTBZ128rr_VPCMPGTBZ128rrk_VPCMPGTDZ128rr_VPCMPGTDZ128rrk_VPCMPGTQZ128rr_VPCMPGTQZ128rrk_VPCMPGTWZ128rr_VPCMPGTWZ128rrk_VPCMPQZ128rri_VPCMPQZ128rrik_VPCMPUBZ128rri_VPCMPUBZ128rrik_VPCMPUDZ128rri_VPCMPUDZ128rrik_VPCMPUQZ128rri_VPCMPUQZ128rrik_VPCMPUWZ128rri_VPCMPUWZ128rrik_VPCMPWZ128rri_VPCMPWZ128rrik") 1, false, false, false, 2322, 3, 12, 1,  0, 0}, // #1208
  {DBGFIELD("VPCMPBZ256rri_VPCMPBZ256rrik_VPCMPDZ256rri_VPCMPDZ256rrik_VPCMPEQBZ256rr_VPCMPEQBZ256rrk_VPCMPEQDZ256rr_VPCMPEQDZ256rrk_VPCMPEQQZ256rr_VPCMPEQQZ256rrk_VPCMPEQWZ256rr_VPCMPEQWZ256rrk_VPCMPGTBZ256rr_VPCMPGTBZ256rrk_VPCMPGTDZ256rr_VPCMPGTDZ256rrk_VPCMPGTQZ256rr_VPCMPGTQZ256rrk_VPCMPGTWZ256rr_VPCMPGTWZ256rrk_VPCMPQZ256rri_VPCMPQZ256rrik_VPCMPUBZ256rri_VPCMPUBZ256rrik_VPCMPUDZ256rri_VPCMPUDZ256rrik_VPCMPUQZ256rri_VPCMPUQZ256rrik_VPCMPUWZ256rri_VPCMPUWZ256rrik_VPCMPWZ256rri_VPCMPWZ256rrik") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1209
  {DBGFIELD("VPCMPBZrri_VPCMPBZrrik_VPCMPDZrri_VPCMPDZrrik_VPCMPEQBZrr_VPCMPEQBZrrk_VPCMPEQDZrr_VPCMPEQDZrrk_VPCMPEQQZrr_VPCMPEQQZrrk_VPCMPEQWZrr_VPCMPEQWZrrk_VPCMPGTBZrr_VPCMPGTBZrrk_VPCMPGTDZrr_VPCMPGTDZrrk_VPCMPGTQZrr_VPCMPGTQZrrk_VPCMPGTWZrr_VPCMPGTWZrrk_VPCMPQZrri_VPCMPQZrrik_VPCMPUBZrri_VPCMPUBZrrik_VPCMPUDZrri_VPCMPUDZrrik_VPCMPUQZrri_VPCMPUQZrrik_VPCMPUWZrri_VPCMPUWZrrik_VPCMPWZrri_VPCMPWZrrik") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1210
  {DBGFIELD("VPTESTMBZ128rr_VPTESTMDZ128rr_VPTESTMQZ128rr_VPTESTMWZ128rr_VPTESTNMBZ128rr_VPTESTNMDZ128rr_VPTESTNMQZ128rr_VPTESTNMWZ128rr") 1, false, false, false, 2322, 3, 12, 1,  0, 0}, // #1211
  {DBGFIELD("VPTESTMBZrr_VPTESTMDZrr_VPTESTMQZrr_VPTESTMWZrr_VPTESTNMBZrr_VPTESTNMDZrr_VPTESTNMQZrr_VPTESTNMWZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1212
  {DBGFIELD("VCVTPD2QQZ128rr_VCVTPD2QQZ128rrk_VCVTPD2QQZ128rrkz_VCVTPD2UQQZ128rr_VCVTPD2UQQZ128rrk_VCVTPD2UQQZ128rrkz_VCVTTPD2QQZ128rr_VCVTTPD2QQZ128rrk_VCVTTPD2QQZ128rrkz_VCVTTPD2UQQZ128rr_VCVTTPD2UQQZ128rrk_VCVTTPD2UQQZ128rrkz") 2, false, false, false, 2439, 5,  7, 1,  0, 0}, // #1213
  {DBGFIELD("VCVTPD2QQZ256rr_VCVTPD2QQZ256rrk_VCVTPD2QQZ256rrkz_VCVTPD2UQQZ256rr_VCVTPD2UQQZ256rrk_VCVTPD2UQQZ256rrkz_VCVTTPD2QQZ256rr_VCVTTPD2QQZ256rrk_VCVTTPD2QQZ256rrkz_VCVTTPD2UQQZ256rr_VCVTTPD2UQQZ256rrk_VCVTTPD2UQQZ256rrkz") 4, false, false, false, 2750, 6,  7, 1,  0, 0}, // #1214
  {DBGFIELD("VCVTPS2DQYrr_VCVTPS2DQZ256rr_VCVTPS2DQZ256rrk_VCVTPS2DQZ256rrkz_VCVTPS2UDQZ256rr_VCVTPS2UDQZ256rrk_VCVTPS2UDQZ256rrkz_VCVTTPS2DQZ256rr_VCVTTPS2DQZ256rrk_VCVTTPS2DQZ256rrkz_VCVTTPS2UDQZ256rr_VCVTTPS2UDQZ256rrk_VCVTTPS2UDQZ256rrkz") 2, false, false, false, 2457, 5, 14, 1,  0, 0}, // #1215
  {DBGFIELD("VCVTPS2DQZ128rr_VCVTPS2DQZ128rrk_VCVTPS2DQZ128rrkz_VCVTPS2UDQZ128rr_VCVTPS2UDQZ128rrk_VCVTPS2UDQZ128rrkz_VCVTTPS2DQZ128rr_VCVTTPS2DQZ128rrk_VCVTTPS2DQZ128rrkz_VCVTTPS2UDQZ128rr_VCVTTPS2UDQZ128rrk_VCVTTPS2UDQZ128rrkz") 1, false, false, false, 2439, 5, 14, 1,  0, 0}, // #1216
  {DBGFIELD("VCVTPD2QQZrr_VCVTPD2UQQZrr_VCVTTPD2QQZrr_VCVTTPD2UQQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1217
  {DBGFIELD("VCVTPS2DQZrr_VCVTPS2UDQZrr_VCVTTPS2DQZrr_VCVTTPS2UDQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1218
  {DBGFIELD("VEXPANDPDZ128rr_VEXPANDPDZ128rrk_VEXPANDPDZ128rrkz_VEXPANDPDZ256rr_VEXPANDPDZ256rrk_VEXPANDPDZ256rrkz_VEXPANDPDZrr_VEXPANDPDZrrk_VEXPANDPDZrrkz_VEXPANDPSZ128rr_VEXPANDPSZ128rrk_VEXPANDPSZ128rrkz_VEXPANDPSZ256rr_VEXPANDPSZ256rrk_VEXPANDPSZ256rrkz_VEXPANDPSZrr_VEXPANDPSZrrk_VEXPANDPSZrrkz_VPEXPANDDZ128rr_VPEXPANDDZ128rrk_VPEXPANDDZ128rrkz_VPEXPANDDZ256rr_VPEXPANDDZ256rrk_VPEXPANDDZ256rrkz_VPEXPANDDZrr_VPEXPANDDZrrk_VPEXPANDDZrrkz_VPEXPANDQZ128rr_VPEXPANDQZ128rrk_VPEXPANDQZ128rrkz_VPEXPANDQZ256rr_VPEXPANDQZ256rrk_VPEXPANDQZ256rrkz_VPEXPANDQZrr_VPEXPANDQZrrk_VPEXPANDQZrrkz") 1, false, false, false, 2605, 3,  1, 1,  0, 0}, // #1219
  {DBGFIELD("VPMOVDBZ128rr_VPMOVDBZ128rrk_VPMOVDBZ128rrkz_VPMOVDWZ128rr_VPMOVDWZ128rrk_VPMOVDWZ128rrkz_VPMOVQBZ128rr_VPMOVQBZ128rrk_VPMOVQBZ128rrkz_VPMOVQWZ128rr_VPMOVQWZ128rrk_VPMOVQWZ128rrkz_VPMOVSDBZ128rr_VPMOVSDBZ128rrk_VPMOVSDBZ128rrkz_VPMOVSDWZ128rr_VPMOVSDWZ128rrk_VPMOVSDWZ128rrkz_VPMOVSQBZ128rr_VPMOVSQBZ128rrk_VPMOVSQBZ128rrkz_VPMOVSQDZ128rr_VPMOVSQDZ128rrk_VPMOVSQDZ128rrkz_VPMOVSQWZ128rr_VPMOVSQWZ128rrk_VPMOVSQWZ128rrkz_VPMOVSWBZ128rr_VPMOVSWBZ128rrk_VPMOVSWBZ128rrkz_VPMOVUSDBZ128rr_VPMOVUSDBZ128rrk_VPMOVUSDBZ128rrkz_VPMOVUSDWZ128rr_VPMOVUSDWZ128rrk_VPMOVUSDWZ128rrkz_VPMOVUSQBZ128rr_VPMOVUSQBZ128rrk_VPMOVUSQBZ128rrkz_VPMOVUSQDZ128rr_VPMOVUSQDZ128rrk_VPMOVUSQDZ128rrkz_VPMOVUSWBZ128rr_VPMOVUSWBZ128rrk_VPMOVUSWBZ128rrkz_VPMOVWBZ128rr_VPMOVWBZ128rrk_VPMOVWBZ128rrkz") 1, false, false, false, 2605, 3,  1, 1,  0, 0}, // #1220
  {DBGFIELD("VPMOVDBZ256rr_VPMOVDBZ256rrk_VPMOVDBZ256rrkz_VPMOVDWZ256rr_VPMOVDWZ256rrk_VPMOVDWZ256rrkz_VPMOVDWZrr_VPMOVDWZrrk_VPMOVDWZrrkz_VPMOVQBZ256rr_VPMOVQBZ256rrk_VPMOVQBZ256rrkz_VPMOVQWZ256rr_VPMOVQWZ256rrk_VPMOVQWZ256rrkz_VPMOVSDBZ256rr_VPMOVSDBZ256rrk_VPMOVSDBZ256rrkz_VPMOVSDWZ256rr_VPMOVSDWZ256rrk_VPMOVSDWZ256rrkz_VPMOVSDWZrr_VPMOVSDWZrrk_VPMOVSDWZrrkz_VPMOVSQBZ256rr_VPMOVSQBZ256rrk_VPMOVSQBZ256rrkz_VPMOVSQDZ256rr_VPMOVSQDZ256rrk_VPMOVSQDZ256rrkz_VPMOVSQDZrr_VPMOVSQDZrrk_VPMOVSQDZrrkz_VPMOVSQWZ256rr_VPMOVSQWZ256rrk_VPMOVSQWZ256rrkz_VPMOVSWBZ256rr_VPMOVSWBZ256rrk_VPMOVSWBZ256rrkz_VPMOVSWBZrr_VPMOVSWBZrrk_VPMOVSWBZrrkz_VPMOVUSDBZ256rr_VPMOVUSDBZ256rrk_VPMOVUSDBZ256rrkz_VPMOVUSDWZ256rr_VPMOVUSDWZ256rrk_VPMOVUSDWZ256rrkz_VPMOVUSDWZrr_VPMOVUSDWZrrk_VPMOVUSDWZrrkz_VPMOVUSQBZ256rr_VPMOVUSQBZ256rrk_VPMOVUSQBZ256rrkz_VPMOVUSQDZ256rr_VPMOVUSQDZ256rrk_VPMOVUSQDZ256rrkz_VPMOVUSQDZrr_VPMOVUSQDZrrk_VPMOVUSQDZrrkz_VPMOVUSWBZ256rr_VPMOVUSWBZ256rrk_VPMOVUSWBZ256rrkz_VPMOVUSWBZrr_VPMOVUSWBZrrk_VPMOVUSWBZrrkz_VPMOVWBZ256rr_VPMOVWBZ256rrk_VPMOVWBZ256rrkz_VPMOVWBZrr_VPMOVWBZrrk_VPMOVWBZrrkz") 1, false, false, false, 2605, 3,  1, 1,  0, 0}, // #1221
  {DBGFIELD("VPMOVDBZrr_VPMOVDBZrrk_VPMOVDBZrrkz_VPMOVQBZrr_VPMOVQBZrrk_VPMOVQBZrrkz_VPMOVQWZrr_VPMOVQWZrrk_VPMOVQWZrrkz_VPMOVSDBZrr_VPMOVSDBZrrk_VPMOVSDBZrrkz_VPMOVSQBZrr_VPMOVSQBZrrk_VPMOVSQBZrrkz_VPMOVSQWZrr_VPMOVSQWZrrk_VPMOVSQWZrrkz_VPMOVUSDBZrr_VPMOVUSDBZrrk_VPMOVUSDBZrrkz_VPMOVUSQBZrr_VPMOVUSQBZrrk_VPMOVUSQBZrrkz") 1, false, false, false, 2605, 3,  1, 1,  0, 0}, // #1222
  {DBGFIELD("VPMOVQDZ128mr_VPMOVQDZ128mrk_VPMOVQDZ256mr_VPMOVQDZ256mrk_VPMOVQDZmr_VPMOVQDZmrk") 1, false, false, false, 2744, 5,  3, 1,  0, 0}, // #1223
  {DBGFIELD("VCVTDQ2PDZ128rr_VCVTDQ2PDZ128rrk_VCVTDQ2PDZ128rrkz_VCVTUDQ2PDZ128rr_VCVTUDQ2PDZ128rrk_VCVTUDQ2PDZ128rrkz") 2, false, false, false, 2439, 5,  7, 1,  0, 0}, // #1224
  {DBGFIELD("VCVTPD2DQZ128rr_VCVTPD2DQZ128rrk_VCVTPD2DQZ128rrkz_VCVTPD2UDQZ128rr_VCVTPD2UDQZ128rrk_VCVTPD2UDQZ128rrkz_VCVTTPD2DQZ128rr_VCVTTPD2DQZ128rrk_VCVTTPD2DQZ128rrkz_VCVTTPD2UDQZ128rr_VCVTTPD2UDQZ128rrk_VCVTTPD2UDQZ128rrkz") 2, false, false, false, 2439, 5,  7, 1,  0, 0}, // #1225
  {DBGFIELD("VCVTPS2PDZ128rr_VCVTPS2PDZ128rrk_VCVTPS2PDZ128rrkz_CVTPS2PDrr_VCVTPS2PDrr") 2, false, false, false, 2439, 5,  7, 1,  0, 0}, // #1226
  {DBGFIELD("VCVTPS2QQZ128rr_VCVTPS2QQZ128rrk_VCVTPS2QQZ128rrkz_VCVTPS2UQQZ128rr_VCVTPS2UQQZ128rrk_VCVTPS2UQQZ128rrkz_VCVTTPS2QQZ128rr_VCVTTPS2QQZ128rrk_VCVTTPS2QQZ128rrkz_VCVTTPS2UQQZ128rr_VCVTTPS2UQQZ128rrk_VCVTTPS2UQQZ128rrkz") 1, false, false, false, 2439, 5, 14, 1,  0, 0}, // #1227
  {DBGFIELD("VCVTQQ2PSZ128rr_VCVTQQ2PSZ128rrk_VCVTQQ2PSZ128rrkz_VCVTUQQ2PSZ128rr_VCVTUQQ2PSZ128rrk_VCVTUQQ2PSZ128rrkz") 1, false, false, false, 2439, 5, 14, 1,  0, 0}, // #1228
  {DBGFIELD("VCVTSI2SSZrr_VCVTSI2SSZrr_Int_VCVTSI2SSZrrb_Int_CVTSI2SSrr_Int_VCVTSI2SSrr_VCVTSI2SSrr_Int_VCVTUSI2SSZrr_VCVTUSI2SSZrr_Int_VCVTUSI2SSZrrb_Int") 2, false, false, false, 2439, 5, 14, 1, 24, 1}, // #1229
  {DBGFIELD("VCVTSI2SDZrr_VCVTSI2SDZrr_Int_VCVTSI642SDZrr_VCVTSI642SDZrr_Int_VCVTSI642SDZrrb_Int_VCVTUSI2SDZrr_VCVTUSI2SDZrr_Int_VCVTUSI642SDZrr_VCVTUSI642SDZrr_Int_VCVTUSI642SDZrrb_Int") 2, false, false, false, 2439, 5, 14, 1, 24, 1}, // #1230
  {DBGFIELD("VCVTSS2SDZrr_VCVTSS2SDZrr_Int_VCVTSS2SDZrr_Intk_VCVTSS2SDZrr_Intkz_VCVTSS2SDZrrb_Int_VCVTSS2SDZrrb_Intk_VCVTSS2SDZrrb_Intkz_CVTSS2SDrr_CVTSS2SDrr_Int_VCVTSS2SDrr_VCVTSS2SDrr_Int") 1, false, false, false, 2457, 5, 14, 1,  0, 0}, // #1231
  {DBGFIELD("VPCONFLICTQZ128rr_VPCONFLICTQZ128rrk_VPCONFLICTQZ128rrkz") 1, false, false, false, 2322, 3, 12, 1,  0, 0}, // #1232
  {DBGFIELD("VCVTPS2PHZ128mr_VCVTPS2PHZ128mrk") 3, false, false, false, 2765, 7, 14, 1,  0, 0}, // #1233
  {DBGFIELD("VCVTPS2PHZ256mr_VCVTPS2PHZ256mrk") 4, false, false, false, 2757, 8, 14, 1,  0, 0}, // #1234
  {DBGFIELD("VCVTPS2PHZmr_VCVTPS2PHZmrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1235
  {DBGFIELD("VPMOVDBZ128mr_VPMOVDBZ128mrk_VPMOVDBZ256mr_VPMOVDBZ256mrk_VPMOVDBZmr_VPMOVDBZmrk_VPMOVDWZ128mr_VPMOVDWZ128mrk_VPMOVDWZ256mr_VPMOVDWZ256mrk_VPMOVDWZmr_VPMOVDWZmrk_VPMOVQBZ128mr_VPMOVQBZ128mrk_VPMOVQBZ256mr_VPMOVQBZ256mrk_VPMOVQBZmr_VPMOVQBZmrk_VPMOVQWZ128mr_VPMOVQWZ128mrk_VPMOVQWZ256mr_VPMOVQWZ256mrk_VPMOVQWZmr_VPMOVQWZmrk_VPMOVSDBZ128mr_VPMOVSDBZ128mrk_VPMOVSDBZ256mr_VPMOVSDBZ256mrk_VPMOVSDBZmr_VPMOVSDBZmrk_VPMOVSDWZ128mr_VPMOVSDWZ128mrk_VPMOVSDWZ256mr_VPMOVSDWZ256mrk_VPMOVSDWZmr_VPMOVSDWZmrk_VPMOVSQBZ128mr_VPMOVSQBZ128mrk_VPMOVSQBZ256mr_VPMOVSQBZ256mrk_VPMOVSQBZmr_VPMOVSQBZmrk_VPMOVSQDZ128mr_VPMOVSQDZ128mrk_VPMOVSQDZ256mr_VPMOVSQDZ256mrk_VPMOVSQDZmr_VPMOVSQDZmrk_VPMOVSQWZ128mr_VPMOVSQWZ128mrk_VPMOVSQWZ256mr_VPMOVSQWZ256mrk_VPMOVSQWZmr_VPMOVSQWZmrk_VPMOVSWBZ128mr_VPMOVSWBZ128mrk_VPMOVSWBZ256mr_VPMOVSWBZ256mrk_VPMOVSWBZmr_VPMOVSWBZmrk_VPMOVUSDBZ128mr_VPMOVUSDBZ128mrk_VPMOVUSDBZ256mr_VPMOVUSDBZ256mrk_VPMOVUSDBZmr_VPMOVUSDBZmrk_VPMOVUSDWZ128mr_VPMOVUSDWZ128mrk_VPMOVUSDWZ256mr_VPMOVUSDWZ256mrk_VPMOVUSDWZmr_VPMOVUSDWZmrk_VPMOVUSQBZ128mr_VPMOVUSQBZ128mrk_VPMOVUSQBZ256mr_VPMOVUSQBZ256mrk_VPMOVUSQBZmr_VPMOVUSQBZmrk_VPMOVUSQDZ128mr_VPMOVUSQDZ128mrk_VPMOVUSQDZ256mr_VPMOVUSQDZ256mrk_VPMOVUSQDZmr_VPMOVUSQDZmrk_VPMOVUSQWZ128mr_VPMOVUSQWZ128mrk_VPMOVUSQWZ256mr_VPMOVUSQWZ256mrk_VPMOVUSQWZmr_VPMOVUSQWZmrk_VPMOVUSWBZ128mr_VPMOVUSWBZ128mrk_VPMOVUSWBZ256mr_VPMOVUSWBZ256mrk_VPMOVUSWBZmr_VPMOVUSWBZmrk_VPMOVWBZ128mr_VPMOVWBZ128mrk_VPMOVWBZ256mr_VPMOVWBZ256mrk_VPMOVWBZmr_VPMOVWBZmrk") 1, false, false, false, 2744, 5,  3, 1,  0, 0}, // #1236
  {DBGFIELD("VCOMPRESSPDZ128rr_VCOMPRESSPDZ128rrk_VCOMPRESSPDZ128rrkz_VCOMPRESSPSZ128rr_VCOMPRESSPSZ128rrk_VCOMPRESSPSZ128rrkz_VPCOMPRESSDZ128rr_VPCOMPRESSDZ128rrk_VPCOMPRESSDZ128rrkz_VPCOMPRESSQZ128rr_VPCOMPRESSQZ128rrk_VPCOMPRESSQZ128rrkz_VPERMWZ128rr_VPERMWZ128rrk_VPERMWZ128rrkz") 1, false, false, false, 2605, 3,  1, 1,  0, 0}, // #1237
  {DBGFIELD("VCOMPRESSPDZ256rr_VCOMPRESSPDZ256rrk_VCOMPRESSPDZ256rrkz_VCOMPRESSPSZ256rr_VCOMPRESSPSZ256rrk_VCOMPRESSPSZ256rrkz_VPCOMPRESSDZ256rr_VPCOMPRESSDZ256rrk_VPCOMPRESSDZ256rrkz_VPCOMPRESSQZ256rr_VPCOMPRESSQZ256rrk_VPCOMPRESSQZ256rrkz_VPERMWZ256rr_VPERMWZ256rrk_VPERMWZ256rrkz") 1, false, false, false, 2605, 3,  1, 1,  0, 0}, // #1238
  {DBGFIELD("VCOMPRESSPDZrr_VCOMPRESSPDZrrk_VCOMPRESSPDZrrkz_VCOMPRESSPSZrr_VCOMPRESSPSZrrk_VCOMPRESSPSZrrkz_VPCOMPRESSDZrr_VPCOMPRESSDZrrk_VPCOMPRESSDZrrkz_VPCOMPRESSQZrr_VPCOMPRESSQZrrk_VPCOMPRESSQZrrkz_VPERMWZrr_VPERMWZrrk_VPERMWZrrkz") 1, false, false, false, 2605, 3,  1, 1,  0, 0}, // #1239
  {DBGFIELD("VMOV64toPQIZrm_VMOVQI2PQIZrm") 1, false, false, false, 2584, 5, 10, 1,  0, 0}, // #1240
  {DBGFIELD("VMOVDI2PDIZrm")      1, false, false, false, 2584, 5, 10, 1,  0, 0}, // #1241
  {DBGFIELD("VCVTSI642SSZrr_VCVTSI642SSZrr_Int_VCVTSI642SSZrrb_Int_VCVTUSI642SSZrr_VCVTUSI642SSZrr_Int_VCVTUSI642SSZrrb_Int") 2, false, false, false, 2439, 5, 14, 1, 24, 1}, // #1242
  {DBGFIELD("VMOVSDZrm_VMOVSDZrm_alt_VMOVSDZrmk_VMOVSDZrmkz_VMOVSSZrm_VMOVSSZrm_alt_VMOVSSZrmk_VMOVSSZrmkz") 1, false, false, false, 2350, 5, 10, 1,  0, 0}, // #1243
  {DBGFIELD("VCVTDQ2PDZ256rr_VCVTDQ2PDZ256rrk_VCVTDQ2PDZ256rrkz_VCVTUDQ2PDZ256rr_VCVTUDQ2PDZ256rrk_VCVTUDQ2PDZ256rrkz") 4, false, false, false, 2457, 5,  7, 1,  0, 0}, // #1244
  {DBGFIELD("VCVTPD2DQZ256rr_VCVTPD2DQZ256rrk_VCVTPD2DQZ256rrkz_VCVTPD2UDQZ256rr_VCVTPD2UDQZ256rrk_VCVTPD2UDQZ256rrkz_VCVTTPD2DQZ256rr_VCVTTPD2DQZ256rrk_VCVTTPD2DQZ256rrkz_VCVTTPD2UDQZ256rr_VCVTTPD2UDQZ256rrk_VCVTTPD2UDQZ256rrkz") 4, false, false, false, 2750, 6,  7, 1,  0, 0}, // #1245
  {DBGFIELD("VCVTPS2PDYrr_VCVTPS2PDZ256rr_VCVTPS2PDZ256rrk_VCVTPS2PDZ256rrkz") 4, false, false, false, 2457, 5,  7, 1,  0, 0}, // #1246
  {DBGFIELD("VCVTPS2QQZ256rr_VCVTPS2QQZ256rrk_VCVTPS2QQZ256rrkz_VCVTPS2UQQZ256rr_VCVTPS2UQQZ256rrk_VCVTPS2UQQZ256rrkz_VCVTTPS2QQZ256rr_VCVTTPS2QQZ256rrk_VCVTTPS2QQZ256rrkz_VCVTTPS2UQQZ256rr_VCVTTPS2UQQZ256rrk_VCVTTPS2UQQZ256rrkz") 2, false, false, false, 2457, 5, 14, 1,  0, 0}, // #1247
  {DBGFIELD("VCVTQQ2PSZ256rr_VCVTQQ2PSZ256rrk_VCVTQQ2PSZ256rrkz_VCVTUQQ2PSZ256rr_VCVTUQQ2PSZ256rrk_VCVTUQQ2PSZ256rrkz") 2, false, false, false, 2457, 5, 14, 1,  0, 0}, // #1248
  {DBGFIELD("VCVTDQ2PDZrr_VCVTUDQ2PDZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1249
  {DBGFIELD("VCVTPD2DQZrr_VCVTPD2UDQZrr_VCVTTPD2DQZrr_VCVTTPD2UDQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1250
  {DBGFIELD("VCVTPS2PDZrr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1251
  {DBGFIELD("VCVTPS2QQZrr_VCVTPS2UQQZrr_VCVTTPS2QQZrr_VCVTTPS2UQQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1252
  {DBGFIELD("VCVTQQ2PSZrr_VCVTUQQ2PSZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1253
  {DBGFIELD("VMOVNTDQAZ128rm")    1, false, false, false, 2584, 5, 10, 1,  0, 0}, // #1254
  {DBGFIELD("VBLENDMPDZ128rm_VBLENDMPDZ128rmb_VBLENDMPDZ128rmbk_VBLENDMPDZ128rmbkz_VBLENDMPDZ128rmk_VBLENDMPDZ128rmkz_VBLENDMPSZ128rm_VBLENDMPSZ128rmb_VBLENDMPSZ128rmbk_VBLENDMPSZ128rmbkz_VBLENDMPSZ128rmk_VBLENDMPSZ128rmkz") 1, false, false, false, 2390, 6,  6, 1,  3, 1}, // #1255
  {DBGFIELD("VBROADCASTI32X2Z128rm_VBROADCASTI32X2Z128rmk_VBROADCASTI32X2Z128rmkz_VPBROADCASTDZ128rm_VPBROADCASTDZ128rmk_VPBROADCASTDZ128rmkz_VPBROADCASTQZ128rm_VPBROADCASTQZ128rmk_VPBROADCASTQZ128rmkz") 1, false, false, false, 2390, 6,  6, 1,  0, 0}, // #1256
  {DBGFIELD("VBROADCASTSSZ128rm_VBROADCASTSSZ128rmk_VBROADCASTSSZ128rmkz") 2, false, false, false, 2350, 5,  6, 1,  0, 0}, // #1257
  {DBGFIELD("VMOVAPDZ128rm_VMOVAPDZ128rmk_VMOVAPDZ128rmkz_VMOVAPSZ128rm_NOVLX_VMOVAPSZ128rm_VMOVAPSZ128rmk_VMOVAPSZ128rmkz_VMOVUPDZ128rm_VMOVUPDZ128rmk_VMOVUPDZ128rmkz_VMOVUPSZ128rm_NOVLX_VMOVUPSZ128rm_VMOVUPSZ128rmk_VMOVUPSZ128rmkz") 1, false, false, false, 2350, 5, 10, 1,  0, 0}, // #1258
  {DBGFIELD("VMOVDDUPZ128rm_VMOVDDUPZ128rmk_VMOVDDUPZ128rmkz_VMOVSHDUPZ128rm_VMOVSHDUPZ128rmk_VMOVSHDUPZ128rmkz_VMOVSLDUPZ128rm_VMOVSLDUPZ128rmk_VMOVSLDUPZ128rmkz") 1, false, false, false, 2579, 5,  6, 1,  0, 0}, // #1259
  {DBGFIELD("VMOVDQA32Z128rm_VMOVDQA32Z128rmk_VMOVDQA32Z128rmkz_VMOVDQA64Z128rm_VMOVDQA64Z128rmk_VMOVDQA64Z128rmkz_VMOVDQU16Z128rm_VMOVDQU16Z128rmk_VMOVDQU16Z128rmkz_VMOVDQU32Z128rm_VMOVDQU32Z128rmk_VMOVDQU32Z128rmkz_VMOVDQU64Z128rm_VMOVDQU64Z128rmk_VMOVDQU64Z128rmkz_VMOVDQU8Z128rm_VMOVDQU8Z128rmk_VMOVDQU8Z128rmkz") 1, false, false, false, 2584, 5, 10, 1,  0, 0}, // #1260
  {DBGFIELD("VPADDBZ128rm_VPADDBZ128rmk_VPADDBZ128rmkz_VPADDDZ128rm_VPADDDZ128rmb_VPADDDZ128rmbk_VPADDDZ128rmbkz_VPADDDZ128rmk_VPADDDZ128rmkz_VPADDQZ128rm_VPADDQZ128rmb_VPADDQZ128rmbk_VPADDQZ128rmbkz_VPADDQZ128rmk_VPADDQZ128rmkz_VPADDWZ128rm_VPADDWZ128rmk_VPADDWZ128rmkz_VPSUBBZ128rm_VPSUBBZ128rmk_VPSUBBZ128rmkz_VPSUBDZ128rm_VPSUBDZ128rmb_VPSUBDZ128rmbk_VPSUBDZ128rmbkz_VPSUBDZ128rmk_VPSUBDZ128rmkz_VPSUBQZ128rm_VPSUBQZ128rmb_VPSUBQZ128rmbk_VPSUBQZ128rmbkz_VPSUBQZ128rmk_VPSUBQZ128rmkz_VPSUBWZ128rm_VPSUBWZ128rmk_VPSUBWZ128rmkz_VPTERNLOGDZ128rmbi_VPTERNLOGDZ128rmbik_VPTERNLOGDZ128rmbikz_VPTERNLOGDZ128rmi_VPTERNLOGDZ128rmik_VPTERNLOGDZ128rmikz_VPTERNLOGQZ128rmbi_VPTERNLOGQZ128rmbik_VPTERNLOGQZ128rmbikz_VPTERNLOGQZ128rmi_VPTERNLOGQZ128rmik_VPTERNLOGQZ128rmikz") 1, false, false, false, 2385, 5,  6, 1,  3, 1}, // #1261
  {DBGFIELD("VPBLENDMBZ128rm_VPBLENDMBZ128rmk_VPBLENDMBZ128rmkz_VPBLENDMDZ128rm_VPBLENDMDZ128rmb_VPBLENDMDZ128rmbk_VPBLENDMDZ128rmbkz_VPBLENDMDZ128rmk_VPBLENDMDZ128rmkz_VPBLENDMQZ128rm_VPBLENDMQZ128rmb_VPBLENDMQZ128rmbk_VPBLENDMQZ128rmbkz_VPBLENDMQZ128rmk_VPBLENDMQZ128rmkz_VPBLENDMWZ128rm_VPBLENDMWZ128rmk_VPBLENDMWZ128rmkz") 1, false, false, false, 2390, 6,  6, 1,  3, 1}, // #1262
  {DBGFIELD("VPERMI2W128rr_VPERMI2W128rrk_VPERMI2W128rrkz_VPERMT2W128rr_VPERMT2W128rrk_VPERMT2W128rrkz") 1, false, false, false, 2605, 3,  1, 1,  0, 0}, // #1263
  {DBGFIELD("VPERMI2W256rr_VPERMI2W256rrk_VPERMI2W256rrkz_VPERMT2W256rr_VPERMT2W256rrk_VPERMT2W256rrkz") 1, false, false, false, 2605, 3,  1, 1,  0, 0}, // #1264
  {DBGFIELD("VPERMI2Wrr_VPERMI2Wrrk_VPERMI2Wrrkz_VPERMT2Wrr_VPERMT2Wrrk_VPERMT2Wrrkz") 1, false, false, false, 2605, 3,  1, 1,  0, 0}, // #1265
  {DBGFIELD("VCVTSS2SI64Zrr_VCVTSS2SI64Zrr_Int_VCVTSS2SI64Zrrb_Int_VCVTTSS2SI64Zrr_VCVTTSS2SI64Zrr_Int_VCVTTSS2SI64Zrrb_Int_VCVTSS2USI64Zrr_Int_VCVTSS2USI64Zrrb_Int_VCVTTSS2USI64Zrr_VCVTTSS2USI64Zrr_Int_VCVTTSS2USI64Zrrb_Int") 2, false, false, false, 2446, 9, 24, 1,  0, 0}, // #1266
  {DBGFIELD("KMOVBkm_KMOVDkm_KMOVQkm_KMOVWkm") 1, false, false, false, 2420, 2, 10, 1,  0, 0}, // #1267
  {DBGFIELD("VCOMPRESSPDZ128mr_VCOMPRESSPDZ128mrk_VCOMPRESSPDZ256mr_VCOMPRESSPDZ256mrk_VCOMPRESSPDZmr_VCOMPRESSPDZmrk_VCOMPRESSPSZ128mr_VCOMPRESSPSZ128mrk_VCOMPRESSPSZ256mr_VCOMPRESSPSZ256mrk_VCOMPRESSPSZmr_VCOMPRESSPSZmrk_VPCOMPRESSDZ128mr_VPCOMPRESSDZ128mrk_VPCOMPRESSDZ256mr_VPCOMPRESSDZ256mrk_VPCOMPRESSDZmr_VPCOMPRESSDZmrk_VPCOMPRESSQZ128mr_VPCOMPRESSQZ128mrk_VPCOMPRESSQZ256mr_VPCOMPRESSQZ256mrk_VPCOMPRESSQZmr_VPCOMPRESSQZmrk") 1, false, false, false, 2744, 5,  3, 1,  0, 0}, // #1268
  {DBGFIELD("VPSCATTERDQZ128mr_VPSCATTERQQZ128mr_VSCATTERDPDZ128mr_VSCATTERQPDZ128mr") 1, false, false, false, 2499, 2,  1, 1,  0, 0}, // #1269
  {DBGFIELD("VPSCATTERDQZ256mr_VPSCATTERQQZ256mr_VSCATTERDPDZ256mr_VSCATTERQPDZ256mr") 1, false, false, false, 2499, 2,  1, 1,  0, 0}, // #1270
  {DBGFIELD("VPSCATTERDQZmr_VPSCATTERQQZmr_VSCATTERDPDZmr_VSCATTERQPDZmr") 1, false, false, false, 2499, 2,  1, 1,  0, 0}, // #1271
  {DBGFIELD("VSCATTERDPSZmr")     1, false, false, false, 2499, 2,  1, 1,  0, 0}, // #1272
  {DBGFIELD("VPBROADCASTBZ256rm_VPBROADCASTBZ256rmk_VPBROADCASTBZ256rmkz_VPBROADCASTBZrm_VPBROADCASTBZrmk_VPBROADCASTBZrmkz_VPBROADCASTWZ256rm_VPBROADCASTWZ256rmk_VPBROADCASTWZ256rmkz_VPBROADCASTWZrm_VPBROADCASTWZrmk_VPBROADCASTWZrmkz") 1, false, false, false, 2744, 5,  3, 1,  0, 0}, // #1273
  {DBGFIELD("VMOVNTDQAZ256rm")    2, false, false, false, 2796, 5, 10, 1,  0, 0}, // #1274
  {DBGFIELD("VBLENDMPDZ256rm_VBLENDMPDZ256rmb_VBLENDMPDZ256rmbk_VBLENDMPDZ256rmbkz_VBLENDMPDZ256rmk_VBLENDMPDZ256rmkz_VBLENDMPSZ256rm_VBLENDMPSZ256rmb_VBLENDMPSZ256rmbk_VBLENDMPSZ256rmbkz_VBLENDMPSZ256rmk_VBLENDMPSZ256rmkz") 2, false, false, false, 2733, 6,  6, 1,  3, 1}, // #1275
  {DBGFIELD("VBLENDMPDZrm_VBLENDMPDZrmb_VBLENDMPDZrmbk_VBLENDMPDZrmbkz_VBLENDMPDZrmk_VBLENDMPDZrmkz_VBLENDMPSZrm_VBLENDMPSZrmb_VBLENDMPSZrmbk_VBLENDMPSZrmbkz_VBLENDMPSZrmk_VBLENDMPSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1276
  {DBGFIELD("VBROADCASTF32X2Z256rm_VBROADCASTF32X2Z256rmk_VBROADCASTF32X2Z256rmkz_VBROADCASTF32X2Zrm_VBROADCASTF32X2Zrmk_VBROADCASTF32X2Zrmkz_VBROADCASTI32X2Z256rm_VBROADCASTI32X2Z256rmk_VBROADCASTI32X2Z256rmkz_VBROADCASTI32X2Zrm_VBROADCASTI32X2Zrmk_VBROADCASTI32X2Zrmkz_VPBROADCASTDZ256rm_VPBROADCASTDZ256rmk_VPBROADCASTDZ256rmkz_VPBROADCASTDZrm_VPBROADCASTDZrmk_VPBROADCASTDZrmkz_VPBROADCASTQZ256rm_VPBROADCASTQZ256rmk_VPBROADCASTQZ256rmkz_VPBROADCASTQZrm_VPBROADCASTQZrmk_VPBROADCASTQZrmkz") 1, false, false, false, 2744, 5,  3, 1,  0, 0}, // #1277
  {DBGFIELD("VBROADCASTF32X4Z256rm_VBROADCASTF32X4Z256rmk_VBROADCASTF32X4Z256rmkz_VBROADCASTF32X4rm_VBROADCASTF32X4rmk_VBROADCASTF32X4rmkz_VBROADCASTF32X8rm_VBROADCASTF32X8rmk_VBROADCASTF32X8rmkz_VBROADCASTF64X2Z128rm_VBROADCASTF64X2Z128rmk_VBROADCASTF64X2Z128rmkz_VBROADCASTF64X2rm_VBROADCASTF64X2rmk_VBROADCASTF64X2rmkz_VBROADCASTF64X4rm_VBROADCASTF64X4rmk_VBROADCASTF64X4rmkz_VBROADCASTI32X4Z256rm_VBROADCASTI32X4Z256rmk_VBROADCASTI32X4Z256rmkz_VBROADCASTI32X4rm_VBROADCASTI32X4rmk_VBROADCASTI32X4rmkz_VBROADCASTI32X8rm_VBROADCASTI32X8rmk_VBROADCASTI32X8rmkz_VBROADCASTI64X2Z128rm_VBROADCASTI64X2Z128rmk_VBROADCASTI64X2Z128rmkz_VBROADCASTI64X2rm_VBROADCASTI64X2rmk_VBROADCASTI64X2rmkz_VBROADCASTI64X4rm_VBROADCASTI64X4rmk_VBROADCASTI64X4rmkz") 2, false, false, false, 2733, 6,  6, 1,  0, 0}, // #1278
  {DBGFIELD("VBROADCASTSDZ256rm_VBROADCASTSDZ256rmk_VBROADCASTSDZ256rmkz_VBROADCASTSDZrm_VBROADCASTSDZrmk_VBROADCASTSDZrmkz_VBROADCASTSSZ256rm_VBROADCASTSSZ256rmk_VBROADCASTSSZ256rmkz_VBROADCASTSSZrm_VBROADCASTSSZrmk_VBROADCASTSSZrmkz") 2, false, false, false, 2350, 5,  6, 1,  0, 0}, // #1279
  {DBGFIELD("VINSERTF32x4Z256rm_VINSERTF32x4Z256rmk_VINSERTF32x4Z256rmkz_VINSERTF32x4Zrm_VINSERTF32x4Zrmk_VINSERTF32x4Zrmkz_VINSERTF32x8Zrm_VINSERTF32x8Zrmk_VINSERTF32x8Zrmkz_VINSERTF64x2Z256rm_VINSERTF64x2Z256rmk_VINSERTF64x2Z256rmkz_VINSERTF64x2Zrm_VINSERTF64x2Zrmk_VINSERTF64x2Zrmkz_VINSERTF64x4Zrm_VINSERTF64x4Zrmk_VINSERTF64x4Zrmkz") 2, false, false, false, 2350, 5,  6, 1,  3, 1}, // #1280
  {DBGFIELD("VINSERTI32x4Z256rm_VINSERTI32x4Z256rmk_VINSERTI32x4Z256rmkz_VINSERTI32x4Zrm_VINSERTI32x4Zrmk_VINSERTI32x4Zrmkz_VINSERTI32x8Zrm_VINSERTI32x8Zrmk_VINSERTI32x8Zrmkz_VINSERTI64x2Z256rm_VINSERTI64x2Z256rmk_VINSERTI64x2Z256rmkz_VINSERTI64x2Zrm_VINSERTI64x2Zrmk_VINSERTI64x2Zrmkz_VINSERTI64x4Zrm_VINSERTI64x4Zrmk_VINSERTI64x4Zrmkz") 1, false, false, false, 2744, 5,  3, 1,  3, 1}, // #1281
  {DBGFIELD("VMOVAPDZ256rm_VMOVAPDZ256rmk_VMOVAPDZ256rmkz_VMOVAPDZrm_VMOVAPDZrmk_VMOVAPDZrmkz_VMOVAPSZ256rm_NOVLX_VMOVAPSZ256rm_VMOVAPSZ256rmk_VMOVAPSZ256rmkz_VMOVAPSZrm_VMOVAPSZrmk_VMOVAPSZrmkz_VMOVUPDZ256rm_VMOVUPDZ256rmk_VMOVUPDZ256rmkz_VMOVUPDZrm_VMOVUPDZrmk_VMOVUPDZrmkz_VMOVUPSZ256rm_NOVLX_VMOVUPSZ256rm_VMOVUPSZ256rmk_VMOVUPSZ256rmkz_VMOVUPSZrm_VMOVUPSZrmk_VMOVUPSZrmkz") 2, false, false, false, 2350, 5, 10, 1,  0, 0}, // #1282
  {DBGFIELD("VMOVDDUPZ256rm_VMOVDDUPZ256rmk_VMOVDDUPZ256rmkz_VMOVSHDUPZ256rm_VMOVSHDUPZ256rmk_VMOVSHDUPZ256rmkz_VMOVSLDUPZ256rm_VMOVSLDUPZ256rmk_VMOVSLDUPZ256rmkz") 2, false, false, false, 2806, 5,  6, 1,  0, 0}, // #1283
  {DBGFIELD("VMOVDDUPZrm_VMOVDDUPZrmk_VMOVDDUPZrmkz_VMOVSHDUPZrm_VMOVSHDUPZrmk_VMOVSHDUPZrmkz_VMOVSLDUPZrm_VMOVSLDUPZrmk_VMOVSLDUPZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1284
  {DBGFIELD("VMOVDQA32Z256rm_VMOVDQA32Z256rmk_VMOVDQA32Z256rmkz_VMOVDQA32Zrm_VMOVDQA32Zrmk_VMOVDQA32Zrmkz_VMOVDQA64Z256rm_VMOVDQA64Z256rmk_VMOVDQA64Z256rmkz_VMOVDQA64Zrm_VMOVDQA64Zrmk_VMOVDQA64Zrmkz_VMOVDQU16Z256rm_VMOVDQU16Z256rmk_VMOVDQU16Z256rmkz_VMOVDQU16Zrm_VMOVDQU16Zrmk_VMOVDQU16Zrmkz_VMOVDQU32Z256rm_VMOVDQU32Z256rmk_VMOVDQU32Z256rmkz_VMOVDQU32Zrm_VMOVDQU32Zrmk_VMOVDQU32Zrmkz_VMOVDQU64Z256rm_VMOVDQU64Z256rmk_VMOVDQU64Z256rmkz_VMOVDQU64Zrm_VMOVDQU64Zrmk_VMOVDQU64Zrmkz_VMOVDQU8Z256rm_VMOVDQU8Z256rmk_VMOVDQU8Z256rmkz_VMOVDQU8Zrm_VMOVDQU8Zrmk_VMOVDQU8Zrmkz") 2, false, false, false, 2796, 5, 10, 1,  0, 0}, // #1285
  {DBGFIELD("VPADDBZ256rm_VPADDBZ256rmk_VPADDBZ256rmkz_VPADDDZ256rm_VPADDDZ256rmb_VPADDDZ256rmbk_VPADDDZ256rmbkz_VPADDDZ256rmk_VPADDDZ256rmkz_VPADDQZ256rm_VPADDQZ256rmb_VPADDQZ256rmbk_VPADDQZ256rmbkz_VPADDQZ256rmk_VPADDQZ256rmkz_VPADDWZ256rm_VPADDWZ256rmk_VPADDWZ256rmkz_VPSUBBZ256rm_VPSUBBZ256rmk_VPSUBBZ256rmkz_VPSUBDZ256rm_VPSUBDZ256rmb_VPSUBDZ256rmbk_VPSUBDZ256rmbkz_VPSUBDZ256rmk_VPSUBDZ256rmkz_VPSUBQZ256rm_VPSUBQZ256rmb_VPSUBQZ256rmbk_VPSUBQZ256rmbkz_VPSUBQZ256rmk_VPSUBQZ256rmkz_VPSUBWZ256rm_VPSUBWZ256rmk_VPSUBWZ256rmkz_VPTERNLOGDZ256rmbi_VPTERNLOGDZ256rmbik_VPTERNLOGDZ256rmbikz_VPTERNLOGDZ256rmi_VPTERNLOGDZ256rmik_VPTERNLOGDZ256rmikz_VPTERNLOGQZ256rmbi_VPTERNLOGQZ256rmbik_VPTERNLOGQZ256rmbikz_VPTERNLOGQZ256rmi_VPTERNLOGQZ256rmik_VPTERNLOGQZ256rmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1286
  {DBGFIELD("VPADDBZrm_VPADDBZrmk_VPADDBZrmkz_VPADDDZrm_VPADDDZrmb_VPADDDZrmbk_VPADDDZrmbkz_VPADDDZrmk_VPADDDZrmkz_VPADDQZrm_VPADDQZrmb_VPADDQZrmbk_VPADDQZrmbkz_VPADDQZrmk_VPADDQZrmkz_VPADDWZrm_VPADDWZrmk_VPADDWZrmkz_VPSUBBZrm_VPSUBBZrmk_VPSUBBZrmkz_VPSUBDZrm_VPSUBDZrmb_VPSUBDZrmbk_VPSUBDZrmbkz_VPSUBDZrmk_VPSUBDZrmkz_VPSUBQZrm_VPSUBQZrmb_VPSUBQZrmbk_VPSUBQZrmbkz_VPSUBQZrmk_VPSUBQZrmkz_VPSUBWZrm_VPSUBWZrmk_VPSUBWZrmkz_VPTERNLOGDZrmbi_VPTERNLOGDZrmbik_VPTERNLOGDZrmbikz_VPTERNLOGDZrmi_VPTERNLOGDZrmik_VPTERNLOGDZrmikz_VPTERNLOGQZrmbi_VPTERNLOGQZrmbik_VPTERNLOGQZrmbikz_VPTERNLOGQZrmi_VPTERNLOGQZrmik_VPTERNLOGQZrmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1287
  {DBGFIELD("VPBLENDMBZ256rm_VPBLENDMBZ256rmk_VPBLENDMBZ256rmkz_VPBLENDMDZ256rm_VPBLENDMDZ256rmb_VPBLENDMDZ256rmbk_VPBLENDMDZ256rmbkz_VPBLENDMDZ256rmk_VPBLENDMDZ256rmkz_VPBLENDMQZ256rm_VPBLENDMQZ256rmb_VPBLENDMQZ256rmbk_VPBLENDMQZ256rmbkz_VPBLENDMQZ256rmk_VPBLENDMQZ256rmkz_VPBLENDMWZ256rm_VPBLENDMWZ256rmk_VPBLENDMWZ256rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1288
  {DBGFIELD("VPBLENDMBZrm_VPBLENDMBZrmk_VPBLENDMBZrmkz_VPBLENDMDZrm_VPBLENDMDZrmb_VPBLENDMDZrmbk_VPBLENDMDZrmbkz_VPBLENDMDZrmk_VPBLENDMDZrmkz_VPBLENDMQZrm_VPBLENDMQZrmb_VPBLENDMQZrmbk_VPBLENDMQZrmbkz_VPBLENDMQZrmk_VPBLENDMQZrmkz_VPBLENDMWZrm_VPBLENDMWZrmk_VPBLENDMWZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1289
  {DBGFIELD("VPSCATTERQDZ128mr_VPSCATTERQDZ256mr_VSCATTERQPSZ128mr_VSCATTERQPSZ256mr") 1, false, false, false, 2499, 2,  1, 1,  0, 0}, // #1290
  {DBGFIELD("VPSCATTERDDZ128mr_VSCATTERDPSZ128mr") 1, false, false, false, 2499, 2,  1, 1,  0, 0}, // #1291
  {DBGFIELD("VPSCATTERDDZ256mr_VSCATTERDPSZ256mr") 1, false, false, false, 2499, 2,  1, 1,  0, 0}, // #1292
  {DBGFIELD("VPSCATTERDDZmr")     1, false, false, false, 2499, 2,  1, 1,  0, 0}, // #1293
  {DBGFIELD("VALIGNDZ128rmbi_VALIGNDZ128rmbik_VALIGNDZ128rmbikz_VALIGNDZ128rmi_VALIGNDZ128rmik_VALIGNDZ128rmikz_VALIGNQZ128rmbi_VALIGNQZ128rmbik_VALIGNQZ128rmbikz_VALIGNQZ128rmi_VALIGNQZ128rmik_VALIGNQZ128rmikz") 1, false, false, false, 2390, 6,  6, 1,  3, 1}, // #1294
  {DBGFIELD("VFPCLASSSDZrm_VFPCLASSSDZrmk_VFPCLASSSSZrm_VFPCLASSSSZrmk") 1, false, false, false, 2373, 6,  6, 1,  3, 1}, // #1295
  {DBGFIELD("VPERMI2D128rm_VPERMI2D128rmb_VPERMI2D128rmbk_VPERMI2D128rmbkz_VPERMI2D128rmk_VPERMI2D128rmkz_VPERMI2Q128rm_VPERMI2Q128rmb_VPERMI2Q128rmbk_VPERMI2Q128rmbkz_VPERMI2Q128rmk_VPERMI2Q128rmkz_VPERMT2D128rm_VPERMT2D128rmb_VPERMT2D128rmbk_VPERMT2D128rmbkz_VPERMT2D128rmk_VPERMT2D128rmkz_VPERMT2Q128rm_VPERMT2Q128rmb_VPERMT2Q128rmbk_VPERMT2Q128rmbkz_VPERMT2Q128rmk_VPERMT2Q128rmkz") 1, false, false, false, 2744, 5,  3, 1,  3, 1}, // #1296
  {DBGFIELD("VPERMI2PD128rm_VPERMI2PD128rmb_VPERMI2PD128rmbk_VPERMI2PD128rmbkz_VPERMI2PD128rmk_VPERMI2PD128rmkz_VPERMI2PS128rm_VPERMI2PS128rmb_VPERMI2PS128rmbk_VPERMI2PS128rmbkz_VPERMI2PS128rmk_VPERMI2PS128rmkz_VPERMT2PD128rm_VPERMT2PD128rmb_VPERMT2PD128rmbk_VPERMT2PD128rmbkz_VPERMT2PD128rmk_VPERMT2PD128rmkz_VPERMT2PS128rm_VPERMT2PS128rmb_VPERMT2PS128rmbk_VPERMT2PS128rmbkz_VPERMT2PS128rmk_VPERMT2PS128rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1297
  {DBGFIELD("VPMAXSQZ128rm_VPMAXSQZ128rmb_VPMAXSQZ128rmbk_VPMAXSQZ128rmbkz_VPMAXSQZ128rmk_VPMAXSQZ128rmkz_VPMAXUQZ128rm_VPMAXUQZ128rmb_VPMAXUQZ128rmbk_VPMAXUQZ128rmbkz_VPMAXUQZ128rmk_VPMAXUQZ128rmkz_VPMINSQZ128rm_VPMINSQZ128rmb_VPMINSQZ128rmbk_VPMINSQZ128rmbkz_VPMINSQZ128rmk_VPMINSQZ128rmkz_VPMINUQZ128rm_VPMINUQZ128rmb_VPMINUQZ128rmbk_VPMINUQZ128rmbkz_VPMINUQZ128rmk_VPMINUQZ128rmkz") 1, false, false, false, 2385, 5,  6, 1,  3, 1}, // #1298
  {DBGFIELD("VCMPPDZ128rmbi_VCMPPDZ128rmbik_VCMPPDZ128rmi_VCMPPDZ128rmik_VCMPPSZ128rmbi_VCMPPSZ128rmbik_VCMPPSZ128rmi_VCMPPSZ128rmik_VFPCLASSPDZ128rm_VFPCLASSPDZ128rmb_VFPCLASSPDZ128rmbk_VFPCLASSPDZ128rmk_VFPCLASSPSZ128rm_VFPCLASSPSZ128rmb_VFPCLASSPSZ128rmbk_VFPCLASSPSZ128rmk") 1, false, false, false, 2373, 6,  6, 1,  3, 1}, // #1299
  {DBGFIELD("VCMPSDZrm_VCMPSDZrm_Int_VCMPSDZrm_Intk_VCMPSSZrm_VCMPSSZrm_Int_VCMPSSZrm_Intk") 1, false, false, false, 2373, 6,  6, 1,  3, 1}, // #1300
  {DBGFIELD("VPCMPBZ128rmi_VPCMPBZ128rmik_VPCMPDZ128rmi_VPCMPDZ128rmib_VPCMPDZ128rmibk_VPCMPDZ128rmik_VPCMPEQBZ128rm_VPCMPEQBZ128rmk_VPCMPEQDZ128rm_VPCMPEQDZ128rmb_VPCMPEQDZ128rmbk_VPCMPEQDZ128rmk_VPCMPEQQZ128rm_VPCMPEQQZ128rmb_VPCMPEQQZ128rmbk_VPCMPEQQZ128rmk_VPCMPEQWZ128rm_VPCMPEQWZ128rmk_VPCMPGTBZ128rm_VPCMPGTBZ128rmk_VPCMPGTDZ128rm_VPCMPGTDZ128rmb_VPCMPGTDZ128rmbk_VPCMPGTDZ128rmk_VPCMPGTQZ128rm_VPCMPGTQZ128rmb_VPCMPGTQZ128rmbk_VPCMPGTQZ128rmk_VPCMPGTWZ128rm_VPCMPGTWZ128rmk_VPCMPQZ128rmi_VPCMPQZ128rmib_VPCMPQZ128rmibk_VPCMPQZ128rmik_VPCMPUBZ128rmi_VPCMPUBZ128rmik_VPCMPUDZ128rmi_VPCMPUDZ128rmib_VPCMPUDZ128rmibk_VPCMPUDZ128rmik_VPCMPUQZ128rmi_VPCMPUQZ128rmib_VPCMPUQZ128rmibk_VPCMPUQZ128rmik_VPCMPUWZ128rmi_VPCMPUWZ128rmik_VPCMPWZ128rmi_VPCMPWZ128rmik") 1, false, false, false, 2385, 5,  6, 1,  3, 1}, // #1301
  {DBGFIELD("VPTESTMBZ128rm_VPTESTMBZ128rmk_VPTESTMDZ128rm_VPTESTMDZ128rmb_VPTESTMDZ128rmbk_VPTESTMDZ128rmk_VPTESTMQZ128rm_VPTESTMQZ128rmb_VPTESTMQZ128rmbk_VPTESTMQZ128rmk_VPTESTMWZ128rm_VPTESTMWZ128rmk_VPTESTNMBZ128rm_VPTESTNMBZ128rmk_VPTESTNMDZ128rm_VPTESTNMDZ128rmb_VPTESTNMDZ128rmbk_VPTESTNMDZ128rmk_VPTESTNMQZ128rm_VPTESTNMQZ128rmb_VPTESTNMQZ128rmbk_VPTESTNMQZ128rmk_VPTESTNMWZ128rm_VPTESTNMWZ128rmk") 1, false, false, false, 2385, 5,  6, 1,  3, 1}, // #1302
  {DBGFIELD("CVTPS2PDrm_VCVTPS2PDrm") 2, false, false, false, 2438, 7, 24, 1,  0, 0}, // #1303
  {DBGFIELD("VALIGNDZ256rmbi_VALIGNDZ256rmbik_VALIGNDZ256rmbikz_VALIGNDZ256rmi_VALIGNDZ256rmik_VALIGNDZ256rmikz_VALIGNQZ256rmbi_VALIGNQZ256rmbik_VALIGNQZ256rmbikz_VALIGNQZ256rmi_VALIGNQZ256rmik_VALIGNQZ256rmikz") 2, false, false, false, 2733, 6,  6, 1,  3, 1}, // #1304
  {DBGFIELD("VALIGNDZrmbi_VALIGNDZrmbik_VALIGNDZrmbikz_VALIGNDZrmi_VALIGNDZrmik_VALIGNDZrmikz_VALIGNQZrmbi_VALIGNQZrmbik_VALIGNQZrmbikz_VALIGNQZrmi_VALIGNQZrmik_VALIGNQZrmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1305
  {DBGFIELD("VPMAXSQZ256rm_VPMAXSQZ256rmb_VPMAXSQZ256rmbk_VPMAXSQZ256rmbkz_VPMAXSQZ256rmk_VPMAXSQZ256rmkz_VPMAXUQZ256rm_VPMAXUQZ256rmb_VPMAXUQZ256rmbk_VPMAXUQZ256rmbkz_VPMAXUQZ256rmk_VPMAXUQZ256rmkz_VPMINSQZ256rm_VPMINSQZ256rmb_VPMINSQZ256rmbk_VPMINSQZ256rmbkz_VPMINSQZ256rmk_VPMINSQZ256rmkz_VPMINUQZ256rm_VPMINUQZ256rmb_VPMINUQZ256rmbk_VPMINUQZ256rmbkz_VPMINUQZ256rmk_VPMINUQZ256rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1306
  {DBGFIELD("VPMAXSQZrm_VPMAXSQZrmb_VPMAXSQZrmbk_VPMAXSQZrmbkz_VPMAXSQZrmk_VPMAXSQZrmkz_VPMAXUQZrm_VPMAXUQZrmb_VPMAXUQZrmbk_VPMAXUQZrmbkz_VPMAXUQZrmk_VPMAXUQZrmkz_VPMINSQZrm_VPMINSQZrmb_VPMINSQZrmbk_VPMINSQZrmbkz_VPMINSQZrmk_VPMINSQZrmkz_VPMINUQZrm_VPMINUQZrmb_VPMINUQZrmbk_VPMINUQZrmbkz_VPMINUQZrmk_VPMINUQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1307
  {DBGFIELD("VCMPPDZ256rmbi_VCMPPDZ256rmbik_VCMPPDZ256rmi_VCMPPDZ256rmik_VCMPPSZ256rmbi_VCMPPSZ256rmbik_VCMPPSZ256rmi_VCMPPSZ256rmik_VFPCLASSPDZ256rm_VFPCLASSPDZ256rmb_VFPCLASSPDZ256rmbk_VFPCLASSPDZ256rmk_VFPCLASSPSZ256rm_VFPCLASSPSZ256rmb_VFPCLASSPSZ256rmbk_VFPCLASSPSZ256rmk") 2, false, false, false, 2727, 6,  6, 1,  3, 1}, // #1308
  {DBGFIELD("VCMPPDZrmbi_VCMPPDZrmbik_VCMPPDZrmi_VCMPPDZrmik_VCMPPSZrmbi_VCMPPSZrmbik_VCMPPSZrmi_VCMPPSZrmik_VFPCLASSPDZrm_VFPCLASSPDZrmb_VFPCLASSPDZrmbk_VFPCLASSPDZrmk_VFPCLASSPSZrm_VFPCLASSPSZrmb_VFPCLASSPSZrmbk_VFPCLASSPSZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1309
  {DBGFIELD("VPCMPBZ256rmi_VPCMPBZ256rmik_VPCMPDZ256rmi_VPCMPDZ256rmib_VPCMPDZ256rmibk_VPCMPDZ256rmik_VPCMPEQBZ256rm_VPCMPEQBZ256rmk_VPCMPEQDZ256rm_VPCMPEQDZ256rmb_VPCMPEQDZ256rmbk_VPCMPEQDZ256rmk_VPCMPEQQZ256rm_VPCMPEQQZ256rmb_VPCMPEQQZ256rmbk_VPCMPEQQZ256rmk_VPCMPEQWZ256rm_VPCMPEQWZ256rmk_VPCMPGTBZ256rm_VPCMPGTBZ256rmk_VPCMPGTDZ256rm_VPCMPGTDZ256rmb_VPCMPGTDZ256rmbk_VPCMPGTDZ256rmk_VPCMPGTQZ256rm_VPCMPGTQZ256rmb_VPCMPGTQZ256rmbk_VPCMPGTQZ256rmk_VPCMPGTWZ256rm_VPCMPGTWZ256rmk_VPCMPQZ256rmi_VPCMPQZ256rmib_VPCMPQZ256rmibk_VPCMPQZ256rmik_VPCMPUBZ256rmi_VPCMPUBZ256rmik_VPCMPUDZ256rmi_VPCMPUDZ256rmib_VPCMPUDZ256rmibk_VPCMPUDZ256rmik_VPCMPUQZ256rmi_VPCMPUQZ256rmib_VPCMPUQZ256rmibk_VPCMPUQZ256rmik_VPCMPUWZ256rmi_VPCMPUWZ256rmik_VPCMPWZ256rmi_VPCMPWZ256rmik") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1310
  {DBGFIELD("VPCMPBZrmi_VPCMPBZrmik_VPCMPDZrmi_VPCMPDZrmib_VPCMPDZrmibk_VPCMPDZrmik_VPCMPEQBZrm_VPCMPEQBZrmk_VPCMPEQDZrm_VPCMPEQDZrmb_VPCMPEQDZrmbk_VPCMPEQDZrmk_VPCMPEQQZrm_VPCMPEQQZrmb_VPCMPEQQZrmbk_VPCMPEQQZrmk_VPCMPEQWZrm_VPCMPEQWZrmk_VPCMPGTBZrm_VPCMPGTBZrmk_VPCMPGTDZrm_VPCMPGTDZrmb_VPCMPGTDZrmbk_VPCMPGTDZrmk_VPCMPGTQZrm_VPCMPGTQZrmb_VPCMPGTQZrmbk_VPCMPGTQZrmk_VPCMPGTWZrm_VPCMPGTWZrmk_VPCMPQZrmi_VPCMPQZrmib_VPCMPQZrmibk_VPCMPQZrmik_VPCMPUBZrmi_VPCMPUBZrmik_VPCMPUDZrmi_VPCMPUDZrmib_VPCMPUDZrmibk_VPCMPUDZrmik_VPCMPUQZrmi_VPCMPUQZrmib_VPCMPUQZrmibk_VPCMPUQZrmik_VPCMPUWZrmi_VPCMPUWZrmik_VPCMPWZrmi_VPCMPWZrmik") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1311
  {DBGFIELD("VPTESTMBZ256rm_VPTESTMBZ256rmk_VPTESTMDZ256rm_VPTESTMDZ256rmb_VPTESTMDZ256rmbk_VPTESTMDZ256rmk_VPTESTMQZ256rm_VPTESTMQZ256rmb_VPTESTMQZ256rmbk_VPTESTMQZ256rmk_VPTESTMWZ256rm_VPTESTMWZ256rmk_VPTESTNMBZ256rm_VPTESTNMBZ256rmk_VPTESTNMDZ256rm_VPTESTNMDZ256rmb_VPTESTNMDZ256rmbk_VPTESTNMDZ256rmk_VPTESTNMQZ256rm_VPTESTNMQZ256rmb_VPTESTNMQZ256rmbk_VPTESTNMQZ256rmk_VPTESTNMWZ256rm_VPTESTNMWZ256rmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1312
  {DBGFIELD("VPTESTMBZrm_VPTESTMBZrmk_VPTESTMDZrm_VPTESTMDZrmb_VPTESTMDZrmbk_VPTESTMDZrmk_VPTESTMQZrm_VPTESTMQZrmb_VPTESTMQZrmbk_VPTESTMQZrmk_VPTESTMWZrm_VPTESTMWZrmk_VPTESTNMBZrm_VPTESTNMBZrmk_VPTESTNMDZrm_VPTESTNMDZrmb_VPTESTNMDZrmbk_VPTESTNMDZrmk_VPTESTNMQZrm_VPTESTNMQZrmb_VPTESTNMQZrmbk_VPTESTNMQZrmk_VPTESTNMWZrm_VPTESTNMWZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1313
  {DBGFIELD("VCVTDQ2PDZ128rm_VCVTDQ2PDZ128rmb_VCVTDQ2PDZ128rmbk_VCVTDQ2PDZ128rmbkz_VCVTDQ2PDZ128rmk_VCVTDQ2PDZ128rmkz_VCVTQQ2PDZ128rm_VCVTQQ2PDZ128rmb_VCVTQQ2PDZ128rmbk_VCVTQQ2PDZ128rmbkz_VCVTQQ2PDZ128rmk_VCVTQQ2PDZ128rmkz_VCVTUDQ2PDZ128rm_VCVTUDQ2PDZ128rmb_VCVTUDQ2PDZ128rmbk_VCVTUDQ2PDZ128rmbkz_VCVTUDQ2PDZ128rmk_VCVTUDQ2PDZ128rmkz_VCVTUQQ2PDZ128rm_VCVTUQQ2PDZ128rmb_VCVTUQQ2PDZ128rmbk_VCVTUQQ2PDZ128rmbkz_VCVTUQQ2PDZ128rmk_VCVTUQQ2PDZ128rmkz") 2, false, false, false, 2438, 7, 24, 1,  0, 0}, // #1314
  {DBGFIELD("VCVTDQ2PSZ128rm_VCVTDQ2PSZ128rmb_VCVTDQ2PSZ128rmbk_VCVTDQ2PSZ128rmbkz_VCVTDQ2PSZ128rmk_VCVTDQ2PSZ128rmkz_CVTDQ2PSrm_VCVTDQ2PSrm_VCVTQQ2PSZ128rm_VCVTQQ2PSZ128rmb_VCVTQQ2PSZ128rmbk_VCVTQQ2PSZ128rmbkz_VCVTQQ2PSZ128rmk_VCVTQQ2PSZ128rmkz_VCVTUDQ2PSZ128rm_VCVTUDQ2PSZ128rmb_VCVTUDQ2PSZ128rmbk_VCVTUDQ2PSZ128rmbkz_VCVTUDQ2PSZ128rmk_VCVTUDQ2PSZ128rmkz_VCVTUQQ2PSZ128rm_VCVTUQQ2PSZ128rmb_VCVTUQQ2PSZ128rmbk_VCVTUQQ2PSZ128rmbkz_VCVTUQQ2PSZ128rmk_VCVTUQQ2PSZ128rmkz") 1, false, false, false, 2438, 7, 22, 1,  0, 0}, // #1315
  {DBGFIELD("VCVTPD2QQZ128rm_VCVTPD2QQZ128rmb_VCVTPD2QQZ128rmbk_VCVTPD2QQZ128rmbkz_VCVTPD2QQZ128rmk_VCVTPD2QQZ128rmkz_VCVTPD2UQQZ128rm_VCVTPD2UQQZ128rmb_VCVTPD2UQQZ128rmbk_VCVTPD2UQQZ128rmbkz_VCVTPD2UQQZ128rmk_VCVTPD2UQQZ128rmkz_VCVTTPD2QQZ128rm_VCVTTPD2QQZ128rmb_VCVTTPD2QQZ128rmbk_VCVTTPD2QQZ128rmbkz_VCVTTPD2QQZ128rmk_VCVTTPD2QQZ128rmkz_VCVTTPD2UQQZ128rm_VCVTTPD2UQQZ128rmb_VCVTTPD2UQQZ128rmbk_VCVTTPD2UQQZ128rmbkz_VCVTTPD2UQQZ128rmk_VCVTTPD2UQQZ128rmkz") 2, false, false, false, 2438, 7, 24, 1,  0, 0}, // #1316
  {DBGFIELD("VCVTPH2PSZ128rm_VCVTPH2PSZ128rmk_VCVTPH2PSZ128rmkz") 3, false, false, false, 2456, 7, 24, 1,  0, 0}, // #1317
  {DBGFIELD("VCVTPS2DQZ128rm_VCVTPS2DQZ128rmb_VCVTPS2DQZ128rmbk_VCVTPS2DQZ128rmbkz_VCVTPS2DQZ128rmk_VCVTPS2DQZ128rmkz_CVTPS2DQrm_VCVTPS2DQrm_VCVTPS2QQZ128rm_VCVTPS2QQZ128rmb_VCVTPS2QQZ128rmbk_VCVTPS2QQZ128rmbkz_VCVTPS2QQZ128rmk_VCVTPS2QQZ128rmkz_VCVTPS2UDQZ128rm_VCVTPS2UDQZ128rmb_VCVTPS2UDQZ128rmbk_VCVTPS2UDQZ128rmbkz_VCVTPS2UDQZ128rmk_VCVTPS2UDQZ128rmkz_VCVTPS2UQQZ128rm_VCVTPS2UQQZ128rmb_VCVTPS2UQQZ128rmbk_VCVTPS2UQQZ128rmbkz_VCVTPS2UQQZ128rmk_VCVTPS2UQQZ128rmkz_VCVTTPS2DQZ128rm_VCVTTPS2DQZ128rmb_VCVTTPS2DQZ128rmbk_VCVTTPS2DQZ128rmbkz_VCVTTPS2DQZ128rmk_VCVTTPS2DQZ128rmkz_CVTTPS2DQrm_VCVTTPS2DQrm_VCVTTPS2QQZ128rm_VCVTTPS2QQZ128rmb_VCVTTPS2QQZ128rmbk_VCVTTPS2QQZ128rmbkz_VCVTTPS2QQZ128rmk_VCVTTPS2QQZ128rmkz_VCVTTPS2UDQZ128rm_VCVTTPS2UDQZ128rmb_VCVTTPS2UDQZ128rmbk_VCVTTPS2UDQZ128rmbkz_VCVTTPS2UDQZ128rmk_VCVTTPS2UDQZ128rmkz_VCVTTPS2UQQZ128rm_VCVTTPS2UQQZ128rmb_VCVTTPS2UQQZ128rmbk_VCVTTPS2UQQZ128rmbkz_VCVTTPS2UQQZ128rmk_VCVTTPS2UQQZ128rmkz") 1, false, false, false, 2438, 7, 22, 1,  0, 0}, // #1318
  {DBGFIELD("VCVTPS2PDZ128rm_VCVTPS2PDZ128rmb_VCVTPS2PDZ128rmbk_VCVTPS2PDZ128rmbkz_VCVTPS2PDZ128rmk_VCVTPS2PDZ128rmkz") 2, false, false, false, 2438, 7, 24, 1,  0, 0}, // #1319
  {DBGFIELD("VCVTSS2SDZrm_VCVTSS2SDZrm_Int_VCVTSS2SDZrm_Intk_VCVTSS2SDZrm_Intkz_CVTSS2SDrm_CVTSS2SDrm_Int_VCVTSS2SDrm_VCVTSS2SDrm_Int") 1, false, false, false, 2456, 7, 22, 1,  3, 1}, // #1320
  {DBGFIELD("VEXPANDPDZ128rm_VEXPANDPDZ128rmk_VEXPANDPDZ128rmkz_VEXPANDPSZ128rm_VEXPANDPSZ128rmk_VEXPANDPSZ128rmkz_VPEXPANDDZ128rm_VPEXPANDDZ128rmk_VPEXPANDDZ128rmkz_VPEXPANDQZ128rm_VPEXPANDQZ128rmk_VPEXPANDQZ128rmkz") 1, false, false, false, 2744, 5,  3, 1,  3, 1}, // #1321
  {DBGFIELD("VCVTDQ2PSYrm")       2, false, false, false, 2456, 7, 22, 1,  0, 0}, // #1322
  {DBGFIELD("VCVTPS2PDYrm")       5, false, false, false, 2456, 7, 24, 1,  0, 0}, // #1323
  {DBGFIELD("VCVTDQ2PDZ256rm_VCVTDQ2PDZ256rmb_VCVTDQ2PDZ256rmbk_VCVTDQ2PDZ256rmbkz_VCVTDQ2PDZ256rmk_VCVTDQ2PDZ256rmkz_VCVTQQ2PDZ256rm_VCVTQQ2PDZ256rmb_VCVTQQ2PDZ256rmbk_VCVTQQ2PDZ256rmbkz_VCVTQQ2PDZ256rmk_VCVTQQ2PDZ256rmkz_VCVTUDQ2PDZ256rm_VCVTUDQ2PDZ256rmb_VCVTUDQ2PDZ256rmbk_VCVTUDQ2PDZ256rmbkz_VCVTUDQ2PDZ256rmk_VCVTUDQ2PDZ256rmkz_VCVTUQQ2PDZ256rm_VCVTUQQ2PDZ256rmb_VCVTUQQ2PDZ256rmbk_VCVTUQQ2PDZ256rmbkz_VCVTUQQ2PDZ256rmk_VCVTUQQ2PDZ256rmkz") 5, false, false, false, 2456, 7, 24, 1,  0, 0}, // #1324
  {DBGFIELD("VCVTDQ2PDZrm_VCVTDQ2PDZrmb_VCVTDQ2PDZrmbk_VCVTDQ2PDZrmbkz_VCVTDQ2PDZrmk_VCVTDQ2PDZrmkz_VCVTQQ2PDZrm_VCVTQQ2PDZrmb_VCVTQQ2PDZrmbk_VCVTQQ2PDZrmbkz_VCVTQQ2PDZrmk_VCVTQQ2PDZrmkz_VCVTUDQ2PDZrm_VCVTUDQ2PDZrmb_VCVTUDQ2PDZrmbk_VCVTUDQ2PDZrmbkz_VCVTUDQ2PDZrmk_VCVTUDQ2PDZrmkz_VCVTUQQ2PDZrm_VCVTUQQ2PDZrmb_VCVTUQQ2PDZrmbk_VCVTUQQ2PDZrmbkz_VCVTUQQ2PDZrmk_VCVTUQQ2PDZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1325
  {DBGFIELD("VCVTDQ2PSZ256rm_VCVTDQ2PSZ256rmb_VCVTDQ2PSZ256rmbk_VCVTDQ2PSZ256rmbkz_VCVTDQ2PSZ256rmk_VCVTDQ2PSZ256rmkz_VCVTQQ2PSZ256rm_VCVTQQ2PSZ256rmb_VCVTQQ2PSZ256rmbk_VCVTQQ2PSZ256rmbkz_VCVTQQ2PSZ256rmk_VCVTQQ2PSZ256rmkz_VCVTUDQ2PSZ256rm_VCVTUDQ2PSZ256rmb_VCVTUDQ2PSZ256rmbk_VCVTUDQ2PSZ256rmbkz_VCVTUDQ2PSZ256rmk_VCVTUDQ2PSZ256rmkz_VCVTUQQ2PSZ256rm_VCVTUQQ2PSZ256rmb_VCVTUQQ2PSZ256rmbk_VCVTUQQ2PSZ256rmbkz_VCVTUQQ2PSZ256rmk_VCVTUQQ2PSZ256rmkz") 2, false, false, false, 2456, 7, 22, 1,  0, 0}, // #1326
  {DBGFIELD("VCVTDQ2PSZrm_VCVTDQ2PSZrmb_VCVTDQ2PSZrmbk_VCVTDQ2PSZrmbkz_VCVTDQ2PSZrmk_VCVTDQ2PSZrmkz_VCVTUDQ2PSZrm_VCVTUDQ2PSZrmb_VCVTUDQ2PSZrmbk_VCVTUDQ2PSZrmbkz_VCVTUDQ2PSZrmk_VCVTUDQ2PSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1327
  {DBGFIELD("VCVTPH2PSZ256rm_VCVTPH2PSZ256rmk_VCVTPH2PSZ256rmkz") 7, false, false, false, 2456, 7, 24, 1,  0, 0}, // #1328
  {DBGFIELD("VCVTPH2PSZrm_VCVTPH2PSZrmk_VCVTPH2PSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1329
  {DBGFIELD("VCVTPS2PDZ256rm_VCVTPS2PDZ256rmb_VCVTPS2PDZ256rmbk_VCVTPS2PDZ256rmbkz_VCVTPS2PDZ256rmk_VCVTPS2PDZ256rmkz") 5, false, false, false, 2456, 7, 24, 1,  0, 0}, // #1330
  {DBGFIELD("VCVTPS2PDZrm_VCVTPS2PDZrmb_VCVTPS2PDZrmbk_VCVTPS2PDZrmbkz_VCVTPS2PDZrmk_VCVTPS2PDZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1331
  {DBGFIELD("VCVTPD2QQZ256rm_VCVTPD2QQZ256rmb_VCVTPD2QQZ256rmbk_VCVTPD2QQZ256rmbkz_VCVTPD2QQZ256rmk_VCVTPD2QQZ256rmkz_VCVTTPD2QQZ256rm_VCVTTPD2QQZ256rmb_VCVTTPD2QQZ256rmbk_VCVTTPD2QQZ256rmbkz_VCVTTPD2QQZ256rmk_VCVTTPD2QQZ256rmkz_VCVTPD2UQQZ256rm_VCVTPD2UQQZ256rmb_VCVTPD2UQQZ256rmbk_VCVTPD2UQQZ256rmbkz_VCVTPD2UQQZ256rmk_VCVTPD2UQQZ256rmkz_VCVTTPD2UQQZ256rm_VCVTTPD2UQQZ256rmb_VCVTTPD2UQQZ256rmbk_VCVTTPD2UQQZ256rmbkz_VCVTTPD2UQQZ256rmk_VCVTTPD2UQQZ256rmkz") 4, false, false, false, 2749, 8, 24, 1,  0, 0}, // #1332
  {DBGFIELD("VCVTPD2QQZrm_VCVTPD2QQZrmb_VCVTPD2QQZrmbk_VCVTPD2QQZrmbkz_VCVTPD2QQZrmk_VCVTPD2QQZrmkz_VCVTTPD2QQZrm_VCVTTPD2QQZrmb_VCVTTPD2QQZrmbk_VCVTTPD2QQZrmbkz_VCVTTPD2QQZrmk_VCVTTPD2QQZrmkz_VCVTPD2UQQZrm_VCVTPD2UQQZrmb_VCVTPD2UQQZrmbk_VCVTPD2UQQZrmbkz_VCVTPD2UQQZrmk_VCVTPD2UQQZrmkz_VCVTTPD2UQQZrm_VCVTTPD2UQQZrmb_VCVTTPD2UQQZrmbk_VCVTTPD2UQQZrmbkz_VCVTTPD2UQQZrmk_VCVTTPD2UQQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1333
  {DBGFIELD("VCVTPS2DQYrm_VCVTTPS2DQYrm_VCVTPS2DQZ256rm_VCVTPS2DQZ256rmb_VCVTPS2DQZ256rmbk_VCVTPS2DQZ256rmbkz_VCVTPS2DQZ256rmk_VCVTPS2DQZ256rmkz_VCVTTPS2DQZ256rm_VCVTTPS2DQZ256rmb_VCVTTPS2DQZ256rmbk_VCVTTPS2DQZ256rmbkz_VCVTTPS2DQZ256rmk_VCVTTPS2DQZ256rmkz_VCVTPS2QQZ256rm_VCVTPS2QQZ256rmb_VCVTPS2QQZ256rmbk_VCVTPS2QQZ256rmbkz_VCVTPS2QQZ256rmk_VCVTPS2QQZ256rmkz_VCVTTPS2QQZ256rm_VCVTTPS2QQZ256rmb_VCVTTPS2QQZ256rmbk_VCVTTPS2QQZ256rmbkz_VCVTTPS2QQZ256rmk_VCVTTPS2QQZ256rmkz_VCVTPS2UDQZ256rm_VCVTPS2UDQZ256rmb_VCVTPS2UDQZ256rmbk_VCVTPS2UDQZ256rmbkz_VCVTPS2UDQZ256rmk_VCVTPS2UDQZ256rmkz_VCVTTPS2UDQZ256rm_VCVTTPS2UDQZ256rmb_VCVTTPS2UDQZ256rmbk_VCVTTPS2UDQZ256rmbkz_VCVTTPS2UDQZ256rmk_VCVTTPS2UDQZ256rmkz_VCVTPS2UQQZ256rm_VCVTPS2UQQZ256rmb_VCVTPS2UQQZ256rmbk_VCVTPS2UQQZ256rmbkz_VCVTPS2UQQZ256rmk_VCVTPS2UQQZ256rmkz_VCVTTPS2UQQZ256rm_VCVTTPS2UQQZ256rmb_VCVTTPS2UQQZ256rmbk_VCVTTPS2UQQZ256rmbkz_VCVTTPS2UQQZ256rmk_VCVTTPS2UQQZ256rmkz") 2, false, false, false, 2456, 7, 22, 1,  0, 0}, // #1334
  {DBGFIELD("VCVTPS2DQZrm_VCVTPS2DQZrmb_VCVTPS2DQZrmbk_VCVTPS2DQZrmbkz_VCVTPS2DQZrmk_VCVTPS2DQZrmkz_VCVTTPS2DQZrm_VCVTTPS2DQZrmb_VCVTTPS2DQZrmbk_VCVTTPS2DQZrmbkz_VCVTTPS2DQZrmk_VCVTTPS2DQZrmkz_VCVTPS2UDQZrm_VCVTPS2UDQZrmb_VCVTPS2UDQZrmbk_VCVTPS2UDQZrmbkz_VCVTPS2UDQZrmk_VCVTPS2UDQZrmkz_VCVTTPS2UDQZrm_VCVTTPS2UDQZrmb_VCVTTPS2UDQZrmbk_VCVTTPS2UDQZrmbkz_VCVTTPS2UDQZrmk_VCVTTPS2UDQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1335
  {DBGFIELD("VEXPANDPDZ256rm_VEXPANDPDZ256rmk_VEXPANDPDZ256rmkz_VEXPANDPDZrm_VEXPANDPDZrmk_VEXPANDPDZrmkz_VEXPANDPSZ256rm_VEXPANDPSZ256rmk_VEXPANDPSZ256rmkz_VEXPANDPSZrm_VEXPANDPSZrmk_VEXPANDPSZrmkz_VPEXPANDDZ256rm_VPEXPANDDZ256rmk_VPEXPANDDZ256rmkz_VPEXPANDDZrm_VPEXPANDDZrmk_VPEXPANDDZrmkz_VPEXPANDQZ256rm_VPEXPANDQZ256rmk_VPEXPANDQZ256rmkz_VPEXPANDQZrm_VPEXPANDQZrmk_VPEXPANDQZrmkz") 1, false, false, false, 2744, 5,  3, 1,  3, 1}, // #1336
  {DBGFIELD("CVTDQ2PDrm_VCVTDQ2PDrm") 2, false, false, false, 2438, 7, 24, 1,  0, 0}, // #1337
  {DBGFIELD("CVTPD2DQrm_CVTTPD2DQrm") 2, false, false, false, 2438, 7, 24, 1,  0, 0}, // #1338
  {DBGFIELD("VPCONFLICTQZ128rm_VPCONFLICTQZ128rmb_VPCONFLICTQZ128rmbk_VPCONFLICTQZ128rmbkz_VPCONFLICTQZ128rmk_VPCONFLICTQZ128rmkz") 1, false, false, false, 2385, 5,  6, 1,  0, 0}, // #1339
  {DBGFIELD("VPMULLQZ128rr_VPMULLQZ128rrk_VPMULLQZ128rrkz") 1, false, false, false, 2380, 4, 14, 1,  0, 0}, // #1340
  {DBGFIELD("VPMULLQZ256rr_VPMULLQZ256rrk_VPMULLQZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1341
  {DBGFIELD("VPMULLQZrr_VPMULLQZrrk_VPMULLQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1342
  {DBGFIELD("VPERMWZ128rm_VPERMWZ128rmk_VPERMWZ128rmkz") 1, false, false, false, 2744, 5,  3, 1,  3, 1}, // #1343
  {DBGFIELD("VCVTSD2USIZrm_Int_VCVTTSD2USIZrm_VCVTTSD2USIZrm_Int") 2, false, false, false, 2445, 11, 13, 1,  3, 1}, // #1344
  {DBGFIELD("VCVTSS2USI64Zrm_Int_VCVTTSS2USI64Zrm_VCVTTSS2USI64Zrm_Int") 2, false, false, false, 2445, 11, 13, 1,  3, 1}, // #1345
  {DBGFIELD("VCVTPS2QQZrm_VCVTPS2QQZrmb_VCVTPS2QQZrmbk_VCVTPS2QQZrmbkz_VCVTPS2QQZrmk_VCVTPS2QQZrmkz_VCVTTPS2QQZrm_VCVTTPS2QQZrmb_VCVTTPS2QQZrmbk_VCVTTPS2QQZrmbkz_VCVTTPS2QQZrmk_VCVTTPS2QQZrmkz_VCVTPS2UQQZrm_VCVTPS2UQQZrmb_VCVTPS2UQQZrmbk_VCVTPS2UQQZrmbkz_VCVTPS2UQQZrmk_VCVTPS2UQQZrmkz_VCVTTPS2UQQZrm_VCVTTPS2UQQZrmb_VCVTTPS2UQQZrmbk_VCVTTPS2UQQZrmbkz_VCVTTPS2UQQZrmk_VCVTTPS2UQQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1346
  {DBGFIELD("VPERMWZ256rm_VPERMWZ256rmk_VPERMWZ256rmkz_VPERMWZrm_VPERMWZrmk_VPERMWZrmkz") 1, false, false, false, 2744, 5,  3, 1,  3, 1}, // #1347
  {DBGFIELD("VCVTDQ2PDYrm")       5, false, false, false, 2456, 7, 24, 1,  0, 0}, // #1348
  {DBGFIELD("VPERMI2W128rm_VPERMI2W128rmk_VPERMI2W128rmkz_VPERMT2W128rm_VPERMT2W128rmk_VPERMT2W128rmkz") 1, false, false, false, 2744, 5,  3, 1,  3, 1}, // #1349
  {DBGFIELD("VCVTPD2DQZrm_VCVTPD2DQZrmb_VCVTPD2DQZrmbk_VCVTPD2DQZrmbkz_VCVTPD2DQZrmk_VCVTPD2DQZrmkz_VCVTPD2UDQZrm_VCVTPD2UDQZrmb_VCVTPD2UDQZrmbk_VCVTPD2UDQZrmbkz_VCVTPD2UDQZrmk_VCVTPD2UDQZrmkz_VCVTTPD2DQZrm_VCVTTPD2DQZrmb_VCVTTPD2DQZrmbk_VCVTTPD2DQZrmbkz_VCVTTPD2DQZrmk_VCVTTPD2DQZrmkz_VCVTTPD2UDQZrm_VCVTTPD2UDQZrmb_VCVTTPD2UDQZrmbk_VCVTTPD2UDQZrmbkz_VCVTTPD2UDQZrmk_VCVTTPD2UDQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1350
  {DBGFIELD("VCVTQQ2PSZrm_VCVTQQ2PSZrmb_VCVTQQ2PSZrmbk_VCVTQQ2PSZrmbkz_VCVTQQ2PSZrmk_VCVTQQ2PSZrmkz_VCVTUQQ2PSZrm_VCVTUQQ2PSZrmb_VCVTUQQ2PSZrmbk_VCVTUQQ2PSZrmbkz_VCVTUQQ2PSZrmk_VCVTUQQ2PSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1351
  {DBGFIELD("VPERMI2W256rm_VPERMI2W256rmk_VPERMI2W256rmkz_VPERMI2Wrm_VPERMI2Wrmk_VPERMI2Wrmkz_VPERMT2W256rm_VPERMT2W256rmk_VPERMT2W256rmkz_VPERMT2Wrm_VPERMT2Wrmk_VPERMT2Wrmkz") 1, false, false, false, 2744, 5,  3, 1,  3, 1}, // #1352
  {DBGFIELD("VPCONFLICTDZ128rm_VPCONFLICTDZ128rmb_VPCONFLICTDZ128rmbk_VPCONFLICTDZ128rmbkz_VPCONFLICTDZ128rmk_VPCONFLICTDZ128rmkz") 1, false, false, false, 2385, 5,  6, 1,  0, 0}, // #1353
  {DBGFIELD("VPMULLQZ128rm_VPMULLQZ128rmb_VPMULLQZ128rmbk_VPMULLQZ128rmbkz_VPMULLQZ128rmk_VPMULLQZ128rmkz") 1, false, false, false, 2379, 6, 22, 1,  3, 1}, // #1354
  {DBGFIELD("VPMULLQZ256rm_VPMULLQZ256rmb_VPMULLQZ256rmbk_VPMULLQZ256rmbkz_VPMULLQZ256rmk_VPMULLQZ256rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1355
  {DBGFIELD("VPMULLQZrm_VPMULLQZrmb_VPMULLQZrmbk_VPMULLQZrmbkz_VPMULLQZrmk_VPMULLQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1356
  {DBGFIELD("VGATHERQPSZ128rm_VPGATHERQDZ128rm_VGATHERDPDZ128rm_VPGATHERDQZ128rm_VGATHERQPDZ128rm_VPGATHERQQZ128rm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1357
  {DBGFIELD("VGATHERQPSZ256rm_VPGATHERQDZ256rm_VGATHERQPDZ256rm_VPGATHERQQZ256rm_VGATHERDPSZ128rm_VPGATHERDDZ128rm_VGATHERDPDZ256rm_VPGATHERDQZ256rm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1358
  {DBGFIELD("VGATHERDPSZ256rm_VPGATHERDDZ256rm_VGATHERDPDZrm_VPGATHERDQZrm_VGATHERQPDZrm_VPGATHERQQZrm_VGATHERQPSZrm_VPGATHERQDZrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1359
  {DBGFIELD("VGATHERDPSZrm_VPGATHERDDZrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1360
  {DBGFIELD("VPCONFLICTQZ256rr_VPCONFLICTQZ256rrk_VPCONFLICTQZ256rrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1361
  {DBGFIELD("VPCONFLICTQZ256rm_VPCONFLICTQZ256rmb_VPCONFLICTQZ256rmbk_VPCONFLICTQZ256rmbkz_VPCONFLICTQZ256rmk_VPCONFLICTQZ256rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1362
  {DBGFIELD("VPCONFLICTQZrr_VPCONFLICTQZrrk_VPCONFLICTQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1363
  {DBGFIELD("VPCONFLICTDZ256rm_VPCONFLICTDZ256rmb_VPCONFLICTDZ256rmbk_VPCONFLICTDZ256rmbkz_VPCONFLICTDZ256rmk_VPCONFLICTDZ256rmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1364
  {DBGFIELD("VPCONFLICTQZrm_VPCONFLICTQZrmb_VPCONFLICTQZrmbk_VPCONFLICTQZrmbkz_VPCONFLICTQZrmk_VPCONFLICTQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1365
  {DBGFIELD("VPCONFLICTDZrm_VPCONFLICTDZrmb_VPCONFLICTDZrmbk_VPCONFLICTDZrmbkz_VPCONFLICTDZrmk_VPCONFLICTDZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1366
  {DBGFIELD("VXORPSZ128rr_VXORPDZ128rr") 1, false, false, false, 2322, 3, 12, 1,  0, 0}, // #1367
  {DBGFIELD("VXORPSZ256rr_VXORPDZ256rr") 2, false, false, false, 2740, 3, 12, 1,  0, 0}, // #1368
  {DBGFIELD("VXORPSZrr_VXORPDZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1369
  {DBGFIELD("VPXORDZ128rr_VPXORQZ128rr") 1, false, false, false, 2322, 3, 12, 1,  0, 0}, // #1370
  {DBGFIELD("VPXORDZ256rr_VPXORQZ256rr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1371
  {DBGFIELD("VPXORDZrr_VPXORQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1372
  {DBGFIELD("VPSUBBZ128rr_VPSUBDZ128rr_VPSUBQZ128rr_VPSUBWZ128rr") 1, false, false, false, 2322, 3, 12, 1,  0, 0}, // #1373
  {DBGFIELD("VPSUBBZ256rr_VPSUBDZ256rr_VPSUBQZ256rr_VPSUBWZ256rr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1374
  {DBGFIELD("VPSUBBZrr_VPSUBDZrr_VPSUBQZrr_VPSUBWZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1375
  {DBGFIELD("VPBROADCASTDrr_VPBROADCASTQrr") 1, false, false, false, 2391, 4, 12, 1,  0, 0}, // #1376
  {DBGFIELD("INSERTPSrr_VINSERTPSZrr_VINSERTPSrr_MOVHLPSrr_MOVLHPSrr_VMOVHLPSZrr_VMOVHLPSrr_VMOVLHPSZrr_VMOVLHPSrr_MOVDDUPrr_VMOVDDUPrr_VPERMILPDZ128ri_VPERMILPDZ128rik_VPERMILPDZ128rikz_VPERMILPDri_VPERMILPSZ128ri_VPERMILPSZ128rik_VPERMILPSZ128rikz_VPERMILPSri_UNPCKHPDrr_UNPCKHPSrr_UNPCKLPDrr_UNPCKLPSrr_VUNPCKHPDZ128rr_VUNPCKHPDZ128rrk_VUNPCKHPDZ128rrkz_VUNPCKHPDrr_VUNPCKHPSZ128rr_VUNPCKHPSZ128rrk_VUNPCKHPSZ128rrkz_VUNPCKHPSrr_VUNPCKLPDZ128rr_VUNPCKLPDZ128rrk_VUNPCKLPDZ128rrkz_VUNPCKLPDrr_VUNPCKLPSZ128rr_VUNPCKLPSZ128rrk_VUNPCKLPSZ128rrkz_VUNPCKLPSrr") 1, false, false, false, 2580, 3, 12, 1,  0, 0}, // #1377
  {DBGFIELD("VMOVDDUPYrr_VPERMILPDYri_VPERMILPDZ256ri_VPERMILPDZ256rik_VPERMILPDZ256rikz_VPERMILPSYri_VPERMILPSZ256ri_VPERMILPSZ256rik_VPERMILPSZ256rikz_VUNPCKHPDYrr_VUNPCKHPDZ256rr_VUNPCKHPDZ256rrk_VUNPCKHPDZ256rrkz_VUNPCKHPSYrr_VUNPCKHPSZ256rr_VUNPCKHPSZ256rrk_VUNPCKHPSZ256rrkz_