#pragma once

enum CellSslError : u32
{
	CELL_SSL_ERROR_NOT_INITIALIZED       = 0x80740001,
	CELL_SSL_ERROR_ALREADY_INITIALIZED   = 0x80740002,
	CELL_SSL_ERROR_INITIALIZATION_FAILED = 0x80740003,
	CELL_SSL_ERROR_NO_BUFFER             = 0x80740004,
	CELL_SSL_ERROR_INVALID_CERTIFICATE   = 0x80740005,
	CELL_SSL_ERROR_UNRETRIEVABLE         = 0x80740006,
	CELL_SSL_ERROR_INVALID_FORMAT        = 0x80740007,
	CELL_SSL_ERROR_NOT_FOUND             = 0x80740008,
	CELL_SSL_ERROR_INVALID_TIME          = 0x80740031,
	CELL_SSL_ERROR_INAVLID_NEGATIVE_TIME = 0x80740032,
	CELL_SSL_ERROR_INCORRECT_TIME        = 0x80740033,
	CELL_SSL_ERROR_UNDEFINED_TIME_TYPE   = 0x80740034,
	CELL_SSL_ERROR_NO_MEMORY             = 0x80740035,
	CELL_SSL_ERROR_NO_STRING             = 0x80740036,
	CELL_SSL_ERROR_UNKNOWN_LOAD_CERT     = 0x80740037
};

// Certificate load flags
enum : u64
{
	CELL_SSL_LOAD_CERT_SCE01               = 0x0000000000000001ULL,
	CELL_SSL_LOAD_CERT_SCE02               = 0x0000000000000002ULL,
	CELL_SSL_LOAD_CERT_SCE03               = 0x0000000000000004ULL,
	CELL_SSL_LOAD_CERT_SCE04               = 0x0000000000000008ULL,
	CELL_SSL_LOAD_CERT_SCE05               = 0x0000000000000010ULL,
	CELL_SSL_LOAD_CERT_BALTIMORE_CT        = 0x0000000000000020ULL,
	CELL_SSL_LOAD_CERT_CLASS1_PCA_G2_V2    = 0x0000000000000040ULL,
	CELL_SSL_LOAD_CERT_CLASS1_PCA_G3_V2    = 0x0000000000000080ULL,
	CELL_SSL_LOAD_CERT_CLASS1_PCA_SS_V4    = 0x0000000000000100ULL,
	CELL_SSL_LOAD_CERT_CLASS2_PCA_G2_V2    = 0x0000000000000200ULL,
	CELL_SSL_LOAD_CERT_CLASS2_PCA_G3_V2    = 0x0000000000000400ULL,
	CELL_SSL_LOAD_CERT_CLASS2_PCA_SS_V4    = 0x0000000000000800ULL,
	CELL_SSL_LOAD_CERT_CLASS3_PCA_G2_V2    = 0x0000000000001000ULL,
	CELL_SSL_LOAD_CERT_CLASS3_PCA_G3_V2    = 0x0000000000002000ULL,
	CELL_SSL_LOAD_CERT_CLASS3_PCA_SS_V4    = 0x0000000000004000ULL,
	CELL_SSL_LOAD_CERT_CLASS4_PCA_G2_V2    = 0x0000000000008000ULL,
	CELL_SSL_LOAD_CERT_CLASS4_PCA_G3_V2    = 0x0000000000010000ULL,
	CELL_SSL_LOAD_CERT_ENTRUST_NET_SS_CA   = 0x0000000000020000ULL,
	CELL_SSL_LOAD_CERT_EQUIFAX_SEC_CA      = 0x0000000000040000ULL,
	CELL_SSL_LOAD_CERT_EQUIFAX_SEC_EBUS1   = 0x0000000000080000ULL,
	CELL_SSL_LOAD_CERT_GEOTRUST_GCA        = 0x0000000000100000ULL,
	CELL_SSL_LOAD_CERT_GLOBALSIGN_RCA      = 0x0000000000200000ULL,
	CELL_SSL_LOAD_CERT_GTE_CT_G_RCA        = 0x0000000000400000ULL,
	CELL_SSL_LOAD_CERT_GTE_CT_ROOT         = 0x0000000000800000ULL,
	CELL_SSL_LOAD_CERT_RSA1024_V1          = 0x0000000001000000ULL,
	CELL_SSL_LOAD_CERT_RSA2048_V3          = 0x0000000002000000ULL,
	CELL_SSL_LOAD_CERT_RSA_SECURE_SERVER   = 0x0000000004000000ULL,
	CELL_SSL_LOAD_CERT_THAWTE_PREM_SCA     = 0x0000000008000000ULL,
	CELL_SSL_LOAD_CERT_THAWTE_SCA          = 0x0000000010000000ULL,
	CELL_SSL_LOAD_CERT_VALICERT_CLASS2     = 0x0000000020000000ULL,
	CELL_SSL_LOAD_CERT_VERISIGN_TSA_CA     = 0x0000000040000000ULL,
	CELL_SSL_LOAD_CERT_AAA_CERT_SERVICES   = 0x0000000080000000ULL,
	CELL_SSL_LOAD_CERT_ADDTRUST_EXT_CA     = 0x0000000100000000ULL,
	CELL_SSL_LOAD_CERT_UTN_USERFIRST_HW    = 0x0000000200000000ULL,
	CELL_SSL_LOAD_CERT_EQUIFAX_SEC_G_EBUS1 = 0x0000000400000000ULL,
	CELL_SSL_LOAD_CERT_CLASS3_PCA_G5       = 0x0000000800000000ULL,
	CELL_SSL_LOAD_CERT_DIGICERT_HA_EV_RCA  = 0x0000001000000000ULL,
	CELL_SSL_LOAD_CERT_DIGICERT_A_ID_RCA   = 0x0000002000000000ULL,
	CELL_SSL_LOAD_CERT_DIGICERT_GLOBAL_RCA = 0x0000004000000000ULL,
	CELL_SSL_LOAD_CERT_CT_G_ROOT           = 0x0000008000000000ULL,
	CELL_SSL_LOAD_CERT_ENTRUST_CA2048      = 0x0000010000000000ULL,
	CELL_SSL_LOAD_CERT_ENTRUST_RCA         = 0x0000020000000000ULL,
	CELL_SSL_LOAD_CERT_GLOBALSIGN_RCA_R2   = 0x0000040000000000ULL,
	CELL_SSL_LOAD_CERT_GODADDY_CLASS2_CA   = 0x0000080000000000ULL,
	CELL_SSL_LOAD_CERT_STARFIELD_CLASS2_CA = 0x0000100000000000ULL,
	CELL_SSL_LOAD_CERT_STARFIELD_S_RC      = 0x0000200000000000ULL,
	CELL_SSL_LOAD_CERT_THATE_PRIMARY_RCA   = 0x0000400000000000ULL,
	CELL_SSL_LOAD_CERT_VALICERT_CLASS1_VA  = 0x0000800000000000ULL,
	CELL_SSL_LOAD_CERT_SECOM_RCA1          = 0x0001000000000000ULL,
	CELL_SSL_LOAD_CERT_SECURE_TRUST_CA     = 0x0002000000000000ULL,
	CELL_SSL_LOAD_CERT_ENTRUST_RCA_G2      = 0x0004000000000000ULL,
	CELL_SSL_LOAD_CERT_VERISIGN_U_RCA      = 0x0008000000000000ULL,
	CELL_SSL_LOAD_CERT_GODADDY_C2_CA_G2    = 0x0010000000000000ULL,
	CELL_SSL_LOAD_CERT_STARFIELD_C2_CA_G2  = 0x0020000000000000ULL,
	CELL_SSL_LOAD_CERT_STARFIELD_S_RC_G2   = 0x0040000000000000ULL,
	CELL_SSL_LOAD_CERT_STARTCOM_CA         = 0x0080000000000000ULL,
	CELL_SSL_LOAD_CERT_STARTCOM_CA_G2      = 0x0100000000000000ULL,
	CELL_SSL_LOAD_CERT_SECOM_RCA2          = 0x0200000000000000ULL,

	// Composite Flags

	CELL_SSL_LOAD_CERT_SCE =
	(
		CELL_SSL_LOAD_CERT_SCE01 |
		CELL_SSL_LOAD_CERT_SCE02 |
		CELL_SSL_LOAD_CERT_SCE03 |
		CELL_SSL_LOAD_CERT_SCE04 |
		CELL_SSL_LOAD_CERT_SCE05
	),
	CELL_SSL_LOAD_CERT_SHA256 =
	(
		CELL_SSL_LOAD_CERT_GLOBALSIGN_RCA_R2 |
		CELL_SSL_LOAD_CERT_ENTRUST_RCA_G2 |
		CELL_SSL_LOAD_CERT_VERISIGN_U_RCA |
		CELL_SSL_LOAD_CERT_GODADDY_C2_CA_G2 |
		CELL_SSL_LOAD_CERT_STARFIELD_C2_CA_G2 |
		CELL_SSL_LOAD_CERT_STARFIELD_S_RC_G2 |
		CELL_SSL_LOAD_CERT_STARTCOM_CA |
		CELL_SSL_LOAD_CERT_STARTCOM_CA_G2 |
		CELL_SSL_LOAD_CERT_SECOM_RCA2
	),
	CELL_SSL_LOAD_CERT_NORMAL =
	(
		CELL_SSL_LOAD_CERT_BALTIMORE_CT |
		CELL_SSL_LOAD_CERT_CLASS3_PCA_G2_V2 |
		CELL_SSL_LOAD_CERT_CLASS3_PCA_G3_V2 |
		CELL_SSL_LOAD_CERT_CLASS3_PCA_SS_V4 |
		CELL_SSL_LOAD_CERT_ENTRUST_NET_SS_CA |
		CELL_SSL_LOAD_CERT_EQUIFAX_SEC_CA |
		CELL_SSL_LOAD_CERT_EQUIFAX_SEC_EBUS1 |
		CELL_SSL_LOAD_CERT_GEOTRUST_GCA |
		CELL_SSL_LOAD_CERT_GLOBALSIGN_RCA |
		CELL_SSL_LOAD_CERT_GTE_CT_G_RCA |
		CELL_SSL_LOAD_CERT_RSA1024_V1 |
		CELL_SSL_LOAD_CERT_RSA2048_V3 |
		CELL_SSL_LOAD_CERT_THAWTE_PREM_SCA |
		CELL_SSL_LOAD_CERT_THAWTE_SCA |
		CELL_SSL_LOAD_CERT_VALICERT_CLASS2 |
		CELL_SSL_LOAD_CERT_AAA_CERT_SERVICES |
		CELL_SSL_LOAD_CERT_ADDTRUST_EXT_CA |
		CELL_SSL_LOAD_CERT_UTN_USERFIRST_HW |
		CELL_SSL_LOAD_CERT_EQUIFAX_SEC_G_EBUS1 |
		CELL_SSL_LOAD_CERT_CLASS3_PCA_G5 |
		CELL_SSL_LOAD_CERT_DIGICERT_HA_EV_RCA |
		CELL_SSL_LOAD_CERT_DIGICERT_A_ID_RCA |
		CELL_SSL_LOAD_CERT_DIGICERT_GLOBAL_RCA |
		CELL_SSL_LOAD_CERT_CT_G_ROOT |
		CELL_SSL_LOAD_CERT_ENTRUST_CA2048 |
		CELL_SSL_LOAD_CERT_ENTRUST_RCA |
		CELL_SSL_LOAD_CERT_GODADDY_CLASS2_CA |
		CELL_SSL_LOAD_CERT_STARFIELD_CLASS2_CA |
		CELL_SSL_LOAD_CERT_STARFIELD_S_RC |
		CELL_SSL_LOAD_CERT_THATE_PRIMARY_RCA |
		CELL_SSL_LOAD_CERT_VALICERT_CLASS1_VA |
		CELL_SSL_LOAD_CERT_SECOM_RCA1 |
		CELL_SSL_LOAD_CERT_SECURE_TRUST_CA |
		CELL_SSL_LOAD_CERT_SHA256
	),
	CELL_SSL_LOAD_CERT_ALL =
	(
		CELL_SSL_LOAD_CERT_SCE |
		CELL_SSL_LOAD_CERT_NORMAL
	),
	CELL_SSL_LOAD_CERT_OBSOLETE =
	(
		CELL_SSL_LOAD_CERT_RSA_SECURE_SERVER |
		CELL_SSL_LOAD_CERT_VERISIGN_TSA_CA |
		CELL_SSL_LOAD_CERT_GTE_CT_ROOT
	),
	CELL_SSL_LOAD_CERT_NOT_FOR_SERVER =
	(
		CELL_SSL_LOAD_CERT_CLASS1_PCA_G2_V2 |
		CELL_SSL_LOAD_CERT_CLASS1_PCA_G3_V2 |
		CELL_SSL_LOAD_CERT_CLASS1_PCA_SS_V4 |
		CELL_SSL_LOAD_CERT_CLASS2_PCA_G2_V2 |
		CELL_SSL_LOAD_CERT_CLASS2_PCA_G3_V2 |
		CELL_SSL_LOAD_CERT_CLASS2_PCA_SS_V4 |
		CELL_SSL_LOAD_CERT_CLASS4_PCA_G2_V2 |
		CELL_SSL_LOAD_CERT_CLASS4_PCA_G3_V2
	),
};

enum // Cipher
{
	CELL_SSL_CIPHER_UNKNOWN                         = -1,
	CELL_SSL_CIPHER_RSA_WITH_3DES_EDE_CBC_SHA       = 0,
	CELL_SSL_CIPHER_RSA_WITH_RC4_128_SHA            = 1,
	CELL_SSL_CIPHER_RSA_WITH_RC4_128_MD5            = 2,
	CELL_SSL_CIPHER_RSA_WITH_DES_CBC_SHA            = 3,
	CELL_SSL_CIPHER_RSA_EXPORT1024_WITH_DES_CBC_SHA = 4,
	CELL_SSL_CIPHER_RSA_EXPORT1024_WITH_RC4_56_SHA  = 5,
	CELL_SSL_CIPHER_RSA_EXPORT_WITH_DES40_CBC_SHA   = 6,
	CELL_SSL_CIPHER_RSA_EXPORT_WITH_RC2_CBC_40_MD5  = 7,
	CELL_SSL_CIPHER_RSA_EXPORT_WITH_RC4_40_MD5      = 8
};

enum // Version
{
	CELL_SSL_VERSION_UNKNOWN = -1,
	CELL_SSL_VERSION_TLS1    = 0,
	CELL_SSL_VERSION_SSL3    = 1
};

enum // Other Constants
{
	CELL_SSL_MD5_FINGERPRINT_MAX_SIZE = 20
};

enum SpecialCerts
{
	BaltimoreCert           = 6,
	Class3G2V2Cert          = 13,
	ClassSSV4Cert           = 15,
	EntrustNetCert          = 18,
	GTECyberTrustGlobalCert = 23
};

struct ssl_manager
{
	atomic_t<bool> is_init{ false };
};

b8 _cellSslIsInitd();
