/*
 * Decompiled with CFR 0.152.
 */
package liqp;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.ZoneId;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import liqp.parser.LiquidSupport;

public class RenderSettings {
    public static final Locale DEFAULT_LOCALE = Locale.ENGLISH;
    public final boolean strictVariables;
    public final boolean showExceptionsFromInclude;
    public final boolean raiseExceptionsInStrictMode;
    public final EvaluateMode evaluateMode;
    public final Locale locale;
    public final ZoneId defaultTimeZone;

    public Map<String, Object> evaluate(ObjectMapper mapper, Map<String, Object> variables) {
        if (this.evaluateMode == EvaluateMode.EAGER) {
            return LiquidSupport.LiquidSupportFromInspectable.objectToMap(mapper, variables);
        }
        return variables;
    }

    public LiquidSupport evaluate(ObjectMapper mapper, Object variable) {
        if (variable instanceof LiquidSupport) {
            return (LiquidSupport)variable;
        }
        return new LiquidSupport.LiquidSupportFromInspectable(mapper, variable);
    }

    private RenderSettings(boolean strictVariables, boolean showExceptionsFromInclude, boolean raiseExceptionsInStrictMode, EvaluateMode evaluateMode, Locale locale, ZoneId defaultTimeZone) {
        this.strictVariables = strictVariables;
        this.showExceptionsFromInclude = showExceptionsFromInclude;
        this.raiseExceptionsInStrictMode = raiseExceptionsInStrictMode;
        this.evaluateMode = evaluateMode;
        this.locale = locale;
        this.defaultTimeZone = defaultTimeZone;
    }

    public static class Builder {
        boolean strictVariables = false;
        boolean showExceptionsFromInclude;
        boolean raiseExceptionsInStrictMode = true;
        EvaluateMode evaluateMode = EvaluateMode.LAZY;
        Locale locale = DEFAULT_LOCALE;
        ZoneId defaultTimeZone;

        public Builder withStrictVariables(boolean strictVariables) {
            this.strictVariables = strictVariables;
            this.showExceptionsFromInclude = false;
            return this;
        }

        public Builder withRaiseExceptionsInStrictMode(boolean raiseExceptionsInStrictMode) {
            this.raiseExceptionsInStrictMode = raiseExceptionsInStrictMode;
            return this;
        }

        public Builder withShowExceptionsFromInclude(boolean showExceptionsFromInclude) {
            this.showExceptionsFromInclude = showExceptionsFromInclude;
            return this;
        }

        public Builder withEvaluateMode(EvaluateMode evaluateMode) {
            this.evaluateMode = evaluateMode;
            return this;
        }

        public Builder withLocale(Locale locale) {
            Objects.requireNonNull(locale);
            this.locale = locale;
            return this;
        }

        public Builder withDefaultTimeZone(ZoneId defaultTimeZone) {
            this.defaultTimeZone = defaultTimeZone;
            return this;
        }

        public RenderSettings build() {
            if (this.defaultTimeZone == null) {
                this.defaultTimeZone = ZoneId.systemDefault();
            }
            return new RenderSettings(this.strictVariables, this.showExceptionsFromInclude, this.raiseExceptionsInStrictMode, this.evaluateMode, this.locale, this.defaultTimeZone);
        }
    }

    public static enum EvaluateMode {
        LAZY,
        EAGER;

    }
}

