/*
 * This declarations of the PIC16F1717 MCU.
 *
 * This file is part of the GNU PIC library for SDCC, originally
 * created by Molnar Karoly <molnarkaroly@users.sf.net> 2016.
 *
 * This file is generated automatically by the cinc2h.pl, 2016-04-13 17:23:12 UTC.
 *
 * SDCC is licensed under the GNU Public license (GPL) v2. Note that
 * this license covers the code to the compiler and other executables,
 * but explicitly does not cover any code or objects generated by sdcc.
 *
 * For pic device libraries and header files which are derived from
 * Microchip header (.inc) and linker script (.lkr) files Microchip
 * requires that "The header files should state that they are only to be
 * used with authentic Microchip devices" which makes them incompatible
 * with the GPL. Pic device libraries and header files are located at
 * non-free/lib and non-free/include directories respectively.
 * Sdcc should be run with the --use-non-free command line option in
 * order to include non-free header files and libraries.
 *
 * See http://sdcc.sourceforge.net/ for the latest information on sdcc.
 */

#ifndef __PIC16F1717_H__
#define __PIC16F1717_H__

//==============================================================================
//
//	Register Addresses
//
//==============================================================================

#ifndef NO_ADDR_DEFINES

#define INDF0_ADDR              0x0000
#define INDF1_ADDR              0x0001
#define PCL_ADDR                0x0002
#define STATUS_ADDR             0x0003
#define FSR0_ADDR               0x0004
#define FSR0L_ADDR              0x0004
#define FSR0H_ADDR              0x0005
#define FSR1_ADDR               0x0006
#define FSR1L_ADDR              0x0006
#define FSR1H_ADDR              0x0007
#define BSR_ADDR                0x0008
#define WREG_ADDR               0x0009
#define PCLATH_ADDR             0x000A
#define INTCON_ADDR             0x000B
#define PORTA_ADDR              0x000C
#define PORTB_ADDR              0x000D
#define PORTC_ADDR              0x000E
#define PORTD_ADDR              0x000F
#define PORTE_ADDR              0x0010
#define PIR1_ADDR               0x0011
#define PIR2_ADDR               0x0012
#define PIR3_ADDR               0x0013
#define TMR0_ADDR               0x0015
#define TMR1_ADDR               0x0016
#define TMR1L_ADDR              0x0016
#define TMR1H_ADDR              0x0017
#define T1CON_ADDR              0x0018
#define T1GCON_ADDR             0x0019
#define TMR2_ADDR               0x001A
#define PR2_ADDR                0x001B
#define T2CON_ADDR              0x001C
#define TRISA_ADDR              0x008C
#define TRISB_ADDR              0x008D
#define TRISC_ADDR              0x008E
#define TRISD_ADDR              0x008F
#define TRISE_ADDR              0x0090
#define PIE1_ADDR               0x0091
#define PIE2_ADDR               0x0092
#define PIE3_ADDR               0x0093
#define OPTION_REG_ADDR         0x0095
#define PCON_ADDR               0x0096
#define WDTCON_ADDR             0x0097
#define OSCTUNE_ADDR            0x0098
#define OSCCON_ADDR             0x0099
#define OSCSTAT_ADDR            0x009A
#define ADRES_ADDR              0x009B
#define ADRESL_ADDR             0x009B
#define ADRESH_ADDR             0x009C
#define ADCON0_ADDR             0x009D
#define ADCON1_ADDR             0x009E
#define ADCON2_ADDR             0x009F
#define LATA_ADDR               0x010C
#define LATB_ADDR               0x010D
#define LATC_ADDR               0x010E
#define LATD_ADDR               0x010F
#define LATE_ADDR               0x0110
#define CM1CON0_ADDR            0x0111
#define CM1CON1_ADDR            0x0112
#define CM2CON0_ADDR            0x0113
#define CM2CON1_ADDR            0x0114
#define CMOUT_ADDR              0x0115
#define BORCON_ADDR             0x0116
#define FVRCON_ADDR             0x0117
#define DAC1CON0_ADDR           0x0118
#define DAC1CON1_ADDR           0x0119
#define DAC2CON0_ADDR           0x011A
#define DAC2CON1_ADDR           0x011B
#define DAC2REF_ADDR            0x011B
#define ZCD1CON_ADDR            0x011C
#define ANSELA_ADDR             0x018C
#define ANSELB_ADDR             0x018D
#define ANSELC_ADDR             0x018E
#define ANSELD_ADDR             0x018F
#define ANSELE_ADDR             0x0190
#define PMADR_ADDR              0x0191
#define PMADRL_ADDR             0x0191
#define PMADRH_ADDR             0x0192
#define PMDAT_ADDR              0x0193
#define PMDATL_ADDR             0x0193
#define PMDATH_ADDR             0x0194
#define PMCON1_ADDR             0x0195
#define PMCON2_ADDR             0x0196
#define VREGCON_ADDR            0x0197
#define RC1REG_ADDR             0x0199
#define RCREG_ADDR              0x0199
#define RCREG1_ADDR             0x0199
#define TX1REG_ADDR             0x019A
#define TXREG_ADDR              0x019A
#define TXREG1_ADDR             0x019A
#define SP1BRG_ADDR             0x019B
#define SP1BRGL_ADDR            0x019B
#define SPBRG_ADDR              0x019B
#define SPBRG1_ADDR             0x019B
#define SPBRGL_ADDR             0x019B
#define SP1BRGH_ADDR            0x019C
#define SPBRGH_ADDR             0x019C
#define SPBRGH1_ADDR            0x019C
#define RC1STA_ADDR             0x019D
#define RCSTA_ADDR              0x019D
#define RCSTA1_ADDR             0x019D
#define TX1STA_ADDR             0x019E
#define TXSTA_ADDR              0x019E
#define TXSTA1_ADDR             0x019E
#define BAUD1CON_ADDR           0x019F
#define BAUDCON_ADDR            0x019F
#define BAUDCON1_ADDR           0x019F
#define BAUDCTL_ADDR            0x019F
#define BAUDCTL1_ADDR           0x019F
#define WPUA_ADDR               0x020C
#define WPUB_ADDR               0x020D
#define WPUC_ADDR               0x020E
#define WPUD_ADDR               0x020F
#define WPUE_ADDR               0x0210
#define SSP1BUF_ADDR            0x0211
#define SSPBUF_ADDR             0x0211
#define SSP1ADD_ADDR            0x0212
#define SSPADD_ADDR             0x0212
#define SSP1MSK_ADDR            0x0213
#define SSPMSK_ADDR             0x0213
#define SSP1STAT_ADDR           0x0214
#define SSPSTAT_ADDR            0x0214
#define SSP1CON_ADDR            0x0215
#define SSP1CON1_ADDR           0x0215
#define SSPCON_ADDR             0x0215
#define SSPCON1_ADDR            0x0215
#define SSP1CON2_ADDR           0x0216
#define SSPCON2_ADDR            0x0216
#define SSP1CON3_ADDR           0x0217
#define SSPCON3_ADDR            0x0217
#define ODCONA_ADDR             0x028C
#define ODCONB_ADDR             0x028D
#define ODCONC_ADDR             0x028E
#define ODCOND_ADDR             0x028F
#define ODCONE_ADDR             0x0290
#define CCPR1_ADDR              0x0291
#define CCPR1L_ADDR             0x0291
#define CCPR1H_ADDR             0x0292
#define CCP1CON_ADDR            0x0293
#define ECCP1CON_ADDR           0x0293
#define CCPR2_ADDR              0x0298
#define CCPR2L_ADDR             0x0298
#define CCPR2H_ADDR             0x0299
#define CCP2CON_ADDR            0x029A
#define ECCP2CON_ADDR           0x029A
#define CCPTMRS_ADDR            0x029E
#define SLRCONA_ADDR            0x030C
#define SLRCONB_ADDR            0x030D
#define SLRCONC_ADDR            0x030E
#define SLRCOND_ADDR            0x030F
#define SLRCONE_ADDR            0x0310
#define INLVLA_ADDR             0x038C
#define INLVLB_ADDR             0x038D
#define INLVLC_ADDR             0x038E
#define INLVLD_ADDR             0x038F
#define INLVLE_ADDR             0x0390
#define IOCAP_ADDR              0x0391
#define IOCAN_ADDR              0x0392
#define IOCAF_ADDR              0x0393
#define IOCBP_ADDR              0x0394
#define IOCBN_ADDR              0x0395
#define IOCBF_ADDR              0x0396
#define IOCCP_ADDR              0x0397
#define IOCCN_ADDR              0x0398
#define IOCCF_ADDR              0x0399
#define IOCEP_ADDR              0x039D
#define IOCEN_ADDR              0x039E
#define IOCEF_ADDR              0x039F
#define TMR4_ADDR               0x0415
#define PR4_ADDR                0x0416
#define T4CON_ADDR              0x0417
#define TMR6_ADDR               0x041C
#define PR6_ADDR                0x041D
#define T6CON_ADDR              0x041E
#define NCO1ACC_ADDR            0x0498
#define NCO1ACCL_ADDR           0x0498
#define NCO1ACCH_ADDR           0x0499
#define NCO1ACCU_ADDR           0x049A
#define NCO1INC_ADDR            0x049B
#define NCO1INCL_ADDR           0x049B
#define NCO1INCH_ADDR           0x049C
#define NCO1INCU_ADDR           0x049D
#define NCO1CON_ADDR            0x049E
#define NCO1CLK_ADDR            0x049F
#define OPA1CON_ADDR            0x0511
#define OPA2CON_ADDR            0x0515
#define PWM3DCL_ADDR            0x0617
#define PWM3DCH_ADDR            0x0618
#define PWM3CON_ADDR            0x0619
#define PWM3CON0_ADDR           0x0619
#define PWM4DCL_ADDR            0x061A
#define PWM4DCH_ADDR            0x061B
#define PWM4CON_ADDR            0x061C
#define PWM4CON0_ADDR           0x061C
#define COG1PHR_ADDR            0x0691
#define COG1PHF_ADDR            0x0692
#define COG1BLKR_ADDR           0x0693
#define COG1BLKF_ADDR           0x0694
#define COG1DBR_ADDR            0x0695
#define COG1DBF_ADDR            0x0696
#define COG1CON0_ADDR           0x0697
#define COG1CON1_ADDR           0x0698
#define COG1RIS_ADDR            0x0699
#define COG1RSIM_ADDR           0x069A
#define COG1FIS_ADDR            0x069B
#define COG1FSIM_ADDR           0x069C
#define COG1ASD0_ADDR           0x069D
#define COG1ASD1_ADDR           0x069E
#define COG1STR_ADDR            0x069F
#define PPSLOCK_ADDR            0x0E0F
#define INTPPS_ADDR             0x0E10
#define T0CKIPPS_ADDR           0x0E11
#define T1CKIPPS_ADDR           0x0E12
#define T1GPPS_ADDR             0x0E13
#define CCP1PPS_ADDR            0x0E14
#define CCP2PPS_ADDR            0x0E15
#define COGINPPS_ADDR           0x0E17
#define SSPCLKPPS_ADDR          0x0E20
#define SSPDATPPS_ADDR          0x0E21
#define SSPSSPPS_ADDR           0x0E22
#define RXPPS_ADDR              0x0E24
#define CKPPS_ADDR              0x0E25
#define CLCIN0PPS_ADDR          0x0E28
#define CLCIN1PPS_ADDR          0x0E29
#define CLCIN2PPS_ADDR          0x0E2A
#define CLCIN3PPS_ADDR          0x0E2B
#define RA0PPS_ADDR             0x0E90
#define RA1PPS_ADDR             0x0E91
#define RA2PPS_ADDR             0x0E92
#define RA3PPS_ADDR             0x0E93
#define RA4PPS_ADDR             0x0E94
#define RA5PPS_ADDR             0x0E95
#define RA6PPS_ADDR             0x0E96
#define RA7PPS_ADDR             0x0E97
#define RB0PPS_ADDR             0x0E98
#define RB1PPS_ADDR             0x0E99
#define RB2PPS_ADDR             0x0E9A
#define RB3PPS_ADDR             0x0E9B
#define RB4PPS_ADDR             0x0E9C
#define RB5PPS_ADDR             0x0E9D
#define RB6PPS_ADDR             0x0E9E
#define RB7PPS_ADDR             0x0E9F
#define RC0PPS_ADDR             0x0EA0
#define RC1PPS_ADDR             0x0EA1
#define RC2PPS_ADDR             0x0EA2
#define RC3PPS_ADDR             0x0EA3
#define RC4PPS_ADDR             0x0EA4
#define RC5PPS_ADDR             0x0EA5
#define RC6PPS_ADDR             0x0EA6
#define RC7PPS_ADDR             0x0EA7
#define RD0PPS_ADDR             0x0EA8
#define RD1PPS_ADDR             0x0EA9
#define RD2PPS_ADDR             0x0EAA
#define RD3PPS_ADDR             0x0EAB
#define RD4PPS_ADDR             0x0EAC
#define RD5PPS_ADDR             0x0EAD
#define RD6PPS_ADDR             0x0EAE
#define RD7PPS_ADDR             0x0EAF
#define RE0PPS_ADDR             0x0EB0
#define RE1PPS_ADDR             0x0EB1
#define RE2PPS_ADDR             0x0EB2
#define CLCDATA_ADDR            0x0F0F
#define CLC1CON_ADDR            0x0F10
#define CLC1POL_ADDR            0x0F11
#define CLC1SEL0_ADDR           0x0F12
#define CLC1SEL1_ADDR           0x0F13
#define CLC1SEL2_ADDR           0x0F14
#define CLC1SEL3_ADDR           0x0F15
#define CLC1GLS0_ADDR           0x0F16
#define CLC1GLS1_ADDR           0x0F17
#define CLC1GLS2_ADDR           0x0F18
#define CLC1GLS3_ADDR           0x0F19
#define CLC2CON_ADDR            0x0F1A
#define CLC2POL_ADDR            0x0F1B
#define CLC2SEL0_ADDR           0x0F1C
#define CLC2SEL1_ADDR           0x0F1D
#define CLC2SEL2_ADDR           0x0F1E
#define CLC2SEL3_ADDR           0x0F1F
#define CLC2GLS0_ADDR           0x0F20
#define CLC2GLS1_ADDR           0x0F21
#define CLC2GLS2_ADDR           0x0F22
#define CLC2GLS3_ADDR           0x0F23
#define CLC3CON_ADDR            0x0F24
#define CLC3POL_ADDR            0x0F25
#define CLC3SEL0_ADDR           0x0F26
#define CLC3SEL1_ADDR           0x0F27
#define CLC3SEL2_ADDR           0x0F28
#define CLC3SEL3_ADDR           0x0F29
#define CLC3GLS0_ADDR           0x0F2A
#define CLC3GLS1_ADDR           0x0F2B
#define CLC3GLS2_ADDR           0x0F2C
#define CLC3GLS3_ADDR           0x0F2D
#define CLC4CON_ADDR            0x0F2E
#define CLC4POL_ADDR            0x0F2F
#define CLC4SEL0_ADDR           0x0F30
#define CLC4SEL1_ADDR           0x0F31
#define CLC4SEL2_ADDR           0x0F32
#define CLC4SEL3_ADDR           0x0F33
#define CLC4GLS0_ADDR           0x0F34
#define CLC4GLS1_ADDR           0x0F35
#define CLC4GLS2_ADDR           0x0F36
#define CLC4GLS3_ADDR           0x0F37
#define STATUS_SHAD_ADDR        0x0FE4
#define WREG_SHAD_ADDR          0x0FE5
#define BSR_SHAD_ADDR           0x0FE6
#define PCLATH_SHAD_ADDR        0x0FE7
#define FSR0L_SHAD_ADDR         0x0FE8
#define FSR0H_SHAD_ADDR         0x0FE9
#define FSR1L_SHAD_ADDR         0x0FEA
#define FSR1H_SHAD_ADDR         0x0FEB
#define STKPTR_ADDR             0x0FED
#define TOSL_ADDR               0x0FEE
#define TOSH_ADDR               0x0FEF

#endif // #ifndef NO_ADDR_DEFINES

//==============================================================================
//
//	Register Definitions
//
//==============================================================================

extern __at(0x0000) __sfr INDF0;
extern __at(0x0001) __sfr INDF1;
extern __at(0x0002) __sfr PCL;

//==============================================================================
//        STATUS Bits

extern __at(0x0003) __sfr STATUS;

typedef struct
  {
  unsigned C                    : 1;
  unsigned DC                   : 1;
  unsigned Z                    : 1;
  unsigned NOT_PD               : 1;
  unsigned NOT_TO               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __STATUSbits_t;

extern __at(0x0003) volatile __STATUSbits_t STATUSbits;

#define _C                      0x01
#define _DC                     0x02
#define _Z                      0x04
#define _NOT_PD                 0x08
#define _NOT_TO                 0x10

//==============================================================================

extern __at(0x0004) __sfr FSR0;
extern __at(0x0004) __sfr FSR0L;
extern __at(0x0005) __sfr FSR0H;
extern __at(0x0006) __sfr FSR1;
extern __at(0x0006) __sfr FSR1L;
extern __at(0x0007) __sfr FSR1H;

//==============================================================================
//        BSR Bits

extern __at(0x0008) __sfr BSR;

typedef union
  {
  struct
    {
    unsigned BSR0               : 1;
    unsigned BSR1               : 1;
    unsigned BSR2               : 1;
    unsigned BSR3               : 1;
    unsigned BSR4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned BSR                : 5;
    unsigned                    : 3;
    };
  } __BSRbits_t;

extern __at(0x0008) volatile __BSRbits_t BSRbits;

#define _BSR0                   0x01
#define _BSR1                   0x02
#define _BSR2                   0x04
#define _BSR3                   0x08
#define _BSR4                   0x10

//==============================================================================

extern __at(0x0009) __sfr WREG;
extern __at(0x000A) __sfr PCLATH;

//==============================================================================
//        INTCON Bits

extern __at(0x000B) __sfr INTCON;

typedef union
  {
  struct
    {
    unsigned IOCIF              : 1;
    unsigned INTF               : 1;
    unsigned TMR0IF             : 1;
    unsigned IOCIE              : 1;
    unsigned INTE               : 1;
    unsigned TMR0IE             : 1;
    unsigned PEIE               : 1;
    unsigned GIE                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T0IF               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T0IE               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __INTCONbits_t;

extern __at(0x000B) volatile __INTCONbits_t INTCONbits;

#define _IOCIF                  0x01
#define _INTF                   0x02
#define _TMR0IF                 0x04
#define _T0IF                   0x04
#define _IOCIE                  0x08
#define _INTE                   0x10
#define _TMR0IE                 0x20
#define _T0IE                   0x20
#define _PEIE                   0x40
#define _GIE                    0x80

//==============================================================================


//==============================================================================
//        PORTA Bits

extern __at(0x000C) __sfr PORTA;

typedef struct
  {
  unsigned RA0                  : 1;
  unsigned RA1                  : 1;
  unsigned RA2                  : 1;
  unsigned RA3                  : 1;
  unsigned RA4                  : 1;
  unsigned RA5                  : 1;
  unsigned RA6                  : 1;
  unsigned RA7                  : 1;
  } __PORTAbits_t;

extern __at(0x000C) volatile __PORTAbits_t PORTAbits;

#define _RA0                    0x01
#define _RA1                    0x02
#define _RA2                    0x04
#define _RA3                    0x08
#define _RA4                    0x10
#define _RA5                    0x20
#define _RA6                    0x40
#define _RA7                    0x80

//==============================================================================


//==============================================================================
//        PORTB Bits

extern __at(0x000D) __sfr PORTB;

typedef struct
  {
  unsigned RB0                  : 1;
  unsigned RB1                  : 1;
  unsigned RB2                  : 1;
  unsigned RB3                  : 1;
  unsigned RB4                  : 1;
  unsigned RB5                  : 1;
  unsigned RB6                  : 1;
  unsigned RB7                  : 1;
  } __PORTBbits_t;

extern __at(0x000D) volatile __PORTBbits_t PORTBbits;

#define _RB0                    0x01
#define _RB1                    0x02
#define _RB2                    0x04
#define _RB3                    0x08
#define _RB4                    0x10
#define _RB5                    0x20
#define _RB6                    0x40
#define _RB7                    0x80

//==============================================================================


//==============================================================================
//        PORTC Bits

extern __at(0x000E) __sfr PORTC;

typedef struct
  {
  unsigned RC0                  : 1;
  unsigned RC1                  : 1;
  unsigned RC2                  : 1;
  unsigned RC3                  : 1;
  unsigned RC4                  : 1;
  unsigned RC5                  : 1;
  unsigned RC6                  : 1;
  unsigned RC7                  : 1;
  } __PORTCbits_t;

extern __at(0x000E) volatile __PORTCbits_t PORTCbits;

#define _RC0                    0x01
#define _RC1                    0x02
#define _RC2                    0x04
#define _RC3                    0x08
#define _RC4                    0x10
#define _RC5                    0x20
#define _RC6                    0x40
#define _RC7                    0x80

//==============================================================================


//==============================================================================
//        PORTD Bits

extern __at(0x000F) __sfr PORTD;

typedef struct
  {
  unsigned RD0                  : 1;
  unsigned RD1                  : 1;
  unsigned RD2                  : 1;
  unsigned RD3                  : 1;
  unsigned RD4                  : 1;
  unsigned RD5                  : 1;
  unsigned RD6                  : 1;
  unsigned RD7                  : 1;
  } __PORTDbits_t;

extern __at(0x000F) volatile __PORTDbits_t PORTDbits;

#define _RD0                    0x01
#define _RD1                    0x02
#define _RD2                    0x04
#define _RD3                    0x08
#define _RD4                    0x10
#define _RD5                    0x20
#define _RD6                    0x40
#define _RD7                    0x80

//==============================================================================


//==============================================================================
//        PORTE Bits

extern __at(0x0010) __sfr PORTE;

typedef union
  {
  struct
    {
    unsigned RE0                : 1;
    unsigned RE1                : 1;
    unsigned RE2                : 1;
    unsigned RE3                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RE                 : 4;
    unsigned                    : 4;
    };
  } __PORTEbits_t;

extern __at(0x0010) volatile __PORTEbits_t PORTEbits;

#define _RE0                    0x01
#define _RE1                    0x02
#define _RE2                    0x04
#define _RE3                    0x08

//==============================================================================


//==============================================================================
//        PIR1 Bits

extern __at(0x0011) __sfr PIR1;

typedef struct
  {
  unsigned TMR1IF               : 1;
  unsigned TMR2IF               : 1;
  unsigned CCP1IF               : 1;
  unsigned SSP1IF               : 1;
  unsigned TXIF                 : 1;
  unsigned RCIF                 : 1;
  unsigned ADIF                 : 1;
  unsigned TMR1GIF              : 1;
  } __PIR1bits_t;

extern __at(0x0011) volatile __PIR1bits_t PIR1bits;

#define _TMR1IF                 0x01
#define _TMR2IF                 0x02
#define _CCP1IF                 0x04
#define _SSP1IF                 0x08
#define _TXIF                   0x10
#define _RCIF                   0x20
#define _ADIF                   0x40
#define _TMR1GIF                0x80

//==============================================================================


//==============================================================================
//        PIR2 Bits

extern __at(0x0012) __sfr PIR2;

typedef struct
  {
  unsigned CCP2IF               : 1;
  unsigned TMR4IF               : 1;
  unsigned TMR6IF               : 1;
  unsigned BCL1IF               : 1;
  unsigned                      : 1;
  unsigned C1IF                 : 1;
  unsigned C2IF                 : 1;
  unsigned OSFIF                : 1;
  } __PIR2bits_t;

extern __at(0x0012) volatile __PIR2bits_t PIR2bits;

#define _CCP2IF                 0x01
#define _TMR4IF                 0x02
#define _TMR6IF                 0x04
#define _BCL1IF                 0x08
#define _C1IF                   0x20
#define _C2IF                   0x40
#define _OSFIF                  0x80

//==============================================================================


//==============================================================================
//        PIR3 Bits

extern __at(0x0013) __sfr PIR3;

typedef struct
  {
  unsigned CLC1IF               : 1;
  unsigned CLC2IF               : 1;
  unsigned CLC3IF               : 1;
  unsigned CLC4IF               : 1;
  unsigned ZCDIF                : 1;
  unsigned COGIF                : 1;
  unsigned NCOIF                : 1;
  unsigned                      : 1;
  } __PIR3bits_t;

extern __at(0x0013) volatile __PIR3bits_t PIR3bits;

#define _CLC1IF                 0x01
#define _CLC2IF                 0x02
#define _CLC3IF                 0x04
#define _CLC4IF                 0x08
#define _ZCDIF                  0x10
#define _COGIF                  0x20
#define _NCOIF                  0x40

//==============================================================================

extern __at(0x0015) __sfr TMR0;
extern __at(0x0016) __sfr TMR1;
extern __at(0x0016) __sfr TMR1L;
extern __at(0x0017) __sfr TMR1H;

//==============================================================================
//        T1CON Bits

extern __at(0x0018) __sfr T1CON;

typedef union
  {
  struct
    {
    unsigned TMR1ON             : 1;
    unsigned                    : 1;
    unsigned NOT_T1SYNC         : 1;
    unsigned T1OSCEN            : 1;
    unsigned T1CKPS0            : 1;
    unsigned T1CKPS1            : 1;
    unsigned TMR1CS0            : 1;
    unsigned TMR1CS1            : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T1CKPS             : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned TMR1CS             : 2;
    };
  } __T1CONbits_t;

extern __at(0x0018) volatile __T1CONbits_t T1CONbits;

#define _TMR1ON                 0x01
#define _NOT_T1SYNC             0x04
#define _T1OSCEN                0x08
#define _T1CKPS0                0x10
#define _T1CKPS1                0x20
#define _TMR1CS0                0x40
#define _TMR1CS1                0x80

//==============================================================================


//==============================================================================
//        T1GCON Bits

extern __at(0x0019) __sfr T1GCON;

typedef union
  {
  struct
    {
    unsigned T1GSS0             : 1;
    unsigned T1GSS1             : 1;
    unsigned T1GVAL             : 1;
    unsigned T1GGO_NOT_DONE     : 1;
    unsigned T1GSPM             : 1;
    unsigned T1GTM              : 1;
    unsigned T1GPOL             : 1;
    unsigned TMR1GE             : 1;
    };

  struct
    {
    unsigned T1GSS              : 2;
    unsigned                    : 6;
    };
  } __T1GCONbits_t;

extern __at(0x0019) volatile __T1GCONbits_t T1GCONbits;

#define _T1GSS0                 0x01
#define _T1GSS1                 0x02
#define _T1GVAL                 0x04
#define _T1GGO_NOT_DONE         0x08
#define _T1GSPM                 0x10
#define _T1GTM                  0x20
#define _T1GPOL                 0x40
#define _TMR1GE                 0x80

//==============================================================================

extern __at(0x001A) __sfr TMR2;
extern __at(0x001B) __sfr PR2;

//==============================================================================
//        T2CON Bits

extern __at(0x001C) __sfr T2CON;

typedef union
  {
  struct
    {
    unsigned T2CKPS0            : 1;
    unsigned T2CKPS1            : 1;
    unsigned TMR2ON             : 1;
    unsigned T2OUTPS0           : 1;
    unsigned T2OUTPS1           : 1;
    unsigned T2OUTPS2           : 1;
    unsigned T2OUTPS3           : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T2CKPS             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned T2OUTPS            : 4;
    unsigned                    : 1;
    };
  } __T2CONbits_t;

extern __at(0x001C) volatile __T2CONbits_t T2CONbits;

#define _T2CKPS0                0x01
#define _T2CKPS1                0x02
#define _TMR2ON                 0x04
#define _T2OUTPS0               0x08
#define _T2OUTPS1               0x10
#define _T2OUTPS2               0x20
#define _T2OUTPS3               0x40

//==============================================================================


//==============================================================================
//        TRISA Bits

extern __at(0x008C) __sfr TRISA;

typedef struct
  {
  unsigned TRISA0               : 1;
  unsigned TRISA1               : 1;
  unsigned TRISA2               : 1;
  unsigned TRISA3               : 1;
  unsigned TRISA4               : 1;
  unsigned TRISA5               : 1;
  unsigned TRISA6               : 1;
  unsigned TRISA7               : 1;
  } __TRISAbits_t;

extern __at(0x008C) volatile __TRISAbits_t TRISAbits;

#define _TRISA0                 0x01
#define _TRISA1                 0x02
#define _TRISA2                 0x04
#define _TRISA3                 0x08
#define _TRISA4                 0x10
#define _TRISA5                 0x20
#define _TRISA6                 0x40
#define _TRISA7                 0x80

//==============================================================================


//==============================================================================
//        TRISB Bits

extern __at(0x008D) __sfr TRISB;

typedef struct
  {
  unsigned TRISB0               : 1;
  unsigned TRISB1               : 1;
  unsigned TRISB2               : 1;
  unsigned TRISB3               : 1;
  unsigned TRISB4               : 1;
  unsigned TRISB5               : 1;
  unsigned TRISB6               : 1;
  unsigned TRISB7               : 1;
  } __TRISBbits_t;

extern __at(0x008D) volatile __TRISBbits_t TRISBbits;

#define _TRISB0                 0x01
#define _TRISB1                 0x02
#define _TRISB2                 0x04
#define _TRISB3                 0x08
#define _TRISB4                 0x10
#define _TRISB5                 0x20
#define _TRISB6                 0x40
#define _TRISB7                 0x80

//==============================================================================


//==============================================================================
//        TRISC Bits

extern __at(0x008E) __sfr TRISC;

typedef struct
  {
  unsigned TRISC0               : 1;
  unsigned TRISC1               : 1;
  unsigned TRISC2               : 1;
  unsigned TRISC3               : 1;
  unsigned TRISC4               : 1;
  unsigned TRISC5               : 1;
  unsigned TRISC6               : 1;
  unsigned TRISC7               : 1;
  } __TRISCbits_t;

extern __at(0x008E) volatile __TRISCbits_t TRISCbits;

#define _TRISC0                 0x01
#define _TRISC1                 0x02
#define _TRISC2                 0x04
#define _TRISC3                 0x08
#define _TRISC4                 0x10
#define _TRISC5                 0x20
#define _TRISC6                 0x40
#define _TRISC7                 0x80

//==============================================================================


//==============================================================================
//        TRISD Bits

extern __at(0x008F) __sfr TRISD;

typedef struct
  {
  unsigned TRISD0               : 1;
  unsigned TRISD1               : 1;
  unsigned TRISD2               : 1;
  unsigned TRISD3               : 1;
  unsigned TRISD4               : 1;
  unsigned TRISD5               : 1;
  unsigned TRISD6               : 1;
  unsigned TRISD7               : 1;
  } __TRISDbits_t;

extern __at(0x008F) volatile __TRISDbits_t TRISDbits;

#define _TRISD0                 0x01
#define _TRISD1                 0x02
#define _TRISD2                 0x04
#define _TRISD3                 0x08
#define _TRISD4                 0x10
#define _TRISD5                 0x20
#define _TRISD6                 0x40
#define _TRISD7                 0x80

//==============================================================================


//==============================================================================
//        TRISE Bits

extern __at(0x0090) __sfr TRISE;

typedef union
  {
  struct
    {
    unsigned TRISE0             : 1;
    unsigned TRISE1             : 1;
    unsigned TRISE2             : 1;
    unsigned TRISE3             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned TRISE              : 4;
    unsigned                    : 4;
    };
  } __TRISEbits_t;

extern __at(0x0090) volatile __TRISEbits_t TRISEbits;

#define _TRISE0                 0x01
#define _TRISE1                 0x02
#define _TRISE2                 0x04
#define _TRISE3                 0x08

//==============================================================================


//==============================================================================
//        PIE1 Bits

extern __at(0x0091) __sfr PIE1;

typedef struct
  {
  unsigned TMR1IE               : 1;
  unsigned TMR2IE               : 1;
  unsigned CCP1IE               : 1;
  unsigned SSP1IE               : 1;
  unsigned TXIE                 : 1;
  unsigned RCIE                 : 1;
  unsigned ADIE                 : 1;
  unsigned TMR1GIE              : 1;
  } __PIE1bits_t;

extern __at(0x0091) volatile __PIE1bits_t PIE1bits;

#define _TMR1IE                 0x01
#define _TMR2IE                 0x02
#define _CCP1IE                 0x04
#define _SSP1IE                 0x08
#define _TXIE                   0x10
#define _RCIE                   0x20
#define _ADIE                   0x40
#define _TMR1GIE                0x80

//==============================================================================


//==============================================================================
//        PIE2 Bits

extern __at(0x0092) __sfr PIE2;

typedef struct
  {
  unsigned CCP2IE               : 1;
  unsigned TMR4IE               : 1;
  unsigned TMR6IE               : 1;
  unsigned BCL1IE               : 1;
  unsigned                      : 1;
  unsigned C1IE                 : 1;
  unsigned C2IE                 : 1;
  unsigned OSFIE                : 1;
  } __PIE2bits_t;

extern __at(0x0092) volatile __PIE2bits_t PIE2bits;

#define _CCP2IE                 0x01
#define _TMR4IE                 0x02
#define _TMR6IE                 0x04
#define _BCL1IE                 0x08
#define _C1IE                   0x20
#define _C2IE                   0x40
#define _OSFIE                  0x80

//==============================================================================


//==============================================================================
//        PIE3 Bits

extern __at(0x0093) __sfr PIE3;

typedef struct
  {
  unsigned CLC1IE               : 1;
  unsigned CLC2IE               : 1;
  unsigned CLC3IE               : 1;
  unsigned CLC4IE               : 1;
  unsigned ZCDIE                : 1;
  unsigned COGIE                : 1;
  unsigned NCOIE                : 1;
  unsigned                      : 1;
  } __PIE3bits_t;

extern __at(0x0093) volatile __PIE3bits_t PIE3bits;

#define _CLC1IE                 0x01
#define _CLC2IE                 0x02
#define _CLC3IE                 0x04
#define _CLC4IE                 0x08
#define _ZCDIE                  0x10
#define _COGIE                  0x20
#define _NCOIE                  0x40

//==============================================================================


//==============================================================================
//        OPTION_REG Bits

extern __at(0x0095) __sfr OPTION_REG;

typedef union
  {
  struct
    {
    unsigned PS0                : 1;
    unsigned PS1                : 1;
    unsigned PS2                : 1;
    unsigned PSA                : 1;
    unsigned TMR0SE             : 1;
    unsigned TMR0CS             : 1;
    unsigned INTEDG             : 1;
    unsigned NOT_WPUEN          : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T0SE               : 1;
    unsigned T0CS               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PS                 : 3;
    unsigned                    : 5;
    };
  } __OPTION_REGbits_t;

extern __at(0x0095) volatile __OPTION_REGbits_t OPTION_REGbits;

#define _PS0                    0x01
#define _PS1                    0x02
#define _PS2                    0x04
#define _PSA                    0x08
#define _TMR0SE                 0x10
#define _T0SE                   0x10
#define _TMR0CS                 0x20
#define _T0CS                   0x20
#define _INTEDG                 0x40
#define _NOT_WPUEN              0x80

//==============================================================================


//==============================================================================
//        PCON Bits

extern __at(0x0096) __sfr PCON;

typedef struct
  {
  unsigned NOT_BOR              : 1;
  unsigned NOT_POR              : 1;
  unsigned NOT_RI               : 1;
  unsigned NOT_RMCLR            : 1;
  unsigned NOT_RWDT             : 1;
  unsigned                      : 1;
  unsigned STKUNF               : 1;
  unsigned STKOVF               : 1;
  } __PCONbits_t;

extern __at(0x0096) volatile __PCONbits_t PCONbits;

#define _NOT_BOR                0x01
#define _NOT_POR                0x02
#define _NOT_RI                 0x04
#define _NOT_RMCLR              0x08
#define _NOT_RWDT               0x10
#define _STKUNF                 0x40
#define _STKOVF                 0x80

//==============================================================================


//==============================================================================
//        WDTCON Bits

extern __at(0x0097) __sfr WDTCON;

typedef union
  {
  struct
    {
    unsigned SWDTEN             : 1;
    unsigned WDTPS0             : 1;
    unsigned WDTPS1             : 1;
    unsigned WDTPS2             : 1;
    unsigned WDTPS3             : 1;
    unsigned WDTPS4             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned WDTPS              : 5;
    unsigned                    : 2;
    };
  } __WDTCONbits_t;

extern __at(0x0097) volatile __WDTCONbits_t WDTCONbits;

#define _SWDTEN                 0x01
#define _WDTPS0                 0x02
#define _WDTPS1                 0x04
#define _WDTPS2                 0x08
#define _WDTPS3                 0x10
#define _WDTPS4                 0x20

//==============================================================================


//==============================================================================
//        OSCTUNE Bits

extern __at(0x0098) __sfr OSCTUNE;

typedef union
  {
  struct
    {
    unsigned TUN0               : 1;
    unsigned TUN1               : 1;
    unsigned TUN2               : 1;
    unsigned TUN3               : 1;
    unsigned TUN4               : 1;
    unsigned TUN5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned TUN                : 6;
    unsigned                    : 2;
    };
  } __OSCTUNEbits_t;

extern __at(0x0098) volatile __OSCTUNEbits_t OSCTUNEbits;

#define _TUN0                   0x01
#define _TUN1                   0x02
#define _TUN2                   0x04
#define _TUN3                   0x08
#define _TUN4                   0x10
#define _TUN5                   0x20

//==============================================================================


//==============================================================================
//        OSCCON Bits

extern __at(0x0099) __sfr OSCCON;

typedef union
  {
  struct
    {
    unsigned SCS0               : 1;
    unsigned SCS1               : 1;
    unsigned                    : 1;
    unsigned IRCF0              : 1;
    unsigned IRCF1              : 1;
    unsigned IRCF2              : 1;
    unsigned IRCF3              : 1;
    unsigned SPLLEN             : 1;
    };

  struct
    {
    unsigned SCS                : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned IRCF               : 4;
    unsigned                    : 1;
    };
  } __OSCCONbits_t;

extern __at(0x0099) volatile __OSCCONbits_t OSCCONbits;

#define _SCS0                   0x01
#define _SCS1                   0x02
#define _IRCF0                  0x08
#define _IRCF1                  0x10
#define _IRCF2                  0x20
#define _IRCF3                  0x40
#define _SPLLEN                 0x80

//==============================================================================


//==============================================================================
//        OSCSTAT Bits

extern __at(0x009A) __sfr OSCSTAT;

typedef struct
  {
  unsigned HFIOFS               : 1;
  unsigned LFIOFR               : 1;
  unsigned MFIOFR               : 1;
  unsigned HFIOFL               : 1;
  unsigned HFIOFR               : 1;
  unsigned OSTS                 : 1;
  unsigned PLLR                 : 1;
  unsigned SOSCR                : 1;
  } __OSCSTATbits_t;

extern __at(0x009A) volatile __OSCSTATbits_t OSCSTATbits;

#define _HFIOFS                 0x01
#define _LFIOFR                 0x02
#define _MFIOFR                 0x04
#define _HFIOFL                 0x08
#define _HFIOFR                 0x10
#define _OSTS                   0x20
#define _PLLR                   0x40
#define _SOSCR                  0x80

//==============================================================================

extern __at(0x009B) __sfr ADRES;
extern __at(0x009B) __sfr ADRESL;
extern __at(0x009C) __sfr ADRESH;

//==============================================================================
//        ADCON0 Bits

extern __at(0x009D) __sfr ADCON0;

typedef union
  {
  struct
    {
    unsigned ADON               : 1;
    unsigned GO_NOT_DONE        : 1;
    unsigned CHS0               : 1;
    unsigned CHS1               : 1;
    unsigned CHS2               : 1;
    unsigned CHS3               : 1;
    unsigned CHS4               : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned ADGO               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned GO                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CHS                : 5;
    unsigned                    : 1;
    };
  } __ADCON0bits_t;

extern __at(0x009D) volatile __ADCON0bits_t ADCON0bits;

#define _ADON                   0x01
#define _GO_NOT_DONE            0x02
#define _ADGO                   0x02
#define _GO                     0x02
#define _CHS0                   0x04
#define _CHS1                   0x08
#define _CHS2                   0x10
#define _CHS3                   0x20
#define _CHS4                   0x40

//==============================================================================


//==============================================================================
//        ADCON1 Bits

extern __at(0x009E) __sfr ADCON1;

typedef union
  {
  struct
    {
    unsigned ADPREF0            : 1;
    unsigned ADPREF1            : 1;
    unsigned ADNREF             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ADFM               : 1;
    };

  struct
    {
    unsigned ADPREF             : 2;
    unsigned                    : 6;
    };
  } __ADCON1bits_t;

extern __at(0x009E) volatile __ADCON1bits_t ADCON1bits;

#define _ADPREF0                0x01
#define _ADPREF1                0x02
#define _ADNREF                 0x04
#define _ADFM                   0x80

//==============================================================================


//==============================================================================
//        ADCON2 Bits

extern __at(0x009F) __sfr ADCON2;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TRIGSEL0           : 1;
    unsigned TRIGSEL1           : 1;
    unsigned TRIGSEL2           : 1;
    unsigned TRIGSEL3           : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned TRIGSEL            : 4;
    };
  } __ADCON2bits_t;

extern __at(0x009F) volatile __ADCON2bits_t ADCON2bits;

#define _TRIGSEL0               0x10
#define _TRIGSEL1               0x20
#define _TRIGSEL2               0x40
#define _TRIGSEL3               0x80

//==============================================================================


//==============================================================================
//        LATA Bits

extern __at(0x010C) __sfr LATA;

typedef struct
  {
  unsigned LATA0                : 1;
  unsigned LATA1                : 1;
  unsigned LATA2                : 1;
  unsigned LATA3                : 1;
  unsigned LATA4                : 1;
  unsigned LATA5                : 1;
  unsigned LATA6                : 1;
  unsigned LATA7                : 1;
  } __LATAbits_t;

extern __at(0x010C) volatile __LATAbits_t LATAbits;

#define _LATA0                  0x01
#define _LATA1                  0x02
#define _LATA2                  0x04
#define _LATA3                  0x08
#define _LATA4                  0x10
#define _LATA5                  0x20
#define _LATA6                  0x40
#define _LATA7                  0x80

//==============================================================================


//==============================================================================
//        LATB Bits

extern __at(0x010D) __sfr LATB;

typedef struct
  {
  unsigned LATB0                : 1;
  unsigned LATB1                : 1;
  unsigned LATB2                : 1;
  unsigned LATB3                : 1;
  unsigned LATB4                : 1;
  unsigned LATB5                : 1;
  unsigned LATB6                : 1;
  unsigned LATB7                : 1;
  } __LATBbits_t;

extern __at(0x010D) volatile __LATBbits_t LATBbits;

#define _LATB0                  0x01
#define _LATB1                  0x02
#define _LATB2                  0x04
#define _LATB3                  0x08
#define _LATB4                  0x10
#define _LATB5                  0x20
#define _LATB6                  0x40
#define _LATB7                  0x80

//==============================================================================


//==============================================================================
//        LATC Bits

extern __at(0x010E) __sfr LATC;

typedef struct
  {
  unsigned LATC0                : 1;
  unsigned LATC1                : 1;
  unsigned LATC2                : 1;
  unsigned LATC3                : 1;
  unsigned LATC4                : 1;
  unsigned LATC5                : 1;
  unsigned LATC6                : 1;
  unsigned LATC7                : 1;
  } __LATCbits_t;

extern __at(0x010E) volatile __LATCbits_t LATCbits;

#define _LATC0                  0x01
#define _LATC1                  0x02
#define _LATC2                  0x04
#define _LATC3                  0x08
#define _LATC4                  0x10
#define _LATC5                  0x20
#define _LATC6                  0x40
#define _LATC7                  0x80

//==============================================================================


//==============================================================================
//        LATD Bits

extern __at(0x010F) __sfr LATD;

typedef struct
  {
  unsigned LATD0                : 1;
  unsigned LATD1                : 1;
  unsigned LATD2                : 1;
  unsigned LATD3                : 1;
  unsigned LATD4                : 1;
  unsigned LATD5                : 1;
  unsigned LATD6                : 1;
  unsigned LATD7                : 1;
  } __LATDbits_t;

extern __at(0x010F) volatile __LATDbits_t LATDbits;

#define _LATD0                  0x01
#define _LATD1                  0x02
#define _LATD2                  0x04
#define _LATD3                  0x08
#define _LATD4                  0x10
#define _LATD5                  0x20
#define _LATD6                  0x40
#define _LATD7                  0x80

//==============================================================================


//==============================================================================
//        LATE Bits

extern __at(0x0110) __sfr LATE;

typedef union
  {
  struct
    {
    unsigned LATE0              : 1;
    unsigned LATE1              : 1;
    unsigned LATE2              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LATE               : 3;
    unsigned                    : 5;
    };
  } __LATEbits_t;

extern __at(0x0110) volatile __LATEbits_t LATEbits;

#define _LATE0                  0x01
#define _LATE1                  0x02
#define _LATE2                  0x04

//==============================================================================


//==============================================================================
//        CM1CON0 Bits

extern __at(0x0111) __sfr CM1CON0;

typedef struct
  {
  unsigned C1SYNC               : 1;
  unsigned C1HYS                : 1;
  unsigned C1SP                 : 1;
  unsigned C1ZLF                : 1;
  unsigned C1POL                : 1;
  unsigned                      : 1;
  unsigned C1OUT                : 1;
  unsigned C1ON                 : 1;
  } __CM1CON0bits_t;

extern __at(0x0111) volatile __CM1CON0bits_t CM1CON0bits;

#define _C1SYNC                 0x01
#define _C1HYS                  0x02
#define _C1SP                   0x04
#define _C1ZLF                  0x08
#define _C1POL                  0x10
#define _C1OUT                  0x40
#define _C1ON                   0x80

//==============================================================================


//==============================================================================
//        CM1CON1 Bits

extern __at(0x0112) __sfr CM1CON1;

typedef union
  {
  struct
    {
    unsigned C1NCH0             : 1;
    unsigned C1NCH1             : 1;
    unsigned C1NCH2             : 1;
    unsigned C1PCH0             : 1;
    unsigned C1PCH1             : 1;
    unsigned C1PCH2             : 1;
    unsigned C1INTN             : 1;
    unsigned C1INTP             : 1;
    };

  struct
    {
    unsigned C1NCH              : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 3;
    unsigned C1PCH              : 3;
    unsigned                    : 2;
    };
  } __CM1CON1bits_t;

extern __at(0x0112) volatile __CM1CON1bits_t CM1CON1bits;

#define _C1NCH0                 0x01
#define _C1NCH1                 0x02
#define _C1NCH2                 0x04
#define _C1PCH0                 0x08
#define _C1PCH1                 0x10
#define _C1PCH2                 0x20
#define _C1INTN                 0x40
#define _C1INTP                 0x80

//==============================================================================


//==============================================================================
//        CM2CON0 Bits

extern __at(0x0113) __sfr CM2CON0;

typedef struct
  {
  unsigned C2SYNC               : 1;
  unsigned C2HYS                : 1;
  unsigned C2SP                 : 1;
  unsigned C2ZLF                : 1;
  unsigned C2POL                : 1;
  unsigned                      : 1;
  unsigned C2OUT                : 1;
  unsigned C2ON                 : 1;
  } __CM2CON0bits_t;

extern __at(0x0113) volatile __CM2CON0bits_t CM2CON0bits;

#define _C2SYNC                 0x01
#define _C2HYS                  0x02
#define _C2SP                   0x04
#define _C2ZLF                  0x08
#define _C2POL                  0x10
#define _C2OUT                  0x40
#define _C2ON                   0x80

//==============================================================================


//==============================================================================
//        CM2CON1 Bits

extern __at(0x0114) __sfr CM2CON1;

typedef union
  {
  struct
    {
    unsigned C2NCH0             : 1;
    unsigned C2NCH1             : 1;
    unsigned C2NCH2             : 1;
    unsigned C2PCH0             : 1;
    unsigned C2PCH1             : 1;
    unsigned C2PCH2             : 1;
    unsigned C2INTN             : 1;
    unsigned C2INTP             : 1;
    };

  struct
    {
    unsigned C2NCH              : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 3;
    unsigned C2PCH              : 3;
    unsigned                    : 2;
    };
  } __CM2CON1bits_t;

extern __at(0x0114) volatile __CM2CON1bits_t CM2CON1bits;

#define _C2NCH0                 0x01
#define _C2NCH1                 0x02
#define _C2NCH2                 0x04
#define _C2PCH0                 0x08
#define _C2PCH1                 0x10
#define _C2PCH2                 0x20
#define _C2INTN                 0x40
#define _C2INTP                 0x80

//==============================================================================


//==============================================================================
//        CMOUT Bits

extern __at(0x0115) __sfr CMOUT;

typedef struct
  {
  unsigned MC1OUT               : 1;
  unsigned MC2OUT               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __CMOUTbits_t;

extern __at(0x0115) volatile __CMOUTbits_t CMOUTbits;

#define _MC1OUT                 0x01
#define _MC2OUT                 0x02

//==============================================================================


//==============================================================================
//        BORCON Bits

extern __at(0x0116) __sfr BORCON;

typedef struct
  {
  unsigned BORRDY               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned BORFS                : 1;
  unsigned SBOREN               : 1;
  } __BORCONbits_t;

extern __at(0x0116) volatile __BORCONbits_t BORCONbits;

#define _BORRDY                 0x01
#define _BORFS                  0x40
#define _SBOREN                 0x80

//==============================================================================


//==============================================================================
//        FVRCON Bits

extern __at(0x0117) __sfr FVRCON;

typedef union
  {
  struct
    {
    unsigned ADFVR0             : 1;
    unsigned ADFVR1             : 1;
    unsigned CDAFVR0            : 1;
    unsigned CDAFVR1            : 1;
    unsigned TSRNG              : 1;
    unsigned TSEN               : 1;
    unsigned FVRRDY             : 1;
    unsigned FVREN              : 1;
    };

  struct
    {
    unsigned ADFVR              : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CDAFVR             : 2;
    unsigned                    : 4;
    };
  } __FVRCONbits_t;

extern __at(0x0117) volatile __FVRCONbits_t FVRCONbits;

#define _ADFVR0                 0x01
#define _ADFVR1                 0x02
#define _CDAFVR0                0x04
#define _CDAFVR1                0x08
#define _TSRNG                  0x10
#define _TSEN                   0x20
#define _FVRRDY                 0x40
#define _FVREN                  0x80

//==============================================================================


//==============================================================================
//        DAC1CON0 Bits

extern __at(0x0118) __sfr DAC1CON0;

typedef union
  {
  struct
    {
    unsigned DAC1NSS            : 1;
    unsigned                    : 1;
    unsigned DAC1PSS0           : 1;
    unsigned DAC1PSS1           : 1;
    unsigned DAC1OE2            : 1;
    unsigned DAC1OE1            : 1;
    unsigned                    : 1;
    unsigned DAC1EN             : 1;
    };

  struct
    {
    unsigned DACNSS             : 1;
    unsigned                    : 1;
    unsigned DACPSS0            : 1;
    unsigned DACPSS1            : 1;
    unsigned DACOE0             : 1;
    unsigned DACOE1             : 1;
    unsigned                    : 1;
    unsigned DACEN              : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned DACPSS             : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 2;
    unsigned DAC1PSS            : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DACOE              : 2;
    unsigned                    : 2;
    };
  } __DAC1CON0bits_t;

extern __at(0x0118) volatile __DAC1CON0bits_t DAC1CON0bits;

#define _DAC1NSS                0x01
#define _DACNSS                 0x01
#define _DAC1PSS0               0x04
#define _DACPSS0                0x04
#define _DAC1PSS1               0x08
#define _DACPSS1                0x08
#define _DAC1OE2                0x10
#define _DACOE0                 0x10
#define _DAC1OE1                0x20
#define _DACOE1                 0x20
#define _DAC1EN                 0x80
#define _DACEN                  0x80

//==============================================================================


//==============================================================================
//        DAC1CON1 Bits

extern __at(0x0119) __sfr DAC1CON1;

typedef union
  {
  struct
    {
    unsigned DAC1R0             : 1;
    unsigned DAC1R1             : 1;
    unsigned DAC1R2             : 1;
    unsigned DAC1R3             : 1;
    unsigned DAC1R4             : 1;
    unsigned DAC1R5             : 1;
    unsigned DAC1R6             : 1;
    unsigned DAC1R7             : 1;
    };

  struct
    {
    unsigned DACR0              : 1;
    unsigned DACR1              : 1;
    unsigned DACR2              : 1;
    unsigned DACR3              : 1;
    unsigned DACR4              : 1;
    unsigned DACR5              : 1;
    unsigned DACR6              : 1;
    unsigned DACR7              : 1;
    };
  } __DAC1CON1bits_t;

extern __at(0x0119) volatile __DAC1CON1bits_t DAC1CON1bits;

#define _DAC1R0                 0x01
#define _DACR0                  0x01
#define _DAC1R1                 0x02
#define _DACR1                  0x02
#define _DAC1R2                 0x04
#define _DACR2                  0x04
#define _DAC1R3                 0x08
#define _DACR3                  0x08
#define _DAC1R4                 0x10
#define _DACR4                  0x10
#define _DAC1R5                 0x20
#define _DACR5                  0x20
#define _DAC1R6                 0x40
#define _DACR6                  0x40
#define _DAC1R7                 0x80
#define _DACR7                  0x80

//==============================================================================


//==============================================================================
//        DAC2CON0 Bits

extern __at(0x011A) __sfr DAC2CON0;

typedef union
  {
  struct
    {
    unsigned NSS                : 1;
    unsigned                    : 1;
    unsigned PSS0               : 1;
    unsigned PSS1               : 1;
    unsigned OE2                : 1;
    unsigned OE1                : 1;
    unsigned                    : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned DACNSS             : 1;
    unsigned                    : 1;
    unsigned DACPSS0            : 1;
    unsigned DACPSS1            : 1;
    unsigned DACOE2             : 1;
    unsigned DACOE1             : 1;
    unsigned                    : 1;
    unsigned DACEN              : 1;
    };

  struct
    {
    unsigned DAC2NSS            : 1;
    unsigned                    : 1;
    unsigned DAC2PSS0           : 1;
    unsigned DAC2PSS1           : 1;
    unsigned DAC2OE2            : 1;
    unsigned DAC2OE1            : 1;
    unsigned                    : 1;
    unsigned DAC2EN             : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned DACPSS             : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 2;
    unsigned PSS                : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 2;
    unsigned DAC2PSS            : 2;
    unsigned                    : 4;
    };
  } __DAC2CON0bits_t;

extern __at(0x011A) volatile __DAC2CON0bits_t DAC2CON0bits;

#define _DAC2CON0_NSS           0x01
#define _DAC2CON0_DACNSS        0x01
#define _DAC2CON0_DAC2NSS       0x01
#define _DAC2CON0_PSS0          0x04
#define _DAC2CON0_DACPSS0       0x04
#define _DAC2CON0_DAC2PSS0      0x04
#define _DAC2CON0_PSS1          0x08
#define _DAC2CON0_DACPSS1       0x08
#define _DAC2CON0_DAC2PSS1      0x08
#define _DAC2CON0_OE2           0x10
#define _DAC2CON0_DACOE2        0x10
#define _DAC2CON0_DAC2OE2       0x10
#define _DAC2CON0_OE1           0x20
#define _DAC2CON0_DACOE1        0x20
#define _DAC2CON0_DAC2OE1       0x20
#define _DAC2CON0_EN            0x80
#define _DAC2CON0_DACEN         0x80
#define _DAC2CON0_DAC2EN        0x80

//==============================================================================


//==============================================================================
//        DAC2CON1 Bits

extern __at(0x011B) __sfr DAC2CON1;

typedef union
  {
  struct
    {
    unsigned DACR0              : 1;
    unsigned DACR1              : 1;
    unsigned DACR2              : 1;
    unsigned DACR3              : 1;
    unsigned DACR4              : 1;
    unsigned REF5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned R0                 : 1;
    unsigned R1                 : 1;
    unsigned R2                 : 1;
    unsigned R3                 : 1;
    unsigned R4                 : 1;
    unsigned DAC2REF5           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned DAC2R0             : 1;
    unsigned DAC2R1             : 1;
    unsigned DAC2R2             : 1;
    unsigned DAC2R3             : 1;
    unsigned DAC2R4             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned REF0               : 1;
    unsigned REF1               : 1;
    unsigned REF2               : 1;
    unsigned REF3               : 1;
    unsigned REF4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned DAC2REF0           : 1;
    unsigned DAC2REF1           : 1;
    unsigned DAC2REF2           : 1;
    unsigned DAC2REF3           : 1;
    unsigned DAC2REF4           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned DACR               : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned DAC2R              : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned REF                : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned R                  : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned DAC2REF            : 6;
    unsigned                    : 2;
    };
  } __DAC2CON1bits_t;

extern __at(0x011B) volatile __DAC2CON1bits_t DAC2CON1bits;

#define _DAC2CON1_DACR0         0x01
#define _DAC2CON1_R0            0x01
#define _DAC2CON1_DAC2R0        0x01
#define _DAC2CON1_REF0          0x01
#define _DAC2CON1_DAC2REF0      0x01
#define _DAC2CON1_DACR1         0x02
#define _DAC2CON1_R1            0x02
#define _DAC2CON1_DAC2R1        0x02
#define _DAC2CON1_REF1          0x02
#define _DAC2CON1_DAC2REF1      0x02
#define _DAC2CON1_DACR2         0x04
#define _DAC2CON1_R2            0x04
#define _DAC2CON1_DAC2R2        0x04
#define _DAC2CON1_REF2          0x04
#define _DAC2CON1_DAC2REF2      0x04
#define _DAC2CON1_DACR3         0x08
#define _DAC2CON1_R3            0x08
#define _DAC2CON1_DAC2R3        0x08
#define _DAC2CON1_REF3          0x08
#define _DAC2CON1_DAC2REF3      0x08
#define _DAC2CON1_DACR4         0x10
#define _DAC2CON1_R4            0x10
#define _DAC2CON1_DAC2R4        0x10
#define _DAC2CON1_REF4          0x10
#define _DAC2CON1_DAC2REF4      0x10
#define _DAC2CON1_REF5          0x20
#define _DAC2CON1_DAC2REF5      0x20

//==============================================================================


//==============================================================================
//        DAC2REF Bits

extern __at(0x011B) __sfr DAC2REF;

typedef union
  {
  struct
    {
    unsigned DACR0              : 1;
    unsigned DACR1              : 1;
    unsigned DACR2              : 1;
    unsigned DACR3              : 1;
    unsigned DACR4              : 1;
    unsigned REF5               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned R0                 : 1;
    unsigned R1                 : 1;
    unsigned R2                 : 1;
    unsigned R3                 : 1;
    unsigned R4                 : 1;
    unsigned DAC2REF5           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned DAC2R0             : 1;
    unsigned DAC2R1             : 1;
    unsigned DAC2R2             : 1;
    unsigned DAC2R3             : 1;
    unsigned DAC2R4             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned REF0               : 1;
    unsigned REF1               : 1;
    unsigned REF2               : 1;
    unsigned REF3               : 1;
    unsigned REF4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned DAC2REF0           : 1;
    unsigned DAC2REF1           : 1;
    unsigned DAC2REF2           : 1;
    unsigned DAC2REF3           : 1;
    unsigned DAC2REF4           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned DAC2REF            : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned REF                : 6;
    unsigned                    : 2;
    };

  struct
    {
    unsigned DAC2R              : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned R                  : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned DACR               : 5;
    unsigned                    : 3;
    };
  } __DAC2REFbits_t;

extern __at(0x011B) volatile __DAC2REFbits_t DAC2REFbits;

#define _DAC2REF_DACR0          0x01
#define _DAC2REF_R0             0x01
#define _DAC2REF_DAC2R0         0x01
#define _DAC2REF_REF0           0x01
#define _DAC2REF_DAC2REF0       0x01
#define _DAC2REF_DACR1          0x02
#define _DAC2REF_R1             0x02
#define _DAC2REF_DAC2R1         0x02
#define _DAC2REF_REF1           0x02
#define _DAC2REF_DAC2REF1       0x02
#define _DAC2REF_DACR2          0x04
#define _DAC2REF_R2             0x04
#define _DAC2REF_DAC2R2         0x04
#define _DAC2REF_REF2           0x04
#define _DAC2REF_DAC2REF2       0x04
#define _DAC2REF_DACR3          0x08
#define _DAC2REF_R3             0x08
#define _DAC2REF_DAC2R3         0x08
#define _DAC2REF_REF3           0x08
#define _DAC2REF_DAC2REF3       0x08
#define _DAC2REF_DACR4          0x10
#define _DAC2REF_R4             0x10
#define _DAC2REF_DAC2R4         0x10
#define _DAC2REF_REF4           0x10
#define _DAC2REF_DAC2REF4       0x10
#define _DAC2REF_REF5           0x20
#define _DAC2REF_DAC2REF5       0x20

//==============================================================================


//==============================================================================
//        ZCD1CON Bits

extern __at(0x011C) __sfr ZCD1CON;

typedef struct
  {
  unsigned ZCD1INTN             : 1;
  unsigned ZCD1INTP             : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned ZCD1POL              : 1;
  unsigned ZCD1OUT              : 1;
  unsigned                      : 1;
  unsigned ZCD1EN               : 1;
  } __ZCD1CONbits_t;

extern __at(0x011C) volatile __ZCD1CONbits_t ZCD1CONbits;

#define _ZCD1INTN               0x01
#define _ZCD1INTP               0x02
#define _ZCD1POL                0x10
#define _ZCD1OUT                0x20
#define _ZCD1EN                 0x80

//==============================================================================


//==============================================================================
//        ANSELA Bits

extern __at(0x018C) __sfr ANSELA;

typedef union
  {
  struct
    {
    unsigned ANSA0              : 1;
    unsigned ANSA1              : 1;
    unsigned ANSA2              : 1;
    unsigned ANSA3              : 1;
    unsigned ANSA4              : 1;
    unsigned ANSA5              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ANSA               : 6;
    unsigned                    : 2;
    };
  } __ANSELAbits_t;

extern __at(0x018C) volatile __ANSELAbits_t ANSELAbits;

#define _ANSA0                  0x01
#define _ANSA1                  0x02
#define _ANSA2                  0x04
#define _ANSA3                  0x08
#define _ANSA4                  0x10
#define _ANSA5                  0x20

//==============================================================================


//==============================================================================
//        ANSELB Bits

extern __at(0x018D) __sfr ANSELB;

typedef union
  {
  struct
    {
    unsigned ANSB0              : 1;
    unsigned ANSB1              : 1;
    unsigned ANSB2              : 1;
    unsigned ANSB3              : 1;
    unsigned ANSB4              : 1;
    unsigned ANSB5              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ANSB               : 6;
    unsigned                    : 2;
    };
  } __ANSELBbits_t;

extern __at(0x018D) volatile __ANSELBbits_t ANSELBbits;

#define _ANSB0                  0x01
#define _ANSB1                  0x02
#define _ANSB2                  0x04
#define _ANSB3                  0x08
#define _ANSB4                  0x10
#define _ANSB5                  0x20

//==============================================================================


//==============================================================================
//        ANSELC Bits

extern __at(0x018E) __sfr ANSELC;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned ANSC2                : 1;
  unsigned ANSC3                : 1;
  unsigned ANSC4                : 1;
  unsigned ANSC5                : 1;
  unsigned ANSC6                : 1;
  unsigned ANSC7                : 1;
  } __ANSELCbits_t;

extern __at(0x018E) volatile __ANSELCbits_t ANSELCbits;

#define _ANSC2                  0x04
#define _ANSC3                  0x08
#define _ANSC4                  0x10
#define _ANSC5                  0x20
#define _ANSC6                  0x40
#define _ANSC7                  0x80

//==============================================================================


//==============================================================================
//        ANSELD Bits

extern __at(0x018F) __sfr ANSELD;

typedef struct
  {
  unsigned ANSD0                : 1;
  unsigned ANSD1                : 1;
  unsigned ANSD2                : 1;
  unsigned ANSD3                : 1;
  unsigned ANSD4                : 1;
  unsigned ANSD5                : 1;
  unsigned ANSD6                : 1;
  unsigned ANSD7                : 1;
  } __ANSELDbits_t;

extern __at(0x018F) volatile __ANSELDbits_t ANSELDbits;

#define _ANSD0                  0x01
#define _ANSD1                  0x02
#define _ANSD2                  0x04
#define _ANSD3                  0x08
#define _ANSD4                  0x10
#define _ANSD5                  0x20
#define _ANSD6                  0x40
#define _ANSD7                  0x80

//==============================================================================


//==============================================================================
//        ANSELE Bits

extern __at(0x0190) __sfr ANSELE;

typedef union
  {
  struct
    {
    unsigned ANSE0              : 1;
    unsigned ANSE1              : 1;
    unsigned ANSE2              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ANSE               : 3;
    unsigned                    : 5;
    };
  } __ANSELEbits_t;

extern __at(0x0190) volatile __ANSELEbits_t ANSELEbits;

#define _ANSE0                  0x01
#define _ANSE1                  0x02
#define _ANSE2                  0x04

//==============================================================================

extern __at(0x0191) __sfr PMADR;
extern __at(0x0191) __sfr PMADRL;
extern __at(0x0192) __sfr PMADRH;
extern __at(0x0193) __sfr PMDAT;
extern __at(0x0193) __sfr PMDATL;
extern __at(0x0194) __sfr PMDATH;

//==============================================================================
//        PMCON1 Bits

extern __at(0x0195) __sfr PMCON1;

typedef struct
  {
  unsigned RD                   : 1;
  unsigned WR                   : 1;
  unsigned WREN                 : 1;
  unsigned WRERR                : 1;
  unsigned FREE                 : 1;
  unsigned LWLO                 : 1;
  unsigned CFGS                 : 1;
  unsigned                      : 1;
  } __PMCON1bits_t;

extern __at(0x0195) volatile __PMCON1bits_t PMCON1bits;

#define _RD                     0x01
#define _WR                     0x02
#define _WREN                   0x04
#define _WRERR                  0x08
#define _FREE                   0x10
#define _LWLO                   0x20
#define _CFGS                   0x40

//==============================================================================

extern __at(0x0196) __sfr PMCON2;

//==============================================================================
//        VREGCON Bits

extern __at(0x0197) __sfr VREGCON;

typedef struct
  {
  unsigned Reserved             : 1;
  unsigned VREGPM               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __VREGCONbits_t;

extern __at(0x0197) volatile __VREGCONbits_t VREGCONbits;

#define _Reserved               0x01
#define _VREGPM                 0x02

//==============================================================================

extern __at(0x0199) __sfr RC1REG;
extern __at(0x0199) __sfr RCREG;
extern __at(0x0199) __sfr RCREG1;
extern __at(0x019A) __sfr TX1REG;
extern __at(0x019A) __sfr TXREG;
extern __at(0x019A) __sfr TXREG1;
extern __at(0x019B) __sfr SP1BRG;
extern __at(0x019B) __sfr SP1BRGL;
extern __at(0x019B) __sfr SPBRG;
extern __at(0x019B) __sfr SPBRG1;
extern __at(0x019B) __sfr SPBRGL;
extern __at(0x019C) __sfr SP1BRGH;
extern __at(0x019C) __sfr SPBRGH;
extern __at(0x019C) __sfr SPBRGH1;

//==============================================================================
//        RC1STA Bits

extern __at(0x019D) __sfr RC1STA;

typedef struct
  {
  unsigned RX9D                 : 1;
  unsigned OERR                 : 1;
  unsigned FERR                 : 1;
  unsigned ADDEN                : 1;
  unsigned CREN                 : 1;
  unsigned SREN                 : 1;
  unsigned RX9                  : 1;
  unsigned SPEN                 : 1;
  } __RC1STAbits_t;

extern __at(0x019D) volatile __RC1STAbits_t RC1STAbits;

#define _RX9D                   0x01
#define _OERR                   0x02
#define _FERR                   0x04
#define _ADDEN                  0x08
#define _CREN                   0x10
#define _SREN                   0x20
#define _RX9                    0x40
#define _SPEN                   0x80

//==============================================================================


//==============================================================================
//        RCSTA Bits

extern __at(0x019D) __sfr RCSTA;

typedef struct
  {
  unsigned RX9D                 : 1;
  unsigned OERR                 : 1;
  unsigned FERR                 : 1;
  unsigned ADDEN                : 1;
  unsigned CREN                 : 1;
  unsigned SREN                 : 1;
  unsigned RX9                  : 1;
  unsigned SPEN                 : 1;
  } __RCSTAbits_t;

extern __at(0x019D) volatile __RCSTAbits_t RCSTAbits;

#define _RCSTA_RX9D             0x01
#define _RCSTA_OERR             0x02
#define _RCSTA_FERR             0x04
#define _RCSTA_ADDEN            0x08
#define _RCSTA_CREN             0x10
#define _RCSTA_SREN             0x20
#define _RCSTA_RX9              0x40
#define _RCSTA_SPEN             0x80

//==============================================================================


//==============================================================================
//        RCSTA1 Bits

extern __at(0x019D) __sfr RCSTA1;

typedef struct
  {
  unsigned RX9D                 : 1;
  unsigned OERR                 : 1;
  unsigned FERR                 : 1;
  unsigned ADDEN                : 1;
  unsigned CREN                 : 1;
  unsigned SREN                 : 1;
  unsigned RX9                  : 1;
  unsigned SPEN                 : 1;
  } __RCSTA1bits_t;

extern __at(0x019D) volatile __RCSTA1bits_t RCSTA1bits;

#define _RCSTA1_RX9D            0x01
#define _RCSTA1_OERR            0x02
#define _RCSTA1_FERR            0x04
#define _RCSTA1_ADDEN           0x08
#define _RCSTA1_CREN            0x10
#define _RCSTA1_SREN            0x20
#define _RCSTA1_RX9             0x40
#define _RCSTA1_SPEN            0x80

//==============================================================================


//==============================================================================
//        TX1STA Bits

extern __at(0x019E) __sfr TX1STA;

typedef struct
  {
  unsigned TX9D                 : 1;
  unsigned TRMT                 : 1;
  unsigned BRGH                 : 1;
  unsigned SENDB                : 1;
  unsigned SYNC                 : 1;
  unsigned TXEN                 : 1;
  unsigned TX9                  : 1;
  unsigned CSRC                 : 1;
  } __TX1STAbits_t;

extern __at(0x019E) volatile __TX1STAbits_t TX1STAbits;

#define _TX9D                   0x01
#define _TRMT                   0x02
#define _BRGH                   0x04
#define _SENDB                  0x08
#define _SYNC                   0x10
#define _TXEN                   0x20
#define _TX9                    0x40
#define _CSRC                   0x80

//==============================================================================


//==============================================================================
//        TXSTA Bits

extern __at(0x019E) __sfr TXSTA;

typedef struct
  {
  unsigned TX9D                 : 1;
  unsigned TRMT                 : 1;
  unsigned BRGH                 : 1;
  unsigned SENDB                : 1;
  unsigned SYNC                 : 1;
  unsigned TXEN                 : 1;
  unsigned TX9                  : 1;
  unsigned CSRC                 : 1;
  } __TXSTAbits_t;

extern __at(0x019E) volatile __TXSTAbits_t TXSTAbits;

#define _TXSTA_TX9D             0x01
#define _TXSTA_TRMT             0x02
#define _TXSTA_BRGH             0x04
#define _TXSTA_SENDB            0x08
#define _TXSTA_SYNC             0x10
#define _TXSTA_TXEN             0x20
#define _TXSTA_TX9              0x40
#define _TXSTA_CSRC             0x80

//==============================================================================


//==============================================================================
//        TXSTA1 Bits

extern __at(0x019E) __sfr TXSTA1;

typedef struct
  {
  unsigned TX9D                 : 1;
  unsigned TRMT                 : 1;
  unsigned BRGH                 : 1;
  unsigned SENDB                : 1;
  unsigned SYNC                 : 1;
  unsigned TXEN                 : 1;
  unsigned TX9                  : 1;
  unsigned CSRC                 : 1;
  } __TXSTA1bits_t;

extern __at(0x019E) volatile __TXSTA1bits_t TXSTA1bits;

#define _TXSTA1_TX9D            0x01
#define _TXSTA1_TRMT            0x02
#define _TXSTA1_BRGH            0x04
#define _TXSTA1_SENDB           0x08
#define _TXSTA1_SYNC            0x10
#define _TXSTA1_TXEN            0x20
#define _TXSTA1_TX9             0x40
#define _TXSTA1_CSRC            0x80

//==============================================================================


//==============================================================================
//        BAUD1CON Bits

extern __at(0x019F) __sfr BAUD1CON;

typedef struct
  {
  unsigned ABDEN                : 1;
  unsigned WUE                  : 1;
  unsigned                      : 1;
  unsigned BRG16                : 1;
  unsigned SCKP                 : 1;
  unsigned                      : 1;
  unsigned RCIDL                : 1;
  unsigned ABDOVF               : 1;
  } __BAUD1CONbits_t;

extern __at(0x019F) volatile __BAUD1CONbits_t BAUD1CONbits;

#define _ABDEN                  0x01
#define _WUE                    0x02
#define _BRG16                  0x08
#define _SCKP                   0x10
#define _RCIDL                  0x40
#define _ABDOVF                 0x80

//==============================================================================


//==============================================================================
//        BAUDCON Bits

extern __at(0x019F) __sfr BAUDCON;

typedef struct
  {
  unsigned ABDEN                : 1;
  unsigned WUE                  : 1;
  unsigned                      : 1;
  unsigned BRG16                : 1;
  unsigned SCKP                 : 1;
  unsigned                      : 1;
  unsigned RCIDL                : 1;
  unsigned ABDOVF               : 1;
  } __BAUDCONbits_t;

extern __at(0x019F) volatile __BAUDCONbits_t BAUDCONbits;

#define _BAUDCON_ABDEN          0x01
#define _BAUDCON_WUE            0x02
#define _BAUDCON_BRG16          0x08
#define _BAUDCON_SCKP           0x10
#define _BAUDCON_RCIDL          0x40
#define _BAUDCON_ABDOVF         0x80

//==============================================================================


//==============================================================================
//        BAUDCON1 Bits

extern __at(0x019F) __sfr BAUDCON1;

typedef struct
  {
  unsigned ABDEN                : 1;
  unsigned WUE                  : 1;
  unsigned                      : 1;
  unsigned BRG16                : 1;
  unsigned SCKP                 : 1;
  unsigned                      : 1;
  unsigned RCIDL                : 1;
  unsigned ABDOVF               : 1;
  } __BAUDCON1bits_t;

extern __at(0x019F) volatile __BAUDCON1bits_t BAUDCON1bits;

#define _BAUDCON1_ABDEN         0x01
#define _BAUDCON1_WUE           0x02
#define _BAUDCON1_BRG16         0x08
#define _BAUDCON1_SCKP          0x10
#define _BAUDCON1_RCIDL         0x40
#define _BAUDCON1_ABDOVF        0x80

//==============================================================================


//==============================================================================
//        BAUDCTL Bits

extern __at(0x019F) __sfr BAUDCTL;

typedef struct
  {
  unsigned ABDEN                : 1;
  unsigned WUE                  : 1;
  unsigned                      : 1;
  unsigned BRG16                : 1;
  unsigned SCKP                 : 1;
  unsigned                      : 1;
  unsigned RCIDL                : 1;
  unsigned ABDOVF               : 1;
  } __BAUDCTLbits_t;

extern __at(0x019F) volatile __BAUDCTLbits_t BAUDCTLbits;

#define _BAUDCTL_ABDEN          0x01
#define _BAUDCTL_WUE            0x02
#define _BAUDCTL_BRG16          0x08
#define _BAUDCTL_SCKP           0x10
#define _BAUDCTL_RCIDL          0x40
#define _BAUDCTL_ABDOVF         0x80

//==============================================================================


//==============================================================================
//        BAUDCTL1 Bits

extern __at(0x019F) __sfr BAUDCTL1;

typedef struct
  {
  unsigned ABDEN                : 1;
  unsigned WUE                  : 1;
  unsigned                      : 1;
  unsigned BRG16                : 1;
  unsigned SCKP                 : 1;
  unsigned                      : 1;
  unsigned RCIDL                : 1;
  unsigned ABDOVF               : 1;
  } __BAUDCTL1bits_t;

extern __at(0x019F) volatile __BAUDCTL1bits_t BAUDCTL1bits;

#define _BAUDCTL1_ABDEN         0x01
#define _BAUDCTL1_WUE           0x02
#define _BAUDCTL1_BRG16         0x08
#define _BAUDCTL1_SCKP          0x10
#define _BAUDCTL1_RCIDL         0x40
#define _BAUDCTL1_ABDOVF        0x80

//==============================================================================


//==============================================================================
//        WPUA Bits

extern __at(0x020C) __sfr WPUA;

typedef struct
  {
  unsigned WPUA0                : 1;
  unsigned WPUA1                : 1;
  unsigned WPUA2                : 1;
  unsigned WPUA3                : 1;
  unsigned WPUA4                : 1;
  unsigned WPUA5                : 1;
  unsigned WPUA6                : 1;
  unsigned WPUA7                : 1;
  } __WPUAbits_t;

extern __at(0x020C) volatile __WPUAbits_t WPUAbits;

#define _WPUA0                  0x01
#define _WPUA1                  0x02
#define _WPUA2                  0x04
#define _WPUA3                  0x08
#define _WPUA4                  0x10
#define _WPUA5                  0x20
#define _WPUA6                  0x40
#define _WPUA7                  0x80

//==============================================================================


//==============================================================================
//        WPUB Bits

extern __at(0x020D) __sfr WPUB;

typedef struct
  {
  unsigned WPUB0                : 1;
  unsigned WPUB1                : 1;
  unsigned WPUB2                : 1;
  unsigned WPUB3                : 1;
  unsigned WPUB4                : 1;
  unsigned WPUB5                : 1;
  unsigned WPUB6                : 1;
  unsigned WPUB7                : 1;
  } __WPUBbits_t;

extern __at(0x020D) volatile __WPUBbits_t WPUBbits;

#define _WPUB0                  0x01
#define _WPUB1                  0x02
#define _WPUB2                  0x04
#define _WPUB3                  0x08
#define _WPUB4                  0x10
#define _WPUB5                  0x20
#define _WPUB6                  0x40
#define _WPUB7                  0x80

//==============================================================================


//==============================================================================
//        WPUC Bits

extern __at(0x020E) __sfr WPUC;

typedef struct
  {
  unsigned WPUC0                : 1;
  unsigned WPUC1                : 1;
  unsigned WPUC2                : 1;
  unsigned WPUC3                : 1;
  unsigned WPUC4                : 1;
  unsigned WPUC5                : 1;
  unsigned WPUC6                : 1;
  unsigned WPUC7                : 1;
  } __WPUCbits_t;

extern __at(0x020E) volatile __WPUCbits_t WPUCbits;

#define _WPUC0                  0x01
#define _WPUC1                  0x02
#define _WPUC2                  0x04
#define _WPUC3                  0x08
#define _WPUC4                  0x10
#define _WPUC5                  0x20
#define _WPUC6                  0x40
#define _WPUC7                  0x80

//==============================================================================


//==============================================================================
//        WPUD Bits

extern __at(0x020F) __sfr WPUD;

typedef struct
  {
  unsigned WPUD0                : 1;
  unsigned WPUD1                : 1;
  unsigned WPUD2                : 1;
  unsigned WPUD3                : 1;
  unsigned WPUD4                : 1;
  unsigned WPUD5                : 1;
  unsigned WPUD6                : 1;
  unsigned WPUD7                : 1;
  } __WPUDbits_t;

extern __at(0x020F) volatile __WPUDbits_t WPUDbits;

#define _WPUD0                  0x01
#define _WPUD1                  0x02
#define _WPUD2                  0x04
#define _WPUD3                  0x08
#define _WPUD4                  0x10
#define _WPUD5                  0x20
#define _WPUD6                  0x40
#define _WPUD7                  0x80

//==============================================================================


//==============================================================================
//        WPUE Bits

extern __at(0x0210) __sfr WPUE;

typedef union
  {
  struct
    {
    unsigned WPUE0              : 1;
    unsigned WPUE1              : 1;
    unsigned WPUE2              : 1;
    unsigned WPUE3              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned WPUE               : 4;
    unsigned                    : 4;
    };
  } __WPUEbits_t;

extern __at(0x0210) volatile __WPUEbits_t WPUEbits;

#define _WPUE0                  0x01
#define _WPUE1                  0x02
#define _WPUE2                  0x04
#define _WPUE3                  0x08

//==============================================================================


//==============================================================================
//        SSP1BUF Bits

extern __at(0x0211) __sfr SSP1BUF;

typedef union
  {
  struct
    {
    unsigned SSP1BUF0           : 1;
    unsigned SSP1BUF1           : 1;
    unsigned SSP1BUF2           : 1;
    unsigned SSP1BUF3           : 1;
    unsigned SSP1BUF4           : 1;
    unsigned SSP1BUF5           : 1;
    unsigned SSP1BUF6           : 1;
    unsigned SSP1BUF7           : 1;
    };

  struct
    {
    unsigned BUF0               : 1;
    unsigned BUF1               : 1;
    unsigned BUF2               : 1;
    unsigned BUF3               : 1;
    unsigned BUF4               : 1;
    unsigned BUF5               : 1;
    unsigned BUF6               : 1;
    unsigned BUF7               : 1;
    };
  } __SSP1BUFbits_t;

extern __at(0x0211) volatile __SSP1BUFbits_t SSP1BUFbits;

#define _SSP1BUF0               0x01
#define _BUF0                   0x01
#define _SSP1BUF1               0x02
#define _BUF1                   0x02
#define _SSP1BUF2               0x04
#define _BUF2                   0x04
#define _SSP1BUF3               0x08
#define _BUF3                   0x08
#define _SSP1BUF4               0x10
#define _BUF4                   0x10
#define _SSP1BUF5               0x20
#define _BUF5                   0x20
#define _SSP1BUF6               0x40
#define _BUF6                   0x40
#define _SSP1BUF7               0x80
#define _BUF7                   0x80

//==============================================================================


//==============================================================================
//        SSPBUF Bits

extern __at(0x0211) __sfr SSPBUF;

typedef union
  {
  struct
    {
    unsigned SSP1BUF0           : 1;
    unsigned SSP1BUF1           : 1;
    unsigned SSP1BUF2           : 1;
    unsigned SSP1BUF3           : 1;
    unsigned SSP1BUF4           : 1;
    unsigned SSP1BUF5           : 1;
    unsigned SSP1BUF6           : 1;
    unsigned SSP1BUF7           : 1;
    };

  struct
    {
    unsigned BUF0               : 1;
    unsigned BUF1               : 1;
    unsigned BUF2               : 1;
    unsigned BUF3               : 1;
    unsigned BUF4               : 1;
    unsigned BUF5               : 1;
    unsigned BUF6               : 1;
    unsigned BUF7               : 1;
    };
  } __SSPBUFbits_t;

extern __at(0x0211) volatile __SSPBUFbits_t SSPBUFbits;

#define _SSPBUF_SSP1BUF0        0x01
#define _SSPBUF_BUF0            0x01
#define _SSPBUF_SSP1BUF1        0x02
#define _SSPBUF_BUF1            0x02
#define _SSPBUF_SSP1BUF2        0x04
#define _SSPBUF_BUF2            0x04
#define _SSPBUF_SSP1BUF3        0x08
#define _SSPBUF_BUF3            0x08
#define _SSPBUF_SSP1BUF4        0x10
#define _SSPBUF_BUF4            0x10
#define _SSPBUF_SSP1BUF5        0x20
#define _SSPBUF_BUF5            0x20
#define _SSPBUF_SSP1BUF6        0x40
#define _SSPBUF_BUF6            0x40
#define _SSPBUF_SSP1BUF7        0x80
#define _SSPBUF_BUF7            0x80

//==============================================================================


//==============================================================================
//        SSP1ADD Bits

extern __at(0x0212) __sfr SSP1ADD;

typedef union
  {
  struct
    {
    unsigned SSP1ADD0           : 1;
    unsigned SSP1ADD1           : 1;
    unsigned SSP1ADD2           : 1;
    unsigned SSP1ADD3           : 1;
    unsigned SSP1ADD4           : 1;
    unsigned SSP1ADD5           : 1;
    unsigned SSP1ADD6           : 1;
    unsigned SSP1ADD7           : 1;
    };

  struct
    {
    unsigned ADD0               : 1;
    unsigned ADD1               : 1;
    unsigned ADD2               : 1;
    unsigned ADD3               : 1;
    unsigned ADD4               : 1;
    unsigned ADD5               : 1;
    unsigned ADD6               : 1;
    unsigned ADD7               : 1;
    };
  } __SSP1ADDbits_t;

extern __at(0x0212) volatile __SSP1ADDbits_t SSP1ADDbits;

#define _SSP1ADD0               0x01
#define _ADD0                   0x01
#define _SSP1ADD1               0x02
#define _ADD1                   0x02
#define _SSP1ADD2               0x04
#define _ADD2                   0x04
#define _SSP1ADD3               0x08
#define _ADD3                   0x08
#define _SSP1ADD4               0x10
#define _ADD4                   0x10
#define _SSP1ADD5               0x20
#define _ADD5                   0x20
#define _SSP1ADD6               0x40
#define _ADD6                   0x40
#define _SSP1ADD7               0x80
#define _ADD7                   0x80

//==============================================================================


//==============================================================================
//        SSPADD Bits

extern __at(0x0212) __sfr SSPADD;

typedef union
  {
  struct
    {
    unsigned SSP1ADD0           : 1;
    unsigned SSP1ADD1           : 1;
    unsigned SSP1ADD2           : 1;
    unsigned SSP1ADD3           : 1;
    unsigned SSP1ADD4           : 1;
    unsigned SSP1ADD5           : 1;
    unsigned SSP1ADD6           : 1;
    unsigned SSP1ADD7           : 1;
    };

  struct
    {
    unsigned ADD0               : 1;
    unsigned ADD1               : 1;
    unsigned ADD2               : 1;
    unsigned ADD3               : 1;
    unsigned ADD4               : 1;
    unsigned ADD5               : 1;
    unsigned ADD6               : 1;
    unsigned ADD7               : 1;
    };
  } __SSPADDbits_t;

extern __at(0x0212) volatile __SSPADDbits_t SSPADDbits;

#define _SSPADD_SSP1ADD0        0x01
#define _SSPADD_ADD0            0x01
#define _SSPADD_SSP1ADD1        0x02
#define _SSPADD_ADD1            0x02
#define _SSPADD_SSP1ADD2        0x04
#define _SSPADD_ADD2            0x04
#define _SSPADD_SSP1ADD3        0x08
#define _SSPADD_ADD3            0x08
#define _SSPADD_SSP1ADD4        0x10
#define _SSPADD_ADD4            0x10
#define _SSPADD_SSP1ADD5        0x20
#define _SSPADD_ADD5            0x20
#define _SSPADD_SSP1ADD6        0x40
#define _SSPADD_ADD6            0x40
#define _SSPADD_SSP1ADD7        0x80
#define _SSPADD_ADD7            0x80

//==============================================================================


//==============================================================================
//        SSP1MSK Bits

extern __at(0x0213) __sfr SSP1MSK;

typedef union
  {
  struct
    {
    unsigned SSP1MSK0           : 1;
    unsigned SSP1MSK1           : 1;
    unsigned SSP1MSK2           : 1;
    unsigned SSP1MSK3           : 1;
    unsigned SSP1MSK4           : 1;
    unsigned SSP1MSK5           : 1;
    unsigned SSP1MSK6           : 1;
    unsigned SSP1MSK7           : 1;
    };

  struct
    {
    unsigned MSK0               : 1;
    unsigned MSK1               : 1;
    unsigned MSK2               : 1;
    unsigned MSK3               : 1;
    unsigned MSK4               : 1;
    unsigned MSK5               : 1;
    unsigned MSK6               : 1;
    unsigned MSK7               : 1;
    };
  } __SSP1MSKbits_t;

extern __at(0x0213) volatile __SSP1MSKbits_t SSP1MSKbits;

#define _SSP1MSK0               0x01
#define _MSK0                   0x01
#define _SSP1MSK1               0x02
#define _MSK1                   0x02
#define _SSP1MSK2               0x04
#define _MSK2                   0x04
#define _SSP1MSK3               0x08
#define _MSK3                   0x08
#define _SSP1MSK4               0x10
#define _MSK4                   0x10
#define _SSP1MSK5               0x20
#define _MSK5                   0x20
#define _SSP1MSK6               0x40
#define _MSK6                   0x40
#define _SSP1MSK7               0x80
#define _MSK7                   0x80

//==============================================================================


//==============================================================================
//        SSPMSK Bits

extern __at(0x0213) __sfr SSPMSK;

typedef union
  {
  struct
    {
    unsigned SSP1MSK0           : 1;
    unsigned SSP1MSK1           : 1;
    unsigned SSP1MSK2           : 1;
    unsigned SSP1MSK3           : 1;
    unsigned SSP1MSK4           : 1;
    unsigned SSP1MSK5           : 1;
    unsigned SSP1MSK6           : 1;
    unsigned SSP1MSK7           : 1;
    };

  struct
    {
    unsigned MSK0               : 1;
    unsigned MSK1               : 1;
    unsigned MSK2               : 1;
    unsigned MSK3               : 1;
    unsigned MSK4               : 1;
    unsigned MSK5               : 1;
    unsigned MSK6               : 1;
    unsigned MSK7               : 1;
    };
  } __SSPMSKbits_t;

extern __at(0x0213) volatile __SSPMSKbits_t SSPMSKbits;

#define _SSPMSK_SSP1MSK0        0x01
#define _SSPMSK_MSK0            0x01
#define _SSPMSK_SSP1MSK1        0x02
#define _SSPMSK_MSK1            0x02
#define _SSPMSK_SSP1MSK2        0x04
#define _SSPMSK_MSK2            0x04
#define _SSPMSK_SSP1MSK3        0x08
#define _SSPMSK_MSK3            0x08
#define _SSPMSK_SSP1MSK4        0x10
#define _SSPMSK_MSK4            0x10
#define _SSPMSK_SSP1MSK5        0x20
#define _SSPMSK_MSK5            0x20
#define _SSPMSK_SSP1MSK6        0x40
#define _SSPMSK_MSK6            0x40
#define _SSPMSK_SSP1MSK7        0x80
#define _SSPMSK_MSK7            0x80

//==============================================================================


//==============================================================================
//        SSP1STAT Bits

extern __at(0x0214) __sfr SSP1STAT;

typedef struct
  {
  unsigned BF                   : 1;
  unsigned UA                   : 1;
  unsigned R_NOT_W              : 1;
  unsigned S                    : 1;
  unsigned P                    : 1;
  unsigned D_NOT_A              : 1;
  unsigned CKE                  : 1;
  unsigned SMP                  : 1;
  } __SSP1STATbits_t;

extern __at(0x0214) volatile __SSP1STATbits_t SSP1STATbits;

#define _BF                     0x01
#define _UA                     0x02
#define _R_NOT_W                0x04
#define _S                      0x08
#define _P                      0x10
#define _D_NOT_A                0x20
#define _CKE                    0x40
#define _SMP                    0x80

//==============================================================================


//==============================================================================
//        SSPSTAT Bits

extern __at(0x0214) __sfr SSPSTAT;

typedef struct
  {
  unsigned BF                   : 1;
  unsigned UA                   : 1;
  unsigned R_NOT_W              : 1;
  unsigned S                    : 1;
  unsigned P                    : 1;
  unsigned D_NOT_A              : 1;
  unsigned CKE                  : 1;
  unsigned SMP                  : 1;
  } __SSPSTATbits_t;

extern __at(0x0214) volatile __SSPSTATbits_t SSPSTATbits;

#define _SSPSTAT_BF             0x01
#define _SSPSTAT_UA             0x02
#define _SSPSTAT_R_NOT_W        0x04
#define _SSPSTAT_S              0x08
#define _SSPSTAT_P              0x10
#define _SSPSTAT_D_NOT_A        0x20
#define _SSPSTAT_CKE            0x40
#define _SSPSTAT_SMP            0x80

//==============================================================================


//==============================================================================
//        SSP1CON Bits

extern __at(0x0215) __sfr SSP1CON;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSP1CONbits_t;

extern __at(0x0215) volatile __SSP1CONbits_t SSP1CONbits;

#define _SSPM0                  0x01
#define _SSPM1                  0x02
#define _SSPM2                  0x04
#define _SSPM3                  0x08
#define _CKP                    0x10
#define _SSPEN                  0x20
#define _SSPOV                  0x40
#define _WCOL                   0x80

//==============================================================================


//==============================================================================
//        SSP1CON1 Bits

extern __at(0x0215) __sfr SSP1CON1;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSP1CON1bits_t;

extern __at(0x0215) volatile __SSP1CON1bits_t SSP1CON1bits;

#define _SSP1CON1_SSPM0         0x01
#define _SSP1CON1_SSPM1         0x02
#define _SSP1CON1_SSPM2         0x04
#define _SSP1CON1_SSPM3         0x08
#define _SSP1CON1_CKP           0x10
#define _SSP1CON1_SSPEN         0x20
#define _SSP1CON1_SSPOV         0x40
#define _SSP1CON1_WCOL          0x80

//==============================================================================


//==============================================================================
//        SSPCON Bits

extern __at(0x0215) __sfr SSPCON;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSPCONbits_t;

extern __at(0x0215) volatile __SSPCONbits_t SSPCONbits;

#define _SSPCON_SSPM0           0x01
#define _SSPCON_SSPM1           0x02
#define _SSPCON_SSPM2           0x04
#define _SSPCON_SSPM3           0x08
#define _SSPCON_CKP             0x10
#define _SSPCON_SSPEN           0x20
#define _SSPCON_SSPOV           0x40
#define _SSPCON_WCOL            0x80

//==============================================================================


//==============================================================================
//        SSPCON1 Bits

extern __at(0x0215) __sfr SSPCON1;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSPCON1bits_t;

extern __at(0x0215) volatile __SSPCON1bits_t SSPCON1bits;

#define _SSPCON1_SSPM0          0x01
#define _SSPCON1_SSPM1          0x02
#define _SSPCON1_SSPM2          0x04
#define _SSPCON1_SSPM3          0x08
#define _SSPCON1_CKP            0x10
#define _SSPCON1_SSPEN          0x20
#define _SSPCON1_SSPOV          0x40
#define _SSPCON1_WCOL           0x80

//==============================================================================


//==============================================================================
//        SSP1CON2 Bits

extern __at(0x0216) __sfr SSP1CON2;

typedef struct
  {
  unsigned SEN                  : 1;
  unsigned RSEN                 : 1;
  unsigned PEN                  : 1;
  unsigned RCEN                 : 1;
  unsigned ACKEN                : 1;
  unsigned ACKDT                : 1;
  unsigned ACKSTAT              : 1;
  unsigned GCEN                 : 1;
  } __SSP1CON2bits_t;

extern __at(0x0216) volatile __SSP1CON2bits_t SSP1CON2bits;

#define _SEN                    0x01
#define _RSEN                   0x02
#define _PEN                    0x04
#define _RCEN                   0x08
#define _ACKEN                  0x10
#define _ACKDT                  0x20
#define _ACKSTAT                0x40
#define _GCEN                   0x80

//==============================================================================


//==============================================================================
//        SSPCON2 Bits

extern __at(0x0216) __sfr SSPCON2;

typedef struct
  {
  unsigned SEN                  : 1;
  unsigned RSEN                 : 1;
  unsigned PEN                  : 1;
  unsigned RCEN                 : 1;
  unsigned ACKEN                : 1;
  unsigned ACKDT                : 1;
  unsigned ACKSTAT              : 1;
  unsigned GCEN                 : 1;
  } __SSPCON2bits_t;

extern __at(0x0216) volatile __SSPCON2bits_t SSPCON2bits;

#define _SSPCON2_SEN            0x01
#define _SSPCON2_RSEN           0x02
#define _SSPCON2_PEN            0x04
#define _SSPCON2_RCEN           0x08
#define _SSPCON2_ACKEN          0x10
#define _SSPCON2_ACKDT          0x20
#define _SSPCON2_ACKSTAT        0x40
#define _SSPCON2_GCEN           0x80

//==============================================================================


//==============================================================================
//        SSP1CON3 Bits

extern __at(0x0217) __sfr SSP1CON3;

typedef struct
  {
  unsigned DHEN                 : 1;
  unsigned AHEN                 : 1;
  unsigned SBCDE                : 1;
  unsigned SDAHT                : 1;
  unsigned BOEN                 : 1;
  unsigned SCIE                 : 1;
  unsigned PCIE                 : 1;
  unsigned ACKTIM               : 1;
  } __SSP1CON3bits_t;

extern __at(0x0217) volatile __SSP1CON3bits_t SSP1CON3bits;

#define _DHEN                   0x01
#define _AHEN                   0x02
#define _SBCDE                  0x04
#define _SDAHT                  0x08
#define _BOEN                   0x10
#define _SCIE                   0x20
#define _PCIE                   0x40
#define _ACKTIM                 0x80

//==============================================================================


//==============================================================================
//        SSPCON3 Bits

extern __at(0x0217) __sfr SSPCON3;

typedef struct
  {
  unsigned DHEN                 : 1;
  unsigned AHEN                 : 1;
  unsigned SBCDE                : 1;
  unsigned SDAHT                : 1;
  unsigned BOEN                 : 1;
  unsigned SCIE                 : 1;
  unsigned PCIE                 : 1;
  unsigned ACKTIM               : 1;
  } __SSPCON3bits_t;

extern __at(0x0217) volatile __SSPCON3bits_t SSPCON3bits;

#define _SSPCON3_DHEN           0x01
#define _SSPCON3_AHEN           0x02
#define _SSPCON3_SBCDE          0x04
#define _SSPCON3_SDAHT          0x08
#define _SSPCON3_BOEN           0x10
#define _SSPCON3_SCIE           0x20
#define _SSPCON3_PCIE           0x40
#define _SSPCON3_ACKTIM         0x80

//==============================================================================


//==============================================================================
//        ODCONA Bits

extern __at(0x028C) __sfr ODCONA;

typedef struct
  {
  unsigned ODA0                 : 1;
  unsigned ODA1                 : 1;
  unsigned ODA2                 : 1;
  unsigned ODA3                 : 1;
  unsigned ODA4                 : 1;
  unsigned ODA5                 : 1;
  unsigned ODA6                 : 1;
  unsigned ODA7                 : 1;
  } __ODCONAbits_t;

extern __at(0x028C) volatile __ODCONAbits_t ODCONAbits;

#define _ODA0                   0x01
#define _ODA1                   0x02
#define _ODA2                   0x04
#define _ODA3                   0x08
#define _ODA4                   0x10
#define _ODA5                   0x20
#define _ODA6                   0x40
#define _ODA7                   0x80

//==============================================================================


//==============================================================================
//        ODCONB Bits

extern __at(0x028D) __sfr ODCONB;

typedef struct
  {
  unsigned ODB0                 : 1;
  unsigned ODB1                 : 1;
  unsigned ODB2                 : 1;
  unsigned ODB3                 : 1;
  unsigned ODB4                 : 1;
  unsigned ODB5                 : 1;
  unsigned ODB6                 : 1;
  unsigned ODB7                 : 1;
  } __ODCONBbits_t;

extern __at(0x028D) volatile __ODCONBbits_t ODCONBbits;

#define _ODB0                   0x01
#define _ODB1                   0x02
#define _ODB2                   0x04
#define _ODB3                   0x08
#define _ODB4                   0x10
#define _ODB5                   0x20
#define _ODB6                   0x40
#define _ODB7                   0x80

//==============================================================================


//==============================================================================
//        ODCONC Bits

extern __at(0x028E) __sfr ODCONC;

typedef struct
  {
  unsigned ODC0                 : 1;
  unsigned ODC1                 : 1;
  unsigned ODC2                 : 1;
  unsigned ODC3                 : 1;
  unsigned ODC4                 : 1;
  unsigned ODC5                 : 1;
  unsigned ODC6                 : 1;
  unsigned ODC7                 : 1;
  } __ODCONCbits_t;

extern __at(0x028E) volatile __ODCONCbits_t ODCONCbits;

#define _ODC0                   0x01
#define _ODC1                   0x02
#define _ODC2                   0x04
#define _ODC3                   0x08
#define _ODC4                   0x10
#define _ODC5                   0x20
#define _ODC6                   0x40
#define _ODC7                   0x80

//==============================================================================


//==============================================================================
//        ODCOND Bits

extern __at(0x028F) __sfr ODCOND;

typedef struct
  {
  unsigned ODD0                 : 1;
  unsigned ODD1                 : 1;
  unsigned ODD2                 : 1;
  unsigned ODD3                 : 1;
  unsigned ODD4                 : 1;
  unsigned ODD5                 : 1;
  unsigned ODD6                 : 1;
  unsigned ODD7                 : 1;
  } __ODCONDbits_t;

extern __at(0x028F) volatile __ODCONDbits_t ODCONDbits;

#define _ODD0                   0x01
#define _ODD1                   0x02
#define _ODD2                   0x04
#define _ODD3                   0x08
#define _ODD4                   0x10
#define _ODD5                   0x20
#define _ODD6                   0x40
#define _ODD7                   0x80

//==============================================================================


//==============================================================================
//        ODCONE Bits

extern __at(0x0290) __sfr ODCONE;

typedef union
  {
  struct
    {
    unsigned ODE0               : 1;
    unsigned ODE1               : 1;
    unsigned ODE2               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ODE                : 3;
    unsigned                    : 5;
    };
  } __ODCONEbits_t;

extern __at(0x0290) volatile __ODCONEbits_t ODCONEbits;

#define _ODE0                   0x01
#define _ODE1                   0x02
#define _ODE2                   0x04

//==============================================================================

extern __at(0x0291) __sfr CCPR1;
extern __at(0x0291) __sfr CCPR1L;
extern __at(0x0292) __sfr CCPR1H;

//==============================================================================
//        CCP1CON Bits

extern __at(0x0293) __sfr CCP1CON;

typedef union
  {
  struct
    {
    unsigned CCP1M0             : 1;
    unsigned CCP1M1             : 1;
    unsigned CCP1M2             : 1;
    unsigned CCP1M3             : 1;
    unsigned DC1B0              : 1;
    unsigned DC1B1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CCP1Y              : 1;
    unsigned CCP1X              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP1M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC1B               : 2;
    unsigned                    : 2;
    };
  } __CCP1CONbits_t;

extern __at(0x0293) volatile __CCP1CONbits_t CCP1CONbits;

#define _CCP1M0                 0x01
#define _CCP1M1                 0x02
#define _CCP1M2                 0x04
#define _CCP1M3                 0x08
#define _DC1B0                  0x10
#define _CCP1Y                  0x10
#define _DC1B1                  0x20
#define _CCP1X                  0x20

//==============================================================================


//==============================================================================
//        ECCP1CON Bits

extern __at(0x0293) __sfr ECCP1CON;

typedef union
  {
  struct
    {
    unsigned CCP1M0             : 1;
    unsigned CCP1M1             : 1;
    unsigned CCP1M2             : 1;
    unsigned CCP1M3             : 1;
    unsigned DC1B0              : 1;
    unsigned DC1B1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CCP1Y              : 1;
    unsigned CCP1X              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP1M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC1B               : 2;
    unsigned                    : 2;
    };
  } __ECCP1CONbits_t;

extern __at(0x0293) volatile __ECCP1CONbits_t ECCP1CONbits;

#define _ECCP1CON_CCP1M0        0x01
#define _ECCP1CON_CCP1M1        0x02
#define _ECCP1CON_CCP1M2        0x04
#define _ECCP1CON_CCP1M3        0x08
#define _ECCP1CON_DC1B0         0x10
#define _ECCP1CON_CCP1Y         0x10
#define _ECCP1CON_DC1B1         0x20
#define _ECCP1CON_CCP1X         0x20

//==============================================================================

extern __at(0x0298) __sfr CCPR2;
extern __at(0x0298) __sfr CCPR2L;
extern __at(0x0299) __sfr CCPR2H;

//==============================================================================
//        CCP2CON Bits

extern __at(0x029A) __sfr CCP2CON;

typedef union
  {
  struct
    {
    unsigned CCP2M0             : 1;
    unsigned CCP2M1             : 1;
    unsigned CCP2M2             : 1;
    unsigned CCP2M3             : 1;
    unsigned DC2B0              : 1;
    unsigned DC2B1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CCP2Y              : 1;
    unsigned CCP2X              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP2M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC2B               : 2;
    unsigned                    : 2;
    };
  } __CCP2CONbits_t;

extern __at(0x029A) volatile __CCP2CONbits_t CCP2CONbits;

#define _CCP2M0                 0x01
#define _CCP2M1                 0x02
#define _CCP2M2                 0x04
#define _CCP2M3                 0x08
#define _DC2B0                  0x10
#define _CCP2Y                  0x10
#define _DC2B1                  0x20
#define _CCP2X                  0x20

//==============================================================================


//==============================================================================
//        ECCP2CON Bits

extern __at(0x029A) __sfr ECCP2CON;

typedef union
  {
  struct
    {
    unsigned CCP2M0             : 1;
    unsigned CCP2M1             : 1;
    unsigned CCP2M2             : 1;
    unsigned CCP2M3             : 1;
    unsigned DC2B0              : 1;
    unsigned DC2B1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CCP2Y              : 1;
    unsigned CCP2X              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP2M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC2B               : 2;
    unsigned                    : 2;
    };
  } __ECCP2CONbits_t;

extern __at(0x029A) volatile __ECCP2CONbits_t ECCP2CONbits;

#define _ECCP2CON_CCP2M0        0x01
#define _ECCP2CON_CCP2M1        0x02
#define _ECCP2CON_CCP2M2        0x04
#define _ECCP2CON_CCP2M3        0x08
#define _ECCP2CON_DC2B0         0x10
#define _ECCP2CON_CCP2Y         0x10
#define _ECCP2CON_DC2B1         0x20
#define _ECCP2CON_CCP2X         0x20

//==============================================================================


//==============================================================================
//        CCPTMRS Bits

extern __at(0x029E) __sfr CCPTMRS;

typedef union
  {
  struct
    {
    unsigned C1TSEL0            : 1;
    unsigned C1TSEL1            : 1;
    unsigned C2TSEL0            : 1;
    unsigned C2TSEL1            : 1;
    unsigned P3TSEL0            : 1;
    unsigned P3TSEL1            : 1;
    unsigned P4TSEL0            : 1;
    unsigned P4TSEL1            : 1;
    };

  struct
    {
    unsigned C1TSEL             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned C2TSEL             : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned P3TSEL             : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned P4TSEL             : 2;
    };
  } __CCPTMRSbits_t;

extern __at(0x029E) volatile __CCPTMRSbits_t CCPTMRSbits;

#define _C1TSEL0                0x01
#define _C1TSEL1                0x02
#define _C2TSEL0                0x04
#define _C2TSEL1                0x08
#define _P3TSEL0                0x10
#define _P3TSEL1                0x20
#define _P4TSEL0                0x40
#define _P4TSEL1                0x80

//==============================================================================


//==============================================================================
//        SLRCONA Bits

extern __at(0x030C) __sfr SLRCONA;

typedef struct
  {
  unsigned SLRA0                : 1;
  unsigned SLRA1                : 1;
  unsigned SLRA2                : 1;
  unsigned SLRA3                : 1;
  unsigned SLRA4                : 1;
  unsigned SLRA5                : 1;
  unsigned SLRA6                : 1;
  unsigned SLRA7                : 1;
  } __SLRCONAbits_t;

extern __at(0x030C) volatile __SLRCONAbits_t SLRCONAbits;

#define _SLRA0                  0x01
#define _SLRA1                  0x02
#define _SLRA2                  0x04
#define _SLRA3                  0x08
#define _SLRA4                  0x10
#define _SLRA5                  0x20
#define _SLRA6                  0x40
#define _SLRA7                  0x80

//==============================================================================


//==============================================================================
//        SLRCONB Bits

extern __at(0x030D) __sfr SLRCONB;

typedef struct
  {
  unsigned SLRB0                : 1;
  unsigned SLRB1                : 1;
  unsigned SLRB2                : 1;
  unsigned SLRB3                : 1;
  unsigned SLRB4                : 1;
  unsigned SLRB5                : 1;
  unsigned SLRB6                : 1;
  unsigned SLRB7                : 1;
  } __SLRCONBbits_t;

extern __at(0x030D) volatile __SLRCONBbits_t SLRCONBbits;

#define _SLRB0                  0x01
#define _SLRB1                  0x02
#define _SLRB2                  0x04
#define _SLRB3                  0x08
#define _SLRB4                  0x10
#define _SLRB5                  0x20
#define _SLRB6                  0x40
#define _SLRB7                  0x80

//==============================================================================


//==============================================================================
//        SLRCONC Bits

extern __at(0x030E) __sfr SLRCONC;

typedef struct
  {
  unsigned SLRC0                : 1;
  unsigned SLRC1                : 1;
  unsigned SLRC2                : 1;
  unsigned SLRC3                : 1;
  unsigned SLRC4                : 1;
  unsigned SLRC5                : 1;
  unsigned SLRC6                : 1;
  unsigned SLRC7                : 1;
  } __SLRCONCbits_t;

extern __at(0x030E) volatile __SLRCONCbits_t SLRCONCbits;

#define _SLRC0                  0x01
#define _SLRC1                  0x02
#define _SLRC2                  0x04
#define _SLRC3                  0x08
#define _SLRC4                  0x10
#define _SLRC5                  0x20
#define _SLRC6                  0x40
#define _SLRC7                  0x80

//==============================================================================


//==============================================================================
//        SLRCOND Bits

extern __at(0x030F) __sfr SLRCOND;

typedef struct
  {
  unsigned SLRD0                : 1;
  unsigned SLRD1                : 1;
  unsigned SLRD2                : 1;
  unsigned SLRD3                : 1;
  unsigned SLRD4                : 1;
  unsigned SLRD5                : 1;
  unsigned SLRD6                : 1;
  unsigned SLRD7                : 1;
  } __SLRCONDbits_t;

extern __at(0x030F) volatile __SLRCONDbits_t SLRCONDbits;

#define _SLRD0                  0x01
#define _SLRD1                  0x02
#define _SLRD2                  0x04
#define _SLRD3                  0x08
#define _SLRD4                  0x10
#define _SLRD5                  0x20
#define _SLRD6                  0x40
#define _SLRD7                  0x80

//==============================================================================


//==============================================================================
//        SLRCONE Bits

extern __at(0x0310) __sfr SLRCONE;

typedef union
  {
  struct
    {
    unsigned SLRE0              : 1;
    unsigned SLRE1              : 1;
    unsigned SLRE2              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SLRE               : 3;
    unsigned                    : 5;
    };
  } __SLRCONEbits_t;

extern __at(0x0310) volatile __SLRCONEbits_t SLRCONEbits;

#define _SLRE0                  0x01
#define _SLRE1                  0x02
#define _SLRE2                  0x04

//==============================================================================


//==============================================================================
//        INLVLA Bits

extern __at(0x038C) __sfr INLVLA;

typedef struct
  {
  unsigned INLVLA0              : 1;
  unsigned INLVLA1              : 1;
  unsigned INLVLA2              : 1;
  unsigned INLVLA3              : 1;
  unsigned INLVLA4              : 1;
  unsigned INLVLA5              : 1;
  unsigned INLVLA6              : 1;
  unsigned INLVLA7              : 1;
  } __INLVLAbits_t;

extern __at(0x038C) volatile __INLVLAbits_t INLVLAbits;

#define _INLVLA0                0x01
#define _INLVLA1                0x02
#define _INLVLA2                0x04
#define _INLVLA3                0x08
#define _INLVLA4                0x10
#define _INLVLA5                0x20
#define _INLVLA6                0x40
#define _INLVLA7                0x80

//==============================================================================


//==============================================================================
//        INLVLB Bits

extern __at(0x038D) __sfr INLVLB;

typedef struct
  {
  unsigned INLVLB0              : 1;
  unsigned INLVLB1              : 1;
  unsigned INLVLB2              : 1;
  unsigned INLVLB3              : 1;
  unsigned INLVLB4              : 1;
  unsigned INLVLB5              : 1;
  unsigned INLVLB6              : 1;
  unsigned INLVLB7              : 1;
  } __INLVLBbits_t;

extern __at(0x038D) volatile __INLVLBbits_t INLVLBbits;

#define _INLVLB0                0x01
#define _INLVLB1                0x02
#define _INLVLB2                0x04
#define _INLVLB3                0x08
#define _INLVLB4                0x10
#define _INLVLB5                0x20
#define _INLVLB6                0x40
#define _INLVLB7                0x80

//==============================================================================


//==============================================================================
//        INLVLC Bits

extern __at(0x038E) __sfr INLVLC;

typedef struct
  {
  unsigned INLVLC0              : 1;
  unsigned INLVLC1              : 1;
  unsigned INLVLC2              : 1;
  unsigned INLVLC3              : 1;
  unsigned INLVLC4              : 1;
  unsigned INLVLC5              : 1;
  unsigned INLVLC6              : 1;
  unsigned INLVLC7              : 1;
  } __INLVLCbits_t;

extern __at(0x038E) volatile __INLVLCbits_t INLVLCbits;

#define _INLVLC0                0x01
#define _INLVLC1                0x02
#define _INLVLC2                0x04
#define _INLVLC3                0x08
#define _INLVLC4                0x10
#define _INLVLC5                0x20
#define _INLVLC6                0x40
#define _INLVLC7                0x80

//==============================================================================


//==============================================================================
//        INLVLD Bits

extern __at(0x038F) __sfr INLVLD;

typedef struct
  {
  unsigned INLVLD0              : 1;
  unsigned INLVLD1              : 1;
  unsigned INLVLD2              : 1;
  unsigned INLVLD3              : 1;
  unsigned INLVLD4              : 1;
  unsigned INLVLD5              : 1;
  unsigned INLVLD6              : 1;
  unsigned INLVLD7              : 1;
  } __INLVLDbits_t;

extern __at(0x038F) volatile __INLVLDbits_t INLVLDbits;

#define _INLVLD0                0x01
#define _INLVLD1                0x02
#define _INLVLD2                0x04
#define _INLVLD3                0x08
#define _INLVLD4                0x10
#define _INLVLD5                0x20
#define _INLVLD6                0x40
#define _INLVLD7                0x80

//==============================================================================


//==============================================================================
//        INLVLE Bits

extern __at(0x0390) __sfr INLVLE;

typedef union
  {
  struct
    {
    unsigned INLVLE0            : 1;
    unsigned INLVLE1            : 1;
    unsigned INLVLE2            : 1;
    unsigned INLVLE3            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned INLVLE             : 4;
    unsigned                    : 4;
    };
  } __INLVLEbits_t;

extern __at(0x0390) volatile __INLVLEbits_t INLVLEbits;

#define _INLVLE0                0x01
#define _INLVLE1                0x02
#define _INLVLE2                0x04
#define _INLVLE3                0x08

//==============================================================================


//==============================================================================
//        IOCAP Bits

extern __at(0x0391) __sfr IOCAP;

typedef struct
  {
  unsigned IOCAP0               : 1;
  unsigned IOCAP1               : 1;
  unsigned IOCAP2               : 1;
  unsigned IOCAP3               : 1;
  unsigned IOCAP4               : 1;
  unsigned IOCAP5               : 1;
  unsigned IOCAP6               : 1;
  unsigned IOCAP7               : 1;
  } __IOCAPbits_t;

extern __at(0x0391) volatile __IOCAPbits_t IOCAPbits;

#define _IOCAP0                 0x01
#define _IOCAP1                 0x02
#define _IOCAP2                 0x04
#define _IOCAP3                 0x08
#define _IOCAP4                 0x10
#define _IOCAP5                 0x20
#define _IOCAP6                 0x40
#define _IOCAP7                 0x80

//==============================================================================


//==============================================================================
//        IOCAN Bits

extern __at(0x0392) __sfr IOCAN;

typedef struct
  {
  unsigned IOCAN0               : 1;
  unsigned IOCAN1               : 1;
  unsigned IOCAN2               : 1;
  unsigned IOCAN3               : 1;
  unsigned IOCAN4               : 1;
  unsigned IOCAN5               : 1;
  unsigned IOCAN6               : 1;
  unsigned IOCAN7               : 1;
  } __IOCANbits_t;

extern __at(0x0392) volatile __IOCANbits_t IOCANbits;

#define _IOCAN0                 0x01
#define _IOCAN1                 0x02
#define _IOCAN2                 0x04
#define _IOCAN3                 0x08
#define _IOCAN4                 0x10
#define _IOCAN5                 0x20
#define _IOCAN6                 0x40
#define _IOCAN7                 0x80

//==============================================================================


//==============================================================================
//        IOCAF Bits

extern __at(0x0393) __sfr IOCAF;

typedef struct
  {
  unsigned IOCAF0               : 1;
  unsigned IOCAF1               : 1;
  unsigned IOCAF2               : 1;
  unsigned IOCAF3               : 1;
  unsigned IOCAF4               : 1;
  unsigned IOCAF5               : 1;
  unsigned IOCAF6               : 1;
  unsigned IOCAF7               : 1;
  } __IOCAFbits_t;

extern __at(0x0393) volatile __IOCAFbits_t IOCAFbits;

#define _IOCAF0                 0x01
#define _IOCAF1                 0x02
#define _IOCAF2                 0x04
#define _IOCAF3                 0x08
#define _IOCAF4                 0x10
#define _IOCAF5                 0x20
#define _IOCAF6                 0x40
#define _IOCAF7                 0x80

//==============================================================================


//==============================================================================
//        IOCBP Bits

extern __at(0x0394) __sfr IOCBP;

typedef struct
  {
  unsigned IOCBP0               : 1;
  unsigned IOCBP1               : 1;
  unsigned IOCBP2               : 1;
  unsigned IOCBP3               : 1;
  unsigned IOCBP4               : 1;
  unsigned IOCBP5               : 1;
  unsigned IOCBP6               : 1;
  unsigned IOCBP7               : 1;
  } __IOCBPbits_t;

extern __at(0x0394) volatile __IOCBPbits_t IOCBPbits;

#define _IOCBP0                 0x01
#define _IOCBP1                 0x02
#define _IOCBP2                 0x04
#define _IOCBP3                 0x08
#define _IOCBP4                 0x10
#define _IOCBP5                 0x20
#define _IOCBP6                 0x40
#define _IOCBP7                 0x80

//==============================================================================


//==============================================================================
//        IOCBN Bits

extern __at(0x0395) __sfr IOCBN;

typedef struct
  {
  unsigned IOCBN0               : 1;
  unsigned IOCBN1               : 1;
  unsigned IOCBN2               : 1;
  unsigned IOCBN3               : 1;
  unsigned IOCBN4               : 1;
  unsigned IOCBN5               : 1;
  unsigned IOCBN6               : 1;
  unsigned IOCBN7               : 1;
  } __IOCBNbits_t;

extern __at(0x0395) volatile __IOCBNbits_t IOCBNbits;

#define _IOCBN0                 0x01
#define _IOCBN1                 0x02
#define _IOCBN2                 0x04
#define _IOCBN3                 0x08
#define _IOCBN4                 0x10
#define _IOCBN5                 0x20
#define _IOCBN6                 0x40
#define _IOCBN7                 0x80

//==============================================================================


//==============================================================================
//        IOCBF Bits

extern __at(0x0396) __sfr IOCBF;

typedef struct
  {
  unsigned IOCBF0               : 1;
  unsigned IOCBF1               : 1;
  unsigned IOCBF2               : 1;
  unsigned IOCBF3               : 1;
  unsigned IOCBF4               : 1;
  unsigned IOCBF5               : 1;
  unsigned IOCBF6               : 1;
  unsigned IOCBF7               : 1;
  } __IOCBFbits_t;

extern __at(0x0396) volatile __IOCBFbits_t IOCBFbits;

#define _IOCBF0                 0x01
#define _IOCBF1                 0x02
#define _IOCBF2                 0x04
#define _IOCBF3                 0x08
#define _IOCBF4                 0x10
#define _IOCBF5                 0x20
#define _IOCBF6                 0x40
#define _IOCBF7                 0x80

//==============================================================================


//==============================================================================
//        IOCCP Bits

extern __at(0x0397) __sfr IOCCP;

typedef struct
  {
  unsigned IOCCP0               : 1;
  unsigned IOCCP1               : 1;
  unsigned IOCCP2               : 1;
  unsigned IOCCP3               : 1;
  unsigned IOCCP4               : 1;
  unsigned IOCCP5               : 1;
  unsigned IOCCP6               : 1;
  unsigned IOCCP7               : 1;
  } __IOCCPbits_t;

extern __at(0x0397) volatile __IOCCPbits_t IOCCPbits;

#define _IOCCP0                 0x01
#define _IOCCP1                 0x02
#define _IOCCP2                 0x04
#define _IOCCP3                 0x08
#define _IOCCP4                 0x10
#define _IOCCP5                 0x20
#define _IOCCP6                 0x40
#define _IOCCP7                 0x80

//==============================================================================


//==============================================================================
//        IOCCN Bits

extern __at(0x0398) __sfr IOCCN;

typedef struct
  {
  unsigned IOCCN0               : 1;
  unsigned IOCCN1               : 1;
  unsigned IOCCN2               : 1;
  unsigned IOCCN3               : 1;
  unsigned IOCCN4               : 1;
  unsigned IOCCN5               : 1;
  unsigned IOCCN6               : 1;
  unsigned IOCCN7               : 1;
  } __IOCCNbits_t;

extern __at(0x0398) volatile __IOCCNbits_t IOCCNbits;

#define _IOCCN0                 0x01
#define _IOCCN1                 0x02
#define _IOCCN2                 0x04
#define _IOCCN3                 0x08
#define _IOCCN4                 0x10
#define _IOCCN5                 0x20
#define _IOCCN6                 0x40
#define _IOCCN7                 0x80

//==============================================================================


//==============================================================================
//        IOCCF Bits

extern __at(0x0399) __sfr IOCCF;

typedef struct
  {
  unsigned IOCCF0               : 1;
  unsigned IOCCF1               : 1;
  unsigned IOCCF2               : 1;
  unsigned IOCCF3               : 1;
  unsigned IOCCF4               : 1;
  unsigned IOCCF5               : 1;
  unsigned IOCCF6               : 1;
  unsigned IOCCF7               : 1;
  } __IOCCFbits_t;

extern __at(0x0399) volatile __IOCCFbits_t IOCCFbits;

#define _IOCCF0                 0x01
#define _IOCCF1                 0x02
#define _IOCCF2                 0x04
#define _IOCCF3                 0x08
#define _IOCCF4                 0x10
#define _IOCCF5                 0x20
#define _IOCCF6                 0x40
#define _IOCCF7                 0x80

//==============================================================================


//==============================================================================
//        IOCEP Bits

extern __at(0x039D) __sfr IOCEP;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned IOCEP3               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __IOCEPbits_t;

extern __at(0x039D) volatile __IOCEPbits_t IOCEPbits;

#define _IOCEP3                 0x08

//==============================================================================


//==============================================================================
//        IOCEN Bits

extern __at(0x039E) __sfr IOCEN;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned IOCEN3               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __IOCENbits_t;

extern __at(0x039E) volatile __IOCENbits_t IOCENbits;

#define _IOCEN3                 0x08

//==============================================================================


//==============================================================================
//        IOCEF Bits

extern __at(0x039F) __sfr IOCEF;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned IOCEF3               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __IOCEFbits_t;

extern __at(0x039F) volatile __IOCEFbits_t IOCEFbits;

#define _IOCEF3                 0x08

//==============================================================================

extern __at(0x0415) __sfr TMR4;
extern __at(0x0416) __sfr PR4;

//==============================================================================
//        T4CON Bits

extern __at(0x0417) __sfr T4CON;

typedef union
  {
  struct
    {
    unsigned T4CKPS0            : 1;
    unsigned T4CKPS1            : 1;
    unsigned TMR4ON             : 1;
    unsigned T4OUTPS0           : 1;
    unsigned T4OUTPS1           : 1;
    unsigned T4OUTPS2           : 1;
    unsigned T4OUTPS3           : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T4CKPS             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned T4OUTPS            : 4;
    unsigned                    : 1;
    };
  } __T4CONbits_t;

extern __at(0x0417) volatile __T4CONbits_t T4CONbits;

#define _T4CKPS0                0x01
#define _T4CKPS1                0x02
#define _TMR4ON                 0x04
#define _T4OUTPS0               0x08
#define _T4OUTPS1               0x10
#define _T4OUTPS2               0x20
#define _T4OUTPS3               0x40

//==============================================================================

extern __at(0x041C) __sfr TMR6;
extern __at(0x041D) __sfr PR6;

//==============================================================================
//        T6CON Bits

extern __at(0x041E) __sfr T6CON;

typedef union
  {
  struct
    {
    unsigned T6CKPS0            : 1;
    unsigned T6CKPS1            : 1;
    unsigned TMR6ON             : 1;
    unsigned T6OUTPS0           : 1;
    unsigned T6OUTPS1           : 1;
    unsigned T6OUTPS2           : 1;
    unsigned T6OUTPS3           : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T6CKPS             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned T6OUTPS            : 4;
    unsigned                    : 1;
    };
  } __T6CONbits_t;

extern __at(0x041E) volatile __T6CONbits_t T6CONbits;

#define _T6CKPS0                0x01
#define _T6CKPS1                0x02
#define _TMR6ON                 0x04
#define _T6OUTPS0               0x08
#define _T6OUTPS1               0x10
#define _T6OUTPS2               0x20
#define _T6OUTPS3               0x40

//==============================================================================

extern __at(0x0498) __sfr NCO1ACC;

//==============================================================================
//        NCO1ACCL Bits

extern __at(0x0498) __sfr NCO1ACCL;

typedef struct
  {
  unsigned NCO1ACC0             : 1;
  unsigned NCO1ACC1             : 1;
  unsigned NCO1ACC2             : 1;
  unsigned NCO1ACC3             : 1;
  unsigned NCO1ACC4             : 1;
  unsigned NCO1ACC5             : 1;
  unsigned NCO1ACC6             : 1;
  unsigned NCO1ACC7             : 1;
  } __NCO1ACCLbits_t;

extern __at(0x0498) volatile __NCO1ACCLbits_t NCO1ACCLbits;

#define _NCO1ACC0               0x01
#define _NCO1ACC1               0x02
#define _NCO1ACC2               0x04
#define _NCO1ACC3               0x08
#define _NCO1ACC4               0x10
#define _NCO1ACC5               0x20
#define _NCO1ACC6               0x40
#define _NCO1ACC7               0x80

//==============================================================================


//==============================================================================
//        NCO1ACCH Bits

extern __at(0x0499) __sfr NCO1ACCH;

typedef struct
  {
  unsigned NCO1ACC8             : 1;
  unsigned NCO1ACC9             : 1;
  unsigned NCO1ACC10            : 1;
  unsigned NCO1ACC11            : 1;
  unsigned NCO1ACC12            : 1;
  unsigned NCO1ACC13            : 1;
  unsigned NCO1ACC14            : 1;
  unsigned NCO1ACC15            : 1;
  } __NCO1ACCHbits_t;

extern __at(0x0499) volatile __NCO1ACCHbits_t NCO1ACCHbits;

#define _NCO1ACC8               0x01
#define _NCO1ACC9               0x02
#define _NCO1ACC10              0x04
#define _NCO1ACC11              0x08
#define _NCO1ACC12              0x10
#define _NCO1ACC13              0x20
#define _NCO1ACC14              0x40
#define _NCO1ACC15              0x80

//==============================================================================


//==============================================================================
//        NCO1ACCU Bits

extern __at(0x049A) __sfr NCO1ACCU;

typedef struct
  {
  unsigned NCO1ACC16            : 1;
  unsigned NCO1ACC17            : 1;
  unsigned NCO1ACC18            : 1;
  unsigned NCO1ACC19            : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __NCO1ACCUbits_t;

extern __at(0x049A) volatile __NCO1ACCUbits_t NCO1ACCUbits;

#define _NCO1ACC16              0x01
#define _NCO1ACC17              0x02
#define _NCO1ACC18              0x04
#define _NCO1ACC19              0x08

//==============================================================================

extern __at(0x049B) __sfr NCO1INC;

//==============================================================================
//        NCO1INCL Bits

extern __at(0x049B) __sfr NCO1INCL;

typedef struct
  {
  unsigned NCO1INC0             : 1;
  unsigned NCO1INC1             : 1;
  unsigned NCO1INC2             : 1;
  unsigned NCO1INC3             : 1;
  unsigned NCO1INC4             : 1;
  unsigned NCO1INC5             : 1;
  unsigned NCO1INC6             : 1;
  unsigned NCO1INC7             : 1;
  } __NCO1INCLbits_t;

extern __at(0x049B) volatile __NCO1INCLbits_t NCO1INCLbits;

#define _NCO1INC0               0x01
#define _NCO1INC1               0x02
#define _NCO1INC2               0x04
#define _NCO1INC3               0x08
#define _NCO1INC4               0x10
#define _NCO1INC5               0x20
#define _NCO1INC6               0x40
#define _NCO1INC7               0x80

//==============================================================================


//==============================================================================
//        NCO1INCH Bits

extern __at(0x049C) __sfr NCO1INCH;

typedef struct
  {
  unsigned NCO1INC8             : 1;
  unsigned NCO1INC9             : 1;
  unsigned NCO1INC10            : 1;
  unsigned NCO1INC11            : 1;
  unsigned NCO1INC12            : 1;
  unsigned NCO1INC13            : 1;
  unsigned NCO1INC14            : 1;
  unsigned NCO1INC15            : 1;
  } __NCO1INCHbits_t;

extern __at(0x049C) volatile __NCO1INCHbits_t NCO1INCHbits;

#define _NCO1INC8               0x01
#define _NCO1INC9               0x02
#define _NCO1INC10              0x04
#define _NCO1INC11              0x08
#define _NCO1INC12              0x10
#define _NCO1INC13              0x20
#define _NCO1INC14              0x40
#define _NCO1INC15              0x80

//==============================================================================


//==============================================================================
//        NCO1INCU Bits

extern __at(0x049D) __sfr NCO1INCU;

typedef struct
  {
  unsigned NCO1INC16            : 1;
  unsigned NCO1INC17            : 1;
  unsigned NCO1INC18            : 1;
  unsigned NCO1INC19            : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __NCO1INCUbits_t;

extern __at(0x049D) volatile __NCO1INCUbits_t NCO1INCUbits;

#define _NCO1INC16              0x01
#define _NCO1INC17              0x02
#define _NCO1INC18              0x04
#define _NCO1INC19              0x08

//==============================================================================


//==============================================================================
//        NCO1CON Bits

extern __at(0x049E) __sfr NCO1CON;

typedef struct
  {
  unsigned N1PFM                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned N1POL                : 1;
  unsigned N1OUT                : 1;
  unsigned                      : 1;
  unsigned N1EN                 : 1;
  } __NCO1CONbits_t;

extern __at(0x049E) volatile __NCO1CONbits_t NCO1CONbits;

#define _N1PFM                  0x01
#define _N1POL                  0x10
#define _N1OUT                  0x20
#define _N1EN                   0x80

//==============================================================================


//==============================================================================
//        NCO1CLK Bits

extern __at(0x049F) __sfr NCO1CLK;

typedef union
  {
  struct
    {
    unsigned N1CKS0             : 1;
    unsigned N1CKS1             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned N1PWS0             : 1;
    unsigned N1PWS1             : 1;
    unsigned N1PWS2             : 1;
    };

  struct
    {
    unsigned N1CKS              : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 5;
    unsigned N1PWS              : 3;
    };
  } __NCO1CLKbits_t;

extern __at(0x049F) volatile __NCO1CLKbits_t NCO1CLKbits;

#define _N1CKS0                 0x01
#define _N1CKS1                 0x02
#define _N1PWS0                 0x20
#define _N1PWS1                 0x40
#define _N1PWS2                 0x80

//==============================================================================


//==============================================================================
//        OPA1CON Bits

extern __at(0x0511) __sfr OPA1CON;

typedef union
  {
  struct
    {
    unsigned OPA1PCH0           : 1;
    unsigned OPA1PCH1           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned OPA1UG             : 1;
    unsigned                    : 1;
    unsigned OPA1SP             : 1;
    unsigned OPA1EN             : 1;
    };

  struct
    {
    unsigned OPA1PCH            : 2;
    unsigned                    : 6;
    };
  } __OPA1CONbits_t;

extern __at(0x0511) volatile __OPA1CONbits_t OPA1CONbits;

#define _OPA1PCH0               0x01
#define _OPA1PCH1               0x02
#define _OPA1UG                 0x10
#define _OPA1SP                 0x40
#define _OPA1EN                 0x80

//==============================================================================


//==============================================================================
//        OPA2CON Bits

extern __at(0x0515) __sfr OPA2CON;

typedef union
  {
  struct
    {
    unsigned OPA2PCH0           : 1;
    unsigned OPA2PCH1           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned OPA2UG             : 1;
    unsigned                    : 1;
    unsigned OPA2SP             : 1;
    unsigned OPA2EN             : 1;
    };

  struct
    {
    unsigned OPA2PCH            : 2;
    unsigned                    : 6;
    };
  } __OPA2CONbits_t;

extern __at(0x0515) volatile __OPA2CONbits_t OPA2CONbits;

#define _OPA2PCH0               0x01
#define _OPA2PCH1               0x02
#define _OPA2UG                 0x10
#define _OPA2SP                 0x40
#define _OPA2EN                 0x80

//==============================================================================


//==============================================================================
//        PWM3DCL Bits

extern __at(0x0617) __sfr PWM3DCL;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PWM3DCL0           : 1;
    unsigned PWM3DCL1           : 1;
    };

  struct
    {
    unsigned                    : 6;
    unsigned PWM3DCL            : 2;
    };
  } __PWM3DCLbits_t;

extern __at(0x0617) volatile __PWM3DCLbits_t PWM3DCLbits;

#define _PWM3DCL0               0x40
#define _PWM3DCL1               0x80

//==============================================================================


//==============================================================================
//        PWM3DCH Bits

extern __at(0x0618) __sfr PWM3DCH;

typedef struct
  {
  unsigned PWM3DCH0             : 1;
  unsigned PWM3DCH1             : 1;
  unsigned PWM3DCH2             : 1;
  unsigned PWM3DCH3             : 1;
  unsigned PWM3DCH4             : 1;
  unsigned PWM3DCH5             : 1;
  unsigned PWM3DCH6             : 1;
  unsigned PWM3DCH7             : 1;
  } __PWM3DCHbits_t;

extern __at(0x0618) volatile __PWM3DCHbits_t PWM3DCHbits;

#define _PWM3DCH0               0x01
#define _PWM3DCH1               0x02
#define _PWM3DCH2               0x04
#define _PWM3DCH3               0x08
#define _PWM3DCH4               0x10
#define _PWM3DCH5               0x20
#define _PWM3DCH6               0x40
#define _PWM3DCH7               0x80

//==============================================================================


//==============================================================================
//        PWM3CON Bits

extern __at(0x0619) __sfr PWM3CON;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned PWM3POL              : 1;
  unsigned PWM3OUT              : 1;
  unsigned                      : 1;
  unsigned PWM3EN               : 1;
  } __PWM3CONbits_t;

extern __at(0x0619) volatile __PWM3CONbits_t PWM3CONbits;

#define _PWM3POL                0x10
#define _PWM3OUT                0x20
#define _PWM3EN                 0x80

//==============================================================================


//==============================================================================
//        PWM3CON0 Bits

extern __at(0x0619) __sfr PWM3CON0;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned PWM3POL              : 1;
  unsigned PWM3OUT              : 1;
  unsigned                      : 1;
  unsigned PWM3EN               : 1;
  } __PWM3CON0bits_t;

extern __at(0x0619) volatile __PWM3CON0bits_t PWM3CON0bits;

#define _PWM3CON0_PWM3POL       0x10
#define _PWM3CON0_PWM3OUT       0x20
#define _PWM3CON0_PWM3EN        0x80

//==============================================================================


//==============================================================================
//        PWM4DCL Bits

extern __at(0x061A) __sfr PWM4DCL;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PWM4DCL0           : 1;
    unsigned PWM4DCL1           : 1;
    };

  struct
    {
    unsigned                    : 6;
    unsigned PWM4DCL            : 2;
    };
  } __PWM4DCLbits_t;

extern __at(0x061A) volatile __PWM4DCLbits_t PWM4DCLbits;

#define _PWM4DCL0               0x40
#define _PWM4DCL1               0x80

//==============================================================================


//==============================================================================
//        PWM4DCH Bits

extern __at(0x061B) __sfr PWM4DCH;

typedef struct
  {
  unsigned PWM4DCH0             : 1;
  unsigned PWM4DCH1             : 1;
  unsigned PWM4DCH2             : 1;
  unsigned PWM4DCH3             : 1;
  unsigned PWM4DCH4             : 1;
  unsigned PWM4DCH5             : 1;
  unsigned PWM4DCH6             : 1;
  unsigned PWM4DCH7             : 1;
  } __PWM4DCHbits_t;

extern __at(0x061B) volatile __PWM4DCHbits_t PWM4DCHbits;

#define _PWM4DCH0               0x01
#define _PWM4DCH1               0x02
#define _PWM4DCH2               0x04
#define _PWM4DCH3               0x08
#define _PWM4DCH4               0x10
#define _PWM4DCH5               0x20
#define _PWM4DCH6               0x40
#define _PWM4DCH7               0x80

//==============================================================================


//==============================================================================
//        PWM4CON Bits

extern __at(0x061C) __sfr PWM4CON;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned PWM4POL              : 1;
  unsigned PWM4OUT              : 1;
  unsigned                      : 1;
  unsigned PWM4EN               : 1;
  } __PWM4CONbits_t;

extern __at(0x061C) volatile __PWM4CONbits_t PWM4CONbits;

#define _PWM4POL                0x10
#define _PWM4OUT                0x20
#define _PWM4EN                 0x80

//==============================================================================


//==============================================================================
//        PWM4CON0 Bits

extern __at(0x061C) __sfr PWM4CON0;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned PWM4POL              : 1;
  unsigned PWM4OUT              : 1;
  unsigned                      : 1;
  unsigned PWM4EN               : 1;
  } __PWM4CON0bits_t;

extern __at(0x061C) volatile __PWM4CON0bits_t PWM4CON0bits;

#define _PWM4CON0_PWM4POL       0x10
#define _PWM4CON0_PWM4OUT       0x20
#define _PWM4CON0_PWM4EN        0x80

//==============================================================================


//==============================================================================
//        COG1PHR Bits

extern __at(0x0691) __sfr COG1PHR;

typedef union
  {
  struct
    {
    unsigned G1PHR0             : 1;
    unsigned G1PHR1             : 1;
    unsigned G1PHR2             : 1;
    unsigned G1PHR3             : 1;
    unsigned G1PHR4             : 1;
    unsigned G1PHR5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned G1PHR              : 6;
    unsigned                    : 2;
    };
  } __COG1PHRbits_t;

extern __at(0x0691) volatile __COG1PHRbits_t COG1PHRbits;

#define _G1PHR0                 0x01
#define _G1PHR1                 0x02
#define _G1PHR2                 0x04
#define _G1PHR3                 0x08
#define _G1PHR4                 0x10
#define _G1PHR5                 0x20

//==============================================================================


//==============================================================================
//        COG1PHF Bits

extern __at(0x0692) __sfr COG1PHF;

typedef union
  {
  struct
    {
    unsigned G1PHF0             : 1;
    unsigned G1PHF1             : 1;
    unsigned G1PHF2             : 1;
    unsigned G1PHF3             : 1;
    unsigned G1PHF4             : 1;
    unsigned G1PHF5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned G1PHF              : 6;
    unsigned                    : 2;
    };
  } __COG1PHFbits_t;

extern __at(0x0692) volatile __COG1PHFbits_t COG1PHFbits;

#define _G1PHF0                 0x01
#define _G1PHF1                 0x02
#define _G1PHF2                 0x04
#define _G1PHF3                 0x08
#define _G1PHF4                 0x10
#define _G1PHF5                 0x20

//==============================================================================


//==============================================================================
//        COG1BLKR Bits

extern __at(0x0693) __sfr COG1BLKR;

typedef union
  {
  struct
    {
    unsigned G1BLKR0            : 1;
    unsigned G1BLKR1            : 1;
    unsigned G1BLKR2            : 1;
    unsigned G1BLKR3            : 1;
    unsigned G1BLKR4            : 1;
    unsigned G1BLKR5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned G1BLKR             : 6;
    unsigned                    : 2;
    };
  } __COG1BLKRbits_t;

extern __at(0x0693) volatile __COG1BLKRbits_t COG1BLKRbits;

#define _G1BLKR0                0x01
#define _G1BLKR1                0x02
#define _G1BLKR2                0x04
#define _G1BLKR3                0x08
#define _G1BLKR4                0x10
#define _G1BLKR5                0x20

//==============================================================================


//==============================================================================
//        COG1BLKF Bits

extern __at(0x0694) __sfr COG1BLKF;

typedef union
  {
  struct
    {
    unsigned G1BLKF0            : 1;
    unsigned G1BLKF1            : 1;
    unsigned G1BLKF2            : 1;
    unsigned G1BLKF3            : 1;
    unsigned G1BLKF4            : 1;
    unsigned G1BLKF5            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned G1BLKF             : 6;
    unsigned                    : 2;
    };
  } __COG1BLKFbits_t;

extern __at(0x0694) volatile __COG1BLKFbits_t COG1BLKFbits;

#define _G1BLKF0                0x01
#define _G1BLKF1                0x02
#define _G1BLKF2                0x04
#define _G1BLKF3                0x08
#define _G1BLKF4                0x10
#define _G1BLKF5                0x20

//==============================================================================


//==============================================================================
//        COG1DBR Bits

extern __at(0x0695) __sfr COG1DBR;

typedef union
  {
  struct
    {
    unsigned G1DBR0             : 1;
    unsigned G1DBR1             : 1;
    unsigned G1DBR2             : 1;
    unsigned G1DBR3             : 1;
    unsigned G1DBR4             : 1;
    unsigned G1DBR5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned G1DBR              : 6;
    unsigned                    : 2;
    };
  } __COG1DBRbits_t;

extern __at(0x0695) volatile __COG1DBRbits_t COG1DBRbits;

#define _G1DBR0                 0x01
#define _G1DBR1                 0x02
#define _G1DBR2                 0x04
#define _G1DBR3                 0x08
#define _G1DBR4                 0x10
#define _G1DBR5                 0x20

//==============================================================================


//==============================================================================
//        COG1DBF Bits

extern __at(0x0696) __sfr COG1DBF;

typedef union
  {
  struct
    {
    unsigned G1DBF0             : 1;
    unsigned G1DBF1             : 1;
    unsigned G1DBF2             : 1;
    unsigned G1DBF3             : 1;
    unsigned G1DBF4             : 1;
    unsigned G1DBF5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned G1DBF              : 6;
    unsigned                    : 2;
    };
  } __COG1DBFbits_t;

extern __at(0x0696) volatile __COG1DBFbits_t COG1DBFbits;

#define _G1DBF0                 0x01
#define _G1DBF1                 0x02
#define _G1DBF2                 0x04
#define _G1DBF3                 0x08
#define _G1DBF4                 0x10
#define _G1DBF5                 0x20

//==============================================================================


//==============================================================================
//        COG1CON0 Bits

extern __at(0x0697) __sfr COG1CON0;

typedef union
  {
  struct
    {
    unsigned G1MD0              : 1;
    unsigned G1MD1              : 1;
    unsigned G1MD2              : 1;
    unsigned G1CS0              : 1;
    unsigned G1CS1              : 1;
    unsigned                    : 1;
    unsigned G1LD               : 1;
    unsigned G1EN               : 1;
    };

  struct
    {
    unsigned G1MD               : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 3;
    unsigned G1CS               : 2;
    unsigned                    : 3;
    };
  } __COG1CON0bits_t;

extern __at(0x0697) volatile __COG1CON0bits_t COG1CON0bits;

#define _G1MD0                  0x01
#define _G1MD1                  0x02
#define _G1MD2                  0x04
#define _G1CS0                  0x08
#define _G1CS1                  0x10
#define _G1LD                   0x40
#define _G1EN                   0x80

//==============================================================================


//==============================================================================
//        COG1CON1 Bits

extern __at(0x0698) __sfr COG1CON1;

typedef struct
  {
  unsigned G1POLA               : 1;
  unsigned G1POLB               : 1;
  unsigned G1POLC               : 1;
  unsigned G1POLD               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned G1FDBS               : 1;
  unsigned G1RDBS               : 1;
  } __COG1CON1bits_t;

extern __at(0x0698) volatile __COG1CON1bits_t COG1CON1bits;

#define _G1POLA                 0x01
#define _G1POLB                 0x02
#define _G1POLC                 0x04
#define _G1POLD                 0x08
#define _G1FDBS                 0x40
#define _G1RDBS                 0x80

//==============================================================================


//==============================================================================
//        COG1RIS Bits

extern __at(0x0699) __sfr COG1RIS;

typedef struct
  {
  unsigned G1RIS0               : 1;
  unsigned G1RIS1               : 1;
  unsigned G1RIS2               : 1;
  unsigned G1RIS3               : 1;
  unsigned G1RIS4               : 1;
  unsigned G1RIS5               : 1;
  unsigned G1RIS6               : 1;
  unsigned G1RIS7               : 1;
  } __COG1RISbits_t;

extern __at(0x0699) volatile __COG1RISbits_t COG1RISbits;

#define _G1RIS0                 0x01
#define _G1RIS1                 0x02
#define _G1RIS2                 0x04
#define _G1RIS3                 0x08
#define _G1RIS4                 0x10
#define _G1RIS5                 0x20
#define _G1RIS6                 0x40
#define _G1RIS7                 0x80

//==============================================================================


//==============================================================================
//        COG1RSIM Bits

extern __at(0x069A) __sfr COG1RSIM;

typedef struct
  {
  unsigned G1RSIM0              : 1;
  unsigned G1RSIM1              : 1;
  unsigned G1RSIM2              : 1;
  unsigned G1RSIM3              : 1;
  unsigned G1RSIM4              : 1;
  unsigned G1RSIM5              : 1;
  unsigned G1RSIM6              : 1;
  unsigned G1RSIM7              : 1;
  } __COG1RSIMbits_t;

extern __at(0x069A) volatile __COG1RSIMbits_t COG1RSIMbits;

#define _G1RSIM0                0x01
#define _G1RSIM1                0x02
#define _G1RSIM2                0x04
#define _G1RSIM3                0x08
#define _G1RSIM4                0x10
#define _G1RSIM5                0x20
#define _G1RSIM6                0x40
#define _G1RSIM7                0x80

//==============================================================================


//==============================================================================
//        COG1FIS Bits

extern __at(0x069B) __sfr COG1FIS;

typedef struct
  {
  unsigned G1FIS0               : 1;
  unsigned G1FIS1               : 1;
  unsigned G1FIS2               : 1;
  unsigned G1FIS3               : 1;
  unsigned G1FIS4               : 1;
  unsigned G1FIS5               : 1;
  unsigned G1FIS6               : 1;
  unsigned G1FIS7               : 1;
  } __COG1FISbits_t;

extern __at(0x069B) volatile __COG1FISbits_t COG1FISbits;

#define _G1FIS0                 0x01
#define _G1FIS1                 0x02
#define _G1FIS2                 0x04
#define _G1FIS3                 0x08
#define _G1FIS4                 0x10
#define _G1FIS5                 0x20
#define _G1FIS6                 0x40
#define _G1FIS7                 0x80

//==============================================================================


//==============================================================================
//        COG1FSIM Bits

extern __at(0x069C) __sfr COG1FSIM;

typedef struct
  {
  unsigned G1FSIM0              : 1;
  unsigned G1FSIM1              : 1;
  unsigned G1FSIM2              : 1;
  unsigned G1FSIM3              : 1;
  unsigned G1FSIM4              : 1;
  unsigned G1FSIM5              : 1;
  unsigned G1FSIM6              : 1;
  unsigned G1FSIM7              : 1;
  } __COG1FSIMbits_t;

extern __at(0x069C) volatile __COG1FSIMbits_t COG1FSIMbits;

#define _G1FSIM0                0x01
#define _G1FSIM1                0x02
#define _G1FSIM2                0x04
#define _G1FSIM3                0x08
#define _G1FSIM4                0x10
#define _G1FSIM5                0x20
#define _G1FSIM6                0x40
#define _G1FSIM7                0x80

//==============================================================================


//==============================================================================
//        COG1ASD0 Bits

extern __at(0x069D) __sfr COG1ASD0;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned G1ASDAC0           : 1;
    unsigned G1ASDAC1           : 1;
    unsigned G1ASDBD0           : 1;
    unsigned G1ASDBD1           : 1;
    unsigned G1ARSEN            : 1;
    unsigned G1ASE              : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned G1ASDAC            : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned G1ASDBD            : 2;
    unsigned                    : 2;
    };
  } __COG1ASD0bits_t;

extern __at(0x069D) volatile __COG1ASD0bits_t COG1ASD0bits;

#define _G1ASDAC0               0x04
#define _G1ASDAC1               0x08
#define _G1ASDBD0               0x10
#define _G1ASDBD1               0x20
#define _G1ARSEN                0x40
#define _G1ASE                  0x80

//==============================================================================


//==============================================================================
//        COG1ASD1 Bits

extern __at(0x069E) __sfr COG1ASD1;

typedef struct
  {
  unsigned G1AS0E               : 1;
  unsigned G1AS1E               : 1;
  unsigned G1AS2E               : 1;
  unsigned G1AS3E               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __COG1ASD1bits_t;

extern __at(0x069E) volatile __COG1ASD1bits_t COG1ASD1bits;

#define _G1AS0E                 0x01
#define _G1AS1E                 0x02
#define _G1AS2E                 0x04
#define _G1AS3E                 0x08

//==============================================================================


//==============================================================================
//        COG1STR Bits

extern __at(0x069F) __sfr COG1STR;

typedef struct
  {
  unsigned G1STRA               : 1;
  unsigned G1STRB               : 1;
  unsigned G1STRC               : 1;
  unsigned G1STRD               : 1;
  unsigned G1SDATA              : 1;
  unsigned G1SDATB              : 1;
  unsigned G1SDATC              : 1;
  unsigned G1SDATD              : 1;
  } __COG1STRbits_t;

extern __at(0x069F) volatile __COG1STRbits_t COG1STRbits;

#define _G1STRA                 0x01
#define _G1STRB                 0x02
#define _G1STRC                 0x04
#define _G1STRD                 0x08
#define _G1SDATA                0x10
#define _G1SDATB                0x20
#define _G1SDATC                0x40
#define _G1SDATD                0x80

//==============================================================================


//==============================================================================
//        PPSLOCK Bits

extern __at(0x0E0F) __sfr PPSLOCK;

typedef struct
  {
  unsigned PPSLOCKED            : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PPSLOCKbits_t;

extern __at(0x0E0F) volatile __PPSLOCKbits_t PPSLOCKbits;

#define _PPSLOCKED              0x01

//==============================================================================

extern __at(0x0E10) __sfr INTPPS;
extern __at(0x0E11) __sfr T0CKIPPS;
extern __at(0x0E12) __sfr T1CKIPPS;
extern __at(0x0E13) __sfr T1GPPS;
extern __at(0x0E14) __sfr CCP1PPS;
extern __at(0x0E15) __sfr CCP2PPS;
extern __at(0x0E17) __sfr COGINPPS;
extern __at(0x0E20) __sfr SSPCLKPPS;
extern __at(0x0E21) __sfr SSPDATPPS;
extern __at(0x0E22) __sfr SSPSSPPS;
extern __at(0x0E24) __sfr RXPPS;
extern __at(0x0E25) __sfr CKPPS;
extern __at(0x0E28) __sfr CLCIN0PPS;
extern __at(0x0E29) __sfr CLCIN1PPS;
extern __at(0x0E2A) __sfr CLCIN2PPS;
extern __at(0x0E2B) __sfr CLCIN3PPS;
extern __at(0x0E90) __sfr RA0PPS;
extern __at(0x0E91) __sfr RA1PPS;
extern __at(0x0E92) __sfr RA2PPS;
extern __at(0x0E93) __sfr RA3PPS;
extern __at(0x0E94) __sfr RA4PPS;
extern __at(0x0E95) __sfr RA5PPS;
extern __at(0x0E96) __sfr RA6PPS;
extern __at(0x0E97) __sfr RA7PPS;
extern __at(0x0E98) __sfr RB0PPS;
extern __at(0x0E99) __sfr RB1PPS;
extern __at(0x0E9A) __sfr RB2PPS;
extern __at(0x0E9B) __sfr RB3PPS;
extern __at(0x0E9C) __sfr RB4PPS;
extern __at(0x0E9D) __sfr RB5PPS;
extern __at(0x0E9E) __sfr RB6PPS;
extern __at(0x0E9F) __sfr RB7PPS;
extern __at(0x0EA0) __sfr RC0PPS;
extern __at(0x0EA1) __sfr RC1PPS;
extern __at(0x0EA2) __sfr RC2PPS;
extern __at(0x0EA3) __sfr RC3PPS;
extern __at(0x0EA4) __sfr RC4PPS;
extern __at(0x0EA5) __sfr RC5PPS;
extern __at(0x0EA6) __sfr RC6PPS;
extern __at(0x0EA7) __sfr RC7PPS;
extern __at(0x0EA8) __sfr RD0PPS;
extern __at(0x0EA9) __sfr RD1PPS;
extern __at(0x0EAA) __sfr RD2PPS;
extern __at(0x0EAB) __sfr RD3PPS;
extern __at(0x0EAC) __sfr RD4PPS;
extern __at(0x0EAD) __sfr RD5PPS;
extern __at(0x0EAE) __sfr RD6PPS;
extern __at(0x0EAF) __sfr RD7PPS;
extern __at(0x0EB0) __sfr RE0PPS;
extern __at(0x0EB1) __sfr RE1PPS;
extern __at(0x0EB2) __sfr RE2PPS;

//==============================================================================
//        CLCDATA Bits

extern __at(0x0F0F) __sfr CLCDATA;

typedef union
  {
  struct
    {
    unsigned MLC1OUT            : 1;
    unsigned MLC2OUT            : 1;
    unsigned MLC3OUT            : 1;
    unsigned MLC4OUT            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned MCLC1OUT           : 1;
    unsigned MCLC2OUT           : 1;
    unsigned MCLC3OUT           : 1;
    unsigned MCLC4OUT           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __CLCDATAbits_t;

extern __at(0x0F0F) volatile __CLCDATAbits_t CLCDATAbits;

#define _MLC1OUT                0x01
#define _MCLC1OUT               0x01
#define _MLC2OUT                0x02
#define _MCLC2OUT               0x02
#define _MLC3OUT                0x04
#define _MCLC3OUT               0x04
#define _MLC4OUT                0x08
#define _MCLC4OUT               0x08

//==============================================================================


//==============================================================================
//        CLC1CON Bits

extern __at(0x0F10) __sfr CLC1CON;

typedef union
  {
  struct
    {
    unsigned LC1MODE0           : 1;
    unsigned LC1MODE1           : 1;
    unsigned LC1MODE2           : 1;
    unsigned LC1INTN            : 1;
    unsigned LC1INTP            : 1;
    unsigned LC1OUT             : 1;
    unsigned                    : 1;
    unsigned LC1EN              : 1;
    };

  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE2              : 1;
    unsigned INTN               : 1;
    unsigned INTP               : 1;
    unsigned OUT                : 1;
    unsigned                    : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned MODE               : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned LC1MODE            : 3;
    unsigned                    : 5;
    };
  } __CLC1CONbits_t;

extern __at(0x0F10) volatile __CLC1CONbits_t CLC1CONbits;

#define _LC1MODE0               0x01
#define _MODE0                  0x01
#define _LC1MODE1               0x02
#define _MODE1                  0x02
#define _LC1MODE2               0x04
#define _MODE2                  0x04
#define _LC1INTN                0x08
#define _INTN                   0x08
#define _LC1INTP                0x10
#define _INTP                   0x10
#define _LC1OUT                 0x20
#define _OUT                    0x20
#define _LC1EN                  0x80
#define _EN                     0x80

//==============================================================================


//==============================================================================
//        CLC1POL Bits

extern __at(0x0F11) __sfr CLC1POL;

typedef union
  {
  struct
    {
    unsigned LC1G1POL           : 1;
    unsigned LC1G2POL           : 1;
    unsigned LC1G3POL           : 1;
    unsigned LC1G4POL           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LC1POL             : 1;
    };

  struct
    {
    unsigned G1POL              : 1;
    unsigned G2POL              : 1;
    unsigned G3POL              : 1;
    unsigned G4POL              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned POL                : 1;
    };
  } __CLC1POLbits_t;

extern __at(0x0F11) volatile __CLC1POLbits_t CLC1POLbits;

#define _LC1G1POL               0x01
#define _G1POL                  0x01
#define _LC1G2POL               0x02
#define _G2POL                  0x02
#define _LC1G3POL               0x04
#define _G3POL                  0x04
#define _LC1G4POL               0x08
#define _G4POL                  0x08
#define _LC1POL                 0x80
#define _POL                    0x80

//==============================================================================


//==============================================================================
//        CLC1SEL0 Bits

extern __at(0x0F12) __sfr CLC1SEL0;

typedef union
  {
  struct
    {
    unsigned LC1D1S0            : 1;
    unsigned LC1D1S1            : 1;
    unsigned LC1D1S2            : 1;
    unsigned LC1D1S3            : 1;
    unsigned LC1D1S4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D1S0               : 1;
    unsigned D1S1               : 1;
    unsigned D1S2               : 1;
    unsigned D1S3               : 1;
    unsigned D1S4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LC1D1S             : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned D1S                : 5;
    unsigned                    : 3;
    };
  } __CLC1SEL0bits_t;

extern __at(0x0F12) volatile __CLC1SEL0bits_t CLC1SEL0bits;

#define _LC1D1S0                0x01
#define _D1S0                   0x01
#define _LC1D1S1                0x02
#define _D1S1                   0x02
#define _LC1D1S2                0x04
#define _D1S2                   0x04
#define _LC1D1S3                0x08
#define _D1S3                   0x08
#define _LC1D1S4                0x10
#define _D1S4                   0x10

//==============================================================================


//==============================================================================
//        CLC1SEL1 Bits

extern __at(0x0F13) __sfr CLC1SEL1;

typedef union
  {
  struct
    {
    unsigned LC1D2S0            : 1;
    unsigned LC1D2S1            : 1;
    unsigned LC1D2S2            : 1;
    unsigned LC1D2S3            : 1;
    unsigned LC1D2S4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D2S0               : 1;
    unsigned D2S1               : 1;
    unsigned D2S2               : 1;
    unsigned D2S3               : 1;
    unsigned D2S4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LC1D2S             : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned D2S                : 5;
    unsigned                    : 3;
    };
  } __CLC1SEL1bits_t;

extern __at(0x0F13) volatile __CLC1SEL1bits_t CLC1SEL1bits;

#define _LC1D2S0                0x01
#define _D2S0                   0x01
#define _LC1D2S1                0x02
#define _D2S1                   0x02
#define _LC1D2S2                0x04
#define _D2S2                   0x04
#define _LC1D2S3                0x08
#define _D2S3                   0x08
#define _LC1D2S4                0x10
#define _D2S4                   0x10

//==============================================================================


//==============================================================================
//        CLC1SEL2 Bits

extern __at(0x0F14) __sfr CLC1SEL2;

typedef union
  {
  struct
    {
    unsigned LC1D3S0            : 1;
    unsigned LC1D3S1            : 1;
    unsigned LC1D3S2            : 1;
    unsigned LC1D3S3            : 1;
    unsigned LC1D3S4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D3S0               : 1;
    unsigned D3S1               : 1;
    unsigned D3S2               : 1;
    unsigned D3S3               : 1;
    unsigned D3S4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D3S                : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned LC1D3S             : 5;
    unsigned                    : 3;
    };
  } __CLC1SEL2bits_t;

extern __at(0x0F14) volatile __CLC1SEL2bits_t CLC1SEL2bits;

#define _LC1D3S0                0x01
#define _D3S0                   0x01
#define _LC1D3S1                0x02
#define _D3S1                   0x02
#define _LC1D3S2                0x04
#define _D3S2                   0x04
#define _LC1D3S3                0x08
#define _D3S3                   0x08
#define _LC1D3S4                0x10
#define _D3S4                   0x10

//==============================================================================


//==============================================================================
//        CLC1SEL3 Bits

extern __at(0x0F15) __sfr CLC1SEL3;

typedef union
  {
  struct
    {
    unsigned LC1D4S0            : 1;
    unsigned LC1D4S1            : 1;
    unsigned LC1D4S2            : 1;
    unsigned LC1D4S3            : 1;
    unsigned LC1D4S4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D4S0               : 1;
    unsigned D4S1               : 1;
    unsigned D4S2               : 1;
    unsigned D4S3               : 1;
    unsigned D4S4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D4S                : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned LC1D4S             : 5;
    unsigned                    : 3;
    };
  } __CLC1SEL3bits_t;

extern __at(0x0F15) volatile __CLC1SEL3bits_t CLC1SEL3bits;

#define _LC1D4S0                0x01
#define _D4S0                   0x01
#define _LC1D4S1                0x02
#define _D4S1                   0x02
#define _LC1D4S2                0x04
#define _D4S2                   0x04
#define _LC1D4S3                0x08
#define _D4S3                   0x08
#define _LC1D4S4                0x10
#define _D4S4                   0x10

//==============================================================================


//==============================================================================
//        CLC1GLS0 Bits

extern __at(0x0F16) __sfr CLC1GLS0;

typedef union
  {
  struct
    {
    unsigned LC1G1D1N           : 1;
    unsigned LC1G1D1T           : 1;
    unsigned LC1G1D2N           : 1;
    unsigned LC1G1D2T           : 1;
    unsigned LC1G1D3N           : 1;
    unsigned LC1G1D3T           : 1;
    unsigned LC1G1D4N           : 1;
    unsigned LC1G1D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC1GLS0bits_t;

extern __at(0x0F16) volatile __CLC1GLS0bits_t CLC1GLS0bits;

#define _LC1G1D1N               0x01
#define _D1N                    0x01
#define _LC1G1D1T               0x02
#define _D1T                    0x02
#define _LC1G1D2N               0x04
#define _D2N                    0x04
#define _LC1G1D2T               0x08
#define _D2T                    0x08
#define _LC1G1D3N               0x10
#define _D3N                    0x10
#define _LC1G1D3T               0x20
#define _D3T                    0x20
#define _LC1G1D4N               0x40
#define _D4N                    0x40
#define _LC1G1D4T               0x80
#define _D4T                    0x80

//==============================================================================


//==============================================================================
//        CLC1GLS1 Bits

extern __at(0x0F17) __sfr CLC1GLS1;

typedef union
  {
  struct
    {
    unsigned LC1G2D1N           : 1;
    unsigned LC1G2D1T           : 1;
    unsigned LC1G2D2N           : 1;
    unsigned LC1G2D2T           : 1;
    unsigned LC1G2D3N           : 1;
    unsigned LC1G2D3T           : 1;
    unsigned LC1G2D4N           : 1;
    unsigned LC1G2D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC1GLS1bits_t;

extern __at(0x0F17) volatile __CLC1GLS1bits_t CLC1GLS1bits;

#define _CLC1GLS1_LC1G2D1N      0x01
#define _CLC1GLS1_D1N           0x01
#define _CLC1GLS1_LC1G2D1T      0x02
#define _CLC1GLS1_D1T           0x02
#define _CLC1GLS1_LC1G2D2N      0x04
#define _CLC1GLS1_D2N           0x04
#define _CLC1GLS1_LC1G2D2T      0x08
#define _CLC1GLS1_D2T           0x08
#define _CLC1GLS1_LC1G2D3N      0x10
#define _CLC1GLS1_D3N           0x10
#define _CLC1GLS1_LC1G2D3T      0x20
#define _CLC1GLS1_D3T           0x20
#define _CLC1GLS1_LC1G2D4N      0x40
#define _CLC1GLS1_D4N           0x40
#define _CLC1GLS1_LC1G2D4T      0x80
#define _CLC1GLS1_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC1GLS2 Bits

extern __at(0x0F18) __sfr CLC1GLS2;

typedef union
  {
  struct
    {
    unsigned LC1G3D1N           : 1;
    unsigned LC1G3D1T           : 1;
    unsigned LC1G3D2N           : 1;
    unsigned LC1G3D2T           : 1;
    unsigned LC1G3D3N           : 1;
    unsigned LC1G3D3T           : 1;
    unsigned LC1G3D4N           : 1;
    unsigned LC1G3D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC1GLS2bits_t;

extern __at(0x0F18) volatile __CLC1GLS2bits_t CLC1GLS2bits;

#define _CLC1GLS2_LC1G3D1N      0x01
#define _CLC1GLS2_D1N           0x01
#define _CLC1GLS2_LC1G3D1T      0x02
#define _CLC1GLS2_D1T           0x02
#define _CLC1GLS2_LC1G3D2N      0x04
#define _CLC1GLS2_D2N           0x04
#define _CLC1GLS2_LC1G3D2T      0x08
#define _CLC1GLS2_D2T           0x08
#define _CLC1GLS2_LC1G3D3N      0x10
#define _CLC1GLS2_D3N           0x10
#define _CLC1GLS2_LC1G3D3T      0x20
#define _CLC1GLS2_D3T           0x20
#define _CLC1GLS2_LC1G3D4N      0x40
#define _CLC1GLS2_D4N           0x40
#define _CLC1GLS2_LC1G3D4T      0x80
#define _CLC1GLS2_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC1GLS3 Bits

extern __at(0x0F19) __sfr CLC1GLS3;

typedef union
  {
  struct
    {
    unsigned LC1G4D1N           : 1;
    unsigned LC1G4D1T           : 1;
    unsigned LC1G4D2N           : 1;
    unsigned LC1G4D2T           : 1;
    unsigned LC1G4D3N           : 1;
    unsigned LC1G4D3T           : 1;
    unsigned LC1G4D4N           : 1;
    unsigned LC1G4D4T           : 1;
    };

  struct
    {
    unsigned G4D1N              : 1;
    unsigned G4D1T              : 1;
    unsigned G4D2N              : 1;
    unsigned G4D2T              : 1;
    unsigned G4D3N              : 1;
    unsigned G4D3T              : 1;
    unsigned G4D4N              : 1;
    unsigned G4D4T              : 1;
    };
  } __CLC1GLS3bits_t;

extern __at(0x0F19) volatile __CLC1GLS3bits_t CLC1GLS3bits;

#define _LC1G4D1N               0x01
#define _G4D1N                  0x01
#define _LC1G4D1T               0x02
#define _G4D1T                  0x02
#define _LC1G4D2N               0x04
#define _G4D2N                  0x04
#define _LC1G4D2T               0x08
#define _G4D2T                  0x08
#define _LC1G4D3N               0x10
#define _G4D3N                  0x10
#define _LC1G4D3T               0x20
#define _G4D3T                  0x20
#define _LC1G4D4N               0x40
#define _G4D4N                  0x40
#define _LC1G4D4T               0x80
#define _G4D4T                  0x80

//==============================================================================


//==============================================================================
//        CLC2CON Bits

extern __at(0x0F1A) __sfr CLC2CON;

typedef union
  {
  struct
    {
    unsigned LC2MODE0           : 1;
    unsigned LC2MODE1           : 1;
    unsigned LC2MODE2           : 1;
    unsigned LC2INTN            : 1;
    unsigned LC2INTP            : 1;
    unsigned LC2OUT             : 1;
    unsigned                    : 1;
    unsigned LC2EN              : 1;
    };

  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE2              : 1;
    unsigned INTN               : 1;
    unsigned INTP               : 1;
    unsigned OUT                : 1;
    unsigned                    : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned LC2MODE            : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned MODE               : 3;
    unsigned                    : 5;
    };
  } __CLC2CONbits_t;

extern __at(0x0F1A) volatile __CLC2CONbits_t CLC2CONbits;

#define _CLC2CON_LC2MODE0       0x01
#define _CLC2CON_MODE0          0x01
#define _CLC2CON_LC2MODE1       0x02
#define _CLC2CON_MODE1          0x02
#define _CLC2CON_LC2MODE2       0x04
#define _CLC2CON_MODE2          0x04
#define _CLC2CON_LC2INTN        0x08
#define _CLC2CON_INTN           0x08
#define _CLC2CON_LC2INTP        0x10
#define _CLC2CON_INTP           0x10
#define _CLC2CON_LC2OUT         0x20
#define _CLC2CON_OUT            0x20
#define _CLC2CON_LC2EN          0x80
#define _CLC2CON_EN             0x80

//==============================================================================


//==============================================================================
//        CLC2POL Bits

extern __at(0x0F1B) __sfr CLC2POL;

typedef union
  {
  struct
    {
    unsigned LC2G1POL           : 1;
    unsigned LC2G2POL           : 1;
    unsigned LC2G3POL           : 1;
    unsigned LC2G4POL           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LC2POL             : 1;
    };

  struct
    {
    unsigned G1POL              : 1;
    unsigned G2POL              : 1;
    unsigned G3POL              : 1;
    unsigned G4POL              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned POL                : 1;
    };
  } __CLC2POLbits_t;

extern __at(0x0F1B) volatile __CLC2POLbits_t CLC2POLbits;

#define _CLC2POL_LC2G1POL       0x01
#define _CLC2POL_G1POL          0x01
#define _CLC2POL_LC2G2POL       0x02
#define _CLC2POL_G2POL          0x02
#define _CLC2POL_LC2G3POL       0x04
#define _CLC2POL_G3POL          0x04
#define _CLC2POL_LC2G4POL       0x08
#define _CLC2POL_G4POL          0x08
#define _CLC2POL_LC2POL         0x80
#define _CLC2POL_POL            0x80

//==============================================================================


//==============================================================================
//        CLC2SEL0 Bits

extern __at(0x0F1C) __sfr CLC2SEL0;

typedef union
  {
  struct
    {
    unsigned LC2D1S0            : 1;
    unsigned LC2D1S1            : 1;
    unsigned LC2D1S2            : 1;
    unsigned LC2D1S3            : 1;
    unsigned LC2D1S4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D1S0               : 1;
    unsigned D1S1               : 1;
    unsigned D1S2               : 1;
    unsigned D1S3               : 1;
    unsigned D1S4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D1S                : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned LC2D1S             : 5;
    unsigned                    : 3;
    };
  } __CLC2SEL0bits_t;

extern __at(0x0F1C) volatile __CLC2SEL0bits_t CLC2SEL0bits;

#define _CLC2SEL0_LC2D1S0       0x01
#define _CLC2SEL0_D1S0          0x01
#define _CLC2SEL0_LC2D1S1       0x02
#define _CLC2SEL0_D1S1          0x02
#define _CLC2SEL0_LC2D1S2       0x04
#define _CLC2SEL0_D1S2          0x04
#define _CLC2SEL0_LC2D1S3       0x08
#define _CLC2SEL0_D1S3          0x08
#define _CLC2SEL0_LC2D1S4       0x10
#define _CLC2SEL0_D1S4          0x10

//==============================================================================


//==============================================================================
//        CLC2SEL1 Bits

extern __at(0x0F1D) __sfr CLC2SEL1;

typedef union
  {
  struct
    {
    unsigned LC2D2S0            : 1;
    unsigned LC2D2S1            : 1;
    unsigned LC2D2S2            : 1;
    unsigned LC2D2S3            : 1;
    unsigned LC2D2S4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D2S0               : 1;
    unsigned D2S1               : 1;
    unsigned D2S2               : 1;
    unsigned D2S3               : 1;
    unsigned D2S4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LC2D2S             : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned D2S                : 5;
    unsigned                    : 3;
    };
  } __CLC2SEL1bits_t;

extern __at(0x0F1D) volatile __CLC2SEL1bits_t CLC2SEL1bits;

#define _CLC2SEL1_LC2D2S0       0x01
#define _CLC2SEL1_D2S0          0x01
#define _CLC2SEL1_LC2D2S1       0x02
#define _CLC2SEL1_D2S1          0x02
#define _CLC2SEL1_LC2D2S2       0x04
#define _CLC2SEL1_D2S2          0x04
#define _CLC2SEL1_LC2D2S3       0x08
#define _CLC2SEL1_D2S3          0x08
#define _CLC2SEL1_LC2D2S4       0x10
#define _CLC2SEL1_D2S4          0x10

//==============================================================================


//==============================================================================
//        CLC2SEL2 Bits

extern __at(0x0F1E) __sfr CLC2SEL2;

typedef union
  {
  struct
    {
    unsigned LC2D3S0            : 1;
    unsigned LC2D3S1            : 1;
    unsigned LC2D3S2            : 1;
    unsigned LC2D3S3            : 1;
    unsigned LC2D3S4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D3S0               : 1;
    unsigned D3S1               : 1;
    unsigned D3S2               : 1;
    unsigned D3S3               : 1;
    unsigned D3S4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LC2D3S             : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned D3S                : 5;
    unsigned                    : 3;
    };
  } __CLC2SEL2bits_t;

extern __at(0x0F1E) volatile __CLC2SEL2bits_t CLC2SEL2bits;

#define _CLC2SEL2_LC2D3S0       0x01
#define _CLC2SEL2_D3S0          0x01
#define _CLC2SEL2_LC2D3S1       0x02
#define _CLC2SEL2_D3S1          0x02
#define _CLC2SEL2_LC2D3S2       0x04
#define _CLC2SEL2_D3S2          0x04
#define _CLC2SEL2_LC2D3S3       0x08
#define _CLC2SEL2_D3S3          0x08
#define _CLC2SEL2_LC2D3S4       0x10
#define _CLC2SEL2_D3S4          0x10

//==============================================================================


//==============================================================================
//        CLC2SEL3 Bits

extern __at(0x0F1F) __sfr CLC2SEL3;

typedef union
  {
  struct
    {
    unsigned LC2D4S0            : 1;
    unsigned LC2D4S1            : 1;
    unsigned LC2D4S2            : 1;
    unsigned LC2D4S3            : 1;
    unsigned LC2D4S4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D4S0               : 1;
    unsigned D4S1               : 1;
    unsigned D4S2               : 1;
    unsigned D4S3               : 1;
    unsigned D4S4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LC2D4S             : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned D4S                : 5;
    unsigned                    : 3;
    };
  } __CLC2SEL3bits_t;

extern __at(0x0F1F) volatile __CLC2SEL3bits_t CLC2SEL3bits;

#define _CLC2SEL3_LC2D4S0       0x01
#define _CLC2SEL3_D4S0          0x01
#define _CLC2SEL3_LC2D4S1       0x02
#define _CLC2SEL3_D4S1          0x02
#define _CLC2SEL3_LC2D4S2       0x04
#define _CLC2SEL3_D4S2          0x04
#define _CLC2SEL3_LC2D4S3       0x08
#define _CLC2SEL3_D4S3          0x08
#define _CLC2SEL3_LC2D4S4       0x10
#define _CLC2SEL3_D4S4          0x10

//==============================================================================


//==============================================================================
//        CLC2GLS0 Bits

extern __at(0x0F20) __sfr CLC2GLS0;

typedef union
  {
  struct
    {
    unsigned LC2G1D1N           : 1;
    unsigned LC2G1D1T           : 1;
    unsigned LC2G1D2N           : 1;
    unsigned LC2G1D2T           : 1;
    unsigned LC2G1D3N           : 1;
    unsigned LC2G1D3T           : 1;
    unsigned LC2G1D4N           : 1;
    unsigned LC2G1D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC2GLS0bits_t;

extern __at(0x0F20) volatile __CLC2GLS0bits_t CLC2GLS0bits;

#define _CLC2GLS0_LC2G1D1N      0x01
#define _CLC2GLS0_D1N           0x01
#define _CLC2GLS0_LC2G1D1T      0x02
#define _CLC2GLS0_D1T           0x02
#define _CLC2GLS0_LC2G1D2N      0x04
#define _CLC2GLS0_D2N           0x04
#define _CLC2GLS0_LC2G1D2T      0x08
#define _CLC2GLS0_D2T           0x08
#define _CLC2GLS0_LC2G1D3N      0x10
#define _CLC2GLS0_D3N           0x10
#define _CLC2GLS0_LC2G1D3T      0x20
#define _CLC2GLS0_D3T           0x20
#define _CLC2GLS0_LC2G1D4N      0x40
#define _CLC2GLS0_D4N           0x40
#define _CLC2GLS0_LC2G1D4T      0x80
#define _CLC2GLS0_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC2GLS1 Bits

extern __at(0x0F21) __sfr CLC2GLS1;

typedef union
  {
  struct
    {
    unsigned LC2G2D1N           : 1;
    unsigned LC2G2D1T           : 1;
    unsigned LC2G2D2N           : 1;
    unsigned LC2G2D2T           : 1;
    unsigned LC2G2D3N           : 1;
    unsigned LC2G2D3T           : 1;
    unsigned LC2G2D4N           : 1;
    unsigned LC2G2D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC2GLS1bits_t;

extern __at(0x0F21) volatile __CLC2GLS1bits_t CLC2GLS1bits;

#define _CLC2GLS1_LC2G2D1N      0x01
#define _CLC2GLS1_D1N           0x01
#define _CLC2GLS1_LC2G2D1T      0x02
#define _CLC2GLS1_D1T           0x02
#define _CLC2GLS1_LC2G2D2N      0x04
#define _CLC2GLS1_D2N           0x04
#define _CLC2GLS1_LC2G2D2T      0x08
#define _CLC2GLS1_D2T           0x08
#define _CLC2GLS1_LC2G2D3N      0x10
#define _CLC2GLS1_D3N           0x10
#define _CLC2GLS1_LC2G2D3T      0x20
#define _CLC2GLS1_D3T           0x20
#define _CLC2GLS1_LC2G2D4N      0x40
#define _CLC2GLS1_D4N           0x40
#define _CLC2GLS1_LC2G2D4T      0x80
#define _CLC2GLS1_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC2GLS2 Bits

extern __at(0x0F22) __sfr CLC2GLS2;

typedef union
  {
  struct
    {
    unsigned LC2G3D1N           : 1;
    unsigned LC2G3D1T           : 1;
    unsigned LC2G3D2N           : 1;
    unsigned LC2G3D2T           : 1;
    unsigned LC2G3D3N           : 1;
    unsigned LC2G3D3T           : 1;
    unsigned LC2G3D4N           : 1;
    unsigned LC2G3D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC2GLS2bits_t;

extern __at(0x0F22) volatile __CLC2GLS2bits_t CLC2GLS2bits;

#define _CLC2GLS2_LC2G3D1N      0x01
#define _CLC2GLS2_D1N           0x01
#define _CLC2GLS2_LC2G3D1T      0x02
#define _CLC2GLS2_D1T           0x02
#define _CLC2GLS2_LC2G3D2N      0x04
#define _CLC2GLS2_D2N           0x04
#define _CLC2GLS2_LC2G3D2T      0x08
#define _CLC2GLS2_D2T           0x08
#define _CLC2GLS2_LC2G3D3N      0x10
#define _CLC2GLS2_D3N           0x10
#define _CLC2GLS2_LC2G3D3T      0x20
#define _CLC2GLS2_D3T           0x20
#define _CLC2GLS2_LC2G3D4N      0x40
#define _CLC2GLS2_D4N           0x40
#define _CLC2GLS2_LC2G3D4T      0x80
#define _CLC2GLS2_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC2GLS3 Bits

extern __at(0x0F23) __sfr CLC2GLS3;

typedef union
  {
  struct
    {
    unsigned LC2G4D1N           : 1;
    unsigned LC2G4D1T           : 1;
    unsigned LC2G4D2N           : 1;
    unsigned LC2G4D2T           : 1;
    unsigned LC2G4D3N           : 1;
    unsigned LC2G4D3T           : 1;
    unsigned LC2G4D4N           : 1;
    unsigned LC2G4D4T           : 1;
    };

  struct
    {
    unsigned G4D1N              : 1;
    unsigned G4D1T              : 1;
    unsigned G4D2N              : 1;
    unsigned G4D2T              : 1;
    unsigned G4D3N              : 1;
    unsigned G4D3T              : 1;
    unsigned G4D4N              : 1;
    unsigned G4D4T              : 1;
    };
  } __CLC2GLS3bits_t;

extern __at(0x0F23) volatile __CLC2GLS3bits_t CLC2GLS3bits;

#define _CLC2GLS3_LC2G4D1N      0x01
#define _CLC2GLS3_G4D1N         0x01
#define _CLC2GLS3_LC2G4D1T      0x02
#define _CLC2GLS3_G4D1T         0x02
#define _CLC2GLS3_LC2G4D2N      0x04
#define _CLC2GLS3_G4D2N         0x04
#define _CLC2GLS3_LC2G4D2T      0x08
#define _CLC2GLS3_G4D2T         0x08
#define _CLC2GLS3_LC2G4D3N      0x10
#define _CLC2GLS3_G4D3N         0x10
#define _CLC2GLS3_LC2G4D3T      0x20
#define _CLC2GLS3_G4D3T         0x20
#define _CLC2GLS3_LC2G4D4N      0x40
#define _CLC2GLS3_G4D4N         0x40
#define _CLC2GLS3_LC2G4D4T      0x80
#define _CLC2GLS3_G4D4T         0x80

//==============================================================================


//==============================================================================
//        CLC3CON Bits

extern __at(0x0F24) __sfr CLC3CON;

typedef union
  {
  struct
    {
    unsigned LC3MODE0           : 1;
    unsigned LC3MODE1           : 1;
    unsigned LC3MODE2           : 1;
    unsigned LC3INTN            : 1;
    unsigned LC3INTP            : 1;
    unsigned LC3OUT             : 1;
    unsigned                    : 1;
    unsigned LC3EN              : 1;
    };

  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE2              : 1;
    unsigned INTN               : 1;
    unsigned INTP               : 1;
    unsigned OUT                : 1;
    unsigned                    : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned LC3MODE            : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned MODE               : 3;
    unsigned                    : 5;
    };
  } __CLC3CONbits_t;

extern __at(0x0F24) volatile __CLC3CONbits_t CLC3CONbits;

#define _CLC3CON_LC3MODE0       0x01
#define _CLC3CON_MODE0          0x01
#define _CLC3CON_LC3MODE1       0x02
#define _CLC3CON_MODE1          0x02
#define _CLC3CON_LC3MODE2       0x04
#define _CLC3CON_MODE2          0x04
#define _CLC3CON_LC3INTN        0x08
#define _CLC3CON_INTN           0x08
#define _CLC3CON_LC3INTP        0x10
#define _CLC3CON_INTP           0x10
#define _CLC3CON_LC3OUT         0x20
#define _CLC3CON_OUT            0x20
#define _CLC3CON_LC3EN          0x80
#define _CLC3CON_EN             0x80

//==============================================================================


//==============================================================================
//        CLC3POL Bits

extern __at(0x0F25) __sfr CLC3POL;

typedef union
  {
  struct
    {
    unsigned LC3G1POL           : 1;
    unsigned LC3G2POL           : 1;
    unsigned LC3G3POL           : 1;
    unsigned LC3G4POL           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LC3POL             : 1;
    };

  struct
    {
    unsigned G1POL              : 1;
    unsigned G2POL              : 1;
    unsigned G3POL              : 1;
    unsigned G4POL              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned POL                : 1;
    };
  } __CLC3POLbits_t;

extern __at(0x0F25) volatile __CLC3POLbits_t CLC3POLbits;

#define _CLC3POL_LC3G1POL       0x01
#define _CLC3POL_G1POL          0x01
#define _CLC3POL_LC3G2POL       0x02
#define _CLC3POL_G2POL          0x02
#define _CLC3POL_LC3G3POL       0x04
#define _CLC3POL_G3POL          0x04
#define _CLC3POL_LC3G4POL       0x08
#define _CLC3POL_G4POL          0x08
#define _CLC3POL_LC3POL         0x80
#define _CLC3POL_POL            0x80

//==============================================================================


//==============================================================================
//        CLC3SEL0 Bits

extern __at(0x0F26) __sfr CLC3SEL0;

typedef union
  {
  struct
    {
    unsigned LC3D1S0            : 1;
    unsigned LC3D1S1            : 1;
    unsigned LC3D1S2            : 1;
    unsigned LC3D1S3            : 1;
    unsigned LC3D1S4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D1S0               : 1;
    unsigned D1S1               : 1;
    unsigned D1S2               : 1;
    unsigned D1S3               : 1;
    unsigned D1S4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LC3D1S             : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned D1S                : 5;
    unsigned                    : 3;
    };
  } __CLC3SEL0bits_t;

extern __at(0x0F26) volatile __CLC3SEL0bits_t CLC3SEL0bits;

#define _CLC3SEL0_LC3D1S0       0x01
#define _CLC3SEL0_D1S0          0x01
#define _CLC3SEL0_LC3D1S1       0x02
#define _CLC3SEL0_D1S1          0x02
#define _CLC3SEL0_LC3D1S2       0x04
#define _CLC3SEL0_D1S2          0x04
#define _CLC3SEL0_LC3D1S3       0x08
#define _CLC3SEL0_D1S3          0x08
#define _CLC3SEL0_LC3D1S4       0x10
#define _CLC3SEL0_D1S4          0x10

//==============================================================================


//==============================================================================
//        CLC3SEL1 Bits

extern __at(0x0F27) __sfr CLC3SEL1;

typedef union
  {
  struct
    {
    unsigned LC3D2S0            : 1;
    unsigned LC3D2S1            : 1;
    unsigned LC3D2S2            : 1;
    unsigned LC3D2S3            : 1;
    unsigned LC3D2S4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D2S0               : 1;
    unsigned D2S1               : 1;
    unsigned D2S2               : 1;
    unsigned D2S3               : 1;
    unsigned D2S4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D2S                : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned LC3D2S             : 5;
    unsigned                    : 3;
    };
  } __CLC3SEL1bits_t;

extern __at(0x0F27) volatile __CLC3SEL1bits_t CLC3SEL1bits;

#define _CLC3SEL1_LC3D2S0       0x01
#define _CLC3SEL1_D2S0          0x01
#define _CLC3SEL1_LC3D2S1       0x02
#define _CLC3SEL1_D2S1          0x02
#define _CLC3SEL1_LC3D2S2       0x04
#define _CLC3SEL1_D2S2          0x04
#define _CLC3SEL1_LC3D2S3       0x08
#define _CLC3SEL1_D2S3          0x08
#define _CLC3SEL1_LC3D2S4       0x10
#define _CLC3SEL1_D2S4          0x10

//==============================================================================


//==============================================================================
//        CLC3SEL2 Bits

extern __at(0x0F28) __sfr CLC3SEL2;

typedef union
  {
  struct
    {
    unsigned LC3D3S0            : 1;
    unsigned LC3D3S1            : 1;
    unsigned LC3D3S2            : 1;
    unsigned LC3D3S3            : 1;
    unsigned LC3D3S4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D3S0               : 1;
    unsigned D3S1               : 1;
    unsigned D3S2               : 1;
    unsigned D3S3               : 1;
    unsigned D3S4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LC3D3S             : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned D3S                : 5;
    unsigned                    : 3;
    };
  } __CLC3SEL2bits_t;

extern __at(0x0F28) volatile __CLC3SEL2bits_t CLC3SEL2bits;

#define _CLC3SEL2_LC3D3S0       0x01
#define _CLC3SEL2_D3S0          0x01
#define _CLC3SEL2_LC3D3S1       0x02
#define _CLC3SEL2_D3S1          0x02
#define _CLC3SEL2_LC3D3S2       0x04
#define _CLC3SEL2_D3S2          0x04
#define _CLC3SEL2_LC3D3S3       0x08
#define _CLC3SEL2_D3S3          0x08
#define _CLC3SEL2_LC3D3S4       0x10
#define _CLC3SEL2_D3S4          0x10

//==============================================================================


//==============================================================================
//        CLC3SEL3 Bits

extern __at(0x0F29) __sfr CLC3SEL3;

typedef union
  {
  struct
    {
    unsigned LC3D4S0            : 1;
    unsigned LC3D4S1            : 1;
    unsigned LC3D4S2            : 1;
    unsigned LC3D4S3            : 1;
    unsigned LC3D4S4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D4S0               : 1;
    unsigned D4S1               : 1;
    unsigned D4S2               : 1;
    unsigned D4S3               : 1;
    unsigned D4S4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D4S                : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned LC3D4S             : 5;
    unsigned                    : 3;
    };
  } __CLC3SEL3bits_t;

extern __at(0x0F29) volatile __CLC3SEL3bits_t CLC3SEL3bits;

#define _CLC3SEL3_LC3D4S0       0x01
#define _CLC3SEL3_D4S0          0x01
#define _CLC3SEL3_LC3D4S1       0x02
#define _CLC3SEL3_D4S1          0x02
#define _CLC3SEL3_LC3D4S2       0x04
#define _CLC3SEL3_D4S2          0x04
#define _CLC3SEL3_LC3D4S3       0x08
#define _CLC3SEL3_D4S3          0x08
#define _CLC3SEL3_LC3D4S4       0x10
#define _CLC3SEL3_D4S4          0x10

//==============================================================================


//==============================================================================
//        CLC3GLS0 Bits

extern __at(0x0F2A) __sfr CLC3GLS0;

typedef union
  {
  struct
    {
    unsigned LC3G1D1N           : 1;
    unsigned LC3G1D1T           : 1;
    unsigned LC3G1D2N           : 1;
    unsigned LC3G1D2T           : 1;
    unsigned LC3G1D3N           : 1;
    unsigned LC3G1D3T           : 1;
    unsigned LC3G1D4N           : 1;
    unsigned LC3G1D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC3GLS0bits_t;

extern __at(0x0F2A) volatile __CLC3GLS0bits_t CLC3GLS0bits;

#define _CLC3GLS0_LC3G1D1N      0x01
#define _CLC3GLS0_D1N           0x01
#define _CLC3GLS0_LC3G1D1T      0x02
#define _CLC3GLS0_D1T           0x02
#define _CLC3GLS0_LC3G1D2N      0x04
#define _CLC3GLS0_D2N           0x04
#define _CLC3GLS0_LC3G1D2T      0x08
#define _CLC3GLS0_D2T           0x08
#define _CLC3GLS0_LC3G1D3N      0x10
#define _CLC3GLS0_D3N           0x10
#define _CLC3GLS0_LC3G1D3T      0x20
#define _CLC3GLS0_D3T           0x20
#define _CLC3GLS0_LC3G1D4N      0x40
#define _CLC3GLS0_D4N           0x40
#define _CLC3GLS0_LC3G1D4T      0x80
#define _CLC3GLS0_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC3GLS1 Bits

extern __at(0x0F2B) __sfr CLC3GLS1;

typedef union
  {
  struct
    {
    unsigned LC3G2D1N           : 1;
    unsigned LC3G2D1T           : 1;
    unsigned LC3G2D2N           : 1;
    unsigned LC3G2D2T           : 1;
    unsigned LC3G2D3N           : 1;
    unsigned LC3G2D3T           : 1;
    unsigned LC3G2D4N           : 1;
    unsigned LC3G2D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC3GLS1bits_t;

extern __at(0x0F2B) volatile __CLC3GLS1bits_t CLC3GLS1bits;

#define _CLC3GLS1_LC3G2D1N      0x01
#define _CLC3GLS1_D1N           0x01
#define _CLC3GLS1_LC3G2D1T      0x02
#define _CLC3GLS1_D1T           0x02
#define _CLC3GLS1_LC3G2D2N      0x04
#define _CLC3GLS1_D2N           0x04
#define _CLC3GLS1_LC3G2D2T      0x08
#define _CLC3GLS1_D2T           0x08
#define _CLC3GLS1_LC3G2D3N      0x10
#define _CLC3GLS1_D3N           0x10
#define _CLC3GLS1_LC3G2D3T      0x20
#define _CLC3GLS1_D3T           0x20
#define _CLC3GLS1_LC3G2D4N      0x40
#define _CLC3GLS1_D4N           0x40
#define _CLC3GLS1_LC3G2D4T      0x80
#define _CLC3GLS1_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC3GLS2 Bits

extern __at(0x0F2C) __sfr CLC3GLS2;

typedef union
  {
  struct
    {
    unsigned LC3G3D1N           : 1;
    unsigned LC3G3D1T           : 1;
    unsigned LC3G3D2N           : 1;
    unsigned LC3G3D2T           : 1;
    unsigned LC3G3D3N           : 1;
    unsigned LC3G3D3T           : 1;
    unsigned LC3G3D4N           : 1;
    unsigned LC3G3D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC3GLS2bits_t;

extern __at(0x0F2C) volatile __CLC3GLS2bits_t CLC3GLS2bits;

#define _CLC3GLS2_LC3G3D1N      0x01
#define _CLC3GLS2_D1N           0x01
#define _CLC3GLS2_LC3G3D1T      0x02
#define _CLC3GLS2_D1T           0x02
#define _CLC3GLS2_LC3G3D2N      0x04
#define _CLC3GLS2_D2N           0x04
#define _CLC3GLS2_LC3G3D2T      0x08
#define _CLC3GLS2_D2T           0x08
#define _CLC3GLS2_LC3G3D3N      0x10
#define _CLC3GLS2_D3N           0x10
#define _CLC3GLS2_LC3G3D3T      0x20
#define _CLC3GLS2_D3T           0x20
#define _CLC3GLS2_LC3G3D4N      0x40
#define _CLC3GLS2_D4N           0x40
#define _CLC3GLS2_LC3G3D4T      0x80
#define _CLC3GLS2_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC3GLS3 Bits

extern __at(0x0F2D) __sfr CLC3GLS3;

typedef union
  {
  struct
    {
    unsigned LC3G4D1N           : 1;
    unsigned LC3G4D1T           : 1;
    unsigned LC3G4D2N           : 1;
    unsigned LC3G4D2T           : 1;
    unsigned LC3G4D3N           : 1;
    unsigned LC3G4D3T           : 1;
    unsigned LC3G4D4N           : 1;
    unsigned LC3G4D4T           : 1;
    };

  struct
    {
    unsigned G4D1N              : 1;
    unsigned G4D1T              : 1;
    unsigned G4D2N              : 1;
    unsigned G4D2T              : 1;
    unsigned G4D3N              : 1;
    unsigned G4D3T              : 1;
    unsigned G4D4N              : 1;
    unsigned G4D4T              : 1;
    };
  } __CLC3GLS3bits_t;

extern __at(0x0F2D) volatile __CLC3GLS3bits_t CLC3GLS3bits;

#define _CLC3GLS3_LC3G4D1N      0x01
#define _CLC3GLS3_G4D1N         0x01
#define _CLC3GLS3_LC3G4D1T      0x02
#define _CLC3GLS3_G4D1T         0x02
#define _CLC3GLS3_LC3G4D2N      0x04
#define _CLC3GLS3_G4D2N         0x04
#define _CLC3GLS3_LC3G4D2T      0x08
#define _CLC3GLS3_G4D2T         0x08
#define _CLC3GLS3_LC3G4D3N      0x10
#define _CLC3GLS3_G4D3N         0x10
#define _CLC3GLS3_LC3G4D3T      0x20
#define _CLC3GLS3_G4D3T         0x20
#define _CLC3GLS3_LC3G4D4N      0x40
#define _CLC3GLS3_G4D4N         0x40
#define _CLC3GLS3_LC3G4D4T      0x80
#define _CLC3GLS3_G4D4T         0x80

//==============================================================================


//==============================================================================
//        CLC4CON Bits

extern __at(0x0F2E) __sfr CLC4CON;

typedef union
  {
  struct
    {
    unsigned LC4MODE0           : 1;
    unsigned LC4MODE1           : 1;
    unsigned LC4MODE2           : 1;
    unsigned LC4INTN            : 1;
    unsigned LC4INTP            : 1;
    unsigned LC4OUT             : 1;
    unsigned                    : 1;
    unsigned LC4EN              : 1;
    };

  struct
    {
    unsigned MODE0              : 1;
    unsigned MODE1              : 1;
    unsigned MODE2              : 1;
    unsigned INTN               : 1;
    unsigned INTP               : 1;
    unsigned OUT                : 1;
    unsigned                    : 1;
    unsigned EN                 : 1;
    };

  struct
    {
    unsigned MODE               : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned LC4MODE            : 3;
    unsigned                    : 5;
    };
  } __CLC4CONbits_t;

extern __at(0x0F2E) volatile __CLC4CONbits_t CLC4CONbits;

#define _CLC4CON_LC4MODE0       0x01
#define _CLC4CON_MODE0          0x01
#define _CLC4CON_LC4MODE1       0x02
#define _CLC4CON_MODE1          0x02
#define _CLC4CON_LC4MODE2       0x04
#define _CLC4CON_MODE2          0x04
#define _CLC4CON_LC4INTN        0x08
#define _CLC4CON_INTN           0x08
#define _CLC4CON_LC4INTP        0x10
#define _CLC4CON_INTP           0x10
#define _CLC4CON_LC4OUT         0x20
#define _CLC4CON_OUT            0x20
#define _CLC4CON_LC4EN          0x80
#define _CLC4CON_EN             0x80

//==============================================================================


//==============================================================================
//        CLC4POL Bits

extern __at(0x0F2F) __sfr CLC4POL;

typedef union
  {
  struct
    {
    unsigned LC4G1POL           : 1;
    unsigned LC4G2POL           : 1;
    unsigned LC4G3POL           : 1;
    unsigned LC4G4POL           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LC4POL             : 1;
    };

  struct
    {
    unsigned G1POL              : 1;
    unsigned G2POL              : 1;
    unsigned G3POL              : 1;
    unsigned G4POL              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned POL                : 1;
    };
  } __CLC4POLbits_t;

extern __at(0x0F2F) volatile __CLC4POLbits_t CLC4POLbits;

#define _CLC4POL_LC4G1POL       0x01
#define _CLC4POL_G1POL          0x01
#define _CLC4POL_LC4G2POL       0x02
#define _CLC4POL_G2POL          0x02
#define _CLC4POL_LC4G3POL       0x04
#define _CLC4POL_G3POL          0x04
#define _CLC4POL_LC4G4POL       0x08
#define _CLC4POL_G4POL          0x08
#define _CLC4POL_LC4POL         0x80
#define _CLC4POL_POL            0x80

//==============================================================================


//==============================================================================
//        CLC4SEL0 Bits

extern __at(0x0F30) __sfr CLC4SEL0;

typedef union
  {
  struct
    {
    unsigned LC4D1S0            : 1;
    unsigned LC4D1S1            : 1;
    unsigned LC4D1S2            : 1;
    unsigned LC4D1S3            : 1;
    unsigned LC4D1S4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D1S0               : 1;
    unsigned D1S1               : 1;
    unsigned D1S2               : 1;
    unsigned D1S3               : 1;
    unsigned D1S4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D1S                : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned LC4D1S             : 5;
    unsigned                    : 3;
    };
  } __CLC4SEL0bits_t;

extern __at(0x0F30) volatile __CLC4SEL0bits_t CLC4SEL0bits;

#define _CLC4SEL0_LC4D1S0       0x01
#define _CLC4SEL0_D1S0          0x01
#define _CLC4SEL0_LC4D1S1       0x02
#define _CLC4SEL0_D1S1          0x02
#define _CLC4SEL0_LC4D1S2       0x04
#define _CLC4SEL0_D1S2          0x04
#define _CLC4SEL0_LC4D1S3       0x08
#define _CLC4SEL0_D1S3          0x08
#define _CLC4SEL0_LC4D1S4       0x10
#define _CLC4SEL0_D1S4          0x10

//==============================================================================


//==============================================================================
//        CLC4SEL1 Bits

extern __at(0x0F31) __sfr CLC4SEL1;

typedef union
  {
  struct
    {
    unsigned LC4D2S0            : 1;
    unsigned LC4D2S1            : 1;
    unsigned LC4D2S2            : 1;
    unsigned LC4D2S3            : 1;
    unsigned LC4D2S4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D2S0               : 1;
    unsigned D2S1               : 1;
    unsigned D2S2               : 1;
    unsigned D2S3               : 1;
    unsigned D2S4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LC4D2S             : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned D2S                : 5;
    unsigned                    : 3;
    };
  } __CLC4SEL1bits_t;

extern __at(0x0F31) volatile __CLC4SEL1bits_t CLC4SEL1bits;

#define _CLC4SEL1_LC4D2S0       0x01
#define _CLC4SEL1_D2S0          0x01
#define _CLC4SEL1_LC4D2S1       0x02
#define _CLC4SEL1_D2S1          0x02
#define _CLC4SEL1_LC4D2S2       0x04
#define _CLC4SEL1_D2S2          0x04
#define _CLC4SEL1_LC4D2S3       0x08
#define _CLC4SEL1_D2S3          0x08
#define _CLC4SEL1_LC4D2S4       0x10
#define _CLC4SEL1_D2S4          0x10

//==============================================================================


//==============================================================================
//        CLC4SEL2 Bits

extern __at(0x0F32) __sfr CLC4SEL2;

typedef union
  {
  struct
    {
    unsigned LC4D3S0            : 1;
    unsigned LC4D3S1            : 1;
    unsigned LC4D3S2            : 1;
    unsigned LC4D3S3            : 1;
    unsigned LC4D3S4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D3S0               : 1;
    unsigned D3S1               : 1;
    unsigned D3S2               : 1;
    unsigned D3S3               : 1;
    unsigned D3S4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D3S                : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned LC4D3S             : 5;
    unsigned                    : 3;
    };
  } __CLC4SEL2bits_t;

extern __at(0x0F32) volatile __CLC4SEL2bits_t CLC4SEL2bits;

#define _CLC4SEL2_LC4D3S0       0x01
#define _CLC4SEL2_D3S0          0x01
#define _CLC4SEL2_LC4D3S1       0x02
#define _CLC4SEL2_D3S1          0x02
#define _CLC4SEL2_LC4D3S2       0x04
#define _CLC4SEL2_D3S2          0x04
#define _CLC4SEL2_LC4D3S3       0x08
#define _CLC4SEL2_D3S3          0x08
#define _CLC4SEL2_LC4D3S4       0x10
#define _CLC4SEL2_D3S4          0x10

//==============================================================================


//==============================================================================
//        CLC4SEL3 Bits

extern __at(0x0F33) __sfr CLC4SEL3;

typedef union
  {
  struct
    {
    unsigned LC4D4S0            : 1;
    unsigned LC4D4S1            : 1;
    unsigned LC4D4S2            : 1;
    unsigned LC4D4S3            : 1;
    unsigned LC4D4S4            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned D4S0               : 1;
    unsigned D4S1               : 1;
    unsigned D4S2               : 1;
    unsigned D4S3               : 1;
    unsigned D4S4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LC4D4S             : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned D4S                : 5;
    unsigned                    : 3;
    };
  } __CLC4SEL3bits_t;

extern __at(0x0F33) volatile __CLC4SEL3bits_t CLC4SEL3bits;

#define _CLC4SEL3_LC4D4S0       0x01
#define _CLC4SEL3_D4S0          0x01
#define _CLC4SEL3_LC4D4S1       0x02
#define _CLC4SEL3_D4S1          0x02
#define _CLC4SEL3_LC4D4S2       0x04
#define _CLC4SEL3_D4S2          0x04
#define _CLC4SEL3_LC4D4S3       0x08
#define _CLC4SEL3_D4S3          0x08
#define _CLC4SEL3_LC4D4S4       0x10
#define _CLC4SEL3_D4S4          0x10

//==============================================================================


//==============================================================================
//        CLC4GLS0 Bits

extern __at(0x0F34) __sfr CLC4GLS0;

typedef union
  {
  struct
    {
    unsigned LC4G1D1N           : 1;
    unsigned LC4G1D1T           : 1;
    unsigned LC4G1D2N           : 1;
    unsigned LC4G1D2T           : 1;
    unsigned LC4G1D3N           : 1;
    unsigned LC4G1D3T           : 1;
    unsigned LC4G1D4N           : 1;
    unsigned LC4G1D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC4GLS0bits_t;

extern __at(0x0F34) volatile __CLC4GLS0bits_t CLC4GLS0bits;

#define _CLC4GLS0_LC4G1D1N      0x01
#define _CLC4GLS0_D1N           0x01
#define _CLC4GLS0_LC4G1D1T      0x02
#define _CLC4GLS0_D1T           0x02
#define _CLC4GLS0_LC4G1D2N      0x04
#define _CLC4GLS0_D2N           0x04
#define _CLC4GLS0_LC4G1D2T      0x08
#define _CLC4GLS0_D2T           0x08
#define _CLC4GLS0_LC4G1D3N      0x10
#define _CLC4GLS0_D3N           0x10
#define _CLC4GLS0_LC4G1D3T      0x20
#define _CLC4GLS0_D3T           0x20
#define _CLC4GLS0_LC4G1D4N      0x40
#define _CLC4GLS0_D4N           0x40
#define _CLC4GLS0_LC4G1D4T      0x80
#define _CLC4GLS0_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC4GLS1 Bits

extern __at(0x0F35) __sfr CLC4GLS1;

typedef union
  {
  struct
    {
    unsigned LC4G2D1N           : 1;
    unsigned LC4G2D1T           : 1;
    unsigned LC4G2D2N           : 1;
    unsigned LC4G2D2T           : 1;
    unsigned LC4G2D3N           : 1;
    unsigned LC4G2D3T           : 1;
    unsigned LC4G2D4N           : 1;
    unsigned LC4G2D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC4GLS1bits_t;

extern __at(0x0F35) volatile __CLC4GLS1bits_t CLC4GLS1bits;

#define _CLC4GLS1_LC4G2D1N      0x01
#define _CLC4GLS1_D1N           0x01
#define _CLC4GLS1_LC4G2D1T      0x02
#define _CLC4GLS1_D1T           0x02
#define _CLC4GLS1_LC4G2D2N      0x04
#define _CLC4GLS1_D2N           0x04
#define _CLC4GLS1_LC4G2D2T      0x08
#define _CLC4GLS1_D2T           0x08
#define _CLC4GLS1_LC4G2D3N      0x10
#define _CLC4GLS1_D3N           0x10
#define _CLC4GLS1_LC4G2D3T      0x20
#define _CLC4GLS1_D3T           0x20
#define _CLC4GLS1_LC4G2D4N      0x40
#define _CLC4GLS1_D4N           0x40
#define _CLC4GLS1_LC4G2D4T      0x80
#define _CLC4GLS1_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC4GLS2 Bits

extern __at(0x0F36) __sfr CLC4GLS2;

typedef union
  {
  struct
    {
    unsigned LC4G3D1N           : 1;
    unsigned LC4G3D1T           : 1;
    unsigned LC4G3D2N           : 1;
    unsigned LC4G3D2T           : 1;
    unsigned LC4G3D3N           : 1;
    unsigned LC4G3D3T           : 1;
    unsigned LC4G3D4N           : 1;
    unsigned LC4G3D4T           : 1;
    };

  struct
    {
    unsigned D1N                : 1;
    unsigned D1T                : 1;
    unsigned D2N                : 1;
    unsigned D2T                : 1;
    unsigned D3N                : 1;
    unsigned D3T                : 1;
    unsigned D4N                : 1;
    unsigned D4T                : 1;
    };
  } __CLC4GLS2bits_t;

extern __at(0x0F36) volatile __CLC4GLS2bits_t CLC4GLS2bits;

#define _CLC4GLS2_LC4G3D1N      0x01
#define _CLC4GLS2_D1N           0x01
#define _CLC4GLS2_LC4G3D1T      0x02
#define _CLC4GLS2_D1T           0x02
#define _CLC4GLS2_LC4G3D2N      0x04
#define _CLC4GLS2_D2N           0x04
#define _CLC4GLS2_LC4G3D2T      0x08
#define _CLC4GLS2_D2T           0x08
#define _CLC4GLS2_LC4G3D3N      0x10
#define _CLC4GLS2_D3N           0x10
#define _CLC4GLS2_LC4G3D3T      0x20
#define _CLC4GLS2_D3T           0x20
#define _CLC4GLS2_LC4G3D4N      0x40
#define _CLC4GLS2_D4N           0x40
#define _CLC4GLS2_LC4G3D4T      0x80
#define _CLC4GLS2_D4T           0x80

//==============================================================================


//==============================================================================
//        CLC4GLS3 Bits

extern __at(0x0F37) __sfr CLC4GLS3;

typedef union
  {
  struct
    {
    unsigned LC4G4D1N           : 1;
    unsigned LC4G4D1T           : 1;
    unsigned LC4G4D2N           : 1;
    unsigned LC4G4D2T           : 1;
    unsigned LC4G4D3N           : 1;
    unsigned LC4G4D3T           : 1;
    unsigned LC4G4D4N           : 1;
    unsigned LC4G4D4T           : 1;
    };

  struct
    {
    unsigned G4D1N              : 1;
    unsigned G4D1T              : 1;
    unsigned G4D2N              : 1;
    unsigned G4D2T              : 1;
    unsigned G4D3N              : 1;
    unsigned G4D3T              : 1;
    unsigned G4D4N              : 1;
    unsigned G4D4T              : 1;
    };
  } __CLC4GLS3bits_t;

extern __at(0x0F37) volatile __CLC4GLS3bits_t CLC4GLS3bits;

#define _CLC4GLS3_LC4G4D1N      0x01
#define _CLC4GLS3_G4D1N         0x01
#define _CLC4GLS3_LC4G4D1T      0x02
#define _CLC4GLS3_G4D1T         0x02
#define _CLC4GLS3_LC4G4D2N      0x04
#define _CLC4GLS3_G4D2N         0x04
#define _CLC4GLS3_LC4G4D2T      0x08
#define _CLC4GLS3_G4D2T         0x08
#define _CLC4GLS3_LC4G4D3N      0x10
#define _CLC4GLS3_G4D3N         0x10
#define _CLC4GLS3_LC4G4D3T      0x20
#define _CLC4GLS3_G4D3T         0x20
#define _CLC4GLS3_LC4G4D4N      0x40
#define _CLC4GLS3_G4D4N         0x40
#define _CLC4GLS3_LC4G4D4T      0x80
#define _CLC4GLS3_G4D4T         0x80

//==============================================================================


//==============================================================================
//        STATUS_SHAD Bits

extern __at(0x0FE4) __sfr STATUS_SHAD;

typedef struct
  {
  unsigned C_SHAD               : 1;
  unsigned DC_SHAD              : 1;
  unsigned Z_SHAD               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __STATUS_SHADbits_t;

extern __at(0x0FE4) volatile __STATUS_SHADbits_t STATUS_SHADbits;

#define _C_SHAD                 0x01
#define _DC_SHAD                0x02
#define _Z_SHAD                 0x04

//==============================================================================

extern __at(0x0FE5) __sfr WREG_SHAD;
extern __at(0x0FE6) __sfr BSR_SHAD;
extern __at(0x0FE7) __sfr PCLATH_SHAD;
extern __at(0x0FE8) __sfr FSR0L_SHAD;
extern __at(0x0FE9) __sfr FSR0H_SHAD;
extern __at(0x0FEA) __sfr FSR1L_SHAD;
extern __at(0x0FEB) __sfr FSR1H_SHAD;
extern __at(0x0FED) __sfr STKPTR;
extern __at(0x0FEE) __sfr TOSL;
extern __at(0x0FEF) __sfr TOSH;

//==============================================================================
//
//        Configuration Bits
//
//==============================================================================

#define _CONFIG1                0x8007
#define _CONFIG2                0x8008

//----------------------------- CONFIG1 Options -------------------------------

#define _FOSC_LP                0x3FF8  // LP Oscillator, Low-power crystal connected between OSC1 and OSC2 pins.
#define _FOSC_XT                0x3FF9  // XT Oscillator, Crystal/resonator connected between OSC1 and OSC2 pins.
#define _FOSC_HS                0x3FFA  // HS Oscillator, High-speed crystal/resonator connected between OSC1 and OSC2 pins.
#define _FOSC_EXTRC             0x3FFB  // EXTRC oscillator: External RC circuit connected to CLKIN pin.
#define _FOSC_INTOSC            0x3FFC  // INTOSC oscillator: I/O function on CLKIN pin.
#define _FOSC_ECL               0x3FFD  // ECL, External Clock, Low Power Mode (0-0.5 MHz): device clock supplied to CLKIN pins.
#define _FOSC_ECM               0x3FFE  // ECM, External Clock, Medium Power Mode (0.5-4 MHz): device clock supplied to CLKIN pins.
#define _FOSC_ECH               0x3FFF  // ECH, External Clock, High Power Mode (4-20 MHz): device clock supplied to CLKIN pins.
#define _WDTE_OFF               0x3FE7  // WDT disabled.
#define _WDTE_SWDTEN            0x3FEF  // WDT controlled by the SWDTEN bit in the WDTCON register.
#define _WDTE_NSLEEP            0x3FF7  // WDT enabled while running and disabled in Sleep.
#define _WDTE_ON                0x3FFF  // WDT enabled.
#define _PWRTE_ON               0x3FDF  // PWRT enabled.
#define _PWRTE_OFF              0x3FFF  // PWRT disabled.
#define _MCLRE_OFF              0x3FBF  // MCLR/VPP pin function is digital input if LVP bit is also 0.
#define _MCLRE_ON               0x3FFF  // MCLR/VPP pin function is MCLR.
#define _CP_ON                  0x3F7F  // Program memory code protection is enabled.
#define _CP_OFF                 0x3FFF  // Program memory code protection is disabled.
#define _BOREN_OFF              0x39FF  // Brown-out Reset disabled.
#define _BOREN_SBODEN           0x3BFF  // Brown-out Reset controlled by the SBOREN bit in the BORCON register.
#define _BOREN_NSLEEP           0x3DFF  // Brown-out Reset enabled while running and disabled in Sleep.
#define _BOREN_ON               0x3FFF  // Brown-out Reset enabled.
#define _CLKOUTEN_ON            0x37FF  // CLKOUT function is enabled on the CLKOUT pin.
#define _CLKOUTEN_OFF           0x3FFF  // CLKOUT function is disabled. I/O or oscillator function on the CLKOUT pin.
#define _IESO_OFF               0x2FFF  // Internal/External Switchover Mode is disabled.
#define _IESO_ON                0x3FFF  // Internal/External Switchover Mode is enabled.
#define _FCMEN_OFF              0x1FFF  // Fail-Safe Clock Monitor is disabled.
#define _FCMEN_ON               0x3FFF  // Fail-Safe Clock Monitor is enabled.

//----------------------------- CONFIG2 Options -------------------------------

#define _WRT_ALL                0x3FFC  // 0000h to 1FFFh write protected, no addresses may be modified by EECON control.
#define _WRT_HALF               0x3FFD  // 0000h to 0FFFh write protected, 1000h to 1FFFh may be modified by EECON control.
#define _WRT_BOOT               0x3FFE  // 0000h to 03FFh write protected, 0400h to 1FFFh may be modified by EECON control.
#define _WRT_OFF                0x3FFF  // Write protection off.
#define _PPS1WAY_OFF            0x3FFB  // The PPSLOCK bit can be set and cleared repeatedly by software.
#define _PPS1WAY_ON             0x3FFF  // The PPSLOCK bit cannot be cleared once it is set by software.
#define _ZCDDIS_OFF             0x3F7F  // Zero-cross detect circuit is always enabled.
#define _ZCDDIS_ON              0x3FFF  // Zero-cross detect circuit is disabled at POR and can be enabled with ZCDSEN bit.
#define _PLLEN_OFF              0x3EFF  // 4x PLL is enabled when software sets the SPLLEN bit.
#define _PLLEN_ON               0x3FFF  // 4x PLL is always enabled.
#define _STVREN_OFF             0x3DFF  // Stack Overflow or Underflow will not cause a Reset.
#define _STVREN_ON              0x3FFF  // Stack Overflow or Underflow will cause a Reset.
#define _BORV_HI                0x3BFF  // Brown-out Reset Voltage (Vbor), high trip point selected.
#define _BORV_LO                0x3FFF  // Brown-out Reset Voltage (Vbor), low trip point selected.
#define _LPBOR_ON               0x37FF  // Low-Power BOR is enabled.
#define _LPBOR_OFF              0x3FFF  // Low-Power BOR is disabled.
#define _DEBUG_ON               0x2FFF  // In-Circuit Debugger enabled, ICSPCLK and ICSPDAT are dedicated to the debugger.
#define _DEBUG_OFF              0x3FFF  // In-Circuit Debugger disabled, ICSPCLK and ICSPDAT are general purpose I/O pins.
#define _LVP_OFF                0x1FFF  // High-voltage on MCLR/VPP must be used for programming.
#define _LVP_ON                 0x3FFF  // Low-voltage programming enabled.

//==============================================================================

#define _DEVID1                 0x8006

#define _IDLOC0                 0x8000
#define _IDLOC1                 0x8001
#define _IDLOC2                 0x8002
#define _IDLOC3                 0x8003

//==============================================================================

#ifndef NO_BIT_DEFINES

#define ADON                    ADCON0bits.ADON                 // bit 0
#define GO_NOT_DONE             ADCON0bits.GO_NOT_DONE          // bit 1, shadows bit in ADCON0bits
#define ADGO                    ADCON0bits.ADGO                 // bit 1, shadows bit in ADCON0bits
#define GO                      ADCON0bits.GO                   // bit 1, shadows bit in ADCON0bits
#define CHS0                    ADCON0bits.CHS0                 // bit 2
#define CHS1                    ADCON0bits.CHS1                 // bit 3
#define CHS2                    ADCON0bits.CHS2                 // bit 4
#define CHS3                    ADCON0bits.CHS3                 // bit 5
#define CHS4                    ADCON0bits.CHS4                 // bit 6

#define ADPREF0                 ADCON1bits.ADPREF0              // bit 0
#define ADPREF1                 ADCON1bits.ADPREF1              // bit 1
#define ADNREF                  ADCON1bits.ADNREF               // bit 2
#define ADFM                    ADCON1bits.ADFM                 // bit 7

#define TRIGSEL0                ADCON2bits.TRIGSEL0             // bit 4
#define TRIGSEL1                ADCON2bits.TRIGSEL1             // bit 5
#define TRIGSEL2                ADCON2bits.TRIGSEL2             // bit 6
#define TRIGSEL3                ADCON2bits.TRIGSEL3             // bit 7

#define ANSA0                   ANSELAbits.ANSA0                // bit 0
#define ANSA1                   ANSELAbits.ANSA1                // bit 1
#define ANSA2                   ANSELAbits.ANSA2                // bit 2
#define ANSA3                   ANSELAbits.ANSA3                // bit 3
#define ANSA4                   ANSELAbits.ANSA4                // bit 4
#define ANSA5                   ANSELAbits.ANSA5                // bit 5

#define ANSB0                   ANSELBbits.ANSB0                // bit 0
#define ANSB1                   ANSELBbits.ANSB1                // bit 1
#define ANSB2                   ANSELBbits.ANSB2                // bit 2
#define ANSB3                   ANSELBbits.ANSB3                // bit 3
#define ANSB4                   ANSELBbits.ANSB4                // bit 4
#define ANSB5                   ANSELBbits.ANSB5                // bit 5

#define ANSC2                   ANSELCbits.ANSC2                // bit 2
#define ANSC3                   ANSELCbits.ANSC3                // bit 3
#define ANSC4                   ANSELCbits.ANSC4                // bit 4
#define ANSC5                   ANSELCbits.ANSC5                // bit 5
#define ANSC6                   ANSELCbits.ANSC6                // bit 6
#define ANSC7                   ANSELCbits.ANSC7                // bit 7

#define ANSD0                   ANSELDbits.ANSD0                // bit 0
#define ANSD1                   ANSELDbits.ANSD1                // bit 1
#define ANSD2                   ANSELDbits.ANSD2                // bit 2
#define ANSD3                   ANSELDbits.ANSD3                // bit 3
#define ANSD4                   ANSELDbits.ANSD4                // bit 4
#define ANSD5                   ANSELDbits.ANSD5                // bit 5
#define ANSD6                   ANSELDbits.ANSD6                // bit 6
#define ANSD7                   ANSELDbits.ANSD7                // bit 7

#define ANSE0                   ANSELEbits.ANSE0                // bit 0
#define ANSE1                   ANSELEbits.ANSE1                // bit 1
#define ANSE2                   ANSELEbits.ANSE2                // bit 2

#define ABDEN                   BAUD1CONbits.ABDEN              // bit 0
#define WUE                     BAUD1CONbits.WUE                // bit 1
#define BRG16                   BAUD1CONbits.BRG16              // bit 3
#define SCKP                    BAUD1CONbits.SCKP               // bit 4
#define RCIDL                   BAUD1CONbits.RCIDL              // bit 6
#define ABDOVF                  BAUD1CONbits.ABDOVF             // bit 7

#define BORRDY                  BORCONbits.BORRDY               // bit 0
#define BORFS                   BORCONbits.BORFS                // bit 6
#define SBOREN                  BORCONbits.SBOREN               // bit 7

#define BSR0                    BSRbits.BSR0                    // bit 0
#define BSR1                    BSRbits.BSR1                    // bit 1
#define BSR2                    BSRbits.BSR2                    // bit 2
#define BSR3                    BSRbits.BSR3                    // bit 3
#define BSR4                    BSRbits.BSR4                    // bit 4

#define CCP1M0                  CCP1CONbits.CCP1M0              // bit 0
#define CCP1M1                  CCP1CONbits.CCP1M1              // bit 1
#define CCP1M2                  CCP1CONbits.CCP1M2              // bit 2
#define CCP1M3                  CCP1CONbits.CCP1M3              // bit 3
#define DC1B0                   CCP1CONbits.DC1B0               // bit 4, shadows bit in CCP1CONbits
#define CCP1Y                   CCP1CONbits.CCP1Y               // bit 4, shadows bit in CCP1CONbits
#define DC1B1                   CCP1CONbits.DC1B1               // bit 5, shadows bit in CCP1CONbits
#define CCP1X                   CCP1CONbits.CCP1X               // bit 5, shadows bit in CCP1CONbits

#define CCP2M0                  CCP2CONbits.CCP2M0              // bit 0
#define CCP2M1                  CCP2CONbits.CCP2M1              // bit 1
#define CCP2M2                  CCP2CONbits.CCP2M2              // bit 2
#define CCP2M3                  CCP2CONbits.CCP2M3              // bit 3
#define DC2B0                   CCP2CONbits.DC2B0               // bit 4, shadows bit in CCP2CONbits
#define CCP2Y                   CCP2CONbits.CCP2Y               // bit 4, shadows bit in CCP2CONbits
#define DC2B1                   CCP2CONbits.DC2B1               // bit 5, shadows bit in CCP2CONbits
#define CCP2X                   CCP2CONbits.CCP2X               // bit 5, shadows bit in CCP2CONbits

#define C1TSEL0                 CCPTMRSbits.C1TSEL0             // bit 0
#define C1TSEL1                 CCPTMRSbits.C1TSEL1             // bit 1
#define C2TSEL0                 CCPTMRSbits.C2TSEL0             // bit 2
#define C2TSEL1                 CCPTMRSbits.C2TSEL1             // bit 3
#define P3TSEL0                 CCPTMRSbits.P3TSEL0             // bit 4
#define P3TSEL1                 CCPTMRSbits.P3TSEL1             // bit 5
#define P4TSEL0                 CCPTMRSbits.P4TSEL0             // bit 6
#define P4TSEL1                 CCPTMRSbits.P4TSEL1             // bit 7

#define LC1MODE0                CLC1CONbits.LC1MODE0            // bit 0, shadows bit in CLC1CONbits
#define MODE0                   CLC1CONbits.MODE0               // bit 0, shadows bit in CLC1CONbits
#define LC1MODE1                CLC1CONbits.LC1MODE1            // bit 1, shadows bit in CLC1CONbits
#define MODE1                   CLC1CONbits.MODE1               // bit 1, shadows bit in CLC1CONbits
#define LC1MODE2                CLC1CONbits.LC1MODE2            // bit 2, shadows bit in CLC1CONbits
#define MODE2                   CLC1CONbits.MODE2               // bit 2, shadows bit in CLC1CONbits
#define LC1INTN                 CLC1CONbits.LC1INTN             // bit 3, shadows bit in CLC1CONbits
#define INTN                    CLC1CONbits.INTN                // bit 3, shadows bit in CLC1CONbits
#define LC1INTP                 CLC1CONbits.LC1INTP             // bit 4, shadows bit in CLC1CONbits
#define INTP                    CLC1CONbits.INTP                // bit 4, shadows bit in CLC1CONbits
#define LC1OUT                  CLC1CONbits.LC1OUT              // bit 5, shadows bit in CLC1CONbits
#define OUT                     CLC1CONbits.OUT                 // bit 5, shadows bit in CLC1CONbits
#define LC1EN                   CLC1CONbits.LC1EN               // bit 7, shadows bit in CLC1CONbits
#define EN                      CLC1CONbits.EN                  // bit 7, shadows bit in CLC1CONbits

#define LC1G1D1N                CLC1GLS0bits.LC1G1D1N           // bit 0, shadows bit in CLC1GLS0bits
#define D1N                     CLC1GLS0bits.D1N                // bit 0, shadows bit in CLC1GLS0bits
#define LC1G1D1T                CLC1GLS0bits.LC1G1D1T           // bit 1, shadows bit in CLC1GLS0bits
#define D1T                     CLC1GLS0bits.D1T                // bit 1, shadows bit in CLC1GLS0bits
#define LC1G1D2N                CLC1GLS0bits.LC1G1D2N           // bit 2, shadows bit in CLC1GLS0bits
#define D2N                     CLC1GLS0bits.D2N                // bit 2, shadows bit in CLC1GLS0bits
#define LC1G1D2T                CLC1GLS0bits.LC1G1D2T           // bit 3, shadows bit in CLC1GLS0bits
#define D2T                     CLC1GLS0bits.D2T                // bit 3, shadows bit in CLC1GLS0bits
#define LC1G1D3N                CLC1GLS0bits.LC1G1D3N           // bit 4, shadows bit in CLC1GLS0bits
#define D3N                     CLC1GLS0bits.D3N                // bit 4, shadows bit in CLC1GLS0bits
#define LC1G1D3T                CLC1GLS0bits.LC1G1D3T           // bit 5, shadows bit in CLC1GLS0bits
#define D3T                     CLC1GLS0bits.D3T                // bit 5, shadows bit in CLC1GLS0bits
#define LC1G1D4N                CLC1GLS0bits.LC1G1D4N           // bit 6, shadows bit in CLC1GLS0bits
#define D4N                     CLC1GLS0bits.D4N                // bit 6, shadows bit in CLC1GLS0bits
#define LC1G1D4T                CLC1GLS0bits.LC1G1D4T           // bit 7, shadows bit in CLC1GLS0bits
#define D4T                     CLC1GLS0bits.D4T                // bit 7, shadows bit in CLC1GLS0bits

#define LC1G4D1N                CLC1GLS3bits.LC1G4D1N           // bit 0, shadows bit in CLC1GLS3bits
#define G4D1N                   CLC1GLS3bits.G4D1N              // bit 0, shadows bit in CLC1GLS3bits
#define LC1G4D1T                CLC1GLS3bits.LC1G4D1T           // bit 1, shadows bit in CLC1GLS3bits
#define G4D1T                   CLC1GLS3bits.G4D1T              // bit 1, shadows bit in CLC1GLS3bits
#define LC1G4D2N                CLC1GLS3bits.LC1G4D2N           // bit 2, shadows bit in CLC1GLS3bits
#define G4D2N                   CLC1GLS3bits.G4D2N              // bit 2, shadows bit in CLC1GLS3bits
#define LC1G4D2T                CLC1GLS3bits.LC1G4D2T           // bit 3, shadows bit in CLC1GLS3bits
#define G4D2T                   CLC1GLS3bits.G4D2T              // bit 3, shadows bit in CLC1GLS3bits
#define LC1G4D3N                CLC1GLS3bits.LC1G4D3N           // bit 4, shadows bit in CLC1GLS3bits
#define G4D3N                   CLC1GLS3bits.G4D3N              // bit 4, shadows bit in CLC1GLS3bits
#define LC1G4D3T                CLC1GLS3bits.LC1G4D3T           // bit 5, shadows bit in CLC1GLS3bits
#define G4D3T                   CLC1GLS3bits.G4D3T              // bit 5, shadows bit in CLC1GLS3bits
#define LC1G4D4N                CLC1GLS3bits.LC1G4D4N           // bit 6, shadows bit in CLC1GLS3bits
#define G4D4N                   CLC1GLS3bits.G4D4N              // bit 6, shadows bit in CLC1GLS3bits
#define LC1G4D4T                CLC1GLS3bits.LC1G4D4T           // bit 7, shadows bit in CLC1GLS3bits
#define G4D4T                   CLC1GLS3bits.G4D4T              // bit 7, shadows bit in CLC1GLS3bits

#define LC1G1POL                CLC1POLbits.LC1G1POL            // bit 0, shadows bit in CLC1POLbits
#define G1POL                   CLC1POLbits.G1POL               // bit 0, shadows bit in CLC1POLbits
#define LC1G2POL                CLC1POLbits.LC1G2POL            // bit 1, shadows bit in CLC1POLbits
#define G2POL                   CLC1POLbits.G2POL               // bit 1, shadows bit in CLC1POLbits
#define LC1G3POL                CLC1POLbits.LC1G3POL            // bit 2, shadows bit in CLC1POLbits
#define G3POL                   CLC1POLbits.G3POL               // bit 2, shadows bit in CLC1POLbits
#define LC1G4POL                CLC1POLbits.LC1G4POL            // bit 3, shadows bit in CLC1POLbits
#define G4POL                   CLC1POLbits.G4POL               // bit 3, shadows bit in CLC1POLbits
#define LC1POL                  CLC1POLbits.LC1POL              // bit 7, shadows bit in CLC1POLbits
#define POL                     CLC1POLbits.POL                 // bit 7, shadows bit in CLC1POLbits

#define LC1D1S0                 CLC1SEL0bits.LC1D1S0            // bit 0, shadows bit in CLC1SEL0bits
#define D1S0                    CLC1SEL0bits.D1S0               // bit 0, shadows bit in CLC1SEL0bits
#define LC1D1S1                 CLC1SEL0bits.LC1D1S1            // bit 1, shadows bit in CLC1SEL0bits
#define D1S1                    CLC1SEL0bits.D1S1               // bit 1, shadows bit in CLC1SEL0bits
#define LC1D1S2                 CLC1SEL0bits.LC1D1S2            // bit 2, shadows bit in CLC1SEL0bits
#define D1S2                    CLC1SEL0bits.D1S2               // bit 2, shadows bit in CLC1SEL0bits
#define LC1D1S3                 CLC1SEL0bits.LC1D1S3            // bit 3, shadows bit in CLC1SEL0bits
#define D1S3                    CLC1SEL0bits.D1S3               // bit 3, shadows bit in CLC1SEL0bits
#define LC1D1S4                 CLC1SEL0bits.LC1D1S4            // bit 4, shadows bit in CLC1SEL0bits
#define D1S4                    CLC1SEL0bits.D1S4               // bit 4, shadows bit in CLC1SEL0bits

#define LC1D2S0                 CLC1SEL1bits.LC1D2S0            // bit 0, shadows bit in CLC1SEL1bits
#define D2S0                    CLC1SEL1bits.D2S0               // bit 0, shadows bit in CLC1SEL1bits
#define LC1D2S1                 CLC1SEL1bits.LC1D2S1            // bit 1, shadows bit in CLC1SEL1bits
#define D2S1                    CLC1SEL1bits.D2S1               // bit 1, shadows bit in CLC1SEL1bits
#define LC1D2S2                 CLC1SEL1bits.LC1D2S2            // bit 2, shadows bit in CLC1SEL1bits
#define D2S2                    CLC1SEL1bits.D2S2               // bit 2, shadows bit in CLC1SEL1bits
#define LC1D2S3                 CLC1SEL1bits.LC1D2S3            // bit 3, shadows bit in CLC1SEL1bits
#define D2S3                    CLC1SEL1bits.D2S3               // bit 3, shadows bit in CLC1SEL1bits
#define LC1D2S4                 CLC1SEL1bits.LC1D2S4            // bit 4, shadows bit in CLC1SEL1bits
#define D2S4                    CLC1SEL1bits.D2S4               // bit 4, shadows bit in CLC1SEL1bits

#define LC1D3S0                 CLC1SEL2bits.LC1D3S0            // bit 0, shadows bit in CLC1SEL2bits
#define D3S0                    CLC1SEL2bits.D3S0               // bit 0, shadows bit in CLC1SEL2bits
#define LC1D3S1                 CLC1SEL2bits.LC1D3S1            // bit 1, shadows bit in CLC1SEL2bits
#define D3S1                    CLC1SEL2bits.D3S1               // bit 1, shadows bit in CLC1SEL2bits
#define LC1D3S2                 CLC1SEL2bits.LC1D3S2            // bit 2, shadows bit in CLC1SEL2bits
#define D3S2                    CLC1SEL2bits.D3S2               // bit 2, shadows bit in CLC1SEL2bits
#define LC1D3S3                 CLC1SEL2bits.LC1D3S3            // bit 3, shadows bit in CLC1SEL2bits
#define D3S3                    CLC1SEL2bits.D3S3               // bit 3, shadows bit in CLC1SEL2bits
#define LC1D3S4                 CLC1SEL2bits.LC1D3S4            // bit 4, shadows bit in CLC1SEL2bits
#define D3S4                    CLC1SEL2bits.D3S4               // bit 4, shadows bit in CLC1SEL2bits

#define LC1D4S0                 CLC1SEL3bits.LC1D4S0            // bit 0, shadows bit in CLC1SEL3bits
#define D4S0                    CLC1SEL3bits.D4S0               // bit 0, shadows bit in CLC1SEL3bits
#define LC1D4S1                 CLC1SEL3bits.LC1D4S1            // bit 1, shadows bit in CLC1SEL3bits
#define D4S1                    CLC1SEL3bits.D4S1               // bit 1, shadows bit in CLC1SEL3bits
#define LC1D4S2                 CLC1SEL3bits.LC1D4S2            // bit 2, shadows bit in CLC1SEL3bits
#define D4S2                    CLC1SEL3bits.D4S2               // bit 2, shadows bit in CLC1SEL3bits
#define LC1D4S3                 CLC1SEL3bits.LC1D4S3            // bit 3, shadows bit in CLC1SEL3bits
#define D4S3                    CLC1SEL3bits.D4S3               // bit 3, shadows bit in CLC1SEL3bits
#define LC1D4S4                 CLC1SEL3bits.LC1D4S4            // bit 4, shadows bit in CLC1SEL3bits
#define D4S4                    CLC1SEL3bits.D4S4               // bit 4, shadows bit in CLC1SEL3bits

#define MLC1OUT                 CLCDATAbits.MLC1OUT             // bit 0, shadows bit in CLCDATAbits
#define MCLC1OUT                CLCDATAbits.MCLC1OUT            // bit 0, shadows bit in CLCDATAbits
#define MLC2OUT                 CLCDATAbits.MLC2OUT             // bit 1, shadows bit in CLCDATAbits
#define MCLC2OUT                CLCDATAbits.MCLC2OUT            // bit 1, shadows bit in CLCDATAbits
#define MLC3OUT                 CLCDATAbits.MLC3OUT             // bit 2, shadows bit in CLCDATAbits
#define MCLC3OUT                CLCDATAbits.MCLC3OUT            // bit 2, shadows bit in CLCDATAbits
#define MLC4OUT                 CLCDATAbits.MLC4OUT             // bit 3, shadows bit in CLCDATAbits
#define MCLC4OUT                CLCDATAbits.MCLC4OUT            // bit 3, shadows bit in CLCDATAbits

#define C1SYNC                  CM1CON0bits.C1SYNC              // bit 0
#define C1HYS                   CM1CON0bits.C1HYS               // bit 1
#define C1SP                    CM1CON0bits.C1SP                // bit 2
#define C1ZLF                   CM1CON0bits.C1ZLF               // bit 3
#define C1POL                   CM1CON0bits.C1POL               // bit 4
#define C1OUT                   CM1CON0bits.C1OUT               // bit 6
#define C1ON                    CM1CON0bits.C1ON                // bit 7

#define C1NCH0                  CM1CON1bits.C1NCH0              // bit 0
#define C1NCH1                  CM1CON1bits.C1NCH1              // bit 1
#define C1NCH2                  CM1CON1bits.C1NCH2              // bit 2
#define C1PCH0                  CM1CON1bits.C1PCH0              // bit 3
#define C1PCH1                  CM1CON1bits.C1PCH1              // bit 4
#define C1PCH2                  CM1CON1bits.C1PCH2              // bit 5
#define C1INTN                  CM1CON1bits.C1INTN              // bit 6
#define C1INTP                  CM1CON1bits.C1INTP              // bit 7

#define C2SYNC                  CM2CON0bits.C2SYNC              // bit 0
#define C2HYS                   CM2CON0bits.C2HYS               // bit 1
#define C2SP                    CM2CON0bits.C2SP                // bit 2
#define C2ZLF                   CM2CON0bits.C2ZLF               // bit 3
#define C2POL                   CM2CON0bits.C2POL               // bit 4
#define C2OUT                   CM2CON0bits.C2OUT               // bit 6
#define C2ON                    CM2CON0bits.C2ON                // bit 7

#define C2NCH0                  CM2CON1bits.C2NCH0              // bit 0
#define C2NCH1                  CM2CON1bits.C2NCH1              // bit 1
#define C2NCH2                  CM2CON1bits.C2NCH2              // bit 2
#define C2PCH0                  CM2CON1bits.C2PCH0              // bit 3
#define C2PCH1                  CM2CON1bits.C2PCH1              // bit 4
#define C2PCH2                  CM2CON1bits.C2PCH2              // bit 5
#define C2INTN                  CM2CON1bits.C2INTN              // bit 6
#define C2INTP                  CM2CON1bits.C2INTP              // bit 7

#define MC1OUT                  CMOUTbits.MC1OUT                // bit 0
#define MC2OUT                  CMOUTbits.MC2OUT                // bit 1

#define G1ASDAC0                COG1ASD0bits.G1ASDAC0           // bit 2
#define G1ASDAC1                COG1ASD0bits.G1ASDAC1           // bit 3
#define G1ASDBD0                COG1ASD0bits.G1ASDBD0           // bit 4
#define G1ASDBD1                COG1ASD0bits.G1ASDBD1           // bit 5
#define G1ARSEN                 COG1ASD0bits.G1ARSEN            // bit 6
#define G1ASE                   COG1ASD0bits.G1ASE              // bit 7

#define G1AS0E                  COG1ASD1bits.G1AS0E             // bit 0
#define G1AS1E                  COG1ASD1bits.G1AS1E             // bit 1
#define G1AS2E                  COG1ASD1bits.G1AS2E             // bit 2
#define G1AS3E                  COG1ASD1bits.G1AS3E             // bit 3

#define G1BLKF0                 COG1BLKFbits.G1BLKF0            // bit 0
#define G1BLKF1                 COG1BLKFbits.G1BLKF1            // bit 1
#define G1BLKF2                 COG1BLKFbits.G1BLKF2            // bit 2
#define G1BLKF3                 COG1BLKFbits.G1BLKF3            // bit 3
#define G1BLKF4                 COG1BLKFbits.G1BLKF4            // bit 4
#define G1BLKF5                 COG1BLKFbits.G1BLKF5            // bit 5

#define G1BLKR0                 COG1BLKRbits.G1BLKR0            // bit 0
#define G1BLKR1                 COG1BLKRbits.G1BLKR1            // bit 1
#define G1BLKR2                 COG1BLKRbits.G1BLKR2            // bit 2
#define G1BLKR3                 COG1BLKRbits.G1BLKR3            // bit 3
#define G1BLKR4                 COG1BLKRbits.G1BLKR4            // bit 4
#define G1BLKR5                 COG1BLKRbits.G1BLKR5            // bit 5

#define G1MD0                   COG1CON0bits.G1MD0              // bit 0
#define G1MD1                   COG1CON0bits.G1MD1              // bit 1
#define G1MD2                   COG1CON0bits.G1MD2              // bit 2
#define G1CS0                   COG1CON0bits.G1CS0              // bit 3
#define G1CS1                   COG1CON0bits.G1CS1              // bit 4
#define G1LD                    COG1CON0bits.G1LD               // bit 6
#define G1EN                    COG1CON0bits.G1EN               // bit 7

#define G1POLA                  COG1CON1bits.G1POLA             // bit 0
#define G1POLB                  COG1CON1bits.G1POLB             // bit 1
#define G1POLC                  COG1CON1bits.G1POLC             // bit 2
#define G1POLD                  COG1CON1bits.G1POLD             // bit 3
#define G1FDBS                  COG1CON1bits.G1FDBS             // bit 6
#define G1RDBS                  COG1CON1bits.G1RDBS             // bit 7

#define G1DBF0                  COG1DBFbits.G1DBF0              // bit 0
#define G1DBF1                  COG1DBFbits.G1DBF1              // bit 1
#define G1DBF2                  COG1DBFbits.G1DBF2              // bit 2
#define G1DBF3                  COG1DBFbits.G1DBF3              // bit 3
#define G1DBF4                  COG1DBFbits.G1DBF4              // bit 4
#define G1DBF5                  COG1DBFbits.G1DBF5              // bit 5

#define G1DBR0                  COG1DBRbits.G1DBR0              // bit 0
#define G1DBR1                  COG1DBRbits.G1DBR1              // bit 1
#define G1DBR2                  COG1DBRbits.G1DBR2              // bit 2
#define G1DBR3                  COG1DBRbits.G1DBR3              // bit 3
#define G1DBR4                  COG1DBRbits.G1DBR4              // bit 4
#define G1DBR5                  COG1DBRbits.G1DBR5              // bit 5

#define G1FIS0                  COG1FISbits.G1FIS0              // bit 0
#define G1FIS1                  COG1FISbits.G1FIS1              // bit 1
#define G1FIS2                  COG1FISbits.G1FIS2              // bit 2
#define G1FIS3                  COG1FISbits.G1FIS3              // bit 3
#define G1FIS4                  COG1FISbits.G1FIS4              // bit 4
#define G1FIS5                  COG1FISbits.G1FIS5              // bit 5
#define G1FIS6                  COG1FISbits.G1FIS6              // bit 6
#define G1FIS7                  COG1FISbits.G1FIS7              // bit 7

#define G1FSIM0                 COG1FSIMbits.G1FSIM0            // bit 0
#define G1FSIM1                 COG1FSIMbits.G1FSIM1            // bit 1
#define G1FSIM2                 COG1FSIMbits.G1FSIM2            // bit 2
#define G1FSIM3                 COG1FSIMbits.G1FSIM3            // bit 3
#define G1FSIM4                 COG1FSIMbits.G1FSIM4            // bit 4
#define G1FSIM5                 COG1FSIMbits.G1FSIM5            // bit 5
#define G1FSIM6                 COG1FSIMbits.G1FSIM6            // bit 6
#define G1FSIM7                 COG1FSIMbits.G1FSIM7            // bit 7

#define G1PHF0                  COG1PHFbits.G1PHF0              // bit 0
#define G1PHF1                  COG1PHFbits.G1PHF1              // bit 1
#define G1PHF2                  COG1PHFbits.G1PHF2              // bit 2
#define G1PHF3                  COG1PHFbits.G1PHF3              // bit 3
#define G1PHF4                  COG1PHFbits.G1PHF4              // bit 4
#define G1PHF5                  COG1PHFbits.G1PHF5              // bit 5

#define G1PHR0                  COG1PHRbits.G1PHR0              // bit 0
#define G1PHR1                  COG1PHRbits.G1PHR1              // bit 1
#define G1PHR2                  COG1PHRbits.G1PHR2              // bit 2
#define G1PHR3                  COG1PHRbits.G1PHR3              // bit 3
#define G1PHR4                  COG1PHRbits.G1PHR4              // bit 4
#define G1PHR5                  COG1PHRbits.G1PHR5              // bit 5

#define G1RIS0                  COG1RISbits.G1RIS0              // bit 0
#define G1RIS1                  COG1RISbits.G1RIS1              // bit 1
#define G1RIS2                  COG1RISbits.G1RIS2              // bit 2
#define G1RIS3                  COG1RISbits.G1RIS3              // bit 3
#define G1RIS4                  COG1RISbits.G1RIS4              // bit 4
#define G1RIS5                  COG1RISbits.G1RIS5              // bit 5
#define G1RIS6                  COG1RISbits.G1RIS6              // bit 6
#define G1RIS7                  COG1RISbits.G1RIS7              // bit 7

#define G1RSIM0                 COG1RSIMbits.G1RSIM0            // bit 0
#define G1RSIM1                 COG1RSIMbits.G1RSIM1            // bit 1
#define G1RSIM2                 COG1RSIMbits.G1RSIM2            // bit 2
#define G1RSIM3                 COG1RSIMbits.G1RSIM3            // bit 3
#define G1RSIM4                 COG1RSIMbits.G1RSIM4            // bit 4
#define G1RSIM5                 COG1RSIMbits.G1RSIM5            // bit 5
#define G1RSIM6                 COG1RSIMbits.G1RSIM6            // bit 6
#define G1RSIM7                 COG1RSIMbits.G1RSIM7            // bit 7

#define G1STRA                  COG1STRbits.G1STRA              // bit 0
#define G1STRB                  COG1STRbits.G1STRB              // bit 1
#define G1STRC                  COG1STRbits.G1STRC              // bit 2
#define G1STRD                  COG1STRbits.G1STRD              // bit 3
#define G1SDATA                 COG1STRbits.G1SDATA             // bit 4
#define G1SDATB                 COG1STRbits.G1SDATB             // bit 5
#define G1SDATC                 COG1STRbits.G1SDATC             // bit 6
#define G1SDATD                 COG1STRbits.G1SDATD             // bit 7

#define DAC1NSS                 DAC1CON0bits.DAC1NSS            // bit 0, shadows bit in DAC1CON0bits
#define DACNSS                  DAC1CON0bits.DACNSS             // bit 0, shadows bit in DAC1CON0bits
#define DAC1PSS0                DAC1CON0bits.DAC1PSS0           // bit 2, shadows bit in DAC1CON0bits
#define DACPSS0                 DAC1CON0bits.DACPSS0            // bit 2, shadows bit in DAC1CON0bits
#define DAC1PSS1                DAC1CON0bits.DAC1PSS1           // bit 3, shadows bit in DAC1CON0bits
#define DACPSS1                 DAC1CON0bits.DACPSS1            // bit 3, shadows bit in DAC1CON0bits
#define DAC1OE2                 DAC1CON0bits.DAC1OE2            // bit 4, shadows bit in DAC1CON0bits
#define DACOE0                  DAC1CON0bits.DACOE0             // bit 4, shadows bit in DAC1CON0bits
#define DAC1OE1                 DAC1CON0bits.DAC1OE1            // bit 5, shadows bit in DAC1CON0bits
#define DACOE1                  DAC1CON0bits.DACOE1             // bit 5, shadows bit in DAC1CON0bits
#define DAC1EN                  DAC1CON0bits.DAC1EN             // bit 7, shadows bit in DAC1CON0bits
#define DACEN                   DAC1CON0bits.DACEN              // bit 7, shadows bit in DAC1CON0bits

#define DAC1R0                  DAC1CON1bits.DAC1R0             // bit 0, shadows bit in DAC1CON1bits
#define DACR0                   DAC1CON1bits.DACR0              // bit 0, shadows bit in DAC1CON1bits
#define DAC1R1                  DAC1CON1bits.DAC1R1             // bit 1, shadows bit in DAC1CON1bits
#define DACR1                   DAC1CON1bits.DACR1              // bit 1, shadows bit in DAC1CON1bits
#define DAC1R2                  DAC1CON1bits.DAC1R2             // bit 2, shadows bit in DAC1CON1bits
#define DACR2                   DAC1CON1bits.DACR2              // bit 2, shadows bit in DAC1CON1bits
#define DAC1R3                  DAC1CON1bits.DAC1R3             // bit 3, shadows bit in DAC1CON1bits
#define DACR3                   DAC1CON1bits.DACR3              // bit 3, shadows bit in DAC1CON1bits
#define DAC1R4                  DAC1CON1bits.DAC1R4             // bit 4, shadows bit in DAC1CON1bits
#define DACR4                   DAC1CON1bits.DACR4              // bit 4, shadows bit in DAC1CON1bits
#define DAC1R5                  DAC1CON1bits.DAC1R5             // bit 5, shadows bit in DAC1CON1bits
#define DACR5                   DAC1CON1bits.DACR5              // bit 5, shadows bit in DAC1CON1bits
#define DAC1R6                  DAC1CON1bits.DAC1R6             // bit 6, shadows bit in DAC1CON1bits
#define DACR6                   DAC1CON1bits.DACR6              // bit 6, shadows bit in DAC1CON1bits
#define DAC1R7                  DAC1CON1bits.DAC1R7             // bit 7, shadows bit in DAC1CON1bits
#define DACR7                   DAC1CON1bits.DACR7              // bit 7, shadows bit in DAC1CON1bits

#define ADFVR0                  FVRCONbits.ADFVR0               // bit 0
#define ADFVR1                  FVRCONbits.ADFVR1               // bit 1
#define CDAFVR0                 FVRCONbits.CDAFVR0              // bit 2
#define CDAFVR1                 FVRCONbits.CDAFVR1              // bit 3
#define TSRNG                   FVRCONbits.TSRNG                // bit 4
#define TSEN                    FVRCONbits.TSEN                 // bit 5
#define FVRRDY                  FVRCONbits.FVRRDY               // bit 6
#define FVREN                   FVRCONbits.FVREN                // bit 7

#define INLVLA0                 INLVLAbits.INLVLA0              // bit 0
#define INLVLA1                 INLVLAbits.INLVLA1              // bit 1
#define INLVLA2                 INLVLAbits.INLVLA2              // bit 2
#define INLVLA3                 INLVLAbits.INLVLA3              // bit 3
#define INLVLA4                 INLVLAbits.INLVLA4              // bit 4
#define INLVLA5                 INLVLAbits.INLVLA5              // bit 5
#define INLVLA6                 INLVLAbits.INLVLA6              // bit 6
#define INLVLA7                 INLVLAbits.INLVLA7              // bit 7

#define INLVLB0                 INLVLBbits.INLVLB0              // bit 0
#define INLVLB1                 INLVLBbits.INLVLB1              // bit 1
#define INLVLB2                 INLVLBbits.INLVLB2              // bit 2
#define INLVLB3                 INLVLBbits.INLVLB3              // bit 3
#define INLVLB4                 INLVLBbits.INLVLB4              // bit 4
#define INLVLB5                 INLVLBbits.INLVLB5              // bit 5
#define INLVLB6                 INLVLBbits.INLVLB6              // bit 6
#define INLVLB7                 INLVLBbits.INLVLB7              // bit 7

#define INLVLC0                 INLVLCbits.INLVLC0              // bit 0
#define INLVLC1                 INLVLCbits.INLVLC1              // bit 1
#define INLVLC2                 INLVLCbits.INLVLC2              // bit 2
#define INLVLC3                 INLVLCbits.INLVLC3              // bit 3
#define INLVLC4                 INLVLCbits.INLVLC4              // bit 4
#define INLVLC5                 INLVLCbits.INLVLC5              // bit 5
#define INLVLC6                 INLVLCbits.INLVLC6              // bit 6
#define INLVLC7                 INLVLCbits.INLVLC7              // bit 7

#define INLVLD0                 INLVLDbits.INLVLD0              // bit 0
#define INLVLD1                 INLVLDbits.INLVLD1              // bit 1
#define INLVLD2                 INLVLDbits.INLVLD2              // bit 2
#define INLVLD3                 INLVLDbits.INLVLD3              // bit 3
#define INLVLD4                 INLVLDbits.INLVLD4              // bit 4
#define INLVLD5                 INLVLDbits.INLVLD5              // bit 5
#define INLVLD6                 INLVLDbits.INLVLD6              // bit 6
#define INLVLD7                 INLVLDbits.INLVLD7              // bit 7

#define INLVLE0                 INLVLEbits.INLVLE0              // bit 0
#define INLVLE1                 INLVLEbits.INLVLE1              // bit 1
#define INLVLE2                 INLVLEbits.INLVLE2              // bit 2
#define INLVLE3                 INLVLEbits.INLVLE3              // bit 3

#define IOCIF                   INTCONbits.IOCIF                // bit 0
#define INTF                    INTCONbits.INTF                 // bit 1
#define TMR0IF                  INTCONbits.TMR0IF               // bit 2, shadows bit in INTCONbits
#define T0IF                    INTCONbits.T0IF                 // bit 2, shadows bit in INTCONbits
#define IOCIE                   INTCONbits.IOCIE                // bit 3
#define INTE                    INTCONbits.INTE                 // bit 4
#define TMR0IE                  INTCONbits.TMR0IE               // bit 5, shadows bit in INTCONbits
#define T0IE                    INTCONbits.T0IE                 // bit 5, shadows bit in INTCONbits
#define PEIE                    INTCONbits.PEIE                 // bit 6
#define GIE                     INTCONbits.GIE                  // bit 7

#define IOCAF0                  IOCAFbits.IOCAF0                // bit 0
#define IOCAF1                  IOCAFbits.IOCAF1                // bit 1
#define IOCAF2                  IOCAFbits.IOCAF2                // bit 2
#define IOCAF3                  IOCAFbits.IOCAF3                // bit 3
#define IOCAF4                  IOCAFbits.IOCAF4                // bit 4
#define IOCAF5                  IOCAFbits.IOCAF5                // bit 5
#define IOCAF6                  IOCAFbits.IOCAF6                // bit 6
#define IOCAF7                  IOCAFbits.IOCAF7                // bit 7

#define IOCAN0                  IOCANbits.IOCAN0                // bit 0
#define IOCAN1                  IOCANbits.IOCAN1                // bit 1
#define IOCAN2                  IOCANbits.IOCAN2                // bit 2
#define IOCAN3                  IOCANbits.IOCAN3                // bit 3
#define IOCAN4                  IOCANbits.IOCAN4                // bit 4
#define IOCAN5                  IOCANbits.IOCAN5                // bit 5
#define IOCAN6                  IOCANbits.IOCAN6                // bit 6
#define IOCAN7                  IOCANbits.IOCAN7                // bit 7

#define IOCAP0                  IOCAPbits.IOCAP0                // bit 0
#define IOCAP1                  IOCAPbits.IOCAP1                // bit 1
#define IOCAP2                  IOCAPbits.IOCAP2                // bit 2
#define IOCAP3                  IOCAPbits.IOCAP3                // bit 3
#define IOCAP4                  IOCAPbits.IOCAP4                // bit 4
#define IOCAP5                  IOCAPbits.IOCAP5                // bit 5
#define IOCAP6                  IOCAPbits.IOCAP6                // bit 6
#define IOCAP7                  IOCAPbits.IOCAP7                // bit 7

#define IOCBF0                  IOCBFbits.IOCBF0                // bit 0
#define IOCBF1                  IOCBFbits.IOCBF1                // bit 1
#define IOCBF2                  IOCBFbits.IOCBF2                // bit 2
#define IOCBF3                  IOCBFbits.IOCBF3                // bit 3
#define IOCBF4                  IOCBFbits.IOCBF4                // bit 4
#define IOCBF5                  IOCBFbits.IOCBF5                // bit 5
#define IOCBF6                  IOCBFbits.IOCBF6                // bit 6
#define IOCBF7                  IOCBFbits.IOCBF7                // bit 7

#define IOCBN0                  IOCBNbits.IOCBN0                // bit 0
#define IOCBN1                  IOCBNbits.IOCBN1                // bit 1
#define IOCBN2                  IOCBNbits.IOCBN2                // bit 2
#define IOCBN3                  IOCBNbits.IOCBN3                // bit 3
#define IOCBN4                  IOCBNbits.IOCBN4                // bit 4
#define IOCBN5                  IOCBNbits.IOCBN5                // bit 5
#define IOCBN6                  IOCBNbits.IOCBN6                // bit 6
#define IOCBN7                  IOCBNbits.IOCBN7                // bit 7

#define IOCBP0                  IOCBPbits.IOCBP0                // bit 0
#define IOCBP1                  IOCBPbits.IOCBP1                // bit 1
#define IOCBP2                  IOCBPbits.IOCBP2                // bit 2
#define IOCBP3                  IOCBPbits.IOCBP3                // bit 3
#define IOCBP4                  IOCBPbits.IOCBP4                // bit 4
#define IOCBP5                  IOCBPbits.IOCBP5                // bit 5
#define IOCBP6                  IOCBPbits.IOCBP6                // bit 6
#define IOCBP7                  IOCBPbits.IOCBP7                // bit 7

#define IOCCF0                  IOCCFbits.IOCCF0                // bit 0
#define IOCCF1                  IOCCFbits.IOCCF1                // bit 1
#define IOCCF2                  IOCCFbits.IOCCF2                // bit 2
#define IOCCF3                  IOCCFbits.IOCCF3                // bit 3
#define IOCCF4                  IOCCFbits.IOCCF4                // bit 4
#define IOCCF5                  IOCCFbits.IOCCF5                // bit 5
#define IOCCF6                  IOCCFbits.IOCCF6                // bit 6
#define IOCCF7                  IOCCFbits.IOCCF7                // bit 7

#define IOCCN0                  IOCCNbits.IOCCN0                // bit 0
#define IOCCN1                  IOCCNbits.IOCCN1                // bit 1
#define IOCCN2                  IOCCNbits.IOCCN2                // bit 2
#define IOCCN3                  IOCCNbits.IOCCN3                // bit 3
#define IOCCN4                  IOCCNbits.IOCCN4                // bit 4
#define IOCCN5                  IOCCNbits.IOCCN5                // bit 5
#define IOCCN6                  IOCCNbits.IOCCN6                // bit 6
#define IOCCN7                  IOCCNbits.IOCCN7                // bit 7

#define IOCCP0                  IOCCPbits.IOCCP0                // bit 0
#define IOCCP1                  IOCCPbits.IOCCP1                // bit 1
#define IOCCP2                  IOCCPbits.IOCCP2                // bit 2
#define IOCCP3                  IOCCPbits.IOCCP3                // bit 3
#define IOCCP4                  IOCCPbits.IOCCP4                // bit 4
#define IOCCP5                  IOCCPbits.IOCCP5                // bit 5
#define IOCCP6                  IOCCPbits.IOCCP6                // bit 6
#define IOCCP7                  IOCCPbits.IOCCP7                // bit 7

#define IOCEF3                  IOCEFbits.IOCEF3                // bit 3

#define IOCEN3                  IOCENbits.IOCEN3                // bit 3

#define IOCEP3                  IOCEPbits.IOCEP3                // bit 3

#define LATA0                   LATAbits.LATA0                  // bit 0
#define LATA1                   LATAbits.LATA1                  // bit 1
#define LATA2                   LATAbits.LATA2                  // bit 2
#define LATA3                   LATAbits.LATA3                  // bit 3
#define LATA4                   LATAbits.LATA4                  // bit 4
#define LATA5                   LATAbits.LATA5                  // bit 5
#define LATA6                   LATAbits.LATA6                  // bit 6
#define LATA7                   LATAbits.LATA7                  // bit 7

#define LATB0                   LATBbits.LATB0                  // bit 0
#define LATB1                   LATBbits.LATB1                  // bit 1
#define LATB2                   LATBbits.LATB2                  // bit 2
#define LATB3                   LATBbits.LATB3                  // bit 3
#define LATB4                   LATBbits.LATB4                  // bit 4
#define LATB5                   LATBbits.LATB5                  // bit 5
#define LATB6                   LATBbits.LATB6                  // bit 6
#define LATB7                   LATBbits.LATB7                  // bit 7

#define LATC0                   LATCbits.LATC0                  // bit 0
#define LATC1                   LATCbits.LATC1                  // bit 1
#define LATC2                   LATCbits.LATC2                  // bit 2
#define LATC3                   LATCbits.LATC3                  // bit 3
#define LATC4                   LATCbits.LATC4                  // bit 4
#define LATC5                   LATCbits.LATC5                  // bit 5
#define LATC6                   LATCbits.LATC6                  // bit 6
#define LATC7                   LATCbits.LATC7                  // bit 7

#define LATD0                   LATDbits.LATD0                  // bit 0
#define LATD1                   LATDbits.LATD1                  // bit 1
#define LATD2                   LATDbits.LATD2                  // bit 2
#define LATD3                   LATDbits.LATD3                  // bit 3
#define LATD4                   LATDbits.LATD4                  // bit 4
#define LATD5                   LATDbits.LATD5                  // bit 5
#define LATD6                   LATDbits.LATD6                  // bit 6
#define LATD7                   LATDbits.LATD7                  // bit 7

#define LATE0                   LATEbits.LATE0                  // bit 0
#define LATE1                   LATEbits.LATE1                  // bit 1
#define LATE2                   LATEbits.LATE2                  // bit 2

#define NCO1ACC8                NCO1ACCHbits.NCO1ACC8           // bit 0
#define NCO1ACC9                NCO1ACCHbits.NCO1ACC9           // bit 1
#define NCO1ACC10               NCO1ACCHbits.NCO1ACC10          // bit 2
#define NCO1ACC11               NCO1ACCHbits.NCO1ACC11          // bit 3
#define NCO1ACC12               NCO1ACCHbits.NCO1ACC12          // bit 4
#define NCO1ACC13               NCO1ACCHbits.NCO1ACC13          // bit 5
#define NCO1ACC14               NCO1ACCHbits.NCO1ACC14          // bit 6
#define NCO1ACC15               NCO1ACCHbits.NCO1ACC15          // bit 7

#define NCO1ACC0                NCO1ACCLbits.NCO1ACC0           // bit 0
#define NCO1ACC1                NCO1ACCLbits.NCO1ACC1           // bit 1
#define NCO1ACC2                NCO1ACCLbits.NCO1ACC2           // bit 2
#define NCO1ACC3                NCO1ACCLbits.NCO1ACC3           // bit 3
#define NCO1ACC4                NCO1ACCLbits.NCO1ACC4           // bit 4
#define NCO1ACC5                NCO1ACCLbits.NCO1ACC5           // bit 5
#define NCO1ACC6                NCO1ACCLbits.NCO1ACC6           // bit 6
#define NCO1ACC7                NCO1ACCLbits.NCO1ACC7           // bit 7

#define NCO1ACC16               NCO1ACCUbits.NCO1ACC16          // bit 0
#define NCO1ACC17               NCO1ACCUbits.NCO1ACC17          // bit 1
#define NCO1ACC18               NCO1ACCUbits.NCO1ACC18          // bit 2
#define NCO1ACC19               NCO1ACCUbits.NCO1ACC19          // bit 3

#define N1CKS0                  NCO1CLKbits.N1CKS0              // bit 0
#define N1CKS1                  NCO1CLKbits.N1CKS1              // bit 1
#define N1PWS0                  NCO1CLKbits.N1PWS0              // bit 5
#define N1PWS1                  NCO1CLKbits.N1PWS1              // bit 6
#define N1PWS2                  NCO1CLKbits.N1PWS2              // bit 7

#define N1PFM                   NCO1CONbits.N1PFM               // bit 0
#define N1POL                   NCO1CONbits.N1POL               // bit 4
#define N1OUT                   NCO1CONbits.N1OUT               // bit 5
#define N1EN                    NCO1CONbits.N1EN                // bit 7

#define NCO1INC8                NCO1INCHbits.NCO1INC8           // bit 0
#define NCO1INC9                NCO1INCHbits.NCO1INC9           // bit 1
#define NCO1INC10               NCO1INCHbits.NCO1INC10          // bit 2
#define NCO1INC11               NCO1INCHbits.NCO1INC11          // bit 3
#define NCO1INC12               NCO1INCHbits.NCO1INC12          // bit 4
#define NCO1INC13               NCO1INCHbits.NCO1INC13          // bit 5
#define NCO1INC14               NCO1INCHbits.NCO1INC14          // bit 6
#define NCO1INC15               NCO1INCHbits.NCO1INC15          // bit 7

#define NCO1INC0                NCO1INCLbits.NCO1INC0           // bit 0
#define NCO1INC1                NCO1INCLbits.NCO1INC1           // bit 1
#define NCO1INC2                NCO1INCLbits.NCO1INC2           // bit 2
#define NCO1INC3                NCO1INCLbits.NCO1INC3           // bit 3
#define NCO1INC4                NCO1INCLbits.NCO1INC4           // bit 4
#define NCO1INC5                NCO1INCLbits.NCO1INC5           // bit 5
#define NCO1INC6                NCO1INCLbits.NCO1INC6           // bit 6
#define NCO1INC7                NCO1INCLbits.NCO1INC7           // bit 7

#define NCO1INC16               NCO1INCUbits.NCO1INC16          // bit 0
#define NCO1INC17               NCO1INCUbits.NCO1INC17          // bit 1
#define NCO1INC18               NCO1INCUbits.NCO1INC18          // bit 2
#define NCO1INC19               NCO1INCUbits.NCO1INC19          // bit 3

#define ODA0                    ODCONAbits.ODA0                 // bit 0
#define ODA1                    ODCONAbits.ODA1                 // bit 1
#define ODA2                    ODCONAbits.ODA2                 // bit 2
#define ODA3                    ODCONAbits.ODA3                 // bit 3
#define ODA4                    ODCONAbits.ODA4                 // bit 4
#define ODA5                    ODCONAbits.ODA5                 // bit 5
#define ODA6                    ODCONAbits.ODA6                 // bit 6
#define ODA7                    ODCONAbits.ODA7                 // bit 7

#define ODB0                    ODCONBbits.ODB0                 // bit 0
#define ODB1                    ODCONBbits.ODB1                 // bit 1
#define ODB2                    ODCONBbits.ODB2                 // bit 2
#define ODB3                    ODCONBbits.ODB3                 // bit 3
#define ODB4                    ODCONBbits.ODB4                 // bit 4
#define ODB5                    ODCONBbits.ODB5                 // bit 5
#define ODB6                    ODCONBbits.ODB6                 // bit 6
#define ODB7                    ODCONBbits.ODB7                 // bit 7

#define ODC0                    ODCONCbits.ODC0                 // bit 0
#define ODC1                    ODCONCbits.ODC1                 // bit 1
#define ODC2                    ODCONCbits.ODC2                 // bit 2
#define ODC3                    ODCONCbits.ODC3                 // bit 3
#define ODC4                    ODCONCbits.ODC4                 // bit 4
#define ODC5                    ODCONCbits.ODC5                 // bit 5
#define ODC6                    ODCONCbits.ODC6                 // bit 6
#define ODC7                    ODCONCbits.ODC7                 // bit 7

#define ODD0                    ODCONDbits.ODD0                 // bit 0
#define ODD1                    ODCONDbits.ODD1                 // bit 1
#define ODD2                    ODCONDbits.ODD2                 // bit 2
#define ODD3                    ODCONDbits.ODD3                 // bit 3
#define ODD4                    ODCONDbits.ODD4                 // bit 4
#define ODD5                    ODCONDbits.ODD5                 // bit 5
#define ODD6                    ODCONDbits.ODD6                 // bit 6
#define ODD7                    ODCONDbits.ODD7                 // bit 7

#define ODE0                    ODCONEbits.ODE0                 // bit 0
#define ODE1                    ODCONEbits.ODE1                 // bit 1
#define ODE2                    ODCONEbits.ODE2                 // bit 2

#define OPA1PCH0                OPA1CONbits.OPA1PCH0            // bit 0
#define OPA1PCH1                OPA1CONbits.OPA1PCH1            // bit 1
#define OPA1UG                  OPA1CONbits.OPA1UG              // bit 4
#define OPA1SP                  OPA1CONbits.OPA1SP              // bit 6
#define OPA1EN                  OPA1CONbits.OPA1EN              // bit 7

#define OPA2PCH0                OPA2CONbits.OPA2PCH0            // bit 0
#define OPA2PCH1                OPA2CONbits.OPA2PCH1            // bit 1
#define OPA2UG                  OPA2CONbits.OPA2UG              // bit 4
#define OPA2SP                  OPA2CONbits.OPA2SP              // bit 6
#define OPA2EN                  OPA2CONbits.OPA2EN              // bit 7

#define PS0                     OPTION_REGbits.PS0              // bit 0
#define PS1                     OPTION_REGbits.PS1              // bit 1
#define PS2                     OPTION_REGbits.PS2              // bit 2
#define PSA                     OPTION_REGbits.PSA              // bit 3
#define TMR0SE                  OPTION_REGbits.TMR0SE           // bit 4, shadows bit in OPTION_REGbits
#define T0SE                    OPTION_REGbits.T0SE             // bit 4, shadows bit in OPTION_REGbits
#define TMR0CS                  OPTION_REGbits.TMR0CS           // bit 5, shadows bit in OPTION_REGbits
#define T0CS                    OPTION_REGbits.T0CS             // bit 5, shadows bit in OPTION_REGbits
#define INTEDG                  OPTION_REGbits.INTEDG           // bit 6
#define NOT_WPUEN               OPTION_REGbits.NOT_WPUEN        // bit 7

#define SCS0                    OSCCONbits.SCS0                 // bit 0
#define SCS1                    OSCCONbits.SCS1                 // bit 1
#define IRCF0                   OSCCONbits.IRCF0                // bit 3
#define IRCF1                   OSCCONbits.IRCF1                // bit 4
#define IRCF2                   OSCCONbits.IRCF2                // bit 5
#define IRCF3                   OSCCONbits.IRCF3                // bit 6
#define SPLLEN                  OSCCONbits.SPLLEN               // bit 7

#define HFIOFS                  OSCSTATbits.HFIOFS              // bit 0
#define LFIOFR                  OSCSTATbits.LFIOFR              // bit 1
#define MFIOFR                  OSCSTATbits.MFIOFR              // bit 2
#define HFIOFL                  OSCSTATbits.HFIOFL              // bit 3
#define HFIOFR                  OSCSTATbits.HFIOFR              // bit 4
#define OSTS                    OSCSTATbits.OSTS                // bit 5
#define PLLR                    OSCSTATbits.PLLR                // bit 6
#define SOSCR                   OSCSTATbits.SOSCR               // bit 7

#define TUN0                    OSCTUNEbits.TUN0                // bit 0
#define TUN1                    OSCTUNEbits.TUN1                // bit 1
#define TUN2                    OSCTUNEbits.TUN2                // bit 2
#define TUN3                    OSCTUNEbits.TUN3                // bit 3
#define TUN4                    OSCTUNEbits.TUN4                // bit 4
#define TUN5                    OSCTUNEbits.TUN5                // bit 5

#define NOT_BOR                 PCONbits.NOT_BOR                // bit 0
#define NOT_POR                 PCONbits.NOT_POR                // bit 1
#define NOT_RI                  PCONbits.NOT_RI                 // bit 2
#define NOT_RMCLR               PCONbits.NOT_RMCLR              // bit 3
#define NOT_RWDT                PCONbits.NOT_RWDT               // bit 4
#define STKUNF                  PCONbits.STKUNF                 // bit 6
#define STKOVF                  PCONbits.STKOVF                 // bit 7

#define TMR1IE                  PIE1bits.TMR1IE                 // bit 0
#define TMR2IE                  PIE1bits.TMR2IE                 // bit 1
#define CCP1IE                  PIE1bits.CCP1IE                 // bit 2
#define SSP1IE                  PIE1bits.SSP1IE                 // bit 3
#define TXIE                    PIE1bits.TXIE                   // bit 4
#define RCIE                    PIE1bits.RCIE                   // bit 5
#define ADIE                    PIE1bits.ADIE                   // bit 6
#define TMR1GIE                 PIE1bits.TMR1GIE                // bit 7

#define CCP2IE                  PIE2bits.CCP2IE                 // bit 0
#define TMR4IE                  PIE2bits.TMR4IE                 // bit 1
#define TMR6IE                  PIE2bits.TMR6IE                 // bit 2
#define BCL1IE                  PIE2bits.BCL1IE                 // bit 3
#define C1IE                    PIE2bits.C1IE                   // bit 5
#define C2IE                    PIE2bits.C2IE                   // bit 6
#define OSFIE                   PIE2bits.OSFIE                  // bit 7

#define CLC1IE                  PIE3bits.CLC1IE                 // bit 0
#define CLC2IE                  PIE3bits.CLC2IE                 // bit 1
#define CLC3IE                  PIE3bits.CLC3IE                 // bit 2
#define CLC4IE                  PIE3bits.CLC4IE                 // bit 3
#define ZCDIE                   PIE3bits.ZCDIE                  // bit 4
#define COGIE                   PIE3bits.COGIE                  // bit 5
#define NCOIE                   PIE3bits.NCOIE                  // bit 6

#define TMR1IF                  PIR1bits.TMR1IF                 // bit 0
#define TMR2IF                  PIR1bits.TMR2IF                 // bit 1
#define CCP1IF                  PIR1bits.CCP1IF                 // bit 2
#define SSP1IF                  PIR1bits.SSP1IF                 // bit 3
#define TXIF                    PIR1bits.TXIF                   // bit 4
#define RCIF                    PIR1bits.RCIF                   // bit 5
#define ADIF                    PIR1bits.ADIF                   // bit 6
#define TMR1GIF                 PIR1bits.TMR1GIF                // bit 7

#define CCP2IF                  PIR2bits.CCP2IF                 // bit 0
#define TMR4IF                  PIR2bits.TMR4IF                 // bit 1
#define TMR6IF                  PIR2bits.TMR6IF                 // bit 2
#define BCL1IF                  PIR2bits.BCL1IF                 // bit 3
#define C1IF                    PIR2bits.C1IF                   // bit 5
#define C2IF                    PIR2bits.C2IF                   // bit 6
#define OSFIF                   PIR2bits.OSFIF                  // bit 7

#define CLC1IF                  PIR3bits.CLC1IF                 // bit 0
#define CLC2IF                  PIR3bits.CLC2IF                 // bit 1
#define CLC3IF                  PIR3bits.CLC3IF                 // bit 2
#define CLC4IF                  PIR3bits.CLC4IF                 // bit 3
#define ZCDIF                   PIR3bits.ZCDIF                  // bit 4
#define COGIF                   PIR3bits.COGIF                  // bit 5
#define NCOIF                   PIR3bits.NCOIF                  // bit 6

#define RD                      PMCON1bits.RD                   // bit 0
#define WR                      PMCON1bits.WR                   // bit 1
#define WREN                    PMCON1bits.WREN                 // bit 2
#define WRERR                   PMCON1bits.WRERR                // bit 3
#define FREE                    PMCON1bits.FREE                 // bit 4
#define LWLO                    PMCON1bits.LWLO                 // bit 5
#define CFGS                    PMCON1bits.CFGS                 // bit 6

#define RA0                     PORTAbits.RA0                   // bit 0
#define RA1                     PORTAbits.RA1                   // bit 1
#define RA2                     PORTAbits.RA2                   // bit 2
#define RA3                     PORTAbits.RA3                   // bit 3
#define RA4                     PORTAbits.RA4                   // bit 4
#define RA5                     PORTAbits.RA5                   // bit 5
#define RA6                     PORTAbits.RA6                   // bit 6
#define RA7                     PORTAbits.RA7                   // bit 7

#define RB0                     PORTBbits.RB0                   // bit 0
#define RB1                     PORTBbits.RB1                   // bit 1
#define RB2                     PORTBbits.RB2                   // bit 2
#define RB3                     PORTBbits.RB3                   // bit 3
#define RB4                     PORTBbits.RB4                   // bit 4
#define RB5                     PORTBbits.RB5                   // bit 5
#define RB6                     PORTBbits.RB6                   // bit 6
#define RB7                     PORTBbits.RB7                   // bit 7

#define RC0                     PORTCbits.RC0                   // bit 0
#define RC1                     PORTCbits.RC1                   // bit 1
#define RC2                     PORTCbits.RC2                   // bit 2
#define RC3                     PORTCbits.RC3                   // bit 3
#define RC4                     PORTCbits.RC4                   // bit 4
#define RC5                     PORTCbits.RC5                   // bit 5
#define RC6                     PORTCbits.RC6                   // bit 6
#define RC7                     PORTCbits.RC7                   // bit 7

#define RD0                     PORTDbits.RD0                   // bit 0
#define RD1                     PORTDbits.RD1                   // bit 1
#define RD2                     PORTDbits.RD2                   // bit 2
#define RD3                     PORTDbits.RD3                   // bit 3
#define RD4                     PORTDbits.RD4                   // bit 4
#define RD5                     PORTDbits.RD5                   // bit 5
#define RD6                     PORTDbits.RD6                   // bit 6
#define RD7                     PORTDbits.RD7                   // bit 7

#define RE0                     PORTEbits.RE0                   // bit 0
#define RE1                     PORTEbits.RE1                   // bit 1
#define RE2                     PORTEbits.RE2                   // bit 2
#define RE3                     PORTEbits.RE3                   // bit 3

#define PPSLOCKED               PPSLOCKbits.PPSLOCKED           // bit 0

#define PWM3POL                 PWM3CONbits.PWM3POL             // bit 4
#define PWM3OUT                 PWM3CONbits.PWM3OUT             // bit 5
#define PWM3EN                  PWM3CONbits.PWM3EN              // bit 7

#define PWM3DCH0                PWM3DCHbits.PWM3DCH0            // bit 0
#define PWM3DCH1                PWM3DCHbits.PWM3DCH1            // bit 1
#define PWM3DCH2                PWM3DCHbits.PWM3DCH2            // bit 2
#define PWM3DCH3                PWM3DCHbits.PWM3DCH3            // bit 3
#define PWM3DCH4                PWM3DCHbits.PWM3DCH4            // bit 4
#define PWM3DCH5                PWM3DCHbits.PWM3DCH5            // bit 5
#define PWM3DCH6                PWM3DCHbits.PWM3DCH6            // bit 6
#define PWM3DCH7                PWM3DCHbits.PWM3DCH7            // bit 7

#define PWM3DCL0                PWM3DCLbits.PWM3DCL0            // bit 6
#define PWM3DCL1                PWM3DCLbits.PWM3DCL1            // bit 7

#define PWM4POL                 PWM4CONbits.PWM4POL             // bit 4
#define PWM4OUT                 PWM4CONbits.PWM4OUT             // bit 5
#define PWM4EN                  PWM4CONbits.PWM4EN              // bit 7

#define PWM4DCH0                PWM4DCHbits.PWM4DCH0            // bit 0
#define PWM4DCH1                PWM4DCHbits.PWM4DCH1            // bit 1
#define PWM4DCH2                PWM4DCHbits.PWM4DCH2            // bit 2
#define PWM4DCH3                PWM4DCHbits.PWM4DCH3            // bit 3
#define PWM4DCH4                PWM4DCHbits.PWM4DCH4            // bit 4
#define PWM4DCH5                PWM4DCHbits.PWM4DCH5            // bit 5
#define PWM4DCH6                PWM4DCHbits.PWM4DCH6            // bit 6
#define PWM4DCH7                PWM4DCHbits.PWM4DCH7            // bit 7

#define PWM4DCL0                PWM4DCLbits.PWM4DCL0            // bit 6
#define PWM4DCL1                PWM4DCLbits.PWM4DCL1            // bit 7

#define RX9D                    RC1STAbits.RX9D                 // bit 0
#define OERR                    RC1STAbits.OERR                 // bit 1
#define FERR                    RC1STAbits.FERR                 // bit 2
#define ADDEN                   RC1STAbits.ADDEN                // bit 3
#define CREN                    RC1STAbits.CREN                 // bit 4
#define SREN                    RC1STAbits.SREN                 // bit 5
#define RX9                     RC1STAbits.RX9                  // bit 6
#define SPEN                    RC1STAbits.SPEN                 // bit 7

#define SLRA0                   SLRCONAbits.SLRA0               // bit 0
#define SLRA1                   SLRCONAbits.SLRA1               // bit 1
#define SLRA2                   SLRCONAbits.SLRA2               // bit 2
#define SLRA3                   SLRCONAbits.SLRA3               // bit 3
#define SLRA4                   SLRCONAbits.SLRA4               // bit 4
#define SLRA5                   SLRCONAbits.SLRA5               // bit 5
#define SLRA6                   SLRCONAbits.SLRA6               // bit 6
#define SLRA7                   SLRCONAbits.SLRA7               // bit 7

#define SLRB0                   SLRCONBbits.SLRB0               // bit 0
#define SLRB1                   SLRCONBbits.SLRB1               // bit 1
#define SLRB2                   SLRCONBbits.SLRB2               // bit 2
#define SLRB3                   SLRCONBbits.SLRB3               // bit 3
#define SLRB4                   SLRCONBbits.SLRB4               // bit 4
#define SLRB5                   SLRCONBbits.SLRB5               // bit 5
#define SLRB6                   SLRCONBbits.SLRB6               // bit 6
#define SLRB7                   SLRCONBbits.SLRB7               // bit 7

#define SLRC0                   SLRCONCbits.SLRC0               // bit 0
#define SLRC1                   SLRCONCbits.SLRC1               // bit 1
#define SLRC2                   SLRCONCbits.SLRC2               // bit 2
#define SLRC3                   SLRCONCbits.SLRC3               // bit 3
#define SLRC4                   SLRCONCbits.SLRC4               // bit 4
#define SLRC5                   SLRCONCbits.SLRC5               // bit 5
#define SLRC6                   SLRCONCbits.SLRC6               // bit 6
#define SLRC7                   SLRCONCbits.SLRC7               // bit 7

#define SLRD0                   SLRCONDbits.SLRD0               // bit 0
#define SLRD1                   SLRCONDbits.SLRD1               // bit 1
#define SLRD2                   SLRCONDbits.SLRD2               // bit 2
#define SLRD3                   SLRCONDbits.SLRD3               // bit 3
#define SLRD4                   SLRCONDbits.SLRD4               // bit 4
#define SLRD5                   SLRCONDbits.SLRD5               // bit 5
#define SLRD6                   SLRCONDbits.SLRD6               // bit 6
#define SLRD7                   SLRCONDbits.SLRD7               // bit 7

#define SLRE0                   SLRCONEbits.SLRE0               // bit 0
#define SLRE1                   SLRCONEbits.SLRE1               // bit 1
#define SLRE2                   SLRCONEbits.SLRE2               // bit 2

#define SSP1ADD0                SSP1ADDbits.SSP1ADD0            // bit 0, shadows bit in SSP1ADDbits
#define ADD0                    SSP1ADDbits.ADD0                // bit 0, shadows bit in SSP1ADDbits
#define SSP1ADD1                SSP1ADDbits.SSP1ADD1            // bit 1, shadows bit in SSP1ADDbits
#define ADD1                    SSP1ADDbits.ADD1                // bit 1, shadows bit in SSP1ADDbits
#define SSP1ADD2                SSP1ADDbits.SSP1ADD2            // bit 2, shadows bit in SSP1ADDbits
#define ADD2                    SSP1ADDbits.ADD2                // bit 2, shadows bit in SSP1ADDbits
#define SSP1ADD3                SSP1ADDbits.SSP1ADD3            // bit 3, shadows bit in SSP1ADDbits
#define ADD3                    SSP1ADDbits.ADD3                // bit 3, shadows bit in SSP1ADDbits
#define SSP1ADD4                SSP1ADDbits.SSP1ADD4            // bit 4, shadows bit in SSP1ADDbits
#define ADD4                    SSP1ADDbits.ADD4                // bit 4, shadows bit in SSP1ADDbits
#define SSP1ADD5                SSP1ADDbits.SSP1ADD5            // bit 5, shadows bit in SSP1ADDbits
#define ADD5                    SSP1ADDbits.ADD5                // bit 5, shadows bit in SSP1ADDbits
#define SSP1ADD6                SSP1ADDbits.SSP1ADD6            // bit 6, shadows bit in SSP1ADDbits
#define ADD6                    SSP1ADDbits.ADD6                // bit 6, shadows bit in SSP1ADDbits
#define SSP1ADD7                SSP1ADDbits.SSP1ADD7            // bit 7, shadows bit in SSP1ADDbits
#define ADD7                    SSP1ADDbits.ADD7                // bit 7, shadows bit in SSP1ADDbits

#define SSP1BUF0                SSP1BUFbits.SSP1BUF0            // bit 0, shadows bit in SSP1BUFbits
#define BUF0                    SSP1BUFbits.BUF0                // bit 0, shadows bit in SSP1BUFbits
#define SSP1BUF1                SSP1BUFbits.SSP1BUF1            // bit 1, shadows bit in SSP1BUFbits
#define BUF1                    SSP1BUFbits.BUF1                // bit 1, shadows bit in SSP1BUFbits
#define SSP1BUF2                SSP1BUFbits.SSP1BUF2            // bit 2, shadows bit in SSP1BUFbits
#define BUF2                    SSP1BUFbits.BUF2                // bit 2, shadows bit in SSP1BUFbits
#define SSP1BUF3                SSP1BUFbits.SSP1BUF3            // bit 3, shadows bit in SSP1BUFbits
#define BUF3                    SSP1BUFbits.BUF3                // bit 3, shadows bit in SSP1BUFbits
#define SSP1BUF4                SSP1BUFbits.SSP1BUF4            // bit 4, shadows bit in SSP1BUFbits
#define BUF4                    SSP1BUFbits.BUF4                // bit 4, shadows bit in SSP1BUFbits
#define SSP1BUF5                SSP1BUFbits.SSP1BUF5            // bit 5, shadows bit in SSP1BUFbits
#define BUF5                    SSP1BUFbits.BUF5                // bit 5, shadows bit in SSP1BUFbits
#define SSP1BUF6                SSP1BUFbits.SSP1BUF6            // bit 6, shadows bit in SSP1BUFbits
#define BUF6                    SSP1BUFbits.BUF6                // bit 6, shadows bit in SSP1BUFbits
#define SSP1BUF7                SSP1BUFbits.SSP1BUF7            // bit 7, shadows bit in SSP1BUFbits
#define BUF7                    SSP1BUFbits.BUF7                // bit 7, shadows bit in SSP1BUFbits

#define SSPM0                   SSP1CONbits.SSPM0               // bit 0
#define SSPM1                   SSP1CONbits.SSPM1               // bit 1
#define SSPM2                   SSP1CONbits.SSPM2               // bit 2
#define SSPM3                   SSP1CONbits.SSPM3               // bit 3
#define CKP                     SSP1CONbits.CKP                 // bit 4
#define SSPEN                   SSP1CONbits.SSPEN               // bit 5
#define SSPOV                   SSP1CONbits.SSPOV               // bit 6
#define WCOL                    SSP1CONbits.WCOL                // bit 7

#define SEN                     SSP1CON2bits.SEN                // bit 0
#define RSEN                    SSP1CON2bits.RSEN               // bit 1
#define PEN                     SSP1CON2bits.PEN                // bit 2
#define RCEN                    SSP1CON2bits.RCEN               // bit 3
#define ACKEN                   SSP1CON2bits.ACKEN              // bit 4
#define ACKDT                   SSP1CON2bits.ACKDT              // bit 5
#define ACKSTAT                 SSP1CON2bits.ACKSTAT            // bit 6
#define GCEN                    SSP1CON2bits.GCEN               // bit 7

#define DHEN                    SSP1CON3bits.DHEN               // bit 0
#define AHEN                    SSP1CON3bits.AHEN               // bit 1
#define SBCDE                   SSP1CON3bits.SBCDE              // bit 2
#define SDAHT                   SSP1CON3bits.SDAHT              // bit 3
#define BOEN                    SSP1CON3bits.BOEN               // bit 4
#define SCIE                    SSP1CON3bits.SCIE               // bit 5
#define PCIE                    SSP1CON3bits.PCIE               // bit 6
#define ACKTIM                  SSP1CON3bits.ACKTIM             // bit 7

#define SSP1MSK0                SSP1MSKbits.SSP1MSK0            // bit 0, shadows bit in SSP1MSKbits
#define MSK0                    SSP1MSKbits.MSK0                // bit 0, shadows bit in SSP1MSKbits
#define SSP1MSK1                SSP1MSKbits.SSP1MSK1            // bit 1, shadows bit in SSP1MSKbits
#define MSK1                    SSP1MSKbits.MSK1                // bit 1, shadows bit in SSP1MSKbits
#define SSP1MSK2                SSP1MSKbits.SSP1MSK2            // bit 2, shadows bit in SSP1MSKbits
#define MSK2                    SSP1MSKbits.MSK2                // bit 2, shadows bit in SSP1MSKbits
#define SSP1MSK3                SSP1MSKbits.SSP1MSK3            // bit 3, shadows bit in SSP1MSKbits
#define MSK3                    SSP1MSKbits.MSK3                // bit 3, shadows bit in SSP1MSKbits
#define SSP1MSK4                SSP1MSKbits.SSP1MSK4            // bit 4, shadows bit in SSP1MSKbits
#define MSK4                    SSP1MSKbits.MSK4                // bit 4, shadows bit in SSP1MSKbits
#define SSP1MSK5                SSP1MSKbits.SSP1MSK5            // bit 5, shadows bit in SSP1MSKbits
#define MSK5                    SSP1MSKbits.MSK5                // bit 5, shadows bit in SSP1MSKbits
#define SSP1MSK6                SSP1MSKbits.SSP1MSK6            // bit 6, shadows bit in SSP1MSKbits
#define MSK6                    SSP1MSKbits.MSK6                // bit 6, shadows bit in SSP1MSKbits
#define SSP1MSK7                SSP1MSKbits.SSP1MSK7            // bit 7, shadows bit in SSP1MSKbits
#define MSK7                    SSP1MSKbits.MSK7                // bit 7, shadows bit in SSP1MSKbits

#define BF                      SSP1STATbits.BF                 // bit 0
#define UA                      SSP1STATbits.UA                 // bit 1
#define R_NOT_W                 SSP1STATbits.R_NOT_W            // bit 2
#define S                       SSP1STATbits.S                  // bit 3
#define P                       SSP1STATbits.P                  // bit 4
#define D_NOT_A                 SSP1STATbits.D_NOT_A            // bit 5
#define CKE                     SSP1STATbits.CKE                // bit 6
#define SMP                     SSP1STATbits.SMP                // bit 7

#define C                       STATUSbits.C                    // bit 0
#define DC                      STATUSbits.DC                   // bit 1
#define Z                       STATUSbits.Z                    // bit 2
#define NOT_PD                  STATUSbits.NOT_PD               // bit 3
#define NOT_TO                  STATUSbits.NOT_TO               // bit 4

#define C_SHAD                  STATUS_SHADbits.C_SHAD          // bit 0
#define DC_SHAD                 STATUS_SHADbits.DC_SHAD         // bit 1
#define Z_SHAD                  STATUS_SHADbits.Z_SHAD          // bit 2

#define TMR1ON                  T1CONbits.TMR1ON                // bit 0
#define NOT_T1SYNC              T1CONbits.NOT_T1SYNC            // bit 2
#define T1OSCEN                 T1CONbits.T1OSCEN               // bit 3
#define T1CKPS0                 T1CONbits.T1CKPS0               // bit 4
#define T1CKPS1                 T1CONbits.T1CKPS1               // bit 5
#define TMR1CS0                 T1CONbits.TMR1CS0               // bit 6
#define TMR1CS1                 T1CONbits.TMR1CS1               // bit 7

#define T1GSS0                  T1GCONbits.T1GSS0               // bit 0
#define T1GSS1                  T1GCONbits.T1GSS1               // bit 1
#define T1GVAL                  T1GCONbits.T1GVAL               // bit 2
#define T1GGO_NOT_DONE          T1GCONbits.T1GGO_NOT_DONE       // bit 3
#define T1GSPM                  T1GCONbits.T1GSPM               // bit 4
#define T1GTM                   T1GCONbits.T1GTM                // bit 5
#define T1GPOL                  T1GCONbits.T1GPOL               // bit 6
#define TMR1GE                  T1GCONbits.TMR1GE               // bit 7

#define T2CKPS0                 T2CONbits.T2CKPS0               // bit 0
#define T2CKPS1                 T2CONbits.T2CKPS1               // bit 1
#define TMR2ON                  T2CONbits.TMR2ON                // bit 2
#define T2OUTPS0                T2CONbits.T2OUTPS0              // bit 3
#define T2OUTPS1                T2CONbits.T2OUTPS1              // bit 4
#define T2OUTPS2                T2CONbits.T2OUTPS2              // bit 5
#define T2OUTPS3                T2CONbits.T2OUTPS3              // bit 6

#define T4CKPS0                 T4CONbits.T4CKPS0               // bit 0
#define T4CKPS1                 T4CONbits.T4CKPS1               // bit 1
#define TMR4ON                  T4CONbits.TMR4ON                // bit 2
#define T4OUTPS0                T4CONbits.T4OUTPS0              // bit 3
#define T4OUTPS1                T4CONbits.T4OUTPS1              // bit 4
#define T4OUTPS2                T4CONbits.T4OUTPS2              // bit 5
#define T4OUTPS3                T4CONbits.T4OUTPS3              // bit 6

#define T6CKPS0                 T6CONbits.T6CKPS0               // bit 0
#define T6CKPS1                 T6CONbits.T6CKPS1               // bit 1
#define TMR6ON                  T6CONbits.TMR6ON                // bit 2
#define T6OUTPS0                T6CONbits.T6OUTPS0              // bit 3
#define T6OUTPS1                T6CONbits.T6OUTPS1              // bit 4
#define T6OUTPS2                T6CONbits.T6OUTPS2              // bit 5
#define T6OUTPS3                T6CONbits.T6OUTPS3              // bit 6

#define TRISA0                  TRISAbits.TRISA0                // bit 0
#define TRISA1                  TRISAbits.TRISA1                // bit 1
#define TRISA2                  TRISAbits.TRISA2                // bit 2
#define TRISA3                  TRISAbits.TRISA3                // bit 3
#define TRISA4                  TRISAbits.TRISA4                // bit 4
#define TRISA5                  TRISAbits.TRISA5                // bit 5
#define TRISA6                  TRISAbits.TRISA6                // bit 6
#define TRISA7                  TRISAbits.TRISA7                // bit 7

#define TRISB0                  TRISBbits.TRISB0                // bit 0
#define TRISB1                  TRISBbits.TRISB1                // bit 1
#define TRISB2                  TRISBbits.TRISB2                // bit 2
#define TRISB3                  TRISBbits.TRISB3                // bit 3
#define TRISB4                  TRISBbits.TRISB4                // bit 4
#define TRISB5                  TRISBbits.TRISB5                // bit 5
#define TRISB6                  TRISBbits.TRISB6                // bit 6
#define TRISB7                  TRISBbits.TRISB7                // bit 7

#define TRISC0                  TRISCbits.TRISC0                // bit 0
#define TRISC1                  TRISCbits.TRISC1                // bit 1
#define TRISC2                  TRISCbits.TRISC2                // bit 2
#define TRISC3                  TRISCbits.TRISC3                // bit 3
#define TRISC4                  TRISCbits.TRISC4                // bit 4
#define TRISC5                  TRISCbits.TRISC5                // bit 5
#define TRISC6                  TRISCbits.TRISC6                // bit 6
#define TRISC7                  TRISCbits.TRISC7                // bit 7

#define TRISD0                  TRISDbits.TRISD0                // bit 0
#define TRISD1                  TRISDbits.TRISD1                // bit 1
#define TRISD2                  TRISDbits.TRISD2                // bit 2
#define TRISD3                  TRISDbits.TRISD3                // bit 3
#define TRISD4                  TRISDbits.TRISD4                // bit 4
#define TRISD5                  TRISDbits.TRISD5                // bit 5
#define TRISD6                  TRISDbits.TRISD6                // bit 6
#define TRISD7                  TRISDbits.TRISD7                // bit 7

#define TRISE0                  TRISEbits.TRISE0                // bit 0
#define TRISE1                  TRISEbits.TRISE1                // bit 1
#define TRISE2                  TRISEbits.TRISE2                // bit 2
#define TRISE3                  TRISEbits.TRISE3                // bit 3

#define TX9D                    TX1STAbits.TX9D                 // bit 0
#define TRMT                    TX1STAbits.TRMT                 // bit 1
#define BRGH                    TX1STAbits.BRGH                 // bit 2
#define SENDB                   TX1STAbits.SENDB                // bit 3
#define SYNC                    TX1STAbits.SYNC                 // bit 4
#define TXEN                    TX1STAbits.TXEN                 // bit 5
#define TX9                     TX1STAbits.TX9                  // bit 6
#define CSRC                    TX1STAbits.CSRC                 // bit 7

#define Reserved                VREGCONbits.Reserved            // bit 0
#define VREGPM                  VREGCONbits.VREGPM              // bit 1

#define SWDTEN                  WDTCONbits.SWDTEN               // bit 0
#define WDTPS0                  WDTCONbits.WDTPS0               // bit 1
#define WDTPS1                  WDTCONbits.WDTPS1               // bit 2
#define WDTPS2                  WDTCONbits.WDTPS2               // bit 3
#define WDTPS3                  WDTCONbits.WDTPS3               // bit 4
#define WDTPS4                  WDTCONbits.WDTPS4               // bit 5

#define WPUA0                   WPUAbits.WPUA0                  // bit 0
#define WPUA1                   WPUAbits.WPUA1                  // bit 1
#define WPUA2                   WPUAbits.WPUA2                  // bit 2
#define WPUA3                   WPUAbits.WPUA3                  // bit 3
#define WPUA4                   WPUAbits.WPUA4                  // bit 4
#define WPUA5                   WPUAbits.WPUA5                  // bit 5
#define WPUA6                   WPUAbits.WPUA6                  // bit 6
#define WPUA7                   WPUAbits.WPUA7                  // bit 7

#define WPUB0                   WPUBbits.WPUB0                  // bit 0
#define WPUB1                   WPUBbits.WPUB1                  // bit 1
#define WPUB2                   WPUBbits.WPUB2                  // bit 2
#define WPUB3                   WPUBbits.WPUB3                  // bit 3
#define WPUB4                   WPUBbits.WPUB4                  // bit 4
#define WPUB5                   WPUBbits.WPUB5                  // bit 5
#define WPUB6                   WPUBbits.WPUB6                  // bit 6
#define WPUB7                   WPUBbits.WPUB7                  // bit 7

#define WPUC0                   WPUCbits.WPUC0                  // bit 0
#define WPUC1                   WPUCbits.WPUC1                  // bit 1
#define WPUC2                   WPUCbits.WPUC2                  // bit 2
#define WPUC3                   WPUCbits.WPUC3                  // bit 3
#define WPUC4                   WPUCbits.WPUC4                  // bit 4
#define WPUC5                   WPUCbits.WPUC5                  // bit 5
#define WPUC6                   WPUCbits.WPUC6                  // bit 6
#define WPUC7                   WPUCbits.WPUC7                  // bit 7

#define WPUD0                   WPUDbits.WPUD0                  // bit 0
#define WPUD1                   WPUDbits.WPUD1                  // bit 1
#define WPUD2                   WPUDbits.WPUD2                  // bit 2
#define WPUD3                   WPUDbits.WPUD3                  // bit 3
#define WPUD4                   WPUDbits.WPUD4                  // bit 4
#define WPUD5                   WPUDbits.WPUD5                  // bit 5
#define WPUD6                   WPUDbits.WPUD6                  // bit 6
#define WPUD7                   WPUDbits.WPUD7                  // bit 7

#define WPUE0                   WPUEbits.WPUE0                  // bit 0
#define WPUE1                   WPUEbits.WPUE1                  // bit 1
#define WPUE2                   WPUEbits.WPUE2                  // bit 2
#define WPUE3                   WPUEbits.WPUE3                  // bit 3

#define ZCD1INTN                ZCD1CONbits.ZCD1INTN            // bit 0
#define ZCD1INTP                ZCD1CONbits.ZCD1INTP            // bit 1
#define ZCD1POL                 ZCD1CONbits.ZCD1POL             // bit 4
#define ZCD1OUT                 ZCD1CONbits.ZCD1OUT             // bit 5
#define ZCD1EN                  ZCD1CONbits.ZCD1EN              // bit 7

#endif // #ifndef NO_BIT_DEFINES

#endif // #ifndef __PIC16F1717_H__
