/*-------------------------------------------------------------------------
   _ulonglong2fs.c - Floating point library in optimized assembly for 8051

   Copyright (c) 2004, Paul Stoffregen, paul@pjrc.com
                 2022, Benedikt Freisen

   This library is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2, or (at your option) any
   later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this library; see the file COPYING. If not, write to the
   Free Software Foundation, 51 Franklin Street, Fifth Floor, Boston,
   MA 02110-1301, USA.

   As a special exception, if you link this library with other files,
   some of which are compiled with SDCC, to produce an executable,
   this library does not by itself cause the resulting executable to
   be covered by the GNU General Public License. This exception does
   not however invalidate any other reasons why the executable file
   might be covered by the GNU General Public License.
-------------------------------------------------------------------------*/


#define __SDCC_FLOAT_LIB
#include <float.h>


/*
** libgcc support for software floating point.
** Copyright (C) 1991 by Pipeline Associates, Inc.  All rights reserved.
** Permission is granted to do *anything* you want with this file,
** commercial or otherwise, provided this message remains intact.  So there!
** I would appreciate receiving any updates/patches/changes that anyone
** makes, and am willing to be the repository for said changes (am I
** making a big mistake?).
**
** Pat Wood
** Pipeline Associates, Inc.
** pipeline!phw@motown.com or
** sun!pipeline!phw or
** uunet!motown!pipeline!phw
*/

/* (c)2000/2001: hacked a little by johan.knol@iduna.nl for sdcc */
/* (c)2022:      fix sdcc bug #3276 -- Benedikt Freisen */
/*               ported from ulong to ulonglong -- Benedikt Freisen */

union float_long
  {
    float f;
    long l;
  };

float __ulonglong2fs (unsigned long long a )
{
  unsigned char exp = (unsigned char)24 + (unsigned char)EXCESS;
  volatile union float_long fl;

  if (!a)
    {
      return 0.0;
    }

  if (a == 0xffffffffffffffffull)
    {
      return 18446744073709551616.0f;
    }

  while (a < HIDDEN)
    {
      a <<= 1;
      exp--;
    }

  while (a & NORM)
    {
      // we lose accuracy here
      if (a & 1)
        a += 2;
      a >>= 1;
      exp++;
    }

  a &= ~HIDDEN ;
  /* pack up and go home */
  fl.l = PACK(0,(unsigned long)exp, a);

  return (fl.f);
}
