# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.2.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""
SoapySDR API.

SoapySDR is an open-source generalized API and runtime library for interfacing
with Software Defined Radio devices. With SoapySDR, you can instantiate,
configure, and stream with an SDR device in a variety of environments.
Refer to https://github.com/pothosware/SoapySDR/wiki

This Python interface closely maps to the C/C++ one.
See https://pothosware.github.io/SoapySDR/doxygen/latest/index.html for details.

"""


import os

if os.name == 'nt' and hasattr(os, 'add_dll_directory'):
    root_dir = __file__
    for i in range(5): #limit search depth
        root_dir = os.path.dirname(root_dir)
        bin_dir = os.path.join(root_dir, 'bin')
        if os.path.exists(bin_dir):
            try: os.add_dll_directory(bin_dir)
            except Exception as ex:
                print('add_dll_directory(%s): %s'%(bin_dir, ex))
            break



from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _SoapySDR
else:
    import _SoapySDR

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


import weakref



COMPILE_ABI_VERSION = "0.8-3"
PYTHONLIB_ABI_VERSION = _SoapySDR.SOAPY_SDR_ABI_VERSION
CORELIB_ABI_VERSION = _SoapySDR.getABIVersion()

if not (COMPILE_ABI_VERSION == PYTHONLIB_ABI_VERSION == CORELIB_ABI_VERSION):
    raise Exception("""Failed ABI check.
Import script:    {0}
Python module:    {1}
SoapySDR library: {2}""".format(COMPILE_ABI_VERSION, PYTHONLIB_ABI_VERSION, CORELIB_ABI_VERSION))

class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _SoapySDR.delete_SwigPyIterator

    def value(self):
        return _SoapySDR.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _SoapySDR.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _SoapySDR.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _SoapySDR.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _SoapySDR.SwigPyIterator_equal(self, x)

    def copy(self):
        return _SoapySDR.SwigPyIterator_copy(self)

    def next(self):
        return _SoapySDR.SwigPyIterator_next(self)

    def __next__(self):
        return _SoapySDR.SwigPyIterator___next__(self)

    def previous(self):
        return _SoapySDR.SwigPyIterator_previous(self)

    def advance(self, n):
        return _SoapySDR.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _SoapySDR.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _SoapySDR.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _SoapySDR.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _SoapySDR.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _SoapySDR.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _SoapySDR.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _SoapySDR:
_SoapySDR.SwigPyIterator_swigregister(SwigPyIterator)

def KwargsFromString(markup):
    r"""
    Convert a markup string to a key-value map.
    The markup format is: "key0=value0, key1=value1"
    """
    return _SoapySDR.KwargsFromString(markup)

def KwargsToString(args):
    r"""
    Convert a key-value map to a markup string.
    The markup format is: "key0=value0, key1=value1"
    """
    return _SoapySDR.KwargsToString(args)
class Range(object):
    r"""A simple min/max numeric range pair"""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        *Overload 1:*
        Create an empty range (0.0, 0.0)

        |

        *Overload 2:*
        Create a min/max range

        |

        *Overload 3:*
        Create a min/max range
        """
        _SoapySDR.Range_swiginit(self, _SoapySDR.new_Range(*args))

    def minimum(self):
        r""" Get the range minimum"""
        return _SoapySDR.Range_minimum(self)

    def maximum(self):
        r""" Get the range maximum"""
        return _SoapySDR.Range_maximum(self)

    def step(self):
        r""" Get the range step size"""
        return _SoapySDR.Range_step(self)

    def __str__(self):
        fields = [self.minimum(), self.maximum()]
        if self.step() != 0.0: fields.append(self.step())
        return ', '.join(['%g'%f for f in fields])

    def __repr__(self):
        return self.__str__()

    __swig_destroy__ = _SoapySDR.delete_Range

# Register Range in _SoapySDR:
_SoapySDR.Range_swigregister(Range)
class ArgInfo(object):
    r"""Argument info describes a key/value argument."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r""" Default constructor"""
        _SoapySDR.ArgInfo_swiginit(self, _SoapySDR.new_ArgInfo())
    key = property(_SoapySDR.ArgInfo_key_get, _SoapySDR.ArgInfo_key_set, doc=r""" The key used to identify the argument (required)""")
    value = property(_SoapySDR.ArgInfo_value_get, _SoapySDR.ArgInfo_value_set, doc=r"""
    The default value of the argument when not specified (required)
    Numbers should use standard floating point and integer formats.
    Boolean values should be represented as "true" and  "false".
    """)
    name = property(_SoapySDR.ArgInfo_name_get, _SoapySDR.ArgInfo_name_set, doc=r""" The displayable name of the argument (optional, use key if empty)""")
    description = property(_SoapySDR.ArgInfo_description_get, _SoapySDR.ArgInfo_description_set, doc=r""" A brief description about the argument (optional)""")
    units = property(_SoapySDR.ArgInfo_units_get, _SoapySDR.ArgInfo_units_set, doc=r""" The units of the argument: dB, Hz, etc (optional)""")
    BOOL = _SoapySDR.ArgInfo_BOOL
    INT = _SoapySDR.ArgInfo_INT
    FLOAT = _SoapySDR.ArgInfo_FLOAT
    STRING = _SoapySDR.ArgInfo_STRING
    type = property(_SoapySDR.ArgInfo_type_get, _SoapySDR.ArgInfo_type_set)
    range = property(_SoapySDR.ArgInfo_range_get, _SoapySDR.ArgInfo_range_set, doc=r"""
    The range of possible numeric values (optional)
    When specified, the argument should be restricted to this range.
    The range is only applicable to numeric argument types.
    """)
    options = property(_SoapySDR.ArgInfo_options_get, _SoapySDR.ArgInfo_options_set, doc=r"""
    A discrete list of possible values (optional)
    When specified, the argument should be restricted to this options set.
    """)
    optionNames = property(_SoapySDR.ArgInfo_optionNames_get, _SoapySDR.ArgInfo_optionNames_set, doc=r"""
    A discrete list of displayable names for the enumerated options (optional)
    When not specified, the option value itself can be used as a display name.
    """)
    __swig_destroy__ = _SoapySDR.delete_ArgInfo

# Register ArgInfo in _SoapySDR:
_SoapySDR.ArgInfo_swigregister(ArgInfo)
class SoapySDRUnsignedList(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        return _SoapySDR.SoapySDRUnsignedList_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _SoapySDR.SoapySDRUnsignedList___nonzero__(self)

    def __bool__(self):
        return _SoapySDR.SoapySDRUnsignedList___bool__(self)

    def __len__(self):
        return _SoapySDR.SoapySDRUnsignedList___len__(self)

    def __getslice__(self, i, j):
        return _SoapySDR.SoapySDRUnsignedList___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _SoapySDR.SoapySDRUnsignedList___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _SoapySDR.SoapySDRUnsignedList___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _SoapySDR.SoapySDRUnsignedList___delitem__(self, *args)

    def __getitem__(self, *args):
        return _SoapySDR.SoapySDRUnsignedList___getitem__(self, *args)

    def __setitem__(self, *args):
        return _SoapySDR.SoapySDRUnsignedList___setitem__(self, *args)

    def pop(self):
        return _SoapySDR.SoapySDRUnsignedList_pop(self)

    def append(self, x):
        return _SoapySDR.SoapySDRUnsignedList_append(self, x)

    def empty(self):
        return _SoapySDR.SoapySDRUnsignedList_empty(self)

    def size(self):
        return _SoapySDR.SoapySDRUnsignedList_size(self)

    def swap(self, v):
        return _SoapySDR.SoapySDRUnsignedList_swap(self, v)

    def begin(self):
        return _SoapySDR.SoapySDRUnsignedList_begin(self)

    def end(self):
        return _SoapySDR.SoapySDRUnsignedList_end(self)

    def rbegin(self):
        return _SoapySDR.SoapySDRUnsignedList_rbegin(self)

    def rend(self):
        return _SoapySDR.SoapySDRUnsignedList_rend(self)

    def clear(self):
        return _SoapySDR.SoapySDRUnsignedList_clear(self)

    def get_allocator(self):
        return _SoapySDR.SoapySDRUnsignedList_get_allocator(self)

    def pop_back(self):
        return _SoapySDR.SoapySDRUnsignedList_pop_back(self)

    def erase(self, *args):
        return _SoapySDR.SoapySDRUnsignedList_erase(self, *args)

    def __init__(self, *args):
        _SoapySDR.SoapySDRUnsignedList_swiginit(self, _SoapySDR.new_SoapySDRUnsignedList(*args))

    def push_back(self, x):
        return _SoapySDR.SoapySDRUnsignedList_push_back(self, x)

    def front(self):
        return _SoapySDR.SoapySDRUnsignedList_front(self)

    def back(self):
        return _SoapySDR.SoapySDRUnsignedList_back(self)

    def assign(self, n, x):
        return _SoapySDR.SoapySDRUnsignedList_assign(self, n, x)

    def resize(self, *args):
        return _SoapySDR.SoapySDRUnsignedList_resize(self, *args)

    def insert(self, *args):
        return _SoapySDR.SoapySDRUnsignedList_insert(self, *args)

    def reserve(self, n):
        return _SoapySDR.SoapySDRUnsignedList_reserve(self, n)

    def capacity(self):
        return _SoapySDR.SoapySDRUnsignedList_capacity(self)
    __swig_destroy__ = _SoapySDR.delete_SoapySDRUnsignedList

# Register SoapySDRUnsignedList in _SoapySDR:
_SoapySDR.SoapySDRUnsignedList_swigregister(SoapySDRUnsignedList)
class SoapySDRKwargs(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        return _SoapySDR.SoapySDRKwargs_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _SoapySDR.SoapySDRKwargs___nonzero__(self)

    def __bool__(self):
        return _SoapySDR.SoapySDRKwargs___bool__(self)

    def __len__(self):
        return _SoapySDR.SoapySDRKwargs___len__(self)
    def __iter__(self):
        return self.key_iterator()
    def iterkeys(self):
        return self.key_iterator()
    def itervalues(self):
        return self.value_iterator()
    def iteritems(self):
        return self.iterator()

    def __getitem__(self, key):
        return _SoapySDR.SoapySDRKwargs___getitem__(self, key)

    def __delitem__(self, key):
        return _SoapySDR.SoapySDRKwargs___delitem__(self, key)

    def has_key(self, key):
        return _SoapySDR.SoapySDRKwargs_has_key(self, key)

    def keys(self):
        return _SoapySDR.SoapySDRKwargs_keys(self)

    def values(self):
        return _SoapySDR.SoapySDRKwargs_values(self)

    def items(self):
        return _SoapySDR.SoapySDRKwargs_items(self)

    def __contains__(self, key):
        return _SoapySDR.SoapySDRKwargs___contains__(self, key)

    def key_iterator(self):
        return _SoapySDR.SoapySDRKwargs_key_iterator(self)

    def value_iterator(self):
        return _SoapySDR.SoapySDRKwargs_value_iterator(self)

    def __setitem__(self, *args):
        return _SoapySDR.SoapySDRKwargs___setitem__(self, *args)

    def asdict(self):
        return _SoapySDR.SoapySDRKwargs_asdict(self)

    def __init__(self, *args):
        _SoapySDR.SoapySDRKwargs_swiginit(self, _SoapySDR.new_SoapySDRKwargs(*args))

    def empty(self):
        return _SoapySDR.SoapySDRKwargs_empty(self)

    def size(self):
        return _SoapySDR.SoapySDRKwargs_size(self)

    def swap(self, v):
        return _SoapySDR.SoapySDRKwargs_swap(self, v)

    def begin(self):
        return _SoapySDR.SoapySDRKwargs_begin(self)

    def end(self):
        return _SoapySDR.SoapySDRKwargs_end(self)

    def rbegin(self):
        return _SoapySDR.SoapySDRKwargs_rbegin(self)

    def rend(self):
        return _SoapySDR.SoapySDRKwargs_rend(self)

    def clear(self):
        return _SoapySDR.SoapySDRKwargs_clear(self)

    def get_allocator(self):
        return _SoapySDR.SoapySDRKwargs_get_allocator(self)

    def count(self, x):
        return _SoapySDR.SoapySDRKwargs_count(self, x)

    def erase(self, *args):
        return _SoapySDR.SoapySDRKwargs_erase(self, *args)

    def find(self, x):
        return _SoapySDR.SoapySDRKwargs_find(self, x)

    def lower_bound(self, x):
        return _SoapySDR.SoapySDRKwargs_lower_bound(self, x)

    def upper_bound(self, x):
        return _SoapySDR.SoapySDRKwargs_upper_bound(self, x)

    def __str__(self):
        out = list()
        for k, v in self.iteritems():
            out.append("%s=%s"%(k, v))
        return '{'+(', '.join(out))+'}'

    def __repr__(self):
        return self.__str__()

    __swig_destroy__ = _SoapySDR.delete_SoapySDRKwargs

# Register SoapySDRKwargs in _SoapySDR:
_SoapySDR.SoapySDRKwargs_swigregister(SoapySDRKwargs)
class SoapySDRKwargsList(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        return _SoapySDR.SoapySDRKwargsList_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _SoapySDR.SoapySDRKwargsList___nonzero__(self)

    def __bool__(self):
        return _SoapySDR.SoapySDRKwargsList___bool__(self)

    def __len__(self):
        return _SoapySDR.SoapySDRKwargsList___len__(self)

    def __getslice__(self, i, j):
        return _SoapySDR.SoapySDRKwargsList___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _SoapySDR.SoapySDRKwargsList___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _SoapySDR.SoapySDRKwargsList___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _SoapySDR.SoapySDRKwargsList___delitem__(self, *args)

    def __getitem__(self, *args):
        return _SoapySDR.SoapySDRKwargsList___getitem__(self, *args)

    def __setitem__(self, *args):
        return _SoapySDR.SoapySDRKwargsList___setitem__(self, *args)

    def pop(self):
        return _SoapySDR.SoapySDRKwargsList_pop(self)

    def append(self, x):
        return _SoapySDR.SoapySDRKwargsList_append(self, x)

    def empty(self):
        return _SoapySDR.SoapySDRKwargsList_empty(self)

    def size(self):
        return _SoapySDR.SoapySDRKwargsList_size(self)

    def swap(self, v):
        return _SoapySDR.SoapySDRKwargsList_swap(self, v)

    def begin(self):
        return _SoapySDR.SoapySDRKwargsList_begin(self)

    def end(self):
        return _SoapySDR.SoapySDRKwargsList_end(self)

    def rbegin(self):
        return _SoapySDR.SoapySDRKwargsList_rbegin(self)

    def rend(self):
        return _SoapySDR.SoapySDRKwargsList_rend(self)

    def clear(self):
        return _SoapySDR.SoapySDRKwargsList_clear(self)

    def get_allocator(self):
        return _SoapySDR.SoapySDRKwargsList_get_allocator(self)

    def pop_back(self):
        return _SoapySDR.SoapySDRKwargsList_pop_back(self)

    def erase(self, *args):
        return _SoapySDR.SoapySDRKwargsList_erase(self, *args)

    def __init__(self, *args):
        _SoapySDR.SoapySDRKwargsList_swiginit(self, _SoapySDR.new_SoapySDRKwargsList(*args))

    def push_back(self, x):
        return _SoapySDR.SoapySDRKwargsList_push_back(self, x)

    def front(self):
        return _SoapySDR.SoapySDRKwargsList_front(self)

    def back(self):
        return _SoapySDR.SoapySDRKwargsList_back(self)

    def assign(self, n, x):
        return _SoapySDR.SoapySDRKwargsList_assign(self, n, x)

    def resize(self, *args):
        return _SoapySDR.SoapySDRKwargsList_resize(self, *args)

    def insert(self, *args):
        return _SoapySDR.SoapySDRKwargsList_insert(self, *args)

    def reserve(self, n):
        return _SoapySDR.SoapySDRKwargsList_reserve(self, n)

    def capacity(self):
        return _SoapySDR.SoapySDRKwargsList_capacity(self)
    __swig_destroy__ = _SoapySDR.delete_SoapySDRKwargsList

# Register SoapySDRKwargsList in _SoapySDR:
_SoapySDR.SoapySDRKwargsList_swigregister(SoapySDRKwargsList)
class SoapySDRArgInfoList(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        return _SoapySDR.SoapySDRArgInfoList_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _SoapySDR.SoapySDRArgInfoList___nonzero__(self)

    def __bool__(self):
        return _SoapySDR.SoapySDRArgInfoList___bool__(self)

    def __len__(self):
        return _SoapySDR.SoapySDRArgInfoList___len__(self)

    def __getslice__(self, i, j):
        return _SoapySDR.SoapySDRArgInfoList___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _SoapySDR.SoapySDRArgInfoList___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _SoapySDR.SoapySDRArgInfoList___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _SoapySDR.SoapySDRArgInfoList___delitem__(self, *args)

    def __getitem__(self, *args):
        return _SoapySDR.SoapySDRArgInfoList___getitem__(self, *args)

    def __setitem__(self, *args):
        return _SoapySDR.SoapySDRArgInfoList___setitem__(self, *args)

    def pop(self):
        return _SoapySDR.SoapySDRArgInfoList_pop(self)

    def append(self, x):
        return _SoapySDR.SoapySDRArgInfoList_append(self, x)

    def empty(self):
        return _SoapySDR.SoapySDRArgInfoList_empty(self)

    def size(self):
        return _SoapySDR.SoapySDRArgInfoList_size(self)

    def swap(self, v):
        return _SoapySDR.SoapySDRArgInfoList_swap(self, v)

    def begin(self):
        return _SoapySDR.SoapySDRArgInfoList_begin(self)

    def end(self):
        return _SoapySDR.SoapySDRArgInfoList_end(self)

    def rbegin(self):
        return _SoapySDR.SoapySDRArgInfoList_rbegin(self)

    def rend(self):
        return _SoapySDR.SoapySDRArgInfoList_rend(self)

    def clear(self):
        return _SoapySDR.SoapySDRArgInfoList_clear(self)

    def get_allocator(self):
        return _SoapySDR.SoapySDRArgInfoList_get_allocator(self)

    def pop_back(self):
        return _SoapySDR.SoapySDRArgInfoList_pop_back(self)

    def erase(self, *args):
        return _SoapySDR.SoapySDRArgInfoList_erase(self, *args)

    def __init__(self, *args):
        _SoapySDR.SoapySDRArgInfoList_swiginit(self, _SoapySDR.new_SoapySDRArgInfoList(*args))

    def push_back(self, x):
        return _SoapySDR.SoapySDRArgInfoList_push_back(self, x)

    def front(self):
        return _SoapySDR.SoapySDRArgInfoList_front(self)

    def back(self):
        return _SoapySDR.SoapySDRArgInfoList_back(self)

    def assign(self, n, x):
        return _SoapySDR.SoapySDRArgInfoList_assign(self, n, x)

    def resize(self, *args):
        return _SoapySDR.SoapySDRArgInfoList_resize(self, *args)

    def insert(self, *args):
        return _SoapySDR.SoapySDRArgInfoList_insert(self, *args)

    def reserve(self, n):
        return _SoapySDR.SoapySDRArgInfoList_reserve(self, n)

    def capacity(self):
        return _SoapySDR.SoapySDRArgInfoList_capacity(self)
    __swig_destroy__ = _SoapySDR.delete_SoapySDRArgInfoList

# Register SoapySDRArgInfoList in _SoapySDR:
_SoapySDR.SoapySDRArgInfoList_swigregister(SoapySDRArgInfoList)
class SoapySDRStringList(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        return _SoapySDR.SoapySDRStringList_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _SoapySDR.SoapySDRStringList___nonzero__(self)

    def __bool__(self):
        return _SoapySDR.SoapySDRStringList___bool__(self)

    def __len__(self):
        return _SoapySDR.SoapySDRStringList___len__(self)

    def __getslice__(self, i, j):
        return _SoapySDR.SoapySDRStringList___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _SoapySDR.SoapySDRStringList___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _SoapySDR.SoapySDRStringList___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _SoapySDR.SoapySDRStringList___delitem__(self, *args)

    def __getitem__(self, *args):
        return _SoapySDR.SoapySDRStringList___getitem__(self, *args)

    def __setitem__(self, *args):
        return _SoapySDR.SoapySDRStringList___setitem__(self, *args)

    def pop(self):
        return _SoapySDR.SoapySDRStringList_pop(self)

    def append(self, x):
        return _SoapySDR.SoapySDRStringList_append(self, x)

    def empty(self):
        return _SoapySDR.SoapySDRStringList_empty(self)

    def size(self):
        return _SoapySDR.SoapySDRStringList_size(self)

    def swap(self, v):
        return _SoapySDR.SoapySDRStringList_swap(self, v)

    def begin(self):
        return _SoapySDR.SoapySDRStringList_begin(self)

    def end(self):
        return _SoapySDR.SoapySDRStringList_end(self)

    def rbegin(self):
        return _SoapySDR.SoapySDRStringList_rbegin(self)

    def rend(self):
        return _SoapySDR.SoapySDRStringList_rend(self)

    def clear(self):
        return _SoapySDR.SoapySDRStringList_clear(self)

    def get_allocator(self):
        return _SoapySDR.SoapySDRStringList_get_allocator(self)

    def pop_back(self):
        return _SoapySDR.SoapySDRStringList_pop_back(self)

    def erase(self, *args):
        return _SoapySDR.SoapySDRStringList_erase(self, *args)

    def __init__(self, *args):
        _SoapySDR.SoapySDRStringList_swiginit(self, _SoapySDR.new_SoapySDRStringList(*args))

    def push_back(self, x):
        return _SoapySDR.SoapySDRStringList_push_back(self, x)

    def front(self):
        return _SoapySDR.SoapySDRStringList_front(self)

    def back(self):
        return _SoapySDR.SoapySDRStringList_back(self)

    def assign(self, n, x):
        return _SoapySDR.SoapySDRStringList_assign(self, n, x)

    def resize(self, *args):
        return _SoapySDR.SoapySDRStringList_resize(self, *args)

    def insert(self, *args):
        return _SoapySDR.SoapySDRStringList_insert(self, *args)

    def reserve(self, n):
        return _SoapySDR.SoapySDRStringList_reserve(self, n)

    def capacity(self):
        return _SoapySDR.SoapySDRStringList_capacity(self)
    __swig_destroy__ = _SoapySDR.delete_SoapySDRStringList

# Register SoapySDRStringList in _SoapySDR:
_SoapySDR.SoapySDRStringList_swigregister(SoapySDRStringList)
class SoapySDRRangeList(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        return _SoapySDR.SoapySDRRangeList_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _SoapySDR.SoapySDRRangeList___nonzero__(self)

    def __bool__(self):
        return _SoapySDR.SoapySDRRangeList___bool__(self)

    def __len__(self):
        return _SoapySDR.SoapySDRRangeList___len__(self)

    def __getslice__(self, i, j):
        return _SoapySDR.SoapySDRRangeList___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _SoapySDR.SoapySDRRangeList___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _SoapySDR.SoapySDRRangeList___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _SoapySDR.SoapySDRRangeList___delitem__(self, *args)

    def __getitem__(self, *args):
        return _SoapySDR.SoapySDRRangeList___getitem__(self, *args)

    def __setitem__(self, *args):
        return _SoapySDR.SoapySDRRangeList___setitem__(self, *args)

    def pop(self):
        return _SoapySDR.SoapySDRRangeList_pop(self)

    def append(self, x):
        return _SoapySDR.SoapySDRRangeList_append(self, x)

    def empty(self):
        return _SoapySDR.SoapySDRRangeList_empty(self)

    def size(self):
        return _SoapySDR.SoapySDRRangeList_size(self)

    def swap(self, v):
        return _SoapySDR.SoapySDRRangeList_swap(self, v)

    def begin(self):
        return _SoapySDR.SoapySDRRangeList_begin(self)

    def end(self):
        return _SoapySDR.SoapySDRRangeList_end(self)

    def rbegin(self):
        return _SoapySDR.SoapySDRRangeList_rbegin(self)

    def rend(self):
        return _SoapySDR.SoapySDRRangeList_rend(self)

    def clear(self):
        return _SoapySDR.SoapySDRRangeList_clear(self)

    def get_allocator(self):
        return _SoapySDR.SoapySDRRangeList_get_allocator(self)

    def pop_back(self):
        return _SoapySDR.SoapySDRRangeList_pop_back(self)

    def erase(self, *args):
        return _SoapySDR.SoapySDRRangeList_erase(self, *args)

    def __init__(self, *args):
        _SoapySDR.SoapySDRRangeList_swiginit(self, _SoapySDR.new_SoapySDRRangeList(*args))

    def push_back(self, x):
        return _SoapySDR.SoapySDRRangeList_push_back(self, x)

    def front(self):
        return _SoapySDR.SoapySDRRangeList_front(self)

    def back(self):
        return _SoapySDR.SoapySDRRangeList_back(self)

    def assign(self, n, x):
        return _SoapySDR.SoapySDRRangeList_assign(self, n, x)

    def resize(self, *args):
        return _SoapySDR.SoapySDRRangeList_resize(self, *args)

    def insert(self, *args):
        return _SoapySDR.SoapySDRRangeList_insert(self, *args)

    def reserve(self, n):
        return _SoapySDR.SoapySDRRangeList_reserve(self, n)

    def capacity(self):
        return _SoapySDR.SoapySDRRangeList_capacity(self)
    __swig_destroy__ = _SoapySDR.delete_SoapySDRRangeList

# Register SoapySDRRangeList in _SoapySDR:
_SoapySDR.SoapySDRRangeList_swigregister(SoapySDRRangeList)
class SoapySDRSizeList(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        return _SoapySDR.SoapySDRSizeList_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _SoapySDR.SoapySDRSizeList___nonzero__(self)

    def __bool__(self):
        return _SoapySDR.SoapySDRSizeList___bool__(self)

    def __len__(self):
        return _SoapySDR.SoapySDRSizeList___len__(self)

    def __getslice__(self, i, j):
        return _SoapySDR.SoapySDRSizeList___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _SoapySDR.SoapySDRSizeList___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _SoapySDR.SoapySDRSizeList___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _SoapySDR.SoapySDRSizeList___delitem__(self, *args)

    def __getitem__(self, *args):
        return _SoapySDR.SoapySDRSizeList___getitem__(self, *args)

    def __setitem__(self, *args):
        return _SoapySDR.SoapySDRSizeList___setitem__(self, *args)

    def pop(self):
        return _SoapySDR.SoapySDRSizeList_pop(self)

    def append(self, x):
        return _SoapySDR.SoapySDRSizeList_append(self, x)

    def empty(self):
        return _SoapySDR.SoapySDRSizeList_empty(self)

    def size(self):
        return _SoapySDR.SoapySDRSizeList_size(self)

    def swap(self, v):
        return _SoapySDR.SoapySDRSizeList_swap(self, v)

    def begin(self):
        return _SoapySDR.SoapySDRSizeList_begin(self)

    def end(self):
        return _SoapySDR.SoapySDRSizeList_end(self)

    def rbegin(self):
        return _SoapySDR.SoapySDRSizeList_rbegin(self)

    def rend(self):
        return _SoapySDR.SoapySDRSizeList_rend(self)

    def clear(self):
        return _SoapySDR.SoapySDRSizeList_clear(self)

    def get_allocator(self):
        return _SoapySDR.SoapySDRSizeList_get_allocator(self)

    def pop_back(self):
        return _SoapySDR.SoapySDRSizeList_pop_back(self)

    def erase(self, *args):
        return _SoapySDR.SoapySDRSizeList_erase(self, *args)

    def __init__(self, *args):
        _SoapySDR.SoapySDRSizeList_swiginit(self, _SoapySDR.new_SoapySDRSizeList(*args))

    def push_back(self, x):
        return _SoapySDR.SoapySDRSizeList_push_back(self, x)

    def front(self):
        return _SoapySDR.SoapySDRSizeList_front(self)

    def back(self):
        return _SoapySDR.SoapySDRSizeList_back(self)

    def assign(self, n, x):
        return _SoapySDR.SoapySDRSizeList_assign(self, n, x)

    def resize(self, *args):
        return _SoapySDR.SoapySDRSizeList_resize(self, *args)

    def insert(self, *args):
        return _SoapySDR.SoapySDRSizeList_insert(self, *args)

    def reserve(self, n):
        return _SoapySDR.SoapySDRSizeList_reserve(self, n)

    def capacity(self):
        return _SoapySDR.SoapySDRSizeList_capacity(self)
    __swig_destroy__ = _SoapySDR.delete_SoapySDRSizeList

# Register SoapySDRSizeList in _SoapySDR:
_SoapySDR.SoapySDRSizeList_swigregister(SoapySDRSizeList)
class SoapySDRDoubleList(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        return _SoapySDR.SoapySDRDoubleList_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _SoapySDR.SoapySDRDoubleList___nonzero__(self)

    def __bool__(self):
        return _SoapySDR.SoapySDRDoubleList___bool__(self)

    def __len__(self):
        return _SoapySDR.SoapySDRDoubleList___len__(self)

    def __getslice__(self, i, j):
        return _SoapySDR.SoapySDRDoubleList___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _SoapySDR.SoapySDRDoubleList___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _SoapySDR.SoapySDRDoubleList___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _SoapySDR.SoapySDRDoubleList___delitem__(self, *args)

    def __getitem__(self, *args):
        return _SoapySDR.SoapySDRDoubleList___getitem__(self, *args)

    def __setitem__(self, *args):
        return _SoapySDR.SoapySDRDoubleList___setitem__(self, *args)

    def pop(self):
        return _SoapySDR.SoapySDRDoubleList_pop(self)

    def append(self, x):
        return _SoapySDR.SoapySDRDoubleList_append(self, x)

    def empty(self):
        return _SoapySDR.SoapySDRDoubleList_empty(self)

    def size(self):
        return _SoapySDR.SoapySDRDoubleList_size(self)

    def swap(self, v):
        return _SoapySDR.SoapySDRDoubleList_swap(self, v)

    def begin(self):
        return _SoapySDR.SoapySDRDoubleList_begin(self)

    def end(self):
        return _SoapySDR.SoapySDRDoubleList_end(self)

    def rbegin(self):
        return _SoapySDR.SoapySDRDoubleList_rbegin(self)

    def rend(self):
        return _SoapySDR.SoapySDRDoubleList_rend(self)

    def clear(self):
        return _SoapySDR.SoapySDRDoubleList_clear(self)

    def get_allocator(self):
        return _SoapySDR.SoapySDRDoubleList_get_allocator(self)

    def pop_back(self):
        return _SoapySDR.SoapySDRDoubleList_pop_back(self)

    def erase(self, *args):
        return _SoapySDR.SoapySDRDoubleList_erase(self, *args)

    def __init__(self, *args):
        _SoapySDR.SoapySDRDoubleList_swiginit(self, _SoapySDR.new_SoapySDRDoubleList(*args))

    def push_back(self, x):
        return _SoapySDR.SoapySDRDoubleList_push_back(self, x)

    def front(self):
        return _SoapySDR.SoapySDRDoubleList_front(self)

    def back(self):
        return _SoapySDR.SoapySDRDoubleList_back(self)

    def assign(self, n, x):
        return _SoapySDR.SoapySDRDoubleList_assign(self, n, x)

    def resize(self, *args):
        return _SoapySDR.SoapySDRDoubleList_resize(self, *args)

    def insert(self, *args):
        return _SoapySDR.SoapySDRDoubleList_insert(self, *args)

    def reserve(self, n):
        return _SoapySDR.SoapySDRDoubleList_reserve(self, n)

    def capacity(self):
        return _SoapySDR.SoapySDRDoubleList_capacity(self)
    __swig_destroy__ = _SoapySDR.delete_SoapySDRDoubleList

# Register SoapySDRDoubleList in _SoapySDR:
_SoapySDR.SoapySDRDoubleList_swigregister(SoapySDRDoubleList)
class SoapySDRDeviceList(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        return _SoapySDR.SoapySDRDeviceList_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _SoapySDR.SoapySDRDeviceList___nonzero__(self)

    def __bool__(self):
        return _SoapySDR.SoapySDRDeviceList___bool__(self)

    def __len__(self):
        return _SoapySDR.SoapySDRDeviceList___len__(self)

    def __getslice__(self, i, j):
        return _SoapySDR.SoapySDRDeviceList___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _SoapySDR.SoapySDRDeviceList___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _SoapySDR.SoapySDRDeviceList___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _SoapySDR.SoapySDRDeviceList___delitem__(self, *args)

    def __getitem__(self, *args):
        return _SoapySDR.SoapySDRDeviceList___getitem__(self, *args)

    def __setitem__(self, *args):
        return _SoapySDR.SoapySDRDeviceList___setitem__(self, *args)

    def pop(self):
        return _SoapySDR.SoapySDRDeviceList_pop(self)

    def append(self, x):
        return _SoapySDR.SoapySDRDeviceList_append(self, x)

    def empty(self):
        return _SoapySDR.SoapySDRDeviceList_empty(self)

    def size(self):
        return _SoapySDR.SoapySDRDeviceList_size(self)

    def swap(self, v):
        return _SoapySDR.SoapySDRDeviceList_swap(self, v)

    def begin(self):
        return _SoapySDR.SoapySDRDeviceList_begin(self)

    def end(self):
        return _SoapySDR.SoapySDRDeviceList_end(self)

    def rbegin(self):
        return _SoapySDR.SoapySDRDeviceList_rbegin(self)

    def rend(self):
        return _SoapySDR.SoapySDRDeviceList_rend(self)

    def clear(self):
        return _SoapySDR.SoapySDRDeviceList_clear(self)

    def get_allocator(self):
        return _SoapySDR.SoapySDRDeviceList_get_allocator(self)

    def pop_back(self):
        return _SoapySDR.SoapySDRDeviceList_pop_back(self)

    def erase(self, *args):
        return _SoapySDR.SoapySDRDeviceList_erase(self, *args)

    def __init__(self, *args):
        _SoapySDR.SoapySDRDeviceList_swiginit(self, _SoapySDR.new_SoapySDRDeviceList(*args))

    def push_back(self, x):
        return _SoapySDR.SoapySDRDeviceList_push_back(self, x)

    def front(self):
        return _SoapySDR.SoapySDRDeviceList_front(self)

    def back(self):
        return _SoapySDR.SoapySDRDeviceList_back(self)

    def assign(self, n, x):
        return _SoapySDR.SoapySDRDeviceList_assign(self, n, x)

    def resize(self, *args):
        return _SoapySDR.SoapySDRDeviceList_resize(self, *args)

    def insert(self, *args):
        return _SoapySDR.SoapySDRDeviceList_insert(self, *args)

    def reserve(self, n):
        return _SoapySDR.SoapySDRDeviceList_reserve(self, n)

    def capacity(self):
        return _SoapySDR.SoapySDRDeviceList_capacity(self)
    __swig_destroy__ = _SoapySDR.delete_SoapySDRDeviceList

# Register SoapySDRDeviceList in _SoapySDR:
_SoapySDR.SoapySDRDeviceList_swigregister(SoapySDRDeviceList)
class StreamResult(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        _SoapySDR.StreamResult_swiginit(self, _SoapySDR.new_StreamResult())
    ret = property(_SoapySDR.StreamResult_ret_get, _SoapySDR.StreamResult_ret_set)
    flags = property(_SoapySDR.StreamResult_flags_get, _SoapySDR.StreamResult_flags_set)
    timeNs = property(_SoapySDR.StreamResult_timeNs_get, _SoapySDR.StreamResult_timeNs_set)
    chanMask = property(_SoapySDR.StreamResult_chanMask_get, _SoapySDR.StreamResult_chanMask_set)

    def __str__(self):
        return "ret=%s, flags=%s, timeNs=%s"%(self.ret, self.flags, self.timeNs)

    def __repr__(self):
        return self.__str__()

    __swig_destroy__ = _SoapySDR.delete_StreamResult

# Register StreamResult in _SoapySDR:
_SoapySDR.StreamResult_swigregister(StreamResult)
class NativeStreamFormat(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    format = property(_SoapySDR.NativeStreamFormat_format_get, _SoapySDR.NativeStreamFormat_format_set)
    fullScale = property(_SoapySDR.NativeStreamFormat_fullScale_get, _SoapySDR.NativeStreamFormat_fullScale_set)

    def __str__(self):
        return "format=%s, fullScale=%f"%(self.format, self.fullScale)

    def __repr__(self):
        return self.__str__()


    def __init__(self):
        _SoapySDR.NativeStreamFormat_swiginit(self, _SoapySDR.new_NativeStreamFormat())
    __swig_destroy__ = _SoapySDR.delete_NativeStreamFormat

# Register NativeStreamFormat in _SoapySDR:
_SoapySDR.NativeStreamFormat_swigregister(NativeStreamFormat)
SOAPY_SDR_TX = _SoapySDR.SOAPY_SDR_TX
r"""
     Constants used in the device API.

     Copyright: 
     Copyright (c) 2014-2016 Josh Blum
     SPDX-License-Identifier: BSL-1.0

    Constant to represent the transmit direction
    """
SOAPY_SDR_RX = _SoapySDR.SOAPY_SDR_RX
r"""Constant to represent the receive direction"""
SOAPY_SDR_END_BURST = _SoapySDR.SOAPY_SDR_END_BURST
r"""
    Indicate end of burst for transmit or receive.
    For write, end of burst if set by the caller.
    For read, end of burst is set by the driver.
    """
SOAPY_SDR_HAS_TIME = _SoapySDR.SOAPY_SDR_HAS_TIME
r"""
    Indicates that the time stamp is valid.
    For write, the caller must set has time when timeNs is provided.
    For read, the driver sets has time when timeNs is provided.
    """
SOAPY_SDR_END_ABRUPT = _SoapySDR.SOAPY_SDR_END_ABRUPT
r"""
    Indicates that stream terminated prematurely.
    This is the flag version of an overflow error
    that indicates an overflow with the end samples.
    """
SOAPY_SDR_ONE_PACKET = _SoapySDR.SOAPY_SDR_ONE_PACKET
r"""
    Indicates transmit or receive only a single packet.
    Applicable when the driver fragments samples into packets.
    For write, the user sets this flag to only send a single packet.
    For read, the user sets this flag to only receive a single packet.
    """
SOAPY_SDR_MORE_FRAGMENTS = _SoapySDR.SOAPY_SDR_MORE_FRAGMENTS
r"""
    Indicate that this read call and the next results in a fragment.
    Used when the implementation has an underlying packet interface.
    The caller can use this indicator and the SOAPY_SDR_ONE_PACKET flag
    on subsequent read stream calls to re-align with packet boundaries.
    """
SOAPY_SDR_WAIT_TRIGGER = _SoapySDR.SOAPY_SDR_WAIT_TRIGGER
r"""
    Indicate that the stream should wait for an external trigger event.
    This flag might be used with the flags argument in any of the
    stream API calls. The trigger implementation is hardware-specific.
    """
SOAPY_SDR_USER_FLAG0 = _SoapySDR.SOAPY_SDR_USER_FLAG0
r"""A flag that can be used for SDR specific data."""
SOAPY_SDR_USER_FLAG1 = _SoapySDR.SOAPY_SDR_USER_FLAG1
r"""A flag that can be used for SDR specific data."""
SOAPY_SDR_USER_FLAG2 = _SoapySDR.SOAPY_SDR_USER_FLAG2
r"""A flag that can be used for SDR specific data."""
SOAPY_SDR_USER_FLAG3 = _SoapySDR.SOAPY_SDR_USER_FLAG3
r"""A flag that can be used for SDR specific data."""
SOAPY_SDR_USER_FLAG4 = _SoapySDR.SOAPY_SDR_USER_FLAG4
r"""A flag that can be used for SDR specific data."""
SOAPY_SDR_TRUE = _SoapySDR.SOAPY_SDR_TRUE
r""" String definition for boolean true used in settings"""
SOAPY_SDR_FALSE = _SoapySDR.SOAPY_SDR_FALSE
r""" String definition for boolean false used in settings"""
SOAPY_SDR_TIMEOUT = _SoapySDR.SOAPY_SDR_TIMEOUT
r"""Returned when read has a timeout."""
SOAPY_SDR_STREAM_ERROR = _SoapySDR.SOAPY_SDR_STREAM_ERROR
r"""Returned for non-specific stream errors."""
SOAPY_SDR_CORRUPTION = _SoapySDR.SOAPY_SDR_CORRUPTION
r"""
    Returned when read has data corruption.
    For example, the driver saw a malformed packet.
    """
SOAPY_SDR_OVERFLOW = _SoapySDR.SOAPY_SDR_OVERFLOW
r"""
    Returned when read has an overflow condition.
    For example, and internal buffer has filled.
    """
SOAPY_SDR_NOT_SUPPORTED = _SoapySDR.SOAPY_SDR_NOT_SUPPORTED
r"""
    Returned when a requested operation or flag setting
    is not supported by the underlying implementation.
    """
SOAPY_SDR_TIME_ERROR = _SoapySDR.SOAPY_SDR_TIME_ERROR
r"""
    Returned when a the device encountered a stream time
    which was expired (late) or too early to process.
    """
SOAPY_SDR_UNDERFLOW = _SoapySDR.SOAPY_SDR_UNDERFLOW
r"""
    Returned when write caused an underflow condition.
    For example, a continuous stream was interrupted.
    """
SOAPY_SDR_API_VERSION = _SoapySDR.SOAPY_SDR_API_VERSION
r"""
     Utility functions to query version information.

     Copyright: 
     Copyright (c) 2014-2021 Josh Blum
     Copyright (c) 2016-2016 Bastille Networks
                   2021-2022 Nicholas Corgan
     SPDX-License-Identifier: BSL-1.0

    API version number which can be used as a preprocessor check.
    The format of the version number is encoded as follows:
    **(major << 24) | (minor << 16) | (16 bit increment)**.
    Where the increment can be used to indicate implementation
    changes, fixes, or API additions within a minor release series.

    The macro is typically used in an application as follows:

    .. code-block:: c++

        #if defined(SOAPY_SDR_API_VERSION) && (SOAPY_SDR_API_VERSION >= 0x00001234)
        // Use a newer feature from the SoapySDR library API
        #endif
    """
SOAPY_SDR_ABI_VERSION = _SoapySDR.SOAPY_SDR_ABI_VERSION
r"""
    ABI Version Information - incremented when the ABI is changed.
    The ABI version format is **version[-extra]**.
    The *version* comes from the associated library major.minor version.
    And *extra* is empty for releases but set on development branches.
    The ABI should remain constant across patch releases of the library.
    """
SOAPY_SDR_CF64 = _SoapySDR.SOAPY_SDR_CF64
r"""
    Format strings used in the stream API.

    Copyright: 
    Copyright (c) 2015-2015 Josh Blum
    SPDX-License-Identifier: BSL-1.0
     Complex 64-bit floats (complex double)
    """
SOAPY_SDR_CF32 = _SoapySDR.SOAPY_SDR_CF32
r""" Complex 32-bit floats (complex float)"""
SOAPY_SDR_CS32 = _SoapySDR.SOAPY_SDR_CS32
r""" Complex signed 32-bit integers (complex int32)"""
SOAPY_SDR_CU32 = _SoapySDR.SOAPY_SDR_CU32
r""" Complex unsigned 32-bit integers (complex uint32)"""
SOAPY_SDR_CS16 = _SoapySDR.SOAPY_SDR_CS16
r""" Complex signed 16-bit integers (complex int16)"""
SOAPY_SDR_CU16 = _SoapySDR.SOAPY_SDR_CU16
r""" Complex unsigned 16-bit integers (complex uint16)"""
SOAPY_SDR_CS12 = _SoapySDR.SOAPY_SDR_CS12
r""" Complex signed 12-bit integers (3 bytes)"""
SOAPY_SDR_CU12 = _SoapySDR.SOAPY_SDR_CU12
r""" Complex unsigned 12-bit integers (3 bytes)"""
SOAPY_SDR_CS8 = _SoapySDR.SOAPY_SDR_CS8
r""" Complex signed 8-bit integers (complex int8)"""
SOAPY_SDR_CU8 = _SoapySDR.SOAPY_SDR_CU8
r""" Complex unsigned 8-bit integers (complex uint8)"""
SOAPY_SDR_CS4 = _SoapySDR.SOAPY_SDR_CS4
r""" Complex signed 4-bit integers (1 byte)"""
SOAPY_SDR_CU4 = _SoapySDR.SOAPY_SDR_CU4
r""" Complex unsigned 4-bit integers (1 byte)"""
SOAPY_SDR_F64 = _SoapySDR.SOAPY_SDR_F64
r""" Real 64-bit floats (double)"""
SOAPY_SDR_F32 = _SoapySDR.SOAPY_SDR_F32
r""" Real 32-bit floats (float)"""
SOAPY_SDR_S32 = _SoapySDR.SOAPY_SDR_S32
r""" Real signed 32-bit integers (int32)"""
SOAPY_SDR_U32 = _SoapySDR.SOAPY_SDR_U32
r""" Real unsigned 32-bit integers (uint32)"""
SOAPY_SDR_S16 = _SoapySDR.SOAPY_SDR_S16
r""" Real signed 16-bit integers (int16)"""
SOAPY_SDR_U16 = _SoapySDR.SOAPY_SDR_U16
r""" Real unsigned 16-bit integers (uint16)"""
SOAPY_SDR_S8 = _SoapySDR.SOAPY_SDR_S8
r""" Real signed 8-bit integers (int8)"""
SOAPY_SDR_U8 = _SoapySDR.SOAPY_SDR_U8
r""" Real unsigned 8-bit integers (uint8)"""
SOAPY_SDR_FATAL = _SoapySDR.SOAPY_SDR_FATAL
r""" A fatal error. The application will most likely terminate. This is the highest priority."""
SOAPY_SDR_CRITICAL = _SoapySDR.SOAPY_SDR_CRITICAL
r""" A critical error. The application might not be able to continue running successfully."""
SOAPY_SDR_ERROR = _SoapySDR.SOAPY_SDR_ERROR
r""" An error. An operation did not complete successfully, but the application as a whole is not affected."""
SOAPY_SDR_WARNING = _SoapySDR.SOAPY_SDR_WARNING
r""" A warning. An operation completed with an unexpected result."""
SOAPY_SDR_NOTICE = _SoapySDR.SOAPY_SDR_NOTICE
r""" A notice, which is an information with just a higher priority."""
SOAPY_SDR_INFO = _SoapySDR.SOAPY_SDR_INFO
r""" An informational message, usually denoting the successful completion of an operation."""
SOAPY_SDR_DEBUG = _SoapySDR.SOAPY_SDR_DEBUG
r""" A debugging message."""
SOAPY_SDR_TRACE = _SoapySDR.SOAPY_SDR_TRACE
r""" A tracing message. This is the lowest priority."""
SOAPY_SDR_SSI = _SoapySDR.SOAPY_SDR_SSI
r""" Streaming status indicators such as "U" (underflow) and "O" (overflow)."""

def log(logLevel, message):
    r"""
    Send a message to the registered logger.
    :type logLevel: int
    :param logLevel: a possible logging level
    :type message: str
    :param message: a logger message string
    """
    return _SoapySDR.log(logLevel, message)

def setLogLevel(logLevel):
    r"""
    Set the log level threshold.
    Log messages with lower priority are dropped.
    """
    return _SoapySDR.setLogLevel(logLevel)

def getLogLevel():
    r"""Get the log level threshold."""
    return _SoapySDR.getLogLevel()
class _SoapySDR_pythonLogHandlerBase(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        if self.__class__ == _SoapySDR_pythonLogHandlerBase:
            _self = None
        else:
            _self = self
        _SoapySDR._SoapySDR_pythonLogHandlerBase_swiginit(self, _SoapySDR.new__SoapySDR_pythonLogHandlerBase(_self, ))
    __swig_destroy__ = _SoapySDR.delete__SoapySDR_pythonLogHandlerBase

    def handle(self, arg0, arg1):
        return _SoapySDR._SoapySDR_pythonLogHandlerBase_handle(self, arg0, arg1)
    def __disown__(self):
        self.this.disown()
        _SoapySDR.disown__SoapySDR_pythonLogHandlerBase(self)
        return weakref.proxy(self)

# Register _SoapySDR_pythonLogHandlerBase in _SoapySDR:
_SoapySDR._SoapySDR_pythonLogHandlerBase_swigregister(_SoapySDR_pythonLogHandlerBase)

_SoapySDR_globalLogHandlers = [None]

class _SoapySDR_pythonLogHandler(_SoapySDR_pythonLogHandlerBase):
    def __init__(self, handler):
        self.handler = handler
        getattr(_SoapySDR_pythonLogHandlerBase, '__init__')(self)

    def handle(self, *args): self.handler(*args)

def registerLogHandler(handler):
    """Register a new system log handler.

    Platforms should call this to replace the default stdio handler.

    :param handler: is a callback function that's called each time an event is
    to be logged by the SoapySDR module.  It is passed the log level and the
    the log message.  The callback shouldn't return anything, but may throw
    exceptions which can be handled in turn in the Python client code.
    Alternately, setting handler to None restores the default.

    :type handler: Callable[[int, str], None] or None

    :returns: None
    """
    if handler is None:
        _SoapySDR_globalLogHandlers[0] = None
    else:
        _SoapySDR_globalLogHandlers[0] = _SoapySDR_pythonLogHandler(handler)


def errToStr(errorCode):
    r"""
    Convert a error code to a string for printing purposes.
    If the error code is unrecognized, errToStr returns "UNKNOWN".
    :type errorCode: int
    :param errorCode: a negative integer return code
    :rtype: string
    :return: a pointer to a string representing the error
    """
    return _SoapySDR.errToStr(errorCode)

def getAPIVersion():
    r"""
    Get the SoapySDR library API version as a string.
    The format of the version string is **major.minor.increment**,
    where the digits are taken directly from **SOAPY_SDR_API_VERSION**.
    """
    return _SoapySDR.getAPIVersion()

def getABIVersion():
    r"""
    Get the ABI version string that the library was built against.
    A client can compare **SOAPY_SDR_ABI_VERSION** to getABIVersion()
    to check for ABI incompatibility before using the library.
    If the values are not equal then the client code was
    compiled against a different ABI than the library.
    """
    return _SoapySDR.getABIVersion()

def getLibVersion():
    r"""
    Get the library version and build information string.
    The format of the version string is **major.minor.patch-buildInfo**.
    This function is commonly used to identify the software back-end
    to the user for command-line utilities and graphical applications.
    """
    return _SoapySDR.getLibVersion()

def getRootPath():
    r""" Query the root installation path"""
    return _SoapySDR.getRootPath()

def listSearchPaths():
    r"""
    The list of paths automatically searched by loadModules().
    :rtype: list[str]
    :return: a list of automatically searched file paths
    """
    return _SoapySDR.listSearchPaths()

def listModules(*args):
    r"""
    *Overload 1:*

    List all modules found in default path.
    :rtype: list[str]
    :return: a list of file paths to loadable modules

    |

    *Overload 2:*

    List all modules found in the given path.
    :type path: str
    :param path: a directory on the system
    :rtype: list[str]
    :return: a list of file paths to loadable modules
    """
    return _SoapySDR.listModules(*args)

def loadModule(path):
    r"""
    Load a single module given its file system path.
    :type path: str
    :param path: the path to a specific module file
    :rtype: str
    :return: an error message, empty on success
    """
    return _SoapySDR.loadModule(path)

def getLoaderResult(path):
    r"""
    List all registration loader errors for a given module path.
    The resulting dictionary contains all registry entry names
    provided by the specified module. The value of each entry
    is an error message string or empty on successful load.
    :type path: str
    :param path: the path to a specific module file
    :rtype: dict
    :return: a dictionary of registry names to error messages
    """
    return _SoapySDR.getLoaderResult(path)

def getModuleVersion(path):
    r"""
    Get a version string for the specified module.
    Modules may optionally provide version strings.
    :type path: str
    :param path: the path to a specific module file
    :rtype: str
    :return: a version string or empty if no version provided
    """
    return _SoapySDR.getModuleVersion(path)

def unloadModule(path):
    r"""
    Unload a module that was loaded with loadModule().
    :type path: str
    :param path: the path to a specific module file
    :rtype: str
    :return: an error message, empty on success
    """
    return _SoapySDR.unloadModule(path)

def loadModules():
    r"""
    Load the support modules installed on this system.
    This call will only actually perform the load once.
    Subsequent calls are a NOP.
    """
    return _SoapySDR.loadModules()

def unloadModules():
    r"""Unload all currently loaded support modules."""
    return _SoapySDR.unloadModules()
class ModuleManager(object):
    r"""
    Manage the lifetime of loadable modules
    by unloading modules on scope exit.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, load=True):
        r"""
        Create an instance of the module manager.
        Loading modules on creation can be disabled.
        :type load: bool, optional
        :param load: false to skip loading modules
        """
        _SoapySDR.ModuleManager_swiginit(self, _SoapySDR.new_ModuleManager(load))
    __swig_destroy__ = _SoapySDR.delete_ModuleManager

# Register ModuleManager in _SoapySDR:
_SoapySDR.ModuleManager_swigregister(ModuleManager)
class ModuleVersion(object):
    r""" Conditional comment: Internal call to register version with a module during load"""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, version):
        _SoapySDR.ModuleVersion_swiginit(self, _SoapySDR.new_ModuleVersion(version))
    __swig_destroy__ = _SoapySDR.delete_ModuleVersion

# Register ModuleVersion in _SoapySDR:
_SoapySDR.ModuleVersion_swigregister(ModuleVersion)

def formatToSize(format):
    r"""
    Get the size of a single element in the specified format.
    :type format: str
    :param format: a supported format string
    :rtype: int
    :return: the size of an element in bytes
    """
    return _SoapySDR.formatToSize(format)

def ticksToTimeNs(ticks, rate):
    r"""
    Convert a tick count into a time in nanoseconds using the tick rate.
    :type ticks: int
    :param ticks: a integer tick count
    :type rate: float
    :param rate: the ticks per second
    :rtype: int
    :return: the time in nanoseconds
    """
    return _SoapySDR.ticksToTimeNs(ticks, rate)

def timeNsToTicks(timeNs, rate):
    r"""
    Convert a time in nanoseconds into a tick count using the tick rate.
    :type timeNs: int
    :param timeNs: time in nanoseconds
    :type rate: float
    :param rate: the ticks per second
    :rtype: int
    :return: the integer tick count
    """
    return _SoapySDR.timeNsToTicks(timeNs, rate)
class Device(object):
    r"""Abstraction for an SDR transceiver device - configuration and streaming."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _SoapySDR.delete_Device

    @staticmethod
    def enumerate(*args):
        r"""
        *Overload 1:*

        Enumerate a list of available devices on the system.
        :type args: dict, optional
        :param args: device construction key/value argument filters
        :rtype: list[dict]
        :return: a list of argument maps, each unique to a device

        |

        *Overload 2:*

        Enumerate a list of available devices on the system.
        Markup format for args: "keyA=valA, keyB=valB".
        :type args: str
        :param args: a markup string of key/value argument filters
        :rtype: list[dict]
        :return: a list of argument maps, each unique to a device
        """
        return _SoapySDR.Device_enumerate(*args)

    @staticmethod
    def make(*args):
        r"""
        *Overload 1:*

        Make a new Device object given device construction args.
        The device pointer will be stored in a table so subsequent calls
        with the same arguments will produce the same device.
        For every call to make, there should be a matched call to unmake.

        :type args: dict, optional
        :param args: device construction key/value argument map
        :rtype: SoapySDR.Device
        :return: a pointer to a new Device object

        |

        *Overload 2:*

        Make a new Device object given device construction args.
        The device pointer will be stored in a table so subsequent calls
        with the same arguments will produce the same device.
        For every call to make, there should be a matched call to unmake.

        :type args: str
        :param args: a markup string of key/value arguments
        :rtype: SoapySDR.Device
        :return: a pointer to a new Device object

        |

        *Overload 3:*

        Create a list of devices from a list of construction arguments.
        This is a convenience call to parallelize device construction,
        and is fundamentally a parallel for loop of make(Kwargs).

        :type argsList: list[dict]
        :param argsList: a list of device arguments per each device
        :rtype: list[SoapySDR.Device]
        :return: a list of device pointers per each specified argument

        |

        *Overload 4:*

        Create a list of devices from a list of construction arguments.
        This is a convenience call to parallelize device construction,
        and is fundamentally a parallel for loop of make(args).

        :type argsList: list[str]
        :param argsList: a list of device arguments per each device
        :rtype: list[SoapySDR.Device]
        :return: a list of device pointers per each specified argument
        """
        return _SoapySDR.Device_make(*args)

    @staticmethod
    def unmake(*args):
        r"""
        *Overload 1:*

        Unmake or release a device object handle.

        :type device: SoapySDR.Device
        :param device: a pointer to a device object

        |

        *Overload 2:*

        Unmake or release a list of device handles.
        This is a convenience call to parallelize device destruction,
        and is fundamentally a parallel for loop of unmake(Device *).

        :type devices: list[SoapySDR.Device]
        :param devices: a list of pointers to device objects
        """
        return _SoapySDR.Device_unmake(*args)

    def getDriverKey(self):
        r"""
        A key that uniquely identifies the device driver.
        This key identifies the underlying implementation.
        Several variants of a product may share a driver.
        """
        return _SoapySDR.Device_getDriverKey(self)

    def getHardwareKey(self):
        r"""
        A key that uniquely identifies the hardware.
        This key should be meaningful to the user
        to optimize for the underlying hardware.
        """
        return _SoapySDR.Device_getHardwareKey(self)

    def getHardwareInfo(self):
        r"""
        Query a dictionary of available device information.
        This dictionary can any number of values like
        vendor name, product name, revisions, serials...
        This information can be displayed to the user
        to help identify the instantiated device.
        """
        return _SoapySDR.Device_getHardwareInfo(self)

    def setFrontendMapping(self, direction, mapping):
        r"""
        Set the frontend mapping of available DSP units to RF frontends.
        This mapping controls channel mapping and channel availability.
        :type direction: int
        :param direction: the channel direction RX or TX
        :type mapping: str
        :param mapping: a vendor-specific mapping string
        """
        return _SoapySDR.Device_setFrontendMapping(self, direction, mapping)

    def getFrontendMapping(self, direction):
        r"""
        Get the mapping configuration string.
        :type direction: int
        :param direction: the channel direction RX or TX
        :rtype: str
        :return: the vendor-specific mapping string
        """
        return _SoapySDR.Device_getFrontendMapping(self, direction)

    def getNumChannels(self, direction):
        r"""Get a number of channels given the streaming direction"""
        return _SoapySDR.Device_getNumChannels(self, direction)

    def getChannelInfo(self, direction, channel):
        r"""
        Query a dictionary of available channel information.
        This dictionary can any number of values like
        decoder type, version, available functions...
        This information can be displayed to the user
        to help identify the instantiated channel.
        :type direction: int
        :param direction: the channel direction RX or TX
        :type channel: int
        :param channel: an available channel on the device
        :rtype: dict
        :return: channel information
        """
        return _SoapySDR.Device_getChannelInfo(self, direction, channel)

    def getFullDuplex(self, direction, channel):
        r"""
        Find out if the specified channel is full or half duplex.
        :type direction: int
        :param direction: the channel direction RX or TX
        :type channel: int
        :param channel: an available channel on the device
        :rtype: bool
        :return: true for full duplex, false for half duplex
        """
        return _SoapySDR.Device_getFullDuplex(self, direction, channel)

    def getStreamFormats(self, direction, channel):
        r"""
        Query a list of the available stream formats.
        :type direction: int
        :param direction: the channel direction RX or TX
        :type channel: int
        :param channel: an available channel on the device
        :rtype: list[str]
        :return: a list of allowed format strings. See setupStream() for the format syntax.
        """
        return _SoapySDR.Device_getStreamFormats(self, direction, channel)

    def getStreamArgsInfo(self, direction, channel):
        r"""
        Query the argument info description for stream args.
        :type direction: int
        :param direction: the channel direction RX or TX
        :type channel: int
        :param channel: an available channel on the device
        :rtype: list[SoapySDR.ArgInfo]
        :return: a list of argument info structures
        """
        return _SoapySDR.Device_getStreamArgsInfo(self, direction, channel)

    def setupStream(self, *args):
        r"""
        Initialize a stream given a list of channels and stream arguments.
        The implementation may change switches or power-up components.
        All stream API calls should be usable with the new stream object
        after setupStream() is complete, regardless of the activity state.

        The API allows any number of simultaneous TX and RX streams, but many dual-channel
        devices are limited to one stream in each direction, using either one or both channels.
        This call will throw an exception if an unsupported combination is requested,
        or if a requested channel in this direction is already in use by another stream.

        When multiple channels are added to a stream, they are typically expected to have
        the same sample rate. See setSampleRate().

        :type direction: int
        :param direction: the channel direction (`SOAPY_SDR_RX` or `SOAPY_SDR_TX`)
        :type format: str
        :param format: A string representing the desired buffer format in read/writeStream()


        The first character selects the number type:
          - "C" means complex
          - "F" means floating point
          - "S" means signed integer
          - "U" means unsigned integer

        The type character is followed by the number of bits per number (complex is 2x this size per sample)

         Example format strings:
          - "CF32" -  complex float32 (8 bytes per element)
          - "CS16" -  complex int16 (4 bytes per element)
          - "CS12" -  complex int12 (3 bytes per element)
          - "CS4" -  complex int4 (1 byte per element)
          - "S32" -  int32 (4 bytes per element)
          - "U8" -  uint8 (1 byte per element)


        :type channels: std::vector< size_t,std::allocator< size_t > >, optional
        :param channels: a list of channels or empty for automatic.
        :type args: dict, optional
        :param args: stream args or empty for defaults.


          Recommended keys to use in the args dictionary:
           - "WIRE" - format of the samples between device and host

        :rtype: SoapySDR.Stream
        :return: an opaque pointer to a stream handle.


        The returned stream is not required to have internal locking, and may not be used
        concurrently from multiple threads.
        """
        return _SoapySDR.Device_setupStream(self, *args)

    def closeStream(self, stream):
        r"""
        Close an open stream created by setupStream
        The implementation may change switches or power-down components.
        :type stream: SoapySDR.Stream
        :param stream: the opaque pointer to a stream handle
        """
        return _SoapySDR.Device_closeStream(self, stream)

    def getStreamMTU(self, stream):
        r"""
        Get the stream's maximum transmission unit (MTU) in number of elements.
        The MTU specifies the maximum payload transfer in a stream operation.
        This value can be used as a stream buffer allocation size that can
        best optimize throughput given the underlying stream implementation.

        :type stream: SoapySDR.Stream
        :param stream: the opaque pointer to a stream handle
        :rtype: int
        :return: the MTU in number of stream elements (never zero)
        """
        return _SoapySDR.Device_getStreamMTU(self, stream)

    def activateStream(self, stream, flags=0, timeNs=0, numElems=0):
        r"""
        Activate a stream.
        Call activate to prepare a stream before using read/write().
        The implementation control switches or stimulate data flow.

        The timeNs is only valid when the flags have SOAPY_SDR_HAS_TIME.
        The numElems count can be used to request a finite burst size.
        The SOAPY_SDR_END_BURST flag can signal end on the finite burst.
        Not all implementations will support the full range of options.
        In this case, the implementation returns SOAPY_SDR_NOT_SUPPORTED.

        :type stream: SoapySDR.Stream
        :param stream: the opaque pointer to a stream handle
        :type flags: int, optional
        :param flags: optional flag indicators about the stream
        :type timeNs: int, optional
        :param timeNs: optional activation time in nanoseconds
        :type numElems: int, optional
        :param numElems: optional element count for burst control
        :rtype: int
        :return: 0 for success or error code on failure
        """
        return _SoapySDR.Device_activateStream(self, stream, flags, timeNs, numElems)

    def deactivateStream(self, stream, flags=0, timeNs=0):
        r"""
        Deactivate a stream.
        Call deactivate when not using using read/write().
        The implementation control switches or halt data flow.

        The timeNs is only valid when the flags have SOAPY_SDR_HAS_TIME.
        Not all implementations will support the full range of options.
        In this case, the implementation returns SOAPY_SDR_NOT_SUPPORTED.

        :type stream: SoapySDR.Stream
        :param stream: the opaque pointer to a stream handle
        :type flags: int, optional
        :param flags: optional flag indicators about the stream
        :type timeNs: int, optional
        :param timeNs: optional deactivation time in nanoseconds
        :rtype: int
        :return: 0 for success or error code on failure
        """
        return _SoapySDR.Device_deactivateStream(self, stream, flags, timeNs)

    def listAntennas(self, direction, channel):
        r"""
        Get a list of available antennas to select on a given chain.
        :type direction: int
        :param direction: the channel direction RX or TX
        :type channel: int
        :param channel: an available channel on the device
        :rtype: list[str]
        :return: a list of available antenna names
        """
        return _SoapySDR.Device_listAntennas(self, direction, channel)

    def setAntenna(self, direction, channel, name):
        r"""
        Set the selected antenna on a chain.
        :type direction: int
        :param direction: the channel direction RX or TX
        :type channel: int
        :param channel: an available channel on the device
        :type name: str
        :param name: the name of an available antenna
        """
        return _SoapySDR.Device_setAntenna(self, direction, channel, name)

    def getAntenna(self, direction, channel):
        r"""
        Get the selected antenna on a chain.
        :type direction: int
        :param direction: the channel direction RX or TX
        :type channel: int
        :param channel: an available channel on the device
        :rtype: str
        :return: the name of an available antenna
        """
        return _SoapySDR.Device_getAntenna(self, direction, channel)

    def hasDCOffsetMode(self, direction, channel):
        r"""
        Does the device support automatic DC offset corrections?
        :type direction: int
        :param direction: the channel direction RX or TX
        :type channel: int
        :param channel: an available channel on the device
        :rtype: bool
        :return: true if automatic corrections are supported
        """
        return _SoapySDR.Device_hasDCOffsetMode(self, direction, channel)

    def setDCOffsetMode(self, direction, channel, automatic):
        r"""
        Set the automatic DC offset corrections mode.
        :type direction: int
        :param direction: the channel direction RX or TX
        :type channel: int
        :param channel: an available channel on the device
        :type automatic: bool
        :param automatic: true for automatic offset correction
        """
        return _SoapySDR.Device_setDCOffsetMode(self, direction, channel, automatic)

    def getDCOffsetMode(self, direction, channel):
        r"""
        Get the automatic DC offset corrections mode.
        :type direction: int
        :param direction: the channel direction RX or TX
        :type channel: int
        :param channel: an available channel on the device
        :rtype: bool
        :return: true for automatic offset correction
        """
        return _SoapySDR.Device_getDCOffsetMode(self, direction, channel)

    def hasDCOffset(self, direction, channel):
        r"""
        Does the device support frontend DC offset correction?
        :type direction: int
        :param direction: the channel direction RX or TX
        :type channel: int
        :param channel: an available channel on the device
        :rtype: bool
        :return: true if DC offset corrections are supported
        """
        return _SoapySDR.Device_hasDCOffset(self, direction, channel)

    def setDCOffset(self, direction, channel, offset):
        r"""
        Set the frontend DC offset correction.
        :type direction: int
        :param direction: the channel direction RX or TX
        :type channel: int
        :param channel: an available channel on the device
        :type offset: complex
        :param offset: the relative correction (1.0 max)
        """
        return _SoapySDR.Device_setDCOffset(self, direction, channel, offset)

    def getDCOffset(self, direction, channel):
        r"""
        Get the frontend DC offset correction.
        :type direction: int
        :param direction: the channel direction RX or TX
        :type channel: int
        :param channel: an available channel on the device
        :rtype: complex
        :return: the relative correction (1.0 max)
        """
        return _SoapySDR.Device_getDCOffset(self, direction, channel)

    def hasIQBalance(self, direction, channel):
        r"""
        Does the device support frontend IQ balance correction?
        :type direction: int
        :param direction: the channel direction RX or TX
        :type channel: int
        :param channel: an available channel on the device
        :rtype: bool
        :return: true if IQ balance corrections are supported
        """
        return _SoapySDR.Device_hasIQBalance(self, direction, channel)

    def setIQBalance(self, direction, channel, balance):
        r"""
        Set the frontend IQ balance correction.
        :type direction: int
        :param direction: the channel direction RX or TX
        :type channel: int
        :param channel: an available channel on the device
        :type balance: complex
        :param balance: the relative correction (1.0 max)
        """
        return _SoapySDR.Device_setIQBalance(self, direction, channel, balance)

    def getIQBalance(self, direction, channel):
        r"""
        Get the frontend IQ balance correction.
        :type direction: int
        :param direction: the channel direction RX or TX
        :type channel: int
        :param channel: an available channel on the device
        :rtype: complex
        :return: the relative correction (1.0 max)
        """
        return _SoapySDR.Device_getIQBalance(self, direction, channel)

    def hasIQBalanceMode(self, direction, channel):
        r"""
        Does the device support automatic frontend IQ balance correction?
        :type direction: int
        :param direction: the channel direction RX or TX
        :type channel: int
        :param channel: an available channel on the device
        :rtype: bool
        :return: true if IQ balance corrections are supported
        """
        return _SoapySDR.Device_hasIQBalanceMode(self, direction, channel)

    def setIQBalanceMode(self, direction, channel, automatic):
        r"""
        Set the automatic frontend IQ balance correction.
        :type direction: int
        :param direction: the channel direction RX or TX
        :type channel: int
        :param channel: an available channel on the device
        :type automatic: bool
        :param automatic: true for automatic correction
        """
        return _SoapySDR.Device_setIQBalanceMode(self, direction, channel, automatic)

    def getIQBalanceMode(self, direction, channel):
        r"""
        Set the automatic IQ balance corrections mode.
        :type direction: int
        :param direction: the channel direction RX or TX
        :type channel: int
        :param channel: an available channel on the device
        :rtype: bool
        :return: true for automatic correction
        """
        return _SoapySDR.Device_getIQBalanceMode(self, direction, channel)

    def hasFrequencyCorrection(self, direction, channel):
        r"""
        Does the device support frontend frequency correction?
        :type direction: int
        :param direction: the channel direction RX or TX
        :type channel: int
        :param channel: an available channel on the device
        :rtype: bool
        :return: true if frequency corrections are supported
        """
        return _SoapySDR.Device_hasFrequencyCorrection(self, direction, channel)

    def setFrequencyCorrection(self, direction, channel, value):
        r"""
        Fine tune the frontend frequency correction.
        :type direction: int
        :param direction: the channel direction RX or TX
        :type channel: int
        :param channel: an available channel on the device
        :type value: float
        :param value: the correction in PPM
        """
        return _SoapySDR.Device_setFrequencyCorrection(self, direction, channel, value)

    def getFrequencyCorrection(self, direction, channel):
        r"""
        Get the frontend frequency correction value.
        :type direction: int
        :param direction: the channel direction RX or TX
        :type channel: int
        :param channel: an available channel on the device
        :rtype: float
        :return: the correction value in PPM
        """
        return _SoapySDR.Device_getFrequencyCorrection(self, direction, channel)

    def listGains(self, direction, channel):
        r"""
        List available amplification elements.
        Elements should be in order RF to baseband.
        :type direction: int
        :param direction: the channel direction RX or TX
        :type channel: int
        :param channel: an available channel
        :rtype: list[str]
        :return: a list of gain string names
        """
        return _SoapySDR.Device_listGains(self, direction, channel)

    def hasGainMode(self, direction, channel):
        r"""
        Does the device support automatic gain control?
        :type direction: int
        :param direction: the channel direction RX or TX
        :type channel: int
        :param channel: an available channel on the device
        :rtype: bool
        :return: true for automatic gain control
        """
        return _SoapySDR.Device_hasGainMode(self, direction, channel)

    def setGainMode(self, direction, channel, automatic):
        r"""
        Set the automatic gain mode on the chain.
        :type direction: int
        :param direction: the channel direction RX or TX
        :type channel: int
        :param channel: an available channel on the device
        :type automatic: bool
        :param automatic: true for automatic gain setting
        """
        return _SoapySDR.Device_setGainMode(self, direction, channel, automatic)

    def getGainMode(self, direction, channel):
        r"""
        Get the automatic gain mode on the chain.
        :type direction: int
        :param direction: the channel direction RX or TX
        :type channel: int
        :param channel: an available channel on the device
        :rtype: bool
        :return: true for automatic gain setting
        """
        return _SoapySDR.Device_getGainMode(self, direction, channel)

    def setGain(self, *args):
        r"""
        *Overload 1:*

        Set the overall amplification in a chain.
        The gain will be distributed automatically across available element.
        :type direction: int
        :param direction: the channel direction RX or TX
        :type channel: int
        :param channel: an available channel on the device
        :type value: float
        :param value: the new amplification value in dB

        |

        *Overload 2:*

        Set the value of a amplification element in a chain.
        :type direction: int
        :param direction: the channel direction RX or TX
        :type channel: int
        :param channel: an available channel on the device
        :type name: str
        :param name: the name of an amplification element
        :type value: float
        :param value: the new amplification value in dB
        """
        return _SoapySDR.Device_setGain(self, *args)

    def getGain(self, *args):
        r"""
        *Overload 1:*

        Get the overall value of the gain elements in a chain.
        :type direction: int
        :param direction: the channel direction RX or TX
        :type channel: int
        :param channel: an available channel on the device
        :rtype: float
        :return: the value of the gain in dB

        |

        *Overload 2:*

        Get the value of an individual amplification element in a chain.
        :type direction: int
        :param direction: the channel direction RX or TX
        :type channel: int
        :param channel: an available channel on the device
        :type name: str
        :param name: the name of an amplification element
        :rtype: float
        :return: the value of the gain in dB
        """
        return _SoapySDR.Device_getGain(self, *args)

    def getGainRange(self, *args):
        r"""
        *Overload 1:*

        Get the overall range of possible gain values.
        :type direction: int
        :param direction: the channel direction RX or TX
        :type channel: int
        :param channel: an available channel on the device
        :rtype: SoapySDR.Range
        :return: a list of gain ranges in dB

        |

        *Overload 2:*

        Get the range of possible gain values for a specific element.
        :type direction: int
        :param direction: the channel direction RX or TX
        :type channel: int
        :param channel: an available channel on the device
        :type name: str
        :param name: the name of an amplification element
        :rtype: SoapySDR.Range
        :return: a list of gain ranges in dB
        """
        return _SoapySDR.Device_getGainRange(self, *args)

    def setFrequency(self, *args):
        r"""
        *Overload 1:*

        Set the center frequency of the chain.
         - For RX, this specifies the down-conversion frequency.
         - For TX, this specifies the up-conversion frequency.

        The default implementation of setFrequency() will tune the "RF"
        component as close as possible to the requested center frequency.
        Tuning inaccuracies will be compensated for with the "BB" component.

        The args can be used to augment the tuning algorithm.
         - Use "OFFSET" to specify an "RF" tuning offset,
           usually with the intention of moving the LO out of the passband.
           The offset will be compensated for using the "BB" component.
         - Use the name of a component for the key and a frequency in Hz
           as the value (any format) to enforce a specific frequency.
           The other components will be tuned with compensation
           to achieve the specified overall frequency.
         - Use the name of a component for the key and the value "IGNORE"
           so that the tuning algorithm will avoid altering the component.
         - Vendor specific implementations can also use the same args to augment
           tuning in other ways such as specifying fractional vs integer N tuning.

        :type direction: int
        :param direction: the channel direction RX or TX
        :type channel: int
        :param channel: an available channel on the device
        :type frequency: float
        :param frequency: the center frequency in Hz
        :type args: dict, optional
        :param args: optional tuner arguments

        |

        *Overload 2:*

        Tune the center frequency of the specified element.
         - For RX, this specifies the down-conversion frequency.
         - For TX, this specifies the up-conversion frequency.

        Recommended names used to represent tunable components:
         - "CORR" - freq error correction in PPM
         - "RF" - frequency of the RF frontend
         - "BB" - frequency of the baseband DSP

        :type direction: int
        :param direction: the channel direction RX or TX
        :type channel: int
        :param channel: an available channel on the device
        :type name: str
        :param name: the name of a tunable element
        :type frequency: float
        :param frequency: the center frequency in Hz
        :type args: dict, optional
        :param args: optional tuner arguments

        |

        *Overload 3:*

        Tune the center frequency of the specified element.
         - For RX, this specifies the down-conversion frequency.
         - For TX, this specifies the up-conversion frequency.

        Recommended names used to represent tunable components:
         - "CORR" - freq error correction in PPM
         - "RF" - frequency of the RF frontend
         - "BB" - frequency of the baseband DSP

        :type direction: int
        :param direction: the channel direction RX or TX
        :type channel: int
        :param channel: an available channel on the device
        :type name: str
        :param name: the name of a tunable element
        :type frequency: float
        :param frequency: the center frequency in Hz
        :param args: optional tuner arguments
        """
        return _SoapySDR.Device_setFrequency(self, *args)

    def getFrequency(self, *args):
        r"""
        *Overload 1:*

        Get the overall center frequency of the chain.
         - For RX, this specifies the down-conversion frequency.
         - For TX, this specifies the up-conversion frequency.
        :type direction: int
        :param direction: the channel direction RX or TX
        :type channel: int
        :param channel: an available channel on the device
        :rtype: float
        :return: the center frequency in Hz

        |

        *Overload 2:*

        Get the frequency of a tunable element in the chain.
        :type direction: int
        :param direction: the channel direction RX or TX
        :type channel: int
        :param channel: an available channel on the device
        :type name: str
        :param name: the name of a tunable element
        :rtype: float
        :return: the tunable element's frequency in Hz
        """
        return _SoapySDR.Device_getFrequency(self, *args)

    def listFrequencies(self, direction, channel):
        r"""
        List available tunable elements in the chain.
        Elements should be in order RF to baseband.
        :type direction: int
        :param direction: the channel direction RX or TX
        :type channel: int
        :param channel: an available channel
        :rtype: list[str]
        :return: a list of tunable elements by name
        """
        return _SoapySDR.Device_listFrequencies(self, direction, channel)

    def getFrequencyRange(self, *args):
        r"""
        *Overload 1:*

        Get the range of overall frequency values.
        :type direction: int
        :param direction: the channel direction RX or TX
        :type channel: int
        :param channel: an available channel on the device
        :rtype: list[SoapySDR.Range]
        :return: a list of frequency ranges in Hz

        |

        *Overload 2:*

        Get the range of tunable values for the specified element.
        :type direction: int
        :param direction: the channel direction RX or TX
        :type channel: int
        :param channel: an available channel on the device
        :type name: str
        :param name: the name of a tunable element
        :rtype: list[SoapySDR.Range]
        :return: a list of frequency ranges in Hz
        """
        return _SoapySDR.Device_getFrequencyRange(self, *args)

    def getFrequencyArgsInfo(self, direction, channel):
        r"""
        Query the argument info description for tune args.
        :type direction: int
        :param direction: the channel direction RX or TX
        :type channel: int
        :param channel: an available channel on the device
        :rtype: list[SoapySDR.ArgInfo]
        :return: a list of argument info structures
        """
        return _SoapySDR.Device_getFrequencyArgsInfo(self, direction, channel)

    def setSampleRate(self, direction, channel, rate):
        r"""
        Set the baseband sample rate of the chain.
        :type direction: int
        :param direction: the channel direction RX or TX
        :type channel: int
        :param channel: an available channel on the device
        :type rate: float
        :param rate: the sample rate in samples per second
        """
        return _SoapySDR.Device_setSampleRate(self, direction, channel, rate)

    def getSampleRate(self, direction, channel):
        r"""
        Get the baseband sample rate of the chain.
        :type direction: int
        :param direction: the channel direction RX or TX
        :type channel: int
        :param channel: an available channel on the device
        :rtype: float
        :return: the sample rate in samples per second
        """
        return _SoapySDR.Device_getSampleRate(self, direction, channel)

    def listSampleRates(self, direction, channel):
        r"""
        Get the range of possible baseband sample rates.
        Deprecated: replaced by getSampleRateRange()
        :type direction: int
        :param direction: the channel direction RX or TX
        :type channel: int
        :param channel: an available channel on the device
        :rtype: std::vector< double,std::allocator< double > >
        :return: a list of possible rates in samples per second
        """
        return _SoapySDR.Device_listSampleRates(self, direction, channel)

    def getSampleRateRange(self, direction, channel):
        r"""
        Get the range of possible baseband sample rates.
        :type direction: int
        :param direction: the channel direction RX or TX
        :type channel: int
        :param channel: an available channel on the device
        :rtype: list[SoapySDR.Range]
        :return: a list of sample rate ranges in samples per second
        """
        return _SoapySDR.Device_getSampleRateRange(self, direction, channel)

    def setBandwidth(self, direction, channel, bw):
        r"""
        Set the baseband filter width of the chain.
        :type direction: int
        :param direction: the channel direction RX or TX
        :type channel: int
        :param channel: an available channel on the device
        :type bw: float
        :param bw: the baseband filter width in Hz
        """
        return _SoapySDR.Device_setBandwidth(self, direction, channel, bw)

    def getBandwidth(self, direction, channel):
        r"""
        Get the baseband filter width of the chain.
        :type direction: int
        :param direction: the channel direction RX or TX
        :type channel: int
        :param channel: an available channel on the device
        :rtype: float
        :return: the baseband filter width in Hz
        """
        return _SoapySDR.Device_getBandwidth(self, direction, channel)

    def listBandwidths(self, direction, channel):
        r"""
        Get the range of possible baseband filter widths.
        Deprecated: replaced by getBandwidthRange()
        :type direction: int
        :param direction: the channel direction RX or TX
        :type channel: int
        :param channel: an available channel on the device
        :rtype: std::vector< double,std::allocator< double > >
        :return: a list of possible bandwidths in Hz
        """
        return _SoapySDR.Device_listBandwidths(self, direction, channel)

    def getBandwidthRange(self, direction, channel):
        r"""
        Get the range of possible baseband filter widths.
        :type direction: int
        :param direction: the channel direction RX or TX
        :type channel: int
        :param channel: an available channel on the device
        :rtype: list[SoapySDR.Range]
        :return: a list of bandwidth ranges in Hz
        """
        return _SoapySDR.Device_getBandwidthRange(self, direction, channel)

    def setMasterClockRate(self, rate):
        r"""
        Set the master clock rate of the device.
        :type rate: float
        :param rate: the clock rate in Hz
        """
        return _SoapySDR.Device_setMasterClockRate(self, rate)

    def getMasterClockRate(self):
        r"""
        Get the master clock rate of the device.
        :rtype: float
        :return: the clock rate in Hz
        """
        return _SoapySDR.Device_getMasterClockRate(self)

    def getMasterClockRates(self):
        r"""
        Get the range of available master clock rates.
        :rtype: list[SoapySDR.Range]
        :return: a list of clock rate ranges in Hz
        """
        return _SoapySDR.Device_getMasterClockRates(self)

    def setReferenceClockRate(self, rate):
        r"""
        Set the reference clock rate of the device.
        :type rate: float
        :param rate: the clock rate in Hz
        """
        return _SoapySDR.Device_setReferenceClockRate(self, rate)

    def getReferenceClockRate(self):
        r"""
        Get the reference clock rate of the device.
        :rtype: float
        :return: the clock rate in Hz
        """
        return _SoapySDR.Device_getReferenceClockRate(self)

    def getReferenceClockRates(self):
        r"""
        Get the range of available reference clock rates.
        :rtype: list[SoapySDR.Range]
        :return: a list of clock rate ranges in Hz
        """
        return _SoapySDR.Device_getReferenceClockRates(self)

    def listClockSources(self):
        r"""
        Get the list of available clock sources.
        :rtype: list[str]
        :return: a list of clock source names
        """
        return _SoapySDR.Device_listClockSources(self)

    def setClockSource(self, source):
        r"""
        Set the clock source on the device
        :type source: str
        :param source: the name of a clock source
        """
        return _SoapySDR.Device_setClockSource(self, source)

    def getClockSource(self):
        r"""
        Get the clock source of the device
        :rtype: str
        :return: the name of a clock source
        """
        return _SoapySDR.Device_getClockSource(self)

    def listTimeSources(self):
        r"""
        Get the list of available time sources.
        :rtype: list[str]
        :return: a list of time source names
        """
        return _SoapySDR.Device_listTimeSources(self)

    def setTimeSource(self, source):
        r"""
        Set the time source on the device
        :type source: str
        :param source: the name of a time source
        """
        return _SoapySDR.Device_setTimeSource(self, source)

    def getTimeSource(self):
        r"""
        Get the time source of the device
        :rtype: str
        :return: the name of a time source
        """
        return _SoapySDR.Device_getTimeSource(self)

    def hasHardwareTime(self, *args):
        r"""
        Does this device have a hardware clock?
        :type what: str, optional
        :param what: optional argument
        :rtype: bool
        :return: true if the hardware clock exists
        """
        return _SoapySDR.Device_hasHardwareTime(self, *args)

    def getHardwareTime(self, *args):
        r"""
        Read the time from the hardware clock on the device.
        The what argument can refer to a specific time counter.
        :type what: str, optional
        :param what: optional argument
        :rtype: int
        :return: the time in nanoseconds
        """
        return _SoapySDR.Device_getHardwareTime(self, *args)

    def setHardwareTime(self, *args):
        r"""
        Write the time to the hardware clock on the device.
        The what argument can refer to a specific time counter.
        :type timeNs: int
        :param timeNs: time in nanoseconds
        :type what: str, optional
        :param what: optional argument
        """
        return _SoapySDR.Device_setHardwareTime(self, *args)

    def setCommandTime(self, *args):
        r"""
        Set the time of subsequent configuration calls.
        The what argument can refer to a specific command queue.
        Implementations may use a time of 0 to clear.
        Deprecated: replaced by setHardwareTime()
        :type timeNs: int
        :param timeNs: time in nanoseconds
        :type what: str, optional
        :param what: optional argument
        """
        return _SoapySDR.Device_setCommandTime(self, *args)

    def listSensors(self, *args):
        r"""
        *Overload 1:*

        List the available global readback sensors.
        A sensor can represent a reference lock, RSSI, temperature.
        :rtype: list[str]
        :return: a list of available sensor string names

        |

        *Overload 2:*

        List the available channel readback sensors.
        A sensor can represent a reference lock, RSSI, temperature.
        :type direction: int
        :param direction: the channel direction RX or TX
        :type channel: int
        :param channel: an available channel on the device
        :rtype: list[str]
        :return: a list of available sensor string names
        """
        return _SoapySDR.Device_listSensors(self, *args)

    def getSensorInfo(self, *args):
        r"""
        *Overload 1:*

        Get meta-information about a sensor.
        Example: displayable name, type, range.
        :type key: str
        :param key: the ID name of an available sensor
        :rtype: SoapySDR.ArgInfo
        :return: meta-information about a sensor

        |

        *Overload 2:*

        Get meta-information about a channel sensor.
        Example: displayable name, type, range.
        :type direction: int
        :param direction: the channel direction RX or TX
        :type channel: int
        :param channel: an available channel on the device
        :type key: str
        :param key: the ID name of an available sensor
        :rtype: SoapySDR.ArgInfo
        :return: meta-information about a sensor
        """
        return _SoapySDR.Device_getSensorInfo(self, *args)

    def readSensor(self, *args):
        r"""
        *Overload 1:*

        Readback a global sensor given the name.
        The value returned is a string which can represent
        a boolean ("true"/"false"), an integer, or float.
        :type key: str
        :param key: the ID name of an available sensor
        :rtype: str
        :return: the current value of the sensor

        |

        *Overload 2:*

        Readback a channel sensor given the name.
        The value returned is a string which can represent
        a boolean ("true"/"false"), an integer, or float.
        :type direction: int
        :param direction: the channel direction RX or TX
        :type channel: int
        :param channel: an available channel on the device
        :type key: str
        :param key: the ID name of an available sensor
        :rtype: str
        :return: the current value of the sensor
        """
        return _SoapySDR.Device_readSensor(self, *args)

    def listRegisterInterfaces(self):
        r"""
        Get a list of available register interfaces by name.
        :rtype: list[str]
        :return: a list of available register interfaces
        """
        return _SoapySDR.Device_listRegisterInterfaces(self)

    def writeRegister(self, *args):
        r"""
        *Overload 1:*

        Write a register on the device given the interface name.
        This can represent a register on a soft CPU, FPGA, IC;
        the interpretation is up the implementation to decide.
        :type name: str
        :param name: the name of a available register interface
        :type addr: int
        :param addr: the register address
        :type value: int
        :param value: the register value

        |

        *Overload 2:*

        Write a register on the device.
        This can represent a register on a soft CPU, FPGA, IC;
        the interpretation is up the implementation to decide.
        Deprecated: replaced by writeRegister(name)
        :type addr: int
        :param addr: the register address
        :type value: int
        :param value: the register value
        """
        return _SoapySDR.Device_writeRegister(self, *args)

    def readRegister(self, *args):
        r"""
        *Overload 1:*

        Read a register on the device given the interface name.
        :type name: str
        :param name: the name of a available register interface
        :type addr: int
        :param addr: the register address
        :rtype: int
        :return: the register value

        |

        *Overload 2:*

        Read a register on the device.
        Deprecated: replaced by readRegister(name)
        :type addr: int
        :param addr: the register address
        :rtype: int
        :return: the register value
        """
        return _SoapySDR.Device_readRegister(self, *args)

    def writeRegisters(self, name, addr, value):
        r"""
        Write a memory block on the device given the interface name.
        This can represent a memory block on a soft CPU, FPGA, IC;
        the interpretation is up the implementation to decide.
        :type name: str
        :param name: the name of a available memory block interface
        :type addr: int
        :param addr: the memory block start address
        :type value: list[int]
        :param value: the memory block content
        """
        return _SoapySDR.Device_writeRegisters(self, name, addr, value)

    def readRegisters(self, name, addr, length):
        r"""
        Read a memory block on the device given the interface name.
        :type name: str
        :param name: the name of a available memory block interface
        :type addr: int
        :param addr: the memory block start address
        :type length: int
        :param length: number of words to be read from memory block
        :rtype: list[int]
        :return: the memory block content
        """
        return _SoapySDR.Device_readRegisters(self, name, addr, length)

    def getSettingInfo(self, *args):
        r"""
        *Overload 1:*

        Describe the allowed keys and values used for settings.
        :rtype: list[SoapySDR.ArgInfo]
        :return: a list of argument info structures

        |

        *Overload 2:*

        Get information on a specific setting.
        :type key: str
        :param key: the setting identifier
        :rtype: SoapySDR.ArgInfo
        :return: all information for a specific setting

        |

        *Overload 3:*

        Describe the allowed keys and values used for channel settings.
        :type direction: int
        :param direction: the channel direction RX or TX
        :type channel: int
        :param channel: an available channel on the device
        :rtype: list[SoapySDR.ArgInfo]
        :return: a list of argument info structures

        |

        *Overload 4:*

        Get information on a specific channel setting.
        :type direction: int
        :param direction: the channel direction RX or TX
        :param channel: an available channel on the device
        :type key: str
        :param key: the setting identifier
        :rtype: SoapySDR.ArgInfo
        :return: all information for a specific channel setting
        """
        return _SoapySDR.Device_getSettingInfo(self, *args)

    def readSetting(self, *args):
        r"""
        *Overload 1:*

        Read an arbitrary setting on the device.
        :type key: str
        :param key: the setting identifier
        :rtype: str
        :return: the setting value

        |

        *Overload 2:*

        Read an arbitrary channel setting on the device.
        :type direction: int
        :param direction: the channel direction RX or TX
        :type channel: int
        :param channel: an available channel on the device
        :type key: str
        :param key: the setting identifier
        :rtype: str
        :return: the setting value
        """
        return _SoapySDR.Device_readSetting(self, *args)

    def listGPIOBanks(self):
        r"""Get a list of available GPIO banks by name."""
        return _SoapySDR.Device_listGPIOBanks(self)

    def writeGPIO(self, *args):
        r"""
        *Overload 1:*

        Write the value of a GPIO bank.
        :type bank: str
        :param bank: the name of an available bank
        :type value: int
        :param value: an integer representing GPIO bits

        |

        *Overload 2:*

        Write the value of a GPIO bank with modification mask.
        :type bank: str
        :param bank: the name of an available bank
        :type value: int
        :param value: an integer representing GPIO bits
        :type mask: int
        :param mask: a modification mask where 1 = modify
        """
        return _SoapySDR.Device_writeGPIO(self, *args)

    def readGPIO(self, bank):
        r"""
        Readback the value of a GPIO bank.
        :type bank: str
        :param bank: the name of an available bank
        :rtype: int
        :return: an integer representing GPIO bits
        """
        return _SoapySDR.Device_readGPIO(self, bank)

    def writeGPIODir(self, *args):
        r"""
        *Overload 1:*

        Write the data direction of a GPIO bank.
        1 bits represent outputs, 0 bits represent inputs.
        :type bank: str
        :param bank: the name of an available bank
        :type dir: int
        :param dir: an integer representing data direction bits

        |

        *Overload 2:*

        Write the data direction of a GPIO bank with modification mask.
        1 bits represent outputs, 0 bits represent inputs.
        :type bank: str
        :param bank: the name of an available bank
        :type dir: int
        :param dir: an integer representing data direction bits
        :type mask: int
        :param mask: a modification mask where 1 = modify
        """
        return _SoapySDR.Device_writeGPIODir(self, *args)

    def readGPIODir(self, bank):
        r"""
        Read the data direction of a GPIO bank.
        1 bits represent outputs, 0 bits represent inputs.
        :type bank: str
        :param bank: the name of an available bank
        :rtype: int
        :return: an integer representing data direction bits
        """
        return _SoapySDR.Device_readGPIODir(self, bank)

    def writeI2C(self, addr, data):
        r"""
        Write to an available I2C slave.
        If the device contains multiple I2C masters,
        the address bits can encode which master.
        :type addr: int
        :param addr: the address of the slave
        :type data: str
        :param data: an array of bytes write out
        """
        return _SoapySDR.Device_writeI2C(self, addr, data)

    def readI2C(self, addr, numBytes):
        r"""
        Read from an available I2C slave.
        If the device contains multiple I2C masters,
        the address bits can encode which master.
        :type addr: int
        :param addr: the address of the slave
        :type numBytes: int
        :param numBytes: the number of bytes to read
        :rtype: str
        :return: an array of bytes read from the slave
        """
        return _SoapySDR.Device_readI2C(self, addr, numBytes)

    def transactSPI(self, addr, data, numBits):
        r"""
        Perform a SPI transaction and return the result.
        Its up to the implementation to set the clock rate,
        and read edge, and the write edge of the SPI core.
        SPI slaves without a readback pin will return 0.

        If the device contains multiple SPI masters,
        the address bits can encode which master.

        :type addr: int
        :param addr: an address of an available SPI slave
        :type data: int
        :param data: the SPI data, numBits-1 is first out
        :type numBits: int
        :param numBits: the number of bits to clock out
        :rtype: int
        :return: the readback data, numBits-1 is first in
        """
        return _SoapySDR.Device_transactSPI(self, addr, data, numBits)

    def listUARTs(self):
        r"""
        Enumerate the available UART devices.
        :rtype: list[str]
        :return: a list of names of available UARTs
        """
        return _SoapySDR.Device_listUARTs(self)

    def writeUART(self, which, data):
        r"""
        Write data to a UART device.
        Its up to the implementation to set the baud rate,
        carriage return settings, flushing on newline.
        :type which: str
        :param which: the name of an available UART
        :type data: str
        :param data: an array of bytes to write out
        """
        return _SoapySDR.Device_writeUART(self, which, data)

    def readUART(self, which, timeoutUs=100000):
        r"""
        Read bytes from a UART until timeout or newline.
        Its up to the implementation to set the baud rate,
        carriage return settings, flushing on newline.
        :type which: str
        :param which: the name of an available UART
        :type timeoutUs: int, optional
        :param timeoutUs: a timeout in microseconds
        :rtype: str
        :return: an array of bytes read from the UART
        """
        return _SoapySDR.Device_readUART(self, which, timeoutUs)

    def writeSetting(self, *args):
        r"""
        *Overload 1:*

        Write an arbitrary setting on the device.
        The interpretation is up the implementation.
        :type key: str
        :param key: the setting identifier
        :type value: str
        :param value: the setting value

        |

        *Overload 2:*

        Write an arbitrary channel setting on the device.
        The interpretation is up the implementation.
        :type direction: int
        :param direction: the channel direction RX or TX
        :type channel: int
        :param channel: an available channel on the device
        :type key: str
        :param key: the setting identifier
        :type value: str
        :param value: the setting value

        |

        *Overload 3:*

        Write a setting with an arbitrary value type.
        :param Type: the data type of the value
        :type key: str
        :param key: the setting identifier
        :type value: bool
        :param value: the setting value

        |

        *Overload 4:*

        Write an arbitrary channel setting on the device.
        :param Type: the data type of the value
        :type direction: int
        :param direction: the channel direction RX or TX
        :type channel: int
        :param channel: an available channel on the device
        :type key: str
        :param key: the setting identifier
        :type value: bool
        :param value: the setting value

        |

        *Overload 5:*

        Write a setting with an arbitrary value type.
        :param Type: the data type of the value
        :type key: str
        :param key: the setting identifier
        :type value: float
        :param value: the setting value

        |

        *Overload 6:*

        Write an arbitrary channel setting on the device.
        :param Type: the data type of the value
        :type direction: int
        :param direction: the channel direction RX or TX
        :type channel: int
        :param channel: an available channel on the device
        :type key: str
        :param key: the setting identifier
        :type value: float
        :param value: the setting value

        |

        *Overload 7:*

        Write a setting with an arbitrary value type.
        :param Type: the data type of the value
        :type key: str
        :param key: the setting identifier
        :type value: int
        :param value: the setting value

        |

        *Overload 8:*

        Write an arbitrary channel setting on the device.
        :param Type: the data type of the value
        :type direction: int
        :param direction: the channel direction RX or TX
        :type channel: int
        :param channel: an available channel on the device
        :type key: str
        :param key: the setting identifier
        :type value: int
        :param value: the setting value
        """
        return _SoapySDR.Device_writeSetting(self, *args)

    def readSensorBool(self, *args):
        r"""
        *Overload 1:*

        Readback a global sensor given the name.
        :param Type: the return type for the sensor value
        :type key: str
        :param key: the ID name of an available sensor
        :rtype: bool
        :return: the current value of the sensor as the specified type

        |

        *Overload 2:*

        Readback a channel sensor given the name.
        :param Type: the return type for the sensor value
        :type direction: int
        :param direction: the channel direction RX or TX
        :type channel: int
        :param channel: an available channel on the device
        :type key: str
        :param key: the ID name of an available sensor
        :rtype: bool
        :return: the current value of the sensor as the specified type
        """
        return _SoapySDR.Device_readSensorBool(self, *args)

    def readSensorInt(self, *args):
        r"""
        *Overload 1:*

        Readback a global sensor given the name.
        :param Type: the return type for the sensor value
        :type key: str
        :param key: the ID name of an available sensor
        :rtype: int
        :return: the current value of the sensor as the specified type

        |

        *Overload 2:*

        Readback a channel sensor given the name.
        :param Type: the return type for the sensor value
        :type direction: int
        :param direction: the channel direction RX or TX
        :type channel: int
        :param channel: an available channel on the device
        :type key: str
        :param key: the ID name of an available sensor
        :rtype: int
        :return: the current value of the sensor as the specified type
        """
        return _SoapySDR.Device_readSensorInt(self, *args)

    def readSensorFloat(self, *args):
        r"""
        *Overload 1:*

        Readback a global sensor given the name.
        :param Type: the return type for the sensor value
        :type key: str
        :param key: the ID name of an available sensor
        :rtype: float
        :return: the current value of the sensor as the specified type

        |

        *Overload 2:*

        Readback a channel sensor given the name.
        :param Type: the return type for the sensor value
        :type direction: int
        :param direction: the channel direction RX or TX
        :type channel: int
        :param channel: an available channel on the device
        :type key: str
        :param key: the ID name of an available sensor
        :rtype: float
        :return: the current value of the sensor as the specified type
        """
        return _SoapySDR.Device_readSensorFloat(self, *args)

    def readSettingBool(self, *args):
        r"""
        *Overload 1:*

        Read an arbitrary setting on the device.
        :param Type: the return type for the sensor value
        :type key: str
        :param key: the setting identifier
        :rtype: bool
        :return: the setting value

        |

        *Overload 2:*

        Read an arbitrary channel setting on the device.
        :param Type: the return type for the sensor value
        :type direction: int
        :param direction: the channel direction RX or TX
        :type channel: int
        :param channel: an available channel on the device
        :type key: str
        :param key: the setting identifier
        :rtype: bool
        :return: the setting value
        """
        return _SoapySDR.Device_readSettingBool(self, *args)

    def readSettingInt(self, *args):
        r"""
        *Overload 1:*

        Read an arbitrary setting on the device.
        :param Type: the return type for the sensor value
        :type key: str
        :param key: the setting identifier
        :rtype: int
        :return: the setting value

        |

        *Overload 2:*

        Read an arbitrary channel setting on the device.
        :param Type: the return type for the sensor value
        :type direction: int
        :param direction: the channel direction RX or TX
        :type channel: int
        :param channel: an available channel on the device
        :type key: str
        :param key: the setting identifier
        :rtype: int
        :return: the setting value
        """
        return _SoapySDR.Device_readSettingInt(self, *args)

    def readSettingFloat(self, *args):
        r"""
        *Overload 1:*

        Read an arbitrary setting on the device.
        :param Type: the return type for the sensor value
        :type key: str
        :param key: the setting identifier
        :rtype: float
        :return: the setting value

        |

        *Overload 2:*

        Read an arbitrary channel setting on the device.
        :param Type: the return type for the sensor value
        :type direction: int
        :param direction: the channel direction RX or TX
        :type channel: int
        :param channel: an available channel on the device
        :type key: str
        :param key: the setting identifier
        :rtype: float
        :return: the setting value
        """
        return _SoapySDR.Device_readSettingFloat(self, *args)

    def __getNativeStreamFormat(self, direction, channel):
        return _SoapySDR.Device___getNativeStreamFormat(self, direction, channel)

    def __readStream(self, stream, buffs, numElems, flags, timeoutUs):
        return _SoapySDR.Device___readStream(self, stream, buffs, numElems, flags, timeoutUs)

    def __writeStream(self, stream, buffs, numElems, flags, timeNs, timeoutUs):
        return _SoapySDR.Device___writeStream(self, stream, buffs, numElems, flags, timeNs, timeoutUs)

    def __readStreamStatus(self, stream, timeoutUs):
        return _SoapySDR.Device___readStreamStatus(self, stream, timeoutUs)

            #manually unmake and flag for future calls and the deleter
    def close(self):
        try: getattr(self, '__closed__')
        except AttributeError: Device.unmake(self)
        setattr(self, '__closed__', True)

    def __del__(self): self.close()

    def __str__(self):
        return "%s:%s"%(self.getDriverKey(), self.getHardwareKey())

    def __repr__(self):
        return "%s:%s"%(self.getDriverKey(), self.getHardwareKey())

    def getNativeStreamFormat(self, direction, chan):
        r"""
        Get the hardware's native stream format for this channel.
        This is the format used by the underlying transport layer.
        :type direction: int
        :param direction: the channel direction RX or TX
        :type chan: an available channel on the device
        :rtype SoapySDR.NativeStreamFormat
        :returns the native stream format and max possible value
        """
        return self.__getNativeStreamFormat(direction, chan)

    def readStream(self, stream, buffs, numElems, flags = 0, timeoutUs = 100000):
        r"""
        Read elements from a stream for reception.
        :type stream: SoapySDR.Stream
        :param stream: SoapySDR stream handle
        :type buffs: numpy.ndarray
        :param buffs: a 2D NumPy array of the underlying stream type
        :type numElems: int
        :param numElems: the number of elements in each buffer
        :type timeoutUs: int
        :param timeoutUs: the timeout in microseconds
        :rtype: SoapySDR.StreamResult
        :returns the number of elements read per buffer, plus metadata
        """
        ptrs = [extractBuffPointer(b) for b in buffs]
        return self.__readStream(stream, ptrs, numElems, flags, timeoutUs)

    def writeStream(self, stream, buffs, numElems, flags = 0, timeNs = 0, timeoutUs = 100000):
        r"""
        Write elements to a stream for transmission.
        :type stream: SoapySDR.Stream
        :param stream: SoapySDR stream handle
        :type numElems: int
        :param numElems: the number of elements in each buffer
        :type flags: int
        :param flags: optional input flags
        :type timeNs: int
        :param timeNs: the buffer's timestamp in nanoseconds
        :type timeoutUs: int
        :param timeoutUs: the timeout in microseconds
        :rtype: SoapySDR.StreamResult
        :returns the number of elements written per buffer, plus metadata
        """
        ptrs = [extractBuffPointer(b) for b in buffs]
        return self.__writeStream(stream, ptrs, numElems, flags, timeNs, timeoutUs)

    def readStreamStatus(self, stream, timeoutUs = 100000):
        r"""
        Readback status information about a stream. This call
        is typically used on a transmit stream to report time
        errors, underflows, and burst completion.
        :type stream: SoapySDR.Stream
        :param stream: SoapySDR stream handle
        :type timeoutUs: int
        :param timeoutUs: the timeout in microseconds
        :rtype: SoapySDR.StreamResult
        :returns any stream errors, plus other metadata
        """
        return self.__readStreamStatus(stream, timeoutUs)


# Register Device in _SoapySDR:
_SoapySDR.Device_swigregister(Device)


__all__ = list()
for key in sorted(globals().keys()):
    if key.startswith('SOAPY_SDR_'):
        __all__.append(key)


class Device(Device):
    def __new__(cls, *args, **kwargs):
        return cls.make(*args, **kwargs)

def extractBuffPointer(buff):
    if hasattr(buff, '__array_interface__'): return buff.__array_interface__['data'][0]
    if hasattr(buff, 'buffer_info'): return buff.buffer_info()[0]
    if hasattr(buff, '__long__'): return long(buff)
    if hasattr(buff, '__int__'): return int(buff)
    raise Exception("Unrecognized data format: " + str(type(buff)))


